000100 IDENTIFICATION DIVISION.                                         
000200 PROGRAM-ID.  CSR04690.                                           
000300 DATE-WRITTEN.  11/28/13.                                         
000400 DATE-COMPILED.                                                   
000500                                                                  
000600******************************************************************00000600
000700*                                                                *00000700
000800*               SOUTH CAROLINA ELECTRIC & GAS                    *00000800
000900*----------------------------------------------------------------*00000900
001000*                STORED PROCEDURE:  CSR04690                     *00001000
001100******************************************************************00001100
001200*                 P R O G R A M  S U M M A R Y                   *00001200
001300*                                                                *00001300
001400*  CSR04690:                                                     *00001400
001500*                                                                *00001500
001600*  THIS PROCEDURE IS USED TO RETRIEVE DATA FROM THE BILLING      *00001600
001700*  HEADER, BILL CALC DETAILS AND CONSUMPTION HISTORY.            *00001700
001800*                                                                *00001800
001900*  CLONED FROM CSR02128.                                         *00001900
002000*                                                                *00002000
002100*  DB2 TABLES USED.                                              *00002100
002200*     1.CSS_BILLING_HDR                                          *00002200
002300*     2.CSS_BILLING_DET                                          *00002300
002400*     3.CSS_BILL_CALC_DET                                        *00002400
002500*     4.CSS_CNSMPTN_HIST                                         *00002500
P00836*     5.CSS_CODE_VALUE                                           *00002500
002600*                                                                *00002600
002700*----------------------------------------------------------------*00002700
002800*    PARAMETERS                                                  *00002800
002900*                                                                *00002900
003000*        INPUT                                                   *00003000
003100*               ACCOUNT_NO          DECIMAL(13,0)                *00003100
003200*               IC_NO               SMALLINT                     *00003200
P00836*               I_APPL_PROG_ID      CHAR(03)                     *00003200
003300*                                                                *00003300
003400*        OUT                                                     *00003400
003500*                                                                *00003500
003600*              NONE                                              *00003600
003700*                                                                *00003700
003800*        INOUT                                                   *00003800
003900*                                                                *00003900
004000*              NONE                                              *00004000
004100*                                                                *00004100
004200*    RESULT SET                                                  *00004200
004300*                                                                *00004300
004400*    CSR04690_R1 - BILL DETAILS                                  *00004400
004500*                                                                *00004500
004600*             RETURN_CODE         INTEGER                        *00004600
004700*            ,APPL_RETURN_CODE    INTEGER                        *00004700
004800*            ,BILL_DATE           CHAR(10)                       *00004800
004900*            ,READ_DATE           CHAR(10)                       *00004900
005000*            ,DAYS                SMALLINT                       *00005000
005100*            ,KWH_USED            INTEGER                        *00005100
005200*            ,ACTUAL_KW           INTEGER                        *00005200
005300*            ,ACTUAL_KVA          INTEGER                        *00005300
005400*            ,BILLED_KVA_KW       INTEGER                        *00005400
005500*            ,DEMAND_CALC_CODE    CHAR(1)                        *00005500
005600*            ,TOTAL_REVENUE       DECIMAL(11,2)                  *00005600
005700*            ,LOAD_FACTOR         DECIMAL(11,2)                  *00005700
005800*            ,POWER_FACTOR        DECIMAL(11,2)                  *00005800
005900*            ,AVG_CENTS_PER_KWH   DECIMAL(15,6)                  *00005900
006000*            ,ON_PEAK_KWH         INTEGER                        *00006000
006100*            ,OFF_PEAK_KWH        INTEGER                        *00006100
006200*            ,SHOULDER_KWH        INTEGER                        *00006200
006300*            ,ON_PEAK_KW          INTEGER                        *00006300
006400*            ,OFF_PEAK_KW         INTEGER                        *00006400
006500*            ,SHOULDER_KW         INTEGER                        *00006500
006600*            ,ON_PEAK_KVA         INTEGER                        *00006600
006700*            ,OFF_PEAK_KVA        INTEGER                        *00006700
006800*            ,SHOULDER_KVA        INTEGER                        *00006800
006900*            ,EMPL                INTEGER                        *00006900
007000*            ,EXCL_DMD_RCHT_IND   CHAR(1)                        *00007000
007100*            ,CODE_UTIL_TYPE      CHAR(1)                        *00007100
007200*            ,BILL_ITEM_TIMESTMP  CHAR(26)                       *00007200
007300*            ,BILL_NO             INTEGER                        *00007300
007400*            ,MTR_REF_NO          SMALLINT                       *00007400
007500*            ,REG_ID_NO           SMALLINT                       *00007500
007600*            ,CODE_TIME_PERIOD    SMALLINT                       *00007600
007700*            ,ITEM_SEQ_NO         SMALLINT                       *00007700
007800*                                                                *00007800
007900*    CSR04690_R2 - BUS RULE DETAILS                              *00007900
008000*                                                                *00008000
008100*             RETURN_CODE         INTEGER                        *00008100
008200*            ,APPL_RETURN_CODE    INTEGER                        *00008200
008300*            ,BUS_RULE_ID         CHAR(10)                       *00008300
008400*            ,BUS_RULE_RESULT_CD  CHAR(10)                       *00008400
008500*            ,BUS_RULE_XREF_ID    CHAR(26)                       *00008500
008600*                                                                *00008600
P00836*    CSR04690_R3 - FORMAT DETAILS                                *00007900
P00836*                                                                *00008000
P00836*             RETURN_CODE         INTEGER                        *00008100
P00836*            ,APPL_RETURN_CODE    INTEGER                        *00008200
P00836*            ,CODE_SHORT_DESC     CHAR(15)                       *00008200
P00836*                                                                *00008600
008700******************************************************************00008700
008800*                                                                *00008800
008900*                     PROGRAM MODIFICATION LOG                   *00008900
009000*                                                                *00009000
009100*    DATE    INITIALS   COMMENTS                                 *00009100
009200*  --------  --------   ---------------------------------------  *00009200
009300*  11/27/13   AD7F921   INITIAL VERSION.                         *00009300
P00836*  10/08/15   VK7L032   ADDED INPUT PARAMENTER APPL_PROGRAM_ID,  *00009300
P00836*                       ADDED THIRD RESULT SET TO GET THE SHORT  *        
P00836*                       DESCRIPTION FROM THE CODE VALUE TABLE    *        
P00836*                       USING RATE PLAN NUMBER.                  *        
WEBFIX*  03/09/17  GD43988    A05745:FIX WEB SORT ORDER ISSUE.         *        
009400******************************************************************00009400
009500*                                                                 00009500
009600 ENVIRONMENT DIVISION.                                            
009700 DATA DIVISION.                                                   
009800 WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04690'.
MSQ017     COPY MFASQLM.
009900*                                                                 00009900
010000 01 WS-START                   PIC X(40) VALUE                    
010100      'WORKING STORAGE FOR CSR04690 STARTS HERE'.                 
010200*                                                                 00010200
010300************************************************************      00010300
010400*    DB2 INCLUDES                                                 00010400
010500************************************************************      00010500
010600     EXEC SQL                                                     00010600
010700        INCLUDE SQLCA                                             00010700
010800     END-EXEC.                                                    00010800
010900                                                                  
011000******************************************************************00011000
011100*    BI - CSS_BILLING_HDR                                        *00011100
011200******************************************************************00011200
011300     EXEC SQL                                                     00011300
011400         INCLUDE TBBLLHDR                                         00011400
011500     END-EXEC.                                                    00011500
011600                                                                  
011700******************************************************************00011700
011800*    BG - CSS_BILLING_DET                                        *00011800
011900******************************************************************00011900
012000     EXEC SQL                                                     00012000
012100         INCLUDE TBBLLDET                                         00012100
012200     END-EXEC.                                                    00012200
012300                                                                  
012400******************************************************************00012400
012500*    BZ - CSS_BILL_CALC_DET                                      *00012500
012600******************************************************************00012600
012700     EXEC SQL                                                     00012700
012800         INCLUDE TBBLCLDT                                         00012800
012900     END-EXEC.                                                    00012900
013000                                                                  
013100******************************************************************00013100
013200*    CX - CSS_CNSMPTN_HIST                                       *00013200
013300******************************************************************00013300
013400     EXEC SQL                                                     00013400
013500         INCLUDE TBCNSMP                                          00013500
013600     END-EXEC.                                                    00013600
013700                                                                  
PRJ821*****************************************************************         
PRJ821*    CSS_RATE_PLAN_DESC  RD                                     *         
PRJ821*****************************************************************         
PRJ821     EXEC SQL                                                             
PRJ821         INCLUDE TBRTDESC                                                 
PRJ821     END-EXEC.                                                            
PRJ821                                                                  
P00836*****************************************************************         
P00836*    CSS_CODE_VALUE UV                                          *         
P00836*****************************************************************         
P00836     EXEC SQL                                                             
P00836         INCLUDE TBCDVALU                                                 
P00836     END-EXEC.                                                            
P00836                                                                  
P00836*****************************************************************         
P00836*    CSS_UTIL_ENVRNMT UT                                        *         
P00836*****************************************************************         
P00836     EXEC SQL                                                             
P00836         INCLUDE TBUTLENV                                                 
P00836     END-EXEC.                                                            
PRJ836*                                                                         
PRJ836*** CSS_ACCOUNT, AT                                                       
PRJ836*                                                                         
PRJ836     EXEC SQL                                                             
PRJ836         INCLUDE TBACCT                                                   
PRJ836     END-EXEC.                                                            
PRJ836                                                                  
PRJ836*                                                                         
PRJ836*** CSS_BILL_CRED_DET, 1H                                                 
PRJ836*                                                                         
PRJ836     EXEC SQL                                                             
PRJ836       INCLUDE TBCRBLDL                                                   
PRJ836     END-EXEC.                                                            
PRJ836*                                                                         
PRJ836*** CSS_WQ_ITEMS, WQ                                                      
PRJ836*                                                                         
PRJ836     EXEC SQL                                                             
PRJ836         INCLUDE TBWQITS                                                  
PRJ836     END-EXEC.                                                            
PRJ836*                                                                         
PRJ836*** CSS_WQ_CATEGORY, C3                                                   
PRJ836*                                                                         
PRJ836     EXEC SQL                                                             
PRJ836         INCLUDE TBWQCAT                                                  
PRJ836     END-EXEC.                                                            
PRJ836*                                                                         
013800******************************************************************00013800
013900*    COMMON COPYLIBS                                             *00013900
014000******************************************************************00014000
014100                                                                  
014200     EXEC SQL                                                     00014200
014300          INCLUDE CWSX0010                                        00014300
014400     END-EXEC.                                                    00014400
014500                                                                  
014600******************************************************************00014600
014700* -- SUPPORTS DB2 AND SQL ERROR CHECKING                          00014700
014800******************************************************************00014800
014900     COPY CWS00303.                                               00014900
015000                                                                  
015100******************************************************************00015100
015200*    WORK AREAS                                                  *00015200
015300******************************************************************00015300
015400*                                                                 00015400
015500 01  GTT-MISC-FIELDS.                                             
015600      05  WS-GTT-NAME                 PIC X(26)                   
015700                                                VALUE SPACES.     
015800                                                                  
015900      05  GTT-ROW.                                                
016000          49 GTT-ROW-LEN              PIC S9(04) COMP.            
016100          49 GTT-ROW-CHAR             PIC X(1024).                
016200      05  GTT-SQLCODE                 PIC S9(9) COMP.             
016300                                                                  
016400                                                                  
016500******************************************************************00016500
016600*    INPUT PARAMETERS                                            *00016600
016700******************************************************************00016700
016800                                                                  
016900 01  SNA-FIELDS.                                                  
017000     05  SNA-SUBC                     PIC S9(9) COMP.             
017100     05  SNA-CONNECTION-NAME          PIC X(8)  VALUE SPACE.      
017200                                                                  
017300 01  COUNTER-FIELDS.                                              
017400     05  CTR-COLUMN                   PIC S9(9) COMP VALUE 1.     
017500     05  CTR-ROWS-RS1                 PIC S9(9) COMP VALUE 0.     
017600     05  CTR-ROWS-RS2                 PIC S9(9) COMP VALUE 0.     
P00836     05  CTR-ROWS-RS3                 PIC S9(9) COMP VALUE 0.     
PRJ836     05  CTR-ROWS-RS4                 PIC S9(9) COMP VALUE 0.     
017700                                                                  
017800 01  WORK-FIELDS.                                                 
017900     05  MAX-LENGTH-PARM              PIC S9(9) COMP.             
018000     05  WRKLEN1                      PIC S9(9) COMP.             
018100     05  WRKLEN2                      PIC S9(9) COMP.             
018200     05  WRK-DONE-STATUS              PIC S9(9) COMP.             
018300                                                                  
018400******************************************************************00018400
018500*    RESULT SET FIELDS                                           *00018500
018600******************************************************************00018600
018700                                                                  
018800 01  TDS-RETURN-FIELDS.                                           
018900     05  RS-RETURN-CODE               PIC S9(04) COMP VALUE 0.    
018910     05  RS-APPL-RETURN-CODE          PIC S9(04) COMP VALUE 0.    
019000     05  RS-BILL-DATE                 PIC X(10).                  
019100     05  RS-READ-DATE                 PIC X(10).                  
019200     05  RS-DAYS                      PIC S9(4) COMP.             
019300     05  RS-KWH-USED                  PIC S9(9) COMP.             
019400     05  RS-ACTUAL-KW                 PIC S9(9) COMP.             
019500     05  RS-ACTUAL-KVA                PIC S9(9) COMP.             
019600     05  RS-BILLED-KVA-KW             PIC S9(9) COMP.             
019700     05  RS-DEMAND-CALC-CODE          PIC X(1).                   
COB305     05 RS-TOTAL-REVENUE        PIC S9(9)V99 COMP-3 VALUE 0.        
COB305     05 RS-LOAD-FACTOR        PIC S9(9)V99 COMP-3 VALUE 0.        
COB305     05 RS-POWER-FACTOR        PIC S9(9)V99 COMP-3 VALUE 0.        
COB305     05 RS-AVG-CENTS-PER-KWH        PIC S9(9)V999999 COMP-3 
COB305       VALUE 0.    
020200     05  RS-ON-PEAK-KWH               PIC S9(9) COMP              
020300                                          VALUE 0.                
020400     05  RS-OFF-PEAK-KWH              PIC S9(9) COMP              
020500                                          VALUE 0.                
020600     05  RS-SHOULDER-KWH              PIC S9(9) COMP              
020700                                          VALUE 0.                
020800     05  RS-ON-PEAK-KW                PIC S9(9) COMP.             
020900     05  RS-OFF-PEAK-KW               PIC S9(9) COMP.             
021000     05  RS-SHOULDER-KW               PIC S9(9) COMP.             
021100     05  RS-ON-PEAK-KVA               PIC S9(9) COMP.             
021200     05  RS-OFF-PEAK-KVA              PIC S9(9) COMP.             
021300     05  RS-SHOULDER-KVA              PIC S9(9) COMP.             
021400     05  RS-EMPLOYEE-NO               PIC S9(9) USAGE COMP.       
021500     05  RS-EXCL-DMD-RCHT-IND         PIC X(1).                   
021600     05  RS-CODE-UTIL-TYPE            PIC X(1).                   
021700     05  RS-BILL-ITEM-TIMESTMP        PIC X(26).                  
021800     05  RS-BILL-NO                   PIC S9(9) USAGE COMP.       
021900     05  RS-MTR-REF-NO                PIC S9(4) COMP.             
022000     05  RS-REG-ID-NO                 PIC S9(4) COMP.             
022100     05  RS-CODE-TIME-PERIOD          PIC S9(4) COMP.             
022200     05  RS-ITEM-SEQ-NO               PIC S9(4) COMP.             
PRJ821     05  RS-RATE-PLAN-NO              PIC X(03) VALUE SPACES.     
PRJ821     05  RS-RATE-PLAN-DESC            PIC X(50) VALUE SPACES.     
PRJ836     05  RS-CODE-BILL-CALC        PIC X(01) VALUE SPACES.         
PRJ836     05  RS-CODE-BILL-ITM-TYPE    PIC X(01) VALUE SPACES.         
PRJ836     05  RS-CODE-BILL-ITM-IND     PIC X(01) VALUE SPACES.         
PRJ836     05  RS-CODE-DR-CR-CNSMPTN    PIC X(01) VALUE SPACES.         
PRJ836     05  RS-AMT-STATE-TAX         PIC S9(7)V9(2) COMP-3 VALUE 0.  
PRJ836     05  RS-AMT-CITY-TAX          PIC S9(7)V9(2) COMP-3 VALUE 0.  
PRJ836     05  RS-AMT-OTHER-TAX         PIC S9(7)V9(2) COMP-3 VALUE 0.  
PRJ836     05  RS-REVENUE-MONTH         PIC S9(6)V     COMP-3 VALUE 0.  
PRJ836     05  RS-REV-MTH-ORIG-BILL     PIC S9(6)V     COMP-3 VALUE 0.  
PRJ836     05  RS-CODE-BILL-TYPE        PIC X(01) VALUE SPACES.         
022300                                                                  
022400 01  GTT-RETURN-FIELDS.                                           
022500*********************************************************         00022500
022600*   GTT TABLE LAYOUT FOR ICP CSS_UTIL_ENVRNMT           *         00022600
022700*********************************************************         00022700
022800     05 S-RETURN-CODE                   PIC S9(04) COMP VALUE 0.  
022900     05 GTT-RETURN-FIELDS-1.                                      
023000        10  S-RETURN-CODE-1             PIC S9(04) COMP VALUE 0.  
023100        10  S-APPL-RETURN-CODE-1        PIC S9(04) COMP VALUE 0.  
023200        10  S-BILL-DATE                 PIC X(10).                
023300        10  S-READ-DATE                 PIC X(10).                
023400        10  S-DAYS                      PIC S9(4) COMP.           
023500        10  S-KWH-USED                  PIC S9(9) COMP.           
023600        10  S-ACTUAL-KW                 PIC S9(9) COMP.           
023700        10  S-ACTUAL-KVA                PIC S9(9) COMP.           
023800        10  S-BILLED-KVA-KW             PIC S9(9) COMP.           
023900        10  S-DEMAND-CALC-CODE          PIC X(1).                 
COB305        10 S-TOTAL-REVENUE        PIC S9(9)V99 COMP-3 VALUE 0.      
COB305        10 S-LOAD-FACTOR        PIC S9(9)V99 COMP-3 VALUE 0.      
COB305        10 S-POWER-FACTOR        PIC S9(9)V99 COMP-3 VALUE 0.      
COB305        10 S-AVG-CENTS-PER-KWH        PIC S9(9)V999999 COMP-3 
COB305           VALUE 0.  
024400        10  S-ON-PEAK-KWH               PIC S9(9) COMP            
024500                                             VALUE 0.             
024600        10  S-OFF-PEAK-KWH              PIC S9(9) COMP            
024700                                             VALUE 0.             
024800        10  S-SHOULDER-KWH              PIC S9(9) COMP            
024900                                             VALUE 0.             
025000        10  S-ON-PEAK-KW                PIC S9(9) COMP.           
025100        10  S-OFF-PEAK-KW               PIC S9(9) COMP.           
025200        10  S-SHOULDER-KW               PIC S9(9) COMP.           
025300        10  S-ON-PEAK-KVA               PIC S9(9) COMP.           
025400        10  S-OFF-PEAK-KVA              PIC S9(9) COMP.           
025500        10  S-SHOULDER-KVA              PIC S9(9) COMP.           
025600        10  S-EMPLOYEE-NO               PIC S9(9) USAGE COMP.     
025700        10  S-EXCL-DMD-RCHT-IND         PIC X(1).                 
025800        10  S-CODE-UTIL-TYPE            PIC X(1).                 
025900        10  S-BILL-ITEM-TIMESTMP        PIC X(26).                
026000        10  S-BILL-NO                   PIC S9(9) USAGE COMP.     
026100        10  S-MTR-REF-NO                PIC S9(4) COMP.           
026200        10  S-REG-ID-NO                 PIC S9(4) COMP.           
026300        10  S-CODE-TIME-PERIOD          PIC S9(4) COMP.           
026400        10  S-ITEM-SEQ-NO               PIC S9(4) COMP.           
PRJ821        10  S-RATE-PLAN-NO              PIC X(03) VALUE SPACES.   
PRJ821        10  S-RATE-PLAN-DESC            PIC X(50) VALUE SPACES.   
PRJ836        10  S-CODE-BILL-CALC      PIC X(01) VALUE SPACES.         
PRJ836        10  S-CODE-BILL-ITM-TYPE  PIC X(01) VALUE SPACES.         
PRJ836        10  S-CODE-BILL-ITM-IND   PIC X(01) VALUE SPACES.         
PRJ836        10  S-CODE-DR-CR-CNSMPTN  PIC X(01) VALUE SPACES.         
PRJ836        10  S-AMT-STATE-TAX       PIC S9(7)V9(2) COMP-3 VALUE 0.  
PRJ836        10  S-AMT-CITY-TAX        PIC S9(7)V9(2) COMP-3 VALUE 0.  
PRJ836        10  S-AMT-OTHER-TAX       PIC S9(7)V9(2) COMP-3 VALUE 0.  
PRJ836        10  S-REVENUE-MONTH       PIC S9(6)V     COMP-3 VALUE 0.  
PRJ836        10  S-REV-MTH-ORIG-BILL   PIC S9(6)V     COMP-3 VALUE 0.  
PRJ836        10  S-CODE-BILL-TYPE      PIC X(01) VALUE SPACES.         
026500*********************************************************         00026500
026600*   GTT TABLE LAYOUT FOR BUS RULE ERROR MESSAGE        *          00026600
026700*********************************************************         00026700
026800     05 GTT-RETURN-FIELDS-2.                                      
026900        10 S-RETURN-CODE-2             PIC S9(04) COMP VALUE 0.   
027000        10 S-APPL-RETURN-CODE-2        PIC S9(04) COMP VALUE 0.   
027100        10 S-RS2-BUS-RULE-ID           PIC X(10)  VALUE SPACES.   
027200        10 S-RS2-BUS-RULE-RESULT-CD    PIC X(10)  VALUE SPACES.   
027300        10 S-RS2-BUS-RULE-XREF-ID      PIC X(26)  VALUE SPACES.   
P00836*********************************************************         00026500
P00836*   GTT TABLE LAYOUT FOR FORMAT DETAILS                *          00026600
P00836*********************************************************         00026700
P00836     05 GTT-RETURN-FIELDS-3.                                      
P00836        10 S-RETURN-CODE-3             PIC S9(04) COMP VALUE 0.   
P00836        10 S-APPL-RETURN-CODE-3        PIC S9(04) COMP VALUE 0.   
P00836        10 S-CODE-SHORT-DESC           PIC X(15)  VALUE SPACES.   
027400                                                                  
027500                                                                  
027600 01  SWITCHES.                                                    
027700     05  ALL-DONE-SW                  PIC X VALUE 'N'.            
027800         88  NOT-ALL-DONE             VALUE 'N'.                  
027900         88  ALL-DONE                 VALUE 'Y'.                  
028000     05  SEND-DONE-SW                 PIC X VALUE 'Y'.            
028100         88  SEND-DONE-ERROR          VALUE 'N'.                  
028200         88  SEND-DONE-OK             VALUE 'Y'.                  
028300     05  WS-LOAD-FACTOR-SW            PIC X VALUE 'N'.            
028400         88  INVALID-LOAD-FACTOR      VALUE 'Y'.                  
028500                                                                  
028600 01  WS-MISC-FIELDS.                                              
P00836     05  WS-APPL-PROGRAM-ID           PIC X(03) VALUE SPACES.     
028700     05  WS-APPL-RETURN-CODE          PIC S9(04) COMP VALUE 0.    
COB305     05 WS-ACCT-NO        PIC S9(13) COMP-3 VALUE 0.          
028900     05  WS-KVAR-UNITS                PIC S9(09) COMP.            
029000     05  WS-HOLD-MTR-REF-NO           PIC S9(4) COMP.             
029100     05  WS-PREV-MTR-REF-NO-0         PIC S9(4) COMP.             
029200     05  WS-PREV-MTR-REF-NO-1         PIC S9(4) COMP.             
029300     05  WS-PREV-MTR-REF-NO-2         PIC S9(4) COMP.             
029400     05  WS-PREV-MTR-REF-NO-3         PIC S9(4) COMP.             
029500     05  WS-PREV-METER-NO             PIC X(9).                   
029600     05  WS-PREV-USAGE-TYPE           PIC X(01) VALUE SPACES.     
PRJ821     05  WS-PREV-RATE-PLAN-NO         PIC X(03) VALUE SPACES.     
029700     05  WS-MTR-REF-NO                PIC S9(4) COMP.             
029800     05  WS-HOLD-DATE                 PIC X(10).                  
029900     05  WS-DEMAND-ACCUM              PIC S9(11) COMP.            
030000     05  WS-ACTUAL-KVA                PIC S9(9) COMP.             
030100     05  WS-ACTUAL-KW                 PIC S9(9) COMP.             
030200     05  WS-HOLD-ACTUAL-KVA           PIC S9(9) COMP.             
030300     05  WS-HOLD-ACTUAL-KW            PIC S9(9) COMP.             
030400     05  WS-NULL-IND                  PIC S9(4) COMP.             
030500     05  WS-NULL-IND-1                PIC S9(4) COMP.             
030600     05  WS-BILL-UNITS-NI             PIC S9(4) COMP.             
030700     05  WS-READ-UNITS-NI             PIC S9(4) COMP.             
030800     05  WS-BILL-COMP-NI              PIC S9(4) COMP.             
030900     05  WS-NO-UNITS-NI               PIC S9(4) COMP.             
COB305     05 WS-NO-UNITS        PIC S9(9)V USAGE COMP-3 VALUE 0.    
031100     05  WS-BILL-ITEM-TIMESTMP        PIC X(026) VALUE  SPACES.   
031200     05  WS-IC-NO                     PIC S9(4) COMP.             
031300     05  PROGRAM-NAME                 PIC X(08) VALUE 'CSR04690'. 
031400     05  WS-SQLSTATE                  PIC X(05) VALUE SPACES.     
031410     05  WS-FAILED                    PIC X(01)  VALUE 'F'.       
031410     05  WS-ACTIVE-RETURN-CD-BI       PIC S9(9) COMP VALUE 0.     
031410     05  WS-ACTIVE-RETURN-CD-BZ       PIC S9(9) COMP VALUE 0.     
031410     05  WS-ACTIVE-RETURN-CD-CX       PIC S9(9) COMP VALUE 0.     
031410     05  WS-ACTIVE-RETURN-CD-DMD      PIC S9(9) COMP VALUE 0.     
PRJ836     05  WS-SHOW-LATEST-BILL-FL       PIC X(01) VALUE 'Y'.        
PRJ836     05  WS-WEB-REV-MTH-LATEST        PIC S9(6)V COMP-3 VALUE 0.  
031500*                                                                 00031500
031600 01  WS-ERR-FLAGS.                                                
031700     05  WS-ERR-INSRT-R1          PIC X(01) VALUE 'N'.            
031800     05  WS-ERR-INSRT-R2          PIC X(01) VALUE 'N'.            
P00836     05  WS-ERR-INSRT-R3          PIC X(01) VALUE 'N'.            
031900     05  WS-YES                   PIC X(01) VALUE 'Y'.            
031900     05  WS-NO                    PIC X(01) VALUE 'N'.            
032000     05  WS-ZERO                  PIC S9(9) COMP VALUE 0.         
032100*                                                                 00032100
032200 01  CSRERLOG-P.                                                  
032300      10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
032400      10  S-SQLCODE               PIC S9(9) COMP VALUE 0.         
032500      10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
032600      10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
032700      10  S-HOST-VARIABLES.                                       
032800          49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.           
032900          49  S-HOST-VARIABLES-V  PIC X(255).                     
033000      10  S-SQL-STATEMENT.                                        
033100          49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.           
033200          49  S-SQL-STATEMENT-V   PIC X(255).                     
033300      10  S-SQL-DESCRIPTION.                                      
033400          49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.           
033500          49  S-SQL-DESCRIPTION-V PIC X(255).                     
033600      10  WS-ABEND-SQLERRMC.                                      
033700          49  WS-ABEND-SQLERRMC-L PIC S9(4) USAGE COMP.           
033800          49  WS-ABEND-SQLERRMC-V PIC X(255).                     
HPCCDM*    EJECT                                                        00033900
034000                                                                  
035900******************************************************************00035900
036000*    BZ-CURSOR USED TO RETRIEVE KWH, KVA, KW RELATED DATA FOR    *00036000
036100*    EVERY BILL NO PRESENT IN THE BI CURSOR.                     *00036100
036200******************************************************************00036200
036300     EXEC SQL                                                     
036400         DECLARE BZ-CURSOR CURSOR FOR                             
036500             SELECT REPLACE(REPLACE(CONVERT(CHAR(26), 
           BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP,                           
036600                    CODE_TIME_PERIOD,                             
036700                    CODE_SEASON,                                  
036800                    READ_UNITS,                                   
036900                    BILL_UNITS,                                   
037000                    CONSUMPT_TYPE_CD,                             
037100                    NET_UNIT_SEL_RSN,                             
037200                    BILLED_COMP_AM                                
037300               FROM CSS_BILL_CALC_DET                             
037400              WHERE ACCOUNT_NO         = :WS-ACCT-NO              
037500                AND CODE_UTIL_TYPE     = 'E'                      
037600                AND BILL_NO            = :BI-BILL-NO              
037700                AND IC_NO              = :WS-IC-NO                
037800                AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :WS-BILL-ITEM-TIMESTMP
              )   
037900                AND CMPNT_ID_CD NOT IN ('92','93')                
038000           ORDER BY BILL_ITEM_TIMESTMP DESC                       
038100                                                      
038200     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     00036300
MFA-TR*        DECLARE BZ-CURSOR CURSOR FOR                             00036400
MFA-TR*            SELECT BILL_ITEM_TIMESTMP,                           00036500
MFA-TR*                   CODE_TIME_PERIOD,                             00036600
MFA-TR*                   CODE_SEASON,                                  00036700
MFA-TR*                   READ_UNITS,                                   00036800
MFA-TR*                   BILL_UNITS,                                   00036900
MFA-TR*                   CONSUMPT_TYPE_CD,                             00037000
MFA-TR*                   NET_UNIT_SEL_RSN,                             00037100
MFA-TR*                   BILLED_COMP_AM                                00037200
MFA-TR*              FROM CSS_BILL_CALC_DET                             00037300
MFA-TR*             WHERE ACCOUNT_NO         = :WS-ACCT-NO              00037400
MFA-TR*               AND CODE_UTIL_TYPE     = 'E'                      00037500
MFA-TR*               AND BILL_NO            = :BI-BILL-NO              00037600
MFA-TR*               AND IC_NO              = :WS-IC-NO                00037700
MFA-TR*               AND BILL_ITEM_TIMESTMP = :WS-BILL-ITEM-TIMESTMP   00037800
MFA-TR*               AND CMPNT_ID_CD NOT IN ('92','93')                00037900
MFA-TR*          ORDER BY BILL_ITEM_TIMESTMP DESC                       00038000
MFA-TR*          QUERYNO 7220                                           00038100
MFA-TR*    END-EXEC.                                                    00038200
HPCCDM*    EJECT                                                        00038300
038400******************************************************************00038400
038500*   CX-CURSOR USED TO RETRIEVE KVAR METER UNITS FOR EVERY IC     *00038500
038600*   IN THE BZ CURSOR.                                            *00038600
038700******************************************************************00038700
038800     EXEC SQL                                                     
038900         DECLARE CX-CURSOR CURSOR FOR                             
039000             SELECT MTR_REF_NO,                                   
039100                    CODE_TIME_PERIOD,                             
039200                    CODE_USAGE_TYPE,                              
039300                    DATE_READ,                                    
039400                    CIS.CHAR2$DATE(DATE_READ,'USA'),                      
039500                    METER_NO,                                     
039600                    NO_UNITS,                                     
039700                    NO_DAYS,                                      
039800                    NO_DEMAND_UNITS,                              
039900                    EMPLOYEE_NO,                                  
040000                    EXCL_DMD_RCHT_IND,                            
040100                    CODE_UTIL_TYPE,                               
040200                    REPLACE(REPLACE(CONVERT(CHAR(26), 
           BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP,                           
040300                    BILL_NO,                                      
040400                    MTR_REF_NO MSQ056A15,                                 
040500                    REG_ID_NO,                                    
040600                    CODE_TIME_PERIOD,                             
040700                    ITEM_SEQ_NO                                   
040800               FROM CSS_CNSMPTN_HIST                              
040900              WHERE ACCOUNT_NO         = :WS-ACCT-NO              
041000                AND CODE_UTIL_TYPE     = 'E'                      
041100                AND BILL_NO            = :BI-BILL-NO              
041200                AND IC_NO              = :WS-IC-NO                
041300                AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :WS-BILL-ITEM-TIMESTMP
              )   
041400                AND CODE_USAGE_TYPE IN ('B','E','J')              
041500                AND CODE_USAGE_ID IN ('A','F')                    
041600                AND CODE_USAGE_SOURCE IN ('B','C')                
041700           ORDER BY CODE_USAGE_TYPE ASC,                          
041800                    MTR_REF_NO      ASC                           
041900                                                      
042000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ056
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     00038800
MFA-TR*        DECLARE CX-CURSOR CURSOR FOR                             00038900
MFA-TR*            SELECT MTR_REF_NO,                                   00039000
MFA-TR*                   CODE_TIME_PERIOD,                             00039100
MFA-TR*                   CODE_USAGE_TYPE,                              00039200
MFA-TR*                   DATE_READ,                                    00039300
MFA-TR*                   CHAR(DATE_READ,USA),                          00039400
MFA-TR*                   METER_NO,                                     00039500
MFA-TR*                   NO_UNITS,                                     00039600
MFA-TR*                   NO_DAYS,                                      00039700
MFA-TR*                   NO_DEMAND_UNITS,                              00039800
MFA-TR*                   EMPLOYEE_NO,                                  00039900
MFA-TR*                   EXCL_DMD_RCHT_IND,                            00040000
MFA-TR*                   CODE_UTIL_TYPE,                               00040100
MFA-TR*                   BILL_ITEM_TIMESTMP,                           00040200
MFA-TR*                   BILL_NO,                                      00040300
MFA-TR*                   MTR_REF_NO,                                   00040400
MFA-TR*                   REG_ID_NO,                                    00040500
MFA-TR*                   CODE_TIME_PERIOD,                             00040600
MFA-TR*                   ITEM_SEQ_NO                                   00040700
MFA-TR*              FROM CSS_CNSMPTN_HIST                              00040800
MFA-TR*             WHERE ACCOUNT_NO         = :WS-ACCT-NO              00040900
MFA-TR*               AND CODE_UTIL_TYPE     = 'E'                      00041000
MFA-TR*               AND BILL_NO            = :BI-BILL-NO              00041100
MFA-TR*               AND IC_NO              = :WS-IC-NO                00041200
MFA-TR*               AND BILL_ITEM_TIMESTMP = :WS-BILL-ITEM-TIMESTMP   00041300
MFA-TR*               AND CODE_USAGE_TYPE IN ('B','E','J')              00041400
MFA-TR*               AND CODE_USAGE_ID IN ('A','F')                    00041500
MFA-TR*               AND CODE_USAGE_SOURCE IN ('B','C')                00041600
MFA-TR*          ORDER BY CODE_USAGE_TYPE ASC,                          00041700
MFA-TR*                   MTR_REF_NO      ASC                           00041800
MFA-TR*          QUERYNO 7320                                           00041900
MFA-TR*    END-EXEC.                                                    00042000
042100******************************************************************00042100
042200*   DEMAND-CURSOR USED TO DETERMINE IF WE HAVE A METER WITHOUT   *00042200
042300*   A DEMAND READING.                                            *00042300
042400******************************************************************00042400
042500     EXEC SQL                                                     
042600         DECLARE DEMAND-CURSOR CURSOR FOR                         
042700             SELECT MTR_REF_NO,                                   
042800                    CODE_USAGE_TYPE,                              
042900                    NO_DEMAND_UNITS                               
043000               FROM CSS_CNSMPTN_HIST                              
043100              WHERE ACCOUNT_NO         = :WS-ACCT-NO              
043200                AND CODE_UTIL_TYPE     = 'E'                      
043300                AND BILL_NO            = :BI-BILL-NO              
043400                AND IC_NO              = :WS-IC-NO                
043500                AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :WS-BILL-ITEM-TIMESTMP
              )   
043600                AND CODE_USAGE_ID NOT IN ('1','2','3','4',        
043700                                         '5','6','7','8','9')     
043800           ORDER BY MTR_REF_NO ASC,                               
043900                    CODE_USAGE_TYPE ASC                           
044000                                                      
044100     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     00042500
MFA-TR*        DECLARE DEMAND-CURSOR CURSOR FOR                         00042600
MFA-TR*            SELECT MTR_REF_NO,                                   00042700
MFA-TR*                   CODE_USAGE_TYPE,                              00042800
MFA-TR*                   NO_DEMAND_UNITS                               00042900
MFA-TR*              FROM CSS_CNSMPTN_HIST                              00043000
MFA-TR*             WHERE ACCOUNT_NO         = :WS-ACCT-NO              00043100
MFA-TR*               AND CODE_UTIL_TYPE     = 'E'                      00043200
MFA-TR*               AND BILL_NO            = :BI-BILL-NO              00043300
MFA-TR*               AND IC_NO              = :WS-IC-NO                00043400
MFA-TR*               AND BILL_ITEM_TIMESTMP = :WS-BILL-ITEM-TIMESTMP   00043500
MFA-TR*               AND CODE_USAGE_ID NOT IN ('1','2','3','4',        00043600
MFA-TR*                                        '5','6','7','8','9')     00043700
MFA-TR*          ORDER BY MTR_REF_NO ASC,                               00043800
MFA-TR*                   CODE_USAGE_TYPE ASC                           00043900
MFA-TR*          QUERYNO 7316                                           00044000
MFA-TR*    END-EXEC.                                                    00044100
044200*                                                                 00044200
044300******************************************************************00044300
044400*    LINKAGE SECTION                                             *00044400
044500******************************************************************00044500
044600 LINKAGE SECTION.                                                 
COB305 01 PARM-ACCT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.       
044800 01  PARM-IC-NO                   PIC S9(04) COMP.                
P00836 01  PARM-APPL-PROGRAM-ID         PIC X(03).                      
044900*                                                                 00044900
HPCCDM*    EJECT                                                        00045000
045100******************************************************************00045100
045200*    BI-CURSOR USED AS MAIN CONTROL LOOP.                        *00045200
045300******************************************************************00045300
045400     EXEC SQL                                                     
045500         DECLARE BI-CURSOR CURSOR FOR                             
045600             SELECT BI.BILL_NO,                                   
045700                    BI.DATE_BILLED,                               
045800                    CIS.CHAR2$DATE(BI.DATE_BILLED,'USA'),                 
PRJ836                    BI.CODE_BILL_TYPE,                            
045900                    REPLACE(REPLACE(CONVERT(CHAR(26), 
           BG.BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP,                        
046100                    BG.AMT_BILL_ITEM -                            
046200                    BG.AMT_STATE_TAX -                            
046300                    BG.AMT_CITY_TAX  -                            
046400                    BG.AMT_OTHER_TAX,                             
046500                    BG.CODE_BILL_CALC,                            
046600                    BG.CODE_BILL_ITM_TYPE,                        
PRJ836                    BG.CODE_BILL_ITM_IND,                         
PRJ821                    BG.CODE_DR_CR_CNSMPTN,                        
PRJ821                    BG.RATE_PLAN_NO,                              
PRJ836                    BG.CODE_UTIL_TYPE,                            
PRJ836                    BG.REVENUE_MONTH,                             
PRJ836                    BG.REV_MTH_ORIG_BILL,                         
PRJ836                    BG.AMT_STATE_TAX,                             
PRJ836                    BG.AMT_CITY_TAX,                              
PRJ836                    BG.AMT_OTHER_TAX                              
046800               FROM CSS_BILLING_HDR BI                            
046900                   ,CSS_BILLING_DET BG                            
047000              WHERE BI.ACCOUNT_NO        = :WS-ACCT-NO            
047100                AND BI.ACCOUNT_NO        = BG.ACCOUNT_NO          
047200                AND BI.BILL_NO           = BG.BILL_NO             
047300                AND BG.IC_NO             = :WS-IC-NO              
047400                AND DATE_BILLED          IS NOT NULL              
047500                AND BG.CODE_UTIL_TYPE    = 'E'                    
047600           ORDER BY BILL_NO DESC                                  
047700                   ,BILL_ITEM_TIMESTMP DESC                       
047800                                                      
047900     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ029
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     00045400
MFA-TR*        DECLARE BI-CURSOR CURSOR FOR                             00045500
MFA-TR*            SELECT BI.BILL_NO,                                   00045600
MFA-TR*                   BI.DATE_BILLED,                               00045700
MFA-TR*                   CHAR(BI.DATE_BILLED,USA),                     00045800
MFA-TR*                   BI.CODE_BILL_TYPE,                                    
MFA-TR*                   BG.BILL_ITEM_TIMESTMP,                        00045900
MFA-TR*                   BG.AMT_BILL_ITEM -                            00046100
MFA-TR*                   BG.AMT_STATE_TAX -                            00046200
MFA-TR*                   BG.AMT_CITY_TAX  -                            00046300
MFA-TR*                   BG.AMT_OTHER_TAX,                             00046400
MFA-TR*                   BG.CODE_BILL_CALC,                            00046500
MFA-TR*                   BG.CODE_BILL_ITM_TYPE,                        00046600
MFA-TR*                   BG.CODE_BILL_ITM_IND,                                 
MFA-TR*                   BG.CODE_DR_CR_CNSMPTN,                        00046700
MFA-TR*                   BG.RATE_PLAN_NO,                              00046700
MFA-TR*                   BG.CODE_UTIL_TYPE,                            00046700
MFA-TR*                   BG.REVENUE_MONTH,                             00046700
MFA-TR*                   BG.REV_MTH_ORIG_BILL,                         00046700
MFA-TR*                   BG.AMT_STATE_TAX,                             00046700
MFA-TR*                   BG.AMT_CITY_TAX,                              00046700
MFA-TR*                   BG.AMT_OTHER_TAX                              00046700
MFA-TR*              FROM CSS_BILLING_HDR BI                            00046800
MFA-TR*                  ,CSS_BILLING_DET BG                            00046900
MFA-TR*             WHERE BI.ACCOUNT_NO        = :WS-ACCT-NO            00047000
MFA-TR*               AND BI.ACCOUNT_NO        = BG.ACCOUNT_NO          00047100
MFA-TR*               AND BI.BILL_NO           = BG.BILL_NO             00047200
MFA-TR*               AND BG.IC_NO             = :WS-IC-NO              00047300
MFA-TR*               AND DATE_BILLED          IS NOT NULL              00047400
MFA-TR*               AND BG.CODE_UTIL_TYPE    = 'E'                    00047500
MFA-TR*          ORDER BY BILL_NO DESC                                  00047600
MFA-TR*                  ,BILL_ITEM_TIMESTMP DESC                       00047700
MFA-TR*          QUERYNO 7120                                           00047800
MFA-TR*    END-EXEC.                                                    00047900
HPCCDM*    EJECT                                                        00048000
048100*                                                                 00048100
048200 PROCEDURE DIVISION USING PARM-ACCT-NO                            
048300                          PARM-IC-NO                              
P00836                          PARM-APPL-PROGRAM-ID.                   
048400                                                                  
048500******************************************************************00048500
048600* 0000-MAINLINE                                                  *00048600
048700*     CONTROLS THE MAIN PATH OF THE PROGRAM                      *00048700
048800******************************************************************00048800
048900                                                                  
049000 0000-MAINLINE.                                                   
049100                                                                  
049200     PERFORM 0100-INITIALIZE               THRU 0100-EXIT.        
049300     PERFORM 1000-PROCESS-INPUT            THRU 1000-EXIT.        
049400     PERFORM 2000-PROCESS-OUTPUT           THRU 2000-EXIT.        
049500     PERFORM 9999-END-PROGRAM              THRU 9999-EXIT.        
049600                                                                  
049700 0000-EXIT.                                                       
049800     EXIT.                                                        
HPCCDM*    EJECT                                                        00049900
050000******************************************************************00050000
050100*                                                                *00050100
050200* 0100-INITIALIZE                                                *00050200
050300*                                                                *00050300
050400******************************************************************00050400
050500                                                                  
050600 0100-INITIALIZE.                                                 
050700                                                                  
050800     EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
050900     EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
051000     EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
051100                                                                  
051200     PERFORM 0100A-DECLARE-GTT-R1          THRU 0100A-EXIT.       
051300     PERFORM 0100B-DECLARE-GTT-R2          THRU 0100B-EXIT.       
P00836     PERFORM 0100C-DECLARE-GTT-R3          THRU 0100C-EXIT.       
PRJ836     IF PARM-APPL-PROGRAM-ID = 'WEB'                              
PRJ836        PERFORM 0100D-DECLARE-GTT-R4  THRU  0100D-EXIT            
PRJ836     END-IF.                                                      
051400                                                                  
051500 0100-EXIT.                                                       
051600     EXIT.                                                        
HPCCDM*    EJECT                                                        00051700
051800******************************************************************00051800
051900* 0100A-DECLARE-GTT-R1                                           *00051900
052000******************************************************************00052000
052100 0100A-DECLARE-GTT-R1.                                            
052200       MOVE 'SESSION.CSR04690_R1'     TO WS-GTT-NAME.             
052300                                                                  
052400       EXEC SQL
               CALL CIS.DROP_TEMP_TABLE('#CSR04690_R1')
             END-EXEC
             EXEC SQL
               CREATE TABLE #CSR04690_R1
                (     RETURN_CODE         INT                     
052610                 ,APPL_RETURN_CODE    INT                     
052700                 ,BILL_DATE CHAR(10)  COLLATE 
                                       LATIN1_GENERAL_100_BIN2                 
052800                 ,READ_DATE CHAR(10)  COLLATE 
                                       LATIN1_GENERAL_100_BIN2                 
052900                 ,DAYS                SMALLINT                    
053000                 ,KWH_USED            INT                     
053100                 ,ACTUAL_KW           INT                     
053200                 ,ACTUAL_KVA          INT                     
053300                 ,BILLED_KVA_KW       INT                     
053400                 ,DEMAND_CALC_CODE CHAR(1)  COLLATE 
                                       LATIN1_GENERAL_100_BIN2                 
053500                 ,TOTAL_REVENUE       DECIMAL(11,2)               
053600                 ,LOAD_FACTOR         DECIMAL(11,2)               
053700                 ,POWER_FACTOR        DECIMAL(11,2)               
053800                 ,AVG_CENTS_PER_KWH   DECIMAL(15,6)               
053900                 ,ON_PEAK_KWH         INT                     
054000                 ,OFF_PEAK_KWH        INT                     
054100                 ,SHOULDER_KWH        INT                     
054200                 ,ON_PEAK_KW          INT                     
054300                 ,OFF_PEAK_KW         INT                     
054400                 ,SHOULDER_KW         INT                     
054500                 ,ON_PEAK_KVA         INT                     
054600                 ,OFF_PEAK_KVA        INT                     
054700                 ,SHOULDER_KVA        INT                     
054800                 ,EMPL                INT                     
054900                 ,EXCL_DMD_RCHT_IND CHAR(1)  COLLATE 
                                       LATIN1_GENERAL_100_BIN2                 
055000                 ,CODE_UTIL_TYPE CHAR(1)  COLLATE 
                                       LATIN1_GENERAL_100_BIN2                 
055100                 ,BILL_ITEM_TIMESTMP CHAR(26)  COLLATE 
                                       LATIN1_GENERAL_100_BIN2                 
055200                 ,BILL_NO             INT                     
055300                 ,MTR_REF_NO          SMALLINT                    
055400                 ,REG_ID_NO           SMALLINT                    
055500                 ,CODE_TIME_PERIOD    SMALLINT                    
055600                 ,ITEM_SEQ_NO         SMALLINT                    
PRJ821                 ,RATE_PLAN_NO CHAR(03)  COLLATE 
                                       LATIN1_GENERAL_100_BIN2                 
PRJ821                 ,RATE_PLAN_DESC CHAR(50)  COLLATE 
                                       LATIN1_GENERAL_100_BIN2                 
PRJ836                 ,REVENUE_MONTH       DECIMAL(6,0)                
055700            )
             END-EXEC                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

055900*                                                                 00055900
056000     MOVE SQLSTATE                    TO WS-SQLSTATE.             
056100     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
056200*                                                                 00056200
056300     IF WS-SQLSTATE = '42710'                                     
056400        PERFORM 8000A-DELETE-GTT-ROWS                             
056500                                           THRU 8000A-EXIT        
056600     ELSE                                                         
056700        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
056800           CONTINUE                                               
056900        ELSE                                                      
057000           MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
057100           MOVE SQLCODE               TO ABEND-SQLCODE            
057200           MOVE SQLSTATE              TO ABEND-SQLSTATE           
057300           MOVE '0100A'               TO ACTIVE-PARAGRAPH         
057400           MOVE 'WS-GTT-NAME'         TO ABEND-FUNCTION           
057500           MOVE SPACES                TO                          
057600                                      ABEND-SQL-PREDICATES        
057700                                      ABEND-TABLES                
057800           MOVE 'CSR04690_R1'         TO TABLE-1                  
057900           MOVE SPACES                TO TABLE-ELEMENT-1          
058000           MOVE SPACES                TO HOSTVAR-ELEMENT-1        
058100           PERFORM 9900-SQL-ERROR-ROUTINE                         
058200                                           THRU  9900-EXIT        
058300        END-IF                                                    
058400     END-IF.                                                      
058500*                                                                 00058500
058600     EXEC SQL                                                     
066800         DECLARE C1 CURSOR                             
066900                           WITH ROWSET POSITIONING FOR            
058800          SELECT                                                  
058900               RETURN_CODE                                        
058910              ,APPL_RETURN_CODE                                   
059000              ,LTRIM(RTRIM(BILL_DATE))            AS  BILL_DATE          
059100              ,LTRIM(RTRIM(READ_DATE))            AS  READ_DATE          
059200              ,DAYS                                               
059300              ,KWH_USED                                           
059400              ,ACTUAL_KW                                          
059500              ,ACTUAL_KVA                                         
059600              ,BILLED_KVA_KW                                      
059700              ,LTRIM(RTRIM(DEMAND_CALC_CODE))     AS 
           DEMAND_CALC_CODE    
059800              ,TOTAL_REVENUE                                      
059900              ,LOAD_FACTOR                                        
060000              ,POWER_FACTOR                                       
060100              ,AVG_CENTS_PER_KWH                                  
060200              ,ON_PEAK_KWH                                        
060300              ,OFF_PEAK_KWH                                       
060400              ,SHOULDER_KWH                                       
060500              ,ON_PEAK_KW                                         
060600              ,OFF_PEAK_KW                                        
060700              ,SHOULDER_KW                                        
060800              ,ON_PEAK_KVA                                        
060900              ,OFF_PEAK_KVA                                       
061000              ,SHOULDER_KVA                                       
061100              ,EMPL                                               
061200              ,LTRIM(RTRIM(EXCL_DMD_RCHT_IND))    AS 
           EXCL_DMD_RCHT_IND   
061300              ,LTRIM(RTRIM(CODE_UTIL_TYPE))       AS 
           CODE_UTIL_TYPE      
061400              ,LTRIM(RTRIM(BILL_ITEM_TIMESTMP))   AS 
           BILL_ITEM_TIMESTMP  
061500              ,BILL_NO                                            
061600              ,MTR_REF_NO                                         
061700              ,REG_ID_NO                                          
061800              ,CODE_TIME_PERIOD                                   
061900              ,ITEM_SEQ_NO                                        
PRJ821              ,LTRIM(RTRIM(RATE_PLAN_NO))         AS RATE_PLAN_NO        
PRJ821              ,LTRIM(RTRIM(RATE_PLAN_DESC))       AS 
           RATE_PLAN_DESC      
PRJ836              ,REVENUE_MONTH                                      
062000          FROM                                                    
062100              #CSR04690_R1                                 
062200      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     00058600
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                            00058610
MFA-TR*                          WITH ROWSET POSITIONING FOR            00058620
MFA-TR*         SELECT                                                  00058800
MFA-TR*              RETURN_CODE                                        00058900
MFA-TR*             ,APPL_RETURN_CODE                                   00058910
MFA-TR*             ,STRIP(BILL_DATE)            AS  BILL_DATE          00059000
MFA-TR*             ,STRIP(READ_DATE)            AS  READ_DATE          00059100
MFA-TR*             ,DAYS                                               00059200
MFA-TR*             ,KWH_USED                                           00059300
MFA-TR*             ,ACTUAL_KW                                          00059400
MFA-TR*             ,ACTUAL_KVA                                         00059500
MFA-TR*             ,BILLED_KVA_KW                                      00059600
MFA-TR*             ,STRIP(DEMAND_CALC_CODE)     AS DEMAND_CALC_CODE    00059700
MFA-TR*             ,TOTAL_REVENUE                                      00059800
MFA-TR*             ,LOAD_FACTOR                                        00059900
MFA-TR*             ,POWER_FACTOR                                       00060000
MFA-TR*             ,AVG_CENTS_PER_KWH                                  00060100
MFA-TR*             ,ON_PEAK_KWH                                        00060200
MFA-TR*             ,OFF_PEAK_KWH                                       00060300
MFA-TR*             ,SHOULDER_KWH                                       00060400
MFA-TR*             ,ON_PEAK_KW                                         00060500
MFA-TR*             ,OFF_PEAK_KW                                        00060600
MFA-TR*             ,SHOULDER_KW                                        00060700
MFA-TR*             ,ON_PEAK_KVA                                        00060800
MFA-TR*             ,OFF_PEAK_KVA                                       00060900
MFA-TR*             ,SHOULDER_KVA                                       00061000
MFA-TR*             ,EMPL                                               00061100
MFA-TR*             ,STRIP(EXCL_DMD_RCHT_IND)    AS EXCL_DMD_RCHT_IND   00061200
MFA-TR*             ,STRIP(CODE_UTIL_TYPE)       AS CODE_UTIL_TYPE      00061300
MFA-TR*             ,STRIP(BILL_ITEM_TIMESTMP)   AS BILL_ITEM_TIMESTMP  00061400
MFA-TR*             ,BILL_NO                                            00061500
MFA-TR*             ,MTR_REF_NO                                         00061600
MFA-TR*             ,REG_ID_NO                                          00061700
MFA-TR*             ,CODE_TIME_PERIOD                                   00061800
MFA-TR*             ,ITEM_SEQ_NO                                        00061900
MFA-TR*             ,STRIP(RATE_PLAN_NO)         AS RATE_PLAN_NO        00061900
MFA-TR*             ,STRIP(RATE_PLAN_DESC)       AS RATE_PLAN_DESC      00061900
MFA-TR*             ,REVENUE_MONTH                                      00061900
MFA-TR*         FROM                                                    00062000
MFA-TR*             SESSION.CSR04690_R1                                 00062100
MFA-TR*     END-EXEC.                                                   00062200
062300 0100A-EXIT.                                                      
062400       EXIT.                                                      
062500***********************************************************       00062500
062600*                                                                 00062600
062700*  0100B-DECLARE-GTT-R2                                           00062700
062800***********************************************************       00062800
062900 0100B-DECLARE-GTT-R2.                                            
063000                                                                  
063100     MOVE 'SESSION.CSR04690_R2'       TO WS-GTT-NAME.             
063200                                                                  
063300     EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04690_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04690_R2
              (                                                       
063600              RETURN_CODE             INT                     
063700             ,APPL_RETURN_CODE        INT                     
063800             ,BUS_RULE_ID CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
063900             ,BUS_RULE_RESULT_CD CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
064000             ,BUS_RULE_XREF_ID CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
064100          )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

064300                                                                  
064400     MOVE SQLSTATE                    TO WS-SQLSTATE.             
064500     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
064600                                                                  
064700     IF WS-SQLSTATE = '42710'                                     
064800        PERFORM 8000B-DEL-GTT-ROWS         THRU 8000B-EXIT        
064900     ELSE                                                         
065000        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
065100           CONTINUE                                               
065200        ELSE                                                      
065300           MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
065400           MOVE '0100B'               TO ACTIVE-PARAGRAPH         
065500           MOVE SQLCODE               TO ABEND-SQLCODE            
065600           MOVE SQLSTATE              TO ABEND-SQLSTATE           
065700           MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
065800           MOVE SPACES                TO ABEND-SQL-PREDICATES     
065900                                         ABEND-TABLES             
066000           MOVE WS-GTT-NAME           TO TABLE-1                  
066100           MOVE SPACES                TO TABLE-ELEMENT-1          
066200           MOVE SPACES                TO HOSTVAR-ELEMENT-1        
066300           PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT         
066400        END-IF                                                    
066500     END-IF.                                                      
066600                                                                  
066700     EXEC SQL                                                     
066800         DECLARE C2 CURSOR                             
066900                           WITH ROWSET POSITIONING FOR            
067000          SELECT RETURN_CODE                                      
067100                ,APPL_RETURN_CODE                                 
067200                ,LTRIM(RTRIM(BUS_RULE_ID))          AS BUS_RULE_ID       
067300                ,LTRIM(RTRIM(BUS_RULE_RESULT_CD))   AS 
           BUS_RULE_RESULT_CD
067400                ,LTRIM(RTRIM(BUS_RULE_XREF_ID))     AS 
           BUS_RULE_XREF_ID  
067500            FROM #CSR04690_R2                              
067600     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     00066700
MFA-TR*        DECLARE C2 CURSOR WITH RETURN                            00066800
MFA-TR*                          WITH ROWSET POSITIONING FOR            00066900
MFA-TR*         SELECT RETURN_CODE                                      00067000
MFA-TR*               ,APPL_RETURN_CODE                                 00067100
MFA-TR*               ,STRIP(BUS_RULE_ID)          AS BUS_RULE_ID       00067200
MFA-TR*               ,STRIP(BUS_RULE_RESULT_CD)   AS BUS_RULE_RESULT_CD00067300
MFA-TR*               ,STRIP(BUS_RULE_XREF_ID)     AS BUS_RULE_XREF_ID  00067400
MFA-TR*           FROM SESSION.CSR04690_R2                              00067500
MFA-TR*    END-EXEC.                                                    00067600
067700                                                                  
067800 0100B-EXIT.                                                      
067900      EXIT.                                                       
068000                                                                  
P00836***********************************************************       00062500
P00836*                                                                 00062600
P00836*  0100C-DECLARE-GTT-R3                                           00062700
P00836***********************************************************       00062800
P00836 0100C-DECLARE-GTT-R3.                                            
P00836                                                                  
P00836     MOVE 'SESSION.CSR04690_R3'       TO WS-GTT-NAME.             
P00836                                                                  
P00836     EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04690_R3')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04690_R3
              (                                                       
P00836              RETURN_CODE             INT                     
P00836             ,APPL_RETURN_CODE        INT                     
P00836             ,CODE_SHORT_DESC CHAR(15)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
P00836          )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00836                                                                  
P00836     MOVE SQLSTATE                    TO WS-SQLSTATE.             
P00836     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
P00836                                                                  
P00836     IF WS-SQLSTATE = '42710'                                     
P00836        PERFORM 8000C-DEL-GTT-ROWS         THRU 8000C-EXIT        
P00836     ELSE                                                         
P00836        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
P00836           CONTINUE                                               
P00836        ELSE                                                      
P00836           MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
P00836           MOVE '0100C'               TO ACTIVE-PARAGRAPH         
P00836           MOVE SQLCODE               TO ABEND-SQLCODE            
P00836           MOVE SQLSTATE              TO ABEND-SQLSTATE           
P00836           MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
P00836           MOVE SPACES                TO ABEND-SQL-PREDICATES     
P00836                                         ABEND-TABLES             
P00836           MOVE WS-GTT-NAME           TO TABLE-1                  
P00836           MOVE SPACES                TO TABLE-ELEMENT-1          
P00836           MOVE SPACES                TO HOSTVAR-ELEMENT-1        
P00836           PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT         
P00836        END-IF                                                    
P00836     END-IF.                                                      
P00836                                                                  
P00836     EXEC SQL                                                     
P00836         DECLARE C3 CURSOR                             
P00836                           WITH ROWSET POSITIONING FOR            
P00836          SELECT RETURN_CODE                                      
P00836                ,APPL_RETURN_CODE                                 
P00836                ,LTRIM(RTRIM(CODE_SHORT_DESC))      AS 
           WEB_FORMAT_CD     
P00836            FROM #CSR04690_R3                              
P00836     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     00066700
MFA-TR*        DECLARE C3 CURSOR WITH RETURN                            00066800
MFA-TR*                          WITH ROWSET POSITIONING FOR            00066900
MFA-TR*         SELECT RETURN_CODE                                      00067000
MFA-TR*               ,APPL_RETURN_CODE                                 00067100
MFA-TR*               ,STRIP(CODE_SHORT_DESC)      AS WEB_FORMAT_CD     00067200
MFA-TR*           FROM SESSION.CSR04690_R3                              00067500
MFA-TR*    END-EXEC.                                                    00067600
P00836                                                                  
P00836 0100C-EXIT.                                                      
P00836      EXIT.                                                       
P00836                                                                  
PRJ836******************************************************************00051800
PRJ836** 0100D-DECLARE-GTT-R4                                         **00051900
PRJ836******************************************************************00052000
PRJ836*                                                                 00052000
PRJ836 0100D-DECLARE-GTT-R4.                                            
PRJ836*                                                                 00052000
PRJ836       MOVE 'SESSION.CSR04690_R4'     TO WS-GTT-NAME.             
PRJ836*                                                                 00052000
PRJ836       EXEC SQL
               CALL CIS.DROP_TEMP_TABLE('#CSR04690_R4')
             END-EXEC
             EXEC SQL
               CREATE TABLE #CSR04690_R4
                (     RETURN_CODE         INT                     
PRJ836                 ,APPL_RETURN_CODE    INT                     
PRJ836                 ,CODE_UTIL_TYPE CHAR(1)  COLLATE 
                                       LATIN1_GENERAL_100_BIN2                 
PRJ836                 ,BILL_DATE CHAR(10)  COLLATE 
                                       LATIN1_GENERAL_100_BIN2                 
PRJ836                 ,CODE_BILL_TYPE CHAR(01)  COLLATE 
                                       LATIN1_GENERAL_100_BIN2                 
PRJ836                 ,REVENUE_MONTH       DECIMAL(6,0)                
PRJ836                 ,CODE_BILL_CALC CHAR(01)  COLLATE 
                                       LATIN1_GENERAL_100_BIN2                 
PRJ836                 ,CODE_BILL_ITM_TYPE CHAR(01)  COLLATE 
                                       LATIN1_GENERAL_100_BIN2                 
PRJ836                 ,CODE_BILL_ITM_IND CHAR(01)  COLLATE 
                                       LATIN1_GENERAL_100_BIN2                 
PRJ836                 ,TOTAL_REVENUE       DECIMAL(15,6)               
PRJ836                 ,READ_DATE CHAR(10)  COLLATE 
                                       LATIN1_GENERAL_100_BIN2                 
PRJ836                 ,DAYS                SMALLINT                    
PRJ836                 ,KWH_USED            INT                     
PRJ836                 ,ACTUAL_KW           INT                     
PRJ836                 ,ACTUAL_KVA          INT                     
PRJ836                 ,BILLED_KVA_KW       INT                     
PRJ836                 ,ON_PEAK_KWH         INT                     
PRJ836                 ,ON_PEAK_KW          INT                     
PRJ836                 ,ON_PEAK_KVA         INT                     
PRJ836                 ,OFF_PEAK_KWH        INT                     
PRJ836                 ,OFF_PEAK_KW         INT                     
PRJ836                 ,OFF_PEAK_KVA        INT                     
PRJ836                 ,SHOULDER_KWH        INT                     
PRJ836                 ,SHOULDER_KW         INT                     
PRJ836                 ,SHOULDER_KVA        INT                     
PRJ836                 ,LOAD_FACTOR         DECIMAL(11,2)               
PRJ836                 ,POWER_FACTOR        DECIMAL(11,2)               
PRJ836                 ,RATE_PLAN_NO CHAR(03)  COLLATE 
                                       LATIN1_GENERAL_100_BIN2                 
PRJ836                 ,RATE_PLAN_DESC CHAR(50)  COLLATE 
                                       LATIN1_GENERAL_100_BIN2                 
PRJ836            )
             END-EXEC.                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PRJ836*                                                                 00055900
PRJ836     MOVE SQLSTATE                    TO WS-SQLSTATE.             
PRJ836     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
PRJ836*                                                                 00056200
PRJ836     IF WS-SQLSTATE = '42710'                                     
PRJ836        PERFORM 8000D-DELETE-GTT-ROWS                             
PRJ836                                           THRU 8000D-EXIT        
PRJ836     ELSE                                                         
PRJ836        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
PRJ836           CONTINUE                                               
PRJ836        ELSE                                                      
PRJ836           MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
PRJ836           MOVE SQLCODE               TO ABEND-SQLCODE            
PRJ836           MOVE SQLSTATE              TO ABEND-SQLSTATE           
PRJ836           MOVE '0100D'               TO ACTIVE-PARAGRAPH         
PRJ836           MOVE 'WS-GTT-NAME'         TO ABEND-FUNCTION           
PRJ836           MOVE SPACES                TO                          
PRJ836                                      ABEND-SQL-PREDICATES        
PRJ836                                      ABEND-TABLES                
PRJ836           MOVE 'CSR04690_R4'         TO TABLE-1                  
PRJ836           MOVE SPACES                TO TABLE-ELEMENT-1          
PRJ836           MOVE SPACES                TO HOSTVAR-ELEMENT-1        
PRJ836           PERFORM 9900-SQL-ERROR-ROUTINE                         
PRJ836                                           THRU  9900-EXIT        
PRJ836        END-IF                                                    
PRJ836     END-IF.                                                      
PRJ836*                                                                 00058500
PRJ836     EXEC SQL                                                     
PRJ836         DECLARE C4 CURSOR                             
PRJ836                           WITH ROWSET POSITIONING FOR            
PRJ836          SELECT                                                  
PRJ836               RETURN_CODE                                        
PRJ836              ,APPL_RETURN_CODE                                   
PRJ836              ,CODE_UTIL_TYPE                                     
PRJ836              ,BILL_DATE                                          
PRJ836              ,CODE_BILL_TYPE                                     
PRJ836              ,REVENUE_MONTH                                      
PRJ836              ,CODE_BILL_CALC                                     
PRJ836              ,CODE_BILL_ITM_TYPE                                 
PRJ836              ,CODE_BILL_ITM_IND                                  
PRJ836              ,TOTAL_REVENUE                                      
PRJ836              ,READ_DATE                                          
PRJ836              ,DAYS                                               
PRJ836              ,KWH_USED                                           
PRJ836              ,ACTUAL_KW                                          
PRJ836              ,ACTUAL_KVA                                         
PRJ836              ,BILLED_KVA_KW                                      
PRJ836              ,ON_PEAK_KWH                                        
PRJ836              ,ON_PEAK_KW                                         
PRJ836              ,ON_PEAK_KVA                                        
PRJ836              ,OFF_PEAK_KWH                                       
PRJ836              ,OFF_PEAK_KW                                        
PRJ836              ,OFF_PEAK_KVA                                       
PRJ836              ,SHOULDER_KWH                                       
PRJ836              ,SHOULDER_KW                                        
PRJ836              ,SHOULDER_KVA                                       
PRJ836              ,LOAD_FACTOR                                        
PRJ836              ,POWER_FACTOR                                       
PRJ836              ,RATE_PLAN_NO                                       
PRJ836              ,RATE_PLAN_DESC                                     
PRJ836          FROM                                                    
PRJ836              #CSR04690_R4                                 
PRJ836      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     00058600
MFA-TR*        DECLARE C4 CURSOR WITH RETURN                            00058610
MFA-TR*                          WITH ROWSET POSITIONING FOR            00058620
MFA-TR*         SELECT                                                  00058800
MFA-TR*              RETURN_CODE                                        00058900
MFA-TR*             ,APPL_RETURN_CODE                                   00058910
MFA-TR*             ,CODE_UTIL_TYPE                                     00061300
MFA-TR*             ,BILL_DATE                                          00059000
MFA-TR*             ,CODE_BILL_TYPE                                     00059000
MFA-TR*             ,REVENUE_MONTH                                      00061900
MFA-TR*             ,CODE_BILL_CALC                                     00061900
MFA-TR*             ,CODE_BILL_ITM_TYPE                                 00061900
MFA-TR*             ,CODE_BILL_ITM_IND                                  00061900
MFA-TR*             ,TOTAL_REVENUE                                      00059800
MFA-TR*             ,READ_DATE                                          00059100
MFA-TR*             ,DAYS                                               00059200
MFA-TR*             ,KWH_USED                                           00059300
MFA-TR*             ,ACTUAL_KW                                          00059400
MFA-TR*             ,ACTUAL_KVA                                         00059500
MFA-TR*             ,BILLED_KVA_KW                                      00059600
MFA-TR*             ,ON_PEAK_KWH                                        00060200
MFA-TR*             ,ON_PEAK_KW                                         00060500
MFA-TR*             ,ON_PEAK_KVA                                        00060800
MFA-TR*             ,OFF_PEAK_KWH                                       00060300
MFA-TR*             ,OFF_PEAK_KW                                        00060600
MFA-TR*             ,OFF_PEAK_KVA                                       00060900
MFA-TR*             ,SHOULDER_KWH                                       00060400
MFA-TR*             ,SHOULDER_KW                                        00060700
MFA-TR*             ,SHOULDER_KVA                                       00061000
MFA-TR*             ,LOAD_FACTOR                                        00061800
MFA-TR*             ,POWER_FACTOR                                       00061900
MFA-TR*             ,RATE_PLAN_NO                                       00061900
MFA-TR*             ,RATE_PLAN_DESC                                     00061900
MFA-TR*         FROM                                                    00062000
MFA-TR*             SESSION.CSR04690_R4                                 00062100
MFA-TR*     END-EXEC.                                                   00062200
PRJ836*                                                                 00062400
PRJ836 0100D-EXIT.                                                      
PRJ836       EXIT.                                                      
PRJ836*                                                                 00062400
068100******************************************************************00068100
068200*1000-PROCESS-INPUT                                              *00068200
068300*                                                                *00068300
068400*    1. RECEIVE EACH PARAMETER FROM THE LINKAGE SECTION          *00068400
068500*                                                                *00068500
068600******************************************************************00068600
068700                                                                  
068800 1000-PROCESS-INPUT.                                              
068900*                                                                 00068900
069000     MOVE PARM-ACCT-NO                TO WS-ACCT-NO               
P00836                                         UT-ACCOUNT-NO.           
069100     MOVE PARM-IC-NO                  TO WS-IC-NO                 
P00836                                         UT-IC-NO.                
P00836     MOVE PARM-APPL-PROGRAM-ID        TO WS-APPL-PROGRAM-ID.      
069200*                                                                 00069200
069300 1000-EXIT.                                                       
069400     EXIT.                                                        
HPCCDM*    EJECT                                                        00069500
069600******************************************************************00069600
069700* 2000-PROCESS-OUTPUT                                            *00069700
069800*                                                                *00069800
069900*     DESCRIBE EACH COLUMN IN THE RESULT SET.                    *00069900
070000*     BUILD THE RESULT SET.                                      *00070000
070100*                                                                *00070100
070200******************************************************************00070200
070300                                                                  
070400 2000-PROCESS-OUTPUT.                                             
PRJ836*                                                                         
PRJ836     PERFORM 7050-CHECK-EBILL-NO-DISP-IND  THRU  7050-EXIT.       
PRJ836*                                                                         
P00836     PERFORM 7940-GET-CURRENT-RATE-PLAN    THRU  7940-EXIT.       
P00836     MOVE UT-RATE-PLAN-NO             TO UV-CODE-VALUE-TEXT.      
P00836     MOVE LENGTH OF UV-CODE-VALUE-TEXT                            
P00836                                      TO UV-CODE-VALUE-LEN.       
070500*                                                                *00070500
070600******************************************************************00070600
070700* PROCESS BILLING HDR AND DETAILS                                *00070700
070800******************************************************************00070800
070500*                                                                *00070801
070810     PERFORM 7100-PROCESS-BI-CURSOR             THRU 7100-EXIT.   
070500*                                                                *00070820
PRJ836     IF CTR-ROWS-RS4 > 0                                          
PRJ836        PERFORM 8100-DELETE-CANCEL-ROWS-R4  THRU  8100-EXIT       
PRJ836        PERFORM 8200-INSERT-GTT-RESULT      THRU  8200-EXIT       
PRJ836     END-IF.                                                      
PRJ836*                                                                         
071730     IF CTR-ROWS-RS1  EQUAL WS-ZERO                               
071740        MOVE 'CMN0000015'             TO S-RS2-BUS-RULE-ID        
071750        MOVE WS-FAILED                TO S-RS2-BUS-RULE-RESULT-CD 
071760        PERFORM 7550-GET-RULE-XREF-ID      THRU 7550-EXIT         
071770        PERFORM 8020-INSERT-GTT-R2         THRU 8020-EXIT         
071780        PERFORM 9999-END-PROGRAM           THRU 9999-EXIT         
071790     END-IF.                                                      
P00836     PERFORM 2200-PROCESS-FORMAT-CODE      THRU 2200-EXIT.        
072100*                                                                 00072100
072200 2000-EXIT.                                                       
072300     EXIT.                                                        
HPCCDM*    EJECT                                                        00072400
072500******************************************************************00072500
072600* 2000-PROCESS-OUTPUT                                            *00072600
072700******************************************************************00072700
072800*                                                                *00072800
072900 2000A-MOVE-RESULT.                                               
073000*                                                                 00073000
073100     MOVE  RS-BILL-DATE               TO    S-BILL-DATE.          
073200     MOVE  RS-READ-DATE               TO    S-READ-DATE.          
073300     MOVE  RS-DAYS                    TO    S-DAYS.               
073400     MOVE  RS-KWH-USED                TO    S-KWH-USED.           
073500     MOVE  RS-ACTUAL-KW               TO    S-ACTUAL-KW.          
073600     MOVE  RS-ACTUAL-KVA              TO    S-ACTUAL-KVA.         
073700     MOVE  RS-BILLED-KVA-KW           TO    S-BILLED-KVA-KW.      
073800     MOVE  RS-DEMAND-CALC-CODE        TO    S-DEMAND-CALC-CODE.   
073900     MOVE  RS-TOTAL-REVENUE           TO    S-TOTAL-REVENUE.      
074000     MOVE  RS-LOAD-FACTOR             TO    S-LOAD-FACTOR.        
074100     MOVE  RS-POWER-FACTOR            TO    S-POWER-FACTOR        
074200     MOVE  RS-AVG-CENTS-PER-KWH       TO    S-AVG-CENTS-PER-KWH.  
074300     MOVE  RS-ON-PEAK-KWH             TO    S-ON-PEAK-KWH.        
074400     MOVE  RS-OFF-PEAK-KWH            TO    S-OFF-PEAK-KWH.       
074500     MOVE  RS-SHOULDER-KWH            TO    S-SHOULDER-KWH.       
074600     MOVE  RS-ON-PEAK-KW              TO    S-ON-PEAK-KW.         
074700     MOVE  RS-OFF-PEAK-KW             TO    S-OFF-PEAK-KW.        
074800     MOVE  RS-SHOULDER-KW             TO    S-SHOULDER-KW.        
074900     MOVE  RS-ON-PEAK-KVA             TO    S-ON-PEAK-KVA.        
075000     MOVE  RS-OFF-PEAK-KVA            TO    S-OFF-PEAK-KVA.       
075100     MOVE  RS-SHOULDER-KVA            TO    S-SHOULDER-KVA.       
075200     MOVE  RS-EMPLOYEE-NO             TO    S-EMPLOYEE-NO.        
075300     MOVE  RS-EXCL-DMD-RCHT-IND       TO    S-EXCL-DMD-RCHT-IND.  
075400     MOVE  RS-CODE-UTIL-TYPE          TO    S-CODE-UTIL-TYPE.     
075500     MOVE  RS-BILL-ITEM-TIMESTMP      TO    S-BILL-ITEM-TIMESTMP. 
075600     MOVE  RS-BILL-NO                 TO    S-BILL-NO.            
075700     MOVE  RS-MTR-REF-NO              TO    S-MTR-REF-NO.         
075800     MOVE  RS-REG-ID-NO               TO    S-REG-ID-NO.          
075900     MOVE  RS-CODE-TIME-PERIOD        TO    S-CODE-TIME-PERIOD.   
076000     MOVE  RS-ITEM-SEQ-NO             TO    S-ITEM-SEQ-NO.        
PRJ821     MOVE  RS-RATE-PLAN-NO            TO    S-RATE-PLAN-NO.       
PRJ821     MOVE  RS-RATE-PLAN-DESC          TO    S-RATE-PLAN-DESC.     
PRJ836     MOVE  RS-CODE-BILL-TYPE          TO    S-CODE-BILL-TYPE.     
PRJ836     MOVE  RS-CODE-BILL-CALC          TO    S-CODE-BILL-CALC.     
PRJ836     MOVE  RS-CODE-BILL-ITM-TYPE      TO    S-CODE-BILL-ITM-TYPE. 
PRJ836     MOVE  RS-CODE-BILL-ITM-IND       TO    S-CODE-BILL-ITM-IND.  
PRJ836     MOVE  RS-CODE-DR-CR-CNSMPTN      TO    S-CODE-DR-CR-CNSMPTN. 
PRJ836     MOVE  RS-AMT-STATE-TAX           TO    S-AMT-STATE-TAX.      
PRJ836     MOVE  RS-AMT-CITY-TAX            TO    S-AMT-CITY-TAX.       
PRJ836     MOVE  RS-AMT-OTHER-TAX           TO    S-AMT-OTHER-TAX.      
PRJ836     MOVE  RS-REVENUE-MONTH           TO    S-REVENUE-MONTH.      
PRJ836     MOVE  RS-REV-MTH-ORIG-BILL       TO    S-REV-MTH-ORIG-BILL.  
PRJ836     IF PARM-APPL-PROGRAM-ID NOT = 'WEB' AND                      
PRJ836        S-REV-MTH-ORIG-BILL      >  0                             
PRJ836        MOVE S-REV-MTH-ORIG-BILL      TO    S-REVENUE-MONTH       
PRJ836     END-IF.                                                      
076100                                                                  
076200 2000A-EXIT.                                                      
076300     EXIT.                                                        
076400*                                                                 00076400
076500******************************************************************00076500
076600*                                                                *00076600
076700* 2100-PROCESS-BILL-MONTH                                        *00076700
076800*                                                                *00076800
076900******************************************************************00076900
077000                                                                  
077100 2100-PROCESS-BILL-MONTH.                                         
077200                                                                  
077300     INITIALIZE TDS-RETURN-FIELDS.                                
077400*                                                                 00077400
077500     MOVE WS-ZERO                     TO WS-KVAR-UNITS            
077600                                         WS-HOLD-ACTUAL-KVA       
077700                                         WS-HOLD-ACTUAL-KW        
077800                                         WS-HOLD-MTR-REF-NO.      
PRJ821                                                                  
PRJ821     MOVE BG-RATE-PLAN-NO             TO RS-RATE-PLAN-NO          
PRJ821                                         RD-RATE-PLAN-NO.         
I00177                                                                  
PRJ821     MOVE BG-CODE-UTIL-TYPE           TO RD-CODE-UTIL-TYPE.       
PRJ821                                                                  
PRJ821     IF RD-RATE-PLAN-NO NOT EQUAL WS-PREV-RATE-PLAN-NO            
PRJ821        PERFORM 7930-GET-RATE-DESC        THRU 7930-EXIT          
PRJ821     END-IF.                                                      
PRJ821                                                                  
PRJ821     MOVE RD-RATE-DESC                 TO RS-RATE-PLAN-DESC.      
PRJ821     MOVE RD-RATE-PLAN-NO              TO WS-PREV-RATE-PLAN-NO.   
PRJ836     MOVE BI-CODE-BILL-TYPE            TO RS-CODE-BILL-TYPE.      
PRJ836     MOVE BG-CODE-BILL-CALC            TO RS-CODE-BILL-CALC.      
PRJ836     MOVE BG-CODE-BILL-ITM-TYPE        TO RS-CODE-BILL-ITM-TYPE.  
PRJ836     MOVE BG-CODE-BILL-ITM-IND         TO RS-CODE-BILL-ITM-IND.   
PRJ836     MOVE BG-CODE-DR-CR-CNSMPTN        TO RS-CODE-DR-CR-CNSMPTN.  
PRJ836     MOVE BG-AMT-STATE-TAX             TO RS-AMT-STATE-TAX.       
PRJ836     MOVE BG-AMT-CITY-TAX              TO RS-AMT-CITY-TAX.        
PRJ836     MOVE BG-AMT-OTHER-TAX             TO RS-AMT-OTHER-TAX.       
PRJ836     MOVE BG-REV-MTH-ORIG-BILL         TO RS-REV-MTH-ORIG-BILL.   
PRJ836     MOVE BG-REVENUE-MONTH             TO RS-REVENUE-MONTH.       
077900                                                                  
078000     MOVE WS-HOLD-DATE                TO RS-BILL-DATE.            
078100*                                                                 00078100
078200     PERFORM 7200-PROCESS-BZ-CURSOR        THRU 7200-EXIT.        
078610*                                                                 00078610
082100*                                                                 00082100
082200     PERFORM 7300-PROCESS-DEMAND-CURSOR    THRU 7300-EXIT.        
      *                                                                 00082910
083000     PERFORM 7400-PROCESS-CX-CURSOR        THRU 7400-EXIT.        
      *                                                                 00083001
085300                                                                  
085400     MOVE RS-ON-PEAK-KVA              TO RS-ACTUAL-KVA            
085410*                                                                 00085410
085500     IF RS-OFF-PEAK-KVA > RS-ACTUAL-KVA                           
085600         MOVE RS-OFF-PEAK-KVA         TO RS-ACTUAL-KVA            
085700     END-IF.                                                      
085710*                                                                 00085710
085800     IF RS-SHOULDER-KVA > RS-ACTUAL-KVA                           
085900         MOVE RS-SHOULDER-KVA         TO RS-ACTUAL-KVA            
086000     END-IF.                                                      
086010*                                                                 00086010
086200     MOVE RS-ON-PEAK-KW               TO RS-ACTUAL-KW.            
086210*                                                                 00086210
086300     IF RS-OFF-PEAK-KW > RS-ACTUAL-KW                             
086400         MOVE RS-OFF-PEAK-KW          TO RS-ACTUAL-KW             
086500     END-IF.                                                      
086510*                                                                 00086510
086600     IF RS-SHOULDER-KW > RS-ACTUAL-KW                             
086700         MOVE RS-SHOULDER-KW          TO RS-ACTUAL-KW             
086800     END-IF.                                                      
086810*                                                                 00086810
087000     IF RS-ON-PEAK-KW = 0 AND RS-OFF-PEAK-KW = 0 AND              
087100        RS-SHOULDER-KW = 0                                        
087200        MOVE WS-HOLD-ACTUAL-KW        TO RS-ACTUAL-KW             
087300        MOVE WS-HOLD-ACTUAL-KW        TO RS-ON-PEAK-KW            
087400     END-IF                                                       
087410*                                                                 00087410
087500     IF RS-ON-PEAK-KVA = 0 AND RS-OFF-PEAK-KVA = 0 AND            
087600        RS-SHOULDER-KVA = 0                                       
087700        MOVE WS-HOLD-ACTUAL-KVA       TO RS-ACTUAL-KVA            
087800        MOVE WS-HOLD-ACTUAL-KVA       TO RS-ON-PEAK-KVA           
087900     END-IF                                                       
087910*                                                                 00087910
088100     MOVE RS-ACTUAL-KVA               TO WS-ACTUAL-KVA.           
088200     MOVE RS-ACTUAL-KW                TO WS-ACTUAL-KW.            
088300*                                                                 00088300
088400     IF WS-ACTUAL-KVA > 0         AND WS-ACTUAL-KW > 0            
              PERFORM 2140-CALC-POWER-FACTOR           THRU 2140-EXIT   
088600     ELSE                                                         
088700         IF WS-ACTUAL-KVA > 0     AND WS-ACTUAL-KW = 0            
088800            PERFORM 2120-CALC-KW-UNITS           THRU 2120-EXIT   
                  PERFORM 2140-CALC-POWER-FACTOR       THRU 2140-EXIT   
088910*                                                                 00088910
089000         ELSE                                                     
089100             IF WS-ACTUAL-KVA = 0 AND WS-ACTUAL-KW > 0            
                      PERFORM 2130-CALC-KVA-UNITS      THRU 2130-EXIT   
                      PERFORM 2140-CALC-POWER-FACTOR   THRU 2140-EXIT   
089400             END-IF                                               
089500         END-IF                                                   
089600     END-IF.                                                      
089610*                                                                 00089610
089700     IF RS-KWH-USED = 0  OR RS-DAYS = 0                           
089800        MOVE ZEROES                   TO RS-LOAD-FACTOR           
089900     ELSE                                                         
089910*                                                                 00089910
090000       IF INVALID-LOAD-FACTOR                                     
090100          MOVE ZEROES                 TO RS-LOAD-FACTOR           
090200       ELSE                                                       
090210*                                                                 00090210
090300          IF RS-ACTUAL-KW > 0                                     
090400             COMPUTE RS-LOAD-FACTOR ROUNDED =                     
090500             (RS-KWH-USED / (WS-ACTUAL-KW * 24 * RS-DAYS))        
090600          ELSE                                                    
090610*                                                                 00090610
090700             IF WS-ACTUAL-KVA > 0                                 
090800                COMPUTE RS-LOAD-FACTOR ROUNDED = (RS-KWH-USED /   
090900                (WS-ACTUAL-KVA * 0.85 * 24 * RS-DAYS))            
091000             END-IF                                               
091010*                                                                 00091010
091100          END-IF                                                  
091110*                                                                 00091110
091200        END-IF                                                    
091210*                                                                 00091210
091300     END-IF.                                                      
091310*                                                                 00091310
091400     MOVE WS-ZERO                     TO WS-DEMAND-ACCUM.         
091500     MOVE WS-ZERO                     TO WS-MTR-REF-NO.           
091600     MOVE WS-NO                       TO WS-LOAD-FACTOR-SW.       
091610*                                                                 00091610
091700     IF RS-KWH-USED NOT = 0                                       
091800        COMPUTE RS-AVG-CENTS-PER-KWH =                            
091900             RS-TOTAL-REVENUE / RS-KWH-USED                       
092000     END-IF.                                                      
092010*                                                                 00092010
092200     MOVE CX-EMPLOYEE-NO              TO RS-EMPLOYEE-NO.          
092300     MOVE CX-EXCL-DMD-RCHT-IND        TO RS-EXCL-DMD-RCHT-IND.    
092400     MOVE CX-CODE-UTIL-TYPE           TO RS-CODE-UTIL-TYPE.       
092500     MOVE WS-BILL-ITEM-TIMESTMP       TO RS-BILL-ITEM-TIMESTMP.   
092600     MOVE BI-BILL-NO                  TO RS-BILL-NO.              
092700     MOVE CX-MTR-REF-NO               TO RS-MTR-REF-NO.           
092800     MOVE CX-REG-ID-NO                TO RS-REG-ID-NO.            
092900     MOVE CX-CODE-TIME-PERIOD         TO RS-CODE-TIME-PERIOD.     
093000     MOVE CX-ITEM-SEQ-NO              TO RS-ITEM-SEQ-NO.          
093100*                                                                 00093100
093200     PERFORM 2000A-MOVE-RESULT             THRU 2000A-EXIT.       
PRJ836     IF PARM-APPL-PROGRAM-ID = 'WEB'                              
PRJ836        PERFORM 2250-PROCESS-WEBMOD-CHANGES  THRU  2250-EXIT      
PRJ836     ELSE                                                         
PRJ836        PERFORM 8010-INSERT-GTT-R1           THRU  8010-EXIT      
PRJ836     END-IF.                                                      
093400     PERFORM 7120-FETCH-BI-CURSOR          THRU 7120-EXIT.        
093500                                                                  
093600 2100-EXIT.                                                       
093700     EXIT.                                                        
HPCCDM*    EJECT                                                        00093800
P00836******************************************************************00093900
P00836* 2200-PROCESS-FORMAT-CODE.                                      *00094000
P00836******************************************************************00093900
P00836*                                                                         
P00836 2200-PROCESS-FORMAT-CODE.                                        
P00836*                                                                         
P00836     IF WS-APPL-PROGRAM-ID EQUAL 'WEB'                            
P00836        MOVE '01'                           TO UV-COMPANY-NO      
P00836        MOVE 'ALL'                          TO UV-PROGRAM-ID      
P00836        MOVE 'WEB_USAGE_VIEW'               TO UV-TABLE-NA-TEXT   
P00836        MOVE '18'                           TO UV-TABLE-NA-LEN    
P00836        MOVE 'FORMAT_CD'                    TO UV-COLUMN-NA-TEXT  
P00836        MOVE '18'                           TO UV-COLUMN-NA-LEN   
P00836        PERFORM 7500-GET-CODE-SHORT-DESC       THRU 7500-EXIT     
P00836        EVALUATE WS-ACTIVE-RETURN-CODE                            
P00836          WHEN SUCCESSFUL-CALL                                    
P00836               MOVE UV-CODE-SHORT-DESC-TEXT TO S-CODE-SHORT-DESC  
P00836          WHEN NOT-FOUND                                          
P00836               MOVE SPACES                  TO S-CODE-SHORT-DESC  
P00836        END-EVALUATE                                              
P00836        PERFORM 8030-INSERT-GTT-R3             THRU 8030-EXIT     
P00836     END-IF.                                                      
P00836*                                                                         
P00836 2200-EXIT.                                                       
P00836     EXIT.                                                        
      *                                                                         
093900******************************************************************00093900
094000* 2110-PROCESS-BZ.                                               *00094000
094100*                                                                *00094100
094200*     RETRIEVE NEEDED DATA FROM BZ CURSOR.                       *00094200
094300*                                                                *00094300
094400******************************************************************00094400
094500*                                                                 00094500
094600 2110-PROCESS-BZ.                                                 
094700                                                                  
094800     IF RS-DEMAND-CALC-CODE = SPACES                              
094900        MOVE BZ-NET-UNIT-SEL-RSN      TO RS-DEMAND-CALC-CODE      
095000     END-IF.                                                      
095100*                                                                 00095100
095200     EVALUATE BZ-CONSUMPT-TYPE-CD                                 
095210*                                                                 00095210
095300         WHEN 'B'                                                 
095400            ADD BZ-BILLED-COMP-AM     TO RS-TOTAL-REVENUE         
095500            ADD BZ-READ-UNITS         TO RS-KWH-USED              
095510*                                                                 00095510
095600         WHEN 'E'                                                 
095700            ADD BZ-BILL-UNITS         TO RS-BILLED-KVA-KW         
095800            ADD BZ-BILLED-COMP-AM     TO RS-TOTAL-REVENUE         
095810*                                                                 00095810
095900         WHEN 'J'                                                 
096000            ADD BZ-BILL-UNITS         TO RS-BILLED-KVA-KW         
096100            ADD BZ-BILLED-COMP-AM     TO RS-TOTAL-REVENUE         
096110*                                                                 00096110
096200     END-EVALUATE.                                                
096300*                                                                 00096300
096400     PERFORM 7220-FETCH-BZ-CURSOR          THRU 7220-EXIT.        
096500*                                                                 00096500
096700 2110-EXIT.                                                       
096800     EXIT.                                                        
HPCCDM*    EJECT                                                        00096900
097000                                                                  
097100******************************************************************00097100
097200* 2111-PROCESS-CX.                                               *00097200
097300*                                                                *00097300
097400*     RETRIEVE NEEDED DATA FROM CX CURSOR.                       *00097400
097500*                                                                *00097500
097600******************************************************************00097600
097700*                                                                 00097700
097800 2111-PROCESS-CX.                                                 
097900                                                                  
098000      IF CX-CODE-USAGE-TYPE NOT = WS-PREV-USAGE-TYPE              
098100         MOVE 0                       TO WS-PREV-MTR-REF-NO-0     
098200         MOVE 0                       TO WS-PREV-MTR-REF-NO-1     
098300         MOVE 0                       TO WS-PREV-MTR-REF-NO-2     
098400         MOVE 0                       TO WS-PREV-MTR-REF-NO-3     
098500      END-IF.                                                     
098510*                                                                 00098510
098600      MOVE CX-CODE-USAGE-TYPE         TO WS-PREV-USAGE-TYPE       
098610*                                                                 00098610
098800      EVALUATE CX-CODE-USAGE-TYPE                                 
098810*                                                                 00098810
098900         WHEN 'B'                                                 
099000            MOVE BG-NO-OF-CONS-DAYS   TO RS-DAYS                  
099010*                                                                 00099010
099100            EVALUATE CX-CODE-TIME-PERIOD                          
099110*                                                                 00099110
099200               WHEN 1                                             
099300                  ADD CX-NO-UNITS                                 
099400                                      TO RS-ON-PEAK-KWH           
099500               WHEN 2                                             
099600                  ADD CX-NO-UNITS                                 
099700                                      TO RS-OFF-PEAK-KWH          
099800               WHEN 3                                             
099900                  ADD CX-NO-UNITS                                 
100000                                      TO RS-SHOULDER-KWH          
100010*                                                                 00100010
100100            END-EVALUATE                                          
100110*                                                                 00100110
100200         WHEN 'C'                                                 
100300            MOVE BG-NO-OF-CONS-DAYS   TO RS-DAYS                  
100310*                                                                 00100310
100400         WHEN 'J'                                                 
100410*                                                                 00100410
100500            EVALUATE CX-CODE-TIME-PERIOD                          
100510*                                                                 00100510
100600               WHEN 0                                             
100610*                                                                 00100610
100700                  IF CX-MTR-REF-NO  = WS-PREV-MTR-REF-NO-0        
100710*                                                                 00100710
100800                    IF CX-NO-DEMAND-UNITS > WS-HOLD-ACTUAL-KW     
100900                     MOVE CX-NO-DEMAND-UNITS                      
101000                                      TO WS-HOLD-ACTUAL-KW        
101100                    END-IF                                        
101110*                                                                 00101110
101200                  ELSE                                            
101300                      COMPUTE WS-HOLD-ACTUAL-KW =                 
101400                          CX-NO-DEMAND-UNITS + WS-HOLD-ACTUAL-KW  
101500                  END-IF                                          
101510*                                                                 00101510
101600                  MOVE CX-MTR-REF-NO  TO WS-PREV-MTR-REF-NO-0     
101700                  MOVE CX-METER-NO    TO WS-PREV-METER-NO         
101710*                                                                 00101710
101800               WHEN 1                                             
101810*                                                                 00101810
101900                  IF CX-MTR-REF-NO  = WS-PREV-MTR-REF-NO-1        
101910*                                                                 00101910
102000                     IF CX-NO-DEMAND-UNITS > RS-ON-PEAK-KW        
102100                        MOVE CX-NO-DEMAND-UNITS                   
102200                                      TO RS-ON-PEAK-KW            
102300                    END-IF                                        
102310*                                                                 00102310
102400                  ELSE                                            
102410*                                                                 00102410
102500                     COMPUTE RS-ON-PEAK-KW = CX-NO-DEMAND-UNITS   
102600                                             + RS-ON-PEAK-KW      
102700                  END-IF                                          
102710*                                                                 00102710
102800                  MOVE CX-MTR-REF-NO  TO WS-PREV-MTR-REF-NO-1     
102900                  MOVE CX-METER-NO    TO WS-PREV-METER-NO         
102910*                                                                 00102910
103000               WHEN 2                                             
103010*                                                                 00103010
103100                  IF CX-MTR-REF-NO  = WS-PREV-MTR-REF-NO-2        
103110*                                                                 00103110
103200                     IF CX-NO-DEMAND-UNITS > RS-OFF-PEAK-KW       
103300                        MOVE CX-NO-DEMAND-UNITS                   
103400                                      TO RS-OFF-PEAK-KW           
103500                     END-IF                                       
103510*                                                                 00103510
103600                  ELSE                                            
103700                     COMPUTE RS-OFF-PEAK-KW = CX-NO-DEMAND-UNITS  
103800                       + RS-OFF-PEAK-KW                           
103900                  END-IF                                          
103910*                                                                 00103910
104000                  MOVE CX-MTR-REF-NO  TO WS-PREV-MTR-REF-NO-2     
104100                  MOVE CX-METER-NO    TO WS-PREV-METER-NO         
104110*                                                                 00104110
104200               WHEN 3                                             
104210*                                                                 00104210
104300                  IF CX-MTR-REF-NO  = WS-PREV-MTR-REF-NO-3        
104310*                                                                 00104310
104400                     IF CX-NO-DEMAND-UNITS > RS-SHOULDER-KW       
104500                        MOVE CX-NO-DEMAND-UNITS                   
104600                                      TO RS-SHOULDER-KW           
104700                     END-IF                                       
104710*                                                                 00104710
104800                  ELSE                                            
104900                     COMPUTE RS-SHOULDER-KW = CX-NO-DEMAND-UNITS  
105000                                     + RS-SHOULDER-KW             
105100                  END-IF                                          
105110*                                                                 00105110
105200                  MOVE CX-MTR-REF-NO  TO WS-PREV-MTR-REF-NO-3     
105300                  MOVE CX-METER-NO    TO WS-PREV-METER-NO         
105400            END-EVALUATE                                          
105410*                                                                 00105410
105500         WHEN 'E'                                                 
105510*                                                                 00105510
105600            EVALUATE CX-CODE-TIME-PERIOD                          
105610*                                                                 00105610
105700               WHEN 0                                             
105710*                                                                 00105710
105800                  IF CX-MTR-REF-NO  = WS-PREV-MTR-REF-NO-0        
105810*                                                                 00105810
105900                     IF CX-NO-DEMAND-UNITS > WS-HOLD-ACTUAL-KVA   
106000                        MOVE CX-NO-DEMAND-UNITS                   
106100                                      TO WS-HOLD-ACTUAL-KVA       
106200                    END-IF                                        
106210*                                                                 00106210
106300                  ELSE                                            
106400                      COMPUTE WS-HOLD-ACTUAL-KVA =                
106500                          CX-NO-DEMAND-UNITS + WS-HOLD-ACTUAL-KVA 
106600                  END-IF                                          
106610*                                                                 00106610
106700                  MOVE CX-MTR-REF-NO  TO WS-PREV-MTR-REF-NO-0     
106800                  MOVE CX-METER-NO    TO WS-PREV-METER-NO         
106810*                                                                 00106810
106900               WHEN 1                                             
106910*                                                                 00106910
107000                  IF CX-MTR-REF-NO  = WS-PREV-MTR-REF-NO-1        
107010*                                                                 00107010
107100                    IF CX-NO-DEMAND-UNITS > RS-ON-PEAK-KVA        
107200                       MOVE CX-NO-DEMAND-UNITS                    
107300                       TO RS-ON-PEAK-KVA                          
107400                    END-IF                                        
107410*                                                                 00107410
107500                  ELSE                                            
107600                    COMPUTE RS-ON-PEAK-KVA = CX-NO-DEMAND-UNITS   
107700                                             + RS-ON-PEAK-KVA     
107800                  END-IF                                          
107810*                                                                 00107810
107900                  MOVE CX-MTR-REF-NO  TO WS-PREV-MTR-REF-NO-1     
108000                  MOVE CX-METER-NO    TO WS-PREV-METER-NO         
108010*                                                                 00108010
108100               WHEN 2                                             
108110*                                                                 00108110
108200                  IF CX-MTR-REF-NO  = WS-PREV-MTR-REF-NO-2        
108210*                                                                 00108210
108300                     IF CX-NO-DEMAND-UNITS > RS-OFF-PEAK-KVA      
108400                     MOVE CX-NO-DEMAND-UNITS                      
108500                                      TO RS-OFF-PEAK-KVA          
108600                     END-IF                                       
108610*                                                                 00108610
108700                  ELSE                                            
108800                     COMPUTE RS-OFF-PEAK-KVA = CX-NO-DEMAND-UNITS 
108900                       + RS-OFF-PEAK-KVA                          
109000                  END-IF                                          
109010*                                                                 00109010
109100                  MOVE CX-MTR-REF-NO  TO WS-PREV-MTR-REF-NO-2     
109200                  MOVE CX-METER-NO    TO WS-PREV-METER-NO         
109210*                                                                 00109210
109300               WHEN 3                                             
109310*                                                                 00109310
109400                  IF CX-MTR-REF-NO  = WS-PREV-MTR-REF-NO-3        
109410*                                                                 00109410
109500                     IF CX-NO-DEMAND-UNITS > RS-SHOULDER-KVA      
109600                        MOVE CX-NO-DEMAND-UNITS                   
109700                                      TO RS-SHOULDER-KVA          
109800                    END-IF                                        
109810*                                                                 00109810
109900                  ELSE                                            
110000                     COMPUTE RS-SHOULDER-KVA = CX-NO-DEMAND-UNITS 
110100                                     + RS-SHOULDER-KVA            
110200                  END-IF                                          
110210*                                                                 00110210
110300                  MOVE CX-MTR-REF-NO  TO WS-PREV-MTR-REF-NO-3     
110400                  MOVE CX-METER-NO    TO WS-PREV-METER-NO         
110410*                                                                 00110410
110500            END-EVALUATE                                          
110600      END-EVALUATE.                                               
110700*                                                                 00110700
110800      PERFORM 7420-FETCH-CX-CURSOR         THRU 7420-EXIT.        
110900                                                                  
111000 2111-EXIT.                                                       
111100     EXIT.                                                        
HPCCDM*    EJECT                                                        00111200
111300******************************************************************00111300
111400* 2112-BACKOUT-CX.                                               *00111400
111500*                                                                *00111500
111600*     BACKOUT NUMBER OF UNITS ORIGINALLY BILLED IN CANCEL/REBILL *00111600
111700*     SITUATIONS                                                 *00111700
111800*                                                                *00111800
111900******************************************************************00111900
112000                                                                  
112100 2112-BACKOUT-CX.                                                 
112200                                                                  
112300     EVALUATE CX-CODE-USAGE-TYPE                                  
112310*                                                                 00112310
112400         WHEN 'S'                                                 
112410*                                                                 00112410
112500            IF CX-MTR-REF-NO = WS-HOLD-MTR-REF-NO                 
112600                SUBTRACT CX-MTR-REF-NO  FROM WS-KVAR-UNITS        
112700            END-IF                                                
112710*                                                                 00112710
112800         WHEN 'B'                                                 
112810*                                                                 00112810
112900            SUBTRACT CX-NO-UNITS        FROM RS-KWH-USED          
112910*                                                                 00112910
113000         WHEN 'E'                                                 
113010*                                                                 00113010
113100         WHEN 'J'                                                 
113110*                                                                 00113110
113200            SUBTRACT CX-NO-DEMAND-UNITS FROM RS-BILLED-KVA-KW     
113230*                                                                 00113230
113300     END-EVALUATE.                                                
113310*                                                                 00113310
113400     PERFORM 7420-FETCH-CX-CURSOR          THRU 7420-EXIT.        
113500                                                                  
113600 2112-EXIT.                                                       
113700     EXIT.                                                        
HPCCDM*    EJECT                                                        00113800
113900******************************************************************00113900
114000* 2113-PROCESS-DEMAND                                            *00114000
114100*                                                                *00114100
114200*     DETERMINE IF WE HAVE A METER WITH NO DEMAND.  IF SO, WE    *00114200
114300*     CANNOT CALCULATE A VALID LOAD FACTOR.                      *00114300
114400******************************************************************00114400
114500                                                                  
114600 2113-PROCESS-DEMAND.                                             
114700*                                                                 00114700
114800     IF WS-MTR-REF-NO = 0                                         
114810*                                                                 00114810
114900        MOVE CX-MTR-REF-NO            TO WS-MTR-REF-NO            
115000        MOVE WS-ZERO                  TO WS-DEMAND-ACCUM          
115100        ADD CX-NO-DEMAND-UNITS        TO WS-DEMAND-ACCUM          
115110*                                                                 00115110
115200     ELSE                                                         
115210*                                                                 00115210
115300        IF WS-MTR-REF-NO NOT = CX-MTR-REF-NO                      
115310*                                                                 00115310
115400           IF WS-DEMAND-ACCUM = 0                                 
115500              SET INVALID-LOAD-FACTOR TO   TRUE                   
115600              MOVE NOT-FOUND          TO WS-ACTIVE-RETURN-CODE    
115600                                         WS-ACTIVE-RETURN-CD-DMD  
115700              GO TO 2113-EXIT                                     
115800           END-IF                                                 
115810*                                                                 00115810
115900           MOVE CX-MTR-REF-NO         TO WS-MTR-REF-NO            
116000           MOVE WS-ZERO               TO WS-DEMAND-ACCUM          
116100           ADD CX-NO-DEMAND-UNITS     TO WS-DEMAND-ACCUM          
116110*                                                                 00116110
116200        ELSE                                                      
116210*                                                                 00116210
116300           ADD CX-NO-DEMAND-UNITS     TO WS-DEMAND-ACCUM          
116400        END-IF                                                    
116410*                                                                 00116410
116500     END-IF.                                                      
116600                                                                  
116700     PERFORM 7316-FETCH-DEMAND-CURSOR      THRU 7316-EXIT.        
116800                                                                  
116900 2113-EXIT.                                                       
117000     EXIT.                                                        
119400******************************************************************00119400
119500* 2120-CALC-KW-UNITS.                                            *00119500
119600*                                                                *00119600
119700*     CALC KW UNITS FROM KVA AND KVAR UNITS.                     *00119700
119800*                                                                *00119800
119900******************************************************************00119900
120000                                                                  
120100 2120-CALC-KW-UNITS.                                              
120200                                                                  
120300     COMPUTE WS-ACTUAL-KW =                                       
120400         (WS-ACTUAL-KVA ** 2 - WS-KVAR-UNITS ** 2) ** 0.5.        
120500                                                                  
120600 2120-EXIT.                                                       
120700     EXIT.                                                        
HPCCDM*    EJECT                                                        00120800
      ******************************************************************        
      * 2130-CALC-KVA-UNITS.                                           *        
      *                                                                *        
      *     CALC KVA UNITS FROM KVA AND KVAR UNITS.                    *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2130-CALC-KVA-UNITS.                                             
                                                                        
           COMPUTE WS-ACTUAL-KVA =                                      
               (WS-ACTUAL-KW ** 2 - WS-KVAR-UNITS ** 2) ** 0.5.         
                                                                        
       2130-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 2140-CALC-POWER-FACTOR.                                        *        
      *                                                                *        
      *     CALC POWER FACTOR FROM KW AND KVA UNITS.                   *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2140-CALC-POWER-FACTOR.                                          
                                                                        
           IF WS-ACTUAL-KVA > 0                                         
               COMPUTE RS-POWER-FACTOR = WS-ACTUAL-KW / WS-ACTUAL-KVA   
           END-IF.                                                      
                                                                        
       2140-EXIT.                                                       
           EXIT.                                                        
PRJ836*                                                                         
PRJ836******************************************************************        
PRJ836** WEBMOD CHANGES                                               **        
PRJ836******************************************************************        
PRJ836*                                                                         
PRJ836 2250-PROCESS-WEBMOD-CHANGES.                                     
PRJ836*                                                                         
PRJ836     MOVE '2250'                       TO ACTIVE-PARAGRAPH.       
PRJ836*                                                                 00077600
PRJ836**** ACA -> CORRECTED BILL, SCA -> NON-CALC & ACK -> CANCEL-ROW           
PRJ836*                                                                         
PRJ836     IF (S-CODE-BILL-CALC     = 'A'  AND                          
PRJ836         S-CODE-BILL-ITM-TYPE = 'C'  AND                          
PRJ836         S-CODE-BILL-ITM-IND  = 'A')                              
PRJ836                      OR                                          
PRJ836        (S-CODE-BILL-CALC     = 'S'  AND                          
PRJ836         S-CODE-BILL-ITM-TYPE = 'C'  AND                          
PRJ836         S-CODE-BILL-ITM-IND  = 'A')                              
PRJ836                      OR                                          
PRJ836        (S-CODE-BILL-CALC     = 'A'  AND                          
PRJ836         S-CODE-BILL-ITM-TYPE = 'C'  AND                          
PRJ836         S-CODE-BILL-ITM-IND  = 'K')                              
PRJ836        CONTINUE                                                  
PRJ836     ELSE                                                         
PRJ836        GO TO 2250-EXIT                                           
PRJ836     END-IF.                                                      
PRJ836*                                                                         
PRJ836**** SCA -> NON-CALC: INITIALIZE REQUIRED DATA                            
PRJ836     IF S-CODE-BILL-CALC     = 'S' AND                            
PRJ836        S-CODE-BILL-ITM-TYPE = 'C' AND                            
PRJ836        S-CODE-BILL-ITM-IND  = 'A'                                
PRJ836        INITIALIZE                        S-BILL-DATE             
PRJ836                                          S-RATE-PLAN-NO          
PRJ836                                          S-RATE-PLAN-DESC        
PRJ836     END-IF.                                                      
PRJ836*                                                                         
PRJ836***  IF S-CODE-DR-CR-CNSMPTN = 'C'                                00077600
PRJ836***     COMPUTE S-TOTAL-REVENUE = S-TOTAL-REVENUE -               00077600
PRJ836***             S-AMT-STATE-TAX - S-AMT-CITY-TAX  -               00077600
PRJ836***             S-AMT-OTHER-TAX                                   00077600
PRJ836***  ELSE                                                         00077600
PRJ836***     COMPUTE S-TOTAL-REVENUE = S-TOTAL-REVENUE +               00077600
PRJ836***             S-AMT-STATE-TAX + S-AMT-CITY-TAX  +               00077600
PRJ836***             S-AMT-OTHER-TAX                                   00077600
PRJ836***     END-COMPUTE                                               00077600
PRJ836***  END-IF.                                                      00077600
PRJ836*                                                                 00077600
PRJ836     IF WS-SHOW-LATEST-BILL-FL = 'Y' AND                          
PRJ836        CTR-ROWS-RS4           =  0  AND                          
PRJ836        S-BILL-NO              >  0  AND                          
PRJ836        S-REVENUE-MONTH        >  0                               
PRJ836        MOVE S-REVENUE-MONTH           TO WS-WEB-REV-MTH-LATEST   
PRJ836        PERFORM 7950-CHECK-BILL-CRED-DATA THRU 7950-EXIT          
PRJ836        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
PRJ836           MOVE 'N'                    TO WS-SHOW-LATEST-BILL-FL  
PRJ836        END-IF                                                    
PRJ836     END-IF.                                                      
PRJ836*                                                                         
PRJ836     IF S-REV-MTH-ORIG-BILL > 0                                   
PRJ836        MOVE S-REV-MTH-ORIG-BILL       TO S-REVENUE-MONTH         
PRJ836     END-IF.                                                      
PRJ836*                                                                         
PRJ836*** HIDE LATEST REVENUE MONTH BILL(S) WHEN FLAG IS 'N'                    
PRJ836*                                                                         
PRJ836     IF WS-SHOW-LATEST-BILL-FL = 'N' AND                          
PRJ836        WS-WEB-REV-MTH-LATEST  =  S-REVENUE-MONTH                 
PRJ836        CONTINUE                                                  
PRJ836     ELSE                                                         
PRJ836        PERFORM 8040-INSERT-GTT-R4  THRU  8040-EXIT               
PRJ836     END-IF.                                                      
PRJ836*                                                                         
PRJ836 2250-EXIT.                                                       
PRJ836     EXIT.                                                        
PRJ836*                                                                         
PRJ836******************************************************************        
PRJ836** CHECK ACTIVE/IN PROGRESS WQ WITH EBILL NO DISPLAY IND SET    **        
PRJ836******************************************************************        
PRJ836*                                                                         
PRJ836 7050-CHECK-EBILL-NO-DISP-IND.                                    
PRJ836*                                                                         
PRJ836     EXEC SQL                                                     
PRJ836          SELECT TOP(1) 'N'                                              
PRJ836            INTO :WS-SHOW-LATEST-BILL-FL                          
PRJ836            FROM CSS_WQ_CATEGORY C3 WITH(READUNCOMMITTED)                 
PRJ836                ,CSS_WQ_ITEMS    WQ WITH(READUNCOMMITTED)                 
PRJ836           WHERE WQ.ACCOUNT_NO        =  :WS-ACCT-NO              
PRJ836             AND WQ.CATEGORY_ID       =   C3.CATEGORY_ID          
PRJ836             AND C3.EBILL_NO_DISP_IND =  'Y'                      
PRJ836             AND WQ.STATUS           IN ('A','I')                 
PRJ836                                       
PRJ836                                                      
PRJ836     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'N'                                                      
MFA-TR*           INTO :WS-SHOW-LATEST-BILL-FL                                  
MFA-TR*           FROM CSS_WQ_CATEGORY C3                                       
MFA-TR*               ,CSS_WQ_ITEMS    WQ                                       
MFA-TR*          WHERE WQ.ACCOUNT_NO        =  :WS-ACCT-NO                      
MFA-TR*            AND WQ.CATEGORY_ID       =   C3.CATEGORY_ID                  
MFA-TR*            AND C3.EBILL_NO_DISP_IND =  'Y'                              
MFA-TR*            AND WQ.STATUS           IN ('A','I')                         
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*         QUERYNO 7050                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PRJ836*                                                                         
PRJ836     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
PRJ836                                         S-RETURN-CODE-1.         
PRJ836*                                                                 00129500
PRJ836     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
PRJ836         CONTINUE                                                 
PRJ836     ELSE                                                         
PRJ836         MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
PRJ836         MOVE '7050'                  TO ACTIVE-PARAGRAPH         
PRJ836         MOVE 'SELECT'                TO ABEND-FUNCTION           
PRJ836         MOVE SPACES                  TO ABEND-SQL-PREDICATES     
PRJ836                                         ABEND-TABLES             
PRJ836         MOVE 'CSS_WQ_ITEMS'          TO TABLE-1                  
PRJ836         MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
PRJ836         MOVE WS-ACCT-NO              TO HOSTVAR-ELEMENT-1        
PRJ836         PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
PRJ836     END-IF.                                                      
PRJ836                                                                  
PRJ836 7050-EXIT.                                                       
PRJ836     EXIT.                                                        
PRJ836*                                                                 00131100
124000******************************************************************00124000
124100* 7100-PROCESS-BI-CURSOR                                         *00124100
124200*                                                                *00124200
124500******************************************************************00124500
124600                                                                  
124700 7100-PROCESS-BI-CURSOR.                                          
071010*                                                                *00124701
070900     PERFORM 7110-OPEN-BI-CURSOR                THRU 7110-EXIT.   
071000     PERFORM 7120-FETCH-BI-CURSOR               THRU 7120-EXIT.   
071010*                                                                *00124730
071100     PERFORM 2100-PROCESS-BILL-MONTH            THRU 2100-EXIT    
071200         UNTIL WS-ACTIVE-RETURN-CD-BI = NOT-FOUND.                
071210*                                                                *00124760
071300     PERFORM 7130-CLOSE-BI-CURSOR               THRU 7130-EXIT.   
071400*                                                                 00124780
124800                                                                  
126900 7100-EXIT.                                                       
127000     EXIT.                                                        
HPCCDM*    EJECT                                                        00127100
124000******************************************************************00127101
124100* 7200-PROCESS-BZ-CURSOR                                         *00127102
124200*                                                                *00127103
124500******************************************************************00127104
124600                                                                  
124700 7200-PROCESS-BZ-CURSOR.                                          
078400*                                                                 00127107
078200     PERFORM 7210-OPEN-BZ-CURSOR           THRU 7210-EXIT.        
078300     PERFORM 7220-FETCH-BZ-CURSOR          THRU 7220-EXIT.        
078400*                                                                 00127110
078500     IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
078510*                                                                 00127112
078600        PERFORM 7230-CLOSE-BZ-CURSOR       THRU 7230-EXIT         
078700        IF BG-CODE-BILL-CALC     = 'S' AND                        
078800           BG-CODE-BILL-ITM-TYPE = 'B'                            
078900******************************************************************00127116
079000* CANCEL REBILL                                                  *00127117
079100******************************************************************00127118
079200*                                                                 00127119
079300           PERFORM 7340-SELECT-BACKOUT-CNSMPTN                    
                                                 THRU 7340-EXIT         
079310*                                                                 00127122
079400           SUBTRACT BZ-BILLED-COMP-AM FROM                        
079500                                           RS-TOTAL-REVENUE       
079510*                                                                 00127125
079600           SUBTRACT BZ-READ-UNITS     FROM RS-KWH-USED            
079610*                                                                 00127127
079700           PERFORM 7350-SELECT-BACKOUT-DEMAND                     
                                                 THRU 7350-EXIT         
079710*                                                                 00127130
079800           SUBTRACT BZ-BILL-UNITS     FROM RS-BILLED-KVA-KW       
079900           SUBTRACT BZ-BILLED-COMP-AM FROM RS-TOTAL-REVENUE       
079910*                                                                 00127133
080000        ELSE                                                      
080100******************************************************************00127135
080200* NON CALC                                                       *00127136
080300******************************************************************00127137
080400*                                                                 00127138
080500           PERFORM 7360-SELECT-KWH-FOR-NONCALC                    
                                                 THRU 7360-EXIT         
080510*                                                                 00127141
080600           IF BG-CODE-DR-CR-CNSMPTN = 'C'                         
080610*                                                                 00127143
080700              SUBTRACT BG-AMT-BILL-ITEM  FROM RS-TOTAL-REVENUE    
080800              SUBTRACT WS-NO-UNITS       FROM RS-KWH-USED         
080810*                                                                 00127146
080900           ELSE                                                   
080810*                                                                 00127148
081000              ADD BG-AMT-BILL-ITEM    TO   RS-TOTAL-REVENUE       
081100              ADD WS-NO-UNITS         TO   RS-KWH-USED            
081110*                                                                 00127151
081200           END-IF                                                 
081300*                                                                 00127153
081400           ADD 0                      TO RS-BILLED-KVA-KW         
081410*                                                                 00127155
081500        END-IF                                                    
081510*                                                                 00127157
081600     ELSE                                                         
081610*                                                                 00127159
081700        PERFORM 2110-PROCESS-BZ            THRU 2110-EXIT         
081800                UNTIL WS-ACTIVE-RETURN-CD-BZ = NOT-FOUND          
081910*                                                                 00127162
081900        PERFORM 7230-CLOSE-BZ-CURSOR       THRU 7230-EXIT         
081910*                                                                 00127164
082000     END-IF.                                                      
124800                                                                  
126900 7200-EXIT.                                                       
127000     EXIT.                                                        
HPCCDM*    EJECT                                                        00127169
124000******************************************************************00127170
124100* 7300-PROCESS-DEMAND-CURSOR                                     *00127171
124200*                                                                *00127172
124500******************************************************************00127173
124600                                                                  
124700 7300-PROCESS-DEMAND-CURSOR.                                      
082410*                                                                 00127176
082200     PERFORM 7305-SELECT-BG-DAYS           THRU 7305-EXIT.        
082300     PERFORM 7315-OPEN-DEMAND-CURSOR       THRU 7315-EXIT.        
082400     PERFORM 7316-FETCH-DEMAND-CURSOR      THRU 7316-EXIT.        
082410*                                                                 00127180
082500     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
082410*                                                                 00127182
082600        PERFORM 2113-PROCESS-DEMAND        THRU 2113-EXIT         
082700            UNTIL WS-ACTIVE-RETURN-CD-DMD = NOT-FOUND             
082800     END-IF.                                                      
082810*                                                                 00127186
082900     PERFORM 7317-CLOSE-DEMAND-CURSOR      THRU 7317-EXIT.        
124800                                                                  
126900 7300-EXIT.                                                       
127000     EXIT.                                                        
HPCCDM*    EJECT                                                        00127191
124000******************************************************************00127192
124100* 7400-PROCESS-CX-CURSOR                                         *00127193
124200*                                                                *00127194
124500******************************************************************00127195
124600                                                                  
124700 7400-PROCESS-CX-CURSOR.                                          
083110*                                                                 00127198
083000     PERFORM 7410-OPEN-CX-CURSOR           THRU 7410-EXIT.        
083100     PERFORM 7420-FETCH-CX-CURSOR          THRU 7420-EXIT.        
083110*                                                                 00127201
083200     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
083210*                                                                 00127203
083300        MOVE WS-HOLD-DATE             TO RS-READ-DATE             
083400        MOVE CX-METER-NO              TO WS-PREV-METER-NO         
083410*                                                                 00127206
083500     ELSE                                                         
083510*                                                                 00127208
083600       PERFORM 7430-CLOSE-CX-CURSOR        THRU 7430-EXIT         
083700       PERFORM 7120-FETCH-BI-CURSOR        THRU 7120-EXIT         
083510*                                                                 00127211
083800       IF WS-ACTIVE-RETURN-CODE NOT EQUAL                         
                                            TO NOT-FOUND                
092500          MOVE WS-BILL-ITEM-TIMESTMP    TO RS-BILL-ITEM-TIMESTMP  
092600          MOVE BI-BILL-NO               TO RS-BILL-NO             
083810*                                                                 00127214
083900          PERFORM 2000A-MOVE-RESULT        THRU 2000A-EXIT        
PRJ836          IF PARM-APPL-PROGRAM-ID = 'WEB'                         
PRJ836             PERFORM 2250-PROCESS-WEBMOD-CHANGES THRU 2250-EXIT   
PRJ836          ELSE                                                    
PRJ836             PERFORM 8010-INSERT-GTT-R1          THRU 8010-EXIT   
PRJ836          END-IF                                                  
084010*                                                                 00127217
084100       ELSE                                                       
084110*                                                                 00127219
084400          MOVE NOT-FOUND              TO WS-ACTIVE-RETURN-CODE    
084410*                                                                 00127221
084500       END-IF                                                     
084510*                                                                 00127223
084600         GO TO 2100-EXIT                                          
084610*                                                                 00127225
084700     END-IF.                                                      
084610*                                                                 00127227
084900     PERFORM 2111-PROCESS-CX               THRU 2111-EXIT         
085000         UNTIL WS-ACTIVE-RETURN-CD-CX = NOT-FOUND.                
084610*                                                                 00127230
085200     PERFORM 7430-CLOSE-CX-CURSOR          THRU 7430-EXIT.        
085100*                                                                 00127232
124800                                                                  
126900 7400-EXIT.                                                       
127000     EXIT.                                                        
HPCCDM*    EJECT                                                        00127236
P00836******************************************************************        
P00836**  7500-GET-CODE-SHORT-DESC.                                   **        
P00836******************************************************************        
P00836*                                                                         
P00836 7500-GET-CODE-SHORT-DESC.                                        
P00836*                                                                         
P00836     EXEC SQL                                                     
P00836        SELECT UV.CODE_SHORT_DESC                                 
P00836          INTO :UV-CODE-SHORT-DESC                                
P00836          FROM CSS_CODE_VALUE UV                                  
P00836         WHERE UV.CODE_VALUE = :UV-CODE-VALUE                     
P00836           AND UV.COLUMN_NA  = :UV-COLUMN-NA                      
P00836           AND UV.COMPANY_NO = :UV-COMPANY-NO                     
P00836           AND UV.PROGRAM_ID = :UV-PROGRAM-ID                     
P00836           AND UV.TABLE_NA   = :UV-TABLE-NA                       
P00836     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00836*                                                                         
P00836     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
P00836                                         S-RETURN-CODE-3.         
P00836                                                                  
P00836     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00836         CONTINUE                                                 
P00836     ELSE                                                         
P00836         MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
P00836         MOVE '7500'                  TO ACTIVE-PARAGRAPH         
P00836         MOVE 'SELECT'                TO ABEND-FUNCTION           
P00836         MOVE SPACES                  TO ABEND-SQL-PREDICATES     
P00836                                        ABEND-TABLES              
P00836         MOVE 'CSS_CODE_VALUE'        TO TABLE-1                  
P00836         MOVE 'UV-CODE-SHORT-DESC'    TO TABLE-ELEMENT-1          
P00836         MOVE UV-CODE-VALUE           TO HOSTVAR-ELEMENT-1        
P00836         PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
P00836     END-IF.                                                      
P00836                                                                  
P00836*                                                                         
P00836 7500-EXIT.                                                       
P00836     EXIT.                                                        
P00836*                                                                         
124000******************************************************************00127237
124100* 7110-OPEN-BI-CURSOR                                            *00127238
124200*                                                                *00127239
124300*     OPEN BI-CURSOR; CHECK FOR SQL ERROR.                       *00127240
124400*                                                                *00127241
124500******************************************************************00127242
124600                                                                  
124700 7110-OPEN-BI-CURSOR.                                             
124800                                                                  
124900     EXEC SQL                                                     
125000         OPEN BI-CURSOR                                           
125100     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

125200                                                                  
125300     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
125310                                         S-RETURN-CODE-1.         
125400                                                                  
125500     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
125600         CONTINUE                                                 
125700     ELSE                                                         
125800         MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
125900         MOVE '7110'                  TO ACTIVE-PARAGRAPH         
126000         MOVE 'OPEN'                  TO ABEND-FUNCTION           
126100         MOVE SPACES                  TO ABEND-SQL-PREDICATES     
126200                                        ABEND-TABLES              
126300         MOVE 'CSS_BILLING_HDR'       TO TABLE-1                  
126400         MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
126500         MOVE WS-ACCT-NO              TO HOSTVAR-ELEMENT-1        
126600         PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
126700     END-IF.                                                      
126800                                                                  
126900 7110-EXIT.                                                       
127000     EXIT.                                                        
HPCCDM*    EJECT                                                        00127269
127200******************************************************************00127270
127300* 7120-FETCH-BI-CURSOR                                           *00127300
127400*                                                                *00127400
127500*     FETCH BI-CURSOR; CHECK FOR SQL ERROR.                      *00127500
127600*                                                                *00127600
127700******************************************************************00127700
127800                                                                  
127900 7120-FETCH-BI-CURSOR.                                            
128000                                                                  
128100     EXEC SQL                                                     
128200         FETCH BI-CURSOR                                          
128300            INTO :BI-BILL-NO,                                     
128400                 :BI-DATE-BILLED,                                 
128500                 :WS-HOLD-DATE,                                   
PRJ836                 :BI-CODE-BILL-TYPE,                              
128600                 :WS-BILL-ITEM-TIMESTMP,                          
128800                 :BG-AMT-BILL-ITEM,                               
128900                 :BG-CODE-BILL-CALC,                              
129000                 :BG-CODE-BILL-ITM-TYPE,                          
PRJ836                 :BG-CODE-BILL-ITM-IND,                           
PRJ821                 :BG-CODE-DR-CR-CNSMPTN,                          
PRJ821                 :BG-RATE-PLAN-NO,                                
PRJ836                 :BG-CODE-UTIL-TYPE,                              
PRJ836                 :BG-REVENUE-MONTH,                               
PRJ836                 :BG-REV-MTH-ORIG-BILL,                           
PRJ836                 :BG-AMT-STATE-TAX,                               
PRJ836                 :BG-AMT-CITY-TAX,                                
PRJ836                 :BG-AMT-OTHER-TAX                                
129200     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

129300                                                                  
129400     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CD-BI   
129410                                         WS-ACTIVE-RETURN-CODE    
129410                                         S-RETURN-CODE-1.         
129500                                                                  
129600     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
129700         CONTINUE                                                 
129800     ELSE                                                         
129900         MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
130000         MOVE '7120'                  TO ACTIVE-PARAGRAPH         
130100         MOVE 'FETCH'                 TO ABEND-FUNCTION           
130200         MOVE SPACES                  TO ABEND-SQL-PREDICATES     
130300                                         ABEND-TABLES             
130400         MOVE 'CSS_BILLING_HDR'       TO TABLE-1                  
130500         MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
130600         MOVE WS-ACCT-NO              TO HOSTVAR-ELEMENT-1        
130700         PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
130800     END-IF.                                                      
130900                                                                  
131000 7120-EXIT.                                                       
131100     EXIT.                                                        
HPCCDM*    EJECT                                                        00131200
131300******************************************************************00131300
131400* 7130-CLOSE-BI-CURSOR                                           *00131400
131500*                                                                *00131500
131600*     CLOSE BI-CURSOR; CHECK FOR SQL ERROR.                      *00131600
131700*                                                                *00131700
131800******************************************************************00131800
131900                                                                  
132000 7130-CLOSE-BI-CURSOR.                                            
132100                                                                  
132200     EXEC SQL                                                     
132300         CLOSE BI-CURSOR                                          
132400     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

132500                                                                  
132600     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
132610                     S-RETURN-CODE-1.                             
132700                                                                  
132800     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
132900         CONTINUE                                                 
133000     ELSE                                                         
133100         MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
133200         MOVE '7130'                  TO ACTIVE-PARAGRAPH         
133300         MOVE 'CLOSE'                 TO ABEND-FUNCTION           
133400         MOVE SPACES                  TO ABEND-SQL-PREDICATES     
133500                                         ABEND-TABLES             
133600         MOVE 'CSS_BILLING_HDR'       TO TABLE-1                  
133700         MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
133800         MOVE WS-ACCT-NO              TO HOSTVAR-ELEMENT-1        
133900         PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
134000     END-IF.                                                      
134100                                                                  
134200 7130-EXIT.                                                       
134300     EXIT.                                                        
HPCCDM*    EJECT                                                        00134400
134500******************************************************************00134500
134600* 7210-OPEN-BZ-CURSOR                                            *00134600
134700*                                                                *00134700
134800*     OPEN BZ-CURSOR; CHECK FOR SQL ERROR.                       *00134800
134900*                                                                *00134900
135000******************************************************************00135000
135100                                                                  
135200 7210-OPEN-BZ-CURSOR.                                             
135300                                                                  
135400     EXEC SQL                                                     
135500         OPEN BZ-CURSOR                                           
135600     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

135700                                                                  
135800     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
135810                                         S-RETURN-CODE-1.         
135900                                                                  
136000     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
136100         CONTINUE                                                 
136200     ELSE                                                         
136300         MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
136400         MOVE '7210'                  TO ACTIVE-PARAGRAPH         
136500         MOVE 'OPEN'                  TO ABEND-FUNCTION           
136600         MOVE SPACES                  TO ABEND-SQL-PREDICATES     
136700                                         ABEND-TABLES             
136800         MOVE 'CSS_BILL_CALC_DET'     TO TABLE-1                  
136900         MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
137000         MOVE 'BILL_NO'               TO TABLE-ELEMENT-2          
137100         MOVE 'IC_NO'                 TO TABLE-ELEMENT-3          
137200         MOVE WS-ACCT-NO              TO HOSTVAR-ELEMENT-1        
137300         MOVE BI-BILL-NO              TO HOSTVAR-ELEMENT-2        
137400         MOVE WS-IC-NO                TO HOSTVAR-ELEMENT-3        
137500         PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
137600     END-IF.                                                      
137700                                                                  
137800 7210-EXIT.                                                       
137900     EXIT.                                                        
HPCCDM*    EJECT                                                        00138000
138100******************************************************************00138100
138200* 7220-FETCH-BZ-CURSOR                                           *00138200
138300*                                                                *00138300
138400*     FETCH BZ-CURSOR; CHECK FOR SQL ERROR.                      *00138400
138500*                                                                *00138500
138600******************************************************************00138600
138700                                                                  
138800 7220-FETCH-BZ-CURSOR.                                            
138900                                                                  
139000     EXEC SQL                                                     
139100         FETCH BZ-CURSOR                                          
139200            INTO :BZ-BILL-ITEM-TIMESTMP,                          
139300                 :BZ-CODE-TIME-PERIOD,                            
139400                 :BZ-CODE-SEASON,                                 
139500                 :BZ-READ-UNITS,                                  
139600                 :BZ-BILL-UNITS,                                  
139700                 :BZ-CONSUMPT-TYPE-CD,                            
139800                 :BZ-NET-UNIT-SEL-RSN,                            
139900                 :BZ-BILLED-COMP-AM                               
140000     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

140100                                                                  
140200     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CD-BZ   
140210                                         WS-ACTIVE-RETURN-CODE    
140210                                         S-RETURN-CODE-1.         
140300                                                                  
140400     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
140500         CONTINUE                                                 
140600     ELSE                                                         
140700         MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
140800         MOVE '7220'                  TO ACTIVE-PARAGRAPH         
140900         MOVE 'FETCH'                 TO ABEND-FUNCTION           
141000         MOVE SPACES                  TO ABEND-SQL-PREDICATES     
141100                                         ABEND-TABLES             
141200         MOVE 'CSS_BILL_CALC_DET'     TO TABLE-1                  
141300         MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
141400         MOVE 'BILL_NO'               TO TABLE-ELEMENT-2          
141500         MOVE 'IC_NO'                 TO TABLE-ELEMENT-3          
141600         MOVE WS-ACCT-NO              TO HOSTVAR-ELEMENT-1        
141700         MOVE BI-BILL-NO              TO HOSTVAR-ELEMENT-2        
141800         MOVE WS-IC-NO                TO HOSTVAR-ELEMENT-3        
141900         PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
142000     END-IF.                                                      
142100                                                                  
142200 7220-EXIT.                                                       
142300     EXIT.                                                        
HPCCDM*    EJECT                                                        00142400
142500******************************************************************00142500
142600* 7230-CLOSE-BZ-CURSOR                                           *00142600
142700*                                                                *00142700
142800*     CLOSE BZ-CURSOR; CHECK FOR SQL ERROR.                      *00142800
142900*                                                                *00142900
143000******************************************************************00143000
143100                                                                  
143200 7230-CLOSE-BZ-CURSOR.                                            
143300                                                                  
143400     EXEC SQL                                                     
143500         CLOSE BZ-CURSOR                                          
143600     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

143700                                                                  
143800     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
143810                                         S-RETURN-CODE-1.         
143900                                                                  
144000     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
144100         CONTINUE                                                 
144200     ELSE                                                         
144300         MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
144400         MOVE '7230'                  TO ACTIVE-PARAGRAPH         
144500         MOVE 'CLOSE'                 TO ABEND-FUNCTION           
144600         MOVE SPACES                  TO ABEND-SQL-PREDICATES     
144700                                         ABEND-TABLES             
144800         MOVE 'CSS_BILL_CALC_DET'     TO TABLE-1                  
144900         MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
145000         MOVE 'BILL_NO'               TO TABLE-ELEMENT-2          
145100         MOVE 'IC_NO'                 TO TABLE-ELEMENT-3          
145200         MOVE WS-ACCT-NO              TO HOSTVAR-ELEMENT-1        
145300         MOVE BI-BILL-NO              TO HOSTVAR-ELEMENT-2        
145400         MOVE WS-IC-NO                TO HOSTVAR-ELEMENT-3        
145500         PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
145600     END-IF.                                                      
145700                                                                  
145800 7230-EXIT.                                                       
145900     EXIT.                                                        
HPCCDM*    EJECT                                                        00146000
157200******************************************************************00157200
157300* 7305-SELECT-BG-DAYS                                            *00157300
157400*                                                                *00157400
157500*     SELECT THE NO OF DAYS FROM THE BILLING DETAIL TABLE.       *00157500
157600*                                                                *00157600
157700******************************************************************00157700
157800                                                                  
157900 7305-SELECT-BG-DAYS.                                             
158000                                                                  
158100     EXEC SQL                                                     
158200             SELECT NO_OF_CONS_DAYS                               
158300               INTO :BG-NO-OF-CONS-DAYS                           
158400               FROM CSS_BILLING_DET                               
158500              WHERE ACCOUNT_NO         = :WS-ACCT-NO              
158600                AND CODE_UTIL_TYPE     = 'E'                      
158700                AND BILL_NO            = :BI-BILL-NO              
158800                AND IC_NO              = :WS-IC-NO                
158900                AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :WS-BILL-ITEM-TIMESTMP
              )   
159000                                                      
159100     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     00158100
MFA-TR*            SELECT NO_OF_CONS_DAYS                               00158200
MFA-TR*              INTO :BG-NO-OF-CONS-DAYS                           00158300
MFA-TR*              FROM CSS_BILLING_DET                               00158400
MFA-TR*             WHERE ACCOUNT_NO         = :WS-ACCT-NO              00158500
MFA-TR*               AND CODE_UTIL_TYPE     = 'E'                      00158600
MFA-TR*               AND BILL_NO            = :BI-BILL-NO              00158700
MFA-TR*               AND IC_NO              = :WS-IC-NO                00158800
MFA-TR*               AND BILL_ITEM_TIMESTMP = :WS-BILL-ITEM-TIMESTMP   00158900
MFA-TR*            QUERYNO 7305                                         00159000
MFA-TR*    END-EXEC.                                                    00159100

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

159200                                                                  
159300     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
159400                                                                  
159500     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
159600        CONTINUE                                                  
159700     ELSE                                                         
159800         MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
159900         MOVE '7305'                  TO ACTIVE-PARAGRAPH         
160000         MOVE 'SELECT'                TO ABEND-FUNCTION           
160100         MOVE SPACES                  TO ABEND-SQL-PREDICATES     
160200                                         ABEND-TABLES             
160300         MOVE 'CSS_BILLING_DET'       TO TABLE-1                  
160400         MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
160500         MOVE 'BILL_NO'               TO TABLE-ELEMENT-2          
160600         MOVE 'IC_NO'                 TO TABLE-ELEMENT-3          
160700         MOVE 'BILL_ITEM_TIMESTMP'    TO TABLE-ELEMENT-4          
160800         MOVE WS-ACCT-NO              TO HOSTVAR-ELEMENT-1        
160900         MOVE BI-BILL-NO              TO HOSTVAR-ELEMENT-2        
161000         MOVE WS-IC-NO                TO HOSTVAR-ELEMENT-3        
161100         MOVE WS-BILL-ITEM-TIMESTMP   TO HOSTVAR-ELEMENT-4        
161200         PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
161300     END-IF.                                                      
161400                                                                  
161500 7305-EXIT.                                                       
161600     EXIT.                                                        
HPCCDM*    EJECT                                                        00161700
161800******************************************************************00161800
161900* 7410-OPEN-CX-CURSOR                                            *00161900
162000*                                                                *00162000
162100*     OPEN CX-CURSOR; CHECK FOR SQL ERROR.                       *00162100
162200*                                                                *00162200
162300******************************************************************00162300
162400                                                                  
162500 7410-OPEN-CX-CURSOR.                                             
162600                                                                  
162700     EXEC SQL                                                     
162800         OPEN CX-CURSOR                                           
162900     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

163000                                                                  
163100     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
163110                                         S-RETURN-CODE-1.         
163200                                                                  
163300     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
163400        CONTINUE                                                  
163500     ELSE                                                         
163600         MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
163700         MOVE '7310'                  TO ACTIVE-PARAGRAPH         
163800         MOVE 'OPEN'                  TO ABEND-FUNCTION           
163900         MOVE SPACES                  TO ABEND-SQL-PREDICATES     
164000                                         ABEND-TABLES             
164100         MOVE 'CSS_CNSMPTN_HIST'      TO TABLE-1                  
164200         MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
164300         MOVE 'BILL_NO'               TO TABLE-ELEMENT-2          
164400         MOVE 'IC_NO'                 TO TABLE-ELEMENT-3          
164500         MOVE 'BILL_ITEM_TIMESTMP'    TO TABLE-ELEMENT-4          
164600         MOVE WS-ACCT-NO              TO HOSTVAR-ELEMENT-1        
164700         MOVE BI-BILL-NO              TO HOSTVAR-ELEMENT-2        
164800         MOVE WS-IC-NO                TO HOSTVAR-ELEMENT-3        
164900         MOVE WS-BILL-ITEM-TIMESTMP   TO HOSTVAR-ELEMENT-4        
165000         PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
165100     END-IF.                                                      
165200                                                                  
165300 7410-EXIT.                                                       
165400     EXIT.                                                        
HPCCDM*    EJECT                                                        00165500
165600******************************************************************00165600
165700* 7315-OPEN-DEMAND-CURSOR                                        *00165700
165800*                                                                *00165800
165900*     OPEN CX-CURSOR; CHECK FOR SQL ERROR.                       *00165900
166000*                                                                *00166000
166100******************************************************************00166100
166200                                                                  
166300 7315-OPEN-DEMAND-CURSOR.                                         
166400                                                                  
166500     EXEC SQL                                                     
166600         OPEN DEMAND-CURSOR                                       
166700     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

166800                                                                  
166900     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
166910                     S-RETURN-CODE-1.                             
167000                                                                  
167100     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
167200        CONTINUE                                                  
167300     ELSE                                                         
167400         MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
167500         MOVE '7315'                  TO ACTIVE-PARAGRAPH         
167600         MOVE 'OPEN'                  TO ABEND-FUNCTION           
167700         MOVE SPACES                  TO ABEND-SQL-PREDICATES     
167800                                         ABEND-TABLES             
167900         MOVE 'CSS_CNSMPTN_HIST'      TO TABLE-1                  
168000         MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
168100         MOVE 'BILL_NO'               TO TABLE-ELEMENT-2          
168200         MOVE 'IC_NO'                 TO TABLE-ELEMENT-3          
168300         MOVE 'BILL_ITEM_TIMESTMP'    TO TABLE-ELEMENT-4          
168400         MOVE WS-ACCT-NO              TO HOSTVAR-ELEMENT-1        
168500         MOVE BI-BILL-NO              TO HOSTVAR-ELEMENT-2        
168600         MOVE WS-IC-NO                TO HOSTVAR-ELEMENT-3        
168700         MOVE WS-BILL-ITEM-TIMESTMP   TO HOSTVAR-ELEMENT-4        
168800         PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
168900     END-IF.                                                      
169000                                                                  
169100 7315-EXIT.                                                       
169200     EXIT.                                                        
HPCCDM*    EJECT                                                        00169300
169400******************************************************************00169400
169500* 7316-FETCH-DEMAND-CURSOR                                       *00169500
169600*                                                                *00169600
169700*     FETCH DEMAND-CURSOR; CHECK FOR SQL ERROR.                  *00169700
169800*                                                                *00169800
169900******************************************************************00169900
170000                                                                  
170100 7316-FETCH-DEMAND-CURSOR.                                        
170200                                                                  
170300     EXEC SQL                                                     
170400         FETCH DEMAND-CURSOR                                      
170500            INTO :CX-MTR-REF-NO,                                  
170600                 :CX-CODE-USAGE-TYPE,                             
170700                 :CX-NO-DEMAND-UNITS                              
170800     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

170900                                                                  
171000     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CD-DMD  
171010                                         WS-ACTIVE-RETURN-CODE    
171010                                         S-RETURN-CODE-1.         
171100                                                                  
171200     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
171300        CONTINUE                                                  
171400     ELSE                                                         
171500         MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
171600         MOVE '7316'                  TO ACTIVE-PARAGRAPH         
171700         MOVE 'FETCH'                 TO ABEND-FUNCTION           
171800         MOVE SPACES                  TO ABEND-SQL-PREDICATES     
171900                                         ABEND-TABLES             
172000         MOVE 'CSS_CNSMPTN_HIST'      TO TABLE-1                  
172100         MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
172200         MOVE 'BILL_NO'               TO TABLE-ELEMENT-2          
172300         MOVE 'IC_NO'                 TO TABLE-ELEMENT-3          
172400         MOVE 'BILL_ITEM_TIMESTMP'    TO TABLE-ELEMENT-4          
172500         MOVE WS-ACCT-NO              TO HOSTVAR-ELEMENT-1        
172600         MOVE BI-BILL-NO              TO HOSTVAR-ELEMENT-2        
172700         MOVE WS-IC-NO                TO HOSTVAR-ELEMENT-3        
172800         MOVE WS-BILL-ITEM-TIMESTMP   TO HOSTVAR-ELEMENT-4        
172900         PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
173000     END-IF.                                                      
173100                                                                  
173200 7316-EXIT.                                                       
173300     EXIT.                                                        
HPCCDM*    EJECT                                                        00173400
173500******************************************************************00173500
173600* 7317-CLOSE-DEMAND-CURSOR                                       *00173600
173700*                                                                *00173700
173800*     CLOSE DEMAND-CURSOR; CHECK FOR SQL ERROR.                  *00173800
173900*                                                                *00173900
174000******************************************************************00174000
174100                                                                  
174200 7317-CLOSE-DEMAND-CURSOR.                                        
174300                                                                  
174400     EXEC SQL                                                     
174500         CLOSE DEMAND-CURSOR                                      
174600     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

174700                                                                  
174800     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
174810                                         S-RETURN-CODE-1.         
174900                                                                  
175000     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
175100        CONTINUE                                                  
175200     ELSE                                                         
175300         MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
175400         MOVE '7317'                  TO ACTIVE-PARAGRAPH         
175500         MOVE 'CLOSE'                 TO ABEND-FUNCTION           
175600         MOVE SPACES                  TO ABEND-SQL-PREDICATES     
175700                                         ABEND-TABLES             
175800         MOVE 'CSS_CNSMPTN_HIST'      TO TABLE-1                  
175900         MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
176000         MOVE 'BILL_NO'               TO TABLE-ELEMENT-2          
176100         MOVE 'IC_NO'                 TO TABLE-ELEMENT-3          
176200         MOVE 'BILL_ITEM_TIMESTMP'    TO TABLE-ELEMENT-4          
176300         MOVE WS-ACCT-NO              TO HOSTVAR-ELEMENT-1        
176400         MOVE BI-BILL-NO              TO HOSTVAR-ELEMENT-2        
176500         MOVE WS-IC-NO                TO HOSTVAR-ELEMENT-3        
176600         MOVE WS-BILL-ITEM-TIMESTMP   TO HOSTVAR-ELEMENT-4        
176700         PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
176800     END-IF.                                                      
176900                                                                  
177000 7317-EXIT.                                                       
177100     EXIT.                                                        
HPCCDM*    EJECT                                                        00177200
177300******************************************************************00177300
177400* 7420-FETCH-CX-CURSOR                                           *00177400
177500*                                                                *00177500
177600*     FETCH CX-CURSOR; CHECK FOR SQL ERROR.                      *00177600
177700*                                                                *00177700
177800******************************************************************00177800
177900                                                                  
178000 7420-FETCH-CX-CURSOR.                                            
178100                                                                  
178200     EXEC SQL                                                     
178300         FETCH CX-CURSOR                                          
178400            INTO :CX-MTR-REF-NO,                                  
178500                 :CX-CODE-TIME-PERIOD,                            
178600                 :CX-CODE-USAGE-TYPE,                             
178700                 :CX-DATE-READ :WS-NULL-IND,                       
178800                 :WS-HOLD-DATE :WS-NULL-IND-1,                     
178900                 :CX-METER-NO,                                    
179000                 :CX-NO-UNITS,                                    
179100                 :CX-NO-DAYS,                                     
179200                 :CX-NO-DEMAND-UNITS,                             
179300                 :CX-EMPLOYEE-NO,                                 
179400                 :CX-EXCL-DMD-RCHT-IND,                           
179500                 :CX-CODE-UTIL-TYPE,                              
179600                 :CX-BILL-ITEM-TIMESTMP,                          
179700                 :CX-BILL-NO,                                     
179800                 :CX-MTR-REF-NO,                                  
179900                 :CX-REG-ID-NO,                                   
180000                 :CX-CODE-TIME-PERIOD,                            
180100                 :CX-ITEM-SEQ-NO                                  
180200     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

180300                                                                  
180400     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CD-CX   
180410                                         WS-ACTIVE-RETURN-CODE    
180410                                         S-RETURN-CODE-1.         
180500                                                                  
180600     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
180700        CONTINUE                                                  
180800     ELSE                                                         
180900         MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
181000         MOVE '7320'                  TO ACTIVE-PARAGRAPH         
181100         MOVE 'FETCH'                 TO ABEND-FUNCTION           
181200         MOVE SPACES                  TO ABEND-SQL-PREDICATES     
181300                                         ABEND-TABLES             
181400         MOVE 'CSS_CNSMPTN_HIST'      TO TABLE-1                  
181500         MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
181600         MOVE 'BILL_NO'               TO TABLE-ELEMENT-2          
181700         MOVE 'IC_NO'                 TO TABLE-ELEMENT-3          
181800         MOVE 'BILL_ITEM_TIMESTMP'    TO TABLE-ELEMENT-4          
181900         MOVE WS-ACCT-NO              TO HOSTVAR-ELEMENT-1        
182000         MOVE BI-BILL-NO              TO HOSTVAR-ELEMENT-2        
182100         MOVE WS-IC-NO                TO HOSTVAR-ELEMENT-3        
182200         MOVE WS-BILL-ITEM-TIMESTMP   TO HOSTVAR-ELEMENT-4        
182300         PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
182400     END-IF.                                                      
182500                                                                  
182600 7420-EXIT.                                                       
182700     EXIT.                                                        
HPCCDM*    EJECT                                                        00182800
182900******************************************************************00182900
183000* 7430-CLOSE-CX-CURSOR                                           *00183000
183100*                                                                *00183100
183200*     CLOSE CX-CURSOR; CHECK FOR SQL ERROR.                      *00183200
183300*                                                                *00183300
183400******************************************************************00183400
183500                                                                  
183600 7430-CLOSE-CX-CURSOR.                                            
183700                                                                  
183800     EXEC SQL                                                     
183900         CLOSE CX-CURSOR                                          
184000     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

184100                                                                  
184200     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
184210                                         S-RETURN-CODE-1.         
184300                                                                  
184400     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
184500        CONTINUE                                                  
184600     ELSE                                                         
184700         MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
184800         MOVE '7330'                  TO ACTIVE-PARAGRAPH         
184900         MOVE 'CLOSE'                 TO ABEND-FUNCTION           
185000         MOVE SPACES                  TO ABEND-SQL-PREDICATES     
185100                                        ABEND-TABLES              
185200         MOVE 'CSS_CNSMPTN_HIST'      TO TABLE-1                  
185300         MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
185400         MOVE 'BILL_NO'               TO TABLE-ELEMENT-2          
185500         MOVE 'IC_NO'                 TO TABLE-ELEMENT-3          
185600         MOVE 'BILL_ITEM_TIMESTMP'    TO TABLE-ELEMENT-4          
185700         MOVE WS-ACCT-NO              TO HOSTVAR-ELEMENT-1        
185800         MOVE BI-BILL-NO              TO HOSTVAR-ELEMENT-2        
185900         MOVE WS-IC-NO                TO HOSTVAR-ELEMENT-3        
186000         MOVE WS-BILL-ITEM-TIMESTMP   TO HOSTVAR-ELEMENT-4        
186100         PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
186200     END-IF.                                                      
186300                                                                  
186400 7430-EXIT.                                                       
186500     EXIT.                                                        
186600******************************************************************00186600
186700*                                                                *00186700
186800* SELECT THE CSS_BILL_CALC_DET TO GET THE ORIGINAL BILL'S USAGE  *00186800
186900*                                                                *00186900
187000******************************************************************00187000
187100 7340-SELECT-BACKOUT-CNSMPTN.                                     
187200*                                                                 00187200
187300     EXEC SQL                                                     
187400          SELECT SUM(BILL_UNITS)                                  
187500                ,SUM(READ_UNITS)                                  
187600                ,SUM(BILLED_COMP_AM)                              
187700          INTO  :BZ-BILL-UNITS :WS-BILL-UNITS-NI                   
187800               ,:BZ-READ-UNITS :WS-READ-UNITS-NI                   
187900               ,:BZ-BILLED-COMP-AM :WS-BILL-COMP-NI                
188000          FROM CSS_BILL_CALC_DET                                  
188100          WHERE ACCOUNT_NO         = :WS-ACCT-NO                  
188200          AND   CODE_UTIL_TYPE     = 'E'                          
188300          AND   IC_NO              = :WS-IC-NO                    
188400          AND   CONSUMPT_TYPE_CD   = 'B'                          
188500          AND   BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :WS-BILL-ITEM-TIMESTMP
              )       
188600          AND   CMPNT_ID_CD        NOT IN ('92','93')             
188700                                                      
188800     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     00187300
MFA-TR*         SELECT SUM(BILL_UNITS)                                  00187400
MFA-TR*               ,SUM(READ_UNITS)                                  00187500
MFA-TR*               ,SUM(BILLED_COMP_AM)                              00187600
MFA-TR*         INTO  :BZ-BILL-UNITS:WS-BILL-UNITS-NI                   00187700
MFA-TR*              ,:BZ-READ-UNITS:WS-READ-UNITS-NI                   00187800
MFA-TR*              ,:BZ-BILLED-COMP-AM:WS-BILL-COMP-NI                00187900
MFA-TR*         FROM CSS_BILL_CALC_DET                                  00188000
MFA-TR*         WHERE ACCOUNT_NO         = :WS-ACCT-NO                  00188100
MFA-TR*         AND   CODE_UTIL_TYPE     = 'E'                          00188200
MFA-TR*         AND   IC_NO              = :WS-IC-NO                    00188300
MFA-TR*         AND   CONSUMPT_TYPE_CD   = 'B'                          00188400
MFA-TR*         AND   BILL_ITEM_TIMESTMP = :WS-BILL-ITEM-TIMESTMP       00188500
MFA-TR*         AND   CMPNT_ID_CD        NOT IN ('92','93')             00188600
MFA-TR*         QUERYNO 7340                                            00188700
MFA-TR*    END-EXEC.                                                    00188800

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

188900*                                                                 00188900
189000     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
189020*                                                                 00189020
189100     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
189110*                                                                 00189110
189200         IF WS-BILL-UNITS-NI < 0                                  
189300           MOVE 0                     TO BZ-BILL-UNITS            
189400         END-IF                                                   
189410*                                                                 00189410
189500         IF WS-READ-UNITS-NI < 0                                  
189600           MOVE 0                     TO BZ-READ-UNITS            
189700         END-IF                                                   
189710*                                                                 00189710
189800         IF WS-BILL-COMP-NI < 0                                   
189900           MOVE 0                     TO BZ-BILLED-COMP-AM        
190000         END-IF                                                   
190010*                                                                 00190010
190100     ELSE                                                         
190110*                                                                 00190110
190200         MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
190300         MOVE '7340'                  TO ACTIVE-PARAGRAPH         
190400         MOVE 'SELECT'                TO ABEND-FUNCTION           
190500         MOVE SPACES                  TO ABEND-SQL-PREDICATES     
190600                                        ABEND-TABLES              
190700         MOVE 'CSS_BILL_CALC_DET'     TO TABLE-1                  
190800         MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
190900         MOVE 'BILL_NO'               TO TABLE-ELEMENT-2          
191000         MOVE 'IC_NO'                 TO TABLE-ELEMENT-3          
191100         MOVE 'BILL_ITEM_TIMESTMP'    TO TABLE-ELEMENT-4          
191200         MOVE WS-ACCT-NO              TO HOSTVAR-ELEMENT-1        
191300         MOVE BI-BILL-NO              TO HOSTVAR-ELEMENT-2        
191400         MOVE WS-IC-NO                TO HOSTVAR-ELEMENT-3        
191500         MOVE WS-BILL-ITEM-TIMESTMP   TO HOSTVAR-ELEMENT-4        
191600         PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
191610*                                                                 00191610
191700     END-IF.                                                      
191800*                                                                 00191800
191900 7340-EXIT.                                                       
192000     EXIT.                                                        
192100                                                                  
192200 7350-SELECT-BACKOUT-DEMAND.                                      
192300*                                                                 00192300
192400     EXEC SQL                                                     
192500          SELECT MAX(READ_UNITS)                                  
192600                ,MAX(BILL_UNITS)                                  
192700                ,SUM(BILLED_COMP_AM)                              
192800          INTO  :BZ-READ-UNITS :WS-READ-UNITS-NI,                  
192900                :BZ-BILL-UNITS :WS-BILL-UNITS-NI                   
193000               ,:BZ-BILLED-COMP-AM :WS-BILL-COMP-NI                
193100          FROM CSS_BILL_CALC_DET                                  
193200          WHERE ACCOUNT_NO         = :WS-ACCT-NO                  
193300          AND   CODE_UTIL_TYPE     = 'E'                          
193400          AND   IC_NO              = :WS-IC-NO                    
193500          AND   CONSUMPT_TYPE_CD   IN ('E','J')                   
193600          AND   BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :WS-BILL-ITEM-TIMESTMP
              )       
193700          AND   CMPNT_ID_CD        NOT IN ('92','93')             
193800                                                      
193900     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     00192400
MFA-TR*         SELECT MAX(READ_UNITS)                                  00192500
MFA-TR*               ,MAX(BILL_UNITS)                                  00192600
MFA-TR*               ,SUM(BILLED_COMP_AM)                              00192700
MFA-TR*         INTO  :BZ-READ-UNITS:WS-READ-UNITS-NI,                  00192800
MFA-TR*               :BZ-BILL-UNITS:WS-BILL-UNITS-NI                   00192900
MFA-TR*              ,:BZ-BILLED-COMP-AM:WS-BILL-COMP-NI                00193000
MFA-TR*         FROM CSS_BILL_CALC_DET                                  00193100
MFA-TR*         WHERE ACCOUNT_NO         = :WS-ACCT-NO                  00193200
MFA-TR*         AND   CODE_UTIL_TYPE     = 'E'                          00193300
MFA-TR*         AND   IC_NO              = :WS-IC-NO                    00193400
MFA-TR*         AND   CONSUMPT_TYPE_CD   IN ('E','J')                   00193500
MFA-TR*         AND   BILL_ITEM_TIMESTMP = :WS-BILL-ITEM-TIMESTMP       00193600
MFA-TR*         AND   CMPNT_ID_CD        NOT IN ('92','93')             00193700
MFA-TR*         QUERYNO 7350                                            00193800
MFA-TR*    END-EXEC.                                                    00193900

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

194000*                                                                 00194000
194100     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
194120*                                                                 00194120
194200     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
194210*                                                                 00194210
194300         IF WS-BILL-UNITS-NI < 0                                  
194400           MOVE 0                     TO BZ-BILL-UNITS            
194500         END-IF                                                   
194510*                                                                 00194510
194600         IF WS-READ-UNITS-NI < 0                                  
194700           MOVE 0                     TO BZ-READ-UNITS            
194800         END-IF                                                   
194810*                                                                 00194810
194900         IF WS-BILL-COMP-NI < 0                                   
195000           MOVE 0                     TO BZ-BILLED-COMP-AM        
195100         END-IF                                                   
195110*                                                                 00195110
195200     ELSE                                                         
195210*                                                                 00195210
195300         MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
195400         MOVE '7340'                  TO ACTIVE-PARAGRAPH         
195500         MOVE 'SELECT'                TO ABEND-FUNCTION           
195600         MOVE SPACES                  TO ABEND-SQL-PREDICATES     
195700                                         ABEND-TABLES             
195800         MOVE 'CSS_BILL_CALC_DET'     TO TABLE-1                  
195900         MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
196000         MOVE 'BILL_NO'               TO TABLE-ELEMENT-2          
196100         MOVE 'IC_NO'                 TO TABLE-ELEMENT-3          
196200         MOVE 'BILL_ITEM_TIMESTMP'    TO TABLE-ELEMENT-4          
196300         MOVE WS-ACCT-NO              TO HOSTVAR-ELEMENT-1        
196400         MOVE BI-BILL-NO              TO HOSTVAR-ELEMENT-2        
196500         MOVE WS-IC-NO                TO HOSTVAR-ELEMENT-3        
196600         MOVE WS-BILL-ITEM-TIMESTMP   TO HOSTVAR-ELEMENT-4        
196700         PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
196710*                                                                 00196710
196800     END-IF.                                                      
196900*                                                                 00196900
197000 7350-EXIT.                                                       
197100     EXIT.                                                        
197200                                                                  
197300 7360-SELECT-KWH-FOR-NONCALC.                                     
197400*                                                                 00197400
197500     EXEC SQL                                                     
197600          SELECT SUM(NO_UNITS)                                    
197700          INTO  :WS-NO-UNITS :WS-NO-UNITS-NI                       
197800          FROM CSS_CNSMPTN_HIST                                   
197900          WHERE ACCOUNT_NO         = :WS-ACCT-NO                  
198000          AND   CODE_UTIL_TYPE     = 'E'                          
198100          AND   IC_NO              = :WS-IC-NO                    
198200          AND   CODE_USAGE_TYPE    = 'B'                          
198300          AND   CODE_USAGE_ID     = 'A'                           
198400          AND   CODE_USAGE_SOURCE = 'B'                           
198500          AND   BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :WS-BILL-ITEM-TIMESTMP
              )       
198600                                                      
198700     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     00197500
MFA-TR*         SELECT SUM(NO_UNITS)                                    00197600
MFA-TR*         INTO  :WS-NO-UNITS:WS-NO-UNITS-NI                       00197700
MFA-TR*         FROM CSS_CNSMPTN_HIST                                   00197800
MFA-TR*         WHERE ACCOUNT_NO         = :WS-ACCT-NO                  00197900
MFA-TR*         AND   CODE_UTIL_TYPE     = 'E'                          00198000
MFA-TR*         AND   IC_NO              = :WS-IC-NO                    00198100
MFA-TR*         AND   CODE_USAGE_TYPE    = 'B'                          00198200
MFA-TR*         AND   CODE_USAGE_ID     = 'A'                           00198300
MFA-TR*         AND   CODE_USAGE_SOURCE = 'B'                           00198400
MFA-TR*         AND   BILL_ITEM_TIMESTMP = :WS-BILL-ITEM-TIMESTMP       00198500
MFA-TR*         QUERYNO 7360                                            00198600
MFA-TR*    END-EXEC.                                                    00198700

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

198800*                                                                 00198800
198900     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
198910*                                                                 00198910
199000     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
199010*                                                                 00199010
199100         IF WS-NO-UNITS-NI < 0                                    
199200           MOVE 0                     TO WS-NO-UNITS              
199300         END-IF                                                   
199310*                                                                 00199310
199400     ELSE                                                         
199410*                                                                 00199410
199500         MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
199600         MOVE '7360'                  TO ACTIVE-PARAGRAPH         
199700         MOVE 'SELECT'                TO ABEND-FUNCTION           
199800         MOVE SPACES                  TO ABEND-SQL-PREDICATES     
199900                                         ABEND-TABLES             
200000         MOVE 'CSS_CNSMPTN_HIST'      TO TABLE-1                  
200100         MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
200200         MOVE 'BILL_NO'               TO TABLE-ELEMENT-2          
200300         MOVE 'IC_NO'                 TO TABLE-ELEMENT-3          
200400         MOVE 'BILL_ITEM_TIMESTMP'    TO TABLE-ELEMENT-4          
200500         MOVE WS-ACCT-NO              TO HOSTVAR-ELEMENT-1        
200600         MOVE BI-BILL-NO              TO HOSTVAR-ELEMENT-2        
200700         MOVE WS-IC-NO                TO HOSTVAR-ELEMENT-3        
200800         MOVE WS-BILL-ITEM-TIMESTMP   TO HOSTVAR-ELEMENT-4        
200900         PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
200910*                                                                 00200910
201000     END-IF.                                                      
201100*                                                                 00201100
201200 7360-EXIT.                                                       
201300     EXIT.                                                        
201400                                                                  
HPCCDM*    EJECT                                                        00201500
201510************************************************************      00201510
201520*                                                                 00201520
201530* 7550-GET-RULE-XREF-ID                                           00201530
201540*                                                                 00201540
201550************************************************************      00201550
201560 7550-GET-RULE-XREF-ID.                                           
201570                                                                  
201580     EXEC SQL                                                     
201590        SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           BUS_RULE_XREF_ID, 121), ' ', '-'), ':', '.') 
           BUS_RULE_XREF_ID                                   
201591          INTO :S-RS2-BUS-RULE-XREF-ID                            
201592          FROM CSS_BUS_RULE   R WITH(READUNCOMMITTED)                     
201593              ,CSS_BUS_RULE_XREF T WITH(READUNCOMMITTED)                  
201594         WHERE R.BUS_RULE_ID = :S-RS2-BUS-RULE-ID                 
201595           AND R.BUS_RULE_ID = T.BUS_RULE_ID                      
201596                                       
201597                                                      
201598     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     00201580
MFA-TR*       SELECT BUS_RULE_XREF_ID                                   00201590
MFA-TR*         INTO :S-RS2-BUS-RULE-XREF-ID                            00201591
MFA-TR*         FROM CSS_BUS_RULE   R                                   00201592
MFA-TR*             ,CSS_BUS_RULE_XREF T                                00201593
MFA-TR*        WHERE R.BUS_RULE_ID = :S-RS2-BUS-RULE-ID                 00201594
MFA-TR*          AND R.BUS_RULE_ID = T.BUS_RULE_ID                      00201595
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                             00201596
MFA-TR*      QUERYNO 7550                                               00201597
MFA-TR*    END-EXEC                                                     00201598

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

201599                                                                  
201600     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
201601                                                                  
201602     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
201603        CONTINUE                                                  
201604     ELSE                                                         
201605         MOVE SPACES                  TO ABEND-TABLES             
201606         MOVE SPACES                  TO ABEND-SQL-PREDICATES     
201607         MOVE '7550'                  TO ACTIVE-PARAGRAPH         
201608         MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
201609         MOVE SQLCODE                 TO ABEND-SQLCODE            
201610         MOVE SQLSTATE                TO ABEND-SQLSTATE           
201611         MOVE 'SELECT'                TO ABEND-FUNCTION           
201612         MOVE 'CSS_BUS_RULE'          TO TABLE-1                  
201613         MOVE 'BUS_RULE_ID'           TO TABLE-ELEMENT-1          
201614         MOVE S-RS2-BUS-RULE-ID       TO HOSTVAR-ELEMENT-1        
201615         PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
201616     END-IF.                                                      
201617                                                                  
201618 7550-EXIT.                                                       
201619     EXIT.                                                        
PRJ821***************************************************************           
PRJ821* 7930-GET-RATE-DESC                                          *           
PRJ821*                                                             *           
PRJ821***************************************************************           
PRJ821 7930-GET-RATE-DESC.                                              
PRJ821                                                                  
PRJ821     EXEC SQL                                                     
PRJ821        SELECT RD.RATE_DESC                                       
PRJ821          INTO :RD-RATE-DESC                                      
PRJ821          FROM CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED)                
PRJ821         WHERE RD.RATE_PLAN_NO   = :RD-RATE-PLAN-NO               
PRJ821           AND RD.CODE_UTIL_TYPE = :RD-CODE-UTIL-TYPE             
PRJ821                                                           
PRJ821                                                      
PRJ821     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RD.RATE_DESC                                               
MFA-TR*         INTO :RD-RATE-DESC                                              
MFA-TR*         FROM CSS_RATE_PLAN_DESC RD                                      
MFA-TR*        WHERE RD.RATE_PLAN_NO   = :RD-RATE-PLAN-NO                       
MFA-TR*          AND RD.CODE_UTIL_TYPE = :RD-CODE-UTIL-TYPE                     
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7930                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PRJ821                                                                  
PRJ821     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
PRJ821                                                                  
PRJ821     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
PRJ821        NEXT SENTENCE                                             
PRJ821     ELSE                                                         
PRJ821        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
PRJ821        MOVE '7930'                    TO ACTIVE-PARAGRAPH        
PRJ821        MOVE 'SELECT'                  TO ABEND-FUNCTION          
PRJ821        MOVE SPACES                    TO ABEND-SQL-PREDICATES    
PRJ821                                          ABEND-TABLES            
PRJ821        MOVE 'CSS_RATE_PLAN_DESC'      TO TABLE-1                 
PRJ821        MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-1         
PRJ821        MOVE RD-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-1       
PRJ821        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
PRJ821        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
PRJ821     END-IF.                                                      
PRJ821                                                                  
PRJ821 7930-EXIT.                                                       
PRJ821     EXIT.                                                        
201620                                                                  
P00836***************************************************************           
P00836* 7940-GET-CURRENT-RATE-PLAN.                                 *           
P00836*                                                             *           
P00836***************************************************************           
P00836 7940-GET-CURRENT-RATE-PLAN.                                      
P00836                                                                  
P00836     EXEC SQL                                                     
P00836        SELECT UT.RATE_PLAN_NO                                    
P00836          INTO :UT-RATE-PLAN-NO                                   
P00836          FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                  
P00836         WHERE UT.ACCOUNT_NO     = :UT-ACCOUNT-NO                 
P00836           AND UT.CODE_UTIL_TYPE = 'E'                            
P00836           AND UT.IC_NO          = :UT-IC-NO                      
P00836                                                           
P00836                                                      
P00836     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT UT.RATE_PLAN_NO                                            
MFA-TR*         INTO :UT-RATE-PLAN-NO                                           
MFA-TR*         FROM CSS_UTIL_ENVRNMT UT                                        
MFA-TR*        WHERE UT.ACCOUNT_NO     = :UT-ACCOUNT-NO                         
MFA-TR*          AND UT.CODE_UTIL_TYPE = 'E'                                    
MFA-TR*          AND UT.IC_NO          = :UT-IC-NO                              
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7940                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00836                                                                  
P00836     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
P00836                                                                  
P00836     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00836        NEXT SENTENCE                                             
P00836     ELSE                                                         
P00836        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
P00836        MOVE '7940'                    TO ACTIVE-PARAGRAPH        
P00836        MOVE 'SELECT'                  TO ABEND-FUNCTION          
P00836        MOVE SPACES                    TO ABEND-SQL-PREDICATES    
P00836                                          ABEND-TABLES            
P00836        MOVE 'CSS_UTIL_ENVRNMT'        TO TABLE-1                 
P00836        MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
P00836        MOVE UT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
P00836        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
P00836        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
P00836     END-IF.                                                      
P00836                                                                  
P00836 7940-EXIT.                                                       
P00836     EXIT.                                                        
P00836                                                                  
PRJ836******************************************************************        
PRJ836** CHECK DATA EXISTS FOR LATEST BILL IN BILL CRED TABLE         **        
PRJ836******************************************************************        
PRJ836*                                                                         
PRJ836 7950-CHECK-BILL-CRED-DATA.                                       
PRJ836*                                                                         
PRJ836     EXEC SQL                                                     
PRJ836          SELECT TOP(1) [1H].ACCOUNT_NO                                   
PRJ836            INTO :1H-ACCOUNT-NO                                   
PRJ836            FROM  CSS_BILL_CRED_DET [1H] WITH(READUNCOMMITTED)            
PRJ836           WHERE  [1H].ACCOUNT_NO = :WS-ACCT-NO                     
PRJ836             AND  [1H].BILL_NO    = :S-BILL-NO                      
PRJ836                                       
PRJ836                                                      
PRJ836     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT  1H.ACCOUNT_NO                                           
MFA-TR*           INTO :1H-ACCOUNT-NO                                           
MFA-TR*           FROM  CSS_BILL_CRED_DET 1H                                    
MFA-TR*          WHERE  1H.ACCOUNT_NO = :WS-ACCT-NO                             
MFA-TR*            AND  1H.BILL_NO    = :S-BILL-NO                              
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*         QUERYNO 7950                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PRJ836*                                                                         
PRJ836     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
PRJ836                                         S-RETURN-CODE-1.         
PRJ836*                                                                 00129500
PRJ836     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
PRJ836         CONTINUE                                                 
PRJ836     ELSE                                                         
PRJ836         MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
PRJ836         MOVE '7950'                  TO ACTIVE-PARAGRAPH         
PRJ836         MOVE 'SELECT'                TO ABEND-FUNCTION           
PRJ836         MOVE SPACES                  TO ABEND-SQL-PREDICATES     
PRJ836                                         ABEND-TABLES             
PRJ836         MOVE 'CSS_BILL_CRED_DET'     TO TABLE-1                  
PRJ836         MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
PRJ836         MOVE WS-ACCT-NO              TO HOSTVAR-ELEMENT-1        
PRJ836         MOVE 'BILL_NO'               TO TABLE-ELEMENT-2          
PRJ836         MOVE S-BILL-NO               TO HOSTVAR-ELEMENT-2        
PRJ836         PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
PRJ836     END-IF.                                                      
PRJ836                                                                  
PRJ836 7950-EXIT.                                                       
PRJ836     EXIT.                                                        
PRJ836*                                                                 00131100
201630******************************************************************00201630
201700*8000A-DELETE-GTT-ROWS                                           *00201700
201800******************************************************************00201800
201900 8000A-DELETE-GTT-ROWS.                                           
202000*                                                                 00202000
202100     EXEC SQL                                                     
202200         DELETE FROM #CSR04690_R1                          
202300     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     00202100
MFA-TR*        DELETE FROM SESSION.CSR04690_R1                          00202200
MFA-TR*    END-EXEC.                                                    00202300

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

202400*                                                                 00202400
202500     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
202600                                      S-RETURN-CODE-1.            
202700*                                                                 00202700
202800     EVALUATE WS-ACTIVE-RETURN-CODE                               
202900         WHEN SUCCESSFUL-CALL                                     
203000              CONTINUE                                            
203100         WHEN NOT-FOUND                                           
203200              MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
203300                                         S-RETURN-CODE-1          
203400         WHEN OTHER                                               
203500              MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
203600              MOVE SQLCODE            TO ABEND-SQLCODE            
203700              MOVE '8000A'            TO ACTIVE-PARAGRAPH         
203800              MOVE 'DELETE'           TO ABEND-FUNCTION           
203900              MOVE SPACES             TO ABEND-SQL-PREDICATES     
204000                                         ABEND-TABLES             
204100              MOVE 'CSR04690_R1'      TO TABLE-1                  
204200              MOVE SPACES             TO TABLE-ELEMENT-1          
204300              MOVE SPACES             TO HOSTVAR-ELEMENT-1        
204400              PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT         
204500     END-EVALUATE.                                                
204600*                                                                 00204600
204700 8000A-EXIT.                                                      
204800     EXIT.                                                        
204900*                                                                 00204900
205000***************************************************************** 00205000
205100*                                                               * 00205100
205200* 8000B-DEL-GTT-ROWS.                                           * 00205200
205300***************************************************************** 00205300
205400 8000B-DEL-GTT-ROWS.                                              
205500                                                                  
205600     EXEC SQL                                                     
205700         DELETE FROM #CSR04690_R2                          
205800     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     00205600
MFA-TR*        DELETE FROM SESSION.CSR04690_R2                          00205700
MFA-TR*    END-EXEC.                                                    00205800

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

205900                                                                  
206000     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
206100                                         S-RETURN-CODE-2.         
206200                                                                  
206300     EVALUATE WS-ACTIVE-RETURN-CODE                               
206400         WHEN SUCCESSFUL-CALL                                     
206500              CONTINUE                                            
206600         WHEN NOT-FOUND                                           
206700              MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
206800                                         S-RETURN-CODE-2          
206900         WHEN OTHER                                               
207000              MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
207100              MOVE SQLCODE            TO ABEND-SQLCODE            
207200              MOVE SQLSTATE           TO ABEND-SQLSTATE           
207300              MOVE '8000B'            TO ACTIVE-PARAGRAPH         
207400              MOVE 'DELETE'           TO ABEND-FUNCTION           
207500              MOVE SPACES             TO ABEND-SQL-PREDICATES     
207600                                         ABEND-TABLES             
207700              MOVE 'CSR04690_R2'      TO TABLE-1                  
207800              MOVE SPACES             TO TABLE-ELEMENT-1          
207900              MOVE SPACES             TO HOSTVAR-ELEMENT-1        
208000              PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT         
208100     END-EVALUATE.                                                
208200                                                                  
208300 8000B-EXIT.                                                      
208400      EXIT.                                                       
208500                                                                  
P00836***************************************************************** 00205000
P00836*                                                               * 00205100
P00836* 8000C-DEL-GTT-ROWS.                                           * 00205200
P00836***************************************************************** 00205300
P00836 8000C-DEL-GTT-ROWS.                                              
P00836                                                                  
P00836     EXEC SQL                                                     
P00836         DELETE FROM #CSR04690_R3                          
P00836     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     00205600
MFA-TR*        DELETE FROM SESSION.CSR04690_R3                          00205700
MFA-TR*    END-EXEC.                                                    00205800

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00836                                                                  
P00836     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
P00836                                         S-RETURN-CODE-3.         
P00836                                                                  
P00836     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00836         WHEN SUCCESSFUL-CALL                                     
P00836              CONTINUE                                            
P00836         WHEN NOT-FOUND                                           
P00836              MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
P00836                                         S-RETURN-CODE-3          
P00836         WHEN OTHER                                               
P00836              MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
P00836              MOVE SQLCODE            TO ABEND-SQLCODE            
P00836              MOVE SQLSTATE           TO ABEND-SQLSTATE           
P00836              MOVE '8000C'            TO ACTIVE-PARAGRAPH         
P00836              MOVE 'DELETE'           TO ABEND-FUNCTION           
P00836              MOVE SPACES             TO ABEND-SQL-PREDICATES     
P00836                                         ABEND-TABLES             
P00836              MOVE 'CSR04690_R3'      TO TABLE-1                  
P00836              MOVE SPACES             TO TABLE-ELEMENT-1          
P00836              MOVE SPACES             TO HOSTVAR-ELEMENT-1        
P00836              PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT         
P00836     END-EVALUATE.                                                
P00836                                                                  
P00836 8000C-EXIT.                                                      
P00836      EXIT.                                                       
P00836                                                                  
PRJ836******************************************************************00201630
PRJ836*8000D-DELETE-GTT-ROWS                                           *00201700
PRJ836******************************************************************00201800
PRJ836*                                                                 00202000
PRJ836 8000D-DELETE-GTT-ROWS.                                           
PRJ836*                                                                 00202000
PRJ836     EXEC SQL                                                     
PRJ836         DELETE FROM #CSR04690_R4                          
PRJ836     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     00202100
MFA-TR*        DELETE FROM SESSION.CSR04690_R4                          00202200
MFA-TR*    END-EXEC.                                                    00202300

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PRJ836*                                                                 00202400
PRJ836     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
PRJ836*                                                                 00202700
PRJ836     EVALUATE WS-ACTIVE-RETURN-CODE                               
PRJ836         WHEN SUCCESSFUL-CALL                                     
PRJ836              CONTINUE                                            
PRJ836         WHEN NOT-FOUND                                           
PRJ836              MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
PRJ836                                         S-RETURN-CODE-1          
PRJ836         WHEN OTHER                                               
PRJ836              MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
PRJ836              MOVE SQLCODE            TO ABEND-SQLCODE            
PRJ836              MOVE '8000D'            TO ACTIVE-PARAGRAPH         
PRJ836              MOVE 'DELETE'           TO ABEND-FUNCTION           
PRJ836              MOVE SPACES             TO ABEND-SQL-PREDICATES     
PRJ836                                         ABEND-TABLES             
PRJ836              MOVE 'CSR04690_R4'      TO TABLE-1                  
PRJ836              MOVE SPACES             TO TABLE-ELEMENT-1          
PRJ836              MOVE SPACES             TO HOSTVAR-ELEMENT-1        
PRJ836              PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT         
PRJ836     END-EVALUATE.                                                
PRJ836*                                                                 00204600
PRJ836 8000D-EXIT.                                                      
PRJ836     EXIT.                                                        
PRJ836*                                                                 00204900
208600******************************************************************00208600
208700*8010-INSERT-GTT-R1                                              *00208700
208800******************************************************************00208800
208900 8010-INSERT-GTT-R1.                                              
209000     EXEC SQL                                                     
209100          INSERT INTO #CSR04690_R1                         
209200          (    RETURN_CODE                                        
209300              ,APPL_RETURN_CODE                                   
209310              ,BILL_DATE                                          
209400              ,READ_DATE                                          
209500              ,DAYS                                               
209600              ,KWH_USED                                           
209700              ,ACTUAL_KW                                          
209800              ,ACTUAL_KVA                                         
209900              ,BILLED_KVA_KW                                      
210000              ,DEMAND_CALC_CODE                                   
210100              ,TOTAL_REVENUE                                      
210200              ,LOAD_FACTOR                                        
210300              ,POWER_FACTOR                                       
210400              ,AVG_CENTS_PER_KWH                                  
210500              ,ON_PEAK_KWH                                        
210600              ,OFF_PEAK_KWH                                       
210700              ,SHOULDER_KWH                                       
210800              ,ON_PEAK_KW                                         
210900              ,OFF_PEAK_KW                                        
211000              ,SHOULDER_KW                                        
211100              ,ON_PEAK_KVA                                        
211200              ,OFF_PEAK_KVA                                       
211300              ,SHOULDER_KVA                                       
211400              ,EMPL                                               
211500              ,EXCL_DMD_RCHT_IND                                  
211600              ,CODE_UTIL_TYPE                                     
211700              ,BILL_ITEM_TIMESTMP                                 
211800              ,BILL_NO                                            
211900              ,MTR_REF_NO                                         
212000              ,REG_ID_NO                                          
212100              ,CODE_TIME_PERIOD                                   
212200              ,ITEM_SEQ_NO                                        
PRJ821              ,RATE_PLAN_NO                                       
PRJ821              ,RATE_PLAN_DESC                                     
PRJ836              ,REVENUE_MONTH                                      
212300          )                                                       
212400          VALUES                                                  
212500          (   :S-RETURN-CODE-1                                    
212600             ,:S-APPL-RETURN-CODE-1                               
212610             ,:S-BILL-DATE                                        
212700             ,:S-READ-DATE                                        
212800             ,:S-DAYS                                             
212900             ,:S-KWH-USED                                         
213000             ,:S-ACTUAL-KW                                        
213100             ,:S-ACTUAL-KVA                                       
213200             ,:S-BILLED-KVA-KW                                    
213300             ,:S-DEMAND-CALC-CODE                                 
213400             ,:S-TOTAL-REVENUE                                    
213500             ,:S-LOAD-FACTOR                                      
213600             ,:S-POWER-FACTOR                                     
213700             ,:S-AVG-CENTS-PER-KWH                                
213800             ,:S-ON-PEAK-KWH                                      
213900             ,:S-OFF-PEAK-KWH                                     
214000             ,:S-SHOULDER-KWH                                     
214100             ,:S-ON-PEAK-KW                                       
214200             ,:S-OFF-PEAK-KW                                      
214300             ,:S-SHOULDER-KW                                      
214400             ,:S-ON-PEAK-KVA                                      
214500             ,:S-OFF-PEAK-KVA                                     
214600             ,:S-SHOULDER-KVA                                     
214700             ,:S-EMPLOYEE-NO                                      
214800             ,:S-EXCL-DMD-RCHT-IND                                
214900             ,:S-CODE-UTIL-TYPE                                   
215000             ,:S-BILL-ITEM-TIMESTMP                               
215100             ,:S-BILL-NO                                          
215200             ,:S-MTR-REF-NO                                       
215300             ,:S-REG-ID-NO                                        
215400             ,:S-CODE-TIME-PERIOD                                 
215500             ,:S-ITEM-SEQ-NO                                      
PRJ821             ,:S-RATE-PLAN-NO                                     
PRJ821             ,:S-RATE-PLAN-DESC                                   
PRJ836             ,:S-REVENUE-MONTH                                    
215600          )                                                       
215700     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     00209000
MFA-TR*         INSERT INTO SESSION.CSR04690_R1                         00209100
MFA-TR*         (    RETURN_CODE                                        00209200
MFA-TR*             ,APPL_RETURN_CODE                                   00209300
MFA-TR*             ,BILL_DATE                                          00209310
MFA-TR*             ,READ_DATE                                          00209400
MFA-TR*             ,DAYS                                               00209500
MFA-TR*             ,KWH_USED                                           00209600
MFA-TR*             ,ACTUAL_KW                                          00209700
MFA-TR*             ,ACTUAL_KVA                                         00209800
MFA-TR*             ,BILLED_KVA_KW                                      00209900
MFA-TR*             ,DEMAND_CALC_CODE                                   00210000
MFA-TR*             ,TOTAL_REVENUE                                      00210100
MFA-TR*             ,LOAD_FACTOR                                        00210200
MFA-TR*             ,POWER_FACTOR                                       00210300
MFA-TR*             ,AVG_CENTS_PER_KWH                                  00210400
MFA-TR*             ,ON_PEAK_KWH                                        00210500
MFA-TR*             ,OFF_PEAK_KWH                                       00210600
MFA-TR*             ,SHOULDER_KWH                                       00210700
MFA-TR*             ,ON_PEAK_KW                                         00210800
MFA-TR*             ,OFF_PEAK_KW                                        00210900
MFA-TR*             ,SHOULDER_KW                                        00211000
MFA-TR*             ,ON_PEAK_KVA                                        00211100
MFA-TR*             ,OFF_PEAK_KVA                                       00211200
MFA-TR*             ,SHOULDER_KVA                                       00211300
MFA-TR*             ,EMPL                                               00211400
MFA-TR*             ,EXCL_DMD_RCHT_IND                                  00211500
MFA-TR*             ,CODE_UTIL_TYPE                                     00211600
MFA-TR*             ,BILL_ITEM_TIMESTMP                                 00211700
MFA-TR*             ,BILL_NO                                            00211800
MFA-TR*             ,MTR_REF_NO                                         00211900
MFA-TR*             ,REG_ID_NO                                          00212000
MFA-TR*             ,CODE_TIME_PERIOD                                   00212100
MFA-TR*             ,ITEM_SEQ_NO                                        00212200
MFA-TR*             ,RATE_PLAN_NO                                       00212100
MFA-TR*             ,RATE_PLAN_DESC                                     00212100
MFA-TR*             ,REVENUE_MONTH                                              
MFA-TR*         )                                                       00212300
MFA-TR*         VALUES                                                  00212400
MFA-TR*         (   :S-RETURN-CODE-1                                    00212500
MFA-TR*            ,:S-APPL-RETURN-CODE-1                               00212600
MFA-TR*            ,:S-BILL-DATE                                        00212610
MFA-TR*            ,:S-READ-DATE                                        00212700
MFA-TR*            ,:S-DAYS                                             00212800
MFA-TR*            ,:S-KWH-USED                                         00212900
MFA-TR*            ,:S-ACTUAL-KW                                        00213000
MFA-TR*            ,:S-ACTUAL-KVA                                       00213100
MFA-TR*            ,:S-BILLED-KVA-KW                                    00213200
MFA-TR*            ,:S-DEMAND-CALC-CODE                                 00213300
MFA-TR*            ,:S-TOTAL-REVENUE                                    00213400
MFA-TR*            ,:S-LOAD-FACTOR                                      00213500
MFA-TR*            ,:S-POWER-FACTOR                                     00213600
MFA-TR*            ,:S-AVG-CENTS-PER-KWH                                00213700
MFA-TR*            ,:S-ON-PEAK-KWH                                      00213800
MFA-TR*            ,:S-OFF-PEAK-KWH                                     00213900
MFA-TR*            ,:S-SHOULDER-KWH                                     00214000
MFA-TR*            ,:S-ON-PEAK-KW                                       00214100
MFA-TR*            ,:S-OFF-PEAK-KW                                      00214200
MFA-TR*            ,:S-SHOULDER-KW                                      00214300
MFA-TR*            ,:S-ON-PEAK-KVA                                      00214400
MFA-TR*            ,:S-OFF-PEAK-KVA                                     00214500
MFA-TR*            ,:S-SHOULDER-KVA                                     00214600
MFA-TR*            ,:S-EMPLOYEE-NO                                      00214700
MFA-TR*            ,:S-EXCL-DMD-RCHT-IND                                00214800
MFA-TR*            ,:S-CODE-UTIL-TYPE                                   00214900
MFA-TR*            ,:S-BILL-ITEM-TIMESTMP                               00215000
MFA-TR*            ,:S-BILL-NO                                          00215100
MFA-TR*            ,:S-MTR-REF-NO                                       00215200
MFA-TR*            ,:S-REG-ID-NO                                        00215300
MFA-TR*            ,:S-CODE-TIME-PERIOD                                 00215400
MFA-TR*            ,:S-ITEM-SEQ-NO                                      00215500
MFA-TR*            ,:S-RATE-PLAN-NO                                     00215500
MFA-TR*            ,:S-RATE-PLAN-DESC                                   00215500
MFA-TR*            ,:S-REVENUE-MONTH                                            
MFA-TR*         )                                                       00215600
MFA-TR*    END-EXEC.                                                    00215700

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

215800      MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.   
215900*                                                                 00215900
216000      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR               
216100                                 WS-ERR-INSRT-R1 = WS-YES         
216200         ADD +1                       TO CTR-ROWS-RS1             
216300      ELSE                                                        
216400         MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
216500         MOVE SQLCODE                 TO ABEND-SQLCODE            
216600         MOVE '8010'                  TO ACTIVE-PARAGRAPH         
216700         MOVE 'INSERT'                TO ABEND-FUNCTION           
216700         MOVE WS-YES                  TO  WS-ERR-INSRT-R1         
216800         MOVE SPACES                  TO ABEND-SQL-PREDICATES     
216900                                         ABEND-TABLES             
217000         MOVE 'CSR04690_R1'           TO TABLE-1                  
217100         MOVE SPACES                  TO TABLE-ELEMENT-1          
217200         MOVE SPACES                  TO HOSTVAR-ELEMENT-1        
217300         PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT         
217400     END-IF.                                                      
217500*                                                                 00217500
217600 8010-EXIT.                                                       
217700     EXIT.                                                        
217800*                                                                 00217800
217900******************************************************************00217900
218000*                                                                *00218000
218100* 8020-INSERT-GTT-R2.                                            *00218100
218200******************************************************************00218200
218300 8020-INSERT-GTT-R2.                                              
218400                                                                  
218500     EXEC SQL                                                     
218600        INSERT INTO #CSR04690_R2                           
218700           (                                                      
218800             RETURN_CODE                                          
218900            ,APPL_RETURN_CODE                                     
219000            ,BUS_RULE_ID                                          
219100            ,BUS_RULE_RESULT_CD                                   
219200            ,BUS_RULE_XREF_ID                                     
219300           )                                                      
219400        VALUES                                                    
219500           (                                                      
219600             :S-RETURN-CODE-2                                     
219700            ,:S-APPL-RETURN-CODE-2                                
219800            ,:S-RS2-BUS-RULE-ID                                   
219900            ,:S-RS2-BUS-RULE-RESULT-CD                            
220000            ,:S-RS2-BUS-RULE-XREF-ID                              
220100           )                                                      
220200     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     00218500
MFA-TR*       INSERT INTO SESSION.CSR04690_R2                           00218600
MFA-TR*          (                                                      00218700
MFA-TR*            RETURN_CODE                                          00218800
MFA-TR*           ,APPL_RETURN_CODE                                     00218900
MFA-TR*           ,BUS_RULE_ID                                          00219000
MFA-TR*           ,BUS_RULE_RESULT_CD                                   00219100
MFA-TR*           ,BUS_RULE_XREF_ID                                     00219200
MFA-TR*          )                                                      00219300
MFA-TR*       VALUES                                                    00219400
MFA-TR*          (                                                      00219500
MFA-TR*            :S-RETURN-CODE-2                                     00219600
MFA-TR*           ,:S-APPL-RETURN-CODE-2                                00219700
MFA-TR*           ,:S-RS2-BUS-RULE-ID                                   00219800
MFA-TR*           ,:S-RS2-BUS-RULE-RESULT-CD                            00219900
MFA-TR*           ,:S-RS2-BUS-RULE-XREF-ID                              00220000
MFA-TR*          )                                                      00220100
MFA-TR*    END-EXEC.                                                    00220200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

220300                                                                  
220400     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
220500                                         S-RETURN-CODE-2.         
220600                                                                  
220700     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
220800                                WS-ERR-INSRT-R2 = WS-YES          
220900        ADD +1                        TO  CTR-ROWS-RS2            
221000     ELSE                                                         
221100        MOVE PROGRAM-NAME             TO  ABEND-PROGRAM           
221200        MOVE '8020'                   TO  ACTIVE-PARAGRAPH        
221300        MOVE SQLCODE                  TO  ABEND-SQLCODE           
221400        MOVE 'INSERT'                 TO  ABEND-FUNCTION          
221500        MOVE WS-YES                   TO  WS-ERR-INSRT-R2         
221600        MOVE SPACES                   TO  ABEND-SQL-PREDICATES    
221700                                          ABEND-TABLES            
221800        MOVE 'CSR04690_R2'            TO  TABLE-1                 
221900        MOVE SPACES                   TO  TABLE-ELEMENT-1         
222000        MOVE SPACES                   TO  HOSTVAR-ELEMENT-1       
222100        PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
222200     END-IF.                                                      
222300                                                                  
222400  8020-EXIT.                                                      
222500      EXIT.                                                       
222600                                                                  
P00836******************************************************************00217900
P00836*                                                                *00218000
P00836* 8030-INSERT-GTT-R3.                                            *00218100
P00836******************************************************************00218200
P00836 8030-INSERT-GTT-R3.                                              
P00836                                                                  
P00836     EXEC SQL                                                     
P00836        INSERT INTO #CSR04690_R3                           
P00836           (                                                      
P00836             RETURN_CODE                                          
P00836            ,APPL_RETURN_CODE                                     
P00836            ,CODE_SHORT_DESC                                      
P00836           )                                                      
P00836        VALUES                                                    
P00836           (                                                      
P00836             :S-RETURN-CODE-3                                     
P00836            ,:S-APPL-RETURN-CODE-3                                
P00836            ,:S-CODE-SHORT-DESC                                   
P00836           )                                                      
P00836     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     00218500
MFA-TR*       INSERT INTO SESSION.CSR04690_R3                           00218600
MFA-TR*          (                                                      00218700
MFA-TR*            RETURN_CODE                                          00218800
MFA-TR*           ,APPL_RETURN_CODE                                     00218900
MFA-TR*           ,CODE_SHORT_DESC                                      00219000
MFA-TR*          )                                                      00219300
MFA-TR*       VALUES                                                    00219400
MFA-TR*          (                                                      00219500
MFA-TR*            :S-RETURN-CODE-3                                     00219600
MFA-TR*           ,:S-APPL-RETURN-CODE-3                                00219700
MFA-TR*           ,:S-CODE-SHORT-DESC                                   00219800
MFA-TR*          )                                                      00220100
MFA-TR*    END-EXEC.                                                    00220200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00836                                                                  
P00836     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
P00836                                         S-RETURN-CODE-3.         
P00836                                                                  
P00836     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
P00836                                WS-ERR-INSRT-R3 = WS-YES          
P00836        ADD +1                        TO  CTR-ROWS-RS3            
P00836     ELSE                                                         
P00836        MOVE PROGRAM-NAME             TO  ABEND-PROGRAM           
P00836        MOVE '8030'                   TO  ACTIVE-PARAGRAPH        
P00836        MOVE SQLCODE                  TO  ABEND-SQLCODE           
P00836        MOVE 'INSERT'                 TO  ABEND-FUNCTION          
P00836        MOVE WS-YES                   TO  WS-ERR-INSRT-R3         
P00836        MOVE SPACES                   TO  ABEND-SQL-PREDICATES    
P00836                                          ABEND-TABLES            
P00836        MOVE 'CSR04690_R3'            TO  TABLE-1                 
P00836        MOVE SPACES                   TO  TABLE-ELEMENT-1         
P00836        MOVE SPACES                   TO  HOSTVAR-ELEMENT-1       
P00836        PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
P00836     END-IF.                                                      
P00836                                                                  
P00836  8030-EXIT.                                                      
P00836      EXIT.                                                       
P00836                                                                  
PRJ836******************************************************************00208600
PRJ836*8040-INSERT-GTT-R4                                              *00208700
PRJ836******************************************************************00208800
PRJ836*                                                                 00208800
PRJ836 8040-INSERT-GTT-R4.                                              
PRJ836*                                                                 00208800
PRJ836     EXEC SQL                                                     
PRJ836          INSERT INTO #CSR04690_R4                         
PRJ836          (    RETURN_CODE                                        
PRJ836              ,APPL_RETURN_CODE                                   
PRJ836              ,CODE_UTIL_TYPE                                     
PRJ836              ,BILL_DATE                                          
PRJ836              ,CODE_BILL_TYPE                                     
PRJ836              ,REVENUE_MONTH                                      
PRJ836              ,CODE_BILL_CALC                                     
PRJ836              ,CODE_BILL_ITM_TYPE                                 
PRJ836              ,CODE_BILL_ITM_IND                                  
PRJ836              ,TOTAL_REVENUE                                      
PRJ836              ,READ_DATE                                          
PRJ836              ,DAYS                                               
PRJ836              ,KWH_USED                                           
PRJ836              ,ACTUAL_KW                                          
PRJ836              ,ACTUAL_KVA                                         
PRJ836              ,BILLED_KVA_KW                                      
PRJ836              ,ON_PEAK_KWH                                        
PRJ836              ,ON_PEAK_KW                                         
PRJ836              ,ON_PEAK_KVA                                        
PRJ836              ,OFF_PEAK_KWH                                       
PRJ836              ,OFF_PEAK_KW                                        
PRJ836              ,OFF_PEAK_KVA                                       
PRJ836              ,SHOULDER_KWH                                       
PRJ836              ,SHOULDER_KW                                        
PRJ836              ,SHOULDER_KVA                                       
PRJ836              ,LOAD_FACTOR                                        
PRJ836              ,POWER_FACTOR                                       
PRJ836              ,RATE_PLAN_NO                                       
PRJ836              ,RATE_PLAN_DESC                                     
PRJ836          )                                                       
PRJ836          VALUES                                                  
PRJ836          (   :S-RETURN-CODE-1                                    
PRJ836             ,:S-APPL-RETURN-CODE-1                               
PRJ836             ,:S-CODE-UTIL-TYPE                                   
PRJ836             ,:S-BILL-DATE                                        
PRJ836             ,:S-CODE-BILL-TYPE                                   
PRJ836             ,:S-REVENUE-MONTH                                    
PRJ836             ,:S-CODE-BILL-CALC                                   
PRJ836             ,:S-CODE-BILL-ITM-TYPE                               
PRJ836             ,:S-CODE-BILL-ITM-IND                                
PRJ836             ,:S-TOTAL-REVENUE                                    
PRJ836             ,:S-READ-DATE                                        
PRJ836             ,:S-DAYS                                             
PRJ836             ,:S-KWH-USED                                         
PRJ836             ,:S-ACTUAL-KW                                        
PRJ836             ,:S-ACTUAL-KVA                                       
PRJ836             ,:S-BILLED-KVA-KW                                    
PRJ836             ,:S-ON-PEAK-KWH                                      
PRJ836             ,:S-ON-PEAK-KW                                       
PRJ836             ,:S-ON-PEAK-KVA                                      
PRJ836             ,:S-OFF-PEAK-KWH                                     
PRJ836             ,:S-OFF-PEAK-KW                                      
PRJ836             ,:S-OFF-PEAK-KVA                                     
PRJ836             ,:S-SHOULDER-KWH                                     
PRJ836             ,:S-SHOULDER-KW                                      
PRJ836             ,:S-SHOULDER-KVA                                     
PRJ836             ,:S-LOAD-FACTOR                                      
PRJ836             ,:S-POWER-FACTOR                                     
PRJ836             ,:S-RATE-PLAN-NO                                     
PRJ836             ,:S-RATE-PLAN-DESC                                   
PRJ836          )                                                       
PRJ836     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     00209000
MFA-TR*         INSERT INTO SESSION.CSR04690_R4                         00209100
MFA-TR*         (    RETURN_CODE                                        00209200
MFA-TR*             ,APPL_RETURN_CODE                                   00209300
MFA-TR*             ,CODE_UTIL_TYPE                                     00209310
MFA-TR*             ,BILL_DATE                                          00209400
MFA-TR*             ,CODE_BILL_TYPE                                             
MFA-TR*             ,REVENUE_MONTH                                      00209500
MFA-TR*             ,CODE_BILL_CALC                                     00209600
MFA-TR*             ,CODE_BILL_ITM_TYPE                                 00209700
MFA-TR*             ,CODE_BILL_ITM_IND                                  00209800
MFA-TR*             ,TOTAL_REVENUE                                      00209900
MFA-TR*             ,READ_DATE                                          00210100
MFA-TR*             ,DAYS                                               00210200
MFA-TR*             ,KWH_USED                                           00210300
MFA-TR*             ,ACTUAL_KW                                          00210400
MFA-TR*             ,ACTUAL_KVA                                         00210500
MFA-TR*             ,BILLED_KVA_KW                                      00210600
MFA-TR*             ,ON_PEAK_KWH                                        00210700
MFA-TR*             ,ON_PEAK_KW                                         00210800
MFA-TR*             ,ON_PEAK_KVA                                        00210900
MFA-TR*             ,OFF_PEAK_KWH                                       00211000
MFA-TR*             ,OFF_PEAK_KW                                        00211100
MFA-TR*             ,OFF_PEAK_KVA                                       00211200
MFA-TR*             ,SHOULDER_KWH                                       00211300
MFA-TR*             ,SHOULDER_KW                                        00211400
MFA-TR*             ,SHOULDER_KVA                                       00211500
MFA-TR*             ,LOAD_FACTOR                                        00211600
MFA-TR*             ,POWER_FACTOR                                       00211700
MFA-TR*             ,RATE_PLAN_NO                                       00211800
MFA-TR*             ,RATE_PLAN_DESC                                     00211900
MFA-TR*         )                                                       00212300
MFA-TR*         VALUES                                                  00212400
MFA-TR*         (   :S-RETURN-CODE-1                                    00212500
MFA-TR*            ,:S-APPL-RETURN-CODE-1                               00212600
MFA-TR*            ,:S-CODE-UTIL-TYPE                                   00214900
MFA-TR*            ,:S-BILL-DATE                                        00212610
MFA-TR*            ,:S-CODE-BILL-TYPE                                   00212610
MFA-TR*            ,:S-REVENUE-MONTH                                            
MFA-TR*            ,:S-CODE-BILL-CALC                                           
MFA-TR*            ,:S-CODE-BILL-ITM-TYPE                                       
MFA-TR*            ,:S-CODE-BILL-ITM-IND                                        
MFA-TR*            ,:S-TOTAL-REVENUE                                    00213400
MFA-TR*            ,:S-READ-DATE                                        00212700
MFA-TR*            ,:S-DAYS                                             00212800
MFA-TR*            ,:S-KWH-USED                                         00212900
MFA-TR*            ,:S-ACTUAL-KW                                        00213000
MFA-TR*            ,:S-ACTUAL-KVA                                       00213100
MFA-TR*            ,:S-BILLED-KVA-KW                                    00213200
MFA-TR*            ,:S-ON-PEAK-KWH                                      00213800
MFA-TR*            ,:S-ON-PEAK-KW                                       00214100
MFA-TR*            ,:S-ON-PEAK-KVA                                      00214400
MFA-TR*            ,:S-OFF-PEAK-KWH                                     00213900
MFA-TR*            ,:S-OFF-PEAK-KW                                      00214200
MFA-TR*            ,:S-OFF-PEAK-KVA                                     00214500
MFA-TR*            ,:S-SHOULDER-KWH                                     00214000
MFA-TR*            ,:S-SHOULDER-KW                                      00214300
MFA-TR*            ,:S-SHOULDER-KVA                                     00214600
MFA-TR*            ,:S-LOAD-FACTOR                                      00213500
MFA-TR*            ,:S-POWER-FACTOR                                     00213600
MFA-TR*            ,:S-RATE-PLAN-NO                                     00215500
MFA-TR*            ,:S-RATE-PLAN-DESC                                   00215500
MFA-TR*         )                                                       00215600
MFA-TR*    END-EXEC.                                                    00215700

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PRJ836      MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.   
PRJ836*                                                                 00215900
PRJ836      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
PRJ836         ADD +1                       TO CTR-ROWS-RS4             
PRJ836      ELSE                                                        
PRJ836         MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
PRJ836         MOVE SQLCODE                 TO ABEND-SQLCODE            
PRJ836         MOVE '8040'                  TO ACTIVE-PARAGRAPH         
PRJ836         MOVE 'INSERT'                TO ABEND-FUNCTION           
PRJ836         MOVE WS-YES                  TO  WS-ERR-INSRT-R1         
PRJ836         MOVE SPACES                  TO ABEND-SQL-PREDICATES     
PRJ836                                         ABEND-TABLES             
PRJ836         MOVE 'CSR04690_R4'           TO TABLE-1                  
PRJ836         MOVE SPACES                  TO TABLE-ELEMENT-1          
PRJ836         MOVE SPACES                  TO HOSTVAR-ELEMENT-1        
PRJ836         PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT         
PRJ836     END-IF.                                                      
PRJ836*                                                                 00217500
PRJ836 8040-EXIT.                                                       
PRJ836     EXIT.                                                        
PRJ836*                                                                 00217800
PRJ836******************************************************************        
PRJ836** DELETE CANCEL ROWS IF CORRECT BILL ROW EXISTS                **        
PRJ836******************************************************************        
PRJ836*                                                                         
PRJ836 8100-DELETE-CANCEL-ROWS-R4.                                      
PRJ836*                                                                         
PRJ836      EXEC SQL                                                    
PRJ836          DELETE                                                  
PRJ836            FROM T1                            
                FROM #CSR04690_R4 T1
PRJ836           WHERE T1.CODE_BILL_CALC     = 'A'                      
PRJ836             AND T1.CODE_BILL_ITM_TYPE = 'C'                      
PRJ836             AND T1.CODE_BILL_ITM_IND  = 'K'                      
PRJ836             AND EXISTS                                           
PRJ836                (SELECT 1                                         
PRJ836                   FROM #CSR04690_R4 T2                    
PRJ836                  WHERE T2.REVENUE_MONTH      = T1.REVENUE_MONTH  
PRJ836                    AND T2.CODE_BILL_CALC     = 'A'               
PRJ836                    AND T2.CODE_BILL_ITM_TYPE = 'C'               
PRJ836                    AND T2.CODE_BILL_ITM_IND  = 'A')              
PRJ836      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE                                                          
MFA-TR*           FROM SESSION.CSR04690_R4  T1                                  
MFA-TR*          WHERE T1.CODE_BILL_CALC     = 'A'                              
MFA-TR*            AND T1.CODE_BILL_ITM_TYPE = 'C'                              
MFA-TR*            AND T1.CODE_BILL_ITM_IND  = 'K'                              
MFA-TR*            AND EXISTS                                                   
MFA-TR*               (SELECT 1                                                 
MFA-TR*                  FROM SESSION.CSR04690_R4 T2                            
MFA-TR*                 WHERE T2.REVENUE_MONTH      = T1.REVENUE_MONTH          
MFA-TR*                   AND T2.CODE_BILL_CALC     = 'A'                       
MFA-TR*                   AND T2.CODE_BILL_ITM_TYPE = 'C'                       
MFA-TR*                   AND T2.CODE_BILL_ITM_IND  = 'A')                      
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PRJ836*                                                                         
PRJ836      MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.      
PRJ836*                                                                         
PRJ836      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
PRJ836          CONTINUE                                                
PRJ836      ELSE                                                        
PRJ836         MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
PRJ836         MOVE SQLCODE                 TO ABEND-SQLCODE            
PRJ836         MOVE '8100'                  TO ACTIVE-PARAGRAPH         
PRJ836         MOVE 'INSERT'                TO ABEND-FUNCTION           
PRJ836         MOVE WS-YES                  TO WS-ERR-INSRT-R1          
PRJ836         MOVE SPACES                  TO ABEND-SQL-PREDICATES     
PRJ836                                         ABEND-TABLES             
PRJ836         MOVE 'CSR04690_R4'           TO TABLE-1                  
PRJ836         MOVE SPACES                  TO TABLE-ELEMENT-1          
PRJ836         MOVE SPACES                  TO HOSTVAR-ELEMENT-1        
PRJ836         PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT         
PRJ836     END-IF.                                                      
PRJ836*                                                                 00217800
PRJ836 8100-EXIT.                                                       
PRJ836     EXIT.                                                        
PRJ836*                                                                         
PRJ836******************************************************************00208600
PRJ836** INSERT RESULT SET DATA                                       **00208700
PRJ836******************************************************************00208800
PRJ836*                                                                 00217800
PRJ836 8200-INSERT-GTT-RESULT.                                          
PRJ836*                                                                 00217800
PRJ836     EXEC SQL                                                     
PRJ836          INSERT INTO #CSR04690_R1                         
PRJ836          (    RETURN_CODE                                        
PRJ836              ,APPL_RETURN_CODE                                   
PRJ836              ,BILL_DATE                                          
PRJ836              ,READ_DATE                                          
PRJ836              ,DAYS                                               
PRJ836              ,KWH_USED                                           
PRJ836              ,ACTUAL_KW                                          
PRJ836              ,ACTUAL_KVA                                         
PRJ836              ,BILLED_KVA_KW                                      
PRJ836              ,DEMAND_CALC_CODE                                   
PRJ836              ,TOTAL_REVENUE                                      
PRJ836              ,LOAD_FACTOR                                        
PRJ836              ,POWER_FACTOR                                       
PRJ836              ,AVG_CENTS_PER_KWH                                  
PRJ836              ,ON_PEAK_KWH                                        
PRJ836              ,OFF_PEAK_KWH                                       
PRJ836              ,SHOULDER_KWH                                       
PRJ836              ,ON_PEAK_KW                                         
PRJ836              ,OFF_PEAK_KW                                        
PRJ836              ,SHOULDER_KW                                        
PRJ836              ,ON_PEAK_KVA                                        
PRJ836              ,OFF_PEAK_KVA                                       
PRJ836              ,SHOULDER_KVA                                       
PRJ836              ,EMPL                                               
PRJ836              ,EXCL_DMD_RCHT_IND                                  
PRJ836              ,CODE_UTIL_TYPE                                     
PRJ836              ,BILL_ITEM_TIMESTMP                                 
PRJ836              ,BILL_NO                                            
PRJ836              ,MTR_REF_NO                                         
PRJ836              ,REG_ID_NO                                          
PRJ836              ,CODE_TIME_PERIOD                                   
PRJ836              ,ITEM_SEQ_NO                                        
PRJ836              ,RATE_PLAN_NO                                       
PRJ836              ,RATE_PLAN_DESC                                     
PRJ836              ,REVENUE_MONTH                                      
PRJ836          )                                                       
PRJ836          SELECT TOP(100) RETURN_CODE,
              APPL_RETURN_CODE,
              MAX(BILL_DATE),
              MAX(READ_DATE),
              SUM(DAYS),
              SUM(KWH_USED),
              SUM(ACTUAL_KW),
              SUM(ACTUAL_KVA),
              SUM(BILLED_KVA_KW),
              ' ',
              SUM(TOTAL_REVENUE),
              SUM(LOAD_FACTOR),
              SUM(POWER_FACTOR),
              CASE WHEN SUM(KWH_USED) = 0 THEN 0              
PRJ836                       ELSE SUM(TOTAL_REVENUE)/SUM(KWH_USED)      
PRJ836                  END,
              SUM(ON_PEAK_KWH),
              SUM(OFF_PEAK_KWH),
              SUM(SHOULDER_KWH),
              SUM(ON_PEAK_KW),
              SUM(OFF_PEAK_KW),
              SUM(SHOULDER_KW),
              SUM(ON_PEAK_KVA),
              SUM(OFF_PEAK_KVA),
              SUM(SHOULDER_KVA),
              0,
              ' ',
              MAX(CODE_UTIL_TYPE),
              ' ',
              0,
              0,
              0,
              0,
              0,
              MAX(RATE_PLAN_NO),
              MAX(RATE_PLAN_DESC),
              REVENUE_MONTH                                   
PRJ836            FROM  #CSR04690_R4                             
PRJ836           GROUP BY RETURN_CODE, APPL_RETURN_CODE,                
PRJ836                    REVENUE_MONTH, CODE_BILL_TYPE                 
PRJ836           ORDER BY REVENUE_MONTH DESC, CODE_BILL_TYPE DESC       
WEBFIX                                         
PRJ836     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     00209000
MFA-TR*         INSERT INTO SESSION.CSR04690_R1                         00209100
MFA-TR*         (    RETURN_CODE                                        00209200
MFA-TR*             ,APPL_RETURN_CODE                                   00209300
MFA-TR*             ,BILL_DATE                                          00209310
MFA-TR*             ,READ_DATE                                          00209400
MFA-TR*             ,DAYS                                               00209500
MFA-TR*             ,KWH_USED                                           00209600
MFA-TR*             ,ACTUAL_KW                                          00209700
MFA-TR*             ,ACTUAL_KVA                                         00209800
MFA-TR*             ,BILLED_KVA_KW                                      00209900
MFA-TR*             ,DEMAND_CALC_CODE                                   00210000
MFA-TR*             ,TOTAL_REVENUE                                      00210100
MFA-TR*             ,LOAD_FACTOR                                        00210200
MFA-TR*             ,POWER_FACTOR                                       00210300
MFA-TR*             ,AVG_CENTS_PER_KWH                                  00210400
MFA-TR*             ,ON_PEAK_KWH                                        00210500
MFA-TR*             ,OFF_PEAK_KWH                                       00210600
MFA-TR*             ,SHOULDER_KWH                                       00210700
MFA-TR*             ,ON_PEAK_KW                                         00210800
MFA-TR*             ,OFF_PEAK_KW                                        00210900
MFA-TR*             ,SHOULDER_KW                                        00211000
MFA-TR*             ,ON_PEAK_KVA                                        00211100
MFA-TR*             ,OFF_PEAK_KVA                                       00211200
MFA-TR*             ,SHOULDER_KVA                                       00211300
MFA-TR*             ,EMPL                                               00211400
MFA-TR*             ,EXCL_DMD_RCHT_IND                                  00211500
MFA-TR*             ,CODE_UTIL_TYPE                                     00211600
MFA-TR*             ,BILL_ITEM_TIMESTMP                                 00211700
MFA-TR*             ,BILL_NO                                            00211800
MFA-TR*             ,MTR_REF_NO                                         00211900
MFA-TR*             ,REG_ID_NO                                          00212000
MFA-TR*             ,CODE_TIME_PERIOD                                   00212100
MFA-TR*             ,ITEM_SEQ_NO                                        00212200
MFA-TR*             ,RATE_PLAN_NO                                       00212100
MFA-TR*             ,RATE_PLAN_DESC                                     00212100
MFA-TR*             ,REVENUE_MONTH                                              
MFA-TR*         )                                                       00212300
MFA-TR*         SELECT  RETURN_CODE                                     00212400
MFA-TR*                ,APPL_RETURN_CODE                                00212500
MFA-TR*                ,MAX(BILL_DATE)                                  00212610
MFA-TR*                ,MAX(READ_DATE)                                  00212700
MFA-TR*                ,SUM(DAYS)                                       00212800
MFA-TR*                ,SUM(KWH_USED)                                   00212900
MFA-TR*                ,SUM(ACTUAL_KW)                                  00213000
MFA-TR*                ,SUM(ACTUAL_KVA)                                 00213100
MFA-TR*                ,SUM(BILLED_KVA_KW)                              00213200
MFA-TR*                ,' '                                             00213300
MFA-TR*                ,SUM(TOTAL_REVENUE)                              00213400
MFA-TR*                ,SUM(LOAD_FACTOR)                                00213500
MFA-TR*                ,SUM(POWER_FACTOR)                               00213600
MFA-TR*                ,CASE WHEN SUM(KWH_USED) = 0 THEN 0              00213700
MFA-TR*                      ELSE SUM(TOTAL_REVENUE)/SUM(KWH_USED)      00213700
MFA-TR*                 END                                                     
MFA-TR*                ,SUM(ON_PEAK_KWH)                                00213800
MFA-TR*                ,SUM(OFF_PEAK_KWH)                               00213900
MFA-TR*                ,SUM(SHOULDER_KWH)                               00214000
MFA-TR*                ,SUM(ON_PEAK_KW)                                 00214100
MFA-TR*                ,SUM(OFF_PEAK_KW)                                00214200
MFA-TR*                ,SUM(SHOULDER_KW)                                00214300
MFA-TR*                ,SUM(ON_PEAK_KVA)                                00214400
MFA-TR*                ,SUM(OFF_PEAK_KVA)                               00214500
MFA-TR*                ,SUM(SHOULDER_KVA)                               00214600
MFA-TR*                ,0                                               00214700
MFA-TR*                ,' '                                             00214800
MFA-TR*                ,MAX(CODE_UTIL_TYPE)                             00214900
MFA-TR*                ,' '                                             00215000
MFA-TR*                ,0                                               00215100
MFA-TR*                ,0                                               00215200
MFA-TR*                ,0                                               00215300
MFA-TR*                ,0                                               00215400
MFA-TR*                ,0                                               00215500
MFA-TR*                ,MAX(RATE_PLAN_NO)                               00215500
MFA-TR*                ,MAX(RATE_PLAN_DESC)                             00215500
MFA-TR*                ,REVENUE_MONTH                                           
MFA-TR*           FROM  SESSION.CSR04690_R4                             00215600
MFA-TR*          GROUP BY RETURN_CODE, APPL_RETURN_CODE,                00215600
MFA-TR*                   REVENUE_MONTH, CODE_BILL_TYPE                 00215600
MFA-TR*          ORDER BY REVENUE_MONTH DESC, CODE_BILL_TYPE DESC       00215600
MFA-TR*          FETCH FIRST 100 ROWS ONLY                                      
MFA-TR*    END-EXEC.                                                    00215700

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PRJ836*                                                                 00215900
PRJ836      MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.   
PRJ836*                                                                 00215900
PRJ836      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
PRJ836         MOVE CTR-ROWS-RS4            TO CTR-ROWS-RS1             
PRJ836      ELSE                                                        
PRJ836         MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
PRJ836         MOVE SQLCODE                 TO ABEND-SQLCODE            
PRJ836         MOVE '8200'                  TO ACTIVE-PARAGRAPH         
PRJ836         MOVE 'INSERT'                TO ABEND-FUNCTION           
PRJ836         MOVE WS-YES                  TO  WS-ERR-INSRT-R1         
PRJ836         MOVE SPACES                  TO ABEND-SQL-PREDICATES     
PRJ836                                         ABEND-TABLES             
PRJ836         MOVE 'CSR04690_R4'           TO TABLE-1                  
PRJ836         MOVE SPACES                  TO TABLE-ELEMENT-1          
PRJ836         MOVE SPACES                  TO HOSTVAR-ELEMENT-1        
PRJ836         PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT         
PRJ836     END-IF.                                                      
PRJ836*                                                                 00217500
PRJ836 8200-EXIT.                                                       
PRJ836     EXIT.                                                        
PRJ836*                                                                 00217800
222700************************************************************      00222700
222800*                                                                 00222800
222900* 8800-CHECK-RESULTS.                                             00222900
223000************************************************************      00223000
223100 8800-CHECK-RESULTS.                                              
223200                                                                  
223300     IF CTR-ROWS-RS1 <= 0                                         
223400        INITIALIZE GTT-RETURN-FIELDS-1                            
223500        MOVE 100                      TO S-RETURN-CODE-1          
223600        MOVE   0                      TO S-APPL-RETURN-CODE-1     
223700        PERFORM 8010-INSERT-GTT-R1         THRU 8010-EXIT         
223800     END-IF.                                                      
223900*                                                                 00223900
224000     IF CTR-ROWS-RS2 <= 0                                         
224100        INITIALIZE GTT-RETURN-FIELDS-2                            
224200        MOVE 100                      TO S-RETURN-CODE-2          
224300        MOVE   0                      TO S-APPL-RETURN-CODE-2     
224400        PERFORM 8020-INSERT-GTT-R2         THRU 8020-EXIT         
224500     END-IF.                                                      
223900*                                                                 00223900
P00836     IF CTR-ROWS-RS3 <= 0                                         
P00836        INITIALIZE GTT-RETURN-FIELDS-3                            
P00836        MOVE 100                      TO S-RETURN-CODE-3          
P00836        MOVE   0                      TO S-APPL-RETURN-CODE-3     
P00836        PERFORM 8030-INSERT-GTT-R3         THRU 8030-EXIT         
P00836     END-IF.                                                      
224600*                                                                 00224600
224700 8800-EXIT.                                                       
224800     EXIT.                                                        
224900************************************************************      00224900
225000*                                                                 00225000
225100* 8900-SEND-DONE.                                                 00225100
225200************************************************************      00225200
225300 8900-SEND-DONE.                                                  
225400                                                                  
225500     MOVE PROGRAM-NAME                TO ABEND-PROGRAM            
225600     MOVE '8900'                      TO ACTIVE-PARAGRAPH         
225700     MOVE 'OPEN'                      TO ABEND-FUNCTION           
225800                                                                  
225900     EXEC SQL                                                     
226000         OPEN C1                                                  
226100     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
226200                                                                  
226300     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
226400                                      S-RETURN-CODE-1.            
226500                                                                  
226600     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
226700        CONTINUE                                                  
226800     ELSE                                                         
226900        MOVE SQLCODE                  TO ABEND-SQLCODE            
227000        MOVE SQLSTATE                 TO ABEND-SQLSTATE           
227100        MOVE 'CSR04690_R1'            TO TABLE-1                  
227200        PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
227300     END-IF.                                                      
227400                                                                  
227500     EXEC SQL                                                     
227600         OPEN C2                                                  
227700     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
227800                                                                  
227900     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
228000                                      S-RETURN-CODE-2.            
228100                                                                  
228200     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
228300        CONTINUE                                                  
228400     ELSE                                                         
228500        MOVE SQLCODE                  TO ABEND-SQLCODE            
228600        MOVE SQLSTATE                 TO ABEND-SQLSTATE           
228700        MOVE 'CSR04690_R2'            TO TABLE-1                  
228800        PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
228900     END-IF.                                                      
229000                                                                  
P00836     EXEC SQL                                                     
P00836         OPEN C3                                                  
P00836     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C3 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
P00836                                                                  
P00836     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
P00836                                      S-RETURN-CODE-3.            
P00836                                                                  
P00836     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00836        CONTINUE                                                  
P00836     ELSE                                                         
P00836        MOVE SQLCODE                  TO ABEND-SQLCODE            
P00836        MOVE SQLSTATE                 TO ABEND-SQLSTATE           
P00836        MOVE 'CSR04690_R3'            TO TABLE-1                  
P00836        PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
P00836     END-IF.                                                      
229100 8900-EXIT.                                                       
229200     EXIT.                                                        
229300                                                                  
229400************************************************************      00229400
229500*                                                                 00229500
229600* 9000-SEND-ERROR-RESULT                                          00229600
229700************************************************************      00229700
229800 9000-SEND-ERROR-RESULT.                                          
229900                                                                  
230000     INITIALIZE GTT-RETURN-FIELDS.                                
230100     MOVE WS-ACTIVE-RETURN-CODE       TO ABEND-SQLCODE            
230200                                         S-RETURN-CODE-1          
230300                                         S-RETURN-CODE-2          
P00836                                         S-RETURN-CODE-3          
230400                                                                  
230500     MOVE WS-APPL-RETURN-CODE         TO S-APPL-RETURN-CODE-1     
230600                                         S-APPL-RETURN-CODE-2     
P00836                                         S-APPL-RETURN-CODE-3     
230700                                                                  
230800                                                                  
230900     MOVE SQLERRMC                    TO ABEND-SQLERRMC.          
231000                                                                  
231100     EXEC SQL                                                     
231200         ROLLBACK                                                 
231300     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

231400                                                                  
231500     IF SQLCODE = 0                                               
231600        CONTINUE                                                  
231700     ELSE                                                         
231800        MOVE 'ROLLBACK'               TO ABEND-FUNCTION           
231900     END-IF.                                                      
232000                                                                  
232100     PERFORM 0100A-DECLARE-GTT-R1          THRU 0100A-EXIT.       
232200     PERFORM 0100B-DECLARE-GTT-R2          THRU 0100B-EXIT.       
P00836     PERFORM 0100C-DECLARE-GTT-R3          THRU 0100C-EXIT.       
232300                                                                  
232400     PERFORM 8010-INSERT-GTT-R1            THRU 8010-EXIT.        
232500     PERFORM 8020-INSERT-GTT-R2            THRU 8020-EXIT.        
P00836     PERFORM 8030-INSERT-GTT-R3            THRU 8030-EXIT.        
232600                                                                  
232700 9000-EXIT.                                                       
232800     EXIT.                                                        
232900                                                                  
233000************************************************************      00233000
233100* 9700-ABEND-PROCESSING.                                          00233100
233200************************************************************      00233200
233300 9700-PROCESS-ABEND.                                              
233400                                                                  
233500     PERFORM 9000-SEND-ERROR-RESULT        THRU 9000-EXIT.        
233600     PERFORM 9900-SQL-ERROR-ROUTINE        THRU 9900-EXIT.        
233700                                                                  
233800 9700-EXIT.                                                       
233900     EXIT.                                                        
234000                                                                  
234100******************************************************************00234100
234200* 9900- JOURNALING / ERROR HANDLING INCLUDE                      *00234200
234300******************************************************************00234300
234400     EXEC SQL                                                     00234400
234500        INCLUDE CPDSP300                                          00234500
234600     END-EXEC.                                                    00234600
HPCCDM*    EJECT                                                        00234700
234800************************************************************      00234800
234900* 9999-END-PROGRAM.                                               00234900
235000************************************************************      00235000
235100                                                                  
235200 9999-END-PROGRAM.                                                
235300                                                                  
235400      PERFORM 8800-CHECK-RESULTS           THRU 8800-EXIT         
235500      PERFORM 8900-SEND-DONE               THRU 8900-EXIT         
235600                                                                  
235700     
MSQ016        GOBACK.                                                    
235800                                                                  
235900 9999-EXIT.                                                       
236000     EXIT.                                                        
