       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.  CSR04686.                                           
COB303 DATE-WRITTEN.  AUGUST 30, 2013                                   
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM RECEIVES PARMS FROM THE CALLING PROGRAM.  IT     *        
      *  WILL USE THE PARMS AS KEY INFO TO READ DB2 TABLES TO GET THE  *        
      *  INFORMATION FOR THE LINKAGE SECTION AND THEN CALL BILL CALC.  *        
      *  AFTER CALLING BILL CALC IT WILL RETURN ROWS OF DETAILED BILLING        
      *  DATA TO THE CALLER.                                           *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE      INITIALS   COMMENTS                               *        
      *  --------    --------   ---------------------------------------*        
      *  08/30/2013  HA7A338    PROCEDURE CLONED FROM CSR02285.        *        
PRJ821*  07/29/2014  RH15956    CALCULATE TAXES FOR UNBILLED CONSMPTION*        
ACT247*  08/22/2014  VIJAY      POPULATE BG.RT_PKG_OPT_SEQ_NO FROM     *        
ACT247*  A04880                 UTIL_ENVRNMT WHEN IT IS 0 TO AVOID     *        
ACT247*                         ABEND IN BILL CALC PROGRAM WHEN PROCES-*        
ACT247*                         SING 'EXIT FEE' FACTOR                 *        
PRJ821*  09/24/2014  MN90523    ADDED READ_DATE, FACTOR_TYPE, CALC_TYPE*        
PRJ821*                         ADJUST_ELEMENT                         *        
PRJ821*  10/17/2014  MN90523    FIXED REPLACE UNITS ADJUST'S FACTOR    *        
PRJ821*                         TO HAVE THE FACTOR IN NET UNITS        *        
PRJ637*  12/22/2014  MN90523    FIXED BTU-FACTOR TO HAVE THE FACTOR    *        
PRJ637*                         IN RATE FACTOR                         *        
PRJ821*  02/26/2015  HA7A338    ADDED BLOCK-NO IN FACTOR RESULT SET FOR*        
PRJ821*                         RATE INCLUDE FACTOR IDS.               *        
ACT236*  11/18/2015  VIJAY      POPULATE BG.RT_PKG_OPT_SEQ_NO FROM     *        
ACT236*  A05136                 UTIL_ENVRNMT WHEN IT IS 0 TO AVOID     *        
ACT236*                         ABEND IN BILL CALC PROGRAM .           *        
A05460*  05/04/2016  MC95456    REMOVED DECLGEN FOR CSS_MKT_CNTRL.     *        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  OUTPUT MODULES                                   *        
      *  8000 - 8999  DB2 CALLS                                        *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04686'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                           PIC X(40) VALUE           
           'WORKING STORAGE FOR CSR04686 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCSTPLN                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE TBBILADJ                                                 
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBRTUSES                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBRTDESC                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBSVCCAT                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBINTACT                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBBLLDET                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSPLFTR                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCNSMP                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBFXHST                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBUMCNSM                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMTRENV                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBUMEQP                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBDELQ                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBUTLENV                                                 
           END-EXEC.                                                            
                                                                        
      * CSS_ACCT_RTPK_AGR, DF                                                   
           EXEC SQL                                                             
               INCLUDE TBACCTRG                                                 
           END-EXEC.                                                            
                                                                        
      * CRM_RT_PKG_OPTION, FI                                                   
           EXEC SQL                                                             
               INCLUDE TBRTPKGO                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_TAX_EXMPT_CODE, F1                                        *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBTXMPCD                                                 
           END-EXEC.                                                            
                                                                        
      * CSS_BILL_WINDOW, BN                                                     
           EXEC SQL                                                             
               INCLUDE TBBILWDW                                                 
           END-EXEC.                                                            
                                                                        
      * CSS_RATE_COMP_DEF, J1                                                   
           EXEC SQL                                                             
               INCLUDE TBRTCDEF                                                 
           END-EXEC.                                                            
                                                                        
      * CSS_BILL_MANUAL, NG                                                     
           EXEC SQL                                                             
               INCLUDE TBBILMNL                                                 
           END-EXEC.                                                            
                                                                        
      * CSS_BUS_RULE_XREF 1T                                                    
           EXEC SQL                                                             
              INCLUDE TBBUSRUL                                                  
           END-EXEC.                                                            
                                                                        
      * CSS_BUS_RULE   1R                                                       
           EXEC SQL                                                             
              INCLUDE TBRULXRF                                                  
           END-EXEC.                                                            
                                                                        
      * CSS_BILLING_HDR BI                                                      
           EXEC SQL                                                             
              INCLUDE TBBLLHDR                                                  
           END-EXEC.                                                            
                                                                        
      * CSS_BILL_CALC_DET BZ                                                    
           EXEC SQL                                                             
              INCLUDE TBBLCLDT                                                  
           END-EXEC.                                                            
                                                                        
      **** CSS_WEATHER_TREND, WT                                                
           EXEC SQL                                                             
               INCLUDE TBWTHTRD                                                 
           END-EXEC.                                                            
      *                                                                         
      **** CSS_TAX_CNTL,      TC                                                
           EXEC SQL                                                             
               INCLUDE TBTXCNTL                                                 
           END-EXEC.                                                            
      *                                                                         
      **** CSS_TAX_RATE,      TR                                                
           EXEC SQL                                                             
               INCLUDE TBTXRATE                                                 
           END-EXEC.                                                            
      *                                                                         
      **** CSS_TAX_USE_CNTL,  TU                                                
           EXEC SQL                                                             
               INCLUDE TBTXUSE                                                  
           END-EXEC.                                                            
      *                                                                         
      **** CSS_TAX_EXCISE_AMT,                                                  
           EXEC SQL                                                             
               INCLUDE TBEXCISE                                                 
           END-EXEC.                                                            
      *                                                                         
      **** CSS_BILL_MAN_DET,  NU                                                
           EXEC SQL                                                             
               INCLUDE TBBILMDE                                                 
           END-EXEC.                                                            
      *                                                                         
      **** CSS_REVENUE_CLASS, F3                                                
           EXEC SQL                                                             
               INCLUDE TBREVCLS                                                 
           END-EXEC.                                                            
      *                                                                         
      **** CSS_FRNCHS_TX_XMPT, F2                                               
           EXEC SQL                                                             
               INCLUDE TBFTXXMP                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
           COPY CCA00001.                                                       
           COPY CWS00027.                                                       
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS00013                                                  
           END-EXEC.                                                            
                                                                        
       01  WS-WORK-VARIABLES.                                           
           03  WS-NULL-IND-1                  PIC S9(4) COMP.           
           03  WS-NULL-IND-2                  PIC S9(4) COMP.           
           03  WS-NULL-IND-3                  PIC S9(4) COMP.           
           03  WS-NULL-IND-4                  PIC S9(4) COMP.           
           03  WS-NULL-IND-5                  PIC S9(4) COMP.           
           03  WS-NULL-IND-6                  PIC S9(4) COMP.           
           03  WS-NULL-IND-7                  PIC S9(4) COMP.           
           03  WS-NULL-IND-8                  PIC S9(4) COMP.           
           03  WS-NULL-IND-9                  PIC S9(4) COMP.           
           03  WS-NULL-IND-10                 PIC S9(4) COMP.           
           03  WS-NULL-IND-11                 PIC S9(4) COMP.           
           03  WS-DATE-ORIG-BILL-NULL         PIC S9(4) COMP.           
           03  WS-DATE-READ-NULL              PIC S9(4) COMP.           
           03  WS-DATE-USAGE-ENDS-NULL        PIC S9(4) COMP.           
           03  WS-EFF-DATE-FROM-NULL          PIC S9(4) COMP.           
           03  WS-EFF-DATE-TO-NULL            PIC S9(4) COMP.           
           03  WS-DATE-LFTM-HI-DMD            PIC S9(4) COMP.           
           03  ALL-DONE-SW                    PIC X(01) VALUE 'N'.      
               88 NOT-ALL-DONE                          VALUE 'N'.      
               88 ALL-DONE                              VALUE 'Y'.      
           03  WS-CUST-PLAN-SW                PIC X(01) VALUE 'N'.      
               88 HAS-CUST-PLAN                         VALUE 'Y'.      
           03  WS-SPMNTMIN-SW                 PIC X(01) VALUE 'N'.      
               88 MONTHLY-MINIMUM-CHARGED               VALUE 'Y'.      
           03  WS-SPANMIN-SW                  PIC X(01) VALUE 'N'.      
               88 ANNUAL-MINIMUM-APPLIED                VALUE 'Y'.      
           03  WS-INTERRUPT-SW                PIC X(01) VALUE 'N'.      
               88 INTERRUPTIBLE                         VALUE 'Y'.      
           03  WS-PCT-BILL-SW                 PIC X(01) VALUE 'N'.      
               88 NOT-PCT-BILL                          VALUE 'N'.      
               88 PCT-BILL                              VALUE 'Y'.      
           03  WS-MANUAL-BILL-SW              PIC X(01) VALUE 'N'.      
           03  WS-PROCESS-BILL-CALC           PIC X(01) VALUE 'N'.      
           03  WS-CIG-PRORATE-FL              PIC X(01) VALUE 'N'.      
           03  WS-CIG-PRORATE-FL              PIC X(01) VALUE 'N'.      
           03  WS-CIG-REV-MONTH               PIC X(06) VALUE SPACES.   
           03  WS-BG-REV-MM                   PIC X(02) VALUE SPACES.   
PRJ821     03  WS-REV-DISTRICT-CD             PIC X(03) VALUE SPACES.   
           03  WS-RS-DATE-FROM.                                         
               05  WS-RS-MM                   PIC X(2) VALUE '00'.      
               05  WS-RS-DD                   PIC X(2) VALUE '00'.      
           03  WS-CIG-DATE-FROM               PIC 9(4) VALUE ZEROES.    
           03  WS-BOTH                        PIC X(1) VALUE 'B'.       
           03  WS-FMT-PERCENT-TEXT.                                     
               05  FILLER                     PIC X(3) VALUE '(S='.     
               05  WS-FMT-PERCENT             PIC Z.999.                
               05  FILLER                     PIC X(2) VALUE '%)'.      
           03  WS-CNTRCT-START-DT.                                      
               05  FILLER                     PIC X(5).                 
               05  WS-CNTRCT-START-MTH        PIC X(2).                 
               05  FILLER                     PIC X(3).                 
           03  WS-HOLD-REV-MONTH              PIC X(6).                 
           03  WS-BC-TABLE-LOADED             PIC X VALUE 'N'.          
           03  WS-SEASONAL-PRORATE            PIC X VALUE 'N'.          
           03  WS-VERSION-PRORATE             PIC X VALUE 'N'.          
           03  SUB4                           PIC 9(3) VALUE 0.         
           03  WS-PRO-BC-TABLE.                                         
               07  WS-PRO-TABLE OCCURS 20 TIMES INDEXED BY PRO-INDX.    
COB305             10 WS-PRO-UNITS-READ        PIC S9(9) USAGE COMP-3 
COB305               VALUE 0.  
COB305             10 WS-PRO-UNITS-BILLED        PIC S9(9) USAGE COMP-3 
COB305               VALUE 0.  
                   10  WS-PRO-CONSUMPTION-TYPE PIC X.                   
COB305             10 WS-PRO-DOLLAR-AMT        PIC S9(9)V99 
COB305               USAGE COMP-3 VALUE 0.  
                   10  WS-PRO-TIME-PERIOD      PIC 9.                   
COB305             10 WS-PRO-RATE        PIC S9(5)V9(12) USAGE COMP-3 
COB305               VALUE 0.  
           03  WS-HOLD-BASIC-FACILITY          PIC S9(9)V99 VALUE 0.    
COB305     03 WS-TOTAL-COMPONENT-AMT        PIC S9(9)V9(2) USAGE COMP-3 
COB305       VALUE 0.  
           03  WS-INTERRUPTIBLE-CREDITS PIC S9(9)V9(2) COMP-3 VALUE +0. 
COB305     03 WS-HOLD-BG-AMT        PIC S9(9)V9(2) USAGE COMP-3 VALUE 0.
COB305     03 WS-HOLD-STATE        PIC S9(7)V9(2) USAGE COMP-3 VALUE 0.
COB305     03 WS-HOLD-CITY        PIC S9(7)V9(2) USAGE COMP-3 VALUE 0.
COB305     03 WS-HOLD-OTHER        PIC S9(7)V9(2) USAGE COMP-3 VALUE 0.
           03  WS-WORK-FACTOR                  PIC S9(2)V9(15).         
COB305     03 WS-SPANMIN-AMT        PIC S9(9)V99 USAGE COMP-3 VALUE 0.  
COB305     03 WS-INTERRUPT-AMT        PIC S9(9)V99 USAGE COMP-3 VALUE 0.  
           03  WS-HOLD-FACTOR-ID               PIC X(9).                
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
           05  GWL-RC                         PIC S9(9) COMP.           
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME                PIC X(26)                       
                                             VALUE                      
                                             'SESSION.CSR04686_R1'.     
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
       01  FILLER                             PIC X(11)                 
                                                  VALUE 'PARM FIELDS'.  
       01  WS-MISC.                                                     
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04686'.     
           05  WS-SQLSTATE              PIC X(05) VALUE SPACES.         
           05  WS-RETURN-CODE-ERR       PIC S9(9) COMP VALUE 0.         
           05  WS-BILL-NO               PIC S9(9) COMP VALUE 0.         
COB305     05 WS-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.       
           05  WS-CODE-UTIL-TYPE        PIC X(01) VALUE SPACES.         
           05  WS-IC-NO                 PIC S9(4) USAGE COMP.           
           05  WS-BILL-ITEM-TIMESTMP    PIC X(26).                      
           05  WS-CX-BILL-NO            PIC S9(9) COMP VALUE 0.         
COB305     05 WS-CX-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.       
           05  WS-CX-CODE-UTIL-TYPE     PIC X(01) VALUE SPACES.         
           05  WS-CX-IC-NO              PIC S9(4) USAGE COMP.           
           05  WS-CX-BILL-ITEM-TIMESTMP PIC X(26).                      
           05  WS-TEMP-CODE-UTIL-TYPE   PIC X(01) VALUE SPACES.         
           05  WS-TEMP-IC-NO            PIC S9(4) USAGE COMP.           
           05  WS-US-MTR-REF-NO-CX      PIC 9(4).                       
           05  WS-US-NO-DAYS-CX         PIC 9(4).                       
           05  WS-US-RATE-ITEM-CODE-UC  PIC 9(4).                       
           05  WS-US-NO-DAYS-UC         PIC 9(4).                       
           05  WS-US-NO-UNITS-CX        PIC 9(9).                       
           05  WS-US-USAGE-FIXED-UC     PIC 9(9).                       
           05  WS-US-NO-UNITS-UC        PIC 9(9).                       
           05  WS-US-NO-DEMAND-UNITS-CX PIC 9(9).                       
           05  WS-US-CODE-TIME-PERIOD   PIC 9(1).                       
           05  WS-BLOCK-NO              PIC 9(01).                      
           05  WS-CONSUMPTION-TYPE      PIC X(01) VALUE SPACE.          
           05  WS-TOTAL-USAGE-CHARGES   PIC S9(9)V99 COMP-3 VALUE 0.    
           05  WS-LOAD-FACTOR-AMT       PIC S9(9)V99 COMP-3 VALUE 0.    
           05  WS-TOTAL-NET-CHARGES     PIC S9(9)V99 COMP-3 VALUE 0.    
           05  WS-TOTAL-DEMAND-CHARGES  PIC S9(9)V99 COMP-3 VALUE 0.    
           05  WS-TOTAL-COMPONENTS-AMT  PIC S9(9)V99 COMP-3 VALUE 0.    
           05  WS-TOTAL-NET-UNITS       PIC S9(9)V99 USAGE COMP-3       
                                                            VALUE 0.    
           05  WS-UNIT-PRICE-AMT        PIC S9(5)V9(6) USAGE COMP-3     
                                                            VALUE 0.    
           05  WS-PRICE-PER-THERM       PIC S9(5)V9(6) USAGE COMP-3     
                                                            VALUE 0.    
           05  WS-AGL-CREDIT-CHARGES    PIC S9(9)V9(4) USAGE COMP-3     
                                                            VALUE 0.    
           05  WS-AGL-DEBIT-CHARGES     PIC S9(9)V9(4) USAGE COMP-3     
                                                            VALUE 0.    
           05  WS-AGL-CHARGES           PIC S9(9)V9(4) USAGE COMP-3     
                                                            VALUE 0.    
           05  WS-OTHR-CHARGES          PIC S9(9)V9(4) USAGE COMP-3     
                                                            VALUE 0.    
           05  WS-DEMAND-CHRGS-CREDITS  PIC S9(9)V99 COMP-3 VALUE 0.    
           05  WS-USAGE-CHRGS-CREDITS   PIC S9(9)V99 COMP-3 VALUE 0.    
           05  WS-BASIC-FCLTY-CHRG      PIC S9(9)V99 COMP-3 VALUE 0.    
COB305     05 WS-MIN-PRORATE-DAYS        PIC S9(4)V9(5) USAGE COMP-3 
COB305       VALUE 0.    
COB305     05 WS-MAX-PRORATE-DAYS        PIC S9(4)V9(5) USAGE COMP-3 
COB305       VALUE 0.    
           05  WS-MIN-PRORATE-CD        PIC X(15)                       
                                        VALUE 'DAY-MIN-PRORATE'.        
           05  WS-MAX-PRORATE-CD        PIC X(15)                       
                                        VALUE 'DAY-MAX-PRORATE'.        
           05  WS-NO-OF-DAYS-DISP       PIC 9(4).                       
           05  WS-NO-OF-DAYS-RED REDEFINES WS-NO-OF-DAYS-DISP.          
               10 WS-NO-OF-DAYS-TXT     PIC X(4).                       
           05  WS-PRORTD-BILL-FL        PIC X(01) VALUE SPACES.         
           05  WS-PRORTD-BY-DAYS-FL     PIC X(01) VALUE SPACES.         
           05  WS-FAILED                PIC X(01) VALUE 'F'.            
           05  WS-PASSED                PIC X(01) VALUE 'P'.            
           05  SEND-DONE-SW             PIC X(01) VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
           05  WS-CURR-REVENUE-MTH-A    PIC X(6).                       
           05  WS-CURR-REVENUE-MONTH REDEFINES WS-CURR-REVENUE-MTH-A    
                                        PIC 9(6).                       
           05  WS-COMMON-DATE           PIC X(10).                      
           05  WS-RT-OVRD-BILL-CY       PIC X(02) VALUE SPACES.         
           05  WS-RT-OVRD-BILL-DT       PIC X(10) VALUE SPACES.         
           05  WS-RT-OVRD-REV-MTH       PIC S9(6)V COMP-3 VALUE 0.      
           05  WS-RT-PARM-OVRD          PIC X(04) VALUE 'RTOV'.         
      *                                                                         
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS-RS1            PIC S9(9) COMP VALUE 0.          
           05  CTR-ROWS-RS2            PIC S9(9) COMP VALUE 0.          
           05  CTR-ROWS-RS3            PIC S9(9) COMP VALUE 0.          
           05  CTR-ROWS-RS4            PIC S9(9) COMP VALUE 0.          
           05  CTR-ROWS-RS5            PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
           05  MCSCB107                PIC X(8) VALUE 'MCSCB107'.       
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
       01  TDS-RETURN-FIELDS.                                           
           05  RS-FACTOR-DESC          PIC X(54) VALUE SPACE.           
           05  RS-FACTOR-TYPE          PIC X(01) VALUE SPACE.           
           05  RS-ADJUST-ELEMENT       PIC X(01) VALUE SPACE.           
           05  RS-CALC-TYPE-CD         PIC X(01) VALUE SPACE.           
           05  RS-CHARGE-DESC          PIC X(54) VALUE SPACE.           
           05  RS-FACTOR-ID            PIC X(09) VALUE SPACE.           
           05  RS-READ-DATE            PIC X(10) VALUE SPACE.           
           05  RS-UNITS-READ           PIC S9(9)V9(2) USAGE COMP-3      
                                                      VALUE 0.          
           05  RS-NET-UNITS            PIC S9(9)V9(2) USAGE COMP-3      
                                                      VALUE 0.          
           05  RS-BLOCK-NUMBER         PIC X(03) VALUE SPACE.           
           05  RS-BLOCK-NO             PIC 9(01) VALUE ZERO.            
           05  RS2-BLOCK-NO            PIC X(04) VALUE SPACE.           
           05  RS-BLOCK-SIZE           PIC S9(9) COMP.                  
           05  RS-UNITS-BILLED         PIC S9(9)V9(2) USAGE COMP-3      
                                                      VALUE 0.          
           05  RS-BASE-RATE            PIC S9(5)V9(6) USAGE COMP-3      
                                                      VALUE 0.          
           05  RS-NET-RATE             PIC S9(9)V9(6) USAGE COMP-3      
                                                      VALUE 0.          
           05  RS-PRICE-TYPE-CD        PIC X(01) VALUE SPACE.           
           05  RS-COMPUTED-CHARGE      PIC S9(9)V9(2) USAGE COMP-3      
                                                      VALUE 0.          
           05  RS-NO-OF-DAYS           PIC S9(4) COMP.                  
           05  RS-BTU-FACTOR           PIC S9(5)V9(6) USAGE COMP-3      
                                                      VALUE 0.          
           05  RS-WNA-FACTOR           PIC S9(5)V9(6) USAGE COMP-3      
                                                      VALUE 0.          
           05  RS-CONSUMPTION-TYPE     PIC X(01) VALUE SPACE.           
           05  RS-REGISTER-TYPE        PIC X(01) VALUE SPACE.           
           05  RS-RATE-VERSION         PIC X(01) VALUE SPACE.           
           05  RS-COMPONENT-KEY        PIC X(08) VALUE SPACE.           
           05  RS-STATE-TAX            PIC S9(9)V9(2) USAGE COMP-3      
                                                      VALUE 0.          
           05  RS-CITY-TAX             PIC S9(9)V9(2) USAGE COMP-3      
                                                      VALUE 0.          
           05  RS-OTHER-TAX            PIC S9(9)V9(2) USAGE COMP-3      
                                                      VALUE 0.          
           05  RS-TOTAL-USAGE-CHARGES  PIC S9(9)V9(2) USAGE COMP-3      
                                                      VALUE 0.          
           05  RS-USAGE-CHARGES        PIC S9(9)V9(2) USAGE COMP-3      
                                                      VALUE 0.          
           05  RS-TOTAL-DEMAND-CHARGES PIC S9(9)V9(2) USAGE COMP-3      
                                                      VALUE 0.          
           05  RS-DEMAND-CHRGS-CREDITS PIC S9(9)V9(2) USAGE COMP-3      
                                                      VALUE 0.          
           05  RS-USAGE-CHRGS-CREDITS  PIC S9(9)V9(2) USAGE COMP-3      
                                                      VALUE 0.          
           05  RS-BASIC-FCLTY-CHRG     PIC S9(9)V9(2) USAGE COMP-3      
                                                      VALUE 0.          
           05  RS-AGL-CHARGES          PIC S9(9)V9(4) USAGE COMP-3      
                                                      VALUE 0.          
           05  RS-UNIT-PRICE-AMT       PIC S9(5)V9(6) USAGE COMP-3      
                                                      VALUE 0.          
           05  RS-TOTAL-BILL-AMOUNT    PIC S9(9)V9(2) USAGE COMP-3      
                                                      VALUE 0.          
           05  RS-TOTAL-NET-UNITS      PIC S9(9)V9(2) USAGE COMP-3      
                                                      VALUE 0.          
           05  RS-RETURN-CODE          PIC S9(9) VALUE 0 COMP.          
           05  RS-APPL-RETURN-CODE     PIC S9(9) VALUE 0 COMP.          
           05  RS-REV-MONTH            PIC X(06) VALUE SPACES.          
           05  RS-RATE-PLAN            PIC X(03) VALUE SPACES.          
           05  RS-RATE-DESC            PIC X(50) VALUE SPACES.          
           05  RS-SVC-CAT              PIC X(02) VALUE SPACES.          
           05  RS-STATE-TAX-RATE       PIC S9(5)V9(6) USAGE COMP-3      
                                                      VALUE 0.          
           05  RS-CITY-TAX-RATE        PIC S9(5)V9(6) USAGE COMP-3      
                                                      VALUE 0.          
           05  RS-PARTIAL-XMPT-FL      PIC X(01) VALUE SPACES.          
           05  RS-PRORTD-BILL-FL       PIC X(01) VALUE SPACES.          
           05  RS-PRORTD-BY-DAYS-FL    PIC X(01) VALUE SPACES.          
           05  RS-RT-OVRD-BILL-CY      PIC X(02) VALUE SPACES.          
           05  RS-RT-OVRD-BILL-DT      PIC X(10) VALUE SPACES.          
           05  RS-RT-OVRD-REV-MTH      PIC S9(6)V USAGE COMP-3          
                                                      VALUE 0.          
           05  RS-CODE-ADJUST-TYPE     PIC X(01) VALUE SPACE.           
           05  RS-INFO-ONLY-FLAG       PIC X(01) VALUE SPACE.           
           05  RS-COMPONENT-ID         PIC X(02) VALUE SPACE.           
           05  RS-CODE-TOU             PIC S9(4) COMP.                  
           05  RS-CODE-SN              PIC X(01) VALUE SPACE.           
           05  RS-SEAS-PRORATE-PCT     PIC S9(1)V9(5) USAGE COMP-3      
                                                      VALUE 0.          
           05  RS-NET-UNIT-SEL-RSN     PIC X(01) VALUE SPACE.           
           05  RS-SPCL-GRP-CD          PIC X(02) VALUE SPACE.           
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE           PIC S9(9) VALUE 0 COMP.          
           05  S-APPL-RETURN-CODE      PIC S9(9) VALUE 0 COMP.          
           05  S-FACTOR-DESC           PIC X(54) VALUE SPACE.           
           05  S-FACTOR-TYPE           PIC X(01) VALUE SPACE.           
           05  S-ADJUST-ELEMENT        PIC X(01) VALUE SPACE.           
           05  S-CALC-TYPE-CD          PIC X(01) VALUE SPACE.           
           05  S-CHARGE-DESC           PIC X(54) VALUE SPACE.           
           05  S-FACTOR-ID             PIC X(09) VALUE SPACE.           
           05  S-READ-DATE             PIC X(10) VALUE SPACE.           
           05  S-UNITS-READ            PIC S9(9)V9(2) USAGE COMP-3      
                                                      VALUE 0.          
           05  S-NET-UNITS             PIC S9(9)V9(2) USAGE COMP-3      
                                                      VALUE 0.          
           05  S-BLOCK-NO              PIC X(03) VALUE SPACE.           
           05  S2-BLOCK-NO             PIC X(01) VALUE SPACE.           
           05  S-BLOCK-SIZE            PIC S9(9) COMP.                  
           05  S-UNITS-BILLED          PIC S9(9)V9(2) USAGE COMP-3      
                                                      VALUE 0.          
           05  S-BASE-RATE             PIC S9(5)V9(6) USAGE COMP-3      
                                                      VALUE 0.          
           05  S-NET-RATE              PIC S9(9)V9(6) USAGE COMP-3      
                                                      VALUE 0.          
           05  S-PRICE-TYPE-CD         PIC X(01) VALUE SPACE.           
           05  S-COMPUTED-CHARGE       PIC S9(9)V9(2) USAGE COMP-3      
                                                      VALUE 0.          
           05  S-NO-OF-DAYS            PIC S9(4) COMP.                  
           05  S-BTU-FACTOR            PIC S9(5)V9(6) USAGE COMP-3      
                                                      VALUE 0.          
           05  S-WNA-FACTOR            PIC S9(5)V9(6) USAGE COMP-3      
                                                      VALUE 0.          
           05  S-CONSUMPTION-TYPE      PIC X(01) VALUE SPACE.           
           05  S-REGISTER-TYPE         PIC X(01) VALUE SPACE.           
           05  S-RATE-VERSION          PIC X(01) VALUE SPACE.           
           05  S-COMPONENT-KEY         PIC X(08) VALUE SPACE.           
           05  S-STATE-TAX             PIC S9(9)V9(2) USAGE COMP-3      
                                                      VALUE 0.          
           05  S-CITY-TAX              PIC S9(9)V9(2) USAGE COMP-3      
                                                      VALUE 0.          
           05  S-OTHER-TAX             PIC S9(9)V9(2) USAGE COMP-3      
                                                      VALUE 0.          
           05  S-TOTAL-USAGE-CHRG      PIC S9(9)V9(2) USAGE COMP-3      
                                                      VALUE 0.          
           05  S-USAGE-CHRG            PIC S9(9)V9(2) USAGE COMP-3      
                                                      VALUE 0.          
           05  S-TOTAL-DEMAND-CHRG     PIC S9(9)V9(2) USAGE COMP-3      
                                                      VALUE 0.          
           05  S-DEMAND-CHRGS-CRDT     PIC S9(9)V9(2) USAGE COMP-3      
                                                      VALUE 0.          
           05  S-USAGE-CHRGS-CRDT      PIC S9(9)V9(2) USAGE COMP-3      
                                                      VALUE 0.          
           05  S-BASIC-FCLTY-CHRG      PIC S9(9)V9(2) USAGE COMP-3      
                                                      VALUE 0.          
           05  S-TOTAL-BILL-AMOUNT     PIC S9(9)V9(2) USAGE COMP-3      
                                                      VALUE 0.          
           05  S-TOTAL-NET-UNITS       PIC S9(9)V9(2) USAGE COMP-3      
                                                      VALUE 0.          
           05  S-UNIT-PRICE-AMT        PIC S9(5)V9(6) USAGE COMP-3      
                                                      VALUE 0.          
           05  S-AGL-CHARGES           PIC S9(9)V9(4) USAGE COMP-3      
                                                      VALUE 0.          
           05  S-REV-MONTH             PIC X(06) VALUE SPACES.          
           05  S-RATE-PLAN             PIC X(03) VALUE SPACES.          
           05  S-RATE-DESC             PIC X(50) VALUE SPACES.          
           05  S-SVC-CAT               PIC X(02) VALUE SPACES.          
           05  S-STATE-TAX-RATE        PIC S9(5)V9(6) USAGE COMP-3      
                                                      VALUE 0.          
           05  S-CITY-TAX-RATE         PIC S9(5)V9(6) USAGE COMP-3      
                                                      VALUE 0.          
           05  S-PARTIAL-XMPT-FL       PIC X(01) VALUE SPACES.          
           05  S-PRORTD-BILL-FL        PIC X(01) VALUE SPACES.          
           05  S-PRORTD-BY-DAYS-FL     PIC X(01) VALUE SPACES.          
           05  S-RT-OVRD-BILL-CY       PIC X(02) VALUE SPACES.          
           05  S-RT-OVRD-BILL-DT       PIC X(10) VALUE SPACES.          
           05  S-RT-OVRD-REV-MTH       PIC S9(6)V USAGE COMP-3          
                                                      VALUE 0.          
           05  S-CODE-ADJUST-TYPE      PIC X(01) VALUE SPACES.          
           05  S-INFO-ONLY-FLAG        PIC X(01) VALUE SPACES.          
           05  S-COMPONENT-ID          PIC X(02) VALUE SPACES.          
           05  S-CODE-TOU              PIC S9(4) COMP.                  
           05  S-CODE-SEASON           PIC X(01) VALUE SPACES.          
           05  S-SEAS-PRORATE-PCT      PIC S9(1)V9(5) USAGE COMP-3      
                                                      VALUE 0.          
           05  S-NET-UNIT-SEL-RSN      PIC X(01) VALUE SPACES.          
           05  S-SPCL-GRP-CD           PIC X(02) VALUE SPACES.          
                                                                        
      *********************************************************                 
      *   GTT TABLE LAYOUT FOR BUS RULE ERROR MESSAGE        *                  
      *********************************************************                 
           05 GTT-RETURN-FIELDS-RS5.                                    
             10 S5-RETURN-CODE              PIC S9(09) COMP VALUE 0.    
             10 S5-APPL-RETURN-CODE         PIC S9(09) COMP VALUE 0.    
             10 S5-BUS-RULE-ID              PIC X(10)  VALUE SPACES.    
             10 S5-BUS-RULE-RESULT-CD       PIC X(10)  VALUE SPACES.    
             10 S5-BUS-RULE-XREF-ID         PIC X(26)  VALUE SPACES.    
             10 S5-MESSAGE-PARMS            PIC X(55)  VALUE SPACES.    
             10 S5-LINK-PARMS               PIC X(10)  VALUE SPACES.    
             10 S5-COMPONENT-KEY            PIC X(08)  VALUE SPACES.    
                                                                        
      **** COPYBOOKS NEEDED TO CALL BILL CALCULATION ROUTINE                    
           EXEC SQL                                                             
              INCLUDE CWS0022B                                                  
           END-EXEC.                                                            
      *                                                                         
      **** CONTAINS COMMON SUBROUTINE DATA                                      
           COPY CWS0024B.                                                       
      *                                                                         
      **** CA00 WORK DATA                                                       
           COPY CWS00039.                                                       
      *                                                                         
      **** GL NUMBERS                                                           
           COPY CWS00061.                                                       
      *                                                                         
      **** CONTAINS BE01 RECORD LAYOUTS                                         
           COPY CWS1001A.                                                       
           COPY CWS1001B.                                                       
      *                                                                         
      **** CONTAINS BE00 RECORD LAYOUTS                                         
           COPY CWS1000A.                                                       
           COPY CWS1000B.                                                       
      *                                                                         
      **** MCSCB102 & MCSCB105 CALL                                             
      *    EXEC SQL                                                             
      *        INCLUDE CWS04515                                                 
      *    END-EXEC.                                                            
      *                                                                         
      **** MCSCB102 & MCSCB105 CALL                                             
           EXEC SQL                                                             
               INCLUDE CWSCA122                                                 
           END-EXEC.                                                            
      *                                                                         
      **** ERROR HANDLING (ABEND VARIABLES)                                     
           EXEC SQL                                                             
               INCLUDE CWSCB122                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWSCB107                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
      *                                                                         
      **** DB2 AND SQL ERROR CHECKING                                           
           COPY CWS00303.                                                       
                                                                        
       01  WS-HOLD-CX-DATA                  PIC X(31000).               
       01  WS-HOLD-BC-DATA                  PIC X(100000).              
       01  WS-HOLD-BA-DATA                  PIC X(20400).               
       01  WS-ERR-FLAGS.                                                
           05  WS-ERR-INSRT-RS1             PIC X(01) VALUE 'N'.        
           05  WS-ERR-INSRT-RS2             PIC X(01) VALUE 'N'.        
           05  WS-ERR-INSRT-RS3             PIC X(01) VALUE 'N'.        
           05  WS-ERR-INSRT-RS4             PIC X(01) VALUE 'N'.        
           05  WS-ERR-INSRT-RS5             PIC X(01) VALUE 'N'.        
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9) COMP VALUE 0.         
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.           
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.           
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.           
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
                                                                        
      ******************************************************************        
      *  DECLARE CURSOR FOR FIXED FACTOR HISTORY                       *        
      ******************************************************************        
           EXEC SQL                                                     
                DECLARE FIXED_FCT_HIST CURSOR FOR                       
                  SELECT ACCOUNT_NO        ,                            
                         BILL_NO           ,                            
                         CODE_UTIL_TYPE    ,                            
                         IC_NO             ,                            
                         CODE_TIME_PERIOD  ,                            
                         REPLACE(REPLACE(CONVERT(CHAR(26), 
           BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP,                            
                         EFF_DATE_FROM     ,                            
                         FACTOR_ID         ,                            
                         CODE_DEBIT_CREDIT ,                            
                         CMPNT_ID_CD       ,                            
                         CODE_SEASON       ,                            
                         INSTR_USE_TYPE_CD ,                            
                         CODE_REVENUE_CLASS,                            
                         CODE_TAX_STAT_XMT ,                            
                         CODE_TAX_CITY_XMT ,                            
                         CODE_TAX_OTHR_XMT ,                            
                         FACTOR            ,                            
                         EFF_DATE_TO                                    
                    FROM CSS_FIXED_FCT_HIST WITH(READUNCOMMITTED)               
                   WHERE ACCOUNT_NO         = :WS-ACCOUNT-NO            
                     AND BILL_NO            = :WS-BILL-NO               
                     AND IC_NO              = :WS-IC-NO                 
                     AND CODE_UTIL_TYPE     = :WS-CODE-UTIL-TYPE        
                     AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :WS-BILL-ITEM-TIMESTMP
              )    
                  FOR READ ONLY                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE FIXED_FCT_HIST CURSOR FOR                               
MFA-TR*           SELECT ACCOUNT_NO        ,                                    
MFA-TR*                  BILL_NO           ,                                    
MFA-TR*                  CODE_UTIL_TYPE    ,                                    
MFA-TR*                  IC_NO             ,                                    
MFA-TR*                  CODE_TIME_PERIOD  ,                                    
MFA-TR*                  BILL_ITEM_TIMESTMP,                                    
MFA-TR*                  EFF_DATE_FROM     ,                                    
MFA-TR*                  FACTOR_ID         ,                                    
MFA-TR*                  CODE_DEBIT_CREDIT ,                                    
MFA-TR*                  CMPNT_ID_CD       ,                                    
MFA-TR*                  CODE_SEASON       ,                                    
MFA-TR*                  INSTR_USE_TYPE_CD ,                                    
MFA-TR*                  CODE_REVENUE_CLASS,                                    
MFA-TR*                  CODE_TAX_STAT_XMT ,                                    
MFA-TR*                  CODE_TAX_CITY_XMT ,                                    
MFA-TR*                  CODE_TAX_OTHR_XMT ,                                    
MFA-TR*                  FACTOR            ,                                    
MFA-TR*                  EFF_DATE_TO                                            
MFA-TR*             FROM CSS_FIXED_FCT_HIST                                     
MFA-TR*            WHERE ACCOUNT_NO         = :WS-ACCOUNT-NO                    
MFA-TR*              AND BILL_NO            = :WS-BILL-NO                       
MFA-TR*              AND IC_NO              = :WS-IC-NO                         
MFA-TR*              AND CODE_UTIL_TYPE     = :WS-CODE-UTIL-TYPE                
MFA-TR*              AND BILL_ITEM_TIMESTMP = :WS-BILL-ITEM-TIMESTMP            
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  DECLARE CURSOR FOR BILL ADJUSTMENT TABLE                      *        
      ******************************************************************        
           EXEC SQL                                                     
              DECLARE BILL_ADJ_CSR CURSOR FOR                           
                 SELECT ADJ_TYPE_CD,                                    
                        REVENUE_MONTH,                                  
                        ADJ_REASON_DESC,                                
                        OVRRIDE_RT_REV_MTH,                             
                        OVRRIDE_RT_BILL_DT,                             
                        OVRRIDE_RT_BILL_CY                              
                FROM CSS_BILL_ADJUSTMNT WITH(READUNCOMMITTED)                   
               WHERE ACCOUNT_NO         = :WS-ACCOUNT-NO                
                 AND BILL_NO            = :WS-BILL-NO                   
                 AND CODE_UTIL_TYPE     = :WS-CODE-UTIL-TYPE            
                 AND IC_NO              = :WS-IC-NO                     
                 AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :WS-BILL-ITEM-TIMESTMP
              )        
                 FOR READ ONLY                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE BILL_ADJ_CSR CURSOR FOR                                   
MFA-TR*          SELECT ADJ_TYPE_CD,                                            
MFA-TR*                 REVENUE_MONTH,                                          
MFA-TR*                 ADJ_REASON_DESC,                                        
MFA-TR*                 OVRRIDE_RT_REV_MTH,                                     
MFA-TR*                 OVRRIDE_RT_BILL_DT,                                     
MFA-TR*                 OVRRIDE_RT_BILL_CY                                      
MFA-TR*         FROM CSS_BILL_ADJUSTMNT                                         
MFA-TR*        WHERE ACCOUNT_NO         = :WS-ACCOUNT-NO                        
MFA-TR*          AND BILL_NO            = :WS-BILL-NO                           
MFA-TR*          AND CODE_UTIL_TYPE     = :WS-CODE-UTIL-TYPE                    
MFA-TR*          AND IC_NO              = :WS-IC-NO                             
MFA-TR*          AND BILL_ITEM_TIMESTMP = :WS-BILL-ITEM-TIMESTMP                
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  DECLARE CURSOR FOR METERED ENVIRONMENT                        *        
      ******************************************************************        
      /                                                                         
           EXEC SQL                                                     
                DECLARE MTRD_ENVRNMT CURSOR FOR                         
                SELECT                                                  
                    ACCOUNT_NO,                                         
                    CODE_UTIL_TYPE,                                     
                    IC_NO,                                              
                    MTR_REF_NO,                                         
                    CODE_TIME_PERIOD,                                   
                    METER_NO,                                           
                    CODE_DISCOUNT,                                      
                    CODE_METER_LOC,                                     
                    CODE_METER_STATUS,                                  
                    CODE_STATUS_REAS,                                   
                    CODE_ALRT_CHNG_IND,                                 
                    DIST_NODE_POINT,                                    
                    CODE_DIVERSION,                                     
                    DATE_MTR_INSTALL,                                   
                    CODE_SPCL_SEAL,                                     
                    EST_USAGE,                                          
                    SPCL_MTR_CONDITION,                                 
                    CODE_DATA_PRESENT,                                  
                    CODE_USAGE_TYPE,                                    
                    CODE_USAGE_ID,                                      
                    CODE_USAGE_SOURCE,                                  
                    REG_ID_NO,                                          
                    REGISTER_RD_SEQ,                                    
                    CODE_CRNT_REG_READ,                                 
                    CODE_NO_RD_REASON,                                  
                    CODE_LAST_REG_READ,                                 
                    REPLACE(CONVERT(CHAR(8), LAST_REG_READ_TIME, 108), 
           ':', '.') LAST_REG_READ_TIME,                                 
                    LAST_REG_READ_DATE,                                 
                    LAST_READ_VALUE,                                    
                    NO_CONSEC_CRD_READ,                                 
                    NO_CONSEC_ESTIMATE,                                 
                    POINT_ID,                                           
                    LOCK_TYPE_ID,                                       
                    SEAL_CODE_ID,                                       
                    HEXAGRAM_LOCATION,                                  
                    INSULATED_IND,                                      
                    METER_SUPPLYING,                                    
                    REPLACE(CONVERT(CHAR(8), LAST_VALID_READ_TM, 108), 
           ':', '.') LAST_VALID_READ_TM,                                 
                    LAST_VALID_READ_DT,                                 
                    READ_CARD_PRINT_DT,                                 
                    EXCEPT_OVERRIDE_CD,                                 
                    CODE_MTR_RD_INST1,                                  
                    CODE_MTR_RD_INST2,                                  
                    CODE_MTR_RD_INST3,                                  
                    DIGTL_MTR_TYPE,                                     
                    REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS,                        
                    LAST_VAL_RD_VALUE,                                  
                    CODE_LAST_VALID_RD,                                 
                    REMOTE_READ_IND,                                    
                    MTR_READ_SOURCE_CD,                                 
                    UTILITY_SOURCE_CD,                                  
                    DELIVERY_LEVEL_CD,                                  
                    MTR_STATUS_CHNG_DT                                  
                FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                     
                WHERE ACCOUNT_NO     = :WS-ACCOUNT-NO      AND          
                      CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE  AND          
                      IC_NO          = :WS-IC-NO           AND          
                      CODE_METER_STATUS <> 'B'             AND          
                      METER_NO       > '         '                      
                FOR READ ONLY                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE MTRD_ENVRNMT CURSOR FOR                                 
MFA-TR*         SELECT                                                          
MFA-TR*             ACCOUNT_NO,                                                 
MFA-TR*             CODE_UTIL_TYPE,                                             
MFA-TR*             IC_NO,                                                      
MFA-TR*             MTR_REF_NO,                                                 
MFA-TR*             CODE_TIME_PERIOD,                                           
MFA-TR*             METER_NO,                                                   
MFA-TR*             CODE_DISCOUNT,                                              
MFA-TR*             CODE_METER_LOC,                                             
MFA-TR*             CODE_METER_STATUS,                                          
MFA-TR*             CODE_STATUS_REAS,                                           
MFA-TR*             CODE_ALRT_CHNG_IND,                                         
MFA-TR*             DIST_NODE_POINT,                                            
MFA-TR*             CODE_DIVERSION,                                             
MFA-TR*             DATE_MTR_INSTALL,                                           
MFA-TR*             CODE_SPCL_SEAL,                                             
MFA-TR*             EST_USAGE,                                                  
MFA-TR*             SPCL_MTR_CONDITION,                                         
MFA-TR*             CODE_DATA_PRESENT,                                          
MFA-TR*             CODE_USAGE_TYPE,                                            
MFA-TR*             CODE_USAGE_ID,                                              
MFA-TR*             CODE_USAGE_SOURCE,                                          
MFA-TR*             REG_ID_NO,                                                  
MFA-TR*             REGISTER_RD_SEQ,                                            
MFA-TR*             CODE_CRNT_REG_READ,                                         
MFA-TR*             CODE_NO_RD_REASON,                                          
MFA-TR*             CODE_LAST_REG_READ,                                         
MFA-TR*             LAST_REG_READ_TIME,                                         
MFA-TR*             LAST_REG_READ_DATE,                                         
MFA-TR*             LAST_READ_VALUE,                                            
MFA-TR*             NO_CONSEC_CRD_READ,                                         
MFA-TR*             NO_CONSEC_ESTIMATE,                                         
MFA-TR*             POINT_ID,                                                   
MFA-TR*             LOCK_TYPE_ID,                                               
MFA-TR*             SEAL_CODE_ID,                                               
MFA-TR*             HEXAGRAM_LOCATION,                                          
MFA-TR*             INSULATED_IND,                                              
MFA-TR*             METER_SUPPLYING,                                            
MFA-TR*             LAST_VALID_READ_TM,                                         
MFA-TR*             LAST_VALID_READ_DT,                                         
MFA-TR*             READ_CARD_PRINT_DT,                                         
MFA-TR*             EXCEPT_OVERRIDE_CD,                                         
MFA-TR*             CODE_MTR_RD_INST1,                                          
MFA-TR*             CODE_MTR_RD_INST2,                                          
MFA-TR*             CODE_MTR_RD_INST3,                                          
MFA-TR*             DIGTL_MTR_TYPE,                                             
MFA-TR*             LAST_UPDATE_TS,                                             
MFA-TR*             LAST_VAL_RD_VALUE,                                          
MFA-TR*             CODE_LAST_VALID_RD,                                         
MFA-TR*             REMOTE_READ_IND,                                            
MFA-TR*             MTR_READ_SOURCE_CD,                                         
MFA-TR*             UTILITY_SOURCE_CD,                                          
MFA-TR*             DELIVERY_LEVEL_CD,                                          
MFA-TR*             MTR_STATUS_CHNG_DT                                          
MFA-TR*         FROM CSS_MTRD_ENVRNMT                                           
MFA-TR*         WHERE ACCOUNT_NO     = :WS-ACCOUNT-NO      AND                  
MFA-TR*               CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE  AND                  
MFA-TR*               IC_NO          = :WS-IC-NO           AND                  
MFA-TR*               CODE_METER_STATUS <> 'B'             AND                  
MFA-TR*               METER_NO       > '         '                              
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  DECLARE CURSOR FOR CONSUMPTION HISTORY                        *        
      ******************************************************************        
           EXEC SQL                                                     
                DECLARE CNSMPTN_HIST CURSOR FOR                         
                  SELECT ACCOUNT_NO        ,                            
                         BILL_NO           ,                            
                         CODE_UTIL_TYPE    ,                            
                         IC_NO             ,                            
                         REPLACE(REPLACE(CONVERT(CHAR(26), 
           BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP,                            
                         CODE_TIME_PERIOD  ,                            
                         MTR_REF_NO        ,                            
                         CODE_USAGE_TYPE   ,                            
                         CODE_USAGE_ID     ,                            
                         CODE_USAGE_SOURCE ,                            
                         ITEM_SEQ_NO       ,                            
                         METER_NO          ,                            
                         REG_ID_NO         ,                            
                         DATE_READ         ,                            
                         CODE_METER_READ   ,                            
                         CODE_METER_NO_READ,                            
                         METER_READING     ,                            
                         DEMAND_READING    ,                            
                         EMPLOYEE_NO       ,                            
                         NO_UNITS          ,                            
                         NO_DEMAND_UNITS   ,                            
                         NO_DAYS           ,                            
                         CODE_SOURCE_ID    ,                            
                         CODE_DEBIT_CREDIT ,                            
                         CODE_ITEM_STATUS  ,                            
                         CODE_DISCOUNT     ,                            
                         CONSTANT          ,                            
                         NO_DIALS          ,                            
                         COMPANY_NO        ,                            
                         EXCEPT_OVERRIDE_CD,                            
                         REQUESTED_USAGE   ,                            
                         DIGTL_INTRL_MTR_NO,                            
                         DIGTL_MTR_TYPE    ,                            
                         CODE_TOU_SEASN    ,                            
                         EXCL_DMD_RCHT_IND                              
                    FROM CSS_CNSMPTN_HIST WITH(READUNCOMMITTED)                 
                   WHERE ACCOUNT_NO         = :WS-ACCOUNT-NO            
                     AND BILL_NO            = :WS-BILL-NO               
                     AND CODE_UTIL_TYPE     = :WS-CODE-UTIL-TYPE        
                     AND IC_NO              = :WS-IC-NO                 
                     AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :WS-BILL-ITEM-TIMESTMP
              )    
                     AND CODE_USAGE_ID     <> 'X'                       
                  FOR READ ONLY                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE CNSMPTN_HIST CURSOR FOR                                 
MFA-TR*           SELECT ACCOUNT_NO        ,                                    
MFA-TR*                  BILL_NO           ,                                    
MFA-TR*                  CODE_UTIL_TYPE    ,                                    
MFA-TR*                  IC_NO             ,                                    
MFA-TR*                  BILL_ITEM_TIMESTMP,                                    
MFA-TR*                  CODE_TIME_PERIOD  ,                                    
MFA-TR*                  MTR_REF_NO        ,                                    
MFA-TR*                  CODE_USAGE_TYPE   ,                                    
MFA-TR*                  CODE_USAGE_ID     ,                                    
MFA-TR*                  CODE_USAGE_SOURCE ,                                    
MFA-TR*                  ITEM_SEQ_NO       ,                                    
MFA-TR*                  METER_NO          ,                                    
MFA-TR*                  REG_ID_NO         ,                                    
MFA-TR*                  DATE_READ         ,                                    
MFA-TR*                  CODE_METER_READ   ,                                    
MFA-TR*                  CODE_METER_NO_READ,                                    
MFA-TR*                  METER_READING     ,                                    
MFA-TR*                  DEMAND_READING    ,                                    
MFA-TR*                  EMPLOYEE_NO       ,                                    
MFA-TR*                  NO_UNITS          ,                                    
MFA-TR*                  NO_DEMAND_UNITS   ,                                    
MFA-TR*                  NO_DAYS           ,                                    
MFA-TR*                  CODE_SOURCE_ID    ,                                    
MFA-TR*                  CODE_DEBIT_CREDIT ,                                    
MFA-TR*                  CODE_ITEM_STATUS  ,                                    
MFA-TR*                  CODE_DISCOUNT     ,                                    
MFA-TR*                  CONSTANT          ,                                    
MFA-TR*                  NO_DIALS          ,                                    
MFA-TR*                  COMPANY_NO        ,                                    
MFA-TR*                  EXCEPT_OVERRIDE_CD,                                    
MFA-TR*                  REQUESTED_USAGE   ,                                    
MFA-TR*                  DIGTL_INTRL_MTR_NO,                                    
MFA-TR*                  DIGTL_MTR_TYPE    ,                                    
MFA-TR*                  CODE_TOU_SEASN    ,                                    
MFA-TR*                  EXCL_DMD_RCHT_IND                                      
MFA-TR*             FROM CSS_CNSMPTN_HIST                                       
MFA-TR*            WHERE ACCOUNT_NO         = :WS-ACCOUNT-NO                    
MFA-TR*              AND BILL_NO            = :WS-BILL-NO                       
MFA-TR*              AND CODE_UTIL_TYPE     = :WS-CODE-UTIL-TYPE                
MFA-TR*              AND IC_NO              = :WS-IC-NO                         
MFA-TR*              AND BILL_ITEM_TIMESTMP = :WS-BILL-ITEM-TIMESTMP            
MFA-TR*              AND CODE_USAGE_ID     <> 'X'                               
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  DECLARE CURSOR FOR BILLING DETAILS                            *        
      ******************************************************************        
           EXEC SQL                                                     
                DECLARE BILLING_DET CURSOR FOR                          
                  SELECT PREMISE_NO        ,                            
                         BILL_NO           ,                            
                         CODE_UTIL_TYPE    ,                            
                         IC_NO             ,                            
                         REPLACE(REPLACE(CONVERT(CHAR(26), 
           BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP,                            
                         DATE_ORIG_BILL    ,                            
                         AMT_BILL_ITEM     ,                            
                         CODE_BILL_CALC    ,                            
                         CODE_BILL_ITM_TYPE,                            
                         CODE_BILL_ITM_IND ,                            
                         CODE_DR_CR_CNSMPTN,                            
                         AMT_STATE_TAX     ,                            
                         AMT_CITY_TAX      ,                            
                         AMT_OTHER_TAX     ,                            
                         CODE_REVENUE_CLASS,                            
                         CODE_SIC_NO       ,                            
                         RATE_PLAN_NO      ,                            
                         CODE_CURTAIL_PRTY ,                            
                         CODE_STAT_TAX_XMT ,                            
                         CODE_CITY_TAX_XMT ,                            
                         CODE_OTHR_TAX_XMT ,                            
                         REV_RPT_CD        ,                            
                         STANDBY_COMPLIED  ,                            
                         PRORATE_CD        ,                            
                         NEW_RATE_PCT      ,                            
                         CODE_SUB_TOTAL    ,                            
                         TAX_REFUND_CD     ,                            
                         ACCOUNT_NO        ,                            
                         COMPANY_NO        ,                            
                         DATE_LFTM_HI_DMD  ,                            
                         LFTM_HI_PEAK_DMD  ,                            
                         REBILL_IND        ,                            
                         ADJ_REASON_CD     ,                            
                         REVENUE_MONTH     ,                            
                         GAS_BASE_USE      ,                            
                         WNA_FACTOR        ,                            
                         BTU_FACTOR        ,                            
                         REV_MTH_ORIG_BILL ,                            
                         BILL_CALC_CYCLE,                               
                         RT_PKG_OPT_SEQ_NO,                             
                         STATE_TAX_RATE,                                
                         CITY_TAX_RATE                                  
                    FROM CSS_BILLING_DET WITH(READUNCOMMITTED)                  
                   WHERE ACCOUNT_NO         = :WS-ACCOUNT-NO            
                     AND BILL_NO            = :WS-BILL-NO               
                     AND IC_NO              = :WS-IC-NO                 
                     AND CODE_UTIL_TYPE     = :WS-CODE-UTIL-TYPE        
                     AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :WS-BILL-ITEM-TIMESTMP
              )    
                  FOR READ ONLY                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE BILLING_DET CURSOR FOR                                  
MFA-TR*           SELECT PREMISE_NO        ,                                    
MFA-TR*                  BILL_NO           ,                                    
MFA-TR*                  CODE_UTIL_TYPE    ,                                    
MFA-TR*                  IC_NO             ,                                    
MFA-TR*                  BILL_ITEM_TIMESTMP,                                    
MFA-TR*                  DATE_ORIG_BILL    ,                                    
MFA-TR*                  AMT_BILL_ITEM     ,                                    
MFA-TR*                  CODE_BILL_CALC    ,                                    
MFA-TR*                  CODE_BILL_ITM_TYPE,                                    
MFA-TR*                  CODE_BILL_ITM_IND ,                                    
MFA-TR*                  CODE_DR_CR_CNSMPTN,                                    
MFA-TR*                  AMT_STATE_TAX     ,                                    
MFA-TR*                  AMT_CITY_TAX      ,                                    
MFA-TR*                  AMT_OTHER_TAX     ,                                    
MFA-TR*                  CODE_REVENUE_CLASS,                                    
MFA-TR*                  CODE_SIC_NO       ,                                    
MFA-TR*                  RATE_PLAN_NO      ,                                    
MFA-TR*                  CODE_CURTAIL_PRTY ,                                    
MFA-TR*                  CODE_STAT_TAX_XMT ,                                    
MFA-TR*                  CODE_CITY_TAX_XMT ,                                    
MFA-TR*                  CODE_OTHR_TAX_XMT ,                                    
MFA-TR*                  REV_RPT_CD        ,                                    
MFA-TR*                  STANDBY_COMPLIED  ,                                    
MFA-TR*                  PRORATE_CD        ,                                    
MFA-TR*                  NEW_RATE_PCT      ,                                    
MFA-TR*                  CODE_SUB_TOTAL    ,                                    
MFA-TR*                  TAX_REFUND_CD     ,                                    
MFA-TR*                  ACCOUNT_NO        ,                                    
MFA-TR*                  COMPANY_NO        ,                                    
MFA-TR*                  DATE_LFTM_HI_DMD  ,                                    
MFA-TR*                  LFTM_HI_PEAK_DMD  ,                                    
MFA-TR*                  REBILL_IND        ,                                    
MFA-TR*                  ADJ_REASON_CD     ,                                    
MFA-TR*                  REVENUE_MONTH     ,                                    
MFA-TR*                  GAS_BASE_USE      ,                                    
MFA-TR*                  WNA_FACTOR        ,                                    
MFA-TR*                  BTU_FACTOR        ,                                    
MFA-TR*                  REV_MTH_ORIG_BILL ,                                    
MFA-TR*                  BILL_CALC_CYCLE,                                       
MFA-TR*                  RT_PKG_OPT_SEQ_NO,                                     
MFA-TR*                  STATE_TAX_RATE,                                        
MFA-TR*                  CITY_TAX_RATE                                          
MFA-TR*             FROM CSS_BILLING_DET                                        
MFA-TR*            WHERE ACCOUNT_NO         = :WS-ACCOUNT-NO                    
MFA-TR*              AND BILL_NO            = :WS-BILL-NO                       
MFA-TR*              AND IC_NO              = :WS-IC-NO                         
MFA-TR*              AND CODE_UTIL_TYPE     = :WS-CODE-UTIL-TYPE                
MFA-TR*              AND BILL_ITEM_TIMESTMP = :WS-BILL-ITEM-TIMESTMP            
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  DECLARE CURSOR FOR UNMETERED CONSUMPTION HISTORY              *        
      ******************************************************************        
           EXEC SQL                                                     
               DECLARE UM_CNSMPT_HIST CURSOR FOR                        
                 SELECT ACCOUNT_NO,                                     
                        BILL_NO,                                        
                        CODE_UTIL_TYPE,                                 
                        IC_NO,                                          
                        REPLACE(REPLACE(CONVERT(CHAR(26), 
           BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP,                             
                        RATE_ITEM_CODE    ,                             
                        ITEM_SEQ_NO       ,                             
                        NO_UNITS          ,                             
                        NO_DAYS           ,                             
                        CODE_DEBIT_CREDIT ,                             
                        USAGE_FIXED       ,                             
                        DATE_USAGE_ENDS   ,                             
                        CODE_SERVICE_TYPE ,                             
                        CODE_ITEM_STATUS  ,                             
                        CODE_SOURCE_ID    ,                             
                        MTHLY_AMOUNT_FIXED,                             
                        DIST_NO           ,                             
                        LIGHT_NO          ,                             
                        POLE_NO                                         
                   FROM CSS_UM_CNSMPT_HIST WITH(READUNCOMMITTED)                
                  WHERE ACCOUNT_NO         = :WS-ACCOUNT-NO             
                    AND BILL_NO            = :WS-BILL-NO                
                    AND CODE_UTIL_TYPE     = :WS-CODE-UTIL-TYPE         
                    AND IC_NO              = :WS-IC-NO                  
                    AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :WS-BILL-ITEM-TIMESTMP
              )     
                 FOR READ ONLY                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE UM_CNSMPT_HIST CURSOR FOR                                
MFA-TR*          SELECT ACCOUNT_NO,                                             
MFA-TR*                 BILL_NO,                                                
MFA-TR*                 CODE_UTIL_TYPE,                                         
MFA-TR*                 IC_NO,                                                  
MFA-TR*                 BILL_ITEM_TIMESTMP,                                     
MFA-TR*                 RATE_ITEM_CODE    ,                                     
MFA-TR*                 ITEM_SEQ_NO       ,                                     
MFA-TR*                 NO_UNITS          ,                                     
MFA-TR*                 NO_DAYS           ,                                     
MFA-TR*                 CODE_DEBIT_CREDIT ,                                     
MFA-TR*                 USAGE_FIXED       ,                                     
MFA-TR*                 DATE_USAGE_ENDS   ,                                     
MFA-TR*                 CODE_SERVICE_TYPE ,                                     
MFA-TR*                 CODE_ITEM_STATUS  ,                                     
MFA-TR*                 CODE_SOURCE_ID    ,                                     
MFA-TR*                 MTHLY_AMOUNT_FIXED,                                     
MFA-TR*                 DIST_NO           ,                                     
MFA-TR*                 LIGHT_NO          ,                                     
MFA-TR*                 POLE_NO                                                 
MFA-TR*            FROM CSS_UM_CNSMPT_HIST                                      
MFA-TR*           WHERE ACCOUNT_NO         = :WS-ACCOUNT-NO                     
MFA-TR*             AND BILL_NO            = :WS-BILL-NO                        
MFA-TR*             AND CODE_UTIL_TYPE     = :WS-CODE-UTIL-TYPE                 
MFA-TR*             AND IC_NO              = :WS-IC-NO                          
MFA-TR*             AND BILL_ITEM_TIMESTMP = :WS-BILL-ITEM-TIMESTMP             
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*    END-EXEC.                                                            
      ******************************************************************        
      *  DECLARE CURSOR TO GET ALL METERD IC'S UNDER UNBILLED ROW      *        
      ******************************************************************        
           EXEC SQL                                                     
                DECLARE CUST_PLAN_CSR CURSOR FOR                        
                SELECT                                                  
                    ACCOUNT_NO,                                         
                    CODE_UTIL_TYPE,                                     
                    IC_NO,                                              
                    RATE_ITEM_CODE,                                     
                    ITEM_SEQ_NO,                                        
                    CODE_PLAN_STATUS,                                   
                    CODE_STAT_REASON,                                   
                    DATE_PLAN_START,                                    
                    CODE_SERVICE_TYPE,                                  
                    USAGE_FIXED,                                        
                    MTHLY_AMOUNT_FIXED,                                 
                    NO_UNITS,                                           
                    REMOVE_DATE,                                        
                    DIST_NO,                                            
                    POLE_NO,                                            
                    LIGHT_NO,                                           
                    LAST_BILL_DATE                                      
                 FROM CSS_CUST_PLAN WITH(READUNCOMMITTED)                       
                WHERE ACCOUNT_NO       = :WS-ACCOUNT-NO      AND        
                      CODE_UTIL_TYPE   = :WS-CODE-UTIL-TYPE  AND        
                      IC_NO            = :WS-IC-NO           AND        
                      ((CODE_PLAN_STATUS = 'A'               AND        
                        DATE_PLAN_START <= CAST(SYSDATETIMEOFFSET() 
           AS DATE) )               
                       OR REMOVE_DATE > LAST_BILL_DATE)                 
              FOR READ ONLY                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     01127000
MFA-TR*         DECLARE CUST_PLAN_CSR CURSOR FOR                        01128000
MFA-TR*         SELECT                                                  01129000
MFA-TR*             ACCOUNT_NO,                                         01130000
MFA-TR*             CODE_UTIL_TYPE,                                     01131000
MFA-TR*             IC_NO,                                              01132000
MFA-TR*             RATE_ITEM_CODE,                                     01133000
MFA-TR*             ITEM_SEQ_NO,                                        01134000
MFA-TR*             CODE_PLAN_STATUS,                                   01135000
MFA-TR*             CODE_STAT_REASON,                                   01136000
MFA-TR*             DATE_PLAN_START,                                    01137000
MFA-TR*             CODE_SERVICE_TYPE,                                  01138000
MFA-TR*             USAGE_FIXED,                                        01139000
MFA-TR*             MTHLY_AMOUNT_FIXED,                                 01140000
MFA-TR*             NO_UNITS,                                           01141000
MFA-TR*             REMOVE_DATE,                                        01142000
MFA-TR*             DIST_NO,                                            01143000
MFA-TR*             POLE_NO,                                            01144000
MFA-TR*             LIGHT_NO,                                           01145000
MFA-TR*             LAST_BILL_DATE                                      01146000
MFA-TR*          FROM CSS_CUST_PLAN                                     01147000
MFA-TR*         WHERE ACCOUNT_NO       = :WS-ACCOUNT-NO      AND        01148000
MFA-TR*               CODE_UTIL_TYPE   = :WS-CODE-UTIL-TYPE  AND        01149000
MFA-TR*               IC_NO            = :WS-IC-NO           AND        01150000
MFA-TR*               ((CODE_PLAN_STATUS = 'A'               AND        01151000
MFA-TR*                 DATE_PLAN_START <= CURRENT DATE )               01152000
MFA-TR*                OR REMOVE_DATE > LAST_BILL_DATE)                 01153000
MFA-TR*       FOR FETCH ONLY WITH UR                                    01154000
MFA-TR*    END-EXEC.                                                    01155000
                                                                        
HPCCDM*EJECT                                                                    
       LINKAGE SECTION.                                                 
COB305 01 PARM-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.     
       01  PARM-BILL-NO                   PIC S9(4) COMP.               
       01  PARM-UTIL-TYPE                 PIC X(01).                    
       01  PARM-IC-NO                     PIC S9(4) COMP.               
       01  PARM-BILL-ITEM-TIMESTAMP       PIC X(26).                    
       01  PARM-BUS-PROC-ID               PIC X(10).                    
                                                                        
       PROCEDURE DIVISION  USING                                        
                           PARM-ACCOUNT-NO                              
                           PARM-BILL-NO                                 
                           PARM-UTIL-TYPE                               
                           PARM-IC-NO                                   
                           PARM-BILL-ITEM-TIMESTAMP                     
                           PARM-BUS-PROC-ID.                            
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE            THRU 0100-EXIT.           
           PERFORM 1000-PROCESS-INPUT         THRU 1000-EXIT.           
           PERFORM 2000-PROCESS-OUTPUT        THRU 2000-EXIT.           
           PERFORM 9999-END-PROGRAM           THRU 9999-EXIT.           
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           PERFORM 8655-SELECT-COMMON-DATE THRU 8655-EXIT.              
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
                                                                        
           INITIALIZE LS-PCSCA100-COMM-AREA                             
                      WS-BILLING-CALC-WORK                              
                      WS-BILLING-COMPONENT                              
                      WS-BILLING-ADJUSTMENT                             
                      WS-BILL-CALC-BG                                   
                      WS-BILL-CALC-CX                                   
                      WS-BILL-CALC-UC                                   
                      WS-BILL-CALC-FH                                   
                      WS-BILL-CONTRACT-BK                               
                      WS-FIXED-FCTR-TABLE-FF                            
                      WS-BILL-CNTR-HIST-BX                              
                      WS-PEAK-HIST-PH                                   
                      WS-INTERRUPT-ACCT-IP                              
                      WS-STANDBY-GEN-SE                                 
                      WS-INTERRUPT-IR                                   
                      WS-MTRD-ENVRNMT-TABLE-MN                          
                      WS-HOLD-CX-DATA                                   
                      WS-HOLD-BC-DATA                                   
                      WS-HOLD-BA-DATA                                   
                      WS-BILLING-WQ-ITEMS-WF                            
                      WS-REFUND-RN                                      
                      WS-INTERRUPT-AMT                                  
                      TDS-RETURN-FIELDS                                 
                      WS-BILL-CALC-DETAIL-X                             
                      WS-BC-VOL-DAILY-ND                                
                      WS-BILL-BSLN-CNTR-LN                              
                      WS-BILL-BSLN-HIST-LO                              
                      WS-UTL-BILL-REL-TABLE-UR                          
                      WS-INTERRUPT-NZ.                                  
      *               WS-CPD4515-INPUTS.                                        
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1  THRU 0100A-EXIT.               
           PERFORM 0100B-DECLARE-GTT-R2  THRU 0100B-EXIT.               
           PERFORM 0100C-DECLARE-GTT-R3  THRU 0100C-EXIT.               
           PERFORM 0100D-DECLARE-GTT-R4  THRU 0100D-EXIT.               
           PERFORM 0100E-DECLARE-GTT-R5  THRU 0100E-EXIT.               
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *0100A-DECLARE-GTT-R1                                            *        
      ******************************************************************        
       0100A-DECLARE-GTT-R1.                                            
           MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR04686_R1'            
                                             TO S-SQL-STATEMENT-V.      
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04686_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04686_R1
              (                                                       
                  RETURN_CODE          INT                          
                 ,APPL_RETURN_CODE     INT                          
                 ,NO_OF_DAYS           SMALLINT                         
                 ,STATE_TAX            DECIMAL(11,2)                    
                 ,CITY_TAX             DECIMAL(11,2)                    
                 ,OTHER_TAX            DECIMAL(11,2)                    
                 ,TOTAL_NET_UNITS      DECIMAL(11,2)                    
                 ,TOTAL_USAGE_CHRG     DECIMAL(11,2)                    
                 ,USAGE_CHRG           DECIMAL(11,2)                    
                 ,TOTAL_DEMAND_CHRG    DECIMAL(11,2)                    
                 ,DEMAND_CHRGS_CRDT    DECIMAL(11,2)                    
                 ,USAGE_CHRGS_CRDT     DECIMAL(11,2)                    
                 ,BASIC_FCLTY_CHRG     DECIMAL(11,2)                    
                 ,AGL_CHARGES          DECIMAL(13,4)                    
                 ,UNIT_PRICE_AMT       DECIMAL(11,6)                    
                 ,TOTAL_BILL_AMOUNT    DECIMAL(11,2)                    
                 ,REV_MONTH CHAR(06)  COLLATE LATIN1_GENERAL_100_BIN2           
                 ,RATE_PLAN CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2           
                 ,RATE_DESC CHAR(50)  COLLATE LATIN1_GENERAL_100_BIN2           
                 ,SVC_CAT CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2             
                 ,STATE_TAX_RATE       DECIMAL(11,6)                    
                 ,CITY_TAX_RATE        DECIMAL(11,6)                    
                 ,PARTIAL_XMPT_FL CHAR(01)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                         
                 ,RT_OVRD_BILL_CY CHAR(02)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                         
                 ,RT_OVRD_BILL_DT CHAR(10)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                         
                 ,RT_OVRD_REV_MTH      DECIMAL(06,0)                    
                 ,PRORTD_BILL_FL CHAR(01)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                         
                 ,READ_DATE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2           
                 ,PRORTD_BY_DAYS_FL CHAR(01)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                         
                 )
           END-EXEC.                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

             MOVE SQLSTATE                   TO WS-SQLSTATE.            
             MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.  
                                                                        
             IF WS-SQLSTATE = '42710'                                   
                PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT           
             ELSE                                                       
                IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL              
                   CONTINUE                                             
                ELSE                                                    
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE SQLCODE              TO ABEND-SQLCODE           
                   MOVE SQLSTATE             TO ABEND-SQLSTATE          
                   MOVE '0100A'              TO ACTIVE-PARAGRAPH        
                   MOVE 'DECLARE GTT'        TO ABEND-FUNCTION          
                   MOVE SPACES               TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                   MOVE 'CSR04686_R1'        TO TABLE-1                 
                   MOVE SPACES               TO TABLE-ELEMENT-1         
                   MOVE SPACES               TO HOSTVAR-ELEMENT-1       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
                END-IF                                                  
             END-IF.                                                    
                                                                        
           EXEC SQL                                                     
                DECLARE C1 CURSOR                            
                        WITH ROWSET POSITIONING FOR                     
                SELECT                                                  
                  RETURN_CODE                                           
                 ,APPL_RETURN_CODE                                      
                 ,NO_OF_DAYS                                            
                 ,STATE_TAX                                             
                 ,CITY_TAX                                              
                 ,OTHER_TAX                                             
                 ,TOTAL_NET_UNITS                                       
                 ,TOTAL_USAGE_CHRG                                      
                 ,USAGE_CHRG                                            
                 ,TOTAL_DEMAND_CHRG                                     
                 ,DEMAND_CHRGS_CRDT                                     
                 ,USAGE_CHRGS_CRDT                                      
                 ,BASIC_FCLTY_CHRG                                      
                 ,AGL_CHARGES                                           
                 ,UNIT_PRICE_AMT                                        
                 ,TOTAL_BILL_AMOUNT                                     
                 ,REV_MONTH                                             
                 ,RATE_PLAN                                             
                 ,RATE_DESC                                             
                 ,SVC_CAT                                               
                 ,STATE_TAX_RATE                                        
                 ,CITY_TAX_RATE                                         
                 ,PARTIAL_XMPT_FL                                       
                 ,RT_OVRD_BILL_CY                                       
                 ,RT_OVRD_BILL_DT                                       
                 ,RT_OVRD_REV_MTH                                       
                 ,PRORTD_BILL_FL                                        
                 ,READ_DATE                                             
                 ,PRORTD_BY_DAYS_FL                                     
                 FROM #CSR04686_R1                               
             END-EXEC.                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE C1 CURSOR WITH RETURN                                   
MFA-TR*                 WITH ROWSET POSITIONING FOR                             
MFA-TR*         SELECT                                                          
MFA-TR*           RETURN_CODE                                                   
MFA-TR*          ,APPL_RETURN_CODE                                              
MFA-TR*          ,NO_OF_DAYS                                                    
MFA-TR*          ,STATE_TAX                                                     
MFA-TR*          ,CITY_TAX                                                      
MFA-TR*          ,OTHER_TAX                                                     
MFA-TR*          ,TOTAL_NET_UNITS                                               
MFA-TR*          ,TOTAL_USAGE_CHRG                                              
MFA-TR*          ,USAGE_CHRG                                                    
MFA-TR*          ,TOTAL_DEMAND_CHRG                                             
MFA-TR*          ,DEMAND_CHRGS_CRDT                                             
MFA-TR*          ,USAGE_CHRGS_CRDT                                              
MFA-TR*          ,BASIC_FCLTY_CHRG                                              
MFA-TR*          ,AGL_CHARGES                                                   
MFA-TR*          ,UNIT_PRICE_AMT                                                
MFA-TR*          ,TOTAL_BILL_AMOUNT                                             
MFA-TR*          ,REV_MONTH                                                     
MFA-TR*          ,RATE_PLAN                                                     
MFA-TR*          ,RATE_DESC                                                     
MFA-TR*          ,SVC_CAT                                                       
MFA-TR*          ,STATE_TAX_RATE                                                
MFA-TR*          ,CITY_TAX_RATE                                                 
MFA-TR*          ,PARTIAL_XMPT_FL                                               
MFA-TR*          ,RT_OVRD_BILL_CY                                               
MFA-TR*          ,RT_OVRD_BILL_DT                                               
MFA-TR*          ,RT_OVRD_REV_MTH                                               
MFA-TR*          ,PRORTD_BILL_FL                                                
MFA-TR*          ,READ_DATE                                                     
MFA-TR*          ,PRORTD_BY_DAYS_FL                                             
MFA-TR*          FROM SESSION.CSR04686_R1                                       
MFA-TR*      END-EXEC.                                                          
      *                                                                         
       0100A-EXIT.                                                      
             EXIT.                                                      
      *                                                                         
      ******************************************************************        
      *0100B-DECLARE-GTT-R2                                            *        
      ******************************************************************        
       0100B-DECLARE-GTT-R2.                                            
           MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR04686_R2'            
                                             TO S-SQL-STATEMENT-V.      
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04686_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04686_R2
              (                                                       
                  RETURN_CODE          INT                          
                 ,APPL_RETURN_CODE     INT                          
                 ,FACTOR_DESC CHAR(54)  COLLATE LATIN1_GENERAL_100_BIN2         
                 ,FACTOR_ID CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2           
                 ,UNITS_BILLED         DECIMAL(11,2)                    
                 ,NET_RATE             DECIMAL(13,6)                    
                 ,COMPUTED_CHARGE      DECIMAL(11,2)                    
                 ,COMPONENT_KEY CHAR(08)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                         
                 ,SPCL_GROUP_CD CHAR(02)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                         
                 ,FACTOR_TYPE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
                 ,ADJUST_ELEMENT CHAR(01)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                         
                 ,CALC_TYPE_CD CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2        
                 ,BLOCK_NO CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2            
                    )
           END-EXEC.                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

             MOVE SQLSTATE                   TO WS-SQLSTATE.            
             MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.  
                                                                        
             IF WS-SQLSTATE = '42710'                                   
                PERFORM 8000B-DELETE-GTT-ROWS THRU 8000B-EXIT           
             ELSE                                                       
                IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL              
                   CONTINUE                                             
                ELSE                                                    
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE SQLCODE              TO ABEND-SQLCODE           
                   MOVE SQLSTATE             TO ABEND-SQLSTATE          
                   MOVE '0100B'              TO ACTIVE-PARAGRAPH        
                   MOVE 'DECLARE GTT'        TO ABEND-FUNCTION          
                   MOVE SPACES               TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                   MOVE 'CSR04686_R2'        TO TABLE-1                 
                   MOVE SPACES               TO TABLE-ELEMENT-1         
                   MOVE SPACES               TO HOSTVAR-ELEMENT-1       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
                END-IF                                                  
             END-IF.                                                    
                                                                        
           EXEC SQL                                                     
                DECLARE C2 CURSOR                            
                        WITH ROWSET POSITIONING FOR                     
                SELECT                                                  
                  RETURN_CODE                                           
                 ,APPL_RETURN_CODE                                      
                 ,FACTOR_DESC                                           
                 ,FACTOR_ID                                             
                 ,UNITS_BILLED                                          
                 ,NET_RATE                                              
                 ,COMPUTED_CHARGE                                       
                 ,COMPONENT_KEY                                         
                 ,SPCL_GROUP_CD                                         
                 ,FACTOR_TYPE                                           
                 ,ADJUST_ELEMENT                                        
                 ,CALC_TYPE_CD                                          
                 ,BLOCK_NO                                              
                FROM #CSR04686_R2                                
             END-EXEC.                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE C2 CURSOR WITH RETURN                                   
MFA-TR*                 WITH ROWSET POSITIONING FOR                             
MFA-TR*         SELECT                                                          
MFA-TR*           RETURN_CODE                                                   
MFA-TR*          ,APPL_RETURN_CODE                                              
MFA-TR*          ,FACTOR_DESC                                                   
MFA-TR*          ,FACTOR_ID                                                     
MFA-TR*          ,UNITS_BILLED                                                  
MFA-TR*          ,NET_RATE                                                      
MFA-TR*          ,COMPUTED_CHARGE                                               
MFA-TR*          ,COMPONENT_KEY                                                 
MFA-TR*          ,SPCL_GROUP_CD                                                 
MFA-TR*          ,FACTOR_TYPE                                                   
MFA-TR*          ,ADJUST_ELEMENT                                                
MFA-TR*          ,CALC_TYPE_CD                                                  
MFA-TR*          ,BLOCK_NO                                                      
MFA-TR*         FROM SESSION.CSR04686_R2                                        
MFA-TR*      END-EXEC.                                                          
      *                                                                         
       0100B-EXIT.                                                      
             EXIT.                                                      
      *                                                                         
      ******************************************************************        
      *0100C-DECLARE-GTT-R3                                            *        
      ******************************************************************        
       0100C-DECLARE-GTT-R3.                                            
           MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR04686_R3'            
                                             TO S-SQL-STATEMENT-V.      
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04686_R3')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04686_R3
              (                                                       
                  RETURN_CODE          INT                          
                 ,APPL_RETURN_CODE     INT                          
                 ,CHARGE_DESC CHAR(54)  COLLATE LATIN1_GENERAL_100_BIN2         
                 ,FACTOR_ID CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2           
                 ,CODE_ADJUST_TYPE CHAR(01)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                         
                 ,COMPONENT_ID CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2        
                 ,CODE_TOU             SMALLINT                         
                 ,CODE_SEASON CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
                 ,SEAS_PRORATE_PCT     DECIMAL(06,5)                    
                 ,NET_UNIT_SEL_RSN CHAR(01)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                         
                 ,BTU_FACTOR           DECIMAL(11,6)                    
                 ,WNA_FACTOR           DECIMAL(11,6)                    
                 ,CONSUMPTION_TYPE CHAR(1)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                         
                 ,REGISTER_TYPE CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2        
                 ,RATE_VERSION CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2         
                 ,UNITS_READ           DECIMAL(11,2)                    
                 ,NET_UNITS            DECIMAL(11,2)                    
                 ,BLOCK_NO CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2            
                 ,BLOCK_SIZE           INT                          
                 ,UNITS_BILLED         DECIMAL(11,2)                    
                 ,BASE_RATE            DECIMAL(11,6)                    
                 ,NET_RATE             DECIMAL(13,6)                    
                 ,PRICE_TYPE_CD CHAR(01)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                         
                 ,COMPUTED_CHARGE      DECIMAL(11,2)                    
                 ,INFO_ONLY_FLAG CHAR(01)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                         
                 ,COMPONENT_KEY CHAR(8)  COLLATE LATIN1_GENERAL_100_BIN2        
                    )
           END-EXEC.                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

             MOVE SQLSTATE                   TO WS-SQLSTATE.            
             MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.  
                                                                        
             IF WS-SQLSTATE = '42710'                                   
                PERFORM 8000C-DELETE-GTT-ROWS THRU 8000C-EXIT           
             ELSE                                                       
                IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL              
                   CONTINUE                                             
                ELSE                                                    
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE SQLCODE              TO ABEND-SQLCODE           
                   MOVE SQLSTATE             TO ABEND-SQLSTATE          
                   MOVE '0100C'              TO ACTIVE-PARAGRAPH        
                   MOVE 'DECLARE GTT'        TO ABEND-FUNCTION          
                   MOVE SPACES               TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                   MOVE 'CSR04686_R3'        TO TABLE-1                 
                   MOVE SPACES               TO TABLE-ELEMENT-1         
                   MOVE SPACES               TO HOSTVAR-ELEMENT-1       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
                END-IF                                                  
             END-IF.                                                    
                                                                        
           EXEC SQL                                                     
                DECLARE C3 CURSOR                            
                        WITH ROWSET POSITIONING FOR                     
                SELECT                                                  
                  RETURN_CODE                                           
                 ,APPL_RETURN_CODE                                      
                 ,CHARGE_DESC                                           
                 ,FACTOR_ID                                             
                 ,CODE_ADJUST_TYPE                                      
                 ,COMPONENT_ID                                          
                 ,CODE_TOU                                              
                 ,CODE_SEASON                                           
                 ,SEAS_PRORATE_PCT                                      
                 ,NET_UNIT_SEL_RSN                                      
                 ,BTU_FACTOR                                            
                 ,WNA_FACTOR                                            
                 ,CONSUMPTION_TYPE                                      
                 ,REGISTER_TYPE                                         
                 ,RATE_VERSION                                          
                 ,UNITS_READ                                            
                 ,NET_UNITS                                             
                 ,BLOCK_NO                                              
                 ,BLOCK_SIZE                                            
                 ,UNITS_BILLED                                          
                 ,BASE_RATE                                             
                 ,NET_RATE                                              
                 ,PRICE_TYPE_CD                                         
                 ,COMPUTED_CHARGE                                       
                 ,INFO_ONLY_FLAG                                        
                 ,COMPONENT_KEY                                         
              FROM #CSR04686_R3                                  
             END-EXEC.                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE C3 CURSOR WITH RETURN                                   
MFA-TR*                 WITH ROWSET POSITIONING FOR                             
MFA-TR*         SELECT                                                          
MFA-TR*           RETURN_CODE                                                   
MFA-TR*          ,APPL_RETURN_CODE                                              
MFA-TR*          ,CHARGE_DESC                                                   
MFA-TR*          ,FACTOR_ID                                                     
MFA-TR*          ,CODE_ADJUST_TYPE                                              
MFA-TR*          ,COMPONENT_ID                                                  
MFA-TR*          ,CODE_TOU                                                      
MFA-TR*          ,CODE_SEASON                                                   
MFA-TR*          ,SEAS_PRORATE_PCT                                              
MFA-TR*          ,NET_UNIT_SEL_RSN                                              
MFA-TR*          ,BTU_FACTOR                                                    
MFA-TR*          ,WNA_FACTOR                                                    
MFA-TR*          ,CONSUMPTION_TYPE                                              
MFA-TR*          ,REGISTER_TYPE                                                 
MFA-TR*          ,RATE_VERSION                                                  
MFA-TR*          ,UNITS_READ                                                    
MFA-TR*          ,NET_UNITS                                                     
MFA-TR*          ,BLOCK_NO                                                      
MFA-TR*          ,BLOCK_SIZE                                                    
MFA-TR*          ,UNITS_BILLED                                                  
MFA-TR*          ,BASE_RATE                                                     
MFA-TR*          ,NET_RATE                                                      
MFA-TR*          ,PRICE_TYPE_CD                                                 
MFA-TR*          ,COMPUTED_CHARGE                                               
MFA-TR*          ,INFO_ONLY_FLAG                                                
MFA-TR*          ,COMPONENT_KEY                                                 
MFA-TR*       FROM SESSION.CSR04686_R3                                          
MFA-TR*      END-EXEC.                                                          
      *                                                                         
       0100C-EXIT.                                                      
             EXIT.                                                      
      *                                                                         
      ******************************************************************        
      *0100D-DECLARE-GTT-R4                                            *        
      ******************************************************************        
       0100D-DECLARE-GTT-R4.                                            
           MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR04686_R4'            
                                             TO S-SQL-STATEMENT-V.      
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04686_R4')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04686_R4
              (                                                       
                  RETURN_CODE          INT                          
                 ,APPL_RETURN_CODE     INT                          
                 ,CHARGE_DESC CHAR(54)  COLLATE LATIN1_GENERAL_100_BIN2         
                 ,FACTOR_ID CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2           
                 ,CODE_ADJUST_TYPE CHAR(01)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                         
                 ,COMPONENT_ID CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2        
                 ,CODE_TOU             SMALLINT                         
                 ,CODE_SEASON CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
                 ,RATE_VERSION CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2        
                 ,UNITS_BILLED         DECIMAL(11,2)                    
                 ,NET_RATE             DECIMAL(13,6)                    
                 ,COMPUTED_CHARGE      DECIMAL(11,2)                    
                 ,CONSUMPTION_TYPE CHAR(1)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                         
                 ,COMPONENT_KEY CHAR(8)  COLLATE LATIN1_GENERAL_100_BIN2        
                    )
           END-EXEC.                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

             MOVE SQLSTATE                   TO WS-SQLSTATE.            
             MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.  
                                                                        
             IF WS-SQLSTATE = '42710'                                   
                PERFORM 8000D-DELETE-GTT-ROWS THRU 8000D-EXIT           
             ELSE                                                       
                IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL              
                   CONTINUE                                             
                ELSE                                                    
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE SQLCODE              TO ABEND-SQLCODE           
                   MOVE SQLSTATE             TO ABEND-SQLSTATE          
                   MOVE '0100D'              TO ACTIVE-PARAGRAPH        
                   MOVE 'DECLARE GTT'        TO ABEND-FUNCTION          
                   MOVE SPACES               TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                   MOVE 'CSR04686_R4'        TO TABLE-1                 
                   MOVE SPACES               TO TABLE-ELEMENT-1         
                   MOVE SPACES               TO HOSTVAR-ELEMENT-1       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
                END-IF                                                  
             END-IF.                                                    
                                                                        
           EXEC SQL                                                     
                DECLARE C4 CURSOR                            
                        WITH ROWSET POSITIONING FOR                     
                SELECT                                                  
                  RETURN_CODE                                           
                 ,APPL_RETURN_CODE                                      
                 ,CHARGE_DESC                                           
                 ,FACTOR_ID                                             
                 ,CODE_ADJUST_TYPE                                      
                 ,COMPONENT_ID                                          
                 ,CODE_TOU                                              
                 ,CODE_SEASON                                           
                 ,RATE_VERSION                                          
                 ,UNITS_BILLED                                          
                 ,NET_RATE                                              
                 ,COMPUTED_CHARGE                                       
                 ,CONSUMPTION_TYPE                                      
                 ,COMPONENT_KEY                                         
              FROM #CSR04686_R4                                  
             END-EXEC.                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE C4 CURSOR WITH RETURN                                   
MFA-TR*                 WITH ROWSET POSITIONING FOR                             
MFA-TR*         SELECT                                                          
MFA-TR*           RETURN_CODE                                                   
MFA-TR*          ,APPL_RETURN_CODE                                              
MFA-TR*          ,CHARGE_DESC                                                   
MFA-TR*          ,FACTOR_ID                                                     
MFA-TR*          ,CODE_ADJUST_TYPE                                              
MFA-TR*          ,COMPONENT_ID                                                  
MFA-TR*          ,CODE_TOU                                                      
MFA-TR*          ,CODE_SEASON                                                   
MFA-TR*          ,RATE_VERSION                                                  
MFA-TR*          ,UNITS_BILLED                                                  
MFA-TR*          ,NET_RATE                                                      
MFA-TR*          ,COMPUTED_CHARGE                                               
MFA-TR*          ,CONSUMPTION_TYPE                                              
MFA-TR*          ,COMPONENT_KEY                                                 
MFA-TR*       FROM SESSION.CSR04686_R4                                          
MFA-TR*      END-EXEC.                                                          
      *                                                                         
       0100D-EXIT.                                                      
             EXIT.                                                      
      *                                                                         
      ******************************************************************        
      *0100E-DECLARE-GTT-R5                                            *        
      ******************************************************************        
       0100E-DECLARE-GTT-R5.                                            
           MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR04686_R5'            
                                             TO S-SQL-STATEMENT-V.      
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04686_R5')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04686_R5
              (                                                       
                  RETURN_CODE          INT                          
                 ,APPL_RETURN_CODE     INT                          
                 ,BUS_RULE_ID CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2         
                 ,BUS_RULE_RESULT_CD CHAR(10)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                         
                 ,BUS_RULE_XREF_ID CHAR(26)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                         
                 ,MESSAGE_PARMS CHAR(55)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                         
                 ,LINK_PARMS CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2          
                 ,COMPONENT_KEY CHAR(08)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                         
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                   TO WS-SQLSTATE.              
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000E-DELETE-GTT-ROWS THRU 8000E-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE SQLCODE                TO ABEND-SQLCODE           
                 MOVE SQLSTATE               TO ABEND-SQLSTATE          
                 MOVE '0100E'                TO ACTIVE-PARAGRAPH        
                 MOVE 'DECLARE GTT'          TO ABEND-FUNCTION          
                 MOVE SPACES                 TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                 MOVE 'CSR04686_R5'          TO TABLE-1                 
                 MOVE SPACES                 TO TABLE-ELEMENT-1         
                 MOVE SPACES                 TO HOSTVAR-ELEMENT-1       
                 PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT            
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
                DECLARE C5 CURSOR                            
                        WITH ROWSET POSITIONING FOR                     
                SELECT                                                  
                  RETURN_CODE                                           
                 ,APPL_RETURN_CODE                                      
                 ,LTRIM(RTRIM(BUS_RULE_ID))          AS BUS_RULE_ID            
                 ,LTRIM(RTRIM(BUS_RULE_RESULT_CD))   AS 
           BUS_RULE_RESULT_CD     
                 ,LTRIM(RTRIM(BUS_RULE_XREF_ID))     AS BUS_RULE_XREF_ID       
                 ,LTRIM(RTRIM(MESSAGE_PARMS))        AS MESSAGE_PARMS          
                 ,LTRIM(RTRIM(LINK_PARMS))           AS LINK_PARMS             
                 ,LTRIM(RTRIM(COMPONENT_KEY))        AS COMPONENT_KEY          
                FROM #CSR04686_R5                                
             END-EXEC.                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE C5 CURSOR WITH RETURN                                   
MFA-TR*                 WITH ROWSET POSITIONING FOR                             
MFA-TR*         SELECT                                                          
MFA-TR*           RETURN_CODE                                                   
MFA-TR*          ,APPL_RETURN_CODE                                              
MFA-TR*          ,STRIP(BUS_RULE_ID)          AS BUS_RULE_ID                    
MFA-TR*          ,STRIP(BUS_RULE_RESULT_CD)   AS BUS_RULE_RESULT_CD             
MFA-TR*          ,STRIP(BUS_RULE_XREF_ID)     AS BUS_RULE_XREF_ID               
MFA-TR*          ,STRIP(MESSAGE_PARMS)        AS MESSAGE_PARMS                  
MFA-TR*          ,STRIP(LINK_PARMS)           AS LINK_PARMS                     
MFA-TR*          ,STRIP(COMPONENT_KEY)        AS COMPONENT_KEY                  
MFA-TR*         FROM SESSION.CSR04686_R5                                        
MFA-TR*      END-EXEC.                                                          
      *                                                                         
       0100E-EXIT.                                                      
             EXIT.                                                      
      *                                                                         
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *     1. RECEIVE PARMS.                                          *        
      *     2. DESCRIBE RESULT SET                                     *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-ACCOUNT-NO              TO CP-ACCOUNT-NO           
                                                BI-ACCOUNT-NO           
                                                BG-ACCOUNT-NO           
                                                AT-ACCOUNT-NO           
                                                NG-ACCOUNT-NO           
      *                                         WS-CPD4515-ACCT-NO              
                                                WS-CX-ACCOUNT-NO        
                                                WS-ACCOUNT-NO.          
           MOVE PARM-UTIL-TYPE               TO CP-CODE-UTIL-TYPE       
                                                BG-CODE-UTIL-TYPE       
                                                NG-CODE-UTIL-TYPE       
                                                WS-CODE-UTIL-TYPE.      
           MOVE PARM-IC-NO                   TO CP-IC-NO                
                                                BG-IC-NO                
                                                NG-IC-NO                
                                                WS-IC-NO.               
           MOVE PARM-BILL-NO                 TO BI-BILL-NO              
                                                BG-BILL-NO              
                                                NG-BILL-NO              
                                                WS-CX-BILL-NO           
                                                WS-BILL-NO.             
           MOVE PARM-BILL-ITEM-TIMESTAMP     TO BG-BILL-ITEM-TIMESTMP   
                                                NG-BILL-ITEM-TIMESTMP   
                                                WS-BILL-ITEM-TIMESTMP.  
                                                                        
           PERFORM 8240-CHECK-CUST-PLAN       THRU 8240-EXIT.           
           PERFORM 8250-GET-BILL-STATUS       THRU 8250-EXIT.           
           PERFORM 8260-SELECT-COMPANY-NO     THRU 8260-EXIT.           
                                                                        
      *    MOVE AT-BILL-CYCLE                TO WS-CPD4515-BILL-CYCLE.          
      *    MOVE AT-COMPANY-NO                TO WS-CPD4515-COMPANY-NO.          
           MOVE BI-CODE-BILL-STATUS          TO                         
                                             WS-BC-CODE-BILL-STATUS-BI. 
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *                                                                *        
      *     2. OBTAIN DB2 DATA                                         *        
      *     3. BUILD LINKAGE                                           *        
      *     4. CALL BILL CALC                                          *        
      *     5. SEND RESULT SET                                         *        
      *                                                                *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
                                                                        
      * BILLED ROW   - CALL MCSCB107 TO GET UTILITY CHARGE. TAX AMOUNT          
      *                WILL GET FROM BG TABLE                                   
      * UNBILLED ROW - ALL METERD SERVICE UNDER THAT BILL SHOULD HAVE           
      *                EITHER UNBILLED CONSUMPITON OR UNBILL REBILL ROW         
      *              - CALL CPD04515(CALLS MCSCB102/105/107) TO GET             
      *                UTILTIY CHARGE ALONG TAX AMOUNT                          
           PERFORM 5000-PROCESS-MCSCB107      THRU 5000-EXIT.           
                                                                        
           IF BI-DATE-BILLED = SPACES AND WS-CALC-ERROR = SPACES        
      *                                                                         
      **** PROCESS BG AREA                                                      
              SET WS-BILLING-INDX            TO 1                       
              PERFORM 5170-MOVE-CWS1000B-BG   THRU 5170-EXIT            
      *                                                                         
      **** PROCESS CP AREA                                                      
              SET WS-CUST-PLAN-INDX          TO 1                       
              PERFORM 5180-LOAD-CUST-PLAN     THRU 5180-EXIT            
      *                                                                         
      **** PROCESS PK AREA                                                      
      **** YET TO CODE THE PARA 5190-******                                     
      *       IF SEB-DATABASE                                                   
      *          SET WS-PK-INDX              TO 1                               
      *          PERFORM 5190-CHK-N-LOAD-PREPAY-HIST                            
      *                                       THRU 5190-EXIT                    
      *       END-IF                                                            
      *                                                                         
              PERFORM 6000-TAX-CALCULATION    THRU 6000-CPD122-EXIT     
           END-IF.                                                      
                                                                        
           PERFORM 5050-PROCESS-CMPNTS-N-FCTRS                          
                                              THRU 5050-EXIT.           
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000A-MOVE-RESULT.                                             *        
      ******************************************************************        
       2000A-MOVE-RESULT.                                               
            MOVE RS-RETURN-CODE              TO S-RETURN-CODE.          
            MOVE RS-APPL-RETURN-CODE         TO S-APPL-RETURN-CODE.     
            MOVE RS-FACTOR-ID                TO S-FACTOR-ID.            
            MOVE RS-READ-DATE                TO S-READ-DATE.            
            MOVE RS-FACTOR-DESC              TO S-FACTOR-DESC.          
            MOVE RS-FACTOR-TYPE              TO S-FACTOR-TYPE.          
            MOVE RS-ADJUST-ELEMENT           TO S-ADJUST-ELEMENT.       
            MOVE RS-CALC-TYPE-CD             TO S-CALC-TYPE-CD.         
            MOVE RS-CHARGE-DESC              TO S-CHARGE-DESC.          
            MOVE RS-CODE-ADJUST-TYPE         TO S-CODE-ADJUST-TYPE.     
            MOVE RS-INFO-ONLY-FLAG           TO S-INFO-ONLY-FLAG.       
            MOVE RS-COMPONENT-ID             TO S-COMPONENT-ID.         
            MOVE RS-CODE-TOU                 TO S-CODE-TOU.             
            MOVE RS-CODE-SN                  TO S-CODE-SEASON.          
            MOVE RS-SEAS-PRORATE-PCT         TO S-SEAS-PRORATE-PCT.     
            MOVE RS-NET-UNIT-SEL-RSN         TO S-NET-UNIT-SEL-RSN.     
            MOVE RS-UNITS-READ               TO S-UNITS-READ.           
            MOVE RS-NET-UNITS                TO S-NET-UNITS.            
            MOVE RS-BLOCK-NO                 TO S-BLOCK-NO.             
            MOVE RS2-BLOCK-NO(4:1)           TO S2-BLOCK-NO.            
            MOVE RS-BLOCK-SIZE               TO S-BLOCK-SIZE.           
            MOVE RS-UNITS-BILLED             TO S-UNITS-BILLED.         
            MOVE RS-BASE-RATE                TO S-BASE-RATE.            
            MOVE RS-NET-RATE                 TO S-NET-RATE.             
            MOVE RS-PRICE-TYPE-CD            TO S-PRICE-TYPE-CD.        
            MOVE RS-COMPUTED-CHARGE          TO S-COMPUTED-CHARGE.      
            MOVE RS-NO-OF-DAYS               TO S-NO-OF-DAYS.           
            MOVE RS-BTU-FACTOR               TO S-BTU-FACTOR.           
            MOVE RS-WNA-FACTOR               TO S-WNA-FACTOR.           
            MOVE RS-CONSUMPTION-TYPE         TO S-CONSUMPTION-TYPE.     
            MOVE RS-REGISTER-TYPE            TO S-REGISTER-TYPE.        
            MOVE RS-RATE-VERSION             TO S-RATE-VERSION.         
            MOVE RS-COMPONENT-KEY            TO S-COMPONENT-KEY.        
            MOVE RS-STATE-TAX                TO S-STATE-TAX.            
            MOVE RS-CITY-TAX                 TO S-CITY-TAX.             
            MOVE RS-OTHER-TAX                TO S-OTHER-TAX.            
            MOVE RS-TOTAL-USAGE-CHARGES      TO S-TOTAL-USAGE-CHRG.     
            MOVE RS-USAGE-CHARGES            TO S-USAGE-CHRG.           
            MOVE RS-TOTAL-DEMAND-CHARGES     TO S-TOTAL-DEMAND-CHRG.    
            MOVE RS-DEMAND-CHRGS-CREDITS     TO S-DEMAND-CHRGS-CRDT.    
            MOVE RS-USAGE-CHRGS-CREDITS      TO S-USAGE-CHRGS-CRDT.     
            MOVE RS-BASIC-FCLTY-CHRG         TO S-BASIC-FCLTY-CHRG.     
            MOVE RS-TOTAL-BILL-AMOUNT        TO S-TOTAL-BILL-AMOUNT.    
            MOVE RS-TOTAL-NET-UNITS          TO S-TOTAL-NET-UNITS.      
            MOVE RS-AGL-CHARGES              TO S-AGL-CHARGES.          
            MOVE RS-UNIT-PRICE-AMT           TO S-UNIT-PRICE-AMT.       
            MOVE RS-REV-MONTH                TO S-REV-MONTH.            
            MOVE RS-RATE-PLAN                TO S-RATE-PLAN.            
            MOVE RS-RATE-DESC                TO S-RATE-DESC.            
            MOVE RS-SVC-CAT                  TO S-SVC-CAT.              
            MOVE RS-STATE-TAX-RATE           TO S-STATE-TAX-RATE.       
            MOVE RS-CITY-TAX-RATE            TO S-CITY-TAX-RATE.        
            MOVE RS-PARTIAL-XMPT-FL          TO S-PARTIAL-XMPT-FL.      
            MOVE RS-PRORTD-BILL-FL           TO S-PRORTD-BILL-FL.       
            MOVE RS-PRORTD-BY-DAYS-FL        TO S-PRORTD-BY-DAYS-FL.    
            MOVE WS-RT-OVRD-BILL-CY          TO S-RT-OVRD-BILL-CY.      
            MOVE WS-RT-OVRD-BILL-DT          TO S-RT-OVRD-BILL-DT.      
            MOVE WS-RT-OVRD-REV-MTH          TO S-RT-OVRD-REV-MTH.      
            MOVE RS-SPCL-GRP-CD              TO S-SPCL-GRP-CD.          
                                                                        
       2000A-EXIT.                                                      
             EXIT.                                                      
                                                                        
      ******************************************************************        
      ** CASE1:IF DATA DOES NOT EXISTS IN BILL_MAN% TABLES & BILLED   **        
      ** SCENARIO THEN CALL MCSCB107 AND POPULATE THE RESULTS         **        
      ******************************************************************        
       5000-PROCESS-MCSCB107.                                           
                                                                        
      * LOAD ALL TABLE DETAILS SIMILAR TO MCSCB102                              
           PERFORM 5100-BUILD-PASS-AREA       THRU 5100-EXIT.           
           IF WS-BC-REV-MTH-ORIG-BILL-BG > 0 AND                        
              WS-BC-REVENUE-MONTH-BG = 0                                
              MOVE WS-BC-REV-MTH-ORIG-BILL-BG                           
                                             TO WS-BC-REVENUE-MONTH-BG  
           ELSE                                                         
              IF WS-BC-REVENUE-MONTH-BG  = 0                            
                 PERFORM 8640-GET-BILLWINDOW-REV-MTH                    
                                              THRU 8640-EXIT            
                 IF WS-ACTIVE-RETURN-CODE EQUAL                         
                                             TO SUCCESSFUL-CALL         
                    MOVE BN-REVENUE-MONTH    TO WS-BC-REVENUE-MONTH-BG  
                 ELSE                                                   
                    MOVE ZEROS               TO BN-REVENUE-MONTH        
                    PERFORM 8645-GET-MIN-REVMTH                         
                                              THRU 8645-EXIT            
                    IF BN-REVENUE-MONTH = 0 OR                          
                       BN-REVENUE-MONTH = AT-REV-MTH-LST-NRML           
                       PERFORM 8650-SELECT-REVENUE-MONTH                
                          THRU 8650-EXIT                                
                       MOVE WS-CURR-REVENUE-MONTH                       
                                             TO WS-BC-REVENUE-MONTH-BG  
                    ELSE                                                
                       MOVE BN-REVENUE-MONTH                            
                                             TO WS-BC-REVENUE-MONTH-BG  
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
           MOVE 'S'                          TO WS-BC-CALC-MODE.        
           MOVE 'DATABASE'                   TO C8-DELINQ-CD.           
           PERFORM 8600-SELECT-DELINQUENCY    THRU 8600-EXIT.           
           MOVE C8-DELINQ-VALUE              TO LS-DATABASE.            
           INITIALIZE WS-CNSMPTN-HOURLY.                                
                                                                        
      * CALL MCSCB107 TO GET UTILITY CHARGES                                    
           PERFORM 6000-CALL-BILL-CALC        THRU 6000-EXIT.           
                                                                        
           IF WS-CALC-ERROR NOT = SPACES                                
              MOVE 0                         TO S5-RETURN-CODE          
              MOVE 0                         TO S5-APPL-RETURN-CODE     
              MOVE 'BA00000044'              TO S5-BUS-RULE-ID          
              MOVE WS-FAILED                 TO S5-BUS-RULE-RESULT-CD   
              IF S5-BUS-RULE-ID GREATER THAN SPACES                     
                 PERFORM 7900-GET-RULE-XREF-ID                          
                                              THRU 7900-EXIT            
                 MOVE WS-CALC-ERROR          TO S5-MESSAGE-PARMS        
                 MOVE SPACES                 TO S5-LINK-PARMS           
                                                S5-COMPONENT-KEY        
              END-IF                                                    
              PERFORM 8100E-INSERT-GTT-R5     THRU 8100E-EXIT           
              PERFORM 9999-END-PROGRAM        THRU 9999-EXIT            
           ELSE                                                         
      * CHECK IF BILL CALCULATIONS ARE PRESENT IN MANUAL BILL TABLE.            
              MOVE 'N'                       TO WS-MANUAL-BILL-SW       
              PERFORM 7880-CHK-MANUAL-BILL    THRU 7880-EXIT            
                                                                        
              IF WS-MANUAL-BILL-SW = 'Y'                                
                 COMPUTE WS-BC-AMT-BILL-ITEM-BG = WS-BC-AMT-BILL-ITEM-BG
                                              - (WS-BC-AMT-STATE-TAX-BG 
                                              +  WS-BC-AMT-OTHER-TAX-BG 
                                              +  WS-BC-AMT-CITY-TAX-BG) 
                 END-COMPUTE                                            
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5050-PROCESS-CMPNTS-N-FCTRS                                    *        
      *                                                                *        
      *  1. DETERMINE TYPE OF OPERATION                                *        
      *  2. OBTAIN ADDITIONAL DATA IF NECESSARY                        *        
      *  3. CALL BILL CALCULATION ROUTINE                              *        
      ******************************************************************        
       5050-PROCESS-CMPNTS-N-FCTRS.                                     
                                                                        
           IF WS-CALC-ERROR = SPACES                                    
              IF WS-BC-CODE-UTIL-TYPE-BG NOT = 'U'                      
                 PERFORM VARYING BC-INDX FROM 1 BY 1                    
                   UNTIL BC-INDX > WS-BC-MAX-ENTRY                      
                   COMPUTE WS-TOTAL-NET-UNITS = WS-TOTAL-NET-UNITS      
                                      + WS-BC-NET-UNITS(BC-INDX)        
                 END-PERFORM                                            
                                                                        
              END-IF                                                    
              PERFORM VARYING WS-BC-ADJUSTMNT-INDEX FROM 1 BY 1         
                UNTIL WS-BC-ADJUSTMNT-INDEX > WS-BC-BP-MAX-ENTRY        
                   OR WS-BC-ACCOUNT-NO-BP(WS-BC-ADJUSTMNT-INDEX) = 0    
                   IF WS-BC-ACCOUNT-NO-BP(WS-BC-ADJUSTMNT-INDEX)        
                    = WS-BC-ACCOUNT-NO-BG         AND                   
                      WS-BC-BILL-NO-BP(WS-BC-ADJUSTMNT-INDEX)           
                    = WS-BC-BILL-NO-BG            AND                   
                      WS-BC-CODE-UTIL-TYPE-BP(WS-BC-ADJUSTMNT-INDEX)    
                    = WS-BC-CODE-UTIL-TYPE-BG     AND                   
                      WS-BC-IC-NO-BP(WS-BC-ADJUSTMNT-INDEX)             
                    = WS-BC-IC-NO-BG              AND                   
                      WS-BC-BILL-ITEM-TIMESTMP-BP(WS-BC-ADJUSTMNT-INDEX)
                    = WS-BC-BILL-ITEM-TIMESTMP-BG AND                   
                      WS-BC-ADJ-TYPE-CD-BP(WS-BC-ADJUSTMNT-INDEX)       
                    = WS-RT-PARM-OVRD                                   
                      MOVE WS-BC-OVRRIDE-RT-BILL-CY-BP                  
                     (WS-BC-ADJUSTMNT-INDEX) TO WS-RT-OVRD-BILL-CY      
                      MOVE WS-BC-OVRRIDE-RT-BILL-DT-BP                  
                     (WS-BC-ADJUSTMNT-INDEX) TO WS-RT-OVRD-BILL-DT      
                      MOVE WS-BC-OVRRIDE-RT-REV-MTH-BP                  
                     (WS-BC-ADJUSTMNT-INDEX) TO WS-RT-OVRD-REV-MTH      
                   END-IF                                               
              END-PERFORM                                               
              IF WS-BC-PRORATE-CD-BG NOT = SPACE                        
                 MOVE WS-MIN-PRORATE-CD      TO C8-DELINQ-CD            
                 PERFORM 8600-SELECT-DELINQUENCY THROUGH 8600-EXIT      
                 MOVE C8-DELINQ-VALUE        TO WS-MIN-PRORATE-DAYS     
                 MOVE WS-MAX-PRORATE-CD      TO C8-DELINQ-CD            
                 PERFORM 8600-SELECT-DELINQUENCY THROUGH 8600-EXIT      
                 MOVE C8-DELINQ-VALUE        TO WS-MAX-PRORATE-DAYS     
              END-IF                                                    
              IF WS-BC-PRORATE-CD-BG NOT = SPACE                        
                 AND (WS-BC-NO-CNSMPTN-DAYS < WS-MIN-PRORATE-DAYS       
                      OR > WS-MAX-PRORATE-DAYS)                         
                 AND AT-COMPANY-NO NOT = '26'                           
                 IF SEB-DATABASE                                        
                    SET NOT-PCT-BILL         TO TRUE                    
                    PERFORM 8665-CHECK-STEP-RATE THRU 8665-EXIT         
                    IF J1-LAST-ENERGY-BLOCK > 1                         
                       SET PCT-BILL          TO TRUE                    
                    END-IF                                              
                 END-IF                                                 
                                                                        
                 IF SEB-DATABASE AND PCT-BILL                           
                    PERFORM 7000-BUILD-RESULT THRU 7000-EXIT            
                 ELSE                                                   
                    INITIALIZE WS-PRO-BC-TABLE                          
                               WS-HOLD-BASIC-FACILITY                   
                    PERFORM 6100-SUM-BFC      THRU 6100-EXIT            
                    PERFORM 6200-PRORATE      THRU 6200-EXIT            
      *  ONLY DISPLAY PRORATION INFORMATION FOR GEORGIA CUSTOMERS               
      *  SCE&G CUSTOMERS HAVE STEP RATES AND SHOULD NOT BE DISPLAYED            
      *  THIS WILL HAVE TO BE REMOVED IF SCANA ENERGY EVER STEPS RATES          
                    PERFORM VARYING BC-INDX FROM 1 BY 1                 
SCA006                UNTIL NOT SEB-DATABASE OR 
                            BC-INDX > WS-BC-MAX-ENTRY OR 
                            WS-BC-COMPONENT-ID (BC-INDX) = SPACE                
      ** DISPLAY BTU FACTOR FOR PRORATED BILLS                                  
                       INITIALIZE TDS-RETURN-FIELDS                     
                       PERFORM VARYING BA-INDX FROM 1 BY 1              
                          UNTIL BA-INDX > 200                           
                             OR WS-BC-FACTOR-ID (BA-INDX) NOT > SPACE   
                          IF WS-BC-FACTOR-COMPONENT (BA-INDX) =         
                                WS-BC-COMPONENT-KEY (BC-INDX)           
                             EVALUATE TRUE                              
                                WHEN (ADD-TO-NET-UNITS (BA-INDX)        
                                  AND WS-BC-SPECIAL-CALC-CD (BA-INDX)   
                                     NOT = 'XX')                        
                                WHEN SUB-FROM-NET-UNITS (BA-INDX)       
                                  PERFORM 7300-UNITS-INCLUDE            
                                              THRU 7300-EXIT            
                                WHEN REPL-NET-UNITS (BA-INDX)           
                                  PERFORM 7400-UNITS-USE                
                                              THRU 7400-EXIT            
                                WHEN OTHER                              
                                  CONTINUE                              
                             END-EVALUATE                               
                          END-IF                                        
                       END-PERFORM                                      
      ** DISPLAY FACTORS FOR PRORATED BILL                                      
                       PERFORM VARYING BA-INDX FROM 1 BY 1              
                         UNTIL BA-INDX > 200                            
                            OR WS-BC-FACTOR-ID (BA-INDX) NOT > SPACE    
                          IF WS-BC-FACTOR-COMPONENT (BA-INDX) =         
                                WS-BC-COMPONENT-KEY (BC-INDX)           
                           AND WS-BC-FACTOR-ID (BA-INDX) (1:8)          
                                NOT = 'BFACCHRG'                        
                           AND WS-BC-FACTOR-ID (BA-INDX) (1:1) NOT = '@'
                             EVALUATE TRUE                              
                                WHEN ADD-TO-COMPONENT-AMT (BA-INDX)     
                                WHEN SUB-FROM-COMPONENT-AMT (BA-INDX)   
                                   PERFORM 7500-AMT-INCLUDES            
                                              THRU 7500-EXIT            
                                WHEN REPL-COMPONENT-AMT (BA-INDX)       
                                   PERFORM 7600-AMT-USES                
                                              THRU 7600-EXIT            
                                WHEN CALC-ONLY (BA-INDX)                
                                  OR TAX-ONLY (BA-INDX)                 
                                   PERFORM 7700-AMT-FYI                 
                                              THRU 7700-EXIT            
                                WHEN OTHER                              
                                   CONTINUE                             
                             END-EVALUATE                               
                          END-IF                                        
                       END-PERFORM                                      
                    END-PERFORM                                         
                    IF SEB-DATABASE OR (WS-BC-CIG-CUSTOMER-IND-BG = 'Y')
                       MOVE 'Y'              TO WS-PRORTD-BILL-FL       
                                                WS-PRORTD-BY-DAYS-FL    
                    END-IF                                              
                    IF WS-BC-RATE-PLAN-NO-BG = '023' OR '024'           
                       PERFORM 6500-INTERRUPTIBLE                       
                                              THRU 6500-EXIT            
                    ELSE                                                
                       IF WS-BC-CIG-CUSTOMER-IND-BG = 'Y'               
                          CONTINUE                                      
                       ELSE                                             
                          PERFORM 6400-SPANNMIN                         
                                              THRU 6400-EXIT            
                       END-IF                                           
                    END-IF                                              
                    INITIALIZE TDS-RETURN-FIELDS                        
                    MOVE WS-BC-NO-CNSMPTN-DAYS                          
                                             TO RS-NO-OF-DAYS           
                    IF (WS-BC-REVENUE-MONTH-BG > 0)  OR                 
                       (WS-BC-REV-MTH-ORIG-BILL-BG > 0 )                
                       IF WS-BC-REVENUE-MONTH-BG > 0                    
                          MOVE WS-BC-REVENUE-MONTH-BG                   
                                             TO RS-REV-MONTH            
                       ELSE                                             
                          MOVE WS-BC-REV-MTH-ORIG-BILL-BG               
                                             TO RS-REV-MONTH            
                       END-IF                                           
                    ELSE                                                
                       MOVE SPACES           TO RS-REV-MONTH            
                    END-IF                                              
                    IF WS-BC-RATE-PLAN-NO-BG NOT EQUAL                  
                                             TO SPACES                  
                       MOVE WS-BC-CODE-UTIL-TYPE-BG                     
                                             TO RD-CODE-UTIL-TYPE       
                       MOVE WS-BC-RATE-PLAN-NO-BG                       
                                             TO RD-RATE-PLAN-NO         
                                                RS-RATE-PLAN            
                       PERFORM 8662-GET-RATE-PLAN-DESC                  
                                              THRU 8662-EXIT            
                       MOVE RD-RATE-DESC     TO RS-RATE-DESC            
                       IF SEB-DATABASE                                  
                          IF WS-PRICE-PER-THERM = 0                     
                             PERFORM 8668-PRICE-PER-THERM               
                                              THRU 8668-EXIT            
                          ELSE                                          
                             MOVE WS-PRICE-PER-THERM                    
                                             TO WS-UNIT-PRICE-AMT       
                          END-IF                                        
                                                                        
                          IF WS-BC-RT-PKG-OPT-SEQ-NO-BG > 0             
                             MOVE WS-BC-ACCOUNT-NO-BG                   
                                             TO DF-ACCOUNT-NO           
                             MOVE WS-BC-CODE-UTIL-TYPE-BG               
                                             TO DF-CODE-UTIL-TYPE       
                             MOVE WS-BC-IC-NO-BG                        
                                             TO DF-IC-NO                
                             MOVE WS-BC-RT-PKG-OPT-SEQ-NO-BG            
                                             TO DF-RT-PKG-OPT-SEQ-NO    
                             PERFORM 7540-GET-OPTION-DESC               
                                THRU 7540-EXIT                          
                             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL 
                                MOVE FI-OPT-DESC-INT                    
                                             TO RS-RATE-DESC            
                             END-IF                                     
                          END-IF                                        
                       END-IF                                           
                    END-IF                                              
                    IF WS-BC-CODE-CURTAIL-PRTY-BG IS NUMERIC            
                       MOVE WS-BC-CODE-CURTAIL-PRTY-BG                  
                                             TO Z4-CODE-CURTAIL-PRTY    
                       MOVE AT-COMPANY-NO    TO Z4-COMPANY-NO           
                       PERFORM 8663-GET-SVC-CAT-DESC                    
                                               THRU 8663-EXIT           
                       MOVE Z4-PRTY-SVC-CAT-CD                          
                                             TO RS-SVC-CAT              
                    END-IF                                              
                    MOVE WS-BC-WNA-FACTOR-BG TO RS-WNA-FACTOR           
                    MOVE WS-BC-BTU-FACTOR-BG TO RS-BTU-FACTOR           
                    IF BG-CODE-STAT-TAX-XMT > SPACES                    
                       MOVE SPACES           TO F1-PARTIAL-EXEMPT-CD    
                       MOVE BG-CODE-STAT-TAX-XMT                        
                                             TO F1-TAX-EXEMPT-CODE      
                       PERFORM 7870-SEL-TAX-XMPT-CD THRU 7870-EXIT      
                       IF F1-PARTIAL-EXEMPT-CD > SPACES                 
                          MOVE 'Y'           TO RS-PARTIAL-XMPT-FL      
                       END-IF                                           
                    END-IF                                              
PRJ821              MOVE WS-BC-AMT-STATE-TAX-BG                         
PRJ821                                       TO RS-STATE-TAX            
PRJ821              MOVE WS-BC-AMT-CITY-TAX-BG                          
PRJ821                                       TO RS-CITY-TAX             
PRJ821              MOVE WS-BC-AMT-OTHER-TAX-BG                         
PRJ821                                       TO RS-OTHER-TAX            
PRJ821              MOVE BG-STATE-TAX-RATE TO RS-STATE-TAX-RATE         
PRJ821              MOVE BG-CITY-TAX-RATE TO RS-CITY-TAX-RATE           
                    IF MONTHLY-MINIMUM-CHARGED                          
                       MOVE ZERO             TO WS-USAGE-CHRGS-CREDITS  
                    ELSE                                                
                       IF ANNUAL-MINIMUM-APPLIED                        
                          MOVE ZERO          TO WS-USAGE-CHRGS-CREDITS  
                          COMPUTE WS-BC-AMT-BILL-ITEM-BG =              
                               BG-AMT-BILL-ITEM - WS-BC-AMT-STATE-TAX-BG
                                                - WS-BC-AMT-CITY-TAX-BG 
                                                - WS-BC-AMT-OTHER-TAX-BG
                       ELSE                                             
                          COMPUTE WS-BC-AMT-BILL-ITEM-BG =              
                                  WS-BC-AMT-BILL-ITEM-BG                
                                - WS-TOTAL-DEMAND-CHARGES               
                                - WS-DEMAND-CHRGS-CREDITS               
                                - WS-USAGE-CHRGS-CREDITS                
                       END-IF                                           
                    END-IF                                              
                    IF BG-CODE-DR-CR-CNSMPTN = 'C'                      
                       COMPUTE WS-BC-AMT-BILL-ITEM-BG   =               
                               WS-BC-AMT-BILL-ITEM-BG   * -1            
                       COMPUTE WS-TOTAL-DEMAND-CHARGES  =               
                               WS-TOTAL-DEMAND-CHARGES  * -1            
                       COMPUTE WS-DEMAND-CHRGS-CREDITS  =               
                               WS-DEMAND-CHRGS-CREDITS  * -1            
                       COMPUTE WS-USAGE-CHRGS-CREDITS   =               
                               WS-USAGE-CHRGS-CREDITS   * -1            
                       COMPUTE WS-BC-AMT-STATE-TAX-BG   =               
                               WS-BC-AMT-STATE-TAX-BG   * -1            
                       COMPUTE WS-BC-AMT-CITY-TAX-BG    =               
                               WS-BC-AMT-CITY-TAX-BG    * -1            
                    END-IF                                              
                    MOVE WS-BC-AMT-BILL-ITEM-BG                         
                                             TO RS-TOTAL-USAGE-CHARGES  
                    IF SEB-DATABASE                                     
                       COMPUTE RS-USAGE-CHARGES =                       
                               WS-BC-AMT-BILL-ITEM-BG - WS-OTHR-CHARGES 
                    ELSE                                                
                       MOVE WS-BC-AMT-BILL-ITEM-BG                      
                                             TO RS-USAGE-CHARGES        
                    END-IF                                              
                                                                        
                    MOVE WS-TOTAL-DEMAND-CHARGES                        
                                             TO RS-TOTAL-DEMAND-CHARGES 
                    MOVE WS-DEMAND-CHRGS-CREDITS                        
                                             TO RS-DEMAND-CHRGS-CREDITS 
                    MOVE WS-USAGE-CHRGS-CREDITS                         
                                             TO RS-USAGE-CHRGS-CREDITS  
                    MOVE WS-BASIC-FCLTY-CHRG TO RS-BASIC-FCLTY-CHRG     
                    MOVE WS-TOTAL-NET-UNITS  TO RS-TOTAL-NET-UNITS      
                    MOVE WS-UNIT-PRICE-AMT   TO RS-UNIT-PRICE-AMT       
                    MOVE WS-AGL-CHARGES      TO RS-AGL-CHARGES          
                    MOVE 'X'                 TO RS-CONSUMPTION-TYPE     
                    MOVE WS-BC-DATE-READ-CX(1) TO RS-READ-DATE          
                    MOVE WS-PRORTD-BILL-FL     TO RS-PRORTD-BILL-FL     
                    MOVE WS-PRORTD-BY-DAYS-FL  TO RS-PRORTD-BY-DAYS-FL  
                    COMPUTE RS-TOTAL-BILL-AMOUNT =                      
                                                WS-BC-AMT-BILL-ITEM-BG  
                                              + WS-TOTAL-DEMAND-CHARGES 
                                              + WS-DEMAND-CHRGS-CREDITS 
                                              + WS-USAGE-CHRGS-CREDITS  
                                              + WS-BC-AMT-STATE-TAX-BG  
                                              + WS-BC-AMT-CITY-TAX-BG   
                    PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT           
                    PERFORM 8100A-INSERT-GTT-R1                         
                                              THRU 8100A-EXIT           
                 END-IF                                                 
              ELSE                                                      
                 PERFORM 7000-BUILD-RESULT    THRU 7000-EXIT            
           END-IF
           END-IF.                                                      
                                                                        
       5050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5100-BUILD-PASS-AREA.                                          *        
      *                                                                *        
      *  READ DATA BASE TABLES AND LOAD THE PASSAREA WITH DATA         *        
      *                                                                *        
      ******************************************************************        
       5100-BUILD-PASS-AREA.                                            
                                                                        
           INITIALIZE WS-BC-BILL-ADJUSTMNT.                             
           SET WS-BC-ADJUSTMNT-INDEX         TO 1.                      
           MOVE WS-ACCOUNT-NO                TO BP-ACCOUNT-NO.          
           MOVE WS-BILL-NO                   TO BP-BILL-NO.             
           MOVE WS-CODE-UTIL-TYPE            TO BP-CODE-UTIL-TYPE.      
           MOVE WS-IC-NO                     TO BP-IC-NO.               
           MOVE WS-BILL-ITEM-TIMESTMP        TO BP-BILL-ITEM-TIMESTMP.  
           PERFORM 8040-OPEN-BILL-ADJUSTMENT  THRU 8040-EXIT.           
           PERFORM 8050-FETCH-BILL-ADJUSTMENT THRU 8050-EXIT.           
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              PERFORM 8060-CLOSE-BILL-ADJUSTMENT                        
                                              THRU 8060-EXIT            
           ELSE                                                         
              PERFORM 5160-LOAD-BILL-ADJUSTMENT                         
                                              THRU 5160-EXIT            
                 UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND            
              PERFORM 8060-CLOSE-BILL-ADJUSTMENT                        
                                              THRU 8060-EXIT            
           END-IF.                                                      
                                                                        
           PERFORM 5105-BUILD-PASS-AREA       THRU 5105-EXIT.           
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 5105-BUILD-PASS-AREA.                                         *         
      * MOVE BILLING DETAIL FIELDS TO PASSAREA                        *         
      *****************************************************************         
       5105-BUILD-PASS-AREA.                                            
                                                                        
           MOVE SPACE                        TO                         
                                             WS-BC-PRORATE-OVERRIDE-IND.
           PERFORM 8030-OPEN-BILLING-DET      THRU 8030-EXIT.           
           PERFORM 8100-FETCH-BILLING-DET     THRU 8100-EXIT.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              PERFORM 5110-LOAD-BILLING-DETAILS                         
                                              THRU 5110-EXIT            
              PERFORM 8230-CLOSE-BILLING-DET  THRU 8230-EXIT            
           ELSE                                                         
              PERFORM 8230-CLOSE-BILLING-DET  THRU 8230-EXIT            
           END-IF.                                                      
                                                                        
           IF WS-BC-DATE-ORIG-BILL-BG > SPACES                          
              MOVE WS-BC-DATE-ORIG-BILL-BG   TO WS-BC-CALC-DATE         
           ELSE                                                         
              IF BI-DATE-BILLED > SPACES                                
                 MOVE BI-DATE-BILLED         TO WS-BC-CALC-DATE         
                 IF AT-CODE-ACCT-STAT = 'B' AND                         
                    AT-ACCT-FINALED-DT > LOW-VALUES                     
                    MOVE BI-DATE-BILLED      TO WS-BC-DATE-ORIG-BILL-BG 
                 END-IF                                                 
              ELSE                                                      
                 MOVE WS-COMMON-DATE         TO WS-BC-CALC-DATE         
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF NOT HAS-CUST-PLAN                                         
              SET WS-MTRD-INDX               TO 1                       
              PERFORM 8500-OPEN-MTRD-ENVRNMT  THRU  8500-EXIT           
              PERFORM 8510-FETCH-MTRD-ENVRNMT THRU  8510-EXIT           
              PERFORM 5150-LOAD-MTR-ENVRNMT   THRU 5150-EXIT            
                 UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND            
              PERFORM 8520-CLOSE-MTRD-ENVRNMT THRU  8520-EXIT
           END-IF.          
      *                                                                         
           IF NOT HAS-CUST-PLAN                                         
              SET CX-INDX                    TO 1                       
              PERFORM 8000-OPEN-CNSMPTN-HIST  THRU  8000-EXIT           
              PERFORM 8070-FETCH-CNSMPTN-HIST THRU  8070-EXIT           
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                 PERFORM 5120-LOAD-MTRD-CNSMPTN                         
                                              THRU  5120-EXIT           
                   UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
                 PERFORM 8200-CLOSE-CNSMPTN-HIST                        
                                              THRU 8200-EXIT            
              ELSE                                                      
                 PERFORM 8200-CLOSE-CNSMPTN-HIST                        
                                              THRU 8200-EXIT            
              END-IF                                                    
           ELSE                                                         
              SET UC-INDX                    TO 1                       
              PERFORM 8020-OPEN-UNMTRD-CNSMPTN                          
                                              THRU 8020-EXIT            
              PERFORM 8090-FETCH-UNMTRD-CNSMPTN                         
                                              THRU 8090-EXIT            
                                                                        
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                 PERFORM 5130-LOAD-UNMTRD-CNSMPTN                       
                                              THRU 5130-EXIT            
                    UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND         
                 PERFORM 8220-CLOSE-UNMTRD-CNSMPTN                      
                                              THRU 8220-EXIT            
              ELSE                                                      
                 PERFORM 8220-CLOSE-UNMTRD-CNSMPTN                      
                                              THRU 8220-EXIT            
              END-IF                                                    
           END-IF.                                                      
                                                                        
      ***************************************************************           
      * THE FOLLOWING LOGIC IS COMMENTED OUT PER TIM FULLER UNTIL   *           
      * BILL CALC IS READY FOR IT.                                  *           
      ***************************************************************           
                                                                        
           SET FH-INDX                       TO 1.                      
           PERFORM 8010-OPEN-FIXED-FCT-HIST   THRU 8010-EXIT.           
           PERFORM 8080-FETCH-FIXED-FCT-HIST  THRU 8080-EXIT.           
           IF WS-ACTIVE-RETURN-CODE EQUAL  SUCCESSFUL-CALL              
              PERFORM 5140-LOAD-FIXED-FCT-HIST                          
                                              THRU 5140-EXIT            
                 UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND            
              PERFORM 8210-CLOSE-FIXED-FCT-HIST                         
                                              THRU 8210-EXIT            
           ELSE                                                         
              PERFORM 8210-CLOSE-FIXED-FCT-HIST                         
                                              THRU 8210-EXIT
           END-IF.           
                                                                        
       5105-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 5110-LOAD-BILLING-DETAILS.                                    *         
      *                                                               *         
      * MOVE BILLING DETAIL FIELDS TO PASSAREA                        *         
      *                                                               *         
      *****************************************************************         
       5110-LOAD-BILLING-DETAILS.                                       
                                                                        
           MOVE BG-ACCOUNT-NO                TO WS-BC-ACCOUNT-NO-BG     
                                                WS-ACCOUNT-NO-AT.       
           MOVE BG-BILL-NO                   TO WS-BC-BILL-NO-BG.       
           MOVE BG-CODE-UTIL-TYPE            TO WS-BC-CODE-UTIL-TYPE-BG.
           MOVE BG-IC-NO                     TO WS-BC-IC-NO-BG.         
           MOVE BG-BILL-ITEM-TIMESTMP        TO                         
                                            WS-BC-BILL-ITEM-TIMESTMP-BG.
           MOVE BG-PREMISE-NO                TO WS-BC-PREMISE-NO-BG.    
           MOVE BG-DATE-ORIG-BILL            TO WS-BC-DATE-ORIG-BILL-BG.
           MOVE BG-AMT-BILL-ITEM             TO WS-BC-AMT-BILL-ITEM-BG. 
           MOVE BG-CODE-BILL-CALC            TO WS-BC-CODE-BILL-CALC-BG.
           MOVE BG-CODE-BILL-ITM-TYPE        TO                         
                                            WS-BC-CODE-BILL-ITM-TYPE-BG.
           MOVE BG-CODE-BILL-ITM-IND         TO                         
                                            WS-BC-CODE-BILL-ITM-IND-BG. 
           MOVE BG-CODE-DR-CR-CNSMPTN        TO                         
                                            WS-BC-CODE-DR-CR-CNSMPTN-BG.
           MOVE BG-AMT-STATE-TAX             TO WS-BC-AMT-STATE-TAX-BG. 
           MOVE BG-AMT-CITY-TAX              TO WS-BC-AMT-CITY-TAX-BG.  
           MOVE BG-AMT-OTHER-TAX             TO WS-BC-AMT-OTHER-TAX-BG. 
           MOVE BG-CODE-REVENUE-CLASS        TO                         
                                            WS-BC-CODE-REVENUE-CLASS-BG.
           MOVE BG-CODE-SIC-NO               TO WS-BC-CODE-SIC-NO-BG.   
           MOVE BG-RATE-PLAN-NO              TO WS-BC-RATE-PLAN-NO-BG.  
                                                                        
      *** IF ACCOUNT BILLED ON NEGOTIATED RATE PLAN, REPLACE WITH BASE          
      *** RATE PLAN TO DISPLAY ALL BILLED RATES INFORMATION.                    
           IF BG-RATE-PLAN-NO = '160'                                   
              PERFORM  5115-GET-BASE-RATE     THRU 5115-EXIT            
              MOVE UT-RATE-PLAN-NO           TO WS-BC-RATE-PLAN-NO-BG   
           END-IF.                                                      
           MOVE BG-CODE-CURTAIL-PRTY         TO                         
                                            WS-BC-CODE-CURTAIL-PRTY-BG. 
           MOVE BG-CODE-STAT-TAX-XMT         TO                         
                                            WS-BC-CODE-STAT-TAX-XMT-BG. 
           MOVE BG-CODE-CITY-TAX-XMT         TO                         
                                            WS-BC-CODE-CITY-TAX-XMT-BG. 
           MOVE BG-CODE-OTHR-TAX-XMT         TO                         
                                            WS-BC-CODE-OTHR-TAX-XMT-BG. 
           MOVE BG-REV-RPT-CD                TO WS-BC-REV-RPT-CD-BG.    
           MOVE BG-STANDBY-COMPLIED          TO                         
                                            WS-BC-STANDBY-COMPLIED-BG.  
           MOVE BG-PRORATE-CD                TO WS-BC-PRORATE-CD-BG.    
           MOVE BG-NEW-RATE-PCT              TO WS-BC-NEW-RATE-PCT-BG.  
           MOVE BG-CODE-SUB-TOTAL            TO WS-BC-CODE-SUB-TOTAL-BG.
           MOVE BG-TAX-REFUND-CD             TO WS-BC-TAX-REFUND-CD-BG. 
           MOVE BG-COMPANY-NO                TO WS-BC-COMPANY-NO-BG.    
           MOVE BG-DATE-LFTM-HI-DMD          TO                         
                                             WS-BC-DATE-LFTM-HI-DMD-BG. 
           MOVE BG-LFTM-HI-PEAK-DMD          TO                         
                                             WS-BC-LFTM-HI-PEAK-DMD-BG. 
           MOVE BG-REBILL-IND                TO WS-BC-REBILL-IND-BG.    
           MOVE BG-REVENUE-MONTH             TO WS-BC-REVENUE-MONTH-BG. 
           MOVE BG-GAS-BASE-USE              TO WS-BC-GAS-BASE-USE-BG.  
           MOVE BG-ADJ-REASON-CD             TO WS-BC-ADJ-REASON-CD-BG. 
           MOVE BG-WNA-FACTOR                TO WS-BC-WNA-FACTOR-BG.    
           MOVE BG-BTU-FACTOR                TO WS-BC-BTU-FACTOR-BG.    
           MOVE BG-REV-MTH-ORIG-BILL         TO                         
                                             WS-BC-REV-MTH-ORIG-BILL-BG.
           MOVE BG-BILL-CALC-CYCLE           TO                         
                                             WS-BC-BILL-CALC-CYCLE-BG.  
           MOVE BG-ACCOUNT-NO                TO UT-ACCOUNT-NO.          
           MOVE BG-CODE-UTIL-TYPE            TO UT-CODE-UTIL-TYPE.      
           MOVE BG-IC-NO                     TO UT-IC-NO.               
           PERFORM 8664-SELECT-READ-FREQ      THRU 8664-EXIT.           
           MOVE UT-CODE-MTR-READ-FREQ        TO                         
                                            WS-BC-CODE-MTR-READ-FREQ-BG.
ACT247     IF   BG-RT-PKG-OPT-SEQ-NO = 0                                
ACT247       MOVE UT-RT-PKG-OPT-SEQ-NO                                  
ACT236         TO WS-BC-RT-PKG-OPT-SEQ-NO-BG                            
ACT247     ELSE                                                         
              MOVE BG-RT-PKG-OPT-SEQ-NO                                 
                TO WS-BC-RT-PKG-OPT-SEQ-NO-BG                           
ACT247     END-IF.                                                      
                                                                        
       5110-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5115-GET-BASE-RATE.                                              
           MOVE BG-ACCOUNT-NO                TO UT-ACCOUNT-NO.          
           MOVE BG-CODE-UTIL-TYPE            TO UT-CODE-UTIL-TYPE.      
           MOVE BG-IC-NO                     TO UT-IC-NO.               
           PERFORM 8660-SELECT-BASE-RATE      THRU 8660-EXIT.           
       5115-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *****************************************************************         
      * 5120-LOAD-MTRD-CNSMPTN.                                       *         
      *                                                               *         
      * MOVE CONSUMPTION HISTORY FIELDS TO PASSAREA                   *         
      *                                                               *         
      *****************************************************************         
       5120-LOAD-MTRD-CNSMPTN.                                          
           MOVE CX-ACCOUNT-NO                TO                         
                WS-BC-ACCOUNT-NO-CX (CX-INDX).                          
           MOVE CX-BILL-NO                   TO                         
                WS-BC-BILL-NO-CX (CX-INDX).                             
           MOVE CX-CODE-UTIL-TYPE            TO                         
                WS-BC-CODE-UTIL-TYPE-CX (CX-INDX).                      
           MOVE CX-IC-NO                     TO                         
                WS-BC-IC-NO-CX (CX-INDX).                               
           MOVE CX-BILL-ITEM-TIMESTMP        TO                         
                WS-BC-BILL-ITEM-TIMESTMP-CX (CX-INDX).                  
           MOVE CX-MTR-REF-NO                TO                         
                WS-BC-MTR-REF-NO-CX (CX-INDX).                          
           MOVE CX-CODE-USAGE-TYPE           TO                         
                WS-BC-CODE-USAGE-TYPE-CX (CX-INDX).                     
           MOVE CX-CODE-USAGE-ID             TO                         
                WS-BC-CODE-USAGE-ID-CX (CX-INDX).                       
           MOVE CX-CODE-USAGE-SOURCE         TO                         
                WS-BC-CODE-USAGE-SOURCE-CX (CX-INDX).                   
           MOVE CX-CODE-TIME-PERIOD          TO                         
                WS-BC-CODE-TIME-PERIOD-CX (CX-INDX).                    
           MOVE CX-ITEM-SEQ-NO               TO                         
                WS-BC-ITEM-SEQ-NO-CX (CX-INDX).                         
           MOVE CX-METER-NO                  TO                         
                WS-BC-METER-NO-CX (CX-INDX).                            
           MOVE CX-REG-ID-NO                 TO                         
                WS-BC-REG-ID-NO-CX (CX-INDX).                           
           MOVE CX-DATE-READ                 TO                         
                WS-BC-DATE-READ-CX (CX-INDX).                           
           MOVE CX-CODE-METER-READ           TO                         
                WS-BC-CODE-METER-READ-CX (CX-INDX).                     
           MOVE CX-CODE-METER-NO-READ        TO                         
                WS-BC-CODE-METER-NO-READ-CX (CX-INDX).                  
           MOVE CX-METER-READING             TO                         
                WS-BC-METER-READING-CX (CX-INDX).                       
           MOVE CX-DEMAND-READING            TO                         
                WS-BC-DEMAND-READING-CX (CX-INDX).                      
           MOVE CX-EMPLOYEE-NO               TO                         
                WS-BC-EMPLOYEE-NO-CX (CX-INDX).                         
           MOVE CX-NO-UNITS                  TO                         
                WS-BC-NO-UNITS-CX (CX-INDX).                            
           MOVE CX-NO-DEMAND-UNITS           TO                         
                WS-BC-NO-DEMAND-UNITS-CX (CX-INDX).                     
           MOVE CX-NO-DAYS                   TO                         
                WS-BC-NO-DAYS-CX (CX-INDX).                             
           MOVE CX-CODE-SOURCE-ID            TO                         
                WS-BC-CODE-SOURCE-ID-CX (CX-INDX).                      
           MOVE CX-CODE-DEBIT-CREDIT         TO                         
                WS-BC-CODE-DEBIT-CREDIT-CX (CX-INDX).                   
           MOVE CX-CODE-ITEM-STATUS          TO                         
                WS-BC-CODE-ITEM-STATUS-CX (CX-INDX).                    
           MOVE CX-CODE-DISCOUNT             TO                         
                WS-BC-CODE-DISCOUNT-CX (CX-INDX).                       
           MOVE CX-CONSTANT                  TO                         
                WS-BC-CONSTANT-CX (CX-INDX).                            
           MOVE CX-NO-DIALS                  TO                         
                WS-BC-NO-DIALS-CX (CX-INDX).                            
           MOVE CX-COMPANY-NO                TO                         
                WS-BC-COMPANY-NO-CX (CX-INDX).                          
           MOVE CX-EXCEPT-OVERRIDE-CD        TO                         
                WS-BC-EXCEPT-OVERRIDE-CD-CX (CX-INDX).                  
           MOVE CX-REQUESTED-USAGE           TO                         
                WS-BC-REQUESTED-USAGE-CX (CX-INDX).                     
           MOVE CX-DIGTL-INTRL-MTR-NO        TO                         
                WS-BC-DIGTL-INTRL-MTR-NO-CX (CX-INDX).                  
           MOVE CX-DIGTL-MTR-TYPE            TO                         
                WS-BC-DIGTL-MTR-TYPE-CX (CX-INDX).                      
           MOVE CX-CODE-TOU-SEASN            TO                         
                WS-BC-CODE-TOU-SEASN-CX (CX-INDX).                      
           MOVE CX-EXCL-DMD-RCHT-IND         TO                         
                WS-BC-EXCL-DMD-RCHT-IND-CX (CX-INDX).                   
           MOVE SPACE                        TO                         
                WS-BC-UPDATE-ACTION-IND-CX (CX-INDX).                   
           SET CX-INDX UP BY 1.                                         
           PERFORM 8070-FETCH-CNSMPTN-HIST    THRU  8070-EXIT.          
                                                                        
       5120-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *****************************************************************         
      * 5130-LOAD-UNMTRD-CNSMPTN.                                     *         
      *                                                               *         
      * MOVE UNMETERED CONSUMPTION FIELDS TO PASSAREA                 *         
      *                                                               *         
      *****************************************************************         
       5130-LOAD-UNMTRD-CNSMPTN.                                        
                                                                        
           MOVE UC-ACCOUNT-NO                TO                         
                WS-BC-ACCOUNT-NO-UC (UC-INDX).                          
           MOVE UC-BILL-NO                   TO                         
                WS-BC-BILL-NO-UC (UC-INDX).                             
           MOVE UC-CODE-UTIL-TYPE            TO                         
                WS-BC-CODE-UTIL-TYPE-UC (UC-INDX).                      
           MOVE UC-IC-NO                     TO                         
                WS-BC-IC-NO-UC (UC-INDX).                               
           MOVE UC-BILL-ITEM-TIMESTMP        TO                         
                WS-BC-BILL-ITEM-TIMESTMP-UC (UC-INDX).                  
           MOVE UC-RATE-ITEM-CODE            TO                         
                WS-BC-RATE-ITEM-CODE-UC (UC-INDX).                      
           MOVE UC-ITEM-SEQ-NO               TO                         
                WS-BC-ITEM-SEQ-NO-UC (UC-INDX).                         
           MOVE UC-NO-UNITS                  TO                         
                WS-BC-NO-UNITS-UC (UC-INDX).                            
           MOVE UC-NO-DAYS                   TO                         
                WS-BC-NO-DAYS-UC (UC-INDX).                             
           MOVE UC-CODE-DEBIT-CREDIT         TO                         
                WS-BC-CODE-DEBIT-CREDIT-UC (UC-INDX).                   
           MOVE UC-USAGE-FIXED               TO                         
                WS-BC-USAGE-FIXED-UC (UC-INDX).                         
           MOVE UC-DATE-USAGE-ENDS           TO                         
                WS-BC-DATE-USAGE-ENDS-UC (UC-INDX).                     
           MOVE UC-CODE-SERVICE-TYPE         TO                         
                WS-BC-CODE-SERVICE-TYPE-UC (UC-INDX).                   
           MOVE UC-CODE-ITEM-STATUS          TO                         
                WS-BC-CODE-ITEM-STATUS-UC (UC-INDX).                    
           MOVE UC-CODE-SOURCE-ID            TO                         
                WS-BC-CODE-SOURCE-ID-UC (UC-INDX).                      
           MOVE UC-MTHLY-AMOUNT-FIXED        TO                         
                WS-BC-MTHLY-AMOUNT-FIXED-UC (UC-INDX).                  
           MOVE SPACE                        TO                         
                WS-BC-UPDATE-ACTION-IND-UC (UC-INDX).                   
           MOVE UC-DIST-NO                   TO                         
                WS-BC-DIST-NO-UC (UC-INDX).                             
           MOVE UC-LIGHT-NO                  TO                         
                WS-BC-LIGHT-NO-UC (UC-INDX).                            
           MOVE UC-POLE-NO                   TO                         
                WS-BC-POLE-NO-UC (UC-INDX).                             
           SET UC-INDX UP BY 1.                                         
           PERFORM 8090-FETCH-UNMTRD-CNSMPTN  THRU 8090-EXIT.           
                                                                        
       5130-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 5140-LOAD-FIXED-FCT-HIST.                                     *         
      *                                                               *         
      * MOVE FIXED FACTOR HISTORY FIELDS TO PASSAREA                  *         
      *                                                               *         
      *****************************************************************         
       5140-LOAD-FIXED-FCT-HIST.                                        
                                                                        
           MOVE FH-ACCOUNT-NO                TO                         
                WS-BC-ACCOUNT-NO-FH (FH-INDX).                          
           MOVE FH-BILL-NO                   TO                         
                WS-BC-BILL-NO-FH (FH-INDX).                             
           MOVE FH-CODE-UTIL-TYPE            TO                         
                WS-BC-CODE-UTIL-TYPE-FH (FH-INDX).                      
           MOVE FH-IC-NO                     TO                         
                WS-BC-IC-NO-FH (FH-INDX).                               
           MOVE FH-BILL-ITEM-TIMESTMP        TO                         
                WS-BC-BILL-ITEM-TIMESTMP-FH (FH-INDX).                  
           MOVE FH-FACTOR-ID                 TO                         
                WS-BC-FACTOR-ID-FH (FH-INDX).                           
           MOVE FH-EFF-DATE-FROM             TO                         
                WS-BC-EFF-DATE-FROM-FH (FH-INDX).                       
           MOVE FH-CMPNT-ID-CD               TO                         
                WS-BC-CMPNT-ID-CD-FH (FH-INDX).                         
           MOVE FH-CODE-SEASON               TO                         
                WS-BC-CODE-SEASON-FH (FH-INDX).                         
           MOVE FH-INSTR-USE-TYPE-CD         TO                         
                WS-BC-INSTR-USE-TYPE-CD-FH (FH-INDX).                   
           MOVE FH-CODE-TIME-PERIOD          TO                         
                WS-BC-CODE-TIME-PERIOD-FH (FH-INDX).                    
           MOVE FH-CODE-DEBIT-CREDIT         TO                         
                WS-BC-CODE-DEBIT-CREDIT-FH (FH-INDX).                   
           MOVE FH-CODE-REVENUE-CLASS        TO                         
                WS-BC-CODE-REVENUE-CLASS-FH (FH-INDX).                  
           MOVE FH-CODE-TAX-STAT-XMT         TO                         
                WS-BC-CODE-TAX-STAT-XMT-FH (FH-INDX).                   
           MOVE FH-CODE-TAX-CITY-XMT         TO                         
                WS-BC-CODE-TAX-CITY-XMT-FH (FH-INDX).                   
           MOVE FH-CODE-TAX-OTHR-XMT         TO                         
                WS-BC-CODE-TAX-OTHR-XMT-FH (FH-INDX).                   
           MOVE FH-FACTOR                    TO                         
                WS-BC-FACTOR-FH (FH-INDX).                              
           MOVE SPACE                        TO                         
                WS-BC-UPDATE-ACTION-IND-FH (FH-INDX).                   
           SET FH-INDX UP BY 1.                                         
           PERFORM 8080-FETCH-FIXED-FCT-HIST  THRU 8080-EXIT.           
                                                                        
       5140-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       5150-LOAD-MTR-ENVRNMT.                                           
           MOVE  WS-ACCOUNT-NO               TO                         
                 WS-ACCOUNT-NO-MN (WS-MTRD-INDX).                       
           MOVE  WS-CODE-UTIL-TYPE           TO                         
                 WS-CODE-UTIL-TYPE-MN (WS-MTRD-INDX).                   
           MOVE  WS-IC-NO                    TO                         
                 WS-IC-NO-MN (WS-MTRD-INDX).                            
           MOVE  MN-MTR-REF-NO               TO                         
                 WS-MTR-REF-NO-MN (WS-MTRD-INDX).                       
           MOVE  MN-CODE-TIME-PERIOD         TO                         
                 WS-CODE-TIME-PERIOD-MN (WS-MTRD-INDX).                 
           MOVE  MN-METER-NO                 TO                         
                 WS-METER-NO-MN (WS-MTRD-INDX).                         
           MOVE  MN-CODE-DISCOUNT            TO                         
                 WS-CODE-DISCOUNT-MN (WS-MTRD-INDX).                    
           MOVE  MN-CODE-METER-LOC           TO                         
                 WS-CODE-METER-LOC-MN (WS-MTRD-INDX).                   
           MOVE  MN-CODE-METER-STATUS        TO                         
                 WS-CODE-METER-STATUS-MN (WS-MTRD-INDX).                
           MOVE  MN-CODE-STATUS-REAS         TO                         
                 WS-CODE-STATUS-REAS-MN  (WS-MTRD-INDX).                
           MOVE  MN-CODE-ALRT-CHNG-IND       TO                         
                 WS-CODE-ALRT-CHNG-IND-MN (WS-MTRD-INDX).               
           MOVE  MN-DIST-NODE-POINT          TO                         
                 WS-DIST-NODE-POINT-MN (WS-MTRD-INDX).                  
           MOVE  MN-CODE-DIVERSION           TO                         
                 WS-CODE-DIVERSION-MN (WS-MTRD-INDX).                   
           MOVE  MN-DATE-MTR-INSTALL         TO                         
                 WS-DATE-MTR-INSTALL-MN (WS-MTRD-INDX).                 
           MOVE  MN-CODE-SPCL-SEAL           TO                         
                 WS-CODE-SPCL-SEAL-MN (WS-MTRD-INDX).                   
           MOVE  MN-EST-USAGE                TO                         
                 WS-EST-USAGE-MN (WS-MTRD-INDX).                        
           MOVE  MN-SPCL-MTR-CONDITION       TO                         
                 WS-SPCL-MTR-CONDITION-MN (WS-MTRD-INDX).               
           MOVE  MN-CODE-DATA-PRESENT        TO                         
                 WS-CODE-DATA-PRESENT-MN (WS-MTRD-INDX).                
           MOVE  MN-CODE-USAGE-TYPE          TO                         
                 WS-CODE-USAGE-TYPE-MN (WS-MTRD-INDX).                  
           MOVE  MN-CODE-USAGE-ID            TO                         
                 WS-CODE-USAGE-ID-MN (WS-MTRD-INDX).                    
           MOVE  MN-CODE-USAGE-SOURCE        TO                         
                 WS-CODE-USAGE-SOURCE-MN (WS-MTRD-INDX).                
           MOVE  MN-REG-ID-NO                TO                         
                 WS-REG-ID-NO-MN (WS-MTRD-INDX).                        
           MOVE  MN-REGISTER-RD-SEQ          TO                         
                 WS-REGISTER-RD-SEQ-MN (WS-MTRD-INDX).                  
           MOVE  MN-CODE-CRNT-REG-READ       TO                         
                 WS-CODE-CRNT-REG-READ-MN (WS-MTRD-INDX).               
           MOVE  MN-CODE-NO-RD-REASON        TO                         
                 WS-CODE-NO-RD-REASON-MN (WS-MTRD-INDX).                
           MOVE  MN-CODE-LAST-REG-READ       TO                         
                 WS-CODE-LAST-REG-READ-MN (WS-MTRD-INDX).               
           MOVE  MN-LAST-REG-READ-TIME       TO                         
                 WS-LAST-REG-READ-TIME-MN (WS-MTRD-INDX).               
           MOVE  MN-LAST-REG-READ-DATE       TO                         
                 WS-LAST-REG-READ-DATE-MN (WS-MTRD-INDX).               
           MOVE  MN-LAST-READ-VALUE          TO                         
                 WS-LAST-READ-VALUE-MN (WS-MTRD-INDX).                  
           MOVE  MN-NO-CONSEC-CRD-READ       TO                         
                 WS-NO-CONSEC-CRD-READ-MN (WS-MTRD-INDX).               
           MOVE  MN-NO-CONSEC-ESTIMATE       TO                         
                 WS-NO-CONSEC-ESTIMATE-MN (WS-MTRD-INDX).               
           MOVE  MN-POINT-ID                 TO                         
                 WS-POINT-ID-MN (WS-MTRD-INDX).                         
           MOVE  MN-LOCK-TYPE-ID             TO                         
                 WS-LOCK-TYPE-ID-MN (WS-MTRD-INDX).                     
           MOVE  MN-SEAL-CODE-ID             TO                         
                 WS-SEAL-CODE-ID-MN (WS-MTRD-INDX).                     
           MOVE  MN-HEXAGRAM-LOCATION        TO                         
                 WS-HEXAGRAM-LOCATION-MN (WS-MTRD-INDX).                
           MOVE  MN-INSULATED-IND            TO                         
                 WS-INSULATED-IND-MN (WS-MTRD-INDX).                    
           MOVE  MN-METER-SUPPLYING          TO                         
                 WS-METER-SUPPLYING-MN (WS-MTRD-INDX).                  
           MOVE  MN-LAST-VALID-READ-TM       TO                         
                 WS-LAST-VALID-READ-TM-MN (WS-MTRD-INDX).               
           MOVE  MN-LAST-VALID-READ-DT       TO                         
                 WS-LAST-VALID-READ-DT-MN (WS-MTRD-INDX).               
           MOVE  MN-READ-CARD-PRINT-DT       TO                         
                 WS-READ-CARD-PRINT-DT-MN (WS-MTRD-INDX).               
           MOVE  MN-EXCEPT-OVERRIDE-CD       TO                         
                 WS-EXCEPT-OVERRIDE-CD-MN (WS-MTRD-INDX).               
           MOVE  MN-CODE-MTR-RD-INST1        TO                         
                 WS-CODE-MTR-RD-INST1-MN (WS-MTRD-INDX).                
           MOVE  MN-CODE-MTR-RD-INST2        TO                         
                 WS-CODE-MTR-RD-INST2-MN (WS-MTRD-INDX).                
           MOVE  MN-CODE-MTR-RD-INST3        TO                         
                 WS-CODE-MTR-RD-INST3-MN (WS-MTRD-INDX).                
           MOVE  MN-DIGTL-MTR-TYPE           TO                         
                 WS-DIGTL-MTR-TYPE-MN (WS-MTRD-INDX).                   
           MOVE  MN-LAST-VAL-RD-VALUE        TO                         
                 WS-LAST-VAL-RD-VALUE-MN (WS-MTRD-INDX).                
           MOVE  MN-CODE-LAST-VALID-RD       TO                         
                 WS-CODE-LAST-VALID-RD-MN (WS-MTRD-INDX).               
           MOVE  MN-LAST-UPDATE-TS           TO                         
                 WS-LAST-UPDATE-TS-MN (WS-MTRD-INDX).                   
           MOVE  MN-REMOTE-READ-IND          TO                         
                 WS-REMOTE-READ-IND-MN (WS-MTRD-INDX).                  
           MOVE  MN-MTR-READ-SOURCE-CD       TO                         
                 WS-MTR-READ-SOURCE-CD-MN (WS-MTRD-INDX).               
           MOVE  MN-UTILITY-SOURCE-CD        TO                         
                 WS-UTILITY-SOURCE-CD-MN (WS-MTRD-INDX)                 
           MOVE  MN-DELIVERY-LEVEL-CD        TO                         
                 WS-DELIVERY-LEVEL-CD-MN (WS-MTRD-INDX)                 
           MOVE  MN-MTR-STATUS-CHNG-DT       TO                         
                 WS-MTR-STATUS-CHNG-DT-MN (WS-MTRD-INDX)                
                                                                        
           SET WS-MTRD-INDX UP BY 1.                                    
           PERFORM 8510-FETCH-MTRD-ENVRNMT    THRU  8510-EXIT.          
                                                                        
       5150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       5160-LOAD-BILL-ADJUSTMENT.                                       
      *                                                                         
           MOVE BP-ACCOUNT-NO                TO                         
                WS-BC-ACCOUNT-NO-BP(WS-BC-ADJUSTMNT-INDEX)              
           MOVE BP-BILL-NO                   TO                         
                WS-BC-BILL-NO-BP(WS-BC-ADJUSTMNT-INDEX)                 
           MOVE BP-CODE-UTIL-TYPE            TO                         
                WS-BC-CODE-UTIL-TYPE-BP(WS-BC-ADJUSTMNT-INDEX)          
           MOVE BP-IC-NO                     TO                         
                WS-BC-IC-NO-BP(WS-BC-ADJUSTMNT-INDEX)                   
           MOVE BP-BILL-ITEM-TIMESTMP        TO                         
                WS-BC-BILL-ITEM-TIMESTMP-BP(WS-BC-ADJUSTMNT-INDEX)      
           MOVE BP-ADJ-TYPE-CD               TO                         
                WS-BC-ADJ-TYPE-CD-BP(WS-BC-ADJUSTMNT-INDEX)             
           MOVE BP-REVENUE-MONTH             TO                         
                WS-BC-REVENUE-MONTH-BP(WS-BC-ADJUSTMNT-INDEX)           
           MOVE BP-ADJ-REASON-DESC-LEN        TO                        
                WS-BC-ADJ-REASON-DESC-LEN-BP(WS-BC-ADJUSTMNT-INDEX)     
           MOVE BP-ADJ-REASON-DESC-TEXT       TO                        
                WS-BC-ADJ-REASON-DESC-TEXT-BP(WS-BC-ADJUSTMNT-INDEX)    
           MOVE BP-OVRRIDE-RT-REV-MTH         TO                        
                WS-BC-OVRRIDE-RT-REV-MTH-BP(WS-BC-ADJUSTMNT-INDEX)      
           MOVE BP-OVRRIDE-RT-BILL-DT         TO                        
                WS-BC-OVRRIDE-RT-BILL-DT-BP(WS-BC-ADJUSTMNT-INDEX)      
           MOVE BP-OVRRIDE-RT-BILL-CY         TO                        
                WS-BC-OVRRIDE-RT-BILL-CY-BP(WS-BC-ADJUSTMNT-INDEX)      
      *                                                                         
           SET WS-BC-ADJUSTMNT-INDEX UP BY +1.                          
           PERFORM 8050-FETCH-BILL-ADJUSTMENT THRU 8050-EXIT.           
      *                                                                         
       5160-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 5170-MOVE-CWS1000B-BG.                                        *         
      * MOVE BILLING DETAIL FIELDS TO CWS1000B PASSAREA               *         
      *****************************************************************         
       5170-MOVE-CWS1000B-BG.                                           
                                                                        
           MOVE WS-BC-ACCOUNT-NO-BG          TO                         
                             WS-ACCOUNT-NO-BG (WS-BILLING-INDX)         
           MOVE WS-BC-BILL-NO-BG             TO                         
                             WS-BILL-NO-BG (WS-BILLING-INDX)            
           MOVE WS-BC-CODE-UTIL-TYPE-BG      TO                         
                             WS-CODE-UTIL-TYPE-BG (WS-BILLING-INDX)     
           MOVE WS-BC-IC-NO-BG               TO                         
                             WS-IC-NO-BG (WS-BILLING-INDX)              
           MOVE WS-BC-BILL-ITEM-TIMESTMP-BG  TO                         
                             WS-BILL-ITEM-TIMESTMP-BG (WS-BILLING-INDX) 
           MOVE WS-BC-PREMISE-NO-BG          TO                         
                             WS-PREMISE-NO-BG (WS-BILLING-INDX)         
           MOVE WS-BC-DATE-ORIG-BILL-BG      TO                         
                             WS-DATE-ORIG-BILL-BG (WS-BILLING-INDX)     
           MOVE WS-BC-AMT-BILL-ITEM-BG       TO                         
                             WS-AMT-BILL-ITEM-BG (WS-BILLING-INDX)      
           MOVE WS-BC-CODE-BILL-CALC-BG      TO                         
                             WS-CODE-BILL-CALC-BG (WS-BILLING-INDX)     
           MOVE WS-BC-CODE-BILL-ITM-TYPE-BG  TO                         
                             WS-CODE-BILL-ITM-TYPE-BG (WS-BILLING-INDX) 
           MOVE WS-BC-CODE-BILL-ITM-IND-BG   TO                         
                             WS-CODE-BILL-ITM-IND-BG (WS-BILLING-INDX)  
           MOVE WS-BC-CODE-DR-CR-CNSMPTN-BG  TO                         
                             WS-CODE-DR-CR-CNSMPTN-BG (WS-BILLING-INDX) 
           MOVE WS-BC-AMT-STATE-TAX-BG       TO                         
                             WS-AMT-STATE-TAX-BG (WS-BILLING-INDX)      
           MOVE WS-BC-AMT-CITY-TAX-BG        TO                         
                             WS-AMT-CITY-TAX-BG (WS-BILLING-INDX)       
           MOVE WS-BC-AMT-OTHER-TAX-BG       TO                         
                             WS-AMT-OTHER-TAX-BG (WS-BILLING-INDX)      
           MOVE WS-BC-CODE-REVENUE-CLASS-BG  TO                         
                             WS-CODE-REVENUE-CLASS-BG (WS-BILLING-INDX) 
           MOVE WS-BC-CODE-SIC-NO-BG         TO                         
                             WS-CODE-SIC-NO-BG (WS-BILLING-INDX)        
           MOVE WS-BC-RATE-PLAN-NO-BG        TO                         
                             WS-RATE-PLAN-NO-BG (WS-BILLING-INDX)       
           MOVE WS-BC-CODE-CURTAIL-PRTY-BG   TO                         
                             WS-CODE-CURTAIL-PRTY-BG (WS-BILLING-INDX)  
           MOVE WS-BC-CODE-STAT-TAX-XMT-BG   TO                         
                             WS-CODE-STAT-TAX-XMT-BG (WS-BILLING-INDX)  
           MOVE WS-BC-CODE-CITY-TAX-XMT-BG   TO                         
                             WS-CODE-CITY-TAX-XMT-BG (WS-BILLING-INDX)  
           MOVE WS-BC-CODE-OTHR-TAX-XMT-BG   TO                         
                             WS-CODE-OTHR-TAX-XMT-BG (WS-BILLING-INDX)  
           MOVE WS-BC-REV-RPT-CD-BG          TO                         
                             WS-REV-RPT-CD-BG (WS-BILLING-INDX)         
           MOVE WS-BC-STANDBY-COMPLIED-BG    TO                         
                             WS-STANDBY-COMPLIED-BG (WS-BILLING-INDX)   
           MOVE WS-BC-PRORATE-CD-BG          TO                         
                             WS-PRORATE-CD-BG (WS-BILLING-INDX)         
           MOVE WS-BC-NEW-RATE-PCT-BG        TO                         
                             WS-NEW-RATE-PCT-BG (WS-BILLING-INDX)       
           MOVE WS-BC-CODE-SUB-TOTAL-BG      TO                         
                             WS-CODE-SUB-TOTAL-BG (WS-BILLING-INDX)     
           MOVE WS-BC-TAX-REFUND-CD-BG       TO                         
                             WS-TAX-REFUND-CD-BG (WS-BILLING-INDX)      
           MOVE WS-BC-COMPANY-NO-BG          TO                         
                             WS-COMPANY-NO-BG (WS-BILLING-INDX)         
           MOVE WS-BC-DATE-LFTM-HI-DMD-BG    TO                         
                             WS-DATE-LFTM-HI-DMD-BG (WS-BILLING-INDX)   
           MOVE WS-BC-LFTM-HI-PEAK-DMD-BG    TO                         
                             WS-LFTM-HI-PEAK-DMD-BG (WS-BILLING-INDX)   
           MOVE WS-BC-REBILL-IND-BG          TO                         
                             WS-REBILL-IND-BG (WS-BILLING-INDX)         
           MOVE WS-BC-REVENUE-MONTH-BG       TO                         
                             WS-REVENUE-MONTH-BG (WS-BILLING-INDX)      
           MOVE WS-BC-GAS-BASE-USE-BG        TO                         
                             WS-GAS-BASE-USE-BG (WS-BILLING-INDX)       
           MOVE WS-BC-ADJ-REASON-CD-BG       TO                         
                             WS-ADJ-REASON-CD-BG (WS-BILLING-INDX)      
           MOVE WS-BC-WNA-FACTOR-BG          TO                         
                             WS-WNA-FACTOR-BG (WS-BILLING-INDX)         
           MOVE WS-BC-BTU-FACTOR-BG          TO                         
                             WS-BTU-FACTOR-BG (WS-BILLING-INDX)         
           MOVE WS-BC-REV-MTH-ORIG-BILL-BG   TO                         
                             WS-REV-MTH-ORIG-BILL-BG (WS-BILLING-INDX)  
           MOVE WS-BC-BILL-CALC-CYCLE-BG     TO                         
                             WS-BILL-CALC-CYCLE-BG (WS-BILLING-INDX)    
           MOVE WS-BC-RT-PKG-OPT-SEQ-NO-BG   TO                         
                             WS-RT-PKG-OPT-SEQ-NO-BG (WS-BILLING-INDX)  
           MOVE WS-BC-CODE-MTR-READ-FREQ-BG  TO                         
                             WS-CODE-MTR-READ-FREQ-BG (WS-BILLING-INDX).
       5170-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 5180-LOAD-CUST-PLAN.                                          *         
      * MOVE BILLING DETAIL FIELDS TO CWS1000B PASSAREA               *         
      *****************************************************************         
       5180-LOAD-CUST-PLAN.                                             
                                                                        
           PERFORM 8270-OPEN-CUST-PLAN     THRU 8270-EXIT.              
           PERFORM 8280-FETCH-CUST-PLAN    THRU 8280-EXIT.              
           PERFORM 5185-LOAD-CUST-PLAN     THRU 5185-EXIT               
                 UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.           
           PERFORM 8290-CLOSE-CUST-PLAN    THRU 8290-EXIT.              
                                                                        
       5180-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 5185-LOAD-CUST-PLAN.                                          *         
      * MOVE BILLING DETAIL FIELDS TO CWS1000B PASSAREA               *         
      *****************************************************************         
       5185-LOAD-CUST-PLAN.                                             
                                                                        
           MOVE WS-ACCOUNT-NO                   TO                      
                   WS-ACCOUNT-NO-CP (WS-CUST-PLAN-INDX)   .             
           MOVE WS-CODE-UTIL-TYPE               TO                      
                   WS-CODE-UTIL-TYPE-CP (WS-CUST-PLAN-INDX).            
           MOVE WS-IC-NO                        TO                      
                   WS-IC-NO-CP (WS-CUST-PLAN-INDX)          .           
           MOVE CP-RATE-ITEM-CODE               TO                      
                WS-RATE-ITEM-CODE-CP (WS-CUST-PLAN-INDX)    .           
           MOVE CP-ITEM-SEQ-NO                  TO                      
                WS-ITEM-SEQ-NO-CP (WS-CUST-PLAN-INDX)       .           
           MOVE CP-CODE-PLAN-STATUS             TO                      
                WS-CODE-PLAN-STATUS-CP (WS-CUST-PLAN-INDX)  .           
           MOVE CP-CODE-STAT-REASON             TO                      
                WS-CODE-STAT-REASON-CP (WS-CUST-PLAN-INDX)  .           
           MOVE CP-DATE-PLAN-START              TO                      
                WS-DATE-PLAN-START-CP (WS-CUST-PLAN-INDX)   .           
           MOVE CP-CODE-SERVICE-TYPE            TO                      
                WS-CODE-SERVICE-TYPE-CP (WS-CUST-PLAN-INDX) .           
           MOVE CP-USAGE-FIXED                  TO                      
                WS-USAGE-FIXED-CP (WS-CUST-PLAN-INDX)       .           
           MOVE CP-MTHLY-AMOUNT-FIXED           TO                      
                WS-MTHLY-AMOUNT-FIXED-CP (WS-CUST-PLAN-INDX).           
           MOVE CP-NO-UNITS                     TO                      
                WS-NO-UNITS-CP (WS-CUST-PLAN-INDX)          .           
           MOVE CP-REMOVE-DATE                  TO                      
                WS-REMOVE-DATE-CP (WS-CUST-PLAN-INDX)       .           
           MOVE CP-DIST-NO                      TO                      
                WS-DIST-NO-CP (WS-CUST-PLAN-INDX)           .           
           MOVE CP-POLE-NO                     TO                       
                WS-POLE-NO-CP (WS-CUST-PLAN-INDX)           .           
           MOVE CP-LIGHT-NO                     TO                      
                WS-LIGHT-NO-CP (WS-CUST-PLAN-INDX)          .           
           MOVE CP-LAST-BILL-DATE               TO                      
                WS-LAST-BILL-DATE-CP (WS-CUST-PLAN-INDX)    .           
      *                                                                 05497000
           PERFORM 8280-FETCH-CUST-PLAN    THRU  8280-EXIT.             
           SET WS-CUST-PLAN-INDX UP BY 1.                               
                                                                        
       5185-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05507000
      *****************************************************************         
      * 6000-CALL-BILL-CALC.                                          *         
      *                                                               *         
      * CALL BILL CALCULATION ROUTINE                                 *         
      *                                                               *         
      *****************************************************************         
       6000-CALL-BILL-CALC.                                             
                                                                        
                  CALL MCSCB107 USING                                   
                                 LS-PCSCA100-COMM-AREA                  
                               , WS-BILLING-CALC-WORK                   
                               , WS-BILLING-COMPONENT                   
                               , WS-BILLING-ADJUSTMENT                  
                               , WS-BILL-CALC-BG                        
                               , WS-BILL-CALC-CX                        
                               , WS-BILL-CALC-UC                        
                               , WS-BILL-CALC-FH                        
                               , WS-BILL-CONTRACT-BK                    
                               , WS-FIXED-FCTR-TABLE-FF                 
                               , WS-BILL-CNTR-HIST-BX                   
                               , WS-PEAK-HIST-PH                        
                               , WS-INTERRUPT-ACCT-IP                   
                               , WS-MTRD-ENVRNMT-TABLE-MN               
                               , WS-STANDBY-GEN-SE                      
                               , WS-INTERRUPT-IR                        
                               , WS-HOLD-CX-DATA                        
                               , WS-HOLD-BC-DATA                        
                               , WS-HOLD-BA-DATA                        
                               , WS-BILLING-WQ-ITEMS-WF                 
                               , WS-REFUND-RN                           
                               , WS-ACCOUNT-AT                          
                               , WS-BC-BILL-ADJUSTMNT                   
                               , WS-BC-ACCT-RTPK-AGR-DF                 
                               , WS-BC-FIXED-FCTR-FF                    
                               , WS-BC-BILL-DET-BT                      
                               , WS-CWS22B-MAX-TBL-LIMITS               
                               , WS-BILL-CALC-DETAIL-X                  
                               , WS-BC-VOL-DAILY-ND                     
                               , WS-BILL-BSLN-CNTR-LN                   
                               , WS-BILL-BSLN-HIST-LO                   
                               , WS-UTL-BILL-REL-TABLE-UR               
                               , WS-INTERRUPT-NZ                        
                               , WS-CNSMPTN-HOURLY.                     
                                                                        
       6000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      ** 6000-TAX-CALCULATION                                         **        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDCB107                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPDCA122                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * 6100-SUM-BFC                                                  *         
      * SUM ALL BFC ADJUSTMENT ROWS                                   *         
      *****************************************************************         
       6100-SUM-BFC.                                                    
                                                                        
           PERFORM VARYING BA-INDX FROM 1 BY 1                          
                    UNTIL BA-INDX > 200                                 
              OR WS-BC-FACTOR-ID (BA-INDX) = SPACES                     
              IF WS-BC-FACTOR-ID (BA-INDX) = 'BFACCHRG'                 
                 IF WS-BC-AMT-ADJUSTMENT (BA-INDX) > 0                  
                     ADD WS-BC-AMT-ADJUSTMENT (BA-INDX)                 
                                             TO WS-USAGE-CHRGS-CREDITS  
                                                WS-BASIC-FCLTY-CHRG     
                                                WS-HOLD-BASIC-FACILITY  
                     MOVE WS-BC-FACTOR-ID (BA-INDX)                     
                                             TO RS-FACTOR-ID            
                     MOVE WS-BC-FACTOR (BA-INDX)                        
                                             TO RS-NET-RATE             
                     MOVE WS-BC-FACTOR-COMPONENT (BA-INDX)              
                                             TO RS-COMPONENT-KEY        
                     MOVE WS-BC-FCT-CNSMPT-TYPE (BA-INDX)               
                                             TO RS-CONSUMPTION-TYPE     
                     MOVE WS-BC-FCT-RATE-VERSION (BA-INDX)              
                                             TO RS-RATE-VERSION         
                     MOVE WS-BC-FCT-TOU (BA-INDX)                       
                                             TO RS-CODE-TOU             
                     MOVE WS-BC-FCT-SEASON (BA-INDX)                    
                                             TO RS-CODE-SN              
                     MOVE WS-BC-FCT-CMPNT-ID (BA-INDX)                  
                                             TO RS-COMPONENT-ID         
                     PERFORM 8400-GET-FACTOR-TEXT                       
                                              THRU 8400-EXIT            
                     MOVE SF-FACTOR-DESC     TO RS-CHARGE-DESC          
                     MOVE SF-FACTOR-TYPE     TO RS-FACTOR-TYPE          
                     MOVE SF-ADJUST-ELEMENT  TO RS-ADJUST-ELEMENT       
                     MOVE SF-CALC-TYPE-CD    TO RS-CALC-TYPE-CD         
                     MOVE WS-BC-AMT-ADJUSTMENT (BA-INDX)                
                                             TO RS-COMPUTED-CHARGE      
                                                                        
                     IF WS-BC-ADJ-UNITS (BA-INDX) > ZERO                
                        MOVE WS-BC-ADJ-UNITS (BA-INDX)                  
                                             TO RS-UNITS-BILLED         
                     END-IF                                             
                                                                        
                     PERFORM 2000A-MOVE-RESULT                          
                                              THRU 2000A-EXIT           
                     PERFORM 8100D-INSERT-GTT-R4                        
                                              THRU 8100D-EXIT           
                     INITIALIZE TDS-RETURN-FIELDS                       
                 END-IF                                                 
              END-IF                                                    
           END-PERFORM.                                                 
           PERFORM VARYING BA-INDX FROM 1 BY 1                          
             UNTIL BA-INDX > 200                                        
                OR WS-BC-FACTOR-ID (BA-INDX) = SPACES                   
              IF WS-BC-FACTOR-ID (BA-INDX) = 'SPMNTMIN'                 
                 MOVE 'Y'                    TO WS-SPMNTMIN-SW          
                 IF WS-BC-AMT-ADJUSTMENT (BA-INDX) > 0                  
                    MOVE WS-BC-FACTOR-ID (BA-INDX)                      
                                             TO RS-FACTOR-ID            
                    MOVE WS-BC-FCT-CNSMPT-TYPE (BA-INDX)                
                                             TO RS-CONSUMPTION-TYPE     
                    MOVE WS-BC-FCT-REGISTER-TYPE (BA-INDX)              
                                             TO RS-REGISTER-TYPE        
                    MOVE WS-BC-FCT-RATE-VERSION (BA-INDX)               
                                             TO RS-RATE-VERSION         
                    MOVE WS-BC-AMT-ADJUSTMENT   (BA-INDX)               
                                             TO RS-COMPUTED-CHARGE      
                    MOVE WS-BC-FACTOR-COMPONENT (BA-INDX)               
                                             TO RS-COMPONENT-KEY        
                    PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT           
                    PERFORM 8100B-INSERT-GTT-R2                         
                                              THRU 8100B-EXIT           
                    INITIALIZE TDS-RETURN-FIELDS                        
                 END-IF                                                 
              END-IF                                                    
           END-PERFORM.                                                 
           PERFORM VARYING BA-INDX FROM 1 BY 1                          
             UNTIL BA-INDX > 200                                        
                OR WS-BC-FACTOR-ID (BA-INDX) = SPACES                   
              IF WS-BC-FACTOR-ID (BA-INDX) (1:6) = 'SEABLK'             
                 IF WS-BC-FACTOR (BA-INDX) > 0                          
                     MOVE WS-BC-FACTOR-ID (BA-INDX)                     
                                             TO RS-FACTOR-ID            
                     PERFORM 8400-GET-FACTOR-TEXT                       
                                              THRU 8400-EXIT            
                     MOVE SF-FACTOR-DESC     TO RS-FACTOR-DESC          
                     MOVE SF-FACTOR-TYPE     TO RS-FACTOR-TYPE          
                     MOVE SF-ADJUST-ELEMENT  TO RS-ADJUST-ELEMENT       
                     MOVE SF-CALC-TYPE-CD    TO RS-CALC-TYPE-CD         
                     MOVE 'F'                TO RS-PRICE-TYPE-CD        
                     MOVE WS-BC-FACTOR (BA-INDX)                        
                                             TO RS-COMPUTED-CHARGE      
                     MOVE WS-BC-FCT-CNSMPT-TYPE (BA-INDX)               
                                             TO RS-CONSUMPTION-TYPE     
                     MOVE WS-BC-FCT-REGISTER-TYPE (BA-INDX)             
                                             TO RS-REGISTER-TYPE        
                     MOVE WS-BC-FCT-RATE-VERSION (BA-INDX)              
                                             TO RS-RATE-VERSION         
                     MOVE WS-BC-FACTOR-COMPONENT (BA-INDX)              
                                             TO RS-COMPONENT-KEY        
                     PERFORM 2000A-MOVE-RESULT                          
                                              THRU 2000A-EXIT           
                     PERFORM 8100B-INSERT-GTT-R2                        
                                              THRU 8100B-EXIT           
                     INITIALIZE TDS-RETURN-FIELDS                       
                 END-IF                                                 
              END-IF                                                    
           END-PERFORM.                                                 
                                                                        
       6100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       6200-PRORATE.                                                    
                                                                        
           SET PRO-INDX                      TO 1.                      
           PERFORM VARYING BC-INDX FROM 1 BY 1                          
             UNTIL BC-INDX > WS-BC-MAX-ENTRY                            
                OR WS-BC-CONSUMPTION-TYPE (BC-INDX) = SPACE             
              IF WS-BC-CIG-CUSTOMER-IND-BG = 'Y'                        
                 MOVE WS-BC-CODE-UTIL-TYPE-BG                           
                                             TO RS-CODE-UTIL-TYPE       
                 MOVE 'N'                    TO RS-CODE-SEASON          
                 MOVE WS-BC-RATE-PLAN-NO-BG  TO RS-RATE-PLAN-NO         
                 MOVE WS-BC-REVENUE-MONTH-BG TO WS-CIG-REV-MONTH        
                 MOVE WS-CIG-REV-MONTH (5:2) TO WS-RS-MM                
                 MOVE '01'                   TO WS-RS-DD                
                 MOVE WS-RS-DATE-FROM        TO WS-CIG-DATE-FROM        
                 MOVE WS-CIG-DATE-FROM       TO RS-DATE-FROM            
                 PERFORM 8661-GET-SEASONAL-CODE                         
                                              THRU 8661-EXIT            
                 MOVE 'N'                    TO WS-PROCESS-BILL-CALC    
                IF WS-BC-NET-COMPONENT-AMT (BC-INDX) = ZERO AND         
                   WS-BC-NET-UNITS (BC-INDX) = ZERO         AND         
                   WS-BC-COMPONENT-ID(BC-INDX) <= '20'      AND         
                   WS-BC-CIG-TRNSP-DET-BG = 'N'             AND         
                   WS-BC-TOTAL-WNA-AMT (BC-INDX) = 0        AND         
                   ENERGY-COMPONENT (BC-INDX)               AND         
                   (WS-BC-CODE-SEASON (BC-INDX) = RS-CODE-SEASON  OR    
                   WS-BC-CODE-SEASON (BC-INDX) = WS-BOTH)   AND         
                   WS-BC-AMT-NET-RATE(BC-INDX, 1) > 0                   
                   MOVE 'Y'                  TO WS-PROCESS-BILL-CALC    
                END-IF                                                  
                IF WS-BC-NET-COMPONENT-AMT (BC-INDX) NOT = ZERO         
                    OR WS-BC-NET-UNITS (BC-INDX) NOT = ZERO             
                   MOVE 'Y'                  TO WS-PROCESS-BILL-CALC    
                END-IF                                                  
              ELSE                                                      
                 MOVE 'Y'                    TO WS-PROCESS-BILL-CALC    
              END-IF                                                    
              IF WS-PROCESS-BILL-CALC = 'Y'                             
              IF WS-BC-CONSUMPTION-TYPE (BC-INDX)  = 'E'                
               OR WS-BC-CONSUMPTION-TYPE (BC-INDX) = 'J'                
                 ADD WS-BC-CALC-COMPONENT-AMT (BC-INDX)                 
                                             TO                         
                     WS-TOTAL-DEMAND-CHARGES                            
                 COMPUTE WS-DEMAND-CHRGS-CREDITS =                      
                    WS-DEMAND-CHRGS-CREDITS +                           
                       (WS-BC-NET-COMPONENT-AMT (BC-INDX) -             
                         WS-BC-CALC-COMPONENT-AMT(BC-INDX))             
              END-IF                                                    
              MOVE WS-BC-READ-UNITS (BC-INDX)                           
                                             TO                         
                   WS-PRO-UNITS-READ (PRO-INDX)                         
              MOVE WS-BC-NET-UNITS (BC-INDX) TO                         
                   WS-PRO-UNITS-BILLED (PRO-INDX)                       
              MOVE WS-BC-CALC-COMPONENT-AMT (BC-INDX)                   
                                             TO                         
                   WS-PRO-DOLLAR-AMT (PRO-INDX)                         
              IF (WS-BC-CIG-CUSTOMER-IND-BG = 'Y') AND                  
                 (WS-BC-COMPONENT-ID(BC-INDX) = '70' OR                 
                  WS-BC-COMPONENT-ID(BC-INDX) = '71' )                  
                MOVE WS-BC-NET-COMPONENT-AMT(BC-INDX)                   
                                             TO                         
                     WS-PRO-DOLLAR-AMT (PRO-INDX)                       
              END-IF                                                    
              MOVE WS-BC-CONSUMPTION-TYPE (BC-INDX)                     
                                             TO                         
                   WS-PRO-CONSUMPTION-TYPE (PRO-INDX)                   
              MOVE +0                        TO WS-PRO-RATE (PRO-INDX)  
              PERFORM 6300-LITERALS           THRU 6300-EXIT            
              SET PRO-INDX UP BY 1                                      
              END-IF                                                    
           END-PERFORM.                                                 
                                                                        
       6200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       6300-LITERALS.                                                   
                                                                        
           INITIALIZE TDS-RETURN-FIELDS.                                
           IF WS-BC-COMPONENT-ID (BC-INDX) (1:1) = 'U'                  
              PERFORM 8300-GET-UM-TEXT        THRU 8300-EXIT            
              MOVE L9-UM-EQUIP-SHRT-DESC     TO RS-CHARGE-DESC          
              ADD WS-BC-NET-UNITS (BC-INDX)  TO WS-TOTAL-NET-UNITS      
           END-IF.                                                      
           MOVE WS-PRO-UNITS-READ (PRO-INDX) TO RS-UNITS-READ.          
           MOVE WS-PRO-UNITS-BILLED (PRO-INDX)                          
                                             TO RS-UNITS-BILLED.        
           MOVE WS-PRO-DOLLAR-AMT (PRO-INDX) TO RS-COMPUTED-CHARGE.     
      ** DISPLAY DETAIL INFORMATION FOR SCANA CUSTOMERS ONLY                    
           IF SEB-DATABASE                                              
              MOVE '  1'                     TO RS-BLOCK-NUMBER         
              MOVE 1                         TO RS-BLOCK-NO             
              MOVE WS-BC-AMT-BLOCK (BC-INDX 1)                          
                                             TO RS-COMPUTED-CHARGE      
              MOVE WS-BC-NET-UNITS (BC-INDX) TO RS-NET-UNITS            
              MOVE WS-BC-BLOCK-SIZE (BC-INDX 1)                         
                                             TO RS-BLOCK-SIZE           
              MOVE WS-BC-PRICE-TYPE-CD(BC-INDX 1)                       
                                             TO RS-PRICE-TYPE-CD        
              MOVE WS-BC-AMT-BASE-RATE (BC-INDX 1)                      
                                             TO RS-BASE-RATE            
              MOVE WS-BC-AMT-NET-RATE (BC-INDX 1)                       
                                             TO RS-NET-RATE             
           END-IF                                                       
           IF WS-BC-CIG-CUSTOMER-IND-BG   = 'Y'  AND                    
             (WS-BC-AMT-BLOCK (BC-INDX 1) =                             
                                     WS-BC-CALC-COMPONENT-AMT (BC-INDX))
              MOVE WS-BC-AMT-BASE-RATE (BC-INDX 1)                      
                                             TO RS-BASE-RATE            
              MOVE WS-BC-AMT-NET-RATE (BC-INDX 1)                       
                                             TO RS-NET-RATE             
           END-IF                                                       
           IF WS-PRO-RATE (PRO-INDX) NOT = 0                            
              MOVE WS-PRO-RATE (PRO-INDX)    TO RS-NET-RATE             
           END-IF.                                                      
           MOVE WS-BC-CONSUMPTION-TYPE (BC-INDX)                        
                                             TO RS-CONSUMPTION-TYPE.    
           MOVE WS-BC-REGISTER-TYPE (BC-INDX)                           
                                             TO RS-REGISTER-TYPE.       
           MOVE WS-BC-RATE-VERSION (BC-INDX) TO RS-RATE-VERSION.        
           MOVE WS-BC-CODE-TOU (BC-INDX)     TO RS-CODE-TOU.            
           MOVE WS-BC-CODE-SEASON (BC-INDX)  TO RS-CODE-SN.             
           MOVE WS-BC-COMPONENT-ID (BC-INDX) TO RS-COMPONENT-ID.        
           MOVE WS-BC-COMPONENT-KEY (BC-INDX)                           
                                             TO RS-COMPONENT-KEY.       
           IF RS-COMPONENT-ID > SPACES                                  
              ADD RS-NET-RATE                TO WS-PRICE-PER-THERM      
           END-IF.                                                      
      *    ADD  RS-UNITS-BILLED              TO WS-TOTAL-NET-UNITS.             
           PERFORM 2000A-MOVE-RESULT          THRU 2000A-EXIT.          
           PERFORM 8100C-INSERT-GTT-R3        THRU 8100C-EXIT.          
                                                                        
       6300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 6400-SPANNMIN.                                                 *        
      *                                                                *        
      *   HANDLE SPECIAL ANNUAL MINIMUMS                               *        
      *                                                                *        
      ******************************************************************        
       6400-SPANNMIN.                                                   
                                                                        
           MOVE SPACES                       TO WS-CNTRCT-START-DT.     
           SET WS-BX-INDX                    TO 1.                      
           SEARCH WS-BILL-CNTR-HIST-DATA                                
              AT END                                                    
                 CONTINUE                                               
              WHEN WS-ACCOUNT-NO-BX (WS-BX-INDX)                        
                       = ZERO                                           
                 CONTINUE                                               
              WHEN WS-ACCOUNT-NO-BX (WS-BX-INDX)                        
                       = WS-BC-ACCOUNT-NO-BG                            
                     AND WS-BILL-NO-BX (WS-BX-INDX)                     
                       = WS-BC-BILL-NO-BG                               
                     AND WS-CODE-UTIL-TYPE-BX (WS-BX-INDX)              
                       = WS-BC-CODE-UTIL-TYPE-BG                        
                     AND WS-IC-NO-BX (WS-BX-INDX)                       
                       = WS-BC-IC-NO-BG                                 
                     AND WS-BILL-ITEM-TIMESTMP-BX (WS-BX-INDX)          
                       = WS-BC-BILL-ITEM-TIMESTMP-BG                    
                     AND WS-SPCL-ANN-MIN-AM-BX (WS-BX-INDX) > 0         
                        MOVE WS-CNTRCT-START-DT-BX (WS-BX-INDX)         
                                             TO WS-CNTRCT-START-DT      
           END-SEARCH.                                                  
           MOVE WS-BC-REVENUE-MONTH-BG       TO WS-HOLD-REV-MONTH       
           IF WS-CNTRCT-START-MTH = WS-HOLD-REV-MONTH (5:2)             
              PERFORM 6410-GET-BG-AMT         THRU 6410-EXIT            
              MOVE BG-AMT-BILL-ITEM          TO WS-HOLD-BG-AMT          
              MOVE WS-BC-AMT-STATE-TAX-BG    TO WS-HOLD-STATE           
              MOVE WS-BC-AMT-CITY-TAX-BG     TO WS-HOLD-CITY            
              MOVE WS-BC-AMT-OTHER-TAX-BG    TO WS-HOLD-OTHER           
              IF BG-CODE-DR-CR-CNSMPTN = 'C'                            
                 COMPUTE WS-HOLD-BG-AMT = WS-HOLD-BG-AMT * -1           
                 COMPUTE WS-HOLD-STATE  = WS-HOLD-STATE  * -1           
                 COMPUTE WS-HOLD-CITY   = WS-HOLD-CITY   * -1           
                 COMPUTE WS-HOLD-OTHER  = WS-HOLD-OTHER  * -1           
              END-IF                                                    
              MOVE ZERO                      TO WS-TOTAL-COMPONENT-AMT  
              PERFORM VARYING BC-INDX FROM 1 BY 1                       
                   UNTIL BC-INDX > WS-BC-MAX-ENTRY                      
                      OR WS-BC-COMPONENT-ID (BC-INDX) = SPACE           
                         ADD WS-BC-CALC-COMPONENT-AMT (BC-INDX)         
                                             TO WS-TOTAL-COMPONENT-AMT  
              END-PERFORM                                               
              COMPUTE WS-SPANMIN-AMT = WS-TOTAL-COMPONENT-AMT           
                       - (WS-HOLD-BG-AMT                                
                       - WS-HOLD-BASIC-FACILITY                         
                       - WS-HOLD-STATE                                  
                       - WS-HOLD-CITY                                   
                       - WS-HOLD-OTHER)                                 
              IF WS-SPANMIN-AMT > 0                                     
                 MOVE 'Y'                    TO WS-SPANMIN-SW           
                 MOVE 'ANNUAL MINIMUM CREDIT'                           
                                             TO RS-CHARGE-DESC          
                 MOVE 'A'                    TO RS-CONSUMPTION-TYPE     
                 MOVE WS-SPANMIN-AMT         TO RS-COMPUTED-CHARGE      
                 MOVE WS-BC-COMPONENT-KEY (BC-INDX)                     
                                             TO RS-COMPONENT-KEY        
                 PERFORM 2000A-MOVE-RESULT    THRU 2000A-EXIT           
                 PERFORM 8100C-INSERT-GTT-R3  THRU 8100C-EXIT           
                 INITIALIZE TDS-RETURN-FIELDS                           
              ELSE                                                      
                 IF WS-SPANMIN-AMT < 0                                  
                    MOVE 'Y'                 TO WS-SPANMIN-SW           
                    MOVE 'ANNUAL MINIMUM DEBIT'                         
                                             TO RS-CHARGE-DESC          
                    MOVE 'A'                 TO RS-CONSUMPTION-TYPE     
                    COMPUTE WS-SPANMIN-AMT = WS-SPANMIN-AMT * -1        
                    MOVE WS-SPANMIN-AMT      TO RS-COMPUTED-CHARGE      
                    MOVE WS-BC-COMPONENT-KEY (BC-INDX)                  
                                             TO RS-COMPONENT-KEY        
                    PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT           
                    PERFORM 8100C-INSERT-GTT-R3                         
                                              THRU 8100C-EXIT           
                    INITIALIZE TDS-RETURN-FIELDS                        
                 END-IF                                                 
              END-IF
           END-IF.                                                   
                                                                        
       6400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 6410-GET-BG-AMT                                                *        
      *                                                                *        
      *   RETRIEVE THE SPECIAL ANNUAL MINIMUM AMOUNT WHICH IS STORED   *        
      *   IN THE BG.                                                   *        
      *                                                                *        
      ******************************************************************        
       6410-GET-BG-AMT.                                                 
                                                                        
           EXEC SQL                                                     
              SELECT AMT_BILL_ITEM                                      
                INTO :BG-AMT-BILL-ITEM                                  
                FROM CSS_BILLING_DET WITH(READUNCOMMITTED)                      
               WHERE ACCOUNT_NO         = :WS-BC-ACCOUNT-NO-BG          
                 AND BILL_NO            = :WS-BC-BILL-NO-BG             
                 AND CODE_UTIL_TYPE     = :WS-BC-CODE-UTIL-TYPE-BG      
                 AND IC_NO              = :WS-BC-IC-NO-BG               
                 AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                           :WS-BC-BILL-ITEM-TIMESTMP-BG
              )  
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT AMT_BILL_ITEM                                              
MFA-TR*         INTO :BG-AMT-BILL-ITEM                                          
MFA-TR*         FROM CSS_BILLING_DET                                            
MFA-TR*        WHERE ACCOUNT_NO         = :WS-BC-ACCOUNT-NO-BG                  
MFA-TR*          AND BILL_NO            = :WS-BC-BILL-NO-BG                     
MFA-TR*          AND CODE_UTIL_TYPE     = :WS-BC-CODE-UTIL-TYPE-BG              
MFA-TR*          AND IC_NO              = :WS-BC-IC-NO-BG                       
MFA-TR*          AND BILL_ITEM_TIMESTMP = :WS-BC-BILL-ITEM-TIMESTMP-BG          
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
           IF WS-ACTIVE-RETURN-CODE EQUAL    TO SUCCESSFUL-CALL         
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '6410'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_BILLING_DET'         TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'BILL_NO'                 TO TABLE-ELEMENT-2         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-3         
              MOVE 'IC_NO'                   TO TABLE-ELEMENT-4         
              MOVE WS-BC-ACCOUNT-NO-BG       TO HOSTVAR-ELEMENT-1       
              MOVE WS-BC-BILL-NO-BG          TO HOSTVAR-ELEMENT-2       
              MOVE WS-BC-CODE-UTIL-TYPE-BG   TO HOSTVAR-ELEMENT-3       
              MOVE WS-BC-IC-NO-BG            TO HOSTVAR-ELEMENT-4       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT
           END-IF.           
                                                                        
       6410-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 6500-INTERRUPTIBLE.                                            *        
      *                                                                *        
      *   HANDLE INTERRUPTIBLE DEBITS AND CREDITS                      *        
      *                                                                *        
      ******************************************************************        
       6500-INTERRUPTIBLE.                                              
                                                                        
           MOVE SPACES                        TO WS-CNTRCT-START-DT.    
           MOVE WS-BC-REVENUE-MONTH-BG        TO WS-HOLD-REV-MONTH.     
           EXEC SQL                                                     
              SELECT CONTRACT_DATE                                      
                INTO :IP-CONTRACT-DATE                                  
                FROM CSS_INTERRUPT_ACCT WITH(READUNCOMMITTED)                   
               WHERE ACCOUNT_NO         = :WS-BC-ACCOUNT-NO-BG          
                 AND CODE_UTIL_TYPE     = :WS-BC-CODE-UTIL-TYPE-BG      
                 AND IC_NO              = :WS-BC-IC-NO-BG               
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CONTRACT_DATE                                              
MFA-TR*         INTO :IP-CONTRACT-DATE                                          
MFA-TR*         FROM CSS_INTERRUPT_ACCT                                         
MFA-TR*        WHERE ACCOUNT_NO         = :WS-BC-ACCOUNT-NO-BG                  
MFA-TR*          AND CODE_UTIL_TYPE     = :WS-BC-CODE-UTIL-TYPE-BG              
MFA-TR*          AND IC_NO              = :WS-BC-IC-NO-BG                       
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
           IF WS-ACTIVE-RETURN-CODE EQUAL    TO SUCCESSFUL-CALL         
              MOVE 'Y'                       TO WS-INTERRUPT-SW         
           ELSE                                                         
              MOVE 'N'                       TO WS-INTERRUPT-SW         
              IF WS-ACTIVE-RETURN-CODE EQUAL TO NOT-FOUND               
                     CONTINUE                                           
              ELSE                                                      
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE '6500'                 TO ACTIVE-PARAGRAPH        
                 MOVE 'SELECT'               TO ABEND-FUNCTION          
                 MOVE 'CSS_INTERRUPT_ACCT'   TO TABLE-1                 
                 MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1         
                 MOVE 'CODE_UTIL_TYPE'       TO TABLE-ELEMENT-2         
                 MOVE 'IC_NO'                TO TABLE-ELEMENT-3         
                 MOVE WS-BC-ACCOUNT-NO-BG    TO HOSTVAR-ELEMENT-1       
                 MOVE WS-BC-CODE-UTIL-TYPE-BG                           
                                             TO HOSTVAR-ELEMENT-2       
                 MOVE WS-BC-IC-NO-BG         TO HOSTVAR-ELEMENT-3       
                 PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT
              END-IF
           END-IF.           
                                                                        
                                                                        
           IF INTERRUPTIBLE                                             
              IF IP-CONTRACT-DATE < WS-BC-CALC-DATE OR                  
                 IP-CONTRACT-DATE = WS-BC-CALC-DATE                     
                 COMPUTE WS-INTERRUPT-AMT = WS-INTERRUPT-AMT            
                                 + WS-INTERRUPTIBLE-CREDITS             
              END-IF                                                    
           END-IF.                                                      
                                                                        
       6500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 6600-LOAD-FACTOR-AMOUNT.                                       *        
      *                                                                *        
      *   COMPUTE THE MONEY AMOUNT OF THE LOAD FACTOR ADJUSTMENT       *        
      *                                                                *        
      ******************************************************************        
       6600-LOAD-FACTOR-AMOUNT.                                         
                                                                        
           PERFORM VARYING BC-INDX2 FROM 1 BY 1                         
                   UNTIL BC-INDX2 > WS-BC-MAX-ENTRY                     
                      OR WS-BC-COMPONENT-ID (BC-INDX2) = SPACE          
              ADD WS-BC-NET-COMPONENT-AMT (BC-INDX2)                    
                                             TO WS-TOTAL-NET-CHARGES    
           END-PERFORM.                                                 
                                                                        
           COMPUTE WS-LOAD-FACTOR-AMT =                                 
                            BG-AMT-BILL-ITEM - WS-TOTAL-NET-CHARGES.    
                                                                        
       6600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      ** ERROR ROUTINE FOR COPYBOOK CPD4515                           **        
      ******************************************************************        
      *6999-ERROR-ROUTINE-CPD4515.                                              
      *                                                                         
      *    MOVE WS-CPD4515-RETURN-CODE       TO WS-RETURN-CODE-ERR.             
      *                                                                         
      *    EVALUATE WS-RETURN-CODE-ERR                                          
      *        WHEN 12                                                          
      *             MOVE 'NON003'            TO S5-MESSAGE-PARMS                
      *                                         S5-BUS-RULE-ID                  
      *        WHEN 9999                                                        
      *             MOVE 'NON002'            TO S5-MESSAGE-PARMS                
      *                                         S5-BUS-RULE-ID                  
      *        WHEN OTHER                                                       
      *             MOVE 'NON001'            TO S5-MESSAGE-PARMS                
      *                                         S5-BUS-RULE-ID                  
      *    END-EVALUATE.                                                        
      *                                                                         
      *    MOVE 0                            TO S5-RETURN-CODE                  
      *    MOVE 0                            TO S5-APPL-RETURN-CODE             
      *    MOVE WS-FAILED                    TO S5-BUS-RULE-RESULT-CD           
      *    IF S5-BUS-RULE-ID GREATER THAN SPACES                                
      *       PERFORM 7900-GET-RULE-XREF-ID   THRU 7900-EXIT                    
      *         MOVE SPACES                  TO S5-LINK-PARMS                   
      *         MOVE WS-BC-COMPONENT-KEY (BC-INDX)                              
      *                                      TO S5-COMPONENT-KEY                
      *    END-IF                                                               
      *    PERFORM 8100E-INSERT-GTT-R5        THRU 8100E-EXIT.                  
      *    PERFORM 9999-END-PROGRAM           THRU 9999-EXIT.                   
      *                                                                         
      *6999-CPD4515-EXIT.                                                       
      *    EXIT.                                                                
      *                                                                         
      ******************************************************************        
      * 7000-BUILD-RESULT.                                             *        
      *                                                                *        
      *   SEND THE RESULT SET BACK TO THE CALLER                       *        
      *                                                                *        
      ******************************************************************        
       7000-BUILD-RESULT.                                               
                                                                        
           PERFORM VARYING BC-INDX FROM 1 BY 1                          
                   UNTIL BC-INDX > WS-BC-MAX-ENTRY                      
                      OR WS-BC-COMPONENT-ID (BC-INDX) = SPACE           
              ADD WS-BC-CALC-COMPONENT-AMT (BC-INDX)                    
                                             TO WS-TOTAL-COMPONENTS-AMT 
              IF WS-BC-CONSUMPTION-TYPE (BC-INDX)  = 'E'                
                  OR WS-BC-CONSUMPTION-TYPE (BC-INDX) = 'J'             
                  OR WS-BC-CONSUMPTION-TYPE (BC-INDX) = 'Q'             
                    ADD WS-BC-CALC-COMPONENT-AMT (BC-INDX)              
                                             TO WS-TOTAL-DEMAND-CHARGES 
                    COMPUTE WS-DEMAND-CHRGS-CREDITS =                   
                       WS-DEMAND-CHRGS-CREDITS +                        
                          (WS-BC-NET-COMPONENT-AMT (BC-INDX) -          
                            WS-BC-CALC-COMPONENT-AMT(BC-INDX))          
              END-IF                                                    
              IF WS-BC-CIG-CUSTOMER-IND-BG = 'Y'                        
                 MOVE 'N'                    TO RS-CODE-SEASON          
                 MOVE WS-BC-CODE-UTIL-TYPE-BG TO RS-CODE-UTIL-TYPE      
                 MOVE WS-BC-RATE-PLAN-NO-BG  TO RS-RATE-PLAN-NO         
                 MOVE WS-BC-REVENUE-MONTH-BG TO WS-CIG-REV-MONTH        
                 MOVE WS-CIG-REV-MONTH (5:2) TO WS-RS-MM                
                 MOVE '01'                   TO WS-RS-DD                
                 MOVE WS-RS-DATE-FROM        TO WS-CIG-DATE-FROM        
                 MOVE WS-CIG-DATE-FROM       TO RS-DATE-FROM            
                 PERFORM 8661-GET-SEASONAL-CODE THRU 8661-EXIT          
              END-IF                                                    
              MOVE 'N'                       TO WS-PROCESS-BILL-CALC    
              IF WS-BC-CIG-CUSTOMER-IND-BG = 'Y'          AND           
                 WS-BC-NET-COMPONENT-AMT (BC-INDX) = ZERO AND           
                 WS-BC-NET-UNITS (BC-INDX) = ZERO         AND           
                 WS-BC-COMPONENT-ID(BC-INDX) <= '20'      AND           
                 WS-BC-CIG-TRNSP-DET-BG = 'N'             AND           
                 WS-BC-TOTAL-WNA-AMT (BC-INDX) = 0        AND           
                 ENERGY-COMPONENT (BC-INDX)               AND           
                 (WS-BC-CODE-SEASON (BC-INDX) = RS-CODE-SEASON  OR      
                 WS-BC-CODE-SEASON (BC-INDX) = WS-BOTH)   AND           
                 WS-BC-AMT-NET-RATE(BC-INDX, 1) > 0                     
                 MOVE 'Y'                    TO WS-PROCESS-BILL-CALC    
              END-IF                                                    
              IF WS-BC-NET-COMPONENT-AMT (BC-INDX) NOT = ZERO           
                    OR WS-BC-NET-UNITS (BC-INDX) NOT = ZERO             
                    OR WS-PROCESS-BILL-CALC = 'Y'                       
                 PERFORM 7200-DETAIL THRU 7200-EXIT                     
                 PERFORM VARYING BA-INDX FROM 1 BY 1                    
                         UNTIL BA-INDX > 200                            
                         OR WS-BC-FACTOR-ID (BA-INDX) NOT > SPACE       
                    IF WS-BC-FACTOR-ID (BA-INDX) = 'SPMNTMIN'           
                       MOVE 'Y'              TO WS-SPMNTMIN-SW          
                    END-IF                                              
                    IF BC-INDX = 1                                      
                       IF WS-BC-FACTOR-ID (BA-INDX) = 'LFADJUST'        
                          PERFORM 6600-LOAD-FACTOR-AMOUNT THRU 6600-EXIT
                          MOVE WS-LOAD-FACTOR-AMT                       
                                             TO                         
                               WS-BC-AMT-ADJUSTMENT (BA-INDX)           
                          ADD WS-LOAD-FACTOR-AMT                        
                                             TO WS-BC-AMT-BILL-ITEM-BG  
                       END-IF                                           
                    END-IF                                              
                    IF WS-BC-FACTOR-COMPONENT (BA-INDX) =               
                          WS-BC-COMPONENT-KEY (BC-INDX)                 
                       EVALUATE TRUE                                    
                          WHEN (ADD-TO-NET-UNITS (BA-INDX)              
                             AND WS-BC-SPECIAL-CALC-CD (BA-INDX)        
                                 NOT = 'XX')                            
                          WHEN APPLY-TO-SUBTRACTIVE-MTR (BA-INDX)       
                          WHEN SUB-FROM-NET-UNITS (BA-INDX)             
                             PERFORM 7300-UNITS-INCLUDE                 
                                              THRU 7300-EXIT            
                          WHEN REPL-NET-UNITS (BA-INDX)                 
                             PERFORM 7400-UNITS-USE                     
                                              THRU 7400-EXIT            
                          WHEN OTHER                                    
                             CONTINUE                                   
                       END-EVALUATE                                     
                    END-IF                                              
                 END-PERFORM                                            
                 PERFORM VARYING BA-INDX FROM 1 BY 1                    
                         UNTIL BA-INDX > 200                            
                         OR WS-BC-FACTOR-ID (BA-INDX) NOT > SPACE       
                    IF WS-BC-FACTOR-COMPONENT (BA-INDX) =               
                          WS-BC-COMPONENT-KEY (BC-INDX)                 
                      IF WS-BC-FCT-RATE-VERSION (BA-INDX) = 1           
                         OR WS-BC-FACTOR-ID (BA-INDX) = 'RTPROPCT'      
                         OR WS-BC-FACTOR-ID (BA-INDX) = 'BFACCHRG'      
                         OR (ADD-TO-COMPONENT-AMT (BA-INDX) AND         
                             PERCENTAGE (BA-INDX)           AND         
                             BASE-RATE (BA-INDX))                       
                         OR ADD-TO-NET-RATE (BA-INDX)                   
                         OR REPL-NET-RATE (BA-INDX)                     
                         OR SUB-FROM-NET-RATE (BA-INDX)                 
                         OR MAX-FROM-NET-RATE (BA-INDX)                 
                         EVALUATE TRUE                                  
                            WHEN ADD-TO-COMPONENT-AMT (BA-INDX)         
                            WHEN SUB-FROM-COMPONENT-AMT (BA-INDX)       
                               PERFORM 7500-AMT-INCLUDES                
                                              THRU 7500-EXIT            
                            WHEN REPL-COMPONENT-AMT (BA-INDX)           
                               PERFORM 7600-AMT-USES                    
                                              THRU 7600-EXIT            
                            WHEN CALC-ONLY (BA-INDX)                    
                              OR TAX-ONLY (BA-INDX)                     
                               PERFORM 7700-AMT-FYI                     
                                              THRU 7700-EXIT            
                            WHEN OTHER                                  
                               CONTINUE                                 
                         END-EVALUATE                                   
                       END-IF                                           
                    END-IF                                              
                 END-PERFORM                                            
                 INITIALIZE TDS-RETURN-FIELDS                           
                 PERFORM VARYING BA-INDX FROM 1 BY 1                    
                         UNTIL BA-INDX > 200                            
                            OR WS-BC-FACTOR-ID (BA-INDX) NOT > SPACE    
                    IF WS-BC-FACTOR-COMPONENT (BA-INDX) =               
                          WS-BC-COMPONENT-KEY (BC-INDX)                 
                       EVALUATE TRUE                                    
                          WHEN ADD-TO-NET-RATE (BA-INDX)                
                          WHEN REPL-NET-RATE (BA-INDX)                  
                          WHEN SUB-FROM-NET-RATE (BA-INDX)              
                          WHEN WNA-UNITS (BA-INDX)                      
                             PERFORM 7800-RATE-INCLUDES                 
                                              THRU 7800-EXIT            
                          WHEN OTHER                                    
                             CONTINUE                                   
                       END-EVALUATE                                     
                    END-IF                                              
                 END-PERFORM                                            
              END-IF                                                    
           END-PERFORM.                                                 
           PERFORM VARYING BA-INDX FROM 1 BY 1                          
                 UNTIL BA-INDX > 200                                    
                     OR WS-BC-FACTOR-ID (BA-INDX) NOT > SPACE           
              IF WS-BC-FCT-RATE-VERSION (BA-INDX) = 1                   
                 MOVE WS-BC-FACTOR-ID (BA-INDX) TO WS-HOLD-FACTOR-ID    
                 IF WS-HOLD-FACTOR-ID (1:8) = 'INTRCRED'                
                    OR WS-HOLD-FACTOR-ID (1:8) = 'ENERLINK'             
                     SUBTRACT WS-BC-FACTOR (BA-INDX)                    
                        FROM WS-INTERRUPTIBLE-CREDITS                   
                 END-IF                                                 
              END-IF                                                    
           END-PERFORM.                                                 
                                                                        
                                                                        
           IF WS-BC-RATE-PLAN-NO-BG = '023' OR '024'                    
              PERFORM 6500-INTERRUPTIBLE      THRU 6500-EXIT            
           ELSE                                                         
              IF WS-BC-CIG-CUSTOMER-IND-BG = 'Y'                        
                 CONTINUE                                               
              ELSE                                                      
                 PERFORM 6400-SPANNMIN        THRU 6400-EXIT            
              END-IF                                                    
           END-IF.                                                      
           INITIALIZE TDS-RETURN-FIELDS.                                
           MOVE WS-BC-NO-CNSMPTN-DAYS        TO RS-NO-OF-DAYS.          
           IF (WS-BC-REVENUE-MONTH-BG > 0)  OR                          
              (WS-BC-REV-MTH-ORIG-BILL-BG > 0 )                         
              IF WS-BC-REVENUE-MONTH-BG > 0                             
                 MOVE WS-BC-REVENUE-MONTH-BG TO RS-REV-MONTH            
              ELSE                                                      
                 MOVE WS-BC-REV-MTH-ORIG-BILL-BG                        
                                             TO RS-REV-MONTH            
              END-IF                                                    
           ELSE                                                         
                   MOVE SPACES               TO RS-REV-MONTH            
           END-IF                                                       
           IF WS-BC-RATE-PLAN-NO-BG NOT EQUAL TO SPACES                 
              MOVE WS-BC-CODE-UTIL-TYPE-BG   TO RD-CODE-UTIL-TYPE       
              MOVE WS-BC-RATE-PLAN-NO-BG     TO RD-RATE-PLAN-NO         
                                                RS-RATE-PLAN            
              PERFORM 8662-GET-RATE-PLAN-DESC THRU 8662-EXIT            
              MOVE RD-RATE-DESC              TO RS-RATE-DESC            
                                                                        
              IF SEB-DATABASE                                           
      *          IF WS-AGL-CHARGES = 0                                          
      *          PERFORM 8666-AGL-DEBIT       THRU 8666-EXIT                    
      *          PERFORM 8667-AGL-CREDIT      THRU 8667-EXIT                    
      *          COMPUTE WS-AGL-CHARGES = WS-AGL-DEBIT-CHARGES -                
      *                                   WS-AGL-CREDIT-CHARGES                 
      *          END-IF                                                         
                 IF WS-PRICE-PER-THERM = 0                              
                 PERFORM 8668-PRICE-PER-THERM THRU 8668-EXIT            
                 ELSE                                                   
                    MOVE WS-PRICE-PER-THERM  TO WS-UNIT-PRICE-AMT       
                 END-IF                                                 
                                                                        
                 IF WS-BC-RT-PKG-OPT-SEQ-NO-BG > 0                      
                                                                        
                    MOVE WS-BC-ACCOUNT-NO-BG                            
                                             TO DF-ACCOUNT-NO           
                    MOVE WS-BC-CODE-UTIL-TYPE-BG                        
                                             TO DF-CODE-UTIL-TYPE       
                    MOVE WS-BC-IC-NO-BG                                 
                                             TO DF-IC-NO                
                    MOVE WS-BC-RT-PKG-OPT-SEQ-NO-BG                     
                                             TO DF-RT-PKG-OPT-SEQ-NO    
                                                                        
                    PERFORM 7540-GET-OPTION-DESC                        
                       THRU 7540-EXIT                                   
                                                                        
                    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL          
                       MOVE FI-OPT-DESC-INT  TO RS-RATE-DESC            
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
                                                                        
           END-IF                                                       
           IF WS-BC-CODE-CURTAIL-PRTY-BG IS NUMERIC                     
              MOVE WS-BC-CODE-CURTAIL-PRTY-BG TO Z4-CODE-CURTAIL-PRTY   
              MOVE AT-COMPANY-NO             TO Z4-COMPANY-NO           
              PERFORM 8663-GET-SVC-CAT-DESC THRU 8663-EXIT              
              MOVE Z4-PRTY-SVC-CAT-CD        TO RS-SVC-CAT              
           END-IF                                                       
           MOVE WS-BC-WNA-FACTOR-BG          TO RS-WNA-FACTOR.          
           MOVE WS-BC-BTU-FACTOR-BG          TO RS-BTU-FACTOR.          
           MOVE WS-BC-AMT-STATE-TAX-BG       TO RS-STATE-TAX.           
           MOVE WS-BC-AMT-CITY-TAX-BG        TO RS-CITY-TAX.            
           IF BG-CODE-STAT-TAX-XMT > SPACES                             
              MOVE SPACES                    TO F1-PARTIAL-EXEMPT-CD    
              MOVE BG-CODE-STAT-TAX-XMT      TO F1-TAX-EXEMPT-CODE      
              PERFORM 7870-SEL-TAX-XMPT-CD    THRU 7870-EXIT            
              IF F1-PARTIAL-EXEMPT-CD > SPACES                          
                 MOVE 'Y'                    TO RS-PARTIAL-XMPT-FL      
              END-IF                                                    
           END-IF                                                       
           IF WS-BC-AMT-STATE-TAX-BG > 0                                
                                    AND AT-COMPANY-NO NOT EQUAL '26'    
              MOVE BG-STATE-TAX-RATE         TO RS-STATE-TAX-RATE       
           END-IF                                                       
           IF WS-BC-AMT-CITY-TAX-BG > 0                                 
              MOVE BG-CITY-TAX-RATE          TO RS-CITY-TAX-RATE        
           END-IF                                                       
           MOVE WS-BC-AMT-OTHER-TAX-BG       TO RS-OTHER-TAX.           
           IF MONTHLY-MINIMUM-CHARGED                                   
              MOVE ZERO                      TO WS-USAGE-CHRGS-CREDITS  
           ELSE                                                         
              IF ANNUAL-MINIMUM-APPLIED                                 
                 MOVE ZERO                   TO WS-USAGE-CHRGS-CREDITS  
                    COMPUTE WS-BC-AMT-BILL-ITEM-BG =                    
                         BG-AMT-BILL-ITEM - WS-BC-AMT-STATE-TAX-BG      
                                          - WS-BC-AMT-CITY-TAX-BG       
                                          - WS-BC-AMT-OTHER-TAX-BG      
              ELSE                                                      
                 COMPUTE WS-BC-AMT-BILL-ITEM-BG =                       
                         WS-BC-AMT-BILL-ITEM-BG                         
                    - WS-TOTAL-DEMAND-CHARGES                           
                    - WS-DEMAND-CHRGS-CREDITS                           
                    - WS-USAGE-CHRGS-CREDITS                            
              END-IF                                                    
           END-IF.                                                      
           IF BG-CODE-DR-CR-CNSMPTN = 'C'                               
              COMPUTE WS-BC-AMT-BILL-ITEM-BG   =                        
                      WS-BC-AMT-BILL-ITEM-BG   * -1                     
              COMPUTE WS-TOTAL-DEMAND-CHARGES  =                        
                      WS-TOTAL-DEMAND-CHARGES  * -1                     
              COMPUTE WS-DEMAND-CHRGS-CREDITS  =                        
                      WS-DEMAND-CHRGS-CREDITS  * -1                     
              COMPUTE WS-USAGE-CHRGS-CREDITS   =                        
                      WS-USAGE-CHRGS-CREDITS   * -1                     
              COMPUTE WS-BC-AMT-STATE-TAX-BG   =                        
                      WS-BC-AMT-STATE-TAX-BG   * -1                     
              COMPUTE WS-BC-AMT-CITY-TAX-BG    =                        
                      WS-BC-AMT-CITY-TAX-BG    * -1                     
           END-IF.                                                      
           MOVE WS-BC-AMT-BILL-ITEM-BG       TO RS-TOTAL-USAGE-CHARGES. 
                                                                        
           IF SEB-DATABASE                                              
              COMPUTE RS-USAGE-CHARGES = WS-BC-AMT-BILL-ITEM-BG -       
                                         WS-OTHR-CHARGES                
           ELSE                                                         
              MOVE WS-BC-AMT-BILL-ITEM-BG    TO RS-USAGE-CHARGES        
           END-IF.                                                      
                                                                        
           MOVE WS-TOTAL-DEMAND-CHARGES      TO RS-TOTAL-DEMAND-CHARGES.
           MOVE WS-DEMAND-CHRGS-CREDITS      TO RS-DEMAND-CHRGS-CREDITS.
           MOVE WS-USAGE-CHRGS-CREDITS       TO RS-USAGE-CHRGS-CREDITS. 
           MOVE WS-BASIC-FCLTY-CHRG          TO RS-BASIC-FCLTY-CHRG.    
           MOVE WS-TOTAL-NET-UNITS           TO RS-TOTAL-NET-UNITS.     
           MOVE WS-UNIT-PRICE-AMT            TO RS-UNIT-PRICE-AMT.      
           MOVE WS-AGL-CHARGES               TO RS-AGL-CHARGES.         
           MOVE WS-PRORTD-BILL-FL            TO RS-PRORTD-BILL-FL.      
           MOVE WS-PRORTD-BY-DAYS-FL         TO RS-PRORTD-BY-DAYS-FL.   
           MOVE 'X'                          TO RS-CONSUMPTION-TYPE.    
           MOVE WS-BC-DATE-READ-CX (1)       TO RS-READ-DATE.           
           COMPUTE RS-TOTAL-BILL-AMOUNT =       WS-BC-AMT-BILL-ITEM-BG  
                                              + WS-TOTAL-DEMAND-CHARGES 
                                              + WS-DEMAND-CHRGS-CREDITS 
                                              + WS-USAGE-CHRGS-CREDITS  
                                              + WS-BC-AMT-STATE-TAX-BG  
                                              + WS-BC-AMT-CITY-TAX-BG.  
           PERFORM 2000A-MOVE-RESULT          THRU 2000A-EXIT.          
           PERFORM 8100A-INSERT-GTT-R1        THRU 8100A-EXIT.          
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7200-DETAIL.                                                  *         
      *                                                               *         
      *                                                               *         
      *                                                               *         
      *****************************************************************         
       7200-DETAIL.                                                     
                                                                        
           IF WS-BC-COMPONENT-ID (BC-INDX) (1:1) = 'U'                  
              PERFORM 8300-GET-UM-TEXT THRU 8300-EXIT                   
              MOVE L9-UM-EQUIP-SHRT-DESC     TO RS-CHARGE-DESC          
              EVALUATE WS-BC-COMPONENT-ID (BC-INDX)                     
                 WHEN '90'                                              
                 WHEN '91'                                              
                    PERFORM 7210-GET-RATE     THRU 7210-EXIT            
                 WHEN '92'                                              
                 WHEN '93'                                              
                    GO                       TO 7200-EXIT               
              END-EVALUATE                                              
              ADD WS-BC-NET-UNITS (BC-INDX)  TO WS-TOTAL-NET-UNITS      
           END-IF.                                                      
                                                                        
           IF WS-BC-SEAS-PRORATE-PCT (BC-INDX) NOT = ZERO               
              MOVE WS-FMT-PERCENT-TEXT       TO RS-CHARGE-DESC          
              MOVE WS-BC-SEAS-PRORATE-PCT (BC-INDX)                     
                                             TO WS-FMT-PERCENT          
                                                RS-SEAS-PRORATE-PCT     
           END-IF.                                                      
                                                                        
           MOVE WS-BC-READ-UNITS (BC-INDX)   TO RS-UNITS-READ           
           MOVE WS-BC-NET-UNITS (BC-INDX)    TO RS-NET-UNITS            
           MOVE '  1'                        TO RS-BLOCK-NUMBER         
           MOVE 1                            TO RS-BLOCK-NO             
           MOVE WS-BC-BLOCK-SIZE (BC-INDX 1) TO RS-BLOCK-SIZE           
           MOVE WS-BC-UNITS-BILLED (BC-INDX 1)                          
                                             TO RS-UNITS-BILLED         
           MOVE WS-BC-PRICE-TYPE-CD (BC-INDX 1)                         
                                             TO RS-PRICE-TYPE-CD        
           MOVE WS-BC-AMT-BASE-RATE (BC-INDX 1)                         
                                             TO RS-BASE-RATE            
           MOVE WS-BC-AMT-NET-RATE (BC-INDX 1)                          
                                             TO RS-NET-RATE             
           MOVE WS-BC-AMT-BLOCK (BC-INDX 1)  TO RS-COMPUTED-CHARGE      
           MOVE WS-BC-CONSUMPTION-TYPE (BC-INDX)                        
                                             TO RS-CONSUMPTION-TYPE     
           MOVE WS-BC-REGISTER-TYPE (BC-INDX)                           
                                             TO RS-REGISTER-TYPE        
           MOVE WS-BC-RATE-VERSION (BC-INDX) TO RS-RATE-VERSION         
           MOVE WS-BC-CODE-TOU (BC-INDX)     TO RS-CODE-TOU             
           MOVE WS-BC-CODE-SEASON (BC-INDX)  TO RS-CODE-SN              
           MOVE WS-BC-COMPONENT-ID (BC-INDX) TO RS-COMPONENT-ID         
           MOVE WS-BC-COMPONENT-KEY (BC-INDX)                           
                                             TO RS-COMPONENT-KEY        
      *    ADD  RS-UNITS-BILLED              TO WS-TOTAL-NET-UNITS.             
                                                                        
           IF RS-COMPONENT-ID > SPACES                                  
              ADD RS-NET-RATE                TO WS-PRICE-PER-THERM      
           END-IF.                                                      
                                                                        
           PERFORM 2000A-MOVE-RESULT          THRU 2000A-EXIT           
           PERFORM 8100C-INSERT-GTT-R3        THRU 8100C-EXIT           
           INITIALIZE TDS-RETURN-FIELDS.                                
                                                                        
           PERFORM VARYING BLK-INDX FROM 2 BY 1                         
             UNTIL BLK-INDX > 9                                         
                OR BLK-INDX > WS-BC-BLOCKS-USED (BC-INDX)               
              MOVE WS-BC-PRICE-TYPE-CD (BC-INDX 1)                      
                                             TO RS-PRICE-TYPE-CD        
              SET WS-BLOCK-NO                TO BLK-INDX                
              IF WS-BC-FIRST-WNA-BLOCK (BC-INDX) <= BLK-INDX            
                        AND > ZERO                                      
                 MOVE '**'                   TO RS-BLOCK-NUMBER (1:2)   
              ELSE                                                      
                 MOVE SPACES                 TO RS-BLOCK-NUMBER (1:2)   
              END-IF                                                    
              MOVE WS-BLOCK-NO               TO RS-BLOCK-NUMBER (3:1)   
              MOVE WS-BLOCK-NO               TO RS-BLOCK-NO             
              MOVE WS-BC-BLOCK-SIZE (BC-INDX BLK-INDX)                  
                                             TO RS-BLOCK-SIZE           
              MOVE WS-BC-UNITS-BILLED (BC-INDX BLK-INDX)                
                                             TO RS-UNITS-BILLED         
              MOVE WS-BC-AMT-BASE-RATE (BC-INDX BLK-INDX)               
                                             TO RS-BASE-RATE            
              MOVE WS-BC-AMT-NET-RATE (BC-INDX BLK-INDX)                
                                             TO RS-NET-RATE             
              MOVE WS-BC-AMT-BLOCK (BC-INDX BLK-INDX)                   
                                             TO RS-COMPUTED-CHARGE      
              MOVE WS-BC-REGISTER-TYPE (BC-INDX)                        
                                             TO RS-REGISTER-TYPE        
              MOVE WS-BC-RATE-VERSION (BC-INDX)                         
                                             TO RS-RATE-VERSION         
              MOVE WS-BC-CODE-TOU (BC-INDX)  TO RS-CODE-TOU             
              MOVE WS-BC-CONSUMPTION-TYPE (BC-INDX)                     
                                             TO RS-CONSUMPTION-TYPE     
              MOVE WS-BC-COMPONENT-KEY (BC-INDX)                        
                                             TO RS-COMPONENT-KEY        
              PERFORM 2000A-MOVE-RESULT    THRU 2000A-EXIT              
              PERFORM 8100C-INSERT-GTT-R3 THRU 8100C-EXIT               
              INITIALIZE TDS-RETURN-FIELDS                              
           END-PERFORM.                                                 
                                                                        
           IF WS-BC-NET-UNIT-SEL-RSN (BC-INDX) NOT = 'A' AND SPACE      
              EVALUATE WS-BC-NET-UNIT-SEL-RSN (BC-INDX)                 
                 WHEN 'B'                                               
                    MOVE 'BCNSMPT002'        TO S5-BUS-RULE-ID          
                 WHEN 'C'                                               
                    MOVE 'BCNSMPT003'        TO S5-BUS-RULE-ID          
                 WHEN 'D'                                               
                    MOVE 'BCNSMPT001'        TO S5-BUS-RULE-ID          
                 WHEN 'E'                                               
                    MOVE 'BCNSMPT004'        TO S5-BUS-RULE-ID          
                 WHEN 'F'                                               
                    MOVE 'BCNSMPT005'        TO S5-BUS-RULE-ID          
                 WHEN 'G'                                               
                    MOVE 'BCNSMPT006'        TO S5-BUS-RULE-ID          
                 WHEN 'H'                                               
                    MOVE 'BCNSMPT007'        TO S5-BUS-RULE-ID          
                 WHEN 'I'                                               
                    MOVE 'BCNSMPT008'        TO S5-BUS-RULE-ID          
                 WHEN 'J'                                               
                    MOVE 'BCNSMPT009'        TO S5-BUS-RULE-ID          
             END-EVALUATE                                               
             MOVE 0                          TO S5-RETURN-CODE          
             MOVE 0                          TO S5-APPL-RETURN-CODE     
             MOVE WS-PASSED                  TO S5-BUS-RULE-RESULT-CD   
             IF S5-BUS-RULE-ID GREATER THAN SPACES                      
                PERFORM 7900-GET-RULE-XREF-ID                           
                                              THRU 7900-EXIT            
                MOVE WS-BC-NET-UNIT-SEL-RSN (BC-INDX)                   
                                             TO S5-MESSAGE-PARMS        
                MOVE SPACES                  TO S5-LINK-PARMS           
                MOVE WS-BC-COMPONENT-KEY (BC-INDX)                      
                                             TO S5-COMPONENT-KEY        
             END-IF                                                     
             PERFORM 8100E-INSERT-GTT-R5      THRU 8100E-EXIT           
             INITIALIZE TDS-RETURN-FIELDS                               
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7210-GET-RATE                                                 *         
      * SPIN THRU ADJUSTMENT ROWS AND OBTAIN THE RTP MARGIN RATE WHICH*         
      * WILL BE MULTIPLIED BY THE OVER/UNDER BASELINE UNITS TO COMPUTE*         
      * THE BLOCK CHARGE.                                             *         
      *****************************************************************         
       7210-GET-RATE.                                                   
                                                                        
           PERFORM VARYING BA-INDX FROM 1 BY 1                          
              UNTIL BA-INDX > 200                                       
                OR WS-BC-FACTOR-ID (BA-INDX) NOT > SPACE                
                   IF WS-BC-FACTOR-COMPONENT (BA-INDX) =                
                          WS-BC-COMPONENT-KEY (BC-INDX)                 
                      IF WS-BC-FACTOR-ID (BA-INDX) = '&RTP_MRG'         
                         COMPUTE WS-WORK-FACTOR =                       
                               (WS-BC-FACTOR (BA-INDX) / 1000000)       
                         COMPUTE WS-BC-AMT-BLOCK (BC-INDX 1) =          
                            WS-BC-UNITS-BILLED (BC-INDX 1) *            
                               WS-WORK-FACTOR                           
                      END-IF                                            
                   END-IF                                               
           END-PERFORM.                                                 
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7300-UNITS-INCLUDE                                            *         
      *                                                               *         
      *                                                               *         
      *                                                               *         
      *****************************************************************         
       7300-UNITS-INCLUDE.                                              
                                                                        
           EVALUATE WS-BC-FACTOR-ID (BA-INDX)                           
              WHEN '&PFPCT'                                             
              WHEN '&FREEDEM'                                           
              WHEN '&FREEKWH'                                           
                 MOVE WS-BC-FACTOR-ID (BA-INDX)                         
                                             TO RS-FACTOR-ID            
              WHEN OTHER                                                
                 PERFORM 8400-GET-FACTOR-TEXT THRU 8400-EXIT            
                 MOVE SF-FACTOR-DESC         TO RS-FACTOR-DESC          
                 MOVE SF-FACTOR-TYPE         TO RS-FACTOR-TYPE          
                 MOVE SF-ADJUST-ELEMENT      TO RS-ADJUST-ELEMENT       
                 MOVE SF-CALC-TYPE-CD        TO RS-CALC-TYPE-CD         
           END-EVALUATE.                                                
                                                                        
           IF (ADD-TO-NET-UNITS (BA-INDX) OR                            
               APPLY-TO-SUBTRACTIVE-MTR (BA-INDX))                      
           AND READ-UNITS (BA-INDX)                                     
              MOVE WS-BC-ADJ-UNITS (BA-INDX) TO RS-NET-UNITS            
           ELSE                                                         
              MOVE WS-BC-FACTOR (BA-INDX)    TO RS-NET-UNITS            
           END-IF.                                                      
                                                                        
      *    ADD  RS-NET-UNITS                 TO WS-TOTAL-NET-UNITS.             
           MOVE WS-BC-FCT-CNSMPT-TYPE (BA-INDX)                         
                                             TO RS-CONSUMPTION-TYPE.    
           MOVE WS-BC-FCT-REGISTER-TYPE (BA-INDX)                       
                                             TO RS-REGISTER-TYPE.       
           MOVE WS-BC-FCT-RATE-VERSION (BA-INDX)                        
                                             TO RS-RATE-VERSION.        
           MOVE WS-BC-CODE-ADJUST-TYPE (BA-INDX)                        
                                             TO RS-CODE-ADJUST-TYPE.    
           MOVE WS-BC-FACTOR-COMPONENT (BA-INDX)                        
                                             TO RS-COMPONENT-KEY.       
                                                                        
           PERFORM 2000A-MOVE-RESULT          THRU 2000A-EXIT.          
           PERFORM 8100B-INSERT-GTT-R2        THRU 8100B-EXIT.          
           INITIALIZE TDS-RETURN-FIELDS.                                
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7400-UNITS-USE                                                *         
      *                                                               *         
      *                                                               *         
      *                                                               *         
      *****************************************************************         
       7400-UNITS-USE.                                                  
                                                                        
           MOVE WS-BC-FACTOR-ID (BA-INDX)    TO RS-FACTOR-ID            
           MOVE WS-BC-FCT-CNSMPT-TYPE (BA-INDX)                         
                                             TO RS-CONSUMPTION-TYPE     
           MOVE WS-BC-FCT-REGISTER-TYPE (BA-INDX)                       
                                             TO RS-REGISTER-TYPE        
           MOVE WS-BC-FCT-RATE-VERSION (BA-INDX)                        
                                             TO RS-RATE-VERSION         
           MOVE WS-BC-CODE-ADJUST-TYPE (BA-INDX)                        
                                             TO RS-CODE-ADJUST-TYPE     
           MOVE WS-BC-FACTOR-COMPONENT (BA-INDX)                        
                                             TO RS-COMPONENT-KEY        
           PERFORM 8400-GET-FACTOR-TEXT       THRU 8400-EXIT            
PRJ637     IF WS-BC-FACTOR-ID (BA-INDX) = 'BTUFCTR'                     
PRJ637        MOVE WS-BC-FACTOR (BA-INDX)    TO RS-NET-RATE             
PRJ637     END-IF                                                       
      *    EVALUATE WS-BC-FACTOR-ID (BA-INDX)                                   
      *       WHEN 'BTUFCTR'                                                    
                 MOVE SF-FACTOR-DESC         TO RS-FACTOR-DESC          
                 MOVE SF-FACTOR-TYPE         TO RS-FACTOR-TYPE          
                 MOVE SF-ADJUST-ELEMENT      TO RS-ADJUST-ELEMENT       
                 MOVE SF-CALC-TYPE-CD        TO RS-CALC-TYPE-CD         
      *          MOVE WS-BC-FACTOR (BA-INDX) TO RS-BASE-RATE                    
                 MOVE SPACE                  TO RS-PRICE-TYPE-CD        
      *          PERFORM 2000A-MOVE-RESULT    THRU 2000A-EXIT                   
      *          PERFORM 8100B-INSERT-GTT-R2  THRU 8100B-EXIT                   
      *       WHEN OTHER                                                        
      *          MOVE SF-FACTOR-DESC         TO RS-CHARGE-DESC                  
PRJ821           MOVE WS-BC-FACTOR (BA-INDX) TO RS-UNITS-BILLED         
      *          ADD  RS-NET-UNITS           TO WS-TOTAL-NET-UNITS              
                 PERFORM 2000A-MOVE-RESULT    THRU 2000A-EXIT           
                 PERFORM 8100B-INSERT-GTT-R2  THRU 8100B-EXIT           
      *    END-EVALUATE.                                                        
                                                                        
           INITIALIZE TDS-RETURN-FIELDS.                                
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * 7500-AMT-INCLUDES.                                            *         
      *                                                               *         
      *                                                               *         
      *                                                               *         
      *****************************************************************         
       7500-AMT-INCLUDES.                                               
                                                                        
           IF ADD-TO-COMPONENT-AMT    (BA-INDX)        AND              
              PERCENTAGE              (BA-INDX)        AND              
              BASE-RATE               (BA-INDX)        AND              
              WS-BC-SPCL-GROUP-CD     (BA-INDX) = 'GN' AND              
              WS-BC-ADJ-UNITS         (BA-INDX) = 0    AND              
              WS-BC-FCTR-ELEM-APPL-CD (BA-INDX) = 'E'                   
              GO                             TO 7500-EXIT               
           END-IF                                                       
                                                                        
           MOVE WS-BC-FACTOR-ID (BA-INDX)    TO RS-FACTOR-ID            
           MOVE WS-BC-FACTOR (BA-INDX)       TO RS-NET-RATE             
           MOVE WS-BC-FACTOR-COMPONENT (BA-INDX)                        
                                             TO RS-COMPONENT-KEY        
           MOVE WS-BC-SPCL-GROUP-CD    (BA-INDX)                        
                                             TO RS-SPCL-GRP-CD          
           MOVE WS-BC-AMT-ADJUSTMENT   (BA-INDX)                        
                                             TO RS-COMPUTED-CHARGE      
           IF (WS-BC-FACTOR-ID (BA-INDX) = 'TRNSPURCH' OR               
               WS-BC-FACTOR-ID (BA-INDX) = 'COMPADJ'   OR               
               WS-BC-FACTOR-ID (BA-INDX) = 'RTPCURTCR' OR               
               APPLY-TOTAL-AGL (BA-INDX))              AND              
               RS-COMPUTED-CHARGE > 0                                   
              COMPUTE RS-COMPUTED-CHARGE =  RS-COMPUTED-CHARGE  * -1    
           END-IF.                                                      
                                                                        
           IF WS-BC-ADJ-UNITS (BA-INDX) > ZERO                          
              MOVE WS-BC-ADJ-UNITS (BA-INDX) TO RS-UNITS-BILLED         
           END-IF.                                                      
                                                                        
           IF RS-SPCL-GRP-CD = 'AP' OR                                  
              RS-SPCL-GRP-CD = 'MT'                                     
              ADD RS-COMPUTED-CHARGE         TO WS-AGL-CHARGES          
           END-IF.                                                      
                                                                        
           PERFORM 8400-GET-FACTOR-TEXT       THRU 8400-EXIT            
           EVALUATE WS-BC-FACTOR-ID (BA-INDX) (1:8)                     
              WHEN 'BFACCHRG'                                           
                 ADD WS-BC-AMT-ADJUSTMENT (BA-INDX)                     
                                             TO WS-USAGE-CHRGS-CREDITS  
                                                WS-HOLD-BASIC-FACILITY  
                                                WS-BASIC-FCLTY-CHRG     
                 MOVE WS-BC-FCT-CNSMPT-TYPE (BA-INDX)                   
                                             TO RS-CONSUMPTION-TYPE     
                 MOVE WS-BC-FCT-RATE-VERSION (BA-INDX)                  
                                             TO RS-RATE-VERSION         
                 MOVE WS-BC-FCT-TOU (BA-INDX)                           
                                             TO RS-CODE-TOU             
                 MOVE WS-BC-FCT-SEASON (BA-INDX)                        
                                             TO RS-CODE-SN              
                 MOVE WS-BC-FCT-CMPNT-ID (BA-INDX)                      
                                             TO RS-COMPONENT-ID         
                 MOVE SF-FACTOR-DESC         TO RS-CHARGE-DESC          
                 MOVE SF-FACTOR-TYPE         TO RS-FACTOR-TYPE          
                 MOVE SF-ADJUST-ELEMENT      TO RS-ADJUST-ELEMENT       
                 MOVE SF-CALC-TYPE-CD        TO RS-CALC-TYPE-CD         
                 PERFORM 2000A-MOVE-RESULT    THRU 2000A-EXIT           
                 PERFORM 8100D-INSERT-GTT-R4  THRU 8100D-EXIT           
              WHEN OTHER                                                
PRJ821           IF SEB-DATABASE                                        
PRJ821             IF SUB-FROM-COMPONENT-AMT (BA-INDX)                  
PRJ821                   AND WS-BC-AMT-ADJUSTMENT (BA-INDX) > 0         
PRJ821                SUBTRACT WS-BC-AMT-ADJUSTMENT (BA-INDX)           
PRJ821                                          FROM WS-OTHR-CHARGES    
PRJ821             ELSE                                                 
PRJ821                ADD WS-BC-AMT-ADJUSTMENT (BA-INDX)                
PRJ821                                          TO WS-OTHR-CHARGES      
PRJ821             END-IF                                               
                 END-IF                                                 
                 MOVE SF-FACTOR-DESC         TO RS-FACTOR-DESC          
                 MOVE SF-FACTOR-TYPE         TO RS-FACTOR-TYPE          
                 MOVE SF-ADJUST-ELEMENT      TO RS-ADJUST-ELEMENT       
                 MOVE SF-CALC-TYPE-CD        TO RS-CALC-TYPE-CD         
                 PERFORM 2000A-MOVE-RESULT    THRU 2000A-EXIT           
                 PERFORM 8100B-INSERT-GTT-R2  THRU 8100B-EXIT           
           END-EVALUATE.                                                
                                                                        
           INITIALIZE TDS-RETURN-FIELDS.                                
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      ******************************************************************        
      **  GET REVENUE MONTH / REV MTH ORIG BILL                       **        
      ******************************************************************        
      *                                                                         
       7510-GET-REVENUE-MONTH-BG.                                       
      *                                                                         
           EXEC SQL                                                     
             SELECT TOP(1) COALESCE(CASE WHEN BG.REV_MTH_ORIG_BILL > 0          
                           THEN BG.REV_MTH_ORIG_BILL                    
                           ELSE BG.REVENUE_MONTH                        
                           END,0),
              COALESCE(BG.DATE_ORIG_BILL,IIF(TRY_CONVERT(DATE, 
              '1900-01-01') IS NULL OR (PATINDEX('%.%', '1900-01-01'
              ) <> 0) OR (LEN('1900-01-01') <> 10), CIS.CHAR2DATE(
              '1900-01-01'), CONVERT(DATE, '1900-01-01') )),
              BG.CODE_BILL_CALC                                  
               INTO  :BG-REVENUE-MONTH                                  
                    ,:BG-DATE-ORIG-BILL                                 
                    ,:BG-CODE-BILL-CALC                                 
               FROM  CSS_BILLING_DET  BG WITH(READUNCOMMITTED)                  
              WHERE  BG.ACCOUNT_NO          =  :BG-ACCOUNT-NO           
                AND  BG.CODE_UTIL_TYPE      =  :BG-CODE-UTIL-TYPE       
                AND  BG.IC_NO               =  :BG-IC-NO                
                AND  BG.BILL_NO             =  :BG-BILL-NO              
                AND  BG.BILL_ITEM_TIMESTMP  =  CIS.CHAR2TIMESTAMP(
                                                 :BG-BILL-ITEM-TIMESTMP
              )   
                AND  BG.CODE_BILL_CALC      IN ('A','S')                
                AND  BG.CODE_BILL_ITM_TYPE  =   'C'                     
                AND  BG.CODE_BILL_ITM_IND   =   'A'                     
                AND  BG.REV_RPT_CD          <>  'T'                     
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  IFNULL(CASE WHEN BG.REV_MTH_ORIG_BILL > 0                  
MFA-TR*                    THEN BG.REV_MTH_ORIG_BILL                            
MFA-TR*                    ELSE BG.REVENUE_MONTH                                
MFA-TR*                    END,0)                                               
MFA-TR*             ,IFNULL(BG.DATE_ORIG_BILL,'1900-01-01')                     
MFA-TR*             ,BG.CODE_BILL_CALC                                          
MFA-TR*        INTO  :BG-REVENUE-MONTH                                          
MFA-TR*             ,:BG-DATE-ORIG-BILL                                         
MFA-TR*             ,:BG-CODE-BILL-CALC                                         
MFA-TR*        FROM  CSS_BILLING_DET  BG                                        
MFA-TR*       WHERE  BG.ACCOUNT_NO          =  :BG-ACCOUNT-NO                   
MFA-TR*         AND  BG.CODE_UTIL_TYPE      =  :BG-CODE-UTIL-TYPE               
MFA-TR*         AND  BG.IC_NO               =  :BG-IC-NO                        
MFA-TR*         AND  BG.BILL_NO             =  :BG-BILL-NO                      
MFA-TR*         AND  BG.BILL_ITEM_TIMESTMP  =  :BG-BILL-ITEM-TIMESTMP           
MFA-TR*         AND  BG.CODE_BILL_CALC      IN ('A','S')                        
MFA-TR*         AND  BG.CODE_BILL_ITM_TYPE  =   'C'                             
MFA-TR*         AND  BG.CODE_BILL_ITM_IND   =   'A'                             
MFA-TR*         AND  BG.REV_RPT_CD          <>  'T'                             
MFA-TR*      FETCH FIRST ROW ONLY WITH UR                                       
MFA-TR*      QUERYNO 7510                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO WS-RETURN-CODE-ERR      
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7510'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_BILLING_DET'         TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'BILL_NO'                 TO TABLE-ELEMENT-2         
              MOVE 'IC_NO'                   TO TABLE-ELEMENT-3         
              MOVE 'BILL_ITEM_TIMESTMP'      TO TABLE-ELEMENT-4         
              MOVE BG-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE BG-BILL-NO                TO HOSTVAR-ELEMENT-2       
              MOVE BG-IC-NO                  TO HOSTVAR-ELEMENT-3       
              MOVE BG-BILL-ITEM-TIMESTMP     TO HOSTVAR-ELEMENT-4       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       7510-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7540-GET-OPTION-DESC                                          *         
      *****************************************************************         
       7540-GET-OPTION-DESC.                                            
                                                                        
           EXEC SQL                                                     
              SELECT FI.OPT_DESC_INT                                    
                INTO :FI-OPT-DESC-INT                                   
                FROM CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)                 
                    ,CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)                 
               WHERE DF.ACCOUNT_NO         = :DF-ACCOUNT-NO             
                 AND DF.CODE_UTIL_TYPE     = :DF-CODE-UTIL-TYPE         
                 AND DF.IC_NO              = :DF-IC-NO                  
                 AND DF.RT_PKG_OPT_SEQ_NO  = :DF-RT-PKG-OPT-SEQ-NO      
                 AND DF.OPTION_CD          = FI.OPTION_CD               
                 AND FI.OPT_VSTART_TS     <= CIS.CURRENT$TIMESTAMP()          
                 AND FI.OPT_VEND_TS       >= CIS.CURRENT$TIMESTAMP()          
                 AND FI.PROC_STATUS_CD     = 'AC'                       
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT FI.OPT_DESC_INT                                            
MFA-TR*         INTO :FI-OPT-DESC-INT                                           
MFA-TR*         FROM CSS_ACCT_RTPK_AGR DF                                       
MFA-TR*             ,CRM_RT_PKG_OPTION FI                                       
MFA-TR*        WHERE DF.ACCOUNT_NO         = :DF-ACCOUNT-NO                     
MFA-TR*          AND DF.CODE_UTIL_TYPE     = :DF-CODE-UTIL-TYPE                 
MFA-TR*          AND DF.IC_NO              = :DF-IC-NO                          
MFA-TR*          AND DF.RT_PKG_OPT_SEQ_NO  = :DF-RT-PKG-OPT-SEQ-NO              
MFA-TR*          AND DF.OPTION_CD          = FI.OPTION_CD                       
MFA-TR*          AND FI.OPT_VSTART_TS     <= CURRENT TIMESTAMP                  
MFA-TR*          AND FI.OPT_VEND_TS       >= CURRENT TIMESTAMP                  
MFA-TR*          AND FI.PROC_STATUS_CD     = 'AC'                               
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE '7540'                    TO ACTIVE-PARAGRAPH        
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_ACCT_RTPK_AGR'       TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE 'IC_NO'                   TO TABLE-ELEMENT-3         
              MOVE 'RT_PKG_OPT_SEQ_NO'       TO TABLE-ELEMENT-4         
              MOVE DF-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE DF-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              MOVE DF-IC-NO                  TO HOSTVAR-ELEMENT-3       
              MOVE DF-RT-PKG-OPT-SEQ-NO      TO HOSTVAR-ELEMENT-4       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7540-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7600-AMT-USES.                                                *         
      *                                                               *         
      *                                                               *         
      *                                                               *         
      *****************************************************************         
       7600-AMT-USES.                                                   
                                                                        
           PERFORM 8400-GET-FACTOR-TEXT THRU 8400-EXIT.                 
                                                                        
           MOVE WS-BC-FCT-CNSMPT-TYPE (BA-INDX)                         
                                             TO RS-CONSUMPTION-TYPE     
           MOVE WS-BC-FCT-REGISTER-TYPE (BA-INDX)                       
                                             TO RS-REGISTER-TYPE        
           MOVE WS-BC-FCT-RATE-VERSION (BA-INDX)                        
                                             TO RS-RATE-VERSION         
           MOVE WS-BC-AMT-ADJUSTMENT (BA-INDX)                          
                                             TO RS-COMPUTED-CHARGE      
           MOVE WS-BC-CODE-ADJUST-TYPE (BA-INDX)                        
                                             TO RS-CODE-ADJUST-TYPE     
           MOVE WS-BC-FACTOR-COMPONENT (BA-INDX)                        
                                             TO RS-COMPONENT-KEY        
                                                                        
           IF WS-BC-FACTOR-ID (BA-INDX)= 'RTPROPCT'                     
              MOVE WS-BC-FACTOR-ID (BA-INDX) TO RS-FACTOR-ID            
              MOVE WS-BC-GL-LOCAL-OFFICE-ADJ (BA-INDX)                  
                                             TO RS-CHARGE-DESC (1:3)    
              MOVE SF-FACTOR-DESC            TO RS-CHARGE-DESC (05:44)  
              MOVE SF-FACTOR-TYPE            TO RS-FACTOR-TYPE          
              MOVE SF-ADJUST-ELEMENT         TO RS-ADJUST-ELEMENT       
              MOVE SF-CALC-TYPE-CD           TO RS-CALC-TYPE-CD         
              MOVE ZERO                      TO RS-BLOCK-NO             
              MOVE 'Y'                       TO WS-PRORTD-BILL-FL       
              PERFORM 2000A-MOVE-RESULT       THRU 2000A-EXIT           
              PERFORM 8100C-INSERT-GTT-R3     THRU 8100C-EXIT           
           ELSE                                                         
              MOVE SF-FACTOR-DESC            TO RS-FACTOR-DESC          
              MOVE SF-FACTOR-TYPE            TO RS-FACTOR-TYPE          
              MOVE SF-ADJUST-ELEMENT         TO RS-ADJUST-ELEMENT       
              MOVE SF-CALC-TYPE-CD           TO RS-CALC-TYPE-CD         
              PERFORM 2000A-MOVE-RESULT       THRU 2000A-EXIT           
              PERFORM 8100B-INSERT-GTT-R2     THRU 8100B-EXIT           
           END-IF.                                                      
           INITIALIZE TDS-RETURN-FIELDS.                                
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7700-AMT-FYI.                                                 *         
      *****************************************************************         
       7700-AMT-FYI.                                                    
      *                                                                         
      *GOING TO DELETE THIS SET AFTER CONFIRMATION FROM JIJU, SINCE THE         
      *REQUIRED INFO IS ALREADY DISPLAYED IN THE SUMMARY RESULT SET RS1         
      *                                                                         
      *                                                                         
      *    IF WS-BC-SPCL-GROUP-CD (BA-INDX) = 'TX' OR TAX-ONLY (BA-INDX)        
      *      AND WS-BC-AMT-ADJUSTMENT (BA-INDX) NOT = 0                         
      *       PERFORM 8400-GET-FACTOR-TEXT    THRU 8400-EXIT                    
      *       MOVE SF-FACTOR-DESC            TO RS-CHARGE-DESC                  
      *       MOVE 'Z'                       TO RS-CONSUMPTION-TYPE             
      *       MOVE WS-BC-AMT-ADJUSTMENT (BA-INDX)                               
      *                                      TO RS-BASE-RATE                    
      *       MOVE WS-BC-FACTOR-COMPONENT (BA-INDX)                             
      *                                      TO RS-COMPONENT-KEY                
      *       PERFORM 2000A-MOVE-RESULT       THRU 2000A-EXIT                   
      *       PERFORM 8100C-INSERT-GTT-R3     THRU 8100C-EXIT                   
      *       INITIALIZE TDS-RETURN-FIELDS                                      
      *    END-IF.                                                              
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7800-RATE-INCLUDES.                                           *         
      *                                                               *         
      *                                                               *         
      *                                                               *         
      *****************************************************************         
       7800-RATE-INCLUDES.                                              
                                                                        
           EVALUATE WS-BC-FACTOR-ID (BA-INDX)                           
              WHEN '&RTP_MRG'                                           
                 GO                          TO 7800-EXIT               
              WHEN OTHER                                                
                 PERFORM 8400-GET-FACTOR-TEXT THRU 8400-EXIT            
                 MOVE SF-FACTOR-DESC         TO RS-FACTOR-DESC          
                 MOVE SF-FACTOR-TYPE         TO RS-FACTOR-TYPE          
                 MOVE SF-ADJUST-ELEMENT      TO RS-ADJUST-ELEMENT       
                 MOVE SF-CALC-TYPE-CD        TO RS-CALC-TYPE-CD         
                 IF WS-BC-FACTOR-ID (BA-INDX) NOT = 'WNA-AMT'           
                    MOVE WS-BC-BLOCK-NO (BA-INDX)                       
                                             TO RS2-BLOCK-NO            
                 END-IF                                                 
           END-EVALUATE                                                 
                                                                        
           MOVE WS-BC-FACTOR-ID (BA-INDX)    TO RS-FACTOR-ID            
                                                                        
           EVALUATE TRUE                                                
              WHEN ADD-TO-NET-RATE (BA-INDX)                            
              WHEN REPL-NET-RATE (BA-INDX)                              
              WHEN SUB-FROM-NET-RATE (BA-INDX)                          
              WHEN WNA-UNITS (BA-INDX)                                  
                   CONTINUE                                             
              WHEN OTHER                                                
                   MOVE WS-BC-AMT-ADJUSTMENT (BA-INDX)                  
                                             TO RS-COMPUTED-CHARGE      
           END-EVALUATE                                                 
                                                                        
           MOVE WS-BC-FACTOR-COMPONENT (BA-INDX)                        
                                             TO RS-COMPONENT-KEY        
           MOVE WS-BC-SPCL-GROUP-CD    (BA-INDX)                        
                                             TO RS-SPCL-GRP-CD          
           IF RS-SPCL-GRP-CD = 'AP' OR                                  
              RS-SPCL-GRP-CD = 'MT'                                     
              ADD RS-COMPUTED-CHARGE         TO WS-AGL-CHARGES          
           END-IF.                                                      
                                                                        
           IF WS-BC-R-FACTOR      (BA-INDX) > 0                         
              MOVE WS-BC-R-FACTOR (BA-INDX)  TO RS-NET-RATE             
           ELSE                                                         
              MOVE WS-BC-FACTOR   (BA-INDX)  TO RS-NET-RATE             
           END-IF.                                                      
                                                                        
           PERFORM 2000A-MOVE-RESULT          THRU 2000A-EXIT.          
           PERFORM 8100B-INSERT-GTT-R2        THRU 8100B-EXIT.          
           INITIALIZE TDS-RETURN-FIELDS.                                
                                                                        
       7800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7870-SEL-TAX-XMPT-CD.                                         *         
      *****************************************************************         
       7870-SEL-TAX-XMPT-CD.                                            
                                                                        
           EXEC SQL                                                     
               SELECT F1.PARTIAL_EXEMPT_CD                              
                 INTO :F1-PARTIAL-EXEMPT-CD                             
                 FROM CSS_TAX_EXMPT_CODE F1 WITH(READUNCOMMITTED)               
                WHERE F1.TAX_EXEMPT_CODE = :F1-TAX-EXEMPT-CODE          
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT F1.PARTIAL_EXEMPT_CD                                      
MFA-TR*          INTO :F1-PARTIAL-EXEMPT-CD                                     
MFA-TR*          FROM CSS_TAX_EXMPT_CODE F1                                     
MFA-TR*         WHERE F1.TAX_EXEMPT_CODE = :F1-TAX-EXEMPT-CODE                  
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE ZEROES                 TO WS-ACTIVE-RETURN-CODE   
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7870'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_TAX_EXMPT_CODE'      TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'TAX_EXEMPT_CODE'         TO TABLE-ELEMENT-2         
              MOVE WS-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE F1-TAX-EXEMPT-CODE        TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7870-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7880-CHK-MANUAL-BILL.                                         *         
      *****************************************************************         
       7880-CHK-MANUAL-BILL.                                            
                                                                        
           EXEC SQL                                                     
             SELECT  'Y'                                                
               INTO :WS-MANUAL-BILL-SW                                  
               FROM  CSS_BILL_MANUAL NG                                 
              WHERE  NG.ACCOUNT_NO         = :NG-ACCOUNT-NO             
                AND  NG.BILL_NO            = :NG-BILL-NO                
                AND  NG.CODE_UTIL_TYPE     = :NG-CODE-UTIL-TYPE         
                AND  NG.IC_NO              = :NG-IC-NO                  
                AND  NG.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :NG-BILL-ITEM-TIMESTMP
              )     
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  'Y'                                                        
MFA-TR*        INTO :WS-MANUAL-BILL-SW                                          
MFA-TR*        FROM  CSS_BILL_MANUAL NG                                         
MFA-TR*       WHERE  NG.ACCOUNT_NO         = :NG-ACCOUNT-NO                     
MFA-TR*         AND  NG.BILL_NO            = :NG-BILL-NO                        
MFA-TR*         AND  NG.CODE_UTIL_TYPE     = :NG-CODE-UTIL-TYPE                 
MFA-TR*         AND  NG.IC_NO              = :NG-IC-NO                          
MFA-TR*         AND  NG.BILL_ITEM_TIMESTMP = :NG-BILL-ITEM-TIMESTMP             
MFA-TR*     QUERYNO  7680                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE ZEROES                 TO WS-ACTIVE-RETURN-CODE   
                 MOVE 'N'                    TO WS-MANUAL-BILL-SW       
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7880'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_BILL_MANUAL'         TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'BILL_NO'                 TO TABLE-ELEMENT-2         
              MOVE 'IC_NO'                   TO TABLE-ELEMENT-3         
              MOVE 'BILL_ITEM_TIMESTMP'      TO TABLE-ELEMENT-4         
              MOVE NG-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE NG-BILL-NO                TO HOSTVAR-ELEMENT-2       
              MOVE NG-IC-NO                  TO HOSTVAR-ELEMENT-3       
              MOVE NG-BILL-ITEM-TIMESTMP     TO HOSTVAR-ELEMENT-4       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7880-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7900-GET-RULE-XREF-ID                                          *        
      ******************************************************************        
       7900-GET-RULE-XREF-ID.                                           
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           BUS_RULE_XREF_ID, 121), ' ', '-'), ':', '.') 
           BUS_RULE_XREF_ID                                   
                INTO :S5-BUS-RULE-XREF-ID                               
                FROM CSS_BUS_RULE   [1R] WITH(READUNCOMMITTED)                  
                    ,CSS_BUS_RULE_XREF [1T] WITH(READUNCOMMITTED)               
               WHERE [1R].BUS_RULE_ID = :S5-BUS-RULE-ID                   
                 AND [1R].BUS_RULE_ID = [1T].BUS_RULE_ID                    
                 AND [1T].BUS_PROCESS_ID = :PARM-BUS-PROC-ID              
                                             
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BUS_RULE_XREF_ID                                           
MFA-TR*         INTO :S5-BUS-RULE-XREF-ID                                       
MFA-TR*         FROM CSS_BUS_RULE   1R                                          
MFA-TR*             ,CSS_BUS_RULE_XREF 1T                                       
MFA-TR*        WHERE 1R.BUS_RULE_ID = :S5-BUS-RULE-ID                           
MFA-TR*          AND 1R.BUS_RULE_ID = 1T.BUS_RULE_ID                            
MFA-TR*          AND 1T.BUS_PROCESS_ID = :PARM-BUS-PROC-ID                      
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7900                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SPACES                    TO ABEND-TABLES            
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
              MOVE '7900'                    TO ACTIVE-PARAGRAPH        
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_BUS_RULE'            TO TABLE-1                 
              MOVE 'BUS_RULE_ID'             TO TABLE-ELEMENT-1         
              MOVE S5-BUS-RULE-ID            TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8000-OPEN-CNSMPTN-HIST                                         *        
      *                                                                *        
      *   PERFORM SQL FUNCTIONS                                        *        
      *                                                                *        
      ******************************************************************        
          8000-OPEN-CNSMPTN-HIST.                                       
                                                                        
              EXEC SQL                                                  
                   OPEN CNSMPTN_HIST                                    
              END-EXEC.                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
              MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.  
                                                                        
              IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL         
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE '8000'                 TO ACTIVE-PARAGRAPH        
                 MOVE 'OPEN'                 TO ABEND-FUNCTION          
                 MOVE 'CSS_CNSMPTN_HIST'     TO TABLE-1                 
                 MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1         
                 MOVE 'BILL_NO'              TO TABLE-ELEMENT-2         
                 MOVE 'CODE_UTIL_TYPE'       TO TABLE-ELEMENT-3         
                 MOVE 'IC_NO'                TO TABLE-ELEMENT-4         
                 MOVE WS-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1       
                 MOVE WS-BILL-NO             TO HOSTVAR-ELEMENT-2       
                 MOVE WS-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-3       
                 MOVE WS-IC-NO               TO HOSTVAR-ELEMENT-4       
                 PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT
              END-IF.           
                                                                        
          8000-EXIT.                                                    
              EXIT.                                                     
                                                                        
      ******************************************************************        
      *8000A-DELETE-GTT-ROWS                                           *        
      ******************************************************************        
       8000A-DELETE-GTT-ROWS.                                           
            MOVE 'DELETE ROWS'               TO S-SQL-STATEMENT-V.      
            EXEC SQL                                                    
                     DELETE FROM #CSR04686_R1                    
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*              DELETE FROM SESSION.CSR04686_R1                            
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

            MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.  
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
                CONTINUE                                                
            ELSE                                                        
                MOVE PROGRAM-NAME            TO ABEND-PROGRAM           
                MOVE '8000A'                 TO ACTIVE-PARAGRAPH        
                MOVE 'DELETE'                TO ABEND-FUNCTION          
                MOVE SPACES                  TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                MOVE 'CSR04686_R1'           TO TABLE-1                 
                MOVE SPACES                  TO TABLE-ELEMENT-1         
                MOVE SPACES                  TO HOSTVAR-ELEMENT-1       
                PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT            
            END-IF.                                                     
      *                                                                         
       8000A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      *8000B-DELETE-GTT-ROWS                                           *        
      ******************************************************************        
       8000B-DELETE-GTT-ROWS.                                           
            MOVE 'DELETE ROWS'               TO S-SQL-STATEMENT-V.      
            EXEC SQL                                                    
                     DELETE FROM #CSR04686_R2                    
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*              DELETE FROM SESSION.CSR04686_R2                            
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

            MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.  
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
                CONTINUE                                                
            ELSE                                                        
                MOVE PROGRAM-NAME            TO ABEND-PROGRAM           
                MOVE '8000B'                 TO ACTIVE-PARAGRAPH        
                MOVE 'DELETE'                TO ABEND-FUNCTION          
                MOVE SPACES                  TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                MOVE 'CSR04686_R2'           TO TABLE-1                 
                MOVE SPACES                  TO TABLE-ELEMENT-1         
                MOVE SPACES                  TO HOSTVAR-ELEMENT-1       
                PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT            
            END-IF.                                                     
      *                                                                         
       8000B-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      *8000C-DELETE-GTT-ROWS                                           *        
      ******************************************************************        
       8000C-DELETE-GTT-ROWS.                                           
            MOVE 'DELETE ROWS'               TO S-SQL-STATEMENT-V.      
            EXEC SQL                                                    
                     DELETE FROM #CSR04686_R3                    
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*              DELETE FROM SESSION.CSR04686_R3                            
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

            MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.  
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
                CONTINUE                                                
            ELSE                                                        
                MOVE PROGRAM-NAME            TO ABEND-PROGRAM           
                MOVE '8000C'                 TO ACTIVE-PARAGRAPH        
                MOVE 'DELETE'                TO ABEND-FUNCTION          
                MOVE SPACES                  TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                MOVE 'CSR04686_R3'           TO TABLE-1                 
                MOVE SPACES                  TO TABLE-ELEMENT-1         
                MOVE SPACES                  TO HOSTVAR-ELEMENT-1       
                PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT            
            END-IF.                                                     
      *                                                                         
       8000C-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      *8000D-DELETE-GTT-ROWS                                           *        
      ******************************************************************        
       8000D-DELETE-GTT-ROWS.                                           
            MOVE 'DELETE ROWS'               TO S-SQL-STATEMENT-V.      
            EXEC SQL                                                    
                     DELETE FROM #CSR04686_R4                    
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*              DELETE FROM SESSION.CSR04686_R4                            
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

            MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.  
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
                CONTINUE                                                
            ELSE                                                        
                MOVE PROGRAM-NAME            TO ABEND-PROGRAM           
                MOVE '8000D'                 TO ACTIVE-PARAGRAPH        
                MOVE 'DELETE'                TO ABEND-FUNCTION          
                MOVE SPACES                  TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                MOVE 'CSR04686_R4'           TO TABLE-1                 
                MOVE SPACES                  TO TABLE-ELEMENT-1         
                MOVE SPACES                  TO HOSTVAR-ELEMENT-1       
                PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT            
            END-IF.                                                     
      *                                                                         
       8000D-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      *8000E-DELETE-GTT-ROWS                                           *        
      ******************************************************************        
       8000E-DELETE-GTT-ROWS.                                           
            MOVE 'DELETE ROWS'               TO S-SQL-STATEMENT-V.      
            EXEC SQL                                                    
                     DELETE FROM #CSR04686_R5                    
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*              DELETE FROM SESSION.CSR04686_R5                            
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

            MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.  
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
                CONTINUE                                                
            ELSE                                                        
                MOVE PROGRAM-NAME            TO ABEND-PROGRAM           
                MOVE '8000E'                 TO ACTIVE-PARAGRAPH        
                MOVE 'DELETE'                TO ABEND-FUNCTION          
                MOVE SPACES                  TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                MOVE 'CSR04686_R5'           TO TABLE-1                 
                MOVE SPACES                  TO TABLE-ELEMENT-1         
                MOVE SPACES                  TO HOSTVAR-ELEMENT-1       
                PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT            
            END-IF.                                                     
      *                                                                         
       8000E-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8010-OPEN-FIXED-FCT-HIST.                                      *        
      ******************************************************************        
       8010-OPEN-FIXED-FCT-HIST.                                        
                                                                        
              EXEC SQL                                                  
                   OPEN FIXED_FCT_HIST                                  
              END-EXEC.                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

              MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.  
              IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL         
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE '8010'                 TO ACTIVE-PARAGRAPH        
                 MOVE 'OPEN'                 TO ABEND-FUNCTION          
                 MOVE 'CSS_FIXED_FCT_HIST'   TO TABLE-1                 
                 MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1         
                 MOVE 'BILL_NO'              TO TABLE-ELEMENT-2         
                 MOVE 'IC_NO'                TO TABLE-ELEMENT-3         
                 MOVE 'CODE_UTIL_TYPE'       TO TABLE-ELEMENT-4         
                 MOVE WS-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1       
                 MOVE WS-BILL-NO             TO HOSTVAR-ELEMENT-2       
                 MOVE WS-IC-NO               TO HOSTVAR-ELEMENT-3       
                 MOVE WS-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-4       
                 PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT
              END-IF.           
                                                                        
          8010-EXIT.                                                    
              EXIT.                                                     
                                                                        
      ******************************************************************        
      * 8020-OPEN-UNMTRD-CNSMPTN.                                      *        
      ******************************************************************        
       8020-OPEN-UNMTRD-CNSMPTN.                                        
                                                                        
              EXEC SQL                                                  
                   OPEN UM_CNSMPT_HIST                                  
              END-EXEC.                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

              MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.  
              IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL         
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE '8020'                 TO ACTIVE-PARAGRAPH        
                 MOVE 'OPEN'                 TO ABEND-FUNCTION          
                 MOVE 'CSS_UM_CNSMPT_HIST'   TO TABLE-1                 
                 MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1         
                 MOVE 'BILL_NO'              TO TABLE-ELEMENT-2         
                 MOVE 'IC_NO'                TO TABLE-ELEMENT-3         
                 MOVE 'CODE_UTIL_TYPE'       TO TABLE-ELEMENT-4         
                 MOVE WS-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1       
                 MOVE WS-BILL-NO             TO HOSTVAR-ELEMENT-2       
                 MOVE WS-IC-NO               TO HOSTVAR-ELEMENT-3       
                 MOVE WS-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-4       
                 PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT
              END-IF.           
                                                                        
          8020-EXIT.                                                    
              EXIT.                                                     
                                                                        
      ******************************************************************        
      * 8030-OPEN-BILLING-DET.                                         *        
      ******************************************************************        
       8030-OPEN-BILLING-DET.                                           
                                                                        
              EXEC SQL                                                  
                   OPEN BILLING_DET                                     
              END-EXEC.                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
              MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.  
                                                                        
              IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL         
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE '8030'                 TO ACTIVE-PARAGRAPH        
                 MOVE 'OPEN'                 TO ABEND-FUNCTION          
                 MOVE 'CSS_BILLING_DET'      TO TABLE-1                 
                 MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1         
                 MOVE 'BILL_NO'              TO TABLE-ELEMENT-2         
                 MOVE 'IC_NO'                TO TABLE-ELEMENT-3         
                 MOVE 'CODE_UTIL_TYPE'       TO TABLE-ELEMENT-4         
                 MOVE WS-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1       
                 MOVE WS-BILL-NO             TO HOSTVAR-ELEMENT-2       
                 MOVE WS-IC-NO               TO HOSTVAR-ELEMENT-3       
                 MOVE WS-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-4       
                 PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT
              END-IF.           
                                                                        
          8030-EXIT.                                                    
              EXIT.                                                     
                                                                        
      ******************************************************************        
      * 8040-OPEN-BILL-ADJUSTMENT.                                     *        
      ******************************************************************        
                                                                        
       8040-OPEN-BILL-ADJUSTMENT.                                       
                                                                        
           EXEC SQL                                                     
                OPEN BILL_ADJ_CSR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL    TO SUCCESSFUL-CALL         
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8040'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'CSS_BILL_ADJUSTMENT'     TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'BILL_NO'                 TO TABLE-ELEMENT-2         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-3         
              MOVE 'IC_NO'                   TO TABLE-ELEMENT-4         
              MOVE WS-BC-ACCOUNT-NO-BG       TO HOSTVAR-ELEMENT-1       
              MOVE WS-BC-BILL-NO-BG          TO HOSTVAR-ELEMENT-2       
              MOVE WS-BC-CODE-UTIL-TYPE-BG   TO HOSTVAR-ELEMENT-3       
              MOVE WS-BC-IC-NO-BG            TO HOSTVAR-ELEMENT-4       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT
           END-IF.           
                                                                        
       8040-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8050-FETCH-BILL-ADJUSTMENT.                                    *        
      ******************************************************************        
      *                                                                         
       8050-FETCH-BILL-ADJUSTMENT.                                      
           EXEC SQL                                                     
                FETCH  BILL_ADJ_CSR                                     
                INTO                                                    
                    :BP-ADJ-TYPE-CD                                     
                   ,:BP-REVENUE-MONTH                                   
                   ,:BP-ADJ-REASON-DESC                                 
                   ,:BP-OVRRIDE-RT-REV-MTH                              
                   ,:BP-OVRRIDE-RT-BILL-DT :WS-NULL-IND-11               
                   ,:BP-OVRRIDE-RT-BILL-CY                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE SQLCODE                                             
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-IND-11 < 0                                
                      MOVE SPACES            TO BP-OVRRIDE-RT-BILL-DT   
                   ELSE                                                 
                      CONTINUE                                          
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE SPACES               TO BP-OVRRIDE-RT-BILL-DT   
                                                BP-OVRRIDE-RT-BILL-CY   
                   MOVE ZEROS                TO BP-OVRRIDE-RT-REV-MTH   
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '8050'               TO ACTIVE-PARAGRAPH        
                   MOVE 'FETCH'              TO ABEND-FUNCTION          
                   MOVE 'CSS_BILL_ADJUSTMENT'                           
                                             TO TABLE-1                 
                   MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1         
                   MOVE 'BILL_NO'            TO TABLE-ELEMENT-2         
                   MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-3         
                   MOVE 'IC_NO'              TO TABLE-ELEMENT-4         
                   MOVE WS-BC-ACCOUNT-NO-BG  TO HOSTVAR-ELEMENT-1       
                   MOVE WS-BC-BILL-NO-BG     TO HOSTVAR-ELEMENT-2       
                   MOVE WS-BC-CODE-UTIL-TYPE-BG                         
                                             TO HOSTVAR-ELEMENT-3       
                   MOVE WS-BC-IC-NO-BG       TO HOSTVAR-ELEMENT-4       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
      *                                                                         
       8050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8060-CLOSE-BILL-ADJUSTMENT.                                    *        
      ******************************************************************        
       8060-CLOSE-BILL-ADJUSTMENT.                                      
      *                                                                         
           EXEC SQL                                                     
               CLOSE BILL_ADJ_CSR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL    TO SUCCESSFUL-CALL         
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8060'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE 'CSS_BILL_ADJUSTMENT'     TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'BILL_NO'                 TO TABLE-ELEMENT-2         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-3         
              MOVE 'IC_NO'                   TO TABLE-ELEMENT-4         
              MOVE WS-BC-ACCOUNT-NO-BG       TO HOSTVAR-ELEMENT-1       
              MOVE WS-BC-BILL-NO-BG          TO HOSTVAR-ELEMENT-2       
              MOVE WS-BC-CODE-UTIL-TYPE-BG   TO HOSTVAR-ELEMENT-3       
              MOVE WS-BC-IC-NO-BG            TO HOSTVAR-ELEMENT-4       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT
           END-IF.           
                                                                        
       8060-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8070-FETCH-CNSMPTN-HIST.                                       *        
      ******************************************************************        
       8070-FETCH-CNSMPTN-HIST.                                         
                                                                        
              EXEC SQL                                                  
                   FETCH CNSMPTN_HIST INTO                              
                       :CX-ACCOUNT-NO                 ,                 
                       :CX-BILL-NO                    ,                 
                       :CX-CODE-UTIL-TYPE             ,                 
                       :CX-IC-NO                      ,                 
                       :CX-BILL-ITEM-TIMESTMP         ,                 
                       :CX-CODE-TIME-PERIOD           ,                 
                       :CX-MTR-REF-NO                 ,                 
                       :CX-CODE-USAGE-TYPE            ,                 
                       :CX-CODE-USAGE-ID              ,                 
                       :CX-CODE-USAGE-SOURCE          ,                 
                       :CX-ITEM-SEQ-NO                ,                 
                       :CX-METER-NO                   ,                 
                       :CX-REG-ID-NO                  ,                 
                       :CX-DATE-READ :WS-DATE-READ-NULL,                 
                       :CX-CODE-METER-READ            ,                 
                       :CX-CODE-METER-NO-READ         ,                 
                       :CX-METER-READING              ,                 
                       :CX-DEMAND-READING             ,                 
                       :CX-EMPLOYEE-NO                ,                 
                       :CX-NO-UNITS                   ,                 
                       :CX-NO-DEMAND-UNITS            ,                 
                       :CX-NO-DAYS                    ,                 
                       :CX-CODE-SOURCE-ID             ,                 
                       :CX-CODE-DEBIT-CREDIT          ,                 
                       :CX-CODE-ITEM-STATUS           ,                 
                       :CX-CODE-DISCOUNT              ,                 
                       :CX-CONSTANT                   ,                 
                       :CX-NO-DIALS                   ,                 
                       :CX-COMPANY-NO                 ,                 
                       :CX-EXCEPT-OVERRIDE-CD         ,                 
                       :CX-REQUESTED-USAGE            ,                 
                       :CX-DIGTL-INTRL-MTR-NO         ,                 
                       :CX-DIGTL-MTR-TYPE             ,                 
                       :CX-CODE-TOU-SEASN             ,                 
                       :CX-EXCL-DMD-RCHT-IND                            
              END-EXEC.                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

              MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.  
              IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL         
                                             OR NOT-FOUND               
                  CONTINUE                                              
              ELSE                                                      
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE '8070'                 TO ACTIVE-PARAGRAPH        
                 MOVE 'FETCH'                TO ABEND-FUNCTION          
                 MOVE 'CSS_CNSMPTN_HIST'     TO TABLE-1                 
                 MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1         
                 MOVE 'BILL_NO'              TO TABLE-ELEMENT-2         
                 MOVE 'CODE_UTIL_TYPE'       TO TABLE-ELEMENT-3         
                 MOVE 'IC_NO'                TO TABLE-ELEMENT-4         
                 MOVE WS-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1       
                 MOVE WS-BILL-NO             TO HOSTVAR-ELEMENT-2       
                 MOVE WS-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-3       
                 MOVE WS-IC-NO               TO HOSTVAR-ELEMENT-4       
                 PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT
              END-IF.           
      *                                                                         
          8070-EXIT.                                                    
              EXIT.                                                     
      *                                                                         
      ******************************************************************        
      * 8080-FETCH-FIXED-FCT-HIST.                                    *         
      ******************************************************************        
       8080-FETCH-FIXED-FCT-HIST.                                       
                                                                        
              EXEC SQL                                                  
                   FETCH FIXED_FCT_HIST INTO                            
                        :FH-ACCOUNT-NO                         ,        
                        :FH-BILL-NO                            ,        
                        :FH-CODE-UTIL-TYPE                     ,        
                        :FH-IC-NO                              ,        
                        :FH-CODE-TIME-PERIOD                   ,        
                        :FH-BILL-ITEM-TIMESTMP                 ,        
                        :FH-EFF-DATE-FROM :WS-EFF-DATE-FROM-NULL,        
                        :FH-FACTOR-ID                          ,        
                        :FH-CODE-DEBIT-CREDIT                  ,        
                        :FH-CMPNT-ID-CD                        ,        
                        :FH-CODE-SEASON                        ,        
                        :FH-INSTR-USE-TYPE-CD                  ,        
                        :FH-CODE-REVENUE-CLASS                 ,        
                        :FH-CODE-TAX-STAT-XMT                  ,        
                        :FH-CODE-TAX-CITY-XMT                  ,        
                        :FH-CODE-TAX-OTHR-XMT                  ,        
                        :FH-FACTOR                             ,        
                        :FH-EFF-DATE-TO :WS-EFF-DATE-TO-NULL             
              END-EXEC.                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

              MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.  
              IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL         
                                             OR NOT-FOUND               
                  CONTINUE                                              
              ELSE                                                      
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE '8080'                 TO ACTIVE-PARAGRAPH        
                 MOVE 'FETCH'                TO ABEND-FUNCTION          
                 MOVE 'CSS_FIXED_FCT_HIST'   TO TABLE-1                 
                 MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1         
                 MOVE 'BILL_NO'              TO TABLE-ELEMENT-2         
                 MOVE 'IC_NO'                TO TABLE-ELEMENT-3         
                 MOVE 'CODE_UTIL_TYPE'       TO TABLE-ELEMENT-4         
                 MOVE WS-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1       
                 MOVE WS-BILL-NO             TO HOSTVAR-ELEMENT-2       
                 MOVE WS-IC-NO               TO HOSTVAR-ELEMENT-3       
                 MOVE WS-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-4       
                 PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT
              END-IF.           
      *                                                                         
          8080-EXIT.                                                    
              EXIT.                                                     
      *                                                                         
      ******************************************************************        
      * 8090-FETCH-UNMTRD-CNSMPTN.                                     *        
      ******************************************************************        
       8090-FETCH-UNMTRD-CNSMPTN.                                       
                                                                        
              EXEC SQL                                                  
                   FETCH UM_CNSMPT_HIST INTO                            
                         :UC-ACCOUNT-NO        ,                        
                         :UC-BILL-NO           ,                        
                         :UC-CODE-UTIL-TYPE    ,                        
                         :UC-IC-NO             ,                        
                         :UC-BILL-ITEM-TIMESTMP,                        
                         :UC-RATE-ITEM-CODE    ,                        
                         :UC-ITEM-SEQ-NO       ,                        
                         :UC-NO-UNITS          ,                        
                         :UC-NO-DAYS           ,                        
                         :UC-CODE-DEBIT-CREDIT ,                        
                         :UC-USAGE-FIXED       ,                        
                         :UC-DATE-USAGE-ENDS :WS-DATE-USAGE-ENDS-NULL,   
                         :UC-CODE-SERVICE-TYPE ,                        
                         :UC-CODE-ITEM-STATUS  ,                        
                         :UC-CODE-SOURCE-ID    ,                        
                         :UC-MTHLY-AMOUNT-FIXED,                        
                         :UC-DIST-NO           ,                        
                         :UC-LIGHT-NO          ,                        
                         :UC-POLE-NO                                    
              END-EXEC.                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

              MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.  
              IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL         
                                             OR NOT-FOUND               
                  CONTINUE                                              
              ELSE                                                      
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE '8090'                 TO ACTIVE-PARAGRAPH        
                 MOVE 'FETCH'                TO ABEND-FUNCTION          
                 MOVE 'CSS_UM_CNSMPT_HIST'   TO TABLE-1                 
                 MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1         
                 MOVE 'BILL_NO'              TO TABLE-ELEMENT-2         
                 MOVE 'IC_NO'                TO TABLE-ELEMENT-3         
                 MOVE 'CODE_UTIL_TYPE'       TO TABLE-ELEMENT-4         
                 MOVE WS-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1       
                 MOVE WS-BILL-NO             TO HOSTVAR-ELEMENT-2       
                 MOVE WS-IC-NO               TO HOSTVAR-ELEMENT-3       
                 MOVE WS-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-4       
                 PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT
              END-IF.           
      *                                                                         
          8090-EXIT.                                                    
              EXIT.                                                     
      *                                                                         
      ******************************************************************        
      * 8100-FETCH-BILLING-DET.                                        *        
      ******************************************************************        
       8100-FETCH-BILLING-DET.                                          
                                                                        
              EXEC SQL                                                  
                 FETCH BILLING_DET INTO                                 
                   :BG-PREMISE-NO        ,                              
                   :BG-BILL-NO           ,                              
                   :BG-CODE-UTIL-TYPE    ,                              
                   :BG-IC-NO             ,                              
                   :BG-BILL-ITEM-TIMESTMP,                              
                   :BG-DATE-ORIG-BILL :WS-DATE-ORIG-BILL-NULL,           
                   :BG-AMT-BILL-ITEM     ,                              
                   :BG-CODE-BILL-CALC    ,                              
                   :BG-CODE-BILL-ITM-TYPE,                              
                   :BG-CODE-BILL-ITM-IND ,                              
                   :BG-CODE-DR-CR-CNSMPTN,                              
                   :BG-AMT-STATE-TAX     ,                              
                   :BG-AMT-CITY-TAX      ,                              
                   :BG-AMT-OTHER-TAX     ,                              
                   :BG-CODE-REVENUE-CLASS,                              
                   :BG-CODE-SIC-NO       ,                              
                   :BG-RATE-PLAN-NO      ,                              
                   :BG-CODE-CURTAIL-PRTY ,                              
                   :BG-CODE-STAT-TAX-XMT ,                              
                   :BG-CODE-CITY-TAX-XMT ,                              
                   :BG-CODE-OTHR-TAX-XMT ,                              
                   :BG-REV-RPT-CD        ,                              
                   :BG-STANDBY-COMPLIED  ,                              
                   :BG-PRORATE-CD        ,                              
                   :BG-NEW-RATE-PCT      ,                              
                   :BG-CODE-SUB-TOTAL    ,                              
                   :BG-TAX-REFUND-CD     ,                              
                   :BG-ACCOUNT-NO        ,                              
                   :BG-COMPANY-NO        ,                              
                   :BG-DATE-LFTM-HI-DMD :WS-DATE-LFTM-HI-DMD,            
                   :BG-LFTM-HI-PEAK-DMD  ,                              
                   :BG-REBILL-IND        ,                              
                   :BG-ADJ-REASON-CD     ,                              
                   :BG-REVENUE-MONTH     ,                              
                   :BG-GAS-BASE-USE      ,                              
                   :BG-WNA-FACTOR        ,                              
                   :BG-BTU-FACTOR        ,                              
                   :BG-REV-MTH-ORIG-BILL ,                              
                   :BG-BILL-CALC-CYCLE,                                 
                   :BG-RT-PKG-OPT-SEQ-NO :WS-NULL-IND-1,                
                   :BG-STATE-TAX-RATE,                                  
                   :BG-CITY-TAX-RATE                                    
              END-EXEC.                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
              MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.  
                                                                        
              IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL         
                 IF WS-NULL-IND-1 < ZERO                                
                     MOVE ZERO               TO BG-RT-PKG-OPT-SEQ-NO    
                 END-IF                                                 
              ELSE                                                      
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE '8100'                 TO ACTIVE-PARAGRAPH        
                 MOVE 'FETCH'                TO ABEND-FUNCTION          
                 MOVE 'CSS_BILLING_DET'      TO TABLE-1                 
                 MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1         
                 MOVE 'BILL_NO'              TO TABLE-ELEMENT-2         
                 MOVE 'IC_NO'                TO TABLE-ELEMENT-3         
                 MOVE 'CODE_UTIL_TYPE'       TO TABLE-ELEMENT-4         
                 MOVE WS-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1       
                 MOVE WS-BILL-NO             TO HOSTVAR-ELEMENT-2       
                 MOVE WS-IC-NO               TO HOSTVAR-ELEMENT-3       
                 MOVE WS-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-4       
                 PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT
              END-IF.           
      *                                                                         
          8100-EXIT.                                                    
              EXIT.                                                     
      *                                                                         
      ******************************************************************        
      * 8100A-INSERT-MTT-R1                                            *        
      ******************************************************************        
       8100A-INSERT-GTT-R1.                                             
            EXEC SQL                                                    
                 INSERT INTO #CSR04686_R1                        
                 (                                                      
                      RETURN_CODE                                       
                     ,APPL_RETURN_CODE                                  
                     ,NO_OF_DAYS                                        
                     ,STATE_TAX                                         
                     ,CITY_TAX                                          
                     ,OTHER_TAX                                         
                     ,TOTAL_NET_UNITS                                   
                     ,TOTAL_USAGE_CHRG                                  
                     ,USAGE_CHRG                                        
                     ,TOTAL_DEMAND_CHRG                                 
                     ,DEMAND_CHRGS_CRDT                                 
                     ,USAGE_CHRGS_CRDT                                  
                     ,BASIC_FCLTY_CHRG                                  
                     ,AGL_CHARGES                                       
                     ,UNIT_PRICE_AMT                                    
                     ,TOTAL_BILL_AMOUNT                                 
                     ,REV_MONTH                                         
                     ,RATE_PLAN                                         
                     ,RATE_DESC                                         
                     ,SVC_CAT                                           
                     ,STATE_TAX_RATE                                    
                     ,CITY_TAX_RATE                                     
                     ,PARTIAL_XMPT_FL                                   
                     ,RT_OVRD_BILL_CY                                   
                     ,RT_OVRD_BILL_DT                                   
                     ,RT_OVRD_REV_MTH                                   
                     ,PRORTD_BILL_FL                                    
                     ,READ_DATE                                         
                     ,PRORTD_BY_DAYS_FL                                 
                  )                                                     
                  VALUES                                                
                  (                                                     
                      :S-RETURN-CODE                                    
                     ,:S-APPL-RETURN-CODE                               
                     ,:S-NO-OF-DAYS                                     
                     ,:S-STATE-TAX                                      
                     ,:S-CITY-TAX                                       
                     ,:S-OTHER-TAX                                      
                     ,:S-TOTAL-NET-UNITS                                
                     ,:S-TOTAL-USAGE-CHRG                               
                     ,:S-USAGE-CHRG                                     
                     ,:S-TOTAL-DEMAND-CHRG                              
                     ,:S-DEMAND-CHRGS-CRDT                              
                     ,:S-USAGE-CHRGS-CRDT                               
                     ,:S-BASIC-FCLTY-CHRG                               
                     ,:S-AGL-CHARGES                                    
                     ,:S-UNIT-PRICE-AMT                                 
                     ,:S-TOTAL-BILL-AMOUNT                              
                     ,:S-REV-MONTH                                      
                     ,:S-RATE-PLAN                                      
                     ,:S-RATE-DESC                                      
                     ,:S-SVC-CAT                                        
                     ,:S-STATE-TAX-RATE                                 
                     ,:S-CITY-TAX-RATE                                  
                     ,:S-PARTIAL-XMPT-FL                                
                     ,:S-RT-OVRD-BILL-CY                                
                     ,:S-RT-OVRD-BILL-DT                                
                     ,:S-RT-OVRD-REV-MTH                                
                     ,:S-PRORTD-BILL-FL                                 
                     ,:S-READ-DATE                                      
                     ,:S-PRORTD-BY-DAYS-FL                              
                  )                                                     
              END-EXEC.                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*          INSERT INTO SESSION.CSR04686_R1                                
MFA-TR*          (                                                              
MFA-TR*               RETURN_CODE                                               
MFA-TR*              ,APPL_RETURN_CODE                                          
MFA-TR*              ,NO_OF_DAYS                                                
MFA-TR*              ,STATE_TAX                                                 
MFA-TR*              ,CITY_TAX                                                  
MFA-TR*              ,OTHER_TAX                                                 
MFA-TR*              ,TOTAL_NET_UNITS                                           
MFA-TR*              ,TOTAL_USAGE_CHRG                                          
MFA-TR*              ,USAGE_CHRG                                                
MFA-TR*              ,TOTAL_DEMAND_CHRG                                         
MFA-TR*              ,DEMAND_CHRGS_CRDT                                         
MFA-TR*              ,USAGE_CHRGS_CRDT                                          
MFA-TR*              ,BASIC_FCLTY_CHRG                                          
MFA-TR*              ,AGL_CHARGES                                               
MFA-TR*              ,UNIT_PRICE_AMT                                            
MFA-TR*              ,TOTAL_BILL_AMOUNT                                         
MFA-TR*              ,REV_MONTH                                                 
MFA-TR*              ,RATE_PLAN                                                 
MFA-TR*              ,RATE_DESC                                                 
MFA-TR*              ,SVC_CAT                                                   
MFA-TR*              ,STATE_TAX_RATE                                            
MFA-TR*              ,CITY_TAX_RATE                                             
MFA-TR*              ,PARTIAL_XMPT_FL                                           
MFA-TR*              ,RT_OVRD_BILL_CY                                           
MFA-TR*              ,RT_OVRD_BILL_DT                                           
MFA-TR*              ,RT_OVRD_REV_MTH                                           
MFA-TR*              ,PRORTD_BILL_FL                                            
MFA-TR*              ,READ_DATE                                                 
MFA-TR*              ,PRORTD_BY_DAYS_FL                                         
MFA-TR*           )                                                             
MFA-TR*           VALUES                                                        
MFA-TR*           (                                                             
MFA-TR*               :S-RETURN-CODE                                            
MFA-TR*              ,:S-APPL-RETURN-CODE                                       
MFA-TR*              ,:S-NO-OF-DAYS                                             
MFA-TR*              ,:S-STATE-TAX                                              
MFA-TR*              ,:S-CITY-TAX                                               
MFA-TR*              ,:S-OTHER-TAX                                              
MFA-TR*              ,:S-TOTAL-NET-UNITS                                        
MFA-TR*              ,:S-TOTAL-USAGE-CHRG                                       
MFA-TR*              ,:S-USAGE-CHRG                                             
MFA-TR*              ,:S-TOTAL-DEMAND-CHRG                                      
MFA-TR*              ,:S-DEMAND-CHRGS-CRDT                                      
MFA-TR*              ,:S-USAGE-CHRGS-CRDT                                       
MFA-TR*              ,:S-BASIC-FCLTY-CHRG                                       
MFA-TR*              ,:S-AGL-CHARGES                                            
MFA-TR*              ,:S-UNIT-PRICE-AMT                                         
MFA-TR*              ,:S-TOTAL-BILL-AMOUNT                                      
MFA-TR*              ,:S-REV-MONTH                                              
MFA-TR*              ,:S-RATE-PLAN                                              
MFA-TR*              ,:S-RATE-DESC                                              
MFA-TR*              ,:S-SVC-CAT                                                
MFA-TR*              ,:S-STATE-TAX-RATE                                         
MFA-TR*              ,:S-CITY-TAX-RATE                                          
MFA-TR*              ,:S-PARTIAL-XMPT-FL                                        
MFA-TR*              ,:S-RT-OVRD-BILL-CY                                        
MFA-TR*              ,:S-RT-OVRD-BILL-DT                                        
MFA-TR*              ,:S-RT-OVRD-REV-MTH                                        
MFA-TR*              ,:S-PRORTD-BILL-FL                                         
MFA-TR*              ,:S-READ-DATE                                              
MFA-TR*              ,:S-PRORTD-BY-DAYS-FL                                      
MFA-TR*           )                                                             
MFA-TR*       END-EXEC.                                                         

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

              MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.  
                                                                        
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR             
                 WS-ERR-INSRT-RS1      = 'Y'                            
                 ADD +1                      TO CTR-ROWS-RS1            
              ELSE                                                      
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE SQLCODE                TO ABEND-SQLCODE           
                 MOVE 'Y'                    TO WS-ERR-INSRT-RS1        
                 MOVE '8100A'                TO ACTIVE-PARAGRAPH        
                 MOVE 'INSERT'               TO ABEND-FUNCTION          
                 MOVE SPACES                 TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                 MOVE 'CSR04686_R1'          TO TABLE-1                 
                 MOVE SPACES                 TO TABLE-ELEMENT-1         
                 MOVE SPACES                 TO HOSTVAR-ELEMENT-1       
                 PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT            
              END-IF.                                                   
                                                                        
       8100A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8100B-INSERT-GTT-R2                                            *        
      ******************************************************************        
       8100B-INSERT-GTT-R2.                                             
            EXEC SQL                                                    
                 INSERT INTO #CSR04686_R2                        
                 (                                                      
                      RETURN_CODE                                       
                     ,APPL_RETURN_CODE                                  
                     ,FACTOR_DESC                                       
                     ,FACTOR_ID                                         
                     ,UNITS_BILLED                                      
                     ,NET_RATE                                          
                     ,COMPUTED_CHARGE                                   
                     ,COMPONENT_KEY                                     
                     ,SPCL_GROUP_CD                                     
                     ,FACTOR_TYPE                                       
                     ,ADJUST_ELEMENT                                    
                     ,CALC_TYPE_CD                                      
                     ,BLOCK_NO                                          
                  )                                                     
                  VALUES                                                
                  (                                                     
                      :S-RETURN-CODE                                    
                     ,:S-APPL-RETURN-CODE                               
                     ,:S-FACTOR-DESC                                    
                     ,:S-FACTOR-ID                                      
                     ,:S-UNITS-BILLED                                   
                     ,:S-NET-RATE                                       
                     ,:S-COMPUTED-CHARGE                                
                     ,:S-COMPONENT-KEY                                  
                     ,:S-SPCL-GRP-CD                                    
                     ,:S-FACTOR-TYPE                                    
                     ,:S-ADJUST-ELEMENT                                 
                     ,:S-CALC-TYPE-CD                                   
                     ,:S2-BLOCK-NO                                      
                  )                                                     
              END-EXEC.                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*          INSERT INTO SESSION.CSR04686_R2                                
MFA-TR*          (                                                              
MFA-TR*               RETURN_CODE                                               
MFA-TR*              ,APPL_RETURN_CODE                                          
MFA-TR*              ,FACTOR_DESC                                               
MFA-TR*              ,FACTOR_ID                                                 
MFA-TR*              ,UNITS_BILLED                                              
MFA-TR*              ,NET_RATE                                                  
MFA-TR*              ,COMPUTED_CHARGE                                           
MFA-TR*              ,COMPONENT_KEY                                             
MFA-TR*              ,SPCL_GROUP_CD                                             
MFA-TR*              ,FACTOR_TYPE                                               
MFA-TR*              ,ADJUST_ELEMENT                                            
MFA-TR*              ,CALC_TYPE_CD                                              
MFA-TR*              ,BLOCK_NO                                                  
MFA-TR*           )                                                             
MFA-TR*           VALUES                                                        
MFA-TR*           (                                                             
MFA-TR*               :S-RETURN-CODE                                            
MFA-TR*              ,:S-APPL-RETURN-CODE                                       
MFA-TR*              ,:S-FACTOR-DESC                                            
MFA-TR*              ,:S-FACTOR-ID                                              
MFA-TR*              ,:S-UNITS-BILLED                                           
MFA-TR*              ,:S-NET-RATE                                               
MFA-TR*              ,:S-COMPUTED-CHARGE                                        
MFA-TR*              ,:S-COMPONENT-KEY                                          
MFA-TR*              ,:S-SPCL-GRP-CD                                            
MFA-TR*              ,:S-FACTOR-TYPE                                            
MFA-TR*              ,:S-ADJUST-ELEMENT                                         
MFA-TR*              ,:S-CALC-TYPE-CD                                           
MFA-TR*              ,:S2-BLOCK-NO                                              
MFA-TR*           )                                                             
MFA-TR*       END-EXEC.                                                         

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

              MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.  
                                                                        
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR             
                 WS-ERR-INSRT-RS2      = 'Y'                            
                 ADD +1                      TO CTR-ROWS-RS2            
              ELSE                                                      
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE SQLCODE                TO ABEND-SQLCODE           
                 MOVE 'Y'                    TO WS-ERR-INSRT-RS2        
                 MOVE '8100B'                TO ACTIVE-PARAGRAPH        
                 MOVE 'INSERT'               TO ABEND-FUNCTION          
                 MOVE SPACES                 TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                 MOVE 'CSR04686_R2'          TO TABLE-1                 
                 MOVE SPACES                 TO TABLE-ELEMENT-1         
                 MOVE SPACES                 TO HOSTVAR-ELEMENT-1       
                 PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT           
              END-IF.                                                   
      *                                                                         
       8100B-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8100C-INSERT-GTT-R3                                            *        
      ******************************************************************        
       8100C-INSERT-GTT-R3.                                             
            EXEC SQL                                                    
                 INSERT INTO #CSR04686_R3                        
                 (                                                      
                      RETURN_CODE                                       
                     ,APPL_RETURN_CODE                                  
                     ,CHARGE_DESC                                       
                     ,FACTOR_ID                                         
                     ,CODE_ADJUST_TYPE                                  
                     ,COMPONENT_ID                                      
                     ,CODE_TOU                                          
                     ,CODE_SEASON                                       
                     ,SEAS_PRORATE_PCT                                  
                     ,NET_UNIT_SEL_RSN                                  
                     ,BTU_FACTOR                                        
                     ,WNA_FACTOR                                        
                     ,CONSUMPTION_TYPE                                  
                     ,REGISTER_TYPE                                     
                     ,RATE_VERSION                                      
                     ,UNITS_READ                                        
                     ,NET_UNITS                                         
                     ,BLOCK_NO                                          
                     ,BLOCK_SIZE                                        
                     ,UNITS_BILLED                                      
                     ,BASE_RATE                                         
                     ,NET_RATE                                          
                     ,PRICE_TYPE_CD                                     
                     ,COMPUTED_CHARGE                                   
                     ,INFO_ONLY_FLAG                                    
                     ,COMPONENT_KEY                                     
                  )                                                     
                  VALUES                                                
                  (                                                     
                      :S-RETURN-CODE                                    
                     ,:S-APPL-RETURN-CODE                               
                     ,:S-CHARGE-DESC                                    
                     ,:S-FACTOR-ID                                      
                     ,:S-CODE-ADJUST-TYPE                               
                     ,:S-COMPONENT-ID                                   
                     ,:S-CODE-TOU                                       
                     ,:S-CODE-SEASON                                    
                     ,:S-SEAS-PRORATE-PCT                               
                     ,:S-NET-UNIT-SEL-RSN                               
                     ,:S-BTU-FACTOR                                     
                     ,:S-WNA-FACTOR                                     
                     ,:S-CONSUMPTION-TYPE                               
                     ,:S-REGISTER-TYPE                                  
                     ,:S-RATE-VERSION                                   
                     ,:S-UNITS-READ                                     
                     ,:S-NET-UNITS                                      
                     ,:S-BLOCK-NO                                       
                     ,:S-BLOCK-SIZE                                     
                     ,:S-UNITS-BILLED                                   
                     ,:S-BASE-RATE                                      
                     ,:S-NET-RATE                                       
                     ,:S-PRICE-TYPE-CD                                  
                     ,:S-COMPUTED-CHARGE                                
                     ,:S-INFO-ONLY-FLAG                                 
                     ,:S-COMPONENT-KEY                                  
                  )                                                     
              END-EXEC.                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*          INSERT INTO SESSION.CSR04686_R3                                
MFA-TR*          (                                                              
MFA-TR*               RETURN_CODE                                               
MFA-TR*              ,APPL_RETURN_CODE                                          
MFA-TR*              ,CHARGE_DESC                                               
MFA-TR*              ,FACTOR_ID                                                 
MFA-TR*              ,CODE_ADJUST_TYPE                                          
MFA-TR*              ,COMPONENT_ID                                              
MFA-TR*              ,CODE_TOU                                                  
MFA-TR*              ,CODE_SEASON                                               
MFA-TR*              ,SEAS_PRORATE_PCT                                          
MFA-TR*              ,NET_UNIT_SEL_RSN                                          
MFA-TR*              ,BTU_FACTOR                                                
MFA-TR*              ,WNA_FACTOR                                                
MFA-TR*              ,CONSUMPTION_TYPE                                          
MFA-TR*              ,REGISTER_TYPE                                             
MFA-TR*              ,RATE_VERSION                                              
MFA-TR*              ,UNITS_READ                                                
MFA-TR*              ,NET_UNITS                                                 
MFA-TR*              ,BLOCK_NO                                                  
MFA-TR*              ,BLOCK_SIZE                                                
MFA-TR*              ,UNITS_BILLED                                              
MFA-TR*              ,BASE_RATE                                                 
MFA-TR*              ,NET_RATE                                                  
MFA-TR*              ,PRICE_TYPE_CD                                             
MFA-TR*              ,COMPUTED_CHARGE                                           
MFA-TR*              ,INFO_ONLY_FLAG                                            
MFA-TR*              ,COMPONENT_KEY                                             
MFA-TR*           )                                                             
MFA-TR*           VALUES                                                        
MFA-TR*           (                                                             
MFA-TR*               :S-RETURN-CODE                                            
MFA-TR*              ,:S-APPL-RETURN-CODE                                       
MFA-TR*              ,:S-CHARGE-DESC                                            
MFA-TR*              ,:S-FACTOR-ID                                              
MFA-TR*              ,:S-CODE-ADJUST-TYPE                                       
MFA-TR*              ,:S-COMPONENT-ID                                           
MFA-TR*              ,:S-CODE-TOU                                               
MFA-TR*              ,:S-CODE-SEASON                                            
MFA-TR*              ,:S-SEAS-PRORATE-PCT                                       
MFA-TR*              ,:S-NET-UNIT-SEL-RSN                                       
MFA-TR*              ,:S-BTU-FACTOR                                             
MFA-TR*              ,:S-WNA-FACTOR                                             
MFA-TR*              ,:S-CONSUMPTION-TYPE                                       
MFA-TR*              ,:S-REGISTER-TYPE                                          
MFA-TR*              ,:S-RATE-VERSION                                           
MFA-TR*              ,:S-UNITS-READ                                             
MFA-TR*              ,:S-NET-UNITS                                              
MFA-TR*              ,:S-BLOCK-NO                                               
MFA-TR*              ,:S-BLOCK-SIZE                                             
MFA-TR*              ,:S-UNITS-BILLED                                           
MFA-TR*              ,:S-BASE-RATE                                              
MFA-TR*              ,:S-NET-RATE                                               
MFA-TR*              ,:S-PRICE-TYPE-CD                                          
MFA-TR*              ,:S-COMPUTED-CHARGE                                        
MFA-TR*              ,:S-INFO-ONLY-FLAG                                         
MFA-TR*              ,:S-COMPONENT-KEY                                          
MFA-TR*           )                                                             
MFA-TR*       END-EXEC.                                                         

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

              MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.  
                                                                        
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR             
                 WS-ERR-INSRT-RS3      = 'Y'                            
                 ADD +1                      TO CTR-ROWS-RS3            
              ELSE                                                      
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE SQLCODE                TO ABEND-SQLCODE           
                 MOVE 'Y'                    TO WS-ERR-INSRT-RS3        
                 MOVE '8100C'                TO ACTIVE-PARAGRAPH        
                 MOVE 'INSERT'               TO ABEND-FUNCTION          
                 MOVE SPACES                 TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                 MOVE 'CSR04686_R3'          TO TABLE-1                 
                 MOVE SPACES                 TO TABLE-ELEMENT-1         
                 MOVE SPACES                 TO HOSTVAR-ELEMENT-1       
                 PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT            
              END-IF.                                                   
      *                                                                         
       8100C-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8100D-INSERT-GTT-R4                                            *        
      ******************************************************************        
       8100D-INSERT-GTT-R4.                                             
            EXEC SQL                                                    
                 INSERT INTO #CSR04686_R4                        
                 (                                                      
                      RETURN_CODE                                       
                     ,APPL_RETURN_CODE                                  
                     ,CHARGE_DESC                                       
                     ,FACTOR_ID                                         
                     ,CODE_ADJUST_TYPE                                  
                     ,COMPONENT_ID                                      
                     ,CODE_TOU                                          
                     ,CODE_SEASON                                       
                     ,RATE_VERSION                                      
                     ,UNITS_BILLED                                      
                     ,NET_RATE                                          
                     ,COMPUTED_CHARGE                                   
                     ,CONSUMPTION_TYPE                                  
                     ,COMPONENT_KEY                                     
                  )                                                     
                  VALUES                                                
                  (                                                     
                      :S-RETURN-CODE                                    
                     ,:S-APPL-RETURN-CODE                               
                     ,:S-CHARGE-DESC                                    
                     ,:S-FACTOR-ID                                      
                     ,:S-CODE-ADJUST-TYPE                               
                     ,:S-COMPONENT-ID                                   
                     ,:S-CODE-TOU                                       
                     ,:S-CODE-SEASON                                    
                     ,:S-RATE-VERSION                                   
                     ,:S-UNITS-BILLED                                   
                     ,:S-NET-RATE                                       
                     ,:S-COMPUTED-CHARGE                                
                     ,:S-CONSUMPTION-TYPE                               
                     ,:S-COMPONENT-KEY                                  
                  )                                                     
              END-EXEC.                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*          INSERT INTO SESSION.CSR04686_R4                                
MFA-TR*          (                                                              
MFA-TR*               RETURN_CODE                                               
MFA-TR*              ,APPL_RETURN_CODE                                          
MFA-TR*              ,CHARGE_DESC                                               
MFA-TR*              ,FACTOR_ID                                                 
MFA-TR*              ,CODE_ADJUST_TYPE                                          
MFA-TR*              ,COMPONENT_ID                                              
MFA-TR*              ,CODE_TOU                                                  
MFA-TR*              ,CODE_SEASON                                               
MFA-TR*              ,RATE_VERSION                                              
MFA-TR*              ,UNITS_BILLED                                              
MFA-TR*              ,NET_RATE                                                  
MFA-TR*              ,COMPUTED_CHARGE                                           
MFA-TR*              ,CONSUMPTION_TYPE                                          
MFA-TR*              ,COMPONENT_KEY                                             
MFA-TR*           )                                                             
MFA-TR*           VALUES                                                        
MFA-TR*           (                                                             
MFA-TR*               :S-RETURN-CODE                                            
MFA-TR*              ,:S-APPL-RETURN-CODE                                       
MFA-TR*              ,:S-CHARGE-DESC                                            
MFA-TR*              ,:S-FACTOR-ID                                              
MFA-TR*              ,:S-CODE-ADJUST-TYPE                                       
MFA-TR*              ,:S-COMPONENT-ID                                           
MFA-TR*              ,:S-CODE-TOU                                               
MFA-TR*              ,:S-CODE-SEASON                                            
MFA-TR*              ,:S-RATE-VERSION                                           
MFA-TR*              ,:S-UNITS-BILLED                                           
MFA-TR*              ,:S-NET-RATE                                               
MFA-TR*              ,:S-COMPUTED-CHARGE                                        
MFA-TR*              ,:S-CONSUMPTION-TYPE                                       
MFA-TR*              ,:S-COMPONENT-KEY                                          
MFA-TR*           )                                                             
MFA-TR*       END-EXEC.                                                         

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

              MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.  
                                                                        
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR             
                 WS-ERR-INSRT-RS4      = 'Y'                            
                 ADD +1                      TO CTR-ROWS-RS4            
              ELSE                                                      
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE SQLCODE                TO ABEND-SQLCODE           
                 MOVE 'Y'                    TO WS-ERR-INSRT-RS4        
                 MOVE '8100D'                TO ACTIVE-PARAGRAPH        
                 MOVE 'INSERT'               TO ABEND-FUNCTION          
                 MOVE SPACES                 TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                 MOVE 'CSR04686_R4'          TO TABLE-1                 
                 MOVE SPACES                 TO TABLE-ELEMENT-1         
                 MOVE SPACES                 TO HOSTVAR-ELEMENT-1       
                 PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT            
              END-IF.                                                   
      *                                                                         
       8100D-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8100E-INSERT-GTT-R5                                            *        
      ******************************************************************        
       8100E-INSERT-GTT-R5.                                             
            EXEC SQL                                                    
                 INSERT INTO #CSR04686_R5                        
                 (                                                      
                      RETURN_CODE                                       
                     ,APPL_RETURN_CODE                                  
                     ,BUS_RULE_ID                                       
                     ,BUS_RULE_RESULT_CD                                
                     ,BUS_RULE_XREF_ID                                  
                     ,MESSAGE_PARMS                                     
                     ,LINK_PARMS                                        
                     ,COMPONENT_KEY                                     
                  )                                                     
                  VALUES                                                
                  (                                                     
                      :S5-RETURN-CODE                                   
                     ,:S5-APPL-RETURN-CODE                              
                     ,:S5-BUS-RULE-ID                                   
                     ,:S5-BUS-RULE-RESULT-CD                            
                     ,:S5-BUS-RULE-XREF-ID                              
                     ,:S5-MESSAGE-PARMS                                 
                     ,:S5-LINK-PARMS                                    
                     ,:S5-COMPONENT-KEY                                 
                  )                                                     
              END-EXEC.                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*          INSERT INTO SESSION.CSR04686_R5                                
MFA-TR*          (                                                              
MFA-TR*               RETURN_CODE                                               
MFA-TR*              ,APPL_RETURN_CODE                                          
MFA-TR*              ,BUS_RULE_ID                                               
MFA-TR*              ,BUS_RULE_RESULT_CD                                        
MFA-TR*              ,BUS_RULE_XREF_ID                                          
MFA-TR*              ,MESSAGE_PARMS                                             
MFA-TR*              ,LINK_PARMS                                                
MFA-TR*              ,COMPONENT_KEY                                             
MFA-TR*           )                                                             
MFA-TR*           VALUES                                                        
MFA-TR*           (                                                             
MFA-TR*               :S5-RETURN-CODE                                           
MFA-TR*              ,:S5-APPL-RETURN-CODE                                      
MFA-TR*              ,:S5-BUS-RULE-ID                                           
MFA-TR*              ,:S5-BUS-RULE-RESULT-CD                                    
MFA-TR*              ,:S5-BUS-RULE-XREF-ID                                      
MFA-TR*              ,:S5-MESSAGE-PARMS                                         
MFA-TR*              ,:S5-LINK-PARMS                                            
MFA-TR*              ,:S5-COMPONENT-KEY                                         
MFA-TR*           )                                                             
MFA-TR*       END-EXEC.                                                         

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

              MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.  
                                                                        
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR             
                 WS-ERR-INSRT-RS5      = 'Y'                            
                 ADD +1                      TO CTR-ROWS-RS5            
              ELSE                                                      
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE SQLCODE                TO ABEND-SQLCODE           
                 MOVE 'Y'                    TO WS-ERR-INSRT-RS5        
                 MOVE '8100E'                TO ACTIVE-PARAGRAPH        
                 MOVE 'INSERT'               TO ABEND-FUNCTION          
                 MOVE SPACES                 TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                 MOVE 'CSR04686_R5'          TO TABLE-1                 
                 MOVE SPACES                 TO TABLE-ELEMENT-1         
                 MOVE SPACES                 TO HOSTVAR-ELEMENT-1       
                 PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT            
              END-IF.                                                   
      *                                                                         
       8100E-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8200-CLOSE-CNSMPTN-HIST.                                       *        
      ******************************************************************        
       8200-CLOSE-CNSMPTN-HIST.                                         
                                                                        
              EXEC SQL                                                  
                   CLOSE CNSMPTN_HIST                                   
              END-EXEC.                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
              MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.  
                                                                        
              IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL         
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE '8200'                 TO ACTIVE-PARAGRAPH        
                 MOVE 'CLOSE'                TO ABEND-FUNCTION          
                 MOVE 'CSS_CNSMPTN_HIST'     TO TABLE-1                 
                 MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1         
                 MOVE 'BILL_NO'              TO TABLE-ELEMENT-2         
                 MOVE 'CODE_UTIL_TYPE'       TO TABLE-ELEMENT-3         
                 MOVE 'IC_NO'                TO TABLE-ELEMENT-4         
                 MOVE WS-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1       
                 MOVE WS-BILL-NO             TO HOSTVAR-ELEMENT-2       
                 MOVE WS-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-3       
                 MOVE WS-IC-NO               TO HOSTVAR-ELEMENT-4       
                 PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT
              END-IF.           
      *                                                                         
          8200-EXIT.                                                    
              EXIT.                                                     
      *                                                                         
      ******************************************************************        
      * 8210-CLOSE-FIXED-FCT-HIST.                                     *        
      ******************************************************************        
       8210-CLOSE-FIXED-FCT-HIST.                                       
                                                                        
              EXEC SQL                                                  
                   CLOSE FIXED_FCT_HIST                                 
              END-EXEC.                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
              MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.  
                                                                        
              IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL         
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE '8210'                 TO ACTIVE-PARAGRAPH        
                 MOVE 'CLOSE'                TO ABEND-FUNCTION          
                 MOVE 'CSS_FIXED_FCT_HIST'   TO TABLE-1                 
                 MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1         
                 MOVE 'BILL_NO'              TO TABLE-ELEMENT-2         
                 MOVE 'IC_NO'                TO TABLE-ELEMENT-3         
                 MOVE 'CODE_UTIL_TYPE'       TO TABLE-ELEMENT-4         
                 MOVE WS-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1       
                 MOVE WS-BILL-NO             TO HOSTVAR-ELEMENT-2       
                 MOVE WS-IC-NO               TO HOSTVAR-ELEMENT-3       
                 MOVE WS-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-4       
                 PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT
              END-IF.           
      *                                                                         
          8210-EXIT.                                                    
              EXIT.                                                     
      *                                                                         
      ******************************************************************        
      * 8220-CLOSE-UNMTRD-CNSMPTN.                                     *        
      ******************************************************************        
                                                                        
       8220-CLOSE-UNMTRD-CNSMPTN.                                       
                                                                        
              EXEC SQL                                                  
                   CLOSE UM_CNSMPT_HIST                                 
              END-EXEC.                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
              MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.  
                                                                        
              IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL         
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE '8220'                 TO ACTIVE-PARAGRAPH        
                 MOVE 'CLOSE'                TO ABEND-FUNCTION          
                 MOVE 'CSS_UM_CNSMPT_HIST'   TO TABLE-1                 
                 MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1         
                 MOVE 'BILL_NO'              TO TABLE-ELEMENT-2         
                 MOVE 'IC_NO'                TO TABLE-ELEMENT-3         
                 MOVE 'CODE_UTIL_TYPE'       TO TABLE-ELEMENT-4         
                 MOVE WS-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1       
                 MOVE WS-BILL-NO             TO HOSTVAR-ELEMENT-2       
                 MOVE WS-IC-NO               TO HOSTVAR-ELEMENT-3       
                 MOVE WS-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-4       
                 PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT
              END-IF.           
      *                                                                         
          8220-EXIT.                                                    
              EXIT.                                                     
      *                                                                         
      ******************************************************************        
      * 8230-CLOSE-BILLING-DET.                                        *        
      ******************************************************************        
       8230-CLOSE-BILLING-DET.                                          
                                                                        
              EXEC SQL                                                  
                   CLOSE BILLING_DET                                    
              END-EXEC.                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
              MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.  
                                                                        
              IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL         
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE '8230'                 TO ACTIVE-PARAGRAPH        
                 MOVE 'CLOSE'                TO ABEND-FUNCTION          
                 MOVE 'CSS_BILLING_DET'      TO TABLE-1                 
                 MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1         
                 MOVE 'BILL_NO'              TO TABLE-ELEMENT-2         
                 MOVE 'IC_NO'                TO TABLE-ELEMENT-3         
                 MOVE 'CODE_UTIL_TYPE'       TO TABLE-ELEMENT-4         
                 MOVE WS-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1       
                 MOVE WS-BILL-NO             TO HOSTVAR-ELEMENT-2       
                 MOVE WS-IC-NO               TO HOSTVAR-ELEMENT-3       
                 MOVE WS-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-4       
                 PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT
              END-IF.           
      *                                                                         
       8230-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   PERFORM FETCH ON CSS_CUST_PLAN TO DETERMINE IF WE ARE DEALING         
      *   WITH UNMETERED CONSUMPTION OR CONSUMPTION HISTORY                     
      ******************************************************************        
                                                                        
       8240-CHECK-CUST-PLAN.                                            
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) POLE_NO                                           
                 INTO :CP-POLE-NO                                       
                 FROM CSS_CUST_PLAN WITH(READUNCOMMITTED)                       
                WHERE ACCOUNT_NO     = :CP-ACCOUNT-NO                   
                  AND CODE_UTIL_TYPE = :CP-CODE-UTIL-TYPE               
                  AND IC_NO          = :CP-IC-NO                        
                                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT POLE_NO                                                   
MFA-TR*          INTO :CP-POLE-NO                                               
MFA-TR*          FROM CSS_CUST_PLAN                                             
MFA-TR*         WHERE ACCOUNT_NO     = :CP-ACCOUNT-NO                           
MFA-TR*           AND CODE_UTIL_TYPE = :CP-CODE-UTIL-TYPE                       
MFA-TR*           AND IC_NO          = :CP-IC-NO                                
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                RS-RETURN-CODE          
                                                GWL-RC.                 
           IF WS-ACTIVE-RETURN-CODE EQUAL    TO SUCCESSFUL-CALL         
              SET HAS-CUST-PLAN              TO TRUE                    
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL TO NOT-FOUND               
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE '8240'                 TO ACTIVE-PARAGRAPH        
                 MOVE 'FETCH'                TO ABEND-FUNCTION          
                 MOVE 'CSS_CUST_PLAN'        TO TABLE-1                 
                 MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1         
                 MOVE 'CODE_UTIL_TYPE'       TO TABLE-ELEMENT-2         
                 MOVE 'IC_NO'                TO TABLE-ELEMENT-3         
                 MOVE CP-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1       
                 MOVE CP-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-2       
                 MOVE CP-IC-NO               TO HOSTVAR-ELEMENT-3       
                 PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT
              END-IF
           END-IF.           
      *                                                                         
       8240-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   RETRIEVE CODE_BILL_STATUS FROM CSS_BILLING_HDR TABLE                  
      ******************************************************************        
                                                                        
       8250-GET-BILL-STATUS.                                            
                                                                        
           EXEC SQL                                                     
               SELECT BI.CODE_BILL_STATUS                               
                     ,BI.DATE_BILLED                                    
                 INTO :BI-CODE-BILL-STATUS                              
                     ,:BI-DATE-BILLED :WS-NULL-IND-10                   
                 FROM CSS_BILLING_HDR BI                                
                WHERE ACCOUNT_NO     = :BI-ACCOUNT-NO                   
                  AND BILL_NO        = :BI-BILL-NO                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                RS-RETURN-CODE.         
           IF WS-ACTIVE-RETURN-CODE EQUAL    TO SUCCESSFUL-CALL         
              IF WS-NULL-IND-10 < ZERO                                  
                 MOVE SPACES                 TO BI-DATE-BILLED          
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8250'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_BILLING_HDR'         TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'BILL_NO'                 TO TABLE-ELEMENT-2         
              MOVE BI-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE BI-BILL-NO                TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT
           END-IF.           
      *                                                                         
       8250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************                                  
      *  SELECTS COMPANY_NO FROM CSS_ACCOUNT *                                  
      ****************************************                                  
       8260-SELECT-COMPANY-NO.                                          
           EXEC SQL                                                     
              SELECT AT.COMPANY_NO                                      
                    ,AT.CODE_ACCT_STAT                                  
                    ,AT.BILL_CYCLE                                      
                    ,AT.REV_MTH_LST_NRML                                
                    ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           AT.ACCT_FINALED_DT, 121), ' ', '-'), ':', '.') 
           ACCT_FINALED_DT                                 
                INTO :AT-COMPANY-NO                                     
                    ,:AT-CODE-ACCT-STAT                                 
                    ,:AT-BILL-CYCLE                                     
                    ,:AT-REV-MTH-LST-NRML                               
                    ,:AT-ACCT-FINALED-DT :WS-NULL-IND-10                
                FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT AT.COMPANY_NO                                              
MFA-TR*             ,AT.CODE_ACCT_STAT                                          
MFA-TR*             ,AT.BILL_CYCLE                                              
MFA-TR*             ,AT.REV_MTH_LST_NRML                                        
MFA-TR*             ,AT.ACCT_FINALED_DT                                         
MFA-TR*         INTO :AT-COMPANY-NO                                             
MFA-TR*             ,:AT-CODE-ACCT-STAT                                         
MFA-TR*             ,:AT-BILL-CYCLE                                             
MFA-TR*             ,:AT-REV-MTH-LST-NRML                                       
MFA-TR*             ,:AT-ACCT-FINALED-DT :WS-NULL-IND-10                        
MFA-TR*         FROM CSS_ACCOUNT AT                                             
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF WS-NULL-IND-10 < ZERO                                  
                 MOVE LOW-VALUES             TO AT-ACCT-FINALED-DT      
              END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8260'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_ACCOUNT'             TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       8260-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8270-OPEN-CUST-PLAN.                                           *        
      ******************************************************************        
       8270-OPEN-CUST-PLAN.                                             
                                                                        
              EXEC SQL                                                  
                   OPEN CUST_PLAN_CSR                                   
              END-EXEC.                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
              MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.  
                                                                        
              IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL         
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE '8270'                 TO ACTIVE-PARAGRAPH        
                 MOVE 'OPEN'                 TO ABEND-FUNCTION          
                 MOVE 'CSS_CUST_PLAN'        TO TABLE-1                 
                 MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1         
                 MOVE 'CODE_UTIL_TYPE'       TO TABLE-ELEMENT-2         
                 MOVE WS-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1       
                 MOVE WS-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-2       
                 PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT
              END-IF.           
                                                                        
          8270-EXIT.                                                    
              EXIT.                                                     
                                                                        
      ******************************************************************        
      * 8280-FETCH-CUST-PLAN.                                          *        
      ******************************************************************        
       8280-FETCH-CUST-PLAN.                                            
                                                                        
              EXEC SQL                                                  
                 FETCH CUST_PLAN_CSR  INTO                              
                   :CP-ACCOUNT-NO                                       
                  ,:CP-CODE-UTIL-TYPE                                   
                  ,:CP-IC-NO                                            
                  ,:CP-RATE-ITEM-CODE                                   
                  ,:CP-ITEM-SEQ-NO                                      
                  ,:CP-CODE-PLAN-STATUS                                 
                  ,:CP-CODE-STAT-REASON                                 
                  ,:CP-DATE-PLAN-START :WS-NULL-IND-1                   
                  ,:CP-CODE-SERVICE-TYPE                                
                  ,:CP-USAGE-FIXED                                      
                  ,:CP-MTHLY-AMOUNT-FIXED                               
                  ,:CP-NO-UNITS                                         
                  ,:CP-REMOVE-DATE :WS-NULL-IND-2                       
                  ,:CP-DIST-NO                                          
                  ,:CP-POLE-NO                                          
                  ,:CP-LIGHT-NO                                         
                  ,:CP-LAST-BILL-DATE :WS-NULL-IND-3                    
          END-EXEC.                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

              MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.  
                                                                        
              IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL OR      
                                                NOT-FOUND               
                 IF WS-NULL-IND-1 < ZERO                                
                     MOVE LOW-VALUES         TO CP-DATE-PLAN-START      
                 END-IF                                                 
                 IF WS-NULL-IND-2 < ZERO                                
                     MOVE LOW-VALUES         TO CP-REMOVE-DATE          
                 END-IF                                                 
                 IF WS-NULL-IND-3 < ZERO                                
                     MOVE LOW-VALUES         TO CP-LAST-BILL-DATE       
                 END-IF                                                 
              ELSE                                                      
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE '8280'                 TO ACTIVE-PARAGRAPH        
                 MOVE 'FETCH'                TO ABEND-FUNCTION          
                 MOVE 'CSS_CUST_PLAN'        TO TABLE-1                 
                 MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1         
                 MOVE 'CODE_UTIL_TYPE'       TO TABLE-ELEMENT-2         
                 MOVE WS-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1       
                 MOVE WS-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-2       
                 PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT
              END-IF.           
      *                                                                         
          8280-EXIT.                                                    
              EXIT.                                                     
      *                                                                         
      ******************************************************************        
      * 8290-CLOSE-CUST-PLAN.                                          *        
      ******************************************************************        
       8290-CLOSE-CUST-PLAN.                                            
      *                                                                         
           EXEC SQL                                                     
               CLOSE CUST_PLAN_CSR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL    TO SUCCESSFUL-CALL         
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8290'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE 'CSS_CUST_PLAN'           TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE WS-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE WS-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT
           END-IF.           
                                                                        
       8290-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8300-GET-UM-TEXT                                               *        
      ******************************************************************        
       8300-GET-UM-TEXT.                                                
                                                                        
           MOVE WS-BC-COMPONENT-CODE (BC-INDX) (2:2)                    
                                             TO L9-UM-EQUIP-ID          
                                                                        
           EXEC SQL                                                     
              SELECT UM_EQUIP_SHRT_DESC                                 
                INTO :L9-UM-EQUIP-SHRT-DESC                             
                FROM CSS_UM_EQUIPMENT WITH(READUNCOMMITTED)                     
                WHERE UM_EQUIP_ID = :L9-UM-EQUIP-ID                     
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT UM_EQUIP_SHRT_DESC                                         
MFA-TR*         INTO :L9-UM-EQUIP-SHRT-DESC                                     
MFA-TR*         FROM CSS_UM_EQUIPMENT                                           
MFA-TR*         WHERE UM_EQUIP_ID = :L9-UM-EQUIP-ID                             
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE NOT = ZERO                                        
              MOVE 'NO DESCRIPTION AVAILABLE'                           
                                             TO L9-UM-EQUIP-SHRT-DESC   
           END-IF.                                                      
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL    TO SUCCESSFUL-CALL OR      
                                              NOT-FOUND                 
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8300'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_UM_EQUIPMENT'        TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'UM_EQUIP_ID'             TO TABLE-ELEMENT-2         
              MOVE WS-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE L9-UM-EQUIP-ID            TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT
           END-IF.           
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8400-GET-FACTOR-TEXT.                                          *        
      ******************************************************************        
       8400-GET-FACTOR-TEXT.                                            
                                                                        
           MOVE WS-BC-FACTOR-ID (BA-INDX)    TO SF-FACTOR-ID.           
                                                                        
           EXEC SQL                                                     
              SELECT FACTOR_DESC                                        
                    ,FACTOR_TYPE                                        
                    ,ADJUST_ELEMENT                                     
                    ,CALC_TYPE_CD                                       
                INTO :SF-FACTOR-DESC                                    
                    ,:SF-FACTOR-TYPE                                    
                    ,:SF-ADJUST-ELEMENT                                 
                    ,:SF-CALC-TYPE-CD                                   
                FROM CSS_SPCL_FCTR WITH(READUNCOMMITTED)                        
                WHERE FACTOR_ID = :SF-FACTOR-ID                         
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT FACTOR_DESC                                                
MFA-TR*             ,FACTOR_TYPE                                                
MFA-TR*             ,ADJUST_ELEMENT                                             
MFA-TR*             ,CALC_TYPE_CD                                               
MFA-TR*         INTO :SF-FACTOR-DESC                                            
MFA-TR*             ,:SF-FACTOR-TYPE                                            
MFA-TR*             ,:SF-ADJUST-ELEMENT                                         
MFA-TR*             ,:SF-CALC-TYPE-CD                                           
MFA-TR*         FROM CSS_SPCL_FCTR                                              
MFA-TR*         WHERE FACTOR_ID = :SF-FACTOR-ID                                 
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE NOT = ZERO                                        
              MOVE 'NO DESCRIPTION AVAILABLE'                           
                                             TO SF-FACTOR-DESC          
              MOVE SPACES                    TO SF-FACTOR-TYPE          
                                                SF-ADJUST-ELEMENT       
                                                SF-CALC-TYPE-CD         
           END-IF.                                                      
                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL    TO SUCCESSFUL-CALL OR      
                                              NOT-FOUND                 
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8400'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SPCL_FCTR'           TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'FACTOR_ID'               TO TABLE-ELEMENT-2         
              MOVE WS-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE SF-FACTOR-ID              TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT
           END-IF.           
      *                                                                         
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8500-OPEN-MTRD-ENVRNMT.                                                 
      ******************************************************************        
       8500-OPEN-MTRD-ENVRNMT.                                          
                                                                        
           EXEC SQL                                                     
                OPEN MTRD_ENVRNMT                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL    TO SUCCESSFUL-CALL         
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8500'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'CSS_MTRD_ENVRNMT'        TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE 'IC_NO'                   TO TABLE-ELEMENT-3         
              MOVE WS-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE WS-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              MOVE WS-IC-NO                  TO HOSTVAR-ELEMENT-3       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT
           END-IF.           
      *                                                                         
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8510-FETCH-MTRD-ENVRNMT.                                                
      ******************************************************************        
       8510-FETCH-MTRD-ENVRNMT.                                         
           EXEC SQL                                                     
                FETCH MTRD_ENVRNMT INTO                                 
                   :MN-ACCOUNT-NO,                                      
                   :MN-CODE-UTIL-TYPE,                                  
                   :MN-IC-NO,                                           
                   :MN-MTR-REF-NO,                                      
                   :MN-CODE-TIME-PERIOD,                                
                   :MN-METER-NO,                                        
                   :MN-CODE-DISCOUNT,                                   
                   :MN-CODE-METER-LOC,                                  
                   :MN-CODE-METER-STATUS,                               
                   :MN-CODE-STATUS-REAS,                                
                   :MN-CODE-ALRT-CHNG-IND,                              
                   :MN-DIST-NODE-POINT,                                 
                   :MN-CODE-DIVERSION,                                  
                   :MN-DATE-MTR-INSTALL :WS-NULL-IND-1,                 
                   :MN-CODE-SPCL-SEAL,                                  
                   :MN-EST-USAGE,                                       
                   :MN-SPCL-MTR-CONDITION,                              
                   :MN-CODE-DATA-PRESENT,                               
                   :MN-CODE-USAGE-TYPE,                                 
                   :MN-CODE-USAGE-ID,                                   
                   :MN-CODE-USAGE-SOURCE,                               
                   :MN-REG-ID-NO,                                       
                   :MN-REGISTER-RD-SEQ,                                 
                   :MN-CODE-CRNT-REG-READ,                              
                   :MN-CODE-NO-RD-REASON,                               
                   :MN-CODE-LAST-REG-READ,                              
                   :MN-LAST-REG-READ-TIME :WS-NULL-IND-3,               
                   :MN-LAST-REG-READ-DATE :WS-NULL-IND-4,               
                   :MN-LAST-READ-VALUE,                                 
                   :MN-NO-CONSEC-CRD-READ,                              
                   :MN-NO-CONSEC-ESTIMATE,                              
                   :MN-POINT-ID,                                        
                   :MN-LOCK-TYPE-ID,                                    
                   :MN-SEAL-CODE-ID,                                    
                   :MN-HEXAGRAM-LOCATION,                               
                   :MN-INSULATED-IND,                                   
                   :MN-METER-SUPPLYING,                                 
                   :MN-LAST-VALID-READ-TM :WS-NULL-IND-5,               
                   :MN-LAST-VALID-READ-DT :WS-NULL-IND-6,               
                   :MN-READ-CARD-PRINT-DT :WS-NULL-IND-7,               
                   :MN-EXCEPT-OVERRIDE-CD,                              
                   :MN-CODE-MTR-RD-INST1,                               
                   :MN-CODE-MTR-RD-INST2,                               
                   :MN-CODE-MTR-RD-INST3,                               
                   :MN-DIGTL-MTR-TYPE,                                  
                   :MN-LAST-UPDATE-TS :WS-NULL-IND-8,                   
                   :MN-LAST-VAL-RD-VALUE,                               
                   :MN-CODE-LAST-VALID-RD,                              
                   :MN-REMOTE-READ-IND,                                 
                   :MN-MTR-READ-SOURCE-CD,                              
                   :MN-UTILITY-SOURCE-CD,                               
                   :MN-DELIVERY-LEVEL-CD,                               
                   :MN-MTR-STATUS-CHNG-DT :WS-NULL-IND-9                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
           IF WS-ACTIVE-RETURN-CODE EQUAL    TO SUCCESSFUL-CALL         
                                          OR NOT-FOUND                  
               IF WS-NULL-IND-1 < ZERO                                  
                   MOVE LOW-VALUES           TO   MN-DATE-MTR-INSTALL   
               END-IF                                                   
               IF WS-NULL-IND-3 < ZERO                                  
                   MOVE LOW-VALUES           TO   MN-LAST-REG-READ-TIME 
               END-IF                                                   
               IF WS-NULL-IND-4 < ZERO                                  
                   MOVE LOW-VALUES           TO   MN-LAST-REG-READ-DATE 
               END-IF                                                   
               IF WS-NULL-IND-5 < ZERO                                  
                   MOVE LOW-VALUES           TO   MN-LAST-VALID-READ-TM 
               END-IF                                                   
               IF WS-NULL-IND-6 < ZERO                                  
                   MOVE LOW-VALUES           TO   MN-LAST-VALID-READ-DT 
               END-IF                                                   
               IF WS-NULL-IND-7 < ZERO                                  
                   MOVE LOW-VALUES           TO   MN-READ-CARD-PRINT-DT 
               END-IF                                                   
               IF WS-NULL-IND-8 < ZERO                                  
                   MOVE LOW-VALUES           TO   MN-LAST-UPDATE-TS     
               END-IF                                                   
               IF WS-NULL-IND-9 < ZERO                                  
                   MOVE LOW-VALUES           TO   MN-MTR-STATUS-CHNG-DT 
               END-IF                                                   
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8510'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE 'CSS_MTRD_ENVRNMT'        TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE 'IC_NO'                   TO TABLE-ELEMENT-3         
              MOVE WS-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE WS-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              MOVE WS-IC-NO                  TO HOSTVAR-ELEMENT-3       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       8510-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8520-CLOSE-MTRD-ENVRNMT.                                                
      ******************************************************************        
       8520-CLOSE-MTRD-ENVRNMT.                                         
                                                                        
           EXEC SQL                                                     
                CLOSE MTRD_ENVRNMT                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
           IF WS-ACTIVE-RETURN-CODE EQUAL    TO SUCCESSFUL-CALL         
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8520'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE 'CSS_MTRD_ENVRNMT'        TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE 'IC_NO'                   TO TABLE-ELEMENT-3         
              MOVE WS-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE WS-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              MOVE WS-IC-NO                  TO HOSTVAR-ELEMENT-3       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       8520-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************                                  
      *  SELECTS COMPANY_NO FROM CSS_ACCOUNT *                                  
      ****************************************                                  
       8530-SELECT-DATE-BILLED.                                         
           EXEC SQL                                                     
              SELECT BI.DATE_BILLED                                     
                INTO :BI-DATE-BILLED :WS-NULL-IND-10                    
                FROM CSS_BILLING_HDR BI WITH(READUNCOMMITTED)                   
               WHERE BI.ACCOUNT_NO = :BI-ACCOUNT-NO                     
                 AND BI.BILL_NO    = :BI-BILL-NO                        
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BI.DATE_BILLED                                             
MFA-TR*         INTO :BI-DATE-BILLED :WS-NULL-IND-10                            
MFA-TR*         FROM CSS_BILLING_HDR BI                                         
MFA-TR*        WHERE BI.ACCOUNT_NO = :BI-ACCOUNT-NO                             
MFA-TR*          AND BI.BILL_NO    = :BI-BILL-NO                                
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF WS-NULL-IND-10 < ZERO                                  
                 MOVE SPACES                 TO BI-DATE-BILLED          
              END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8530'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_BILLING_HDR'         TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'BILL_NO'                 TO TABLE-ELEMENT-2         
              MOVE BI-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE BI-BILL-NO                TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       8530-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8600- SELECT-DELINQUENCY                                       *        
      ******************************************************************        
       8600-SELECT-DELINQUENCY.                                         
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE DELINQ_CD  = :C8-DELINQ-CD                         
                 AND COMPANY_NO = :AT-COMPANY-NO                        
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD  = :C8-DELINQ-CD                                 
MFA-TR*          AND COMPANY_NO = :AT-COMPANY-NO                                
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
           IF WS-ACTIVE-RETURN-CODE EQUAL    TO SUCCESSFUL-CALL         
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8600'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_DELINQUENCY'         TO TABLE-1                 
              MOVE 'DELINQ_CD'               TO TABLE-ELEMENT-1         
              MOVE C8-DELINQ-CD              TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       8600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * GET REVENUE MONTH FROM CSS_BILL_WINDOW TABLE USING             *        
      * AT-BILL-CYCLE & WS-COMMON-DATE                                 *        
      ******************************************************************        
       8640-GET-BILLWINDOW-REV-MTH.                                     
                                                                        
            EXEC SQL                                                    
               SELECT REVENUE_MONTH                                     
                 INTO :BN-REVENUE-MONTH                                 
                 FROM CSS_BILL_WINDOW  BN WITH(READUNCOMMITTED)                 
                WHERE BN.BILL_CYCLE     = :AT-BILL-CYCLE                
                  AND BN.DATE_EXTRACT   = IIF(TRY_CONVERT(DATE, 
                                                        :WS-COMMON-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-COMMON-DATE
              ) <> 0) OR (LEN(:WS-COMMON-DATE) <> 10), CIS.CHAR2DATE(
                                                        :WS-COMMON-DATE
              ), CONVERT(DATE, :WS-COMMON-DATE) )               
                                                                 
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*     EXEC SQL                                                            
MFA-TR*        SELECT REVENUE_MONTH                                             
MFA-TR*          INTO :BN-REVENUE-MONTH                                         
MFA-TR*          FROM CSS_BILL_WINDOW  BN                                       
MFA-TR*         WHERE BN.BILL_CYCLE     = :AT-BILL-CYCLE                        
MFA-TR*           AND BN.DATE_EXTRACT   = :WS-COMMON-DATE                       
MFA-TR*        WITH UR                                                          
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL    TO SUCCESSFUL-CALL         
                                          OR NOT-FOUND                  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8640'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_BILL_WINDOW'         TO TABLE-1                 
              MOVE 'BILL_CYCLE'              TO TABLE-ELEMENT-1         
              MOVE 'DATE_EXTRACT'            TO TABLE-ELEMENT-2         
              MOVE  AT-BILL-CYCLE            TO HOSTVAR-ELEMENT-1       
              MOVE  WS-COMMON-DATE           TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       8640-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * GET MIN REVENUE MONTH FOR THE EXTRACT DATE = COMMON DATE       *        
      ******************************************************************        
       8645-GET-MIN-REVMTH.                                             
                                                                        
            EXEC SQL                                                    
               SELECT COALESCE(MIN(REVENUE_MONTH),0)                      
                 INTO :BN-REVENUE-MONTH                                 
                 FROM CSS_BILL_WINDOW  BN WITH(READUNCOMMITTED)                 
                WHERE BN.DATE_EXTRACT = IIF(TRY_CONVERT(DATE, 
                                                        :WS-COMMON-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-COMMON-DATE
              ) <> 0) OR (LEN(:WS-COMMON-DATE) <> 10), CIS.CHAR2DATE(
                                                        :WS-COMMON-DATE
              ), CONVERT(DATE, :WS-COMMON-DATE) )                 
                                                                 
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*     EXEC SQL                                                            
MFA-TR*        SELECT IFNULL(MIN(REVENUE_MONTH),0)                              
MFA-TR*          INTO :BN-REVENUE-MONTH                                         
MFA-TR*          FROM CSS_BILL_WINDOW  BN                                       
MFA-TR*         WHERE BN.DATE_EXTRACT = :WS-COMMON-DATE                         
MFA-TR*          WITH UR                                                        
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL    TO SUCCESSFUL-CALL         
                                          OR NOT-FOUND                  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8645'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_BILL_WINDOW'         TO TABLE-1                 
              MOVE 'DATE_EXTRACT'            TO TABLE-ELEMENT-1         
              MOVE  WS-COMMON-DATE           TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       8645-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *        8650-SELECT-REVENUE MONTH FROM CSS_JOB_PARM             *        
      *                                                                         
      * ****************************************************************        
       8650-SELECT-REVENUE-MONTH.                                       
            EXEC SQL                                                    
               SELECT CIS.SUBSTR3(PARM_DATA,15,6)                            
                 INTO :WS-CURR-REVENUE-MTH-A                            
                 FROM CSS_JOB_PARM WITH(READUNCOMMITTED)                        
                WHERE PROGRAM_NAME   = 'COMMON'                         
                  AND CMND_CODE      = 'DATE'                           
                  AND SEQ_NO         =  20                              
                  AND STATUS         = 'A'                              
                  AND COMPANY_NO     = '01'                             
                                                                 
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*     EXEC SQL                                                            
MFA-TR*        SELECT SUBSTR(PARM_DATA,15,6)                                    
MFA-TR*          INTO :WS-CURR-REVENUE-MTH-A                                    
MFA-TR*          FROM CSS_JOB_PARM                                              
MFA-TR*         WHERE PROGRAM_NAME   = 'COMMON'                                 
MFA-TR*           AND CMND_CODE      = 'DATE'                                   
MFA-TR*           AND SEQ_NO         =  20                                      
MFA-TR*           AND STATUS         = 'A'                                      
MFA-TR*           AND COMPANY_NO     = '01'                                     
MFA-TR*        WITH UR                                                          
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
           IF WS-ACTIVE-RETURN-CODE EQUAL    TO SUCCESSFUL-CALL         
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8650'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_JOB_PARM '           TO TABLE-1                 
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       8650-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *        8655-SELECT COMMON-DATE FROM CSS_JOB_PARM               *        
      *                                                                         
      * ****************************************************************        
       8655-SELECT-COMMON-DATE.                                         
            EXEC SQL                                                    
               SELECT CIS.SUBSTR3(PARM_DATA,10,10)                           
                 INTO :WS-COMMON-DATE                                   
                 FROM CSS_JOB_PARM WITH(READUNCOMMITTED)                        
                WHERE PROGRAM_NAME   = 'COMMON'                         
                  AND CMND_CODE      = 'DATE'                           
                  AND SEQ_NO         =  10                              
                  AND STATUS         = 'A'                              
                  AND COMPANY_NO     = '01'                             
                                                                 
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*     EXEC SQL                                                            
MFA-TR*        SELECT SUBSTR(PARM_DATA,10,10)                                   
MFA-TR*          INTO :WS-COMMON-DATE                                           
MFA-TR*          FROM CSS_JOB_PARM                                              
MFA-TR*         WHERE PROGRAM_NAME   = 'COMMON'                                 
MFA-TR*           AND CMND_CODE      = 'DATE'                                   
MFA-TR*           AND SEQ_NO         =  10                                      
MFA-TR*           AND STATUS         = 'A'                                      
MFA-TR*           AND COMPANY_NO     = '01'                                     
MFA-TR*        WITH UR                                                          
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
           IF WS-ACTIVE-RETURN-CODE EQUAL    TO SUCCESSFUL-CALL         
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8655'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_JOB_PARM '           TO TABLE-1                 
              MOVE 'COMPANY_NO   '           TO TABLE-ELEMENT-1         
              MOVE  AT-COMPANY-NO            TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       8655-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *        8660-SELECT-BASE-RATE                                            
      * ****************************************************************        
       8660-SELECT-BASE-RATE.                                           
            EXEC SQL                                                    
               SELECT RATE_PLAN_NO                                      
                 INTO :UT-RATE-PLAN-NO                                  
                 FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO     = :UT-ACCOUNT-NO                   
                  AND CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE               
                  AND IC_NO          = :UT-IC-NO                        
                                                                 
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*        SELECT RATE_PLAN_NO                                              
MFA-TR*          INTO :UT-RATE-PLAN-NO                                          
MFA-TR*          FROM CSS_UTIL_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO     = :UT-ACCOUNT-NO                           
MFA-TR*           AND CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE                       
MFA-TR*           AND IC_NO          = :UT-IC-NO                                
MFA-TR*        WITH UR                                                          
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
           IF WS-ACTIVE-RETURN-CODE EQUAL    TO SUCCESSFUL-CALL         
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8660'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_UTIL_ENVRNMT'        TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE  UT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1       
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE  UT-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2       
              MOVE 'IC_NO'                   TO TABLE-ELEMENT-3         
              MOVE  UT-IC-NO                 TO HOSTVAR-ELEMENT-3       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       8660-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *        8661-GET-SEASONAL-CODE.                                          
      ******************************************************************        
       8661-GET-SEASONAL-CODE.                                          
            EXEC SQL                                                    
               SELECT CODE_SEASON                                       
                 INTO :RS-CODE-SEASON                                   
                 FROM CSS_RATE_USE_SEASN WITH(READUNCOMMITTED)                  
                WHERE CODE_UTIL_TYPE   = :RS-CODE-UTIL-TYPE             
                 AND  RATE_PLAN_NO     = :RS-RATE-PLAN-NO               
                 AND  VERSION_NO_CNTRL = (SELECT MAX(VERSION_NO_CNTRL)  
                           FROM CSS_RATE_USE_SEASN RS
                           WITH(READUNCOMMITTED)                   
                           WHERE RS.RATE_PLAN_NO  = :RS-RATE-PLAN-NO    
                           AND  RS.CODE_UTIL_TYPE = :RS-CODE-UTIL-TYPE) 
                 AND CODE_USE_INST_TYPE = 'C'                           
                 AND ((DATE_FROM        <= :RS-DATE-FROM                
                       AND DATE_TO      >= :RS-DATE-FROM                
                       AND DATE_FROM    <= DATE_TO)                     
                       OR  (DATE_FROM   >= :RS-DATE-FROM                
                       AND DATE_TO      <= :RS-DATE-FROM                
                       AND DATE_FROM    >= DATE_TO))                    
                                                                 
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*        SELECT CODE_SEASON                                               
MFA-TR*          INTO :RS-CODE-SEASON                                           
MFA-TR*          FROM CSS_RATE_USE_SEASN                                        
MFA-TR*         WHERE CODE_UTIL_TYPE   = :RS-CODE-UTIL-TYPE                     
MFA-TR*          AND  RATE_PLAN_NO     = :RS-RATE-PLAN-NO                       
MFA-TR*          AND  VERSION_NO_CNTRL = (SELECT MAX(VERSION_NO_CNTRL)          
MFA-TR*                    FROM CSS_RATE_USE_SEASN RS                           
MFA-TR*                    WHERE RS.RATE_PLAN_NO  = :RS-RATE-PLAN-NO            
MFA-TR*                    AND  RS.CODE_UTIL_TYPE = :RS-CODE-UTIL-TYPE)         
MFA-TR*          AND CODE_USE_INST_TYPE = 'C'                                   
MFA-TR*          AND ((DATE_FROM        <= :RS-DATE-FROM                        
MFA-TR*                AND DATE_TO      >= :RS-DATE-FROM                        
MFA-TR*                AND DATE_FROM    <= DATE_TO)                             
MFA-TR*                OR  (DATE_FROM   >= :RS-DATE-FROM                        
MFA-TR*                AND DATE_TO      <= :RS-DATE-FROM                        
MFA-TR*                AND DATE_FROM    >= DATE_TO))                            
MFA-TR*        WITH UR                                                          
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
           IF WS-ACTIVE-RETURN-CODE EQUAL    TO NOT-FOUND               
              MOVE 'N'                       TO  RS-CODE-SEASON         
           END-IF                                                       
           IF WS-ACTIVE-RETURN-CODE EQUAL    TO SUCCESSFUL-CALL         
                                         OR NOT-FOUND                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8661'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_RATE_USE_SEASN'      TO TABLE-1                 
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-1         
              MOVE  RS-RATE-PLAN-NO          TO HOSTVAR-ELEMENT-1       
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE  RS-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       8661-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *        8662-GET-RATE-PLAN-DESC                                          
      ******************************************************************        
       8662-GET-RATE-PLAN-DESC.                                         
            EXEC SQL                                                    
               SELECT RATE_DESC                                         
                 INTO :RD-RATE-DESC                                     
                 FROM CSS_RATE_PLAN_DESC WITH(READUNCOMMITTED)                  
                WHERE CODE_UTIL_TYPE   = :RD-CODE-UTIL-TYPE             
                 AND  RATE_PLAN_NO     = :RD-RATE-PLAN-NO               
                                                                 
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*        SELECT RATE_DESC                                                 
MFA-TR*          INTO :RD-RATE-DESC                                             
MFA-TR*          FROM CSS_RATE_PLAN_DESC                                        
MFA-TR*         WHERE CODE_UTIL_TYPE   = :RD-CODE-UTIL-TYPE                     
MFA-TR*          AND  RATE_PLAN_NO     = :RD-RATE-PLAN-NO                       
MFA-TR*        WITH UR                                                          
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
           IF WS-ACTIVE-RETURN-CODE EQUAL    TO SUCCESSFUL-CALL         
                                         OR NOT-FOUND                   
              IF WS-ACTIVE-RETURN-CODE= NOT-FOUND                       
                 MOVE SPACES                 TO RD-RATE-DESC            
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8662'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_RATE_PLAN_DESC'      TO TABLE-1                 
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-1         
              MOVE  RD-RATE-PLAN-NO          TO HOSTVAR-ELEMENT-1       
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE  RD-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       8662-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *        8663-GET-SVC-CAT-DESC                                            
      ******************************************************************        
       8663-GET-SVC-CAT-DESC.                                           
            EXEC SQL                                                    
               SELECT PRTY_SVC_CAT_CD,                                  
                      PRTY_SVC_CAT_DESC                                 
                 INTO :Z4-PRTY-SVC-CAT-CD,                              
                      :Z4-PRTY-SVC-CAT-DESC                             
                 FROM CSS_PRTY_SVC_CAT WITH(READUNCOMMITTED)                    
                WHERE COMPANY_NO        = :Z4-COMPANY-NO                
                 AND  CODE_CURTAIL_PRTY = :Z4-CODE-CURTAIL-PRTY         
                                                                 
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*        SELECT PRTY_SVC_CAT_CD,                                          
MFA-TR*               PRTY_SVC_CAT_DESC                                         
MFA-TR*          INTO :Z4-PRTY-SVC-CAT-CD,                                      
MFA-TR*               :Z4-PRTY-SVC-CAT-DESC                                     
MFA-TR*          FROM CSS_PRTY_SVC_CAT                                          
MFA-TR*         WHERE COMPANY_NO        = :Z4-COMPANY-NO                        
MFA-TR*          AND  CODE_CURTAIL_PRTY = :Z4-CODE-CURTAIL-PRTY                 
MFA-TR*        WITH UR                                                          
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
           IF WS-ACTIVE-RETURN-CODE EQUAL    TO SUCCESSFUL-CALL         
                                         OR NOT-FOUND                   
              IF WS-ACTIVE-RETURN-CODE= NOT-FOUND                       
                 MOVE SPACES                 TO Z4-PRTY-SVC-CAT-CD      
                 MOVE SPACES                 TO Z4-PRTY-SVC-CAT-DESC    
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8663'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_RATE_PLAN_DESC'      TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE  Z4-COMPANY-NO            TO HOSTVAR-ELEMENT-1       
              MOVE 'CODE_CURTAIL_PRTY'       TO TABLE-ELEMENT-2         
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       8663-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *        8664-SELECT-READ-FREQ                                            
      * ****************************************************************        
       8664-SELECT-READ-FREQ.                                           
            EXEC SQL                                                    
               SELECT CODE_MTR_READ_FREQ                                
ACT247              , RT_PKG_OPT_SEQ_NO                                 
                 INTO :UT-CODE-MTR-READ-FREQ                            
ACT247              , :UT-RT-PKG-OPT-SEQ-NO                             
                 FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO     = :UT-ACCOUNT-NO                   
                  AND CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE               
                  AND IC_NO          = :UT-IC-NO                        
                                                                 
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*        SELECT CODE_MTR_READ_FREQ                                        
MFA-TR*             , RT_PKG_OPT_SEQ_NO                                         
MFA-TR*          INTO :UT-CODE-MTR-READ-FREQ                                    
MFA-TR*             , :UT-RT-PKG-OPT-SEQ-NO                                     
MFA-TR*          FROM CSS_UTIL_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO     = :UT-ACCOUNT-NO                           
MFA-TR*           AND CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE                       
MFA-TR*           AND IC_NO          = :UT-IC-NO                                
MFA-TR*        WITH UR                                                          
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
           IF WS-ACTIVE-RETURN-CODE EQUAL    TO SUCCESSFUL-CALL         
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8664'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_UTIL_ENVRNMT'        TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE  UT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1       
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE  UT-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2       
              MOVE 'IC_NO'                   TO TABLE-ELEMENT-3         
              MOVE  UT-IC-NO                 TO HOSTVAR-ELEMENT-3       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       8664-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *        8665-CHECK-STEP-RATE                                             
      ******************************************************************        
       8665-CHECK-STEP-RATE.                                            
                                                                        
           EXEC SQL                                                     
              SELECT LAST_ENERGY_BLOCK                                  
                INTO :J1-LAST-ENERGY-BLOCK                              
                FROM CSS_RATE_COMP_DEF J1 WITH(READUNCOMMITTED)                 
               WHERE J1.CODE_UTIL_TYPE   = :WS-BC-CODE-UTIL-TYPE-BG     
                 AND J1.RATE_PLAN_NO     = :WS-BC-RATE-PLAN-NO-BG       
                 AND J1.CMPNT_ID_CD      = '10'                         
                 AND J1.VERSION_NO_CNTRL =                              
                    (SELECT MAX(J2.VERSION_NO_CNTRL)                    
                       FROM CSS_RATE_COMP_DEF J2 WITH(READUNCOMMITTED)          
                      WHERE J2.CODE_UTIL_TYPE = J1.CODE_UTIL_TYPE       
                        AND J2.RATE_PLAN_NO   = J1.RATE_PLAN_NO         
                        AND J2.CMPNT_ID_CD    = J1.CMPNT_ID_CD)         
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT LAST_ENERGY_BLOCK                                          
MFA-TR*         INTO :J1-LAST-ENERGY-BLOCK                                      
MFA-TR*         FROM CSS_RATE_COMP_DEF J1                                       
MFA-TR*        WHERE J1.CODE_UTIL_TYPE   = :WS-BC-CODE-UTIL-TYPE-BG             
MFA-TR*          AND J1.RATE_PLAN_NO     = :WS-BC-RATE-PLAN-NO-BG               
MFA-TR*          AND J1.CMPNT_ID_CD      = '10'                                 
MFA-TR*          AND J1.VERSION_NO_CNTRL =                                      
MFA-TR*             (SELECT MAX(J2.VERSION_NO_CNTRL)                            
MFA-TR*                FROM CSS_RATE_COMP_DEF J2                                
MFA-TR*               WHERE J2.CODE_UTIL_TYPE = J1.CODE_UTIL_TYPE               
MFA-TR*                 AND J2.RATE_PLAN_NO   = J1.RATE_PLAN_NO                 
MFA-TR*                 AND J2.CMPNT_ID_CD    = J1.CMPNT_ID_CD)                 
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL    TO SUCCESSFUL-CALL         
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8665'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_RATE_COMP_DEF'       TO TABLE-1                 
              MOVE 'RATE PLAN'               TO TABLE-ELEMENT-1         
              MOVE  WS-BC-RATE-PLAN-NO-BG    TO HOSTVAR-ELEMENT-1       
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE  WS-BC-CODE-UTIL-TYPE-BG  TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       8665-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO SELECT THE TOTAL CHARGES THAT     **        
      **  ARE RELATED TO AGL FACTORS.                                 **        
      ******************************************************************        
      *8666-AGL-DEBIT.                                                          
      *                                                                         
      *    EXEC SQL                                                             
      *        SELECT  SUM(FH.FACTOR)                                           
      *          INTO  :WS-AGL-DEBIT-CHARGES:WS-NULL-IND-8                      
      *        FROM    CSS_FIXED_FCT_HIST FH                                    
      *               ,CSS_SPCL_FCTR      SF                                    
      *        WHERE   FH.ACCOUNT_NO         = :WS-ACCOUNT-NO                   
      *          AND   FH.CODE_UTIL_TYPE     = :WS-CODE-UTIL-TYPE               
      *          AND   FH.IC_NO              = :WS-IC-NO                        
      *          AND   FH.BILL_NO            = :WS-BILL-NO                      
      *          AND   FH.BILL_ITEM_TIMESTMP = :WS-BILL-ITEM-TIMESTMP           
      *          AND   FH.CODE_DEBIT_CREDIT  IN ('D',' ')                       
      *          AND   SF.SPCL_GROUP_CD      IN ('AP','MT')                     
      *          AND   SF.FACTOR_ID          = FH.FACTOR_ID                     
      *    WITH UR                                                              
      *    QUERYNO 8666                                                         
      *    END-EXEC.                                                            
      *                                                                         
      *    MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.          
      *                                                                         
      *    IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL OR NOT-FOUND        
      *       IF WS-NULL-IND-8 < 0                                              
      *          MOVE 0                      TO WS-AGL-DEBIT-CHARGES            
      *       END-IF                                                            
      *    ELSE                                                                 
      *       MOVE PROGRAM-NAME              TO ABEND-PROGRAM                   
      *       MOVE '8666'                    TO ACTIVE-PARAGRAPH                
      *       MOVE 'SELECT'                  TO ABEND-FUNCTION                  
      *       MOVE SPACES                    TO ABEND-SQL-PREDICATES            
      *                                         ABEND-TABLES                    
      *       MOVE 'CSS_FIXED_FCT_HIST'      TO TABLE-1                         
      *       MOVE 'ACCOUNT_NO  '            TO TABLE-ELEMENT-1                 
      *       MOVE 'BILL_ITEM_TIMESTMP'      TO TABLE-ELEMENT-2                 
      *       MOVE WS-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1               
      *       MOVE WS-BILL-ITEM-TIMESTMP     TO HOSTVAR-ELEMENT-2               
      *       PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT                    
      *    END-IF.                                                              
      *                                                                         
      *8666-EXIT.                                                               
      *     EXIT.                                                               
      *                                                                         
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO SELECT THE TOTAL CHARGES THAT     **        
      **  ARE RELATED TO AGL FACTORS.                                 **        
      ******************************************************************        
      *8667-AGL-CREDIT.                                                         
      *                                                                         
      *    EXEC SQL                                                             
      *        SELECT  SUM(FH.FACTOR)                                           
      *          INTO  :WS-AGL-CREDIT-CHARGES:WS-NULL-IND-8                     
      *        FROM    CSS_FIXED_FCT_HIST FH                                    
      *               ,CSS_SPCL_FCTR      SF                                    
      *        WHERE   FH.ACCOUNT_NO         = :WS-ACCOUNT-NO                   
      *          AND   FH.CODE_UTIL_TYPE     = :WS-CODE-UTIL-TYPE               
      *          AND   FH.IC_NO              = :WS-IC-NO                        
      *          AND   FH.BILL_NO            = :WS-BILL-NO                      
      *          AND   FH.BILL_ITEM_TIMESTMP = :WS-BILL-ITEM-TIMESTMP           
      *          AND   FH.CODE_DEBIT_CREDIT  = 'C'                              
      *          AND   SF.SPCL_GROUP_CD      = 'AP'                             
      *          AND   SF.FACTOR_ID          = FH.FACTOR_ID                     
      *    WITH UR                                                              
      *    QUERYNO 8667                                                         
      *    END-EXEC.                                                            
      *                                                                         
      *    MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.          
      *                                                                         
      *    IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL OR NOT-FOUND        
      *       IF WS-NULL-IND-8 < 0                                              
      *          MOVE 0                      TO WS-AGL-CREDIT-CHARGES           
      *       END-IF                                                            
      *    ELSE                                                                 
      *       MOVE PROGRAM-NAME              TO ABEND-PROGRAM                   
      *       MOVE '8667'                    TO ACTIVE-PARAGRAPH                
      *       MOVE 'SELECT'                  TO ABEND-FUNCTION                  
      *       MOVE SPACES                    TO ABEND-SQL-PREDICATES            
      *                                         ABEND-TABLES                    
      *       MOVE 'CSS_FIXED_FCT_HIST'      TO TABLE-1                         
      *       MOVE 'ACCOUNT_NO  '            TO TABLE-ELEMENT-1                 
      *       MOVE 'BILL_ITEM_TIMESTMP'      TO TABLE-ELEMENT-2                 
      *       MOVE WS-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1               
      *       MOVE WS-BILL-ITEM-TIMESTMP     TO HOSTVAR-ELEMENT-2               
      *       PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT                    
      *    END-IF.                                                              
      *                                                                         
      *8667-EXIT.                                                               
      *     EXIT.                                                               
      *                                                                         
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO SELECT THE TOTAL UNIT PRICE AMOUNT *        
      ******************************************************************        
       8668-PRICE-PER-THERM.                                            
      *                                                                         
           EXEC SQL                                                     
              SELECT  SUM(UNIT_PRICE_AM)                                
                INTO  :WS-UNIT-PRICE-AMT :WS-NULL-IND-8                  
                FROM  CSS_BILL_CALC_DET WITH(READUNCOMMITTED)                   
               WHERE  ACCOUNT_NO         = :WS-ACCOUNT-NO               
                 AND  CODE_UTIL_TYPE     = :WS-CODE-UTIL-TYPE           
                 AND  BILL_NO            = :WS-BILL-NO                  
                 AND  IC_NO              = :WS-IC-NO                    
                 AND  BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :WS-BILL-ITEM-TIMESTMP
              )       
                 AND  CMPNT_ID_CD NOT IN ('92','93')                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  SUM(UNIT_PRICE_AM)                                        
MFA-TR*         INTO  :WS-UNIT-PRICE-AMT:WS-NULL-IND-8                          
MFA-TR*         FROM  CSS_BILL_CALC_DET                                         
MFA-TR*        WHERE  ACCOUNT_NO         = :WS-ACCOUNT-NO                       
MFA-TR*          AND  CODE_UTIL_TYPE     = :WS-CODE-UTIL-TYPE                   
MFA-TR*          AND  BILL_NO            = :WS-BILL-NO                          
MFA-TR*          AND  IC_NO              = :WS-IC-NO                            
MFA-TR*          AND  BILL_ITEM_TIMESTMP = :WS-BILL-ITEM-TIMESTMP               
MFA-TR*          AND  CMPNT_ID_CD NOT IN ('92','93')                            
MFA-TR*    WITH UR                                                              
MFA-TR*    QUERYNO 8668                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL OR NOT-FOUND
              IF WS-NULL-IND-8 < 0                                      
                 MOVE 0                      TO WS-UNIT-PRICE-AMT       
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8668'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_BILL_CALC_DET'       TO TABLE-1                 
              MOVE 'ACCOUNT_NO  '            TO TABLE-ELEMENT-1         
              MOVE 'BILL_ITEM_TIMESTMP'      TO TABLE-ELEMENT-2         
              MOVE WS-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE WS-BILL-ITEM-TIMESTMP     TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       8668-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      *****************************************************************         
      * 8800-CHECK-RESULTS.                                           *         
      *****************************************************************         
       8800-CHECK-RESULTS.                                              
                                                                        
           IF CTR-ROWS-RS1 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS                              
              MOVE 100                       TO S-RETURN-CODE           
              MOVE 0                         TO S-APPL-RETURN-CODE      
              PERFORM 8100A-INSERT-GTT-R1       THRU 8100A-EXIT         
           END-IF.                                                      
                                                                        
           IF CTR-ROWS-RS2 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS                              
              MOVE 100                       TO S-RETURN-CODE           
              MOVE 0                         TO S-APPL-RETURN-CODE      
              PERFORM 8100B-INSERT-GTT-R2       THRU 8100B-EXIT         
           END-IF.                                                      
                                                                        
           IF CTR-ROWS-RS3 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS                              
              MOVE 100                       TO S-RETURN-CODE           
              MOVE 0                         TO S-APPL-RETURN-CODE      
              PERFORM 8100C-INSERT-GTT-R3       THRU 8100C-EXIT         
           END-IF.                                                      
                                                                        
           IF CTR-ROWS-RS4 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS                              
              MOVE 100                       TO S-RETURN-CODE           
              MOVE 0                         TO S-APPL-RETURN-CODE      
              PERFORM 8100D-INSERT-GTT-R4       THRU 8100D-EXIT         
           END-IF.                                                      
                                                                        
           IF CTR-ROWS-RS5 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-RS5                          
              MOVE 100                       TO S5-RETURN-CODE          
              MOVE 0                         TO S5-APPL-RETURN-CODE     
              PERFORM 8100E-INSERT-GTT-R5       THRU 8100E-EXIT         
           END-IF.                                                      
                                                                        
       8800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8900-SEND-DONE.                                               *         
      *****************************************************************         
       8900-SEND-DONE.                                                  
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                 S-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE 'CSR04686_R1'             TO TABLE-1                 
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C2                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                 S-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE 'CSR04686_R2'             TO TABLE-1                 
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C3                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C3 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                 S-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE 'CSR04686_R3'             TO TABLE-1                 
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C5                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C5 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                 S5-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE 'CSR04686_R5'             TO TABLE-1                 
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C4                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C4 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                 S-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE 'CSR04686_R4'             TO TABLE-1                 
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 9000-SEND-ERROR-RESULT.                                       *         
      *****************************************************************         
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE        TO ABEND-SQLCODE           
                                                S5-RETURN-CODE          
                                                S-RETURN-CODE.          
                                                                        
           MOVE SQLERRMC                     TO ABEND-SQLERRMC.         
                                                                        
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'                TO ABEND-FUNCTION          
           END-IF.                                                      
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1       THRU 0100A-EXIT.          
           PERFORM 0100B-DECLARE-GTT-R2       THRU 0100B-EXIT.          
           PERFORM 0100C-DECLARE-GTT-R3       THRU 0100C-EXIT.          
           PERFORM 0100D-DECLARE-GTT-R4       THRU 0100D-EXIT.          
           PERFORM 0100E-DECLARE-GTT-R5       THRU 0100E-EXIT.          
                                                                        
           PERFORM 8100A-INSERT-GTT-R1        THRU 8100A-EXIT.          
           PERFORM 8100B-INSERT-GTT-R2        THRU 8100B-EXIT.          
           PERFORM 8100C-INSERT-GTT-R3        THRU 8100C-EXIT.          
           PERFORM 8100D-INSERT-GTT-R4        THRU 8100D-EXIT.          
           PERFORM 8100E-INSERT-GTT-R5        THRU 8100E-EXIT.          
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 9700-PROCESS-ABEND.                                           *         
      *****************************************************************         
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT.           
           PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT.           
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900-SQL-ERROR-ROUTINE.                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * 9999-END-PROGRAM.                                             *         
      *****************************************************************         
       9999-END-PROGRAM.                                                
                                                                        
           PERFORM 8800-CHECK-RESULTS         THRU 8800-EXIT.           
           PERFORM 8900-SEND-DONE             THRU 8900-EXIT.           
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
