       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04685.                                         
       AUTHOR.        DANA SHERER.                                      
COB303 DATE-WRITTEN.  OCTOBER 12, 2013.                                 
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM DOES THE FOLLOWING:                              *        
      *  1. RETRIEVES THE EBILL INDICATOR FROM CSS_CUST_STATS          *        
      *  2. UPDATES THE EBILL INDICATOR                                *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  10/21/13    DMS      INITIAL VERSION.                         *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04685'.
MSQ017     COPY MFASQLM.
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04685 STARTS HERE'.                  
                                                                        
      ******************************************************************00540000
      *    DB2 INCLUDES                                                *00550000
      ******************************************************************00560000
                                                                        
           EXEC SQL                                                     00580000
              INCLUDE SQLCA                                             00590000
           END-EXEC.                                                    00600000
                                                                        
      ******************************************************************00540000
      *    INCLUDE CSS_CUST_STATS                                      *00550000
      ******************************************************************00560000
           EXEC SQL                                                     00630000
              INCLUDE TBCSTSTS                                          00640000
           END-EXEC.                                                    00650000
                                                                        
      ******************************************************************00540000
      *    INCLUDE CSS_CUSTOMER                                        *00550000
      ******************************************************************00560000
           EXEC SQL                                                     00630000
              INCLUDE TBCUST                                            00640000
           END-EXEC.                                                    00650000
                                                                        
      ******************************************************************00540000
      *    INCLUDE CSS_MNT_TRANS_HIST                                  *00550000
      ******************************************************************00560000
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************00540000
      *    INCLUDE CSS_MT_TRN_HST_DET                                  *00550000
      ******************************************************************00560000
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************00770000
      *    COBOL WORKING STORAGE COPYBOOKS                             *00780000
      ******************************************************************00790000
      * ERROR HANDLING                                                  00880000
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
      * ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS                  00900000
           COPY CWS00027.                                               00910000
      * SUPPORTS DB2 AND SQL ERROR CHECKING                             00920000
           COPY CWS00303.                                               00930000
                                                                        
      ******************************************************************00660000
      *    WORK AREAS                                                  *00670000
      ******************************************************************00680000
       01  PARM-FIELDS.                                                 
           05  PARM-ACCOUNT-NO-TEMP    PIC X(13).                       
           05  PARM-ACCOUNT-NO-NUM REDEFINES PARM-ACCOUNT-NO-TEMP       
                                       PIC 9(13).                       
           05  PARM-CUSTOMER-NO-TEMP   PIC X(10).                       
           05  PARM-CUSTOMER-NO-NUM REDEFINES PARM-CUSTOMER-NO-TEMP     
                                       PIC 9(10).                       
       01  WS-MISC.                                                     
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR04685'.      
           05  WS-F                    PIC X(01) VALUE 'F'.             
           05  WS-TRAN-APPL-NO         PIC S9(4) COMP.                  
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
           05  RS-EBILL-REGISTER-IND   PIC X(01) VALUE  SPACES.         
                                                                        
       01  GTT-MISC-FIELDS.                                             
           05  GTT-NAME                PIC X(26)                        
                                           VALUE 'SESSION.CSR04685_R1'. 
           05  GTT-ROW.                                                 
               49 GTT-ROW-LEN          PIC S9(04) COMP.                 
               49 GTT-ROW-CHAR         PIC X(1024).                     
           05  GTT-SQLCODE             PIC S9(9) COMP.                  
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE           PIC S9(9) COMP VALUE 0.          
           05  S-EBILL-REGISTER-IND    PIC X(01) VALUE  SPACES.         
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
           05  ROW-EXISTS-SW           PIC X(01) VALUE 'Y'.             
               88 NO-ROW                         VALUE 'N'.             
               88 ROW-EXISTS                     VALUE 'Y'.             
HPCCDM*EJECT                                                            02000000
       LINKAGE SECTION.                                                 
       01  PARM-CALL-TYPE              PIC X(01).                       
       01  PARM-ACCOUNT-NO             PIC X(13).                       
       01  PARM-CUSTOMER-NO            PIC X(10).                       
       01  PARM-EBILL-REGISTER-IND     PIC X(01).                       
       01  PARM-USER-ID                PIC X(07).                       
       01  PARM-TRAN-COMMENT-LEN       PIC S9(4) COMP.                  
       01  PARM-TRAN-COMMENT           PIC X(210).                      
                                                                        
       PROCEDURE DIVISION USING PARM-CALL-TYPE                          
                                PARM-ACCOUNT-NO                         
                                PARM-CUSTOMER-NO                        
                                PARM-EBILL-REGISTER-IND                 
                                PARM-USER-ID                            
                                PARM-TRAN-COMMENT-LEN                   
                                PARM-TRAN-COMMENT.                      
                                                                        
      ******************************************************************02500000
      * 0000-MAINLINE                                                  *02510000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *02520000
      ******************************************************************02530000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02230000
      * 0100-INITIALIZE                                                *02240000
      ******************************************************************02530000
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'          TO ACTIVE-PARAGRAPH.                    
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           EXEC SQL                                                     
                DECLARE C1 CURSOR  FOR                       
                SELECT                                                  
                      :S-RETURN-CODE               AS RETURN_CODE       
                     ,LTRIM(RTRIM(:S-EBILL-REGISTER-IND)) AS 
           EBILL_REGISTER_IND
                FROM                                                    
                     CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE C1 CURSOR WITH RETURN FOR                               
MFA-TR*         SELECT                                                          
MFA-TR*               :S-RETURN-CODE               AS RETURN_CODE               
MFA-TR*              ,STRIP(:S-EBILL-REGISTER-IND) AS EBILL_REGISTER_IND        
MFA-TR*         FROM                                                            
MFA-TR*              SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02640000
      * 1000-PROCESS-INPUT                                             *02650000
      ******************************************************************02710000
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-CUSTOMER-NO        TO PARM-CUSTOMER-NO-TEMP.       
           MOVE PARM-ACCOUNT-NO         TO PARM-ACCOUNT-NO-TEMP.        
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03210000
      * 2000-PROCESS-OUTPUT.                                           *03220000
      ******************************************************************03300000
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2300-BUILD-RESULT             THRU 2300-EXIT.        
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  2000A-MOVE-RESULT.                                            *        
      ******************************************************************        
                                                                        
       2000A-MOVE-RESULT.                                               
                                                                        
           MOVE RS-RETURN-CODE        TO S-RETURN-CODE.                 
           MOVE RS-EBILL-REGISTER-IND TO S-EBILL-REGISTER-IND.          
                                                                        
       2000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************06620000
      * 2300-BUILD-RESULT                                              *06630000
      ******************************************************************06710000
       2300-BUILD-RESULT.                                               
                                                                        
           MOVE '2300'                          TO ACTIVE-PARAGRAPH.    
                                                                        
           PERFORM 2400-GET-EBILL-IND         THRU 2400-EXIT.           
           IF PARM-CALL-TYPE = 'S'                                      
              MOVE CE-EBILL-REGISTER-IND    TO RS-EBILL-REGISTER-IND    
           END-IF.                                                      
                                                                        
           IF PARM-CALL-TYPE = 'U'                                      
              PERFORM 2500-SET-EBILL-IND    THRU 2500-EXIT              
           END-IF.                                                      
                                                                        
           PERFORM 2000A-MOVE-RESULT          THRU 2000A-EXIT.          
           ADD +1                             TO   CTR-ROWS.            
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2400-GET-EBILL-IND                                             *        
      *     GET EBILL INDICATOR                                        *        
      ******************************************************************07550000
       2400-GET-EBILL-IND.                                              
                                                                        
           PERFORM 7000-GET-EBILL-REG-IND   THRU 7000-EXIT.             
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              MOVE 'N'              TO ROW-EXISTS-SW                    
              MOVE SPACES           TO CE-EBILL-REGISTER-IND            
           END-IF.                                                      
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 2500-SET-EBILL-IND                                            *         
      *****************************************************************         
                                                                        
       2500-SET-EBILL-IND.                                              
                                                                        
           IF PARM-EBILL-REGISTER-IND NOT EQUAL CE-EBILL-REGISTER-IND   
              IF NO-ROW                                                 
                 PERFORM 7400-GET-NAME-ID        THRU 7400-EXIT         
                 PERFORM 7410-INSERT-EBILL       THRU 7410-EXIT         
              ELSE                                                      
                 PERFORM 7420-UPDATE-EBILL       THRU 7420-EXIT         
              END-IF                                                    
              PERFORM 5000-MAINTENANCE-HISTORY THRU 5000-EXIT           
              MOVE ZEROS                      TO MH-ACCOUNT-NO          
              MOVE PARM-CUSTOMER-NO-TEMP      TO MH-CUSTOMER-NO         
              MOVE 'EBILL'                    TO MI-COLUMN-DESC         
              MOVE 1                          TO MI-PRV-COLUMN-VALUE-LEN
              IF CE-EBILL-REGISTER-IND EQUAL SPACES                     
                 MOVE 'N'                    TO MI-PRV-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE CE-EBILL-REGISTER-IND                             
                                             TO MI-PRV-COLUMN-VALUE-TEXT
              END-IF                                                    
              MOVE 1                          TO MI-CHG-COLUMN-VALUE-LEN
              IF PARM-EBILL-REGISTER-IND EQUAL SPACES                   
                 MOVE 'N'                    TO MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE PARM-EBILL-REGISTER-IND                           
                                             TO MI-CHG-COLUMN-VALUE-TEXT
              END-IF                                                    
              MOVE SPACES                     TO MI-TABLE-ID            
              PERFORM 5010-MNT-HST-DETAIL     THRU 5010-EXIT            
           END-IF.                                                      
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 5000-MAINTENANCE-HISTORY.                                     *         
      *     PREPARE MAINTENANCE JOURNAL                               *         
      *****************************************************************         
                                                                        
       5000-MAINTENANCE-HISTORY.                                        
                                                                        
           MOVE '5000'                 TO ACTIVE-PARAGRAPH.             
                                                                        
           PERFORM 7300-GET-TIMESTAMP      THRU 7300-EXIT.              
                                                                        
           MOVE WS-F                   TO MH-CODE-TRAN-TYPE.            
           MOVE SPACES                 TO MH-RESP-AREA-ID.              
           MOVE PARM-ACCOUNT-NO-TEMP   TO MH-ACCOUNT-NO.                
           MOVE ZEROS                  TO MH-CUSTOMER-NO.               
           MOVE ZEROS                  TO MH-PREMISE-NO.                
           MOVE PARM-USER-ID           TO MH-USER-ID.                   
           MOVE 'PANEL490'             TO MH-APPL-PROGRAM-ID.           
           MOVE PARM-TRAN-COMMENT-LEN  TO MH-TRAN-COMMENT-LEN.          
           MOVE PARM-TRAN-COMMENT      TO MH-TRAN-COMMENT-TEXT.         
           MOVE +1                     TO WS-TRAN-APPL-NO.              
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 5010-MNT-HST-DETAIL.                                          *         
      *****************************************************************         
                                                                        
       5010-MNT-HST-DETAIL.                                             
                                                                        
           MOVE '5010'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO         TO MI-TRANS-HIST-SEQ-NO.   
           MOVE WS-TRAN-APPL-NO              TO MI-TRAN-APPL-NO.        
           PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT.            
           ADD 1                             TO WS-TRAN-APPL-NO.        
                                                                        
       5010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 6530-LOAD-MNT-TRANS-HIST                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************07969900
      * 7000-GET-EBILL-REG-IND                                         *07492029
      *     SELECT EBILL IND FROM CSS_CUST_STATS                       *07530029
      ******************************************************************07550000
       7000-GET-EBILL-REG-IND.                                          
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) EBILL_REGISTER_IND                               
                  INTO :CE-EBILL-REGISTER-IND                           
                  FROM CSS_CUST_STATS CE                                
                 WHERE CE.CUSTOMER_NO   = :PARM-CUSTOMER-NO-TEMP        
                   AND CE.CUSTOMER_TYPE = 'C'                           
                                                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                     07922011
MFA-TR*         SELECT EBILL_REGISTER_IND                                       
MFA-TR*           INTO :CE-EBILL-REGISTER-IND                                   
MFA-TR*           FROM CSS_CUST_STATS CE                                        
MFA-TR*          WHERE CE.CUSTOMER_NO   = :PARM-CUSTOMER-NO-TEMP                
MFA-TR*            AND CE.CUSTOMER_TYPE = 'C'                                   
MFA-TR*       FETCH FIRST ROW ONLY                                              
MFA-TR*       QUERYNO 7000                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7000'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_CUST_STATS'      TO TABLE-1                     
              MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1             
              MOVE PARM-CUSTOMER-NO-TEMP TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7300-GET-TIMESTAMP                                             *        
      ******************************************************************        
                                                                        
       7300-GET-TIMESTAMP.                                              
                                                                        
           EXEC SQL                                                     
             SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), DATEADD( SECOND, 10, 
           CIS.CURRENT$TIMESTAMP() ), 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :MH-TRANS-HIST-SEQ-NO,
              :MH-DATE-TRANS                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SET :MH-TRANS-HIST-SEQ-NO = CURRENT TIMESTAMP + 10 SECONDS         
MFA-TR*         ,:MH-DATE-TRANS = CURRENT DATE                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7300'                TO ACTIVE-PARAGRAPH            
              MOVE 'SET'                 TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE PARM-ACCOUNT-NO-TEMP  TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7400-GET-NAME-ID                                              *         
      *     GET NAME ID FROM CSS_CUSTOMER                             *         
      *****************************************************************         
       7400-GET-NAME-ID.                                                
                                                                        
           MOVE '7400'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
             SELECT NAME_ID                                             
               INTO :CU-NAME-ID                                         
               FROM CSS_CUSTOMER WITH(READUNCOMMITTED)                          
              WHERE CUSTOMER_NO   = :PARM-CUSTOMER-NO-TEMP              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT NAME_ID                                                     
MFA-TR*        INTO :CU-NAME-ID                                                 
MFA-TR*        FROM CSS_CUSTOMER                                                
MFA-TR*       WHERE CUSTOMER_NO   = :PARM-CUSTOMER-NO-TEMP                      
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7400                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
             MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE               
             MOVE PROGRAM-NAME          TO ABEND-PROGRAM                
             MOVE 'SELECT'              TO ABEND-FUNCTION               
             MOVE SPACES                TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
             MOVE 'CSS_CUSTOMER'        TO TABLE-1                      
             MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1              
             MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2              
             MOVE PARM-CUSTOMER-NO-TEMP TO HOSTVAR-ELEMENT-1            
             MOVE PARM-ACCOUNT-NO-TEMP  TO HOSTVAR-ELEMENT-2            
             PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT             
             PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7410-INSERT-EBILL                                             *         
      *     INSERTS ROW INTO CSS_CUST_STATS TABLE                     *         
      *****************************************************************         
       7410-INSERT-EBILL.                                               
                                                                        
           MOVE '7410'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
             INSERT INTO CSS_CUST_STATS                                 
                    (CUSTOMER_NO                                        
                    ,CUSTOMER_TYPE                                      
                    ,SSN                                                
                    ,NAME_ID                                            
                    ,CODE_STATE_ID                                      
                    ,DRIVERS_LICENSE_NO                                 
                    ,EMPLOYER                                           
                    ,EMPLOYED_DATE                                      
                    ,OCCUPATION                                         
                    ,OTHER_ID_TYPE                                      
                    ,OTHER_ID                                           
                    ,DRVR_LIC_ISS_DT                                    
                    ,DATE_OF_BIRTH                                      
                    ,EMPLOYEE_NBR                                       
                    ,INTR_CO_IND                                        
                    ,EBILL_REGISTER_IND                                 
                    ,PASSWORD_HINT_CD                                   
                    ,PASSWORD_TX                                        
                    ,REFUSED_SSN_FL                                     
                    ,LANGUAGE_PREF_CD                                   
                    ,DOB_VERIFIED_CD)                                   
             VALUES (:PARM-CUSTOMER-NO-TEMP                             
                    ,'C'                                                
                    ,''                                                 
                    ,:CU-NAME-ID                                        
                    ,''                                                 
                    ,''                                                 
                    ,''                                                 
                    ,NULL                                               
                    ,''                                                 
                    ,''                                                 
                    ,''                                                 
                    ,NULL                                               
                    ,NULL                                               
                    ,''                                                 
                    ,''                                                 
                    ,:PARM-EBILL-REGISTER-IND                           
                    ,''                                                 
                    ,''                                                 
                    ,''                                                 
                    ,''                                                 
                    ,'')                                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
             MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE               
             MOVE PROGRAM-NAME          TO ABEND-PROGRAM                
             MOVE 'INSERT'              TO ABEND-FUNCTION               
             MOVE SPACES                TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
             MOVE 'CSS_CUST_STATS'      TO TABLE-1                      
             MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1              
             MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2              
             MOVE PARM-CUSTOMER-NO-TEMP TO HOSTVAR-ELEMENT-1            
             MOVE PARM-ACCOUNT-NO-TEMP  TO HOSTVAR-ELEMENT-2            
             PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT             
             PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7410-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7420-UPDATE-EBILL                                             *         
      *     UPDATES EBILL REGISTER IND ON CSS_CUST_STATS              *         
      *****************************************************************         
       7420-UPDATE-EBILL.                                               
                                                                        
           MOVE '7420'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
             UPDATE CSS_CUST_STATS                                      
                SET EBILL_REGISTER_IND = :PARM-EBILL-REGISTER-IND       
              WHERE CUSTOMER_NO   = :PARM-CUSTOMER-NO-TEMP              
                AND CUSTOMER_TYPE = 'C'                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
             MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE               
             MOVE PROGRAM-NAME          TO ABEND-PROGRAM                
             MOVE 'UPDATE'              TO ABEND-FUNCTION               
             MOVE SPACES                TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
             MOVE 'CSS_CUST_STATS'      TO TABLE-1                      
             MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1              
             MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2              
             MOVE PARM-CUSTOMER-NO-TEMP TO HOSTVAR-ELEMENT-1            
             MOVE PARM-ACCOUNT-NO-TEMP  TO HOSTVAR-ELEMENT-2            
             PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT             
             PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7420-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************07969900
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                     07970000
      ******************************************************************07970100
           EXEC SQL                                                     07970200
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                    07980000
                                                                        
      ******************************************************************08000000
      *       END PROGRAM COPYLIB                                      *08010000
      ******************************************************************08020000
           EXEC SQL                                                             
               INCLUDE CPD00321                                                 
           END-EXEC.                                                            
