       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04684.                                         
COB303 DATE-WRITTEN.     SEP 16, 2013.                                  
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00060000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00070000
      ******************************************************************00150000
      *                 P R O G R A M  S U M M A R Y                   *00160000
      *  THE PROCEDURE WILL BRING BACK CODE-PERM-BILL, CODE-TEMP-BILL  *        
      *  AND  CODE ACCT BILLED WHEN ACCOUNT NUMBER IS PASSED.          *        
      *                                                                *        
      ******************************************************************00220000
      *                                                                *00230000
      *                     PROGRAM MODIFICATION LOG                   *00240000
      *                                                                *00250000
      *    DATE    INITIALS   COMMENTS                                 *00260000
      *  --------  --------   ---------------------------------------  *00270000
P00740*  09/16/13  SV95326    INITIAL VERSION.                         *00280000
      ******************************************************************00300000
      ******************************************************************00310000
      *                                                                *00320000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00330000
      *                                                                *00340000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00350000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00360000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00370000
      *  3000 - 4999  NOT USED                                         *00380000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00390000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00400000
      *  7000 - 7999  INPUT MODULES                                    *00410000
      *  8000 - 8999  OUTPUT MODULES                                   *00420000
      *  9000 - 9999  TERMINATION, ABEND, MESSAGING MODULES            *00430000
      *                                                                *00440000
      ******************************************************************00450000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04684'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04684 STARTS HERE'.                  
                                                                        
      ******************************************************************00540000
      *    DB2 INCLUDES                                                *00550000
      ******************************************************************00560000
                                                                        
           EXEC SQL                                                     00580000
              INCLUDE SQLCA                                             00590000
           END-EXEC.                                                    00600000
                                                                        
      *-------< INCLUDE CSS_ACCOUNT       >                             00620000
                                                                        
           EXEC SQL                                                     00630000
              INCLUDE TBACCT                                            00640000
           END-EXEC.                                                    00650000
                                                                        
      ******************************************************************00770000
      *    COBOL WORKING STORAGE COPY BOOKS                            *00780000
      ******************************************************************00790000
      *--------<COMMON SYSTEM AREA >                                    00860000
           COPY CCA00001.                                               00870000
      *--------< ERROR HANDLING >                                       00880000
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
      *--------< ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS >       00900000
           COPY CWS00027.                                               00910000
      *--------< SUPPORTS DB2 AND SQL ERROR CHECKING >                  00920000
           COPY CWS00303.                                               00930000
      ******************************************************************00950000
      *    WORK AREAS                                                  *00960000
      ******************************************************************00970000
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR04684'.      
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-ACCOUNT-NO-TEMP    PIC X(13).                       
           05  PARM-ACCOUNT-NO-NUM     REDEFINES PARM-ACCOUNT-NO-TEMP   
                                       PIC 9(13).                       
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
      *                                                                         
       01  GTT-MISC-FIELDS.                                             
           05  GTT-NAME                PIC X(26)                        
                                           VALUE 'SESSION.CSR04684_R1'. 
           05  GTT-ROW.                                                 
               49 GTT-ROW-LEN          PIC S9(04) COMP.                 
               49 GTT-ROW-CHAR         PIC X(1024).                     
           05  GTT-SQLCODE             PIC S9(9) COMP.                  
      *                                                                         
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
           05  RS-CODE-PERM-BILL       PIC X(1)  VALUE  SPACES.         
           05  RS-CODE-TEMP-BILL       PIC X(1)  VALUE  SPACES.         
           05  RS-ACCT-CREDIT-GRP      PIC X(1)  VALUE  SPACES.         
           05  RS-CODE-ACCT-BILLED     PIC X(1)  VALUE  SPACES.         
      *                                                                         
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE           PIC S9(9) COMP VALUE 0.          
           05  S-CODE-PERM-BILL        PIC X(1)  VALUE  SPACES.         
           05  S-CODE-TEMP-BILL        PIC X(1)  VALUE  SPACES.         
           05  S-ACCT-CREDIT-GRP       PIC X(1)  VALUE  SPACES.         
           05  S-CODE-ACCT-BILLED      PIC X(1)  VALUE  SPACES.         
      *                                                                         
       01  GENERAL-WORKING-STORAGE.                                     
COB305     05 WS-ACCOUNT-NO        PIC S9(13) USAGE COMP-3 VALUE 0.          
           05  WS-ACCOUNT-NO-CHAR     PIC X(13).                        
           05  WS-ACCOUNT-NO-INT      PIC 9(13).                        
COB305     05 WS-ACCOUNT-NO-CHK        PIC S9(13)V USAGE COMP-3 VALUE 0.        
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
HPCCDM*EJECT                                                            02000000
       LINKAGE SECTION.                                                 
       01  PARM-ACCOUNT-NO             PIC X(13).                       
                                                                        
       PROCEDURE DIVISION USING PARM-ACCOUNT-NO.                        
                                                                        
      ******************************************************************02030000
      * 0000-MAINLINE                                                  *02040000
      *     CALLS 0100-INITIALIZE                                      *02050000
      *           1000-PROCESS-INPUT                                   *02060000
      *           2000-PROCESS-OUTPUT                                  *02070000
      *           9999-END-PROGRAM                                     *02080000
      *                                                                *02090000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *02100000
      ******************************************************************02110000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02230000
      * 0100-INITIALIZE                                                *02240000
      *     CALLS 9000-SEND-ERROR-RESULT                               *02250000
      *           9900-SQL-ERROR-ROUTINE                               *02260000
      *                                                                *02270000
      *     CALLED FROM 0000-MAINLINE                                  *02280000
      *                                                                *02290000
      *     1. RESET DB2 ERROR HANDLERS                                *02300000
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *02310000
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *02320000
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*02330000
      *                                                                *02340000
      ******************************************************************02350000
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'          TO ACTIVE-PARAGRAPH.                    
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           EXEC SQL                                                     
                DECLARE C1 CURSOR  FOR                       
                SELECT                                                  
                      :S-RETURN-CODE               AS RETURN_CODE       
                     ,LTRIM(RTRIM(:S-CODE-PERM-BILL))     AS 
           CODE_PERM_BILL    
                     ,LTRIM(RTRIM(:S-CODE-TEMP-BILL))     AS 
           CODE_TEMP_BILL    
                     ,LTRIM(RTRIM(:S-ACCT-CREDIT-GRP))    AS 
           ACCT_CREDIT_GRP   
                     ,LTRIM(RTRIM(:S-CODE-ACCT-BILLED))   AS 
           CODE_ACCT_BILLED  
                FROM                                                    
                     CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE C1 CURSOR WITH RETURN FOR                               
MFA-TR*         SELECT                                                          
MFA-TR*               :S-RETURN-CODE               AS RETURN_CODE               
MFA-TR*              ,STRIP(:S-CODE-PERM-BILL)     AS CODE_PERM_BILL            
MFA-TR*              ,STRIP(:S-CODE-TEMP-BILL)     AS CODE_TEMP_BILL            
MFA-TR*              ,STRIP(:S-ACCT-CREDIT-GRP)    AS ACCT_CREDIT_GRP           
MFA-TR*              ,STRIP(:S-CODE-ACCT-BILLED)   AS CODE_ACCT_BILLED          
MFA-TR*         FROM                                                            
MFA-TR*              SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02640000
      * 1000-PROCESS-INPUT                                             *02650000
      *     CALLS 1100-RECEIVE-PARMS                                   *02660000
      *                                                                *02670000
      *     CALLED FROM 0000-MAINLINE                                  *02680000
      *                                                                *02690000
      *     1. RECEIVE PARMS.                                          *02700000
      ******************************************************************02710000
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-ACCOUNT-NO         TO PARM-ACCOUNT-NO-TEMP.        
           MOVE PARM-ACCOUNT-NO         TO WS-ACCOUNT-NO-CHAR.          
           UNSTRING WS-ACCOUNT-NO-CHAR DELIMITED BY SPACES              
                                        INTO WS-ACCOUNT-NO-INT.         
           MOVE WS-ACCOUNT-NO-INT       TO WS-ACCOUNT-NO.               
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03210000
      * 2000-PROCESS-OUTPUT.                                           *03220000
      *     CALLS 2100-DESCRIBE-RESULT                                 *03230000
      *           2300-BUILD-RESULT                                    *03240000
      *                                                                *03250000
      *      CALLED FROM 0000-MAINLINE                                 *03260000
      *                                                                *03270000
      *      SETS UP PARAMETERS TO BE RETURNED, POPULATES THE PARMS    *03280000
      *      AND SENDS THEN BACK                                       *03290000
      ******************************************************************03300000
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2300-BUILD-RESULT             THRU 2300-EXIT.        
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  2000A-MOVE-RESULT.                                            *        
      ******************************************************************        
      *                                                                         
       2000A-MOVE-RESULT.                                               
                                                                        
           MOVE RS-RETURN-CODE        TO S-RETURN-CODE.                 
           MOVE RS-CODE-PERM-BILL     TO S-CODE-PERM-BILL.              
           MOVE RS-CODE-TEMP-BILL     TO S-CODE-TEMP-BILL.              
           MOVE RS-ACCT-CREDIT-GRP    TO S-ACCT-CREDIT-GRP.             
           MOVE RS-CODE-ACCT-BILLED   TO S-CODE-ACCT-BILLED.            
      *                                                                         
       2000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************06620000
      * 2300-BUILD-RESULT                                              *06630000
      *     CALLS  7300-SELECT-BILL-CODE                               *06640011
      *            7400-SELECT-LOCK-BOX-NO                             *        
      *            8100-SEND-RESULT                                    *        
      *                                                                *        
      *     CALLED FROM 2000-PROCESS-OUTPUT                            *06680000
      *                                                                *06690000
      *     BUILD THE RESULT SET DESCRIBED ABOVE.                      *06700000
      ******************************************************************06710000
       2300-BUILD-RESULT.                                               
                                                                        
           MOVE '2300'                          TO ACTIVE-PARAGRAPH.    
                                                                        
           PERFORM 7300-SELECT-BILL-CODE     THRU 7300-EXIT.            
           MOVE AT-CODE-PERM-BILL   TO RS-CODE-PERM-BILL.               
           MOVE AT-CODE-TEMP-BILL   TO RS-CODE-TEMP-BILL.               
           MOVE AT-CREDIT-GROUP     TO RS-ACCT-CREDIT-GRP.              
           MOVE AT-CODE-ACCT-BILLED TO RS-CODE-ACCT-BILLED.             
           PERFORM 2000A-MOVE-RESULT          THRU 2000A-EXIT.          
           ADD +1                             TO   CTR-ROWS.            
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************07491300
      * 7300-SELECT-BILL-CODE                                          *07492029
      *     CALLS       9000-SEND-ERROR-RESULT                         *07500000
      *                 9900-SQL-ERROR-ROUTINE                         *07510000
      *                                                                *07520000
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      *     SELECT FROM CSS_ACCOUNT                                    *07530029
      ******************************************************************07550000
       7300-SELECT-BILL-CODE.                                           
                                                                        
           EXEC SQL                                                     
                SELECT CODE_PERM_BILL                                   
                      ,CODE_TEMP_BILL                                   
                      ,CREDIT_GROUP                                     
                      ,CODE_ACCT_BILLED                                 
                INTO   :AT-CODE-PERM-BILL                               
                      ,:AT-CODE-TEMP-BILL                               
                      ,:AT-CREDIT-GROUP                                 
                      ,:AT-CODE-ACCT-BILLED                             
                FROM CSS_ACCOUNT                                        
                WHERE ACCOUNT_NO   = :WS-ACCOUNT-NO                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE.                
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7300'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************07969900
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                     07970000
      ******************************************************************07970100
           EXEC SQL                                                     07970200
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                    07980000
                                                                        
      ******************************************************************08000000
      *       END PROGRAM COPYLIB                                      *08010000
      ******************************************************************08020000
           EXEC SQL                                                             
               INCLUDE CPD00321                                                 
           END-EXEC.                                                            
      *    COPY CPD00302.                                                       
