       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04683.                                         
COB303 DATE-WRITTEN.     SEP 18, 2013.                                  
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00060000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00070000
      ******************************************************************00150000
      *                 P R O G R A M  S U M M A R Y                   *00160000
      *                                                                *00170000
      *                                                                *        
      *                                                                *        
      ******************************************************************00220000
      *                                                                *00230000
      *                     PROGRAM MODIFICATION LOG                   *00240000
      *                                                                *00250000
      *    DATE       INITIALS   COMMENTS                              *00260000
      *  ------------------------------------------------------------  *00270000
      *  09/19/13    SV95326  INITIAL VERSION.                         *00280000
      *  11 MAY 2015 RF10596  REMOVE UNUSED DATA                       *00280000
A05136*  12/23/15    SV95326  REMOVE RS-RETURN-CODE = 5665 WHEN        *00280000
A05136*  12/23/15    SV95326  WS-COMMON-DATE > BILL WINDOW CLOSE DATE. *00280000
      *                                                                *00280000
A05744** 03/01/17  NC94746    ADD RELEASE FOR BILLING NEW OPTION TO ADD*        
A05744**                      ACCOUNT TO OFF-CYC FOR IMMEDIATE BILLING *        
      ******************************************************************00300000
      ******************************************************************00310000
      *                                                                *00320000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00330000
      *                                                                *00340000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00350000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00360000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00370000
      *  3000 - 4999  NOT USED                                         *00380000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00390000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00400000
      *  7000 - 7999  INPUT MODULES                                    *00410000
      *  8000 - 8999  OUTPUT MODULES                                   *00420000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00430000
      *                                                                *00440000
      ******************************************************************00450000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04683'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04683 STARTS HERE'.                  
                                                                        
      ******************************************************************00540000
      *    DB2 INCLUDES                                                *00550000
      ******************************************************************00560000
                                                                        
           EXEC SQL                                                     00580000
              INCLUDE SQLCA                                             00590000
           END-EXEC.                                                    00600000
                                                                        
      *-------< INCLUDE CSS_ACCOUNT       >                             00620000
                                                                        
           EXEC SQL                                                     00630000
              INCLUDE TBACCT                                            00640000
           END-EXEC.                                                    00650000
                                                                        
      *-------< INCLUDE CSS_OFF_CYCL_ACCT >                             00620000
                                                                        
           EXEC SQL                                                     00630000
              INCLUDE TBOFFCYL                                          00640000
           END-EXEC.                                                    00650000
                                                                        
      *---< CSS_MNT_TRANS_HIST >                                                
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
                                                                        
      *---< CSS_MT_TRN_HST_DET >                                                
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
             INCLUDE TBBILWDW                                                   
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBUTLENV                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBMTRENV                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBRGREAD                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBACTATT                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     00630000
              INCLUDE TBATTRIB                                          00640000
           END-EXEC.                                                    00650000
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
      *                                                                         
      *-------< INCLUDE CSS_CUST_STATS >                                00620000
           EXEC SQL                                                     00630000
              INCLUDE TBCSTSTS                                          00640000
           END-EXEC.                                                    00650000
      *-------< INCLUDE CSS_EDI_ACCT_DEST >                             00620000
           EXEC SQL                                                     00630000
              INCLUDE TBACDEST                                          00640000
           END-EXEC.                                                    00650000
      *-------< INCLUDE CSS_ADDR_FREEFORM >                             00620000
           EXEC SQL                                                     00630000
              INCLUDE TBADRFRE                                          00640000
           END-EXEC.                                                    00650000
A05744*-------< INCLUDE CSS_SO_FINAL_BILL >                                     
A05744     EXEC SQL                                                             
A05744        INCLUDE TBSOFIN                                                   
A05744     END-EXEC.                                                            
      *                                                                         
      ******************************************************************00770000
      *    COBOL WORKING STORAGE COPY BOOKS                            *00780000
      ******************************************************************00790000
      *--------<COMMON SYSTEM AREA >                                    00860000
           COPY CCA00001.                                               00870000
      *--------< ERROR HANDLING >                                       00880000
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
      *--------< ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS >       00900000
           COPY CWS00027.                                               00910000
      *--------< SUPPORTS DB2 AND SQL ERROR CHECKING >                  00920000
           COPY CWS00303.                                               00930000
      ******************************************************************00950000
      *    WORK AREAS                                                  *00960000
      ******************************************************************00970000
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR04683'.      
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-ACCOUNT-NO-TEMP    PIC X(13).                       
           05  PARM-ACCOUNT-NO-NUM REDEFINES PARM-ACCOUNT-NO-TEMP       
                                       PIC 9(13).                       
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(08)  VALUE SPACES.         
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
                                                                        
       01  GTT-MISC-FIELDS.                                             
           05  GTT-NAME                PIC X(26)                        
                                           VALUE 'SESSION.CSR04683_R1'. 
           05  GTT-ROW.                                                 
               49 GTT-ROW-LEN          PIC S9(04) COMP.                 
               49 GTT-ROW-CHAR         PIC X(1024).                     
           05  GTT-SQLCODE             PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE           PIC S9(9) COMP VALUE 0.          
                                                                        
       01  GENERAL-WORKING-STORAGE.                                     
COB305     05 WS-ACCOUNT-NO        PIC S9(13) USAGE COMP-3 VALUE 0.          
           05  WS-ACCOUNT-NO-CHAR     PIC X(13).                        
           05  WS-ACCOUNT-NO-INT      PIC 9(13).                        
COB305     05 WS-ACCOUNT-NO-CHK        PIC S9(13)V USAGE COMP-3 VALUE 0.        
           05  WS-MASTER              PIC X(01) VALUE 'M'.              
           05  WS-YES                 PIC X(01) VALUE 'Y'.              
           05  WS-NO                  PIC X(01) VALUE 'N'.              
           05  WS-HOLD                PIC X(01) VALUE 'H'.              
           05  WS-RELEASE             PIC X(01) VALUE 'R'.              
A05744     05  WS-RELEASE-FOR-BILL    PIC X(01) VALUE 'I'.              
           05  WS-SPACE               PIC X(01) VALUE ' '.              
           05  WS-MN-AWAITING-RD-COUNT PIC S9(04) COMP VALUE ZERO.      
           05  WS-RG-AWAITING-RD-COUNT PIC S9(04) COMP VALUE ZERO.      
           05  WS-VERIFIED-READ        PIC X(01)   VALUE 'K'.           
           05  WS-BILL-NOTIFICATION    PIC X(05) VALUE SPACES.          
           05  WS-ATTRIBUTE-TYPE       PIC X(08) VALUE SPACES.          
           05  WS-PAPERLESS            PIC X(01)  VALUE SPACES.         
           05  WS-INTER-ADD            PIC X(01)  VALUE SPACES.         
           05  WS-COMMON-DATE         PIC X(10).                        
           05  WS-BN-OPEN-DATE        PIC X(10).                        
           05  WS-BN-CLOSE-DATE       PIC X(10).                        
           05  WS-CM-OPEN-DATE        PIC X(10).                        
           05  WS-CM-CLOSE-DATE       PIC X(10).                        
           05  WS-PM-OPEN-DATE        PIC X(10).                        
           05  WS-PM-CLOSE-DATE       PIC X(10).                        
           05  WS-CURR-REV-MONTH      PIC 9(06).                        
           05  WS-PRV-CODE-PERM-BILL  PIC X(01) VALUE SPACE.            
           05  WS-EXCLUDE             PIC X(01) VALUE 'X'.              
           05  WS-UT-COUNT             PIC S9(04) COMP VALUE ZERO.      
           05  WS-READS-POSTED         PIC S9(04) COMP VALUE ZERO.      
           05  WS-ATTRB-VAL-TX         PIC X(22)  VALUE SPACES.         
           05  WS-OLD-NO-COPIES        PIC S9(4) COMP VALUE ZEROS.      
           05  WS-PAPERLESS-IND        PIC X(01) VALUE  SPACES.         
           05  WS-EBILL-REGISTER-IND   PIC X(01) VALUE  SPACES.         
           05  WS-PRV-CODE-TEMP-BILL  PIC X(01) VALUE SPACE.            
           05  WS-TRAN-APPL-NO        PIC S9(4) COMP.                   
           05  WS-DUPLICATE-ROW       PIC S9(9) VALUE -803.             
           05  WS-PRV-CODE-ACCT-BILL  PIC X(01) VALUE SPACE.            
           05  WS-XFER-CONSOLIDATED   PIC X(01) VALUE 'M'.              
           05  WS-XFER-REGULAR        PIC X(01) VALUE 'T'.              
           05  WS-XFER-GUARANTOR      PIC X(01) VALUE 'G'.              
           05  WS-F                   PIC X(01) VALUE 'F'.              
           05  WS-PREV-REVENUE-MONTH.                                   
               10 WS-PREV-REV-YYYY    PIC 9(04).                        
               10 WS-PREV-REV-MM      PIC 9(02).                        
           05  WS-PREV-REV-MONTH REDEFINES                              
               WS-PREV-REVENUE-MONTH   PIC 9(06).                       
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  WS-NO-NOTIFICATION     PIC X(01)  VALUE 'N'.             
               88 NO-NOTIFICATION                VALUE 'Y'.             
           05  WS-PAPER-ONLY           PIC X(01) VALUE 'N'.             
               88 PAPER-ONLY                     VALUE 'Y'.             
           05  WS-METER-NOT-READ       PIC X(01) VALUE 'Y'.             
               88 METER-NOT-READ-FOUND           VALUE 'N'.             
           05  ACCT-ON-HOLD-SW         PIC X(01) VALUE 'N'.             
               88 ACCT-IS-ON-HOLD                VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
                                                                        
           EXEC SQL                                                     
               DECLARE UTIL_ENVRNMT CURSOR FOR                          
                SELECT ACCOUNT_NO,                                      
                       CODE_UTIL_TYPE,                                  
                       IC_NO,                                           
                       READ_CYCLE,                                      
                       READ_ROUTE                                       
                  FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                   
                 WHERE ACCOUNT_NO      = :UT-ACCOUNT-NO                 
                   AND (CODE_UTIL_TYPE = 'E'                            
                    OR CODE_UTIL_TYPE  = 'G')                           
              ORDER BY ACCOUNT_NO, CODE_UTIL_TYPE, IC_NO                
              FOR READ ONLY                                     
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE UTIL_ENVRNMT CURSOR FOR                                  
MFA-TR*         SELECT ACCOUNT_NO,                                              
MFA-TR*                CODE_UTIL_TYPE,                                          
MFA-TR*                IC_NO,                                                   
MFA-TR*                READ_CYCLE,                                              
MFA-TR*                READ_ROUTE                                               
MFA-TR*           FROM CSS_UTIL_ENVRNMT                                         
MFA-TR*          WHERE ACCOUNT_NO      = :UT-ACCOUNT-NO                         
MFA-TR*            AND (CODE_UTIL_TYPE = 'E'                                    
MFA-TR*             OR CODE_UTIL_TYPE  = 'G')                                   
MFA-TR*       ORDER BY ACCOUNT_NO, CODE_UTIL_TYPE, IC_NO                        
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*       QUERYNO 7350                                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       LINKAGE SECTION.                                                 
                                                                        
       01  PARM-ACCOUNT-NO               PIC X(13).                     
       01  PARM-CODE-PERM-BILL           PIC X(01).                     
       01  PARM-CODE-TEMP-BILL           PIC X(01).                     
       01  PARM-RELEASE-BILL-OPTN        PIC X(01).                     
       01  PARM-USER-ID                  PIC X(07).                     
       01  PARM-TRAN-COMMENT-LEN         PIC S9(4) COMP.                
       01  PARM-TRAN-COMMENT             PIC X(210).                    
                                                                        
       PROCEDURE DIVISION USING  PARM-ACCOUNT-NO                        
                                ,PARM-CODE-PERM-BILL                    
                                ,PARM-CODE-TEMP-BILL                    
                                ,PARM-RELEASE-BILL-OPTN                 
                                ,PARM-USER-ID                           
                                ,PARM-TRAN-COMMENT-LEN                  
                                ,PARM-TRAN-COMMENT .                    
                                                                        
      ******************************************************************02030000
      * 0000-MAINLINE                                                  *02040000
      *     CALLS 0100-INITIALIZE                                      *02050000
      *           1000-PROCESS-INPUT                                   *02060000
      *           2000-PROCESS-OUTPUT                                  *02070000
      *           9999-END-PROGRAM                                     *02080000
      *                                                                *02090000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *02100000
      ******************************************************************02110000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           MOVE '0000'                 TO ACTIVE-PARAGRAPH.             
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02230000
      * 0100-INITIALIZE                                                *02240000
      *     CALLS 9000-SEND-ERROR-RESULT                               *02250000
      *           9900-SQL-ERROR-ROUTINE                               *02260000
      *                                                                *02270000
      *     CALLED FROM 0000-MAINLINE                                  *02280000
      *                                                                *02290000
      ******************************************************************02350000
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'                  TO ACTIVE-PARAGRAPH.            
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           EXEC SQL                                                     
                DECLARE C1 CURSOR  FOR                       
                SELECT                                                  
                     :S-RETURN-CODE         AS RETURN_CODE              
                FROM                                                    
                     CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE C1 CURSOR WITH RETURN FOR                               
MFA-TR*         SELECT                                                          
MFA-TR*              :S-RETURN-CODE         AS RETURN_CODE                      
MFA-TR*         FROM                                                            
MFA-TR*              SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************02640000
      * 1000-PROCESS-INPUT                                             *02650000
      *     CALLS 1100-RECEIVE-PARMS                                   *02660000
      *                                                                *02670000
      *     CALLED FROM 0000-MAINLINE                                  *02680000
      *                                                                *02690000
      *     RECEIVE PARMS                                              *02700000
      ******************************************************************02710000
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE '1000'                  TO ACTIVE-PARAGRAPH.            
                                                                        
           MOVE PARM-ACCOUNT-NO         TO PARM-ACCOUNT-NO-TEMP.        
           MOVE PARM-ACCOUNT-NO         TO WS-ACCOUNT-NO-CHAR.          
           UNSTRING WS-ACCOUNT-NO-CHAR DELIMITED BY SPACES              
                                        INTO WS-ACCOUNT-NO-INT.         
           MOVE WS-ACCOUNT-NO-INT       TO WS-ACCOUNT-NO.               
           MOVE WS-ACCOUNT-NO-INT       TO WS-ACCOUNT-NO-CHK.           
           MOVE PARM-USER-ID            TO PF-USER-ID .                 
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03210000
      * 2000-PROCESS-OUTPUT.                                           *03220000
      *     CALLS 2100-DESCRIBE-RESULT                                 *03230000
      *           2300-BUILD-RESULT                                    *03240000
      *           2800-TRANSFER-HISTORY                                *        
      *                                                                *03250000
      *     CALLED FROM 0000-MAINLINE                                  *03260000
      *                                                                *03270000
      *     SETS UP PARAMETERS TO BE RETURNED, POPULATES THE PARMS,    *03280000
      *      AND SENDS THEM BACK                                       *03290000
      ******************************************************************03300000
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           PERFORM 2300-BUILD-RESULT        THRU 2300-EXIT.             
           PERFORM 2800-TRANSFER-HISTORY    THRU 2800-EXIT.             
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  2000A-MOVE-RESULT.                                            *        
      ******************************************************************        
       2000A-MOVE-RESULT.                                               
                                                                        
           MOVE RS-RETURN-CODE        TO S-RETURN-CODE.                 
                                                                        
       2000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************06620000
      * 2300-BUILD-RESULT                                              *06630000
      *     CALLS       7000-SELECT-BILL-PULL-CODES                    *06640011
      *                 8000-UPDATE-ACCOUNT                            *        
      *                 8100-SEND-RESULT                               *        
      *                                                                *        
      *     CALLED FROM 2000-PROCESS-OUTPUT                            *06680000
      *                                                                *06690000
      *     BUILD THE RESULT SET DESCRIBED ABOVE                       *06700000
      ******************************************************************06710000
                                                                        
       2300-BUILD-RESULT.                                               
                                                                        
           MOVE '2300'                         TO ACTIVE-PARAGRAPH.     
                                                                        
           PERFORM 7000-SELECT-BILL-PULL-CODES THRU 7000-EXIT.          
A05744     MOVE AT-CODE-ACCT-BILLED      TO WS-PRV-CODE-ACCT-BILL       
A05744     IF AT-CODE-ACCT-BILLED = WS-HOLD                             
A05744        SET ACCT-IS-ON-HOLD TO TRUE                               
A05744     END-IF.                                                      
           PERFORM 7100-SELECT-RESP-AREA       THRU 7100-EXIT.          
           PERFORM 2350-GET-BILL-NOTIFICATION  THRU 2350-EXIT.          
           PERFORM 2700-GET-EBILL-PPRL-IND    THRU 2700-EXIT.           
           IF (WS-PAPERLESS-IND = 'Y' OR                                
               WS-EBILL-REGISTER-IND = 'Y') AND                         
               WS-BILL-NOTIFICATION = '5'                               
               MOVE '2'                       TO WS-BILL-NOTIFICATION   
           END-IF.                                                      
                                                                        
      * ACCOUNT W/ EXTRA POSTAGE SWITCHING TO PAPERLESS                         
           IF PARM-CODE-PERM-BILL = 'D' AND                             
              WS-PRV-CODE-PERM-BILL = 'D' AND                           
SIVA          WS-BILL-NOTIFICATION = '1' AND                            
              AT-NO-BILL-COPIES > 0                                     
                  MOVE 'A' TO PARM-CODE-PERM-BILL
           END-IF.                      
      * ACCOUNT W/ INTERNATIONAL ADDRESS SWITCHING FROM PAPERLESS               
           IF PARM-CODE-PERM-BILL = 'A' AND                             
              WS-PRV-CODE-PERM-BILL = 'A' AND                           
SIVA         (WS-BILL-NOTIFICATION = '2' OR '3') AND                    
              AT-NO-BILL-COPIES = 0 AND                                 
              AT-ADDRESS-ID > 0 AND                                     
              AT-ADDRESS-FORMAT = 'B'                                   
                  MOVE 'N' TO WS-INTER-ADD                              
                  PERFORM 7510-CHECK-ADDRESS THRU 7510-EXIT             
                  IF WS-INTER-ADD = 'Y'                                 
                      MOVE 'D' TO PARM-CODE-PERM-BILL
                  END-IF
           END-IF.                  
      *                                                                         
A05744     IF PARM-RELEASE-BILL-OPTN = WS-RELEASE-FOR-BILL              
A05744        MOVE PARM-ACCOUNT-NO-NUM   TO OC-ACCOUNT-NO               
A05744        IF AT-CODE-ACCT-STAT = 'B'                                
A05744           MOVE 'B'                TO OC-CODE-BILL-OFF-CYCL       
A05744           MOVE SPACES             TO XD-CREDIT-LETTER-IND        
A05744           PERFORM 7970-GET-CRED-LETTER-IND THRU 7970-EXIT        
A05744           MOVE XD-CREDIT-LETTER-IND TO OC-CREDIT-LETTER-IND      
A05744        ELSE                                                      
A05744           MOVE ' '                TO OC-CODE-BILL-OFF-CYCL       
A05744                                      OC-CREDIT-LETTER-IND        
A05744        END-IF                                                    
A05744        PERFORM 8010-DLT-OFF-CYCL-ACCT    THRU 8010-EXIT          
A05744        PERFORM 8035-UPDATE-OFF-CYCLE-TBL THRU 8035-EXIT          
A05744     ELSE                                                         
              IF PARM-RELEASE-BILL-OPTN = WS-HOLD OR WS-EXCLUDE         
                 IF PARM-RELEASE-BILL-OPTN = WS-HOLD                    
                    MOVE WS-HOLD             TO AT-CODE-ACCT-BILLED     
                 ELSE                                                   
                    MOVE WS-EXCLUDE          TO AT-CODE-ACCT-BILLED     
                 END-IF                                                 
              ELSE                                                      
                 IF PARM-RELEASE-BILL-OPTN = WS-RELEASE                 
                      AND ( AT-CREDIT-GROUP NOT EQUAL 'D' AND 'M' )     
                    PERFORM 2400-SET-CODE-ACCT-BILL THRU 2400-EXIT      
                 ELSE                                                   
                    PERFORM 8035-UPDATE-OFF-CYCLE-TBL THRU 8035-EXIT    
                 END-IF                                                 
              END-IF                                                    
A05744     END-IF.                                                      
      *                                                                         
           PERFORM 8000-UPDATE-ACCOUNT         THRU 8000-EXIT.          
                                                                        
           PERFORM 2000A-MOVE-RESULT             THRU 2000A-EXIT.       
           ADD +1                                TO   CTR-ROWS.         
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2350-GET-BILL-NOTIFICATION                                     *        
      *                                                                *07520000
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      *     SELECT FROM CSS_ACCOUNT AND CSS_ACCT_ATTRIBUTE             *07530029
      ******************************************************************07550000
      *                                                                         
       2350-GET-BILL-NOTIFICATION.                                      
      *                                                                         
           PERFORM 7700-GET-EBILL-COPIES THRU 7700-EXIT.                
           MOVE 'EMAIL_BILLNOTIFY'    TO YP-ATTRIBUTE-DESC.             
           PERFORM 7800-CHECK-ACCT-ATTRB  THRU 7800-EXIT.               
           IF NO-NOTIFICATION                                           
              MOVE '4'                TO WS-BILL-NOTIFICATION           
           ELSE                                                         
              IF AT-NO-BILL-COPIES EQUAL 0                              
                 MOVE '1'             TO WS-BILL-NOTIFICATION           
              ELSE                                                      
                 IF AT-NO-BILL-COPIES > 0                               
                    MOVE 'EMAIL_PAPERONLY'   TO YP-ATTRIBUTE-DESC       
                    MOVE 'EMAIL'             TO WS-ATTRIBUTE-TYPE       
                    PERFORM 7900-CHECK-ATTRB THRU 7900-EXIT             
                    IF PAPER-ONLY                                       
                       MOVE '3'       TO WS-BILL-NOTIFICATION           
                    ELSE                                                
                       MOVE '5'       TO WS-BILL-NOTIFICATION           
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************06620000
      ** CODE TO SET THE AT-CODE-ACCT-BILLED CORRECTLY IN ALL CASES   **06620000
      ******************************************************************06620000
       2400-SET-CODE-ACCT-BILL.                                         
      *                                                                         
           MOVE '2400'                     TO ACTIVE-PARAGRAPH.         
      *                                                                         
           PERFORM 7310-GET-COMMON-DATE THRU 7310-EXIT.                 
           PERFORM 7315-GET-MAX-REV-MONTH THRU 7315-EXIT.               
           MOVE BN-REVENUE-MONTH           TO WS-CURR-REV-MONTH.        
           MOVE AT-BILL-CYCLE              TO BN-BILL-CYCLE.            
           PERFORM 7320-GET-BILL-WINDOW-DT THRU 7320-EXIT.              
           MOVE WS-BN-OPEN-DATE            TO WS-CM-OPEN-DATE.          
           MOVE WS-BN-CLOSE-DATE           TO WS-CM-CLOSE-DATE.         
           IF  AT-REV-MTH-LST-NRML EQUAL WS-CURR-REV-MONTH              
               EVALUATE TRUE                                            
                  WHEN WS-COMMON-DATE < WS-CM-OPEN-DATE                 
                      MOVE SPACES          TO AT-CODE-ACCT-BILLED       
                  WHEN ( WS-COMMON-DATE >= WS-CM-OPEN-DATE AND          
                         WS-COMMON-DATE <= WS-CM-CLOSE-DATE )           
                      MOVE WS-YES          TO AT-CODE-ACCT-BILLED       
                  WHEN WS-COMMON-DATE > WS-CM-CLOSE-DATE                
                      MOVE SPACES          TO AT-CODE-ACCT-BILLED       
               END-EVALUATE                                             
           ELSE                                                         
               EVALUATE TRUE                                            
                  WHEN WS-COMMON-DATE < WS-CM-OPEN-DATE                 
                      PERFORM 2410-CHECK-PREV-MONTH THRU 2410-EXIT      
                  WHEN ( WS-COMMON-DATE >=  WS-CM-OPEN-DATE AND         
                         WS-COMMON-DATE <= WS-CM-CLOSE-DATE )           
                      PERFORM 2420-CHECK-BILL-STAT-OPEN THRU            
                                                        2420-EXIT       
                  WHEN WS-COMMON-DATE > WS-CM-CLOSE-DATE                
                      MOVE SPACES          TO AT-CODE-ACCT-BILLED       
               END-EVALUATE                                             
           END-IF.                                                      
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2410-CHECK-PREV-MONTH.                                           
      *                                                                         
           MOVE '2410'                     TO ACTIVE-PARAGRAPH.         
      *                                                                         
           MOVE WS-CURR-REV-MONTH          TO WS-PREV-REV-MONTH.        
      *                                                                         
           COMPUTE WS-PREV-REV-MM = WS-PREV-REV-MM - 1.                 
           IF  WS-PREV-REV-MM = ZEROS                                   
               MOVE 12                     TO WS-PREV-REV-MM            
               COMPUTE WS-PREV-REV-YYYY = WS-PREV-REV-YYYY - 1          
           END-IF.                                                      
      *                                                                         
           MOVE WS-PREV-REV-MONTH          TO BN-REVENUE-MONTH.         
           MOVE AT-BILL-CYCLE              TO BN-BILL-CYCLE.            
           PERFORM 7320-GET-BILL-WINDOW-DT THRU 7320-EXIT.              
           MOVE WS-BN-OPEN-DATE            TO WS-PM-OPEN-DATE.          
           MOVE WS-BN-CLOSE-DATE           TO WS-PM-CLOSE-DATE.         
           EVALUATE TRUE                                                
              WHEN WS-COMMON-DATE < WS-PM-OPEN-DATE                     
                  MOVE SPACES      TO AT-CODE-ACCT-BILLED               
              WHEN ( WS-COMMON-DATE >= WS-PM-OPEN-DATE AND              
                     WS-COMMON-DATE <= WS-PM-CLOSE-DATE )               
                  PERFORM 2420-CHECK-BILL-STAT-OPEN THRU 2420-EXIT      
              WHEN WS-COMMON-DATE > WS-PM-CLOSE-DATE                    
                  MOVE SPACES          TO AT-CODE-ACCT-BILLED           
           END-EVALUATE.                                                
      *                                                                         
       2410-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************06620000
      ** CHECK BILL STATUS FOR OPEN BILL WINDOW                       **06620000
      ******************************************************************06620000
       2420-CHECK-BILL-STAT-OPEN.                                       
      *                                                                         
           MOVE '2420'                     TO ACTIVE-PARAGRAPH.         
      *                                                                         
           PERFORM 2450-CHECK-HELD-RD-ROUTE THRU 2450-EXIT              
           IF WS-UT-COUNT GREATER THAN ZERO                             
              IF WS-READS-POSTED EQUAL WS-UT-COUNT                      
                 MOVE WS-RELEASE       TO AT-CODE-ACCT-BILLED           
              ELSE                                                      
                 MOVE SPACES           TO AT-CODE-ACCT-BILLED           
              END-IF                                                    
           END-IF.                                                      
       2420-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************06620000
      * CHECK TO SEE ALL THE REGISTERS FOR THE ACCT HAVE A READ POSTED *06620000
      ******************************************************************06620000
       2450-CHECK-HELD-RD-ROUTE.                                        
      *                                                                         
           MOVE '2450'                     TO ACTIVE-PARAGRAPH.         
      *                                                                         
           MOVE ZERO                       TO WS-UT-COUNT               
                                              WS-READS-POSTED.          
           MOVE WS-ACCOUNT-NO-CHK          TO UT-ACCOUNT-NO             
           PERFORM 7350-OPEN-UTIL-ENVRNMT            THRU 7350-EXIT.    
           PERFORM 7360-FETCH-UTIL-ENVRNMT           THRU 7360-EXIT.    
           PERFORM 2500-CHECK-READ-CODES             THRU 2500-EXIT     
               UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.             
           PERFORM 7370-CLOSE-UTIL-ENVRNMT           THRU 7370-EXIT.    
      *                                                                         
       2450-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************06620000
      * CHECK TO SEE ALL THE REGISTERS FOR THE ACCT HAVE A READ POSTED *06620000
      ******************************************************************06620000
       2500-CHECK-READ-CODES.                                           
      *                                                                         
           MOVE '2500'                     TO ACTIVE-PARAGRAPH.         
      *                                                                         
           MOVE 'Y'                        TO WS-METER-NOT-READ.        
           MOVE ZERO                       TO WS-MN-AWAITING-RD-COUNT   
                                              WS-RG-AWAITING-RD-COUNT.  
           MOVE UT-ACCOUNT-NO              TO MN-ACCOUNT-NO.            
           MOVE UT-CODE-UTIL-TYPE          TO MN-CODE-UTIL-TYPE.        
           MOVE UT-IC-NO                   TO MN-IC-NO.                 
           MOVE 'D'                        TO MN-CODE-CRNT-REG-READ.    
           PERFORM 7400-SELECT-CNT-MTRD-ENVRNMT      THRU 7400-EXIT.    
           IF WS-MN-AWAITING-RD-COUNT > 0                               
               MOVE 'N' TO WS-METER-NOT-READ                            
           ELSE                                                         
               MOVE UT-ACCOUNT-NO          TO RG-ACCOUNT-NO             
               MOVE UT-CODE-UTIL-TYPE      TO RG-CODE-UTIL-TYPE         
               MOVE UT-IC-NO               TO RG-IC-NO                  
               MOVE 'D'                    TO RG-CODE-CRNT-REG-READ     
               MOVE ZERO                   TO WS-RG-AWAITING-RD-COUNT   
               PERFORM 7410-SELECT-CNT-REGISTER-READ THRU 7410-EXIT     
               IF  WS-RG-AWAITING-RD-COUNT GREATER THAN ZERO            
                   MOVE WS-N               TO WS-METER-NOT-READ         
               END-IF                                                   
           END-IF.                                                      
           IF METER-NOT-READ-FOUND                                      
               NEXT SENTENCE                                            
           ELSE                                                         
               ADD 1                       TO WS-READS-POSTED           
           END-IF.                                                      
           ADD 1                           TO WS-UT-COUNT.              
           PERFORM 7360-FETCH-UTIL-ENVRNMT THRU 7360-EXIT.              
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2700-GET-EBILL-PPRL-IND                                        *        
      *                                                                *07520000
      * GET EBILL AND PAPERLESS INDICATORS                             *        
      *                                                                *        
      ******************************************************************07550000
      *                                                                         
       2700-GET-EBILL-PPRL-IND.                                         
      *                                                                         
           MOVE WS-ACCOUNT-NO               TO NF-ACCOUNT-NO            
           PERFORM 7950-GET-PAPERLESS-IND   THRU 7950-EXIT.             
           MOVE WS-PAPERLESS                TO WS-PAPERLESS-IND.        
           MOVE WS-ACCOUNT-NO               TO AT-ACCOUNT-NO            
           PERFORM 7960-GET-EBILL-REG-IND   THRU 7960-EXIT.             
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              MOVE SPACES                   TO CE-EBILL-REGISTER-IND    
           END-IF.                                                      
           MOVE CE-EBILL-REGISTER-IND       TO WS-EBILL-REGISTER-IND.   
      *                                                                         
       2700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 2800-TRANSFER-HISTORY.                                        *         
      *     CALLS       5000-MAINTENANCE-HISTORY                      * 06640011
      *                 5010-MNT-HST-DET                              *         
      *                                                               *         
      *     CALLED FROM 2000-PROCESS-OUTPUT                           * 06680000
      *                                                               *         
      *     INSERTS INTO CSS_MNT_TRANS_HIST & CSS_MT_TRN_HST_DET      *         
      *****************************************************************         
                                                                        
       2800-TRANSFER-HISTORY.                                           
                                                                        
           MOVE '2800'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           PERFORM 5000-MAINTENANCE-HISTORY   THRU 5000-EXIT.           
                                                                        
           IF PARM-RELEASE-BILL-OPTN = WS-EXCLUDE                       
              MOVE +26                   TO MH-TRAN-COMMENT-LEN         
              MOVE 'ACCT EXCLUDED FROM BILLING'                         
                                         TO MH-TRAN-COMMENT-TEXT        
           END-IF                                                       
                                                                        
           IF WS-PRV-CODE-PERM-BILL = PARM-CODE-PERM-BILL               
             NEXT SENTENCE                                              
           ELSE                                                         
             MOVE 'PERM PULL CODE'       TO MI-COLUMN-DESC              
             MOVE +1                     TO MI-PRV-COLUMN-VALUE-LEN     
             MOVE WS-PRV-CODE-PERM-BILL  TO MI-PRV-COLUMN-VALUE-TEXT    
             MOVE +1                     TO MI-CHG-COLUMN-VALUE-LEN     
             MOVE PARM-CODE-PERM-BILL    TO MI-CHG-COLUMN-VALUE-TEXT    
             MOVE '70'                   TO MI-TABLE-ID                 
             PERFORM 5010-MNT-HST-DETAIL           THRU 5010-EXIT       
           END-IF.                                                      
                                                                        
           IF WS-PRV-CODE-TEMP-BILL = PARM-CODE-TEMP-BILL               
             NEXT SENTENCE                                              
           ELSE                                                         
             MOVE 'TEMP PULL CODE'       TO MI-COLUMN-DESC              
             MOVE +1                     TO MI-PRV-COLUMN-VALUE-LEN     
             MOVE WS-PRV-CODE-TEMP-BILL  TO MI-PRV-COLUMN-VALUE-TEXT    
             MOVE +1                     TO MI-CHG-COLUMN-VALUE-LEN     
             MOVE PARM-CODE-TEMP-BILL    TO MI-CHG-COLUMN-VALUE-TEXT    
             MOVE '71'                   TO MI-TABLE-ID                 
             PERFORM 5010-MNT-HST-DETAIL           THRU 5010-EXIT       
           END-IF.                                                      
      *                                                                         
           IF AT-CODE-ACCT-BILLED NOT EQUAL WS-PRV-CODE-ACCT-BILL       
             MOVE 'ACCT BILLED CD'       TO MI-COLUMN-DESC              
             MOVE +1                     TO MI-PRV-COLUMN-VALUE-LEN     
             MOVE WS-PRV-CODE-ACCT-BILL  TO MI-PRV-COLUMN-VALUE-TEXT    
             MOVE +1                     TO MI-CHG-COLUMN-VALUE-LEN     
             MOVE AT-CODE-ACCT-BILLED    TO MI-CHG-COLUMN-VALUE-TEXT    
             MOVE '72'                   TO MI-TABLE-ID                 
             PERFORM 5010-MNT-HST-DETAIL           THRU 5010-EXIT       
           END-IF.                                                      
*                                                                       
       2800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 5000-MAINTENANCE-HISTORY.                                     *         
      *     CALLS       7300-GET-TIMESTAMP                            * 06640011
      *                                                               *         
      *     CALLED FROM 2800-TRANSFER-HISTORY                         * 06680000
      *                                                               *         
      *     PREPARE MAINTENANCE JOURNAL                               *         
      *****************************************************************         
                                                                        
       5000-MAINTENANCE-HISTORY.                                        
                                                                        
           MOVE '5000'                 TO ACTIVE-PARAGRAPH.             
                                                                        
           PERFORM 7300-GET-TIMESTAMP      THRU 7300-EXIT.              
                                                                        
           MOVE WS-F                   TO MH-CODE-TRAN-TYPE.            
           MOVE PF-RESP-AREA-ID        TO MH-RESP-AREA-ID.              
           MOVE WS-ACCOUNT-NO-CHK      TO MH-ACCOUNT-NO.                
           MOVE ZEROS                  TO MH-CUSTOMER-NO.               
           MOVE ZEROS                  TO MH-PREMISE-NO.                
           MOVE PARM-USER-ID           TO MH-USER-ID.                   
           MOVE 'PANEL490'             TO MH-APPL-PROGRAM-ID.           
           MOVE PARM-TRAN-COMMENT-LEN  TO MH-TRAN-COMMENT-LEN.          
           MOVE PARM-TRAN-COMMENT      TO MH-TRAN-COMMENT-TEXT.         
           MOVE +1                     TO WS-TRAN-APPL-NO.              
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 5010-MNT-HST-DETAIL.                                          *         
      *     CALLS       6530-LOAD-MNT-TRANS-HIST                      * 06640011
      *                                                               *         
      *     CALLED FROM 2800-TRANSFER-HISTORY                         * 06680000
      *****************************************************************         
                                                                        
       5010-MNT-HST-DETAIL.                                             
                                                                        
           MOVE '5010'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO         TO MI-TRANS-HIST-SEQ-NO.   
           MOVE WS-TRAN-APPL-NO              TO MI-TRAN-APPL-NO.        
           PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT.            
           ADD 1                             TO WS-TRAN-APPL-NO.        
                                                                        
       5010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 6530-LOAD-MNT-TRANS-HIST                                       *        
      *                                                                *        
      *     CALLED FROM 5010-MNT-HST-DETAIL                            *        
      *                                                                *        
      *     JOURNALING ROUTINE                                         *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 7000-SELECT-BILL-PULL-CODES                                    *        
      *     CALLS    9000-SEND-ERROR-RESULT                            *        
      *              9900-SQL-ERROR-ROUTINE                            *        
      *                                                                *        
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      ******************************************************************        
                                                                        
       7000-SELECT-BILL-PULL-CODES.                                     
                                                                        
           EXEC SQL                                                     
            SELECT CODE_PERM_BILL,                                      
                   CODE_TEMP_BILL                                       
                  ,CREDIT_GROUP                                         
                  ,BILL_CYCLE                                           
                  ,REV_MTH_LST_NRML                                     
                  ,NO_BILL_COPIES                                       
                  ,COMPANY_NO                                           
                  ,LOCAL_OFFICE                                         
                  ,CODE_ACCT_STAT                                       
                  ,ADDRESS_ID                                           
                  ,ADDRESS_FORMAT                                       
                  ,CUSTOMER_NO                                          
A05744            ,CODE_ACCT_BILLED                                     
             INTO :AT-CODE-PERM-BILL,                                   
                  :AT-CODE-TEMP-BILL                                    
                 ,:AT-CREDIT-GROUP                                      
                 ,:AT-BILL-CYCLE                                        
                 ,:AT-REV-MTH-LST-NRML                                  
                 ,:AT-NO-BILL-COPIES                                    
                 ,:AT-COMPANY-NO                                        
                 ,:AT-LOCAL-OFFICE                                      
                 ,:AT-CODE-ACCT-STAT                                    
                 ,:AT-ADDRESS-ID                                        
                 ,:AT-ADDRESS-FORMAT                                    
                 ,:AT-CUSTOMER-NO                                       
A05744           ,:AT-CODE-ACCT-BILLED                                  
             FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                             
                WHERE ACCOUNT_NO = :WS-ACCOUNT-NO-CHK                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SELECT CODE_PERM_BILL,                                              
MFA-TR*            CODE_TEMP_BILL                                               
MFA-TR*           ,CREDIT_GROUP                                                 
MFA-TR*           ,BILL_CYCLE                                                   
MFA-TR*           ,REV_MTH_LST_NRML                                             
MFA-TR*           ,NO_BILL_COPIES                                               
MFA-TR*           ,COMPANY_NO                                                   
MFA-TR*           ,LOCAL_OFFICE                                                 
MFA-TR*           ,CODE_ACCT_STAT                                               
MFA-TR*           ,ADDRESS_ID                                                   
MFA-TR*           ,ADDRESS_FORMAT                                               
MFA-TR*           ,CUSTOMER_NO                                                  
MFA-TR*           ,CODE_ACCT_BILLED                                             
MFA-TR*      INTO :AT-CODE-PERM-BILL,                                           
MFA-TR*           :AT-CODE-TEMP-BILL                                            
MFA-TR*          ,:AT-CREDIT-GROUP                                              
MFA-TR*          ,:AT-BILL-CYCLE                                                
MFA-TR*          ,:AT-REV-MTH-LST-NRML                                          
MFA-TR*          ,:AT-NO-BILL-COPIES                                            
MFA-TR*          ,:AT-COMPANY-NO                                                
MFA-TR*          ,:AT-LOCAL-OFFICE                                              
MFA-TR*          ,:AT-CODE-ACCT-STAT                                            
MFA-TR*          ,:AT-ADDRESS-ID                                                
MFA-TR*          ,:AT-ADDRESS-FORMAT                                            
MFA-TR*          ,:AT-CUSTOMER-NO                                               
MFA-TR*          ,:AT-CODE-ACCT-BILLED                                          
MFA-TR*      FROM CSS_ACCOUNT                                                   
MFA-TR*         WHERE ACCOUNT_NO = :WS-ACCOUNT-NO-CHK                           
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7000                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               MOVE AT-CODE-PERM-BILL TO WS-PRV-CODE-PERM-BILL          
               MOVE AT-CODE-TEMP-BILL TO WS-PRV-CODE-TEMP-BILL          
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7000'              TO ACTIVE-PARAGRAPH              
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
              MOVE 'CSS_ACCOUNT'       TO TABLE-1                       
              MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
              MOVE WS-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7100-SELECT-RESP-AREA.                                        *         
      *****************************************************************         
       7100-SELECT-RESP-AREA.                                           
                                                                        
           EXEC SQL                                                     
              SELECT PF.RESP_AREA_ID                                    
                INTO :PF-RESP-AREA-ID                                   
                FROM CSS_USER_PROFILE PF WITH(READUNCOMMITTED)                  
               WHERE PF.USER_ID = :PF-USER-ID                           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT PF.RESP_AREA_ID                                            
MFA-TR*         INTO :PF-RESP-AREA-ID                                           
MFA-TR*         FROM CSS_USER_PROFILE PF                                        
MFA-TR*        WHERE PF.USER_ID = :PF-USER-ID                                   
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7100'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_USER_PROFILE'        TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'USER_ID'                 TO TABLE-ELEMENT-2         
              MOVE WS-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE PF-USER-ID                TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7175-REMOVE-FROM-OFF-CYCLE                                     *        
      *     CALLED FROM   8000-UPDATE-ACCOUNT                          *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7175-REMOVE-FROM-OFF-CYCLE.                                      
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_OFF_CYCL_ACCT                            
                WHERE ACCOUNT_NO = :WS-ACCOUNT-NO-CHK AND               
                      CODE_BILL_OFF_CYCL = :WS-SPACE                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM CSS_OFF_CYCL_ACCT                                    
MFA-TR*         WHERE ACCOUNT_NO = :WS-ACCOUNT-NO-CHK AND                       
MFA-TR*               CODE_BILL_OFF_CYCL = :WS-SPACE                            
MFA-TR*      QUERYNO 7175                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE         
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE '7175'                    TO ACTIVE-PARAGRAPH       
               MOVE 'DELETE'                  TO ABEND-FUNCTION         
               MOVE 'CSS_OFF_CYCL_ACCT'       TO TABLE-1                
               MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1        
               MOVE WS-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1      
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7175-EXIT.                                                       
                                                                        
      ******************************************************************        
      * 7300-GET-TIMESTAMP      JOURNALING ROUTINE                     *        
      *                                                                *        
      *     CALLED FROM 5000-MAINTENANCE-HISTORY                       *        
      ******************************************************************        
                                                                        
       7300-GET-TIMESTAMP.                                              
                                                                        
           EXEC SQL                                                     
             SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), DATEADD( SECOND, 10, 
           CIS.CURRENT$TIMESTAMP() ), 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :MH-TRANS-HIST-SEQ-NO,
              :MH-DATE-TRANS                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SET :MH-TRANS-HIST-SEQ-NO = CURRENT TIMESTAMP + 10 SECONDS         
MFA-TR*         ,:MH-DATE-TRANS = CURRENT DATE                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7300'                TO ACTIVE-PARAGRAPH            
              MOVE 'SET'                 TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7310-GET-COMMON-DATE.                                          *        
      ******************************************************************        
                                                                        
       7310-GET-COMMON-DATE.                                            
                                                                        
           EXEC SQL                                                     
             SELECT CIS.SUBSTR3(PARM_DATA,1,10)                              
               INTO :WS-COMMON-DATE                                     
               FROM CSS_JOB_PARM WITH(READUNCOMMITTED)                          
              WHERE PROGRAM_NAME = 'COMMONDATE'                         
                AND COMPANY_NO   = '01'                                 
                AND CMND_CODE    = 'CA00'                               
                AND STATUS       = 'A'                                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT SUBSTR(PARM_DATA,1,10)                                      
MFA-TR*        INTO :WS-COMMON-DATE                                             
MFA-TR*        FROM CSS_JOB_PARM                                                
MFA-TR*       WHERE PROGRAM_NAME = 'COMMONDATE'                                 
MFA-TR*         AND COMPANY_NO   = '01'                                         
MFA-TR*         AND CMND_CODE    = 'CA00'                                       
MFA-TR*         AND STATUS       = 'A'                                          
MFA-TR*       WITH UR                                                           
MFA-TR*      QUERYNO 7310                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7310'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_JOB_PARM'        TO TABLE-1                     
              MOVE 'PROGRAM_NAME'        TO TABLE-ELEMENT-1             
              MOVE 'CMND_CODE'           TO TABLE-ELEMENT-2             
              MOVE 'COMMONDATE'          TO HOSTVAR-ELEMENT-1           
              MOVE 'CA00'                TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7315-GET-MAX-REV-MONTH                                         *        
      ******************************************************************        
       7315-GET-MAX-REV-MONTH.                                          
                                                                        
           EXEC SQL                                                     
              SELECT MAX(REVENUE_MONTH)                                 
                INTO :BN-REVENUE-MONTH                                  
                FROM CSS_BILL_WINDOW WITH(READUNCOMMITTED)                      
               WHERE DATE_EXTRACT = IIF(TRY_CONVERT(DATE, 
                                                        :WS-COMMON-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-COMMON-DATE
              ) <> 0) OR (LEN(:WS-COMMON-DATE) <> 10), CIS.CHAR2DATE(
                                                        :WS-COMMON-DATE
              ), CONVERT(DATE, :WS-COMMON-DATE) )                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MAX(REVENUE_MONTH)                                         
MFA-TR*         INTO :BN-REVENUE-MONTH                                          
MFA-TR*         FROM CSS_BILL_WINDOW                                            
MFA-TR*        WHERE DATE_EXTRACT = :WS-COMMON-DATE                             
MFA-TR*        WITH UR                                                          
MFA-TR*      QUERYNO 7315                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7315'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_BILL_WINDOW'     TO TABLE-1                     
              MOVE 'DATE_EXTRACT'        TO TABLE-ELEMENT-1             
              MOVE WS-COMMON-DATE        TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7315-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 7320-GET-BILL-WINDOW-DT                                        *        
      ******************************************************************        
                                                                        
       7320-GET-BILL-WINDOW-DT.                                         
                                                                        
           EXEC SQL                                                     
              SELECT MAX(DATE_EXTRACT)                                  
                    ,MIN(DATE_EXTRACT)                                  
                INTO :WS-BN-CLOSE-DATE                                  
                    ,:WS-BN-OPEN-DATE                                   
                FROM CSS_BILL_WINDOW WITH(READUNCOMMITTED)                      
               WHERE BILL_CYCLE    = :BN-BILL-CYCLE                     
                 AND REVENUE_MONTH = :BN-REVENUE-MONTH                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MAX(DATE_EXTRACT)                                          
MFA-TR*             ,MIN(DATE_EXTRACT)                                          
MFA-TR*         INTO :WS-BN-CLOSE-DATE                                          
MFA-TR*             ,:WS-BN-OPEN-DATE                                           
MFA-TR*         FROM CSS_BILL_WINDOW                                            
MFA-TR*        WHERE BILL_CYCLE    = :BN-BILL-CYCLE                             
MFA-TR*          AND REVENUE_MONTH = :BN-REVENUE-MONTH                          
MFA-TR*        WITH UR                                                          
MFA-TR*      QUERYNO 7320                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7320'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_BILL_WINDOW'     TO TABLE-1                     
              MOVE 'BILL_CYCLE'          TO TABLE-ELEMENT-1             
              MOVE 'REVENUE_MONTH'       TO TABLE-ELEMENT-2             
              MOVE BN-BILL-CYCLE         TO HOSTVAR-ELEMENT-1           
              MOVE BN-REVENUE-MONTH      TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7320-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      *     7350-OPEN-UTIL-ENVRNMT                                     *        
      *                                                                *        
      ******************************************************************        
       7350-OPEN-UTIL-ENVRNMT.                                          
      *                                                                         
           EXEC SQL                                                     
               OPEN UTIL_ENVRNMT                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7350'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_UTIL_ENVRNMT'    TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE UT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *     7360-FETCH-UTIL-ENVRNMT                                    *        
      *                                                                *        
      ******************************************************************        
       7360-FETCH-UTIL-ENVRNMT.                                         
      *                                                                         
           EXEC SQL                                                     
                FETCH UTIL_ENVRNMT                                      
                 INTO :UT-ACCOUNT-NO,                                   
                      :UT-CODE-UTIL-TYPE,                               
                      :UT-IC-NO,                                        
                      :UT-READ-CYCLE,                                   
                      :UT-READ-ROUTE                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7360'                TO ACTIVE-PARAGRAPH            
              MOVE 'FETCH'               TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_UTIL_ENVRNMT'    TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE UT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7360-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *                                                                *        
      *     7370-CLOSE-UTIL-ENVRNMT                                    *        
      *                                                                *        
      ******************************************************************        
       7370-CLOSE-UTIL-ENVRNMT.                                         
           EXEC SQL                                                     
               CLOSE UTIL_ENVRNMT                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7370'                TO ACTIVE-PARAGRAPH            
              MOVE 'CLOSE'               TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_UTIL_ENVRNMT'    TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE UT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7370-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7400-SELECT-CNT-MTRD-ENVRNMT.                                    
      *                                                                         
           EXEC SQL                                                     
              SELECT COUNT(*)                                           
                INTO :WS-MN-AWAITING-RD-COUNT                           
                FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                     
               WHERE ACCOUNT_NO          = :MN-ACCOUNT-NO               
                 AND CODE_UTIL_TYPE      = :MN-CODE-UTIL-TYPE           
                 AND IC_NO               = :MN-IC-NO                    
                 AND (CODE_CRNT_REG_READ = :MN-CODE-CRNT-REG-READ       
                  OR  CODE_CRNT_REG_READ = :WS-VERIFIED-READ)           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COUNT(*)                                                   
MFA-TR*         INTO :WS-MN-AWAITING-RD-COUNT                                   
MFA-TR*         FROM CSS_MTRD_ENVRNMT                                           
MFA-TR*        WHERE ACCOUNT_NO          = :MN-ACCOUNT-NO                       
MFA-TR*          AND CODE_UTIL_TYPE      = :MN-CODE-UTIL-TYPE                   
MFA-TR*          AND IC_NO               = :MN-IC-NO                            
MFA-TR*          AND (CODE_CRNT_REG_READ = :MN-CODE-CRNT-REG-READ               
MFA-TR*           OR  CODE_CRNT_REG_READ = :WS-VERIFIED-READ)                   
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7400                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7400'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_MTRD_ENVRNMT'    TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2             
              MOVE 'IC_NO'               TO TABLE-ELEMENT-3             
              MOVE MN-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE MN-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2           
              MOVE MN-IC-NO              TO HOSTVAR-ELEMENT-3           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7410-SELECT-CNT-REGISTER-READ.                                   
      *                                                                         
           EXEC SQL                                                     
               SELECT COUNT(*)                                          
                 INTO :WS-RG-AWAITING-RD-COUNT                          
                 FROM CSS_REGISTER_READ WITH(READUNCOMMITTED)                   
                WHERE ACCOUNT_NO             = :RG-ACCOUNT-NO           
                  AND CODE_UTIL_TYPE         = :RG-CODE-UTIL-TYPE       
                  AND IC_NO                  = :RG-IC-NO                
                  AND (CODE_CRNT_REG_READ    = :RG-CODE-CRNT-REG-READ   
                       OR CODE_CRNT_REG_READ = :WS-VERIFIED-READ)       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COUNT(*)                                                  
MFA-TR*          INTO :WS-RG-AWAITING-RD-COUNT                                  
MFA-TR*          FROM CSS_REGISTER_READ                                         
MFA-TR*         WHERE ACCOUNT_NO             = :RG-ACCOUNT-NO                   
MFA-TR*           AND CODE_UTIL_TYPE         = :RG-CODE-UTIL-TYPE               
MFA-TR*           AND IC_NO                  = :RG-IC-NO                        
MFA-TR*           AND (CODE_CRNT_REG_READ    = :RG-CODE-CRNT-REG-READ           
MFA-TR*                OR CODE_CRNT_REG_READ = :WS-VERIFIED-READ)               
MFA-TR*          WITH UR                                                        
MFA-TR*      QUERYNO 7410                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7410'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_REGISTER_READ'   TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2             
              MOVE 'IC_NO'               TO TABLE-ELEMENT-3             
              MOVE MN-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE MN-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2           
              MOVE MN-IC-NO              TO HOSTVAR-ELEMENT-3           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7410-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
                                                                        
       7510-CHECK-ADDRESS.                                              
                                                                        
           EXEC SQL                                                     
               SELECT ADDR_COUNTRY                                      
                 INTO :DZ-ADDR-COUNTRY                                  
                 FROM CSS_ADDR_FREEFORM WITH(READUNCOMMITTED)                   
                WHERE ADDRESS_ID = :AT-ADDRESS-ID                       
                  AND ADDR_COUNTRY > ' '                                
                  AND ADDR_COUNTRY <> 'USA'                             
                  AND ADDR_COUNTRY <> 'US'                              
                  AND ADDR_COUNTRY <> 'UNITED STATES'                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ053
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ADDR_COUNTRY                                              
MFA-TR*          INTO :DZ-ADDR-COUNTRY                                          
MFA-TR*          FROM CSS_ADDR_FREEFORM                                         
MFA-TR*         WHERE ADDRESS_ID = :AT-ADDRESS-ID                               
MFA-TR*           AND ADDR_COUNTRY > ' '                                        
MFA-TR*           AND ADDR_COUNTRY = 'USA'                                     
MFA-TR*           AND ADDR_COUNTRY = 'US'                                      
MFA-TR*           AND ADDR_COUNTRY = 'UNITED STATES'                           
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7510                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-INTER-ADD                             
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-INTER-ADD                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE         
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7510'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE 'CSS_ADDR_FREEFORM' TO TABLE-1                  
                   MOVE 'ADDRESS_ID'     TO TABLE-ELEMENT-1             
                   MOVE AT-ADDRESS-ID    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************07969900
      * 7700-GET-EBILL-COPIES                                          *07492029
      *     CALLS       9000-SEND-ERROR-RESULT                         *07500000
      *                 9900-SQL-ERROR-ROUTINE                         *07510000
      *                                                                *07520000
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      *     SELECT FROM CSS_ACCT_ATTRIBUTE                             *07530029
      ******************************************************************07550000
       7700-GET-EBILL-COPIES.                                           
                                                                        
           EXEC SQL                                                     
                SELECT NO_BILL_COPIES                                   
                      ,COMPANY_NO                                       
                  INTO :AT-NO-BILL-COPIES                               
                      ,:AT-COMPANY-NO                                   
                  FROM CSS_ACCOUNT                                      
                 WHERE ACCOUNT_NO        = :WS-ACCOUNT-NO               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7800'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************07969900
      * 7800-CHECK-ACCT-ATTRB                                          *07492029
      *     CALLS       9000-SEND-ERROR-RESULT                         *07500000
      *                 9900-SQL-ERROR-ROUTINE                         *07510000
      *                                                                *07520000
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      *     SELECT FROM CSS_ACCT_ATTRIBUTE                             *07530029
      ******************************************************************07550000
       7800-CHECK-ACCT-ATTRB.                                           
                                                                        
           EXEC SQL                                                     
                SELECT 'Y'                                              
                  INTO :WS-NO-NOTIFICATION                              
                  FROM CSS_ATTRIBUTE WZ                                 
                      ,CSS_ACCT_ATTRIBUTE YP                            
                 WHERE YP.ACCOUNT_NO        = :WS-ACCOUNT-NO            
                   AND WZ.COMPANY_NO        = :AT-COMPANY-NO            
                   AND WZ.ATTRIBUTE_DESC    = YP.ATTRIBUTE_DESC         
                   AND YP.ATTRIBUTE_DESC    = :YP-ATTRIBUTE-DESC        
                   AND WZ.ATTRIBUTE_STAT_CD = 'A'                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7800'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_ACCT_ATTRIBUTE'  TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7800-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************07969900
      * 7900-CHECK-ATTRB                                               *07492029
      *     CALLS       9000-SEND-ERROR-RESULT                         *07500000
      *                 9900-SQL-ERROR-ROUTINE                         *07510000
      *                                                                *07520000
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      *     SELECT FROM CSS_ACCT_ATTRIBUTE                             *07530029
      ******************************************************************07550000
       7900-CHECK-ATTRB.                                                
                                                                        
           EXEC SQL                                                     
                SELECT 'Y'                                              
                  INTO :WS-PAPER-ONLY                                   
                  FROM CSS_ATTRIBUTE WZ                                 
                      ,CSS_ACCT_ATTRIBUTE YP                            
                 WHERE WZ.ATTRIBUTE_DESC    = YP.ATTRIBUTE_DESC         
                   AND YP.ATTRIBUTE_DESC    = :YP-ATTRIBUTE-DESC        
                   AND WZ.COMPANY_NO        = :AT-COMPANY-NO            
                   AND YP.ACCOUNT_NO        = :WS-ACCOUNT-NO            
                   AND WZ.ATTRIBUTE_STAT_CD = 'A'                       
                   AND WZ.ATTRIBUTE_TYPE_TX = :WS-ATTRIBUTE-TYPE        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7900'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_ACCT_ATTRIBUTE'  TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************07969900
      * 7950-GET-PAPERLESS-IND                                         *07492029
      *     SELECT FROM CSS_EDI_ACCT_DEST                              *07530029
      ******************************************************************07550000
       7950-GET-PAPERLESS-IND.                                          
                                                                        
           EXEC SQL                                                     
                SELECT 'Y'                                              
                  INTO :WS-PAPERLESS                                    
                  FROM CSS_EDI_ACCT_DEST NF WITH(READUNCOMMITTED)               
                 WHERE NF.ACCOUNT_NO   = :NF-ACCOUNT-NO                 
                   AND NF.STATUS_CD    = 'A'                            
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     07922011
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-PAPERLESS                                            
MFA-TR*           FROM CSS_EDI_ACCT_DEST NF                                     
MFA-TR*          WHERE NF.ACCOUNT_NO   = :NF-ACCOUNT-NO                         
MFA-TR*            AND NF.STATUS_CD    = 'A'                                    
MFA-TR*            WITH UR                                                      
MFA-TR*            QUERYNO 7950                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7950'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_EDI_ACCT_DEST'   TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE NF-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7950-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************07969900
      * 7960-GET-EBILL-REG-IND                                         *07492029
      *     SELECT FROM CSS_CUST_STATS                                 *07530029
      ******************************************************************07550000
       7960-GET-EBILL-REG-IND.                                          
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) EBILL_REGISTER_IND                               
                  INTO :CE-EBILL-REGISTER-IND                           
                  FROM CSS_CUST_STATS CE                                
                      ,CSS_ACCOUNT AT                                   
                 WHERE AT.ACCOUNT_NO    = :AT-ACCOUNT-NO                
                   AND AT.CUSTOMER_NO   = CE.CUSTOMER_NO                
                   AND CE.CUSTOMER_TYPE = 'C'                           
                                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                     07922011
MFA-TR*         SELECT EBILL_REGISTER_IND                                       
MFA-TR*           INTO :CE-EBILL-REGISTER-IND                                   
MFA-TR*           FROM CSS_CUST_STATS CE                                        
MFA-TR*               ,CSS_ACCOUNT AT                                           
MFA-TR*          WHERE AT.ACCOUNT_NO    = :AT-ACCOUNT-NO                        
MFA-TR*            AND AT.CUSTOMER_NO   = CE.CUSTOMER_NO                        
MFA-TR*            AND CE.CUSTOMER_TYPE = 'C'                                   
MFA-TR*       FETCH FIRST ROW ONLY                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7960'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_CUST_STATS'      TO TABLE-1                     
              MOVE 'CSS_NAME_ACCT_XREF'  TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7960-EXIT.                                                       
           EXIT.                                                        
A05744*                                                                 07470000
A05744*================================================================*        
A05744 7970-GET-CRED-LETTER-IND.                                        
A05744*================================================================*        
A05744*  GET CREDIT LETTER INDICATOR FROM CSS_SO_FINAL_BILL TABLE.     *        
A05744*----------------------------------------------------------------*        
A05744                                                                  
A05744     EXEC SQL                                                     
A05744        SELECT TOP(1) XD.CREDIT_LETTER_IND                              
A05744          INTO  :XD-CREDIT-LETTER-IND                             
A05744          FROM  CSS_SO_FINAL_BILL XD WITH(READUNCOMMITTED)                
A05744               ,CSS_SO_DATA VO WITH(READUNCOMMITTED)                      
A05744         WHERE  XD.SERV_ORDER_NO              = VO.SERV_ORDER_NO  
A05744           AND  (CIS.SUBSTR3(VO.ORDER_TYPE_CD,1,3) = 'OFF' OR          
A05744                 CIS.SUBSTR3(VO.ORDER_TYPE_CD,1,2) = 'CC')             
A05744           AND  VO.ORDER_STATE_CD             = 'Z'               
A05744           AND  VO.ACCOUNT_NO_PRIOR           = :OC-ACCOUNT-NO    
A05744         ORDER BY COMPLETED_DATETIME DESC                         
A05744                                       
A05744                                                      
A05744     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  XD.CREDIT_LETTER_IND                                      
MFA-TR*         INTO  :XD-CREDIT-LETTER-IND                                     
MFA-TR*         FROM  CSS_SO_FINAL_BILL XD                                      
MFA-TR*              ,CSS_SO_DATA VO                                            
MFA-TR*        WHERE  XD.SERV_ORDER_NO              = VO.SERV_ORDER_NO          
MFA-TR*          AND  (SUBSTR(VO.ORDER_TYPE_CD,1,3) = 'OFF' OR                  
MFA-TR*                SUBSTR(VO.ORDER_TYPE_CD,1,2) = 'CC')                     
MFA-TR*          AND  VO.ORDER_STATE_CD             = 'Z'                       
MFA-TR*          AND  VO.ACCOUNT_NO_PRIOR           = :OC-ACCOUNT-NO            
MFA-TR*        ORDER BY COMPLETED_DATETIME DESC                                 
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*       QUERYNO 7970                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05744                                                                  
A05744     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A05744                                                                  
A05744     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A05744        CONTINUE                                                  
A05744     ELSE                                                         
A05744        MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
A05744        MOVE '7970'                  TO ACTIVE-PARAGRAPH          
A05744        MOVE 'SELECT'                TO ABEND-FUNCTION            
A05744        MOVE SPACES                  TO ABEND-SQL-PREDICATES      
A05744                                        ABEND-TABLES              
A05744        MOVE 'CSS_SO_DATA'           TO TABLE-1                   
A05744        MOVE 'CSS_SO_FINAL_BILL'     TO TABLE-2                   
A05744        MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1           
A05744        MOVE OC-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1         
A05744        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
A05744        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
A05744     END-IF.                                                      
A05744                                                                  
A05744 7970-EXIT.                                                       
A05744     EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8000-UPDATE-ACCOUNT                                            *        
      *     CALLS    9000-SEND-ERROR-RESULT                            *        
      *              9900-SQL-ERROR-ROUTINE                            *        
      *                                                                *        
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      *     UPDATE CODE_PERM_BILL AND CODE_TEMP_BILL ON CSS_ACCOUNT    *        
      ******************************************************************        
                                                                        
       8000-UPDATE-ACCOUNT.                                             
                                                                        
           IF (PARM-RELEASE-BILL-OPTN = WS-HOLD AND NOT ACCT-IS-ON-HOLD 
                 AND AT-CODE-ACCT-BILLED NOT EQUAL WS-YES)              
                  OR PARM-RELEASE-BILL-OPTN = WS-EXCLUDE                
               PERFORM 7175-REMOVE-FROM-OFF-CYCLE THRU 7175-EXIT        
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_ACCOUNT                                       
                  SET CODE_PERM_BILL  =  :PARM-CODE-PERM-BILL,          
                      CODE_TEMP_BILL  =  :PARM-CODE-TEMP-BILL,          
                      CODE_ACCT_BILLED = :AT-CODE-ACCT-BILLED           
                WHERE ACCOUNT_NO = :WS-ACCOUNT-NO-CHK                   
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_ACCOUNT                                               
MFA-TR*           SET CODE_PERM_BILL  =  :PARM-CODE-PERM-BILL,                  
MFA-TR*               CODE_TEMP_BILL  =  :PARM-CODE-TEMP-BILL,                  
MFA-TR*               CODE_ACCT_BILLED = :AT-CODE-ACCT-BILLED                   
MFA-TR*         WHERE ACCOUNT_NO = :WS-ACCOUNT-NO-CHK                           
MFA-TR*      QUERYNO 8000                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE         
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE '8000'                    TO ACTIVE-PARAGRAPH       
               MOVE 'UPDATE'                  TO ABEND-FUNCTION         
               MOVE 'CSS_ACCOUNT'             TO TABLE-1                
               MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1        
               MOVE 'CODE_PERM_BILL'          TO TABLE-ELEMENT-2        
               MOVE 'CODE_TEMP_BILL'          TO TABLE-ELEMENT-3        
               MOVE 'CODE_ACCT_BILLED'        TO TABLE-ELEMENT-4        
               MOVE WS-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1      
               MOVE PARM-CODE-PERM-BILL       TO HOSTVAR-ELEMENT-2      
               MOVE PARM-CODE-TEMP-BILL       TO HOSTVAR-ELEMENT-3      
               MOVE AT-CODE-ACCT-BILLED       TO HOSTVAR-ELEMENT-4      
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
A05744*================================================================*        
A05744 8010-DLT-OFF-CYCL-ACCT.                                          
A05744*================================================================*        
A05744                                                                  
A05744     EXEC SQL                                                     
A05744       DELETE FROM OC                            
             FROM CSS_OFF_CYCL_ACCT OC
A05744        WHERE ACCOUNT_NO         = :OC-ACCOUNT-NO                 
A05744          AND CODE_BILL_OFF_CYCL IN ( :OC-CODE-BILL-OFF-CYCL      
A05744                                     ,:WS-HOLD )                  
A05744     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DELETE FROM CSS_OFF_CYCL_ACCT OC                                   
MFA-TR*       WHERE ACCOUNT_NO         = :OC-ACCOUNT-NO                         
MFA-TR*         AND CODE_BILL_OFF_CYCL IN ( :OC-CODE-BILL-OFF-CYCL              
MFA-TR*                                    ,:WS-HOLD )                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05744                                                                  
A05744     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
A05744                                                                  
A05744     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A05744        CONTINUE                                                  
A05744     ELSE                                                         
A05744        MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
A05744        MOVE SQLCODE                  TO ABEND-SQLCODE            
A05744        MOVE '8010'                   TO ACTIVE-PARAGRAPH         
A05744        MOVE 'DELETE'                 TO ABEND-FUNCTION           
A05744        MOVE SPACES                  TO ABEND-SQL-PREDICATES      
A05744                                        ABEND-TABLES              
A05744        MOVE 'CSS_OFF_CYCL_ACCT'      TO TABLE-1                  
A05744        MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
A05744        MOVE OC-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
A05744        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
A05744        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
A05744     END-IF.                                                      
A05744                                                                  
A05744 8010-EXIT.                                                       
A05744     EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8035-UPDATE-OFF-CYCLE-TBL                                      *        
      *     CALLS    8075-INSERT-OFF-CYCLE-TBL                         *        
      *                                                                *        
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      *     UPDATE CSS_OFF_CYCL_ACCT TABLE                             *        
      ******************************************************************        
                                                                        
       8035-UPDATE-OFF-CYCLE-TBL.                                       
                                                                        
           MOVE '8035'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EVALUATE PARM-RELEASE-BILL-OPTN                              
A05744        WHEN WS-RELEASE-FOR-BILL                                  
A05744           IF AT-CODE-ACCT-BILLED = WS-HOLD                       
A05744              MOVE SPACES            TO AT-CODE-ACCT-BILLED       
A05744           END-IF                                                 
A05744           MOVE PARM-ACCOUNT-NO-NUM  TO OC-ACCOUNT-NO             
A05744           MOVE AT-CUSTOMER-NO       TO OC-CUSTOMER-NO            
A05744           MOVE ZERO                 TO OC-ITEM-ID                
A05744           PERFORM 8075-INSERT-OFF-CYCLE-TBL    THRU 8075-EXIT    
              WHEN WS-RELEASE                                           
                 MOVE SPACES               TO AT-CODE-ACCT-BILLED       
                 MOVE PARM-ACCOUNT-NO-NUM  TO OC-ACCOUNT-NO             
                 MOVE SPACES               TO OC-CODE-BILL-OFF-CYCL     
                 MOVE SPACES               TO OC-CREDIT-LETTER-IND      
                 MOVE AT-CUSTOMER-NO       TO OC-CUSTOMER-NO            
                 MOVE ZERO                 TO OC-ITEM-ID                
                 PERFORM 8075-INSERT-OFF-CYCLE-TBL    THRU 8075-EXIT    
              WHEN WS-XFER-CONSOLIDATED                                 
                 MOVE PARM-ACCOUNT-NO-NUM  TO OC-ACCOUNT-NO             
                 MOVE 'M'                  TO OC-CODE-BILL-OFF-CYCL     
                 MOVE SPACES               TO OC-CREDIT-LETTER-IND      
                 MOVE AT-CUSTOMER-NO       TO OC-CUSTOMER-NO            
                 MOVE ZERO                 TO OC-ITEM-ID                
                 PERFORM 8075-INSERT-OFF-CYCLE-TBL    THRU 8075-EXIT    
              WHEN WS-XFER-REGULAR                                      
                 MOVE PARM-ACCOUNT-NO-NUM  TO OC-ACCOUNT-NO             
                 MOVE 'T'                  TO OC-CODE-BILL-OFF-CYCL     
                 MOVE SPACES               TO OC-CREDIT-LETTER-IND      
                 MOVE AT-CUSTOMER-NO       TO OC-CUSTOMER-NO            
                 MOVE ZERO                 TO OC-ITEM-ID                
                 PERFORM 8075-INSERT-OFF-CYCLE-TBL    THRU 8075-EXIT    
              WHEN WS-XFER-GUARANTOR                                    
                 MOVE PARM-ACCOUNT-NO-NUM  TO OC-ACCOUNT-NO             
                 MOVE 'G'                  TO OC-CODE-BILL-OFF-CYCL     
                 MOVE SPACES               TO OC-CREDIT-LETTER-IND      
                 MOVE AT-CUSTOMER-NO       TO OC-CUSTOMER-NO            
                 MOVE ZERO                 TO OC-ITEM-ID                
                 PERFORM 8075-INSERT-OFF-CYCLE-TBL    THRU 8075-EXIT    
           END-EVALUATE.                                                
                                                                        
       8035-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************07969900
      * 8075-INSERT-OFF-CYCLE-TBL                                      *        
      *     CALLS    8080-WRITE-RLS-BILL-HIST                          *        
      *              9000-SEND-ERROR-RESULT                            *        
      *              9900-SQL-ERROR-ROUTINE                            *        
      *                                                                *        
      *     CALLED FROM   2300-BUILD-RESULT                            *        
      *                                                                *        
      *     INSERT ROW INTO CSS_OFF_CYCL_ACCT                          *        
      ******************************************************************        
                                                                        
       8075-INSERT-OFF-CYCLE-TBL.                                       
                                                                        
           MOVE '8075'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_OFF_CYCL_ACCT                            
                      ( ACCOUNT_NO,                                     
                        CODE_BILL_OFF_CYCL,                             
                        CREDIT_LETTER_IND,                              
                        CUSTOMER_NO,                                    
                        ITEM_ID,                                        
                        LAST_UPDATE_TS )                                
               VALUES ( :OC-ACCOUNT-NO,                                 
                        :OC-CODE-BILL-OFF-CYCL,                         
                        :OC-CREDIT-LETTER-IND,                          
                        :OC-CUSTOMER-NO,                                
                        :OC-ITEM-ID,                                    
                        CIS.CURRENT$TIMESTAMP() )                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_OFF_CYCL_ACCT                                    
MFA-TR*               ( ACCOUNT_NO,                                             
MFA-TR*                 CODE_BILL_OFF_CYCL,                                     
MFA-TR*                 CREDIT_LETTER_IND,                                      
MFA-TR*                 CUSTOMER_NO,                                            
MFA-TR*                 ITEM_ID,                                                
MFA-TR*                 LAST_UPDATE_TS )                                        
MFA-TR*        VALUES ( :OC-ACCOUNT-NO,                                         
MFA-TR*                 :OC-CODE-BILL-OFF-CYCL,                                 
MFA-TR*                 :OC-CREDIT-LETTER-IND,                                  
MFA-TR*                 :OC-CUSTOMER-NO,                                        
MFA-TR*                 :OC-ITEM-ID,                                            
MFA-TR*                 CURRENT TIMESTAMP )                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               PERFORM 8080-WRITE-RLS-BILL-HIST  THRU 8080-EXIT         
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = WS-DUPLICATE-ROW              
                  NEXT SENTENCE                                         
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE '8075'               TO ACTIVE-PARAGRAPH         
                  MOVE 'INSERT'             TO ABEND-FUNCTION           
                  MOVE 'CSS_OFF_CYCL_ACCT'  TO TABLE-1                  
                  MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1          
                  MOVE 'CODE_BILL_OFF_CYCL' TO TABLE-ELEMENT-2          
                  MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-3          
                  MOVE 'ITEM_ID'            TO TABLE-ELEMENT-4          
                  MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1       
                  MOVE OC-CODE-BILL-OFF-CYCL TO HOSTVAR-ELEMENT-2       
                  MOVE OC-CUSTOMER-NO        TO HOSTVAR-ELEMENT-3       
                  MOVE OC-ITEM-ID            TO HOSTVAR-ELEMENT-4       
                  PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT         
                  PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT         
               END-IF                                                   
           END-IF.                                                      
                                                                        
       8075-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8080-WRITE-RLS-BILL-HIST                                       *        
      *     CALLS  7300-GET-TIMESTAMP                                  *        
      *            5010-MNT-HST-DETAIL                                 *        
      *                                                                *        
      *     CALLED FROM   8075-INSERT-OFF-CYCLE-TBL                    *        
      *                                                                *        
      *     WRITE ROWS TO CSS_MNT_TRANS_HIST AND CSS_MT_TRN_HST_DET    *        
      ******************************************************************        
                                                                        
       8080-WRITE-RLS-BILL-HIST.                                        
                                                                        
           MOVE '8080'                    TO ACTIVE-PARAGRAPH.          
                                                                        
           PERFORM 7300-GET-TIMESTAMP     THRU 7300-EXIT.               
                                                                        
      *    *** SET UP HEADER ROW                                                
           MOVE WS-F                      TO MH-CODE-TRAN-TYPE.         
           MOVE PF-RESP-AREA-ID           TO MH-RESP-AREA-ID.           
           MOVE PARM-ACCOUNT-NO-NUM       TO MH-ACCOUNT-NO.             
                                                                        
           IF AT-CREDIT-GROUP = WS-MASTER                               
              MOVE ZEROS                  TO MH-CUSTOMER-NO             
           ELSE                                                         
SIVA          MOVE AT-CUSTOMER-NO         TO MH-CUSTOMER-NO             
           END-IF.                                                      
                                                                        
           MOVE ZEROS                     TO MH-PREMISE-NO.             
           MOVE PARM-USER-ID              TO MH-USER-ID.                
           MOVE 'PANEL490'                TO MH-APPL-PROGRAM-ID.        
                                                                        
           EVALUATE PARM-RELEASE-BILL-OPTN                              
              WHEN WS-RELEASE                                           
                 MOVE +16                    TO MH-TRAN-COMMENT-LEN     
                 MOVE 'REMOVE FROM HOLD'     TO MH-TRAN-COMMENT-TEXT    
A05744        WHEN WS-RELEASE-FOR-BILL                                  
A05744           MOVE +29                    TO MH-TRAN-COMMENT-LEN     
A05744           MOVE 'ACCOUNT RELEASED FOR BILLING.'                   
A05744                                       TO MH-TRAN-COMMENT-TEXT    
              WHEN WS-HOLD                                              
                 MOVE +34                    TO MH-TRAN-COMMENT-LEN     
                 MOVE 'ACCT HELD SO THAT IT WILL NOT BILL'              
                                             TO MH-TRAN-COMMENT-TEXT    
              WHEN WS-XFER-CONSOLIDATED                                 
                 MOVE +46                    TO MH-TRAN-COMMENT-LEN     
                 MOVE 'ACCT RELEASED TO ACCEPT CONSOLIDATED PEND XFER'  
                                             TO MH-TRAN-COMMENT-TEXT    
              WHEN WS-XFER-REGULAR                                      
                 MOVE +41                    TO MH-TRAN-COMMENT-LEN     
                 MOVE 'ACCT RELEASED TO ACCEPT REGULAR PEND XFER'       
                                             TO MH-TRAN-COMMENT-TEXT    
              WHEN WS-XFER-GUARANTOR                                    
                 MOVE +43                    TO MH-TRAN-COMMENT-LEN     
                 MOVE 'ACCT RELEASED TO ACCEPT GUARANTOR PEND XFER'     
                                             TO MH-TRAN-COMMENT-TEXT    
           END-EVALUATE.                                                
                                                                        
      *    *** SET UP DETAIL ROW                                                
           MOVE +1                        TO WS-TRAN-APPL-NO.           
                                                                        
           MOVE 'OFF CYCLE CODE'          TO MI-COLUMN-DESC.            
           MOVE +12                       TO MI-PRV-COLUMN-VALUE-LEN.   
           MOVE '**INSERTED**'            TO MI-PRV-COLUMN-VALUE-TEXT.  
           MOVE +1                        TO MI-CHG-COLUMN-VALUE-LEN.   
           MOVE OC-CODE-BILL-OFF-CYCL     TO MI-CHG-COLUMN-VALUE-TEXT.  
           MOVE 'OC'                      TO MI-TABLE-ID.               
           PERFORM 5010-MNT-HST-DETAIL    THRU 5010-EXIT.               
                                                                        
       8080-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************07969900
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                     07970000
      ******************************************************************07970100
           EXEC SQL                                                     07970200
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                    07980000
                                                                        
      ******************************************************************08000000
      * END PROGRAM COPYLIB                                            *08010000
      *     <8100-SEND RESULT & 9000-SEND-ERROR-RESULT>                *        
      ******************************************************************08020000
           EXEC SQL                                                             
               INCLUDE CPD00321                                                 
           END-EXEC.                                                            
      *                                                                *63030000
      ******************************************************************63030100
      * 9700-PROCESS-ABEND.                                            *63030200
      * THIS PARAGRAPH DUPLICATES THE CODE IN CPD0023C, BECAUSE        *63030300
      * 9700-PROCESS-ABEND IS NOT APPLICABLE TO THIS PROGRAM           *63030400
      *                                                                *63030600
      ******************************************************************63030700
       9700-PROCESS-ABEND.                                              
      *                                                                 63030900
           PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT.               
           PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT.               
      *                                                                 63031200
       9700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
