       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04682.                                          
       AUTHOR.       GOPI DUGGIRALA.                                    
       DATE-WRITTEN. SEP 16, 2013.                                      
       DATE-COMPILED.                                                   
      *****************************************************************         
      **                          SCE&G                              **         
      *****************************************************************         
      **                STORED PROCEDURE: CSR04682                   **         
      *****************************************************************         
      **                P R O G R A M   S U M M A R Y                **         
      **                                                             **         
      ** TRANSACTION HISTORY MODERNIZATION - MAIN RETRIEVE PROGRAM   **         
      **                                                             **         
      ** PARAMETERS                                                  **         
      **                                                             **         
      **  INPUT                                                      **         
      **   CALL_TYPE               CHAR(01)                          **         
      **   ACCOUNT_NO              CHAR(13)                          **         
      **   CUSTOMER_NO             CHAR(10)                          **         
      **   PREMISE_NO              CHAR(10)                          **         
      **   RESP_AREA_ID            CHAR(03)                          **         
      **   USER_ID                 CHAR(07)                          **         
      **   CODE_TRAN_TYPE          CHAR(01)                          **         
      **   TRNS_HIST_FROM_TS       CHAR(26)                          **         
      **   TRNS_HIST_TO_TS         CHAR(26)                          **         
      **   COMPANY_NO              CHAR(02)                          **         
      **   NAVIG_PATH              CHAR(03)                          **         
      **   CSR_USER_ID             CHAR(07)                          **         
      **                                                             **         
      **  OUTPUT                                                     **         
      **   RES SET1:TRANSACTION HISTORY - HEADER DATA                **         
      **   RES SET2:TRANSACTION HISTORY - ACCT RECV HIST DETAIL DATA **         
      **   RES SET3:TRANSACTION HISTORY - MAINTAIN HIST DETAIL DATA  **         
      **                                                             **         
      *****************************************************************         
      **              PROGRAM MODIFICATION LOG                       **         
      ** DATE        INITIALS     REASON                             **         
      ** --------    ---------    ---------------------------------- **         
P00740** 09/16/13    GD43988      NEW PROGRAM.                       **         
A04880** 10/02/14    MS93554      PARA 2750 - CHANGED THE LOGIC TO   **         
      **             #ACT270      CALL DECODE COPY BOOK TO HANDLE    **         
      **                          SPECIFIC ADDTIONAL COLUMN.         **         
A04880** 10/09/14    VP43661      RETRIEVE CASH DRAWER DETAILS FOR   **         
      **             #ACT276      PAYMENT CORRECTIONS TOO.           **         
A04880** 10/17/14    AS7C117      PARA 2750 - CHANGED THE LOGIC TO   **         
      **             #ACT280      CALL DECODE COPY BOOK TO HANDLE    **         
      **                          SPECIFIC ADDTIONAL COLUMN SEASONAL_FL         
PRJ586** 05/20/2015  AP40911      GET REFUND INDICATOR               **         
A05136** 07/01/15    RS7M249      ADDED NSC REMOVE FL COLUMN DESCRIP **         
      **             ACT129       TION IN TRNS HST DETAILS           **         
A05136** 07/27/15    RS7M249      ADDED ITPA_CURR_RSLT AND LETTER    **         
      **             ACT134       NOTIFY COLUMN DESCRIPTION IN TRNS  **         
      **                          HST DETAILS AND ALSO INCLUDED      **         
      **                          TBCONACC COPYBOOK                  **         
A05136** 09/12/15    RS7M249      INCLUDE DECODE COPYBOOKS           **         
      **             ACT164                                          **         
A05460** 01/21/16    SM93554      INCLUDE DCLGEN COPYBOOKS FOR TABLE **         
      **             ACT014       CSS_SO_CODE_DESC                   **         
A05065**  08/26/15   MS7M727      INCLUDE CSS_REMOTE_RD_IND TABLE FOR**         
      **             ACT044       RETRIEVE A DESCRIPTION             **         
PRDFIX**  07/13/16   SM93554      FIX FOR PROD ISSUE- GLOBAL TRAN SRCH*         
A05460**  08/02/16   MC95456      REMOVED DCLGENS OF CSS_MKT_* TABLES *         
      **             ACT244                                                     
A05460**  09/21/16   MR7E794      REMOVED UNUSED DCLGENS.             *         
      **             ACT282                                           *         
      *****************************************************************         
      *                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ008  01 MSQ008-TRNS-HDR-UID-CUST  PIC S9(9) COMP-5.
MSQ008  01 MSQ008-TRNS-HDR-UID-MH  PIC S9(9) COMP-5.
MSQ008  01 MSQ008-TRNS-HDR-UID-AR  PIC S9(9) COMP-5.
MSQ008  01 MSQ008-TRNS-HDR-UID  PIC S9(9) COMP-5.
MSQ008  01 MSQ008-TRNS-HDR-UID-ACCT  PIC S9(9) COMP-5.
MSQ008  01 MSQ008-TRNS-HDR-RESP-MH  PIC S9(9) COMP-5.
MSQ008  01 MSQ008-TRNS-HDR-RESP-AR  PIC S9(9) COMP-5.
MSQ008  01 MSQ008-TRNS-HDR-RESP  PIC S9(9) COMP-5.
MSQ008  01 MSQ008-TRNS-HDR-PREM  PIC S9(9) COMP-5.
MSQ008  01 MSQ008-TRNS-HDR-CUST  PIC S9(9) COMP-5.
MSQ008  01 MSQ008-TRNS-HDR-ACCT  PIC S9(9) COMP-5.
MSQ008  01 MSQ008-TRNS-HDR-ACP  PIC S9(9) COMP-5.
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04682'.
MSQ017     COPY MFASQLM.
      *                                                                         
      **********************************                                        
      **   DB2 INCLUDES               **                                        
      **********************************                                        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE SQLCA                                                   
           END-EXEC.                                                            
      *                                                                         
      **** CSS_AR_TRANS_HIST, AR                                                
           EXEC SQL                                                             
              INCLUDE TBARHIST                                                  
           END-EXEC.                                                            
      *                                                                         
      **** CSS_MNT_TRANS_HIST, MH                                               
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
      *                                                                         
      **** CSS_AR_TRN_HST_DET, AU                                               
           EXEC SQL                                                             
              INCLUDE TBARHDT                                                   
           END-EXEC.                                                            
      *                                                                         
      **** CSS_MT_TRN_HST_DET, MI                                               
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
      *                                                                         
      **** CSS_APPL_PGM_DESC, K9                                                
           EXEC SQL                                                             
              INCLUDE TBPGMDSC                                                  
           END-EXEC.                                                            
      *                                                                         
      **** CSS_USER_PROFILE, PF                                                 
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
      *                                                                         
ACT044**** CSS_REMOTE_RD_IND,OB                                                 
ACT044     EXEC SQL                                                             
ACT044        INCLUDE TBREMIND                                                  
ACT044     END-EXEC.                                                            
                                                                        
      **** CSS_CASHIER_OFFICE, Y2                                               
           EXEC SQL                                                             
              INCLUDE TBCSHOFF                                                  
           END-EXEC.                                                            
      *                                                                         
      *                                                                         
      **** CSS_BCH_JRNL_CNTL, BC                                                
           EXEC SQL                                                             
              INCLUDE TBBJCNTL                                                  
           END-EXEC.                                                            
      *                                                                         
      **** CSS_CSH_DRWR_CNTL, CS                                                
           EXEC SQL                                                             
              INCLUDE TBCDCNTL                                                  
           END-EXEC.                                                            
      *                                                                         
      **** CSS_CONTRACT, CT                                                     
           EXEC SQL                                                             
              INCLUDE TBCNTRCT                                                  
           END-EXEC.                                                            
      *                                                                         
      **** CSS_CONTRACT_INFO, K6                                                
           EXEC SQL                                                             
              INCLUDE TBCNTINF                                                  
           END-EXEC.                                                            
      *                                                                         
      **** CSS_NAME_ACCT_XREF, HT                                               
           EXEC SQL                                                             
              INCLUDE TBNMACTX                                                  
           END-EXEC.                                                            
      *                                                                         
      **** CSS_NAME, DQ                                                         
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
      *                                                                         
      **** CSS_ADDR_FORMATTED, DY                                               
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
      *                                                                         
      **** CSS_ZIP_CODE, A4                                                     
           EXEC SQL                                                             
              INCLUDE TBZIPCD                                                   
           END-EXEC.                                                            
      *                                                                         
      ***** DECODING COPYBOOKS - BEGIN *****                                    
      *                                                                         
      **** CSS_WAIVER, A6                                                       
           EXEC SQL                                                             
              INCLUDE TBWAIVER                                                  
           END-EXEC.                                                            
      *                                                                         
      **** CSS_LOCAL_OFFICE, B1                                                 
           EXEC SQL                                                             
              INCLUDE TBLOCOFC                                                  
           END-EXEC.                                                            
      *                                                                         
      **** CSS_LOCK_TYPE,B3                                                     
           EXEC SQL                                                             
              INCLUDE TBLCKTYP                                                  
           END-EXEC.                                                            
      *                                                                         
      **** CSS_COMPANY, C7                                                      
           EXEC SQL                                                             
              INCLUDE TBCOMPNY                                                  
           END-EXEC.                                                            
      *                                                                         
      **** CSS_CONTACT_TYPE, D8                                                 
           EXEC SQL                                                             
              INCLUDE TBCTYPE                                                   
           END-EXEC.                                                            
      *                                                                         
ACT134**** CSS_CONTACT_ACCESS, 3I                                               
ACT134     EXEC SQL                                                             
ACT134        INCLUDE TBCONACC                                                  
ACT134     END-EXEC.                                                            
ACT134*                                                                         
      **** CSS_TAX_EXMPT_CODE, F1                                               
           EXEC SQL                                                             
              INCLUDE TBTXMPCD                                                  
           END-EXEC.                                                            
      *                                                                         
      **** CSS_REVENUE_CLASS, F3                                                
           EXEC SQL                                                             
              INCLUDE TBREVCLS                                                  
           END-EXEC.                                                            
      *                                                                         
      **** CSS_SIC, R1                                                          
           EXEC SQL                                                             
              INCLUDE TBSIC                                                     
           END-EXEC.                                                            
      *                                                                         
      ****  CSS_METER_LOC, Q4                                                   
           EXEC SQL                                                             
              INCLUDE TBMTRLOC                                                  
           END-EXEC.                                                            
      *                                                                         
      ****  CSS_MTR_RD_INST, Q5                                                 
           EXEC SQL                                                             
              INCLUDE TBMTRINS                                                  
           END-EXEC.                                                            
      *                                                                         
      ****  CSS_RATE_PLAN_DESC, RD                                              
           EXEC SQL                                                             
              INCLUDE TBRTDESC                                                  
           END-EXEC.                                                            
      *                                                                         
      ****  CSS_STREET_SUFFIX, S9                                               
           EXEC SQL                                                             
              INCLUDE TBSTRSFX                                                  
           END-EXEC.                                                            
      *                                                                         
      ****  CSS_CODE_VALUE, UV                                                  
           EXEC SQL                                                             
              INCLUDE TBCDVALU                                                  
           END-EXEC.                                                            
      *                                                                         
      **** CSS_CRED_CODE_DESC, KL                                               
           EXEC SQL                                                             
              INCLUDE TBCREDCD                                                  
           END-EXEC.                                                            
      *                                                                         
      **** CSS_SEASONAL_USE, B2                                                 
           EXEC SQL                                                             
              INCLUDE TBSNLUSE                                                  
           END-EXEC.                                                            
      *                                                                         
      **** CSS_BOND_CO, BO                                                      
           EXEC SQL                                                             
              INCLUDE TBBONDCO                                                  
           END-EXEC.                                                            
      *                                                                         
      **** CSS_FIXED_FCTR_TYP, FT                                               
           EXEC SQL                                                             
              INCLUDE TBFXDTYP                                                  
           END-EXEC.                                                            
      *                                                                         
      **** CSS_RATE_COMPONENT, N6                                               
           EXEC SQL                                                             
              INCLUDE TBRTCPNT                                                  
           END-EXEC.                                                            
      *                                                                         
      **** CSS_CRIT_OUTAGE, Q2                                                  
           EXEC SQL                                                             
              INCLUDE TBCRITOG                                                  
           END-EXEC.                                                            
      *                                                                         
      **** CSS_DELIVERY_LEVEL, R2                                               
           EXEC SQL                                                             
              INCLUDE TBDVLYLV                                                  
           END-EXEC.                                                            
      *                                                                         
      **** CSS_NO_READ_REASON, S4                                               
           EXEC SQL                                                             
              INCLUDE TBNORDRN                                                  
           END-EXEC.                                                            
      *                                                                         
      **** CRM_TIER_ACCT_TYPE, TT                                               
           EXEC SQL                                                             
              INCLUDE TBTIACTP                                                  
           END-EXEC.                                                            
      *                                                                         
      **** CSS_RECONNECT_CHRG, U7                                               
           EXEC SQL                                                             
              INCLUDE TBRCNCHR                                                  
           END-EXEC.                                                            
      *                                                                         
      **** CSS_MTR_RD_SOURCE, X7                                                
           EXEC SQL                                                             
              INCLUDE TBRDSRCE                                                  
           END-EXEC.                                                            
      *                                                                         
      **** CSS_CATEGORY, F5                                                     
           EXEC SQL                                                             
              INCLUDE TBCAT                                                     
           END-EXEC.                                                            
      *                                                                         
ACT164*                                                                         
ACT164**** CRM_RT_PKG_OFFER, FG                                                 
ACT164     EXEC SQL                                                             
ACT164        INCLUDE TBRTPOFF                                                  
ACT164     END-EXEC.                                                            
ACT164*                                                                         
ACT164**** CRM_RT_PKG_OPTION, FI                                                
ACT164     EXEC SQL                                                             
ACT164        INCLUDE TBRTPKGO                                                  
ACT164     END-EXEC.                                                            
ACT164*                                                                         
ACT014**** CSS_SO_CODE_DESC, SW                                                 
ACT014     EXEC SQL                                                             
ACT014        INCLUDE TBSOCODE                                                  
ACT014     END-EXEC.                                                            
ACT014*                                                                         
      ***** WS COPYBOOK FOR DECODING LOGIC                                      
           EXEC SQL                                                             
               INCLUDE CWS04682                                                 
           END-EXEC.                                                            
      *                                                                         
      ***** DECODING COPYBOOKS - END *****                                      
      *                                                                         
       01  WS-LITERALS.                                                 
           05  PROGRAM-NAME              PIC X(08) VALUE 'CSR04682'.    
      *                                                                         
       01  PARM-FIELDS.                                                 
           05  PARM-L                    PIC S9(9) COMP.                
           05  PARM-CALL-TYPE            PIC X(01).                     
           05  PARM-ACCOUNT-NO           PIC X(13).                     
           05  PARM-ACCOUNT-NO-NUM  REDEFINES                           
               PARM-ACCOUNT-NO           PIC 9(13).                     
           05  PARM-CUSTOMER-NO          PIC X(10).                     
           05  PARM-CUSTOMER-NO-NUM REDEFINES                           
               PARM-CUSTOMER-NO          PIC 9(10).                     
           05  PARM-PREMISE-NO           PIC X(10).                     
           05  PARM-PREMISE-NO-NUM  REDEFINES                           
               PARM-PREMISE-NO           PIC 9(10).                     
           05  PARM-RESP-AREA-ID         PIC X(03).                     
           05  PARM-USER-ID              PIC X(07).                     
           05  PARM-CODE-TRAN-TYPE       PIC X(01).                     
           05  PARM-TRNS-HIST-FROM-TS    PIC X(26).                     
           05  PARM-TRNS-HIST-TO-TS      PIC X(26).                     
           05  PARM-COMPANY-NO           PIC X(02).                     
           05  PARM-NAVIG-PATH           PIC X(03).                     
           05  PARM-CSR-USER-ID          PIC X(07).                     
      *                                                                         
       01  WS-HDR-ARRAY.                                                
           05  H-TRANS-HIST-SEQ-NO       OCCURS 26 TIMES PIC X(26).     
           05  H-CODE-TRAN-TYPE          OCCURS 26 TIMES PIC X(01).     
           05  H-APPL-PROGRAM-ID         OCCURS 26 TIMES PIC X(09).     
           05  H-USER-ID                 OCCURS 26 TIMES PIC X(07).     
           05  H-RESP-AREA-ID            OCCURS 26 TIMES PIC X(03).     
           05  H-TRAN-COMMENT            OCCURS 26 TIMES PIC X(210).    
COB305     05 H-ACCOUNT-NO        PIC S9(13)V OCCURS 26 TIMES 
COB305       USAGE COMP-3 VALUE 0.      
COB305     05 H-CUSTOMER-NO        PIC S9(10)V OCCURS 26 TIMES 
COB305       USAGE COMP-3 VALUE 0.      
COB305     05 H-PREMISE-NO        PIC S9(10)V OCCURS 26 TIMES 
COB305       USAGE COMP-3 VALUE 0.      
COB305     05 H-AMT-ORIG-ENTERED        PIC S9(9)V9(2) OCCURS 26 TIMES 
COB305       USAGE COMP-3 VALUE 0.   
COB305     05 H-AMT-BILLED-UNPAID        PIC S9(9)V9(2) OCCURS 26 TIMES 
COB305       USAGE COMP-3 VALUE 0.   
           05  H-RECORD-ONLY-FL          OCCURS 26 TIMES PIC X(01).     
PRJ586     05  H-PYMT-REFUNDED-IND       OCCURS 26 TIMES PIC X(01).     
           05  H-CASH-LOCAL-OFFICE       OCCURS 26 TIMES PIC X(03).     
           05  H-CASH-REPORT-NO          OCCURS 26 TIMES PIC X(03).     
           05  H-DATE-CASH-REPORT        OCCURS 26 TIMES PIC X(10).     
           05  H-DATE-ORIG-PYMT          OCCURS 26 TIMES PIC X(10).     
           05  H-CASH-DRAWER-ID          OCCURS 26 TIMES                
                                         PIC S9(4) USAGE COMP.          
           05  H-PYMT-FACILITY-CD        OCCURS 26 TIMES PIC X(01).     
           05  H-TABLE-CD                OCCURS 26 TIMES PIC X(02).     
      *                                                                         
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS-HDR              PIC S9(9) COMP VALUE 0.        
           05  CTR-ROWS-ACR              PIC S9(9) COMP VALUE 0.        
           05  CTR-ROWS-MNT              PIC S9(9) COMP VALUE 0.        
      *                                                                         
       01  GTT-RETURN-FIELDS.                                           
      *                                                                         
           05  GTT-RETURN-FIELDS-HDR.                                   
               10 S-H-RETURN-CODE        PIC S9(9) COMP VALUE 0.        
               10 S-H-TRANS-HIST-SEQ-NO  PIC X(26).                     
               10 S-H-CODE-TRAN-TYPE     PIC X(01).                     
               10 S-H-APPL-PROGRAM-DESC  PIC X(20).                     
               10 S-H-EMPLOYEE-NAME      PIC X(40).                     
               10 S-H-RESP-AREA-ID       PIC X(03).                     
               10 S-H-TRAN-COMMENT       PIC X(210).                    
COB305         10 S-H-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 
COB305           VALUE 0.      
COB305         10 S-H-CUSTOMER-NO        PIC S9(10)V USAGE COMP-3 
COB305           VALUE 0.      
COB305         10 S-H-PREMISE-NO        PIC S9(10)V USAGE COMP-3 
COB305           VALUE 0.      
COB305         10 S-H-AMT-ORIG-ENTERED        PIC S9(9)V9(2) 
COB305           USAGE COMP-3 VALUE 0.   
COB305         10 S-H-AMT-BILLED-UNPAID        PIC S9(9)V9(2) 
COB305           USAGE COMP-3 VALUE 0.   
               10 S-H-RECORD-ONLY-FL     PIC X(01).                     
PRJ586         10 S-H-PYMT-REFUNDED-IND  PIC X(01).                     
               10 S-H-CASH-LOCAL-OFFICE  PIC X(29).                     
               10 S-H-DATE-CASH-REPORT   PIC X(10).                     
               10 S-H-DATE-ORIG-PYMT     PIC X(08).                     
               10 S-H-DRAWER-ID          PIC S9(4) USAGE COMP.          
               10 S-H-DRAWER-STATUS      PIC X(08).                     
               10 S-H-PYMT-FACILITY-CD   PIC X(01).                     
               10 S-H-PYMT-FACILITY-DESC PIC X(20).                     
               10 S-H-TABLE-CD           PIC X(02).                     
               10 S-H-MORE-DATA-AVLB-FL  PIC X(01).                     
               10 S-H-FULL-NAME          PIC X(70).                     
               10 S-H-ADDRESS-LINE-1     PIC X(75).                     
               10 S-H-ADDRESS-LINE-2     PIC X(35).                     
      *                                                                         
           05  GTT-RETURN-FIELDS-ACR.                                   
               10 S-A-RETURN-CODE        PIC S9(9) COMP VALUE 0.        
COB305         10 S-A-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 
COB305           VALUE 0.      
               10 S-A-TRANS-HIST-SEQ-NO  PIC X(26).                     
               10 S-A-CODE-AR-AGE-DESC   PIC X(20).                     
COB305         10 S-A-GL-ACCT-CREDIT        PIC S9(3)V9(4) USAGE COMP-3 
COB305           VALUE 0.   
COB305         10 S-A-GL-ACCT-DEBIT        PIC S9(3)V9(4) USAGE COMP-3 
COB305           VALUE 0.   
COB305         10 S-A-AMT-POSTED        PIC S9(9)V9(2) USAGE COMP-3 
COB305           VALUE 0.   
               10 S-A-ITEM-ID            PIC S9(9) USAGE COMP.          
               10 S-A-CNT-NAME-DESC      PIC X(30).                     
               10 S-A-CURRENCY-TYPE      PIC X(01).                     
      *                                                                         
           05  GTT-RETURN-FIELDS-MNT.                                   
               10 S-M-RETURN-CODE        PIC S9(9) COMP VALUE 0.        
               10 S-M-TRANS-HIST-SEQ-NO  PIC X(26).                     
               10 S-M-COLUMN-DESC        PIC X(15).                     
               10 S-M-PRV-COLUMN-VALUE   PIC X(75).                     
               10 S-M-CHG-COLUMN-VALUE   PIC X(75).                     
      *                                                                         
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
           10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
      *                                                                         
       01  WS-SWITCHES.                                                 
           05  SEND-DONE-SW              PIC X(01) VALUE 'Y'.           
               88  SEND-DONE-ERROR                 VALUE 'N'.           
               88  SEND-DONE-OK                    VALUE 'Y'.           
      *                                                                         
       01  WS-NULL-INDICATORS.                                          
           05  WS-DATE-NULL-1            PIC S9(04) COMP VALUE +0.      
      *                                                                         
       01  WS-MISC-VAR.                                                 
           05  WS-YES-NULL               PIC S9(04) VALUE -1.           
           05  WS-CURRENT-TS             PIC X(26)  VALUE SPACES.       
           05  WS-CURRENT-TS-MINUS-25    PIC X(26)  VALUE SPACES.       
           05  WS-GET-ACCT-DATA-FL       PIC X(01)  VALUE SPACES.       
           05  WS-GET-CUST-DATA-FL       PIC X(01)  VALUE SPACES.       
           05  WS-GET-PREM-DATA-FL       PIC X(01)  VALUE SPACES.       
           05  WS-CODE-TRAN-TYPE1        PIC X(01)  VALUE SPACES.       
           05  WS-CODE-TRAN-TYPE2        PIC X(01)  VALUE SPACES.       
           05  WS-EMPLOYEE-NAME          PIC X(40)  VALUE SPACES.       
           05  WS-HDR-FETCH-COUNT        PIC 9(04)  VALUE 0.            
           05  WS-MORE-DATA-AVLB-FL      PIC X(01)  VALUE SPACES.       
           05  WS-HI                     PIC 9(04)  VALUE 0.            
           05  WS-DELIVERY-LVL-AMT       PIC X(15)  VALUE SPACES.       
           05  WS-DESCRIPTION            PIC X(35)  VALUE SPACES.       
           05  WS-SEAL-CODE-DESC         PIC X(08)  VALUE SPACES.       
           05  WS-COL-VALU-TMP           PIC S9(09) USAGE COMP.         
           05  WS-BUSINESS-TYPE          PIC X(30)  VALUE SPACES.       
           05  WS-M-TABLE-ID             PIC X(02).                     
           05  WS-ADDRESS-LINE-1         PIC X(75)  VALUE SPACES.       
           05  WS-ADDRESS-LINE-2         PIC X(35)  VALUE SPACES.       
      *                                                                         
      **** ERROR HANDLING (ABEND VARIABLES)                                     
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
      *                                                                         
      **** DB2 AND SQL ERROR CHECKING                                           
           COPY CWS00303.                                                       
      *                                                                         
      **** ABEND ROUTINE (USED WITH CPD09900 INCLUDE MEMBER)                    
           COPY CWS09900.                                                       
      *                                                                         
      ****ACCOUT RECEIVABLES / MAINTENANCE TRANS HIST DATA                      
      ****CALL TYPE = 'Z' (ALL - ACCOUNT, CUSTOMER & PREMISE)                   
      *                                                                         
           EXEC SQL                                                     
             DECLARE  TRNS_HDR_ACP CURSOR WITH ROWSET POSITIONING FOR   
              SELECT TOP(21) MSQ020.*
               FROM (
                 SELECT  REPLACE(REPLACE(CONVERT(CHAR(26), 
           AR.TRANS_HIST_SEQ_NO, 121), ' ', '-'), ':', '.') 
           TRANS_HIST_SEQ_NO                              
                     ,AR.CODE_TRAN_TYPE                                 
                     ,AR.APPL_PROGRAM_ID                                
                     ,AR.USER_ID                                        
                     ,AR.RESP_AREA_ID                                   
                     ,AR.TRAN_COMMENT                                   
                     ,AR.ACCOUNT_NO                                     
                     ,0 MSQ020A8                                                
                     ,0 MSQ020A9                                                
                     ,AR.AMT_ORIG_ENTERED                               
                     ,AR.AMT_BILLED_UNPAID                              
                     ,AR.RECORD_ONLY_FL                                 
PRJ586               ,AR.PYMT_REFUNDED_IND                              
                     ,AR.CASH_LOCAL_OFFICE                              
                     ,AR.CASH_REPORT_NO                                 
                     ,AR.DATE_CASH_REPORT                               
                     ,COALESCE(AR.DATE_ORIG_PYMT,IIF(TRY_CONVERT(DATE, 
              '1900-01-01') IS NULL OR (PATINDEX('%.%', '1900-01-01'
              ) <> 0) OR (LEN('1900-01-01') <> 10), CIS.CHAR2DATE(
              '1900-01-01'), CONVERT(DATE, '1900-01-01') )) MSQ020A17          
                     ,AR.CASH_DRAWER_ID                                 
                     ,AR.PYMT_FACILITY_CD                               
                     ,'AR' MSQ020A20                                            
                FROM  CSS_AR_TRANS_HIST AR WITH(READUNCOMMITTED)                
               WHERE :WS-GET-ACCT-DATA-FL   = 'Y'                       
                 AND  AR.ACCOUNT_NO         = :AR-ACCOUNT-NO            
                 AND  AR.DATE_TRANS        >= IIF(TRY_CONVERT(DATE, 
              '1900-01-01') IS NULL OR (PATINDEX('%.%', '1900-01-01'
              ) <> 0) OR (LEN('1900-01-01') <> 10), CIS.CHAR2DATE(
              '1900-01-01'), CONVERT(DATE, '1900-01-01') )              
                 AND  AR.TRANS_HIST_SEQ_NO >= CIS.CHAR2TIMESTAMP(
                                                :PARM-TRNS-HIST-FROM-TS
              )   
                 AND  AR.TRANS_HIST_SEQ_NO  < CIS.CHAR2TIMESTAMP(
                                                  :PARM-TRNS-HIST-TO-TS
              )     
                 AND (AR.CODE_TRAN_TYPE  LIKE :WS-CODE-TRAN-TYPE1       
                  OR  AR.CODE_TRAN_TYPE  LIKE :WS-CODE-TRAN-TYPE2)      
              UNION                                                     
              SELECT  REPLACE(REPLACE(CONVERT(CHAR(26), 
           MH.TRANS_HIST_SEQ_NO, 121), ' ', '-'), ':', '.') 
           TRANS_HIST_SEQ_NO                              
                     ,MH.CODE_TRAN_TYPE                                 
                     ,MH.APPL_PROGRAM_ID                                
                     ,MH.USER_ID                                        
                     ,MH.RESP_AREA_ID                                   
                     ,MH.TRAN_COMMENT                                   
                     ,MH.ACCOUNT_NO                                     
                     ,MH.CUSTOMER_NO                                    
                     ,MH.PREMISE_NO                                     
                     ,0                                                 
                     ,0                                                 
                     ,' '                                               
PRJ586               ,' '                                               
                     ,'   '                                             
                     ,'   '                                             
                     ,'1900-01-01'                                      
                     ,'1900-01-01'                                      
                     ,0                                                 
                     ,' '                                               
                     ,'MH'                                              
                FROM  CSS_MNT_TRANS_HIST MH WITH(READUNCOMMITTED)               
               WHERE :WS-GET-ACCT-DATA-FL   = 'Y'                       
                 AND  MH.ACCOUNT_NO         = :MH-ACCOUNT-NO            
                 AND  MH.DATE_TRANS        >= IIF(TRY_CONVERT(DATE, 
              '1900-01-01') IS NULL OR (PATINDEX('%.%', '1900-01-01'
              ) <> 0) OR (LEN('1900-01-01') <> 10), CIS.CHAR2DATE(
              '1900-01-01'), CONVERT(DATE, '1900-01-01') )              
                 AND  MH.TRANS_HIST_SEQ_NO >= CIS.CHAR2TIMESTAMP(
                                                :PARM-TRNS-HIST-FROM-TS
              )   
                 AND  MH.TRANS_HIST_SEQ_NO  < CIS.CHAR2TIMESTAMP(
                                                  :PARM-TRNS-HIST-TO-TS
              )     
                 AND (MH.CODE_TRAN_TYPE  LIKE :WS-CODE-TRAN-TYPE1       
                  OR  MH.CODE_TRAN_TYPE  LIKE :WS-CODE-TRAN-TYPE2)      
              UNION                                                     
              SELECT  REPLACE(REPLACE(CONVERT(CHAR(26), 
           MH.TRANS_HIST_SEQ_NO, 121), ' ', '-'), ':', '.') 
           TRANS_HIST_SEQ_NO                              
                     ,MH.CODE_TRAN_TYPE                                 
                     ,MH.APPL_PROGRAM_ID                                
                     ,MH.USER_ID                                        
                     ,MH.RESP_AREA_ID                                   
                     ,MH.TRAN_COMMENT                                   
                     ,MH.ACCOUNT_NO                                     
                     ,MH.CUSTOMER_NO                                    
                     ,MH.PREMISE_NO                                     
                     ,0                                                 
                     ,0                                                 
                     ,' '                                               
PRJ586               ,' '                                               
                     ,'   '                                             
                     ,'   '                                             
                     ,'1900-01-01'                                      
                     ,'1900-01-01'                                      
                     ,0                                                 
                     ,' '                                               
                     ,'MH'                                              
                FROM  CSS_MNT_TRANS_HIST MH WITH(READUNCOMMITTED)               
               WHERE :WS-GET-CUST-DATA-FL   = 'Y'                       
                 AND  MH.CUSTOMER_NO        = :MH-CUSTOMER-NO           
                 AND  MH.DATE_TRANS        >= IIF(TRY_CONVERT(DATE, 
              '1900-01-01') IS NULL OR (PATINDEX('%.%', '1900-01-01'
              ) <> 0) OR (LEN('1900-01-01') <> 10), CIS.CHAR2DATE(
              '1900-01-01'), CONVERT(DATE, '1900-01-01') )              
                 AND  MH.TRANS_HIST_SEQ_NO >= CIS.CHAR2TIMESTAMP(
                                                :PARM-TRNS-HIST-FROM-TS
              )   
                 AND  MH.TRANS_HIST_SEQ_NO  < CIS.CHAR2TIMESTAMP(
                                                  :PARM-TRNS-HIST-TO-TS
              )     
                 AND (MH.CODE_TRAN_TYPE  LIKE :WS-CODE-TRAN-TYPE1       
                  OR  MH.CODE_TRAN_TYPE  LIKE :WS-CODE-TRAN-TYPE2)      
              UNION                                                     
              SELECT  REPLACE(REPLACE(CONVERT(CHAR(26), 
           MH.TRANS_HIST_SEQ_NO, 121), ' ', '-'), ':', '.') 
           TRANS_HIST_SEQ_NO                              
                     ,MH.CODE_TRAN_TYPE                                 
                     ,MH.APPL_PROGRAM_ID                                
                     ,MH.USER_ID                                        
                     ,MH.RESP_AREA_ID                                   
                     ,MH.TRAN_COMMENT                                   
                     ,MH.ACCOUNT_NO                                     
                     ,MH.CUSTOMER_NO                                    
                     ,MH.PREMISE_NO                                     
                     ,0                                                 
                     ,0                                                 
                     ,' '                                               
PRJ586               ,' '                                               
                     ,'   '                                             
                     ,'   '                                             
                     ,'1900-01-01'                                      
                     ,'1900-01-01'                                      
                     ,0                                                 
                     ,' '                                               
                     ,'MH'
            FROM  CSS_MNT_TRANS_HIST MH WITH(READUNCOMMITTED)
            WHERE :WS-GET-PREM-DATA-FL   = 'Y'                       
                 AND  MH.PREMISE_NO         = :MH-PREMISE-NO            
                 AND  MH.DATE_TRANS        >= IIF(TRY_CONVERT(DATE, 
              '1900-01-01') IS NULL OR (PATINDEX('%.%', '1900-01-01'
              ) <> 0) OR (LEN('1900-01-01') <> 10), CIS.CHAR2DATE(
              '1900-01-01'), CONVERT(DATE, '1900-01-01') )              
                 AND  MH.TRANS_HIST_SEQ_NO >= CIS.CHAR2TIMESTAMP(
                                                :PARM-TRNS-HIST-FROM-TS
              )   
                 AND  MH.TRANS_HIST_SEQ_NO  < CIS.CHAR2TIMESTAMP(
                                                  :PARM-TRNS-HIST-TO-TS
              )     
                 AND (MH.CODE_TRAN_TYPE  LIKE :WS-CODE-TRAN-TYPE1       
                  OR  MH.CODE_TRAN_TYPE  LIKE :WS-CODE-TRAN-TYPE2)
            
                        ) MSQ020
                 
                 
                 ORDER BY 1 DESC                                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE  TRNS_HDR_ACP CURSOR WITH ROWSET POSITIONING FOR           
MFA-TR*       SELECT  AR.TRANS_HIST_SEQ_NO                                      
MFA-TR*              ,AR.CODE_TRAN_TYPE                                         
MFA-TR*              ,AR.APPL_PROGRAM_ID                                        
MFA-TR*              ,AR.USER_ID                                                
MFA-TR*              ,AR.RESP_AREA_ID                                           
MFA-TR*              ,AR.TRAN_COMMENT                                           
MFA-TR*              ,AR.ACCOUNT_NO                                             
MFA-TR*              ,0                                                         
MFA-TR*              ,0                                                         
MFA-TR*              ,AR.AMT_ORIG_ENTERED                                       
MFA-TR*              ,AR.AMT_BILLED_UNPAID                                      
MFA-TR*              ,AR.RECORD_ONLY_FL                                         
MFA-TR*              ,AR.PYMT_REFUNDED_IND                                      
MFA-TR*              ,AR.CASH_LOCAL_OFFICE                                      
MFA-TR*              ,AR.CASH_REPORT_NO                                         
MFA-TR*              ,AR.DATE_CASH_REPORT                                       
MFA-TR*              ,IFNULL(AR.DATE_ORIG_PYMT,'1900-01-01')                    
MFA-TR*              ,AR.CASH_DRAWER_ID                                         
MFA-TR*              ,AR.PYMT_FACILITY_CD                                       
MFA-TR*              ,'AR'                                                      
MFA-TR*         FROM  CSS_AR_TRANS_HIST AR                                      
MFA-TR*        WHERE :WS-GET-ACCT-DATA-FL   = 'Y'                               
MFA-TR*          AND  AR.ACCOUNT_NO         = :AR-ACCOUNT-NO                    
MFA-TR*          AND  AR.DATE_TRANS        >= '1900-01-01'                      
MFA-TR*          AND  AR.TRANS_HIST_SEQ_NO >= :PARM-TRNS-HIST-FROM-TS           
MFA-TR*          AND  AR.TRANS_HIST_SEQ_NO  < :PARM-TRNS-HIST-TO-TS             
MFA-TR*          AND (AR.CODE_TRAN_TYPE  LIKE :WS-CODE-TRAN-TYPE1               
MFA-TR*           OR  AR.CODE_TRAN_TYPE  LIKE :WS-CODE-TRAN-TYPE2)              
MFA-TR*       UNION                                                             
MFA-TR*       SELECT  MH.TRANS_HIST_SEQ_NO                                      
MFA-TR*              ,MH.CODE_TRAN_TYPE                                         
MFA-TR*              ,MH.APPL_PROGRAM_ID                                        
MFA-TR*              ,MH.USER_ID                                                
MFA-TR*              ,MH.RESP_AREA_ID                                           
MFA-TR*              ,MH.TRAN_COMMENT                                           
MFA-TR*              ,MH.ACCOUNT_NO                                             
MFA-TR*              ,MH.CUSTOMER_NO                                            
MFA-TR*              ,MH.PREMISE_NO                                             
MFA-TR*              ,0                                                         
MFA-TR*              ,0                                                         
MFA-TR*              ,' '                                                       
MFA-TR*              ,' '                                                       
MFA-TR*              ,'   '                                                     
MFA-TR*              ,'   '                                                     
MFA-TR*              ,'1900-01-01'                                              
MFA-TR*              ,'1900-01-01'                                              
MFA-TR*              ,0                                                         
MFA-TR*              ,' '                                                       
MFA-TR*              ,'MH'                                                      
MFA-TR*         FROM  CSS_MNT_TRANS_HIST MH                                     
MFA-TR*        WHERE :WS-GET-ACCT-DATA-FL   = 'Y'                               
MFA-TR*          AND  MH.ACCOUNT_NO         = :MH-ACCOUNT-NO                    
MFA-TR*          AND  MH.DATE_TRANS        >= '1900-01-01'                      
MFA-TR*          AND  MH.TRANS_HIST_SEQ_NO >= :PARM-TRNS-HIST-FROM-TS           
MFA-TR*          AND  MH.TRANS_HIST_SEQ_NO  < :PARM-TRNS-HIST-TO-TS             
MFA-TR*          AND (MH.CODE_TRAN_TYPE  LIKE :WS-CODE-TRAN-TYPE1               
MFA-TR*           OR  MH.CODE_TRAN_TYPE  LIKE :WS-CODE-TRAN-TYPE2)              
MFA-TR*       UNION                                                             
MFA-TR*       SELECT  MH.TRANS_HIST_SEQ_NO                                      
MFA-TR*              ,MH.CODE_TRAN_TYPE                                         
MFA-TR*              ,MH.APPL_PROGRAM_ID                                        
MFA-TR*              ,MH.USER_ID                                                
MFA-TR*              ,MH.RESP_AREA_ID                                           
MFA-TR*              ,MH.TRAN_COMMENT                                           
MFA-TR*              ,MH.ACCOUNT_NO                                             
MFA-TR*              ,MH.CUSTOMER_NO                                            
MFA-TR*              ,MH.PREMISE_NO                                             
MFA-TR*              ,0                                                         
MFA-TR*              ,0                                                         
MFA-TR*              ,' '                                                       
MFA-TR*              ,' '                                                       
MFA-TR*              ,'   '                                                     
MFA-TR*              ,'   '                                                     
MFA-TR*              ,'1900-01-01'                                              
MFA-TR*              ,'1900-01-01'                                              
MFA-TR*              ,0                                                         
MFA-TR*              ,' '                                                       
MFA-TR*              ,'MH'                                                      
MFA-TR*         FROM  CSS_MNT_TRANS_HIST MH                                     
MFA-TR*        WHERE :WS-GET-CUST-DATA-FL   = 'Y'                               
MFA-TR*          AND  MH.CUSTOMER_NO        = :MH-CUSTOMER-NO                   
MFA-TR*          AND  MH.DATE_TRANS        >= '1900-01-01'                      
MFA-TR*          AND  MH.TRANS_HIST_SEQ_NO >= :PARM-TRNS-HIST-FROM-TS           
MFA-TR*          AND  MH.TRANS_HIST_SEQ_NO  < :PARM-TRNS-HIST-TO-TS             
MFA-TR*          AND (MH.CODE_TRAN_TYPE  LIKE :WS-CODE-TRAN-TYPE1               
MFA-TR*           OR  MH.CODE_TRAN_TYPE  LIKE :WS-CODE-TRAN-TYPE2)              
MFA-TR*       UNION                                                             
MFA-TR*       SELECT  MH.TRANS_HIST_SEQ_NO                                      
MFA-TR*              ,MH.CODE_TRAN_TYPE                                         
MFA-TR*              ,MH.APPL_PROGRAM_ID                                        
MFA-TR*              ,MH.USER_ID                                                
MFA-TR*              ,MH.RESP_AREA_ID                                           
MFA-TR*              ,MH.TRAN_COMMENT                                           
MFA-TR*              ,MH.ACCOUNT_NO                                             
MFA-TR*              ,MH.CUSTOMER_NO                                            
MFA-TR*              ,MH.PREMISE_NO                                             
MFA-TR*              ,0                                                         
MFA-TR*              ,0                                                         
MFA-TR*              ,' '                                                       
MFA-TR*              ,' '                                                       
MFA-TR*              ,'   '                                                     
MFA-TR*              ,'   '                                                     
MFA-TR*              ,'1900-01-01'                                              
MFA-TR*              ,'1900-01-01'                                              
MFA-TR*              ,0                                                         
MFA-TR*              ,' '                                                       
MFA-TR*              ,'MH'                                                      
MFA-TR*         FROM  CSS_MNT_TRANS_HIST MH                                     
MFA-TR*        WHERE :WS-GET-PREM-DATA-FL   = 'Y'                               
MFA-TR*          AND  MH.PREMISE_NO         = :MH-PREMISE-NO                    
MFA-TR*          AND  MH.DATE_TRANS        >= '1900-01-01'                      
MFA-TR*          AND  MH.TRANS_HIST_SEQ_NO >= :PARM-TRNS-HIST-FROM-TS           
MFA-TR*          AND  MH.TRANS_HIST_SEQ_NO  < :PARM-TRNS-HIST-TO-TS             
MFA-TR*          AND (MH.CODE_TRAN_TYPE  LIKE :WS-CODE-TRAN-TYPE1               
MFA-TR*           OR  MH.CODE_TRAN_TYPE  LIKE :WS-CODE-TRAN-TYPE2)              
MFA-TR*       ORDER BY 1 DESC                                                   
MFA-TR*       FETCH FIRST 21 ROWS ONLY WITH UR                                  
MFA-TR*       QUERYNO 7100                                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ****ACCOUT RECEIVABLES / MAINTENANCE TRANS HIST DATA                      
      ****CALL TYPE = 'A' (ACCOUNT)                                             
      *                                                                         
           EXEC SQL                                                     
             DECLARE  TRNS_HDR_ACCT CURSOR WITH ROWSET POSITIONING FOR  
              SELECT TOP(21) MSQ020.*
               FROM (
                 SELECT  REPLACE(REPLACE(CONVERT(CHAR(26), 
           AR.TRANS_HIST_SEQ_NO, 121), ' ', '-'), ':', '.') 
           TRANS_HIST_SEQ_NO                              
                     ,AR.CODE_TRAN_TYPE                                 
                     ,AR.APPL_PROGRAM_ID                                
                     ,AR.USER_ID                                        
                     ,AR.RESP_AREA_ID                                   
                     ,AR.TRAN_COMMENT                                   
                     ,AR.ACCOUNT_NO                                     
                     ,0 MSQ020A8                                                
                     ,0 MSQ020A9                                                
                     ,AR.AMT_ORIG_ENTERED                               
                     ,AR.AMT_BILLED_UNPAID                              
                     ,AR.RECORD_ONLY_FL                                 
PRJ586               ,AR.PYMT_REFUNDED_IND                              
                     ,AR.CASH_LOCAL_OFFICE                              
                     ,AR.CASH_REPORT_NO                                 
                     ,AR.DATE_CASH_REPORT                               
                     ,COALESCE(AR.DATE_ORIG_PYMT,IIF(TRY_CONVERT(DATE, 
              '1900-01-01') IS NULL OR (PATINDEX('%.%', '1900-01-01'
              ) <> 0) OR (LEN('1900-01-01') <> 10), CIS.CHAR2DATE(
              '1900-01-01'), CONVERT(DATE, '1900-01-01') )) MSQ020A17          
                     ,AR.CASH_DRAWER_ID                                 
                     ,AR.PYMT_FACILITY_CD                               
                     ,'AR' MSQ020A20                                            
                FROM  CSS_AR_TRANS_HIST AR WITH(READUNCOMMITTED)                
               WHERE :WS-GET-ACCT-DATA-FL   = 'Y'                       
                 AND  AR.ACCOUNT_NO         = :AR-ACCOUNT-NO            
                 AND  AR.DATE_TRANS        >= IIF(TRY_CONVERT(DATE, 
              '1900-01-01') IS NULL OR (PATINDEX('%.%', '1900-01-01'
              ) <> 0) OR (LEN('1900-01-01') <> 10), CIS.CHAR2DATE(
              '1900-01-01'), CONVERT(DATE, '1900-01-01') )              
                 AND  AR.TRANS_HIST_SEQ_NO >= CIS.CHAR2TIMESTAMP(
                                                :PARM-TRNS-HIST-FROM-TS
              )   
                 AND  AR.TRANS_HIST_SEQ_NO  < CIS.CHAR2TIMESTAMP(
                                                  :PARM-TRNS-HIST-TO-TS
              )     
                 AND (AR.CODE_TRAN_TYPE  LIKE :WS-CODE-TRAN-TYPE1       
                  OR  AR.CODE_TRAN_TYPE  LIKE :WS-CODE-TRAN-TYPE2)      
              UNION                                                     
              SELECT  REPLACE(REPLACE(CONVERT(CHAR(26), 
           MH.TRANS_HIST_SEQ_NO, 121), ' ', '-'), ':', '.') 
           TRANS_HIST_SEQ_NO                              
                     ,MH.CODE_TRAN_TYPE                                 
                     ,MH.APPL_PROGRAM_ID                                
                     ,MH.USER_ID                                        
                     ,MH.RESP_AREA_ID                                   
                     ,MH.TRAN_COMMENT                                   
                     ,MH.ACCOUNT_NO                                     
                     ,MH.CUSTOMER_NO                                    
                     ,MH.PREMISE_NO                                     
                     ,0                                                 
                     ,0                                                 
                     ,' '                                               
                     ,' '                                               
                     ,'   '                                             
                     ,'   '                                             
                     ,'1900-01-01'                                      
                     ,'1900-01-01'                                      
                     ,0                                                 
                     ,' '                                               
                     ,'MH'
            FROM  CSS_MNT_TRANS_HIST MH WITH(READUNCOMMITTED)
            WHERE :WS-GET-ACCT-DATA-FL   = 'Y'                       
                 AND  MH.ACCOUNT_NO         = :MH-ACCOUNT-NO            
                 AND  MH.DATE_TRANS        >= IIF(TRY_CONVERT(DATE, 
              '1900-01-01') IS NULL OR (PATINDEX('%.%', '1900-01-01'
              ) <> 0) OR (LEN('1900-01-01') <> 10), CIS.CHAR2DATE(
              '1900-01-01'), CONVERT(DATE, '1900-01-01') )              
                 AND  MH.TRANS_HIST_SEQ_NO >= CIS.CHAR2TIMESTAMP(
                                                :PARM-TRNS-HIST-FROM-TS
              )   
                 AND  MH.TRANS_HIST_SEQ_NO  < CIS.CHAR2TIMESTAMP(
                                                  :PARM-TRNS-HIST-TO-TS
              )     
                 AND (MH.CODE_TRAN_TYPE  LIKE :WS-CODE-TRAN-TYPE1       
                  OR  MH.CODE_TRAN_TYPE  LIKE :WS-CODE-TRAN-TYPE2)
            
                        ) MSQ020
                 
                 
                 ORDER BY 1 DESC                                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE  TRNS_HDR_ACCT CURSOR WITH ROWSET POSITIONING FOR          
MFA-TR*       SELECT  AR.TRANS_HIST_SEQ_NO                                      
MFA-TR*              ,AR.CODE_TRAN_TYPE                                         
MFA-TR*              ,AR.APPL_PROGRAM_ID                                        
MFA-TR*              ,AR.USER_ID                                                
MFA-TR*              ,AR.RESP_AREA_ID                                           
MFA-TR*              ,AR.TRAN_COMMENT                                           
MFA-TR*              ,AR.ACCOUNT_NO                                             
MFA-TR*              ,0                                                         
MFA-TR*              ,0                                                         
MFA-TR*              ,AR.AMT_ORIG_ENTERED                                       
MFA-TR*              ,AR.AMT_BILLED_UNPAID                                      
MFA-TR*              ,AR.RECORD_ONLY_FL                                         
MFA-TR*              ,AR.PYMT_REFUNDED_IND                                      
MFA-TR*              ,AR.CASH_LOCAL_OFFICE                                      
MFA-TR*              ,AR.CASH_REPORT_NO                                         
MFA-TR*              ,AR.DATE_CASH_REPORT                                       
MFA-TR*              ,IFNULL(AR.DATE_ORIG_PYMT,'1900-01-01')                    
MFA-TR*              ,AR.CASH_DRAWER_ID                                         
MFA-TR*              ,AR.PYMT_FACILITY_CD                                       
MFA-TR*              ,'AR'                                                      
MFA-TR*         FROM  CSS_AR_TRANS_HIST AR                                      
MFA-TR*        WHERE :WS-GET-ACCT-DATA-FL   = 'Y'                               
MFA-TR*          AND  AR.ACCOUNT_NO         = :AR-ACCOUNT-NO                    
MFA-TR*          AND  AR.DATE_TRANS        >= '1900-01-01'                      
MFA-TR*          AND  AR.TRANS_HIST_SEQ_NO >= :PARM-TRNS-HIST-FROM-TS           
MFA-TR*          AND  AR.TRANS_HIST_SEQ_NO  < :PARM-TRNS-HIST-TO-TS             
MFA-TR*          AND (AR.CODE_TRAN_TYPE  LIKE :WS-CODE-TRAN-TYPE1               
MFA-TR*           OR  AR.CODE_TRAN_TYPE  LIKE :WS-CODE-TRAN-TYPE2)              
MFA-TR*       UNION                                                             
MFA-TR*       SELECT  MH.TRANS_HIST_SEQ_NO                                      
MFA-TR*              ,MH.CODE_TRAN_TYPE                                         
MFA-TR*              ,MH.APPL_PROGRAM_ID                                        
MFA-TR*              ,MH.USER_ID                                                
MFA-TR*              ,MH.RESP_AREA_ID                                           
MFA-TR*              ,MH.TRAN_COMMENT                                           
MFA-TR*              ,MH.ACCOUNT_NO                                             
MFA-TR*              ,MH.CUSTOMER_NO                                            
MFA-TR*              ,MH.PREMISE_NO                                             
MFA-TR*              ,0                                                         
MFA-TR*              ,0                                                         
MFA-TR*              ,' '                                                       
MFA-TR*              ,' '                                                       
MFA-TR*              ,'   '                                                     
MFA-TR*              ,'   '                                                     
MFA-TR*              ,'1900-01-01'                                              
MFA-TR*              ,'1900-01-01'                                              
MFA-TR*              ,0                                                         
MFA-TR*              ,' '                                                       
MFA-TR*              ,'MH'                                                      
MFA-TR*         FROM  CSS_MNT_TRANS_HIST MH                                     
MFA-TR*        WHERE :WS-GET-ACCT-DATA-FL   = 'Y'                               
MFA-TR*          AND  MH.ACCOUNT_NO         = :MH-ACCOUNT-NO                    
MFA-TR*          AND  MH.DATE_TRANS        >= '1900-01-01'                      
MFA-TR*          AND  MH.TRANS_HIST_SEQ_NO >= :PARM-TRNS-HIST-FROM-TS           
MFA-TR*          AND  MH.TRANS_HIST_SEQ_NO  < :PARM-TRNS-HIST-TO-TS             
MFA-TR*          AND (MH.CODE_TRAN_TYPE  LIKE :WS-CODE-TRAN-TYPE1               
MFA-TR*           OR  MH.CODE_TRAN_TYPE  LIKE :WS-CODE-TRAN-TYPE2)              
MFA-TR*       ORDER BY 1 DESC                                                   
MFA-TR*       FETCH FIRST 21 ROWS ONLY WITH UR                                  
MFA-TR*       QUERYNO 7150                                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ****MAINTENANCE TRANS HIST DATA                                           
      ****CALL TYPE = 'C' (CUSTOMER)                                            
      *                                                                         
           EXEC SQL                                                     
             DECLARE  TRNS_HDR_CUST CURSOR WITH ROWSET POSITIONING FOR  
              SELECT TOP(21) REPLACE(REPLACE(CONVERT(CHAR(26), 
           MH.TRANS_HIST_SEQ_NO, 121), ' ', '-'), ':', '.') 
           TRANS_HIST_SEQ_NO,
              MH.CODE_TRAN_TYPE,
              MH.APPL_PROGRAM_ID,
              MH.USER_ID,
              MH.RESP_AREA_ID,
              MH.TRAN_COMMENT,
              MH.ACCOUNT_NO,
              MH.CUSTOMER_NO,
              MH.PREMISE_NO,
              'MH'                                              
                FROM  CSS_MNT_TRANS_HIST MH WITH(READUNCOMMITTED)               
               WHERE  MH.CUSTOMER_NO        = :MH-CUSTOMER-NO           
                 AND  MH.DATE_TRANS        >= IIF(TRY_CONVERT(DATE, 
              '1900-01-01') IS NULL OR (PATINDEX('%.%', '1900-01-01'
              ) <> 0) OR (LEN('1900-01-01') <> 10), CIS.CHAR2DATE(
              '1900-01-01'), CONVERT(DATE, '1900-01-01') )              
                 AND  MH.TRANS_HIST_SEQ_NO >= CIS.CHAR2TIMESTAMP(
                                                :PARM-TRNS-HIST-FROM-TS
              )   
                 AND  MH.TRANS_HIST_SEQ_NO  < CIS.CHAR2TIMESTAMP(
                                                  :PARM-TRNS-HIST-TO-TS
              )     
                 AND (MH.CODE_TRAN_TYPE  LIKE :WS-CODE-TRAN-TYPE1       
                  OR  MH.CODE_TRAN_TYPE  LIKE :WS-CODE-TRAN-TYPE2)      
              ORDER BY 1 DESC                                           
                                         
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE  TRNS_HDR_CUST CURSOR WITH ROWSET POSITIONING FOR          
MFA-TR*       SELECT  MH.TRANS_HIST_SEQ_NO                                      
MFA-TR*              ,MH.CODE_TRAN_TYPE                                         
MFA-TR*              ,MH.APPL_PROGRAM_ID                                        
MFA-TR*              ,MH.USER_ID                                                
MFA-TR*              ,MH.RESP_AREA_ID                                           
MFA-TR*              ,MH.TRAN_COMMENT                                           
MFA-TR*              ,MH.ACCOUNT_NO                                             
MFA-TR*              ,MH.CUSTOMER_NO                                            
MFA-TR*              ,MH.PREMISE_NO                                             
MFA-TR*              ,'MH'                                                      
MFA-TR*         FROM  CSS_MNT_TRANS_HIST MH                                     
MFA-TR*        WHERE  MH.CUSTOMER_NO        = :MH-CUSTOMER-NO                   
MFA-TR*          AND  MH.DATE_TRANS        >= '1900-01-01'                      
MFA-TR*          AND  MH.TRANS_HIST_SEQ_NO >= :PARM-TRNS-HIST-FROM-TS           
MFA-TR*          AND  MH.TRANS_HIST_SEQ_NO  < :PARM-TRNS-HIST-TO-TS             
MFA-TR*          AND (MH.CODE_TRAN_TYPE  LIKE :WS-CODE-TRAN-TYPE1               
MFA-TR*           OR  MH.CODE_TRAN_TYPE  LIKE :WS-CODE-TRAN-TYPE2)              
MFA-TR*       ORDER BY 1 DESC                                                   
MFA-TR*       FETCH FIRST 21 ROWS ONLY WITH UR                                  
MFA-TR*       QUERYNO 7200                                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ****MAINTAIN TRNS HIST HDR DATA-ACCOUNT                                   
      ****CALL TYPE = 'P' (PREMISE)                                             
      *                                                                         
           EXEC SQL                                                     
             DECLARE  TRNS_HDR_PREM CURSOR WITH ROWSET POSITIONING FOR  
              SELECT TOP(21) REPLACE(REPLACE(CONVERT(CHAR(26), 
           MH.TRANS_HIST_SEQ_NO, 121), ' ', '-'), ':', '.') 
           TRANS_HIST_SEQ_NO,
              MH.CODE_TRAN_TYPE,
              MH.APPL_PROGRAM_ID,
              MH.USER_ID,
              MH.RESP_AREA_ID,
              MH.TRAN_COMMENT,
              MH.ACCOUNT_NO,
              MH.CUSTOMER_NO,
              MH.PREMISE_NO,
              'MH'                                              
                FROM  CSS_MNT_TRANS_HIST MH WITH(READUNCOMMITTED)               
               WHERE  MH.PREMISE_NO         = :MH-PREMISE-NO            
                 AND  MH.DATE_TRANS        >= IIF(TRY_CONVERT(DATE, 
              '1900-01-01') IS NULL OR (PATINDEX('%.%', '1900-01-01'
              ) <> 0) OR (LEN('1900-01-01') <> 10), CIS.CHAR2DATE(
              '1900-01-01'), CONVERT(DATE, '1900-01-01') )              
                 AND  MH.TRANS_HIST_SEQ_NO >= CIS.CHAR2TIMESTAMP(
                                                :PARM-TRNS-HIST-FROM-TS
              )   
                 AND  MH.TRANS_HIST_SEQ_NO  < CIS.CHAR2TIMESTAMP(
                                                  :PARM-TRNS-HIST-TO-TS
              )     
                 AND (MH.CODE_TRAN_TYPE  LIKE :WS-CODE-TRAN-TYPE1       
                  OR  MH.CODE_TRAN_TYPE  LIKE :WS-CODE-TRAN-TYPE2)      
              ORDER BY 1 DESC                                           
                                         
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE  TRNS_HDR_PREM CURSOR WITH ROWSET POSITIONING FOR          
MFA-TR*       SELECT  MH.TRANS_HIST_SEQ_NO                                      
MFA-TR*              ,MH.CODE_TRAN_TYPE                                         
MFA-TR*              ,MH.APPL_PROGRAM_ID                                        
MFA-TR*              ,MH.USER_ID                                                
MFA-TR*              ,MH.RESP_AREA_ID                                           
MFA-TR*              ,MH.TRAN_COMMENT                                           
MFA-TR*              ,MH.ACCOUNT_NO                                             
MFA-TR*              ,MH.CUSTOMER_NO                                            
MFA-TR*              ,MH.PREMISE_NO                                             
MFA-TR*              ,'MH'                                                      
MFA-TR*         FROM  CSS_MNT_TRANS_HIST MH                                     
MFA-TR*        WHERE  MH.PREMISE_NO         = :MH-PREMISE-NO                    
MFA-TR*          AND  MH.DATE_TRANS        >= '1900-01-01'                      
MFA-TR*          AND  MH.TRANS_HIST_SEQ_NO >= :PARM-TRNS-HIST-FROM-TS           
MFA-TR*          AND  MH.TRANS_HIST_SEQ_NO  < :PARM-TRNS-HIST-TO-TS             
MFA-TR*          AND (MH.CODE_TRAN_TYPE  LIKE :WS-CODE-TRAN-TYPE1               
MFA-TR*           OR  MH.CODE_TRAN_TYPE  LIKE :WS-CODE-TRAN-TYPE2)              
MFA-TR*       ORDER BY 1 DESC                                                   
MFA-TR*       FETCH FIRST 21 ROWS ONLY WITH UR                                  
MFA-TR*       QUERYNO 7250                                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ****ACCT RECV/MAINTAIN TRNS HIST HDR DATA-RESP AREA ID                    
      *                                                                         
           EXEC SQL                                                     
             DECLARE  TRNS_HDR_RESP CURSOR WITH ROWSET POSITIONING FOR  
              SELECT TOP(21) MSQ020.*
               FROM (
                 SELECT  REPLACE(REPLACE(CONVERT(CHAR(26), 
           AR.TRANS_HIST_SEQ_NO, 121), ' ', '-'), ':', '.') 
           TRANS_HIST_SEQ_NO                              
                     ,AR.CODE_TRAN_TYPE                                 
                     ,AR.APPL_PROGRAM_ID                                
                     ,AR.USER_ID                                        
                     ,AR.RESP_AREA_ID                                   
                     ,AR.TRAN_COMMENT                                   
                     ,AR.ACCOUNT_NO                                     
                     ,0 MSQ020A8                                                
                     ,0 MSQ020A9                                                
                     ,AR.AMT_ORIG_ENTERED                               
                     ,AR.AMT_BILLED_UNPAID                              
                     ,AR.RECORD_ONLY_FL                                 
PRJ586               ,AR.PYMT_REFUNDED_IND                              
                     ,AR.CASH_LOCAL_OFFICE                              
                     ,AR.CASH_REPORT_NO                                 
                     ,AR.DATE_CASH_REPORT                               
                     ,COALESCE(AR.DATE_ORIG_PYMT,IIF(TRY_CONVERT(DATE, 
              '1900-01-01') IS NULL OR (PATINDEX('%.%', '1900-01-01'
              ) <> 0) OR (LEN('1900-01-01') <> 10), CIS.CHAR2DATE(
              '1900-01-01'), CONVERT(DATE, '1900-01-01') )) MSQ020A17          
                     ,AR.CASH_DRAWER_ID                                 
                     ,AR.PYMT_FACILITY_CD                               
                     ,'AR' MSQ020A20                                            
                FROM  CSS_AR_TRANS_HIST AR WITH(READUNCOMMITTED)                
               WHERE  AR.RESP_AREA_ID       = :AR-RESP-AREA-ID          
                 AND  AR.DATE_TRANS        >= IIF(TRY_CONVERT(DATE, 
              '1900-01-01') IS NULL OR (PATINDEX('%.%', '1900-01-01'
              ) <> 0) OR (LEN('1900-01-01') <> 10), CIS.CHAR2DATE(
              '1900-01-01'), CONVERT(DATE, '1900-01-01') )              
                 AND  AR.TRANS_HIST_SEQ_NO >= CIS.CHAR2TIMESTAMP(
                                                :PARM-TRNS-HIST-FROM-TS
              )   
                 AND  AR.TRANS_HIST_SEQ_NO  < CIS.CHAR2TIMESTAMP(
                                                  :PARM-TRNS-HIST-TO-TS
              )     
                 AND (AR.CODE_TRAN_TYPE  LIKE :WS-CODE-TRAN-TYPE1       
                  OR  AR.CODE_TRAN_TYPE  LIKE :WS-CODE-TRAN-TYPE2)      
              UNION                                                     
              SELECT  REPLACE(REPLACE(CONVERT(CHAR(26), 
           MH.TRANS_HIST_SEQ_NO, 121), ' ', '-'), ':', '.') 
           TRANS_HIST_SEQ_NO                              
                     ,MH.CODE_TRAN_TYPE                                 
                     ,MH.APPL_PROGRAM_ID                                
                     ,MH.USER_ID                                        
                     ,MH.RESP_AREA_ID                                   
                     ,MH.TRAN_COMMENT                                   
                     ,MH.ACCOUNT_NO                                     
                     ,MH.CUSTOMER_NO                                    
                     ,MH.PREMISE_NO                                     
                     ,0                                                 
                     ,0                                                 
                     ,' '                                               
PRJ586               ,' '                                               
                     ,'   '                                             
                     ,'   '                                             
                     ,'1900-01-01'                                      
                     ,'1900-01-01'                                      
                     ,0                                                 
                     ,' '                                               
                     ,'MH'
            FROM  CSS_MNT_TRANS_HIST MH WITH(READUNCOMMITTED)
            WHERE  MH.RESP_AREA_ID       = :MH-RESP-AREA-ID          
                 AND  MH.DATE_TRANS        >= IIF(TRY_CONVERT(DATE, 
              '1900-01-01') IS NULL OR (PATINDEX('%.%', '1900-01-01'
              ) <> 0) OR (LEN('1900-01-01') <> 10), CIS.CHAR2DATE(
              '1900-01-01'), CONVERT(DATE, '1900-01-01') )              
                 AND  MH.TRANS_HIST_SEQ_NO >= CIS.CHAR2TIMESTAMP(
                                                :PARM-TRNS-HIST-FROM-TS
              )   
                 AND  MH.TRANS_HIST_SEQ_NO  < CIS.CHAR2TIMESTAMP(
                                                  :PARM-TRNS-HIST-TO-TS
              )     
                 AND (MH.CODE_TRAN_TYPE  LIKE :WS-CODE-TRAN-TYPE1       
                  OR  MH.CODE_TRAN_TYPE  LIKE :WS-CODE-TRAN-TYPE2)
            
                        ) MSQ020
                 
                 
                 ORDER BY 1 DESC                                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE  TRNS_HDR_RESP CURSOR WITH ROWSET POSITIONING FOR          
MFA-TR*       SELECT  AR.TRANS_HIST_SEQ_NO                                      
MFA-TR*              ,AR.CODE_TRAN_TYPE                                         
MFA-TR*              ,AR.APPL_PROGRAM_ID                                        
MFA-TR*              ,AR.USER_ID                                                
MFA-TR*              ,AR.RESP_AREA_ID                                           
MFA-TR*              ,AR.TRAN_COMMENT                                           
MFA-TR*              ,AR.ACCOUNT_NO                                             
MFA-TR*              ,0                                                         
MFA-TR*              ,0                                                         
MFA-TR*              ,AR.AMT_ORIG_ENTERED                                       
MFA-TR*              ,AR.AMT_BILLED_UNPAID                                      
MFA-TR*              ,AR.RECORD_ONLY_FL                                         
MFA-TR*              ,AR.PYMT_REFUNDED_IND                                      
MFA-TR*              ,AR.CASH_LOCAL_OFFICE                                      
MFA-TR*              ,AR.CASH_REPORT_NO                                         
MFA-TR*              ,AR.DATE_CASH_REPORT                                       
MFA-TR*              ,IFNULL(AR.DATE_ORIG_PYMT,'1900-01-01')                    
MFA-TR*              ,AR.CASH_DRAWER_ID                                         
MFA-TR*              ,AR.PYMT_FACILITY_CD                                       
MFA-TR*              ,'AR'                                                      
MFA-TR*         FROM  CSS_AR_TRANS_HIST AR                                      
MFA-TR*        WHERE  AR.RESP_AREA_ID       = :AR-RESP-AREA-ID                  
MFA-TR*          AND  AR.DATE_TRANS        >= '1900-01-01'                      
MFA-TR*          AND  AR.TRANS_HIST_SEQ_NO >= :PARM-TRNS-HIST-FROM-TS           
MFA-TR*          AND  AR.TRANS_HIST_SEQ_NO  < :PARM-TRNS-HIST-TO-TS             
MFA-TR*          AND (AR.CODE_TRAN_TYPE  LIKE :WS-CODE-TRAN-TYPE1               
MFA-TR*           OR  AR.CODE_TRAN_TYPE  LIKE :WS-CODE-TRAN-TYPE2)              
MFA-TR*       UNION                                                             
MFA-TR*       SELECT  MH.TRANS_HIST_SEQ_NO                                      
MFA-TR*              ,MH.CODE_TRAN_TYPE                                         
MFA-TR*              ,MH.APPL_PROGRAM_ID                                        
MFA-TR*              ,MH.USER_ID                                                
MFA-TR*              ,MH.RESP_AREA_ID                                           
MFA-TR*              ,MH.TRAN_COMMENT                                           
MFA-TR*              ,MH.ACCOUNT_NO                                             
MFA-TR*              ,MH.CUSTOMER_NO                                            
MFA-TR*              ,MH.PREMISE_NO                                             
MFA-TR*              ,0                                                         
MFA-TR*              ,0                                                         
MFA-TR*              ,' '                                                       
MFA-TR*              ,' '                                                       
MFA-TR*              ,'   '                                                     
MFA-TR*              ,'   '                                                     
MFA-TR*              ,'1900-01-01'                                              
MFA-TR*              ,'1900-01-01'                                              
MFA-TR*              ,0                                                         
MFA-TR*              ,' '                                                       
MFA-TR*              ,'MH'                                                      
MFA-TR*         FROM  CSS_MNT_TRANS_HIST MH                                     
MFA-TR*        WHERE  MH.RESP_AREA_ID       = :MH-RESP-AREA-ID                  
MFA-TR*          AND  MH.DATE_TRANS        >= '1900-01-01'                      
MFA-TR*          AND  MH.TRANS_HIST_SEQ_NO >= :PARM-TRNS-HIST-FROM-TS           
MFA-TR*          AND  MH.TRANS_HIST_SEQ_NO  < :PARM-TRNS-HIST-TO-TS             
MFA-TR*          AND (MH.CODE_TRAN_TYPE  LIKE :WS-CODE-TRAN-TYPE1               
MFA-TR*           OR  MH.CODE_TRAN_TYPE  LIKE :WS-CODE-TRAN-TYPE2)              
MFA-TR*       ORDER BY 1 DESC                                                   
MFA-TR*       FETCH FIRST 21 ROWS ONLY WITH UR                                  
MFA-TR*       QUERYNO 7300                                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ****ACCT RECV TRANS HIST DET ONLY - RESP AREA ID & AR ONLY                
      *                                                                         
           EXEC SQL                                                     
             DECLARE TRNS_HDR_RESP_AR CURSOR WITH ROWSET POSITIONING FOR
              SELECT TOP(21) REPLACE(REPLACE(CONVERT(CHAR(26), 
           AR.TRANS_HIST_SEQ_NO, 121), ' ', '-'), ':', '.') 
           TRANS_HIST_SEQ_NO,
              AR.CODE_TRAN_TYPE,
              AR.APPL_PROGRAM_ID,
              AR.USER_ID,
              AR.RESP_AREA_ID,
              AR.TRAN_COMMENT,
              AR.ACCOUNT_NO,
              0,
              0,
              AR.AMT_ORIG_ENTERED,
              AR.AMT_BILLED_UNPAID,
              AR.RECORD_ONLY_FL,
              AR.PYMT_REFUNDED_IND,
              AR.CASH_LOCAL_OFFICE,
              AR.CASH_REPORT_NO,
              AR.DATE_CASH_REPORT,
              COALESCE(AR.DATE_ORIG_PYMT,IIF(TRY_CONVERT(DATE, 
              '1900-01-01') IS NULL OR (PATINDEX('%.%', '1900-01-01'
              ) <> 0) OR (LEN('1900-01-01') <> 10), CIS.CHAR2DATE(
              '1900-01-01'), CONVERT(DATE, '1900-01-01') )),
              AR.CASH_DRAWER_ID,
              AR.PYMT_FACILITY_CD,
              'AR'                                              
                FROM  CSS_AR_TRANS_HIST AR WITH(READUNCOMMITTED)                
               WHERE  AR.RESP_AREA_ID       = :AR-RESP-AREA-ID          
                 AND  AR.DATE_TRANS        >= IIF(TRY_CONVERT(DATE, 
              '1900-01-01') IS NULL OR (PATINDEX('%.%', '1900-01-01'
              ) <> 0) OR (LEN('1900-01-01') <> 10), CIS.CHAR2DATE(
              '1900-01-01'), CONVERT(DATE, '1900-01-01') )              
                 AND  AR.TRANS_HIST_SEQ_NO >= CIS.CHAR2TIMESTAMP(
                                                :PARM-TRNS-HIST-FROM-TS
              )   
                 AND  AR.TRANS_HIST_SEQ_NO  < CIS.CHAR2TIMESTAMP(
                                                  :PARM-TRNS-HIST-TO-TS
              )     
                 AND (AR.CODE_TRAN_TYPE  LIKE :WS-CODE-TRAN-TYPE1       
                  OR  AR.CODE_TRAN_TYPE  LIKE :WS-CODE-TRAN-TYPE2)      
              ORDER BY 1 DESC                                           
                                         
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE TRNS_HDR_RESP_AR CURSOR WITH ROWSET POSITIONING FOR        
MFA-TR*       SELECT  AR.TRANS_HIST_SEQ_NO                                      
MFA-TR*              ,AR.CODE_TRAN_TYPE                                         
MFA-TR*              ,AR.APPL_PROGRAM_ID                                        
MFA-TR*              ,AR.USER_ID                                                
MFA-TR*              ,AR.RESP_AREA_ID                                           
MFA-TR*              ,AR.TRAN_COMMENT                                           
MFA-TR*              ,AR.ACCOUNT_NO                                             
MFA-TR*              ,0                                                         
MFA-TR*              ,0                                                         
MFA-TR*              ,AR.AMT_ORIG_ENTERED                                       
MFA-TR*              ,AR.AMT_BILLED_UNPAID                                      
MFA-TR*              ,AR.RECORD_ONLY_FL                                         
MFA-TR*              ,AR.PYMT_REFUNDED_IND                                      
MFA-TR*              ,AR.CASH_LOCAL_OFFICE                                      
MFA-TR*              ,AR.CASH_REPORT_NO                                         
MFA-TR*              ,AR.DATE_CASH_REPORT                                       
MFA-TR*              ,IFNULL(AR.DATE_ORIG_PYMT,'1900-01-01')                    
MFA-TR*              ,AR.CASH_DRAWER_ID                                         
MFA-TR*              ,AR.PYMT_FACILITY_CD                                       
MFA-TR*              ,'AR'                                                      
MFA-TR*         FROM  CSS_AR_TRANS_HIST AR                                      
MFA-TR*        WHERE  AR.RESP_AREA_ID       = :AR-RESP-AREA-ID                  
MFA-TR*          AND  AR.DATE_TRANS        >= '1900-01-01'                      
MFA-TR*          AND  AR.TRANS_HIST_SEQ_NO >= :PARM-TRNS-HIST-FROM-TS           
MFA-TR*          AND  AR.TRANS_HIST_SEQ_NO  < :PARM-TRNS-HIST-TO-TS             
MFA-TR*          AND (AR.CODE_TRAN_TYPE  LIKE :WS-CODE-TRAN-TYPE1               
MFA-TR*           OR  AR.CODE_TRAN_TYPE  LIKE :WS-CODE-TRAN-TYPE2)              
MFA-TR*       ORDER BY 1 DESC                                                   
MFA-TR*       FETCH FIRST 21 ROWS ONLY WITH UR                                  
MFA-TR*       QUERYNO 7350                                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ****MAINTAIN TRANS HIST HDR DATA ONLY - RESP AREA ID & MH ONLY            
      *                                                                         
           EXEC SQL                                                     
             DECLARE TRNS_HDR_RESP_MH CURSOR WITH ROWSET POSITIONING FOR
              SELECT TOP(21) REPLACE(REPLACE(CONVERT(CHAR(26), 
           MH.TRANS_HIST_SEQ_NO, 121), ' ', '-'), ':', '.') 
           TRANS_HIST_SEQ_NO,
              MH.CODE_TRAN_TYPE,
              MH.APPL_PROGRAM_ID,
              MH.USER_ID,
              MH.RESP_AREA_ID,
              MH.TRAN_COMMENT,
              MH.ACCOUNT_NO,
              MH.CUSTOMER_NO,
              MH.PREMISE_NO,
              0,
              0,
              ' ',
              ' ',
              '   ',
              '   ',
              '1900-01-01',
              '1900-01-01',
              0,
              ' ',
              'MH'                                              
                FROM  CSS_MNT_TRANS_HIST MH WITH(READUNCOMMITTED)               
               WHERE  MH.RESP_AREA_ID       = :MH-RESP-AREA-ID          
                 AND  MH.DATE_TRANS        >= IIF(TRY_CONVERT(DATE, 
              '1900-01-01') IS NULL OR (PATINDEX('%.%', '1900-01-01'
              ) <> 0) OR (LEN('1900-01-01') <> 10), CIS.CHAR2DATE(
              '1900-01-01'), CONVERT(DATE, '1900-01-01') )              
                 AND  MH.TRANS_HIST_SEQ_NO >= CIS.CHAR2TIMESTAMP(
                                                :PARM-TRNS-HIST-FROM-TS
              )   
                 AND  MH.TRANS_HIST_SEQ_NO  < CIS.CHAR2TIMESTAMP(
                                                  :PARM-TRNS-HIST-TO-TS
              )     
                 AND (MH.CODE_TRAN_TYPE  LIKE :WS-CODE-TRAN-TYPE1       
                  OR  MH.CODE_TRAN_TYPE  LIKE :WS-CODE-TRAN-TYPE2)      
              ORDER BY 1 DESC                                           
                                         
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE TRNS_HDR_RESP_MH CURSOR WITH ROWSET POSITIONING FOR        
MFA-TR*       SELECT  MH.TRANS_HIST_SEQ_NO                                      
MFA-TR*              ,MH.CODE_TRAN_TYPE                                         
MFA-TR*              ,MH.APPL_PROGRAM_ID                                        
MFA-TR*              ,MH.USER_ID                                                
MFA-TR*              ,MH.RESP_AREA_ID                                           
MFA-TR*              ,MH.TRAN_COMMENT                                           
MFA-TR*              ,MH.ACCOUNT_NO                                             
MFA-TR*              ,MH.CUSTOMER_NO                                            
MFA-TR*              ,MH.PREMISE_NO                                             
MFA-TR*              ,0                                                         
MFA-TR*              ,0                                                         
MFA-TR*              ,' '                                                       
MFA-TR*              ,' '                                                       
MFA-TR*              ,'   '                                                     
MFA-TR*              ,'   '                                                     
MFA-TR*              ,'1900-01-01'                                              
MFA-TR*              ,'1900-01-01'                                              
MFA-TR*              ,0                                                         
MFA-TR*              ,' '                                                       
MFA-TR*              ,'MH'                                                      
MFA-TR*         FROM  CSS_MNT_TRANS_HIST MH                                     
MFA-TR*        WHERE  MH.RESP_AREA_ID       = :MH-RESP-AREA-ID                  
MFA-TR*          AND  MH.DATE_TRANS        >= '1900-01-01'                      
MFA-TR*          AND  MH.TRANS_HIST_SEQ_NO >= :PARM-TRNS-HIST-FROM-TS           
MFA-TR*          AND  MH.TRANS_HIST_SEQ_NO  < :PARM-TRNS-HIST-TO-TS             
MFA-TR*          AND (MH.CODE_TRAN_TYPE  LIKE :WS-CODE-TRAN-TYPE1               
MFA-TR*           OR  MH.CODE_TRAN_TYPE  LIKE :WS-CODE-TRAN-TYPE2)              
MFA-TR*       ORDER BY 1 DESC                                                   
MFA-TR*       FETCH FIRST 21 ROWS ONLY WITH UR                                  
MFA-TR*       QUERYNO 7400                                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ****ACCT RECV/MAINTAIN TRNS HIST HDR DATA-USER ID & ACCOUNT               
      *                                                                         
           EXEC SQL                                                     
             DECLARE  TRNS_HDR_UID_ACCT CURSOR                          
                                        WITH ROWSET POSITIONING FOR     
              SELECT TOP(21) MSQ020.*
               FROM (
                 SELECT  REPLACE(REPLACE(CONVERT(CHAR(26), 
           AR.TRANS_HIST_SEQ_NO, 121), ' ', '-'), ':', '.') 
           TRANS_HIST_SEQ_NO                              
                     ,AR.CODE_TRAN_TYPE                                 
                     ,AR.APPL_PROGRAM_ID                                
                     ,AR.USER_ID                                        
                     ,AR.RESP_AREA_ID                                   
                     ,AR.TRAN_COMMENT                                   
                     ,AR.ACCOUNT_NO                                     
                     ,0 MSQ020A8                                                
                     ,0 MSQ020A9                                                
                     ,AR.AMT_ORIG_ENTERED                               
                     ,AR.AMT_BILLED_UNPAID                              
                     ,AR.RECORD_ONLY_FL                                 
PRJ586               ,AR.PYMT_REFUNDED_IND                              
                     ,AR.CASH_LOCAL_OFFICE                              
                     ,AR.CASH_REPORT_NO                                 
                     ,AR.DATE_CASH_REPORT                               
                     ,COALESCE(AR.DATE_ORIG_PYMT,IIF(TRY_CONVERT(DATE, 
              '1900-01-01') IS NULL OR (PATINDEX('%.%', '1900-01-01'
              ) <> 0) OR (LEN('1900-01-01') <> 10), CIS.CHAR2DATE(
              '1900-01-01'), CONVERT(DATE, '1900-01-01') )) MSQ020A17          
                     ,AR.CASH_DRAWER_ID                                 
                     ,AR.PYMT_FACILITY_CD                               
                     ,'AR' MSQ020A20                                            
                FROM  CSS_AR_TRANS_HIST AR WITH(READUNCOMMITTED)                
               WHERE  AR.USER_ID            = :AR-USER-ID               
                 AND  AR.ACCOUNT_NO         = :AR-ACCOUNT-NO            
                 AND  AR.DATE_TRANS        >= IIF(TRY_CONVERT(DATE, 
              '1900-01-01') IS NULL OR (PATINDEX('%.%', '1900-01-01'
              ) <> 0) OR (LEN('1900-01-01') <> 10), CIS.CHAR2DATE(
              '1900-01-01'), CONVERT(DATE, '1900-01-01') )              
                 AND  AR.TRANS_HIST_SEQ_NO >= CIS.CHAR2TIMESTAMP(
                                                :PARM-TRNS-HIST-FROM-TS
              )   
                 AND  AR.TRANS_HIST_SEQ_NO  < CIS.CHAR2TIMESTAMP(
                                                  :PARM-TRNS-HIST-TO-TS
              )     
              UNION                                                     
              SELECT  REPLACE(REPLACE(CONVERT(CHAR(26), 
           MH.TRANS_HIST_SEQ_NO, 121), ' ', '-'), ':', '.') 
           TRANS_HIST_SEQ_NO                              
                     ,MH.CODE_TRAN_TYPE                                 
                     ,MH.APPL_PROGRAM_ID                                
                     ,MH.USER_ID                                        
                     ,MH.RESP_AREA_ID                                   
                     ,MH.TRAN_COMMENT                                   
                     ,MH.ACCOUNT_NO                                     
                     ,MH.CUSTOMER_NO                                    
                     ,MH.PREMISE_NO                                     
                     ,0                                                 
                     ,0                                                 
                     ,' '                                               
PRJ586               ,' '                                               
                     ,'   '                                             
                     ,'   '                                             
                     ,'1900-01-01'                                      
                     ,'1900-01-01'                                      
                     ,0                                                 
                     ,' '                                               
                     ,'MH'
            FROM  CSS_MNT_TRANS_HIST MH WITH(READUNCOMMITTED)
            WHERE  MH.USER_ID            = :MH-USER-ID               
                 AND  MH.ACCOUNT_NO         = :MH-ACCOUNT-NO            
                 AND  MH.DATE_TRANS        >= IIF(TRY_CONVERT(DATE, 
              '1900-01-01') IS NULL OR (PATINDEX('%.%', '1900-01-01'
              ) <> 0) OR (LEN('1900-01-01') <> 10), CIS.CHAR2DATE(
              '1900-01-01'), CONVERT(DATE, '1900-01-01') )              
                 AND  MH.TRANS_HIST_SEQ_NO >= CIS.CHAR2TIMESTAMP(
                                                :PARM-TRNS-HIST-FROM-TS
              )   
                 AND  MH.TRANS_HIST_SEQ_NO  < CIS.CHAR2TIMESTAMP(
                                                  :PARM-TRNS-HIST-TO-TS
              )
            
                        ) MSQ020
                 
                 
                 ORDER BY 1 DESC                                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE  TRNS_HDR_UID_ACCT CURSOR                                  
MFA-TR*                                 WITH ROWSET POSITIONING FOR             
MFA-TR*       SELECT  AR.TRANS_HIST_SEQ_NO                                      
MFA-TR*              ,AR.CODE_TRAN_TYPE                                         
MFA-TR*              ,AR.APPL_PROGRAM_ID                                        
MFA-TR*              ,AR.USER_ID                                                
MFA-TR*              ,AR.RESP_AREA_ID                                           
MFA-TR*              ,AR.TRAN_COMMENT                                           
MFA-TR*              ,AR.ACCOUNT_NO                                             
MFA-TR*              ,0                                                         
MFA-TR*              ,0                                                         
MFA-TR*              ,AR.AMT_ORIG_ENTERED                                       
MFA-TR*              ,AR.AMT_BILLED_UNPAID                                      
MFA-TR*              ,AR.RECORD_ONLY_FL                                         
MFA-TR*              ,AR.PYMT_REFUNDED_IND                                      
MFA-TR*              ,AR.CASH_LOCAL_OFFICE                                      
MFA-TR*              ,AR.CASH_REPORT_NO                                         
MFA-TR*              ,AR.DATE_CASH_REPORT                                       
MFA-TR*              ,IFNULL(AR.DATE_ORIG_PYMT,'1900-01-01')                    
MFA-TR*              ,AR.CASH_DRAWER_ID                                         
MFA-TR*              ,AR.PYMT_FACILITY_CD                                       
MFA-TR*              ,'AR'                                                      
MFA-TR*         FROM  CSS_AR_TRANS_HIST AR                                      
MFA-TR*        WHERE  AR.USER_ID            = :AR-USER-ID                       
MFA-TR*          AND  AR.ACCOUNT_NO         = :AR-ACCOUNT-NO                    
MFA-TR*          AND  AR.DATE_TRANS        >= '1900-01-01'                      
MFA-TR*          AND  AR.TRANS_HIST_SEQ_NO >= :PARM-TRNS-HIST-FROM-TS           
MFA-TR*          AND  AR.TRANS_HIST_SEQ_NO  < :PARM-TRNS-HIST-TO-TS             
MFA-TR*       UNION                                                             
MFA-TR*       SELECT  MH.TRANS_HIST_SEQ_NO                                      
MFA-TR*              ,MH.CODE_TRAN_TYPE                                         
MFA-TR*              ,MH.APPL_PROGRAM_ID                                        
MFA-TR*              ,MH.USER_ID                                                
MFA-TR*              ,MH.RESP_AREA_ID                                           
MFA-TR*              ,MH.TRAN_COMMENT                                           
MFA-TR*              ,MH.ACCOUNT_NO                                             
MFA-TR*              ,MH.CUSTOMER_NO                                            
MFA-TR*              ,MH.PREMISE_NO                                             
MFA-TR*              ,0                                                         
MFA-TR*              ,0                                                         
MFA-TR*              ,' '                                                       
MFA-TR*              ,' '                                                       
MFA-TR*              ,'   '                                                     
MFA-TR*              ,'   '                                                     
MFA-TR*              ,'1900-01-01'                                              
MFA-TR*              ,'1900-01-01'                                              
MFA-TR*              ,0                                                         
MFA-TR*              ,' '                                                       
MFA-TR*              ,'MH'                                                      
MFA-TR*         FROM  CSS_MNT_TRANS_HIST MH                                     
MFA-TR*        WHERE  MH.USER_ID            = :MH-USER-ID                       
MFA-TR*          AND  MH.ACCOUNT_NO         = :MH-ACCOUNT-NO                    
MFA-TR*          AND  MH.DATE_TRANS        >= '1900-01-01'                      
MFA-TR*          AND  MH.TRANS_HIST_SEQ_NO >= :PARM-TRNS-HIST-FROM-TS           
MFA-TR*          AND  MH.TRANS_HIST_SEQ_NO  < :PARM-TRNS-HIST-TO-TS             
MFA-TR*       ORDER BY 1 DESC                                                   
MFA-TR*       FETCH FIRST 21 ROWS ONLY WITH UR                                  
MFA-TR*       QUERYNO 7450                                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ****ACCT RECV/MAINTAIN TRNS HIST HDR DATA-USER ID                         
      *                                                                         
           EXEC SQL                                                     
             DECLARE  TRNS_HDR_UID CURSOR WITH ROWSET POSITIONING FOR   
              SELECT TOP(21) MSQ020.*
               FROM (
                 SELECT  REPLACE(REPLACE(CONVERT(CHAR(26), 
           AR.TRANS_HIST_SEQ_NO, 121), ' ', '-'), ':', '.') 
           TRANS_HIST_SEQ_NO                              
                     ,AR.CODE_TRAN_TYPE                                 
                     ,AR.APPL_PROGRAM_ID                                
                     ,AR.USER_ID                                        
                     ,AR.RESP_AREA_ID                                   
                     ,AR.TRAN_COMMENT                                   
                     ,AR.ACCOUNT_NO                                     
                     ,0 MSQ020A8                                                
                     ,0 MSQ020A9                                                
                     ,AR.AMT_ORIG_ENTERED                               
                     ,AR.AMT_BILLED_UNPAID                              
                     ,AR.RECORD_ONLY_FL                                 
PRJ586               ,AR.PYMT_REFUNDED_IND                              
                     ,AR.CASH_LOCAL_OFFICE                              
                     ,AR.CASH_REPORT_NO                                 
                     ,AR.DATE_CASH_REPORT                               
                     ,COALESCE(AR.DATE_ORIG_PYMT,IIF(TRY_CONVERT(DATE, 
              '1900-01-01') IS NULL OR (PATINDEX('%.%', '1900-01-01'
              ) <> 0) OR (LEN('1900-01-01') <> 10), CIS.CHAR2DATE(
              '1900-01-01'), CONVERT(DATE, '1900-01-01') )) MSQ020A17          
                     ,AR.CASH_DRAWER_ID                                 
                     ,AR.PYMT_FACILITY_CD                               
                     ,'AR' MSQ020A20                                            
                FROM  CSS_AR_TRANS_HIST AR WITH(READUNCOMMITTED)                
               WHERE  AR.USER_ID            = :AR-USER-ID               
                 AND  AR.DATE_TRANS        >= IIF(TRY_CONVERT(DATE, 
              '1900-01-01') IS NULL OR (PATINDEX('%.%', '1900-01-01'
              ) <> 0) OR (LEN('1900-01-01') <> 10), CIS.CHAR2DATE(
              '1900-01-01'), CONVERT(DATE, '1900-01-01') )              
                 AND  AR.TRANS_HIST_SEQ_NO >= CIS.CHAR2TIMESTAMP(
                                                :PARM-TRNS-HIST-FROM-TS
              )   
                 AND  AR.TRANS_HIST_SEQ_NO  < CIS.CHAR2TIMESTAMP(
                                                  :PARM-TRNS-HIST-TO-TS
              )     
                 AND (AR.CODE_TRAN_TYPE  LIKE :WS-CODE-TRAN-TYPE1       
                  OR  AR.CODE_TRAN_TYPE  LIKE :WS-CODE-TRAN-TYPE2)      
              UNION                                                     
              SELECT  REPLACE(REPLACE(CONVERT(CHAR(26), 
           MH.TRANS_HIST_SEQ_NO, 121), ' ', '-'), ':', '.') 
           TRANS_HIST_SEQ_NO                              
                     ,MH.CODE_TRAN_TYPE                                 
                     ,MH.APPL_PROGRAM_ID                                
                     ,MH.USER_ID                                        
                     ,MH.RESP_AREA_ID                                   
                     ,MH.TRAN_COMMENT                                   
                     ,MH.ACCOUNT_NO                                     
                     ,MH.CUSTOMER_NO                                    
                     ,MH.PREMISE_NO                                     
                     ,0                                                 
                     ,0                                                 
                     ,' '                                               
                     ,' '                                               
                     ,'   '                                             
                     ,'   '                                             
                     ,'1900-01-01'                                      
                     ,'1900-01-01'                                      
                     ,0                                                 
                     ,' '                                               
                     ,'MH'
            FROM  CSS_MNT_TRANS_HIST MH WITH(READUNCOMMITTED)
            WHERE  MH.USER_ID            = :MH-USER-ID               
                 AND  MH.DATE_TRANS        >= IIF(TRY_CONVERT(DATE, 
              '1900-01-01') IS NULL OR (PATINDEX('%.%', '1900-01-01'
              ) <> 0) OR (LEN('1900-01-01') <> 10), CIS.CHAR2DATE(
              '1900-01-01'), CONVERT(DATE, '1900-01-01') )              
                 AND  MH.TRANS_HIST_SEQ_NO >= CIS.CHAR2TIMESTAMP(
                                                :PARM-TRNS-HIST-FROM-TS
              )   
                 AND  MH.TRANS_HIST_SEQ_NO  < CIS.CHAR2TIMESTAMP(
                                                  :PARM-TRNS-HIST-TO-TS
              )     
                 AND (MH.CODE_TRAN_TYPE  LIKE :WS-CODE-TRAN-TYPE1       
                  OR  MH.CODE_TRAN_TYPE  LIKE :WS-CODE-TRAN-TYPE2)
            
                        ) MSQ020
                 
                 
                 ORDER BY 1 DESC                                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE  TRNS_HDR_UID CURSOR WITH ROWSET POSITIONING FOR           
MFA-TR*       SELECT  AR.TRANS_HIST_SEQ_NO                                      
MFA-TR*              ,AR.CODE_TRAN_TYPE                                         
MFA-TR*              ,AR.APPL_PROGRAM_ID                                        
MFA-TR*              ,AR.USER_ID                                                
MFA-TR*              ,AR.RESP_AREA_ID                                           
MFA-TR*              ,AR.TRAN_COMMENT                                           
MFA-TR*              ,AR.ACCOUNT_NO                                             
MFA-TR*              ,0                                                         
MFA-TR*              ,0                                                         
MFA-TR*              ,AR.AMT_ORIG_ENTERED                                       
MFA-TR*              ,AR.AMT_BILLED_UNPAID                                      
MFA-TR*              ,AR.RECORD_ONLY_FL                                         
MFA-TR*              ,AR.PYMT_REFUNDED_IND                                      
MFA-TR*              ,AR.CASH_LOCAL_OFFICE                                      
MFA-TR*              ,AR.CASH_REPORT_NO                                         
MFA-TR*              ,AR.DATE_CASH_REPORT                                       
MFA-TR*              ,IFNULL(AR.DATE_ORIG_PYMT,'1900-01-01')                    
MFA-TR*              ,AR.CASH_DRAWER_ID                                         
MFA-TR*              ,AR.PYMT_FACILITY_CD                                       
MFA-TR*              ,'AR'                                                      
MFA-TR*         FROM  CSS_AR_TRANS_HIST AR                                      
MFA-TR*        WHERE  AR.USER_ID            = :AR-USER-ID                       
MFA-TR*          AND  AR.DATE_TRANS        >= '1900-01-01'                      
MFA-TR*          AND  AR.TRANS_HIST_SEQ_NO >= :PARM-TRNS-HIST-FROM-TS           
MFA-TR*          AND  AR.TRANS_HIST_SEQ_NO  < :PARM-TRNS-HIST-TO-TS             
MFA-TR*          AND (AR.CODE_TRAN_TYPE  LIKE :WS-CODE-TRAN-TYPE1               
MFA-TR*           OR  AR.CODE_TRAN_TYPE  LIKE :WS-CODE-TRAN-TYPE2)              
MFA-TR*       UNION                                                             
MFA-TR*       SELECT  MH.TRANS_HIST_SEQ_NO                                      
MFA-TR*              ,MH.CODE_TRAN_TYPE                                         
MFA-TR*              ,MH.APPL_PROGRAM_ID                                        
MFA-TR*              ,MH.USER_ID                                                
MFA-TR*              ,MH.RESP_AREA_ID                                           
MFA-TR*              ,MH.TRAN_COMMENT                                           
MFA-TR*              ,MH.ACCOUNT_NO                                             
MFA-TR*              ,MH.CUSTOMER_NO                                            
MFA-TR*              ,MH.PREMISE_NO                                             
MFA-TR*              ,0                                                         
MFA-TR*              ,0                                                         
MFA-TR*              ,' '                                                       
MFA-TR*              ,' '                                                       
MFA-TR*              ,'   '                                                     
MFA-TR*              ,'   '                                                     
MFA-TR*              ,'1900-01-01'                                              
MFA-TR*              ,'1900-01-01'                                              
MFA-TR*              ,0                                                         
MFA-TR*              ,' '                                                       
MFA-TR*              ,'MH'                                                      
MFA-TR*         FROM  CSS_MNT_TRANS_HIST MH                                     
MFA-TR*        WHERE  MH.USER_ID            = :MH-USER-ID                       
MFA-TR*          AND  MH.DATE_TRANS        >= '1900-01-01'                      
MFA-TR*          AND  MH.TRANS_HIST_SEQ_NO >= :PARM-TRNS-HIST-FROM-TS           
MFA-TR*          AND  MH.TRANS_HIST_SEQ_NO  < :PARM-TRNS-HIST-TO-TS             
MFA-TR*          AND (MH.CODE_TRAN_TYPE  LIKE :WS-CODE-TRAN-TYPE1               
MFA-TR*           OR  MH.CODE_TRAN_TYPE  LIKE :WS-CODE-TRAN-TYPE2)              
MFA-TR*       ORDER BY 1 DESC                                                   
MFA-TR*       FETCH FIRST 21 ROWS ONLY WITH UR                                  
MFA-TR*       QUERYNO 7500                                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ****ACCT RECV TRANS HIST HDR DATA ONLY-USER ID & AR ONLY                  
      *                                                                         
           EXEC SQL                                                     
             DECLARE TRNS_HDR_UID_AR CURSOR WITH ROWSET POSITIONING FOR 
              SELECT TOP(21) REPLACE(REPLACE(CONVERT(CHAR(26), 
           AR.TRANS_HIST_SEQ_NO, 121), ' ', '-'), ':', '.') 
           TRANS_HIST_SEQ_NO,
              AR.CODE_TRAN_TYPE,
              AR.APPL_PROGRAM_ID,
              AR.USER_ID,
              AR.RESP_AREA_ID,
              AR.TRAN_COMMENT,
              AR.ACCOUNT_NO,
              0,
              0,
              AR.AMT_ORIG_ENTERED,
              AR.AMT_BILLED_UNPAID,
              AR.RECORD_ONLY_FL,
              AR.PYMT_REFUNDED_IND,
              AR.CASH_LOCAL_OFFICE,
              AR.CASH_REPORT_NO,
              AR.DATE_CASH_REPORT,
              COALESCE(AR.DATE_ORIG_PYMT,IIF(TRY_CONVERT(DATE, 
              '1900-01-01') IS NULL OR (PATINDEX('%.%', '1900-01-01'
              ) <> 0) OR (LEN('1900-01-01') <> 10), CIS.CHAR2DATE(
              '1900-01-01'), CONVERT(DATE, '1900-01-01') )),
              AR.CASH_DRAWER_ID,
              AR.PYMT_FACILITY_CD,
              'AR'                                              
                FROM  CSS_AR_TRANS_HIST AR WITH(READUNCOMMITTED)                
               WHERE  AR.USER_ID            = :AR-USER-ID               
                 AND  AR.DATE_TRANS        >= IIF(TRY_CONVERT(DATE, 
              '1900-01-01') IS NULL OR (PATINDEX('%.%', '1900-01-01'
              ) <> 0) OR (LEN('1900-01-01') <> 10), CIS.CHAR2DATE(
              '1900-01-01'), CONVERT(DATE, '1900-01-01') )              
                 AND  AR.TRANS_HIST_SEQ_NO >= CIS.CHAR2TIMESTAMP(
                                                :PARM-TRNS-HIST-FROM-TS
              )   
                 AND  AR.TRANS_HIST_SEQ_NO  < CIS.CHAR2TIMESTAMP(
                                                  :PARM-TRNS-HIST-TO-TS
              )     
                 AND (AR.CODE_TRAN_TYPE  LIKE :WS-CODE-TRAN-TYPE1       
                  OR  AR.CODE_TRAN_TYPE  LIKE :WS-CODE-TRAN-TYPE2)      
              ORDER BY 1 DESC                                           
                                         
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE TRNS_HDR_UID_AR CURSOR WITH ROWSET POSITIONING FOR         
MFA-TR*       SELECT  AR.TRANS_HIST_SEQ_NO                                      
MFA-TR*              ,AR.CODE_TRAN_TYPE                                         
MFA-TR*              ,AR.APPL_PROGRAM_ID                                        
MFA-TR*              ,AR.USER_ID                                                
MFA-TR*              ,AR.RESP_AREA_ID                                           
MFA-TR*              ,AR.TRAN_COMMENT                                           
MFA-TR*              ,AR.ACCOUNT_NO                                             
MFA-TR*              ,0                                                         
MFA-TR*              ,0                                                         
MFA-TR*              ,AR.AMT_ORIG_ENTERED                                       
MFA-TR*              ,AR.AMT_BILLED_UNPAID                                      
MFA-TR*              ,AR.RECORD_ONLY_FL                                         
MFA-TR*              ,AR.PYMT_REFUNDED_IND                                      
MFA-TR*              ,AR.CASH_LOCAL_OFFICE                                      
MFA-TR*              ,AR.CASH_REPORT_NO                                         
MFA-TR*              ,AR.DATE_CASH_REPORT                                       
MFA-TR*              ,IFNULL(AR.DATE_ORIG_PYMT,'1900-01-01')                    
MFA-TR*              ,AR.CASH_DRAWER_ID                                         
MFA-TR*              ,AR.PYMT_FACILITY_CD                                       
MFA-TR*              ,'AR'                                                      
MFA-TR*         FROM  CSS_AR_TRANS_HIST AR                                      
MFA-TR*        WHERE  AR.USER_ID            = :AR-USER-ID                       
MFA-TR*          AND  AR.DATE_TRANS        >= '1900-01-01'                      
MFA-TR*          AND  AR.TRANS_HIST_SEQ_NO >= :PARM-TRNS-HIST-FROM-TS           
MFA-TR*          AND  AR.TRANS_HIST_SEQ_NO  < :PARM-TRNS-HIST-TO-TS             
MFA-TR*          AND (AR.CODE_TRAN_TYPE  LIKE :WS-CODE-TRAN-TYPE1               
MFA-TR*           OR  AR.CODE_TRAN_TYPE  LIKE :WS-CODE-TRAN-TYPE2)              
MFA-TR*       ORDER BY 1 DESC                                                   
MFA-TR*       FETCH FIRST 21 ROWS ONLY WITH UR                                  
MFA-TR*       QUERYNO 7550                                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ****MAINTAIN TRANS HIST HDR DATA ONLY-USER ID & MH                        
      *                                                                         
           EXEC SQL                                                     
             DECLARE TRNS_HDR_UID_MH CURSOR WITH ROWSET POSITIONING FOR 
              SELECT TOP(21) REPLACE(REPLACE(CONVERT(CHAR(26), 
           MH.TRANS_HIST_SEQ_NO, 121), ' ', '-'), ':', '.') 
           TRANS_HIST_SEQ_NO,
              MH.CODE_TRAN_TYPE,
              MH.APPL_PROGRAM_ID,
              MH.USER_ID,
              MH.RESP_AREA_ID,
              MH.TRAN_COMMENT,
              MH.ACCOUNT_NO,
              MH.CUSTOMER_NO,
              MH.PREMISE_NO,
              0,
              0,
              ' ',
              ' ',
              '   ',
              '   ',
              '1900-01-01',
              '1900-01-01',
              0,
              ' ',
              'MH'                                              
                FROM  CSS_MNT_TRANS_HIST MH WITH(READUNCOMMITTED)               
               WHERE  MH.USER_ID            = :MH-USER-ID               
                 AND  MH.DATE_TRANS        >= IIF(TRY_CONVERT(DATE, 
              '1900-01-01') IS NULL OR (PATINDEX('%.%', '1900-01-01'
              ) <> 0) OR (LEN('1900-01-01') <> 10), CIS.CHAR2DATE(
              '1900-01-01'), CONVERT(DATE, '1900-01-01') )              
                 AND  MH.TRANS_HIST_SEQ_NO >= CIS.CHAR2TIMESTAMP(
                                                :PARM-TRNS-HIST-FROM-TS
              )   
                 AND  MH.TRANS_HIST_SEQ_NO  < CIS.CHAR2TIMESTAMP(
                                                  :PARM-TRNS-HIST-TO-TS
              )     
                 AND (MH.CODE_TRAN_TYPE  LIKE :WS-CODE-TRAN-TYPE1       
                  OR  MH.CODE_TRAN_TYPE  LIKE :WS-CODE-TRAN-TYPE2)      
              ORDER BY 1 DESC                                           
                                         
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE TRNS_HDR_UID_MH CURSOR WITH ROWSET POSITIONING FOR         
MFA-TR*       SELECT  MH.TRANS_HIST_SEQ_NO                                      
MFA-TR*              ,MH.CODE_TRAN_TYPE                                         
MFA-TR*              ,MH.APPL_PROGRAM_ID                                        
MFA-TR*              ,MH.USER_ID                                                
MFA-TR*              ,MH.RESP_AREA_ID                                           
MFA-TR*              ,MH.TRAN_COMMENT                                           
MFA-TR*              ,MH.ACCOUNT_NO                                             
MFA-TR*              ,MH.CUSTOMER_NO                                            
MFA-TR*              ,MH.PREMISE_NO                                             
MFA-TR*              ,0                                                         
MFA-TR*              ,0                                                         
MFA-TR*              ,' '                                                       
MFA-TR*              ,' '                                                       
MFA-TR*              ,'   '                                                     
MFA-TR*              ,'   '                                                     
MFA-TR*              ,'1900-01-01'                                              
MFA-TR*              ,'1900-01-01'                                              
MFA-TR*              ,0                                                         
MFA-TR*              ,' '                                                       
MFA-TR*              ,'MH'                                                      
MFA-TR*         FROM  CSS_MNT_TRANS_HIST MH                                     
MFA-TR*        WHERE  MH.USER_ID            = :MH-USER-ID                       
MFA-TR*          AND  MH.DATE_TRANS        >= '1900-01-01'                      
MFA-TR*          AND  MH.TRANS_HIST_SEQ_NO >= :PARM-TRNS-HIST-FROM-TS           
MFA-TR*          AND  MH.TRANS_HIST_SEQ_NO  < :PARM-TRNS-HIST-TO-TS             
MFA-TR*          AND (MH.CODE_TRAN_TYPE  LIKE :WS-CODE-TRAN-TYPE1               
MFA-TR*           OR  MH.CODE_TRAN_TYPE  LIKE :WS-CODE-TRAN-TYPE2)              
MFA-TR*       ORDER BY 1 DESC                                                   
MFA-TR*       FETCH FIRST 21 ROWS ONLY WITH UR                                  
MFA-TR*       QUERYNO 7600                                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ****MAINTAIN TRNS HIST HDR DATA-USER ID & CUSTOMER                        
      *                                                                         
           EXEC SQL                                                     
             DECLARE  TRNS_HDR_UID_CUST CURSOR                          
                                        WITH ROWSET POSITIONING FOR     
              SELECT TOP(21) REPLACE(REPLACE(CONVERT(CHAR(26), 
           MH.TRANS_HIST_SEQ_NO, 121), ' ', '-'), ':', '.') 
           TRANS_HIST_SEQ_NO,
              MH.CODE_TRAN_TYPE,
              MH.APPL_PROGRAM_ID,
              MH.USER_ID,
              MH.RESP_AREA_ID,
              MH.TRAN_COMMENT,
              MH.ACCOUNT_NO,
              MH.CUSTOMER_NO,
              MH.PREMISE_NO,
              'MH'                                              
                FROM  CSS_MNT_TRANS_HIST MH WITH(READUNCOMMITTED)               
               WHERE  MH.USER_ID            = :MH-USER-ID               
                 AND  MH.CUSTOMER_NO        = :MH-CUSTOMER-NO           
                 AND  MH.DATE_TRANS        >= IIF(TRY_CONVERT(DATE, 
              '1900-01-01') IS NULL OR (PATINDEX('%.%', '1900-01-01'
              ) <> 0) OR (LEN('1900-01-01') <> 10), CIS.CHAR2DATE(
              '1900-01-01'), CONVERT(DATE, '1900-01-01') )              
                 AND  MH.TRANS_HIST_SEQ_NO >= CIS.CHAR2TIMESTAMP(
                                                :PARM-TRNS-HIST-FROM-TS
              )   
                 AND  MH.TRANS_HIST_SEQ_NO  < CIS.CHAR2TIMESTAMP(
                                                  :PARM-TRNS-HIST-TO-TS
              )     
              ORDER BY 1 DESC                                           
                                         
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE  TRNS_HDR_UID_CUST CURSOR                                  
MFA-TR*                                 WITH ROWSET POSITIONING FOR             
MFA-TR*       SELECT  MH.TRANS_HIST_SEQ_NO                                      
MFA-TR*              ,MH.CODE_TRAN_TYPE                                         
MFA-TR*              ,MH.APPL_PROGRAM_ID                                        
MFA-TR*              ,MH.USER_ID                                                
MFA-TR*              ,MH.RESP_AREA_ID                                           
MFA-TR*              ,MH.TRAN_COMMENT                                           
MFA-TR*              ,MH.ACCOUNT_NO                                             
MFA-TR*              ,MH.CUSTOMER_NO                                            
MFA-TR*              ,MH.PREMISE_NO                                             
MFA-TR*              ,'MH'                                                      
MFA-TR*         FROM  CSS_MNT_TRANS_HIST MH                                     
MFA-TR*        WHERE  MH.USER_ID            = :MH-USER-ID                       
MFA-TR*          AND  MH.CUSTOMER_NO        = :MH-CUSTOMER-NO                   
MFA-TR*          AND  MH.DATE_TRANS        >= '1900-01-01'                      
MFA-TR*          AND  MH.TRANS_HIST_SEQ_NO >= :PARM-TRNS-HIST-FROM-TS           
MFA-TR*          AND  MH.TRANS_HIST_SEQ_NO  < :PARM-TRNS-HIST-TO-TS             
MFA-TR*       ORDER BY 1 DESC                                                   
MFA-TR*       FETCH FIRST 21 ROWS ONLY WITH UR                                  
MFA-TR*       QUERYNO 7650                                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      **** ACCT RECV TRNS HIST DETAILS                                          
      *                                                                         
           EXEC SQL                                                     
             DECLARE  ACCT_RECV_DET CURSOR FOR                          
              SELECT  AU.CODE_AR_AGE                                    
                     ,AU.GL_ACCT_CREDIT                                 
                     ,AU.GL_ACCT_DEBIT                                  
                     ,AU.AMT_POSTED                                     
                     ,AU.ITEM_ID                                        
                     ,AU.CODE_CONTRACT_TYPE                             
                     ,AU.CURRENCY_TYPE                                  
                FROM  CSS_AR_TRN_HST_DET AU WITH(READUNCOMMITTED)               
               WHERE  AU.ACCOUNT_NO         = :AU-ACCOUNT-NO            
                 AND  AU.TRANS_HIST_SEQ_NO  = CIS.CHAR2TIMESTAMP(
                                                  :AU-TRANS-HIST-SEQ-NO
              )     
              FOR READ ONLY                                     
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE  ACCT_RECV_DET CURSOR FOR                                  
MFA-TR*       SELECT  AU.CODE_AR_AGE                                            
MFA-TR*              ,AU.GL_ACCT_CREDIT                                         
MFA-TR*              ,AU.GL_ACCT_DEBIT                                          
MFA-TR*              ,AU.AMT_POSTED                                             
MFA-TR*              ,AU.ITEM_ID                                                
MFA-TR*              ,AU.CODE_CONTRACT_TYPE                                     
MFA-TR*              ,AU.CURRENCY_TYPE                                          
MFA-TR*         FROM  CSS_AR_TRN_HST_DET AU                                     
MFA-TR*        WHERE  AU.ACCOUNT_NO         = :AU-ACCOUNT-NO                    
MFA-TR*          AND  AU.TRANS_HIST_SEQ_NO  = :AU-TRANS-HIST-SEQ-NO             
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*       QUERYNO 7800                                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      **** MAINTAIN TRNS HIST DETAILS                                           
      *                                                                         
           EXEC SQL                                                     
             DECLARE  MNTN_TRNS_DET CURSOR FOR                          
              SELECT  MI.COLUMN_DESC                                    
                     ,MI.TABLE_ID                                       
                     ,MI.PRV_COLUMN_VALUE                               
                     ,MI.CHG_COLUMN_VALUE                               
                FROM  CSS_MT_TRN_HST_DET MI WITH(READUNCOMMITTED)               
               WHERE  MI.TRANS_HIST_SEQ_NO  = CIS.CHAR2TIMESTAMP(
                                                  :MI-TRANS-HIST-SEQ-NO
              )     
              FOR READ ONLY                                     
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE  MNTN_TRNS_DET CURSOR FOR                                  
MFA-TR*       SELECT  MI.COLUMN_DESC                                            
MFA-TR*              ,MI.TABLE_ID                                               
MFA-TR*              ,MI.PRV_COLUMN_VALUE                                       
MFA-TR*              ,MI.CHG_COLUMN_VALUE                                       
MFA-TR*         FROM  CSS_MT_TRN_HST_DET MI                                     
MFA-TR*        WHERE  MI.TRANS_HIST_SEQ_NO  = :MI-TRANS-HIST-SEQ-NO             
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*       QUERYNO 7900                                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       LINKAGE SECTION.                                                 
      *                                                                         
       01  LINK-CALL-TYPE           PIC X(01).                          
       01  LINK-ACCOUNT-NO          PIC X(13).                          
       01  LINK-CUSTOMER-NO         PIC X(10).                          
       01  LINK-PREMISE-NO          PIC X(10).                          
       01  LINK-RESP-AREA-ID        PIC X(03).                          
       01  LINK-USER-ID             PIC X(07).                          
       01  LINK-CODE-TRAN-TYPE      PIC X(01).                          
       01  LINK-TRNS-HIST-FROM-TS   PIC X(26).                          
       01  LINK-TRNS-HIST-TO-TS     PIC X(26).                          
       01  LINK-COMPANY-NO          PIC X(02).                          
       01  LINK-NAVIG-PATH          PIC X(03).                          
       01  LINK-CSR-USER-ID         PIC X(07).                          
      *                                                                         
       PROCEDURE DIVISION USING  LINK-CALL-TYPE                         
                                ,LINK-ACCOUNT-NO                        
                                ,LINK-CUSTOMER-NO                       
                                ,LINK-PREMISE-NO                        
                                ,LINK-RESP-AREA-ID                      
                                ,LINK-USER-ID                           
                                ,LINK-CODE-TRAN-TYPE                    
                                ,LINK-TRNS-HIST-FROM-TS                 
                                ,LINK-TRNS-HIST-TO-TS                   
                                ,LINK-COMPANY-NO                        
                                ,LINK-NAVIG-PATH                        
                                ,LINK-CSR-USER-ID.                      
      *                                                                         
      ******************************************************************        
      **   CONTROLS THE MAIN PATH OF THE PROGRAM                      **        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE           THRU  0100-EXIT.           
           PERFORM 1000-PROCESS-INPUT        THRU  1000-EXIT.           
           PERFORM 2000-PROCESS-OUTPUT       THRU  2000-EXIT.           
           PERFORM 2900-VLDT-NOTFOUND-RES    THRU  2900-EXIT.           
           PERFORM 9999-END-PROGRAM          THRU  9999-EXIT.           
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** INITIALIZE REQUIRED VARIABLES                                **        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           MOVE '0100'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           INITIALIZE                        GTT-RETURN-FIELDS          
                                             WS-HDR-ARRAY.              
      *                                                                         
           PERFORM 0100A-DECLARE-GTT-HDR     THRU  0100A-EXIT.          
           PERFORM 0100B-DECLARE-GTT-ACR     THRU  0100B-EXIT.          
           PERFORM 0100C-DECLARE-GTT-MNT     THRU  0100C-EXIT.          
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** DECLARE GLOBAL TEMPORARY TABLE - HEADER                      **        
      ******************************************************************        
      *                                                                         
       0100A-DECLARE-GTT-HDR.                                           
      *                                                                         
           MOVE                                                         
           'DECLARE GLOBAL TEMPORARY TABLE CSR04682_HDR'                
                                             TO S-SQL-STATEMENT-V.      
      *                                                                         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04682_HDR')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04682_HDR
              (                                                    
                       RETURN_CODE            INT                   
                      ,TRANS_HIST_SEQ_NO CHAR(26)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,CODE_TRAN_TYPE CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,APPL_PROGRAM_DESC CHAR(20)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,EMPLOYEE_NAME CHAR(40)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,RESP_AREA_ID CHAR(03)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,TRAN_COMMENT CHAR(210)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                 
                      ,ACCOUNT_NO             DECIMAL(13,0)            
                      ,CUSTOMER_NO            DECIMAL(10,0)            
                      ,PREMISE_NO             DECIMAL(10,0)            
                      ,AMT_ORIG_ENTERED       DECIMAL(11,2)            
                      ,AMT_BILLED_UNPAID      DECIMAL(11,2)            
                      ,RECORD_ONLY_FL CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
PRJ586                ,PYMT_REFUNDED_IND CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,CASH_LOCAL_OFFICE CHAR(29)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,DATE_CASH_REPORT CHAR(10)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,DATE_ORIG_PYMT CHAR(08)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,DRAWER_ID              SMALLINT                  
                      ,DRAWER_STATUS CHAR(08)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,PYMT_FACILITY_CD CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,PYMT_FACILITY_DESC CHAR(20)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,TABLE_CD CHAR(02)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,MORE_DATA_AVLB_FL CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,FULL_NAME CHAR(70)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,ADDRESS_LINE_1 CHAR(75)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,ADDRESS_LINE_2 CHAR(35)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                   )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF SQLSTATE = '42710'                                        
              PERFORM 8000A-DELETE-GTT-ROWS-HDR THRU 8000A-EXIT         
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  CONTINUE                                              
               ELSE                                                     
                  MOVE PROGRAM-NAME          TO ABEND-PROGRAM           
                  MOVE SQLCODE               TO ABEND-SQLCODE           
                  MOVE SQLSTATE              TO ABEND-SQLSTATE          
                  MOVE '0100A'               TO ACTIVE-PARAGRAPH        
                  MOVE 'DECLARE GTT'         TO ABEND-FUNCTION          
                  MOVE SPACES                TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                  MOVE 'CSR04682_HDR'        TO TABLE-1                 
                  MOVE SPACES                TO TABLE-ELEMENT-1         
                  MOVE SPACES                TO HOSTVAR-ELEMENT-1       
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                       WITH ROWSET POSITIONING FOR                      
               SELECT  RETURN_CODE                                      
                      ,TRANS_HIST_SEQ_NO                                
                      ,CODE_TRAN_TYPE                                   
                      ,APPL_PROGRAM_DESC                                
                      ,EMPLOYEE_NAME                                    
                      ,RESP_AREA_ID                                     
                      ,TRAN_COMMENT                                     
                      ,ACCOUNT_NO                                       
                      ,CUSTOMER_NO                                      
                      ,PREMISE_NO                                       
                      ,AMT_ORIG_ENTERED                                 
                      ,AMT_BILLED_UNPAID                                
                      ,RECORD_ONLY_FL                                   
PRJ586                ,PYMT_REFUNDED_IND                                
                      ,CASH_LOCAL_OFFICE                                
                      ,DATE_CASH_REPORT                                 
                      ,DATE_ORIG_PYMT                                   
                      ,DRAWER_ID                                        
                      ,DRAWER_STATUS                                    
                      ,PYMT_FACILITY_CD                                 
                      ,PYMT_FACILITY_DESC                               
                      ,TABLE_CD                                         
                      ,MORE_DATA_AVLB_FL                                
                      ,FULL_NAME                                        
                      ,ADDRESS_LINE_1                                   
                      ,ADDRESS_LINE_2                                   
               FROM #CSR04682_HDR                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                WITH ROWSET POSITIONING FOR                              
MFA-TR*        SELECT  RETURN_CODE                                              
MFA-TR*               ,TRANS_HIST_SEQ_NO                                        
MFA-TR*               ,CODE_TRAN_TYPE                                           
MFA-TR*               ,APPL_PROGRAM_DESC                                        
MFA-TR*               ,EMPLOYEE_NAME                                            
MFA-TR*               ,RESP_AREA_ID                                             
MFA-TR*               ,TRAN_COMMENT                                             
MFA-TR*               ,ACCOUNT_NO                                               
MFA-TR*               ,CUSTOMER_NO                                              
MFA-TR*               ,PREMISE_NO                                               
MFA-TR*               ,AMT_ORIG_ENTERED                                         
MFA-TR*               ,AMT_BILLED_UNPAID                                        
MFA-TR*               ,RECORD_ONLY_FL                                           
MFA-TR*               ,PYMT_REFUNDED_IND                                        
MFA-TR*               ,CASH_LOCAL_OFFICE                                        
MFA-TR*               ,DATE_CASH_REPORT                                         
MFA-TR*               ,DATE_ORIG_PYMT                                           
MFA-TR*               ,DRAWER_ID                                                
MFA-TR*               ,DRAWER_STATUS                                            
MFA-TR*               ,PYMT_FACILITY_CD                                         
MFA-TR*               ,PYMT_FACILITY_DESC                                       
MFA-TR*               ,TABLE_CD                                                 
MFA-TR*               ,MORE_DATA_AVLB_FL                                        
MFA-TR*               ,FULL_NAME                                                
MFA-TR*               ,ADDRESS_LINE_1                                           
MFA-TR*               ,ADDRESS_LINE_2                                           
MFA-TR*        FROM SESSION.CSR04682_HDR                                        
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0100A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** DECLARE GLOBAL TEMPORARY TABLE - ACCT RECV TRNS HIST DETAILS **        
      ******************************************************************        
      *                                                                         
       0100B-DECLARE-GTT-ACR.                                           
      *                                                                         
           MOVE                                                         
           'DECLARE GLOBAL TEMPORARY TABLE CSR04682_ACR'                
                                             TO S-SQL-STATEMENT-V.      
      *                                                                         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04682_ACR')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04682_ACR
              (                                                    
                       RETURN_CODE            INT                   
                      ,ACCOUNT_NO             DECIMAL(13,0)             
                      ,TRANS_HIST_SEQ_NO CHAR(26)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,CODE_AR_AGE_DESC CHAR(20)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,GL_ACCT_CREDIT         DECIMAL(7,4)              
                      ,GL_ACCT_DEBIT          DECIMAL(7,4)              
                      ,AMT_POSTED             DECIMAL(11,2)             
                      ,ITEM_ID                INT                   
                      ,CNT_NAME_DESC CHAR(30)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,CURRENCY_TYPE CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                   )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF SQLSTATE = '42710'                                        
              PERFORM 8000B-DELETE-GTT-ROWS-ACR THRU 8000B-EXIT         
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  CONTINUE                                              
               ELSE                                                     
                  MOVE PROGRAM-NAME          TO ABEND-PROGRAM           
                  MOVE SQLCODE               TO ABEND-SQLCODE           
                  MOVE SQLSTATE              TO ABEND-SQLSTATE          
                  MOVE '0100B'               TO ACTIVE-PARAGRAPH        
                  MOVE 'DECLARE GTT'         TO ABEND-FUNCTION          
                  MOVE SPACES                TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                  MOVE 'CSR04682_ACR'        TO TABLE-1                 
                  MOVE SPACES                TO TABLE-ELEMENT-1         
                  MOVE SPACES                TO HOSTVAR-ELEMENT-1       
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
               DECLARE C2 CURSOR                             
                       WITH ROWSET POSITIONING FOR                      
               SELECT  RETURN_CODE                                      
                      ,ACCOUNT_NO                                       
                      ,TRANS_HIST_SEQ_NO                                
                      ,CODE_AR_AGE_DESC                                 
                      ,GL_ACCT_CREDIT                                   
                      ,GL_ACCT_DEBIT                                    
                      ,AMT_POSTED                                       
                      ,ITEM_ID                                          
                      ,CNT_NAME_DESC                                    
                      ,CURRENCY_TYPE                                    
               FROM #CSR04682_ACR                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C2 CURSOR WITH RETURN                                    
MFA-TR*                WITH ROWSET POSITIONING FOR                              
MFA-TR*        SELECT  RETURN_CODE                                              
MFA-TR*               ,ACCOUNT_NO                                               
MFA-TR*               ,TRANS_HIST_SEQ_NO                                        
MFA-TR*               ,CODE_AR_AGE_DESC                                         
MFA-TR*               ,GL_ACCT_CREDIT                                           
MFA-TR*               ,GL_ACCT_DEBIT                                            
MFA-TR*               ,AMT_POSTED                                               
MFA-TR*               ,ITEM_ID                                                  
MFA-TR*               ,CNT_NAME_DESC                                            
MFA-TR*               ,CURRENCY_TYPE                                            
MFA-TR*        FROM SESSION.CSR04682_ACR                                        
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0100B-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** DECLARE GLOBAL TEMPORARY TABLE - MAINTAIN TRNS HIST DETAILS  **        
      ******************************************************************        
      *                                                                         
       0100C-DECLARE-GTT-MNT.                                           
      *                                                                         
           MOVE                                                         
           'DECLARE GLOBAL TEMPORARY TABLE CSR04682_MNT'                
                                             TO S-SQL-STATEMENT-V.      
      *                                                                         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04682_MNT')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04682_MNT
              (                                                    
                       RETURN_CODE            INT                   
                      ,TRANS_HIST_SEQ_NO CHAR(26)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,COLUMN_DESC CHAR(15)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,PRV_COLUMN_VALUE CHAR(75)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,CHG_COLUMN_VALUE CHAR(75)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                   )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF SQLSTATE = '42710'                                        
              PERFORM 8000C-DELETE-GTT-ROWS-MNT THRU 8000C-EXIT         
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   CONTINUE                                             
               ELSE                                                     
                  MOVE PROGRAM-NAME          TO ABEND-PROGRAM           
                  MOVE SQLCODE               TO ABEND-SQLCODE           
                  MOVE SQLSTATE              TO ABEND-SQLSTATE          
                  MOVE '0100C'               TO ACTIVE-PARAGRAPH        
                  MOVE 'DECLARE GTT'         TO ABEND-FUNCTION          
                  MOVE SPACES                TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                  MOVE 'CSR04682_MNT'        TO TABLE-1                 
                  MOVE SPACES                TO TABLE-ELEMENT-1         
                  MOVE SPACES                TO HOSTVAR-ELEMENT-1       
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
               DECLARE C3 CURSOR                             
                       WITH ROWSET POSITIONING FOR                      
               SELECT  RETURN_CODE                                      
                      ,TRANS_HIST_SEQ_NO                                
                      ,COLUMN_DESC                                      
                      ,PRV_COLUMN_VALUE                                 
                      ,CHG_COLUMN_VALUE                                 
               FROM #CSR04682_MNT                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C3 CURSOR WITH RETURN                                    
MFA-TR*                WITH ROWSET POSITIONING FOR                              
MFA-TR*        SELECT  RETURN_CODE                                              
MFA-TR*               ,TRANS_HIST_SEQ_NO                                        
MFA-TR*               ,COLUMN_DESC                                              
MFA-TR*               ,PRV_COLUMN_VALUE                                         
MFA-TR*               ,CHG_COLUMN_VALUE                                         
MFA-TR*        FROM SESSION.CSR04682_MNT                                        
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0100C-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** RECEIVE INPUT PARMS                                          **        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           MOVE '1000'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           MOVE LINK-CALL-TYPE            TO PARM-CALL-TYPE.            
      *                                                                         
           IF LINK-ACCOUNT-NO  GREATER THAN SPACES                      
              MOVE LINK-ACCOUNT-NO        TO PARM-ACCOUNT-NO            
           END-IF.                                                      
           IF LINK-CUSTOMER-NO GREATER THAN SPACES                      
              MOVE LINK-CUSTOMER-NO       TO PARM-CUSTOMER-NO           
           END-IF.                                                      
           IF LINK-PREMISE-NO  GREATER THAN SPACES                      
              MOVE LINK-PREMISE-NO        TO PARM-PREMISE-NO            
           END-IF.                                                      
      *                                                                         
           MOVE LINK-RESP-AREA-ID         TO PARM-RESP-AREA-ID.         
           MOVE LINK-USER-ID              TO PARM-USER-ID.              
           MOVE LINK-CODE-TRAN-TYPE       TO PARM-CODE-TRAN-TYPE.       
           MOVE LINK-TRNS-HIST-FROM-TS    TO PARM-TRNS-HIST-FROM-TS.    
           MOVE LINK-TRNS-HIST-TO-TS      TO PARM-TRNS-HIST-TO-TS.      
           MOVE LINK-COMPANY-NO           TO PARM-COMPANY-NO.           
           MOVE LINK-NAVIG-PATH           TO PARM-NAVIG-PATH.           
           MOVE LINK-CSR-USER-ID          TO PARM-CSR-USER-ID.          
      *                                                                         
           MOVE 'N'                       TO WS-GET-ACCT-DATA-FL        
                                             WS-GET-CUST-DATA-FL        
                                             WS-GET-PREM-DATA-FL.       
      *                                                                         
           IF PARM-ACCOUNT-NO-NUM > 0                                   
              MOVE 'Y'                    TO WS-GET-ACCT-DATA-FL        
              MOVE PARM-ACCOUNT-NO-NUM    TO AR-ACCOUNT-NO              
                                             MH-ACCOUNT-NO              
           END-IF.                                                      
           IF PARM-CUSTOMER-NO-NUM > 0                                  
              MOVE 'Y'                    TO WS-GET-CUST-DATA-FL        
              MOVE PARM-CUSTOMER-NO-NUM   TO MH-CUSTOMER-NO             
           END-IF.                                                      
           IF PARM-PREMISE-NO-NUM > 0                                   
              MOVE 'Y'                    TO WS-GET-PREM-DATA-FL        
              MOVE PARM-PREMISE-NO-NUM    TO MH-PREMISE-NO              
           END-IF.                                                      
      *                                                                         
           MOVE PARM-RESP-AREA-ID         TO AR-RESP-AREA-ID            
                                             MH-RESP-AREA-ID.           
      *                                                                         
           MOVE PARM-USER-ID              TO AR-USER-ID                 
                                             MH-USER-ID.                
      *                                                                         
           EVALUATE TRUE                                                
               WHEN (PARM-CODE-TRAN-TYPE = 'X')                         
                    MOVE 'B'              TO WS-CODE-TRAN-TYPE1         
                    MOVE 'P'              TO WS-CODE-TRAN-TYPE2         
               WHEN (PARM-CODE-TRAN-TYPE GREATER THAN SPACES)           
                    MOVE PARM-CODE-TRAN-TYPE                            
                                          TO WS-CODE-TRAN-TYPE1         
                                             WS-CODE-TRAN-TYPE2         
               WHEN OTHER                                               
                    MOVE '_'              TO WS-CODE-TRAN-TYPE1         
                                             WS-CODE-TRAN-TYPE2         
           END-EVALUATE.                                                
      *                                                                         
           IF PARM-TRNS-HIST-FROM-TS > SPACES                           
              IF PARM-NAVIG-PATH(1:1) = 'H'                             
                 MOVE '-00.00.00.000000'                                
                   TO PARM-TRNS-HIST-FROM-TS(11:16)                     
              END-IF                                                    
           ELSE                                                         
              MOVE '1900-01-01-00.00.00.000000'                         
                                          TO PARM-TRNS-HIST-FROM-TS     
           END-IF.                                                      
      *                                                                         
           IF PARM-TRNS-HIST-TO-TS > SPACES                             
              IF PARM-NAVIG-PATH(1:1) = 'H'                             
                 MOVE '-23.59.59.999999'                                
                   TO PARM-TRNS-HIST-TO-TS(11:16)                       
              END-IF                                                    
           ELSE                                                         
              PERFORM 7000-GET-CURRENT-TIMESTAMP  THRU  7000-EXIT       
              MOVE WS-CURRENT-TS          TO PARM-TRNS-HIST-TO-TS       
           END-IF.                                                      
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** CALL TYPE = 'Z'(ACCT,CUST & PREMISE TRANSACTION HISTORY)     **        
      ** CALL TYPE = 'A'(ACCOUNT TRANSACTION HISTORY)                 **        
      ** CALL TYPE = 'C'(CUSTOMER TRANSACTION HISTORY)                **        
      ** CALL TYPE = 'P'(PREMISE TRANSACTION HISTORY)                 **        
      ** CALL TYPE = 'U'(USER ID TRANSACTION HISTORY)                 **        
      ** NAVIGATION PATH = 'H'(ACCESS HISTORY-TRANSACTION HISTORY)    **        
      ** RESULT SETS: HEADER, ACCT RECV DET & MAINTAIN TRNS HIST DET  **        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           MOVE '2000'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           EVALUATE TRUE                                                
             WHEN (PARM-CALL-TYPE = 'Z')                                
               PERFORM 7100-OPEN-TRNS-HDR-ACP        THRU  7100-EXIT    
               PERFORM 7110-FETCH-TRNS-HDR-ACP       THRU  7110-EXIT    
             WHEN (PARM-CALL-TYPE = 'A')                                
               PERFORM 7150-OPEN-TRNS-HDR-ACCT       THRU  7150-EXIT    
               PERFORM 7160-FETCH-TRNS-HDR-ACCT      THRU  7160-EXIT    
             WHEN (PARM-CALL-TYPE = 'C')                                
               PERFORM 7200-OPEN-TRNS-HDR-CUST       THRU  7200-EXIT    
               PERFORM 7210-FETCH-TRNS-HDR-CUST      THRU  7210-EXIT    
             WHEN (PARM-CALL-TYPE = 'P')                                
               PERFORM 7250-OPEN-TRNS-HDR-PREM       THRU  7250-EXIT    
               PERFORM 7260-FETCH-TRNS-HDR-PREM      THRU  7260-EXIT    
             WHEN (PARM-CALL-TYPE = 'R' AND PARM-NAVIG-PATH = 'GAR')    
               PERFORM 7350-OPEN-TRNS-HDR-RESP-AR    THRU  7350-EXIT    
               PERFORM 7360-FETCH-TRNS-HDR-RESP-AR   THRU  7360-EXIT    
             WHEN (PARM-CALL-TYPE = 'R' AND PARM-NAVIG-PATH = 'GMH')    
               PERFORM 7400-OPEN-TRNS-HDR-RESP-MH    THRU  7400-EXIT    
               PERFORM 7410-FETCH-TRNS-HDR-RESP-MH   THRU  7410-EXIT    
             WHEN (PARM-CALL-TYPE = 'R')                                
               PERFORM 7300-OPEN-TRNS-HDR-RESP       THRU  7300-EXIT    
               PERFORM 7310-FETCH-TRNS-HDR-RESP      THRU  7310-EXIT    
             WHEN (PARM-CALL-TYPE = 'U' AND PARM-NAVIG-PATH(1:1) = 'H'  
                   AND PARM-ACCOUNT-NO-NUM > 0)                         
               PERFORM 7450-OPEN-TRNS-HDR-UID-ACCT   THRU  7450-EXIT    
               PERFORM 7460-FETCH-TRNS-HDR-UID-ACCT  THRU  7460-EXIT    
             WHEN (PARM-CALL-TYPE = 'U' AND PARM-NAVIG-PATH(1:1) = 'H'  
                   AND PARM-CUSTOMER-NO-NUM > 0)                        
               PERFORM 7650-OPEN-TRNS-HDR-UID-CUST   THRU  7650-EXIT    
               PERFORM 7660-FETCH-TRNS-HDR-UID-CUST  THRU  7660-EXIT    
             WHEN (PARM-CALL-TYPE = 'U' AND PARM-NAVIG-PATH = 'GAR')    
               PERFORM 7550-OPEN-TRNS-HDR-UID-AR     THRU  7550-EXIT    
               PERFORM 7560-FETCH-TRNS-HDR-UID-AR    THRU  7560-EXIT    
             WHEN (PARM-CALL-TYPE = 'U' AND PARM-NAVIG-PATH = 'GMH')    
               PERFORM 7600-OPEN-TRNS-HDR-UID-MH     THRU  7600-EXIT    
               PERFORM 7610-FETCH-TRNS-HDR-UID-MH    THRU  7610-EXIT    
             WHEN (PARM-CALL-TYPE = 'U')                                
               PERFORM 7500-OPEN-TRNS-HDR-UID        THRU  7500-EXIT    
               PERFORM 7510-FETCH-TRNS-HDR-UID       THRU  7510-EXIT    
             WHEN OTHER                                                 
               PERFORM 2900-VLDT-NOTFOUND-RES        THRU  2900-EXIT    
               PERFORM 9999-END-PROGRAM              THRU  9999-EXIT    
           END-EVALUATE.                                                
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              AND WS-HDR-FETCH-COUNT = 21                               
              MOVE 'Y'                    TO WS-MORE-DATA-AVLB-FL       
           ELSE                                                         
              MOVE 'N'                    TO WS-MORE-DATA-AVLB-FL       
           END-IF.                                                      
      *                                                                         
           PERFORM 2500-MOVE-RESULT-HDR  THRU  2500-EXIT                
           VARYING WS-HI FROM 1 BY 1 UNTIL WS-HI > 20                   
                OR WS-HI > WS-HDR-FETCH-COUNT.                          
      *                                                                         
           EVALUATE TRUE                                                
             WHEN (PARM-CALL-TYPE = 'Z')                                
               PERFORM 7120-CLOSE-TRNS-HDR-ACP       THRU  7120-EXIT    
             WHEN (PARM-CALL-TYPE = 'A')                                
               PERFORM 7170-CLOSE-TRNS-HDR-ACCT      THRU  7170-EXIT    
             WHEN (PARM-CALL-TYPE = 'C')                                
               PERFORM 7220-CLOSE-TRNS-HDR-CUST      THRU  7220-EXIT    
             WHEN (PARM-CALL-TYPE = 'P')                                
               PERFORM 7270-CLOSE-TRNS-HDR-PREM      THRU  7270-EXIT    
             WHEN (PARM-CALL-TYPE = 'R' AND PARM-NAVIG-PATH = 'GAR')    
               PERFORM 7370-CLOSE-TRNS-HDR-RESP-AR   THRU  7370-EXIT    
             WHEN (PARM-CALL-TYPE = 'R' AND PARM-NAVIG-PATH = 'GMH')    
               PERFORM 7420-CLOSE-TRNS-HDR-RESP-MH   THRU  7420-EXIT    
             WHEN (PARM-CALL-TYPE = 'R')                                
               PERFORM 7320-CLOSE-TRNS-HDR-RESP      THRU  7320-EXIT    
             WHEN (PARM-CALL-TYPE = 'U' AND PARM-NAVIG-PATH(1:1) = 'H'  
                   AND PARM-ACCOUNT-NO-NUM > 0)                         
               PERFORM 7470-CLOSE-TRNS-HDR-UID-ACCT  THRU  7470-EXIT    
             WHEN (PARM-CALL-TYPE = 'U' AND PARM-NAVIG-PATH(1:1) = 'H'  
                   AND PARM-CUSTOMER-NO-NUM > 0)                        
               PERFORM 7670-CLOSE-TRNS-HDR-UID-CUST  THRU  7670-EXIT    
             WHEN (PARM-CALL-TYPE = 'U' AND PARM-NAVIG-PATH = 'GAR')    
               PERFORM 7570-CLOSE-TRNS-HDR-UID-AR    THRU  7570-EXIT    
             WHEN (PARM-CALL-TYPE = 'U' AND PARM-NAVIG-PATH = 'GMH')    
               PERFORM 7620-CLOSE-TRNS-HDR-UID-MH    THRU  7620-EXIT    
             WHEN (PARM-CALL-TYPE = 'U')                                
               PERFORM 7520-CLOSE-TRNS-HDR-UID       THRU  7520-EXIT    
           END-EVALUATE.                                                
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** MOVE RESULT SET - TRANSACTION HISTORY HEADER                 **        
      ******************************************************************        
      *                                                                         
       2500-MOVE-RESULT-HDR.                                            
      *                                                                         
           MOVE '2500'                      TO ACTIVE-PARAGRAPH.        
      *                                                                         
           MOVE H-TRANS-HIST-SEQ-NO(WS-HI)  TO S-H-TRANS-HIST-SEQ-NO.   
           MOVE H-CODE-TRAN-TYPE(WS-HI)     TO S-H-CODE-TRAN-TYPE.      
      *                                                                         
           MOVE SPACES                      TO K9-APPL-PROGRAM-ID       
                                               K9-APPL-PROGRAM-DESC.    
           MOVE H-APPL-PROGRAM-ID(WS-HI)    TO K9-APPL-PROGRAM-ID.      
           PERFORM 7700-GET-APPL-PGM-DESC   THRU  7700-EXIT.            
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE K9-APPL-PROGRAM-DESC     TO S-H-APPL-PROGRAM-DESC    
           ELSE                                                         
              MOVE H-APPL-PROGRAM-ID(WS-HI) TO S-H-APPL-PROGRAM-DESC    
           END-IF.                                                      
      *                                                                         
           EVALUATE H-USER-ID(WS-HI)                                    
             WHEN 'SYSTEM'                                              
                MOVE 'SYSTEM'               TO S-H-EMPLOYEE-NAME        
             WHEN OTHER                                                 
                MOVE SPACES                 TO WS-EMPLOYEE-NAME         
                                               PF-LAST-NAME             
                                               PF-FIRST-NAME            
                                               PF-MIDDLE-NAME           
                MOVE H-USER-ID(WS-HI)       TO PF-USER-ID               
                PERFORM 7710-GET-EMPLOYEE-NAME  THRU  7710-EXIT         
                IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL          
                   MOVE WS-EMPLOYEE-NAME    TO S-H-EMPLOYEE-NAME        
                ELSE                                                    
                   MOVE H-USER-ID(WS-HI)    TO S-H-EMPLOYEE-NAME        
                END-IF                                                  
           END-EVALUATE.                                                
      *                                                                         
           MOVE H-RESP-AREA-ID(WS-HI)       TO S-H-RESP-AREA-ID.        
           MOVE H-TRAN-COMMENT(WS-HI)       TO S-H-TRAN-COMMENT.        
           MOVE H-ACCOUNT-NO(WS-HI)         TO S-H-ACCOUNT-NO.          
      *                                                                         
           IF H-TABLE-CD(WS-HI) = 'AR'                                  
              INITIALIZE                         S-H-CUSTOMER-NO        
                                                 S-H-PREMISE-NO         
              MOVE H-AMT-ORIG-ENTERED(WS-HI)  TO S-H-AMT-ORIG-ENTERED   
              MOVE H-AMT-BILLED-UNPAID(WS-HI) TO S-H-AMT-BILLED-UNPAID  
           ELSE                                                         
              MOVE H-CUSTOMER-NO(WS-HI)       TO S-H-CUSTOMER-NO        
              MOVE H-PREMISE-NO(WS-HI)        TO S-H-PREMISE-NO         
              INITIALIZE                         S-H-AMT-ORIG-ENTERED   
                                                 S-H-AMT-BILLED-UNPAID  
           END-IF.                                                      
      *                                                                         
           MOVE H-RECORD-ONLY-FL(WS-HI)     TO S-H-RECORD-ONLY-FL.      
PRJ586     MOVE H-PYMT-REFUNDED-IND(WS-HI)  TO S-H-PYMT-REFUNDED-IND.   
      *                                                                         
           IF H-TABLE-CD(WS-HI)           = 'AR'                        
ACT276        AND H-CODE-TRAN-TYPE(WS-HI) = 'P' OR 'C'                  
              PERFORM 2525-MOVE-RESULT-HDR-AR-PYMT  THRU  2525-EXIT     
           ELSE                                                         
              INITIALIZE                      S-H-CASH-LOCAL-OFFICE     
                                              S-H-DATE-CASH-REPORT      
                                              S-H-DATE-ORIG-PYMT        
                                              S-H-DRAWER-ID             
                                              S-H-DRAWER-STATUS         
                                              S-H-PYMT-FACILITY-CD      
                                              S-H-PYMT-FACILITY-DESC    
           END-IF.                                                      
      *                                                                         
           MOVE H-TABLE-CD(WS-HI)           TO S-H-TABLE-CD.            
           MOVE WS-MORE-DATA-AVLB-FL        TO S-H-MORE-DATA-AVLB-FL.   
      *                                                                         
           INITIALIZE                          S-H-FULL-NAME            
                                               S-H-ADDRESS-LINE-1       
                                               S-H-ADDRESS-LINE-2.      
      *                                                                         
      *** GLOBAL TRANS HIST -> CUSTOMER NAME & ADDRESS DETAILS                  
           IF PARM-NAVIG-PATH(1:1) = 'G'                                
              PERFORM 2550-MOVE-CUST-NAME-AND-ADDR  THRU  2550-EXIT     
           END-IF.                                                      
      *                                                                         
           PERFORM 8100A-SEND-RESULT-HDR  THRU  8100A-EXIT.             
      *                                                                         
           PERFORM 2600-PROCESS-TRNS-DETAILS  THRU  2600-EXIT.          
      *                                                                         
           INITIALIZE                          GTT-RETURN-FIELDS-HDR.   
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** MOVE RESULT SET - TRANSACTION HISTORY HEADER OF ACCT RECV    **        
      ******************************************************************        
      *                                                                         
       2525-MOVE-RESULT-HDR-AR-PYMT.                                    
      *                                                                         
           MOVE '2525'                      TO ACTIVE-PARAGRAPH.        
      *                                                                         
           INITIALIZE                          Y2-CASH-LOCAL-OFFICE     
                                               Y2-CASH-LOC-OFF-DESC     
                                               UV-CODE-VALUE-TEXT       
                                               UV-CODE-SHORT-DESC       
                                               BC-CASH-LOCAL-OFFICE     
                                               BC-CASH-REPORT-NO        
                                               BC-DATE-CASH-REPORT      
                                               BC-CASH-DRAWER-ID        
                                               BC-CODE-BATCH-STATUS     
                                               CS-CASH-LOCAL-OFFICE     
                                               CS-CASH-REPORT-NO        
                                               CS-DATE-CASH-REPORT      
                                               CS-CASH-DRAWER-ID.       
      *                                                                         
           MOVE H-CASH-LOCAL-OFFICE(WS-HI)  TO S-H-CASH-LOCAL-OFFICE.   
      *                                                                         
           IF (H-CASH-LOCAL-OFFICE(WS-HI)      = '058' OR '038')        
              AND H-PYMT-FACILITY-CD(WS-HI)    = 'O'                    
              MOVE H-TRAN-COMMENT(WS-HI)(13:3) TO Y2-CASH-LOCAL-OFFICE  
              PERFORM 7715-GET-CASH-LOC-OFF-DESC  THRU  7715-EXIT       
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                 STRING 'BMX-'                DELIMITED SIZE            
                        Y2-CASH-LOC-OFF-DESC  DELIMITED BY '  '         
                   INTO S-H-CASH-LOCAL-OFFICE                           
                 IF H-TRAN-COMMENT(WS-HI)(17:10) = 'CARD-TYPE='         
                    MOVE S-H-TRAN-COMMENT(27:1) TO UV-CODE-VALUE-TEXT   
                    MOVE LENGTH OF UV-CODE-VALUE-TEXT                   
                                             TO UV-CODE-VALUE-LEN       
                    PERFORM 7770-GET-CODE-VALUE-DESC  THRU  7770-EXIT   
                    IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL      
                      STRING                                            
                       H-TRAN-COMMENT(WS-HI)(1:12)   DELIMITED BY SIZE  
                       S-H-CASH-LOCAL-OFFICE         DELIMITED BY '  '  
                       H-TRAN-COMMENT(WS-HI)(16:11)  DELIMITED BY SIZE  
                       UV-CODE-SHORT-DESC-TEXT       DELIMITED BY '  '  
                       H-TRAN-COMMENT(WS-HI)(28:183) DELIMITED BY SIZE  
                      INTO S-H-TRAN-COMMENT                             
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           MOVE H-DATE-CASH-REPORT(WS-HI)   TO S-H-DATE-CASH-REPORT.    
      *                                                                         
           IF H-DATE-ORIG-PYMT(WS-HI) = '1900-01-01'                    
              MOVE SPACES                   TO S-H-DATE-ORIG-PYMT       
           ELSE                                                         
              MOVE H-DATE-ORIG-PYMT(WS-HI)(6:2)                         
                                            TO S-H-DATE-ORIG-PYMT(1:2)  
              MOVE '/'                      TO S-H-DATE-ORIG-PYMT(3:1)  
              MOVE H-DATE-ORIG-PYMT(WS-HI)(9:2)                         
                                            TO S-H-DATE-ORIG-PYMT(4:2)  
              MOVE '/'                      TO S-H-DATE-ORIG-PYMT(6:1)  
              MOVE H-DATE-ORIG-PYMT(WS-HI)(3:2)                         
                                            TO S-H-DATE-ORIG-PYMT(7:2)  
           END-IF.                                                      
      *                                                                         
           MOVE H-CASH-DRAWER-ID(WS-HI)     TO S-H-DRAWER-ID.           
      *                                                                         
           MOVE H-CASH-LOCAL-OFFICE(WS-HI)  TO BC-CASH-LOCAL-OFFICE     
                                               CS-CASH-LOCAL-OFFICE.    
           MOVE H-CASH-REPORT-NO(WS-HI)     TO BC-CASH-REPORT-NO        
                                               CS-CASH-REPORT-NO.       
           MOVE H-DATE-CASH-REPORT(WS-HI)   TO BC-DATE-CASH-REPORT      
                                               CS-DATE-CASH-REPORT.     
           MOVE H-CASH-DRAWER-ID(WS-HI)     TO BC-CASH-DRAWER-ID        
                                               CS-CASH-DRAWER-ID.       
           PERFORM 7720-GET-BATCH-STATUS  THRU  7720-EXIT.              
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              PERFORM 7730-GET-CD-BATCH-STATUS THRU 7730-EXIT           
           END-IF.                                                      
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              MOVE SPACES                   TO BC-CODE-BATCH-STATUS     
           END-IF.                                                      
           EVALUATE BC-CODE-BATCH-STATUS                                
               WHEN 'A'                                                 
                    MOVE 'ACTIVE'           TO S-H-DRAWER-STATUS        
               WHEN 'B'                                                 
                    MOVE 'BALANCED'         TO S-H-DRAWER-STATUS        
               WHEN 'C'                                                 
                    MOVE 'CLOSED'           TO S-H-DRAWER-STATUS        
               WHEN 'P'                                                 
                    MOVE 'PENDING'          TO S-H-DRAWER-STATUS        
               WHEN OTHER                                               
                    MOVE SPACES             TO S-H-DRAWER-STATUS        
           END-EVALUATE.                                                
      *                                                                         
           MOVE H-PYMT-FACILITY-CD(WS-HI)   TO S-H-PYMT-FACILITY-CD.    
      *                                                                         
           EVALUATE S-H-PYMT-FACILITY-CD                                
              WHEN 'A'                                                  
                 MOVE 'AUTO PYMT AGENCY'    TO S-H-PYMT-FACILITY-DESC   
              WHEN 'B'                                                  
                 MOVE 'DROP BOX'            TO S-H-PYMT-FACILITY-DESC   
              WHEN 'C'                                                  
                 MOVE 'COUNTER BOX'         TO S-H-PYMT-FACILITY-DESC   
              WHEN 'D'                                                  
                 MOVE 'DRIVE IN'            TO S-H-PYMT-FACILITY-DESC   
              WHEN 'E'                                                  
                 MOVE 'COLLECTION AGENCY'   TO S-H-PYMT-FACILITY-DESC   
              WHEN 'F'                                                  
                 MOVE 'FIELD COLLECTION'    TO S-H-PYMT-FACILITY-DESC   
              WHEN 'G'                                                  
                 MOVE 'DRAFT'               TO S-H-PYMT-FACILITY-DESC   
              WHEN 'H'                                                  
                 MOVE 'WEB-FEE'             TO S-H-PYMT-FACILITY-DESC   
              WHEN 'I'                                                  
                 MOVE 'MOBILE'              TO S-H-PYMT-FACILITY-DESC   
              WHEN 'J'                                                  
                 MOVE 'WEB-NO FEE'          TO S-H-PYMT-FACILITY-DESC   
              WHEN 'K'                                                  
                 MOVE 'WEB-AUTO CARD PAY'   TO S-H-PYMT-FACILITY-DESC   
              WHEN 'L'                                                  
                 MOVE 'LOCKBOX'             TO S-H-PYMT-FACILITY-DESC   
              WHEN 'M'                                                  
                 MOVE 'MAIL'                TO S-H-PYMT-FACILITY-DESC   
              WHEN 'N'                                                  
                 MOVE 'REMOTE SALES'        TO S-H-PYMT-FACILITY-DESC   
              WHEN 'O'                                                  
                 MOVE 'OFFICE'              TO S-H-PYMT-FACILITY-DESC   
              WHEN 'P'                                                  
                 MOVE 'TELEPHONE'           TO S-H-PYMT-FACILITY-DESC   
              WHEN 'Q'                                                  
                 MOVE 'EDI'                 TO S-H-PYMT-FACILITY-DESC   
              WHEN 'R'                                                  
                 MOVE 'WEB AGENCY'          TO S-H-PYMT-FACILITY-DESC   
              WHEN 'S'                                                  
                 MOVE 'PAYMENT AGENCY'      TO S-H-PYMT-FACILITY-DESC   
              WHEN 'T'                                                  
                 MOVE 'MAIL'                TO S-H-PYMT-FACILITY-DESC   
              WHEN 'U'                                                  
                 MOVE 'COLL / REC MGMT'     TO S-H-PYMT-FACILITY-DESC   
              WHEN 'W'                                                  
                 MOVE 'WALK IN'             TO S-H-PYMT-FACILITY-DESC   
              WHEN 'X'                                                  
                 MOVE 'FAX PAYMENT'         TO S-H-PYMT-FACILITY-DESC   
              WHEN 'Y'                                                  
                 MOVE 'AUTO PYMT AGENCY'    TO S-H-PYMT-FACILITY-DESC   
              WHEN 'Z'                                                  
                 MOVE 'E-PAYMENT'           TO S-H-PYMT-FACILITY-DESC   
              WHEN OTHER                                                
                 MOVE S-H-PYMT-FACILITY-CD  TO S-H-PYMT-FACILITY-DESC   
           END-EVALUATE.                                                
      *                                                                         
           IF S-H-TRAN-COMMENT(1:10)  = 'CARD-TYPE='                    
GOPI  ******* AND (H-APPL-PROGRAM-ID(WS-HI) = 'CSR03413' OR 'PCSCA362')         
              MOVE S-H-TRAN-COMMENT(11:1)   TO UV-CODE-VALUE-TEXT       
              MOVE LENGTH OF UV-CODE-VALUE-TEXT TO UV-CODE-VALUE-LEN    
              PERFORM 7770-GET-CODE-VALUE-DESC  THRU  7770-EXIT         
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                 MOVE UV-CODE-SHORT-DESC-TEXT TO S-H-TRAN-COMMENT(11:15)
                 STRING H-TRAN-COMMENT(WS-HI)(1:10)   DELIMITED BY SIZE 
                        UV-CODE-SHORT-DESC-TEXT       DELIMITED BY '  ' 
                        H-TRAN-COMMENT(WS-HI)(12:199) DELIMITED BY SIZE 
                 INTO S-H-TRAN-COMMENT                                  
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2525-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** POPULATE NAME AND ADDRESS DETAILS                            **        
      ******************************************************************        
      *                                                                         
       2550-MOVE-CUST-NAME-AND-ADDR.                                    
      *                                                                         
           MOVE '2550'                      TO ACTIVE-PARAGRAPH.        
      *                                                                         
           INITIALIZE                          HT-ACCOUNT-NO            
                                               HT-CUSTOMER-NO           
                                               HT-PREMISE-NO            
                                               DQ-FULL-NAME             
                                               A4-TOWN                  
                                               A4-STATE                 
                                               A4-ZIP-CODE              
                                               WS-ADDRESS-LINE-1        
                                               WS-ADDRESS-LINE-2.       
      *                                                                         
           EVALUATE TRUE                                                
               WHEN (S-H-ACCOUNT-NO  > 0)                               
                    MOVE S-H-ACCOUNT-NO       TO HT-ACCOUNT-NO          
                    PERFORM 7740-GET-CUST-NAME-AND-ADDR THRU 7740-EXIT  
                    IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL      
                       MOVE DQ-FULL-NAME      TO S-H-FULL-NAME          
                       MOVE WS-ADDRESS-LINE-1 TO S-H-ADDRESS-LINE-1     
                       MOVE WS-ADDRESS-LINE-2 TO S-H-ADDRESS-LINE-2     
                    END-IF                                              
               WHEN (S-H-CUSTOMER-NO > 0 AND S-H-PREMISE-NO  > 0)       
                    MOVE S-H-CUSTOMER-NO      TO HT-CUSTOMER-NO         
                    PERFORM 7750-GET-CUSTOMER-NAME      THRU 7750-EXIT  
                    IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL      
                       MOVE DQ-FULL-NAME      TO S-H-FULL-NAME          
                    END-IF                                              
                    MOVE S-H-PREMISE-NO       TO HT-PREMISE-NO          
                    PERFORM 7760-GET-PREMISE-ADDRESS  THRU  7760-EXIT   
                    IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL      
                       MOVE WS-ADDRESS-LINE-1 TO S-H-ADDRESS-LINE-1     
                       MOVE WS-ADDRESS-LINE-2 TO S-H-ADDRESS-LINE-2     
                    END-IF                                              
               WHEN (S-H-CUSTOMER-NO > 0)                               
                    MOVE S-H-CUSTOMER-NO      TO HT-CUSTOMER-NO         
                    PERFORM 7750-GET-CUSTOMER-NAME  THRU  7750-EXIT     
                    IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL      
                       MOVE DQ-FULL-NAME      TO S-H-FULL-NAME          
                    END-IF                                              
               WHEN (S-H-PREMISE-NO  > 0)                               
                    MOVE S-H-PREMISE-NO       TO HT-PREMISE-NO          
                    PERFORM 7760-GET-PREMISE-ADDRESS  THRU  7760-EXIT   
                    IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL      
                       MOVE WS-ADDRESS-LINE-1 TO S-H-ADDRESS-LINE-1     
                       MOVE WS-ADDRESS-LINE-2 TO S-H-ADDRESS-LINE-2     
                    END-IF                                              
           END-EVALUATE.                                                
      *                                                                         
       2550-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** ACCT RECV TRNS HIST DETAILS                                  **        
      ** MAINTAIN TRNS HIST DETAILS                                   **        
      ******************************************************************        
      *                                                                         
       2600-PROCESS-TRNS-DETAILS.                                       
      *                                                                         
           MOVE '2600'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           IF H-TABLE-CD(WS-HI) = 'AR'                                  
              INITIALIZE                       GTT-RETURN-FIELDS-ACR    
              MOVE H-ACCOUNT-NO(WS-HI)        TO AU-ACCOUNT-NO          
              MOVE H-TRANS-HIST-SEQ-NO(WS-HI) TO AU-TRANS-HIST-SEQ-NO   
              PERFORM 7800-OPEN-ACCT-RECV-DET    THRU  7800-EXIT        
              PERFORM 7810-FETCH-ACCT-RECV-DET   THRU  7810-EXIT        
           ELSE                                                         
              INITIALIZE                         GTT-RETURN-FIELDS-MNT  
                                                 MI-COLUMN-DESC         
                                                 MI-TABLE-ID            
                                                 MI-PRV-COLUMN-VALUE    
                                                 MI-CHG-COLUMN-VALUE    
              MOVE H-TRANS-HIST-SEQ-NO(WS-HI) TO MI-TRANS-HIST-SEQ-NO   
              PERFORM 7900-OPEN-MNTN-TRNS-DET    THRU  7900-EXIT        
              PERFORM 7910-FETCH-MNTN-TRNS-DET   THRU  7910-EXIT        
           END-IF.                                                      
      *                                                                         
           PERFORM 2650-PROCESS-TRNS-DET-DATA  THRU  2650-EXIT          
             UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.                   
      *                                                                         
           IF H-TABLE-CD(WS-HI) = 'AR'                                  
              PERFORM 7820-CLOSE-ACCT-RECV-DET    THRU  7820-EXIT       
           ELSE                                                         
              PERFORM 7920-CLOSE-MNTN-TRNS-DET    THRU  7920-EXIT       
           END-IF.                                                      
      *                                                                         
       2600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** POPULATE ACCT RECV TRNS HIST DETAILS RESULT SET              **        
      ** POPULATE MAINTAIN TRNS HIST DETAILS  RESULT SET              **        
      ******************************************************************        
      *                                                                         
       2650-PROCESS-TRNS-DET-DATA.                                      
      *                                                                         
           MOVE '2650'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           IF H-TABLE-CD(WS-HI) = 'AR'                                  
              PERFORM 2700-MOVE-RESULT-ACR      THRU  2700-EXIT         
              PERFORM 7810-FETCH-ACCT-RECV-DET  THRU  7810-EXIT         
           ELSE                                                         
              PERFORM 2750-MOVE-RESULT-MNT      THRU  2750-EXIT         
              PERFORM 7910-FETCH-MNTN-TRNS-DET  THRU  7910-EXIT         
           END-IF.                                                      
      *                                                                         
       2650-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** MOVE RESULT SET - ACCT RECV TRNS HIST DETAILS                **        
      ******************************************************************        
      *                                                                         
       2700-MOVE-RESULT-ACR.                                            
      *                                                                         
           MOVE '2700'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           MOVE AU-ACCOUNT-NO             TO S-A-ACCOUNT-NO.            
           MOVE AU-TRANS-HIST-SEQ-NO      TO S-A-TRANS-HIST-SEQ-NO.     
      *                                                                         
           PERFORM 2710-SET-CODE-AR-AGE-DESC  THRU  2710-EXIT.          
      *                                                                         
           MOVE AU-GL-ACCT-CREDIT         TO S-A-GL-ACCT-CREDIT.        
           MOVE AU-GL-ACCT-DEBIT          TO S-A-GL-ACCT-DEBIT.         
           MOVE AU-AMT-POSTED             TO S-A-AMT-POSTED.            
           MOVE AU-ITEM-ID                TO S-A-ITEM-ID.               
      *                                                                         
           MOVE SPACES                    TO S-A-CNT-NAME-DESC          
                                             K6-CNT-NAME-DESC.          
           IF AU-CODE-CONTRACT-TYPE GREATER THAN SPACES                 
              MOVE AU-ACCOUNT-NO          TO CT-ACCOUNT-NO              
              MOVE AU-ITEM-ID             TO CT-CNT-ITEM-ID             
              PERFORM 7830-GET-CONTRACT-DESC  THRU  7830-EXIT           
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                 MOVE K6-CNT-NAME-DESC    TO S-A-CNT-NAME-DESC          
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           MOVE AU-CURRENCY-TYPE          TO S-A-CURRENCY-TYPE.         
      *                                                                         
           PERFORM 8100B-SEND-RESULT-ACR  THRU  8100B-EXIT.             
      *                                                                         
           INITIALIZE                     GTT-RETURN-FIELDS-ACR.        
      *                                                                         
       2700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** DERIVE CODE AR AGE DESC                                      **        
      ******************************************************************        
      *                                                                         
       2710-SET-CODE-AR-AGE-DESC.                                       
      *                                                                         
           MOVE '2710'                     TO ACTIVE-PARAGRAPH.         
      *                                                                         
           EVALUATE AU-CODE-AR-AGE                                      
             WHEN '0'                                                   
               MOVE '0 DAYS'               TO S-A-CODE-AR-AGE-DESC      
             WHEN '3'                                                   
               MOVE '30 DAYS'              TO S-A-CODE-AR-AGE-DESC      
             WHEN '6'                                                   
               MOVE '60 DAYS'              TO S-A-CODE-AR-AGE-DESC      
             WHEN '9'                                                   
               MOVE '90 DAYS'              TO S-A-CODE-AR-AGE-DESC      
             WHEN 'A'                                                   
               MOVE 'WASH - ADJUSTED'      TO S-A-CODE-AR-AGE-DESC      
             WHEN 'E'                                                   
               MOVE 'ADJUSTMENT TO BBP OB' TO S-A-CODE-AR-AGE-DESC      
             WHEN 'F'                                                   
               MOVE 'FILE MAINTENANCE'     TO S-A-CODE-AR-AGE-DESC      
             WHEN 'N'                                                   
               MOVE 'NON CIS RETURN CHECK' TO S-A-CODE-AR-AGE-DESC      
             WHEN 'P'                                                   
               MOVE 'PREPAYMENT'           TO S-A-CODE-AR-AGE-DESC      
             WHEN 'W'                                                   
               MOVE 'WRITE-OFF'            TO S-A-CODE-AR-AGE-DESC      
             WHEN OTHER                                                 
               MOVE AU-CODE-AR-AGE         TO S-A-CODE-AR-AGE-DESC      
           END-EVALUATE.                                                
      *                                                                         
       2710-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** MOVE RESULT SET - MAINTAIN TRNS HIST DETAILS                 **        
      ******************************************************************        
      *                                                                         
       2750-MOVE-RESULT-MNT.                                            
      *                                                                         
           MOVE '2750'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           MOVE MI-TRANS-HIST-SEQ-NO      TO S-M-TRANS-HIST-SEQ-NO.     
           MOVE MI-TABLE-ID               TO WS-M-TABLE-ID.             
           MOVE MI-COLUMN-DESC            TO S-M-COLUMN-DESC.           
      *                                                                         
ACT270     IF (WS-M-TABLE-ID GREATER THAN SPACES)  OR                   
ACT270        (S-M-COLUMN-DESC = 'CONTACT ID'      OR                   
ACT270                           'NICKNAME'        OR                   
ACT270                           'SOCIAL SECURITY' OR                   
ACT270                           'SSN'             OR                   
ACT280                           'GUAR LTR STATUS' OR                   
ACT280                           'SEASONAL_FL'     OR                   
ACT129                           'NSC REMOVE FL'   OR                   
ACT134                           'ITPA_CURR_RSLT'  OR                   
ACT134                           'LETTER NOTIFY'   )                    
ACT270        PERFORM 2775-DECODE-MNT-COLUMN-DESC  THRU  2775-EXIT      
ACT270     ELSE                                                         
ACT270        MOVE MI-PRV-COLUMN-VALUE-TEXT TO S-M-PRV-COLUMN-VALUE     
ACT270        MOVE MI-CHG-COLUMN-VALUE-TEXT TO S-M-CHG-COLUMN-VALUE     
ACT270     END-IF.                                                      
      *                                                                         
           PERFORM 8100C-SEND-RESULT-MNT  THRU  8100C-EXIT.             
      *                                                                         
           INITIALIZE                     GTT-RETURN-FIELDS-MNT         
                                          MI-COLUMN-DESC                
                                          MI-TABLE-ID                   
                                          MI-PRV-COLUMN-VALUE           
                                          MI-CHG-COLUMN-VALUE.          
      *                                                                         
       2750-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** DECODE COLUMN VALUE DESC USING COPYBOOK LOGIC                **        
      ******************************************************************        
      *                                                                         
       2775-DECODE-MNT-COLUMN-DESC.                                     
      *                                                                         
           MOVE '2775'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           INITIALIZE                        WS-CPD4682-INPUT.          
           MOVE WS-M-TABLE-ID             TO WS-CPD4682-TABLE-ID.       
           MOVE S-M-COLUMN-DESC           TO WS-CPD4682-COL-NAME.       
           MOVE PARM-COMPANY-NO           TO WS-CPD4682-COMPANY-NO.     
           MOVE PARM-ACCOUNT-NO-NUM       TO WS-CPD4682-ACCT-NO.        
           MOVE PARM-CSR-USER-ID          TO WS-CPD4682-USER-ID.        
      *                                                                         
      *** DECODE PREVIOUS COLUMN VALUE                                          
           IF MI-PRV-COLUMN-VALUE-TEXT(1:1) = '*'                       
              MOVE MI-PRV-COLUMN-VALUE-TEXT    TO S-M-PRV-COLUMN-VALUE  
           ELSE                                                         
              MOVE MI-PRV-COLUMN-VALUE-TEXT    TO WS-CPD4682-COL-VALUE  
              PERFORM 6000-PROCESS-DECODE-CPD4682                       
                 THRU 6000-CPD4682-EXIT                                 
              IF CPD4682-NO-ERRORS                                      
                 MOVE WS-CPD4682-DECODE-TEXT   TO S-M-PRV-COLUMN-VALUE  
              ELSE                                                      
                 PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT        
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
      *** DECODE CHANGED COLUMN VALUE                                           
           MOVE SPACES                         TO WS-CPD4682-COL-VALUE. 
           IF MI-CHG-COLUMN-VALUE-TEXT(1:1) = '*'                       
              MOVE MI-CHG-COLUMN-VALUE-TEXT    TO S-M-CHG-COLUMN-VALUE  
           ELSE                                                         
              MOVE MI-CHG-COLUMN-VALUE-TEXT    TO WS-CPD4682-COL-VALUE  
              PERFORM 6000-PROCESS-DECODE-CPD4682                       
                 THRU 6000-CPD4682-EXIT                                 
              IF CPD4682-NO-ERRORS                                      
                 MOVE WS-CPD4682-DECODE-TEXT   TO S-M-CHG-COLUMN-VALUE  
              ELSE                                                      
                 PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT        
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2775-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** IF ROW COUNT = 0 IN A RESULT SET, SEND DUMMY RESULT SET      **        
      ******************************************************************        
      *                                                                         
       2900-VLDT-NOTFOUND-RES.                                          
      *                                                                         
           MOVE '2900'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           IF CTR-ROWS-HDR = 0                                          
              INITIALIZE                     GTT-RETURN-FIELDS-HDR      
              MOVE 100                    TO S-H-RETURN-CODE            
              PERFORM 8100A-SEND-RESULT-HDR  THRU  8100A-EXIT           
           END-IF.                                                      
      *                                                                         
           IF CTR-ROWS-ACR = 0                                          
              INITIALIZE                     GTT-RETURN-FIELDS-ACR      
              MOVE 100                    TO S-A-RETURN-CODE            
              PERFORM 8100B-SEND-RESULT-ACR  THRU  8100B-EXIT           
           END-IF.                                                      
      *                                                                         
           IF CTR-ROWS-MNT = 0                                          
              INITIALIZE                     GTT-RETURN-FIELDS-MNT      
              MOVE 100                    TO S-M-RETURN-CODE            
              PERFORM 8100C-SEND-RESULT-MNT  THRU  8100C-EXIT           
           END-IF.                                                      
      *                                                                         
       2900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 6000-PROCESS-DECODE-CPD4682 THRU 6000-CPD4682-EXIT           **        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD04682                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      **  GET CURRENT TIMESTAMP                                       **        
      ******************************************************************        
      *                                                                         
       7000-GET-CURRENT-TIMESTAMP.                                      
      *                                                                         
           EXEC SQL                                                     
             SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              REPLACE(REPLACE(CONVERT(CHAR(26), DATEADD( MONTH, -25, 
           CIS.CURRENT$TIMESTAMP() ), 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TS,
              :WS-CURRENT-TS-MINUS-25                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SET :WS-CURRENT-TS           =  CURRENT TIMESTAMP                  
MFA-TR*         ,:WS-CURRENT-TS-MINUS-25  =  CURRENT TIMESTAMP                  
MFA-TR*                                   -  25 MONTHS                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7000'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SET'                      TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE SPACES                     TO TABLE-1                
              MOVE 'CALL_TYPE'                TO TABLE-ELEMENT-1        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE 'CUSTOMER_NO'              TO TABLE-ELEMENT-3        
              MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-4        
              MOVE LINK-CALL-TYPE             TO HOSTVAR-ELEMENT-1      
              MOVE LINK-ACCOUNT-NO            TO HOSTVAR-ELEMENT-2      
              MOVE LINK-CUSTOMER-NO           TO HOSTVAR-ELEMENT-3      
              MOVE LINK-PREMISE-NO            TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** OPEN ACCT RECV/MAINTAIN TRNS HIST CURSOR-ACCT,CUST & PREMISE **        
      ******************************************************************        
      *                                                                         
       7100-OPEN-TRNS-HDR-ACP.                                          
      *                                                                         
           EXEC SQL                                                     
               OPEN TRNS_HDR_ACP                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7100'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_AR_TRANS_HIST'        TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'TRNS_HIST_FROM_TS'        TO TABLE-ELEMENT-2        
              MOVE 'TRNS_HIST_TO_TS'          TO TABLE-ELEMENT-3        
              MOVE 'CODE_TRAN_TYPE'           TO TABLE-ELEMENT-4        
              MOVE AR-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE PARM-TRNS-HIST-FROM-TS     TO HOSTVAR-ELEMENT-2      
              MOVE PARM-TRNS-HIST-TO-TS       TO HOSTVAR-ELEMENT-3      
              MOVE PARM-CODE-TRAN-TYPE        TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **FETCH ACCT RECV/MAINTAIN TRNS HIST CURSOR-ACCT,CUST & PREMISE **        
      ******************************************************************        
      *                                                                         
       7110-FETCH-TRNS-HDR-ACP.                                         

MSQ008     MOVE 21 TO MSQ008-TRNS-HDR-ACP
      *                                                                         
           EXEC SQL                                                     
              FOR :MSQ008-TRNS-HDR-ACP
              FETCH 
              FROM TRNS_HDR_ACP            
               INTO :H-TRANS-HIST-SEQ-NO                                
                   ,:H-CODE-TRAN-TYPE                                   
                   ,:H-APPL-PROGRAM-ID                                  
                   ,:H-USER-ID                                          
                   ,:H-RESP-AREA-ID                                     
                   ,:H-TRAN-COMMENT                                     
                   ,:H-ACCOUNT-NO                                       
                   ,:H-CUSTOMER-NO                                      
                   ,:H-PREMISE-NO                                       
                   ,:H-AMT-ORIG-ENTERED                                 
                   ,:H-AMT-BILLED-UNPAID                                
                   ,:H-RECORD-ONLY-FL                                   
PRJ586             ,:H-PYMT-REFUNDED-IND                                
                   ,:H-CASH-LOCAL-OFFICE                                
                   ,:H-CASH-REPORT-NO                                   
                   ,:H-DATE-CASH-REPORT                                 
                   ,:H-DATE-ORIG-PYMT                                   
                   ,:H-CASH-DRAWER-ID                                   
                   ,:H-PYMT-FACILITY-CD                                 
                   ,:H-TABLE-CD                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                             
MFA-TR*       FETCH NEXT ROWSET FROM TRNS_HDR_ACP FOR 21 ROWS                   
MFA-TR*        INTO :H-TRANS-HIST-SEQ-NO                                        
MFA-TR*            ,:H-CODE-TRAN-TYPE                                           
MFA-TR*            ,:H-APPL-PROGRAM-ID                                          
MFA-TR*            ,:H-USER-ID                                                  
MFA-TR*            ,:H-RESP-AREA-ID                                             
MFA-TR*            ,:H-TRAN-COMMENT                                             
MFA-TR*            ,:H-ACCOUNT-NO                                               
MFA-TR*            ,:H-CUSTOMER-NO                                              
MFA-TR*            ,:H-PREMISE-NO                                               
MFA-TR*            ,:H-AMT-ORIG-ENTERED                                         
MFA-TR*            ,:H-AMT-BILLED-UNPAID                                        
MFA-TR*            ,:H-RECORD-ONLY-FL                                           
MFA-TR*            ,:H-PYMT-REFUNDED-IND                                        
MFA-TR*            ,:H-CASH-LOCAL-OFFICE                                        
MFA-TR*            ,:H-CASH-REPORT-NO                                           
MFA-TR*            ,:H-DATE-CASH-REPORT                                         
MFA-TR*            ,:H-DATE-ORIG-PYMT                                           
MFA-TR*            ,:H-CASH-DRAWER-ID                                           
MFA-TR*            ,:H-PYMT-FACILITY-CD                                         
MFA-TR*            ,:H-TABLE-CD                                                 
MFA-TR*    END-EXEC.                                                            

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-TRNS-HDR-ACP
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              MOVE SQLERRD(3)                 TO WS-HDR-FETCH-COUNT     
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7110'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_AR_TRANS_HIST'        TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'TRNS_HIST_FROM_TS'        TO TABLE-ELEMENT-2        
              MOVE 'TRNS_HIST_TO_TS'          TO TABLE-ELEMENT-3        
              MOVE 'CODE_TRAN_TYPE'           TO TABLE-ELEMENT-4        
              MOVE AR-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE PARM-TRNS-HIST-FROM-TS     TO HOSTVAR-ELEMENT-2      
              MOVE PARM-TRNS-HIST-TO-TS       TO HOSTVAR-ELEMENT-3      
              MOVE PARM-CODE-TRAN-TYPE        TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **CLOSE ACCT RECV/MAINTAIN TRNS HIST CURSOR-ACCT,CUST & PREMISE **        
      ******************************************************************        
      *                                                                         
       7120-CLOSE-TRNS-HDR-ACP.                                         
      *                                                                         
           EXEC SQL                                                     
              CLOSE TRNS_HDR_ACP                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7120'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_AR_TRANS_HIST'        TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'TRNS_HIST_FROM_TS'        TO TABLE-ELEMENT-2        
              MOVE 'TRNS_HIST_TO_TS'          TO TABLE-ELEMENT-3        
              MOVE 'CODE_TRAN_TYPE'           TO TABLE-ELEMENT-4        
              MOVE AR-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE PARM-TRNS-HIST-FROM-TS     TO HOSTVAR-ELEMENT-2      
              MOVE PARM-TRNS-HIST-TO-TS       TO HOSTVAR-ELEMENT-3      
              MOVE PARM-CODE-TRAN-TYPE        TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** OPEN ACCT RECV/MAINTAIN TRNS HIST CURSOR-ACCOUNT ONLY        **        
      ******************************************************************        
      *                                                                         
       7150-OPEN-TRNS-HDR-ACCT.                                         
      *                                                                         
           EXEC SQL                                                     
               OPEN TRNS_HDR_ACCT                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7150'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_AR_TRANS_HIST'        TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'TRNS_HIST_FROM_TS'        TO TABLE-ELEMENT-2        
              MOVE 'TRNS_HIST_TO_TS'          TO TABLE-ELEMENT-3        
              MOVE 'CODE_TRAN_TYPE'           TO TABLE-ELEMENT-4        
              MOVE AR-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE PARM-TRNS-HIST-FROM-TS     TO HOSTVAR-ELEMENT-2      
              MOVE PARM-TRNS-HIST-TO-TS       TO HOSTVAR-ELEMENT-3      
              MOVE PARM-CODE-TRAN-TYPE        TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** FETCH ACCT RECV/MAINTAIN TRNS HIST CURSOR-ACCOUNT ONLY       **        
      ******************************************************************        
      *                                                                         
       7160-FETCH-TRNS-HDR-ACCT.                                        

MSQ008     MOVE 21 TO MSQ008-TRNS-HDR-ACCT
      *                                                                         
           EXEC SQL                                                     
              FOR :MSQ008-TRNS-HDR-ACCT
              FETCH 
              FROM TRNS_HDR_ACCT           
               INTO :H-TRANS-HIST-SEQ-NO                                
                   ,:H-CODE-TRAN-TYPE                                   
                   ,:H-APPL-PROGRAM-ID                                  
                   ,:H-USER-ID                                          
                   ,:H-RESP-AREA-ID                                     
                   ,:H-TRAN-COMMENT                                     
                   ,:H-ACCOUNT-NO                                       
                   ,:H-CUSTOMER-NO                                      
                   ,:H-PREMISE-NO                                       
                   ,:H-AMT-ORIG-ENTERED                                 
                   ,:H-AMT-BILLED-UNPAID                                
                   ,:H-RECORD-ONLY-FL                                   
PRJ586             ,:H-PYMT-REFUNDED-IND                                
                   ,:H-CASH-LOCAL-OFFICE                                
                   ,:H-CASH-REPORT-NO                                   
                   ,:H-DATE-CASH-REPORT                                 
                   ,:H-DATE-ORIG-PYMT                                   
                   ,:H-CASH-DRAWER-ID                                   
                   ,:H-PYMT-FACILITY-CD                                 
                   ,:H-TABLE-CD                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                             
MFA-TR*       FETCH NEXT ROWSET FROM TRNS_HDR_ACCT FOR 21 ROWS                  
MFA-TR*        INTO :H-TRANS-HIST-SEQ-NO                                        
MFA-TR*            ,:H-CODE-TRAN-TYPE                                           
MFA-TR*            ,:H-APPL-PROGRAM-ID                                          
MFA-TR*            ,:H-USER-ID                                                  
MFA-TR*            ,:H-RESP-AREA-ID                                             
MFA-TR*            ,:H-TRAN-COMMENT                                             
MFA-TR*            ,:H-ACCOUNT-NO                                               
MFA-TR*            ,:H-CUSTOMER-NO                                              
MFA-TR*            ,:H-PREMISE-NO                                               
MFA-TR*            ,:H-AMT-ORIG-ENTERED                                         
MFA-TR*            ,:H-AMT-BILLED-UNPAID                                        
MFA-TR*            ,:H-RECORD-ONLY-FL                                           
MFA-TR*            ,:H-PYMT-REFUNDED-IND                                        
MFA-TR*            ,:H-CASH-LOCAL-OFFICE                                        
MFA-TR*            ,:H-CASH-REPORT-NO                                           
MFA-TR*            ,:H-DATE-CASH-REPORT                                         
MFA-TR*            ,:H-DATE-ORIG-PYMT                                           
MFA-TR*            ,:H-CASH-DRAWER-ID                                           
MFA-TR*            ,:H-PYMT-FACILITY-CD                                         
MFA-TR*            ,:H-TABLE-CD                                                 
MFA-TR*    END-EXEC.                                                            

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-TRNS-HDR-ACCT
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              MOVE SQLERRD(3)                 TO WS-HDR-FETCH-COUNT     
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7160'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_AR_TRANS_HIST'        TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'TRNS_HIST_FROM_TS'        TO TABLE-ELEMENT-2        
              MOVE 'TRNS_HIST_TO_TS'          TO TABLE-ELEMENT-3        
              MOVE 'CODE_TRAN_TYPE'           TO TABLE-ELEMENT-4        
              MOVE AR-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE PARM-TRNS-HIST-FROM-TS     TO HOSTVAR-ELEMENT-2      
              MOVE PARM-TRNS-HIST-TO-TS       TO HOSTVAR-ELEMENT-3      
              MOVE PARM-CODE-TRAN-TYPE        TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7160-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** CLOSE ACCT RECV/MAINTAIN TRNS HIST CURSOR-ACCOUNT ONLY       **        
      ******************************************************************        
      *                                                                         
       7170-CLOSE-TRNS-HDR-ACCT.                                        
      *                                                                         
           EXEC SQL                                                     
              CLOSE TRNS_HDR_ACCT                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7170'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_AR_TRANS_HIST'        TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'TRNS_HIST_FROM_TS'        TO TABLE-ELEMENT-2        
              MOVE 'TRNS_HIST_TO_TS'          TO TABLE-ELEMENT-3        
              MOVE 'CODE_TRAN_TYPE'           TO TABLE-ELEMENT-4        
              MOVE AR-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE PARM-TRNS-HIST-FROM-TS     TO HOSTVAR-ELEMENT-2      
              MOVE PARM-TRNS-HIST-TO-TS       TO HOSTVAR-ELEMENT-3      
              MOVE PARM-CODE-TRAN-TYPE        TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7170-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** OPEN MAINTAIN TRNS HIST CURSOR-CUSTOMER ONLY                 **        
      ******************************************************************        
      *                                                                         
       7200-OPEN-TRNS-HDR-CUST.                                         
      *                                                                         
           EXEC SQL                                                     
               OPEN TRNS_HDR_CUST                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7200'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_MNT_TRANS_HIST'       TO TABLE-1                
              MOVE 'CUSTOMER_NO'              TO TABLE-ELEMENT-1        
              MOVE 'TRNS_HIST_FROM_TS'        TO TABLE-ELEMENT-2        
              MOVE 'TRNS_HIST_TO_TS'          TO TABLE-ELEMENT-3        
              MOVE 'CODE_TRAN_TYPE'           TO TABLE-ELEMENT-4        
              MOVE MH-CUSTOMER-NO             TO HOSTVAR-ELEMENT-1      
              MOVE PARM-TRNS-HIST-FROM-TS     TO HOSTVAR-ELEMENT-2      
              MOVE PARM-TRNS-HIST-TO-TS       TO HOSTVAR-ELEMENT-3      
              MOVE PARM-CODE-TRAN-TYPE        TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** FETCH MAINTAIN TRNS HIST CURSOR-CUSTOMER ONLY                **        
      ******************************************************************        
      *                                                                         
       7210-FETCH-TRNS-HDR-CUST.                                        

MSQ008     MOVE 21 TO MSQ008-TRNS-HDR-CUST
      *                                                                         
           EXEC SQL                                                     
              FOR :MSQ008-TRNS-HDR-CUST
              FETCH 
              FROM TRNS_HDR_CUST           
               INTO :H-TRANS-HIST-SEQ-NO                                
                   ,:H-CODE-TRAN-TYPE                                   
                   ,:H-APPL-PROGRAM-ID                                  
                   ,:H-USER-ID                                          
                   ,:H-RESP-AREA-ID                                     
                   ,:H-TRAN-COMMENT                                     
                   ,:H-ACCOUNT-NO                                       
                   ,:H-CUSTOMER-NO                                      
                   ,:H-PREMISE-NO                                       
                   ,:H-TABLE-CD                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                             
MFA-TR*       FETCH NEXT ROWSET FROM TRNS_HDR_CUST FOR 21 ROWS                  
MFA-TR*        INTO :H-TRANS-HIST-SEQ-NO                                        
MFA-TR*            ,:H-CODE-TRAN-TYPE                                           
MFA-TR*            ,:H-APPL-PROGRAM-ID                                          
MFA-TR*            ,:H-USER-ID                                                  
MFA-TR*            ,:H-RESP-AREA-ID                                             
MFA-TR*            ,:H-TRAN-COMMENT                                             
MFA-TR*            ,:H-ACCOUNT-NO                                               
MFA-TR*            ,:H-CUSTOMER-NO                                              
MFA-TR*            ,:H-PREMISE-NO                                               
MFA-TR*            ,:H-TABLE-CD                                                 
MFA-TR*    END-EXEC.                                                            

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-TRNS-HDR-CUST
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              MOVE SQLERRD(3)                 TO WS-HDR-FETCH-COUNT     
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7210'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_MNT_TRANS_HIST'       TO TABLE-1                
              MOVE 'CUSTOMER_NO'              TO TABLE-ELEMENT-1        
              MOVE 'TRNS_HIST_FROM_TS'        TO TABLE-ELEMENT-2        
              MOVE 'TRNS_HIST_TO_TS'          TO TABLE-ELEMENT-3        
              MOVE 'CODE_TRAN_TYPE'           TO TABLE-ELEMENT-4        
              MOVE MH-CUSTOMER-NO             TO HOSTVAR-ELEMENT-1      
              MOVE PARM-TRNS-HIST-FROM-TS     TO HOSTVAR-ELEMENT-2      
              MOVE PARM-TRNS-HIST-TO-TS       TO HOSTVAR-ELEMENT-3      
              MOVE PARM-CODE-TRAN-TYPE        TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** CLOSE MAINTAIN TRNS HIST CURSOR-CUSTOMER ONLY                **        
      ******************************************************************        
      *                                                                         
       7220-CLOSE-TRNS-HDR-CUST.                                        
      *                                                                         
           EXEC SQL                                                     
              CLOSE TRNS_HDR_CUST                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7220'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_MNT_TRANS_HIST'       TO TABLE-1                
              MOVE 'CUSTOMER_NO'              TO TABLE-ELEMENT-1        
              MOVE 'TRNS_HIST_FROM_TS'        TO TABLE-ELEMENT-2        
              MOVE 'TRNS_HIST_TO_TS'          TO TABLE-ELEMENT-3        
              MOVE 'CODE_TRAN_TYPE'           TO TABLE-ELEMENT-4        
              MOVE MH-CUSTOMER-NO             TO HOSTVAR-ELEMENT-1      
              MOVE PARM-TRNS-HIST-FROM-TS     TO HOSTVAR-ELEMENT-2      
              MOVE PARM-TRNS-HIST-TO-TS       TO HOSTVAR-ELEMENT-3      
              MOVE PARM-CODE-TRAN-TYPE        TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** OPEN MAINTAIN TRNS HIST CURSOR-PREMISE ONLY                  **        
      ******************************************************************        
      *                                                                         
       7250-OPEN-TRNS-HDR-PREM.                                         
      *                                                                         
           EXEC SQL                                                     
               OPEN TRNS_HDR_PREM                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7250'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_MNT_TRANS_HIST'       TO TABLE-1                
              MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-1        
              MOVE 'TRNS_HIST_FROM_TS'        TO TABLE-ELEMENT-2        
              MOVE 'TRNS_HIST_TO_TS'          TO TABLE-ELEMENT-3        
              MOVE 'CODE_TRAN_TYPE'           TO TABLE-ELEMENT-4        
              MOVE MH-PREMISE-NO              TO HOSTVAR-ELEMENT-1      
              MOVE PARM-TRNS-HIST-FROM-TS     TO HOSTVAR-ELEMENT-2      
              MOVE PARM-TRNS-HIST-TO-TS       TO HOSTVAR-ELEMENT-3      
              MOVE PARM-CODE-TRAN-TYPE        TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** FETCH MAINTAIN TRNS HIST CURSOR-PREMISE ONLY                 **        
      ******************************************************************        
      *                                                                         
       7260-FETCH-TRNS-HDR-PREM.                                        

MSQ008     MOVE 21 TO MSQ008-TRNS-HDR-PREM
      *                                                                         
           EXEC SQL                                                     
              FOR :MSQ008-TRNS-HDR-PREM
              FETCH 
              FROM TRNS_HDR_PREM           
               INTO :H-TRANS-HIST-SEQ-NO                                
                   ,:H-CODE-TRAN-TYPE                                   
                   ,:H-APPL-PROGRAM-ID                                  
                   ,:H-USER-ID                                          
                   ,:H-RESP-AREA-ID                                     
                   ,:H-TRAN-COMMENT                                     
                   ,:H-ACCOUNT-NO                                       
                   ,:H-CUSTOMER-NO                                      
                   ,:H-PREMISE-NO                                       
                   ,:H-TABLE-CD                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                             
MFA-TR*       FETCH NEXT ROWSET FROM TRNS_HDR_PREM FOR 21 ROWS                  
MFA-TR*        INTO :H-TRANS-HIST-SEQ-NO                                        
MFA-TR*            ,:H-CODE-TRAN-TYPE                                           
MFA-TR*            ,:H-APPL-PROGRAM-ID                                          
MFA-TR*            ,:H-USER-ID                                                  
MFA-TR*            ,:H-RESP-AREA-ID                                             
MFA-TR*            ,:H-TRAN-COMMENT                                             
MFA-TR*            ,:H-ACCOUNT-NO                                               
MFA-TR*            ,:H-CUSTOMER-NO                                              
MFA-TR*            ,:H-PREMISE-NO                                               
MFA-TR*            ,:H-TABLE-CD                                                 
MFA-TR*    END-EXEC.                                                            

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-TRNS-HDR-PREM
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              MOVE SQLERRD(3)                 TO WS-HDR-FETCH-COUNT     
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7260'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_MNT_TRANS_HIST'       TO TABLE-1                
              MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-1        
              MOVE 'TRNS_HIST_FROM_TS'        TO TABLE-ELEMENT-2        
              MOVE 'TRNS_HIST_TO_TS'          TO TABLE-ELEMENT-3        
              MOVE 'CODE_TRAN_TYPE'           TO TABLE-ELEMENT-4        
              MOVE MH-PREMISE-NO              TO HOSTVAR-ELEMENT-1      
              MOVE PARM-TRNS-HIST-FROM-TS     TO HOSTVAR-ELEMENT-2      
              MOVE PARM-TRNS-HIST-TO-TS       TO HOSTVAR-ELEMENT-3      
              MOVE PARM-CODE-TRAN-TYPE        TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7260-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** CLOSE MAINTAIN TRNS HIST CURSOR-PREMISE ONLY                 **        
      ******************************************************************        
      *                                                                         
       7270-CLOSE-TRNS-HDR-PREM.                                        
      *                                                                         
           EXEC SQL                                                     
              CLOSE TRNS_HDR_PREM                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7270'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_MNT_TRANS_HIST'       TO TABLE-1                
              MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-1        
              MOVE 'TRNS_HIST_FROM_TS'        TO TABLE-ELEMENT-2        
              MOVE 'TRNS_HIST_TO_TS'          TO TABLE-ELEMENT-3        
              MOVE 'CODE_TRAN_TYPE'           TO TABLE-ELEMENT-4        
              MOVE MH-PREMISE-NO              TO HOSTVAR-ELEMENT-1      
              MOVE PARM-TRNS-HIST-FROM-TS     TO HOSTVAR-ELEMENT-2      
              MOVE PARM-TRNS-HIST-TO-TS       TO HOSTVAR-ELEMENT-3      
              MOVE PARM-CODE-TRAN-TYPE        TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7270-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** OPEN ACCT RECV/MAINTAIN TRNS HIST CURSOR-RESP AREA ID        **        
      ******************************************************************        
      *                                                                         
       7300-OPEN-TRNS-HDR-RESP.                                         
      *                                                                         
           EXEC SQL                                                     
               OPEN TRNS_HDR_RESP                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7300'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_AR_TRANS_HIST'        TO TABLE-1                
              MOVE 'RESP_AREA_ID'             TO TABLE-ELEMENT-1        
              MOVE 'TRNS_HIST_FROM_TS'        TO TABLE-ELEMENT-2        
              MOVE 'TRNS_HIST_TO_TS'          TO TABLE-ELEMENT-3        
              MOVE 'CODE_TRAN_TYPE'           TO TABLE-ELEMENT-4        
              MOVE AR-RESP-AREA-ID            TO HOSTVAR-ELEMENT-1      
              MOVE PARM-TRNS-HIST-FROM-TS     TO HOSTVAR-ELEMENT-2      
              MOVE PARM-TRNS-HIST-TO-TS       TO HOSTVAR-ELEMENT-3      
              MOVE PARM-CODE-TRAN-TYPE        TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** FETCH ACCT RECV/MAINTAIN TRNS HIST CURSOR-RESP AREA ID       **        
      ******************************************************************        
      *                                                                         
       7310-FETCH-TRNS-HDR-RESP.                                        

MSQ008     MOVE 21 TO MSQ008-TRNS-HDR-RESP
      *                                                                         
           EXEC SQL                                                     
              FOR :MSQ008-TRNS-HDR-RESP
              FETCH 
              FROM TRNS_HDR_RESP           
               INTO :H-TRANS-HIST-SEQ-NO                                
                   ,:H-CODE-TRAN-TYPE                                   
                   ,:H-APPL-PROGRAM-ID                                  
                   ,:H-USER-ID                                          
                   ,:H-RESP-AREA-ID                                     
                   ,:H-TRAN-COMMENT                                     
                   ,:H-ACCOUNT-NO                                       
                   ,:H-CUSTOMER-NO                                      
                   ,:H-PREMISE-NO                                       
                   ,:H-AMT-ORIG-ENTERED                                 
                   ,:H-AMT-BILLED-UNPAID                                
                   ,:H-RECORD-ONLY-FL                                   
PRJ586             ,:H-PYMT-REFUNDED-IND                                
                   ,:H-CASH-LOCAL-OFFICE                                
                   ,:H-CASH-REPORT-NO                                   
                   ,:H-DATE-CASH-REPORT                                 
                   ,:H-DATE-ORIG-PYMT                                   
                   ,:H-CASH-DRAWER-ID                                   
                   ,:H-PYMT-FACILITY-CD                                 
                   ,:H-TABLE-CD                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                             
MFA-TR*       FETCH NEXT ROWSET FROM TRNS_HDR_RESP FOR 21 ROWS                  
MFA-TR*        INTO :H-TRANS-HIST-SEQ-NO                                        
MFA-TR*            ,:H-CODE-TRAN-TYPE                                           
MFA-TR*            ,:H-APPL-PROGRAM-ID                                          
MFA-TR*            ,:H-USER-ID                                                  
MFA-TR*            ,:H-RESP-AREA-ID                                             
MFA-TR*            ,:H-TRAN-COMMENT                                             
MFA-TR*            ,:H-ACCOUNT-NO                                               
MFA-TR*            ,:H-CUSTOMER-NO                                              
MFA-TR*            ,:H-PREMISE-NO                                               
MFA-TR*            ,:H-AMT-ORIG-ENTERED                                         
MFA-TR*            ,:H-AMT-BILLED-UNPAID                                        
MFA-TR*            ,:H-RECORD-ONLY-FL                                           
MFA-TR*            ,:H-PYMT-REFUNDED-IND                                        
MFA-TR*            ,:H-CASH-LOCAL-OFFICE                                        
MFA-TR*            ,:H-CASH-REPORT-NO                                           
MFA-TR*            ,:H-DATE-CASH-REPORT                                         
MFA-TR*            ,:H-DATE-ORIG-PYMT                                           
MFA-TR*            ,:H-CASH-DRAWER-ID                                           
MFA-TR*            ,:H-PYMT-FACILITY-CD                                         
MFA-TR*            ,:H-TABLE-CD                                                 
MFA-TR*    END-EXEC.                                                            

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-TRNS-HDR-RESP
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              MOVE SQLERRD(3)                 TO WS-HDR-FETCH-COUNT     
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7310'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_AR_TRANS_HIST'        TO TABLE-1                
              MOVE 'RESP_AREA_ID'             TO TABLE-ELEMENT-1        
              MOVE 'TRNS_HIST_FROM_TS'        TO TABLE-ELEMENT-2        
              MOVE 'TRNS_HIST_TO_TS'          TO TABLE-ELEMENT-3        
              MOVE 'CODE_TRAN_TYPE'           TO TABLE-ELEMENT-4        
              MOVE AR-RESP-AREA-ID            TO HOSTVAR-ELEMENT-1      
              MOVE PARM-TRNS-HIST-FROM-TS     TO HOSTVAR-ELEMENT-2      
              MOVE PARM-TRNS-HIST-TO-TS       TO HOSTVAR-ELEMENT-3      
              MOVE PARM-CODE-TRAN-TYPE        TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7310-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** CLOSE ACCT RECV/MAINTAIN TRNS HIST CURSOR-RESP AREA ID       **        
      ******************************************************************        
      *                                                                         
       7320-CLOSE-TRNS-HDR-RESP.                                        
      *                                                                         
           EXEC SQL                                                     
              CLOSE TRNS_HDR_RESP                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7320'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_AR_TRANS_HIST'        TO TABLE-1                
              MOVE 'RESP_AREA_ID'             TO TABLE-ELEMENT-1        
              MOVE 'TRNS_HIST_FROM_TS'        TO TABLE-ELEMENT-2        
              MOVE 'TRNS_HIST_TO_TS'          TO TABLE-ELEMENT-3        
              MOVE 'CODE_TRAN_TYPE'           TO TABLE-ELEMENT-4        
              MOVE AR-RESP-AREA-ID            TO HOSTVAR-ELEMENT-1      
              MOVE PARM-TRNS-HIST-FROM-TS     TO HOSTVAR-ELEMENT-2      
              MOVE PARM-TRNS-HIST-TO-TS       TO HOSTVAR-ELEMENT-3      
              MOVE PARM-CODE-TRAN-TYPE        TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7320-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** OPEN ACCT RECV TRANS HIST DATA ONLY-RESP AREA ID & AR ONLY   **        
      ******************************************************************        
      *                                                                         
       7350-OPEN-TRNS-HDR-RESP-AR.                                      
      *                                                                         
           EXEC SQL                                                     
               OPEN TRNS_HDR_RESP_AR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7350'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_AR_TRANS_HIST'        TO TABLE-1                
              MOVE 'RESP_AREA_ID'             TO TABLE-ELEMENT-1        
              MOVE 'TRNS_HIST_FROM_TS'        TO TABLE-ELEMENT-2        
              MOVE 'TRNS_HIST_TO_TS'          TO TABLE-ELEMENT-3        
              MOVE 'CODE_TRAN_TYPE'           TO TABLE-ELEMENT-4        
              MOVE AR-RESP-AREA-ID            TO HOSTVAR-ELEMENT-1      
              MOVE PARM-TRNS-HIST-FROM-TS     TO HOSTVAR-ELEMENT-2      
              MOVE PARM-TRNS-HIST-TO-TS       TO HOSTVAR-ELEMENT-3      
              MOVE PARM-CODE-TRAN-TYPE        TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** FETCH ACCT RECV TRANS HIST DATA ONLY-RESP AREA ID & AR ONLY  **        
      ******************************************************************        
      *                                                                         
       7360-FETCH-TRNS-HDR-RESP-AR.                                     

MSQ008     MOVE 21 TO MSQ008-TRNS-HDR-RESP-AR
      *                                                                         
           EXEC SQL                                                     
              FOR :MSQ008-TRNS-HDR-RESP-AR
              FETCH 
              FROM TRNS_HDR_RESP_AR        
               INTO :H-TRANS-HIST-SEQ-NO                                
                   ,:H-CODE-TRAN-TYPE                                   
                   ,:H-APPL-PROGRAM-ID                                  
                   ,:H-USER-ID                                          
                   ,:H-RESP-AREA-ID                                     
                   ,:H-TRAN-COMMENT                                     
                   ,:H-ACCOUNT-NO                                       
                   ,:H-CUSTOMER-NO                                      
                   ,:H-PREMISE-NO                                       
                   ,:H-AMT-ORIG-ENTERED                                 
                   ,:H-AMT-BILLED-UNPAID                                
                   ,:H-RECORD-ONLY-FL                                   
PRJ586             ,:H-PYMT-REFUNDED-IND                                
                   ,:H-CASH-LOCAL-OFFICE                                
                   ,:H-CASH-REPORT-NO                                   
                   ,:H-DATE-CASH-REPORT                                 
                   ,:H-DATE-ORIG-PYMT                                   
                   ,:H-CASH-DRAWER-ID                                   
                   ,:H-PYMT-FACILITY-CD                                 
                   ,:H-TABLE-CD                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                             
MFA-TR*       FETCH NEXT ROWSET FROM TRNS_HDR_RESP_AR FOR 21 ROWS               
MFA-TR*        INTO :H-TRANS-HIST-SEQ-NO                                        
MFA-TR*            ,:H-CODE-TRAN-TYPE                                           
MFA-TR*            ,:H-APPL-PROGRAM-ID                                          
MFA-TR*            ,:H-USER-ID                                                  
MFA-TR*            ,:H-RESP-AREA-ID                                             
MFA-TR*            ,:H-TRAN-COMMENT                                             
MFA-TR*            ,:H-ACCOUNT-NO                                               
MFA-TR*            ,:H-CUSTOMER-NO                                              
MFA-TR*            ,:H-PREMISE-NO                                               
MFA-TR*            ,:H-AMT-ORIG-ENTERED                                         
MFA-TR*            ,:H-AMT-BILLED-UNPAID                                        
MFA-TR*            ,:H-RECORD-ONLY-FL                                           
MFA-TR*            ,:H-PYMT-REFUNDED-IND                                        
MFA-TR*            ,:H-CASH-LOCAL-OFFICE                                        
MFA-TR*            ,:H-CASH-REPORT-NO                                           
MFA-TR*            ,:H-DATE-CASH-REPORT                                         
MFA-TR*            ,:H-DATE-ORIG-PYMT                                           
MFA-TR*            ,:H-CASH-DRAWER-ID                                           
MFA-TR*            ,:H-PYMT-FACILITY-CD                                         
MFA-TR*            ,:H-TABLE-CD                                                 
MFA-TR*    END-EXEC.                                                            

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-TRNS-HDR-RESP-AR
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              MOVE SQLERRD(3)                 TO WS-HDR-FETCH-COUNT     
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7360'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_AR_TRANS_HIST'        TO TABLE-1                
              MOVE 'RESP_AREA_ID'             TO TABLE-ELEMENT-1        
              MOVE 'TRNS_HIST_FROM_TS'        TO TABLE-ELEMENT-2        
              MOVE 'TRNS_HIST_TO_TS'          TO TABLE-ELEMENT-3        
              MOVE 'CODE_TRAN_TYPE'           TO TABLE-ELEMENT-4        
              MOVE AR-RESP-AREA-ID            TO HOSTVAR-ELEMENT-1      
              MOVE PARM-TRNS-HIST-FROM-TS     TO HOSTVAR-ELEMENT-2      
              MOVE PARM-TRNS-HIST-TO-TS       TO HOSTVAR-ELEMENT-3      
              MOVE PARM-CODE-TRAN-TYPE        TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7360-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** CLOSE ACCT RECV TRANS HIST DATA ONLY-RESP AREA ID & AR ONLY  **        
      ******************************************************************        
      *                                                                         
       7370-CLOSE-TRNS-HDR-RESP-AR.                                     
      *                                                                         
           EXEC SQL                                                     
              CLOSE TRNS_HDR_RESP_AR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7370'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_AR_TRANS_HIST'        TO TABLE-1                
              MOVE 'RESP_AREA_ID'             TO TABLE-ELEMENT-1        
              MOVE 'TRNS_HIST_FROM_TS'        TO TABLE-ELEMENT-2        
              MOVE 'TRNS_HIST_TO_TS'          TO TABLE-ELEMENT-3        
              MOVE 'CODE_TRAN_TYPE'           TO TABLE-ELEMENT-4        
              MOVE AR-RESP-AREA-ID            TO HOSTVAR-ELEMENT-1      
              MOVE PARM-TRNS-HIST-FROM-TS     TO HOSTVAR-ELEMENT-2      
              MOVE PARM-TRNS-HIST-TO-TS       TO HOSTVAR-ELEMENT-3      
              MOVE PARM-CODE-TRAN-TYPE        TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7370-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** OPEN MAINTAIN TRANS HIST HDR DATA ONLY-RESP AREA ID & MH     **        
      ******************************************************************        
      *                                                                         
       7400-OPEN-TRNS-HDR-RESP-MH.                                      
      *                                                                         
           EXEC SQL                                                     
               OPEN TRNS_HDR_RESP_MH                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7400'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_MNT_TRANS_HIST'       TO TABLE-1                
              MOVE 'RESP_AREA_ID'             TO TABLE-ELEMENT-1        
              MOVE 'TRNS_HIST_FROM_TS'        TO TABLE-ELEMENT-2        
              MOVE 'TRNS_HIST_TO_TS'          TO TABLE-ELEMENT-3        
              MOVE 'CODE_TRAN_TYPE'           TO TABLE-ELEMENT-4        
              MOVE MH-RESP-AREA-ID            TO HOSTVAR-ELEMENT-1      
              MOVE PARM-TRNS-HIST-FROM-TS     TO HOSTVAR-ELEMENT-2      
              MOVE PARM-TRNS-HIST-TO-TS       TO HOSTVAR-ELEMENT-3      
              MOVE PARM-CODE-TRAN-TYPE        TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** FETCH MAINTAIN TRANS HIST HDR DATA ONLY-RESP AREA ID & MH    **        
      ******************************************************************        
      *                                                                         
       7410-FETCH-TRNS-HDR-RESP-MH.                                     

MSQ008     MOVE 21 TO MSQ008-TRNS-HDR-RESP-MH
      *                                                                         
           EXEC SQL                                                     
              FOR :MSQ008-TRNS-HDR-RESP-MH
              FETCH 
              FROM TRNS_HDR_RESP_MH        
               INTO :H-TRANS-HIST-SEQ-NO                                
                   ,:H-CODE-TRAN-TYPE                                   
                   ,:H-APPL-PROGRAM-ID                                  
                   ,:H-USER-ID                                          
                   ,:H-RESP-AREA-ID                                     
                   ,:H-TRAN-COMMENT                                     
                   ,:H-ACCOUNT-NO                                       
                   ,:H-CUSTOMER-NO                                      
                   ,:H-PREMISE-NO                                       
                   ,:H-AMT-ORIG-ENTERED                                 
                   ,:H-AMT-BILLED-UNPAID                                
                   ,:H-RECORD-ONLY-FL                                   
PRJ586             ,:H-PYMT-REFUNDED-IND                                
                   ,:H-CASH-LOCAL-OFFICE                                
                   ,:H-CASH-REPORT-NO                                   
                   ,:H-DATE-CASH-REPORT                                 
                   ,:H-DATE-ORIG-PYMT                                   
                   ,:H-CASH-DRAWER-ID                                   
                   ,:H-PYMT-FACILITY-CD                                 
                   ,:H-TABLE-CD                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                             
MFA-TR*       FETCH NEXT ROWSET FROM TRNS_HDR_RESP_MH FOR 21 ROWS               
MFA-TR*        INTO :H-TRANS-HIST-SEQ-NO                                        
MFA-TR*            ,:H-CODE-TRAN-TYPE                                           
MFA-TR*            ,:H-APPL-PROGRAM-ID                                          
MFA-TR*            ,:H-USER-ID                                                  
MFA-TR*            ,:H-RESP-AREA-ID                                             
MFA-TR*            ,:H-TRAN-COMMENT                                             
MFA-TR*            ,:H-ACCOUNT-NO                                               
MFA-TR*            ,:H-CUSTOMER-NO                                              
MFA-TR*            ,:H-PREMISE-NO                                               
MFA-TR*            ,:H-AMT-ORIG-ENTERED                                         
MFA-TR*            ,:H-AMT-BILLED-UNPAID                                        
MFA-TR*            ,:H-RECORD-ONLY-FL                                           
MFA-TR*            ,:H-PYMT-REFUNDED-IND                                        
MFA-TR*            ,:H-CASH-LOCAL-OFFICE                                        
MFA-TR*            ,:H-CASH-REPORT-NO                                           
MFA-TR*            ,:H-DATE-CASH-REPORT                                         
MFA-TR*            ,:H-DATE-ORIG-PYMT                                           
MFA-TR*            ,:H-CASH-DRAWER-ID                                           
MFA-TR*            ,:H-PYMT-FACILITY-CD                                         
MFA-TR*            ,:H-TABLE-CD                                                 
MFA-TR*    END-EXEC.                                                            

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-TRNS-HDR-RESP-MH
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              MOVE SQLERRD(3)                 TO WS-HDR-FETCH-COUNT     
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7410'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_MNT_TRANS_HIST'       TO TABLE-1                
              MOVE 'RESP_AREA_ID'             TO TABLE-ELEMENT-1        
              MOVE 'TRNS_HIST_FROM_TS'        TO TABLE-ELEMENT-2        
              MOVE 'TRNS_HIST_TO_TS'          TO TABLE-ELEMENT-3        
              MOVE 'CODE_TRAN_TYPE'           TO TABLE-ELEMENT-4        
              MOVE MH-RESP-AREA-ID            TO HOSTVAR-ELEMENT-1      
              MOVE PARM-TRNS-HIST-FROM-TS     TO HOSTVAR-ELEMENT-2      
              MOVE PARM-TRNS-HIST-TO-TS       TO HOSTVAR-ELEMENT-3      
              MOVE PARM-CODE-TRAN-TYPE        TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7410-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** CLOSE MAINTAIN TRANS HIST HDR DATA ONLY-RESP AREA ID & MH    **        
      ******************************************************************        
      *                                                                         
       7420-CLOSE-TRNS-HDR-RESP-MH.                                     
      *                                                                         
           EXEC SQL                                                     
              CLOSE TRNS_HDR_RESP_MH                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7420'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_MNT_TRANS_HIST'       TO TABLE-1                
              MOVE 'RESP_AREA_ID'             TO TABLE-ELEMENT-1        
              MOVE 'TRNS_HIST_FROM_TS'        TO TABLE-ELEMENT-2        
              MOVE 'TRNS_HIST_TO_TS'          TO TABLE-ELEMENT-3        
              MOVE 'CODE_TRAN_TYPE'           TO TABLE-ELEMENT-4        
              MOVE MH-RESP-AREA-ID            TO HOSTVAR-ELEMENT-1      
              MOVE PARM-TRNS-HIST-FROM-TS     TO HOSTVAR-ELEMENT-2      
              MOVE PARM-TRNS-HIST-TO-TS       TO HOSTVAR-ELEMENT-3      
              MOVE PARM-CODE-TRAN-TYPE        TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7420-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** OPEN ACCT RECV/MAINTAIN TRNS HIST CUSROR-USER ID & ACCOUNT   **        
      ******************************************************************        
      *                                                                         
       7450-OPEN-TRNS-HDR-UID-ACCT.                                     
      *                                                                         
           EXEC SQL                                                     
               OPEN TRNS_HDR_UID_ACCT                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7450'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_AR_TRANS_HIST'        TO TABLE-1                
              MOVE 'USER_ID'                  TO TABLE-ELEMENT-1        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE 'TRNS_HIST_FROM_TS'        TO TABLE-ELEMENT-3        
              MOVE 'TRNS_HIST_TO_TS'          TO TABLE-ELEMENT-4        
              MOVE AR-USER-ID                 TO HOSTVAR-ELEMENT-1      
              MOVE AR-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
              MOVE PARM-TRNS-HIST-FROM-TS     TO HOSTVAR-ELEMENT-3      
              MOVE PARM-TRNS-HIST-TO-TS       TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7450-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** FETCH ACCT RECV/MAINTAIN TRNS HIST CUSROR-USER ID & ACCOUNT  **        
      ******************************************************************        
      *                                                                         
       7460-FETCH-TRNS-HDR-UID-ACCT.                                    

MSQ008     MOVE 21 TO MSQ008-TRNS-HDR-UID-ACCT
      *                                                                         
           EXEC SQL                                                     
              FOR :MSQ008-TRNS-HDR-UID-ACCT
              FETCH 
              FROM TRNS_HDR_UID_ACCT       
               INTO :H-TRANS-HIST-SEQ-NO                                
                   ,:H-CODE-TRAN-TYPE                                   
                   ,:H-APPL-PROGRAM-ID                                  
                   ,:H-USER-ID                                          
                   ,:H-RESP-AREA-ID                                     
                   ,:H-TRAN-COMMENT                                     
                   ,:H-ACCOUNT-NO                                       
                   ,:H-CUSTOMER-NO                                      
                   ,:H-PREMISE-NO                                       
                   ,:H-AMT-ORIG-ENTERED                                 
                   ,:H-AMT-BILLED-UNPAID                                
                   ,:H-RECORD-ONLY-FL                                   
PRJ586             ,:H-PYMT-REFUNDED-IND                                
                   ,:H-CASH-LOCAL-OFFICE                                
                   ,:H-CASH-REPORT-NO                                   
                   ,:H-DATE-CASH-REPORT                                 
                   ,:H-DATE-ORIG-PYMT                                   
                   ,:H-CASH-DRAWER-ID                                   
                   ,:H-PYMT-FACILITY-CD                                 
                   ,:H-TABLE-CD                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                             
MFA-TR*       FETCH NEXT ROWSET FROM TRNS_HDR_UID_ACCT FOR 21 ROWS              
MFA-TR*        INTO :H-TRANS-HIST-SEQ-NO                                        
MFA-TR*            ,:H-CODE-TRAN-TYPE                                           
MFA-TR*            ,:H-APPL-PROGRAM-ID                                          
MFA-TR*            ,:H-USER-ID                                                  
MFA-TR*            ,:H-RESP-AREA-ID                                             
MFA-TR*            ,:H-TRAN-COMMENT                                             
MFA-TR*            ,:H-ACCOUNT-NO                                               
MFA-TR*            ,:H-CUSTOMER-NO                                              
MFA-TR*            ,:H-PREMISE-NO                                               
MFA-TR*            ,:H-AMT-ORIG-ENTERED                                         
MFA-TR*            ,:H-AMT-BILLED-UNPAID                                        
MFA-TR*            ,:H-RECORD-ONLY-FL                                           
MFA-TR*            ,:H-PYMT-REFUNDED-IND                                        
MFA-TR*            ,:H-CASH-LOCAL-OFFICE                                        
MFA-TR*            ,:H-CASH-REPORT-NO                                           
MFA-TR*            ,:H-DATE-CASH-REPORT                                         
MFA-TR*            ,:H-DATE-ORIG-PYMT                                           
MFA-TR*            ,:H-CASH-DRAWER-ID                                           
MFA-TR*            ,:H-PYMT-FACILITY-CD                                         
MFA-TR*            ,:H-TABLE-CD                                                 
MFA-TR*    END-EXEC.                                                            

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-TRNS-HDR-UID-ACCT
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              MOVE SQLERRD(3)                 TO WS-HDR-FETCH-COUNT     
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7460'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_AR_TRANS_HIST'        TO TABLE-1                
              MOVE 'USER_ID'                  TO TABLE-ELEMENT-1        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE 'TRNS_HIST_FROM_TS'        TO TABLE-ELEMENT-3        
              MOVE 'TRNS_HIST_TO_TS'          TO TABLE-ELEMENT-4        
              MOVE AR-USER-ID                 TO HOSTVAR-ELEMENT-1      
              MOVE AR-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
              MOVE PARM-TRNS-HIST-FROM-TS     TO HOSTVAR-ELEMENT-3      
              MOVE PARM-TRNS-HIST-TO-TS       TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7460-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** CLOSE ACCT RECV/MAINTAIN TRNS HIST CUSROR-USER ID & ACCOUNT  **        
      ******************************************************************        
      *                                                                         
       7470-CLOSE-TRNS-HDR-UID-ACCT.                                    
      *                                                                         
           EXEC SQL                                                     
              CLOSE TRNS_HDR_UID_ACCT                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7470'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_AR_TRANS_HIST'        TO TABLE-1                
              MOVE 'USER_ID'                  TO TABLE-ELEMENT-1        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE 'TRNS_HIST_FROM_TS'        TO TABLE-ELEMENT-3        
              MOVE 'TRNS_HIST_TO_TS'          TO TABLE-ELEMENT-4        
              MOVE AR-USER-ID                 TO HOSTVAR-ELEMENT-1      
              MOVE AR-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
              MOVE PARM-TRNS-HIST-FROM-TS     TO HOSTVAR-ELEMENT-3      
              MOVE PARM-TRNS-HIST-TO-TS       TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7470-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** OPEN ACCT RECV/MAINTAIN TRNS HIST CUSROR-USER ID             **        
      ******************************************************************        
      *                                                                         
       7500-OPEN-TRNS-HDR-UID.                                          
      *                                                                         
           EXEC SQL                                                     
               OPEN TRNS_HDR_UID                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7500'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_AR_TRANS_HIST'        TO TABLE-1                
              MOVE 'USER_ID'                  TO TABLE-ELEMENT-1        
              MOVE 'TRNS_HIST_FROM_TS'        TO TABLE-ELEMENT-2        
              MOVE 'TRNS_HIST_TO_TS'          TO TABLE-ELEMENT-3        
              MOVE 'CODE_TRAN_TYPE'           TO TABLE-ELEMENT-4        
              MOVE AR-USER-ID                 TO HOSTVAR-ELEMENT-1      
              MOVE PARM-TRNS-HIST-FROM-TS     TO HOSTVAR-ELEMENT-2      
              MOVE PARM-TRNS-HIST-TO-TS       TO HOSTVAR-ELEMENT-3      
              MOVE PARM-CODE-TRAN-TYPE        TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** FETCH ACCT RECV/MAINTAIN TRNS HIST CUSROR-USER ID            **        
      ******************************************************************        
      *                                                                         
       7510-FETCH-TRNS-HDR-UID.                                         

MSQ008     MOVE 21 TO MSQ008-TRNS-HDR-UID
      *                                                                         
           EXEC SQL                                                     
              FOR :MSQ008-TRNS-HDR-UID
              FETCH 
              FROM TRNS_HDR_UID            
               INTO :H-TRANS-HIST-SEQ-NO                                
                   ,:H-CODE-TRAN-TYPE                                   
                   ,:H-APPL-PROGRAM-ID                                  
                   ,:H-USER-ID                                          
                   ,:H-RESP-AREA-ID                                     
                   ,:H-TRAN-COMMENT                                     
                   ,:H-ACCOUNT-NO                                       
                   ,:H-CUSTOMER-NO                                      
                   ,:H-PREMISE-NO                                       
                   ,:H-AMT-ORIG-ENTERED                                 
                   ,:H-AMT-BILLED-UNPAID                                
                   ,:H-RECORD-ONLY-FL                                   
PRJ586             ,:H-PYMT-REFUNDED-IND                                
                   ,:H-CASH-LOCAL-OFFICE                                
                   ,:H-CASH-REPORT-NO                                   
                   ,:H-DATE-CASH-REPORT                                 
                   ,:H-DATE-ORIG-PYMT                                   
                   ,:H-CASH-DRAWER-ID                                   
                   ,:H-PYMT-FACILITY-CD                                 
                   ,:H-TABLE-CD                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                             
MFA-TR*       FETCH NEXT ROWSET FROM TRNS_HDR_UID FOR 21 ROWS                   
MFA-TR*        INTO :H-TRANS-HIST-SEQ-NO                                        
MFA-TR*            ,:H-CODE-TRAN-TYPE                                           
MFA-TR*            ,:H-APPL-PROGRAM-ID                                          
MFA-TR*            ,:H-USER-ID                                                  
MFA-TR*            ,:H-RESP-AREA-ID                                             
MFA-TR*            ,:H-TRAN-COMMENT                                             
MFA-TR*            ,:H-ACCOUNT-NO                                               
MFA-TR*            ,:H-CUSTOMER-NO                                              
MFA-TR*            ,:H-PREMISE-NO                                               
MFA-TR*            ,:H-AMT-ORIG-ENTERED                                         
MFA-TR*            ,:H-AMT-BILLED-UNPAID                                        
MFA-TR*            ,:H-RECORD-ONLY-FL                                           
MFA-TR*            ,:H-PYMT-REFUNDED-IND                                        
MFA-TR*            ,:H-CASH-LOCAL-OFFICE                                        
MFA-TR*            ,:H-CASH-REPORT-NO                                           
MFA-TR*            ,:H-DATE-CASH-REPORT                                         
MFA-TR*            ,:H-DATE-ORIG-PYMT                                           
MFA-TR*            ,:H-CASH-DRAWER-ID                                           
MFA-TR*            ,:H-PYMT-FACILITY-CD                                         
MFA-TR*            ,:H-TABLE-CD                                                 
MFA-TR*    END-EXEC.                                                            

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-TRNS-HDR-UID
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              MOVE SQLERRD(3)                 TO WS-HDR-FETCH-COUNT     
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7510'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_AR_TRANS_HIST'        TO TABLE-1                
              MOVE 'USER_ID'                  TO TABLE-ELEMENT-1        
              MOVE 'TRNS_HIST_FROM_TS'        TO TABLE-ELEMENT-2        
              MOVE 'TRNS_HIST_TO_TS'          TO TABLE-ELEMENT-3        
              MOVE 'CODE_TRAN_TYPE'           TO TABLE-ELEMENT-4        
              MOVE AR-USER-ID                 TO HOSTVAR-ELEMENT-1      
              MOVE PARM-TRNS-HIST-FROM-TS     TO HOSTVAR-ELEMENT-2      
              MOVE PARM-TRNS-HIST-TO-TS       TO HOSTVAR-ELEMENT-3      
              MOVE PARM-CODE-TRAN-TYPE        TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7510-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** CLOSE ACCT RECV/MAINTAIN TRNS HIST CUSROR-USER ID            **        
      ******************************************************************        
      *                                                                         
       7520-CLOSE-TRNS-HDR-UID.                                         
      *                                                                         
           EXEC SQL                                                     
              CLOSE TRNS_HDR_UID                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7520'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_AR_TRANS_HIST'        TO TABLE-1                
              MOVE 'USER_ID'                  TO TABLE-ELEMENT-1        
              MOVE 'TRNS_HIST_FROM_TS'        TO TABLE-ELEMENT-2        
              MOVE 'TRNS_HIST_TO_TS'          TO TABLE-ELEMENT-3        
              MOVE 'CODE_TRAN_TYPE'           TO TABLE-ELEMENT-4        
              MOVE AR-USER-ID                 TO HOSTVAR-ELEMENT-1      
              MOVE PARM-TRNS-HIST-FROM-TS     TO HOSTVAR-ELEMENT-2      
              MOVE PARM-TRNS-HIST-TO-TS       TO HOSTVAR-ELEMENT-3      
              MOVE PARM-CODE-TRAN-TYPE        TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7520-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** OPEN ACCT RECV TRANS HIST ONLY CUSROR-USER ID & AR ONLY      **        
      ******************************************************************        
      *                                                                         
       7550-OPEN-TRNS-HDR-UID-AR.                                       
      *                                                                         
           EXEC SQL                                                     
               OPEN TRNS_HDR_UID_AR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7550'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_AR_TRANS_HIST'        TO TABLE-1                
              MOVE 'USER_ID'                  TO TABLE-ELEMENT-1        
              MOVE 'TRNS_HIST_FROM_TS'        TO TABLE-ELEMENT-2        
              MOVE 'TRNS_HIST_TO_TS'          TO TABLE-ELEMENT-3        
              MOVE 'CODE_TRAN_TYPE'           TO TABLE-ELEMENT-4        
              MOVE AR-USER-ID                 TO HOSTVAR-ELEMENT-1      
              MOVE PARM-TRNS-HIST-FROM-TS     TO HOSTVAR-ELEMENT-2      
              MOVE PARM-TRNS-HIST-TO-TS       TO HOSTVAR-ELEMENT-3      
              MOVE PARM-CODE-TRAN-TYPE        TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7550-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** FETCH ACCT RECV TRANS HIST ONLY CUSROR-USER ID & AR ONLY     **        
      ******************************************************************        
      *                                                                         
       7560-FETCH-TRNS-HDR-UID-AR.                                      

MSQ008     MOVE 21 TO MSQ008-TRNS-HDR-UID-AR
      *                                                                         
           EXEC SQL                                                     
              FOR :MSQ008-TRNS-HDR-UID-AR
              FETCH 
              FROM TRNS_HDR_UID_AR         
               INTO :H-TRANS-HIST-SEQ-NO                                
                   ,:H-CODE-TRAN-TYPE                                   
                   ,:H-APPL-PROGRAM-ID                                  
                   ,:H-USER-ID                                          
                   ,:H-RESP-AREA-ID                                     
                   ,:H-TRAN-COMMENT                                     
                   ,:H-ACCOUNT-NO                                       
                   ,:H-CUSTOMER-NO                                      
                   ,:H-PREMISE-NO                                       
                   ,:H-AMT-ORIG-ENTERED                                 
                   ,:H-AMT-BILLED-UNPAID                                
                   ,:H-RECORD-ONLY-FL                                   
PRJ586             ,:H-PYMT-REFUNDED-IND                                
                   ,:H-CASH-LOCAL-OFFICE                                
                   ,:H-CASH-REPORT-NO                                   
                   ,:H-DATE-CASH-REPORT                                 
                   ,:H-DATE-ORIG-PYMT                                   
                   ,:H-CASH-DRAWER-ID                                   
                   ,:H-PYMT-FACILITY-CD                                 
                   ,:H-TABLE-CD                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                             
MFA-TR*       FETCH NEXT ROWSET FROM TRNS_HDR_UID_AR FOR 21 ROWS                
MFA-TR*        INTO :H-TRANS-HIST-SEQ-NO                                        
MFA-TR*            ,:H-CODE-TRAN-TYPE                                           
MFA-TR*            ,:H-APPL-PROGRAM-ID                                          
MFA-TR*            ,:H-USER-ID                                                  
MFA-TR*            ,:H-RESP-AREA-ID                                             
MFA-TR*            ,:H-TRAN-COMMENT                                             
MFA-TR*            ,:H-ACCOUNT-NO                                               
MFA-TR*            ,:H-CUSTOMER-NO                                              
MFA-TR*            ,:H-PREMISE-NO                                               
MFA-TR*            ,:H-AMT-ORIG-ENTERED                                         
MFA-TR*            ,:H-AMT-BILLED-UNPAID                                        
MFA-TR*            ,:H-RECORD-ONLY-FL                                           
MFA-TR*            ,:H-PYMT-REFUNDED-IND                                        
MFA-TR*            ,:H-CASH-LOCAL-OFFICE                                        
MFA-TR*            ,:H-CASH-REPORT-NO                                           
MFA-TR*            ,:H-DATE-CASH-REPORT                                         
MFA-TR*            ,:H-DATE-ORIG-PYMT                                           
MFA-TR*            ,:H-CASH-DRAWER-ID                                           
MFA-TR*            ,:H-PYMT-FACILITY-CD                                         
MFA-TR*            ,:H-TABLE-CD                                                 
MFA-TR*    END-EXEC.                                                            

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-TRNS-HDR-UID-AR
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              MOVE SQLERRD(3)                 TO WS-HDR-FETCH-COUNT     
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7560'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_AR_TRANS_HIST'        TO TABLE-1                
              MOVE 'USER_ID'                  TO TABLE-ELEMENT-1        
              MOVE 'TRNS_HIST_FROM_TS'        TO TABLE-ELEMENT-2        
              MOVE 'TRNS_HIST_TO_TS'          TO TABLE-ELEMENT-3        
              MOVE 'CODE_TRAN_TYPE'           TO TABLE-ELEMENT-4        
              MOVE AR-USER-ID                 TO HOSTVAR-ELEMENT-1      
              MOVE PARM-TRNS-HIST-FROM-TS     TO HOSTVAR-ELEMENT-2      
              MOVE PARM-TRNS-HIST-TO-TS       TO HOSTVAR-ELEMENT-3      
              MOVE PARM-CODE-TRAN-TYPE        TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7560-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** CLOSE ACCT RECV TRANS HIST ONLY CUSROR-USER ID & AR ONLY     **        
      ******************************************************************        
      *                                                                         
       7570-CLOSE-TRNS-HDR-UID-AR.                                      
      *                                                                         
           EXEC SQL                                                     
              CLOSE TRNS_HDR_UID_AR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7570'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_AR_TRANS_HIST'        TO TABLE-1                
              MOVE 'USER_ID'                  TO TABLE-ELEMENT-1        
              MOVE 'TRNS_HIST_FROM_TS'        TO TABLE-ELEMENT-2        
              MOVE 'TRNS_HIST_TO_TS'          TO TABLE-ELEMENT-3        
              MOVE 'CODE_TRAN_TYPE'           TO TABLE-ELEMENT-4        
              MOVE AR-USER-ID                 TO HOSTVAR-ELEMENT-1      
              MOVE PARM-TRNS-HIST-FROM-TS     TO HOSTVAR-ELEMENT-2      
              MOVE PARM-TRNS-HIST-TO-TS       TO HOSTVAR-ELEMENT-3      
              MOVE PARM-CODE-TRAN-TYPE        TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7570-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** OPEN MAINTAIN TRANS HIST ONLY CURSOR - USER ID & MH ONLY     **        
      ******************************************************************        
      *                                                                         
       7600-OPEN-TRNS-HDR-UID-MH.                                       
      *                                                                         
           EXEC SQL                                                     
               OPEN TRNS_HDR_UID_MH                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7600'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_MNT_TRANS_HIST'       TO TABLE-1                
              MOVE 'USER_ID'                  TO TABLE-ELEMENT-1        
              MOVE 'TRNS_HIST_FROM_TS'        TO TABLE-ELEMENT-2        
              MOVE 'TRNS_HIST_TO_TS'          TO TABLE-ELEMENT-3        
              MOVE 'CODE_TRAN_TYPE'           TO TABLE-ELEMENT-4        
              MOVE MH-USER-ID                 TO HOSTVAR-ELEMENT-1      
              MOVE PARM-TRNS-HIST-FROM-TS     TO HOSTVAR-ELEMENT-2      
              MOVE PARM-TRNS-HIST-TO-TS       TO HOSTVAR-ELEMENT-3      
              MOVE PARM-CODE-TRAN-TYPE        TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** FOPEN MAINTAIN TRANS HIST ONLY CURSOR - USER ID & MH ONLY    **        
      ******************************************************************        
      *                                                                         
       7610-FETCH-TRNS-HDR-UID-MH.                                      

MSQ008     MOVE 21 TO MSQ008-TRNS-HDR-UID-MH
      *                                                                         
           EXEC SQL                                                     
              FOR :MSQ008-TRNS-HDR-UID-MH
              FETCH 
              FROM TRNS_HDR_UID_MH         
               INTO :H-TRANS-HIST-SEQ-NO                                
                   ,:H-CODE-TRAN-TYPE                                   
                   ,:H-APPL-PROGRAM-ID                                  
                   ,:H-USER-ID                                          
                   ,:H-RESP-AREA-ID                                     
                   ,:H-TRAN-COMMENT                                     
                   ,:H-ACCOUNT-NO                                       
                   ,:H-CUSTOMER-NO                                      
                   ,:H-PREMISE-NO                                       
                   ,:H-AMT-ORIG-ENTERED                                 
                   ,:H-AMT-BILLED-UNPAID                                
                   ,:H-RECORD-ONLY-FL                                   
PRJ586             ,:H-PYMT-REFUNDED-IND                                
                   ,:H-CASH-LOCAL-OFFICE                                
                   ,:H-CASH-REPORT-NO                                   
                   ,:H-DATE-CASH-REPORT                                 
                   ,:H-DATE-ORIG-PYMT                                   
                   ,:H-CASH-DRAWER-ID                                   
                   ,:H-PYMT-FACILITY-CD                                 
                   ,:H-TABLE-CD                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                             
MFA-TR*       FETCH NEXT ROWSET FROM TRNS_HDR_UID_MH FOR 21 ROWS                
MFA-TR*        INTO :H-TRANS-HIST-SEQ-NO                                        
MFA-TR*            ,:H-CODE-TRAN-TYPE                                           
MFA-TR*            ,:H-APPL-PROGRAM-ID                                          
MFA-TR*            ,:H-USER-ID                                                  
MFA-TR*            ,:H-RESP-AREA-ID                                             
MFA-TR*            ,:H-TRAN-COMMENT                                             
MFA-TR*            ,:H-ACCOUNT-NO                                               
MFA-TR*            ,:H-CUSTOMER-NO                                              
MFA-TR*            ,:H-PREMISE-NO                                               
MFA-TR*            ,:H-AMT-ORIG-ENTERED                                         
MFA-TR*            ,:H-AMT-BILLED-UNPAID                                        
MFA-TR*            ,:H-RECORD-ONLY-FL                                           
MFA-TR*            ,:H-PYMT-REFUNDED-IND                                        
MFA-TR*            ,:H-CASH-LOCAL-OFFICE                                        
MFA-TR*            ,:H-CASH-REPORT-NO                                           
MFA-TR*            ,:H-DATE-CASH-REPORT                                         
MFA-TR*            ,:H-DATE-ORIG-PYMT                                           
MFA-TR*            ,:H-CASH-DRAWER-ID                                           
MFA-TR*            ,:H-PYMT-FACILITY-CD                                         
MFA-TR*            ,:H-TABLE-CD                                                 
MFA-TR*    END-EXEC.                                                            

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-TRNS-HDR-UID-MH
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              MOVE SQLERRD(3)                 TO WS-HDR-FETCH-COUNT     
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7610'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_MNT_TRANS_HIST'       TO TABLE-1                
              MOVE 'USER_ID'                  TO TABLE-ELEMENT-1        
              MOVE 'TRNS_HIST_FROM_TS'        TO TABLE-ELEMENT-2        
              MOVE 'TRNS_HIST_TO_TS'          TO TABLE-ELEMENT-3        
              MOVE 'CODE_TRAN_TYPE'           TO TABLE-ELEMENT-4        
              MOVE MH-USER-ID                 TO HOSTVAR-ELEMENT-1      
              MOVE PARM-TRNS-HIST-FROM-TS     TO HOSTVAR-ELEMENT-2      
              MOVE PARM-TRNS-HIST-TO-TS       TO HOSTVAR-ELEMENT-3      
              MOVE PARM-CODE-TRAN-TYPE        TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7610-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** CLOSE MAINTAIN TRANS HIST ONLY CURSOR - USER ID & MH ONLY    **        
      ******************************************************************        
      *                                                                         
       7620-CLOSE-TRNS-HDR-UID-MH.                                      
      *                                                                         
           EXEC SQL                                                     
              CLOSE TRNS_HDR_UID_MH                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7620'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_MNT_TRANS_HIST'       TO TABLE-1                
              MOVE 'USER_ID'                  TO TABLE-ELEMENT-1        
              MOVE 'TRNS_HIST_FROM_TS'        TO TABLE-ELEMENT-2        
              MOVE 'TRNS_HIST_TO_TS'          TO TABLE-ELEMENT-3        
              MOVE 'CODE_TRAN_TYPE'           TO TABLE-ELEMENT-4        
              MOVE MH-USER-ID                 TO HOSTVAR-ELEMENT-1      
              MOVE PARM-TRNS-HIST-FROM-TS     TO HOSTVAR-ELEMENT-2      
              MOVE PARM-TRNS-HIST-TO-TS       TO HOSTVAR-ELEMENT-3      
              MOVE PARM-CODE-TRAN-TYPE        TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7620-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** OPEN MAINTAIN TRNS HIST CURSOR-USER ID & CUSTOMER            **        
      ******************************************************************        
      *                                                                         
       7650-OPEN-TRNS-HDR-UID-CUST.                                     
      *                                                                         
           EXEC SQL                                                     
               OPEN TRNS_HDR_UID_CUST                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7650'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_MNT_TRANS_HIST'       TO TABLE-1                
              MOVE 'USER_ID'                  TO TABLE-ELEMENT-1        
              MOVE 'CUSTOMER_NO'              TO TABLE-ELEMENT-2        
              MOVE 'TRNS_HIST_FROM_TS'        TO TABLE-ELEMENT-3        
              MOVE 'TRNS_HIST_TO_TS'          TO TABLE-ELEMENT-4        
              MOVE MH-USER-ID                 TO HOSTVAR-ELEMENT-1      
              MOVE MH-CUSTOMER-NO             TO HOSTVAR-ELEMENT-2      
              MOVE PARM-TRNS-HIST-FROM-TS     TO HOSTVAR-ELEMENT-3      
              MOVE PARM-TRNS-HIST-TO-TS       TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7650-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** FETCH MAINTAIN TRNS HIST CURSOR-USER ID & CUSTOMER           **        
      ******************************************************************        
      *                                                                         
       7660-FETCH-TRNS-HDR-UID-CUST.                                    

MSQ008     MOVE 21 TO MSQ008-TRNS-HDR-UID-CUST
      *                                                                         
           EXEC SQL                                                     
              FOR :MSQ008-TRNS-HDR-UID-CUST
              FETCH 
              FROM TRNS_HDR_UID_CUST       
               INTO :H-TRANS-HIST-SEQ-NO                                
                   ,:H-CODE-TRAN-TYPE                                   
                   ,:H-APPL-PROGRAM-ID                                  
                   ,:H-USER-ID                                          
                   ,:H-RESP-AREA-ID                                     
                   ,:H-TRAN-COMMENT                                     
                   ,:H-ACCOUNT-NO                                       
                   ,:H-CUSTOMER-NO                                      
                   ,:H-PREMISE-NO                                       
                   ,:H-TABLE-CD                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                             
MFA-TR*       FETCH NEXT ROWSET FROM TRNS_HDR_UID_CUST FOR 21 ROWS              
MFA-TR*        INTO :H-TRANS-HIST-SEQ-NO                                        
MFA-TR*            ,:H-CODE-TRAN-TYPE                                           
MFA-TR*            ,:H-APPL-PROGRAM-ID                                          
MFA-TR*            ,:H-USER-ID                                                  
MFA-TR*            ,:H-RESP-AREA-ID                                             
MFA-TR*            ,:H-TRAN-COMMENT                                             
MFA-TR*            ,:H-ACCOUNT-NO                                               
MFA-TR*            ,:H-CUSTOMER-NO                                              
MFA-TR*            ,:H-PREMISE-NO                                               
MFA-TR*            ,:H-TABLE-CD                                                 
MFA-TR*    END-EXEC.                                                            

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-TRNS-HDR-UID-CUST
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              MOVE SQLERRD(3)                 TO WS-HDR-FETCH-COUNT     
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7660'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_MNT_TRANS_HIST'       TO TABLE-1                
              MOVE 'USER_ID'                  TO TABLE-ELEMENT-1        
              MOVE 'CUSTOMER_NO'              TO TABLE-ELEMENT-2        
              MOVE 'TRNS_HIST_FROM_TS'        TO TABLE-ELEMENT-3        
              MOVE 'TRNS_HIST_TO_TS'          TO TABLE-ELEMENT-4        
              MOVE MH-USER-ID                 TO HOSTVAR-ELEMENT-1      
              MOVE MH-CUSTOMER-NO             TO HOSTVAR-ELEMENT-2      
              MOVE PARM-TRNS-HIST-FROM-TS     TO HOSTVAR-ELEMENT-3      
              MOVE PARM-TRNS-HIST-TO-TS       TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7660-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** CLOSE MAINTAIN TRNS HIST CURSOR-USER ID & CUSTOMER           **        
      ******************************************************************        
      *                                                                         
       7670-CLOSE-TRNS-HDR-UID-CUST.                                    
      *                                                                         
           EXEC SQL                                                     
              CLOSE TRNS_HDR_UID_CUST                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7670'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_MNT_TRANS_HIST'       TO TABLE-1                
              MOVE 'USER_ID'                  TO TABLE-ELEMENT-1        
              MOVE 'CUSTOMER_NO'              TO TABLE-ELEMENT-2        
              MOVE 'TRNS_HIST_FROM_TS'        TO TABLE-ELEMENT-3        
              MOVE 'TRNS_HIST_TO_TS'          TO TABLE-ELEMENT-4        
              MOVE MH-USER-ID                 TO HOSTVAR-ELEMENT-1      
              MOVE MH-CUSTOMER-NO             TO HOSTVAR-ELEMENT-2      
              MOVE PARM-TRNS-HIST-FROM-TS     TO HOSTVAR-ELEMENT-3      
              MOVE PARM-TRNS-HIST-TO-TS       TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7670-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** GET THE PROGRAM DESCRIPTION                                  **        
      ******************************************************************        
      *                                                                         
       7700-GET-APPL-PGM-DESC.                                          
      *                                                                         
           EXEC SQL                                                     
              SELECT  K9.APPL_PROGRAM_DESC                              
                INTO :K9-APPL-PROGRAM-DESC                              
                FROM  CSS_APPL_PGM_DESC   K9 WITH(READUNCOMMITTED)              
               WHERE  K9.APPL_PROGRAM_ID  =  :K9-APPL-PROGRAM-ID        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  K9.APPL_PROGRAM_DESC                                      
MFA-TR*         INTO :K9-APPL-PROGRAM-DESC                                      
MFA-TR*         FROM  CSS_APPL_PGM_DESC   K9                                    
MFA-TR*        WHERE  K9.APPL_PROGRAM_ID  =  :K9-APPL-PROGRAM-ID                
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7700                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7700'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_APPL_PGM_DESC'        TO TABLE-1                
              MOVE 'APPL_PROGRAM_ID'          TO TABLE-ELEMENT-1        
              MOVE 'CALL_TYPE'                TO TABLE-ELEMENT-2        
              MOVE 'TRNS_HIST_FROM_TS'        TO TABLE-ELEMENT-3        
              MOVE 'TRNS_HIST_TO_TS'          TO TABLE-ELEMENT-4        
              MOVE K9-APPL-PROGRAM-ID         TO HOSTVAR-ELEMENT-1      
              MOVE PARM-CALL-TYPE             TO HOSTVAR-ELEMENT-2      
              MOVE PARM-TRNS-HIST-FROM-TS     TO HOSTVAR-ELEMENT-3      
              MOVE PARM-TRNS-HIST-TO-TS       TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** GET EMPLOYEE NAME                                            **        
      ******************************************************************        
      *                                                                         
       7710-GET-EMPLOYEE-NAME.                                          
      *                                                                         
           EXEC SQL                                                     
              SELECT  CIS.CHAR2$CHAR(LTRIM(RTRIM(PF.LAST_NAME)) + 
           CASE WHEN CIS.SUBSTR3(PF.FIRST_NAME,1,1)  = ' '        
                           THEN '' ELSE ', ' END + LTRIM(RTRIM(
           PF.FIRST_NAME)) + CASE WHEN CIS.SUBSTR3(
           PF.MIDDLE_NAME,1,1) = ' '        
                           THEN '' ELSE ' '  END + LTRIM(RTRIM(
           PF.MIDDLE_NAME)),40)                         
                INTO  :WS-EMPLOYEE-NAME                                 
                FROM  CSS_USER_PROFILE  PF WITH(READUNCOMMITTED)                
               WHERE  PF.USER_ID  =  :PF-USER-ID                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  CHAR(STRIP(PF.LAST_NAME)    CONCAT                        
MFA-TR*               CASE WHEN SUBSTR(PF.FIRST_NAME,1,1)  = ' '                
MFA-TR*                    THEN '' ELSE ', ' END  CONCAT                        
MFA-TR*               STRIP(PF.FIRST_NAME)        CONCAT                        
MFA-TR*               CASE WHEN SUBSTR(PF.MIDDLE_NAME,1,1) = ' '                
MFA-TR*                    THEN '' ELSE ' '  END  CONCAT                        
MFA-TR*               STRIP(PF.MIDDLE_NAME),40)                                 
MFA-TR*         INTO  :WS-EMPLOYEE-NAME                                         
MFA-TR*         FROM  CSS_USER_PROFILE  PF                                      
MFA-TR*        WHERE  PF.USER_ID  =  :PF-USER-ID                                
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7710                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7710'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_USER_PROFILE'         TO TABLE-1                
              MOVE 'USER_ID'                  TO TABLE-ELEMENT-1        
              MOVE 'CALL_TYPE'                TO TABLE-ELEMENT-2        
              MOVE 'TRNS_HIST_FROM_TS'        TO TABLE-ELEMENT-3        
              MOVE 'TRNS_HIST_TO_TS'          TO TABLE-ELEMENT-4        
              MOVE PF-USER-ID                 TO HOSTVAR-ELEMENT-1      
              MOVE PARM-CALL-TYPE             TO HOSTVAR-ELEMENT-2      
              MOVE PARM-TRNS-HIST-FROM-TS     TO HOSTVAR-ELEMENT-3      
              MOVE PARM-TRNS-HIST-TO-TS       TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7710-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** GET CASH LOCAL OFFICE DESC                                   **        
      ******************************************************************        
      *                                                                         
       7715-GET-CASH-LOC-OFF-DESC.                                      
      *                                                                         
           EXEC SQL                                                     
              SELECT  Y2.CASH_LOC_OFF_DESC                              
                INTO :Y2-CASH-LOC-OFF-DESC                              
                FROM  CSS_CASHIER_OFFICE  Y2 WITH(READUNCOMMITTED)              
               WHERE  Y2.CASH_COMPANY_NO    = '01'                      
                 AND  Y2.CASH_LOCAL_OFFICE  = :Y2-CASH-LOCAL-OFFICE     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  Y2.CASH_LOC_OFF_DESC                                      
MFA-TR*         INTO :Y2-CASH-LOC-OFF-DESC                                      
MFA-TR*         FROM  CSS_CASHIER_OFFICE  Y2                                    
MFA-TR*        WHERE  Y2.CASH_COMPANY_NO    = '01'                              
MFA-TR*          AND  Y2.CASH_LOCAL_OFFICE  = :Y2-CASH-LOCAL-OFFICE             
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7715                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7715'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_CASHIER_OFFICE'       TO TABLE-1                
              MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-1        
              MOVE Y2-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7715-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** GET CODE BATCH STATUS                                        **        
      ******************************************************************        
      *                                                                         
       7720-GET-BATCH-STATUS.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT  BC.CODE_BATCH_STATUS                              
                INTO :BC-CODE-BATCH-STATUS                              
                FROM  CSS_BCH_JRNL_CNTL   BC WITH(READUNCOMMITTED)              
               WHERE  BC.CASH_COMPANY_NO    = '01'                      
                 AND  BC.CASH_LOCAL_OFFICE  = :BC-CASH-LOCAL-OFFICE     
                 AND  BC.CASH_REPORT_NO     = :BC-CASH-REPORT-NO        
                 AND  BC.DATE_CASH_REPORT   = IIF(TRY_CONVERT(DATE, 
                                                   :BC-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :BC-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:BC-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:BC-DATE-CASH-REPORT
              ), CONVERT(DATE, :BC-DATE-CASH-REPORT) )      
                 AND  BC.CASH_DRAWER_ID     = :BC-CASH-DRAWER-ID        
                 AND  BC.LOCAL_OFFICE_ENTRY = ' '                       
                 AND  BC.BATCH_NO           = ' '                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  BC.CODE_BATCH_STATUS                                      
MFA-TR*         INTO :BC-CODE-BATCH-STATUS                                      
MFA-TR*         FROM  CSS_BCH_JRNL_CNTL   BC                                    
MFA-TR*        WHERE  BC.CASH_COMPANY_NO    = '01'                              
MFA-TR*          AND  BC.CASH_LOCAL_OFFICE  = :BC-CASH-LOCAL-OFFICE             
MFA-TR*          AND  BC.CASH_REPORT_NO     = :BC-CASH-REPORT-NO                
MFA-TR*          AND  BC.DATE_CASH_REPORT   = :BC-DATE-CASH-REPORT              
MFA-TR*          AND  BC.CASH_DRAWER_ID     = :BC-CASH-DRAWER-ID                
MFA-TR*          AND  BC.LOCAL_OFFICE_ENTRY = ' '                               
MFA-TR*          AND  BC.BATCH_NO           = ' '                               
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7720                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7720'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_BCH_JRNL_CNTL'        TO TABLE-1                
              MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-1        
              MOVE 'CASH_REPORT_NO'           TO TABLE-ELEMENT-2        
              MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-3        
              MOVE 'CASH_DRAWER_ID'           TO TABLE-ELEMENT-4        
              MOVE BC-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-1      
              MOVE BC-CASH-REPORT-NO          TO HOSTVAR-ELEMENT-2      
              MOVE BC-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-3      
              MOVE BC-CASH-DRAWER-ID          TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7720-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** GET CODE BATCH STATUS                                        **        
      ******************************************************************        
      *                                                                         
       7730-GET-CD-BATCH-STATUS.                                        
      *                                                                         
           EXEC SQL                                                     
              SELECT CS.CODE_CSH_DRWR_STAT                              
                INTO :BC-CODE-BATCH-STATUS                              
                FROM CSS_CSH_DRWR_CNTL CS WITH(READUNCOMMITTED)                 
               WHERE CASH_COMPANY_NO    = '01'                          
                 AND CASH_LOCAL_OFFICE  = :CS-CASH-LOCAL-OFFICE         
                 AND CASH_REPORT_NO     = :CS-CASH-REPORT-NO            
                 AND DATE_CASH_REPORT   = IIF(TRY_CONVERT(DATE, 
                                                   :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) )          
                 AND CASH_DRAWER_ID     = :CS-CASH-DRAWER-ID            
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CS.CODE_CSH_DRWR_STAT                                      
MFA-TR*         INTO :BC-CODE-BATCH-STATUS                                      
MFA-TR*         FROM CSS_CSH_DRWR_CNTL CS                                       
MFA-TR*        WHERE CASH_COMPANY_NO    = '01'                                  
MFA-TR*          AND CASH_LOCAL_OFFICE  = :CS-CASH-LOCAL-OFFICE                 
MFA-TR*          AND CASH_REPORT_NO     = :CS-CASH-REPORT-NO                    
MFA-TR*          AND DATE_CASH_REPORT   = :CS-DATE-CASH-REPORT                  
MFA-TR*          AND CASH_DRAWER_ID     = :CS-CASH-DRAWER-ID                    
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7730                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7730'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_CSH_DRWR_CNTL'        TO TABLE-1                
              MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-1        
              MOVE 'CASH_REPORT_NO'           TO TABLE-ELEMENT-2        
              MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-3        
              MOVE 'CASH_DRAWER_ID'           TO TABLE-ELEMENT-4        
              MOVE CS-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-1      
              MOVE CS-CASH-REPORT-NO          TO HOSTVAR-ELEMENT-2      
              MOVE CS-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-3      
              MOVE CS-CASH-DRAWER-ID          TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7730-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** GET CUSTOMER NAME AND ADDRESS                                **        
      ******************************************************************        
      *                                                                         
       7740-GET-CUST-NAME-AND-ADDR.                                     
      *                                                                         
           EXEC SQL                                                     
              SELECT  CASE WHEN DQ.NAME_FORMAT = 'B' THEN DQ.FULL_NAME  
                      ELSE CIS.CHAR2$CHAR(LTRIM(RTRIM(DQ.LAST_NAME)) + 
           CASE WHEN CIS.SUBSTR3(DQ.FIRST_NAME,1,1)  = ' '   
                                THEN '' ELSE ', '    END + LTRIM(RTRIM(
           DQ.FIRST_NAME)) + CASE WHEN CIS.SUBSTR3(
           DQ.MIDDLE_NAME,1,1) = ' '   
                                THEN '' ELSE ' '     END + LTRIM(RTRIM(
           DQ.MIDDLE_NAME)),70) END                
                     ,CIS.CHAR2$CHAR(LTRIM(RTRIM(DY.HOUSE_NO)) + 
           CASE WHEN LTRIM(RTRIM(DY.ADDR_PREFIX_1))     > ' '       
                           THEN ' ' ELSE '' END + LTRIM(RTRIM(
           DY.ADDR_PREFIX_1)) + CASE WHEN LTRIM(RTRIM(DY.ADDR_PREFIX_2
           ))     > ' '       
                           THEN ' ' ELSE '' END + LTRIM(RTRIM(
           DY.ADDR_PREFIX_2)) + CASE WHEN LTRIM(RTRIM(DY.STREET_NAME
           ))       > ' '       
                           THEN ' ' ELSE '' END + LTRIM(RTRIM(
           DY.STREET_NAME)) + CASE WHEN LTRIM(RTRIM(DY.STREET_SUFFIX
           ))     > ' '       
                           THEN ' ' ELSE '' END + LTRIM(RTRIM(
           DY.STREET_SUFFIX)) + CASE WHEN LTRIM(RTRIM(
           DY.STREET_LOCATION_1)) > ' '       
                           THEN ' ' ELSE '' END + LTRIM(RTRIM(
           DY.STREET_LOCATION_1)) + CASE WHEN LTRIM(RTRIM(
           DY.STREET_LOCATION_2)) > ' '       
                           THEN ' ' ELSE '' END + LTRIM(RTRIM(
           DY.STREET_LOCATION_2)),75)              
                     ,CIS.CHAR2$CHAR(LTRIM(RTRIM(A4.TOWN)) + ', ' + 
           LTRIM(RTRIM(A4.STATE)) + ' ' + LTRIM(RTRIM(A4.ZIP_CODE)),35)        
                INTO  :DQ-FULL-NAME                                     
                     ,:WS-ADDRESS-LINE-1                                
                     ,:WS-ADDRESS-LINE-2                                
                FROM  CSS_NAME            DQ WITH(READUNCOMMITTED)              
                     ,CSS_NAME_ACCT_XREF  HT WITH(READUNCOMMITTED)              
                     ,CSS_ADDR_FORMATTED  DY WITH(READUNCOMMITTED)              
                     ,CSS_ZIP_CODE        A4 WITH(READUNCOMMITTED)              
               WHERE  HT.ACCOUNT_NO       = :HT-ACCOUNT-NO              
                 AND  HT.NAME_ID          =  DQ.NAME_ID                 
                 AND  DQ.NAME_TYPE        =  'CN'                       
                 AND  HT.ADDRESS_ID       =  DY.ADDRESS_ID              
                 AND  HT.CUSTOMER_ROLE_CD =  ' '                        
                 AND  A4.ZIP_CODE         =  DY.ZIP_CODE                
                 AND  A4.ZIP_CODE_TOKEN   =  DY.ZIP_CODE_TOKEN          
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  CASE WHEN DQ.NAME_FORMAT = 'B' THEN DQ.FULL_NAME          
MFA-TR*               ELSE CHAR(STRIP(DQ.LAST_NAME)       ||                    
MFA-TR*                    CASE WHEN SUBSTR(DQ.FIRST_NAME,1,1)  = ' '           
MFA-TR*                         THEN '' ELSE ', '    END  ||                    
MFA-TR*                    STRIP(DQ.FIRST_NAME)           ||                    
MFA-TR*                    CASE WHEN SUBSTR(DQ.MIDDLE_NAME,1,1) = ' '           
MFA-TR*                         THEN '' ELSE ' '     END  ||                    
MFA-TR*                    STRIP(DQ.MIDDLE_NAME),70) END                        
MFA-TR*              ,CHAR(STRIP(DY.HOUSE_NO)           ||                      
MFA-TR*               CASE WHEN STRIP(DY.ADDR_PREFIX_1)     > ' '               
MFA-TR*                    THEN ' ' ELSE '' END         ||                      
MFA-TR*                    STRIP(DY.ADDR_PREFIX_1)      ||                      
MFA-TR*               CASE WHEN STRIP(DY.ADDR_PREFIX_2)     > ' '               
MFA-TR*                    THEN ' ' ELSE '' END         ||                      
MFA-TR*                    STRIP(DY.ADDR_PREFIX_2)      ||                      
MFA-TR*               CASE WHEN STRIP(DY.STREET_NAME)       > ' '               
MFA-TR*                    THEN ' ' ELSE '' END         ||                      
MFA-TR*                    STRIP(DY.STREET_NAME)        ||                      
MFA-TR*               CASE WHEN STRIP(DY.STREET_SUFFIX)     > ' '               
MFA-TR*                    THEN ' ' ELSE '' END         ||                      
MFA-TR*                    STRIP(DY.STREET_SUFFIX)      ||                      
MFA-TR*               CASE WHEN STRIP(DY.STREET_LOCATION_1) > ' '               
MFA-TR*                    THEN ' ' ELSE '' END         ||                      
MFA-TR*                    STRIP(DY.STREET_LOCATION_1)  ||                      
MFA-TR*               CASE WHEN STRIP(DY.STREET_LOCATION_2) > ' '               
MFA-TR*                    THEN ' ' ELSE '' END         ||                      
MFA-TR*                    STRIP(DY.STREET_LOCATION_2),75)                      
MFA-TR*              ,CHAR(STRIP(A4.TOWN)       || ', ' ||                      
MFA-TR*                    STRIP(A4.STATE)      || ' '  ||                      
MFA-TR*                    STRIP(A4.ZIP_CODE),35)                               
MFA-TR*         INTO  :DQ-FULL-NAME                                             
MFA-TR*              ,:WS-ADDRESS-LINE-1                                        
MFA-TR*              ,:WS-ADDRESS-LINE-2                                        
MFA-TR*         FROM  CSS_NAME            DQ                                    
MFA-TR*              ,CSS_NAME_ACCT_XREF  HT                                    
MFA-TR*              ,CSS_ADDR_FORMATTED  DY                                    
MFA-TR*              ,CSS_ZIP_CODE        A4                                    
MFA-TR*        WHERE  HT.ACCOUNT_NO       = :HT-ACCOUNT-NO                      
MFA-TR*          AND  HT.NAME_ID          =  DQ.NAME_ID                         
MFA-TR*          AND  DQ.NAME_TYPE        =  'CN'                               
MFA-TR*          AND  HT.ADDRESS_ID       =  DY.ADDRESS_ID                      
MFA-TR*          AND  HT.CUSTOMER_ROLE_CD =  ' '                                
MFA-TR*          AND  A4.ZIP_CODE         =  DY.ZIP_CODE                        
MFA-TR*          AND  A4.ZIP_CODE_TOKEN   =  DY.ZIP_CODE_TOKEN                  
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7740                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7740'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_NAME_ACCT_XREF'       TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE HT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7740-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** GET CUSTOMER NAME                                            **        
      ******************************************************************        
      *                                                                         
       7750-GET-CUSTOMER-NAME.                                          
      *                                                                         
           EXEC SQL                                                     
              SELECT  DISTINCT                                          
                      CASE WHEN DQ.NAME_FORMAT = 'B' THEN DQ.FULL_NAME  
                      ELSE CIS.CHAR2$CHAR(LTRIM(RTRIM(DQ.LAST_NAME)) + 
           CASE WHEN CIS.SUBSTR3(DQ.FIRST_NAME,1,1)  = ' '   
                                THEN '' ELSE ', '    END + LTRIM(RTRIM(
           DQ.FIRST_NAME)) + CASE WHEN CIS.SUBSTR3(
           DQ.MIDDLE_NAME,1,1) = ' '   
                                THEN '' ELSE ' '     END + LTRIM(RTRIM(
           DQ.MIDDLE_NAME)),70) END                
                INTO  :DQ-FULL-NAME                                     
                FROM  CSS_NAME            DQ WITH(READUNCOMMITTED)              
                     ,CSS_NAME_ACCT_XREF  HT WITH(READUNCOMMITTED)              
               WHERE  HT.CUSTOMER_NO      = :HT-CUSTOMER-NO             
                 AND  HT.NAME_ID          =  DQ.NAME_ID                 
                 AND  DQ.NAME_TYPE        =  'CN'                       
                 AND  HT.CUSTOMER_ROLE_CD =  ' '                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  DISTINCT                                                  
MFA-TR*               CASE WHEN DQ.NAME_FORMAT = 'B' THEN DQ.FULL_NAME          
MFA-TR*               ELSE CHAR(STRIP(DQ.LAST_NAME)       ||                    
MFA-TR*                    CASE WHEN SUBSTR(DQ.FIRST_NAME,1,1)  = ' '           
MFA-TR*                         THEN '' ELSE ', '    END  ||                    
MFA-TR*                    STRIP(DQ.FIRST_NAME)           ||                    
MFA-TR*                    CASE WHEN SUBSTR(DQ.MIDDLE_NAME,1,1) = ' '           
MFA-TR*                         THEN '' ELSE ' '     END  ||                    
MFA-TR*                    STRIP(DQ.MIDDLE_NAME),70) END                        
MFA-TR*         INTO  :DQ-FULL-NAME                                             
MFA-TR*         FROM  CSS_NAME            DQ                                    
MFA-TR*              ,CSS_NAME_ACCT_XREF  HT                                    
MFA-TR*        WHERE  HT.CUSTOMER_NO      = :HT-CUSTOMER-NO                     
MFA-TR*          AND  HT.NAME_ID          =  DQ.NAME_ID                         
MFA-TR*          AND  DQ.NAME_TYPE        =  'CN'                               
MFA-TR*          AND  HT.CUSTOMER_ROLE_CD =  ' '                                
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7750                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7750'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_NAME_ACCT_XREF'       TO TABLE-1                
              MOVE 'CUSTOMER_NO'              TO TABLE-ELEMENT-1        
              MOVE HT-CUSTOMER-NO             TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7750-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** GET PREMISE ADDRESS                                          **        
      ******************************************************************        
      *                                                                         
       7760-GET-PREMISE-ADDRESS.                                        
      *                                                                         
           EXEC SQL                                                     
              SELECT  DISTINCT                                          
                      CIS.CHAR2$CHAR(LTRIM(RTRIM(DY.HOUSE_NO)) + 
           CASE WHEN LTRIM(RTRIM(DY.ADDR_PREFIX_1))     > ' '       
                           THEN ' ' ELSE '' END + LTRIM(RTRIM(
           DY.ADDR_PREFIX_1)) + CASE WHEN LTRIM(RTRIM(DY.ADDR_PREFIX_2
           ))     > ' '       
                           THEN ' ' ELSE '' END + LTRIM(RTRIM(
           DY.ADDR_PREFIX_2)) + CASE WHEN LTRIM(RTRIM(DY.STREET_NAME
           ))       > ' '       
                           THEN ' ' ELSE '' END + LTRIM(RTRIM(
           DY.STREET_NAME)) + CASE WHEN LTRIM(RTRIM(DY.STREET_SUFFIX
           ))     > ' '       
                           THEN ' ' ELSE '' END + LTRIM(RTRIM(
           DY.STREET_SUFFIX)) + CASE WHEN LTRIM(RTRIM(
           DY.STREET_LOCATION_1)) > ' '       
                           THEN ' ' ELSE '' END + LTRIM(RTRIM(
           DY.STREET_LOCATION_1)) + CASE WHEN LTRIM(RTRIM(
           DY.STREET_LOCATION_2)) > ' '       
                           THEN ' ' ELSE '' END + LTRIM(RTRIM(
           DY.STREET_LOCATION_2)),75)              
                     ,CIS.CHAR2$CHAR(LTRIM(RTRIM(A4.TOWN)) + ', ' + 
           LTRIM(RTRIM(A4.STATE)) + ' ' + LTRIM(RTRIM(A4.ZIP_CODE)),35)        
                INTO  :WS-ADDRESS-LINE-1                                
                     ,:WS-ADDRESS-LINE-2                                
                FROM  CSS_NAME_ACCT_XREF  HT WITH(READUNCOMMITTED)              
                     ,CSS_ADDR_FORMATTED  DY WITH(READUNCOMMITTED)              
                     ,CSS_ZIP_CODE        A4 WITH(READUNCOMMITTED)              
               WHERE  HT.PREMISE_NO       = :HT-PREMISE-NO              
                 AND  HT.ADDRESS_ID       =  DY.ADDRESS_ID              
                 AND  HT.CUSTOMER_ROLE_CD =  ' '                        
                 AND  A4.ZIP_CODE         =  DY.ZIP_CODE                
                 AND  A4.ZIP_CODE_TOKEN   =  DY.ZIP_CODE_TOKEN          
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  DISTINCT                                                  
MFA-TR*               CHAR(STRIP(DY.HOUSE_NO)           ||                      
MFA-TR*               CASE WHEN STRIP(DY.ADDR_PREFIX_1)     > ' '               
MFA-TR*                    THEN ' ' ELSE '' END         ||                      
MFA-TR*                    STRIP(DY.ADDR_PREFIX_1)      ||                      
MFA-TR*               CASE WHEN STRIP(DY.ADDR_PREFIX_2)     > ' '               
MFA-TR*                    THEN ' ' ELSE '' END         ||                      
MFA-TR*                    STRIP(DY.ADDR_PREFIX_2)      ||                      
MFA-TR*               CASE WHEN STRIP(DY.STREET_NAME)       > ' '               
MFA-TR*                    THEN ' ' ELSE '' END         ||                      
MFA-TR*                    STRIP(DY.STREET_NAME)        ||                      
MFA-TR*               CASE WHEN STRIP(DY.STREET_SUFFIX)     > ' '               
MFA-TR*                    THEN ' ' ELSE '' END         ||                      
MFA-TR*                    STRIP(DY.STREET_SUFFIX)      ||                      
MFA-TR*               CASE WHEN STRIP(DY.STREET_LOCATION_1) > ' '               
MFA-TR*                    THEN ' ' ELSE '' END         ||                      
MFA-TR*                    STRIP(DY.STREET_LOCATION_1)  ||                      
MFA-TR*               CASE WHEN STRIP(DY.STREET_LOCATION_2) > ' '               
MFA-TR*                    THEN ' ' ELSE '' END         ||                      
MFA-TR*                    STRIP(DY.STREET_LOCATION_2),75)                      
MFA-TR*              ,CHAR(STRIP(A4.TOWN)       || ', ' ||                      
MFA-TR*                    STRIP(A4.STATE)      || ' '  ||                      
MFA-TR*                    STRIP(A4.ZIP_CODE),35)                               
MFA-TR*         INTO  :WS-ADDRESS-LINE-1                                        
MFA-TR*              ,:WS-ADDRESS-LINE-2                                        
MFA-TR*         FROM  CSS_NAME_ACCT_XREF  HT                                    
MFA-TR*              ,CSS_ADDR_FORMATTED  DY                                    
MFA-TR*              ,CSS_ZIP_CODE        A4                                    
MFA-TR*        WHERE  HT.PREMISE_NO       = :HT-PREMISE-NO                      
MFA-TR*          AND  HT.ADDRESS_ID       =  DY.ADDRESS_ID                      
MFA-TR*          AND  HT.CUSTOMER_ROLE_CD =  ' '                                
MFA-TR*          AND  A4.ZIP_CODE         =  DY.ZIP_CODE                        
MFA-TR*          AND  A4.ZIP_CODE_TOKEN   =  DY.ZIP_CODE_TOKEN                  
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7760                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7760'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_NAME_ACCT_XREF'       TO TABLE-1                
              MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-1        
              MOVE HT-PREMISE-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7760-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** GET DESCRIPTION FROM CODE VALUE TABLE                        **        
      ******************************************************************        
      *                                                                         
       7770-GET-CODE-VALUE-DESC.                                        
      *                                                                         
           EXEC SQL                                                     
              SELECT  UV.CODE_SHORT_DESC                                
                INTO :UV-CODE-SHORT-DESC                                
                FROM  CSS_CODE_VALUE  UV WITH(READUNCOMMITTED)                  
               WHERE  UV.CODE_VALUE  =  :UV-CODE-VALUE                  
                 AND  UV.COLUMN_NA   =  'CURRENCY_TYPE'                 
                 AND  UV.TABLE_NA    =  'CSS_PAYMENT_TRANS'             
                 AND  UV.PROGRAM_ID  =  'H'                             
                 AND  UV.COMPANY_NO  =  '01'                            
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  UV.CODE_SHORT_DESC                                        
MFA-TR*         INTO :UV-CODE-SHORT-DESC                                        
MFA-TR*         FROM  CSS_CODE_VALUE  UV                                        
MFA-TR*        WHERE  UV.CODE_VALUE  =  :UV-CODE-VALUE                          
MFA-TR*          AND  UV.COLUMN_NA   =  'CURRENCY_TYPE'                         
MFA-TR*          AND  UV.TABLE_NA    =  'CSS_PAYMENT_TRANS'                     
MFA-TR*          AND  UV.PROGRAM_ID  =  'H'                                     
MFA-TR*          AND  UV.COMPANY_NO  =  '01'                                    
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7770                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7770'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_CODE_VALUE'           TO TABLE-1                
              MOVE 'CODE_VALUE'               TO TABLE-ELEMENT-1        
              MOVE UV-CODE-VALUE              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7770-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  OPEN ACCT RECV TRNS HIST DETAILS CURSOR                     **        
      ******************************************************************        
      *                                                                         
       7800-OPEN-ACCT-RECV-DET.                                         
      *                                                                         
           EXEC SQL                                                     
               OPEN ACCT_RECV_DET                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7800'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_AR_TRN_HST_DET'       TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'TRANS_HIST_SEQ_NO'        TO TABLE-ELEMENT-2        
              MOVE 'TRNS_HIST_FROM_TS'        TO TABLE-ELEMENT-3        
              MOVE 'TRNS_HIST_TO_TS'          TO TABLE-ELEMENT-4        
              MOVE AU-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE AU-TRANS-HIST-SEQ-NO       TO HOSTVAR-ELEMENT-2      
              MOVE PARM-TRNS-HIST-FROM-TS     TO HOSTVAR-ELEMENT-3      
              MOVE PARM-TRNS-HIST-TO-TS       TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  FETCH ACCT RECV TRNS HIST DETAILS CURSOR                    **        
      ******************************************************************        
      *                                                                         
       7810-FETCH-ACCT-RECV-DET.                                        
      *                                                                         
           EXEC SQL                                                     
              FETCH ACCT_RECV_DET                                       
               INTO :AU-CODE-AR-AGE                                     
                   ,:AU-GL-ACCT-CREDIT                                  
                   ,:AU-GL-ACCT-DEBIT                                   
                   ,:AU-AMT-POSTED                                      
                   ,:AU-ITEM-ID                                         
                   ,:AU-CODE-CONTRACT-TYPE                              
                   ,:AU-CURRENCY-TYPE                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7810'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_AR_TRN_HST_DET'       TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'TRANS_HIST_SEQ_NO'        TO TABLE-ELEMENT-2        
              MOVE 'TRNS_HIST_FROM_TS'        TO TABLE-ELEMENT-3        
              MOVE 'TRNS_HIST_TO_TS'          TO TABLE-ELEMENT-4        
              MOVE AU-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE AU-TRANS-HIST-SEQ-NO       TO HOSTVAR-ELEMENT-2      
              MOVE PARM-TRNS-HIST-FROM-TS     TO HOSTVAR-ELEMENT-3      
              MOVE PARM-TRNS-HIST-TO-TS       TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7810-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  CLOSE ACCT RECV TRNS HIST DETAILS CURSOR                    **        
      ******************************************************************        
      *                                                                         
       7820-CLOSE-ACCT-RECV-DET.                                        
      *                                                                         
           EXEC SQL                                                     
              CLOSE ACCT_RECV_DET                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7820'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_AR_TRN_HST_DET'       TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'TRANS_HIST_SEQ_NO'        TO TABLE-ELEMENT-2        
              MOVE 'TRNS_HIST_FROM_TS'        TO TABLE-ELEMENT-3        
              MOVE 'TRNS_HIST_TO_TS'          TO TABLE-ELEMENT-4        
              MOVE AU-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE AU-TRANS-HIST-SEQ-NO       TO HOSTVAR-ELEMENT-2      
              MOVE PARM-TRNS-HIST-FROM-TS     TO HOSTVAR-ELEMENT-3      
              MOVE PARM-TRNS-HIST-TO-TS       TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7820-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** GET CONTRACT NAME DESCRIPTION                                **        
      ******************************************************************        
      *                                                                         
       7830-GET-CONTRACT-DESC.                                          
      *                                                                         
           EXEC SQL                                                     
              SELECT  K6.CNT_NAME_DESC                                  
                INTO :K6-CNT-NAME-DESC                                  
                FROM  CSS_CONTRACT       CT WITH(READUNCOMMITTED)               
                     ,CSS_CONTRACT_INFO  K6 WITH(READUNCOMMITTED)               
               WHERE  CT.ACCOUNT_NO         =  :CT-ACCOUNT-NO           
                 AND  CT.CNT_ITEM_ID        =  :CT-CNT-ITEM-ID          
                 AND  CT.PYMT_PRIORITY_LVL  =  100                      
                 AND  CT.CNT_NAME_CD        =  K6.CNT_NAME_CD           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  K6.CNT_NAME_DESC                                          
MFA-TR*         INTO :K6-CNT-NAME-DESC                                          
MFA-TR*         FROM  CSS_CONTRACT       CT                                     
MFA-TR*              ,CSS_CONTRACT_INFO  K6                                     
MFA-TR*        WHERE  CT.ACCOUNT_NO         =  :CT-ACCOUNT-NO                   
MFA-TR*          AND  CT.CNT_ITEM_ID        =  :CT-CNT-ITEM-ID                  
MFA-TR*          AND  CT.PYMT_PRIORITY_LVL  =  100                              
MFA-TR*          AND  CT.CNT_NAME_CD        =  K6.CNT_NAME_CD                   
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7830                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7830'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_CONTRACT'             TO TABLE-1                
              MOVE 'TRANS_HIST_SEQ_NO'        TO TABLE-ELEMENT-1        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE 'ITEM_ID'                  TO TABLE-ELEMENT-3        
              MOVE AU-TRANS-HIST-SEQ-NO       TO HOSTVAR-ELEMENT-1      
              MOVE CT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
              MOVE CT-CNT-ITEM-ID             TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7830-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  OPEN MAINTAIN TRNS HIST DETAILS CURSOR                      **        
      ******************************************************************        
      *                                                                         
       7900-OPEN-MNTN-TRNS-DET.                                         
      *                                                                         
           EXEC SQL                                                     
               OPEN MNTN_TRNS_DET                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7900'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_MT_TRN_HST_DET'       TO TABLE-1                
              MOVE 'TRANS_HIST_SEQ_NO'        TO TABLE-ELEMENT-1        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE 'CUSTOMER_NO'              TO TABLE-ELEMENT-3        
              MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-4        
              MOVE MI-TRANS-HIST-SEQ-NO       TO HOSTVAR-ELEMENT-1      
              MOVE PARM-ACCOUNT-NO-NUM        TO HOSTVAR-ELEMENT-2      
              MOVE PARM-CUSTOMER-NO-NUM       TO HOSTVAR-ELEMENT-3      
              MOVE PARM-PREMISE-NO-NUM        TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  FETCH MAINTAIN TRNS HIST DETAILS CURSOR                     **        
      ******************************************************************        
      *                                                                         
       7910-FETCH-MNTN-TRNS-DET.                                        
      *                                                                         
           EXEC SQL                                                     
              FETCH MNTN_TRNS_DET                                       
               INTO :MI-COLUMN-DESC                                     
                   ,:MI-TABLE-ID                                        
                   ,:MI-PRV-COLUMN-VALUE                                
                   ,:MI-CHG-COLUMN-VALUE                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7910'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_MT_TRN_HST_DET'       TO TABLE-1                
              MOVE 'TRANS_HIST_SEQ_NO'        TO TABLE-ELEMENT-1        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE 'CUSTOMER_NO'              TO TABLE-ELEMENT-3        
              MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-4        
              MOVE MI-TRANS-HIST-SEQ-NO       TO HOSTVAR-ELEMENT-1      
              MOVE PARM-ACCOUNT-NO-NUM        TO HOSTVAR-ELEMENT-2      
              MOVE PARM-CUSTOMER-NO-NUM       TO HOSTVAR-ELEMENT-3      
              MOVE PARM-PREMISE-NO-NUM        TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7910-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  CLOSE MAINTAIN TRNS HIST DETAILS CURSOR                     **        
      ******************************************************************        
      *                                                                         
       7920-CLOSE-MNTN-TRNS-DET.                                        
      *                                                                         
           EXEC SQL                                                     
              CLOSE MNTN_TRNS_DET                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7920'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_MT_TRN_HST_DET'       TO TABLE-1                
              MOVE 'TRANS_HIST_SEQ_NO'        TO TABLE-ELEMENT-1        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE 'CUSTOMER_NO'              TO TABLE-ELEMENT-3        
              MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-4        
              MOVE MI-TRANS-HIST-SEQ-NO       TO HOSTVAR-ELEMENT-1      
              MOVE PARM-ACCOUNT-NO-NUM        TO HOSTVAR-ELEMENT-2      
              MOVE PARM-CUSTOMER-NO-NUM       TO HOSTVAR-ELEMENT-3      
              MOVE PARM-PREMISE-NO-NUM        TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7920-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** DELETE SESSION TABLE - HEADER                                **        
      ******************************************************************        
      *                                                                         
       8000A-DELETE-GTT-ROWS-HDR.                                       
      *                                                                         
           MOVE                                                         
           'DELETE GLOBAL TEMPORARY TABLE CSR04682_HDR'                 
                                             TO S-SQL-STATEMENT-V.      
      *                                                                         
            EXEC SQL                                                    
                DELETE FROM #CSR04682_HDR                        
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR04682_HDR                                
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE '8000A'                  TO ACTIVE-PARAGRAPH        
               MOVE 'DELETE'                 TO ABEND-FUNCTION          
               MOVE SPACES                   TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
               MOVE 'CSR04682_HDR'           TO TABLE-1                 
               MOVE SPACES                   TO TABLE-ELEMENT-1         
               MOVE SPACES                   TO HOSTVAR-ELEMENT-1       
               PERFORM 9000-SEND-ERROR-RESULT THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       8000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** DELETE SESSION TABLE - ACCT RECV TRNS HIST DETAILS           **        
      ******************************************************************        
      *                                                                         
       8000B-DELETE-GTT-ROWS-ACR.                                       
      *                                                                         
           MOVE                                                         
           'DELETE GLOBAL TEMPORARY TABLE CSR04682_ACR'                 
                                             TO S-SQL-STATEMENT-V.      
      *                                                                         
            EXEC SQL                                                    
                DELETE FROM #CSR04682_ACR                        
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR04682_ACR                                
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE '8000B'                  TO ACTIVE-PARAGRAPH        
               MOVE 'DELETE'                 TO ABEND-FUNCTION          
               MOVE SPACES                   TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
               MOVE 'CSR04682_ACR'           TO TABLE-1                 
               MOVE SPACES                   TO TABLE-ELEMENT-1         
               MOVE SPACES                   TO HOSTVAR-ELEMENT-1       
               PERFORM 9000-SEND-ERROR-RESULT THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       8000B-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** DELETE SESSION TABLE - MAINTAIN TRNS HIST DETAILS            **        
      ******************************************************************        
      *                                                                         
       8000C-DELETE-GTT-ROWS-MNT.                                       
      *                                                                         
           MOVE                                                         
           'DELETE GLOBAL TEMPORARY TABLE CSR04682_MNT'                 
                                             TO S-SQL-STATEMENT-V.      
      *                                                                         
            EXEC SQL                                                    
                DELETE FROM #CSR04682_MNT                        
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR04682_MNT                                
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE '8000C'                  TO ACTIVE-PARAGRAPH        
               MOVE 'DELETE'                 TO ABEND-FUNCTION          
               MOVE SPACES                   TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
               MOVE 'CSR04682_MNT'           TO TABLE-1                 
               MOVE SPACES                   TO TABLE-ELEMENT-1         
               MOVE SPACES                   TO HOSTVAR-ELEMENT-1       
               PERFORM 9000-SEND-ERROR-RESULT THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       8000C-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** SEND RESULT SET - HEADER                                     **        
      ******************************************************************        
      *                                                                         
       8100A-SEND-RESULT-HDR.                                           
      *                                                                         
           EXEC SQL                                                     
             INSERT INTO #CSR04682_HDR                           
             (                                                          
              RETURN_CODE                                               
             ,TRANS_HIST_SEQ_NO                                         
             ,CODE_TRAN_TYPE                                            
             ,APPL_PROGRAM_DESC                                         
             ,EMPLOYEE_NAME                                             
             ,RESP_AREA_ID                                              
             ,TRAN_COMMENT                                              
             ,ACCOUNT_NO                                                
             ,CUSTOMER_NO                                               
             ,PREMISE_NO                                                
             ,AMT_ORIG_ENTERED                                          
             ,AMT_BILLED_UNPAID                                         
             ,RECORD_ONLY_FL                                            
PRJ586       ,PYMT_REFUNDED_IND                                         
             ,CASH_LOCAL_OFFICE                                         
             ,DATE_CASH_REPORT                                          
             ,DATE_ORIG_PYMT                                            
             ,DRAWER_ID                                                 
             ,DRAWER_STATUS                                             
             ,PYMT_FACILITY_CD                                          
             ,PYMT_FACILITY_DESC                                        
             ,TABLE_CD                                                  
             ,MORE_DATA_AVLB_FL                                         
             ,FULL_NAME                                                 
             ,ADDRESS_LINE_1                                            
             ,ADDRESS_LINE_2                                            
             )                                                          
             VALUES                                                     
             (                                                          
              :S-H-RETURN-CODE                                          
             ,:S-H-TRANS-HIST-SEQ-NO                                    
             ,:S-H-CODE-TRAN-TYPE                                       
             ,:S-H-APPL-PROGRAM-DESC                                    
             ,:S-H-EMPLOYEE-NAME                                        
             ,:S-H-RESP-AREA-ID                                         
             ,:S-H-TRAN-COMMENT                                         
             ,:S-H-ACCOUNT-NO                                           
             ,:S-H-CUSTOMER-NO                                          
             ,:S-H-PREMISE-NO                                           
             ,:S-H-AMT-ORIG-ENTERED                                     
             ,:S-H-AMT-BILLED-UNPAID                                    
             ,:S-H-RECORD-ONLY-FL                                       
PRJ586       ,:S-H-PYMT-REFUNDED-IND                                    
             ,:S-H-CASH-LOCAL-OFFICE                                    
             ,:S-H-DATE-CASH-REPORT                                     
             ,:S-H-DATE-ORIG-PYMT                                       
             ,:S-H-DRAWER-ID                                            
             ,:S-H-DRAWER-STATUS                                        
             ,:S-H-PYMT-FACILITY-CD                                     
             ,:S-H-PYMT-FACILITY-DESC                                   
             ,:S-H-TABLE-CD                                             
             ,:S-H-MORE-DATA-AVLB-FL                                    
             ,:S-H-FULL-NAME                                            
             ,:S-H-ADDRESS-LINE-1                                       
             ,:S-H-ADDRESS-LINE-2                                       
             )                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04682_HDR                                   
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,TRANS_HIST_SEQ_NO                                                 
MFA-TR*      ,CODE_TRAN_TYPE                                                    
MFA-TR*      ,APPL_PROGRAM_DESC                                                 
MFA-TR*      ,EMPLOYEE_NAME                                                     
MFA-TR*      ,RESP_AREA_ID                                                      
MFA-TR*      ,TRAN_COMMENT                                                      
MFA-TR*      ,ACCOUNT_NO                                                        
MFA-TR*      ,CUSTOMER_NO                                                       
MFA-TR*      ,PREMISE_NO                                                        
MFA-TR*      ,AMT_ORIG_ENTERED                                                  
MFA-TR*      ,AMT_BILLED_UNPAID                                                 
MFA-TR*      ,RECORD_ONLY_FL                                                    
MFA-TR*      ,PYMT_REFUNDED_IND                                                 
MFA-TR*      ,CASH_LOCAL_OFFICE                                                 
MFA-TR*      ,DATE_CASH_REPORT                                                  
MFA-TR*      ,DATE_ORIG_PYMT                                                    
MFA-TR*      ,DRAWER_ID                                                         
MFA-TR*      ,DRAWER_STATUS                                                     
MFA-TR*      ,PYMT_FACILITY_CD                                                  
MFA-TR*      ,PYMT_FACILITY_DESC                                                
MFA-TR*      ,TABLE_CD                                                          
MFA-TR*      ,MORE_DATA_AVLB_FL                                                 
MFA-TR*      ,FULL_NAME                                                         
MFA-TR*      ,ADDRESS_LINE_1                                                    
MFA-TR*      ,ADDRESS_LINE_2                                                    
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S-H-RETURN-CODE                                                  
MFA-TR*      ,:S-H-TRANS-HIST-SEQ-NO                                            
MFA-TR*      ,:S-H-CODE-TRAN-TYPE                                               
MFA-TR*      ,:S-H-APPL-PROGRAM-DESC                                            
MFA-TR*      ,:S-H-EMPLOYEE-NAME                                                
MFA-TR*      ,:S-H-RESP-AREA-ID                                                 
MFA-TR*      ,:S-H-TRAN-COMMENT                                                 
MFA-TR*      ,:S-H-ACCOUNT-NO                                                   
MFA-TR*      ,:S-H-CUSTOMER-NO                                                  
MFA-TR*      ,:S-H-PREMISE-NO                                                   
MFA-TR*      ,:S-H-AMT-ORIG-ENTERED                                             
MFA-TR*      ,:S-H-AMT-BILLED-UNPAID                                            
MFA-TR*      ,:S-H-RECORD-ONLY-FL                                               
MFA-TR*      ,:S-H-PYMT-REFUNDED-IND                                            
MFA-TR*      ,:S-H-CASH-LOCAL-OFFICE                                            
MFA-TR*      ,:S-H-DATE-CASH-REPORT                                             
MFA-TR*      ,:S-H-DATE-ORIG-PYMT                                               
MFA-TR*      ,:S-H-DRAWER-ID                                                    
MFA-TR*      ,:S-H-DRAWER-STATUS                                                
MFA-TR*      ,:S-H-PYMT-FACILITY-CD                                             
MFA-TR*      ,:S-H-PYMT-FACILITY-DESC                                           
MFA-TR*      ,:S-H-TABLE-CD                                                     
MFA-TR*      ,:S-H-MORE-DATA-AVLB-FL                                            
MFA-TR*      ,:S-H-FULL-NAME                                                    
MFA-TR*      ,:S-H-ADDRESS-LINE-1                                               
MFA-TR*      ,:S-H-ADDRESS-LINE-2                                               
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8100A'                    TO ACTIVE-PARAGRAPH       
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE 'CSR04682_HDR'             TO TABLE-1                
              MOVE 'CALL_TYPE'                TO TABLE-ELEMENT-1        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE 'TRNS_HIST_FROM_TS'        TO TABLE-ELEMENT-3        
              MOVE 'TRNS_HIST_TO_TS'          TO TABLE-ELEMENT-4        
              MOVE PARM-CALL-TYPE             TO HOSTVAR-ELEMENT-1      
              MOVE PARM-ACCOUNT-NO-NUM        TO HOSTVAR-ELEMENT-2      
              MOVE PARM-TRNS-HIST-FROM-TS     TO HOSTVAR-ELEMENT-3      
              MOVE PARM-TRNS-HIST-TO-TS       TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT THRU  9000-EXIT            
           END-IF.                                                      
      *                                                                         
           ADD 1                              TO CTR-ROWS-HDR.          
      *                                                                         
       8100A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      ** SEND RESULT SET - ACCT RECV TRNS HIST DETAILS                **        
      ******************************************************************        
      *                                                                         
       8100B-SEND-RESULT-ACR.                                           
      *                                                                         
           EXEC SQL                                                     
             INSERT INTO #CSR04682_ACR                           
             (                                                          
              RETURN_CODE                                               
             ,ACCOUNT_NO                                                
             ,TRANS_HIST_SEQ_NO                                         
             ,CODE_AR_AGE_DESC                                          
             ,GL_ACCT_CREDIT                                            
             ,GL_ACCT_DEBIT                                             
             ,AMT_POSTED                                                
             ,ITEM_ID                                                   
             ,CNT_NAME_DESC                                             
             ,CURRENCY_TYPE                                             
             )                                                          
             VALUES                                                     
             (                                                          
              :S-A-RETURN-CODE                                          
             ,:S-A-ACCOUNT-NO                                           
             ,:S-A-TRANS-HIST-SEQ-NO                                    
             ,:S-A-CODE-AR-AGE-DESC                                     
             ,:S-A-GL-ACCT-CREDIT                                       
             ,:S-A-GL-ACCT-DEBIT                                        
             ,:S-A-AMT-POSTED                                           
             ,:S-A-ITEM-ID                                              
             ,:S-A-CNT-NAME-DESC                                        
             ,:S-A-CURRENCY-TYPE                                        
             )                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04682_ACR                                   
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,ACCOUNT_NO                                                        
MFA-TR*      ,TRANS_HIST_SEQ_NO                                                 
MFA-TR*      ,CODE_AR_AGE_DESC                                                  
MFA-TR*      ,GL_ACCT_CREDIT                                                    
MFA-TR*      ,GL_ACCT_DEBIT                                                     
MFA-TR*      ,AMT_POSTED                                                        
MFA-TR*      ,ITEM_ID                                                           
MFA-TR*      ,CNT_NAME_DESC                                                     
MFA-TR*      ,CURRENCY_TYPE                                                     
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S-A-RETURN-CODE                                                  
MFA-TR*      ,:S-A-ACCOUNT-NO                                                   
MFA-TR*      ,:S-A-TRANS-HIST-SEQ-NO                                            
MFA-TR*      ,:S-A-CODE-AR-AGE-DESC                                             
MFA-TR*      ,:S-A-GL-ACCT-CREDIT                                               
MFA-TR*      ,:S-A-GL-ACCT-DEBIT                                                
MFA-TR*      ,:S-A-AMT-POSTED                                                   
MFA-TR*      ,:S-A-ITEM-ID                                                      
MFA-TR*      ,:S-A-CNT-NAME-DESC                                                
MFA-TR*      ,:S-A-CURRENCY-TYPE                                                
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8100B'                    TO ACTIVE-PARAGRAPH       
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE 'CSR04682_ACR'             TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'TRANS_HIST_SEQ_NO'        TO TABLE-ELEMENT-2        
              MOVE 'TRNS_HIST_FROM_TS'        TO TABLE-ELEMENT-3        
              MOVE 'TRNS_HIST_TO_TS'          TO TABLE-ELEMENT-4        
              MOVE AU-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE AU-TRANS-HIST-SEQ-NO       TO HOSTVAR-ELEMENT-2      
              MOVE PARM-TRNS-HIST-FROM-TS     TO HOSTVAR-ELEMENT-3      
              MOVE PARM-TRNS-HIST-TO-TS       TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT THRU  9000-EXIT            
           END-IF.                                                      
      *                                                                         
           ADD 1                              TO CTR-ROWS-ACR.          
      *                                                                         
       8100B-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      ** SEND RESULT SET - MAINTAIN TRNS HIST DETAILS                 **        
      ******************************************************************        
      *                                                                         
       8100C-SEND-RESULT-MNT.                                           
      *                                                                         
           EXEC SQL                                                     
             INSERT INTO #CSR04682_MNT                           
             (                                                          
              RETURN_CODE                                               
             ,TRANS_HIST_SEQ_NO                                         
             ,COLUMN_DESC                                               
             ,PRV_COLUMN_VALUE                                          
             ,CHG_COLUMN_VALUE                                          
             )                                                          
             VALUES                                                     
             (                                                          
              :S-M-RETURN-CODE                                          
             ,:S-M-TRANS-HIST-SEQ-NO                                    
             ,:S-M-COLUMN-DESC                                          
             ,:S-M-PRV-COLUMN-VALUE                                     
             ,:S-M-CHG-COLUMN-VALUE                                     
             )                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04682_MNT                                   
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,TRANS_HIST_SEQ_NO                                                 
MFA-TR*      ,COLUMN_DESC                                                       
MFA-TR*      ,PRV_COLUMN_VALUE                                                  
MFA-TR*      ,CHG_COLUMN_VALUE                                                  
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S-M-RETURN-CODE                                                  
MFA-TR*      ,:S-M-TRANS-HIST-SEQ-NO                                            
MFA-TR*      ,:S-M-COLUMN-DESC                                                  
MFA-TR*      ,:S-M-PRV-COLUMN-VALUE                                             
MFA-TR*      ,:S-M-CHG-COLUMN-VALUE                                             
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8100C'                    TO ACTIVE-PARAGRAPH       
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE 'CSR04682_MNT'             TO TABLE-1                
              MOVE 'TRANS_HIST_SEQ_NO'        TO TABLE-ELEMENT-1        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE 'CUSTOMER_NO'              TO TABLE-ELEMENT-3        
              MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-4        
              MOVE MI-TRANS-HIST-SEQ-NO       TO HOSTVAR-ELEMENT-1      
              MOVE PARM-ACCOUNT-NO-NUM        TO HOSTVAR-ELEMENT-2      
              MOVE PARM-CUSTOMER-NO-NUM       TO HOSTVAR-ELEMENT-3      
              MOVE PARM-PREMISE-NO-NUM        TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT THRU  9000-EXIT            
           END-IF.                                                      
      *                                                                         
           ADD 1                              TO CTR-ROWS-MNT.          
      *                                                                         
       8100C-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      ** 8900-SEND-DONE                                               **        
      ******************************************************************        
      *                                                                         
       8900-SEND-DONE.                                                  
      *                                                                         
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                         
           EXEC SQL                                                     
               OPEN C2                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                         
           EXEC SQL                                                     
               OPEN C3                                                  
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C3 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
                                                    
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 9000-SEND-ERROR-RESULT                                       **        
      ******************************************************************        
      *                                                                         
       9000-SEND-ERROR-RESULT.                                          
      *                                                                         
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'          TO ABEND-FUNCTION                
           END-IF.                                                      
      *                                                                         
           INITIALIZE                     GTT-RETURN-FIELDS.            
      *                                                                         
           MOVE WS-ACTIVE-RETURN-CODE  TO S-H-RETURN-CODE               
                                          S-A-RETURN-CODE               
                                          S-M-RETURN-CODE.              
      *                                                                         
           PERFORM 0100A-DECLARE-GTT-HDR   THRU  0100A-EXIT.            
           PERFORM 0100B-DECLARE-GTT-ACR   THRU  0100B-EXIT.            
           PERFORM 0100C-DECLARE-GTT-MNT   THRU  0100C-EXIT.            
      *                                                                         
           PERFORM 8100A-SEND-RESULT-HDR   THRU  8100A-EXIT.            
           PERFORM 8100B-SEND-RESULT-ACR   THRU  8100B-EXIT.            
           PERFORM 8100C-SEND-RESULT-MNT   THRU  8100C-EXIT.            
      *                                                                         
           PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT.             
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 9900-SQL-ERROR-ROUTINE                                       **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      ** 9999-END-PROGRAM                                             **        
      ******************************************************************        
      *                                                                         
       9999-END-PROGRAM.                                                
      *                                                                         
           PERFORM 8900-SEND-DONE      THRU  8900-EXIT.                 
      *                                                                         
           
MSQ016        GOBACK.                                                    
      *                                                                         
       9999-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
