       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04679.                                         
       DATE-WRITTEN.  12/12/2013.                                       
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  TRANID:                                                       *        
      *  PROGRAM:                                                      *        
      *  CALLING SP:                                                   *        
      *  BUSINESOP : RequUpdWorkQueueBusinessOp                        *        
      *  INPUT     : I-ITEM-ID                                         *        
      *              I_CATEGORY_ID                                     *        
      *              I_RESP_AREA_ID                                    *        
      *              I_USER_ID_ASGN                                    *        
      *              I_STATUS                                          *        
      *              I_PRIORITY                                        *        
      *              I_DATE_REQUIRED                                   *        
      *              I_COMMENTS                                        *        
      *                                                                *        
      *--      OUT                                                   --         
      *--           NONE                                             --         
      *--                                                            --         
      *--      INOUT                                                 --         
      *--                                                            --         
      *--           NONE                                             --         
      *--                                                            --         
      *--  RESULT SET                                                --         
      *--      1. CSR04679_R1 - CSS_WQ_ITEMS                         --         
      *--           RETURN_CODE             INTEGER                  --         
      *             APPL_RETURN_CODE        INTEGER                   *         
      *--                                                            --         
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
P00757*  12/2013   MC95456    INITIAL VERSION.                         *        
ACT209*  06/2014   AS7C117    ADD THE ASSGN_HIST_PRES_FL COLUMN IN     *        
      *            APPL4880   7000-SELECT-WQ-ITEMS TO AVIOD TO UPDATE  *        
      *                       THE JUNK VALUE.                          *        
ACT006*  01/2016   MC95456    RELEASE ACCOUNTS FOR BILLING WHICH ARE   *        
ACT006*            APPL5460   HAVING WQ CATEGORY 581 AND 582.          *        
ACT101*  04/2016   TP7R341    CHANGE STATUS FROM IN-PROGRESS TO        *        
ACT101*            APPL5460   ASSIGNED WHILE REASSIGNING TASK          *        
ACT352*  11/2016   RS7V450    ADDING WQ-CATEGORY-ID WS-134.            *        
ACT352*            APPL5460                                            *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION, ABEND, MESSAGING MODULES            *        
      ******************************************************************        
      *                                                                *        
      *              RETURN CODES AND MEANINGS                         *        
      *  ANY -   ERROR                                                 *        
      *   0      RECORD WAS FOUND                                      *        
      *   100    RECORD WAS NOT FOUND                                  *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04679'.
MSQ017     COPY MFASQLM.
       01  WS-START                           PIC X(40) VALUE           
           'WORKING STORAGE FOR CSR04679 STARTS HERE'.                  
                                                                        
                                                                        
       01 WORK-FIELDS.                                                  
          05 SEND-DONE-SW                PIC X(01) VALUE 'Y'.           
             88 SEND-DONE-ERROR                    VALUE 'N'.           
             88 SEND-DONE-OK                       VALUE 'Y'.           
          05 PROGRAM-NAME                PIC X(08) VALUE 'CSR04679'.    
          05 WS-DR-NULL                  PIC S9(04) COMP.               
          05 WS-CD-NULL                  PIC S9(04) COMP.               
          05 WS-ITEM-ID                  PIC 9(10).                     
          05 WS-581                      PIC S9(04) COMP VALUE 581.     
          05 WS-582                      PIC S9(04) COMP VALUE 582.     
ACT352    05 WS-134                      PIC S9(04) COMP VALUE 134.     
ACT352    05 WS-READ-POSTED              PIC X(01) VALUE 'R'.           
          05 WS-C                        PIC X(01) VALUE 'C'.           
          05 WS-H                        PIC X(01) VALUE 'H'.           
          05 WS-TRAN-APPL-NO             PIC S9(04) COMP VALUE 0.       
          05 GTT-NAME                    PIC X(26)                      
                                            VALUE 'SESSION.CSR04679_R1'.
                                                                        
      *                                                                         
      ******************************************************************        
      *    RESULT SET COLUMN NAMES                                     *        
      ******************************************************************        
                                                                        
       01 GTT-RETURN-FIELDS.                                            
          05 S-RETURN-CODE               PIC S9(8)  COMP VALUE 0.       
          05 S-APPL-RETURN-CODE          PIC S9(8)  COMP VALUE 0.       
                                                                        
      ******************************************************************        
      * INCLUDE SQLCA                                                           
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ****************************************************************          
ACT352*    CSS_ACCOUNT  AT                                                      
ACT352*****************************************************************         
ACT352     EXEC SQL                                                     03980000
ACT352        INCLUDE TBACCT                                            03990000
ACT352     END-EXEC.                                                    04000000
      *****************************************************************         
      *   CSS_MNT_TRANS_HIST MH                                      *          
      ****************************************************************          
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
                                                                        
      ****************************************************************          
      *   CSS_MT_TRN_HST_DET MI                                      *          
      ****************************************************************          
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * INCLUDE CSS_WQ_ASSGN_HSTY          WI                                   
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBWQHTY                                                   
           END-EXEC.                                                            
                                                                        
                                                                        
      ******************************************************************        
      * INCLUDE CSS_WQ_ITEMS               WQ                                   
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBWQITS                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * SUPPORTS DB2 AND SQL ERROR CHECKING                                     
      ******************************************************************        
           COPY CWS00303.                                                       
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE CWSSP001                                                 
           END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-ITEM-ID               PIC X(10).                        
       01  PARM-CATEGORY-ID           PIC S9(04)  USAGE COMP.           
       01  PARM-RESP-AREA-ID          PIC X(03).                        
       01  PARM-USER-ID-ASGN          PIC X(07).                        
       01  PARM-STATUS                PIC X(01).                        
       01  PARM-PRIORITY              PIC X(01).                        
       01  PARM-DATE-REQUIRED         PIC X(26).                        
       01  PARM-COMMENTS.                                               
           49 PARM-COMMENTS-LEN       PIC S9(4) USAGE COMP.             
           49 PARM-COMMENTS-TEXT      PIC X(250).                       
                                                                        
       PROCEDURE DIVISION USING PARM-ITEM-ID                            
                                PARM-CATEGORY-ID                        
                                PARM-RESP-AREA-ID                       
                                PARM-USER-ID-ASGN                       
                                PARM-STATUS                             
                                PARM-PRIORITY                           
                                PARM-DATE-REQUIRED                      
                                PARM-COMMENTS.                          
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE            THRU 0100-EXIT.           
           PERFORM 1000-PROCESS               THRU 1000-EXIT.           
           PERFORM 9999-END-PROGRAM           THRU 9999-EXIT.           
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      *     1. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *                                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           PERFORM 0100A-DECLARE-GTT          THRU 0100A-EXIT.          
                                                                        
           IF PARM-ITEM-ID IS NUMERIC                                   
              MOVE PARM-ITEM-ID               TO WS-ITEM-ID             
              MOVE WS-ITEM-ID                 TO WQ-ITEM-ID             
           ELSE                                                         
              INITIALIZE                         GTT-RETURN-FIELDS      
              MOVE 200                        TO S-APPL-RETURN-CODE     
              PERFORM 8100-SEND-RESULT        THRU 8100-EXIT            
              PERFORM 9999-END-PROGRAM        THRU 9999-EXIT            
           END-IF.                                                      
                                                                        
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       0100A-DECLARE-GTT.                                               
      *================================================================*        
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04679_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04679_R1
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
                                                                        
           IF SQLSTATE = '42710'                                        
              PERFORM 8000A-DELETE-GTT-ROWS    THRU 8000A-EXIT          
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME             TO ABEND-PROGRAM         
                 MOVE '0100A'                  TO ACTIVE-PARAGRAPH      
                 MOVE SQLCODE                  TO ABEND-SQLCODE         
                 MOVE SQLSTATE                 TO ABEND-SQLSTATE        
                 MOVE 'DECLARE GTT'            TO ABEND-FUNCTION        
                 MOVE SPACES                   TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
                 MOVE 'CSR04679_R1'            TO TABLE-1               
                 MOVE SPACES                   TO TABLE-ELEMENT-1       
                 MOVE SPACES                   TO HOSTVAR-ELEMENT-1     
                 PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT           
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT                                                  
                   *                                                    
                  FROM #CSR04679_R1                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT                                                          
MFA-TR*            *                                                            
MFA-TR*           FROM SESSION.CSR04679_R1                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      *================================================================*        
       1000-PROCESS.                                                    
      *================================================================*        
                                                                        
           MOVE '1000'                            TO ACTIVE-PARAGRAPH.  
                                                                        
           PERFORM 7000-SELECT-WQ-ITEMS           THRU 7000-EXIT.       
           PERFORM 2000-PROCESS-OUTPUT            THRU 2000-EXIT.       
           PERFORM 8100-SEND-RESULT               THRU 8100-EXIT.       
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       2000-PROCESS-OUTPUT.                                             
      *================================================================*        
                                                                        
           MOVE '2000'                            TO ACTIVE-PARAGRAPH.  
                                                                        
           MOVE WQ-ITEM-ID                 TO WI-ITEM-ID                
           MOVE WQ-COMPANY-NO              TO WI-COMPANY-NO             
           MOVE WQ-RESP-AREA-ID            TO WI-RESP-AREA-ID           
           MOVE WQ-USER-ID-ASGN            TO WI-USER-ID                
                                                                        
           IF PARM-STATUS > SPACES                                      
              MOVE PARM-STATUS             TO WQ-STATUS                 
           END-IF.                                                      
           IF PARM-CATEGORY-ID > 0                                      
ACT101        IF PARM-CATEGORY-ID NOT = WQ-CATEGORY-ID                  
ACT101           MOVE 'A'                  TO WQ-STATUS                 
ACT101        END-IF                                                    
              MOVE PARM-CATEGORY-ID        TO WQ-CATEGORY-ID            
           END-IF.                                                      
           IF PARM-RESP-AREA-ID > SPACES                                
ACT101        IF PARM-RESP-AREA-ID NOT = WQ-RESP-AREA-ID                
ACT101           MOVE 'A'                  TO WQ-STATUS                 
ACT101        END-IF                                                    
              MOVE PARM-RESP-AREA-ID       TO WQ-RESP-AREA-ID           
           END-IF.                                                      
           IF PARM-DATE-REQUIRED > SPACES                               
              MOVE 0                       TO WS-DR-NULL                
              MOVE PARM-DATE-REQUIRED      TO WQ-DATE-REQUIRED          
           END-IF.                                                      
           IF PARM-COMMENTS-LEN      > ZEROS                            
              MOVE PARM-COMMENTS           TO WQ-COMMENTS               
           END-IF.                                                      
           IF PARM-STATUS = 'C'                                         
              PERFORM 7700-GET-CURR-TIME-STAMP THRU 7700-EXIT           
              MOVE 0                       TO WS-CD-NULL                
           END-IF.                                                      
           IF PARM-PRIORITY  > SPACES                                   
              MOVE PARM-PRIORITY           TO WQ-PRIORITY               
           END-IF.                                                      
           IF WQ-DATE-REQUIRED = SPACES                                 
              MOVE -1                      TO WS-DR-NULL                
           END-IF.                                                      
           IF WQ-COMPLETE-DATE = SPACES                                 
              MOVE -1                      TO WS-CD-NULL                
           END-IF.                                                      
           IF WQ-USER-ID-ASGN    = 'STORM'                              
              IF PARM-USER-ID-ASGN  NOT EQUAL WQ-USER-ID-ASGN           
                 INITIALIZE                   GTT-RETURN-FIELDS         
                 MOVE -2                      TO S-RETURN-CODE          
                 MOVE 200                     TO S-APPL-RETURN-CODE     
                 PERFORM 8100-SEND-RESULT     THRU 8100-EXIT            
                 PERFORM 9999-END-PROGRAM     THRU 9999-EXIT            
              END-IF                                                    
           END-IF.                                                      
           IF PARM-USER-ID-ASGN NOT EQUAL WQ-USER-ID-ASGN               
              MOVE PARM-USER-ID-ASGN           TO WQ-USER-ID-ASGN       
              MOVE 'Y'                         TO WQ-ASSGN-HIST-PRES-FL 
ACT101        MOVE 'A'                         TO WQ-STATUS             
              PERFORM 7600-INSERT-WQ-ASSGN-HIST THRU 7600-EXIT          
           END-IF.                                                      
                                                                        
           PERFORM 7500-UPDATE-WQ-ITEMS     THRU 7500-EXIT.             
                                                                        
ACT352     IF (WQ-CATEGORY-ID = WS-581 OR WS-582 OR WS-134) AND         
ACT006                          WQ-STATUS = WS-C                        
ACT352        IF WQ-CATEGORY-ID = WS-134                                
ACT352           MOVE SPACES TO AT-CODE-ACCT-BILLED                     
ACT352        ELSE                                                      
ACT352           MOVE WS-READ-POSTED TO AT-CODE-ACCT-BILLED             
ACT352        END-IF                                                    
ACT006        PERFORM 7550-UPDATE-ACCOUNT   THRU 7550-EXIT              
ACT006        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
ACT006           PERFORM 2500-WRITE-TRANS-HIST THRU 2500-EXIT           
ACT006        END-IF                                                    
ACT006     END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
ACT006****************************************************************          
ACT006*  2500-WRITE-TRANS-HIST.                                      *          
ACT006****************************************************************          
ACT006                                                                  
ACT006 2500-WRITE-TRANS-HIST.                                           
ACT006                                                                  
ACT006     PERFORM 7400-SELECT-MH-DATE-TIME   THRU 7400-EXIT.           
ACT006     MOVE MH-TRANS-HIST-SEQ-NO          TO MI-TRANS-HIST-SEQ-NO.  
ACT006     MOVE 'F'                           TO MH-CODE-TRAN-TYPE.     
ACT006     MOVE SPACES                        TO MH-RESP-AREA-ID.       
ACT006     MOVE ZEROS                         TO MH-CUSTOMER-NO         
ACT006                                           MH-PREMISE-NO.         
ACT006     MOVE 'SYSTEM'                      TO MH-USER-ID             
ACT006     MOVE PROGRAM-NAME                  TO MH-APPL-PROGRAM-ID.    
ACT006     MOVE WQ-ACCOUNT-NO                 TO MH-ACCOUNT-NO.         
ACT006     MOVE SPACES                        TO MH-TRAN-COMMENT-TEXT.  
ACT006     MOVE MH-TRANS-HIST-SEQ-NO          TO MI-TRANS-HIST-SEQ-NO.  
ACT006     STRING 'ACCOUNT RELEASED FOR BILLING'                        
ACT006            DELIMITED BY SIZE        INTO MH-TRAN-COMMENT-TEXT    
ACT006     END-STRING                                                   
ACT006     MOVE LENGTH OF MH-TRAN-COMMENT-TEXT                          
ACT006                                       TO MH-TRAN-COMMENT-LEN.    
ACT006     MOVE 1                            TO WS-TRAN-APPL-NO.        
ACT006                                                                  
ACT006     MOVE WS-TRAN-APPL-NO              TO MI-TRAN-APPL-NO.        
ACT006     MOVE WS-H                         TO MI-PRV-COLUMN-VALUE-TEXT
ACT006     MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
ACT006                                       TO MI-PRV-COLUMN-VALUE-LEN 
ACT352     MOVE AT-CODE-ACCT-BILLED          TO MI-CHG-COLUMN-VALUE-TEXT
ACT006     MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
ACT006                                       TO MI-CHG-COLUMN-VALUE-LEN 
ACT006     MOVE 'ACCT BILLED CD'             TO MI-COLUMN-DESC.         
ACT006     MOVE '72'                         TO MI-TABLE-ID.            
ACT006     PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT.         
ACT006     ADD  1                            TO WS-TRAN-APPL-NO.        
ACT006                                                                  
      *                                                                         
ACT006 2500-EXIT.                                                       
ACT006      EXIT.                                                       
      *================================================================*        
       7000-SELECT-WQ-ITEMS.                                            
      *================================================================*        
                                                                        
           EXEC SQL                                                     
              SELECT WQ.CATEGORY_ID                                     
                    ,WQ.COMPANY_NO                                      
                    ,WQ.RESP_AREA_ID                                    
                    ,WQ.USER_ID_ASGN                                    
                    ,WQ.STATUS                                          
                    ,REPLACE(REPLACE(CONVERT(CHAR(26), WQ.DATE_REQUIRED
           , 121), ' ', '-'), ':', '.') DATE_REQUIRED                          
                    ,WQ.COMMENTS                                        
                    ,REPLACE(REPLACE(CONVERT(CHAR(26), WQ.COMPLETE_DATE
           , 121), ' ', '-'), ':', '.') COMPLETE_DATE                          
                    ,WQ.PRIORITY                                        
ACT209              ,WQ.ASSGN_HIST_PRES_FL                              
ACT006              ,WQ.ACCOUNT_NO                                      
                INTO :WQ-CATEGORY-ID                                    
                    ,:WQ-COMPANY-NO                                     
                    ,:WQ-RESP-AREA-ID                                   
                    ,:WQ-USER-ID-ASGN                                   
                    ,:WQ-STATUS                                         
                    ,:WQ-DATE-REQUIRED :WS-DR-NULL                       
                    ,:WQ-COMMENTS                                       
                    ,:WQ-COMPLETE-DATE :WS-CD-NULL                       
                    ,:WQ-PRIORITY                                       
ACT209              ,:WQ-ASSGN-HIST-PRES-FL                             
ACT006              ,:WQ-ACCOUNT-NO                                     
                FROM CSS_WQ_ITEMS WQ WITH(READUNCOMMITTED)                      
               WHERE WQ.ITEM_ID = :WQ-ITEM-ID                           
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT WQ.CATEGORY_ID                                             
MFA-TR*             ,WQ.COMPANY_NO                                              
MFA-TR*             ,WQ.RESP_AREA_ID                                            
MFA-TR*             ,WQ.USER_ID_ASGN                                            
MFA-TR*             ,WQ.STATUS                                                  
MFA-TR*             ,WQ.DATE_REQUIRED                                           
MFA-TR*             ,WQ.COMMENTS                                                
MFA-TR*             ,WQ.COMPLETE_DATE                                           
MFA-TR*             ,WQ.PRIORITY                                                
MFA-TR*             ,WQ.ASSGN_HIST_PRES_FL                                      
MFA-TR*             ,WQ.ACCOUNT_NO                                              
MFA-TR*         INTO :WQ-CATEGORY-ID                                    00088700
MFA-TR*             ,:WQ-COMPANY-NO                                             
MFA-TR*             ,:WQ-RESP-AREA-ID                                   00088800
MFA-TR*             ,:WQ-USER-ID-ASGN                                   00088800
MFA-TR*             ,:WQ-STATUS                                                 
MFA-TR*             ,:WQ-DATE-REQUIRED:WS-DR-NULL                               
MFA-TR*             ,:WQ-COMMENTS                                               
MFA-TR*             ,:WQ-COMPLETE-DATE:WS-CD-NULL                               
MFA-TR*             ,:WQ-PRIORITY                                               
MFA-TR*             ,:WQ-ASSGN-HIST-PRES-FL                                     
MFA-TR*             ,:WQ-ACCOUNT-NO                                             
MFA-TR*         FROM CSS_WQ_ITEMS WQ                                            
MFA-TR*        WHERE WQ.ITEM_ID = :WQ-ITEM-ID                                   
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-DR-NULL  < 0                                        
                 MOVE SPACES TO WQ-DATE-REQUIRED                        
              END-IF                                                    
              IF WS-CD-NULL  < 0                                        
                 MOVE SPACES TO WQ-COMPLETE-DATE                        
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7000'              TO ACTIVE-PARAGRAPH              
              MOVE 'OPEN'              TO ABEND-FUNCTION                
              MOVE 'CSS_WQ_ITEMS'      TO TABLE-1                       
              MOVE 'ITEM_ID'           TO TABLE-ELEMENT-1               
              MOVE WQ-ITEM-ID          TO HOSTVAR-ELEMENT-1             
              PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
ACT006*****************************************************************         
ACT006* 7400-SELECT-MH-DATE-TIME.                                     *         
ACT006*****************************************************************         
ACT006 7400-SELECT-MH-DATE-TIME.                                        
ACT006                                                                  
ACT006     EXEC SQL                                                     
ACT006        SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :MH-TRANS-HIST-SEQ-NO,
              :MH-DATE-TRANS                  
ACT006     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :MH-TRANS-HIST-SEQ-NO = CURRENT TIMESTAMP                     
MFA-TR*          ,:MH-DATE-TRANS        = CURRENT DATE                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT006                                                                  
ACT006     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
ACT006                                          S-RETURN-CODE.          
ACT006                                                                  
ACT006     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
ACT006        NEXT SENTENCE                                             
ACT006     ELSE                                                         
ACT006        MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
ACT006        MOVE '7400'              TO ACTIVE-PARAGRAPH              
ACT006        MOVE 'SET'               TO ABEND-FUNCTION                
ACT006        PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
ACT006     END-IF.                                                      
ACT006                                                                  
ACT006 7400-EXIT.                                                       
ACT006     EXIT.                                                        
      *================================================================*        
       7500-UPDATE-WQ-ITEMS.                                            
      *================================================================*        
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_WQ_ITEMS                                       
                 SET CATEGORY_ID        = :WQ-CATEGORY-ID               
                    ,RESP_AREA_ID       = :WQ-RESP-AREA-ID              
                    ,USER_ID_ASGN       = :WQ-USER-ID-ASGN              
                    ,STATUS             = :WQ-STATUS                    
                    ,DATE_REQUIRED      = CIS.CHAR2TIMESTAMP(
                                                     :WQ-DATE-REQUIRED 
                                                             :WS-DR-NULL
              )  
                    ,COMMENTS           = :WQ-COMMENTS                  
                    ,COMPLETE_DATE      = CIS.CHAR2TIMESTAMP(
                                                     :WQ-COMPLETE-DATE 
                                                             :WS-CD-NULL
              )  
                    ,PRIORITY           = :WQ-PRIORITY                  
                    ,ASSGN_HIST_PRES_FL = :WQ-ASSGN-HIST-PRES-FL        
               WHERE ITEM_ID            = :WQ-ITEM-ID                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_WQ_ITEMS                                               
MFA-TR*          SET CATEGORY_ID        = :WQ-CATEGORY-ID                       
MFA-TR*             ,RESP_AREA_ID       = :WQ-RESP-AREA-ID                      
MFA-TR*             ,USER_ID_ASGN       = :WQ-USER-ID-ASGN                      
MFA-TR*             ,STATUS             = :WQ-STATUS                            
MFA-TR*             ,DATE_REQUIRED      = :WQ-DATE-REQUIRED:WS-DR-NULL          
MFA-TR*             ,COMMENTS           = :WQ-COMMENTS                          
MFA-TR*             ,COMPLETE_DATE      = :WQ-COMPLETE-DATE:WS-CD-NULL          
MFA-TR*             ,PRIORITY           = :WQ-PRIORITY                          
MFA-TR*             ,ASSGN_HIST_PRES_FL = :WQ-ASSGN-HIST-PRES-FL                
MFA-TR*        WHERE ITEM_ID            = :WQ-ITEM-ID                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                          S-RETURN-CODE.                
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7500'              TO ACTIVE-PARAGRAPH              
              MOVE 'UPDATE'            TO ABEND-FUNCTION                
              MOVE 'CSS_WQ_ITEMS'      TO TABLE-1                       
              MOVE 'ITEM_ID'           TO TABLE-ELEMENT-1               
              MOVE WQ-ITEM-ID          TO HOSTVAR-ELEMENT-1             
              PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
ACT006*================================================================*        
ACT006 7550-UPDATE-ACCOUNT.                                             
ACT006*================================================================*        
                                                                        
ACT006     EXEC SQL                                                     
ACT006        UPDATE CSS_ACCOUNT                                        
ACT006           SET CODE_ACCT_BILLED   = :AT-CODE-ACCT-BILLED          
ACT006         WHERE ACCOUNT_NO         = :WQ-ACCOUNT-NO                
ACT006           AND CODE_ACCT_BILLED   = :WS-H                         
ACT006     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
ACT006     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
ACT006                                    S-RETURN-CODE.                
ACT006                                                                  
ACT006     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
ACT006        CONTINUE                                                  
ACT006     ELSE                                                         
ACT006        MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
ACT006        MOVE '7550'              TO ACTIVE-PARAGRAPH              
ACT006        MOVE 'UPDATE'            TO ABEND-FUNCTION                
ACT006        MOVE 'CSS_ACCOUNT'       TO TABLE-1                       
ACT006        MOVE 'ACCOUNT NO'        TO TABLE-ELEMENT-1               
ACT006        MOVE WQ-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
ACT006        PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
ACT006     END-IF.                                                      
ACT006                                                                  
ACT006 7550-EXIT.                                                       
ACT006     EXIT.                                                        
      *================================================================*        
       7600-INSERT-WQ-ASSGN-HIST.                                       
      *================================================================*        
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_WQ_ASSGN_HSTY                             
                     ( COMPANY_NO                                       
                      ,ITEM_ID                                          
                      ,RESP_AREA_ID                                     
                      ,REASSIGN_DATE                                    
                      ,USER_ID)                                         
               VALUES( :WI-COMPANY-NO                                   
                      ,:WI-ITEM-ID                                      
                      ,:WI-RESP-AREA-ID                                 
                      ,CIS.CURRENT$TIMESTAMP()                                
                      ,:WI-USER-ID)                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_WQ_ASSGN_HSTY                                     
MFA-TR*              ( COMPANY_NO                                               
MFA-TR*               ,ITEM_ID                                                  
MFA-TR*               ,RESP_AREA_ID                                             
MFA-TR*               ,REASSIGN_DATE                                            
MFA-TR*               ,USER_ID)                                                 
MFA-TR*        VALUES( :WI-COMPANY-NO                                           
MFA-TR*               ,:WI-ITEM-ID                                              
MFA-TR*               ,:WI-RESP-AREA-ID                                         
MFA-TR*               ,CURRENT TIMESTAMP                                        
MFA-TR*               ,:WI-USER-ID)                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                          S-RETURN-CODE.                
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7600'              TO ACTIVE-PARAGRAPH              
              MOVE 'INSERT'            TO ABEND-FUNCTION                
              MOVE 'CSS_WQ_ASSGN_HSTY' TO TABLE-1                       
              MOVE 'ITEM_ID'           TO TABLE-ELEMENT-1               
              MOVE WQ-ITEM-ID          TO HOSTVAR-ELEMENT-1             
              PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
           END-IF.                                                      
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      *================================================================*        
       7700-GET-CURR-TIME-STAMP.                                        
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WQ-COMPLETE-DATE               
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WQ-COMPLETE-DATE = CURRENT TIMESTAMP                       
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
      *                                                                         
       7700-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *================================================================*        
       8000A-DELETE-GTT-ROWS.                                           
      *================================================================*        
                                                                        
           MOVE                                                         
           'DELETE ROWS'                                                
               TO S-SQL-STATEMENT-V.                                    
                                                                        
            EXEC SQL                                                    
                DELETE FROM #CSR04679_R1                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR04679_R1                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
                CONTINUE                                                
            ELSE                                                        
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8000A'              TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04679_R1'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       8000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 8100-SEND-RESULT                                              *         
      ******************************************************************        
      *                                                                         
       8100-SEND-RESULT.                                                
      *                                                                         
           EXEC SQL                                                     
              INSERT INTO #CSR04679_R1                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE                                       
                  ,:S-APPL-RETURN-CODE                                  
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04679_R1                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE                                               
MFA-TR*           ,:S-APPL-RETURN-CODE                                          
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                         TO WS-ACTIVE-RETURN-CODE
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                             TO CTR-ROWS            
           ELSE                                                         
              MOVE PROGRAM-NAME                  TO ABEND-PROGRAM       
              MOVE '8100'                        TO ACTIVE-PARAGRAPH    
              MOVE SQLCODE                       TO ABEND-SQLCODE       
              MOVE 'INSERT'                      TO ABEND-FUNCTION      
              MOVE SPACES                        TO ABEND-SQL-PREDICATES
                                                    ABEND-TABLES        
              MOVE 'CSR04679_R1'                 TO TABLE-1             
              MOVE SPACES                        TO TABLE-ELEMENT-1     
              MOVE SPACES                        TO HOSTVAR-ELEMENT-1   
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9700-PROCESS-ABEND                                             *        
      ******************************************************************        
      *                                                                         
        9700-PROCESS-ABEND.                                             
                                                                        
             PERFORM 9000-SEND-ERROR-RESULT      THRU 9000-EXIT.        
                                                                        
             PERFORM 9900-SQL-ERROR-ROUTINE      THRU 9900-EXIT.        
      *                                                                         
        9700-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      *  JOURNALING COPYBOOK.                                          *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 9900 - JOURNALING / ERROR HANDLING ROUTINE                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD00320                                                   
           END-EXEC.                                                            
      *                                                                         
                                                                        
