       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04678.                                         
       DATE-WRITTEN.  10/18/2013.                                       
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  TRANID:                                                       *        
      *  PROGRAM:                                                      *        
      *  CALLING SP:                                                   *        
      *  BUSINESOP : RequGetGLCodeDescBusinessOP                       *        
      *  INPUT     : I-ITEM-ID                                         *        
      *                                                                *        
      *--      OUT                                                   --         
      *--           NONE                                             --         
      *--                                                            --         
      *--      INOUT                                                 --         
      *--                                                            --         
      *--           NONE                                             --         
      *--                                                            --         
      *--  RESULT SET                                                --         
      *--      1. CSR04678_R1 - CSS_GL_CODE_DESC                     --         
      *--           RETURN_CODE             INTEGER                  --         
      *             APPL_RETURN_CODE        INTEGER                   *         
      *             FROM_USER               CHAR(07)                  *         
      *             TO_USER                 CHAR(07)                  *         
      *             RESP_AREA_ID            CHAR(03)                  *         
      *             DATE_CREATED            CHAR(26)                  *         
      *--                                                            --         
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
P00757*  10/2013   NC94746    INITIAL VERSION.                         *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION, ABEND, MESSAGING MODULES            *        
      ******************************************************************        
      *                                                                *        
      *              RETURN CODES AND MEANINGS                         *        
      *  ANY -   ERROR                                                 *        
      *   0      RECORD WAS FOUND                                      *        
      *   100    RECORD WAS NOT FOUND                                  *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04678'.
MSQ017     COPY MFASQLM.
       01  WS-START                           PIC X(40) VALUE           
           'WORKING STORAGE FOR CSR04678 STARTS HERE'.                  
                                                                        
                                                                        
       01 WORK-FIELDS.                                                  
          05 WS-ITEM-ID                  PIC 9(10).                     
          05 PREV-FROM-USER              PIC X(07).                     
          05 PREV-RESP-AREA-ID           PIC X(03).                     
          05 WS-HIST-ROW                 PIC 9(01) VALUE 0.             
             88 FIRST-ROW                          VALUE 0.             
             88 MIDDLE-ROW                         VALUE 1.             
             88 LAST-ROW                           VALUE 2.             
COB305    05 SUB1        PIC S9(3) COMP-3 VALUE 0.              
          05 WRK-DONE-STATUS             PIC S9(9) COMP.                
          05 HAS-ACCESS-FL               PIC X(01) VALUE 'N'.           
          05 SEND-DONE-SW                PIC X(01) VALUE 'Y'.           
             88 SEND-DONE-ERROR                    VALUE 'N'.           
             88 SEND-DONE-OK                       VALUE 'Y'.           
          05 PROGRAM-NAME                PIC X(08) VALUE 'CSR04678'.    
                                                                        
      *                                                                         
      ******************************************************************        
      *    RESULT SET COLUMN NAMES                                     *        
      ******************************************************************        
                                                                        
       01 GTT-RETURN-FIELDS.                                            
          05 S-RETURN-CODE               PIC S9(8)  COMP VALUE 0.       
          05 S-APPL-RETURN-CODE          PIC S9(8)  COMP VALUE 0.       
          05 S-FROM-USER                 PIC X(07)  VALUE SPACES.       
          05 S-TO-USER                   PIC X(07)  VALUE SPACES.       
          05 S-RESP-AREA-ID              PIC X(03)  VALUE SPACES.       
          05 S-DATE-CREATED              PIC X(26)  VALUE SPACES.       
                                                                        
      ******************************************************************        
      * INCLUDE SQLCA                                                           
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * INCLUDE CSS_WQ_ASSGN_HSTY          WI                                   
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBWQHTY                                                   
           END-EXEC.                                                            
                                                                        
                                                                        
      ******************************************************************        
      * INCLUDE CSS_WQ_ITEMS               WQ                                   
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBWQITS                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * SUPPORTS DB2 AND SQL ERROR CHECKING                                     
      ******************************************************************        
           COPY CWS00303.                                                       
      ******************************************************************        
      *    CURSOR DECLARATIONS                                         *        
      ******************************************************************        
                                                                        
      ******************************************************************        
      *****DUMP FROM CSS_GL_CODE_DESC                             ******        
      ******************************************************************        
                                                                        
           EXEC SQL DECLARE WQ-HIST-CUR  CURSOR FOR                     
            SELECT WI.RESP_AREA_ID                                      
                  ,WI.USER_ID                                           
                  ,REPLACE(REPLACE(CONVERT(CHAR(26), WI.REASSIGN_DATE
           , 121), ' ', '-'), ':', '.') REASSIGN_DATE                          
                FROM CSS_WQ_ASSGN_HSTY WI WITH(READUNCOMMITTED)                 
               WHERE WI.ITEM_ID      = :WQ-ITEM-ID                      
               ORDER BY REASSIGN_DATE DESC                              
                 FOR READ ONLY                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL DECLARE WQ-HIST-CUR  CURSOR FOR                             
MFA-TR*     SELECT WI.RESP_AREA_ID                                              
MFA-TR*           ,WI.USER_ID                                                   
MFA-TR*           ,WI.REASSIGN_DATE                                             
MFA-TR*         FROM CSS_WQ_ASSGN_HSTY WI                                       
MFA-TR*        WHERE WI.ITEM_ID      = :WQ-ITEM-ID                              
MFA-TR*        ORDER BY REASSIGN_DATE DESC                                      
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*          QUERYNO 7100                                                   
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE CWSSP001                                                 
           END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-ITEM-ID               PIC X(10).                        
                                                                        
                                                                        
       PROCEDURE DIVISION USING PARM-ITEM-ID.                           
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE            THRU 0100-EXIT.           
           PERFORM 1000-PROCESS               THRU 1000-EXIT.           
           PERFORM 9999-END-PROGRAM           THRU 9999-EXIT.           
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      *     1. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     2. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     3. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           IF PARM-ITEM-ID IS NUMERIC                                   
              MOVE PARM-ITEM-ID               TO WS-ITEM-ID             
              MOVE WS-ITEM-ID                 TO WQ-ITEM-ID             
           ELSE                                                         
              INITIALIZE                         GTT-RETURN-FIELDS      
              MOVE 200                        TO S-APPL-RETURN-CODE     
              PERFORM 8100-SEND-RESULT        THRU 8100-EXIT            
           END-IF.                                                      
                                                                        
           PERFORM 0100A-DECLARE-GTT           THRU  0100A-EXIT.        
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       0100A-DECLARE-GTT.                                               
      *================================================================*        
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04678_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04678_R1
              (                                                        
                   RETURN_CODE             INT                      
                  ,APPL_RETURN_CODE        INT                      
                  ,FROM_USER CHAR(07)  COLLATE LATIN1_GENERAL_100_BIN2          
                  ,TO_USER CHAR(07)  COLLATE LATIN1_GENERAL_100_BIN2            
                  ,RESP_AREA_ID CHAR(03)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                     
                  ,DATE_CREATED CHAR(26)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                     
               )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF SQLSTATE = '42710'                                        
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  CONTINUE                                              
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'              TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04678_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT       
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
                                                                        
                                                                        
           EXEC SQL                                                     
              DECLARE C1 CURSOR  WITH ROWSET                 
                           POSITIONING FOR                              
                 SELECT RETURN_CODE                                     
                       ,APPL_RETURN_CODE                                
                       ,FROM_USER                                       
                       ,TO_USER                                         
                       ,RESP_AREA_ID                                    
                       ,DATE_CREATED                                    
                   FROM #CSR04678_R1                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN WITH ROWSET                         
MFA-TR*                    POSITIONING FOR                                      
MFA-TR*          SELECT RETURN_CODE                                             
MFA-TR*                ,APPL_RETURN_CODE                                        
MFA-TR*                ,FROM_USER                                               
MFA-TR*                ,TO_USER                                                 
MFA-TR*                ,RESP_AREA_ID                                            
MFA-TR*                ,DATE_CREATED                                            
MFA-TR*            FROM SESSION.CSR04678_R1                                     
MFA-TR*    END-EXEC.                                                            
                                                                        
                                                                        
       0100A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      *================================================================*        
       1000-PROCESS.                                                    
      *================================================================*        
                                                                        
           MOVE '1000'                            TO ACTIVE-PARAGRAPH.  
                                                                        
           PERFORM 7000-SELECT-WQ-ITEMS           THRU 7000-EXIT.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              PERFORM 7100-OPEN-WQ-HIST-CUR       THRU 7100-EXIT        
              PERFORM 7120-FETCH-WQ-HIST-CUR      THRU 7120-EXIT        
              SET FIRST-ROW       TO TRUE                               
              PERFORM 2000-PROCESS-OUTPUT         THRU 2000-EXIT        
                 UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                
              IF MIDDLE-ROW                                             
                SET LAST-ROW       TO TRUE                              
                PERFORM 2000-PROCESS-OUTPUT         THRU 2000-EXIT      
              END-IF                                                    
              PERFORM 7140-CLOSE-WQ-HIST-CUR      THRU 7140-EXIT        
           ELSE                                                         
              INITIALIZE                         GTT-RETURN-FIELDS      
              MOVE 100                        TO S-APPL-RETURN-CODE     
              PERFORM 8100-SEND-RESULT        THRU 8100-EXIT            
           END-IF.                                                      
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       2000-PROCESS-OUTPUT.                                             
      *================================================================*        
                                                                        
           MOVE '2000'                            TO ACTIVE-PARAGRAPH.  
                                                                        
           EVALUATE TRUE                                                
              WHEN FIRST-ROW                                            
                 SET MIDDLE-ROW               TO TRUE                   
                 MOVE WQ-USER-ID-ASGN         TO S-TO-USER              
                 MOVE WQ-RESP-AREA-ID         TO S-RESP-AREA-ID         
                 MOVE WI-USER-ID              TO S-FROM-USER            
                                                 PREV-FROM-USER         
                 MOVE WI-REASSIGN-DATE        TO S-DATE-CREATED         
                 MOVE WI-RESP-AREA-ID         TO PREV-RESP-AREA-ID      
                 PERFORM 8100-SEND-RESULT       THRU 8100-EXIT          
                 PERFORM 7120-FETCH-WQ-HIST-CUR THRU 7120-EXIT          
              WHEN MIDDLE-ROW                                           
                 MOVE PREV-FROM-USER          TO S-TO-USER              
                 MOVE PREV-RESP-AREA-ID       TO S-RESP-AREA-ID         
                 MOVE WI-USER-ID              TO S-FROM-USER            
                                                 PREV-FROM-USER         
                 MOVE WI-REASSIGN-DATE        TO S-DATE-CREATED         
                 MOVE WI-RESP-AREA-ID         TO PREV-RESP-AREA-ID      
                 PERFORM 8100-SEND-RESULT       THRU 8100-EXIT          
                 PERFORM 7120-FETCH-WQ-HIST-CUR THRU 7120-EXIT          
              WHEN LAST-ROW                                             
                 MOVE PREV-FROM-USER          TO S-TO-USER              
                 MOVE PREV-RESP-AREA-ID       TO S-RESP-AREA-ID         
                 MOVE WQ-USER-ID-ORIG         TO S-FROM-USER            
                 MOVE WQ-DATE-CREATED         TO S-DATE-CREATED         
                 PERFORM 8100-SEND-RESULT       THRU 8100-EXIT          
           END-EVALUATE                                                 
                                                                        
           INITIALIZE                            GTT-RETURN-FIELDS.     
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7000-SELECT-WQ-ITEMS.                                            
      *================================================================*        
                                                                        
           EXEC SQL                                                     
              SELECT REPLACE(REPLACE(CONVERT(CHAR(26), WQ.DATE_CREATED
           , 121), ' ', '-'), ':', '.') DATE_CREATED                           
                    ,WQ.USER_ID_ORIG                                    
                    ,WQ.USER_ID_ASGN                                    
                    ,WQ.RESP_AREA_ID                                    
                INTO :WQ-DATE-CREATED                                   
                    ,:WQ-USER-ID-ORIG                                   
                    ,:WQ-USER-ID-ASGN                                   
                    ,:WQ-RESP-AREA-ID                                   
                FROM CSS_WQ_ITEMS WQ WITH(READUNCOMMITTED)                      
               WHERE WQ.ITEM_ID = :WQ-ITEM-ID                           
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT WQ.DATE_CREATED                                            
MFA-TR*             ,WQ.USER_ID_ORIG                                            
MFA-TR*             ,WQ.USER_ID_ASGN                                            
MFA-TR*             ,WQ.RESP_AREA_ID                                            
MFA-TR*         INTO :WQ-DATE-CREATED                                   00088700
MFA-TR*             ,:WQ-USER-ID-ORIG                                   00088800
MFA-TR*             ,:WQ-USER-ID-ASGN                                   00088800
MFA-TR*             ,:WQ-RESP-AREA-ID                                   00088800
MFA-TR*         FROM CSS_WQ_ITEMS WQ                                            
MFA-TR*        WHERE WQ.ITEM_ID = :WQ-ITEM-ID                                   
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7000'              TO ACTIVE-PARAGRAPH              
              MOVE 'OPEN'              TO ABEND-FUNCTION                
              MOVE 'CSS_WQ_ITEMS'      TO TABLE-1                       
              MOVE 'ITEM_ID'           TO TABLE-ELEMENT-1               
              MOVE WQ-ITEM-ID          TO HOSTVAR-ELEMENT-1             
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7100-OPEN-WQ-HIST-CUR.                                           
      *================================================================*        
                                                                        
           EXEC SQL                                                     
              OPEN WQ-HIST-CUR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7100'              TO ACTIVE-PARAGRAPH              
              MOVE 'OPEN'              TO ABEND-FUNCTION                
              MOVE 'CSS_WQ_ASSGN_HSTY' TO TABLE-1                       
              MOVE 'ITEM_ID'           TO TABLE-ELEMENT-1               
              MOVE WQ-ITEM-ID          TO HOSTVAR-ELEMENT-1             
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7120-FETCH-WQ-HIST-CUR.                                          
      *================================================================*        
                                                                        
                                                                        
           EXEC SQL                                                     
              FETCH WQ-HIST-CUR                                         
                INTO :WI-RESP-AREA-ID                                   
                    ,:WI-USER-ID                                        
                    ,:WI-REASSIGN-DATE                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    CONTINUE                                            
               WHEN OTHER                                               
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE '7120'               TO ACTIVE-PARAGRAPH         
                  MOVE 'FETCH'              TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSS_WQ_ASSGN_HSTY'  TO TABLE-1                  
                  MOVE 'ITEM_ID'            TO TABLE-ELEMENT-1          
                  MOVE WQ-ITEM-ID           TO HOSTVAR-ELEMENT-1        
                  PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *================================================================*        
       7140-CLOSE-WQ-HIST-CUR.                                          
      *================================================================*        
                                                                        
           EXEC SQL                                                     
              CLOSE WQ-HIST-CUR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7140'              TO ACTIVE-PARAGRAPH              
              MOVE 'CLOSE'             TO ABEND-FUNCTION                
              MOVE 'CSS_WQ_ASSGN_HSTY' TO TABLE-1                       
              MOVE 'ITEM_ID'           TO TABLE-ELEMENT-1               
              MOVE WQ-ITEM-ID          TO HOSTVAR-ELEMENT-1             
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7140-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       8000A-DELETE-GTT-ROWS.                                           
      *================================================================*        
                                                                        
           MOVE                                                         
           'DELETE ROWS'                                                
               TO S-SQL-STATEMENT-V.                                    
                                                                        
            EXEC SQL                                                    
                DELETE FROM #CSR04678_R1                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR04678_R1                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
                CONTINUE                                                
            ELSE                                                        
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8000A'              TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04678_R1'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
                                                                        
      *================================================================*        
       8100-SEND-RESULT.                                                
      *================================================================*        
                                                                        
           EXEC SQL                                                     
                  INSERT INTO #CSR04678_R1                       
                  (  RETURN_CODE                                        
                    ,APPL_RETURN_CODE                                   
                    ,FROM_USER                                          
                    ,TO_USER                                            
                    ,RESP_AREA_ID                                       
                    ,DATE_CREATED                                       
                  )                                                     
               VALUES                                                   
               (                                                        
                    :S-RETURN-CODE                                      
                   ,:S-APPL-RETURN-CODE                                 
                   ,:S-FROM-USER                                        
                   ,:S-TO-USER                                          
                   ,:S-RESP-AREA-ID                                     
                   ,:S-DATE-CREATED                                     
               )                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*           INSERT INTO SESSION.CSR04678_R1                               
MFA-TR*           (  RETURN_CODE                                                
MFA-TR*             ,APPL_RETURN_CODE                                           
MFA-TR*             ,FROM_USER                                                  
MFA-TR*             ,TO_USER                                                    
MFA-TR*             ,RESP_AREA_ID                                               
MFA-TR*             ,DATE_CREATED                                               
MFA-TR*           )                                                             
MFA-TR*        VALUES                                                           
MFA-TR*        (                                                                
MFA-TR*             :S-RETURN-CODE                                              
MFA-TR*            ,:S-APPL-RETURN-CODE                                         
MFA-TR*            ,:S-FROM-USER                                                
MFA-TR*            ,:S-TO-USER                                                  
MFA-TR*            ,:S-RESP-AREA-ID                                             
MFA-TR*            ,:S-DATE-CREATED                                             
MFA-TR*        )                                                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD 1 TO CTR-ROWS                                         
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8100'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04678_R1'        TO TABLE-1                      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***********************************************************               
      * JOURNALING / ERROR HANDLING ROUTINE                     *               
      * 9900-SQL-ERROR-ROUTINE                                  *               
      * 9975-ABEND-CONTROL-TRANSFER                             *               
      ***********************************************************               
                                                                        
           EXEC SQL                                                             
               INCLUDE CPDSP300                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * END PROGRAM COPYLIB                                            *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CPD00320                                                 
           END-EXEC.                                                            
                                                                        
