       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       CSR04677.                                      
       AUTHOR.       SHABNAM SHAIK.                                     
COB303 DATE-WRITTEN. 10 OCTOBER 2013.                                   
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROCEDURE CAN PERFORM UPDATE AND INSERT TO WQ TABLES     *        
      *                                                                *        
      *  NOTE : IN THE INPUT ITEM ID CAN COME MAX 999 TIMES            *        
      *  CLONED FROM CSR00002.                                         *        
      ******************************************************************        
      *                                                                *        
      *  BUSINESOP : RequUpdMassReassignWQsBusinessOp                  *        
      *                                                                *        
      *  INPUT PARAMETERS:                                             *        
      *                                                                *        
      *          I_ITEM_ID                CHAR(9990)                   *        
      *          I_RESP_AREA_ID           CHAR(03)                     *        
      *          I_USER_ID_ASGN           CHAR(07)                     *        
      *          I_COMPANY_NO             CHAR(02)                     *        
      *          I_ASGHST_RESP_AREA       CHAR(03)                     *        
      *          I_ASGHST_USER_ID         CHAR(07)                     *        
      *                                                                *        
      *                                                                *        
      *  RESUT SET 1:                                                  *        
      *                                                                *        
      *          RETURN_CODE              INTEGER                      *        
      *          APPL_RETURN_CODE         INTEGER                      *        
      *                                                                *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE        INITIALS     COMMENTS                           *        
      *  --------      --------     --------------------------------   *        
      *  10-21-2013    SS7F226      NEW CODE                           *        
A04880*  10-21-2014    NC94746      SET ASSIGNED STATUS FOR TASKS THAT *        
A04880*                             ARE IN-PROGRESS WHEN RE-ASSIGNING. *        
ACT166*  09-01-2015    MC95456      ADDITIONAL FIELD CURRENT_USER_ID   *        
ACT166*  APPL5136-ACT166            ADDED TO INPUT.                    *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04677'.
MSQ017     COPY MFASQLM.
                                                                        
       01 WS-START                                   PIC X(40) VALUE    
          'WORKING STORAGE FOR CSR04677 STARTS HERE'.                   
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
       01 WS-GENERAL-VARIABLE.                                          
          05 WS-SQLSTATE               PIC X(05)  VALUE SPACES.         
          05 WS-ITEM-ID-RED            PIC X(10).                       
          05 WS-ITEM-ID-NUM REDEFINES WS-ITEM-ID-RED                    
                                       PIC 9(10).                       
          05 WS-CURRENT-USER           PIC X(08).                       
          05 WS-RESP-AREA-ID           PIC X(03) VALUE SPACES.          
          05 WS-USER-ID-ASGN           PIC X(07) VALUE SPACES.          
          05 WS-STATUS                 PIC X(01) VALUE SPACES.          
                                                                        
       01 COUNTER-FIELDS.                                               
          05 CTR-COLUMN                PIC S9(09) COMP VALUE 1.         
          05 CTR-ROWS                  PIC S9(09) COMP VALUE 0.         
                                                                        
       01 GTT-MISC-FIELDS.                                              
          05 GTT-ROW.                                                   
             49 GTT-ROW-LEN            PIC S9(04) COMP.                 
             49 GTT-ROW-CHAR           PIC X(1024).                     
          05 GTT-SQLCODE               PIC S9(09) COMP.                 
                                                                        
       01 WS-LITERALS.                                                  
          05 PROGRAM-NAME              PIC X(08)  VALUE 'CSR04677'.     
          05 WS-ZERO                   PIC S9(04) VALUE 0.              
          05 WS-DELETE                 PIC X(01)  VALUE 'D'.            
          05 WS-MAX-ROW                PIC S9(04) VALUE 999.            
          05 WS-GTT-NAME               PIC X(19)  VALUE SPACES.         
                                                                        
       01 WS-SWITCHES.                                                  
          05 SEND-DONE-SW              PIC X(01)  VALUE 'Y'.            
             88 SEND-DONE-ERROR                   VALUE 'N'.            
                                                                        
       01 WS-ITEM-DATA-INFO.                                            
          05 WS-ITEM-DATA-LEN          PIC S9(4) COMP.                  
          05 WS-ITEM-DATA-TEXT         PIC X(9990).                     
                                                                        
       01 WS-ITEM-ID-TEMP-TB.                                           
          05 WS-ITEM-ID-DATA.                                           
             10 WS-ITEM-ID             PIC X(10) OCCURS 999 TIMES       
                                       INDEXED BY WS-ITEM-INDX.         
                                                                        
       01 GTT-RETURN-FIELDS.                                            
          05 S-RETURN-CODE             PIC S9(09) COMP VALUE 0.         
          05 S-APPL-RETURN-CODE        PIC S9(09) COMP VALUE 0.         
                                                                        
       01 CSRERLOG-P.                                                   
           10 S-SP-NAME                PIC X(18) VALUE SPACES.          
           10 S-SQLCODE                PIC S9(9) COMP VALUE 0.          
           10 S-SQLSTATE               PIC X(5)  VALUE ' '.             
           10 S-TABLE-NAME             PIC X(18) VALUE SPACES.          
           10 S-HOST-VARIABLES.                                         
              49 S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.            
              49 S-HOST-VARIABLES-V    PIC X(255).                      
           10 S-SQL-STATEMENT.                                          
              49 S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.            
              49 S-SQL-STATEMENT-V     PIC X(255).                      
           10 S-SQL-DESCRIPTION.                                        
              49 S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.            
              49 S-SQL-DESCRIPTION-V   PIC X(255).                      
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CSS_RESP_AREA      C1                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRSAREA                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CSS_USER_PROFILE   PF                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CSS_WQ_ASSGN_HSTY  WI                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBWQHTY                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CSS_WQ_ITEMS       WQ                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBWQITS                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    ERROR HANDLING COPY BOOK.                                   *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01 PARM-ITEM-ID                 PIC X(9990).                     
       01 PARM-RESP-AREA-ID            PIC X(03).                       
       01 PARM-USER-ID-ASGN            PIC X(07).                       
       01 PARM-COMPANY-NO              PIC X(02).                       
       01 PARM-ASGHST-RESP-AREA        PIC X(03).                       
       01 PARM-ASGHST-USER-ID          PIC X(07).                       
ACT166 01 PARM-CURRNT-USER-ID          PIC X(07).                       
                                                                        
       PROCEDURE DIVISION USING PARM-ITEM-ID                            
                                PARM-RESP-AREA-ID                       
                                PARM-USER-ID-ASGN                       
                                PARM-COMPANY-NO                         
                                PARM-ASGHST-RESP-AREA                   
                                PARM-ASGHST-USER-ID                     
ACT166                          PARM-CURRNT-USER-ID.                    
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0000-MAINLINE.                                                 *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE          THRU 0100-EXIT.             
           PERFORM 1000-PROCESS-INPUT       THRU 1000-EXIT.             
           PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT.             
           PERFORM 9999-END-PROGRAM         THRU 9999-EXIT.             
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100-INITIALIZE.                                               *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           EXEC SQL                                                     
              DECLARE C1 CURSOR  FOR                         
              SELECT :S-RETURN-CODE           AS RETURN_CODE            
                    ,:S-APPL-RETURN-CODE      AS APPL_RETURN_CODE       
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN FOR                                 
MFA-TR*       SELECT :S-RETURN-CODE           AS RETURN_CODE                    
MFA-TR*             ,:S-APPL-RETURN-CODE      AS APPL_RETURN_CODE               
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 1000-PROCESS-INPUT.                                            *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-ITEM-ID                TO WS-ITEM-DATA-INFO.       
           MOVE WS-ITEM-DATA-TEXT           TO WS-ITEM-ID-DATA.         
           MOVE PARM-RESP-AREA-ID           TO C1-RESP-AREA-ID          
                                               WQ-RESP-AREA-ID.         
           MOVE PARM-USER-ID-ASGN           TO WQ-USER-ID-ASGN.         
           MOVE PARM-COMPANY-NO             TO C1-COMPANY-NO.           
           MOVE PARM-ASGHST-RESP-AREA       TO WI-RESP-AREA-ID.         
           MOVE PARM-ASGHST-USER-ID         TO WI-USER-ID.              
ACT166     MOVE PARM-CURRNT-USER-ID         TO WS-CURRENT-USER.         
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           IF WQ-USER-ID-ASGN = SPACES                                  
              PERFORM 7100-GET-USER-ID-ASGN    THRU 7100-EXIT           
              MOVE C1-USER-ID                       TO WQ-USER-ID-ASGN  
           END-IF                                                       
           PERFORM 2100-PROCESS-FOR-UPDT       THRU 2100-EXIT.          
           PERFORM 8100-SEND-RESULT            THRU 8100-EXIT.          
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2100-PROCESS-FOR-UPDT.                                         *        
      ******************************************************************        
       2100-PROCESS-FOR-UPDT.                                           
                                                                        
           PERFORM VARYING WS-ITEM-INDX FROM 1 BY 1                     
                           UNTIL WS-ITEM-INDX > WS-MAX-ROW              
                  OR WS-ITEM-ID(WS-ITEM-INDX) < WS-ZERO                 
                                                                        
              MOVE WS-ITEM-ID(WS-ITEM-INDX)      TO WS-ITEM-ID-RED      
              MOVE WS-ITEM-ID-NUM                TO WQ-ITEM-ID          
                                                                        
A04880        PERFORM 2500-SELECT-WQ-ITEMS          THRU 2500-EXIT      
A04880        IF WS-STATUS = 'I'                                        
A04880           MOVE 'A'                     TO WS-STATUS              
A04880        END-IF                                                    
A04880        IF WS-STATUS = 'A' AND                                    
A04880           (WS-RESP-AREA-ID NOT = WQ-RESP-AREA-ID                 
A04880           OR WS-USER-ID-ASGN NOT = WQ-USER-ID-ASGN )             
A04880           PERFORM 2600-PROCESS-UPDATES THRU 2600-EXIT            
A04880        END-IF                                                    
                                                                        
           END-PERFORM.                                                 
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                *        
A04880*================================================================*        
A04880 2500-SELECT-WQ-ITEMS.                                            
A04880*================================================================*        
A04880                                                                  
A04880     EXEC SQL                                                     
A04880        SELECT RESP_AREA_ID                                       
A04880              ,USER_ID_ASGN                                       
A04880              ,STATUS                                             
A04880          INTO :WS-RESP-AREA-ID                                   
A04880              ,:WS-USER-ID-ASGN                                   
A04880              ,:WS-STATUS                                         
A04880          FROM CSS_WQ_ITEMS WITH(READUNCOMMITTED)                         
A04880         WHERE ITEM_ID                 = :WQ-ITEM-ID              
A04880                                                           
A04880                                                      
A04880     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RESP_AREA_ID                                               
MFA-TR*             ,USER_ID_ASGN                                               
MFA-TR*             ,STATUS                                                     
MFA-TR*         INTO :WS-RESP-AREA-ID                                           
MFA-TR*             ,:WS-USER-ID-ASGN                                           
MFA-TR*             ,:WS-STATUS                                                 
MFA-TR*         FROM CSS_WQ_ITEMS                                               
MFA-TR*        WHERE ITEM_ID                 = :WQ-ITEM-ID                      
MFA-TR*        WITH UR                                                          
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04880                                                                  
A04880     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
A04880                                                                  
A04880     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A04880        CONTINUE                                                  
A04880     ELSE                                                         
A04880        MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
A04880        MOVE '2500'                   TO ACTIVE-PARAGRAPH         
A04880        MOVE 'SELECT'                 TO ABEND-FUNCTION           
A04880        MOVE SPACES                   TO ABEND-SQL-PREDICATES     
A04880                                         ABEND-TABLES             
A04880        MOVE 'CSS_WQ_ITEMS'           TO TABLE-1                  
A04880        MOVE 'ITEM_ID'                TO TABLE-ELEMENT-1          
A04880        MOVE WQ-ITEM-ID               TO HOSTVAR-ELEMENT-1        
A04880        PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
A04880     END-IF.                                                      
A04880                                                                  
A04880 2500-EXIT.                                                       
A04880     EXIT.                                                        
A04880                                                                  
A04880*================================================================*        
A04880 2600-PROCESS-UPDATES.                                            
A04880*================================================================*        
A04880                                                                  
A04880     PERFORM 8000-UPDATE-WQ-ITEMS    THRU 8000-EXIT.              
A04880     MOVE C1-COMPANY-NO              TO WI-COMPANY-NO             
A04880     MOVE WQ-ITEM-ID                 TO WI-ITEM-ID                
A04880     PERFORM 8200-INSERT-HSTY-FOR-ASGHST THRU 8200-EXIT           
A04880     PERFORM 7200-GET-RESP-AREA-ID   THRU 7200-EXIT               
A04880                                                                  
A04880     IF WI-USER-ID      NOT EQUAL TO WS-CURRENT-USER AND          
A04880        WQ-USER-ID-ASGN NOT EQUAL TO WS-CURRENT-USER              
A04880        PERFORM 8600-INSERT-HSTY-FOR-ASGNBY THRU 8600-EXIT        
A04880     END-IF.                                                      
A04880                                                                  
A04880 2600-EXIT.                                                       
A04880     EXIT.                                                        
      ******************************************************************        
      *                                                                *        
      * 7100-GET-USER-ID-ASGN.                                         *        
      ******************************************************************        
       7100-GET-USER-ID-ASGN.                                           
                                                                        
           EXEC SQL                                                     
              SELECT C1.USER_ID                                         
                INTO :C1-USER-ID                                        
                FROM CSS_RESP_AREA C1 WITH(READUNCOMMITTED)                     
               WHERE C1.RESP_AREA_ID = :C1-RESP-AREA-ID                 
                 AND C1.COMPANY_NO   = :C1-COMPANY-NO                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT C1.USER_ID                                                 
MFA-TR*         INTO :C1-USER-ID                                                
MFA-TR*         FROM CSS_RESP_AREA C1                                           
MFA-TR*        WHERE C1.RESP_AREA_ID = :C1-RESP-AREA-ID                         
MFA-TR*          AND C1.COMPANY_NO   = :C1-COMPANY-NO                           
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7100'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_RESP_AREA'          TO TABLE-1                  
              MOVE 'RESP_AREA_ID'           TO TABLE-ELEMENT-1          
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-2          
              MOVE C1-RESP-AREA-ID          TO HOSTVAR-ELEMENT-1        
              MOVE C1-COMPANY-NO            TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7200-GET-RESP-AREA-ID.                                         *        
      ******************************************************************        
       7200-GET-RESP-AREA-ID.                                           
                                                                        
           EXEC SQL                                                     
              SELECT PF.RESP_AREA_ID                                    
                INTO :PF-RESP-AREA-ID                                   
                FROM CSS_USER_PROFILE PF WITH(READUNCOMMITTED)                  
               WHERE PF.USER_ID = :WS-CURRENT-USER                      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT PF.RESP_AREA_ID                                            
MFA-TR*         INTO :PF-RESP-AREA-ID                                           
MFA-TR*         FROM CSS_USER_PROFILE PF                                        
MFA-TR*        WHERE PF.USER_ID = :WS-CURRENT-USER                              
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7200                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE PF-RESP-AREA-ID          TO WI-RESP-AREA-ID          
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7200'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_USER_PROFILE'       TO TABLE-1                  
              MOVE 'USER_ID'                TO TABLE-ELEMENT-1          
              MOVE WS-CURRENT-USER          TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8000-UPDATE-WQ-ITEMS.                                          *        
      ******************************************************************        
       8000-UPDATE-WQ-ITEMS.                                            
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_WQ_ITEMS                                       
                 SET RESP_AREA_ID            = :WQ-RESP-AREA-ID         
                    ,USER_ID_ASGN            = :WQ-USER-ID-ASGN         
A04880              ,STATUS                  = :WS-STATUS               
                    ,ASSGN_HIST_PRES_FL      = 'Y'                      
               WHERE ITEM_ID                 = :WQ-ITEM-ID              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8000'                   TO ACTIVE-PARAGRAPH         
              MOVE 'UPDATE'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_WQ_ITEMS'           TO TABLE-1                  
              MOVE 'ITEM_ID'                TO TABLE-ELEMENT-1          
              MOVE WQ-ITEM-ID               TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *                                                                *        
      * 8200-INSERT-HSTY-FOR-ASGHST.                                   *        
      ******************************************************************        
       8200-INSERT-HSTY-FOR-ASGHST.                                     
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_WQ_ASSGN_HSTY                             
                   (                                                    
                    COMPANY_NO                                          
                   ,ITEM_ID                                             
                   ,RESP_AREA_ID                                        
                   ,REASSIGN_DATE                                       
                   ,USER_ID                                             
                   )                                                    
                VALUES                                                  
                   (                                                    
                    :WI-COMPANY-NO                                      
                   ,:WI-ITEM-ID                                         
                   ,:WI-RESP-AREA-ID                                    
                   ,CIS.CURRENT$TIMESTAMP()                                   
                   ,:WI-USER-ID                                         
                   )                                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_WQ_ASSGN_HSTY                                     
MFA-TR*            (                                                            
MFA-TR*             COMPANY_NO                                                  
MFA-TR*            ,ITEM_ID                                                     
MFA-TR*            ,RESP_AREA_ID                                                
MFA-TR*            ,REASSIGN_DATE                                               
MFA-TR*            ,USER_ID                                                     
MFA-TR*            )                                                            
MFA-TR*         VALUES                                                          
MFA-TR*            (                                                            
MFA-TR*             :WI-COMPANY-NO                                              
MFA-TR*            ,:WI-ITEM-ID                                                 
MFA-TR*            ,:WI-RESP-AREA-ID                                            
MFA-TR*            ,CURRENT TIMESTAMP                                           
MFA-TR*            ,:WI-USER-ID                                                 
MFA-TR*            )                                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8200'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_WQ_ASSGN_HSTY'      TO TABLE-1                  
              MOVE 'ITEM_NO'                TO TABLE-ELEMENT-1          
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-2          
              MOVE WQ-ITEM-ID               TO HOSTVAR-ELEMENT-1        
              MOVE WQ-COMPANY-NO            TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *                                                                *        
      * 8600-INSERT-HSTY-FOR-ASGNBY.                                   *        
      ******************************************************************        
       8600-INSERT-HSTY-FOR-ASGNBY.                                     
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_WQ_ASSGN_HSTY                             
                   (                                                    
                    COMPANY_NO                                          
                   ,ITEM_ID                                             
                   ,RESP_AREA_ID                                        
                   ,REASSIGN_DATE                                       
                   ,USER_ID                                             
                   )                                                    
                VALUES                                                  
                   (                                                    
                    :WI-COMPANY-NO                                      
                   ,:WI-ITEM-ID                                         
                   ,:WI-RESP-AREA-ID                                    
                   ,CIS.CURRENT$TIMESTAMP()                                   
                   ,:WS-CURRENT-USER                                    
                   )                                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_WQ_ASSGN_HSTY                                     
MFA-TR*            (                                                            
MFA-TR*             COMPANY_NO                                                  
MFA-TR*            ,ITEM_ID                                                     
MFA-TR*            ,RESP_AREA_ID                                                
MFA-TR*            ,REASSIGN_DATE                                               
MFA-TR*            ,USER_ID                                                     
MFA-TR*            )                                                            
MFA-TR*         VALUES                                                          
MFA-TR*            (                                                            
MFA-TR*             :WI-COMPANY-NO                                              
MFA-TR*            ,:WI-ITEM-ID                                                 
MFA-TR*            ,:WI-RESP-AREA-ID                                            
MFA-TR*            ,CURRENT TIMESTAMP                                           
MFA-TR*            ,:WS-CURRENT-USER                                            
MFA-TR*            )                                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8600'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_WQ_ASSGN_HSTY'      TO TABLE-1                  
              MOVE 'ITEM_NO'                TO TABLE-ELEMENT-1          
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-2          
              MOVE WQ-ITEM-ID               TO HOSTVAR-ELEMENT-1        
              MOVE WQ-COMPANY-NO            TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8600-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8100-SEND-RESULT.                                              *        
      ******************************************************************        
       8100-SEND-RESULT.                                                
                                                                        
           ADD +1                           TO CTR-ROWS.                
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 9700-ABEND-PROCESSING.                                         *        
      ******************************************************************        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT.             
           PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT.             
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *                                                                *        
      * END PROGRAM COPYLIB.                                           *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00321                                                  
           END-EXEC.                                                            
                                                                        
