       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       CSR04676.                                      
       AUTHOR.       SHABNAM SHAIK.                                     
COB303 DATE-WRITTEN. 10 OCTOBER 2013.                                   
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROCEDURE CAN PERFORM UPDATE AND INSERT TO WQ TABLES     *        
      *                                                                *        
      *  NOTE : IN THE INPUT ITEM ID CAN COME MAX 999 TIMES            *        
      *  CLONED FROM CSR03422.                                         *        
      ******************************************************************        
      *                                                                *        
      *  BUSINESOP : RequUpdMassWorkQueueStatusBusinessOp              *        
      *                                                                *        
      *  INPUT PARAMETERS:                                             *        
      *                                                                *        
      *          I_NEW_USER_ID           CHAR(7)                       *        
      *          I_ITEM_ID               VARCHAR(9990)                 *        
      *                                                                *        
      *  RESUT SET 1:                                                  *        
      *                                                                *        
      *          RETURN_CODE             INTEGER                       *        
      *          APPL_RETURN_CODE        INTEGER                       *        
      *                                                                *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE        INITIALS     COMMENTS                           *        
      *  --------      --------     --------------------------------   *        
      *  10-04-2013    SS7F226      NEW CODE                           *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04676'.
MSQ017     COPY MFASQLM.
                                                                        
       01 WS-START                                   PIC X(40) VALUE    
          'WORKING STORAGE FOR CSR04676 STARTS HERE'.                   
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
       01 WS-GENERAL-VARIABLE.                                          
          05 WS-SQLSTATE               PIC X(05)  VALUE SPACES.         
          05 WS-ITEM-ID-RED            PIC X(10).                       
          05 WS-ITEM-ID-NUM REDEFINES WS-ITEM-ID-RED                    
                                       PIC 9(10).                       
                                                                        
       01 COUNTER-FIELDS.                                               
          05 CTR-COLUMN                PIC S9(09) COMP VALUE 1.         
          05 CTR-ROWS                  PIC S9(09) COMP VALUE 0.         
                                                                        
       01 GTT-MISC-FIELDS.                                              
          05 GTT-ROW.                                                   
             49 GTT-ROW-LEN            PIC S9(04) COMP.                 
             49 GTT-ROW-CHAR           PIC X(1024).                     
          05 GTT-SQLCODE               PIC S9(09) COMP.                 
                                                                        
       01 WS-LITERALS.                                                  
          05 PROGRAM-NAME              PIC X(08)  VALUE 'CSR04676'.     
          05 WS-ZERO                   PIC S9(04) VALUE 0.              
          05 WS-DELETE                 PIC X(01)  VALUE 'D'.            
          05 WS-MAX-ROW                PIC S9(04) VALUE 999.            
          05 WS-GTT-NAME               PIC X(19)  VALUE SPACES.         
                                                                        
       01 WS-SWITCHES.                                                  
          05 SEND-DONE-SW              PIC X(01)  VALUE 'Y'.            
             88 SEND-DONE-ERROR                   VALUE 'N'.            
                                                                        
       01 WS-ITEM-DATA-INFO.                                            
          05 WS-ITEM-DATA-LEN          PIC S9(4) COMP.                  
          05 WS-ITEM-DATA-TEXT         PIC X(9990).                     
                                                                        
       01 WS-ITEM-ID-TEMP-TB.                                           
          05 WS-ITEM-ID-DATA.                                           
             10 WS-ITEM-ID             PIC X(10) OCCURS 999 TIMES       
                                       INDEXED BY WS-ITEM-INDX.         
                                                                        
       01 GTT-RETURN-FIELDS.                                            
          05 S-RETURN-CODE             PIC S9(09) COMP VALUE 0.         
          05 S-APPL-RETURN-CODE        PIC S9(09) COMP VALUE 0.         
                                                                        
       01 CSRERLOG-P.                                                   
           10 S-SP-NAME                PIC X(18) VALUE SPACES.          
           10 S-SQLCODE                PIC S9(9) COMP VALUE 0.          
           10 S-SQLSTATE               PIC X(5)  VALUE ' '.             
           10 S-TABLE-NAME             PIC X(18) VALUE SPACES.          
           10 S-HOST-VARIABLES.                                         
              49 S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.            
              49 S-HOST-VARIABLES-V    PIC X(255).                      
           10 S-SQL-STATEMENT.                                          
              49 S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.            
              49 S-SQL-STATEMENT-V     PIC X(255).                      
           10 S-SQL-DESCRIPTION.                                        
              49 S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.            
              49 S-SQL-DESCRIPTION-V   PIC X(255).                      
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CSS_USER_PROFILE   PF                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CSS_WQ_ASSGN_HSTY  WI                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBWQHTY                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CSS_WQ_ITEMS       WQ                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBWQITS                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    ERROR HANDLING COPY BOOK.                                   *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01 PARM-NEW-USER-ID             PIC X(07).                       
       01 PARM-ITEM-ID                 PIC X(9990).                     
                                                                        
       PROCEDURE DIVISION USING PARM-NEW-USER-ID                        
                                PARM-ITEM-ID.                           
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0000-MAINLINE.                                                 *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE          THRU 0100-EXIT.             
           PERFORM 1000-PROCESS-INPUT       THRU 1000-EXIT.             
           PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT.             
           PERFORM 9999-END-PROGRAM         THRU 9999-EXIT.             
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100-INITIALIZE.                                               *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           EXEC SQL                                                     
              DECLARE C1 CURSOR  FOR                         
              SELECT :S-RETURN-CODE           AS RETURN_CODE            
                    ,:S-APPL-RETURN-CODE      AS APPL_RETURN_CODE       
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN FOR                                 
MFA-TR*       SELECT :S-RETURN-CODE           AS RETURN_CODE                    
MFA-TR*             ,:S-APPL-RETURN-CODE      AS APPL_RETURN_CODE               
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 1000-PROCESS-INPUT.                                            *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-NEW-USER-ID            TO PF-USER-ID.              
           MOVE PARM-ITEM-ID                TO WS-ITEM-DATA-INFO.       
           MOVE WS-ITEM-DATA-TEXT           TO WS-ITEM-ID-DATA.         
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 7000-GET-RESP-AREA-ID       THRU 7000-EXIT.          
           PERFORM 2100-PROCESS-FOR-UPDT       THRU 2100-EXIT.          
           PERFORM 8100-SEND-RESULT            THRU 8100-EXIT.          
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2100-PROCESS-FOR-UPDT.                                         *        
      ******************************************************************        
       2100-PROCESS-FOR-UPDT.                                           
                                                                        
           PERFORM VARYING WS-ITEM-INDX FROM 1 BY 1                     
                           UNTIL WS-ITEM-INDX > WS-MAX-ROW              
                  OR WS-ITEM-ID(WS-ITEM-INDX) < WS-ZERO                 
                                                                        
              MOVE WS-ITEM-ID(WS-ITEM-INDX) TO WS-ITEM-ID-RED           
              MOVE WS-ITEM-ID-NUM           TO WQ-ITEM-ID               
                                                                        
              PERFORM 7200-GET-WQ-ITEM-DET     THRU 7200-EXIT           
              PERFORM 8000-INSERT-WQ-HSTY      THRU 8000-EXIT           
              PERFORM 8050-UPDATE-WQ-ITEMS     THRU 8050-EXIT           
                                                                        
           END-PERFORM.                                                 
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7000-GET-RESP-AREA-ID.                                         *        
      ******************************************************************        
       7000-GET-RESP-AREA-ID.                                           
                                                                        
           EXEC SQL                                                     
              SELECT PF.RESP_AREA_ID                                    
                INTO :PF-RESP-AREA-ID                                   
                FROM CSS_USER_PROFILE PF WITH(READUNCOMMITTED)                  
               WHERE PF.USER_ID = :PF-USER-ID                           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT PF.RESP_AREA_ID                                            
MFA-TR*         INTO :PF-RESP-AREA-ID                                           
MFA-TR*         FROM CSS_USER_PROFILE PF                                        
MFA-TR*        WHERE PF.USER_ID = :PF-USER-ID                                   
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7000                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7000'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_USER_PROFILE'       TO TABLE-1                  
              MOVE 'USER_ID'                TO TABLE-ELEMENT-1          
              MOVE PF-USER-ID               TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7200-GET-WQ-ITEM-DET.                                          *        
      ******************************************************************        
       7200-GET-WQ-ITEM-DET.                                            
                                                                        
           EXEC SQL                                                     
              SELECT WQ.RESP_AREA_ID                                    
                    ,WQ.USER_ID_ASGN                                    
                    ,WQ.COMPANY_NO                                      
                INTO :WQ-RESP-AREA-ID                                   
                    ,:WQ-USER-ID-ASGN                                   
                    ,:WQ-COMPANY-NO                                     
                FROM CSS_WQ_ITEMS WQ WITH(READUNCOMMITTED)                      
               WHERE WQ.ITEM_ID      = :WQ-ITEM-ID                      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT WQ.RESP_AREA_ID                                            
MFA-TR*             ,WQ.USER_ID_ASGN                                            
MFA-TR*             ,WQ.COMPANY_NO                                              
MFA-TR*         INTO :WQ-RESP-AREA-ID                                           
MFA-TR*             ,:WQ-USER-ID-ASGN                                           
MFA-TR*             ,:WQ-COMPANY-NO                                             
MFA-TR*         FROM CSS_WQ_ITEMS WQ                                            
MFA-TR*        WHERE WQ.ITEM_ID      = :WQ-ITEM-ID                              
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7200                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7200'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_WQ_ITEMS'           TO TABLE-1                  
              MOVE 'ITEM_ID'                TO TABLE-ELEMENT-1          
              MOVE WQ-ITEM-ID               TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8000-INSERT-WQ-HSTY.                                           *        
      ******************************************************************        
       8000-INSERT-WQ-HSTY.                                             
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_WQ_ASSGN_HSTY                             
                   (                                                    
                    COMPANY_NO                                          
                   ,ITEM_ID                                             
                   ,RESP_AREA_ID                                        
                   ,REASSIGN_DATE                                       
                   ,USER_ID                                             
                   )                                                    
                VALUES                                                  
                   (                                                    
                    :WQ-COMPANY-NO                                      
                   ,:WQ-ITEM-ID                                         
                   ,:WQ-RESP-AREA-ID                                    
                   ,CIS.CURRENT$TIMESTAMP()                                   
                   ,:WQ-USER-ID-ASGN                                    
                   )                                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_WQ_ASSGN_HSTY                                     
MFA-TR*            (                                                            
MFA-TR*             COMPANY_NO                                                  
MFA-TR*            ,ITEM_ID                                                     
MFA-TR*            ,RESP_AREA_ID                                                
MFA-TR*            ,REASSIGN_DATE                                               
MFA-TR*            ,USER_ID                                                     
MFA-TR*            )                                                            
MFA-TR*         VALUES                                                          
MFA-TR*            (                                                            
MFA-TR*             :WQ-COMPANY-NO                                              
MFA-TR*            ,:WQ-ITEM-ID                                                 
MFA-TR*            ,:WQ-RESP-AREA-ID                                            
MFA-TR*            ,CURRENT TIMESTAMP                                           
MFA-TR*            ,:WQ-USER-ID-ASGN                                            
MFA-TR*            )                                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8000'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_WQ_ASSGN_HSTY'      TO TABLE-1                  
              MOVE 'ITEM_NO'                TO TABLE-ELEMENT-1          
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-2          
              MOVE WQ-ITEM-ID               TO HOSTVAR-ELEMENT-1        
              MOVE WQ-COMPANY-NO            TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8050-UPDATE-WQ-ITEMS.                                          *        
      ******************************************************************        
       8050-UPDATE-WQ-ITEMS.                                            
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_WQ_ITEMS                                       
                 SET STATUS                  = :WS-DELETE               
                    ,RESP_AREA_ID            = :PF-RESP-AREA-ID         
                    ,USER_ID_ASGN            = :PF-USER-ID              
                    ,COMPLETE_DATE           =  CIS.CURRENT$TIMESTAMP()       
                    ,ASSGN_HIST_PRES_FL      = 'Y'                      
               WHERE ITEM_ID                 = :WQ-ITEM-ID              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_WQ_ITEMS                                               
MFA-TR*          SET STATUS                  = :WS-DELETE                       
MFA-TR*             ,RESP_AREA_ID            = :PF-RESP-AREA-ID                 
MFA-TR*             ,USER_ID_ASGN            = :PF-USER-ID                      
MFA-TR*             ,COMPLETE_DATE           =  CURRENT TIMESTAMP               
MFA-TR*             ,ASSGN_HIST_PRES_FL      = 'Y'                              
MFA-TR*        WHERE ITEM_ID                 = :WQ-ITEM-ID                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8050'                   TO ACTIVE-PARAGRAPH         
              MOVE 'UPDATE'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_WQ_ITEMS'           TO TABLE-1                  
              MOVE 'ITEM_NO'                TO TABLE-ELEMENT-1          
              MOVE WQ-ITEM-ID               TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8100-SEND-RESULT.                                              *        
      ******************************************************************        
       8100-SEND-RESULT.                                                
                                                                        
           ADD +1                           TO CTR-ROWS.                
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 9700-ABEND-PROCESSING.                                         *        
      ******************************************************************        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT.             
           PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT.             
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *                                                                *        
      * END PROGRAM COPYLIB.                                           *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00321                                                  
           END-EXEC.                                                            
                                                                        
