       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       CSR04674.                                      
COB303 DATE-WRITTEN.     SEPTEMBER,2013.                                
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROCEDURE WILL RETRIEVE THE DETAIL VIEW OF ONE           *        
      *  WORK QUEUE ITEM THAT HAS BEEN SELECTED FROM A WORK            *        
      *  QUEUE BROWSE.                                                 *        
      *                                                                *        
      *  CLONED FROM CSR01097.                                         *        
      ******************************************************************        
      *                                                                *        
      *  BUSINESOP : RequGetWorkQueueSearchResultsBusinessOp           *        
      *                                                                *        
      *  INPUT PARAMETERS:                                             *        
      *                                                                *        
      *          I_ITEM_ID               DECIMAL(10,0)                 *        
      *          I_CATEGORY_ID           SMALLINT                      *        
      *          I_STATUS                CHAR(1)                       *        
      *          I_RESP_AREA_ID          CHAR(3)                       *        
      *          I_USER_ID_ASGN          CHAR(7)                       *        
      *          I_USER_ID_ORIG          CHAR(7)                       *        
      *          I_ACCOUNT_NO            CHAR(13)                      *        
      *          I_CUSTOMER_NO           CHAR(10)                      *        
      *          I_PREMISE_NO            CHAR(10)                      *        
      *          I_REQUIRED_DATE_BY      CHAR(26)                      *        
      *          I_REQUIRED_DATE_FROM    CHAR(26)                      *        
      *          I_COMPLETE_DATE_BY      CHAR(26)                      *        
      *          I_COMPLETE_DATE_FROM    CHAR(26)                      *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *  RESUT SET 1:                                                  *        
      *                                                                *        
      *             RETURN_CODE          INTEGER                       *        
      *             APPL_RETURN_CODE     INTEGER                       *        
      *             ITEM_ID              DECIMAL(10,0)                 *        
      *             DATE_CREATED         CHAR(26)                      *        
      *             ACCOUNT_NO           DECIMAL(13,0)                 *        
      *             PREMISE_NO           DECIMAL(10,0)                 *        
      *             CUSTOMER_NO          DECIMAL(10,0)                 *        
      *             STATUS               CHAR(1)                       *        
      *             USER_ID_ORIG         CHAR(7)                       *        
      *             USER_ID_ASGN         CHAR(7)                       *        
      *             RESP_AREA_ID         CHAR(3)                       *        
      *             COMPLETE_DATE        CHAR(26)                      *        
      *             CATEGORY_ID          SMALLINT                      *        
      *             DATE_REQUIRED        CHAR(26)                      *        
      *             PRIORITY             CHAR(1)                       *        
      *             WQ_ERROR_CD          CHAR(4)                       *        
      *             LAST_UPDATE_TS       CHAR(26)                      *        
      *             ADDRESS_LINE1        CHAR(55)                      *        
      *             ADDRESS_LINE2        CHAR(41)                      *        
      *             ZIP_CODE             CHAR(5)                       *        
      *             PHONE_NO             CHAR(10)                      *        
      *             FULL_NAME            CHAR(70)                      *        
      *             LOCAL_OFFICE         CHAR(3)                       *        
      *             BILL_CYCLE           CHAR(2)                       *        
      *             MST_SUB_ACCT_IND     CHAR(6)                       *        
      *             ASSIGN_HIST_IND      CHAR(1)                       *        
      *             TASKS_COUNT          SMALLINT                               
      *             COMMENTS             VARCHAR(250)                  *        
      *             FREE_FORM_AREA       VARCHAR(255)                  *        
A00509*             TOTAL_RECORDS        INTEGER                       *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  08/29/13  SS7F226    CLONED FROM CSR01097 AND ADDED RETURN    *        
      *                       CODE AND APPL RETURN CODE                *        
A00509*  08/27/14  MC95456    FOR PERFORMANCE USED ROWSET FOR 500 ROWS *        
A00509*  02/05/16  NC94746    INCREASED FETCH ROW COUNT TO 750 ROWS    *        
ACT118*  04/12/16  TP7R341    INCREASED FETCH ROW COUNT TO 999 ROWS    *        
ACT118*            APPL5460                                            *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ008  01 MSQ008-WQ-CUR6  PIC S9(9) COMP-5.
MSQ008  01 MSQ008-WQ-CUR5  PIC S9(9) COMP-5.
MSQ008  01 MSQ008-WQ-CUR4  PIC S9(9) COMP-5.
MSQ008  01 MSQ008-WQ-CUR3  PIC S9(9) COMP-5.
MSQ008  01 MSQ008-WQ-CUR2  PIC S9(9) COMP-5.
MSQ008  01 MSQ008-WQ-CUR1  PIC S9(9) COMP-5.
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04674'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04674 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
                                                                        
      ******************************************************************        
      *   CSS_ACCOUNT        AT                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CSS_CUST_PHONE     CB                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCSTPHN                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CSS_CUSTOMER       CU                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCUST                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CSS_NAME           DQ                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
                                                                        
                                                                        
      ******************************************************************        
      *   CSS_RESP_AREA      C1                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBRSAREA                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CSS_WQ_CATEGORY    C3                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBWQCAT                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CSS_ADDR_FORMATTED DY                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *   CSS_USER_PROFILE   PF                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CSS_PREMISE        PR                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
                                                                        
                                                                        
      ******************************************************************        
      *   CSS_WQ_ITEMS       WQ                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBWQITS                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CSS_ZIP_CODE       A4                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBZIPCD                                                   
           END-EXEC.                                                            
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE CWSSP001                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01 GW-LIB-MISC-FIELDS.                                           
          05 PROGRAM-NAME              PIC X(08)  VALUE 'CSR04674'.     
          05 WS-MIN-TMST               PIC X(26) VALUE                  
                                        '0001-01-01-00.00.00.000000'.   
          05 WS-MAX-TMST               PIC X(26) VALUE                  
                                        '2099-12-31-23.59.59.999999'.   
A00509    05 WS-TOT-ROWS-COUNT          PIC S9(09) COMP VALUE 0.        
A00509    05 WS-ROWS-COUNT              PIC S9(09) COMP VALUE 0.        
A00509    05 WS-SUB                     PIC S9(04) COMP.                
A00509    05 WS-WQ-RESULT.                                              
A00509       10 WS-WQ-ITEM-ID            PIC S9(10)V USAGE COMP-3       
ACT118                                   OCCURS 999 TIMES VALUE 0.      
A00509       10 WS-WQ-DATE-CREATED       PIC X(26)                      
ACT118                                   OCCURS 999 TIMES VALUE SPACES. 
A00509       10 WS-WQ-ACCOUNT-NO         PIC S9(13)V USAGE COMP-3       
ACT118                                   OCCURS 999 TIMES VALUE 0.      
A00509       10 WS-WQ-PREMISE-NO         PIC S9(10)V USAGE COMP-3       
ACT118                                   OCCURS 999 TIMES VALUE 0.      
A00509       10 WS-WQ-CUSTOMER-NO        PIC S9(10)V USAGE COMP-3       
ACT118                                   OCCURS 999 TIMES VALUE 0.      
A00509       10 WS-WQ-STATUS             PIC X(1)                       
ACT118                                   OCCURS 999 TIMES VALUE SPACES. 
A00509       10 WS-WQ-USER-ID-ORIG       PIC X(7)                       
ACT118                                   OCCURS 999 TIMES VALUE SPACES. 
A00509       10 WS-WQ-USER-ID-ASGN       PIC X(7)                       
ACT118                                   OCCURS 999 TIMES VALUE SPACES. 
A00509       10 WS-WQ-RESP-AREA-ID       PIC X(3)                       
ACT118                                   OCCURS 999 TIMES VALUE SPACES. 
A00509       10 WS-WQ-COMPLETE-DATE      PIC X(26)                      
ACT118                                   OCCURS 999 TIMES VALUE SPACES. 
A00509       10 WS-WQ-NULL-IND-01        PIC S9(04) COMP                
ACT118                                   OCCURS 999 TIMES VALUE 0.      
A00509       10 WS-WQ-CATEGORY-ID        PIC S9(4) USAGE COMP           
ACT118                                   OCCURS 999 TIMES VALUE 0.      
ACT118       10 WS-WQ-COMMENTS           OCCURS 999 TIMES.              
A00509          49 WS-WQ-COMMENTS-LEN    PIC S9(4) USAGE COMP SYNC.     
A00509          49 WS-WQ-COMMENTS-TXT    PIC X(250).                    
A00509       10 WS-WQ-DATE-REQUIRED      PIC X(26)                      
ACT118                                   OCCURS 999 TIMES VALUE SPACES. 
A00509       10 WS-WQ-NULL-IND-02        PIC S9(04) COMP                
ACT118                                   OCCURS 999 TIMES VALUE 0.      
A00509       10 WS-WQ-PRIORITY           PIC X(1)                       
ACT118                                   OCCURS 999 TIMES VALUE SPACES. 
ACT118       10 WS-WQ-FREE-FORM-AREA     OCCURS 999 TIMES.              
A00509          49 WS-WQ-FREE-FORM-AREA-LEN  PIC S9(04) COMP SYNC.      
A00509          49 WS-WQ-FREE-FORM-AREA-TXT  PIC X(255).                
A00509       10 WS-WQ-ERROR-CD           PIC X(1)                       
ACT118                                   OCCURS 999 TIMES VALUE SPACES. 
A00509       10 WS-WQ-LAST-UPDATE-TS     PIC X(26)                      
ACT118                                   OCCURS 999 TIMES VALUE SPACES. 
A00509       10 WS-WQ-ASSGN-HIST-PRES-FL PIC X(01)                      
ACT118                                   OCCURS 999 TIMES VALUE SPACES. 
A00509       10 WS-AT-BILL-CYCLE         PIC X(2)                       
ACT118                                   OCCURS 999 TIMES VALUE SPACES. 
A00509       10 WS-AT-MST-SUB-ACCT-IND   PIC X(1)                       
ACT118                                   OCCURS 999 TIMES VALUE SPACES. 
                                                                        
       01  SWITCHES.                                                    
           05 SEND-DONE-SW                  PIC X(01) VALUE 'Y'.        
              88 SEND-DONE-ERROR                  VALUE 'N'.            
                                                                        
       01  WS-NULL-INDICATORS.                                          
           05  WS-NULL-IND-01               PIC S9(04) COMP.            
           05  WS-NULL-IND-02               PIC S9(04) COMP.            
                                                                        
       01 WS-INPUT-FIELDS.                                              
          05 WS-IN-CATEGORY-ID              PIC S9(4) USAGE COMP.       
          05 WS-IN-RESP-AREA-ID             PIC X(3).                   
          05 WS-IN-USER-ID-ASGN             PIC X(7).                   
          05 WS-IN-USER-ID-ORIG             PIC X(7).                   
COB305    05 WS-IN-CUSTOMER-NO        PIC S9(10)V USAGE COMP-3 VALUE 0.   
COB305    05 WS-IN-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.   
COB305    05 WS-IN-PREMISE-NO        PIC S9(10)V USAGE COMP-3 VALUE 0.   
          05 WS-IN-REQUIRED-DATE-FROM       PIC X(26).                  
          05 WS-IN-REQUIRED-DATE-BY         PIC X(26).                  
          05 WS-IN-COMPLETE-DATE-FROM       PIC X(26).                  
          05 WS-IN-COMPLETE-DATE-BY         PIC X(26).                  
          05 WS-IN-STATUS                   PIC X(1).                   
          05 WS-IN-STATUS1                  PIC X(1).                   
          05 WS-IN-STATUS2                  PIC X(1).                   
          05 WS-IN-STATUS3                  PIC X(1).                   
          05 WS-IN-STATUS4                  PIC X(1).                   
COB305    05 WS-IN-ITEM-ID        PIC S9(10)V USAGE COMP-3 VALUE 0.   
                                                                        
       01 WS-TEMP-FIELDS.                                               
          05 WS-CUSTOMER-NO                 PIC 9(10).                  
          05 WS-ACCOUNT-NO                  PIC 9(13).                  
          05 WS-PREMISE-NO                  PIC 9(10).                  
          05 WS-TASKS-COUNT                 PIC S9(4) USAGE COMP.       
                                                                        
       01 WS-NAME-FORMATTING.                                           
          05 WS-LAST-NAME-SUFF.                                         
             10 WS-LAST-NAME             PIC X(40).                     
             10 FILLER                   PIC X(04) VALUE SPACES.        
          05 WS-FIRST-NAME-SUFF.                                        
             10 WS-FIRST-NAME            PIC X(15).                     
             10 FILLER                   PIC X(04) VALUE SPACES.        
          05 WS-MIDDLE-NAME-INI          PIC X(1).                      
                                                                        
       01 WS-ADDRESS.                                                   
          05 WS-IN-STRING.                                              
             10 WS-IN-CHAR               PIC X(1) OCCURS 85 TIMES       
                                            INDEXED BY WS-IN-INDX.      
          05 WS-OUT-STRING.                                             
             10 WS-OUT-CHAR               PIC X(1) OCCURS 85 TIMES      
                                            INDEXED BY WS-OUT-INDX.     
          05 WS-LAST-CHAR                PIC X(1)   VALUE SPACES.       
          05 WS-CHAR-LENGTH              PIC S9(03) VALUE ZERO.         
          05 WS-STREET-ADDRESS.                                         
             10 WS-HOUSE-NO              PIC X(15).                     
             10 FILLER                   PIC X(01) VALUE SPACES.        
             10 WS-ADDR-PREFIX-1         PIC X(03).                     
             10 FILLER                   PIC X(01) VALUE SPACES.        
             10 WS-ADDR-PREFIX-2         PIC X(02).                     
             10 FILLER                   PIC X(01) VALUE SPACES.        
             10 WS-NAME-STREET           PIC X(30).                     
             10 FILLER                   PIC X(01) VALUE SPACES.        
             10 WS-STREET-SUFFIX         PIC X(04).                     
             10 FILLER                   PIC X(01) VALUE SPACES.        
             10 WS-ADDRESS-SUFFIX        PIC X(02).                     
             10 FILLER                   PIC X(01) VALUE SPACES.        
             10 WS-STREET-LOCATION-1     PIC X(04).                     
             10 FILLER                   PIC X(01) VALUE SPACES.        
             10 WS-STREET-LOCATION-2     PIC X(11).                     
             10 FILLER                   PIC X(04) VALUE SPACES.        
          05 WS-CITY-STATE.                                             
             10 WS-CITY                  PIC X(26).                     
             10 FILLER                   PIC X(01) VALUE SPACES.        
             10 WS-STATE                 PIC X(02).                     
             10 WS-ZIP-FILLER            PIC X(02) VALUE ' *'.          
             10 WS-ZIP.                                                 
                15 WS-ZIP-CODE           PIC X(05).                     
                15 WS-ZIP-DASH           PIC X(01) VALUE '-'.           
                15 WS-ZIP-PLUS-4         PIC X(04).                     
                                                                        
       01 GTT-RETURN-FIELDS.                                            
          05 S-RETURN-CODE               PIC S9(09) COMP VALUE 0.       
          05 S-APPL-RETURN-CODE          PIC S9(09) COMP VALUE 0.       
COB305    05 S-ITEM-ID        PIC S9(10)V USAGE COMP-3 VALUE 0.      
          05 S-DATE-CREATED              PIC X(26).                     
COB305    05 S-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.      
COB305    05 S-PREMISE-NO        PIC S9(10)V USAGE COMP-3 VALUE 0.      
COB305    05 S-CUSTOMER-NO        PIC S9(10)V USAGE COMP-3 VALUE 0.      
          05 S-STATUS                    PIC X(1).                      
          05 S-USER-ID-ORIG              PIC X(7).                      
          05 S-USER-ID-ASGN              PIC X(7).                      
          05 S-RESP-AREA-ID              PIC X(3).                      
          05 S-COMPLETE-DATE             PIC X(26).                     
          05 S-CATEGORY-ID               PIC S9(4) USAGE COMP.          
          05 S-DATE-REQUIRED             PIC X(26).                     
          05 S-PRIORITY                  PIC X(1).                      
          05 S-WQ-ERROR-CD               PIC X(4).                      
          05 S-LAST-UPDATE-TS            PIC X(26).                     
          05 S-ADDRESS-LINE1             PIC X(55).                     
          05 S-ADDRESS-LINE2             PIC X(41).                     
          05 S-ZIP-CODE                  PIC X(5).                      
          05 S-PHONE-NO                  PIC X(10).                     
          05 S-FULL-NAME                 PIC X(70).                     
          05 S-LOCAL-OFFICE              PIC X(3).                      
          05 S-BILL-CYCLE                PIC X(2).                      
          05 S-MST-SUB-ACCT-IND          PIC X(6).                      
          05 S-ASSIGN-HIST-IND           PIC X(1).                      
          05 S-TASKS-COUNT               PIC S9(4) USAGE COMP.          
          05 S-COMMENTS.                                                
             49 S-COMMENTS-LEN           PIC S9(4) USAGE COMP.          
             49 S-COMMENTS-TEXT          PIC X(250).                    
          05 S-FREE-FORM-AREA.                                          
             49 S-FREE-FORM-AREA-LEN     PIC S9(4) USAGE COMP.          
             49 S-FREE-FORM-AREA-TEXT    PIC X(255).                    
A00509    05 S-TOTAL-RECORDS             PIC S9(9) COMP VALUE 0.        
                                                                        
      ******************************************************************        
      *   CURSOR DECLARATION TO RETRIVE WORK QUEUE ITEMS WHEN                   
      *   CUSTOMER ACCOUNT PROVIDED IN SEARCH CRITERIA                 *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
A00509        DECLARE WQ_CURX1 CURSOR FOR                               
                SELECT WQ.ITEM_ID                                       
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), WQ.DATE_CREATED
           , 121), ' ', '-'), ':', '.') DATE_CREATED                           
                      ,WQ.ACCOUNT_NO                                    
                      ,COALESCE(AT.PREMISE_NO, WQ.PREMISE_NO)           
                      ,COALESCE(AT.CUSTOMER_NO, WQ.CUSTOMER_NO)         
                      ,WQ.STATUS                                        
                      ,WQ.USER_ID_ORIG                                  
                      ,WQ.USER_ID_ASGN                                  
                      ,WQ.RESP_AREA_ID                                  
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           WQ.COMPLETE_DATE, 121), ' ', '-'), ':', '.') COMPLETE_DATE          
                      ,WQ.CATEGORY_ID                                   
                      ,WQ.COMMENTS                                      
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           WQ.DATE_REQUIRED, 121), ' ', '-'), ':', '.') DATE_REQUIRED          
                      ,WQ.PRIORITY                                      
                      ,WQ.FREE_FORM_AREA                                
                      ,WQ.WQ_ERROR_CD                                   
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           WQ.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS        
                      ,WQ.ASSGN_HIST_PRES_FL                            
                      ,COALESCE(AT.BILL_CYCLE, '  ')                    
                      ,COALESCE(AT.MST_SUB_ACCT_IND, ' ')               
                  FROM CSS_WQ_ITEMS WQ WITH(READUNCOMMITTED) LEFT JOIN          
                       CSS_ACCOUNT  AT WITH(READUNCOMMITTED)                    
                    ON AT.ACCOUNT_NO = WQ.ACCOUNT_NO                    
                 WHERE WQ.ITEM_ID    = :WS-IN-ITEM-ID                   
                   FOR READ ONLY                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE WQ_CURX1 CURSOR FOR                                       
MFA-TR*         SELECT WQ.ITEM_ID                                               
MFA-TR*               ,WQ.DATE_CREATED                                          
MFA-TR*               ,WQ.ACCOUNT_NO                                            
MFA-TR*               ,COALESCE(AT.PREMISE_NO, WQ.PREMISE_NO)                   
MFA-TR*               ,COALESCE(AT.CUSTOMER_NO, WQ.CUSTOMER_NO)                 
MFA-TR*               ,WQ.STATUS                                                
MFA-TR*               ,WQ.USER_ID_ORIG                                          
MFA-TR*               ,WQ.USER_ID_ASGN                                          
MFA-TR*               ,WQ.RESP_AREA_ID                                          
MFA-TR*               ,WQ.COMPLETE_DATE                                         
MFA-TR*               ,WQ.CATEGORY_ID                                           
MFA-TR*               ,WQ.COMMENTS                                              
MFA-TR*               ,WQ.DATE_REQUIRED                                         
MFA-TR*               ,WQ.PRIORITY                                              
MFA-TR*               ,WQ.FREE_FORM_AREA                                        
MFA-TR*               ,WQ.WQ_ERROR_CD                                           
MFA-TR*               ,WQ.LAST_UPDATE_TS                                        
MFA-TR*               ,WQ.ASSGN_HIST_PRES_FL                                    
MFA-TR*               ,COALESCE(AT.BILL_CYCLE, '  ')                            
MFA-TR*               ,COALESCE(AT.MST_SUB_ACCT_IND, ' ')                       
MFA-TR*           FROM CSS_WQ_ITEMS WQ LEFT JOIN                                
MFA-TR*                CSS_ACCOUNT  AT                                          
MFA-TR*             ON AT.ACCOUNT_NO = WQ.ACCOUNT_NO                            
MFA-TR*          WHERE WQ.ITEM_ID    = :WS-IN-ITEM-ID                           
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*        QUERYNO 7050                                                     
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CURSOR DECLARATION TO RETRIVE WORK QUEUE ITEMS WHEN                   
      *   CUSTOMER ACCOUNT PROVIDED IN SEARCH CRITERIA                 *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
A00509        DECLARE WQ_CUR1 CURSOR WITH ROWSET POSITIONING FOR        
                SELECT TOP(999) WQ.ITEM_ID,
              REPLACE(REPLACE(CONVERT(CHAR(26), WQ.DATE_CREATED, 121), 
           ' ', '-'), ':', '.') DATE_CREATED,
              WQ.ACCOUNT_NO,
              COALESCE(AT.PREMISE_NO, WQ.PREMISE_NO),
              COALESCE(AT.CUSTOMER_NO, WQ.CUSTOMER_NO),
              WQ.STATUS,
              WQ.USER_ID_ORIG,
              WQ.USER_ID_ASGN,
              WQ.RESP_AREA_ID,
              REPLACE(REPLACE(CONVERT(CHAR(26), WQ.COMPLETE_DATE, 121), 
           ' ', '-'), ':', '.') COMPLETE_DATE,
              WQ.CATEGORY_ID,
              WQ.COMMENTS,
              REPLACE(REPLACE(CONVERT(CHAR(26), WQ.DATE_REQUIRED, 121), 
           ' ', '-'), ':', '.') DATE_REQUIRED,
              WQ.PRIORITY,
              WQ.FREE_FORM_AREA,
              WQ.WQ_ERROR_CD,
              REPLACE(REPLACE(CONVERT(CHAR(26), WQ.LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS,
              WQ.ASSGN_HIST_PRES_FL,
              COALESCE(AT.BILL_CYCLE, '  '),
              COALESCE(AT.MST_SUB_ACCT_IND, ' ')               
                 FROM CSS_WQ_ITEMS WQ WITH(READUNCOMMITTED) LEFT JOIN           
                      CSS_ACCOUNT  AT WITH(READUNCOMMITTED)                     
                   ON AT.ACCOUNT_NO = WQ.ACCOUNT_NO                     
                WHERE WQ.ACCOUNT_NO = :WS-IN-ACCOUNT-NO                 
                  AND WQ.STATUS  IN ( :WS-IN-STATUS1, :WS-IN-STATUS2    
                                  ,:WS-IN-STATUS3, :WS-IN-STATUS4 )     
                  AND WQ.DATE_REQUIRED BETWEEN                          
                                      CIS.CHAR2TIMESTAMP(
                                              :WS-IN-REQUIRED-DATE-FROM
              )         
                                  AND CIS.CHAR2TIMESTAMP(
                                                :WS-IN-REQUIRED-DATE-BY
              )           
                  AND (WQ.CATEGORY_ID = :WS-IN-CATEGORY-ID              
                       OR :WS-IN-CATEGORY-ID = 0 )                      
                  AND (WQ.RESP_AREA_ID = :WS-IN-RESP-AREA-ID            
                       OR :WS-IN-RESP-AREA-ID = '   ')                  
                  AND (WQ.USER_ID_ORIG = :WS-IN-USER-ID-ORIG            
                       OR :WS-IN-USER-ID-ORIG = '       ')              
                  AND (WQ.USER_ID_ASGN =     :WS-IN-USER-ID-ASGN        
                       OR :WS-IN-USER-ID-ASGN = '       ')              
                  AND ((:WS-IN-COMPLETE-DATE-BY <> :WS-MIN-TMST         
                       AND WQ.COMPLETE_DATE BETWEEN                     
                       CIS.CHAR2TIMESTAMP(:WS-IN-COMPLETE-DATE-FROM)            
                       AND CIS.CHAR2TIMESTAMP(:WS-IN-COMPLETE-DATE-BY) )        
                     OR (:WS-IN-COMPLETE-DATE-BY = :WS-MIN-TMST ))      
                ORDER BY WQ.PRIORITY, DATE_CREATED DESC              
ACT118                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE WQ_CUR1 CURSOR WITH ROWSET POSITIONING FOR                
MFA-TR*         SELECT WQ.ITEM_ID                                               
MFA-TR*               ,WQ.DATE_CREATED                                          
MFA-TR*               ,WQ.ACCOUNT_NO                                            
MFA-TR*               ,COALESCE(AT.PREMISE_NO, WQ.PREMISE_NO)                   
MFA-TR*               ,COALESCE(AT.CUSTOMER_NO, WQ.CUSTOMER_NO)                 
MFA-TR*               ,WQ.STATUS                                                
MFA-TR*               ,WQ.USER_ID_ORIG                                          
MFA-TR*               ,WQ.USER_ID_ASGN                                          
MFA-TR*               ,WQ.RESP_AREA_ID                                          
MFA-TR*               ,WQ.COMPLETE_DATE                                         
MFA-TR*               ,WQ.CATEGORY_ID                                           
MFA-TR*               ,WQ.COMMENTS                                              
MFA-TR*               ,WQ.DATE_REQUIRED                                         
MFA-TR*               ,WQ.PRIORITY                                              
MFA-TR*               ,WQ.FREE_FORM_AREA                                        
MFA-TR*               ,WQ.WQ_ERROR_CD                                           
MFA-TR*               ,WQ.LAST_UPDATE_TS                                        
MFA-TR*               ,WQ.ASSGN_HIST_PRES_FL                                    
MFA-TR*               ,COALESCE(AT.BILL_CYCLE, '  ')                            
MFA-TR*               ,COALESCE(AT.MST_SUB_ACCT_IND, ' ')                       
MFA-TR*          FROM CSS_WQ_ITEMS WQ LEFT JOIN                                 
MFA-TR*               CSS_ACCOUNT  AT                                           
MFA-TR*            ON AT.ACCOUNT_NO = WQ.ACCOUNT_NO                             
MFA-TR*         WHERE WQ.ACCOUNT_NO = :WS-IN-ACCOUNT-NO                         
MFA-TR*           AND WQ.STATUS  IN ( :WS-IN-STATUS1, :WS-IN-STATUS2            
MFA-TR*                           ,:WS-IN-STATUS3, :WS-IN-STATUS4 )             
MFA-TR*           AND WQ.DATE_REQUIRED BETWEEN                                  
MFA-TR*                               :WS-IN-REQUIRED-DATE-FROM                 
MFA-TR*                           AND :WS-IN-REQUIRED-DATE-BY                   
MFA-TR*           AND (WQ.CATEGORY_ID = :WS-IN-CATEGORY-ID                      
MFA-TR*                OR :WS-IN-CATEGORY-ID = 0 )                              
MFA-TR*           AND (WQ.RESP_AREA_ID = :WS-IN-RESP-AREA-ID                    
MFA-TR*                OR :WS-IN-RESP-AREA-ID = '   ')                          
MFA-TR*           AND (WQ.USER_ID_ORIG = :WS-IN-USER-ID-ORIG                    
MFA-TR*                OR :WS-IN-USER-ID-ORIG = '       ')                      
MFA-TR*           AND (WQ.USER_ID_ASGN =     :WS-IN-USER-ID-ASGN                
MFA-TR*                OR :WS-IN-USER-ID-ASGN = '       ')                      
MFA-TR*           AND ((:WS-IN-COMPLETE-DATE-BY <> :WS-MIN-TMST                 
MFA-TR*                AND WQ.COMPLETE_DATE BETWEEN                             
MFA-TR*                :WS-IN-COMPLETE-DATE-FROM                                
MFA-TR*                AND :WS-IN-COMPLETE-DATE-BY )                            
MFA-TR*              OR (:WS-IN-COMPLETE-DATE-BY = :WS-MIN-TMST ))              
MFA-TR*         ORDER BY WQ.PRIORITY, WQ.DATE_CREATED DESC                      
MFA-TR*         FETCH FIRST 999 ROWS ONLY WITH UR                               
MFA-TR*       QUERYNO 7100                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CURSOR DECLARATION TO RETRIVE WORK QUEUE ITEMS WHEN                   
      *   CUSTOMER NO OR PRIMISE NO PROVIDED IN SEARCH CRITERIA                 
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
A00509        DECLARE WQ_CUR2 CURSOR WITH ROWSET POSITIONING FOR        
                SELECT TOP(999) WQ.ITEM_ID,
              REPLACE(REPLACE(CONVERT(CHAR(26), WQ.DATE_CREATED, 121), 
           ' ', '-'), ':', '.') DATE_CREATED,
              WQ.ACCOUNT_NO,
              COALESCE(AT.PREMISE_NO, WQ.PREMISE_NO),
              COALESCE(AT.CUSTOMER_NO, WQ.CUSTOMER_NO),
              WQ.STATUS,
              WQ.USER_ID_ORIG,
              WQ.USER_ID_ASGN,
              WQ.RESP_AREA_ID,
              REPLACE(REPLACE(CONVERT(CHAR(26), WQ.COMPLETE_DATE, 121), 
           ' ', '-'), ':', '.') COMPLETE_DATE,
              WQ.CATEGORY_ID,
              WQ.COMMENTS,
              REPLACE(REPLACE(CONVERT(CHAR(26), WQ.DATE_REQUIRED, 121), 
           ' ', '-'), ':', '.') DATE_REQUIRED,
              WQ.PRIORITY,
              WQ.FREE_FORM_AREA,
              WQ.WQ_ERROR_CD,
              REPLACE(REPLACE(CONVERT(CHAR(26), WQ.LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS,
              WQ.ASSGN_HIST_PRES_FL,
              COALESCE(AT.BILL_CYCLE, '  '),
              COALESCE(AT.MST_SUB_ACCT_IND, ' ')               
                 FROM CSS_WQ_ITEMS WQ WITH(READUNCOMMITTED) LEFT JOIN           
                      CSS_ACCOUNT  AT WITH(READUNCOMMITTED)                     
                   ON AT.ACCOUNT_NO = WQ.ACCOUNT_NO                     
                WHERE WQ.CUSTOMER_NO IN (:WS-IN-CUSTOMER-NO, 0)         
                  AND WQ.PREMISE_NO  IN (:WS-IN-PREMISE-NO, 0)          
                  AND WQ.ACCOUNT_NO  IN (:WS-IN-ACCOUNT-NO, 0)          
                  AND (WQ.CUSTOMER_NO > 0 OR WQ.PREMISE_NO > 0          
                                          OR WQ.ACCOUNT_NO > 0)         
                  AND WQ.STATUS  IN ( :WS-IN-STATUS1, :WS-IN-STATUS2    
                                     ,:WS-IN-STATUS3 )                  
                  AND WQ.DATE_REQUIRED BETWEEN                          
                                   CIS.CHAR2TIMESTAMP(
                                              :WS-IN-REQUIRED-DATE-FROM
              )            
                               AND CIS.CHAR2TIMESTAMP(
                                                :WS-IN-REQUIRED-DATE-BY
              )              
                  AND (WQ.CATEGORY_ID = :WS-IN-CATEGORY-ID              
                       OR :WS-IN-CATEGORY-ID = 0 )                      
                  AND (WQ.RESP_AREA_ID = :WS-IN-RESP-AREA-ID            
                       OR :WS-IN-RESP-AREA-ID = '   ')                  
                  AND (WQ.USER_ID_ORIG = :WS-IN-USER-ID-ORIG            
                       OR :WS-IN-USER-ID-ORIG = '       ')              
                  AND (WQ.USER_ID_ASGN =  :WS-IN-USER-ID-ASGN           
                       OR :WS-IN-USER-ID-ASGN = '       ')              
                  AND ((:WS-IN-COMPLETE-DATE-BY <> :WS-MIN-TMST         
                       AND WQ.COMPLETE_DATE BETWEEN                     
                       CIS.CHAR2TIMESTAMP(:WS-IN-COMPLETE-DATE-FROM)            
                       AND CIS.CHAR2TIMESTAMP(:WS-IN-COMPLETE-DATE-BY) )        
                     OR (:WS-IN-COMPLETE-DATE-BY = :WS-MIN-TMST ))      
                ORDER BY WQ.PRIORITY, DATE_CREATED DESC              
ACT118                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE WQ_CUR2 CURSOR WITH ROWSET POSITIONING FOR                
MFA-TR*         SELECT WQ.ITEM_ID                                               
MFA-TR*               ,WQ.DATE_CREATED                                          
MFA-TR*               ,WQ.ACCOUNT_NO                                            
MFA-TR*               ,COALESCE(AT.PREMISE_NO, WQ.PREMISE_NO)                   
MFA-TR*               ,COALESCE(AT.CUSTOMER_NO, WQ.CUSTOMER_NO)                 
MFA-TR*               ,WQ.STATUS                                                
MFA-TR*               ,WQ.USER_ID_ORIG                                          
MFA-TR*               ,WQ.USER_ID_ASGN                                          
MFA-TR*               ,WQ.RESP_AREA_ID                                          
MFA-TR*               ,WQ.COMPLETE_DATE                                         
MFA-TR*               ,WQ.CATEGORY_ID                                           
MFA-TR*               ,WQ.COMMENTS                                              
MFA-TR*               ,WQ.DATE_REQUIRED                                         
MFA-TR*               ,WQ.PRIORITY                                              
MFA-TR*               ,WQ.FREE_FORM_AREA                                        
MFA-TR*               ,WQ.WQ_ERROR_CD                                           
MFA-TR*               ,WQ.LAST_UPDATE_TS                                        
MFA-TR*               ,WQ.ASSGN_HIST_PRES_FL                                    
MFA-TR*               ,COALESCE(AT.BILL_CYCLE, '  ')                            
MFA-TR*               ,COALESCE(AT.MST_SUB_ACCT_IND, ' ')                       
MFA-TR*          FROM CSS_WQ_ITEMS WQ LEFT JOIN                                 
MFA-TR*               CSS_ACCOUNT  AT                                           
MFA-TR*            ON AT.ACCOUNT_NO = WQ.ACCOUNT_NO                             
MFA-TR*         WHERE WQ.CUSTOMER_NO IN (:WS-IN-CUSTOMER-NO, 0)                 
MFA-TR*           AND WQ.PREMISE_NO  IN (:WS-IN-PREMISE-NO, 0)                  
MFA-TR*           AND WQ.ACCOUNT_NO  IN (:WS-IN-ACCOUNT-NO, 0)                  
MFA-TR*           AND (WQ.CUSTOMER_NO > 0 OR WQ.PREMISE_NO > 0                  
MFA-TR*                                   OR WQ.ACCOUNT_NO > 0)                 
MFA-TR*           AND WQ.STATUS  IN ( :WS-IN-STATUS1, :WS-IN-STATUS2            
MFA-TR*                              ,:WS-IN-STATUS3 )                          
MFA-TR*           AND WQ.DATE_REQUIRED BETWEEN                                  
MFA-TR*                            :WS-IN-REQUIRED-DATE-FROM                    
MFA-TR*                        AND :WS-IN-REQUIRED-DATE-BY                      
MFA-TR*           AND (WQ.CATEGORY_ID = :WS-IN-CATEGORY-ID                      
MFA-TR*                OR :WS-IN-CATEGORY-ID = 0 )                              
MFA-TR*           AND (WQ.RESP_AREA_ID = :WS-IN-RESP-AREA-ID                    
MFA-TR*                OR :WS-IN-RESP-AREA-ID = '   ')                          
MFA-TR*           AND (WQ.USER_ID_ORIG = :WS-IN-USER-ID-ORIG                    
MFA-TR*                OR :WS-IN-USER-ID-ORIG = '       ')                      
MFA-TR*           AND (WQ.USER_ID_ASGN =  :WS-IN-USER-ID-ASGN                   
MFA-TR*                OR :WS-IN-USER-ID-ASGN = '       ')                      
MFA-TR*           AND ((:WS-IN-COMPLETE-DATE-BY <> :WS-MIN-TMST                 
MFA-TR*                AND WQ.COMPLETE_DATE BETWEEN                             
MFA-TR*                :WS-IN-COMPLETE-DATE-FROM                                
MFA-TR*                AND :WS-IN-COMPLETE-DATE-BY )                            
MFA-TR*              OR (:WS-IN-COMPLETE-DATE-BY = :WS-MIN-TMST ))              
MFA-TR*         ORDER BY WQ.PRIORITY, WQ.DATE_CREATED DESC                      
MFA-TR*         FETCH FIRST 999 ROWS ONLY WITH UR                               
MFA-TR*       QUERYNO 7150                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CURSOR DECLARATION TO RETRIVE WORK QUEUE ITEMS WHEN                   
      *   ASSIGN USER ID PROVIDED IN SEARCH CRITERIA                            
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
A00509        DECLARE WQ_CUR3 CURSOR WITH ROWSET POSITIONING FOR        
                SELECT TOP(999) WQ.ITEM_ID,
              REPLACE(REPLACE(CONVERT(CHAR(26), WQ.DATE_CREATED, 121), 
           ' ', '-'), ':', '.') DATE_CREATED,
              WQ.ACCOUNT_NO,
              COALESCE(AT.PREMISE_NO, WQ.PREMISE_NO),
              COALESCE(AT.CUSTOMER_NO, WQ.CUSTOMER_NO),
              WQ.STATUS,
              WQ.USER_ID_ORIG,
              WQ.USER_ID_ASGN,
              WQ.RESP_AREA_ID,
              REPLACE(REPLACE(CONVERT(CHAR(26), WQ.COMPLETE_DATE, 121), 
           ' ', '-'), ':', '.') COMPLETE_DATE,
              WQ.CATEGORY_ID,
              WQ.COMMENTS,
              REPLACE(REPLACE(CONVERT(CHAR(26), WQ.DATE_REQUIRED, 121), 
           ' ', '-'), ':', '.') DATE_REQUIRED,
              WQ.PRIORITY,
              WQ.FREE_FORM_AREA,
              WQ.WQ_ERROR_CD,
              REPLACE(REPLACE(CONVERT(CHAR(26), WQ.LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS,
              WQ.ASSGN_HIST_PRES_FL,
              COALESCE(AT.BILL_CYCLE, '  '),
              COALESCE(AT.MST_SUB_ACCT_IND, ' ')               
                 FROM CSS_WQ_ITEMS WQ WITH(READUNCOMMITTED) LEFT JOIN           
                      CSS_ACCOUNT  AT WITH(READUNCOMMITTED)                     
                   ON AT.ACCOUNT_NO = WQ.ACCOUNT_NO                     
                WHERE WQ.USER_ID_ASGN =     :WS-IN-USER-ID-ASGN         
                  AND WQ.STATUS  IN ( :WS-IN-STATUS1, :WS-IN-STATUS2    
                                     ,:WS-IN-STATUS3 )                  
                  AND WQ.DATE_REQUIRED BETWEEN                          
                                   CIS.CHAR2TIMESTAMP(
                                              :WS-IN-REQUIRED-DATE-FROM
              )            
                               AND CIS.CHAR2TIMESTAMP(
                                                :WS-IN-REQUIRED-DATE-BY
              )              
                  AND (WQ.CATEGORY_ID = :WS-IN-CATEGORY-ID              
                       OR :WS-IN-CATEGORY-ID = 0 )                      
                  AND (WQ.RESP_AREA_ID = :WS-IN-RESP-AREA-ID            
                       OR :WS-IN-RESP-AREA-ID = '   ')                  
                  AND (WQ.USER_ID_ORIG = :WS-IN-USER-ID-ORIG            
                       OR :WS-IN-USER-ID-ORIG = '       ')              
                  AND ((:WS-IN-COMPLETE-DATE-BY <> :WS-MIN-TMST         
                       AND WQ.COMPLETE_DATE BETWEEN                     
                       CIS.CHAR2TIMESTAMP(:WS-IN-COMPLETE-DATE-FROM)            
                       AND CIS.CHAR2TIMESTAMP(:WS-IN-COMPLETE-DATE-BY) )        
                     OR (:WS-IN-COMPLETE-DATE-BY = :WS-MIN-TMST ))      
                ORDER BY WQ.PRIORITY, DATE_CREATED DESC              
ACT118                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE WQ_CUR3 CURSOR WITH ROWSET POSITIONING FOR                
MFA-TR*         SELECT WQ.ITEM_ID                                               
MFA-TR*               ,WQ.DATE_CREATED                                          
MFA-TR*               ,WQ.ACCOUNT_NO                                            
MFA-TR*               ,COALESCE(AT.PREMISE_NO, WQ.PREMISE_NO)                   
MFA-TR*               ,COALESCE(AT.CUSTOMER_NO, WQ.CUSTOMER_NO)                 
MFA-TR*               ,WQ.STATUS                                                
MFA-TR*               ,WQ.USER_ID_ORIG                                          
MFA-TR*               ,WQ.USER_ID_ASGN                                          
MFA-TR*               ,WQ.RESP_AREA_ID                                          
MFA-TR*               ,WQ.COMPLETE_DATE                                         
MFA-TR*               ,WQ.CATEGORY_ID                                           
MFA-TR*               ,WQ.COMMENTS                                              
MFA-TR*               ,WQ.DATE_REQUIRED                                         
MFA-TR*               ,WQ.PRIORITY                                              
MFA-TR*               ,WQ.FREE_FORM_AREA                                        
MFA-TR*               ,WQ.WQ_ERROR_CD                                           
MFA-TR*               ,WQ.LAST_UPDATE_TS                                        
MFA-TR*               ,WQ.ASSGN_HIST_PRES_FL                                    
MFA-TR*               ,COALESCE(AT.BILL_CYCLE, '  ')                            
MFA-TR*               ,COALESCE(AT.MST_SUB_ACCT_IND, ' ')                       
MFA-TR*          FROM CSS_WQ_ITEMS WQ LEFT JOIN                                 
MFA-TR*               CSS_ACCOUNT  AT                                           
MFA-TR*            ON AT.ACCOUNT_NO = WQ.ACCOUNT_NO                             
MFA-TR*         WHERE WQ.USER_ID_ASGN =     :WS-IN-USER-ID-ASGN                 
MFA-TR*           AND WQ.STATUS  IN ( :WS-IN-STATUS1, :WS-IN-STATUS2            
MFA-TR*                              ,:WS-IN-STATUS3 )                          
MFA-TR*           AND WQ.DATE_REQUIRED BETWEEN                                  
MFA-TR*                            :WS-IN-REQUIRED-DATE-FROM                    
MFA-TR*                        AND :WS-IN-REQUIRED-DATE-BY                      
MFA-TR*           AND (WQ.CATEGORY_ID = :WS-IN-CATEGORY-ID                      
MFA-TR*                OR :WS-IN-CATEGORY-ID = 0 )                              
MFA-TR*           AND (WQ.RESP_AREA_ID = :WS-IN-RESP-AREA-ID                    
MFA-TR*                OR :WS-IN-RESP-AREA-ID = '   ')                          
MFA-TR*           AND (WQ.USER_ID_ORIG = :WS-IN-USER-ID-ORIG                    
MFA-TR*                OR :WS-IN-USER-ID-ORIG = '       ')                      
MFA-TR*           AND ((:WS-IN-COMPLETE-DATE-BY <> :WS-MIN-TMST                 
MFA-TR*                AND WQ.COMPLETE_DATE BETWEEN                             
MFA-TR*                :WS-IN-COMPLETE-DATE-FROM                                
MFA-TR*                AND :WS-IN-COMPLETE-DATE-BY )                            
MFA-TR*              OR (:WS-IN-COMPLETE-DATE-BY = :WS-MIN-TMST ))              
MFA-TR*         ORDER BY WQ.PRIORITY, WQ.DATE_CREATED DESC                      
MFA-TR*         FETCH FIRST 999 ROWS ONLY WITH UR                               
MFA-TR*       QUERYNO 7200                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CURSOR DECLARATION TO RETRIVE WORK QUEUE ITEMS WHEN                   
      *   RESP AREA ID PROVIDED IN SEARCH CRITERIA                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
A00509        DECLARE WQ_CUR4 CURSOR WITH ROWSET POSITIONING FOR        
                SELECT TOP(999) WQ.ITEM_ID,
              REPLACE(REPLACE(CONVERT(CHAR(26), WQ.DATE_CREATED, 121), 
           ' ', '-'), ':', '.') DATE_CREATED,
              WQ.ACCOUNT_NO,
              COALESCE(AT.PREMISE_NO, WQ.PREMISE_NO),
              COALESCE(AT.CUSTOMER_NO, WQ.CUSTOMER_NO),
              WQ.STATUS,
              WQ.USER_ID_ORIG,
              WQ.USER_ID_ASGN,
              WQ.RESP_AREA_ID,
              REPLACE(REPLACE(CONVERT(CHAR(26), WQ.COMPLETE_DATE, 121), 
           ' ', '-'), ':', '.') COMPLETE_DATE,
              WQ.CATEGORY_ID,
              WQ.COMMENTS,
              REPLACE(REPLACE(CONVERT(CHAR(26), WQ.DATE_REQUIRED, 121), 
           ' ', '-'), ':', '.') DATE_REQUIRED,
              WQ.PRIORITY,
              WQ.FREE_FORM_AREA,
              WQ.WQ_ERROR_CD,
              REPLACE(REPLACE(CONVERT(CHAR(26), WQ.LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS,
              WQ.ASSGN_HIST_PRES_FL,
              COALESCE(AT.BILL_CYCLE, '  '),
              COALESCE(AT.MST_SUB_ACCT_IND, ' ')               
                 FROM CSS_WQ_ITEMS WQ WITH(READUNCOMMITTED) LEFT JOIN           
                      CSS_ACCOUNT  AT WITH(READUNCOMMITTED)                     
                   ON AT.ACCOUNT_NO = WQ.ACCOUNT_NO                     
                WHERE WQ.RESP_AREA_ID = :WS-IN-RESP-AREA-ID             
                  AND WQ.STATUS  IN ( :WS-IN-STATUS1, :WS-IN-STATUS2    
                                     ,:WS-IN-STATUS3 )                  
                  AND WQ.DATE_REQUIRED BETWEEN                          
                                   CIS.CHAR2TIMESTAMP(
                                              :WS-IN-REQUIRED-DATE-FROM
              )            
                               AND CIS.CHAR2TIMESTAMP(
                                                :WS-IN-REQUIRED-DATE-BY
              )              
                  AND (WQ.CATEGORY_ID = :WS-IN-CATEGORY-ID              
                       OR :WS-IN-CATEGORY-ID = 0 )                      
                  AND (WQ.USER_ID_ORIG = :WS-IN-USER-ID-ORIG            
                       OR :WS-IN-USER-ID-ORIG = '       ')              
                  AND ((:WS-IN-COMPLETE-DATE-BY <> :WS-MIN-TMST         
                       AND WQ.COMPLETE_DATE BETWEEN                     
                       CIS.CHAR2TIMESTAMP(:WS-IN-COMPLETE-DATE-FROM)            
                       AND CIS.CHAR2TIMESTAMP(:WS-IN-COMPLETE-DATE-BY) )        
                     OR (:WS-IN-COMPLETE-DATE-BY = :WS-MIN-TMST ))      
                ORDER BY WQ.PRIORITY, DATE_CREATED DESC              
ACT118                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE WQ_CUR4 CURSOR WITH ROWSET POSITIONING FOR                
MFA-TR*         SELECT WQ.ITEM_ID                                               
MFA-TR*               ,WQ.DATE_CREATED                                          
MFA-TR*               ,WQ.ACCOUNT_NO                                            
MFA-TR*               ,COALESCE(AT.PREMISE_NO, WQ.PREMISE_NO)                   
MFA-TR*               ,COALESCE(AT.CUSTOMER_NO, WQ.CUSTOMER_NO)                 
MFA-TR*               ,WQ.STATUS                                                
MFA-TR*               ,WQ.USER_ID_ORIG                                          
MFA-TR*               ,WQ.USER_ID_ASGN                                          
MFA-TR*               ,WQ.RESP_AREA_ID                                          
MFA-TR*               ,WQ.COMPLETE_DATE                                         
MFA-TR*               ,WQ.CATEGORY_ID                                           
MFA-TR*               ,WQ.COMMENTS                                              
MFA-TR*               ,WQ.DATE_REQUIRED                                         
MFA-TR*               ,WQ.PRIORITY                                              
MFA-TR*               ,WQ.FREE_FORM_AREA                                        
MFA-TR*               ,WQ.WQ_ERROR_CD                                           
MFA-TR*               ,WQ.LAST_UPDATE_TS                                        
MFA-TR*               ,WQ.ASSGN_HIST_PRES_FL                                    
MFA-TR*               ,COALESCE(AT.BILL_CYCLE, '  ')                            
MFA-TR*               ,COALESCE(AT.MST_SUB_ACCT_IND, ' ')                       
MFA-TR*          FROM CSS_WQ_ITEMS WQ LEFT JOIN                                 
MFA-TR*               CSS_ACCOUNT  AT                                           
MFA-TR*            ON AT.ACCOUNT_NO = WQ.ACCOUNT_NO                             
MFA-TR*         WHERE WQ.RESP_AREA_ID = :WS-IN-RESP-AREA-ID                     
MFA-TR*           AND WQ.STATUS  IN ( :WS-IN-STATUS1, :WS-IN-STATUS2            
MFA-TR*                              ,:WS-IN-STATUS3 )                          
MFA-TR*           AND WQ.DATE_REQUIRED BETWEEN                                  
MFA-TR*                            :WS-IN-REQUIRED-DATE-FROM                    
MFA-TR*                        AND :WS-IN-REQUIRED-DATE-BY                      
MFA-TR*           AND (WQ.CATEGORY_ID = :WS-IN-CATEGORY-ID                      
MFA-TR*                OR :WS-IN-CATEGORY-ID = 0 )                              
MFA-TR*           AND (WQ.USER_ID_ORIG = :WS-IN-USER-ID-ORIG                    
MFA-TR*                OR :WS-IN-USER-ID-ORIG = '       ')                      
MFA-TR*           AND ((:WS-IN-COMPLETE-DATE-BY <> :WS-MIN-TMST                 
MFA-TR*                AND WQ.COMPLETE_DATE BETWEEN                             
MFA-TR*                :WS-IN-COMPLETE-DATE-FROM                                
MFA-TR*                AND :WS-IN-COMPLETE-DATE-BY )                            
MFA-TR*              OR (:WS-IN-COMPLETE-DATE-BY = :WS-MIN-TMST ))              
MFA-TR*         ORDER BY WQ.PRIORITY, WQ.DATE_CREATED DESC                      
MFA-TR*         FETCH FIRST 999 ROWS ONLY WITH UR                               
MFA-TR*       QUERYNO 7250                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CURSOR DECLARATION TO RETRIVE WORK QUEUE ITEMS WHEN                   
      *   CATEGORY ID PROVIDED IN SEARCH CRITERIA                               
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
A00509        DECLARE WQ_CUR5 CURSOR WITH ROWSET POSITIONING FOR        
                SELECT TOP(999) WQ.ITEM_ID,
              REPLACE(REPLACE(CONVERT(CHAR(26), WQ.DATE_CREATED, 121), 
           ' ', '-'), ':', '.') DATE_CREATED,
              WQ.ACCOUNT_NO,
              COALESCE(AT.PREMISE_NO, WQ.PREMISE_NO),
              COALESCE(AT.CUSTOMER_NO, WQ.CUSTOMER_NO),
              WQ.STATUS,
              WQ.USER_ID_ORIG,
              WQ.USER_ID_ASGN,
              WQ.RESP_AREA_ID,
              REPLACE(REPLACE(CONVERT(CHAR(26), WQ.COMPLETE_DATE, 121), 
           ' ', '-'), ':', '.') COMPLETE_DATE,
              WQ.CATEGORY_ID,
              WQ.COMMENTS,
              REPLACE(REPLACE(CONVERT(CHAR(26), WQ.DATE_REQUIRED, 121), 
           ' ', '-'), ':', '.') DATE_REQUIRED,
              WQ.PRIORITY,
              WQ.FREE_FORM_AREA,
              WQ.WQ_ERROR_CD,
              REPLACE(REPLACE(CONVERT(CHAR(26), WQ.LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS,
              WQ.ASSGN_HIST_PRES_FL,
              COALESCE(AT.BILL_CYCLE, '  '),
              COALESCE(AT.MST_SUB_ACCT_IND, ' ')               
                 FROM CSS_WQ_ITEMS WQ WITH(READUNCOMMITTED) LEFT JOIN           
                      CSS_ACCOUNT  AT WITH(READUNCOMMITTED)                     
                   ON AT.ACCOUNT_NO = WQ.ACCOUNT_NO                     
                WHERE WQ.CATEGORY_ID = :WS-IN-CATEGORY-ID               
                  AND WQ.STATUS  IN ( :WS-IN-STATUS1, :WS-IN-STATUS2    
                                     ,:WS-IN-STATUS3 )                  
                  AND WQ.DATE_REQUIRED BETWEEN                          
                                   CIS.CHAR2TIMESTAMP(
                                              :WS-IN-REQUIRED-DATE-FROM
              )            
                               AND CIS.CHAR2TIMESTAMP(
                                                :WS-IN-REQUIRED-DATE-BY
              )              
                  AND (WQ.USER_ID_ORIG = :WS-IN-USER-ID-ORIG            
                       OR :WS-IN-USER-ID-ORIG = '       ')              
                  AND ((:WS-IN-COMPLETE-DATE-BY <> :WS-MIN-TMST         
                       AND WQ.COMPLETE_DATE BETWEEN                     
                       CIS.CHAR2TIMESTAMP(:WS-IN-COMPLETE-DATE-FROM)            
                       AND CIS.CHAR2TIMESTAMP(:WS-IN-COMPLETE-DATE-BY) )        
                     OR (:WS-IN-COMPLETE-DATE-BY = :WS-MIN-TMST ))      
                ORDER BY WQ.PRIORITY, DATE_CREATED DESC              
ACT118                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE WQ_CUR5 CURSOR WITH ROWSET POSITIONING FOR                
MFA-TR*         SELECT WQ.ITEM_ID                                               
MFA-TR*               ,WQ.DATE_CREATED                                          
MFA-TR*               ,WQ.ACCOUNT_NO                                            
MFA-TR*               ,COALESCE(AT.PREMISE_NO, WQ.PREMISE_NO)                   
MFA-TR*               ,COALESCE(AT.CUSTOMER_NO, WQ.CUSTOMER_NO)                 
MFA-TR*               ,WQ.STATUS                                                
MFA-TR*               ,WQ.USER_ID_ORIG                                          
MFA-TR*               ,WQ.USER_ID_ASGN                                          
MFA-TR*               ,WQ.RESP_AREA_ID                                          
MFA-TR*               ,WQ.COMPLETE_DATE                                         
MFA-TR*               ,WQ.CATEGORY_ID                                           
MFA-TR*               ,WQ.COMMENTS                                              
MFA-TR*               ,WQ.DATE_REQUIRED                                         
MFA-TR*               ,WQ.PRIORITY                                              
MFA-TR*               ,WQ.FREE_FORM_AREA                                        
MFA-TR*               ,WQ.WQ_ERROR_CD                                           
MFA-TR*               ,WQ.LAST_UPDATE_TS                                        
MFA-TR*               ,WQ.ASSGN_HIST_PRES_FL                                    
MFA-TR*               ,COALESCE(AT.BILL_CYCLE, '  ')                            
MFA-TR*               ,COALESCE(AT.MST_SUB_ACCT_IND, ' ')                       
MFA-TR*          FROM CSS_WQ_ITEMS WQ LEFT JOIN                                 
MFA-TR*               CSS_ACCOUNT  AT                                           
MFA-TR*            ON AT.ACCOUNT_NO = WQ.ACCOUNT_NO                             
MFA-TR*         WHERE WQ.CATEGORY_ID = :WS-IN-CATEGORY-ID                       
MFA-TR*           AND WQ.STATUS  IN ( :WS-IN-STATUS1, :WS-IN-STATUS2            
MFA-TR*                              ,:WS-IN-STATUS3 )                          
MFA-TR*           AND WQ.DATE_REQUIRED BETWEEN                                  
MFA-TR*                            :WS-IN-REQUIRED-DATE-FROM                    
MFA-TR*                        AND :WS-IN-REQUIRED-DATE-BY                      
MFA-TR*           AND (WQ.USER_ID_ORIG = :WS-IN-USER-ID-ORIG                    
MFA-TR*                OR :WS-IN-USER-ID-ORIG = '       ')                      
MFA-TR*           AND ((:WS-IN-COMPLETE-DATE-BY <> :WS-MIN-TMST                 
MFA-TR*                AND WQ.COMPLETE_DATE BETWEEN                             
MFA-TR*                :WS-IN-COMPLETE-DATE-FROM                                
MFA-TR*                AND :WS-IN-COMPLETE-DATE-BY )                            
MFA-TR*              OR (:WS-IN-COMPLETE-DATE-BY = :WS-MIN-TMST ))              
MFA-TR*         ORDER BY WQ.PRIORITY, WQ.DATE_CREATED DESC                      
MFA-TR*         FETCH FIRST 999 ROWS ONLY WITH UR                               
MFA-TR*       QUERYNO 7300                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CURSOR DECLARATION TO RETRIVE WORK QUEUE ITEMS WHEN                   
      *   WQ STATUS PROVIDED IN SEARCH CRITERIA                                 
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
A00509        DECLARE WQ_CUR6 CURSOR WITH ROWSET POSITIONING FOR        
                SELECT TOP(999) WQ.ITEM_ID,
              REPLACE(REPLACE(CONVERT(CHAR(26), WQ.DATE_CREATED, 121), 
           ' ', '-'), ':', '.') DATE_CREATED,
              WQ.ACCOUNT_NO,
              COALESCE(AT.PREMISE_NO, WQ.PREMISE_NO),
              COALESCE(AT.CUSTOMER_NO, WQ.CUSTOMER_NO),
              WQ.STATUS,
              WQ.USER_ID_ORIG,
              WQ.USER_ID_ASGN,
              WQ.RESP_AREA_ID,
              REPLACE(REPLACE(CONVERT(CHAR(26), WQ.COMPLETE_DATE, 121), 
           ' ', '-'), ':', '.') COMPLETE_DATE,
              WQ.CATEGORY_ID,
              WQ.COMMENTS,
              REPLACE(REPLACE(CONVERT(CHAR(26), WQ.DATE_REQUIRED, 121), 
           ' ', '-'), ':', '.') DATE_REQUIRED,
              WQ.PRIORITY,
              WQ.FREE_FORM_AREA,
              WQ.WQ_ERROR_CD,
              REPLACE(REPLACE(CONVERT(CHAR(26), WQ.LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS,
              WQ.ASSGN_HIST_PRES_FL,
              COALESCE(AT.BILL_CYCLE, '  '),
              COALESCE(AT.MST_SUB_ACCT_IND, ' ')               
                 FROM CSS_WQ_ITEMS WQ WITH(READUNCOMMITTED) LEFT JOIN           
                      CSS_ACCOUNT  AT WITH(READUNCOMMITTED)                     
                   ON AT.ACCOUNT_NO = WQ.ACCOUNT_NO                     
                WHERE WQ.STATUS  IN ( :WS-IN-STATUS1, :WS-IN-STATUS2    
                                     ,:WS-IN-STATUS3 )                  
                  AND WQ.DATE_REQUIRED BETWEEN                          
                                   CIS.CHAR2TIMESTAMP(
                                              :WS-IN-REQUIRED-DATE-FROM
              )            
                               AND CIS.CHAR2TIMESTAMP(
                                                :WS-IN-REQUIRED-DATE-BY
              )              
                  AND (WQ.USER_ID_ORIG = :WS-IN-USER-ID-ORIG            
                       OR :WS-IN-USER-ID-ORIG = '       ')              
                  AND ((:WS-IN-COMPLETE-DATE-BY <> :WS-MIN-TMST         
                       AND WQ.COMPLETE_DATE BETWEEN                     
                       CIS.CHAR2TIMESTAMP(:WS-IN-COMPLETE-DATE-FROM)            
                       AND CIS.CHAR2TIMESTAMP(:WS-IN-COMPLETE-DATE-BY) )        
                     OR (:WS-IN-COMPLETE-DATE-BY = :WS-MIN-TMST ))      
                ORDER BY WQ.PRIORITY, DATE_CREATED DESC              
ACT118                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE WQ_CUR6 CURSOR WITH ROWSET POSITIONING FOR                
MFA-TR*         SELECT WQ.ITEM_ID                                               
MFA-TR*               ,WQ.DATE_CREATED                                          
MFA-TR*               ,WQ.ACCOUNT_NO                                            
MFA-TR*               ,COALESCE(AT.PREMISE_NO, WQ.PREMISE_NO)                   
MFA-TR*               ,COALESCE(AT.CUSTOMER_NO, WQ.CUSTOMER_NO)                 
MFA-TR*               ,WQ.STATUS                                                
MFA-TR*               ,WQ.USER_ID_ORIG                                          
MFA-TR*               ,WQ.USER_ID_ASGN                                          
MFA-TR*               ,WQ.RESP_AREA_ID                                          
MFA-TR*               ,WQ.COMPLETE_DATE                                         
MFA-TR*               ,WQ.CATEGORY_ID                                           
MFA-TR*               ,WQ.COMMENTS                                              
MFA-TR*               ,WQ.DATE_REQUIRED                                         
MFA-TR*               ,WQ.PRIORITY                                              
MFA-TR*               ,WQ.FREE_FORM_AREA                                        
MFA-TR*               ,WQ.WQ_ERROR_CD                                           
MFA-TR*               ,WQ.LAST_UPDATE_TS                                        
MFA-TR*               ,WQ.ASSGN_HIST_PRES_FL                                    
MFA-TR*               ,COALESCE(AT.BILL_CYCLE, '  ')                            
MFA-TR*               ,COALESCE(AT.MST_SUB_ACCT_IND, ' ')                       
MFA-TR*          FROM CSS_WQ_ITEMS WQ LEFT JOIN                                 
MFA-TR*               CSS_ACCOUNT  AT                                           
MFA-TR*            ON AT.ACCOUNT_NO = WQ.ACCOUNT_NO                             
MFA-TR*         WHERE WQ.STATUS  IN ( :WS-IN-STATUS1, :WS-IN-STATUS2            
MFA-TR*                              ,:WS-IN-STATUS3 )                          
MFA-TR*           AND WQ.DATE_REQUIRED BETWEEN                                  
MFA-TR*                            :WS-IN-REQUIRED-DATE-FROM                    
MFA-TR*                        AND :WS-IN-REQUIRED-DATE-BY                      
MFA-TR*           AND (WQ.USER_ID_ORIG = :WS-IN-USER-ID-ORIG                    
MFA-TR*                OR :WS-IN-USER-ID-ORIG = '       ')                      
MFA-TR*           AND ((:WS-IN-COMPLETE-DATE-BY <> :WS-MIN-TMST                 
MFA-TR*                AND WQ.COMPLETE_DATE BETWEEN                             
MFA-TR*                :WS-IN-COMPLETE-DATE-FROM                                
MFA-TR*                AND :WS-IN-COMPLETE-DATE-BY )                            
MFA-TR*              OR (:WS-IN-COMPLETE-DATE-BY = :WS-MIN-TMST ))              
MFA-TR*         ORDER BY WQ.PRIORITY, WQ.DATE_CREATED DESC                      
MFA-TR*         FETCH FIRST 999 ROWS ONLY WITH UR                               
MFA-TR*       QUERYNO 7350                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
                                                                        
       LINKAGE SECTION.                                                 
COB305 01 PARM-ITEM-ID        PIC S9(10)V USAGE COMP-3 VALUE 0.         
       01  PARM-CATEGORY-ID           PIC S9(04) USAGE COMP.            
       01  PARM-STATUS                PIC X(1).                         
       01  PARM-RESP-AREA-ID          PIC X(3).                         
       01  PARM-USER-ID-ASGN          PIC X(7).                         
       01  PARM-USER-ID-ORIG          PIC X(7).                         
       01  PARM-ACCOUNT-NO            PIC X(13).                        
       01  PARM-CUSTOMER-NO           PIC X(10).                        
       01  PARM-PREMISE-NO            PIC X(10).                        
       01  PARM-REQUIRED-DATE-BY      PIC X(26).                        
       01  PARM-REQUIRED-DATE-FROM    PIC X(26).                        
       01  PARM-COMPLETE-DATE-BY      PIC X(26).                        
       01  PARM-COMPLETE-DATE-FROM    PIC X(26).                        
                                                                        
       PROCEDURE DIVISION USING PARM-ITEM-ID                            
                                PARM-CATEGORY-ID                        
                                PARM-STATUS                             
                                PARM-RESP-AREA-ID                       
                                PARM-USER-ID-ASGN                       
                                PARM-USER-ID-ORIG                       
                                PARM-ACCOUNT-NO                         
                                PARM-CUSTOMER-NO                        
                                PARM-PREMISE-NO                         
                                PARM-REQUIRED-DATE-BY                   
                                PARM-REQUIRED-DATE-FROM                 
                                PARM-COMPLETE-DATE-BY                   
                                PARM-COMPLETE-DATE-FROM.                
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-VALIDATE-INPUT      THRU 0100-EXIT.             
           PERFORM 1000-PROCESS-INPUT       THRU 1000-EXIT.             
           PERFORM 9999-END-PROGRAM         THRU 9999-EXIT.             
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       0100-VALIDATE-INPUT.                                             
      *================================================================*        
                                                                        
           MOVE PARM-ITEM-ID                TO WS-IN-ITEM-ID            
           MOVE PARM-CATEGORY-ID            TO WS-IN-CATEGORY-ID        
           MOVE PARM-STATUS                 TO WS-IN-STATUS             
                                                                        
           EVALUATE TRUE                                                
              WHEN WS-IN-STATUS = '*'                                   
                 MOVE 'A'                   TO WS-IN-STATUS1            
                 MOVE 'I'                   TO WS-IN-STATUS2            
                                               WS-IN-STATUS3            
                                               WS-IN-STATUS4            
              WHEN WS-IN-STATUS > SPACES                                
                 MOVE WS-IN-STATUS          TO WS-IN-STATUS1            
                                               WS-IN-STATUS2            
                                               WS-IN-STATUS3            
                                               WS-IN-STATUS4            
              WHEN OTHER                                                
                 MOVE 'A'                   TO WS-IN-STATUS1            
                 MOVE 'I'                   TO WS-IN-STATUS2            
                 MOVE 'C'                   TO WS-IN-STATUS3            
                 MOVE 'D'                   TO WS-IN-STATUS4            
           END-EVALUATE.                                                
                                                                        
           MOVE PARM-RESP-AREA-ID           TO WS-IN-RESP-AREA-ID       
           MOVE PARM-USER-ID-ASGN           TO WS-IN-USER-ID-ASGN       
           MOVE PARM-USER-ID-ORIG           TO WS-IN-USER-ID-ORIG       
                                                                        
           IF PARM-CUSTOMER-NO IS NUMERIC                               
              MOVE PARM-CUSTOMER-NO         TO WS-CUSTOMER-NO           
              MOVE WS-CUSTOMER-NO           TO WS-IN-CUSTOMER-NO        
           ELSE                                                         
              MOVE ZEROS                    TO WS-IN-CUSTOMER-NO        
           END-IF.                                                      
                                                                        
           IF PARM-ACCOUNT-NO IS NUMERIC                                
              MOVE PARM-ACCOUNT-NO          TO WS-ACCOUNT-NO            
              MOVE WS-ACCOUNT-NO            TO WS-IN-ACCOUNT-NO         
           ELSE                                                         
              MOVE ZEROS                    TO WS-IN-ACCOUNT-NO         
           END-IF.                                                      
                                                                        
           IF PARM-PREMISE-NO IS NUMERIC                                
              MOVE PARM-PREMISE-NO          TO WS-PREMISE-NO            
              MOVE WS-PREMISE-NO            TO WS-IN-PREMISE-NO         
           ELSE                                                         
              MOVE ZEROS                    TO WS-IN-PREMISE-NO         
           END-IF.                                                      
                                                                        
           IF PARM-REQUIRED-DATE-FROM > SPACES                          
              MOVE PARM-REQUIRED-DATE-FROM  TO WS-IN-REQUIRED-DATE-FROM 
           ELSE                                                         
              MOVE WS-MIN-TMST              TO WS-IN-REQUIRED-DATE-FROM 
           END-IF.                                                      
                                                                        
           IF PARM-REQUIRED-DATE-BY   > SPACES                          
              MOVE PARM-REQUIRED-DATE-BY    TO WS-IN-REQUIRED-DATE-BY   
           ELSE                                                         
              MOVE WS-MAX-TMST              TO WS-IN-REQUIRED-DATE-BY   
           END-IF.                                                      
                                                                        
           IF PARM-COMPLETE-DATE-FROM > SPACES                          
              MOVE PARM-COMPLETE-DATE-FROM  TO WS-IN-COMPLETE-DATE-FROM 
           ELSE                                                         
              MOVE WS-MIN-TMST              TO WS-IN-COMPLETE-DATE-FROM 
           END-IF.                                                      
                                                                        
           IF PARM-COMPLETE-DATE-BY   > SPACES                          
              MOVE PARM-COMPLETE-DATE-BY    TO WS-IN-COMPLETE-DATE-BY   
           ELSE                                                         
              MOVE WS-MAX-TMST              TO WS-IN-COMPLETE-DATE-BY   
           END-IF.                                                      
                                                                        
           IF WS-IN-STATUS = 'C' OR WS-IN-STATUS = 'D'                  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-MIN-TMST              TO WS-IN-COMPLETE-DATE-BY   
           END-IF                                                       
                                                                        
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
                                                                        
           PERFORM 0100A-DECLARE-GTT           THRU 0100A-EXIT.         
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       0100A-DECLARE-GTT.                                               
      *================================================================*        
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04674_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04674_R1
              (                                                       
                    RETURN_CODE          INT                        
                   ,APPL_RETURN_CODE     INT                        
                   ,ITEM_ID              DECIMAL(10,0)                  
                   ,DATE_CREATED CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,ACCOUNT_NO           DECIMAL(13,0)                  
                   ,PREMISE_NO           DECIMAL(10,0)                  
                   ,CUSTOMER_NO          DECIMAL(10,0)                  
                   ,STATUS CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2             
                   ,USER_ID_ORIG CHAR(7)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,USER_ID_ASGN CHAR(7)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,RESP_AREA_ID CHAR(3)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,COMPLETE_DATE CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,CATEGORY_ID          SMALLINT                       
                   ,DATE_REQUIRED CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,PRIORITY CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2           
                   ,WQ_ERROR_CD CHAR(4)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,LAST_UPDATE_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,ADDRESS_LINE1 CHAR(55)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,ADDRESS_LINE2 CHAR(41)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,ZIP_CODE CHAR(5)  COLLATE LATIN1_GENERAL_100_BIN2           
                   ,PHONE_NO CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,FULL_NAME CHAR(70)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,LOCAL_OFFICE CHAR(3)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,BILL_CYCLE CHAR(2)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,MST_SUB_ACCT_IND CHAR(6)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,ASSIGN_HIST_IND CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,TASKS_COUNT          SMALLINT                       
                   ,COMMENTS VARCHAR(250)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                   
                   ,FREE_FORM_AREA VARCHAR(255)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                   
A00509             ,TOTAL_RECORDS        INT                        
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF SQLSTATE   = '42710'                                      
              PERFORM 8000A-DEL-GTT-ROWS    THRU 8000A-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100A'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE 'CSR04674_R1'         TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,ITEM_ID                                          
                      ,DATE_CREATED                                     
                      ,ACCOUNT_NO                                       
                      ,PREMISE_NO                                       
                      ,CUSTOMER_NO                                      
                      ,STATUS                                           
                      ,USER_ID_ORIG                                     
                      ,USER_ID_ASGN                                     
                      ,RESP_AREA_ID                                     
                      ,COMPLETE_DATE                                    
                      ,CATEGORY_ID                                      
                      ,DATE_REQUIRED                                    
                      ,PRIORITY                                         
                      ,WQ_ERROR_CD                                      
                      ,LAST_UPDATE_TS                                   
                      ,ADDRESS_LINE1                                    
                      ,ADDRESS_LINE2                                    
                      ,ZIP_CODE                                         
                      ,PHONE_NO                                         
                      ,FULL_NAME                                        
                      ,LOCAL_OFFICE                                     
                      ,BILL_CYCLE                                       
                      ,MST_SUB_ACCT_IND                                 
                      ,ASSIGN_HIST_IND                                  
                      ,TASKS_COUNT                                      
                      ,COMMENTS                                         
                      ,FREE_FORM_AREA                                   
A00509                ,TOTAL_RECORDS                                    
                  FROM #CSR04674_R1                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,ITEM_ID                                                  
MFA-TR*               ,DATE_CREATED                                             
MFA-TR*               ,ACCOUNT_NO                                               
MFA-TR*               ,PREMISE_NO                                               
MFA-TR*               ,CUSTOMER_NO                                              
MFA-TR*               ,STATUS                                                   
MFA-TR*               ,USER_ID_ORIG                                             
MFA-TR*               ,USER_ID_ASGN                                             
MFA-TR*               ,RESP_AREA_ID                                             
MFA-TR*               ,COMPLETE_DATE                                            
MFA-TR*               ,CATEGORY_ID                                              
MFA-TR*               ,DATE_REQUIRED                                            
MFA-TR*               ,PRIORITY                                                 
MFA-TR*               ,WQ_ERROR_CD                                              
MFA-TR*               ,LAST_UPDATE_TS                                           
MFA-TR*               ,ADDRESS_LINE1                                            
MFA-TR*               ,ADDRESS_LINE2                                            
MFA-TR*               ,ZIP_CODE                                                 
MFA-TR*               ,PHONE_NO                                                 
MFA-TR*               ,FULL_NAME                                                
MFA-TR*               ,LOCAL_OFFICE                                             
MFA-TR*               ,BILL_CYCLE                                               
MFA-TR*               ,MST_SUB_ACCT_IND                                         
MFA-TR*               ,ASSIGN_HIST_IND                                          
MFA-TR*               ,TASKS_COUNT                                              
MFA-TR*               ,COMMENTS                                                 
MFA-TR*               ,FREE_FORM_AREA                                           
MFA-TR*               ,TOTAL_RECORDS                                            
MFA-TR*           FROM SESSION.CSR04674_R1                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1000-PROCESS-INPUT.                                              
      *================================================================*        
                                                                        
           EVALUATE TRUE                                                
              WHEN WS-IN-ITEM-ID > 0                                    
                                                                        
                PERFORM 7050-OPEN-WQ-CURX1    THRU 7050-EXIT            
                PERFORM 7060-FETCH-WQ-CURX1   THRU 7060-EXIT            
                PERFORM 7070-CLOSE-WQ-CURX1   THRU 7070-EXIT            
A00509          MOVE WS-ROWS-COUNT            TO WS-TOT-ROWS-COUNT      
                                                                        
              WHEN WS-IN-ACCOUNT-NO > 0 AND WS-IN-PREMISE-NO = 0        
                   AND WS-IN-CUSTOMER-NO = 0                            
                PERFORM 7100-OPEN-WQ-CUR1     THRU 7100-EXIT            
                PERFORM 7110-FETCH-WQ-CUR1    THRU 7110-EXIT            
                PERFORM 7120-CLOSE-WQ-CUR1    THRU 7120-EXIT            
ACT118          IF WS-ROWS-COUNT = 999                                  
A00509             PERFORM 7125-MAX-COUNT-CUR1 THRU 7125-EXIT           
A00509          ELSE                                                    
A00509             MOVE WS-ROWS-COUNT         TO WS-TOT-ROWS-COUNT      
A00509          END-IF                                                  
                                                                        
              WHEN WS-IN-PREMISE-NO > 0 OR WS-IN-CUSTOMER-NO > 0        
                PERFORM 7150-OPEN-WQ-CUR2     THRU 7150-EXIT            
                PERFORM 7160-FETCH-WQ-CUR2    THRU 7160-EXIT            
                PERFORM 7170-CLOSE-WQ-CUR2    THRU 7170-EXIT            
ACT118          IF WS-ROWS-COUNT = 999                                  
A00509             PERFORM 7175-MAX-COUNT-CUR2 THRU 7175-EXIT           
A00509          ELSE                                                    
A00509             MOVE WS-ROWS-COUNT         TO WS-TOT-ROWS-COUNT      
A00509          END-IF                                                  
                                                                        
              WHEN WS-IN-USER-ID-ASGN > SPACES                          
                PERFORM 7200-OPEN-WQ-CUR3     THRU 7200-EXIT            
                PERFORM 7210-FETCH-WQ-CUR3    THRU 7210-EXIT            
                PERFORM 7220-CLOSE-WQ-CUR3    THRU 7220-EXIT            
ACT118          IF WS-ROWS-COUNT = 999                                  
A00509             PERFORM 7225-MAX-COUNT-CUR3 THRU 7225-EXIT           
A00509          ELSE                                                    
A00509             MOVE WS-ROWS-COUNT         TO WS-TOT-ROWS-COUNT      
A00509          END-IF                                                  
                                                                        
              WHEN WS-IN-RESP-AREA-ID > SPACES                          
                PERFORM 7250-OPEN-WQ-CUR4     THRU 7250-EXIT            
                PERFORM 7260-FETCH-WQ-CUR4    THRU 7260-EXIT            
                PERFORM 7270-CLOSE-WQ-CUR4    THRU 7270-EXIT            
ACT118          IF WS-ROWS-COUNT = 999                                  
A00509             PERFORM 7275-MAX-COUNT-CUR4 THRU 7275-EXIT           
A00509          ELSE                                                    
A00509             MOVE WS-ROWS-COUNT         TO WS-TOT-ROWS-COUNT      
A00509          END-IF                                                  
                                                                        
              WHEN WS-IN-CATEGORY-ID > ZEROS                            
                PERFORM 7300-OPEN-WQ-CUR5     THRU 7300-EXIT            
                PERFORM 7310-FETCH-WQ-CUR5    THRU 7310-EXIT            
                PERFORM 7320-CLOSE-WQ-CUR5    THRU 7320-EXIT            
ACT118          IF WS-ROWS-COUNT = 999                                  
A00509             PERFORM 7325-MAX-COUNT-CUR5 THRU 7325-EXIT           
A00509          ELSE                                                    
A00509             MOVE WS-ROWS-COUNT         TO WS-TOT-ROWS-COUNT      
A00509          END-IF                                                  
                                                                        
              WHEN WS-IN-STATUS > SPACES                                
                PERFORM 7350-OPEN-WQ-CUR6     THRU 7350-EXIT            
                PERFORM 7360-FETCH-WQ-CUR6    THRU 7360-EXIT            
                PERFORM 7370-CLOSE-WQ-CUR6    THRU 7370-EXIT            
ACT118          IF WS-ROWS-COUNT = 999                                  
A00509             PERFORM 7375-MAX-COUNT-CUR6 THRU 7375-EXIT           
A00509          ELSE                                                    
A00509             MOVE WS-ROWS-COUNT         TO WS-TOT-ROWS-COUNT      
A00509          END-IF                                                  
                                                                        
              WHEN OTHER                                                
                INITIALIZE GTT-RETURN-FIELDS                            
                MOVE 900                      TO S-APPL-RETURN-CODE     
                PERFORM 8100-SEND-RESULT      THRU 8100-EXIT            
                                                                        
           END-EVALUATE.                                                
                                                                        
A00509     IF WS-ROWS-COUNT > ZERO                                      
A00509          PERFORM 3000-PROCESS-OUTPUT   THRU 3000-EXIT VARYING    
A00509            WS-SUB FROM 1 BY 1 UNTIL WS-SUB > WS-ROWS-COUNT       
A00509     END-IF.                                                      
                                                                        
           IF CTR-ROWS <= 0                                             
              INITIALIZE GTT-RETURN-FIELDS                              
              MOVE 100                      TO S-APPL-RETURN-CODE       
              PERFORM 8100-SEND-RESULT      THRU 8100-EXIT              
           END-IF.                                                      
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                *        
      *================================================================*        
       3000-PROCESS-OUTPUT.                                             
      *================================================================*        
                                                                        
           MOVE ZEROS                       TO S-RETURN-CODE            
                                               S-APPL-RETURN-CODE       
A00509     MOVE WS-WQ-ITEM-ID(WS-SUB)       TO S-ITEM-ID                
A00509     MOVE WS-WQ-ACCOUNT-NO(WS-SUB)    TO S-ACCOUNT-NO             
                                                                        
A00509     IF WS-WQ-ACCOUNT-NO(WS-SUB) > 0                              
A00509        MOVE WS-WQ-ACCOUNT-NO(WS-SUB) TO WQ-ACCOUNT-NO            
              PERFORM 7000-GET-TASKS-COUNT  THRU 7000-EXIT              
              MOVE WS-TASKS-COUNT           TO S-TASKS-COUNT            
A00509        MOVE WS-AT-BILL-CYCLE(WS-SUB) TO S-BILL-CYCLE             
              EVALUATE TRUE                                             
A00509           WHEN WS-AT-MST-SUB-ACCT-IND(WS-SUB) = 'M'              
                      MOVE 'MASTER'         TO S-MST-SUB-ACCT-IND       
A00509           WHEN WS-AT-MST-SUB-ACCT-IND(WS-SUB) = 'S'              
                      MOVE 'SUB   '         TO S-MST-SUB-ACCT-IND       
                 WHEN OTHER                                             
                      MOVE 'NORMAL'         TO S-MST-SUB-ACCT-IND       
              END-EVALUATE                                              
           ELSE                                                         
              MOVE SPACES                   TO S-BILL-CYCLE             
              MOVE 'N/A'                    TO S-MST-SUB-ACCT-IND       
              MOVE ZEROS                    TO S-TASKS-COUNT            
           END-IF.                                                      
      **   MOVE PR-LOCAL-OFFICE             TO S-LOCAL-OFFICE                   
                                                                        
A00509     MOVE WS-WQ-PREMISE-NO(WS-SUB)    TO S-PREMISE-NO             
                                                                        
A00509     IF WS-WQ-PREMISE-NO(WS-SUB) > 0                              
A00509        MOVE WS-WQ-PREMISE-NO(WS-SUB) TO   PR-PREMISE-NO          
              PERFORM 7010-SELECT-PREMISE   THRU 7010-EXIT              
              MOVE PR-LOCAL-OFFICE          TO S-LOCAL-OFFICE           
           ELSE                                                         
              MOVE ZEROS                    TO PR-ADDRESS-ID            
              MOVE SPACES                   TO S-LOCAL-OFFICE           
           END-IF.                                                      
                                                                        
A00509     MOVE WS-WQ-CUSTOMER-NO(WS-SUB)   TO S-CUSTOMER-NO            
A00509     MOVE WS-WQ-DATE-CREATED(WS-SUB)  TO S-DATE-CREATED           
A00509     IF WS-WQ-NULL-IND-01(WS-SUB) < 0                             
A00509        MOVE SPACES                   TO S-COMPLETE-DATE          
A00509     ELSE                                                         
A00509        MOVE WS-WQ-COMPLETE-DATE(WS-SUB) TO S-COMPLETE-DATE       
A00509     END-IF                                                       
A00509     IF WS-WQ-ASSGN-HIST-PRES-FL(WS-SUB) = 'Y'                    
              MOVE 'Y'                      TO S-ASSIGN-HIST-IND        
           ELSE                                                         
              MOVE 'N'                      TO S-ASSIGN-HIST-IND        
           END-IF                                                       
                                                                        
A00509     MOVE WS-WQ-COMMENTS(WS-SUB)      TO S-COMMENTS               
           INSPECT S-COMMENTS-TEXT REPLACING ALL LOW-VALUES BY SPACES.  
A00509     MOVE WS-WQ-FREE-FORM-AREA(WS-SUB)   TO S-FREE-FORM-AREA      
                                                                        
A00509     IF WS-WQ-PRIORITY(WS-SUB) = SPACES                           
              MOVE 'N'                      TO S-PRIORITY               
           ELSE                                                         
A00509        MOVE WS-WQ-PRIORITY(WS-SUB)   TO S-PRIORITY               
           END-IF                                                       
                                                                        
A00509     IF WS-WQ-NULL-IND-02(WS-SUB) < 0                             
A00509        MOVE SPACES                   TO S-DATE-REQUIRED          
A00509     ELSE                                                         
A00509        MOVE WS-WQ-DATE-REQUIRED(WS-SUB) TO S-DATE-REQUIRED       
A00509     END-IF                                                       
A00509     MOVE WS-WQ-STATUS(WS-SUB)           TO S-STATUS              
A00509     MOVE WS-WQ-USER-ID-ORIG(WS-SUB)     TO S-USER-ID-ORIG        
A00509     MOVE WS-WQ-USER-ID-ASGN(WS-SUB)     TO S-USER-ID-ASGN        
A00509     MOVE WS-WQ-CATEGORY-ID(WS-SUB)      TO S-CATEGORY-ID         
A00509     MOVE WS-WQ-RESP-AREA-ID(WS-SUB)     TO S-RESP-AREA-ID        
A00509     MOVE WS-WQ-LAST-UPDATE-TS(WS-SUB) TO S-LAST-UPDATE-TS        
A00509     IF WS-WQ-ERROR-CD(WS-SUB) = 'B'                              
              MOVE 'BILL'                   TO S-WQ-ERROR-CD            
           ELSE                                                         
              MOVE 'NONE'                   TO S-WQ-ERROR-CD            
           END-IF                                                       
                                                                        
A00509     IF WS-WQ-CUSTOMER-NO(WS-SUB) > 0                             
A00509        MOVE    WS-WQ-CUSTOMER-NO(WS-SUB) TO WQ-CUSTOMER-NO       
              PERFORM 3100-GET-CUSTOMER-NAME THRU 3100-EXIT             
           ELSE                                                         
              MOVE SPACES                     TO S-FULL-NAME            
                                                 S-PHONE-NO             
           END-IF                                                       
                                                                        
           IF PR-ADDRESS-ID > 0                                         
              PERFORM 7030-SELECT-ADDR-FORMATTED THRU 7030-EXIT         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 PERFORM 3200-FORMAT-ADDRESS  THRU 3200-EXIT            
              ELSE                                                      
                 MOVE SPACES                  TO S-ADDRESS-LINE1        
                                                 S-ADDRESS-LINE2        
              END-IF                                                    
           ELSE                                                         
              MOVE SPACES                     TO S-ADDRESS-LINE1        
                                                 S-ADDRESS-LINE2        
           END-IF                                                       
                                                                        
A00509     MOVE WS-TOT-ROWS-COUNT             TO S-TOTAL-RECORDS        
                                                                        
           PERFORM 8100-SEND-RESULT             THRU 8100-EXIT.         
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
                                                                        
       3000-EXIT.                                                       
           EXIT.                                                        
      *                                                                *        
      *================================================================*        
       3100-GET-CUSTOMER-NAME.                                          
      *================================================================*        
                                                                        
           PERFORM 7020-SELECT-NAME-PHONE THRU 7020-EXIT                
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF DQ-NAME-FORMAT = 'I'                                   
                 MOVE CB-PHONE-NO             TO S-PHONE-NO             
                 MOVE DQ-LAST-NAME            TO WS-LAST-NAME           
                 MOVE DQ-FIRST-NAME           TO WS-FIRST-NAME          
                 MOVE DQ-MIDDLE-NAME (1:1)    TO WS-MIDDLE-NAME-INI     
                 MOVE SPACES                  TO S-FULL-NAME            
                                                                        
                 STRING WS-LAST-NAME-SUFF  DELIMITED BY '    '          
                        ', '               DELIMITED BY SIZE            
                        WS-FIRST-NAME-SUFF DELIMITED BY '    '          
                        ' '                DELIMITED BY SIZE            
                        WS-MIDDLE-NAME-INI DELIMITED BY SIZE            
                   INTO S-FULL-NAME                                     
                                                                        
              ELSE                                                      
                 MOVE DQ-FULL-NAME            TO S-FULL-NAME            
              END-IF                                                    
           ELSE                                                         
              MOVE SPACES                     TO S-FULL-NAME            
                                                 S-PHONE-NO             
           END-IF.                                                      
                                                                        
       3100-EXIT.                                                       
           EXIT.                                                        
      *                                                                *        
      *================================================================*        
       3200-FORMAT-ADDRESS.                                             
      *================================================================*        
                                                                        
           MOVE SPACES                        TO WS-IN-STRING           
                                                 WS-OUT-STRING          
           MOVE DY-HOUSE-NO                   TO WS-HOUSE-NO            
           MOVE DY-ADDR-PREFIX-1              TO WS-ADDR-PREFIX-1       
           MOVE DY-ADDR-PREFIX-2              TO WS-ADDR-PREFIX-2       
           MOVE DY-STREET-NAME                TO WS-NAME-STREET         
           MOVE DY-STREET-SUFFIX              TO WS-STREET-SUFFIX       
           MOVE DY-STREET-LOCATION-1          TO WS-STREET-LOCATION-1   
           MOVE DY-STREET-LOCATION-2          TO WS-STREET-LOCATION-2   
           MOVE DY-ADDR-SUFFIX                TO WS-ADDRESS-SUFFIX      
           MOVE WS-STREET-ADDRESS             TO WS-IN-STRING           
           MOVE 82                            TO WS-CHAR-LENGTH         
           PERFORM 3210-REDUCE-EMBED-SPACES THRU 3210-EXIT              
           MOVE WS-OUT-STRING                 TO S-ADDRESS-LINE1        
                                                                        
      *** FORMAT ADDRESS LINE 2                                         00055700
           MOVE SPACES                        TO WS-IN-STRING           
                                                 WS-OUT-STRING          
           MOVE DY-ZIP-CODE                   TO A4-ZIP-CODE            
                                                 WS-ZIP-CODE            
                                                 S-ZIP-CODE             
           MOVE DY-ZIP-CODE-TOKEN             TO A4-ZIP-CODE-TOKEN      
           IF DY-ZIP-CODE-PLUS-FOUR > SPACES                            
              MOVE '-'                        TO WS-ZIP-DASH            
              MOVE DY-ZIP-CODE-PLUS-FOUR      TO WS-ZIP-PLUS-4          
           END-IF.                                                      
           MOVE ' *'                          TO WS-ZIP-FILLER          
                                                                        
           PERFORM 7040-SELECT-ZIP-CODE       THRU 7040-EXIT.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              MOVE SPACES                     TO WS-STATE               
              MOVE 'UNKNOWN *'                TO WS-CITY                
           ELSE                                                         
              MOVE A4-STATE                   TO WS-STATE               
              MOVE A4-TOWN                    TO WS-CITY                
           END-IF.                                                      
                                                                        
           MOVE WS-CITY-STATE                 TO WS-IN-STRING           
           MOVE 41                            TO WS-CHAR-LENGTH         
           PERFORM 3210-REDUCE-EMBED-SPACES THRU 3210-EXIT              
           MOVE WS-OUT-STRING                 TO S-ADDRESS-LINE2        
                                                                        
           INSPECT S-ADDRESS-LINE2    REPLACING ALL '*' BY SPACES.      
                                                                        
       3200-EXIT.                                                       
           EXIT.                                                        
      *                                                                *        
      *                                                                *        
      *================================================================*        
       3210-REDUCE-EMBED-SPACES.                                        
      *================================================================*        
                                                                        
           SET WS-OUT-INDX                    TO 1                      
           MOVE SPACES                        TO WS-LAST-CHAR           
                                                                        
           PERFORM VARYING WS-IN-INDX FROM 1 BY 1                       
                                UNTIL WS-IN-INDX > WS-CHAR-LENGTH       
              EVALUATE TRUE                                             
                 WHEN WS-IN-CHAR (WS-IN-INDX) = LOW-VALUES              
                      CONTINUE                                          
                 WHEN WS-IN-CHAR (WS-IN-INDX) = SPACES                  
                      AND WS-LAST-CHAR = SPACES                         
                      CONTINUE                                          
                 WHEN OTHER                                             
                      MOVE WS-IN-CHAR (WS-IN-INDX) TO WS-LAST-CHAR      
                           WS-OUT-CHAR (WS-OUT-INDX)                    
                      SET WS-OUT-INDX UP BY 1                           
              END-EVALUATE                                              
           END-PERFORM.                                                 
                                                                        
      *                                                                         
       3210-EXIT.                                                       
           EXIT.                                                        
      *                                                                *        
                                                                        
      *================================================================*        
       7000-GET-TASKS-COUNT.                                            
      *================================================================*        
                                                                        
                                                                        
           EXEC SQL                                                     
             SELECT COUNT(*)                                            
               INTO :WS-TASKS-COUNT                                     
               FROM CSS_WQ_ITEMS WITH(READUNCOMMITTED)                          
              WHERE ACCOUNT_NO = :WQ-ACCOUNT-NO                         
                AND STATUS     IN ('A', 'I')                            
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT COUNT(*)                                                    
MFA-TR*        INTO :WS-TASKS-COUNT                                             
MFA-TR*        FROM CSS_WQ_ITEMS                                                
MFA-TR*       WHERE ACCOUNT_NO = :WQ-ACCOUNT-NO                                 
MFA-TR*         AND STATUS     IN ('A', 'I')                                    
MFA-TR*        WITH UR                                                          
MFA-TR*     QUERYNO 7000                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           EVALUATE TRUE                                                
           WHEN WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
              CONTINUE                                                  
           WHEN WS-ACTIVE-RETURN-CODE = NOT-FOUND                       
              MOVE ZEROS                 TO WS-TASKS-COUNT              
           WHEN OTHER                                                   
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7000'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_WQ_ITEMS'        TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE WQ-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-EVALUATE.                                                
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                *        
      *================================================================*        
       7010-SELECT-PREMISE.                                             
      *================================================================*        
                                                                        
           EXEC SQL                                                     
             SELECT LOCAL_OFFICE                                        
                   ,ADDRESS_ID                                          
               INTO :PR-LOCAL-OFFICE                                    
                   ,:PR-ADDRESS-ID                                      
               FROM CSS_PREMISE WITH(READUNCOMMITTED)                           
              WHERE PREMISE_NO = :PR-PREMISE-NO                         
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT LOCAL_OFFICE                                                
MFA-TR*            ,ADDRESS_ID                                                  
MFA-TR*        INTO :PR-LOCAL-OFFICE                                            
MFA-TR*            ,:PR-ADDRESS-ID                                              
MFA-TR*        FROM CSS_PREMISE                                                 
MFA-TR*       WHERE PREMISE_NO = :PR-PREMISE-NO                                 
MFA-TR*        WITH UR                                                          
MFA-TR*     QUERYNO 7010                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           EVALUATE TRUE                                                
           WHEN WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
              CONTINUE                                                  
           WHEN WS-ACTIVE-RETURN-CODE = NOT-FOUND                       
              MOVE SPACES                TO PR-LOCAL-OFFICE             
              MOVE ZEROS                 TO PR-ADDRESS-ID               
           WHEN OTHER                                                   
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7010'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE WQ-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-EVALUATE.                                                
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                *        
      *================================================================*        
       7020-SELECT-NAME-PHONE.                                          
      *================================================================*        
                                                                        
           EXEC SQL                                                     
             SELECT COALESCE(DQ.NAME_FORMAT, ' ')                         
                   ,COALESCE(DQ.FIRST_NAME, ' ')                          
                   ,COALESCE(DQ.LAST_NAME, ' ')                           
                   ,COALESCE(DQ.MIDDLE_NAME, ' ')                         
                   ,COALESCE(DQ.FULL_NAME, ' ')                           
                   ,COALESCE(CB.PHONE_NO, ' ')                            
               INTO :DQ-NAME-FORMAT                                     
                   ,:DQ-FIRST-NAME                                      
                   ,:DQ-LAST-NAME                                       
                   ,:DQ-MIDDLE-NAME                                     
                   ,:DQ-FULL-NAME                                       
                   ,:CB-PHONE-NO                                        
               FROM CSS_CUSTOMER CU WITH(READUNCOMMITTED)                       
               LEFT JOIN CSS_NAME     DQ WITH(READUNCOMMITTED)                  
                 ON (CU.NAME_ID = DQ.NAME_ID                            
                     AND DQ.NAME_FORMAT IN ('I','B')                    
                     AND DQ.NAME_TYPE = 'CN')                           
               LEFT JOIN CSS_CUST_PHONE CB WITH(READUNCOMMITTED)                
                 ON (CU.CUSTOMER_NO = CB.CUSTOMER_NO                    
                     AND CB.PHONE_TYPE = 'H1'                           
                     AND CB.CUSTOMER_TYPE = 'C')                        
              WHERE CU.CUSTOMER_NO = :WQ-CUSTOMER-NO                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT IFNULL(DQ.NAME_FORMAT, ' ')                                 
MFA-TR*            ,IFNULL(DQ.FIRST_NAME, ' ')                                  
MFA-TR*            ,IFNULL(DQ.LAST_NAME, ' ')                                   
MFA-TR*            ,IFNULL(DQ.MIDDLE_NAME, ' ')                                 
MFA-TR*            ,IFNULL(DQ.FULL_NAME, ' ')                                   
MFA-TR*            ,IFNULL(CB.PHONE_NO, ' ')                                    
MFA-TR*        INTO :DQ-NAME-FORMAT                                             
MFA-TR*            ,:DQ-FIRST-NAME                                              
MFA-TR*            ,:DQ-LAST-NAME                                               
MFA-TR*            ,:DQ-MIDDLE-NAME                                             
MFA-TR*            ,:DQ-FULL-NAME                                               
MFA-TR*            ,:CB-PHONE-NO                                                
MFA-TR*        FROM CSS_CUSTOMER CU                                             
MFA-TR*        LEFT JOIN CSS_NAME     DQ                                        
MFA-TR*          ON (CU.NAME_ID = DQ.NAME_ID                                    
MFA-TR*              AND DQ.NAME_FORMAT IN ('I','B')                            
MFA-TR*              AND DQ.NAME_TYPE = 'CN')                                   
MFA-TR*        LEFT JOIN CSS_CUST_PHONE CB                                      
MFA-TR*          ON (CU.CUSTOMER_NO = CB.CUSTOMER_NO                            
MFA-TR*              AND CB.PHONE_TYPE = 'H1'                                   
MFA-TR*              AND CB.CUSTOMER_TYPE = 'C')                                
MFA-TR*       WHERE CU.CUSTOMER_NO = :WQ-CUSTOMER-NO                            
MFA-TR*        WITH UR                                                          
MFA-TR*     QUERYNO 7020                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7020'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE WQ-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                *        
      *================================================================*        
       7030-SELECT-ADDR-FORMATTED.                                      
      *================================================================*        
                                                                        
           EXEC SQL                                                     
             SELECT                                                     
                   HOUSE_NO                                             
                  ,ADDR_PREFIX_1                                        
                  ,ADDR_PREFIX_2                                        
                  ,STREET_NAME                                          
                  ,STREET_LOCATION_1                                    
                  ,STREET_LOCATION_2                                    
                  ,STREET_SUFFIX                                        
                  ,ADDRESS_OVERFLOW                                     
                  ,CARRIER_ROUTE                                        
                  ,ZIP_CODE                                             
                  ,ZIP_CODE_PLUS_FOUR                                   
                  ,ZIP_CODE_TOKEN                                       
                  ,ADDR_SUFFIX                                          
              INTO :DY-HOUSE-NO                                         
                  ,:DY-ADDR-PREFIX-1                                    
                  ,:DY-ADDR-PREFIX-2                                    
                  ,:DY-STREET-NAME                                      
                  ,:DY-STREET-LOCATION-1                                
                  ,:DY-STREET-LOCATION-2                                
                  ,:DY-STREET-SUFFIX                                    
                  ,:DY-ADDRESS-OVERFLOW                                 
                  ,:DY-CARRIER-ROUTE                                    
                  ,:DY-ZIP-CODE                                         
                  ,:DY-ZIP-CODE-PLUS-FOUR                               
                  ,:DY-ZIP-CODE-TOKEN                                   
                  ,:DY-ADDR-SUFFIX                                      
              FROM CSS_ADDR_FORMATTED WITH(READUNCOMMITTED)                     
             WHERE ADDRESS_ID = :PR-ADDRESS-ID                          
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT                                                     00078400
MFA-TR*            HOUSE_NO                                                 0007
MFA-TR*           ,ADDR_PREFIX_1                                            0007
MFA-TR*           ,ADDR_PREFIX_2                                            0007
MFA-TR*           ,STREET_NAME                                              0007
MFA-TR*           ,STREET_LOCATION_1                                        0007
MFA-TR*           ,STREET_LOCATION_2                                        0007
MFA-TR*           ,STREET_SUFFIX                                            0007
MFA-TR*           ,ADDRESS_OVERFLOW                                         0007
MFA-TR*           ,CARRIER_ROUTE                                            0007
MFA-TR*           ,ZIP_CODE                                                 0007
MFA-TR*           ,ZIP_CODE_PLUS_FOUR                                       0007
MFA-TR*           ,ZIP_CODE_TOKEN                                           0007
MFA-TR*           ,ADDR_SUFFIX                                              0007
MFA-TR*       INTO :DY-HOUSE-NO                                         00079800
MFA-TR*           ,:DY-ADDR-PREFIX-1                                    00079900
MFA-TR*           ,:DY-ADDR-PREFIX-2                                    00080000
MFA-TR*           ,:DY-STREET-NAME                                      00080100
MFA-TR*           ,:DY-STREET-LOCATION-1                                00080200
MFA-TR*           ,:DY-STREET-LOCATION-2                                00080300
MFA-TR*           ,:DY-STREET-SUFFIX                                    00080400
MFA-TR*           ,:DY-ADDRESS-OVERFLOW                                 00080500
MFA-TR*           ,:DY-CARRIER-ROUTE                                    00080600
MFA-TR*           ,:DY-ZIP-CODE                                         00080700
MFA-TR*           ,:DY-ZIP-CODE-PLUS-FOUR                               00080800
MFA-TR*           ,:DY-ZIP-CODE-TOKEN                                   00080900
MFA-TR*           ,:DY-ADDR-SUFFIX                                      00081000
MFA-TR*       FROM CSS_ADDR_FORMATTED                                   00081100
MFA-TR*      WHERE ADDRESS_ID = :PR-ADDRESS-ID                          00081200
MFA-TR*       WITH UR                                                           
MFA-TR*    QUERYNO 7030                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7030'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE WQ-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
      *                                                                *        
      *================================================================*        
       7040-SELECT-ZIP-CODE.                                            
      *================================================================*        
                                                                        
           EXEC SQL                                                     
             SELECT TOWN                                                
                   ,STATE                                               
               INTO :A4-TOWN                                            
                   ,:A4-STATE                                           
               FROM CSS_ZIP_CODE WITH(READUNCOMMITTED)                          
              WHERE ZIP_CODE = :A4-ZIP-CODE AND                         
                    ZIP_CODE_TOKEN = :A4-ZIP-CODE-TOKEN                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT TOWN                                                00088400
MFA-TR*            ,STATE                                               00088600
MFA-TR*        INTO :A4-TOWN                                            00088700
MFA-TR*            ,:A4-STATE                                           00088800
MFA-TR*        FROM CSS_ZIP_CODE                                        00088900
MFA-TR*       WHERE ZIP_CODE = :A4-ZIP-CODE AND                         00089000
MFA-TR*             ZIP_CODE_TOKEN = :A4-ZIP-CODE-TOKEN                 00089100
MFA-TR*        WITH UR                                                          
MFA-TR*     QUERYNO 7040                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7040'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE WQ-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7040-EXIT.                                                       
           EXIT.                                                        
      *                                                                *        
      *================================================================*        
       7050-OPEN-WQ-CURX1.                                              
      *================================================================*        
                                                                        
                                                                        
           EXEC SQL                                                     
                OPEN WQ_CURX1                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7050'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_WQ_ITEMS'             TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'CUSTOMER_NO'              TO TABLE-ELEMENT-2        
              MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-3        
              MOVE 'STATUS'                   TO TABLE-ELEMENT-4        
              MOVE WQ-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE WQ-CUSTOMER-NO             TO HOSTVAR-ELEMENT-2      
              MOVE WQ-PREMISE-NO              TO HOSTVAR-ELEMENT-3      
              MOVE WS-IN-STATUS               TO HOSTVAR-ELEMENT-4      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                *        
      *================================================================*        
       7060-FETCH-WQ-CURX1.                                             
      *================================================================*        
                                                                        
           EXEC SQL                                                     
A00509         FETCH WQ_CURX1                                           
A00509          INTO :WS-WQ-ITEM-ID                                     
A00509              ,:WS-WQ-DATE-CREATED                                
A00509              ,:WS-WQ-ACCOUNT-NO                                  
A00509              ,:WS-WQ-PREMISE-NO                                  
A00509              ,:WS-WQ-CUSTOMER-NO                                 
A00509              ,:WS-WQ-STATUS                                      
A00509              ,:WS-WQ-USER-ID-ORIG                                
A00509              ,:WS-WQ-USER-ID-ASGN                                
A00509              ,:WS-WQ-RESP-AREA-ID                                
A00509              ,:WS-WQ-COMPLETE-DATE :WS-WQ-NULL-IND-01             
A00509              ,:WS-WQ-CATEGORY-ID                                 
A00509              ,:WS-WQ-COMMENTS                                    
A00509              ,:WS-WQ-DATE-REQUIRED :WS-WQ-NULL-IND-02             
A00509              ,:WS-WQ-PRIORITY                                    
A00509              ,:WS-WQ-FREE-FORM-AREA                              
A00509              ,:WS-WQ-ERROR-CD                                    
A00509              ,:WS-WQ-LAST-UPDATE-TS                              
A00509              ,:WS-WQ-ASSGN-HIST-PRES-FL                          
A00509              ,:WS-AT-BILL-CYCLE                                  
A00509              ,:WS-AT-MST-SUB-ACCT-IND                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
A00509          MOVE 1                        to WS-ROWS-COUNT          
A00509        WHEN NOT-FOUND                                            
A00509          MOVE zero                     to WS-ROWS-COUNT          
              WHEN OTHER                                                
                 MOVE PROGRAM-NAME            TO ABEND-PROGRAM          
                 MOVE '7060'                  TO ACTIVE-PARAGRAPH       
                 MOVE 'FETCH'                 TO ABEND-FUNCTION         
                 MOVE SPACES                  TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
                 MOVE 'CSS_WQ_ITEMS'          TO TABLE-1                
                 MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1        
                 MOVE 'CUSTOMER_NO'           TO TABLE-ELEMENT-2        
                 MOVE 'PREMISE_NO'            TO TABLE-ELEMENT-3        
                 MOVE 'STATUS'                TO TABLE-ELEMENT-4        
                 MOVE WQ-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1      
                 MOVE WQ-CUSTOMER-NO          TO HOSTVAR-ELEMENT-2      
                 MOVE WQ-PREMISE-NO           TO HOSTVAR-ELEMENT-3      
                 MOVE WS-IN-STATUS            TO HOSTVAR-ELEMENT-4      
                 PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7060-EXIT.                                                       
           EXIT.                                                        
      *                                                                *        
      *================================================================*        
       7070-CLOSE-WQ-CURX1.                                             
      *================================================================*        
                                                                        
           EXEC SQL                                                     
                CLOSE WQ_CURX1                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7070'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_WQ_ITEMS'             TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'CUSTOMER_NO'              TO TABLE-ELEMENT-2        
              MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-3        
              MOVE 'STATUS'                   TO TABLE-ELEMENT-4        
              MOVE WQ-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE WQ-CUSTOMER-NO             TO HOSTVAR-ELEMENT-2      
              MOVE WQ-PREMISE-NO              TO HOSTVAR-ELEMENT-3      
              MOVE WS-IN-STATUS               TO HOSTVAR-ELEMENT-4      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7070-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                *        
      *================================================================*        
       7100-OPEN-WQ-CUR1.                                               
      *================================================================*        
                                                                        
                                                                        
           EXEC SQL                                                     
                OPEN WQ_CUR1                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7100'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_WQ_ITEMS'             TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'CUSTOMER_NO'              TO TABLE-ELEMENT-2        
              MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-3        
              MOVE 'STATUS'                   TO TABLE-ELEMENT-4        
              MOVE WQ-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE WQ-CUSTOMER-NO             TO HOSTVAR-ELEMENT-2      
              MOVE WQ-PREMISE-NO              TO HOSTVAR-ELEMENT-3      
              MOVE WS-IN-STATUS               TO HOSTVAR-ELEMENT-4      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                *        
      *================================================================*        
       7110-FETCH-WQ-CUR1.                                              

MSQ008     MOVE 999 TO MSQ008-WQ-CUR1
      *================================================================*        
                                                                        
           EXEC SQL                                                     
ACT118         FOR :MSQ008-WQ-CUR1
              FETCH 
              FROM WQ_CUR1               
A00509          INTO :WS-WQ-ITEM-ID                                     
A00509              ,:WS-WQ-DATE-CREATED                                
A00509              ,:WS-WQ-ACCOUNT-NO                                  
A00509              ,:WS-WQ-PREMISE-NO                                  
A00509              ,:WS-WQ-CUSTOMER-NO                                 
A00509              ,:WS-WQ-STATUS                                      
A00509              ,:WS-WQ-USER-ID-ORIG                                
A00509              ,:WS-WQ-USER-ID-ASGN                                
A00509              ,:WS-WQ-RESP-AREA-ID                                
A00509              ,:WS-WQ-COMPLETE-DATE :WS-WQ-NULL-IND-01             
A00509              ,:WS-WQ-CATEGORY-ID                                 
A00509              ,:WS-WQ-COMMENTS                                    
A00509              ,:WS-WQ-DATE-REQUIRED :WS-WQ-NULL-IND-02             
A00509              ,:WS-WQ-PRIORITY                                    
A00509              ,:WS-WQ-FREE-FORM-AREA                              
A00509              ,:WS-WQ-ERROR-CD                                    
A00509              ,:WS-WQ-LAST-UPDATE-TS                              
A00509              ,:WS-WQ-ASSGN-HIST-PRES-FL                          
A00509              ,:WS-AT-BILL-CYCLE                                  
A00509              ,:WS-AT-MST-SUB-ACCT-IND                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                             
MFA-TR*        FETCH NEXT ROWSET FROM WQ_CUR1 FOR 999 ROWS                      
MFA-TR*         INTO :WS-WQ-ITEM-ID                                             
MFA-TR*             ,:WS-WQ-DATE-CREATED                                        
MFA-TR*             ,:WS-WQ-ACCOUNT-NO                                          
MFA-TR*             ,:WS-WQ-PREMISE-NO                                          
MFA-TR*             ,:WS-WQ-CUSTOMER-NO                                         
MFA-TR*             ,:WS-WQ-STATUS                                              
MFA-TR*             ,:WS-WQ-USER-ID-ORIG                                        
MFA-TR*             ,:WS-WQ-USER-ID-ASGN                                        
MFA-TR*             ,:WS-WQ-RESP-AREA-ID                                        
MFA-TR*             ,:WS-WQ-COMPLETE-DATE:WS-WQ-NULL-IND-01                     
MFA-TR*             ,:WS-WQ-CATEGORY-ID                                         
MFA-TR*             ,:WS-WQ-COMMENTS                                            
MFA-TR*             ,:WS-WQ-DATE-REQUIRED:WS-WQ-NULL-IND-02                     
MFA-TR*             ,:WS-WQ-PRIORITY                                            
MFA-TR*             ,:WS-WQ-FREE-FORM-AREA                                      
MFA-TR*             ,:WS-WQ-ERROR-CD                                            
MFA-TR*             ,:WS-WQ-LAST-UPDATE-TS                                      
MFA-TR*             ,:WS-WQ-ASSGN-HIST-PRES-FL                                  
MFA-TR*             ,:WS-AT-BILL-CYCLE                                          
MFA-TR*             ,:WS-AT-MST-SUB-ACCT-IND                                    
MFA-TR*    END-EXEC.                                                            

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-WQ-CUR1
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
              WHEN NOT-FOUND                                            
A00509             MOVE SQLERRD(3)            TO WS-ROWS-COUNT          
              WHEN OTHER                                                
                 MOVE PROGRAM-NAME            TO ABEND-PROGRAM          
                 MOVE '7110'                  TO ACTIVE-PARAGRAPH       
                 MOVE 'FETCH'                 TO ABEND-FUNCTION         
                 MOVE SPACES                  TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
                 MOVE 'CSS_WQ_ITEMS'          TO TABLE-1                
                 MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1        
                 MOVE 'CUSTOMER_NO'           TO TABLE-ELEMENT-2        
                 MOVE 'PREMISE_NO'            TO TABLE-ELEMENT-3        
                 MOVE 'STATUS'                TO TABLE-ELEMENT-4        
                 MOVE WQ-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1      
                 MOVE WQ-CUSTOMER-NO          TO HOSTVAR-ELEMENT-2      
                 MOVE WQ-PREMISE-NO           TO HOSTVAR-ELEMENT-3      
                 MOVE WS-IN-STATUS            TO HOSTVAR-ELEMENT-4      
                 PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
      *                                                                *        
      *================================================================*        
       7120-CLOSE-WQ-CUR1.                                              
      *================================================================*        
                                                                        
           EXEC SQL                                                     
                CLOSE WQ_CUR1                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7120'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_WQ_ITEMS'             TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'CUSTOMER_NO'              TO TABLE-ELEMENT-2        
              MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-3        
              MOVE 'STATUS'                   TO TABLE-ELEMENT-4        
              MOVE WQ-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE WQ-CUSTOMER-NO             TO HOSTVAR-ELEMENT-2      
              MOVE WQ-PREMISE-NO              TO HOSTVAR-ELEMENT-3      
              MOVE WS-IN-STATUS               TO HOSTVAR-ELEMENT-4      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                *        
A00509*================================================================*        
A00509 7125-MAX-COUNT-CUR1.                                             
A00509*================================================================*        
A00509                                                                  
A00509     EXEC SQL                                                     
A00509          SELECT COUNT(*)                                         
A00509           INTO :WS-TOT-ROWS-COUNT                                
A00509           FROM CSS_WQ_ITEMS WQ WITH(READUNCOMMITTED)                     
A00509          WHERE WQ.ACCOUNT_NO = :WS-IN-ACCOUNT-NO                 
A00509            AND WQ.STATUS  IN ( :WS-IN-STATUS1, :WS-IN-STATUS2    
A00509                            ,:WS-IN-STATUS3, :WS-IN-STATUS4 )     
A00509            AND WQ.DATE_REQUIRED BETWEEN                          
A00509                                CIS.CHAR2TIMESTAMP(
                                              :WS-IN-REQUIRED-DATE-FROM
              )         
A00509                            AND CIS.CHAR2TIMESTAMP(
                                                :WS-IN-REQUIRED-DATE-BY
              )           
A00509            AND (WQ.CATEGORY_ID = :WS-IN-CATEGORY-ID              
A00509                 OR :WS-IN-CATEGORY-ID = 0 )                      
A00509            AND (WQ.RESP_AREA_ID = :WS-IN-RESP-AREA-ID            
A00509                 OR :WS-IN-RESP-AREA-ID = '   ')                  
A00509            AND (WQ.USER_ID_ORIG = :WS-IN-USER-ID-ORIG            
A00509                 OR :WS-IN-USER-ID-ORIG = '       ')              
A00509            AND (WQ.USER_ID_ASGN =     :WS-IN-USER-ID-ASGN        
A00509                 OR :WS-IN-USER-ID-ASGN = '       ')              
A00509            AND ((:WS-IN-COMPLETE-DATE-BY <> :WS-MIN-TMST         
A00509                 AND WQ.COMPLETE_DATE BETWEEN                     
A00509                 CIS.CHAR2TIMESTAMP(:WS-IN-COMPLETE-DATE-FROM)            
A00509                 AND CIS.CHAR2TIMESTAMP(:WS-IN-COMPLETE-DATE-BY) )        
A00509                OR (:WS-IN-COMPLETE-DATE-BY = :WS-MIN-TMST ))     
A00509                                                           
A00509                                                      
A00509     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT COUNT(*)                                                 
MFA-TR*          INTO :WS-TOT-ROWS-COUNT                                        
MFA-TR*          FROM CSS_WQ_ITEMS WQ                                           
MFA-TR*         WHERE WQ.ACCOUNT_NO = :WS-IN-ACCOUNT-NO                         
MFA-TR*           AND WQ.STATUS  IN ( :WS-IN-STATUS1, :WS-IN-STATUS2            
MFA-TR*                           ,:WS-IN-STATUS3, :WS-IN-STATUS4 )             
MFA-TR*           AND WQ.DATE_REQUIRED BETWEEN                                  
MFA-TR*                               :WS-IN-REQUIRED-DATE-FROM                 
MFA-TR*                           AND :WS-IN-REQUIRED-DATE-BY                   
MFA-TR*           AND (WQ.CATEGORY_ID = :WS-IN-CATEGORY-ID                      
MFA-TR*                OR :WS-IN-CATEGORY-ID = 0 )                              
MFA-TR*           AND (WQ.RESP_AREA_ID = :WS-IN-RESP-AREA-ID                    
MFA-TR*                OR :WS-IN-RESP-AREA-ID = '   ')                          
MFA-TR*           AND (WQ.USER_ID_ORIG = :WS-IN-USER-ID-ORIG                    
MFA-TR*                OR :WS-IN-USER-ID-ORIG = '       ')                      
MFA-TR*           AND (WQ.USER_ID_ASGN =     :WS-IN-USER-ID-ASGN                
MFA-TR*                OR :WS-IN-USER-ID-ASGN = '       ')                      
MFA-TR*           AND ((:WS-IN-COMPLETE-DATE-BY <> :WS-MIN-TMST                 
MFA-TR*                AND WQ.COMPLETE_DATE BETWEEN                             
MFA-TR*                :WS-IN-COMPLETE-DATE-FROM                                
MFA-TR*                AND :WS-IN-COMPLETE-DATE-BY )                            
MFA-TR*               OR (:WS-IN-COMPLETE-DATE-BY = :WS-MIN-TMST ))             
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7125                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00509                                                                  
A00509     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
A00509                                                                  
A00509     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A00509        CONTINUE                                                  
A00509     ELSE                                                         
A00509        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
A00509        MOVE '7125'                     TO ACTIVE-PARAGRAPH       
A00509        MOVE 'SELECT'                   TO ABEND-FUNCTION         
A00509        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
A00509                                           ABEND-TABLES           
A00509        MOVE 'CSS_WQ_ITEMS'             TO TABLE-1                
A00509        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
A00509        MOVE 'CUSTOMER_NO'              TO TABLE-ELEMENT-2        
A00509        MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-3        
A00509        MOVE 'STATUS'                   TO TABLE-ELEMENT-4        
A00509        MOVE WQ-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
A00509        MOVE WQ-CUSTOMER-NO             TO HOSTVAR-ELEMENT-2      
A00509        MOVE WQ-PREMISE-NO              TO HOSTVAR-ELEMENT-3      
A00509        MOVE WS-IN-STATUS               TO HOSTVAR-ELEMENT-4      
A00509        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
A00509     END-IF.                                                      
A00509                                                                  
A00509 7125-EXIT.                                                       
A00509     EXIT.                                                        
A00509                                                                  
A00509*                                                                *        
      *================================================================*        
       7150-OPEN-WQ-CUR2.                                               
      *================================================================*        
                                                                        
                                                                        
           EXEC SQL                                                     
                OPEN WQ_CUR2                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7150'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_WQ_ITEMS'             TO TABLE-1                
              MOVE 'CUSTOMER_NO'              TO TABLE-ELEMENT-1        
              MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-2        
              MOVE 'USER_ID_ASGN'             TO TABLE-ELEMENT-3        
              MOVE 'STATUS'                   TO TABLE-ELEMENT-4        
              MOVE WS-IN-CUSTOMER-NO          TO HOSTVAR-ELEMENT-1      
              MOVE WS-IN-PREMISE-NO           TO HOSTVAR-ELEMENT-2      
              MOVE WS-IN-USER-ID-ASGN         TO HOSTVAR-ELEMENT-3      
              MOVE WS-IN-STATUS               TO HOSTVAR-ELEMENT-4      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
      *                                                                *        
      *================================================================*        
       7160-FETCH-WQ-CUR2.                                              

MSQ008     MOVE 999 TO MSQ008-WQ-CUR2
      *================================================================*        
                                                                        
           EXEC SQL                                                     
ACT118         FOR :MSQ008-WQ-CUR2
              FETCH 
              FROM WQ_CUR2               
A00509          INTO :WS-WQ-ITEM-ID                                     
A00509              ,:WS-WQ-DATE-CREATED                                
A00509              ,:WS-WQ-ACCOUNT-NO                                  
A00509              ,:WS-WQ-PREMISE-NO                                  
A00509              ,:WS-WQ-CUSTOMER-NO                                 
A00509              ,:WS-WQ-STATUS                                      
A00509              ,:WS-WQ-USER-ID-ORIG                                
A00509              ,:WS-WQ-USER-ID-ASGN                                
A00509              ,:WS-WQ-RESP-AREA-ID                                
A00509              ,:WS-WQ-COMPLETE-DATE :WS-WQ-NULL-IND-01             
A00509              ,:WS-WQ-CATEGORY-ID                                 
A00509              ,:WS-WQ-COMMENTS                                    
A00509              ,:WS-WQ-DATE-REQUIRED :WS-WQ-NULL-IND-02             
A00509              ,:WS-WQ-PRIORITY                                    
A00509              ,:WS-WQ-FREE-FORM-AREA                              
A00509              ,:WS-WQ-ERROR-CD                                    
A00509              ,:WS-WQ-LAST-UPDATE-TS                              
A00509              ,:WS-WQ-ASSGN-HIST-PRES-FL                          
A00509              ,:WS-AT-BILL-CYCLE                                  
A00509              ,:WS-AT-MST-SUB-ACCT-IND                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                             
MFA-TR*        FETCH NEXT ROWSET FROM WQ_CUR2 FOR 999 ROWS                      
MFA-TR*         INTO :WS-WQ-ITEM-ID                                             
MFA-TR*             ,:WS-WQ-DATE-CREATED                                        
MFA-TR*             ,:WS-WQ-ACCOUNT-NO                                          
MFA-TR*             ,:WS-WQ-PREMISE-NO                                          
MFA-TR*             ,:WS-WQ-CUSTOMER-NO                                         
MFA-TR*             ,:WS-WQ-STATUS                                              
MFA-TR*             ,:WS-WQ-USER-ID-ORIG                                        
MFA-TR*             ,:WS-WQ-USER-ID-ASGN                                        
MFA-TR*             ,:WS-WQ-RESP-AREA-ID                                        
MFA-TR*             ,:WS-WQ-COMPLETE-DATE:WS-WQ-NULL-IND-01                     
MFA-TR*             ,:WS-WQ-CATEGORY-ID                                         
MFA-TR*             ,:WS-WQ-COMMENTS                                            
MFA-TR*             ,:WS-WQ-DATE-REQUIRED:WS-WQ-NULL-IND-02                     
MFA-TR*             ,:WS-WQ-PRIORITY                                            
MFA-TR*             ,:WS-WQ-FREE-FORM-AREA                                      
MFA-TR*             ,:WS-WQ-ERROR-CD                                            
MFA-TR*             ,:WS-WQ-LAST-UPDATE-TS                                      
MFA-TR*             ,:WS-WQ-ASSGN-HIST-PRES-FL                                  
MFA-TR*             ,:WS-AT-BILL-CYCLE                                          
MFA-TR*             ,:WS-AT-MST-SUB-ACCT-IND                                    
MFA-TR*    END-EXEC.                                                            

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-WQ-CUR2
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
              WHEN NOT-FOUND                                            
A00509           MOVE SQLERRD(3)              TO WS-ROWS-COUNT          
              WHEN OTHER                                                
                 MOVE PROGRAM-NAME            TO ABEND-PROGRAM          
                 MOVE '7160'                  TO ACTIVE-PARAGRAPH       
                 MOVE 'FETCH'                 TO ABEND-FUNCTION         
                 MOVE SPACES                  TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
                 MOVE 'CSS_WQ_ITEMS'          TO TABLE-1                
                 MOVE 'CUSTOMER_NO'           TO TABLE-ELEMENT-1        
                 MOVE 'PREMISE_NO'            TO TABLE-ELEMENT-2        
                 MOVE 'USER_ID_ASGN'          TO TABLE-ELEMENT-3        
                 MOVE 'STATUS'                TO TABLE-ELEMENT-4        
                 MOVE WS-IN-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1      
                 MOVE WS-IN-PREMISE-NO        TO HOSTVAR-ELEMENT-2      
                 MOVE WS-IN-USER-ID-ASGN      TO HOSTVAR-ELEMENT-3      
                 MOVE WS-IN-STATUS            TO HOSTVAR-ELEMENT-4      
                 PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7160-EXIT.                                                       
           EXIT.                                                        
      *                                                                *        
      *================================================================*        
       7170-CLOSE-WQ-CUR2.                                              
      *================================================================*        
                                                                        
           EXEC SQL                                                     
                CLOSE WQ_CUR2                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7170'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_WQ_ITEMS'             TO TABLE-1                
              MOVE 'CUSTOMER_NO'              TO TABLE-ELEMENT-1        
              MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-2        
              MOVE 'USER_ID_ASGN'             TO TABLE-ELEMENT-3        
              MOVE 'STATUS'                   TO TABLE-ELEMENT-4        
              MOVE WS-IN-CUSTOMER-NO          TO HOSTVAR-ELEMENT-1      
              MOVE WS-IN-PREMISE-NO           TO HOSTVAR-ELEMENT-2      
              MOVE WS-IN-USER-ID-ASGN         TO HOSTVAR-ELEMENT-3      
              MOVE WS-IN-STATUS               TO HOSTVAR-ELEMENT-4      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7170-EXIT.                                                       
           EXIT.                                                        
A00509*================================================================*        
A00509 7175-MAX-COUNT-CUR2.                                             
A00509*================================================================*        
A00509                                                                  
A00509     EXEC SQL                                                     
A00509          SELECT COUNT(*)                                         
A00509            INTO :WS-TOT-ROWS-COUNT                               
A00509            FROM CSS_WQ_ITEMS WQ WITH(READUNCOMMITTED)                    
A00509           WHERE WQ.CUSTOMER_NO IN (:WS-IN-CUSTOMER-NO, 0)        
A00509             AND WQ.PREMISE_NO  IN (:WS-IN-PREMISE-NO, 0)         
A00509             AND WQ.ACCOUNT_NO  IN (:WS-IN-ACCOUNT-NO, 0)         
A00509             AND (WQ.CUSTOMER_NO > 0 OR WQ.PREMISE_NO > 0         
A00509                                    OR WQ.ACCOUNT_NO > 0)         
A00509             AND WQ.STATUS  IN ( :WS-IN-STATUS1, :WS-IN-STATUS2   
A00509                               ,:WS-IN-STATUS3 )                  
A00509             AND WQ.DATE_REQUIRED BETWEEN                         
A00509                             CIS.CHAR2TIMESTAMP(
                                              :WS-IN-REQUIRED-DATE-FROM
              )            
A00509                         AND CIS.CHAR2TIMESTAMP(
                                                :WS-IN-REQUIRED-DATE-BY
              )              
A00509             AND (WQ.CATEGORY_ID = :WS-IN-CATEGORY-ID             
A00509                 OR :WS-IN-CATEGORY-ID = 0 )                      
A00509             AND (WQ.RESP_AREA_ID = :WS-IN-RESP-AREA-ID           
A00509                 OR :WS-IN-RESP-AREA-ID = '   ')                  
A00509             AND (WQ.USER_ID_ORIG = :WS-IN-USER-ID-ORIG           
A00509                 OR :WS-IN-USER-ID-ORIG = '       ')              
A00509             AND (WQ.USER_ID_ASGN =  :WS-IN-USER-ID-ASGN          
A00509                 OR :WS-IN-USER-ID-ASGN = '       ')              
A00509             AND ((:WS-IN-COMPLETE-DATE-BY <> :WS-MIN-TMST        
A00509                 AND WQ.COMPLETE_DATE BETWEEN                     
A00509                 CIS.CHAR2TIMESTAMP(:WS-IN-COMPLETE-DATE-FROM)            
A00509                 AND CIS.CHAR2TIMESTAMP(:WS-IN-COMPLETE-DATE-BY) )        
A00509              OR (:WS-IN-COMPLETE-DATE-BY = :WS-MIN-TMST ))       
A00509                                                           
A00509                                                      
A00509     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT COUNT(*)                                                 
MFA-TR*           INTO :WS-TOT-ROWS-COUNT                                       
MFA-TR*           FROM CSS_WQ_ITEMS WQ                                          
MFA-TR*          WHERE WQ.CUSTOMER_NO IN (:WS-IN-CUSTOMER-NO, 0)                
MFA-TR*            AND WQ.PREMISE_NO  IN (:WS-IN-PREMISE-NO, 0)                 
MFA-TR*            AND WQ.ACCOUNT_NO  IN (:WS-IN-ACCOUNT-NO, 0)                 
MFA-TR*            AND (WQ.CUSTOMER_NO > 0 OR WQ.PREMISE_NO > 0                 
MFA-TR*                                   OR WQ.ACCOUNT_NO > 0)                 
MFA-TR*            AND WQ.STATUS  IN ( :WS-IN-STATUS1, :WS-IN-STATUS2           
MFA-TR*                              ,:WS-IN-STATUS3 )                          
MFA-TR*            AND WQ.DATE_REQUIRED BETWEEN                                 
MFA-TR*                            :WS-IN-REQUIRED-DATE-FROM                    
MFA-TR*                        AND :WS-IN-REQUIRED-DATE-BY                      
MFA-TR*            AND (WQ.CATEGORY_ID = :WS-IN-CATEGORY-ID                     
MFA-TR*                OR :WS-IN-CATEGORY-ID = 0 )                              
MFA-TR*            AND (WQ.RESP_AREA_ID = :WS-IN-RESP-AREA-ID                   
MFA-TR*                OR :WS-IN-RESP-AREA-ID = '   ')                          
MFA-TR*            AND (WQ.USER_ID_ORIG = :WS-IN-USER-ID-ORIG                   
MFA-TR*                OR :WS-IN-USER-ID-ORIG = '       ')                      
MFA-TR*            AND (WQ.USER_ID_ASGN =  :WS-IN-USER-ID-ASGN                  
MFA-TR*                OR :WS-IN-USER-ID-ASGN = '       ')                      
MFA-TR*            AND ((:WS-IN-COMPLETE-DATE-BY <> :WS-MIN-TMST                
MFA-TR*                AND WQ.COMPLETE_DATE BETWEEN                             
MFA-TR*                :WS-IN-COMPLETE-DATE-FROM                                
MFA-TR*                AND :WS-IN-COMPLETE-DATE-BY )                            
MFA-TR*             OR (:WS-IN-COMPLETE-DATE-BY = :WS-MIN-TMST ))               
MFA-TR*           WITH UR                                                       
MFA-TR*        QUERYNO 7175                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00509                                                                  
A00509     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
A00509                                                                  
A00509     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A00509        CONTINUE                                                  
A00509     ELSE                                                         
A00509        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
A00509        MOVE '7175'                     TO ACTIVE-PARAGRAPH       
A00509        MOVE 'SELECT'                   TO ABEND-FUNCTION         
A00509        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
A00509                                           ABEND-TABLES           
A00509        MOVE 'CSS_WQ_ITEMS'             TO TABLE-1                
A00509        MOVE 'CUSTOMER_NO'              TO TABLE-ELEMENT-1        
A00509        MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-2        
A00509        MOVE 'USER_ID_ASGN'             TO TABLE-ELEMENT-3        
A00509        MOVE 'STATUS'                   TO TABLE-ELEMENT-4        
A00509        MOVE WS-IN-CUSTOMER-NO          TO HOSTVAR-ELEMENT-1      
A00509        MOVE WS-IN-PREMISE-NO           TO HOSTVAR-ELEMENT-2      
A00509        MOVE WS-IN-USER-ID-ASGN         TO HOSTVAR-ELEMENT-3      
A00509        MOVE WS-IN-STATUS               TO HOSTVAR-ELEMENT-4      
A00509        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
A00509     END-IF.                                                      
A00509                                                                  
A00509 7175-EXIT.                                                       
A00509     EXIT.                                                        
                                                                        
      *================================================================*        
       7200-OPEN-WQ-CUR3.                                               
      *================================================================*        
                                                                        
                                                                        
           EXEC SQL                                                     
                OPEN WQ_CUR3                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7200'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_WQ_ITEMS'             TO TABLE-1                
              MOVE 'USER_ID_ASGN'             TO TABLE-ELEMENT-1        
              MOVE 'CATEGORY_ID'              TO TABLE-ELEMENT-2        
              MOVE 'RESP_AREA_ID'             TO TABLE-ELEMENT-3        
              MOVE 'STATUS'                   TO TABLE-ELEMENT-4        
              MOVE WS-IN-USER-ID-ASGN         TO HOSTVAR-ELEMENT-1      
              MOVE WS-IN-CATEGORY-ID          TO HOSTVAR-ELEMENT-2      
              MOVE WS-IN-RESP-AREA-ID         TO HOSTVAR-ELEMENT-3      
              MOVE WS-IN-STATUS               TO HOSTVAR-ELEMENT-4      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                *        
      *================================================================*        
       7210-FETCH-WQ-CUR3.                                              

MSQ008     MOVE 999 TO MSQ008-WQ-CUR3
      *================================================================*        
                                                                        
           EXEC SQL                                                     
ACT118         FOR :MSQ008-WQ-CUR3
              FETCH 
              FROM WQ_CUR3               
A00509          INTO :WS-WQ-ITEM-ID                                     
A00509              ,:WS-WQ-DATE-CREATED                                
A00509              ,:WS-WQ-ACCOUNT-NO                                  
A00509              ,:WS-WQ-PREMISE-NO                                  
A00509              ,:WS-WQ-CUSTOMER-NO                                 
A00509              ,:WS-WQ-STATUS                                      
A00509              ,:WS-WQ-USER-ID-ORIG                                
A00509              ,:WS-WQ-USER-ID-ASGN                                
A00509              ,:WS-WQ-RESP-AREA-ID                                
A00509              ,:WS-WQ-COMPLETE-DATE :WS-WQ-NULL-IND-01             
A00509              ,:WS-WQ-CATEGORY-ID                                 
A00509              ,:WS-WQ-COMMENTS                                    
A00509              ,:WS-WQ-DATE-REQUIRED :WS-WQ-NULL-IND-02             
A00509              ,:WS-WQ-PRIORITY                                    
A00509              ,:WS-WQ-FREE-FORM-AREA                              
A00509              ,:WS-WQ-ERROR-CD                                    
A00509              ,:WS-WQ-LAST-UPDATE-TS                              
A00509              ,:WS-WQ-ASSGN-HIST-PRES-FL                          
A00509              ,:WS-AT-BILL-CYCLE                                  
A00509              ,:WS-AT-MST-SUB-ACCT-IND                            
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                             
MFA-TR*        FETCH NEXT ROWSET FROM WQ_CUR3 FOR 999 ROWS                      
MFA-TR*         INTO :WS-WQ-ITEM-ID                                             
MFA-TR*             ,:WS-WQ-DATE-CREATED                                        
MFA-TR*             ,:WS-WQ-ACCOUNT-NO                                          
MFA-TR*             ,:WS-WQ-PREMISE-NO                                          
MFA-TR*             ,:WS-WQ-CUSTOMER-NO                                         
MFA-TR*             ,:WS-WQ-STATUS                                              
MFA-TR*             ,:WS-WQ-USER-ID-ORIG                                        
MFA-TR*             ,:WS-WQ-USER-ID-ASGN                                        
MFA-TR*             ,:WS-WQ-RESP-AREA-ID                                        
MFA-TR*             ,:WS-WQ-COMPLETE-DATE:WS-WQ-NULL-IND-01                     
MFA-TR*             ,:WS-WQ-CATEGORY-ID                                         
MFA-TR*             ,:WS-WQ-COMMENTS                                            
MFA-TR*             ,:WS-WQ-DATE-REQUIRED:WS-WQ-NULL-IND-02                     
MFA-TR*             ,:WS-WQ-PRIORITY                                            
MFA-TR*             ,:WS-WQ-FREE-FORM-AREA                                      
MFA-TR*             ,:WS-WQ-ERROR-CD                                            
MFA-TR*             ,:WS-WQ-LAST-UPDATE-TS                                      
MFA-TR*             ,:WS-WQ-ASSGN-HIST-PRES-FL                                  
MFA-TR*             ,:WS-AT-BILL-CYCLE                                          
MFA-TR*             ,:WS-AT-MST-SUB-ACCT-IND                                    
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-WQ-CUR3
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
              WHEN NOT-FOUND                                            
A00509           MOVE SQLERRD(3)              TO WS-ROWS-COUNT          
              WHEN OTHER                                                
                 MOVE PROGRAM-NAME            TO ABEND-PROGRAM          
                 MOVE '7210'                  TO ACTIVE-PARAGRAPH       
                 MOVE 'FETCH'                 TO ABEND-FUNCTION         
                 MOVE SPACES                  TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
                 MOVE 'CSS_WQ_ITEMS'          TO TABLE-1                
                 MOVE 'USER_ID_ASGN'          TO TABLE-ELEMENT-1        
                 MOVE 'CATEGORY_ID'           TO TABLE-ELEMENT-2        
                 MOVE 'RESP_AREA_ID'          TO TABLE-ELEMENT-3        
                 MOVE 'STATUS'                TO TABLE-ELEMENT-4        
                 MOVE WS-IN-USER-ID-ASGN      TO HOSTVAR-ELEMENT-1      
                 MOVE WS-IN-CATEGORY-ID       TO HOSTVAR-ELEMENT-2      
                 MOVE WS-IN-RESP-AREA-ID      TO HOSTVAR-ELEMENT-3      
                 MOVE WS-IN-STATUS            TO HOSTVAR-ELEMENT-4      
                 PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                *        
      *================================================================*        
       7220-CLOSE-WQ-CUR3.                                              
      *================================================================*        
                                                                        
           EXEC SQL                                                     
                CLOSE WQ_CUR3                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7220'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_WQ_ITEMS'             TO TABLE-1                
              MOVE 'USER_ID_ASGN'             TO TABLE-ELEMENT-1        
              MOVE 'CATEGORY_ID'              TO TABLE-ELEMENT-2        
              MOVE 'RESP_AREA_ID'             TO TABLE-ELEMENT-3        
              MOVE 'STATUS'                   TO TABLE-ELEMENT-4        
              MOVE WS-IN-USER-ID-ASGN         TO HOSTVAR-ELEMENT-1      
              MOVE WS-IN-CATEGORY-ID          TO HOSTVAR-ELEMENT-2      
              MOVE WS-IN-RESP-AREA-ID         TO HOSTVAR-ELEMENT-3      
              MOVE WS-IN-STATUS               TO HOSTVAR-ELEMENT-4      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7220-EXIT.                                                       
           EXIT.                                                        
                                                                        
A00509*================================================================*        
A00509 7225-MAX-COUNT-CUR3.                                             
A00509*================================================================*        
A00509                                                                  
A00509     EXEC SQL                                                     
A00509          SELECT COUNT(*)                                         
A00509            INTO :WS-TOT-ROWS-COUNT                               
A00509            FROM CSS_WQ_ITEMS WQ WITH(READUNCOMMITTED)                    
A00509           WHERE WQ.USER_ID_ASGN =     :WS-IN-USER-ID-ASGN        
A00509             AND WQ.STATUS  IN ( :WS-IN-STATUS1, :WS-IN-STATUS2   
A00509                               ,:WS-IN-STATUS3 )                  
A00509             AND WQ.DATE_REQUIRED BETWEEN                         
A00509                             CIS.CHAR2TIMESTAMP(
                                              :WS-IN-REQUIRED-DATE-FROM
              )            
A00509                         AND CIS.CHAR2TIMESTAMP(
                                                :WS-IN-REQUIRED-DATE-BY
              )              
A00509             AND (WQ.CATEGORY_ID = :WS-IN-CATEGORY-ID             
A00509                 OR :WS-IN-CATEGORY-ID = 0 )                      
A00509             AND (WQ.RESP_AREA_ID = :WS-IN-RESP-AREA-ID           
A00509                 OR :WS-IN-RESP-AREA-ID = '   ')                  
A00509             AND (WQ.USER_ID_ORIG = :WS-IN-USER-ID-ORIG           
A00509                 OR :WS-IN-USER-ID-ORIG = '       ')              
A00509             AND ((:WS-IN-COMPLETE-DATE-BY <> :WS-MIN-TMST        
A00509                 AND WQ.COMPLETE_DATE BETWEEN                     
A00509                 CIS.CHAR2TIMESTAMP(:WS-IN-COMPLETE-DATE-FROM)            
A00509                 AND CIS.CHAR2TIMESTAMP(:WS-IN-COMPLETE-DATE-BY) )        
A00509              OR (:WS-IN-COMPLETE-DATE-BY = :WS-MIN-TMST ))       
A00509                                                           
A00509                                                      
A00509     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT COUNT(*)                                                 
MFA-TR*           INTO :WS-TOT-ROWS-COUNT                                       
MFA-TR*           FROM CSS_WQ_ITEMS WQ                                          
MFA-TR*          WHERE WQ.USER_ID_ASGN =     :WS-IN-USER-ID-ASGN                
MFA-TR*            AND WQ.STATUS  IN ( :WS-IN-STATUS1, :WS-IN-STATUS2           
MFA-TR*                              ,:WS-IN-STATUS3 )                          
MFA-TR*            AND WQ.DATE_REQUIRED BETWEEN                                 
MFA-TR*                            :WS-IN-REQUIRED-DATE-FROM                    
MFA-TR*                        AND :WS-IN-REQUIRED-DATE-BY                      
MFA-TR*            AND (WQ.CATEGORY_ID = :WS-IN-CATEGORY-ID                     
MFA-TR*                OR :WS-IN-CATEGORY-ID = 0 )                              
MFA-TR*            AND (WQ.RESP_AREA_ID = :WS-IN-RESP-AREA-ID                   
MFA-TR*                OR :WS-IN-RESP-AREA-ID = '   ')                          
MFA-TR*            AND (WQ.USER_ID_ORIG = :WS-IN-USER-ID-ORIG                   
MFA-TR*                OR :WS-IN-USER-ID-ORIG = '       ')                      
MFA-TR*            AND ((:WS-IN-COMPLETE-DATE-BY <> :WS-MIN-TMST                
MFA-TR*                AND WQ.COMPLETE_DATE BETWEEN                             
MFA-TR*                :WS-IN-COMPLETE-DATE-FROM                                
MFA-TR*                AND :WS-IN-COMPLETE-DATE-BY )                            
MFA-TR*             OR (:WS-IN-COMPLETE-DATE-BY = :WS-MIN-TMST ))               
MFA-TR*           WITH UR                                                       
MFA-TR*        QUERYNO 7225                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00509                                                                  
A00509     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
A00509                                                                  
A00509     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A00509        CONTINUE                                                  
A00509     ELSE                                                         
A00509        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
A00509        MOVE '7225'                     TO ACTIVE-PARAGRAPH       
A00509        MOVE 'SELECT'                   TO ABEND-FUNCTION         
A00509        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
A00509                                           ABEND-TABLES           
A00509        MOVE 'CSS_WQ_ITEMS'             TO TABLE-1                
A00509        MOVE 'USER_ID_ASGN'             TO TABLE-ELEMENT-1        
A00509        MOVE 'CATEGORY_ID'              TO TABLE-ELEMENT-2        
A00509        MOVE 'RESP_AREA_ID'             TO TABLE-ELEMENT-3        
A00509        MOVE 'STATUS'                   TO TABLE-ELEMENT-4        
A00509        MOVE WS-IN-USER-ID-ASGN         TO HOSTVAR-ELEMENT-1      
A00509        MOVE WS-IN-CATEGORY-ID          TO HOSTVAR-ELEMENT-2      
A00509        MOVE WS-IN-RESP-AREA-ID         TO HOSTVAR-ELEMENT-3      
A00509        MOVE WS-IN-STATUS               TO HOSTVAR-ELEMENT-4      
A00509        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
A00509     END-IF.                                                      
A00509                                                                  
A00509 7225-EXIT.                                                       
A00509     EXIT.                                                        
      *================================================================*        
       7250-OPEN-WQ-CUR4.                                               
      *================================================================*        
                                                                        
                                                                        
           EXEC SQL                                                     
                OPEN WQ_CUR4                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7250'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_WQ_ITEMS'             TO TABLE-1                
              MOVE 'RESP_AREA_ID'             TO TABLE-ELEMENT-1        
              MOVE 'CATEGORY_ID'              TO TABLE-ELEMENT-2        
              MOVE 'STATUS'                   TO TABLE-ELEMENT-3        
              MOVE 'REQUIRED_DATE_FROM'       TO TABLE-ELEMENT-4        
              MOVE WS-IN-RESP-AREA-ID         TO HOSTVAR-ELEMENT-1      
              MOVE WS-IN-CATEGORY-ID          TO HOSTVAR-ELEMENT-2      
              MOVE WS-IN-STATUS               TO HOSTVAR-ELEMENT-3      
              MOVE WS-IN-REQUIRED-DATE-FROM   TO HOSTVAR-ELEMENT-4      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7250-EXIT.                                                       
           EXIT.                                                        
      *                                                                *        
      *================================================================*        
       7260-FETCH-WQ-CUR4.                                              

MSQ008     MOVE 999 TO MSQ008-WQ-CUR4
      *================================================================*        
                                                                        
           EXEC SQL                                                     
ACT118         FOR :MSQ008-WQ-CUR4
              FETCH 
              FROM WQ_CUR4               
A00509          INTO :WS-WQ-ITEM-ID                                     
A00509              ,:WS-WQ-DATE-CREATED                                
A00509              ,:WS-WQ-ACCOUNT-NO                                  
A00509              ,:WS-WQ-PREMISE-NO                                  
A00509              ,:WS-WQ-CUSTOMER-NO                                 
A00509              ,:WS-WQ-STATUS                                      
A00509              ,:WS-WQ-USER-ID-ORIG                                
A00509              ,:WS-WQ-USER-ID-ASGN                                
A00509              ,:WS-WQ-RESP-AREA-ID                                
A00509              ,:WS-WQ-COMPLETE-DATE :WS-WQ-NULL-IND-01             
A00509              ,:WS-WQ-CATEGORY-ID                                 
A00509              ,:WS-WQ-COMMENTS                                    
A00509              ,:WS-WQ-DATE-REQUIRED :WS-WQ-NULL-IND-02             
A00509              ,:WS-WQ-PRIORITY                                    
A00509              ,:WS-WQ-FREE-FORM-AREA                              
A00509              ,:WS-WQ-ERROR-CD                                    
A00509              ,:WS-WQ-LAST-UPDATE-TS                              
A00509              ,:WS-WQ-ASSGN-HIST-PRES-FL                          
A00509              ,:WS-AT-BILL-CYCLE                                  
A00509              ,:WS-AT-MST-SUB-ACCT-IND                            
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                             
MFA-TR*        FETCH NEXT ROWSET FROM WQ_CUR4 FOR 999 ROWS                      
MFA-TR*         INTO :WS-WQ-ITEM-ID                                             
MFA-TR*             ,:WS-WQ-DATE-CREATED                                        
MFA-TR*             ,:WS-WQ-ACCOUNT-NO                                          
MFA-TR*             ,:WS-WQ-PREMISE-NO                                          
MFA-TR*             ,:WS-WQ-CUSTOMER-NO                                         
MFA-TR*             ,:WS-WQ-STATUS                                              
MFA-TR*             ,:WS-WQ-USER-ID-ORIG                                        
MFA-TR*             ,:WS-WQ-USER-ID-ASGN                                        
MFA-TR*             ,:WS-WQ-RESP-AREA-ID                                        
MFA-TR*             ,:WS-WQ-COMPLETE-DATE:WS-WQ-NULL-IND-01                     
MFA-TR*             ,:WS-WQ-CATEGORY-ID                                         
MFA-TR*             ,:WS-WQ-COMMENTS                                            
MFA-TR*             ,:WS-WQ-DATE-REQUIRED:WS-WQ-NULL-IND-02                     
MFA-TR*             ,:WS-WQ-PRIORITY                                            
MFA-TR*             ,:WS-WQ-FREE-FORM-AREA                                      
MFA-TR*             ,:WS-WQ-ERROR-CD                                            
MFA-TR*             ,:WS-WQ-LAST-UPDATE-TS                                      
MFA-TR*             ,:WS-WQ-ASSGN-HIST-PRES-FL                                  
MFA-TR*             ,:WS-AT-BILL-CYCLE                                          
MFA-TR*             ,:WS-AT-MST-SUB-ACCT-IND                                    
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-WQ-CUR4
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
              WHEN NOT-FOUND                                            
A00509           MOVE SQLERRD(3)              TO WS-ROWS-COUNT          
              WHEN OTHER                                                
                 MOVE PROGRAM-NAME            TO ABEND-PROGRAM          
                 MOVE '7260'                  TO ACTIVE-PARAGRAPH       
                 MOVE 'FETCH'                 TO ABEND-FUNCTION         
                 MOVE SPACES                  TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
                 MOVE 'CSS_WQ_ITEMS'          TO TABLE-1                
                 MOVE 'RESP_AREA_ID'          TO TABLE-ELEMENT-1        
                 MOVE 'CATEGORY_ID'           TO TABLE-ELEMENT-2        
                 MOVE 'STATUS'                TO TABLE-ELEMENT-3        
                 MOVE 'REQUIRED_DATE_FROM'    TO TABLE-ELEMENT-4        
                 MOVE WS-IN-RESP-AREA-ID      TO HOSTVAR-ELEMENT-1      
                 MOVE WS-IN-CATEGORY-ID       TO HOSTVAR-ELEMENT-2      
                 MOVE WS-IN-STATUS            TO HOSTVAR-ELEMENT-3      
                 MOVE WS-IN-REQUIRED-DATE-FROM TO HOSTVAR-ELEMENT-4     
                 PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7260-EXIT.                                                       
           EXIT.                                                        
      *                                                                *        
      *================================================================*        
       7270-CLOSE-WQ-CUR4.                                              
      *================================================================*        
                                                                        
           EXEC SQL                                                     
                CLOSE WQ_CUR4                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7270'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_WQ_ITEMS'             TO TABLE-1                
              MOVE 'RESP_AREA_ID'             TO TABLE-ELEMENT-1        
              MOVE 'CATEGORY_ID'              TO TABLE-ELEMENT-2        
              MOVE 'STATUS'                   TO TABLE-ELEMENT-3        
              MOVE 'REQUIRED_DATE_FROM'       TO TABLE-ELEMENT-4        
              MOVE WS-IN-RESP-AREA-ID         TO HOSTVAR-ELEMENT-1      
              MOVE WS-IN-CATEGORY-ID          TO HOSTVAR-ELEMENT-2      
              MOVE WS-IN-STATUS               TO HOSTVAR-ELEMENT-3      
              MOVE WS-IN-REQUIRED-DATE-FROM   TO HOSTVAR-ELEMENT-4      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7270-EXIT.                                                       
           EXIT.                                                        
                                                                        
A00509*================================================================*        
A00509 7275-MAX-COUNT-CUR4.                                             
A00509*================================================================*        
A00509                                                                  
A00509     EXEC SQL                                                     
A00509          SELECT COUNT(*)                                         
A00509            INTO :WS-TOT-ROWS-COUNT                               
A00509            FROM CSS_WQ_ITEMS WQ WITH(READUNCOMMITTED)                    
A00509           WHERE WQ.RESP_AREA_ID = :WS-IN-RESP-AREA-ID            
A00509             AND WQ.STATUS  IN ( :WS-IN-STATUS1, :WS-IN-STATUS2   
A00509                               ,:WS-IN-STATUS3 )                  
A00509             AND WQ.DATE_REQUIRED BETWEEN                         
A00509                             CIS.CHAR2TIMESTAMP(
                                              :WS-IN-REQUIRED-DATE-FROM
              )            
A00509                         AND CIS.CHAR2TIMESTAMP(
                                                :WS-IN-REQUIRED-DATE-BY
              )              
A00509             AND (WQ.CATEGORY_ID = :WS-IN-CATEGORY-ID             
A00509                 OR :WS-IN-CATEGORY-ID = 0 )                      
A00509             AND (WQ.USER_ID_ORIG = :WS-IN-USER-ID-ORIG           
A00509                 OR :WS-IN-USER-ID-ORIG = '       ')              
A00509             AND ((:WS-IN-COMPLETE-DATE-BY <> :WS-MIN-TMST        
A00509                 AND WQ.COMPLETE_DATE BETWEEN                     
A00509                 CIS.CHAR2TIMESTAMP(:WS-IN-COMPLETE-DATE-FROM)            
A00509                 AND CIS.CHAR2TIMESTAMP(:WS-IN-COMPLETE-DATE-BY) )        
A00509              OR (:WS-IN-COMPLETE-DATE-BY = :WS-MIN-TMST ))       
A00509                                                           
A00509                                                      
A00509     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT COUNT(*)                                                 
MFA-TR*           INTO :WS-TOT-ROWS-COUNT                                       
MFA-TR*           FROM CSS_WQ_ITEMS WQ                                          
MFA-TR*          WHERE WQ.RESP_AREA_ID = :WS-IN-RESP-AREA-ID                    
MFA-TR*            AND WQ.STATUS  IN ( :WS-IN-STATUS1, :WS-IN-STATUS2           
MFA-TR*                              ,:WS-IN-STATUS3 )                          
MFA-TR*            AND WQ.DATE_REQUIRED BETWEEN                                 
MFA-TR*                            :WS-IN-REQUIRED-DATE-FROM                    
MFA-TR*                        AND :WS-IN-REQUIRED-DATE-BY                      
MFA-TR*            AND (WQ.CATEGORY_ID = :WS-IN-CATEGORY-ID                     
MFA-TR*                OR :WS-IN-CATEGORY-ID = 0 )                              
MFA-TR*            AND (WQ.USER_ID_ORIG = :WS-IN-USER-ID-ORIG                   
MFA-TR*                OR :WS-IN-USER-ID-ORIG = '       ')                      
MFA-TR*            AND ((:WS-IN-COMPLETE-DATE-BY <> :WS-MIN-TMST                
MFA-TR*                AND WQ.COMPLETE_DATE BETWEEN                             
MFA-TR*                :WS-IN-COMPLETE-DATE-FROM                                
MFA-TR*                AND :WS-IN-COMPLETE-DATE-BY )                            
MFA-TR*             OR (:WS-IN-COMPLETE-DATE-BY = :WS-MIN-TMST ))               
MFA-TR*           WITH UR                                                       
MFA-TR*        QUERYNO 7275                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00509                                                                  
A00509     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
A00509                                                                  
A00509     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A00509        CONTINUE                                                  
A00509     ELSE                                                         
A00509        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
A00509        MOVE '7275'                     TO ACTIVE-PARAGRAPH       
A00509        MOVE 'SELECT'                   TO ABEND-FUNCTION         
A00509        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
A00509                                           ABEND-TABLES           
A00509        MOVE 'CSS_WQ_ITEMS'             TO TABLE-1                
A00509        MOVE 'RESP_AREA_ID'             TO TABLE-ELEMENT-1        
A00509        MOVE 'CATEGORY_ID'              TO TABLE-ELEMENT-2        
A00509        MOVE 'STATUS'                   TO TABLE-ELEMENT-3        
A00509        MOVE 'REQUIRED_DATE_FROM'       TO TABLE-ELEMENT-4        
A00509        MOVE WS-IN-RESP-AREA-ID         TO HOSTVAR-ELEMENT-1      
A00509        MOVE WS-IN-CATEGORY-ID          TO HOSTVAR-ELEMENT-2      
A00509        MOVE WS-IN-STATUS               TO HOSTVAR-ELEMENT-3      
A00509        MOVE WS-IN-REQUIRED-DATE-FROM   TO HOSTVAR-ELEMENT-4      
A00509        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
A00509     END-IF.                                                      
A00509                                                                  
A00509 7275-EXIT.                                                       
A00509     EXIT.                                                        
                                                                        
      *================================================================*        
       7300-OPEN-WQ-CUR5.                                               
      *================================================================*        
                                                                        
                                                                        
           EXEC SQL                                                     
                OPEN WQ_CUR5                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7300'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_WQ_ITEMS'             TO TABLE-1                
              MOVE 'CATEGORY_ID'              TO TABLE-ELEMENT-1        
              MOVE 'STATUS'                   TO TABLE-ELEMENT-2        
              MOVE 'REQUIRED_DATE_FROM'       TO TABLE-ELEMENT-3        
              MOVE 'REQUIRED_DATE_BY'         TO TABLE-ELEMENT-4        
              MOVE WS-IN-CATEGORY-ID          TO HOSTVAR-ELEMENT-1      
              MOVE WS-IN-STATUS               TO HOSTVAR-ELEMENT-2      
              MOVE WS-IN-REQUIRED-DATE-FROM   TO HOSTVAR-ELEMENT-3      
              MOVE WS-IN-REQUIRED-DATE-BY     TO HOSTVAR-ELEMENT-4      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                *        
      *================================================================*        
       7310-FETCH-WQ-CUR5.                                              

MSQ008     MOVE 999 TO MSQ008-WQ-CUR5
      *================================================================*        
                                                                        
           EXEC SQL                                                     
ACT118         FOR :MSQ008-WQ-CUR5
              FETCH 
              FROM WQ_CUR5               
A00509          INTO :WS-WQ-ITEM-ID                                     
A00509              ,:WS-WQ-DATE-CREATED                                
A00509              ,:WS-WQ-ACCOUNT-NO                                  
A00509              ,:WS-WQ-PREMISE-NO                                  
A00509              ,:WS-WQ-CUSTOMER-NO                                 
A00509              ,:WS-WQ-STATUS                                      
A00509              ,:WS-WQ-USER-ID-ORIG                                
A00509              ,:WS-WQ-USER-ID-ASGN                                
A00509              ,:WS-WQ-RESP-AREA-ID                                
A00509              ,:WS-WQ-COMPLETE-DATE :WS-WQ-NULL-IND-01             
A00509              ,:WS-WQ-CATEGORY-ID                                 
A00509              ,:WS-WQ-COMMENTS                                    
A00509              ,:WS-WQ-DATE-REQUIRED :WS-WQ-NULL-IND-02             
A00509              ,:WS-WQ-PRIORITY                                    
A00509              ,:WS-WQ-FREE-FORM-AREA                              
A00509              ,:WS-WQ-ERROR-CD                                    
A00509              ,:WS-WQ-LAST-UPDATE-TS                              
A00509              ,:WS-WQ-ASSGN-HIST-PRES-FL                          
A00509              ,:WS-AT-BILL-CYCLE                                  
A00509              ,:WS-AT-MST-SUB-ACCT-IND                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                             
MFA-TR*        FETCH NEXT ROWSET FROM WQ_CUR5 FOR 999 ROWS                      
MFA-TR*         INTO :WS-WQ-ITEM-ID                                             
MFA-TR*             ,:WS-WQ-DATE-CREATED                                        
MFA-TR*             ,:WS-WQ-ACCOUNT-NO                                          
MFA-TR*             ,:WS-WQ-PREMISE-NO                                          
MFA-TR*             ,:WS-WQ-CUSTOMER-NO                                         
MFA-TR*             ,:WS-WQ-STATUS                                              
MFA-TR*             ,:WS-WQ-USER-ID-ORIG                                        
MFA-TR*             ,:WS-WQ-USER-ID-ASGN                                        
MFA-TR*             ,:WS-WQ-RESP-AREA-ID                                        
MFA-TR*             ,:WS-WQ-COMPLETE-DATE:WS-WQ-NULL-IND-01                     
MFA-TR*             ,:WS-WQ-CATEGORY-ID                                         
MFA-TR*             ,:WS-WQ-COMMENTS                                            
MFA-TR*             ,:WS-WQ-DATE-REQUIRED:WS-WQ-NULL-IND-02                     
MFA-TR*             ,:WS-WQ-PRIORITY                                            
MFA-TR*             ,:WS-WQ-FREE-FORM-AREA                                      
MFA-TR*             ,:WS-WQ-ERROR-CD                                            
MFA-TR*             ,:WS-WQ-LAST-UPDATE-TS                                      
MFA-TR*             ,:WS-WQ-ASSGN-HIST-PRES-FL                                  
MFA-TR*             ,:WS-AT-BILL-CYCLE                                          
MFA-TR*             ,:WS-AT-MST-SUB-ACCT-IND                                    
MFA-TR*    END-EXEC.                                                            

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-WQ-CUR5
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
              WHEN NOT-FOUND                                            
A00509           MOVE SQLERRD(3)              TO WS-ROWS-COUNT          
              WHEN OTHER                                                
                 MOVE PROGRAM-NAME            TO ABEND-PROGRAM          
                 MOVE '7310'                  TO ACTIVE-PARAGRAPH       
                 MOVE 'FETCH'                 TO ABEND-FUNCTION         
                 MOVE SPACES                  TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
                 MOVE 'CSS_WQ_ITEMS'          TO TABLE-1                
                 MOVE 'CATEGORY_ID'           TO TABLE-ELEMENT-1        
                 MOVE 'STATUS'                TO TABLE-ELEMENT-2        
                 MOVE 'REQUIRED_DATE_FROM'    TO TABLE-ELEMENT-3        
                 MOVE 'REQUIRED_DATE_BY'      TO TABLE-ELEMENT-4        
                 MOVE WS-IN-CATEGORY-ID       TO HOSTVAR-ELEMENT-1      
                 MOVE WS-IN-STATUS            TO HOSTVAR-ELEMENT-2      
                 MOVE WS-IN-REQUIRED-DATE-FROM TO HOSTVAR-ELEMENT-3     
                 MOVE WS-IN-REQUIRED-DATE-BY   TO HOSTVAR-ELEMENT-4     
                 PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
                                                                        
       7310-EXIT.                                                       
           EXIT.                                                        
      *                                                                *        
      *================================================================*        
       7320-CLOSE-WQ-CUR5.                                              
      *================================================================*        
                                                                        
           EXEC SQL                                                     
                CLOSE WQ_CUR5                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7320'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_WQ_ITEMS'             TO TABLE-1                
              MOVE 'CATEGORY_ID'              TO TABLE-ELEMENT-1        
              MOVE 'STATUS'                   TO TABLE-ELEMENT-2        
              MOVE 'REQUIRED_DATE_FROM'       TO TABLE-ELEMENT-3        
              MOVE 'REQUIRED_DATE_BY'         TO TABLE-ELEMENT-4        
              MOVE WS-IN-CATEGORY-ID          TO HOSTVAR-ELEMENT-1      
              MOVE WS-IN-STATUS               TO HOSTVAR-ELEMENT-2      
              MOVE WS-IN-REQUIRED-DATE-FROM   TO HOSTVAR-ELEMENT-3      
              MOVE WS-IN-REQUIRED-DATE-BY     TO HOSTVAR-ELEMENT-4      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7320-EXIT.                                                       
           EXIT.                                                        
                                                                        
A00509*================================================================*        
A00509 7325-MAX-COUNT-CUR5.                                             
A00509*================================================================*        
A00509                                                                  
A00509     EXEC SQL                                                     
A00509          SELECT COUNT(*)                                         
A00509            INTO :WS-TOT-ROWS-COUNT                               
A00509           FROM CSS_WQ_ITEMS WQ WITH(READUNCOMMITTED)                     
A00509          WHERE WQ.CATEGORY_ID = :WS-IN-CATEGORY-ID               
A00509            AND WQ.STATUS  IN ( :WS-IN-STATUS1, :WS-IN-STATUS2    
A00509                               ,:WS-IN-STATUS3 )                  
A00509            AND WQ.DATE_REQUIRED BETWEEN                          
A00509                             CIS.CHAR2TIMESTAMP(
                                              :WS-IN-REQUIRED-DATE-FROM
              )            
A00509                         AND CIS.CHAR2TIMESTAMP(
                                                :WS-IN-REQUIRED-DATE-BY
              )              
A00509            AND (WQ.USER_ID_ORIG = :WS-IN-USER-ID-ORIG            
A00509                 OR :WS-IN-USER-ID-ORIG = '       ')              
A00509            AND ((:WS-IN-COMPLETE-DATE-BY <> :WS-MIN-TMST         
A00509                 AND WQ.COMPLETE_DATE BETWEEN                     
A00509                 CIS.CHAR2TIMESTAMP(:WS-IN-COMPLETE-DATE-FROM)            
A00509                 AND CIS.CHAR2TIMESTAMP(:WS-IN-COMPLETE-DATE-BY) )        
A00509                OR (:WS-IN-COMPLETE-DATE-BY = :WS-MIN-TMST ))     
A00509                                                           
A00509                                                      
A00509     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT COUNT(*)                                                 
MFA-TR*           INTO :WS-TOT-ROWS-COUNT                                       
MFA-TR*          FROM CSS_WQ_ITEMS WQ                                           
MFA-TR*         WHERE WQ.CATEGORY_ID = :WS-IN-CATEGORY-ID                       
MFA-TR*           AND WQ.STATUS  IN ( :WS-IN-STATUS1, :WS-IN-STATUS2            
MFA-TR*                              ,:WS-IN-STATUS3 )                          
MFA-TR*           AND WQ.DATE_REQUIRED BETWEEN                                  
MFA-TR*                            :WS-IN-REQUIRED-DATE-FROM                    
MFA-TR*                        AND :WS-IN-REQUIRED-DATE-BY                      
MFA-TR*           AND (WQ.USER_ID_ORIG = :WS-IN-USER-ID-ORIG                    
MFA-TR*                OR :WS-IN-USER-ID-ORIG = '       ')                      
MFA-TR*           AND ((:WS-IN-COMPLETE-DATE-BY <> :WS-MIN-TMST                 
MFA-TR*                AND WQ.COMPLETE_DATE BETWEEN                             
MFA-TR*                :WS-IN-COMPLETE-DATE-FROM                                
MFA-TR*                AND :WS-IN-COMPLETE-DATE-BY )                            
MFA-TR*               OR (:WS-IN-COMPLETE-DATE-BY = :WS-MIN-TMST ))             
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7325                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00509                                                                  
A00509     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
A00509                                                                  
A00509     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A00509        CONTINUE                                                  
A00509     ELSE                                                         
A00509        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
A00509        MOVE '7325'                     TO ACTIVE-PARAGRAPH       
A00509        MOVE 'SELECT'                   TO ABEND-FUNCTION         
A00509        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
A00509                                           ABEND-TABLES           
A00509        MOVE 'CSS_WQ_ITEMS'             TO TABLE-1                
A00509        MOVE 'CATEGORY_ID'              TO TABLE-ELEMENT-1        
A00509        MOVE 'STATUS'                   TO TABLE-ELEMENT-2        
A00509        MOVE 'REQUIRED_DATE_FROM'       TO TABLE-ELEMENT-3        
A00509        MOVE 'REQUIRED_DATE_BY'         TO TABLE-ELEMENT-4        
A00509        MOVE WS-IN-CATEGORY-ID          TO HOSTVAR-ELEMENT-1      
A00509        MOVE WS-IN-STATUS               TO HOSTVAR-ELEMENT-2      
A00509        MOVE WS-IN-REQUIRED-DATE-FROM   TO HOSTVAR-ELEMENT-3      
A00509        MOVE WS-IN-REQUIRED-DATE-BY     TO HOSTVAR-ELEMENT-4      
A00509        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
A00509     END-IF.                                                      
A00509                                                                  
A00509 7325-EXIT.                                                       
A00509     EXIT.                                                        
                                                                        
      *================================================================*        
       7350-OPEN-WQ-CUR6.                                               
      *================================================================*        
                                                                        
                                                                        
           EXEC SQL                                                     
                OPEN WQ_CUR6                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7350'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_WQ_ITEMS'             TO TABLE-1                
              MOVE 'STATUS'                   TO TABLE-ELEMENT-1        
              MOVE 'REQUIRED_DATE_FROM'       TO TABLE-ELEMENT-2        
              MOVE 'REQUIRED_DATE_BY'         TO TABLE-ELEMENT-3        
              MOVE 'COMPLETE_DATE_FROM'       TO TABLE-ELEMENT-4        
              MOVE WS-IN-STATUS               TO HOSTVAR-ELEMENT-1      
              MOVE WS-IN-REQUIRED-DATE-FROM   TO HOSTVAR-ELEMENT-2      
              MOVE WS-IN-REQUIRED-DATE-BY     TO HOSTVAR-ELEMENT-3      
              MOVE WS-IN-COMPLETE-DATE-FROM   TO HOSTVAR-ELEMENT-4      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7350-EXIT.                                                       
           EXIT.                                                        
      *                                                                *        
      *================================================================*        
       7360-FETCH-WQ-CUR6.                                              

MSQ008     MOVE 999 TO MSQ008-WQ-CUR6
      *================================================================*        
                                                                        
           EXEC SQL                                                     
ACT118         FOR :MSQ008-WQ-CUR6
              FETCH 
              FROM WQ_CUR6               
A00509          INTO :WS-WQ-ITEM-ID                                     
A00509              ,:WS-WQ-DATE-CREATED                                
A00509              ,:WS-WQ-ACCOUNT-NO                                  
A00509              ,:WS-WQ-PREMISE-NO                                  
A00509              ,:WS-WQ-CUSTOMER-NO                                 
A00509              ,:WS-WQ-STATUS                                      
A00509              ,:WS-WQ-USER-ID-ORIG                                
A00509              ,:WS-WQ-USER-ID-ASGN                                
A00509              ,:WS-WQ-RESP-AREA-ID                                
A00509              ,:WS-WQ-COMPLETE-DATE :WS-WQ-NULL-IND-01             
A00509              ,:WS-WQ-CATEGORY-ID                                 
A00509              ,:WS-WQ-COMMENTS                                    
A00509              ,:WS-WQ-DATE-REQUIRED :WS-WQ-NULL-IND-02             
A00509              ,:WS-WQ-PRIORITY                                    
A00509              ,:WS-WQ-FREE-FORM-AREA                              
A00509              ,:WS-WQ-ERROR-CD                                    
A00509              ,:WS-WQ-LAST-UPDATE-TS                              
A00509              ,:WS-WQ-ASSGN-HIST-PRES-FL                          
A00509              ,:WS-AT-BILL-CYCLE                                  
A00509              ,:WS-AT-MST-SUB-ACCT-IND                            
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                             
MFA-TR*        FETCH NEXT ROWSET FROM WQ_CUR6 FOR 999 ROWS                      
MFA-TR*         INTO :WS-WQ-ITEM-ID                                             
MFA-TR*             ,:WS-WQ-DATE-CREATED                                        
MFA-TR*             ,:WS-WQ-ACCOUNT-NO                                          
MFA-TR*             ,:WS-WQ-PREMISE-NO                                          
MFA-TR*             ,:WS-WQ-CUSTOMER-NO                                         
MFA-TR*             ,:WS-WQ-STATUS                                              
MFA-TR*             ,:WS-WQ-USER-ID-ORIG                                        
MFA-TR*             ,:WS-WQ-USER-ID-ASGN                                        
MFA-TR*             ,:WS-WQ-RESP-AREA-ID                                        
MFA-TR*             ,:WS-WQ-COMPLETE-DATE:WS-WQ-NULL-IND-01                     
MFA-TR*             ,:WS-WQ-CATEGORY-ID                                         
MFA-TR*             ,:WS-WQ-COMMENTS                                            
MFA-TR*             ,:WS-WQ-DATE-REQUIRED:WS-WQ-NULL-IND-02                     
MFA-TR*             ,:WS-WQ-PRIORITY                                            
MFA-TR*             ,:WS-WQ-FREE-FORM-AREA                                      
MFA-TR*             ,:WS-WQ-ERROR-CD                                            
MFA-TR*             ,:WS-WQ-LAST-UPDATE-TS                                      
MFA-TR*             ,:WS-WQ-ASSGN-HIST-PRES-FL                                  
MFA-TR*             ,:WS-AT-BILL-CYCLE                                          
MFA-TR*             ,:WS-AT-MST-SUB-ACCT-IND                                    
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-WQ-CUR6
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
              WHEN NOT-FOUND                                            
A00509           MOVE SQLERRD(3)              TO WS-ROWS-COUNT          
              WHEN OTHER                                                
                 MOVE PROGRAM-NAME            TO ABEND-PROGRAM          
                 MOVE '7360'                  TO ACTIVE-PARAGRAPH       
                 MOVE 'FETCH'                 TO ABEND-FUNCTION         
                 MOVE SPACES                  TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
                 MOVE 'CSS_WQ_ITEMS'          TO TABLE-1                
                 MOVE 'STATUS'                TO TABLE-ELEMENT-1        
                 MOVE 'REQUIRED_DATE_FROM'    TO TABLE-ELEMENT-2        
                 MOVE 'REQUIRED_DATE_BY'      TO TABLE-ELEMENT-3        
                 MOVE 'COMPLETE_DATE_FROM'    TO TABLE-ELEMENT-4        
                 MOVE WS-IN-STATUS            TO HOSTVAR-ELEMENT-1      
                 MOVE WS-IN-REQUIRED-DATE-FROM TO HOSTVAR-ELEMENT-2     
                 MOVE WS-IN-REQUIRED-DATE-BY   TO HOSTVAR-ELEMENT-3     
                 MOVE WS-IN-COMPLETE-DATE-FROM TO HOSTVAR-ELEMENT-4     
                 PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7360-EXIT.                                                       
           EXIT.                                                        
      *                                                                *        
      *================================================================*        
       7370-CLOSE-WQ-CUR6.                                              
      *================================================================*        
                                                                        
           EXEC SQL                                                     
                CLOSE WQ_CUR6                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7370'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_WQ_ITEMS'             TO TABLE-1                
              MOVE 'STATUS'                   TO TABLE-ELEMENT-1        
              MOVE 'REQUIRED_DATE_FROM'       TO TABLE-ELEMENT-2        
              MOVE 'REQUIRED_DATE_BY'         TO TABLE-ELEMENT-3        
              MOVE 'COMPLETE_DATE_FROM'       TO TABLE-ELEMENT-4        
              MOVE WS-IN-STATUS               TO HOSTVAR-ELEMENT-1      
              MOVE WS-IN-REQUIRED-DATE-FROM   TO HOSTVAR-ELEMENT-2      
              MOVE WS-IN-REQUIRED-DATE-BY     TO HOSTVAR-ELEMENT-3      
              MOVE WS-IN-COMPLETE-DATE-FROM   TO HOSTVAR-ELEMENT-4      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7370-EXIT.                                                       
           EXIT.                                                        
                                                                        
A00509*================================================================*        
A00509 7375-MAX-COUNT-CUR6.                                             
A00509*================================================================*        
A00509                                                                  
A00509     EXEC SQL                                                     
A00509          SELECT COUNT(*)                                         
A00509            INTO :WS-TOT-ROWS-COUNT                               
A00509            FROM CSS_WQ_ITEMS WQ WITH(READUNCOMMITTED)                    
A00509           WHERE WQ.STATUS  IN ( :WS-IN-STATUS1, :WS-IN-STATUS2   
A00509                               ,:WS-IN-STATUS3 )                  
A00509             AND WQ.DATE_REQUIRED BETWEEN                         
A00509                             CIS.CHAR2TIMESTAMP(
                                              :WS-IN-REQUIRED-DATE-FROM
              )            
A00509                         AND CIS.CHAR2TIMESTAMP(
                                                :WS-IN-REQUIRED-DATE-BY
              )              
A00509             AND (WQ.USER_ID_ORIG = :WS-IN-USER-ID-ORIG           
A00509                 OR :WS-IN-USER-ID-ORIG = '       ')              
A00509             AND ((:WS-IN-COMPLETE-DATE-BY <> :WS-MIN-TMST        
A00509                 AND WQ.COMPLETE_DATE BETWEEN                     
A00509                 CIS.CHAR2TIMESTAMP(:WS-IN-COMPLETE-DATE-FROM)            
A00509                 AND CIS.CHAR2TIMESTAMP(:WS-IN-COMPLETE-DATE-BY) )        
A00509             OR (:WS-IN-COMPLETE-DATE-BY = :WS-MIN-TMST ))        
A00509                                                           
A00509                                                      
A00509     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT COUNT(*)                                                 
MFA-TR*           INTO :WS-TOT-ROWS-COUNT                                       
MFA-TR*           FROM CSS_WQ_ITEMS WQ                                          
MFA-TR*          WHERE WQ.STATUS  IN ( :WS-IN-STATUS1, :WS-IN-STATUS2           
MFA-TR*                              ,:WS-IN-STATUS3 )                          
MFA-TR*            AND WQ.DATE_REQUIRED BETWEEN                                 
MFA-TR*                            :WS-IN-REQUIRED-DATE-FROM                    
MFA-TR*                        AND :WS-IN-REQUIRED-DATE-BY                      
MFA-TR*            AND (WQ.USER_ID_ORIG = :WS-IN-USER-ID-ORIG                   
MFA-TR*                OR :WS-IN-USER-ID-ORIG = '       ')                      
MFA-TR*            AND ((:WS-IN-COMPLETE-DATE-BY <> :WS-MIN-TMST                
MFA-TR*                AND WQ.COMPLETE_DATE BETWEEN                             
MFA-TR*                :WS-IN-COMPLETE-DATE-FROM                                
MFA-TR*                AND :WS-IN-COMPLETE-DATE-BY )                            
MFA-TR*            OR (:WS-IN-COMPLETE-DATE-BY = :WS-MIN-TMST ))                
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7375                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00509                                                                  
A00509     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
A00509                                                                  
A00509     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A00509        CONTINUE                                                  
A00509     ELSE                                                         
A00509        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
A00509        MOVE '7375'                     TO ACTIVE-PARAGRAPH       
A00509        MOVE 'SELECT'                   TO ABEND-FUNCTION         
A00509        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
A00509                                           ABEND-TABLES           
A00509        MOVE 'CSS_WQ_ITEMS'             TO TABLE-1                
A00509        MOVE 'STATUS'                   TO TABLE-ELEMENT-1        
A00509        MOVE 'REQUIRED_DATE_FROM'       TO TABLE-ELEMENT-2        
A00509        MOVE 'REQUIRED_DATE_BY'         TO TABLE-ELEMENT-3        
A00509        MOVE 'COMPLETE_DATE_FROM'       TO TABLE-ELEMENT-4        
A00509        MOVE WS-IN-STATUS               TO HOSTVAR-ELEMENT-1      
A00509        MOVE WS-IN-REQUIRED-DATE-FROM   TO HOSTVAR-ELEMENT-2      
A00509        MOVE WS-IN-REQUIRED-DATE-BY     TO HOSTVAR-ELEMENT-3      
A00509        MOVE WS-IN-COMPLETE-DATE-FROM   TO HOSTVAR-ELEMENT-4      
A00509        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
A00509     END-IF.                                                      
A00509                                                                  
A00509 7375-EXIT.                                                       
A00509     EXIT.                                                        
      *****************************************************************         
      * 8000A-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000A-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04674_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04674_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                  CONTINUE                                              
               WHEN NOT-FOUND                                           
                  MOVE ZEROES                 TO WS-ACTIVE-RETURN-CODE  
               WHEN OTHER                                               
                  MOVE PROGRAM-NAME           TO ABEND-PROGRAM          
                  MOVE SQLCODE                TO ABEND-SQLCODE          
                  MOVE SQLSTATE               TO ABEND-SQLSTATE         
                  MOVE '8000A'                TO ACTIVE-PARAGRAPH       
                  MOVE 'DELETE'               TO ABEND-FUNCTION         
                  MOVE SPACES                 TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
                  MOVE 'CSR04674_R1'          TO TABLE-1                
                  MOVE SPACES                 TO TABLE-ELEMENT-1        
                  MOVE SPACES                 TO HOSTVAR-ELEMENT-1      
                  PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       8000A-EXIT.                                                      
            EXIT.                                                       
      *                                                                *        
      *================================================================*        
       8100-SEND-RESULT.                                                
      *================================================================*        
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04674_R1                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,ITEM_ID                                              
                  ,DATE_CREATED                                         
                  ,ACCOUNT_NO                                           
                  ,PREMISE_NO                                           
                  ,CUSTOMER_NO                                          
                  ,STATUS                                               
                  ,USER_ID_ORIG                                         
                  ,USER_ID_ASGN                                         
                  ,RESP_AREA_ID                                         
                  ,COMPLETE_DATE                                        
                  ,CATEGORY_ID                                          
                  ,DATE_REQUIRED                                        
                  ,PRIORITY                                             
                  ,WQ_ERROR_CD                                          
                  ,LAST_UPDATE_TS                                       
                  ,ADDRESS_LINE1                                        
                  ,ADDRESS_LINE2                                        
                  ,ZIP_CODE                                             
                  ,PHONE_NO                                             
                  ,FULL_NAME                                            
                  ,LOCAL_OFFICE                                         
                  ,BILL_CYCLE                                           
                  ,MST_SUB_ACCT_IND                                     
                  ,ASSIGN_HIST_IND                                      
                  ,TASKS_COUNT                                          
                  ,COMMENTS                                             
                  ,FREE_FORM_AREA                                       
A00509            ,TOTAL_RECORDS                                        
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE                                       
                  ,:S-APPL-RETURN-CODE                                  
                  ,:S-ITEM-ID                                           
                  ,:S-DATE-CREATED                                      
                  ,:S-ACCOUNT-NO                                        
                  ,:S-PREMISE-NO                                        
                  ,:S-CUSTOMER-NO                                       
                  ,:S-STATUS                                            
                  ,:S-USER-ID-ORIG                                      
                  ,:S-USER-ID-ASGN                                      
                  ,:S-RESP-AREA-ID                                      
                  ,:S-COMPLETE-DATE                                     
                  ,:S-CATEGORY-ID                                       
                  ,:S-DATE-REQUIRED                                     
                  ,:S-PRIORITY                                          
                  ,:S-WQ-ERROR-CD                                       
                  ,:S-LAST-UPDATE-TS                                    
                  ,:S-ADDRESS-LINE1                                     
                  ,:S-ADDRESS-LINE2                                     
                  ,:S-ZIP-CODE                                          
                  ,:S-PHONE-NO                                          
                  ,:S-FULL-NAME                                         
                  ,:S-LOCAL-OFFICE                                      
                  ,:S-BILL-CYCLE                                        
                  ,:S-MST-SUB-ACCT-IND                                  
                  ,:S-ASSIGN-HIST-IND                                   
                  ,:S-TASKS-COUNT                                       
                  ,:S-COMMENTS                                          
                  ,:S-FREE-FORM-AREA                                    
A00509            ,:S-TOTAL-RECORDS                                     
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04674_R1                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,ITEM_ID                                                      
MFA-TR*           ,DATE_CREATED                                                 
MFA-TR*           ,ACCOUNT_NO                                                   
MFA-TR*           ,PREMISE_NO                                                   
MFA-TR*           ,CUSTOMER_NO                                                  
MFA-TR*           ,STATUS                                                       
MFA-TR*           ,USER_ID_ORIG                                                 
MFA-TR*           ,USER_ID_ASGN                                                 
MFA-TR*           ,RESP_AREA_ID                                                 
MFA-TR*           ,COMPLETE_DATE                                                
MFA-TR*           ,CATEGORY_ID                                                  
MFA-TR*           ,DATE_REQUIRED                                                
MFA-TR*           ,PRIORITY                                                     
MFA-TR*           ,WQ_ERROR_CD                                                  
MFA-TR*           ,LAST_UPDATE_TS                                               
MFA-TR*           ,ADDRESS_LINE1                                                
MFA-TR*           ,ADDRESS_LINE2                                                
MFA-TR*           ,ZIP_CODE                                                     
MFA-TR*           ,PHONE_NO                                                     
MFA-TR*           ,FULL_NAME                                                    
MFA-TR*           ,LOCAL_OFFICE                                                 
MFA-TR*           ,BILL_CYCLE                                                   
MFA-TR*           ,MST_SUB_ACCT_IND                                             
MFA-TR*           ,ASSIGN_HIST_IND                                              
MFA-TR*           ,TASKS_COUNT                                                  
MFA-TR*           ,COMMENTS                                                     
MFA-TR*           ,FREE_FORM_AREA                                               
MFA-TR*           ,TOTAL_RECORDS                                                
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE                                               
MFA-TR*           ,:S-APPL-RETURN-CODE                                          
MFA-TR*           ,:S-ITEM-ID                                                   
MFA-TR*           ,:S-DATE-CREATED                                              
MFA-TR*           ,:S-ACCOUNT-NO                                                
MFA-TR*           ,:S-PREMISE-NO                                                
MFA-TR*           ,:S-CUSTOMER-NO                                               
MFA-TR*           ,:S-STATUS                                                    
MFA-TR*           ,:S-USER-ID-ORIG                                              
MFA-TR*           ,:S-USER-ID-ASGN                                              
MFA-TR*           ,:S-RESP-AREA-ID                                              
MFA-TR*           ,:S-COMPLETE-DATE                                             
MFA-TR*           ,:S-CATEGORY-ID                                               
MFA-TR*           ,:S-DATE-REQUIRED                                             
MFA-TR*           ,:S-PRIORITY                                                  
MFA-TR*           ,:S-WQ-ERROR-CD                                               
MFA-TR*           ,:S-LAST-UPDATE-TS                                            
MFA-TR*           ,:S-ADDRESS-LINE1                                             
MFA-TR*           ,:S-ADDRESS-LINE2                                             
MFA-TR*           ,:S-ZIP-CODE                                                  
MFA-TR*           ,:S-PHONE-NO                                                  
MFA-TR*           ,:S-FULL-NAME                                                 
MFA-TR*           ,:S-LOCAL-OFFICE                                              
MFA-TR*           ,:S-BILL-CYCLE                                                
MFA-TR*           ,:S-MST-SUB-ACCT-IND                                          
MFA-TR*           ,:S-ASSIGN-HIST-IND                                           
MFA-TR*           ,:S-TASKS-COUNT                                               
MFA-TR*           ,:S-COMMENTS                                                  
MFA-TR*           ,:S-FREE-FORM-AREA                                            
MFA-TR*           ,:S-TOTAL-RECORDS                                             
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                     TO  CTR-ROWS                   
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8100'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04674_R1'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
        8100-EXIT.                                                      
            EXIT.                                                       
      ******************************************************************        
      * 9700-ABEND-PROCESSING.                                         *        
      ******************************************************************        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT.             
           PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT.             
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * END PROGRAM COPYLIB                                            *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CPD00320                                                 
           END-EXEC.                                                            
                                                                        
