       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04672.                                         
       AUTHOR.        GOKUL SATHIYAMOORTHY.                             
COB303 DATE-WRITTEN.  SEP 04, 2013.                                     
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  CSR04672 RETRIEVE SP FOR CREDIT ARRANGEMENTS MAINTAIN VIEW    *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM RETURNS EXISTING CREDIT ARRANGEMENTS                      
      *  RESULTS SETS:                                                 *        
      *     1.  STA PLAN ARRANGEMENTS                                  *        
      *     2.  ARRANGEMENT DETAILS                                    *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
P00726*  09/04/13  GOKUL      INITIAL IMPLEMENTATION.                  *        
P0726A*  09/30/13  VENKAT V   ADDED MORE EXTENSION DETAILS.            *        
P0726B*  02/19/14  AA97148    CREDIT ARRANGEMENTS - RELEASE 2 CHANGES  *        
P0726C*  07/02/14  SS42021    CREDIT ARRANGEMENTS - RELEASE 3 CHANGES  *        
P0726D*  07/21/14  VV94890    ADDED CANCEL COMMENTS,CT METER ATTR TO RS*        
P0726E*  09/17/14  VV94890    FIXED ARNG SETUP COMMENTS.               *        
P0726E*  09/18/14  GOKUL      RELEASE 4.1 CHANGES - CHANGE CREDIT      *        
P0726E*                       ACTION FLAG FOR GROUP 1 SENIOR.          *        
P00948*  06/16/16  AA97148    LEAST AMOUNT TO PAY CHANGES.             *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04672'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                      PIC X(40) VALUE                
           'WORKING STORAGE FOR CSR04672 STARTS HERE'.                  
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME              PIC X(08)  VALUE 'CSR04672'.   
           05  WS-PGRMNAME               PIC X(08)  VALUE 'CSR04672'.   
           05  WS-AUTOCARD-SETUP-FL      PIC X(01)  VALUE 'N'.          
P0726B     05  WS-ARNG-TBL-COUNT         PIC S9(9)  COMP VALUE 0.       
P0726B     05  WS-CREDIT-ACTION-FL       PIC X(01)  VALUE 'N'.          
P0726B     05  WS-PENDING-SO-FLAG        PIC X(01)  VALUE 'N'.          
P0726B     05  WS-DATE-BILL-00-IND       PIC S9(04) COMP VALUE +0.      
P0726B     05  WS-DATE-BILL-30-IND       PIC S9(04) COMP VALUE +0.      
P0726B     05  WS-DATE-BILL-60-IND       PIC S9(04) COMP VALUE +0.      
P0726B     05  WS-DATE-BILL-90-IND       PIC S9(04) COMP VALUE +0.      
P0726B     05  MCSCB068                  PIC X(08)  VALUE 'MCSCB068'.   
P0726B     05  WS-TOTAL-ARREARS          PIC S9(9)V99 COMP-3 VALUE 0.   
P0726C     05  WS-FLEX-COMMENTS          PIC X(255)  VALUE SPACES.      
P0726D     05  WS-CANCEL-COMMENTS        PIC X(255)  VALUE SPACES.      
P0726C     05  WS-FLEX-ARNGMNT           PIC X(01)   VALUE SPACES.      
P0726E     05  WS-GROUP1-TO-GROUP2-FL    PIC X(01)  VALUE 'N'.          
P0726E     05  WS-ACCT-ATTRIBUTE-FL      PIC X(01)  VALUE 'N'.          
P00948     05  WS-LEAST-AMT-DUE-CD       PIC X(13)  VALUE               
P00948                                       'LEAST-AMT-DUE'.           
P00948     05  WS-LEAST-AMOUNT-DUE       PIC S9(4)V9(5) USAGE COMP-3    
P00948                                              VALUE 0.            
           05  WS-CURRENT-DATE           PIC X(10)  VALUE SPACES.       
           05  WS-DATE-CCYY-MM-DD.                                      
               10  WS-DATE-CCYY          PIC X(04)  VALUE SPACES.       
               10  FILLER                PIC X(01)  VALUE SPACES.       
               10  WS-DATE-MM            PIC X(02)  VALUE SPACES.       
               10  FILLER                PIC X(01)  VALUE SPACES.       
               10  WS-DATE-DD            PIC X(02)  VALUE SPACES.       
           05  WS-DATE-MM-DD-YYYY.                                      
               10  WS-DATE2-MM           PIC X(02)  VALUE SPACES.       
               10  FILLER                PIC X(01)  VALUE '/'.          
               10  WS-DATE2-DD           PIC X(02)  VALUE SPACES.       
               10  FILLER                PIC X(01)  VALUE '/'.          
               10  WS-DATE2-CCYY         PIC X(04)  VALUE SPACES.       
                                                                        
P0726E 01  WS-SWITCHES.                                                 
P0726E     05  WS-DATABASE               PIC 9(01)  VALUE ZERO.         
P0726E         88 CSR-DATABASE                      VALUE 1.            
P0726E         88 SEB-DATABASE                      VALUE 2.            
P0726E     05  WS-REG-GROUP              PIC X(03)  VALUE SPACES.       
P0726E         88 WS-DEREG                          VALUE ' '.          
P0726E         88 WS-REG                            VALUE '100', '200'. 
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS-RS1              PIC S9(9)  COMP VALUE 0.       
           05  CTR-ROWS-RS2              PIC S9(9)  COMP VALUE 0.       
           05  CTR-ROWS-RS3              PIC S9(9)  COMP VALUE 0.       
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  GTT-RETURN-FIELDS-1.                                     
               10 S-R1-RETURN-CODE       PIC S9(9)  COMP VALUE 0.       
               10 S-R1-ARNG-ID           PIC X(05)  VALUE SPACES.       
               10 S-R1-ARNG-TYPE         PIC X(10)  VALUE SPACES.       
               10 S-R1-ARNG-SEQ          PIC S9(4)  COMP VALUE 0.       
               10 S-R1-ARNG-SETUP-DT     PIC X(10)  VALUE SPACES.       
               10 S-R1-ARNG-COMPL-CD     PIC X(01)  VALUE SPACES.       
               10 S-R1-ARNG-STATUS-CD    PIC X(01)  VALUE SPACES.       
               10 S-R1-ARNG-DUE-DT       PIC X(10)  VALUE SPACES.       
               10 S-R1-ARNG-AMOUNT       PIC S9(11)V99  COMP-3 VALUE +0.
               10 S-R1-SETUP-COMMENTS    PIC X(255) VALUE SPACES.       
               10 S-R1-ARNG-REMAINING-AMT PIC S9(11)V99 COMP-3 VALUE +0.
P0726A         10 S-R1-ARNG-CONFIRM-NO    PIC X(20)  VALUE SPACES.      
P0726A         10 S-R1-ORIGINAL-DUE-DT    PIC X(10)  VALUE SPACES.      
P0726A         10 S-R1-LAST-UPDATE-USERID PIC X(07)  VALUE SPACES.      
P0726A         10 S-R1-DNP-DATE           PIC X(10)  VALUE SPACES.      
P0726B         10 S-R1-ARNG-PLAN-DESC    PIC X(50)   VALUE SPACES.      
P0726B         10 S-R1-MAJOR-ATTR-FL     PIC X(01)  VALUE SPACES.       
P0726B         10 S-R1-NONRES-ATTR-FL    PIC X(01)  VALUE SPACES.       
P0726B         10 S-R1-CREDIT-ACTION-FL  PIC X(01)  VALUE SPACES.       
P0726B         10 S-R1-APPL-RETURN-CODE  PIC S9(9)  COMP VALUE 0.       
P0726A         10 S-R1-ORIGINAL-DNP-DT    PIC X(10)  VALUE SPACES.      
P0726A         10 S-R1-FIRST-NOT-MAIL-DT  PIC X(10)  VALUE SPACES.      
P0726A         10 S-R1-FINAL-NOT-MAIL-DT  PIC X(10)  VALUE SPACES.      
P0726A         10 S-R1-ARNG-DNP-DT        PIC X(10)  VALUE SPACES.      
P0726A         10 S-R1-FLEX-ARNGMNT       PIC X(01)  VALUE SPACES.      
P0726A         10 S-R1-FLEX-COMMENTS      PIC X(255) VALUE SPACES.      
P0726D         10 S-R1-CANCEL-COMMENTS    PIC X(255) VALUE SPACES.      
P0726D         10 S-R1-KR361-CT-METER-ATTR PIC X(01) VALUE SPACES.      
                                                                        
       01  CSRERLOG-P.                                                  
           05  S-SP-NAME                 PIC X(18)  VALUE SPACES.       
           05  S-SQLCODE                 PIC S9(9)  COMP  VALUE 0.      
           05  S-SQLSTATE                PIC X(5)   VALUE ' '.          
           05  S-TABLE-NAME              PIC X(18)  VALUE SPACES.       
           05  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4)  USAGE COMP.         
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           05  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4)  USAGE COMP.         
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           05  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4)  USAGE COMP.         
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           05  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4)  USAGE COMP.         
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
           05  WS-SQLSTATE               PIC X(05)  VALUE SPACES.       
           05  WS-GTT-NAME               PIC X(19)  VALUE SPACES.       
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************06330000
P0726A* CSS_ACCOUNT  - AT                                              *06340000
      ******************************************************************06350000
      *                                                                         
P0726A     EXEC SQL                                                     00660000
P0726A        INCLUDE TBACCT                                            00670000
P0726A     END-EXEC.                                                    00680000
      *                                                                         
P0726B******************************************************************        
P0726B*    CSS_ARNG_PLAN       - UF                                    *        
P0726B******************************************************************        
P0726B                                                                  
P0726B     EXEC SQL                                                             
P0726B        INCLUDE TBARGPLN                                                  
P0726B     END-EXEC.                                                            
P0726B                                                                  
P0726B******************************************************************        
P0726B*    CSS_ARNG_ATTR       - UY                                    *        
P0726B******************************************************************        
P0726B                                                                  
P0726B     EXEC SQL                                                             
P0726B        INCLUDE TBARGATT                                                  
P0726B     END-EXEC.                                                            
P0726B                                                                  
P0726B******************************************************************        
P0726B*    CSS_ARNG_OPTN_ATTR  - VH                                    *        
P0726B******************************************************************        
P0726B                                                                  
P0726B     EXEC SQL                                                             
P0726B        INCLUDE TBARGOPA                                                  
P0726B     END-EXEC.                                                            
P0726B                                                                  
P0726B******************************************************************        
P0726B*    CSS_BILLING_HDR     - BI                                    *        
P0726B******************************************************************        
P0726B                                                                  
P0726B     EXEC SQL                                                             
P0726B        INCLUDE TBBLLHDR                                                  
P0726B     END-EXEC.                                                            
P0726B                                                                  
      ******************************************************************        
      *    CSS_CRED_ARNGMENT   - X1                                    *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCRARNG                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_CRED_ARNG_HIST  - WY                                    *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCRARHS                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_CRED_ARNG_SCHD  - WX                                    *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCRARSC                                                  
           END-EXEC.                                                            
                                                                        
P0726E******************************************************************        
P0726E*    CSS_DELINQUENCY     - C8                                    *        
P0726E******************************************************************        
P0726E                                                                  
P0726E     EXEC SQL                                                             
P0726E        INCLUDE TBDELQ                                                    
P0726E     END-EXEC.                                                            
P0726E                                                                  
P0726E******************************************************************        
P0726E*    CSS_ACCT_ATTRIBUTE  - YP                                    *        
P0726E******************************************************************        
P0726E                                                                  
P0726E     EXEC SQL                                                             
P0726E        INCLUDE TBACTATT                                                  
P0726E     END-EXEC.                                                            
P0726E                                                                  
P0726B******************************************************************        
P0726B*    CSS_REG_PROFILE     - LR                                    *        
P0726B******************************************************************        
P0726B                                                                  
P0726B     EXEC SQL                                                             
P0726B        INCLUDE TBREGPRF                                                  
P0726B     END-EXEC.                                                            
P0726B                                                                  
P0726B**************************************************************            
P0726B*    CSS_SO_DATA         - VO                                             
P0726B**************************************************************            
P0726B                                                                  
P0726B     EXEC SQL                                                             
P0726B        INCLUDE TBSODAT                                                   
P0726B     END-EXEC.                                                            
P0726B                                                                  
P0726B******************************************************************        
      * ERROR HANDLING                                                 *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * SUPPORTS DB2 AND SQL ERROR CHECKING                            *        
      ******************************************************************        
                                                                        
           COPY CWS00303.                                                       
                                                                        
           COPY CWS00056.                                               01680000
                                                                        
      ******************************************************************        
      * WORKING STORAGE COPYBOOKS FOR CPD00068                         *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS00068                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * WORKING STORAGE COPYBOOKS FOR CPD00309                         *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     01720000
              INCLUDE CWS00309                                          01730000
           END-EXEC.                                                    01740000
                                                                        
      ******************************************************************        
      * WORKING STORAGE COPYBOOKS FOR CPDKR361                         *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     01720000
              INCLUDE CWSKR361                                          01730000
           END-EXEC.                                                    01740000
                                                                        
      ******************************************************************        
      *    DECLARE CURSOR TO GET ARNG DETAILS                          *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
              DECLARE ARNG_DTLS CURSOR FOR                              
                 SELECT                                                 
                      X1.ARNG_ID                                        
                     ,X1.ARNG_TYPE                                      
                     ,X1.CRED_ARNG_SEQ                                  
                     ,X1.ARNG_SETUP_DT                                  
                     ,X1.ARNG_COMPLIANCE_CD                             
                     ,X1.ARNG_STATUS_CD                                 
P0726A               ,X1.ARNG_CONFIRM_NO                                
P00948               ,COALESCE(X1.ORIGINAL_DUE_DT,IIF(TRY_CONVERT(DATE, 
              '1901-01-01') IS NULL OR (PATINDEX('%.%', '1901-01-01'
              ) <> 0) OR (LEN('1901-01-01') <> 10), CIS.CHAR2DATE(
              '1901-01-01'), CONVERT(DATE, '1901-01-01') ))           
P0726B               ,X1.ARNG_OPTION_ID                                 
                     ,WX.ARNG_SCHD_DUE_DT                               
                     ,WX.ARNG_SCHD_PYMT_AMT                             
                     ,WY.CHANGE_COMMENTS                                
                     ,COALESCE(CH.TOTAL_AR_BALANCE,0)                     
P0726B               ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           WY.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS        
P0726C               ,COALESCE(X1.ORIGINAL_DNP_DT,IIF(TRY_CONVERT(DATE, 
              '1901-01-01') IS NULL OR (PATINDEX('%.%', '1901-01-01'
              ) <> 0) OR (LEN('1901-01-01') <> 10), CIS.CHAR2DATE(
              '1901-01-01'), CONVERT(DATE, '1901-01-01') ))           
P0726C               ,COALESCE(X1.FIRST_NOT_MAIL_DT,
              IIF(TRY_CONVERT(DATE, '1901-01-01'
              ) IS NULL OR (PATINDEX('%.%', '1901-01-01'
              ) <> 0) OR (LEN('1901-01-01') <> 10), CIS.CHAR2DATE(
              '1901-01-01'), CONVERT(DATE, '1901-01-01') ))         
P0726C               ,COALESCE(X1.FINAL_NOT_MAIL_DT,
              IIF(TRY_CONVERT(DATE, '1901-01-01'
              ) IS NULL OR (PATINDEX('%.%', '1901-01-01'
              ) <> 0) OR (LEN('1901-01-01') <> 10), CIS.CHAR2DATE(
              '1901-01-01'), CONVERT(DATE, '1901-01-01') ))         
P0726C               ,COALESCE(X1.ARNG_DNP_DT,IIF(TRY_CONVERT(DATE, 
              '1901-01-01') IS NULL OR (PATINDEX('%.%', '1901-01-01'
              ) <> 0) OR (LEN('1901-01-01') <> 10), CIS.CHAR2DATE(
              '1901-01-01'), CONVERT(DATE, '1901-01-01') ))               
P0726C               ,COALESCE(FX.ARNG_CHANGE_CD,' ')                     
P0726C               ,COALESCE(FX.CHANGE_COMMENTS,' ')                    
P0726D               ,COALESCE(CH.CHANGE_COMMENTS,' ')                    
                  FROM                                                  
                       CSS_CRED_ARNG_SCHD WX WITH(READUNCOMMITTED)              
                      ,CSS_CRED_ARNG_HIST WY WITH(READUNCOMMITTED)              
                      ,CSS_CRED_ARNGMENT  X1 WITH(READUNCOMMITTED)              
                      LEFT OUTER JOIN CSS_CRED_ARNG_HIST CH
                           WITH(READUNCOMMITTED)             
                        ON CH.ACCOUNT_NO     = X1.ACCOUNT_NO            
                       AND CH.ARNG_ID        =  X1.ARNG_ID              
                       AND CH.CRED_ARNG_SEQ  =  X1.CRED_ARNG_SEQ        
                       AND CH.ARNG_CHANGE_CD IN ('C','M')               
                      LEFT OUTER JOIN CSS_CRED_ARNG_HIST FX
                           WITH(READUNCOMMITTED)             
                        ON FX.ACCOUNT_NO     = X1.ACCOUNT_NO            
                       AND FX.ARNG_ID        =  X1.ARNG_ID              
                       AND FX.CRED_ARNG_SEQ  =  X1.CRED_ARNG_SEQ        
                       AND FX.ARNG_CHANGE_CD =  'F'                     
                 WHERE X1.ACCOUNT_NO     = :X1-ACCOUNT-NO               
                   AND X1.ACCOUNT_NO     =  WX.ACCOUNT_NO               
                   AND X1.ACCOUNT_NO     =  WY.ACCOUNT_NO               
                   AND X1.ARNG_ID        =  WX.ARNG_ID                  
                   AND X1.ARNG_ID        =  WY.ARNG_ID                  
                   AND X1.CRED_ARNG_SEQ  =  WX.CRED_ARNG_SEQ            
                   AND X1.CRED_ARNG_SEQ  =  WY.CRED_ARNG_SEQ            
                   AND WY.ARNG_CHANGE_CD =  'S'                         
                   AND WX.ARNG_SCHD_SEQ  = 1                            
                   FOR READ ONLY                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE ARNG_DTLS CURSOR FOR                                      
MFA-TR*          SELECT                                                         
MFA-TR*               X1.ARNG_ID                                                
MFA-TR*              ,X1.ARNG_TYPE                                              
MFA-TR*              ,X1.CRED_ARNG_SEQ                                          
MFA-TR*              ,X1.ARNG_SETUP_DT                                          
MFA-TR*              ,X1.ARNG_COMPLIANCE_CD                                     
MFA-TR*              ,X1.ARNG_STATUS_CD                                         
MFA-TR*              ,X1.ARNG_CONFIRM_NO                                        
MFA-TR*              ,IFNULL(X1.ORIGINAL_DUE_DT,'1901-01-01')                   
MFA-TR*              ,X1.ARNG_OPTION_ID                                         
MFA-TR*              ,WX.ARNG_SCHD_DUE_DT                                       
MFA-TR*              ,WX.ARNG_SCHD_PYMT_AMT                                     
MFA-TR*              ,WY.CHANGE_COMMENTS                                        
MFA-TR*              ,IFNULL(CH.TOTAL_AR_BALANCE,0)                             
MFA-TR*              ,WY.LAST_UPDATE_TS                                         
MFA-TR*              ,IFNULL(X1.ORIGINAL_DNP_DT,'1901-01-01')                   
MFA-TR*              ,IFNULL(X1.FIRST_NOT_MAIL_DT,'1901-01-01')                 
MFA-TR*              ,IFNULL(X1.FINAL_NOT_MAIL_DT,'1901-01-01')                 
MFA-TR*              ,IFNULL(X1.ARNG_DNP_DT,'1901-01-01')                       
MFA-TR*              ,IFNULL(FX.ARNG_CHANGE_CD,' ')                             
MFA-TR*              ,IFNULL(FX.CHANGE_COMMENTS,' ')                            
MFA-TR*              ,IFNULL(CH.CHANGE_COMMENTS,' ')                            
MFA-TR*           FROM                                                          
MFA-TR*                CSS_CRED_ARNG_SCHD WX                                    
MFA-TR*               ,CSS_CRED_ARNG_HIST WY                                    
MFA-TR*               ,CSS_CRED_ARNGMENT  X1                                    
MFA-TR*               LEFT OUTER JOIN CSS_CRED_ARNG_HIST CH                     
MFA-TR*                 ON CH.ACCOUNT_NO     = X1.ACCOUNT_NO                    
MFA-TR*                AND CH.ARNG_ID        =  X1.ARNG_ID                      
MFA-TR*                AND CH.CRED_ARNG_SEQ  =  X1.CRED_ARNG_SEQ                
MFA-TR*                AND CH.ARNG_CHANGE_CD IN ('C','M')                       
MFA-TR*               LEFT OUTER JOIN CSS_CRED_ARNG_HIST FX                     
MFA-TR*                 ON FX.ACCOUNT_NO     = X1.ACCOUNT_NO                    
MFA-TR*                AND FX.ARNG_ID        =  X1.ARNG_ID                      
MFA-TR*                AND FX.CRED_ARNG_SEQ  =  X1.CRED_ARNG_SEQ                
MFA-TR*                AND FX.ARNG_CHANGE_CD =  'F'                             
MFA-TR*          WHERE X1.ACCOUNT_NO     = :X1-ACCOUNT-NO                       
MFA-TR*            AND X1.ACCOUNT_NO     =  WX.ACCOUNT_NO                       
MFA-TR*            AND X1.ACCOUNT_NO     =  WY.ACCOUNT_NO                       
MFA-TR*            AND X1.ARNG_ID        =  WX.ARNG_ID                          
MFA-TR*            AND X1.ARNG_ID        =  WY.ARNG_ID                          
MFA-TR*            AND X1.CRED_ARNG_SEQ  =  WX.CRED_ARNG_SEQ                    
MFA-TR*            AND X1.CRED_ARNG_SEQ  =  WY.CRED_ARNG_SEQ                    
MFA-TR*            AND WY.ARNG_CHANGE_CD =  'S'                                 
MFA-TR*            AND WX.ARNG_SCHD_SEQ  = 1                                    
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*         QUERYNO 7510                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-ACCOUNT-NO             PIC 9(13).                       
       01  PARM-ARNG-CHANNEL-CD        PIC X(02).                       
                                                                        
       PROCEDURE DIVISION USING PARM-ACCOUNT-NO                         
                                PARM-ARNG-CHANNEL-CD.                   
                                                                        
      ******************************************************************        
      * 0000-MAINLINE.                                                 *        
      * CONTROLS THE MAIN PATH OF THE PROGRAM                          *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE          THRU 0100-EXIT.             
           PERFORM 1000-PROCESS-INPUT       THRU 1000-EXIT.             
           PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT.             
           PERFORM 9999-END-PROGRAM         THRU 9999-EXIT.             
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1     THRU 0100A-EXIT.            
                                                                        
P0726E* TO IDENTIFY THE DATA BASE                                               
P0726E     MOVE '01'                        TO C8-COMPANY-NO.           
P0726E     MOVE 'DATABASE'                  TO C8-DELINQ-CD.            
P0726E     PERFORM 7010-GET-DLINQ-VAL       THRU 7010-EXIT              
P0726E     MOVE C8-DELINQ-VALUE             TO WS-DATABASE.             
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100A-DECLARE-GTT-R1                                           *        
      ******************************************************************        
                                                                        
       0100A-DECLARE-GTT-R1.                                            
                                                                        
           MOVE 'SESSION.CSR04672_R1'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04672_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04672_R1
              (                                                          
                  RETURN_CODE           INT                         
                 ,ARNG_ID CHAR(05)  COLLATE LATIN1_GENERAL_100_BIN2             
                 ,ARNG_TYPE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2           
                 ,CRED_ARNG_SEQ         SMALLINT                        
                 ,ARNG_SETUP_DATE CHAR(10)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                        
                 ,ARNG_COMPL_CD CHAR(01)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                        
                 ,ARNG_STATUS_CD CHAR(01)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                        
                 ,ARNG_DUE_DATE CHAR(10)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                        
                 ,ARNG_AMOUNT           DECIMAL(11,2)                   
                 ,ARNG_SETUP_CMNTS CHAR(255)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                       
                 ,ARNG_REMAINING_AMOUNT DECIMAL(11,2)                   
P0726A           ,ARNG_CONFIRM_NO CHAR(20)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                        
P0726A           ,ORIGINAL_DUE_DT CHAR(10)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                        
P0726A           ,LAST_UPDATE_USERID CHAR(07)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                        
P0726A           ,DNP_DATE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2            
P0726B           ,ARNG_PLAN_DESC CHAR(50)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                        
P0726B           ,MAJOR_ATTR_FL CHAR(01)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                        
P0726B           ,NONRES_ATTR_FL CHAR(01)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                        
P0726B           ,CREDIT_ACTION_FL CHAR(01)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                        
P0726B           ,APPL_RETURN_CODE      INT                         
P0726C           ,ORIGINAL_DNP_DT CHAR(10)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                        
P0726C           ,FIRST_NOT_MAIL_DT CHAR(10)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                        
P0726C           ,FINAL_NOT_MAIL_DT CHAR(10)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                        
P0726C           ,ARNG_DNP_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2         
P0726C           ,FLEX_ARNGMNT CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2         
P0726C           ,FLEX_COMMENTS CHAR(255)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                       
P0726D           ,CANCEL_COMMENTS CHAR(255)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                       
P0726D           ,CT_METER_ATTR CHAR(01)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                        
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE   = SUCCESSFUL-CALL              
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE '0100A'               TO ACTIVE-PARAGRAPH         
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
               SELECT                                                   
                  RETURN_CODE                                           
                 ,LTRIM(RTRIM(ARNG_ID))            AS ARNG_ID                  
                 ,LTRIM(RTRIM(ARNG_TYPE))          AS ARNG_TYPE                
                 ,CRED_ARNG_SEQ             AS ARNG_SEQ_NO              
                 ,LTRIM(RTRIM(ARNG_SETUP_DATE))    AS ARNG_SETUP_DATE          
                 ,LTRIM(RTRIM(ARNG_COMPL_CD))      AS ARNG_COMPL_CD            
                 ,LTRIM(RTRIM(ARNG_STATUS_CD))     AS ARNG_STATUS_CD           
                 ,LTRIM(RTRIM(ARNG_DUE_DATE))      AS ARNG_DUE_DATE            
                 ,ARNG_AMOUNT               AS ARNG_AMOUNT              
                 ,LTRIM(RTRIM(ARNG_SETUP_CMNTS))   AS ARNG_SETUP_CMNTS         
                 ,ARNG_REMAINING_AMOUNT     AS ARNG_REMAINING_AMOUNT    
P0726A           ,LTRIM(RTRIM(ARNG_CONFIRM_NO))    AS ARNG_CONFIRM_NO          
P0726A           ,LTRIM(RTRIM(ORIGINAL_DUE_DT))    AS ORIGINAL_DUE_DT          
P0726A           ,LTRIM(RTRIM(LAST_UPDATE_USERID)) AS LAST_UPDATE_USERID       
P0726A           ,LTRIM(RTRIM(DNP_DATE))           AS DNP_DATE                 
P0726B           ,LTRIM(RTRIM(ARNG_PLAN_DESC))     AS ARNG_PLAN_DESC           
P0726B           ,LTRIM(RTRIM(MAJOR_ATTR_FL))      AS MAJOR_ATTR_FL            
P0726B           ,LTRIM(RTRIM(NONRES_ATTR_FL))     AS NONRES_ATTR_FL           
P0726B           ,LTRIM(RTRIM(CREDIT_ACTION_FL))   AS CREDIT_ACTION_FL         
P0726B           ,APPL_RETURN_CODE                                      
P0726C           ,ORIGINAL_DNP_DT                                       
P0726C           ,FIRST_NOT_MAIL_DT                                     
P0726C           ,FINAL_NOT_MAIL_DT                                     
P0726C           ,ARNG_DNP_DT                                           
P0726C           ,FLEX_ARNGMNT                                          
P0726C           ,FLEX_COMMENTS                                         
P0726D           ,CANCEL_COMMENTS                                       
P0726D           ,CT_METER_ATTR                                         
               FROM #CSR04672_R1                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*        SELECT                                                           
MFA-TR*           RETURN_CODE                                                   
MFA-TR*          ,STRIP(ARNG_ID)            AS ARNG_ID                          
MFA-TR*          ,STRIP(ARNG_TYPE)          AS ARNG_TYPE                        
MFA-TR*          ,CRED_ARNG_SEQ             AS ARNG_SEQ_NO                      
MFA-TR*          ,STRIP(ARNG_SETUP_DATE)    AS ARNG_SETUP_DATE                  
MFA-TR*          ,STRIP(ARNG_COMPL_CD)      AS ARNG_COMPL_CD                    
MFA-TR*          ,STRIP(ARNG_STATUS_CD)     AS ARNG_STATUS_CD                   
MFA-TR*          ,STRIP(ARNG_DUE_DATE)      AS ARNG_DUE_DATE                    
MFA-TR*          ,ARNG_AMOUNT               AS ARNG_AMOUNT                      
MFA-TR*          ,STRIP(ARNG_SETUP_CMNTS)   AS ARNG_SETUP_CMNTS                 
MFA-TR*          ,ARNG_REMAINING_AMOUNT     AS ARNG_REMAINING_AMOUNT            
MFA-TR*          ,STRIP(ARNG_CONFIRM_NO)    AS ARNG_CONFIRM_NO                  
MFA-TR*          ,STRIP(ORIGINAL_DUE_DT)    AS ORIGINAL_DUE_DT                  
MFA-TR*          ,STRIP(LAST_UPDATE_USERID) AS LAST_UPDATE_USERID               
MFA-TR*          ,STRIP(DNP_DATE)           AS DNP_DATE                         
MFA-TR*          ,STRIP(ARNG_PLAN_DESC)     AS ARNG_PLAN_DESC                   
MFA-TR*          ,STRIP(MAJOR_ATTR_FL)      AS MAJOR_ATTR_FL                    
MFA-TR*          ,STRIP(NONRES_ATTR_FL)     AS NONRES_ATTR_FL                   
MFA-TR*          ,STRIP(CREDIT_ACTION_FL)   AS CREDIT_ACTION_FL                 
MFA-TR*          ,APPL_RETURN_CODE                                              
MFA-TR*          ,ORIGINAL_DNP_DT                                               
MFA-TR*          ,FIRST_NOT_MAIL_DT                                             
MFA-TR*          ,FINAL_NOT_MAIL_DT                                             
MFA-TR*          ,ARNG_DNP_DT                                                   
MFA-TR*          ,FLEX_ARNGMNT                                                  
MFA-TR*          ,FLEX_COMMENTS                                                 
MFA-TR*          ,CANCEL_COMMENTS                                               
MFA-TR*          ,CT_METER_ATTR                                                 
MFA-TR*        FROM SESSION.CSR04672_R1                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT.                                            *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-ACCOUNT-NO               TO X1-ACCOUNT-NO          
P0726B                                           LR-ACCOUNT-NO          
P0726B                                           VO-ACCOUNT-NO          
P0726B                                           BI-ACCOUNT-NO          
P0726A                                           AT-ACCOUNT-NO.         
P0726E     MOVE 'N'                           TO WS-GROUP1-TO-GROUP2-FL.
P0726E     MOVE SPACES                        TO LR-REG-GROUP-CD.       
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
P0726B* INITIALIZE                                                              
P0726B     MOVE 'N'                       TO WS-CREDIT-ACTION-FL        
P0726B                                       WS-PENDING-SO-FLAG.        
P0726B     MOVE 0                         TO S-R1-RETURN-CODE.          
P0726B                                                                  
P0726B     PERFORM 7730-GET-CURRENT-DATE           THRU 7730-EXIT.      
P0726B     PERFORM 7600-SELECT-ACCOUNT             THRU 7600-EXIT.      
P0726B     MOVE AT-CODES-DATA-PRESENT     TO WS-CODES-DATA-PRESENT.     
P0726B     PERFORM 2120-CALL-MCSCB068              THRU 2120-EXIT.      
P0726B     PERFORM 2130-VALIDATE-CREDIT-ACTION     THRU 2130-EXIT.      
                                                                        
           PERFORM 7500-OPEN-ARNG-DTLS-CURSOR      THRU 7500-EXIT.      
           PERFORM 7510-FETCH-ARNG-DTLS            THRU 7510-EXIT.      
           PERFORM 2100-BUILD-ARNG-RESULT-SET      THRU 2100-EXIT       
                UNTIL SQLCODE = NOT-FOUND.                              
           PERFORM 7520-CLOSE-ARNG-DTLS-CURSOR     THRU 7520-EXIT.      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2100-BUILD-ARNG-RESULT-SET.                                    *        
      ******************************************************************        
                                                                        
       2100-BUILD-ARNG-RESULT-SET.                                      
                                                                        
           MOVE X1-ARNG-ID                TO S-R1-ARNG-ID               
           MOVE X1-ARNG-TYPE              TO S-R1-ARNG-TYPE             
           MOVE X1-CRED-ARNG-SEQ          TO S-R1-ARNG-SEQ              
           MOVE X1-ARNG-SETUP-DT          TO S-R1-ARNG-SETUP-DT         
           MOVE X1-ARNG-COMPLIANCE-CD     TO S-R1-ARNG-COMPL-CD         
           MOVE X1-ARNG-STATUS-CD         TO S-R1-ARNG-STATUS-CD        
P0726A     MOVE X1-ARNG-CONFIRM-NO        TO S-R1-ARNG-CONFIRM-NO       
P0726A     MOVE X1-ORIGINAL-DUE-DT        TO S-R1-ORIGINAL-DUE-DT       
P0726A     MOVE SPACES                    TO S-R1-DNP-DATE              
           MOVE WX-ARNG-SCHD-DUE-DT       TO S-R1-ARNG-DUE-DT           
           MOVE WX-ARNG-SCHD-PYMT-AMT     TO S-R1-ARNG-AMOUNT           
           MOVE WY-CHANGE-COMMENTS-TEXT   TO S-R1-SETUP-COMMENTS        
P0726C     MOVE X1-ORIGINAL-DNP-DT        TO S-R1-ORIGINAL-DNP-DT       
P0726C     MOVE X1-FIRST-NOT-MAIL-DT      TO S-R1-FIRST-NOT-MAIL-DT     
P0726C     MOVE X1-FINAL-NOT-MAIL-DT      TO S-R1-FINAL-NOT-MAIL-DT     
P0726C     MOVE X1-ARNG-DNP-DT            TO S-R1-ARNG-DNP-DT           
P0726C     MOVE WS-FLEX-ARNGMNT           TO S-R1-FLEX-ARNGMNT          
P0726C     IF WS-FLEX-ARNGMNT = 'Y'                                     
P0726C        MOVE WS-FLEX-COMMENTS       TO S-R1-FLEX-COMMENTS         
P0726C     ELSE                                                         
P0726C        MOVE SPACES                 TO S-R1-FLEX-COMMENTS         
P0726C     END-IF                                                       
P0726D     MOVE WS-CANCEL-COMMENTS        TO S-R1-CANCEL-COMMENTS       
P0726A*                                                                         
P0726B     EVALUATE X1-ARNG-TYPE                                        
P0726B      WHEN 'CDD'                                                  
P0726B           MOVE AT-TOTAL-AR-BALANCE TO S-R1-ARNG-REMAINING-AMT    
P0726B      WHEN 'CDDA'                                                 
P0726B           IF AT-DATE-BILL-DAY-00 < X1-ARNG-SETUP-DT              
P0726B              MOVE AT-TOTAL-AR-BALANCE TO S-R1-ARNG-REMAINING-AMT 
P0726B           ELSE                                                   
P0726B              MOVE ZEROES              TO WS-TOTAL-ARREARS        
P0726B              COMPUTE WS-TOTAL-ARREARS  = WS-AMT-ARREARS-UTL +    
P0726B                                          WS-AMT-ARREARS-NONUTL   
P0726B              IF AT-DATE-BILL-DAY-00 = X1-ARNG-SETUP-DT           
P0726B                 PERFORM 7750-SELECT-BILL-DETAILS THRU 7750-EXIT  
P0726B                 IF BI-LAST-UPDATE-TS < WY-LAST-UPDATE-TS         
P0726B                    MOVE AT-TOTAL-AR-BALANCE                      
P0726B                                       TO S-R1-ARNG-REMAINING-AMT 
P0726B                 ELSE                                             
P0726B                    MOVE WS-TOTAL-ARREARS                         
P0726B                                       TO S-R1-ARNG-REMAINING-AMT
                       END-IF 
P0726B              ELSE                                                
P0726B                 MOVE WS-TOTAL-ARREARS TO S-R1-ARNG-REMAINING-AMT 
P0726B              END-IF                                              
P0726B           END-IF                                                 
P0726C      WHEN 'STA'                                                  
P00948      WHEN 'STF'                                                  
P0726C           IF AT-CREDIT-GROUP = 'B'                               
P0726C              MOVE AT-TOTAL-AR-BALANCE TO S-R1-ARNG-REMAINING-AMT 
P0726C           ELSE                                                   
P0726C              MOVE WS-AMT-ARREARS-UTL  TO S-R1-ARNG-REMAINING-AMT 
P0726C           END-IF                                                 
P0726C      WHEN 'STAA'                                                 
P00948      WHEN 'STFA'                                                 
P0726C           IF AT-DATE-BILL-DAY-00 < X1-ARNG-SETUP-DT              
P0726C              MOVE WS-TOTAL-BALANCE-UTL TO S-R1-ARNG-REMAINING-AMT
P0726C           ELSE                                                   
P0726C              MOVE ZEROES              TO WS-TOTAL-ARREARS        
P0726C              COMPUTE WS-TOTAL-ARREARS  = WS-AMT-ARREARS-UTL +    
P0726C                                          WS-AMT-ARREARS-NONUTL   
P0726C              IF AT-DATE-BILL-DAY-00 = X1-ARNG-SETUP-DT           
P0726C                 PERFORM 7750-SELECT-BILL-DETAILS THRU 7750-EXIT  
P0726C                 IF BI-LAST-UPDATE-TS < WY-LAST-UPDATE-TS         
P0726C                    MOVE WS-TOTAL-BALANCE-UTL                     
P0726C                                       TO S-R1-ARNG-REMAINING-AMT 
P0726C                 ELSE                                             
P0726C                    MOVE WS-AMT-ARREARS-UTL                       
P0726C                                       TO S-R1-ARNG-REMAINING-AMT 
P0726C                 END-IF                                           
P0726C              ELSE                                                
P0726C                 MOVE WS-AMT-ARREARS-UTL                          
P0726C                                       TO S-R1-ARNG-REMAINING-AMT 
P0726C              END-IF                                              
P0726C           END-IF                                                 
P0726C     END-EVALUATE.                                                
P00948     IF X1-ARNG-TYPE = 'STF' OR 'STFA'                            
P00948        MOVE WS-LEAST-AMT-DUE-CD    TO C8-DELINQ-CD               
P00948        MOVE AT-COMPANY-NO          TO C8-COMPANY-NO              
P00948        PERFORM 7010-GET-DLINQ-VAL  THRU 7010-EXIT                
P00948        MOVE C8-DELINQ-VALUE        TO WS-LEAST-AMOUNT-DUE        
P00948        COMPUTE S-R1-ARNG-REMAINING-AMT =                         
P00948                S-R1-ARNG-REMAINING-AMT - WS-LEAST-AMOUNT-DUE     
P00948     END-IF.                                                      
P0726A*                                                                         
P0726A     PERFORM 7700-LAST-UPDATE-USERID   THRU 7700-EXIT             
P0726A     MOVE WY-LAST-UPDATE-USERID     TO S-R1-LAST-UPDATE-USERID    
P0726E     MOVE WY-CHANGE-COMMENTS-TEXT   TO S-R1-SETUP-COMMENTS        
P0726B     MOVE WS-CREDIT-ACTION-FL       TO S-R1-CREDIT-ACTION-FL      
P0726A*                                                                         
P0726E     IF SEB-DATABASE                                              
P0726B        PERFORM 7710-SELECT-REG-PROFILE        THRU 7710-EXIT     
P0726E        MOVE LR-REG-GROUP-CD        TO WS-REG-GROUP               
P0726E     END-IF.                                                      
P0726B     PERFORM 7720-SEL-ARNG-PLAN-DESC        THRU 7720-EXIT.       
P0726B     MOVE UF-ARNG-PLAN-DESC         TO S-R1-ARNG-PLAN-DESC.       
P0726B     PERFORM 2110-POPULATE-CPDKR361-DTLS    THRU 2110-EXIT.       
P0726B     MOVE WS-KR361-MAJOR-ATTR-FL    TO S-R1-MAJOR-ATTR-FL.        
P0726B     MOVE WS-KR361-NON-RES-ATTR-FL  TO S-R1-NONRES-ATTR-FL.       
P0726D     MOVE WS-KR361-CT-METER-ATTR-FL TO S-R1-KR361-CT-METER-ATTR.  
P0726B     ADD +1                         TO WS-ARNG-TBL-COUNT.         
P0726B*                                                                         
           PERFORM 8010-INSERT-GTT-R1     THRU 8010-EXIT                
                                                                        
           PERFORM 7510-FETCH-ARNG-DTLS   THRU 7510-EXIT.               
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
P0726B******************************************************************        
P0726B* 2110-POPULATE-CPDKR361-DTLS                                    *        
P0726B******************************************************************        
P0726B                                                                  
P0726B 2110-POPULATE-CPDKR361-DTLS.                                     
P0726B                                                                  
P0726B     MOVE UF-ARNG-PLAN-ID           TO WS-KR361-ARNG-PLAN-ID.     
P0726B     MOVE X1-ARNG-OPTION-ID         TO WS-KR361-ARNG-OPTION-ID.   
P0726B     MOVE X1-ACCOUNT-NO             TO WS-KR361-ACCOUNT-NO.       
P0726B     MOVE AT-CODE-MAJOR-ACCT        TO WS-KR361-MAJOR-IND.        
P0726B     MOVE AT-ACCOUNT-TYPE-CODE      TO WS-KR361-ACCOUNT-TYPE-CD.  
P0726B     MOVE WX-ARNG-SCHD-PYMT-AMT     TO WS-KR361-TOTAL-AMOUNT.     
P0726B                                                                  
P0726B     PERFORM 5000-PROCESS-ARNG-ATTRIBUTES                         
P0726B                                    THRU 5000-CPDKR361-EXIT.      
P0726B                                                                  
P0726B 2110-EXIT.                                                       
P0726B     EXIT.                                                        
P0726B                                                                  
P0726B******************************************************************        
P0726B* 2120-CALL-MCSCB068.                                            *        
P0726B******************************************************************        
P0726B                                                                  
P0726B 2120-CALL-MCSCB068.                                              
P0726B                                                                  
P0726B* SET CPD00068 SWITCHES THAT ARE NEEDED                                   
P0726B                                                                  
P0726B     MOVE WS-CURRENT-DATE           TO WS-HOLD-DATE               
P0726B                                                                  
P0726B     MOVE 'Y' TO CALC-BALANCE-SW                                  
P0726B                 CALC-ARREARS-SW                                  
P0726B                 LOAD-DNP-DATE-SW                                 
P0726B                 LOAD-DUE-DATES-SW                                
P0726B                 CALC-PAST-DUE-SW.                                
P0726B                                                                  
P0726B     MOVE PROGRAM-NAME              TO WS-CPD00068-CALLING-PGM.   
P0726B     MOVE SPACES                    TO ABEND-FUNCTION.            
P0726B     PERFORM 5100-CALL-MCSCB068     THRU 5100-EXIT.               
P0726B                                                                  
P0726B 2120-EXIT.                                                       
P0726B     EXIT.                                                        
P0726B                                                                  
P0726B******************************************************************        
P0726B* 2130-VALIDATE-CREDIT-ACTION                                    *        
P0726B******************************************************************        
P0726B                                                                  
P0726B 2130-VALIDATE-CREDIT-ACTION.                                     
P0726B                                                                  
P0726B     IF WS-DATE-DISC(1:4) NUMERIC AND                             
P0726B        WS-DATE-DISC(6:2) NUMERIC AND                             
P0726B        WS-DATE-DISC(9:2) NUMERIC                                 
P0726B        IF WS-DATE-DISC >= WS-CURRENT-DATE                        
P0726B           MOVE 'Y'                 TO WS-CREDIT-ACTION-FL        
P0726B        END-IF                                                    
P0726B     ELSE                                                         
P0726B        IF WS-DATE-DISC = 'MULTIPLE'                              
P0726B           IF WS-DATE-CREDIT-ACTION-G >= WS-CURRENT-DATE OR       
P0726B              WS-DATE-CREDIT-ACTION-D >= WS-CURRENT-DATE OR       
P0726B              WS-DATE-CREDIT-ACTION-H >= WS-CURRENT-DATE OR       
P0726B              WS-DATE-CREDIT-ACTION-I >= WS-CURRENT-DATE          
P0726B              MOVE 'Y'              TO WS-CREDIT-ACTION-FL        
P0726B           END-IF                                                 
P0726B        END-IF                                                    
P0726B     END-IF.                                                      
P0726B                                                                  
P0726B     IF WS-CREDIT-ACTION-FL = 'N'                                 
P0726B        MOVE 'DNP01'                TO VO-ORDER-TYPE-CD           
P0726B        PERFORM 7740-SELECT-PENDING-SO       THRU 7740-EXIT       
P0726B        IF WS-PENDING-SO-FLAG = 'Y'                               
P0726B           MOVE 'Y'                 TO WS-CREDIT-ACTION-FL        
P0726B        END-IF                                                    
P0726B     END-IF.                                                      
P0726E                                                                  
P0726E     IF LR-REG-GROUP-CD = '100'  AND                              
P0726E        LR-SENIOR-FL = 'Y'                                        
P0726E        MOVE 'FCST CR GP BALANCE'      TO YP-ATTRIBUTE-DESC       
P0726E        PERFORM 7000-ACCOUNT-ATTRIBUTE THRU 7000-EXIT             
P0726E        IF WS-ACCT-ATTRIBUTE-FL = 'Y'                             
P0726E           MOVE 'Y'                    TO WS-GROUP1-TO-GROUP2-FL  
P0726E        END-IF                                                    
P0726E                                                                  
P0726E        IF WS-GROUP1-TO-GROUP2-FL = 'Y' AND                       
P0726E           WS-DATE-NOTICE-MAIL-C > SPACES AND                     
P0726E           WS-AMT-NOTICE-C > WS-NOTICE-DNP-LIMIT                  
P0726E           MOVE 'Y'                    TO WS-CREDIT-ACTION-FL     
P0726E        END-IF                                                    
P0726E     END-IF.                                                      
P0726B                                                                  
P0726B 2130-EXIT.                                                       
P0726B     EXIT.                                                        
P0726B                                                                  
P0726B******************************************************************        
P0726B* 5000-PROCESS-ARNG-ATTRIBUTES                                            
P0726B******************************************************************        
P0726B                                                                  
P0726B     EXEC SQL                                                             
P0726B        INCLUDE CPDKR361                                                  
P0726B     END-EXEC.                                                            
P0726B                                                                  
P0726B******************************************************************        
P0726B* 5100-CALL-MCSCB068.                                            *        
P0726B******************************************************************        
P0726B                                                                  
P0726B 5100-CALL-MCSCB068.                                              
P0726B                                                                  
P0726B     CALL MCSCB068  USING  CWS00068-FIELDS                        
P0726B                           WS-CODES-DATA-PRESENT                  
P0726B                           DCLCSS-ACCOUNT                         
P0726B                           ABEND-FILE                             
P0726B                           S-R1-RETURN-CODE.                      
P0726B                                                                  
P0726B     MOVE S-R1-RETURN-CODE          TO WS-ACTIVE-RETURN-CODE.     
P0726B                                                                  
P0726B     IF ABEND-FUNCTION  > SPACES                                  
P0726B        IF ABEND-FUNCTION EQUAL 'BADDATA'                         
P0726B           MOVE -1                  TO WS-ACTIVE-RETURN-CODE      
P0726B        END-IF                                                    
P0726B        ADD +1 TO CTR-ROWS-RS1                                    
P0726B        PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT                
P0726B     END-IF.                                                      
P0726B                                                                  
P0726B 5100-EXIT.                                                       
P0726B     EXIT.                                                        
P0726B                                                                  
P0726E******************************************************************        
P0726E* 7000-ACCOUNT-ATTRIBUTE                                         *        
P0726E* CHECKS ACCCOUNT ATTRIBUTE                                      *        
P0726E******************************************************************        
P0726E 7000-ACCOUNT-ATTRIBUTE.                                          
P0726E                                                                  
P0726E     EXEC SQL                                                     
P0726E         SELECT TOP(1) ACCOUNT_NO                                        
P0726E           INTO :YP-ACCOUNT-NO                                    
P0726E           FROM CSS_ACCT_ATTRIBUTE WITH(READUNCOMMITTED)                  
P0726E          WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
P0726E            AND ATTRIBUTE_DESC = :YP-ATTRIBUTE-DESC               
P0726E                                           
P0726E                                                           
P0726E                                                      
P0726E     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ACCOUNT_NO                                                
MFA-TR*          INTO :YP-ACCOUNT-NO                                            
MFA-TR*          FROM CSS_ACCT_ATTRIBUTE                                        
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*           AND ATTRIBUTE_DESC = :YP-ATTRIBUTE-DESC                       
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7000                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0726E                                                                  
P0726E     MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
P0726E                                                                  
P0726E     EVALUATE WS-ACTIVE-RETURN-CODE                               
P0726E         WHEN SUCCESSFUL-CALL                                     
P0726E             MOVE 'Y' TO WS-ACCT-ATTRIBUTE-FL                     
P0726E         WHEN NOT-FOUND                                           
P0726E             MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
P0726E             MOVE 'N' TO WS-ACCT-ATTRIBUTE-FL                     
P0726E         WHEN OTHER                                               
P0726E             MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
P0726E             MOVE '7000'               TO ACTIVE-PARAGRAPH        
P0726E             MOVE 'SELECT'             TO ABEND-FUNCTION          
P0726E             MOVE 'CSS_ACCT_ATTRIBUTE' TO TABLE-1                 
P0726E             MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1         
P0726E             MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1       
P0726E             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
P0726E     END-EVALUATE.                                                
P0726E                                                                  
P0726E 7000-EXIT.                                                       
P0726E     EXIT.                                                        
P0726E*****************************************************************         
P0726E* 7010-GET-DLINQ-VAL.                                           *         
P0726E*****************************************************************         
P0726E                                                                  
P0726E 7010-GET-DLINQ-VAL.                                              
P0726E                                                                  
P0726E     EXEC SQL                                                     
P0726E        SELECT C8.DELINQ_VALUE                                    
P0726E          INTO :C8-DELINQ-VALUE                                   
P0726E          FROM CSS_DELINQUENCY C8 WITH(READUNCOMMITTED)                   
P0726E         WHERE C8.DELINQ_CD  = :C8-DELINQ-CD                      
P0726E           AND C8.COMPANY_NO = :C8-COMPANY-NO                     
P0726E                                                           
P0726E                                                      
P0726E     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT C8.DELINQ_VALUE                                            
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY C8                                         
MFA-TR*        WHERE C8.DELINQ_CD  = :C8-DELINQ-CD                              
MFA-TR*          AND C8.COMPANY_NO = :C8-COMPANY-NO                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7010                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0726E                                                                  
P0726E     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
P0726E                                                                  
P0726E     EVALUATE WS-ACTIVE-RETURN-CODE                               
P0726E       WHEN SUCCESSFUL-CALL                                       
P0726E         CONTINUE                                                 
P0726E       WHEN OTHER                                                 
P0726E         MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
P0726E         MOVE SQLCODE                 TO ABEND-SQLCODE            
P0726E         MOVE SQLSTATE                TO ABEND-SQLSTATE           
P0726E         MOVE '7010'                  TO ACTIVE-PARAGRAPH         
P0726E         MOVE 'SELECT'                TO ABEND-FUNCTION           
P0726E         MOVE 'CSS_DELINQUENCY'       TO TABLE-1                  
P0726E         MOVE 'DELINQ_CD'             TO TABLE-ELEMENT-1          
P0726E         MOVE 'COMPANY_NO'            TO TABLE-ELEMENT-2          
P0726E         MOVE C8-DELINQ-CD            TO HOSTVAR-ELEMENT-1        
P0726E         MOVE C8-COMPANY-NO           TO HOSTVAR-ELEMENT-2        
P0726E         PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT              
P0726E     END-EVALUATE.                                                
P0726E                                                                  
P0726E 7010-EXIT.                                                       
P0726E     EXIT.                                                        
P0726E                                                                  
      ******************************************************************        
      * 7500-OPEN-ARNG-DTLS-CURSOR                                              
      ******************************************************************        
                                                                        
       7500-OPEN-ARNG-DTLS-CURSOR.                                      
                                                                        
           EXEC SQL                                                     
              OPEN ARNG_DTLS                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
                    MOVE '7500'               TO ACTIVE-PARAGRAPH       
                    MOVE 'OPEN'               TO ABEND-FUNCTION         
                    MOVE SPACES               TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
                    MOVE 'CSS_CRED_ARNGMENT'  TO TABLE-1                
                    MOVE 'CSS_CRED_ARNG_HIST' TO TABLE-2                
                    MOVE 'CSS_CRED_ARNG_SCHD' TO TABLE-3                
                    PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT         
           END-EVALUATE.                                                
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7510-FETCH-ARNG-DTLS.                                                   
      ******************************************************************        
                                                                        
       7510-FETCH-ARNG-DTLS.                                            
                                                                        
           EXEC SQL                                                     
               FETCH ARNG_DTLS                                          
                INTO :X1-ARNG-ID                                        
                    ,:X1-ARNG-TYPE                                      
                    ,:X1-CRED-ARNG-SEQ                                  
                    ,:X1-ARNG-SETUP-DT                                  
                    ,:X1-ARNG-COMPLIANCE-CD                             
                    ,:X1-ARNG-STATUS-CD                                 
P0726A              ,:X1-ARNG-CONFIRM-NO                                
P0726A              ,:X1-ORIGINAL-DUE-DT                                
P0726B              ,:X1-ARNG-OPTION-ID                                 
                    ,:WX-ARNG-SCHD-DUE-DT                               
                    ,:WX-ARNG-SCHD-PYMT-AMT                             
                    ,:WY-CHANGE-COMMENTS                                
                    ,:WY-TOTAL-AR-BALANCE                               
P0726B              ,:WY-LAST-UPDATE-TS                                 
P0726C              ,:X1-ORIGINAL-DNP-DT                                
P0726C              ,:X1-FIRST-NOT-MAIL-DT                              
P0726C              ,:X1-FINAL-NOT-MAIL-DT                              
P0726C              ,:X1-ARNG-DNP-DT                                    
P0726C              ,:WS-FLEX-ARNGMNT                                   
P0726C              ,:WS-FLEX-COMMENTS                                  
P0726D              ,:WS-CANCEL-COMMENTS                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
P00948              IF X1-ORIGINAL-DUE-DT = '1901-01-01'                
P00948                 MOVE SPACES TO  X1-ORIGINAL-DUE-DT               
P00948              END-IF                                              
                    IF X1-ORIGINAL-DNP-DT = '1901-01-01'                
                       MOVE SPACES TO  X1-ORIGINAL-DNP-DT               
                    END-IF                                              
                    IF X1-FIRST-NOT-MAIL-DT  = '1901-01-01'             
                       MOVE SPACES TO  X1-FIRST-NOT-MAIL-DT             
                    END-IF                                              
                    IF X1-FINAL-NOT-MAIL-DT  = '1901-01-01'             
                       MOVE SPACES TO  X1-FINAL-NOT-MAIL-DT             
                    END-IF                                              
                    IF X1-ARNG-DNP-DT  = '1901-01-01'                   
                       MOVE SPACES TO  X1-ARNG-DNP-DT                   
                    END-IF                                              
                    IF WS-FLEX-ARNGMNT = 'F'                            
                       MOVE 'Y'    TO  WS-FLEX-ARNGMNT                  
                    END-IF                                              
               WHEN NOT-FOUND                                           
                    MOVE ZEROES               TO WS-ACTIVE-RETURN-CODE  
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
                    MOVE '7510'               TO ACTIVE-PARAGRAPH       
                    MOVE 'FETCH'              TO ABEND-FUNCTION         
                    MOVE SPACES               TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
                    MOVE 'CSS_CRED_ARNGMENT'  TO TABLE-1                
                    MOVE 'CSS_CRED_ARNG_HIST' TO TABLE-2                
                    MOVE 'CSS_CRED_ARNG_SCHD' TO TABLE-3                
                    MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1        
                    MOVE X1-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1      
                    PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT         
           END-EVALUATE.                                                
                                                                        
       7510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7520-CLOSE-ARNG-DTLS-CURSOR                                             
      ******************************************************************        
                                                                        
       7520-CLOSE-ARNG-DTLS-CURSOR.                                     
                                                                        
           EXEC SQL                                                     
               CLOSE ARNG_DTLS                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
                    MOVE '7520'               TO ACTIVE-PARAGRAPH       
                    MOVE 'CLOSE'              TO ABEND-FUNCTION         
                    MOVE SPACES               TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
                    MOVE 'CSS_CRED_ARNGMENT'  TO TABLE-1                
                    MOVE 'CSS_CRED_ARNG_HIST' TO TABLE-2                
                    MOVE 'CSS_CRED_ARNG_SCHD' TO TABLE-3                
                    PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT         
           END-EVALUATE.                                                
                                                                        
       7520-EXIT.                                                       
           EXIT.                                                        
P0726A*                                                                 16650000
P0726A*****************************************************************         
P0726B* 7600-SELECT-ACCOUNT                                           *         
P0726A*     SELECTS CSS_ACCOUNT                                       *         
P0726A*****************************************************************         
P0726B 7600-SELECT-ACCOUNT.                                             
P0726A*                                                                         
P0726A     MOVE '7600'               TO ACTIVE-PARAGRAPH.               
P0726A*                                                                         
P0726A     EXEC SQL                                                     
P0726A        SELECT COALESCE(AT.TOTAL_AR_BALANCE,0)                      
P0726B              ,AT.COMPANY_NO                                      
P0726B              ,AT.ACCOUNT_TYPE_CODE                               
P0726B              ,AT.CODE_MAJOR_ACCT                                 
P0726B              ,AT.NOTICE_EXEMPT_CD                                
P0726B              ,AT.CODE_DISC_OK                                    
P0726B              ,AT.DATE_BILL_DAY_00                                
P0726B              ,AT.DATE_BILL_DAY_30                                
P0726B              ,AT.DATE_BILL_DAY_60                                
P0726B              ,AT.DATE_BILL_DAY_90                                
P0726B              ,AT.CODES_DATA_PRESENT                              
P0726B              ,AT.LOCAL_OFFICE                                    
P0726B              ,AT.BANKRUPTCY_IND                                  
P0726B              ,AT.CREDIT_GROUP                                    
P0726B              ,AT.CODE_ACCT_STAT                                  
P0726B              ,AT.IVR_EXEMPT_CD                                   
P0726D              ,AT.CT_METER_RATED_IND                              
P0726A          INTO :AT-TOTAL-AR-BALANCE                               
P0726B              ,:AT-COMPANY-NO                                     
P0726B              ,:AT-ACCOUNT-TYPE-CODE                              
P0726B              ,:AT-CODE-MAJOR-ACCT                                
P0726B              ,:AT-NOTICE-EXEMPT-CD                               
P0726B              ,:AT-CODE-DISC-OK                                   
P0726B              ,:AT-DATE-BILL-DAY-00 :WS-DATE-BILL-00-IND          
P0726B              ,:AT-DATE-BILL-DAY-30 :WS-DATE-BILL-30-IND          
P0726B              ,:AT-DATE-BILL-DAY-60 :WS-DATE-BILL-60-IND          
P0726B              ,:AT-DATE-BILL-DAY-90 :WS-DATE-BILL-90-IND          
P0726B              ,:AT-CODES-DATA-PRESENT                             
P0726B              ,:AT-LOCAL-OFFICE                                   
P0726B              ,:AT-BANKRUPTCY-IND                                 
P0726B              ,:AT-CREDIT-GROUP                                   
P0726B              ,:AT-CODE-ACCT-STAT                                 
P0726B              ,:AT-IVR-EXEMPT-CD                                  
P0726D              ,:AT-CT-METER-RATED-IND                             
P0726A          FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
P0726A         WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                     
P0726A                                                           
P0726A                                                      
P0726A     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT IFNULL(AT.TOTAL_AR_BALANCE,0)                              
MFA-TR*             ,AT.COMPANY_NO                                              
MFA-TR*             ,AT.ACCOUNT_TYPE_CODE                                       
MFA-TR*             ,AT.CODE_MAJOR_ACCT                                         
MFA-TR*             ,AT.NOTICE_EXEMPT_CD                                        
MFA-TR*             ,AT.CODE_DISC_OK                                            
MFA-TR*             ,AT.DATE_BILL_DAY_00                                        
MFA-TR*             ,AT.DATE_BILL_DAY_30                                        
MFA-TR*             ,AT.DATE_BILL_DAY_60                                        
MFA-TR*             ,AT.DATE_BILL_DAY_90                                        
MFA-TR*             ,AT.CODES_DATA_PRESENT                                      
MFA-TR*             ,AT.LOCAL_OFFICE                                            
MFA-TR*             ,AT.BANKRUPTCY_IND                                          
MFA-TR*             ,AT.CREDIT_GROUP                                            
MFA-TR*             ,AT.CODE_ACCT_STAT                                          
MFA-TR*             ,AT.IVR_EXEMPT_CD                                           
MFA-TR*             ,AT.CT_METER_RATED_IND                                      
MFA-TR*         INTO :AT-TOTAL-AR-BALANCE                                       
MFA-TR*             ,:AT-COMPANY-NO                                     32260000
MFA-TR*             ,:AT-ACCOUNT-TYPE-CODE                                      
MFA-TR*             ,:AT-CODE-MAJOR-ACCT                                        
MFA-TR*             ,:AT-NOTICE-EXEMPT-CD                                       
MFA-TR*             ,:AT-CODE-DISC-OK                                           
MFA-TR*             ,:AT-DATE-BILL-DAY-00 :WS-DATE-BILL-00-IND                  
MFA-TR*             ,:AT-DATE-BILL-DAY-30 :WS-DATE-BILL-30-IND                  
MFA-TR*             ,:AT-DATE-BILL-DAY-60 :WS-DATE-BILL-60-IND                  
MFA-TR*             ,:AT-DATE-BILL-DAY-90 :WS-DATE-BILL-90-IND                  
MFA-TR*             ,:AT-CODES-DATA-PRESENT                                     
MFA-TR*             ,:AT-LOCAL-OFFICE                                           
MFA-TR*             ,:AT-BANKRUPTCY-IND                                         
MFA-TR*             ,:AT-CREDIT-GROUP                                           
MFA-TR*             ,:AT-CODE-ACCT-STAT                                         
MFA-TR*             ,:AT-IVR-EXEMPT-CD                                          
MFA-TR*             ,:AT-CT-METER-RATED-IND                                     
MFA-TR*         FROM CSS_ACCOUNT AT                                             
MFA-TR*        WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                             
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7600                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0726A*                                                                         
P0726A     MOVE SQLCODE   TO WS-ACTIVE-RETURN-CODE.                     
P0726B                                                                  
P0726B     IF WS-DATE-BILL-00-IND < 0                                   
P0726B        MOVE SPACES TO AT-DATE-BILL-DAY-00                        
P0726B        MOVE ZEROES TO WS-DATE-BILL-00-IND                        
P0726B     END-IF                                                       
P0726B     IF WS-DATE-BILL-30-IND < 0                                   
P0726B        MOVE SPACES TO AT-DATE-BILL-DAY-30                        
P0726B        MOVE ZEROES TO WS-DATE-BILL-30-IND                        
P0726B     END-IF                                                       
P0726B     IF WS-DATE-BILL-60-IND < 0                                   
P0726B        MOVE SPACES TO AT-DATE-BILL-DAY-60                        
P0726B        MOVE ZEROES TO WS-DATE-BILL-60-IND                        
P0726B     END-IF                                                       
P0726B     IF WS-DATE-BILL-90-IND < 0                                   
P0726B        MOVE SPACES TO AT-DATE-BILL-DAY-90                        
P0726B        MOVE ZEROES TO WS-DATE-BILL-90-IND                        
P0726B     END-IF                                                       
P0726B                                                                  
P0726A     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P0726A        NEXT SENTENCE                                             
P0726A     ELSE                                                         
P0726A        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
P0726A        MOVE '7600'                TO ACTIVE-PARAGRAPH            
P0726A        MOVE 'SELECT'              TO ABEND-FUNCTION              
P0726A        MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
P0726A        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
P0726A        MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
P0726A        PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
P0726A     END-IF.                                                      
P0726A*                                                                         
P0726A 7600-EXIT.                                                       
P0726A     EXIT.                                                        
P0726A*                                                                 16650000
P0726A*****************************************************************         
P0726A* 7700-LAST-UPDATE-USERID                                       *         
P0726A*     SELECTS CSS_CRED_ARNG_HIST                                *         
P0726A*****************************************************************         
P0726A 7700-LAST-UPDATE-USERID.                                         
P0726A*                                                                         
P0726A     MOVE '7700'               TO ACTIVE-PARAGRAPH.               
P0726E     MOVE SPACES               TO WY-LAST-UPDATE-USERID           
P0726E                                  WY-CHANGE-COMMENTS.             
P0726A*                                                                         
P0726A     EXEC SQL                                                     
P0726A        SELECT TOP(1) LAST_UPDATE_USERID,
              CHANGE_COMMENTS                                    
P0726A          INTO :WY-LAST-UPDATE-USERID,                            
P0726A               :WY-CHANGE-COMMENTS                                
P0726A          FROM CSS_CRED_ARNG_HIST WY WITH(READUNCOMMITTED)                
P0726A         WHERE WY.ACCOUNT_NO     = :AT-ACCOUNT-NO                 
P0726A           AND WY.ARNG_ID        = :X1-ARNG-ID                    
P0726A           AND WY.CRED_ARNG_SEQ  = :X1-CRED-ARNG-SEQ              
P0726A           AND WY.ARNG_CHANGE_CD =  'S'                           
P0726A                                           
P0726A                                                           
P0726A                                                      
P0726A     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT LAST_UPDATE_USERID,                                        
MFA-TR*              CHANGE_COMMENTS                                            
MFA-TR*         INTO :WY-LAST-UPDATE-USERID,                                    
MFA-TR*              :WY-CHANGE-COMMENTS                                        
MFA-TR*         FROM CSS_CRED_ARNG_HIST WY                                      
MFA-TR*        WHERE WY.ACCOUNT_NO     = :AT-ACCOUNT-NO                         
MFA-TR*          AND WY.ARNG_ID        = :X1-ARNG-ID                            
MFA-TR*          AND WY.CRED_ARNG_SEQ  = :X1-CRED-ARNG-SEQ                      
MFA-TR*          AND WY.ARNG_CHANGE_CD =  'S'                                   
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7700                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0726A*                                                                         
P0726A     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P0726A     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P0726A        NEXT SENTENCE                                             
P0726A     ELSE                                                         
P0726A        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
P0726A        MOVE '7700'                TO ACTIVE-PARAGRAPH            
P0726A        MOVE 'SELECT'              TO ABEND-FUNCTION              
P0726A        MOVE 'CSS_CRED_ARNG_HIST'  TO TABLE-1                     
P0726A        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
P0726A        MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
P0726A        PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
P0726A     END-IF.                                                      
P0726A*                                                                         
P0726A 7700-EXIT.                                                       
P0726A     EXIT.                                                        
P0726B******************************************************************        
P0726B* 7710-SELECT-REG-PROFILE                                        *12450000
P0726B******************************************************************        
P0726B                                                                  
P0726B 7710-SELECT-REG-PROFILE.                                         
P0726B                                                                  
P0726B     EXEC SQL                                                     
P0726B        SELECT REG_GROUP_CD                                       
P0726B              ,SENIOR_FL                                          
P0726B          INTO :LR-REG-GROUP-CD                                   
P0726B              ,:LR-SENIOR-FL                                      
P0726B          FROM CSS_REG_PROFILE WITH(READUNCOMMITTED)                      
P0726B         WHERE ACCOUNT_NO      = :LR-ACCOUNT-NO                   
P0726B                                                           
P0726B                                                      
P0726B     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     12694000
MFA-TR*       SELECT REG_GROUP_CD                                       12695000
MFA-TR*             ,SENIOR_FL                                          12695000
MFA-TR*         INTO :LR-REG-GROUP-CD                                   12696000
MFA-TR*             ,:LR-SENIOR-FL                                      12696000
MFA-TR*         FROM CSS_REG_PROFILE                                    12697000
MFA-TR*        WHERE ACCOUNT_NO      = :LR-ACCOUNT-NO                   12698000
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7710                                                       
MFA-TR*    END-EXEC.                                                    12699100

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0726B                                                                  
P0726B     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
P0726B                                                                  
P0726B     EVALUATE SQLCODE                                             
P0726B         WHEN SUCCESSFUL-CALL                                     
P0726B              CONTINUE                                            
P0726B         WHEN NOT-FOUND                                           
P0726B              MOVE SPACES TO LR-REG-GROUP-CD                      
P0726B         WHEN OTHER                                               
P0726B              MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
P0726B              MOVE '7710'             TO ACTIVE-PARAGRAPH         
P0726B              MOVE 'SELECT'           TO ABEND-FUNCTION           
P0726B              MOVE SPACES             TO ABEND-SQL-PREDICATES     
P0726B                                         ABEND-TABLES             
P0726B              MOVE 'CSS_REG_PROFILE'  TO TABLE-1                  
P0726B              MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1          
P0726B              MOVE LR-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1        
P0726B              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
P0726B     END-EVALUATE.                                                
P0726B                                                                  
P0726B 7710-EXIT.                                                       
P0726B     EXIT.                                                        
P0726B                                                                  
P0726B******************************************************************        
P0726B* 7720-SEL-ARNG-PLAN-DESC                                        *12450000
P0726B******************************************************************        
P0726B                                                                  
P0726B 7720-SEL-ARNG-PLAN-DESC.                                         
P0726B                                                                  
P0726B     EXEC SQL                                                     
P0726B        SELECT UF.ARNG_PLAN_ID                                    
P0726B              ,UF.ARNG_PLAN_DESC                                  
P0726B          INTO :UF-ARNG-PLAN-ID                                   
P0726B              ,:UF-ARNG-PLAN-DESC                                 
P0726B          FROM CSS_ARNG_PLAN UF WITH(READUNCOMMITTED)                     
P0726B         WHERE UF.COMPANY_NO        = :AT-COMPANY-NO              
P0726B           AND UF.REG_GROUP_CD      = :LR-REG-GROUP-CD            
P0726B           AND UF.ARNG_ID           = :X1-ARNG-ID                 
P0726B           AND UF.ARNG_PLAN_EFF_DT <= IIF(TRY_CONVERT(DATE, 
                                                      :X1-ARNG-SETUP-DT
              ) IS NULL OR (PATINDEX('%.%', :X1-ARNG-SETUP-DT
              ) <> 0) OR (LEN(:X1-ARNG-SETUP-DT) <> 10), CIS.CHAR2DATE(
                                                      :X1-ARNG-SETUP-DT
              ), CONVERT(DATE, :X1-ARNG-SETUP-DT) )           
P0726B           AND UF.ARNG_PLAN_EXP_DT >= IIF(TRY_CONVERT(DATE, 
                                                      :X1-ARNG-SETUP-DT
              ) IS NULL OR (PATINDEX('%.%', :X1-ARNG-SETUP-DT
              ) <> 0) OR (LEN(:X1-ARNG-SETUP-DT) <> 10), CIS.CHAR2DATE(
                                                      :X1-ARNG-SETUP-DT
              ), CONVERT(DATE, :X1-ARNG-SETUP-DT) )           
P0726B                                                           
P0726B                                                      
P0726B     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     12694000
MFA-TR*       SELECT UF.ARNG_PLAN_ID                                            
MFA-TR*             ,UF.ARNG_PLAN_DESC                                  12695000
MFA-TR*         INTO :UF-ARNG-PLAN-ID                                           
MFA-TR*             ,:UF-ARNG-PLAN-DESC                                 12696000
MFA-TR*         FROM CSS_ARNG_PLAN UF                                   12697000
MFA-TR*        WHERE UF.COMPANY_NO        = :AT-COMPANY-NO              12698000
MFA-TR*          AND UF.REG_GROUP_CD      = :LR-REG-GROUP-CD                    
MFA-TR*          AND UF.ARNG_ID           = :X1-ARNG-ID                         
MFA-TR*          AND UF.ARNG_PLAN_EFF_DT <= :X1-ARNG-SETUP-DT                   
MFA-TR*          AND UF.ARNG_PLAN_EXP_DT >= :X1-ARNG-SETUP-DT                   
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7720                                                       
MFA-TR*    END-EXEC.                                                    12699100

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0726B                                                                  
P0726B     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
P0726B                                                                  
P0726B     EVALUATE SQLCODE                                             
P0726B         WHEN SUCCESSFUL-CALL                                     
P0726B              CONTINUE                                            
P0726B         WHEN OTHER                                               
P0726B              MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
P0726B              MOVE '7720'             TO ACTIVE-PARAGRAPH         
P0726B              MOVE 'SELECT'           TO ABEND-FUNCTION           
P0726B              MOVE SPACES             TO ABEND-SQL-PREDICATES     
P0726B                                         ABEND-TABLES             
P0726B              MOVE 'CSS_ARNG_PLAN'    TO TABLE-1                  
P0726B              MOVE 'COMPANY_NO'       TO TABLE-ELEMENT-1          
P0726B              MOVE AT-COMPANY-NO      TO HOSTVAR-ELEMENT-1        
P0726B              MOVE 'REG_GROUP_CD'     TO TABLE-ELEMENT-2          
P0726B              MOVE LR-REG-GROUP-CD    TO HOSTVAR-ELEMENT-2        
P0726B              MOVE 'ARNG_ID'          TO TABLE-ELEMENT-3          
P0726B              MOVE X1-ARNG-ID         TO HOSTVAR-ELEMENT-3        
P0726B              MOVE 'ARNG_SETUP_DT'    TO TABLE-ELEMENT-4          
P0726B              MOVE X1-ARNG-SETUP-DT   TO HOSTVAR-ELEMENT-4        
P0726B              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
P0726B     END-EVALUATE.                                                
P0726B                                                                  
P0726B 7720-EXIT.                                                       
P0726B     EXIT.                                                        
P0726B                                                                  
P0726B******************************************************************        
P0726B* 7730-GET-CURRENT-DATE                                                   
P0726B******************************************************************        
P0726B                                                                  
P0726B 7730-GET-CURRENT-DATE.                                           
P0726B                                                                  
P0726B     EXEC SQL                                                     
P0726B         SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                      
P0726B     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET: WS-CURRENT-DATE = CURRENT DATE                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0726B                                                                  
P0726B     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
P0726B                                                                  
P0726B     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P0726B        CONTINUE                                                  
P0726B     ELSE                                                         
P0726B        MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
P0726B        MOVE '7730'                   TO ACTIVE-PARAGRAPH         
P0726B        MOVE 'SET'                    TO ABEND-FUNCTION           
P0726B        PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
P0726B     END-IF.                                                      
P0726B                                                                  
P0726B 7730-EXIT.                                                       
P0726B     EXIT.                                                        
P0726B                                                                  
P0726B******************************************************************        
P0726B* 7740-SELECT-PENDING-SO                                         *12450000
P0726B******************************************************************        
P0726B                                                                  
P0726B 7740-SELECT-PENDING-SO.                                          
P0726B                                                                  
P0726B     EXEC SQL                                                     
P0726B        SELECT TOP(1) 'Y'                                                
P0726B          INTO :WS-PENDING-SO-FLAG                                
P0726B          FROM CSS_SO_DATA WITH(READUNCOMMITTED)                          
P0726B         WHERE ACCOUNT_NO_PRIOR    = :VO-ACCOUNT-NO               
P0726B           AND ORDER_STATE_CD NOT IN ('C', 'Z')                   
P0726B           AND ORDER_TYPE_CD       = :VO-ORDER-TYPE-CD            
P0726B                                           
P0726B                                                           
P0726B                                                      
P0726B     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-PENDING-SO-FLAG                                        
MFA-TR*         FROM CSS_SO_DATA                                                
MFA-TR*        WHERE ACCOUNT_NO_PRIOR    = :VO-ACCOUNT-NO                       
MFA-TR*          AND ORDER_STATE_CD NOT IN ('C', 'Z')                           
MFA-TR*          AND ORDER_TYPE_CD       = :VO-ORDER-TYPE-CD                    
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7740                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0726B                                                                  
P0726B     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
P0726B                                                                  
P0726B     EVALUATE SQLCODE                                             
P0726B         WHEN SUCCESSFUL-CALL                                     
P0726B              CONTINUE                                            
P0726B         WHEN NOT-FOUND                                           
P0726B              MOVE 'N'                TO WS-PENDING-SO-FLAG       
P0726B         WHEN OTHER                                               
P0726B              MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
P0726B              MOVE '7740'             TO ACTIVE-PARAGRAPH         
P0726B              MOVE 'SELECT'           TO ABEND-FUNCTION           
P0726B              MOVE SPACES             TO ABEND-SQL-PREDICATES     
P0726B                                         ABEND-TABLES             
P0726B              MOVE 'CSS_SO_DATA'      TO TABLE-1                  
P0726B              MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1          
P0726B              MOVE VO-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1        
P0726B              MOVE 'ORDER_TYPE_CD'    TO TABLE-ELEMENT-2          
P0726B              MOVE VO-ORDER-TYPE-CD   TO HOSTVAR-ELEMENT-2        
P0726B              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
P0726B     END-EVALUATE.                                                
P0726B                                                                  
P0726B 7740-EXIT.                                                       
P0726B     EXIT.                                                        
P0726B                                                                  
P0726B******************************************************************        
P0726B* 7750-SELECT-BILL-DETAILS                                       *        
P0726B******************************************************************        
P0726B                                                                  
P0726B 7750-SELECT-BILL-DETAILS.                                        
P0726B                                                                  
P0726B     EXEC SQL                                                     
P0726B        SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS           
P0726B          INTO :BI-LAST-UPDATE-TS                                 
P0726B          FROM CSS_BILLING_HDR WITH(READUNCOMMITTED)                      
P0726B         WHERE ACCOUNT_NO  = :BI-ACCOUNT-NO                       
P0726B           AND DATE_BILLED IS NOT NULL                            
P0726B         ORDER BY BILL_NO DESC                                    
P0726B                                                           
P0726B                                           
P0726B                                                      
P0726B     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT LAST_UPDATE_TS                                             
MFA-TR*         INTO :BI-LAST-UPDATE-TS                                         
MFA-TR*         FROM CSS_BILLING_HDR                                            
MFA-TR*        WHERE ACCOUNT_NO  = :BI-ACCOUNT-NO                               
MFA-TR*          AND DATE_BILLED IS NOT NULL                                    
MFA-TR*        ORDER BY BILL_NO DESC                                            
MFA-TR*         WITH UR                                                         
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*      QUERYNO 7750                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0726B                                                                  
P0726B     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
P0726B                                                                  
P0726B     EVALUATE WS-ACTIVE-RETURN-CODE                               
P0726B         WHEN SUCCESSFUL-CALL                                     
P0726B              CONTINUE                                            
P0726B         WHEN NOT-FOUND                                           
P0726B              MOVE SPACES             TO BI-LAST-UPDATE-TS        
P0726B         WHEN OTHER                                               
P0726B              MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
P0726B              MOVE '7750'             TO ACTIVE-PARAGRAPH         
P0726B              MOVE 'SELECT'           TO ABEND-FUNCTION           
P0726B              MOVE SPACES             TO ABEND-SQL-PREDICATES     
P0726B                                         ABEND-TABLES             
P0726B              MOVE 'CSS_BILLING_HDR'  TO TABLE-1                  
P0726B              MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1          
P0726B              MOVE BI-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1        
P0726B              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
P0726B     END-EVALUATE.                                                
P0726B                                                                  
P0726B 7750-EXIT.                                                       
P0726B     EXIT.                                                        
P0726B                                                                  
      ******************************************************************        
      * 8000A-DELETE-GTT-ROWS.                                         *        
      ******************************************************************        
       8000A-DELETE-GTT-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04672_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04672_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                   CONTINUE                                             
              WHEN NOT-FOUND                                            
                   MOVE ZEROES              TO WS-ACTIVE-RETURN-CODE    
              WHEN OTHER                                                
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '8000A'             TO ACTIVE-PARAGRAPH         
                   MOVE 'DELETE'            TO ABEND-FUNCTION           
                   MOVE SPACES              TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                   MOVE 'CSR04672_R1'       TO TABLE-1                  
                   MOVE SPACES              TO TABLE-ELEMENT-1          
                   MOVE SPACES              TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       8000A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 8010-INSERT-GTT-R1.                                            *        
      ******************************************************************        
       8010-INSERT-GTT-R1.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04672_R1                            
             (                                                          
              RETURN_CODE                                               
             ,ARNG_ID                                                   
             ,ARNG_TYPE                                                 
             ,CRED_ARNG_SEQ                                             
             ,ARNG_SETUP_DATE                                           
             ,ARNG_COMPL_CD                                             
             ,ARNG_STATUS_CD                                            
             ,ARNG_DUE_DATE                                             
             ,ARNG_AMOUNT                                               
             ,ARNG_SETUP_CMNTS                                          
             ,ARNG_REMAINING_AMOUNT                                     
P0726A       ,ARNG_CONFIRM_NO                                           
P0726A       ,ORIGINAL_DUE_DT                                           
P0726A       ,LAST_UPDATE_USERID                                        
P0726A       ,DNP_DATE                                                  
P0726B       ,ARNG_PLAN_DESC                                            
P0726B       ,MAJOR_ATTR_FL                                             
P0726B       ,NONRES_ATTR_FL                                            
P0726B       ,CREDIT_ACTION_FL                                          
P0726B       ,APPL_RETURN_CODE                                          
P0726C       ,ORIGINAL_DNP_DT                                           
P0726C       ,FIRST_NOT_MAIL_DT                                         
P0726C       ,FINAL_NOT_MAIL_DT                                         
P0726C       ,ARNG_DNP_DT                                               
P0726C       ,FLEX_ARNGMNT                                              
P0726C       ,FLEX_COMMENTS                                             
P0726D       ,CANCEL_COMMENTS                                           
P0726D       ,CT_METER_ATTR                                             
             )                                                          
             VALUES                                                     
             (                                                          
              :S-R1-RETURN-CODE                                         
             ,:S-R1-ARNG-ID                                             
             ,:S-R1-ARNG-TYPE                                           
             ,:S-R1-ARNG-SEQ                                            
             ,:S-R1-ARNG-SETUP-DT                                       
             ,:S-R1-ARNG-COMPL-CD                                       
             ,:S-R1-ARNG-STATUS-CD                                      
             ,:S-R1-ARNG-DUE-DT                                         
             ,:S-R1-ARNG-AMOUNT                                         
             ,:S-R1-SETUP-COMMENTS                                      
             ,:S-R1-ARNG-REMAINING-AMT                                  
P0726A       ,:S-R1-ARNG-CONFIRM-NO                                     
P0726A       ,:S-R1-ORIGINAL-DUE-DT                                     
P0726A       ,:S-R1-LAST-UPDATE-USERID                                  
P0726A       ,:S-R1-DNP-DATE                                            
P0726B       ,:S-R1-ARNG-PLAN-DESC                                      
P0726B       ,:S-R1-MAJOR-ATTR-FL                                       
P0726B       ,:S-R1-NONRES-ATTR-FL                                      
P0726B       ,:S-R1-CREDIT-ACTION-FL                                    
P0726B       ,:S-R1-APPL-RETURN-CODE                                    
P0726C       ,:S-R1-ORIGINAL-DNP-DT                                     
P0726C       ,:S-R1-FIRST-NOT-MAIL-DT                                   
P0726C       ,:S-R1-FINAL-NOT-MAIL-DT                                   
P0726C       ,:S-R1-ARNG-DNP-DT                                         
P0726C       ,:S-R1-FLEX-ARNGMNT                                        
P0726C       ,:S-R1-FLEX-COMMENTS                                       
P0726D       ,:S-R1-CANCEL-COMMENTS                                     
P0726D       ,:S-R1-KR361-CT-METER-ATTR                                 
             )                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04672_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,ARNG_ID                                                           
MFA-TR*      ,ARNG_TYPE                                                         
MFA-TR*      ,CRED_ARNG_SEQ                                                     
MFA-TR*      ,ARNG_SETUP_DATE                                                   
MFA-TR*      ,ARNG_COMPL_CD                                                     
MFA-TR*      ,ARNG_STATUS_CD                                                    
MFA-TR*      ,ARNG_DUE_DATE                                                     
MFA-TR*      ,ARNG_AMOUNT                                                       
MFA-TR*      ,ARNG_SETUP_CMNTS                                                  
MFA-TR*      ,ARNG_REMAINING_AMOUNT                                             
MFA-TR*      ,ARNG_CONFIRM_NO                                                   
MFA-TR*      ,ORIGINAL_DUE_DT                                                   
MFA-TR*      ,LAST_UPDATE_USERID                                                
MFA-TR*      ,DNP_DATE                                                          
MFA-TR*      ,ARNG_PLAN_DESC                                                    
MFA-TR*      ,MAJOR_ATTR_FL                                                     
MFA-TR*      ,NONRES_ATTR_FL                                                    
MFA-TR*      ,CREDIT_ACTION_FL                                                  
MFA-TR*      ,APPL_RETURN_CODE                                                  
MFA-TR*      ,ORIGINAL_DNP_DT                                                   
MFA-TR*      ,FIRST_NOT_MAIL_DT                                                 
MFA-TR*      ,FINAL_NOT_MAIL_DT                                                 
MFA-TR*      ,ARNG_DNP_DT                                                       
MFA-TR*      ,FLEX_ARNGMNT                                                      
MFA-TR*      ,FLEX_COMMENTS                                                     
MFA-TR*      ,CANCEL_COMMENTS                                                   
MFA-TR*      ,CT_METER_ATTR                                                     
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S-R1-RETURN-CODE                                                 
MFA-TR*      ,:S-R1-ARNG-ID                                                     
MFA-TR*      ,:S-R1-ARNG-TYPE                                                   
MFA-TR*      ,:S-R1-ARNG-SEQ                                                    
MFA-TR*      ,:S-R1-ARNG-SETUP-DT                                               
MFA-TR*      ,:S-R1-ARNG-COMPL-CD                                               
MFA-TR*      ,:S-R1-ARNG-STATUS-CD                                              
MFA-TR*      ,:S-R1-ARNG-DUE-DT                                                 
MFA-TR*      ,:S-R1-ARNG-AMOUNT                                                 
MFA-TR*      ,:S-R1-SETUP-COMMENTS                                              
MFA-TR*      ,:S-R1-ARNG-REMAINING-AMT                                          
MFA-TR*      ,:S-R1-ARNG-CONFIRM-NO                                             
MFA-TR*      ,:S-R1-ORIGINAL-DUE-DT                                             
MFA-TR*      ,:S-R1-LAST-UPDATE-USERID                                          
MFA-TR*      ,:S-R1-DNP-DATE                                                    
MFA-TR*      ,:S-R1-ARNG-PLAN-DESC                                              
MFA-TR*      ,:S-R1-MAJOR-ATTR-FL                                               
MFA-TR*      ,:S-R1-NONRES-ATTR-FL                                              
MFA-TR*      ,:S-R1-CREDIT-ACTION-FL                                            
MFA-TR*      ,:S-R1-APPL-RETURN-CODE                                            
MFA-TR*      ,:S-R1-ORIGINAL-DNP-DT                                             
MFA-TR*      ,:S-R1-FIRST-NOT-MAIL-DT                                           
MFA-TR*      ,:S-R1-FINAL-NOT-MAIL-DT                                           
MFA-TR*      ,:S-R1-ARNG-DNP-DT                                                 
MFA-TR*      ,:S-R1-FLEX-ARNGMNT                                                
MFA-TR*      ,:S-R1-FLEX-COMMENTS                                               
MFA-TR*      ,:S-R1-CANCEL-COMMENTS                                             
MFA-TR*      ,:S-R1-KR361-CT-METER-ATTR                                         
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE       = SUCCESSFUL-CALL             
              ADD +1                        TO  CTR-ROWS-RS1            
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE '8010'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE 'CSR04672_R1'            TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       8010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8900-SEND-DONE.                                                *        
      ******************************************************************        
       8900-SEND-DONE.                                                  
                                                                        
           MOVE PROGRAM-NAME                TO ABEND-PROGRAM            
           MOVE '8900'                      TO ACTIVE-PARAGRAPH         
           MOVE 'OPEN'                      TO ABEND-FUNCTION           
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
                                                    
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9000-SEND-ERROR-RESULT                                         *        
      ******************************************************************        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE       TO ABEND-SQLCODE            
                                               S-R1-RETURN-CODE.        
                                                                        
           MOVE SQLERRMC                    TO ABEND-SQLERRMC.          
                                                                        
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE                     = SUCCESSFUL-CALL             
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'               TO ABEND-FUNCTION           
           END-IF.                                                      
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1     THRU 0100A-EXIT.            
                                                                        
           PERFORM 8010-INSERT-GTT-R1       THRU 8010-EXIT.             
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9700-ABEND-PROCESSING.                                         *        
      ******************************************************************        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT.             
           PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT.             
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900-SQL-ERROR-ROUTINE.                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9999-END-PROGRAM.                                              *        
      ******************************************************************        
                                                                        
       9999-END-PROGRAM.                                                
                                                                        
P0726B     IF WS-ARNG-TBL-COUNT = 0                                     
P0726B        INITIALIZE GTT-RETURN-FIELDS-1                            
P0726B        MOVE WS-CREDIT-ACTION-FL      TO S-R1-CREDIT-ACTION-FL    
P0726B        MOVE 100                      TO S-R1-APPL-RETURN-CODE    
              PERFORM 8010-INSERT-GTT-R1    THRU 8010-EXIT              
           END-IF.                                                      
                                                                        
           IF CTR-ROWS-RS1 < 1                                          
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '9999-END-PROGRAM'       TO ABEND-FUNCTION           
              MOVE 'PROGRAMMER LOGIC'       TO TABLE-1                  
              MOVE 'FAILED TO SEND'         TO TABLE-ELEMENT-1          
              MOVE 'RESULT SET'             TO HOSTVAR-ELEMENT-1        
              MOVE -1                       TO WS-ACTIVE-RETURN-CODE    
                                                                        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           ELSE                                                         
              PERFORM 8900-SEND-DONE        THRU 8900-EXIT              
           END-IF.                                                      
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
