       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       CSR04671.                                      
COB303 DATE-WRITTEN.     AUGUST 20 2013.                                
       DATE-COMPILED.                                                   
      ******************************************************************00050000
      ****             SOUTH CAROLINA ELECTRIC & GAS                    00060000
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *00070000
      *                                                                 00080000
      ******************************************************************00130000
      *                 P R O G R A M  S U M M A R Y                   *00140000
      *                                                                *00150000
      *  THIS PROGRAM IS A REMOTE PROCEDURE CALL MADE FROM MOD         *00160000
      *                                                                *00180000
      *  THIS PROGRAM UPDATES CSS_ACCOUNT, CSS_AR_CNTL                 *00190000
      *                       AND CSS_BILLING_HDR                      *00200000
      ******************************************************************00210000
      *                                                                *00220000
      *                     PROGRAM MODIFICATION LOG                   *00230000
      *                                                                *00240000
      *    DATE    INITIALS   COMMENTS                                 *00250000
      *  --------  --------   ---------------------------------------  *00260000
      *  08/20/2013  MC95456  NEW PROGRAM                              *00270000
ACT071*  03/24/2014  MC95456  DELETE WS-45 ROW WHEN UTG AMT IS ZERO    *        
ACT071*  A04880-ACT071                                                 *        
      ******************************************************************00380000
      *                                                                *00390000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00400000
      *                                                                *00410000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00420000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00430000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00440000
      *  3000 - 4999  NOT USED                                         *00450000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00460000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00470000
      *  7000 - 7999  INPUT MODULES                                    *00480000
      *  8000 - 8999  OUTPUT MODULES                                   *00490000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00500000
      *                                                                *00510000
      ******************************************************************00520000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04671'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04671 STARTS HERE'.                  
                                                                        
                                                                        
      ******************************************************************00620000
      *    DB2 INCLUDES                                                *00630000
      ******************************************************************00640000
                                                                        
           EXEC SQL                                                     00660000
              INCLUDE SQLCA                                             00670000
           END-EXEC.                                                    00680000
                                                                        
      ******************************************************************        
      *  AC - CSS_CSS_AR_CNTL                                          *        
      ******************************************************************        
           EXEC SQL                                                     00700000
               INCLUDE TBARCNTL                                         00710000
           END-EXEC.                                                    00720000
                                                                        
      ******************************************************************        
      *  AR - CSS_AR_TRANS_HIST                                                 
      ******************************************************************        
           EXEC SQL                                                     00700000
               INCLUDE TBARHIST                                         00710000
           END-EXEC.                                                    00720000
                                                                        
      ******************************************************************        
      *  AT - CSS_ACCOUNT                                              *        
      ******************************************************************        
           EXEC SQL                                                     00700000
               INCLUDE TBACCT                                           00710000
           END-EXEC.                                                    00720000
                                                                        
      ******************************************************************        
      *  AU - CSS_AR_TRN_HST_DET                                                
      ******************************************************************        
           EXEC SQL                                                     00700000
               INCLUDE TBARHDT                                          00710000
           END-EXEC.                                                    00720000
                                                                        
                                                                        
      ******************************************************************        
      *  BC -  CSS_BCH_JRNL_CNTL                                       *        
      ******************************************************************        
           EXEC SQL                                                     00700000
               INCLUDE TBBJCNTL                                         00710000
           END-EXEC.                                                    00720000
                                                                        
      ******************************************************************        
      *  BJ -  CSS_BATCH_JRNL                                     *             
      ******************************************************************        
           EXEC SQL                                                     00700000
               INCLUDE TBBTJRNL                                         00710000
           END-EXEC.                                                    00720000
                                                                        
      ******************************************************************        
      *  BI - CSS_BILLING_HDR                                          *        
      ******************************************************************        
           EXEC SQL                                                     00700000
               INCLUDE TBBLLHDR                                         00710000
           END-EXEC.                                                    00720000
                                                                        
                                                                        
      ******************************************************************        
      *  FW - CSS_FIN_WO                                                        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBFINLWO                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  GO - CSS_GL_ACCT_NO                                                    
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBGLATNO                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  KD - CSS_FIN_WO_ACTION                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBFWACTN                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  MH - CSS_MNT_TRANS_HIST                                                
      ******************************************************************        
           EXEC SQL                                                     00700000
               INCLUDE TBMNHIST                                         00710000
           END-EXEC.                                                    00720000
                                                                        
                                                                        
      ******************************************************************        
      *  MI - CSS_MT_TRN_HST_DET                                                
      ******************************************************************        
           EXEC SQL                                                     00700000
               INCLUDE TBMNHDT                                          00710000
           END-EXEC.                                                    00720000
                                                                        
      ******************************************************************        
      *  MJ - CSS_MISC_JRNL TABLE                                               
      ******************************************************************        
           EXEC SQL                                                     00700000
               INCLUDE TBMSJRNL                                         00710000
           END-EXEC.                                                    00720000
      ***************************************************************** 00010000
      *  WS ABEND WORK AREA                                           * 00020000
      ***************************************************************** 00080000
           EXEC SQL                                                     03680002
               INCLUDE CWSX0010                                         03690002
           END-EXEC.                                                    03700002
                                                                        
      ***************************************************************** 00010000
      *  JRNL-ROUTINE                                                 * 00020000
      ***************************************************************** 00080000
           EXEC SQL                                                     01555900
              INCLUDE CWS00013                                          01556000
           END-EXEC.                                                    01557000
                                                                        
      ***************************************************************** 00010000
      *  WORKING STORAGE COPY BOOKS                                   * 00020000
      ***************************************************************** 00080000
           COPY CWS00056.                                                       
           COPY CJF00101.                                                       
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************01010000
      *    WORK AREAS                                                  *01020000
      ******************************************************************01030000
      *                                                                 01570000
       01  WS-MISC.                                                     
           05  PROGRAM-NAME            PIC X(08)  VALUE 'CSR04671'.     
           05  WS-SQLSTATE             PIC X(05)  VALUE SPACES.         
           05  WS-CODES                PIC X(32)  VALUE SPACES.         
           05  CTR-ROWS                PIC S9(9)  COMP VALUE 0.         
           05  WS-50                   PIC S9(04) VALUE 50 USAGE COMP.  
           05  WS-45                   PIC S9(04) VALUE 45 USAGE COMP.  
           05  WS-ACCOUNT              PIC X(13).                       
           05  WS-ACCOUNT-NO  REDEFINES WS-ACCOUNT PIC 9(13).           
           05  WS-UTG-AMT-AFTER-00     PIC S9(09)V99 COMP-3 VALUE +0.   
           05  WS-UTG-AMT-AFTER-30     PIC S9(09)V99 COMP-3 VALUE +0.   
           05  WS-UTG-AMT-AFTER-60     PIC S9(09)V99 COMP-3 VALUE +0.   
           05  WS-UTG-AMT-AFTER-90     PIC S9(09)V99 COMP-3 VALUE +0.   
           05  WS-UTG-AMT-UNBILLED     PIC S9(09)V99 COMP-3 VALUE +0.   
           05  WS-TOTAL-BALANCE-UTG    PIC S9(09)V99 COMP-3 VALUE +0.   
           05  WS-CASH-DRAWER-ID       PIC 9(04)     VALUE ZERO.        
           05  WS-CASH-COMPANY-NO      PIC X(02)     VALUE '01'.        
           05  WS-CASH-REPORT-NO       PIC X(03)     VALUE SPACES.      
           05  WS-CASH-LOCAL-OFFICE    PIC X(03)     VALUE SPACES.      
           05  WS-A                    PIC X(01)     VALUE 'A'.         
           05  WS-N                    PIC X(01)     VALUE 'N'.         
           05  WS-ACCT-FINALED-DT-NULL PIC S9(04) COMP.                 
           05  WS-NULL-INDICATOR-1     PIC S9(04) COMP.                 
           05  WS-NULL-INDICATOR-2     PIC S9(04) COMP.                 
           05  WS-NULL-INDICATOR-3     PIC S9(04) COMP.                 
           05  WS-NULL-INDICATOR-4     PIC S9(04) COMP.                 
           05  WS-45-NULL-IND-00       PIC S9(04) COMP.                 
           05  WS-45-NULL-IND-30       PIC S9(04) COMP.                 
           05  WS-45-NULL-IND-60       PIC S9(04) COMP.                 
           05  WS-45-NULL-IND-90       PIC S9(04) COMP.                 
           05  WS-45-NULL-IND-UN       PIC S9(04) COMP.                 
           05  WS-CURRENT-DATE         PIC X(10)  VALUE SPACES.         
           05  WS-TIMESTAMP            PIC X(26)  VALUE SPACES.         
           05  WS-USER-ID              PIC X(07)  VALUE SPACES.         
           05  WS-UTG-EXISTS-SW        PIC X(01)  VALUE SPACES.         
               88 UTG-EXISTS           VALUE 'Y'.                       
               88 UTG-NOT-EXISTS       VALUE 'N'.                       
           05  WS-TRANHIST-MSG         PIC X(20) VALUE                  
                                       'Prepay reset - TOIE'.           
       01  WS-DEBIT-GL-DATA.                                            
           05  WS-DEBIT-GL-TEXT        PIC X(15).                       
           05  WS-DEBIT-GL-NUM         PIC S9(03)V9(04)                 
                                           VALUE 142.0400.              
           05  FILLER                  PIC X(57).                       
      *                                                                 01110000
       01  WS-CREDIT-GL-DATA.                                           
           05  WS-CREDIT-GL-TEXT       PIC X(16).                       
           05  WS-CREDIT-GL-NUM        PIC S9(03)V9(04)                 
                                           VALUE 142.0310.              
           05  FILLER                  PIC X(56).                       
      *                                                                 01110000
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE           PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WS-MNT-TRANS-DET.                                            
           05  WS-CODE-TRAN-TYPE       PIC X(01)  VALUE 'B'.            
           05  WS-TRAN-APPL-NO         PIC S9(02) VALUE 0.              
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME               PIC X(18)      VALUE SPACES.     
           10  S-SQLCODE               PIC S9(9) COMP VALUE 0.          
           10  S-SQLSTATE              PIC X(5)       VALUE ' '.        
           10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.     
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.            
               49  S-HOST-VARIABLES-V  PIC X(255).                      
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
               49  S-SQL-STATEMENT-V   PIC X(255).                      
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.            
               49  S-SQL-DESCRIPTION-V PIC X(255).                      
                                                                        
      *                                                                         
       LINKAGE SECTION.                                                 
      *                                                                         
       01 PARM-ACCOUNT-NO         PIC X(13).                            
       01 PARM-USER-ID            PIC X(07).                            
      *                                                                         
       PROCEDURE DIVISION USING  PARM-ACCOUNT-NO,                       
                                 PARM-USER-ID.                          
                                                                        
      *                                                                 02760000
      ******************************************************************02770000
      * 0000-MAINLINE                                                  *02780000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *02790000
      ******************************************************************02800000
       0000-MAINLINE.                                                   
                                                                        
           MOVE '0000'                 TO ACTIVE-PARAGRAPH.             
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02920000
      * 0100-INITIALIZE                                                *02930000
      *                                                                *02940000
      *     1. RESET DB2 ERROR HANDLERS                                *02950000
      *     2. DECLARE C1 CURSOR FOR RETURN VALUES.                    *02960000
      *                                                                *02990000
      ******************************************************************03000000
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'                 TO ACTIVE-PARAGRAPH.             
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
      *                                                                         
           EXEC SQL                                                     
                DECLARE C1 CURSOR                            
                                  WITH ROWSET POSITIONING FOR           
                 SELECT :S-RETURN-CODE       AS RETURN_CODE             
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE C1 CURSOR WITH RETURN                                   
MFA-TR*                           WITH ROWSET POSITIONING FOR                   
MFA-TR*          SELECT :S-RETURN-CODE       AS RETURN_CODE                     
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                   03030000
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************03270000
      * 1000-PROCESS-INPUT                                             *03280000
      *                                                                *03290000
      *     1. PROCESS INPUTS.                                         *03300000
      *                                                                *03310000
      ******************************************************************03320000
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-ACCOUNT-NO       TO WS-ACCOUNT.                    
           MOVE PARM-USER-ID          TO WS-USER-ID.                    
           MOVE WS-ACCOUNT-NO         TO AT-ACCOUNT-NO.                 
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04890000
      * 2000-PROCESS-OUTPUT.                                           *04900000
      ******************************************************************04950000
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                         TO ACTIVE-PARAGRAPH.     
           MOVE AT-ACCOUNT-NO                  TO FW-ACCOUNT-NO         
                                                  KD-ACCOUNT-NO         
                                                  AC-ACCOUNT-NO         
                                                  BI-ACCOUNT-NO.        
           PERFORM 8000-DELETE-FINAL-WO           THRU 8000-EXIT.       
           PERFORM 8150-DELETE-FIN-WO-ACT         THRU 8150-EXIT.       
           PERFORM 7010-GET-CURRENT-DATE          THRU 7010-EXIT.       
           PERFORM 5000-PROCESS-ACCOUNT           THRU 5000-EXIT.       
           PERFORM 5100-GET-UTG-AMTS              THRU 5100-EXIT.       
           IF UTG-EXISTS                                                
              PERFORM 8300-DELETE-UTG-ROW         THRU 8300-EXIT        
              PERFORM 5200-PROCESS-AR-CNTL        THRU 5200-EXIT        
              PERFORM 5300-SETUP-JOURNAL-HDR      THRU 5300-EXIT        
              PERFORM 5350-CREATE-AR-TRAN-DET     THRU 5350-EXIT        
              PERFORM 5400-CREATE-101-JRNL-ENTRY  THRU 5400-EXIT        
           ELSE                                                         
ACT071        PERFORM 8300-DELETE-UTG-ROW         THRU 8300-EXIT        
              PERFORM 5200-PROCESS-AR-CNTL        THRU 5200-EXIT        
              PERFORM 5450-MAINTENANCE-HISTORY    THRU 5450-EXIT        
           END-IF.                                                      
           PERFORM 5500-PROCESS-BILLING-HDR       THRU 5500-EXIT.       
           PERFORM 8100-SEND-RESULT               THRU 8100-EXIT.       
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05370000
      ***************************************************************   06210000
      *                                                             *   06220000
      * 5000-PROCESS-ACCOUNT.                                       *   06230000
      *      UPDATES CSS_ACCOUNT                                    *   06240000
      ***************************************************************   06250000
       5000-PROCESS-ACCOUNT.                                            
                                                                        
           MOVE '5000'                     TO ACTIVE-PARAGRAPH.         
      *                                                                         
           PERFORM 7000-SELECT-ACCOUNT     THRU 7000-EXIT.              
           MOVE AT-CODES-DATA-PRESENT      TO WS-CODES-DATA-PRESENT.    
           MOVE ' '                        TO WS-CODE-UTL.              
           MOVE 'A'                        TO WS-CODE-PRE-PAY-PLAN.     
           MOVE WS-CODES-DATA-PRESENT      TO WS-CODES.                 
           MOVE -1                         TO WS-ACCT-FINALED-DT-NULL.  
           MOVE SPACES                     TO AT-ACCT-FINALED-DT.       
           PERFORM 8200-UPDATE-ACCOUNT     THRU 8200-EXIT.              
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************10702900
      *                                                                 10703000
      * 5100-GET-UTG-AMTS.                                              10703100
      ******************************************************************10703300
      *                                                                 10703400
       5100-GET-UTG-AMTS.                                               
                                                                        
           MOVE '5100'                      TO ACTIVE-PARAGRAPH.        
      *                                                                         
           MOVE 'N'                         TO WS-UTG-EXISTS-SW.        
           PERFORM 7500-SELECT-UTG-AMOUNTS  THRU 7500-EXIT.             
           COMPUTE WS-TOTAL-BALANCE-UTG = (WS-UTG-AMT-AFTER-00 +        
                                           WS-UTG-AMT-AFTER-30 +        
                                           WS-UTG-AMT-AFTER-60 +        
                                           WS-UTG-AMT-AFTER-90 +        
                                           WS-UTG-AMT-UNBILLED).        
           IF WS-TOTAL-BALANCE-UTG > 0                                  
              MOVE 'Y'                      TO WS-UTG-EXISTS-SW         
           END-IF.                                                      
      *                                                                         
        5100-EXIT.                                                      
             EXIT.                                                      
                                                                        
      ******************************************************************10702900
      *                                                                 10703000
      * 5200-PROCESS-AR-CNTL                                            10703100
      * CSS_AR_CNTL WILL BE INSERTED WITH PAYMNT_PRIORITY_LVL 50       *10703200
      ******************************************************************10703300
      *                                                                 10703400
       5200-PROCESS-AR-CNTL.                                            
      *                                                                 10703600
           MOVE '5200'                       TO ACTIVE-PARAGRAPH.       
      *                                                                 10703600
           MOVE AT-ACCOUNT-NO                TO AC-ACCOUNT-NO.          
           MOVE WS-50                        TO AC-PYMT-PRIORITY-LVL.   
           MOVE 0                            TO AC-ITEM-ID.             
           PERFORM 7020-SELECT-TIMESTAMP     THRU 7020-EXIT.            
      *                                                                 10704300
           MOVE WS-TOTAL-BALANCE-UTG         TO AC-AMT-AR-DAY-00.       
           MOVE ZEROS                        TO AC-AMT-TRAN-BALANCE.    
           PERFORM 8500-CREATE-AR-CNTL       THRU 8500-EXIT.            
      *                                                                 10704300
           MOVE AT-ACCOUNT-NO                TO AC-ACCOUNT-NO.          
           MOVE WS-50                        TO AC-PYMT-PRIORITY-LVL.   
           MOVE 1                            TO AC-ITEM-ID.             
           MOVE WS-TOTAL-BALANCE-UTG         TO AC-AMT-AR-DAY-00        
                                                AC-AMT-TRAN-BALANCE.    
           PERFORM 8500-CREATE-AR-CNTL       THRU 8500-EXIT.            
      *                                                                 10705400
       5200-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************10698600
      *                                                                 10698800
      *   PERFORM 5300-SETUP-JOURNAL-HDR                                10698900
      *                                                                 10699000
      ******************************************************************10700000
      *                                                                 10701500
       5300-SETUP-JOURNAL-HDR.                                          
      *                                                                 10701700
           MOVE '5300'                            TO ACTIVE-PARAGRAPH.  
      *                                                                 10701700
           PERFORM 5310-FMT-AR-TRANS-HDR          THRU 5310-EXIT.       
           PERFORM 5320-SET-100-JRNL-VARS         THRU 5320-EXIT.       
           PERFORM 8600-BATCH-LOAD-AR-TRAN-HIST   THRU 8600-EXIT.       
      *                                                                 10702500
       5300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10702800
      ****************************************************************  10796600
      **    5310-FMT-AR-TRANS-HDR.                                  **  10796800
      **        FORMATS COMMON FIELDS FOR AR TRANS HIST             **  10796900
      ****************************************************************  10797100
      *                                                                 10797200
       5310-FMT-AR-TRANS-HDR.                                           
      *                                                                 10797400
           MOVE '5310'                  TO ACTIVE-PARAGRAPH.            
      *                                                                 10797400
           MOVE AT-ACCOUNT-NO           TO AR-ACCOUNT-NO.               
           MOVE WS-TIMESTAMP            TO AR-TRANS-HIST-SEQ-NO.        
           MOVE WS-CURRENT-DATE         TO AR-DATE-TRANS.               
           MOVE 'TOIE'                  TO AR-APPL-PROGRAM-ID.          
           MOVE WS-USER-ID              TO AR-USER-ID.                  
           MOVE AT-COMPANY-NO           TO AR-COMPANY-NO.               
           MOVE SPACES                  TO AR-RECORD-ONLY-FL.           
           MOVE SPACES                  TO AR-RESP-AREA-ID              
                                           AR-PYMT-FACILITY-CD          
                                           AR-DATE-ORIG-PYMT            
                                           AR-PYMT-REFUNDED-IND.        
           MOVE WS-TRANHIST-MSG         TO AR-TRAN-COMMENT-TEXT.        
           MOVE LENGTH OF AR-TRAN-COMMENT-TEXT                          
                                        TO AR-TRAN-COMMENT-LEN.         
           MOVE AT-TOTAL-AR-BALANCE     TO AR-AMT-BILLED-UNPAID.        
           MOVE 0                       TO AR-AMT-ORIG-ENTERED.         
           MOVE WS-CASH-COMPANY-NO      TO AR-CASH-COMPANY-NO.          
           MOVE AT-LOCAL-OFFICE         TO AR-CASH-LOCAL-OFFICE.        
           MOVE WS-CASH-REPORT-NO       TO AR-CASH-REPORT-NO.           
           MOVE WS-CASH-DRAWER-ID       TO AR-CASH-DRAWER-ID.           
           MOVE SPACES                  TO AR-DATE-CASH-REPORT.         
           MOVE 'I'                     TO AR-CODE-TRAN-TYPE.           
      *                                                                 10800000
       5310-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10800300
      ***************************************************************   10909700
      * 5320-SET-100-JRNL-VARS                                      *   10909900
      * POPULATES THE 100 VARIBLES FOR JOURNALLING.                 *   10910100
      ***************************************************************   10910300
      *                                                                 10910400
       5320-SET-100-JRNL-VARS.                                          
      *                                                                 10910700
           MOVE '5320'               TO ACTIVE-PARAGRAPH.               
      *                                                                 10910700
           MOVE WS-CASH-COMPANY-NO   TO WS-JRNL-BT-BAT-COMPANY.         
           MOVE WS-CASH-LOCAL-OFFICE TO WS-JRNL-BT-BAT-LOC-OFF.         
           MOVE WS-CASH-REPORT-NO    TO WS-JRNL-BT-BAT-REPORT-NO.       
           MOVE WS-CURRENT-DATE      TO WS-JRNL-BT-BAT-REPORT-DT.       
           MOVE WS-CASH-DRAWER-ID    TO WS-JRNL-BT-BAT-CASH-DRWR.       
           MOVE SPACES               TO WS-JRNL-BT-ENTRY-LOC.           
           MOVE SPACES               TO WS-JRNL-CURRENCY-TYPE           
                                        WS-JRNL-CODE-PYMT-FACILITY.     
      *                                                                 10912300
           MOVE 'A'                  TO WS-100-JRNL-SORT-ID.            
           MOVE AT-ACCOUNT-NO        TO WS-100-ACCT-NO.                 
           MOVE AT-CUSTOMER-NO       TO WS-100-CUSTOMER-NO.             
           MOVE AT-COMPANY-NO        TO WS-100-COMPANY-NO.              
           MOVE AT-PREMISE-NO        TO WS-100-PREMISE-NO.              
           MOVE 'A720'               TO WS-100-CODE-TERMINAL-TRAN.      
           MOVE 0                    TO WS-100-JRNL-TRAN-APPL-NO.       
           MOVE WS-CURRENT-DATE      TO WS-100-DATE-LAST-ACTION.        
           MOVE 'B'                  TO WS-100-CODE-ENTRY-SOURCE.       
           MOVE AT-LOCAL-OFFICE      TO WS-100-LOCAL-OFFICE-CD.         
           MOVE SPACES               TO WS-100-TRANS-ERRORS.            
                                                                        
           MOVE WS-JRNL-SELECT-AND-OR-INS  TO WS-JRNL-OPERATION-RQST.   
           PERFORM 6400-BATCH-JRNL-ROUTINE THRU 6400-EXIT.              
                                                                        
           MOVE 'B'                  TO WS-JRNL-SOURCE-CODE.            
           MOVE WS-JRNL-CASH-UPDATE  TO WS-JRNL-BT-AUTH-TYPE.           
                                                                        
       5320-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10914600
      ****************************************************************  10848900
      **    5350-CREATE-AR-TRAN-DET                                 **  10849100
      ****************************************************************  10849300
      *                                                                 10849400
       5350-CREATE-AR-TRAN-DET.                                         
      *                                                                 10849600
           MOVE '5350'                   TO ACTIVE-PARAGRAPH.           
      *                                                                 10849600
           MOVE AT-ACCOUNT-NO            TO AU-ACCOUNT-NO.              
           MOVE WS-TIMESTAMP             TO AU-TRANS-HIST-SEQ-NO.       
      *                                                                 10904000
           ADD +1                        TO AU-TRAN-APPL-NO.            
           MOVE 'P'                      TO AU-CODE-AR-AGE.             
           MOVE SPACES                   TO AU-CODE-CONTRACT-TYPE.      
                                                                        
           MOVE WS-TOTAL-BALANCE-UTG     TO AU-AMT-POSTED               
           MOVE WS-DEBIT-GL-NUM          TO AU-GL-ACCT-DEBIT            
           MOVE WS-CREDIT-GL-NUM         TO AU-GL-ACCT-CREDIT           
      *                                                                 10904400
           MOVE 1                        TO AU-ITEM-ID.                 
           MOVE SPACES                   TO AU-CURRENCY-TYPE.           
           MOVE ZERO                     TO AU-CURRENCY-AMT.            
      *                                                                 10904600
           PERFORM 8750-INSRT-AR-TRN-DET THRU 8750-EXIT.                
      *                                                                 10904600
       5350-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10909600
      ***************************************************************   10914700
      * 5400-CREATE-101-JRNL-ENTRY                                  *   10914900
      * POPULATES THE 101 VARIBLES FOR JOURNALLING.                 *   10915100
      ***************************************************************   10915300
      *                                                                 10915400
       5400-CREATE-101-JRNL-ENTRY.                                      
      *                                                                 10915600
           MOVE '5400'                 TO ACTIVE-PARAGRAPH.             
      *                                                                 10915600
           INITIALIZE CJF00101.                                         
      *                                                                 10915800
           MOVE 0                      TO WS-100-JRNL-TRAN-APPL-NO.     
           MOVE 101                    TO WS-101-JRNL-FORMAT-NO.        
           MOVE 'X'                    TO WS-101-CASH-DRAWER-USED.      
           MOVE WS-TOTAL-BALANCE-UTG   TO WS-101-AMOUNT-ENTERED.        
           MOVE WS-TOTAL-BALANCE-UTG   TO WS-101-AMT-POSTED             
           MOVE WS-DEBIT-GL-NUM        TO WS-101-ACCT-GEN-LED-DR        
           MOVE WS-CREDIT-GL-NUM       TO WS-101-ACCT-GEN-LED-CR        
           MOVE WS-101-AMT-POSTED      TO WS-JRNL-CASH-DEBIT-AMT        
                                          WS-JRNL-GEN-LEG-CREDIT-AMT.   
           MOVE 'P'                    TO WS-101-AR-AGE.                
           MOVE WS-CURRENT-DATE        TO WS-101-DATE-AR-BILLED.        
           MOVE 1                      TO WS-101-ITEM-ID-NO             
           MOVE 0                      TO WS-101-DETAIL-END-BAL,        
                                          WS-101-DETAIL-END-AR-BAL.     
           MOVE AT-TOTAL-AR-BALANCE    TO WS-101-ACCT-END-AR-BAL.       
           MOVE AT-CODE-COMPANY-ACCT   TO WS-101-CODE-COMPANY-ACCT.     
           MOVE AT-CODE-ACCT-STAT      TO WS-101-CODE-ACCOUNT-STATUS.   
           MOVE WS-N                   TO WS-UPDATE-JRNL-CNTL-NOW.      
           MOVE CJF00101               TO WS-100-USER-DEFINED-AREA.     
           MOVE WS-JRNL-ONLY           TO WS-JRNL-OPERATION-RQST.       
                                                                        
           PERFORM 6400-BATCH-JRNL-ROUTINE    THRU 6400-EXIT.           
           IF WS-JRNL-RTRN-CODE EQUAL SPACES                            
               NEXT SENTENCE                                            
           ELSE                                                         
               PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
           MOVE WS-JRNL-CNTRL-ONLY            TO WS-JRNL-OPERATION-RQST 
                                                                        
           PERFORM 6400-BATCH-JRNL-ROUTINE    THRU 6400-EXIT.           
           IF WS-JRNL-RTRN-CODE EQUAL SPACES                            
               NEXT SENTENCE                                            
           ELSE                                                         
               PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                 10915600
       5400-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * 5450-MAINTENANCE-HISTORY.                                     *         
      *****************************************************************         
                                                                        
       5450-MAINTENANCE-HISTORY.                                        
      *                                                                 10915600
           MOVE '5000'                 TO ACTIVE-PARAGRAPH.             
      *                                                                 10915600
           MOVE WS-TIMESTAMP           TO MH-TRANS-HIST-SEQ-NO.         
           MOVE WS-CURRENT-DATE        TO MH-DATE-TRANS.                
           MOVE 'F'                    TO MH-CODE-TRAN-TYPE.            
           MOVE ' '                    TO MH-RESP-AREA-ID.              
           MOVE AT-ACCOUNT-NO          TO MH-ACCOUNT-NO.                
           MOVE ZEROS                  TO MH-CUSTOMER-NO.               
           MOVE ZEROS                  TO MH-PREMISE-NO.                
           MOVE PARM-USER-ID           TO MH-USER-ID.                   
           MOVE 'TOIE'                 TO MH-APPL-PROGRAM-ID.           
           MOVE +20                    TO MH-TRAN-COMMENT-LEN.          
           MOVE 'Prepay reset - TOIE'  TO MH-TRAN-COMMENT-TEXT.         
           MOVE +1                     TO WS-TRAN-APPL-NO.              
      *                                                                         
           MOVE MH-TRANS-HIST-SEQ-NO   TO MI-TRANS-HIST-SEQ-NO          
           MOVE 'PYMT PRTY LVL'        TO MI-COLUMN-DESC                
           MOVE +3                     TO MI-PRV-COLUMN-VALUE-LEN       
           MOVE 'NEW'                  TO MI-PRV-COLUMN-VALUE-TEXT      
           MOVE +2                     TO MI-CHG-COLUMN-VALUE-LEN       
           MOVE '50'                   TO MI-CHG-COLUMN-VALUE-TEXT      
           MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO               
                                                                        
           PERFORM 6530-LOAD-MNT-TRANS-HIST    THRU 6530-EXIT.          
      *                                                                 10915600
       5450-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ***************************************************************   10914700
      * 5500-PROCESS-BILLING-HDR                                    *   10914900
      *      THE WILL CHANGE THE STATUS OF FUTURE BILL AND CURRENT  *           
      *      BILL TO NORMAL.                                        *           
      ***************************************************************   10915300
      *                                                                 10915400
       5500-PROCESS-BILLING-HDR.                                        
      *                                                                 10915600
           MOVE '5500'                         TO ACTIVE-PARAGRAPH.     
      *                                                                 10915600
           PERFORM 7200-SELECT-FUTURE-BILL     THRU 7200-EXIT.          
           PERFORM 8700-UPDATE-BILLING-HDR     THRU 8700-EXIT.          
           COMPUTE BI-BILL-NO = BI-BILL-NO - 1.                         
           IF BI-BILL-NO > 0                                            
              PERFORM 8700-UPDATE-BILLING-HDR  THRU 8700-EXIT           
           END-IF.                                                      
      *                                                                 10915600
       5500-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************** 11189000
      * 6400-BATCH-JRNL-ROUTINE                                         11189200
      ***************************************************************** 11189400
      *                                                                 11189500
           EXEC SQL                                                     11189600
               INCLUDE CPD00007                                         11189700
           END-EXEC.                                                    11189800
      *                                                                 11190000
      ******************************************************************        
      * 6530-LOAD-MNT-TRANS-HIST                                       *        
      *     JOURNALING ROUTINE                                         *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************12000000
      *   7000-SELCT-ACCOUNT.                                          *12010000
      *   THIS PARAGRAPH IS USED TO GET THE ACCOUNT DETAILS FROM       *12030000
      *   CSS_ACCOUNT.                                                  12040000
      ******************************************************************12050000
       7000-SELECT-ACCOUNT.                                             
      *                                                                 12050000
           EXEC SQL                                                     
               SELECT COMPANY_NO                                        
                     ,TOTAL_AR_BALANCE                                  
                     ,CODE_COMPANY_ACCT                                 
                     ,CODE_ACCT_STAT                                    
                     ,PREMISE_NO                                        
                     ,CUSTOMER_NO                                       
                     ,DATE_LAST_ACTION                                  
                     ,LOCAL_OFFICE                                      
                     ,ACCOUNT_NO                                        
                     ,CODES_DATA_PRESENT                                
                     ,CREDIT_GROUP                                      
                     ,TOTAL_AR_BALANCE                                  
                     ,NOTICE_EXEMPT_CD                                  
                     ,CODE_DISC_OK                                      
                     ,DATE_BILL_DAY_00                                  
                     ,DATE_BILL_DAY_30                                  
                     ,DATE_BILL_DAY_60                                  
                     ,DATE_BILL_DAY_90                                  
                     ,BANKRUPTCY_IND                                    
                     ,IVR_EXEMPT_CD                                     
                     ,ACCOUNT_TYPE_CODE                                 
                INTO  :AT-COMPANY-NO                                    
                     ,:AT-TOTAL-AR-BALANCE                              
                     ,:AT-CODE-COMPANY-ACCT                             
                     ,:AT-CODE-ACCT-STAT                                
                     ,:AT-PREMISE-NO                                    
                     ,:AT-CUSTOMER-NO                                   
                     ,:AT-DATE-LAST-ACTION                              
                     ,:AT-LOCAL-OFFICE                                  
                     ,:AT-ACCOUNT-NO                                    
                     ,:AT-CODES-DATA-PRESENT                            
                     ,:AT-CREDIT-GROUP                                  
                     ,:AT-TOTAL-AR-BALANCE                              
                     ,:AT-NOTICE-EXEMPT-CD                              
                     ,:AT-CODE-DISC-OK                                  
                     ,:AT-DATE-BILL-DAY-00 :WS-NULL-INDICATOR-1          
                     ,:AT-DATE-BILL-DAY-30 :WS-NULL-INDICATOR-2          
                     ,:AT-DATE-BILL-DAY-60 :WS-NULL-INDICATOR-3          
                     ,:AT-DATE-BILL-DAY-90 :WS-NULL-INDICATOR-4          
                     ,:AT-BANKRUPTCY-IND                                
                     ,:AT-IVR-EXEMPT-CD                                 
                     ,:AT-ACCOUNT-TYPE-CODE                             
                 FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     22580002
MFA-TR*        SELECT COMPANY_NO                                        22590002
MFA-TR*              ,TOTAL_AR_BALANCE                                  22600002
MFA-TR*              ,CODE_COMPANY_ACCT                                 22610002
MFA-TR*              ,CODE_ACCT_STAT                                    22620002
MFA-TR*              ,PREMISE_NO                                        22630002
MFA-TR*              ,CUSTOMER_NO                                       22640002
MFA-TR*              ,DATE_LAST_ACTION                                  22650002
MFA-TR*              ,LOCAL_OFFICE                                      22660002
MFA-TR*              ,ACCOUNT_NO                                        22670002
MFA-TR*              ,CODES_DATA_PRESENT                                22680002
MFA-TR*              ,CREDIT_GROUP                                      22690002
MFA-TR*              ,TOTAL_AR_BALANCE                                  22700002
MFA-TR*              ,NOTICE_EXEMPT_CD                                  22710002
MFA-TR*              ,CODE_DISC_OK                                      22720002
MFA-TR*              ,DATE_BILL_DAY_00                                  22730002
MFA-TR*              ,DATE_BILL_DAY_30                                  22740002
MFA-TR*              ,DATE_BILL_DAY_60                                  22750002
MFA-TR*              ,DATE_BILL_DAY_90                                  22760002
MFA-TR*              ,BANKRUPTCY_IND                                    22770002
MFA-TR*              ,IVR_EXEMPT_CD                                     22780002
MFA-TR*              ,ACCOUNT_TYPE_CODE                                 22790002
MFA-TR*         INTO  :AT-COMPANY-NO                                    22800002
MFA-TR*              ,:AT-TOTAL-AR-BALANCE                              22810002
MFA-TR*              ,:AT-CODE-COMPANY-ACCT                             22820002
MFA-TR*              ,:AT-CODE-ACCT-STAT                                22830002
MFA-TR*              ,:AT-PREMISE-NO                                    22840002
MFA-TR*              ,:AT-CUSTOMER-NO                                   22850002
MFA-TR*              ,:AT-DATE-LAST-ACTION                              22860002
MFA-TR*              ,:AT-LOCAL-OFFICE                                  22870002
MFA-TR*              ,:AT-ACCOUNT-NO                                    22880002
MFA-TR*              ,:AT-CODES-DATA-PRESENT                            22890002
MFA-TR*              ,:AT-CREDIT-GROUP                                  22900002
MFA-TR*              ,:AT-TOTAL-AR-BALANCE                              22910002
MFA-TR*              ,:AT-NOTICE-EXEMPT-CD                              22920002
MFA-TR*              ,:AT-CODE-DISC-OK                                  22930002
MFA-TR*              ,:AT-DATE-BILL-DAY-00:WS-NULL-INDICATOR-1          22940002
MFA-TR*              ,:AT-DATE-BILL-DAY-30:WS-NULL-INDICATOR-2          22950002
MFA-TR*              ,:AT-DATE-BILL-DAY-60:WS-NULL-INDICATOR-3          22960002
MFA-TR*              ,:AT-DATE-BILL-DAY-90:WS-NULL-INDICATOR-4          22970002
MFA-TR*              ,:AT-BANKRUPTCY-IND                                22980002
MFA-TR*              ,:AT-IVR-EXEMPT-CD                                 22990002
MFA-TR*              ,:AT-ACCOUNT-TYPE-CODE                             23000002
MFA-TR*          FROM CSS_ACCOUNT                                       23010002
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       23020002
MFA-TR*         WITH UR                                                 23030002
MFA-TR*         QUERYNO 7000                                                    
MFA-TR*    END-EXEC.                                                    23040002

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 12180000
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                 12200000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE       TO S-RETURN-CODE         
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '7000'                      TO ACTIVE-PARAGRAPH      
              MOVE 'SELECT'                    TO ABEND-FUNCTION        
              MOVE 'CSS_ACCOUNT'               TO TABLE-1               
              MOVE 'ACCOUNT_NO  '              TO TABLE-ELEMENT-1       
              MOVE AT-ACCOUNT-NO               TO HOSTVAR-ELEMENT-1     
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                 12200000
       7000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ****************************************************************          
      * 7010-GET-CURRENT-DATE                                         *         
      *          GETS CURRENT DATE                                    *         
      *****************************************************************         
       7010-GET-CURRENT-DATE.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-DATE = CURRENT DATE                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE       TO S-RETURN-CODE         
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '7010'                      TO ACTIVE-PARAGRAPH      
              MOVE 'SELECT'                    TO ABEND-FUNCTION        
              MOVE 'WS-CURRENT-DATE'           TO HOSTVAR-ELEMENT-1     
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
      *                                                                         
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  12942500
      *   7020-SELECT-TIMESTAMP.                                    **  12942200
      ****************************************************************  12942500
       7020-SELECT-TIMESTAMP.                                           
      *                                                                 12942700
                                                                        
           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-TIMESTAMP                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     12943000
MFA-TR*         SET :WS-TIMESTAMP = CURRENT TIMESTAMP                   12943100
MFA-TR*    END-EXEC.                                                    12943200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 12943300
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                 12943500
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE       TO S-RETURN-CODE         
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '7020'                      TO ACTIVE-PARAGRAPH      
              MOVE 'SELECT'                    TO ABEND-FUNCTION        
              MOVE 'WS-TIMESTAMP'              TO HOSTVAR-ELEMENT-1     
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                 12944400
       7020-EXIT.                                                       
            EXIT.                                                       
      *                                                                 12950000
      ****************************************************************  18581900
      **  7200-SELECT-FUTURE-BILL                                   **  18582100
      ****************************************************************  18582800
      *                                                                 18582900
       7200-SELECT-FUTURE-BILL.                                         
      *                                                                 18582900
           EXEC SQL                                                     
               SELECT MAX (BILL_NO)                                     
                 INTO :BI-BILL-NO                                       
                 FROM CSS_BILLING_HDR WITH(READUNCOMMITTED)                     
                WHERE ACCOUNT_NO = :BI-ACCOUNT-NO                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     07457000
MFA-TR*        SELECT MAX (BILL_NO)                                     07458000
MFA-TR*          INTO :BI-BILL-NO                                       07459000
MFA-TR*          FROM CSS_BILLING_HDR                                   07460000
MFA-TR*         WHERE ACCOUNT_NO = :BI-ACCOUNT-NO                       07461000
MFA-TR*        WITH UR                                                  07463100
MFA-TR*        QUERYNO 7200                                                     
MFA-TR*    END-EXEC.                                                    07464000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE       TO S-RETURN-CODE         
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '7200'                      TO ACTIVE-PARAGRAPH      
              MOVE 'SELECT'                    TO ABEND-FUNCTION        
              MOVE 'CSS_BILLING_HDR'           TO TABLE-1               
              MOVE 'ACCOUNT_NO  '              TO TABLE-ELEMENT-1       
              MOVE BI-ACCOUNT-NO               TO HOSTVAR-ELEMENT-1     
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************  18581900
      **                                                            **  18582000
      **  7500-SELECT-UTG-AMOUNTS                                   **  18582100
      **                                                            **  18582200
      ****************************************************************  18582800
      *                                                                 18582900
       7500-SELECT-UTG-AMOUNTS.                                         
      *                                                                 18582900
           EXEC SQL                                                     
              SELECT SUM(AMT_AR_DAY_00),                                
                     SUM(AMT_AR_DAY_30),                                
                     SUM(AMT_AR_DAY_60),                                
                     SUM(AMT_AR_DAY_90),                                
                     SUM(TOT_SUMM_UNBILLED)                             
                INTO :WS-UTG-AMT-AFTER-00 :WS-45-NULL-IND-00,            
                     :WS-UTG-AMT-AFTER-30 :WS-45-NULL-IND-30,            
                     :WS-UTG-AMT-AFTER-60 :WS-45-NULL-IND-60,            
                     :WS-UTG-AMT-AFTER-90 :WS-45-NULL-IND-90,            
                     :WS-UTG-AMT-UNBILLED :WS-45-NULL-IND-UN             
                FROM CSS_AR_CNTL WITH(READUNCOMMITTED)                          
               WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                 
                 AND PYMT_PRIORITY_LVL = :WS-45                         
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     07457000
MFA-TR*       SELECT SUM(AMT_AR_DAY_00),                                        
MFA-TR*              SUM(AMT_AR_DAY_30),                                        
MFA-TR*              SUM(AMT_AR_DAY_60),                                        
MFA-TR*              SUM(AMT_AR_DAY_90),                                        
MFA-TR*              SUM(TOT_SUMM_UNBILLED)                                     
MFA-TR*         INTO :WS-UTG-AMT-AFTER-00:WS-45-NULL-IND-00,                    
MFA-TR*              :WS-UTG-AMT-AFTER-30:WS-45-NULL-IND-30,                    
MFA-TR*              :WS-UTG-AMT-AFTER-60:WS-45-NULL-IND-60,                    
MFA-TR*              :WS-UTG-AMT-AFTER-90:WS-45-NULL-IND-90,                    
MFA-TR*              :WS-UTG-AMT-UNBILLED:WS-45-NULL-IND-UN                     
MFA-TR*         FROM CSS_AR_CNTL                                                
MFA-TR*        WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                         
MFA-TR*          AND PYMT_PRIORITY_LVL = :WS-45                                 
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7500                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-45-NULL-IND-00 < 0                                  
                 MOVE 0      TO WS-UTG-AMT-AFTER-00                     
              END-IF                                                    
              IF WS-45-NULL-IND-30 < 0                                  
                 MOVE 0      TO WS-UTG-AMT-AFTER-30                     
              END-IF                                                    
              IF WS-45-NULL-IND-60 < 0                                  
                 MOVE 0      TO WS-UTG-AMT-AFTER-60                     
              END-IF                                                    
              IF WS-45-NULL-IND-90 < 0                                  
                 MOVE 0      TO WS-UTG-AMT-AFTER-90                     
              END-IF                                                    
              IF WS-45-NULL-IND-UN < 0                                  
                 MOVE 0      TO WS-UTG-AMT-UNBILLED                     
              END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE       TO S-RETURN-CODE         
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '7500'                      TO ACTIVE-PARAGRAPH      
              MOVE 'SELECT'                    TO ABEND-FUNCTION        
              MOVE 'CSS_AR_CNTL'               TO TABLE-1               
              MOVE 'ACCOUNT_NO  '              TO TABLE-ELEMENT-1       
              MOVE AC-ACCOUNT-NO               TO HOSTVAR-ELEMENT-1     
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 8000-DELETE-FINAL-WO.                                                   
      ******************************************************************        
       8000-DELETE-FINAL-WO.                                            
      *                                                                         
           EXEC SQL                                                     
              DELETE FROM CSS_FINAL_WO                                  
               WHERE ACCOUNT_NO        = :FW-ACCOUNT-NO                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE         TO WS-ACTIVE-RETURN-CODE.               
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8000'                     TO ACTIVE-PARAGRAPH       
              MOVE 'DELETE'                   TO ABEND-FUNCTION         
              MOVE 'CSS_FINAL_WO'             TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE FW-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 8100-SEND-RESULT                                              *         
      ******************************************************************        
      *                                                                         
       8100-SEND-RESULT.                                                
      *                                                                         
           ADD +1                           TO CTR-ROWS.                
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8150-DELETE-FIN-WO-ACT.                                        *        
      ******************************************************************        
       8150-DELETE-FIN-WO-ACT.                                          
      *                                                                         
           EXEC SQL                                                     
              DELETE FROM CSS_FIN_WO_ACTION                             
               WHERE ACCOUNT_NO        = :KD-ACCOUNT-NO                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE         TO WS-ACTIVE-RETURN-CODE.               
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8150'                     TO ACTIVE-PARAGRAPH       
              MOVE 'DELETE'                   TO ABEND-FUNCTION         
              MOVE 'CSS_FIN_WO_ACTION'        TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE KD-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       8150-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************  14930000
      * 8200-UPDATE-ACCOUNT.                                            14940000
      ****************************************************************  14950000
       8200-UPDATE-ACCOUNT.                                             
      *                                                                 14970000
           EXEC SQL                                                     
               UPDATE CSS_ACCOUNT                                       
               SET CODE_ACCT_STAT     = :WS-A                           
                  ,CODE_STATUS_REASON = :WS-A                           
                  ,ACCT_FINALED_DT    =                                 
                      CIS.CHAR2TIMESTAMP(:AT-ACCT-FINALED-DT 
                                         :WS-ACCT-FINALED-DT-NULL)       
                  ,CODES_DATA_PRESENT = :WS-CODES                       
               WHERE ACCOUNT_NO       = :AT-ACCOUNT-NO                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     15000000
MFA-TR*        UPDATE CSS_ACCOUNT                                       15010000
MFA-TR*        SET CODE_ACCT_STAT     = :WS-A                           15020000
MFA-TR*           ,CODE_STATUS_REASON = :WS-A                                   
MFA-TR*           ,ACCT_FINALED_DT    =                                 15030000
MFA-TR*               :AT-ACCT-FINALED-DT:WS-ACCT-FINALED-DT-NULL       15030000
MFA-TR*           ,CODES_DATA_PRESENT = :WS-CODES                               
MFA-TR*        WHERE ACCOUNT_NO       = :AT-ACCOUNT-NO                  15050000
MFA-TR*    END-EXEC.                                                    15060000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE       TO S-RETURN-CODE         
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '8200'                      TO ACTIVE-PARAGRAPH      
              MOVE 'UPDATE'                    TO ABEND-FUNCTION        
              MOVE 'CSS_ACCOUNT'               TO TABLE-1               
              MOVE 'ACCOUNT_NO  '              TO TABLE-ELEMENT-1       
              MOVE AT-ACCOUNT-NO               TO HOSTVAR-ELEMENT-1     
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       8200-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **   8300-DELETE-UTG-ROW.                                     **          
      **       DELETES UTG ROW ON THE ACCOUNT                       **          
      ****************************************************************          
      *                                                                         
       8300-DELETE-UTG-ROW.                                             
      *                                                                         
           EXEC SQL                                                     
              DELETE FROM CSS_AR_CNTL                                   
               WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                 
                 AND PYMT_PRIORITY_LVL = :WS-45                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8300'                     TO ACTIVE-PARAGRAPH       
              MOVE 'DELETE'                   TO ABEND-FUNCTION         
              MOVE 'CSS_AR_CNTL'              TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE AC-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  18586100
      **  8500-CREATE-AR-CNTL                                       **  18586300
      ****************************************************************  18587000
      *                                                                 18587100
       8500-CREATE-AR-CNTL.                                             
      *                                                                 18587300
           EXEC SQL                                                     
             INSERT INTO CSS_AR_CNTL                                    
                 (ACCOUNT_NO,                                           
                 AMT_AR_DAY_00,                                         
                 AMT_AR_DAY_30,                                         
                 AMT_AR_DAY_60,                                         
                 AMT_AR_DAY_90,                                         
                 AMT_TRAN_BALANCE,                                      
                 AMT_UNUSED_CR,                                         
                 ITEM_ID,                                               
                 LAST_UPDATE_TS,                                        
                 PYMT_PRIORITY_LVL,                                     
                 TOT_SUMM_UNBILLED)                                     
             VALUES                                                     
                 (:AC-ACCOUNT-NO,                                       
                 :AC-AMT-AR-DAY-00,                                     
                 0,                                                     
                 0,                                                     
                 0,                                                     
                 :AC-AMT-TRAN-BALANCE,                                  
                 0,                                                     
                 :AC-ITEM-ID,                                           
                 CIS.CHAR2TIMESTAMP(:WS-TIMESTAMP),                             
                 :AC-PYMT-PRIORITY-LVL,                                 
                 0)                                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     18587600
MFA-TR*      INSERT INTO CSS_AR_CNTL                                    18587700
MFA-TR*          (ACCOUNT_NO,                                           18587800
MFA-TR*          AMT_AR_DAY_00,                                         18587900
MFA-TR*          AMT_AR_DAY_30,                                         18588000
MFA-TR*          AMT_AR_DAY_60,                                         18588100
MFA-TR*          AMT_AR_DAY_90,                                         18588200
MFA-TR*          AMT_TRAN_BALANCE,                                      18588300
MFA-TR*          AMT_UNUSED_CR,                                         18588400
MFA-TR*          ITEM_ID,                                               18588500
MFA-TR*          LAST_UPDATE_TS,                                        18588600
MFA-TR*          PYMT_PRIORITY_LVL,                                     18588700
MFA-TR*          TOT_SUMM_UNBILLED)                                     18588800
MFA-TR*      VALUES                                                     18588900
MFA-TR*          (:AC-ACCOUNT-NO,                                       18589000
MFA-TR*          :AC-AMT-AR-DAY-00,                                     18589200
MFA-TR*          0,                                                     18589300
MFA-TR*          0,                                                     18589400
MFA-TR*          0,                                                     18589600
MFA-TR*          :AC-AMT-TRAN-BALANCE,                                  18589500
MFA-TR*          0,                                                     18589600
MFA-TR*          :AC-ITEM-ID,                                           18589700
MFA-TR*          :WS-TIMESTAMP,                                         18589800
MFA-TR*          :AC-PYMT-PRIORITY-LVL,                                 18589900
MFA-TR*          0)                                                     18590000
MFA-TR*    END-EXEC.                                                    18590700

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 18590800
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                 18590800
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8500'                     TO ACTIVE-PARAGRAPH       
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_AR_CNTL'              TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE AC-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                 18591000
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 18592300
      ****************************************************************  11191400
      *   8600-BATCH-LOAD-AR-TRAN-HIST                              **  11191600
      *       INSERT DATA INTO CSS_AR_TRANS_HIST TABLE              **  11191700
      ****************************************************************  11191900
       8600-BATCH-LOAD-AR-TRAN-HIST.                                    
      *                                                                 11192300
           EXEC SQL                                                     
                INSERT INTO  CSS_AR_TRANS_HIST                          
                (ACCOUNT_NO,                                            
                 TRANS_HIST_SEQ_NO,                                     
                 DATE_TRANS,                                            
                 CODE_TRAN_TYPE,                                        
                 AMT_ORIG_ENTERED,                                      
                 AMT_BILLED_UNPAID,                                     
                 RESP_AREA_ID,                                          
                 APPL_PROGRAM_ID,                                       
                 PYMT_FACILITY_CD,                                      
                 USER_ID,                                               
                 COMPANY_NO,                                            
                 TRAN_COMMENT,                                          
                 RECORD_ONLY_FL,                                        
                 DATE_ORIG_PYMT,                                        
                 CASH_COMPANY_NO,                                       
                 CASH_LOCAL_OFFICE,                                     
                 CASH_REPORT_NO,                                        
                 DATE_CASH_REPORT,                                      
                 CASH_DRAWER_ID)                                        
                VALUES                                                  
                (:AR-ACCOUNT-NO,                                        
                 CIS.CHAR2TIMESTAMP(:AR-TRANS-HIST-SEQ-NO) ,                    
                 IIF(TRY_CONVERT(DATE, :AR-DATE-TRANS
              ) IS NULL OR (PATINDEX('%.%', :AR-DATE-TRANS
              ) <> 0) OR (LEN(:AR-DATE-TRANS) <> 10), CIS.CHAR2DATE(
                                                         :AR-DATE-TRANS
              ), CONVERT(DATE, :AR-DATE-TRANS) ),                              
                 :AR-CODE-TRAN-TYPE,                                    
                 :AR-AMT-ORIG-ENTERED,                                  
                 :AR-AMT-BILLED-UNPAID,                                 
                 :AR-RESP-AREA-ID,                                      
                 :AR-APPL-PROGRAM-ID,                                   
                 :AR-PYMT-FACILITY-CD,                                  
                 :AR-USER-ID,                                           
                 :AR-COMPANY-NO,                                        
                 :AR-TRAN-COMMENT,                                      
                 :AR-RECORD-ONLY-FL,                                    
                  NULL,                                                 
                 :AR-CASH-COMPANY-NO,                                   
                 :AR-CASH-LOCAL-OFFICE,                                 
                 :AR-CASH-REPORT-NO,                                    
                  CAST(SYSDATETIMEOFFSET() AS DATE),                            
                 :AR-CASH-DRAWER-ID)                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     11192400
MFA-TR*         INSERT INTO  CSS_AR_TRANS_HIST                          11192500
MFA-TR*         (ACCOUNT_NO,                                            11192600
MFA-TR*          TRANS_HIST_SEQ_NO,                                     11192600
MFA-TR*          DATE_TRANS,                                            11192600
MFA-TR*          CODE_TRAN_TYPE,                                        11192600
MFA-TR*          AMT_ORIG_ENTERED,                                      11192600
MFA-TR*          AMT_BILLED_UNPAID,                                     11192600
MFA-TR*          RESP_AREA_ID,                                          11192600
MFA-TR*          APPL_PROGRAM_ID,                                       11192600
MFA-TR*          PYMT_FACILITY_CD,                                      11192600
MFA-TR*          USER_ID,                                               11192700
MFA-TR*          COMPANY_NO,                                            11192800
MFA-TR*          TRAN_COMMENT,                                          11192900
MFA-TR*          RECORD_ONLY_FL,                                        11192900
MFA-TR*          DATE_ORIG_PYMT,                                        11192900
MFA-TR*          CASH_COMPANY_NO,                                       11193000
MFA-TR*          CASH_LOCAL_OFFICE,                                     11193100
MFA-TR*          CASH_REPORT_NO,                                        11193100
MFA-TR*          DATE_CASH_REPORT,                                      11193200
MFA-TR*          CASH_DRAWER_ID)                                        11193400
MFA-TR*         VALUES                                                  11193500
MFA-TR*         (:AR-ACCOUNT-NO,                                        11193600
MFA-TR*          :AR-TRANS-HIST-SEQ-NO ,                                11193600
MFA-TR*          :AR-DATE-TRANS,                                                
MFA-TR*          :AR-CODE-TRAN-TYPE,                                    11193600
MFA-TR*          :AR-AMT-ORIG-ENTERED,                                  11193600
MFA-TR*          :AR-AMT-BILLED-UNPAID,                                 11193600
MFA-TR*          :AR-RESP-AREA-ID,                                      11193700
MFA-TR*          :AR-APPL-PROGRAM-ID,                                   11193800
MFA-TR*          :AR-PYMT-FACILITY-CD,                                  11193900
MFA-TR*          :AR-USER-ID,                                           11193900
MFA-TR*          :AR-COMPANY-NO,                                        11193900
MFA-TR*          :AR-TRAN-COMMENT,                                      11194000
MFA-TR*          :AR-RECORD-ONLY-FL,                                    11194000
MFA-TR*           NULL,                                                         
MFA-TR*          :AR-CASH-COMPANY-NO,                                   11194100
MFA-TR*          :AR-CASH-LOCAL-OFFICE,                                 11194200
MFA-TR*          :AR-CASH-REPORT-NO,                                    11194200
MFA-TR*           CURRENT DATE,                                         11194400
MFA-TR*          :AR-CASH-DRAWER-ID)                                    11194400
MFA-TR*    END-EXEC.                                                    11194500

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 11194600
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                 11194800
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8600'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_ACCOUNT'             TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE AR-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                 11195700
       8600-EXIT.                                                       
            EXIT.                                                       
      *                                                                 11196000
      ******************************************************************16390000
      *   8700-UPDATE-BILLING-HDR                                     **11191600
      *  UPDATE THE CODE-BILL-TYPE ON THE CSS_BILLING_HDR TABLE.       *16400000
      ******************************************************************16410000
       8700-UPDATE-BILLING-HDR.                                         
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_BILLING_HDR                                   
                    SET CODE_BILL_TYPE = :WS-A                          
                   WHERE ACCOUNT_NO    = :BI-ACCOUNT-NO                 
                     AND BILL_NO       = :BI-BILL-NO                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8700'                     TO ACTIVE-PARAGRAPH       
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_BILLING_HDR'          TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE BI-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE BI-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                 11195700
       8700-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************  18655100
      **    8750-INSRT-AR-TRN-DET                                   **  18655300
      ****************************************************************  18655600
      *                                                                 18655700
       8750-INSRT-AR-TRN-DET.                                           
      *                                                                 18655900
           EXEC SQL                                                     
             INSERT INTO CSS_AR_TRN_HST_DET                             
               (ACCOUNT_NO,                                             
                TRANS_HIST_SEQ_NO,                                      
                TRAN_APPL_NO,                                           
                CODE_AR_AGE,                                            
                GL_ACCT_CREDIT,                                         
                GL_ACCT_DEBIT,                                          
                AMT_POSTED,                                             
                ITEM_ID,                                                
                CODE_CONTRACT_TYPE,                                     
                CURRENCY_TYPE,                                          
                CURRENCY_AMT)                                           
             VALUES                                                     
                (:AU-ACCOUNT-NO,                                        
                CIS.CHAR2TIMESTAMP(:AU-TRANS-HIST-SEQ-NO),                      
                :AU-TRAN-APPL-NO,                                       
                :AU-CODE-AR-AGE,                                        
                :AU-GL-ACCT-CREDIT,                                     
                :AU-GL-ACCT-DEBIT,                                      
                :AU-AMT-POSTED,                                         
                :AU-ITEM-ID,                                            
                :AU-CODE-CONTRACT-TYPE,                                 
                :AU-CURRENCY-TYPE,                                      
                :AU-CURRENCY-AMT)                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     18656200
MFA-TR*      INSERT INTO CSS_AR_TRN_HST_DET                             18656300
MFA-TR*        (ACCOUNT_NO,                                             18656400
MFA-TR*         TRANS_HIST_SEQ_NO,                                      18656500
MFA-TR*         TRAN_APPL_NO,                                           18656600
MFA-TR*         CODE_AR_AGE,                                            18656700
MFA-TR*         GL_ACCT_CREDIT,                                         18656800
MFA-TR*         GL_ACCT_DEBIT,                                          18656900
MFA-TR*         AMT_POSTED,                                             18657000
MFA-TR*         ITEM_ID,                                                18657100
MFA-TR*         CODE_CONTRACT_TYPE,                                     18657200
MFA-TR*         CURRENCY_TYPE,                                          18657300
MFA-TR*         CURRENCY_AMT)                                           18657400
MFA-TR*      VALUES                                                     18657500
MFA-TR*         (:AU-ACCOUNT-NO,                                        18657600
MFA-TR*         :AU-TRANS-HIST-SEQ-NO,                                  18657700
MFA-TR*         :AU-TRAN-APPL-NO,                                       18657800
MFA-TR*         :AU-CODE-AR-AGE,                                        18657900
MFA-TR*         :AU-GL-ACCT-CREDIT,                                     18658000
MFA-TR*         :AU-GL-ACCT-DEBIT,                                      18658100
MFA-TR*         :AU-AMT-POSTED,                                         18658200
MFA-TR*         :AU-ITEM-ID,                                            18658300
MFA-TR*         :AU-CODE-CONTRACT-TYPE,                                 18658400
MFA-TR*         :AU-CURRENCY-TYPE,                                      18658500
MFA-TR*         :AU-CURRENCY-AMT)                                       18658600
MFA-TR*    END-EXEC.                                                    18658700

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 18658800
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                 18659000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8750'                     TO ACTIVE-PARAGRAPH       
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_AR_TRN_HST_DET'       TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE AU-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                 18659900
       8750-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 9700-PROCESS-ABEND - COMBINED ERROR HANDLING INCLUDE           *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD0023C                                                  
           END-EXEC.                                                            
      ******************************************************************        
      * 9900 - JOURNALING / ERROR HANDLING ROUTINE                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD00321                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *9900-ABEND.                                                    *         
      *****************************************************************         
      *                                                                         
       9900-ABEND.                                                      
           PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT.             
           PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT.             
      *                                                                         
