       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR04666.                                     
COB303 DATE-WRITTEN.     DEC 18, 2013.                                  
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROCEDURE PERFORMS AN UPDATE, INSERT                     *        
      *  INFORMATION IN THE CSS_ACCT_MKT_TIER                          *        
      *  THIS STORED PROCEDURE IS CLONED FROM CSR04098                 *        
      ******************************************************************        
      *----------------------------------------------------------------*        
      *    PARAMETERS                                                  *        
      *                                                                *        
      *        INPUT                                                   *        
      *               ACCOUNT_NO          DECIMAL(13, 0)               *        
      *               TIER_CUST_STAT_CD   CHAR(1)                      *        
      *               TIER_ACCT_TYPE_CD   CHAR(1)                      *        
      *               MKT_TIER_RANKING    SMALLINT                     *        
      *               COMPANY_NO          CHAR(1)                      *        
      *                                                                *        
      *                                                                *        
      *        OUT                                                     *        
      *                                                                *        
      *              NONE                                              *        
      *                                                                *        
      *        INOUT                                                   *        
      *                                                                *        
      *              NONE                                              *        
      *                                                                *        
      *    RESULT SET                                                  *        
      *                                                                *        
      *                                                                *        
      *     CSR04666_R1 - BUS RULE DETAILS                             *        
      *                                                                *        
      *             RETURN_CODE         INTEGER                        *        
      *            ,APPL_RETURN_CODE    INTEGER                        *        
      *            ,BUS_RULE_ID         CHAR(10)                       *        
      *            ,BUS_RULE_RESULT_CD  CHAR(10)                       *        
      *            ,BUS_RULE_XREF_ID    CHAR(26)                       *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      * 12/18/2013  AD7F921   INITIAL VERSION                          *        
P00738* 10/01/2014  AW41078   CHANGED CSR0409M TO CSR04666 WHEN WRITING*        
P00738*                       TO TRANSACTION HISTORY.                  *        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04666'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04098 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CSS_ACCT_MKT_TIER, DD                                         *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBMKTIER                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CRM_MKT_TIER_ADJ, 1B                                          *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBMKTTAD                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CRM_MKT_TIER, IG                                               *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMKTTER                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CSS_ACCOUNT, AT                                               *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *  CSS_DELINQUENCY C8                                           *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CSS_CUSTOMER, CU                                              *         
      *****************************************************************         
            EXEC SQL                                                            
              INCLUDE TBCUST                                                    
            END-EXEC.                                                           
      *                                                                         
      *****************************************************************         
      *  CRM_TIER_ACCT_TYPE - TT                                      *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBTIACTP                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *  CSS_USER_PROFILE   - PF                                      *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *  CSS_MNT_TRANS_HIST - MH                                      *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *  CSS_MT_TRN_HST_DET  - MI                                     *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CSS_CODE_VALUE, UV                                            *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBCDVALU                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CSS_CUST_STATS, CE                                            *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBCSTSTS                                               
            END-EXEC.                                                           
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
           COPY CCA00001.                                                       
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
      *                                                                         
           COPY CWS00027.                                                       
      *                                                                         
           COPY CWS00303.                                                       
      *                                                                         
      ******************************************************************        
      *   GTT TABLE LAYOUT FOR BUS RULE ERROR MESSAGE                  *        
      ******************************************************************        
       01  GTT-RETURN-FIELDS.                                           
           05 S-RETURN-CODE               PIC S9(04) COMP  VALUE 0.     
           05 S-APPL-RETURN-CODE          PIC S9(04) COMP  VALUE 0.     
           05 S-RS1-BUS-RULE-ID           PIC X(10)  VALUE SPACES.      
           05 S-RS1-BUS-RULE-RESULT-CD    PIC X(10)  VALUE SPACES.      
           05 S-RS1-BUS-RULE-XREF-ID      PIC X(26)  VALUE SPACES.      
                                                                        
       01  SWITCHES.                                                    
           05  WS-MKT-TIER-FOUND       PIC X(01) VALUE 'N'.             
               88 MKT-TIER-FOUND                 VALUE 'Y'.             
           05  WS-CUSTOMER-ON-SR-TIER  PIC X(01) VALUE 'N'.             
               88 CUSTOMER-ON-SR-TIER            VALUE 'Y'.             
      *                                                                         
       01 WS-WORKING-STORAGE.                                           
           05 WS-ACCOUNT-NO            PIC 9(13) VALUE ZEROES.          
           05 WS-TIER-CUST-STAT-CD     PIC X(01) VALUE SPACES.          
           05 WS-TIER-ACCT-TYPE-CD     PIC X(01) VALUE SPACES.          
           05 WS-MKT-TIER-RANKING      PIC 9(04) VALUE ZEROES.          
           05 WS-EFF-START-DT          PIC X(10) VALUE SPACES.          
           05 WS-TIER-SOURCE-CD        PIC X(02) VALUE SPACES.          
           05 WS-ADJ-TIER-SEQ-NO       PIC 9(04) VALUE ZEROES.          
           05 WS-COMPANY-NO            PIC X(02) VALUE SPACES.          
           05 WS-USER-ID               PIC X(07) VALUE SPACES.          
           05 WS-CURRENT-TIMESTAMP     PIC X(26) VALUE SPACES.          
           05 WS-CURRENT-DATE          PIC X(10) VALUE SPACES.          
           05 WS-MKT-TIER-START-DT     PIC X(10) VALUE SPACES.          
           05 WS-TRAN-APPL-NO          PIC S9(04) COMP VALUE 0.         
           05 WS-GTT-NAME              PIC X(26) VALUE SPACES.          
           05 WS-DHR-CUSTOMER          PIC X(01) VALUE 'N'.             
           05 WS-CODE-VALUE            PIC X(10) VALUE SPACES.          
           05 WS-CURR-MKT-TIER-DESC    PIC X(50) VALUE SPACES.          
           05 WS-PREV-MKT-TIER-DESC    PIC X(50) VALUE SPACES.          
           05 WS-CURR-TIER-ADJ-DESC    PIC X(80) VALUE SPACES.          
           05 WS-PREV-TIER-ADJ-DESC    PIC X(80) VALUE SPACES.          
           05 WS-TRANS-HIST-COMMENT    PIC X(210) VALUE SPACES.         
           05 WS-COM-REV-MONTH         PIC X(06) VALUE SPACES.          
           05 WS-TIER-RANK-Z           PIC Z(04).                       
           05 WS-DUMMY-DATE-ST         PIC X(10) VALUE SPACES.          
           05 WS-DUMMY-DATE-END        PIC X(10) VALUE SPACES.          
           05 WS-SQLSTATE              PIC X(05) VALUE SPACES.          
           05 WS-RESULT-YEAR           PIC S9(04) COMP.                 
      *                                                                         
       01 WS-LITERALS.                                                  
           05 WS-UPDATE-ACCT-TIER     PIC X(01) VALUE 'M'.              
           05 WS-MKT-TIER-UPD         PIC X(08) VALUE 'CSR04666'.       
           05 SCANA-SR-DEFLT-FLAG     PIC X(01) VALUE 'S'.              
           05 SCANA-SR-AGE            PIC X(17)                         
                                             VALUE 'SCANA SENIOR AGE'.  
      *                                                                         
       01  WS-NULL-INDICATORS.                                          
           05 WS-NULL-IND-01          PIC S9(4) COMP.                   
           05 WS-NULL-IND-02          PIC S9(4) COMP.                   
      *                                                                         
       01  PROGRAM-NAME-FIELD.                                          
           05  PROGRAM-NAME           PIC X(08) VALUE 'CSR04666'.       
      *                                                                         
       LINKAGE SECTION.                                                 
COB305 01 PARM-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.         
       01  PARM-TIER-CUST-STAT-CD     PIC X(01).                        
       01  PARM-TIER-ACCT-TYPE-CD     PIC X(01).                        
       01  PARM-MKT-TIER-RANKING      PIC S9(4) COMP.                   
       01  PARM-COMPANY-NO            PIC X(02).                        
       01  PARM-USER-ID               PIC X(07).                        
       01  PARM-TRANS-HIST-COMMENT    PIC X(210).                       
      *                                                                         
       PROCEDURE DIVISION USING PARM-ACCOUNT-NO                         
                                PARM-TIER-CUST-STAT-CD                  
                                PARM-TIER-ACCT-TYPE-CD                  
                                PARM-MKT-TIER-RANKING                   
                                PARM-COMPANY-NO                         
                                PARM-USER-ID                            
                                PARM-TRANS-HIST-COMMENT.                
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      *     RESET DB2 ERROR HANDLERS                                   *        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1          THRU 0100A-EXIT.       
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      *                                                                         
      *  0100A-DECLARE-GTT-R1                                                   
      ****************************************************************          
       0100A-DECLARE-GTT-R1.                                            
                                                                        
           MOVE 'SESSION.CSR04666_R1'      TO WS-GTT-NAME.              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04666_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04666_R1
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,BUS_RULE_ID CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BUS_RULE_RESULT_CD CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BUS_RULE_XREF_ID CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS         THRU 8000A-EXIT        
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100A'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT         
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,LTRIM(RTRIM(BUS_RULE_ID))          AS BUS_RULE_ID       
                      ,LTRIM(RTRIM(BUS_RULE_RESULT_CD))   AS 
           BUS_RULE_RESULT_CD
                      ,LTRIM(RTRIM(BUS_RULE_XREF_ID))     AS 
           BUS_RULE_XREF_ID  
                  FROM #CSR04666_R1                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,STRIP(BUS_RULE_ID)          AS BUS_RULE_ID               
MFA-TR*               ,STRIP(BUS_RULE_RESULT_CD)   AS BUS_RULE_RESULT_CD        
MFA-TR*               ,STRIP(BUS_RULE_XREF_ID)     AS BUS_RULE_XREF_ID          
MFA-TR*           FROM SESSION.CSR04666_R1                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      *                                                                *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-ACCOUNT-NO              TO AT-ACCOUNT-NO           
                                                DD-ACCOUNT-NO.          
      *                                                                         
           MOVE PARM-TIER-CUST-STAT-CD       TO WS-TIER-CUST-STAT-CD.   
           MOVE PARM-TIER-ACCT-TYPE-CD       TO WS-TIER-ACCT-TYPE-CD.   
           MOVE PARM-MKT-TIER-RANKING        TO WS-MKT-TIER-RANKING.    
           MOVE PARM-USER-ID                 TO WS-USER-ID.             
           PERFORM 7800-SELECT-RESP-AREA        THRU 7800-EXIT.         
           MOVE PARM-TRANS-HIST-COMMENT      TO WS-TRANS-HIST-COMMENT.  
      *                                                                         
           MOVE PARM-COMPANY-NO              TO WS-COMPANY-NO           
                                                UV-COMPANY-NO.          
      * GET REVENUE MONTH                                                       
           PERFORM 7260-SEL-ACCOUNT-DET         THRU 7260-EXIT.         
                                                                        
           PERFORM 7000-SET-TIMESTAMP           THRU 7000-EXIT.         
           MOVE WS-CURRENT-TIMESTAMP         TO DD-CREATED-TS.          
           MOVE WS-CURRENT-DATE              TO WS-EFF-START-DT         
                                                DD-EFF-START-DT.        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 5200-UPDATE-ACCT-TIER  THRU 5200-EXIT.               
           PERFORM 8010-INSERT-GTT-R1     THRU 8010-EXIT.               
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5200-UPDATE-ACCT-TIER                                          *        
      ******************************************************************        
       5200-UPDATE-ACCT-TIER.                                           
                                                                        
           MOVE 'ON'                        TO WS-TIER-SOURCE-CD.       
                                                                        
           MOVE WS-TIER-CUST-STAT-CD        TO IG-TIER-CUST-STAT-CD.    
           MOVE WS-TIER-ACCT-TYPE-CD        TO IG-TIER-ACCT-TYPE-CD.    
           MOVE WS-MKT-TIER-RANKING         TO IG-MKT-TIER-RANKING      
                                               1B-MKT-TIER-RANKING      
                                               1B-ADJ-TIER-RANKING.     
      *                                                                         
           MOVE WS-COMPANY-NO               TO IG-COMPANY-NO.           
      *                                                                         
           PERFORM 7620-SEL-MKT-EFF-DT           THRU 7620-EXIT         
      *                                                                         
           MOVE IG-MKT-TIER-START-DT        TO WS-MKT-TIER-START-DT     
           MOVE IG-MKT-TIER-DESC            TO WS-CURR-MKT-TIER-DESC    
      *                                                                         
           IF IG-CUST-ACCT-DEFLT-FL EQUAL SCANA-SR-DEFLT-FLAG           
              SET CUSTOMER-ON-SR-TIER       TO TRUE                     
           END-IF                                                       
                                                                        
           MOVE 'N'                         TO WS-DHR-CUSTOMER.         
           MOVE AT-CUSTOMER-NO              TO CU-CUSTOMER-NO.          
           PERFORM 7840-SEL-DHR-HIST             THRU 7840-EXIT.        
           MOVE WS-DHR-CUSTOMER             TO 1B-DHR-QUALIFIED-FL      
                                                                        
           MOVE ZEROES                      TO 1B-ADJ-TIER-SEQ-NO.      
           IF CUSTOMER-ON-SR-TIER                                       
              MOVE AT-CUSTOMER-NO           TO CE-CUSTOMER-NO           
              MOVE 'C'                      TO CE-CUSTOMER-TYPE         
              MOVE SPACES                   TO CE-DOB-VERIFIED-CD       
                                               CE-DATE-OF-BIRTH         
             PERFORM 7080-SELECT-CUST-STATS      THRU 7080-EXIT         
             IF CE-DOB-VERIFIED-CD NOT EQUAL SPACES                     
                           AND CE-DATE-OF-BIRTH NOT EQUAL SPACES        
                MOVE WS-CURRENT-DATE        TO WS-DUMMY-DATE-ST         
                MOVE CE-DATE-OF-BIRTH       TO WS-DUMMY-DATE-END        
                MOVE SCANA-SR-AGE           TO C8-DELINQ-CD             
                MOVE '01'                   TO C8-COMPANY-NO            
                PERFORM 7060-SELECT-DELINQNCY    THRU 7060-EXIT         
                PERFORM 7070-GET-YEAR-BETWEEN    THRU 7070-EXIT         
                IF WS-RESULT-YEAR >= C8-DELINQ-VALUE                    
                   MOVE 'S'                 TO 1B-AGL-LOW-INCM-SR-FL    
                   PERFORM 7860-SEL-TIER-ADJ-SEQ-NO-SR                  
                                                 THRU 7860-EXIT         
                ELSE                                                    
                   MOVE 'Y'                 TO 1B-AGL-LOW-INCM-SR-FL    
                   PERFORM 7860-SEL-TIER-ADJ-SEQ-NO-SR                  
                                                 THRU 7860-EXIT         
                END-IF                                                  
             ELSE                                                       
                MOVE 'Y'                    TO 1B-AGL-LOW-INCM-SR-FL    
                PERFORM 7860-SEL-TIER-ADJ-SEQ-NO-SR                     
                                                 THRU 7860-EXIT         
             END-IF                                                     
            ELSE                                                        
               PERFORM 7810-SEL-TIER-ADJ-SEQ-NO  THRU 7810-EXIT         
            END-IF                                                      
            MOVE 1B-ADJ-TIER-SEQ-NO         TO WS-ADJ-TIER-SEQ-NO       
            MOVE 1B-TIER-ADJ-DESC           TO WS-CURR-TIER-ADJ-DESC    
                                                                        
            MOVE 'N'                        TO WS-MKT-TIER-FOUND        
            PERFORM 7630-SEL-MKT-TIER-DET        THRU 7630-EXIT         
                                                                        
            IF MKT-TIER-FOUND                                           
               MOVE DD-TIER-CUST-STAT-CD    TO IG-TIER-CUST-STAT-CD     
               MOVE DD-TIER-ACCT-TYPE-CD    TO IG-TIER-ACCT-TYPE-CD     
               MOVE DD-MKT-TIER-RANKING     TO IG-MKT-TIER-RANKING      
               MOVE DD-COMPANY-NO           TO IG-COMPANY-NO            
               MOVE DD-MKT-TIER-START-DT    TO IG-MKT-TIER-START-DT     
               PERFORM 7820-SEL-MKT-TIER-DESC    THRU 7820-EXIT         
               MOVE IG-MKT-TIER-DESC        TO WS-PREV-MKT-TIER-DESC    
                                                                        
               MOVE DD-ADJ-TIER-SEQ-NO      TO 1B-ADJ-TIER-SEQ-NO       
               MOVE SPACES                  TO 1B-TIER-ADJ-DESC         
               PERFORM 7830-SEL-TIER-ADJ-DESC    THRU 7830-EXIT         
               MOVE 1B-TIER-ADJ-DESC        TO WS-PREV-TIER-ADJ-DESC    
            END-IF                                                      
                                                                        
            IF MKT-TIER-FOUND                                           
               IF WS-EFF-START-DT EQUAL DD-EFF-START-DT                 
                  PERFORM 5595-DEL-INS-TIER-TANS THRU 5595-EXIT         
                  PERFORM 8410-DEL-MKT-TIER      THRU 8410-EXIT         
                  PERFORM 5210-MOVE-TIER-VALUES  THRU 5210-EXIT         
                  PERFORM 8000-INSERT-MKT-TIER   THRU 8000-EXIT         
               ELSE                                                     
                  PERFORM 5580-INS-TIER-TRNS-HIST                       
                                                 THRU 5580-EXIT         
                  PERFORM 5210-MOVE-TIER-VALUES  THRU 5210-EXIT         
                  PERFORM 8000-INSERT-MKT-TIER   THRU 8000-EXIT         
               END-IF                                                   
            ELSE                                                        
               PERFORM 5580-INS-TIER-TRNS-HIST   THRU 5580-EXIT         
               PERFORM 5210-MOVE-TIER-VALUES     THRU 5210-EXIT         
               PERFORM 8000-INSERT-MKT-TIER      THRU 8000-EXIT         
            END-IF.                                                     
                                                                        
       5200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5210-MOVE-TIER-VALUES.                                         *        
      ******************************************************************        
       5210-MOVE-TIER-VALUES.                                           
                                                                        
            MOVE WS-TIER-CUST-STAT-CD       TO DD-TIER-CUST-STAT-CD     
            MOVE WS-TIER-ACCT-TYPE-CD       TO DD-TIER-ACCT-TYPE-CD     
            MOVE WS-MKT-TIER-RANKING        TO DD-MKT-TIER-RANKING      
            MOVE WS-COMPANY-NO              TO DD-COMPANY-NO            
            MOVE WS-USER-ID                 TO DD-LAST-UPDATE-USERID.   
            MOVE WS-CURRENT-DATE            TO DD-LAST-EVALUATED-DT     
            MOVE WS-CURRENT-TIMESTAMP       TO DD-LAST-UPDATE-TS        
                                               DD-CREATED-TS.           
            MOVE WS-TIER-SOURCE-CD          TO DD-TIER-SOURCE-CD.       
            MOVE WS-ADJ-TIER-SEQ-NO         TO DD-ADJ-TIER-SEQ-NO.      
            MOVE WS-CURRENT-DATE            TO DD-EFF-START-DT.         
            MOVE WS-MKT-TIER-START-DT       TO DD-MKT-TIER-START-DT.    
                                                                        
       5210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5220-SELECT-CODE-VALUE.                                        *        
      ******************************************************************        
       5220-SELECT-CODE-VALUE.                                          
                                                                        
           MOVE SPACES                      TO UV-CODE-SHORT-DESC-TEXT  
           MOVE LENGTH OF UV-CODE-VALUE-TEXT                            
                                            TO UV-CODE-VALUE-LEN        
           MOVE LENGTH OF UV-COLUMN-NA-TEXT TO UV-COLUMN-NA-LEN         
           MOVE LENGTH OF UV-TABLE-NA-TEXT  TO UV-TABLE-NA-LEN          
           PERFORM 7700-SEL-CODE-VALUE-DESC      THRU 7700-EXIT.        
                                                                        
       5220-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************           
      *                                                             *           
      * 5580-INS-TIER-TRNS-HIST.                                    *           
      ***************************************************************           
       5580-INS-TIER-TRNS-HIST.                                         
                                                                        
           PERFORM 5800-LOAD-TRAN-HIST           THRU 5800-EXIT.        
                                                                        
           MOVE SPACES                      TO MI-TABLE-ID.             
           MOVE MH-TRANS-HIST-SEQ-NO        TO MI-TRANS-HIST-SEQ-NO.    
           MOVE +01                         TO WS-TRAN-APPL-NO          
                                                                        
           MOVE 'TIER_CUST_STAT_CD'         TO UV-COLUMN-NA-TEXT        
           MOVE LENGTH OF UV-COLUMN-NA-TEXT TO UV-COLUMN-NA-LEN         
           MOVE 'CRM_MKT_TIER'              TO UV-TABLE-NA-TEXT         
           MOVE LENGTH OF UV-TABLE-NA-TEXT  TO UV-TABLE-NA-LEN          
           MOVE 'ALL'                       TO UV-PROGRAM-ID            
           MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO.         
           IF DD-TIER-CUST-STAT-CD > SPACES                             
              MOVE DD-TIER-CUST-STAT-CD                                 
                                            TO UV-CODE-VALUE-TEXT       
              MOVE LENGTH OF UV-CODE-VALUE-TEXT                         
                                            TO UV-CODE-VALUE-LEN        
              PERFORM 7700-SEL-CODE-VALUE-DESC   THRU 7700-EXIT         
              MOVE UV-CODE-SHORT-DESC-TEXT  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                   
                                            TO MI-PRV-COLUMN-VALUE-LEN  
           ELSE                                                         
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
           END-IF                                                       
                                                                        
           MOVE SPACES                      TO UV-CODE-SHORT-DESC       
           MOVE WS-TIER-CUST-STAT-CD        TO UV-CODE-VALUE-TEXT       
           MOVE LENGTH OF UV-CODE-VALUE-TEXT                            
                                            TO UV-CODE-VALUE-LEN        
           PERFORM 7700-SEL-CODE-VALUE-DESC      THRU 7700-EXIT.        
           MOVE UV-CODE-SHORT-DESC-TEXT                                 
                                            TO MI-CHG-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                            TO MI-CHG-COLUMN-VALUE-LEN. 
           MOVE 'ACCOUNT TYPE'              TO MI-COLUMN-DESC.          
           PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT.        
           ADD  +1                          TO WS-TRAN-APPL-NO.         
                                                                        
                                                                        
           MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO.         
           MOVE 'TT'                        TO MI-TABLE-ID.             
           IF DD-TIER-ACCT-TYPE-CD > SPACES                             
              MOVE +01                      TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE DD-TIER-ACCT-TYPE-CD     TO MI-PRV-COLUMN-VALUE-TEXT 
           ELSE                                                         
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
           END-IF                                                       
           MOVE +01                         TO MI-CHG-COLUMN-VALUE-LEN  
           MOVE WS-TIER-ACCT-TYPE-CD        TO MI-CHG-COLUMN-VALUE-TEXT 
           MOVE 'ACCOUNT SUB TYPE'          TO MI-COLUMN-DESC.          
           PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT.        
           ADD  +1                          TO WS-TRAN-APPL-NO.         
                                                                        
           MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO.         
           MOVE SPACES                      TO MI-TABLE-ID.             
           IF WS-PREV-MKT-TIER-DESC > SPACES                            
              MOVE WS-PREV-MKT-TIER-DESC    TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                   
                                            TO MI-PRV-COLUMN-VALUE-LEN  
           ELSE                                                         
              MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
           END-IF                                                       
           MOVE WS-CURR-MKT-TIER-DESC       TO MI-CHG-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                            TO MI-CHG-COLUMN-VALUE-LEN. 
           MOVE 'TIER RANKING'              TO MI-COLUMN-DESC.          
           PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT.        
           ADD  +1                          TO WS-TRAN-APPL-NO.         
                                                                        
           MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO.         
           IF DD-EFF-START-DT > SPACES                                  
              MOVE +10                      TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE DD-EFF-START-DT          TO MI-PRV-COLUMN-VALUE-TEXT 
           ELSE                                                         
              MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
           END-IF                                                       
           MOVE +10                         TO MI-CHG-COLUMN-VALUE-LEN  
           MOVE WS-EFF-START-DT             TO MI-CHG-COLUMN-VALUE-TEXT 
           MOVE 'START DATE'                TO MI-COLUMN-DESC.          
           PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT.        
           ADD  +1                          TO WS-TRAN-APPL-NO.         
                                                                        
           MOVE 'TIER_SOURCE_CD'            TO UV-COLUMN-NA-TEXT        
           MOVE LENGTH OF UV-COLUMN-NA-TEXT                             
                                            TO UV-COLUMN-NA-LEN         
           MOVE 'CSS_ACCT_MKT_TIER'         TO UV-TABLE-NA-TEXT         
           MOVE LENGTH OF UV-TABLE-NA-TEXT                              
                                            TO UV-TABLE-NA-LEN          
           MOVE LENGTH OF UV-CODE-VALUE-TEXT                            
                                            TO UV-CODE-VALUE-LEN        
           MOVE 'ALL'                       TO UV-PROGRAM-ID            
           PERFORM 7700-SEL-CODE-VALUE-DESC      THRU 7700-EXIT.        
                                                                        
           MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO.         
           IF DD-TIER-SOURCE-CD > SPACES                                
              MOVE DD-TIER-SOURCE-CD        TO UV-CODE-VALUE-TEXT       
              PERFORM 7700-SEL-CODE-VALUE-DESC   THRU 7700-EXIT         
              MOVE UV-CODE-SHORT-DESC-TEXT                              
                                            TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                   
                                            TO MI-PRV-COLUMN-VALUE-LEN  
           ELSE                                                         
              MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
           END-IF                                                       
           MOVE WS-TIER-SOURCE-CD           TO UV-CODE-VALUE-TEXT       
           PERFORM 7700-SEL-CODE-VALUE-DESC      THRU 7700-EXIT.        
           MOVE UV-CODE-SHORT-DESC-TEXT     TO MI-CHG-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                            TO MI-CHG-COLUMN-VALUE-LEN. 
           MOVE 'SOURCE CODE'               TO MI-COLUMN-DESC.          
           PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT.        
           ADD  +1                          TO WS-TRAN-APPL-NO.         
                                                                        
           IF WS-ADJ-TIER-SEQ-NO EQUAL ZEROES                           
                             AND DD-ADJ-TIER-SEQ-NO EQUAL ZEROES        
              GO TO 5580-EXIT                                           
           END-IF                                                       
                                                                        
           MOVE 'TIER ADJ REASON'           TO MI-COLUMN-DESC.          
           MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO.         
           IF WS-PREV-TIER-ADJ-DESC > SPACES                            
              MOVE WS-PREV-TIER-ADJ-DESC                                
                                            TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                   
                                            TO MI-PRV-COLUMN-VALUE-LEN  
           ELSE                                                         
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                   
                                            TO MI-PRV-COLUMN-VALUE-LEN  
           END-IF                                                       
           MOVE WS-CURR-TIER-ADJ-DESC       TO MI-CHG-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                            TO MI-CHG-COLUMN-VALUE-LEN. 
           MOVE 'ADJ TIER SEQ NO'           TO MI-COLUMN-DESC.          
           PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT.            
                                                                        
       5580-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      *                                                             *           
      * 5595-DEL-INS-TIER-TANS.                                     *           
      ***************************************************************           
       5595-DEL-INS-TIER-TANS.                                          
                                                                        
           PERFORM 5800-LOAD-TRAN-HIST           THRU 5800-EXIT.        
                                                                        
           MOVE SPACES                      TO MI-TABLE-ID.             
           MOVE MH-TRANS-HIST-SEQ-NO        TO MI-TRANS-HIST-SEQ-NO.    
           MOVE +01                         TO WS-TRAN-APPL-NO          
                                                                        
           MOVE DD-TIER-CUST-STAT-CD        TO UV-CODE-VALUE-TEXT       
           MOVE 'TIER_CUST_STAT_CD'         TO UV-COLUMN-NA-TEXT        
           MOVE 'CRM_MKT_TIER'              TO UV-TABLE-NA-TEXT         
           MOVE 'ALL'                       TO UV-PROGRAM-ID            
           PERFORM 5220-SELECT-CODE-VALUE        THRU 5220-EXIT.        
                                                                        
           MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO.         
           MOVE UV-CODE-SHORT-DESC-TEXT     TO MI-PRV-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                            TO MI-PRV-COLUMN-VALUE-LEN. 
           MOVE WS-TIER-CUST-STAT-CD        TO UV-CODE-VALUE-TEXT       
           PERFORM 5220-SELECT-CODE-VALUE        THRU 5220-EXIT.        
           MOVE UV-CODE-SHORT-DESC-TEXT     TO MI-CHG-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                            TO MI-CHG-COLUMN-VALUE-LEN. 
           MOVE 'ACCOUNT TYPE'              TO MI-COLUMN-DESC.          
           PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT.        
           ADD  +1                          TO WS-TRAN-APPL-NO.         
                                                                        
                                                                        
           MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO.         
           MOVE 'TT'                        TO MI-TABLE-ID.             
           MOVE DD-TIER-ACCT-TYPE-CD        TO MI-PRV-COLUMN-VALUE-TEXT.
           MOVE +01                         TO MI-PRV-COLUMN-VALUE-LEN. 
           MOVE +01                         TO MI-CHG-COLUMN-VALUE-LEN. 
           MOVE WS-TIER-ACCT-TYPE-CD        TO MI-CHG-COLUMN-VALUE-TEXT.
           MOVE 'ACCOUNT SUB TYPE'          TO MI-COLUMN-DESC.          
           PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT.        
           ADD  +1                          TO WS-TRAN-APPL-NO.         
                                                                        
           MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO.         
           MOVE SPACES                      TO MI-TABLE-ID.             
           MOVE WS-PREV-MKT-TIER-DESC       TO MI-PRV-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
                                            TO MI-PRV-COLUMN-VALUE-LEN. 
           MOVE WS-CURR-MKT-TIER-DESC       TO MI-CHG-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                            TO MI-CHG-COLUMN-VALUE-LEN. 
           MOVE 'TIER RANKING'              TO MI-COLUMN-DESC.          
           PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT.        
           ADD  +1                          TO WS-TRAN-APPL-NO.         
                                                                        
           MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO.         
           MOVE +10                         TO MI-PRV-COLUMN-VALUE-LEN. 
           MOVE DD-EFF-START-DT             TO MI-PRV-COLUMN-VALUE-TEXT.
           MOVE +10                         TO MI-CHG-COLUMN-VALUE-LEN. 
           MOVE WS-EFF-START-DT             TO MI-CHG-COLUMN-VALUE-TEXT.
           MOVE 'START DATE'                TO MI-COLUMN-DESC.          
           PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT.        
           ADD  +1                          TO WS-TRAN-APPL-NO.         
                                                                        
           MOVE 'TIER_SOURCE_CD'            TO UV-COLUMN-NA-TEXT        
           MOVE 'CSS_ACCT_MKT_TIER'         TO UV-TABLE-NA-TEXT         
           MOVE 'ALL'                       TO UV-PROGRAM-ID            
           MOVE DD-TIER-SOURCE-CD           TO UV-CODE-VALUE-TEXT       
           PERFORM 5220-SELECT-CODE-VALUE        THRU 5220-EXIT.        
                                                                        
           MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO.         
           MOVE UV-CODE-SHORT-DESC-TEXT     TO MI-PRV-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                            TO MI-PRV-COLUMN-VALUE-LEN. 
           MOVE WS-TIER-SOURCE-CD           TO UV-CODE-VALUE-TEXT       
           PERFORM 5220-SELECT-CODE-VALUE        THRU 5220-EXIT.        
           MOVE UV-CODE-SHORT-DESC-TEXT     TO MI-CHG-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                            TO MI-CHG-COLUMN-VALUE-LEN. 
           MOVE 'SOURCE CODE'               TO MI-COLUMN-DESC.          
           PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT.        
           ADD  +1                          TO WS-TRAN-APPL-NO.         
                                                                        
           IF WS-ADJ-TIER-SEQ-NO EQUAL ZEROES                           
                                   AND DD-ADJ-TIER-SEQ-NO EQUAL ZEROES  
              GO TO 5595-EXIT                                           
           END-IF                                                       
                                                                        
           MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO.         
           MOVE WS-PREV-TIER-ADJ-DESC       TO MI-PRV-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                            TO MI-PRV-COLUMN-VALUE-LEN. 
           MOVE WS-CURR-TIER-ADJ-DESC       TO MI-CHG-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                            TO MI-CHG-COLUMN-VALUE-LEN. 
           MOVE 'TIER ADJ REASON'           TO MI-COLUMN-DESC.          
           PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT.        
                                                                        
       5595-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 5800-LOAD-TRAN-HIST.                                           *        
      ******************************************************************        
       5800-LOAD-TRAN-HIST.                                             
                                                                        
           PERFORM 7000-SET-TIMESTAMP         THRU 7000-EXIT.           
                                                                        
           MOVE AT-ACCOUNT-NO               TO MH-ACCOUNT-NO.           
           MOVE WS-MKT-TIER-UPD             TO MH-APPL-PROGRAM-ID.      
           MOVE 'F'                         TO MH-CODE-TRAN-TYPE.       
           MOVE WS-CURRENT-DATE             TO MH-DATE-TRANS.           
           MOVE ZEROES                      TO MH-CUSTOMER-NO           
                                               MH-PREMISE-NO.           
           MOVE PF-RESP-AREA-ID             TO MH-RESP-AREA-ID.         
           MOVE WS-CURRENT-TIMESTAMP        TO MH-TRANS-HIST-SEQ-NO.    
           MOVE WS-USER-ID                  TO MH-USER-ID.              
           IF WS-TRANS-HIST-COMMENT > SPACES                            
              MOVE WS-TRANS-HIST-COMMENT    TO MH-TRAN-COMMENT-TEXT     
              MOVE LENGTH OF MH-TRAN-COMMENT-TEXT                       
                                            TO MH-TRAN-COMMENT-LEN      
           ELSE                                                         
              MOVE SPACES                   TO MH-TRAN-COMMENT-TEXT     
              MOVE ZEROES                   TO MH-TRAN-COMMENT-LEN      
           END-IF.                                                      
                                                                        
       5800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7060-SELECT-DELINQNCY                                          *        
      ******************************************************************        
       7060-SELECT-DELINQNCY.                                           
                                                                        
           EXEC SQL                                                     
               SELECT DELINQ_VALUE                                      
                 INTO :C8-DELINQ-VALUE                                  
                 FROM CSS_DELINQUENCY C8 WITH(READUNCOMMITTED)                  
                WHERE C8.DELINQ_CD  = :C8-DELINQ-CD                     
                  AND C8.COMPANY_NO = :C8-COMPANY-NO                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DELINQ_VALUE                                              
MFA-TR*          INTO :C8-DELINQ-VALUE                                          
MFA-TR*          FROM CSS_DELINQUENCY C8                                        
MFA-TR*         WHERE C8.DELINQ_CD  = :C8-DELINQ-CD                             
MFA-TR*           AND C8.COMPANY_NO = :C8-COMPANY-NO                            
MFA-TR*           WITH UR                                                       
MFA-TR*           QUERYNO 7060                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7060'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_DELINQUENCY'        TO TABLE-1                  
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-1          
              MOVE 'DELINQ_CD'              TO TABLE-ELEMENT-2          
              MOVE C8-COMPANY-NO            TO HOSTVAR-ELEMENT-1        
              MOVE C8-DELINQ-CD             TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       7060-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7070-GET-YEAR-BETWEEN.                                         *        
      ******************************************************************        
       7070-GET-YEAR-BETWEEN.                                           
                                                                        
           EXEC SQL                                                     
               SELECT
              ( 12 *                            
                                        CIS.DECIMAL2YEAR(CIS.DIFFDATE( 
              IIF(TRY_CONVERT(DATE, :WS-DUMMY-DATE-ST
              ) IS NULL OR (PATINDEX('%.%', :WS-DUMMY-DATE-ST
              ) <> 0) OR (LEN(:WS-DUMMY-DATE-ST) <> 10), CIS.CHAR2DATE(
                                                      :WS-DUMMY-DATE-ST
              ), CONVERT(DATE, :WS-DUMMY-DATE-ST) ), 
              IIF(TRY_CONVERT(DATE, :WS-DUMMY-DATE-END
              ) IS NULL OR (PATINDEX('%.%', :WS-DUMMY-DATE-END
              ) <> 0) OR (LEN(:WS-DUMMY-DATE-END
              ) <> 10), CIS.CHAR2DATE(:WS-DUMMY-DATE-END
              ), CONVERT(DATE, :WS-DUMMY-DATE-END) ) ))     
                                        + 
           CIS.DECIMAL2MONTH(CIS.DIFFDATE( IIF(TRY_CONVERT(DATE, 
                                                      :WS-DUMMY-DATE-ST
              ) IS NULL OR (PATINDEX('%.%', :WS-DUMMY-DATE-ST
              ) <> 0) OR (LEN(:WS-DUMMY-DATE-ST) <> 10), CIS.CHAR2DATE(
                                                      :WS-DUMMY-DATE-ST
              ), CONVERT(DATE, :WS-DUMMY-DATE-ST) ), 
              IIF(TRY_CONVERT(DATE, :WS-DUMMY-DATE-END
              ) IS NULL OR (PATINDEX('%.%', :WS-DUMMY-DATE-END
              ) <> 0) OR (LEN(:WS-DUMMY-DATE-END
              ) <> 10), CIS.CHAR2DATE(:WS-DUMMY-DATE-END
              ), CONVERT(DATE, :WS-DUMMY-DATE-END) ) ))     
                                       ) / 12
            INTO
              :WS-RESULT-YEAR                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ050
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-RESULT-YEAR =  ( 12 *                                    
MFA-TR*                                 YEAR(DATE(:WS-DUMMY-DATE-ST)            
MFA-TR*                                 - DATE(:WS-DUMMY-DATE-END))             
MFA-TR*                                 + MONTH(DATE(:WS-DUMMY-DATE-ST)         
MFA-TR*                                 - DATE(:WS-DUMMY-DATE-END))             
MFA-TR*                                ) / 12                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7070'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_MODEL_SQL'          TO TABLE-1                  
              MOVE 'START DATE'             TO TABLE-ELEMENT-1          
              MOVE 'END DATE'               TO TABLE-ELEMENT-2          
              MOVE WS-DUMMY-DATE-ST         TO HOSTVAR-ELEMENT-1        
              MOVE WS-DUMMY-DATE-END        TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       7070-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7080-SELECT-CUST-STATS.                                        *        
      ******************************************************************        
       7080-SELECT-CUST-STATS.                                          
                                                                        
           EXEC SQL                                                     
               SELECT CE.DOB_VERIFIED_CD                                
                     ,CE.DATE_OF_BIRTH                                  
                 INTO :CE-DOB-VERIFIED-CD                               
                     ,:CE-DATE-OF-BIRTH :WS-NULL-IND-01                  
                 FROM CSS_CUST_STATS CE WITH(READUNCOMMITTED)                   
                WHERE CE.CUSTOMER_NO   = :CE-CUSTOMER-NO                
                  AND CE.CUSTOMER_TYPE = :CE-CUSTOMER-TYPE              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CE.DOB_VERIFIED_CD                                        
MFA-TR*              ,CE.DATE_OF_BIRTH                                          
MFA-TR*          INTO :CE-DOB-VERIFIED-CD                                       
MFA-TR*              ,:CE-DATE-OF-BIRTH:WS-NULL-IND-01                          
MFA-TR*          FROM CSS_CUST_STATS CE                                         
MFA-TR*         WHERE CE.CUSTOMER_NO   = :CE-CUSTOMER-NO                        
MFA-TR*           AND CE.CUSTOMER_TYPE = :CE-CUSTOMER-TYPE                      
MFA-TR*           WITH UR                                                       
MFA-TR*           QUERYNO 7080                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7080'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_CUST_STATS'         TO TABLE-1                  
              MOVE 'CUSTOMER_NO'            TO TABLE-ELEMENT-1          
              MOVE 'CUSTOMER_TYPE'          TO TABLE-ELEMENT-2          
              MOVE CE-CUSTOMER-NO           TO HOSTVAR-ELEMENT-1        
              MOVE CE-CUSTOMER-TYPE         TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       7080-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 7000-SET-TIMESTAMP                                             *        
      ******************************************************************        
       7000-SET-TIMESTAMP.                                              
      *                                                                         
           MOVE '7000' TO WS-ACTIVE-PARAGRAPH.                          
                                                                        
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-TIMESTAMP,
              :WS-CURRENT-DATE             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-TIMESTAMP      = CURRENT TIMESTAMP                
MFA-TR*          ,:WS-CURRENT-DATE           = CURRENT DATE                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO S-RETURN-CODE            
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE 'SET'                    TO ABEND-FUNCTION           
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 7260-SEL-ACCOUNT-DET.                                          *        
      ******************************************************************        
       7260-SEL-ACCOUNT-DET.                                            
      *                                                                         
           EXEC SQL                                                     
               SELECT REV_MTH_LST_NRML                                  
                     ,CUSTOMER_NO                                       
                 INTO :AT-REV-MTH-LST-NRML                              
                     ,:AT-CUSTOMER-NO                                   
                 FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT REV_MTH_LST_NRML                                          
MFA-TR*              ,CUSTOMER_NO                                               
MFA-TR*          INTO :AT-REV-MTH-LST-NRML                                      
MFA-TR*              ,:AT-CUSTOMER-NO                                           
MFA-TR*          FROM CSS_ACCOUNT                                               
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7260                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7260'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_ACCOUNT'           TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE AT-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       7260-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *                                                                *        
      * 7610-SEL-MKT-TIER.                                             *        
      ******************************************************************        
       7610-SEL-MKT-TIER.                                               
                                                                        
           EXEC SQL                                                     
               SELECT DD.EFF_START_DT                                   
                 INTO :DD-EFF-START-DT                                  
                 FROM CSS_ACCT_MKT_TIER DD WITH(READUNCOMMITTED)                
                WHERE DD.ACCOUNT_NO         = :DD-ACCOUNT-NO            
                  AND DD.TIER_CUST_STAT_CD  = :DD-TIER-CUST-STAT-CD     
                  AND DD.TIER_ACCT_TYPE_CD  = :DD-TIER-ACCT-TYPE-CD     
                  AND DD.MKT_TIER_RANKING   = :DD-MKT-TIER-RANKING      
                  AND DD.MKT_TIER_START_DT  = IIF(TRY_CONVERT(DATE, 
                                                  :DD-MKT-TIER-START-DT
              ) IS NULL OR (PATINDEX('%.%', :DD-MKT-TIER-START-DT
              ) <> 0) OR (LEN(:DD-MKT-TIER-START-DT
              ) <> 10), CIS.CHAR2DATE(:DD-MKT-TIER-START-DT
              ), CONVERT(DATE, :DD-MKT-TIER-START-DT) )     
                  AND DD.COMPANY_NO         = :DD-COMPANY-NO            
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DD.EFF_START_DT                                           
MFA-TR*          INTO :DD-EFF-START-DT                                          
MFA-TR*          FROM CSS_ACCT_MKT_TIER DD                                      
MFA-TR*         WHERE DD.ACCOUNT_NO         = :DD-ACCOUNT-NO                    
MFA-TR*           AND DD.TIER_CUST_STAT_CD  = :DD-TIER-CUST-STAT-CD             
MFA-TR*           AND DD.TIER_ACCT_TYPE_CD  = :DD-TIER-ACCT-TYPE-CD             
MFA-TR*           AND DD.MKT_TIER_RANKING   = :DD-MKT-TIER-RANKING              
MFA-TR*           AND DD.MKT_TIER_START_DT  = :DD-MKT-TIER-START-DT             
MFA-TR*           AND DD.COMPANY_NO         = :DD-COMPANY-NO                    
MFA-TR*           WITH UR                                                       
MFA-TR*           QUERYNO 7610                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7610'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_ACCT_MKT_TIER'     TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE 'TIER_CUST_STAT_CD'     TO TABLE-ELEMENT-2          
               MOVE 'TIER_ACCT_TYPE_CD'     TO TABLE-ELEMENT-3          
               MOVE 'MKT_TIER_RANKING'      TO TABLE-ELEMENT-4          
               MOVE DD-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               MOVE DD-TIER-CUST-STAT-CD    TO HOSTVAR-ELEMENT-2        
               MOVE DD-TIER-ACCT-TYPE-CD    TO HOSTVAR-ELEMENT-3        
               MOVE DD-MKT-TIER-RANKING     TO HOSTVAR-ELEMENT-4        
               PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       7610-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7620-SEL-MKT-EFF-DT.                                           *        
      ******************************************************************        
       7620-SEL-MKT-EFF-DT.                                             
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) IG.MKT_TIER_START_DT,
              IG.MKT_TIER_DESC,
              IG.CUST_ACCT_DEFLT_FL                             
                 INTO :IG-MKT-TIER-START-DT :WS-NULL-IND-01              
                     ,:IG-MKT-TIER-DESC                                 
                     ,:IG-CUST-ACCT-DEFLT-FL                            
                 FROM CRM_MKT_TIER IG WITH(READUNCOMMITTED)                     
                WHERE IG.TIER_CUST_STAT_CD  = :IG-TIER-CUST-STAT-CD     
                  AND IG.TIER_ACCT_TYPE_CD  = :IG-TIER-ACCT-TYPE-CD     
                  AND IG.MKT_TIER_RANKING   = :IG-MKT-TIER-RANKING      
                  AND IG.COMPANY_NO         = :IG-COMPANY-NO            
                ORDER BY IG.MKT_TIER_START_DT DESC                      
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT IG.MKT_TIER_START_DT                                      
MFA-TR*              ,IG.MKT_TIER_DESC                                          
MFA-TR*              ,IG.CUST_ACCT_DEFLT_FL                                     
MFA-TR*          INTO :IG-MKT-TIER-START-DT:WS-NULL-IND-01                      
MFA-TR*              ,:IG-MKT-TIER-DESC                                         
MFA-TR*              ,:IG-CUST-ACCT-DEFLT-FL                                    
MFA-TR*          FROM CRM_MKT_TIER IG                                           
MFA-TR*         WHERE IG.TIER_CUST_STAT_CD  = :IG-TIER-CUST-STAT-CD             
MFA-TR*           AND IG.TIER_ACCT_TYPE_CD  = :IG-TIER-ACCT-TYPE-CD             
MFA-TR*           AND IG.MKT_TIER_RANKING   = :IG-MKT-TIER-RANKING              
MFA-TR*           AND IG.COMPANY_NO         = :IG-COMPANY-NO                    
MFA-TR*         ORDER BY IG.MKT_TIER_START_DT DESC                              
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*         QUERYNO 7620                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7620'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CRM_MKT_TIER'          TO TABLE-1                  
               MOVE 'TIER_CUST_STAT_CD'     TO TABLE-ELEMENT-1          
               MOVE 'TIER_ACCT_TYPE_CD'     TO TABLE-ELEMENT-2          
               MOVE 'MKT_TIER_RANKING'      TO TABLE-ELEMENT-3          
               MOVE IG-TIER-CUST-STAT-CD    TO HOSTVAR-ELEMENT-1        
               MOVE IG-TIER-ACCT-TYPE-CD    TO HOSTVAR-ELEMENT-2        
               MOVE IG-MKT-TIER-RANKING     TO HOSTVAR-ELEMENT-3        
               PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       7620-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7630-SEL-MKT-TIER-DET.                                         *        
      ******************************************************************        
       7630-SEL-MKT-TIER-DET.                                           
                                                                        
           EXEC SQL                                                     
               SELECT DD.TIER_CUST_STAT_CD                              
                     ,DD.TIER_ACCT_TYPE_CD                              
                     ,DD.MKT_TIER_RANKING                               
                     ,DD.MKT_TIER_START_DT                              
                     ,DD.COMPANY_NO                                     
                     ,DD.TIER_SOURCE_CD                                 
                     ,DD.ADJ_TIER_SEQ_NO                                
                     ,DD.EFF_START_DT                                   
                 INTO :DD-TIER-CUST-STAT-CD                             
                     ,:DD-TIER-ACCT-TYPE-CD                             
                     ,:DD-MKT-TIER-RANKING                              
                     ,:DD-MKT-TIER-START-DT                             
                     ,:DD-COMPANY-NO                                    
                     ,:DD-TIER-SOURCE-CD                                
                     ,:DD-ADJ-TIER-SEQ-NO                               
                     ,:DD-EFF-START-DT                                  
                 FROM CSS_ACCT_MKT_TIER DD WITH(READUNCOMMITTED)                
                WHERE DD.ACCOUNT_NO   = :DD-ACCOUNT-NO                  
                  AND DD.EFF_START_DT =                                 
                          ( SELECT MAX(DD1.EFF_START_DT)                
                              FROM CSS_ACCT_MKT_TIER DD1
                           WITH(READUNCOMMITTED)                
                             WHERE DD1.ACCOUNT_NO = :DD-ACCOUNT-NO )    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DD.TIER_CUST_STAT_CD                                      
MFA-TR*              ,DD.TIER_ACCT_TYPE_CD                                      
MFA-TR*              ,DD.MKT_TIER_RANKING                                       
MFA-TR*              ,DD.MKT_TIER_START_DT                                      
MFA-TR*              ,DD.COMPANY_NO                                             
MFA-TR*              ,DD.TIER_SOURCE_CD                                         
MFA-TR*              ,DD.ADJ_TIER_SEQ_NO                                        
MFA-TR*              ,DD.EFF_START_DT                                           
MFA-TR*          INTO :DD-TIER-CUST-STAT-CD                                     
MFA-TR*              ,:DD-TIER-ACCT-TYPE-CD                                     
MFA-TR*              ,:DD-MKT-TIER-RANKING                                      
MFA-TR*              ,:DD-MKT-TIER-START-DT                                     
MFA-TR*              ,:DD-COMPANY-NO                                            
MFA-TR*              ,:DD-TIER-SOURCE-CD                                        
MFA-TR*              ,:DD-ADJ-TIER-SEQ-NO                                       
MFA-TR*              ,:DD-EFF-START-DT                                          
MFA-TR*          FROM CSS_ACCT_MKT_TIER DD                                      
MFA-TR*         WHERE DD.ACCOUNT_NO   = :DD-ACCOUNT-NO                          
MFA-TR*           AND DD.EFF_START_DT =                                         
MFA-TR*                   ( SELECT MAX(DD1.EFF_START_DT)                        
MFA-TR*                       FROM CSS_ACCT_MKT_TIER DD1                        
MFA-TR*                      WHERE DD1.ACCOUNT_NO = :DD-ACCOUNT-NO )            
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7630                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE 'Y'                   TO WS-MKT-TIER-FOUND        
              END-IF                                                    
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7630'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_ACCT_MKT_TIER'     TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE 'EFF_START_DT'          TO TABLE-ELEMENT-2          
               MOVE DD-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               MOVE DD-EFF-START-DT         TO HOSTVAR-ELEMENT-2        
               PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       7630-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7700-SEL-CODE-VALUE-DESC                                       *        
      ******************************************************************        
       7700-SEL-CODE-VALUE-DESC.                                        
                                                                        
           EXEC SQL                                                     
              SELECT CODE_SHORT_DESC                                    
               INTO :UV-CODE-SHORT-DESC                                 
               FROM CSS_CODE_VALUE WITH(READUNCOMMITTED)                        
              WHERE CODE_VALUE     = :UV-CODE-VALUE                     
                AND COLUMN_NA      = :UV-COLUMN-NA                      
                AND COMPANY_NO     = :UV-COMPANY-NO                     
                AND PROGRAM_ID     = :UV-PROGRAM-ID                     
                AND TABLE_NA       = :UV-TABLE-NA                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CODE_SHORT_DESC                                            
MFA-TR*        INTO :UV-CODE-SHORT-DESC                                         
MFA-TR*        FROM CSS_CODE_VALUE                                              
MFA-TR*       WHERE CODE_VALUE     = :UV-CODE-VALUE                             
MFA-TR*         AND COLUMN_NA      = :UV-COLUMN-NA                              
MFA-TR*         AND COMPANY_NO     = :UV-COMPANY-NO                             
MFA-TR*         AND PROGRAM_ID     = :UV-PROGRAM-ID                             
MFA-TR*         AND TABLE_NA       = :UV-TABLE-NA                               
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7700                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7700'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_CODE_VALUE'         TO TABLE-1                  
              MOVE 'CODE_VALUE'             TO TABLE-ELEMENT-1          
              MOVE WS-CODE-VALUE            TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7800-SELECT-RESP-AREA                                         *         
      *     SELECTS CSS_USER_PROFILE                                  *         
      *****************************************************************         
       7800-SELECT-RESP-AREA.                                           
                                                                        
           EXEC SQL                                                     
              SELECT RESP_AREA_ID                                       
                INTO :PF-RESP-AREA-ID                                   
                FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                     
               WHERE USER_ID  = :WS-USER-ID                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RESP_AREA_ID                                               
MFA-TR*         INTO :PF-RESP-AREA-ID                                           
MFA-TR*         FROM CSS_USER_PROFILE                                           
MFA-TR*        WHERE USER_ID  = :WS-USER-ID                                     
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7800                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE '7800'                   TO ACTIVE-PARAGRAPH         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_USER_PROFILE'       TO TABLE-1                  
              MOVE 'USER_ID'                TO TABLE-ELEMENT-1          
              MOVE WS-USER-ID               TO HOSTVAR-ELEMENT-1        
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-2          
              MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       7800-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7810-SEL-TIER-ADJ-SEQ-NO.                                      *        
      ******************************************************************        
       7810-SEL-TIER-ADJ-SEQ-NO.                                        
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) [1B].ADJ_TIER_SEQ_NO,
              [1B].TIER_ADJ_DESC                                  
                 INTO :1B-ADJ-TIER-SEQ-NO                               
                     ,:1B-TIER-ADJ-DESC                                 
                 FROM CSS_ACCT_MKT_TIER DD WITH(READUNCOMMITTED)                
                     ,CRM_MKT_TIER_ADJ [1B] WITH(READUNCOMMITTED)               
                WHERE DD.ACCOUNT_NO        = :DD-ACCOUNT-NO             
                  AND [1B].ADJ_TIER_RANKING  = :1B-ADJ-TIER-RANKING       
                  AND [1B].DHR_QUALIFIED_FL  = :1B-DHR-QUALIFIED-FL       
                  AND DD.TIER_CUST_STAT_CD = [1B].TIER_CUST_STAT_CD       
                  AND DD.TIER_ACCT_TYPE_CD = [1B].TIER_ACCT_TYPE_CD       
                  AND DD.MKT_TIER_RANKING  = [1B].MKT_TIER_RANKING        
                  AND DD.MKT_TIER_START_DT = [1B].MKT_TIER_START_DT       
                  AND DD.COMPANY_NO        = [1B].COMPANY_NO              
                  AND [1B].DHR_QUALIFIED_FL  = :1B-DHR-QUALIFIED-FL       
                  AND [1B].APPLICATION_CD    <> 'RT'                      
                  AND [1B].ADJ_START_DT      <= IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )          
                  AND [1B].ADJ_END_DT        >= IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )          
                  AND DD.EFF_START_DT =                                 
                          ( SELECT MAX(DD1.EFF_START_DT)                
                              FROM CSS_ACCT_MKT_TIER DD1
                           WITH(READUNCOMMITTED)                
                             WHERE DD1.ACCOUNT_NO = :DD-ACCOUNT-NO )    
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 1B.ADJ_TIER_SEQ_NO                                        
MFA-TR*              ,1B.TIER_ADJ_DESC                                          
MFA-TR*          INTO :1B-ADJ-TIER-SEQ-NO                                       
MFA-TR*              ,:1B-TIER-ADJ-DESC                                         
MFA-TR*          FROM CSS_ACCT_MKT_TIER DD                                      
MFA-TR*              ,CRM_MKT_TIER_ADJ 1B                                       
MFA-TR*         WHERE DD.ACCOUNT_NO        = :DD-ACCOUNT-NO                     
MFA-TR*           AND 1B.ADJ_TIER_RANKING  = :1B-ADJ-TIER-RANKING               
MFA-TR*           AND 1B.DHR_QUALIFIED_FL  = :1B-DHR-QUALIFIED-FL               
MFA-TR*           AND DD.TIER_CUST_STAT_CD = 1B.TIER_CUST_STAT_CD               
MFA-TR*           AND DD.TIER_ACCT_TYPE_CD = 1B.TIER_ACCT_TYPE_CD               
MFA-TR*           AND DD.MKT_TIER_RANKING  = 1B.MKT_TIER_RANKING                
MFA-TR*           AND DD.MKT_TIER_START_DT = 1B.MKT_TIER_START_DT               
MFA-TR*           AND DD.COMPANY_NO        = 1B.COMPANY_NO                      
MFA-TR*           AND 1B.DHR_QUALIFIED_FL  = :1B-DHR-QUALIFIED-FL               
MFA-TR*           AND 1B.APPLICATION_CD    <> 'RT'                              
MFA-TR*           AND 1B.ADJ_START_DT      <= :WS-CURRENT-DATE                  
MFA-TR*           AND 1B.ADJ_END_DT        >= :WS-CURRENT-DATE                  
MFA-TR*           AND DD.EFF_START_DT =                                         
MFA-TR*                   ( SELECT MAX(DD1.EFF_START_DT)                        
MFA-TR*                       FROM CSS_ACCT_MKT_TIER DD1                        
MFA-TR*                      WHERE DD1.ACCOUNT_NO = :DD-ACCOUNT-NO )            
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*         QUERYNO 7810                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7810'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_ACCT_MKT_TIER'     TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE 'TIER_RANKING'          TO TABLE-ELEMENT-2          
               MOVE DD-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               MOVE 1B-ADJ-TIER-RANKING     TO HOSTVAR-ELEMENT-2        
               PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       7810-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7820-SEL-MKT-TIER-DESC.                                        *        
      ******************************************************************        
       7820-SEL-MKT-TIER-DESC.                                          
                                                                        
           EXEC SQL                                                     
               SELECT IG.MKT_TIER_DESC                                  
                 INTO :IG-MKT-TIER-DESC                                 
                 FROM CRM_MKT_TIER IG WITH(READUNCOMMITTED)                     
                WHERE IG.TIER_CUST_STAT_CD  = :IG-TIER-CUST-STAT-CD     
                  AND IG.TIER_ACCT_TYPE_CD  = :IG-TIER-ACCT-TYPE-CD     
                  AND IG.MKT_TIER_RANKING   = :IG-MKT-TIER-RANKING      
                  AND IG.MKT_TIER_START_DT  = IIF(TRY_CONVERT(DATE, 
                                                  :IG-MKT-TIER-START-DT
              ) IS NULL OR (PATINDEX('%.%', :IG-MKT-TIER-START-DT
              ) <> 0) OR (LEN(:IG-MKT-TIER-START-DT
              ) <> 10), CIS.CHAR2DATE(:IG-MKT-TIER-START-DT
              ), CONVERT(DATE, :IG-MKT-TIER-START-DT) )     
                  AND IG.COMPANY_NO         = :IG-COMPANY-NO            
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT IG.MKT_TIER_DESC                                          
MFA-TR*          INTO :IG-MKT-TIER-DESC                                         
MFA-TR*          FROM CRM_MKT_TIER IG                                           
MFA-TR*         WHERE IG.TIER_CUST_STAT_CD  = :IG-TIER-CUST-STAT-CD             
MFA-TR*           AND IG.TIER_ACCT_TYPE_CD  = :IG-TIER-ACCT-TYPE-CD             
MFA-TR*           AND IG.MKT_TIER_RANKING   = :IG-MKT-TIER-RANKING              
MFA-TR*           AND IG.MKT_TIER_START_DT  = :IG-MKT-TIER-START-DT             
MFA-TR*           AND IG.COMPANY_NO         = :IG-COMPANY-NO                    
MFA-TR*           WITH UR                                                       
MFA-TR*           QUERYNO 7820                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7820'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CRM_MKT_TIER'          TO TABLE-1                  
               MOVE 'TIER_CUST_STAT_CD'     TO TABLE-ELEMENT-1          
               MOVE 'TIER_ACCT_TYPE_CD'     TO TABLE-ELEMENT-2          
               MOVE 'MKT_TIER_RANKING'      TO TABLE-ELEMENT-3          
               MOVE 'MKT_TIER_START_DT'     TO TABLE-ELEMENT-4          
               MOVE IG-TIER-CUST-STAT-CD    TO HOSTVAR-ELEMENT-1        
               MOVE IG-TIER-ACCT-TYPE-CD    TO HOSTVAR-ELEMENT-2        
               MOVE IG-MKT-TIER-RANKING     TO HOSTVAR-ELEMENT-3        
               MOVE IG-MKT-TIER-START-DT    TO HOSTVAR-ELEMENT-4        
               PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       7820-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7830-SEL-TIER-ADJ-DESC.                                        *        
      ******************************************************************        
       7830-SEL-TIER-ADJ-DESC.                                          
                                                                        
           EXEC SQL                                                     
               SELECT [1B].TIER_ADJ_DESC                                  
                 INTO :1B-TIER-ADJ-DESC                                 
                 FROM CRM_MKT_TIER_ADJ [1B] WITH(READUNCOMMITTED)               
                WHERE [1B].ADJ_TIER_SEQ_NO = :1B-ADJ-TIER-SEQ-NO          
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 1B.TIER_ADJ_DESC                                          
MFA-TR*          INTO :1B-TIER-ADJ-DESC                                         
MFA-TR*          FROM CRM_MKT_TIER_ADJ 1B                                       
MFA-TR*         WHERE 1B.ADJ_TIER_SEQ_NO = :1B-ADJ-TIER-SEQ-NO                  
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7830                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7830'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CRM_MKT_TIER_ADJ'      TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE 'ADJ_TIER_SEQ_NO'       TO TABLE-ELEMENT-2          
               MOVE AT-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               MOVE 1B-ADJ-TIER-SEQ-NO      TO HOSTVAR-ELEMENT-2        
               PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       7830-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7840-SEL-DHR-HIST.                                             *        
      ******************************************************************        
       7840-SEL-DHR-HIST.                                               
                                                                        
           EXEC SQL                                                     
                SELECT CU.DHR_FL                                        
                  INTO :WS-DHR-CUSTOMER                                 
                  FROM CSS_CUSTOMER CU WITH(READUNCOMMITTED)                    
                 WHERE CU.CUSTOMER_NO  = :CU-CUSTOMER-NO                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT CU.DHR_FL                                                
MFA-TR*           INTO :WS-DHR-CUSTOMER                                         
MFA-TR*           FROM CSS_CUSTOMER CU                                          
MFA-TR*          WHERE CU.CUSTOMER_NO  = :CU-CUSTOMER-NO                        
MFA-TR*           WITH UR                                                       
MFA-TR*           QUERYNO 7840                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7840'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_CUSTOMER'          TO TABLE-1                  
               MOVE 'CUSTOMER_NO'           TO TABLE-ELEMENT-1          
               MOVE CU-CUSTOMER-NO          TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       7840-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7860-SEL-TIER-ADJ-SEQ-NO-SR.                                   *        
      ******************************************************************        
       7860-SEL-TIER-ADJ-SEQ-NO-SR.                                     
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) [1B].ADJ_TIER_SEQ_NO,
              [1B].TIER_ADJ_DESC                                  
                 INTO :1B-ADJ-TIER-SEQ-NO                               
                     ,:1B-TIER-ADJ-DESC                                 
                 FROM CSS_ACCT_MKT_TIER DD WITH(READUNCOMMITTED)                
                     ,CRM_MKT_TIER_ADJ [1B] WITH(READUNCOMMITTED)               
                WHERE DD.ACCOUNT_NO         = :DD-ACCOUNT-NO            
                  AND [1B].ADJ_TIER_RANKING   = :1B-ADJ-TIER-RANKING      
                  AND [1B].DHR_QUALIFIED_FL   = :1B-DHR-QUALIFIED-FL      
                  AND DD.TIER_CUST_STAT_CD  = [1B].TIER_CUST_STAT_CD      
                  AND DD.TIER_ACCT_TYPE_CD  = [1B].TIER_ACCT_TYPE_CD      
                  AND DD.MKT_TIER_RANKING   = [1B].MKT_TIER_RANKING       
                  AND DD.MKT_TIER_START_DT  = [1B].MKT_TIER_START_DT      
                  AND DD.COMPANY_NO         = [1B].COMPANY_NO             
                  AND [1B].DHR_QUALIFIED_FL   = :1B-DHR-QUALIFIED-FL      
                  AND [1B].AGL_LOW_INCM_SR_FL = :1B-AGL-LOW-INCM-SR-FL    
                  AND [1B].ADJ_START_DT      <= IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )          
                  AND [1B].ADJ_END_DT        >= IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )          
                  AND DD.EFF_START_DT =                                 
                          ( SELECT MAX(DD1.EFF_START_DT)                
                              FROM CSS_ACCT_MKT_TIER DD1
                           WITH(READUNCOMMITTED)                
                             WHERE DD1.ACCOUNT_NO = :DD-ACCOUNT-NO )    
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 1B.ADJ_TIER_SEQ_NO                                        
MFA-TR*              ,1B.TIER_ADJ_DESC                                          
MFA-TR*          INTO :1B-ADJ-TIER-SEQ-NO                                       
MFA-TR*              ,:1B-TIER-ADJ-DESC                                         
MFA-TR*          FROM CSS_ACCT_MKT_TIER DD                                      
MFA-TR*              ,CRM_MKT_TIER_ADJ 1B                                       
MFA-TR*         WHERE DD.ACCOUNT_NO         = :DD-ACCOUNT-NO                    
MFA-TR*           AND 1B.ADJ_TIER_RANKING   = :1B-ADJ-TIER-RANKING              
MFA-TR*           AND 1B.DHR_QUALIFIED_FL   = :1B-DHR-QUALIFIED-FL              
MFA-TR*           AND DD.TIER_CUST_STAT_CD  = 1B.TIER_CUST_STAT_CD              
MFA-TR*           AND DD.TIER_ACCT_TYPE_CD  = 1B.TIER_ACCT_TYPE_CD              
MFA-TR*           AND DD.MKT_TIER_RANKING   = 1B.MKT_TIER_RANKING               
MFA-TR*           AND DD.MKT_TIER_START_DT  = 1B.MKT_TIER_START_DT              
MFA-TR*           AND DD.COMPANY_NO         = 1B.COMPANY_NO                     
MFA-TR*           AND 1B.DHR_QUALIFIED_FL   = :1B-DHR-QUALIFIED-FL              
MFA-TR*           AND 1B.AGL_LOW_INCM_SR_FL = :1B-AGL-LOW-INCM-SR-FL            
MFA-TR*           AND 1B.ADJ_START_DT      <= :WS-CURRENT-DATE                  
MFA-TR*           AND 1B.ADJ_END_DT        >= :WS-CURRENT-DATE                  
MFA-TR*           AND DD.EFF_START_DT =                                         
MFA-TR*                   ( SELECT MAX(DD1.EFF_START_DT)                        
MFA-TR*                       FROM CSS_ACCT_MKT_TIER DD1                        
MFA-TR*                      WHERE DD1.ACCOUNT_NO = :DD-ACCOUNT-NO )            
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*         QUERYNO 7860                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7860'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_ACCT_MKT_TIER'     TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE 'TIER_RANKING'          TO TABLE-ELEMENT-2          
               MOVE 'AGL_LOW_INCM_SR_FL'    TO TABLE-ELEMENT-3          
               MOVE DD-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               MOVE 1B-ADJ-TIER-RANKING     TO HOSTVAR-ELEMENT-2        
               MOVE 1B-AGL-LOW-INCM-SR-FL   TO HOSTVAR-ELEMENT-3        
               PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       7860-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8000-INSERT-MKT-TIER                                           *        
      *       THIS MODULE INSERTS A NEW ROW  INTO THE TABLE            *        
      *       CSS_ACCT_MKT_TIER                                        *        
      ******************************************************************        
       8000-INSERT-MKT-TIER.                                            
      *                                                                         
           EXEC SQL                                                     
               INSERT INTO CSS_ACCT_MKT_TIER                            
                    ( ACCOUNT_NO                                        
                     ,TIER_CUST_STAT_CD                                 
                     ,TIER_ACCT_TYPE_CD                                 
                     ,MKT_TIER_RANKING                                  
                     ,MKT_TIER_START_DT                                 
                     ,COMPANY_NO                                        
                     ,CREATED_TS                                        
                     ,LAST_UPDATE_USERID                                
                     ,EFF_START_DT                                      
                     ,LAST_UPDATE_TS                                    
                     ,LAST_EVALUATED_DT                                 
                     ,TIER_SOURCE_CD                                    
                     ,ADJ_TIER_SEQ_NO)                                  
               VALUES                                                   
                    (:DD-ACCOUNT-NO                                     
                    ,:DD-TIER-CUST-STAT-CD                              
                    ,:DD-TIER-ACCT-TYPE-CD                              
                    ,:DD-MKT-TIER-RANKING                               
                    ,IIF(TRY_CONVERT(DATE, :DD-MKT-TIER-START-DT
              ) IS NULL OR (PATINDEX('%.%', :DD-MKT-TIER-START-DT
              ) <> 0) OR (LEN(:DD-MKT-TIER-START-DT
              ) <> 10), CIS.CHAR2DATE(:DD-MKT-TIER-START-DT
              ), CONVERT(DATE, :DD-MKT-TIER-START-DT) )                        
                    ,:DD-COMPANY-NO                                     
                    ,CIS.CHAR2TIMESTAMP(:DD-CREATED-TS)                         
                    ,:DD-LAST-UPDATE-USERID                             
                    ,IIF(TRY_CONVERT(DATE, :DD-EFF-START-DT
              ) IS NULL OR (PATINDEX('%.%', :DD-EFF-START-DT
              ) <> 0) OR (LEN(:DD-EFF-START-DT) <> 10), CIS.CHAR2DATE(
                                                       :DD-EFF-START-DT
              ), CONVERT(DATE, :DD-EFF-START-DT) )                             
                    ,CIS.CHAR2TIMESTAMP(:DD-LAST-UPDATE-TS)                     
                    ,IIF(TRY_CONVERT(DATE, :DD-LAST-EVALUATED-DT
              ) IS NULL OR (PATINDEX('%.%', :DD-LAST-EVALUATED-DT
              ) <> 0) OR (LEN(:DD-LAST-EVALUATED-DT
              ) <> 10), CIS.CHAR2DATE(:DD-LAST-EVALUATED-DT
              ), CONVERT(DATE, :DD-LAST-EVALUATED-DT) )                        
                    ,:DD-TIER-SOURCE-CD                                 
                    ,:DD-ADJ-TIER-SEQ-NO)                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_ACCT_MKT_TIER                                    
MFA-TR*             ( ACCOUNT_NO                                                
MFA-TR*              ,TIER_CUST_STAT_CD                                         
MFA-TR*              ,TIER_ACCT_TYPE_CD                                         
MFA-TR*              ,MKT_TIER_RANKING                                          
MFA-TR*              ,MKT_TIER_START_DT                                         
MFA-TR*              ,COMPANY_NO                                                
MFA-TR*              ,CREATED_TS                                                
MFA-TR*              ,LAST_UPDATE_USERID                                        
MFA-TR*              ,EFF_START_DT                                              
MFA-TR*              ,LAST_UPDATE_TS                                            
MFA-TR*              ,LAST_EVALUATED_DT                                         
MFA-TR*              ,TIER_SOURCE_CD                                            
MFA-TR*              ,ADJ_TIER_SEQ_NO)                                          
MFA-TR*        VALUES                                                           
MFA-TR*             (:DD-ACCOUNT-NO                                             
MFA-TR*             ,:DD-TIER-CUST-STAT-CD                                      
MFA-TR*             ,:DD-TIER-ACCT-TYPE-CD                                      
MFA-TR*             ,:DD-MKT-TIER-RANKING                                       
MFA-TR*             ,:DD-MKT-TIER-START-DT                                      
MFA-TR*             ,:DD-COMPANY-NO                                             
MFA-TR*             ,:DD-CREATED-TS                                             
MFA-TR*             ,:DD-LAST-UPDATE-USERID                                     
MFA-TR*             ,:DD-EFF-START-DT                                           
MFA-TR*             ,:DD-LAST-UPDATE-TS                                         
MFA-TR*             ,:DD-LAST-EVALUATED-DT                                      
MFA-TR*             ,:DD-TIER-SOURCE-CD                                         
MFA-TR*             ,:DD-ADJ-TIER-SEQ-NO)                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               MOVE WS-ACTIVE-RETURN-CODE   TO S-RETURN-CODE            
                                               S-APPL-RETURN-CODE       
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE WS-ACTIVE-RETURN-CODE   TO S-RETURN-CODE            
               MOVE '8000'                  TO ACTIVE-PARAGRAPH         
               MOVE 'INSERT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_ACCT_MKT_TIER'     TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE 'TIER_CUST_STAT_CD'     TO TABLE-ELEMENT-2          
               MOVE 'TIER_ACCT_TYPE_CD'     TO TABLE-ELEMENT-3          
               MOVE 'MKT_TIER_RANKING'      TO TABLE-ELEMENT-4          
               MOVE DD-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               MOVE DD-TIER-CUST-STAT-CD    TO HOSTVAR-ELEMENT-2        
               MOVE DD-TIER-ACCT-TYPE-CD    TO HOSTVAR-ELEMENT-3        
               MOVE DD-MKT-TIER-RANKING     TO HOSTVAR-ELEMENT-4        
               PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8410-DEL-MKT-TIER.                                             *        
      ******************************************************************        
       8410-DEL-MKT-TIER.                                               
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_ACCT_MKT_TIER                            
                WHERE ACCOUNT_NO         = :DD-ACCOUNT-NO               
                  AND TIER_CUST_STAT_CD  = :DD-TIER-CUST-STAT-CD        
                  AND TIER_ACCT_TYPE_CD  = :DD-TIER-ACCT-TYPE-CD        
                  AND MKT_TIER_RANKING   = :DD-MKT-TIER-RANKING         
                  AND EFF_START_DT       = IIF(TRY_CONVERT(DATE, 
                                                       :DD-EFF-START-DT
              ) IS NULL OR (PATINDEX('%.%', :DD-EFF-START-DT
              ) <> 0) OR (LEN(:DD-EFF-START-DT) <> 10), CIS.CHAR2DATE(
                                                       :DD-EFF-START-DT
              ), CONVERT(DATE, :DD-EFF-START-DT) )             
                  AND COMPANY_NO         = :DD-COMPANY-NO               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM CSS_ACCT_MKT_TIER                                    
MFA-TR*         WHERE ACCOUNT_NO         = :DD-ACCOUNT-NO                       
MFA-TR*           AND TIER_CUST_STAT_CD  = :DD-TIER-CUST-STAT-CD                
MFA-TR*           AND TIER_ACCT_TYPE_CD  = :DD-TIER-ACCT-TYPE-CD                
MFA-TR*           AND MKT_TIER_RANKING   = :DD-MKT-TIER-RANKING                 
MFA-TR*           AND EFF_START_DT       = :DD-EFF-START-DT                     
MFA-TR*           AND COMPANY_NO         = :DD-COMPANY-NO                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '8410'                  TO ACTIVE-PARAGRAPH         
               MOVE 'DELETE'                TO ABEND-FUNCTION           
               MOVE 'CSS_ACCT_MKT_TIER'     TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE 'TIER_CUST_STAT_CD'     TO TABLE-ELEMENT-2          
               MOVE 'TIER_ACCT_TYPE_CD'     TO TABLE-ELEMENT-3          
               MOVE 'MKT_TIER_RANKING'      TO TABLE-ELEMENT-4          
               MOVE DD-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               MOVE DD-TIER-CUST-STAT-CD    TO HOSTVAR-ELEMENT-2        
               MOVE DD-TIER-ACCT-TYPE-CD    TO HOSTVAR-ELEMENT-3        
               MOVE DD-MKT-TIER-RANKING     TO HOSTVAR-ELEMENT-4        
               PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       8410-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8000A-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000A-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04666_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04666_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE.           
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
      *                                                                         
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
      *                                                                         
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE            
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000A'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04666_R1'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT         
           END-EVALUATE.                                                
                                                                        
       8000A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8010-INSERT-GTT-R1.                                            *        
      ******************************************************************        
       8010-INSERT-GTT-R1.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04666_R1                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,BUS_RULE_ID                                          
                  ,BUS_RULE_RESULT_CD                                   
                  ,BUS_RULE_XREF_ID                                     
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE                                       
                  ,:S-APPL-RETURN-CODE                                  
                  ,:S-RS1-BUS-RULE-ID                                   
                  ,:S-RS1-BUS-RULE-RESULT-CD                            
                  ,:S-RS1-BUS-RULE-XREF-ID                              
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04666_R1                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,BUS_RULE_ID                                                  
MFA-TR*           ,BUS_RULE_RESULT_CD                                           
MFA-TR*           ,BUS_RULE_XREF_ID                                             
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE                                               
MFA-TR*           ,:S-APPL-RETURN-CODE                                          
MFA-TR*           ,:S-RS1-BUS-RULE-ID                                           
MFA-TR*           ,:S-RS1-BUS-RULE-RESULT-CD                                    
MFA-TR*           ,:S-RS1-BUS-RULE-XREF-ID                                      
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO  ABEND-PROGRAM           
              MOVE '8010'                   TO  ACTIVE-PARAGRAPH        
              MOVE SQLCODE                  TO  ABEND-SQLCODE           
              MOVE 'INSERT'                 TO  ABEND-FUNCTION          
              MOVE SPACES                   TO  ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSR04666_R1'            TO  TABLE-1                 
              MOVE SPACES                   TO  TABLE-ELEMENT-1         
              MOVE SPACES                   TO  HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
        8010-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ************************************************************              
      *                                                                         
      * 8900-SEND-DONE.                                                         
      ************************************************************              
       8900-SEND-DONE.                                                  
                                                                        
           MOVE PROGRAM-NAME                TO ABEND-PROGRAM            
           MOVE '8900'                      TO ACTIVE-PARAGRAPH         
           MOVE 'OPEN'                      TO ABEND-FUNCTION           
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE 'CSR04666_R1'            TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      *                                                                         
      * 9000-SEND-ERROR-RESULT                                                  
      ************************************************************              
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE       TO ABEND-SQLCODE            
                                               S-RETURN-CODE            
                                                                        
           MOVE ZERO                        TO S-APPL-RETURN-CODE       
                                                                        
                                                                        
           MOVE SQLERRMC                    TO ABEND-SQLERRMC.          
                                                                        
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'               TO ABEND-FUNCTION           
           END-IF.                                                      
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1          THRU 0100A-EXIT.       
                                                                        
           PERFORM 8010-INSERT-GTT-R1            THRU 8010-EXIT.        
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      * 9700-ABEND-PROCESSING.                                                  
      ************************************************************              
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT        THRU 9000-EXIT.        
           PERFORM 9900-SQL-ERROR-ROUTINE        THRU 9900-EXIT.        
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * TRANS HIST COPYBOOK.                                           *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
HPCCDM*    EJECT                                                                
      ************************************************************              
      * 9999-END-PROGRAM.                                                       
      ************************************************************              
                                                                        
       9999-END-PROGRAM.                                                
                                                                        
            PERFORM 8900-SEND-DONE               THRU 8900-EXIT         
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
