       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       CSR04665.                                      
COB303 DATE-WRITTEN.     NOV 20,2013.                                   
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE:  CSR04665              --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--                                                            --         
      *--  CSR04665 :                                                --         
      *--                                                            --         
      *--  #  RETRIEVES VALUES FROM THE TABLE CSS_ACCT_MKT_TIER      --         
      *--     THIS PROGRAM IS CLONED FROM CSR04097                   --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *--  PARAMETERS                                                --         
      *--                                                            --         
      *--      IN                                                    --         
      *--         ACCOUNT_NO                                         --         
      *--                                                            --         
      *--      OUT                                                   --         
      *--         NONE                                               --         
      *--                                                            --         
      *--      INOUT                                                 --         
      *--         NONE                                               --         
      *--                                                            --         
      *--  CSR04665_R1 - ACCOUNT MARKET TIER                         --         
      *--                                                            --         
      *--            RETURN_CODE          INTEGER                    --         
      *--           ,APPL_RETURN_CODE     INTEGER                    --         
      *--           ,TIER_CUST_STAT_CD    CHAR(01)                   --         
      *--           ,TIER_ACCT_TYPE_CD    CHAR(01)                   --         
      *--           ,MKT_TIER_RANKING     SMALLINT                   --         
      *--           ,MKT_TIER_DESC        CHAR(50)                   --         
      *--           ,MKT_TIER_START_DT    CHAR(10)                   --         
      *--           ,COMPANY_NO           CHAR(02)                   --         
      *--           ,CREATED_TS           CHAR(26)                   --         
      *--           ,LAST_UPDATE_USERID   CHAR(07)                   --         
      *--           ,EFF_START_DT         CHAR(10)                   --         
      *--           ,LAST_UPDATE_TS       CHAR(26)                   --         
      *--           ,LAST_EVALUATED_DT    CHAR(10)                   --         
      *--           ,TIER_SOURCE_CD       CHAR(02)                   --         
      *--           ,ADJ_TIER_SEQ_DESC    CHAR(80)                   --         
      *--           ,PRP_TIER_RANK        SMALLINT                   --         
      *--                                                            --         
      *--  CSR04665_R2 - BUS RULE DETAILS                            --         
      *--                                                            --         
      *--           RETURN_CODE             INTEGER                  --         
      *--          ,APPL_RETURN_CODE        INTEGER                  --         
      *--          ,BUS_RULE_ID             CHAR(10)                 --         
      *--          ,BUS_RULE_RESULT_CD      CHAR(10)                 --         
      *--          ,BUS_RULE_XREF_ID        CHAR(26)                 --         
      *--                                                            --         
      *--                                                            --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                        MODIFICATION LOG                    --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
      *--  11/20/2013    AD75921     INTIAL VERSION                  --         
      *--                                                            --         
      *----------------------------------------------------------------         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04665'.
MSQ017     COPY MFASQLM.
                                                                        
      *****************************************************************         
      *    DB2 INCLUDES                                               *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_ACCT_MKT_TIER, DD                                         *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBMKTIER                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CRM_MKT_TIER, IG                                               *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMKTTER                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CRM_MKT_TIER_ADJ, 1B                                          *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBMKTTAD                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CSS_FIXED_FCTR ,FF                                            *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBFXDFCT                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CSS_CODE_VALUE, UV                                            *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBCDVALU                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CSS_DELINQUENCY, C8                                           *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBDELQ                                                 
            END-EXEC.                                                           
      *                                                                         
      *****************************************************************         
      * CSS_ACCOUNT, AT                                               *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBACCT                                                 
            END-EXEC.                                                           
      *                                                                         
      *****************************************************************         
      *    COBOL WORKING STORAGE COPY BOOKS                           *         
      *****************************************************************         
           COPY CCA00001.                                                       
           COPY CWS00056.                                                       
      *                                                                         
      *****************************************************************         
      *    ERROR HANDLING COPY BOOK.                                  *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    SQL ERROR CHECKING COPYBOOK.                               *         
      *****************************************************************         
           COPY CWS00303.                                                       
                                                                        
      *                                                                         
      *****************************************************************         
      *    WORK AREAS                                                 *         
      *****************************************************************         
      *                                                                         
       01  GTT-MISC-FIELDS.                                             
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR04665'.      
           05  ROWICMS                 PIC X(07) VALUE 'ROWICMS'.       
           05  GTT-ROW.                                                 
               49 GTT-ROW-LEN          PIC S9(04) COMP.                 
               49 GTT-ROW-CHAR         PIC X(1024).                     
           05  GTT-SQLCODE             PIC S9(9) COMP.                  
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-SUBROUTINE-IDS.                                       
               10  CSRERLOG              PIC X(8) VALUE 'CSRERLOG'.     
      *                                                                         
       01  LS-DATABASE                   PIC 9(01)  VALUE 0.            
           88 CSR-DATABASE                          VALUE 1.            
           88 SEB-DATABASE                          VALUE 2.            
      *                                                                         
      *---------------------------------------------------------------          
      *--  ERROR PROCESSING VARIABLES                               --          
      *---------------------------------------------------------------          
      *                                                                         
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
      *                                                                         
       01  WS-ERR-FLAGS.                                                
           10  WS-ERR-INSRT-R1              PIC X(01) VALUE 'N'.        
           10  WS-ERR-INSRT-R2              PIC X(01) VALUE 'N'.        
      *                                                                         
       01  TDS-RETURN-FIELDS.                                           
           10 RS-RETURN-CODE        PIC S9(9) COMP VALUE 0.             
           10 RS-APPL-RETURN-CODE   PIC S9(9) COMP VALUE 0.             
           10 RS-TIER-CUST-STAT-CD  PIC X(01) VALUE SPACES.             
           10 RS-TIER-ACCT-TYPE-CD  PIC X(01) VALUE SPACES.             
           10 RS-MKT-TIER-RANKING   PIC S9(4) COMP VALUE 0.             
           10 RS-MKT-TIER-DESC      PIC X(50) VALUE SPACES.             
           10 RS-MKT-TIER-START-DT  PIC X(10) VALUE SPACES.             
           10 RS-COMPANY-NO         PIC X(02) VALUE SPACES.             
           10 RS-CREATED-TS         PIC X(26) VALUE SPACES.             
           10 RS-LAST-UPDATE-USERID PIC X(07) VALUE SPACES.             
           10 RS-EFF-START-DT       PIC X(10) VALUE SPACES.             
           10 RS-LAST-UPDATE-TS     PIC X(26) VALUE SPACES.             
           10 RS-LAST-EVALUATED-DT  PIC X(10) VALUE SPACES.             
           10 RS-TIER-SOURCE-CD     PIC X(02) VALUE SPACES.             
           10 RS-ADJ-TIER-SEQ-DESC  PIC X(80) VALUE SPACES.             
           10 RS-PRP-TIER-RANK      PIC S9(4) COMP VALUE 0.             
                                                                        
       01  GTT-RETURN-FIELDS-1.                                         
           10 S-RETURN-CODE-1       PIC S9(9) COMP VALUE 0.             
           10 S-APPL-RETURN-CODE-1  PIC S9(9) COMP VALUE 0.             
           10 S-TIER-CUST-STAT-CD   PIC X(01) VALUE SPACES.             
           10 S-TIER-ACCT-TYPE-CD   PIC X(01) VALUE SPACES.             
           10 S-MKT-TIER-RANKING    PIC S9(4) COMP VALUE 0.             
           10 S-MKT-TIER-DESC       PIC X(50) VALUE SPACES.             
           10 S-MKT-TIER-START-DT   PIC X(10) VALUE SPACES.             
           10 S-COMPANY-NO          PIC X(02) VALUE SPACES.             
           10 S-CREATED-TS          PIC X(26) VALUE SPACES.             
           10 S-LAST-UPDATE-USERID  PIC X(07) VALUE SPACES.             
           10 S-EFF-START-DT        PIC X(10) VALUE SPACES.             
           10 S-LAST-UPDATE-TS      PIC X(26) VALUE SPACES.             
           10 S-LAST-EVALUATED-DT   PIC X(10) VALUE SPACES.             
           10 S-TIER-SOURCE-CD      PIC X(02) VALUE SPACES.             
           10 S-ADJ-TIER-SEQ-DESC   PIC X(80) VALUE SPACES.             
           10 S-PRP-TIER-RANK       PIC S9(4) COMP VALUE 0.             
      *                                                                         
      *********************************************************                 
      *   GTT TABLE LAYOUT FOR BUS RULE ERROR MESSAGE         *                 
      *********************************************************                 
       01 GTT-RETURN-FIELDS-2.                                          
           10 S-RETURN-CODE-2          PIC S9(04) COMP VALUE 0.         
           10 S-APPL-RETURN-CODE-2     PIC S9(04) COMP VALUE 0.         
           10 S-RS2-BUS-RULE-ID        PIC X(10)  VALUE SPACES.         
           10 S-RS2-BUS-RULE-RESULT-CD PIC X(10)  VALUE SPACES.         
           10 S-RS2-BUS-RULE-XREF-ID   PIC X(26)  VALUE SPACES.         
      *                                                                         
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS-RS1            PIC S9(9) COMP VALUE 0.          
           05  CTR-ROWS-RS2            PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
      *                                                                         
       01  WS-FLAG-VALUES.                                              
           05  WS-YES                       PIC X(01) VALUE 'Y'.        
           05  WS-NO                        PIC X(01) VALUE 'N'.        
           05  WS-ZERO                      PIC S9(4) COMP VALUE 0.     
      *                                                                         
       01  WS-MISC.                                                     
           05  WS-SQLSTATE            PIC X(05) VALUE SPACES.           
           05  WS-ACCOUNT-NO          PIC 9(13) VALUE ZERO.             
           05  WS-GTT-NAME            PIC X(26) VALUE SPACES.           
           05  WS-FAILED              PIC X(01)  VALUE 'F'.             
           05  WS-APPL-RETURN-CODE    PIC S9(04) COMP VALUE 0.          
           05  WS-PRP-MKT-TIER-RANK   PIC S9(4) USAGE COMP VALUE +0.    
           05  WS-PRP-DEFAULT-TIER    PIC X(20) VALUE                   
                                       'PRP-DEFAULT-TIER'.              
      *                                                                         
       01  WS-MISC-ITEMS.                                               
           05  WS-EXISTS-FLAG          PIC X(01) VALUE 'N'.             
           05  WS-ACTIVE-CODE          PIC X(01) VALUE 'A'.             
      *                                                                         
      *                                                                         
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
           05 WS-NO-MORE-ROWS         PIC X(01) VALUE  'N'.             
              88 NO-MORE-ROWS                   VALUE  'Y'.             
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **  CURSOR DECLARATION                                         **         
      *****************************************************************         
           EXEC SQL                                                     
              DECLARE ACCMKTR_CSR CURSOR FOR                            
                SELECT  DD.TIER_CUST_STAT_CD                            
                       ,DD.TIER_ACCT_TYPE_CD                            
                       ,DD.MKT_TIER_RANKING                             
                       ,DD.MKT_TIER_START_DT                            
                       ,DD.COMPANY_NO                                   
                       ,REPLACE(REPLACE(CONVERT(CHAR(26), DD.CREATED_TS
           , 121), ' ', '-'), ':', '.') CREATED_TS                             
                       ,DD.LAST_UPDATE_USERID                           
                       ,DD.EFF_START_DT                                 
                       ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           DD.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS        
                       ,DD.LAST_EVALUATED_DT                            
                       ,DD.TIER_SOURCE_CD                               
                       ,DD.ADJ_TIER_SEQ_NO                              
                  FROM CSS_ACCT_MKT_TIER DD WITH(READUNCOMMITTED)               
                 WHERE DD.ACCOUNT_NO          = :DD-ACCOUNT-NO          
                 FOR READ ONLY                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE ACCMKTR_CSR CURSOR FOR                                    
MFA-TR*         SELECT  DD.TIER_CUST_STAT_CD                                    
MFA-TR*                ,DD.TIER_ACCT_TYPE_CD                                    
MFA-TR*                ,DD.MKT_TIER_RANKING                                     
MFA-TR*                ,DD.MKT_TIER_START_DT                                    
MFA-TR*                ,DD.COMPANY_NO                                           
MFA-TR*                ,DD.CREATED_TS                                           
MFA-TR*                ,DD.LAST_UPDATE_USERID                                   
MFA-TR*                ,DD.EFF_START_DT                                         
MFA-TR*                ,DD.LAST_UPDATE_TS                                       
MFA-TR*                ,DD.LAST_EVALUATED_DT                                    
MFA-TR*                ,DD.TIER_SOURCE_CD                                       
MFA-TR*                ,DD.ADJ_TIER_SEQ_NO                                      
MFA-TR*           FROM CSS_ACCT_MKT_TIER DD                                     
MFA-TR*          WHERE DD.ACCOUNT_NO          = :DD-ACCOUNT-NO                  
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*          QUERYNO 5200                                                   
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
COB305 01 PARM-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.         
                                                                        
       PROCEDURE DIVISION USING PARM-ACCOUNT-NO.                        
                                                                        
      *****************************************************************         
      * 0000-MAINLINE                                                 *         
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                     *         
      *****************************************************************         
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE-PROCEDURE    THRU 0100-EXIT.         
           PERFORM 2000-PROCESS-OUTPUT          THRU 2000-EXIT.         
           PERFORM 9999-END-PROGRAM             THRU 9999-EXIT.         
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------*         
      *--  SET UP SQL ERROR PROCESSING                             ---*         
      *--  DECLARE ASSOCIATED CURSOR                               ---*         
      *---------------------------------------------------------------*         
       0100-INITIALIZE-PROCEDURE.                                       
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLWARNING                                      
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLERROR                                        
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER NOT FOUND                                       
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1                                 
              THRU 0100A-EXIT.                                          
      *                                                                         
           PERFORM 0100B-DECLARE-GTT-R2                                 
              THRU 0100B-EXIT.                                          
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------          
      *--  0100A-DECLARE-GTT-R1                                     --          
      *--  DECLARE TEMPORARY TABLE                                  --          
      *---------------------------------------------------------------          
       0100A-DECLARE-GTT-R1.                                            
           MOVE                                                         
           'DECLARE GLOBAL TEMPORARY TABLE CSR04665_R1'                 
                                          TO WS-GTT-NAME.               
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04665_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04665_R1
              (                                                       
                  RETURN_CODE          INT                          
                 ,APPL_RETURN_CODE     INT                          
                 ,TIER_CUST_STAT_CD CHAR(01)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                         
                 ,TIER_ACCT_TYPE_CD CHAR(01)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                         
                 ,MKT_TIER_RANKING     SMALLINT                         
                 ,MKT_TIER_DESC CHAR(50)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                         
                 ,MKT_TIER_START_DT CHAR(10)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                         
                 ,COMPANY_NO CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2          
                 ,CREATED_TS CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2          
                 ,LAST_UPDATE_USERID CHAR(07)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                         
                 ,EFF_START_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2        
                 ,LAST_UPDATE_TS CHAR(26)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                         
                 ,LAST_EVALUATED_DT CHAR(10)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                         
                 ,TIER_SOURCE_CD CHAR(02)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                         
                 ,ADJ_TIER_SEQ_DESC CHAR(80)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                         
                 ,PRP_TIER_RANK        SMALLINT                         
                )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO                          
                                            WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS                             
                 THRU 8000A-EXIT                                        
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  CONTINUE                                              
               ELSE                                                     
                  MOVE PROGRAM-NAME          TO ABEND-PROGRAM           
                  MOVE SQLCODE               TO ABEND-SQLCODE           
                  MOVE SQLSTATE              TO ABEND-SQLSTATE          
                  MOVE '0100A'               TO ACTIVE-PARAGRAPH        
                  MOVE 'DECLARE GTT'         TO ABEND-FUNCTION          
                  MOVE SPACES                TO                         
                                              ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                  MOVE WS-GTT-NAME           TO TABLE-1                 
                  MOVE SPACES                TO TABLE-ELEMENT-1         
                  MOVE SPACES                TO HOSTVAR-ELEMENT-1       
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT             
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
                                                                        
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                  SELECT RETURN_CODE                                    
                   ,APPL_RETURN_CODE                                    
                   ,LTRIM(RTRIM(TIER_CUST_STAT_CD))  AS 
           TIER_CUST_STAT_CD      
                   ,LTRIM(RTRIM(TIER_ACCT_TYPE_CD))  AS 
           TIER_ACCT_TYPE_CD      
                   ,MKT_TIER_RANKING                                    
                   ,LTRIM(RTRIM(MKT_TIER_DESC))      AS MKT_TIER_DESC          
                   ,LTRIM(RTRIM(MKT_TIER_START_DT))  AS 
           MKT_TIER_START_DT      
                   ,LTRIM(RTRIM(COMPANY_NO))         AS COMPANY_NO             
                   ,LTRIM(RTRIM(CREATED_TS))         AS CREATED_TS             
                   ,LTRIM(RTRIM(LAST_UPDATE_USERID)) AS 
           LAST_UPDATE_USERID     
                   ,LTRIM(RTRIM(EFF_START_DT))       AS EFF_START_DT           
                   ,LTRIM(RTRIM(LAST_UPDATE_TS))     AS LAST_UPDATE_TS         
                   ,LTRIM(RTRIM(LAST_EVALUATED_DT))  AS 
           LAST_EVALUATED_DT      
                   ,LTRIM(RTRIM(TIER_SOURCE_CD))     AS TIER_SOURCE_CD         
                   ,LTRIM(RTRIM(ADJ_TIER_SEQ_DESC))  AS 
           ADJ_TIER_SEQ_DESC      
                   ,PRP_TIER_RANK                                       
                  FROM #CSR04665_R1                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*           SELECT RETURN_CODE                                            
MFA-TR*            ,APPL_RETURN_CODE                                            
MFA-TR*            ,STRIP(TIER_CUST_STAT_CD)  AS TIER_CUST_STAT_CD              
MFA-TR*            ,STRIP(TIER_ACCT_TYPE_CD)  AS TIER_ACCT_TYPE_CD              
MFA-TR*            ,MKT_TIER_RANKING                                            
MFA-TR*            ,STRIP(MKT_TIER_DESC)      AS MKT_TIER_DESC                  
MFA-TR*            ,STRIP(MKT_TIER_START_DT)  AS MKT_TIER_START_DT              
MFA-TR*            ,STRIP(COMPANY_NO)         AS COMPANY_NO                     
MFA-TR*            ,STRIP(CREATED_TS)         AS CREATED_TS                     
MFA-TR*            ,STRIP(LAST_UPDATE_USERID) AS LAST_UPDATE_USERID             
MFA-TR*            ,STRIP(EFF_START_DT)       AS EFF_START_DT                   
MFA-TR*            ,STRIP(LAST_UPDATE_TS)     AS LAST_UPDATE_TS                 
MFA-TR*            ,STRIP(LAST_EVALUATED_DT)  AS LAST_EVALUATED_DT              
MFA-TR*            ,STRIP(TIER_SOURCE_CD)     AS TIER_SOURCE_CD                 
MFA-TR*            ,STRIP(ADJ_TIER_SEQ_DESC)  AS ADJ_TIER_SEQ_DESC              
MFA-TR*            ,PRP_TIER_RANK                                               
MFA-TR*           FROM SESSION.CSR04665_R1                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100B-DECLARE-GTT-R2                                           *        
      ******************************************************************        
       0100B-DECLARE-GTT-R2.                                            
                                                                        
           MOVE 'SESSION.CSR04665_R2'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04665_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04665_R2
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,BUS_RULE_ID CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BUS_RULE_RESULT_CD CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BUS_RULE_XREF_ID CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000B-DEL-GTT-ROWS    THRU 8000B-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100B'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT R2'         TO ABEND-FUNCTION        
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C2 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,LTRIM(RTRIM(BUS_RULE_ID))          AS BUS_RULE_ID       
                      ,LTRIM(RTRIM(BUS_RULE_RESULT_CD))   AS 
           BUS_RULE_RESULT_CD
                      ,LTRIM(RTRIM(BUS_RULE_XREF_ID))     AS 
           BUS_RULE_XREF_ID  
                  FROM #CSR04665_R2                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C2 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,STRIP(BUS_RULE_ID)          AS BUS_RULE_ID               
MFA-TR*               ,STRIP(BUS_RULE_RESULT_CD)   AS BUS_RULE_RESULT_CD        
MFA-TR*               ,STRIP(BUS_RULE_XREF_ID)     AS BUS_RULE_XREF_ID          
MFA-TR*           FROM SESSION.CSR04665_R2                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100B-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      * 2000-PROCESS-OUTPUT.                                          *         
      *                                                               *         
      *****************************************************************         
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE PARM-ACCOUNT-NO              TO WS-ACCOUNT-NO           
                                                DD-ACCOUNT-NO           
                                                AT-ACCOUNT-NO.          
      *                                                                         
           SET  CSR-DATABASE                 TO TRUE.                   
           MOVE '01'                         TO C8-COMPANY-NO           
           MOVE 'DATABASE'                   TO C8-DELINQ-CD            
           PERFORM 7350-SELECT-DELINQ-VALUE     THRU 7350-EXIT          
           MOVE C8-DELINQ-VALUE              TO LS-DATABASE             
                                                                        
           IF SEB-DATABASE                                              
              MOVE WS-PRP-DEFAULT-TIER          TO C8-DELINQ-CD         
              PERFORM 7350-SELECT-DELINQ-VALUE     THRU 7350-EXIT       
              MOVE C8-DELINQ-VALUE              TO WS-PRP-MKT-TIER-RANK 
              MOVE WS-PRP-MKT-TIER-RANK         TO RS-PRP-TIER-RANK     
           END-IF.                                                      
                                                                        
           PERFORM 5200-SELECT-MKT-TIER         THRU 5200-EXIT.         
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 2000A-MOVE-RESULT.                                                      
      *****************************************************************         
       2000A-MOVE-RESULT.                                               
                                                                        
            MOVE RS-RETURN-CODE             TO S-RETURN-CODE-1.         
            MOVE RS-APPL-RETURN-CODE        TO S-APPL-RETURN-CODE-1.    
            MOVE RS-TIER-CUST-STAT-CD       TO S-TIER-CUST-STAT-CD.     
            MOVE RS-TIER-ACCT-TYPE-CD       TO S-TIER-ACCT-TYPE-CD.     
            MOVE RS-MKT-TIER-RANKING        TO S-MKT-TIER-RANKING.      
            MOVE RS-MKT-TIER-DESC           TO S-MKT-TIER-DESC.         
            MOVE RS-MKT-TIER-START-DT       TO S-MKT-TIER-START-DT.     
            MOVE RS-COMPANY-NO              TO S-COMPANY-NO.            
            MOVE RS-CREATED-TS              TO S-CREATED-TS.            
            MOVE RS-LAST-UPDATE-USERID      TO S-LAST-UPDATE-USERID.    
            MOVE RS-EFF-START-DT            TO S-EFF-START-DT.          
            MOVE RS-LAST-UPDATE-TS          TO S-LAST-UPDATE-TS.        
            MOVE RS-LAST-EVALUATED-DT       TO S-LAST-EVALUATED-DT.     
            MOVE RS-TIER-SOURCE-CD          TO S-TIER-SOURCE-CD.        
            MOVE RS-ADJ-TIER-SEQ-DESC       TO S-ADJ-TIER-SEQ-DESC.     
            MOVE RS-PRP-TIER-RANK           TO S-PRP-TIER-RANK.         
       2000A-EXIT.                                                      
             EXIT.                                                      
                                                                        
      *****************************************************************         
      *                                                                         
      * 5200-SELECT-MKT-TIER.                                                   
      *****************************************************************         
       5200-SELECT-MKT-TIER.                                            
                                                                        
           MOVE WS-NO                        TO WS-NO-MORE-ROWS.        
           PERFORM 7000-OPEN-ACCMKTR-CSR        THRU 7000-EXIT          
           PERFORM 7100-FETCH-ACCMKTR-CSR       THRU 7100-EXIT          
           PERFORM 5250-PROCESS-MKT-TIER        THRU 5250-EXIT          
                                                UNTIL NO-MORE-ROWS.     
           PERFORM 7200-CLOSE-ACCMKTR-CSR       THRU 7200-EXIT.         
                                                                        
       5200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 5250-PROCESS-MKT-TIER.                                        *         
      *****************************************************************         
       5250-PROCESS-MKT-TIER.                                           
                                                                        
           MOVE DD-TIER-CUST-STAT-CD         TO RS-TIER-CUST-STAT-CD    
                                                IG-TIER-CUST-STAT-CD    
           MOVE DD-TIER-ACCT-TYPE-CD         TO RS-TIER-ACCT-TYPE-CD    
                                                IG-TIER-ACCT-TYPE-CD    
           MOVE DD-MKT-TIER-RANKING          TO RS-MKT-TIER-RANKING     
                                                IG-MKT-TIER-RANKING     
           MOVE DD-MKT-TIER-START-DT         TO RS-MKT-TIER-START-DT    
                                                IG-MKT-TIER-START-DT    
           MOVE DD-COMPANY-NO                TO RS-COMPANY-NO           
                                                IG-COMPANY-NO           
           MOVE DD-CREATED-TS                TO RS-CREATED-TS.          
           MOVE DD-LAST-UPDATE-USERID        TO RS-LAST-UPDATE-USERID.  
           MOVE DD-EFF-START-DT              TO RS-EFF-START-DT.        
           MOVE DD-LAST-UPDATE-TS            TO RS-LAST-UPDATE-TS.      
           MOVE DD-LAST-EVALUATED-DT         TO RS-LAST-EVALUATED-DT.   
           MOVE DD-TIER-SOURCE-CD            TO RS-TIER-SOURCE-CD.      
           MOVE DD-ADJ-TIER-SEQ-NO           TO 1B-ADJ-TIER-SEQ-NO      
           IF DD-ADJ-TIER-SEQ-NO EQUAL ZEROES                           
              MOVE 'N/A'                     TO RS-ADJ-TIER-SEQ-DESC    
           ELSE                                                         
              PERFORM 7330-SEL-TIER-ADJ-DESC    THRU 7330-EXIT          
              MOVE 1B-TIER-ADJ-DESC          TO RS-ADJ-TIER-SEQ-DESC    
           END-IF                                                       
           MOVE SPACES                       TO IG-MKT-TIER-DESC.       
           PERFORM 7320-SEL-MKT-TIER-DESC       THRU 7320-EXIT.         
           MOVE IG-MKT-TIER-DESC             TO RS-MKT-TIER-DESC.       
                                                                        
           PERFORM 2000A-MOVE-RESULT            THRU 2000A-EXIT.        
           PERFORM 8010-INSERT-GTT-R1           THRU 8010-EXIT.         
           PERFORM 7100-FETCH-ACCMKTR-CSR       THRU 7100-EXIT.         
                                                                        
       5250-EXIT.                                                       
             EXIT.                                                      
                                                                        
      *****************************************************************         
      * 7000-OPEN-ACCMKTR-CSR.                                        *         
      *****************************************************************         
       7000-OPEN-ACCMKTR-CSR.                                           
                                                                        
           EXEC SQL                                                     
              OPEN ACCMKTR_CSR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE   =  SUCCESSFUL-CALL                
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7000'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN '                  TO ABEND-FUNCTION           
              MOVE 'CSS_ACCT_MKT_TIER'      TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE DD-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT                
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7100-FETCH-ACCMKTR-CSR.                                       *         
      *     FETCH CURSOR TO GET ALL RECORDS SELECTED.                 *         
      *****************************************************************         
                                                                        
       7100-FETCH-ACCMKTR-CSR.                                          
                                                                        
           EXEC SQL                                                     
              FETCH ACCMKTR_CSR                                         
              INTO :DD-TIER-CUST-STAT-CD                                
                  ,:DD-TIER-ACCT-TYPE-CD                                
                  ,:DD-MKT-TIER-RANKING                                 
                  ,:DD-MKT-TIER-START-DT                                
                  ,:DD-COMPANY-NO                                       
                  ,:DD-CREATED-TS                                       
                  ,:DD-LAST-UPDATE-USERID                               
                  ,:DD-EFF-START-DT                                     
                  ,:DD-LAST-UPDATE-TS                                   
                  ,:DD-LAST-EVALUATED-DT                                
                  ,:DD-TIER-SOURCE-CD                                   
                  ,:DD-ADJ-TIER-SEQ-NO                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
             IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                   
               MOVE WS-YES TO WS-NO-MORE-ROWS                           
             END-IF                                                     
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7100'                   TO ACTIVE-PARAGRAPH         
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE 'FETCH'                  TO ABEND-FUNCTION           
              MOVE 'CSS_ACCT_MKT_TIER'      TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE DD-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT                
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7200-CLOSE-ACCMKTR-CSR.                                       *         
      *****************************************************************         
                                                                        
       7200-CLOSE-ACCMKTR-CSR.                                          
                                                                        
           EXEC SQL                                                     
              CLOSE ACCMKTR_CSR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7200'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE 'CSS_ACCT_MKT_TIER'      TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE DD-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT                
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7320-SEL-MKT-TIER-DESC.                                        *        
      ******************************************************************        
       7320-SEL-MKT-TIER-DESC.                                          
                                                                        
           EXEC SQL                                                     
               SELECT IG.MKT_TIER_DESC                                  
                 INTO :IG-MKT-TIER-DESC                                 
                 FROM CRM_MKT_TIER IG                                   
               WHERE IG.TIER_CUST_STAT_CD  = :IG-TIER-CUST-STAT-CD      
                  AND IG.TIER_ACCT_TYPE_CD  = :IG-TIER-ACCT-TYPE-CD     
                  AND IG.MKT_TIER_RANKING   = :IG-MKT-TIER-RANKING      
                  AND IG.COMPANY_NO         = :IG-COMPANY-NO            
                  AND IG.MKT_TIER_START_DT  = IIF(TRY_CONVERT(DATE, 
                                                  :IG-MKT-TIER-START-DT
              ) IS NULL OR (PATINDEX('%.%', :IG-MKT-TIER-START-DT
              ) <> 0) OR (LEN(:IG-MKT-TIER-START-DT
              ) <> 10), CIS.CHAR2DATE(:IG-MKT-TIER-START-DT
              ), CONVERT(DATE, :IG-MKT-TIER-START-DT) )     
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT IG.MKT_TIER_DESC                                          
MFA-TR*          INTO :IG-MKT-TIER-DESC                                         
MFA-TR*          FROM CRM_MKT_TIER IG                                           
MFA-TR*        WHERE IG.TIER_CUST_STAT_CD  = :IG-TIER-CUST-STAT-CD              
MFA-TR*           AND IG.TIER_ACCT_TYPE_CD  = :IG-TIER-ACCT-TYPE-CD             
MFA-TR*           AND IG.MKT_TIER_RANKING   = :IG-MKT-TIER-RANKING              
MFA-TR*           AND IG.COMPANY_NO         = :IG-COMPANY-NO                    
MFA-TR*           AND IG.MKT_TIER_START_DT  = :IG-MKT-TIER-START-DT             
MFA-TR*        QUERYNO 7320                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE         TO WS-ACTIVE-RETURN-CODE.               
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7320'                  TO ACTIVE-PARAGRAPH         
               MOVE SQLCODE                 TO ABEND-SQLCODE            
               MOVE SQLSTATE                TO ABEND-SQLSTATE           
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CRM_MKT_TIER'          TO TABLE-1                  
               MOVE 'TIER_CUST_STAT_CD'     TO TABLE-ELEMENT-1          
               MOVE 'TIER_ACCT_TYPE_CD'     TO TABLE-ELEMENT-2          
               MOVE 'MKT_TIER_RANKING'      TO TABLE-ELEMENT-3          
               MOVE IG-TIER-CUST-STAT-CD    TO HOSTVAR-ELEMENT-1        
               MOVE IG-TIER-ACCT-TYPE-CD    TO HOSTVAR-ELEMENT-2        
               MOVE IG-MKT-TIER-RANKING     TO HOSTVAR-ELEMENT-3        
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
           END-IF.                                                      
                                                                        
       7320-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7330-SEL-TIER-ADJ-DESC.                                        *        
      ******************************************************************        
       7330-SEL-TIER-ADJ-DESC.                                          
                                                                        
           EXEC SQL                                                     
               SELECT [1B].TIER_ADJ_DESC                                  
                 INTO :1B-TIER-ADJ-DESC                                 
                 FROM CRM_MKT_TIER_ADJ [1B] WITH(READUNCOMMITTED)               
                 WHERE [1B].ADJ_TIER_SEQ_NO = :1B-ADJ-TIER-SEQ-NO         
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 1B.TIER_ADJ_DESC                                          
MFA-TR*          INTO :1B-TIER-ADJ-DESC                                         
MFA-TR*          FROM CRM_MKT_TIER_ADJ 1B                                       
MFA-TR*          WHERE 1B.ADJ_TIER_SEQ_NO = :1B-ADJ-TIER-SEQ-NO                 
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7330                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE         TO WS-ACTIVE-RETURN-CODE.               
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7330'                  TO ACTIVE-PARAGRAPH         
               MOVE SQLCODE                 TO ABEND-SQLCODE            
               MOVE SQLSTATE                TO ABEND-SQLSTATE           
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CRM_MKT_TIER_ADJ'      TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE 'ADJ_TIER_SEQ_NO'       TO TABLE-ELEMENT-2          
               MOVE WS-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               MOVE 1B-ADJ-TIER-SEQ-NO      TO HOSTVAR-ELEMENT-2        
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
           END-IF.                                                      
                                                                        
       7330-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      *7350-SELECT-DELINQ-VALUE.                                                
      **************************************************************            
       7350-SELECT-DELINQ-VALUE.                                        
                                                                        
           EXEC SQL                                                     
              SELECT C8.DELINQ_VALUE                                    
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY C8 WITH(READUNCOMMITTED)                   
               WHERE C8.DELINQ_CD   = :C8-DELINQ-CD                     
                 AND C8.COMPANY_NO  = :C8-COMPANY-NO                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT C8.DELINQ_VALUE                                            
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY C8                                         
MFA-TR*        WHERE C8.DELINQ_CD   = :C8-DELINQ-CD                             
MFA-TR*          AND C8.COMPANY_NO  = :C8-COMPANY-NO                            
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7350                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE -1                     TO C8-DELINQ-VALUE         
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7350'                    TO ACTIVE-PARAGRAPH        
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_DELINQUENCY'         TO TABLE-1                 
              MOVE 'DELINQ_CD'               TO TABLE-ELEMENT-1         
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-2         
              MOVE C8-DELINQ-CD              TO HOSTVAR-ELEMENT-1       
              MOVE C8-COMPANY-NO             TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 8000A-DELETE-GTT-ROWS.                                        *         
      *****************************************************************         
       8000A-DELETE-GTT-ROWS.                                           
      *                                                                         
           MOVE 'DELETE ROWS'               TO WS-GTT-NAME.             
                                                                        
      *                                                                         
            EXEC SQL                                                    
                DELETE FROM #CSR04665_R1                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR04665_R1                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE SQLCODE                 TO ABEND-SQLCODE            
               MOVE SQLSTATE                TO ABEND-SQLSTATE           
               MOVE '8000A'                 TO ACTIVE-PARAGRAPH         
               MOVE 'DELETE'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE WS-GTT-NAME             TO TABLE-1                  
               MOVE SPACES                  TO TABLE-ELEMENT-1          
               MOVE SPACES                  TO HOSTVAR-ELEMENT-1        
               PERFORM 9900-SQL-ERROR-ROUTINE                           
                  THRU 9900-EXIT                                        
           END-IF.                                                      
      *                                                                         
       8000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ************************************************************              
      *                                                                         
      * 8000B-DEL-GTT-ROWS.                                                     
      ************************************************************              
       8000B-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04665_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04665_R2                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES          TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2             
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME    TO ABEND-PROGRAM               
                    MOVE SQLCODE         TO ABEND-SQLCODE               
                    MOVE SQLSTATE        TO ABEND-SQLSTATE              
                    MOVE '8000B'         TO ACTIVE-PARAGRAPH            
                    MOVE 'DELETE'        TO ABEND-FUNCTION              
                    MOVE SPACES          TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                    MOVE 'CSR04665_R2'   TO TABLE-1                     
                    MOVE SPACES          TO TABLE-ELEMENT-1             
                    MOVE SPACES          TO HOSTVAR-ELEMENT-1           
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       8000B-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ****************************************************************          
      * 8010-INSERT-GTT-R1                                           *          
      ****************************************************************          
       8010-INSERT-GTT-R1.                                              
                                                                        
           MOVE 'INSERT INTO CSR04665_R1'   TO WS-GTT-NAME.             
                                                                        
           EXEC SQL                                                     
               INSERT INTO #CSR04665_R1                          
                   (                                                    
                     RETURN_CODE                                        
                    ,APPL_RETURN_CODE                                   
                    ,TIER_CUST_STAT_CD                                  
                    ,TIER_ACCT_TYPE_CD                                  
                    ,MKT_TIER_RANKING                                   
                    ,MKT_TIER_DESC                                      
                    ,MKT_TIER_START_DT                                  
                    ,COMPANY_NO                                         
                    ,CREATED_TS                                         
                    ,LAST_UPDATE_USERID                                 
                    ,EFF_START_DT                                       
                    ,LAST_UPDATE_TS                                     
                    ,LAST_EVALUATED_DT                                  
                    ,TIER_SOURCE_CD                                     
                    ,ADJ_TIER_SEQ_DESC                                  
                    ,PRP_TIER_RANK                                      
                   )                                                    
               VALUES                                                   
                   (                                                    
                     :S-RETURN-CODE-1                                   
                    ,:S-APPL-RETURN-CODE-1                              
                    ,:S-TIER-CUST-STAT-CD                               
                    ,:S-TIER-ACCT-TYPE-CD                               
                    ,:S-MKT-TIER-RANKING                                
                    ,:S-MKT-TIER-DESC                                   
                    ,:S-MKT-TIER-START-DT                               
                    ,:S-COMPANY-NO                                      
                    ,:S-CREATED-TS                                      
                    ,:S-LAST-UPDATE-USERID                              
                    ,:S-EFF-START-DT                                    
                    ,:S-LAST-UPDATE-TS                                  
                    ,:S-LAST-EVALUATED-DT                               
                    ,:S-TIER-SOURCE-CD                                  
                    ,:S-ADJ-TIER-SEQ-DESC                               
                    ,:S-PRP-TIER-RANK                                   
                   )                                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO SESSION.CSR04665_R1                                  
MFA-TR*            (                                                            
MFA-TR*              RETURN_CODE                                                
MFA-TR*             ,APPL_RETURN_CODE                                           
MFA-TR*             ,TIER_CUST_STAT_CD                                          
MFA-TR*             ,TIER_ACCT_TYPE_CD                                          
MFA-TR*             ,MKT_TIER_RANKING                                           
MFA-TR*             ,MKT_TIER_DESC                                              
MFA-TR*             ,MKT_TIER_START_DT                                          
MFA-TR*             ,COMPANY_NO                                                 
MFA-TR*             ,CREATED_TS                                                 
MFA-TR*             ,LAST_UPDATE_USERID                                         
MFA-TR*             ,EFF_START_DT                                               
MFA-TR*             ,LAST_UPDATE_TS                                             
MFA-TR*             ,LAST_EVALUATED_DT                                          
MFA-TR*             ,TIER_SOURCE_CD                                             
MFA-TR*             ,ADJ_TIER_SEQ_DESC                                          
MFA-TR*             ,PRP_TIER_RANK                                              
MFA-TR*            )                                                            
MFA-TR*        VALUES                                                           
MFA-TR*            (                                                            
MFA-TR*              :S-RETURN-CODE-1                                           
MFA-TR*             ,:S-APPL-RETURN-CODE-1                                      
MFA-TR*             ,:S-TIER-CUST-STAT-CD                                       
MFA-TR*             ,:S-TIER-ACCT-TYPE-CD                                       
MFA-TR*             ,:S-MKT-TIER-RANKING                                        
MFA-TR*             ,:S-MKT-TIER-DESC                                           
MFA-TR*             ,:S-MKT-TIER-START-DT                                       
MFA-TR*             ,:S-COMPANY-NO                                              
MFA-TR*             ,:S-CREATED-TS                                              
MFA-TR*             ,:S-LAST-UPDATE-USERID                                      
MFA-TR*             ,:S-EFF-START-DT                                            
MFA-TR*             ,:S-LAST-UPDATE-TS                                          
MFA-TR*             ,:S-LAST-EVALUATED-DT                                       
MFA-TR*             ,:S-TIER-SOURCE-CD                                          
MFA-TR*             ,:S-ADJ-TIER-SEQ-DESC                                       
MFA-TR*             ,:S-PRP-TIER-RANK                                           
MFA-TR*            )                                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R1 = WS-YES          
              ADD 1 TO CTR-ROWS-RS1                                     
              INITIALIZE GTT-RETURN-FIELDS-1                            
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE '8010'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE WS-GTT-NAME              TO TABLE-1                  
              MOVE SPACES                   TO TABLE-ELEMENT-1          
              MOVE SPACES                   TO HOSTVAR-ELEMENT-1        
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                 THRU 9900-EXIT                                         
           END-IF.                                                      
      *                                                                         
       8010-EXIT.                                                       
           EXIT.                                                        
      ************************************************************              
      *                                                                         
      * 8020-INSERT-GTT-R2.                                                     
      ************************************************************              
       8020-INSERT-GTT-R2.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04665_R2                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,BUS_RULE_ID                                          
                  ,BUS_RULE_RESULT_CD                                   
                  ,BUS_RULE_XREF_ID                                     
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-2                                     
                  ,:S-APPL-RETURN-CODE-2                                
                  ,:S-RS2-BUS-RULE-ID                                   
                  ,:S-RS2-BUS-RULE-RESULT-CD                            
                  ,:S-RS2-BUS-RULE-XREF-ID                              
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04665_R2                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,BUS_RULE_ID                                                  
MFA-TR*           ,BUS_RULE_RESULT_CD                                           
MFA-TR*           ,BUS_RULE_XREF_ID                                             
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-2                                             
MFA-TR*           ,:S-APPL-RETURN-CODE-2                                        
MFA-TR*           ,:S-RS2-BUS-RULE-ID                                           
MFA-TR*           ,:S-RS2-BUS-RULE-RESULT-CD                                    
MFA-TR*           ,:S-RS2-BUS-RULE-XREF-ID                                      
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R2 = WS-YES          
              ADD +1                     TO  CTR-ROWS-RS2               
              INITIALIZE GTT-RETURN-FIELDS-2                            
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8020'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE WS-YES                TO  WS-ERR-INSRT-R2            
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04665_R2'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       8020-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ************************************************************              
      *                                                                         
      * 8800-CHECK-RESULTS.                                                     
      ************************************************************              
       8800-CHECK-RESULTS.                                              
                                                                        
           IF CTR-ROWS-RS1 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-1                            
              MOVE 100                       TO S-RETURN-CODE-1         
              MOVE   0                       TO S-APPL-RETURN-CODE-1    
              PERFORM 8010-INSERT-GTT-R1     THRU 8010-EXIT             
           END-IF.                                                      
      *                                                                         
           IF CTR-ROWS-RS2 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-2                            
              MOVE 100                       TO S-RETURN-CODE-2         
              MOVE   0                       TO S-APPL-RETURN-CODE-2    
              PERFORM 8020-INSERT-GTT-R2     THRU 8020-EXIT             
           END-IF.                                                      
      *                                                                         
       8800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      *                                                                         
      * 8900-SEND-DONE.                                                         
      ************************************************************              
       8900-SEND-DONE.                                                  
                                                                        
           MOVE PROGRAM-NAME          TO ABEND-PROGRAM                  
           MOVE '8900'                TO ACTIVE-PARAGRAPH               
           MOVE 'OPEN'                TO ABEND-FUNCTION                 
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE 'CSR04665_R1'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C2                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE 'CSR04665_R2'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      *                                                                         
      * 9000-SEND-ERROR-RESULT                                                  
      ************************************************************              
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-1                               
                      GTT-RETURN-FIELDS-2.                              
           MOVE WS-ACTIVE-RETURN-CODE     TO ABEND-SQLCODE              
                                             S-RETURN-CODE-1            
                                             S-RETURN-CODE-2            
                                                                        
           MOVE WS-APPL-RETURN-CODE       TO S-APPL-RETURN-CODE-1       
                                             S-APPL-RETURN-CODE-2       
                                                                        
                                                                        
           MOVE SQLERRMC                  TO ABEND-SQLERRMC.            
                                                                        
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'             TO ABEND-FUNCTION             
           END-IF.                                                      
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1   THRU 0100A-EXIT.              
           PERFORM 0100B-DECLARE-GTT-R2   THRU 0100B-EXIT.              
                                                                        
           PERFORM 8010-INSERT-GTT-R1     THRU 8010-EXIT.               
           PERFORM 8020-INSERT-GTT-R2     THRU 8020-EXIT.               
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      * 9700-ABEND-PROCESSING.                                                  
      ************************************************************              
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT.             
           PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT.             
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                     *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ************************************************************              
      * 9999-END-PROGRAM.                                                       
      ************************************************************              
                                                                        
       9999-END-PROGRAM.                                                
                                                                        
            PERFORM 8800-CHECK-RESULTS THRU 8800-EXIT                   
            PERFORM 8900-SEND-DONE     THRU 8900-EXIT                   
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
