       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.      CSR04664.                                       
       AUTHOR.       SAKTHIVEL MATHIYAZHAGAN.                           
COB303 DATE-WRITTEN. 08 OCT 2013.                                       
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE: CSR04664               --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--                                                            --         
      *--  CSR04664 :                                                --         
      *--                                                            --         
      *--  #  THIS STORED PROCEDURE IS PERFORM TO RETRIEVE           --         
      *--     MRM - FLAGS FOR BILLING AND METERING.                  --         
      *--                                                            --         
      *--  #  CLONED FROM: CSR02046 & CSR02288 & CSR04157.           --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--  Notes:                                                    --         
      *--                                                            --         
      *--  #  THE BELOW FLAGS ARE RETURNED at util & ic level.       --         
      *--                                                            --         
      *--     Account Has Active Unmetered Plans Exists.             --         
      *--     Number Of Active Meters.                               --         
      *--     Is Dekatherms Rate.                                    --         
      *--     Is Industrial Gas Customer Rate.                       --         
      *--     Account Has Fixed Factors.                             --         
      *--     Account Has Bill Contracts.                            --         
      *--     Interruptable Account.                                 --         
      *--     Number of blocks allowed for fixed factors.            --         
      *--     IC/Account is currently DSM Exempt.                    --         
      *--     IC/Rate Plan is eligible for DSM exemption.            --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *--  INPUT PARAMETERS.                                         --         
      *--                                                            --         
      *--            I_ACCOUNT_NO           DECIMAL(13)              --         
      *--            I_CODE_UTIL_TYPE       DECIMAL(01)              --         
      *--            I_IC_NO                SMALLINT                 --         
      *--                                                            --         
      *--  OUTPUT PARAMETERS.                                        --         
      *--            RETURN_CODE             INTEGER                 --         
      *--            APPL_RETURN_CODE        INTEGER                 --         
      *--            CODE_UTIL_TYPE          CHAR(01)                --         
      *--            IC_NO                   SMALLINT                --         
      *--            RATE_PLAN_NO            CHAR(03)                --         
      *--            ACTV_UNMTR_PLN_EXIST    CHAR(01)                --         
      *--            ACTIVE_METERS_CNT       INTEGER                 --         
      *--            BASE_USE_IND            CHAR(01)                --         
      *--            INDUS_GAS_CUST          CHAR(01)                --         
      *--            FIXED_FACTORS_IND       CHAR(01)                --         
      *--            BILL_CONTRACT_IND       CHAR(01)                --         
      *--            INTERRUPT_ACCT_IND      CHAR(01)                --         
      *--            ALLOWED_BLOCKS          SMALLINT                --         
      *--            DSM_EXEMPT_FL           CHAR(01)                --         
      *--            ELGBLE_FOR_DSM_EXEMPTN  CHAR(01)                --         
      *--            PNDNG_SRVCE_ORDER_IND   CHAR(01)                --         
      *--            MULTI_GAS_ELEC_IND      CHAR(01)                --         
      *--            CURR_OPTION_CD          CHAR(12)                --         
      *--            CURR_OPTION_SHORT_DESC  CHAR(50)                --         
      *--            CURR_OPTION_LONG_DESC   VARCHAR(255)            --         
      *--            CURR_OPTION_CSC_AMT     DECIMAL(11,6)           --         
      *--            CURR_OPTION_THERM_PRICE DECIMAL(11,6)           --         
      *--            CURR_OPTION_STATUS_CD   CHAR(01)                --         
      *--            PEND_OPTION_CD          CHAR(12)                --         
      *--            PEND_OPTION_SHORT_DESC  CHAR(50)                --         
      *--            PEND_OPTION_LONG_DESC   VARCHAR(255)            --         
      *--            PEND_OPTION_CSC_AMT     DECIMAL(11,6)           --         
      *--            PEND_OPTION_THERM_PRICE DECIMAL(11,6)           --         
      *--            PEND_OPTION_FL          CHAR(01)                --         
      *--            SUBDVSN_LIGHT_IND       CHAR(01)                --         
      *--            ACCT_ON_BANK_DRAFT      CHAR(01)                --         
      *--            LAST_DRAFT_DATE         CHAR(10)                --         
      *--            DRAFT_CYCLE             CHAR(02)                --         
      *--            PNDG_DRAFT_DATE         CHAR(10)                --         
      *--            ACCT_BILL_CYCLE         CHAR(02)                --         
      *--            CODE_ACCT_STAT          CHAR(01)                --         
      *--            ACCOUNT_TYPE_CODE       CHAR(01)                --         
      *--            MST_DEP_REL_EXISTS      CHAR(01)                --         
      *--            UNMTR_RATE_MAINTABLE    CHAR(01)                --         
P00892*--            CURR_AUTO_REN_OPT_IN_FL CHAR(01)                --         
P00892*--            PEND_AUTO_REN_OPT_IN_FL CHAR(01)                --         
OTPOOL*--            TIER_ACCT_TYPE_CD       CHAR(01)                --         
OTPOOL*--            OUTER_POOL_FL           CHAR(01)                --         
P01137*--            CURR_OPT_CALC_TYPE_CD   CHAR(02)                --         
P01137*--            PEND_OPT_CALC_TYPE_CD   CHAR(02)                --         
      ******************************************************************        
      *--                                                            --         
      *--              ---- BASIC SEQUENCE STRUCTURE ----            --         
      *--                                                            --         
      *--0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION           --         
      *--1000 - 1999  INPUT PROCESSING CONTROL PATH                  --         
      *--2000 - 2999  OUTPUT PROCESSING CONTROL PATH                 --         
      *--3000 - 4999  NOT USED                                       --         
      *--5000 - 5999  COMMON PROGRAM MODULES                         --         
      *--6000 - 6999  COMMON SYSTEM MODULES                          --         
      *--7000 - 7999  INPUT MODULES                                  --         
      *--8000 - 8999  OUTPUT MODULES                                 --         
      *--9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES           --         
      *--                                                            --         
      *****************************************************************         
      *----------------------------------------------------------------         
      *--                        MODIFICATION LOG                    --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
      *--  10-08-2013    MS93554     PROGRAM INTIALLY WRITTEN.       --         
P00892*--  08-28-2015    VV44188     AUTO RENEWAL OPTION CHANGES     --         
A05136*--  09-01-2015    SM93554     INITILIAZE PENDING OPTN DESC    --         
      *--                ACT-167                                     --         
A05460*--  06-01-2016    MS7M727     REMOVED UNUSED COPYBOOK CCA00001--         
      *--                ACT181                                      --         
OTPOOL*--  07-18-2016    SS45239     OUTER POOL CHANGES.             --         
P01137*--  08-03-2016    MS7M727     ADDED PEND_OPT_CALC_TYPE_CD,    --         
P01137*--                            CURR_OPT_CALC_TYPE_CD COLUMNS   --         
P01137*--                            IN RESULT SET 1                 --         
I02262*--  08-22-2016    SS45239     APPEND DDDC TO OPTION DESCRIPTION-         
      *--                            FOR 2-PART-RATES.               --         
P01137*--  11-29-2016    MS7M727     ADDED OPT_AGRMT_EFF_DT,         --         
P01137*--                            OPT_AGRMT_EFF_TM COLUMNS IN     --         
P01137*--                            RESULT SET 1                    --         
PRJ137*--  12-28-2016    JC91900     Set default values for option   --         
PRJ137*--                            agreement effective date and    --         
PRJ137*--                            time to avoid the null exception--         
PRJ137*--                            issue with BusOp.               --         
      *----------------------------------------------------------------         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04664'.
MSQ017     COPY MFASQLM.
                                                                        
                                                                        
       01 WS-WORKING-STORAGE.                                           
          05 WS-SQLSTATE                  PIC X(05) VALUE SPACES.       
                                                                        
       01 WS-SWITCHES.                                                  
          05 ALL-DONE-SW                  PIC X(01) VALUE 'N'.          
             88 NOT-ALL-DONE                        VALUE 'N'.          
             88 ALL-DONE                            VALUE 'Y'.          
          05 SEND-DONE-SW                 PIC X(01) VALUE 'Y'.          
             88 SEND-DONE-ERROR                     VALUE 'N'.          
             88 SEND-DONE-OK                        VALUE 'Y'.          
          05 WS-DATABASE                  PIC 9(01) VALUE ZERO.         
             88 CSR-DATABASE                        VALUE 1.            
             88 SEB-DATABASE                        VALUE 2.            
          05 WS-SUBDVSN-LIGHT-FL          PIC X(01) VALUE 'N'.          
             88 SUBDVSN-LIGHT                       VALUE 'Y'.          
                                                                        
       01 WS-GENERAL-VARIABLE.                                          
          05 WS-BLOCK-NULL-ID             PIC S9(4) COMP VALUE 0.       
          05 WS-PREV-PREMISE-NO           PIC S9(10)V USAGE COMP-3      
                                                    VALUE 0.            
          05 WS-G6-PARM-ACCOUNT-NO        PIC 9(13) VALUE 0.            
I02262    05 WS-CORE-RATE-DDDC            PIC Z9.99.                    
                                                                        
       01 WS-LITERALS.                                                  
          05 PROGRAM-NAME                 PIC X(08) VALUE 'CSR04664'.   
          05 WS-A                         PIC X(01) VALUE 'A'.          
          05 WS-I                         PIC X(01) VALUE 'I'.          
          05 WS-B                         PIC X(01) VALUE 'B'.          
          05 WS-NO                        PIC X(01) VALUE 'N'.          
          05 WS-YES                       PIC X(01) VALUE 'Y'.          
          05 MULTIPLE-ROWS                PIC S9(9) VALUE -811 COMP.    
          05 WS-ZERO                      PIC 9(01) VALUE 0.            
          05 WS-NINE                      PIC 9(01) VALUE 9.            
          05 WS-ONE                       PIC 9(01) VALUE 1.            
          05 WS-YES-NULL                  PIC S9(4) VALUE -1.           
          05 WS-ELECTRIC                  PIC X(01) VALUE 'E'.          
          05 WS-CHECK-FOR-MST             PIC X(01) VALUE 'N'.          
          05 WS-CHECK-FOR-DEP             PIC X(01) VALUE 'N'.          
          05 WS-NULL-LAST-DRAFT-DATE      PIC S9(04) COMP VALUE ZERO.   
          05 WS-NULL-IND-1                PIC S9(04) COMP VALUE ZERO.   
          05 WS-SERV-ORDER-IS-PNDNG       PIC X(01) VALUE 'A'.          
          05 WS-GAS-DEKATHERMS            PIC X(01) VALUE 'D'.          
          05 WS-BASIC-FIRM                PIC X(02) VALUE '10'.         
          05 WS-UNMETER                   PIC X(01) VALUE 'U'.          
          05 WS-EPP-ACCOUNT               PIC X(01) VALUE 'A'.          
          05 WS-MCSCB063                  PIC X(08) VALUE 'MCSCB063'.   
          05 WS-MCSCB063-RET-CODE         PIC S9(04) COMP VALUE 0.      
          05 WS-COUNTER                   PIC S9(04) COMP VALUE 0.      
          05 WS-FACTOR-FF                 PIC S9(09)V9(06) USAGE COMP-3 
                                                        VALUE 0.        
          05 WS-DMD-SIDE-MGMT             PIC X(09) VALUE 'DSMCREDIT'.  
          05 WS-DS                        PIC X(02) VALUE 'DS'.         
          05 GTT-NAME                     PIC X(26)                     
                                          VALUE 'SESSION.CSR04664_R1'.  
                                                                        
       01 COUNTER-FIELDS.                                               
          05 CTR-COLUMN                   PIC S9(9) COMP VALUE 1.       
          05 CTR-ROWS                     PIC S9(9) COMP VALUE 0.       
                                                                        
       01 GTT-RETURN-FIELDS.                                            
          05 S-RETURN-CODE                PIC S9(09) COMP  VALUE 0.     
          05 S-APPL-RETURN-CODE           PIC S9(09) COMP  VALUE 0.     
          05 S-CODE-UTIL-TYPE             PIC  X(01) VALUE SPACES.      
          05 S-IC-NO                      PIC S9(04) COMP  VALUE 0.     
          05 S-RATE-PLAN-NO               PIC  X(03) VALUE SPACES.      
          05 S-ACTV-UNMTR-PLN-EXIST       PIC  X(01) VALUE SPACES.      
          05 S-ACTIVE-METERS-CNT          PIC S9(09) COMP  VALUE 0.     
          05 S-BASE-USE-IND               PIC  X(01) VALUE SPACES.      
          05 S-INDUS-GAS-CUST             PIC  X(01) VALUE SPACES.      
          05 S-FIXED-FACTORS-IND          PIC  X(01) VALUE SPACES.      
          05 S-BILL-CONTRACT-IND          PIC  X(01) VALUE SPACES.      
          05 S-INTERRUPT-ACCT-IND         PIC  X(01) VALUE SPACES.      
          05 S-ALLOWED-BLOCKS             PIC S9(04) COMP  VALUE 0.     
          05 S-DSM-EXEMPT-FL              PIC  X(01) VALUE SPACES.      
          05 S-ELGBLE-FOR-DSM-EXEMPTN     PIC  X(01) VALUE SPACES.      
          05 S-PNDNG-SRVCE-ORDER-IND      PIC  X(01) VALUE SPACES.      
          05 S-MULTI-GAS-ELEC-IND         PIC  X(01) VALUE SPACES.      
          05 S-CURR-OPTION-CD             PIC  X(12) VALUE SPACES.      
          05 S-CURR-OPTION-SHORT-DESC     PIC  X(50) VALUE SPACES.      
          05 S-CURR-OPTION-LONG-DESC      PIC X(255) VALUE SPACES.      
          05 S-CURR-OPTION-CSC-AMT        PIC S9(05)V9(6) USAGE COMP-3  
                                                     VALUE ZEROES.      
          05 S-CURR-OPTION-THERM-PRICE    PIC S9(05)V9(6) USAGE COMP-3  
                                                     VALUE ZEROES.      
          05 S-CURR-OPTION-STATUS-CD      PIC  X(01) VALUE SPACES.      
          05 S-PEND-OPTION-CD             PIC  X(12) VALUE SPACES.      
          05 S-PEND-OPTION-SHORT-DESC     PIC  X(50) VALUE SPACES.      
          05 S-PEND-OPTION-LONG-DESC      PIC X(255) VALUE SPACES.      
          05 S-PEND-OPTION-CSC-AMT        PIC S9(05)V9(6) USAGE COMP-3  
                                                     VALUE ZEROES.      
          05 S-PEND-OPTION-THERM-PRICE    PIC S9(05)V9(6) USAGE COMP-3  
                                                     VALUE ZEROES.      
          05 S-PEND-OPTION-FL             PIC  X(01) VALUE SPACES.      
          05 S-SUBDVSN-LIGHT-IND          PIC  X(01) VALUE SPACES.      
          05 S-ACCT-ON-BANK-DRAFT         PIC  X(01) VALUE SPACES.      
          05 S-LAST-DRAFT-DATE            PIC  X(10) VALUE SPACES.      
          05 S-DRAFT-CYCLE                PIC  X(02) VALUE SPACES.      
          05 S-PNDG-DRAFT-DATE            PIC  X(10) VALUE SPACES.      
          05 S-BILL-CYCLE                 PIC  X(02) VALUE SPACES.      
          05 S-CODE-ACCT-STAT             PIC  X(01) VALUE SPACES.      
          05 S-ACCOUNT-TYPE-CODE          PIC  X(01) VALUE SPACES.      
          05 S-MST-DEP-REL-EXISTS         PIC  X(01) VALUE 'N'.         
          05 S-UNMTR-RATE-MAINTABLE       PIC  X(01) VALUE 'Y'.         
          05 S-RATE-64-UPDT-FL            PIC  X(01) VALUE 'Y'.         
P00892    05 S-CURR-AUTO-REN-OPT-IN-FL    PIC  X(01) VALUE SPACES.      
P00892    05 S-PEND-AUTO-REN-OPT-IN-FL    PIC  X(01) VALUE SPACES.      
OTPOOL    05 S-TIER-ACCT-TYPE-CD          PIC  X(01) VALUE SPACES.      
OTPOOL    05 S-OUTER-POOL-FL              PIC  X(01) VALUE SPACES.      
P01137    05 S-CURR-OPT-CALC-TYPE-CD      PIC  X(02) VALUE SPACES.      
P01137    05 S-PEND-OPT-CALC-TYPE-CD      PIC  X(02) VALUE SPACES.      
P01137    05 S-OPT-AGRMT-EFF-DT           PIC  X(10) VALUE SPACES.      
P01137    05 S-OPT-AGRMT-EFF-TM           PIC  X(08) VALUE SPACES.      
                                                                        
       01 WS-CODE-VALUE.                                                
          05  WS-CODE-VALUE-LEN           PIC S9(4) COMP VALUE 5.       
          05  WS-CODE-VALUE-UTL-TYP       PIC X(01) VALUE SPACES.       
          05  FILLER                      PIC X(01) VALUE ''.          
          05  WS-CODE-VALUE-RATE-PLAN     PIC X(03) VALUE SPACES.       
          05  FILLER                      PIC X(05) VALUE SPACES.       
                                                                        
       01 WS-CODE-SHORT-DESC-TEXT.                                      
          05  WS-CODE-SHORT-DESC-TXT      PIC X(01) VALUE SPACES.       
          05  FILLER                      PIC X(14) VALUE SPACES.       
                                                                        
       01 CSRERLOG-P.                                                   
          10  S-SP-NAME                   PIC X(18)  VALUE SPACES.      
          10  S-SQLCODE                   PIC S9(9)  COMP VALUE 0.      
          10  S-SQLSTATE                  PIC X(5)   VALUE ' '.         
          10  S-TABLE-NAME                PIC X(18)  VALUE SPACES.      
          10  S-HOST-VARIABLES.                                         
              49  S-HOST-VARIABLES-L      PIC S9(4)  USAGE COMP.        
              49  S-HOST-VARIABLES-V      PIC X(255).                   
          10  S-SQL-STATEMENT.                                          
              49  S-SQL-STATEMENT-L       PIC S9(4)  USAGE COMP.        
              49  S-SQL-STATEMENT-V       PIC X(255).                   
          10  S-SQL-DESCRIPTION.                                        
              49  S-SQL-DESCRIPTION-L     PIC S9(4)  USAGE COMP.        
              49  S-SQL-DESCRIPTION-V     PIC X(255).                   
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ACCOUNT          AT                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
OTPOOL******************************************************************02620000
OTPOOL*    CSS_LOCAL_OFFICE - B1                                       *02630000
OTPOOL******************************************************************02640000
OTPOOL     EXEC SQL                                                     02660000
OTPOOL          INCLUDE TBLOCOFC                                        02670000
OTPOOL     END-EXEC.                                                    02680000
OTPOOL                                                                  
      ******************************************************************        
      *    CSS_MTRD_ENVRNMT     MN                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMTRENV                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_UTIL_ENVRNMT     UT                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CRM_RT_PKG_OPTION    FI                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRTPKGO                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ACCT_RTPK_AGR    DF                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBACCTRG                                                  
           END-EXEC.                                                            
                                                                        
OTPOOL******************************************************************        
OTPOOL*    CSS_ACCT_MKT_TIER    DD                                     *        
OTPOOL******************************************************************        
OTPOOL     EXEC SQL                                                             
OTPOOL        INCLUDE TBMKTIER                                                  
OTPOOL     END-EXEC.                                                            
OTPOOL                                                                  
      ******************************************************************        
      *    CSS_CUST_PLAN        CP                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCSTPLN                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_JOB_PARM       G6                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CRM_OPT_ATTR_INCTV   HQ                                    *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBOPTATT                                               
            END-EXEC.                                                           
                                                                        
      ******************************************************************        
      *    CSS_PREMISE          PR                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_RATE_COMP_DEF    J1                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRTCDEF                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_FIXED_FCTR       FF                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBFXDFCT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_BILL_CONTRACT    BK                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBBLCNTR                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_BANK_EFT         BE                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBBNKEFT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_PNDNG_BNK_DRFT   PB                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBPDBKDF                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_INTERRUPT_ACCT   IP                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBINTACT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_DELINQUENCY      C8                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_RATE_PLAN_DESC   RD                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRTDESC                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_SPCL_FCTR        SF                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBSPLFTR                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_SPCL_FCTR_APPL   SA                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBSPLAPL                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_PRICE_SCHED      PS                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBPRCSCH                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_RATE_CREATOR     RT                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRTCRTR                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_UTL_BILL_REL     UR                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBUTLREL                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_CODE_VALUE     UV                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCDVALU                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    SQL ERROR CHECKING COPYBOOK.                                *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    CODES DATA PRESENT WORK AREA.                               *        
      ******************************************************************        
           COPY CWS00056.                                                       
                                                                        
      ******************************************************************        
      *    SUPPORT FOR MCSCB063.                                       *        
      ******************************************************************        
           COPY CWS00063.                                                       
                                                                        
      ******************************************************************        
      *    ERROR HANDLING COPY BOOK.                                   *        
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
COB305 01 PARM-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.     
       01 PARM-CODE-UTIL-TYPE             PIC  X(01)  VALUE SPACES.     
       01 PARM-IC-NO                      PIC S9(04)  COMP VALUE 0.     
                                                                        
       PROCEDURE DIVISION  USING PARM-ACCOUNT-NO                        
                                 PARM-CODE-UTIL-TYPE                    
                                 PARM-IC-NO.                            
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0000-MAINLINE.                                                 *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE               THRU 0100-EXIT.        
           PERFORM 1000-PROCESS-INPUT            THRU 1000-EXIT.        
           PERFORM 2000-PROCESS-OUTPUT           THRU 2000-EXIT.        
           PERFORM 9999-END-PROGRAM              THRU 9999-EXIT.        
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           EXEC SQL                                                     
             DECLARE C1 CURSOR  FOR                          
              SELECT :S-RETURN-CODE             AS RETURN_CODE          
                    ,:S-APPL-RETURN-CODE        AS APPL_RETURN_CODE     
                    ,LTRIM(RTRIM(:S-CODE-UTIL-TYPE))   AS CODE_UTIL_TYPE       
                    ,:S-IC-NO                   AS IC_NO                
                    ,LTRIM(RTRIM(:S-RATE-PLAN-NO))     AS RATE_PLAN_NO         
                    ,LTRIM(RTRIM(:S-ACTV-UNMTR-PLN-EXIST))                     
                                                AS ACTV_UNMTR_PLN_EXIST 
                    ,:S-ACTIVE-METERS-CNT       AS ACTIVE_METERS_CNT    
                    ,LTRIM(RTRIM(:S-BASE-USE-IND))     AS BASE_USE_IND         
                    ,LTRIM(RTRIM(:S-INDUS-GAS-CUST))   AS INDUS_GAS_CUST       
                    ,LTRIM(RTRIM(:S-FIXED-FACTORS-IND))                        
                                                AS FIXED_FACTORS_IND    
                    ,LTRIM(RTRIM(:S-BILL-CONTRACT-IND))                        
                                                AS BILL_CONTRACT_IND    
                    ,LTRIM(RTRIM(:S-INTERRUPT-ACCT-IND))                       
                                                AS INTERRUPT_ACCT_IND   
                    ,:S-ALLOWED-BLOCKS          AS ALLOWED_BLOCKS       
                    ,LTRIM(RTRIM(:S-DSM-EXEMPT-FL))    AS DSM_EXEMPT_FL        
                    ,LTRIM(RTRIM(:S-ELGBLE-FOR-DSM-EXEMPTN))                   
                                                AS                      
                                                ELGBLE_FOR_DSM_EXEMPTN  
                    ,LTRIM(RTRIM(:S-PNDNG-SRVCE-ORDER-IND))                    
                                                AS PNDNG_SRVCE_ORDER_IND
                    ,LTRIM(RTRIM(:S-MULTI-GAS-ELEC-IND))                       
                                                AS MULTI_GAS_ELEC_IND   
                    ,LTRIM(RTRIM(:S-CURR-OPTION-CD))   AS CUR_OPTN_CD          
                    ,LTRIM(RTRIM(:S-CURR-OPTION-SHORT-DESC))                   
                                                AS CUR_OPTN_SHORT_DESC  
                    ,LTRIM(RTRIM(:S-CURR-OPTION-LONG-DESC))                    
                                                AS CUR_OPTN_LONG_DESC   
                    ,:S-CURR-OPTION-CSC-AMT     AS CUR_OPTN_CSC_AMT     
                    ,:S-CURR-OPTION-THERM-PRICE                         
                                                AS CUR_OPTN_THERM_PRICE 
                    ,LTRIM(RTRIM(:S-CURR-OPTION-STATUS-CD))                    
                                                AS CUR_OPTN_STATUS_CD   
                    ,LTRIM(RTRIM(:S-PEND-OPTION-CD))   AS PND_OPTN_CD          
                    ,LTRIM(RTRIM(:S-PEND-OPTION-SHORT-DESC))                   
                                                AS PND_OPTN_SHORT_DESC  
                    ,LTRIM(RTRIM(:S-PEND-OPTION-LONG-DESC))                    
                                                AS PND_OPTN_LONG_DESC   
                    ,:S-PEND-OPTION-CSC-AMT     AS PND_OPTN_CSC_AMT     
                    ,:S-PEND-OPTION-THERM-PRICE AS PND_OPTN_THERM_PRICE 
                    ,LTRIM(RTRIM(:S-PEND-OPTION-FL))   AS PND_OPTN_FL          
                    ,LTRIM(RTRIM(:S-SUBDVSN-LIGHT-IND))                        
                                                AS SUBDVSN_LIGHT_IND    
                    ,LTRIM(RTRIM(:S-ACCT-ON-BANK-DRAFT))                       
                                                AS ACCT_ON_BANK_DRAFT   
                    ,LTRIM(RTRIM(:S-LAST-DRAFT-DATE))  AS 
           LAST_DRAFT_DATE      
                    ,LTRIM(RTRIM(:S-DRAFT-CYCLE))      AS DRAFT_CYCLE          
                    ,LTRIM(RTRIM(:S-PNDG-DRAFT-DATE))  AS 
           PNDG_DRAFT_DATE      
                    ,LTRIM(RTRIM(:S-BILL-CYCLE))       AS 
           ACCT_BILL_CYCLE      
                    ,LTRIM(RTRIM(:S-CODE-ACCT-STAT))   AS CODE_ACCT_STAT       
                    ,LTRIM(RTRIM(:S-ACCOUNT-TYPE-CODE))                        
                                                AS ACCOUNT_TYPE_CODE    
                    ,LTRIM(RTRIM(:S-MST-DEP-REL-EXISTS))                       
                                                AS MST_DEP_REL_EXISTS   
                    ,LTRIM(RTRIM(:S-UNMTR-RATE-MAINTABLE))                     
                                                AS UNMTR_RATE_MAINTABLE 
                    ,LTRIM(RTRIM(:S-RATE-64-UPDT-FL))  AS 
           RATE_64_UPDT_FL      
P00892              ,LTRIM(RTRIM(:S-CURR-AUTO-REN-OPT-IN-FL)) AS               
P00892                                           CURR_AUTO_REN_OPT_IN_FL
P00892              ,LTRIM(RTRIM(:S-PEND-AUTO-REN-OPT-IN-FL)) AS               
P00892                                           PEND_AUTO_REN_OPT_IN_FL
OTPOOL              ,LTRIM(RTRIM(:S-TIER-ACCT-TYPE-CD))       AS               
OTPOOL                                           TIER_ACCT_TYPE_CD      
OTPOOL              ,LTRIM(RTRIM(:S-OUTER-POOL-FL))           AS               
OTPOOL                                           OUTER_POOL_FL          
P01137              ,LTRIM(RTRIM(:S-PEND-OPT-CALC-TYPE-CD))   AS               
P01137                                           PEND_OPT_CALC_TYPE_CD  
P01137              ,LTRIM(RTRIM(:S-CURR-OPT-CALC-TYPE-CD))   AS               
P01137                                           CURR_OPT_CALC_TYPE_CD  
P01137              ,LTRIM(RTRIM(:S-OPT-AGRMT-EFF-DT))        AS               
P01137                                           OPT_AGRMT_EFF_DT       
P01137              ,LTRIM(RTRIM(:S-OPT-AGRMT-EFF-TM))        AS               
P01137                                           OPT_AGRMT_EFF_TM       
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*       SELECT :S-RETURN-CODE             AS RETURN_CODE                  
MFA-TR*             ,:S-APPL-RETURN-CODE        AS APPL_RETURN_CODE             
MFA-TR*             ,STRIP(:S-CODE-UTIL-TYPE)   AS CODE_UTIL_TYPE               
MFA-TR*             ,:S-IC-NO                   AS IC_NO                        
MFA-TR*             ,STRIP(:S-RATE-PLAN-NO)     AS RATE_PLAN_NO                 
MFA-TR*             ,STRIP(:S-ACTV-UNMTR-PLN-EXIST)                             
MFA-TR*                                         AS ACTV_UNMTR_PLN_EXIST         
MFA-TR*             ,:S-ACTIVE-METERS-CNT       AS ACTIVE_METERS_CNT            
MFA-TR*             ,STRIP(:S-BASE-USE-IND)     AS BASE_USE_IND                 
MFA-TR*             ,STRIP(:S-INDUS-GAS-CUST)   AS INDUS_GAS_CUST               
MFA-TR*             ,STRIP(:S-FIXED-FACTORS-IND)                                
MFA-TR*                                         AS FIXED_FACTORS_IND            
MFA-TR*             ,STRIP(:S-BILL-CONTRACT-IND)                                
MFA-TR*                                         AS BILL_CONTRACT_IND            
MFA-TR*             ,STRIP(:S-INTERRUPT-ACCT-IND)                               
MFA-TR*                                         AS INTERRUPT_ACCT_IND           
MFA-TR*             ,:S-ALLOWED-BLOCKS          AS ALLOWED_BLOCKS               
MFA-TR*             ,STRIP(:S-DSM-EXEMPT-FL)    AS DSM_EXEMPT_FL                
MFA-TR*             ,STRIP(:S-ELGBLE-FOR-DSM-EXEMPTN)                           
MFA-TR*                                         AS                              
MFA-TR*                                         ELGBLE_FOR_DSM_EXEMPTN          
MFA-TR*             ,STRIP(:S-PNDNG-SRVCE-ORDER-IND)                            
MFA-TR*                                         AS PNDNG_SRVCE_ORDER_IND        
MFA-TR*             ,STRIP(:S-MULTI-GAS-ELEC-IND)                               
MFA-TR*                                         AS MULTI_GAS_ELEC_IND           
MFA-TR*             ,STRIP(:S-CURR-OPTION-CD)   AS CUR_OPTN_CD                  
MFA-TR*             ,STRIP(:S-CURR-OPTION-SHORT-DESC)                           
MFA-TR*                                         AS CUR_OPTN_SHORT_DESC  C       
MFA-TR*             ,STRIP(:S-CURR-OPTION-LONG-DESC)                            
MFA-TR*                                         AS CUR_OPTN_LONG_DESC           
MFA-TR*             ,:S-CURR-OPTION-CSC-AMT     AS CUR_OPTN_CSC_AMT             
MFA-TR*             ,:S-CURR-OPTION-THERM-PRICE                                 
MFA-TR*                                         AS CUR_OPTN_THERM_PRICE         
MFA-TR*             ,STRIP(:S-CURR-OPTION-STATUS-CD)                            
MFA-TR*                                         AS CUR_OPTN_STATUS_CD           
MFA-TR*             ,STRIP(:S-PEND-OPTION-CD)   AS PND_OPTN_CD                  
MFA-TR*             ,STRIP(:S-PEND-OPTION-SHORT-DESC)                           
MFA-TR*                                         AS PND_OPTN_SHORT_DESC          
MFA-TR*             ,STRIP(:S-PEND-OPTION-LONG-DESC)                            
MFA-TR*                                         AS PND_OPTN_LONG_DESC           
MFA-TR*             ,:S-PEND-OPTION-CSC-AMT     AS PND_OPTN_CSC_AMT             
MFA-TR*             ,:S-PEND-OPTION-THERM-PRICE AS PND_OPTN_THERM_PRICE         
MFA-TR*             ,STRIP(:S-PEND-OPTION-FL)   AS PND_OPTN_FL                  
MFA-TR*             ,STRIP(:S-SUBDVSN-LIGHT-IND)                                
MFA-TR*                                         AS SUBDVSN_LIGHT_IND            
MFA-TR*             ,STRIP(:S-ACCT-ON-BANK-DRAFT)                               
MFA-TR*                                         AS ACCT_ON_BANK_DRAFT           
MFA-TR*             ,STRIP(:S-LAST-DRAFT-DATE)  AS LAST_DRAFT_DATE              
MFA-TR*             ,STRIP(:S-DRAFT-CYCLE)      AS DRAFT_CYCLE                  
MFA-TR*             ,STRIP(:S-PNDG-DRAFT-DATE)  AS PNDG_DRAFT_DATE              
MFA-TR*             ,STRIP(:S-BILL-CYCLE)       AS ACCT_BILL_CYCLE              
MFA-TR*             ,STRIP(:S-CODE-ACCT-STAT)   AS CODE_ACCT_STAT               
MFA-TR*             ,STRIP(:S-ACCOUNT-TYPE-CODE)                                
MFA-TR*                                         AS ACCOUNT_TYPE_CODE            
MFA-TR*             ,STRIP(:S-MST-DEP-REL-EXISTS)                               
MFA-TR*                                         AS MST_DEP_REL_EXISTS           
MFA-TR*             ,STRIP(:S-UNMTR-RATE-MAINTABLE)                             
MFA-TR*                                         AS UNMTR_RATE_MAINTABLE         
MFA-TR*             ,STRIP(:S-RATE-64-UPDT-FL)  AS RATE_64_UPDT_FL              
MFA-TR*             ,STRIP(:S-CURR-AUTO-REN-OPT-IN-FL) AS                       
MFA-TR*                                          CURR_AUTO_REN_OPT_IN_FL        
MFA-TR*             ,STRIP(:S-PEND-AUTO-REN-OPT-IN-FL) AS                       
MFA-TR*                                          PEND_AUTO_REN_OPT_IN_FL        
MFA-TR*             ,STRIP(:S-TIER-ACCT-TYPE-CD)       AS                       
MFA-TR*                                          TIER_ACCT_TYPE_CD              
MFA-TR*             ,STRIP(:S-OUTER-POOL-FL)           AS                       
MFA-TR*                                          OUTER_POOL_FL                  
MFA-TR*             ,STRIP(:S-PEND-OPT-CALC-TYPE-CD)   AS                       
MFA-TR*                                          PEND_OPT_CALC_TYPE_CD          
MFA-TR*             ,STRIP(:S-CURR-OPT-CALC-TYPE-CD)   AS                       
MFA-TR*                                          CURR_OPT_CALC_TYPE_CD          
MFA-TR*             ,STRIP(:S-OPT-AGRMT-EFF-DT)        AS                       
MFA-TR*                                          OPT_AGRMT_EFF_DT               
MFA-TR*             ,STRIP(:S-OPT-AGRMT-EFF-TM)        AS                       
MFA-TR*                                          OPT_AGRMT_EFF_TM               
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-ACCOUNT-NO             TO UT-ACCOUNT-NO            
                                               AT-ACCOUNT-NO            
                                               CP-ACCOUNT-NO            
                                               FF-ACCOUNT-NO            
                                               IP-ACCOUNT-NO            
                                               MN-ACCOUNT-NO            
                                               BK-ACCOUNT-NO            
                                               DF-ACCOUNT-NO            
OTPOOL                                         DD-ACCOUNT-NO            
                                               BE-ACCOUNT-NO            
                                               PB-ACCOUNT-NO            
                                               WS-ACCOUNT-NO-063        
                                               FF-ACCOUNT-NO            
                                               UR-ACCOUNT-NO-MST        
                                               UR-ACCOUNT-NO-DEP.       
                                                                        
           MOVE PARM-CODE-UTIL-TYPE         TO CP-CODE-UTIL-TYPE        
                                               J1-CODE-UTIL-TYPE        
                                               FF-CODE-UTIL-TYPE        
                                               IP-CODE-UTIL-TYPE        
                                               MN-CODE-UTIL-TYPE        
                                               BK-CODE-UTIL-TYPE        
                                               DF-CODE-UTIL-TYPE        
                                               RD-CODE-UTIL-TYPE        
                                               PS-CODE-UTIL-TYPE        
                                               FF-CODE-UTIL-TYPE        
                                               SA-CODE-UTIL-TYPE        
                                               WS-CODE-UTIL-TYPE-063    
                                               WS-CODE-VALUE-UTL-TYP    
                                               UT-CODE-UTIL-TYPE        
                                               S-CODE-UTIL-TYPE         
                                               UR-CODE-UTIL-TYPE-MST    
                                               UR-CODE-UTIL-TYPE-DEP.   
           IF PARM-IC-NO EQUAL 0 THEN                                   
              PERFORM 7010-SELECT-MAX-IC-NO    THRU 7010-EXIT           
              ADD +1                        TO UT-IC-NO                 
              MOVE UT-IC-NO                 TO PARM-IC-NO               
              MOVE SPACES                   TO UT-RATE-PLAN-NO          
           ELSE                                                         
              MOVE PARM-IC-NO               TO UT-IC-NO                 
              MOVE SPACES                   TO UT-RATE-PLAN-NO          
              PERFORM 7000-GET-RATE-PLAN       THRU 7000-EXIT           
           END-IF                                                       
                                                                        
           MOVE PARM-IC-NO                  TO CP-IC-NO                 
                                               IP-IC-NO                 
                                               UT-IC-NO                 
                                               FF-IC-NO                 
                                               MN-IC-NO                 
                                               BK-IC-NO                 
                                               DF-IC-NO                 
                                               WS-IC-NO-063             
                                               S-IC-NO                  
                                               UR-IC-NO-MST             
                                               UR-IC-NO-DEP.            
                                                                        
           MOVE WS-ZERO                     TO WS-DATABASE.             
           MOVE 'DATABASE'                  TO C8-DELINQ-CD.            
           MOVE '01'                        TO C8-COMPANY-NO            
           PERFORM 7050-GET-DELINQUENCY-VALUE    THRU 7050-EXIT.        
           MOVE C8-DELINQ-VALUE             TO WS-DATABASE.             
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2050-INITIALIZE-OUTPUT        THRU 2050-EXIT.        
           PERFORM 2100-BUILD-RESULT-SET         THRU 2100-EXIT.        
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2050-INITIALIZE-OUTPUT.                                        *        
      ******************************************************************        
       2050-INITIALIZE-OUTPUT.                                          
                                                                        
           MOVE WS-YES                      TO S-UNMTR-RATE-MAINTABLE   
                                                                        
           MOVE WS-NO                       TO S-ACTV-UNMTR-PLN-EXIST   
                                               S-BASE-USE-IND           
                                               S-INDUS-GAS-CUST         
                                               S-FIXED-FACTORS-IND      
                                               S-BILL-CONTRACT-IND      
                                               S-INTERRUPT-ACCT-IND     
                                               S-DSM-EXEMPT-FL          
                                               S-ELGBLE-FOR-DSM-EXEMPTN 
                                               S-PNDNG-SRVCE-ORDER-IND  
                                               S-MULTI-GAS-ELEC-IND     
                                               S-MULTI-GAS-ELEC-IND     
                                               S-SUBDVSN-LIGHT-IND      
                                               S-PEND-OPTION-FL.        
                                                                        
           MOVE SPACES                      TO S-CURR-OPTION-CD         
                                               S-CURR-OPTION-SHORT-DESC 
                                               S-CURR-OPTION-LONG-DESC  
                                               S-CURR-OPTION-STATUS-CD  
                                               S-PEND-OPTION-CD         
                                               S-PEND-OPTION-SHORT-DESC 
                                               S-PEND-OPTION-LONG-DESC  
P00892                                         S-CURR-AUTO-REN-OPT-IN-FL
P00892                                         S-PEND-AUTO-REN-OPT-IN-FL
OTPOOL                                         S-TIER-ACCT-TYPE-CD.     
OTPOOL     MOVE 'N'                         TO S-OUTER-POOL-FL.         
                                                                        
           MOVE WS-ZERO                     TO S-ACTIVE-METERS-CNT      
                                               S-ALLOWED-BLOCKS         
                                               S-CURR-OPTION-CSC-AMT    
                                               S-CURR-OPTION-THERM-PRICE
                                               S-PEND-OPTION-THERM-PRICE
                                               S-PEND-OPTION-CSC-AMT.   
       2050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2100-BUILD-RESULT-SET.                                         *        
      ******************************************************************        
       2100-BUILD-RESULT-SET.                                           
                                                                        
                                                                        
           MOVE UT-RATE-PLAN-NO              TO J1-RATE-PLAN-NO         
                                                RD-RATE-PLAN-NO         
                                                PS-RATE-PLAN-NO         
                                                SA-RATE-PLAN-NO         
                                                WS-CODE-VALUE-RATE-PLAN 
                                                S-RATE-PLAN-NO.         
                                                                        
                                                                        
           PERFORM 2300-DETERMINE-FLAGS          THRU 2300-EXIT.        
           PERFORM 8100-SEND-RESULT              THRU 8100-EXIT.        
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2300-DETERMINE-FLAGS.                                          *        
      ******************************************************************        
       2300-DETERMINE-FLAGS.                                            
                                                                        
                                                                        
      *    GET MASTER DEPENDENT RELATION EXIST FLAG                             
           PERFORM 7030-CHECK-FOR-MST            THRU 7030-EXIT.        
           PERFORM 7040-CHECK-FOR-DEP            THRU 7040-EXIT.        
      *                                                                         
           IF WS-CHECK-FOR-MST = 'Y' OR WS-CHECK-FOR-DEP = 'Y'          
              MOVE WS-YES                     TO S-MST-DEP-REL-EXISTS   
           END-IF.                                                      
      *    Get Account Details                                                  
           PERFORM 7045-GET-ACCT-DETAILS         THRU 7045-EXIT.        
           MOVE AT-COMPANY-NO                 TO UT-COMPANY-NO.         
           MOVE AT-BILL-CYCLE                 TO S-BILL-CYCLE.          
           MOVE AT-CODE-ACCT-STAT             TO S-CODE-ACCT-STAT.      
           MOVE AT-ACCOUNT-TYPE-CODE          TO S-ACCOUNT-TYPE-CODE.   
           MOVE AT-PREMISE-NO                 TO PR-PREMISE-NO.         
                                                                        
OTPOOL     IF SEB-DATABASE                                              
OTPOOL        IF B1-DIVISION-NO = 'OUT'                                 
OTPOOL           MOVE 'Y'                     TO S-OUTER-POOL-FL        
OTPOOL        END-IF                                                    
OTPOOL        PERFORM 7270-GET-ACCT-MKT-TIER     THRU 7270-EXIT         
OTPOOL        IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
OTPOOL           MOVE DD-TIER-ACCT-TYPE-CD    TO S-TIER-ACCT-TYPE-CD    
OTPOOL        END-IF                                                    
OTPOOL     END-IF.                                                      
                                                                        
      *    Get pending service order indicator.                                 
           IF PR-PREMISE-NO NOT EQUAL WS-PREV-PREMISE-NO                
              MOVE PR-PREMISE-NO              TO WS-PREV-PREMISE-NO     
              PERFORM 7120-GET-SERV-ORDER-PEND   THRU 7120-EXIT         
              IF PR-SERV-ORDER-PEND EQUAL WS-SERV-ORDER-IS-PNDNG        
                 MOVE WS-YES                  TO S-PNDNG-SRVCE-ORDER-IND
              END-IF                                                    
           END-IF.                                                      
                                                                        
           PERFORM 7100-CHECK-ACTIVE-PLANS       THRU 7100-EXIT.        
      *    GET MULTIPLE GAS AND ELECTRIC INDICATOR                              
           PERFORM 7110-MULT-GAS-ELEC-ICPS       THRU 7110-EXIT.        
      *                                                                         
           PERFORM 7130-GET-ACTV-METER-CNT       THRU 7130-EXIT.        
           PERFORM 7140-CHECK-BASE-USE-IND       THRU 7140-EXIT.        
           PERFORM 7150-CHECK-INDUS-GAS-CUST     THRU 7150-EXIT.        
           PERFORM 7180-GET-FIXED-FCTR-FL        THRU 7180-EXIT.        
           PERFORM 7190-GET-BILL-CONTRACT-IND    THRU 7190-EXIT.        
           PERFORM 7195-GET-INTRRPT-ACCT         THRU 7195-EXIT.        
      *                                                                         
      *    Get the Rate is Maintenable flag                                     
           PERFORM 2410-GET-RATE-MAINTENABLE-FL  THRU 2410-EXIT.        
      *                                                                         
      *    Get the Rate is updateable flag                                      
           PERFORM 2420-GET-RATE-UPDATEABLE      THRU 2420-EXIT.        
      *                                                                         
      *    Get the Sub Division Flag if Light Exists                            
           PERFORM 7200-DETERMINE-SUBDVSN-LIGHT  THRU 7200-EXIT.        
           MOVE    WS-SUBDVSN-LIGHT-FL          TO  S-SUBDVSN-LIGHT-IND.
      *                                                                         
      *    Get Pending and Last Draft                                           
           PERFORM 7280-DETERMINE-BANK-DRAFT   THRU 7280-EXIT           
                                                                        
           IF WS-NULL-LAST-DRAFT-DATE = -1                              
              MOVE SPACES                      TO S-LAST-DRAFT-DATE     
           ELSE                                                         
              MOVE BE-LAST-DRAFT-DATE          TO S-LAST-DRAFT-DATE     
           END-IF                                                       
                                                                        
           MOVE BE-DRAFT-CYCLE                 TO S-DRAFT-CYCLE         
                                                                        
           PERFORM 7290-GET-PNDNG-DRAFT-DATE   THRU 7290-EXIT           
                                                                        
           MOVE PB-DRAFT-DATE                  TO S-PNDG-DRAFT-DATE     
                                                                        
      *    Get the maximum number of blocks allowed for fixed factors.          
           MOVE SPACES                         TO RD-SECURED-RATE-FL.   
           PERFORM 7210-GET-SECURED-RATE-FL      THRU 7210-EXIT.        
           IF CSR-DATABASE AND (RD-SECURED-RATE-FL EQUAL WS-YES)        
              MOVE WS-NINE                  TO S-ALLOWED-BLOCKS         
           ELSE                                                         
              MOVE WS-ZERO                  TO WS-BLOCK-NULL-ID         
                                                 PS-BLOCK-NO            
              PERFORM 7220-GET-ALLOWED-BLOCK-NO  THRU 7220-EXIT         
              MOVE PS-BLOCK-NO              TO S-ALLOWED-BLOCKS         
           END-IF.                                                      
                                                                        
      *    Get current DSM Exempt fl & elgible for DSM exempt.                  
           IF FF-CODE-UTIL-TYPE EQUAL WS-ELECTRIC                       
              PERFORM 7230-GET-DSM-CREDIT-FL     THRU 7230-EXIT         
              PERFORM 7240-GET-SPCL-FCTR-FL      THRU 7240-EXIT         
           END-IF.                                                      
PRJ137     MOVE '0001-01-01'                     TO S-OPT-AGRMT-EFF-DT  
PRJ137     MOVE '00.00.00'                       TO S-OPT-AGRMT-EFF-TM  
      *    GET CURRENT,PENDING OPTION AND ITS DESC.                             
           IF SEB-DATABASE                                              
              INITIALIZE          FI-OPT-DESC-INT-LONG                  
ACT167                            FI-OPT-DESC-INT                       
      *                                                                         
              PERFORM 7250-GET-CURR-RATE-PKG-OPTN   THRU 7250-EXIT      
                                                                        
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
P01137           MOVE DF-OPT-AGRMT-EFF-DT        TO S-OPT-AGRMT-EFF-DT  
P01137           MOVE DF-OPT-AGRMT-EFF-TM        TO S-OPT-AGRMT-EFF-TM  
I02262           IF RD-RATE-DEFINITION-CD EQUAL '2'                     
I02262              PERFORM 7245-GET-CORE-RATE-DDDC THRU 7245-EXIT      
I02262              MOVE SA-FACTOR               TO WS-CORE-RATE-DDDC   
I02262           END-IF                                                 
                 PERFORM 2400-PROCESS-CURR-RTPK-OPTN                    
                                                    THRU 2400-EXIT      
                 IF WS-PEND063-OPT-EXIST-FL = WS-YES                    
                    PERFORM 2500-PROCESS-PEND-RTPK-OPTN                 
                                                    THRU 2500-EXIT      
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2400-PROCESS-CURR-RTPK-OPTN.                                   *        
      ******************************************************************        
       2400-PROCESS-CURR-RTPK-OPTN.                                     
      *                                                                         
                                                                        
           MOVE DF-OPTION-CD                TO S-CURR-OPTION-CD         
                                               WS-OPTION-CD.            
           MOVE WS-YES                      TO WS-THERM-CSC-ACCT-FL     
                                               WS-PENDING-OPTION-FL-063.
      * GET THERM-PRICE AND CSC AMOUNT FOR CURRENT OPTION                       
           PERFORM 6000-CALL-MCSCB063         THRU 6000-EXIT.           
      *                                                                         
           MOVE WS-PEND063-THERM-PRICE      TO S-PEND-OPTION-THERM-PRICE
           MOVE WS-PEND063-CSC-AMT          TO S-PEND-OPTION-CSC-AMT.   
           MOVE WS-CSC-AMT                  TO S-CURR-OPTION-CSC-AMT.   
      *                                                                         
           IF WS-FF-DURATION-REM EQUAL ZEROES                           
                            AND WS-RATE-CALC-TYPE-CD EQUAL '02'         
              MOVE DF-OPTION-CD             TO HQ-OPTION-CD             
              MOVE DF-RT-PKG-OPT-SEQ-NO     TO FF-RT-PKG-OPT-SEQ-NO     
      *                                                                         
              PERFORM 7251-SEL-THERM-PRICE    THRU 7251-EXIT            
      *                                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                 MOVE FF-FACTOR             TO S-CURR-OPTION-THERM-PRICE
                 MOVE FF-FACTOR-ID          TO SF-FACTOR-ID             
                 MOVE 0                     TO SF-FCTR-POWER-10         
      *                                                                         
                 PERFORM 7252-SELECT-FCTR-POWER                         
                                              THRU 7252-EXIT            
                 IF SF-FCTR-POWER-10  NOT EQUAL 0                       
                    COMPUTE WS-FACTOR-FF = FF-FACTOR *                  
                                      10** SF-FCTR-POWER-10             
                    MOVE WS-FACTOR-FF       TO S-CURR-OPTION-THERM-PRICE
                 END-IF                                                 
              END-IF                                                    
           ELSE                                                         
              MOVE WS-THERM-PRICE           TO S-CURR-OPTION-THERM-PRICE
           END-IF.                                                      
      *                                                                         
           MOVE DF-STATUS-CD                TO S-CURR-OPTION-STATUS-CD. 
      *                                                                         
I02262     IF RD-RATE-DEFINITION-CD EQUAL '2'                           
I02262        IF WS-CORE-RATE-DDDC (1:1) EQUAL ' '                      
I02262           STRING FI-OPT-DESC-INT-LONG-TEXT                       
I02262                  ' ('                                            
I02262                  WS-CORE-RATE-DDDC (2:4)                         
I02262                  ' X DDDC)'                                      
I02262                  DELIMITED BY '  '                               
I02262             INTO S-CURR-OPTION-LONG-DESC                         
I02262           END-STRING                                             
I02262        ELSE                                                      
I02262           STRING FI-OPT-DESC-INT-LONG-TEXT                       
I02262                  ' ('                                            
I02262                  WS-CORE-RATE-DDDC                               
I02262                  ' X DDDC)'                                      
I02262                  DELIMITED BY '  '                               
I02262             INTO S-CURR-OPTION-LONG-DESC                         
I02262           END-STRING                                             
I02262        END-IF                                                    
I02262     ELSE                                                         
              MOVE FI-OPT-DESC-INT-LONG-TEXT                            
                                            TO S-CURR-OPTION-LONG-DESC  
I02262     END-IF.                                                      
      *                                                                         
           MOVE FI-OPT-DESC-INT             TO S-CURR-OPTION-SHORT-DESC.
P00892     MOVE DF-AUTO-REN-OPT-IN-FL       TO S-CURR-AUTO-REN-OPT-IN-FL
P01137     MOVE FI-OPT-CALC-TYPE-CD         TO S-CURR-OPT-CALC-TYPE-CD. 
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2410-GET-RATE-MAINTENABLE-FL                                   *        
      ******************************************************************        
       2410-GET-RATE-MAINTENABLE-FL.                                    
      *                                                                         
           MOVE WS-CODE-VALUE               TO UV-CODE-VALUE.           
           MOVE 'CSR04649'                  TO UV-PROGRAM-ID.           
           MOVE 16                          TO UV-COLUMN-NA-LEN.        
           MOVE 'UI_VIEW_MAINTAIN'          TO UV-COLUMN-NA-TEXT.       
           MOVE 14                          TO UV-TABLE-NA-LEN.         
           MOVE 'CSS_UNMTR_PLAN'            TO UV-TABLE-NA-TEXT.        
                                                                        
           PERFORM 7300-GET-CODE-VALUE         THRU 7300-EXIT           
                                                                        
           MOVE UV-CODE-SHORT-DESC-TEXT        TO                       
                                                WS-CODE-SHORT-DESC-TEXT.
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
      * if code value disable unmtrd view is 'Y' then mainteable is 'N'         
              IF WS-CODE-SHORT-DESC-TXT = 'N' THEN                      
                 MOVE WS-YES                   TO S-UNMTR-RATE-MAINTABLE
              ELSE                                                      
                 MOVE WS-NO                    TO S-UNMTR-RATE-MAINTABLE
              END-IF                                                    
           ELSE                                                         
      * By Default Rates are mainteable                                         
              MOVE WS-YES                      TO S-UNMTR-RATE-MAINTABLE
           END-IF.                                                      
                                                                        
      *                                                                         
       2410-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2420-GET-RATE-UPDATEABLE                                       *        
      ******************************************************************        
       2420-GET-RATE-UPDATEABLE.                                        
      *                                                                         
           MOVE 'N'                         TO S-RATE-64-UPDT-FL.       
           MOVE 'CSR04649'                  TO G6-PROGRAM-NAME.         
           MOVE '01'                        TO G6-COMPANY-NO.           
           MOVE 'PARM'                      TO G6-CMND-CODE.            
           MOVE 'A'                         TO G6-STATUS.               
           MOVE 01                          TO G6-SEQ-NO.               
                                                                        
           PERFORM 7400-SELECT-JOB-PARM           THRU 7400-EXIT.       
                                                                        
           MOVE G6-PARM-DATA(1:13)          TO WS-G6-PARM-ACCOUNT-NO.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL AND               
              WS-G6-PARM-ACCOUNT-NO = UT-ACCOUNT-NO                     
              MOVE 'Y'                      TO S-RATE-64-UPDT-FL        
           END-IF.                                                      
      *                                                                         
       2420-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2500-PROCESS-PEND-RTPK-OPTN.                                   *        
      ******************************************************************        
       2500-PROCESS-PEND-RTPK-OPTN.                                     
      *                                                                         
           MOVE SPACES                      TO DF-OPTION-CD             
ACT167                                         FI-OPT-DESC-INT-LONG-TEXT
ACT167                                         FI-OPT-DESC-INT          
ACT167                                         DF-AUTO-REN-OPT-IN-FL.   
                                                                        
           PERFORM 7260-GET-PEND-RATE-PKG-OPTN THRU 7260-EXIT.          
                                                                        
I02262     IF RD-RATE-DEFINITION-CD EQUAL '2'                           
I02262        MOVE FI-RATE-PLAN-NO          TO SA-RATE-PLAN-NO          
I02262        PERFORM 7245-GET-CORE-RATE-DDDC  THRU 7245-EXIT           
I02262        MOVE SA-FACTOR                TO WS-CORE-RATE-DDDC        
I02262     END-IF                                                       
                                                                        
           MOVE WS-YES                      TO S-PEND-OPTION-FL.        
           MOVE DF-OPTION-CD                TO S-PEND-OPTION-CD.        
                                                                        
I02262     IF RD-RATE-DEFINITION-CD EQUAL '2'                           
I02262        IF WS-CORE-RATE-DDDC (1:1) EQUAL ' '                      
I02262           STRING FI-OPT-DESC-INT-LONG-TEXT                       
I02262                  ' ('                                            
I02262                  WS-CORE-RATE-DDDC (2:4)                         
I02262                  ' X DDDC)'                                      
I02262                  DELIMITED BY '  '                               
I02262             INTO S-PEND-OPTION-LONG-DESC                         
I02262           END-STRING                                             
I02262        ELSE                                                      
I02262           STRING FI-OPT-DESC-INT-LONG-TEXT                       
I02262                  ' ('                                            
I02262                  WS-CORE-RATE-DDDC                               
I02262                  ' X DDDC)'                                      
I02262                  DELIMITED BY '  '                               
I02262             INTO S-PEND-OPTION-LONG-DESC                         
I02262           END-STRING                                             
I02262        END-IF                                                    
I02262     ELSE                                                         
              MOVE FI-OPT-DESC-INT-LONG-TEXT                            
                                            TO S-PEND-OPTION-LONG-DESC  
I02262     END-IF.                                                      
                                                                        
           MOVE FI-OPT-DESC-INT             TO S-PEND-OPTION-SHORT-DESC.
P00892     MOVE DF-AUTO-REN-OPT-IN-FL       TO S-PEND-AUTO-REN-OPT-IN-FL
P01137     MOVE FI-OPT-CALC-TYPE-CD         TO S-PEND-OPT-CALC-TYPE-CD. 
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 6000-CALL-MCSCB063.                                           *         
      *****************************************************************         
       6000-CALL-MCSCB063.                                              
                                                                        
           CALL WS-MCSCB063 USING CWS00063-FIELDS,                      
                              ,ABEND-FILE,                              
                              ,WS-MCSCB063-RET-CODE.                    
                                                                        
           MOVE WS-MCSCB063-RET-CODE        TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '6000'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CALL'                   TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'MCSCB063'               TO TABLE-1                  
              MOVE 'WS-OPTION-CD'           TO TABLE-ELEMENT-1          
              MOVE 'WS-PENDING-OPTION-FL-063'                           
                                            TO TABLE-ELEMENT-2          
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
      *                                                                         
       6000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7000-GET-RATE-PLAN.                                            *        
      ******************************************************************        
       7000-GET-RATE-PLAN.                                              
                                                                        
           EXEC SQL                                                     
               SELECT UT.RATE_PLAN_NO                                   
                 INTO :UT-RATE-PLAN-NO                                  
                 FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                 
                WHERE UT.ACCOUNT_NO         = :UT-ACCOUNT-NO            
                  AND UT.CODE_UTIL_TYPE     = :UT-CODE-UTIL-TYPE        
                  AND UT.IC_NO              = :UT-IC-NO                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT UT.RATE_PLAN_NO                                           
MFA-TR*          INTO :UT-RATE-PLAN-NO                                          
MFA-TR*          FROM CSS_UTIL_ENVRNMT UT                                       
MFA-TR*         WHERE UT.ACCOUNT_NO         = :UT-ACCOUNT-NO                    
MFA-TR*           AND UT.CODE_UTIL_TYPE     = :UT-CODE-UTIL-TYPE                
MFA-TR*           AND UT.IC_NO              = :UT-IC-NO                         
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7000                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7000'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_UTIL_ENVRNMT'       TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE UT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE UT-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE UT-IC-NO                 TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7010-SELECT-MAX-IC-NO.                                         *        
      *     1. SELECT THE MAXIMUM IC NUMBER FOR A GIVEN ACCOUNT NUMBER *        
      *        AND UTILITY TYPE IN ORDER TO CALCULATE THE NEXT IC NO.  *        
      ******************************************************************        
       7010-SELECT-MAX-IC-NO.                                           
                                                                        
           EXEC SQL                                                     
              SELECT MAX(IC_NO)                                         
                INTO :UT-IC-NO :WS-NULL-IND-1                            
                FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                     
               WHERE ACCOUNT_NO     = :UT-ACCOUNT-NO                    
                 AND CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MAX(IC_NO)                                                 
MFA-TR*         INTO :UT-IC-NO:WS-NULL-IND-1                                    
MFA-TR*         FROM CSS_UTIL_ENVRNMT                                           
MFA-TR*        WHERE ACCOUNT_NO     = :UT-ACCOUNT-NO                            
MFA-TR*          AND CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE                        
MFA-TR*        WITH UR                                                          
MFA-TR*       QUERYNO 7010                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7010'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_UTIL_ENVRNMT'    TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE UT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2             
              MOVE UT-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7030-CHECK-FOR-MST.                                                     
      *                                                                         
      *    CHECK IF THE ACCOUNT HAS ANY MASTER ACCOUNTS.                        
      *                                                                         
      *****************************************************************         
       7030-CHECK-FOR-MST.                                              
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-CHECK-FOR-MST                                  
                FROM CSS_UTL_BILL_REL WITH(READUNCOMMITTED)                     
               WHERE ACCOUNT_NO_MST      = :UR-ACCOUNT-NO-MST           
                 AND CODE_UTIL_TYPE_MST  = :UR-CODE-UTIL-TYPE-MST       
                 AND IC_NO_MST           = :UR-IC-NO-MST                
                                                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-CHECK-FOR-MST                                          
MFA-TR*         FROM CSS_UTL_BILL_REL                                           
MFA-TR*        WHERE ACCOUNT_NO_MST      = :UR-ACCOUNT-NO-MST                   
MFA-TR*          AND CODE_UTIL_TYPE_MST  = :UR-CODE-UTIL-TYPE-MST               
MFA-TR*          AND IC_NO_MST           = :UR-IC-NO-MST                        
MFA-TR*        FETCH FIRST 1 ROW ONLY                                           
MFA-TR*        WITH UR                                                          
MFA-TR*       QUERYNO 7030                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7030'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_UTL_BILL_REL'       TO TABLE-1                  
              MOVE 'ACCOUNT_NO_MST'         TO TABLE-ELEMENT-1          
              MOVE UR-ACCOUNT-NO-MST        TO HOSTVAR-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE_MST'     TO TABLE-ELEMENT-2          
              MOVE UR-CODE-UTIL-TYPE-MST    TO HOSTVAR-ELEMENT-2        
              MOVE 'IC_NO_MST'              TO TABLE-ELEMENT-3          
              MOVE UR-IC-NO-MST             TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND           THRU 9700-EXIT       
           END-IF.                                                      
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7040-CHECK-FOR-DEP.                                                     
      *                                                                         
      *    CHECK IF THE ACCOUNT HAS ANY DEPENDENT ACCOUNTS.                     
      *                                                                         
      *****************************************************************         
       7040-CHECK-FOR-DEP.                                              
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-CHECK-FOR-DEP                                  
                FROM CSS_UTL_BILL_REL WITH(READUNCOMMITTED)                     
               WHERE ACCOUNT_NO_DEP      = :UR-ACCOUNT-NO-DEP           
                 AND CODE_UTIL_TYPE_DEP  = :UR-CODE-UTIL-TYPE-DEP       
                 AND IC_NO_DEP           = :UR-IC-NO-DEP                
                                                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-CHECK-FOR-DEP                                          
MFA-TR*         FROM CSS_UTL_BILL_REL                                           
MFA-TR*        WHERE ACCOUNT_NO_DEP      = :UR-ACCOUNT-NO-DEP                   
MFA-TR*          AND CODE_UTIL_TYPE_DEP  = :UR-CODE-UTIL-TYPE-DEP               
MFA-TR*          AND IC_NO_DEP           = :UR-IC-NO-DEP                        
MFA-TR*        FETCH FIRST 1 ROW ONLY                                           
MFA-TR*        WITH UR                                                          
MFA-TR*       QUERYNO 7040                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7040'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_UTL_BILL_REL'       TO TABLE-1                  
              MOVE 'ACCOUNT_NO_DEP'         TO TABLE-ELEMENT-1          
              MOVE UR-ACCOUNT-NO-DEP        TO HOSTVAR-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE_DEP'     TO TABLE-ELEMENT-2          
              MOVE UR-CODE-UTIL-TYPE-DEP    TO HOSTVAR-ELEMENT-2        
              MOVE 'IC_NO_DEP'              TO TABLE-ELEMENT-3          
              MOVE UR-IC-NO-DEP             TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       7040-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7045-GET-ACCT-DETAILS.                                         *        
      *                                                                *        
      ******************************************************************        
       7045-GET-ACCT-DETAILS.                                           
                                                                        
           EXEC SQL                                                     
              SELECT AT.COMPANY_NO                                      
                    ,AT.BILL_CYCLE                                      
                    ,AT.CODE_ACCT_STAT                                  
                    ,AT.ACCOUNT_TYPE_CODE                               
                    ,AT.PREMISE_NO                                      
OTPOOL              ,COALESCE(B1.DIVISION_NO,'   ')                       
                INTO :AT-COMPANY-NO                                     
                    ,:AT-BILL-CYCLE                                     
                    ,:AT-CODE-ACCT-STAT                                 
                    ,:AT-ACCOUNT-TYPE-CODE                              
                    ,:AT-PREMISE-NO                                     
OTPOOL              ,:B1-DIVISION-NO                                    
                FROM CSS_ACCOUNT      AT WITH(READUNCOMMITTED)                  
OTPOOL              ,CSS_LOCAL_OFFICE B1 WITH(READUNCOMMITTED)                  
               WHERE ACCOUNT_NO      = :AT-ACCOUNT-NO                   
OTPOOL           AND B1.LOCAL_OFFICE =  AT.LOCAL_OFFICE                 
OTPOOL           AND B1.COMPANY_NO   =  AT.COMPANY_NO                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT AT.COMPANY_NO                                              
MFA-TR*             ,AT.BILL_CYCLE                                              
MFA-TR*             ,AT.CODE_ACCT_STAT                                          
MFA-TR*             ,AT.ACCOUNT_TYPE_CODE                                       
MFA-TR*             ,AT.PREMISE_NO                                              
MFA-TR*             ,IFNULL(B1.DIVISION_NO,'   ')                               
MFA-TR*         INTO :AT-COMPANY-NO                                             
MFA-TR*             ,:AT-BILL-CYCLE                                             
MFA-TR*             ,:AT-CODE-ACCT-STAT                                         
MFA-TR*             ,:AT-ACCOUNT-TYPE-CODE                                      
MFA-TR*             ,:AT-PREMISE-NO                                             
MFA-TR*             ,:B1-DIVISION-NO                                            
MFA-TR*         FROM CSS_ACCOUNT      AT                                        
MFA-TR*             ,CSS_LOCAL_OFFICE B1                                        
MFA-TR*        WHERE ACCOUNT_NO      = :AT-ACCOUNT-NO                           
MFA-TR*          AND B1.LOCAL_OFFICE =  AT.LOCAL_OFFICE                         
MFA-TR*          AND B1.COMPANY_NO   =  AT.COMPANY_NO                           
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7045                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7045'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_ACCOUNT'              TO TABLE-1                
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-1        
              MOVE UT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       7045-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *                                                                *        
      * 7050-GET-DELINQUENCY-VALUE.                                    *        
      ******************************************************************        
       7050-GET-DELINQUENCY-VALUE.                                      
                                                                        
           EXEC SQL                                                     
              SELECT C8.DELINQ_VALUE                                    
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY C8 WITH(READUNCOMMITTED)                   
               WHERE C8.DELINQ_CD  = :C8-DELINQ-CD                      
                 AND C8.COMPANY_NO = :C8-COMPANY-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT C8.DELINQ_VALUE                                            
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY C8                                         
MFA-TR*        WHERE C8.DELINQ_CD  = :C8-DELINQ-CD                              
MFA-TR*          AND C8.COMPANY_NO = :C8-COMPANY-NO                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7050                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7050'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_DELINQUENCY'        TO TABLE-1                  
              MOVE 'DELINQ CD'              TO TABLE-ELEMENT-1          
              MOVE 'COMPANY NO'             TO TABLE-ELEMENT-2          
              MOVE C8-DELINQ-CD             TO HOSTVAR-ELEMENT-1        
              MOVE C8-COMPANY-NO            TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7100-CHECK-ACTIVE-PLANS.                                       *        
      *  CHECK IS THERE ANY UNMETERED PLANS FOR THE ACCOUNT IRRESPECTIV*        
      *  OF IC AND UTILITY IN CSS_CUST_PLAN                            *        
      ******************************************************************        
       7100-CHECK-ACTIVE-PLANS.                                         
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :S-ACTV-UNMTR-PLN-EXIST                            
                FROM CSS_CUST_PLAN CP WITH(READUNCOMMITTED)                     
               WHERE CP.ACCOUNT_NO        = :CP-ACCOUNT-NO              
                 AND CP.CODE_UTIL_TYPE    = :CP-CODE-UTIL-TYPE          
                 AND CP.IC_NO             = :CP-IC-NO                   
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :S-ACTV-UNMTR-PLN-EXIST                                    
MFA-TR*         FROM CSS_CUST_PLAN CP                                           
MFA-TR*        WHERE CP.ACCOUNT_NO        = :CP-ACCOUNT-NO                      
MFA-TR*          AND CP.CODE_UTIL_TYPE    = :CP-CODE-UTIL-TYPE                  
MFA-TR*          AND CP.IC_NO             = :CP-IC-NO                           
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7100'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_CUST_PLAN'          TO TABLE-1                  
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-1          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-2          
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-3          
              MOVE CP-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-1        
              MOVE CP-IC-NO                 TO HOSTVAR-ELEMENT-2        
              MOVE CP-ACCOUNT-NO            TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7110-GAS-ELEC-ICPS.                                           *         
      * DETERMINE IF MULTIPLE ICPS EXIST FOR A GIVEN ACCOUNT AND      *         
      * FOR BOTH GAS AND ELECTRIC .                                   *         
      *****************************************************************         
       7110-MULT-GAS-ELEC-ICPS.                                         
                                                                        
           EXEC SQL                                                     
              SELECT 'Y'                                                
                INTO :S-MULTI-GAS-ELEC-IND                              
                FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                     
               WHERE CODE_UTIL_TYPE     IN ('G','E')                    
                 AND ACCOUNT_NO         = :UT-ACCOUNT-NO                
            GROUP BY ACCOUNT_NO                                         
              HAVING COUNT(*) >= 2                                      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :S-MULTI-GAS-ELEC-IND                                      
MFA-TR*         FROM CSS_UTIL_ENVRNMT                                           
MFA-TR*        WHERE CODE_UTIL_TYPE     IN ('G','E')                            
MFA-TR*          AND ACCOUNT_NO         = :UT-ACCOUNT-NO                        
MFA-TR*     GROUP BY ACCOUNT_NO                                                 
MFA-TR*       HAVING COUNT(*) >= 2                                              
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7110                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                                      OR NOT-FOUND                      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7110'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_UTIL_ENVRNMT'       TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE UT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7120-GET-SERV-ORDER-PEND.                                      *        
      ******************************************************************        
       7120-GET-SERV-ORDER-PEND.                                        
                                                                        
           EXEC SQL                                                     
              SELECT PR.SERV_ORDER_PEND                                 
                INTO :PR-SERV-ORDER-PEND                                
                FROM CSS_PREMISE PR WITH(READUNCOMMITTED)                       
               WHERE PR.PREMISE_NO   = :PR-PREMISE-NO                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT PR.SERV_ORDER_PEND                                         
MFA-TR*         INTO :PR-SERV-ORDER-PEND                                        
MFA-TR*         FROM CSS_PREMISE PR                                             
MFA-TR*        WHERE PR.PREMISE_NO   = :PR-PREMISE-NO                           
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7120                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7500'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_PREMISE'            TO TABLE-1                  
              MOVE 'PREMISE NO'             TO TABLE-ELEMENT-1          
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-2          
              MOVE PR-PREMISE-NO            TO HOSTVAR-ELEMENT-2        
              MOVE UT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7130-GET-ACTV-METER-CNT.                                       *        
      ******************************************************************        
       7130-GET-ACTV-METER-CNT.                                         
                                                                        
           EXEC SQL                                                     
              SELECT COUNT(*)                                           
                INTO :S-ACTIVE-METERS-CNT                               
                FROM CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)                  
               WHERE MN.CODE_UTIL_TYPE    = :MN-CODE-UTIL-TYPE          
                 AND MN.IC_NO             = :MN-IC-NO                   
                 AND MN.ACCOUNT_NO        = :MN-ACCOUNT-NO              
                 AND MN.CODE_METER_STATUS IN (:WS-A, :WS-I, :WS-B)      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COUNT(*)                                                   
MFA-TR*         INTO :S-ACTIVE-METERS-CNT                                       
MFA-TR*         FROM CSS_MTRD_ENVRNMT MN                                        
MFA-TR*        WHERE MN.CODE_UTIL_TYPE    = :MN-CODE-UTIL-TYPE                  
MFA-TR*          AND MN.IC_NO             = :MN-IC-NO                           
MFA-TR*          AND MN.ACCOUNT_NO        = :MN-ACCOUNT-NO                      
MFA-TR*          AND MN.CODE_METER_STATUS IN (:WS-A, :WS-I, :WS-B)              
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7130                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7130'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_MTRD_ENVRNMT'       TO TABLE-1                  
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-1          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-2          
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-3          
              MOVE MN-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-1        
              MOVE MN-IC-NO                 TO HOSTVAR-ELEMENT-2        
              MOVE MN-ACCOUNT-NO            TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       7130-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7140-CHECK-BASE-USE-IND.                                       *        
      ******************************************************************        
       7140-CHECK-BASE-USE-IND.                                         
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :S-BASE-USE-IND                                    
                FROM CSS_RATE_COMP_DEF J1 WITH(READUNCOMMITTED)                 
               WHERE J1.CODE_UTIL_TYPE = :J1-CODE-UTIL-TYPE             
                 AND J1.RATE_PLAN_NO   = :J1-RATE-PLAN-NO               
                 AND J1.CMPNT_ID_CD    = :WS-BASIC-FIRM                 
                 AND J1.ENERGY_UNIT_CD = :WS-GAS-DEKATHERMS             
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :S-BASE-USE-IND                                            
MFA-TR*         FROM CSS_RATE_COMP_DEF J1                                       
MFA-TR*        WHERE J1.CODE_UTIL_TYPE = :J1-CODE-UTIL-TYPE                     
MFA-TR*          AND J1.RATE_PLAN_NO   = :J1-RATE-PLAN-NO                       
MFA-TR*          AND J1.CMPNT_ID_CD    = :WS-BASIC-FIRM                         
MFA-TR*          AND J1.ENERGY_UNIT_CD = :WS-GAS-DEKATHERMS                     
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7140                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7140'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_RATE_COMP_DEF'      TO TABLE-1                  
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-1          
              MOVE 'RATE PLAN NO'           TO TABLE-ELEMENT-2          
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-3          
              MOVE J1-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-1        
              MOVE J1-RATE-PLAN-NO          TO HOSTVAR-ELEMENT-2        
              MOVE UT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       7140-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7150-CHECK-INDUS-GAS-CUST.                                     *        
      ******************************************************************        
       7150-CHECK-INDUS-GAS-CUST.                                       
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :S-INDUS-GAS-CUST                                  
                FROM CSS_RATE_COMP_DEF J1 WITH(READUNCOMMITTED)                 
               WHERE J1.RATE_PLAN_NO   = :J1-RATE-PLAN-NO               
                 AND J1.REG_TYPE_CD    = 'D'                            
                 AND J1.CODE_UTIL_TYPE = :J1-CODE-UTIL-TYPE             
                 AND J1.VERSION_NO_CNTRL =                              
                     (SELECT MAX(A1.VERSION_NO_CNTRL)                   
                        FROM CSS_RATE_COMP_DEF A1 WITH(READUNCOMMITTED)         
                       WHERE A1.RATE_PLAN_NO   = :J1-RATE-PLAN-NO       
                         AND A1.CODE_UTIL_TYPE = :J1-CODE-UTIL-TYPE)    
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :S-INDUS-GAS-CUST                                          
MFA-TR*         FROM CSS_RATE_COMP_DEF J1                                       
MFA-TR*        WHERE J1.RATE_PLAN_NO   = :J1-RATE-PLAN-NO                       
MFA-TR*          AND J1.REG_TYPE_CD    = 'D'                                    
MFA-TR*          AND J1.CODE_UTIL_TYPE = :J1-CODE-UTIL-TYPE                     
MFA-TR*          AND J1.VERSION_NO_CNTRL =                                      
MFA-TR*              (SELECT MAX(A1.VERSION_NO_CNTRL)                           
MFA-TR*                 FROM CSS_RATE_COMP_DEF A1                               
MFA-TR*                WHERE A1.RATE_PLAN_NO   = :J1-RATE-PLAN-NO               
MFA-TR*                  AND A1.CODE_UTIL_TYPE = :J1-CODE-UTIL-TYPE)            
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7150                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7150'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_RATE_COMP_DEF'      TO TABLE-1                  
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-1          
              MOVE 'RATE PLAN NO'           TO TABLE-ELEMENT-2          
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-3          
              MOVE J1-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-1        
              MOVE J1-RATE-PLAN-NO          TO HOSTVAR-ELEMENT-2        
              MOVE UT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7180-GET-FIXED-FCTR-FL.                                        *        
      ******************************************************************        
       7180-GET-FIXED-FCTR-FL.                                          
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :S-FIXED-FACTORS-IND                               
                FROM CSS_FIXED_FCTR FF WITH(READUNCOMMITTED)                    
               WHERE FF.CODE_UTIL_TYPE = :FF-CODE-UTIL-TYPE             
                 AND FF.IC_NO          = :FF-IC-NO                      
                 AND FF.ACCOUNT_NO     = :FF-ACCOUNT-NO                 
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :S-FIXED-FACTORS-IND                                       
MFA-TR*         FROM CSS_FIXED_FCTR FF                                          
MFA-TR*        WHERE FF.CODE_UTIL_TYPE = :FF-CODE-UTIL-TYPE                     
MFA-TR*          AND FF.IC_NO          = :FF-IC-NO                              
MFA-TR*          AND FF.ACCOUNT_NO     = :FF-ACCOUNT-NO                         
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7180                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7180'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_FIXED_FCTR'         TO TABLE-1                  
              MOVE 'CODE UTIL TYPE'         TO TABLE-ELEMENT-1          
              MOVE 'IC NO'                  TO TABLE-ELEMENT-2          
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-3          
              MOVE FF-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-1        
              MOVE FF-IC-NO                 TO HOSTVAR-ELEMENT-2        
              MOVE FF-ACCOUNT-NO            TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       7180-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7190-GET-BILL-CONTRACT-IND.                                    *        
      ******************************************************************        
       7190-GET-BILL-CONTRACT-IND.                                      
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :S-BILL-CONTRACT-IND                               
                FROM CSS_BILL_CONTRACT BK WITH(READUNCOMMITTED)                 
               WHERE BK.CODE_UTIL_TYPE = :BK-CODE-UTIL-TYPE             
                 AND BK.IC_NO          = :BK-IC-NO                      
                 AND BK.ACCOUNT_NO     = :BK-ACCOUNT-NO                 
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :S-BILL-CONTRACT-IND                                       
MFA-TR*         FROM CSS_BILL_CONTRACT BK                                       
MFA-TR*        WHERE BK.CODE_UTIL_TYPE = :BK-CODE-UTIL-TYPE                     
MFA-TR*          AND BK.IC_NO          = :BK-IC-NO                              
MFA-TR*          AND BK.ACCOUNT_NO     = :BK-ACCOUNT-NO                         
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7190                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7190'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_BILL_CONTRACT'      TO TABLE-1                  
              MOVE 'CODE UTIL TYPE'         TO TABLE-ELEMENT-1          
              MOVE 'IC NO'                  TO TABLE-ELEMENT-2          
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-3          
              MOVE BK-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-1        
              MOVE BK-IC-NO                 TO HOSTVAR-ELEMENT-2        
              MOVE BK-ACCOUNT-NO            TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       7190-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7195-GET-INTRRPT-ACCT.                                         *        
      ******************************************************************        
       7195-GET-INTRRPT-ACCT.                                           
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :S-INTERRUPT-ACCT-IND                              
                FROM CSS_INTERRUPT_ACCT IP WITH(READUNCOMMITTED)                
               WHERE IP.CODE_UTIL_TYPE = :IP-CODE-UTIL-TYPE             
                 AND IP.IC_NO          = :IP-IC-NO                      
                 AND IP.ACCOUNT_NO     = :IP-ACCOUNT-NO                 
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :S-INTERRUPT-ACCT-IND                                      
MFA-TR*         FROM CSS_INTERRUPT_ACCT IP                                      
MFA-TR*        WHERE IP.CODE_UTIL_TYPE = :IP-CODE-UTIL-TYPE                     
MFA-TR*          AND IP.IC_NO          = :IP-IC-NO                              
MFA-TR*          AND IP.ACCOUNT_NO     = :IP-ACCOUNT-NO                         
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7195                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7195'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_BILL_CONTRACT'      TO TABLE-1                  
              MOVE 'CODE UTIL TYPE'         TO TABLE-ELEMENT-1          
              MOVE 'IC NO'                  TO TABLE-ELEMENT-2          
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-3          
              MOVE IP-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-1        
              MOVE IP-IC-NO                 TO HOSTVAR-ELEMENT-2        
              MOVE IP-ACCOUNT-NO            TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       7195-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7200-DETERMINE-SUBDVSN-LIGHT.                                  *        
      *     DETERMINE IF THE ACCOUNT HAS SUBDIVISION LIGHTING ON IT.   *        
      *                                                                *        
      ******************************************************************        
       7200-DETERMINE-SUBDVSN-LIGHT.                                    
                                                                        
           EXEC SQL                                                     
              SELECT 'Y'                                                
                INTO :WS-SUBDVSN-LIGHT-FL                               
                FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                     
               WHERE ACCOUNT_NO     = :UT-ACCOUNT-NO                    
                 AND CODE_UTIL_TYPE = 'U'                               
                 AND RATE_PLAN_NO   = '064'                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-SUBDVSN-LIGHT-FL                                       
MFA-TR*         FROM CSS_UTIL_ENVRNMT                                           
MFA-TR*        WHERE ACCOUNT_NO     = :UT-ACCOUNT-NO                            
MFA-TR*          AND CODE_UTIL_TYPE = 'U'                                       
MFA-TR*          AND RATE_PLAN_NO   = '064'                                     
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7200                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
           OR WS-ACTIVE-RETURN-CODE = MULTIPLE-ROWS                     
           OR WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7200'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_UTIL_ENVRNMT'         TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE UT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-2        
              MOVE UT-IC-NO                   TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7210-GET-SECURED-RATE-FL.                                      *        
      ******************************************************************        
       7210-GET-SECURED-RATE-FL.                                        
                                                                        
           EXEC SQL                                                     
              SELECT RD.SECURED_RATE_FL                                 
                INTO :RD-SECURED-RATE-FL                                
                FROM CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED)                
               WHERE RD.CODE_UTIL_TYPE = :RD-CODE-UTIL-TYPE             
                 AND RD.RATE_PLAN_NO   = :RD-RATE-PLAN-NO               
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RD.SECURED_RATE_FL                                         
MFA-TR*         INTO :RD-SECURED-RATE-FL                                        
MFA-TR*         FROM CSS_RATE_PLAN_DESC RD                                      
MFA-TR*        WHERE RD.CODE_UTIL_TYPE = :RD-CODE-UTIL-TYPE                     
MFA-TR*          AND RD.RATE_PLAN_NO   = :RD-RATE-PLAN-NO                       
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7210                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7210'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_RATE_PLAN_DESC'     TO TABLE-1                  
              MOVE 'ACCOUNT NO'             TO TABLE-ELEMENT-1          
              MOVE 'CODE UTIL TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'RATE PLAN NO'           TO TABLE-ELEMENT-3          
              MOVE UT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE RD-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE RD-RATE-PLAN-NO          TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7220-GET-ALLOWED-BLOCK-NO.                                     *        
      ******************************************************************        
       7220-GET-ALLOWED-BLOCK-NO.                                       
                                                                        
           EXEC SQL                                                     
              SELECT MAX(BLOCK_NO)                                      
                INTO :PS-BLOCK-NO :WS-BLOCK-NULL-ID                      
                FROM CSS_PRICE_SCHED PS WITH(READUNCOMMITTED)                   
               WHERE PS.RATE_PLAN_NO       = :PS-RATE-PLAN-NO           
                 AND PS.CODE_UTIL_TYPE     = :PS-CODE-UTIL-TYPE         
                 AND PS.VERSION_NO_CNTRL = (                            
                             SELECT MAX(VERSION_NO_CNTRL)               
                               FROM CSS_RATE_CREATOR
                           WITH(READUNCOMMITTED)                    
                              WHERE CODE_UTIL_TYPE = PS.CODE_UTIL_TYPE  
                                AND RATE_PLAN_NO   = PS.RATE_PLAN_NO    
                                AND CODE_STATUS    IN ('A','T') )       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MAX(BLOCK_NO)                                              
MFA-TR*         INTO :PS-BLOCK-NO:WS-BLOCK-NULL-ID                              
MFA-TR*         FROM CSS_PRICE_SCHED PS                                         
MFA-TR*        WHERE PS.RATE_PLAN_NO       = :PS-RATE-PLAN-NO                   
MFA-TR*          AND PS.CODE_UTIL_TYPE     = :PS-CODE-UTIL-TYPE                 
MFA-TR*          AND PS.VERSION_NO_CNTRL = (                                    
MFA-TR*                      SELECT MAX(VERSION_NO_CNTRL)                       
MFA-TR*                        FROM CSS_RATE_CREATOR                            
MFA-TR*                       WHERE CODE_UTIL_TYPE = PS.CODE_UTIL_TYPE          
MFA-TR*                         AND RATE_PLAN_NO   = PS.RATE_PLAN_NO            
MFA-TR*                         AND CODE_STATUS    IN ('A','T') )               
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7220                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-BLOCK-NULL-ID EQUAL WS-YES-NULL                     
                 MOVE WS-ZERO               TO PS-BLOCK-NO              
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7220'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_RATE_PLAN_DESC'     TO TABLE-1                  
              MOVE 'ACCOUNT NO'             TO TABLE-ELEMENT-1          
              MOVE 'CODE UTIL TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'RATE PLAN NO'           TO TABLE-ELEMENT-3          
              MOVE UT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE PS-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE PS-RATE-PLAN-NO          TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       7220-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7230-GET-DSM-CREDIT-FL.                                        *        
      ******************************************************************        
       7230-GET-DSM-CREDIT-FL.                                          
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :S-DSM-EXEMPT-FL                                   
                FROM CSS_FIXED_FCTR FF WITH(READUNCOMMITTED)                    
               WHERE FF.ACCOUNT_NO      = :FF-ACCOUNT-NO                
                 AND FF.CODE_UTIL_TYPE  = :FF-CODE-UTIL-TYPE            
                 AND FF.IC_NO           = :FF-IC-NO                     
                 AND FF.FACTOR_ID       = :WS-DMD-SIDE-MGMT             
                 AND FF.EFF_DATE_TO    >= CAST(SYSDATETIMEOFFSET() 
           AS DATE)                  
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :S-DSM-EXEMPT-FL                                           
MFA-TR*         FROM CSS_FIXED_FCTR FF                                          
MFA-TR*        WHERE FF.ACCOUNT_NO      = :FF-ACCOUNT-NO                        
MFA-TR*          AND FF.CODE_UTIL_TYPE  = :FF-CODE-UTIL-TYPE                    
MFA-TR*          AND FF.IC_NO           = :FF-IC-NO                             
MFA-TR*          AND FF.FACTOR_ID       = :WS-DMD-SIDE-MGMT                     
MFA-TR*          AND FF.EFF_DATE_TO    >= CURRENT DATE                          
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*        QUERYNO 7230                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7230'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_RATE_PLAN_DESC'     TO TABLE-1                  
              MOVE 'ACCOUNT NO'             TO TABLE-ELEMENT-1          
              MOVE 'CODE UTIL TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'IC NO'                  TO TABLE-ELEMENT-3          
              MOVE FF-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE FF-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE FF-IC-NO                 TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       7230-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7240-GET-SPCL-FCTR-FL.                                         *        
      ******************************************************************        
       7240-GET-SPCL-FCTR-FL.                                           
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :S-ELGBLE-FOR-DSM-EXEMPTN                          
                FROM CSS_SPCL_FCTR_APPL SA WITH(READUNCOMMITTED)                
                    ,CSS_SPCL_FCTR SF WITH(READUNCOMMITTED)                     
               WHERE SA.FACTOR_ID      =  SF.FACTOR_ID                  
                 AND SA.RATE_PLAN_NO   = :SA-RATE-PLAN-NO               
                 AND SA.CODE_UTIL_TYPE = :SA-CODE-UTIL-TYPE             
                 AND SA.DATE_FROM     <=  CAST(SYSDATETIMEOFFSET() 
           AS DATE)                  
                 AND SA.DATE_TO       >=  CAST(SYSDATETIMEOFFSET() 
           AS DATE)                  
                 AND SA.CODE_STATUS    = :WS-A                          
                 AND SF.SPCL_GROUP_CD  = :WS-DS                         
                                             
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :S-ELGBLE-FOR-DSM-EXEMPTN                                  
MFA-TR*         FROM CSS_SPCL_FCTR_APPL SA                                      
MFA-TR*             ,CSS_SPCL_FCTR SF                                           
MFA-TR*        WHERE SA.FACTOR_ID      =  SF.FACTOR_ID                          
MFA-TR*          AND SA.RATE_PLAN_NO   = :SA-RATE-PLAN-NO                       
MFA-TR*          AND SA.CODE_UTIL_TYPE = :SA-CODE-UTIL-TYPE                     
MFA-TR*          AND SA.DATE_FROM     <=  CURRENT DATE                          
MFA-TR*          AND SA.DATE_TO       >=  CURRENT DATE                          
MFA-TR*          AND SA.CODE_STATUS    = :WS-A                                  
MFA-TR*          AND SF.SPCL_GROUP_CD  = :WS-DS                                 
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7240                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7240'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_RATE_PLAN_DESC'     TO TABLE-1                  
              MOVE 'ACCOUNT NO'             TO TABLE-ELEMENT-1          
              MOVE 'CODE UTIL TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'RATE PLAN NO'           TO TABLE-ELEMENT-3          
              MOVE UT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE SA-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE SA-RATE-PLAN-NO          TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       7240-EXIT.                                                       
           EXIT.                                                        
                                                                        
I02262******************************************************************        
I02262*                                                                *        
I02262* 7245-GET-CORE-RATE-DDDC.                                       *        
I02262******************************************************************        
I02262 7245-GET-CORE-RATE-DDDC.                                         
I02262                                                                  
I02262     EXEC SQL                                                     
I02262        SELECT TOP(1) SA.FACTOR                                         
I02262          INTO :SA-FACTOR                                         
I02262          FROM  CSS_SPCL_FCTR_APPL SA WITH(READUNCOMMITTED)               
I02262               ,CSS_SPCL_FCTR      SF WITH(READUNCOMMITTED)               
I02262         WHERE  SA.CODE_UTIL_TYPE = :SA-CODE-UTIL-TYPE            
I02262           AND  SA.RATE_PLAN_NO   = :SA-RATE-PLAN-NO              
I02262           AND  SA.CODE_STATUS    = 'A'                           
I02262           AND  SA.FACTOR_ID      = SF.FACTOR_ID                  
I02262           AND  SF.SPCL_GROUP_CD  = 'DD'                          
I02262           AND  SA.DATE_TO       >= CAST(SYSDATETIMEOFFSET() 
           AS DATE)                  
I02262           AND  SA.DATE_FROM      =                               
I02262                     (SELECT MAX(ZZ.DATE_FROM)                    
I02262                        FROM CSS_SPCL_FCTR_APPL ZZ
                           WITH(READUNCOMMITTED)                
I02262                       WHERE ZZ.RATE_PLAN_NO   = SA.RATE_PLAN_NO  
I02262                         AND ZZ.CODE_UTIL_TYPE = SA.CODE_UTIL_TYPE
I02262                         AND ZZ.FACTOR_ID      = SA.FACTOR_ID     
I02262                         AND ZZ.DATE_TO       >= 
           CAST(SYSDATETIMEOFFSET() AS DATE))    
I02262                                       
I02262                                                      
I02262     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  SA.FACTOR                                                 
MFA-TR*         INTO :SA-FACTOR                                                 
MFA-TR*         FROM  CSS_SPCL_FCTR_APPL SA                                     
MFA-TR*              ,CSS_SPCL_FCTR      SF                                     
MFA-TR*        WHERE  SA.CODE_UTIL_TYPE = :SA-CODE-UTIL-TYPE                    
MFA-TR*          AND  SA.RATE_PLAN_NO   = :SA-RATE-PLAN-NO                      
MFA-TR*          AND  SA.CODE_STATUS    = 'A'                                   
MFA-TR*          AND  SA.FACTOR_ID      = SF.FACTOR_ID                          
MFA-TR*          AND  SF.SPCL_GROUP_CD  = 'DD'                                  
MFA-TR*          AND  SA.DATE_TO       >= CURRENT DATE                          
MFA-TR*          AND  SA.DATE_FROM      =                                       
MFA-TR*                    (SELECT MAX(ZZ.DATE_FROM)                            
MFA-TR*                       FROM CSS_SPCL_FCTR_APPL ZZ                        
MFA-TR*                      WHERE ZZ.RATE_PLAN_NO   = SA.RATE_PLAN_NO          
MFA-TR*                        AND ZZ.CODE_UTIL_TYPE = SA.CODE_UTIL_TYPE        
MFA-TR*                        AND ZZ.FACTOR_ID      = SA.FACTOR_ID             
MFA-TR*                        AND ZZ.DATE_TO       >= CURRENT DATE)            
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7245                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

I02262                                                                  
I02262     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
I02262                                                                  
I02262     EVALUATE WS-ACTIVE-RETURN-CODE                               
I02262         WHEN SUCCESSFUL-CALL                                     
I02262            CONTINUE                                              
I02262         WHEN NOT-FOUND                                           
I02262            MOVE ZEROS                TO SA-FACTOR                
I02262         WHEN OTHER                                               
I02262            MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
I02262            MOVE '7245'               TO ACTIVE-PARAGRAPH         
I02262            MOVE 'SELECT'             TO ABEND-FUNCTION           
I02262            MOVE 'CSS_SPCL_FCTR_APPL' TO TABLE-1                  
I02262            MOVE 'RATE_PLAN_NO'       TO TABLE-ELEMENT-1          
I02262            MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2          
I02262            MOVE SA-RATE-PLAN-NO      TO HOSTVAR-ELEMENT-1        
I02262            MOVE SA-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2        
I02262            PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT           
I02262     END-EVALUATE.                                                
I02262                                                                  
I02262 7245-EXIT.                                                       
I02262     EXIT.                                                        
                                                                        
      ***************************************************************           
      *                                                                         
      * 7250-GET-CURR-RATE-PKG-OPTN.                                *           
      ***************************************************************           
       7250-GET-CURR-RATE-PKG-OPTN.                                     
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) FI.OPT_DESC_INT_LONG,
              FI.OPT_DESC_INT,
              DF.OPTION_CD,
              DF.RT_PKG_OPT_SEQ_NO,
              DF.STATUS_CD,
              DF.STAT_ADJUSTABLE_CD,
              DF.AUTO_REN_OPT_IN_FL,
              FI.OPT_CALC_TYPE_CD,
              RD.RATE_DEFINITION_CD,
              DF.OPT_AGRMT_EFF_DT,
              REPLACE(CONVERT(CHAR(8), DF.OPT_AGRMT_EFF_TM, 108), ':', 
           '.') OPT_AGRMT_EFF_TM                              
                 INTO  :FI-OPT-DESC-INT-LONG                            
                      ,:FI-OPT-DESC-INT                                 
                      ,:DF-OPTION-CD                                    
                      ,:DF-RT-PKG-OPT-SEQ-NO                            
                      ,:DF-STATUS-CD                                    
                      ,:DF-STAT-ADJUSTABLE-CD                           
P00892                ,:DF-AUTO-REN-OPT-IN-FL                           
P01137                ,:FI-OPT-CALC-TYPE-CD                             
I02262                ,:RD-RATE-DEFINITION-CD                           
P01137                ,:DF-OPT-AGRMT-EFF-DT                             
P01137                ,:DF-OPT-AGRMT-EFF-TM                             
                 FROM  CRM_RT_PKG_OPTION  FI WITH(READUNCOMMITTED)              
                      ,CSS_ACCT_RTPK_AGR  DF WITH(READUNCOMMITTED)              
                      ,CSS_UTIL_ENVRNMT   UT WITH(READUNCOMMITTED)              
I02262                ,CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED)              
                WHERE UT.CODE_UTIL_TYPE    = :UT-CODE-UTIL-TYPE         
                  AND UT.IC_NO             = :UT-IC-NO                  
                  AND UT.ACCOUNT_NO        = :UT-ACCOUNT-NO             
                  AND UT.COMPANY_NO        = :UT-COMPANY-NO             
                  AND DF.CODE_UTIL_TYPE    = UT.CODE_UTIL_TYPE          
                  AND DF.IC_NO             = UT.IC_NO                   
                  AND DF.ACCOUNT_NO        = UT.ACCOUNT_NO              
                  AND DF.RT_PKG_OPT_SEQ_NO = UT.RT_PKG_OPT_SEQ_NO       
                  AND DF.COMPANY_NO        = UT.COMPANY_NO              
                  AND FI.OPTION_CD         = DF.OPTION_CD               
                  AND FI.COMPANY_NO        = DF.COMPANY_NO              
                  AND FI.OPT_VSTART_TS    <= CIS.CURRENT$TIMESTAMP()          
                  AND FI.OPT_VEND_TS      >= CIS.CURRENT$TIMESTAMP()          
                  AND FI.PROC_STATUS_CD    = 'AC'                       
I02262            AND RD.RATE_PLAN_NO      = UT.RATE_PLAN_NO            
I02262            AND RD.CODE_UTIL_TYPE    = UT.CODE_UTIL_TYPE          
                ORDER BY DF.RT_PKG_OPT_SEQ_NO DESC                      
                                                    
                                                                 
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  FI.OPT_DESC_INT_LONG                                     
MFA-TR*               ,FI.OPT_DESC_INT                                          
MFA-TR*               ,DF.OPTION_CD                                             
MFA-TR*               ,DF.RT_PKG_OPT_SEQ_NO                                     
MFA-TR*               ,DF.STATUS_CD                                             
MFA-TR*               ,DF.STAT_ADJUSTABLE_CD                                    
MFA-TR*               ,DF.AUTO_REN_OPT_IN_FL                                    
MFA-TR*               ,FI.OPT_CALC_TYPE_CD                                      
MFA-TR*               ,RD.RATE_DEFINITION_CD                                    
MFA-TR*               ,DF.OPT_AGRMT_EFF_DT                                      
MFA-TR*               ,DF.OPT_AGRMT_EFF_TM                                      
MFA-TR*          INTO  :FI-OPT-DESC-INT-LONG                                    
MFA-TR*               ,:FI-OPT-DESC-INT                                         
MFA-TR*               ,:DF-OPTION-CD                                            
MFA-TR*               ,:DF-RT-PKG-OPT-SEQ-NO                                    
MFA-TR*               ,:DF-STATUS-CD                                            
MFA-TR*               ,:DF-STAT-ADJUSTABLE-CD                                   
MFA-TR*               ,:DF-AUTO-REN-OPT-IN-FL                                   
MFA-TR*               ,:FI-OPT-CALC-TYPE-CD                                     
MFA-TR*               ,:RD-RATE-DEFINITION-CD                                   
MFA-TR*               ,:DF-OPT-AGRMT-EFF-DT                                     
MFA-TR*               ,:DF-OPT-AGRMT-EFF-TM                                     
MFA-TR*          FROM  CRM_RT_PKG_OPTION  FI                                    
MFA-TR*               ,CSS_ACCT_RTPK_AGR  DF                                    
MFA-TR*               ,CSS_UTIL_ENVRNMT   UT                                    
MFA-TR*               ,CSS_RATE_PLAN_DESC RD                                    
MFA-TR*         WHERE UT.CODE_UTIL_TYPE    = :UT-CODE-UTIL-TYPE                 
MFA-TR*           AND UT.IC_NO             = :UT-IC-NO                          
MFA-TR*           AND UT.ACCOUNT_NO        = :UT-ACCOUNT-NO                     
MFA-TR*           AND UT.COMPANY_NO        = :UT-COMPANY-NO                     
MFA-TR*           AND DF.CODE_UTIL_TYPE    = UT.CODE_UTIL_TYPE                  
MFA-TR*           AND DF.IC_NO             = UT.IC_NO                           
MFA-TR*           AND DF.ACCOUNT_NO        = UT.ACCOUNT_NO                      
MFA-TR*           AND DF.RT_PKG_OPT_SEQ_NO = UT.RT_PKG_OPT_SEQ_NO               
MFA-TR*           AND DF.COMPANY_NO        = UT.COMPANY_NO                      
MFA-TR*           AND FI.OPTION_CD         = DF.OPTION_CD                       
MFA-TR*           AND FI.COMPANY_NO        = DF.COMPANY_NO                      
MFA-TR*           AND FI.OPT_VSTART_TS    <= CURRENT TIMESTAMP                  
MFA-TR*           AND FI.OPT_VEND_TS      >= CURRENT TIMESTAMP                  
MFA-TR*           AND FI.PROC_STATUS_CD    = 'AC'                               
MFA-TR*           AND RD.RATE_PLAN_NO      = UT.RATE_PLAN_NO                    
MFA-TR*           AND RD.CODE_UTIL_TYPE    = UT.CODE_UTIL_TYPE                  
MFA-TR*         ORDER BY DF.RT_PKG_OPT_SEQ_NO DESC                              
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7250                                                    
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7250'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_UTIL_ENVRNMT'       TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-4          
              MOVE UT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE UT-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE UT-IC-NO                 TO HOSTVAR-ELEMENT-3        
              MOVE UT-COMPANY-NO            TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7250-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      *                                                               *         
      * 7251-SEL-THERM-PRICE.                                         *         
      *****************************************************************         
       7251-SEL-THERM-PRICE.                                            
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) FACTOR,
              FF.FACTOR_ID                                       
                INTO :FF-FACTOR                                         
                    ,:FF-FACTOR-ID                                      
                FROM CSS_FIXED_FCTR FF WITH(READUNCOMMITTED)                    
                    ,CRM_OPT_ATTR_INCTV HQ WITH(READUNCOMMITTED)                
               WHERE FF.ACCOUNT_NO         = :FF-ACCOUNT-NO             
                 AND FF.CODE_UTIL_TYPE     = :FF-CODE-UTIL-TYPE         
                 AND FF.IC_NO              = :FF-IC-NO                  
                 AND FF.RT_PKG_OPT_SEQ_NO  = :FF-RT-PKG-OPT-SEQ-NO      
                 AND FF.FACTOR_ID          = HQ.FACTOR_ID               
                 AND HQ.OPTION_CD          = :HQ-OPTION-CD              
                 AND HQ.RT_ATTR_INCTV_TYPE = 'FIXED PRICE'              
                 AND HQ.ATTR_INCTV_STRT_DT <= CAST(SYSDATETIMEOFFSET() 
           AS DATE)              
                 AND HQ.ATTR_INCTV_END_DT  >= CAST(SYSDATETIMEOFFSET() 
           AS DATE)              
                 AND HQ.OPT_ATTR_VSTART_TS <= CIS.CURRENT$TIMESTAMP()         
                 AND HQ.OPT_ATTR_VEND_TS   >= CIS.CURRENT$TIMESTAMP()         
                 AND HQ.PROC_STATUS_CD      = 'AC'                      
               ORDER BY FF.EFF_DATE_FROM DESC                           
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT FACTOR                                                     
MFA-TR*             ,FF.FACTOR_ID                                               
MFA-TR*         INTO :FF-FACTOR                                                 
MFA-TR*             ,:FF-FACTOR-ID                                              
MFA-TR*         FROM CSS_FIXED_FCTR FF                                          
MFA-TR*             ,CRM_OPT_ATTR_INCTV HQ                                      
MFA-TR*        WHERE FF.ACCOUNT_NO         = :FF-ACCOUNT-NO                     
MFA-TR*          AND FF.CODE_UTIL_TYPE     = :FF-CODE-UTIL-TYPE                 
MFA-TR*          AND FF.IC_NO              = :FF-IC-NO                          
MFA-TR*          AND FF.RT_PKG_OPT_SEQ_NO  = :FF-RT-PKG-OPT-SEQ-NO              
MFA-TR*          AND FF.FACTOR_ID          = HQ.FACTOR_ID                       
MFA-TR*          AND HQ.OPTION_CD          = :HQ-OPTION-CD                      
MFA-TR*          AND HQ.RT_ATTR_INCTV_TYPE = 'FIXED PRICE'                      
MFA-TR*          AND HQ.ATTR_INCTV_STRT_DT <= CURRENT DATE                      
MFA-TR*          AND HQ.ATTR_INCTV_END_DT  >= CURRENT DATE                      
MFA-TR*          AND HQ.OPT_ATTR_VSTART_TS <= CURRENT TIMESTAMP                 
MFA-TR*          AND HQ.OPT_ATTR_VEND_TS   >= CURRENT TIMESTAMP                 
MFA-TR*          AND HQ.PROC_STATUS_CD      = 'AC'                              
MFA-TR*        ORDER BY FF.EFF_DATE_FROM DESC                                   
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7251                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7251'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_FIXED_FCTR'         TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'RT_PKG_OPT_SEQ_NO'      TO TABLE-ELEMENT-3          
              MOVE 'OPTION_CD'              TO TABLE-ELEMENT-4          
              MOVE FF-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE FF-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE FF-RT-PKG-OPT-SEQ-NO     TO HOSTVAR-ELEMENT-3        
              MOVE HQ-OPTION-CD             TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7251-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 7252-SELECT-FCTR-POWER.                                        *        
      ******************************************************************        
       7252-SELECT-FCTR-POWER.                                          
                                                                        
           EXEC SQL                                                     
              SELECT SF.FCTR_POWER_10                                   
                INTO :SF-FCTR-POWER-10                                  
                FROM CSS_SPCL_FCTR SF WITH(READUNCOMMITTED)                     
               WHERE SF.FACTOR_ID = :SF-FACTOR-ID                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SF.FCTR_POWER_10                                           
MFA-TR*         INTO :SF-FCTR-POWER-10                                          
MFA-TR*         FROM CSS_SPCL_FCTR SF                                           
MFA-TR*        WHERE SF.FACTOR_ID = :SF-FACTOR-ID                               
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7252                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7252'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_SPCL_FCTR'          TO TABLE-1                  
              MOVE 'FACTOR_ID'              TO TABLE-ELEMENT-1          
              MOVE SF-FACTOR-ID             TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       7252-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7260-GET-PEND-RATE-PKG-OPTN.                                  *         
      *****************************************************************         
       7260-GET-PEND-RATE-PKG-OPTN.                                     
      *                                                                         
           EXEC SQL                                                     
               SELECT TOP(1) DF.OPTION_CD,
              FI.OPT_DESC_INT,
              FI.OPT_DESC_INT_LONG,
              DF.AUTO_REN_OPT_IN_FL,
              FI.OPT_CALC_TYPE_CD,
              FI.RATE_PLAN_NO,
              RD.RATE_DEFINITION_CD                             
                 INTO :DF-OPTION-CD                                     
                     ,:FI-OPT-DESC-INT                                  
                     ,:FI-OPT-DESC-INT-LONG                             
P00892               ,:DF-AUTO-REN-OPT-IN-FL                            
P01137               ,:FI-OPT-CALC-TYPE-CD                              
I02262               ,:FI-RATE-PLAN-NO                                  
I02262               ,:RD-RATE-DEFINITION-CD                            
                 FROM CSS_ACCT_RTPK_AGR  DF WITH(READUNCOMMITTED)               
                     ,CRM_RT_PKG_OPTION  FI WITH(READUNCOMMITTED)               
I02262               ,CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED)               
                WHERE DF.ACCOUNT_NO     = :DF-ACCOUNT-NO                
                  AND DF.CODE_UTIL_TYPE = :DF-CODE-UTIL-TYPE            
                  AND DF.IC_NO          = :DF-IC-NO                     
                  AND DF.STATUS_CD      = 'P'                           
                  AND FI.OPTION_CD      = DF.OPTION_CD                  
                  AND FI.COMPANY_NO     = DF.COMPANY_NO                 
                  AND FI.OPT_VSTART_TS <= CIS.CURRENT$TIMESTAMP()             
                  AND FI.OPT_VEND_TS   >= CIS.CURRENT$TIMESTAMP()             
                  AND FI.PROC_STATUS_CD = 'AC'                          
I02262            AND RD.RATE_PLAN_NO   = FI.RATE_PLAN_NO               
I02262            AND RD.CODE_UTIL_TYPE = :DF-CODE-UTIL-TYPE            
                 ORDER BY DF.RT_PKG_OPT_SEQ_NO DESC                     
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DF.OPTION_CD                                              
MFA-TR*              ,FI.OPT_DESC_INT                                           
MFA-TR*              ,FI.OPT_DESC_INT_LONG                                      
MFA-TR*              ,DF.AUTO_REN_OPT_IN_FL                                     
MFA-TR*              ,FI.OPT_CALC_TYPE_CD                                       
MFA-TR*              ,FI.RATE_PLAN_NO                                           
MFA-TR*              ,RD.RATE_DEFINITION_CD                                     
MFA-TR*          INTO :DF-OPTION-CD                                             
MFA-TR*              ,:FI-OPT-DESC-INT                                          
MFA-TR*              ,:FI-OPT-DESC-INT-LONG                                     
MFA-TR*              ,:DF-AUTO-REN-OPT-IN-FL                                    
MFA-TR*              ,:FI-OPT-CALC-TYPE-CD                                      
MFA-TR*              ,:FI-RATE-PLAN-NO                                          
MFA-TR*              ,:RD-RATE-DEFINITION-CD                                    
MFA-TR*          FROM CSS_ACCT_RTPK_AGR  DF                                     
MFA-TR*              ,CRM_RT_PKG_OPTION  FI                                     
MFA-TR*              ,CSS_RATE_PLAN_DESC RD                                     
MFA-TR*         WHERE DF.ACCOUNT_NO     = :DF-ACCOUNT-NO                        
MFA-TR*           AND DF.CODE_UTIL_TYPE = :DF-CODE-UTIL-TYPE                    
MFA-TR*           AND DF.IC_NO          = :DF-IC-NO                             
MFA-TR*           AND DF.STATUS_CD      = 'P'                                   
MFA-TR*           AND FI.OPTION_CD      = DF.OPTION_CD                          
MFA-TR*           AND FI.COMPANY_NO     = DF.COMPANY_NO                         
MFA-TR*           AND FI.OPT_VSTART_TS <= CURRENT TIMESTAMP                     
MFA-TR*           AND FI.OPT_VEND_TS   >= CURRENT TIMESTAMP                     
MFA-TR*           AND FI.PROC_STATUS_CD = 'AC'                                  
MFA-TR*           AND RD.RATE_PLAN_NO   = FI.RATE_PLAN_NO                       
MFA-TR*           AND RD.CODE_UTIL_TYPE = :DF-CODE-UTIL-TYPE                    
MFA-TR*          ORDER BY DF.RT_PKG_OPT_SEQ_NO DESC                             
MFA-TR*          FETCH FIRST ROW ONLY                                           
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7260                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7260'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_ACCT_RTPK_AGR'      TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE DF-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE DF-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE DF-IC-NO                 TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7260-EXIT.                                                       
           EXIT.                                                        
                                                                        
OTPOOL*****************************************************************         
OTPOOL*                                                               *         
OTPOOL* 7270-GET-ACCT-MKT-TIER.                                       *         
OTPOOL*****************************************************************         
OTPOOL 7270-GET-ACCT-MKT-TIER.                                          
OTPOOL*                                                                         
OTPOOL     EXEC SQL                                                     
OTPOOL         SELECT TOP(1) DD.TIER_ACCT_TYPE_CD                             
OTPOOL           INTO :DD-TIER-ACCT-TYPE-CD                             
OTPOOL           FROM  CSS_ACCT_MKT_TIER DD WITH(READUNCOMMITTED)               
OTPOOL          WHERE  DD.ACCOUNT_NO  = :DD-ACCOUNT-NO                  
OTPOOL          ORDER  BY DD.EFF_START_DT DESC                          
OTPOOL                                              
OTPOOL                                                           
OTPOOL                                                      
OTPOOL     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  DD.TIER_ACCT_TYPE_CD                                     
MFA-TR*          INTO :DD-TIER-ACCT-TYPE-CD                                     
MFA-TR*          FROM  CSS_ACCT_MKT_TIER DD                                     
MFA-TR*         WHERE  DD.ACCOUNT_NO  = :DD-ACCOUNT-NO                          
MFA-TR*         ORDER  BY DD.EFF_START_DT DESC                                  
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7270                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

OTPOOL                                                                  
OTPOOL     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
OTPOOL                                                                  
OTPOOL     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
OTPOOL        CONTINUE                                                  
OTPOOL     ELSE                                                         
OTPOOL        MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
OTPOOL        MOVE '7270'                   TO ACTIVE-PARAGRAPH         
OTPOOL        MOVE 'SELECT'                 TO ABEND-FUNCTION           
OTPOOL        MOVE 'CSS_ACCT_MKT_TIER'      TO TABLE-1                  
OTPOOL        MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
OTPOOL        MOVE DD-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
OTPOOL        PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
OTPOOL     END-IF.                                                      
OTPOOL                                                                  
OTPOOL 7270-EXIT.                                                       
OTPOOL     EXIT.                                                        
OTPOOL                                                                  
      ******************************************************************        
      * 7280-DETERMINE-BANK-DRAFT.                                     *        
      *     DETERMINE IF ACCOUNT IS ON BANK DRAFT                      *        
      ******************************************************************        
       7280-DETERMINE-BANK-DRAFT.                                       
                                                                        
           EXEC SQL                                                     
              SELECT 'Y'                                                
                    ,BE.LAST_DRAFT_DATE                                 
                    ,BE.DRAFT_CYCLE                                     
                INTO :S-ACCT-ON-BANK-DRAFT                              
                    ,:BE-LAST-DRAFT-DATE :WS-NULL-LAST-DRAFT-DATE        
                    ,:BE-DRAFT-CYCLE                                    
                FROM CSS_BANK_EFT BE WITH(READUNCOMMITTED)                      
               WHERE BE.ACCOUNT_NO       = :BE-ACCOUNT-NO               
                 AND BE.STATUS_CODE      = :WS-A                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*             ,BE.LAST_DRAFT_DATE                                         
MFA-TR*             ,BE.DRAFT_CYCLE                                             
MFA-TR*         INTO :S-ACCT-ON-BANK-DRAFT                                      
MFA-TR*             ,:BE-LAST-DRAFT-DATE:WS-NULL-LAST-DRAFT-DATE                
MFA-TR*             ,:BE-DRAFT-CYCLE                                            
MFA-TR*         FROM CSS_BANK_EFT BE                                            
MFA-TR*        WHERE BE.ACCOUNT_NO       = :BE-ACCOUNT-NO                       
MFA-TR*          AND BE.STATUS_CODE      = :WS-A                                
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7280                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                                   OR NOT-FOUND                         
                                   OR MULTIPLE-ROWS                     
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7280'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_BANK_EFT'             TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE BE-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       7280-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7290-GET-PNDNG-DRAFT-DATE.                                     *        
      *     GETS PENDING DRAFT DATE                                    *        
      ******************************************************************        
       7290-GET-PNDNG-DRAFT-DATE.                                       
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) PB.DRAFT_DATE                                      
                INTO :PB-DRAFT-DATE                                     
                FROM CSS_PNDNG_BNK_DRFT PB WITH(READUNCOMMITTED)                
               WHERE PB.ACCOUNT_NO          = :PB-ACCOUNT-NO            
               ORDER BY PB.DRAFT_DATE DESC                              
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT PB.DRAFT_DATE                                              
MFA-TR*         INTO :PB-DRAFT-DATE                                             
MFA-TR*         FROM CSS_PNDNG_BNK_DRFT PB                                      
MFA-TR*        WHERE PB.ACCOUNT_NO          = :PB-ACCOUNT-NO                    
MFA-TR*        ORDER BY PB.DRAFT_DATE DESC                                      
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7290                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7290'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_PNDNG_BNK_DRFT'       TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE PB-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       7290-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      *                                                               *         
      * 7300-GET-CODE-VALUE                                           *         
      *****************************************************************         
      *                                                                         
       7300-GET-CODE-VALUE.                                             
      *                                                                         
           EXEC SQL                                                     
              SELECT UV.CODE_SHORT_DESC                                 
                INTO :UV-CODE-SHORT-DESC                                
                FROM CSS_CODE_VALUE UV WITH(READUNCOMMITTED)                    
               WHERE UV.CODE_VALUE  = :UV-CODE-VALUE                    
                 AND UV.COLUMN_NA   = :UV-COLUMN-NA                     
                 AND UV.TABLE_NA    = :UV-TABLE-NA                      
                 AND UV.PROGRAM_ID  = :UV-PROGRAM-ID                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT UV.CODE_SHORT_DESC                                         
MFA-TR*         INTO :UV-CODE-SHORT-DESC                                        
MFA-TR*         FROM CSS_CODE_VALUE UV                                          
MFA-TR*        WHERE UV.CODE_VALUE  = :UV-CODE-VALUE                            
MFA-TR*          AND UV.COLUMN_NA   = :UV-COLUMN-NA                             
MFA-TR*          AND UV.TABLE_NA    = :UV-TABLE-NA                              
MFA-TR*          AND UV.PROGRAM_ID  = :UV-PROGRAM-ID                            
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7300                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7300'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_CODE_VALUE'         TO TABLE-1                  
              MOVE 'PROGRAM_ID'             TO TABLE-ELEMENT-1          
              MOVE UV-PROGRAM-ID            TO HOSTVAR-ELEMENT-1        
              MOVE 'CODE_VALUE'             TO TABLE-ELEMENT-2          
              MOVE UV-CODE-VALUE            TO HOSTVAR-ELEMENT-2        
              MOVE 'COLUMN_NA'              TO TABLE-ELEMENT-3          
              MOVE UV-COLUMN-NA             TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7400-SELECT-JOB-PARM                                           *        
      ******************************************************************        
       7400-SELECT-JOB-PARM.                                            
      *                                                                         
           EXEC SQL                                                     
             SELECT G6.PARM_DATA                                        
               INTO :G6-PARM-DATA                                       
               FROM CSS_JOB_PARM       G6                               
              WHERE G6.PROGRAM_NAME = :G6-PROGRAM-NAME                  
                AND G6.COMPANY_NO   = :G6-COMPANY-NO                    
                AND G6.CMND_CODE    = :G6-CMND-CODE                     
                AND G6.STATUS       = :G6-STATUS                        
                AND G6.SEQ_NO       = :G6-SEQ-NO                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_JOB_PARM'           TO TABLE-1                  
              MOVE 'PROGRAM_NAME'           TO TABLE-ELEMENT-1          
              MOVE G6-PROGRAM-NAME          TO HOSTVAR-ELEMENT-1        
              MOVE 'CMD_CODE'               TO TABLE-ELEMENT-2          
              MOVE G6-CMND-CODE             TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8100-SEND-RESULT                                               *        
      ******************************************************************        
       8100-SEND-RESULT.                                                
                                                                        
           ADD +1                           TO CTR-ROWS.                
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************** ***********************************************        
      * 9700-ABEND-PROCESSING.                                         *        
      ******************************************************************        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT        THRU 9000-EXIT.        
           PERFORM 9900-SQL-ERROR-ROUTINE        THRU 9900-EXIT.        
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900 - JOURNALING / ERROR HANDLING ROUTINE                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
           EXEC SQL                                                             
             INCLUDE CPD00321                                                   
           END-EXEC.                                                            
                                                                        
