       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       CSR04661.                                      
COB303 AUTHOR.           AD7F921.                                       
COB303 DATE-WRITTEN.     NOV 13, 2013.                                  
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  CSR04661:                                                     *        
      *                                                                *        
      *  RETRIEVE FIXED FACTOR DETAILS FROM DB2 TABLES.                *        
      *                                                                *        
      *  THIS PROGRAM IS CLONED FROM CSR04303.                         *        
      *                                                                *        
      *  INPUT PARAMETERS                                              *        
      *  ----------------                                              *        
      *             ACCOUNT_NO                 DECIMAL(13, 0)          *        
      *             CODE_UTIL_TYPE             CHAR(01)                *        
      *             IC_NO                      SMALLINT                *        
      *             STATUS_CD                  CHAR(01)                *        
      *                                                                *        
      *  OUTPUT PARAMETERS                                             *        
      *  -----------------                                             *        
      *                                                                *        
      *         RESULT SET 01: CSR04661_R1                             *        
      *         --------------------------                             *        
      *             RETURN_CODE                INTEGER                 *        
      *             APPL_RETURN_CODE           INTEGER                 *        
      *             FACTOR_TYPE                CHAR(01)                *        
      *             FACTOR_ID                  CHAR(09)                *        
      *             FACTOR_DESC                CHAR(20)                *        
      *             START_DATE                 CHAR(10)                *        
      *             END_DATE                   CHAR(10)                *        
      *             DURATION_REM               SMALLINT                *        
      *             FACTOR                     DECIMAL(13,4)           *        
      *             APPL_METHOD                CHAR(01)                *        
      *             SWITCH_EXIT_FEE            DECIMAL(11,6)           *        
      *             RATE_CHNG_EXIT_FEE         DECIMAL(11,6)           *        
      *             OPTION_DESC                CHAR(50)                *        
      *             CALC_END_DATE              CHAR(10)                *        
P00892*             AUTO_REN_OPT_IN_FL         CHAR(01)                *        
P00892*             RT_PKG_OPT_SEQ_NO          SMALLINT                         
      *                                                                *        
      *         RESULT SET 02: CSR04661_R2                             *        
      *         --------------------------                             *        
      *             RETURN_CODE             INTEGER                    *        
      *             APPL_RETURN_CODE        INTEGER                    *        
      *             BUS_RULE_ID             CHAR(10)                   *        
      *             BUS_RULE_RESULT_CD      CHAR(10)                   *        
      *             BUS_RULE_XREF_ID        CHAR(26)                   *        
      *                                                                *        
      *  APPL RETURN CODE                                              *        
      *  -----------------                                             *        
      *  1000 - INPUT VALUES ARE INVALID                               *        
      *                                                                *        
      *  COPYBOOKS USED:                                               *        
      *  ---------------                                               *        
      *  CWS00303  - SUPPORTS DB2 AND SQL ERROR CHECKING.              *        
      *  CWS04114  - WORKING STORAGE SUPPORT TO GET EXIT FEE.          *        
      *  CWXS0010  - ERROR HANDLING COPY BOOK.                         *        
      *  CPD04114  - GETTING EXIT FEE/ RATE CHANGE EXIT FEE.           *        
      *  CPDSP300  - JOURNALING  / ERROR HANDLING.                     *        
      *                                                                *        
      *  DCLGEN USED:                                                  *        
      *  ------------                                                  *        
      *  TBACCT    - CSS_ACCOUNT                                       *        
      *  TBMKTIER  - CSS_ACCT_MKT_TIER                                 *        
      *  TBUTLENV  - CSS_UTIL_ENVRNMT                                  *        
      *  TBFXDFCT  - CSS_FIXED_FCTR                                    *        
      *  TBSPLFTR  - CSS_SPCL_FCTR                                     *        
      *  TBACCTRG  - CSS_ACCT_RTPK_AGR                                 *        
      *  TBOPTATT  - CRM_OPT_ATTR_INCTV                                *        
      *  TBRTPKGO  - CRM_RT_PKG_OPTION                                 *        
      *  TBJBPARM  - CSS_JOB_PARM                                      *        
      *  TBBILWDW  - CSS_BILL_WINDOW                                   *        
      *  TBATRPRO  - CRM_ATTR_PRORATE                                  *        
      *  TBATRFCT  - CRM_ATTR_PRO_FCTR                                 *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE      INITIALS   COMMENTS                               *        
      *  --------    --------   ------------------------------         *        
      *  11-13-2013  AD7F921    NEW PROGRAM                            *        
P00892*  04/22/2015  VIJAY      FIXED RATE AUTO RENEWAL CHANGES        *        
A05136*  12/16/2015  SAKTHI     WHEN DURATION TYPE IS SPACE MOVE       *        
      *              ACT-255    FIXED FACTOR ENDATE AS CALC END DATE.  *        
P805CS*  04/06/2016  SS45239    SHOW CSC DISCOUNT FACTORS.             *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04661'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04661 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ACCOUNT        AT                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ACCT_MKT_TIER  DD                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMKTIER                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_UTIL_ENVRNMT   UT                                      *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_FIXED_FCTR     FF                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBFXDFCT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_SPCL_FCTR      SF                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBSPLFTR                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ACCT_RTPK_AGR  DF                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBACCTRG                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CRM_OPT_ATTR_INCTV HQ                                      *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBOPTATT                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CRM_RT_PKG_OPTION  FI                                      *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBRTPKGO                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_JOB_PARM       G6                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_BILL_WINDOW    BN                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBBILWDW                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CRM_ATTR_PRORATE   2L                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBATRPRO                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CRM_ATTR_PRO_FCTR  2N                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBATRFCT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      ******************************************************************        
      *    SUPPORTS DB2 AND SQL ERROR CHECKING                         *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    CSS_JOB_PARM DATA COPY BOOK                                 *        
      ******************************************************************        
           COPY FIOJC01.                                                        
                                                                        
      ******************************************************************        
      *    JOB PARM DATA VARIABLES                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CWS00038                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    WORKING STORAGE SUPPORT TO GET EXIT FEE                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CWS04114                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    ERROR HANDLING COPY BOOK.                                   *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
                                                                        
P805CS*** DISCOUNT ELIGIBILITY ROUTINE WS COPYBOOK(S)                           
P805CS     EXEC SQL                                                             
P805CS         INCLUDE CWS0444E                                                 
P805CS     END-EXEC.                                                            
P805CS*                                                                         
P805CS     COPY CWS00444.                                                       
P805CS*                                                                         
P805CS*** CODES DATA PRESENT LAYOUT                                             
P805CS*                                                                         
P805CS     COPY CWS00056.                                                       
P805CS*                                                                         
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  WS-WORKING-STORAGE.                                          
           05  WS-SQLSTATE                  PIC X(05) VALUE SPACES.     
           05  WS-GTT-NAME                  PIC X(26) VALUE SPACES.     
           05  WS-FAILED                    PIC X(01) VALUE 'F'.        
           05  WS-APPL-RETURN-CODE          PIC S9(04) COMP VALUE 0.    
                                                                        
       01  SWITCHES.                                                    
           05  CSR04661-DONE-SW             PIC X(01) VALUE 'N'.        
               88 NOT-ALL-DONE                        VALUE 'N'.        
               88 ALL-DONE                            VALUE 'Y'.        
           05  SEND-DONE-SW                 PIC X(01) VALUE 'Y'.        
               88 SEND-DONE-ERROR                     VALUE 'N'.        
               88 SEND-DONE-OK                        VALUE 'Y'.        
           05  WS-NO-MORE-ROWS              PIC X(01) VALUE 'N'.        
               88 NO-MORE-ROWS                        VALUE 'Y'.        
               88 NOT-NO-MORE-ROWS                    VALUE 'N'.        
           05  WS-PENDING-STATUS            PIC X(01) VALUE 'Y'.        
               88 PENDING-STATUS                      VALUE 'Y'.        
               88 NOT-PENDING-STATUS                  VALUE 'N'.        
                                                                        
       01  NULL-INDICATORS.                                             
           05  WS-IND-DATE-TO               PIC S9(04) COMP.            
           05  WS-IND-DATE-FROM             PIC S9(04) COMP.            
           05  WS-IND-DUR-REM-NO            PIC S9(04) COMP.            
                                                                        
       01  GTT-MISC-FIELDS.                                             
           05  GTT-ROW.                                                 
               49 GTT-ROW-LEN               PIC S9(04) COMP.            
               49 GTT-ROW-CHAR              PIC X(1024).                
           05  GTT-SQLCODE                  PIC S9(9) COMP.             
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN                   PIC S9(9) COMP VALUE 1.     
           05  CTR-ROWS-RS1                 PIC S9(9) COMP VALUE 0.     
           05  CTR-ROWS-RS2                 PIC S9(9) COMP VALUE 0.     
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM              PIC S9(9) COMP.             
           05  WRKLEN1                      PIC S9(9) COMP.             
           05  WRKLEN2                      PIC S9(9) COMP.             
           05  WRK-DONE-STATUS              PIC S9(9) COMP.             
                                                                        
       01  WS-FLAG-VALUES.                                              
           05  WS-YES                       PIC X(01) VALUE 'Y'.        
           05  WS-NO                        PIC X(01) VALUE 'N'.        
           05  WS-99                        PIC X(02) VALUE '99'.       
           05  WS-01                        PIC X(02) VALUE '01'.       
           05  WS-ONE                       PIC 9(02) VALUE 01.         
           05  WS-12                        PIC 9(02) VALUE 12.         
           05  WS-ZERO                      PIC S9(4) COMP VALUE 0.     
                                                                        
                                                                        
       01  WS-REV-YEAR-MONTH.                                           
           05  WS-REV-MONTH1                PIC X(06).                  
           05  WS-REV-MNTH-RED              REDEFINES WS-REV-MONTH1.    
               10  WS-REV-MNTH              PIC 9(06).                  
           05  WS-REVENUE-MONTH             PIC S9(06)V.                
           05  WS-REV-MONTH-RED             REDEFINES WS-REVENUE-MONTH. 
               10 WS-REV-MONTH-YY           PIC 9(04).                  
               10 WS-REV-MONTH-MM           PIC 9(02).                  
                                                                        
       01  WS-ERR-FLAGS.                                                
           05  WS-ERR-INSRT-R1              PIC X(01) VALUE 'N'.        
           05  WS-ERR-INSRT-R2              PIC X(01) VALUE 'N'.        
                                                                        
       01  WS-LITERAL.                                                  
           05 WS-PENDING                    PIC X(01) VALUE 'P'.        
           05 PROGRAM-NAME                  PIC X(08) VALUE 'CSR04661'. 
           05 WS-COMMON                     PIC X(10) VALUE 'COMMON'.   
           05 WS-DATE-PARM                  PIC X(04) VALUE 'DATE'.     
                                                                        
       01  WS-MISC.                                                     
           05 WS-CALC-END-DATE              PIC X(10) VALUE SPACES.     
           05 WS-CALC-END-MONTH             PIC 9(06) VALUE 0.          
           05 WS-CURRENT-DATE               PIC X(10) VALUE SPACES.     
           05 WS-CALC-REM-MONTHS            PIC S9(4) USAGE COMP        
                                                      VALUE ZERO.       
           05 WS-DUR-RMN-NO-TEMP-1          PIC 9(04).                  
           05 WS-DUR-RMN-NO-TEMP-2          PIC ZZZ9.                   
           05 WS-YES-NULL                   PIC S9(04) VALUE -1.        
           05 WS-DURATION-REM-NO            PIC X(04) VALUE SPACE.      
           05 WS-FACTOR-FF                  PIC S9(9)V9(6) USAGE COMP-3 
                                                      VALUE 0.          
                                                                        
       01  GTT-RETURN-FIELDS.                                           
      *********************************************************                 
      *   GTT TABLE LAYOUT                                    *                 
      *********************************************************                 
           05  RS-RETURN-CODE               PIC S9(04) COMP VALUE 0.    
           05  GTT-RETURN-FIELDS-1.                                     
              10  S-RETURN-CODE-1           PIC S9(04) COMP VALUE 0.    
              10  S-APPL-RETURN-CODE-1      PIC S9(04) COMP VALUE 0.    
              10  S-FACTOR-TYPE             PIC X(01) VALUE SPACE.      
              10  S-FACTOR-ID               PIC X(09) VALUE SPACE.      
              10  S-FACTOR-DESC             PIC X(20) VALUE SPACE.      
              10  S-START-DATE              PIC X(10) VALUE             
                                                      '0000-01-01'.     
              10  S-END-DATE                PIC X(10) VALUE             
                                                      '0000-01-01'.     
              10  S-DURATION-REM-NO         PIC X(04) VALUE SPACE.      
              10  S-FACTOR                  PIC S9(9)V9(6) USAGE COMP-3 
                                                      VALUE 0.          
              10  S-APPL-METHOD             PIC X(01) VALUE SPACE.      
              10  S-SWITCH-EXIT-FEE         PIC S9(5)V9(6) USAGE COMP-3 
                                                      VALUE 0.          
              10  S-RATE-CHNG-EXIT-FEE      PIC S9(5)V9(6) USAGE COMP-3 
                                                      VALUE 0.          
              10  S-OPTION-DESC             PIC X(50) VALUE SPACES.     
              10  S-CALC-END-DATE           PIC X(10) VALUE SPACES.     
P00892        10  S-AUTO-REN-OPT-IN-FL      PIC X(01) VALUE SPACES.     
P00892        10  S-RT-PKG-OPT-SEQ-NO       PIC S9(4) COMP VALUE 0.     
      *********************************************************                 
      *   GTT TABLE LAYOUT FOR BUS RULE ERROR MESSAGE         *                 
      *********************************************************                 
          05 GTT-RETURN-FIELDS-2.                                       
             10 S-RETURN-CODE-2             PIC S9(04) COMP VALUE 0.    
             10 S-APPL-RETURN-CODE-2        PIC S9(04) COMP VALUE 0.    
             10 S-RS2-BUS-RULE-ID           PIC X(10)  VALUE SPACES.    
             10 S-RS2-BUS-RULE-RESULT-CD    PIC X(10)  VALUE SPACES.    
             10 S-RS2-BUS-RULE-XREF-ID      PIC X(26)  VALUE SPACES.    
      ****************************************************************          
      *                                                              *          
      *    ERROR PROCESSING VARIABLES                                *          
      ****************************************************************          
      *                                                                         
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME                   PIC X(18)  VALUE SPACES.    
            10  S-SQLCODE                   PIC S9(9)  COMP VALUE 0.    
            10  S-SQLSTATE                  PIC X(5)   VALUE ' '.       
            10  S-TABLE-NAME                PIC X(18)  VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L      PIC S9(4)  USAGE COMP.      
                49  S-HOST-VARIABLES-V      PIC X(255).                 
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L       PIC S9(4)  USAGE COMP.      
                49  S-SQL-STATEMENT-V       PIC X(255).                 
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L     PIC S9(4)  USAGE COMP.      
                49  S-SQL-DESCRIPTION-V     PIC X(255).                 
                                                                        
      ******************************************************************        
      *    CURSOR DECLARATIONS                                         *        
      ******************************************************************        
                                                                        
      ******************************************************************        
      * DECLARE CURSOR TO RETRIEVE THE ROWS FOR ACTIVE / OPEN FOR      *        
      * RENEWAL / RENEWED STATUS. FACTOR TYPE SHOULD BE                *        
      * FIXED FACTOR / COMBO FIXED.                                    *        
      ******************************************************************        
           EXEC SQL                                                     
              DECLARE FIXED_FCTR_CUR CURSOR FOR                         
                 SELECT SF.FACTOR_TYPE                                  
                       ,SF.FACTOR_ID                                    
                       ,SF.FACTOR_TEXT                                  
                       ,FF.EFF_DATE_FROM                                
                       ,FF.EFF_DATE_TO                                  
                       ,FF.DURATION_REMAIN_NO                           
                       ,FF.FACTOR                                       
                       ,SF.FCTR_POWER_10                                
                       ,SF.VERS_PRORATE_CD                              
                       ,FI.OPT_DESC_INT                                 
P00892                 ,DF.AUTO_REN_OPT_IN_FL                           
P00892                 ,DF.RT_PKG_OPT_SEQ_NO                            
ACT255                 ,SF.DURATION_TYPE_CD                             
                   FROM CSS_FIXED_FCTR     FF WITH(READUNCOMMITTED)             
                       ,CSS_SPCL_FCTR      SF WITH(READUNCOMMITTED)             
                       ,CSS_ACCT_RTPK_AGR  DF WITH(READUNCOMMITTED)             
                       ,CSS_UTIL_ENVRNMT   UT WITH(READUNCOMMITTED)             
                       ,CRM_RT_PKG_OPTION  FI WITH(READUNCOMMITTED)             
                  WHERE DF.ACCOUNT_NO        = :DF-ACCOUNT-NO           
                    AND DF.CODE_UTIL_TYPE    = :DF-CODE-UTIL-TYPE       
                    AND DF.IC_NO             = :DF-IC-NO                
                    AND DF.STATUS_CD        IN ('A','O','R')            
                    AND UT.ACCOUNT_NO        = DF.ACCOUNT_NO            
                    AND UT.CODE_UTIL_TYPE    = DF.CODE_UTIL_TYPE        
                    AND UT.IC_NO             = DF.IC_NO                 
                    AND UT.RT_PKG_OPT_SEQ_NO = DF.RT_PKG_OPT_SEQ_NO     
                    AND FF.RT_PKG_OPT_SEQ_NO = DF.RT_PKG_OPT_SEQ_NO     
                    AND FF.ACCOUNT_NO        = DF.ACCOUNT_NO            
                    AND FF.CODE_UTIL_TYPE    = DF.CODE_UTIL_TYPE        
                    AND FF.IC_NO             = DF.IC_NO                 
                    AND SF.FACTOR_ID         = FF.FACTOR_ID             
                    AND SF.FACTOR_TYPE      IN ('B','F')                
                    AND SF.RT_ATTR_INCTV_TYPE <> 'ADJUSTABLE RATE'      
                    AND FI.OPTION_CD         = DF.OPTION_CD             
                    AND FI.COMPANY_NO        = '01'                     
                    AND FI.OPT_VSTART_TS    <= CIS.CURRENT$TIMESTAMP()        
                    AND FI.OPT_VEND_TS      >= CIS.CURRENT$TIMESTAMP()        
                    AND FI.PROC_STATUS_CD    = 'AC'                     
                                                                        
P805CS****        UNION ALL                                                     
                                                                        
P805CS****       SELECT SF.FACTOR_TYPE                                          
P805CS****             ,SF.FACTOR_ID                                            
P805CS****             ,SF.FACTOR_TEXT                                          
P805CS****             ,FF.EFF_DATE_FROM                                        
P805CS****             ,FF.EFF_DATE_TO                                          
P805CS****             ,FF.DURATION_REMAIN_NO                                   
P805CS****             ,FF.FACTOR                                               
P805CS****             ,SF.FCTR_POWER_10                                        
P805CS****             ,SF.VERS_PRORATE_CD                                      
P805CS****             ,FI.OPT_DESC_INT                                         
P805CS****             ,DF.AUTO_REN_OPT_IN_FL                                   
P805CS****             ,DF.RT_PKG_OPT_SEQ_NO                                    
P805CS****             ,SF.DURATION_TYPE_CD                                     
P805CS****         FROM CSS_FIXED_FCTR     FF                                   
P805CS****             ,CSS_SPCL_FCTR      SF                                   
P805CS****             ,CSS_ACCT_RTPK_AGR  DF                                   
P805CS****             ,CSS_UTIL_ENVRNMT   UT                                   
P805CS****             ,CRM_RT_PKG_OPTION  FI                                   
P805CS****        WHERE DF.ACCOUNT_NO        = :DF-ACCOUNT-NO                   
P805CS****          AND DF.CODE_UTIL_TYPE    = :DF-CODE-UTIL-TYPE               
P805CS****          AND DF.IC_NO             = :DF-IC-NO                        
P805CS****          AND UT.ACCOUNT_NO        = DF.ACCOUNT_NO                    
P805CS****          AND UT.CODE_UTIL_TYPE    = DF.CODE_UTIL_TYPE                
P805CS****          AND UT.IC_NO             = DF.IC_NO                         
P805CS****          AND UT.RT_PKG_OPT_SEQ_NO = DF.RT_PKG_OPT_SEQ_NO             
P805CS****          AND FF.ACCOUNT_NO        = DF.ACCOUNT_NO                    
P805CS****          AND FF.CODE_UTIL_TYPE    = DF.CODE_UTIL_TYPE                
P805CS****          AND FF.IC_NO             = DF.IC_NO                         
P805CS****          AND FF.EFF_DATE_FROM    <= CURRENT DATE                     
P805CS****          AND FF.EFF_DATE_TO      >= CURRENT DATE                     
P805CS****          AND FF.FACTOR_ID        IN                                  
P805CS****                (SELECT TRIM(SUBSTR(G6.PARM_DATA,35,9))               
P805CS****                   FROM CSS_JOB_PARM    G6                            
P805CS****                  WHERE G6.PROGRAM_NAME = 'CPD00444'                  
P805CS****                    AND G6.COMPANY_NO   = '01'                        
P805CS****                    AND G6.CMND_CODE    = 'PARM'                      
P805CS****                    AND G6.STATUS       = 'A'                         
P805CS****                    AND SUBSTR(G6.PARM_DATA,1,14)                     
P805CS****                                        = 'DISCOUNT_TYPE=')           
P805CS****          AND SF.FACTOR_ID         = FF.FACTOR_ID                     
P805CS****          AND FI.OPTION_CD         = DF.OPTION_CD                     
P805CS****          AND FI.COMPANY_NO        = '01'                             
P805CS****          AND FI.OPT_VSTART_TS    <= CURRENT TIMESTAMP                
P805CS****          AND FI.OPT_VEND_TS      >= CURRENT TIMESTAMP                
P805CS****          AND FI.PROC_STATUS_CD    = 'AC'                             
                                                                        
P805CS            ORDER BY 5 DESC                                       
P805CS                    ,4 DESC                                       
P805CS                    ,3 ASC                                        
                    FOR READ ONLY                               
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE FIXED_FCTR_CUR CURSOR FOR                                 
MFA-TR*          SELECT SF.FACTOR_TYPE                                          
MFA-TR*                ,SF.FACTOR_ID                                            
MFA-TR*                ,SF.FACTOR_TEXT                                          
MFA-TR*                ,FF.EFF_DATE_FROM                                        
MFA-TR*                ,FF.EFF_DATE_TO                                          
MFA-TR*                ,FF.DURATION_REMAIN_NO                                   
MFA-TR*                ,FF.FACTOR                                               
MFA-TR*                ,SF.FCTR_POWER_10                                        
MFA-TR*                ,SF.VERS_PRORATE_CD                                      
MFA-TR*                ,FI.OPT_DESC_INT                                         
MFA-TR*                ,DF.AUTO_REN_OPT_IN_FL                                   
MFA-TR*                ,DF.RT_PKG_OPT_SEQ_NO                                    
MFA-TR*                ,SF.DURATION_TYPE_CD                                     
MFA-TR*            FROM CSS_FIXED_FCTR     FF                                   
MFA-TR*                ,CSS_SPCL_FCTR      SF                                   
MFA-TR*                ,CSS_ACCT_RTPK_AGR  DF                                   
MFA-TR*                ,CSS_UTIL_ENVRNMT   UT                                   
MFA-TR*                ,CRM_RT_PKG_OPTION  FI                                   
MFA-TR*           WHERE DF.ACCOUNT_NO        = :DF-ACCOUNT-NO                   
MFA-TR*             AND DF.CODE_UTIL_TYPE    = :DF-CODE-UTIL-TYPE               
MFA-TR*             AND DF.IC_NO             = :DF-IC-NO                        
MFA-TR*             AND DF.STATUS_CD        IN ('A','O','R')                    
MFA-TR*             AND UT.ACCOUNT_NO        = DF.ACCOUNT_NO                    
MFA-TR*             AND UT.CODE_UTIL_TYPE    = DF.CODE_UTIL_TYPE                
MFA-TR*             AND UT.IC_NO             = DF.IC_NO                         
MFA-TR*             AND UT.RT_PKG_OPT_SEQ_NO = DF.RT_PKG_OPT_SEQ_NO             
MFA-TR*             AND FF.RT_PKG_OPT_SEQ_NO = DF.RT_PKG_OPT_SEQ_NO             
MFA-TR*             AND FF.ACCOUNT_NO        = DF.ACCOUNT_NO                    
MFA-TR*             AND FF.CODE_UTIL_TYPE    = DF.CODE_UTIL_TYPE                
MFA-TR*             AND FF.IC_NO             = DF.IC_NO                         
MFA-TR*             AND SF.FACTOR_ID         = FF.FACTOR_ID                     
MFA-TR*             AND SF.FACTOR_TYPE      IN ('B','F')                        
MFA-TR*             AND SF.RT_ATTR_INCTV_TYPE <> 'ADJUSTABLE RATE'              
MFA-TR*             AND FI.OPTION_CD         = DF.OPTION_CD                     
MFA-TR*             AND FI.COMPANY_NO        = '01'                             
MFA-TR*             AND FI.OPT_VSTART_TS    <= CURRENT TIMESTAMP                
MFA-TR*             AND FI.OPT_VEND_TS      >= CURRENT TIMESTAMP                
MFA-TR*             AND FI.PROC_STATUS_CD    = 'AC'                             
MFA-TR*                                                                         
MFA-TR****        UNION ALL                                                     
MFA-TR*                                                                         
MFA-TR****       SELECT SF.FACTOR_TYPE                                          
MFA-TR****             ,SF.FACTOR_ID                                            
MFA-TR****             ,SF.FACTOR_TEXT                                          
MFA-TR****             ,FF.EFF_DATE_FROM                                        
MFA-TR****             ,FF.EFF_DATE_TO                                          
MFA-TR****             ,FF.DURATION_REMAIN_NO                                   
MFA-TR****             ,FF.FACTOR                                               
MFA-TR****             ,SF.FCTR_POWER_10                                        
MFA-TR****             ,SF.VERS_PRORATE_CD                                      
MFA-TR****             ,FI.OPT_DESC_INT                                         
MFA-TR****             ,DF.AUTO_REN_OPT_IN_FL                                   
MFA-TR****             ,DF.RT_PKG_OPT_SEQ_NO                                    
MFA-TR****             ,SF.DURATION_TYPE_CD                                     
MFA-TR****         FROM CSS_FIXED_FCTR     FF                                   
MFA-TR****             ,CSS_SPCL_FCTR      SF                                   
MFA-TR****             ,CSS_ACCT_RTPK_AGR  DF                                   
MFA-TR****             ,CSS_UTIL_ENVRNMT   UT                                   
MFA-TR****             ,CRM_RT_PKG_OPTION  FI                                   
MFA-TR****        WHERE DF.ACCOUNT_NO        = :DF-ACCOUNT-NO                   
MFA-TR****          AND DF.CODE_UTIL_TYPE    = :DF-CODE-UTIL-TYPE               
MFA-TR****          AND DF.IC_NO             = :DF-IC-NO                        
MFA-TR****          AND UT.ACCOUNT_NO        = DF.ACCOUNT_NO                    
MFA-TR****          AND UT.CODE_UTIL_TYPE    = DF.CODE_UTIL_TYPE                
MFA-TR****          AND UT.IC_NO             = DF.IC_NO                         
MFA-TR****          AND UT.RT_PKG_OPT_SEQ_NO = DF.RT_PKG_OPT_SEQ_NO             
MFA-TR****          AND FF.ACCOUNT_NO        = DF.ACCOUNT_NO                    
MFA-TR****          AND FF.CODE_UTIL_TYPE    = DF.CODE_UTIL_TYPE                
MFA-TR****          AND FF.IC_NO             = DF.IC_NO                         
MFA-TR****          AND FF.EFF_DATE_FROM    <= CURRENT DATE                     
MFA-TR****          AND FF.EFF_DATE_TO      >= CURRENT DATE                     
MFA-TR****          AND FF.FACTOR_ID        IN                                  
MFA-TR****                (SELECT TRIM(SUBSTR(G6.PARM_DATA,35,9))               
MFA-TR****                   FROM CSS_JOB_PARM    G6                            
MFA-TR****                  WHERE G6.PROGRAM_NAME = 'CPD00444'                  
MFA-TR****                    AND G6.COMPANY_NO   = '01'                        
MFA-TR****                    AND G6.CMND_CODE    = 'PARM'                      
MFA-TR****                    AND G6.STATUS       = 'A'                         
MFA-TR****                    AND SUBSTR(G6.PARM_DATA,1,14)                     
MFA-TR****                                        = 'DISCOUNT_TYPE=')           
MFA-TR****          AND SF.FACTOR_ID         = FF.FACTOR_ID                     
MFA-TR****          AND FI.OPTION_CD         = DF.OPTION_CD                     
MFA-TR****          AND FI.COMPANY_NO        = '01'                             
MFA-TR****          AND FI.OPT_VSTART_TS    <= CURRENT TIMESTAMP                
MFA-TR****          AND FI.OPT_VEND_TS      >= CURRENT TIMESTAMP                
MFA-TR****          AND FI.PROC_STATUS_CD    = 'AC'                             
MFA-TR*                                                                         
MFA-TR*           ORDER BY 5 DESC                                               
MFA-TR*                   ,4 DESC                                               
MFA-TR*                   ,3 ASC                                                
MFA-TR*             FOR FETCH ONLY WITH UR                                      
MFA-TR*         QUERYNO 7000                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * DECLARE CURSOR TO RETRIEVE THE ROWS FOR PENDING STATUS AND     *        
      * FACTOR TYPE SHOULD BE FIXED FACTOR / COMBO FIXED.              *        
      ******************************************************************        
           EXEC SQL                                                     
              DECLARE PEND_FIXED_FCTR_CUR CURSOR FOR                    
                 SELECT SF.FACTOR_TYPE                                  
                       ,SF.FACTOR_ID                                    
                       ,SF.FACTOR_TEXT                                  
                       ,FF.EFF_DATE_FROM                                
                       ,FF.EFF_DATE_TO                                  
                       ,FF.DURATION_REMAIN_NO                           
                       ,FF.FACTOR                                       
                       ,SF.FCTR_POWER_10                                
                       ,SF.VERS_PRORATE_CD                              
                       ,FI.OPT_DESC_INT                                 
                       ,DF.STATUS_EFF_REV_MTH                           
P00892                 ,DF.AUTO_REN_OPT_IN_FL                           
P00892                 ,DF.RT_PKG_OPT_SEQ_NO                            
ACT255                 ,SF.DURATION_TYPE_CD                             
                   FROM CSS_FIXED_FCTR     FF WITH(READUNCOMMITTED)             
                       ,CSS_SPCL_FCTR      SF WITH(READUNCOMMITTED)             
                       ,CSS_ACCT_RTPK_AGR  DF WITH(READUNCOMMITTED)             
                       ,CRM_RT_PKG_OPTION  FI WITH(READUNCOMMITTED)             
                  WHERE DF.ACCOUNT_NO        = :DF-ACCOUNT-NO           
                    AND DF.CODE_UTIL_TYPE    = :DF-CODE-UTIL-TYPE       
                    AND DF.IC_NO             = :DF-IC-NO                
                    AND DF.STATUS_CD         = :DF-STATUS-CD            
                    AND FF.RT_PKG_OPT_SEQ_NO = DF.RT_PKG_OPT_SEQ_NO     
                    AND FF.ACCOUNT_NO        = DF.ACCOUNT_NO            
                    AND FF.CODE_UTIL_TYPE    = DF.CODE_UTIL_TYPE        
                    AND FF.IC_NO             = DF.IC_NO                 
                    AND SF.FACTOR_ID         = FF.FACTOR_ID             
                    AND SF.FACTOR_TYPE      IN ('B','F')                
                    AND SF.RT_ATTR_INCTV_TYPE <> 'ADJUSTABLE RATE'      
                    AND FI.OPTION_CD         = DF.OPTION_CD             
                    AND FI.COMPANY_NO        = '01'                     
                    AND FI.OPT_VSTART_TS    <= CIS.CURRENT$TIMESTAMP()        
                    AND FI.OPT_VEND_TS      >= CIS.CURRENT$TIMESTAMP()        
                    AND FI.PROC_STATUS_CD    = 'AC'                     
                  ORDER BY FF.EFF_DATE_TO DESC                          
                          ,FF.EFF_DATE_FROM DESC                        
                          ,SF.FACTOR_TEXT ASC                           
                    FOR READ ONLY                               
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE PEND_FIXED_FCTR_CUR CURSOR FOR                            
MFA-TR*          SELECT SF.FACTOR_TYPE                                          
MFA-TR*                ,SF.FACTOR_ID                                            
MFA-TR*                ,SF.FACTOR_TEXT                                          
MFA-TR*                ,FF.EFF_DATE_FROM                                        
MFA-TR*                ,FF.EFF_DATE_TO                                          
MFA-TR*                ,FF.DURATION_REMAIN_NO                                   
MFA-TR*                ,FF.FACTOR                                               
MFA-TR*                ,SF.FCTR_POWER_10                                        
MFA-TR*                ,SF.VERS_PRORATE_CD                                      
MFA-TR*                ,FI.OPT_DESC_INT                                         
MFA-TR*                ,DF.STATUS_EFF_REV_MTH                                   
MFA-TR*                ,DF.AUTO_REN_OPT_IN_FL                                   
MFA-TR*                ,DF.RT_PKG_OPT_SEQ_NO                                    
MFA-TR*                ,SF.DURATION_TYPE_CD                                     
MFA-TR*            FROM CSS_FIXED_FCTR     FF                                   
MFA-TR*                ,CSS_SPCL_FCTR      SF                                   
MFA-TR*                ,CSS_ACCT_RTPK_AGR  DF                                   
MFA-TR*                ,CRM_RT_PKG_OPTION  FI                                   
MFA-TR*           WHERE DF.ACCOUNT_NO        = :DF-ACCOUNT-NO                   
MFA-TR*             AND DF.CODE_UTIL_TYPE    = :DF-CODE-UTIL-TYPE               
MFA-TR*             AND DF.IC_NO             = :DF-IC-NO                        
MFA-TR*             AND DF.STATUS_CD         = :DF-STATUS-CD                    
MFA-TR*             AND FF.RT_PKG_OPT_SEQ_NO = DF.RT_PKG_OPT_SEQ_NO             
MFA-TR*             AND FF.ACCOUNT_NO        = DF.ACCOUNT_NO                    
MFA-TR*             AND FF.CODE_UTIL_TYPE    = DF.CODE_UTIL_TYPE                
MFA-TR*             AND FF.IC_NO             = DF.IC_NO                         
MFA-TR*             AND SF.FACTOR_ID         = FF.FACTOR_ID                     
MFA-TR*             AND SF.FACTOR_TYPE      IN ('B','F')                        
MFA-TR*             AND SF.RT_ATTR_INCTV_TYPE <> 'ADJUSTABLE RATE'              
MFA-TR*             AND FI.OPTION_CD         = DF.OPTION_CD                     
MFA-TR*             AND FI.COMPANY_NO        = '01'                             
MFA-TR*             AND FI.OPT_VSTART_TS    <= CURRENT TIMESTAMP                
MFA-TR*             AND FI.OPT_VEND_TS      >= CURRENT TIMESTAMP                
MFA-TR*             AND FI.PROC_STATUS_CD    = 'AC'                             
MFA-TR*           ORDER BY FF.EFF_DATE_TO DESC                                  
MFA-TR*                   ,FF.EFF_DATE_FROM DESC                                
MFA-TR*                   ,SF.FACTOR_TEXT ASC                                   
MFA-TR*             FOR FETCH ONLY WITH UR                                      
MFA-TR*         QUERYNO 7300                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
COB305 01 PARM-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.              
       01  PARM-CODE-UTIL-TYPE  PIC X(01).                              
       01  PARM-IC-NO           PIC S9(4) USAGE COMP.                   
       01  PARM-STATUS-CD       PIC X(01).                              
                                                                        
       PROCEDURE DIVISION USING PARM-ACCOUNT-NO                         
                                PARM-CODE-UTIL-TYPE                     
                                PARM-IC-NO                              
                                PARM-STATUS-CD.                         
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1   THRU 0100A-EXIT.              
           PERFORM 0100B-DECLARE-GTT-R2   THRU 0100B-EXIT.              
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100A-DECLARE-GTT-R1                                           *        
      ******************************************************************        
       0100A-DECLARE-GTT-R1.                                            
           MOVE 'SESSION.CSR04661_R1'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04661_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04661_R1
              (                                                       
                    RETURN_CODE                INT                  
                   ,APPL_RETURN_CODE           INT                  
                   ,FACTOR_TYPE CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                 
                   ,FACTOR_ID CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,FACTOR_DESC CHAR(20)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                 
                   ,START_DATE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,END_DATE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,DURATION_REM_NO CHAR(04)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                 
                   ,FACTOR                     DECIMAL(13,4)            
                   ,APPL_METHOD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                 
                   ,SWITCH_EXIT_FEE            DECIMAL(11,6)            
                   ,RATE_CHNG_EXIT_FEE         DECIMAL(11,6)            
                   ,OPTION_DESC CHAR(50)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                 
                   ,CALC_END_DATE CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                 
P00892             ,AUTO_REN_OPT_IN_FL CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                 
P00892             ,RT_PKG_OPT_SEQ_NO          SMALLINT                 
                )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS    THRU 8000A-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100A'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT R1'         TO ABEND-FUNCTION        
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,LTRIM(RTRIM(FACTOR_TYPE))        AS FACTOR_TYPE         
                      ,LTRIM(RTRIM(FACTOR_ID))          AS FACTOR_ID           
                      ,LTRIM(RTRIM(FACTOR_DESC))        AS FACTOR_DESC         
                      ,LTRIM(RTRIM(START_DATE))         AS START_DATE          
                      ,LTRIM(RTRIM(END_DATE))           AS END_DATE            
                      ,LTRIM(RTRIM(DURATION_REM_NO))    AS DURATION_REM        
                      ,FACTOR                    AS FACTOR              
                      ,LTRIM(RTRIM(APPL_METHOD))        AS APPL_METHOD         
                      ,SWITCH_EXIT_FEE           AS SWITCH_EXIT_FEE     
                      ,RATE_CHNG_EXIT_FEE        AS RATE_CHNG_EXIT_FEE  
                      ,LTRIM(RTRIM(OPTION_DESC))        AS OPTION_DESC         
                      ,LTRIM(RTRIM(CALC_END_DATE))      AS CALC_END_DATE       
P00892                ,AUTO_REN_OPT_IN_FL        AS AUTO_REN_OPT_IN_FL  
P00892                ,RT_PKG_OPT_SEQ_NO         AS RT_PKG_OPT_SEQ_NO   
                  FROM #CSR04661_R1                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,STRIP(FACTOR_TYPE)        AS FACTOR_TYPE                 
MFA-TR*               ,STRIP(FACTOR_ID)          AS FACTOR_ID                   
MFA-TR*               ,STRIP(FACTOR_DESC)        AS FACTOR_DESC                 
MFA-TR*               ,STRIP(START_DATE)         AS START_DATE                  
MFA-TR*               ,STRIP(END_DATE)           AS END_DATE                    
MFA-TR*               ,STRIP(DURATION_REM_NO)    AS DURATION_REM                
MFA-TR*               ,FACTOR                    AS FACTOR                      
MFA-TR*               ,STRIP(APPL_METHOD)        AS APPL_METHOD                 
MFA-TR*               ,SWITCH_EXIT_FEE           AS SWITCH_EXIT_FEE             
MFA-TR*               ,RATE_CHNG_EXIT_FEE        AS RATE_CHNG_EXIT_FEE          
MFA-TR*               ,STRIP(OPTION_DESC)        AS OPTION_DESC                 
MFA-TR*               ,STRIP(CALC_END_DATE)      AS CALC_END_DATE               
MFA-TR*               ,AUTO_REN_OPT_IN_FL        AS AUTO_REN_OPT_IN_FL          
MFA-TR*               ,RT_PKG_OPT_SEQ_NO         AS RT_PKG_OPT_SEQ_NO           
MFA-TR*           FROM SESSION.CSR04661_R1                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100B-DECLARE-GTT-R2                                           *        
      ******************************************************************        
       0100B-DECLARE-GTT-R2.                                            
                                                                        
           MOVE 'SESSION.CSR04661_R2'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04661_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04661_R2
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,BUS_RULE_ID CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BUS_RULE_RESULT_CD CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BUS_RULE_XREF_ID CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000B-DEL-GTT-ROWS    THRU 8000B-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100B'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT R2'         TO ABEND-FUNCTION        
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C2 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,LTRIM(RTRIM(BUS_RULE_ID))          AS BUS_RULE_ID       
                      ,LTRIM(RTRIM(BUS_RULE_RESULT_CD))   AS 
           BUS_RULE_RESULT_CD
                      ,LTRIM(RTRIM(BUS_RULE_XREF_ID))     AS 
           BUS_RULE_XREF_ID  
                  FROM #CSR04661_R2                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C2 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,STRIP(BUS_RULE_ID)          AS BUS_RULE_ID               
MFA-TR*               ,STRIP(BUS_RULE_RESULT_CD)   AS BUS_RULE_RESULT_CD        
MFA-TR*               ,STRIP(BUS_RULE_XREF_ID)     AS BUS_RULE_XREF_ID          
MFA-TR*           FROM SESSION.CSR04661_R2                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100B-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-ACCOUNT-NO             TO DF-ACCOUNT-NO            
                                               AT-ACCOUNT-NO            
                                               WS-ACCT-NO-4114.         
           MOVE PARM-CODE-UTIL-TYPE         TO DF-CODE-UTIL-TYPE.       
           MOVE PARM-IC-NO                  TO DF-IC-NO.                
           MOVE PARM-STATUS-CD              TO DF-STATUS-CD             
                                               WS-RTPK-AGR-STAT-4114.   
           MOVE 'EXIT FEE'                  TO WS-INCTV-TYPE-4114.      
                                                                        
           PERFORM 1100-VALIDATE-INPUT         THRU 1100-EXIT.          
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * BASIC INPUT VALIDATION FOR ACCOUNT NO / UTIL TYPE/ IC NO      *         
      *****************************************************************         
       1100-VALIDATE-INPUT.                                             
                                                                        
           IF DF-ACCOUNT-NO > WS-ZERO AND DF-CODE-UTIL-TYPE > SPACES    
                                 AND DF-IC-NO > WS-ZERO                 
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE '1100'                  TO ACTIVE-PARAGRAPH          
              MOVE 'RECEIVE INPUT'         TO ABEND-FUNCTION            
              MOVE SPACES                  TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
              MOVE SPACES                  TO TABLE-1                   
              MOVE SPACES                  TO TABLE-ELEMENT-1           
              MOVE SPACES                  TO HOSTVAR-ELEMENT-1         
      **********************************************************                
      *      IF PASSED INPUT VALUES ARE INVALID                *                
      **********************************************************                
              MOVE     0                   TO S-RETURN-CODE-1           
              MOVE +1000                   TO S-APPL-RETURN-CODE-1      
              PERFORM 8010-INSERT-GTT-R1      THRU 8010-EXIT            
              PERFORM 9999-END-PROGRAM        THRU 9999-EXIT            
           END-IF.                                                      
                                                                        
       1100-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2200-DETERMINE-OPERATION    THRU 2200-EXIT.          
                                                                        
           IF CTR-ROWS-RS1  EQUAL WS-ZERO                               
              MOVE 'MRM0000036'             TO S-RS2-BUS-RULE-ID        
              MOVE WS-FAILED                TO S-RS2-BUS-RULE-RESULT-CD 
              PERFORM 7550-GET-RULE-XREF-ID    THRU 7550-EXIT           
              PERFORM 8020-INSERT-GTT-R2       THRU 8020-EXIT           
           END-IF.                                                      
                                                                        
P805CS     PERFORM 2600-PROCESS-CSC-DISCOUNTS  THRU 2600-EXIT.          
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      *  2200-DETERMINE-OPERATION.                                     *        
      ******************************************************************        
       2200-DETERMINE-OPERATION.                                        
      *                                                                         
           PERFORM 2300-GET-EXIT-FEE-DET       THRU 2300-EXIT.          
      *                                                                         
           PERFORM 7010-GET-ACCOUNT-DETAIL     THRU 7010-EXIT.          
      *                                                                         
           IF AT-BILL-CYCLE EQUAL WS-99                                 
              MOVE WS-01                    TO BN-BILL-CYCLE            
           ELSE                                                         
              MOVE AT-BILL-CYCLE            TO BN-BILL-CYCLE            
           END-IF                                                       
      *                                                                         
           IF DF-STATUS-CD EQUAL WS-PENDING                             
              PERFORM 7300-OPEN-PEND-FIXED-FCTR  THRU 7300-EXIT         
              PERFORM 7400-FETCH-PEND-FIXED-FCTR THRU 7400-EXIT         
              MOVE AT-REV-MTH-LST-NRML      TO WS-REVENUE-MONTH         
              PERFORM 2400-BUILD-RESULT-SET      THRU 2400-EXIT         
                                                 UNTIL NO-MORE-ROWS     
              PERFORM 7500-CLOSE-PEND-FIXED-FCTR THRU 7500-EXIT         
           ELSE                                                         
              MOVE WS-NO                    TO WS-PENDING-STATUS        
      *                                                                         
              IF AT-REV-MTH-LST-NRML EQUAL ZERO                         
                 PERFORM 2221-GETNXT-RVMON-BILDAT   THRU 2221-EXIT      
              ELSE                                                      
                 MOVE AT-REV-MTH-LST-NRML   TO WS-REVENUE-MONTH         
              END-IF                                                    
      *                                                                         
              PERFORM 7000-OPEN-FIXED-FCTR-CUR   THRU 7000-EXIT         
              PERFORM 7100-FETCH-FIXED-FCTR-CUR  THRU 7100-EXIT         
              PERFORM 2400-BUILD-RESULT-SET      THRU 2400-EXIT         
                                                 UNTIL NO-MORE-ROWS     
              PERFORM 7200-CLOSE-FIXED-FCTR-CUR  THRU 7200-EXIT         
           END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      *  2221-GETNXT-RVMON-BILDAT                                      *        
      ******************************************************************        
       2221-GETNXT-RVMON-BILDAT.                                        
      *                                                                         
      *IF ACCOUNT IS NOT YET BILLED(AT-REV-MTH-LST-NRML=0),REVENUE              
      *MONTH FROM JOB_PARM TABLE WILL CONSIDERED TO CALCULATE THE               
      *CALCULATED END DATE.                                                     
      *                                                                         
           PERFORM 6001-GET-JPARM-REVMON                                
                                                 THRU 6001-EXIT.        
           MOVE WS-REVENUE-MONTH-PARM       TO WS-REV-MONTH1.           
                                                                        
           MOVE WS-REV-MNTH                 TO WS-REVENUE-MONTH.        
      *                                                                         
      *                                                                         
       2221-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * GETTING EXIT FEE / RATE CHANGE EXIT FEE FROM CPD04114 CPYC.    *        
      * 2300-GET-EXIT-FEE-DET.                                         *        
      ******************************************************************        
       2300-GET-EXIT-FEE-DET.                                           
                                                                        
           INITIALIZE                       WS-INPUT-DATE-4114          
                                            WS-REV-MTH-4114             
                                                                        
           PERFORM 6000-GET-PRO-INCTV-CPD4114  THRU                     
                   6000-CPD4114-EXIT                                    
           IF NO-ERRORS-4114                                            
              MOVE WS-EXIT-FEE-4114         TO S-SWITCH-EXIT-FEE        
              MOVE WS-RATE-CHNG-EXIT-FEE-4114                           
                                            TO S-RATE-CHNG-EXIT-FEE     
           ELSE                                                         
              MOVE WS-ZERO                  TO S-SWITCH-EXIT-FEE        
              MOVE WS-ZERO                  TO S-RATE-CHNG-EXIT-FEE     
           END-IF.                                                      
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      *  2400-BUILD-RESULT-SET.                                                 
      ******************************************************************        
       2400-BUILD-RESULT-SET.                                           
                                                                        
           IF WS-IND-DATE-FROM EQUAL WS-YES-NULL                        
              MOVE SPACES                   TO FF-EFF-DATE-FROM         
           END-IF.                                                      
                                                                        
           IF WS-IND-DATE-TO EQUAL WS-YES-NULL                          
              MOVE SPACES                   TO FF-EFF-DATE-TO           
           END-IF.                                                      
                                                                        
           IF WS-IND-DUR-REM-NO EQUAL WS-YES-NULL                       
               MOVE 'N/A'                   TO WS-DURATION-REM-NO       
           ELSE                                                         
               MOVE FF-DURATION-REMAIN-NO   TO WS-DUR-RMN-NO-TEMP-1     
               MOVE WS-DUR-RMN-NO-TEMP-1    TO WS-DUR-RMN-NO-TEMP-2     
               MOVE WS-DUR-RMN-NO-TEMP-2    TO WS-DURATION-REM-NO       
           END-IF.                                                      
      *                                                                         
           MOVE FF-DURATION-REMAIN-NO       TO WS-CALC-REM-MONTHS.      
      *                                                                         
           IF AT-REV-MTH-LST-NRML = ZERO OR PENDING-STATUS              
              SUBTRACT 01 FROM FF-DURATION-REMAIN-NO                    
                                        GIVING WS-CALC-REM-MONTHS       
           END-IF.                                                      
      *                                                                         
ACT255     IF SF-DURATION-TYPE-CD EQUAL SPACES                          
ACT255        MOVE FF-EFF-DATE-TO              TO S-CALC-END-DATE       
ACT255     ELSE                                                         
ACT255        PERFORM 2500-GET-CALC-END-MONTH        THRU 2500-EXIT     
ACT255        PERFORM 7800-GET-NEXT-BILL-DATE        THRU 7800-EXIT     
ACT255        IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
ACT255           MOVE SPACES                   TO S-CALC-END-DATE       
ACT255           MOVE ZEROES                   TO WS-ACTIVE-RETURN-CODE 
ACT255                                            S-RETURN-CODE-1       
ACT255        ELSE                                                      
ACT255           MOVE BN-DATE-EXTRACT          TO S-CALC-END-DATE       
ACT255        END-IF                                                    
ACT255     END-IF.                                                      
      *                                                                         
                                                                        
           IF SF-FCTR-POWER-10 NOT EQUAL WS-ZERO                        
              COMPUTE WS-FACTOR-FF = FF-FACTOR * 10** SF-FCTR-POWER-10  
              MOVE WS-FACTOR-FF             TO FF-FACTOR                
              MOVE WS-ZERO                  TO SF-FCTR-POWER-10         
           END-IF.                                                      
      *                                                                         
                                                                        
           MOVE SF-FACTOR-TYPE              TO S-FACTOR-TYPE.           
           MOVE SF-FACTOR-ID                TO S-FACTOR-ID.             
           MOVE SF-FACTOR-TEXT              TO S-FACTOR-DESC.           
           MOVE FF-EFF-DATE-FROM            TO S-START-DATE.            
           MOVE FF-EFF-DATE-TO              TO S-END-DATE.              
           MOVE WS-DURATION-REM-NO          TO S-DURATION-REM-NO.       
           MOVE FF-FACTOR                   TO S-FACTOR.                
           MOVE SF-VERS-PRORATE-CD          TO S-APPL-METHOD.           
           MOVE FI-OPT-DESC-INT             TO S-OPTION-DESC.           
                                                                        
P00892     MOVE DF-AUTO-REN-OPT-IN-FL       TO S-AUTO-REN-OPT-IN-FL.    
P00892     MOVE DF-RT-PKG-OPT-SEQ-NO        TO S-RT-PKG-OPT-SEQ-NO .    
                                                                        
           PERFORM 8010-INSERT-GTT-R1             THRU 8010-EXIT.       
                                                                        
           IF PENDING-STATUS                                            
              PERFORM 7400-FETCH-PEND-FIXED-FCTR  THRU 7400-EXIT        
           ELSE                                                         
              PERFORM 7100-FETCH-FIXED-FCTR-CUR   THRU 7100-EXIT        
           END-IF.                                                      
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      *                                                                         
      * 2500-GET-CALC-END-MONTH.                                                
      *                                                                         
      ************************************************************              
       2500-GET-CALC-END-MONTH.                                         
      *                                                                         
           COMPUTE WS-CALC-END-MONTH =                                  
                   WS-REV-MONTH-MM   + WS-CALC-REM-MONTHS.              
           IF WS-CALC-END-MONTH    > 12                                 
              ADD      +1                   TO WS-REV-MONTH-YY          
              SUBTRACT +12                FROM WS-CALC-END-MONTH        
              IF WS-CALC-END-MONTH  EQUAL ZERO                          
                 ADD +1                     TO WS-CALC-END-MONTH        
              END-IF                                                    
              IF WS-CALC-END-MONTH > 12                                 
                 ADD      +1                TO WS-REV-MONTH-YY          
                 SUBTRACT +12             FROM WS-CALC-END-MONTH        
                 IF WS-REV-MONTH-MM EQUAL ZERO                          
                    ADD +1                  TO WS-CALC-END-MONTH        
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
           MOVE WS-CALC-END-MONTH           TO WS-REV-MONTH-MM.         
           MOVE WS-REVENUE-MONTH            TO BN-REVENUE-MONTH.        
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
P805CS*****************************************************************         
P805CS*** VALIDATE CSC DISOCUNT ELIGIBILITY                         ***         
P805CS*****************************************************************         
P805CS*                                                                         
P805CS 2600-PROCESS-CSC-DISCOUNTS.                                      
P805CS*                                                                         
P805CS     MOVE '2600'                       TO ACTIVE-PARAGRAPH.       
P805CS*                                                                         
P805CS     MOVE PARM-ACCOUNT-NO              TO WS-444-I-ACCT-NO.       
P805CS     MOVE PROGRAM-NAME                 TO WS-444-I-PGM-ID.        
P805CS     MOVE SPACES                       TO WS-444-I-USER-ID.       
P805CS*                                                                         
P805CS     PERFORM 6000-CPD444-CSC-DISCOUNT-ELIG                        
P805CS        THRU 6000-CPD444-EXIT.                                    
P805CS*                                                                         
P805CS     EVALUATE WS-ACTIVE-RETURN-CODE                               
P805CS         WHEN 0                                                   
P805CS            PERFORM VARYING WS-444-S FROM 1 BY 1                  
P805CS              UNTIL WS-444-S > 10                                 
P805CS                 OR WS-444-O-DISC-CD(WS-444-S) = SPACES           
P805CS               EVALUATE WS-444-O-DISC-CD(WS-444-S)                
P805CS                   WHEN 'PAPERLESS'                               
P805CS                     IF WS-444-O-ELIG-FL(WS-444-S) = 'Y'          
P805CS                        MOVE 'MRM0000160'                         
P805CS                                      TO S-RS2-BUS-RULE-ID        
P805CS                        MOVE WS-FAILED                            
P805CS                                      TO S-RS2-BUS-RULE-RESULT-CD 
P805CS                        PERFORM 7550-GET-RULE-XREF-ID             
P805CS                                         THRU 7550-EXIT           
P805CS                        PERFORM 8020-INSERT-GTT-R2                
P805CS                                         THRU 8020-EXIT           
P805CS                     END-IF                                       
P805CS                   WHEN 'AUTORENEW'                               
P805CS                     IF WS-444-O-ELIG-FL(WS-444-S) = 'Y'          
P805CS                        MOVE 'MRM0000161'                         
P805CS                                      TO S-RS2-BUS-RULE-ID        
P805CS                        MOVE WS-FAILED                            
P805CS                                      TO S-RS2-BUS-RULE-RESULT-CD 
P805CS                        PERFORM 7550-GET-RULE-XREF-ID             
P805CS                                         THRU 7550-EXIT           
P805CS                        PERFORM 8020-INSERT-GTT-R2                
P805CS                                         THRU 8020-EXIT           
P805CS                     END-IF                                       
P805CS               END-EVALUATE                                       
P805CS            END-PERFORM                                           
P805CS         WHEN 999                                                 
P805CS            CONTINUE                                              
P805CS         WHEN OTHER                                               
P805CS            PERFORM 6999-CPD444-ERROR-ROUTINE                     
P805CS               THRU 6999-CPD444-EXIT                              
P805CS     END-EVALUATE.                                                
P805CS*                                                                         
P805CS 2600-EXIT.                                                       
P805CS     EXIT.                                                        
P805CS*                                                                         
      ******************************************************************        
      * 6000-GET-PRO-INCTV-CPD04114                                    *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD04114                                                  
           END-EXEC.                                                            
                                                                        
P805CS*****************************************************************         
P805CS*** 6000-CPD444-CSC-DISCOUNT-ELIG THRU 6000-CPD444-EXIT       ***         
P805CS*****************************************************************         
P805CS*                                                                         
P805CS     EXEC SQL                                                     PCS03470
P805CS        INCLUDE CPD0444E                                          PCS03470
P805CS     END-EXEC.                                                            
P805CS*                                                                         
P805CS*****************************************************************         
P805CS*** ERROR ROUTINE FOR CPD0444E                                ***         
P805CS*****************************************************************         
P805CS*                                                                         
P805CS 6999-CPD444-ERROR-ROUTINE.                                       
P805CS*                                                                         
P805CS     PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT.          
P805CS*                                                                         
P805CS 6999-CPD444-EXIT.                                                
P805CS     EXIT.                                                        
P805CS*                                                                         
      ****************************************************************          
      *                                                             **          
      *  6001-GET-JPARM-REVMON                                      **          
      ****************************************************************          
       6001-GET-JPARM-REVMON.                                           
      *                                                                         
           MOVE SPACES                      TO WS-SYSIPT                
           MOVE 'COMMON'                    TO WS-PROGRAM               
           MOVE WS-DATE                     TO WS-COMMAND               
           MOVE ZEROS                       TO WS-SEQUENCE              
           MOVE WS-KEY-AREA                 TO E-FJC01-KEY              
      *                                                                         
           PERFORM 7600-START-FCSJC01             THRU  7600-EXIT       
      *                                                                         
           PERFORM 7610-READ-FCSJC01              THRU  7610-EXIT       
              UNTIL (REVENUE-MONTH AND INPUT-ACTIVE)                    
                    OR END-OF-SYSIPT                                    
      *                                                                         
           IF REVENUE-MONTH AND INPUT-ACTIVE                            
              PERFORM 7611-CLOSE                  THRU  7611-EXIT       
           ELSE                                                         
              MOVE SPACES                   TO ABEND-TABLES             
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '6001'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_JOB_PARM'           TO TABLE-1                  
              MOVE 'PROGRAM_NAME'           TO TABLE-ELEMENT-1          
              MOVE 'CMND_CODE'              TO TABLE-ELEMENT-2          
              MOVE 'STATUS'                 TO TABLE-ELEMENT-3          
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-4          
              MOVE WS-COMMON                TO HOSTVAR-ELEMENT-1        
              MOVE 'DATE'                   TO HOSTVAR-ELEMENT-2        
              MOVE 'A'                      TO HOSTVAR-ELEMENT-3        
              MOVE G6-COMPANY-NO            TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
      *                                                                         
       6001-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      ** ERROR ROUTINE FOR COPYBOOK CPD04114                         **         
      *****************************************************************         
       6999-ERROR-ROUTINE-CPD4114.                                      
                                                                        
           IF ERRORS-4114                                               
              EVALUATE WS-ACTIVE-RETURN-CODE                            
                  WHEN SUCCESSFUL-CALL                                  
                   CONTINUE                                             
                  WHEN NOT-FOUND                                        
                   CONTINUE                                             
                  WHEN OTHER                                            
                    MOVE PROGRAM-NAME           TO ABEND-PROGRAM        
                    MOVE '6100'                 TO ACTIVE-PARAGRAPH     
                    MOVE 'CPD04114'             TO ABEND-FUNCTION       
                    MOVE 'CSS_ACCOUNT'          TO TABLE-1              
                    MOVE 'CSS_ACCT_RTPK_AGR'    TO TABLE-2              
                    MOVE 'CSS_FIXED_FCTR'       TO TABLE-3              
                    MOVE 'CSS_SPCL_FCTR'        TO TABLE-4              
                    MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1      
                    MOVE 'CODE_UTIL_TYPE'       TO TABLE-ELEMENT-2      
                    MOVE 'IC_NO'                TO TABLE-ELEMENT-3      
                    MOVE DF-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1    
                    MOVE DF-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-2    
                    MOVE DF-IC-NO               TO HOSTVAR-ELEMENT-3    
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
              END-EVALUATE                                              
           END-IF.                                                      
                                                                        
       6999-CPD4114-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7000-OPEN-FIXED-FCTR-CUR.                                      *        
      ******************************************************************        
       7000-OPEN-FIXED-FCTR-CUR.                                        
                                                                        
           EXEC SQL                                                     
                OPEN FIXED_FCTR_CUR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1          
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7000'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE 'CSS_FIXED_FCTR  '       TO TABLE-1                  
              MOVE 'CSS_SPCL_FCTR   '       TO TABLE-2                  
              MOVE 'CSS_ACCT_RTPK_AG'       TO TABLE-3                  
              MOVE 'CSS_UTIL_ENVRNMT'       TO TABLE-4                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE DF-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE DF-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE DF-IC-NO                 TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT                
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7010-GET-ACCOUNT-DETAIL.                                       *        
      ******************************************************************        
       7010-GET-ACCOUNT-DETAIL.                                         
                                                                        
           EXEC SQL                                                     
              SELECT BILL_CYCLE                                         
                    ,REV_MTH_LST_NRML                                   
               INTO :AT-BILL-CYCLE                                      
                   ,:AT-REV-MTH-LST-NRML                                
               FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                           
               WHERE ACCOUNT_NO    = :AT-ACCOUNT-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BILL_CYCLE                                                 
MFA-TR*             ,REV_MTH_LST_NRML                                           
MFA-TR*        INTO :AT-BILL-CYCLE                                              
MFA-TR*            ,:AT-REV-MTH-LST-NRML                                        
MFA-TR*        FROM CSS_ACCOUNT                                                 
MFA-TR*        WHERE ACCOUNT_NO    = :AT-ACCOUNT-NO                             
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7010                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                         TO WS-ACTIVE-RETURN-CODE
                                                   S-RETURN-CODE-1.     
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME           TO ABEND-PROGRAM        
                    MOVE '7010'                 TO ACTIVE-PARAGRAPH     
                    MOVE 'SELECT'               TO ABEND-FUNCTION       
                    MOVE 'CSS_ACCOUNT     '     TO TABLE-1              
                    MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1      
                    MOVE AT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1    
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7030-GET-CURRENT-DATE                                          *        
      ******************************************************************        
       7030-GET-CURRENT-DATE.                                           
                                                                        
           EXEC SQL                                                     
                SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-DATE = CURRENT DATE                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1          
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7030'                 TO ACTIVE-PARAGRAPH           
              MOVE 'SELECT'               TO ABEND-FUNCTION             
              MOVE 'CURRENT DATE'         TO TABLE-1                    
              MOVE 'CURRENT_DATE'         TO TABLE-ELEMENT-1            
              PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT                
           END-IF.                                                      
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7100-FETCH-FIXED-FCTR-CUR.                                     *        
      ******************************************************************        
       7100-FETCH-FIXED-FCTR-CUR.                                       
                                                                        
           EXEC SQL                                                     
              FETCH FIXED_FCTR_CUR                                      
               INTO :SF-FACTOR-TYPE                                     
                   ,:SF-FACTOR-ID                                       
                   ,:SF-FACTOR-TEXT                                     
                   ,:FF-EFF-DATE-FROM :WS-IND-DATE-FROM                  
                   ,:FF-EFF-DATE-TO :WS-IND-DATE-TO                      
                   ,:FF-DURATION-REMAIN-NO :WS-IND-DUR-REM-NO            
                   ,:FF-FACTOR                                          
                   ,:SF-FCTR-POWER-10                                   
                   ,:SF-VERS-PRORATE-CD                                 
                   ,:FI-OPT-DESC-INT                                    
P00892             ,:DF-AUTO-REN-OPT-IN-FL                              
P00892             ,:DF-RT-PKG-OPT-SEQ-NO                               
ACT255             ,:SF-DURATION-TYPE-CD                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                         TO WS-ACTIVE-RETURN-CODE
                                                   S-RETURN-CODE-1      
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE WS-YES                 TO WS-NO-MORE-ROWS      
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME           TO ABEND-PROGRAM        
                    MOVE '7100'                 TO ACTIVE-PARAGRAPH     
                    MOVE 'FETCH'                TO ABEND-FUNCTION       
                    MOVE 'CSS_FIXED_FCTR  '     TO TABLE-1              
                    MOVE 'CSS_SPCL_FCTR   '     TO TABLE-2              
                    MOVE 'CSS_ACCT_RTPK_AG'     TO TABLE-3              
                    MOVE 'CSS_UTIL_ENVRNMT'     TO TABLE-4              
                    MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1      
                    MOVE 'CODE_UTIL_TYPE'       TO TABLE-ELEMENT-2      
                    MOVE 'IC_NO'                TO TABLE-ELEMENT-3      
                    MOVE DF-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1    
                    MOVE DF-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-2    
                    MOVE DF-IC-NO               TO HOSTVAR-ELEMENT-3    
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7200-CLOSE-FIXED-FCTR-CUR.                                     *        
      ******************************************************************        
       7200-CLOSE-FIXED-FCTR-CUR.                                       
                                                                        
           EXEC SQL                                                     
                CLOSE FIXED_FCTR_CUR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1          
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7200'                 TO ACTIVE-PARAGRAPH           
              MOVE 'CLOSE'                TO ABEND-FUNCTION             
              MOVE 'CSS_FIXED_FCTR  '     TO TABLE-1                    
              MOVE 'CSS_SPCL_FCTR   '     TO TABLE-2                    
              MOVE 'CSS_ACCT_RTPK_AG'     TO TABLE-3                    
              MOVE 'CSS_UTIL_ENVRNMT'     TO TABLE-4                    
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
              MOVE 'CODE_UTIL_TYPE'       TO TABLE-ELEMENT-2            
              MOVE 'IC_NO'                TO TABLE-ELEMENT-3            
              MOVE DF-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
              MOVE DF-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-2          
              MOVE DF-IC-NO               TO HOSTVAR-ELEMENT-3          
              PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT                
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7300-OPEN-PEND-FIXED-FCTR.                                     *        
      ******************************************************************        
       7300-OPEN-PEND-FIXED-FCTR.                                       
                                                                        
           EXEC SQL                                                     
                OPEN PEND_FIXED_FCTR_CUR                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1          
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7300'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE 'CSS_FIXED_FCTR  '       TO TABLE-1                  
              MOVE 'CSS_SPCL_FCTR   '       TO TABLE-2                  
              MOVE 'CSS_ACCT_RTPK_AG'       TO TABLE-3                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE 'STATUS_CD'              TO TABLE-ELEMENT-4          
              MOVE DF-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE DF-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE DF-IC-NO                 TO HOSTVAR-ELEMENT-3        
              MOVE DF-STATUS-CD             TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT                
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7400-FETCH-PEND-FIXED-FCTR.                                    *        
      ******************************************************************        
       7400-FETCH-PEND-FIXED-FCTR.                                      
                                                                        
           EXEC SQL                                                     
              FETCH PEND_FIXED_FCTR_CUR                                 
               INTO :SF-FACTOR-TYPE                                     
                   ,:SF-FACTOR-ID                                       
                   ,:SF-FACTOR-TEXT                                     
                   ,:FF-EFF-DATE-FROM :WS-IND-DATE-FROM                  
                   ,:FF-EFF-DATE-TO :WS-IND-DATE-TO                      
                   ,:FF-DURATION-REMAIN-NO :WS-IND-DUR-REM-NO            
                   ,:FF-FACTOR                                          
                   ,:SF-FCTR-POWER-10                                   
                   ,:SF-VERS-PRORATE-CD                                 
                   ,:FI-OPT-DESC-INT                                    
                   ,:DF-STATUS-EFF-REV-MTH                              
P00892             ,:DF-AUTO-REN-OPT-IN-FL                              
P00892             ,:DF-RT-PKG-OPT-SEQ-NO                               
ACT255             ,:SF-DURATION-TYPE-CD                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                         TO WS-ACTIVE-RETURN-CODE
                                                   S-RETURN-CODE-1      
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE WS-YES                 TO WS-NO-MORE-ROWS      
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME           TO ABEND-PROGRAM        
                    MOVE '7400'                 TO ACTIVE-PARAGRAPH     
                    MOVE 'FETCH'                TO ABEND-FUNCTION       
                    MOVE 'CSS_FIXED_FCTR  '     TO TABLE-1              
                    MOVE 'CSS_SPCL_FCTR   '     TO TABLE-2              
                    MOVE 'CSS_ACCT_RTPK_AG'     TO TABLE-3              
                    MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1      
                    MOVE 'CODE_UTIL_TYPE'       TO TABLE-ELEMENT-2      
                    MOVE 'IC_NO'                TO TABLE-ELEMENT-3      
                    MOVE 'STATUS_CD'            TO TABLE-ELEMENT-4      
                    MOVE DF-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1    
                    MOVE DF-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-2    
                    MOVE DF-IC-NO               TO HOSTVAR-ELEMENT-3    
                    MOVE DF-STATUS-CD           TO TABLE-ELEMENT-4      
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7500-CLOSE-PEND-FIXED-FCTR.                                    *        
      ******************************************************************        
       7500-CLOSE-PEND-FIXED-FCTR.                                      
                                                                        
           EXEC SQL                                                     
                CLOSE PEND_FIXED_FCTR_CUR                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1          
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7500'                 TO ACTIVE-PARAGRAPH           
              MOVE 'CLOSE'                TO ABEND-FUNCTION             
              MOVE 'CSS_FIXED_FCTR  '     TO TABLE-1                    
              MOVE 'CSS_SPCL_FCTR   '     TO TABLE-2                    
              MOVE 'CSS_ACCT_RTPK_AG'     TO TABLE-3                    
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
              MOVE 'CODE_UTIL_TYPE'       TO TABLE-ELEMENT-2            
              MOVE 'IC_NO'                TO TABLE-ELEMENT-3            
              MOVE 'STATUS_CD'            TO TABLE-ELEMENT-4            
              MOVE DF-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
              MOVE DF-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-2          
              MOVE DF-IC-NO               TO HOSTVAR-ELEMENT-3          
              MOVE DF-STATUS-CD           TO TABLE-ELEMENT-4            
              PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT                
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      *                                                                         
      * 7550-GET-RULE-XREF-ID                                                   
      *                                                                         
      ************************************************************              
       7550-GET-RULE-XREF-ID.                                           
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           BUS_RULE_XREF_ID, 121), ' ', '-'), ':', '.') 
           BUS_RULE_XREF_ID                                   
                INTO :S-RS2-BUS-RULE-XREF-ID                            
                FROM CSS_BUS_RULE   R WITH(READUNCOMMITTED)                     
                    ,CSS_BUS_RULE_XREF T WITH(READUNCOMMITTED)                  
               WHERE R.BUS_RULE_ID = :S-RS2-BUS-RULE-ID                 
                 AND R.BUS_RULE_ID = T.BUS_RULE_ID                      
                                             
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BUS_RULE_XREF_ID                                           
MFA-TR*         INTO :S-RS2-BUS-RULE-XREF-ID                                    
MFA-TR*         FROM CSS_BUS_RULE   R                                           
MFA-TR*             ,CSS_BUS_RULE_XREF T                                        
MFA-TR*        WHERE R.BUS_RULE_ID = :S-RS2-BUS-RULE-ID                         
MFA-TR*          AND R.BUS_RULE_ID = T.BUS_RULE_ID                              
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7550                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
               MOVE SPACES                  TO ABEND-TABLES             
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
               MOVE '7550'                  TO ACTIVE-PARAGRAPH         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE SQLCODE                 TO ABEND-SQLCODE            
               MOVE SQLSTATE                TO ABEND-SQLSTATE           
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_BUS_RULE'          TO TABLE-1                  
               MOVE 'BUS_RULE_ID'           TO TABLE-ELEMENT-1          
               MOVE S-RS2-BUS-RULE-ID       TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7800-GET-NEXT-BILL-DATE.                                       *        
      ******************************************************************        
       7800-GET-NEXT-BILL-DATE.                                         
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) DATE_EXTRACT                                     
                 INTO :BN-DATE-EXTRACT                                  
                 FROM  CSS_BILL_WINDOW WITH(READUNCOMMITTED)                    
                 WHERE BILL_CYCLE     = :BN-BILL-CYCLE                  
                 AND   REVENUE_MONTH  = :BN-REVENUE-MONTH               
                 AND   CODE_BILL_COND = 'R'                             
                 ORDER BY REV_CALC_CYCLE DESC                           
                                           
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT DATE_EXTRACT                                             
MFA-TR*          INTO :BN-DATE-EXTRACT                                          
MFA-TR*          FROM  CSS_BILL_WINDOW                                          
MFA-TR*          WHERE BILL_CYCLE     = :BN-BILL-CYCLE                          
MFA-TR*          AND   REVENUE_MONTH  = :BN-REVENUE-MONTH                       
MFA-TR*          AND   CODE_BILL_COND = 'R'                                     
MFA-TR*          ORDER BY REV_CALC_CYCLE DESC                                   
MFA-TR*          FETCH FIRST 1 ROW ONLY WITH UR                                 
MFA-TR*          QUERYNO 7800                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1          
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7800'                 TO ACTIVE-PARAGRAPH           
              MOVE 'SELECT'               TO ABEND-FUNCTION             
              MOVE 'CSS_BILL_WINDOW'      TO TABLE-1                    
              MOVE 'BILL_CYCLCE'          TO TABLE-ELEMENT-1            
              MOVE 'REVENUE_MONTH'        TO TABLE-ELEMENT-2            
              MOVE BN-BILL-CYCLE          TO HOSTVAR-ELEMENT-1          
              MOVE BN-REVENUE-MONTH       TO HOSTVAR-ELEMENT-2          
              PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT                
           END-IF.                                                      
                                                                        
       7800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8000A-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000A-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04661_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04661_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1          
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1          
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000A'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04661_R1'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       8000A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8000B-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000B-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04661_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04661_R2                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2             
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES          TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2             
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME    TO ABEND-PROGRAM               
                    MOVE SQLCODE         TO ABEND-SQLCODE               
                    MOVE SQLSTATE        TO ABEND-SQLSTATE              
                    MOVE '8000B'         TO ACTIVE-PARAGRAPH            
                    MOVE 'DELETE'        TO ABEND-FUNCTION              
                    MOVE SPACES          TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                    MOVE 'CSR04661_R2'   TO TABLE-1                     
                    MOVE SPACES          TO TABLE-ELEMENT-1             
                    MOVE SPACES          TO HOSTVAR-ELEMENT-1           
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       8000B-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8010-INSERT-GTT-R1.                                            *        
      ******************************************************************        
       8010-INSERT-GTT-R1.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04661_R1                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,FACTOR_TYPE                                          
                  ,FACTOR_ID                                            
                  ,FACTOR_DESC                                          
                  ,START_DATE                                           
                  ,END_DATE                                             
                  ,DURATION_REM_NO                                      
                  ,FACTOR                                               
                  ,APPL_METHOD                                          
                  ,SWITCH_EXIT_FEE                                      
                  ,RATE_CHNG_EXIT_FEE                                   
                  ,OPTION_DESC                                          
                  ,CALC_END_DATE                                        
P00892            ,AUTO_REN_OPT_IN_FL                                   
P00892            ,RT_PKG_OPT_SEQ_NO                                    
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-1                                     
                  ,:S-APPL-RETURN-CODE-1                                
                  ,:S-FACTOR-TYPE                                       
                  ,:S-FACTOR-ID                                         
                  ,:S-FACTOR-DESC                                       
                  ,:S-START-DATE                                        
                  ,:S-END-DATE                                          
                  ,:S-DURATION-REM-NO                                   
                  ,:S-FACTOR                                            
                  ,:S-APPL-METHOD                                       
                  ,:S-SWITCH-EXIT-FEE                                   
                  ,:S-RATE-CHNG-EXIT-FEE                                
                  ,:S-OPTION-DESC                                       
                  ,:S-CALC-END-DATE                                     
P00892            ,:S-AUTO-REN-OPT-IN-FL                                
P00892            ,:S-RT-PKG-OPT-SEQ-NO                                 
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04661_R1                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,FACTOR_TYPE                                                  
MFA-TR*           ,FACTOR_ID                                                    
MFA-TR*           ,FACTOR_DESC                                                  
MFA-TR*           ,START_DATE                                                   
MFA-TR*           ,END_DATE                                                     
MFA-TR*           ,DURATION_REM_NO                                              
MFA-TR*           ,FACTOR                                                       
MFA-TR*           ,APPL_METHOD                                                  
MFA-TR*           ,SWITCH_EXIT_FEE                                              
MFA-TR*           ,RATE_CHNG_EXIT_FEE                                           
MFA-TR*           ,OPTION_DESC                                                  
MFA-TR*           ,CALC_END_DATE                                                
MFA-TR*           ,AUTO_REN_OPT_IN_FL                                           
MFA-TR*           ,RT_PKG_OPT_SEQ_NO                                            
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-1                                             
MFA-TR*           ,:S-APPL-RETURN-CODE-1                                        
MFA-TR*           ,:S-FACTOR-TYPE                                               
MFA-TR*           ,:S-FACTOR-ID                                                 
MFA-TR*           ,:S-FACTOR-DESC                                               
MFA-TR*           ,:S-START-DATE                                                
MFA-TR*           ,:S-END-DATE                                                  
MFA-TR*           ,:S-DURATION-REM-NO                                           
MFA-TR*           ,:S-FACTOR                                                    
MFA-TR*           ,:S-APPL-METHOD                                               
MFA-TR*           ,:S-SWITCH-EXIT-FEE                                           
MFA-TR*           ,:S-RATE-CHNG-EXIT-FEE                                        
MFA-TR*           ,:S-OPTION-DESC                                               
MFA-TR*           ,:S-CALC-END-DATE                                             
MFA-TR*           ,:S-AUTO-REN-OPT-IN-FL                                        
MFA-TR*           ,:S-RT-PKG-OPT-SEQ-NO                                         
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1             
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R1 = 'Y'             
              ADD +1                     TO CTR-ROWS-RS1                
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8100'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE WS-YES                TO  WS-ERR-INSRT-R1            
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04661_R1'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       8010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8020-INSERT-GTT-R2.                                            *        
      ******************************************************************        
       8020-INSERT-GTT-R2.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04661_R2                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,BUS_RULE_ID                                          
                  ,BUS_RULE_RESULT_CD                                   
                  ,BUS_RULE_XREF_ID                                     
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-2                                     
                  ,:S-APPL-RETURN-CODE-2                                
                  ,:S-RS2-BUS-RULE-ID                                   
                  ,:S-RS2-BUS-RULE-RESULT-CD                            
                  ,:S-RS2-BUS-RULE-XREF-ID                              
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04661_R2                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,BUS_RULE_ID                                                  
MFA-TR*           ,BUS_RULE_RESULT_CD                                           
MFA-TR*           ,BUS_RULE_XREF_ID                                             
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-2                                             
MFA-TR*           ,:S-APPL-RETURN-CODE-2                                        
MFA-TR*           ,:S-RS2-BUS-RULE-ID                                           
MFA-TR*           ,:S-RS2-BUS-RULE-RESULT-CD                                    
MFA-TR*           ,:S-RS2-BUS-RULE-XREF-ID                                      
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R2 = 'Y'             
              ADD +1                     TO  CTR-ROWS-RS2               
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8200'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE WS-YES                TO  WS-ERR-INSRT-R2            
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04661_R2'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
        8020-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8800-CHECK-RESULTS.                                           *         
      *****************************************************************         
       8800-CHECK-RESULTS.                                              
                                                                        
           IF CTR-ROWS-RS1 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-1                            
              MOVE   0                       TO S-RETURN-CODE-1         
              MOVE 100                       TO S-APPL-RETURN-CODE-1    
              PERFORM 8010-INSERT-GTT-R1     THRU 8010-EXIT             
           END-IF.                                                      
      *                                                                         
           IF CTR-ROWS-RS2 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-2                            
              MOVE   0                       TO S-RETURN-CODE-2         
              MOVE   0                       TO S-APPL-RETURN-CODE-2    
              PERFORM 8020-INSERT-GTT-R2     THRU 8020-EXIT             
           END-IF.                                                      
      *                                                                         
       8800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 8900-SEND-DONE.                                                *        
      ******************************************************************        
       8900-SEND-DONE.                                                  
                                                                        
           MOVE PROGRAM-NAME          TO ABEND-PROGRAM                  
           MOVE '8900'                TO ACTIVE-PARAGRAPH               
           MOVE 'OPEN'                TO ABEND-FUNCTION                 
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE 'CSR04661_R1'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C2                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE 'CSR04661_R2'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 9000-SEND-ERROR-RESULT                                         *        
      ******************************************************************        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-1                               
                      GTT-RETURN-FIELDS-2.                              
           MOVE WS-ACTIVE-RETURN-CODE       TO ABEND-SQLCODE            
                                               S-RETURN-CODE-1          
                                               S-RETURN-CODE-2          
                                                                        
           MOVE WS-APPL-RETURN-CODE         TO S-APPL-RETURN-CODE-1     
                                               S-APPL-RETURN-CODE-2     
                                                                        
                                                                        
           MOVE SQLERRMC                    TO ABEND-SQLERRMC.          
                                                                        
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'               TO ABEND-FUNCTION           
           END-IF.                                                      
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1        THRU 0100A-EXIT.         
           PERFORM 0100B-DECLARE-GTT-R2        THRU 0100B-EXIT.         
                                                                        
           PERFORM 8010-INSERT-GTT-R1          THRU 8010-EXIT.          
           PERFORM 8020-INSERT-GTT-R2          THRU 8020-EXIT.          
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9700-ABEND-PROCESSING.                                         *        
      ******************************************************************        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT.             
           PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT.             
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 6001- TO GET JOB PARM DETAILS             *                             
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDCA038                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9999-END-PROGRAM.                                              *        
      ******************************************************************        
                                                                        
       9999-END-PROGRAM.                                                
                                                                        
            PERFORM 8800-CHECK-RESULTS THRU 8800-EXIT                   
            PERFORM 8900-SEND-DONE     THRU 8900-EXIT                   
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
