       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04660.                                          
       AUTHOR.       AMIRTHARAJ.                                        
COB303 DATE-WRITTEN. JAN 22,2014.                                       
       DATE-COMPILED.                                                   
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE:  CSR04660              --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--                                                            --         
      *--  CSR04660 :                                                --         
      *--                                                            --         
      *--  #  INVOKED FROM CRM APPL, INSERTS FACTORS TO CIS TABLES.  --         
      *--  #  THIS STORED PROCEDURE IS CLONED FROM CSR03984.         --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *--  PARAMETERS                                                --         
      *--                                                            --         
      *--      IN                                                    --         
      *--                                                            --         
      *--            APPL_PGMID                CHAR(08)              --         
      *--            ACTION_IND                CHAR(01)              --         
      *--            ACCOUNT_NO                DECIMAL(13,0)         --         
      *--            CODE_UTIL_TYPE            CHAR(01)              --         
      *--            IC_NO                     SMALLINT              --         
      *--            RTPK_OPT_SEQ_NO           SMALLINT              --         
      *--            OPTION_CD                 CHAR(12)              --         
      *--            OFFER_CD                  CHAR(12)              --         
      *--            TRANS_SEQ_ID              CHAR(04)              --         
      *--            PROMO_CD                  CHAR(12)              --         
      *--            COMM_CHANNEL              CHAR(02)              --         
      *--            CREATED_USER_ID           CHAR(07)              --         
      *--            PROCESS_CD                CHAR(01)              --         
      *--            OPT_AGRMT_EFF_DT          CHAR(10)              --         
      *--            OPT_AGRMT_EFF_TM          CHAR(08)              --         
      *--            PRCE_NEGOTIATED_CD        CHAR(01)              --         
      *--            EXIT_FEE_FLAG             CHAR(01)              --         
      *--            EXIT_FEE_AMT              CHAR(11)              --         
      *--            PREV_OPT_CODE             CHAR(12)              --         
      *--            RATE_PLAN_NO              CHAR(03)              --         
      *--            CUST_AGRD_THERM           CHAR(11)              --         
      *--            CODE_REV_CLASS            CHAR(03)              --         
      *--            TIER_ACCT_TYPE_CD         CHAR(01)              --         
      *--            TIER_CUST_STAT_CD         CHAR(01)              --         
      *--            MKT_TIER_RANKING          CHAR(04)              --         
      *--            MKT_TIER_START_DT         CHAR(10)              --         
P00892*--            AUTO_REN_OPT_IN_FL        CHAR(01)              --         
      *--                                                            --         
      *--      OUT                                                   --         
      *--            NONE                                            --         
      *--      INOUT                                                 --         
      *--            NONE                                            --         
      *--                                                            --         
      *--  CSR04660_R1 - BUS RULE DETAILS                            --         
      *--                                                            --         
      *--            RETURN_CODE               INTEGER               --         
      *--            APPL_RETURN_CODE          INTEGER               --         
      *--            IC_NO                     CHAR(04)              --         
      *--            BUS_RULE_ID               CHAR(10)              --         
      *--            BUS_RULE_RESULT_CD        CHAR(10)              --         
      *--            BUS_RULE_XREF_ID          CHAR(26)              --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                        MODIFICATION LOG                    --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
      *--  01/22/2014    AD7F921     INITIAL VERSION.                --         
P00892*--  04/24/2015    VIJAY       FIXED RATE AUTO RENEWAL CHANGES --         
ACT179*--  09/18/2015    VIJAY       ADD MNT TRANSACTION TO          --         
ACT179*--  A05136 - DEFECT9268       CSS_ACCT_RATE_HISTORY TO TRACK  --         
ACT179*--                            RTPKG CHANGES.                  --         
ACT086*--  02/19/2016    MUTHU       REMOVE THE DCLGEN COPYBOOK      --         
ACT086*--  A04860                    TBMFWQ FOR TABLE CSS_WQ_ITEMS_MF--         
      *----------------------------------------------------------------         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04660'.
MSQ017     COPY MFASQLM.
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_ACCOUNT, AT                                               *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBACCT                                                 
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_ACCT_ATTRIBUTE, YP                                        *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBACTATT                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_AR_CNTL, AC                                               *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBARCNTL                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_ACCT_RTPK_AGR, DF                                         *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBACCTRG                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_BILLING_DET, BG                                           *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBBLLDET                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_BILLING_HDR, BI                                           *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBBLLHDR                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_CNSMPTN_HIST, CX                                          *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBCNSMP                                                
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_CREDIT_HIST, CK                                                     
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBCRHIST                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_DELINQUENCY, C8                                           *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBDELQ                                                 
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_FIXED_FCTR, FF                                            *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBFXDFCT                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_FIXED_FCT_HIST, FH                                        *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBFXHST                                                
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CRM_RT_PKG_OPTION, FI                                                   
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBRTPKGO                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_JOB_PARM, G6                                              *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBJBPARM                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_MNT_TRANS_HIST, MH                                        *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBMNHIST                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_MT_TRN_HST_DET, MI                                        *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBMNHDT                                                
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CRM_OPT_ATTR_INCTV, HQ                                        *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBOPTATT                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_READ_WINDOW, RW                                           *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBRDWNDW                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CRM_RT_ATTR_INCTV, G7                                         *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBRTINCT                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_SPCL_FCTR, SF                                             *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBSPLFTR                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_SPCL_FCT_CMPNT, SK                                        *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBFCTCMP                                               
            END-EXEC.                                                           
      *****************************************************************         
      * CSS_SPCL_FCTR_APPL, SA                                        *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBSPLAPL                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_SPCL_FCTR_ATTR, SY                                                  
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBSPFCAT                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_USER_PROFILE, PF                                                    
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBUSRPRF                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_UTL_ENVRMNT , UT                                                    
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_CODE_VALUE   UV                                                     
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBCDVALU                                               
            END-EXEC.                                                           
                                                                        
ACT179*****************************************************************         
ACT179* CSS_ACCT_RATE_HIST 5H                                                   
ACT179*****************************************************************         
ACT179      EXEC SQL                                                            
ACT179           INCLUDE TBACRTHS                                               
ACT179      END-EXEC.                                                           
                                                                        
      ******************************************************************        
      *    SQL ERROR CHECKING COPYBOOK.                                *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS TO XFER DATA.                                    *        
      ******************************************************************        
           COPY CCA00001.                                                       
                                                                        
      ******************************************************************        
      *    WORKING STORAGE SUPPORT FOR 326.                            *        
      ******************************************************************        
           COPY CWS00326.                                                       
                                                                        
      ******************************************************************        
      *    WQ CREATION COPYBOOK.                                       *        
      ******************************************************************        
           COPY CWS0070B.                                                       
                                                                        
      *****************************************************************         
      * COPYBOOK FOR THE WORKING STORAGE THAT IS TUNED FOR BATCH      *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE CWS00327                                               
            END-EXEC.                                                           
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS00013                                                  
           END-EXEC.                                                            
                                                                        
      *    COPY CWS00010.                                                       
      ******************************************************************        
      *    ERROR HANDLING COPY BOOK.                                   *        
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
                                                                        
       01  WS-WORKING-STORAGE.                                          
           05 WS-SQLSTATE             PIC X(05) VALUE SPACES.           
           05 WS-GTT-NAME             PIC X(30) VALUE SPACES.           
                                                                        
       01  WS-SWITCHES.                                                 
           05 WS-ACTION-IND           PIC X(01) VALUE SPACES.           
              88 WS-INSERT                VALUE 'I'.                    
              88 WS-UPDATE                VALUE 'U'.                    
           05 ALL-DONE-SW             PIC X(01) VALUE 'N'.              
              88 NOT-ALL-DONE             VALUE 'N'.                    
              88 ALL-DONE                 VALUE 'Y'.                    
           05 SEND-DONE-SW            PIC X(01) VALUE 'Y'.              
              88 SEND-DONE-ERROR          VALUE 'N'.                    
              88 SEND-DONE-OK             VALUE 'Y'.                    
                                                                        
       01  WS-LITERALS.                                                 
           05 PROGRAM-NAME            PIC X(08) VALUE 'CSR04660'.       
           05 MCSCB326                PIC X(08) VALUE 'MCSCB326'.       
           05 WS-N                    PIC X(01) VALUE 'N'.              
           05 GTT-NAME                PIC X(26)                         
                                            VALUE 'SESSION.CSR04660_R1'.
       01  WS-ERR-FLAGS.                                                
           05  WS-ERR-INSRT-R1         PIC X(01) VALUE 'N'.             
      *                                                                         
                                                                        
       01  GTT-MISC-FIELDS.                                             
           05  GTT-ROW.                                                 
               49 GTT-ROW-LEN          PIC S9(04) COMP.                 
               49 GTT-ROW-CHAR         PIC X(1024).                     
           05  GTT-SQLCODE             PIC S9(9) COMP.                  
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS-RS1            PIC S9(9) COMP VALUE 0.          
      *                                                                         
       01 WS-TRANS-COMMENTS.                                            
          05 WS-COMMENT-TEXT.                                           
             10 FILLER                 PIC X(24) VALUE                  
                                           'UPDATED FOR RTPK SEQ NO:'.  
             10 FILLER                 PIC X(01) VALUE SPACES.          
             10 WS-RTPK-SEQ-NO         PIC X(04).                       
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  WS-MISC-FIELDS.                                              
           05  WS-APPL-RETURN-CODE     PIC S9(04) COMP   VALUE ZERO.    
           05  WS-ACCOUNT-NO-INT       PIC 9(13) VALUE ZERO.            
           05  WS-IC-NO-INT            PIC 9(04) VALUE ZERO.            
           05  WS-IC-NO-TEXT           PIC 0009  VALUE ZERO.            
ACT179     05  WS-RTPK-SEQ-NUM         PIC 9999  VALUE ZERO.            
           05  WS-COMMENT-LEN          PIC S9(04) COMP   VALUE 29.      
           05  WS-PRCE-NEGOTIATED-CD   PIC X(01) VALUE SPACE.           
P00892     05  WS-AUTO-REN-OPT-IN-FL   PIC X(01) VALUE SPACE.           
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05 S-RETURN-CODE             PIC S9(04) COMP VALUE 0.        
      *********************************************************                 
      *   GTT TABLE LAYOUT FOR BUS RULE AND IC NO            *                  
      *********************************************************                 
           05 GTT-RETURN-FIELDS-1.                                      
              10 S-RETURN-CODE-1        PIC S9(04) COMP VALUE 0.        
              10 S-APPL-RETURN-CODE-1   PIC S9(04) COMP VALUE 0.        
              10 S-IC-NO                PIC X(04)  VALUE SPACES.        
              10 S-RS1-BUS-RULE-ID      PIC X(10)  VALUE SPACES.        
              10 S-RS1-BUS-RULE-RESULT-CD                               
                                        PIC X(10)  VALUE SPACES.        
              10 S-RS1-BUS-RULE-XREF-ID PIC X(26)  VALUE SPACES.        
                                                                        
      *---------------------------------------------------------------          
      *--  ERROR PROCESSING VARIABLES                               --          
      *---------------------------------------------------------------          
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9) COMP VALUE 0.         
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.           
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.           
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.           
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
                                                                        
      ******************************************************************        
      *  CURSOR DECLARATIONS.                                          *        
      ******************************************************************        
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-APPL-PGMID                PIC X(08).                    
       01  PARM-ACTION-IND                PIC X(01).                    
COB305 01 PARM-ACCOUNT-NO        PIC S9(13)V COMP-3 VALUE 0.           
       01  PARM-CODE-UTIL-TYPE            PIC X(01).                    
       01  PARM-IC-NO                     PIC S9(04) COMP.              
       01  PARM-RTPK-OPT-SEQ-NO           PIC S9(04) COMP.              
       01  PARM-OPTION-CD                 PIC X(12).                    
       01  PARM-OFFER-CD                  PIC X(12).                    
       01  PARM-TRANS-SEQ-ID              PIC X(04).                    
       01  PARM-PROMO-CD                  PIC X(12).                    
       01  PARM-COMM-CHANNEL              PIC X(01).                    
       01  PARM-CREATED-USER-ID           PIC X(07).                    
       01  PARM-PROCESS-CD                PIC X(01).                    
       01  PARM-OPT-AGRMT-EFF-DT          PIC X(10).                    
       01  PARM-OPT-AGRMT-EFF-TM          PIC X(08).                    
       01  PARM-PRCE-NEGOTIATED-CD        PIC X(01).                    
       01  PARM-EXIT-FEE-FLAG             PIC X(01).                    
       01  PARM-EXIT-FEE-AMT              PIC X(11).                    
       01  PARM-PREV-OPT-CODE             PIC X(12).                    
       01  PARM-RATE-PLAN-NO              PIC X(03).                    
       01  PARM-CUST-AGRD-THERM           PIC X(11).                    
       01  PARM-CODE-REV-CLASS            PIC X(03).                    
       01  PARM-TIER-ACCT-TYPE-CD         PIC X(01).                    
       01  PARM-TIER-CUST-STAT-CD         PIC X(01).                    
       01  PARM-MKT-TIER-RANKING          PIC X(04).                    
       01  PARM-MKT-TIER-START-DT         PIC X(10).                    
P00892 01  PARM-AUTO-REN-OPT-IN-FL        PIC X(01).                    
                                                                        
       PROCEDURE DIVISION  USING PARM-APPL-PGMID                        
                                 PARM-ACTION-IND                        
                                 PARM-ACCOUNT-NO                        
                                 PARM-CODE-UTIL-TYPE                    
                                 PARM-IC-NO                             
                                 PARM-RTPK-OPT-SEQ-NO                   
                                 PARM-OPTION-CD                         
                                 PARM-OFFER-CD                          
                                 PARM-TRANS-SEQ-ID                      
                                 PARM-PROMO-CD                          
                                 PARM-COMM-CHANNEL                      
                                 PARM-CREATED-USER-ID                   
                                 PARM-PROCESS-CD                        
                                 PARM-OPT-AGRMT-EFF-DT                  
                                 PARM-OPT-AGRMT-EFF-TM                  
                                 PARM-PRCE-NEGOTIATED-CD                
                                 PARM-EXIT-FEE-FLAG                     
                                 PARM-EXIT-FEE-AMT                      
                                 PARM-PREV-OPT-CODE                     
                                 PARM-RATE-PLAN-NO                      
                                 PARM-CUST-AGRD-THERM                   
                                 PARM-CODE-REV-CLASS                    
                                 PARM-TIER-ACCT-TYPE-CD                 
                                 PARM-TIER-CUST-STAT-CD                 
                                 PARM-MKT-TIER-RANKING                  
                                 PARM-MKT-TIER-START-DT                 
P00892                           PARM-AUTO-REN-OPT-IN-FL.               
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0000-MAINLINE.                                                 *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE             THRU 0100-EXIT.          
           PERFORM 1000-PROCESS-INPUT          THRU 1000-EXIT.          
           PERFORM 2000-PROCESS-OUTPUT         THRU 2000-EXIT.          
           PERFORM 9999-END-PROGRAM            THRU 9999-EXIT.          
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1                                 
              THRU 0100A-EXIT.                                          
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100A-DECLARE-GTT-R1                                           *        
      ******************************************************************        
       0100A-DECLARE-GTT-R1.                                            
                                                                        
           MOVE 'SESSION.CSR04660_R1'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04660_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04660_R1
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,IC_NO CHAR(04)  COLLATE LATIN1_GENERAL_100_BIN2             
                   ,BUS_RULE_ID CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BUS_RULE_RESULT_CD CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BUS_RULE_XREF_ID CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS          THRU 8000A-EXIT    
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100A'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT        
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,IC_NO                                            
                      ,LTRIM(RTRIM(BUS_RULE_ID))          AS BUS_RULE_ID       
                      ,LTRIM(RTRIM(BUS_RULE_RESULT_CD))   AS 
           BUS_RULE_RESULT_CD
                      ,LTRIM(RTRIM(BUS_RULE_XREF_ID))     AS 
           BUS_RULE_XREF_ID  
                  FROM #CSR04660_R1                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,IC_NO                                                    
MFA-TR*               ,STRIP(BUS_RULE_ID)          AS BUS_RULE_ID               
MFA-TR*               ,STRIP(BUS_RULE_RESULT_CD)   AS BUS_RULE_RESULT_CD        
MFA-TR*               ,STRIP(BUS_RULE_XREF_ID)     AS BUS_RULE_XREF_ID          
MFA-TR*           FROM SESSION.CSR04660_R1                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-APPL-PGMID           TO WS-APPL-PGMID.             
           MOVE PARM-ACTION-IND           TO WS-ACTION-IND.             
                                                                        
           MOVE PARM-ACCOUNT-NO           TO WS-ACCOUNT-NO-INT          
                                             DF-ACCOUNT-NO.             
                                                                        
           MOVE WS-ACCOUNT-NO-INT         TO WS-ACCOUNT-NO-O.           
      *                                                                         
           MOVE PARM-CODE-UTIL-TYPE       TO WS-CODE-UTIL-TYPE-O        
                                             DF-CODE-UTIL-TYPE.         
      *                                                                         
           MOVE PARM-IC-NO                TO WS-IC-NO-INT               
                                             DF-IC-NO.                  
                                                                        
           MOVE WS-IC-NO-INT              TO WS-IC-NO-TEXT              
           MOVE WS-IC-NO-TEXT             TO WS-IC-NO-O.                
                                                                        
           MOVE PARM-RTPK-OPT-SEQ-NO      TO DF-RT-PKG-OPT-SEQ-NO.      
                                                                        
           MOVE PARM-PRCE-NEGOTIATED-CD   TO DF-PRCE-NEGOTIATED-CD.     
P00892     MOVE PARM-AUTO-REN-OPT-IN-FL   TO DF-AUTO-REN-OPT-IN-FL.     
                                                                        
      *                                                                         
           MOVE PARM-OPTION-CD            TO WS-OPTION-CD-O.            
           MOVE PARM-OFFER-CD             TO WS-OFFER-CD-O.             
           MOVE PARM-TRANS-SEQ-ID         TO WS-TRANS-SEQ-ID-O.         
           MOVE PARM-PROMO-CD             TO WS-PROMO-CD-O.             
           MOVE PARM-COMM-CHANNEL         TO WS-COMM-CHANNEL-O.         
           MOVE PARM-CREATED-USER-ID      TO WS-CREATED-USER-ID-O.      
           MOVE PARM-PROCESS-CD           TO WS-PROCESS-CD-O.           
           MOVE PARM-OPT-AGRMT-EFF-DT     TO WS-OPT-AGRMT-EFF-DT-O.     
           MOVE PARM-OPT-AGRMT-EFF-TM     TO WS-OPT-AGRMT-EFF-TM-O.     
           MOVE PARM-EXIT-FEE-FLAG        TO WS-EXIT-FEE-FLAG-O.        
           MOVE PARM-EXIT-FEE-AMT         TO WS-EXIT-FEE-AMT-O.         
           MOVE PARM-PREV-OPT-CODE        TO WS-PREV-OPT-CODE-O.        
           MOVE PARM-RATE-PLAN-NO         TO WS-RATE-PLAN-NO-O.         
           MOVE PARM-CUST-AGRD-THERM      TO WS-CUST-AGRD-THERM-O.      
           MOVE PARM-CODE-REV-CLASS       TO WS-CODE-REV-CLASS-O.       
           MOVE PARM-TIER-ACCT-TYPE-CD    TO WS-TIER-ACCT-TYPE-CD-O.    
           MOVE PARM-TIER-CUST-STAT-CD    TO WS-TIER-CUST-STAT-CD-O.    
           MOVE PARM-MKT-TIER-RANKING     TO WS-MKT-TIER-RANKING-O.     
           MOVE PARM-MKT-TIER-START-DT    TO WS-MKT-TIER-START-DT-O.    
P00892     MOVE PARM-AUTO-REN-OPT-IN-FL   TO WS-AUTO-REN-OPT-IN-FL-O.   
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *                                                                *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           IF WS-INSERT                                                 
              PERFORM 6000-START-APPLYING-FCTRS   THRU 6000-EXIT        
           ELSE                                                         
              PERFORM 2500-UPDATE-RTPK-AGR        THRU 2500-EXIT        
           END-IF.                                                      
      *                                                                         
           PERFORM 2000A-MOVE-RESULT              THRU 2000A-EXIT.      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000A-MOVE-RESULT.                                             *        
      ******************************************************************        
       2000A-MOVE-RESULT.                                               
                                                                        
            MOVE S-RETURN-CODE             TO S-RETURN-CODE-1           
            MOVE S-APPL-RETURN-CODE-1      TO S-APPL-RETURN-CODE-1.     
            MOVE WS-NEW-IC-NO              TO S-IC-NO.                  
            PERFORM 8010-INSERT-GTT-R1            THRU 8010-EXIT.       
      *                                                                         
       2000A-EXIT.                                                      
             EXIT.                                                      
      ******************************************************************        
      * 2500-UPDATE-RTPK-AGR                                           *        
      ******************************************************************        
       2500-UPDATE-RTPK-AGR.                                            
                                                                        
            PERFORM 7000-GET-AT-RTPK-AGR          THRU 7000-EXIT.       
            PERFORM 8000-UPDT-AT-RTPK-AGR         THRU 8000-EXIT.       
P00892      PERFORM 2600-AUTO-OPT-IN-PROCESS   THRU 2600-EXIT           
            PERFORM 2800-PRCS-TRAN-HIST           THRU 2800-EXIT.       
      *                                                                         
       2500-EXIT.                                                       
            EXIT.                                                       
                                                                        
P00892******************************************************************        
P00892*   2600-AUTO-OPT-IN-PROCESS                                     *        
P00892*   IF AUTO-REN-OPT-IN-FL = I (OPTED IN)                         *        
P00892*      > CREATE OPTED-IN ATTRIBUTE                               *        
P00892*      > DELETE DECLINED ATTRIBUTE                               *        
P00892*   IF AUTO-REN-OPT-IN-FL = O (OPTED OUT)                        *        
P00892*      > CREATE DECLINED ATTRIBUTE                               *        
P00892*      > DELETE OPTED-IN ATTRIBUTE                               *        
P00892*   IF AUTO-REN-OPT-IN-FL = N (NOT ELIGIBLE) OR E(ELIGIBLE) OR   *        
P00892*                           A (AUTO RENEWED)                     *        
P00892*      > DELETE OPTED-IN ATTRIBUTE                               *        
P00892*      > DELETE DECLINED ATTRIBUTE                               *        
P00892******************************************************************        
P00892 2600-AUTO-OPT-IN-PROCESS.                                        
P00892                                                                  
P00892     EVALUATE DF-AUTO-REN-OPT-IN-FL                               
P00892       WHEN 'I'                                                   
P00892         MOVE 'OPTED IN'            TO YP-ATTRIBUTE-DESC          
P00892         MOVE 'I'                   TO YP-ATTRIBUTE-VALUE-CD      
P00892         PERFORM 8100-INSERT-ATTR          THRU 8100-EXIT         
P00892         MOVE 'AUTORENEW_REJE'      TO YP-ATTRIBUTE-DESC          
P00892         PERFORM 8200-DELETE-ATTR          THRU 8200-EXIT         
P00892       WHEN 'O'                                                   
P00892         MOVE 'AUTORENEW_REJE'   TO YP-ATTRIBUTE-DESC             
P00892         MOVE 'RENJR'            TO YP-ATTRIBUTE-VALUE-CD         
P00892         MOVE 'OPTED OUT'        TO YP-ATTRIBUTE-VALUE-TX-TEXT    
P00892         MOVE LENGTH OF YP-ATTRIBUTE-VALUE-TX-TEXT                
P00892                                 TO YP-ATTRIBUTE-VALUE-TX-LEN     
P00892         PERFORM 8100-INSERT-ATTR          THRU 8100-EXIT         
P00892         IF WS-ACTIVE-RETURN-CODE = ALREADY-EXISTS                
P00892            PERFORM 8400-UPDATE-ATTR       THRU 8400-EXIT         
P00892         END-IF                                                   
P00892         MOVE 'OPTED IN'            TO YP-ATTRIBUTE-DESC          
P00892         PERFORM 8200-DELETE-ATTR         THRU 8200-EXIT          
P00892       WHEN 'N'                                                   
P00892       WHEN 'E'                                                   
P00892       WHEN 'A'                                                   
P00892         MOVE 'OPTED IN'            TO YP-ATTRIBUTE-DESC          
P00892         PERFORM 8200-DELETE-ATTR         THRU 8200-EXIT          
P00892         MOVE 'AUTORENEW_REJE'      TO YP-ATTRIBUTE-DESC          
P00892         PERFORM 8200-DELETE-ATTR          THRU 8200-EXIT         
P00892       WHEN OTHER                                                 
P00892         CONTINUE                                                 
P00892     END-EVALUATE.                                                
P00892                                                                  
P00892 2600-EXIT.                                                       
P00892      EXIT.                                                       
      ******************************************************************        
      *   2800-PRCS-TRAN-HIST                                          *        
      *                                                                *        
      ******************************************************************        
       2800-PRCS-TRAN-HIST.                                             
                                                                        
                                                                        
           IF WS-PRCE-NEGOTIATED-CD NOT = DF-PRCE-NEGOTIATED-CD         
              PERFORM 7010-GET-CURR-TIMESTAMP     THRU 7010-EXIT        
              PERFORM 2810-PRCS-NEG-CD-TR-HIS     THRU 2810-EXIT        
              PERFORM 2820-PRCS-NEG-CD-TR-DET     THRU 2820-EXIT        
           END-IF.                                                      
                                                                        
P00892     IF WS-AUTO-REN-OPT-IN-FL NOT = DF-AUTO-REN-OPT-IN-FL         
P00892        PERFORM 7010-GET-CURR-TIMESTAMP     THRU 7010-EXIT        
P00892        PERFORM 2830-AUTO-REN-FL-TR-HIS     THRU 2830-EXIT        
P00892        PERFORM 2840-AUTO-REN-FL-TR-DET     THRU 2840-EXIT        
ACT179        PERFORM 2850-MOVE-ACCT-RT-HIST-DET  THRU 2850-EXIT        
           END-IF.                                                      
      *                                                                         
       2800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2810-PRCS-NEG-CD-TR-HIS                                        *        
      ******************************************************************        
       2810-PRCS-NEG-CD-TR-HIS.                                         
                                                                        
           MOVE 'F'                      TO MH-CODE-TRAN-TYPE.          
           MOVE DF-ACCOUNT-NO            TO MH-ACCOUNT-NO.              
           MOVE SPACES                   TO MH-RESP-AREA-ID.            
           MOVE ZERO                     TO MH-CUSTOMER-NO.             
           MOVE ZERO                     TO MH-PREMISE-NO.              
           MOVE PARM-CREATED-USER-ID     TO MH-USER-ID.                 
           MOVE PROGRAM-NAME             TO MH-APPL-PROGRAM-ID.         
           MOVE DF-RT-PKG-OPT-SEQ-NO     TO WS-RTPK-SEQ-NUM.            
           MOVE WS-RTPK-SEQ-NUM          TO WS-RTPK-SEQ-NO.             
           MOVE WS-COMMENT-LEN           TO MH-TRAN-COMMENT-LEN.        
           MOVE WS-COMMENT-TEXT          TO MH-TRAN-COMMENT-TEXT.       
      *                                                                         
       2810-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      * 2820-PRCS-NEG-CD-TR-DET                                       *         
      ******************************************************************        
       2820-PRCS-NEG-CD-TR-DET.                                         
      *                                                                         
           MOVE MH-TRANS-HIST-SEQ-NO     TO MI-TRANS-HIST-SEQ-NO.       
           MOVE 1                        TO MI-TRAN-APPL-NO.            
           MOVE SPACES                   TO MI-TABLE-ID.                
      *                                                                         
           MOVE +01                      TO MI-PRV-COLUMN-VALUE-LEN.    
           MOVE WS-PRCE-NEGOTIATED-CD    TO MI-PRV-COLUMN-VALUE-TEXT.   
           MOVE +01                      TO MI-CHG-COLUMN-VALUE-LEN.    
           MOVE DF-PRCE-NEGOTIATED-CD    TO MI-CHG-COLUMN-VALUE-TEXT.   
      *                                                                         
           MOVE 'PRICE_NEGOTIATED'       TO MI-COLUMN-DESC.             
      * GET CODE VALUE                                                          
      *                                                                         
           MOVE +03                      TO MI-PRV-COLUMN-VALUE-LEN     
                                            MI-CHG-COLUMN-VALUE-LEN.    
      *                                                                         
           MOVE +18                      TO UV-COLUMN-NA-LEN.           
           MOVE 'PRCE_NEGOTIATED_CD'     TO UV-COLUMN-NA-TEXT.          
           MOVE +17                      TO UV-TABLE-NA-LEN.            
           MOVE 'CSS_ACCT_RTPK_AGR'      TO UV-TABLE-NA-TEXT.           
           MOVE 01                       TO UV-CODE-VALUE-LEN.          
           MOVE 03                       TO UV-CODE-LONG-DESC-LEN.      
           MOVE 'ALL'                    TO UV-PROGRAM-ID.              
      * GET PREVIOUS VALUE                                                      
           MOVE  WS-PRCE-NEGOTIATED-CD                                  
                                         TO UV-CODE-VALUE-TEXT.         
           PERFORM 7100-GET-CODE-VALUE            THRU   7100-EXIT.     
      *                                                                         
           MOVE UV-CODE-LONG-DESC-TEXT                                  
                                         TO MI-PRV-COLUMN-VALUE-TEXT.   
      *                                                                         
           INITIALIZE  UV-CODE-VALUE-TEXT                               
                       UV-CODE-LONG-DESC-TEXT.                          
      * GET CURRENT VALUE                                                       
           MOVE  DF-PRCE-NEGOTIATED-CD                                  
                                         TO UV-CODE-VALUE-TEXT.         
           PERFORM 7100-GET-CODE-VALUE            THRU   7100-EXIT.     
      *                                                                         
           MOVE UV-CODE-LONG-DESC-TEXT                                  
                                         TO MI-CHG-COLUMN-VALUE-TEXT.   
                                                                        
           PERFORM 6530-LOAD-MNT-TRANS-HIST       THRU 6530-EXIT.       
      *                                                                         
       2820-EXIT.                                                       
            EXIT.                                                       
                                                                        
P00892******************************************************************        
P00892* 2830-AUTO-REN-FL-TR-HIS                                        *        
P00892******************************************************************        
P00892 2830-AUTO-REN-FL-TR-HIS.                                         
P00892                                                                  
P00892     MOVE 'F'                      TO MH-CODE-TRAN-TYPE.          
P00892     MOVE DF-ACCOUNT-NO            TO MH-ACCOUNT-NO.              
P00892     MOVE SPACES                   TO MH-RESP-AREA-ID.            
P00892     MOVE ZERO                     TO MH-CUSTOMER-NO.             
P00892     MOVE ZERO                     TO MH-PREMISE-NO.              
P00892     MOVE PARM-CREATED-USER-ID     TO MH-USER-ID.                 
P00892     MOVE PROGRAM-NAME             TO MH-APPL-PROGRAM-ID.         
P00892     MOVE DF-RT-PKG-OPT-SEQ-NO     TO WS-RTPK-SEQ-NUM.            
P00892     MOVE WS-RTPK-SEQ-NUM          TO WS-RTPK-SEQ-NO.             
P00892     MOVE WS-COMMENT-LEN           TO MH-TRAN-COMMENT-LEN.        
P00892     MOVE WS-COMMENT-TEXT          TO MH-TRAN-COMMENT-TEXT.       
P00892*                                                                         
P00892 2830-EXIT.                                                       
P00892      EXIT.                                                       
                                                                        
P00892******************************************************************        
P00892* 2840-AUTO-REN-FL-TR-DET                                                 
P00892******************************************************************        
P00892 2840-AUTO-REN-FL-TR-DET.                                         
P00892     MOVE MH-TRANS-HIST-SEQ-NO     TO MI-TRANS-HIST-SEQ-NO.       
P00892     MOVE 1                        TO MI-TRAN-APPL-NO.            
P00892     MOVE SPACES                   TO MI-TABLE-ID.                
P00892                                                                  
P00892     MOVE +01                      TO MI-PRV-COLUMN-VALUE-LEN.    
P00892     MOVE WS-AUTO-REN-OPT-IN-FL    TO MI-PRV-COLUMN-VALUE-TEXT.   
P00892     MOVE +01                      TO MI-CHG-COLUMN-VALUE-LEN.    
P00892     MOVE DF-AUTO-REN-OPT-IN-FL    TO MI-CHG-COLUMN-VALUE-TEXT.   
P00892                                                                  
P00892     MOVE 'AUTO_REN_OPT_IN_FL'     TO MI-COLUMN-DESC.             
P00892* GET CODE VALUE                                                          
P00892                                                                  
P00892     MOVE +12                      TO MI-PRV-COLUMN-VALUE-LEN     
P00892                                      MI-CHG-COLUMN-VALUE-LEN.    
P00892                                                                  
P00892     MOVE +18                      TO UV-COLUMN-NA-LEN.           
P00892     MOVE 'AUTO_REN_OPT_IN_FL'     TO UV-COLUMN-NA-TEXT.          
P00892     MOVE +17                      TO UV-TABLE-NA-LEN.            
P00892     MOVE 'CSS_ACCT_RTPK_AGR'      TO UV-TABLE-NA-TEXT.           
P00892     MOVE 01                       TO UV-CODE-VALUE-LEN.          
P00892     MOVE 12                       TO UV-CODE-LONG-DESC-LEN.      
P00892     MOVE 'ALL'                    TO UV-PROGRAM-ID.              
P00892* GET PREVIOUS VALUE                                                      
P00892     MOVE  WS-AUTO-REN-OPT-IN-FL                                  
P00892                                   TO UV-CODE-VALUE-TEXT.         
P00892     PERFORM 7100-GET-CODE-VALUE            THRU   7100-EXIT.     
P00892                                                                  
P00892     MOVE UV-CODE-LONG-DESC-TEXT                                  
P00892                                   TO MI-PRV-COLUMN-VALUE-TEXT.   
P00892                                                                  
P00892     INITIALIZE  UV-CODE-VALUE-TEXT                               
P00892                 UV-CODE-LONG-DESC-TEXT.                          
P00892* GET CURRENT VALUE                                                       
P00892     MOVE  DF-AUTO-REN-OPT-IN-FL                                  
P00892                                   TO UV-CODE-VALUE-TEXT.         
P00892     PERFORM 7100-GET-CODE-VALUE            THRU   7100-EXIT.     
P00892                                                                  
P00892     MOVE UV-CODE-LONG-DESC-TEXT                                  
P00892                                   TO MI-CHG-COLUMN-VALUE-TEXT.   
P00892                                                                  
P00892     PERFORM 6530-LOAD-MNT-TRANS-HIST       THRU 6530-EXIT.       
P00892                                                                  
P00892 2840-EXIT.                                                       
P00892      EXIT.                                                       
                                                                        
ACT179*****************************************************************         
ACT179* CSS_ACCT_RATE_HIST  DATA                                                
ACT179*****************************************************************         
ACT179 2850-MOVE-ACCT-RT-HIST-DET.                                      
ACT179     MOVE DF-ACCOUNT-NO            TO 5H-ACCOUNT-NO.              
ACT179     MOVE DF-CODE-UTIL-TYPE        TO 5H-CODE-UTIL-TYPE.          
ACT179     MOVE DF-IC-NO                 TO 5H-IC-NO.                   
ACT179     MOVE DF-RT-PKG-OPT-SEQ-NO     TO 5H-RT-PKG-OPT-SEQ-NO.       
ACT179     MOVE MH-TRANS-HIST-SEQ-NO     TO 5H-TRANS-HIST-SEQ-NO.       
ACT179     PERFORM 8500-INSERT-ACCT-RT-HIST   THRU 8500-EXIT            
ACT179     .                                                            
ACT179 2850-EXIT.                                                       
ACT179      EXIT.                                                       
      *****************************************************************         
      *                                                               *         
      * 6000-START-APPLYING-FCTRS.                                    *         
      *****************************************************************         
       6000-START-APPLYING-FCTRS.                                       
                                                                        
           CALL MCSCB326 USING ABEND-FILE                               
                              ,WS-WARNING-DATA-ELEMENTS                 
                              ,LS-MCSCB326-CALL-TYPE                    
                              ,LS-MCSCB326-ONLINE-CALL                  
                              ,LS-MCSCB326-RET-FIELDS.                  
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL ZEROES                    
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           ELSE                                                         
              CONTINUE                                                  
           END-IF.                                                      
                                                                        
       6000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7000-GET-AT-RTPK-AGR                                           *        
      ******************************************************************        
       7000-GET-AT-RTPK-AGR.                                            
                                                                        
           EXEC SQL                                                     
              SELECT DF.PRCE_NEGOTIATED_CD                              
P00892             , DF.AUTO_REN_OPT_IN_FL                              
                INTO :WS-PRCE-NEGOTIATED-CD                             
P00892             , :WS-AUTO-REN-OPT-IN-FL                             
                FROM CSS_ACCT_RTPK_AGR        DF                        
               WHERE DF.ACCOUNT_NO         = :DF-ACCOUNT-NO             
                 AND DF.CODE_UTIL_TYPE     = :DF-CODE-UTIL-TYPE         
                 AND DF.IC_NO              = :DF-IC-NO                  
                 AND DF.RT_PKG_OPT_SEQ_NO  = :DF-RT-PKG-OPT-SEQ-NO      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DF.PRCE_NEGOTIATED_CD                                      
MFA-TR*            , DF.AUTO_REN_OPT_IN_FL                                      
MFA-TR*         INTO :WS-PRCE-NEGOTIATED-CD                                     
MFA-TR*            , :WS-AUTO-REN-OPT-IN-FL                                     
MFA-TR*         FROM CSS_ACCT_RTPK_AGR        DF                                
MFA-TR*        WHERE DF.ACCOUNT_NO         = :DF-ACCOUNT-NO                     
MFA-TR*          AND DF.CODE_UTIL_TYPE     = :DF-CODE-UTIL-TYPE                 
MFA-TR*          AND DF.IC_NO              = :DF-IC-NO                          
MFA-TR*          AND DF.RT_PKG_OPT_SEQ_NO  = :DF-RT-PKG-OPT-SEQ-NO              
MFA-TR*       QUERYNO 7000                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7000'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_ACCT_RTPK_AGR'      TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE 'RT_PKG_OPT_SEQ_NO'      TO TABLE-ELEMENT-4          
              MOVE DF-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE DF-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE DF-IC-NO                 TO HOSTVAR-ELEMENT-3        
              MOVE DF-RT-PKG-OPT-SEQ-NO     TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7010-GET-CURR-TIMESTAMP                                        *        
      ******************************************************************        
       7010-GET-CURR-TIMESTAMP.                                         
                                                                        
           EXEC SQL                                                     
               SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :MH-TRANS-HIST-SEQ-NO,
              :MH-DATE-TRANS,
              :WS-CURRENT-DATE                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :MH-TRANS-HIST-SEQ-NO = CURRENT TIMESTAMP                    
MFA-TR*           ,:MH-DATE-TRANS        = CURRENT DATE                         
MFA-TR*           ,:WS-CURRENT-DATE      = CURRENT DATE                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SPACES                   TO ABEND-TABLES             
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
              MOVE '7010'                   TO ACTIVE-PARAGRAPH         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7100-GET-CODE-VALUE                                           *         
      *****************************************************************         
                                                                        
       7100-GET-CODE-VALUE.                                             
                                                                        
           EXEC SQL                                                     
              SELECT UV.CODE_LONG_DESC                                  
              INTO  :UV-CODE-LONG-DESC                                  
              FROM  CSS_CODE_VALUE    UV WITH(READUNCOMMITTED)                  
              WHERE UV.CODE_VALUE  = :UV-CODE-VALUE                     
              AND   UV.COLUMN_NA   = :UV-COLUMN-NA                      
              AND   UV.TABLE_NA    = :UV-TABLE-NA                       
              AND   UV.PROGRAM_ID  = :UV-PROGRAM-ID                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT UV.CODE_LONG_DESC                                          
MFA-TR*       INTO  :UV-CODE-LONG-DESC                                          
MFA-TR*       FROM  CSS_CODE_VALUE    UV                                        
MFA-TR*       WHERE UV.CODE_VALUE  = :UV-CODE-VALUE                             
MFA-TR*       AND   UV.COLUMN_NA   = :UV-COLUMN-NA                              
MFA-TR*       AND   UV.TABLE_NA    = :UV-TABLE-NA                               
MFA-TR*       AND   UV.PROGRAM_ID  = :UV-PROGRAM-ID                             
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7100                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE 'NOT FOUND'        TO UV-CODE-LONG-DESC        
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE '7100'             TO ACTIVE-PARAGRAPH         
                    MOVE 'SELECT'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSS_CODE_VALUE'   TO TABLE-1                  
                    MOVE 'PROGRAM_ID'       TO TABLE-ELEMENT-1          
                    MOVE UV-PROGRAM-ID      TO HOSTVAR-ELEMENT-1        
                    MOVE 'CODE_VALUE'       TO TABLE-ELEMENT-2          
                    MOVE UV-CODE-VALUE      TO HOSTVAR-ELEMENT-2        
                    MOVE 'COLUMN_NA'        TO TABLE-ELEMENT-3          
                    MOVE UV-COLUMN-NA       TO HOSTVAR-ELEMENT-3        
                    PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT        
           END-EVALUATE.                                                
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8000-UPDT-AT-RTPK-AGR                                          *        
      ******************************************************************        
       8000-UPDT-AT-RTPK-AGR.                                           
                                                                        
           EXEC SQL                                                     
              UPDATE DF                                
                 SET DF.PRCE_NEGOTIATED_CD = :DF-PRCE-NEGOTIATED-CD     
P00892             , DF.AUTO_REN_OPT_IN_FL = :DF-AUTO-REN-OPT-IN-FL     
              FROM CSS_ACCT_RTPK_AGR DF
               WHERE DF.ACCOUNT_NO         = :DF-ACCOUNT-NO             
                 AND DF.CODE_UTIL_TYPE     = :DF-CODE-UTIL-TYPE         
                 AND DF.IC_NO              = :DF-IC-NO                  
                 AND DF.RT_PKG_OPT_SEQ_NO  = :DF-RT-PKG-OPT-SEQ-NO      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_ACCT_RTPK_AGR        DF                                
MFA-TR*          SET DF.PRCE_NEGOTIATED_CD = :DF-PRCE-NEGOTIATED-CD             
MFA-TR*            , DF.AUTO_REN_OPT_IN_FL = :DF-AUTO-REN-OPT-IN-FL             
MFA-TR*        WHERE DF.ACCOUNT_NO         = :DF-ACCOUNT-NO                     
MFA-TR*          AND DF.CODE_UTIL_TYPE     = :DF-CODE-UTIL-TYPE                 
MFA-TR*          AND DF.IC_NO              = :DF-IC-NO                          
MFA-TR*          AND DF.RT_PKG_OPT_SEQ_NO  = :DF-RT-PKG-OPT-SEQ-NO              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8000'                   TO ACTIVE-PARAGRAPH         
              MOVE 'UPDATE'                 TO ABEND-FUNCTION           
              MOVE 'CSS_ACCT_RTPK_AGR'      TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE 'RT_PKG_OPT_SEQ_NO'      TO TABLE-ELEMENT-4          
              MOVE DF-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE DF-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE DF-IC-NO                 TO HOSTVAR-ELEMENT-3        
              MOVE DF-RT-PKG-OPT-SEQ-NO     TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * 8000A-DELETE-GTT-ROWS.                                        *         
      *****************************************************************         
       8000A-DELETE-GTT-ROWS.                                           
      *                                                                         
            EXEC SQL                                                    
                DELETE FROM #CSR04660_R1                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR04660_R1                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               MOVE ZEROES                  TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1          
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE SQLCODE                 TO ABEND-SQLCODE            
               MOVE SQLSTATE                TO ABEND-SQLSTATE           
               MOVE '8000A'                 TO ACTIVE-PARAGRAPH         
               MOVE 'DELETE'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSR04660_R1'           TO TABLE-1                  
               MOVE SPACES                  TO TABLE-ELEMENT-1          
               MOVE SPACES                  TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
           END-IF.                                                      
      *                                                                         
       8000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 8010-INSERT-GTT-R1.                                            *        
      ******************************************************************        
       8010-INSERT-GTT-R1.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04660_R1                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,IC_NO                                                
                  ,BUS_RULE_ID                                          
                  ,BUS_RULE_RESULT_CD                                   
                  ,BUS_RULE_XREF_ID                                     
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-1                                     
                  ,:S-APPL-RETURN-CODE-1                                
                  ,:S-IC-NO                                             
                  ,:S-RS1-BUS-RULE-ID                                   
                  ,:S-RS1-BUS-RULE-RESULT-CD                            
                  ,:S-RS1-BUS-RULE-XREF-ID                              
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04660_R1                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,IC_NO                                                        
MFA-TR*           ,BUS_RULE_ID                                                  
MFA-TR*           ,BUS_RULE_RESULT_CD                                           
MFA-TR*           ,BUS_RULE_XREF_ID                                             
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-1                                             
MFA-TR*           ,:S-APPL-RETURN-CODE-1                                        
MFA-TR*           ,:S-IC-NO                                                     
MFA-TR*           ,:S-RS1-BUS-RULE-ID                                           
MFA-TR*           ,:S-RS1-BUS-RULE-RESULT-CD                                    
MFA-TR*           ,:S-RS1-BUS-RULE-XREF-ID                                      
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R1 = 'Y'             
              ADD +1                        TO CTR-ROWS-RS1             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO  ABEND-PROGRAM           
              MOVE '8010'                   TO  ACTIVE-PARAGRAPH        
              MOVE SQLCODE                  TO  ABEND-SQLCODE           
              MOVE 'INSERT'                 TO  ABEND-FUNCTION          
              MOVE 'Y'                      TO  WS-ERR-INSRT-R1         
              MOVE SPACES                   TO  ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSR04660_R1'            TO  TABLE-1                 
              MOVE SPACES                   TO  TABLE-ELEMENT-1         
              MOVE SPACES                   TO  HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
        8010-EXIT.                                                      
            EXIT.                                                       
                                                                        
P00892*****************************************************************         
P00892* 8100-INSERT-ATTR                                              *         
P00892*****************************************************************         
P00892 8100-INSERT-ATTR.                                                
P00892                                                                  
P00892     EXEC SQL                                                     
P00892        INSERT INTO CSS_ACCT_ATTRIBUTE                            
P00892           ( ACCOUNT_NO                                           
P00892            ,ATTRIBUTE_DESC                                       
P00892            ,ATTRIBUTE_VALUE_CD                                   
P00892            ,ATTRIBUTE_VALUE_DT                                   
P00892            ,ATTRIBUTE_VALUE_TX                                   
P00892            ,CREATED_TS                                           
P00892            ,STATUS_CD                                            
P00892           )                                                      
P00892        VALUES                                                    
P00892           ( :DF-ACCOUNT-NO                                       
P00892            ,:YP-ATTRIBUTE-DESC                                   
P00892            ,:YP-ATTRIBUTE-VALUE-CD                               
P00892            ,CAST(SYSDATETIMEOFFSET() AS DATE)                            
P00892            ,:YP-ATTRIBUTE-VALUE-TX                               
P00892            ,CIS.CURRENT$TIMESTAMP()                                    
P00892            ,'A'                                                  
P00892           )                                                      
P00892     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_ACCT_ATTRIBUTE                                    
MFA-TR*          ( ACCOUNT_NO                                                   
MFA-TR*           ,ATTRIBUTE_DESC                                               
MFA-TR*           ,ATTRIBUTE_VALUE_CD                                           
MFA-TR*           ,ATTRIBUTE_VALUE_DT                                           
MFA-TR*           ,ATTRIBUTE_VALUE_TX                                           
MFA-TR*           ,CREATED_TS                                                   
MFA-TR*           ,STATUS_CD                                                    
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          ( :DF-ACCOUNT-NO                                               
MFA-TR*           ,:YP-ATTRIBUTE-DESC                                           
MFA-TR*           ,:YP-ATTRIBUTE-VALUE-CD                                       
MFA-TR*           ,CURRENT DATE                                                 
MFA-TR*           ,:YP-ATTRIBUTE-VALUE-TX                                       
MFA-TR*           ,CURRENT TIMESTAMP                                            
MFA-TR*           ,'A'                                                          
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00892                                                                  
P00892     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
P00892                                                                  
P00892     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR -803           
P00892        CONTINUE                                                  
P00892     ELSE                                                         
P00892        MOVE PROGRAM-NAME             TO  ABEND-PROGRAM           
P00892        MOVE '8100'                   TO  ACTIVE-PARAGRAPH        
P00892        MOVE SQLCODE                  TO  ABEND-SQLCODE           
P00892        MOVE 'INSERT'                 TO  ABEND-FUNCTION          
P00892        MOVE 'CSS_ACCT_ATTRIBUTE'     TO  TABLE-1                 
P00892        MOVE 'ACCOUNT_NO'             TO  TABLE-ELEMENT-1         
P00892        MOVE DF-ACCOUNT-NO            TO  HOSTVAR-ELEMENT-1       
P00892        MOVE 'ACCOUNT_NO'             TO  TABLE-ELEMENT-1         
P00892        MOVE DF-ACCOUNT-NO            TO  HOSTVAR-ELEMENT-1       
P00892        PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
P00892     END-IF.                                                      
P00892                                                                  
P00892 8100-EXIT.                                                       
P00892     EXIT.                                                        
                                                                        
P00892*****************************************************************         
P00892* 8200-DELETE-ATTR                                              *         
P00892*****************************************************************         
P00892 8200-DELETE-ATTR .                                               
P00892                                                                  
P00892      EXEC SQL                                                    
P00892          DELETE FROM CSS_ACCT_ATTRIBUTE                          
P00892          WHERE ACCOUNT_NO     = :DF-ACCOUNT-NO                   
P00892            AND ATTRIBUTE_DESC = :YP-ATTRIBUTE-DESC               
P00892      END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00892                                                                  
P00892      MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE    
P00892                                                                  
P00892      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
P00892         CONTINUE                                                 
P00892      ELSE                                                        
P00892         MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
P00892         MOVE SQLCODE                 TO ABEND-SQLCODE            
P00892         MOVE '8200'                  TO ACTIVE-PARAGRAPH         
P00892         MOVE 'DELETE'                TO ABEND-FUNCTION           
P00892         MOVE 'CSS_ACCT_ATTRIBUTE'    TO TABLE-1                  
P00892         MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
P00892         MOVE DF-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
P00892         PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
P00892     END-IF.                                                      
P00892                                                                  
P00892 8200-EXIT.                                                       
P00892     EXIT.                                                        
P00892                                                                  
                                                                        
                                                                        
P00892******************************************************************        
P00892* 8400-UPDATE-ATTR                                                        
P00892******************************************************************        
P00892 8400-UPDATE-ATTR.                                                
P00892     EXEC SQL                                                     
P00892        UPDATE CSS_ACCT_ATTRIBUTE                                 
P00892           SET ATTRIBUTE_VALUE_CD = :YP-ATTRIBUTE-VALUE-CD        
P00892            ,  ATTRIBUTE_VALUE_DT = CAST(SYSDATETIMEOFFSET() 
           AS DATE)                  
P00892            ,  ATTRIBUTE_VALUE_TX = :YP-ATTRIBUTE-VALUE-TX        
P00892            ,  STATUS_CD          = 'A'                           
P00892         WHERE ACCOUNT_NO         = :DF-ACCOUNT-NO                
P00892           AND ATTRIBUTE_DESC     = :YP-ATTRIBUTE-DESC            
P00892     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_ACCT_ATTRIBUTE                                         
MFA-TR*          SET ATTRIBUTE_VALUE_CD = :YP-ATTRIBUTE-VALUE-CD                
MFA-TR*           ,  ATTRIBUTE_VALUE_DT = CURRENT DATE                          
MFA-TR*           ,  ATTRIBUTE_VALUE_TX = :YP-ATTRIBUTE-VALUE-TX                
MFA-TR*           ,  STATUS_CD          = 'A'                                   
MFA-TR*        WHERE ACCOUNT_NO         = :DF-ACCOUNT-NO                        
MFA-TR*          AND ATTRIBUTE_DESC     = :YP-ATTRIBUTE-DESC                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00892                                                                  
P00892     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
P00892                                                                  
P00892     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00892        CONTINUE                                                  
P00892     ELSE                                                         
P00892        MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
P00892        MOVE '8400'                   TO ACTIVE-PARAGRAPH         
P00892        MOVE 'UPDATE'                 TO ABEND-FUNCTION           
P00892        MOVE 'CSS_ACCT_ATTRIBUTE'     TO TABLE-1                  
P00892        MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
P00892        MOVE DF-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
P00892        MOVE 'ATTRIBUTE_DESC'         TO TABLE-ELEMENT-1          
P00892        MOVE YP-ATTRIBUTE-DESC        TO HOSTVAR-ELEMENT-1        
P00892        PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
P00892     END-IF.                                                      
P00892 8400-EXIT.                                                       
P00892     EXIT.                                                        
                                                                        
ACT179*****************************************************************         
ACT179*                                                               *         
ACT179* 8500-INSERT-ACCT-RATE-HIST.                                   *         
ACT179*****************************************************************         
ACT179 8500-INSERT-ACCT-RT-HIST.                                        
ACT179                                                                  
ACT179     EXEC SQL                                                     
ACT179         INSERT INTO CSS_ACCT_RATE_HIST                           
ACT179           (                                                      
ACT179             ACCOUNT_NO                                           
ACT179            ,CODE_UTIL_TYPE                                       
ACT179            ,IC_NO                                                
ACT179            ,RT_PKG_OPT_SEQ_NO                                    
ACT179            ,TRANS_HIST_SEQ_NO                                    
ACT179            ,LAST_UPDATE_TS                                       
ACT179           )                                                      
ACT179         VALUES                                                   
ACT179           (                                                      
ACT179             :5H-ACCOUNT-NO                                       
ACT179            ,:5H-CODE-UTIL-TYPE                                   
ACT179            ,:5H-IC-NO                                            
ACT179            ,:5H-RT-PKG-OPT-SEQ-NO                                
ACT179            ,CIS.CHAR2TIMESTAMP(:5H-TRANS-HIST-SEQ-NO)                    
ACT179            ,CIS.CURRENT$TIMESTAMP()                                    
ACT179           )                                                      
ACT179     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_ACCT_RATE_HIST                                   
MFA-TR*          (                                                              
MFA-TR*            ACCOUNT_NO                                                   
MFA-TR*           ,CODE_UTIL_TYPE                                               
MFA-TR*           ,IC_NO                                                        
MFA-TR*           ,RT_PKG_OPT_SEQ_NO                                            
MFA-TR*           ,TRANS_HIST_SEQ_NO                                            
MFA-TR*           ,LAST_UPDATE_TS                                               
MFA-TR*          )                                                              
MFA-TR*        VALUES                                                           
MFA-TR*          (                                                              
MFA-TR*            :5H-ACCOUNT-NO                                               
MFA-TR*           ,:5H-CODE-UTIL-TYPE                                           
MFA-TR*           ,:5H-IC-NO                                                    
MFA-TR*           ,:5H-RT-PKG-OPT-SEQ-NO                                        
MFA-TR*           ,:5H-TRANS-HIST-SEQ-NO                                        
MFA-TR*           ,CURRENT TIMESTAMP                                            
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
ACT179     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
ACT179     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
ACT179        NEXT SENTENCE                                             
ACT179     ELSE                                                         
ACT179        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
ACT179        MOVE '8500'                    TO ACTIVE-PARAGRAPH        
ACT179        MOVE 'INSERT'                  TO ABEND-FUNCTION          
ACT179        MOVE 'CSS_ACCT_RATE_HIST'      TO TABLE-1                 
ACT179        MOVE 'ACCOUNT NO'              TO TABLE-ELEMENT-1         
ACT179        MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
ACT179        MOVE 'IC_NO'                   TO TABLE-ELEMENT-3         
ACT179        MOVE 'TRANS_HIST_SEQ_NO'       TO TABLE-ELEMENT-4         
ACT179        MOVE 5H-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
ACT179        MOVE 5H-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
ACT179        MOVE 5H-IC-NO                  TO HOSTVAR-ELEMENT-3       
ACT179        MOVE 5H-TRANS-HIST-SEQ-NO      TO HOSTVAR-ELEMENT-4       
ACT179        PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
ACT179     END-IF.                                                      
                                                                        
ACT179 8500-EXIT.                                                       
ACT179     EXIT.                                                        
      *****************************************************************         
      *                                                               *         
      * 8800-CHECK-RESULTS.                                           *         
      *****************************************************************         
       8800-CHECK-RESULTS.                                              
                                                                        
           IF CTR-ROWS-RS1 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-1                            
              MOVE   0                      TO S-RETURN-CODE-1          
              MOVE 100                      TO S-APPL-RETURN-CODE-1     
              PERFORM 8010-INSERT-GTT-R1          THRU 8010-EXIT        
           END-IF.                                                      
      *                                                                         
       8800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8900-SEND-DONE.                                                *        
      ******************************************************************        
       8900-SEND-DONE.                                                  
                                                                        
           MOVE PROGRAM-NAME                TO ABEND-PROGRAM            
           MOVE '8900'                      TO ACTIVE-PARAGRAPH         
           MOVE 'OPEN'                      TO ABEND-FUNCTION           
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE 'CSR04660_R1'            TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 9000-SEND-ERROR-RESULT                                         *        
      ******************************************************************        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE       TO ABEND-SQLCODE            
                                               S-RETURN-CODE-1.         
                                                                        
           MOVE WS-APPL-RETURN-CODE         TO S-APPL-RETURN-CODE-1.    
                                                                        
           MOVE SQLERRMC                    TO ABEND-SQLERRMC.          
                                                                        
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'               TO ABEND-FUNCTION           
           END-IF.                                                      
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1           THRU 0100A-EXIT.      
                                                                        
           PERFORM 8010-INSERT-GTT-R1             THRU 8010-EXIT.       
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9700-ABEND-PROCESSING.                                         *        
      ******************************************************************        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT         THRU 9000-EXIT.       
           PERFORM 9900-SQL-ERROR-ROUTINE         THRU 9900-EXIT.       
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  JOURNALING COPYBOOK.                                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9900-SQL-ERROR-ROUTINE.                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9999-END-PROGRAM.                                              *        
      ******************************************************************        
                                                                        
       9999-END-PROGRAM.                                                
                                                                        
            PERFORM 8800-CHECK-RESULTS            THRU 8800-EXIT        
            PERFORM 8900-SEND-DONE                THRU 8900-EXIT        
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
