       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       CSR04659.                                      
COB303 DATE-WRITTEN.     JAN 20,2014.                                   
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE:  CSR04659              --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--                                                            --         
      *--  CSR04659 :                                                --         
      *--                                                            --         
      *--  #  RETRIEVES ACCOUNT RATE PACKAGE AGREEMENT INFO.         --         
      *--  #  THIS STORED PROCEDURE IS CLONED FROM CSR03814.         --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *--  PARAMETERS                                                --         
      *--                                                            --         
      *--      IN                                                    --         
      *--                                                            --         
      *--            I_ACCOUNT_NO            DECIMAL(13, 0)          --         
      *--            I_CODE_UTIL_TYPE        CHAR(01)                --         
      *--            I_IC_NO                 SMALLINT                --         
P00892*--            I_RT_PKG_OPT_SEQ_NO     SMALLINT                --         
      *--                                                            --         
      *--      OUT                                                   --         
      *--                                                            --         
      *--            NONE                                            --         
      *--                                                            --         
      *--      INOUT                                                 --         
      *--                                                            --         
      *--            NONE                                            --         
      *--                                                            --         
      *--  RESULT SET                                                --         
      *--                                                            --         
      *--  CSR04659_R1 - RATE PACKAGE AGREEMENT DETAILS.             --         
      *--                                                            --         
      *--       RT_PKG_OPT_SEQ_NO     SMALLINT                       --         
      *--       OFFER_CD              CHAR(12)                       --         
      *--       OPTION_DESC           CHAR(255)                      --         
      *--       PROMO_CD              CHAR(12)                       --         
      *--       STATUS_CD             CHAR(12)                       --         
      *--       COMM_CHANNEL          CHAR(02)                       --         
      *--       LAST_UPDATE_USERID    CHAR(7)                        --         
      *--       OPT_AGRMT_EFF_DT      CHAR(10)                       --         
      *--       OPT_AGRMT_EFF_TM      CHAR(08)                       --         
      *--       LAST_UPDATE_TS        CHAR(26)                       --         
      *--       OPTION_CD             CHAR(12)                       --         
      *--       ROW_TYPE              CHAR(01)                       --         
      *--       OFFER_DESC            CHAR(255)                      --         
      *--       ROW_NUM               SMALLINT                       --         
      *--       STATUS_EFF_REV_MTH    INTEGER                        --         
      *--       PRICE_NEGOTIATED_CD   CHAR(15)                       --         
P00892*--       AUTO_REN_OPT_IN_FL    CHAR(01)                       --         
I02262*--       SPCL_OFFER_TYPE_CD    CHAR(02)                       --         
      *--                                                            --         
      *--  CSR04659_R2 - BUS RULE DETAILS                            --         
      *--                                                            --         
      *--       RETURN_CODE           INTEGER                        --         
      *--       APPL_RETURN_CODE      INTEGER                        --         
      *--       BUS_RULE_ID           CHAR(10)                       --         
      *--       BUS_RULE_RESULT_CD    CHAR(10)                       --         
      *--       BUS_RULE_XREF_ID      CHAR(26)                       --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                        MODIFICATION LOG                    --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
      *--  01/20/2014    AD7F921     INITIAL VERSION.                --         
P00892*--  04/15/2015    VIJAY       FIXED RATE AUTO RENEWAL CHANGES --         
A05460*--  06/01/2016    MS7M727     REMOVE UNUSED COPYBOOK CCA00001 --         
      *--                ACT185                                      --         
I02262*--  08/24/2016    SS45239     OUTER POOL GROUP CHANGES        --         
      *****************************************************************         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04659'.
MSQ017     COPY MFASQLM.
                                                                        
      *****************************************************************         
      *    DB2 INCLUDES                                               *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_ACCT_RTPK_AGR, DF                                         *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBACCTRG                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CRM_RT_PKG_OPTION, FI                                                   
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBRTPKGO                                               
            END-EXEC.                                                           
                                                                        
I02262******************************************************************00510000
I02262*    CRM_RT_PKG_OFFER - FG                                       *00520000
I02262******************************************************************00530000
I02262     EXEC SQL                                                     00540000
I02262        INCLUDE TBRTPOFF                                          00550000
I02262     END-EXEC.                                                    00560000
I02262*                                                                 00570000
      ******************************************************************        
      * CSS_BILING_DET   BG                                            *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBBLLDET                                                  
           END-EXEC.                                                            
                                                                        
                                                                        
      *****************************************************************         
      *    ERROR HANDLING COPY BOOK.                                  *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    SUPPORT FOR MCSCB063                                                 
      *****************************************************************         
           COPY CWS00063.                                                       
      *                                                                         
      *****************************************************************         
      *    SQL ERROR CHECKING COPYBOOK.                               *         
      *****************************************************************         
           COPY CWS00303.                                                       
                                                                        
      *                                                                         
      *****************************************************************         
      *    WORK AREAS                                                 *         
      *****************************************************************         
      *                                                                         
       01  GTT-MISC-FIELDS.                                             
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR04659'.      
                                                                        
      *                                                                         
      *---------------------------------------------------------------          
      *--  ERROR PROCESSING VARIABLES                               --          
      *---------------------------------------------------------------          
      *                                                                         
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME               PIC X(18) VALUE SPACES.          
           10  S-SQLCODE               PIC S9(9) COMP VALUE 0.          
           10  S-SQLSTATE              PIC X(5)  VALUE ' '.             
           10  S-TABLE-NAME            PIC X(18) VALUE SPACES.          
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.            
               49  S-HOST-VARIABLES-V  PIC X(255).                      
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
               49  S-SQL-STATEMENT-V   PIC X(255).                      
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.            
               49  S-SQL-DESCRIPTION-V PIC X(255).                      
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L PIC S9(4) USAGE COMP.            
               49  WS-ABEND-SQLERRMC-V PIC X(255).                      
      *                                                                         
       01 GTT-RETURN-FIELDS.                                            
      *********************************************************                 
      *   GTT TABLE LAYOUT FOR RATE PACKAGE AGREEMENT DETAILS *                 
      *********************************************************                 
          05 S-RETURN-CODE             PIC S9(04) COMP VALUE 0.         
          05 GTT-RETURN-FIELDS-1.                                       
             10 S-RETURN-CODE-1        PIC S9(04) COMP VALUE 0.         
             10 S-APPL-RETURN-CODE-1   PIC S9(04) COMP VALUE 0.         
             10 S-RT-PKG-OPT-SEQ-NO    PIC S9(4)  COMP VALUE 0.         
             10 S-OFFER-CD             PIC X(12)  VALUE SPACES.         
             10 S-OPTION-DESC          PIC X(255) VALUE SPACES.         
             10 S-PROMO-CD             PIC X(12)  VALUE SPACES.         
             10 S-STATUS-CD            PIC X(12)  VALUE SPACES.         
             10 S-COMM-CHANNEL         PIC X(02)  VALUE SPACES.         
             10 S-LAST-UPDATE-USERID   PIC X(07)  VALUE SPACES.         
             10 S-OPT-AGRMT-EFF-DT     PIC X(10)  VALUE SPACES.         
             10 S-OPT-AGRMT-EFF-TM     PIC X(08)  VALUE SPACES.         
             10 S-LAST-UPDATE-TS       PIC X(26)  VALUE SPACES.         
             10 S-OPTION-CD            PIC X(12)  VALUE SPACES.         
             10 S-ROW-TYPE             PIC X(01)  VALUE SPACES.         
             10 S-OFFER-DESC           PIC X(255) VALUE SPACES.         
             10 S-ROW-NUM              PIC S9(4)  COMP VALUE 0.         
             10 S-STATUS-EFF-REV-MTH   PIC S9(09) COMP VALUE 0.         
             10 S-PRICE-NEGOTIATED-CD  PIC X(01)  VALUE SPACES.         
P00892       10 S-AUTO-REN-OPT-IN-FL   PIC X(01)  VALUE SPACES.         
I02262       10 S-SPCL-OFFER-TYPE-CD   PIC X(02)  VALUE SPACES.         
      *                                                                         
      *********************************************************                 
      *   GTT TABLE LAYOUT FOR BUS RULE ERROR MESSAGE        *                  
      *********************************************************                 
          05 GTT-RETURN-FIELDS-2.                                       
             10 S-RETURN-CODE-2        PIC S9(04) COMP VALUE 0.         
             10 S-APPL-RETURN-CODE-2   PIC S9(04) COMP VALUE 0.         
             10 S-RS2-BUS-RULE-ID      PIC X(10)  VALUE SPACES.         
             10 S-RS2-BUS-RULE-RESULT-CD                                
                                       PIC X(10)  VALUE SPACES.         
             10 S-RS2-BUS-RULE-XREF-ID PIC X(26)  VALUE SPACES.         
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS-RS1            PIC S9(9) COMP VALUE 0.          
           05  CTR-ROWS-RS2            PIC S9(9) COMP VALUE 0.          
      *                                                                         
       01  WS-ERR-FLAGS.                                                
           05  WS-ERR-INSRT-R1         PIC X(01) VALUE 'N'.             
           05  WS-ERR-INSRT-R2         PIC X(01) VALUE 'N'.             
      *                                                                         
       01  WS-MISC.                                                     
           05  WS-DATE-CCYY-MM-DD.                                      
               10  WS-DATE-CCYY        PIC X(04) VALUE SPACES.          
               10  FILLER              PIC X(01) VALUE SPACES.          
               10  WS-DATE-MM          PIC X(02) VALUE SPACES.          
               10  FILLER              PIC X(01) VALUE SPACES.          
               10  WS-DATE-DD          PIC X(02) VALUE SPACES.          
           05  WS-DATE-MM-DD-YYYY.                                      
               10  WS-DATE2-MM         PIC X(02) VALUE SPACES.          
               10  FILLER              PIC X(01) VALUE '/'.             
               10  WS-DATE2-DD         PIC X(02) VALUE SPACES.          
               10  FILLER              PIC X(01) VALUE '/'.             
               10  WS-DATE2-CCYY       PIC X(04) VALUE SPACES.          
           05  WS-SQLSTATE             PIC X(05) VALUE SPACES.          
      *                                                                         
       01  WS-MISC-ITEMS.                                               
           05  WS-OPT-DESC-INT-LONG    PIC X(255) VALUE SPACES.         
           05  WS-OFFER-DESC-INT-LNG   PIC X(255) VALUE SPACES.         
           05  WS-RT-PKG-OPT-SEQ-NO    PIC S9(09) COMP VALUE +0.        
           05  WS-CURRENT-ROW-NUM      PIC S9(4)  COMP VALUE 0.         
           05  WS-HISTORY-ROW-NUM      PIC S9(4)  COMP VALUE 0.         
           05  WS-FAILED               PIC X(01)  VALUE 'F'.            
           05  WS-APPLIED-A            PIC X(01)  VALUE 'A'.            
           05  WS-OPEN-O               PIC X(01)  VALUE 'O'.            
           05  WS-PENDING-P            PIC X(01)  VALUE 'P'.            
           05  WS-RENEWED-R            PIC X(01)  VALUE 'R'.            
           05  WS-CURRENT-ROW          PIC X(01)  VALUE 'C'.            
           05  WS-HISTORY-ROW          PIC X(01)  VALUE 'H'.            
           05  WS-EXISTS-FLAG          PIC X(01)  VALUE 'N'.            
           05  WS-ACTIVE-CODE          PIC X(01)  VALUE 'A'.            
           05  WS-PENDING-CODE         PIC X(01)  VALUE 'P'.            
           05  WS-PARM-ACCOUNT-NO      PIC 9(13)  VALUE ZERO.           
           05  WS-MST-ACCT-NO          PIC 9(13)  VALUE ZERO.           
           05  WS-IC-NO                PIC 9(04)  VALUE ZERO.           
           05  WS-ACCOUNT-NO           PIC S9(13)V USAGE COMP-3         
                                                  VALUE +0.             
           05  WS-NULL-INDICATOR-1     PIC S9(04) COMP VALUE +0.        
           05  WS-NULL-INDICATOR-2     PIC S9(04) COMP VALUE +0.        
           05  WS-NULL-IND1            PIC S9(04) COMP VALUE +0.        
           05  WS-NULL-IND2            PIC S9(04) COMP VALUE +0.        
           05  WS-DEST-ID              PIC X(10).                       
           05  WS-GTT-NAME             PIC X(30)  VALUE SPACES.         
           05  WS-APPL-RETURN-CODE     PIC S9(04) COMP VALUE 0.         
           05  MCSCB063                PIC X(08)  VALUE 'MCSCB063'.     
           05  WS-MCSCB063-RET-CODE    PIC S9(04) COMP VALUE 0.         
           05  WS-CSC-AMT-DESC         PIC $Z9.99.                      
           05  WS-CSC-LIT-DESC         PIC X(04)  VALUE ' CSC'.         
                                                                        
       01  WS-STATUS-EFF-REV-MTH       PIC 9(06)  VALUE ZEROS.          
                                                                        
       01  WS-EFF-REV-MTH-DATE.                                         
           05  WS-EFF-REV-MTH-YR       PIC X(04)  VALUE SPACES.         
           05  WS-DASH1                PIC X(01)  VALUE SPACES.         
           05  WS-EFF-REV-MTH-MM       PIC X(02)  VALUE SPACES.         
           05  WS-DASH2                PIC X(01)  VALUE SPACES.         
           05  WS-EFF-REV-MTH-DD       PIC X(02)  VALUE SPACES.         
      *                                                                         
      *****************************************************************         
      **  CURSOR DECLARATION FOR RETRIEVING ROWS FROM THE            **         
      **  CSS_ACCT_RTPK_AGR TABLE FOR A GIVEN ACCOUNT NO , IC NO     **         
      **  AND CODE UTILITY TYPE.                                     **         
      *****************************************************************         
                                                                        
           EXEC SQL                                                     
              DECLARE RTPKAGR_CSR CURSOR FOR                            
                SELECT  DF.RT_PKG_OPT_SEQ_NO                            
                       ,DF.OFFER_CD                                     
                       ,DF.OPTION_CD                                    
                       ,DF.PROMO_CD                                     
                       ,DF.STATUS_CD                                    
                       ,DF.COMM_CHANNEL                                 
                       ,DF.LAST_UPDATE_USERID                           
                       ,DF.OPT_AGRMT_EFF_DT                             
                       ,CIS.CHAR2$TIME(DF.OPT_AGRMT_EFF_TM,'USA')               
                       ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           DF.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS        
                       ,DF.STATUS_EFF_REV_MTH                           
                       ,DF.PRCE_NEGOTIATED_CD                           
P00892                 ,DF.AUTO_REN_OPT_IN_FL                           
                  FROM CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)               
                 WHERE DF.ACCOUNT_NO          = :DF-ACCOUNT-NO          
                   AND DF.CODE_UTIL_TYPE      = :DF-CODE-UTIL-TYPE      
                   AND DF.IC_NO               = :DF-IC-NO               
                 ORDER BY DF.RT_PKG_OPT_SEQ_NO DESC                     
                 FOR READ ONLY                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE RTPKAGR_CSR CURSOR FOR                                    
MFA-TR*         SELECT  DF.RT_PKG_OPT_SEQ_NO                                    
MFA-TR*                ,DF.OFFER_CD                                             
MFA-TR*                ,DF.OPTION_CD                                            
MFA-TR*                ,DF.PROMO_CD                                             
MFA-TR*                ,DF.STATUS_CD                                            
MFA-TR*                ,DF.COMM_CHANNEL                                         
MFA-TR*                ,DF.LAST_UPDATE_USERID                                   
MFA-TR*                ,DF.OPT_AGRMT_EFF_DT                                     
MFA-TR*                ,CHAR(DF.OPT_AGRMT_EFF_TM,USA)                           
MFA-TR*                ,DF.LAST_UPDATE_TS                                       
MFA-TR*                ,DF.STATUS_EFF_REV_MTH                                   
MFA-TR*                ,DF.PRCE_NEGOTIATED_CD                                   
MFA-TR*                ,DF.AUTO_REN_OPT_IN_FL                                   
MFA-TR*           FROM CSS_ACCT_RTPK_AGR DF                                     
MFA-TR*          WHERE DF.ACCOUNT_NO          = :DF-ACCOUNT-NO                  
MFA-TR*            AND DF.CODE_UTIL_TYPE      = :DF-CODE-UTIL-TYPE              
MFA-TR*            AND DF.IC_NO               = :DF-IC-NO                       
MFA-TR*          ORDER BY DF.RT_PKG_OPT_SEQ_NO DESC                             
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
                                                                        
       LINKAGE SECTION.                                                 
COB305 01 I-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.        
       01 I-CODE-UTIL-TYPE             PIC  X(01).                      
       01 I-IC-NO                      PIC  S9(4) USAGE COMP.           
P00892 01 I-RT-PKG-OPT-SEQ-NO          PIC  S9(4) COMP.                 
                                                                        
       PROCEDURE DIVISION USING I-ACCOUNT-NO                            
                              , I-CODE-UTIL-TYPE                        
                              , I-IC-NO                                 
                              , I-RT-PKG-OPT-SEQ-NO.                    
                                                                        
      *****************************************************************         
      * 0000-MAINLINE                                                 *         
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                     *         
      *****************************************************************         
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 1000-INITIALIZE-PROCEDURE                            
              THRU 1000-EXIT.                                           
                                                                        
           PERFORM 2000-PROCESS-OUTPUT                                  
              THRU 2000-EXIT.                                           
                                                                        
           PERFORM 9999-END-PROGRAM                                     
              THRU 9999-EXIT.                                           
           GOBACK.                                                      
                                                                        
       0000-MAINLINE-EXIT.                                              
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------          
      *--  0100A-DECLARE-GTT-R1                                     --          
      *--                                                           --          
      *---------------------------------------------------------------          
      *                                                                         
       0100A-DECLARE-GTT-R1.                                            
                                                                        
           MOVE 'SESSION.CSR04659_R1'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04659_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04659_R1
              (                                                       
                  RETURN_CODE           INT                         
                 ,APPL_RETURN_CODE      INT                         
                 ,RT_PKG_OPT_SEQ_NO     SMALLINT                        
                 ,OFFER_CD CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2            
                 ,OPTION_DESC CHAR(255)  COLLATE LATIN1_GENERAL_100_BIN2        
                 ,PROMO_CD CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2            
                 ,STATUS_CD CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2           
                 ,COMM_CHANNEL CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2        
                 ,LAST_UPDATE_USERID CHAR(7)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                         
                 ,OPT_AGRMT_EFF_DT CHAR(10)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                        
                 ,OPT_AGRMT_EFF_TM CHAR(08)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                        
                 ,LAST_UPDATE_TS CHAR(26)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                        
                 ,OPTION_CD CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2           
                 ,ROW_TYPE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2            
                 ,OFFER_DESC CHAR(255)  COLLATE LATIN1_GENERAL_100_BIN2         
                 ,ROW_NUM               SMALLINT                        
                 ,STATUS_EFF_REV_MTH    INT                         
                 ,PRICE_NEGOTIATED_CD CHAR(15)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                        
P00892           ,AUTO_REN_OPT_IN_FL CHAR(01)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                        
I02262           ,SPCL_OFFER_TYPE_CD CHAR(02)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                        
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS       THRU 8000A-EXIT       
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  CONTINUE                                              
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE '0100A'              TO ACTIVE-PARAGRAPH         
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                                ABEND-TABLES            
                  MOVE WS-GTT-NAME          TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT        
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
                                                                        
               DECLARE C1 CURSOR  FOR                        
                  SELECT                                                
                      RETURN_CODE                                       
                     ,APPL_RETURN_CODE                                  
                     ,RT_PKG_OPT_SEQ_NO          AS RT_PKG_OPT_SEQ_NO   
                     ,LTRIM(RTRIM(OFFER_CD))            AS OFFER_CD            
                     ,LTRIM(RTRIM(OPTION_DESC))         AS OPTION_DESC         
                     ,LTRIM(RTRIM(PROMO_CD))            AS PROMO_CD            
                     ,LTRIM(RTRIM(STATUS_CD))           AS STATUS_CD           
                     ,LTRIM(RTRIM(COMM_CHANNEL))        AS COMM_CHANNEL        
                     ,LTRIM(RTRIM(LAST_UPDATE_USERID))  AS 
           LAST_UPDATE_USERID  
                     ,LTRIM(RTRIM(OPT_AGRMT_EFF_DT))    AS 
           OPT_AGRMT_EFF_DT    
                     ,LTRIM(RTRIM(OPT_AGRMT_EFF_TM))    AS 
           OPT_AGRMT_EFF_TM    
                     ,LTRIM(RTRIM(LAST_UPDATE_TS))      AS 
           LAST_UPDATE_TS      
                     ,LTRIM(RTRIM(OPTION_CD))           AS OPTION_CD           
                     ,LTRIM(RTRIM(ROW_TYPE))            AS ROW_TYPE            
                     ,LTRIM(RTRIM(OFFER_DESC))          AS OFFER_DESC          
                     ,ROW_NUM                    AS ROW_NUM             
                     ,STATUS_EFF_REV_MTH         AS STATUS_EFF_REV_MTH  
                     ,LTRIM(RTRIM(PRICE_NEGOTIATED_CD)) AS 
           PRICE_NEGOTIATED_CD 
P00892               ,AUTO_REN_OPT_IN_FL         AS AUTO_REN_OPT_IN_FL  
I02262               ,LTRIM(RTRIM(SPCL_OFFER_TYPE_CD))  AS 
           SPCL_OFFER_TYPE_CD  
                  FROM #CSR04659_R1                              
                  ORDER BY RT_PKG_OPT_SEQ_NO DESC,                      
                           OPT_AGRMT_EFF_DT  DESC,                      
                           OPT_AGRMT_EFF_TM  DESC                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*           SELECT                                                        
MFA-TR*               RETURN_CODE                                               
MFA-TR*              ,APPL_RETURN_CODE                                          
MFA-TR*              ,RT_PKG_OPT_SEQ_NO          AS RT_PKG_OPT_SEQ_NO           
MFA-TR*              ,STRIP(OFFER_CD)            AS OFFER_CD                    
MFA-TR*              ,STRIP(OPTION_DESC)         AS OPTION_DESC                 
MFA-TR*              ,STRIP(PROMO_CD)            AS PROMO_CD                    
MFA-TR*              ,STRIP(STATUS_CD)           AS STATUS_CD                   
MFA-TR*              ,STRIP(COMM_CHANNEL)        AS COMM_CHANNEL                
MFA-TR*              ,STRIP(LAST_UPDATE_USERID)  AS LAST_UPDATE_USERID          
MFA-TR*              ,STRIP(OPT_AGRMT_EFF_DT)    AS OPT_AGRMT_EFF_DT            
MFA-TR*              ,STRIP(OPT_AGRMT_EFF_TM)    AS OPT_AGRMT_EFF_TM            
MFA-TR*              ,STRIP(LAST_UPDATE_TS)      AS LAST_UPDATE_TS              
MFA-TR*              ,STRIP(OPTION_CD)           AS OPTION_CD                   
MFA-TR*              ,STRIP(ROW_TYPE)            AS ROW_TYPE                    
MFA-TR*              ,STRIP(OFFER_DESC)          AS OFFER_DESC                  
MFA-TR*              ,ROW_NUM                    AS ROW_NUM                     
MFA-TR*              ,STATUS_EFF_REV_MTH         AS STATUS_EFF_REV_MTH          
MFA-TR*              ,STRIP(PRICE_NEGOTIATED_CD) AS PRICE_NEGOTIATED_CD         
MFA-TR*              ,AUTO_REN_OPT_IN_FL         AS AUTO_REN_OPT_IN_FL          
MFA-TR*              ,STRIP(SPCL_OFFER_TYPE_CD)  AS SPCL_OFFER_TYPE_CD          
MFA-TR*           FROM SESSION.CSR04659_R1                                      
MFA-TR*           ORDER BY RT_PKG_OPT_SEQ_NO DESC,                              
MFA-TR*                    OPT_AGRMT_EFF_DT  DESC,                              
MFA-TR*                    OPT_AGRMT_EFF_TM  DESC                               
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0100A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100B-DECLARE-GTT-R2                                           *        
      ******************************************************************        
       0100B-DECLARE-GTT-R2.                                            
                                                                        
           MOVE 'SESSION.CSR04659_R2'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04659_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04659_R2
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,BUS_RULE_ID CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BUS_RULE_RESULT_CD CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BUS_RULE_XREF_ID CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000B-DEL-GTT-ROWS          THRU 8000B-EXIT       
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100B'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT        
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C2 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,LTRIM(RTRIM(BUS_RULE_ID))          AS BUS_RULE_ID       
                      ,LTRIM(RTRIM(BUS_RULE_RESULT_CD))   AS 
           BUS_RULE_RESULT_CD
                      ,LTRIM(RTRIM(BUS_RULE_XREF_ID))     AS 
           BUS_RULE_XREF_ID  
                  FROM #CSR04659_R2                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C2 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,STRIP(BUS_RULE_ID)          AS BUS_RULE_ID               
MFA-TR*               ,STRIP(BUS_RULE_RESULT_CD)   AS BUS_RULE_RESULT_CD        
MFA-TR*               ,STRIP(BUS_RULE_XREF_ID)     AS BUS_RULE_XREF_ID          
MFA-TR*           FROM SESSION.CSR04659_R2                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100B-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *---------------------------------------------------------------*         
      *--  SET UP SQL ERROR PROCESSING                             ---*         
      *--  DECLARE ASSOCIATED CURSOR                               ---*         
      *---------------------------------------------------------------*         
      *                                                                         
       1000-INITIALIZE-PROCEDURE.                                       
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLWARNING                                      
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLERROR                                        
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER NOT FOUND                                       
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1                                 
              THRU 0100A-EXIT.                                          
      *                                                                         
           PERFORM 0100B-DECLARE-GTT-R2                                 
              THRU 0100B-EXIT.                                          
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 2000-PROCESS-OUTPUT.                                          *         
      *                                                               *         
      *****************************************************************         
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2200-BUILD-RESULT                                    
              THRU 2200-EXIT.                                           
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      *****************************************************************         
      * 2200-BUILD-RESULT                                             *         
      *                                                               *         
      *     BUILD THE RESULT SET DESCRIBED ABOVE.                     *         
      *                                                               *         
      *****************************************************************         
                                                                        
       2200-BUILD-RESULT.                                               
      *                                                                         
           MOVE I-ACCOUNT-NO                TO WS-ACCOUNT-NO.           
           MOVE WS-ACCOUNT-NO               TO DF-ACCOUNT-NO            
                                               WS-ACCOUNT-NO-063.       
      *                                                                         
           MOVE I-IC-NO                     TO DF-IC-NO                 
                                               WS-IC-NO-063.            
      *                                                                         
           MOVE I-CODE-UTIL-TYPE            TO DF-CODE-UTIL-TYPE        
                                               WS-CODE-UTIL-TYPE-063.   
P00892     MOVE I-RT-PKG-OPT-SEQ-NO         TO DF-RT-PKG-OPT-SEQ-NO.    
                                                                        
P00892     IF DF-RT-PKG-OPT-SEQ-NO > 0                                  
P00892        PERFORM 7300-GET-RTPKG-ROW-DET THRU 7300-EXIT             
P00892        PERFORM 2300-MOVE-VALUES        THRU 2300-EXIT            
P00892     ELSE                                                         
               PERFORM 7000-OPEN-RTPKAGR-CURSOR                         
                  THRU 7000-EXIT                                        
                                                                        
               PERFORM 7100-FETCH-RTPKAGR-CURSOR                        
                  THRU 7100-EXIT                                        
                                                                        
               PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND          
                  PERFORM 2300-MOVE-VALUES                              
                     THRU 2300-EXIT                                     
                                                                        
                  PERFORM 7100-FETCH-RTPKAGR-CURSOR                     
                     THRU 7100-EXIT                                     
               END-PERFORM                                              
                                                                        
               PERFORM 7200-CLOSE-RTPKAGR-CURSOR                        
                  THRU 7200-EXIT                                        
P00892     END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 2300-MOVE-VALUES                                              *         
      *                                                               *         
      *     MOVE VALUES INTO RESULT SET.                              *         
      *                                                               *         
      *****************************************************************         
       2300-MOVE-VALUES.                                                
      *                                                                         
           MOVE 0                           TO   S-RETURN-CODE .        
           MOVE DF-RT-PKG-OPT-SEQ-NO        TO   S-RT-PKG-OPT-SEQ-NO.   
           MOVE DF-OFFER-CD                 TO   S-OFFER-CD.            
           MOVE DF-OPTION-CD                TO   S-OPTION-CD            
                                                 FI-OPTION-CD           
                                                 WS-OPTION-CD.          
           MOVE SPACES                      TO   WS-EFF-REV-MTH-DATE.   
                                                                        
           EVALUATE DF-STATUS-CD                                        
             WHEN  'A'                                                  
             WHEN  'O'                                                  
             WHEN  'P'                                                  
              MOVE 'Y'                      TO WS-THERM-CSC-ACCT-FL     
      *                                                                         
              IF DF-STATUS-CD = 'P'                                     
                 MOVE 'Y'                   TO WS-PENDING-OPTION-FL-063 
              END-IF                                                    
      *                                                                         
             WHEN  OTHER                                                
              MOVE 'Y'                      TO WS-CSC-TIMELINE-FL-063   
      *                                                                         
              IF DF-STATUS-CD = 'R' OR DF-STATUS-CD = 'D'               
                 PERFORM 7225-GET-OLD-EFF-REV-MNTH THRU 7225-EXIT       
                 MOVE BG-REVENUE-MONTH      TO WS-STATUS-EFF-REV-MTH    
      *                                                                         
                 IF BG-REVENUE-MONTH > 0                                
                   MOVE WS-STATUS-EFF-REV-MTH(1:4)                      
                                            TO WS-EFF-REV-MTH-YR        
                                                                        
                   MOVE WS-STATUS-EFF-REV-MTH(5:2)                      
                                            TO WS-EFF-REV-MTH-MM        
                                                                        
                   MOVE '05'                TO WS-EFF-REV-MTH-DD        
                   MOVE '-'                 TO WS-DASH1                 
                                               WS-DASH2                 
                 END-IF                                                 
      *                                                                         
              ELSE                                                      
      *                                                                         
                 IF DF-STATUS-EFF-REV-MTH  = 0                          
                    MOVE DF-OPT-AGRMT-EFF-DT                            
                                            TO WS-EFF-REV-MTH-DATE      
                 ELSE                                                   
      *                                                                         
                  MOVE DF-STATUS-EFF-REV-MTH                            
                                            TO WS-STATUS-EFF-REV-MTH    
                                                                        
                  MOVE WS-STATUS-EFF-REV-MTH(1:4)                       
                                            TO WS-EFF-REV-MTH-YR        
                                                                        
                  MOVE WS-STATUS-EFF-REV-MTH(5:2)                       
                                            TO WS-EFF-REV-MTH-MM        
                  MOVE '05'                 TO WS-EFF-REV-MTH-DD        
                  MOVE '-'                  TO WS-DASH1                 
                                               WS-DASH2                 
                 END-IF                                                 
      *                                                                         
              END-IF                                                    
      *                                                                         
              MOVE WS-EFF-REV-MTH-DATE      TO WS-DATE-FOR-CSC-TIMELINE 
           END-EVALUATE.                                                
                                                                        
           IF WS-STATUS-EFF-REV-MTH > 0   OR                            
              ( DF-STATUS-CD = 'A'        OR                            
                DF-STATUS-CD = 'O'        OR                            
                DF-STATUS-CD = 'P' )                                    
              CALL MCSCB063 USING CWS00063-FIELDS                       
                              ,ABEND-FILE,                              
                              ,WS-MCSCB063-RET-CODE                     
                                                                        
              IF WS-MCSCB063-RET-CODE EQUAL ZEROES                      
      *                                                                         
                 IF DF-STATUS-CD = 'P'                                  
                    MOVE WS-PEND063-CSC-AMT TO WS-CSC-AMT-DESC          
                 ELSE                                                   
                    MOVE WS-CSC-AMT         TO WS-CSC-AMT-DESC          
                END-IF                                                  
      *                                                                         
              ELSE                                                      
      *                                                                         
                MOVE WS-MCSCB063-RET-CODE   TO WS-ACTIVE-RETURN-CODE    
                MOVE 'CALL'                 TO ABEND-FUNCTION           
                MOVE 'MCSCB063'             TO TABLE-1                  
                PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT        
              END-IF                                                    
      *                                                                         
           ELSE                                                         
      *                                                                         
              MOVE ZEROS                    TO WS-CSC-AMT               
           END-IF.                                                      
                                                                        
           PERFORM 7230-SELECT-OFFER-DESC         THRU 7230-EXIT.       
           MOVE WS-OFFER-DESC-INT-LNG       TO S-OFFER-DESC.            
I02262     MOVE FG-SPCL-OFFER-TYPE-CD       TO S-SPCL-OFFER-TYPE-CD.    
                                                                        
           PERFORM 7210-SELECT-OPT-DESC           THRU 7210-EXIT.       
      *                                                                         
           IF WS-CSC-AMT  > 0                                           
              STRING WS-OPT-DESC-INT-LONG   DELIMITED BY '   '          
                     ' with '                                           
                     WS-CSC-AMT-DESC        DELIMITED BY SIZE           
                     WS-CSC-LIT-DESC        DELIMITED BY SIZE           
              INTO S-OPTION-DESC                                        
           ELSE                                                         
              MOVE WS-OPT-DESC-INT-LONG     TO S-OPTION-DESC            
           END-IF.                                                      
      *                                                                         
                                                                        
           MOVE DF-PROMO-CD                 TO   S-PROMO-CD.            
           MOVE DF-STATUS-CD                TO   S-STATUS-CD.           
      *                                                                         
           IF DF-STATUS-CD = WS-APPLIED-A   OR                          
                             WS-OPEN-O      OR                          
                             WS-PENDING-P   OR                          
                  ( DF-STATUS-CD = WS-RENEWED-R AND                     
                    WS-RT-PKG-OPT-SEQ-NO = DF-RT-PKG-OPT-SEQ-NO )       
              MOVE WS-CURRENT-ROW           TO   S-ROW-TYPE             
      *                                                                         
              IF DF-STATUS-CD = WS-PENDING-P                            
                 PERFORM 7220-GET-NEW-RENWED-SEQ-NO                     
                                                  THRU 7220-EXIT        
              END-IF                                                    
      *                                                                         
              ADD +1                        TO WS-CURRENT-ROW-NUM       
              MOVE WS-CURRENT-ROW-NUM       TO S-ROW-NUM                
           ELSE                                                         
      *                                                                         
              MOVE WS-HISTORY-ROW           TO S-ROW-TYPE               
              ADD +1                        TO WS-HISTORY-ROW-NUM       
              MOVE WS-HISTORY-ROW-NUM       TO S-ROW-NUM                
           END-IF.                                                      
      *                                                                         
           MOVE DF-COMM-CHANNEL             TO   S-COMM-CHANNEL.        
           MOVE DF-LAST-UPDATE-USERID       TO   S-LAST-UPDATE-USERID.  
           MOVE DF-OPT-AGRMT-EFF-DT         TO   S-OPT-AGRMT-EFF-DT.    
           MOVE DF-OPT-AGRMT-EFF-TM         TO   S-OPT-AGRMT-EFF-TM.    
           MOVE DF-LAST-UPDATE-TS           TO   S-LAST-UPDATE-TS.      
           MOVE DF-STATUS-EFF-REV-MTH       TO   S-STATUS-EFF-REV-MTH.  
           MOVE DF-PRCE-NEGOTIATED-CD       TO   S-PRICE-NEGOTIATED-CD. 
P00892     MOVE DF-AUTO-REN-OPT-IN-FL       TO   S-AUTO-REN-OPT-IN-FL.  
           PERFORM 8010-INSERT-GTT-R1             THRU 8010-EXIT.       
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *****************************************************************         
      * 7000-OPEN-RTPKAGR-CURSOR.                                     *         
      *****************************************************************         
                                                                        
       7000-OPEN-RTPKAGR-CURSOR.                                        
                                                                        
           EXEC SQL                                                     
              OPEN RTPKAGR_CSR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE   =  SUCCESSFUL-CALL                
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7000'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN '                  TO ABEND-FUNCTION           
              MOVE 'CSS_ACCT_RTPK_AGR'      TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE DF-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE DF-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE DF-IC-NO                 TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7100-FETCH-RTPKAGR-CURSOR.                                    *         
      *     FETCH CURSOR TO GET ALL RECORDS SELECTED.                 *         
      *****************************************************************         
                                                                        
       7100-FETCH-RTPKAGR-CURSOR.                                       
                                                                        
           EXEC SQL                                                     
              FETCH RTPKAGR_CSR                                         
              INTO                                                      
                   :DF-RT-PKG-OPT-SEQ-NO                                
                  ,:DF-OFFER-CD                                         
                  ,:DF-OPTION-CD                                        
                  ,:DF-PROMO-CD                                         
                  ,:DF-STATUS-CD                                        
                  ,:DF-COMM-CHANNEL                                     
                  ,:DF-LAST-UPDATE-USERID                               
                  ,:DF-OPT-AGRMT-EFF-DT                                 
                  ,:DF-OPT-AGRMT-EFF-TM                                 
                  ,:DF-LAST-UPDATE-TS                                   
                  ,:DF-STATUS-EFF-REV-MTH                               
                  ,:DF-PRCE-NEGOTIATED-CD                               
P00892            ,:DF-AUTO-REN-OPT-IN-FL                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7100'                   TO ACTIVE-PARAGRAPH         
              MOVE 'FETCH'                  TO ABEND-FUNCTION           
              MOVE 'CSS_ACCT_RTPK_AGR'      TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE DF-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE DF-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE DF-IC-NO                 TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7200-CLOSE-RTPKAGR-CURSOR.                                    *         
      *****************************************************************         
                                                                        
       7200-CLOSE-RTPKAGR-CURSOR.                                       
                                                                        
           EXEC SQL                                                     
              CLOSE RTPKAGR_CSR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7200'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE 'CSS_ACCT_RTPK_AGR'      TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE DF-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE DF-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE DF-IC-NO                 TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7210-SELECT-OPT-DESC.                                         *         
      *****************************************************************         
                                                                        
       7210-SELECT-OPT-DESC.                                            
                                                                        
           EXEC SQL                                                     
              SELECT LTRIM(RTRIM(FI.OPTION_CD)) + ' - ' + LTRIM(RTRIM(
           FI.OPT_DESC_INT_LONG))                  
                INTO :WS-OPT-DESC-INT-LONG                              
                FROM CRM_RT_PKG_OPTION FI                               
               WHERE FI.OPTION_CD      = :FI-OPTION-CD                  
                 AND FI.OPT_VSTART_TS <= CIS.CURRENT$TIMESTAMP()              
                 AND FI.OPT_VEND_TS   >= CIS.CURRENT$TIMESTAMP()              
                 AND FI.PROC_STATUS_CD = 'AC'                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT STRIP(FI.OPTION_CD) || ' - ' ||                            
MFA-TR*              STRIP(CHAR(FI.OPT_DESC_INT_LONG))                          
MFA-TR*         INTO :WS-OPT-DESC-INT-LONG                                      
MFA-TR*         FROM CRM_RT_PKG_OPTION FI                                       
MFA-TR*        WHERE FI.OPTION_CD      = :FI-OPTION-CD                          
MFA-TR*          AND FI.OPT_VSTART_TS <= CURRENT TIMESTAMP                      
MFA-TR*          AND FI.OPT_VEND_TS   >= CURRENT TIMESTAMP                      
MFA-TR*          AND FI.PROC_STATUS_CD = 'AC'                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7210'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CRM_RT_PKG_OPTION'      TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE WS-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE FI-OPTION-CD             TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7220-GET-NEW-RENWED-SEQ-NO                                    *         
      *****************************************************************         
                                                                        
       7220-GET-NEW-RENWED-SEQ-NO.                                      
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) RT_PKG_OPT_SEQ_NO                                  
                INTO :WS-RT-PKG-OPT-SEQ-NO                              
                FROM CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)                 
               WHERE DF.ACCOUNT_NO          = :DF-ACCOUNT-NO            
                 AND DF.CODE_UTIL_TYPE      = :DF-CODE-UTIL-TYPE        
                 AND DF.IC_NO               = :DF-IC-NO                 
                 AND DF.STATUS_CD           = 'R'                       
                 AND EXISTS (                                           
                     SELECT ACCOUNT_NO                                  
                       FROM CSS_ACCT_RTPK_AGR TM WITH(READUNCOMMITTED)          
                      WHERE DF.ACCOUNT_NO      = TM.ACCOUNT_NO          
                        AND DF.CODE_UTIL_TYPE  = TM.CODE_UTIL_TYPE      
                        AND DF.IC_NO           = TM.IC_NO               
                        AND TM.STATUS_CD       = 'P'                    
                     )                                                  
               ORDER BY                                                 
                     DF.RT_PKG_OPT_SEQ_NO DESC                          
                                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RT_PKG_OPT_SEQ_NO                                          
MFA-TR*         INTO :WS-RT-PKG-OPT-SEQ-NO                                      
MFA-TR*         FROM CSS_ACCT_RTPK_AGR DF                                       
MFA-TR*        WHERE DF.ACCOUNT_NO          = :DF-ACCOUNT-NO                    
MFA-TR*          AND DF.CODE_UTIL_TYPE      = :DF-CODE-UTIL-TYPE                
MFA-TR*          AND DF.IC_NO               = :DF-IC-NO                         
MFA-TR*          AND DF.STATUS_CD           = 'R'                               
MFA-TR*          AND EXISTS (                                                   
MFA-TR*              SELECT ACCOUNT_NO                                          
MFA-TR*                FROM CSS_ACCT_RTPK_AGR TM                                
MFA-TR*               WHERE DF.ACCOUNT_NO      = TM.ACCOUNT_NO                  
MFA-TR*                 AND DF.CODE_UTIL_TYPE  = TM.CODE_UTIL_TYPE              
MFA-TR*                 AND DF.IC_NO           = TM.IC_NO                       
MFA-TR*                 AND TM.STATUS_CD       = 'P'                            
MFA-TR*              )                                                          
MFA-TR*        ORDER BY                                                         
MFA-TR*              DF.RT_PKG_OPT_SEQ_NO DESC                                  
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7220'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_ACCT_RTPK_AGR'      TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE DF-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE DF-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE DF-IC-NO                 TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
       7220-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *****************************************************************         
      * 7225-GET-OLD-EFF-REV-MNTH.                                    *         
      *****************************************************************         
       7225-GET-OLD-EFF-REV-MNTH.                                       
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) BG.REVENUE_MONTH                                  
                 INTO :BG-REVENUE-MONTH                                 
                 FROM CSS_BILLING_DET   BG WITH(READUNCOMMITTED)                
                WHERE BG.ACCOUNT_NO        = :DF-ACCOUNT-NO             
                  AND BG.IC_NO             = :DF-IC-NO                  
                  AND BG.CODE_UTIL_TYPE    = :DF-CODE-UTIL-TYPE         
                  AND BG.RT_PKG_OPT_SEQ_NO = :DF-RT-PKG-OPT-SEQ-NO      
                  AND BG.CODE_BILL_CALC    =  'A'                       
                  AND BG.CODE_BILL_ITM_TYPE = 'C'                       
                  AND BG.CODE_BILL_ITM_IND  = 'A'                       
                  AND BG.REVENUE_MONTH     > 0                          
                ORDER BY REVENUE_MONTH ASC                              
                                                    
                                                                 
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT BG.REVENUE_MONTH                                          
MFA-TR*          INTO :BG-REVENUE-MONTH                                         
MFA-TR*          FROM CSS_BILLING_DET   BG                                      
MFA-TR*         WHERE BG.ACCOUNT_NO        = :DF-ACCOUNT-NO                     
MFA-TR*           AND BG.IC_NO             = :DF-IC-NO                          
MFA-TR*           AND BG.CODE_UTIL_TYPE    = :DF-CODE-UTIL-TYPE                 
MFA-TR*           AND BG.RT_PKG_OPT_SEQ_NO = :DF-RT-PKG-OPT-SEQ-NO              
MFA-TR*           AND BG.CODE_BILL_CALC    =  'A'                               
MFA-TR*           AND BG.CODE_BILL_ITM_TYPE = 'C'                               
MFA-TR*           AND BG.CODE_BILL_ITM_IND  = 'A'                               
MFA-TR*           AND BG.REVENUE_MONTH     > 0                                  
MFA-TR*         ORDER BY REVENUE_MONTH ASC                                      
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7225                                                    
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE ZEROS TO BG-REVENUE-MONTH                         
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7225'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_BILLING_DET'        TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE 'DF_RT_PKG_OPT_SEQ_NO'   TO TABLE-ELEMENT-4          
              MOVE DF-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE DF-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE DF-IC-NO                 TO HOSTVAR-ELEMENT-3        
              MOVE DF-RT-PKG-OPT-SEQ-NO     TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
       7225-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * 7230-SELECT-OFFER-DESC                                        *         
      *****************************************************************         
                                                                        
       7230-SELECT-OFFER-DESC.                                          
                                                                        
           EXEC SQL                                                     
              SELECT LTRIM(RTRIM(OFFER_CD)) + ' - ' + LTRIM(RTRIM(
           OFFER_DESC_INT_LNG))                    
I02262              ,FG.SPCL_OFFER_TYPE_CD                              
                INTO :WS-OFFER-DESC-INT-LNG                             
I02262              ,:FG-SPCL-OFFER-TYPE-CD                             
                FROM CRM_RT_PKG_OFFER FG                                
               WHERE OFFER_CD          = :DF-OFFER-CD                   
                 AND FG.OFF_VSTART_TS <= CIS.CURRENT$TIMESTAMP()              
                 AND FG.OFF_VEND_TS   >= CIS.CURRENT$TIMESTAMP()              
                 AND FG.PROC_STATUS_CD = 'AC'                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT STRIP(OFFER_CD) || ' - ' ||                                
MFA-TR*              STRIP(CHAR(OFFER_DESC_INT_LNG))                            
MFA-TR*             ,FG.SPCL_OFFER_TYPE_CD                                      
MFA-TR*         INTO :WS-OFFER-DESC-INT-LNG                                     
MFA-TR*             ,:FG-SPCL-OFFER-TYPE-CD                                     
MFA-TR*         FROM CRM_RT_PKG_OFFER FG                                        
MFA-TR*        WHERE OFFER_CD          = :DF-OFFER-CD                           
MFA-TR*          AND FG.OFF_VSTART_TS <= CURRENT TIMESTAMP                      
MFA-TR*          AND FG.OFF_VEND_TS   >= CURRENT TIMESTAMP                      
MFA-TR*          AND FG.PROC_STATUS_CD = 'AC'                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7230'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CRM_RT_PKG_OFFER'       TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'OFFER_CD'               TO TABLE-ELEMENT-2          
              MOVE WS-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE DF-OFFER-CD              TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
       7230-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00892******************************************************************        
P00892* 7300-GET-RTPKG-ROW-DET                                         *        
      *    DETAILS OF RTPKG AGR DETAILS FOR CORRESPONDING              *        
      ******************************************************************        
P00892 7300-GET-RTPKG-ROW-DET.                                          
                                                                        
           EXEC SQL                                                     
            SELECT  DF.RT_PKG_OPT_SEQ_NO                                
                   ,DF.OFFER_CD                                         
                   ,DF.OPTION_CD                                        
                   ,DF.PROMO_CD                                         
                   ,DF.STATUS_CD                                        
                   ,DF.COMM_CHANNEL                                     
                   ,DF.LAST_UPDATE_USERID                               
                   ,DF.OPT_AGRMT_EFF_DT                                 
                   ,CIS.CHAR2$TIME(DF.OPT_AGRMT_EFF_TM,'USA')                   
                   ,REPLACE(REPLACE(CONVERT(CHAR(26), DF.LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS                         
                   ,DF.STATUS_EFF_REV_MTH                               
                   ,DF.PRCE_NEGOTIATED_CD                               
                   ,DF.AUTO_REN_OPT_IN_FL                               
              INTO                                                      
                   :DF-RT-PKG-OPT-SEQ-NO                                
                  ,:DF-OFFER-CD                                         
                  ,:DF-OPTION-CD                                        
                  ,:DF-PROMO-CD                                         
                  ,:DF-STATUS-CD                                        
                  ,:DF-COMM-CHANNEL                                     
                  ,:DF-LAST-UPDATE-USERID                               
                  ,:DF-OPT-AGRMT-EFF-DT                                 
                  ,:DF-OPT-AGRMT-EFF-TM                                 
                  ,:DF-LAST-UPDATE-TS                                   
                  ,:DF-STATUS-EFF-REV-MTH                               
                  ,:DF-PRCE-NEGOTIATED-CD                               
P00892            ,:DF-AUTO-REN-OPT-IN-FL                               
              FROM CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)                   
             WHERE DF.ACCOUNT_NO          = :DF-ACCOUNT-NO              
               AND DF.CODE_UTIL_TYPE      = :DF-CODE-UTIL-TYPE          
               AND DF.IC_NO               = :DF-IC-NO                   
               AND DF.RT_PKG_OPT_SEQ_NO   = :DF-RT-PKG-OPT-SEQ-NO       
                                                                 
                                                            
P00892     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SELECT  DF.RT_PKG_OPT_SEQ_NO                                        
MFA-TR*            ,DF.OFFER_CD                                                 
MFA-TR*            ,DF.OPTION_CD                                                
MFA-TR*            ,DF.PROMO_CD                                                 
MFA-TR*            ,DF.STATUS_CD                                                
MFA-TR*            ,DF.COMM_CHANNEL                                             
MFA-TR*            ,DF.LAST_UPDATE_USERID                                       
MFA-TR*            ,DF.OPT_AGRMT_EFF_DT                                         
MFA-TR*            ,CHAR(DF.OPT_AGRMT_EFF_TM,USA)                               
MFA-TR*            ,DF.LAST_UPDATE_TS                                           
MFA-TR*            ,DF.STATUS_EFF_REV_MTH                                       
MFA-TR*            ,DF.PRCE_NEGOTIATED_CD                                       
MFA-TR*            ,DF.AUTO_REN_OPT_IN_FL                                       
MFA-TR*       INTO                                                              
MFA-TR*            :DF-RT-PKG-OPT-SEQ-NO                                        
MFA-TR*           ,:DF-OFFER-CD                                                 
MFA-TR*           ,:DF-OPTION-CD                                                
MFA-TR*           ,:DF-PROMO-CD                                                 
MFA-TR*           ,:DF-STATUS-CD                                                
MFA-TR*           ,:DF-COMM-CHANNEL                                             
MFA-TR*           ,:DF-LAST-UPDATE-USERID                                       
MFA-TR*           ,:DF-OPT-AGRMT-EFF-DT                                         
MFA-TR*           ,:DF-OPT-AGRMT-EFF-TM                                         
MFA-TR*           ,:DF-LAST-UPDATE-TS                                           
MFA-TR*           ,:DF-STATUS-EFF-REV-MTH                                       
MFA-TR*           ,:DF-PRCE-NEGOTIATED-CD                                       
MFA-TR*           ,:DF-AUTO-REN-OPT-IN-FL                                       
MFA-TR*       FROM CSS_ACCT_RTPK_AGR DF                                         
MFA-TR*      WHERE DF.ACCOUNT_NO          = :DF-ACCOUNT-NO                      
MFA-TR*        AND DF.CODE_UTIL_TYPE      = :DF-CODE-UTIL-TYPE                  
MFA-TR*        AND DF.IC_NO               = :DF-IC-NO                           
MFA-TR*        AND DF.RT_PKG_OPT_SEQ_NO   = :DF-RT-PKG-OPT-SEQ-NO               
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7300                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7300'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_ACCT_RTPK_AGR'      TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE 'RT_PKG_OPT_SEQ_NO'      TO TABLE-ELEMENT-4          
              MOVE DF-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE DF-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE DF-IC-NO                 TO HOSTVAR-ELEMENT-3        
              MOVE DF-RT-PKG-OPT-SEQ-NO     TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
P00892 7300-EXIT.                                                       
P00892     EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7550-GET-RULE-XREF-ID                                          *        
      *                                                                *        
      ******************************************************************        
       7550-GET-RULE-XREF-ID.                                           
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           BUS_RULE_XREF_ID, 121), ' ', '-'), ':', '.') 
           BUS_RULE_XREF_ID                                   
                INTO :S-RS2-BUS-RULE-XREF-ID                            
                FROM CSS_BUS_RULE   [1R] WITH(READUNCOMMITTED)                  
                    ,CSS_BUS_RULE_XREF [1T] WITH(READUNCOMMITTED)               
               WHERE [1R].BUS_RULE_ID = :S-RS2-BUS-RULE-ID                
                 AND [1R].BUS_RULE_ID = [1T].BUS_RULE_ID                    
                                             
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BUS_RULE_XREF_ID                                           
MFA-TR*         INTO :S-RS2-BUS-RULE-XREF-ID                                    
MFA-TR*         FROM CSS_BUS_RULE   1R                                          
MFA-TR*             ,CSS_BUS_RULE_XREF 1T                                       
MFA-TR*        WHERE 1R.BUS_RULE_ID = :S-RS2-BUS-RULE-ID                        
MFA-TR*          AND 1R.BUS_RULE_ID = 1T.BUS_RULE_ID                            
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7550                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
               MOVE SPACES                  TO ABEND-TABLES             
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
               MOVE '7550'                  TO ACTIVE-PARAGRAPH         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_BUS_RULE'          TO TABLE-1                  
               MOVE 'BUS_RULE_ID'           TO TABLE-ELEMENT-1          
               MOVE S-RS2-BUS-RULE-ID       TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8000A-DELETE-GTT-ROWS.                                        *         
      *****************************************************************         
       8000A-DELETE-GTT-ROWS.                                           
      *                                                                         
            EXEC SQL                                                    
                DELETE FROM #CSR04659_R1                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR04659_R1                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1          
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000A'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04659_R1'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
      *                                                                         
       8000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *                                                               *         
      * 8000B-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000B-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04659_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04659_R2                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE          
                                         S-RETURN-CODE-2.               
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES          TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2             
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME    TO ABEND-PROGRAM               
                    MOVE SQLCODE         TO ABEND-SQLCODE               
                    MOVE SQLSTATE        TO ABEND-SQLSTATE              
                    MOVE '8000B'         TO ACTIVE-PARAGRAPH            
                    MOVE 'DELETE'        TO ABEND-FUNCTION              
                    MOVE SPACES          TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                    MOVE 'CSR04659_R2'   TO TABLE-1                     
                    MOVE SPACES          TO TABLE-ELEMENT-1             
                    MOVE SPACES          TO HOSTVAR-ELEMENT-1           
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
      *                                                                         
       8000B-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ****************************************************************          
      * 8010-INSERT-GTT-R1   - RATE PACKAGE AGREEMENT DETAILS        *          
      ****************************************************************          
       8010-INSERT-GTT-R1.                                              
                                                                        
           EXEC SQL                                                     
               INSERT INTO #CSR04659_R1                          
                   (                                                    
                     RETURN_CODE                                        
                    ,APPL_RETURN_CODE                                   
                    ,RT_PKG_OPT_SEQ_NO                                  
                    ,OFFER_CD                                           
                    ,OPTION_DESC                                        
                    ,PROMO_CD                                           
                    ,STATUS_CD                                          
                    ,COMM_CHANNEL                                       
                    ,LAST_UPDATE_USERID                                 
                    ,OPT_AGRMT_EFF_DT                                   
                    ,OPT_AGRMT_EFF_TM                                   
                    ,LAST_UPDATE_TS                                     
                    ,OPTION_CD                                          
                    ,ROW_TYPE                                           
                    ,OFFER_DESC                                         
                    ,ROW_NUM                                            
                    ,STATUS_EFF_REV_MTH                                 
                    ,PRICE_NEGOTIATED_CD                                
P00892              ,AUTO_REN_OPT_IN_FL                                 
I02262              ,SPCL_OFFER_TYPE_CD                                 
                   )                                                    
               VALUES                                                   
                   (                                                    
                     :S-RETURN-CODE-1                                   
                    ,:S-APPL-RETURN-CODE-1                              
                    ,:S-RT-PKG-OPT-SEQ-NO                               
                    ,:S-OFFER-CD                                        
                    ,:S-OPTION-DESC                                     
                    ,:S-PROMO-CD                                        
                    ,:S-STATUS-CD                                       
                    ,:S-COMM-CHANNEL                                    
                    ,:S-LAST-UPDATE-USERID                              
                    ,:S-OPT-AGRMT-EFF-DT                                
                    ,:S-OPT-AGRMT-EFF-TM                                
                    ,:S-LAST-UPDATE-TS                                  
                    ,:S-OPTION-CD                                       
                    ,:S-ROW-TYPE                                        
                    ,:S-OFFER-DESC                                      
                    ,:S-ROW-NUM                                         
                    ,:S-STATUS-EFF-REV-MTH                              
                    ,:S-PRICE-NEGOTIATED-CD                             
P00892              ,:S-AUTO-REN-OPT-IN-FL                              
I02262              ,:S-SPCL-OFFER-TYPE-CD                              
                   )                                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO SESSION.CSR04659_R1                                  
MFA-TR*            (                                                            
MFA-TR*              RETURN_CODE                                                
MFA-TR*             ,APPL_RETURN_CODE                                           
MFA-TR*             ,RT_PKG_OPT_SEQ_NO                                          
MFA-TR*             ,OFFER_CD                                                   
MFA-TR*             ,OPTION_DESC                                                
MFA-TR*             ,PROMO_CD                                                   
MFA-TR*             ,STATUS_CD                                                  
MFA-TR*             ,COMM_CHANNEL                                               
MFA-TR*             ,LAST_UPDATE_USERID                                         
MFA-TR*             ,OPT_AGRMT_EFF_DT                                           
MFA-TR*             ,OPT_AGRMT_EFF_TM                                           
MFA-TR*             ,LAST_UPDATE_TS                                             
MFA-TR*             ,OPTION_CD                                                  
MFA-TR*             ,ROW_TYPE                                                   
MFA-TR*             ,OFFER_DESC                                                 
MFA-TR*             ,ROW_NUM                                                    
MFA-TR*             ,STATUS_EFF_REV_MTH                                         
MFA-TR*             ,PRICE_NEGOTIATED_CD                                        
MFA-TR*             ,AUTO_REN_OPT_IN_FL                                         
MFA-TR*             ,SPCL_OFFER_TYPE_CD                                         
MFA-TR*            )                                                            
MFA-TR*        VALUES                                                           
MFA-TR*            (                                                            
MFA-TR*              :S-RETURN-CODE-1                                           
MFA-TR*             ,:S-APPL-RETURN-CODE-1                                      
MFA-TR*             ,:S-RT-PKG-OPT-SEQ-NO                                       
MFA-TR*             ,:S-OFFER-CD                                                
MFA-TR*             ,:S-OPTION-DESC                                             
MFA-TR*             ,:S-PROMO-CD                                                
MFA-TR*             ,:S-STATUS-CD                                               
MFA-TR*             ,:S-COMM-CHANNEL                                            
MFA-TR*             ,:S-LAST-UPDATE-USERID                                      
MFA-TR*             ,:S-OPT-AGRMT-EFF-DT                                        
MFA-TR*             ,:S-OPT-AGRMT-EFF-TM                                        
MFA-TR*             ,:S-LAST-UPDATE-TS                                          
MFA-TR*             ,:S-OPTION-CD                                               
MFA-TR*             ,:S-ROW-TYPE                                                
MFA-TR*             ,:S-OFFER-DESC                                              
MFA-TR*             ,:S-ROW-NUM                                                 
MFA-TR*             ,:S-STATUS-EFF-REV-MTH                                      
MFA-TR*             ,:S-PRICE-NEGOTIATED-CD                                     
MFA-TR*             ,:S-AUTO-REN-OPT-IN-FL                                      
MFA-TR*             ,:S-SPCL-OFFER-TYPE-CD                                      
MFA-TR*            )                                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R1 = 'Y'             
              ADD +1 TO CTR-ROWS-RS1                                    
              INITIALIZE GTT-RETURN-FIELDS                              
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE '8010'                   TO ACTIVE-PARAGRAPH         
              MOVE 'Y'                      TO WS-ERR-INSRT-R1          
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE 'CSR04659_R1'            TO TABLE-1                  
              MOVE SPACES                   TO TABLE-ELEMENT-1          
              MOVE SPACES                   TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
      *                                                                         
       8010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8020-INSERT-GTT-R2.                                            *        
      ******************************************************************        
       8020-INSERT-GTT-R2.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04659_R2                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,BUS_RULE_ID                                          
                  ,BUS_RULE_RESULT_CD                                   
                  ,BUS_RULE_XREF_ID                                     
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-2                                     
                  ,:S-APPL-RETURN-CODE-2                                
                  ,:S-RS2-BUS-RULE-ID                                   
                  ,:S-RS2-BUS-RULE-RESULT-CD                            
                  ,:S-RS2-BUS-RULE-XREF-ID                              
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04659_R2                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,BUS_RULE_ID                                                  
MFA-TR*           ,BUS_RULE_RESULT_CD                                           
MFA-TR*           ,BUS_RULE_XREF_ID                                             
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-2                                             
MFA-TR*           ,:S-APPL-RETURN-CODE-2                                        
MFA-TR*           ,:S-RS2-BUS-RULE-ID                                           
MFA-TR*           ,:S-RS2-BUS-RULE-RESULT-CD                                    
MFA-TR*           ,:S-RS2-BUS-RULE-XREF-ID                                      
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-2.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R2 = 'Y'             
              ADD +1                        TO CTR-ROWS-RS2             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO  ABEND-PROGRAM           
              MOVE '8020'                   TO  ACTIVE-PARAGRAPH        
              MOVE SQLCODE                  TO  ABEND-SQLCODE           
              MOVE 'INSERT'                 TO  ABEND-FUNCTION          
              MOVE 'Y'                      TO  WS-ERR-INSRT-R2         
              MOVE SPACES                   TO  ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSR04659_R2'            TO  TABLE-1                 
              MOVE SPACES                   TO  TABLE-ELEMENT-1         
              MOVE SPACES                   TO  HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
        8020-EXIT.                                                      
            EXIT.                                                       
      *****************************************************************         
      *                                                               *         
      * 8800-CHECK-RESULTS.                                           *         
      *****************************************************************         
       8800-CHECK-RESULTS.                                              
                                                                        
           IF CTR-ROWS-RS1 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-1                            
              MOVE 100                      TO S-RETURN-CODE-1          
                                               S-APPL-RETURN-CODE-1     
              PERFORM 8010-INSERT-GTT-R1        THRU 8010-EXIT          
           END-IF.                                                      
      *                                                                         
           IF CTR-ROWS-RS2 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-2                            
              MOVE 100                      TO S-RETURN-CODE-2          
                                               S-APPL-RETURN-CODE-2     
              PERFORM 8020-INSERT-GTT-R2        THRU 8020-EXIT          
           END-IF.                                                      
      *                                                                         
       8800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8900-SEND-DONE.                                                *        
      ******************************************************************        
       8900-SEND-DONE.                                                  
                                                                        
           MOVE PROGRAM-NAME                TO ABEND-PROGRAM            
           MOVE '8900'                      TO ACTIVE-PARAGRAPH         
           MOVE 'OPEN'                      TO ABEND-FUNCTION           
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE 'CSR04659_R1'            TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C2                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-2.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE 'CSR04659_R2'            TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 9000-SEND-ERROR-RESULT                                         *        
      ******************************************************************        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE       TO ABEND-SQLCODE            
                                               S-RETURN-CODE-1          
                                               S-RETURN-CODE-2.         
                                                                        
           MOVE WS-APPL-RETURN-CODE         TO S-APPL-RETURN-CODE-1     
                                               S-APPL-RETURN-CODE-2.    
                                                                        
           MOVE SQLERRMC                    TO ABEND-SQLERRMC.          
                                                                        
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'               TO ABEND-FUNCTION           
           END-IF.                                                      
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1           THRU 0100A-EXIT.      
           PERFORM 0100B-DECLARE-GTT-R2           THRU 0100B-EXIT.      
                                                                        
           PERFORM 8010-INSERT-GTT-R1             THRU 8010-EXIT.       
           PERFORM 8020-INSERT-GTT-R2             THRU 8020-EXIT.       
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9700-ABEND-PROCESSING.                                         *        
      ******************************************************************        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT         THRU 9000-EXIT.       
           PERFORM 9900-SQL-ERROR-ROUTINE         THRU 9900-EXIT.       
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900-SQL-ERROR-ROUTINE.                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9999-END-PROGRAM.                                              *        
      ******************************************************************        
                                                                        
       9999-END-PROGRAM.                                                
                                                                        
            PERFORM 8800-CHECK-RESULTS            THRU 8800-EXIT        
            PERFORM 8900-SEND-DONE                THRU 8900-EXIT        
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
