       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.      CSR04658.                                       
       AUTHOR.       SAKTHIVEL MATHIYAZHAGAN.                           
COB303 DATE-WRITTEN. OCTOBER 22, 2013.                                  
       DATE-COMPILED.                                                   
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE:  CSR04658              --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--                                                            --         
      *--  CSR04658 :                                                --         
      *--                                                            --         
      *--  #  THIS STORED PROCEDURE IS PERFORM INSERT,UPDATE AND     --         
      *--     DELETE FOR MASTER DEPENDENT RELATIONSHIP SCREEN.       --         
      *--                                                            --         
      *--     CLONED FROM: CSR02140                                  --         
      *--                                                            --         
      *--  NOTE: THIS SP WRITING A TRANSACTION HISTORY FOR           --         
      *--        MASTER & DEPENDENT METER ACCOUNTS.                  --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *--  PARAMETERS                                                --         
      *--                                                            --         
      *--      IN                                                    --         
      *--                                                            --         
      *--            I_UPDT_ACTION_IND       CHAR(01))               --         
      *--            I_USER_ID               CHAR(07)                --         
      *--            I_ACCOUNT_NO_MST        DECIMAL(13)             --         
      *--            I_IC_NO_MST             SMALLINT                --         
      *--            I_METER_REF_NO_MST      SMALLINT                --         
      *--            I_ACCOUNT_NO_DEP        DECIMAL(13)             --         
      *--            I_IC_NO_DEP             SMALLINT                --         
      *--            I_METER_REF_NO_DEP      SMALLINT                --         
      *--            I_CODE_UTIL_TYPE        CHAR(01)                --         
      *--            I_CODE_RELATION_TYPE    CHAR(01)                --         
      *--            I_DEP_REL_START_DATE    CHAR(10)                --         
      *--            I_DEP_REL_END_DATE      CHAR(10)                --         
      *--            I_TRAN_COMMENT          CHAR(210)               --         
      *--                                                            --         
      *--      OUT                                                   --         
      *--            NONE                                            --         
      *--                                                            --         
      *--      INOUT                                                 --         
      *--            NONE                                            --         
      *--                                                            --         
      *--  RESULT SET                                                --         
      *--            RETURN_CODE             INTEGER                 --         
      *--            APPL_RETURN_CODE        INTEGER                 --         
      *--            BUS_RULE_ID             CHAR(10)                --         
      *--            ACTION_TYPE_CD          CHAR(08)                --         
      *--            BUS_RULE_XREF_ID        CHAR(26)                --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                        MODIFICATION LOG                    --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
P00738*--  10-22-2013    MS93554     PROGRAM INTIALLY WRITTEN.       --         
      *----------------------------------------------------------------         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04658'.
MSQ017     COPY MFASQLM.
                                                                        
       01 WS-WORKING-STORAGE.                                           
          05 WS-SQLSTATE                  PIC X(05) VALUE SPACES.       
                                                                        
       01 WS-GENERAL-VARIABLE.                                          
          05 PROGRAM-NAME                 PIC X(08) VALUE 'CSR04658'.   
          05 WS-RESP-AREA-ID              PIC X(03) VALUE SPACES.       
COB305    05 WS-ACCOUNT-NO        PIC S9(13) USAGE COMP-3 VALUE 0.      
                                                                        
       01 WS-CURR-MST-DEP-FIELDS.                                       
          05 WS-CURR-USER-ID              PIC X(07)  VALUE SPACES.      
COB305    05 WS-CURR-ACCOUNT-NO-MST        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.     
          05 WS-CURR-IC-NO-MST            PIC S9(04) COMP VALUE 0.      
          05 WS-CURR-MTR-REF-NO-MST       PIC S9(04) COMP VALUE 0.      
COB305    05 WS-CURR-ACCOUNT-NO-DEP        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.     
          05 WS-CURR-IC-NO-DEP            PIC S9(04) COMP VALUE 0.      
          05 WS-CURR-MTR-REF-NO-DEP       PIC S9(04) COMP VALUE 0.      
          05 WS-CURR-CODE-UTIL-TYPE       PIC X(01)  VALUE SPACES.      
          05 WS-CURR-CODE-RLTN-TYP        PIC X(01)  VALUE SPACES.      
          05 WS-CURR-DEP-REL-START-DT     PIC X(10)  VALUE SPACES.      
          05 WS-CURR-DEP-REL-END-DT       PIC X(10)  VALUE SPACES.      
          05 WS-CURR-TRAN-COMMENT         PIC X(210) VALUE SPACES.      
                                                                        
       01 WS-SWITCHES.                                                  
          05 ALL-DONE-SW                  PIC X(01) VALUE 'N'.          
             88 NOT-ALL-DONE                        VALUE 'N'.          
             88 ALL-DONE                            VALUE 'Y'.          
          05 SEND-DONE-SW                 PIC X(01) VALUE 'Y'.          
             88 SEND-DONE-ERROR                     VALUE 'N'.          
             88 SEND-DONE-OK                        VALUE 'Y'.          
          05 WS-CURR-UPDT-ACTION-IND      PIC X(01) VALUE SPACES.       
             88 MST-DEP-INSERT                      VALUE 'I'.          
             88 MST-DEP-UPDATE                      VALUE 'U'.          
             88 MST-DEP-DELETE                      VALUE 'D'.          
          05 WS-STATE-LINE-RATE           PIC X(03) VALUE SPACES.       
             88 STATE-LINE-RATE                     VALUES '065' '066'. 
          05 WS-MST-DEP-REL-STATUS        PIC X(01) VALUE 'N'.          
             88 MST-DEP-REL-EXIST                   VALUE 'Y'.          
          05 WS-STATE-LINE-FCTR-STAT      PIC X(01) VALUE 'N'.          
             88 STSTELINE-FCTR-EXIST                VALUE 'Y'.          
             88 STATELINE-FCTR-NOT-EXIST            VALUE 'N'.          
          05 WS-SAME-FCTR-STATUS          PIC X(01) VALUE 'N'.          
             88 SAME-FCTR-EXIST                     VALUE 'Y'.          
             88 SAME-FCTR-NOT-EXIST                 VALUE 'N'.          
          05 WS-ROW-ALREADY-EXIST         PIC X(01) VALUE 'N'.          
             88 ROW-ALREADY-EXIST                   VALUE 'Y'.          
          05 WS-CODE-EST-OK-DEP-UPDT      PIC X(01) VALUE 'N'.          
             88 CODE-EST-OK-DEP-UPDT                VALUE 'Y'.          
                                                                        
       01 WS-LITERALS.                                                  
          05 WS-NO                        PIC X(01) VALUE 'N'.          
          05 WS-YES                       PIC X(01) VALUE 'Y'.          
          05 WS-ONE                       PIC 9(01) VALUE 1.            
          05 WS-ZERO                      PIC 9(01) VALUE 0.            
          05 WS-FAILED                    PIC X(01) VALUE 'F'.          
          05 WS-ELEC                      PIC X(01) VALUE 'E'.          
          05 WS-GAS                       PIC X(01) VALUE 'G'.          
          05 WS-UNMETER                   PIC X(01) VALUE 'U'.          
          05 WS-STATE-LINE                PIC X(02) VALUE 'SL'.         
          05 WS-DO-NOT-ESTIMATE-C         PIC X(01) VALUE 'C'.          
                                                                        
       01 GTT-MISC-FIELDS.                                              
          05 GTT-ROW.                                                   
             49 GTT-ROW-LEN               PIC S9(04) COMP.              
             49 GTT-ROW-CHAR              PIC X(1024).                  
          05 GTT-SQLCODE                  PIC S9(9) COMP.               
                                                                        
       01 COUNTER-FIELDS.                                               
          05  CTR-COLUMN                  PIC S9(9) COMP VALUE 1.       
          05  CTR-ROWS                    PIC S9(9) COMP VALUE 0.       
                                                                        
       01 WORK-FIELDS.                                                  
          05  MAX-LENGTH-PARM             PIC S9(9) COMP.               
          05  WRKLEN1                     PIC S9(9) COMP.               
          05  WRKLEN2                     PIC S9(9) COMP.               
          05  WRK-DONE-STATUS             PIC S9(9) COMP.               
                                                                        
       01 GTT-RETURN-FIELDS.                                            
          05  S-RETURN-CODE               PIC S9(09) COMP VALUE 0.      
          05  S-APPL-RETURN-CODE          PIC S9(09) COMP VALUE 0.      
          05  S-BUS-RULE-ID               PIC X(10)  VALUE SPACES.      
          05  S-BUS-RULE-RESULT-CD        PIC X(08)  VALUE SPACES.      
          05  S-BUS-RULE-XREF-ID          PIC X(26)  VALUE SPACES.      
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME                 PIC X(18)  VALUE SPACES.      
            10  S-SQLCODE                 PIC S9(9)  COMP VALUE 0.      
            10  S-SQLSTATE                PIC X(5)   VALUE ' '.         
            10  S-TABLE-NAME              PIC X(18)  VALUE SPACES.      
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L    PIC S9(4)  USAGE COMP.        
                49  S-HOST-VARIABLES-V    PIC X(255).                   
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L     PIC S9(4)  USAGE COMP.        
                49  S-SQL-STATEMENT-V     PIC X(255).                   
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L   PIC S9(4)  USAGE COMP.        
                49  S-SQL-DESCRIPTION-V   PIC X(255).                   
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_USER_PROFILE     PF                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_UTIL_ENVRNMT     UT                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_BUS_RULE_XREF    1T                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRULXRF                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_MNT_TRANS_HIST   MH                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_MT_TRN_HST_DET   MI                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_UTL_BILL_REL    UR                                     *         
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBUTLREL                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_CODE_VALUE      UV                                               
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCDVALU                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_FIXED_FCTR      FF                                               
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBFXDFCT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    SQL ERROR CHECKING COPYBOOK.                                *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS TO XFER DATA.                                    *        
      ******************************************************************        
           COPY CCA00001.                                                       
                                                                        
      ******************************************************************        
      *    ERROR HANDLING COPY BOOK.                                   *        
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  CURSOR DECLARATIONS.                                          *        
      ******************************************************************        
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-UPDT-ACTION-IND            PIC X(01)   VALUE SPACES.    
       01  PARM-USER-ID                    PIC X(07)   VALUE SPACES.    
COB305 01 PARM-ACCOUNT-NO-MST        PIC S9(13)V USAGE COMP-3 VALUE 0.    
       01  PARM-IC-NO-MST                  PIC S9(04)  COMP VALUE 0.    
       01  PARM-METER-REF-NO-MST           PIC S9(04)  COMP VALUE 0.    
COB305 01 PARM-ACCOUNT-NO-DEP        PIC S9(13)V USAGE COMP-3 VALUE 0.    
       01  PARM-IC-NO-DEP                  PIC S9(04)  COMP VALUE 0.    
       01  PARM-METER-REF-NO-DEP           PIC S9(04)  COMP VALUE 0.    
       01  PARM-CODE-UTIL-TYPE             PIC X(01)   VALUE SPACES.    
       01  PARM-CODE-RELATION-TYPE         PIC X(01)   VALUE SPACES.    
       01  PARM-DEP-REL-START-DT           PIC X(10)   VALUE SPACES.    
       01  PARM-DEP-REL-END-DT             PIC X(10)   VALUE SPACES.    
       01  PARM-TRAN-COMMENT               PIC X(210)  VALUE SPACES.    
                                                                        
       PROCEDURE DIVISION  USING PARM-UPDT-ACTION-IND                   
                                 PARM-USER-ID                           
                                 PARM-ACCOUNT-NO-MST                    
                                 PARM-IC-NO-MST                         
                                 PARM-METER-REF-NO-MST                  
                                 PARM-ACCOUNT-NO-DEP                    
                                 PARM-IC-NO-DEP                         
                                 PARM-METER-REF-NO-DEP                  
                                 PARM-CODE-UTIL-TYPE                    
                                 PARM-CODE-RELATION-TYPE                
                                 PARM-DEP-REL-START-DT                  
                                 PARM-DEP-REL-END-DT                    
                                 PARM-TRAN-COMMENT.                     
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0000-MAINLINE.                                                 *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE             THRU 0100-EXIT.          
           PERFORM 1000-PROCESS-INPUT          THRU 1000-EXIT.          
           PERFORM 2000-PROCESS-OUTPUT         THRU 2000-EXIT.          
           PERFORM 9999-END-PROGRAM            THRU 9999-EXIT.          
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           EXEC SQL                                                     
              DECLARE C1 CURSOR  FOR                         
              SELECT :S-RETURN-CODE           AS RETURN_CODE            
                    ,:S-APPL-RETURN-CODE      AS APPL_RETURN_CODE       
                    ,:S-BUS-RULE-ID           AS BUS_RULE_ID            
                    ,:S-BUS-RULE-RESULT-CD    AS BUS_RULE_RESULT_CD     
                    ,:S-BUS-RULE-XREF-ID      AS BUS_RULE_XREF_ID       
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN FOR                                 
MFA-TR*       SELECT :S-RETURN-CODE           AS RETURN_CODE                    
MFA-TR*             ,:S-APPL-RETURN-CODE      AS APPL_RETURN_CODE               
MFA-TR*             ,:S-BUS-RULE-ID           AS BUS_RULE_ID                    
MFA-TR*             ,:S-BUS-RULE-RESULT-CD    AS BUS_RULE_RESULT_CD             
MFA-TR*             ,:S-BUS-RULE-XREF-ID      AS BUS_RULE_XREF_ID               
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-UPDT-ACTION-IND        TO WS-CURR-UPDT-ACTION-IND. 
           MOVE PARM-USER-ID                TO WS-CURR-USER-ID.         
           MOVE PARM-ACCOUNT-NO-MST         TO WS-CURR-ACCOUNT-NO-MST.  
           MOVE PARM-IC-NO-MST              TO WS-CURR-IC-NO-MST.       
           MOVE PARM-METER-REF-NO-MST       TO WS-CURR-MTR-REF-NO-MST.  
           MOVE PARM-ACCOUNT-NO-DEP         TO WS-CURR-ACCOUNT-NO-DEP.  
           MOVE PARM-IC-NO-DEP              TO WS-CURR-IC-NO-DEP.       
           MOVE PARM-METER-REF-NO-DEP       TO WS-CURR-MTR-REF-NO-DEP.  
           MOVE PARM-CODE-UTIL-TYPE         TO WS-CURR-CODE-UTIL-TYPE.  
           MOVE PARM-CODE-RELATION-TYPE     TO WS-CURR-CODE-RLTN-TYP.   
           MOVE PARM-DEP-REL-START-DT       TO WS-CURR-DEP-REL-START-DT.
           MOVE PARM-DEP-REL-END-DT         TO WS-CURR-DEP-REL-END-DT.  
           MOVE PARM-TRAN-COMMENT           TO WS-CURR-TRAN-COMMENT.    
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2050-MAIN-VALIDATION        THRU 2050-EXIT.          
                                                                        
           EVALUATE TRUE                                                
              WHEN MST-DEP-INSERT                                       
                   PERFORM 2100-PROCESS-INSERT THRU 2100-EXIT           
              WHEN MST-DEP-UPDATE                                       
                   PERFORM 2200-PROCESS-UPDATE THRU 2200-EXIT           
              WHEN MST-DEP-DELETE                                       
                   PERFORM 2300-PROCESS-DELETE THRU 2300-EXIT           
           END-EVALUATE.                                                
                                                                        
           PERFORM 8005-SEND-RESULT            THRU 8005-EXIT.          
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2050-MAIN-VALIDATION.                                          *        
      ******************************************************************        
       2050-MAIN-VALIDATION.                                            
                                                                        
           MOVE WS-CURR-ACCOUNT-NO-MST      TO UR-ACCOUNT-NO-MST.       
           MOVE WS-CURR-IC-NO-MST           TO UR-IC-NO-MST.            
           MOVE WS-CURR-MTR-REF-NO-MST      TO UR-MTR-REF-NO-MST.       
                                                                        
           MOVE WS-CURR-ACCOUNT-NO-DEP      TO UR-ACCOUNT-NO-DEP        
                                               UT-ACCOUNT-NO            
                                               FF-ACCOUNT-NO.           
                                                                        
           MOVE WS-CURR-IC-NO-DEP           TO UR-IC-NO-DEP             
                                               UT-IC-NO                 
                                               FF-IC-NO.                
                                                                        
           MOVE WS-CURR-MTR-REF-NO-DEP      TO UR-MTR-REF-NO-DEP.       
                                                                        
           MOVE WS-CURR-CODE-RLTN-TYP       TO UR-CODE-RELATION-TYPE.   
           MOVE WS-CURR-DEP-REL-START-DT    TO UR-DEP-REL-START-DT.     
           MOVE WS-CURR-DEP-REL-END-DT      TO UR-DEP-REL-END-DT.       
           MOVE WS-CURR-CODE-UTIL-TYPE      TO UR-CODE-UTIL-TYPE-MST    
                                               UR-CODE-UTIL-TYPE-DEP    
                                               UT-CODE-UTIL-TYPE        
                                               FF-CODE-UTIL-TYPE.       
                                                                        
      *    CHECK IF MASTER/DEPEND METER RELATIONSHIP ALREADY EXISTS             
      *    FOR SAME REVENUE MONTH.                                              
           IF MST-DEP-INSERT OR MST-DEP-UPDATE                          
              PERFORM 7000-CHK-MST-DEP-REL-EXIST                        
                                               THRU 7000-EXIT           
              IF MST-DEP-REL-EXIST                                      
                 MOVE 'MRM0000088'          TO S-BUS-RULE-ID            
                 MOVE WS-FAILED             TO S-BUS-RULE-RESULT-CD     
                 IF S-BUS-RULE-ID GREATER THAN SPACES                   
                    PERFORM 7010-GET-RULE-XREF-ID                       
                                               THRU 7010-EXIT           
                 END-IF                                                 
                 MOVE WS-ZERO               TO S-APPL-RETURN-CODE       
                 PERFORM 8005-SEND-RESULT      THRU 8005-EXIT           
                 PERFORM 9999-END-PROGRAM      THRU 9999-EXIT           
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF MST-DEP-INSERT                                            
              PERFORM 7020-GET-SUB-RATE        THRU 7020-EXIT           
              IF STATE-LINE-RATE                                        
                 MOVE WS-STATE-LINE         TO FF-FIXED-FCTR-TYP-CD     
      *          DEPENDENT ACCT MST FRST HAV A FIXD FCTR OF TYP "STATLN"        
                 PERFORM 7030-CHK-FIXD-FCTR-TYP THRU 7030-EXIT          
                 IF STATELINE-FCTR-NOT-EXIST                            
                    MOVE 'MRM0000089'       TO S-BUS-RULE-ID            
                    MOVE WS-FAILED          TO S-BUS-RULE-RESULT-CD     
                    IF S-BUS-RULE-ID GREATER THAN SPACES                
                       PERFORM 7010-GET-RULE-XREF-ID THRU 7010-EXIT     
                    END-IF                                              
                    MOVE WS-ZERO            TO S-APPL-RETURN-CODE       
                    PERFORM 8005-SEND-RESULT   THRU 8005-EXIT           
                    PERFORM 9999-END-PROGRAM   THRU 9999-EXIT           
                 END-IF                                                 
                                                                        
      *          THIS MASTER ACCT HAS OTHER DEPENDENTS USING A DIFFERENT        
      *          FACTOR. A GROUP OF ACCOUNTS MUST ALL USE THE SAME FCTR.        
                 PERFORM 7040-CHECK-SAME-FCTR  THRU 7040-EXIT           
                 IF SAME-FCTR-EXIST                                     
                    MOVE 'MRM0000090'       TO S-BUS-RULE-ID            
                    MOVE WS-FAILED          TO S-BUS-RULE-RESULT-CD     
                    IF S-BUS-RULE-ID GREATER THAN SPACES                
                       PERFORM 7010-GET-RULE-XREF-ID THRU 7010-EXIT     
                    END-IF                                              
                    MOVE WS-ZERO            TO S-APPL-RETURN-CODE       
                    PERFORM 8005-SEND-RESULT   THRU 8005-EXIT           
                    PERFORM 9999-END-PROGRAM   THRU 9999-EXIT           
                 END-IF                                                 
              END-IF                                                    
                                                                        
      *       CHECK IF MASTER/DEPEND METER RELATIONSHIP ALREADY EXIST.          
              PERFORM 6000-MOVE-INPUT-VARIABLES THRU 6000-EXIT          
              PERFORM 7090-GET-PREV-DEP-END-DT THRU 7090-EXIT           
              IF ROW-ALREADY-EXIST                                      
                 MOVE 'MRM0000088'          TO S-BUS-RULE-ID            
                 MOVE WS-FAILED             TO S-BUS-RULE-RESULT-CD     
                 IF S-BUS-RULE-ID GREATER THAN SPACES                   
                    PERFORM 7010-GET-RULE-XREF-ID                       
                                               THRU 7010-EXIT           
                 END-IF                                                 
                 MOVE WS-ZERO               TO S-APPL-RETURN-CODE       
                 PERFORM 8005-SEND-RESULT      THRU 8005-EXIT           
                 PERFORM 9999-END-PROGRAM      THRU 9999-EXIT           
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2100-PROCESS-INSERT.                                           *        
      ******************************************************************        
       2100-PROCESS-INSERT.                                             
                                                                        
           MOVE WS-CURR-ACCOUNT-NO-DEP      TO WS-ACCOUNT-NO.           
                                                                        
           PERFORM 5000-WRITE-TRANS-HIST-SUMM  THRU 5000-EXIT.          
           PERFORM 5100-WRITE-TRANS-HIST-DET   THRU 5100-EXIT.          
           PERFORM 6000-MOVE-INPUT-VARIABLES   THRU 6000-EXIT.          
           PERFORM 8100-INSERT-UTL-BILL-REL    THRU 8100-EXIT.          
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2200-PROCESS-UPDATE.                                           *        
      ******************************************************************        
       2200-PROCESS-UPDATE.                                             
                                                                        
           PERFORM 6000-MOVE-INPUT-VARIABLES   THRU 6000-EXIT.          
                                                                        
           MOVE SPACES                      TO UR-DEP-REL-END-DT.       
           PERFORM 7090-GET-PREV-DEP-END-DT    THRU 7090-EXIT.          
                                                                        
           MOVE WS-CURR-ACCOUNT-NO-DEP      TO WS-ACCOUNT-NO.           
           PERFORM 5000-WRITE-TRANS-HIST-SUMM  THRU 5000-EXIT.          
           PERFORM 5200-WRITE-TRANS-HIST-DET   THRU 5200-EXIT.          
                                                                        
           MOVE WS-CURR-DEP-REL-END-DT      TO UR-DEP-REL-END-DT.       
           PERFORM 8200-UPDATE-UTL-BILL-REL    THRU 8200-EXIT.          
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2300-PROCESS-DELETE.                                           *        
      ******************************************************************        
       2300-PROCESS-DELETE.                                             
                                                                        
           MOVE WS-CURR-ACCOUNT-NO-DEP      TO WS-ACCOUNT-NO.           
           PERFORM 5000-WRITE-TRANS-HIST-SUMM  THRU 5000-EXIT.          
           PERFORM 5100-WRITE-TRANS-HIST-DET   THRU 5100-EXIT.          
           PERFORM 6000-MOVE-INPUT-VARIABLES   THRU 6000-EXIT.          
           PERFORM 8300-DELETE-UTL-BILL-REL    THRU 8300-EXIT.          
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 5000-WRITE-TRANS-HIST-SUMM.                                    *        
      ******************************************************************        
       5000-WRITE-TRANS-HIST-SUMM.                                      
                                                                        
           PERFORM 7050-GET-RESP-AREA-ID       THRU 7050-EXIT.          
           PERFORM 7060-GET-CURR-TIMESTAMP     THRU 7060-EXIT.          
                                                                        
      *    WRITE A TRANSACTION HISTORY FOR THE HEADER ROW                       
           MOVE 'F'                         TO MH-CODE-TRAN-TYPE.       
           MOVE WS-RESP-AREA-ID             TO MH-RESP-AREA-ID.         
           MOVE WS-ACCOUNT-NO               TO MH-ACCOUNT-NO.           
           MOVE WS-ZERO                     TO MH-CUSTOMER-NO.          
           MOVE WS-ZERO                     TO MH-PREMISE-NO.           
           MOVE WS-CURR-USER-ID             TO MH-USER-ID.              
           MOVE 'CSR04658'                  TO MH-APPL-PROGRAM-ID.      
           MOVE WS-CURR-TRAN-COMMENT        TO MH-TRAN-COMMENT-TEXT     
           MOVE LENGTH OF MH-TRAN-COMMENT-TEXT                          
                                            TO MH-TRAN-COMMENT-LEN      
           MOVE WS-ONE                      TO MI-TRAN-APPL-NO.         
           MOVE MH-TRANS-HIST-SEQ-NO        TO MI-TRANS-HIST-SEQ-NO.    
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 5100-WRITE-TRANS-HIST-DET.                                     *        
      ******************************************************************        
       5100-WRITE-TRANS-HIST-DET.                                       
                                                                        
      *    WRITE A TRANSACTION HISTORY FOR DEPENDENT METER ACCOUNT.             
                                                                        
           IF WS-CURR-ACCOUNT-NO-MST NOT EQUAL WS-CURR-ACCOUNT-NO-DEP   
              IF MST-DEP-INSERT                                         
                 MOVE +05                   TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT 
                 MOVE +13                   TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE WS-CURR-ACCOUNT-NO-DEP                            
                                            TO MI-CHG-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +13                   TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE WS-CURR-ACCOUNT-NO-DEP                            
                                            TO MI-PRV-COLUMN-VALUE-TEXT 
                 MOVE +09                   TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE '*DELETED*'           TO MI-CHG-COLUMN-VALUE-TEXT 
              END-IF                                                    
              MOVE SPACES                   TO MI-TABLE-ID              
              MOVE 'DEP ACCT NO'            TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                         TO MI-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
           IF MST-DEP-INSERT                                            
              MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              EVALUATE WS-CURR-CODE-UTIL-TYPE                           
              WHEN WS-ELEC                                              
                MOVE +8                     TO MI-CHG-COLUMN-VALUE-LEN  
                MOVE 'ELECTRIC'             TO MI-CHG-COLUMN-VALUE-TEXT 
              WHEN WS-GAS                                               
                MOVE +3                     TO MI-CHG-COLUMN-VALUE-LEN  
                MOVE 'GAS'                  TO MI-CHG-COLUMN-VALUE-TEXT 
              WHEN OTHER                                                
                MOVE +1                     TO MI-CHG-COLUMN-VALUE-LEN  
                MOVE WS-CURR-CODE-UTIL-TYPE TO MI-CHG-COLUMN-VALUE-TEXT 
              END-EVALUATE                                              
           ELSE                                                         
              EVALUATE WS-CURR-CODE-UTIL-TYPE                           
              WHEN WS-ELEC                                              
                MOVE +8                     TO MI-PRV-COLUMN-VALUE-LEN  
                MOVE 'ELECTRIC'             TO MI-PRV-COLUMN-VALUE-TEXT 
              WHEN WS-GAS                                               
                MOVE +3                     TO MI-PRV-COLUMN-VALUE-LEN  
                MOVE 'GAS'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              WHEN OTHER                                                
                MOVE +1                     TO MI-PRV-COLUMN-VALUE-LEN  
                MOVE WS-CURR-CODE-UTIL-TYPE TO MI-PRV-COLUMN-VALUE-TEXT 
              END-EVALUATE                                              
              MOVE +09                      TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE '*DELETED*'              TO MI-CHG-COLUMN-VALUE-TEXT 
           END-IF.                                                      
           MOVE SPACES                      TO MI-TABLE-ID.             
           MOVE 'DEP UTIL TYPE'             TO MI-COLUMN-DESC.          
           PERFORM 6530-LOAD-MNT-TRANS-HIST    THRU 6530-EXIT.          
           ADD 1                            TO MI-TRAN-APPL-NO.         
                                                                        
           IF MST-DEP-INSERT                                            
              MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE +4                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE WS-CURR-IC-NO-DEP        TO MI-CHG-COLUMN-VALUE-TEXT 
           ELSE                                                         
              MOVE +4                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE WS-CURR-IC-NO-DEP        TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE +9                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE '*DELETED*'              TO MI-CHG-COLUMN-VALUE-TEXT 
           END-IF.                                                      
           MOVE SPACES                      TO MI-TABLE-ID.             
           MOVE 'DEP IC NO   '              TO MI-COLUMN-DESC.          
           PERFORM 6530-LOAD-MNT-TRANS-HIST    THRU 6530-EXIT.          
           ADD 1                            TO MI-TRAN-APPL-NO.         
                                                                        
           IF MST-DEP-INSERT                                            
              MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE +4                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE WS-CURR-MTR-REF-NO-DEP   TO MI-CHG-COLUMN-VALUE-TEXT 
           ELSE                                                         
              MOVE +4                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE WS-CURR-MTR-REF-NO-DEP   TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE +9                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE '*DELETED*'              TO MI-CHG-COLUMN-VALUE-TEXT 
           END-IF.                                                      
           MOVE SPACES                      TO MI-TABLE-ID.             
           MOVE 'DEP MTR REF NO'            TO MI-COLUMN-DESC.          
           PERFORM 6530-LOAD-MNT-TRANS-HIST    THRU 6530-EXIT.          
           ADD 1                            TO MI-TRAN-APPL-NO.         
                                                                        
           MOVE WS-CURR-ACCOUNT-NO-DEP      TO UT-ACCOUNT-NO.           
           MOVE WS-CURR-IC-NO-DEP           TO UT-IC-NO.                
           MOVE WS-CURR-CODE-UTIL-TYPE      TO UT-CODE-UTIL-TYPE.       
           MOVE WS-NO                       TO WS-CODE-EST-OK-DEP-UPDT. 
           PERFORM 7070-GET-CODE-ESTIMATE-OK   THRU 7070-EXIT.          
                                                                        
           IF MST-DEP-INSERT AND                                        
              UT-CODE-ESTIMATE-OK NOT EQUAL WS-DO-NOT-ESTIMATE-C        
              MOVE +1                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE UT-CODE-ESTIMATE-OK      TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE +1                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE WS-DO-NOT-ESTIMATE-C     TO MI-CHG-COLUMN-VALUE-TEXT 
                                                                        
              MOVE WS-DO-NOT-ESTIMATE-C     TO UT-CODE-ESTIMATE-OK      
              PERFORM 8000-UPD-CD-ESTMTE-OK    THRU 8000-EXIT           
              SET CODE-EST-OK-DEP-UPDT      TO TRUE                     
                                                                        
              MOVE '37'                     TO MI-TABLE-ID              
              MOVE 'ESTIMATE OK DEP'        TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                         TO MI-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
           IF WS-CURR-ACCOUNT-NO-MST NOT EQUAL WS-CURR-ACCOUNT-NO-DEP   
              IF MST-DEP-INSERT                                         
                 MOVE +05                   TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT 
                 MOVE +13                   TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE WS-CURR-ACCOUNT-NO-MST                            
                                            TO MI-CHG-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +13                   TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE WS-CURR-ACCOUNT-NO-MST                            
                                            TO MI-PRV-COLUMN-VALUE-TEXT 
                 MOVE +09                   TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE '*DELETED*'           TO MI-CHG-COLUMN-VALUE-TEXT 
              END-IF                                                    
                                                                        
              MOVE SPACES                   TO MI-TABLE-ID              
              MOVE 'MAST ACCOUNT NO'        TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                         TO MI-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
           IF MST-DEP-INSERT                                            
              MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              EVALUATE WS-CURR-CODE-UTIL-TYPE                           
              WHEN WS-ELEC                                              
                MOVE +8                     TO MI-CHG-COLUMN-VALUE-LEN  
                MOVE 'ELECTRIC'             TO MI-CHG-COLUMN-VALUE-TEXT 
              WHEN WS-GAS                                               
                MOVE +3                     TO MI-CHG-COLUMN-VALUE-LEN  
                MOVE 'GAS'                  TO MI-CHG-COLUMN-VALUE-TEXT 
              WHEN OTHER                                                
                MOVE +1                     TO MI-CHG-COLUMN-VALUE-LEN  
                MOVE WS-CURR-CODE-UTIL-TYPE TO MI-CHG-COLUMN-VALUE-TEXT 
              END-EVALUATE                                              
           ELSE                                                         
              EVALUATE WS-CURR-CODE-UTIL-TYPE                           
              WHEN WS-ELEC                                              
                MOVE +8                     TO MI-PRV-COLUMN-VALUE-LEN  
                MOVE 'ELECTRIC'             TO MI-PRV-COLUMN-VALUE-TEXT 
              WHEN WS-GAS                                               
                MOVE +3                     TO MI-PRV-COLUMN-VALUE-LEN  
                MOVE 'GAS'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              WHEN OTHER                                                
                MOVE +1                     TO MI-PRV-COLUMN-VALUE-LEN  
                MOVE WS-CURR-CODE-UTIL-TYPE TO MI-PRV-COLUMN-VALUE-TEXT 
              END-EVALUATE                                              
              MOVE +09                      TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE '*DELETED*'              TO MI-CHG-COLUMN-VALUE-TEXT 
           END-IF.                                                      
           MOVE SPACES                      TO MI-TABLE-ID.             
           MOVE 'MAST UTIL TYPE'            TO MI-COLUMN-DESC.          
           PERFORM 6530-LOAD-MNT-TRANS-HIST    THRU 6530-EXIT.          
           ADD 1                            TO MI-TRAN-APPL-NO.         
                                                                        
           IF MST-DEP-INSERT                                            
              MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE +4                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE WS-CURR-IC-NO-MST        TO MI-CHG-COLUMN-VALUE-TEXT 
           ELSE                                                         
              MOVE +4                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE WS-CURR-IC-NO-MST        TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE +9                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE '*DELETED*'              TO MI-CHG-COLUMN-VALUE-TEXT 
           END-IF.                                                      
           MOVE SPACES                      TO MI-TABLE-ID.             
           MOVE 'MAST IC NO  '              TO MI-COLUMN-DESC.          
           PERFORM 6530-LOAD-MNT-TRANS-HIST    THRU 6530-EXIT.          
           ADD 1                            TO MI-TRAN-APPL-NO.         
                                                                        
           IF MST-DEP-INSERT                                            
              MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE +4                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE WS-CURR-MTR-REF-NO-MST   TO MI-CHG-COLUMN-VALUE-TEXT 
           ELSE                                                         
              MOVE +4                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE WS-CURR-MTR-REF-NO-MST   TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE +9                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE '*DELETED*'              TO MI-CHG-COLUMN-VALUE-TEXT 
           END-IF.                                                      
           MOVE SPACES                      TO MI-TABLE-ID.             
           MOVE 'MAST MTR REF NO'           TO MI-COLUMN-DESC.          
           PERFORM 6530-LOAD-MNT-TRANS-HIST    THRU 6530-EXIT.          
           ADD 1                            TO MI-TRAN-APPL-NO.         
                                                                        
           MOVE WS-CURR-ACCOUNT-NO-MST      TO UT-ACCOUNT-NO.           
           MOVE WS-CURR-IC-NO-MST           TO UT-IC-NO.                
           MOVE WS-CURR-CODE-UTIL-TYPE      TO UT-CODE-UTIL-TYPE.       
           PERFORM 7070-GET-CODE-ESTIMATE-OK   THRU 7070-EXIT.          
                                                                        
           IF MST-DEP-INSERT AND                                        
              UT-CODE-ESTIMATE-OK NOT EQUAL WS-DO-NOT-ESTIMATE-C        
              MOVE +1                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE UT-CODE-ESTIMATE-OK      TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE +1                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE WS-DO-NOT-ESTIMATE-C     TO MI-CHG-COLUMN-VALUE-TEXT 
                                                                        
              MOVE WS-DO-NOT-ESTIMATE-C     TO UT-CODE-ESTIMATE-OK      
              IF WS-CURR-ACCOUNT-NO-DEP EQUAL WS-CURR-ACCOUNT-NO-MST    
                 PERFORM 8000-UPD-CD-ESTMTE-OK THRU 8000-EXIT           
              END-IF                                                    
                                                                        
              MOVE '37'                     TO MI-TABLE-ID              
              MOVE 'ESTIMATE OK MST'        TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                         TO MI-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
           MOVE WS-CURR-CODE-RLTN-TYP        TO UV-CODE-VALUE-TEXT      
           MOVE +1                           TO UV-CODE-VALUE-LEN       
           MOVE 'CODE_RELATION_TYPE'         TO UV-COLUMN-NA-TEXT       
           MOVE +18                          TO UV-COLUMN-NA-LEN        
           MOVE 'CSS_UTL_BILL_REL'           TO UV-TABLE-NA-TEXT        
           MOVE +16                          TO UV-TABLE-NA-LEN         
           PERFORM 7080-GET-CODE-VALUE-DESC     THRU 7080-EXIT.         
                                                                        
           IF MST-DEP-INSERT                                            
              MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE UV-CODE-SHORT-DESC       TO MI-CHG-COLUMN-VALUE      
           ELSE                                                         
              MOVE UV-CODE-SHORT-DESC       TO MI-PRV-COLUMN-VALUE      
              MOVE +9                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE '*DELETED*'              TO MI-CHG-COLUMN-VALUE-TEXT 
           END-IF                                                       
           MOVE '50'                        TO MI-TABLE-ID.             
           MOVE 'RELATION TYPE'             TO MI-COLUMN-DESC.          
           PERFORM 6530-LOAD-MNT-TRANS-HIST    THRU 6530-EXIT.          
           ADD 1                            TO MI-TRAN-APPL-NO.         
                                                                        
           IF MST-DEP-INSERT                                            
              MOVE +05                      TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE +10                      TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE WS-CURR-DEP-REL-START-DT TO MI-CHG-COLUMN-VALUE-TEXT 
           ELSE                                                         
              MOVE +10                      TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE WS-CURR-DEP-REL-START-DT TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE +09                      TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE '*DELETED*'              TO MI-CHG-COLUMN-VALUE-TEXT 
           END-IF.                                                      
           MOVE SPACES                      TO MI-TABLE-ID.             
           MOVE 'START REV MTH'             TO MI-COLUMN-DESC.          
           PERFORM 6530-LOAD-MNT-TRANS-HIST    THRU 6530-EXIT.          
           ADD 1                            TO MI-TRAN-APPL-NO.         
                                                                        
           IF MST-DEP-INSERT                                            
              MOVE +05                     TO MI-PRV-COLUMN-VALUE-LEN   
              MOVE '*NEW*'                 TO MI-PRV-COLUMN-VALUE-TEXT  
              MOVE +10                     TO MI-CHG-COLUMN-VALUE-LEN   
              MOVE WS-CURR-DEP-REL-END-DT  TO MI-CHG-COLUMN-VALUE-TEXT  
           ELSE                                                         
              MOVE +10                     TO MI-PRV-COLUMN-VALUE-LEN   
              MOVE WS-CURR-DEP-REL-END-DT  TO MI-PRV-COLUMN-VALUE-TEXT  
              MOVE +09                     TO MI-CHG-COLUMN-VALUE-LEN   
              MOVE '*DELETED*'             TO MI-CHG-COLUMN-VALUE-TEXT  
           END-IF                                                       
           MOVE SPACES                     TO MI-TABLE-ID.              
           MOVE 'END REV MTH'              TO MI-COLUMN-DESC.           
           PERFORM 6530-LOAD-MNT-TRANS-HIST   THRU 6530-EXIT.           
           ADD 1                           TO MI-TRAN-APPL-NO.          
                                                                        
      *    WRITE A TRANSACTION HISTORY FOR MASTER METER ACCOUNT.                
           IF WS-CURR-ACCOUNT-NO-MST NOT EQUAL WS-CURR-ACCOUNT-NO-DEP   
              MOVE WS-CURR-ACCOUNT-NO-MST   TO WS-ACCOUNT-NO            
              PERFORM 5000-WRITE-TRANS-HIST-SUMM  THRU 5000-EXIT        
                                                                        
           IF WS-CURR-ACCOUNT-NO-MST NOT EQUAL WS-CURR-ACCOUNT-NO-DEP   
              IF MST-DEP-INSERT                                         
                 MOVE +05                   TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT 
                 MOVE +13                   TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE WS-CURR-ACCOUNT-NO-DEP                            
                                            TO MI-CHG-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +13                   TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE WS-CURR-ACCOUNT-NO-DEP                            
                                            TO MI-PRV-COLUMN-VALUE-TEXT 
                 MOVE +09                   TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE '*DELETED*'           TO MI-CHG-COLUMN-VALUE-TEXT 
              END-IF                                                    
              MOVE SPACES                   TO MI-TABLE-ID              
              MOVE 'DEP ACCT NO'            TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                         TO MI-TRAN-APPL-NO          
           END-IF                                                       
                                                                        
           IF MST-DEP-INSERT                                            
              MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              EVALUATE WS-CURR-CODE-UTIL-TYPE                           
              WHEN WS-ELEC                                              
                MOVE +8                     TO MI-CHG-COLUMN-VALUE-LEN  
                MOVE 'ELECTRIC'             TO MI-CHG-COLUMN-VALUE-TEXT 
              WHEN WS-GAS                                               
                MOVE +3                     TO MI-CHG-COLUMN-VALUE-LEN  
                MOVE 'GAS'                  TO MI-CHG-COLUMN-VALUE-TEXT 
              WHEN OTHER                                                
                MOVE +1                     TO MI-CHG-COLUMN-VALUE-LEN  
                MOVE WS-CURR-CODE-UTIL-TYPE TO MI-CHG-COLUMN-VALUE-TEXT 
              END-EVALUATE                                              
           ELSE                                                         
              EVALUATE WS-CURR-CODE-UTIL-TYPE                           
              WHEN WS-ELEC                                              
                MOVE +8                     TO MI-PRV-COLUMN-VALUE-LEN  
                MOVE 'ELECTRIC'             TO MI-PRV-COLUMN-VALUE-TEXT 
              WHEN WS-GAS                                               
                MOVE +3                     TO MI-PRV-COLUMN-VALUE-LEN  
                MOVE 'GAS'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              WHEN OTHER                                                
                MOVE +1                     TO MI-PRV-COLUMN-VALUE-LEN  
                MOVE WS-CURR-CODE-UTIL-TYPE TO MI-PRV-COLUMN-VALUE-TEXT 
              END-EVALUATE                                              
              MOVE +09                      TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE '*DELETED*'              TO MI-CHG-COLUMN-VALUE-TEXT 
           END-IF                                                       
           MOVE SPACES                      TO MI-TABLE-ID              
           MOVE 'DEP UTIL TYPE'             TO MI-COLUMN-DESC           
           PERFORM 6530-LOAD-MNT-TRANS-HIST    THRU 6530-EXIT           
           ADD 1                            TO MI-TRAN-APPL-NO          
                                                                        
           IF MST-DEP-INSERT                                            
              MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE +4                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE WS-CURR-IC-NO-DEP        TO MI-CHG-COLUMN-VALUE-TEXT 
           ELSE                                                         
              MOVE +4                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE WS-CURR-IC-NO-DEP        TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE +9                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE '*DELETED*'              TO MI-CHG-COLUMN-VALUE-TEXT 
           END-IF                                                       
           MOVE SPACES                      TO MI-TABLE-ID              
           MOVE 'DEP IC NO   '              TO MI-COLUMN-DESC           
           PERFORM 6530-LOAD-MNT-TRANS-HIST    THRU 6530-EXIT           
           ADD 1                            TO MI-TRAN-APPL-NO          
                                                                        
           IF MST-DEP-INSERT                                            
              MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE +4                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE WS-CURR-MTR-REF-NO-DEP   TO MI-CHG-COLUMN-VALUE-TEXT 
           ELSE                                                         
              MOVE +4                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE WS-CURR-MTR-REF-NO-DEP   TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE +9                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE '*DELETED*'              TO MI-CHG-COLUMN-VALUE-TEXT 
           END-IF                                                       
           MOVE SPACES                      TO MI-TABLE-ID              
           MOVE 'DEP MTR REF NO'            TO MI-COLUMN-DESC           
           PERFORM 6530-LOAD-MNT-TRANS-HIST    THRU 6530-EXIT           
           ADD 1                            TO MI-TRAN-APPL-NO          
                                                                        
           MOVE WS-CURR-ACCOUNT-NO-DEP      TO UT-ACCOUNT-NO            
           MOVE WS-CURR-IC-NO-DEP           TO UT-IC-NO                 
           MOVE WS-CURR-CODE-UTIL-TYPE      TO UT-CODE-UTIL-TYPE        
           PERFORM 7070-GET-CODE-ESTIMATE-OK   THRU 7070-EXIT           
                                                                        
           IF MST-DEP-INSERT AND CODE-EST-OK-DEP-UPDT  AND              
              UT-CODE-ESTIMATE-OK NOT EQUAL WS-DO-NOT-ESTIMATE-C        
              MOVE +1                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE UT-CODE-ESTIMATE-OK      TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE +1                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE WS-DO-NOT-ESTIMATE-C     TO MI-CHG-COLUMN-VALUE-TEXT 
                                                                        
              MOVE '37'                     TO MI-TABLE-ID              
              MOVE 'ESTIMATE OK DEP'        TO MI-COLUMN-DESC           
              MOVE 'DEP MTR REF NO'         TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                         TO MI-TRAN-APPL-NO          
           END-IF                                                       
                                                                        
           IF MST-DEP-INSERT                                            
              MOVE +05                   TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE +13                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE WS-CURR-ACCOUNT-NO-MST                               
                                         TO MI-CHG-COLUMN-VALUE-TEXT    
           ELSE                                                         
              MOVE +13                   TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE WS-CURR-ACCOUNT-NO-MST                               
                                         TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE +09                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE '*DELETED*'           TO MI-CHG-COLUMN-VALUE-TEXT    
           END-IF                                                       
           MOVE SPACES                   TO MI-TABLE-ID                 
           MOVE 'MAST ACCOUNT NO'        TO MI-COLUMN-DESC              
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT              
           ADD 1                         TO MI-TRAN-APPL-NO             
                                                                        
           IF MST-DEP-INSERT                                            
              MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              EVALUATE WS-CURR-CODE-UTIL-TYPE                           
              WHEN WS-ELEC                                              
                MOVE +8                     TO MI-CHG-COLUMN-VALUE-LEN  
                MOVE 'ELECTRIC'             TO MI-CHG-COLUMN-VALUE-TEXT 
              WHEN WS-GAS                                               
                MOVE +3                     TO MI-CHG-COLUMN-VALUE-LEN  
                MOVE 'GAS'                  TO MI-CHG-COLUMN-VALUE-TEXT 
              WHEN OTHER                                                
                MOVE +1                     TO MI-CHG-COLUMN-VALUE-LEN  
                MOVE WS-CURR-CODE-UTIL-TYPE TO MI-CHG-COLUMN-VALUE-TEXT 
              END-EVALUATE                                              
           ELSE                                                         
              EVALUATE WS-CURR-CODE-UTIL-TYPE                           
              WHEN WS-ELEC                                              
                MOVE +8                     TO MI-PRV-COLUMN-VALUE-LEN  
                MOVE 'ELECTRIC'             TO MI-PRV-COLUMN-VALUE-TEXT 
              WHEN WS-GAS                                               
                MOVE +3                     TO MI-PRV-COLUMN-VALUE-LEN  
                MOVE 'GAS'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              WHEN OTHER                                                
                MOVE +1                     TO MI-PRV-COLUMN-VALUE-LEN  
                MOVE WS-CURR-CODE-UTIL-TYPE TO MI-PRV-COLUMN-VALUE-TEXT 
              END-EVALUATE                                              
              MOVE +09                      TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE '*DELETED*'              TO MI-CHG-COLUMN-VALUE-TEXT 
           END-IF                                                       
           MOVE SPACES                      TO MI-TABLE-ID              
           MOVE 'MAST UTIL TYPE'            TO MI-COLUMN-DESC           
           PERFORM 6530-LOAD-MNT-TRANS-HIST    THRU 6530-EXIT           
           ADD 1                            TO MI-TRAN-APPL-NO          
                                                                        
           IF MST-DEP-INSERT                                            
              MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE +4                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE WS-CURR-IC-NO-MST        TO MI-CHG-COLUMN-VALUE-TEXT 
           ELSE                                                         
              MOVE +4                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE WS-CURR-IC-NO-MST        TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE +9                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE '*DELETED*'              TO MI-CHG-COLUMN-VALUE-TEXT 
           END-IF                                                       
           MOVE SPACES                      TO MI-TABLE-ID              
           MOVE 'MAST IC NO  '              TO MI-COLUMN-DESC           
           PERFORM 6530-LOAD-MNT-TRANS-HIST    THRU 6530-EXIT           
           ADD 1                            TO MI-TRAN-APPL-NO          
                                                                        
           IF MST-DEP-INSERT                                            
              MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE +4                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE WS-CURR-MTR-REF-NO-MST   TO MI-CHG-COLUMN-VALUE-TEXT 
           ELSE                                                         
              MOVE +4                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE WS-CURR-MTR-REF-NO-MST   TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE +9                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE '*DELETED*'              TO MI-CHG-COLUMN-VALUE-TEXT 
           END-IF                                                       
           MOVE SPACES                      TO MI-TABLE-ID              
           MOVE 'MAST MTR REF NO'           TO MI-COLUMN-DESC           
           PERFORM 6530-LOAD-MNT-TRANS-HIST    THRU 6530-EXIT           
           ADD 1                            TO MI-TRAN-APPL-NO          
                                                                        
           MOVE WS-CURR-ACCOUNT-NO-MST      TO UT-ACCOUNT-NO            
           MOVE WS-CURR-IC-NO-MST           TO UT-IC-NO                 
           MOVE WS-CURR-CODE-UTIL-TYPE      TO UT-CODE-UTIL-TYPE        
           PERFORM 7070-GET-CODE-ESTIMATE-OK   THRU 7070-EXIT           
                                                                        
           IF MST-DEP-INSERT AND                                        
              UT-CODE-ESTIMATE-OK NOT EQUAL WS-DO-NOT-ESTIMATE-C        
              MOVE +1                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE UT-CODE-ESTIMATE-OK      TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE +1                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE WS-DO-NOT-ESTIMATE-C     TO MI-CHG-COLUMN-VALUE-TEXT 
                                                                        
              MOVE WS-DO-NOT-ESTIMATE-C     TO UT-CODE-ESTIMATE-OK      
              PERFORM 8000-UPD-CD-ESTMTE-OK    THRU 8000-EXIT           
              MOVE '37'                     TO MI-TABLE-ID              
              MOVE 'ESTIMATE OK MST'        TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                         TO MI-TRAN-APPL-NO          
           END-IF                                                       
                                                                        
           MOVE WS-CURR-CODE-RLTN-TYP        TO UV-CODE-VALUE-TEXT      
           MOVE +1                           TO UV-CODE-VALUE-LEN       
           MOVE 'CODE_RELATION_TYPE'         TO UV-COLUMN-NA-TEXT       
           MOVE +18                          TO UV-COLUMN-NA-LEN        
           MOVE 'CSS_UTL_BILL_REL'           TO UV-TABLE-NA-TEXT        
           MOVE +16                          TO UV-TABLE-NA-LEN         
           PERFORM 7080-GET-CODE-VALUE-DESC     THRU 7080-EXIT          
                                                                        
           IF MST-DEP-INSERT                                            
              MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE UV-CODE-SHORT-DESC       TO MI-CHG-COLUMN-VALUE      
           ELSE                                                         
              MOVE UV-CODE-SHORT-DESC       TO MI-PRV-COLUMN-VALUE      
              MOVE +9                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE '*DELETED*'              TO MI-CHG-COLUMN-VALUE-TEXT 
           END-IF                                                       
           MOVE '50'                        TO MI-TABLE-ID              
           MOVE 'RELATION TYPE'             TO MI-COLUMN-DESC           
           PERFORM 6530-LOAD-MNT-TRANS-HIST    THRU 6530-EXIT           
           ADD 1                            TO MI-TRAN-APPL-NO          
                                                                        
           IF MST-DEP-INSERT                                            
              MOVE +05                      TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE +10                      TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE WS-CURR-DEP-REL-START-DT TO MI-CHG-COLUMN-VALUE-TEXT 
           ELSE                                                         
              MOVE +10                      TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE WS-CURR-DEP-REL-START-DT TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE +09                      TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE '*DELETED*'              TO MI-CHG-COLUMN-VALUE-TEXT 
           END-IF                                                       
           MOVE SPACES                      TO MI-TABLE-ID              
           MOVE 'START REV MTH'             TO MI-COLUMN-DESC           
           PERFORM 6530-LOAD-MNT-TRANS-HIST    THRU 6530-EXIT           
           ADD 1                            TO MI-TRAN-APPL-NO          
                                                                        
           IF MST-DEP-INSERT                                            
              MOVE +05                     TO MI-PRV-COLUMN-VALUE-LEN   
              MOVE '*NEW*'                 TO MI-PRV-COLUMN-VALUE-TEXT  
              MOVE +10                     TO MI-CHG-COLUMN-VALUE-LEN   
              MOVE WS-CURR-DEP-REL-END-DT  TO MI-CHG-COLUMN-VALUE-TEXT  
           ELSE                                                         
              MOVE +10                     TO MI-PRV-COLUMN-VALUE-LEN   
              MOVE WS-CURR-DEP-REL-END-DT  TO MI-PRV-COLUMN-VALUE-TEXT  
              MOVE +09                     TO MI-CHG-COLUMN-VALUE-LEN   
              MOVE '*DELETED*'             TO MI-CHG-COLUMN-VALUE-TEXT  
           END-IF                                                       
           MOVE SPACES                     TO MI-TABLE-ID               
           MOVE 'END REV MTH'              TO MI-COLUMN-DESC            
           PERFORM 6530-LOAD-MNT-TRANS-HIST   THRU 6530-EXIT            
           ADD 1                           TO MI-TRAN-APPL-NO           
                                                                        
           END-IF.                                                      
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 5200-WRITE-TRANS-HIST-DET.                                     *        
      ******************************************************************        
       5200-WRITE-TRANS-HIST-DET.                                       
                                                                        
      *    WRITE A TRANSACTION HISTORY FOR DEPENDENT METER ACCOUNT.             
           MOVE +10                         TO MI-PRV-COLUMN-VALUE-LEN. 
           MOVE UR-DEP-REL-END-DT           TO MI-PRV-COLUMN-VALUE-TEXT.
           MOVE +10                         TO MI-CHG-COLUMN-VALUE-LEN. 
           MOVE WS-CURR-DEP-REL-END-DT      TO MI-CHG-COLUMN-VALUE-TEXT.
           MOVE SPACES                      TO MI-TABLE-ID.             
           MOVE 'END REV MTH'               TO MI-COLUMN-DESC.          
           PERFORM 6530-LOAD-MNT-TRANS-HIST    THRU 6530-EXIT.          
           ADD 1                            TO MI-TRAN-APPL-NO.         
                                                                        
      *    WRITE A TRANSACTION HISTORY FOR MASTER METER ACCOUNT.                
           IF WS-CURR-ACCOUNT-NO-MST NOT = WS-CURR-ACCOUNT-NO-DEP       
              MOVE WS-CURR-ACCOUNT-NO-MST   TO WS-ACCOUNT-NO            
              PERFORM 5000-WRITE-TRANS-HIST-SUMM  THRU 5000-EXIT        
                                                                        
              MOVE +10                      TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE UR-DEP-REL-END-DT        TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE +10                      TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE WS-CURR-DEP-REL-END-DT   TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE SPACES                   TO MI-TABLE-ID              
              MOVE 'END REV MTH'            TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                         TO MI-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
       5200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 6000-MOVE-INPUT-VARIABLES.                                    *         
      *****************************************************************         
       6000-MOVE-INPUT-VARIABLES.                                       
                                                                        
           MOVE WS-CURR-ACCOUNT-NO-MST      TO UR-ACCOUNT-NO-MST.       
           MOVE WS-CURR-IC-NO-MST           TO UR-IC-NO-MST.            
           MOVE WS-CURR-MTR-REF-NO-MST      TO UR-MTR-REF-NO-MST.       
           MOVE WS-CURR-ACCOUNT-NO-DEP      TO UR-ACCOUNT-NO-DEP.       
           MOVE WS-CURR-IC-NO-DEP           TO UR-IC-NO-DEP.            
           MOVE WS-CURR-MTR-REF-NO-DEP      TO UR-MTR-REF-NO-DEP.       
           MOVE WS-CURR-CODE-UTIL-TYPE      TO UR-CODE-UTIL-TYPE-DEP    
                                               UR-CODE-UTIL-TYPE-MST.   
           MOVE WS-CURR-CODE-RLTN-TYP       TO UR-CODE-RELATION-TYPE.   
           MOVE WS-CURR-DEP-REL-START-DT    TO UR-DEP-REL-START-DT.     
           MOVE WS-CURR-DEP-REL-END-DT      TO UR-DEP-REL-END-DT.       
                                                                        
       6000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 6530-LOAD-MNT-TRANS-HIST.                                     *         
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7000-CHK-MST-DEP-REL-EXIST.                                *            
      ******************************************************************        
       7000-CHK-MST-DEP-REL-EXIST.                                      
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
               INTO  :WS-MST-DEP-REL-STATUS                             
                FROM CSS_UTL_BILL_REL UR WITH(READUNCOMMITTED)                  
               WHERE UR.ACCOUNT_NO_DEP      = :UR-ACCOUNT-NO-DEP        
                 AND UR.CODE_UTIL_TYPE_DEP  = :UR-CODE-UTIL-TYPE-DEP    
                 AND UR.IC_NO_DEP           = :UR-IC-NO-DEP             
                 AND UR.MTR_REF_NO_DEP      = :UR-MTR-REF-NO-DEP        
                 AND UR.ACCOUNT_NO_MST      = :UR-ACCOUNT-NO-MST        
                 AND UR.CODE_UTIL_TYPE_MST  = :UR-CODE-UTIL-TYPE-MST    
                 AND UR.IC_NO_MST           = :UR-IC-NO-MST             
                 AND UR.MTR_REF_NO_MST      = :UR-MTR-REF-NO-MST        
                 AND UR.CODE_RELATION_TYPE  = :UR-CODE-RELATION-TYPE    
                 AND UR.DEP_REL_START_DT   <> IIF(TRY_CONVERT(DATE, 
                                                   :UR-DEP-REL-START-DT
              ) IS NULL OR (PATINDEX('%.%', :UR-DEP-REL-START-DT
              ) <> 0) OR (LEN(:UR-DEP-REL-START-DT
              ) <> 10), CIS.CHAR2DATE(:UR-DEP-REL-START-DT
              ), CONVERT(DATE, :UR-DEP-REL-START-DT) )      
                 AND (IIF(TRY_CONVERT(DATE, :UR-DEP-REL-START-DT
              ) IS NULL OR (PATINDEX('%.%', :UR-DEP-REL-START-DT
              ) <> 0) OR (LEN(:UR-DEP-REL-START-DT
              ) <> 10), CIS.CHAR2DATE(:UR-DEP-REL-START-DT
              ), CONVERT(DATE, :UR-DEP-REL-START-DT) ) BETWEEN  
           UR.DEP_REL_START_DT 
                                               AND  UR.DEP_REL_END_DT   
                  OR  IIF(TRY_CONVERT(DATE, :UR-DEP-REL-END-DT
              ) IS NULL OR (PATINDEX('%.%', :UR-DEP-REL-END-DT
              ) <> 0) OR (LEN(:UR-DEP-REL-END-DT
              ) <> 10), CIS.CHAR2DATE(:UR-DEP-REL-END-DT
              ), CONVERT(DATE, :UR-DEP-REL-END-DT) )   BETWEEN  
           UR.DEP_REL_START_DT 
                                               AND  UR.DEP_REL_END_DT   
                  OR  UR.DEP_REL_START_DT  BETWEEN 
              IIF(TRY_CONVERT(DATE, :UR-DEP-REL-START-DT
              ) IS NULL OR (PATINDEX('%.%', :UR-DEP-REL-START-DT
              ) <> 0) OR (LEN(:UR-DEP-REL-START-DT
              ) <> 10), CIS.CHAR2DATE(:UR-DEP-REL-START-DT
              ), CONVERT(DATE, :UR-DEP-REL-START-DT) ) 
                                               AND 
              IIF(TRY_CONVERT(DATE, :UR-DEP-REL-END-DT
              ) IS NULL OR (PATINDEX('%.%', :UR-DEP-REL-END-DT
              ) <> 0) OR (LEN(:UR-DEP-REL-END-DT
              ) <> 10), CIS.CHAR2DATE(:UR-DEP-REL-END-DT
              ), CONVERT(DATE, :UR-DEP-REL-END-DT) )   
                  OR  UR.DEP_REL_END_DT    BETWEEN 
              IIF(TRY_CONVERT(DATE, :UR-DEP-REL-START-DT
              ) IS NULL OR (PATINDEX('%.%', :UR-DEP-REL-START-DT
              ) <> 0) OR (LEN(:UR-DEP-REL-START-DT
              ) <> 10), CIS.CHAR2DATE(:UR-DEP-REL-START-DT
              ), CONVERT(DATE, :UR-DEP-REL-START-DT) ) 
                                               AND 
              IIF(TRY_CONVERT(DATE, :UR-DEP-REL-END-DT
              ) IS NULL OR (PATINDEX('%.%', :UR-DEP-REL-END-DT
              ) <> 0) OR (LEN(:UR-DEP-REL-END-DT
              ) <> 10), CIS.CHAR2DATE(:UR-DEP-REL-END-DT
              ), CONVERT(DATE, :UR-DEP-REL-END-DT) ))  
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*        INTO  :WS-MST-DEP-REL-STATUS                                     
MFA-TR*         FROM CSS_UTL_BILL_REL UR                                        
MFA-TR*        WHERE UR.ACCOUNT_NO_DEP      = :UR-ACCOUNT-NO-DEP                
MFA-TR*          AND UR.CODE_UTIL_TYPE_DEP  = :UR-CODE-UTIL-TYPE-DEP            
MFA-TR*          AND UR.IC_NO_DEP           = :UR-IC-NO-DEP                     
MFA-TR*          AND UR.MTR_REF_NO_DEP      = :UR-MTR-REF-NO-DEP                
MFA-TR*          AND UR.ACCOUNT_NO_MST      = :UR-ACCOUNT-NO-MST                
MFA-TR*          AND UR.CODE_UTIL_TYPE_MST  = :UR-CODE-UTIL-TYPE-MST            
MFA-TR*          AND UR.IC_NO_MST           = :UR-IC-NO-MST                     
MFA-TR*          AND UR.MTR_REF_NO_MST      = :UR-MTR-REF-NO-MST                
MFA-TR*          AND UR.CODE_RELATION_TYPE  = :UR-CODE-RELATION-TYPE            
MFA-TR*          AND UR.DEP_REL_START_DT   <> :UR-DEP-REL-START-DT              
MFA-TR*          AND (:UR-DEP-REL-START-DT BETWEEN  UR.DEP_REL_START_DT         
MFA-TR*                                        AND  UR.DEP_REL_END_DT           
MFA-TR*           OR  :UR-DEP-REL-END-DT   BETWEEN  UR.DEP_REL_START_DT         
MFA-TR*                                        AND  UR.DEP_REL_END_DT           
MFA-TR*           OR  UR.DEP_REL_START_DT  BETWEEN :UR-DEP-REL-START-DT         
MFA-TR*                                        AND :UR-DEP-REL-END-DT           
MFA-TR*           OR  UR.DEP_REL_END_DT    BETWEEN :UR-DEP-REL-START-DT         
MFA-TR*                                        AND :UR-DEP-REL-END-DT)          
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7000                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7000'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_UTL_BILL_REL'       TO TABLE-1                  
              MOVE 'ACCOUNT_NO_DEP'         TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE_DEP'     TO TABLE-ELEMENT-2          
              MOVE 'IC_NO_DEP'              TO TABLE-ELEMENT-3          
              MOVE 'MTR_REF_NO_DEP'         TO TABLE-ELEMENT-4          
              MOVE UR-ACCOUNT-NO-DEP        TO HOSTVAR-ELEMENT-1        
              MOVE UR-CODE-UTIL-TYPE-DEP    TO HOSTVAR-ELEMENT-2        
              MOVE UR-IC-NO-DEP             TO HOSTVAR-ELEMENT-3        
              MOVE UR-MTR-REF-NO-DEP        TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7010-GET-RULE-XREF-ID.                                         *        
      ******************************************************************        
       7010-GET-RULE-XREF-ID.                                           
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           BUS_RULE_XREF_ID, 121), ' ', '-'), ':', '.') 
           BUS_RULE_XREF_ID                                   
                INTO :S-BUS-RULE-XREF-ID                                
                FROM CSS_BUS_RULE   [1R] WITH(READUNCOMMITTED)                  
                    ,CSS_BUS_RULE_XREF [1T] WITH(READUNCOMMITTED)               
               WHERE [1R].BUS_RULE_ID = :S-BUS-RULE-ID                    
                 AND [1R].BUS_RULE_ID = [1T].BUS_RULE_ID                    
                                             
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BUS_RULE_XREF_ID                                           
MFA-TR*         INTO :S-BUS-RULE-XREF-ID                                        
MFA-TR*         FROM CSS_BUS_RULE   1R                                          
MFA-TR*             ,CSS_BUS_RULE_XREF 1T                                       
MFA-TR*        WHERE 1R.BUS_RULE_ID = :S-BUS-RULE-ID                            
MFA-TR*          AND 1R.BUS_RULE_ID = 1T.BUS_RULE_ID                            
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7010                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               MOVE SPACES                TO ABEND-TABLES               
               MOVE SPACES                TO ABEND-SQL-PREDICATES       
               MOVE '7010'                TO ACTIVE-PARAGRAPH           
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_BUS_RULE'        TO TABLE-1                    
               MOVE 'BUS_RULE_ID'         TO TABLE-ELEMENT-1            
               MOVE S-BUS-RULE-ID         TO HOSTVAR-ELEMENT-1          
               PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7020-GET-SUB-RATE.                                             *        
      ******************************************************************        
       7020-GET-SUB-RATE.                                               
                                                                        
           EXEC SQL                                                     
              SELECT UT.RATE_PLAN_NO                                    
                INTO :WS-STATE-LINE-RATE                                
                FROM CSS_UTIL_ENVRNMT UT                                
               WHERE UT.ACCOUNT_NO        = :UT-ACCOUNT-NO              
                 AND UT.CODE_UTIL_TYPE    = :UT-CODE-UTIL-TYPE          
                 AND UT.IC_NO             = :UT-IC-NO                   
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT UT.RATE_PLAN_NO                                            
MFA-TR*         INTO :WS-STATE-LINE-RATE                                        
MFA-TR*         FROM CSS_UTIL_ENVRNMT UT                                        
MFA-TR*        WHERE UT.ACCOUNT_NO        = :UT-ACCOUNT-NO                      
MFA-TR*          AND UT.CODE_UTIL_TYPE    = :UT-CODE-UTIL-TYPE                  
MFA-TR*          AND UT.IC_NO             = :UT-IC-NO                           
MFA-TR*      QUERYNO 7020                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7020'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_UTL_BILL_REL'       TO TABLE-1                  
              MOVE 'ACCOUNT_NO_DEP'         TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE_DEP'     TO TABLE-ELEMENT-2          
              MOVE 'IC_NO_DEP'              TO TABLE-ELEMENT-3          
              MOVE UT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE UT-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE UT-IC-NO                 TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7030-CHK-FIXD-FCTR-TYP.                                        *        
      ******************************************************************        
       7030-CHK-FIXD-FCTR-TYP.                                          
                                                                        
           EXEC SQL                                                     
              SELECT 'Y'                                                
                INTO :WS-STATE-LINE-FCTR-STAT                           
                FROM CSS_FIXED_FCTR FF WITH(READUNCOMMITTED)                    
               WHERE FF.ACCOUNT_NO         = :FF-ACCOUNT-NO             
                 AND FF.CODE_UTIL_TYPE     = :FF-CODE-UTIL-TYPE         
                 AND FF.IC_NO              = :FF-IC-NO                  
                 AND FF.FIXED_FCTR_TYP_CD  = :FF-FIXED-FCTR-TYP-CD      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-STATE-LINE-FCTR-STAT                                   
MFA-TR*         FROM CSS_FIXED_FCTR FF                                          
MFA-TR*        WHERE FF.ACCOUNT_NO         = :FF-ACCOUNT-NO                     
MFA-TR*          AND FF.CODE_UTIL_TYPE     = :FF-CODE-UTIL-TYPE                 
MFA-TR*          AND FF.IC_NO              = :FF-IC-NO                          
MFA-TR*          AND FF.FIXED_FCTR_TYP_CD  = :FF-FIXED-FCTR-TYP-CD              
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7030                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7030'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_FIXED_FCTR'         TO TABLE-1                  
              MOVE 'ACCOUNT_NO_DEP'         TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE_DEP'     TO TABLE-ELEMENT-2          
              MOVE 'IC_NO_DEP'              TO TABLE-ELEMENT-3          
              MOVE 'FIXED_FCTR_TYPE'        TO TABLE-ELEMENT-4          
              MOVE FF-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE FF-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE FF-IC-NO                 TO HOSTVAR-ELEMENT-3        
              MOVE FF-FIXED-FCTR-TYP-CD     TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7040-CHECK-SAME-FCTR.                                          *        
      ******************************************************************        
       7040-CHECK-SAME-FCTR.                                            
                                                                        
           EXEC SQL                                                     
              SELECT DISTINCT TOP(1) 'Y'                                       
                INTO :WS-SAME-FCTR-STATUS                               
                FROM CSS_UTL_BILL_REL UR WITH(READUNCOMMITTED)                  
                    ,CSS_FIXED_FCTR FF WITH(READUNCOMMITTED)                    
               WHERE UR.ACCOUNT_NO_DEP     = FF.ACCOUNT_NO              
                 AND UR.ACCOUNT_NO_MST     = :UR-ACCOUNT-NO-MST         
                 AND UR.CODE_UTIL_TYPE_MST = :UR-CODE-UTIL-TYPE-MST     
                 AND UR.IC_NO_MST          = :UR-IC-NO-MST              
                 AND (FF.FIXED_FCTR_TYP_CD = 'AD'                       
                  OR  FF.FIXED_FCTR_TYP_CD = 'SL')                      
                 AND NOT FACTOR_ID =                                    
                                (SELECT A.FACTOR_ID                     
                                   FROM CSS_FIXED_FCTR A
                           WITH(READUNCOMMITTED)                
                                  WHERE A.ACCOUNT_NO = :FF-ACCOUNT-NO   
                                    AND (A.FIXED_FCTR_TYP_CD = 'AD'     
                                     OR  A.FIXED_FCTR_TYP_CD = 'SL'))   
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DISTINCT 'Y'                                               
MFA-TR*         INTO :WS-SAME-FCTR-STATUS                                       
MFA-TR*         FROM CSS_UTL_BILL_REL UR                                        
MFA-TR*             ,CSS_FIXED_FCTR FF                                          
MFA-TR*        WHERE UR.ACCOUNT_NO_DEP     = FF.ACCOUNT_NO                      
MFA-TR*          AND UR.ACCOUNT_NO_MST     = :UR-ACCOUNT-NO-MST                 
MFA-TR*          AND UR.CODE_UTIL_TYPE_MST = :UR-CODE-UTIL-TYPE-MST             
MFA-TR*          AND UR.IC_NO_MST          = :UR-IC-NO-MST                      
MFA-TR*          AND (FF.FIXED_FCTR_TYP_CD = 'AD'                               
MFA-TR*           OR  FF.FIXED_FCTR_TYP_CD = 'SL')                              
MFA-TR*          AND NOT FACTOR_ID =                                            
MFA-TR*                         (SELECT A.FACTOR_ID                             
MFA-TR*                            FROM CSS_FIXED_FCTR A                        
MFA-TR*                           WHERE A.ACCOUNT_NO = :FF-ACCOUNT-NO           
MFA-TR*                             AND (A.FIXED_FCTR_TYP_CD = 'AD'             
MFA-TR*                              OR  A.FIXED_FCTR_TYP_CD = 'SL'))           
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7040                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7040'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_FIXED_FCTR'         TO TABLE-1                  
              MOVE 'ACCOUNT_NO_DEP'         TO TABLE-ELEMENT-1          
              MOVE 'ACCOUNT_NO_MST'         TO TABLE-ELEMENT-2          
              MOVE 'CODE_UTIL_TYPE_MST'     TO TABLE-ELEMENT-3          
              MOVE 'IC_NO_MST'              TO TABLE-ELEMENT-4          
              MOVE FF-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE UR-ACCOUNT-NO-MST        TO HOSTVAR-ELEMENT-2        
              MOVE UR-CODE-UTIL-TYPE-MST    TO HOSTVAR-ELEMENT-3        
              MOVE UR-IC-NO-MST             TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7040-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7050-GET-RESP-AREA-ID.                                         *        
      ******************************************************************        
       7050-GET-RESP-AREA-ID.                                           
                                                                        
           EXEC SQL                                                     
               SELECT RESP_AREA_ID                                      
                 INTO :WS-RESP-AREA-ID                                  
                 FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                    
                WHERE USER_ID = :WS-CURR-USER-ID                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RESP_AREA_ID                                              
MFA-TR*          INTO :WS-RESP-AREA-ID                                          
MFA-TR*          FROM CSS_USER_PROFILE                                          
MFA-TR*         WHERE USER_ID = :WS-CURR-USER-ID                                
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7050                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7050'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT '                TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_USER_PROFILE  '     TO TABLE-1                  
              MOVE 'USER_ID'                TO TABLE-ELEMENT-1          
              MOVE 'ACCOUNT_NO_DEP'         TO TABLE-ELEMENT-2          
              MOVE WS-CURR-USER-ID          TO HOSTVAR-ELEMENT-1        
              MOVE WS-CURR-ACCOUNT-NO-DEP   TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7060-GET-CURR-TIMESTAMP                                        *        
      ******************************************************************        
       7060-GET-CURR-TIMESTAMP.                                         
                                                                        
           EXEC SQL                                                     
               SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :MH-TRANS-HIST-SEQ-NO,
              :MH-DATE-TRANS                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :MH-TRANS-HIST-SEQ-NO = CURRENT TIMESTAMP                    
MFA-TR*           ,:MH-DATE-TRANS        = CURRENT DATE                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SPACES                   TO ABEND-TABLES             
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
              MOVE '7060'                   TO ACTIVE-PARAGRAPH         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7060-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7070-GET-CODE-ESTIMATE-OK.                                     *        
      ******************************************************************        
       7070-GET-CODE-ESTIMATE-OK.                                       
                                                                        
           EXEC SQL                                                     
              SELECT UT.CODE_ESTIMATE_OK                                
                INTO :UT-CODE-ESTIMATE-OK                               
                FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                  
               WHERE UT.ACCOUNT_NO         = :UT-ACCOUNT-NO             
                 AND UT.CODE_UTIL_TYPE     = :UT-CODE-UTIL-TYPE         
                 AND UT.IC_NO              = :UT-IC-NO                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT UT.CODE_ESTIMATE_OK                                        
MFA-TR*         INTO :UT-CODE-ESTIMATE-OK                                       
MFA-TR*         FROM CSS_UTIL_ENVRNMT UT                                        
MFA-TR*        WHERE UT.ACCOUNT_NO         = :UT-ACCOUNT-NO                     
MFA-TR*          AND UT.CODE_UTIL_TYPE     = :UT-CODE-UTIL-TYPE                 
MFA-TR*          AND UT.IC_NO              = :UT-IC-NO                          
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7070                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7070'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT '                TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_UTIL_ENVRNMT'       TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE UT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE UT-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE UT-IC-NO                 TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7070-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7080-GET-CODE-VALUE-DESC.                                      *        
      ******************************************************************        
       7080-GET-CODE-VALUE-DESC.                                        
                                                                        
           EXEC SQL                                                     
             SELECT UV.CODE_SHORT_DESC                                  
               INTO :UV-CODE-SHORT-DESC                                 
               FROM CSS_CODE_VALUE UV                                   
              WHERE UV.CODE_VALUE = :UV-CODE-VALUE                      
                AND UV.COLUMN_NA  = :UV-COLUMN-NA                       
                AND UV.COMPANY_NO = '01'                                
                AND UV.PROGRAM_ID = 'ALL'                               
                AND UV.TABLE_NA   = :UV-TABLE-NA                        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT UV.CODE_SHORT_DESC                                          
MFA-TR*        INTO :UV-CODE-SHORT-DESC                                         
MFA-TR*        FROM CSS_CODE_VALUE UV                                           
MFA-TR*       WHERE UV.CODE_VALUE = :UV-CODE-VALUE                              
MFA-TR*         AND UV.COLUMN_NA  = :UV-COLUMN-NA                               
MFA-TR*         AND UV.COMPANY_NO = '01'                                        
MFA-TR*         AND UV.PROGRAM_ID = 'ALL'                                       
MFA-TR*         AND UV.TABLE_NA   = :UV-TABLE-NA                                
MFA-TR*        QUERYNO 7080                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE UV-CODE-VALUE         TO UV-CODE-SHORT-DESC       
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7080'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT '                TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_CODE_VALUE'         TO TABLE-1                  
              MOVE 'CODE_VALUE'             TO TABLE-ELEMENT-1          
              MOVE 'COLUMN_NA'              TO TABLE-ELEMENT-2          
              MOVE 'TABLE_NA'               TO TABLE-ELEMENT-3          
              MOVE UV-CODE-VALUE-TEXT       TO HOSTVAR-ELEMENT-1        
              MOVE UV-COLUMN-NA-TEXT        TO HOSTVAR-ELEMENT-2        
              MOVE UV-TABLE-NA-TEXT         TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7080-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7090-GET-PREV-DEP-END-DT.                                      *        
      ******************************************************************        
       7090-GET-PREV-DEP-END-DT.                                        
                                                                        
           EXEC SQL                                                     
              SELECT 'Y'                                                
                    ,UR.DEP_REL_END_DT                                  
                INTO :WS-ROW-ALREADY-EXIST                              
                    ,:UR-DEP-REL-END-DT                                 
                FROM CSS_UTL_BILL_REL UR WITH(READUNCOMMITTED)                  
               WHERE UR.ACCOUNT_NO_DEP     = :UR-ACCOUNT-NO-DEP         
                 AND UR.CODE_UTIL_TYPE_DEP = :UR-CODE-UTIL-TYPE-DEP     
                 AND UR.IC_NO_DEP          = :UR-IC-NO-DEP              
                 AND UR.MTR_REF_NO_DEP     = :UR-MTR-REF-NO-DEP         
                 AND UR.ACCOUNT_NO_MST     = :UR-ACCOUNT-NO-MST         
                 AND UR.CODE_UTIL_TYPE_MST = :UR-CODE-UTIL-TYPE-MST     
                 AND UR.IC_NO_MST          = :UR-IC-NO-MST              
                 AND UR.MTR_REF_NO_MST     = :UR-MTR-REF-NO-MST         
                 AND UR.CODE_RELATION_TYPE = :UR-CODE-RELATION-TYPE     
                 AND UR.DEP_REL_START_DT   = IIF(TRY_CONVERT(DATE, 
                                                   :UR-DEP-REL-START-DT
              ) IS NULL OR (PATINDEX('%.%', :UR-DEP-REL-START-DT
              ) <> 0) OR (LEN(:UR-DEP-REL-START-DT
              ) <> 10), CIS.CHAR2DATE(:UR-DEP-REL-START-DT
              ), CONVERT(DATE, :UR-DEP-REL-START-DT) )       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*             ,UR.DEP_REL_END_DT                                          
MFA-TR*         INTO :WS-ROW-ALREADY-EXIST                                      
MFA-TR*             ,:UR-DEP-REL-END-DT                                         
MFA-TR*         FROM CSS_UTL_BILL_REL UR                                        
MFA-TR*        WHERE UR.ACCOUNT_NO_DEP     = :UR-ACCOUNT-NO-DEP                 
MFA-TR*          AND UR.CODE_UTIL_TYPE_DEP = :UR-CODE-UTIL-TYPE-DEP             
MFA-TR*          AND UR.IC_NO_DEP          = :UR-IC-NO-DEP                      
MFA-TR*          AND UR.MTR_REF_NO_DEP     = :UR-MTR-REF-NO-DEP                 
MFA-TR*          AND UR.ACCOUNT_NO_MST     = :UR-ACCOUNT-NO-MST                 
MFA-TR*          AND UR.CODE_UTIL_TYPE_MST = :UR-CODE-UTIL-TYPE-MST             
MFA-TR*          AND UR.IC_NO_MST          = :UR-IC-NO-MST                      
MFA-TR*          AND UR.MTR_REF_NO_MST     = :UR-MTR-REF-NO-MST                 
MFA-TR*          AND UR.CODE_RELATION_TYPE = :UR-CODE-RELATION-TYPE             
MFA-TR*          AND UR.DEP_REL_START_DT   = :UR-DEP-REL-START-DT               
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7090                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7090'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT '                TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_CODE_VALUE'         TO TABLE-1                  
              MOVE 'ACCOUNT_NO_DEP'         TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE_DEP'     TO TABLE-ELEMENT-2          
              MOVE 'IC_NO_DEP'              TO TABLE-ELEMENT-3          
              MOVE 'MTR_REF_NO_DEP'         TO TABLE-ELEMENT-4          
              MOVE UR-ACCOUNT-NO-DEP        TO HOSTVAR-ELEMENT-1        
              MOVE UR-CODE-UTIL-TYPE-DEP    TO HOSTVAR-ELEMENT-2        
              MOVE UR-IC-NO-DEP             TO HOSTVAR-ELEMENT-3        
              MOVE UR-MTR-REF-NO-DEP        TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7090-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8000-UPD-CD-ESTMTE-OK.                                         *        
      ******************************************************************        
       8000-UPD-CD-ESTMTE-OK.                                           
                                                                        
           EXEC SQL                                                     
              UPDATE UT                                 
                 SET UT.CODE_ESTIMATE_OK = :UT-CODE-ESTIMATE-OK         
              FROM CSS_UTIL_ENVRNMT UT
               WHERE UT.ACCOUNT_NO       = :UT-ACCOUNT-NO               
                 AND UT.CODE_UTIL_TYPE   = :UT-CODE-UTIL-TYPE           
                 AND UT.IC_NO            = :UT-IC-NO                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_UTIL_ENVRNMT UT                                        
MFA-TR*          SET UT.CODE_ESTIMATE_OK = :UT-CODE-ESTIMATE-OK                 
MFA-TR*        WHERE UT.ACCOUNT_NO       = :UT-ACCOUNT-NO                       
MFA-TR*          AND UT.CODE_UTIL_TYPE   = :UT-CODE-UTIL-TYPE                   
MFA-TR*          AND UT.IC_NO            = :UT-IC-NO                            
MFA-TR*      QUERYNO 8000                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8000'                   TO ACTIVE-PARAGRAPH         
              MOVE 'UPDATE'                 TO ABEND-FUNCTION           
              MOVE 'CSS_UTIL_ENVRNMT'       TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE UT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE UT-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE UT-IC-NO                 TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8100-INSERT-UTL-BILL-REL.                                      *        
      ******************************************************************        
       8100-INSERT-UTL-BILL-REL.                                        
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_UTL_BILL_REL                              
                   ( ACCOUNT_NO_DEP                                     
                    ,CODE_UTIL_TYPE_DEP                                 
                    ,IC_NO_DEP                                          
                    ,MTR_REF_NO_DEP                                     
                    ,ACCOUNT_NO_MST                                     
                    ,CODE_UTIL_TYPE_MST                                 
                    ,IC_NO_MST                                          
                    ,MTR_REF_NO_MST                                     
                    ,CODE_RELATION_TYPE                                 
                    ,DEP_REL_START_DT                                   
                    ,DEP_REL_END_DT )                                   
             VALUES                                                     
                    (:UR-ACCOUNT-NO-DEP                                 
                    ,:UR-CODE-UTIL-TYPE-DEP                             
                    ,:UR-IC-NO-DEP                                      
                    ,:UR-MTR-REF-NO-DEP                                 
                    ,:UR-ACCOUNT-NO-MST                                 
                    ,:UR-CODE-UTIL-TYPE-MST                             
                    ,:UR-IC-NO-MST                                      
                    ,:UR-MTR-REF-NO-MST                                 
                    ,:UR-CODE-RELATION-TYPE                             
                    ,IIF(TRY_CONVERT(DATE, :UR-DEP-REL-START-DT
              ) IS NULL OR (PATINDEX('%.%', :UR-DEP-REL-START-DT
              ) <> 0) OR (LEN(:UR-DEP-REL-START-DT
              ) <> 10), CIS.CHAR2DATE(:UR-DEP-REL-START-DT
              ), CONVERT(DATE, :UR-DEP-REL-START-DT) )                         
                    ,IIF(TRY_CONVERT(DATE, :UR-DEP-REL-END-DT
              ) IS NULL OR (PATINDEX('%.%', :UR-DEP-REL-END-DT
              ) <> 0) OR (LEN(:UR-DEP-REL-END-DT
              ) <> 10), CIS.CHAR2DATE(:UR-DEP-REL-END-DT
              ), CONVERT(DATE, :UR-DEP-REL-END-DT) ))                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_UTL_BILL_REL                                      
MFA-TR*            ( ACCOUNT_NO_DEP                                             
MFA-TR*             ,CODE_UTIL_TYPE_DEP                                         
MFA-TR*             ,IC_NO_DEP                                                  
MFA-TR*             ,MTR_REF_NO_DEP                                             
MFA-TR*             ,ACCOUNT_NO_MST                                             
MFA-TR*             ,CODE_UTIL_TYPE_MST                                         
MFA-TR*             ,IC_NO_MST                                                  
MFA-TR*             ,MTR_REF_NO_MST                                             
MFA-TR*             ,CODE_RELATION_TYPE                                         
MFA-TR*             ,DEP_REL_START_DT                                           
MFA-TR*             ,DEP_REL_END_DT )                                           
MFA-TR*      VALUES                                                             
MFA-TR*             (:UR-ACCOUNT-NO-DEP                                         
MFA-TR*             ,:UR-CODE-UTIL-TYPE-DEP                                     
MFA-TR*             ,:UR-IC-NO-DEP                                              
MFA-TR*             ,:UR-MTR-REF-NO-DEP                                         
MFA-TR*             ,:UR-ACCOUNT-NO-MST                                         
MFA-TR*             ,:UR-CODE-UTIL-TYPE-MST                                     
MFA-TR*             ,:UR-IC-NO-MST                                              
MFA-TR*             ,:UR-MTR-REF-NO-MST                                         
MFA-TR*             ,:UR-CODE-RELATION-TYPE                                     
MFA-TR*             ,:UR-DEP-REL-START-DT                                       
MFA-TR*             ,:UR-DEP-REL-END-DT)                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8100'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_UTL_BILL_REL'       TO TABLE-1                  
              MOVE 'ACCOUNT_NO_DEP'         TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE_DEP'     TO TABLE-ELEMENT-2          
              MOVE 'IC_NO_DEP'              TO TABLE-ELEMENT-3          
              MOVE 'MTR_REF_NO_DEP'         TO TABLE-ELEMENT-4          
              MOVE UR-ACCOUNT-NO-DEP        TO HOSTVAR-ELEMENT-1        
              MOVE UR-CODE-UTIL-TYPE-DEP    TO HOSTVAR-ELEMENT-2        
              MOVE UR-IC-NO-DEP             TO HOSTVAR-ELEMENT-3        
              MOVE UR-MTR-REF-NO-DEP        TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8200-UPDATE-UTL-BILL-REL.                                      *        
      ******************************************************************        
       8200-UPDATE-UTL-BILL-REL.                                        
                                                                        
           EXEC SQL                                                     
              UPDATE UR                                 
                 SET UR.DEP_REL_END_DT     =IIF(TRY_CONVERT(DATE, 
                                                     :UR-DEP-REL-END-DT
              ) IS NULL OR (PATINDEX('%.%', :UR-DEP-REL-END-DT
              ) <> 0) OR (LEN(:UR-DEP-REL-END-DT
              ) <> 10), CIS.CHAR2DATE(:UR-DEP-REL-END-DT
              ), CONVERT(DATE, :UR-DEP-REL-END-DT) )          
              FROM CSS_UTL_BILL_REL UR
               WHERE UR.ACCOUNT_NO_DEP     =:UR-ACCOUNT-NO-DEP          
                 AND UR.CODE_UTIL_TYPE_DEP =:UR-CODE-UTIL-TYPE-DEP      
                 AND UR.IC_NO_DEP          =:UR-IC-NO-DEP               
                 AND UR.MTR_REF_NO_DEP     =:UR-MTR-REF-NO-DEP          
                 AND UR.ACCOUNT_NO_MST     =:UR-ACCOUNT-NO-MST          
                 AND UR.CODE_UTIL_TYPE_MST =:UR-CODE-UTIL-TYPE-MST      
                 AND UR.IC_NO_MST          =:UR-IC-NO-MST               
                 AND UR.MTR_REF_NO_MST     =:UR-MTR-REF-NO-MST          
                 AND UR.CODE_RELATION_TYPE =:UR-CODE-RELATION-TYPE      
                 AND UR.DEP_REL_START_DT   =IIF(TRY_CONVERT(DATE, 
                                                   :UR-DEP-REL-START-DT
              ) IS NULL OR (PATINDEX('%.%', :UR-DEP-REL-START-DT
              ) <> 0) OR (LEN(:UR-DEP-REL-START-DT
              ) <> 10), CIS.CHAR2DATE(:UR-DEP-REL-START-DT
              ), CONVERT(DATE, :UR-DEP-REL-START-DT) )        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ019
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_UTL_BILL_REL UR                                        
MFA-TR*          SET UR.DEP_REL_END_DT     =:UR-DEP-REL-END-DT                  
MFA-TR*        WHERE UR.ACCOUNT_NO_DEP     =:UR-ACCOUNT-NO-DEP                  
MFA-TR*          AND UR.CODE_UTIL_TYPE_DEP =:UR-CODE-UTIL-TYPE-DEP              
MFA-TR*          AND UR.IC_NO_DEP          =:UR-IC-NO-DEP                       
MFA-TR*          AND UR.MTR_REF_NO_DEP     =:UR-MTR-REF-NO-DEP                  
MFA-TR*          AND UR.ACCOUNT_NO_MST     =:UR-ACCOUNT-NO-MST                  
MFA-TR*          AND UR.CODE_UTIL_TYPE_MST =:UR-CODE-UTIL-TYPE-MST              
MFA-TR*          AND UR.IC_NO_MST          =:UR-IC-NO-MST                       
MFA-TR*          AND UR.MTR_REF_NO_MST     =:UR-MTR-REF-NO-MST                  
MFA-TR*          AND UR.CODE_RELATION_TYPE =:UR-CODE-RELATION-TYPE              
MFA-TR*          AND UR.DEP_REL_START_DT   =:UR-DEP-REL-START-DT                
MFA-TR*      QUERYNO 8200                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8200'                   TO ACTIVE-PARAGRAPH         
              MOVE 'UPDATE'                 TO ABEND-FUNCTION           
              MOVE 'CSS_UTL_BILL_REL'       TO TABLE-1                  
              MOVE 'ACCOUNT_NO_DEP'         TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE_DEP'     TO TABLE-ELEMENT-2          
              MOVE 'IC_NO_DEP'              TO TABLE-ELEMENT-3          
              MOVE 'MTR_REF_NO_DEP'         TO TABLE-ELEMENT-4          
              MOVE UR-ACCOUNT-NO-DEP        TO HOSTVAR-ELEMENT-1        
              MOVE UR-CODE-UTIL-TYPE-DEP    TO HOSTVAR-ELEMENT-2        
              MOVE UR-IC-NO-DEP             TO HOSTVAR-ELEMENT-3        
              MOVE UR-MTR-REF-NO-DEP        TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8300-DELETE-UTL-BILL-REL.                                      *        
      ******************************************************************        
       8300-DELETE-UTL-BILL-REL.                                        
                                                                        
           EXEC SQL                                                     
              DELETE UR                                 
              FROM CSS_UTL_BILL_REL UR
               WHERE UR.ACCOUNT_NO_DEP     =:UR-ACCOUNT-NO-DEP          
                 AND UR.CODE_UTIL_TYPE_DEP =:UR-CODE-UTIL-TYPE-DEP      
                 AND UR.IC_NO_DEP          =:UR-IC-NO-DEP               
                 AND UR.MTR_REF_NO_DEP     =:UR-MTR-REF-NO-DEP          
                 AND UR.ACCOUNT_NO_MST     =:UR-ACCOUNT-NO-MST          
                 AND UR.CODE_UTIL_TYPE_MST =:UR-CODE-UTIL-TYPE-MST      
                 AND UR.IC_NO_MST          =:UR-IC-NO-MST               
                 AND UR.MTR_REF_NO_MST     =:UR-MTR-REF-NO-MST          
                 AND UR.CODE_RELATION_TYPE =:UR-CODE-RELATION-TYPE      
                 AND UR.DEP_REL_START_DT   =IIF(TRY_CONVERT(DATE, 
                                                   :UR-DEP-REL-START-DT
              ) IS NULL OR (PATINDEX('%.%', :UR-DEP-REL-START-DT
              ) <> 0) OR (LEN(:UR-DEP-REL-START-DT
              ) <> 10), CIS.CHAR2DATE(:UR-DEP-REL-START-DT
              ), CONVERT(DATE, :UR-DEP-REL-START-DT) )        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ019
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE CSS_UTL_BILL_REL UR                                        
MFA-TR*        WHERE UR.ACCOUNT_NO_DEP     =:UR-ACCOUNT-NO-DEP                  
MFA-TR*          AND UR.CODE_UTIL_TYPE_DEP =:UR-CODE-UTIL-TYPE-DEP              
MFA-TR*          AND UR.IC_NO_DEP          =:UR-IC-NO-DEP                       
MFA-TR*          AND UR.MTR_REF_NO_DEP     =:UR-MTR-REF-NO-DEP                  
MFA-TR*          AND UR.ACCOUNT_NO_MST     =:UR-ACCOUNT-NO-MST                  
MFA-TR*          AND UR.CODE_UTIL_TYPE_MST =:UR-CODE-UTIL-TYPE-MST              
MFA-TR*          AND UR.IC_NO_MST          =:UR-IC-NO-MST                       
MFA-TR*          AND UR.MTR_REF_NO_MST     =:UR-MTR-REF-NO-MST                  
MFA-TR*          AND UR.CODE_RELATION_TYPE =:UR-CODE-RELATION-TYPE              
MFA-TR*          AND UR.DEP_REL_START_DT   =:UR-DEP-REL-START-DT                
MFA-TR*      QUERYNO 8300                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8300'                   TO ACTIVE-PARAGRAPH         
              MOVE 'DELETE'                 TO ABEND-FUNCTION           
              MOVE 'CSS_UTL_BILL_REL'       TO TABLE-1                  
              MOVE 'ACCOUNT_NO_DEP'         TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE_DEP'     TO TABLE-ELEMENT-2          
              MOVE 'IC_NO_DEP'              TO TABLE-ELEMENT-3          
              MOVE 'MTR_REF_NO_DEP'         TO TABLE-ELEMENT-4          
              MOVE UR-ACCOUNT-NO-DEP        TO HOSTVAR-ELEMENT-1        
              MOVE UR-CODE-UTIL-TYPE-DEP    TO HOSTVAR-ELEMENT-2        
              MOVE UR-IC-NO-DEP             TO HOSTVAR-ELEMENT-3        
              MOVE UR-MTR-REF-NO-DEP        TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      *8005-SEND-RESULT                                                *        
      ******************************************************************        
       8005-SEND-RESULT.                                                
                                                                        
           ADD +1                       TO CTR-ROWS.                    
                                                                        
       8005-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************** ***********************************************        
      * 9700-ABEND-PROCESSING.                                         *        
      ******************************************************************        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT.             
           PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT.             
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900 - JOURNALING / ERROR HANDLING ROUTINE                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
           EXEC SQL                                                             
             INCLUDE CPD00321                                                   
           END-EXEC.                                                            
                                                                        
