       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04657.                                         
       AUTHOR.        DANA SHERER.                                      
COB303 DATE-WRITTEN.  SEPTEMBER 12, 2013.                               
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM DOES THE FOLLOWING:                              *        
      *  1. RETRIEVES MASTER AND DEPENDENT METER ACCOUNT INFORMATION   *        
      *     FOR EXISTING CSS_UTL_BILL_REL RELATIONSHIPS.               *        
      *  2. RETRIEVES MASTER METER IC AND METER INFO WHEN SETTING UP   *        
      *     NEW RELATIONSHIPS.                                         *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  09/12/13    DMS      INITIAL VERSION.                         *        
A05065*  10/23/14  M JOHNSON  ADDED 'ON COMMIT DROP TABLE' TO RESULT   *        
A05065*                       SET 1.                                   *        
A05065*                       DEFECT 5919.                             *        
A05065*  11/17/14  AW41078    DEFECT 3962 - RETURN ALL ROWS FOR IC     *        
A05065*                       INSTEAD OF PER METER.                    *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04657'.
MSQ017     COPY MFASQLM.
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04657 STARTS HERE'.                  
                                                                        
      ******************************************************************00540000
      *    COBOL WORKING STORAGE COPY BOOKS                            *00550000
      ******************************************************************00560000
                                                                        
           COPY CCA00001.                                               00600000
           COPY CWS00027.                                               00620000
           COPY CWS00303.                                               00640000
                                                                        
      ******************************************************************00660000
      *    WORK AREAS                                                  *00670000
      ******************************************************************00680000
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04657'.     
           05  WS-ACCOUNT-NO            PIC 9(13).                      
COB305     05 WS-ACCOUNT-NO-NUM        PIC S9(13) COMP-3 VALUE 0.              
           05  WS-ROW-COUNT             PIC 9(5) VALUE 0.               
           05  WS-METER-COUNT           PIC S9(9) COMP VALUE +0.        
           05  WS-IC-COUNT              PIC S9(9) COMP VALUE +0.        
           05  WS-FULL-NAME             PIC  X(70) VALUE SPACES.        
           05  WS-GTT-NAME              PIC X(19) VALUE SPACES.         
           05  WS-GTT01-DECLARED        PIC X(01) VALUE 'N'.            
           05  WS-GTT02-DECLARED        PIC X(01) VALUE 'N'.            
           05  WS-APPL-RETURN-CODE      PIC S9(04) COMP VALUE 0.        
           05  WS-FAILED                PIC X(01)  VALUE 'F'.           
                                                                        
       01  WS-LITERAL.                                                  
           05  WS-A                     PIC X(01) VALUE 'A'.            
           05  WS-B                     PIC X(01) VALUE 'B'.            
           05  WS-C                     PIC X(01) VALUE 'C'.            
           05  WS-G                     PIC X(01) VALUE 'G'.            
           05  WS-I                     PIC X(01) VALUE 'I'.            
           05  WS-M                     PIC X(01) VALUE 'M'.            
           05  WS-R                     PIC X(01) VALUE 'R'.            
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
           05  GWL-STATUS-SUBCODE       PIC S9(9) COMP.                 
       01  FILLER                       PIC X(11) VALUE 'PARM FIELDS'.  
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-L                   PIC S9(09) COMP.                
           05  PARM-NEW-RELATIONSHIP    PIC  X(01).                     
           05  PARM-ACCOUNT-NO          PIC  X(13).                     
           05  PARM-ACCOUNT-NO-RED      REDEFINES PARM-ACCOUNT-NO       
                                        PIC 9(13).                      
           05  PARM-CODE-UTIL-TYPE      PIC  X(1).                      
           05  PARM-IC-NO               PIC S9(09) COMP.                
           05  PARM-METER-REF-NO        PIC S9(09) COMP.                
           05  PARM-METER-NO            PIC  X(09).                     
           05  PARM-RETRIEVE-TYPE       PIC  X(01).                     
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS-RS1              PIC S9(9) COMP VALUE 0.        
           05  CTR-ROWS-RS2              PIC S9(9) COMP VALUE 0.        
                                                                        
       01  WS-ERR-FLAGS.                                                
           05  WS-ERR-INSRT-R1              PIC X(01) VALUE 'N'.        
           05  WS-ERR-INSRT-R2              PIC X(01) VALUE 'N'.        
                                                                        
       01  WORK-FIELDS.                                                 
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE           PIC S9(09) COMP VALUE +0.       
           05  RS-ACCOUNT-NO-DEP        PIC  X(13) VALUE SPACES.        
           05  RS-CODE-UTIL-TYPE-DEP    PIC  X(1)  VALUE SPACES.        
           05  RS-IC-NO-DEP             PIC S9(09) COMP VALUE +0.       
           05  RS-MTR-REF-NO-DEP        PIC S9(09) COMP VALUE +0.       
           05  RS-DEP-REL-START-DT      PIC  X(10) VALUE SPACES.        
           05  RS-DEP-REL-END-DT        PIC  X(10) VALUE SPACES.        
           05  RS-ACCOUNT-NO-MST        PIC  X(13) VALUE SPACES.        
           05  RS-CODE-UTIL-TYPE-MST    PIC  X(1)  VALUE SPACES.        
           05  RS-IC-NO-MST             PIC S9(09) COMP VALUE +0.       
           05  RS-MTR-REF-NO-MST        PIC S9(09) COMP VALUE +0.       
           05  RS-CODE-RELATION-TYPE    PIC  X(01) VALUE SPACES.        
           05  RS-CODE-REVENUE-CLASS    PIC  X(03) VALUE SPACES.        
           05  RS-RATE-PLAN-NO          PIC  X(03) VALUE SPACES.        
           05  RS-METER-NO-MST          PIC  X(09) VALUE SPACES.        
           05  RS-METER-NO-DEP          PIC  X(09) VALUE SPACES.        
           05  RS-ACCOUNT-NAME-MST      PIC  X(50) VALUE SPACES.        
           05  RS-ACCOUNT-NAME-DEP      PIC  X(50) VALUE SPACES.        
           05  RS-DEP-CODE-REV-CLASS    PIC  X(03) VALUE SPACES.        
           05  RS-DEP-RATE-PLAN-NO      PIC  X(03) VALUE SPACES.        
           05  RS-CODE-ACCT-USAGE       PIC  X(01) VALUE SPACES.        
           05  RS-ERROR-MESSAGE         PIC  X(05) VALUE SPACES.        
           05  RS-TOU-RATE-IND          PIC S9(09) COMP VALUE +0.       
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE-1          PIC S9(09) COMP VALUE +0.       
           05  S-APPL-RETURN-CODE-1     PIC S9(04) COMP VALUE 0.        
           05  S-ACCOUNT-NO-DEP         PIC  X(13) VALUE SPACES.        
           05  S-CODE-UTIL-TYPE-DEP     PIC  X(1)  VALUE SPACES.        
           05  S-IC-NO-DEP              PIC S9(09) COMP VALUE +0.       
           05  S-MTR-REF-NO-DEP         PIC S9(09) COMP VALUE +0.       
           05  S-DEP-REL-START-DT       PIC  X(10) VALUE SPACES.        
           05  S-DEP-REL-END-DT         PIC  X(10) VALUE SPACES.        
           05  S-ACCOUNT-NO-MST         PIC  X(13) VALUE SPACES.        
           05  S-CODE-UTIL-TYPE-MST     PIC  X(1)  VALUE SPACES.        
           05  S-IC-NO-MST              PIC S9(09) COMP VALUE +0.       
           05  S-MTR-REF-NO-MST         PIC S9(09) COMP VALUE +0.       
           05  S-CODE-RELATION-TYPE     PIC  X(01) VALUE SPACES.        
           05  S-CODE-REVENUE-CLASS     PIC  X(03) VALUE SPACES.        
           05  S-RATE-PLAN-NO           PIC  X(03) VALUE SPACES.        
           05  S-METER-NO-MST           PIC  X(09) VALUE SPACES.        
           05  S-METER-NO-DEP           PIC  X(09) VALUE SPACES.        
           05  S-ACCOUNT-NAME-MST       PIC  X(50) VALUE SPACES.        
           05  S-ACCOUNT-NAME-DEP       PIC  X(50) VALUE SPACES.        
           05  S-DEP-CODE-REV-CLASS     PIC  X(03) VALUE SPACES.        
           05  S-DEP-RATE-PLAN-NO       PIC  X(03) VALUE SPACES.        
           05  S-CODE-ACCT-USAGE        PIC  X(01) VALUE SPACES.        
           05  S-ERROR-MESSAGE          PIC  X(05) VALUE SPACES.        
           05  S-TOU-RATE-IND           PIC S9(09) COMP VALUE +0.       
      ******************************************************************        
      *   GTT TABLE LAYOUT FOR BUSINESS RULES.                         *        
      ******************************************************************        
           05  GTT-RETURN-FIELDS-2.                                     
               10  S-RETURN-CODE-2        PIC S9(9) COMP VALUE ZERO.    
               10  S-APPL-RETURN-CODE-2   PIC S9(04) COMP VALUE 0.      
               10  S-BUS-RULE-ID          PIC X(10) VALUE SPACES.       
               10  S-BUS-RULE-RESULT-CD   PIC X(10)  VALUE SPACES.      
               10  S-BUS-RULE-XREF-ID     PIC X(26) VALUE SPACES.       
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     01780000
              INCLUDE SQLCA                                             01790000
           END-EXEC.                                                    01800000
                                                                        
           EXEC SQL                                                     01820000
              INCLUDE TBMODEL                                           01830000
           END-EXEC.                                                    01840000
                                                                        
      ***> CSS_UTL_BILL_REL UR TABLE <***                                       
           EXEC SQL                                                             
              INCLUDE TBUTLREL                                                  
           END-EXEC.                                                            
                                                                        
      ***> CSS_UTIL_ENVRNMT UT TABLE <***                                       
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
                                                                        
      ***> CSS_MTRD_ENVRNMT MN TABLE <***                                       
           EXEC SQL                                                             
              INCLUDE TBMTRENV                                                  
           END-EXEC.                                                            
                                                                        
      ***> CSS_ACCOUNT AT TABLE <***                                            
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      ***> CSS_CUSTOMER CU TABLE <***                                           
           EXEC SQL                                                             
              INCLUDE TBCUST                                                    
           END-EXEC.                                                            
                                                                        
      ***> CSS_NAME DQ TABLE <***                                               
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_BUS_RULE_XREF    1T                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRULXRF                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CURSOR DECLARATIONS                                           *         
      *****************************************************************         
                                                                        
      *****************************************************************         
      * DECLARE CURSOR FOR UTILITY ENVIRONMENT                        *         
      *****************************************************************         
           EXEC SQL DECLARE UTIL-CURSOR CURSOR FOR                      
                SELECT  RATE_PLAN_NO                                    
                      , IC_NO                                           
                      , CODE_REVENUE_CLASS                              
                      , TOU_RATE_IND                                    
                FROM    CSS_UTIL_ENVRNMT                                
                WHERE   ACCOUNT_NO        = :UT-ACCOUNT-NO              
                AND     CODE_UTIL_TYPE    = :UT-CODE-UTIL-TYPE          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL DECLARE UTIL-CURSOR CURSOR FOR                      02100000
MFA-TR*         SELECT  RATE_PLAN_NO                                    02110000
MFA-TR*               , IC_NO                                           02120000
MFA-TR*               , CODE_REVENUE_CLASS                              02130000
MFA-TR*               , TOU_RATE_IND                                    02140000
MFA-TR*         FROM    CSS_UTIL_ENVRNMT                                02150000
MFA-TR*         WHERE   ACCOUNT_NO        = :UT-ACCOUNT-NO              02160000
MFA-TR*         AND     CODE_UTIL_TYPE    = :UT-CODE-UTIL-TYPE          02170000
MFA-TR*         QUERYNO 7000                                                    
MFA-TR*    END-EXEC.                                                    02180000
                                                                        
      ******************************************************************        
      * DECLARE CURSOR FOR METERED ENVIRONMENT                         *        
      ******************************************************************        
           EXEC SQL DECLARE METER-CURSOR CURSOR FOR                     
                SELECT  MTR_REF_NO                                      
                      , METER_NO                                        
                FROM    CSS_MTRD_ENVRNMT                                
                WHERE   ACCOUNT_NO        = :MN-ACCOUNT-NO              
                AND     CODE_UTIL_TYPE    = :MN-CODE-UTIL-TYPE          
                AND     IC_NO             = :MN-IC-NO                   
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL DECLARE METER-CURSOR CURSOR FOR                     02200000
MFA-TR*         SELECT  MTR_REF_NO                                      02210000
MFA-TR*               , METER_NO                                        02220000
MFA-TR*         FROM    CSS_MTRD_ENVRNMT                                02230000
MFA-TR*         WHERE   ACCOUNT_NO        = :MN-ACCOUNT-NO              02240000
MFA-TR*         AND     CODE_UTIL_TYPE    = :MN-CODE-UTIL-TYPE          02250000
MFA-TR*         AND     IC_NO             = :MN-IC-NO                   02260000
MFA-TR*         QUERYNO 7100                                                    
MFA-TR*    END-EXEC.                                                    02270000
                                                                        
      *****************************************************************         
      * DECLARE CURSOR FOR MASTER RELATIONSHIP                        *         
      *****************************************************************         
                                                                        
           EXEC SQL DECLARE MASTER-CURSOR CURSOR FOR                    
                SELECT   MTR_REF_NO_MST,                                
                         CODE_RELATION_TYPE                             
                FROM CSS_UTL_BILL_REL                                   
                WHERE ACCOUNT_NO_MST  = :UR-ACCOUNT-NO-MST              
                AND CODE_UTIL_TYPE_MST = :UR-CODE-UTIL-TYPE-MST         
                AND IC_NO_MST = :UR-IC-NO-MST                           
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL DECLARE MASTER-CURSOR CURSOR FOR                            
MFA-TR*         SELECT   MTR_REF_NO_MST,                                        
MFA-TR*                  CODE_RELATION_TYPE                                     
MFA-TR*         FROM CSS_UTL_BILL_REL                                           
MFA-TR*         WHERE ACCOUNT_NO_MST  = :UR-ACCOUNT-NO-MST                      
MFA-TR*         AND CODE_UTIL_TYPE_MST = :UR-CODE-UTIL-TYPE-MST                 
MFA-TR*         AND IC_NO_MST = :UR-IC-NO-MST                                   
MFA-TR*         QUERYNO 7300                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * DECLARE CURSOR FOR DEPENDENT RELATIONSHIP                     *         
      *****************************************************************         
                                                                        
           EXEC SQL DECLARE DEPEND-CURSOR CURSOR FOR                    
                SELECT   MTR_REF_NO_DEP,                                
                         CODE_RELATION_TYPE                             
                FROM CSS_UTL_BILL_REL                                   
                WHERE ACCOUNT_NO_DEP  = :UR-ACCOUNT-NO-DEP              
                AND CODE_UTIL_TYPE_DEP = :UR-CODE-UTIL-TYPE-DEP         
                AND IC_NO_MST = :UR-IC-NO-DEP                           
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL DECLARE DEPEND-CURSOR CURSOR FOR                            
MFA-TR*         SELECT   MTR_REF_NO_DEP,                                        
MFA-TR*                  CODE_RELATION_TYPE                                     
MFA-TR*         FROM CSS_UTL_BILL_REL                                           
MFA-TR*         WHERE ACCOUNT_NO_DEP  = :UR-ACCOUNT-NO-DEP                      
MFA-TR*         AND CODE_UTIL_TYPE_DEP = :UR-CODE-UTIL-TYPE-DEP                 
MFA-TR*         AND IC_NO_MST = :UR-IC-NO-DEP                                   
MFA-TR*         QUERYNO 7330                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * DECLARE CURSOR FOR MASTER/DEPENDENT RELATIONSHIP              *         
      *****************************************************************         
                                                                        
           EXEC SQL DECLARE MASTDEPREL-CURSOR CURSOR FOR                
                SELECT   ACCOUNT_NO_DEP                                 
                        ,CODE_UTIL_TYPE_DEP                             
                        ,IC_NO_DEP                                      
                        ,MTR_REF_NO_DEP                                 
                        ,ACCOUNT_NO_MST                                 
                        ,CODE_UTIL_TYPE_MST                             
                        ,IC_NO_MST                                      
                        ,MTR_REF_NO_MST                                 
                        ,CODE_RELATION_TYPE                             
                        ,DEP_REL_START_DT                               
                        ,DEP_REL_END_DT                                 
                FROM CSS_UTL_BILL_REL UR                                
                WHERE (ACCOUNT_NO_DEP     = :UR-ACCOUNT-NO-DEP          
                  AND CODE_UTIL_TYPE_DEP  = :UR-CODE-UTIL-TYPE-DEP      
                  AND IC_NO_DEP           = :UR-IC-NO-DEP               
                  AND MTR_REF_NO_DEP      = :UR-MTR-REF-NO-DEP)         
                   OR (ACCOUNT_NO_MST     = :UR-ACCOUNT-NO-MST          
                  AND CODE_UTIL_TYPE_MST  = :UR-CODE-UTIL-TYPE-MST      
                  AND IC_NO_MST           = :UR-IC-NO-MST               
                  AND MTR_REF_NO_MST      = :UR-MTR-REF-NO-MST)         
                ORDER BY DEP_REL_START_DT DESC                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL DECLARE MASTDEPREL-CURSOR CURSOR FOR                        
MFA-TR*         SELECT   ACCOUNT_NO_DEP                                         
MFA-TR*                 ,CODE_UTIL_TYPE_DEP                                     
MFA-TR*                 ,IC_NO_DEP                                              
MFA-TR*                 ,MTR_REF_NO_DEP                                         
MFA-TR*                 ,ACCOUNT_NO_MST                                         
MFA-TR*                 ,CODE_UTIL_TYPE_MST                                     
MFA-TR*                 ,IC_NO_MST                                              
MFA-TR*                 ,MTR_REF_NO_MST                                         
MFA-TR*                 ,CODE_RELATION_TYPE                                     
MFA-TR*                 ,DEP_REL_START_DT                                       
MFA-TR*                 ,DEP_REL_END_DT                                         
MFA-TR*         FROM CSS_UTL_BILL_REL UR                                        
MFA-TR*         WHERE (ACCOUNT_NO_DEP     = :UR-ACCOUNT-NO-DEP                  
MFA-TR*           AND CODE_UTIL_TYPE_DEP  = :UR-CODE-UTIL-TYPE-DEP              
MFA-TR*           AND IC_NO_DEP           = :UR-IC-NO-DEP                       
MFA-TR*           AND MTR_REF_NO_DEP      = :UR-MTR-REF-NO-DEP)                 
MFA-TR*            OR (ACCOUNT_NO_MST     = :UR-ACCOUNT-NO-MST                  
MFA-TR*           AND CODE_UTIL_TYPE_MST  = :UR-CODE-UTIL-TYPE-MST              
MFA-TR*           AND IC_NO_MST           = :UR-IC-NO-MST                       
MFA-TR*           AND MTR_REF_NO_MST      = :UR-MTR-REF-NO-MST)                 
MFA-TR*         ORDER BY DEP_REL_START_DT DESC                                  
MFA-TR*         QUERYNO 7360                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
A05065*****************************************************************         
A05065* DECLARE CURSOR FOR MASTER/DEPENDENT RELATIONSHIP BY IC        *         
A05065*****************************************************************         
A05065                                                                  
A05065     EXEC SQL DECLARE MASTDEPRELIC-CURSOR CURSOR FOR              
A05065          SELECT   ACCOUNT_NO_DEP                                 
A05065                  ,CODE_UTIL_TYPE_DEP                             
A05065                  ,IC_NO_DEP                                      
A05065                  ,MTR_REF_NO_DEP                                 
A05065                  ,ACCOUNT_NO_MST                                 
A05065                  ,CODE_UTIL_TYPE_MST                             
A05065                  ,IC_NO_MST                                      
A05065                  ,MTR_REF_NO_MST                                 
A05065                  ,CODE_RELATION_TYPE                             
A05065                  ,DEP_REL_START_DT                               
A05065                  ,DEP_REL_END_DT                                 
A05065          FROM CSS_UTL_BILL_REL UR                                
A05065          WHERE (ACCOUNT_NO_DEP     = :UR-ACCOUNT-NO-DEP          
A05065            AND CODE_UTIL_TYPE_DEP  = :UR-CODE-UTIL-TYPE-DEP      
A05065            AND IC_NO_DEP           = :UR-IC-NO-DEP)              
A05065             OR (ACCOUNT_NO_MST     = :UR-ACCOUNT-NO-MST          
A05065            AND CODE_UTIL_TYPE_MST  = :UR-CODE-UTIL-TYPE-MST      
A05065            AND IC_NO_MST           = :UR-IC-NO-MST)              
A05065          ORDER BY DEP_REL_START_DT DESC                          
A05065                                                      
A05065     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL DECLARE MASTDEPRELIC-CURSOR CURSOR FOR                      
MFA-TR*         SELECT   ACCOUNT_NO_DEP                                         
MFA-TR*                 ,CODE_UTIL_TYPE_DEP                                     
MFA-TR*                 ,IC_NO_DEP                                              
MFA-TR*                 ,MTR_REF_NO_DEP                                         
MFA-TR*                 ,ACCOUNT_NO_MST                                         
MFA-TR*                 ,CODE_UTIL_TYPE_MST                                     
MFA-TR*                 ,IC_NO_MST                                              
MFA-TR*                 ,MTR_REF_NO_MST                                         
MFA-TR*                 ,CODE_RELATION_TYPE                                     
MFA-TR*                 ,DEP_REL_START_DT                                       
MFA-TR*                 ,DEP_REL_END_DT                                         
MFA-TR*         FROM CSS_UTL_BILL_REL UR                                        
MFA-TR*         WHERE (ACCOUNT_NO_DEP     = :UR-ACCOUNT-NO-DEP                  
MFA-TR*           AND CODE_UTIL_TYPE_DEP  = :UR-CODE-UTIL-TYPE-DEP              
MFA-TR*           AND IC_NO_DEP           = :UR-IC-NO-DEP)                      
MFA-TR*            OR (ACCOUNT_NO_MST     = :UR-ACCOUNT-NO-MST                  
MFA-TR*           AND CODE_UTIL_TYPE_MST  = :UR-CODE-UTIL-TYPE-MST              
MFA-TR*           AND IC_NO_MST           = :UR-IC-NO-MST)                      
MFA-TR*         ORDER BY DEP_REL_START_DT DESC                                  
MFA-TR*         QUERYNO 7365                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
HPCCDM*EJECT                                                            02470000
           EXEC SQL                                                     00000010
               INCLUDE CWSX0010                                         00000020
           END-EXEC.                                                    00000030
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
           10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
                                                                        
       LINKAGE SECTION.                                                 
                                                                        
       01  LINK-NEW-RELATIONSHIP    PIC  X(01)               .          
       01  LINK-ACCOUNT-NO          PIC  X(13)               .          
       01  LINK-CODE-UTIL-TYPE      PIC  X(1)                .          
       01  LINK-IC-NO               PIC S9(09) COMP          .          
       01  LINK-METER-REF-NO        PIC S9(09) COMP          .          
       01  LINK-METER-NO            PIC  X(09)               .          
       01  LINK-RETRIEVE-TYPE       PIC  X(01)               .          
                                                                        
       PROCEDURE DIVISION USING                                         
                LINK-NEW-RELATIONSHIP                                   
                LINK-ACCOUNT-NO                                         
                LINK-CODE-UTIL-TYPE                                     
                LINK-IC-NO                                              
                LINK-METER-REF-NO                                       
                LINK-METER-NO                                           
                LINK-RETRIEVE-TYPE.                                     
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLWARNING                                      
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLERROR                                        
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER NOT FOUND                                       
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
      ******************************************************************02500000
      * 0000-MAINLINE                                                  *02510000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *02520000
      ******************************************************************02530000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02640000
      * 0100-INITIALIZE                                                *02650000
      *                                                                *02660000
      *                                                                *02670000
      *     1. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *02680000
      *     2. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *02690000
      *     3. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*02700000
      *                                                                *02710000
      ******************************************************************02720000
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'                    TO ACTIVE-PARAGRAPH.          
           INITIALIZE TDS-RETURN-FIELDS                                 
                      GTT-RETURN-FIELDS.                                
           MOVE 'N'                       TO WS-GTT01-DECLARED          
                                             WS-GTT02-DECLARED.         
           MOVE '1900-01-01'              TO RS-DEP-REL-START-DT        
                                             RS-DEP-REL-END-DT.         
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1   THRU 0100A-EXIT.              
           PERFORM 0100B-DECLARE-GTT-R2   THRU 0100B-EXIT.              
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100A-DECLARE-GTT-R1.                                            
                                                                        
           MOVE 'SESSION.CSR04657_R1'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04657_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04657_R1
              (                                                          
               RETURN_CODE              INT                         
              ,APPL_RETURN_CODE         INT                         
              ,ACCOUNT_NO_DEP CHAR(13)  COLLATE LATIN1_GENERAL_100_BIN2         
              ,CODE_UTIL_TYPE_DEP CHAR(1)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                         
              ,IC_NO_DEP                INT                         
              ,MTR_REF_NO_DEP           INT                         
              ,DEP_REL_START_DT CHAR(10)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
              ,DEP_REL_END_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2         
              ,ACCOUNT_NO_MST CHAR(13)  COLLATE LATIN1_GENERAL_100_BIN2         
              ,CODE_UTIL_TYPE_MST CHAR(1)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                         
              ,IC_NO_MST                INT                         
              ,MTR_REF_NO_MST           INT                         
              ,CODE_RELATION_TYPE CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
              ,CODE_REVENUE_CLASS CHAR(03)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
              ,RATE_PLAN_NO CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2           
              ,METER_NO_MST CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2           
              ,METER_NO_DEP CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2           
              ,ACCOUNT_NAME_MST CHAR(50)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
              ,ACCOUNT_NAME_DEP CHAR(50)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
              ,CODE_REV_CLASS_DEP CHAR(03)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
              ,RATE_PLAN_NO_DEP CHAR(03)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
              ,CODE_ACCT_USAGE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2        
              ,ERROR_MESSAGE CHAR(05)  COLLATE LATIN1_GENERAL_100_BIN2          
A05065       )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  MOVE 'Y'                  TO WS-GTT01-DECLARED        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'               TO ACTIVE-PARAGRAPH        
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE WS-GTT-NAME          TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT        
               END-IF                                                   
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
               SELECT                                                   
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,LTRIM(RTRIM(ACCOUNT_NO_DEP))      AS ACCOUNT_NO_DEP         
                  ,LTRIM(RTRIM(CODE_UTIL_TYPE_DEP))  AS 
           CODE_UTIL_TYPE_DEP     
                  ,IC_NO_DEP                  AS IC_NO_DEP              
                  ,MTR_REF_NO_DEP             AS MTR_REF_NO_DEP         
                  ,LTRIM(RTRIM(DEP_REL_START_DT))    AS DEP_REL_START_DT       
                  ,LTRIM(RTRIM(DEP_REL_END_DT))      AS DEP_REL_END_DT         
                  ,LTRIM(RTRIM(ACCOUNT_NO_MST))      AS ACCOUNT_NO_MST         
                  ,LTRIM(RTRIM(CODE_UTIL_TYPE_MST))  AS 
           CODE_UTIL_TYPE_MST     
                  ,IC_NO_MST                  AS IC_NO_MST              
                  ,MTR_REF_NO_MST             AS MTR_REF_NO_MST         
                  ,LTRIM(RTRIM(CODE_RELATION_TYPE))  AS 
           CODE_RELATION_TYPE     
                  ,LTRIM(RTRIM(CODE_REVENUE_CLASS))  AS 
           CODE_REVENUE_CLASS     
                  ,LTRIM(RTRIM(RATE_PLAN_NO))        AS RATE_PLAN_NO           
                  ,LTRIM(RTRIM(METER_NO_MST))        AS METER_NO_MST           
                  ,LTRIM(RTRIM(METER_NO_DEP))        AS METER_NO_DEP           
                  ,LTRIM(RTRIM(ACCOUNT_NAME_MST))    AS ACCOUNT_NAME_MST       
                  ,LTRIM(RTRIM(ACCOUNT_NAME_DEP))    AS ACCOUNT_NAME_DEP       
                  ,LTRIM(RTRIM(CODE_REV_CLASS_DEP))  AS 
           CODE_REV_CLASS_DEP     
                  ,LTRIM(RTRIM(RATE_PLAN_NO_DEP))    AS RATE_PLAN_NO_DEP       
                  ,LTRIM(RTRIM(CODE_ACCT_USAGE))     AS CODE_ACCT_USAGE        
                  ,LTRIM(RTRIM(ERROR_MESSAGE))       AS ERROR_MESSAGE          
               FROM #CSR04657_R1                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     00000100
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                            00000300
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*        SELECT                                                   00000400
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,STRIP(ACCOUNT_NO_DEP)      AS ACCOUNT_NO_DEP                 
MFA-TR*           ,STRIP(CODE_UTIL_TYPE_DEP)  AS CODE_UTIL_TYPE_DEP             
MFA-TR*           ,IC_NO_DEP                  AS IC_NO_DEP                      
MFA-TR*           ,MTR_REF_NO_DEP             AS MTR_REF_NO_DEP                 
MFA-TR*           ,STRIP(DEP_REL_START_DT)    AS DEP_REL_START_DT               
MFA-TR*           ,STRIP(DEP_REL_END_DT)      AS DEP_REL_END_DT                 
MFA-TR*           ,STRIP(ACCOUNT_NO_MST)      AS ACCOUNT_NO_MST                 
MFA-TR*           ,STRIP(CODE_UTIL_TYPE_MST)  AS CODE_UTIL_TYPE_MST             
MFA-TR*           ,IC_NO_MST                  AS IC_NO_MST                      
MFA-TR*           ,MTR_REF_NO_MST             AS MTR_REF_NO_MST                 
MFA-TR*           ,STRIP(CODE_RELATION_TYPE)  AS CODE_RELATION_TYPE             
MFA-TR*           ,STRIP(CODE_REVENUE_CLASS)  AS CODE_REVENUE_CLASS             
MFA-TR*           ,STRIP(RATE_PLAN_NO)        AS RATE_PLAN_NO                   
MFA-TR*           ,STRIP(METER_NO_MST)        AS METER_NO_MST                   
MFA-TR*           ,STRIP(METER_NO_DEP)        AS METER_NO_DEP                   
MFA-TR*           ,STRIP(ACCOUNT_NAME_MST)    AS ACCOUNT_NAME_MST               
MFA-TR*           ,STRIP(ACCOUNT_NAME_DEP)    AS ACCOUNT_NAME_DEP               
MFA-TR*           ,STRIP(CODE_REV_CLASS_DEP)  AS CODE_REV_CLASS_DEP             
MFA-TR*           ,STRIP(RATE_PLAN_NO_DEP)    AS RATE_PLAN_NO_DEP               
MFA-TR*           ,STRIP(CODE_ACCT_USAGE)     AS CODE_ACCT_USAGE                
MFA-TR*           ,STRIP(ERROR_MESSAGE)       AS ERROR_MESSAGE                  
MFA-TR*        FROM SESSION.CSR04657_R1                                 00000500
MFA-TR*    END-EXEC.                                                    00000700
                                                                        
       0100A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *  100B-DECLARE-GTT-R2 - BUSINESS RULES                          *        
      ******************************************************************        
       0100B-DECLARE-GTT-R2.                                            
                                                                        
           MOVE 'SESSION.CSR04657_R2'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04657_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04657_R2
              (                                                      
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,BUS_RULE_ID CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BUS_RULE_RESULT_CD CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BUS_RULE_XREF_ID CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                 )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF SQLSTATE = '42710'                                        
              PERFORM 8000B-DELETE-GTT-ROWS    THRU 8000B-EXIT          
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                 MOVE 'Y'                   TO WS-GTT02-DECLARED        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100B'              TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE WS-GTT-NAME          TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT           
               END-IF                                                   
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C2 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,LTRIM(RTRIM(BUS_RULE_ID))          AS BUS_RULE_ID       
                      ,LTRIM(RTRIM(BUS_RULE_RESULT_CD))   AS 
           BUS_RULE_RESULT_CD
                      ,LTRIM(RTRIM(BUS_RULE_XREF_ID))     AS 
           BUS_RULE_XREF_ID  
                  FROM #CSR04657_R2                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C2 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,STRIP(BUS_RULE_ID)          AS BUS_RULE_ID               
MFA-TR*               ,STRIP(BUS_RULE_RESULT_CD)   AS BUS_RULE_RESULT_CD        
MFA-TR*               ,STRIP(BUS_RULE_XREF_ID)     AS BUS_RULE_XREF_ID          
MFA-TR*           FROM SESSION.CSR04657_R2                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100B-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT.                                            *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      *                                                                *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE LINK-NEW-RELATIONSHIP     TO PARM-NEW-RELATIONSHIP.     
           MOVE LINK-ACCOUNT-NO           TO PARM-ACCOUNT-NO.           
           MOVE LINK-CODE-UTIL-TYPE       TO PARM-CODE-UTIL-TYPE.       
           MOVE LINK-IC-NO                TO PARM-IC-NO.                
           MOVE LINK-METER-REF-NO         TO PARM-METER-REF-NO.         
           MOVE LINK-METER-NO             TO PARM-METER-NO.             
           MOVE LINK-RETRIEVE-TYPE        TO PARM-RETRIEVE-TYPE.        
                                                                        
           MOVE PARM-ACCOUNT-NO-RED TO WS-ACCOUNT-NO.                   
           MOVE WS-ACCOUNT-NO       TO WS-ACCOUNT-NO-NUM.               
           MOVE WS-ACCOUNT-NO-NUM   TO UR-ACCOUNT-NO-DEP                
                                       UR-ACCOUNT-NO-MST.               
           MOVE PARM-CODE-UTIL-TYPE TO UR-CODE-UTIL-TYPE-DEP            
                                       UR-CODE-UTIL-TYPE-MST.           
           MOVE PARM-IC-NO          TO UR-IC-NO-DEP                     
                                       UR-IC-NO-MST.                    
           MOVE PARM-METER-REF-NO   TO UR-MTR-REF-NO-DEP                
                                       UR-MTR-REF-NO-MST.               
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03780000
      * 2000-PROCESS-OUTPUT.                                           *03790000
      *                                                                *03800000
      *     1. DESCRIBE RESULT SET                                     *03810000
      *     2. UPDATE DB2 DATA                                         *03820000
      *     3. BUILD RESULT SET                                        *03830000
      *     4. SEND RESULT SET                                         *03840000
      *                                                                *03850000
      ******************************************************************03860000
                                                                        
       2000-PROCESS-OUTPUT.                                             
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
           IF PARM-NEW-RELATIONSHIP = 'Y'                               
              PERFORM 2300-PROCESS-NEW THRU 2300-EXIT                   
           ELSE                                                         
              PERFORM 2200-PROCESS THRU 2200-EXIT                       
           END-IF.                                                      
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *2000A-MOVE-RESULT.                                                       
      ******************************************************************        
       2000A-MOVE-RESULT.                                               
      *                                                                         
           MOVE RS-RETURN-CODE         TO S-RETURN-CODE-1.              
           MOVE RS-ACCOUNT-NO-DEP      TO S-ACCOUNT-NO-DEP.             
           MOVE RS-CODE-UTIL-TYPE-DEP  TO S-CODE-UTIL-TYPE-DEP.         
           MOVE RS-IC-NO-DEP           TO S-IC-NO-DEP.                  
           MOVE RS-MTR-REF-NO-DEP      TO S-MTR-REF-NO-DEP.             
           MOVE RS-DEP-REL-START-DT    TO S-DEP-REL-START-DT            
           MOVE RS-DEP-REL-END-DT      TO S-DEP-REL-END-DT              
           MOVE RS-ACCOUNT-NO-MST      TO S-ACCOUNT-NO-MST.             
           MOVE RS-CODE-UTIL-TYPE-MST  TO S-CODE-UTIL-TYPE-MST.         
           MOVE RS-IC-NO-MST           TO S-IC-NO-MST.                  
           MOVE RS-MTR-REF-NO-MST      TO S-MTR-REF-NO-MST.             
           MOVE RS-CODE-RELATION-TYPE  TO S-CODE-RELATION-TYPE.         
           MOVE RS-CODE-REVENUE-CLASS  TO S-CODE-REVENUE-CLASS.         
           MOVE RS-RATE-PLAN-NO        TO S-RATE-PLAN-NO.               
           MOVE RS-METER-NO-MST        TO S-METER-NO-MST.               
           MOVE RS-METER-NO-DEP        TO S-METER-NO-DEP.               
           MOVE RS-ACCOUNT-NAME-MST    TO S-ACCOUNT-NAME-MST.           
           MOVE RS-ACCOUNT-NAME-DEP    TO S-ACCOUNT-NAME-DEP.           
           MOVE RS-DEP-CODE-REV-CLASS  TO S-DEP-CODE-REV-CLASS.         
           MOVE RS-DEP-RATE-PLAN-NO    TO S-DEP-RATE-PLAN-NO.           
           MOVE RS-CODE-ACCT-USAGE     TO S-CODE-ACCT-USAGE.            
           MOVE RS-ERROR-MESSAGE       TO S-ERROR-MESSAGE.              
                                                                        
       2000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************06600000
      * 2200-PROCESS.                                                  *06610000
      ******************************************************************06620000
       2200-PROCESS.                                                    
                                                                        
A05065     IF PARM-RETRIEVE-TYPE = 'I'                                  
A05065        PERFORM 7365-OPEN-MASTDEPRELIC  THRU 7365-EXIT            
A05065        PERFORM 7375-FETCH-MASTDEPRELIC THRU 7375-EXIT            
A05065     ELSE                                                         
              PERFORM 7360-OPEN-MASTDEPREL  THRU 7360-EXIT              
              PERFORM 7370-FETCH-MASTDEPREL THRU 7370-EXIT              
A05065     END-IF.                                                      
                                                                        
      ***  WHEN NO EXISTING RELATIONSHIPS ARE FOUND RETURN 'N' IN               
      ***  CODE-ACCT-USAGE FIELD TO NOTIFY PANEL NO RELATIONSHIPS EXIST.        
      ***  THIS IS NOT THE ACTUAL VALUE OF AT-CODE-ACCT-USAGE AND 'N'           
      ***  IS CURRENTLY NOT A VALID VALUE FOR THIS COLUMN IN DATABASE.          
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              MOVE 'N'                   TO RS-CODE-ACCT-USAGE          
              MOVE SPACES                TO RS-ERROR-MESSAGE            
      *                                                                         
              ADD 1                      TO WS-ROW-COUNT                
              PERFORM 2000A-MOVE-RESULT  THRU 2000A-EXIT                
              PERFORM 8100-SEND-RESULT   THRU 8100-EXIT                 
           ELSE                                                         
              PERFORM 2600-PROCESS-MASTDEPREL THRU 2600-EXIT            
                 UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                
A05065        IF PARM-RETRIEVE-TYPE ='I'                                
A05065           PERFORM 7385-CLOSE-MASTDEPRELIC THRU 7385-EXIT         
A05065        ELSE                                                      
                 PERFORM 7380-CLOSE-MASTDEPREL   THRU 7380-EXIT         
A05065        END-IF                                                    
           END-IF.                                                      
      *                                                                 08100000
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08140000
      * 2300-PROCESS-NEW.                                              *08150000
      ******************************************************************08160000
                                                                        
       2300-PROCESS-NEW.                                                
                                                                        
           MOVE WS-ACCOUNT-NO-NUM   TO AT-ACCOUNT-NO.                   
           MOVE PARM-ACCOUNT-NO     TO RS-ACCOUNT-NO-MST.               
           PERFORM 7220-SELECT-ACCOUNT THRU 7220-EXIT.                  
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              MOVE 'MRM0000074' TO S-BUS-RULE-ID                        
              MOVE WS-FAILED TO S-BUS-RULE-RESULT-CD                    
              IF S-BUS-RULE-ID GREATER THAN SPACES                      
                 PERFORM 7550-GET-RULE-XREF-ID THRU 7550-EXIT           
              END-IF                                                    
              PERFORM 8020-INSERT-GTT-R2 THRU 8020-EXIT                 
              ADD 1 TO WS-ROW-COUNT                                     
              PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT                 
              PERFORM 8100-SEND-RESULT THRU 8100-EXIT                   
              PERFORM 9999-END-PROGRAM THRU 9999-EXIT                   
           END-IF.                                                      
                                                                        
           MOVE AT-CODE-ACCT-USAGE  TO RS-CODE-ACCT-USAGE.              
           MOVE AT-CUSTOMER-NO      TO CU-CUSTOMER-NO.                  
           MOVE SPACES              TO RS-ACCOUNT-NAME-MST              
                                       WS-FULL-NAME.                    
           PERFORM 7225-SELECT-NAME THRU 7225-EXIT.                     
           MOVE WS-FULL-NAME        TO RS-ACCOUNT-NAME-MST.             
           MOVE PARM-CODE-UTIL-TYPE TO MN-CODE-UTIL-TYPE                
                                       UT-CODE-UTIL-TYPE                
                                       RS-CODE-UTIL-TYPE-MST.           
           MOVE AT-ACCOUNT-NO       TO MN-ACCOUNT-NO                    
                                       UT-ACCOUNT-NO.                   
           MOVE SPACES              TO RS-ERROR-MESSAGE.                
                                                                        
           PERFORM 7000-OPEN-UTIL     THRU 7000-EXIT.                   
           PERFORM 2400-PROCESS-IC    THRU 2400-EXIT                    
              UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.                  
           PERFORM 7020-CLOSE-UTIL     THRU 7020-EXIT.                  
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08930000
      * 2400-PROCESS-IC.                                              * 08940000
      ******************************************************************08950000
       2400-PROCESS-IC.                                                 
           PERFORM 7010-FETCH-UTIL THRU 7010-EXIT.                      
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
           AND WS-IC-COUNT = 0                                          
              MOVE 'MRM0000075' TO S-BUS-RULE-ID                        
              MOVE WS-FAILED TO S-BUS-RULE-RESULT-CD                    
              IF S-BUS-RULE-ID GREATER THAN SPACES                      
                 PERFORM 7550-GET-RULE-XREF-ID THRU 7550-EXIT           
              END-IF                                                    
              PERFORM 8020-INSERT-GTT-R2 THRU 8020-EXIT                 
              ADD 1 TO WS-ROW-COUNT                                     
              PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT                 
              PERFORM 8100-SEND-RESULT THRU 8100-EXIT                   
              PERFORM 9999-END-PROGRAM THRU 9999-EXIT                   
           END-IF.                                                      
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD 1 TO WS-IC-COUNT                                      
              MOVE UT-RATE-PLAN-NO TO RS-RATE-PLAN-NO                   
              MOVE UT-IC-NO        TO RS-IC-NO-MST                      
              MOVE UT-TOU-RATE-IND TO RS-TOU-RATE-IND                   
              MOVE UT-CODE-REVENUE-CLASS TO RS-CODE-REVENUE-CLASS       
              MOVE ZERO TO WS-METER-COUNT                               
              MOVE UT-IC-NO    TO MN-IC-NO                              
              PERFORM 7100-OPEN-METER    THRU 7100-EXIT                 
              PERFORM 2500-PROCESS-METER THRU 2500-EXIT                 
                      UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND           
              PERFORM 7120-CLOSE-METER    THRU 7120-EXIT                
      * IF THERE ARE NO METERS FOR THIS IC IT IS OK JUST SEND BACK      09160000
      * ALL IC INFO                                                     09170000
              IF WS-METER-COUNT = 0                                     
                 MOVE ZEROS         TO RS-MTR-REF-NO-MST                
                 MOVE SPACES        TO RS-METER-NO-MST                  
                 ADD 1 TO WS-ROW-COUNT                                  
                 PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT              
                 PERFORM 8100-SEND-RESULT THRU 8100-EXIT
              END-IF
           END-IF.               
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************09260000
      * 2500-PROCESS-METER.                                           * 09270000
      ******************************************************************09280000
       2500-PROCESS-METER.                                              
           PERFORM 7110-FETCH-METER THRU 7110-EXIT.                     
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE MN-MTR-REF-NO TO RS-MTR-REF-NO-MST                   
              MOVE MN-METER-NO   TO RS-METER-NO-MST                     
              ADD 1 TO WS-METER-COUNT                                   
              ADD 1 TO WS-ROW-COUNT                                     
              PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT                 
              PERFORM 8100-SEND-RESULT THRU 8100-EXIT
           END-IF.                  
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************09260000
      * 2600-PROCESS-MASTDEPREL.                                      * 09270000
      ******************************************************************09280000
       2600-PROCESS-MASTDEPREL.                                         
      *                                                                         
      ***  INITIALIZE RETURN FIELDS AFTER EACH FETCH                            
           INITIALIZE TDS-RETURN-FIELDS.                                
           MOVE '1900-01-01' TO RS-DEP-REL-START-DT                     
                                RS-DEP-REL-END-DT.                      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE UR-ACCOUNT-NO-DEP        TO RS-ACCOUNT-NO-DEP        
              MOVE UR-CODE-UTIL-TYPE-DEP    TO RS-CODE-UTIL-TYPE-DEP    
              MOVE UR-IC-NO-DEP             TO RS-IC-NO-DEP             
              MOVE UR-MTR-REF-NO-DEP        TO RS-MTR-REF-NO-DEP        
              MOVE UR-ACCOUNT-NO-MST        TO RS-ACCOUNT-NO-MST        
                                               AT-ACCOUNT-NO            
                                               UT-ACCOUNT-NO            
              MOVE UR-CODE-UTIL-TYPE-MST    TO RS-CODE-UTIL-TYPE-MST    
                                               UT-CODE-UTIL-TYPE        
              MOVE UR-IC-NO-MST             TO RS-IC-NO-MST             
                                               UT-IC-NO                 
              MOVE UR-MTR-REF-NO-MST        TO RS-MTR-REF-NO-MST        
              MOVE UR-CODE-RELATION-TYPE    TO RS-CODE-RELATION-TYPE    
              MOVE UR-DEP-REL-START-DT      TO RS-DEP-REL-START-DT      
              MOVE UR-DEP-REL-END-DT        TO RS-DEP-REL-END-DT        
      *                                                                         
      *** GET FULL NAME FOR MASTER METER ACCOUNT                                
              PERFORM 7220-SELECT-ACCOUNT   THRU 7220-EXIT              
              MOVE AT-CUSTOMER-NO           TO CU-CUSTOMER-NO           
              MOVE SPACES                   TO RS-ACCOUNT-NAME-MST      
                                               WS-FULL-NAME             
              PERFORM 7225-SELECT-NAME      THRU 7225-EXIT              
              MOVE WS-FULL-NAME             TO RS-ACCOUNT-NAME-MST      
      *                                                                         
      *** GET FULL NAME FOR DEPEND METER ACCOUNT                                
              MOVE UR-ACCOUNT-NO-DEP        TO AT-ACCOUNT-NO            
              PERFORM 7220-SELECT-ACCOUNT   THRU 7220-EXIT              
              MOVE AT-CUSTOMER-NO           TO CU-CUSTOMER-NO           
              MOVE SPACES                   TO RS-ACCOUNT-NAME-DEP      
                                               WS-FULL-NAME             
              PERFORM 7225-SELECT-NAME      THRU 7225-EXIT              
              MOVE WS-FULL-NAME             TO RS-ACCOUNT-NAME-DEP      
      *                                                                         
      *** GET UTILITY INFO FOR MASTER METER ACCOUNT                             
              PERFORM 7210-SELECT-UTIL-ENV  THRU 7210-EXIT              
              MOVE UT-CODE-REVENUE-CLASS    TO RS-CODE-REVENUE-CLASS    
              MOVE UT-RATE-PLAN-NO          TO RS-RATE-PLAN-NO          
              MOVE UT-TOU-RATE-IND          TO RS-TOU-RATE-IND          
      *                                                                         
      *                                                                         
      *** GET UTILITY INFO FOR DEPENDENT METER ACCOUNT                          
              PERFORM 7215-SELECT-DEP-UTL-ENV  THRU 7215-EXIT           
              MOVE UT-CODE-REVENUE-CLASS    TO RS-DEP-CODE-REV-CLASS    
              MOVE UT-RATE-PLAN-NO          TO RS-DEP-RATE-PLAN-NO      
      *                                                                         
      *** GET METER INFO FOR MASTER METER ACCOUNT                               
              IF UR-MTR-REF-NO-MST = 0                                  
                 MOVE SPACES                TO RS-METER-NO-MST          
              ELSE                                                      
                 MOVE UR-ACCOUNT-NO-MST     TO MN-ACCOUNT-NO            
                 MOVE UR-CODE-UTIL-TYPE-MST TO MN-CODE-UTIL-TYPE        
                 MOVE UR-IC-NO-MST          TO MN-IC-NO                 
                 MOVE UR-MTR-REF-NO-MST     TO MN-MTR-REF-NO            
                 PERFORM 7230-SELECT-METERED-ENV THRU 7230-EXIT         
                 MOVE MN-METER-NO           TO RS-METER-NO-MST          
              END-IF                                                    
      *                                                                         
      *** GET METER INFO FOR DEPENDENT METER ACCOUNT                            
              IF UR-MTR-REF-NO-DEP = 0                                  
                 MOVE SPACES                TO RS-METER-NO-DEP          
              ELSE                                                      
                 MOVE UR-ACCOUNT-NO-DEP     TO MN-ACCOUNT-NO            
                 MOVE UR-CODE-UTIL-TYPE-DEP TO MN-CODE-UTIL-TYPE        
                 MOVE UR-IC-NO-DEP          TO MN-IC-NO                 
                 MOVE UR-MTR-REF-NO-DEP     TO MN-MTR-REF-NO            
                 PERFORM 7230-SELECT-METERED-ENV THRU 7230-EXIT         
                 MOVE MN-METER-NO           TO RS-METER-NO-DEP          
              END-IF                                                    
      *                                                                         
              MOVE SPACES                   TO RS-CODE-ACCT-USAGE       
              MOVE SPACES                   TO RS-ERROR-MESSAGE         
      *                                                                         
              ADD 1                         TO WS-ROW-COUNT             
              PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT                 
              PERFORM 8100-SEND-RESULT THRU 8100-EXIT                   
           END-IF.                                                      
      *                                                                         
A05065     IF PARM-RETRIEVE-TYPE ='I'                                   
A05065        PERFORM 7375-FETCH-MASTDEPRELIC  THRU 7375-EXIT           
A05065     ELSE                                                         
              PERFORM 7370-FETCH-MASTDEPREL    THRU 7370-EXIT           
A05065     END-IF.                                                      
      *                                                                         
       2600-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09400000
      ******************************************************************09410000
      * 7000-OPEN-UTIL.                                               * 09420000
      ******************************************************************09430000
       7000-OPEN-UTIL.                                                  
           EXEC SQL                                                     
               OPEN UTIL-CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE '7000'              TO ACTIVE-PARAGRAPH              
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE 'OPEN'              TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
              MOVE 'CSS_UTIL_ENVRNMT'  TO TABLE-1                       
              MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
              MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-2               
              MOVE UT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
              MOVE UT-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-2             
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************  09660000
      * 7010-FETCH-UTIL                                              *  09670000
      ****************************************************************  09680000
                                                                        
       7010-FETCH-UTIL.                                                 
                                                                        
           EXEC SQL                                                     
               FETCH UTIL-CURSOR                                        
               INTO                                                     
                    :UT-RATE-PLAN-NO                                    
                 ,  :UT-IC-NO                                           
                 ,  :UT-CODE-REVENUE-CLASS                              
                 ,  :UT-TOU-RATE-IND                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE '7010'              TO ACTIVE-PARAGRAPH              
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE 'FETCH'             TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
              MOVE 'CSS_UTIL_ENVRNMT'  TO TABLE-1                       
              MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
              MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-2               
              MOVE UT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
              MOVE UT-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-2             
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************  09960000
      * 7020-CLOSE-UTIL                                              *  09970000
      ****************************************************************  09980000
                                                                        
       7020-CLOSE-UTIL.                                                 
                                                                        
            EXEC SQL                                                    
                CLOSE UTIL-CURSOR                                       
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
                NEXT SENTENCE                                           
            ELSE                                                        
              MOVE '7020'              TO ACTIVE-PARAGRAPH              
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE 'CLOSE'             TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
              MOVE 'CSS_UTIL_ENVRNMT'  TO TABLE-1                       
              MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
              MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-2               
              MOVE UT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
              MOVE UT-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-2             
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
            END-IF.                                                     
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************  10220000
      * 7100-OPEN-METER                                              *  10230000
      ****************************************************************  10240000
                                                                        
       7100-OPEN-METER.                                                 
                                                                        
           EXEC SQL                                                     
               OPEN METER-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE '7100'              TO ACTIVE-PARAGRAPH              
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE 'OPEN'              TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
              MOVE 'CSS_MTRD_ENVRNMT'  TO TABLE-1                       
              MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
              MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-2               
              MOVE 'IC_NO'             TO TABLE-ELEMENT-3               
              MOVE MN-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
              MOVE MN-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-2             
              MOVE MN-IC-NO            TO HOSTVAR-ELEMENT-3             
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************  10490000
      * 7110-FETCH-METER                                             *  10500000
      ****************************************************************  10510000
                                                                        
       7110-FETCH-METER.                                                
                                                                        
           EXEC SQL                                                     
               FETCH METER-CURSOR                                       
               INTO :MN-MTR-REF-NO,
                :MN-METER-NO                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ064
MFA-TR*    EXEC SQL                                                     10550000
MFA-TR*        FETCH METER-CURSOR                                       10560000
MFA-TR*        INTO                                                     10570000
MFA-TR*             :MN-MTR-REF-NO                                      10580000
MFA-TR*          ,  :MN-METER-NO                                        10590000
MFA-TR*          ,  :MN-CODE-UTIL-TYPE                                  10600000
MFA-TR*          ,  :MN-IC-NO                                           10610000
MFA-TR*    END-EXEC.                                                    10620000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE '7110'              TO ACTIVE-PARAGRAPH              
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE 'FETCH'             TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
              MOVE 'CSS_MTRD_ENVRNMT'  TO TABLE-1                       
              MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
              MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-2               
              MOVE 'IC_NO'             TO TABLE-ELEMENT-3               
              MOVE MN-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
              MOVE MN-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-2             
              MOVE MN-IC-NO            TO HOSTVAR-ELEMENT-3             
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************  10810000
      * 7120-CLOSE-METER                                             *  10820000
      ****************************************************************  10830000
                                                                        
       7120-CLOSE-METER.                                                
                                                                        
            EXEC SQL                                                    
                CLOSE METER-CURSOR                                      
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
                NEXT SENTENCE                                           
            ELSE                                                        
              MOVE '7120'              TO ACTIVE-PARAGRAPH              
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE 'CLOSE'             TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
              MOVE 'CSS_MTRD_ENVRNMT'  TO TABLE-1                       
              MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
              MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-2               
              MOVE 'IC_NO'             TO TABLE-ELEMENT-3               
              MOVE MN-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
              MOVE MN-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-2             
              MOVE MN-IC-NO            TO HOSTVAR-ELEMENT-3             
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
            END-IF.                                                     
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7210-SELECT-UTIL-ENV.                                            
           EXEC SQL                                                     
                SELECT CODE_REVENUE_CLASS,                              
                       RATE_PLAN_NO,                                    
                       TOU_RATE_IND                                     
                INTO :UT-CODE-REVENUE-CLASS,                            
                     :UT-RATE-PLAN-NO,                                  
                     :UT-TOU-RATE-IND                                   
                FROM CSS_UTIL_ENVRNMT                                   
                WHERE ACCOUNT_NO      = :UT-ACCOUNT-NO                  
                AND   IC_NO           = :UT-IC-NO                       
                AND   CODE_UTIL_TYPE  = :UT-CODE-UTIL-TYPE              
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                     11440000
MFA-TR*         SELECT CODE_REVENUE_CLASS,                              11450000
MFA-TR*                RATE_PLAN_NO,                                    11460000
MFA-TR*                TOU_RATE_IND                                     11470000
MFA-TR*         INTO :UT-CODE-REVENUE-CLASS,                            11480000
MFA-TR*              :UT-RATE-PLAN-NO,                                  11490000
MFA-TR*              :UT-TOU-RATE-IND                                   11500000
MFA-TR*         FROM CSS_UTIL_ENVRNMT                                   11510000
MFA-TR*         WHERE ACCOUNT_NO      = :UT-ACCOUNT-NO                  11520000
MFA-TR*         AND   IC_NO           = :UT-IC-NO                       11530000
MFA-TR*         AND   CODE_UTIL_TYPE  = :UT-CODE-UTIL-TYPE              11540000
MFA-TR*         QUERYNO 7210                                                    
MFA-TR*    END-EXEC.                                                    11550000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7210'              TO ACTIVE-PARAGRAPH              
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
              MOVE 'CSS_UTIL_ENVRNMT'  TO TABLE-1                       
              MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
              MOVE 'IC_NO'             TO TABLE-ELEMENT-2               
              MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-3               
              MOVE PARM-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1             
              MOVE UT-IC-NO            TO HOSTVAR-ELEMENT-2             
              MOVE UT-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-3             
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7215-SELECT-DEP-UTL-ENV.                                         
           EXEC SQL                                                     
                SELECT CODE_REVENUE_CLASS,                              
                       RATE_PLAN_NO                                     
                INTO :UT-CODE-REVENUE-CLASS,                            
                     :UT-RATE-PLAN-NO                                   
                FROM CSS_UTIL_ENVRNMT                                   
                WHERE ACCOUNT_NO      = :UR-ACCOUNT-NO-DEP              
                AND   IC_NO           = :UR-IC-NO-DEP                   
                AND   CODE_UTIL_TYPE  = :UR-CODE-UTIL-TYPE-DEP          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                     11440000
MFA-TR*         SELECT CODE_REVENUE_CLASS,                              11450000
MFA-TR*                RATE_PLAN_NO                                     11460000
MFA-TR*         INTO :UT-CODE-REVENUE-CLASS,                            11480000
MFA-TR*              :UT-RATE-PLAN-NO                                   11490000
MFA-TR*         FROM CSS_UTIL_ENVRNMT                                   11510000
MFA-TR*         WHERE ACCOUNT_NO      = :UR-ACCOUNT-NO-DEP              11520000
MFA-TR*         AND   IC_NO           = :UR-IC-NO-DEP                   11530000
MFA-TR*         AND   CODE_UTIL_TYPE  = :UR-CODE-UTIL-TYPE-DEP          11540000
MFA-TR*         QUERYNO 7215                                                    
MFA-TR*    END-EXEC.                                                    11550000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7215'              TO ACTIVE-PARAGRAPH              
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
              MOVE 'CSS_UTIL_ENVRNMT'  TO TABLE-1                       
              MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
              MOVE 'IC_NO'             TO TABLE-ELEMENT-2               
              MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-3               
              MOVE UR-ACCOUNT-NO-DEP   TO HOSTVAR-ELEMENT-1             
              MOVE UR-IC-NO-DEP        TO HOSTVAR-ELEMENT-2             
              MOVE UR-CODE-UTIL-TYPE-DEP                                
                                       TO HOSTVAR-ELEMENT-3             
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7215-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
       7220-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
                SELECT CUSTOMER_NO,                                     
                       CODE_ACCT_USAGE                                  
                INTO :AT-CUSTOMER-NO,                                   
                     :AT-CODE-ACCT-USAGE                                
                FROM CSS_ACCOUNT                                        
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                     11740000
MFA-TR*         SELECT CUSTOMER_NO,                                     11750000
MFA-TR*                CODE_ACCT_USAGE                                  11760000
MFA-TR*         INTO :AT-CUSTOMER-NO,                                   11770000
MFA-TR*              :AT-CODE-ACCT-USAGE                                11780000
MFA-TR*         FROM CSS_ACCOUNT                                        11790000
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       11800000
MFA-TR*         QUERYNO 7220                                                    
MFA-TR*    END-EXEC.                                                    11810000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
           OR WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7220'              TO ACTIVE-PARAGRAPH              
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
              MOVE 'CSS_ACCOUNT'       TO TABLE-1                       
              MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
              MOVE PARM-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1             
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7220-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7225-SELECT-NAME.                                                
           EXEC SQL                                                     
                SELECT DQ.FULL_NAME                                     
                      ,DQ.LAST_NAME                                     
                      ,DQ.FIRST_NAME                                    
                      ,DQ.MIDDLE_NAME                                   
                      ,DQ.NAME_FORMAT                                   
                INTO  :DQ-FULL-NAME                                     
                     ,:DQ-LAST-NAME                                     
                     ,:DQ-FIRST-NAME                                    
                     ,:DQ-MIDDLE-NAME                                   
                     ,:DQ-NAME-FORMAT                                   
                FROM  CSS_CUSTOMER CU WITH(READUNCOMMITTED)                     
                     ,CSS_NAME DQ WITH(READUNCOMMITTED)                         
                WHERE CU.CUSTOMER_NO = :CU-CUSTOMER-NO                  
                AND   CU.NAME_ID     = DQ.NAME_ID                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     12000000
MFA-TR*         SELECT DQ.FULL_NAME                                     12010000
MFA-TR*               ,DQ.LAST_NAME                                             
MFA-TR*               ,DQ.FIRST_NAME                                            
MFA-TR*               ,DQ.MIDDLE_NAME                                           
MFA-TR*               ,DQ.NAME_FORMAT                                           
MFA-TR*         INTO  :DQ-FULL-NAME                                     12020000
MFA-TR*              ,:DQ-LAST-NAME                                             
MFA-TR*              ,:DQ-FIRST-NAME                                            
MFA-TR*              ,:DQ-MIDDLE-NAME                                           
MFA-TR*              ,:DQ-NAME-FORMAT                                           
MFA-TR*         FROM  CSS_CUSTOMER CU                                   12030000
MFA-TR*              ,CSS_NAME DQ                                       12040000
MFA-TR*         WHERE CU.CUSTOMER_NO = :CU-CUSTOMER-NO                  12050000
MFA-TR*         AND   CU.NAME_ID     = DQ.NAME_ID                       12060000
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7225                                                    
MFA-TR*    END-EXEC.                                                    12070000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               MOVE SPACES              TO WS-FULL-NAME                 
               IF DQ-NAME-FORMAT = 'I'                                  
                  STRING DQ-LAST-NAME   DELIMITED BY SPACE              
                         ', '           DELIMITED BY SIZE               
                         DQ-FIRST-NAME  DELIMITED BY SPACE              
                         ' '            DELIMITED BY SIZE               
                         DQ-MIDDLE-NAME DELIMITED BY SPACE              
                    INTO WS-FULL-NAME                                   
               ELSE                                                     
                  MOVE DQ-FULL-NAME TO WS-FULL-NAME                     
               END-IF                                                   
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7225'              TO ACTIVE-PARAGRAPH              
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
              MOVE 'CSS_CUSTOMER'      TO TABLE-1                       
              MOVE 'CSS_NAME'          TO TABLE-2                       
              MOVE 'CUSTOMER_NO'       TO TABLE-ELEMENT-1               
              MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-2               
              MOVE CU-CUSTOMER-NO      TO HOSTVAR-ELEMENT-1             
              MOVE PARM-ACCOUNT-NO     TO HOSTVAR-ELEMENT-2             
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7225-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7230-SELECT-METERED-ENV.                                         
           EXEC SQL                                                     
                SELECT METER_NO                                         
                INTO :MN-METER-NO                                       
                FROM CSS_MTRD_ENVRNMT                                   
                WHERE ACCOUNT_NO    = :MN-ACCOUNT-NO                    
                AND CODE_UTIL_TYPE  = :MN-CODE-UTIL-TYPE                
                AND IC_NO           = :MN-IC-NO                         
                AND MTR_REF_NO      = :MN-MTR-REF-NO                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                     12250000
MFA-TR*         SELECT METER_NO                                         12260000
MFA-TR*         INTO :MN-METER-NO                                       12270000
MFA-TR*         FROM CSS_MTRD_ENVRNMT                                   12280000
MFA-TR*         WHERE ACCOUNT_NO    = :MN-ACCOUNT-NO                    12290000
MFA-TR*         AND CODE_UTIL_TYPE  = :MN-CODE-UTIL-TYPE                12300000
MFA-TR*         AND IC_NO           = :MN-IC-NO                         12310000
MFA-TR*         AND MTR_REF_NO      = :MN-MTR-REF-NO                    12320000
MFA-TR*         QUERYNO 7230                                                    
MFA-TR*    END-EXEC.                                                    12330000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7230'              TO ACTIVE-PARAGRAPH              
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
              MOVE 'CSS_MTRD_ENVRNMT'  TO TABLE-1                       
              MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
              MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-2               
              MOVE 'IC_NO'             TO TABLE-ELEMENT-3               
              MOVE 'MTR_REF_NO'        TO TABLE-ELEMENT-4               
              MOVE MN-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
              MOVE MN-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-2             
              MOVE MN-IC-NO            TO HOSTVAR-ELEMENT-3             
              MOVE MN-MTR-REF-NO       TO HOSTVAR-ELEMENT-4             
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
            END-IF.                                                     
                                                                        
       7230-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************  13340000
      * 7360-OPEN-MASTDEPREL                                         *  13350000
      ****************************************************************  13360000
      *                                                                 13370000
       7360-OPEN-MASTDEPREL.                                            
      *                                                                 13390000
           EXEC SQL                                                     
               OPEN MASTDEPREL-CURSOR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 13430000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 13450000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE '7360'              TO ACTIVE-PARAGRAPH              
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE 'OPEN'              TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
              MOVE 'CSS_UTL_BILL_REL'  TO TABLE-1                       
              MOVE 'ACCOUNT_NO_DEP'      TO TABLE-ELEMENT-1             
              MOVE 'CODE_UTIL_TYPE_DEP'  TO TABLE-ELEMENT-2             
              MOVE 'IC_NO_MST'           TO TABLE-ELEMENT-3             
              MOVE UR-ACCOUNT-NO-DEP     TO HOSTVAR-ELEMENT-1           
              MOVE UR-CODE-UTIL-TYPE-DEP TO HOSTVAR-ELEMENT-2           
              MOVE UR-IC-NO-DEP          TO HOSTVAR-ELEMENT-3           
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                 13570000
       7360-EXIT.                                                       
           EXIT.                                                        
      *                                                                 13600000
      ****************************************************************  13610000
      * 7370-FETCH-MASTDEPREL                                        *  13620000
      ****************************************************************  13630000
      *                                                                 13640000
       7370-FETCH-MASTDEPREL.                                           
      *                                                                 13660000
           EXEC SQL                                                     
               FETCH MASTDEPREL-CURSOR                                  
               INTO :UR-ACCOUNT-NO-DEP                                  
                   ,:UR-CODE-UTIL-TYPE-DEP                              
                   ,:UR-IC-NO-DEP                                       
                   ,:UR-MTR-REF-NO-DEP                                  
                   ,:UR-ACCOUNT-NO-MST                                  
                   ,:UR-CODE-UTIL-TYPE-MST                              
                   ,:UR-IC-NO-MST                                       
                   ,:UR-MTR-REF-NO-MST                                  
                   ,:UR-CODE-RELATION-TYPE                              
                   ,:UR-DEP-REL-START-DT                                
                   ,:UR-DEP-REL-END-DT                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 13730000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 13750000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                                   OR NOT-FOUND                         
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE '7370'              TO ACTIVE-PARAGRAPH              
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE 'FETCH'             TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
              MOVE 'CSS_UTL_BILL_REL'  TO TABLE-1                       
              MOVE 'ACCOUNT_NO_DEP'      TO TABLE-ELEMENT-1             
              MOVE 'CODE_UTIL_TYPE_DEP'  TO TABLE-ELEMENT-2             
              MOVE 'IC_NO_DEP'           TO TABLE-ELEMENT-3             
              MOVE UR-ACCOUNT-NO-DEP     TO HOSTVAR-ELEMENT-1           
              MOVE UR-CODE-UTIL-TYPE-DEP TO HOSTVAR-ELEMENT-2           
              MOVE UR-IC-NO-DEP          TO HOSTVAR-ELEMENT-3           
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                 13870000
       7370-EXIT.                                                       
           EXIT.                                                        
      *                                                                 13900000
      ****************************************************************  13910000
      * 7380-CLOSE-MASTDEPREL                                        *  13920000
      ****************************************************************  13930000
      *                                                                 13940000
       7380-CLOSE-MASTDEPREL.                                           
      *                                                                 13960000
            EXEC SQL                                                    
                CLOSE MASTDEPREL-CURSOR                                 
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 14000000
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
      *                                                                 14020000
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
                NEXT SENTENCE                                           
            ELSE                                                        
              MOVE '7380'              TO ACTIVE-PARAGRAPH              
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE 'CLOSE'             TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
              MOVE 'CSS_UTL_BILL_REL'  TO TABLE-1                       
              MOVE 'ACCOUNT_NO_DEP'      TO TABLE-ELEMENT-1             
              MOVE 'CODE_UTIL_TYPE_DEP'  TO TABLE-ELEMENT-2             
              MOVE 'IC_NO_MST'           TO TABLE-ELEMENT-3             
              MOVE UR-ACCOUNT-NO-DEP     TO HOSTVAR-ELEMENT-1           
              MOVE UR-CODE-UTIL-TYPE-DEP TO HOSTVAR-ELEMENT-2           
              MOVE UR-IC-NO-DEP          TO HOSTVAR-ELEMENT-3           
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
            END-IF.                                                     
      *                                                                 14140000
       7380-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
A05065****************************************************************  13340000
A05065* 7365-OPEN-MASTDEPRELIC                                       *  13350000
A05065****************************************************************  13360000
A05065*                                                                 13370000
A05065 7365-OPEN-MASTDEPRELIC.                                          
A05065*                                                                 13390000
A05065     EXEC SQL                                                     
A05065         OPEN MASTDEPRELIC-CURSOR                                 
A05065     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05065*                                                                 13430000
A05065     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A05065*                                                                 13450000
A05065     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A05065         NEXT SENTENCE                                            
A05065     ELSE                                                         
A05065        MOVE '7365'              TO ACTIVE-PARAGRAPH              
A05065        MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
A05065        MOVE 'OPEN'              TO ABEND-FUNCTION                
A05065        MOVE SPACES              TO ABEND-SQL-PREDICATES          
A05065                                    ABEND-TABLES                  
A05065        MOVE 'CSS_UTL_BILL_REL'  TO TABLE-1                       
A05065        MOVE 'ACCOUNT_NO_DEP'      TO TABLE-ELEMENT-1             
A05065        MOVE 'CODE_UTIL_TYPE_DEP'  TO TABLE-ELEMENT-2             
A05065        MOVE 'IC_NO_MST'           TO TABLE-ELEMENT-3             
A05065        MOVE UR-ACCOUNT-NO-DEP     TO HOSTVAR-ELEMENT-1           
A05065        MOVE UR-CODE-UTIL-TYPE-DEP TO HOSTVAR-ELEMENT-2           
A05065        MOVE UR-IC-NO-DEP          TO HOSTVAR-ELEMENT-3           
A05065        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
A05065     END-IF.                                                      
A05065*                                                                 13570000
A05065 7365-EXIT.                                                       
A05065     EXIT.                                                        
A05065*                                                                 13600000
A05065****************************************************************  13610000
A05065* 7375-FETCH-MASTDEPRELIC                                      *  13620000
A05065****************************************************************  13630000
A05065*                                                                 13640000
A05065 7375-FETCH-MASTDEPRELIC.                                         
A05065*                                                                 13660000
A05065     EXEC SQL                                                     
A05065         FETCH MASTDEPRELIC-CURSOR                                
A05065         INTO :UR-ACCOUNT-NO-DEP                                  
A05065             ,:UR-CODE-UTIL-TYPE-DEP                              
A05065             ,:UR-IC-NO-DEP                                       
A05065             ,:UR-MTR-REF-NO-DEP                                  
A05065             ,:UR-ACCOUNT-NO-MST                                  
A05065             ,:UR-CODE-UTIL-TYPE-MST                              
A05065             ,:UR-IC-NO-MST                                       
A05065             ,:UR-MTR-REF-NO-MST                                  
A05065             ,:UR-CODE-RELATION-TYPE                              
A05065             ,:UR-DEP-REL-START-DT                                
A05065             ,:UR-DEP-REL-END-DT                                  
A05065     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05065*                                                                 13730000
A05065     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A05065*                                                                 13750000
A05065     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A05065                             OR NOT-FOUND                         
A05065         NEXT SENTENCE                                            
A05065     ELSE                                                         
A05065        MOVE '7375'              TO ACTIVE-PARAGRAPH              
A05065        MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
A05065        MOVE 'FETCH'             TO ABEND-FUNCTION                
A05065        MOVE SPACES              TO ABEND-SQL-PREDICATES          
A05065                                    ABEND-TABLES                  
A05065        MOVE 'CSS_UTL_BILL_REL'  TO TABLE-1                       
A05065        MOVE 'ACCOUNT_NO_DEP'      TO TABLE-ELEMENT-1             
A05065        MOVE 'CODE_UTIL_TYPE_DEP'  TO TABLE-ELEMENT-2             
A05065        MOVE 'IC_NO_DEP'           TO TABLE-ELEMENT-3             
A05065        MOVE UR-ACCOUNT-NO-DEP     TO HOSTVAR-ELEMENT-1           
A05065        MOVE UR-CODE-UTIL-TYPE-DEP TO HOSTVAR-ELEMENT-2           
A05065        MOVE UR-IC-NO-DEP          TO HOSTVAR-ELEMENT-3           
A05065        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
A05065     END-IF.                                                      
A05065*                                                                 13870000
A05065 7375-EXIT.                                                       
A05065     EXIT.                                                        
A05065*                                                                 13900000
A05065****************************************************************  13910000
A05065* 7385-CLOSE-MASTDEPRELIC                                      *  13920000
A05065****************************************************************  13930000
A05065*                                                                 13940000
A05065 7385-CLOSE-MASTDEPRELIC.                                         
A05065*                                                                 13960000
A05065      EXEC SQL                                                    
A05065          CLOSE MASTDEPRELIC-CURSOR                               
A05065      END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05065*                                                                 14000000
A05065      MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
A05065*                                                                 14020000
A05065      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
A05065          NEXT SENTENCE                                           
A05065      ELSE                                                        
A05065        MOVE '7385'              TO ACTIVE-PARAGRAPH              
A05065        MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
A05065        MOVE 'CLOSE'             TO ABEND-FUNCTION                
A05065        MOVE SPACES              TO ABEND-SQL-PREDICATES          
A05065                                    ABEND-TABLES                  
A05065        MOVE 'CSS_UTL_BILL_REL'  TO TABLE-1                       
A05065        MOVE 'ACCOUNT_NO_DEP'      TO TABLE-ELEMENT-1             
A05065        MOVE 'CODE_UTIL_TYPE_DEP'  TO TABLE-ELEMENT-2             
A05065        MOVE 'IC_NO_MST'           TO TABLE-ELEMENT-3             
A05065        MOVE UR-ACCOUNT-NO-DEP     TO HOSTVAR-ELEMENT-1           
A05065        MOVE UR-CODE-UTIL-TYPE-DEP TO HOSTVAR-ELEMENT-2           
A05065        MOVE UR-IC-NO-DEP          TO HOSTVAR-ELEMENT-3           
A05065        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
A05065      END-IF.                                                     
A05065*                                                                 14140000
A05065 7385-EXIT.                                                       
A05065     EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7550-GET-RULE-XREF-ID                                          *        
      *                                                                *        
      ******************************************************************        
       7550-GET-RULE-XREF-ID.                                           
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           BUS_RULE_XREF_ID, 121), ' ', '-'), ':', '.') 
           BUS_RULE_XREF_ID                                   
                INTO :S-BUS-RULE-XREF-ID                                
                FROM CSS_BUS_RULE   [1R] WITH(READUNCOMMITTED)                  
                    ,CSS_BUS_RULE_XREF [1T] WITH(READUNCOMMITTED)               
               WHERE [1R].BUS_RULE_ID = :S-BUS-RULE-ID                    
                 AND [1R].BUS_RULE_ID = [1T].BUS_RULE_ID                    
                                             
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BUS_RULE_XREF_ID                                           
MFA-TR*         INTO :S-BUS-RULE-XREF-ID                                        
MFA-TR*         FROM CSS_BUS_RULE   1R                                          
MFA-TR*             ,CSS_BUS_RULE_XREF 1T                                       
MFA-TR*        WHERE 1R.BUS_RULE_ID = :S-BUS-RULE-ID                            
MFA-TR*          AND 1R.BUS_RULE_ID = 1T.BUS_RULE_ID                            
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7550                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
               MOVE SPACES                  TO ABEND-TABLES             
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
               MOVE '7550'                  TO ACTIVE-PARAGRAPH         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_BUS_RULE'          TO TABLE-1                  
               MOVE 'BUS_RULE_ID'           TO TABLE-ELEMENT-1          
               MOVE S-BUS-RULE-ID           TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************00000100
      * 8000A-DELETE-GTT-ROWS.                                         *00000200
      ******************************************************************00000300
       8000A-DELETE-GTT-ROWS.                                           
                                                                        
           MOVE                                                         
           'DELETE ROWS'                                                
               TO S-SQL-STATEMENT-V.                                    
                                                                        
            EXEC SQL                                                    
                DELETE FROM #CSR04657_R1                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    00001000
MFA-TR*         DELETE FROM SESSION.CSR04657_R1                         00001100
MFA-TR*     END-EXEC.                                                   00001200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
                NEXT SENTENCE                                           
            ELSE                                                        
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8000A'              TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04657_R1'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                 00003100
       8000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                 00003400
      ******************************************************************        
      *  DELETE SESSION TABLE - BUSINESS RULES                         *        
      ******************************************************************        
       8000B-DELETE-GTT-ROWS.                                           
                                                                        
            EXEC SQL                                                    
                DELETE                                                  
                  FROM #CSR04657_R2                              
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE                                                          
MFA-TR*           FROM SESSION.CSR04657_R2                                      
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.   
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE SQLCODE                 TO ABEND-SQLCODE            
               MOVE SQLSTATE                TO ABEND-SQLSTATE           
               MOVE '8000B'                 TO ACTIVE-PARAGRAPH         
               MOVE 'CSR04657_R2'           TO TABLE-1                  
               MOVE 'DELETE'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8000B-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8020-11SERT-GTT-R2.  BUSINESS RULES.                           *        
      ******************************************************************        
       8020-INSERT-GTT-R2.                                              
                                                                        
           EXEC SQL                                                     
               INSERT INTO #CSR04657_R2                          
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,BUS_RULE_ID                                          
                  ,BUS_RULE_RESULT_CD                                   
                  ,BUS_RULE_XREF_ID                                     
                 )                                                      
               VALUES                                                   
                 (                                                      
                   :S-RETURN-CODE-2                                     
                  ,:S-APPL-RETURN-CODE-2                                
                  ,:S-BUS-RULE-ID                                       
                  ,:S-BUS-RULE-RESULT-CD                                
                  ,:S-BUS-RULE-XREF-ID                                  
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO SESSION.CSR04657_R2                                  
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,BUS_RULE_ID                                                  
MFA-TR*           ,BUS_RULE_RESULT_CD                                           
MFA-TR*           ,BUS_RULE_XREF_ID                                             
MFA-TR*          )                                                              
MFA-TR*        VALUES                                                           
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-2                                             
MFA-TR*           ,:S-APPL-RETURN-CODE-2                                        
MFA-TR*           ,:S-BUS-RULE-ID                                               
MFA-TR*           ,:S-BUS-RULE-RESULT-CD                                        
MFA-TR*           ,:S-BUS-RULE-XREF-ID                                          
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R2 = 'Y'             
              ADD +1                        TO CTR-ROWS-RS2             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE '8020'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE 'Y'                      TO WS-ERR-INSRT-R2          
              MOVE 'CSR04657_R2'            TO TABLE-1                  
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
       8020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8100-SEND-RESULTS.                                            *         
      *****************************************************************         
       8100-SEND-RESULT.                                                
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04657_R1                            
             (                                                          
              RETURN_CODE                                               
             ,APPL_RETURN_CODE                                          
             ,ACCOUNT_NO_DEP                                            
             ,CODE_UTIL_TYPE_DEP                                        
             ,IC_NO_DEP                                                 
             ,MTR_REF_NO_DEP                                            
             ,DEP_REL_START_DT                                          
             ,DEP_REL_END_DT                                            
             ,ACCOUNT_NO_MST                                            
             ,CODE_UTIL_TYPE_MST                                        
             ,IC_NO_MST                                                 
             ,MTR_REF_NO_MST                                            
             ,CODE_RELATION_TYPE                                        
             ,CODE_REVENUE_CLASS                                        
             ,RATE_PLAN_NO                                              
             ,METER_NO_MST                                              
             ,METER_NO_DEP                                              
             ,ACCOUNT_NAME_MST                                          
             ,ACCOUNT_NAME_DEP                                          
             ,CODE_REV_CLASS_DEP                                        
             ,RATE_PLAN_NO_DEP                                          
             ,CODE_ACCT_USAGE                                           
             ,ERROR_MESSAGE                                             
             )                                                          
             VALUES                                                     
             (                                                          
              :S-RETURN-CODE-1                                          
             ,:S-APPL-RETURN-CODE-1                                     
             ,:S-ACCOUNT-NO-DEP                                         
             ,:S-CODE-UTIL-TYPE-DEP                                     
             ,:S-IC-NO-DEP                                              
             ,:S-MTR-REF-NO-DEP                                         
             ,:S-DEP-REL-START-DT                                       
             ,:S-DEP-REL-END-DT                                         
             ,:S-ACCOUNT-NO-MST                                         
             ,:S-CODE-UTIL-TYPE-MST                                     
             ,:S-IC-NO-MST                                              
             ,:S-MTR-REF-NO-MST                                         
             ,:S-CODE-RELATION-TYPE                                     
             ,:S-CODE-REVENUE-CLASS                                     
             ,:S-RATE-PLAN-NO                                           
             ,:S-METER-NO-MST                                           
             ,:S-METER-NO-DEP                                           
             ,:S-ACCOUNT-NAME-MST                                       
             ,:S-ACCOUNT-NAME-DEP                                       
             ,:S-DEP-CODE-REV-CLASS                                     
             ,:S-DEP-RATE-PLAN-NO                                       
             ,:S-CODE-ACCT-USAGE                                        
             ,:S-ERROR-MESSAGE                                          
             )                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04657_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,APPL_RETURN_CODE                                                  
MFA-TR*      ,ACCOUNT_NO_DEP                                                    
MFA-TR*      ,CODE_UTIL_TYPE_DEP                                                
MFA-TR*      ,IC_NO_DEP                                                         
MFA-TR*      ,MTR_REF_NO_DEP                                                    
MFA-TR*      ,DEP_REL_START_DT                                                  
MFA-TR*      ,DEP_REL_END_DT                                                    
MFA-TR*      ,ACCOUNT_NO_MST                                                    
MFA-TR*      ,CODE_UTIL_TYPE_MST                                                
MFA-TR*      ,IC_NO_MST                                                         
MFA-TR*      ,MTR_REF_NO_MST                                                    
MFA-TR*      ,CODE_RELATION_TYPE                                                
MFA-TR*      ,CODE_REVENUE_CLASS                                                
MFA-TR*      ,RATE_PLAN_NO                                                      
MFA-TR*      ,METER_NO_MST                                                      
MFA-TR*      ,METER_NO_DEP                                                      
MFA-TR*      ,ACCOUNT_NAME_MST                                                  
MFA-TR*      ,ACCOUNT_NAME_DEP                                                  
MFA-TR*      ,CODE_REV_CLASS_DEP                                                
MFA-TR*      ,RATE_PLAN_NO_DEP                                                  
MFA-TR*      ,CODE_ACCT_USAGE                                                   
MFA-TR*      ,ERROR_MESSAGE                                                     
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S-RETURN-CODE-1                                                  
MFA-TR*      ,:S-APPL-RETURN-CODE-1                                             
MFA-TR*      ,:S-ACCOUNT-NO-DEP                                                 
MFA-TR*      ,:S-CODE-UTIL-TYPE-DEP                                             
MFA-TR*      ,:S-IC-NO-DEP                                                      
MFA-TR*      ,:S-MTR-REF-NO-DEP                                                 
MFA-TR*      ,:S-DEP-REL-START-DT                                               
MFA-TR*      ,:S-DEP-REL-END-DT                                                 
MFA-TR*      ,:S-ACCOUNT-NO-MST                                                 
MFA-TR*      ,:S-CODE-UTIL-TYPE-MST                                             
MFA-TR*      ,:S-IC-NO-MST                                                      
MFA-TR*      ,:S-MTR-REF-NO-MST                                                 
MFA-TR*      ,:S-CODE-RELATION-TYPE                                             
MFA-TR*      ,:S-CODE-REVENUE-CLASS                                             
MFA-TR*      ,:S-RATE-PLAN-NO                                                   
MFA-TR*      ,:S-METER-NO-MST                                                   
MFA-TR*      ,:S-METER-NO-DEP                                                   
MFA-TR*      ,:S-ACCOUNT-NAME-MST                                               
MFA-TR*      ,:S-ACCOUNT-NAME-DEP                                               
MFA-TR*      ,:S-DEP-CODE-REV-CLASS                                             
MFA-TR*      ,:S-DEP-RATE-PLAN-NO                                               
MFA-TR*      ,:S-CODE-ACCT-USAGE                                                
MFA-TR*      ,:S-ERROR-MESSAGE                                                  
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R1 = 'Y'             
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8100'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'Y'                  TO WS-ERR-INSRT-R1              
              MOVE 'CSR04657_R1'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
           ADD 1 TO CTR-ROWS-RS1.                                       
      *                                                                         
       8100-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *****************************************************************         
      * 8800-CHECK-RESULTS.                                           *         
      *****************************************************************         
       8800-CHECK-RESULTS.                                              
                                                                        
           IF CTR-ROWS-RS1 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS                              
              MOVE 0                        TO S-RETURN-CODE-1          
              MOVE 100                      TO S-APPL-RETURN-CODE-1     
              PERFORM 8100-SEND-RESULT      THRU 8100-EXIT              
           END-IF.                                                      
                                                                        
           IF CTR-ROWS-RS2 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-2                            
              MOVE 0                        TO S-RETURN-CODE-2          
              MOVE 100                      TO S-APPL-RETURN-CODE-2     
              PERFORM 8020-INSERT-GTT-R2    THRU 8020-EXIT              
           END-IF.                                                      
                                                                        
       8800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8900-SEND-DONE.                                               *         
      *****************************************************************         
       8900-SEND-DONE.                                                  
                                                                        
           MOVE PROGRAM-NAME          TO ABEND-PROGRAM                  
           MOVE '8900'                TO ACTIVE-PARAGRAPH               
           MOVE 'OPEN'                TO ABEND-FUNCTION                 
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE 'CSR04657_R1'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C2                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE 'CSR04657_R2'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 9000-SEND-ERROR-RESULT.                                       *         
      *****************************************************************         
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE       TO ABEND-SQLCODE            
                                               S-RETURN-CODE-1          
                                               S-RETURN-CODE-2.         
                                                                        
           MOVE WS-APPL-RETURN-CODE         TO S-APPL-RETURN-CODE-1     
                                               S-APPL-RETURN-CODE-2.    
                                                                        
           MOVE SQLERRMC                    TO ABEND-SQLERRMC.          
                                                                        
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'               TO ABEND-FUNCTION           
           END-IF.                                                      
                                                                        
           IF WS-GTT01-DECLARED = 'N'                                   
              PERFORM 0100A-DECLARE-GTT-R1  THRU 0100A-EXIT             
           END-IF.                                                      
                                                                        
           IF WS-GTT02-DECLARED = 'N'                                   
              PERFORM 0100B-DECLARE-GTT-R2  THRU 0100B-EXIT             
           END-IF.                                                      
                                                                        
           PERFORM 8100-SEND-RESULT            THRU 8100-EXIT.          
           PERFORM 8020-INSERT-GTT-R2          THRU 8020-EXIT.          
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 9700-PROCESS-ABEND.                                           *         
      *****************************************************************         
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT      THRU 9000-EXIT.          
           PERFORM 9900-SQL-ERROR-ROUTINE      THRU 9900-EXIT.          
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************14820000
      * 9900 - JOURNALING / ERROR HANDLING ROUTINE                     *14830000
      ******************************************************************14840000
           EXEC SQL                                                     14850000
              INCLUDE CPDSP300                                          14860000
           END-EXEC.                                                    14870000
                                                                        
      ******************************************************************14890000
      *       END PROGRAM COPYLIB                                      *14900000
      ******************************************************************14910000
      *****************************************************************         
      * 9999-END-PROGRAM.                                             *         
      *****************************************************************         
       9999-END-PROGRAM.                                                
                                                                        
           PERFORM 8800-CHECK-RESULTS          THRU 8800-EXIT.          
           PERFORM 8900-SEND-DONE              THRU 8900-EXIT.          
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
      *    EXIT.                                                                
