       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04656.                                         
COB303 DATE-WRITTEN.  JULY 22, 2013.                                    
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------         
      *--                 SOUTH CAROLINA ELECTRIC & GAS              --         
      *----------------------------------------------------------------         
      *--                  STORED PROCEDURE:  CSR04656               --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--  CSR04656 :                                                --         
      *--                                                            --         
      *--   SP CALLED FROM METERING & RATE MAINTENANCE RATE FACTORS  --         
      *--   VIEW OF CIS PORTAL TO RETRIEVE ALL RATE FACTORS FOR THE  --         
      *--   ACCOUNT, UTILITY TYPE & IC COMBINATION.                  --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *--  PARAMETERS                                                --         
      *--                                                            --         
      *--      INPUT                                                 --         
      *--           ACCOUNT_NO              DECIMAL(13,0)            --         
      *--           CODE_UTIL_TYPE          CHAR(01)                 --         
      *--           IC_NO                   SMALLINT                 --         
      *--                                                            --         
      *--      OUT                                                   --         
      *--           NONE                                             --         
      *--                                                            --         
      *--      INOUT                                                 --         
      *--           NONE                                             --         
      *--                                                            --         
      *--  RESULT SET                                                --         
      *--      1. CSR04656_R1 - RATE FACTORS DATA.                   --         
      *--           RETURN_CODE             INTEGER                  --         
      *--           FACTOR_ID               CHAR(09)                 --         
      *--           FACTOR_TEXT             CHAR(20)                 --         
      *--           FACTOR_DESC             CHAR(60)                 --         
      *--           COMPONENT_ID            CHAR(02)                 --         
      *--           USE_CODE                CHAR(01)                 --         
      *--           TIME_PERIOD             CHAR(01)                 --         
      *--           BLOCK_NO                SMALLINT                 --         
      *--           SEASON                  CHAR(01)                 --         
      *--           VRSN_PRORATE            CHAR(01)                 --         
      *--           START_DATE              DATE                     --         
      *--           END_DATE                DATE                     --         
      *--           FACTOR                  DECIMAL(9,6)             --         
      *--           NXT_BILL_START          CHAR(10)                 --         
      *--           NXT_BILL_END            CHAR(10)                 --         
      *--           CODE_BILL_TYPE          CHAR(01)                 --         
      *--                                                            --         
      *--      2. CSR04656_R2 - BUSINESS RULES.                      --         
      *--           RETURN_CODE             INTEGER                  --         
      *--           BUS_RULE_ID             CHAR(10)                 --         
      *--           ACTION_TYPE_CD          CHAR(08)                 --         
      *--           BUS_RULE_XREF_ID        CHAR(26)                 --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                      MODIFICATION LOG                      --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
P00738*--  07/29/2013    SS97726     PROCEDURE ORIGINALLY CODED.     --         
      *----------------------------------------------------------------         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04656'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-START                          PIC X(40) VALUE             
            'WORKING STORAGE FOR CSR04656 STARTS HERE'.                 
      *                                                                         
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-SUBROUTINE-IDS.                                       
               10  CSRERLOG                 PIC X(8)  VALUE 'CSRERLOG'. 
           05  PROGRAM-NAME                 PIC X(08) VALUE 'CSR04656'. 
      *                                                                         
       01  PARM-FIELDS.                                                 
           05  PARM-L                       PIC S9(9) COMP.             
COB305     05 PARM-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.   
           05  PARM-CODE-UTIL-TYPE          PIC X(01).                  
           05  PARM-IC-NO                   PIC S9(4) COMP.             
      *                                                                         
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS-RS1                 PIC S9(9) COMP VALUE 0.     
           05  CTR-ROWS-RS2                 PIC S9(9) COMP VALUE 0.     
      *                                                                         
       01  WS-NULL-INDICATORS.                                          
           05  WS-NULL-IND-01               PIC S9(4) COMP.             
      *                                                                         
       01  WS-MISC.                                                     
           05  WS-YES                       PIC X(01) VALUE 'Y'.        
           05  WS-NO                        PIC X(01) VALUE 'N'.        
           05  WS-ACTIVE-CODE               PIC X(01) VALUE 'A'.        
           05  WS-SQLSTATE                  PIC X(05) VALUE SPACES.     
           05  WS-GTT-NAME                  PIC X(19) VALUE SPACES.     
           05  WS-GTT01-DECLARED            PIC X(01) VALUE 'N'.        
           05  WS-GTT02-DECLARED            PIC X(01) VALUE 'N'.        
           05  WS-DATE-RESULT               PIC X(10) VALUE SPACES.     
           05  WS-REVN-PRT-DT-FRM           PIC X(10) VALUE SPACES.     
           05  WS-OTHR-PRT-DT-FRM           PIC X(10) VALUE SPACES.     
           05  WS-REVN-PRT-DT-TO            PIC X(10) VALUE SPACES.     
           05  WS-OTHR-PRT-DT-TO            PIC X(10) VALUE SPACES.     
           05  WS-ADD-ONE-MTH               PIC X(10) VALUE SPACES.     
           05  WS-START-DATE.                                           
               10 WS-START-YR               PIC X(04) VALUE SPACES.     
               10 FILLER                    PIC X(01) VALUE '-'.        
               10 WS-START-MT               PIC X(02) VALUE SPACES.     
               10 FILLER                    PIC X(01) VALUE '-'.        
               10 WS-START-DY               PIC X(02) VALUE SPACES.     
           05  WS-REV-MTH-LST-NRML          PIC S9(6) VALUE ZEROES.     
           05  WS-REV-MTH-LST-NRML-C        PIC X(06) VALUE SPACES.     
           05  WS-NXT-BILL-START            PIC X(10) VALUE SPACES.     
           05  WS-NXT-BILL-END              PIC X(10) VALUE SPACES.     
           05  WS-REVENUE-MONTH             PIC X(06) VALUE SPACES.     
           05  WS-REVENUE-MONTH-N           PIC 9(06) VALUE ZEROES.     
           05  WS-TIME-PERIOD               PIC 9(01) VALUE ZEROES.     
      *                                                                         
       01  WS-SWITCHES.                                                 
           05  WS-NO-MORE-ROWS              PIC X(01) VALUE 'N'.        
               88 NO-MORE-ROWS                        VALUE 'Y'.        
           05  ALL-DONE-SW                  PIC X(01) VALUE 'N'.        
               88 NOT-ALL-DONE                        VALUE 'N'.        
               88 ALL-DONE                            VALUE 'Y'.        
           05  SEND-DONE-SW                 PIC X(01) VALUE 'Y'.        
               88 SEND-DONE-ERROR                     VALUE 'N'.        
               88 SEND-DONE-OK                        VALUE 'Y'.        
           05  WS-CNS-ROW-FOUND             PIC X(01) VALUE 'N'.        
               88 CNS-ROW-FOUND                       VALUE 'Y'.        
      *                                                                         
      ******************************************************************        
      *    ERROR PROCESSING VARIABLES                                  *        
      ******************************************************************        
      *                                                                         
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                    PIC X(18) VALUE SPACES.     
           10  S-SQLCODE                    PIC S9(9) COMP VALUE 0.     
           10  S-SQLSTATE                   PIC X(5)  VALUE ' '.        
           10  S-TABLE-NAME                 PIC X(18) VALUE SPACES.     
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L       PIC S9(4) USAGE COMP.       
               49  S-HOST-VARIABLES-V       PIC X(255).                 
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L        PIC S9(4) USAGE COMP.       
               49  S-SQL-STATEMENT-V        PIC X(255).                 
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L      PIC S9(4) USAGE COMP.       
               49  S-SQL-DESCRIPTION-V      PIC X(255).                 
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L      PIC S9(4) USAGE COMP.       
               49  WS-ABEND-SQLERRMC-V      PIC X(255).                 
      *                                                                         
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE               PIC S9(9) COMP VALUE 0.     
      *                                                                         
       01 GTT-RETURN-FIELDS.                                            
      ******************************************************************        
      *   GTT TABLE LAYOUT RATE FACTOR DATA.                           *        
      ******************************************************************        
          05  GTT-RETURN-FIELDS-1.                                      
              10  S-RETURN-CODE-1           PIC S9(9) COMP VALUE ZERO.  
              10  S-FACTOR-ID               PIC X(09) VALUE SPACES.     
              10  S-FACTOR-TEXT             PIC X(20) VALUE SPACES.     
              10  S-FACTOR-DESC             PIC X(60) VALUE SPACES.     
              10  S-COMPONENT-ID            PIC X(02) VALUE SPACES.     
              10  S-USE-CODE                PIC X(01) VALUE SPACES.     
              10  S-TIME-PERIOD             PIC X(01) VALUE SPACES.     
              10  S-BLOCK-NO                PIC S9(4) COMP VALUE ZERO.  
              10  S-SEASON                  PIC X(01) VALUE SPACES.     
              10  S-VRSN-PRORATE            PIC X(01) VALUE SPACES.     
              10  S-START-DATE              PIC X(10) VALUE SPACES.     
              10  S-END-DATE                PIC X(10) VALUE SPACES.     
              10  S-FACTOR                  PIC S9(9)V9(6) COMP-3       
                                                      VALUE ZERO.       
              10  S-NXT-BILL-START          PIC X(10) VALUE SPACES.     
              10  S-NXT-BILL-END            PIC X(10) VALUE SPACES.     
              10  S-CODE-BILL-TYPE          PIC X(01) VALUE SPACES.     
      *                                                                         
      ******************************************************************        
      *   GTT TABLE LAYOUT FOR BUSINESS RULES.                         *        
      ******************************************************************        
          05  GTT-RETURN-FIELDS-2.                                      
              10  S-RETURN-CODE-2           PIC S9(9) COMP VALUE ZERO.  
              10  S-BUS-RULE-ID             PIC X(10) VALUE SPACES.     
              10  S-ACTION-TYPE-CD          PIC X(08) VALUE SPACES.     
              10  S-BUS-RULE-XREF-ID        PIC X(26) VALUE SPACES.     
      *                                                                         
      ******************************************************************        
      *               COBOL WORKING STORAGE COPY BOOKS                 *        
      ******************************************************************        
      *                                                                         
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_ACCOUNT,        AT                                         *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_BILL_WINDOW,    BN                                         *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBBILWDW                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_READ_WINDOW,    RW                                         *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBRDWNDW                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_SPCL_FCTR,      SF                                         *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBSPLFTR                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_UTL_ENVRMNT,    UT                                         *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_SPCL_FCTR_APPL, SA                                         *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBSPLAPL                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_BILLING_DET,    BG                                         *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBBLLDET                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_BILLING_HDR,    BI                                         *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBBLLHDR                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_CNSMPTN_HIST,   CX                                         *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCNSMP                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_JOB_PARM,       G6                                         *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    ERROR HANDLING                                                       
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    SUPPORTS DB2 AND SQL ERROR CHECKING                         *        
      ******************************************************************        
      *                                                                         
           COPY CWS00303.                                                       
      *                                                                         
      ******************************************************************        
      *    CURSOR DECLARATIONS.                                        *        
      ******************************************************************        
      *                                                                         
      ******************************************************************        
      *    GET ALL RATE FACTORS ASSOCIATED FOR IC/UTILITY COMBINATION  *        
      ******************************************************************        
           EXEC SQL                                                     
               DECLARE RATE_FCTR CURSOR FOR                             
                 SELECT  SA.CMPNT_ID_CD                                 
                       , SA.CODE_SEASON                                 
                       , SA.INSTR_USE_TYPE_CD                           
                       , SA.CODE_TIME_PERIOD                            
                       , SA.CODE_REVENUE_CLASS                          
                       , SA.DATE_FROM                                   
                       , SA.DATE_TO                                     
                       , SA.FACTOR                                      
                       , SA.BLOCK_NO                                    
                       , SF.FACTOR_TYPE                                 
                       , SA.VERS_PRORATE_CD                             
                       , SF.FACTOR_TEXT                                 
                       , SF.FACTOR_DESC                                 
                       , SF.FACTOR_ID                                   
                   FROM  CSS_SPCL_FCTR_APPL SA WITH(READUNCOMMITTED)            
                       , CSS_SPCL_FCTR      SF WITH(READUNCOMMITTED)            
                  WHERE  SA.FACTOR_ID      = SF.FACTOR_ID               
                    AND  SA.CODE_UTIL_TYPE = :SA-CODE-UTIL-TYPE         
                    AND  SA.RATE_PLAN_NO   = :SA-RATE-PLAN-NO           
                    AND  SF.FACTOR_TYPE    = 'A'                        
                    AND  SA.CODE_STATUS    = 'A'                        
                  ORDER BY RATE_PLAN_NO                                 
                         , DATE_FROM DESC                               
               FOR READ ONLY                                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE RATE_FCTR CURSOR FOR                                     
MFA-TR*          SELECT  SA.CMPNT_ID_CD                                         
MFA-TR*                , SA.CODE_SEASON                                         
MFA-TR*                , SA.INSTR_USE_TYPE_CD                                   
MFA-TR*                , SA.CODE_TIME_PERIOD                                    
MFA-TR*                , SA.CODE_REVENUE_CLASS                                  
MFA-TR*                , SA.DATE_FROM                                           
MFA-TR*                , SA.DATE_TO                                             
MFA-TR*                , SA.FACTOR                                              
MFA-TR*                , SA.BLOCK_NO                                            
MFA-TR*                , SF.FACTOR_TYPE                                         
MFA-TR*                , SA.VERS_PRORATE_CD                                     
MFA-TR*                , SF.FACTOR_TEXT                                         
MFA-TR*                , SF.FACTOR_DESC                                         
MFA-TR*                , SF.FACTOR_ID                                           
MFA-TR*            FROM  CSS_SPCL_FCTR_APPL SA                                  
MFA-TR*                , CSS_SPCL_FCTR      SF                                  
MFA-TR*           WHERE  SA.FACTOR_ID      = SF.FACTOR_ID                       
MFA-TR*             AND  SA.CODE_UTIL_TYPE = :SA-CODE-UTIL-TYPE                 
MFA-TR*             AND  SA.RATE_PLAN_NO   = :SA-RATE-PLAN-NO                   
MFA-TR*             AND  SF.FACTOR_TYPE    = 'A'                                
MFA-TR*             AND  SA.CODE_STATUS    = 'A'                                
MFA-TR*           ORDER BY RATE_PLAN_NO                                         
MFA-TR*                  , DATE_FROM DESC                                       
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*        QUERYNO 7400                                                     
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       LINKAGE SECTION.                                                 
COB305 01 I-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.   
       01  I-CODE-UTIL-TYPE                 PIC X(01).                  
       01  I-IC-NO                          PIC S9(4) COMP.             
      *                                                                         
       PROCEDURE DIVISION USING I-ACCOUNT-NO                            
                                I-CODE-UTIL-TYPE                        
                                I-IC-NO.                                
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION         THRU 0100-EXIT.          
           PERFORM 1000-PROCESS-INPUT          THRU 1000-EXIT.          
           PERFORM 2000-BUILD-RESULT           THRU 2000-EXIT.          
           PERFORM 9999-END-PROGRAM            THRU 9999-EXIT.          
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 0100-INITIALIZATION.                                          *         
      *****************************************************************         
       0100-INITIALIZATION.                                             
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE 'N'                         TO WS-GTT01-DECLARED        
                                               WS-GTT02-DECLARED.       
           EXEC SQL                                                     
               WHENEVER SQLWARNING                                      
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLERROR                                        
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER NOT FOUND                                       
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1        THRU 0100A-EXIT.         
           PERFORM 0100B-DECLARE-GTT-R2        THRU 0100B-EXIT.         
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100A-DECLARE-GTT-R1 - RATE FACTOR DATA.                       *        
      ******************************************************************        
       0100A-DECLARE-GTT-R1.                                            
                                                                        
           MOVE 'SESSION.CSR04656_R1'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04656_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04656_R1
              (                                                      
                    RETURN_CODE             INT                     
                   ,FACTOR_ID CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,FACTOR_TEXT CHAR(20)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,FACTOR_DESC CHAR(60)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,COMPONENT_ID CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,USE_CODE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,TIME_PERIOD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BLOCK_NO                SMALLINT                    
                   ,SEASON CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2            
                   ,VRSN_PRORATE CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,START_DATE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,END_DATE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,FACTOR                  DECIMAL(9,6)                
                   ,NXT_BILL_START CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,NXT_BILL_END CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,CODE_BILL_TYPE CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                 )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS       THRU 8000A-EXIT          
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE 'Y'                   TO WS-GTT01-DECLARED        
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100A'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT           
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE           AS RETURN_CODE             
                      ,LTRIM(RTRIM(FACTOR_ID))      AS FACTOR_ID               
                      ,LTRIM(RTRIM(FACTOR_TEXT))    AS FACTOR_TEXT             
                      ,LTRIM(RTRIM(FACTOR_DESC))    AS FACTOR_DESC             
                      ,LTRIM(RTRIM(COMPONENT_ID))   AS COMPONENT_ID            
                      ,LTRIM(RTRIM(USE_CODE))       AS USE_CODE                
                      ,LTRIM(RTRIM(TIME_PERIOD))    AS TIME_PERIOD             
                      ,BLOCK_NO              AS BLOCK_NO                
                      ,LTRIM(RTRIM(SEASON))         AS SEASON                  
                      ,LTRIM(RTRIM(VRSN_PRORATE))   AS VRSN_PRORATE            
                      ,LTRIM(RTRIM(START_DATE))     AS START_DATE              
                      ,LTRIM(RTRIM(END_DATE))       AS END_DATE                
                      ,FACTOR                AS FACTOR                  
                      ,LTRIM(RTRIM(NXT_BILL_START)) AS NXT_BILL_START          
                      ,LTRIM(RTRIM(NXT_BILL_END))   AS NXT_BILL_END            
                      ,LTRIM(RTRIM(CODE_BILL_TYPE)) AS CODE_BILL_TYPE          
                  FROM #CSR04656_R1                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE           AS RETURN_CODE                     
MFA-TR*               ,STRIP(FACTOR_ID)      AS FACTOR_ID                       
MFA-TR*               ,STRIP(FACTOR_TEXT)    AS FACTOR_TEXT                     
MFA-TR*               ,STRIP(FACTOR_DESC)    AS FACTOR_DESC                     
MFA-TR*               ,STRIP(COMPONENT_ID)   AS COMPONENT_ID                    
MFA-TR*               ,STRIP(USE_CODE)       AS USE_CODE                        
MFA-TR*               ,STRIP(TIME_PERIOD)    AS TIME_PERIOD                     
MFA-TR*               ,BLOCK_NO              AS BLOCK_NO                        
MFA-TR*               ,STRIP(SEASON)         AS SEASON                          
MFA-TR*               ,STRIP(VRSN_PRORATE)   AS VRSN_PRORATE                    
MFA-TR*               ,STRIP(START_DATE)     AS START_DATE                      
MFA-TR*               ,STRIP(END_DATE)       AS END_DATE                        
MFA-TR*               ,FACTOR                AS FACTOR                          
MFA-TR*               ,STRIP(NXT_BILL_START) AS NXT_BILL_START                  
MFA-TR*               ,STRIP(NXT_BILL_END)   AS NXT_BILL_END                    
MFA-TR*               ,STRIP(CODE_BILL_TYPE) AS CODE_BILL_TYPE                  
MFA-TR*           FROM SESSION.CSR04656_R1                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 0100B-DECLARE-GTT-R2 - BUSINESS RULES                          *        
      ******************************************************************        
       0100B-DECLARE-GTT-R2.                                            
                                                                        
           MOVE 'SESSION.CSR04656_R2'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04656_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04656_R2
              (                                                      
                    RETURN_CODE             INT                     
                   ,BUS_RULE_ID CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,ACTION_TYPE_CD CHAR(08)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BUS_RULE_XREF_ID CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                 )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000B-DEL-GTT-ROWS       THRU 8000B-EXIT          
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE 'Y'                   TO WS-GTT02-DECLARED        
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100B'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT           
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C2 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE           AS RETURN_CODE             
                      ,BUS_RULE_ID           AS BUS_RULE_ID             
                      ,ACTION_TYPE_CD        AS ACTION_TYPE_CD          
                      ,BUS_RULE_XREF_ID      AS BUS_RULE_XREF_ID        
                  FROM #CSR04656_R2                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C2 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE           AS RETURN_CODE                     
MFA-TR*               ,BUS_RULE_ID           AS BUS_RULE_ID                     
MFA-TR*               ,ACTION_TYPE_CD        AS ACTION_TYPE_CD                  
MFA-TR*               ,BUS_RULE_XREF_ID      AS BUS_RULE_XREF_ID                
MFA-TR*           FROM SESSION.CSR04656_R2                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100B-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT.                                            *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE '1000'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           IF I-ACCOUNT-NO NOT NUMERIC                                  
              MOVE 0                        TO I-ACCOUNT-NO             
           END-IF.                                                      
                                                                        
           MOVE I-ACCOUNT-NO                TO PARM-ACCOUNT-NO.         
           MOVE I-CODE-UTIL-TYPE            TO PARM-CODE-UTIL-TYPE.     
           MOVE I-IC-NO                     TO PARM-IC-NO.              
                                                                        
           IF (PARM-ACCOUNT-NO     EQUAL ZEROS)                OR       
              (PARM-CODE-UTIL-TYPE EQUAL SPACES OR LOW-VALUES) OR       
              (PARM-IC-NO          EQUAL ZEROS)                         
              MOVE +100                     TO WS-ACTIVE-RETURN-CODE    
              MOVE 'PARM ERROR'             TO S-BUS-RULE-ID            
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
           MOVE PARM-ACCOUNT-NO             TO AT-ACCOUNT-NO            
                                               BG-ACCOUNT-NO            
                                               UT-ACCOUNT-NO.           
                                                                        
           MOVE PARM-CODE-UTIL-TYPE         TO BG-CODE-UTIL-TYPE        
                                               SA-CODE-UTIL-TYPE        
                                               UT-CODE-UTIL-TYPE.       
                                                                        
           MOVE PARM-IC-NO                  TO BG-IC-NO                 
                                               UT-IC-NO.                
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-BUILD-RESULT.                                             *        
      ******************************************************************        
       2000-BUILD-RESULT.                                               
                                                                        
           MOVE '2000'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           PERFORM 7000-SELECT-RATE-PLAN-NO    THRU 7000-EXIT.          
           MOVE UT-RATE-PLAN-NO             TO SA-RATE-PLAN-NO.         
                                                                        
           PERFORM 7050-GET-ACCOUNT-DTLS       THRU 7050-EXIT.          
           MOVE AT-REV-MTH-LST-NRML         TO WS-REV-MTH-LST-NRML      
                                               WS-REVENUE-MONTH-N.      
           MOVE WS-REV-MTH-LST-NRML         TO WS-REV-MTH-LST-NRML-C.   
           MOVE WS-REV-MTH-LST-NRML-C(1:4)  TO WS-START-YR.             
           MOVE WS-REV-MTH-LST-NRML-C(5:2)  TO WS-START-MT.             
           MOVE '01'                        TO WS-START-DY.             
                                                                        
           IF AT-REV-MTH-LST-NRML  EQUAL ZEROES                         
              MOVE 'COMMONDATE'             TO G6-PROGRAM-NAME          
              MOVE '01'                     TO G6-COMPANY-NO            
              MOVE 'CA00'                   TO G6-CMND-CODE             
              MOVE 0                        TO G6-SEQ-NO                
              PERFORM 7250-SELECT-JOB-PARM     THRU 7250-EXIT           
                                                                        
              MOVE G6-PARM-DATA(1:10)       TO BN-DATE-EXTRACT          
              MOVE AT-BILL-CYCLE            TO BN-BILL-CYCLE            
              PERFORM 7300-SELECT-BILL-WINDOW  THRU 7300-EXIT           
                                                                        
              IF BN-REVENUE-MONTH  EQUAL ZEROES AND                     
                 AT-CODE-ACCT-STAT EQUAL 'P'                            
                 MOVE UT-READ-CYCLE         TO BN-BILL-CYCLE            
                 PERFORM 7300-SELECT-BILL-WINDOW                        
                                               THRU 7300-EXIT           
              END-IF                                                    
                                                                        
              MOVE BN-REVENUE-MONTH         TO WS-REVENUE-MONTH         
                                               WS-REVENUE-MONTH-N       
              MOVE WS-REVENUE-MONTH(1:4)    TO WS-REVN-PRT-DT-FRM       
              MOVE '-'                      TO WS-REVN-PRT-DT-FRM(5:1)  
              MOVE WS-REVENUE-MONTH(5:2)    TO WS-REVN-PRT-DT-FRM(6:2)  
              MOVE '-'                      TO WS-REVN-PRT-DT-FRM(8:1)  
              MOVE '01'                     TO WS-REVN-PRT-DT-FRM(9:2)  
              MOVE WS-REVN-PRT-DT-FRM       TO WS-ADD-ONE-MTH           
                                               WS-START-DATE            
              PERFORM 7150-ADD-ONE-MONTH       THRU 7150-EXIT           
                                                                        
              MOVE WS-DATE-RESULT           TO WS-ADD-ONE-MTH           
              PERFORM 7200-SUB-ONE-DAY         THRU 7200-EXIT           
                                                                        
              MOVE WS-DATE-RESULT           TO WS-REVN-PRT-DT-TO        
           ELSE                                                         
              MOVE WS-START-DATE            TO WS-ADD-ONE-MTH           
              PERFORM 7150-ADD-ONE-MONTH       THRU 7150-EXIT           
                                                                        
              MOVE WS-DATE-RESULT           TO WS-REVN-PRT-DT-FRM       
                                               WS-ADD-ONE-MTH           
              PERFORM 7150-ADD-ONE-MONTH       THRU 7150-EXIT           
                                                                        
              MOVE WS-DATE-RESULT           TO WS-ADD-ONE-MTH           
              PERFORM 7200-SUB-ONE-DAY         THRU 7200-EXIT           
                                                                        
              MOVE WS-DATE-RESULT           TO WS-REVN-PRT-DT-TO        
           END-IF                                                       
                                                                        
           PERFORM 7100-SELECT-CNS-START-DATE  THRU 7100-EXIT.          
                                                                        
           IF CNS-ROW-FOUND                                             
              MOVE CX-DATE-READ             TO WS-OTHR-PRT-DT-FRM       
                                               WS-ADD-ONE-MTH           
              PERFORM 7150-ADD-ONE-MONTH       THRU 7150-EXIT           
                                                                        
              MOVE WS-DATE-RESULT           TO WS-ADD-ONE-MTH           
              PERFORM 7200-SUB-ONE-DAY         THRU 7200-EXIT           
                                                                        
              MOVE WS-DATE-RESULT           TO WS-OTHR-PRT-DT-TO        
           ELSE                                                         
              IF AT-CODE-ACCT-STAT NOT EQUAL 'P'                        
                 IF AT-REV-MTH-LST-NRML EQUAL ZEROES                    
                    MOVE WS-START-DATE      TO WS-ADD-ONE-MTH           
                                               WS-OTHR-PRT-DT-FRM       
                 ELSE                                                   
                    MOVE WS-START-DATE      TO WS-ADD-ONE-MTH           
                    PERFORM 7150-ADD-ONE-MONTH THRU 7150-EXIT           
                    MOVE WS-DATE-RESULT     TO WS-OTHR-PRT-DT-FRM       
                                               WS-ADD-ONE-MTH           
                 END-IF                                                 
                 PERFORM 7150-ADD-ONE-MONTH    THRU 7150-EXIT           
                                                                        
                 MOVE WS-DATE-RESULT        TO WS-ADD-ONE-MTH           
                 PERFORM 7200-SUB-ONE-DAY      THRU 7200-EXIT           
                                                                        
                 MOVE WS-DATE-RESULT        TO WS-OTHR-PRT-DT-TO        
              ELSE                                                      
                 MOVE UT-READ-CYCLE         TO RW-READ-CYCLE            
                 MOVE WS-REVENUE-MONTH-N    TO RW-REVENUE-MONTH         
                 PERFORM 7350-SELECT-OPT-READ-DATE                      
                                               THRU 7350-EXIT           
                                                                        
                 MOVE RW-OPTIMUM-READ-DATE  TO WS-ADD-ONE-MTH           
                                               WS-OTHR-PRT-DT-FRM       
                 PERFORM 7150-ADD-ONE-MONTH    THRU 7150-EXIT           
                                                                        
                 MOVE WS-DATE-RESULT        TO WS-ADD-ONE-MTH           
                 PERFORM 7200-SUB-ONE-DAY      THRU 7200-EXIT           
                                                                        
                 MOVE WS-DATE-RESULT        TO WS-OTHR-PRT-DT-TO        
              END-IF                                                    
           END-IF                                                       
                                                                        
           IF WS-REVN-PRT-DT-FRM < WS-OTHR-PRT-DT-FRM                   
              MOVE WS-REVN-PRT-DT-FRM       TO WS-NXT-BILL-START        
           ELSE                                                         
              MOVE WS-OTHR-PRT-DT-FRM       TO WS-NXT-BILL-START        
           END-IF.                                                      
                                                                        
           IF WS-REVN-PRT-DT-TO > WS-OTHR-PRT-DT-TO                     
              MOVE WS-REVN-PRT-DT-TO        TO WS-NXT-BILL-END          
           ELSE                                                         
              MOVE WS-OTHR-PRT-DT-TO        TO WS-NXT-BILL-END          
           END-IF.                                                      
                                                                        
           PERFORM 2050-SELECT-RATE-FCTRS      THRU 2050-EXIT.          
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2050-SELECT-RATE-FCTRS.                                        *        
      ******************************************************************        
       2050-SELECT-RATE-FCTRS.                                          
                                                                        
           MOVE '2050'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           MOVE 'N'                         TO WS-NO-MORE-ROWS.         
           PERFORM 7400-OPEN-RATE-FCTRS        THRU 7400-EXIT.          
           PERFORM 7450-FETCH-RATE-FCTRS       THRU 7450-EXIT.          
           PERFORM 2100-PROCESS-RATE-FCTRS     THRU 2100-EXIT           
                                               UNTIL NO-MORE-ROWS.      
           PERFORM 7500-CLOSE-RATE-FCTRS       THRU 7500-EXIT.          
                                                                        
       2050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2100-PROCESS-RATE-FCTRS.                                       *        
      ******************************************************************        
       2100-PROCESS-RATE-FCTRS.                                         
                                                                        
           MOVE '2100'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           IF SA-VERS-PRORATE-CD EQUAL 'R'                              
              IF SA-DATE-FROM >= WS-REVN-PRT-DT-FRM                     
                     AND ( SA-DATE-TO   <= WS-REVN-PRT-DT-TO            
                       OR( SA-DATE-FROM <= WS-REVN-PRT-DT-TO            
                         AND SA-DATE-TO  = '2999-12-31'))               
                 MOVE 'C'                   TO S-CODE-BILL-TYPE         
              ELSE                                                      
                 IF SA-DATE-FROM < WS-REVN-PRT-DT-FRM                   
                         AND SA-DATE-TO  > WS-REVN-PRT-DT-FRM           
                    MOVE 'C'                TO S-CODE-BILL-TYPE         
                 ELSE                                                   
                    MOVE 'X'                TO S-CODE-BILL-TYPE         
                 END-IF                                                 
              END-IF                                                    
           ELSE                                                         
              IF SA-DATE-FROM >= WS-OTHR-PRT-DT-FRM                     
                     AND ( SA-DATE-TO   <= WS-OTHR-PRT-DT-TO            
                       OR( SA-DATE-FROM <= WS-OTHR-PRT-DT-TO            
                         AND SA-DATE-TO  = '2999-12-31'))               
                 MOVE 'C'                   TO S-CODE-BILL-TYPE         
              ELSE                                                      
                 IF SA-DATE-FROM < WS-OTHR-PRT-DT-FRM                   
                         AND SA-DATE-TO  > WS-OTHR-PRT-DT-FRM           
                    MOVE 'C'                TO S-CODE-BILL-TYPE         
                 ELSE                                                   
                    MOVE 'X'                TO S-CODE-BILL-TYPE         
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
           MOVE +0                          TO S-RETURN-CODE-1.         
           MOVE SF-FACTOR-ID                TO S-FACTOR-ID.             
           MOVE SF-FACTOR-TEXT              TO S-FACTOR-TEXT.           
           MOVE SF-FACTOR-DESC              TO S-FACTOR-DESC.           
           MOVE SA-CMPNT-ID-CD              TO S-COMPONENT-ID.          
           MOVE SA-INSTR-USE-TYPE-CD        TO S-USE-CODE.              
           MOVE SA-CODE-TIME-PERIOD         TO WS-TIME-PERIOD.          
           MOVE WS-TIME-PERIOD              TO S-TIME-PERIOD.           
           MOVE SA-BLOCK-NO                 TO S-BLOCK-NO.              
           MOVE SA-CODE-SEASON              TO S-SEASON.                
           MOVE SA-VERS-PRORATE-CD          TO S-VRSN-PRORATE.          
           MOVE SA-DATE-FROM                TO S-START-DATE.            
           MOVE SA-DATE-TO                  TO S-END-DATE.              
           MOVE SA-FACTOR                   TO S-FACTOR.                
           MOVE WS-NXT-BILL-START           TO S-NXT-BILL-START.        
           MOVE WS-NXT-BILL-END             TO S-NXT-BILL-END.          
                                                                        
           PERFORM 8010-INSERT-GTT-R1          THRU 8010-EXIT.          
           PERFORM 7450-FETCH-RATE-FCTRS       THRU 7450-EXIT.          
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7000-SELECT-RATE-PLAN-NO.                                     *         
      *****************************************************************         
       7000-SELECT-RATE-PLAN-NO.                                        
                                                                        
           MOVE '7000'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
               SELECT  UT.RATE_PLAN_NO                                  
                     , UT.RT_PKG_OPT_SEQ_NO                             
                     , UT.READ_CYCLE                                    
                     , UT.RT_PKG_OPT_SEQ_NO                             
                 INTO :UT-RATE-PLAN-NO                                  
                     ,:UT-RT-PKG-OPT-SEQ-NO                             
                     ,:UT-READ-CYCLE                                    
                     ,:UT-RT-PKG-OPT-SEQ-NO                             
                 FROM  CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                
                WHERE  UT.ACCOUNT_NO     = :UT-ACCOUNT-NO               
                  AND  UT.IC_NO          = :UT-IC-NO                    
                  AND  UT.CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  UT.RATE_PLAN_NO                                          
MFA-TR*              , UT.RT_PKG_OPT_SEQ_NO                                     
MFA-TR*              , UT.READ_CYCLE                                            
MFA-TR*              , UT.RT_PKG_OPT_SEQ_NO                                     
MFA-TR*          INTO :UT-RATE-PLAN-NO                                          
MFA-TR*              ,:UT-RT-PKG-OPT-SEQ-NO                                     
MFA-TR*              ,:UT-READ-CYCLE                                            
MFA-TR*              ,:UT-RT-PKG-OPT-SEQ-NO                                     
MFA-TR*          FROM  CSS_UTIL_ENVRNMT UT                                      
MFA-TR*         WHERE  UT.ACCOUNT_NO     = :UT-ACCOUNT-NO                       
MFA-TR*           AND  UT.IC_NO          = :UT-IC-NO                            
MFA-TR*           AND  UT.CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE                   
MFA-TR*          WITH UR                                                        
MFA-TR*         QUERYNO 7000                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_UTIL_ENVRNMT'       TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-2          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-3          
              MOVE UT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE UT-IC-NO                 TO HOSTVAR-ELEMENT-2        
              MOVE UT-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7050-GET-ACCOUNT-DTLS.                                        *         
      *****************************************************************         
       7050-GET-ACCOUNT-DTLS.                                           
                                                                        
           MOVE '7050'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
               SELECT  AT.CODE_ACCT_STAT                                
                     , AT.REV_MTH_LST_NRML                              
                     , AT.BILL_CYCLE                                    
                 INTO :AT-CODE-ACCT-STAT                                
                     ,:AT-REV-MTH-LST-NRML                              
                     ,:AT-BILL-CYCLE                                    
                 FROM  CSS_ACCOUNT AT WITH(READUNCOMMITTED)                     
                WHERE  AT.ACCOUNT_NO = :AT-ACCOUNT-NO                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  AT.CODE_ACCT_STAT                                        
MFA-TR*              , AT.REV_MTH_LST_NRML                                      
MFA-TR*              , AT.BILL_CYCLE                                            
MFA-TR*          INTO :AT-CODE-ACCT-STAT                                        
MFA-TR*              ,:AT-REV-MTH-LST-NRML                                      
MFA-TR*              ,:AT-BILL-CYCLE                                            
MFA-TR*          FROM  CSS_ACCOUNT AT                                           
MFA-TR*         WHERE  AT.ACCOUNT_NO = :AT-ACCOUNT-NO                           
MFA-TR*          WITH UR                                                        
MFA-TR*         QUERYNO 7050                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_ACCOUNT'            TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7100-SELECT-CNS-START-DATE.                                   *         
      *****************************************************************         
       7100-SELECT-CNS-START-DATE.                                      
                                                                        
           MOVE '7100'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) CX.DATE_READ                                     
                 INTO :CX-DATE-READ                                     
                 FROM  CSS_CNSMPTN_HIST CX WITH(READUNCOMMITTED)                
                     , CSS_BILLING_HDR  BI WITH(READUNCOMMITTED)                
                     , CSS_BILLING_DET  BG WITH(READUNCOMMITTED)                
                WHERE  BG.ACCOUNT_NO         = :BG-ACCOUNT-NO           
                  AND  BG.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE       
                  AND  BG.IC_NO              = :BG-IC-NO                
                  AND  BG.REVENUE_MONTH      =  0                       
                  AND  BG.REV_MTH_ORIG_BILL  =  0                       
                  AND  BI.ACCOUNT_NO         =  BG.ACCOUNT_NO           
                  AND  BI.BILL_NO            =  BG.BILL_NO              
                  AND  BI.DATE_BILLED       IS  NULL                    
                  AND  CX.ACCOUNT_NO         =  BG.ACCOUNT_NO           
                  AND  CX.BILL_NO            =  BG.BILL_NO              
                  AND  CX.CODE_UTIL_TYPE     =  BG.CODE_UTIL_TYPE       
                  AND  CX.IC_NO              =  BG.IC_NO                
                  AND  CX.BILL_ITEM_TIMESTMP =  BG.BILL_ITEM_TIMESTMP   
                ORDER BY CX.DATE_READ ASC                               
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  CX.DATE_READ                                             
MFA-TR*          INTO :CX-DATE-READ                                             
MFA-TR*          FROM  CSS_CNSMPTN_HIST CX                                      
MFA-TR*              , CSS_BILLING_HDR  BI                                      
MFA-TR*              , CSS_BILLING_DET  BG                                      
MFA-TR*         WHERE  BG.ACCOUNT_NO         = :BG-ACCOUNT-NO                   
MFA-TR*           AND  BG.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE               
MFA-TR*           AND  BG.IC_NO              = :BG-IC-NO                        
MFA-TR*           AND  BG.REVENUE_MONTH      =  0                               
MFA-TR*           AND  BG.REV_MTH_ORIG_BILL  =  0                               
MFA-TR*           AND  BI.ACCOUNT_NO         =  BG.ACCOUNT_NO                   
MFA-TR*           AND  BI.BILL_NO            =  BG.BILL_NO                      
MFA-TR*           AND  BI.DATE_BILLED       IS  NULL                            
MFA-TR*           AND  CX.ACCOUNT_NO         =  BG.ACCOUNT_NO                   
MFA-TR*           AND  CX.BILL_NO            =  BG.BILL_NO                      
MFA-TR*           AND  CX.CODE_UTIL_TYPE     =  BG.CODE_UTIL_TYPE               
MFA-TR*           AND  CX.IC_NO              =  BG.IC_NO                        
MFA-TR*           AND  CX.BILL_ITEM_TIMESTMP =  BG.BILL_ITEM_TIMESTMP           
MFA-TR*         ORDER BY CX.DATE_READ ASC                                       
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*         QUERYNO 7100                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                 SET CNS-ROW-FOUND          TO TRUE                     
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_BILLING_DET'        TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE BG-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE BG-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE BG-IC-NO                 TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7150-ADD-ONE-MONTH.                                           *         
      *****************************************************************         
       7150-ADD-ONE-MONTH.                                              
                                                                        
           MOVE '7150'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
               SELECT
              DATEADD( MONTH, 1, IIF(TRY_CONVERT(DATE, :WS-ADD-ONE-MTH
              ) IS NULL OR (PATINDEX('%.%', :WS-ADD-ONE-MTH
              ) <> 0) OR (LEN(:WS-ADD-ONE-MTH) <> 10), CIS.CHAR2DATE(
                                                        :WS-ADD-ONE-MTH
              ), CONVERT(DATE, :WS-ADD-ONE-MTH) ) )
            INTO
              :WS-DATE-RESULT    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-DATE-RESULT = DATE(:WS-ADD-ONE-MTH) + 1 MONTH            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE '7150'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SET'                    TO ABEND-FUNCTION           
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'WS-ADD-ONE-MTH'         TO TABLE-ELEMENT-2          
              MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE WS-ADD-ONE-MTH           TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7200-SUB-ONE-DAY.                                             *         
      *****************************************************************         
       7200-SUB-ONE-DAY.                                                
                                                                        
           MOVE '7200'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
               SELECT
              DATEADD( DAY, -1, IIF(TRY_CONVERT(DATE, :WS-ADD-ONE-MTH
              ) IS NULL OR (PATINDEX('%.%', :WS-ADD-ONE-MTH
              ) <> 0) OR (LEN(:WS-ADD-ONE-MTH) <> 10), CIS.CHAR2DATE(
                                                        :WS-ADD-ONE-MTH
              ), CONVERT(DATE, :WS-ADD-ONE-MTH) ) )
            INTO
              :WS-DATE-RESULT      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-DATE-RESULT = DATE(:WS-ADD-ONE-MTH) - 1 DAY              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE '7160'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SET'                    TO ABEND-FUNCTION           
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'WS-ADD-ONE-MTH'         TO TABLE-ELEMENT-2          
              MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE WS-ADD-ONE-MTH           TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7250-SELECT-JOB-PARM.                                         *         
      *****************************************************************         
       7250-SELECT-JOB-PARM.                                            
                                                                        
           MOVE '7250'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
               SELECT  G6.PARM_DATA                                     
                 INTO :G6-PARM-DATA                                     
                 FROM  CSS_JOB_PARM G6 WITH(READUNCOMMITTED)                    
                WHERE  G6.PROGRAM_NAME = :G6-PROGRAM-NAME               
                  AND  G6.COMPANY_NO   = :G6-COMPANY-NO                 
                  AND  G6.CMND_CODE    = :G6-CMND-CODE                  
                  AND  G6.SEQ_NO       = :G6-SEQ-NO                     
                  AND  G6.STATUS       = 'A'                            
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  G6.PARM_DATA                                             
MFA-TR*          INTO :G6-PARM-DATA                                             
MFA-TR*          FROM  CSS_JOB_PARM G6                                          
MFA-TR*         WHERE  G6.PROGRAM_NAME = :G6-PROGRAM-NAME                       
MFA-TR*           AND  G6.COMPANY_NO   = :G6-COMPANY-NO                         
MFA-TR*           AND  G6.CMND_CODE    = :G6-CMND-CODE                          
MFA-TR*           AND  G6.SEQ_NO       = :G6-SEQ-NO                             
MFA-TR*           AND  G6.STATUS       = 'A'                                    
MFA-TR*          WITH UR                                                        
MFA-TR*         QUERYNO 7250                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_JOB_PARM'           TO TABLE-1                  
              MOVE 'PROGRAM_NAME'           TO TABLE-ELEMENT-1          
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-2          
              MOVE 'CMND_CODE'              TO TABLE-ELEMENT-3          
              MOVE 'SEQ_NO'                 TO TABLE-ELEMENT-4          
              MOVE G6-PROGRAM-NAME          TO HOSTVAR-ELEMENT-1        
              MOVE G6-COMPANY-NO            TO HOSTVAR-ELEMENT-2        
              MOVE G6-CMND-CODE             TO HOSTVAR-ELEMENT-3        
              MOVE G6-SEQ-NO                TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7300-SELECT-BILL-WINDOW.                                      *         
      *****************************************************************         
       7300-SELECT-BILL-WINDOW.                                         
                                                                        
           MOVE '7300'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
               SELECT  MIN(BN.REVENUE_MONTH)                            
                 INTO :BN-REVENUE-MONTH :WS-NULL-IND-01                  
                 FROM  CSS_BILL_WINDOW BN WITH(READUNCOMMITTED)                 
                WHERE  BN.DATE_EXTRACT  >= IIF(TRY_CONVERT(DATE, 
                                                       :BN-DATE-EXTRACT
              ) IS NULL OR (PATINDEX('%.%', :BN-DATE-EXTRACT
              ) <> 0) OR (LEN(:BN-DATE-EXTRACT) <> 10), CIS.CHAR2DATE(
                                                       :BN-DATE-EXTRACT
              ), CONVERT(DATE, :BN-DATE-EXTRACT) )             
                  AND  BN.BILL_CYCLE     = :BN-BILL-CYCLE               
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  MIN(BN.REVENUE_MONTH)                                    
MFA-TR*          INTO :BN-REVENUE-MONTH:WS-NULL-IND-01                          
MFA-TR*          FROM  CSS_BILL_WINDOW BN                                       
MFA-TR*         WHERE  BN.DATE_EXTRACT  >= :BN-DATE-EXTRACT                     
MFA-TR*           AND  BN.BILL_CYCLE     = :BN-BILL-CYCLE                       
MFA-TR*          WITH UR                                                        
MFA-TR*         QUERYNO 7300                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF WS-NULL-IND-01 EQUAL -1                                
                 MOVE ZEROES                TO BN-REVENUE-MONTH         
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_BILL_WINDOW'        TO TABLE-1                  
              MOVE 'DATE_EXTRACT'           TO TABLE-ELEMENT-1          
              MOVE 'BILL_CYCLE'             TO TABLE-ELEMENT-2          
              MOVE BN-DATE-EXTRACT          TO HOSTVAR-ELEMENT-1        
              MOVE BN-BILL-CYCLE            TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7350-SELECT-OPT-READ-DATE.                                    *         
      *****************************************************************         
       7350-SELECT-OPT-READ-DATE.                                       
                                                                        
           MOVE '7350'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
               SELECT  RW.OPTIMUM_READ_DATE                             
                 INTO :RW-OPTIMUM-READ-DATE                             
                 FROM  CSS_READ_WINDOW RW WITH(READUNCOMMITTED)                 
                WHERE  RW.READ_CYCLE    = :RW-READ-CYCLE                
                  AND  RW.REVENUE_MONTH = :RW-REVENUE-MONTH             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  RW.OPTIMUM_READ_DATE                                     
MFA-TR*          INTO :RW-OPTIMUM-READ-DATE                                     
MFA-TR*          FROM  CSS_READ_WINDOW RW                                       
MFA-TR*         WHERE  RW.READ_CYCLE    = :RW-READ-CYCLE                        
MFA-TR*           AND  RW.REVENUE_MONTH = :RW-REVENUE-MONTH                     
MFA-TR*          WITH UR                                                        
MFA-TR*         QUERYNO 7350                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_READ_WINDOW'        TO TABLE-1                  
              MOVE 'READ_CYCLE'             TO TABLE-ELEMENT-1          
              MOVE 'RW.REVENUE_MONTH'       TO TABLE-ELEMENT-2          
              MOVE RW-READ-CYCLE            TO HOSTVAR-ELEMENT-1        
              MOVE RW-REVENUE-MONTH         TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7350-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7400-OPEN-RATE-FCTRS.                                         *         
      *****************************************************************         
       7400-OPEN-RATE-FCTRS.                                            
                                                                        
           MOVE '7400'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
               OPEN RATE_FCTR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE 'CSS_SPCL_FCTR_APPL'     TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'RATE_PLAN_NO'           TO TABLE-ELEMENT-2          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-3          
              MOVE PARM-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1        
              MOVE SA-RATE-PLAN-NO          TO HOSTVAR-ELEMENT-2        
              MOVE SA-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7450-FETCH-RATE-FCTRS.                                        *         
      *****************************************************************         
       7450-FETCH-RATE-FCTRS.                                           
                                                                        
           MOVE '7450'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
               FETCH  RATE_FCTR                                         
                INTO :SA-CMPNT-ID-CD                                    
                    ,:SA-CODE-SEASON                                    
                    ,:SA-INSTR-USE-TYPE-CD                              
                    ,:SA-CODE-TIME-PERIOD                               
                    ,:SA-CODE-REVENUE-CLASS                             
                    ,:SA-DATE-FROM                                      
                    ,:SA-DATE-TO                                        
                    ,:SA-FACTOR                                         
                    ,:SA-BLOCK-NO                                       
                    ,:SF-FACTOR-TYPE                                    
                    ,:SA-VERS-PRORATE-CD                                
                    ,:SF-FACTOR-TEXT                                    
                    ,:SF-FACTOR-DESC                                    
                    ,:SF-FACTOR-ID                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE 'Y'                   TO WS-NO-MORE-ROWS          
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'FETCH'                  TO ABEND-FUNCTION           
              MOVE 'CSS_SPCL_FCTR_APPL'     TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'RATE_PLAN_NO'           TO TABLE-ELEMENT-2          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-3          
              MOVE PARM-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1        
              MOVE SA-RATE-PLAN-NO          TO HOSTVAR-ELEMENT-2        
              MOVE SA-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7450-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7500-CLOSE-RATE-FCTRS.                                        *         
      *****************************************************************         
       7500-CLOSE-RATE-FCTRS.                                           
                                                                        
           MOVE '7500'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
               CLOSE RATE_FCTR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE 'CSS_SPCL_FCTR_APPL'     TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'RATE_PLAN_NO'           TO TABLE-ELEMENT-2          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-3          
              MOVE PARM-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1        
              MOVE SA-RATE-PLAN-NO          TO HOSTVAR-ELEMENT-2        
              MOVE SA-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8000A-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000A-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04656_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04656_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000A'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04656_R1'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       8000A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      * 8000B-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000B-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04656_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04656_R2                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000B'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04656_R2'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       8000B-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 8010-INSERT-GTT-R1. RATE FACTORS DATA.                         *        
      ******************************************************************        
       8010-INSERT-GTT-R1.                                              
                                                                        
           EXEC SQL                                                     
               INSERT INTO #CSR04656_R1                          
                 (                                                      
                   RETURN_CODE                                          
                  ,FACTOR_ID                                            
                  ,FACTOR_TEXT                                          
                  ,FACTOR_DESC                                          
                  ,COMPONENT_ID                                         
                  ,USE_CODE                                             
                  ,TIME_PERIOD                                          
                  ,BLOCK_NO                                             
                  ,SEASON                                               
                  ,VRSN_PRORATE                                         
                  ,START_DATE                                           
                  ,END_DATE                                             
                  ,FACTOR                                               
                  ,NXT_BILL_START                                       
                  ,NXT_BILL_END                                         
                  ,CODE_BILL_TYPE                                       
                 )                                                      
               VALUES                                                   
                 (                                                      
                   :S-RETURN-CODE-1                                     
                  ,:S-FACTOR-ID                                         
                  ,:S-FACTOR-TEXT                                       
                  ,:S-FACTOR-DESC                                       
                  ,:S-COMPONENT-ID                                      
                  ,:S-USE-CODE                                          
                  ,:S-TIME-PERIOD                                       
                  ,:S-BLOCK-NO                                          
                  ,:S-SEASON                                            
                  ,:S-VRSN-PRORATE                                      
                  ,:S-START-DATE                                        
                  ,:S-END-DATE                                          
                  ,:S-FACTOR                                            
                  ,:S-NXT-BILL-START                                    
                  ,:S-NXT-BILL-END                                      
                  ,:S-CODE-BILL-TYPE                                    
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO SESSION.CSR04656_R1                                  
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,FACTOR_ID                                                    
MFA-TR*           ,FACTOR_TEXT                                                  
MFA-TR*           ,FACTOR_DESC                                                  
MFA-TR*           ,COMPONENT_ID                                                 
MFA-TR*           ,USE_CODE                                                     
MFA-TR*           ,TIME_PERIOD                                                  
MFA-TR*           ,BLOCK_NO                                                     
MFA-TR*           ,SEASON                                                       
MFA-TR*           ,VRSN_PRORATE                                                 
MFA-TR*           ,START_DATE                                                   
MFA-TR*           ,END_DATE                                                     
MFA-TR*           ,FACTOR                                                       
MFA-TR*           ,NXT_BILL_START                                               
MFA-TR*           ,NXT_BILL_END                                                 
MFA-TR*           ,CODE_BILL_TYPE                                               
MFA-TR*          )                                                              
MFA-TR*        VALUES                                                           
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-1                                             
MFA-TR*           ,:S-FACTOR-ID                                                 
MFA-TR*           ,:S-FACTOR-TEXT                                               
MFA-TR*           ,:S-FACTOR-DESC                                               
MFA-TR*           ,:S-COMPONENT-ID                                              
MFA-TR*           ,:S-USE-CODE                                                  
MFA-TR*           ,:S-TIME-PERIOD                                               
MFA-TR*           ,:S-BLOCK-NO                                                  
MFA-TR*           ,:S-SEASON                                                    
MFA-TR*           ,:S-VRSN-PRORATE                                              
MFA-TR*           ,:S-START-DATE                                                
MFA-TR*           ,:S-END-DATE                                                  
MFA-TR*           ,:S-FACTOR                                                    
MFA-TR*           ,:S-NXT-BILL-START                                            
MFA-TR*           ,:S-NXT-BILL-END                                              
MFA-TR*           ,:S-CODE-BILL-TYPE                                            
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                        TO CTR-ROWS-RS1             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8010'                   TO ACTIVE-PARAGRAPH         
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSR04656_R1'            TO TABLE-1                  
              MOVE SPACES                   TO TABLE-ELEMENT-1          
              MOVE SPACES                   TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8020-INSERT-GTT-R2.  BUSINESS RULES.                           *        
      ******************************************************************        
       8020-INSERT-GTT-R2.                                              
                                                                        
           EXEC SQL                                                     
               INSERT INTO #CSR04656_R2                          
                 (                                                      
                   RETURN_CODE                                          
                  ,BUS_RULE_ID                                          
                  ,ACTION_TYPE_CD                                       
                  ,BUS_RULE_XREF_ID                                     
                 )                                                      
               VALUES                                                   
                 (                                                      
                   :S-RETURN-CODE-2                                     
                  ,:S-BUS-RULE-ID                                       
                  ,:S-ACTION-TYPE-CD                                    
                  ,:S-BUS-RULE-XREF-ID                                  
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO SESSION.CSR04656_R2                                  
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,BUS_RULE_ID                                                  
MFA-TR*           ,ACTION_TYPE_CD                                               
MFA-TR*           ,BUS_RULE_XREF_ID                                             
MFA-TR*          )                                                              
MFA-TR*        VALUES                                                           
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-2                                             
MFA-TR*           ,:S-BUS-RULE-ID                                               
MFA-TR*           ,:S-ACTION-TYPE-CD                                            
MFA-TR*           ,:S-BUS-RULE-XREF-ID                                          
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                        TO CTR-ROWS-RS2             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8020'                   TO ACTIVE-PARAGRAPH         
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSR04656_R2'            TO TABLE-1                  
              MOVE SPACES                   TO TABLE-ELEMENT-1          
              MOVE SPACES                   TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8800-CHECK-RESULTS.                                           *         
      *****************************************************************         
       8800-CHECK-RESULTS.                                              
                                                                        
           IF CTR-ROWS-RS1 <= 0                                         
              INITIALIZE                       GTT-RETURN-FIELDS-1      
              MOVE   0                      TO S-RETURN-CODE-1          
              PERFORM 8010-INSERT-GTT-R1       THRU 8010-EXIT           
           END-IF.                                                      
                                                                        
           IF CTR-ROWS-RS2 <= 0                                         
              INITIALIZE                       GTT-RETURN-FIELDS-2      
              MOVE   0                      TO S-RETURN-CODE-2          
              PERFORM 8020-INSERT-GTT-R2       THRU 8020-EXIT           
           END-IF.                                                      
                                                                        
       8800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8900-SEND-DONE.                                               *         
      *****************************************************************         
       8900-SEND-DONE.                                                  
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           EXEC SQL                                                     
               OPEN C2                                                  
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
                                                    
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 9000-SEND-ERROR-RESULT.                                       *         
      *****************************************************************         
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE       TO ABEND-SQLCODE            
                                               S-RETURN-CODE-1          
                                               S-RETURN-CODE-2.         
                                                                        
           MOVE SQLERRMC                    TO ABEND-SQLERRMC.          
                                                                        
           IF WS-GTT01-DECLARED = 'N'                                   
              PERFORM 0100A-DECLARE-GTT-R1     THRU 0100A-EXIT          
           END-IF.                                                      
                                                                        
           IF WS-GTT02-DECLARED = 'N'                                   
              PERFORM 0100B-DECLARE-GTT-R2     THRU 0100B-EXIT          
           END-IF.                                                      
                                                                        
           PERFORM 8010-INSERT-GTT-R1          THRU 8010-EXIT.          
           PERFORM 8020-INSERT-GTT-R2          THRU 8020-EXIT.          
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 9700-PROCESS-ABEND.                                           *         
      *****************************************************************         
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT      THRU 9000-EXIT.          
           PERFORM 9900-SQL-ERROR-ROUTINE      THRU 9900-EXIT.          
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 9900-SQL-ERROR-ROUTINE.                                       *         
      *****************************************************************         
       9900-SQL-ERROR-ROUTINE.                                          

MSQ002     EXEC SQL
MSQ002         SELECT LTRIM(RTRIM(CASE                                          
                        WHEN :TABLE-ELEMENT-1 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-1)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-1))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-2 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-2)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-2))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-3 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-3)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-3))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-4 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-4)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-4))                    
                        ELSE                                            
                           ''                                           
                     END))
MSQ002              , :ABEND-FUNCTION
MSQ002              , 'PARAGRAPH-' + LTRIM(RTRIM(:ACTIVE-PARAGRAPH)) + 
           ',' + 'TABLES-' + LTRIM(RTRIM(:TABLE-2)) + ',' + 
           LTRIM(RTRIM(:TABLE-3)) + ',' + LTRIM(RTRIM(:TABLE-4)) + 
           ',' + 'ERRMSG-' + LTRIM(RTRIM(:ABEND-SQLERRMC))
MSQ002           INTO :MFA-CSRERLOG.ARG-5
MSQ002              , :MFA-CSRERLOG.ARG-6
MSQ002              , :MFA-CSRERLOG.ARG-7
MSQ002     END-EXEC
                                                                        
           EXEC SQL                                                     
               CALL CSRERLOG ( :ABEND-PROGRAM
                  , :ABEND-SQLCODE
                  , :ABEND-SQLSTATE
                  , :TABLE-1
                  , :MFA-CSRERLOG.ARG-5
                  , :MFA-CSRERLOG.ARG-6
                  , :MFA-CSRERLOG.ARG-7
                  )                                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ002
MFA-TR*    EXEC SQL                                                             
MFA-TR*        CALL CSRERLOG (                                                  
MFA-TR*             :ABEND-PROGRAM,                                             
MFA-TR*             :ABEND-SQLCODE,                                             
MFA-TR*             :ABEND-SQLSTATE,                                            
MFA-TR*             :TABLE-1,                                                   
MFA-TR*              VARCHAR(STRIP(                                             
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-1 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-1) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-1)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-2 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-2) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-2)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-3 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-3) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-3)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-4 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-4) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-4)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END                                                        
MFA-TR*              )),                                                        
MFA-TR*              VARCHAR(:ABEND-FUNCTION),                                  
MFA-TR*              VARCHAR(                                                   
MFA-TR*              'PARAGRAPH-' CONCAT STRIP(:ACTIVE-PARAGRAPH) CONCAT        
MFA-TR*              ',' CONCAT 'TABLES-' CONCAT STRIP(:TABLE-2) CONCAT         
MFA-TR*              ',' CONCAT STRIP(:TABLE-3) CONCAT                          
MFA-TR*              ',' CONCAT STRIP(:TABLE-4) CONCAT                          
MFA-TR*              ',' CONCAT 'ERRMSG-' CONCAT STRIP(:ABEND-SQLERRMC)         
MFA-TR*              )                                                          
MFA-TR*             )                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           PERFORM 8900-SEND-DONE              THRU 8900-EXIT.          
           
MSQ016        GOBACK.                                                    
                                                                        
       9900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 9999-END-PROGRAM.                                             *         
      *****************************************************************         
       9999-END-PROGRAM.                                                
                                                                        
           PERFORM 8800-CHECK-RESULTS          THRU 8800-EXIT.          
           PERFORM 8900-SEND-DONE              THRU 8900-EXIT.          
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
