       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04655.                                         
COB303 DATE-WRITTEN.                                                    
COB303         OCTOBER 28, 2013.                                        
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM INSERTS, DELETES, OR UPDATES FIXED FACTORS.      *        
      *  CLONE LOGIC FROM CSR02289 & CSR04158.                         *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  10/28/13    DMS      INITIAL VERSION.                         *        
      *                                                                *        
P00805*  02/26/14  AD7F921    ADDED CSS_REG_PROFILE TABLE CHECK FOR    *        
P00805*                       ACCOUNTS TO CHECK THE DURATION REMAINING *        
P00805*                       LIMIT FOR CHANGING THE ACCOUNT STATUS    *        
P00805*                       TO 'O'.FOR DEREG ACCOUNT LIMIT =2.       *        
A05065*  11/21/14  AD7F921    ADDED FACTOR-ID IN TRANSACTION HISTORY   *        
A05065*                       and updated the transaction header comment        
A05065*                       WITH UTILITY CODE,IC NO AND FACTOR-ID    *        
A05065*                       FOR dEFECT# 6088.                        *        
ACT006*  02/20/15  VIJAY      ADD DF.STATUS_CHANGE_DT = CURRENT DATE   *        
ACT006*    A05094             DURING OPEN RENEWAL STATUS UPDATES.               
ACT004*  06/02/16  TP7R341    REMOVE UNWANTED COLUMNS FROM TABLE       *        
ACT004*    A04177             CSS_SPCL_FCTR                       *             
      ******************************************************************        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04655'.
MSQ017     COPY MFASQLM.
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ACCOUNT          AT                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_FIXED_FCTR       FF                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBFXDFCT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_SPCL_FCTR        SF                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBSPLFTR                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_USER_PROFILE     PF                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_RESP_AREA        C1                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRSAREA                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_MT_TRN_HST_DET   MI                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_MNT_TRANS_HIST   MH                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_UTIL_ENVRNMT     UT                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_PRICE_SCHED      PS                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBPRCSCH                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_DELINQUENCY      C8                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_RATE_PLAN_DESC   RD                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRTDESC                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_BILLING_DET      BG                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBBLLDET                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CRM_OPT_ATTR_INCTV   HQ                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBOPTATT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CRM_RT_PKG_OPTION    FI                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRTPKGO                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ACCT_RTPK_AGR    DF                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBACCTRG                                                  
           END-EXEC.                                                            
                                                                        
A05065******************************************************************01230100
A05065*    CSS_CODE_VALUE       UV                                     *01230200
A05065******************************************************************01230300
A05065     EXEC SQL                                                     01230400
A05065        INCLUDE TBCDVALU                                          01230500
A05065     END-EXEC.                                                    01230600
A05065                                                                  
      ******************************************************************        
      *    CSS_BILL_WINDOW      BN                                     *        
      ******************************************************************        
           EXEC SQL                                                             
             INCLUDE TBBILWDW                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_BUS_RULE_XREF    1T                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRULXRF                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_BUS_RULE         1R                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBBUSRUL                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_BUS_RULE_ACTN    1S                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRULACT                                                  
           END-EXEC.                                                            
                                                                        
P00805******************************************************************        
P00805* CSS_REG_PROFILE,    LR                                                  
P00805******************************************************************        
P00805     EXEC SQL                                                             
P00805       INCLUDE TBREGPRF                                                   
P00805     END-EXEC.                                                            
P00805*                                                                         
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
           COPY CWS00027.                                                       
           COPY CWS00303.                                                       
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS00013                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    WORKING STORAGE SUPPORT FOR CPD00065                        *        
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE CWS00065                                                
           END-EXEC.                                                            
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
       01  PARM-FIELDS.                                                 
           05  PARM-ACTION-TYPE        PIC X(01)  VALUE SPACES.         
           05  PARM-USERID             PIC X(07)  VALUE SPACES.         
           05  PARM-ACCOUNT-NO         PIC X(13).                       
           05  PARM-CODE-UTIL-TYPE     PIC X(01)  VALUE SPACES.         
           05  PARM-IC-NO              PIC S9(04) USAGE COMP.           
           05  PARM-FACTOR-ID          PIC X(09).                       
           05  PARM-FACTOR             PIC X(16).                       
           05  PARM-BLOCK-NO           PIC X(04).                       
           05  PARM-FXD-FCTR-SEQ-NO    PIC X(04).                       
           05  PARM-DATE-FROM          PIC X(10).                       
           05  PARM-DATE-TO            PIC X(10).                       
           05  PARM-SEASON             PIC X(01).                       
           05  PARM-INSTR-USE          PIC X(01).                       
           05  PARM-CODE-TIME-PERIOD   PIC X(01).                       
           05  PARM-CMPNT-ID-CD        PIC X(02).                       
           05  PARM-FIXED-FCTR-TYP-CD  PIC X(02).                       
           05  PARM-FAC-CHRG-BASE-AM   PIC X(10).                       
           05  PARM-APPL-PROGRAM-ID    PIC X(08)  VALUE SPACES.         
           05  PARM-DURATION-REMAIN-NO PIC X(04)  VALUE SPACES.         
           05  PARM-TRAN-COMMENT       PIC X(210) VALUE SPACES.         
                                                                        
       01  WS-FACTOR-DATA.                                              
           05  WS-FACT-VALUE.                                           
               15  WS-FACT-VALUE-SI    PIC X(01).                       
               15  WS-FACT-VALUE-AM    PIC X(15).                       
           05  WS-FXD-FCTR-SEQ-NO      PIC X(4).                        
           05  WS-DATE-FROM            PIC X(10).                       
           05  WS-DATE-TO              PIC X(10).                       
           05  WS-SEASON               PIC X(1).                        
           05  WS-INSTR-USE            PIC X(1).                        
           05  WS-CODE-TIME-PERIOD     PIC X(1).                        
           05  WS-CMPNT-ID-CD          PIC X(2).                        
           05  WS-FIXED-FCTR-TYP-CD    PIC X(2).                        
           05  WS-FAC-CHRG-BASE-AMT.                                    
               15  WS-FAC-CHRG-BASE-SI PIC X(1).                        
               15  WS-FAC-CHRG-BASE-AM PIC X(9).                        
           05  WS-DURATION-REMAIN-NO   PIC X(04).                       
           05  WS-DURATION-REMAIN-NO-NUM REDEFINES                      
               WS-DURATION-REMAIN-NO   PIC 9(4).                        
           05  WS-BLOCK-NO             PIC S9(04) COMP VALUE 0.         
           05  WS-BLOCK-NO-X           PIC X(04).                       
           05  WS-BLOCK-NO-9           REDEFINES                        
               WS-BLOCK-NO-X           PIC 9(4).                        
                                                                        
       01  NULL-INDICATORS.                                             
           05  IND-HIST-DATE-FROM      PIC S9(04) COMP.                 
           05  IND-HIST-DATE-TO        PIC S9(04) COMP.                 
           05  IND-DATE-FROM           PIC S9(04) COMP.                 
           05  IND-DATE-TO             PIC S9(04) COMP.                 
           05  IND-BILL-TIMESTAMP      PIC S9(04) COMP.                 
           05  IND-DEBIT-CREDIT        PIC S9(04) COMP.                 
           05  IND-DURATION-REMAIN-NO  PIC S9(04) COMP.                 
           05  IND-DEF-DUR-REM-NO      PIC S9(04) COMP.                 
           05  WS-BLOCK-NULL-ID        PIC S9(04) COMP.                 
           05  WS-NULL-IND-01          PIC S9(04) COMP.                 
           05  WS-NULL-IND-02          PIC S9(04) COMP.                 
                                                                        
A05065 01  WS-TRANS-COMM.                                               
A05065     05  WS-UTILITY                PIC X(10) VALUE SPACES.        
A05065     05  WS-IC-NO                  PIC X(04) VALUE SPACES.        
A05065     05  FILLER                    PIC X(01) VALUE SPACES.        
A05065     05  WS-FACTOR-ID              PIC X(09) VALUE SPACES.        
A05065                                                                  
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
                                                                        
                                                                        
       01  WS-MISC.                                                     
           05  WS-REVENUE-MONTH        PIC X(6).                        
           05  WS-FACTOR-ID-DESC       PIC X(35) VALUE SPACES.          
           05  WS-UPDATE-FLAG          PIC X(01).                       
           05  WS-BILL-NO              PIC 9(05) VALUE ZEROS.           
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR04655'.      
           05  WS-OPTION-CD            PIC X(12) VALUE SPACES.          
A05065     05  WS-LEN                  PIC S9(04) COMP VALUE 0.         
           05  WS-DSM-FACTOR-ID        PIC X(09) VALUE SPACES.          
           05  WS-FACTOR-VALUE         PIC S9(15).                      
           05  WS-FACTOR-VALUE-RED     REDEFINES WS-FACTOR-VALUE        
                                       PIC S999999999V999999.           
           05  WS-BASE-AMT             PIC S9(09).                      
           05  WS-BASE-AMT-RED         REDEFINES WS-BASE-AMT            
                                       PIC S9999999V99.                 
           05  WS-FACTOR-VAL           PIC S999999999V999999.           
           05  WS-HOLD-FACT-VAL        PIC S9(15) VALUE ZEROS.          
           05  WS-HOLD-FACT-VAL-RED    REDEFINES WS-HOLD-FACT-VAL       
                                       PIC S999999999V999999.           
           05  WS-HOLD-BASE-AMT        PIC S9(09) VALUE ZEROS.          
           05  WS-HOLD-BASE-AMT-RED    REDEFINES WS-HOLD-BASE-AMT       
                                       PIC S9999999V99.                 
           05  WS-FACT-VAL-Z           PIC ---------9(01).9(06).        
           05  WS-FACT-BASE-AMT-Z      PIC -------9(01).9(02).          
           05  WS-FACTOR-DESC          PIC X(255) VALUE SPACES.         
           05  WS-FACTOR-DESC-TMP      PIC X(255) VALUE SPACES.         
COB305     05 WS-BASE-AMT-TRANS        PIC S9(7)V9(02) COMP-3 VALUE 0.          
           05  WS-TIME-PERIOD          PIC 9(1).                        
           05  WS-FIXED-FCTR-SEQ-NO    PIC 9(4).                        
           05  WS-ACCOUNT-NO           PIC X(13).                       
           05  WS-ACCOUNT-NO-NUM       REDEFINES WS-ACCOUNT-NO          
                                       PIC S9(13).                      
           05  WS-UPDATE-SUCCESSFUL    PIC X(01).                       
               88 UPDATE-SUCCESSFUL    VALUE 'Y'.                       
           05  WS-NO-OF-UPDATE-TRIES   PIC S9(04) COMP-3 VALUE 0.       
           05  WS-NULL-IND             PIC S9(04) COMP   VALUE 0.       
           05  WS-BASE-AMT-TEXT        PIC S9(7)V9(2).                  
           05  WS-FACTOR-TEXT          PIC S9(9)V9(6).                  
           05  WS-SUB                  PIC S9(04) COMP-3 VALUE 0.       
           05  WS-FACTR-CANT-BE        PIC X(02).                       
           05  WS-RATE                 PIC X(03)  VALUE '000'.          
           05  WS-ADJUST-ELEMENT       PIC X(01) VALUE SPACES.          
           05  WS-REPL-BLK-PCT-S       PIC X(01) VALUE 'S'.             
           05  WS-REPL-BLK-UNITS-Q     PIC X(01) VALUE 'Q'.             
           05  WS-UNIT-PRICE-TYPE-U    PIC X(01) VALUE 'U'.             
           05  WS-PCT-PRICE-TYPE-P     PIC X(01) VALUE 'P'.             
      *                                                                         
P00805     05  WS-MONTHS-TO-RENEW      PIC S9(4) USAGE COMP VALUE 0.    
P00805     05  WS-REG-LIMIT-DELINQ-CD  PIC X(20) VALUE                  
P00805                                     'MONTHS-TO-RENEW-REG'.       
P00805     05  WS-DREG-LIMIT-DELINQ-CD PIC X(20) VALUE                  
P00805                                     'MONTHS-TO-RENEW-DREG'.      
      *                                                                         
           05  WS-CODE-REVENUE-CLASS   PIC X(03).                       
           05  WS-RES-MIN-CD           PIC X(15)  VALUE 'RES-MIN-DDC'.  
           05  WS-RES-MAX-CD           PIC X(15)  VALUE 'RES-MAX-DDC'.  
           05  WS-COM-MIN-CD           PIC X(15)  VALUE 'COM-MIN-DDC'.  
           05  WS-COM-MAX-CD           PIC X(15)  VALUE 'COM-MAX-DDC'.  
           05  WS-DATABASE             PIC 9(01)  VALUE ZERO.           
               88  CSR-DATABASE                   VALUE 1.              
               88  SEB-DATABASE                   VALUE 2.              
           05  WS-DURATION-REMAIN-NULL PIC S9(04) COMP VALUE +0.        
               88  DURATION-REMAIN-NULL           VALUE -1.             
           05  WS-REV-MTH-LST-NRML     PIC 9(06) VALUE 0.               
           05  WS-REV-MTH-LST-NRML2.                                    
               10 WS-REVMTH-LSTNRML-CCYY     PIC 9(04) VALUE 0.         
               10 WS-REVMTH-LSTNRML-MM PIC 9(02) VALUE 0.               
           05  WS-REV-MTH              PIC 9(06) VALUE 0.               
           05  WS-REV-MTH2.                                             
               10 WS-REV-MTH-CCYY      PIC 9(04) VALUE 0.               
               10 WS-REV-MTH-MM        PIC 9(02) VALUE 0.               
           05  WS-REV-MTH-END-DT.                                       
               10  WS-REV-MTH-END-CCYY PIC x(04).                       
               10  FILLER              PIC X(01) VALUE '-'.             
               10  WS-REV-MTH-END-MM   PIC X(02).                       
               10  FILLER              PIC X(01) VALUE '-'.             
               10  WS-REV-MTH-END-DD   PIC X(02).                       
           05  WS-DATE-TO-NUM.                                          
               10  WS-DATETO-NUM-CCYY  PIC 9(04).                       
               10  FILLER              PIC X(01).                       
               10  WS-DATETO-NUM-MM    PIC 9(02).                       
               10  FILLER              PIC X(01).                       
               10  WS-DATETO-NUM-DD    PIC X(02).                       
           05  WS-DATE-END-OF-MTH      PIC X(10).                       
           05  WS-RTPK-UPD-REQ-IND     PIC X(01) VALUE SPACES.          
           05  WS-UPD-RTPK-STAT-ADJ-CD PIC X(01) VALUE SPACES.          
           05  WS-CURRENT-ADJ-FACTOR   PIC X(01) VALUE SPACES.          
           05  WS-RTPK-PENDING-EXISTS  PIC X(01) VALUE SPACES.          
           05  WS-OLD-DF-STATUS-CD     PIC X(01) VALUE SPACES.          
           05  WS-OLD-DF-STAT-ADJ-CD   PIC X(01) VALUE SPACES.          
           05  WS-FCTR-POWER-10        PIC S9(4) USAGE COMP.            
           05  WS-REV-MTH-LST-NRML-C   PIC X(06) VALUE SPACES.          
           05  WS-FACTOR-EXPIRE-DATE   PIC X(10) VALUE SPACES.          
           05  WS-NULL-IND-FF-SEQ-NO   PIC S9(4) COMP VALUE 0.          
           05  WS-NULL-IND-EFF-DATE-TO PIC S9(4) COMP VALUE 0.          
           05  WS-TEMP-DATE-TO         PIC X(10) VALUE SPACES.          
           05  WS-DURATION-NO-Z        PIC Z(04).                       
           05  WS-NULL-IND-13          PIC S9(4) COMP VALUE 0.          
           05 WS-EXP-DATE.                                              
              10 WS-EXP-YR            PIC X(04).                        
              10 FILLER               PIC X(01) VALUE '-'.              
              10 WS-EXP-MT            PIC X(02).                        
              10 FILLER               PIC X(01) VALUE '-'.              
              10 WS-EXP-DY            PIC X(02).                        
COB305     05 WS-FACTOR-FF        PIC S9(09)V9(06) USAGE COMP-3 VALUE 0.    
           05 WS-FAILED               PIC X(01)  VALUE 'F'.             
           05 WS-PASSED               PIC X(01)  VALUE 'P'.             
      *                                                                         
       01  WS-DDC-FACTOR-RANGES.                                        
           05  WS-RES-MIN-DDC          PIC S9(08)V9999.                 
           05  WS-RES-MAX-DDC          PIC S9(08)V9999.                 
           05  WS-COM-MIN-DDC          PIC S9(08)V9999.                 
           05  WS-COM-MAX-DDC          PIC S9(08)V9999.                 
       01  WS-FLAG-VALUES.                                              
           05  WS-YES                  PIC X(01) VALUE 'Y'.             
           05  WS-NO                   PIC X(01) VALUE 'N'.             
           05  WS-FACTOR               PIC X(01) VALUE 'F'.             
           05  WS-FACTOR-HIST          PIC X(01) VALUE 'H'.             
           05  WS-ACTIVE-CODE          PIC X(01) VALUE 'A'.             
       01  WS-ONERATE-ANNIV.                                            
           05  WS-ONERATE-ANNIV-YR     PIC X(04) VALUE SPACES.          
           05  WS-ONERATE-ANNIV-MO     PIC X(02) VALUE SPACES.          
       01  WS-ONERATE-ANNIV-X          PIC X(06) VALUE SPACES.          
       01  WS-ONERATE-ANNIV-N REDEFINES WS-ONERATE-ANNIV-X              
                                       PIC 9(06).                       
COB305 01 WS-ONERATE-ANNIV-RED        PIC S9(6)V USAGE COMP-3 VALUE 0.         
       01  WS-HOLD-DATE-TO.                                             
           05  WS-HOLD-DATE-YR         PIC X(04) VALUE SPACES.          
           05  FILLER                  PIC X(01).                       
           05  WS-HOLD-DATE-MO         PIC X(02) VALUE SPACES.          
           05  FILLER                  PIC X(03).                       
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE          PIC S9(9) COMP VALUE 0.           
           05  S-APPL-RETURN-CODE     PIC S9(04) COMP VALUE 0.          
           05  S-BUS-RULE-ID          PIC X(10) VALUE SPACES.           
           05  S-BUS-RULE-RESULT-CD   PIC X(10)  VALUE SPACES.          
           05  S-BUS-RULE-XREF-ID     PIC X(26) VALUE SPACES.           
                                                                        
       01  WS-MNT-TRANS-DET.                                            
           05  WS-CODE-TRAN-TYPE         PIC X(01) VALUE 'B'.           
           05  WS-TRAN-APPL-NO           PIC S9(02) VALUE +1.           
           05  WS-COLUMN-DESC            PIC X(04) VALUE '****'.        
           05  WS-CHG-COLUMN-VALUE-TEXT  PIC X(04) VALUE '****'.        
           05  WS-CHG-COLUMN-VALUE-LEN   PIC S9(02) VALUE +4.           
           05  WS-PRV-COLUMN-VALUE-TEXT  PIC X(04) VALUE 'NONE'.        
           05  WS-PRV-COLUMN-VALUE-LEN   PIC S9(02) VALUE +4.           
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-DSM                    PIC X(08) VALUE 'DSM'.         
           05  MCSCB065                  PIC X(08) VALUE 'MCSCB065'.    
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
           05  WS-NO-MORE-ROWS         PIC X(01) VALUE 'N'.             
               88 NO-MORE-ROWS                   VALUE 'Y'.             
               88 HAS-REBILL-ROWS                VALUE 'N'.             
           05 DATE-TO-SW               PIC X(01) VALUE 'Y'.             
               88 DATE-TO-INVALID                VALUE 'N'.             
               88 DATE-TO-VALID                  VALUE 'Y'.             
                                                                        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
           10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-ACTION-TYPE         PIC X(01)                .          
       01  LINK-USERID              PIC X(07)                .          
       01  LINK-ACCOUNT-NO          PIC X(13)                .          
       01  LINK-CODE-UTIL-TYPE      PIC X(01)                .          
       01  LINK-IC-NO               PIC S9(04) USAGE COMP    .          
       01  LINK-FACTOR-ID           PIC X(09)                .          
       01  LINK-FACTOR              PIC X(16)                .          
       01  LINK-BLOCK-NO            PIC X(04)                .          
       01  LINK-FXD-FCTR-SEQ-NO     PIC X(04)                .          
       01  LINK-DATE-FROM           PIC X(10)                .          
       01  LINK-DATE-TO             PIC X(10)                .          
       01  LINK-SEASON              PIC X(01)                .          
       01  LINK-INSTR-USE           PIC X(01)                .          
       01  LINK-CODE-TIME-PERIOD    PIC X(01)                .          
       01  LINK-CMPNT-ID-CD         PIC X(02)                .          
       01  LINK-FIXED-FCTR-TYP-CD   PIC X(02)                .          
       01  LINK-FAC-CHRG-BASE-AM    PIC X(10)                .          
       01  LINK-APPL-PROGRAM-ID     PIC X(08)                .          
       01  LINK-DURATION-REMAIN-NO  PIC X(04)                .          
       01  LINK-TRAN-COMMENT        PIC X(210)               .          
                                                                        
       PROCEDURE DIVISION USING LINK-ACTION-TYPE                        
                                LINK-APPL-PROGRAM-ID                    
                                LINK-USERID                             
                                LINK-ACCOUNT-NO                         
                                LINK-CODE-UTIL-TYPE                     
                                LINK-IC-NO                              
                                LINK-FACTOR-ID                          
                                LINK-FACTOR                             
                                LINK-BLOCK-NO                           
                                LINK-FXD-FCTR-SEQ-NO                    
                                LINK-DATE-FROM                          
                                LINK-DATE-TO                            
                                LINK-SEASON                             
                                LINK-INSTR-USE                          
                                LINK-CODE-TIME-PERIOD                   
                                LINK-CMPNT-ID-CD                        
                                LINK-FIXED-FCTR-TYP-CD                  
                                LINK-FAC-CHRG-BASE-AM                   
                                LINK-DURATION-REMAIN-NO                 
                                LINK-TRAN-COMMENT.                      
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE             THRU 0100-EXIT.          
           PERFORM 1000-PROCESS-INPUT          THRU 1000-EXIT.          
           PERFORM 2000-PROCESS-OUTPUT         THRU 2000-EXIT.          
           PERFORM 9999-END-PROGRAM            THRU 9999-EXIT.          
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           EXEC SQL                                                     
              DECLARE C1 CURSOR  FOR                         
              SELECT :S-RETURN-CODE           AS RETURN_CODE            
                    ,:S-APPL-RETURN-CODE      AS APPL_RETURN_CODE       
                    ,:S-BUS-RULE-ID           AS BUS_RULE_ID            
                    ,:S-BUS-RULE-RESULT-CD    AS BUS_RULE_RESULT_CD     
                    ,:S-BUS-RULE-XREF-ID      AS BUS_RULE_XREF_ID       
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN FOR                                 
MFA-TR*       SELECT :S-RETURN-CODE           AS RETURN_CODE                    
MFA-TR*             ,:S-APPL-RETURN-CODE      AS APPL_RETURN_CODE               
MFA-TR*             ,:S-BUS-RULE-ID           AS BUS_RULE_ID                    
MFA-TR*             ,:S-BUS-RULE-RESULT-CD    AS BUS_RULE_RESULT_CD             
MFA-TR*             ,:S-BUS-RULE-XREF-ID      AS BUS_RULE_XREF_ID               
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
           MOVE LINK-ACTION-TYPE          TO PARM-ACTION-TYPE         . 
           MOVE LINK-USERID               TO PARM-USERID              . 
           MOVE LINK-ACCOUNT-NO           TO PARM-ACCOUNT-NO          . 
           MOVE LINK-CODE-UTIL-TYPE       TO PARM-CODE-UTIL-TYPE      . 
           MOVE LINK-IC-NO                TO PARM-IC-NO               . 
           MOVE LINK-FACTOR-ID            TO PARM-FACTOR-ID           . 
           MOVE LINK-FACTOR               TO PARM-FACTOR              . 
           MOVE LINK-BLOCK-NO             TO PARM-BLOCK-NO            . 
           MOVE LINK-FXD-FCTR-SEQ-NO      TO PARM-FXD-FCTR-SEQ-NO     . 
           MOVE LINK-DATE-FROM            TO PARM-DATE-FROM           . 
           MOVE LINK-DATE-TO              TO PARM-DATE-TO             . 
           MOVE LINK-SEASON               TO PARM-SEASON              . 
           MOVE LINK-INSTR-USE            TO PARM-INSTR-USE           . 
           MOVE LINK-CODE-TIME-PERIOD     TO PARM-CODE-TIME-PERIOD    . 
           MOVE LINK-CMPNT-ID-CD          TO PARM-CMPNT-ID-CD         . 
           MOVE LINK-FIXED-FCTR-TYP-CD    TO PARM-FIXED-FCTR-TYP-CD   . 
           MOVE LINK-FAC-CHRG-BASE-AM     TO PARM-FAC-CHRG-BASE-AM    . 
           MOVE LINK-APPL-PROGRAM-ID      TO PARM-APPL-PROGRAM-ID     . 
           MOVE LINK-DURATION-REMAIN-NO   TO PARM-DURATION-REMAIN-NO  . 
           MOVE LINK-TRAN-COMMENT         TO PARM-TRAN-COMMENT        . 
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-FACTOR-ID               TO WS-FACTOR-ID.           
           MOVE PARM-FACTOR                  TO WS-FACT-VALUE.          
           MOVE PARM-BLOCK-NO                TO WS-BLOCK-NO-X.          
           MOVE PARM-FXD-FCTR-SEQ-NO         TO WS-FXD-FCTR-SEQ-NO.     
           MOVE PARM-DATE-FROM               TO WS-DATE-FROM.           
           MOVE PARM-DATE-TO                 TO WS-DATE-TO              
                                                WS-DATE-TO-NUM.         
           MOVE PARM-SEASON                  TO WS-SEASON               
                                                PS-CODE-SEASON.         
           MOVE PARM-INSTR-USE               TO WS-INSTR-USE            
                                                PS-CODE-USE-INST-TYPE.  
           MOVE PARM-CODE-TIME-PERIOD        TO WS-CODE-TIME-PERIOD     
                                                PS-CODE-TIME-PERIOD.    
           MOVE PARM-CMPNT-ID-CD             TO WS-CMPNT-ID-CD          
                                                PS-CMPNT-ID-CD.         
           MOVE PARM-FIXED-FCTR-TYP-CD       TO WS-FIXED-FCTR-TYP-CD.   
           MOVE PARM-FAC-CHRG-BASE-AM        TO WS-FAC-CHRG-BASE-AMT.   
           MOVE PARM-DURATION-REMAIN-NO      TO WS-DURATION-REMAIN-NO.  
           MOVE PARM-ACTION-TYPE             TO WS-UPDATE-FLAG.         
           MOVE PARM-ACCOUNT-NO              TO WS-ACCOUNT-NO.          
           MOVE WS-ACCOUNT-NO                TO FF-ACCOUNT-NO           
                                                UT-ACCOUNT-NO           
                                                AT-ACCOUNT-NO           
P00805                                          LR-ACCOUNT-NO           
                                                BG-ACCOUNT-NO.          
                                                                        
           MOVE PARM-IC-NO                   TO UT-IC-NO                
                                                FF-IC-NO.               
           MOVE PARM-CODE-UTIL-TYPE          TO UT-CODE-UTIL-TYPE       
                                                PS-CODE-UTIL-TYPE       
                                                BG-CODE-UTIL-TYPE       
                                                RD-CODE-UTIL-TYPE       
                                                FF-CODE-UTIL-TYPE.      
                                                                        
           PERFORM 7325-SELECT-COMPANY          THRU 7325-EXIT.         
           MOVE AT-REV-MTH-LST-NRML          TO WS-REV-MTH-LST-NRML.    
           MOVE WS-REV-MTH-LST-NRML          TO WS-REV-MTH-LST-NRML2.   
           MOVE AT-COMPANY-NO                TO C8-COMPANY-NO.          
           MOVE AT-BILL-CYCLE                TO BN-BILL-CYCLE.          
                                                                        
           MOVE PARM-USERID                  TO PF-USER-ID.             
           PERFORM 7020-SELECT-USER-PROFILE     THRU 7020-EXIT          
                                                                        
           MOVE ZERO                         TO WS-DATABASE.            
           MOVE 'DATABASE'                   TO C8-DELINQ-CD.           
           PERFORM 7350-SELECT-DELINQUENCY      THRU 7350-EXIT.         
           MOVE C8-DELINQ-VALUE              TO WS-DATABASE.            
                                                                        
P00805     IF SEB-DATABASE                                              
P00805        PERFORM 7330-SELECT-REG-PROFILE   THRU 7330-EXIT          
P00805        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
P00805           MOVE WS-REG-LIMIT-DELINQ-CD TO C8-DELINQ-CD            
P00805        ELSE                                                      
P00805           MOVE WS-DREG-LIMIT-DELINQ-CD                           
P00805                                       TO C8-DELINQ-CD            
P00805        END-IF                                                    
P00805        MOVE AT-COMPANY-NO             TO C8-COMPANY-NO           
P00805        PERFORM 7350-SELECT-DELINQUENCY   THRU 7350-EXIT          
P00805        MOVE C8-DELINQ-VALUE           TO WS-MONTHS-TO-RENEW      
P00805     END-IF.                                                      
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 7270-GET-RATE               THRU 7270-EXIT.          
           IF WS-RATE < '065' OR WS-RATE > '066'                        
              MOVE 'SL'                     TO WS-FACTR-CANT-BE         
           ELSE                                                         
              MOVE 'AD'                     TO WS-FACTR-CANT-BE         
           END-IF.                                                      
                                                                        
           PERFORM 7600-GET-CURRENT-TS         THRU 7600-EXIT.          
                                                                        
           IF PARM-APPL-PROGRAM-ID EQUAL WS-DSM                         
              PERFORM 2010-PROCESS-DSM         THRU 2010-EXIT           
           ELSE                                                         
              PERFORM 2020-PROCESS-FCTR-UPDT   THRU 2020-EXIT           
           END-IF.                                                      
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE       TO S-RETURN-CODE.           
           PERFORM 8100-SEND-RESULT            THRU 8100-EXIT.          
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2010-PROCESS-DSM                                               *        
      *  PROCESSING FOR DSM FACTORS                                    *        
      ******************************************************************        
       2010-PROCESS-DSM.                                                
                                                                        
           EVALUATE WS-UPDATE-FLAG                                      
               WHEN 'I'                                                 
                  MOVE WS-ACCOUNT-NO        TO WS-CPD65-ACCOUNT-NO      
                  MOVE PARM-CODE-UTIL-TYPE  TO WS-CPD65-CODE-UTIL-TYPE  
                  MOVE PARM-IC-NO           TO WS-CPD65-IC-NO           
                  MOVE PROGRAM-NAME         TO WS-CPD65-CALLING-PGM     
                  MOVE PARM-FACTOR          TO WS-FACTOR-VALUE          
                  MOVE WS-FACTOR-VALUE-RED  TO WS-CPD65-FACTOR          
                  MOVE PARM-DURATION-REMAIN-NO                          
                                            TO WS-CPD65-DUR-REMAIN-NO   
                  MOVE PARM-USERID          TO WS-CPD65-USER-ID         
      ***INSERT DSMCREDIT FACTOR                                                
                  MOVE 'DS'                 TO SF-SPCL-GROUP-CD         
                  PERFORM 7220-GET-FCTR-BY-GRPCD                        
                                            THRU 7220-EXIT              
                  MOVE WS-DSM-FACTOR-ID     TO WS-CPD65-FACTOR-ID       
                  PERFORM 6000-CREATE-FACTOR         THRU 6000-EXIT     
      ***INSERT DSMDEBIT FACTOR                                                 
                  MOVE 'DR'                 TO SF-SPCL-GROUP-CD         
                  PERFORM 7220-GET-FCTR-BY-GRPCD                        
                                            THRU 7220-EXIT              
                  MOVE WS-DSM-FACTOR-ID     TO WS-CPD65-FACTOR-ID       
                  PERFORM 6000-CREATE-FACTOR         THRU 6000-EXIT     
                                                                        
               WHEN 'D'                                                 
      ***DELETE/EXPIRE DSMCREDIT FACTOR                                         
                  MOVE 'DS'                 TO SF-SPCL-GROUP-CD         
                  PERFORM 7220-GET-FCTR-BY-GRPCD                        
                                            THRU 7220-EXIT              
                  MOVE WS-DSM-FACTOR-ID     TO FF-FACTOR-ID             
                  PERFORM 2100-EXPIRE-OR-DELETE-FCTR THRU 2100-EXIT     
      ***DELETE/EXPIRE DSMDEBIT FACTOR                                          
                  MOVE 'DR'                 TO SF-SPCL-GROUP-CD         
                  PERFORM 7220-GET-FCTR-BY-GRPCD                        
                                            THRU 7220-EXIT              
                  MOVE WS-DSM-FACTOR-ID     TO FF-FACTOR-ID             
                  PERFORM 2100-EXPIRE-OR-DELETE-FCTR THRU 2100-EXIT     
           END-EVALUATE.                                                
                                                                        
       2010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2020-PROCESS-FCTR-UPDT.                                        *        
      ******************************************************************        
       2020-PROCESS-FCTR-UPDT.                                          
                                                                        
           IF WS-FACTOR-DATA NOT EQUAL SPACES                           
              IF WS-FIXED-FCTR-TYP-CD EQUAL WS-FACTR-CANT-BE            
                 IF WS-FACTR-CANT-BE = 'AD'                             
                    MOVE 'MRM0000022'         TO S-BUS-RULE-ID          
                 ELSE                                                   
                    IF WS-FACTR-CANT-BE = 'SL'                          
                       MOVE 'MRM0000023'      TO S-BUS-RULE-ID          
                    END-IF                                              
                 END-IF                                                 
                 MOVE WS-FAILED               TO S-BUS-RULE-RESULT-CD   
                 PERFORM 5800-MOVE-BUSINESS-RULE THRU 5800-EXIT         
              END-IF                                                    
                                                                        
              MOVE WS-FACTOR-ID               TO FF-FACTOR-ID           
                                                 SF-FACTOR-ID           
              PERFORM 5100-MOVE-TRAN-HEAD        THRU 5100-EXIT         
              MOVE WS-FXD-FCTR-SEQ-NO         TO WS-FIXED-FCTR-SEQ-NO   
              MOVE WS-FIXED-FCTR-SEQ-NO       TO FF-FIXED-FCTR-SEQ-NO   
              MOVE WS-FACT-VALUE-AM           TO WS-FACTOR-VALUE        
                                                                        
              PERFORM 7210-SELECT-FACTOR-PWR     THRU 7210-EXIT         
                                                                        
              IF WS-FCTR-POWER-10 NOT EQUAL 0                           
                 COMPUTE WS-FACTOR-VALUE-RED = WS-FACTOR-VALUE-RED *    
                         (10 **(WS-FCTR-POWER-10 * -1))                 
              END-IF                                                    
                                                                        
              MOVE WS-FACTOR-VALUE-RED        TO FF-FACTOR              
                                                                        
              MOVE ZEROES                     TO IND-DEF-DUR-REM-NO     
              MOVE SPACES                     TO WS-UPD-RTPK-STAT-ADJ-CD
              PERFORM 7050-GET-SPCL-FCTR-DETAILS                        
                                                 THRU 7050-EXIT         
              MOVE SF-ADJUST-ELEMENT          TO WS-ADJUST-ELEMENT      
                                                                        
              IF SF-RT-ATTR-INCTV-TYPE = 'ADJUSTABLE RATE'              
                                     AND SEB-DATABASE                   
                 MOVE 'Y'                     TO WS-UPD-RTPK-STAT-ADJ-CD
              END-IF                                                    
                                                                        
              PERFORM 7200-SELECT-FACTOR         THRU 7200-EXIT         
                                                                        
              IF WS-UPDATE-FLAG NOT EQUAL "D"                           
                 IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL         
                    MOVE 'U'                  TO WS-UPDATE-FLAG         
                    IF SEB-DATABASE                                     
                       AND WS-DURATION-REMAIN-NO-NUM > 0                
                       AND ( WS-DURATION-REMAIN-NO-NUM                  
                                       NOT = FF-DURATION-REMAIN-NO      
                        OR WS-DATE-TO  NOT = FF-EFF-DATE-TO )           
                       MOVE WS-REV-MTH-LST-NRML                         
                                              TO WS-REV-MTH             
                       MOVE WS-REV-MTH        TO WS-REV-MTH2            
                                                                        
                       IF WS-REV-MTH = 0                                
                          MOVE ZEROES         TO BN-REVENUE-MONTH       
                          PERFORM 7720-GET-BN-REV-MONTH                 
                                                 THRU 7720-EXIT         
                          IF BN-REVENUE-MONTH EQUAL ZEROES              
                             PERFORM 7730-GET-MIN-REV-MONTH             
                                                 THRU 7730-EXIT         
                          END-IF                                        
                          MOVE BN-REVENUE-MONTH                         
                                              TO WS-REV-MTH             
                          MOVE WS-REV-MTH     TO WS-REV-MTH2            
                       ELSE                                             
                          ADD +1              TO WS-REV-MTH-MM          
                          IF WS-REV-MTH-MM > 12                         
                             MOVE +1          TO WS-REV-MTH-MM          
                             ADD +1           TO WS-REV-MTH-CCYY        
                          END-IF                                        
                       END-IF                                           
                                                                        
                       MOVE WS-REV-MTH-CCYY   TO WS-REV-MTH-END-CCYY    
                       MOVE WS-REV-MTH-MM     TO WS-REV-MTH-END-MM      
                       MOVE '01'              TO WS-REV-MTH-END-DD      
                                                                        
                       IF WS-REV-MTH-END-DT > WS-DATE-TO                
                          MOVE 'MRM0000026'   TO S-BUS-RULE-ID          
                          MOVE WS-FAILED      TO S-BUS-RULE-RESULT-CD   
                          PERFORM 5800-MOVE-BUSINESS-RULE               
                                                 THRU 5800-EXIT         
                       END-IF                                           
                    END-IF                                              
                 ELSE                                                   
                    MOVE 'I'                  TO WS-UPDATE-FLAG         
                 END-IF                                                 
              END-IF                                                    
                                                                        
              IF SEB-DATABASE AND (WS-UPDATE-FLAG = "I"                 
                                  OR WS-UPD-RTPK-STAT-ADJ-CD = 'Y')     
                 PERFORM 7700-GET-RTPKGOPTSEQ-FCTR                      
                                                 THRU 7700-EXIT         
                 IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
                    MOVE UT-RT-PKG-OPT-SEQ-NO TO FF-RT-PKG-OPT-SEQ-NO   
                 ELSE                                                   
                    MOVE 0                    TO FF-RT-PKG-OPT-SEQ-NO   
                 END-IF                                                 
              END-IF                                                    
                                                                        
              IF SEB-DATABASE AND ((WS-UPDATE-FLAG = "I" OR "U")        
                                  OR  WS-UPD-RTPK-STAT-ADJ-CD = 'Y')    
                 MOVE WS-FACTOR-ID            TO HQ-FACTOR-ID           
                 IF WS-UPDATE-FLAG = "I"                                
                    MOVE DF-OPTION-CD         TO HQ-OPTION-CD           
                 ELSE                                                   
                    MOVE WS-FXD-FCTR-SEQ-NO   TO WS-FIXED-FCTR-SEQ-NO   
                    MOVE WS-FIXED-FCTR-SEQ-NO TO FF-FIXED-FCTR-SEQ-NO   
                    PERFORM 7710-GET-FCTR-OPTION-CODE                   
                                                 THRU 7710-EXIT         
                    MOVE WS-OPTION-CD         TO HQ-OPTION-CD           
                 END-IF                                                 
                                                                        
                 PERFORM 7800-CHK-DUR-EFFDATETO  THRU 7800-EXIT         
                                                                        
                 IF (WS-RTPK-UPD-REQ-IND = 'Y'                          
                        OR WS-UPD-RTPK-STAT-ADJ-CD = 'Y')               
                    MOVE UT-ACCOUNT-NO        TO DF-ACCOUNT-NO          
                    MOVE UT-CODE-UTIL-TYPE    TO DF-CODE-UTIL-TYPE      
                    MOVE UT-IC-NO             TO DF-IC-NO               
                    MOVE SPACES               TO WS-OLD-DF-STATUS-CD    
                                                 WS-OLD-DF-STAT-ADJ-CD  
                    PERFORM 7725-GET-RTPK-AGR-STATUS                    
                                                 THRU 7725-EXIT         
      *     UPDATE STATUS_CD = 'O' --> OPEN FOR RENEWAL                         
                    MOVE 'O'                  TO DF-STATUS-CD           
                 END-IF                                                 
              END-IF                                                    
                                                                        
              IF CSR-DATABASE AND (WS-UPDATE-FLAG = "I" OR "U")         
                 PERFORM 7810-CHK-DUR-REM-NO     THRU 7810-EXIT         
              END-IF                                                    
                                                                        
              IF CSR-DATABASE                                           
                 MOVE 0                       TO FF-RT-PKG-OPT-SEQ-NO   
              END-IF                                                    
                                                                        
              IF FF-FAC-CHRG-BASE-AM NOT NUMERIC                        
                 MOVE 0                       TO FF-FAC-CHRG-BASE-AM    
              END-IF                                                    
                                                                        
              MOVE FF-FAC-CHRG-BASE-AM        TO WS-BASE-AMT-TRANS      
              MOVE WS-FAC-CHRG-BASE-AM        TO WS-BASE-AMT            
                                                                        
              IF WS-FAC-CHRG-BASE-SI = '-'                              
                 COMPUTE WS-BASE-AMT-RED = WS-BASE-AMT-RED * -1         
              END-IF                                                    
                                                                        
              MOVE WS-BASE-AMT-RED            TO FF-FAC-CHRG-BASE-AM    
              MOVE WS-FACTOR-ID               TO SF-FACTOR-ID           
                                                                        
              PERFORM 7260-SELECT-SPCL-FCTR      THRU 7260-EXIT         
              IF SF-CHECK-ELEMENT NOT = 'N'                             
                 MOVE 0                       TO FF-FAC-CHRG-BASE-AM    
              END-IF                                                    
                                                                        
              EVALUATE WS-UPDATE-FLAG                                   
                  WHEN 'I'                                              
                     PERFORM 5500-CHECK-HIGH-LOW THRU 5500-EXIT         
                     IF ( WS-ADJUST-ELEMENT = WS-REPL-BLK-PCT-S OR      
                                 WS-REPL-BLK-UNITS-Q )                  
                          AND WS-BLOCK-NO-9 = 0 THEN                    
                        MOVE 'MRM0000026'     TO S-BUS-RULE-ID          
                        MOVE WS-FAILED        TO S-BUS-RULE-RESULT-CD   
                        PERFORM 5800-MOVE-BUSINESS-RULE                 
                                                 THRU 5800-EXIT         
                     END-IF                                             
                                                                        
                     IF WS-BLOCK-NO-9 > 0                               
                        PERFORM 5075-CHECK-BLOCK-NO                     
                                                 THRU 5075-EXIT         
                     END-IF                                             
                                                                        
      **UPDATE STAT_ADJUSTABLE_CD ON ACCT_RTPK_AGR, IF NEEDED                   
                     IF SEB-DATABASE                                    
                        AND WS-UPD-RTPK-STAT-ADJ-CD EQUAL 'Y'           
                        IF UT-RT-PKG-OPT-SEQ-NO > 0                     
                           MOVE UT-ACCOUNT-NO TO DF-ACCOUNT-NO          
                           MOVE UT-CODE-UTIL-TYPE                       
                                              TO DF-CODE-UTIL-TYPE      
                           MOVE UT-IC-NO      TO DF-IC-NO               
                           MOVE UT-RT-PKG-OPT-SEQ-NO                    
                                              TO DF-RT-PKG-OPT-SEQ-NO   
                           IF WS-DURATION-REMAIN-NO-NUM > 0             
                              MOVE 'A'        TO DF-STAT-ADJUSTABLE-CD  
                           ELSE                                         
                              MOVE 'E'        TO DF-STAT-ADJUSTABLE-CD  
                           END-IF                                       
                           PERFORM 8560-UPDATE-ACCT-RTPK-AGR            
                                                 THRU 8560-EXIT         
                        END-IF                                          
                     END-IF                                             
A05065               MOVE WS-CODE-TIME-PERIOD TO WS-TIME-PERIOD         
                     PERFORM 5200-MOVE-INS-TRAN-DET                     
                                                 THRU 5200-EXIT         
                                                                        
                     PERFORM 7100-SELECT-MAX-SEQ-NO                     
                                                 THRU 7100-EXIT         
                                                                        
                     IF WS-NULL-IND EQUAL -1                            
                        MOVE 1                TO FF-FIXED-FCTR-SEQ-NO   
                     ELSE                                               
                        ADD  1                TO FF-FIXED-FCTR-SEQ-NO   
                     END-IF                                             
                                                                        
                     MOVE FF-FIXED-FCTR-SEQ-NO                          
                                              TO WS-FXD-FCTR-SEQ-NO     
                     PERFORM 5750-MOVE-FACTOR-VALUES                    
                                                 THRU 5750-EXIT         
                                                                        
                     PERFORM 8200-INSERT-FACTOR  THRU 8200-EXIT         
                     IF WS-RTPK-UPD-REQ-IND = 'Y'                       
                        PERFORM 8550-UPDATE-ACCT-RTPK-AGR               
                                                 THRU 8550-EXIT         
                     END-IF                                             
                                                                        
                  WHEN 'D'                                              
                     IF WS-FIXED-FCTR-TYP-CD  EQUAL  'SL' OR            
                        WS-FIXED-FCTR-TYP-CD  EQUAL  'AD'               
                        MOVE '  '             TO WS-FIXED-FCTR-TYP-CD   
                        PERFORM 7280-CHECK-B-SUB-ACCT THRU 7280-EXIT    
                        IF AT-CODE-ACCT-USAGE > ' '                     
                           MOVE 'MRM0000024'  TO S-BUS-RULE-ID          
                           MOVE WS-FAILED     TO S-BUS-RULE-RESULT-CD   
                           PERFORM 5800-MOVE-BUSINESS-RULE              
                                                 THRU 5800-EXIT         
                        END-IF                                          
                     END-IF                                             
                                                                        
      **UPDATE STAT_ADJUSTABLE_CD ON ACCT_RTPK_AGR, IF NEEDED                   
                     IF SEB-DATABASE                                    
                        AND WS-UPD-RTPK-STAT-ADJ-CD EQUAL 'Y'           
                        MOVE WS-FXD-FCTR-SEQ-NO                         
                                              TO WS-FIXED-FCTR-SEQ-NO   
                        MOVE WS-FIXED-FCTR-SEQ-NO                       
                                              TO FF-FIXED-FCTR-SEQ-NO   
                        PERFORM 7900-CHK-ADJUSTABLE-FACTOR              
                                                 THRU 7900-EXIT         
                        IF WS-CURRENT-ADJ-FACTOR = 'Y'                  
                           AND UT-RT-PKG-OPT-SEQ-NO > 0                 
                           MOVE 'E'           TO DF-STAT-ADJUSTABLE-CD  
                           IF WS-OLD-DF-STAT-ADJ-CD                     
                                       NOT EQUAL DF-STAT-ADJUSTABLE-CD  
                              MOVE UT-ACCOUNT-NO                        
                                              TO DF-ACCOUNT-NO          
                              MOVE UT-CODE-UTIL-TYPE                    
                                              TO DF-CODE-UTIL-TYPE      
                              MOVE UT-IC-NO   TO DF-IC-NO               
                              MOVE UT-RT-PKG-OPT-SEQ-NO                 
                                              TO DF-RT-PKG-OPT-SEQ-NO   
                              PERFORM 8560-UPDATE-ACCT-RTPK-AGR         
                                                 THRU 8560-EXIT         
                           END-IF                                       
                        END-IF                                          
                     END-IF                                             
                                                                        
                     PERFORM 5400-MOVE-DEL-TRAN-DET                     
                                                 THRU 5400-EXIT         
                     PERFORM 5750-MOVE-FACTOR-VALUES                    
                                                 THRU 5750-EXIT         
                                                                        
                     PERFORM 8300-DELETE-FACTOR  THRU 8300-EXIT         
                                                                        
                  WHEN 'U'                                              
                     IF WS-FACTOR-VALUE-RED NOT EQUAL FF-FACTOR         
                        PERFORM 5500-CHECK-HIGH-LOW                     
                                                 THRU 5500-EXIT         
                     END-IF                                             
                     IF (WS-ADJUST-ELEMENT = WS-REPL-BLK-PCT-S          
                                  OR WS-REPL-BLK-UNITS-Q )              
                        IF WS-BLOCK-NO-9 > 0                            
                           PERFORM 5075-CHECK-BLOCK-NO                  
                                                 THRU 5075-EXIT         
                        ELSE                                            
                           IF WS-BLOCK-NO-9 = 0 THEN                    
                              MOVE 'MRM0000026'                         
                                              TO S-BUS-RULE-ID          
                              MOVE WS-FAILED  TO S-BUS-RULE-RESULT-CD   
                              PERFORM 5800-MOVE-BUSINESS-RULE           
                                                 THRU 5800-EXIT         
                           END-IF                                       
                        END-IF                                          
                     END-IF                                             
                                                                        
                     MOVE WS-CODE-TIME-PERIOD TO WS-TIME-PERIOD         
                                                                        
      **UPDATE STAT_ADJUSTABLE_CD ON ACCT_RTPK_AGR, IF NEEDED                   
                     IF SEB-DATABASE                                    
                        AND WS-UPD-RTPK-STAT-ADJ-CD EQUAL 'Y'           
                        MOVE WS-FXD-FCTR-SEQ-NO                         
                                              TO WS-FIXED-FCTR-SEQ-NO   
                        MOVE WS-FIXED-FCTR-SEQ-NO                       
                                              TO FF-FIXED-FCTR-SEQ-NO   
                        PERFORM 7900-CHK-ADJUSTABLE-FACTOR              
                                                 THRU 7900-EXIT         
                        IF WS-CURRENT-ADJ-FACTOR = 'Y'                  
                           AND UT-RT-PKG-OPT-SEQ-NO > 0                 
                           IF WS-DURATION-REMAIN-NO-NUM > 0             
                              MOVE 'A'        TO DF-STAT-ADJUSTABLE-CD  
                           ELSE                                         
                              MOVE 'E'        TO DF-STAT-ADJUSTABLE-CD  
                           END-IF                                       
                           IF WS-OLD-DF-STAT-ADJ-CD                     
                                         NOT EQUAL DF-STAT-ADJUSTABLE-CD
                              MOVE UT-ACCOUNT-NO                        
                                              TO DF-ACCOUNT-NO          
                              MOVE UT-CODE-UTIL-TYPE                    
                                              TO DF-CODE-UTIL-TYPE      
                              MOVE UT-IC-NO   TO DF-IC-NO               
                              MOVE UT-RT-PKG-OPT-SEQ-NO                 
                                              TO DF-RT-PKG-OPT-SEQ-NO   
                              PERFORM 8560-UPDATE-ACCT-RTPK-AGR         
                                                 THRU 8560-EXIT         
                           END-IF                                       
                        END-IF                                          
                     END-IF                                             
                                                                        
                     PERFORM 5300-MOVE-UPD-TRAN-DET                     
                                                 THRU 5300-EXIT         
                     PERFORM 5750-MOVE-FACTOR-VALUES                    
                                                 THRU 5750-EXIT         
                                                                        
                     PERFORM 8500-UPDATE-FACTOR  THRU 8500-EXIT         
                     IF WS-RTPK-UPD-REQ-IND = 'Y'                       
                        PERFORM 8550-UPDATE-ACCT-RTPK-AGR               
                                                 THRU 8550-EXIT         
                     END-IF                                             
                                                                        
              END-EVALUATE                                              
           END-IF.                                                      
                                                                        
       2020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2100-EXPIRE-OR-DELETE-FCTR.                                    *        
      ******************************************************************        
       2100-EXPIRE-OR-DELETE-FCTR.                                      
                                                                        
           PERFORM 7040-SELECT-FIXD-FCTR-SEQ-NO      THRU 7040-EXIT.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL AND           
                                          FF-FIXED-FCTR-SEQ-NO > 0      
              PERFORM 7045-SELECT-EFFECTIVE-DATES    THRU 7045-EXIT     
                                                                        
              IF AT-REV-MTH-LST-NRML > ZEROES                           
                 PERFORM 2110-CREATE-FCTR-EXPIRE-DT                     
                                                     THRU 2110-EXIT     
                 IF WS-NULL-IND-EFF-DATE-TO = 0                         
                    IF FF-EFF-DATE-TO < FF-EFF-DATE-FROM                
                       SET DATE-TO-INVALID TO TRUE                      
                    END-IF                                              
                 END-IF                                                 
                                                                        
                 IF DATE-TO-INVALID                                     
                    PERFORM 2130-DELETE-FIXED-FCTR   THRU 2130-EXIT     
                 ELSE                                                   
                    PERFORM 2120-EXPIRE-FIXED-FCTR   THRU 2120-EXIT     
                 END-IF                                                 
              ELSE                                                      
                 IF AT-REV-MTH-LST-NRML = ZEROES                        
                    PERFORM 2130-DELETE-FIXED-FCTR   THRU 2130-EXIT     
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2110-CREATE-FCTR-EXPIRE-DT.                                    *        
      ******************************************************************        
       2110-CREATE-FCTR-EXPIRE-DT.                                      
                                                                        
           MOVE AT-REV-MTH-LST-NRML        TO WS-REV-MTH-LST-NRML.      
           MOVE WS-REV-MTH-LST-NRML        TO WS-REV-MTH-LST-NRML-C.    
           MOVE WS-REV-MTH-LST-NRML-C(1:4) TO WS-EXP-YR.                
           MOVE WS-REV-MTH-LST-NRML-C(5:2) TO WS-EXP-MT.                
           MOVE '28'                       TO WS-EXP-DY.                
           MOVE WS-EXP-DATE                TO WS-FACTOR-EXPIRE-DATE.    
           MOVE WS-FACTOR-EXPIRE-DATE      TO FF-EFF-DATE-TO.           
                                                                        
       2110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 2120-EXPIRE-FIXED-FCTR.                                       *         
      *****************************************************************         
       2120-EXPIRE-FIXED-FCTR.                                          
                                                                        
      * WRITE TRANS HIST BEFORE EXPIRE.                                         
           PERFORM 7295-SEL-FIXD-FCTR-DET       THRU 7295-EXIT.         
           PERFORM 6560-MOVE-DSM-TRANS-HDR      THRU 6560-EXIT.         
           PERFORM 6565-MOVE-EXP-FCTR-TRAN-DET  THRU 6565-EXIT.         
           PERFORM 8400-EXPIRE-FIXED-FACTOR     THRU 8400-EXIT.         
                                                                        
       2120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 2130-DELETE-FIXED-FCTR.                                       *         
      *****************************************************************         
       2130-DELETE-FIXED-FCTR.                                          
                                                                        
      * WRITE TRANS HIST BEFORE DELETE.                                         
           PERFORM 7295-SEL-FIXD-FCTR-DET       THRU 7295-EXIT.         
           PERFORM 6560-MOVE-DSM-TRANS-HDR      THRU 6560-EXIT.         
           PERFORM 6585-MOVE-DEL-FCTR-TRAN-DET  THRU 6585-EXIT.         
           PERFORM 8450-DELETE-FIXED-FACTOR     THRU 8450-EXIT.         
                                                                        
       2130-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5075-CHECK-BLOCK-NO                                            *        
      *  CHECK THE BLOCK_NO IS VALID                                   *        
      ******************************************************************        
       5075-CHECK-BLOCK-NO.                                             
                                                                        
           MOVE WS-RATE                     TO PS-RATE-PLAN-NO          
                                               RD-RATE-PLAN-NO.         
                                                                        
           MOVE 'N'                         TO RD-SECURED-RATE-FL       
           PERFORM 7025-GET-SECURED-RATE-FL    THRU 7025-EXIT.          
                                                                        
           MOVE ZERO                        TO WS-BLOCK-NULL-ID.        
                                                                        
           PERFORM 7890-GET-ALLOWED-BLOCK-NO   THRU 7890-EXIT.          
                                                                        
           IF (WS-BLOCK-NO-9 > PS-BLOCK-NO OR                           
              ( PS-BLOCK-NO = 1 AND WS-BLOCK-NO-9 NOT = ZERO )) AND     
              (NOT ( CSR-DATABASE  AND  RD-SECURED-RATE-FL  = 'Y'))     
                                                                        
              MOVE 'MRM0000026'             TO S-BUS-RULE-ID            
              MOVE WS-FAILED                TO S-BUS-RULE-RESULT-CD     
              PERFORM 5800-MOVE-BUSINESS-RULE  THRU 5800-EXIT           
           END-IF.                                                      
                                                                        
           IF ( WS-ADJUST-ELEMENT = WS-REPL-BLK-PCT-S                   
                             OR WS-REPL-BLK-UNITS-Q )                   
              IF PS-BLOCK-NO = WS-BLOCK-NO-9                            
                 MOVE 'MRM0000027'          TO S-BUS-RULE-ID            
                 MOVE WS-FAILED             TO S-BUS-RULE-RESULT-CD     
                 PERFORM 5800-MOVE-BUSINESS-RULE THRU 5800-EXIT         
              ELSE                                                      
                 MOVE WS-BLOCK-NO-9         TO PS-BLOCK-NO              
                 PERFORM 7885-GET-BLOCK-PRICE-TYPE                      
                                               THRU 7885-EXIT           
                 IF ( WS-ADJUST-ELEMENT = WS-REPL-BLK-PCT-S             
                      AND PS-PRICE-TYPE-CD = WS-UNIT-PRICE-TYPE-U )     
                  OR ( WS-ADJUST-ELEMENT = WS-REPL-BLK-UNITS-Q          
                      AND PS-PRICE-TYPE-CD = WS-PCT-PRICE-TYPE-P )      
                    MOVE 'MRM0000028'       TO S-BUS-RULE-ID            
                    MOVE WS-FAILED          TO S-BUS-RULE-RESULT-CD     
                    PERFORM 5800-MOVE-BUSINESS-RULE THRU 5800-EXIT      
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
       5075-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * MOVE FIELDS TO THE MAINTENANCE TRANSACTION HEADER AND       *           
      * CALL COMMON PARAGRAPH FOR WRITING A ROW.                    *           
      ***************************************************************           
       5100-MOVE-TRAN-HEAD.                                             
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :MH-DATE-TRANS                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :MH-DATE-TRANS = CURRENT DATE                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE '5100'                  TO ACTIVE-PARAGRAPH          
              MOVE 'SELECT'                TO ABEND-FUNCTION            
              MOVE SPACES                  TO ABEND-TABLES              
              MOVE SPACES                  TO ABEND-SQL-PREDICATES      
              MOVE 'CSS_MODEL_SQL'         TO TABLE-1                   
              MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1           
              MOVE PARM-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1         
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           MOVE 'F'                        TO MH-CODE-TRAN-TYPE.        
           MOVE PF-RESP-AREA-ID            TO MH-RESP-AREA-ID.          
           MOVE FF-ACCOUNT-NO              TO MH-ACCOUNT-NO.            
           MOVE ZEROS                      TO MH-CUSTOMER-NO            
                                              MH-PREMISE-NO.            
           MOVE PARM-USERID                TO MH-USER-ID.               
           MOVE PROGRAM-NAME               TO MH-APPL-PROGRAM-ID.       
                                                                        
           PERFORM 7260-SELECT-SPCL-FCTR      THRU 7260-EXIT.           
                                                                        
A05065     MOVE +01                         TO UV-CODE-VALUE-LEN.       
A05065     MOVE PARM-CODE-UTIL-TYPE         TO UV-CODE-VALUE-TEXT.      
A05065     MOVE +14                         TO UV-COLUMN-NA-LEN.        
A05065     MOVE 'CODE_UTIL_TYPE'            TO UV-COLUMN-NA-TEXT.       
A05065     MOVE +18                         TO UV-TABLE-NA-LEN.         
A05065     MOVE 'CSS_RATE_PLAN_DESC'        TO UV-TABLE-NA-TEXT.        
A05065     MOVE 'ALL'                       TO UV-PROGRAM-ID.           
A05065     MOVE AT-COMPANY-NO               TO UV-COMPANY-NO.           
A05065     INITIALIZE UV-CODE-LONG-DESC.                                
A05065     PERFORM 7170-GET-CODE-VALUE            THRU 7170-EXIT.       
A05065                                                                  
A05065     EVALUATE PARM-CODE-UTIL-TYPE                                 
A05065         WHEN 'E'                                                 
A05065              MOVE +8                 TO WS-LEN                   
A05065         WHEN 'G'                                                 
A05065              MOVE +3                 TO WS-LEN                   
A05065         WHEN 'U'                                                 
A05065              MOVE +9                 TO WS-LEN                   
A05065     END-EVALUATE.                                                
A05065                                                                  
A05065     MOVE UV-CODE-LONG-DESC-TEXT(1:WS-LEN)                        
A05065                                      TO WS-UTILITY.              
A05065     MOVE PARM-IC-NO                  TO WS-IC-NO.                
                                                                        
           IF PARM-TRAN-COMMENT > SPACES                                
              STRING PARM-TRAN-COMMENT DELIMITED BY SIZE                
                     INTO MH-TRAN-COMMENT-TEXT                          
              END-STRING                                                
           ELSE                                                         
              MOVE SPACES                  TO MH-TRAN-COMMENT-TEXT      
           END-IF.                                                      
                                                                        
           MOVE LENGTH OF MH-TRAN-COMMENT-TEXT                          
                                           TO MH-TRAN-COMMENT-LEN.      
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * MOVE FIELDS TO THE MAINTENANCE TRANSACTION DETAIL AND       *           
      * CALL COMMON PARAGRAPH FOR WRITING A ROW.                    *           
      ***************************************************************           
       5200-MOVE-INS-TRAN-DET.                                          
                                                                        
             MOVE '5200'                   TO ACTIVE-PARAGRAPH.         
             MOVE MH-TRANS-HIST-SEQ-NO     TO MI-TRANS-HIST-SEQ-NO.     
                                                                        
                                                                        
A05065       MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO.          
A05065       MOVE +04                      TO MI-PRV-COLUMN-VALUE-LEN   
A05065                                        MI-CHG-COLUMN-VALUE-LEN.  
A05065       MOVE WS-IC-NO                 TO MI-CHG-COLUMN-VALUE-TEXT. 
A05065       MOVE WS-IC-NO                 TO MI-PRV-COLUMN-VALUE-TEXT. 
A05065       MOVE 'IC-NO          '        TO MI-COLUMN-DESC.           
A05065       PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.           
A05065       ADD 1                         TO WS-TRAN-APPL-NO.          
A05065                                                                  
A05065                                                                  
A05065       MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO.          
A05065       MOVE +10                      TO MI-PRV-COLUMN-VALUE-LEN   
A05065                                        MI-CHG-COLUMN-VALUE-LEN.  
A05065       MOVE WS-UTILITY               TO MI-CHG-COLUMN-VALUE-TEXT. 
A05065       MOVE WS-UTILITY               TO MI-PRV-COLUMN-VALUE-TEXT. 
A05065       MOVE 'UTILITY        '        TO MI-COLUMN-DESC.           
A05065       PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.           
A05065       ADD 1                         TO WS-TRAN-APPL-NO.          
A05065                                                                  
A05065       MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO.          
A05065       MOVE +12                      TO MI-PRV-COLUMN-VALUE-LEN.  
A05065       MOVE +09                      TO MI-CHG-COLUMN-VALUE-LEN.  
A05065       MOVE WS-FACTOR-ID             TO MI-CHG-COLUMN-VALUE-TEXT. 
A05065       MOVE '**INSERTED**'           TO MI-PRV-COLUMN-VALUE-TEXT. 
A05065       MOVE 'FACTOR-ID      '        TO MI-COLUMN-DESC.           
A05065       PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.           
A05065       ADD 1                         TO WS-TRAN-APPL-NO.          
                                                                        
             MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO.          
             MOVE WS-FACTOR-VALUE-RED      TO WS-HOLD-FACT-VAL-RED.     
             IF WS-FCTR-POWER-10 NOT EQUAL 0                            
                COMPUTE WS-HOLD-FACT-VAL-RED = WS-HOLD-FACT-VAL-RED *   
                        10**WS-FCTR-POWER-10                            
             END-IF.                                                    
             MOVE WS-HOLD-FACT-VAL-RED     TO WS-FACTOR-TEXT.           
             MOVE WS-FACTOR-TEXT           TO WS-FACT-VAL-Z             
             MOVE WS-FACT-VAL-Z            TO MI-CHG-COLUMN-VALUE-TEXT. 
             MOVE '**INSERTED**'           TO MI-PRV-COLUMN-VALUE-TEXT. 
             MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                    
                                           TO MI-PRV-COLUMN-VALUE-LEN   
             MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                    
                                           TO MI-CHG-COLUMN-VALUE-LEN   
             MOVE 'FACTOR-VALUE   '        TO MI-COLUMN-DESC.           
             PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.           
             ADD 1                         TO WS-TRAN-APPL-NO.          
                                                                        
             MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO.          
             MOVE +12                      TO MI-PRV-COLUMN-VALUE-LEN.  
             MOVE +4                       TO MI-CHG-COLUMN-VALUE-LEN.  
             MOVE  WS-BLOCK-NO-9           TO MI-CHG-COLUMN-VALUE-TEXT. 
             MOVE '**INSERTED**'           TO MI-PRV-COLUMN-VALUE-TEXT. 
             MOVE 'BLOCK NO'               TO MI-COLUMN-DESC.           
             MOVE SPACES                   TO MI-TABLE-ID.              
             PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.           
             ADD 1                         TO WS-TRAN-APPL-NO.          
                                                                        
             MOVE MH-TRANS-HIST-SEQ-NO     TO MI-TRANS-HIST-SEQ-NO.     
             MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO.          
             MOVE WS-BASE-AMT-RED          TO WS-HOLD-BASE-AMT-RED      
             MOVE WS-HOLD-BASE-AMT-RED     TO WS-BASE-AMT-TEXT.         
             MOVE WS-BASE-AMT-TEXT         TO WS-FACT-BASE-AMT-Z        
             MOVE WS-FACT-BASE-AMT-Z       TO MI-CHG-COLUMN-VALUE-TEXT. 
             MOVE '**INSERTED**'           TO MI-PRV-COLUMN-VALUE-TEXT. 
             MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                    
                                           TO MI-PRV-COLUMN-VALUE-LEN   
             MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                    
                                           TO MI-CHG-COLUMN-VALUE-LEN   
             MOVE 'BASE AM/ANL MIN'        TO MI-COLUMN-DESC.           
             PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.           
             ADD 1                         TO WS-TRAN-APPL-NO.          
                                                                        
             MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO.          
             MOVE +12                      TO MI-PRV-COLUMN-VALUE-LEN.  
             MOVE +10                      TO MI-CHG-COLUMN-VALUE-LEN.  
             MOVE WS-DATE-FROM             TO MI-CHG-COLUMN-VALUE-TEXT. 
             MOVE '**INSERTED**'           TO MI-PRV-COLUMN-VALUE-TEXT. 
             MOVE 'DATE FROM      '        TO MI-COLUMN-DESC.           
             PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.           
             ADD 1                         TO WS-TRAN-APPL-NO.          
                                                                        
             MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO.          
             MOVE +12                      TO MI-PRV-COLUMN-VALUE-LEN.  
             MOVE +10                      TO MI-CHG-COLUMN-VALUE-LEN.  
             MOVE WS-DATE-TO               TO MI-CHG-COLUMN-VALUE-TEXT. 
             MOVE '**INSERTED**'           TO MI-PRV-COLUMN-VALUE-TEXT. 
             MOVE 'DATE TO        '        TO MI-COLUMN-DESC.           
             PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.           
             ADD 1                         TO WS-TRAN-APPL-NO.          
                                                                        
             MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO.          
             MOVE +12                      TO MI-PRV-COLUMN-VALUE-LEN.  
             MOVE +1                       TO MI-CHG-COLUMN-VALUE-LEN.  
             MOVE WS-SEASON                TO MI-CHG-COLUMN-VALUE-TEXT. 
             MOVE '**INSERTED**'           TO MI-PRV-COLUMN-VALUE-TEXT. 
             MOVE 'SEASON CODE    '        TO MI-COLUMN-DESC.           
             MOVE '42'                     TO MI-TABLE-ID.              
             PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.           
             ADD 1                         TO WS-TRAN-APPL-NO.          
                                                                        
             MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO.          
             MOVE +12                      TO MI-PRV-COLUMN-VALUE-LEN.  
             MOVE +1                       TO MI-CHG-COLUMN-VALUE-LEN.  
             MOVE WS-INSTR-USE             TO MI-CHG-COLUMN-VALUE-TEXT. 
             MOVE '**INSERTED**'           TO MI-PRV-COLUMN-VALUE-TEXT. 
             MOVE 'INSTR USE    '          TO MI-COLUMN-DESC.           
             MOVE '43'                     TO MI-TABLE-ID.              
             PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.           
             ADD 1                         TO WS-TRAN-APPL-NO.          
                                                                        
             MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO.          
             MOVE +12                      TO MI-PRV-COLUMN-VALUE-LEN.  
             MOVE +1                       TO MI-CHG-COLUMN-VALUE-LEN.  
             MOVE WS-TIME-PERIOD           TO MI-CHG-COLUMN-VALUE-TEXT. 
             MOVE '**INSERTED**'           TO MI-PRV-COLUMN-VALUE-TEXT. 
             MOVE 'TIME PERIOD  '          TO MI-COLUMN-DESC.           
             MOVE '44'                     TO MI-TABLE-ID.              
             PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.           
             ADD 1                         TO WS-TRAN-APPL-NO.          
                                                                        
             MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO.          
             MOVE +12                      TO MI-PRV-COLUMN-VALUE-LEN.  
             MOVE +2                       TO MI-CHG-COLUMN-VALUE-LEN.  
             MOVE WS-CMPNT-ID-CD           TO MI-CHG-COLUMN-VALUE-TEXT. 
             MOVE '**INSERTED**'           TO MI-PRV-COLUMN-VALUE-TEXT. 
             MOVE 'COMPONENT ID '          TO MI-COLUMN-DESC.           
             MOVE 'N6'                     TO MI-TABLE-ID.              
             PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.           
             ADD 1                         TO WS-TRAN-APPL-NO.          
                                                                        
             MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO.          
             MOVE +12                      TO MI-PRV-COLUMN-VALUE-LEN.  
             MOVE +2                       TO MI-CHG-COLUMN-VALUE-LEN.  
             MOVE  WS-FIXED-FCTR-TYP-CD    TO MI-CHG-COLUMN-VALUE-TEXT. 
             MOVE '**INSERTED**'           TO MI-PRV-COLUMN-VALUE-TEXT. 
             MOVE 'FXD FCTR TYP CD'        TO MI-COLUMN-DESC.           
             MOVE 'FT'                     TO MI-TABLE-ID.              
             PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.           
             ADD 1                         TO WS-TRAN-APPL-NO.          
                                                                        
             IF SEB-DATABASE                                            
                MOVE MH-TRANS-HIST-SEQ-NO  TO MI-TRANS-HIST-SEQ-NO      
                MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO           
                IF WS-DURATION-REMAIN-NO EQUAL SPACES                   
                   MOVE SPACES             TO MI-CHG-COLUMN-VALUE-TEXT  
                ELSE                                                    
                   MOVE WS-DURATION-REMAIN-NO-NUM                       
                                           TO MI-CHG-COLUMN-VALUE-TEXT  
                END-IF                                                  
                MOVE '**INSERTED**'        TO MI-PRV-COLUMN-VALUE-TEXT  
                MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                 
                                           TO MI-PRV-COLUMN-VALUE-LEN   
                MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                 
                                           TO MI-CHG-COLUMN-VALUE-LEN   
                MOVE 'DURATION REMAIN NO'  TO MI-COLUMN-DESC            
                MOVE SPACES                TO MI-TABLE-ID               
                PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT         
                ADD 1 TO WS-TRAN-APPL-NO                                
                IF WS-RTPK-UPD-REQ-IND  =  'Y'                          
                   MOVE MH-TRANS-HIST-SEQ-NO TO MI-TRANS-HIST-SEQ-NO    
                   MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO         
                   MOVE WS-OLD-DF-STATUS-CD  TO MI-PRV-COLUMN-VALUE-TEXT
                   MOVE DF-STATUS-CD         TO MI-CHG-COLUMN-VALUE-TEXT
                   MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT              
                                             TO MI-PRV-COLUMN-VALUE-LEN 
                   MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT              
                                             TO MI-CHG-COLUMN-VALUE-LEN 
                   MOVE 'STATUS CD'          TO MI-COLUMN-DESC          
                   MOVE SPACES               TO MI-TABLE-ID             
                   PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT      
                   ADD 1 TO WS-TRAN-APPL-NO                             
                END-IF                                                  
                IF WS-UPD-RTPK-STAT-ADJ-CD   EQUAL 'Y' AND              
                   WS-OLD-DF-STAT-ADJ-CD NOT EQUAL DF-STAT-ADJUSTABLE-CD
                   MOVE MH-TRANS-HIST-SEQ-NO TO MI-TRANS-HIST-SEQ-NO    
                   MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO         
                   MOVE WS-OLD-DF-STAT-ADJ-CD                           
                                             TO MI-PRV-COLUMN-VALUE-TEXT
                   MOVE DF-STAT-ADJUSTABLE-CD                           
                                             TO MI-CHG-COLUMN-VALUE-TEXT
                   MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT              
                                             TO MI-PRV-COLUMN-VALUE-LEN 
                   MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT              
                                             TO MI-CHG-COLUMN-VALUE-LEN 
                   MOVE 'ADJUSTABLE CD'      TO MI-COLUMN-DESC          
                   MOVE SPACES               TO MI-TABLE-ID             
                   PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT      
                   ADD 1                     TO WS-TRAN-APPL-NO         
                END-IF                                                  
             END-IF.                                                    
                                                                        
             IF CSR-DATABASE AND SF-DEFLT-DURATION-NO > 0               
                MOVE MH-TRANS-HIST-SEQ-NO   TO MI-TRANS-HIST-SEQ-NO     
                MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO          
                MOVE SF-DEFLT-DURATION-NO   TO MI-CHG-COLUMN-VALUE-TEXT 
                MOVE '**INSERTED**'         TO MI-PRV-COLUMN-VALUE-TEXT 
                MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                 
                                            TO MI-PRV-COLUMN-VALUE-LEN  
                MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                 
                                            TO MI-CHG-COLUMN-VALUE-LEN  
                MOVE 'DURATION REMAIN NO'   TO MI-COLUMN-DESC           
                MOVE SPACES                 TO MI-TABLE-ID              
                PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT         
                ADD 1 TO WS-TRAN-APPL-NO                                
             END-IF.                                                    
                                                                        
       5200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * MOVE FIELDS TO THE MAINTENANCE TRANSACTION DETAIL AND       *           
      * CALL COMMON PARAGRAPH FOR WRITING A ROW.                    *           
      ***************************************************************           
       5300-MOVE-UPD-TRAN-DET.                                          
                                                                        
             MOVE '5300'                     TO ACTIVE-PARAGRAPH.       
             MOVE MH-TRANS-HIST-SEQ-NO       TO MI-TRANS-HIST-SEQ-NO.   
                                                                        
                                                                        
A05065       MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO.          
A05065       MOVE +04                      TO MI-PRV-COLUMN-VALUE-LEN   
A05065                                        MI-CHG-COLUMN-VALUE-LEN.  
A05065       MOVE WS-IC-NO                 TO MI-CHG-COLUMN-VALUE-TEXT. 
A05065       MOVE WS-IC-NO                 TO MI-PRV-COLUMN-VALUE-TEXT. 
A05065       MOVE 'IC-NO          '        TO MI-COLUMN-DESC.           
A05065       PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.           
A05065       ADD 1                         TO WS-TRAN-APPL-NO.          
A05065                                                                  
A05065                                                                  
A05065       MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO.          
A05065       MOVE +10                      TO MI-PRV-COLUMN-VALUE-LEN   
A05065                                        MI-CHG-COLUMN-VALUE-LEN.  
A05065       MOVE WS-UTILITY               TO MI-CHG-COLUMN-VALUE-TEXT. 
A05065       MOVE WS-UTILITY               TO MI-PRV-COLUMN-VALUE-TEXT. 
A05065       MOVE 'UTILITY        '        TO MI-COLUMN-DESC.           
A05065       PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.           
A05065       ADD 1                         TO WS-TRAN-APPL-NO.          
A05065                                                                  
A05065                                                                  
A05065       MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO.          
A05065       MOVE +09                      TO MI-PRV-COLUMN-VALUE-LEN.  
A05065       MOVE +09                      TO MI-CHG-COLUMN-VALUE-LEN.  
A05065       MOVE WS-FACTOR-ID             TO MI-CHG-COLUMN-VALUE-TEXT. 
A05065       MOVE WS-FACTOR-ID             TO MI-PRV-COLUMN-VALUE-TEXT. 
A05065       MOVE 'FACTOR-ID      '        TO MI-COLUMN-DESC.           
A05065       PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.           
A05065       ADD 1                         TO WS-TRAN-APPL-NO.          
                                                                        
             MOVE WS-TRAN-APPL-NO            TO MI-TRAN-APPL-NO.        
             MOVE WS-FACTOR-VALUE-RED        TO WS-FACTOR-VAL.          
             IF WS-FACTOR-VALUE-RED NOT EQUAL FF-FACTOR                 
                 MOVE FF-FACTOR              TO WS-HOLD-FACT-VAL-RED    
                 IF WS-FCTR-POWER-10 NOT EQUAL 0                        
                   COMPUTE WS-HOLD-FACT-VAL-RED = WS-HOLD-FACT-VAL-RED *
                                                   10**WS-FCTR-POWER-10 
                 END-IF                                                 
                 MOVE WS-HOLD-FACT-VAL-RED   TO WS-FACTOR-TEXT          
                 MOVE WS-FACTOR-TEXT         TO WS-FACT-VAL-Z           
                 MOVE WS-FACT-VAL-Z          TO MI-PRV-COLUMN-VALUE-TEXT
                 MOVE WS-FACTOR-VALUE-RED    TO WS-HOLD-FACT-VAL-RED    
                 IF WS-FCTR-POWER-10 NOT EQUAL 0                        
                   COMPUTE WS-HOLD-FACT-VAL-RED = WS-HOLD-FACT-VAL-RED *
                                                   10**WS-FCTR-POWER-10 
                 END-IF                                                 
                 MOVE WS-HOLD-FACT-VAL-RED   TO WS-FACTOR-TEXT          
                 MOVE WS-FACTOR-TEXT         TO WS-FACT-VAL-Z           
                 MOVE WS-FACT-VAL-Z          TO MI-CHG-COLUMN-VALUE-TEXT
                 MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                
                                             TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                
                                             TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE 'FACTOR-VALUE   '      TO MI-COLUMN-DESC          
                 PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
                 ADD 1       TO WS-TRAN-APPL-NO                         
             END-IF.                                                    
                                                                        
             MOVE WS-TRAN-APPL-NO            TO MI-TRAN-APPL-NO.        
             IF WS-BLOCK-NO-9       NOT EQUAL FF-BLOCK-NO               
                 MOVE FF-BLOCK-NO            TO MI-PRV-COLUMN-VALUE-TEXT
                 MOVE WS-BLOCK-NO-9          TO MI-CHG-COLUMN-VALUE-TEXT
                 MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                
                                             TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                
                                             TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE 'BLOCK NO'             TO MI-COLUMN-DESC          
                 PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
                 ADD 1       TO WS-TRAN-APPL-NO                         
             END-IF.                                                    
                                                                        
             MOVE MH-TRANS-HIST-SEQ-NO       TO MI-TRANS-HIST-SEQ-NO.   
             MOVE WS-TRAN-APPL-NO            TO MI-TRAN-APPL-NO.        
             IF WS-BASE-AMT-RED NOT EQUAL WS-BASE-AMT-TRANS             
                 MOVE +11                    TO MI-PRV-COLUMN-VALUE-LEN 
                                                MI-CHG-COLUMN-VALUE-LEN 
                 MOVE WS-BASE-AMT-TRANS      TO WS-HOLD-BASE-AMT-RED    
                 MOVE WS-HOLD-BASE-AMT-RED   TO WS-BASE-AMT-TEXT        
                 MOVE WS-BASE-AMT-TEXT       TO WS-FACT-BASE-AMT-Z      
                 MOVE WS-FACT-BASE-AMT-Z     TO MI-PRV-COLUMN-VALUE-TEXT
                 MOVE WS-BASE-AMT-RED        TO WS-HOLD-BASE-AMT-RED    
                 MOVE WS-HOLD-BASE-AMT-RED   TO WS-BASE-AMT-TEXT        
                 MOVE WS-BASE-AMT-TEXT       TO WS-FACT-BASE-AMT-Z      
                 MOVE WS-FACT-BASE-AMT-Z     TO MI-CHG-COLUMN-VALUE-TEXT
                 MOVE 'BASE AM/ANL MIN'      TO MI-COLUMN-DESC          
                 PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
                 ADD 1                       TO WS-TRAN-APPL-NO         
             END-IF.                                                    
                                                                        
             MOVE WS-TRAN-APPL-NO            TO MI-TRAN-APPL-NO.        
             IF WS-DATE-FROM NOT EQUAL FF-EFF-DATE-FROM                 
                 MOVE +10                    TO MI-PRV-COLUMN-VALUE-LEN 
                                                MI-CHG-COLUMN-VALUE-LEN 
                 MOVE WS-DATE-FROM           TO MI-CHG-COLUMN-VALUE-TEXT
                 MOVE FF-EFF-DATE-FROM       TO MI-PRV-COLUMN-VALUE-TEXT
                 MOVE 'DATE FROM      '      TO MI-COLUMN-DESC          
                 PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
                 ADD 1 TO WS-TRAN-APPL-NO                               
             END-IF.                                                    
                                                                        
             MOVE WS-TRAN-APPL-NO            TO MI-TRAN-APPL-NO.        
             IF WS-DATE-TO  NOT EQUAL FF-EFF-DATE-TO                    
                IF WS-FACTOR-ID  EQUAL 'ONERATE  '                      
                   MOVE WS-DATE-TO           TO WS-HOLD-DATE-TO         
                   MOVE WS-HOLD-DATE-YR      TO WS-ONERATE-ANNIV-YR     
                   MOVE WS-HOLD-DATE-MO      TO WS-ONERATE-ANNIV-MO     
                   MOVE WS-ONERATE-ANNIV     TO WS-ONERATE-ANNIV-X      
                   MOVE WS-ONERATE-ANNIV-X   TO WS-ONERATE-ANNIV-N      
                   MOVE WS-ONERATE-ANNIV-N   TO WS-ONERATE-ANNIV-RED    
                   PERFORM 8700-UPDATE-UTIL-ENV THRU 8700-EXIT          
                END-IF                                                  
                MOVE +10                     TO MI-PRV-COLUMN-VALUE-LEN 
                                                MI-CHG-COLUMN-VALUE-LEN 
                MOVE WS-DATE-TO              TO MI-CHG-COLUMN-VALUE-TEXT
                MOVE FF-EFF-DATE-TO          TO MI-PRV-COLUMN-VALUE-TEXT
                MOVE 'DATE TO        '       TO MI-COLUMN-DESC          
                PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT         
                ADD 1 TO WS-TRAN-APPL-NO                                
             END-IF.                                                    
                                                                        
             MOVE WS-TRAN-APPL-NO            TO MI-TRAN-APPL-NO.        
             IF WS-SEASON NOT EQUAL FF-CODE-SEASON                      
                 MOVE +1                     TO MI-PRV-COLUMN-VALUE-LEN 
                                                MI-CHG-COLUMN-VALUE-LEN 
                 MOVE WS-SEASON              TO MI-CHG-COLUMN-VALUE-TEXT
                 MOVE FF-CODE-SEASON         TO MI-PRV-COLUMN-VALUE-TEXT
                 MOVE 'SEASON CODE    '      TO MI-COLUMN-DESC          
                 MOVE '42'                   TO MI-TABLE-ID             
                 PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
                 ADD 1                       TO WS-TRAN-APPL-NO         
             END-IF.                                                    
                                                                        
             MOVE WS-TRAN-APPL-NO            TO MI-TRAN-APPL-NO.        
             IF WS-INSTR-USE NOT EQUAL FF-INSTR-USE-TYPE-CD             
                 MOVE +1                     TO MI-PRV-COLUMN-VALUE-LEN 
                                                MI-CHG-COLUMN-VALUE-LEN 
                 MOVE WS-INSTR-USE           TO MI-CHG-COLUMN-VALUE-TEXT
                 MOVE FF-INSTR-USE-TYPE-CD   TO MI-PRV-COLUMN-VALUE-TEXT
                 MOVE 'INSTR CODE'           TO MI-COLUMN-DESC          
                 MOVE '43'                   TO MI-TABLE-ID             
                 PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
                 ADD 1                       TO WS-TRAN-APPL-NO         
             END-IF.                                                    
                                                                        
             MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO.                   
             IF WS-TIME-PERIOD NOT EQUAL FF-CODE-TIME-PERIOD            
                 MOVE +1                     TO MI-PRV-COLUMN-VALUE-LEN 
                                                MI-CHG-COLUMN-VALUE-LEN 
                 MOVE WS-TIME-PERIOD         TO MI-CHG-COLUMN-VALUE-TEXT
                 MOVE FF-CODE-TIME-PERIOD    TO MI-PRV-COLUMN-VALUE-TEXT
                 MOVE 'TIME PERIOD'          TO MI-COLUMN-DESC          
                 MOVE '44'                   TO MI-TABLE-ID             
                 PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
                 ADD 1                       TO WS-TRAN-APPL-NO         
             END-IF.                                                    
                                                                        
             MOVE WS-TRAN-APPL-NO            TO MI-TRAN-APPL-NO.        
             IF WS-CMPNT-ID-CD NOT EQUAL FF-CMPNT-ID-CD                 
A05065          MOVE +2                      TO MI-PRV-COLUMN-VALUE-LEN 
                                                MI-CHG-COLUMN-VALUE-LEN 
                MOVE WS-CMPNT-ID-CD          TO MI-CHG-COLUMN-VALUE-TEXT
                MOVE FF-CMPNT-ID-CD          TO MI-PRV-COLUMN-VALUE-TEXT
                MOVE 'COMPONENT ID'          TO MI-COLUMN-DESC          
                MOVE 'N6'                    TO MI-TABLE-ID             
                PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT         
                ADD 1 TO WS-TRAN-APPL-NO                                
             END-IF.                                                    
                                                                        
             MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO.                   
             IF WS-FIXED-FCTR-TYP-CD  NOT EQUAL FF-FIXED-FCTR-TYP-CD    
                MOVE +2  TO MI-PRV-COLUMN-VALUE-LEN                     
                            MI-CHG-COLUMN-VALUE-LEN                     
                MOVE WS-FIXED-FCTR-TYP-CD   TO MI-CHG-COLUMN-VALUE-TEXT 
                MOVE FF-FIXED-FCTR-TYP-CD   TO MI-PRV-COLUMN-VALUE-TEXT 
                MOVE 'FXD FCTR TYP CD'      TO MI-COLUMN-DESC           
                MOVE 'FT'                   TO MI-TABLE-ID              
                PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT         
                ADD 1 TO WS-TRAN-APPL-NO                                
             END-IF.                                                    
                                                                        
             IF SEB-DATABASE AND                                        
                  (WS-DURATION-REMAIN-NO-NUM NOT EQUAL                  
                                     FF-DURATION-REMAIN-NO )            
                MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO          
                MOVE MH-TRANS-HIST-SEQ-NO   TO MI-TRANS-HIST-SEQ-NO     
                IF WS-DURATION-REMAIN-NO EQUAL SPACES                   
                   MOVE SPACES              TO MI-CHG-COLUMN-VALUE-TEXT 
                ELSE                                                    
                   MOVE WS-DURATION-REMAIN-NO-NUM                       
                                            TO MI-CHG-COLUMN-VALUE-TEXT 
                END-IF                                                  
                MOVE FF-DURATION-REMAIN-NO TO MI-PRV-COLUMN-VALUE-TEXT  
                MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                 
                                            TO MI-PRV-COLUMN-VALUE-LEN  
                MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                 
                                            TO MI-CHG-COLUMN-VALUE-LEN  
                MOVE 'DURATION REMAIN NO'   TO MI-COLUMN-DESC           
                MOVE SPACES                 TO MI-TABLE-ID              
                PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT         
                ADD 1 TO WS-TRAN-APPL-NO                                
                IF WS-RTPK-UPD-REQ-IND  =  'Y'                          
                   MOVE MH-TRANS-HIST-SEQ-NO TO MI-TRANS-HIST-SEQ-NO    
                   MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO         
                   MOVE WS-OLD-DF-STATUS-CD  TO MI-PRV-COLUMN-VALUE-TEXT
                   MOVE DF-STATUS-CD         TO MI-CHG-COLUMN-VALUE-TEXT
                   MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT              
                                             TO MI-PRV-COLUMN-VALUE-LEN 
                   MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT              
                                             TO MI-CHG-COLUMN-VALUE-LEN 
                   MOVE 'STATUS CD'          TO MI-COLUMN-DESC          
                   MOVE SPACES               TO MI-TABLE-ID             
                   PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT      
                   ADD 1 TO WS-TRAN-APPL-NO                             
                END-IF                                                  
                IF WS-UPD-RTPK-STAT-ADJ-CD   EQUAL 'Y' AND              
                   WS-CURRENT-ADJ-FACTOR     EQUAL 'Y' AND              
                   WS-OLD-DF-STAT-ADJ-CD NOT EQUAL                      
                                                DF-STAT-ADJUSTABLE-CD   
                   MOVE MH-TRANS-HIST-SEQ-NO TO MI-TRANS-HIST-SEQ-NO    
                   MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO         
                   MOVE WS-OLD-DF-STAT-ADJ-CD                           
                                             TO MI-PRV-COLUMN-VALUE-TEXT
                   MOVE DF-STAT-ADJUSTABLE-CD                           
                                             TO MI-CHG-COLUMN-VALUE-TEXT
                   MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT              
                                             TO MI-PRV-COLUMN-VALUE-LEN 
                   MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT              
                                             TO MI-CHG-COLUMN-VALUE-LEN 
                   MOVE 'ADJUSTABLE CD'      TO MI-COLUMN-DESC          
                   MOVE SPACES               TO MI-TABLE-ID             
                   PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT      
                   ADD 1                     TO WS-TRAN-APPL-NO         
                END-IF                                                  
             END-IF.                                                    
                                                                        
       5300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * MOVE FIELDS TO THE MAINTENANCE TRANSACTION DETAIL AND       *           
      * CALL COMMON PARAGRAPH FOR WRITING A ROW.                    *           
      ***************************************************************           
       5400-MOVE-DEL-TRAN-DET.                                          
                                                                        
             MOVE '5400' TO ACTIVE-PARAGRAPH.                           
             MOVE MH-TRANS-HIST-SEQ-NO      TO MI-TRANS-HIST-SEQ-NO.    
                                                                        
A05065       MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO.          
A05065       MOVE +04                      TO MI-PRV-COLUMN-VALUE-LEN   
A05065                                        MI-CHG-COLUMN-VALUE-LEN.  
A05065       MOVE WS-IC-NO                 TO MI-CHG-COLUMN-VALUE-TEXT. 
A05065       MOVE WS-IC-NO                 TO MI-PRV-COLUMN-VALUE-TEXT. 
A05065       MOVE 'IC-NO          '        TO MI-COLUMN-DESC.           
A05065       PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.           
A05065       ADD 1                         TO WS-TRAN-APPL-NO.          
A05065                                                                  
A05065                                                                  
A05065       MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO.          
A05065       MOVE +10                      TO MI-PRV-COLUMN-VALUE-LEN   
A05065                                        MI-CHG-COLUMN-VALUE-LEN.  
A05065       MOVE WS-UTILITY               TO MI-CHG-COLUMN-VALUE-TEXT. 
A05065       MOVE WS-UTILITY               TO MI-PRV-COLUMN-VALUE-TEXT. 
A05065       MOVE 'UTILITY        '        TO MI-COLUMN-DESC.           
A05065       PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.           
A05065       ADD 1                         TO WS-TRAN-APPL-NO.          
A05065                                                                  
A05065       MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO.                   
A05065       MOVE +09                       TO MI-PRV-COLUMN-VALUE-LEN. 
A05065       MOVE +11                       TO MI-CHG-COLUMN-VALUE-LEN. 
A05065       MOVE '**DELETED**'             TO MI-CHG-COLUMN-VALUE-TEXT.
A05065       MOVE WS-FACTOR-ID              TO MI-PRV-COLUMN-VALUE-TEXT.
A05065       MOVE 'FACTOR-ID      '         TO MI-COLUMN-DESC.          
A05065       PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.           
A05065       ADD 1                          TO WS-TRAN-APPL-NO.         
A05065                                                                  
             MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO.         
             MOVE '**DELETED**'             TO MI-CHG-COLUMN-VALUE-TEXT.
             MOVE FF-FACTOR                 TO WS-HOLD-FACT-VAL-RED.    
             IF WS-FCTR-POWER-10 NOT EQUAL 0                            
                COMPUTE WS-HOLD-FACT-VAL-RED = WS-HOLD-FACT-VAL-RED *   
                        10**WS-FCTR-POWER-10                            
             END-IF.                                                    
             MOVE WS-HOLD-FACT-VAL-RED      TO WS-FACTOR-TEXT.          
             MOVE WS-FACTOR-TEXT            TO WS-FACT-VAL-Z            
             MOVE WS-FACT-VAL-Z             TO MI-PRV-COLUMN-VALUE-TEXT.
             MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                    
                                            TO MI-PRV-COLUMN-VALUE-LEN. 
             MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                    
                                            TO MI-CHG-COLUMN-VALUE-LEN. 
             MOVE 'FACTOR-VALUE   '         TO MI-COLUMN-DESC.          
             PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.           
             ADD 1                          TO WS-TRAN-APPL-NO.         
                                                                        
             MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO.                   
             MOVE +4  TO MI-PRV-COLUMN-VALUE-LEN.                       
             MOVE +11  TO MI-CHG-COLUMN-VALUE-LEN.                      
             MOVE '**DELETED**'          TO MI-CHG-COLUMN-VALUE-TEXT.   
             MOVE FF-BLOCK-NO            TO MI-PRV-COLUMN-VALUE-TEXT.   
             MOVE 'BLOCK NO'             TO MI-COLUMN-DESC.             
             MOVE SPACES                 TO MI-TABLE-ID                 
             PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.           
             ADD 1 TO WS-TRAN-APPL-NO.                                  
                                                                        
             MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO.                   
             MOVE +10                       TO MI-PRV-COLUMN-VALUE-LEN. 
             MOVE +11                       TO MI-CHG-COLUMN-VALUE-LEN. 
             MOVE '**DELETED**'             TO MI-CHG-COLUMN-VALUE-TEXT.
             MOVE FF-EFF-DATE-FROM          TO MI-PRV-COLUMN-VALUE-TEXT.
             MOVE 'DATE FROM      '         TO MI-COLUMN-DESC.          
             PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.           
             ADD 1                          TO WS-TRAN-APPL-NO.         
                                                                        
             MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO.         
             MOVE +10                       TO MI-PRV-COLUMN-VALUE-LEN. 
             MOVE +11                       TO MI-CHG-COLUMN-VALUE-LEN. 
             MOVE '**DELETED**'             TO MI-CHG-COLUMN-VALUE-TEXT.
             MOVE FF-EFF-DATE-TO            TO MI-PRV-COLUMN-VALUE-TEXT.
             MOVE 'DATE TO        '         TO MI-COLUMN-DESC.          
             PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.           
             ADD 1                          TO WS-TRAN-APPL-NO.         
                                                                        
             MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO.         
             MOVE +1 TO MI-PRV-COLUMN-VALUE-LEN.                        
             MOVE +11 TO MI-CHG-COLUMN-VALUE-LEN.                       
             MOVE '**DELETED**'       TO MI-CHG-COLUMN-VALUE-TEXT.      
             MOVE FF-CODE-SEASON      TO MI-PRV-COLUMN-VALUE-TEXT.      
             MOVE 'SEASON CODE    '   TO MI-COLUMN-DESC.                
             MOVE '42'                TO MI-TABLE-ID                    
             PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.           
             ADD 1 TO WS-TRAN-APPL-NO.                                  
                                                                        
             MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO.                   
             MOVE +1  TO MI-PRV-COLUMN-VALUE-LEN.                       
             MOVE +11  TO MI-CHG-COLUMN-VALUE-LEN.                      
             MOVE '**DELETED**'        TO MI-CHG-COLUMN-VALUE-TEXT.     
             MOVE FF-INSTR-USE-TYPE-CD TO MI-PRV-COLUMN-VALUE-TEXT.     
             MOVE 'INSTR CODE'         TO MI-COLUMN-DESC.               
             MOVE '43'                 TO MI-TABLE-ID                   
             PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.           
             ADD 1                     TO WS-TRAN-APPL-NO.              
                                                                        
             MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO.              
             MOVE +1                   TO MI-PRV-COLUMN-VALUE-LEN.      
             MOVE +11                  TO MI-CHG-COLUMN-VALUE-LEN.      
             MOVE '**DELETED**'        TO MI-CHG-COLUMN-VALUE-TEXT.     
             MOVE FF-CODE-TIME-PERIOD  TO MI-PRV-COLUMN-VALUE-TEXT.     
             MOVE 'TIME PERIOD'        TO MI-COLUMN-DESC.               
             MOVE '44'                 TO MI-TABLE-ID                   
             PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.           
                                                                        
             ADD 1                     TO WS-TRAN-APPL-NO.              
             MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO.              
A05065       MOVE +2                   TO MI-PRV-COLUMN-VALUE-LEN.      
             MOVE +11                  TO MI-CHG-COLUMN-VALUE-LEN.      
             MOVE '**DELETED**'        TO MI-CHG-COLUMN-VALUE-TEXT.     
             MOVE FF-CMPNT-ID-CD       TO MI-PRV-COLUMN-VALUE-TEXT.     
             MOVE 'COMPONENT ID'       TO MI-COLUMN-DESC.               
             MOVE 'N6'                 TO MI-TABLE-ID                   
             PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.           
             ADD 1                     TO WS-TRAN-APPL-NO.              
                                                                        
             MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO.              
             MOVE +2                   TO MI-PRV-COLUMN-VALUE-LEN.      
             MOVE +11                  TO MI-CHG-COLUMN-VALUE-LEN.      
             MOVE '**DELETED**'        TO MI-CHG-COLUMN-VALUE-TEXT.     
             MOVE FF-FIXED-FCTR-TYP-CD   TO MI-PRV-COLUMN-VALUE-TEXT.   
A05065       MOVE 'FXD FCTR TYP CD'      TO MI-COLUMN-DESC.             
             MOVE 'FT'                   TO MI-TABLE-ID                 
             PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.           
             ADD 1                     TO WS-TRAN-APPL-NO.              
                                                                        
             IF SEB-DATABASE                                            
                MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO           
                MOVE '**DELETED**'         TO MI-CHG-COLUMN-VALUE-TEXT  
                MOVE FF-DURATION-REMAIN-NO TO MI-PRV-COLUMN-VALUE-TEXT  
                MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                 
                                           TO MI-PRV-COLUMN-VALUE-LEN   
                MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                 
                                           TO MI-CHG-COLUMN-VALUE-LEN   
                MOVE 'DURATION REMAIN NO'  TO MI-COLUMN-DESC            
                MOVE SPACES                TO MI-TABLE-ID               
                PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT         
                ADD 1 TO WS-TRAN-APPL-NO                                
                IF WS-UPD-RTPK-STAT-ADJ-CD   EQUAL 'Y' AND              
                   WS-CURRENT-ADJ-FACTOR     EQUAL 'Y' AND              
                   WS-OLD-DF-STAT-ADJ-CD NOT EQUAL                      
                                         DF-STAT-ADJUSTABLE-CD          
                   MOVE MH-TRANS-HIST-SEQ-NO TO MI-TRANS-HIST-SEQ-NO    
                   MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO         
                   MOVE WS-OLD-DF-STAT-ADJ-CD                           
                                             TO MI-PRV-COLUMN-VALUE-TEXT
                   MOVE DF-STAT-ADJUSTABLE-CD                           
                                             TO MI-CHG-COLUMN-VALUE-TEXT
                   MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT              
                                             TO MI-PRV-COLUMN-VALUE-LEN 
                   MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT              
                                             TO MI-CHG-COLUMN-VALUE-LEN 
                   MOVE 'ADJUSTABLE CD'      TO MI-COLUMN-DESC          
                   MOVE SPACES               TO MI-TABLE-ID             
                   PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT      
                   ADD 1                     TO WS-TRAN-APPL-NO         
                END-IF                                                  
             END-IF.                                                    
                                                                        
       5400-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CHECK THE FACTOR VALUE WITH THE DELINQ-VALUE FOR HIGH OR LOW  *        
      ******************************************************************        
       5500-CHECK-HIGH-LOW.                                             
      *                                                                         
           IF SEB-DATABASE                                              
              IF WS-FACTOR-ID EQUAL 'DDC'                               
                 PERFORM 5550-LOAD-MIN-MAX-DDC  THRU 5550-EXIT          
                 MOVE SPACES                    TO WS-CODE-REVENUE-CLASS
                 PERFORM 7300-GET-REVENUE-CLASS THRU 7300-EXIT          
                 IF WS-CODE-REVENUE-CLASS (2:1) = '1'                   
                    IF WS-FACTOR-VALUE-RED < WS-RES-MIN-DDC  OR         
                                           > WS-RES-MAX-DDC             
                       MOVE 'MRM0000025'  TO S-BUS-RULE-ID              
                       MOVE WS-FAILED     TO S-BUS-RULE-RESULT-CD       
                       PERFORM 5800-MOVE-BUSINESS-RULE                  
                                             THRU 5800-EXIT             
                    END-IF                                              
                 ELSE                                                   
                  IF WS-CODE-REVENUE-CLASS (2:1) =  '2'                 
                    IF WS-FACTOR-VALUE-RED < WS-COM-MIN-DDC  OR         
                                           > WS-COM-MAX-DDC             
                       MOVE 'MRM0000025'  TO S-BUS-RULE-ID              
                       MOVE WS-FAILED     TO S-BUS-RULE-RESULT-CD       
                       PERFORM 5800-MOVE-BUSINESS-RULE                  
                                             THRU 5800-EXIT             
                    END-IF                                              
                  END-IF                                                
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
       5500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       5550-LOAD-MIN-MAX-DDC.                                           
      *                                                                         
           MOVE WS-RES-MIN-CD                   TO C8-DELINQ-CD.        
           PERFORM 7350-SELECT-DELINQUENCY      THRU 7350-EXIT.         
           MOVE C8-DELINQ-VALUE                 TO WS-RES-MIN-DDC.      
           MOVE WS-RES-MAX-CD                   TO C8-DELINQ-CD.        
           PERFORM 7350-SELECT-DELINQUENCY      THRU 7350-EXIT.         
           MOVE C8-DELINQ-VALUE                 TO WS-RES-MAX-DDC.      
           MOVE WS-COM-MIN-CD                   TO C8-DELINQ-CD.        
           PERFORM 7350-SELECT-DELINQUENCY      THRU 7350-EXIT.         
           MOVE C8-DELINQ-VALUE                 TO WS-COM-MIN-DDC.      
           MOVE WS-COM-MAX-CD                   TO C8-DELINQ-CD.        
           PERFORM 7350-SELECT-DELINQUENCY      THRU 7350-EXIT.         
           MOVE C8-DELINQ-VALUE                 TO WS-COM-MAX-DDC.      
      *                                                                         
       5550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 5750-MOVE-FACTOR-VALUES.                                      *         
      *****************************************************************         
       5750-MOVE-FACTOR-VALUES.                                         
                                                                        
           MOVE WS-DATE-FROM                 TO FF-EFF-DATE-FROM.       
           MOVE WS-DATE-TO                   TO FF-EFF-DATE-TO.         
           MOVE WS-SEASON                    TO FF-CODE-SEASON.         
           MOVE WS-INSTR-USE                 TO FF-INSTR-USE-TYPE-CD.   
           MOVE WS-CODE-TIME-PERIOD          TO WS-TIME-PERIOD.         
           MOVE WS-TIME-PERIOD               TO FF-CODE-TIME-PERIOD.    
           MOVE WS-CMPNT-ID-CD               TO FF-CMPNT-ID-CD.         
           MOVE WS-FIXED-FCTR-TYP-CD         TO FF-FIXED-FCTR-TYP-CD.   
           MOVE WS-FACT-VALUE-AM             TO WS-FACTOR-VALUE         
                                                                        
           IF WS-FACT-VALUE-SI = '-'                                    
              COMPUTE WS-FACTOR-VALUE-RED = WS-FACTOR-VALUE-RED * -1    
           END-IF                                                       
                                                                        
           IF WS-FCTR-POWER-10 NOT EQUAL 0                              
              COMPUTE WS-FACTOR-VALUE-RED = WS-FACTOR-VALUE-RED *       
                      (10 **(WS-FCTR-POWER-10 * -1))                    
           END-IF                                                       
           MOVE WS-FACTOR-VALUE-RED          TO FF-FACTOR               
           MOVE WS-FXD-FCTR-SEQ-NO           TO WS-FIXED-FCTR-SEQ-NO.   
           MOVE WS-FIXED-FCTR-SEQ-NO         TO FF-FIXED-FCTR-SEQ-NO.   
           MOVE WS-BLOCK-NO-9                TO FF-BLOCK-NO.            
           IF SEB-DATABASE                                              
              MOVE WS-DURATION-REMAIN-NO-NUM TO FF-DURATION-REMAIN-NO   
           ELSE                                                         
              EVALUATE TRUE                                             
                WHEN (CSR-DATABASE AND SF-DEFLT-DURATION-NO > 0 AND     
                      WS-UPDATE-FLAG = 'I' )                            
                     MOVE SF-DEFLT-DURATION-NO TO FF-DURATION-REMAIN-NO 
                WHEN (CSR-DATABASE AND SF-DEFLT-DURATION-NO > 0 AND     
                      WS-UPDATE-FLAG = 'U' )                            
                     MOVE WS-DURATION-REMAIN-NO-NUM                     
                                               TO FF-DURATION-REMAIN-NO 
                WHEN OTHER                                              
                  SET DURATION-REMAIN-NULL     TO TRUE                  
              END-EVALUATE                                              
           END-IF.                                                      
                                                                        
       5750-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 5800-MOVE-BUSINESS-RULE.                                      *         
      *****************************************************************         
       5800-MOVE-BUSINESS-RULE.                                         
                                                                        
           IF S-BUS-RULE-ID GREATER THAN SPACES                         
              PERFORM 7550-GET-RULE-XREF-ID    THRU 7550-EXIT           
           END-IF.                                                      
                                                                        
           MOVE 0                           TO S-APPL-RETURN-CODE.      
           PERFORM 8100-SEND-RESULT            THRU 8100-EXIT.          
           PERFORM 9999-END-PROGRAM            THRU 9999-EXIT.          
                                                                        
       5800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 6000-CREATE-FACTOR.                                            *        
      ******************************************************************        
       6000-CREATE-FACTOR.                                              
                                                                        
           CALL MCSCB065 USING CPD00065-FIELDS,                         
                               ABEND-FILE.                              
                                                                        
           MOVE WS-CPD65-RETURN-CODE          TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL ZEROES                        
              PERFORM 8100-SEND-RESULT        THRU 8100-EXIT            
           ELSE                                                         
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE WS-ACTIVE-RETURN-CODE   TO S-RETURN-CODE             
              MOVE 100                     TO S-APPL-RETURN-CODE        
              PERFORM 8100-SEND-RESULT        THRU 8100-EXIT            
              PERFORM 9999-END-PROGRAM        THRU 9999-EXIT            
           END-IF.                                                      
                                                                        
       6000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 6560-MOVE-DSM-TRANS-HDR.                                      *         
      *****************************************************************         
       6560-MOVE-DSM-TRANS-HDR.                                         
                                                                        
           PERFORM 7600-GET-CURRENT-TS        THRU 7600-EXIT.           
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :MH-DATE-TRANS                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :MH-DATE-TRANS = CURRENT DATE                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE 'F'                        TO MH-CODE-TRAN-TYPE.        
           MOVE PF-RESP-AREA-ID            TO MH-RESP-AREA-ID.          
           MOVE FF-ACCOUNT-NO              TO MH-ACCOUNT-NO.            
           MOVE ZEROS                      TO MH-CUSTOMER-NO            
                                              MH-PREMISE-NO.            
           MOVE PARM-USERID                TO MH-USER-ID.               
           MOVE PROGRAM-NAME               TO MH-APPL-PROGRAM-ID.       
                                                                        
           IF SF-SPCL-GROUP-CD = 'DS'                                   
              MOVE 'DSM EXEMPTION REMOVED' TO MH-TRAN-COMMENT-TEXT      
              STRING MH-TRAN-COMMENT-TEXT DELIMITED BY '  '             
                 '; FACTOR ID: ' DELIMITED BY SIZE                      
                 FF-FACTOR-ID    DELIMITED BY SIZE                      
                 INTO MH-TRAN-COMMENT-TEXT                              
              END-STRING                                                
           ELSE                                                         
              MOVE 'DSM RIDER REMOVED' TO MH-TRAN-COMMENT-TEXT          
              STRING MH-TRAN-COMMENT-TEXT DELIMITED BY '  '             
                 '; FACTOR ID: ' DELIMITED BY SIZE                      
                 FF-FACTOR-ID    DELIMITED BY SIZE                      
                 INTO MH-TRAN-COMMENT-TEXT                              
              END-STRING                                                
           END-IF.                                                      
                                                                        
           MOVE LENGTH OF MH-TRAN-COMMENT-TEXT TO MH-TRAN-COMMENT-LEN.  
                                                                        
       6560-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
                                                                        
      *****************************************************************         
      * 6565-MOVE-EXP-FCTR-TRAN-DET.                                  *         
      *****************************************************************         
       6565-MOVE-EXP-FCTR-TRAN-DET.                                     
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO        TO MI-TRANS-HIST-SEQ-NO.    
           MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO.         
           MOVE WS-TEMP-DATE-TO             TO MI-PRV-COLUMN-VALUE-TEXT 
           MOVE FF-EFF-DATE-TO              TO MI-CHG-COLUMN-VALUE-TEXT 
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                            TO MI-CHG-COLUMN-VALUE-LEN  
           MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
                                            TO MI-PRV-COLUMN-VALUE-LEN  
           MOVE 'DATE TO        '           TO MI-COLUMN-DESC.          
           PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT.        
           ADD 1                            TO WS-TRAN-APPL-NO.         
                                                                        
                                                                        
       6565-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 6585-MOVE-DEL-FCTR-TRAN-DET.                                  *         
      *****************************************************************         
       6585-MOVE-DEL-FCTR-TRAN-DET.                                     
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO    TO MI-TRANS-HIST-SEQ-NO.        
           MOVE SPACES                  TO MI-TABLE-ID.                 
           MOVE '*DELETED*'             TO MI-CHG-COLUMN-VALUE-TEXT     
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                        TO MI-CHG-COLUMN-VALUE-LEN      
                                                                        
           MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO.             
           IF SF-FCTR-POWER-10 NOT EQUAL 0                              
              COMPUTE WS-FACTOR-FF = FF-FACTOR * 10** SF-FCTR-POWER-10  
              MOVE WS-FACTOR-FF TO WS-FACTOR-TEXT                       
           ELSE                                                         
              MOVE FF-FACTOR    TO WS-FACTOR-TEXT                       
           END-IF.                                                      
           MOVE WS-FACTOR-TEXT               TO WS-FACT-VAL-Z           
           MOVE WS-FACT-VAL-Z                TO MI-PRV-COLUMN-VALUE-TEXT
           MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
                                             TO MI-PRV-COLUMN-VALUE-LEN 
           MOVE 'FACTOR-VALUE   '             TO MI-COLUMN-DESC.        
           PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT.        
           ADD 1                              TO WS-TRAN-APPL-NO.       
                                                                        
           MOVE WS-TRAN-APPL-NO               TO MI-TRAN-APPL-NO.       
           MOVE FF-EFF-DATE-FROM             TO MI-PRV-COLUMN-VALUE-TEXT
           MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
                                              TO MI-PRV-COLUMN-VALUE-LEN
           MOVE 'DATE FROM      '             TO MI-COLUMN-DESC.        
           PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT.        
           ADD 1                              TO WS-TRAN-APPL-NO.       
                                                                        
           MOVE WS-TRAN-APPL-NO               TO MI-TRAN-APPL-NO.       
           MOVE WS-TEMP-DATE-TO              TO MI-PRV-COLUMN-VALUE-TEXT
           MOVE 'DATE TO        '             TO MI-COLUMN-DESC.        
           PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT.        
           ADD 1                              TO WS-TRAN-APPL-NO.       
                                                                        
           MOVE WS-TRAN-APPL-NO               TO MI-TRAN-APPL-NO.       
           MOVE FF-CODE-SEASON               TO MI-PRV-COLUMN-VALUE-TEXT
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                              TO MI-CHG-COLUMN-VALUE-LEN
           MOVE 'SEASON CODE    '             TO MI-COLUMN-DESC.        
           MOVE '42'                          TO MI-TABLE-ID.           
           PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT.        
           ADD 1                              TO WS-TRAN-APPL-NO.       
                                                                        
           MOVE WS-TRAN-APPL-NO               TO MI-TRAN-APPL-NO.       
           MOVE FF-INSTR-USE-TYPE-CD          TO                        
                                               MI-PRV-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
                                              TO MI-PRV-COLUMN-VALUE-LEN
           MOVE 'INSTR USE    '               TO MI-COLUMN-DESC.        
           MOVE '43'                          TO MI-TABLE-ID.           
           PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT.        
           ADD 1                              TO WS-TRAN-APPL-NO.       
                                                                        
           MOVE WS-TRAN-APPL-NO               TO MI-TRAN-APPL-NO.       
           MOVE FF-CODE-TIME-PERIOD           TO                        
                                              MI-PRV-COLUMN-VALUE-TEXT. 
           MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
                                              TO MI-PRV-COLUMN-VALUE-LEN
           MOVE 'TIME PERIOD  '               TO MI-COLUMN-DESC.        
           MOVE '44'                          TO MI-TABLE-ID.           
           PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT.        
           ADD 1                              TO WS-TRAN-APPL-NO.       
                                                                        
           MOVE WS-TRAN-APPL-NO               TO MI-TRAN-APPL-NO.       
           MOVE FF-CMPNT-ID-CD                TO                        
                                              MI-PRV-COLUMN-VALUE-TEXT. 
           MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
                                              TO MI-PRV-COLUMN-VALUE-LEN
           MOVE 'COMPONENT ID '               TO MI-COLUMN-DESC.        
           MOVE 'N6'                          TO MI-TABLE-ID.           
           PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT.        
           ADD 1                              TO WS-TRAN-APPL-NO.       
                                                                        
           MOVE WS-TRAN-APPL-NO               TO MI-TRAN-APPL-NO.       
           MOVE SPACES                        TO MI-TABLE-ID.           
           IF WS-NULL-IND-13 EQUAL -1                                   
              MOVE 'N/A'                      TO                        
                                              MI-PRV-COLUMN-VALUE-TEXT  
           ELSE                                                         
              MOVE FF-DURATION-REMAIN-NO      TO WS-DURATION-NO-Z       
              MOVE WS-DURATION-NO-Z           TO                        
                                              MI-PRV-COLUMN-VALUE-TEXT  
           END-IF                                                       
           MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
                                              TO MI-PRV-COLUMN-VALUE-LEN
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                              TO MI-CHG-COLUMN-VALUE-LEN
           MOVE 'DURATION '                   TO MI-COLUMN-DESC.        
           PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT.        
           ADD 1                              TO WS-TRAN-APPL-NO.       
                                                                        
                                                                        
       6585-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * GET RESP AREA FOR THE USERID                                  *         
      * 7020-SELECT-USER-PROFILE.                                     *         
      *****************************************************************         
       7020-SELECT-USER-PROFILE.                                        
                                                                        
           EXEC SQL                                                     
               SELECT PF.RESP_AREA_ID                                   
                 INTO :PF-RESP-AREA-ID                                  
                 FROM CSS_USER_PROFILE PF WITH(READUNCOMMITTED)                 
                WHERE PF.USER_ID = :PF-USER-ID                          
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT PF.RESP_AREA_ID                                           
MFA-TR*          INTO :PF-RESP-AREA-ID                                          
MFA-TR*          FROM CSS_USER_PROFILE PF                                       
MFA-TR*         WHERE PF.USER_ID = :PF-USER-ID                                  
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7020                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7020'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_USER_PROFILE'        TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'USER_ID'                 TO TABLE-ELEMENT-2         
              MOVE FF-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE PF-USER-ID                TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   GETTING SECURED_RATE_FL FROM RD TABLE.                       *        
      ******************************************************************        
                                                                        
       7025-GET-SECURED-RATE-FL.                                        
                                                                        
           EXEC SQL                                                     
              SELECT SECURED_RATE_FL                                    
                INTO :RD-SECURED-RATE-FL                                
                FROM CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED)                
               WHERE CODE_UTIL_TYPE = :RD-CODE-UTIL-TYPE                
                 AND RATE_PLAN_NO   = :RD-RATE-PLAN-NO                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SECURED_RATE_FL                                            
MFA-TR*         INTO :RD-SECURED-RATE-FL                                        
MFA-TR*         FROM CSS_RATE_PLAN_DESC RD                                      
MFA-TR*        WHERE CODE_UTIL_TYPE = :RD-CODE-UTIL-TYPE                        
MFA-TR*          AND RATE_PLAN_NO   = :RD-RATE-PLAN-NO                          
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7025                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7025'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_RATE_PLAN_DESC'     TO TABLE-1                  
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-1          
              MOVE 'RATE_PLAN_NO'           TO TABLE-ELEMENT-2          
              MOVE RD-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-1        
              MOVE RD-RATE-PLAN-NO          TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7025-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7040-SELECT-FIXD-FCTR-SEQ-NO.                                 *         
      *****************************************************************         
       7040-SELECT-FIXD-FCTR-SEQ-NO.                                    
                                                                        
           EXEC SQL                                                     
              SELECT MAX(FIXED_FCTR_SEQ_NO)                             
                INTO :FF-FIXED-FCTR-SEQ-NO :WS-NULL-IND-FF-SEQ-NO        
                FROM CSS_FIXED_FCTR FF WITH(READUNCOMMITTED)                    
               WHERE FF.ACCOUNT_NO     = :FF-ACCOUNT-NO                 
                 AND FF.CODE_UTIL_TYPE = :FF-CODE-UTIL-TYPE             
                 AND FF.IC_NO          = :FF-IC-NO                      
                 AND FF.FACTOR_ID      = :FF-FACTOR-ID                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MAX(FIXED_FCTR_SEQ_NO)                                     
MFA-TR*         INTO :FF-FIXED-FCTR-SEQ-NO:WS-NULL-IND-FF-SEQ-NO                
MFA-TR*         FROM CSS_FIXED_FCTR FF                                          
MFA-TR*        WHERE FF.ACCOUNT_NO     = :FF-ACCOUNT-NO                         
MFA-TR*          AND FF.CODE_UTIL_TYPE = :FF-CODE-UTIL-TYPE                     
MFA-TR*          AND FF.IC_NO          = :FF-IC-NO                              
MFA-TR*          AND FF.FACTOR_ID      = :FF-FACTOR-ID                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7040                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-NULL-IND-FF-SEQ-NO EQUAL -1                         
                 MOVE ZEROES                 TO FF-FIXED-FCTR-SEQ-NO    
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7040'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_FIXED_FCTR'          TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE 'IC_NO'                   TO TABLE-ELEMENT-3         
              MOVE FF-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE FF-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              MOVE FF-IC-NO                  TO HOSTVAR-ELEMENT-3       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7040-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7045-SELECT-EFFECTIVE-DATES.                                  *         
      *****************************************************************         
       7045-SELECT-EFFECTIVE-DATES.                                     
      *                                                                         
           EXEC SQL                                                     
              SELECT EFF_DATE_FROM                                      
                    ,EFF_DATE_TO                                        
                INTO :FF-EFF-DATE-FROM                                  
                    ,:FF-EFF-DATE-TO :WS-NULL-IND-EFF-DATE-TO            
                FROM CSS_FIXED_FCTR FF WITH(READUNCOMMITTED)                    
               WHERE FF.ACCOUNT_NO         = :FF-ACCOUNT-NO             
                 AND FF.CODE_UTIL_TYPE     = :FF-CODE-UTIL-TYPE         
                 AND FF.IC_NO              = :FF-IC-NO                  
                 AND FF.FIXED_FCTR_SEQ_NO  = :FF-FIXED-FCTR-SEQ-NO      
                 AND FF.FACTOR_ID          = :FF-FACTOR-ID              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT EFF_DATE_FROM                                              
MFA-TR*             ,EFF_DATE_TO                                                
MFA-TR*         INTO :FF-EFF-DATE-FROM                                          
MFA-TR*             ,:FF-EFF-DATE-TO:WS-NULL-IND-EFF-DATE-TO                    
MFA-TR*         FROM CSS_FIXED_FCTR FF                                          
MFA-TR*        WHERE FF.ACCOUNT_NO         = :FF-ACCOUNT-NO                     
MFA-TR*          AND FF.CODE_UTIL_TYPE     = :FF-CODE-UTIL-TYPE                 
MFA-TR*          AND FF.IC_NO              = :FF-IC-NO                          
MFA-TR*          AND FF.FIXED_FCTR_SEQ_NO  = :FF-FIXED-FCTR-SEQ-NO              
MFA-TR*          AND FF.FACTOR_ID          = :FF-FACTOR-ID                      
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7045                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7045'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_FIXED_FCTR'          TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE 'IC_NO'                   TO TABLE-ELEMENT-3         
              MOVE 'FIXED_FCTR_SEQ_NO'       TO TABLE-ELEMENT-4         
              MOVE FF-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE FF-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              MOVE FF-IC-NO                  TO HOSTVAR-ELEMENT-3       
              MOVE FF-FIXED-FCTR-SEQ-NO      TO HOSTVAR-ELEMENT-4       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7045-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7050-GET-SPCL-FCTR-DETAILS.                                    *        
      * TO GET ADDITIONAL DETAILS FROM CSS_SPCL_FCTR FOR THE FACTOR    *        
      ******************************************************************        
       7050-GET-SPCL-FCTR-DETAILS.                                      
                                                                        
           EXEC SQL                                                     
ACT004        SELECT DEFLT_DURATION_NO                                  
                    ,ADJUST_ELEMENT                                     
                    ,RT_ATTR_INCTV_TYPE                                 
ACT004          INTO :SF-DEFLT-DURATION-NO :IND-DEF-DUR-REM-NO           
                    ,:SF-ADJUST-ELEMENT                                 
                    ,:SF-RT-ATTR-INCTV-TYPE                             
                FROM CSS_SPCL_FCTR WITH(READUNCOMMITTED)                        
               WHERE FACTOR_ID = :SF-FACTOR-ID                          
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DEFLT_DURATION_NO                                          
MFA-TR*             ,ADJUST_ELEMENT                                             
MFA-TR*             ,RT_ATTR_INCTV_TYPE                                         
MFA-TR*         INTO :SF-DEFLT-DURATION-NO:IND-DEF-DUR-REM-NO                   
MFA-TR*             ,:SF-ADJUST-ELEMENT                                         
MFA-TR*             ,:SF-RT-ATTR-INCTV-TYPE                                     
MFA-TR*         FROM CSS_SPCL_FCTR                                              
MFA-TR*        WHERE FACTOR_ID = :SF-FACTOR-ID                                  
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7050                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF IND-DEF-DUR-REM-NO EQUAL -1                            
                 MOVE ZEROES                  TO SF-DEFLT-DURATION-NO   
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7050'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_SPCL_FCTR'            TO TABLE-1                
              MOVE 'FACTOR_ID'                TO TABLE-ELEMENT-1        
              MOVE SF-FACTOR-ID               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7100-SELECT-MAX-SEQ-NO                                         *        
      ******************************************************************        
       7100-SELECT-MAX-SEQ-NO.                                          
                                                                        
           EXEC SQL                                                     
              SELECT   MAX( FIXED_FCTR_SEQ_NO)                          
                INTO   :FF-FIXED-FCTR-SEQ-NO :WS-NULL-IND                
                FROM  CSS_FIXED_FCTR WITH(READUNCOMMITTED)                      
                WHERE ACCOUNT_NO        = :FF-ACCOUNT-NO                
                  AND CODE_UTIL_TYPE    = :PARM-CODE-UTIL-TYPE          
                  AND IC_NO             = :PARM-IC-NO                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT   MAX( FIXED_FCTR_SEQ_NO)                                  
MFA-TR*         INTO   :FF-FIXED-FCTR-SEQ-NO:WS-NULL-IND                        
MFA-TR*         FROM  CSS_FIXED_FCTR                                            
MFA-TR*         WHERE ACCOUNT_NO        = :FF-ACCOUNT-NO                        
MFA-TR*           AND CODE_UTIL_TYPE    = :PARM-CODE-UTIL-TYPE                  
MFA-TR*           AND IC_NO             = :PARM-IC-NO                           
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7100                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7100'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT '                  TO ABEND-FUNCTION         
              MOVE 'CSS_FIXED_FCTR'           TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-3        
              MOVE FF-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE PARM-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2      
              MOVE PARM-IC-NO                 TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
A05065***************************************************************** 29340100
A05065*                                                               * 29340200
A05065* 7170-GET-CODE-VALUE                                           * 29340300
A05065***************************************************************** 29340400
A05065                                                                  
A05065 7170-GET-CODE-VALUE.                                             
A05065                                                                  
A05065     EXEC SQL                                                     
A05065        SELECT UV.CODE_LONG_DESC                                  
A05065          INTO :UV-CODE-LONG-DESC                                 
A05065          FROM CSS_CODE_VALUE    UV WITH(READUNCOMMITTED)                 
A05065         WHERE UV.CODE_VALUE  = :UV-CODE-VALUE                    
A05065           AND UV.COLUMN_NA   = :UV-COLUMN-NA                     
A05065           AND UV.TABLE_NA    = :UV-TABLE-NA                      
A05065           AND UV.PROGRAM_ID  = :UV-PROGRAM-ID                    
A05065           AND UV.COMPANY_NO  = :UV-COMPANY-NO                    
A05065                                                           
A05065                                                      
A05065     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     29340800
MFA-TR*       SELECT UV.CODE_LONG_DESC                                  29340900
MFA-TR*         INTO :UV-CODE-LONG-DESC                                 29341001
MFA-TR*         FROM CSS_CODE_VALUE    UV                               29341003
MFA-TR*        WHERE UV.CODE_VALUE  = :UV-CODE-VALUE                    29341004
MFA-TR*          AND UV.COLUMN_NA   = :UV-COLUMN-NA                     29341005
MFA-TR*          AND UV.TABLE_NA    = :UV-TABLE-NA                      29341006
MFA-TR*          AND UV.PROGRAM_ID  = :UV-PROGRAM-ID                    29341007
MFA-TR*          AND UV.COMPANY_NO  = :UV-COMPANY-NO                    29341008
MFA-TR*         WITH UR                                                 29341009
MFA-TR*      QUERYNO 7170                                               29341010
MFA-TR*    END-EXEC.                                                    29341011

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05065                                                                  
A05065     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
A05065                                                                  
A05065     EVALUATE WS-ACTIVE-RETURN-CODE                               
A05065         WHEN SUCCESSFUL-CALL                                     
A05065              CONTINUE                                            
A05065         WHEN NOT-FOUND                                           
A05065              MOVE +09                TO UV-CODE-LONG-DESC-LEN    
A05065              MOVE 'NOT FOUND'        TO UV-CODE-LONG-DESC-TEXT   
A05065         WHEN OTHER                                               
A05065              MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
A05065              MOVE '7170'             TO ACTIVE-PARAGRAPH         
A05065              MOVE 'SELECT'           TO ABEND-FUNCTION           
A05065              MOVE SPACES             TO ABEND-SQL-PREDICATES     
A05065                                         ABEND-TABLES             
A05065              MOVE 'CSS_CODE_VALUE'   TO TABLE-1                  
A05065              MOVE 'PROGRAM_ID'       TO TABLE-ELEMENT-1          
A05065              MOVE UV-PROGRAM-ID      TO HOSTVAR-ELEMENT-1        
A05065              MOVE 'CODE_VALUE'       TO TABLE-ELEMENT-2          
A05065              MOVE UV-CODE-VALUE      TO HOSTVAR-ELEMENT-2        
A05065              MOVE 'COLUMN_NA'        TO TABLE-ELEMENT-3          
A05065              MOVE UV-COLUMN-NA       TO HOSTVAR-ELEMENT-3        
A05065              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT      
A05065              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT      
A05065     END-EVALUATE.                                                
A05065*                                                                 29341036
A05065 7170-EXIT.                                                       
A05065     EXIT.                                                        
      ******************************************************************        
      * 7200-SELECT-FACTOR                                             *        
      ******************************************************************        
       7200-SELECT-FACTOR.                                              
                                                                        
           EXEC SQL                                                     
              SELECT    FACTOR                                          
                      , FACTOR_ID                                       
                      , EFF_DATE_FROM                                   
                      , EFF_DATE_TO                                     
                      , CODE_SEASON                                     
                      , INSTR_USE_TYPE_CD                               
                      , CODE_TIME_PERIOD                                
                      , CMPNT_ID_CD                                     
                      , FIXED_FCTR_TYP_CD                               
                      , FAC_CHRG_BASE_AM                                
                      , DURATION_REMAIN_NO                              
                      , BLOCK_NO                                        
                INTO    :FF-FACTOR                                      
                      , :FF-FACTOR-ID                                   
                      , :FF-EFF-DATE-FROM :IND-DATE-FROM                 
                      , :FF-EFF-DATE-TO :IND-DATE-TO                     
                      , :FF-CODE-SEASON                                 
                      , :FF-INSTR-USE-TYPE-CD                           
                      , :FF-CODE-TIME-PERIOD                            
                      , :FF-CMPNT-ID-CD                                 
                      , :FF-FIXED-FCTR-TYP-CD                           
                      , :FF-FAC-CHRG-BASE-AM                            
                      , :FF-DURATION-REMAIN-NO :IND-DURATION-REMAIN-NO          
                      , :FF-BLOCK-NO                                    
                FROM  CSS_FIXED_FCTR WITH(READUNCOMMITTED)                      
                WHERE ACCOUNT_NO        = :FF-ACCOUNT-NO                
                  AND CODE_UTIL_TYPE    = :PARM-CODE-UTIL-TYPE          
                  AND IC_NO             = :PARM-IC-NO                   
                  AND FIXED_FCTR_SEQ_NO = :FF-FIXED-FCTR-SEQ-NO         
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT    FACTOR                                                  
MFA-TR*               , FACTOR_ID                                               
MFA-TR*               , EFF_DATE_FROM                                           
MFA-TR*               , EFF_DATE_TO                                             
MFA-TR*               , CODE_SEASON                                             
MFA-TR*               , INSTR_USE_TYPE_CD                                       
MFA-TR*               , CODE_TIME_PERIOD                                        
MFA-TR*               , CMPNT_ID_CD                                             
MFA-TR*               , FIXED_FCTR_TYP_CD                                       
MFA-TR*               , FAC_CHRG_BASE_AM                                        
MFA-TR*               , DURATION_REMAIN_NO                                      
MFA-TR*               , BLOCK_NO                                                
MFA-TR*         INTO    :FF-FACTOR                                              
MFA-TR*               , :FF-FACTOR-ID                                           
MFA-TR*               , :FF-EFF-DATE-FROM:IND-DATE-FROM                         
MFA-TR*               , :FF-EFF-DATE-TO:IND-DATE-TO                             
MFA-TR*               , :FF-CODE-SEASON                                         
MFA-TR*               , :FF-INSTR-USE-TYPE-CD                                   
MFA-TR*               , :FF-CODE-TIME-PERIOD                                    
MFA-TR*               , :FF-CMPNT-ID-CD                                         
MFA-TR*               , :FF-FIXED-FCTR-TYP-CD                                   
MFA-TR*               , :FF-FAC-CHRG-BASE-AM                                    
MFA-TR*               , :FF-DURATION-REMAIN-NO                                  
MFA-TR*                 :IND-DURATION-REMAIN-NO                                 
MFA-TR*               , :FF-BLOCK-NO                                            
MFA-TR*         FROM  CSS_FIXED_FCTR                                            
MFA-TR*         WHERE ACCOUNT_NO        = :FF-ACCOUNT-NO                        
MFA-TR*           AND CODE_UTIL_TYPE    = :PARM-CODE-UTIL-TYPE                  
MFA-TR*           AND IC_NO             = :PARM-IC-NO                           
MFA-TR*           AND FIXED_FCTR_SEQ_NO = :FF-FIXED-FCTR-SEQ-NO                 
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7200                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7200'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_FIXED_FCTR'           TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-3        
              MOVE 'FIXED_FCTR_SEQ_NO'        TO TABLE-ELEMENT-4        
              MOVE FF-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE PARM-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2      
              MOVE PARM-IC-NO                 TO HOSTVAR-ELEMENT-3      
              MOVE FF-FIXED-FCTR-SEQ-NO       TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7210-SELECT-FACTOR-PWR                                         *        
      ******************************************************************        
       7210-SELECT-FACTOR-PWR.                                          
                                                                        
           EXEC SQL                                                     
              SELECT  FCTR_POWER_10                                     
                INTO :WS-FCTR-POWER-10                                  
                FROM  CSS_SPCL_FCTR WITH(READUNCOMMITTED)                       
               WHERE  FACTOR_ID  = :PARM-FACTOR-ID                      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  FCTR_POWER_10                                             
MFA-TR*         INTO :WS-FCTR-POWER-10                                          
MFA-TR*         FROM  CSS_SPCL_FCTR                                             
MFA-TR*        WHERE  FACTOR_ID  = :PARM-FACTOR-ID                              
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7210                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7210'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_SPCL_FCTR'            TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-3        
              MOVE UT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE UT-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2      
              MOVE UT-IC-NO                   TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7220-GET-FCTR-BY-GRPCD.                                        *        
      ******************************************************************        
       7220-GET-FCTR-BY-GRPCD.                                          
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) FACTOR_ID                                         
                INTO :WS-DSM-FACTOR-ID                                  
                FROM  CSS_SPCL_FCTR WITH(READUNCOMMITTED)                       
               WHERE  FACTOR_TYPE   = 'B'                               
                 AND  SPCL_GROUP_CD = :SF-SPCL-GROUP-CD                 
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  FACTOR_ID                                                 
MFA-TR*         INTO :WS-DSM-FACTOR-ID                                          
MFA-TR*         FROM  CSS_SPCL_FCTR                                             
MFA-TR*        WHERE  FACTOR_TYPE   = 'B'                                       
MFA-TR*          AND  SPCL_GROUP_CD = :SF-SPCL-GROUP-CD                         
MFA-TR*      FETCH FIRST ROW ONLY                                               
MFA-TR*       WITH UR                                                           
MFA-TR*      QUERYNO 7220                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7220'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_SPCL_FCTR'            TO TABLE-1                
              MOVE 'SPCL_GROUP_CD'            TO TABLE-ELEMENT-1        
              MOVE SF-SPCL-GROUP-CD           TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7220-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7260-SELECT-SPCL-FCTR                                          *        
      ******************************************************************        
                                                                        
       7260-SELECT-SPCL-FCTR.                                           
                                                                        
           EXEC SQL                                                     
              SELECT SF.CHECK_ELEMENT                                   
                    ,LTRIM(RTRIM(FACTOR_ID)) + ' - ' + LTRIM(RTRIM(
           FACTOR_TEXT))    
                    ,SF.CODE_DR_CR                                      
                    ,SF.CODE_TAX_STAT_XMT                               
                    ,SF.CODE_TAX_CITY_XMT                               
                INTO :SF-CHECK-ELEMENT                                  
                    ,:WS-FACTOR-ID-DESC                                 
                    ,:SF-CODE-DR-CR                                     
                    ,:SF-CODE-TAX-STAT-XMT                              
                    ,:SF-CODE-TAX-CITY-XMT                              
                FROM CSS_SPCL_FCTR SF WITH(READUNCOMMITTED)                     
               WHERE SF.FACTOR_ID = :SF-FACTOR-ID                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SF.CHECK_ELEMENT                                           
MFA-TR*             ,STRIP(FACTOR_ID) || ' - ' || STRIP(FACTOR_TEXT)            
MFA-TR*             ,SF.CODE_DR_CR                                              
MFA-TR*             ,SF.CODE_TAX_STAT_XMT                                       
MFA-TR*             ,SF.CODE_TAX_CITY_XMT                                       
MFA-TR*         INTO :SF-CHECK-ELEMENT                                          
MFA-TR*             ,:WS-FACTOR-ID-DESC                                         
MFA-TR*             ,:SF-CODE-DR-CR                                             
MFA-TR*             ,:SF-CODE-TAX-STAT-XMT                                      
MFA-TR*             ,:SF-CODE-TAX-CITY-XMT                                      
MFA-TR*         FROM CSS_SPCL_FCTR SF                                           
MFA-TR*        WHERE SF.FACTOR_ID = :SF-FACTOR-ID                               
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7260                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7260'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_SPCL_FCTR'            TO TABLE-1                
              MOVE 'FACTOR_ID'                TO TABLE-ELEMENT-1        
              MOVE SF-FACTOR-ID               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7260-EXIT.                                                       
                                                                        
      ******************************************************************        
      * 7270-GET-RATE                                                  *        
      ******************************************************************        
                                                                        
       7270-GET-RATE.                                                   
           EXEC SQL                                                     
              SELECT RATE_PLAN_NO                                       
              INTO   :WS-RATE                                           
              FROM   CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                     
              WHERE  ACCOUNT_NO        = :UT-ACCOUNT-NO                 
              AND    CODE_UTIL_TYPE    = :UT-CODE-UTIL-TYPE             
              AND    IC_NO             = :UT-IC-NO                      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RATE_PLAN_NO                                               
MFA-TR*       INTO   :WS-RATE                                                   
MFA-TR*       FROM   CSS_UTIL_ENVRNMT                                           
MFA-TR*       WHERE  ACCOUNT_NO        = :UT-ACCOUNT-NO                         
MFA-TR*       AND    CODE_UTIL_TYPE    = :UT-CODE-UTIL-TYPE                     
MFA-TR*       AND    IC_NO             = :UT-IC-NO                              
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7270                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7270'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_UTIL_ENVRNMT'         TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-3        
              MOVE UT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE UT-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2      
              MOVE UT-IC-NO                   TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7270-EXIT.                                                       
                                                                        
                                                                        
      ******************************************************************        
      * 7280-CHECK-B-SUB-ACCT                                          *        
      ******************************************************************        
                                                                        
       7280-CHECK-B-SUB-ACCT.                                           
                                                                        
           EXEC SQL                                                     
              SELECT CODE_ACCT_USAGE                                    
              INTO   :AT-CODE-ACCT-USAGE                                
              FROM   CSS_ACCOUNT WITH(READUNCOMMITTED)                          
              WHERE  ACCOUNT_NO        = :AT-ACCOUNT-NO                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CODE_ACCT_USAGE                                            
MFA-TR*       INTO   :AT-CODE-ACCT-USAGE                                        
MFA-TR*       FROM   CSS_ACCOUNT                                                
MFA-TR*       WHERE  ACCOUNT_NO        = :AT-ACCOUNT-NO                         
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7280                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7280'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_ACCOUNT'              TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7280-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7295-SEL-FIXD-FCTR-DET.                                       *         
      *****************************************************************         
       7295-SEL-FIXD-FCTR-DET.                                          
                                                                        
           EXEC SQL                                                     
              SELECT FF.FACTOR_ID                                       
                    ,FF.EFF_DATE_FROM                                   
                    ,FF.CMPNT_ID_CD                                     
                    ,FF.CODE_SEASON                                     
                    ,FF.INSTR_USE_TYPE_CD                               
                    ,FF.CODE_TIME_PERIOD                                
                    ,FF.EFF_DATE_TO                                     
                    ,FF.FIXED_FCTR_TYP_CD                               
                    ,FF.FACTOR                                          
                    ,FF.FAC_CHRG_BASE_AM                                
                    ,REPLACE(REPLACE(CONVERT(CHAR(26), FF.LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS                         
                    ,FF.DURATION_REMAIN_NO                              
                    ,FF.RT_PKG_OPT_SEQ_NO                               
                    ,FF.BLOCK_NO                                        
                    ,SF.FCTR_POWER_10                                   
                INTO :FF-FACTOR-ID                                      
                    ,:FF-EFF-DATE-FROM                                  
                    ,:FF-CMPNT-ID-CD                                    
                    ,:FF-CODE-SEASON                                    
                    ,:FF-INSTR-USE-TYPE-CD                              
                    ,:FF-CODE-TIME-PERIOD                               
                    ,:WS-TEMP-DATE-TO                                   
                    ,:FF-FIXED-FCTR-TYP-CD                              
                    ,:FF-FACTOR                                         
                    ,:FF-FAC-CHRG-BASE-AM                               
                    ,:FF-LAST-UPDATE-TS                                 
                    ,:FF-DURATION-REMAIN-NO :WS-NULL-IND-13              
                    ,:FF-RT-PKG-OPT-SEQ-NO                              
                    ,:FF-BLOCK-NO                                       
                    ,:SF-FCTR-POWER-10                                  
                FROM CSS_FIXED_FCTR FF WITH(READUNCOMMITTED)                    
                    ,CSS_SPCL_FCTR  SF WITH(READUNCOMMITTED)                    
               WHERE FF.ACCOUNT_NO     = :FF-ACCOUNT-NO                 
                 AND FF.CODE_UTIL_TYPE = :FF-CODE-UTIL-TYPE             
                 AND FF.IC_NO          = :FF-IC-NO                      
                 AND FF.FIXED_FCTR_SEQ_NO = :FF-FIXED-FCTR-SEQ-NO       
                 AND FF.FACTOR_ID         = :FF-FACTOR-ID               
                 AND FF.FACTOR_ID      = SF.FACTOR_ID                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT FF.FACTOR_ID                                               
MFA-TR*             ,FF.EFF_DATE_FROM                                           
MFA-TR*             ,FF.CMPNT_ID_CD                                             
MFA-TR*             ,FF.CODE_SEASON                                             
MFA-TR*             ,FF.INSTR_USE_TYPE_CD                                       
MFA-TR*             ,FF.CODE_TIME_PERIOD                                        
MFA-TR*             ,FF.EFF_DATE_TO                                             
MFA-TR*             ,FF.FIXED_FCTR_TYP_CD                                       
MFA-TR*             ,FF.FACTOR                                                  
MFA-TR*             ,FF.FAC_CHRG_BASE_AM                                        
MFA-TR*             ,FF.LAST_UPDATE_TS                                          
MFA-TR*             ,FF.DURATION_REMAIN_NO                                      
MFA-TR*             ,FF.RT_PKG_OPT_SEQ_NO                                       
MFA-TR*             ,FF.BLOCK_NO                                                
MFA-TR*             ,SF.FCTR_POWER_10                                           
MFA-TR*         INTO :FF-FACTOR-ID                                              
MFA-TR*             ,:FF-EFF-DATE-FROM                                          
MFA-TR*             ,:FF-CMPNT-ID-CD                                            
MFA-TR*             ,:FF-CODE-SEASON                                            
MFA-TR*             ,:FF-INSTR-USE-TYPE-CD                                      
MFA-TR*             ,:FF-CODE-TIME-PERIOD                                       
MFA-TR*             ,:WS-TEMP-DATE-TO                                           
MFA-TR*             ,:FF-FIXED-FCTR-TYP-CD                                      
MFA-TR*             ,:FF-FACTOR                                                 
MFA-TR*             ,:FF-FAC-CHRG-BASE-AM                                       
MFA-TR*             ,:FF-LAST-UPDATE-TS                                         
MFA-TR*             ,:FF-DURATION-REMAIN-NO:WS-NULL-IND-13                      
MFA-TR*             ,:FF-RT-PKG-OPT-SEQ-NO                                      
MFA-TR*             ,:FF-BLOCK-NO                                               
MFA-TR*             ,:SF-FCTR-POWER-10                                          
MFA-TR*         FROM CSS_FIXED_FCTR FF                                          
MFA-TR*             ,CSS_SPCL_FCTR  SF                                          
MFA-TR*        WHERE FF.ACCOUNT_NO     = :FF-ACCOUNT-NO                         
MFA-TR*          AND FF.CODE_UTIL_TYPE = :FF-CODE-UTIL-TYPE                     
MFA-TR*          AND FF.IC_NO          = :FF-IC-NO                              
MFA-TR*          AND FF.FIXED_FCTR_SEQ_NO = :FF-FIXED-FCTR-SEQ-NO               
MFA-TR*          AND FF.FACTOR_ID         = :FF-FACTOR-ID                       
MFA-TR*          AND FF.FACTOR_ID      = SF.FACTOR_ID                           
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7295                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7295'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_FIXED_FCTR'          TO TABLE-1                 
              MOVE 'CSS_SPCL_FCTR'           TO TABLE-2                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE 'IC_NO'                   TO TABLE-ELEMENT-3         
              MOVE FF-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE FF-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              MOVE FF-IC-NO                  TO HOSTVAR-ELEMENT-3       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7295-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7300-GET-REVENUE CLASS                                         *        
      ******************************************************************        
      *                                                                         
       7300-GET-REVENUE-CLASS.                                          
      *                                                                         
           EXEC SQL                                                     
              SELECT CODE_REVENUE_CLASS                                 
                INTO :WS-CODE-REVENUE-CLASS                             
                FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                     
               WHERE ACCOUNT_NO        = :UT-ACCOUNT-NO                 
                 AND CODE_UTIL_TYPE    = :UT-CODE-UTIL-TYPE             
                 AND IC_NO             = :UT-IC-NO                      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CODE_REVENUE_CLASS                                         
MFA-TR*         INTO :WS-CODE-REVENUE-CLASS                                     
MFA-TR*         FROM CSS_UTIL_ENVRNMT                                           
MFA-TR*        WHERE ACCOUNT_NO        = :UT-ACCOUNT-NO                         
MFA-TR*          AND CODE_UTIL_TYPE    = :UT-CODE-UTIL-TYPE                     
MFA-TR*          AND IC_NO             = :UT-IC-NO                              
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7300                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND    
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME                TO ABEND-PROGRAM        
               MOVE '7300'                      TO ACTIVE-PARAGRAPH     
               MOVE 'SELECT'                    TO ABEND-FUNCTION       
               MOVE 'CSS_UTIL_ENVRNMT'          TO TABLE-1              
               MOVE 'ACCOUNT_NO'                TO TABLE-ELEMENT-1      
               MOVE 'CODE_UTIL_TYPE'            TO TABLE-ELEMENT-2      
               MOVE 'IC_NO'                     TO TABLE-ELEMENT-3      
               MOVE UT-ACCOUNT-NO               TO HOSTVAR-ELEMENT-1    
               MOVE UT-CODE-UTIL-TYPE           TO HOSTVAR-ELEMENT-2    
               MOVE UT-IC-NO                    TO HOSTVAR-ELEMENT-3    
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
       7325-SELECT-COMPANY.                                             
                                                                        
           EXEC SQL                                                     
              SELECT COMPANY_NO                                         
                    ,REV_MTH_LST_NRML                                   
                    ,BILL_CYCLE                                         
                INTO :AT-COMPANY-NO                                     
                    ,:AT-REV-MTH-LST-NRML                               
                    ,:AT-BILL-CYCLE                                     
                FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                          
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COMPANY_NO                                                 
MFA-TR*             ,REV_MTH_LST_NRML                                           
MFA-TR*             ,BILL_CYCLE                                                 
MFA-TR*         INTO :AT-COMPANY-NO                                             
MFA-TR*             ,:AT-REV-MTH-LST-NRML                                       
MFA-TR*             ,:AT-BILL-CYCLE                                             
MFA-TR*         FROM CSS_ACCOUNT                                                
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7325                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7325'                     TO ACTIVE-PARAGRAPH      
               MOVE 'SELECT'                   TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-TABLES          
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
               MOVE 'CSS_ACCOUNT'              TO TABLE-1               
               MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1       
               MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7325-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P00805*****************************************************************         
P00805* 7330-SELECT-REG-PROFILE                                       *         
P00805*****************************************************************         
P00805 7330-SELECT-REG-PROFILE.                                         
P00805*                                                                         
P00805     EXEC SQL                                                     
P00805        SELECT LR.ACCOUNT_NO                                      
P00805         INTO :LR-ACCOUNT-NO                                      
P00805         FROM CSS_REG_PROFILE LR WITH(READUNCOMMITTED)                    
P00805        WHERE LR.ACCOUNT_NO = :LR-ACCOUNT-NO                      
P00805                                                           
P00805                                                      
P00805     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT LR.ACCOUNT_NO                                              
MFA-TR*        INTO :LR-ACCOUNT-NO                                              
MFA-TR*        FROM CSS_REG_PROFILE LR                                          
MFA-TR*       WHERE LR.ACCOUNT_NO = :LR-ACCOUNT-NO                              
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7330                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00805                                                                  
P00805     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
P00805                                                                  
P00805     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00805        NEXT SENTENCE                                             
P00805     ELSE                                                         
P00805        MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
P00805        MOVE SQLCODE             TO ABEND-SQLCODE                 
P00805        MOVE SQLSTATE            TO ABEND-SQLSTATE                
P00805        MOVE '7330'              TO ACTIVE-PARAGRAPH              
P00805        MOVE 'SELECT'            TO ABEND-FUNCTION                
P00805        MOVE 'CSS_REG_PROFILE'   TO TABLE-1                       
P00805        MOVE LR-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
P00805        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
P00805        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
P00805     END-IF                                                       
P00805     .                                                            
P00805 7330-EXIT.                                                       
P00805     EXIT.                                                        
      ****************************************************************          
      * SELECT DELINQUENCY VALUE FOR THE GIVEN DELINQ CODE                      
      ****************************************************************          
      *                                                                         
       7350-SELECT-DELINQUENCY.                                         
      *                                                                         
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE DELINQ_CD  = :C8-DELINQ-CD                         
                 AND COMPANY_NO = :C8-COMPANY-NO                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD  = :C8-DELINQ-CD                                 
MFA-TR*          AND COMPANY_NO = :C8-COMPANY-NO                                
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7350                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7350'                     TO ACTIVE-PARAGRAPH      
               MOVE 'SELECT'                   TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-TABLES          
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
               MOVE 'CSS_DELIQUENCY'           TO TABLE-1               
               MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1       
               MOVE 'DELINQ_CD'                TO TABLE-ELEMENT-2       
               MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1     
               MOVE C8-DELINQ-CD               TO HOSTVAR-ELEMENT-2     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
         7350-EXIT.                                                     
             EXIT.                                                      
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7550-GET-RULE-XREF-ID                                          *        
      *                                                                *        
      ******************************************************************        
       7550-GET-RULE-XREF-ID.                                           
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           BUS_RULE_XREF_ID, 121), ' ', '-'), ':', '.') 
           BUS_RULE_XREF_ID                                   
                INTO :S-BUS-RULE-XREF-ID                                
                FROM CSS_BUS_RULE   [1R] WITH(READUNCOMMITTED)                  
                    ,CSS_BUS_RULE_XREF [1T] WITH(READUNCOMMITTED)               
               WHERE [1R].BUS_RULE_ID = :S-BUS-RULE-ID                    
                 AND [1R].BUS_RULE_ID = [1T].BUS_RULE_ID                    
                                             
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BUS_RULE_XREF_ID                                           
MFA-TR*         INTO :S-BUS-RULE-XREF-ID                                        
MFA-TR*         FROM CSS_BUS_RULE   1R                                          
MFA-TR*             ,CSS_BUS_RULE_XREF 1T                                       
MFA-TR*        WHERE 1R.BUS_RULE_ID = :S-BUS-RULE-ID                            
MFA-TR*          AND 1R.BUS_RULE_ID = 1T.BUS_RULE_ID                            
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7550                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
               MOVE SPACES                  TO ABEND-TABLES             
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
               MOVE '7550'                  TO ACTIVE-PARAGRAPH         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_BUS_RULE'          TO TABLE-1                  
               MOVE 'BUS_RULE_ID'           TO TABLE-ELEMENT-1          
               MOVE S-BUS-RULE-ID          TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7600-GET-CURRENT-TS.                                           *        
      ******************************************************************        
       7600-GET-CURRENT-TS.                                             
      *                                                                         
           MOVE 1 TO WS-TRAN-APPL-NO MI-TRAN-APPL-NO.                   
                                                                        
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :MH-TRANS-HIST-SEQ-NO             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :MH-TRANS-HIST-SEQ-NO = CURRENT TIMESTAMP                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7400'                     TO ACTIVE-PARAGRAPH      
               MOVE 'SET'                      TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-TABLES          
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
               MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1       
               MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
         7600-EXIT.                                                     
             EXIT.                                                      
      *                                                                         
      ******************************************************************        
      * 7700-GET-RTPKGOPTSEQ-FCTR.                                     *        
      * GET THE RATE PKG OPTION SEQ NO FROM CSS_UTIL_ENVRNMT           *        
      ******************************************************************        
       7700-GET-RTPKGOPTSEQ-FCTR.                                       
                                                                        
           EXEC SQL                                                     
              SELECT UT.RT_PKG_OPT_SEQ_NO                               
                    ,DF.OPTION_CD                                       
                INTO :UT-RT-PKG-OPT-SEQ-NO                              
                    ,:DF-OPTION-CD                                      
                FROM CSS_UTIL_ENVRNMT   UT WITH(READUNCOMMITTED)                
                    ,CSS_ACCT_RTPK_AGR  DF WITH(READUNCOMMITTED)                
               WHERE UT.ACCOUNT_NO         = :UT-ACCOUNT-NO             
                 AND UT.CODE_UTIL_TYPE     = :UT-CODE-UTIL-TYPE         
                 AND UT.IC_NO              = :UT-IC-NO                  
                 AND UT.ACCOUNT_NO         = DF.ACCOUNT_NO              
                 AND UT.CODE_UTIL_TYPE     = DF.CODE_UTIL_TYPE          
                 AND UT.IC_NO              = DF.IC_NO                   
                 AND UT.RT_PKG_OPT_SEQ_NO  = DF.RT_PKG_OPT_SEQ_NO       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT UT.RT_PKG_OPT_SEQ_NO                                       
MFA-TR*             ,DF.OPTION_CD                                               
MFA-TR*         INTO :UT-RT-PKG-OPT-SEQ-NO                                      
MFA-TR*             ,:DF-OPTION-CD                                              
MFA-TR*         FROM CSS_UTIL_ENVRNMT   UT                                      
MFA-TR*             ,CSS_ACCT_RTPK_AGR  DF                                      
MFA-TR*        WHERE UT.ACCOUNT_NO         = :UT-ACCOUNT-NO                     
MFA-TR*          AND UT.CODE_UTIL_TYPE     = :UT-CODE-UTIL-TYPE                 
MFA-TR*          AND UT.IC_NO              = :UT-IC-NO                          
MFA-TR*          AND UT.ACCOUNT_NO         = DF.ACCOUNT_NO                      
MFA-TR*          AND UT.CODE_UTIL_TYPE     = DF.CODE_UTIL_TYPE                  
MFA-TR*          AND UT.IC_NO              = DF.IC_NO                           
MFA-TR*          AND UT.RT_PKG_OPT_SEQ_NO  = DF.RT_PKG_OPT_SEQ_NO               
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7700                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7700'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_UTIL_ENVRNMT'      TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2          
               MOVE 'IC_NO'                 TO TABLE-ELEMENT-3          
               MOVE UT-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               MOVE UT-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2        
               MOVE UT-IC-NO                TO HOSTVAR-ELEMENT-3        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7710-GET-FCTR-OPTION-CODE.                                     *        
      * GET THE OPTION CODE RELATED TO THE FACTOR.                     *        
      ******************************************************************        
       7710-GET-FCTR-OPTION-CODE.                                       
                                                                        
           EXEC SQL                                                     
              SELECT  DF.OPTION_CD                                      
                INTO :WS-OPTION-CD                                      
                FROM  CSS_FIXED_FCTR    FF WITH(READUNCOMMITTED)                
                   ,  CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)                
               WHERE  FF.ACCOUNT_NO        = :UT-ACCOUNT-NO             
                 AND  FF.CODE_UTIL_TYPE    = :UT-CODE-UTIL-TYPE         
                 AND  FF.IC_NO             = :UT-IC-NO                  
                 AND  FF.FIXED_FCTR_SEQ_NO = :FF-FIXED-FCTR-SEQ-NO      
                 AND  DF.ACCOUNT_NO        = FF.ACCOUNT_NO              
                 AND  DF.CODE_UTIL_TYPE    = FF.CODE_UTIL_TYPE          
                 AND  DF.IC_NO             = FF.IC_NO                   
                 AND  DF.RT_PKG_OPT_SEQ_NO = FF.RT_PKG_OPT_SEQ_NO       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  DF.OPTION_CD                                              
MFA-TR*         INTO :WS-OPTION-CD                                              
MFA-TR*         FROM  CSS_FIXED_FCTR    FF                                      
MFA-TR*            ,  CSS_ACCT_RTPK_AGR DF                                      
MFA-TR*        WHERE  FF.ACCOUNT_NO        = :UT-ACCOUNT-NO                     
MFA-TR*          AND  FF.CODE_UTIL_TYPE    = :UT-CODE-UTIL-TYPE                 
MFA-TR*          AND  FF.IC_NO             = :UT-IC-NO                          
MFA-TR*          AND  FF.FIXED_FCTR_SEQ_NO = :FF-FIXED-FCTR-SEQ-NO              
MFA-TR*          AND  DF.ACCOUNT_NO        = FF.ACCOUNT_NO                      
MFA-TR*          AND  DF.CODE_UTIL_TYPE    = FF.CODE_UTIL_TYPE                  
MFA-TR*          AND  DF.IC_NO             = FF.IC_NO                           
MFA-TR*          AND  DF.RT_PKG_OPT_SEQ_NO = FF.RT_PKG_OPT_SEQ_NO               
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7710                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7700'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_ACCT_RTPKG_AGR'    TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2          
               MOVE 'IC_NO'                 TO TABLE-ELEMENT-3          
               MOVE UT-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               MOVE UT-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2        
               MOVE UT-IC-NO                TO HOSTVAR-ELEMENT-3        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7710-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **7720-GET-BN-REV-MONTH                                        **         
      ** GET THE REVNUE MONTH BASED ON BILL CYCLE                     **        
      ******************************************************************        
       7720-GET-BN-REV-MONTH.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT MIN(REVENUE_MONTH)                                 
                INTO :BN-REVENUE-MONTH :WS-NULL-IND-01                   
                FROM CSS_BILL_WINDOW WITH(READUNCOMMITTED)                      
               WHERE BILL_CYCLE    = :BN-BILL-CYCLE                     
                 AND DATE_EXTRACT >= CAST(SYSDATETIMEOFFSET() AS DATE)          
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MIN(REVENUE_MONTH)                                         
MFA-TR*         INTO :BN-REVENUE-MONTH:WS-NULL-IND-01                           
MFA-TR*         FROM CSS_BILL_WINDOW                                            
MFA-TR*        WHERE BILL_CYCLE    = :BN-BILL-CYCLE                             
MFA-TR*          AND DATE_EXTRACT >= CURRENT DATE                               
MFA-TR*      QUERYNO 7720                                                       
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF WS-NULL-IND-01 EQUAL -1                                
                 MOVE ZEROES                 TO BN-REVENUE-MONTH        
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7720'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_BILL_WINDOW'          TO TABLE-1                
              MOVE 'BILL_CYCLE'               TO TABLE-ELEMENT-1        
              MOVE BN-BILL-CYCLE              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7720-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7725-GET-RTPK-AGR-STATUS                                       *        
      ******************************************************************        
       7725-GET-RTPK-AGR-STATUS.                                        
                                                                        
           EXEC SQL                                                     
             SELECT  DF.RT_PKG_OPT_SEQ_NO                               
                    ,DF.STATUS_CD                                       
                    ,DF.STAT_ADJUSTABLE_CD                              
               INTO  :DF-RT-PKG-OPT-SEQ-NO                              
                    ,:WS-OLD-DF-STATUS-CD                               
                    ,:WS-OLD-DF-STAT-ADJ-CD                             
               FROM  CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)                 
                    ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                  
              WHERE DF.ACCOUNT_NO         = :DF-ACCOUNT-NO              
                AND DF.CODE_UTIL_TYPE     = :DF-CODE-UTIL-TYPE          
                AND DF.IC_NO              = :DF-IC-NO                   
                AND UT.ACCOUNT_NO         = DF.ACCOUNT_NO               
                AND UT.CODE_UTIL_TYPE     = DF.CODE_UTIL_TYPE           
                AND UT.IC_NO              = DF.IC_NO                    
                AND UT.RT_PKG_OPT_SEQ_NO  = DF.RT_PKG_OPT_SEQ_NO        
                                                                 
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  DF.RT_PKG_OPT_SEQ_NO                                       
MFA-TR*             ,DF.STATUS_CD                                               
MFA-TR*             ,DF.STAT_ADJUSTABLE_CD                                      
MFA-TR*        INTO  :DF-RT-PKG-OPT-SEQ-NO                                      
MFA-TR*             ,:WS-OLD-DF-STATUS-CD                                       
MFA-TR*             ,:WS-OLD-DF-STAT-ADJ-CD                                     
MFA-TR*        FROM  CSS_ACCT_RTPK_AGR DF                                       
MFA-TR*             ,CSS_UTIL_ENVRNMT UT                                        
MFA-TR*       WHERE DF.ACCOUNT_NO         = :DF-ACCOUNT-NO                      
MFA-TR*         AND DF.CODE_UTIL_TYPE     = :DF-CODE-UTIL-TYPE                  
MFA-TR*         AND DF.IC_NO              = :DF-IC-NO                           
MFA-TR*         AND UT.ACCOUNT_NO         = DF.ACCOUNT_NO                       
MFA-TR*         AND UT.CODE_UTIL_TYPE     = DF.CODE_UTIL_TYPE                   
MFA-TR*         AND UT.IC_NO              = DF.IC_NO                            
MFA-TR*         AND UT.RT_PKG_OPT_SEQ_NO  = DF.RT_PKG_OPT_SEQ_NO                
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7725                                                     
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7725'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_ACCT_RTPK_AGR'   TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2             
              MOVE 'IC_NO'               TO TABLE-ELEMENT-3             
              MOVE DF-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE DF-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2           
              MOVE DF-IC-NO              TO HOSTVAR-ELEMENT-3           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7725-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **7730-GET-MIN-REV-MONTH                                       **         
      ******************************************************************        
       7730-GET-MIN-REV-MONTH.                                          
      *                                                                         
           EXEC SQL                                                     
              SELECT MIN(REVENUE_MONTH)                                 
                INTO :BN-REVENUE-MONTH :WS-NULL-IND-02                   
                FROM CSS_BILL_WINDOW WITH(READUNCOMMITTED)                      
               WHERE DATE_EXTRACT >= CAST(SYSDATETIMEOFFSET() AS DATE)          
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MIN(REVENUE_MONTH)                                         
MFA-TR*         INTO :BN-REVENUE-MONTH:WS-NULL-IND-02                           
MFA-TR*         FROM CSS_BILL_WINDOW                                            
MFA-TR*        WHERE DATE_EXTRACT >= CURRENT DATE                               
MFA-TR*      QUERYNO 7730                                                       
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF WS-NULL-IND-02 EQUAL -1                                
                 MOVE ZEROES                 TO BN-REVENUE-MONTH        
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7730'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_BILL_WINDOW'          TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7730-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7800-CHK-DUR-EFFDATETO.                                        *        
      * VALIDATE DURATION REMAIN NO & EFF DATE TO.                     *        
      ******************************************************************        
       7800-CHK-DUR-EFFDATETO.                                          
                                                                        
           PERFORM 7850-GET-DURATION-DATA THRU 7850-EXIT.               
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF HQ-DURATION-NO > 0                                     
                 IF (WS-DURATION-REMAIN-NO EQUAL SPACES) OR             
                    (WS-DURATION-REMAIN-NO-NUM > HQ-DURATION-NO)        
                    MOVE 'MRM0000030'  TO S-BUS-RULE-ID                 
                    MOVE WS-FAILED     TO S-BUS-RULE-RESULT-CD          
                    PERFORM 5800-MOVE-BUSINESS-RULE                     
                                              THRU 5800-EXIT            
                 END-IF                                                 
P00805           IF WS-DURATION-REMAIN-NO-NUM <= WS-MONTHS-TO-RENEW     
                     AND                                                
                    ((WS-REVMTH-LSTNRML-CCYY NOT EQUAL                  
                                      WS-DATETO-NUM-CCYY) OR            
                    (WS-REVMTH-LSTNRML-MM NOT EQUAL                     
                                      WS-DATETO-NUM-MM))                
                  IF WS-DURATION-REMAIN-NO-NUM EQUAL ZEROES             
                    MOVE WS-REVMTH-LSTNRML-CCYY TO WS-DATETO-NUM-CCYY   
                    MOVE WS-REVMTH-LSTNRML-MM   TO WS-DATETO-NUM-MM     
                    MOVE '01'                   TO WS-DATETO-NUM-DD     
                    MOVE WS-DATE-TO-NUM         TO WS-DATE-END-OF-MTH   
                    PERFORM 7875-GET-END-OF-MTH THRU 7875-EXIT          
                    MOVE WS-DATE-END-OF-MTH     TO WS-DATE-TO-NUM       
                                                   WS-DATE-TO           
                    MOVE 0                      TO S-APPL-RETURN-CODE   
                    MOVE 'MRM0000033'           TO S-BUS-RULE-ID        
                    MOVE WS-PASSED              TO S-BUS-RULE-RESULT-CD 
                    PERFORM 7550-GET-RULE-XREF-ID  THRU 7550-EXIT       
                    PERFORM 8100-SEND-RESULT       THRU 8100-EXIT       
                  END-IF                                                
                                                                        
                  MOVE SPACES                   TO WS-RTPK-UPD-REQ-IND  
                                                                        
                  PERFORM 7880-CHK-OPT-ATTR-INCTV THRU 7880-EXIT        
                  IF WS-RTPK-UPD-REQ-IND = 'Y'                          
                     MOVE SPACES               TO WS-RTPK-PENDING-EXISTS
                     MOVE WS-ACCOUNT-NO        TO DF-ACCOUNT-NO         
                     MOVE PARM-IC-NO           TO DF-IC-NO              
                     MOVE PARM-CODE-UTIL-TYPE  TO DF-CODE-UTIL-TYPE     
                     PERFORM 7895-CHECK-PENDING-OPTION                  
                                               THRU 7895-EXIT           
                     IF WS-RTPK-PENDING-EXISTS ='Y'                     
                        MOVE 'MRM0000031'  TO S-BUS-RULE-ID             
                        MOVE WS-FAILED     TO S-BUS-RULE-RESULT-CD      
                        PERFORM 5800-MOVE-BUSINESS-RULE                 
                                                  THRU 5800-EXIT        
                     END-IF                                             
                  END-IF                                                
                 END-IF                                                 
              ELSE                                                      
                 PERFORM 7810-CHK-DUR-REM-NO     THRU 7810-EXIT         
              END-IF                                                    
           ELSE                                                         
              PERFORM 7860-GET-OPT-FCTR-DATA THRU 7860-EXIT             
              IF SQLCODE = 0                                            
                 MOVE 0             TO S-APPL-RETURN-CODE               
                 MOVE 'MRM0000034'  TO S-BUS-RULE-ID                    
                 MOVE WS-PASSED     TO S-BUS-RULE-RESULT-CD             
                 PERFORM 7550-GET-RULE-XREF-ID   THRU 7550-EXIT         
                 PERFORM 8100-SEND-RESULT        THRU 8100-EXIT         
              ELSE                                                      
                 PERFORM 7810-CHK-DUR-REM-NO     THRU 7810-EXIT         
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7800-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 7810-CHK-DUR-REM-NO.                                           *        
      * VALIDATE DURATION REMAIN NO                                    *        
      ******************************************************************        
       7810-CHK-DUR-REM-NO.                                             
                                                                        
           IF WS-DURATION-REMAIN-NO   EQUAL SPACES                      
              IF SF-DEFLT-DURATION-NO > 0                               
                 MOVE 'MRM0000030'  TO S-BUS-RULE-ID                    
                 MOVE WS-FAILED     TO S-BUS-RULE-RESULT-CD             
                 PERFORM 5800-MOVE-BUSINESS-RULE THRU 5800-EXIT         
              ELSE                                                      
                 SET DURATION-REMAIN-NULL   TO TRUE                     
              END-IF                                                    
              SET DURATION-REMAIN-NULL      TO TRUE                     
           ELSE                                                         
              IF SF-DEFLT-DURATION-NO > 0 AND                           
                 WS-DURATION-REMAIN-NO-NUM <= SF-DEFLT-DURATION-NO      
                 CONTINUE                                               
              ELSE                                                      
                 MOVE 'MRM0000030'  TO S-BUS-RULE-ID                    
                 MOVE WS-FAILED     TO S-BUS-RULE-RESULT-CD             
                 PERFORM 5800-MOVE-BUSINESS-RULE THRU 5800-EXIT         
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7810-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7850-GET-DURATION-DATA.                                        *        
      *     GET THE DURATION NO.                                       *        
      ******************************************************************        
       7850-GET-DURATION-DATA.                                          
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) HQ.DURATION_NO                                     
                INTO :HQ-DURATION-NO                                    
                FROM CRM_OPT_ATTR_INCTV HQ WITH(READUNCOMMITTED)                
               WHERE HQ.FACTOR_ID          = :HQ-FACTOR-ID              
                 AND HQ.OPTION_CD          = :HQ-OPTION-CD              
                 AND HQ.ATTR_INCTV_STRT_DT <= CAST(SYSDATETIMEOFFSET() 
           AS DATE)              
                 AND HQ.ATTR_INCTV_END_DT  >= CAST(SYSDATETIMEOFFSET() 
           AS DATE)              
                 AND HQ.OPT_ATTR_VSTART_TS <= CIS.CURRENT$TIMESTAMP()         
                 AND HQ.OPT_ATTR_VEND_TS   >= CIS.CURRENT$TIMESTAMP()         
                 AND HQ.PROC_STATUS_CD      = 'AC'                      
               ORDER BY HQ.ATTR_INCTV_STRT_DT                           
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT HQ.DURATION_NO                                             
MFA-TR*         INTO :HQ-DURATION-NO                                            
MFA-TR*         FROM CRM_OPT_ATTR_INCTV HQ                                      
MFA-TR*        WHERE HQ.FACTOR_ID          = :HQ-FACTOR-ID                      
MFA-TR*          AND HQ.OPTION_CD          = :HQ-OPTION-CD                      
MFA-TR*          AND HQ.ATTR_INCTV_STRT_DT <= CURRENT DATE                      
MFA-TR*          AND HQ.ATTR_INCTV_END_DT  >= CURRENT DATE                      
MFA-TR*          AND HQ.OPT_ATTR_VSTART_TS <= CURRENT TIMESTAMP                 
MFA-TR*          AND HQ.OPT_ATTR_VEND_TS   >= CURRENT TIMESTAMP                 
MFA-TR*          AND HQ.PROC_STATUS_CD      = 'AC'                              
MFA-TR*        ORDER BY HQ.ATTR_INCTV_STRT_DT                                   
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7850                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7850'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CRM_OPT_ATTR_INCTV'    TO TABLE-1                  
               MOVE 'OPTION_CD'             TO TABLE-ELEMENT-1          
               MOVE 'FACTOR_ID'             TO TABLE-ELEMENT-2          
               MOVE HQ-OPTION-CD            TO HOSTVAR-ELEMENT-1        
               MOVE HQ-FACTOR-ID            TO HOSTVAR-ELEMENT-2        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7850-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7860-GET-OPT-FCTR-DATA.                                        *        
      *     GET OPTION CD BASED ON FACTOR ID AND DURATION > 0          *        
      ******************************************************************        
       7860-GET-OPT-FCTR-DATA.                                          
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) HQ.OPTION_CD                                       
                INTO :HQ-OPTION-CD                                      
                FROM CRM_OPT_ATTR_INCTV HQ WITH(READUNCOMMITTED)                
               WHERE HQ.FACTOR_ID          = :HQ-FACTOR-ID              
                 AND HQ.DURATION_NO        > 0                          
                 AND HQ.ATTR_INCTV_STRT_DT <= CAST(SYSDATETIMEOFFSET() 
           AS DATE)              
                 AND HQ.ATTR_INCTV_END_DT  >= CAST(SYSDATETIMEOFFSET() 
           AS DATE)              
                 AND HQ.OPT_ATTR_VSTART_TS <= CIS.CURRENT$TIMESTAMP()         
                 AND HQ.OPT_ATTR_VEND_TS   >= CIS.CURRENT$TIMESTAMP()         
                 AND HQ.PROC_STATUS_CD      = 'AC'                      
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT HQ.OPTION_CD                                               
MFA-TR*         INTO :HQ-OPTION-CD                                              
MFA-TR*         FROM CRM_OPT_ATTR_INCTV HQ                                      
MFA-TR*        WHERE HQ.FACTOR_ID          = :HQ-FACTOR-ID                      
MFA-TR*          AND HQ.DURATION_NO        > 0                                  
MFA-TR*          AND HQ.ATTR_INCTV_STRT_DT <= CURRENT DATE                      
MFA-TR*          AND HQ.ATTR_INCTV_END_DT  >= CURRENT DATE                      
MFA-TR*          AND HQ.OPT_ATTR_VSTART_TS <= CURRENT TIMESTAMP                 
MFA-TR*          AND HQ.OPT_ATTR_VEND_TS   >= CURRENT TIMESTAMP                 
MFA-TR*          AND HQ.PROC_STATUS_CD      = 'AC'                              
MFA-TR*       FETCH FIRST ROW ONLY WITH UR                                      
MFA-TR*        QUERYNO 7860                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0 OR +100                                       
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7860'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CRM_OPT_ATTR_INCTV'    TO TABLE-1                  
               MOVE 'FACTOR_ID'             TO TABLE-ELEMENT-1          
               MOVE HQ-FACTOR-ID            TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7860-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7875-GET-END-OF-MTH.                                           *        
      *     GET END OF THE MONTH                                       *        
      ******************************************************************        
       7875-GET-END-OF-MTH.                                             
                                                                        
           EXEC SQL                                                     
            SELECT
              DATEADD( DAY, -1, DATEADD( MONTH, 1, 
              IIF(TRY_CONVERT(DATE, :WS-DATE-END-OF-MTH
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-END-OF-MTH
              ) <> 0) OR (LEN(:WS-DATE-END-OF-MTH
              ) <> 10), CIS.CHAR2DATE(:WS-DATE-END-OF-MTH
              ), CONVERT(DATE, :WS-DATE-END-OF-MTH) ) ) )
            INTO
              :WS-DATE-END-OF-MTH             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SET :WS-DATE-END-OF-MTH =                                           
MFA-TR*         DATE(:WS-DATE-END-OF-MTH) + 1 MONTH - 1 DAY                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0 OR +100                                       
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7875'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SET'                   TO ABEND-FUNCTION           
               MOVE '   '                   TO TABLE-1                  
               MOVE 'WS-DATE-END-OF-MTH'    TO TABLE-ELEMENT-1          
               MOVE WS-DATE-END-OF-MTH      TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7875-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7880-CHK-OPT-ATTR-INCTV                                        *        
      *     GET OPTION CD BASED ON FACTOR ID AND DURATION > 0          *        
      ******************************************************************        
       7880-CHK-OPT-ATTR-INCTV.                                         
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-RTPK-UPD-REQ-IND                               
                FROM CRM_OPT_ATTR_INCTV HQ WITH(READUNCOMMITTED)                
                    ,CSS_SPCL_FCTR SF WITH(READUNCOMMITTED)                     
               WHERE HQ.FACTOR_ID          = :HQ-FACTOR-ID              
                 AND HQ.OPTION_CD          = :HQ-OPTION-CD              
                 AND SF.FACTOR_ID          = HQ.FACTOR_ID               
                 AND SF.OVR_RT_CALC_TYP_CD = '02'                       
                 AND HQ.RT_ATTR_INCTV_TYPE =  'FIXED PRICE'             
                 AND HQ.ATTR_INCTV_STRT_DT <= CAST(SYSDATETIMEOFFSET() 
           AS DATE)              
                 AND HQ.ATTR_INCTV_END_DT  >= CAST(SYSDATETIMEOFFSET() 
           AS DATE)              
                 AND HQ.OPT_ATTR_VSTART_TS <= CIS.CURRENT$TIMESTAMP()         
                 AND HQ.OPT_ATTR_VEND_TS   >= CIS.CURRENT$TIMESTAMP()         
                 AND HQ.PROC_STATUS_CD      = 'AC'                      
               ORDER BY HQ.ATTR_INCTV_STRT_DT                           
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-RTPK-UPD-REQ-IND                                       
MFA-TR*         FROM CRM_OPT_ATTR_INCTV HQ                                      
MFA-TR*             ,CSS_SPCL_FCTR SF                                           
MFA-TR*        WHERE HQ.FACTOR_ID          = :HQ-FACTOR-ID                      
MFA-TR*          AND HQ.OPTION_CD          = :HQ-OPTION-CD                      
MFA-TR*          AND SF.FACTOR_ID          = HQ.FACTOR_ID                       
MFA-TR*          AND SF.OVR_RT_CALC_TYP_CD = '02'                               
MFA-TR*          AND HQ.RT_ATTR_INCTV_TYPE =  'FIXED PRICE'                     
MFA-TR*          AND HQ.ATTR_INCTV_STRT_DT <= CURRENT DATE                      
MFA-TR*          AND HQ.ATTR_INCTV_END_DT  >= CURRENT DATE                      
MFA-TR*          AND HQ.OPT_ATTR_VSTART_TS <= CURRENT TIMESTAMP                 
MFA-TR*          AND HQ.OPT_ATTR_VEND_TS   >= CURRENT TIMESTAMP                 
MFA-TR*          AND HQ.PROC_STATUS_CD      = 'AC'                              
MFA-TR*        ORDER BY HQ.ATTR_INCTV_STRT_DT                                   
MFA-TR*       FETCH FIRST ROW ONLY WITH UR                                      
MFA-TR*        QUERYNO 7880                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0 OR +100                                       
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7880'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CRM_OPT_ATTR_INCTV'    TO TABLE-1                  
               MOVE 'FACTOR_ID'             TO TABLE-ELEMENT-1          
               MOVE 'OPTION_CD'             TO TABLE-ELEMENT-2          
               MOVE HQ-FACTOR-ID            TO HOSTVAR-ELEMENT-1        
               MOVE HQ-OPTION-CD            TO HOSTVAR-ELEMENT-2        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
       7880-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      **************************************************************            
      * 7885-GET-BLOCK-PRICE-TYPE                                               
      *    -- THIS MODULE GETS THE PRICE TYPE OF THE BLOCK                      
      **************************************************************            
       7885-GET-BLOCK-PRICE-TYPE.                                       
      *                                                                         
           EXEC SQL                                                     
               SELECT TOP(1) PRICE_TYPE_CD                                     
                 INTO :PS-PRICE-TYPE-CD                                 
                 FROM CSS_PRICE_SCHED PS WITH(READUNCOMMITTED)                  
                WHERE PS.RATE_PLAN_NO       = :PS-RATE-PLAN-NO          
                  AND PS.CODE_UTIL_TYPE     = :PS-CODE-UTIL-TYPE        
                  AND PS.CMPNT_ID_CD        = :PS-CMPNT-ID-CD           
                  AND PS.CODE_SEASON        = :PS-CODE-SEASON           
                  AND PS.CODE_TIME_PERIOD   = :PS-CODE-TIME-PERIOD      
                  AND PS.CODE_USE_INST_TYPE = :PS-CODE-USE-INST-TYPE    
                  AND PS.BLOCK_NO           = :PS-BLOCK-NO              
                  AND PS.VERSION_NO_CNTRL = (                           
                      SELECT MAX(VERSION_NO_CNTRL)                      
                        FROM CSS_RATE_CREATOR WITH(READUNCOMMITTED)             
                       WHERE CODE_UTIL_TYPE = PS.CODE_UTIL_TYPE         
                         AND RATE_PLAN_NO   = PS.RATE_PLAN_NO           
                         AND CODE_STATUS    IN ('A','T' ) )             
                                                    
                                                                 
                                                            
      *                                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT PRICE_TYPE_CD                                             
MFA-TR*          INTO :PS-PRICE-TYPE-CD                                         
MFA-TR*          FROM CSS_PRICE_SCHED PS                                        
MFA-TR*         WHERE PS.RATE_PLAN_NO       = :PS-RATE-PLAN-NO                  
MFA-TR*           AND PS.CODE_UTIL_TYPE     = :PS-CODE-UTIL-TYPE                
MFA-TR*           AND PS.CMPNT_ID_CD        = :PS-CMPNT-ID-CD                   
MFA-TR*           AND PS.CODE_SEASON        = :PS-CODE-SEASON                   
MFA-TR*           AND PS.CODE_TIME_PERIOD   = :PS-CODE-TIME-PERIOD              
MFA-TR*           AND PS.CODE_USE_INST_TYPE = :PS-CODE-USE-INST-TYPE            
MFA-TR*           AND PS.BLOCK_NO           = :PS-BLOCK-NO                      
MFA-TR*           AND PS.VERSION_NO_CNTRL = (                                   
MFA-TR*               SELECT MAX(VERSION_NO_CNTRL)                              
MFA-TR*                 FROM CSS_RATE_CREATOR                                   
MFA-TR*                WHERE CODE_UTIL_TYPE = PS.CODE_UTIL_TYPE                 
MFA-TR*                  AND RATE_PLAN_NO   = PS.RATE_PLAN_NO                   
MFA-TR*                  AND CODE_STATUS    IN ('A','T' ) )                     
MFA-TR*          FETCH FIRST ROW ONLY                                           
MFA-TR*          WITH UR                                                        
MFA-TR*        QUERYNO 7885                                                     
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7885'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_PRICE_SCHED'       TO TABLE-1                  
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-1          
               MOVE 'RATE_PLAN_NO'          TO TABLE-ELEMENT-2          
               MOVE 'BLOCK_NO'              TO TABLE-ELEMENT-3          
               MOVE PS-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-1        
               MOVE PS-RATE-PLAN-NO         TO HOSTVAR-ELEMENT-2        
               MOVE PS-BLOCK-NO             TO HOSTVAR-ELEMENT-3        
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7885-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      **************************************************************            
      * 7890-GET-ALLOWED-BLOCK-NO                                               
      *    -- THIS MODULE GETS THE BLOCK NO FOR THE GIVE RATE PLAN N            
      *       AND COMPONENT ID AND CODE UTIL TYPE                               
      **************************************************************            
       7890-GET-ALLOWED-BLOCK-NO.                                       
      *                                                                         
           EXEC SQL                                                     
               SELECT TOP(1) MAX(BLOCK_NO)                                     
                 INTO :PS-BLOCK-NO :WS-BLOCK-NULL-ID                     
                 FROM CSS_PRICE_SCHED PS WITH(READUNCOMMITTED)                  
                WHERE PS.RATE_PLAN_NO       = :PS-RATE-PLAN-NO          
                  AND PS.CODE_UTIL_TYPE     = :PS-CODE-UTIL-TYPE        
                  AND PS.VERSION_NO_CNTRL = (                           
                      SELECT MAX(VERSION_NO_CNTRL)                      
                        FROM CSS_RATE_CREATOR WITH(READUNCOMMITTED)             
                       WHERE CODE_UTIL_TYPE = PS.CODE_UTIL_TYPE         
                         AND RATE_PLAN_NO   = PS.RATE_PLAN_NO           
                         AND CODE_STATUS    IN ('A','T' ) )             
                                                    
                                                                 
                                                            
      *                                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MAX(BLOCK_NO)                                             
MFA-TR*          INTO :PS-BLOCK-NO:WS-BLOCK-NULL-ID                             
MFA-TR*          FROM CSS_PRICE_SCHED PS                                        
MFA-TR*         WHERE PS.RATE_PLAN_NO       = :PS-RATE-PLAN-NO                  
MFA-TR*           AND PS.CODE_UTIL_TYPE     = :PS-CODE-UTIL-TYPE                
MFA-TR*           AND PS.VERSION_NO_CNTRL = (                                   
MFA-TR*               SELECT MAX(VERSION_NO_CNTRL)                              
MFA-TR*                 FROM CSS_RATE_CREATOR                                   
MFA-TR*                WHERE CODE_UTIL_TYPE = PS.CODE_UTIL_TYPE                 
MFA-TR*                  AND RATE_PLAN_NO   = PS.RATE_PLAN_NO                   
MFA-TR*                  AND CODE_STATUS    IN ('A','T' ) )                     
MFA-TR*          FETCH FIRST ROW ONLY                                           
MFA-TR*          WITH UR                                                        
MFA-TR*        QUERYNO 7890                                                     
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR                  
                  WS-BLOCK-NULL-ID = -1                                 
                  MOVE ZERO                 TO PS-BLOCK-NO              
               END-IF                                                   
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7000'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_PRICE_SCHED'       TO TABLE-1                  
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-1          
               MOVE 'RATE_PLAN_NO'          TO TABLE-ELEMENT-2          
               MOVE 'BLOCK_NO'              TO TABLE-ELEMENT-3          
               MOVE PS-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-1        
               MOVE PS-RATE-PLAN-NO         TO HOSTVAR-ELEMENT-2        
               MOVE PS-BLOCK-NO             TO HOSTVAR-ELEMENT-3        
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7890-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      **************************************************************            
      * 7895-CHECK-PENDING-OPTION                                               
      *    -- THIS MODULE SETS 'Y' IF PENDING OPTION EXISTS                     
      **************************************************************            
       7895-CHECK-PENDING-OPTION.                                       
      *                                                                         
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                 INTO :WS-RTPK-PENDING-EXISTS                           
                 FROM CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)                
                WHERE DF.ACCOUNT_NO     = :DF-ACCOUNT-NO                
                  AND DF.IC_NO          = :DF-IC-NO                     
                  AND DF.CODE_UTIL_TYPE = :DF-CODE-UTIL-TYPE            
                  AND DF.STATUS_CD      = 'P'                           
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-RTPK-PENDING-EXISTS                                   
MFA-TR*          FROM CSS_ACCT_RTPK_AGR DF                                      
MFA-TR*         WHERE DF.ACCOUNT_NO     = :DF-ACCOUNT-NO                        
MFA-TR*           AND DF.IC_NO          = :DF-IC-NO                             
MFA-TR*           AND DF.CODE_UTIL_TYPE = :DF-CODE-UTIL-TYPE                    
MFA-TR*           AND DF.STATUS_CD      = 'P'                                   
MFA-TR*          FETCH FIRST ROW ONLY                                           
MFA-TR*          WITH UR                                                        
MFA-TR*        QUERYNO 7895                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
                  MOVE SPACES               TO WS-RTPK-PENDING-EXISTS   
               END-IF                                                   
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7895'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_ACCT_RTPK_AGR'     TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE 'IC_NO'                 TO TABLE-ELEMENT-2          
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-3          
               MOVE DF-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               MOVE DF-IC-NO                TO HOSTVAR-ELEMENT-2        
               MOVE DF-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-3        
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7895-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 7900-CHK-ADJUSTABLE-FACTOR.                                *            
      *    -- CHECK IF THE ADJUSTABLE FACTOR BEING UPDATED IS FOR  *            
      *    -- THE CURRENT RT_PKG_OPTION.                           *            
      **************************************************************            
       7900-CHK-ADJUSTABLE-FACTOR.                                      
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-CURRENT-ADJ-FACTOR                             
                FROM CSS_UTIL_ENVRNMT  UT WITH(READUNCOMMITTED)                 
                    ,CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)                 
                    ,CSS_FIXED_FCTR    FF WITH(READUNCOMMITTED)                 
               WHERE UT.ACCOUNT_NO        = :UT-ACCOUNT-NO              
                 AND UT.IC_NO             = :UT-IC-NO                   
                 AND UT.CODE_UTIL_TYPE    = :UT-CODE-UTIL-TYPE          
                 AND DF.ACCOUNT_NO        = UT.ACCOUNT_NO               
                 AND DF.CODE_UTIL_TYPE    = UT.CODE_UTIL_TYPE           
                 AND DF.IC_NO             = UT.IC_NO                    
                 AND DF.RT_PKG_OPT_SEQ_NO = UT.RT_PKG_OPT_SEQ_NO        
                 AND FF.ACCOUNT_NO        = DF.ACCOUNT_NO               
                 AND FF.CODE_UTIL_TYPE    = DF.CODE_UTIL_TYPE           
                 AND FF.IC_NO             = DF.IC_NO                    
                 AND FF.RT_PKG_OPT_SEQ_NO = DF.RT_PKG_OPT_SEQ_NO        
                 AND FF.FACTOR_ID         = :PARM-FACTOR-ID             
                 AND FF.FIXED_FCTR_SEQ_NO = :FF-FIXED-FCTR-SEQ-NO       
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-CURRENT-ADJ-FACTOR                                     
MFA-TR*         FROM CSS_UTIL_ENVRNMT  UT                                       
MFA-TR*             ,CSS_ACCT_RTPK_AGR DF                                       
MFA-TR*             ,CSS_FIXED_FCTR    FF                                       
MFA-TR*        WHERE UT.ACCOUNT_NO        = :UT-ACCOUNT-NO                      
MFA-TR*          AND UT.IC_NO             = :UT-IC-NO                           
MFA-TR*          AND UT.CODE_UTIL_TYPE    = :UT-CODE-UTIL-TYPE                  
MFA-TR*          AND DF.ACCOUNT_NO        = UT.ACCOUNT_NO                       
MFA-TR*          AND DF.CODE_UTIL_TYPE    = UT.CODE_UTIL_TYPE                   
MFA-TR*          AND DF.IC_NO             = UT.IC_NO                            
MFA-TR*          AND DF.RT_PKG_OPT_SEQ_NO = UT.RT_PKG_OPT_SEQ_NO                
MFA-TR*          AND FF.ACCOUNT_NO        = DF.ACCOUNT_NO                       
MFA-TR*          AND FF.CODE_UTIL_TYPE    = DF.CODE_UTIL_TYPE                   
MFA-TR*          AND FF.IC_NO             = DF.IC_NO                            
MFA-TR*          AND FF.RT_PKG_OPT_SEQ_NO = DF.RT_PKG_OPT_SEQ_NO                
MFA-TR*          AND FF.FACTOR_ID         = :PARM-FACTOR-ID                     
MFA-TR*          AND FF.FIXED_FCTR_SEQ_NO = :FF-FIXED-FCTR-SEQ-NO               
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7900                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 'N'                   TO WS-CURRENT-ADJ-FACTOR    
              ELSE                                                      
                 CONTINUE                                               
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7900'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_FIXED_FCTR'         TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-2          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-3          
              MOVE UT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE UT-IC-NO                 TO HOSTVAR-ELEMENT-2        
              MOVE UT-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-3        
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8200-INSERT-FACTOR                                             *        
      ******************************************************************        
       8200-INSERT-FACTOR.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_FIXED_FCTR                                
                    ( ACCOUNT_NO                                        
                    , CODE_UTIL_TYPE                                    
                    , IC_NO                                             
                    , FACTOR_ID                                         
                    , FACTOR                                            
                    , BLOCK_NO                                          
                    , CODE_TIME_PERIOD                                  
                    , EFF_DATE_FROM                                     
                    , EFF_DATE_TO                                       
                    , INSTR_USE_TYPE_CD                                 
                    , CODE_SEASON                                       
                    , CMPNT_ID_CD                                       
                    , FIXED_FCTR_TYP_CD                                 
                    , FIXED_FCTR_SEQ_NO                                 
                    , FAC_CHRG_BASE_AM                                  
                    , DURATION_REMAIN_NO                                
                    , RT_PKG_OPT_SEQ_NO  )                              
              VALUES (:FF-ACCOUNT-NO                                    
                    , :PARM-CODE-UTIL-TYPE                              
                    , :PARM-IC-NO                                       
                    , :FF-FACTOR-ID                                     
                    , :FF-FACTOR                                        
                    , :FF-BLOCK-NO                                      
                    , :FF-CODE-TIME-PERIOD                              
                    , IIF(TRY_CONVERT(DATE, :FF-EFF-DATE-FROM 
                                            :IND-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :FF-EFF-DATE-FROM 
                                                         :IND-DATE-FROM
              ) <> 0) OR (LEN(:FF-EFF-DATE-FROM :IND-DATE-FROM
              ) <> 10), CIS.CHAR2DATE(:FF-EFF-DATE-FROM :IND-DATE-FROM
              ), CONVERT(DATE, :FF-EFF-DATE-FROM :IND-DATE-FROM) )             
                    , IIF(TRY_CONVERT(DATE, :FF-EFF-DATE-TO :IND-DATE-TO
              ) IS NULL OR (PATINDEX('%.%', :FF-EFF-DATE-TO 
                                                           :IND-DATE-TO
              ) <> 0) OR (LEN(:FF-EFF-DATE-TO :IND-DATE-TO
              ) <> 10), CIS.CHAR2DATE(:FF-EFF-DATE-TO :IND-DATE-TO
              ), CONVERT(DATE, :FF-EFF-DATE-TO :IND-DATE-TO) )                 
                    , :FF-INSTR-USE-TYPE-CD                             
                    , :FF-CODE-SEASON                                   
                    , :FF-CMPNT-ID-CD                                   
                    , :FF-FIXED-FCTR-TYP-CD                             
                    , :FF-FIXED-FCTR-SEQ-NO                             
                    , :FF-FAC-CHRG-BASE-AM                              
                    , :FF-DURATION-REMAIN-NO :WS-DURATION-REMAIN-NULL           
                    , :FF-RT-PKG-OPT-SEQ-NO   )                         
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_FIXED_FCTR                                        
MFA-TR*             ( ACCOUNT_NO                                                
MFA-TR*             , CODE_UTIL_TYPE                                            
MFA-TR*             , IC_NO                                                     
MFA-TR*             , FACTOR_ID                                                 
MFA-TR*             , FACTOR                                                    
MFA-TR*             , BLOCK_NO                                                  
MFA-TR*             , CODE_TIME_PERIOD                                          
MFA-TR*             , EFF_DATE_FROM                                             
MFA-TR*             , EFF_DATE_TO                                               
MFA-TR*             , INSTR_USE_TYPE_CD                                         
MFA-TR*             , CODE_SEASON                                               
MFA-TR*             , CMPNT_ID_CD                                               
MFA-TR*             , FIXED_FCTR_TYP_CD                                         
MFA-TR*             , FIXED_FCTR_SEQ_NO                                         
MFA-TR*             , FAC_CHRG_BASE_AM                                          
MFA-TR*             , DURATION_REMAIN_NO                                        
MFA-TR*             , RT_PKG_OPT_SEQ_NO  )                                      
MFA-TR*       VALUES (:FF-ACCOUNT-NO                                            
MFA-TR*             , :PARM-CODE-UTIL-TYPE                                      
MFA-TR*             , :PARM-IC-NO                                               
MFA-TR*             , :FF-FACTOR-ID                                             
MFA-TR*             , :FF-FACTOR                                                
MFA-TR*             , :FF-BLOCK-NO                                              
MFA-TR*             , :FF-CODE-TIME-PERIOD                                      
MFA-TR*             , :FF-EFF-DATE-FROM:IND-DATE-FROM                           
MFA-TR*             , :FF-EFF-DATE-TO:IND-DATE-TO                               
MFA-TR*             , :FF-INSTR-USE-TYPE-CD                                     
MFA-TR*             , :FF-CODE-SEASON                                           
MFA-TR*             , :FF-CMPNT-ID-CD                                           
MFA-TR*             , :FF-FIXED-FCTR-TYP-CD                                     
MFA-TR*             , :FF-FIXED-FCTR-SEQ-NO                                     
MFA-TR*             , :FF-FAC-CHRG-BASE-AM                                      
MFA-TR*             , :FF-DURATION-REMAIN-NO                                    
MFA-TR*               :WS-DURATION-REMAIN-NULL                                  
MFA-TR*             , :FF-RT-PKG-OPT-SEQ-NO   )                                 
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8200'                TO ACTIVE-PARAGRAPH            
              MOVE 'INSERT'              TO ABEND-FUNCTION              
              MOVE 'CSS_FIXED_FCTR'      TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'FACTOR_ID'           TO TABLE-ELEMENT-2             
              MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-3             
              MOVE 'IC_NO'               TO TABLE-ELEMENT-4             
              MOVE FF-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE WS-FACTOR-ID          TO HOSTVAR-ELEMENT-2           
              MOVE PARM-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-3           
              MOVE PARM-IC-NO            TO HOSTVAR-ELEMENT-4           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8300-DELETE-FACTOR                                                      
      ******************************************************************        
       8300-DELETE-FACTOR.                                              
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_FIXED_FCTR                                
              WHERE   ACCOUNT_NO        = :FF-ACCOUNT-NO                
                AND   CODE_UTIL_TYPE    = :PARM-CODE-UTIL-TYPE          
                AND   IC_NO             = :PARM-IC-NO                   
                AND   FIXED_FCTR_SEQ_NO = :FF-FIXED-FCTR-SEQ-NO         
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8300'                TO ACTIVE-PARAGRAPH            
              MOVE 'DELETE'              TO ABEND-FUNCTION              
              MOVE 'CSS_FIXED_FCTR'      TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2             
              MOVE 'IC_NO'               TO TABLE-ELEMENT-3             
              MOVE 'FIXED_FCTR_SEQ_NO'   TO TABLE-ELEMENT-4             
              MOVE FF-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE PARM-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-2           
              MOVE PARM-IC-NO            TO HOSTVAR-ELEMENT-3           
              MOVE FF-FIXED-FCTR-SEQ-NO  TO HOSTVAR-ELEMENT-4           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8400-EXPIRE-FIXED-FACTOR.                                     *         
      *****************************************************************         
       8400-EXPIRE-FIXED-FACTOR.                                        
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_FIXED_FCTR                                     
                 SET EFF_DATE_TO        = IIF(TRY_CONVERT(DATE, 
                                                        :FF-EFF-DATE-TO
              ) IS NULL OR (PATINDEX('%.%', :FF-EFF-DATE-TO
              ) <> 0) OR (LEN(:FF-EFF-DATE-TO) <> 10), CIS.CHAR2DATE(
                                                        :FF-EFF-DATE-TO
              ), CONVERT(DATE, :FF-EFF-DATE-TO) )               
               WHERE ACCOUNT_NO         = :FF-ACCOUNT-NO                
                 AND FACTOR_ID          = :FF-FACTOR-ID                 
                 AND CODE_UTIL_TYPE     = :FF-CODE-UTIL-TYPE            
                 AND IC_NO              = :FF-IC-NO                     
                 AND FIXED_FCTR_SEQ_NO  = :FF-FIXED-FCTR-SEQ-NO         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_FIXED_FCTR                                             
MFA-TR*          SET EFF_DATE_TO        = :FF-EFF-DATE-TO                       
MFA-TR*        WHERE ACCOUNT_NO         = :FF-ACCOUNT-NO                        
MFA-TR*          AND FACTOR_ID          = :FF-FACTOR-ID                         
MFA-TR*          AND CODE_UTIL_TYPE     = :FF-CODE-UTIL-TYPE                    
MFA-TR*          AND IC_NO              = :FF-IC-NO                             
MFA-TR*          AND FIXED_FCTR_SEQ_NO  = :FF-FIXED-FCTR-SEQ-NO                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8400'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE 'CSS_FIXED_FCTR'          TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE 'IC_NO'                   TO TABLE-ELEMENT-3         
              MOVE 'FIXED_FCTR_SEQ_NO'       TO TABLE-ELEMENT-4         
              MOVE FF-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE FF-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              MOVE FF-IC-NO                  TO HOSTVAR-ELEMENT-3       
              MOVE FF-FIXED-FCTR-SEQ-NO      TO HOSTVAR-ELEMENT-4       
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 8450-DELETE-FIXED-FACTOR.                                     *         
      *****************************************************************         
       8450-DELETE-FIXED-FACTOR.                                        
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_FIXED_FCTR                                
               WHERE ACCOUNT_NO        = :FF-ACCOUNT-NO                 
                 AND FACTOR_ID         = :FF-FACTOR-ID                  
                 AND CODE_UTIL_TYPE    = :FF-CODE-UTIL-TYPE             
                 AND IC_NO             = :FF-IC-NO                      
                 AND FIXED_FCTR_SEQ_NO = :FF-FIXED-FCTR-SEQ-NO          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8450'                    TO ACTIVE-PARAGRAPH        
              MOVE 'DELETE'                  TO ABEND-FUNCTION          
              MOVE 'CSS_FIXED_FCTR'          TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE 'IC_NO'                   TO TABLE-ELEMENT-3         
              MOVE 'FIXED_FCTR_SEQ_NO'       TO TABLE-ELEMENT-4         
              MOVE FF-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE FF-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              MOVE FF-IC-NO                  TO HOSTVAR-ELEMENT-3       
              MOVE FF-FIXED-FCTR-SEQ-NO      TO HOSTVAR-ELEMENT-4       
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8450-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 8500-UPDATE-FACTOR                                                      
      ******************************************************************        
       8500-UPDATE-FACTOR.                                              
                                                                        
           EXEC SQL                                                     
             UPDATE CSS_FIXED_FCTR                                      
                SET  FACTOR            = :FF-FACTOR                     
                    ,FACTOR_ID         = :FF-FACTOR-ID                  
                    ,BLOCK_NO          = :FF-BLOCK-NO                   
                    ,EFF_DATE_FROM     = IIF(TRY_CONVERT(DATE, 
                                                      :FF-EFF-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :FF-EFF-DATE-FROM
              ) <> 0) OR (LEN(:FF-EFF-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                      :FF-EFF-DATE-FROM
              ), CONVERT(DATE, :FF-EFF-DATE-FROM) )              
                    ,EFF_DATE_TO       = IIF(TRY_CONVERT(DATE, 
                                                        :FF-EFF-DATE-TO
              ) IS NULL OR (PATINDEX('%.%', :FF-EFF-DATE-TO
              ) <> 0) OR (LEN(:FF-EFF-DATE-TO) <> 10), CIS.CHAR2DATE(
                                                        :FF-EFF-DATE-TO
              ), CONVERT(DATE, :FF-EFF-DATE-TO) )                
                    ,CODE_SEASON       = :FF-CODE-SEASON                
                    ,INSTR_USE_TYPE_CD = :FF-INSTR-USE-TYPE-CD          
                    ,CODE_TIME_PERIOD  = :FF-CODE-TIME-PERIOD           
                    ,CMPNT_ID_CD       = :FF-CMPNT-ID-CD                
                    ,FIXED_FCTR_TYP_CD = :FF-FIXED-FCTR-TYP-CD          
                    ,FAC_CHRG_BASE_AM  = :FF-FAC-CHRG-BASE-AM           
                    ,DURATION_REMAIN_NO= :FF-DURATION-REMAIN-NO 
                                         :WS-DURATION-REMAIN-NULL       
              WHERE ACCOUNT_NO         = :FF-ACCOUNT-NO                 
                AND CODE_UTIL_TYPE     = :PARM-CODE-UTIL-TYPE           
                AND IC_NO              = :PARM-IC-NO                    
                AND FIXED_FCTR_SEQ_NO  = :FF-FIXED-FCTR-SEQ-NO          
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      UPDATE CSS_FIXED_FCTR                                              
MFA-TR*         SET  FACTOR            = :FF-FACTOR                             
MFA-TR*             ,FACTOR_ID         = :FF-FACTOR-ID                          
MFA-TR*             ,BLOCK_NO          = :FF-BLOCK-NO                           
MFA-TR*             ,EFF_DATE_FROM     = :FF-EFF-DATE-FROM                      
MFA-TR*             ,EFF_DATE_TO       = :FF-EFF-DATE-TO                        
MFA-TR*             ,CODE_SEASON       = :FF-CODE-SEASON                        
MFA-TR*             ,INSTR_USE_TYPE_CD = :FF-INSTR-USE-TYPE-CD                  
MFA-TR*             ,CODE_TIME_PERIOD  = :FF-CODE-TIME-PERIOD                   
MFA-TR*             ,CMPNT_ID_CD       = :FF-CMPNT-ID-CD                        
MFA-TR*             ,FIXED_FCTR_TYP_CD = :FF-FIXED-FCTR-TYP-CD                  
MFA-TR*             ,FAC_CHRG_BASE_AM  = :FF-FAC-CHRG-BASE-AM                   
MFA-TR*             ,DURATION_REMAIN_NO= :FF-DURATION-REMAIN-NO                 
MFA-TR*                                  :WS-DURATION-REMAIN-NULL               
MFA-TR*       WHERE ACCOUNT_NO         = :FF-ACCOUNT-NO                         
MFA-TR*         AND CODE_UTIL_TYPE     = :PARM-CODE-UTIL-TYPE                   
MFA-TR*         AND IC_NO              = :PARM-IC-NO                            
MFA-TR*         AND FIXED_FCTR_SEQ_NO  = :FF-FIXED-FCTR-SEQ-NO                  
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8500'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE 'CSS_FIXED_FCTR'      TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2             
              MOVE 'IC_NO'               TO TABLE-ELEMENT-3             
              MOVE 'FIXED_FCTR_SEQ_NO'   TO TABLE-ELEMENT-4             
              MOVE FF-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE PARM-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-2           
              MOVE PARM-IC-NO            TO HOSTVAR-ELEMENT-3           
              MOVE FF-FIXED-FCTR-SEQ-NO  TO HOSTVAR-ELEMENT-4           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8550-UPDATE-ACCT-RTPK-AGR                                      *        
      ******************************************************************        
       8550-UPDATE-ACCT-RTPK-AGR.                                       
                                                                        
           EXEC SQL                                                     
             UPDATE  CSS_ACCT_RTPK_AGR                                  
                                                                        
                SET  STATUS_CD          = :DF-STATUS-CD                 
                    ,LAST_UPDATE_TS     = CIS.CURRENT$TIMESTAMP()             
                    ,LAST_UPDATE_USERID = :PARM-USERID                  
ACT006              ,STATUS_CHANGE_DT   = CAST(SYSDATETIMEOFFSET() 
           AS DATE)                  
                                                                        
              WHERE ACCOUNT_NO          = :DF-ACCOUNT-NO                
                AND CODE_UTIL_TYPE      = :DF-CODE-UTIL-TYPE            
                AND IC_NO               = :DF-IC-NO                     
                AND RT_PKG_OPT_SEQ_NO   = :DF-RT-PKG-OPT-SEQ-NO         
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*      UPDATE  CSS_ACCT_RTPK_AGR                                          
MFA-TR*                                                                         
MFA-TR*         SET  STATUS_CD          = :DF-STATUS-CD                         
MFA-TR*             ,LAST_UPDATE_TS     = CURRENT TIMESTAMP                     
MFA-TR*             ,LAST_UPDATE_USERID = :PARM-USERID                          
MFA-TR*             ,STATUS_CHANGE_DT   = CURRENT DATE                          
MFA-TR*                                                                         
MFA-TR*       WHERE ACCOUNT_NO          = :DF-ACCOUNT-NO                        
MFA-TR*         AND CODE_UTIL_TYPE      = :DF-CODE-UTIL-TYPE                    
MFA-TR*         AND IC_NO               = :DF-IC-NO                             
MFA-TR*         AND RT_PKG_OPT_SEQ_NO   = :DF-RT-PKG-OPT-SEQ-NO                 
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8550'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE 'CSS_ACCT_RTPK_AGR'   TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2             
              MOVE 'IC_NO'               TO TABLE-ELEMENT-3             
              MOVE 'RT_PKG_OPT_SEQ_NO'   TO TABLE-ELEMENT-4             
              MOVE DF-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE DF-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2           
              MOVE DF-IC-NO              TO HOSTVAR-ELEMENT-3           
              MOVE DF-RT-PKG-OPT-SEQ-NO  TO HOSTVAR-ELEMENT-4           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8560-UPDATE-ACCT-RTPK-AGR                                      *        
      ******************************************************************        
       8560-UPDATE-ACCT-RTPK-AGR.                                       
                                                                        
           EXEC SQL                                                     
             UPDATE  CSS_ACCT_RTPK_AGR                                  
                                                                        
                SET  STAT_ADJUSTABLE_CD = :DF-STAT-ADJUSTABLE-CD        
                    ,LAST_UPDATE_TS     = CIS.CURRENT$TIMESTAMP()             
                    ,LAST_UPDATE_USERID = :PARM-USERID                  
                                                                        
              WHERE ACCOUNT_NO          = :DF-ACCOUNT-NO                
                AND CODE_UTIL_TYPE      = :DF-CODE-UTIL-TYPE            
                AND IC_NO               = :DF-IC-NO                     
                AND RT_PKG_OPT_SEQ_NO   = :DF-RT-PKG-OPT-SEQ-NO         
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*      UPDATE  CSS_ACCT_RTPK_AGR                                          
MFA-TR*                                                                         
MFA-TR*         SET  STAT_ADJUSTABLE_CD = :DF-STAT-ADJUSTABLE-CD                
MFA-TR*             ,LAST_UPDATE_TS     = CURRENT TIMESTAMP                     
MFA-TR*             ,LAST_UPDATE_USERID = :PARM-USERID                          
MFA-TR*                                                                         
MFA-TR*       WHERE ACCOUNT_NO          = :DF-ACCOUNT-NO                        
MFA-TR*         AND CODE_UTIL_TYPE      = :DF-CODE-UTIL-TYPE                    
MFA-TR*         AND IC_NO               = :DF-IC-NO                             
MFA-TR*         AND RT_PKG_OPT_SEQ_NO   = :DF-RT-PKG-OPT-SEQ-NO                 
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8560'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE 'CSS_ACCT_RTPK_AGR'   TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2             
              MOVE 'IC_NO'               TO TABLE-ELEMENT-3             
              MOVE 'RT_PKG_OPT_SEQ_NO'   TO TABLE-ELEMENT-4             
              MOVE DF-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE DF-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2           
              MOVE DF-IC-NO              TO HOSTVAR-ELEMENT-3           
              MOVE DF-RT-PKG-OPT-SEQ-NO  TO HOSTVAR-ELEMENT-4           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8560-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8700-UPDATE-UTIL-ENV                                                    
      ******************************************************************        
       8700-UPDATE-UTIL-ENV.                                            
                                                                        
           EXEC SQL                                                     
             UPDATE CSS_UTIL_ENVRNMT                                    
                SET ONERATE_ANNIV_MO = :WS-ONERATE-ANNIV-RED            
              WHERE ACCOUNT_NO       = :UT-ACCOUNT-NO                   
                AND IC_NO            = :UT-IC-NO                        
                AND CODE_UTIL_TYPE   = :UT-CODE-UTIL-TYPE               
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8700'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE 'CSS_UTIL_ENVRNMT'    TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2             
              MOVE 'IC_NO'               TO TABLE-ELEMENT-3             
              MOVE UT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE UT-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2           
              MOVE UT-IC-NO              TO HOSTVAR-ELEMENT-3           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8100-SEND-RESULT.                                                
                                                                        
           ADD +1                            TO CTR-ROWS.               
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CPD00321                                                 
           END-EXEC.                                                            
