       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04654.                                         
COB303 DATE-WRITTEN.  SEP 20, 2013                                      
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------         
      *--                 SOUTH CAROLINA ELECTRIC & GAS              --         
      *----------------------------------------------------------------         
      *--                  STORED PROCEDURE:  CSR04654               --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--  CSR04654 :                                                --         
      *--                                                            --         
      *--   SP CALLED FROM METERING & RATE MAINTENANCE FIXED FACTORS --         
      *--   VIEW OF CIS PORTAL TO RETRIEVE ALL FIXED/COMBO FACTORS   --         
      *--   FOR ACCOUNT, UTILITY TYPE & IC COMBINATION.              --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *--  PARAMETERS                                                --         
      *--                                                            --         
      *--      INPUT                                                 --         
      *--           ACCOUNT_NO              CHAR(13)                 --         
      *--           CODE_UTIL_TYPE          CHAR(01)                 --         
      *--           IC_NO                   SMALLINT                 --         
      *--      OUT                                                   --         
      *--           NONE                                             --         
      *--                                                            --         
      *--      INOUT                                                 --         
      *--           NONE                                             --         
      *--                                                            --         
      *--  RESULT SET                                                --         
      *--      1. CSR04654_R1 - ACCOUNT FIXED/COMBO FACTORS DATA.    --         
      *--           RETURN_CODE             INTEGER                  --         
      *--           FACTOR_ID               CHAR(09)                 --         
      *--           FACTOR                  DECIMAL(13,6)            --         
      *--           START_DATE              CHAR(10)                 --         
      *--           END_DATE                CHAR(10)                 --         
      *--           SEASON                  CHAR(01)                 --         
      *--           USE_CODE                CHAR(01)                 --         
      *--           TIME_PERIOD             CHAR(01)                 --         
      *--           COMPONENT_ID            CHAR(02)                 --         
      *--           FIXED_FACTOR_TYPE_CD    CHAR(02)                 --         
      *--           FIXED_FACTOR_SEQ_NO     SMALLINT                 --         
      *--           FAC_CHRG_BASE_AM        DECIMAL(7,2)             --         
      *--           DURATION_REMAIN_NO      CHAR(04)                 --         
      *--           BLOCK_NO                SMALLINT                 --         
      *--           NXT_BILL_START          CHAR(10)                 --         
      *--           NXT_BILL_END            CHAR(10)                 --         
      *--           CODE_BILL_TYPE          CHAR(01)                 --         
      *--           RATE_ATTRIBUTE          CHAR(01)                 --         
A05065*--           OPT_DESC_INT            CHAR(66)                 --         
A05065*--           RT_PKG_OPT_SEQ_NO       SMALLINT                 --         
      *--                                                            --         
      *--      2. CSR04654_R2 - BUSINESS RULES.                      --         
      *--           RETURN_CODE             INTEGER                  --         
      *--           BUS_RULE_ID             CHAR(10)                 --         
      *--           ACTION_TYPE_CD          CHAR(08)                 --         
      *--           BUS_RULE_XREF_ID        CHAR(26)                 --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                      MODIFICATION LOG                      --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
P00738*--  09/20/2013    SS97726     PROCEDURE ORIGINALLY CODED.     --         
A05065*--  11/07/2014    VP43661     OPT DESC & SEQ# ADDED TO GTT    --         
A05065*--  11/19/2014    MR7E794     SEB CSC CHANGES.                --         
A05065*--                ACT298                                      --         
      *----------------------------------------------------------------         
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04654'.
MSQ017     COPY MFASQLM.
                                                                        
      *                                                                         
       01 WS-START                          PIC X(40) VALUE             
            'WORKING STORAGE FOR CSR04654 STARTS HERE'.                 
      *                                                                         
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-SUBROUTINE-IDS.                                       
               10  CSRERLOG                 PIC X(8)  VALUE 'CSRERLOG'. 
           05  PROGRAM-NAME                 PIC X(08) VALUE 'CSR04654'. 
      *                                                                         
       01  PARM-FIELDS.                                                 
           05  PARM-L                       PIC S9(9) COMP.             
COB305     05 PARM-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.   
           05  PARM-CODE-UTIL-TYPE          PIC X(01).                  
           05  PARM-IC-NO                   PIC S9(4) COMP.             
      *                                                                         
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS-RS1                 PIC S9(9) COMP VALUE 0.     
           05  CTR-ROWS-RS2                 PIC S9(9) COMP VALUE 0.     
      *                                                                         
       01  WS-NULL-INDICATORS.                                          
           05  IND-REVENUE-MONTH            PIC S9(4) COMP.             
           05  IND-DATE-TO                  PIC S9(04) COMP.            
           05  IND-DATE-FROM                PIC S9(04) COMP.            
           05  IND-BLOCK-NO                 PIC S9(04) COMP.            
           05  IND-DURATION-REMAIN-NO       PIC S9(04) COMP.            
      *                                                                         
A05065*****************************************************************         
A05065*    SUPPORT FOR MCSCB063                                                 
A05065*****************************************************************         
A05065     COPY CWS00063.                                                       
A05065*                                                                         
       01  WS-MISC.                                                     
           05  WS-YES                       PIC X(01) VALUE 'Y'.        
           05  WS-NO                        PIC X(01) VALUE 'N'.        
           05  WS-ACTIVE-CODE               PIC X(01) VALUE 'A'.        
           05  WS-SQLSTATE                  PIC X(05) VALUE SPACES.     
           05  WS-GTT-NAME                  PIC X(19) VALUE SPACES.     
           05  WS-GTT01-DECLARED            PIC X(01) VALUE 'N'.        
           05  WS-GTT02-DECLARED            PIC X(01) VALUE 'N'.        
           05  WS-YES-NULL                  PIC S9(4) VALUE -1.         
           05  WS-DATE-RESULT               PIC X(10) VALUE SPACES.     
           05  WS-REVN-PRT-DT-FRM           PIC X(10) VALUE SPACES.     
           05  WS-OTHR-PRT-DT-FRM           PIC X(10) VALUE SPACES.     
           05  WS-REVN-PRT-DT-TO            PIC X(10) VALUE SPACES.     
           05  WS-OTHR-PRT-DT-TO            PIC X(10) VALUE SPACES.     
           05  WS-ADD-ONE-MTH               PIC X(10) VALUE SPACES.     
           05  WS-START-DATE.                                           
               10 WS-START-YR               PIC X(04) VALUE SPACES.     
               10 FILLER                    PIC X(01) VALUE '-'.        
               10 WS-START-MT               PIC X(02) VALUE SPACES.     
               10 FILLER                    PIC X(01) VALUE '-'.        
               10 WS-START-DY               PIC X(02) VALUE SPACES.     
           05  WS-REV-MTH-LST-NRML          PIC S9(6) VALUE ZEROES.     
           05  WS-REV-MTH-LST-NRML-C        PIC X(06) VALUE SPACES.     
           05  WS-NXT-BILL-START            PIC X(10) VALUE SPACES.     
           05  WS-NXT-BILL-END              PIC X(10) VALUE SPACES.     
           05  WS-REVENUE-MONTH             PIC X(06) VALUE SPACES.     
           05  WS-REVENUE-MONTH-N           PIC 9(06) VALUE ZEROES.     
           05  WS-DUR-RMN-NO-TEMP-1         PIC 9(04).                  
           05  WS-DUR-RMN-NO-TEMP-2         PIC ZZZ9.                   
           05  WS-FACTOR-VALUE              PIC S9(9)V9(6) COMP-3       
                                                      VALUE ZERO.       
           05  WS-CODE-TIME-PERIOD          PIC 9(01) VALUE ZERO.       
A05065     05  WS-OPT-DESC-INT              PIC X(66) VALUE SPACES.     
A05065*                                                                         
A05065     05  MCSCB063                     PIC X(08)                   
                                                    VALUE 'MCSCB063'.   
A05065     05  WS-MCSCB063-RET-CODE         PIC S9(04) COMP VALUE 0.    
A05065     05  WS-CSC-AMT-DESC              PIC $Z9.99.                 
A05065     05  WS-CSC-LIT-DESC              PIC X(04) VALUE ' CSC'.     
A05065                                                                  
A05065 01  WS-STATUS-EFF-REV-MTH            PIC 9(06) VALUE ZEROS.      
A05065                                                                  
A05065 01  WS-EFF-REV-MTH-DATE.                                         
A05065     05  WS-EFF-REV-MTH-YR            PIC X(04) VALUE SPACES.     
A05065     05  WS-DASH1                     PIC X(01) VALUE SPACES.     
A05065     05  WS-EFF-REV-MTH-MM            PIC X(02) VALUE SPACES.     
A05065     05  WS-DASH2                     PIC X(01) VALUE SPACES.     
A05065     05  WS-EFF-REV-MTH-DD            PIC X(02) VALUE SPACES.     
      *                                                                         
       01  WS-SWITCHES.                                                 
           05  WS-NO-MORE-ROWS              PIC X(01) VALUE 'N'.        
               88 NO-MORE-ROWS                        VALUE 'Y'.        
           05  ALL-DONE-SW                  PIC X(01) VALUE 'N'.        
               88 NOT-ALL-DONE                        VALUE 'N'.        
               88 ALL-DONE                            VALUE 'Y'.        
           05  SEND-DONE-SW                 PIC X(01) VALUE 'Y'.        
               88 SEND-DONE-ERROR                     VALUE 'N'.        
               88 SEND-DONE-OK                        VALUE 'Y'.        
           05  WS-DATABASE                  PIC 9(01) VALUE ZERO.       
               88 CSR-DATABASE                        VALUE 1.          
               88 SEB-DATABASE                        VALUE 2.          
           05  WS-CNS-ROW-FOUND             PIC X(01) VALUE 'N'.        
               88 CNS-ROW-FOUND                       VALUE 'Y'.        
           05  WS-RATE-ATTRIBUTE            PIC X(01) VALUE 'N'.        
               88 RATE-ATTRIBUTE                      VALUE 'Y'.        
      *                                                                         
      ******************************************************************        
      *    ERROR PROCESSING VARIABLES                                  *        
      ******************************************************************        
      *                                                                         
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                    PIC X(18) VALUE SPACES.     
           10  S-SQLCODE                    PIC S9(9) COMP VALUE 0.     
           10  S-SQLSTATE                   PIC X(5)  VALUE ' '.        
           10  S-TABLE-NAME                 PIC X(18) VALUE SPACES.     
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L       PIC S9(4) USAGE COMP.       
               49  S-HOST-VARIABLES-V       PIC X(255).                 
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L        PIC S9(4) USAGE COMP.       
               49  S-SQL-STATEMENT-V        PIC X(255).                 
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L      PIC S9(4) USAGE COMP.       
               49  S-SQL-DESCRIPTION-V      PIC X(255).                 
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L      PIC S9(4) USAGE COMP.       
               49  WS-ABEND-SQLERRMC-V      PIC X(255).                 
      *                                                                         
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE               PIC S9(9) COMP VALUE 0.     
      *                                                                         
       01 GTT-RETURN-FIELDS.                                            
      ******************************************************************        
      *   GTT TABLE LAYOUT FIXED FACTORS FOR ACCOUNT DATA.             *        
      ******************************************************************        
          05  GTT-RETURN-FIELDS-RS1.                                    
              10  S-RETURN-CODE-RS1         PIC S9(9) COMP VALUE ZERO.  
              10  S-FACTOR-ID-RS1           PIC X(09) VALUE SPACES.     
              10  S-FACTOR-RS1              PIC S9(9)V9(6) COMP-3       
                                                      VALUE ZERO.       
              10  S-START-DATE-RS1          PIC X(10) VALUE SPACES.     
              10  S-END-DATE-RS1            PIC X(10) VALUE SPACES.     
              10  S-SEASON-RS1              PIC X(01) VALUE SPACES.     
              10  S-USE-CODE-RS1            PIC X(01) VALUE SPACES.     
              10  S-TIME-PERIOD-RS1         PIC X(01) VALUE SPACES.     
              10  S-COMPONENT-ID-RS1        PIC X(02) VALUE SPACES.     
              10  S-FXD-FCTR-TYPE-CD-RS1    PIC X(02) VALUE SPACES.     
              10  S-FXD-FCTR-SEQ-NO-RS1     PIC S9(4) USAGE COMP        
                                                      VALUE ZERO.       
              10  S-FAC-CHRG-BASE-AM-RS1    PIC S9(7)V9(2) COMP-3       
                                                      VALUE ZERO.       
              10  S-DURATION-REMAIN-NO-RS1  PIC X(04) VALUE SPACES.     
              10  S-BLOCK-NO-RS1            PIC S9(4) COMP VALUE ZERO.  
              10  S-NXT-BILL-START-RS1      PIC X(10) VALUE SPACES.     
              10  S-NXT-BILL-END-RS1        PIC X(10) VALUE SPACES.     
              10  S-CODE-BILL-TYPE-RS1      PIC X(01) VALUE SPACES.     
              10  S-RATE-ATTRIBUTE-RS1      PIC X(01) VALUE SPACES.     
A05065        10  S-OPT-DESC-INT            PIC X(66) VALUE SPACES.     
A05065        10  S-RT-PKG-OPT-SEQ-NO       PIC S9(4) COMP VALUE ZERO.  
      *                                                                         
      ******************************************************************        
      *   GTT TABLE LAYOUT FOR BUSINESS RULES.                         *        
      ******************************************************************        
          05  GTT-RETURN-FIELDS-RS2.                                    
              10  S-RETURN-CODE-RS2         PIC S9(9) COMP VALUE ZERO.  
              10  S-BUS-RULE-ID-RS2         PIC X(10) VALUE SPACES.     
              10  S-ACTION-TYPE-CD-RS2      PIC X(08) VALUE SPACES.     
              10  S-BUS-RULE-XREF-ID-RS2    PIC X(26) VALUE SPACES.     
      *                                                                         
      ******************************************************************        
      *               COBOL WORKING STORAGE COPY BOOKS                 *        
      ******************************************************************        
      *                                                                         
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_DELINQUENCY,    C8                                         *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_ACCOUNT,        AT                                         *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_BILL_WINDOW,    BN                                         *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBBILWDW                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_READ_WINDOW,    RW                                         *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBRDWNDW                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_SPCL_FCTR,      SF                                         *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBSPLFTR                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_FIXED_FCTR,     FF                                         *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBFXDFCT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_ACCT_RTPK_AGR,  DF                                         *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBACCTRG                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CRM_OPT_ATTR_INCTV, HQ                                                  
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBOPTATT                                                  
           END-EXEC.                                                            
A05065*                                                                         
A05065******************************************************************        
A05065* CRM_RT_PKG_OPTION, FI                                          *        
A05065******************************************************************        
A05065*                                                                         
A05065      EXEC SQL                                                            
A05065         INCLUDE TBRTPKGO                                                 
A05065      END-EXEC.                                                           
A05065*                                                                         
      ******************************************************************        
      * CSS_UTL_ENVRMNT,    UT                                         *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_SPCL_FCTR_APPL, SA                                         *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBSPLAPL                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_BILLING_DET,    BG                                         *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBBLLDET                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_BILLING_HDR,    BI                                         *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBBLLHDR                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_CNSMPTN_HIST,   CX                                         *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCNSMP                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_JOB_PARM,       G6                                         *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    ERROR HANDLING                                                       
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    SUPPORTS DB2 AND SQL ERROR CHECKING                         *        
      ******************************************************************        
      *                                                                         
           COPY CWS00303.                                                       
      *                                                                         
      ******************************************************************        
      *    CURSOR DECLARATIONS.                                        *        
      ******************************************************************        
      *                                                                         
      ******************************************************************        
      *    GET ALL FIXED/COMBO FACTORS FOR THE ACCOUNT.                *        
      ******************************************************************        
      *                                                                         
            EXEC SQL                                                    
                DECLARE ACCOUNT_FACTORS CURSOR FOR                      
                 SELECT  SF.FACTOR_ID                                   
                       ,(CIS.DECIMAL2DECIMAL3(FF.FACTOR                         
                               * POWER(10.0,SF.FCTR_POWER_10),13,6))    
                       , FF.EFF_DATE_FROM                               
                       , FF.EFF_DATE_TO                                 
                       , FF.CODE_SEASON                                 
                       , FF.INSTR_USE_TYPE_CD                           
                       , FF.CODE_TIME_PERIOD                            
                       , SF.VERS_PRORATE_CD                             
                       , FF.CMPNT_ID_CD                                 
                       , FF.FIXED_FCTR_TYP_CD                           
                       , FF.FIXED_FCTR_SEQ_NO                           
                       , FF.FAC_CHRG_BASE_AM                            
                       , FF.DURATION_REMAIN_NO                          
                       , FF.BLOCK_NO                                    
A05065                 , FF.RT_PKG_OPT_SEQ_NO                           
                   FROM  CSS_FIXED_FCTR FF WITH(READUNCOMMITTED)                
                       , CSS_SPCL_FCTR  SF WITH(READUNCOMMITTED)                
                  WHERE  SF.FACTOR_ID      =  FF.FACTOR_ID              
                    AND  FF.ACCOUNT_NO     = :FF-ACCOUNT-NO             
                    AND  FF.CODE_UTIL_TYPE = :FF-CODE-UTIL-TYPE         
                    AND  FF.IC_NO          = :FF-IC-NO                  
                    AND  SF.FACTOR_TYPE IN ('B','F','V')                
                  ORDER BY  FF.EFF_DATE_TO DESC                         
                          , FF.EFF_DATE_FROM DESC                       
                          , SF.FACTOR_TEXT ASC                          
                 FOR READ ONLY                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DECLARE ACCOUNT_FACTORS CURSOR FOR                              
MFA-TR*          SELECT  SF.FACTOR_ID                                           
MFA-TR*                ,(DECIMAL(FF.FACTOR                                      
MFA-TR*                        * POWER(10.0,SF.FCTR_POWER_10),13,6))            
MFA-TR*                , FF.EFF_DATE_FROM                                       
MFA-TR*                , FF.EFF_DATE_TO                                         
MFA-TR*                , FF.CODE_SEASON                                         
MFA-TR*                , FF.INSTR_USE_TYPE_CD                                   
MFA-TR*                , FF.CODE_TIME_PERIOD                                    
MFA-TR*                , SF.VERS_PRORATE_CD                                     
MFA-TR*                , FF.CMPNT_ID_CD                                         
MFA-TR*                , FF.FIXED_FCTR_TYP_CD                                   
MFA-TR*                , FF.FIXED_FCTR_SEQ_NO                                   
MFA-TR*                , FF.FAC_CHRG_BASE_AM                                    
MFA-TR*                , FF.DURATION_REMAIN_NO                                  
MFA-TR*                , FF.BLOCK_NO                                            
MFA-TR*                , FF.RT_PKG_OPT_SEQ_NO                                   
MFA-TR*            FROM  CSS_FIXED_FCTR FF                                      
MFA-TR*                , CSS_SPCL_FCTR  SF                                      
MFA-TR*           WHERE  SF.FACTOR_ID      =  FF.FACTOR_ID                      
MFA-TR*             AND  FF.ACCOUNT_NO     = :FF-ACCOUNT-NO                     
MFA-TR*             AND  FF.CODE_UTIL_TYPE = :FF-CODE-UTIL-TYPE                 
MFA-TR*             AND  FF.IC_NO          = :FF-IC-NO                          
MFA-TR*             AND  SF.FACTOR_TYPE IN ('B','F','V')                        
MFA-TR*           ORDER BY  FF.EFF_DATE_TO DESC                                 
MFA-TR*                   , FF.EFF_DATE_FROM DESC                               
MFA-TR*                   , SF.FACTOR_TEXT ASC                                  
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*          QUERYNO 7300                                                   
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      *                                                                         
       LINKAGE SECTION.                                                 
COB305 01 I-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.   
       01  I-CODE-UTIL-TYPE                 PIC X(01).                  
       01  I-IC-NO                          PIC S9(4) COMP.             
      *                                                                         
       PROCEDURE DIVISION USING I-ACCOUNT-NO                            
                               ,I-CODE-UTIL-TYPE                        
                               ,I-IC-NO.                                
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE             THRU 0100-EXIT.          
           PERFORM 1000-PROCESS-INPUT          THRU 1000-EXIT.          
           PERFORM 2000-BUILD-RESULT           THRU 2000-EXIT.          
           PERFORM 9999-END-PROGRAM            THRU 9999-EXIT.          
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE 'N'                         TO WS-GTT01-DECLARED        
                                               WS-GTT02-DECLARED.       
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1        THRU 0100A-EXIT.         
           PERFORM 0100B-DECLARE-GTT-R2        THRU 0100B-EXIT.         
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100A-DECLARE-GTT-R1 - ACCOUNT FIXED/COMBO FACTORS DATA.       *        
      ******************************************************************        
       0100A-DECLARE-GTT-R1.                                            
                                                                        
           MOVE 'SESSION.CSR04654_R1'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04654_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04654_R1
              (                                                      
                    RETURN_CODE             INT                     
                   ,FACTOR_ID CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,FACTOR                  DECIMAL(13,6)               
                   ,START_DATE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,END_DATE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,SEASON CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2            
                   ,USE_CODE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,TIME_PERIOD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,COMPONENT_ID CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,FIXED_FACTOR_TYPE_CD CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,FIXED_FACTOR_SEQ_NO     SMALLINT                    
                   ,FAC_CHRG_BASE_AM        DECIMAL(9,2)                
                   ,DURATION_REMAIN_NO CHAR(04)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BLOCK_NO                SMALLINT                    
                   ,NXT_BILL_START CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,NXT_BILL_END CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,CODE_BILL_TYPE CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,RATE_ATTRIBUTE CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
A05065             ,OPT_DESC_INT CHAR(66)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
A05065             ,RT_PKG_OPT_SEQ_NO       SMALLINT                    
                 )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS       THRU 8000A-EXIT          
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE 'Y'                   TO WS-GTT01-DECLARED        
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100A'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT           
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE           AS RETURN_CODE             
                      ,LTRIM(RTRIM(FACTOR_ID))      AS FACTOR_ID               
                      ,FACTOR                AS FACTOR                  
                      ,LTRIM(RTRIM(START_DATE))     AS START_DATE              
                      ,LTRIM(RTRIM(END_DATE))       AS END_DATE                
                      ,LTRIM(RTRIM(SEASON))         AS SEASON                  
                      ,LTRIM(RTRIM(USE_CODE))       AS USE_CODE                
                      ,LTRIM(RTRIM(TIME_PERIOD))    AS TIME_PERIOD             
                      ,LTRIM(RTRIM(COMPONENT_ID))   AS COMPONENT_ID            
                      ,LTRIM(RTRIM(FIXED_FACTOR_TYPE_CD))                      
                                             AS FIXED_FACTOR_TYPE_CD    
                      ,FIXED_FACTOR_SEQ_NO   AS FIXED_FACTOR_SEQ_NO     
                      ,FAC_CHRG_BASE_AM      AS FAC_CHRG_BASE_AM        
                      ,LTRIM(RTRIM(DURATION_REMAIN_NO))                        
                                             AS DURATION_REMAIN_NO      
                      ,BLOCK_NO              AS BLOCK_NO                
                      ,LTRIM(RTRIM(NXT_BILL_START)) AS NXT_BILL_START          
                      ,LTRIM(RTRIM(NXT_BILL_END))   AS NXT_BILL_END            
                      ,LTRIM(RTRIM(CODE_BILL_TYPE)) AS CODE_BILL_TYPE          
                      ,LTRIM(RTRIM(RATE_ATTRIBUTE)) AS RATE_ATTRIBUTE          
A05065                ,LTRIM(RTRIM(OPT_DESC_INT))   AS OPT_DESC_INT            
A05065                ,RT_PKG_OPT_SEQ_NO     AS RT_PKG_OPT_SEQ_NO       
                  FROM #CSR04654_R1                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE           AS RETURN_CODE                     
MFA-TR*               ,STRIP(FACTOR_ID)      AS FACTOR_ID                       
MFA-TR*               ,FACTOR                AS FACTOR                          
MFA-TR*               ,STRIP(START_DATE)     AS START_DATE                      
MFA-TR*               ,STRIP(END_DATE)       AS END_DATE                        
MFA-TR*               ,STRIP(SEASON)         AS SEASON                          
MFA-TR*               ,STRIP(USE_CODE)       AS USE_CODE                        
MFA-TR*               ,STRIP(TIME_PERIOD)    AS TIME_PERIOD                     
MFA-TR*               ,STRIP(COMPONENT_ID)   AS COMPONENT_ID                    
MFA-TR*               ,STRIP(FIXED_FACTOR_TYPE_CD)                              
MFA-TR*                                      AS FIXED_FACTOR_TYPE_CD            
MFA-TR*               ,FIXED_FACTOR_SEQ_NO   AS FIXED_FACTOR_SEQ_NO             
MFA-TR*               ,FAC_CHRG_BASE_AM      AS FAC_CHRG_BASE_AM                
MFA-TR*               ,STRIP(DURATION_REMAIN_NO)                                
MFA-TR*                                      AS DURATION_REMAIN_NO              
MFA-TR*               ,BLOCK_NO              AS BLOCK_NO                        
MFA-TR*               ,STRIP(NXT_BILL_START) AS NXT_BILL_START                  
MFA-TR*               ,STRIP(NXT_BILL_END)   AS NXT_BILL_END                    
MFA-TR*               ,STRIP(CODE_BILL_TYPE) AS CODE_BILL_TYPE                  
MFA-TR*               ,STRIP(RATE_ATTRIBUTE) AS RATE_ATTRIBUTE                  
MFA-TR*               ,STRIP(OPT_DESC_INT)   AS OPT_DESC_INT                    
MFA-TR*               ,RT_PKG_OPT_SEQ_NO     AS RT_PKG_OPT_SEQ_NO               
MFA-TR*           FROM SESSION.CSR04654_R1                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 0100B-DECLARE-GTT-R2 - BUSINESS RULES                          *        
      ******************************************************************        
       0100B-DECLARE-GTT-R2.                                            
                                                                        
           MOVE 'SESSION.CSR04654_R2'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04654_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04654_R2
              (                                                      
                    RETURN_CODE             INT                     
                   ,BUS_RULE_ID CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,ACTION_TYPE_CD CHAR(08)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BUS_RULE_XREF_ID CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                 )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000B-DEL-GTT-ROWS       THRU 8000B-EXIT          
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE 'Y'                   TO WS-GTT02-DECLARED        
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100B'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT           
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C2 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE           AS RETURN_CODE             
                      ,BUS_RULE_ID           AS BUS_RULE_ID             
                      ,ACTION_TYPE_CD        AS ACTION_TYPE_CD          
                      ,BUS_RULE_XREF_ID      AS BUS_RULE_XREF_ID        
                  FROM #CSR04654_R2                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C2 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE           AS RETURN_CODE                     
MFA-TR*               ,BUS_RULE_ID           AS BUS_RULE_ID                     
MFA-TR*               ,ACTION_TYPE_CD        AS ACTION_TYPE_CD                  
MFA-TR*               ,BUS_RULE_XREF_ID      AS BUS_RULE_XREF_ID                
MFA-TR*           FROM SESSION.CSR04654_R2                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100B-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT.                                            *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE '1000'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           IF I-ACCOUNT-NO NOT NUMERIC                                  
              MOVE 0                        TO I-ACCOUNT-NO             
           END-IF.                                                      
                                                                        
           MOVE I-ACCOUNT-NO                TO PARM-ACCOUNT-NO.         
           MOVE I-CODE-UTIL-TYPE            TO PARM-CODE-UTIL-TYPE.     
           MOVE I-IC-NO                     TO PARM-IC-NO.              
                                                                        
           IF (PARM-ACCOUNT-NO     EQUAL ZEROS)                OR       
              (PARM-CODE-UTIL-TYPE EQUAL SPACES OR LOW-VALUES) OR       
              (PARM-IC-NO          EQUAL ZEROS)                         
              MOVE +100                     TO WS-ACTIVE-RETURN-CODE    
              MOVE 'PARM ERROR'             TO S-BUS-RULE-ID-RS2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
           MOVE PARM-ACCOUNT-NO             TO AT-ACCOUNT-NO            
                                               UT-ACCOUNT-NO            
                                               BG-ACCOUNT-NO            
                                               DF-ACCOUNT-NO            
A05065                                         FF-ACCOUNT-NO            
A05065                                         WS-ACCOUNT-NO-063.       
                                                                        
           MOVE PARM-CODE-UTIL-TYPE         TO UT-CODE-UTIL-TYPE        
                                               BG-CODE-UTIL-TYPE        
                                               DF-CODE-UTIL-TYPE        
A05065                                         FF-CODE-UTIL-TYPE        
A05065                                         WS-CODE-UTIL-TYPE-063.   
                                                                        
           MOVE PARM-IC-NO                  TO UT-IC-NO                 
                                               BG-IC-NO                 
                                               DF-IC-NO                 
A05065                                         FF-IC-NO                 
A05065                                         WS-IC-NO-063.            
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-BUILD-RESULT.                                             *        
      ******************************************************************        
       2000-BUILD-RESULT.                                               
                                                                        
           MOVE '2000'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           MOVE ZERO                        TO WS-DATABASE.             
           MOVE 'DATABASE'                  TO C8-DELINQ-CD.            
           MOVE '01'                        TO C8-COMPANY-NO.           
           PERFORM 7600-GET-DELINQUENCY-VALUE  THRU 7600-EXIT.          
           MOVE C8-DELINQ-VALUE             TO WS-DATABASE.             
                                                                        
           PERFORM 7650-GET-UT-RATE-PLAN-NO    THRU 7650-EXIT.          
           MOVE UT-RATE-PLAN-NO             TO SA-RATE-PLAN-NO.         
                                                                        
           IF SEB-DATABASE                                              
              MOVE UT-RT-PKG-OPT-SEQ-NO     TO DF-RT-PKG-OPT-SEQ-NO     
              PERFORM 7875-SELECT-ACCT-OPTION-CD                        
                                               THRU 7875-EXIT           
              MOVE DF-OPTION-CD             TO HQ-OPTION-CD             
           END-IF.                                                      
                                                                        
           PERFORM 7700-GET-ACCOUNT-DTLS       THRU 7700-EXIT.          
           MOVE AT-REV-MTH-LST-NRML         TO WS-REV-MTH-LST-NRML      
                                               WS-REVENUE-MONTH-N.      
           MOVE WS-REV-MTH-LST-NRML         TO WS-REV-MTH-LST-NRML-C.   
           MOVE WS-REV-MTH-LST-NRML-C(1:4)  TO WS-START-YR.             
           MOVE WS-REV-MTH-LST-NRML-C(5:2)  TO WS-START-MT.             
           MOVE '01'                        TO WS-START-DY.             
                                                                        
           IF AT-REV-MTH-LST-NRML  EQUAL ZEROES                         
              MOVE 'COMMONDATE'             TO G6-PROGRAM-NAME          
              MOVE '01'                     TO G6-COMPANY-NO            
              MOVE 'CA00'                   TO G6-CMND-CODE             
              MOVE 0                        TO G6-SEQ-NO                
              PERFORM 7800-SELECT-JOB-PARM     THRU 7800-EXIT           
                                                                        
              MOVE G6-PARM-DATA(1:10)       TO BN-DATE-EXTRACT          
              MOVE AT-BILL-CYCLE            TO BN-BILL-CYCLE            
              PERFORM 7825-SELECT-BILL-WINDOW  THRU 7825-EXIT           
                                                                        
              IF BN-REVENUE-MONTH  EQUAL ZEROES AND                     
                 AT-CODE-ACCT-STAT EQUAL 'P'                            
                 MOVE UT-READ-CYCLE         TO BN-BILL-CYCLE            
                 PERFORM 7825-SELECT-BILL-WINDOW                        
                                               THRU 7825-EXIT           
              END-IF                                                    
                                                                        
              MOVE BN-REVENUE-MONTH         TO WS-REVENUE-MONTH         
                                               WS-REVENUE-MONTH-N       
              MOVE WS-REVENUE-MONTH(1:4)    TO WS-REVN-PRT-DT-FRM       
              MOVE '-'                      TO WS-REVN-PRT-DT-FRM(5:1)  
              MOVE WS-REVENUE-MONTH(5:2)    TO WS-REVN-PRT-DT-FRM(6:2)  
              MOVE '-'                      TO WS-REVN-PRT-DT-FRM(8:1)  
              MOVE '01'                     TO WS-REVN-PRT-DT-FRM(9:2)  
              MOVE WS-REVN-PRT-DT-FRM       TO WS-ADD-ONE-MTH           
                                               WS-START-DATE            
              PERFORM 7750-ADD-ONE-MONTH       THRU 7750-EXIT           
                                                                        
              MOVE WS-DATE-RESULT           TO WS-ADD-ONE-MTH           
              PERFORM 7775-SUB-ONE-DAY         THRU 7775-EXIT           
                                                                        
              MOVE WS-DATE-RESULT           TO WS-REVN-PRT-DT-TO        
           ELSE                                                         
              MOVE WS-START-DATE            TO WS-ADD-ONE-MTH           
              PERFORM 7750-ADD-ONE-MONTH       THRU 7750-EXIT           
                                                                        
              MOVE WS-DATE-RESULT           TO WS-REVN-PRT-DT-FRM       
                                               WS-ADD-ONE-MTH           
              PERFORM 7750-ADD-ONE-MONTH       THRU 7750-EXIT           
                                                                        
              MOVE WS-DATE-RESULT           TO WS-ADD-ONE-MTH           
              PERFORM 7775-SUB-ONE-DAY         THRU 7775-EXIT           
                                                                        
              MOVE WS-DATE-RESULT           TO WS-REVN-PRT-DT-TO        
           END-IF                                                       
                                                                        
           PERFORM 7725-SELECT-CNS-START-DATE  THRU 7725-EXIT.          
                                                                        
           IF CNS-ROW-FOUND                                             
              MOVE CX-DATE-READ             TO WS-OTHR-PRT-DT-FRM       
                                               WS-ADD-ONE-MTH           
              PERFORM 7750-ADD-ONE-MONTH       THRU 7750-EXIT           
                                                                        
              MOVE WS-DATE-RESULT           TO WS-ADD-ONE-MTH           
              PERFORM 7775-SUB-ONE-DAY         THRU 7775-EXIT           
                                                                        
              MOVE WS-DATE-RESULT           TO WS-OTHR-PRT-DT-TO        
           ELSE                                                         
              IF AT-CODE-ACCT-STAT NOT EQUAL 'P'                        
                 IF AT-REV-MTH-LST-NRML EQUAL ZEROES                    
                    MOVE WS-START-DATE      TO WS-ADD-ONE-MTH           
                                               WS-OTHR-PRT-DT-FRM       
                 ELSE                                                   
                    MOVE WS-START-DATE      TO WS-ADD-ONE-MTH           
                    PERFORM 7750-ADD-ONE-MONTH THRU 7750-EXIT           
                    MOVE WS-DATE-RESULT     TO WS-OTHR-PRT-DT-FRM       
                                               WS-ADD-ONE-MTH           
                 END-IF                                                 
                 PERFORM 7750-ADD-ONE-MONTH    THRU 7750-EXIT           
                                                                        
                 MOVE WS-DATE-RESULT        TO WS-ADD-ONE-MTH           
                 PERFORM 7775-SUB-ONE-DAY      THRU 7775-EXIT           
                                                                        
                 MOVE WS-DATE-RESULT        TO WS-OTHR-PRT-DT-TO        
              ELSE                                                      
                 MOVE UT-READ-CYCLE         TO RW-READ-CYCLE            
                 MOVE WS-REVENUE-MONTH-N    TO RW-REVENUE-MONTH         
                 PERFORM 7850-SELECT-OPT-READ-DATE                      
                                               THRU 7850-EXIT           
                                                                        
                 MOVE RW-OPTIMUM-READ-DATE  TO WS-ADD-ONE-MTH           
                                               WS-OTHR-PRT-DT-FRM       
                 PERFORM 7750-ADD-ONE-MONTH    THRU 7750-EXIT           
                                                                        
                 MOVE WS-DATE-RESULT        TO WS-ADD-ONE-MTH           
                 PERFORM 7775-SUB-ONE-DAY      THRU 7775-EXIT           
                                                                        
                 MOVE WS-DATE-RESULT        TO WS-OTHR-PRT-DT-TO        
              END-IF                                                    
           END-IF                                                       
                                                                        
           IF WS-REVN-PRT-DT-FRM < WS-OTHR-PRT-DT-FRM                   
              MOVE WS-REVN-PRT-DT-FRM       TO WS-NXT-BILL-START        
           ELSE                                                         
              MOVE WS-OTHR-PRT-DT-FRM       TO WS-NXT-BILL-START        
           END-IF.                                                      
                                                                        
           IF WS-REVN-PRT-DT-TO > WS-OTHR-PRT-DT-TO                     
              MOVE WS-REVN-PRT-DT-TO        TO WS-NXT-BILL-END          
           ELSE                                                         
              MOVE WS-OTHR-PRT-DT-TO        TO WS-NXT-BILL-END          
           END-IF.                                                      
                                                                        
           PERFORM 2100-PROCESS-FACTORS        THRU 2100-EXIT.          
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2100-PROCESS-FACTORS.                                          *        
      *                                                                *        
      *  1. SEND ALL FIXED/COMBO FIXED & VARIABLE FACTORS FOR ACCOUNT. *        
      ******************************************************************        
       2100-PROCESS-FACTORS.                                            
                                                                        
           MOVE '2100'                      TO ACTIVE-PARAGRAPH.        
                                                                        
      ** ALL FIXED & COMBO FACTORS ON ACCOUNT                                   
           PERFORM 7300-OPEN-ACCOUNT-FACTORS   THRU 7300-EXIT.          
           MOVE ZEROS                       TO WS-FACTOR-VALUE.         
                                                                        
           PERFORM 7400-FETCH-ACCOUNT-FACTORS  THRU 7400-EXIT.          
                                                                        
           PERFORM 2300-SEND-ACCOUNT-FACTORS   THRU 2300-EXIT           
             UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.                   
                                                                        
           PERFORM 7500-CLOSE-ACCOUNT-FACTORS  THRU 7500-EXIT.          
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2300-SEND-ACCOUNT-FACTORS.                                     *        
      ******************************************************************        
       2300-SEND-ACCOUNT-FACTORS.                                       
                                                                        
           MOVE WS-FACTOR-VALUE             TO S-FACTOR-RS1.            
                                                                        
           IF IND-DATE-FROM = WS-YES-NULL                               
              MOVE SPACES                   TO FF-EFF-DATE-FROM         
           END-IF.                                                      
                                                                        
           IF IND-DATE-TO = WS-YES-NULL                                 
              MOVE SPACES                   TO FF-EFF-DATE-TO           
           END-IF.                                                      
                                                                        
           MOVE SF-FACTOR-ID                TO S-FACTOR-ID-RS1.         
           MOVE FF-EFF-DATE-FROM            TO S-START-DATE-RS1.        
           MOVE FF-EFF-DATE-TO              TO S-END-DATE-RS1.          
           MOVE FF-CODE-SEASON              TO S-SEASON-RS1.            
           MOVE FF-INSTR-USE-TYPE-CD        TO S-USE-CODE-RS1.          
           MOVE ZEROS                       TO WS-CODE-TIME-PERIOD.     
           MOVE FF-CODE-TIME-PERIOD         TO WS-CODE-TIME-PERIOD.     
           MOVE WS-CODE-TIME-PERIOD         TO S-TIME-PERIOD-RS1.       
           MOVE FF-CMPNT-ID-CD              TO S-COMPONENT-ID-RS1.      
           MOVE FF-FIXED-FCTR-TYP-CD        TO S-FXD-FCTR-TYPE-CD-RS1.  
           MOVE FF-FIXED-FCTR-SEQ-NO        TO S-FXD-FCTR-SEQ-NO-RS1.   
           MOVE FF-FAC-CHRG-BASE-AM         TO S-FAC-CHRG-BASE-AM-RS1.  
                                                                        
           IF IND-DURATION-REMAIN-NO = WS-YES-NULL                      
              MOVE 'N/A'                    TO S-DURATION-REMAIN-NO-RS1 
           ELSE                                                         
              MOVE FF-DURATION-REMAIN-NO    TO WS-DUR-RMN-NO-TEMP-1     
              MOVE WS-DUR-RMN-NO-TEMP-1     TO WS-DUR-RMN-NO-TEMP-2     
              MOVE WS-DUR-RMN-NO-TEMP-2     TO S-DURATION-REMAIN-NO-RS1 
           END-IF.                                                      
                                                                        
           MOVE FF-BLOCK-NO                 TO S-BLOCK-NO-RS1.          
           MOVE WS-NXT-BILL-START           TO S-NXT-BILL-START-RS1.    
           MOVE WS-NXT-BILL-END             TO S-NXT-BILL-END-RS1.      
                                                                        
           IF SEB-DATABASE                                              
              MOVE 'N'                      TO WS-RATE-ATTRIBUTE        
              MOVE SF-FACTOR-ID             TO HQ-FACTOR-ID             
              PERFORM 7900-SELECT-CRM-OPT-ATT  THRU 7900-EXIT           
              IF RATE-ATTRIBUTE                                         
                 MOVE 'A'                   TO S-RATE-ATTRIBUTE-RS1     
              ELSE                                                      
                 MOVE SPACES                TO S-RATE-ATTRIBUTE-RS1     
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF SF-VERS-PRORATE-CD EQUAL 'R'                              
              IF FF-EFF-DATE-FROM >= WS-REVN-PRT-DT-FRM                 
                 AND ( FF-EFF-DATE-TO <= WS-REVN-PRT-DT-TO              
                     OR( FF-EFF-DATE-FROM <= WS-REVN-PRT-DT-TO          
                        AND FF-EFF-DATE-TO = '2999-12-31'))             
                 MOVE 'C'                   TO S-CODE-BILL-TYPE-RS1     
              ELSE                                                      
                 IF FF-EFF-DATE-FROM < WS-REVN-PRT-DT-FRM               
                        AND FF-EFF-DATE-TO > WS-REVN-PRT-DT-FRM         
                    MOVE 'C'                TO S-CODE-BILL-TYPE-RS1     
                 ELSE                                                   
                    MOVE 'X'                TO S-CODE-BILL-TYPE-RS1     
                 END-IF                                                 
              END-IF                                                    
           ELSE                                                         
              IF FF-EFF-DATE-FROM >= WS-OTHR-PRT-DT-FRM                 
                 AND ( FF-EFF-DATE-TO <= WS-OTHR-PRT-DT-TO              
                     OR( FF-EFF-DATE-FROM <= WS-OTHR-PRT-DT-TO          
                        AND FF-EFF-DATE-TO = '2999-12-31'))             
                 MOVE 'C'                   TO S-CODE-BILL-TYPE-RS1     
              ELSE                                                      
                 IF FF-EFF-DATE-FROM < WS-OTHR-PRT-DT-FRM               
                        AND FF-EFF-DATE-TO > WS-OTHR-PRT-DT-FRM         
                    MOVE 'C'                TO S-CODE-BILL-TYPE-RS1     
                 ELSE                                                   
                    MOVE 'X'                TO S-CODE-BILL-TYPE-RS1     
                 END-IF                                                 
              END-IF                                                    
           END-IF                                                       
                                                                        
A05065     IF SEB-DATABASE                                              
A05065        INITIALIZE S-OPT-DESC-INT                                 
A05065        INITIALIZE S-RT-PKG-OPT-SEQ-NO                            
A05065        MOVE FF-RT-PKG-OPT-SEQ-NO     TO DF-RT-PKG-OPT-SEQ-NO     
A05065                                         S-RT-PKG-OPT-SEQ-NO      
A05065        PERFORM 7875-SELECT-ACCT-OPTION-CD                        
A05065                                      THRU 7875-EXIT              
A05065        IF S-OPT-DESC-INT > SPACES                                
A05065           PERFORM 2650-GET-CUST-CHRG THRU 2650-EXIT              
A05065           MOVE S-OPT-DESC-INT        TO WS-OPT-DESC-INT          
A05065           IF WS-OPT-DESC-INT  > SPACES                           
A05065              AND WS-CSC-AMT   > 0                                
A05065               STRING WS-OPT-DESC-INT DELIMITED BY '   '          
A05065                      ' WITH '                                    
A05065                      WS-CSC-AMT-DESC DELIMITED BY SIZE           
A05065                      WS-CSC-LIT-DESC DELIMITED BY SIZE           
A05065               INTO S-OPT-DESC-INT                                
A05065           ELSE                                                   
A05065              MOVE WS-OPT-DESC-INT    TO  S-OPT-DESC-INT          
A05065           END-IF                                                 
A05065        END-IF                                                    
A05065     END-IF.                                                      
      ** SEND RESULT SET 1 FOR ALL FIXED/COMBO FACTORS ON ACCOUNT               
           PERFORM 8010-INSERT-GTT-R1          THRU 8010-EXIT.          
           MOVE ZEROS                       TO WS-FACTOR-VALUE.         
                                                                        
           PERFORM 7400-FETCH-ACCOUNT-FACTORS  THRU 7400-EXIT.          
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
A05065*                                                                         
A05065*****************************************************************         
A05065**  GET CSC-AMT USING MCSCB063 CALL                                       
A05065*****************************************************************         
A05065 2650-GET-CUST-CHRG.                                              
A05065     MOVE DF-OPTION-CD                TO  WS-OPTION-CD.           
A05065     MOVE SPACES                      TO  WS-EFF-REV-MTH-DATE     
A05065                                        WS-CSC-TIMELINE-FL-063    
A05065                                        WS-DATE-FOR-CSC-TIMELINE. 
A05065                                                                  
A05065     EVALUATE DF-STATUS-CD                                        
A05065       WHEN  'A'                                                  
A05065       WHEN  'O'                                                  
A05065       WHEN  'P'                                                  
A05065        MOVE 'Y'                      TO WS-THERM-CSC-ACCT-FL     
A05065        IF DF-STATUS-CD = 'P'                                     
A05065           MOVE 'Y'                  TO WS-PENDING-OPTION-FL-063  
A05065        END-IF                                                    
A05065       WHEN  OTHER                                                
A05065        MOVE 'Y'                      TO WS-CSC-TIMELINE-FL-063   
A05065        IF DF-STATUS-CD = 'R' OR DF-STATUS-CD = 'D'               
A05065           PERFORM 7950-GET-OLD-EFF-REV-MNTH THRU 7950-EXIT       
A05065           IF BG-REVENUE-MONTH          = 0                       
A05065              MOVE 190001               TO WS-STATUS-EFF-REV-MTH  
A05065           ELSE                                                   
A05065              MOVE BG-REVENUE-MONTH     TO WS-STATUS-EFF-REV-MTH  
A05065           END-IF                                                 
A05065           MOVE WS-STATUS-EFF-REV-MTH(1:4) TO WS-EFF-REV-MTH-YR   
A05065           MOVE WS-STATUS-EFF-REV-MTH(5:2) TO WS-EFF-REV-MTH-MM   
A05065           MOVE '05'                       TO WS-EFF-REV-MTH-DD   
A05065           MOVE '-'                        TO WS-DASH1            
A05065                                              WS-DASH2            
A05065        ELSE                                                      
A05065           IF DF-STATUS-EFF-REV-MTH  = 0                          
A05065              MOVE '1900-01-01'          TO WS-EFF-REV-MTH-DATE   
A05065           ELSE                                                   
A05065            MOVE DF-STATUS-EFF-REV-MTH  TO WS-STATUS-EFF-REV-MTH  
A05065            MOVE WS-STATUS-EFF-REV-MTH(1:4) TO WS-EFF-REV-MTH-YR  
A05065            MOVE WS-STATUS-EFF-REV-MTH(5:2) TO WS-EFF-REV-MTH-MM  
A05065            MOVE '05'                       TO WS-EFF-REV-MTH-DD  
A05065            MOVE '-'                        TO WS-DASH1           
A05065                                               WS-DASH2           
A05065           END-IF                                                 
A05065        END-IF                                                    
A05065        MOVE WS-EFF-REV-MTH-DATE     TO WS-DATE-FOR-CSC-TIMELINE  
A05065     END-EVALUATE.                                                
A05065                                                                  
A05065     IF WS-STATUS-EFF-REV-MTH > 0  OR                             
A05065        (DF-STATUS-CD = 'A' OR                                    
A05065         DF-STATUS-CD = 'O' OR                                    
A05065         DF-STATUS-CD = 'P' )                                     
A05065        CALL MCSCB063 USING CWS00063-FIELDS                       
A05065                        ,ABEND-FILE,                              
A05065                        ,WS-MCSCB063-RET-CODE                     
A05065                                                                  
A05065        IF WS-MCSCB063-RET-CODE EQUAL ZEROES                      
A05065           IF DF-STATUS-CD = 'P'                                  
A05065              MOVE WS-PEND063-CSC-AMT        TO WS-CSC-AMT-DESC   
A05065           ELSE                                                   
A05065              MOVE WS-CSC-AMT                TO WS-CSC-AMT-DESC   
A05065          END-IF                                                  
A05065        ELSE                                                      
A05065          MOVE WS-MCSCB063-RET-CODE     TO WS-ACTIVE-RETURN-CODE  
A05065          MOVE 'CALL'                    TO ABEND-FUNCTION        
A05065          MOVE 'MCSCB063'                TO TABLE-1               
A05065          PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT         
A05065        END-IF                                                    
A05065     ELSE                                                         
A05065        MOVE ZEROS                       TO WS-CSC-AMT            
A05065     END-IF.                                                      
A05065                                                                  
A05065 2650-EXIT.                                                       
A05065      EXIT.                                                       
A05065*                                                               *         
      ****************************************************************          
      * 7300-OPEN-ACCOUNT-FACTORS.                                   *          
      ****************************************************************          
       7300-OPEN-ACCOUNT-FACTORS.                                       
                                                                        
           MOVE '7300'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
               OPEN ACCOUNT_FACTORS                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_FIXED_FCTR'         TO TABLE-1                  
              MOVE 'CSS_SPCL_FCTR'          TO TABLE-2                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-2          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-3          
              MOVE PARM-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1        
              MOVE PARM-IC-NO               TO HOSTVAR-ELEMENT-2        
              MOVE PARM-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7400-FETCH-ACCOUNT-FACTORS.                                 *           
      ****************************************************************          
       7400-FETCH-ACCOUNT-FACTORS.                                      
                                                                        
           MOVE '7400'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
               FETCH ACCOUNT_FACTORS                                    
               INTO    :SF-FACTOR-ID                                    
                     , :WS-FACTOR-VALUE                                 
                     , :FF-EFF-DATE-FROM :IND-DATE-FROM                  
                     , :FF-EFF-DATE-TO :IND-DATE-TO                      
                     , :FF-CODE-SEASON                                  
                     , :FF-INSTR-USE-TYPE-CD                            
                     , :FF-CODE-TIME-PERIOD                             
                     , :SF-VERS-PRORATE-CD                              
                     , :FF-CMPNT-ID-CD                                  
                     , :FF-FIXED-FCTR-TYP-CD                            
                     , :FF-FIXED-FCTR-SEQ-NO                            
                     , :FF-FAC-CHRG-BASE-AM                             
                     , :FF-DURATION-REMAIN-NO :IND-DURATION-REMAIN-NO    
                     , :FF-BLOCK-NO                                     
                     , :FF-RT-PKG-OPT-SEQ-NO                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'FETCH'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_FIXED_FCTR'         TO TABLE-1                  
              MOVE 'CSS_SPCL_FCTR'          TO TABLE-2                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-2          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-3          
              MOVE PARM-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1        
              MOVE PARM-IC-NO               TO HOSTVAR-ELEMENT-2        
              MOVE PARM-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7500-CLOSE-ACCOUNT-FACTORS.                                             
      ****************************************************************          
       7500-CLOSE-ACCOUNT-FACTORS.                                      
                                                                        
           MOVE '7500'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
               CLOSE ACCOUNT_FACTORS                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_FIXED_FCTR'         TO TABLE-1                  
              MOVE 'CSS_SPCL_FCTR'          TO TABLE-2                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-2          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-3          
              MOVE PARM-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1        
              MOVE PARM-IC-NO               TO HOSTVAR-ELEMENT-2        
              MOVE PARM-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7600-GET-DELINQUENCY-VALUE.                                    *        
      * ARE WE IN SEB OR CSR?                                          *        
      ******************************************************************        
       7600-GET-DELINQUENCY-VALUE.                                      
                                                                        
           MOVE '7600'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              SELECT  DELINQ_VALUE                                      
                INTO :C8-DELINQ-VALUE                                   
                FROM  CSS_DELINQUENCY C8 WITH(READUNCOMMITTED)                  
               WHERE  DELINQ_CD  = :C8-DELINQ-CD                        
                 AND  COMPANY_NO = :C8-COMPANY-NO                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  DELINQ_VALUE                                              
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM  CSS_DELINQUENCY C8                                        
MFA-TR*        WHERE  DELINQ_CD  = :C8-DELINQ-CD                                
MFA-TR*          AND  COMPANY_NO = :C8-COMPANY-NO                               
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7600                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_DELINQUENCY'        TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7650-GET-UT-RATE-PLAN-NO                                     *          
      ****************************************************************          
       7650-GET-UT-RATE-PLAN-NO.                                        
                                                                        
           MOVE '7650'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) UT.RATE_PLAN_NO,
              UT.RT_PKG_OPT_SEQ_NO,
              UT.READ_CYCLE                                    
                 INTO :UT-RATE-PLAN-NO                                  
                     ,:UT-RT-PKG-OPT-SEQ-NO                             
                     ,:UT-READ-CYCLE                                    
                 FROM  CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                
                WHERE  UT.ACCOUNT_NO     = :UT-ACCOUNT-NO               
                  AND  UT.IC_NO          = :UT-IC-NO                    
                  AND  UT.CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE           
                                                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  UT.RATE_PLAN_NO                                          
MFA-TR*              , UT.RT_PKG_OPT_SEQ_NO                                     
MFA-TR*              , UT.READ_CYCLE                                            
MFA-TR*          INTO :UT-RATE-PLAN-NO                                          
MFA-TR*              ,:UT-RT-PKG-OPT-SEQ-NO                                     
MFA-TR*              ,:UT-READ-CYCLE                                            
MFA-TR*          FROM  CSS_UTIL_ENVRNMT UT                                      
MFA-TR*         WHERE  UT.ACCOUNT_NO     = :UT-ACCOUNT-NO                       
MFA-TR*           AND  UT.IC_NO          = :UT-IC-NO                            
MFA-TR*           AND  UT.CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE                   
MFA-TR*         FETCH  FIRST ROW ONLY                                           
MFA-TR*          WITH UR                                                        
MFA-TR*        QUERYNO 7650                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_UTIL_ENVRNMT'       TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-2          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-3          
              MOVE UT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE UT-IC-NO                 TO HOSTVAR-ELEMENT-2        
              MOVE UT-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7650-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7700-GET-ACCOUNT-DTLS.                                        *         
      *****************************************************************         
       7700-GET-ACCOUNT-DTLS.                                           
                                                                        
           MOVE '7700'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
               SELECT  AT.CODE_ACCT_STAT                                
                     , AT.REV_MTH_LST_NRML                              
                     , AT.BILL_CYCLE                                    
                 INTO :AT-CODE-ACCT-STAT                                
                     ,:AT-REV-MTH-LST-NRML                              
                     ,:AT-BILL-CYCLE                                    
                 FROM  CSS_ACCOUNT AT WITH(READUNCOMMITTED)                     
                WHERE  AT.ACCOUNT_NO = :AT-ACCOUNT-NO                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  AT.CODE_ACCT_STAT                                        
MFA-TR*              , AT.REV_MTH_LST_NRML                                      
MFA-TR*              , AT.BILL_CYCLE                                            
MFA-TR*          INTO :AT-CODE-ACCT-STAT                                        
MFA-TR*              ,:AT-REV-MTH-LST-NRML                                      
MFA-TR*              ,:AT-BILL-CYCLE                                            
MFA-TR*          FROM  CSS_ACCOUNT AT                                           
MFA-TR*         WHERE  AT.ACCOUNT_NO = :AT-ACCOUNT-NO                           
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7700                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_ACCOUNT'            TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7725-SELECT-CNS-START-DATE.                                   *         
      *****************************************************************         
       7725-SELECT-CNS-START-DATE.                                      
                                                                        
           MOVE '7725'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) CX.DATE_READ                                     
                 INTO :CX-DATE-READ                                     
                 FROM  CSS_CNSMPTN_HIST CX WITH(READUNCOMMITTED)                
                     , CSS_BILLING_HDR  BI WITH(READUNCOMMITTED)                
                     , CSS_BILLING_DET  BG WITH(READUNCOMMITTED)                
                WHERE  BG.ACCOUNT_NO         = :BG-ACCOUNT-NO           
                  AND  BG.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE       
                  AND  BG.IC_NO              = :BG-IC-NO                
                  AND  BG.REVENUE_MONTH      =  0                       
                  AND  BG.REV_MTH_ORIG_BILL  =  0                       
                  AND  BI.ACCOUNT_NO         =  BG.ACCOUNT_NO           
                  AND  BI.BILL_NO            =  BG.BILL_NO              
                  AND  BI.DATE_BILLED       IS  NULL                    
                  AND  CX.ACCOUNT_NO         =  BG.ACCOUNT_NO           
                  AND  CX.BILL_NO            =  BG.BILL_NO              
                  AND  CX.CODE_UTIL_TYPE     =  BG.CODE_UTIL_TYPE       
                  AND  CX.IC_NO              =  BG.IC_NO                
                  AND  CX.BILL_ITEM_TIMESTMP =  BG.BILL_ITEM_TIMESTMP   
                ORDER BY CX.DATE_READ ASC                               
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  CX.DATE_READ                                             
MFA-TR*          INTO :CX-DATE-READ                                             
MFA-TR*          FROM  CSS_CNSMPTN_HIST CX                                      
MFA-TR*              , CSS_BILLING_HDR  BI                                      
MFA-TR*              , CSS_BILLING_DET  BG                                      
MFA-TR*         WHERE  BG.ACCOUNT_NO         = :BG-ACCOUNT-NO                   
MFA-TR*           AND  BG.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE               
MFA-TR*           AND  BG.IC_NO              = :BG-IC-NO                        
MFA-TR*           AND  BG.REVENUE_MONTH      =  0                               
MFA-TR*           AND  BG.REV_MTH_ORIG_BILL  =  0                               
MFA-TR*           AND  BI.ACCOUNT_NO         =  BG.ACCOUNT_NO                   
MFA-TR*           AND  BI.BILL_NO            =  BG.BILL_NO                      
MFA-TR*           AND  BI.DATE_BILLED       IS  NULL                            
MFA-TR*           AND  CX.ACCOUNT_NO         =  BG.ACCOUNT_NO                   
MFA-TR*           AND  CX.BILL_NO            =  BG.BILL_NO                      
MFA-TR*           AND  CX.CODE_UTIL_TYPE     =  BG.CODE_UTIL_TYPE               
MFA-TR*           AND  CX.IC_NO              =  BG.IC_NO                        
MFA-TR*           AND  CX.BILL_ITEM_TIMESTMP =  BG.BILL_ITEM_TIMESTMP           
MFA-TR*         ORDER BY CX.DATE_READ ASC                                       
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*       QUERYNO 7725                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                 SET CNS-ROW-FOUND          TO TRUE                     
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_BILLING_DET'        TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE BG-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE BG-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE BG-IC-NO                 TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7725-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7750-ADD-ONE-MONTH.                                           *         
      *****************************************************************         
       7750-ADD-ONE-MONTH.                                              
                                                                        
           MOVE '7750'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
               SELECT
              DATEADD( MONTH, 1, IIF(TRY_CONVERT(DATE, :WS-ADD-ONE-MTH
              ) IS NULL OR (PATINDEX('%.%', :WS-ADD-ONE-MTH
              ) <> 0) OR (LEN(:WS-ADD-ONE-MTH) <> 10), CIS.CHAR2DATE(
                                                        :WS-ADD-ONE-MTH
              ), CONVERT(DATE, :WS-ADD-ONE-MTH) ) )
            INTO
              :WS-DATE-RESULT    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-DATE-RESULT = DATE(:WS-ADD-ONE-MTH) + 1 MONTH            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'SET'                    TO ABEND-FUNCTION           
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'WS-ADD-ONE-MTH'         TO TABLE-ELEMENT-2          
              MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE WS-ADD-ONE-MTH           TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7750-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7775-SUB-ONE-DAY.                                             *         
      *****************************************************************         
       7775-SUB-ONE-DAY.                                                
                                                                        
           MOVE '7775'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
               SELECT
              DATEADD( DAY, -1, IIF(TRY_CONVERT(DATE, :WS-ADD-ONE-MTH
              ) IS NULL OR (PATINDEX('%.%', :WS-ADD-ONE-MTH
              ) <> 0) OR (LEN(:WS-ADD-ONE-MTH) <> 10), CIS.CHAR2DATE(
                                                        :WS-ADD-ONE-MTH
              ), CONVERT(DATE, :WS-ADD-ONE-MTH) ) )
            INTO
              :WS-DATE-RESULT      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-DATE-RESULT = DATE(:WS-ADD-ONE-MTH) - 1 DAY              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'SET'                    TO ABEND-FUNCTION           
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'WS-ADD-ONE-MTH'         TO TABLE-ELEMENT-2          
              MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE WS-ADD-ONE-MTH           TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7775-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7800-SELECT-JOB-PARM.                                         *         
      *****************************************************************         
       7800-SELECT-JOB-PARM.                                            
                                                                        
           MOVE '7800'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
               SELECT  G6.PARM_DATA                                     
                 INTO :G6-PARM-DATA                                     
                 FROM  CSS_JOB_PARM G6 WITH(READUNCOMMITTED)                    
                WHERE  G6.PROGRAM_NAME = :G6-PROGRAM-NAME               
                  AND  G6.COMPANY_NO   = :G6-COMPANY-NO                 
                  AND  G6.CMND_CODE    = :G6-CMND-CODE                  
                  AND  G6.SEQ_NO       = :G6-SEQ-NO                     
                  AND  G6.STATUS       = 'A'                            
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  G6.PARM_DATA                                             
MFA-TR*          INTO :G6-PARM-DATA                                             
MFA-TR*          FROM  CSS_JOB_PARM G6                                          
MFA-TR*         WHERE  G6.PROGRAM_NAME = :G6-PROGRAM-NAME                       
MFA-TR*           AND  G6.COMPANY_NO   = :G6-COMPANY-NO                         
MFA-TR*           AND  G6.CMND_CODE    = :G6-CMND-CODE                          
MFA-TR*           AND  G6.SEQ_NO       = :G6-SEQ-NO                             
MFA-TR*           AND  G6.STATUS       = 'A'                                    
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7800                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_JOB_PARM'           TO TABLE-1                  
              MOVE 'PROGRAM_NAME'           TO TABLE-ELEMENT-1          
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-2          
              MOVE 'CMND_CODE'              TO TABLE-ELEMENT-3          
              MOVE 'SEQ_NO'                 TO TABLE-ELEMENT-4          
              MOVE G6-PROGRAM-NAME          TO HOSTVAR-ELEMENT-1        
              MOVE G6-COMPANY-NO            TO HOSTVAR-ELEMENT-2        
              MOVE G6-CMND-CODE             TO HOSTVAR-ELEMENT-3        
              MOVE G6-SEQ-NO                TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7825-SELECT-BILL-WINDOW.                                      *         
      *****************************************************************         
       7825-SELECT-BILL-WINDOW.                                         
                                                                        
           MOVE '7825'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
               SELECT  MIN(BN.REVENUE_MONTH)                            
                 INTO :BN-REVENUE-MONTH :IND-REVENUE-MONTH               
                 FROM  CSS_BILL_WINDOW BN WITH(READUNCOMMITTED)                 
                WHERE  BN.DATE_EXTRACT  >= IIF(TRY_CONVERT(DATE, 
                                                       :BN-DATE-EXTRACT
              ) IS NULL OR (PATINDEX('%.%', :BN-DATE-EXTRACT
              ) <> 0) OR (LEN(:BN-DATE-EXTRACT) <> 10), CIS.CHAR2DATE(
                                                       :BN-DATE-EXTRACT
              ), CONVERT(DATE, :BN-DATE-EXTRACT) )             
                  AND  BN.BILL_CYCLE     = :BN-BILL-CYCLE               
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  MIN(BN.REVENUE_MONTH)                                    
MFA-TR*          INTO :BN-REVENUE-MONTH:IND-REVENUE-MONTH                       
MFA-TR*          FROM  CSS_BILL_WINDOW BN                                       
MFA-TR*         WHERE  BN.DATE_EXTRACT  >= :BN-DATE-EXTRACT                     
MFA-TR*           AND  BN.BILL_CYCLE     = :BN-BILL-CYCLE                       
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7825                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF IND-REVENUE-MONTH EQUAL -1                             
                 MOVE ZEROES                TO BN-REVENUE-MONTH         
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_BILL_WINDOW'        TO TABLE-1                  
              MOVE 'DATE_EXTRACT'           TO TABLE-ELEMENT-1          
              MOVE 'BILL_CYCLE'             TO TABLE-ELEMENT-2          
              MOVE BN-DATE-EXTRACT          TO HOSTVAR-ELEMENT-1        
              MOVE BN-BILL-CYCLE            TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7825-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7850-SELECT-OPT-READ-DATE.                                    *         
      *****************************************************************         
       7850-SELECT-OPT-READ-DATE.                                       
                                                                        
           MOVE '7850'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
               SELECT  RW.OPTIMUM_READ_DATE                             
                 INTO :RW-OPTIMUM-READ-DATE                             
                 FROM  CSS_READ_WINDOW RW WITH(READUNCOMMITTED)                 
                WHERE  RW.READ_CYCLE    = :RW-READ-CYCLE                
                  AND  RW.REVENUE_MONTH = :RW-REVENUE-MONTH             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  RW.OPTIMUM_READ_DATE                                     
MFA-TR*          INTO :RW-OPTIMUM-READ-DATE                                     
MFA-TR*          FROM  CSS_READ_WINDOW RW                                       
MFA-TR*         WHERE  RW.READ_CYCLE    = :RW-READ-CYCLE                        
MFA-TR*           AND  RW.REVENUE_MONTH = :RW-REVENUE-MONTH                     
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7850                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_READ_WINDOW'        TO TABLE-1                  
              MOVE 'READ_CYCLE'             TO TABLE-ELEMENT-1          
              MOVE 'RW.REVENUE_MONTH'       TO TABLE-ELEMENT-2          
              MOVE RW-READ-CYCLE            TO HOSTVAR-ELEMENT-1        
              MOVE RW-REVENUE-MONTH         TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7850-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7875-SELECT-ACCT-OPTION-CD.                                   *         
      *****************************************************************         
       7875-SELECT-ACCT-OPTION-CD.                                      
                                                                        
           MOVE '7875'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) DF.OPTION_CD,
              FI.OPT_DESC_INT,
              DF.STATUS_EFF_REV_MTH,
              DF.STATUS_CD                                     
                 INTO :DF-OPTION-CD                                     
A05065               ,:S-OPT-DESC-INT                                   
A05065               ,:DF-STATUS-EFF-REV-MTH                            
A05065               ,:DF-STATUS-CD                                     
                 FROM  CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)               
A05065                ,CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)               
                WHERE  DF.ACCOUNT_NO        = :DF-ACCOUNT-NO            
                  AND  DF.CODE_UTIL_TYPE    = :DF-CODE-UTIL-TYPE        
                  AND  DF.IC_NO             = :DF-IC-NO                 
                  AND  DF.RT_PKG_OPT_SEQ_NO = :DF-RT-PKG-OPT-SEQ-NO     
A05065            AND  DF.OPTION_CD          = FI.OPTION_CD             
A05065            AND  FI.OPT_VSTART_TS     <= CIS.CURRENT$TIMESTAMP()        
A05065            AND  FI.OPT_VEND_TS       >= CIS.CURRENT$TIMESTAMP()        
A05065            AND  FI.PROC_STATUS_CD     = 'AC'                     
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  DF.OPTION_CD                                             
MFA-TR*               ,FI.OPT_DESC_INT                                          
MFA-TR*               ,DF.STATUS_EFF_REV_MTH                                    
MFA-TR*               ,DF.STATUS_CD                                             
MFA-TR*          INTO :DF-OPTION-CD                                             
MFA-TR*              ,:S-OPT-DESC-INT                                           
MFA-TR*              ,:DF-STATUS-EFF-REV-MTH                                    
MFA-TR*              ,:DF-STATUS-CD                                             
MFA-TR*          FROM  CSS_ACCT_RTPK_AGR DF                                     
MFA-TR*               ,CRM_RT_PKG_OPTION FI                                     
MFA-TR*         WHERE  DF.ACCOUNT_NO        = :DF-ACCOUNT-NO                    
MFA-TR*           AND  DF.CODE_UTIL_TYPE    = :DF-CODE-UTIL-TYPE                
MFA-TR*           AND  DF.IC_NO             = :DF-IC-NO                         
MFA-TR*           AND  DF.RT_PKG_OPT_SEQ_NO = :DF-RT-PKG-OPT-SEQ-NO             
MFA-TR*           AND  DF.OPTION_CD          = FI.OPTION_CD                     
MFA-TR*           AND  FI.OPT_VSTART_TS     <= CURRENT TIMESTAMP                
MFA-TR*           AND  FI.OPT_VEND_TS       >= CURRENT TIMESTAMP                
MFA-TR*           AND  FI.PROC_STATUS_CD     = 'AC'                             
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*       QUERYNO 7875                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
A05065     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_ACCT_RTPK_AGR'      TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-2          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-3          
              MOVE 'RT_PKG_OPT_SEQ_NO'      TO TABLE-ELEMENT-4          
              MOVE DF-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE DF-IC-NO                 TO HOSTVAR-ELEMENT-2        
              MOVE DF-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-3        
              MOVE DF-RT-PKG-OPT-SEQ-NO     TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7875-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7900-SELECT-CRM-OPT-ATT.                                      *         
      *****************************************************************         
       7900-SELECT-CRM-OPT-ATT.                                         
                                                                        
           MOVE '7900'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                              
                 INTO :WS-RATE-ATTRIBUTE                                
                 FROM  CRM_OPT_ATTR_INCTV HQ WITH(READUNCOMMITTED)              
                WHERE  HQ.FACTOR_ID           = :HQ-FACTOR-ID           
                  AND  HQ.OPTION_CD           = :HQ-OPTION-CD           
                  AND  HQ.ATTR_INCTV_STRT_DT <= 
           CAST(SYSDATETIMEOFFSET() AS DATE)            
                  AND  HQ.ATTR_INCTV_END_DT  >= 
           CAST(SYSDATETIMEOFFSET() AS DATE)            
                  AND  HQ.OPT_ATTR_VSTART_TS <= CIS.CURRENT$TIMESTAMP()       
                  AND  HQ.OPT_ATTR_VEND_TS   >= CIS.CURRENT$TIMESTAMP()       
                  AND  HQ.PROC_STATUS_CD      = 'AC'                    
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  'Y'                                                      
MFA-TR*          INTO :WS-RATE-ATTRIBUTE                                        
MFA-TR*          FROM  CRM_OPT_ATTR_INCTV HQ                                    
MFA-TR*         WHERE  HQ.FACTOR_ID           = :HQ-FACTOR-ID                   
MFA-TR*           AND  HQ.OPTION_CD           = :HQ-OPTION-CD                   
MFA-TR*           AND  HQ.ATTR_INCTV_STRT_DT <= CURRENT DATE                    
MFA-TR*           AND  HQ.ATTR_INCTV_END_DT  >= CURRENT DATE                    
MFA-TR*           AND  HQ.OPT_ATTR_VSTART_TS <= CURRENT TIMESTAMP               
MFA-TR*           AND  HQ.OPT_ATTR_VEND_TS   >= CURRENT TIMESTAMP               
MFA-TR*           AND  HQ.PROC_STATUS_CD      = 'AC'                            
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*       QUERYNO 7900                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CRM_OPT_ATTR_INCTV'     TO TABLE-1                  
              MOVE 'OPTION_CD'              TO TABLE-ELEMENT-1          
              MOVE 'FACTOR_ID'              TO TABLE-ELEMENT-2          
              MOVE HQ-OPTION-CD             TO HOSTVAR-ELEMENT-1        
              MOVE HQ-FACTOR-ID             TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7900-EXIT.                                                       
           EXIT.                                                        
A05065*                                                                         
A05065*****************************************************************         
A05065* 7950-GET-OLD-EFF-REV-MNTH.                                    *         
A05065*****************************************************************         
A05065 7950-GET-OLD-EFF-REV-MNTH.                                       
A05065                                                                  
A05065     EXEC SQL                                                     
A05065         SELECT TOP(1) BG.REVENUE_MONTH                                  
A05065           INTO :BG-REVENUE-MONTH                                 
A05065           FROM CSS_BILLING_DET   BG WITH(READUNCOMMITTED)                
A05065          WHERE BG.ACCOUNT_NO        = :DF-ACCOUNT-NO             
A05065            AND BG.IC_NO             = :DF-IC-NO                  
A05065            AND BG.CODE_UTIL_TYPE    = :DF-CODE-UTIL-TYPE         
A05065            AND BG.RT_PKG_OPT_SEQ_NO = :DF-RT-PKG-OPT-SEQ-NO      
A05065            AND BG.CODE_BILL_CALC    =  'A'                       
A05065            AND BG.CODE_BILL_ITM_TYPE = 'C'                       
A05065            AND BG.CODE_BILL_ITM_IND  = 'A'                       
A05065            AND BG.REVENUE_MONTH     > 0                          
A05065          ORDER BY REVENUE_MONTH ASC                              
A05065                                              
A05065                                                           
A05065                                                      
A05065      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT BG.REVENUE_MONTH                                          
MFA-TR*          INTO :BG-REVENUE-MONTH                                         
MFA-TR*          FROM CSS_BILLING_DET   BG                                      
MFA-TR*         WHERE BG.ACCOUNT_NO        = :DF-ACCOUNT-NO                     
MFA-TR*           AND BG.IC_NO             = :DF-IC-NO                          
MFA-TR*           AND BG.CODE_UTIL_TYPE    = :DF-CODE-UTIL-TYPE                 
MFA-TR*           AND BG.RT_PKG_OPT_SEQ_NO = :DF-RT-PKG-OPT-SEQ-NO              
MFA-TR*           AND BG.CODE_BILL_CALC    =  'A'                               
MFA-TR*           AND BG.CODE_BILL_ITM_TYPE = 'C'                               
MFA-TR*           AND BG.CODE_BILL_ITM_IND  = 'A'                               
MFA-TR*           AND BG.REVENUE_MONTH     > 0                                  
MFA-TR*         ORDER BY REVENUE_MONTH ASC                                      
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7950                                                    
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05065                                                                  
A05065     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
A05065                                                                  
A05065     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
A05065        IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
A05065           MOVE ZEROS TO BG-REVENUE-MONTH                         
A05065                         WS-ACTIVE-RETURN-CODE                    
A05065        END-IF                                                    
A05065     ELSE                                                         
A05065        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
A05065        MOVE '7950'                    TO ACTIVE-PARAGRAPH        
A05065        MOVE 'SELECT'                  TO ABEND-FUNCTION          
A05065        MOVE 'CSS_BILLING_DET'         TO TABLE-1                 
A05065        MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
A05065        MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
A05065        MOVE 'IC_NO'                   TO TABLE-ELEMENT-3         
A05065        MOVE 'DF_RT_PKG_OPT_SEQ_NO'    TO TABLE-ELEMENT-4         
A05065        MOVE DF-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
A05065        MOVE DF-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
A05065        MOVE DF-IC-NO                  TO HOSTVAR-ELEMENT-3       
A05065        MOVE DF-RT-PKG-OPT-SEQ-NO      TO HOSTVAR-ELEMENT-4       
A05065        PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
A05065     END-IF.                                                      
A05065                                                                  
A05065 7950-EXIT.                                                       
A05065     EXIT.                                                        
A05065*                                                                         
      *****************************************************************         
      * 8000A-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000A-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04654_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04654_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000A'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04654_R1'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       8000A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      * 8000B-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000B-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04654_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04654_R2                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000B'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04654_R2'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       8000B-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 8010-INSERT-GTT-R1. ACCOUNT FIXED/COMBO FACTORS DATA.          *        
      ******************************************************************        
       8010-INSERT-GTT-R1.                                              
                                                                        
           EXEC SQL                                                     
               INSERT INTO #CSR04654_R1                          
                 (                                                      
                   RETURN_CODE                                          
                  ,FACTOR_ID                                            
                  ,FACTOR                                               
                  ,START_DATE                                           
                  ,END_DATE                                             
                  ,SEASON                                               
                  ,USE_CODE                                             
                  ,TIME_PERIOD                                          
                  ,COMPONENT_ID                                         
                  ,FIXED_FACTOR_TYPE_CD                                 
                  ,FIXED_FACTOR_SEQ_NO                                  
                  ,FAC_CHRG_BASE_AM                                     
                  ,DURATION_REMAIN_NO                                   
                  ,BLOCK_NO                                             
                  ,NXT_BILL_START                                       
                  ,NXT_BILL_END                                         
                  ,CODE_BILL_TYPE                                       
                  ,RATE_ATTRIBUTE                                       
A05065            ,OPT_DESC_INT                                         
A05065            ,RT_PKG_OPT_SEQ_NO                                    
                 )                                                      
               VALUES                                                   
                 (                                                      
                   :S-RETURN-CODE-RS1                                   
                  ,:S-FACTOR-ID-RS1                                     
                  ,:S-FACTOR-RS1                                        
                  ,:S-START-DATE-RS1                                    
                  ,:S-END-DATE-RS1                                      
                  ,:S-SEASON-RS1                                        
                  ,:S-USE-CODE-RS1                                      
                  ,:S-TIME-PERIOD-RS1                                   
                  ,:S-COMPONENT-ID-RS1                                  
                  ,:S-FXD-FCTR-TYPE-CD-RS1                              
                  ,:S-FXD-FCTR-SEQ-NO-RS1                               
                  ,:S-FAC-CHRG-BASE-AM-RS1                              
                  ,:S-DURATION-REMAIN-NO-RS1                            
                  ,:S-BLOCK-NO-RS1                                      
                  ,:S-NXT-BILL-START-RS1                                
                  ,:S-NXT-BILL-END-RS1                                  
                  ,:S-CODE-BILL-TYPE-RS1                                
                  ,:S-RATE-ATTRIBUTE-RS1                                
A05065            ,:S-OPT-DESC-INT                                      
A05065            ,:S-RT-PKG-OPT-SEQ-NO                                 
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO SESSION.CSR04654_R1                                  
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,FACTOR_ID                                                    
MFA-TR*           ,FACTOR                                                       
MFA-TR*           ,START_DATE                                                   
MFA-TR*           ,END_DATE                                                     
MFA-TR*           ,SEASON                                                       
MFA-TR*           ,USE_CODE                                                     
MFA-TR*           ,TIME_PERIOD                                                  
MFA-TR*           ,COMPONENT_ID                                                 
MFA-TR*           ,FIXED_FACTOR_TYPE_CD                                         
MFA-TR*           ,FIXED_FACTOR_SEQ_NO                                          
MFA-TR*           ,FAC_CHRG_BASE_AM                                             
MFA-TR*           ,DURATION_REMAIN_NO                                           
MFA-TR*           ,BLOCK_NO                                                     
MFA-TR*           ,NXT_BILL_START                                               
MFA-TR*           ,NXT_BILL_END                                                 
MFA-TR*           ,CODE_BILL_TYPE                                               
MFA-TR*           ,RATE_ATTRIBUTE                                               
MFA-TR*           ,OPT_DESC_INT                                                 
MFA-TR*           ,RT_PKG_OPT_SEQ_NO                                            
MFA-TR*          )                                                              
MFA-TR*        VALUES                                                           
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-RS1                                           
MFA-TR*           ,:S-FACTOR-ID-RS1                                             
MFA-TR*           ,:S-FACTOR-RS1                                                
MFA-TR*           ,:S-START-DATE-RS1                                            
MFA-TR*           ,:S-END-DATE-RS1                                              
MFA-TR*           ,:S-SEASON-RS1                                                
MFA-TR*           ,:S-USE-CODE-RS1                                              
MFA-TR*           ,:S-TIME-PERIOD-RS1                                           
MFA-TR*           ,:S-COMPONENT-ID-RS1                                          
MFA-TR*           ,:S-FXD-FCTR-TYPE-CD-RS1                                      
MFA-TR*           ,:S-FXD-FCTR-SEQ-NO-RS1                                       
MFA-TR*           ,:S-FAC-CHRG-BASE-AM-RS1                                      
MFA-TR*           ,:S-DURATION-REMAIN-NO-RS1                                    
MFA-TR*           ,:S-BLOCK-NO-RS1                                              
MFA-TR*           ,:S-NXT-BILL-START-RS1                                        
MFA-TR*           ,:S-NXT-BILL-END-RS1                                          
MFA-TR*           ,:S-CODE-BILL-TYPE-RS1                                        
MFA-TR*           ,:S-RATE-ATTRIBUTE-RS1                                        
MFA-TR*           ,:S-OPT-DESC-INT                                              
MFA-TR*           ,:S-RT-PKG-OPT-SEQ-NO                                         
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                        TO CTR-ROWS-RS1             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8010'                   TO ACTIVE-PARAGRAPH         
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSR04654_R1'            TO TABLE-1                  
              MOVE SPACES                   TO TABLE-ELEMENT-1          
              MOVE SPACES                   TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8020-INSERT-GTT-R2.  BUSINESS RULES.                           *        
      ******************************************************************        
       8020-INSERT-GTT-R2.                                              
                                                                        
           EXEC SQL                                                     
               INSERT INTO #CSR04654_R2                          
                 (                                                      
                   RETURN_CODE                                          
                  ,BUS_RULE_ID                                          
                  ,ACTION_TYPE_CD                                       
                  ,BUS_RULE_XREF_ID                                     
                 )                                                      
               VALUES                                                   
                 (                                                      
                   :S-RETURN-CODE-RS2                                   
                  ,:S-BUS-RULE-ID-RS2                                   
                  ,:S-ACTION-TYPE-CD-RS2                                
                  ,:S-BUS-RULE-XREF-ID-RS2                              
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO SESSION.CSR04654_R2                                  
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,BUS_RULE_ID                                                  
MFA-TR*           ,ACTION_TYPE_CD                                               
MFA-TR*           ,BUS_RULE_XREF_ID                                             
MFA-TR*          )                                                              
MFA-TR*        VALUES                                                           
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-RS2                                           
MFA-TR*           ,:S-BUS-RULE-ID-RS2                                           
MFA-TR*           ,:S-ACTION-TYPE-CD-RS2                                        
MFA-TR*           ,:S-BUS-RULE-XREF-ID-RS2                                      
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                        TO CTR-ROWS-RS2             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8020'                   TO ACTIVE-PARAGRAPH         
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSR04654_R2'            TO TABLE-1                  
              MOVE SPACES                   TO TABLE-ELEMENT-1          
              MOVE SPACES                   TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8800-CHECK-RESULTS.                                           *         
      *****************************************************************         
       8800-CHECK-RESULTS.                                              
                                                                        
           IF CTR-ROWS-RS1 <= 0                                         
              INITIALIZE                       GTT-RETURN-FIELDS-RS1    
              MOVE   0                      TO S-RETURN-CODE-RS1        
              PERFORM 8010-INSERT-GTT-R1       THRU 8010-EXIT           
           END-IF.                                                      
                                                                        
           IF CTR-ROWS-RS2 <= 0                                         
              INITIALIZE                       GTT-RETURN-FIELDS-RS2    
              MOVE   0                      TO S-RETURN-CODE-RS2        
              PERFORM 8020-INSERT-GTT-R2       THRU 8020-EXIT           
           END-IF.                                                      
                                                                        
       8800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8900-SEND-DONE.                                               *         
      *****************************************************************         
       8900-SEND-DONE.                                                  
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           EXEC SQL                                                     
               OPEN C2                                                  
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
                                                    
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 9000-SEND-ERROR-RESULT.                                       *         
      *****************************************************************         
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE       TO ABEND-SQLCODE            
                                               S-RETURN-CODE-RS1        
                                               S-RETURN-CODE-RS2.       
                                                                        
           MOVE SQLERRMC                    TO ABEND-SQLERRMC.          
                                                                        
           IF WS-GTT01-DECLARED = 'N'                                   
              PERFORM 0100A-DECLARE-GTT-R1     THRU 0100A-EXIT          
           END-IF.                                                      
                                                                        
           IF WS-GTT02-DECLARED = 'N'                                   
              PERFORM 0100B-DECLARE-GTT-R2     THRU 0100B-EXIT          
           END-IF.                                                      
                                                                        
           PERFORM 8010-INSERT-GTT-R1          THRU 8010-EXIT.          
           PERFORM 8020-INSERT-GTT-R2          THRU 8020-EXIT.          
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 9700-PROCESS-ABEND.                                           *         
      *****************************************************************         
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT      THRU 9000-EXIT.          
           PERFORM 9900-SQL-ERROR-ROUTINE      THRU 9900-EXIT.          
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 9900-SQL-ERROR-ROUTINE.                                       *         
      *****************************************************************         
       9900-SQL-ERROR-ROUTINE.                                          

MSQ002     EXEC SQL
MSQ002         SELECT LTRIM(RTRIM(CASE                                          
                        WHEN :TABLE-ELEMENT-1 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-1)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-1))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-2 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-2)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-2))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-3 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-3)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-3))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-4 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-4)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-4))                    
                        ELSE                                            
                           ''                                           
                     END))
MSQ002              , :ABEND-FUNCTION
MSQ002              , 'PARAGRAPH-' + LTRIM(RTRIM(:ACTIVE-PARAGRAPH)) + 
           ',' + 'TABLES-' + LTRIM(RTRIM(:TABLE-2)) + ',' + 
           LTRIM(RTRIM(:TABLE-3)) + ',' + LTRIM(RTRIM(:TABLE-4)) + 
           ',' + 'ERRMSG-' + LTRIM(RTRIM(:ABEND-SQLERRMC))
MSQ002           INTO :MFA-CSRERLOG.ARG-5
MSQ002              , :MFA-CSRERLOG.ARG-6
MSQ002              , :MFA-CSRERLOG.ARG-7
MSQ002     END-EXEC
                                                                        
           EXEC SQL                                                     
               CALL CSRERLOG ( :ABEND-PROGRAM
                  , :ABEND-SQLCODE
                  , :ABEND-SQLSTATE
                  , :TABLE-1
                  , :MFA-CSRERLOG.ARG-5
                  , :MFA-CSRERLOG.ARG-6
                  , :MFA-CSRERLOG.ARG-7
                  )                                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ002
MFA-TR*    EXEC SQL                                                             
MFA-TR*        CALL CSRERLOG (                                                  
MFA-TR*             :ABEND-PROGRAM,                                             
MFA-TR*             :ABEND-SQLCODE,                                             
MFA-TR*             :ABEND-SQLSTATE,                                            
MFA-TR*             :TABLE-1,                                                   
MFA-TR*              VARCHAR(STRIP(                                             
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-1 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-1) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-1)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-2 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-2) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-2)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-3 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-3) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-3)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-4 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-4) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-4)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END                                                        
MFA-TR*              )),                                                        
MFA-TR*              VARCHAR(:ABEND-FUNCTION),                                  
MFA-TR*              VARCHAR(                                                   
MFA-TR*              'PARAGRAPH-' CONCAT STRIP(:ACTIVE-PARAGRAPH) CONCAT        
MFA-TR*              ',' CONCAT 'TABLES-' CONCAT STRIP(:TABLE-2) CONCAT         
MFA-TR*              ',' CONCAT STRIP(:TABLE-3) CONCAT                          
MFA-TR*              ',' CONCAT STRIP(:TABLE-4) CONCAT                          
MFA-TR*              ',' CONCAT 'ERRMSG-' CONCAT STRIP(:ABEND-SQLERRMC)         
MFA-TR*              )                                                          
MFA-TR*             )                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           PERFORM 8900-SEND-DONE              THRU 8900-EXIT.          
           
MSQ016        GOBACK.                                                    
                                                                        
       9900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 9999-END-PROGRAM.                                             *         
      *****************************************************************         
       9999-END-PROGRAM.                                                
                                                                        
           PERFORM 8800-CHECK-RESULTS          THRU 8800-EXIT.          
           PERFORM 8900-SEND-DONE              THRU 8900-EXIT.          
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
