       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.      CSR04652.                                       
       AUTHOR.       SAKTHIVEL MATHIYAZHAGAN.                           
COB303 DATE-WRITTEN. OCT 17, 2013.                                      
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE:  CSR04652              --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--                                                            --         
      *--  CSR04652 :                                                --         
      *--                                                            --         
      *--  #  UPDATE IN TAX DETAILS SCREEN. CLONED FROM CSR04158.    --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *--  INPUT PARAMETERS.                                         --         
      *--                                                            --         
      *--            USER_ID               CHAR(07)                  --         
      *--            ACCOUNT_NO            CHAR(13)                  --         
      *--            COMPANY_NO            CHAR(02)                  --         
      *--            CODE_UTIL_TYPE        CHAR(01)                  --         
      *--            IC_NO                 SMALLINT                  --         
      *--            STATE_XMPT_NO         CHAR(13)                  --         
      *--            STATE_XMPT_CODE       CHAR(01)                  --         
      *--            COMMENT_TEXT          CHAR(210)                 --         
      *--                                                            --         
      *--  OUTPUT RESULT SET.                                        --         
      *--                                                            --         
      *--            RETURN_CODE           INTEGER                   --         
      *--            APPL_RETURN_CODE      INTEGER                   --         
      *--            BUS_RULE_ID           CHAR(10)                  --         
      *--            ACTION_TYPE_CD        CHAR(08)                  --         
      *--            BUS_RULE_XREF_ID      CHAR(26)                  --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                        MODIFICATION LOG                    --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
P00738*--  10-17-2013    MS93554     PROGRAM INTIALLY WRITTEN.       --         
      *--                                                                       
      *----------------------------------------------------------------         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04652'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-WORKING-STORAGE.                                          
           05 WS-SQLSTATE             PIC X(05) VALUE SPACES.           
           05 WS-CURR-USER-ID         PIC X(07) VALUE SPACES.           
           05 WS-CURR-ACCOUNT-NO      PIC 9(13) VALUE ZEROES.           
           05 WS-CURR-COMPANY-NO      PIC X(02) VALUE ZEROES.           
           05 WS-CURR-CODE-UTIL-TYPE  PIC X(01) VALUE SPACES.           
           05 WS-CURR-IC-NO           PIC S9(4) COMP VALUE 0.           
           05 WS-CURR-STATE-XMPT-NO   PIC X(13) VALUE SPACES.           
           05 WS-CURR-STATE-XMPT-CODE PIC X(01) VALUE SPACES.           
           05 WS-CURR-COMMENT-TEXT    PIC X(210) VALUE SPACES.          
           05 WS-TRAN-APPL-NO         PIC S9(4) COMP VALUE 0.           
           05 WS-CURRENT-TS           PIC X(26) VALUE SPACES.           
           05 WS-CURRENT-DATE         PIC X(10) VALUE SPACES.           
                                                                        
       01  WS-SWITCHES.                                                 
           05 ALL-DONE-SW             PIC X(01) VALUE 'N'.              
              88 NOT-ALL-DONE             VALUE 'N'.                    
              88 ALL-DONE                 VALUE 'Y'.                    
           05 SEND-DONE-SW            PIC X(01) VALUE 'Y'.              
              88 SEND-DONE-ERROR          VALUE 'N'.                    
              88 SEND-DONE-OK             VALUE 'Y'.                    
           05 WS-UPDATE-FL            PIC X(01) VALUE 'N'.              
MAN007*       88 UPDATE                         VALUE 'Y'.                      
MAN007        88 UPDATEY                        VALUE 'Y'.
                                                                        
       01  WS-LITERALS.                                                 
           05 PROGRAM-NAME            PIC X(08) VALUE 'CSR04652'.       
           05 WS-YES                  PIC X(01) VALUE 'Y'.              
           05 WS-NO                   PIC X(01) VALUE 'N'.              
           05 WS-BACKOUT              PIC X(01) VALUE 'B'.              
                                                                        
       01  GTT-MISC-FIELDS.                                             
           05  GTT-ROW.                                                 
               49 GTT-ROW-LEN         PIC S9(04) COMP.                  
               49 GTT-ROW-CHAR        PIC X(1024).                      
           05  GTT-SQLCODE            PIC S9(9) COMP.                   
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN             PIC S9(9) COMP VALUE 1.           
           05  CTR-ROWS               PIC S9(9) COMP VALUE 0.           
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE          PIC S9(09) COMP VALUE 0.          
           05  S-APPL-RETURN-CODE     PIC S9(09) COMP VALUE 0.          
           05  S-BUS-RULE-ID          PIC X(10)  VALUE SPACES.          
           05  S-BUS-RULE-RESULT-CD   PIC X(08)  VALUE SPACES.          
           05  S-BUS-RULE-XREF-ID     PIC X(26)  VALUE SPACES.          
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9) COMP VALUE 0.         
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.           
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.           
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.           
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_BILLING_DET, BG                                           *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBBLLDET                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_BILLING_HDR, BI                                           *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBBLLHDR                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_UTIL_ENVRNMT, UT                                          *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBUTLENV                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_MNT_TRANS_HIST, MH                                        *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBMNHIST                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_MT_TRN_HST_DET, MI                                        *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBMNHDT                                                
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_USER_PROFILE, PF                                          *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBUSRPRF                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      *    SQL ERROR CHECKING COPYBOOK.                                *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS TO XFER DATA.                                    *        
      ******************************************************************        
           COPY CCA00001.                                                       
                                                                        
      ******************************************************************        
      *    ERROR HANDLING COPY BOOK.                                   *        
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  CURSOR DECLARATIONS.                                          *        
      ******************************************************************        
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-USER-ID                   PIC X(07).                    
COB305 01 PARM-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.     
       01  PARM-COMPANY-NO                PIC X(02).                    
       01  PARM-CODE-UTIL-TYPE            PIC X(01).                    
       01  PARM-IC-NO                     PIC S9(4) COMP VALUE 0.       
       01  PARM-STATE-XMPT-NO             PIC X(13).                    
       01  PARM-STATE-XMPT-CODE           PIC X(01).                    
       01  PARM-COMMENT-TEXT              PIC X(210).                   
                                                                        
       PROCEDURE DIVISION  USING PARM-USER-ID                           
                                 PARM-ACCOUNT-NO                        
                                 PARM-COMPANY-NO                        
                                 PARM-CODE-UTIL-TYPE                    
                                 PARM-IC-NO                             
                                 PARM-STATE-XMPT-NO                     
                                 PARM-STATE-XMPT-CODE                   
                                 PARM-COMMENT-TEXT.                     
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0000-MAINLINE.                                                 *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE             THRU 0100-EXIT.          
           PERFORM 1000-PROCESS-INPUT          THRU 1000-EXIT.          
           PERFORM 2000-PROCESS-OUTPUT         THRU 2000-EXIT.          
           PERFORM 9999-END-PROGRAM            THRU 9999-EXIT.          
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           EXEC SQL                                                     
              DECLARE C1 CURSOR  FOR                         
              SELECT :S-RETURN-CODE           AS RETURN_CODE            
                    ,:S-APPL-RETURN-CODE      AS APPL_RETURN_CODE       
                    ,:S-BUS-RULE-ID           AS BUS_RULE_ID            
                    ,:S-BUS-RULE-RESULT-CD    AS BUS_RULE_RESULT_CD     
                    ,:S-BUS-RULE-XREF-ID      AS BUS_RULE_XREF_ID       
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN FOR                                 
MFA-TR*       SELECT :S-RETURN-CODE           AS RETURN_CODE                    
MFA-TR*             ,:S-APPL-RETURN-CODE      AS APPL_RETURN_CODE               
MFA-TR*             ,:S-BUS-RULE-ID           AS BUS_RULE_ID                    
MFA-TR*             ,:S-BUS-RULE-RESULT-CD    AS BUS_RULE_RESULT_CD             
MFA-TR*             ,:S-BUS-RULE-XREF-ID      AS BUS_RULE_XREF_ID               
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-USER-ID              TO WS-CURR-USER-ID.           
           MOVE PARM-ACCOUNT-NO           TO WS-CURR-ACCOUNT-NO.        
           MOVE PARM-COMPANY-NO           TO WS-CURR-COMPANY-NO.        
           MOVE PARM-CODE-UTIL-TYPE       TO WS-CURR-CODE-UTIL-TYPE.    
           MOVE PARM-IC-NO                TO WS-CURR-IC-NO.             
           MOVE PARM-STATE-XMPT-NO        TO WS-CURR-STATE-XMPT-NO.     
           MOVE PARM-STATE-XMPT-CODE      TO WS-CURR-STATE-XMPT-CODE.   
           MOVE PARM-COMMENT-TEXT         TO WS-CURR-COMMENT-TEXT.      
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE WS-CURR-ACCOUNT-NO           TO BG-ACCOUNT-NO           
                                                BI-ACCOUNT-NO           
                                                UT-ACCOUNT-NO.          
                                                                        
           MOVE WS-CURR-CODE-UTIL-TYPE       TO UT-CODE-UTIL-TYPE       
                                                BG-CODE-UTIL-TYPE.      
                                                                        
           MOVE WS-CURR-IC-NO                TO UT-IC-NO                
                                                BG-IC-NO.               
                                                                        
           PERFORM 7000-GET-PREVIOUS-VALUE      THRU 7000-EXIT.         
           PERFORM 5000-WRITE-TRANS-HIST        THRU 5000-EXIT.         
                                                                        
           MOVE WS-CURR-STATE-XMPT-NO        TO UT-STATE-TAX-EXMPT-NO.  
           MOVE WS-CURR-STATE-XMPT-CODE      TO UT-CODE-STAT-TAX-XMT    
                                                BG-CODE-STAT-TAX-XMT.   
MAN007*    IF UPDATE                                                            
MAN007     IF UPDATEY
              PERFORM 8200-UPDATE-UTIL-ENVRNMT  THRU 8200-EXIT          
              PERFORM 8300-UPDATE-BILLING-DET   THRU 8300-EXIT          
           END-IF.                                                      
                                                                        
           PERFORM 8100-SEND-RESULT             THRU 8100-EXIT.         
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 5000-WRITE-TRANS-HIST.                                         *        
      ******************************************************************        
       5000-WRITE-TRANS-HIST.                                           
                                                                        
           PERFORM 7010-SELECT-CURRENT-TS      THRU 7010-EXIT           
           MOVE WS-CURRENT-DATE             TO MH-DATE-TRANS            
           MOVE WS-CURRENT-TS               TO MH-TRANS-HIST-SEQ-NO     
                                               MI-TRANS-HIST-SEQ-NO     
                                                                        
           MOVE WS-CURR-USER-ID             TO PF-USER-ID.              
           PERFORM 7020-SELECT-USER-PROFILE    THRU 7020-EXIT           
                                                                        
           MOVE +01                         TO WS-TRAN-APPL-NO.         
           MOVE 'F'                         TO MH-CODE-TRAN-TYPE.       
           MOVE WS-CURR-ACCOUNT-NO          TO MH-ACCOUNT-NO.           
           MOVE PF-RESP-AREA-ID             TO MH-RESP-AREA-ID.         
           MOVE 0                           TO MH-CUSTOMER-NO.          
           MOVE 0                           TO MH-PREMISE-NO.           
           MOVE WS-CURR-USER-ID             TO MH-USER-ID.              
           MOVE 'CSR04652'                  TO MH-APPL-PROGRAM-ID.      
                                                                        
           MOVE WS-CURR-COMMENT-TEXT        TO MH-TRAN-COMMENT-TEXT.    
                                                                        
           MOVE LENGTH OF MH-TRAN-COMMENT-TEXT                          
                                            TO MH-TRAN-COMMENT-LEN.     
                                                                        
           IF UT-STATE-TAX-EXMPT-NO NOT = WS-CURR-STATE-XMPT-NO         
              MOVE WS-YES                   TO WS-UPDATE-FL             
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE SPACES                   TO MI-TABLE-ID              
                                                                        
              IF WS-CURR-STATE-XMPT-NO > SPACES                         
                 MOVE +13                   TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE WS-CURR-STATE-XMPT-NO TO MI-CHG-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE '*DELETED*'           TO MI-CHG-COLUMN-VALUE-TEXT 
              END-IF                                                    
                                                                        
              IF UT-STATE-TAX-EXMPT-NO > SPACES                         
                 MOVE +13                   TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE UT-STATE-TAX-EXMPT-NO TO MI-PRV-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT 
              END-IF                                                    
                                                                        
              MOVE 'STATE EXEMPT NO'        TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                         TO WS-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
           IF UT-CODE-STAT-TAX-XMT  NOT = WS-CURR-STATE-XMPT-CODE       
              MOVE WS-YES                   TO WS-UPDATE-FL             
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE 'F1'                     TO MI-TABLE-ID              
                                                                        
              IF WS-CURR-STATE-XMPT-CODE   > SPACES                     
                 MOVE +01                   TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE PARM-STATE-XMPT-CODE  TO MI-CHG-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE '*DELETED*'           TO MI-CHG-COLUMN-VALUE-TEXT 
              END-IF                                                    
                                                                        
              IF UT-CODE-STAT-TAX-XMT  > SPACES                         
                 MOVE +01                   TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE UT-CODE-STAT-TAX-XMT  TO MI-PRV-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT 
              END-IF                                                    
                                                                        
              MOVE 'STATE TAX XMT  '        TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                         TO WS-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  6530-LOAD-MNT-TRANS-HIST.                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7000-GET-PREVIOUS-VALUE.                                      *         
      *****************************************************************         
       7000-GET-PREVIOUS-VALUE.                                         
                                                                        
           EXEC SQL                                                     
               SELECT UT.CODE_STAT_TAX_XMT                              
                     ,UT.CODE_CITY_TAX_XMT                              
                     ,UT.STATE_TAX_EXMPT_NO                             
                 INTO :UT-CODE-STAT-TAX-XMT                             
                     ,:UT-CODE-CITY-TAX-XMT                             
                     ,:UT-STATE-TAX-EXMPT-NO                            
                 FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                 
                WHERE UT.ACCOUNT_NO     = :UT-ACCOUNT-NO                
                  AND UT.CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE            
                  AND UT.IC_NO          = :UT-IC-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT UT.CODE_STAT_TAX_XMT                                      
MFA-TR*              ,UT.CODE_CITY_TAX_XMT                                      
MFA-TR*              ,UT.STATE_TAX_EXMPT_NO                                     
MFA-TR*          INTO :UT-CODE-STAT-TAX-XMT                                     
MFA-TR*              ,:UT-CODE-CITY-TAX-XMT                                     
MFA-TR*              ,:UT-STATE-TAX-EXMPT-NO                                    
MFA-TR*          FROM CSS_UTIL_ENVRNMT UT                                       
MFA-TR*         WHERE UT.ACCOUNT_NO     = :UT-ACCOUNT-NO                        
MFA-TR*           AND UT.CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE                    
MFA-TR*           AND UT.IC_NO          = :UT-IC-NO                             
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7000                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7000'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_UTIL_ENVRNMT'        TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE 'IC_NO'                   TO TABLE-ELEMENT-3         
              MOVE UT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE UT-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              MOVE UT-IC-NO                  TO HOSTVAR-ELEMENT-3       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7010-SELECT-CURRENT-TS.                                       *         
      *****************************************************************         
       7010-SELECT-CURRENT-TS.                                          
                                                                        
           EXEC SQL                                                     
               SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE),
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-DATE,
              :WS-CURRENT-TS                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-CURRENT-DATE = CURRENT DATE                              
MFA-TR*           ,:WS-CURRENT-TS   = CURRENT TIMESTAMP                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7010'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SET'                     TO ABEND-FUNCTION          
              MOVE 'MODEL SQL'               TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE WS-CURR-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7020-SELECT-USER-PROFILE.                                     *         
      *****************************************************************         
       7020-SELECT-USER-PROFILE.                                        
                                                                        
           EXEC SQL                                                     
               SELECT PF.RESP_AREA_ID                                   
                 INTO :PF-RESP-AREA-ID                                  
                 FROM CSS_USER_PROFILE PF WITH(READUNCOMMITTED)                 
                WHERE PF.USER_ID = :PF-USER-ID                          
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT PF.RESP_AREA_ID                                           
MFA-TR*          INTO :PF-RESP-AREA-ID                                          
MFA-TR*          FROM CSS_USER_PROFILE PF                                       
MFA-TR*         WHERE PF.USER_ID = :PF-USER-ID                                  
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7020                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7020'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_USER_PROFILE'        TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'USER_ID'                 TO TABLE-ELEMENT-2         
              MOVE WS-CURR-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1       
              MOVE PF-USER-ID                TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8100-SEND-RESULT                                               *        
      ******************************************************************        
       8100-SEND-RESULT.                                                
                                                                        
              ADD +1                    TO CTR-ROWS.                    
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8200-UPDATE-UTIL-ENVRNMT.                                      *        
      ******************************************************************        
       8200-UPDATE-UTIL-ENVRNMT.                                        
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_UTIL_ENVRNMT                                   
                 SET CODE_STAT_TAX_XMT  = :UT-CODE-STAT-TAX-XMT         
                    ,STATE_TAX_EXMPT_NO = :UT-STATE-TAX-EXMPT-NO        
               WHERE ACCOUNT_NO         = :UT-ACCOUNT-NO                
                 AND CODE_UTIL_TYPE     = :UT-CODE-UTIL-TYPE            
                 AND IC_NO              = :UT-IC-NO                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8200'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_UTIL_ENVRNMT'   TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2              
              MOVE 'IC_NO'              TO TABLE-ELEMENT-3              
              MOVE UT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE UT-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2            
              MOVE UT-IC-NO             TO HOSTVAR-ELEMENT-3            
              PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8300-UPDATE-BILLING-DET.                                       *        
      ******************************************************************        
       8300-UPDATE-BILLING-DET.                                         
                                                                        
           EXEC SQL                                                     
              UPDATE BG                                  
                 SET CODE_STAT_TAX_XMT      = :BG-CODE-STAT-TAX-XMT     
              FROM CSS_BILLING_DET BG
               WHERE BG.ACCOUNT_NO          = :BG-ACCOUNT-NO            
                 AND BG.CODE_UTIL_TYPE      = :BG-CODE-UTIL-TYPE        
                 AND BG.IC_NO               = :BG-IC-NO                 
                 AND BG.REV_MTH_ORIG_BILL   = 0                         
                 AND BG.CODE_BILL_ITM_TYPE <> :WS-BACKOUT               
                 AND BG.REBILL_IND         <> :WS-YES                   
                 AND BG.BILL_NO IN                                      
                     ( SELECT BI.BILL_NO                                
                         FROM CSS_BILLING_HDR BI                        
                        WHERE BI.ACCOUNT_NO = :BI-ACCOUNT-NO            
                          AND BI.DATE_BILLED IS NULL    )               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_BILLING_DET BG                                         
MFA-TR*          SET CODE_STAT_TAX_XMT      = :BG-CODE-STAT-TAX-XMT             
MFA-TR*        WHERE BG.ACCOUNT_NO          = :BG-ACCOUNT-NO                    
MFA-TR*          AND BG.CODE_UTIL_TYPE      = :BG-CODE-UTIL-TYPE                
MFA-TR*          AND BG.IC_NO               = :BG-IC-NO                         
MFA-TR*          AND BG.REV_MTH_ORIG_BILL   = 0                                 
MFA-TR*          AND BG.CODE_BILL_ITM_TYPE <> :WS-BACKOUT                       
MFA-TR*          AND BG.REBILL_IND         <> :WS-YES                           
MFA-TR*          AND BG.BILL_NO IN                                              
MFA-TR*              ( SELECT BI.BILL_NO                                        
MFA-TR*                  FROM CSS_BILLING_HDR BI                                
MFA-TR*                 WHERE BI.ACCOUNT_NO = :BI-ACCOUNT-NO                    
MFA-TR*                   AND BI.DATE_BILLED IS NULL    )                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8300'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_BILLING_DET'    TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2              
              MOVE 'IC_NO'              TO TABLE-ELEMENT-3              
              MOVE BG-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE BG-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2            
              MOVE BG-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-3            
              PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
           END-IF.                                                      
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************** ***********************************************        
      *                                                                         
      * 9700-ABEND-PROCESSING.                                         *        
      ******************************************************************        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT.             
           PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT.             
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      *                                                                         
      * 9900 - JOURNALING / ERROR HANDLING ROUTINE                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *                                                                         
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
           EXEC SQL                                                             
             INCLUDE CPD00321                                                   
           END-EXEC.                                                            
                                                                        
