       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.      CSR04651.                                       
       AUTHOR.       SAKTHIVEL MATHIYAZHAGAN.                           
COB303 DATE-WRITTEN. SEP 23, 2013.                                      
       DATE-COMPILED.                                                   
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE:  CSR04651              --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--                                                            --         
      *--  CSR04651 :                                                --         
      *--                                                            --         
      *--  #  RETRIEVE TAX DETAILS.                                  --         
      *--     THIS PROCEDURE CALLS MCSCB426 TO GET ALL TAX DET.      --         
      *--                                                            --         
      *--  #  THIS PROGRAM IS CLONED FROM CSR04157.                  --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *--  PARAMETERS:                                                --        
      *--                                                            --         
      *--  INPUT PARAMETERS.                                         --         
      *--                                                            --         
      *--         ACCOUNT_NO            DECIMAL(13)                  --         
      *--         CODE_UTIL_TYPE        CHAR(01)                     --         
      *--         IC_NO                 SMALLINT                     --         
      *--         PREMISE_NO            CHAR(10)                     --         
      *--                                                            --         
      *--  OUTPUT RESULT SET                                         --         
      *--                                                            --         
      *--   1. CSR04651_R1 - TAX DETAILS.                            --         
      *--         RETURN_CODE          INTEGER                       --         
      *--         APPL_RETURN_CODE     INTEGER                       --         
      *--         REV_CLS_CD_DESC      CHAR(32)                      --         
      *--         REV_DIST_DESC        CHAR(35)                      --         
      *--         COUNTY_DESC          CHAR(22)                      --         
      *--         CODE_SIC_NO          CHAR(04)                      --         
      *--         NAICS_CD             CHAR(06)                      --         
      *--         ST_TAX_EXMPT_NO      CHAR(13)                      --         
      *--         CODE_STAT_TAX_XMT    CHAR(01)                      --         
      *--         CODE_CITY_TAX_XMT    CHAR(01)                      --         
      *--         ST_XMPT_BY_REV_DST   CHAR(01)                      --         
      *--         CITY_XMPT_BY_REV     CHAR(01)                      --         
      *--         PARTIAL_XMPT_CD      CHAR(01)                      --         
      *--         STATE_TAX_PCT        DECIMAL(4,3)                  --         
      *--         CITY_TAX_PCT         DECIMAL(4,3)                  --         
      *--                                                            --         
      *--   2. CSR04651_R2 - PSNC BLOCK DETAILS.                     --         
      *--         RETURN_CODE          INTEGER                       --         
      *--         APPL_RETURN_CODE     INTEGER                       --         
      *--         BLOCK_NO             SMALLINT                      --         
      *--         BLOCK_UNITS          INTEGER                       --         
      *--         TAX_PCT              DECIMAL(11,6)                 --         
      *--                                                            --         
      *--   3. CSR04651_R3 - BUS RULE DETAILS                        --         
      *--         RETURN_CODE          INTEGER                       --         
      *--         APPL_RETURN_CODE     INTEGER                       --         
      *--         BUS_RULE_ID          CHAR(10)                      --         
      *--         BUS_RULE_RESULT_CD   CHAR(10)                      --         
      *--         BUS_RULE_XREF_ID     CHAR(26)                      --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                        MODIFICATION LOG                    --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
P00738*--  09/23/2013    MS93554     PROGRAM INTIALLY WRITTEN.       --         
      *--                                                            --         
      *--  11/20/2013    AD7F921     ADDED CITY_TAX_XMPT_CD AND      --         
      *--                            PARTIAL_TAX_XMPT_CD IN THE      --         
      *--                            RESULT SET1.                    --         
      *--                                                            --         
P00794*--  04/23/2014    SS97726     NC Sales Tax Reforms.           --         
P00794*--                            Effective July 1st 2014 PSNC    --         
P00794*--                            to switch from Excise Tax to    --         
P00794*--                            Sales Tax.                      --         
      *----------------------------------------------------------------         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04651'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-WORKING-STORAGE.                                          
           05 WS-SQLSTATE                 PIC X(05) VALUE SPACES.       
           05 WS-ACCOUNT-NO               PIC 9(13) VALUE ZEROES.       
           05 WS-PREMISE-NO               PIC 9(10) VALUE ZEROES.       
           05 WS-SUB                      PIC 9(02) VALUE ZEROES.       
           05 WS-CODE-UTIL-TYPE           PIC X(01) VALUE SPACES.       
           05 WS-STATE-TX-XMPT-PCT        PIC 9(04)V9(4) VALUE 0.       
           05 WS-CITY-TX-XMPT-PCT         PIC 9(04)V9(4) VALUE 0.       
           05 WS-IC-NO                    PIC S9(04) USAGE COMP         
                                                          VALUE 0.      
           05 WS-REV-DIST-CD-DESC         PIC X(41) VALUE SPACES.       
           05 WS-REV-CLS-CD-DESC          PIC X(32) VALUE SPACES.       
           05 WS-GTT-NAME                 PIC X(19) VALUE SPACES.       
           05 WS-APPL-RETURN-CODE         PIC S9(09) COMP VALUE 0.      
           05 WS-STATE-TAX-PCT            PIC S9(1)V9(3) COMP-3 VALUE 0.
           05 WS-CITY-TAX-PCT             PIC S9(1)V9(3) COMP-3 VALUE 0.
P00794     05 WS-DELQ-PSNC-TAX            PIC 9(09)V9(5) VALUE ZEROS.   
                                                                        
       01  WS-LITERALS.                                                 
           05 PROGRAM-NAME                PIC X(08) VALUE 'CSR04651'.   
           05 MCSCB426                    PIC X(08) VALUE 'MCSCB426'.   
           05 WS-PSNC                     PIC X(02) VALUE '26'.         
           05 STATE-TAX                   PIC 9(02) VALUE 10.           
P00794     05 PSNC-STATE-TAX              PIC 9(02) VALUE 11.           
           05 CITY-TAX                    PIC 9(02) VALUE 20.           
           05 WS-ELECTRIC                 PIC X(01) VALUE 'E'.          
           05 WS-GAS                      PIC X(01) VALUE 'G'.          
           05 WS-UNMETER                  PIC X(01) VALUE 'U'.          
                                                                        
       01  WS-SWITCHES.                                                 
           05 ALL-DONE-SW                 PIC X(01) VALUE 'N'.          
              88 NOT-ALL-DONE                       VALUE 'N'.          
              88 ALL-DONE                           VALUE 'Y'.          
           05 SEND-DONE-SW                PIC X(01) VALUE 'Y'.          
              88 SEND-DONE-ERROR                    VALUE 'N'.          
              88 SEND-DONE-OK                       VALUE 'Y'.          
                                                                        
       01  GTT-MISC-FIELDS.                                             
           05  GTT-ROW.                                                 
               49 GTT-ROW-LEN             PIC S9(04) COMP.              
               49 GTT-ROW-CHAR            PIC X(1024).                  
           05  GTT-SQLCODE                PIC S9(9) COMP.               
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN                 PIC S9(9) COMP VALUE 1.       
           05  CTR-ROWS                   PIC S9(9) COMP VALUE 0.       
           05  CTR-ROWS-RS1               PIC S9(9) COMP VALUE 0.       
           05  CTR-ROWS-RS2               PIC S9(9) COMP VALUE 0.       
           05  CTR-ROWS-RS3               PIC S9(9) COMP VALUE 0.       
                                                                        
       01  WS-ERR-FLAGS.                                                
           05  WS-ERR-INSRT-R1            PIC X(01) VALUE 'N'.          
           05  WS-ERR-INSRT-R2            PIC X(01) VALUE 'N'.          
           05  WS-ERR-INSRT-R3            PIC X(01) VALUE 'N'.          
                                                                        
       01  GTT-RETURN-FIELDS.                                           
      *********************************************************                 
      *   GTT TABLE LAYOUT FOR TAX DETAISL                    *                 
      *********************************************************                 
           05 S-RETURN-CODE               PIC S9(09) COMP VALUE 0.      
           05 GTT-RETURN-FIELDS-1.                                      
              10 S-RETURN-CODE-1          PIC S9(09) COMP VALUE 0.      
              10 S-APPL-RETURN-CODE-1     PIC S9(09) COMP VALUE 0.      
              10 S-RS1-REV-CLS-CD         PIC  X(03) VALUE SPACES.      
              10 S-RS1-REV-CLS-DESC       PIC  X(26) VALUE SPACES.      
              10 S-RS1-REV-DISTRCT-CD     PIC  X(03) VALUE SPACES.      
              10 S-RS1-REV-DISTRCT-DESC   PIC  X(35) VALUE SPACES.      
              10 S-RS1-COUNTY             PIC  X(03) VALUE SPACES.      
              10 S-RS1-COUNTY-DESC        PIC  X(22) VALUE SPACES.      
              10 S-RS1-CODE-SIC-NO        PIC  X(04) VALUE SPACES.      
              10 S-RS1-SIC-LONG-DESC.                                   
                 49 S-RS1-SIC-LONG-DESC-LEN                             
                    PIC S9(4) USAGE COMP VALUE 0.                       
                 49 S-RS1-SIC-LONG-DESC-TXT                             
                    PIC X(512).                                         
                                                                        
              10 S-RS1-NAICS-CD           PIC  X(06) VALUE SPACES.      
              10 S-RS1-NAICS-DESC.                                      
                 49 S-RS1-NAICS-LONG-DESC-LEN                           
                    PIC S9(4) USAGE COMP VALUE 0.                       
                 49 S-RS1-NAICS-LONG-DESC-TXT                           
                    PIC X(256).                                         
              10 S-RS1-STATE-TAX-EXMPT-NO PIC  X(13) VALUE SPACES.      
              10 S-RS1-CODE-STAT-TAX-XMT  PIC  X(01) VALUE SPACES.      
              10 S-RS1-CODE-CITY-TAX-XMT  PIC  X(01) VALUE SPACES.      
              10 S-RS1-ST-XMPT-BY-REV-DST PIC  X(01) VALUE SPACES.      
              10 S-RS1-CITY-XMPT-BY-REV   PIC  X(01) VALUE SPACES.      
              10 S-RS1-PARTIAL-XMPT-CD    PIC  X(01) VALUE SPACES.      
              10 S-RS1-STATE-TAX-PCT      PIC S9(1)V9(3) COMP-3 VALUE 0.
              10 S-RS1-CITY-TAX-PCT       PIC S9(1)V9(3) COMP-3 VALUE 0.
                                                                        
      *********************************************************                 
      *   GTT TABLE LAYOUT FOR BLOCK DETAILS ONLY FOR PSNC    *                 
      *********************************************************                 
           05 GTT-RETURN-FIELDS-2.                                      
              10 S-RETURN-CODE-2          PIC S9(09) COMP VALUE 0.      
              10 S-APPL-RETURN-CODE-2     PIC S9(09) COMP VALUE 0.      
              10 S-RS2-BLOCK-NO           PIC S9(04) COMP VALUE 0.      
              10 S-RS2-BLOCK-UNITS        PIC S9(09) COMP VALUE 0.      
              10 S-RS2-TAX-PCT            PIC S9(5)V9(6) COMP-3 VALUE 0.
                                                                        
      *********************************************************                 
      *   GTT TABLE LAYOUT FOR BUS RULE ERROR MESSAGE        *                  
      *********************************************************                 
           05 GTT-RETURN-FIELDS-3.                                      
              10 S-RETURN-CODE-3          PIC S9(09) COMP VALUE 0.      
              10 S-APPL-RETURN-CODE-3     PIC S9(09) COMP VALUE 0.      
              10 S-RS3-BUS-RULE-ID        PIC X(10)  VALUE SPACES.      
              10 S-RS3-BUS-RULE-RESULT-CD PIC X(10)  VALUE SPACES.      
              10 S-RS3-BUS-RULE-XREF-ID   PIC X(26)  VALUE SPACES.      
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME                 PIC X(18)       VALUE SPACES. 
            10  S-SQLCODE                 PIC S9(9)  COMP VALUE 0.      
            10  S-SQLSTATE                PIC X(5)        VALUE ' '.    
            10  S-TABLE-NAME              PIC X(18)       VALUE SPACES. 
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.         
                49  S-HOST-VARIABLES-V    PIC X(255).                   
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.         
                49  S-SQL-STATEMENT-V     PIC X(255).                   
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.         
                49  S-SQL-DESCRIPTION-V   PIC X(255).                   
                                                                        
      *****************************************************************         
      *    DB2 INCLUDES                                               *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_ACCOUNT, AT                                               *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_CUST_PLAN, CP                                             *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBCSTPLN                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_UTIL_ENVRNMT, UT                                          *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBUTLENV                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_STATE_COUNTY, SC                                          *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBSTCNTY                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_REVENUE_CLASS, F3                                         *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBREVCLS                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_REV_DISTRICT, A9                                          *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBRVDST                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_PREMISE, PR                                               *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBPREM                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_SIC,     R1                                               *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBSIC                                                    
           END-EXEC.                                                            
                                                                        
P00794*****************************************************************         
P00794*CSS_DELINQUENCY. C8                                            *         
P00794*****************************************************************         
P00794     EXEC SQL                                                             
P00794        INCLUDE TBDELQ                                                    
P00794     END-EXEC.                                                            
P00794                                                                  
      *****************************************************************         
      *    SQL ERROR CHECKING COPYBOOK.                               *         
      *****************************************************************         
           COPY CWS00303.                                                       
                                                                        
      *****************************************************************         
      *    WORKING STORAGE SUPPORT FOR 426.                           *         
      *****************************************************************         
           COPY CWS00426.                                                       
                                                                        
      *****************************************************************         
      *    ERROR HANDLING COPY BOOK.                                  *         
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *  CURSOR DECLARATIONS.                                         *         
      *****************************************************************         
                                                                        
       LINKAGE SECTION.                                                 
COB305 01 PARM-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.     
       01  PARM-CODE-UTIL-TYPE            PIC X(01).                    
       01  PARM-IC-NO                     PIC S9(04) USAGE COMP.        
       01  PARM-PREMISE-NO                PIC X(10).                    
                                                                        
       PROCEDURE DIVISION  USING PARM-ACCOUNT-NO                        
                                 PARM-CODE-UTIL-TYPE                    
                                 PARM-IC-NO                             
                                 PARM-PREMISE-NO.                       
                                                                        
      *****************************************************************         
      *                                                               *         
      * 0000-MAINLINE.                                                *         
      *****************************************************************         
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE             THRU 0100-EXIT.          
           PERFORM 1000-PROCESS-INPUT          THRU 1000-EXIT.          
           PERFORM 2000-PROCESS-OUTPUT         THRU 2000-EXIT.          
           PERFORM 9999-END-PROGRAM            THRU 9999-EXIT.          
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 0100-INITIALIZE                                               *         
      *****************************************************************         
       0100-INITIALIZE.                                                 
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1        THRU 0100A-EXIT.         
           PERFORM 0100B-DECLARE-GTT-R2        THRU 0100B-EXIT.         
           PERFORM 0100C-DECLARE-GTT-R3        THRU 0100C-EXIT.         
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 0100A-DECLARE-GTT-R1                                          *         
      *****************************************************************         
       0100A-DECLARE-GTT-R1.                                            
                                                                        
           MOVE 'SESSION.CSR04651_R1'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04651_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04651_R1
              (                                                       
                    RETURN_CODE          INT                        
                   ,APPL_RETURN_CODE     INT                        
                   ,REV_CLS_CD CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,REV_CLS_CD_DESC CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,[REV_DISTRCT-CD] CHAR(03)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,[REV_DISTRCT-DESC] CHAR(35)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,COUNTY CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2            
                   ,COUNTY_DESC CHAR(22)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,CODE_SIC_NO CHAR(04)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,SIC_LONG_DESC VARCHAR(512)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                   
                   ,NAICS_CD CHAR(06)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,NAICS_LONG_DESC VARCHAR(256)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                   
                   ,ST_TAX_EXMPT_NO CHAR(13)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,CODE_STAT_TAX_XMT CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,CODE_CITY_TAX_XMT CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,ST_XMPT_BY_REV_DST CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,CITY_XMPT_BY_REV CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,PARTIAL_XMPT_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,STATE_TAX_PCT        DECIMAL(4,3)                   
                   ,CITY_TAX_PCT         DECIMAL(4,3)                   
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS    THRU 8000A-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100A'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,LTRIM(RTRIM(REV_CLS_CD))        AS 
           REVENUE_CLASS_CD     
                      ,LTRIM(RTRIM(REV_CLS_CD_DESC))   AS 
           REVENUE_CLASS_DESC   
                      ,LTRIM(RTRIM([REV_DISTRCT-CD]))    AS 
           [REV_DISTRCT-CD]       
                      ,LTRIM(RTRIM([REV_DISTRCT-DESC]))  AS 
           [REV_DISTRCT-DESC]     
                      ,LTRIM(RTRIM(COUNTY))            AS COUNTY               
                      ,LTRIM(RTRIM(COUNTY_DESC))       AS COUNTY_DESC          
                      ,LTRIM(RTRIM(CODE_SIC_NO))       AS CODE_SIC_NO          
                      ,LTRIM(RTRIM(SIC_LONG_DESC))     AS SIC_LONG_DESC        
                      ,LTRIM(RTRIM(NAICS_CD))          AS NAICS_CD             
                      ,LTRIM(RTRIM(NAICS_LONG_DESC))   AS 
           NAICS_LONG_DESC      
                      ,LTRIM(RTRIM(ST_TAX_EXMPT_NO))   AS 
           ST_TAX_EXMPT_NO      
                      ,LTRIM(RTRIM(CODE_STAT_TAX_XMT)) AS 
           CODE_STAT_TAX_XMT    
                      ,LTRIM(RTRIM(CODE_CITY_TAX_XMT)) AS 
           CODE_CITY_TAX_XMT    
                      ,LTRIM(RTRIM(ST_XMPT_BY_REV_DST))                        
                                                AS ST_XMPT_BY_REV_DST   
                      ,LTRIM(RTRIM(CITY_XMPT_BY_REV))  AS 
           CITY_XMPT_BY_REV     
                      ,LTRIM(RTRIM(PARTIAL_XMPT_CD))   AS 
           PARTIAL_XMPT_CD      
                      ,STATE_TAX_PCT            AS STATE_TAX_PRCNTG     
                      ,CITY_TAX_PCT             AS CITY_TAX_PRCNTG      
                  FROM #CSR04651_R1                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ026
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,STRIP(REV_CLS_CD)        AS REVENUE_CLASS_CD             
MFA-TR*               ,STRIP(REV_CLS_CD_DESC)   AS REVENUE_CLASS_DESC           
MFA-TR*               ,STRIP(REV_DISTRCT-CD)    AS REV_DISTRCT-CD               
MFA-TR*               ,STRIP(REV_DISTRCT-DESC)  AS REV_DISTRCT-DESC             
MFA-TR*               ,STRIP(COUNTY)            AS COUNTY                       
MFA-TR*               ,STRIP(COUNTY_DESC)       AS COUNTY_DESC                  
MFA-TR*               ,STRIP(CODE_SIC_NO)       AS CODE_SIC_NO                  
MFA-TR*               ,STRIP(SIC_LONG_DESC)     AS SIC_LONG_DESC                
MFA-TR*               ,STRIP(NAICS_CD)          AS NAICS_CD                     
MFA-TR*               ,STRIP(NAICS_LONG_DESC)   AS NAICS_LONG_DESC              
MFA-TR*               ,STRIP(ST_TAX_EXMPT_NO)   AS ST_TAX_EXMPT_NO              
MFA-TR*               ,STRIP(CODE_STAT_TAX_XMT) AS CODE_STAT_TAX_XMT            
MFA-TR*               ,STRIP(CODE_CITY_TAX_XMT) AS CODE_CITY_TAX_XMT            
MFA-TR*               ,STRIP(ST_XMPT_BY_REV_DST)                                
MFA-TR*                                         AS ST_XMPT_BY_REV_DST           
MFA-TR*               ,STRIP(CITY_XMPT_BY_REV)  AS CITY_XMPT_BY_REV             
MFA-TR*               ,STRIP(PARTIAL_XMPT_CD)   AS PARTIAL_XMPT_CD              
MFA-TR*               ,STATE_TAX_PCT            AS STATE_TAX_PRCNTG             
MFA-TR*               ,CITY_TAX_PCT             AS CITY_TAX_PRCNTG              
MFA-TR*           FROM SESSION.CSR04651_R1                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      *                                                               *         
      * 0100B-DECLARE-GTT-R2                                          *         
      *****************************************************************         
       0100B-DECLARE-GTT-R2.                                            
                                                                        
           MOVE 'SESSION.CSR04651_R2'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04651_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04651_R2
              (                                                       
                    RETURN_CODE          INT                        
                   ,APPL_RETURN_CODE     INT                        
                   ,BLOCK_NO             SMALLINT                       
                   ,BLOCK_UNITS          INT                        
                   ,TAX_PCT              DECIMAL(11,6)                  
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000B-DEL-GTT-ROWS    THRU 8000B-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100B'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C2 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,BLOCK_NO                 AS BLOCK_NO             
                      ,BLOCK_UNITS              AS BLOCK_UNITS          
                      ,TAX_PCT                  AS BLOCK_PRICE          
                  FROM #CSR04651_R2                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C2 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,BLOCK_NO                 AS BLOCK_NO                     
MFA-TR*               ,BLOCK_UNITS              AS BLOCK_UNITS                  
MFA-TR*               ,TAX_PCT                  AS BLOCK_PRICE                  
MFA-TR*           FROM SESSION.CSR04651_R2                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100B-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      *                                                               *         
      * 0100C-DECLARE-GTT-R3                                          *         
      *****************************************************************         
       0100C-DECLARE-GTT-R3.                                            
                                                                        
           MOVE 'SESSION.CSR04651_R3'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04651_R3')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04651_R3
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,BUS_RULE_ID CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BUS_RULE_RESULT_CD CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BUS_RULE_XREF_ID CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000C-DEL-GTT-ROWS    THRU 8000C-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100C'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C3 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,LTRIM(RTRIM(BUS_RULE_ID))          AS BUS_RULE_ID       
                      ,LTRIM(RTRIM(BUS_RULE_RESULT_CD))   AS 
           BUS_RULE_RESULT_CD
                      ,LTRIM(RTRIM(BUS_RULE_XREF_ID))     AS 
           BUS_RULE_XREF_ID  
                  FROM #CSR04651_R3                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C3 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,STRIP(BUS_RULE_ID)          AS BUS_RULE_ID               
MFA-TR*               ,STRIP(BUS_RULE_RESULT_CD)   AS BUS_RULE_RESULT_CD        
MFA-TR*               ,STRIP(BUS_RULE_XREF_ID)     AS BUS_RULE_XREF_ID          
MFA-TR*           FROM SESSION.CSR04651_R3                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100C-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      *                                                               *         
      * 1000-PROCESS-INPUT                                            *         
      *****************************************************************         
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-ACCOUNT-NO             TO WS-ACCOUNT-NO.           
           MOVE PARM-CODE-UTIL-TYPE         TO WS-CODE-UTIL-TYPE.       
           MOVE PARM-IC-NO                  TO WS-IC-NO.                
           MOVE PARM-PREMISE-NO             TO WS-PREMISE-NO.           
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 2000-PROCESS-OUTPUT.                                          *         
      *****************************************************************         
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE WS-ACCOUNT-NO               TO AT-ACCOUNT-NO            
                                               CP-ACCOUNT-NO            
                                               UT-ACCOUNT-NO            
                                               WS-426-ACCOUNT-NO.       
                                                                        
           MOVE WS-CODE-UTIL-TYPE           TO F3-CODE-UTIL-TYPE        
                                               CP-CODE-UTIL-TYPE        
                                               UT-CODE-UTIL-TYPE        
                                               WS-426-CODE-UTIL-TYPE.   
                                                                        
           MOVE WS-IC-NO                    TO UT-IC-NO                 
                                               CP-IC-NO                 
                                               WS-426-IC-NO.            
                                                                        
           MOVE WS-PREMISE-NO               TO PR-PREMISE-NO.           
                                                                        
           PERFORM 7000-GET-COMPANY-NO         THRU 7000-EXIT.          
           MOVE AT-COMPANY-NO               TO F3-COMPANY-NO            
P00794                                         C8-COMPANY-NO            
                                               WS-426-COMPANY-NO.       
                                                                        
P00794     IF C8-COMPANY-NO = '26'                                      
P00794        MOVE 'WS-CHANGE-PSNC-TAX'     TO C8-DELINQ-CD             
P00794        PERFORM 7015-GET-DELINQUENCY-VALUE                        
P00794                                         THRU 7015-EXIT           
P00794        MOVE C8-DELINQ-VALUE          TO WS-DELQ-PSNC-TAX         
P00794     END-IF.                                                      
                                                                        
           PERFORM 7010-GET-REV-DISTRICT       THRU 7010-EXIT.          
           MOVE A9-REV-DISTRICT-CD          TO WS-426-REVENUE-DIST-CD   
                                                                        
           PERFORM 7020-GET-COUNTY             THRU 7020-EXIT.          
           PERFORM 7030-GET-SIC-N-NAICS        THRU 7030-EXIT.          
                                                                        
           EVALUATE WS-CODE-UTIL-TYPE                                   
               WHEN WS-GAS                                              
                    MOVE WS-GAS             TO WS-426-ENERGY-FLAG       
               WHEN WS-ELECTRIC                                         
                    MOVE WS-ELECTRIC        TO WS-426-ENERGY-FLAG       
               WHEN WS-UNMETER                                          
                    PERFORM 7040-SEL-SERV-TYPE THRU 7040-EXIT           
                    MOVE CP-CODE-SERVICE-TYPE                           
                                            TO WS-426-ENERGY-FLAG       
           END-EVALUATE.                                                
                                                                        
           PERFORM 5000-GET-TAX-PERCENTAGE     THRU 5000-EXIT.          
           MOVE WS-CODE-REV-CLASS-UT        TO F3-CODE-REVENUE-CLASS.   
           PERFORM 7050-GET-REVENUE-CLS        THRU 7050-EXIT.          
                                                                        
           IF WS-PARTIAL-XMPT-CD > SPACES                               
              MOVE 'Y'                       TO S-RS1-PARTIAL-XMPT-CD   
           ELSE                                                         
              MOVE 'N'                       TO S-RS1-PARTIAL-XMPT-CD   
           END-IF.                                                      
                                                                        
           PERFORM 2100-MOVE-RESULT-SET-R1     THRU 2100-EXIT.          
           PERFORM 8010-INSERT-GTT-R1          THRU 8010-EXIT.          
                                                                        
      *    PROCESS TO GET PSNC BLOCK DETAILS.                                   
P00794     IF AT-COMPANY-NO EQUAL WS-PSNC AND WS-DELQ-PSNC-TAX = 1      
              PERFORM 5200-GET-PSNC-TAX-DET    THRU 5200-EXIT           
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 2100-PROCESS-TO-GET-TAX.                                      *         
      *****************************************************************         
       2100-MOVE-RESULT-SET-R1.                                         
                                                                        
           MOVE F3-CODE-REVENUE-CLASS       TO S-RS1-REV-CLS-CD.        
           MOVE F3-REVENUE-CLS-DESC         TO S-RS1-REV-CLS-DESC.      
           MOVE A9-REV-DISTRICT-CD          TO S-RS1-REV-DISTRCT-CD.    
           MOVE A9-REV-DISTRICT-DESC        TO S-RS1-REV-DISTRCT-DESC.  
           MOVE SC-COUNTY                   TO S-RS1-COUNTY.            
           MOVE SC-COUNTY-DESC              TO S-RS1-COUNTY-DESC.       
      *                                                                         
           IF UT-CODE-SIC-NO > SPACES                                   
              MOVE UT-CODE-SIC-NO           TO S-RS1-CODE-SIC-NO        
              MOVE R1-SIC-LONG-DESC-LEN                                 
                                            TO S-RS1-SIC-LONG-DESC-LEN  
P00794        MOVE R1-SIC-LONG-DESC-TEXT   (1:R1-SIC-LONG-DESC-LEN)     
                                            TO S-RS1-SIC-LONG-DESC-TXT  
           ELSE                                                         
              MOVE SPACES                   TO S-RS1-CODE-SIC-NO        
              MOVE +1                       TO R1-SIC-LONG-DESC-LEN     
              MOVE SPACES                   TO R1-SIC-LONG-DESC-TEXT    
              MOVE R1-SIC-LONG-DESC-LEN                                 
                                            TO S-RS1-SIC-LONG-DESC-LEN  
P00794        MOVE R1-SIC-LONG-DESC-TEXT   (1:R1-SIC-LONG-DESC-LEN)     
                                            TO S-RS1-SIC-LONG-DESC-TXT  
           END-IF.                                                      
      *                                                                         
           IF UT-NAICS-CD > SPACES                                      
              MOVE UT-NAICS-CD              TO S-RS1-NAICS-CD           
              MOVE R1-NAICS-LONG-DESC-LEN   TO S-RS1-NAICS-LONG-DESC-LEN
P00794        MOVE R1-NAICS-LONG-DESC-TEXT (1:R1-NAICS-LONG-DESC-LEN)   
                                            TO S-RS1-NAICS-LONG-DESC-TXT
           ELSE                                                         
              MOVE SPACES                   TO S-RS1-NAICS-CD           
              MOVE +1                       TO R1-NAICS-LONG-DESC-LEN   
              MOVE SPACES                   TO R1-NAICS-LONG-DESC-TEXT  
              MOVE R1-NAICS-LONG-DESC-LEN   TO S-RS1-NAICS-LONG-DESC-LEN
P00794        MOVE R1-NAICS-LONG-DESC-TEXT (1:R1-NAICS-LONG-DESC-LEN)   
                                            TO S-RS1-NAICS-LONG-DESC-TXT
           END-IF                                                       
      *                                                                         
           MOVE WS-ST-TAX-EXMPT-NO-UT       TO S-RS1-STATE-TAX-EXMPT-NO.
           MOVE WS-CODE-STAT-TAX-XMT-UT     TO S-RS1-CODE-STAT-TAX-XMT. 
           MOVE WS-CODE-CITY-TAX-XMT-UT     TO S-RS1-CODE-CITY-TAX-XMT. 
           MOVE WS-ST-TAX-XMPT-REV-CLS      TO S-RS1-ST-XMPT-BY-REV-DST.
           MOVE WS-CT-TAX-XMPT-REV-DST      TO S-RS1-CITY-XMPT-BY-REV.  
           MOVE WS-STATE-TAX-PCT            TO S-RS1-STATE-TAX-PCT.     
           MOVE WS-CITY-TAX-PCT             TO S-RS1-CITY-TAX-PCT.      
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 5000-GET-TAX-PERCENTAGE.                                      *         
      *****************************************************************         
       5000-GET-TAX-PERCENTAGE.                                         
                                                                        
           PERFORM 5100-CALL-TAX-PROGRAM       THRU 5100-EXIT.          
                                                                        
P00794     IF AT-COMPANY-NO NOT = WS-PSNC OR                            
P00794        (AT-COMPANY-NO = WS-PSNC AND WS-DELQ-PSNC-TAX NOT = 1)    
              PERFORM VARYING WS-SUB FROM 1 BY 1 UNTIL                  
                                   WS-SUB > 10 OR                       
                                   WS-TAX-TYPE (WS-SUB) = ZEROES        
      ****    STATE TAX PERCENTAGE.                                             
P00794           IF ((AT-COMPANY-NO NOT = WS-PSNC AND                   
P00794                   WS-TAX-TYPE (WS-SUB) = STATE-TAX) OR           
P00794               (AT-COMPANY-NO     = WS-PSNC AND                   
P00794                   WS-TAX-TYPE (WS-SUB) = PSNC-STATE-TAX))        
                    COMPUTE WS-STATE-TX-XMPT-PCT ROUNDED =              
                            WS-TAX-RATE(WS-SUB) * 100                   
                    MOVE WS-STATE-TX-XMPT-PCT TO WS-STATE-TAX-PCT       
                 END-IF                                                 
                                                                        
      ****    FRANCHISE FEE PERCENTAGE.                                         
                 IF WS-TAX-TYPE (WS-SUB) = CITY-TAX                     
                    COMPUTE WS-CITY-TX-XMPT-PCT ROUNDED =               
                            WS-TAX-RATE(WS-SUB) * 100                   
                    MOVE WS-CITY-TX-XMPT-PCT  TO WS-CITY-TAX-PCT        
                 END-IF                                                 
              END-PERFORM                                               
           END-IF.                                                      
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 5100-CALL-TAX-PROGRAM.                                        *         
      *****************************************************************         
       5100-CALL-TAX-PROGRAM.                                           
                                                                        
           CALL MCSCB426 USING ABEND-FILE                               
                              ,WS-WARNING-DATA-ELEMENTS                 
                              ,LS-CPD00426-INP-FIELDS                   
                              ,LS-CPD00426-RET-FIELDS.                  
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL ZEROES                    
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      *                                                              *          
      * 5200-GET-PSNC-TAX-DET.                                       *          
      ****************************************************************          
       5200-GET-PSNC-TAX-DET.                                           
                                                                        
           PERFORM VARYING WS-SUB FROM 1 BY 1 UNTIL                     
                                 WS-SUB > 10 OR                         
                                 WS-TAX-CNTRL-NO (WS-SUB) = ZEROES      
                MOVE WS-BLOCK-NO (WS-SUB)     TO S-RS2-BLOCK-NO         
                MOVE WS-BLOCK-UNITS (WS-SUB)  TO S-RS2-BLOCK-UNITS      
                MOVE WS-EXCISE-TAX-UNIT-AM (WS-SUB)                     
                                              TO S-RS2-TAX-PCT          
                PERFORM 8020-INSERT-GTT-R2       THRU 8020-EXIT         
                INITIALIZE  GTT-RETURN-FIELDS-2                         
           END-PERFORM.                                                 
                                                                        
       5200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      *                                                              *          
      * 7000-GET-COMPANY-NO.                                         *          
      ****************************************************************          
       7000-GET-COMPANY-NO.                                             
                                                                        
           EXEC SQL                                                     
               SELECT AT.COMPANY_NO                                     
                 INTO :AT-COMPANY-NO                                    
                 FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                      
                WHERE AT.ACCOUNT_NO     = :AT-ACCOUNT-NO                
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT AT.COMPANY_NO                                             
MFA-TR*          INTO :AT-COMPANY-NO                                            
MFA-TR*          FROM CSS_ACCOUNT AT                                            
MFA-TR*         WHERE AT.ACCOUNT_NO     = :AT-ACCOUNT-NO                        
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7000'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_ACCOUNT'             TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      *                                                              *          
      * 7010-GET-REV-DISTRICT.                                       *          
      ****************************************************************          
       7010-GET-REV-DISTRICT.                                           
                                                                        
           EXEC SQL                                                     
              SELECT A9.REV_DISTRICT_CD                                 
                    ,A9.REV_DISTRICT_DESC                               
                INTO :A9-REV-DISTRICT-CD                                
                    ,:A9-REV-DISTRICT-DESC                              
                FROM CSS_PREMISE   PR WITH(READUNCOMMITTED)                     
                    ,CSS_REV_DISTRICT A9 WITH(READUNCOMMITTED)                  
               WHERE PR.PREMISE_NO      = :PR-PREMISE-NO                
                 AND PR.REV_DISTRICT_CD = A9.REV_DISTRICT_CD            
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT A9.REV_DISTRICT_CD                                         
MFA-TR*             ,A9.REV_DISTRICT_DESC                                       
MFA-TR*         INTO :A9-REV-DISTRICT-CD                                        
MFA-TR*             ,:A9-REV-DISTRICT-DESC                                      
MFA-TR*         FROM CSS_PREMISE   PR                                           
MFA-TR*             ,CSS_REV_DISTRICT A9                                        
MFA-TR*        WHERE PR.PREMISE_NO      = :PR-PREMISE-NO                        
MFA-TR*          AND PR.REV_DISTRICT_CD = A9.REV_DISTRICT_CD                    
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7010                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7010'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_PREMISE'             TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'PREMISE_NO'              TO TABLE-ELEMENT-2         
              MOVE WS-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE PR-PREMISE-NO             TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00794*****************************************************************         
P00794*                                                               *         
P00794* 7015-GET-DELINQUENCY-VALUE                                    *         
P00794*****************************************************************         
P00794 7015-GET-DELINQUENCY-VALUE.                                      
P00794                                                                  
P00794     EXEC SQL                                                     
P00794        SELECT  DELINQ_VALUE                                      
P00794          INTO :C8-DELINQ-VALUE                                   
P00794          FROM  CSS_DELINQUENCY C8 WITH(READUNCOMMITTED)                  
P00794         WHERE  DELINQ_CD  = :C8-DELINQ-CD                        
P00794           AND  COMPANY_NO = :C8-COMPANY-NO                       
P00794                                                          
P00794                                                      
P00794     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     17960000
MFA-TR*       SELECT  DELINQ_VALUE                                      17970000
MFA-TR*         INTO :C8-DELINQ-VALUE                                   17980000
MFA-TR*         FROM  CSS_DELINQUENCY C8                                17990000
MFA-TR*        WHERE  DELINQ_CD  = :C8-DELINQ-CD                        18000000
MFA-TR*          AND  COMPANY_NO = :C8-COMPANY-NO                       18010000
MFA-TR*         WITH  UR                                                18011000
MFA-TR*      QUERYNO 7015                                                       
MFA-TR*    END-EXEC.                                                    18020000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00794                                                                  
P00794     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
P00794                                                                  
P00794     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00794        CONTINUE                                                  
P00794     ELSE                                                         
P00794        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
P00794        MOVE '7015'                    TO ACTIVE-PARAGRAPH        
P00794        MOVE 'SELECT'                  TO ABEND-FUNCTION          
P00794        MOVE 'CSS_DELINQUENCY'         TO TABLE-1                 
P00794        MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
P00794        MOVE 'DELINQ_CD'               TO TABLE-ELEMENT-2         
P00794        MOVE 'COMPNAY_NO'              TO TABLE-ELEMENT-3         
P00794        MOVE WS-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
P00794        MOVE C8-DELINQ-CD              TO HOSTVAR-ELEMENT-2       
P00794        MOVE C8-COMPANY-NO             TO HOSTVAR-ELEMENT-3       
P00794        PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
P00794     END-IF.                                                      
P00794                                                                  
P00794 7015-EXIT.                                                       
P00794     EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7020-GET-COUNTY.                                              *         
      *****************************************************************         
       7020-GET-COUNTY.                                                 
                                                                        
           EXEC SQL                                                     
               SELECT SC.COUNTY                                         
                     ,SC.COUNTY_DESC                                    
                 INTO :SC-COUNTY                                        
                     ,:SC-COUNTY-DESC                                   
                 FROM CSS_REV_DISTRICT A9 WITH(READUNCOMMITTED)                 
                     ,CSS_STATE_COUNTY SC WITH(READUNCOMMITTED)                 
                WHERE A9.REV_DISTRICT_CD = :A9-REV-DISTRICT-CD          
                  AND A9.STATE           =  SC.STATE                    
                  AND A9.COUNTY          =  SC.COUNTY                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SC.COUNTY                                                 
MFA-TR*              ,SC.COUNTY_DESC                                            
MFA-TR*          INTO :SC-COUNTY                                                
MFA-TR*              ,:SC-COUNTY-DESC                                           
MFA-TR*          FROM CSS_REV_DISTRICT A9                                       
MFA-TR*              ,CSS_STATE_COUNTY SC                                       
MFA-TR*         WHERE A9.REV_DISTRICT_CD = :A9-REV-DISTRICT-CD                  
MFA-TR*           AND A9.STATE           =  SC.STATE                            
MFA-TR*           AND A9.COUNTY          =  SC.COUNTY                           
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7020                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7020'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_REV_DISTRICT'        TO TABLE-1                 
              MOVE 'CSS_STATE_COUNTY'        TO TABLE-2                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'REV_DISTRICT'            TO TABLE-ELEMENT-2         
              MOVE WS-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE A9-REV-DISTRICT-CD        TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      *                                                              *          
      * 7030-GET-SIC-N-NAICS.                                        *          
      ****************************************************************          
       7030-GET-SIC-N-NAICS.                                            
                                                                        
           EXEC SQL                                                     
               SELECT UT.CODE_SIC_NO                                    
                     ,COALESCE(R1.SIC_LONG_DESC,' ')                      
                     ,UT.NAICS_CD                                       
                     ,COALESCE(R1.NAICS_LONG_DESC,' ')                    
                 INTO :UT-CODE-SIC-NO                                   
                     ,:R1-SIC-LONG-DESC                                 
                     ,:UT-NAICS-CD                                      
                     ,:R1-NAICS-LONG-DESC                               
                 FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                 
P00794           LEFT JOIN CSS_SIC     R1 WITH(READUNCOMMITTED)                 
P00794             ON R1.CODE_SIC_NO     = UT.CODE_SIC_NO               
P00794            AND R1.NAICS_CD        = UT.NAICS_CD                  
                WHERE UT.ACCOUNT_NO      = :UT-ACCOUNT-NO               
                  AND UT.IC_NO           = :UT-IC-NO                    
                  AND UT.CODE_UTIL_TYPE  = :UT-CODE-UTIL-TYPE           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT UT.CODE_SIC_NO                                            
MFA-TR*              ,IFNULL(R1.SIC_LONG_DESC,' ')                              
MFA-TR*              ,UT.NAICS_CD                                               
MFA-TR*              ,IFNULL(R1.NAICS_LONG_DESC,' ')                            
MFA-TR*          INTO :UT-CODE-SIC-NO                                           
MFA-TR*              ,:R1-SIC-LONG-DESC                                         
MFA-TR*              ,:UT-NAICS-CD                                              
MFA-TR*              ,:R1-NAICS-LONG-DESC                                       
MFA-TR*          FROM CSS_UTIL_ENVRNMT UT                                       
MFA-TR*          LEFT JOIN CSS_SIC     R1                                       
MFA-TR*            ON R1.CODE_SIC_NO     = UT.CODE_SIC_NO                       
MFA-TR*           AND R1.NAICS_CD        = UT.NAICS_CD                          
MFA-TR*         WHERE UT.ACCOUNT_NO      = :UT-ACCOUNT-NO                       
MFA-TR*           AND UT.IC_NO           = :UT-IC-NO                            
MFA-TR*           AND UT.CODE_UTIL_TYPE  = :UT-CODE-UTIL-TYPE                   
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7030                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7030'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_UTIL_ENVRNMT'        TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'IC_NO'                   TO TABLE-ELEMENT-2         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-3         
              MOVE UT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE UT-IC-NO                  TO HOSTVAR-ELEMENT-2       
              MOVE UT-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-3       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7040-SEL-SERV-TYPE.                                           *         
      *****************************************************************         
       7040-SEL-SERV-TYPE.                                              
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) CP.CODE_SERVICE_TYPE                              
                 INTO :CP-CODE-SERVICE-TYPE                             
                 FROM CSS_CUST_PLAN CP WITH(READUNCOMMITTED)                    
                WHERE CP.ACCOUNT_NO     = :CP-ACCOUNT-NO                
                  AND CP.CODE_UTIL_TYPE = :CP-CODE-UTIL-TYPE            
                  AND CP.IC_NO          = :CP-IC-NO                     
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CP.CODE_SERVICE_TYPE                                      
MFA-TR*          INTO :CP-CODE-SERVICE-TYPE                                     
MFA-TR*          FROM CSS_CUST_PLAN CP                                          
MFA-TR*         WHERE CP.ACCOUNT_NO     = :CP-ACCOUNT-NO                        
MFA-TR*           AND CP.CODE_UTIL_TYPE = :CP-CODE-UTIL-TYPE                    
MFA-TR*           AND CP.IC_NO          = :CP-IC-NO                             
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*       QUERYNO 7040                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7040'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_CUST_PLAN'           TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE 'IC_NO'                   TO TABLE-ELEMENT-3         
              MOVE CP-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE CP-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              MOVE CP-IC-NO                  TO HOSTVAR-ELEMENT-3       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7040-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      *                                                              *          
      * 7050-GET-REVENUE-CLS.                                        *          
      ****************************************************************          
       7050-GET-REVENUE-CLS.                                            
                                                                        
           EXEC SQL                                                     
               SELECT F3.CODE_REVENUE_CLASS                             
                     ,F3.REVENUE_CLS_DESC                               
                 INTO :F3-CODE-REVENUE-CLASS                            
                     ,:F3-REVENUE-CLS-DESC                              
                 FROM CSS_REVENUE_CLASS F3 WITH(READUNCOMMITTED)                
                WHERE F3.COMPANY_NO         = :F3-COMPANY-NO            
                  AND F3.CODE_REVENUE_CLASS = :F3-CODE-REVENUE-CLASS    
                  AND F3.CODE_UTIL_TYPE     = :F3-CODE-UTIL-TYPE        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT F3.CODE_REVENUE_CLASS                                     
MFA-TR*              ,F3.REVENUE_CLS_DESC                                       
MFA-TR*          INTO :F3-CODE-REVENUE-CLASS                                    
MFA-TR*              ,:F3-REVENUE-CLS-DESC                                      
MFA-TR*          FROM CSS_REVENUE_CLASS F3                                      
MFA-TR*         WHERE F3.COMPANY_NO         = :F3-COMPANY-NO                    
MFA-TR*           AND F3.CODE_REVENUE_CLASS = :F3-CODE-REVENUE-CLASS            
MFA-TR*           AND F3.CODE_UTIL_TYPE     = :F3-CODE-UTIL-TYPE                
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7050                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7050'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_PREMISE'             TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-2         
              MOVE 'CODE_REVENUE_CLASS'      TO TABLE-ELEMENT-3         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-4         
              MOVE WS-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE F3-COMPANY-NO             TO HOSTVAR-ELEMENT-2       
              MOVE F3-CODE-REVENUE-CLASS     TO HOSTVAR-ELEMENT-3       
              MOVE F3-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-4       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8000A-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000A-DEL-GTT-ROWS.                                              
                                                                        
                                                                        
           EXEC SQL                                                     
              DELETE FROM #CSR04651_R1                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM SESSION.CSR04651_R1                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1          
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000A'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04651_R1'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       8000A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8000B-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000B-DEL-GTT-ROWS.                                              
                                                                        
                                                                        
           EXEC SQL                                                     
              DELETE FROM #CSR04651_R2                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM SESSION.CSR04651_R2                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-2.         
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-2          
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000B'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04651_R2'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       8000B-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8000C-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000C-DEL-GTT-ROWS.                                              
                                                                        
                                                                        
           EXEC SQL                                                     
              DELETE FROM #CSR04651_R3                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM SESSION.CSR04651_R3                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-3.         
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-3          
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000C'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04651_R3'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       8000C-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8010-INSERT-GTT-R1.                                           *         
      *****************************************************************         
       8010-INSERT-GTT-R1.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04651_R1                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,REV_CLS_CD                                           
                  ,REV_CLS_CD_DESC                                      
                  ,[REV_DISTRCT-CD]                                       
                  ,[REV_DISTRCT-DESC]                                     
                  ,COUNTY                                               
                  ,COUNTY_DESC                                          
                  ,CODE_SIC_NO                                          
                  ,SIC_LONG_DESC                                        
                  ,NAICS_CD                                             
                  ,NAICS_LONG_DESC                                      
                  ,ST_TAX_EXMPT_NO                                      
                  ,CODE_STAT_TAX_XMT                                    
                  ,CODE_CITY_TAX_XMT                                    
                  ,ST_XMPT_BY_REV_DST                                   
                  ,CITY_XMPT_BY_REV                                     
                  ,PARTIAL_XMPT_CD                                      
                  ,STATE_TAX_PCT                                        
                  ,CITY_TAX_PCT                                         
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-1                                     
                  ,:S-APPL-RETURN-CODE-1                                
                  ,:S-RS1-REV-CLS-CD                                    
                  ,:S-RS1-REV-CLS-DESC                                  
                  ,:S-RS1-REV-DISTRCT-CD                                
                  ,:S-RS1-REV-DISTRCT-DESC                              
                  ,:S-RS1-COUNTY                                        
                  ,:S-RS1-COUNTY-DESC                                   
                  ,:S-RS1-CODE-SIC-NO                                   
                  ,:S-RS1-SIC-LONG-DESC                                 
                  ,:S-RS1-NAICS-CD                                      
                  ,:S-RS1-NAICS-DESC                                    
                  ,:S-RS1-STATE-TAX-EXMPT-NO                            
                  ,:S-RS1-CODE-STAT-TAX-XMT                             
                  ,:S-RS1-CODE-CITY-TAX-XMT                             
                  ,:S-RS1-ST-XMPT-BY-REV-DST                            
                  ,:S-RS1-CITY-XMPT-BY-REV                              
                  ,:S-RS1-PARTIAL-XMPT-CD                               
                  ,:S-RS1-STATE-TAX-PCT                                 
                  ,:S-RS1-CITY-TAX-PCT                                  
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ026
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04651_R1                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,REV_CLS_CD                                                   
MFA-TR*           ,REV_CLS_CD_DESC                                              
MFA-TR*           ,REV_DISTRCT-CD                                               
MFA-TR*           ,REV_DISTRCT-DESC                                             
MFA-TR*           ,COUNTY                                                       
MFA-TR*           ,COUNTY_DESC                                                  
MFA-TR*           ,CODE_SIC_NO                                                  
MFA-TR*           ,SIC_LONG_DESC                                                
MFA-TR*           ,NAICS_CD                                                     
MFA-TR*           ,NAICS_LONG_DESC                                              
MFA-TR*           ,ST_TAX_EXMPT_NO                                              
MFA-TR*           ,CODE_STAT_TAX_XMT                                            
MFA-TR*           ,CODE_CITY_TAX_XMT                                            
MFA-TR*           ,ST_XMPT_BY_REV_DST                                           
MFA-TR*           ,CITY_XMPT_BY_REV                                             
MFA-TR*           ,PARTIAL_XMPT_CD                                              
MFA-TR*           ,STATE_TAX_PCT                                                
MFA-TR*           ,CITY_TAX_PCT                                                 
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-1                                             
MFA-TR*           ,:S-APPL-RETURN-CODE-1                                        
MFA-TR*           ,:S-RS1-REV-CLS-CD                                            
MFA-TR*           ,:S-RS1-REV-CLS-DESC                                          
MFA-TR*           ,:S-RS1-REV-DISTRCT-CD                                        
MFA-TR*           ,:S-RS1-REV-DISTRCT-DESC                                      
MFA-TR*           ,:S-RS1-COUNTY                                                
MFA-TR*           ,:S-RS1-COUNTY-DESC                                           
MFA-TR*           ,:S-RS1-CODE-SIC-NO                                           
MFA-TR*           ,:S-RS1-SIC-LONG-DESC                                         
MFA-TR*           ,:S-RS1-NAICS-CD                                              
MFA-TR*           ,:S-RS1-NAICS-DESC                                            
MFA-TR*           ,:S-RS1-STATE-TAX-EXMPT-NO                                    
MFA-TR*           ,:S-RS1-CODE-STAT-TAX-XMT                                     
MFA-TR*           ,:S-RS1-CODE-CITY-TAX-XMT                                     
MFA-TR*           ,:S-RS1-ST-XMPT-BY-REV-DST                                    
MFA-TR*           ,:S-RS1-CITY-XMPT-BY-REV                                      
MFA-TR*           ,:S-RS1-PARTIAL-XMPT-CD                                       
MFA-TR*           ,:S-RS1-STATE-TAX-PCT                                         
MFA-TR*           ,:S-RS1-CITY-TAX-PCT                                          
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R1 = 'Y'             
              ADD +1                        TO CTR-ROWS-RS1             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8010'                   TO ACTIVE-PARAGRAPH         
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE 'Y'                      TO WS-ERR-INSRT-R1          
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSR04651_R1'            TO TABLE-1                  
              MOVE SPACES                   TO TABLE-ELEMENT-1          
              MOVE SPACES                   TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
        8010-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8020-INSERT-GTT-R2.                                           *         
      *****************************************************************         
       8020-INSERT-GTT-R2.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04651_R2                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,BLOCK_NO                                             
                  ,BLOCK_UNITS                                          
                  ,TAX_PCT                                              
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-2                                     
                  ,:S-APPL-RETURN-CODE-2                                
                  ,:S-RS2-BLOCK-NO                                      
                  ,:S-RS2-BLOCK-UNITS                                   
                  ,:S-RS2-TAX-PCT                                       
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04651_R2                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,BLOCK_NO                                                     
MFA-TR*           ,BLOCK_UNITS                                                  
MFA-TR*           ,TAX_PCT                                                      
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-2                                             
MFA-TR*           ,:S-APPL-RETURN-CODE-2                                        
MFA-TR*           ,:S-RS2-BLOCK-NO                                              
MFA-TR*           ,:S-RS2-BLOCK-UNITS                                           
MFA-TR*           ,:S-RS2-TAX-PCT                                               
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-2.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R2 = 'Y'             
              ADD +1                        TO CTR-ROWS-RS2             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8020'                   TO ACTIVE-PARAGRAPH         
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE 'Y'                      TO WS-ERR-INSRT-R2          
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSR04651_R2'            TO TABLE-1                  
              MOVE SPACES                   TO TABLE-ELEMENT-1          
              MOVE SPACES                   TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
        8020-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8030-INSERT-GTT-R3.                                           *         
      *****************************************************************         
       8030-INSERT-GTT-R3.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04651_R3                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,BUS_RULE_ID                                          
                  ,BUS_RULE_RESULT_CD                                   
                  ,BUS_RULE_XREF_ID                                     
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-3                                     
                  ,:S-APPL-RETURN-CODE-3                                
                  ,:S-RS3-BUS-RULE-ID                                   
                  ,:S-RS3-BUS-RULE-RESULT-CD                            
                  ,:S-RS3-BUS-RULE-XREF-ID                              
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04651_R3                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,BUS_RULE_ID                                                  
MFA-TR*           ,BUS_RULE_RESULT_CD                                           
MFA-TR*           ,BUS_RULE_XREF_ID                                             
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-3                                             
MFA-TR*           ,:S-APPL-RETURN-CODE-3                                        
MFA-TR*           ,:S-RS3-BUS-RULE-ID                                           
MFA-TR*           ,:S-RS3-BUS-RULE-RESULT-CD                                    
MFA-TR*           ,:S-RS3-BUS-RULE-XREF-ID                                      
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-3.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R3 = 'Y'             
              ADD +1                        TO CTR-ROWS-RS3             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8030'                   TO ACTIVE-PARAGRAPH         
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE 'Y'                      TO WS-ERR-INSRT-R3          
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSR04651_R3'            TO TABLE-1                  
              MOVE SPACES                   TO TABLE-ELEMENT-1          
              MOVE SPACES                   TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
        8030-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8800-CHECK-RESULTS.                                           *         
      *****************************************************************         
       8800-CHECK-RESULTS.                                              
                                                                        
           IF CTR-ROWS-RS1 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-1                            
              MOVE   0                      TO S-RETURN-CODE-1          
              MOVE 100                      TO S-APPL-RETURN-CODE-1     
              PERFORM 8010-INSERT-GTT-R1       THRU 8010-EXIT           
           END-IF.                                                      
                                                                        
           IF CTR-ROWS-RS2 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-2                            
              MOVE   0                      TO S-RETURN-CODE-2          
              MOVE 100                      TO S-APPL-RETURN-CODE-2     
              PERFORM 8020-INSERT-GTT-R2       THRU 8020-EXIT           
           END-IF.                                                      
                                                                        
           IF CTR-ROWS-RS3 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-3                            
              MOVE   0                      TO S-RETURN-CODE-3          
              MOVE 100                      TO S-APPL-RETURN-CODE-3     
              PERFORM 8030-INSERT-GTT-R3       THRU 8030-EXIT           
           END-IF.                                                      
                                                                        
       8800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8900-SEND-DONE.                                               *         
      *****************************************************************         
       8900-SEND-DONE.                                                  
                                                                        
           MOVE PROGRAM-NAME                TO ABEND-PROGRAM            
           MOVE '8900'                      TO ACTIVE-PARAGRAPH         
           MOVE 'OPEN'                      TO ABEND-FUNCTION           
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE 'CSR04651_R1'            TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C2                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-2.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE 'CSR04651_R2'            TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C3                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C3 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-3.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE 'CSR04651_R3'            TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 9000-SEND-ERROR-RESULT                                        *         
      *****************************************************************         
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE       TO ABEND-SQLCODE            
                                               S-RETURN-CODE-1          
                                               S-RETURN-CODE-2          
                                               S-RETURN-CODE-3.         
                                                                        
           MOVE WS-APPL-RETURN-CODE         TO S-APPL-RETURN-CODE-1     
                                               S-APPL-RETURN-CODE-2     
                                               S-APPL-RETURN-CODE-3.    
                                                                        
                                                                        
           MOVE SQLERRMC                    TO ABEND-SQLERRMC.          
                                                                        
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'               TO ABEND-FUNCTION           
           END-IF.                                                      
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1        THRU 0100A-EXIT.         
           PERFORM 0100B-DECLARE-GTT-R2        THRU 0100B-EXIT.         
           PERFORM 0100C-DECLARE-GTT-R3        THRU 0100C-EXIT.         
                                                                        
           PERFORM 8010-INSERT-GTT-R1          THRU 8010-EXIT.          
           PERFORM 8020-INSERT-GTT-R2          THRU 8020-EXIT.          
           PERFORM 8030-INSERT-GTT-R3          THRU 8030-EXIT.          
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 9700-ABEND-PROCESSING.                                        *         
      *****************************************************************         
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT.             
           PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT.             
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 9900-SQL-ERROR-ROUTINE.                                       *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * 9999-END-PROGRAM.                                             *         
      *****************************************************************         
                                                                        
       9999-END-PROGRAM.                                                
                                                                        
            PERFORM 8800-CHECK-RESULTS THRU 8800-EXIT                   
            PERFORM 8900-SEND-DONE     THRU 8900-EXIT                   
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
