       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04650.                                         
COB303 DATE-WRITTEN.  JUNE  20, 2014.                                   
       DATE-COMPILED.                                                   
                                                                        
      *-----------------------------------------------------------------00051000
      *--                  SOUTH CAROLINA ELECTRIC & GAS              --00052000
      *-----------------------------------------------------------------00053000
      *--                   STORED PROCEDURE:  CSR04650               --00054000
      *-----------------------------------------------------------------00055000
      *--                         S U M M A R Y                       --00056000
      *--                                                             --00057000
      *--  CSR04650 :                                                 --00058000
      *--                                                             --00059000
      *--  THIS PROCEDURE INSERT/UPDATE/ DELETE CUST PLAN INFORMATION --00059100
      *--                                                             --00059200
      *--  CLONE OF CSR02119                                          --00059300
      *-----------------------------------------------------------------00059400
      *--                                                             --00059500
      *--  PARAMETERS                                                 --00059600
      *--                                                             --00059700
      *--      INPUT                                                  --00059800
      *--           ACTION_IND             CHAR(1)                    --00059901
      *--          ,ACCOUNT_NO             DECIMAL(13)                --00060001
      *--          ,CODE_UTIL_TYPE         CHAR(1)                    --00060101
      *--          ,IC_NO                  SMALLINT                   --00060201
      *--          ,RATE_ITEM_CODE         SMALLINT                   --00060301
      *--          ,ITEM_SEQ_NO            SMALLINT                   --00060401
      *--          ,NO_UNITS               INTEGER                    --00060501
      *--          ,DATE_PLAN_START        DATE                       --00060601
      *--          ,LAST_BILL_DATE         DATE                       --00060701
      *--          ,MTHLY_AMOUNT_FIXED     DECIMAL(11,2)              --00060801
      *--          ,USAGE_FIXED            DECIMAL(9,0)               --00060901
      *--          ,CODE_PLAN_STATUS       CHAR(1)                    --00061001
      *--          ,CODE_STAT_REASON       CHAR(1)                    --00061101
      *--          ,USER_ID                CHAR(7)                    --00061201
      *--          ,COMMENT-LEN            SMALLINT                   --00061301
      *--          ,COMMENT-TEXT           CHAR(210)                  --00061401
      *--          ,OLD_RATE_ITEM_CODE     SMALLINT                   --00061500
      *--          ,REMOVE_DATE            DATE                       --00061600
      *--                                                             --00061800
      *--      OUT                                                    --00061900
      *--                                                             --00062000
      *--            NONE                                             --00062100
      *--                                                             --00062200
      *--      INOUT                                                  --00062300
      *--                                                             --00062400
      *--            NONE                                             --00062500
      *--                                                             --00062600
      *--  RESULT SET                                                 --00062700
      *--                                                             --00062800
      *--  CSR04650_R1 - UPDATE RETURN CODE                           --00063400
      *--                                                             --00063500
      *--           RETURN_CODE            INTEGER                    --00063600
      *--          ,APPL_RETURN_CODE       INTEGER                    --00063700
      *--          ,RATE_ITEM_CODE         SMALLINT                   --00063800
      *--          ,ITEM_SEQ_NO            SMALLINT                   --00063900
      *--          ,ACCOUNT_NO             DECIMAL(13)                --00064000
      *--          ,BUS_RULE_ID            CHAR(10)                   --00064100
      *--          ,BUS_RULE_RESULT_CD     CHAR(10)                   --00064200
      *--          ,BUS_RULE_XREF_ID       CHAR(26)                   --00064300
      *--                                                             --00064400
      *-----------------------------------------------------------------00064500
      *--                        MODIFICATION LOG                     --00064600
      *--                                                             --00064700
      *--  DATE      INITIALS  COMMENTS                               --00064800
      *-- ---------- -------- ------------------------------------------00064900
P00738*--08/22/2013  AD7F921  INITIAL VERSION.                        --00065002
      *--07/05/95    SD       PROCEDURE ORIGINALLY CODED.             --00380000
      *--06/25/97    MJL      DELETE BILL DETAIL WHEN CANCELING CUST  --00390000
      *--                     PLAN.                                   --00400000
PCR618*--03/24/98    TDK      PCR618 : ENABLED THE SAVING OF THE RATE --00410000
PCR618*--                     ITEM DESC AFTER IT HAS BEEN MODIFIED.   --00420000
T15760*--04/07/98    TDK      CORRECTED THE FIXED USAGE TO SAVE ALL   --00430000
T15760*--                     DIGITS ENETERED; NOT TO DIVIDE BY 10.   --00440000
T16412*--05/14/98    TDK      ADDED LAST BILL DATE TO THE INSERT/UPD. --00450000
PCR618*--05/19/98    TDK      ADDED REMOVE DATE TO THE INSERT/UPDATE. --00460000
CBSI  *--08/10/98    CBSI     ABEND LOG MODIFIED TO INCLUDE ALL THE   --00470000
CBSI  *--            MADRAS    ABEND PARAMETERS                       --00480000
T17596*--09/22/98    TDK      CHECK MTRD_ENVRNMT BEFORE SETTING PREMISE-00490000
T17596*--                     INDICATORS.                             --00500000
T19120*--09/22/98    RGB      CHECK WHETHER ANY OTHER ACTIVE ACCOUNT  --00510000
T19120*--                     EXIST FOR PARTICULAR PREMISE BEFORE     --00520000
T19120*--                     CHANGING THE ACCOUNT STATUS TO ACTIVE   --00530000
T19443*--04/04/99    RGB      CHECK WHETHER ANY OTHER ACCOUNT         --00540000
T19443*--                     EXIST FOR PARTICULAR PREMISE IN CUST_   --00550000
T19443*--                     PREM_HIST TABLE FOR PENDING ACCT BEFORE --00560000
T19443*--                     CHANGING THE ACCOUNT STATUS TO ACTIVE   --00570000
T21697*--04/20/99    RGB      CHANGED THE CODE TO SET LITE-AVAILABLE  --00580000
T21697*--                     IND TO INACTIVE ONLY AFTER CHECKING NO  --00590000
T21697*--                     OTHER ACCOUNT IS ACTIVE IN THAT PREMISE --00600000
T23256*--12/13/00    CBSI     PREMISE STATUS IS SET ACTIVE WHEN       --00610000
T23256*--                     LIGHTING IS SET ACTIVE                  --00620000
T22433*--03/27/01    COVANSYS CHANGES MADE TO UPDATE LITE-AVAILABLE-IND-00630000
T22433*--            INDIA    TO INACTIVE WHEN ALL THE UNMETERED UTILI--00640000
T22433*--                     TIES ARE REMOVED                        --00650000
BILGEN*--12/18/01    COVANSYS DO NOT ALLOW MULTIPLE ACTIVE            --00660000
BILGEN*--            CHENNAI  CSS_CUST_PLAN ROWS FOR BILLGEN IC.      --00670000
T26267*--05/17/02    COVANSYS COMMENTED THE CODE THAT DELETE'S ROW    --00680000
T26267*--            CHENNAI  FROM CSS_BILLING_DET TO ALLOW A         --00690000
T26267*--                     CANCEL REBILL ON FUTURE ROW FOR A       --00700000
T26267*--                     UNMETERD IC WHEN THE CODE_PLAN_STATUS   --00710000
T26267*--                     WAS CHANGED FROM ACTIVE TO OTHER VALUE  --00720000
REARCH*--09/13/05    CVNS     RPC TO COBOL DB2 SP CONVERSION.         --00721000
REARCH*--            CHENNAI                                          --00722000
T35434*--07/10/07    MK92804  REPLACED MODEL_SQL TO SET STATEMENT AND --00724000
T35434*--                     ADDED FOR FETCH ONLY WITH UR FOR CURSORS--00725000
T35434*--                     AND WITH UR FOR SELECT STATEMENTS.      --00726000
T36513*--06/10/08    SV85244  PREMISE STATUS MADE ACTIVE WHEN ACCOUNT --00727000
T35434*--                     IS MADE ACTIVE.                         --00728000
T36680*--06/10/08    SV85244  INSERT OR UPDATE ROLLED BACK WHEN ERROR --00729000
T36680*--                     OCCURS DURING PROCESS.                  --00729100
A00302*--12/16/08    MN90523  UPDATE REMOVE DATE AND DELETE FUTURE BIL--00729200
A00302*--                     HOOK IF THE UPDATED ROW IS ONLY ROW FOR --00729300
A00302*--                     THE IC WITH NO REMOVE DATE              --00729400
P00496*--06/15/11    SS97726  ALLOW NEGATIVE VALUES FOR 'NO UNITS'.   --00729500
A05065*--11/20/14    AD7F921  RESOLVE ISSUE WITH SERVICE TYPE INSERT  --00729600
A05065*--                     AS NULL.  DEFECT # 6159                 --00729700
A05065*--11/21/14    AD7F921  ADDED UTILITY TYPE,IC# AND RATE ITEM COD--00729600
A05065*--                     IN THE TRANSACTION COMMENTS BEFORE      --00729700
A05065*--                     THE USER COMMENTS.                      --00729800
A05065*--12/12/14    AW41078  MOVED '01' FOR COMPANY TO GET CODE VALUE--        
A05065*--                     DESC FOR PLAN STATUS AND REASON TO FIX  --        
A05065*--                     ISSUE WHERE DESC NOT GETTING WRITTEN TO --        
A05065*--                     TRANS HIST FOR PSNC.                    --        
ACT052*--03/04/15    VIJAY    UPDATE CODE-SERVICE-TYPE DURING UPDATE  --        
ACT052*--A05136               PROCESS.                                --        
      *--*************************************************************--00730000
      *--                                                             --00740000
      *--              ---- BASIC SEQUENCE STRUCTURE ----             --00750000
      *--                                                             --00760000
      *--0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION            --00770000
      *--1000 - 1999  INPUT PROCESSING CONTROL PATH                   --00780000
      *--2000 - 2999  OUTPUT PROCESSING CONTROL PATH                  --00790000
      *--3000 - 4999  NOT USED                                        --00800000
      *--5000 - 5999  COMMON PROGRAM MODULES                          --00810000
      *--6000 - 6999  COMMON SYSTEM MODULES                           --00820000
      *--7000 - 7999  INPUT MODULES                                   --00830000
      *--8000 - 8999  OUTPUT MODULES                                  --00840000
      *--9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES            --00850000
      *--                                                             --00860000
      *--***************************************************************00870000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04650'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR04650 STARTS HERE'.                  
                                                                        
      ******************************************************************00960000
      *    DB2 INCLUDES                                                *00970000
      ******************************************************************00980000
                                                                        
           EXEC SQL                                                     01000000
              INCLUDE SQLCA                                             01010000
           END-EXEC.                                                    01020000
                                                                        
      ******************************************************************01040001
      *    CSS_MNT_TRANS_HIST MH                                       *01050001
      ******************************************************************01060001
           EXEC SQL                                                     01080000
              INCLUDE TBMNHIST                                          01090000
           END-EXEC.                                                    01100000
                                                                        
      ******************************************************************01111001
      *    CSS_MT_TRN_HST_DET MI                                       *01112001
      ******************************************************************01113001
           EXEC SQL                                                     01120000
              INCLUDE TBMNHDT                                           01130000
           END-EXEC.                                                    01140000
                                                                        
      ******************************************************************01151001
      *    CSS_RESP_AREA      C1                                       *01152001
      ******************************************************************01153001
           EXEC SQL                                                     01160000
              INCLUDE TBRSAREA                                          01170000
           END-EXEC.                                                    01180000
                                                                        
      ******************************************************************01191001
      *    CSS_USER_PROFILE   PF                                       *01192001
      ******************************************************************01193001
           EXEC SQL                                                     01200000
              INCLUDE TBUSRPRF                                          01210000
           END-EXEC.                                                    01220000
                                                                        
      ******************************************************************01230100
      *    CSS_CODE_VALUE     UV                                       *01230200
      ******************************************************************01230300
           EXEC SQL                                                     01230400
              INCLUDE TBCDVALU                                          01230500
           END-EXEC.                                                    01230600
                                                                        
      ******************************************************************01231001
      *    CSS_CUST_PLAN      CP                                       *01232001
      ******************************************************************01233001
           EXEC SQL                                                     01240000
              INCLUDE TBCSTPLN                                          01250000
           END-EXEC.                                                    01260000
                                                                        
      ******************************************************************01271001
      *    CSS_ACCOUNT        AT                                       *01272001
      ******************************************************************01273001
           EXEC SQL                                                     01280000
              INCLUDE TBACCT                                            01290000
           END-EXEC.                                                    01300000
                                                                        
      ******************************************************************01311001
      *    CSS_ACCOUNT        AT                                       *01312001
      ******************************************************************01313001
           EXEC SQL                                                     01320000
              INCLUDE TBCUST                                            01330000
           END-EXEC.                                                    01340000
                                                                        
      ******************************************************************01351001
      *    CSS_CUSTOMER       CU                                       *01352001
      ******************************************************************01353001
           EXEC SQL                                                     01360000
              INCLUDE TBPREM                                            01370000
           END-EXEC.                                                    01380000
                                                                        
      ******************************************************************01391001
      *    CSS_BILLING_DET    BG                                       *01392001
      ******************************************************************01393001
           EXEC SQL                                                     01400000
              INCLUDE TBBLLDET                                          01410000
           END-EXEC.                                                    01420000
                                                                        
      ******************************************************************01431001
      *    CSS_UTIL_ENVRNMT   UT                                       *01432001
      ******************************************************************01433001
           EXEC SQL                                                     01440000
              INCLUDE TBUTLENV                                          01450000
           END-EXEC.                                                    01460000
                                                                        
      ******************************************************************01471001
      *    CSS_RATE_PLAN_DESC RD                                       *01472001
      ******************************************************************01473001
           EXEC SQL                                                     01480000
              INCLUDE TBRTDESC                                          01490000
           END-EXEC.                                                    01500000
                                                                        
      ******************************************************************01471001
      *    CSS_RATE_CREATOR   RT                                       *01472001
      ******************************************************************01473001
           EXEC SQL                                                     01480000
              INCLUDE TBRTCRTR                                          01490000
           END-EXEC.                                                    01500000
                                                                        
      ******************************************************************01511001
      *    CSS_UNMTR_PLAN     UP                                       *01512001
      ******************************************************************01513001
           EXEC SQL                                                     01520000
              INCLUDE TBUMPLAN                                          01530000
           END-EXEC.                                                    01540000
                                                                        
      ******************************************************************01511001
      *    CSS_UM_EQUIPMENT   L9                                       *01512001
      ******************************************************************01513001
           EXEC SQL                                                     01520000
              INCLUDE TBUMEQP                                           01530000
           END-EXEC.                                                    01540000
                                                                        
      ******************************************************************01551001
      *    CSS_CUST_PREM_HIST CH                                       *01552001
      ******************************************************************01553001
           EXEC SQL                                                     01560000
              INCLUDE TBCSTPRM                                          01570000
           END-EXEC.                                                    01580000
                                                                        
      ******************************************************************01600000
      *    COBOL WORKING STORAGE COPY BOOKS                            *01610000
      ******************************************************************01620000
                                                                        
      *--------< CONTAINS THE COBOL EQUATES NEEDED FOR USING THE >      01640000
      *--------<COMMON SYSTEM AREA >                                    01690000
           COPY CCA00001.                                               01700000
      *--------< ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS >       01730000
           COPY CWS00027.                                               01740000
      *--------< SUPPORTS DB2 AND SQL ERROR CHECKING >                  01750000
           COPY CWS00303.                                               01760000
      *--------< TO BREAK UP CODES_DATA_PRESENT      >                  01770000
           COPY CWS00056.                                               01780000
      *                                                                 01790000
           EXEC SQL                                                     01800000
                INCLUDE CWS00013                                        01810000
           END-EXEC.                                                    01820000
      *                                                                 01830000
      ******************************************************************01840000
      *    WORK AREAS                                                  *01850000
      ******************************************************************01860000
                                                                        
       01  WS-MISC.                                                     
REARCH     05  PROGRAM-NAME              PIC X(08) VALUE 'CSR04650'.    
           05  ALL-DONE-SW               PIC X(01) VALUE 'N'.           
               88 NOT-ALL-DONE                     VALUE 'N'.           
               88 ALL-DONE                         VALUE 'Y'.           
           05  SEND-DONE-SW              PIC X(01) VALUE 'Y'.           
               88 SEND-DONE-ERROR                  VALUE 'N'.           
               88 SEND-DONE-OK                     VALUE 'Y'.           
           05  WS-ACTION-IND             PIC X(01) VALUE SPACES.        
               88 WS-UPDATE                        VALUE 'U'.           
               88 WS-INSERT                        VALUE 'I'.           
               88 WS-DELETE                        VALUE 'D'.           
      *                                                                 01950500
           05  WS-DAY                    PIC S9(04) COMP VALUE 0.       
           05  WS-LEN                    PIC S9(04) COMP VALUE 0.       
COB305     05 WS-CUSTOMER-NO        PIC S9(10)V USAGE COMP-3 VALUE 0.      
P00496     05  WS-NO-UNITS-VALUE.                                       
P00496         15  WS-NO-UNITS-SI        PIC X(01).                     
P00496         15  WS-NO-UNITS-AM        PIC X(09).                     
LMSCHG     05  WS-NO-UNITS-X             PIC X(09).                     
LMSCHG     05  WS-NO-UNITS-NUM     REDEFINES WS-NO-UNITS-X              
LMSCHG                                   PIC ZZZZZZZZ9.                 
P00496     05  WS-NO-UNITS-HOLD          PIC S9(9) COMP.                
           05  WS-NO-UNITS-OLD           PIC S9(9) COMP.                
           05  WS-DATE-PLAN-START-OLD    PIC X(10).                     
A00302     05  WS-ROW-EXIST              PIC X(01) VALUE 'N'.           
           05  WS-LAST-BILL-DATE-OLD     PIC X(10).                     
           05  WS-MTHLY-AMOUNT-FIXED     PIC X(12).                     
           05  WS-MTHLY-AMOUNT-FIXED-DEC                                
                                   REDEFINES WS-MTHLY-AMOUNT-FIXED      
                                         PIC ZZZZZZZZ9V99.              
           05  WS-MTHLY-AMOUNT-FIXED-OLD PIC S9(9)V9(2) USAGE COMP-3    
                                                   VALUE 0.             
      *                                                                 02201004
           05  WS-MTHLY-AMOUNT-FIXED-VAL.                               
               10 MTHLY-AMT-FIX          PIC X(09) VALUE SPACES.        
               10 FILLER                 PIC X(01) VALUE '.'.           
               10 MTHLY-AMT-FIX-DEC      PIC X(02) VALUE SPACES.        
LMSCHG     05  WS-ACCT-NUM               PIC S9(13)V USAGE COMP-3       
                                                        VALUE 0.        
T19443     05  WS-811                    PIC S9(9) VALUE -811 COMP.     
           05  WS-USAGE-FIXED            PIC X(09).                     
           05  WS-USAGE-FIXED-DEC  REDEFINES WS-USAGE-FIXED             
                                         PIC ZZZZZZZZ9.                 
           05  WS-USAGE-FIXED-OLD        PIC S9(09)V USAGE COMP-3       
                                                   VALUE 0.             
           05  WS-CODE-PLAN-STATUS-OLD   PIC X(01).                     
           05  WS-CODE-STAT-REASON-OLD   PIC X(01).                     
           05  WS-USER-ID                PIC X(07) VALUE SPACES.        
           05  WS-UM-EQUIP-SHRT-DESC     PIC X(17) VALUE SPACES.        
           05  WS-RESP-AREA-ID           PIC X(03) VALUE SPACES.        
           05  WS-TRAN-APPL-NO           PIC S9(04) COMP VALUE ZERO.    
           05  WS-PARM-COMMENT-LEN       PIC X(04) VALUE SPACES.        
           05  WS-TEMP-RATE-ITEM-CODE    PIC S9(4) USAGE COMP VALUE 0.  
           05  WS-INSERT-MODE            PIC X(01) VALUE 'N'.           
PCR618     05  WS-OLD-RT-ITEM-CD         PIC S9(4) COMP VALUE 0.        
PCR618     05  WS-ITEM-SEQ-NO            PIC S9(4) COMP VALUE 0.        
PCR618     05  WS-REMOVE-DATE-OLD        PIC X(10).                     
A05065     05  WS-CODE-SERVICE-TYPE      PIC X(01) VALUE SPACES.        
           05  WS-GTT-NAME               PIC X(19)  VALUE SPACES.       
           05  WS-APPL-RETURN-CODE       PIC S9(04) COMP VALUE 0.       
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-ACTIVE                 PIC X(1) VALUE 'A'.            
PCR618     05  WS-INACTIVE               PIC X(1) VALUE 'I'.            
PCR618     05  WS-UNMETERED              PIC X(1) VALUE 'U'.            
PCR618     05  WS-ELECTRIC               PIC X(1) VALUE 'E'.            
PCR618     05  WS-GAS                    PIC X(1) VALUE 'G'.            
           05  WS-FAILED                 PIC X(1) VALUE 'F'.            
                                                                        
A05065 01  WS-TRAN-HIST-DESC.                                           
A05065     05  WS-UTILITY                PIC X(10) VALUE SPACES.        
A05065     05  WS-IC-NO                  PIC X(04) VALUE SPACES.        
A05065                                                                  
                                                                        
A05065 01  WS-RATE-ITEM-CD-DESC.                                        
A05065     05  WS-RATE-ITM-CODE          PIC X(04) VALUE SPACES.        
A05065     05  FILLER                    PIC X(03) VALUE ' - '.         
A05065     05  WS-RATE-ITM-DESC          PIC X(17) VALUE SPACES.        
A05065                                                                  
       01  WS-NULL-INDICATORS.                                          
           05  WS-OLD-NULL-IND-1         PIC S9(4) COMP VALUE 0.        
           05  WS-OLD-NULL-IND-2         PIC S9(4) COMP VALUE 0.        
PCR618     05  WS-OLD-NULL-IND-3         PIC S9(4) COMP VALUE 0.        
           05  WS-NULL-IND-1             PIC S9(4) COMP VALUE 0.        
           05  WS-NULL-IND-2             PIC S9(4) COMP VALUE 0.        
PCR618     05  WS-NULL-IND-3             PIC S9(4) COMP VALUE 0.        
           05  WS-NULL-RATE-ITEM-CODE    PIC S9(4) COMP VALUE 0.        
           05  WS-NULL-VERSION-NO-CNTRL  PIC S9(4) COMP VALUE 0.        
PCR618     05  WS-NULL-ITEM-SEQ-NO       PIC S9(4) COMP VALUE 0.        
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
           05  GWL-STATUS-SUBCODE        PIC S9(9) COMP.                
                                                                        
       01  FILLER                        PIC X(11) VALUE 'PARM FIELDS'. 
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-ACTION-IND           PIC X(01).                     
           05  PARM-ACCOUNT-NO           PIC X(13).                     
           05  PARM-CODE-UTIL-TYPE       PIC X(01).                     
           05  PARM-IC-NO                PIC S9(4) COMP.                
           05  PARM-RATE-ITEM-CODE       PIC S9(4) COMP.                
           05  PARM-ITEM-SEQ-NO          PIC S9(4) COMP.                
P00496     05  PARM-NO-UNITS             PIC S9(9) USAGE COMP.          
           05  PARM-DATE-PLAN-START      PIC X(10).                     
           05  PARM-DIST-NO              PIC X(03).                     
           05  PARM-POLE-NO              PIC X(07).                     
           05  PARM-LAST-BILL-DATE       PIC X(10).                     
           05  PARM-LIGHT-NO             PIC X(04).                     
COB305     05 PARM-MTHLY-AMOUNT-FIXED        PIC S9(9)V9(2) 
COB305       USAGE COMP-3 VALUE 0.   
COB305     05 PARM-USAGE-FIXED        PIC S9(9)V USAGE COMP-3 VALUE 0.   
           05  PARM-CODE-PLAN-STATUS     PIC X(01).                     
           05  PARM-CODE-STAT-REASON     PIC X(01).                     
           05  PARM-CODE-SERVICE-TYPE    PIC X(01).                     
           05  PARM-USER-ID              PIC X(07).                     
           05  PARM-COMMENT-TEXT         PIC X(210).                    
           05  PARM-COMMENT-LEN          PIC X(04).                     
PCR618     05  PARM-OLD-RATE-ITEM-CODE   PIC S9(4) COMP.                
PCR618     05  PARM-REMOVE-DATE          PIC X(10).                     
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                  PIC S9(9) COMP.                
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                  PIC S9(9) COMP VALUE 0.        
LMCHG      05  CTR-ROWS-RS1              PIC S9(9) COMP VALUE 0.        
PCR618     05  WS-ACTIVE-COUNT           PIC S9(9) COMP VALUE 0.        
                                                                        
       01  WORK-FIELDS.                                                 
           05  WRK-DONE-STATUS           PIC S9(9) COMP.                
                                                                        
       01  WS-ERR-FLAGS.                                                
           05  WS-ERR-INSRT-R1           PIC X(01) VALUE 'N'.           
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
REARCH 01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE             PIC S9(9) COMP VALUE 0.       
           05  RS-RATE-ITEM-CODE          PIC S9(4) USAGE COMP VALUE 0. 
PCR618     05  RS-ITEM-SEQ-NO             PIC S9(4) USAGE COMP VALUE 0. 
T19120     05  RS-ACCOUNT-NO              PIC X(13).                    
                                                                        
      *********************************************************         03190101
      *   GTT TABLE LAYOUT FOR UNMETERED LIGHTS               *         03190201
      *********************************************************         03190301
          05 S-RETURN-CODE                  PIC S9(04) COMP VALUE 0.    
          05 GTT-RETURN-FIELDS-1.                                       
             10 S-RETURN-CODE-1             PIC S9(04) COMP VALUE 0.    
             10 S-APPL-RETURN-CODE-1        PIC S9(04) COMP VALUE 0.    
             10 S-RS1-RATE-ITEM-CODE        PIC S9(04) USAGE COMP       
                                                            VALUE 0.    
             10 S-RS1-ITEM-SEQ-NO           PIC S9(04) USAGE COMP       
                                                            VALUE 0.    
             10 S-RS1-ACCOUNT-NO            PIC S9(13)V USAGE COMP-3    
                                                            VALUE 0.    
             10 S-RS1-BUS-RULE-ID           PIC X(10)  VALUE SPACES.    
             10 S-RS1-BUS-RULE-RESULT-CD    PIC X(10)  VALUE SPACES.    
             10 S-RS1-BUS-RULE-XREF-ID      PIC X(26)  VALUE SPACES.    
CVT999******************************************************************03310000
CVT999*    CURSOR DECLARATIONS                                         *03320000
CVT999******************************************************************03330000
           EXEC SQL DECLARE OLD-CUST-CURSOR CURSOR FOR                  
               SELECT NO_UNITS,                                         
                      DATE_PLAN_START,                                  
                      LAST_BILL_DATE,                                   
                      MTHLY_AMOUNT_FIXED,                               
                      USAGE_FIXED,                                      
                      CODE_PLAN_STATUS,                                 
                      CODE_STAT_REASON,                                 
PCR618                REMOVE_DATE,                                      
A05064                CODE_SERVICE_TYPE                                 
                 FROM CSS_CUST_PLAN WITH(READUNCOMMITTED)                       
                WHERE ACCOUNT_NO     = :CP-ACCOUNT-NO                   
                  AND CODE_UTIL_TYPE = :CP-CODE-UTIL-TYPE               
                  AND IC_NO          = :CP-IC-NO                        
PCR618            AND RATE_ITEM_CODE = :WS-OLD-RT-ITEM-CD               
PCR618*           AND RATE_ITEM_CODE = :CP-RATE-ITEM-CODE               03510000
                  AND ITEM_SEQ_NO    = :CP-ITEM-SEQ-NO                  
T35434            FOR READ ONLY                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE OLD-CUST-CURSOR CURSOR FOR                  03340000
MFA-TR*        SELECT NO_UNITS,                                         03350000
MFA-TR*               DATE_PLAN_START,                                  03360001
MFA-TR*               LAST_BILL_DATE,                                   03390001
MFA-TR*               MTHLY_AMOUNT_FIXED,                               03410000
MFA-TR*               USAGE_FIXED,                                      03420000
MFA-TR*               CODE_PLAN_STATUS,                                 03430000
MFA-TR*               CODE_STAT_REASON,                                 03440000
MFA-TR*               REMOVE_DATE,                                      03450001
MFA-TR*               CODE_SERVICE_TYPE                                 03450001
MFA-TR*          FROM CSS_CUST_PLAN                                     03460000
MFA-TR*         WHERE ACCOUNT_NO     = :CP-ACCOUNT-NO                   03470000
MFA-TR*           AND CODE_UTIL_TYPE = :CP-CODE-UTIL-TYPE               03480000
MFA-TR*           AND IC_NO          = :CP-IC-NO                        03490000
MFA-TR*           AND RATE_ITEM_CODE = :WS-OLD-RT-ITEM-CD               03500000
MFA-TR*           AND RATE_ITEM_CODE = :CP-RATE-ITEM-CODE               03510000
MFA-TR*           AND ITEM_SEQ_NO    = :CP-ITEM-SEQ-NO                  03520000
MFA-TR*           FOR FETCH ONLY WITH UR                                03521000
MFA-TR*    END-EXEC.                                                    03530000
T19120******************************************************************03540000
ST    *    CURSOR DECLARATIONS                                         *03550000
      ******************************************************************03560000
           EXEC SQL DECLARE CHECK-STAT-CURSOR CURSOR FOR                
               SELECT ACCOUNT_NO                                        
               FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                           
               WHERE PREMISE_NO       = :AT-PREMISE-NO                  
                  AND CREDIT_GROUP    <>   'D'                          
                  AND CODE_ACCT_STAT  =    'A'                          
T22433            AND ACCOUNT_NO      <> :AT-ACCOUNT-NO                 
T35434         FOR READ ONLY                                    
T19120     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE CHECK-STAT-CURSOR CURSOR FOR                03570000
MFA-TR*        SELECT ACCOUNT_NO                                        03580000
MFA-TR*        FROM CSS_ACCOUNT                                         03590000
MFA-TR*        WHERE PREMISE_NO       = :AT-PREMISE-NO                  03600000
MFA-TR*           AND CREDIT_GROUP    <>   'D'                          03610000
MFA-TR*           AND CODE_ACCT_STAT  =    'A'                          03620000
MFA-TR*           AND ACCOUNT_NO      <> :AT-ACCOUNT-NO                 03630000
MFA-TR*        FOR FETCH ONLY WITH UR                                   03631000
MFA-TR*    END-EXEC.                                                    03640000
                                                                        
                                                                        
CVT000     EXEC SQL                                                     03670000
CVT000         INCLUDE CWSX0010                                         03680000
CVT000     END-EXEC.                                                    03690000
CVT000                                                                  
CVT000 01  CSRERLOG-P.                                                  
CVT000     10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
CVT000     10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
CVT000     10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
CVT000     10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
CVT000     10  S-HOST-VARIABLES.                                        
CVT000         49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
CVT000         49  S-HOST-VARIABLES-V    PIC X(255).                    
CVT000     10  S-SQL-STATEMENT.                                         
CVT000         49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-STATEMENT-V     PIC X(255).                    
CVT000     10  S-SQL-DESCRIPTION.                                       
CVT000         49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-DESCRIPTION-V   PIC X(255).                    
CVT000     10  WS-ABEND-SQLERRMC.                                       
CVT000         49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
CVT000         49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
CVT000     10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
CVT000                                                                  
CVT000                                                                  
CVT000                                                                  
CVT000 LINKAGE SECTION.                                                 
CVT000 01  LINK-ACTION-IND          PIC X(01).                          
COB305 01 LINK-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.           
CVT000 01  LINK-CODE-UTIL-TYPE      PIC X(01).                          
CVT000 01  LINK-IC-NO               PIC S9(4) COMP.                     
CVT000 01  LINK-RATE-ITEM-CODE      PIC S9(4) COMP.                     
CVT000 01  LINK-ITEM-SEQ-NO         PIC S9(4) COMP.                     
P00496 01  LINK-NO-UNITS            PIC S9(09) USAGE COMP.              
CVT000 01  LINK-DATE-PLAN-START     PIC X(10).                          
CVT000 01  LINK-LAST-BILL-DATE      PIC X(10).                          
COB305 01 LINK-MTHLY-AMOUNT-FIXED        PIC S9(9)V9(2) USAGE COMP-3 
COB305       VALUE 0.        
COB305 01 LINK-USAGE-FIXED        PIC S9(09)V USAGE COMP-3 VALUE 0.        
CVT000 01  LINK-CODE-PLAN-STATUS    PIC X(01).                          
CVT000 01  LINK-CODE-STAT-REASON    PIC X(01).                          
CVT000 01  LINK-USER-ID             PIC X(07).                          
CVT000 01  LINK-COMMENT-TEXT        PIC X(210).                         
CVT000 01  LINK-COMMENT-LEN         PIC S9(4) COMP.                     
CVT000 01  LINK-OLD-RATE-ITEM-CODE  PIC S9(4) COMP.                     
CVT000 01  LINK-REMOVE-DATE         PIC X(10).                          
                                                                        
CVT000 PROCEDURE DIVISION USING                                         
CVT000          LINK-ACTION-IND                                         
CVT000         ,LINK-ACCOUNT-NO                                         
CVT000         ,LINK-CODE-UTIL-TYPE                                     
CVT000         ,LINK-IC-NO                                              
CVT000         ,LINK-RATE-ITEM-CODE                                     
CVT000         ,LINK-ITEM-SEQ-NO                                        
CVT000         ,LINK-NO-UNITS                                           
CVT000         ,LINK-DATE-PLAN-START                                    
CVT000         ,LINK-LAST-BILL-DATE                                     
CVT000         ,LINK-MTHLY-AMOUNT-FIXED                                 
CVT000         ,LINK-USAGE-FIXED                                        
CVT000         ,LINK-CODE-PLAN-STATUS                                   
CVT000         ,LINK-CODE-STAT-REASON                                   
CVT000         ,LINK-USER-ID                                            
CVT000         ,LINK-COMMENT-TEXT                                       
CVT000         ,LINK-COMMENT-LEN                                        
CVT000         ,LINK-OLD-RATE-ITEM-CODE                                 
CVT000         ,LINK-REMOVE-DATE                                        
CVT000         .                                                        
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLWARNING                                      
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLERROR                                        
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER NOT FOUND                                       
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
                                                                        
                                                                        
      ******************************************************************04560000
      * 0000-MAINLINE                                                  *04570000
      *     CALLS 0100-INITIALIZE                                      *04580000
      *           1000-PROCESS-INPUT                                   *04590000
      *           2000-PROCESS-OUTPUT                                  *04600000
      *           9999-END-PROGRAM                                     *04610000
      *                                                                *04620000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *04630000
      ******************************************************************04640000
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************04760000
      * 0100-INITIALIZE                                                *04770000
      *     CALLS 9000-SEND-ERROR-RESULT                               *04780000
      *           9900-SQL-ERROR-ROUTINE                               *04790000
      *                                                                *04800000
      *     CALLED FROM 0000-MAINLINE                                  *04810000
      *                                                                *04820000
      *     1. RESET DB2 ERROR HANDLERS                                *04830000
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *04840000
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *04850000
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*04860000
      *                                                                *04870000
      ******************************************************************04880000
       0100-INITIALIZE.                                                 
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1        THRU 0100A-EXIT        . 
                                                                        
           MOVE LINK-ACTION-IND           TO PARM-ACTION-IND          . 
CVT000     MOVE LINK-ACCOUNT-NO           TO PARM-ACCOUNT-NO          . 
CVT000     MOVE LINK-CODE-UTIL-TYPE       TO PARM-CODE-UTIL-TYPE      . 
CVT000     MOVE LINK-IC-NO                TO PARM-IC-NO               . 
CVT000     MOVE LINK-RATE-ITEM-CODE       TO PARM-RATE-ITEM-CODE      . 
CVT000     MOVE LINK-ITEM-SEQ-NO          TO PARM-ITEM-SEQ-NO         . 
CVT000     MOVE LINK-NO-UNITS             TO PARM-NO-UNITS            . 
CVT000     MOVE LINK-DATE-PLAN-START      TO PARM-DATE-PLAN-START     . 
CVT000     MOVE LINK-LAST-BILL-DATE       TO PARM-LAST-BILL-DATE      . 
CVT000     MOVE LINK-MTHLY-AMOUNT-FIXED   TO PARM-MTHLY-AMOUNT-FIXED  . 
CVT000     MOVE LINK-USAGE-FIXED          TO PARM-USAGE-FIXED         . 
CVT000     MOVE LINK-CODE-PLAN-STATUS     TO PARM-CODE-PLAN-STATUS    . 
CVT000     MOVE LINK-CODE-STAT-REASON     TO PARM-CODE-STAT-REASON    . 
CVT000     MOVE LINK-USER-ID              TO PARM-USER-ID             . 
CVT000     MOVE LINK-COMMENT-TEXT         TO PARM-COMMENT-TEXT        . 
CVT000     MOVE LINK-COMMENT-LEN          TO PARM-COMMENT-LEN         . 
CVT000     MOVE LINK-OLD-RATE-ITEM-CODE   TO PARM-OLD-RATE-ITEM-CODE  . 
CVT000     MOVE LINK-REMOVE-DATE          TO PARM-REMOVE-DATE         . 
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05451000
      *                                                                *05452000
      * 0100A-DECLARE-GTT-R1.                                          *05453000
      ******************************************************************05454000
       0100A-DECLARE-GTT-R1.                                            
                                                                        
           MOVE 'SESSION.CSR04650_R1'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04650_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04650_R1
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,RATE_ITEM_CODE          SMALLINT                    
                   ,ITEM_SEQ_NO             SMALLINT                    
                   ,ACCOUNT_NO              DECIMAL(13)                 
                   ,BUS_RULE_ID CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BUS_RULE_RESULT_CD CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BUS_RULE_XREF_ID CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS    THRU 8000A-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100A'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,RATE_ITEM_CODE              AS RATE_ITEM_CODE    
                      ,ITEM_SEQ_NO                 AS ITEM_SEQ_NO       
                      ,ACCOUNT_NO                  AS ACCOUNT_NO        
                      ,LTRIM(RTRIM(BUS_RULE_ID))          AS BUS_RULE_ID       
                      ,LTRIM(RTRIM(BUS_RULE_RESULT_CD))   AS 
           BUS_RULE_RESULT_CD
                      ,LTRIM(RTRIM(BUS_RULE_XREF_ID))     AS 
           BUS_RULE_XREF_ID  
                  FROM #CSR04650_R1                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     05462800
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                            05462900
MFA-TR*                          WITH ROWSET POSITIONING FOR            05463000
MFA-TR*         SELECT RETURN_CODE                                      05463100
MFA-TR*               ,APPL_RETURN_CODE                                 05463200
MFA-TR*               ,RATE_ITEM_CODE              AS RATE_ITEM_CODE    05463300
MFA-TR*               ,ITEM_SEQ_NO                 AS ITEM_SEQ_NO       05463400
MFA-TR*               ,ACCOUNT_NO                  AS ACCOUNT_NO        05463500
MFA-TR*               ,STRIP(BUS_RULE_ID)          AS BUS_RULE_ID       05463600
MFA-TR*               ,STRIP(BUS_RULE_RESULT_CD)   AS BUS_RULE_RESULT_CD05463700
MFA-TR*               ,STRIP(BUS_RULE_XREF_ID)     AS BUS_RULE_XREF_ID  05463800
MFA-TR*           FROM SESSION.CSR04650_R1                              05463900
MFA-TR*    END-EXEC.                                                    05464000
                                                                        
       0100A-EXIT.                                                      
            EXIT.                                                       
                                                                        
                                                                        
      ******************************************************************05470000
      * 1000-PROCESS-INPUT                                             *05480000
      *     CALLS 1100-RECEIVE-PARMS                                   *05490000
      *                                                                *05500000
      *     CALLED FROM 0000-MAINLINE                                  *05510000
      *                                                                *05520000
      *     1. RECEIVE PARMS.                                          *05530000
      ******************************************************************05540000
       1000-PROCESS-INPUT.                                              
                                                                        
                                                                        
           MOVE PARM-ACTION-IND             TO  WS-ACTION-IND.          
                                                                        
           MOVE PARM-ACCOUNT-NO             TO  CP-ACCOUNT-NO           
                                                AT-ACCOUNT-NO           
                                                UT-ACCOUNT-NO.          
                                                                        
           MOVE PARM-CODE-UTIL-TYPE         TO CP-CODE-UTIL-TYPE        
A05065                                         UP-CODE-UTIL-TYPE        
BILGEN                                         UT-CODE-UTIL-TYPE.       
                                                                        
           MOVE PARM-IC-NO                  TO CP-IC-NO                 
BILGEN                                         UT-IC-NO.                
           MOVE PARM-RATE-ITEM-CODE         TO CP-RATE-ITEM-CODE        
                                               UP-RATE-ITEM-CODE.       
           MOVE PARM-ITEM-SEQ-NO            TO CP-ITEM-SEQ-NO.          
                                                                        
P00496     MOVE PARM-NO-UNITS               TO CP-NO-UNITS              
                                                                        
           IF (PARM-DATE-PLAN-START = SPACES) OR                        
              (PARM-DATE-PLAN-START < SPACES)                           
              MOVE -1                       TO WS-NULL-IND-1            
           ELSE                                                         
              IF PARM-DATE-PLAN-START > SPACES                          
                 MOVE PARM-DATE-PLAN-START  TO CP-DATE-PLAN-START       
              END-IF                                                    
           END-IF.                                                      
                                                                        
                                                                        
           IF (PARM-LAST-BILL-DATE = SPACES) OR                         
              (PARM-LAST-BILL-DATE < SPACES)                            
              MOVE -1                       TO WS-NULL-IND-2            
           ELSE                                                         
              IF PARM-LAST-BILL-DATE > SPACES                           
                 MOVE PARM-LAST-BILL-DATE   TO CP-LAST-BILL-DATE        
              END-IF                                                    
           END-IF.                                                      
                                                                        
           MOVE PARM-MTHLY-AMOUNT-FIXED     TO  CP-MTHLY-AMOUNT-FIXED.  
           MOVE PARM-USAGE-FIXED            TO  CP-USAGE-FIXED.         
           MOVE PARM-CODE-PLAN-STATUS       TO  CP-CODE-PLAN-STATUS.    
           MOVE PARM-CODE-STAT-REASON       TO  CP-CODE-STAT-REASON.    
           MOVE PARM-USER-ID                TO  WS-USER-ID              
                                                PF-USER-ID.             
                                                                        
PCR618     MOVE PARM-OLD-RATE-ITEM-CODE     TO  WS-OLD-RT-ITEM-CD.      
                                                                        
           MOVE PARM-COMMENT-LEN            TO  WS-PARM-COMMENT-LEN.    
                                                                        
PCR618     IF (PARM-REMOVE-DATE = SPACES) OR                            
PCR618        (PARM-REMOVE-DATE < SPACES)                               
PCR618        MOVE -1                       TO WS-NULL-IND-3            
PCR618     ELSE                                                         
PCR618        IF PARM-REMOVE-DATE > SPACES                              
PCR618           MOVE PARM-REMOVE-DATE      TO CP-REMOVE-DATE           
PCR618        END-IF                                                    
PCR618     END-IF.                                                      
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08630000
      *                                                                *08631001
      * 2000-PROCESS-OUTPUT.                                           *08640000
      *     CALLS 5000-UPDATE                                          *08660000
      *           8100-SEND-RESULT                                     *08670000
      *                                                                *08680000
      *      CALLED FROM 0000-MAINLINE                                 *08690000
      *                                                                *08700000
      *     1. UPDATE DB2 DATA                                         *08720000
      *     2. SEND RESULT SET                                         *08730000
      ******************************************************************08740000
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
A05065     PERFORM 7050-GET-AT-INFO           THRU 7050-EXIT.           
A05065     PERFORM 7000-GET-RATE-PLAN-NO      THRU 7000-EXIT.           
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE L9-UM-EQUIP-SHRT-DESC       TO WS-UM-EQUIP-SHRT-DESC 
           ELSE                                                         
              MOVE SPACES                      TO WS-UM-EQUIP-SHRT-DESC 
           END-IF.                                                      
                                                                        
                                                                        
           EVALUATE TRUE                                                
               WHEN WS-UPDATE                                           
                    PERFORM 5000-UPDATE           THRU 5000-EXIT        
               WHEN WS-INSERT                                           
                    PERFORM 5001-INSERT           THRU 5001-EXIT        
               WHEN WS-DELETE                                           
                    PERFORM 5002-DELETE           THRU 5002-EXIT        
           END-EVALUATE.                                                
                                                                        
REARCH     PERFORM 2000A-MOVE-RESULT-RS1          THRU 2000A-EXIT.      
           PERFORM 8010-INSERT-GTT-R1             THRU 8010-EXIT.       
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08831000
      * 2000A-MOVE-RESULT-RS1                                           08832001
      ******************************************************************08833000
       2000A-MOVE-RESULT-RS1.                                           
      *                                                                 08835000
           MOVE CP-RATE-ITEM-CODE  TO S-RS1-RATE-ITEM-CODE.             
           MOVE CP-ITEM-SEQ-NO     TO S-RS1-ITEM-SEQ-NO.                
      *                                                                 08839300
       2000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
A05065******************************************************************08840100
A05065* 2100-GET-PLAN-STAT-DESC                                         08840200
A05065******************************************************************08840300
A05065 2100-GET-PLAN-STAT-DESC.                                         
A05065*                                                                 08840500
A05065     INITIALIZE UV-CODE-LONG-DESC-TEXT.                           
A05065     MOVE +01                         TO UV-CODE-VALUE-LEN.       
A05065     MOVE +16                         TO UV-COLUMN-NA-LEN.        
A05065     MOVE 'CODE_PLAN_STATUS'          TO UV-COLUMN-NA-TEXT.       
A05065     MOVE +13                         TO UV-TABLE-NA-LEN.         
A05065     MOVE 'CSS_CUST_PLAN'             TO UV-TABLE-NA-TEXT.        
A05065     MOVE 'ALL'                       TO UV-PROGRAM-ID.           
A05065     MOVE '01'                        TO UV-COMPANY-NO.           
A05065     PERFORM 7170-GET-CODE-VALUE            THRU 7170-EXIT.       
A05065*                                                                 08840800
A05065 2100-EXIT.                                                       
A05065     EXIT.                                                        
A05065                                                                  
A05065******************************************************************08841200
A05065* 2200-GET-STAT-RSN-DESC                                          08841300
A05065******************************************************************08841400
A05065 2200-GET-STAT-RSN-DESC.                                          
A05065*                                                                 08841600
A05065     INITIALIZE UV-CODE-LONG-DESC-TEXT.                           
A05065     MOVE +01                         TO UV-CODE-VALUE-LEN.       
A05065     MOVE +16                         TO UV-COLUMN-NA-LEN.        
A05065     MOVE 'CODE_STAT_REASON'          TO UV-COLUMN-NA-TEXT.       
A05065     MOVE +13                         TO UV-TABLE-NA-LEN.         
A05065     MOVE 'CSS_CUST_PLAN'             TO UV-TABLE-NA-TEXT.        
A05065     MOVE 'ALL'                       TO UV-PROGRAM-ID.           
A05065     MOVE '01'                        TO UV-COMPANY-NO.           
A05065     PERFORM 7170-GET-CODE-VALUE            THRU 7170-EXIT.       
A05065     MOVE +30                         TO MI-CHG-COLUMN-VALUE-LEN  
A05065                                         MI-CHG-COLUMN-VALUE-LEN. 
A05065*                                                                 08841693
A05065 2200-EXIT.                                                       
A05065     EXIT.                                                        
A05065                                                                  
      ******************************************************************09850000
      * 5000-UPDATE                                                    *09860000
      *     CALLS 8105-UPDATE-CUST-PLAN                                *09870000
      *           8200-DELETE-BILLING-DET                              *09880000
      *                                                                *09890000
      *     CALLED FROM 2000-PROCESS-OUTPUT                            *09900000
      *                                                                *09910000
      ******************************************************************09920000
       5000-UPDATE.                                                     
      *                                                                 09940003
           PERFORM 7710-OPEN-OLD-CUST-CURSOR  THRU 7710-EXIT            
           PERFORM 7700-FETCH-OLD-CUST-CURSOR THRU 7700-EXIT            
           PERFORM 7720-CLOSE-OLD-CUST-CURSOR THRU 7720-EXIT            
PCR618     PERFORM 8103-DELETE-CUST-PLAN      THRU 8103-EXIT            
PCR618     PERFORM 7028-GET-MAX-SEQ-NO        THRU 7028-EXIT            
A00302     IF  CP-REMOVE-DATE <= CP-LAST-BILL-DATE                      
A00302     AND CP-REMOVE-DATE > SPACES                                  
A00302     AND CP-LAST-BILL-DATE > SPACES                               
              MOVE 'N'                        TO WS-ROW-EXIST           
              PERFORM 8110-ROWS-EXIST-FOR-GIVEN-IC                      
                                              THRU 8110-EXIT            
              IF WS-ROW-EXIST = 'N'                                     
                 MOVE CP-ACCOUNT-NO           TO BG-ACCOUNT-NO          
                 MOVE CP-CODE-UTIL-TYPE       TO BG-CODE-UTIL-TYPE      
                 MOVE CP-IC-NO                TO BG-IC-NO               
                 PERFORM 8200-DELETE-BILLING-DET                        
                                              THRU 8200-EXIT            
              END-IF                                                    
           END-IF                                                       
A00302                                                                  
ACT052     MOVE RD-CODE-SERVICE-TYPE          TO CP-CODE-SERVICE-TYPE   
PCR618     PERFORM 7030-INSERT-CUST-PLAN      THRU 7030-EXIT            
PCR618     PERFORM 7130-CHECK-PREM-IND        THRU 7130-EXIT            
                                                                        
                                                                        
           MOVE CP-RATE-ITEM-CODE           TO S-RS1-RATE-ITEM-CODE     
           MOVE CP-ITEM-SEQ-NO              TO S-RS1-ITEM-SEQ-NO        
                                                                        
           PERFORM 5400-JRNL-TRAN-HEAD        THRU 5400-EXIT.           
           PERFORM 5500-JRNL-UPDATE           THRU 5500-EXIT.           
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************10270500
      * 5001-INSERT                                                    *10270600
      *     CALLS 7030-INSERT-CUST-PLAN                                *10270700
      *                                                                *10270900
      *     CALLED FROM 2000-PROCESS-OUTPUT                            *10271000
      *                                                                *10271100
      ******************************************************************10271200
       5001-INSERT.                                                     
                                                                        
                                                                        
           MOVE 'Y'                           TO WS-INSERT-MODE         
                                                                        
A05065     MOVE RD-CODE-SERVICE-TYPE          TO CP-CODE-SERVICE-TYPE   
                                                                        
           PERFORM 7010-GET-MAX-VERSION       THRU 7010-EXIT            
PCR618     PERFORM 7028-GET-MAX-SEQ-NO        THRU 7028-EXIT            
PCR618     PERFORM 7130-CHECK-PREM-IND        THRU 7130-EXIT            
                                                                        
           IF AT-CODE-ACCT-STAT = 'P'                                   
              PERFORM 7055-PROCESS-PEND-ACCT  THRU 7055-EXIT            
           END-IF                                                       
                                                                        
           PERFORM 7030-INSERT-CUST-PLAN      THRU 7030-EXIT            
                                                                        
                                                                        
PCR618     MOVE CP-RATE-ITEM-CODE           TO S-RS1-RATE-ITEM-CODE     
PCR618     MOVE CP-ITEM-SEQ-NO              TO S-RS1-ITEM-SEQ-NO        
                                                                        
LMSCHG     PERFORM 5400-JRNL-TRAN-HEAD            THRU 5400-EXIT.       
           PERFORM 5500-JRNL-UPDATE              THRU 5500-EXIT.        
                                                                        
       5001-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************10601003
      * 5002-DELETE                                                    *10602003
      *     CALLS 8103-DELETE-CUST-PLAN                                *10603003
      *           8200-DELETE-BILLING-DET                              *10604003
      *                                                                *10605003
      *     CALLED FROM 2000-PROCESS-OUTPUT                            *10606003
      *                                                                *10607003
      ******************************************************************10608003
       5002-DELETE.                                                     
                                                                        
           IF  CP-REMOVE-DATE <= CP-LAST-BILL-DATE                      
           AND CP-REMOVE-DATE > SPACES                                  
           AND CP-LAST-BILL-DATE > SPACES                               
              MOVE 'N'                      TO WS-ROW-EXIST             
              PERFORM 8110-ROWS-EXIST-FOR-GIVEN-IC                      
                                                  THRU 8110-EXIT        
              IF WS-ROW-EXIST = 'N'                                     
                 MOVE CP-ACCOUNT-NO         TO BG-ACCOUNT-NO            
                 MOVE CP-CODE-UTIL-TYPE     TO BG-CODE-UTIL-TYPE        
                 MOVE CP-IC-NO              TO BG-IC-NO                 
                 PERFORM 8200-DELETE-BILLING-DET                        
                                                  THRU 8200-EXIT        
              END-IF                                                    
           END-IF.                                                      
                                                                        
           PERFORM 7130-CHECK-PREM-IND            THRU 7130-EXIT.       
                                                                        
           MOVE CP-RATE-ITEM-CODE           TO WS-OLD-RT-ITEM-CD.       
                                                                        
           PERFORM 7710-OPEN-OLD-CUST-CURSOR      THRU 7710-EXIT.       
           PERFORM 7700-FETCH-OLD-CUST-CURSOR     THRU 7700-EXIT.       
           PERFORM 7720-CLOSE-OLD-CUST-CURSOR     THRU 7720-EXIT.       
                                                                        
A05065     MOVE WS-CODE-SERVICE-TYPE          TO CP-CODE-SERVICE-TYPE   
                                                                        
           PERFORM 8103-DELETE-CUST-PLAN          THRU 8103-EXIT.       
                                                                        
           MOVE CP-RATE-ITEM-CODE           TO S-RS1-RATE-ITEM-CODE.    
           MOVE CP-ITEM-SEQ-NO              TO S-RS1-ITEM-SEQ-NO.       
                                                                        
           PERFORM 5400-JRNL-TRAN-HEAD            THRU 5400-EXIT.       
           PERFORM 5600-DEL-JRNL-UPDATE           THRU 5600-EXIT.       
                                                                        
       5002-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************10620000
      *   5400-JRNL-TRAN-HEAD.                                         *10630000
      *                                                                *10640000
      *   1.   MOVE FIELDS TO THE MAINTENANCE TRANSACTION HEADER.      *10650000
      *        THE FIRST TIME THE TRANSACTION DETAILS ROW IS WRITTEN,  *10660000
      *        THIS ROW WILL ALSO BE WRITTEN (SEE CPD00067).           *10670000
      ******************************************************************10680000
       5400-JRNL-TRAN-HEAD.                                             
                                                                        
           PERFORM 7800-SELECT-TIMESTAMP          THRU 7800-EXIT.       
           PERFORM 7801-SELECT-DATE               THRU 7801-EXIT.       
           PERFORM 7802-SELECT-RESP-AREA          THRU 7802-EXIT.       
                                                                        
A05065     MOVE +01                         TO UV-CODE-VALUE-LEN.       
A05065     MOVE PARM-CODE-UTIL-TYPE         TO UV-CODE-VALUE-TEXT.      
A05065     MOVE +14                         TO UV-COLUMN-NA-LEN.        
A05065     MOVE 'CODE_UTIL_TYPE'            TO UV-COLUMN-NA-TEXT.       
A05065     MOVE +18                         TO UV-TABLE-NA-LEN.         
A05065     MOVE 'CSS_RATE_PLAN_DESC'        TO UV-TABLE-NA-TEXT.        
A05065     MOVE 'ALL'                       TO UV-PROGRAM-ID.           
A05065     MOVE AT-COMPANY-NO               TO UV-COMPANY-NO.           
A05065     INITIALIZE UV-CODE-LONG-DESC.                                
A05065     PERFORM 7170-GET-CODE-VALUE            THRU 7170-EXIT.       
A05065                                                                  
A05065     EVALUATE PARM-CODE-UTIL-TYPE                                 
A05065         WHEN 'E'                                                 
A05065              MOVE +8                 TO WS-LEN                   
A05065         WHEN 'G'                                                 
A05065              MOVE +3                 TO WS-LEN                   
A05065         WHEN 'U'                                                 
A05065              MOVE +9                 TO WS-LEN                   
A05065     END-EVALUATE.                                                
A05065                                                                  
A05065     MOVE UV-CODE-LONG-DESC-TEXT(1:WS-LEN)                        
A05065                                      TO WS-UTILITY.              
A05065     MOVE PARM-IC-NO                  TO WS-IC-NO.                
A05065     MOVE LINK-COMMENT-LEN            TO MH-TRAN-COMMENT-LEN.     
A05065     MOVE LINK-COMMENT-TEXT           TO MH-TRAN-COMMENT-TEXT.    
                                                                        
           MOVE 1                           TO WS-TRAN-APPL-NO          
                                               MI-TRAN-APPL-NO.         
                                                                        
           MOVE 'F'                         TO MH-CODE-TRAN-TYPE.       
           MOVE WS-RESP-AREA-ID             TO MH-RESP-AREA-ID.         
           MOVE CP-ACCOUNT-NO               TO MH-ACCOUNT-NO.           
           MOVE 0                           TO MH-CUSTOMER-NO.          
           MOVE 0                           TO MH-PREMISE-NO.           
           MOVE WS-USER-ID                  TO MH-USER-ID.              
           MOVE 'CSR04650'                  TO MH-APPL-PROGRAM-ID.      
                                                                        
       5400-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************10920000
      *   5500-JRNL-UPDATE.                                            *10930000
      *                                                                *10940000
      ******************************************************************10950000
       5500-JRNL-UPDATE.                                                
                                                                        
A05065     PERFORM 5502-JRNL-IC-UTILITY         THRU 5502-EXIT.         
PCR618     PERFORM 5503-JRNL-RATE-ITEM-CODE     THRU 5503-EXIT.         
           PERFORM 5505-JRNL-NO-UNITS           THRU 5505-EXIT.         
           PERFORM 5510-JRNL-DATE-PLAN-START    THRU 5510-EXIT.         
           PERFORM 5525-JRNL-LAST-BILL-DATE     THRU 5525-EXIT.         
           PERFORM 5535-JRNL-MTHLY-AMOUNT-FIXED THRU 5535-EXIT.         
           PERFORM 5540-JRNL-USAGE-FIXED        THRU 5540-EXIT.         
           PERFORM 5550-JRNL-PLAN-STATUS        THRU 5550-EXIT.         
           PERFORM 5555-JRNL-STAT-REASON        THRU 5555-EXIT.         
PCR618     PERFORM 5565-JRNL-REMOVE-DATE        THRU 5565-EXIT.         
                                                                        
                                                                        
       5500-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
A05065******************************************************************11210000
A05065*   5502-JRNL-IC-UTILITY                                         *11220000
A05065*                                                                *11230000
A05065******************************************************************11240000
A05065 5502-JRNL-IC-UTILITY.                                            
A05065                                                                  
A05065* IC-NO TRANS HIST                                                11260000
A05065     MOVE MH-TRANS-HIST-SEQ-NO        TO MI-TRANS-HIST-SEQ-NO.    
A05065                                                                  
A05065     MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO.         
A05065     MOVE SPACES                      TO MI-TABLE-ID.             
A05065                                                                  
A05065     MOVE +04                         TO MI-CHG-COLUMN-VALUE-LEN. 
A05065     MOVE WS-IC-NO                    TO MI-CHG-COLUMN-VALUE-TEXT.
A05065     MOVE +04                         TO MI-PRV-COLUMN-VALUE-LEN. 
A05065     MOVE WS-IC-NO                    TO MI-PRV-COLUMN-VALUE-TEXT.
A05065                                                                  
A05065                                                                  
A05065     MOVE 'IC NO          '     TO MI-COLUMN-DESC.                
A05065     PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
A05065     ADD 1                      TO WS-TRAN-APPL-NO.               
A05065                                                                  
A05065* UTILITY TRANS HIST                                              11260000
A05065     MOVE MH-TRANS-HIST-SEQ-NO        TO MI-TRANS-HIST-SEQ-NO.    
A05065     MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO.         
A05065     MOVE SPACES                      TO MI-TABLE-ID.             
A05065                                                                  
A05065     MOVE +10                         TO MI-CHG-COLUMN-VALUE-LEN. 
A05065     MOVE WS-UTILITY                  TO MI-CHG-COLUMN-VALUE-TEXT.
A05065     MOVE +10                         TO MI-PRV-COLUMN-VALUE-LEN. 
A05065     MOVE WS-UTILITY                  TO MI-PRV-COLUMN-VALUE-TEXT.
A05065                                                                  
A05065                                                                  
A05065     MOVE 'UTILITY        '     TO MI-COLUMN-DESC.                
A05065     PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
A05065     ADD 1                      TO WS-TRAN-APPL-NO.               
A05065                                                                  
A05065 5502-EXIT.                                                       
A05065     EXIT.                                                        
A05065                                                                  
      ******************************************************************11210000
      *   5503-JRNL-RATE-ITEM-CODE                                     *11220000
      *                                                                *11230000
      ******************************************************************11240000
       5503-JRNL-RATE-ITEM-CODE.                                        
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO        TO MI-TRANS-HIST-SEQ-NO.    
           MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO.         
           MOVE SPACES                      TO MI-TABLE-ID.             
                                                                        
           IF PARM-RATE-ITEM-CODE > 0                                   
              MOVE +24                      TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE PARM-RATE-ITEM-CODE      TO WS-RATE-ITM-CODE         
A05065        PERFORM 7180-GET-RATE-ITEM-DESC     THRU 7180-EXIT        
              MOVE WS-UM-EQUIP-SHRT-DESC    TO WS-RATE-ITM-DESC         
              MOVE WS-RATE-ITEM-CD-DESC     TO MI-CHG-COLUMN-VALUE-TEXT 
A05065        INITIALIZE WS-RATE-ITEM-CD-DESC                           
A05065                   WS-UM-EQUIP-SHRT-DESC                          
           ELSE                                                         
              MOVE +9                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE '*DELETED*'              TO MI-CHG-COLUMN-VALUE-TEXT 
           END-IF.                                                      
                                                                        
           IF WS-OLD-RT-ITEM-CD NOT EQUAL 0                             
              MOVE +24                      TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE WS-OLD-RT-ITEM-CD        TO WS-RATE-ITM-CODE         
A05065        PERFORM 7180-GET-RATE-ITEM-DESC     THRU 7180-EXIT        
              MOVE WS-UM-EQUIP-SHRT-DESC    TO WS-RATE-ITM-DESC         
              MOVE WS-RATE-ITEM-CD-DESC     TO MI-PRV-COLUMN-VALUE-TEXT 
A05065        INITIALIZE WS-RATE-ITEM-CD-DESC                           
                         WS-UM-EQUIP-SHRT-DESC                          
           ELSE                                                         
              MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
           END-IF.                                                      
                                                                        
           MOVE 'RATE ITEM CODE '           TO MI-COLUMN-DESC           
           PERFORM 6530-LOAD-MNT-TRANS-HIST       THRU 6530-EXIT        
           ADD 1                            TO WS-TRAN-APPL-NO.         
                                                                        
       5503-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************11590000
      *   5505-JRNL-NO-UNITS.                                          *11600000
      *                                                                *11610000
      ******************************************************************11620000
       5505-JRNL-NO-UNITS.                                              
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO        TO MI-TRANS-HIST-SEQ-NO.    
                                                                        
                                                                        
P00496     IF WS-NO-UNITS-OLD NOT      = PARM-NO-UNITS                  
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE SPACES                   TO MI-TABLE-ID              
                                                                        
P00496        IF PARM-NO-UNITS    NOT  =  ZEROES                        
P00496           IF PARM-NO-UNITS      < ZEROES                         
P00496              COMPUTE WS-NO-UNITS-HOLD = PARM-NO-UNITS  * -1      
P00496              MOVE '-'                TO WS-NO-UNITS-SI           
P00496              MOVE WS-NO-UNITS-HOLD   TO WS-NO-UNITS-NUM          
P00496              MOVE WS-NO-UNITS-X      TO WS-NO-UNITS-AM           
P00496              MOVE +10                TO MI-CHG-COLUMN-VALUE-LEN  
P00496              MOVE WS-NO-UNITS-VALUE                              
P00496                                      TO MI-CHG-COLUMN-VALUE-TEXT 
P00496           ELSE                                                   
                    MOVE +09                TO MI-CHG-COLUMN-VALUE-LEN  
                    MOVE PARM-NO-UNITS      TO WS-NO-UNITS-NUM          
                    MOVE WS-NO-UNITS-X      TO MI-CHG-COLUMN-VALUE-TEXT 
P00496           END-IF                                                 
              ELSE                                                      
                 MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE '*DELETED*'           TO MI-CHG-COLUMN-VALUE-TEXT 
              END-IF                                                    
                                                                        
P00496        IF WS-NO-UNITS-OLD NOT   = ZEROES                         
P00496           IF WS-NO-UNITS-OLD    < ZEROES                         
P00496              COMPUTE WS-NO-UNITS-HOLD = WS-NO-UNITS-OLD * -1     
P00496              MOVE '-'                TO WS-NO-UNITS-SI           
P00496              MOVE WS-NO-UNITS-HOLD   TO WS-NO-UNITS-NUM          
P00496              MOVE WS-NO-UNITS-X      TO WS-NO-UNITS-AM           
P00496              MOVE +10                TO MI-PRV-COLUMN-VALUE-LEN  
P00496              MOVE WS-NO-UNITS-VALUE                              
P00496                                      TO MI-PRV-COLUMN-VALUE-TEXT 
P00496           ELSE                                                   
                    MOVE +09                TO MI-PRV-COLUMN-VALUE-LEN  
                    MOVE WS-NO-UNITS-OLD    TO WS-NO-UNITS-NUM          
                    MOVE WS-NO-UNITS-X      TO MI-PRV-COLUMN-VALUE-TEXT 
P00496           END-IF                                                 
              ELSE                                                      
                 MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT 
              END-IF                                                    
                                                                        
              MOVE 'NO UNITS       '        TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST    THRU 6530-EXIT        
              ADD 1                         TO WS-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
       5505-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************12000000
      *   5510-JRNL-DATE-PLAN-START                                    *12010000
      *                                                                *12020000
      ******************************************************************12030000
       5510-JRNL-DATE-PLAN-START.                                       
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO        TO MI-TRANS-HIST-SEQ-NO.    
                                                                        
           IF WS-DATE-PLAN-START-OLD NOT = PARM-DATE-PLAN-START         
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE SPACES                   TO MI-TABLE-ID              
                                                                        
              IF PARM-DATE-PLAN-START > SPACES                          
                 MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE PARM-DATE-PLAN-START  TO MI-CHG-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE '*DELETED*'           TO MI-CHG-COLUMN-VALUE-TEXT 
              END-IF                                                    
                                                                        
              IF WS-DATE-PLAN-START-OLD > SPACES                        
                 MOVE +10                   TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE WS-DATE-PLAN-START-OLD                            
                                            TO MI-PRV-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT 
              END-IF                                                    
                                                                        
              MOVE 'DATE PLAN START'        TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST    THRU 6530-EXIT        
              ADD 1                         TO WS-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
       5510-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************13150000
      *   5525-JRNL-LAST-BILL-DATE                                     *13160000
      *                                                                *13170000
      ******************************************************************13180000
       5525-JRNL-LAST-BILL-DATE.                                        
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO        TO MI-TRANS-HIST-SEQ-NO.    
                                                                        
           IF WS-LAST-BILL-DATE-OLD NOT = PARM-LAST-BILL-DATE           
                                                                        
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE SPACES                   TO MI-TABLE-ID              
                                                                        
              IF PARM-LAST-BILL-DATE > SPACES                           
                 MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE PARM-LAST-BILL-DATE   TO MI-CHG-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE '*DELETED*'           TO MI-CHG-COLUMN-VALUE-TEXT 
              END-IF                                                    
                                                                        
              IF WS-LAST-BILL-DATE-OLD > SPACES                         
                 MOVE +10                   TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE WS-LAST-BILL-DATE-OLD TO MI-PRV-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT 
              END-IF                                                    
                                                                        
PCR618        IF PARM-LAST-BILL-DATE > SPACES                           
PCR618*       IF WS-INSERT-MODE = 'Y' AND PARM-LAST-BILL-DATE > SPACES  13450000
                 MOVE 'LAST BILL DATE '     TO MI-COLUMN-DESC           
                 PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT       
                 ADD 1                      TO WS-TRAN-APPL-NO          
              END-IF                                                    
           END-IF.                                                      
                                                                        
       5525-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************13960003
      *   5535-JRNL-MTHLY-AMOUNT-FIXED                                 *13960004
      *                                                                *13960005
      ******************************************************************13960006
       5535-JRNL-MTHLY-AMOUNT-FIXED.                                    
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO        TO MI-TRANS-HIST-SEQ-NO.    
                                                                        
A05065     IF PARM-ACTION-IND = 'I' AND                                 
A05065        PARM-MTHLY-AMOUNT-FIXED = 0                               
A05065        CONTINUE                                                  
A05065     ELSE                                                         
            IF WS-MTHLY-AMOUNT-FIXED-OLD NOT = PARM-MTHLY-AMOUNT-FIXED  
                                                                        
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE SPACES                   TO MI-TABLE-ID              
                                                                        
              IF PARM-MTHLY-AMOUNT-FIXED > ZERO                         
                 MOVE +12                   TO MI-CHG-COLUMN-VALUE-LEN  
                                                                        
                 MOVE PARM-MTHLY-AMOUNT-FIXED                           
                                           TO WS-MTHLY-AMOUNT-FIXED-DEC 
                 MOVE WS-MTHLY-AMOUNT-FIXED(1:9)                        
                                            TO MTHLY-AMT-FIX            
                 MOVE WS-MTHLY-AMOUNT-FIXED(10:2)                       
                                            TO MTHLY-AMT-FIX-DEC        
                 MOVE WS-MTHLY-AMOUNT-FIXED-VAL                         
                                            TO MI-CHG-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +1                    TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE '0'                   TO MI-CHG-COLUMN-VALUE-TEXT 
              END-IF                                                    
                                                                        
A05065        IF WS-MTHLY-AMOUNT-FIXED-OLD > 0                          
                 MOVE +12                   TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE WS-MTHLY-AMOUNT-FIXED-OLD                         
                                           TO WS-MTHLY-AMOUNT-FIXED-DEC 
                 MOVE WS-MTHLY-AMOUNT-FIXED(1:9)                        
                                            TO MTHLY-AMT-FIX            
                 MOVE WS-MTHLY-AMOUNT-FIXED(10:2)                       
                                            TO MTHLY-AMT-FIX-DEC        
                 MOVE WS-MTHLY-AMOUNT-FIXED-VAL                         
                                            TO MI-PRV-COLUMN-VALUE-TEXT 
              ELSE                                                      
A05065           IF PARM-ACTION-IND = 'I'                               
A05065              MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN  
A05065              MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT 
A05065           ELSE                                                   
A05065              MOVE +1                 TO MI-PRV-COLUMN-VALUE-LEN  
A05065              MOVE '0'                TO MI-PRV-COLUMN-VALUE-TEXT 
A05065           END-IF                                                 
              END-IF                                                    
                                                                        
              MOVE 'MTHLY AMT FIXED'        TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1                         TO WS-TRAN-APPL-NO          
A05065      END-IF                                                      
           END-IF.                                                      
                                                                        
       5535-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************13962700
      *   5540-JRNL-USAGE-FIXED                                        *13962800
      *                                                                *13962900
      ******************************************************************13963000
       5540-JRNL-USAGE-FIXED.                                           
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO        TO MI-TRANS-HIST-SEQ-NO.    
                                                                        
T15760*    COMPUTE WS-USAGE-FIXED-DEC = WS-USAGE-FIXED-DEC * 10.        13963600
                                                                        
A05065     IF PARM-ACTION-IND = 'I' AND                                 
A05065        PARM-USAGE-FIXED        = 0                               
A05065        CONTINUE                                                  
A05065     ELSE                                                         
            IF WS-USAGE-FIXED-OLD NOT = PARM-USAGE-FIXED                
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE SPACES                   TO MI-TABLE-ID              
                                                                        
              IF PARM-USAGE-FIXED > ZERO                                
A05065           MOVE PARM-USAGE-FIXED      TO WS-USAGE-FIXED-DEC       
A05065           MOVE +09                   TO MI-CHG-COLUMN-VALUE-LEN  
A05065           MOVE WS-USAGE-FIXED        TO MI-CHG-COLUMN-VALUE-TEXT 
A05065        ELSE                                                      
A05065           MOVE +1                    TO MI-CHG-COLUMN-VALUE-LEN  
A05065           MOVE '0'                   TO MI-CHG-COLUMN-VALUE-TEXT 
              END-IF                                                    
                                                                        
              IF WS-USAGE-FIXED-OLD > 0                                 
A05065           MOVE WS-USAGE-FIXED-OLD    TO WS-USAGE-FIXED-DEC       
A05065           MOVE +09                   TO MI-PRV-COLUMN-VALUE-LEN  
A05065           MOVE WS-USAGE-FIXED        TO MI-PRV-COLUMN-VALUE-TEXT 
A05065        ELSE                                                      
A05065           IF PARM-ACTION-IND = 'I'                               
A05065              MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN  
A05065              MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT 
A05065           ELSE                                                   
A05065              MOVE +1                 TO MI-PRV-COLUMN-VALUE-LEN  
A05065              MOVE '0'                TO MI-PRV-COLUMN-VALUE-TEXT 
A05065           END-IF                                                 
              END-IF                                                    
                                                                        
              MOVE 'USAGE FIXED    '        TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST    THRU 6530-EXIT        
              ADD 1                         TO WS-TRAN-APPL-NO          
A05065      END-IF                                                      
           END-IF.                                                      
                                                                        
       5540-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************14790000
      *   5550-JRNL-PLAN-STATUS                                        *14800000
      *                                                                *14810000
      ******************************************************************14820000
       5550-JRNL-PLAN-STATUS.                                           
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO        TO MI-TRANS-HIST-SEQ-NO.    
                                                                        
           IF WS-CODE-PLAN-STATUS-OLD NOT = PARM-CODE-PLAN-STATUS       
                                                                        
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE '03'                     TO MI-TABLE-ID              
                                                                        
              IF PARM-CODE-PLAN-STATUS > SPACES                         
A05065           MOVE PARM-CODE-PLAN-STATUS TO UV-CODE-VALUE-TEXT       
A05065           PERFORM 2100-GET-PLAN-STAT-DESC  THRU 2100-EXIT        
                 MOVE +30                   TO MI-CHG-COLUMN-VALUE-LEN  
A05065           MOVE UV-CODE-LONG-DESC-TEXT(1:30)                      
A05065                                      TO MI-CHG-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN  
A05065           IF WS-INSERT                                           
A05065              MOVE '         '        TO MI-CHG-COLUMN-VALUE-TEXT 
A05065           ELSE                                                   
A05065              MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT 
A05065           END-IF                                                 
              END-IF                                                    
                                                                        
              IF WS-CODE-PLAN-STATUS-OLD > SPACES                       
A05065           MOVE WS-CODE-PLAN-STATUS-OLD                           
A05065                                      TO UV-CODE-VALUE-TEXT       
A05065           PERFORM 2100-GET-PLAN-STAT-DESC  THRU 2100-EXIT        
A05065           MOVE +30                   TO MI-PRV-COLUMN-VALUE-LEN  
A05065           MOVE UV-CODE-LONG-DESC-TEXT(1:30)                      
A05065                                      TO MI-PRV-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN  
A05065           IF WS-UPDATE                                           
A05065              MOVE '     '            TO MI-PRV-COLUMN-VALUE-TEXT 
A05065           ELSE                                                   
A05065              MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT 
A05065           END-IF                                                 
              END-IF                                                    
                                                                        
              MOVE 'CD PLAN STATUS '        TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST    THRU 6530-EXIT        
              ADD 1                         TO WS-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
       5550-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************15180000
      *   5555-JRNL-STAT-REASON                                        *15190000
      *                                                                *15200000
      ******************************************************************15210000
       5555-JRNL-STAT-REASON.                                           
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO        TO MI-TRANS-HIST-SEQ-NO.    
                                                                        
           IF WS-CODE-STAT-REASON-OLD NOT = PARM-CODE-STAT-REASON       
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE '04'                     TO MI-TABLE-ID              
                                                                        
              IF PARM-CODE-STAT-REASON > SPACE                          
A05065           MOVE PARM-CODE-STAT-REASON TO UV-CODE-VALUE-TEXT       
A05065           PERFORM 2200-GET-STAT-RSN-DESC   THRU 2200-EXIT        
A05065           MOVE +30                   TO MI-CHG-COLUMN-VALUE-LEN  
A05065           MOVE UV-CODE-LONG-DESC-TEXT(1:30)                      
A05065                                      TO MI-CHG-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN  
A05065           IF WS-INSERT                                           
A05065              MOVE '         '        TO MI-CHG-COLUMN-VALUE-TEXT 
A05065           ELSE                                                   
A05065              MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT 
A05065           END-IF                                                 
A05065        END-IF                                                    
                                                                        
              IF WS-CODE-STAT-REASON-OLD > SPACES                       
A05065           MOVE WS-CODE-STAT-REASON-OLD                           
A05065                                      TO UV-CODE-VALUE-TEXT       
A05065           PERFORM 2200-GET-STAT-RSN-DESC   THRU 2200-EXIT        
A05065           MOVE +30                   TO MI-PRV-COLUMN-VALUE-LEN  
A05065           MOVE UV-CODE-LONG-DESC-TEXT(1:30)                      
A05065                                      TO MI-PRV-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN  
A05065           IF WS-UPDATE                                           
A05065              MOVE '     '            TO MI-PRV-COLUMN-VALUE-TEXT 
A05065           ELSE                                                   
A05065              MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT 
A05065           END-IF                                                 
              END-IF                                                    
                                                                        
              MOVE 'CD STAT REASON '        TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST    THRU 6530-EXIT        
              ADD 1                         TO WS-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
       5555-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************15790000
      *   5565-JRNL-REMOVE-DATE                                        *15800000
      *                                                                *15810000
      ******************************************************************15820000
       5565-JRNL-REMOVE-DATE.                                           
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO      TO MI-TRANS-HIST-SEQ-NO.      
                                                                        
A05065     IF PARM-ACTION-IND = 'I' AND                                 
A05065        PARM-REMOVE-DATE = SPACES                                 
A05065        CONTINUE                                                  
A05065     ELSE                                                         
A05065      IF WS-REMOVE-DATE-OLD NOT = PARM-REMOVE-DATE                
                                                                        
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              MOVE SPACES                 TO MI-TABLE-ID                
                                                                        
              IF PARM-REMOVE-DATE > SPACES                              
                 MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE PARM-REMOVE-DATE      TO MI-CHG-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE '*DELETED*'           TO MI-CHG-COLUMN-VALUE-TEXT 
              END-IF                                                    
                                                                        
              IF WS-REMOVE-DATE-OLD > SPACES                            
                 MOVE +10                   TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE WS-REMOVE-DATE-OLD    TO MI-PRV-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT 
              END-IF                                                    
                                                                        
              MOVE 'REMOVE DATE '           TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST    THRU 6530-EXIT        
              ADD 1                         TO WS-TRAN-APPL-NO          
                                                                        
            END-IF                                                      
           END-IF.                                                      
                                                                        
       5565-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************16170100
      *   5600-DEL-JRNL-UPDATE                                         *16170200
      *                                                                *16170300
      ******************************************************************16170400
       5600-DEL-JRNL-UPDATE.                                            
                                                                        
A05065     PERFORM 5502-JRNL-IC-UTILITY           THRU 5502-EXIT.       
      * RATE ITEM CODE                                                  16171000
           MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO          
           MOVE SPACES                      TO MI-TABLE-ID              
      *                                                                 16171030
           MOVE +9                          TO MI-CHG-COLUMN-VALUE-LEN  
           MOVE '*DELETED*'                 TO MI-CHG-COLUMN-VALUE-TEXT 
           MOVE +24                         TO MI-PRV-COLUMN-VALUE-LEN  
           MOVE PARM-RATE-ITEM-CODE         TO WS-RATE-ITM-CODE         
A05065     PERFORM 7180-GET-RATE-ITEM-DESC        THRU 7180-EXIT        
           MOVE WS-UM-EQUIP-SHRT-DESC       TO WS-RATE-ITM-DESC         
           MOVE WS-RATE-ITEM-CD-DESC        TO MI-PRV-COLUMN-VALUE-TEXT 
           MOVE 'RATE ITEM CODE '           TO MI-COLUMN-DESC           
           PERFORM 6530-LOAD-MNT-TRANS-HIST       THRU 6530-EXIT        
           ADD 1                            TO WS-TRAN-APPL-NO          
      * NO OF UNITS                                                     16171900
           IF WS-NO-UNITS-OLD NOT   = ZEROES                            
              IF WS-NO-UNITS-OLD    < ZEROES                            
                 COMPUTE WS-NO-UNITS-HOLD = WS-NO-UNITS-OLD * -1        
                 MOVE '-'                   TO WS-NO-UNITS-SI           
                 MOVE WS-NO-UNITS-HOLD      TO WS-NO-UNITS-NUM          
                 MOVE WS-NO-UNITS-X         TO WS-NO-UNITS-AM           
                 MOVE +10                   TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE WS-NO-UNITS-VALUE                                 
                                            TO MI-PRV-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +09                   TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE WS-NO-UNITS-OLD       TO WS-NO-UNITS-NUM          
                 MOVE WS-NO-UNITS-X         TO MI-PRV-COLUMN-VALUE-TEXT 
              END-IF                                                    
           ELSE                                                         
              MOVE +1                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE '0'                      TO MI-PRV-COLUMN-VALUE-TEXT 
           END-IF                                                       
           MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO          
           MOVE SPACES                      TO MI-TABLE-ID              
      *                                                                 16172002
           MOVE +9                          TO MI-CHG-COLUMN-VALUE-LEN  
           MOVE '*DELETED*'                 TO MI-CHG-COLUMN-VALUE-TEXT 
      *                                                                 16172200
           MOVE 'NO UNITS '                 TO MI-COLUMN-DESC           
           PERFORM 6530-LOAD-MNT-TRANS-HIST       THRU 6530-EXIT        
           ADD 1                            TO WS-TRAN-APPL-NO          
      * DATE PLAN START                                                 16172610
           MOVE +9                          TO MI-CHG-COLUMN-VALUE-LEN  
           MOVE '*DELETED*'                 TO MI-CHG-COLUMN-VALUE-TEXT 
           MOVE +10                         TO MI-PRV-COLUMN-VALUE-LEN  
           MOVE WS-DATE-PLAN-START-OLD                                  
                                            TO MI-PRV-COLUMN-VALUE-TEXT 
           MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO          
           MOVE SPACES                      TO MI-TABLE-ID              
      *                                                                 16172654
           MOVE 'DATE PLAN START'           TO MI-COLUMN-DESC           
           PERFORM 6530-LOAD-MNT-TRANS-HIST       THRU 6530-EXIT        
           ADD 1                            TO WS-TRAN-APPL-NO          
      * LAST BILL DATE                                                  16172690
           MOVE +9                          TO MI-CHG-COLUMN-VALUE-LEN  
           MOVE '*DELETED*'                 TO MI-CHG-COLUMN-VALUE-TEXT 
           MOVE +10                         TO MI-PRV-COLUMN-VALUE-LEN  
           MOVE WS-LAST-BILL-DATE-OLD       TO MI-PRV-COLUMN-VALUE-TEXT 
           MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO          
           MOVE SPACES                      TO MI-TABLE-ID              
      *                                                                 16172697
           MOVE 'LAST BILL DATE '           TO MI-COLUMN-DESC           
           PERFORM 6530-LOAD-MNT-TRANS-HIST       THRU 6530-EXIT        
           ADD 1                            TO WS-TRAN-APPL-NO          
      * MONTHLY AMOUNT FIXED                                            16172701
           MOVE WS-MTHLY-AMOUNT-FIXED-OLD   TO WS-MTHLY-AMOUNT-FIXED-DEC
           IF WS-MTHLY-AMOUNT-FIXED-OLD > 0                             
              MOVE +12                      TO MI-PRV-COLUMN-VALUE-LEN  
                                                                        
              MOVE WS-MTHLY-AMOUNT-FIXED(1:9)                           
                                            TO MTHLY-AMT-FIX            
              MOVE WS-MTHLY-AMOUNT-FIXED(10:2)                          
                                            TO MTHLY-AMT-FIX-DEC        
              MOVE WS-MTHLY-AMOUNT-FIXED-VAL                            
                                            TO MI-PRV-COLUMN-VALUE-TEXT 
           ELSE                                                         
              MOVE +1                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE '0'                      TO MI-PRV-COLUMN-VALUE-TEXT 
           END-IF                                                       
      *                                                                 16172717
           MOVE +9                          TO MI-CHG-COLUMN-VALUE-LEN  
           MOVE '*DELETED*'                 TO MI-CHG-COLUMN-VALUE-TEXT 
      *                                                                 16172720
           MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO          
           MOVE SPACES                      TO MI-TABLE-ID              
      *                                                                 16172723
           MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO          
           MOVE SPACES                      TO MI-TABLE-ID              
      *                                                                 16172726
           MOVE 'MTHLY AMT FIXED'           TO MI-COLUMN-DESC           
           PERFORM 6530-LOAD-MNT-TRANS-HIST       THRU 6530-EXIT        
           ADD 1                            TO WS-TRAN-APPL-NO          
      * USAGE FIXED                                                     16172751
           MOVE WS-USAGE-FIXED-OLD          TO WS-USAGE-FIXED-DEC.      
                                                                        
              IF WS-USAGE-FIXED-OLD > 0                                 
                 MOVE +09                   TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE WS-USAGE-FIXED        TO MI-PRV-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +1                    TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE '0'                   TO MI-PRV-COLUMN-VALUE-TEXT 
              END-IF.                                                   
                                                                        
           MOVE +9                          TO MI-CHG-COLUMN-VALUE-LEN  
           MOVE '*DELETED*'                 TO MI-CHG-COLUMN-VALUE-TEXT 
           MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO          
           MOVE SPACES                      TO MI-TABLE-ID              
      *                                                                 16172766
           MOVE 'USAGE FIXED'               TO MI-COLUMN-DESC           
           PERFORM 6530-LOAD-MNT-TRANS-HIST       THRU 6530-EXIT        
           ADD 1                            TO WS-TRAN-APPL-NO          
      * CODE PLAN STATUS                                                16172770
           MOVE +9                          TO MI-CHG-COLUMN-VALUE-LEN  
           MOVE '*DELETED*'                 TO MI-CHG-COLUMN-VALUE-TEXT 
A05065     MOVE WS-CODE-PLAN-STATUS-OLD                                 
A05065                                      TO UV-CODE-VALUE-TEXT       
A05065     PERFORM 2100-GET-PLAN-STAT-DESC  THRU 2100-EXIT              
A05065     MOVE +30                   TO MI-PRV-COLUMN-VALUE-LEN        
A05065     MOVE UV-CODE-LONG-DESC-TEXT(1:20)                            
A05065                                      TO MI-PRV-COLUMN-VALUE-TEXT 
           MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO          
           MOVE SPACES                      TO MI-TABLE-ID              
      *                                                                 16172801
           MOVE 'CD PLAN STATUS '           TO MI-COLUMN-DESC           
           PERFORM 6530-LOAD-MNT-TRANS-HIST       THRU 6530-EXIT        
           ADD 1                            TO WS-TRAN-APPL-NO          
      * CODE STATUS REASON                                              16172805
           MOVE +9                          TO MI-CHG-COLUMN-VALUE-LEN  
           MOVE '*DELETED*'                 TO MI-CHG-COLUMN-VALUE-TEXT 
A05065     MOVE +30                         TO MI-PRV-COLUMN-VALUE-LEN  
A05065     MOVE WS-CODE-STAT-REASON-OLD                                 
A05065                                      TO UV-CODE-VALUE-TEXT       
A05065     PERFORM 2200-GET-STAT-RSN-DESC         THRU 2200-EXIT        
A05065     MOVE UV-CODE-LONG-DESC-TEXT(1:20)                            
A05065                                      TO MI-PRV-COLUMN-VALUE-TEXT 
           MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO          
           MOVE SPACES                      TO MI-TABLE-ID              
      *                                                                 16172816
           MOVE 'CD STAT REASON '           TO MI-COLUMN-DESC           
           PERFORM 6530-LOAD-MNT-TRANS-HIST       THRU 6530-EXIT        
           ADD 1                            TO WS-TRAN-APPL-NO          
      * REMOVE DATE                                                     16172830
           IF WS-REMOVE-DATE-OLD > SPACES                               
              MOVE +9                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE '*DELETED*'              TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE +04                      TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE WS-REMOVE-DATE-OLD       TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE SPACES                   TO MI-TABLE-ID              
      *                                                                 16172873
              MOVE 'REMOVE DATE '           TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST    THRU 6530-EXIT        
              ADD 1                         TO WS-TRAN-APPL-NO          
           END-IF.                                                      
      *                                                                 16172900
       5600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************16180000
      *  JOURNALING COPYBOOK.                                          *16190000
      ******************************************************************16200000
           EXEC SQL                                                     16210000
              INCLUDE CPD00067                                          16220000
           END-EXEC.                                                    16230000
                                                                        
      ******************************************************************16260000
      * 7000-GET-RATE-PLAN-NO.                                         *16270000
      *                                                                *16280000
      ******************************************************************16290000
       7000-GET-RATE-PLAN-NO.                                           
                                                                        
           EXEC SQL                                                     
              SELECT UT.RATE_PLAN_NO                                    
A05065              ,RD.CODE_SERVICE_TYPE                               
                INTO :UT-RATE-PLAN-NO                                   
A05065              ,:RD-CODE-SERVICE-TYPE                              
                FROM CSS_UTIL_ENVRNMT   UT WITH(READUNCOMMITTED)                
A05065              ,CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED)                
               WHERE UT.ACCOUNT_NO     = :CP-ACCOUNT-NO                 
                 AND UT.CODE_UTIL_TYPE = :CP-CODE-UTIL-TYPE             
                 AND UT.IC_NO          = :CP-IC-NO                      
A05065           AND UT.CODE_UTIL_TYPE = RD.CODE_UTIL_TYPE              
A05065           AND UT.RATE_PLAN_NO   = RD.RATE_PLAN_NO                
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     16340000
MFA-TR*       SELECT UT.RATE_PLAN_NO                                    16350000
MFA-TR*             ,RD.CODE_SERVICE_TYPE                                       
MFA-TR*         INTO :UT-RATE-PLAN-NO                                   16360000
MFA-TR*             ,:RD-CODE-SERVICE-TYPE                              16360000
MFA-TR*         FROM CSS_UTIL_ENVRNMT   UT                              16370000
MFA-TR*             ,CSS_RATE_PLAN_DESC RD                              16370000
MFA-TR*        WHERE UT.ACCOUNT_NO     = :CP-ACCOUNT-NO                 16380000
MFA-TR*          AND UT.CODE_UTIL_TYPE = :CP-CODE-UTIL-TYPE             16390000
MFA-TR*          AND UT.IC_NO          = :CP-IC-NO                      16400000
MFA-TR*          AND UT.CODE_UTIL_TYPE = RD.CODE_UTIL_TYPE              16400000
MFA-TR*          AND UT.RATE_PLAN_NO   = RD.RATE_PLAN_NO                16400000
MFA-TR*        WITH UR                                                  16401000
MFA-TR*    END-EXEC.                                                    16410000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A05065        MOVE UT-RATE-PLAN-NO          TO UP-RATE-PLAN-NO          
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
CBSI          MOVE SPACES                   TO ABEND-SQL-PREDICATES     
CBSI                                           ABEND-TABLES             
              MOVE '7000'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CSS_UTIL_ENVRNMT'       TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE CP-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE CP-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE CP-IC-NO                 TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************16670000
      * 7010-GET-MAX-VERSION.                                          *16680000
      *                                                                *16690000
      ******************************************************************16700000
       7010-GET-MAX-VERSION.                                            
                                                                        
           EXEC SQL                                                     
              SELECT MAX(VERSION_NO_CNTRL)                              
                INTO :RT-VERSION-NO-CNTRL :WS-NULL-VERSION-NO-CNTRL      
                FROM CSS_RATE_CREATOR WITH(READUNCOMMITTED)                     
               WHERE CODE_UTIL_TYPE    = :CP-CODE-UTIL-TYPE             
                 AND RATE_PLAN_NO      = :UT-RATE-PLAN-NO               
                 AND CODE_STATUS       = :CP-CODE-PLAN-STATUS           
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     16750000
MFA-TR*       SELECT MAX(VERSION_NO_CNTRL)                              16760000
MFA-TR*         INTO :RT-VERSION-NO-CNTRL:WS-NULL-VERSION-NO-CNTRL      16770000
MFA-TR*         FROM CSS_RATE_CREATOR                                   16780000
MFA-TR*        WHERE CODE_UTIL_TYPE    = :CP-CODE-UTIL-TYPE             16790000
MFA-TR*          AND RATE_PLAN_NO      = :UT-RATE-PLAN-NO               16800000
MFA-TR*          AND CODE_STATUS       = :CP-CODE-PLAN-STATUS           16810000
MFA-TR*        WITH UR                                                  16811000
MFA-TR*    END-EXEC.                                                    16820000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 S-RETURN-CODE-1.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL AND               
              RT-VERSION-NO-CNTRL > 0                                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE '7010'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CSS_RATE_CREATOR'         TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE CP-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE UT-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-2      
CBSI          MOVE 'CODE_STATUS'              TO TABLE-ELEMENT-3        
              MOVE CP-CODE-PLAN-STATUS        TO HOSTVAR-ELEMENT-3      
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-4        
CBSI          MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-4      
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************17150000
      * 7015-GET-MAX-RATE-ITEM.                                        *17160000
      *                                                                *17170000
      ******************************************************************17180000
       7015-GET-MAX-RATE-ITEM.                                          
                                                                        
           PERFORM 7020-SELECT-MAX-CUST-RATE       THRU 7020-EXIT.      
      *    PERFORM 7025-SELECT-NEXT-UNMTR-RATE     THRU 7025-EXIT.      17220000
                                                                        
           COMPUTE CP-RATE-ITEM-CODE = WS-TEMP-RATE-ITEM-CODE + 1.      
                                                                        
       7015-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************17300000
      * 7020-SELECT-MAX-CUST-RATE.                                     *17310000
      *                                                                *17320000
      ******************************************************************17330000
       7020-SELECT-MAX-CUST-RATE.                                       
                                                                        
           EXEC SQL                                                     
              SELECT MAX(RATE_ITEM_CODE)                                
                INTO :WS-TEMP-RATE-ITEM-CODE :WS-NULL-RATE-ITEM-CODE     
                FROM CSS_CUST_PLAN WITH(READUNCOMMITTED)                        
               WHERE ACCOUNT_NO        = :CP-ACCOUNT-NO                 
                 AND CODE_UTIL_TYPE    = :CP-CODE-UTIL-TYPE             
                 AND IC_NO             = :CP-IC-NO                      
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     17380000
MFA-TR*       SELECT MAX(RATE_ITEM_CODE)                                17390000
MFA-TR*         INTO :WS-TEMP-RATE-ITEM-CODE:WS-NULL-RATE-ITEM-CODE     17400000
MFA-TR*         FROM CSS_CUST_PLAN                                      17410000
MFA-TR*        WHERE ACCOUNT_NO        = :CP-ACCOUNT-NO                 17420000
MFA-TR*          AND CODE_UTIL_TYPE    = :CP-CODE-UTIL-TYPE             17430000
MFA-TR*          AND IC_NO             = :CP-IC-NO                      17440000
MFA-TR*        WITH UR                                                  17441000
MFA-TR*    END-EXEC.                                                    17450000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-NULL-RATE-ITEM-CODE = -1                            
                 MOVE 0                       TO WS-NULL-RATE-ITEM-CODE 
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE '7020'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CSS_CUST_PLAN'            TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE CP-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
              MOVE CP-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2      
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-3        
              MOVE CP-IC-NO                   TO HOSTVAR-ELEMENT-3      
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************17730000
      * 7025-SELECT-NEXT-UNMTR-RATE.                                   *17740000
      *                                                                *17750000
      ******************************************************************17760000
       7025-SELECT-NEXT-UNMTR-RATE.                                     
                                                                        
           EXEC SQL                                                     
              SELECT MIN(RATE_ITEM_CODE)                                
                INTO :CP-RATE-ITEM-CODE :WS-NULL-RATE-ITEM-CODE          
                FROM CSS_UNMTR_PLAN WITH(READUNCOMMITTED)                       
               WHERE CODE_UTIL_TYPE   = :CP-CODE-UTIL-TYPE              
                 AND RATE_PLAN_NO     = :UT-RATE-PLAN-NO                
                 AND VERSION_NO_CNTRL = :RT-VERSION-NO-CNTRL            
                 AND RATE_ITEM_CODE   > :WS-TEMP-RATE-ITEM-CODE         
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     17810000
MFA-TR*       SELECT MIN(RATE_ITEM_CODE)                                17820000
MFA-TR*         INTO :CP-RATE-ITEM-CODE:WS-NULL-RATE-ITEM-CODE          17830000
MFA-TR*         FROM CSS_UNMTR_PLAN                                     17840000
MFA-TR*        WHERE CODE_UTIL_TYPE   = :CP-CODE-UTIL-TYPE              17850000
MFA-TR*          AND RATE_PLAN_NO     = :UT-RATE-PLAN-NO                17860000
MFA-TR*          AND VERSION_NO_CNTRL = :RT-VERSION-NO-CNTRL            17870000
MFA-TR*          AND RATE_ITEM_CODE   > :WS-TEMP-RATE-ITEM-CODE         17880000
MFA-TR*        WITH UR                                                  17881000
MFA-TR*    END-EXEC.                                                    17890000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 S-RETURN-CODE-1.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL AND               
              CP-RATE-ITEM-CODE > 0                                     
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE '7025'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CSS_UNMTR_PLAN'           TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE CP-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE UT-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-2      
              MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-3        
              MOVE RT-VERSION-NO-CNTRL        TO HOSTVAR-ELEMENT-3      
CBSI          MOVE 'RATE_ITEM_CODE'           TO TABLE-ELEMENT-4        
CBSI          MOVE WS-TEMP-RATE-ITEM-CODE     TO HOSTVAR-ELEMENT-4      
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
       7025-EXIT.                                                       
           EXIT.                                                        
                                                                        
PCR618******************************************************************18210000
      * 7028-GET-MAX-SEQ-NO.                                           *18220000
      *                                                                *18230000
      ******************************************************************18240000
       7028-GET-MAX-SEQ-NO.                                             
                                                                        
           EXEC SQL                                                     
              SELECT MAX(ITEM_SEQ_NO)                                   
                INTO :WS-ITEM-SEQ-NO :WS-NULL-ITEM-SEQ-NO                
                FROM CSS_CUST_PLAN CP WITH(READUNCOMMITTED),                    
                     CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                  
               WHERE CP.ACCOUNT_NO        = :CP-ACCOUNT-NO              
                 AND CP.ACCOUNT_NO        = UT.ACCOUNT_NO               
                 AND CP.CODE_UTIL_TYPE    = :CP-CODE-UTIL-TYPE          
                 AND CP.IC_NO             = :CP-IC-NO                   
                 AND UT.RATE_PLAN_NO      = :UT-RATE-PLAN-NO            
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     18290000
MFA-TR*       SELECT MAX(ITEM_SEQ_NO)                                   18300000
MFA-TR*         INTO :WS-ITEM-SEQ-NO:WS-NULL-ITEM-SEQ-NO                18310000
MFA-TR*         FROM CSS_CUST_PLAN CP,                                  18320000
MFA-TR*              CSS_UTIL_ENVRNMT UT                                18330000
MFA-TR*        WHERE CP.ACCOUNT_NO        = :CP-ACCOUNT-NO              18340000
MFA-TR*          AND CP.ACCOUNT_NO        = UT.ACCOUNT_NO               18350000
MFA-TR*          AND CP.CODE_UTIL_TYPE    = :CP-CODE-UTIL-TYPE          18360000
MFA-TR*          AND CP.IC_NO             = :CP-IC-NO                   18370000
MFA-TR*          AND UT.RATE_PLAN_NO      = :UT-RATE-PLAN-NO            18380000
MFA-TR*          WITH UR                                                18381000
MFA-TR*    END-EXEC.                                                    18390000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL AND               
              WS-ITEM-SEQ-NO > 0                                        
              COMPUTE CP-ITEM-SEQ-NO = WS-ITEM-SEQ-NO + 1               
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL AND            
                WS-ITEM-SEQ-NO = 0                                      
                 MOVE +1                         TO CP-ITEM-SEQ-NO      
PCR618        ELSE                                                      
                 MOVE PROGRAM-NAME               TO ABEND-PROGRAM       
                 MOVE 'SELECT'                   TO ABEND-FUNCTION      
CBSI             MOVE SPACES                     TO ABEND-SQL-PREDICATES
CBSI                                                ABEND-TABLES        
                 MOVE '7028'                     TO ACTIVE-PARAGRAPH    
                 MOVE 'CSS_CUST_PLAN'            TO TABLE-1             
                 MOVE 'CSS_UTIL_ENVRNMT'         TO TABLE-2             
                 MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1     
                 MOVE CP-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1   
                 MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2     
                 MOVE CP-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2   
                 MOVE 'IC_NO'                    TO TABLE-ELEMENT-3     
                 MOVE CP-IC-NO                   TO HOSTVAR-ELEMENT-3   
                 MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-4     
                 MOVE UT-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-4   
                 PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT        
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7028-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************18740000
      * 7030-INSERT-CUST-PLAN.                                         *18750000
      *                                                                *18760000
      ******************************************************************18770000
       7030-INSERT-CUST-PLAN.                                           
                                                                        
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_CUST_PLAN                                 
                  (ACCOUNT_NO        ,                                  
                   CODE_UTIL_TYPE    ,                                  
                   IC_NO             ,                                  
                   RATE_ITEM_CODE    ,                                  
                   ITEM_SEQ_NO       ,                                  
                   CODE_PLAN_STATUS  ,                                  
                   CODE_SERVICE_TYPE ,                                  
                   CODE_STAT_REASON  ,                                  
                   DATE_PLAN_START   ,                                  
                   USAGE_FIXED       ,                                  
                   MTHLY_AMOUNT_FIXED,                                  
                   NO_UNITS          ,                                  
                   REMOVE_DATE       ,                                  
                   DIST_NO           ,                                  
PCR618             POLE_NO           ,                                  
                   LIGHT_NO          ,                                  
                   LAST_BILL_DATE)                                      
              VALUES                                                    
                  (:CP-ACCOUNT-NO        ,                              
                   :CP-CODE-UTIL-TYPE    ,                              
                   :CP-IC-NO             ,                              
                   :CP-RATE-ITEM-CODE    ,                              
                   :CP-ITEM-SEQ-NO       ,                              
                   :CP-CODE-PLAN-STATUS  ,                              
                   :CP-CODE-SERVICE-TYPE ,                              
                   :CP-CODE-STAT-REASON  ,                              
                   IIF(TRY_CONVERT(DATE, :CP-DATE-PLAN-START
              ) IS NULL OR (PATINDEX('%.%', :CP-DATE-PLAN-START
              ) <> 0) OR (LEN(:CP-DATE-PLAN-START
              ) <> 10), CIS.CHAR2DATE(:CP-DATE-PLAN-START
              ), CONVERT(DATE, :CP-DATE-PLAN-START) )   ,                      
                   :CP-USAGE-FIXED       ,                              
                   :CP-MTHLY-AMOUNT-FIXED,                              
                   :CP-NO-UNITS          ,                              
PCR618             IIF(TRY_CONVERT(DATE, :CP-REMOVE-DATE :WS-NULL-IND-3
              ) IS NULL OR (PATINDEX('%.%', :CP-REMOVE-DATE 
                                                         :WS-NULL-IND-3
              ) <> 0) OR (LEN(:CP-REMOVE-DATE :WS-NULL-IND-3
              ) <> 10), CIS.CHAR2DATE(:CP-REMOVE-DATE :WS-NULL-IND-3
              ), CONVERT(DATE, :CP-REMOVE-DATE :WS-NULL-IND-3) ),              
                   :CP-DIST-NO           ,                              
PCR618             :CP-POLE-NO           ,                              
                   :CP-LIGHT-NO          ,                              
T16412             IIF(TRY_CONVERT(DATE, :CP-LAST-BILL-DATE 
                                         :WS-NULL-IND-2
              ) IS NULL OR (PATINDEX('%.%', :CP-LAST-BILL-DATE 
                                                         :WS-NULL-IND-2
              ) <> 0) OR (LEN(:CP-LAST-BILL-DATE :WS-NULL-IND-2
              ) <> 10), CIS.CHAR2DATE(:CP-LAST-BILL-DATE :WS-NULL-IND-2
              ), CONVERT(DATE, :CP-LAST-BILL-DATE :WS-NULL-IND-2) ))           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     18830000
MFA-TR*       INSERT INTO CSS_CUST_PLAN                                 18840000
MFA-TR*           (ACCOUNT_NO        ,                                  18850000
MFA-TR*            CODE_UTIL_TYPE    ,                                  18860000
MFA-TR*            IC_NO             ,                                  18870000
MFA-TR*            RATE_ITEM_CODE    ,                                  18880000
MFA-TR*            ITEM_SEQ_NO       ,                                  18890000
MFA-TR*            CODE_PLAN_STATUS  ,                                  18900000
MFA-TR*            CODE_SERVICE_TYPE ,                                  18910000
MFA-TR*            CODE_STAT_REASON  ,                                  18920000
MFA-TR*            DATE_PLAN_START   ,                                  18930000
MFA-TR*            USAGE_FIXED       ,                                  18940000
MFA-TR*            MTHLY_AMOUNT_FIXED,                                  18950000
MFA-TR*            NO_UNITS          ,                                  18960000
MFA-TR*            REMOVE_DATE       ,                                  18970000
MFA-TR*            DIST_NO           ,                                  18980000
MFA-TR*            POLE_NO           ,                                  18990000
MFA-TR*            LIGHT_NO          ,                                  19000000
MFA-TR*            LAST_BILL_DATE)                                      19010000
MFA-TR*       VALUES                                                    19020000
MFA-TR*           (:CP-ACCOUNT-NO        ,                              19030000
MFA-TR*            :CP-CODE-UTIL-TYPE    ,                              19040000
MFA-TR*            :CP-IC-NO             ,                              19050000
MFA-TR*            :CP-RATE-ITEM-CODE    ,                              19060000
MFA-TR*            :CP-ITEM-SEQ-NO       ,                              19070000
MFA-TR*            :CP-CODE-PLAN-STATUS  ,                              19080000
MFA-TR*            :CP-CODE-SERVICE-TYPE ,                              19090000
MFA-TR*            :CP-CODE-STAT-REASON  ,                              19100000
MFA-TR*            :CP-DATE-PLAN-START   ,                              19110000
MFA-TR*            :CP-USAGE-FIXED       ,                              19120000
MFA-TR*            :CP-MTHLY-AMOUNT-FIXED,                              19130000
MFA-TR*            :CP-NO-UNITS          ,                              19140000
MFA-TR*            :CP-REMOVE-DATE:WS-NULL-IND-3,                       19150000
MFA-TR*            :CP-DIST-NO           ,                              19160000
MFA-TR*            :CP-POLE-NO           ,                              19170000
MFA-TR*            :CP-LIGHT-NO          ,                              19180000
MFA-TR*            :CP-LAST-BILL-DATE:WS-NULL-IND-2)                    19190000
MFA-TR*    END-EXEC.                                                    19200000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-1.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE '7030'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CSS_CUST_PLAN'            TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE CP-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
              MOVE CP-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2      
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-3        
              MOVE CP-IC-NO                   TO HOSTVAR-ELEMENT-3      
CBSI          MOVE 'RATE_ITEM_CODE'           TO TABLE-ELEMENT-4        
CBSI          MOVE CP-RATE-ITEM-CODE          TO HOSTVAR-ELEMENT-4      
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************19480000
      * 7050-GET-AT-INFO.                                              *19490000
      *                                                                *19500000
      ******************************************************************19510000
       7050-GET-AT-INFO.                                                
                                                                        
           EXEC SQL                                                     
              SELECT AT.CODES_DATA_PRESENT,                             
                     AT.BILL_CYCLE        ,                             
                     AT.COMPANY_NO        ,                             
                     AT.CUSTOMER_NO       ,                             
                     AT.PREMISE_NO        ,                             
                     AT.CODE_ACCT_STAT    ,                             
                     UT.READ_CYCLE        ,                             
                     AT.ACCOUNT_TYPE_CODE ,                             
                     UT.CODE_REVENUE_CLASS                              
                INTO :AT-CODES-DATA-PRESENT,                            
                     :AT-BILL-CYCLE        ,                            
                     :AT-COMPANY-NO        ,                            
                     :AT-CUSTOMER-NO       ,                            
                     :AT-PREMISE-NO        ,                            
                     :AT-CODE-ACCT-STAT    ,                            
                     :UT-READ-CYCLE        ,                            
                     :AT-ACCOUNT-TYPE-CODE ,                            
                     :UT-CODE-REVENUE-CLASS                             
                FROM CSS_ACCOUNT      AT WITH(READUNCOMMITTED),                 
                     CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                  
               WHERE AT.ACCOUNT_NO     = :CP-ACCOUNT-NO                 
                 AND UT.ACCOUNT_NO     = :CP-ACCOUNT-NO                 
                 AND UT.CODE_UTIL_TYPE = :CP-CODE-UTIL-TYPE             
                 AND UT.IC_NO          = :CP-IC-NO                      
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     19560000
MFA-TR*       SELECT AT.CODES_DATA_PRESENT,                             19570000
MFA-TR*              AT.BILL_CYCLE        ,                             19580000
MFA-TR*              AT.COMPANY_NO        ,                             19580100
MFA-TR*              AT.CUSTOMER_NO       ,                             19590000
MFA-TR*              AT.PREMISE_NO        ,                             19600000
MFA-TR*              AT.CODE_ACCT_STAT    ,                             19610000
MFA-TR*              UT.READ_CYCLE        ,                             19620000
MFA-TR*              AT.ACCOUNT_TYPE_CODE ,                             19630000
MFA-TR*              UT.CODE_REVENUE_CLASS                              19640000
MFA-TR*         INTO :AT-CODES-DATA-PRESENT,                            19650000
MFA-TR*              :AT-BILL-CYCLE        ,                            19660000
MFA-TR*              :AT-COMPANY-NO        ,                            19660100
MFA-TR*              :AT-CUSTOMER-NO       ,                            19670000
MFA-TR*              :AT-PREMISE-NO        ,                            19680000
MFA-TR*              :AT-CODE-ACCT-STAT    ,                            19690000
MFA-TR*              :UT-READ-CYCLE        ,                            19700000
MFA-TR*              :AT-ACCOUNT-TYPE-CODE ,                            19710000
MFA-TR*              :UT-CODE-REVENUE-CLASS                             19720000
MFA-TR*         FROM CSS_ACCOUNT      AT,                               19730000
MFA-TR*              CSS_UTIL_ENVRNMT UT                                19740000
MFA-TR*        WHERE AT.ACCOUNT_NO     = :CP-ACCOUNT-NO                 19750000
MFA-TR*          AND UT.ACCOUNT_NO     = :CP-ACCOUNT-NO                 19760000
MFA-TR*          AND UT.CODE_UTIL_TYPE = :CP-CODE-UTIL-TYPE             19770000
MFA-TR*          AND UT.IC_NO          = :CP-IC-NO                      19780000
MFA-TR*        WITH UR                                                  19781000
MFA-TR*    END-EXEC.                                                    19790000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE '7050'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CSS_ACCOUNT'              TO TABLE-1                
              MOVE 'CSS_UTIL_ENVRNMT'         TO TABLE-2                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE CP-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
CBSI          MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
CBSI          MOVE CP-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2      
CBSI          MOVE 'IC_NO'                    TO TABLE-ELEMENT-3        
CBSI          MOVE CP-IC-NO                   TO HOSTVAR-ELEMENT-3      
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************20060000
      * 7055-PROCESS-PEND-ACCT.                                        *20070000
      *                                                                *20080000
      ******************************************************************20090000
       7055-PROCESS-PEND-ACCT.                                          
                                                                        
           MOVE AT-CODES-DATA-PRESENT         TO WS-CODES-DATA-PRESENT. 
           MOVE 'M01'                         TO AT-CODE-BILL-FREQ.     
                                                                        
           IF WS-CODE-BUDGET = SPACES                                   
              MOVE 'A'                        TO WS-CODE-UTL            
              MOVE WS-CODES-DATA-PRESENT      TO AT-CODES-DATA-PRESENT  
           END-IF.                                                      
                                                                        
           IF AT-BILL-CYCLE = '00'                                      
              MOVE UT-READ-CYCLE              TO AT-BILL-CYCLE          
           END-IF.                                                      
                                                                        
           PERFORM 7060-GET-ACCT-TYPE         THRU 7060-EXIT.           
T19443     PERFORM 7080-SELECT-CUST-PREM-HIST THRU 7080-EXIT.           
T19443     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
T19443        CONTINUE                                                  
T19443     ELSE                                                         
LMSCHG        MOVE 'MRM0000139'             TO S-RS1-BUS-RULE-ID        
LMSCHG        MOVE WS-FAILED                TO S-RS1-BUS-RULE-RESULT-CD 
LMSCHG        IF S-RS1-BUS-RULE-ID GREATER THAN SPACES                  
LMSCHG           PERFORM 7550-GET-RULE-XREF-ID THRU 7550-EXIT           
LMSCHG        END-IF                                                    
LMSCHG        PERFORM 8010-INSERT-GTT-R1       THRU 8010-EXIT           
LMSCHG        PERFORM 9999-END-PROGRAM         THRU 9999-EXIT           
T19443     END-IF.                                                      
                                                                        
T19120     PERFORM 7070-CHECK-ACTIVE-ACCT     THRU 7070-EXIT.           
           PERFORM 7100-UPDATE-AT-INFO        THRU 7100-EXIT.           
T23256     IF PARM-CODE-PLAN-STATUS  = WS-ACTIVE AND                    
T23256           PR-CODE-PREMISE-STAT  = 'J'                            
T23256              MOVE WS-ACTIVE            TO PR-CODE-PREMISE-STAT   
T23256              PERFORM 7125-UPDATE-PREMISE      THRU 7125-EXIT     
T23256     END-IF.                                                      
           PERFORM 7110-INSERT-CUST-PREM-HIST THRU 7110-EXIT.           
           PERFORM 7120-UPDATE-CUST-INFO      THRU 7120-EXIT.           
           PERFORM 7130-CHECK-PREM-IND        THRU 7130-EXIT.           
                                                                        
       7055-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************20490000
      * 7060-GET-ACCT-TYPE.                                            *20500000
      *                                                                *20510000
      ******************************************************************20520000
       7060-GET-ACCT-TYPE.                                              
                                                                        
           IF UT-CODE-REVENUE-CLASS(2:1) = '1'                          
              MOVE 'R'                   TO AT-ACCOUNT-TYPE-CODE        
           ELSE IF UT-CODE-REVENUE-CLASS(2:1) = '2' OR '3' OR '8' OR '9'
              MOVE 'C'                   TO AT-ACCOUNT-TYPE-CODE        
           ELSE IF UT-CODE-REVENUE-CLASS(2:1) = '6'                     
              MOVE 'M'                   TO AT-ACCOUNT-TYPE-CODE        
           ELSE IF UT-CODE-REVENUE-CLASS(2:1) = '7'                     
              MOVE 'W'                   TO AT-ACCOUNT-TYPE-CODE        
           ELSE                                                         
              MOVE 'D'                   TO AT-ACCOUNT-TYPE-CODE        
           END-IF
                END-IF
                END-IF
           END-IF.                                                      
                                                                        
       7060-EXIT.                                                       
           EXIT.                                                        
                                                                        
T19120******************************************************************20700000
ST    * 7070-CHECK-ACTIVE-ACCT.                                        *20710000
      *                                                                *20720000
      ******************************************************************20730000
       7070-CHECK-ACTIVE-ACCT.                                          
                                                                        
T22433     MOVE ZEROES                 TO AT-ACCOUNT-NO                 
           PERFORM 7071-OPEN-CHECK-STAT-CURSOR  THRU 7071-EXIT.         
           PERFORM 7072-FETCH-CHECK-STAT-CURSOR THRU 7072-EXIT.         
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              PERFORM 7073-CLOSE-CHECK-STAT-CURSOR THRU 7073-EXIT       
           ELSE                                                         
              PERFORM 7073-CLOSE-CHECK-STAT-CURSOR THRU 7073-EXIT       
              MOVE 'MRM0000138'             TO S-RS1-BUS-RULE-ID        
              MOVE WS-FAILED                TO S-RS1-BUS-RULE-RESULT-CD 
              MOVE AT-ACCOUNT-NO            TO S-RS1-ACCOUNT-NO         
              IF S-RS1-BUS-RULE-ID GREATER THAN SPACES                  
                 PERFORM 7550-GET-RULE-XREF-ID THRU 7550-EXIT           
              END-IF                                                    
              PERFORM 8010-INSERT-GTT-R1       THRU 8010-EXIT           
              PERFORM 9999-END-PROGRAM         THRU 9999-EXIT           
           END-IF.                                                      
                                                                        
   END 7070-EXIT.                                                       
T19120     EXIT.                                                        
                                                                        
T19120******************************************************************20910000
ST    * 7071-OPEN-CHECK-STAT-CURSOR                                    *20920000
      *     CALLS       9000-SEND-ERROR-RESULT                         *20930000
      *                 9900-SQL-ERROR-ROUTINE                         *20940000
      *                                                                *20950000
      *     CALLED FROM 5000-UPDATE                                    *20960000
      *                                                                *20970000
      *     OPENS THE CURSOR                                           *20980000
      ******************************************************************20990000
                                                                        
       7071-OPEN-CHECK-STAT-CURSOR.                                     
                                                                        
           EXEC SQL                                                     
              OPEN CHECK-STAT-CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 S-RETURN-CODE-1.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE '7071'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CSS_ACCOUNT'            TO TABLE-1                  
              MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-1        
              MOVE AT-PREMISE-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
       7071-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************21280000
      * 7072-FETCH-CHECK-STAT-CURSOR.                                  *21290000
      *     CALLS       9000-SEND-ERROR-RESULT                         *21300000
      *                 9900-SQL-ERROR-ROUTINE                         *21310000
      *                                                                *21320000
      *     CALLED FROM 5000-UPDATE                                    *21330000
      *                                                                *21340000
      ******************************************************************21350000
       7072-FETCH-CHECK-STAT-CURSOR.                                    
                                                                        
           EXEC SQL                                                     
              FETCH  CHECK-STAT-CURSOR                                  
              INTO  :AT-ACCOUNT-NO                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND     
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE '7072'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CSS_ACCOUNT'              TO TABLE-1                
              MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-1        
              MOVE AT-PREMISE-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
       7072-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************21630000
      * 7073-CLOSE-CHECK-STAT-CURSOR                                   *21640000
      *     CALLS       9000-SEND-ERROR-RESULT                         *21650000
      *                 9900-SQL-ERROR-ROUTINE                         *21660000
      *                                                                *21670000
      *     CALLED FROM 5000-UPDATE                                    *21680000
      *                                                                *21690000
      *     CLOSES THE CURSOR                                          *21700000
      ******************************************************************21710000
                                                                        
       7073-CLOSE-CHECK-STAT-CURSOR.                                    
                                                                        
           EXEC SQL                                                     
              CLOSE CHECK-STAT-CURSOR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 S-RETURN-CODE-1.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE '7073'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CSS_CUST_PLAN'            TO TABLE-1                
              MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-1        
              MOVE AT-PREMISE-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
                                                                        
ED     7073-EXIT.                                                       
T19120     EXIT.                                                        
BILGEN**************************************************************            
BILGEN* 7074-GET-EXT-BILLING-FL                                                 
BILGEN* TO CHECK FOR BILLGEN ACCOUNT                                            
BILGEN*                                                                         
BILGEN**************************************************************            
BILGEN 7074-GET-EXT-BILLING-FL.                                         
BILGEN                                                                  
BILGEN     EXEC SQL                                                     
BILGEN        SELECT EXT_BILLING_FL                                     
BILGEN          INTO :AT-EXT-BILLING-FL                                 
BILGEN          FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                          
BILGEN         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
T35434                                                           
BILGEN     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     22090000
MFA-TR*       SELECT EXT_BILLING_FL                                     22100000
MFA-TR*         INTO :AT-EXT-BILLING-FL                                 22110000
MFA-TR*         FROM CSS_ACCOUNT                                        22120000
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        22130000
MFA-TR*        WITH UR                                                  22131000
MFA-TR*    END-EXEC.                                                    22140000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

BILGEN                                                                  
BILGEN     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
BILGEN                                           S-RETURN-CODE-1.       
                                                                        
BILGEN     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
BILGEN        CONTINUE                                                  
BILGEN     ELSE                                                         
BILGEN        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
BILGEN        MOVE 'SELECT'                   TO ABEND-FUNCTION         
BILGEN        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
BILGEN                                           ABEND-TABLES           
BILGEN        MOVE '7074'                     TO ACTIVE-PARAGRAPH       
BILGEN        MOVE 'CSS_ACCOUNT'              TO TABLE-1                
BILGEN        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
BILGEN        MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
BILGEN        PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
BILGEN     END-IF.                                                      
BILGEN                                                                  
BILGEN 7074-EXIT.                                                       
BILGEN     EXIT.                                                        
BILGEN**************************************************************            
BILGEN* 7075-GET-ENERGY-SOURCE                                                  
BILGEN* TO CHECK FOR ENERGY SOURCE                                              
BILGEN*                                                                         
BILGEN**************************************************************            
BILGEN 7075-GET-ENERGY-SOURCE.                                          
BILGEN                                                                  
BILGEN     EXEC SQL                                                     
BILGEN        SELECT ENERGY_SOURCE                                      
BILGEN          INTO :UT-ENERGY-SOURCE                                  
BILGEN          FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                     
BILGEN         WHERE ACCOUNT_NO     = :UT-ACCOUNT-NO                    
BILGEN           AND IC_NO          = :UT-IC-NO                         
BILGEN           AND CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE                
T35434                                                           
BILGEN     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     22430000
MFA-TR*       SELECT ENERGY_SOURCE                                      22440000
MFA-TR*         INTO :UT-ENERGY-SOURCE                                  22450000
MFA-TR*         FROM CSS_UTIL_ENVRNMT                                   22460000
MFA-TR*        WHERE ACCOUNT_NO     = :UT-ACCOUNT-NO                    22470000
MFA-TR*          AND IC_NO          = :UT-IC-NO                         22480000
MFA-TR*          AND CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE                22490000
MFA-TR*        WITH UR                                                  22491000
MFA-TR*    END-EXEC.                                                    22500000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

BILGEN                                                                  
BILGEN     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
BILGEN                                           S-RETURN-CODE-1.       
                                                                        
BILGEN     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
BILGEN        CONTINUE                                                  
BILGEN     ELSE                                                         
BILGEN        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
BILGEN        MOVE 'SELECT'                   TO ABEND-FUNCTION         
BILGEN        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
BILGEN                                           ABEND-TABLES           
BILGEN        MOVE '7075'                     TO ACTIVE-PARAGRAPH       
BILGEN        MOVE 'CSS_UTIL_ENVRNMT'         TO TABLE-1                
BILGEN        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
BILGEN        MOVE UT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
BILGEN        MOVE 'IC_NO'                    TO TABLE-ELEMENT-2        
BILGEN        MOVE UT-IC-NO                   TO HOSTVAR-ELEMENT-2      
BILGEN        MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-3        
BILGEN        MOVE UT-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-3      
BILGEN        PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
BILGEN     END-IF.                                                      
BILGEN 7075-EXIT.                                                       
BILGEN     EXIT.                                                        
BILGEN                                                                  
BILGEN**************************************************************            
BILGEN* 7076-GET-ACTIVE-CUST-PLAN                                               
BILGEN* TO CHECK FOR ACTIVE CUSTOMER PLANS                                      
BILGEN*                                                                         
BILGEN**************************************************************            
BILGEN 7076-GET-ACTIVE-CUST-PLAN.                                       
BILGEN                                                                  
BILGEN     EXEC SQL                                                     
BILGEN        SELECT CODE_PLAN_STATUS                                   
BILGEN          INTO :CP-CODE-PLAN-STATUS                               
BILGEN          FROM CSS_CUST_PLAN WITH(READUNCOMMITTED)                        
BILGEN         WHERE ACCOUNT_NO         = :CP-ACCOUNT-NO                
BILGEN           AND CODE_UTIL_TYPE     = :CP-CODE-UTIL-TYPE            
BILGEN           AND IC_NO              = :CP-IC-NO                     
BILGEN           AND CODE_PLAN_STATUS   = :WS-ACTIVE                    
T35434                                                           
BILGEN     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     22830000
MFA-TR*       SELECT CODE_PLAN_STATUS                                   22840000
MFA-TR*         INTO :CP-CODE-PLAN-STATUS                               22850000
MFA-TR*         FROM CSS_CUST_PLAN                                      22860000
MFA-TR*        WHERE ACCOUNT_NO         = :CP-ACCOUNT-NO                22870000
MFA-TR*          AND CODE_UTIL_TYPE     = :CP-CODE-UTIL-TYPE            22880000
MFA-TR*          AND IC_NO              = :CP-IC-NO                     22890000
MFA-TR*          AND CODE_PLAN_STATUS   = :WS-ACTIVE                    22900000
MFA-TR*        WITH UR                                                  22901000
MFA-TR*    END-EXEC.                                                    22910000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

BILGEN                                                                  
BILGEN     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 S-RETURN-CODE-1.       
BILGEN                                                                  
                                                                        
BILGEN     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
BILGEN        MOVE 600                        TO WS-ACTIVE-RETURN-CODE  
BILGEN     ELSE                                                         
BILGEN        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
BILGEN           CONTINUE                                               
BILGEN        ELSE                                                      
BILGEN           MOVE PROGRAM-NAME            TO ABEND-PROGRAM          
BILGEN           MOVE 'SELECT'                TO ABEND-FUNCTION         
BILGEN           MOVE SPACES                  TO ABEND-SQL-PREDICATES   
BILGEN                                           ABEND-TABLES           
BILGEN           MOVE 'CSS_CUST_PLAN'         TO TABLE-1                
BILGEN           MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1        
BILGEN           MOVE CP-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1      
BILGEN           MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2        
BILGEN           MOVE CP-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2      
BILGEN           MOVE 'IC_NO'                 TO TABLE-ELEMENT-3        
BILGEN           MOVE CP-IC-NO                TO HOSTVAR-ELEMENT-3      
BILGEN           PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT        
BILGEN        END-IF                                                    
BILGEN     END-IF.                                                      
BILGEN 7076-EXIT.                                                       
BILGEN     EXIT.                                                        
BILGEN                                                                  
T19443******************************************************************23230000
ST    * 7080-SLECT-CUST-PREM-HIST.                                     *23240000
      *                                                                *23250000
      ******************************************************************23260000
       7080-SELECT-CUST-PREM-HIST.                                      
                                                                        
           EXEC SQL                                                     
               SELECT ACCOUNT_NO                                        
                 INTO :WS-ACCT-NUM                                      
                 FROM  CSS_CUST_PREM_HIST WITH(READUNCOMMITTED)                 
                 WHERE PREMISE_NO = :AT-PREMISE-NO                      
                   AND ACCOUNT_NO <>:CP-ACCOUNT-NO                      
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     23300000
MFA-TR*        SELECT ACCOUNT_NO                                        23310000
MFA-TR*          INTO :WS-ACCT-NUM                                      23320000
MFA-TR*          FROM  CSS_CUST_PREM_HIST                               23330000
MFA-TR*          WHERE PREMISE_NO = :AT-PREMISE-NO                      23340000
MFA-TR*            AND ACCOUNT_NO <>:CP-ACCOUNT-NO                      23350000
MFA-TR*          WITH UR                                                23351000
MFA-TR*    END-EXEC.                                                    23360000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
                                     OR WS-811                          
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE '7080'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CSS_CUST_PREM_HIST'       TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE  AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1      
              MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-2        
              MOVE  AT-PREMISE-NO             TO HOSTVAR-ELEMENT-2      
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
    ED 7080-EXIT.                                                       
T19443     EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************23610000
      * 7100-UPDATE-AT-INFO.                                           *23620000
      *                                                                *23630000
      ******************************************************************23640000
       7100-UPDATE-AT-INFO.                                             
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_ACCOUNT                                        
                 SET CODE_ACCT_STAT     = 'A'                   ,       
                     CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT,       
                     LAST_UPDATE_TS     = CIS.CURRENT$TIMESTAMP()     ,       
                     ACCOUNT_TYPE_CODE  = :AT-ACCOUNT-TYPE-CODE ,       
                     CODE_STATUS_REASON = 'A'                   ,       
                     BILL_CYCLE         = :AT-BILL-CYCLE        ,       
                     CODE_BILL_FREQ     = :AT-CODE-BILL-FREQ            
               WHERE ACCOUNT_NO = :CP-ACCOUNT-NO                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     23690000
MFA-TR*       UPDATE CSS_ACCOUNT                                        23700000
MFA-TR*          SET CODE_ACCT_STAT     = 'A'                   ,       23710000
MFA-TR*              CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT,       23720000
MFA-TR*              LAST_UPDATE_TS     = CURRENT TIMESTAMP     ,       23730000
MFA-TR*              ACCOUNT_TYPE_CODE  = :AT-ACCOUNT-TYPE-CODE ,       23740000
MFA-TR*              CODE_STATUS_REASON = 'A'                   ,       23750000
MFA-TR*              BILL_CYCLE         = :AT-BILL-CYCLE        ,       23760000
MFA-TR*              CODE_BILL_FREQ     = :AT-CODE-BILL-FREQ            23770000
MFA-TR*        WHERE ACCOUNT_NO = :CP-ACCOUNT-NO                        23780000
MFA-TR*    END-EXEC.                                                    23790000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 S-RETURN-CODE-1.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'UPDATE'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE '7100'                     TO TABLE-1                
              MOVE 'CSS_ACCOUNT'              TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
CBSI          MOVE 'ACCOUNT_TYPE_CODE'        TO TABLE-ELEMENT-2        
CBSI          MOVE 'BILL_CYCLE'               TO TABLE-ELEMENT-3        
              MOVE CP-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
CBSI          MOVE AT-ACCOUNT-TYPE-CODE       TO HOSTVAR-ELEMENT-2      
CBSI          MOVE AT-BILL-CYCLE              TO HOSTVAR-ELEMENT-3      
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************24050000
      * 7110-INSERT-CUST-PREM-HIST.                                    *24060000
      *                                                                *24070000
      ******************************************************************24080000
       7110-INSERT-CUST-PREM-HIST.                                      
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_CUST_PREM_HIST                           
                  (PREMISE_NO        ,                                  
                   ACCOUNT_NO        ,                                  
                   DATE_UTIL_SVC_STRT,                                  
                   DATE_UTIL_SVC_END ,                                  
                   CUSTOMER_NO)                                         
               VALUES                                                   
                  (:AT-PREMISE-NO                     ,                 
                   :CP-ACCOUNT-NO                     ,                 
                   CAST(SYSDATETIMEOFFSET() 
           AS DATE)                       ,                 
                   NULL                               ,                 
                   :AT-CUSTOMER-NO)                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     24130000
MFA-TR*        INSERT INTO CSS_CUST_PREM_HIST                           24140000
MFA-TR*           (PREMISE_NO        ,                                  24150000
MFA-TR*            ACCOUNT_NO        ,                                  24160000
MFA-TR*            DATE_UTIL_SVC_STRT,                                  24170000
MFA-TR*            DATE_UTIL_SVC_END ,                                  24180000
MFA-TR*            CUSTOMER_NO)                                         24190000
MFA-TR*        VALUES                                                   24200000
MFA-TR*           (:AT-PREMISE-NO                     ,                 24210000
MFA-TR*            :CP-ACCOUNT-NO                     ,                 24220000
MFA-TR*            CURRENT DATE                       ,                 24230000
MFA-TR*            NULL                               ,                 24240000
MFA-TR*            :AT-CUSTOMER-NO)                                     24250000
MFA-TR*    END-EXEC.                                                    24260000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 S-RETURN-CODE-1.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE '7110'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CSS_CUST_PREM_HIST'       TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE CP-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
CBSI          MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-2        
CBSI          MOVE  AT-PREMISE-NO             TO HOSTVAR-ELEMENT-2      
CBSI          MOVE 'CUSTOMER_NO'              TO TABLE-ELEMENT-3        
CBSI          MOVE AT-CUSTOMER-NO             TO HOSTVAR-ELEMENT-3      
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************24520000
      * 7120-UPDATE-CUST-INFO.                                         *24530000
      *                                                                *24540000
      ******************************************************************24550000
       7120-UPDATE-CUST-INFO.                                           
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_CUSTOMER                                      
                  SET SERVICE_EST_DATE = CAST(SYSDATETIMEOFFSET() 
           AS DATE),                  
                      LAST_UPDATE_TS   = CIS.CURRENT$TIMESTAMP()              
                WHERE CUSTOMER_NO = :AT-CUSTOMER-NO                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     24600000
MFA-TR*        UPDATE CSS_CUSTOMER                                      24610000
MFA-TR*           SET SERVICE_EST_DATE = CURRENT DATE,                  24620000
MFA-TR*               LAST_UPDATE_TS   = CURRENT TIMESTAMP              24630000
MFA-TR*         WHERE CUSTOMER_NO = :AT-CUSTOMER-NO                     24640000
MFA-TR*    END-EXEC.                                                    24650000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 S-RETURN-CODE-1.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'UPDATE'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE '7120'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CSS_CUSTOMER'             TO TABLE-1                
              MOVE 'CUSTOMER_NO'              TO TABLE-ELEMENT-1        
              MOVE AT-CUSTOMER-NO             TO HOSTVAR-ELEMENT-1      
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
CBSI          MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-2      
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************24890000
      * 7130-CHECK-PREM-IND.                                           *24900000
      *                                                                *24910000
      ******************************************************************24920000
       7130-CHECK-PREM-IND.                                             
                                                                        
PCR618     IF CP-CODE-UTIL-TYPE EQUAL WS-UNMETERED                      
              PERFORM 7140-GET-LITE-IND           THRU 7140-EXIT        
      *                                                                 24970000
T17596        PERFORM 7160-SELECT-ACTIVE-CP-ROWS  THRU 7160-EXIT        
      *                                                                 24990000
              IF WS-ACTIVE-COUNT > 0                                    
PCR618           MOVE WS-ACTIVE                TO PR-LITE-AVAILABLE-IND 
PCR618        ELSE                                                      
T22433          MOVE CP-ACCOUNT-NO           TO AT-ACCOUNT-NO           
T21697          PERFORM 7071-OPEN-CHECK-STAT-CURSOR  THRU 7071-EXIT     
T21697          PERFORM 7072-FETCH-CHECK-STAT-CURSOR THRU 7072-EXIT     
T21697          EVALUATE  WS-ACTIVE-RETURN-CODE                         
T21697            WHEN NOT-FOUND                                        
T21697                 MOVE WS-INACTIVE      TO PR-LITE-AVAILABLE-IND   
T21697            WHEN SUCCESSFUL-CALL                                  
T21697                 MOVE WS-ACTIVE        TO PR-LITE-AVAILABLE-IND   
T21697            WHEN WS-811                                           
T21697                 MOVE WS-ACTIVE        TO PR-LITE-AVAILABLE-IND   
T21697            WHEN OTHER                                            
T21697                 MOVE PROGRAM-NAME     TO ABEND-PROGRAM           
T21697                 MOVE 'FETCH'          TO ABEND-FUNCTION          
T21697                 MOVE SPACES           TO ABEND-SQL-PREDICATES    
T21697                                          ABEND-TABLES            
T21697                 MOVE '7130'           TO ACTIVE-PARAGRAPH        
T21697                 MOVE 'CSS_ACCOUNT'    TO TABLE-1                 
T21697                 MOVE 'PREMISE_NO'     TO TABLE-ELEMENT-1         
T21697                 MOVE AT-PREMISE-NO    TO HOSTVAR-ELEMENT-1       
T21697                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT        
T21697          END-EVALUATE                                            
T21697          PERFORM 7073-CLOSE-CHECK-STAT-CURSOR THRU 7073-EXIT     
PCR618        END-IF                                                    
PCR618        PERFORM 7150-UPDATE-LITE-INFO    THRU 7150-EXIT           
PCR618     ELSE                                                         
              IF CP-CODE-UTIL-TYPE EQUAL WS-ELECTRIC                    
                 PERFORM 7141-GET-ELEC-IND           THRU 7141-EXIT     
      *                                                                 25400000
T17596           PERFORM 7160-SELECT-ACTIVE-CP-ROWS  THRU 7160-EXIT     
      *                                                                 25420000
                 IF WS-ACTIVE-COUNT > 0                                 
PCR618              MOVE WS-ACTIVE             TO PR-ELEC-AVAILABLE-IND 
PCR618           ELSE                                                   
T17596              PERFORM 7165-SELECT-ACTIVE-MN-ROWS THRU 7165-EXIT   
T17596              IF WS-ACTIVE-COUNT > 0                              
T17596                 MOVE WS-ACTIVE          TO PR-ELEC-AVAILABLE-IND 
T17596              ELSE                                                
PCR618                 MOVE WS-INACTIVE        TO PR-ELEC-AVAILABLE-IND 
T17596              END-IF                                              
PCR618           END-IF                                                 
                 PERFORM 7151-UPDATE-ELEC-INFO    THRU 7151-EXIT        
PCR618        ELSE                                                      
                 IF CP-CODE-UTIL-TYPE EQUAL WS-GAS                      
                    PERFORM 7142-GET-GAS-IND            THRU 7142-EXIT  
      *                                                                 25610000
T17596              PERFORM 7160-SELECT-ACTIVE-CP-ROWS  THRU 7160-EXIT  
      *                                                                 25630000
                    IF WS-ACTIVE-COUNT > 0                              
PCR618                 MOVE WS-ACTIVE          TO PR-GAS-AVAILABLE-IND  
PCR618              ELSE                                                
T17596                 PERFORM 7165-SELECT-ACTIVE-MN-ROWS THRU 7165-EXIT
T17596                 IF WS-ACTIVE-COUNT > 0                           
T17596                    MOVE WS-ACTIVE       TO PR-GAS-AVAILABLE-IND  
T17596                 ELSE                                             
PCR618                    MOVE WS-INACTIVE     TO PR-GAS-AVAILABLE-IND  
T17596                 END-IF                                           
PCR618              END-IF                                              
PCR618              PERFORM 7152-UPDATE-GAS-INFO     THRU 7152-EXIT     
                 END-IF                                                 
PCR618        END-IF                                                    
           END-IF.                                                      
T23256     IF PARM-CODE-PLAN-STATUS  = WS-ACTIVE AND                    
T23256           PR-CODE-PREMISE-STAT  = 'J'   AND                      
T23256           AT-CODE-ACCT-STAT ='A'                                 
T23256              MOVE WS-ACTIVE            TO PR-CODE-PREMISE-STAT   
T23256              PERFORM 7125-UPDATE-PREMISE      THRU 7125-EXIT     
T23256     END-IF.                                                      
       7130-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************25920000
      * 7140-GET-LITE-IND.                                             *25930002
      *                                                                *25940000
      ******************************************************************25950000
       7140-GET-LITE-IND.                                               
                                                                        
           EXEC SQL                                                     
               SELECT LITE_AVAILABLE_IND                                
T23256               ,CODE_PREMISE_STAT                                 
                 INTO :PR-LITE-AVAILABLE-IND                            
T23256               ,:PR-CODE-PREMISE-STAT                             
                 FROM CSS_PREMISE WITH(READUNCOMMITTED)                         
                WHERE PREMISE_NO = :AT-PREMISE-NO                       
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     26000000
MFA-TR*        SELECT LITE_AVAILABLE_IND                                26010000
MFA-TR*              ,CODE_PREMISE_STAT                                 26020000
MFA-TR*          INTO :PR-LITE-AVAILABLE-IND                            26030000
MFA-TR*              ,:PR-CODE-PREMISE-STAT                             26040000
MFA-TR*          FROM CSS_PREMISE                                       26050000
MFA-TR*         WHERE PREMISE_NO = :AT-PREMISE-NO                       26060000
MFA-TR*         WITH UR                                                 26061000
MFA-TR*    END-EXEC.                                                    26070000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE '7140'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CSS_PREMISE'              TO TABLE-1                
              MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-1        
              MOVE AT-PREMISE-NO              TO HOSTVAR-ELEMENT-1      
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
CBSI          MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-2      
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
       7140-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************26310000
      * 7141-GET-ELEC-IND.                                             *26320000
      *                                                                *26330000
      ******************************************************************26340000
       7141-GET-ELEC-IND.                                               
                                                                        
           EXEC SQL                                                     
               SELECT ELEC_AVAILABLE_IND                                
C36513               ,CODE_PREMISE_STAT                                 
                 INTO :PR-ELEC-AVAILABLE-IND                            
C36513               ,:PR-CODE-PREMISE-STAT                             
                 FROM CSS_PREMISE WITH(READUNCOMMITTED)                         
                WHERE PREMISE_NO = :AT-PREMISE-NO                       
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     26390000
MFA-TR*        SELECT ELEC_AVAILABLE_IND                                26400000
MFA-TR*              ,CODE_PREMISE_STAT                                 26401000
MFA-TR*          INTO :PR-ELEC-AVAILABLE-IND                            26410000
MFA-TR*              ,:PR-CODE-PREMISE-STAT                             26411000
MFA-TR*          FROM CSS_PREMISE                                       26420000
MFA-TR*         WHERE PREMISE_NO = :AT-PREMISE-NO                       26430000
MFA-TR*         WITH UR                                                 26431000
MFA-TR*    END-EXEC.                                                    26440000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE '7141'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CSS_PREMISE'              TO TABLE-1                
              MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-1        
              MOVE AT-PREMISE-NO              TO HOSTVAR-ELEMENT-1      
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
CBSI          MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-2      
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
       7141-EXIT.                                                       
           EXIT.                                                        
                                                                        
PCR618******************************************************************26670000
      * 7142-GET-GAS-IND.                                              *26680000
      *                                                                *26690000
      ******************************************************************26700000
       7142-GET-GAS-IND.                                                
                                                                        
           EXEC SQL                                                     
               SELECT GAS_AVAILABLE_IND                                 
C36513               ,CODE_PREMISE_STAT                                 
                 INTO :PR-GAS-AVAILABLE-IND                             
C36513               ,:PR-CODE-PREMISE-STAT                             
                 FROM CSS_PREMISE WITH(READUNCOMMITTED)                         
                WHERE PREMISE_NO = :AT-PREMISE-NO                       
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     26750000
MFA-TR*        SELECT GAS_AVAILABLE_IND                                 26760000
MFA-TR*              ,CODE_PREMISE_STAT                                 26761000
MFA-TR*          INTO :PR-GAS-AVAILABLE-IND                             26770000
MFA-TR*              ,:PR-CODE-PREMISE-STAT                             26771000
MFA-TR*          FROM CSS_PREMISE                                       26780000
MFA-TR*         WHERE PREMISE_NO = :AT-PREMISE-NO                       26790000
MFA-TR*         WITH UR                                                 26791000
MFA-TR*    END-EXEC.                                                    26800000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE '7142'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CSS_PREMISE'              TO TABLE-1                
              MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-1        
              MOVE AT-PREMISE-NO              TO HOSTVAR-ELEMENT-1      
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
CBSI          MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-2      
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
       7142-EXIT.                                                       
           EXIT.                                                        
                                                                        
T23256******************************************************************27030000
T23256* 7125-UPDATE-PREMISE.                                           *27040000
T23256*                                                                *27050000
T23256******************************************************************27060000
T23256 7125-UPDATE-PREMISE.                                             
T23256                                                                  
T23256     EXEC SQL                                                     
T23256         UPDATE CSS_PREMISE                                       
T23256            SET CODE_PREMISE_STAT = :PR-CODE-PREMISE-STAT         
T23256          WHERE PREMISE_NO = :AT-PREMISE-NO                       
T23256     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T23256                                                                  
T23256     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
T23256                                                                  
T23256     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T23256        CONTINUE                                                  
T23256     ELSE                                                         
T23256        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
T23256        MOVE 'UPDATE'                   TO ABEND-FUNCTION         
T23256        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
T23256                                           ABEND-TABLES           
T23256        MOVE '7125'                     TO ACTIVE-PARAGRAPH       
T23256        MOVE 'CSS_PREMISE'              TO TABLE-1                
T23256        MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-1        
T23256        MOVE  AT-PREMISE-NO             TO HOSTVAR-ELEMENT-1      
T23256        MOVE 'CODE_PREMISE_STAT'        TO TABLE-ELEMENT-2        
T23256        MOVE  PR-CODE-PREMISE-STAT      TO HOSTVAR-ELEMENT-2      
T23256        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-3        
T23256        MOVE  PARM-ACCOUNT-NO           TO HOSTVAR-ELEMENT-3      
T23256        PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
T23256     END-IF.                                                      
T23256                                                                  
T23256 7125-EXIT.                                                       
T23256     EXIT.                                                        
      ******************************************************************27390000
      * 7150-UPDATE-LITE-INFO.                                         *27400000
      *                                                                *27410000
      ******************************************************************27420000
       7150-UPDATE-LITE-INFO.                                           
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_PREMISE                                       
                  SET LITE_AVAILABLE_IND = :PR-LITE-AVAILABLE-IND       
                WHERE PREMISE_NO = :AT-PREMISE-NO                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 S-RETURN-CODE-1.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'UPDATE'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE '7150'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CSS_PREMISE'              TO TABLE-1                
              MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-1        
              MOVE AT-PREMISE-NO              TO HOSTVAR-ELEMENT-1      
CBSI          MOVE 'LITE_AVAILABLE_IND'       TO TABLE-ELEMENT-2        
CBSI          MOVE  PR-LITE-AVAILABLE-IND     TO HOSTVAR-ELEMENT-2      
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-3        
CBSI          MOVE  PARM-ACCOUNT-NO           TO HOSTVAR-ELEMENT-3      
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************27770000
      * 7151-UPDATE-ELEC-INFO.                                         *27780000
      *                                                                *27790000
      ******************************************************************27800000
       7151-UPDATE-ELEC-INFO.                                           
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_PREMISE                                       
                  SET ELEC_AVAILABLE_IND = :PR-ELEC-AVAILABLE-IND       
                WHERE PREMISE_NO = :AT-PREMISE-NO                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 S-RETURN-CODE-1.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'UPDATE'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE '7151'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CSS_PREMISE'              TO TABLE-1                
              MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-1        
CBSI          MOVE 'ELEC_AVAILABLE_IND'       TO TABLE-ELEMENT-2        
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-3        
              MOVE AT-PREMISE-NO              TO HOSTVAR-ELEMENT-1      
CBSI          MOVE PR-ELEC-AVAILABLE-IND      TO HOSTVAR-ELEMENT-2      
CBSI          MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-3      
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
       7151-EXIT.                                                       
           EXIT.                                                        
                                                                        
PCR618******************************************************************28140000
      * 7152-UPDATE-GAS-INFO.                                          *28150000
      *                                                                *28160000
      ******************************************************************28170000
       7152-UPDATE-GAS-INFO.                                            
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_PREMISE                                       
                  SET GAS_AVAILABLE_IND = :PR-GAS-AVAILABLE-IND         
                WHERE PREMISE_NO = :AT-PREMISE-NO                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 S-RETURN-CODE-1.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'UPDATE'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE '7152'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CSS_PREMISE'              TO TABLE-1                
              MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-1        
CBSI          MOVE 'GAS_AVAILABLE_IND'        TO TABLE-ELEMENT-2        
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-3        
              MOVE AT-PREMISE-NO              TO HOSTVAR-ELEMENT-1      
CBSI          MOVE PR-GAS-AVAILABLE-IND       TO HOSTVAR-ELEMENT-2      
CBSI          MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-3      
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
       7152-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************28510000
      * 7160-SELECT-ACTIVE-CO-ROWS.                                    *28520000
      *                                                                *28530000
      ******************************************************************28540000
       7160-SELECT-ACTIVE-CP-ROWS.                                      
                                                                        
           MOVE ZERO                        TO WS-ACTIVE-COUNT.         
           EXEC SQL                                                     
               SELECT COUNT(*)                                          
                 INTO :WS-ACTIVE-COUNT                                  
                 FROM CSS_CUST_PLAN WITH(READUNCOMMITTED)                       
                WHERE ACCOUNT_NO = :CP-ACCOUNT-NO                       
                  AND CODE_UTIL_TYPE = :CP-CODE-UTIL-TYPE               
                  AND CODE_PLAN_STATUS = :WS-ACTIVE                     
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     28600000
MFA-TR*        SELECT COUNT(*)                                          28610000
MFA-TR*          INTO :WS-ACTIVE-COUNT                                  28620000
MFA-TR*          FROM CSS_CUST_PLAN                                     28630000
MFA-TR*         WHERE ACCOUNT_NO = :CP-ACCOUNT-NO                       28640000
MFA-TR*           AND CODE_UTIL_TYPE = :CP-CODE-UTIL-TYPE               28650000
MFA-TR*           AND CODE_PLAN_STATUS = :WS-ACTIVE                     28660000
MFA-TR*         WITH UR                                                 28661000
MFA-TR*    END-EXEC.                                                    28670000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7160'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_CUST_PLAN'            TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE CP-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
              MOVE CP-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2      
              MOVE 'CODE_PLAN_STATUS'         TO TABLE-ELEMENT-3        
              MOVE WS-ACTIVE                  TO HOSTVAR-ELEMENT-3      
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
       7160-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************28930000
      * 7165-SELECT-ACTIVE-MN-ROWS.                                    *28940000
      *                                                                *28950000
      ******************************************************************28960000
       7165-SELECT-ACTIVE-MN-ROWS.                                      
                                                                        
           MOVE ZERO                 TO WS-ACTIVE-COUNT.                
                                                                        
           EXEC SQL                                                     
               SELECT COUNT(*)                                          
                 INTO :WS-ACTIVE-COUNT                                  
                 FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO = :CP-ACCOUNT-NO                       
                  AND CODE_UTIL_TYPE = :CP-CODE-UTIL-TYPE               
                  AND CODE_METER_STATUS = :WS-ACTIVE                    
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     29020000
MFA-TR*        SELECT COUNT(*)                                          29030000
MFA-TR*          INTO :WS-ACTIVE-COUNT                                  29040000
MFA-TR*          FROM CSS_MTRD_ENVRNMT                                  29050000
MFA-TR*         WHERE ACCOUNT_NO = :CP-ACCOUNT-NO                       29060000
MFA-TR*           AND CODE_UTIL_TYPE = :CP-CODE-UTIL-TYPE               29070000
MFA-TR*           AND CODE_METER_STATUS = :WS-ACTIVE                    29080000
MFA-TR*         WITH UR                                                 29081000
MFA-TR*    END-EXEC.                                                    29090000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7165'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_MTRD_ENVRNMT'         TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE CP-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
              MOVE CP-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2      
              MOVE 'CODE_METER_STATUS'        TO TABLE-ELEMENT-3        
              MOVE WS-ACTIVE                  TO HOSTVAR-ELEMENT-3      
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
       7165-EXIT.                                                       
           EXIT.                                                        
                                                                        
A05065***************************************************************** 29340100
A05065*                                                               * 29340200
A05065* 7170-GET-CODE-VALUE                                           * 29340300
A05065***************************************************************** 29340400
A05065                                                                  
A05065 7170-GET-CODE-VALUE.                                             
A05065                                                                  
A05065     EXEC SQL                                                     
A05065        SELECT UV.CODE_LONG_DESC                                  
A05065          INTO :UV-CODE-LONG-DESC                                 
A05065          FROM CSS_CODE_VALUE    UV WITH(READUNCOMMITTED)                 
A05065         WHERE UV.CODE_VALUE  = :UV-CODE-VALUE                    
A05065           AND UV.COLUMN_NA   = :UV-COLUMN-NA                     
A05065           AND UV.TABLE_NA    = :UV-TABLE-NA                      
A05065           AND UV.PROGRAM_ID  = :UV-PROGRAM-ID                    
A05065           AND UV.COMPANY_NO  = :UV-COMPANY-NO                    
A05065                                                           
A05065                                                      
A05065     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     29340800
MFA-TR*       SELECT UV.CODE_LONG_DESC                                  29340900
MFA-TR*         INTO :UV-CODE-LONG-DESC                                 29341001
MFA-TR*         FROM CSS_CODE_VALUE    UV                               29341003
MFA-TR*        WHERE UV.CODE_VALUE  = :UV-CODE-VALUE                    29341004
MFA-TR*          AND UV.COLUMN_NA   = :UV-COLUMN-NA                     29341005
MFA-TR*          AND UV.TABLE_NA    = :UV-TABLE-NA                      29341006
MFA-TR*          AND UV.PROGRAM_ID  = :UV-PROGRAM-ID                    29341007
MFA-TR*          AND UV.COMPANY_NO  = :UV-COMPANY-NO                    29341008
MFA-TR*         WITH UR                                                 29341009
MFA-TR*      QUERYNO 7170                                               29341010
MFA-TR*    END-EXEC.                                                    29341011

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05065                                                                  
A05065     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
A05065                                                                  
A05065     EVALUATE WS-ACTIVE-RETURN-CODE                               
A05065         WHEN SUCCESSFUL-CALL                                     
A05065              CONTINUE                                            
A05065         WHEN NOT-FOUND                                           
A05065              MOVE +09                TO UV-CODE-LONG-DESC-LEN    
A05065              MOVE 'NOT FOUND'        TO UV-CODE-LONG-DESC-TEXT   
A05065         WHEN OTHER                                               
A05065              MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
A05065              MOVE '7170'             TO ACTIVE-PARAGRAPH         
A05065              MOVE 'SELECT'           TO ABEND-FUNCTION           
A05065              MOVE SPACES             TO ABEND-SQL-PREDICATES     
A05065                                         ABEND-TABLES             
A05065              MOVE 'CSS_CODE_VALUE'   TO TABLE-1                  
A05065              MOVE 'PROGRAM_ID'       TO TABLE-ELEMENT-1          
A05065              MOVE UV-PROGRAM-ID      TO HOSTVAR-ELEMENT-1        
A05065              MOVE 'CODE_VALUE'       TO TABLE-ELEMENT-2          
A05065              MOVE UV-CODE-VALUE      TO HOSTVAR-ELEMENT-2        
A05065              MOVE 'COLUMN_NA'        TO TABLE-ELEMENT-3          
A05065              MOVE UV-COLUMN-NA       TO HOSTVAR-ELEMENT-3        
A05065              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT        
A05065     END-EVALUATE.                                                
A05065*                                                                 29341036
A05065 7170-EXIT.                                                       
A05065     EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7180-GET-RATE-ITEM-DESC.                                       *        
      ******************************************************************        
       7180-GET-RATE-ITEM-DESC.                                         
                                                                        
           EXEC SQL                                                     
              SELECT L9.UM_EQUIP_SHRT_DESC                              
                INTO :WS-UM-EQUIP-SHRT-DESC                             
                FROM CSS_UNMTR_PLAN   UP                                
                    ,CSS_UM_EQUIPMENT L9                                
               WHERE UP.UM_EQUIP_ID    =  L9.UM_EQUIP_ID                
                 AND UP.CODE_UTIL_TYPE = :UP-CODE-UTIL-TYPE             
                 AND UP.RATE_PLAN_NO   = :UP-RATE-PLAN-NO               
                 AND UP.RATE_ITEM_CODE = :UP-RATE-ITEM-CODE             
                 AND L9.STATUS_CD      = 'A'                            
                 AND UP.VERSION_NO_CNTRL =                              
                        (SELECT MAX(RT.VERSION_NO_CNTRL)                
                           FROM CSS_RATE_CREATOR RT                     
                          WHERE RT.CODE_UTIL_TYPE = :UP-CODE-UTIL-TYPE  
                            AND RT.RATE_PLAN_NO   = :UP-RATE-PLAN-NO    
                            AND RT.CODE_STATUS    = 'A')                
              ORDER BY UP.RATE_ITEM_CODE                                
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7180'                 TO ACTIVE-PARAGRAPH           
              MOVE 'SELECT'               TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSS_UNMTR_PLAN'       TO TABLE-1                    
              MOVE 'CODE_UTIL_TYPE'       TO TABLE-ELEMENT-1            
              MOVE 'RATE_PLAN_NO'         TO TABLE-ELEMENT-2            
              MOVE 'RATE_ITEM_CODE'       TO TABLE-ELEMENT-3            
              MOVE UP-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-1          
              MOVE UP-RATE-PLAN-NO        TO HOSTVAR-ELEMENT-2          
              MOVE UP-RATE-ITEM-CODE      TO HOSTVAR-ELEMENT-3          
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7180-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************29341040
      *                                                                *29342003
      * 7550-GET-RULE-XREF-ID                                          *29343003
      *                                                                *29344003
      ******************************************************************29345003
       7550-GET-RULE-XREF-ID.                                           
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           BUS_RULE_XREF_ID, 121), ' ', '-'), ':', '.') 
           BUS_RULE_XREF_ID                                   
                INTO :S-RS1-BUS-RULE-XREF-ID                            
                FROM CSS_BUS_RULE   [1R] WITH(READUNCOMMITTED)                  
                    ,CSS_BUS_RULE_XREF [1T] WITH(READUNCOMMITTED)               
               WHERE [1R].BUS_RULE_ID = :S-RS1-BUS-RULE-ID                
                 AND [1R].BUS_RULE_ID = [1T].BUS_RULE_ID                    
                                             
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     29348003
MFA-TR*       SELECT BUS_RULE_XREF_ID                                   29349003
MFA-TR*         INTO :S-RS1-BUS-RULE-XREF-ID                            29349103
MFA-TR*         FROM CSS_BUS_RULE   1R                                  29349203
MFA-TR*             ,CSS_BUS_RULE_XREF 1T                               29349303
MFA-TR*        WHERE 1R.BUS_RULE_ID = :S-RS1-BUS-RULE-ID                29349403
MFA-TR*          AND 1R.BUS_RULE_ID = 1T.BUS_RULE_ID                    29349503
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                             29349603
MFA-TR*      QUERYNO 7550                                               29349703
MFA-TR*    END-EXEC                                                     29349803

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
               MOVE SPACES                  TO ABEND-TABLES             
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
               MOVE '7550'                  TO ACTIVE-PARAGRAPH         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_BUS_RULE'          TO TABLE-1                  
               MOVE 'BUS_RULE_ID'           TO TABLE-ELEMENT-1          
               MOVE S-RS1-BUS-RULE-ID       TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************29352000
      * 7700-FETCH-OLD-CUST-CURSOR.                                    *29360000
      *     CALLS       9000-SEND-ERROR-RESULT                         *29370000
      *                 9900-SQL-ERROR-ROUTINE                         *29380000
      *                                                                *29390000
      *     CALLED FROM 5000-UPDATE                                    *29400000
      *                                                                *29410000
      *     FETCHES A ROW FROM THE TABLE CSS_CUST_ALERT    WHERE       *29420000
      *     THE (FULL) KEY IS EQUAL TO THE PASSED PARAMETERS           *29430000
      ******************************************************************29440000
       7700-FETCH-OLD-CUST-CURSOR.                                      
                                                                        
           EXEC SQL                                                     
              FETCH  OLD-CUST-CURSOR                                    
              INTO  :WS-NO-UNITS-OLD                         ,          
                    :WS-DATE-PLAN-START-OLD :WS-OLD-NULL-IND-1,          
                    :WS-LAST-BILL-DATE-OLD :WS-OLD-NULL-IND-2 ,          
                    :WS-MTHLY-AMOUNT-FIXED-OLD               ,          
                    :WS-USAGE-FIXED-OLD                      ,          
                    :WS-CODE-PLAN-STATUS-OLD                 ,          
                    :WS-CODE-STAT-REASON-OLD                 ,          
ACR618              :WS-REMOVE-DATE-OLD :WS-OLD-NULL-IND-3    ,          
A05065              :WS-CODE-SERVICE-TYPE                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-OLD-NULL-IND-1  = -1                                
                 MOVE SPACES                  TO WS-DATE-PLAN-START-OLD 
              END-IF                                                    
              IF WS-OLD-NULL-IND-2  = -1                                
                 MOVE SPACES                  TO WS-LAST-BILL-DATE-OLD  
              END-IF                                                    
              IF WS-OLD-NULL-IND-3  = -1                                
                 MOVE SPACES                  TO WS-REMOVE-DATE-OLD     
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'FETCH'                    TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE '7700'                     TO ACTIVE-PARAGRAPH       
CBSI          MOVE 'CSS_CUST_PLAN'            TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
CBSI          MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
CBSI          MOVE 'IC_NO'                    TO TABLE-ELEMENT-3        
CBSI          MOVE 'RATE_ITEM_CODE'           TO TABLE-ELEMENT-4        
              MOVE CP-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
CBSI          MOVE CP-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2      
CBSI          MOVE CP-IC-NO                   TO HOSTVAR-ELEMENT-3      
CBSI          MOVE WS-OLD-RT-ITEM-CD          TO HOSTVAR-ELEMENT-4      
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************29890000
      * 7710-OPEN-OLD-CUST-CURSOR                                      *29900000
      *     CALLS       9000-SEND-ERROR-RESULT                         *29910000
      *                 9900-SQL-ERROR-ROUTINE                         *29920000
      *                                                                *29930000
      *     CALLED FROM 5000-UPDATE                                    *29940000
      *                                                                *29950000
      *     OPENS THE CURSOR                                           *29960000
      ******************************************************************29970000
                                                                        
       7710-OPEN-OLD-CUST-CURSOR.                                       
                                                                        
           EXEC SQL                                                     
              OPEN OLD-CUST-CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'OPEN'                     TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE '7710'                     TO ACTIVE-PARAGRAPH       
CBSI          MOVE 'CSS_CUST_PLAN'            TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
CBSI          MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
CBSI          MOVE 'IC_NO'                    TO TABLE-ELEMENT-3        
CBSI          MOVE 'RATE_ITEM_CODE'           TO TABLE-ELEMENT-4        
              MOVE CP-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
CBSI          MOVE CP-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2      
CBSI          MOVE CP-IC-NO                   TO HOSTVAR-ELEMENT-3      
CBSI          MOVE WS-OLD-RT-ITEM-CD          TO HOSTVAR-ELEMENT-4      
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
       7710-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************30320000
      * 7720-CLOSE-OLD-CUST-CURSOR                                     *30330000
      *     CALLS       9000-SEND-ERROR-RESULT                         *30340000
      *                 9900-SQL-ERROR-ROUTINE                         *30350000
      *                                                                *30360000
      *     CALLED FROM 5000-UPDATE                                    *30370000
      *                                                                *30380000
      *     CLOSES THE CURSOR                                          *30390000
      ******************************************************************30400000
                                                                        
       7720-CLOSE-OLD-CUST-CURSOR.                                      
                                                                        
           EXEC SQL                                                     
              CLOSE OLD-CUST-CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'CLOSE'                    TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE '7720'                     TO ACTIVE-PARAGRAPH       
CBSI          MOVE 'CSS_CUST_PLAN'            TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
CBSI          MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
CBSI          MOVE 'IC_NO'                    TO TABLE-ELEMENT-3        
CBSI          MOVE 'RATE_ITEM_CODE'           TO TABLE-ELEMENT-4        
              MOVE CP-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
CBSI          MOVE CP-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2      
CBSI          MOVE CP-IC-NO                   TO HOSTVAR-ELEMENT-3      
CBSI          MOVE WS-OLD-RT-ITEM-CD          TO HOSTVAR-ELEMENT-4      
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
                                                                        
       7720-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 30760000
      *                                                               * 30770000
      * 7800-SELECT-TIMESTAMP                                         * 30780000
      *     CALLS 9000-SEND-ERROR-RESULT                              * 30790000
      *           9900-SQL-ERROR-ROUTINE                              * 30800000
      *     CALLED FROM 5400-JRN-TRAN-HEAD                            * 30810000
      ***************************************************************** 30830000
                                                                        
        7800-SELECT-TIMESTAMP.                                          
                                                                        
           EXEC SQL                                                     
T35434        SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :MH-TRANS-HIST-SEQ-NO                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     30870000
MFA-TR*       SET :MH-TRANS-HIST-SEQ-NO                                 30901000
MFA-TR*           = CURRENT TIMESTAMP                                   30902000
MFA-TR*    END-EXEC.                                                    30910000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 S-RETURN-CODE-1.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7800'                     TO ACTIVE-PARAGRAPH       
T35434        MOVE 'SET'                      TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
CBSI          MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
       7800-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ***************************************************************** 31140000
      * 7801-SELECT-DATE                                              * 31150000
      *     CALLS 9000-SEND-ERROR-RESULT                              * 31160000
      *           9900-SQL-ERROR-ROUTINE                              * 31170000
      *     CALLED FROM 5400-JRN-TRAN-HEAD                            * 31180000
      ***************************************************************** 31200000
       7801-SELECT-DATE.                                                
                                                                        
           EXEC SQL                                                     
T35434        SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :MH-DATE-TRANS                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     31230000
MFA-TR*       SET :MH-DATE-TRANS                                        31261000
MFA-TR*            = CURRENT DATE                                       31262000
MFA-TR*    END-EXEC.                                                    31270000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 S-RETURN-CODE-1.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7801'                     TO ACTIVE-PARAGRAPH       
T35434        MOVE 'SET'                      TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
CBSI          MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
       7801-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ***************************************************************** 31500000
      * 7802-SELECT-RESP-AREA                                         * 31510000
      *     CALLS 9000-SEND-ERROR-RESULT                              * 31520000
      *           9900-SQL-ERROR-ROUTINE                              * 31530000
      *     CALLED FROM 5400-JRNL-TRAN-HEAD                           * 31540000
      *     SELECTS CSS_USER_PROFILE                                  * 31550000
      ***************************************************************** 31560000
       7802-SELECT-RESP-AREA.                                           
                                                                        
                                                                        
           EXEC SQL                                                     
              SELECT RESP_AREA_ID                                       
                INTO :WS-RESP-AREA-ID                                   
                FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                     
               WHERE USER_ID = :PF-USER-ID                              
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     31620000
MFA-TR*       SELECT RESP_AREA_ID                                       31630000
MFA-TR*         INTO :WS-RESP-AREA-ID                                   31640000
MFA-TR*         FROM CSS_USER_PROFILE                                   31650000
MFA-TR*        WHERE USER_ID = :PF-USER-ID                              31660000
MFA-TR*        WITH UR                                                  31661000
MFA-TR*    END-EXEC.                                                    31670000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7802'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_USER_PROFILE'         TO TABLE-1                
              MOVE 'USER_ID'                  TO TABLE-ELEMENT-1        
              MOVE PARM-USER-ID               TO HOSTVAR-ELEMENT-1      
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
CBSI          MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-2      
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
       7802-EXIT.                                                       
            EXIT.                                                       
                                                                        
                                                                        
PCR618***************************************************************** 31914000
      * 8103-DELETE-CUST-PLAN                                         * 31920000
      *     CALLS 9000-SEND-ERROR-RESULT                              * 31930000
      *           9900-SQL-ERROR-ROUTINE                              * 31940000
      *                                                               * 31950000
      *     CALLED FROM 5200-UPDATE                                   * 31960000
      *                                                               * 31970000
      *     DELETES CSS_CUST_PLAN                                     * 31980000
      ***************************************************************** 31990000
       8103-DELETE-CUST-PLAN.                                           
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_CUST_PLAN                                 
               WHERE ACCOUNT_NO         = :CP-ACCOUNT-NO                
                 AND CODE_UTIL_TYPE     = :CP-CODE-UTIL-TYPE            
                 AND IC_NO              = :CP-IC-NO                     
                 AND RATE_ITEM_CODE     = :WS-OLD-RT-ITEM-CD            
                 AND ITEM_SEQ_NO        = :CP-ITEM-SEQ-NO               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE 'DELETE'            TO ABEND-FUNCTION                
CBSI          MOVE SPACES              TO ABEND-SQL-PREDICATES          
CBSI                                      ABEND-TABLES                  
              MOVE '8103'              TO ACTIVE-PARAGRAPH              
              MOVE 'CSS_CUST_PLAN'     TO TABLE-1                       
              MOVE 'ACCOUNT_NO    '    TO TABLE-ELEMENT-1               
              MOVE CP-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
              MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-2               
              MOVE CP-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-2             
              MOVE 'IC_NO'             TO TABLE-ELEMENT-3               
              MOVE CP-IC-NO            TO HOSTVAR-ELEMENT-3             
CBSI          MOVE 'RATE_ITEM_CODE'    TO TABLE-ELEMENT-4               
CBSI          MOVE WS-OLD-RT-ITEM-CD   TO HOSTVAR-ELEMENT-4             
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
       8103-EXIT.                                                       
           EXIT.                                                        
                                                                        
A00302***************************************************************** 32981000
A00302* 8110-ROWS-EXIST-FOR-GIVEN-IC                                  * 32982000
A00302*     SELECTS CSS_CUST_PLAN AND LOOK IF ANY ROW EXIST FOR AN    * 32983000
A00302*     IC WITH NO REMOVE DATE                                    * 32984000
A00302***************************************************************** 32985000
A00302 8110-ROWS-EXIST-FOR-GIVEN-IC.                                    
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                 
              INTO                                                      
                  :WS-ROW-EXIST                                         
              FROM                                                      
                  CSS_CUST_PLAN WITH(READUNCOMMITTED)                           
              WHERE                                                     
                  ACCOUNT_NO     = :CP-ACCOUNT-NO                       
              AND IC_NO          = :CP-IC-NO                            
              AND CODE_UTIL_TYPE = :CP-CODE-UTIL-TYPE                   
              AND ITEM_SEQ_NO   <> :CP-ITEM-SEQ-NO                      
              AND ( REMOVE_DATE IS NULL                                 
                 OR REMOVE_DATE  > LAST_BILL_DATE )                     
                                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     32989200
MFA-TR*       SELECT                                                    32989300
MFA-TR*           'Y'                                                   32989400
MFA-TR*       INTO                                                      32989500
MFA-TR*           :WS-ROW-EXIST                                         32989600
MFA-TR*       FROM                                                      32989700
MFA-TR*           CSS_CUST_PLAN                                         32989800
MFA-TR*       WHERE                                                     32989900
MFA-TR*           ACCOUNT_NO     = :CP-ACCOUNT-NO                       32990000
MFA-TR*       AND IC_NO          = :CP-IC-NO                            32990100
MFA-TR*       AND CODE_UTIL_TYPE = :CP-CODE-UTIL-TYPE                   32990200
MFA-TR*       AND ITEM_SEQ_NO   <> :CP-ITEM-SEQ-NO                      32990300
MFA-TR*       AND ( REMOVE_DATE IS NULL                                 32990400
MFA-TR*          OR REMOVE_DATE  > LAST_BILL_DATE )                     32990500
MFA-TR*       FETCH FIRST ROW ONLY                                      32990600
MFA-TR*       WITH UR                                                   32990700
MFA-TR*    END-EXEC.                                                    32990800

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 S-RETURN-CODE-1.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8110'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_CUST_PLAN'            TO TABLE-1                
              MOVE 'ITEM_SEQ_NO'              TO TABLE-ELEMENT-1        
              MOVE CP-ITEM-SEQ-NO             TO HOSTVAR-ELEMENT-1      
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE CP-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
A00302                                                                  
A00302 8110-EXIT.                                                       
A00302      EXIT.                                                       
A00302***************************************************************** 32993100
      * 8200-DELETE-BILLING-DET                                       * 32993200
      *     CALLS 9000-SEND-ERROR-RESULT                              * 32993300
      *           9900-SQL-ERROR-ROUTINE                              * 32993400
      *                                                               * 32993500
      *     CALLED FROM 5200-UPDATE                                   * 32993600
      *                                                               * 32993700
      *     UPDATES CSS_CUST_PLAN                                     * 32993800
      ***************************************************************** 32993900
T26267* START                                                           32994000
       8200-DELETE-BILLING-DET.                                         
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_BILLING_DET                               
               WHERE ACCOUNT_NO         = :BG-ACCOUNT-NO                
                 AND CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE            
                 AND IC_NO              = :BG-IC-NO                     
                 AND REVENUE_MONTH      = 0                             
A00302           AND DATE_ORIG_BILL     IS NULL                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE 'DELETE'            TO ABEND-FUNCTION                
CBSI          MOVE SPACES              TO ABEND-SQL-PREDICATES          
CBSI                                      ABEND-TABLES                  
              MOVE '8200'              TO ACTIVE-PARAGRAPH              
CBSI          MOVE 'CSS_BILLING_DET'   TO TABLE-1                       
              MOVE 'ACCOUNT_NO    '    TO TABLE-ELEMENT-1               
              MOVE BG-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
              MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-2               
              MOVE BG-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-2             
              MOVE 'IC_NO'             TO TABLE-ELEMENT-3               
              MOVE BG-IC-NO            TO HOSTVAR-ELEMENT-3             
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
T26267* END                                                             33340000
      ***************************************************************** 33341001
      *                                                               * 33342001
      * 8000A-DEL-GTT-ROWS                                            * 33343001
      ***************************************************************** 33344001
       8000A-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04650_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     33347001
MFA-TR*        DELETE FROM SESSION.CSR04650_R1                          33348001
MFA-TR*    END-EXEC.                                                    33349001

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1          
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000A'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04650_R1'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       8000A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************33379701
      *                                                                *33379801
      * 8010-INSERT-GTT-R1                                             *33379901
      ******************************************************************33380001
       8010-INSERT-GTT-R1.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04650_R1                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,RATE_ITEM_CODE                                       
                  ,ITEM_SEQ_NO                                          
                  ,ACCOUNT_NO                                           
                  ,BUS_RULE_ID                                          
                  ,BUS_RULE_RESULT_CD                                   
                  ,BUS_RULE_XREF_ID                                     
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-1                                     
                  ,:S-APPL-RETURN-CODE-1                                
                  ,:S-RS1-RATE-ITEM-CODE                                
                  ,:S-RS1-ITEM-SEQ-NO                                   
                  ,:S-RS1-ACCOUNT-NO                                    
                  ,:S-RS1-BUS-RULE-ID                                   
                  ,:S-RS1-BUS-RULE-RESULT-CD                            
                  ,:S-RS1-BUS-RULE-XREF-ID                              
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     33383001
MFA-TR*       INSERT INTO SESSION.CSR04650_R1                           33384001
MFA-TR*          (                                                      33385001
MFA-TR*            RETURN_CODE                                          33386001
MFA-TR*           ,APPL_RETURN_CODE                                     33387001
MFA-TR*           ,RATE_ITEM_CODE                                       33388001
MFA-TR*           ,ITEM_SEQ_NO                                          33389001
MFA-TR*           ,ACCOUNT_NO                                           33389101
MFA-TR*           ,BUS_RULE_ID                                          33389201
MFA-TR*           ,BUS_RULE_RESULT_CD                                   33389301
MFA-TR*           ,BUS_RULE_XREF_ID                                     33389401
MFA-TR*          )                                                      33395001
MFA-TR*       VALUES                                                    33396001
MFA-TR*          (                                                      33397001
MFA-TR*            :S-RETURN-CODE-1                                     33398001
MFA-TR*           ,:S-APPL-RETURN-CODE-1                                33399001
MFA-TR*           ,:S-RS1-RATE-ITEM-CODE                                33399101
MFA-TR*           ,:S-RS1-ITEM-SEQ-NO                                   33399201
MFA-TR*           ,:S-RS1-ACCOUNT-NO                                    33399301
MFA-TR*           ,:S-RS1-BUS-RULE-ID                                   33399401
MFA-TR*           ,:S-RS1-BUS-RULE-RESULT-CD                            33399501
MFA-TR*           ,:S-RS1-BUS-RULE-XREF-ID                              33399601
MFA-TR*          )                                                      33407001
MFA-TR*    END-EXEC.                                                    33408001

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R1 = 'Y'             
              ADD +1                     TO  CTR-ROWS-RS1               
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8010'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE 'Y'                   TO  WS-ERR-INSRT-R1            
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04650_R1'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
        8010-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ***************************************************************** 33445001
      *                                                               * 33446001
      * 8800-CHECK-RESULTS.                                           * 33447001
      ***************************************************************** 33448001
       8800-CHECK-RESULTS.                                              
                                                                        
           IF CTR-ROWS-RS1 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-1                            
              MOVE   0                       TO S-RETURN-CODE-1         
              MOVE 100                       TO S-APPL-RETURN-CODE-1    
              PERFORM 8010-INSERT-GTT-R1     THRU 8010-EXIT             
           END-IF.                                                      
                                                                        
       8800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************33459001
      *                                                                *33459101
      * 8900-SEND-DONE.                                                *33459201
      ******************************************************************33459301
       8900-SEND-DONE.                                                  
                                                                        
           MOVE PROGRAM-NAME          TO ABEND-PROGRAM                  
           MOVE '8900'                TO ACTIVE-PARAGRAPH               
           MOVE 'OPEN'                TO ABEND-FUNCTION                 
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE 'CSR04650_R1'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************33479701
      *                                                                *33479801
      * 9000-SEND-ERROR-RESULT                                         *33479901
      ******************************************************************33480001
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-1.                              
           MOVE WS-ACTIVE-RETURN-CODE       TO ABEND-SQLCODE            
                                               S-RETURN-CODE-1.         
                                                                        
           MOVE WS-APPL-RETURN-CODE         TO S-APPL-RETURN-CODE-1.    
                                                                        
                                                                        
           MOVE SQLERRMC                    TO ABEND-SQLERRMC.          
                                                                        
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'               TO ABEND-FUNCTION           
           END-IF.                                                      
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1        THRU 0100A-EXIT.         
                                                                        
           PERFORM 8010-INSERT-GTT-R1          THRU 8010-EXIT.          
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************33499501
      * 9700-ABEND-PROCESSING.                                         *33499601
      ******************************************************************33499701
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT.             
           PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT.             
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************33506001
      * 9900-SQL-ERROR-ROUTINE.                                        *33507001
      ******************************************************************33508001
           EXEC SQL                                                     33509001
              INCLUDE CPDSP300                                          33509101
           END-EXEC.                                                    33509201
                                                                        
      ******************************************************************33509401
      * 9999-END-PROGRAM.                                              *33509501
      ******************************************************************33509601
       9999-END-PROGRAM.                                                
                                                                        
            PERFORM 8800-CHECK-RESULTS THRU 8800-EXIT                   
            PERFORM 8900-SEND-DONE     THRU 8900-EXIT                   
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
