       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       CSR04649.                                      
COB303 DATE-WRITTEN.     AUGUST 22, 2013                                
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE:  CSR04649              --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--                                                            --         
      *--  CSR04649 :                                                --         
      *--                                                            --         
      *--  RETRIEVE LIGHT DETAIlS TO DISPLAY IN LIGHT DETAILS SCREEN.--         
      *--                                                            --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *--  PARAMETERS                                                --         
      *--                                                            --         
      *--      INPUT                                                 --         
      *--             ACCOUNT_NO          DECIMAL(13)                --         
      *--                                                            --         
      *--      OUT                                                   --         
      *--                                                            --         
      *--            NONE                                            --         
      *--                                                            --         
      *--      INOUT                                                 --         
      *--                                                            --         
      *--            NONE                                            --         
      *--                                                            --         
      *--  RESULT SET                                                --         
      *--                                                            --         
      *--  CSR04649_R1 - LIGHT DETAILS                               --         
      *--                                                            --         
      *--           RETURN_CODE            INTEGER                   --         
      *--          ,APPL_RETURN_CODE       INTEGER                   --         
      *--          ,IC_NO                  SMALLINT                  --         
      *--          ,RATE_PLAN_NO           CHAR(3)                   --         
      *--          ,SECURED_RATE_FL        CHAR(1)                   --         
      *--          ,RATE_ITEM_CODE         SMALLINT                  --         
      *--          ,ITEM_SEQ_NO            SMALLINT                  --         
      *--          ,UM_EQUIP_SHRT_DESC     CHAR(17)                  --         
      *--          ,CODE_PLAN_STATUS       CHAR(1)                   --         
      *--          ,CODE_STAT_REASON       CHAR(1)                   --         
      *--          ,POLE_NO                CHAR(7)                   --         
      *--          ,NO_UNITS               INTEGER                   --         
      *--          ,USAGE_FIXED            DECIMAL(9,0)              --         
      *--          ,MTHLY_AMOUNT_FIXED     DECIMAL(11,2)             --         
      *--          ,DATE_PLAN_START        DATE                      --         
      *--          ,REMOVE_DATE            DATE                      --         
      *--          ,LAST_BILL_DATE         DATE                      --         
      *--          ,UNITS_THRSHLD          SMALLINT                  --         
      *--          ,FXD_USAGE_THRSHLD      SMALLINT                  --         
      *--          ,RATE_UPDT_FL           CHAR(1)                   --         
      *--          ,IS_MAINTAINABLE        CHAR(1)                   --         
      *--                                                            --         
      *--  CSR04649_R2 - BUS RULE DETAILS.                           --         
      *--                                                            --         
      *--           RETURN_CODE            INTEGER                   --         
      *--          ,APPL_RETURN_CODE       INTEGER                   --         
      *--          ,BUS_RULE_ID            CHAR(10)                  --         
      *--          ,BUS_RULE_RESULT_CD     CHAR(10)                  --         
      *--          ,BUS_RULE_XREF_ID       CHAR(26)                  --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                        MODIFICATION LOG                    --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
P00738*--  08/22/2013    MS93554     RETRIEVE LIGHT DETAILS.         --         
      *--                                                            --         
      *----------------------------------------------------------------         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04649'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-START                   PIC X(40) VALUE                    
            'WORKING STORAGE FOR CSR04649 STARTS HERE'.                 
      *                                                                         
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-SUBROUTINE-IDS.                                       
               10  CSRERLOG                 PIC X(8)  VALUE 'CSRERLOG'. 
           05  PROGRAM-NAME                 PIC X(08) VALUE 'CSR04649'. 
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN                   PIC S9(9) COMP VALUE 1.     
           05  CTR-ROWS-RS1                 PIC S9(9) COMP VALUE 0.     
           05  CTR-ROWS-RS2                 PIC S9(9) COMP VALUE 0.     
                                                                        
       01  WS-MISC.                                                     
           05  WS-SQLSTATE                  PIC X(05)  VALUE SPACES.    
           05  WS-GTT-NAME                  PIC X(19)  VALUE SPACES.    
           05  WS-APPL-RETURN-CODE          PIC S9(04) COMP VALUE 0.    
           05  WS-PREV-CODE-UTIL-TYPE       PIC X(01)  VALUE SPACES.    
           05  WS-PREV-IC-NO                PIC S9(04) COMP VALUE 0.    
           05  WS-UNITS-THRSHLD             PIC S9(04) COMP VALUE 0.    
           05  WS-FXD-USAGE-THRSHLD         PIC S9(04) COMP VALUE 0.    
           05  WS-G6-PARM-ACCOUNT-NO        PIC 9(13)  VALUE 0.         
                                                                        
       01  WS-FLAGS.                                                    
           05  WS-YES-NULL                  PIC S9(04) VALUE -1.        
           05  WS-YES                       PIC X(01)  VALUE 'Y'.       
           05  WS-NO                        PIC X(01)  VALUE 'N'.       
           05  WS-ZERO                      PIC S9(04) VALUE 0.         
           05  WS-16                        PIC S9(04) VALUE 16.        
           05  WS-14                        PIC S9(04) VALUE 14.        
                                                                        
       01  WS-NULL-INDICATORS.                                          
           05  WS-NULL-IND-01               PIC S9(04) COMP.            
           05  WS-NULL-IND-02               PIC S9(04) COMP.            
           05  WS-NULL-IND-03               PIC S9(04) COMP.            
                                                                        
       01  WS-CODE-VALUE.                                               
           05  WS-CODE-VALUE-LEN       PIC S9(4) COMP VALUE 5.          
           05  WS-CODE-UTIL-TYPE       PIC X(01) VALUE SPACES.          
           05  FILLER                  PIC X(01) VALUE ''.             
           05  WS-RATE-PLAN-NO         PIC X(03) VALUE SPACES.          
           05  FILLER                  PIC X(05) VALUE SPACES.          
                                                                        
       01  WS-CODE-SHORT-DESC-TEXT.                                     
           05  WS-CODE-SHORT-DESC-TXT  PIC X(01) VALUE SPACES.          
           05  FILLER                  PIC X(14) VALUE SPACES.          
                                                                        
       01  WS-ERR-FLAGS.                                                
           05  WS-ERR-INSRT-R1              PIC X(01) VALUE 'N'.        
           05  WS-ERR-INSRT-R2              PIC X(01) VALUE 'N'.        
                                                                        
       01  WS-SWITCHES.                                                 
           05 WS-NO-MORE-ROWS               PIC X(01) VALUE 'N'.        
              88 NO-MORE-ROWS                         VALUE 'Y'.        
                                                                        
      ****************************************************************          
      *                                                              *          
      *    ERROR PROCESSING VARIABLES                                *          
      ****************************************************************          
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
                                                                        
       01 GTT-RETURN-FIELDS.                                            
      *********************************************************                 
      *   GTT TABLE LAYOUT FOR UNMETERED LIGHTS               *                 
      *********************************************************                 
          05 S-RETURN-CODE                  PIC S9(04) COMP VALUE 0.    
          05 GTT-RETURN-FIELDS-1.                                       
             10 S-RETURN-CODE-1             PIC S9(04) COMP VALUE 0.    
             10 S-APPL-RETURN-CODE-1        PIC S9(04) COMP VALUE 0.    
             10 S-RS1-CODE-UTIL-TYPE        PIC X(01)  VALUE SPACES.    
             10 S-RS1-IC-NO                 PIC S9(04) USAGE COMP.      
             10 S-RS1-RATE-PLAN-NO          PIC X(03)  VALUE SPACES.    
             10 S-RS1-SECURED-RATE-FL       PIC X(01)  VALUE SPACES.    
             10 S-RS1-RATE-ITEM-CODE        PIC S9(04) USAGE COMP.      
             10 S-RS1-ITEM-SEQ-NO           PIC S9(04) USAGE COMP.      
             10 S-RS1-UM-EQUIP-SHRT-DESC    PIC X(17)  VALUE SPACES.    
             10 S-RS1-CODE-PLAN-STATUS      PIC X(01)  VALUE SPACES.    
             10 S-RS1-CODE-STAT-REASON      PIC X(01)  VALUE SPACES.    
             10 S-RS1-POLE-NO               PIC X(07)  VALUE SPACES.    
             10 S-RS1-NO-UNITS              PIC S9(09) USAGE COMP.      
COB305       10 S-RS1-USAGE-FIXED        PIC S9(09)V USAGE COMP-3 
COB305          VALUE 0.   
COB305       10 S-RS1-MTHLY-AMOUNT-FIXED        PIC S9(9)V9(2) 
COB305          USAGE COMP-3 VALUE 0.
             10 S-RS1-DATE-PLAN-START       PIC X(10)  VALUE SPACES.    
             10 S-RS1-REMOVE-DATE           PIC X(10)  VALUE SPACES.    
             10 S-RS1-LAST-BILL-DATE        PIC X(10)  VALUE SPACES.    
             10 S-RS1-UNITS-THRSHLD         PIC S9(04) COMP VALUE 0.    
             10 S-RS1-FXD-USAGE-THRSHLD     PIC S9(04) COMP VALUE 0.    
             10 S-RS1-RATE-UPDT-FL          PIC X(01)  VALUE SPACES.    
             10 S-RS1-IS-MAINTAINABLE       PIC X(01)  VALUE SPACES.    
                                                                        
      *********************************************************                 
      *   GTT TABLE LAYOUT FOR BUS RULE ERROR MESSAGE        *                  
      *********************************************************                 
          05 GTT-RETURN-FIELDS-2.                                       
             10 S-RETURN-CODE-2             PIC S9(04) COMP VALUE 0.    
             10 S-APPL-RETURN-CODE-2        PIC S9(04) COMP VALUE 0.    
             10 S-RS2-BUS-RULE-ID           PIC X(10)  VALUE SPACES.    
             10 S-RS2-BUS-RULE-RESULT-CD    PIC X(10)  VALUE SPACES.    
             10 S-RS2-BUS-RULE-XREF-ID      PIC X(26)  VALUE SPACES.    
                                                                        
      ******************************************************************        
      *               COBOL WORKING STORAGE COPY BOOKS                 *        
      ******************************************************************        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_UTIL_ENVRNMT   UT                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_RATE_PLAN_DESC RD                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRTDESC                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_CUST_PLAN      CP                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCSTPLN                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_UM_EQUIPMENT   L9                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBUMEQP                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_UNMTR_PLAN     UP                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBUMPLAN                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_CODE_VALUE     UV                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCDVALU                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_JOB_PARM       G6                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_DELINQUENCY    C8                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
      ******************************************************************        
      *    ERROR HANDLING                                                       
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    SUPPORTS DB2 AND SQL ERROR CHECKING                         *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *   CURSOR DECLARATION TO FETCH ALL UNMETERED DETAILS BASED      *        
      *   ON ACCOUNT NUMBER.                                           *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
               DECLARE UNMETER_CUR CURSOR FOR                           
                SELECT CP.CODE_UTIL_TYPE                                
                      ,CP.IC_NO                                         
                      ,CP.RATE_ITEM_CODE                                
                      ,CP.ITEM_SEQ_NO                                   
                      ,CP.CODE_PLAN_STATUS                              
                      ,CP.CODE_STAT_REASON                              
                      ,CP.POLE_NO                                       
                      ,CP.NO_UNITS                                      
                      ,CP.USAGE_FIXED                                   
                      ,CP.MTHLY_AMOUNT_FIXED                            
                      ,CP.DATE_PLAN_START                               
                      ,CP.REMOVE_DATE                                   
                      ,CP.LAST_BILL_DATE                                
                  FROM CSS_CUST_PLAN CP WITH(READUNCOMMITTED)                   
                 WHERE CP.ACCOUNT_NO   = :CP-ACCOUNT-NO                 
                   FOR READ ONLY                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE UNMETER_CUR CURSOR FOR                                   
MFA-TR*         SELECT CP.CODE_UTIL_TYPE                                        
MFA-TR*               ,CP.IC_NO                                                 
MFA-TR*               ,CP.RATE_ITEM_CODE                                        
MFA-TR*               ,CP.ITEM_SEQ_NO                                           
MFA-TR*               ,CP.CODE_PLAN_STATUS                                      
MFA-TR*               ,CP.CODE_STAT_REASON                                      
MFA-TR*               ,CP.POLE_NO                                               
MFA-TR*               ,CP.NO_UNITS                                              
MFA-TR*               ,CP.USAGE_FIXED                                           
MFA-TR*               ,CP.MTHLY_AMOUNT_FIXED                                    
MFA-TR*               ,CP.DATE_PLAN_START                                       
MFA-TR*               ,CP.REMOVE_DATE                                           
MFA-TR*               ,CP.LAST_BILL_DATE                                        
MFA-TR*           FROM CSS_CUST_PLAN CP                                         
MFA-TR*          WHERE CP.ACCOUNT_NO   = :CP-ACCOUNT-NO                         
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*        QUERYNO 7000                                                     
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
COB305 01 I-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.               
                                                                        
       PROCEDURE DIVISION USING I-ACCOUNT-NO.                           
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 1000-PROCESS-INPUT       THRU 1000-EXIT.             
           PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT.             
           PERFORM 9999-END-PROGRAM         THRU 9999-EXIT.             
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100A-DECLARE-GTT-R1.                                          *        
      ******************************************************************        
       0100A-DECLARE-GTT-R1.                                            
                                                                        
           MOVE 'SESSION.CSR04649_R1'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04649_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04649_R1
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,CODE_UTIL_TYPE CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,IC_NO                   SMALLINT                    
                   ,RATE_PLAN_NO CHAR(03)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,SECURED_RATE_FL CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,RATE_ITEM_CODE          SMALLINT                    
                   ,ITEM_SEQ_NO             SMALLINT                    
                   ,UM_EQUIP_SHRT_DESC CHAR(17)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,CODE_PLAN_STATUS CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,CODE_STAT_REASON CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,POLE_NO CHAR(07)  COLLATE LATIN1_GENERAL_100_BIN2           
                   ,NO_UNITS                INT                     
                   ,USAGE_FIXED             DECIMAL(9,0)                
                   ,MTHLY_AMOUNT_FIXED      DECIMAL(11,2)               
                   ,DATE_PLAN_START CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,REMOVE_DATE CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,LAST_BILL_DATE CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,UNITS_THRSHLD           SMALLINT                    
                   ,FXD_USAGE_THRSHLD       SMALLINT                    
                   ,RATE_UPDT_FL CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,IS_MAINTAINABLE CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS    THRU 8000A-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100A'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,LTRIM(RTRIM(CODE_UTIL_TYPE))       AS 
           CODE_UTIL_TYPE    
                      ,IC_NO                       AS IC_NO             
                      ,LTRIM(RTRIM(RATE_PLAN_NO))         AS 
           RATE_PLAN_NO      
                      ,LTRIM(RTRIM(SECURED_RATE_FL))      AS 
           SECURED_RATE_FL   
                      ,RATE_ITEM_CODE              AS RATE_ITEM_CODE    
                      ,ITEM_SEQ_NO                 AS ITEM_SEQ_NO       
                      ,LTRIM(RTRIM(UM_EQUIP_SHRT_DESC))   AS 
           RATE_ITEM_DESC    
                      ,LTRIM(RTRIM(CODE_PLAN_STATUS))     AS 
           CODE_PLAN_STATUS  
                      ,LTRIM(RTRIM(CODE_STAT_REASON))     AS 
           CODE_STAT_REASON  
                      ,LTRIM(RTRIM(POLE_NO))              AS POLE_NO           
                      ,NO_UNITS                    AS NO_UNITS          
                      ,USAGE_FIXED                 AS USAGE_FIXED       
                      ,MTHLY_AMOUNT_FIXED          AS MTHLY_AMOUNT_FIXED
                      ,LTRIM(RTRIM(DATE_PLAN_START))      AS 
           DATE_PLAN_START   
                      ,LTRIM(RTRIM(REMOVE_DATE))          AS REMOVE_DATE       
                      ,LTRIM(RTRIM(LAST_BILL_DATE))       AS 
           LAST_BILL_DATE    
                      ,UNITS_THRSHLD               AS UNITS_THRSHLD     
                      ,FXD_USAGE_THRSHLD           AS FXD_USAGE_THRSHLD 
                      ,LTRIM(RTRIM(RATE_UPDT_FL))         AS 
           RATE_UPDT_FL      
                      ,LTRIM(RTRIM(IS_MAINTAINABLE))      AS 
           IS_MAINTAINABLE   
                  FROM #CSR04649_R1                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,STRIP(CODE_UTIL_TYPE)       AS CODE_UTIL_TYPE            
MFA-TR*               ,IC_NO                       AS IC_NO                     
MFA-TR*               ,STRIP(RATE_PLAN_NO)         AS RATE_PLAN_NO              
MFA-TR*               ,STRIP(SECURED_RATE_FL)      AS SECURED_RATE_FL           
MFA-TR*               ,RATE_ITEM_CODE              AS RATE_ITEM_CODE            
MFA-TR*               ,ITEM_SEQ_NO                 AS ITEM_SEQ_NO               
MFA-TR*               ,STRIP(UM_EQUIP_SHRT_DESC)   AS RATE_ITEM_DESC            
MFA-TR*               ,STRIP(CODE_PLAN_STATUS)     AS CODE_PLAN_STATUS          
MFA-TR*               ,STRIP(CODE_STAT_REASON)     AS CODE_STAT_REASON          
MFA-TR*               ,STRIP(POLE_NO)              AS POLE_NO                   
MFA-TR*               ,NO_UNITS                    AS NO_UNITS                  
MFA-TR*               ,USAGE_FIXED                 AS USAGE_FIXED               
MFA-TR*               ,MTHLY_AMOUNT_FIXED          AS MTHLY_AMOUNT_FIXED        
MFA-TR*               ,STRIP(DATE_PLAN_START)      AS DATE_PLAN_START           
MFA-TR*               ,STRIP(REMOVE_DATE)          AS REMOVE_DATE               
MFA-TR*               ,STRIP(LAST_BILL_DATE)       AS LAST_BILL_DATE            
MFA-TR*               ,UNITS_THRSHLD               AS UNITS_THRSHLD             
MFA-TR*               ,FXD_USAGE_THRSHLD           AS FXD_USAGE_THRSHLD         
MFA-TR*               ,STRIP(RATE_UPDT_FL)         AS RATE_UPDT_FL              
MFA-TR*               ,STRIP(IS_MAINTAINABLE)      AS IS_MAINTAINABLE           
MFA-TR*           FROM SESSION.CSR04649_R1                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100B-DECLARE-GTT-R2.                                          *        
      ******************************************************************        
       0100B-DECLARE-GTT-R2.                                            
                                                                        
           MOVE 'SESSION.CSR04649_R2'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04649_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04649_R2
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,BUS_RULE_ID CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BUS_RULE_RESULT_CD CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BUS_RULE_XREF_ID CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000B-DEL-GTT-ROWS    THRU 8000B-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100B'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C2 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,LTRIM(RTRIM(BUS_RULE_ID))          AS BUS_RULE_ID       
                      ,LTRIM(RTRIM(BUS_RULE_RESULT_CD))   AS 
           BUS_RULE_RESULT_CD
                      ,LTRIM(RTRIM(BUS_RULE_XREF_ID))     AS 
           BUS_RULE_XREF_ID  
                  FROM #CSR04649_R2                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C2 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,STRIP(BUS_RULE_ID)          AS BUS_RULE_ID               
MFA-TR*               ,STRIP(BUS_RULE_RESULT_CD)   AS BUS_RULE_RESULT_CD        
MFA-TR*               ,STRIP(BUS_RULE_XREF_ID)     AS BUS_RULE_XREF_ID          
MFA-TR*           FROM SESSION.CSR04649_R2                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100B-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE I-ACCOUNT-NO                TO CP-ACCOUNT-NO            
                                               UT-ACCOUNT-NO.           
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1        THRU 0100A-EXIT.         
           PERFORM 0100B-DECLARE-GTT-R2        THRU 0100B-EXIT.         
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2000-PROCESS-OUTPUT                                            *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2050-GET-DELINQ-VALUE       THRU 2050-EXIT.          
           PERFORM 7000-OPEN-UNMETER-CUR       THRU 7000-EXIT.          
           PERFORM 7010-FETCH-UNMETER-CUR      THRU 7010-EXIT.          
           PERFORM 2100-BUILD-RESULT-SET       THRU 2100-EXIT           
                                               UNTIL NO-MORE-ROWS.      
           PERFORM 7020-CLOSE-UNMETER-CUR      THRU 7020-EXIT.          
                                                                        
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2050-GET-DELINQ-VALUE.                                         *        
      ******************************************************************        
       2050-GET-DELINQ-VALUE.                                           
                                                                        
           MOVE '01'                        TO C8-COMPANY-NO.           
                                                                        
           MOVE 'UNMTD-UNITS-THRSHLD'       TO C8-DELINQ-CD.            
           PERFORM 7500-SELECT-DELINQUENCY                              
                                               THRU 7500-EXIT.          
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE C8-DELINQ-VALUE          TO WS-UNITS-THRSHLD         
           ELSE                                                         
              MOVE ZEROS                    TO WS-UNITS-THRSHLD         
           END-IF.                                                      
                                                                        
           MOVE ZEROS                       TO C8-DELINQ-VALUE.         
                                                                        
           MOVE 'UNMTD-FXDUSG-THRSHLD'      TO C8-DELINQ-CD.            
           PERFORM 7500-SELECT-DELINQUENCY                              
                                               THRU 7500-EXIT.          
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE C8-DELINQ-VALUE          TO WS-FXD-USAGE-THRSHLD     
           ELSE                                                         
              MOVE ZEROS                    TO WS-FXD-USAGE-THRSHLD     
           END-IF.                                                      
                                                                        
        2050-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2100-BUILD-RESULT-SET.                                         *        
      ******************************************************************        
       2100-BUILD-RESULT-SET.                                           
                                                                        
      *    GET RATE PLAN NO & SECURED RATE FLAG.                                
           MOVE CP-CODE-UTIL-TYPE           TO UT-CODE-UTIL-TYPE        
                                               UP-CODE-UTIL-TYPE.       
           MOVE CP-IC-NO                    TO UT-IC-NO.                
           IF UT-CODE-UTIL-TYPE NOT EQUAL WS-PREV-CODE-UTIL-TYPE        
              OR UT-IC-NO NOT EQUAL WS-PREV-IC-NO                       
              PERFORM 7100-GET-RATE-PLAN-NO    THRU 7100-EXIT           
              MOVE UT-CODE-UTIL-TYPE        TO WS-PREV-CODE-UTIL-TYPE   
              MOVE UT-IC-NO                 TO WS-PREV-IC-NO            
           END-IF.                                                      
                                                                        
      *    GET RATE ITEM CODE DESCRIPTION.                                      
           MOVE UT-RATE-PLAN-NO             TO UP-RATE-PLAN-NO          
           MOVE CP-RATE-ITEM-CODE           TO UP-RATE-ITEM-CODE.       
           PERFORM 7200-GET-RATE-ITEM-DESC     THRU 7200-EXIT           
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              MOVE SPACES                   TO L9-UM-EQUIP-SHRT-DESC    
           END-IF.                                                      
                                                                        
           MOVE UT-CODE-UTIL-TYPE           TO WS-CODE-UTIL-TYPE.       
           MOVE UT-RATE-PLAN-NO             TO WS-RATE-PLAN-NO.         
           MOVE WS-CODE-VALUE               TO UV-CODE-VALUE.           
           MOVE PROGRAM-NAME                TO UV-PROGRAM-ID.           
           MOVE WS-16                       TO UV-COLUMN-NA-LEN.        
           MOVE 'UI_VIEW_MAINTAIN'          TO UV-COLUMN-NA-TEXT.       
           MOVE WS-14                       TO UV-TABLE-NA-LEN.         
           MOVE 'CSS_UNMTR_PLAN'            TO UV-TABLE-NA-TEXT.        
                                                                        
           PERFORM 7300-GET-CODE-VALUE         THRU 7300-EXIT.          
                                                                        
           MOVE ZERO                        TO S-RETURN-CODE-1.         
           MOVE UV-CODE-SHORT-DESC-TEXT     TO WS-CODE-SHORT-DESC-TEXT. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF WS-CODE-SHORT-DESC-TXT = 'Y'                           
                 MOVE 'N'                   TO S-RS1-IS-MAINTAINABLE    
              ELSE                                                      
                 MOVE 'Y'                   TO S-RS1-IS-MAINTAINABLE    
              END-IF                                                    
           ELSE                                                         
              MOVE 'Y'                      TO S-RS1-IS-MAINTAINABLE    
           END-IF.                                                      
                                                                        
           MOVE SPACES                      TO UV-CODE-SHORT-DESC-TEXT  
                                               WS-CODE-SHORT-DESC-TEXT. 
                                                                        
           MOVE 'N'                         TO S-RS1-RATE-UPDT-FL.      
           MOVE PROGRAM-NAME                TO G6-PROGRAM-NAME.         
           MOVE '01'                        TO G6-COMPANY-NO.           
           MOVE 'PARM'                      TO G6-CMND-CODE.            
           MOVE 'A'                         TO G6-STATUS.               
           MOVE 01                          TO G6-SEQ-NO.               
                                                                        
           PERFORM 7400-SELECT-JOB-PARM           THRU 7400-EXIT.       
                                                                        
           MOVE ZERO                        TO S-RETURN-CODE-1.         
           MOVE G6-PARM-DATA(1:13)          TO WS-G6-PARM-ACCOUNT-NO.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL AND               
              WS-G6-PARM-ACCOUNT-NO = UT-ACCOUNT-NO                     
              MOVE 'Y'                      TO S-RS1-RATE-UPDT-FL       
           END-IF.                                                      
                                                                        
           PERFORM 6000-MOVE-RATE-RS1          THRU 6000-EXIT.          
           PERFORM 7010-FETCH-UNMETER-CUR      THRU 7010-EXIT.          
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 6000-MOVE-RATE-RS1.                                            *        
      ******************************************************************        
       6000-MOVE-RATE-RS1.                                              
                                                                        
           MOVE CP-CODE-UTIL-TYPE           TO S-RS1-CODE-UTIL-TYPE     
           MOVE CP-IC-NO                    TO S-RS1-IC-NO              
           MOVE UT-RATE-PLAN-NO             TO S-RS1-RATE-PLAN-NO       
           MOVE RD-SECURED-RATE-FL          TO S-RS1-SECURED-RATE-FL    
           MOVE CP-RATE-ITEM-CODE           TO S-RS1-RATE-ITEM-CODE     
           MOVE CP-ITEM-SEQ-NO              TO S-RS1-ITEM-SEQ-NO        
           MOVE L9-UM-EQUIP-SHRT-DESC       TO S-RS1-UM-EQUIP-SHRT-DESC 
           MOVE CP-CODE-PLAN-STATUS         TO S-RS1-CODE-PLAN-STATUS   
           MOVE CP-CODE-STAT-REASON         TO S-RS1-CODE-STAT-REASON   
           MOVE CP-POLE-NO                  TO S-RS1-POLE-NO            
           MOVE CP-NO-UNITS                 TO S-RS1-NO-UNITS           
           MOVE CP-USAGE-FIXED              TO S-RS1-USAGE-FIXED        
           MOVE CP-MTHLY-AMOUNT-FIXED       TO S-RS1-MTHLY-AMOUNT-FIXED 
           MOVE CP-DATE-PLAN-START          TO S-RS1-DATE-PLAN-START    
           MOVE CP-REMOVE-DATE              TO S-RS1-REMOVE-DATE        
           MOVE CP-LAST-BILL-DATE           TO S-RS1-LAST-BILL-DATE     
           MOVE WS-UNITS-THRSHLD            TO S-RS1-UNITS-THRSHLD      
           MOVE WS-FXD-USAGE-THRSHLD        TO S-RS1-FXD-USAGE-THRSHLD  
                                                                        
           PERFORM 8010-INSERT-GTT-R1          THRU 8010-EXIT.          
           INITIALIZE GTT-RETURN-FIELDS-1.                              
                                                                        
       6000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7000-OPEN-UNMETER-CUR.                                         *        
      ******************************************************************        
       7000-OPEN-UNMETER-CUR.                                           
                                                                        
           EXEC SQL                                                     
                OPEN UNMETER_CUR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7000'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_CUST_PLAN'       TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE CP-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7010-FETCH-UNMETER-CUR.                                        *        
      ******************************************************************        
       7010-FETCH-UNMETER-CUR.                                          
                                                                        
           EXEC SQL                                                     
               FETCH UNMETER_CUR                                        
                INTO :CP-CODE-UTIL-TYPE                                 
                    ,:CP-IC-NO                                          
                    ,:CP-RATE-ITEM-CODE                                 
                    ,:CP-ITEM-SEQ-NO                                    
                    ,:CP-CODE-PLAN-STATUS                               
                    ,:CP-CODE-STAT-REASON                               
                    ,:CP-POLE-NO                                        
                    ,:CP-NO-UNITS                                       
                    ,:CP-USAGE-FIXED                                    
                    ,:CP-MTHLY-AMOUNT-FIXED                             
                    ,:CP-DATE-PLAN-START :WS-NULL-IND-01                 
                    ,:CP-REMOVE-DATE :WS-NULL-IND-02                     
                    ,:CP-LAST-BILL-DATE :WS-NULL-IND-03                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1          
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    IF WS-NULL-IND-01 = WS-YES-NULL                     
                       MOVE SPACES          TO CP-DATE-PLAN-START       
                    END-IF                                              
                    IF WS-NULL-IND-02 = WS-YES-NULL                     
                       MOVE SPACES          TO CP-REMOVE-DATE           
                    END-IF                                              
                    IF WS-NULL-IND-03 = WS-YES-NULL                     
                       MOVE SPACES          TO CP-LAST-BILL-DATE        
                    END-IF                                              
               WHEN NOT-FOUND                                           
                    MOVE 'Y'                TO WS-NO-MORE-ROWS          
                    MOVE 0                  TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE '7010'             TO ACTIVE-PARAGRAPH         
                    MOVE 'FETCH'            TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSS_CUST_PLAN'    TO TABLE-1                  
                    MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1          
                    MOVE CP-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7020-CLOSE-UNMETER-CUR.                                        *        
      ******************************************************************        
       7020-CLOSE-UNMETER-CUR.                                          
                                                                        
           EXEC SQL                                                     
                CLOSE UNMETER_CUR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7020'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_CUST_PLAN'          TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE CP-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7100-GET-RATE-PLAN-NO.                                        *         
      *****************************************************************         
       7100-GET-RATE-PLAN-NO.                                           
                                                                        
           EXEC SQL                                                     
              SELECT UT.RATE_PLAN_NO                                    
                    ,RD.SECURED_RATE_FL                                 
                INTO :UT-RATE-PLAN-NO                                   
                    ,:RD-SECURED-RATE-FL                                
                FROM CSS_UTIL_ENVRNMT   UT WITH(READUNCOMMITTED)                
                    ,CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED)                
               WHERE UT.ACCOUNT_NO     = :UT-ACCOUNT-NO                 
                 AND UT.CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE             
                 AND UT.IC_NO          = :UT-IC-NO                      
                 AND UT.RATE_PLAN_NO   = RD.RATE_PLAN_NO                
                 AND UT.CODE_UTIL_TYPE = RD.CODE_UTIL_TYPE              
                                                                 
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT UT.RATE_PLAN_NO                                            
MFA-TR*             ,RD.SECURED_RATE_FL                                         
MFA-TR*         INTO :UT-RATE-PLAN-NO                                           
MFA-TR*             ,:RD-SECURED-RATE-FL                                        
MFA-TR*         FROM CSS_UTIL_ENVRNMT   UT                                      
MFA-TR*             ,CSS_RATE_PLAN_DESC RD                                      
MFA-TR*        WHERE UT.ACCOUNT_NO     = :UT-ACCOUNT-NO                         
MFA-TR*          AND UT.CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE                     
MFA-TR*          AND UT.IC_NO          = :UT-IC-NO                              
MFA-TR*          AND UT.RATE_PLAN_NO   = RD.RATE_PLAN_NO                        
MFA-TR*          AND UT.CODE_UTIL_TYPE = RD.CODE_UTIL_TYPE                      
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7100'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_UTIL_ENVRNMT'       TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE UT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE UT-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE UT-IC-NO                 TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7200-GET-RATE-ITEM-DESC.                                       *        
      ******************************************************************        
       7200-GET-RATE-ITEM-DESC.                                         
                                                                        
           EXEC SQL                                                     
              SELECT L9.UM_EQUIP_SHRT_DESC                              
                INTO :L9-UM-EQUIP-SHRT-DESC                             
                FROM CSS_UM_EQUIPMENT L9                                
                    ,CSS_UNMTR_PLAN UP                                  
               WHERE UP.UM_EQUIP_ID    =  L9.UM_EQUIP_ID                
                 AND UP.CODE_UTIL_TYPE = :UP-CODE-UTIL-TYPE             
                 AND UP.RATE_PLAN_NO   = :UP-RATE-PLAN-NO               
                 AND UP.RATE_ITEM_CODE = :UP-RATE-ITEM-CODE             
                 AND L9.STATUS_CD      = 'A'                            
                 AND UP.VERSION_NO_CNTRL =                              
                        (SELECT MAX(RT.VERSION_NO_CNTRL)                
                           FROM CSS_RATE_CREATOR RT                     
                          WHERE RT.CODE_UTIL_TYPE = :UP-CODE-UTIL-TYPE  
                            AND RT.RATE_PLAN_NO   = :UP-RATE-PLAN-NO    
                            AND RT.CODE_STATUS    = 'A')                
              ORDER BY UP.RATE_ITEM_CODE                                
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7200'                 TO ACTIVE-PARAGRAPH           
              MOVE 'SELECT'               TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSS_UNMTR_PLAN'       TO TABLE-1                    
              MOVE 'CODE_UTIL_TYPE'       TO TABLE-ELEMENT-1            
              MOVE 'RATE_PLAN_NO'         TO TABLE-ELEMENT-2            
              MOVE 'RATE_ITEM_CODE'       TO TABLE-ELEMENT-3            
              MOVE UP-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-1          
              MOVE UP-RATE-PLAN-NO        TO HOSTVAR-ELEMENT-2          
              MOVE UP-RATE-ITEM-CODE      TO HOSTVAR-ELEMENT-3          
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7300-GET-CODE-VALUE                                           *         
      *****************************************************************         
                                                                        
       7300-GET-CODE-VALUE.                                             
                                                                        
           EXEC SQL                                                     
              SELECT UV.CODE_SHORT_DESC                                 
              INTO  :UV-CODE-SHORT-DESC                                 
              FROM  CSS_CODE_VALUE    UV WITH(READUNCOMMITTED)                  
              WHERE UV.CODE_VALUE  = :UV-CODE-VALUE                     
              AND   UV.COLUMN_NA   = :UV-COLUMN-NA                      
              AND   UV.TABLE_NA    = :UV-TABLE-NA                       
              AND   UV.PROGRAM_ID  = :UV-PROGRAM-ID                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT UV.CODE_SHORT_DESC                                         
MFA-TR*       INTO  :UV-CODE-SHORT-DESC                                         
MFA-TR*       FROM  CSS_CODE_VALUE    UV                                        
MFA-TR*       WHERE UV.CODE_VALUE  = :UV-CODE-VALUE                             
MFA-TR*       AND   UV.COLUMN_NA   = :UV-COLUMN-NA                              
MFA-TR*       AND   UV.TABLE_NA    = :UV-TABLE-NA                               
MFA-TR*       AND   UV.PROGRAM_ID  = :UV-PROGRAM-ID                             
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7300                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7300'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_CODE_VALUE'         TO TABLE-1                  
              MOVE 'PROGRAM_ID'             TO TABLE-ELEMENT-1          
              MOVE UV-PROGRAM-ID            TO HOSTVAR-ELEMENT-1        
              MOVE 'CODE_VALUE'             TO TABLE-ELEMENT-2          
              MOVE UV-CODE-VALUE            TO HOSTVAR-ELEMENT-2        
              MOVE 'COLUMN_NA'              TO TABLE-ELEMENT-3          
              MOVE UV-COLUMN-NA             TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *                                                                *        
      * 7400-SELECT-JOB-PARM                                           *        
      ******************************************************************        
       7400-SELECT-JOB-PARM.                                            
      *                                                                         
           EXEC SQL                                                     
             SELECT G6.PARM_DATA                                        
               INTO :G6-PARM-DATA                                       
               FROM CSS_JOB_PARM       G6                               
              WHERE G6.PROGRAM_NAME = :G6-PROGRAM-NAME                  
                AND G6.COMPANY_NO   = :G6-COMPANY-NO                    
                AND G6.CMND_CODE    = :G6-CMND-CODE                     
                AND G6.STATUS       = :G6-STATUS                        
                AND G6.SEQ_NO       = :G6-SEQ-NO                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_JOB_PARM'           TO TABLE-1                  
              MOVE 'PROGRAM_NAME'           TO TABLE-ELEMENT-1          
              MOVE G6-PROGRAM-NAME          TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7500-SELECT-DELINQUENCY                                        *        
      ******************************************************************        
       7500-SELECT-DELINQUENCY.                                         
      *                                                                         
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE DELINQ_CD  = :C8-DELINQ-CD                         
                 AND COMPANY_NO = :C8-COMPANY-NO                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD  = :C8-DELINQ-CD                                 
MFA-TR*          AND COMPANY_NO = :C8-COMPANY-NO                                
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7500                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_DELINQUENCY'        TO TABLE-1                  
              MOVE 'PROGRAM_NAME'           TO TABLE-ELEMENT-1          
              MOVE C8-DELINQ-CD             TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8000A-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000A-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04649_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04649_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1          
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000A'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04649_R1'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       8000A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8000B-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000B-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04649_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04649_R2                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-2.         
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-2          
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000B'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04649_R2'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       8000B-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8010-INSERT-GTT-R1.   OFFER CODE TABLE                         *        
      ******************************************************************        
       8010-INSERT-GTT-R1.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04649_R1                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,CODE_UTIL_TYPE                                       
                  ,IC_NO                                                
                  ,RATE_PLAN_NO                                         
                  ,SECURED_RATE_FL                                      
                  ,RATE_ITEM_CODE                                       
                  ,ITEM_SEQ_NO                                          
                  ,UM_EQUIP_SHRT_DESC                                   
                  ,CODE_PLAN_STATUS                                     
                  ,CODE_STAT_REASON                                     
                  ,POLE_NO                                              
                  ,NO_UNITS                                             
                  ,USAGE_FIXED                                          
                  ,MTHLY_AMOUNT_FIXED                                   
                  ,DATE_PLAN_START                                      
                  ,REMOVE_DATE                                          
                  ,LAST_BILL_DATE                                       
                  ,UNITS_THRSHLD                                        
                  ,FXD_USAGE_THRSHLD                                    
                  ,RATE_UPDT_FL                                         
                  ,IS_MAINTAINABLE                                      
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-1                                     
                  ,:S-APPL-RETURN-CODE-1                                
                  ,:S-RS1-CODE-UTIL-TYPE                                
                  ,:S-RS1-IC-NO                                         
                  ,:S-RS1-RATE-PLAN-NO                                  
                  ,:S-RS1-SECURED-RATE-FL                               
                  ,:S-RS1-RATE-ITEM-CODE                                
                  ,:S-RS1-ITEM-SEQ-NO                                   
                  ,:S-RS1-UM-EQUIP-SHRT-DESC                            
                  ,:S-RS1-CODE-PLAN-STATUS                              
                  ,:S-RS1-CODE-STAT-REASON                              
                  ,:S-RS1-POLE-NO                                       
                  ,:S-RS1-NO-UNITS                                      
                  ,:S-RS1-USAGE-FIXED                                   
                  ,:S-RS1-MTHLY-AMOUNT-FIXED                            
                  ,:S-RS1-DATE-PLAN-START                               
                  ,:S-RS1-REMOVE-DATE                                   
                  ,:S-RS1-LAST-BILL-DATE                                
                  ,:S-RS1-UNITS-THRSHLD                                 
                  ,:S-RS1-FXD-USAGE-THRSHLD                             
                  ,:S-RS1-RATE-UPDT-FL                                  
                  ,:S-RS1-IS-MAINTAINABLE                               
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04649_R1                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,CODE_UTIL_TYPE                                               
MFA-TR*           ,IC_NO                                                        
MFA-TR*           ,RATE_PLAN_NO                                                 
MFA-TR*           ,SECURED_RATE_FL                                              
MFA-TR*           ,RATE_ITEM_CODE                                               
MFA-TR*           ,ITEM_SEQ_NO                                                  
MFA-TR*           ,UM_EQUIP_SHRT_DESC                                           
MFA-TR*           ,CODE_PLAN_STATUS                                             
MFA-TR*           ,CODE_STAT_REASON                                             
MFA-TR*           ,POLE_NO                                                      
MFA-TR*           ,NO_UNITS                                                     
MFA-TR*           ,USAGE_FIXED                                                  
MFA-TR*           ,MTHLY_AMOUNT_FIXED                                           
MFA-TR*           ,DATE_PLAN_START                                              
MFA-TR*           ,REMOVE_DATE                                                  
MFA-TR*           ,LAST_BILL_DATE                                               
MFA-TR*           ,UNITS_THRSHLD                                                
MFA-TR*           ,FXD_USAGE_THRSHLD                                            
MFA-TR*           ,RATE_UPDT_FL                                                 
MFA-TR*           ,IS_MAINTAINABLE                                              
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-1                                             
MFA-TR*           ,:S-APPL-RETURN-CODE-1                                        
MFA-TR*           ,:S-RS1-CODE-UTIL-TYPE                                        
MFA-TR*           ,:S-RS1-IC-NO                                                 
MFA-TR*           ,:S-RS1-RATE-PLAN-NO                                          
MFA-TR*           ,:S-RS1-SECURED-RATE-FL                                       
MFA-TR*           ,:S-RS1-RATE-ITEM-CODE                                        
MFA-TR*           ,:S-RS1-ITEM-SEQ-NO                                           
MFA-TR*           ,:S-RS1-UM-EQUIP-SHRT-DESC                                    
MFA-TR*           ,:S-RS1-CODE-PLAN-STATUS                                      
MFA-TR*           ,:S-RS1-CODE-STAT-REASON                                      
MFA-TR*           ,:S-RS1-POLE-NO                                               
MFA-TR*           ,:S-RS1-NO-UNITS                                              
MFA-TR*           ,:S-RS1-USAGE-FIXED                                           
MFA-TR*           ,:S-RS1-MTHLY-AMOUNT-FIXED                                    
MFA-TR*           ,:S-RS1-DATE-PLAN-START                                       
MFA-TR*           ,:S-RS1-REMOVE-DATE                                           
MFA-TR*           ,:S-RS1-LAST-BILL-DATE                                        
MFA-TR*           ,:S-RS1-UNITS-THRSHLD                                         
MFA-TR*           ,:S-RS1-FXD-USAGE-THRSHLD                                     
MFA-TR*           ,:S-RS1-RATE-UPDT-FL                                          
MFA-TR*           ,:S-RS1-IS-MAINTAINABLE                                       
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R1 = 'Y'             
              ADD +1                     TO  CTR-ROWS-RS1               
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8010'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE 'Y'                   TO  WS-ERR-INSRT-R1            
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04649_R1'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
        8010-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8020-INSERT-GTT-R2.                                            *        
      ******************************************************************        
       8020-INSERT-GTT-R2.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04649_R2                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,BUS_RULE_ID                                          
                  ,BUS_RULE_RESULT_CD                                   
                  ,BUS_RULE_XREF_ID                                     
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-2                                     
                  ,:S-APPL-RETURN-CODE-2                                
                  ,:S-RS2-BUS-RULE-ID                                   
                  ,:S-RS2-BUS-RULE-RESULT-CD                            
                  ,:S-RS2-BUS-RULE-XREF-ID                              
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04649_R2                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,BUS_RULE_ID                                                  
MFA-TR*           ,BUS_RULE_RESULT_CD                                           
MFA-TR*           ,BUS_RULE_XREF_ID                                             
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-2                                             
MFA-TR*           ,:S-APPL-RETURN-CODE-2                                        
MFA-TR*           ,:S-RS2-BUS-RULE-ID                                           
MFA-TR*           ,:S-RS2-BUS-RULE-RESULT-CD                                    
MFA-TR*           ,:S-RS2-BUS-RULE-XREF-ID                                      
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R2 = 'Y'             
              ADD +1                     TO  CTR-ROWS-RS2               
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8020'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE 'Y'                   TO  WS-ERR-INSRT-R2            
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04649_R2'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
        8020-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8800-CHECK-RESULTS.                                           *         
      *****************************************************************         
       8800-CHECK-RESULTS.                                              
                                                                        
           IF CTR-ROWS-RS1 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-1                            
              MOVE 100                       TO S-RETURN-CODE-1         
              MOVE 0                         TO S-APPL-RETURN-CODE-1    
              PERFORM 8010-INSERT-GTT-R1     THRU 8010-EXIT             
           END-IF.                                                      
                                                                        
           IF CTR-ROWS-RS2 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-2                            
              MOVE 100                       TO S-RETURN-CODE-2         
              MOVE 0                         TO S-APPL-RETURN-CODE-2    
              PERFORM 8020-INSERT-GTT-R2     THRU 8020-EXIT             
           END-IF.                                                      
                                                                        
       8800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8900-SEND-DONE.                                                *        
      ******************************************************************        
       8900-SEND-DONE.                                                  
                                                                        
           MOVE PROGRAM-NAME          TO ABEND-PROGRAM                  
           MOVE '8900'                TO ACTIVE-PARAGRAPH               
           MOVE 'OPEN'                TO ABEND-FUNCTION                 
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE 'CSR04649_R1'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C2                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE 'CSR04649_R2'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 9000-SEND-ERROR-RESULT                                         *        
      ******************************************************************        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE       TO ABEND-SQLCODE            
                                               S-RETURN-CODE-1          
                                               S-RETURN-CODE-2.         
                                                                        
           MOVE WS-APPL-RETURN-CODE         TO S-APPL-RETURN-CODE-1     
                                               S-APPL-RETURN-CODE-2.    
                                                                        
                                                                        
           MOVE SQLERRMC                    TO ABEND-SQLERRMC.          
                                                                        
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'               TO ABEND-FUNCTION           
           END-IF.                                                      
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1        THRU 0100A-EXIT.         
           PERFORM 0100B-DECLARE-GTT-R2        THRU 0100B-EXIT.         
                                                                        
           PERFORM 8010-INSERT-GTT-R1          THRU 8010-EXIT.          
           PERFORM 8020-INSERT-GTT-R2          THRU 8020-EXIT.          
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9700-ABEND-PROCESSING.                                         *        
      ******************************************************************        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT.             
           PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT.             
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900-SQL-ERROR-ROUTINE.                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9999-END-PROGRAM.                                              *        
      ******************************************************************        
       9999-END-PROGRAM.                                                
                                                                        
            PERFORM 8800-CHECK-RESULTS THRU 8800-EXIT                   
            PERFORM 8900-SEND-DONE     THRU 8900-EXIT                   
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
