       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04648.                                         
COB303 DATE-WRITTEN.  JULY 22, 2013.                                    
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------         
      *--                 SOUTH CAROLINA ELECTRIC & GAS              --         
      *----------------------------------------------------------------         
      *--                  STORED PROCEDURE:  CSR04648               --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--  CSR04648 :                                                --         
      *--                                                            --         
      *--     SP CALLED FROM METERING & RATE MAINTENANCE METER       --         
      *--     HISTORY VIEW OF CIS PORTAL TO RETRIEVE METER MOVEMENT  --         
      *--     AND TEST DATA.                                         --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *--  PARAMETERS                                                --         
      *--                                                            --         
      *--      INPUT                                                 --         
      *--           ACCOUNT_NO              DECIMAL(13,0)            --         
      *--                                                            --         
      *--      OUT                                                   --         
      *--                                                            --         
      *--           NONE                                             --         
      *--                                                            --         
      *--      INOUT                                                 --         
      *--                                                            --         
      *--           NONE                                             --         
      *--                                                            --         
      *--  RESULT SET                                                --         
      *--      1. CSR04648_R1 - ALL METERS ON PREMISE.               --         
      *--           RETURN_CODE             INTEGER                  --         
      *--           CODE_UTIL_TYPE          CHAR(1)                  --         
      *--           METER_NO                CHAR(9)                  --         
      *--                                                            --         
      *--      2. CSR04648_R2 - METER MOVEMENT DATA.                 --         
      *--           RETURN_CODE             INTEGER                  --         
      *--           CODE_UTIL_TYPE          CHAR(1)                  --         
      *--           METER_NO                CHAR(9)                  --         
      *--           DATE_MOVE               CHAR(10)                 --         
      *--                                                            --         
      *--      3. CSR04648_R3 - METER TEST DATA.                     --         
      *--           RETURN_CODE             INTEGER                  --         
      *--           CODE_UTIL_TYPE          CHAR(1)                  --         
      *--           METER_NO                CHAR(9)                  --         
      *--           DATE_TEST               CHAR(10)                 --         
      *--           CODE_TEST_TYPE          CHAR(1)                  --         
      *--           TEST_TYPE_DESC          CHAR(9)                  --         
      *--           CODE_TEST_RESULT        CHAR(1)                  --         
      *--           TEST_RESULT_DESC        CHAR(10)                 --         
      *--           ACCURACY_PCT            DECIMAL(05,2)            --         
      *--                                                            --         
      *--      4. CSR04648_R4 - BUSINESS RULES.                      --         
      *--           RETURN_CODE             INTEGER                  --         
      *--           BUS_RULE_ID             CHAR(10)                 --         
      *--           ACTION_TYPE_CD          CHAR(08)                 --         
      *--           BUS_RULE_XREF_ID        CHAR(26)                 --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                      MODIFICATION LOG                      --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
P00738*--  07/22/2013    SS97726     PROCEDURE ORIGINALLY CODED.     --         
A05065*--  12/04/2014    MN90523     ACT034 - ADD ACTIVE METER TO    --         
A05065*--                            MOVEMENT HISTORY WITH BLANK MDT --         
      *----------------------------------------------------------------         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04648'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-START                          PIC X(40) VALUE             
            'WORKING STORAGE FOR CSR04648 STARTS HERE'.                 
      *                                                                         
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-SUBROUTINE-IDS.                                       
               10  CSRERLOG                 PIC X(8)  VALUE 'CSRERLOG'. 
           05  PROGRAM-NAME                 PIC X(08) VALUE 'CSR04648'. 
      *                                                                         
       01  PARM-FIELDS.                                                 
           05  PARM-L                       PIC S9(9) COMP.             
COB305     05 PARM-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.   
      *                                                                         
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS-RS1                 PIC S9(9) COMP VALUE 0.     
           05  CTR-ROWS-RS2                 PIC S9(9) COMP VALUE 0.     
           05  CTR-ROWS-RS3                 PIC S9(9) COMP VALUE 0.     
           05  CTR-ROWS-RS4                 PIC S9(9) COMP VALUE 0.     
      *                                                                         
       01  WS-MISC.                                                     
           05  WS-SQLSTATE                  PIC X(05) VALUE SPACES.     
           05  WS-GTT-NAME                  PIC X(19) VALUE SPACES.     
           05  WS-METER                     PIC X(1)  VALUE 'M'.        
           05  WS-ELECTRIC                  PIC X(1)  VALUE 'E'.        
           05  WS-GAS                       PIC X(1)  VALUE 'G'.        
           05  WS-GTT01-DECLARED            PIC X(01) VALUE 'N'.        
           05  WS-GTT02-DECLARED            PIC X(01) VALUE 'N'.        
           05  WS-GTT03-DECLARED            PIC X(01) VALUE 'N'.        
           05  WS-GTT04-DECLARED            PIC X(01) VALUE 'N'.        
           05  WS-FLAG                      PIC X(1)  VALUE SPACE.      
           05  WS-HOLD-DATE                 PIC X(10) VALUE SPACE.      
           05  WS-CODE-UTIL-TYPE-HOLD       PIC X(1)  VALUE SPACE.      
           05  WS-METER-NO-HOLD             PIC X(9)  VALUE SPACE.      
           05  WS-OPEN-RATE-ACCURACY        PIC S9(3)V99 COMP-3 VALUE 0.
           05  WS-CHECK-RATE-ACCURACY       PIC S9(3)V99 COMP-3 VALUE 0.
           05  USA-DATE-FORMAT.                                         
               10  USA-MONTH                PIC X(02).                  
               10  FILLER                   PIC X(01) VALUE '/'.        
               10  USA-DAY                  PIC X(02).                  
               10  FILLER                   PIC X(01) VALUE '/'.        
               10  USA-YEAR                 PIC X(04).                  
           05  WS-NULL-IND                  PIC S9(04) COMP VALUE 0.    
      *                                                                         
       01  WS-FLAG-VALUES.                                              
           05  WS-YES                       PIC X(01) VALUE 'Y'.        
           05  WS-NO                        PIC X(01) VALUE 'N'.        
           05  WS-ACTIVE-CODE               PIC X(01) VALUE 'A'.        
      *                                                                         
       01  WS-SWITCHES.                                                 
           05  WS-NO-MORE-ROWS              PIC X(01) VALUE 'N'.        
               88  NO-MORE-ROWS                       VALUE 'Y'.        
           05  ALL-DONE-SW                  PIC X(01) VALUE 'N'.        
               88 NOT-ALL-DONE                        VALUE 'N'.        
               88 ALL-DONE                            VALUE 'Y'.        
           05  SEND-DONE-SW                 PIC X(01) VALUE 'Y'.        
               88 SEND-DONE-ERROR                     VALUE 'N'.        
               88 SEND-DONE-OK                        VALUE 'Y'.        
      *                                                                         
      ******************************************************************        
      *    ERROR PROCESSING VARIABLES                                  *        
      ******************************************************************        
      *                                                                         
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                    PIC X(18) VALUE SPACES.     
           10  S-SQLCODE                    PIC S9(9) COMP VALUE 0.     
           10  S-SQLSTATE                   PIC X(5)  VALUE ' '.        
           10  S-TABLE-NAME                 PIC X(18) VALUE SPACES.     
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L       PIC S9(4) USAGE COMP.       
               49  S-HOST-VARIABLES-V       PIC X(255).                 
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L        PIC S9(4) USAGE COMP.       
               49  S-SQL-STATEMENT-V        PIC X(255).                 
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L      PIC S9(4) USAGE COMP.       
               49  S-SQL-DESCRIPTION-V      PIC X(255).                 
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L      PIC S9(4) USAGE COMP.       
               49  WS-ABEND-SQLERRMC-V      PIC X(255).                 
                                                                        
       01 GTT-RETURN-FIELDS.                                            
      ******************************************************************        
      *   GTT TABLE LAYOUT FOR ALL METERS ON PREMISE.                  *        
      ******************************************************************        
          05 GTT-RETURN-FIELDS-RS1.                                     
             10 S-RETURN-CODE-RS1           PIC S9(9) COMP VALUE 0.     
             10 S-CODE-UTIL-TYPE-RS1        PIC X(1)  VALUE SPACE.      
             10 S-METER-NO-RS1              PIC X(9)  VALUE SPACE.      
                                                                        
      ******************************************************************        
      *   GTT TABLE LAYOUT FOR MOVEMENT DATA FOR ALL METERS.           *        
      ******************************************************************        
          05 GTT-RETURN-FIELDS-RS2.                                     
             10 S-RETURN-CODE-RS2           PIC S9(9) COMP VALUE 0.     
             10 S-CODE-UTIL-TYPE-RS2        PIC X(1)  VALUE SPACE.      
             10 S-METER-NO-RS2              PIC X(9)  VALUE SPACE.      
             10 S-MOVE-DATE-RS2             PIC X(10) VALUE SPACE.      
                                                                        
      ******************************************************************        
      *   GTT TABLE LAYOUT FOR ALL TEST DATA FOR METERS.               *        
      ******************************************************************        
          05 GTT-RETURN-FIELDS-RS3.                                     
             10 S-RETURN-CODE-RS3           PIC S9(9) COMP VALUE 0.     
             10 S-CODE-UTIL-TYPE-RS3        PIC X(1)  VALUE SPACE.      
             10 S-METER-NO-RS3              PIC X(9)  VALUE SPACE.      
             10 S-TEST-DATE-RS3             PIC X(10) VALUE SPACE.      
             10 S-CODE-TEST-TYPE-RS3        PIC X(1)  VALUE SPACE.      
             10 S-TEST-TYPE-DESC-RS3        PIC X(9)  VALUE SPACE.      
             10 S-CODE-TEST-RESULT-RS3      PIC X(1)  VALUE SPACE.      
             10 S-TEST-RESULT-DESC-RS3      PIC X(10) VALUE SPACE.      
             10 S-ACCURACY-PCT-RS3          PIC S9(3)V99 COMP-3 VALUE 0.
                                                                        
      ******************************************************************        
      *   GTT TABLE LAYOUT FOR BUSINESS RULES.                         *        
      ******************************************************************        
          05 GTT-RETURN-FIELDS-RS4.                                     
             10 S-RETURN-CODE-RS4           PIC S9(9) COMP VALUE ZERO.  
             10 S-BUS-RULE-ID               PIC X(10) VALUE SPACES.     
             10 S-ACTION-TYPE-CD            PIC X(08) VALUE SPACES.     
             10 S-BUS-RULE-XREF-ID          PIC X(26) VALUE SPACES.     
                                                                        
      ******************************************************************        
      *               COBOL WORKING STORAGE COPY BOOKS                 *        
      ******************************************************************        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_ACCOUNT        (AT)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_EQUIPMENT      (EQ)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBEQUIP                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_MOVEMENT_HIST  (MV)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBMVHIST                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_ELEC_MTR_TEST  (ET)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBEMTEST                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_GAS_MTR_TEST   (GT)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBGMTEST                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_EQUIP_TEST_TYP (M9)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBEQTTYP                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_EQUIP_TST_RSLT (N2)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBEQTRST                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
      *                                                                         
      ******************************************************************        
      *    ERROR HANDLING                                                       
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    SUPPORTS DB2 AND SQL ERROR CHECKING                         *        
      ******************************************************************        
      *                                                                         
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    CURSOR DECLARATIONS.                                        *        
      ******************************************************************        
      ******************************************************************        
      *    CURSOR TO RETRIEVE ALL METERS FOR THE PREMISE.              *        
      ******************************************************************        
           EXEC SQL                                                     
               DECLARE  EQUIPMENT CURSOR FOR                            
                SELECT  CODE_UTIL_TYPE                                  
                      , DEVICE_NO                                       
                 FROM   CSS_EQUIPMENT                                   
                WHERE   CRNT_LOC_NO       = :AT-PREMISE-NO              
                  AND  (CODE_UTIL_TYPE    = :WS-ELECTRIC                
                   OR   CODE_UTIL_TYPE    = :WS-GAS)                    
                  AND   COMPANY_NO        = :AT-COMPANY-NO              
                  AND   EQUIP_TYPE_CD     = :WS-METER                   
           END-EXEC.                                                    
      *                                                                         
      ******************************************************************        
      *    CURSOR TO RETRIEVE MOVEMENT DATES FOR A METER.              *        
      ******************************************************************        
           EXEC SQL                                                     
               DECLARE  EQUIPMENT-MOVEMENT CURSOR FOR                   
                SELECT  DATE_LAST_MOVE                                  
                  FROM  CSS_EQUIPMENT     EQ                            
                      , CSS_MOVEMENT_HIST MV                            
                 WHERE  LOC_NO            = :AT-PREMISE-NO              
                   AND  MV.CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE          
                   AND  MV.DEVICE_NO      = :EQ-DEVICE-NO               
                   AND  MV.COMPANY_NO     = :AT-COMPANY-NO              
                   AND  EQ.COMPANY_NO     =  MV.COMPANY_NO              
                   AND  CODE_DEVICE_TYPE  = :WS-METER                   
                   AND  EQ.DEVICE_NO      =  MV.DEVICE_NO               
                   AND  EQ.CODE_UTIL_TYPE =  MV.CODE_UTIL_TYPE          
           END-EXEC.                                                    
      *                                                                         
      ******************************************************************        
      *    CURSOR TO RETRIEVE MOVEMENT FOR ALL METERS ON THE PREMISE.  *        
      ******************************************************************        
           EXEC SQL                                                     
               DECLARE  MOVEMENT CURSOR FOR                             
                SELECT  CODE_UTIL_TYPE                                  
                      , DEVICE_NO                                       
                      , DATE_MOVE                                       
                  FROM  CSS_MOVEMENT_HIST                               
                 WHERE  LOC_NO            = :AT-PREMISE-NO              
                   AND (CODE_UTIL_TYPE    = :WS-ELECTRIC                
                    OR  CODE_UTIL_TYPE    = :WS-GAS)                    
                   AND  COMPANY_NO        = :AT-COMPANY-NO              
                   AND  CODE_DEVICE_TYPE  = :WS-METER                   
                 ORDER BY                                               
                        CODE_UTIL_TYPE                                  
                      , DEVICE_NO                                       
           END-EXEC.                                                    
      *                                                                         
      ******************************************************************        
      *    CURSOR TO RETRIEVE ALL TEST DATA FOR AN ELECTRIC METER.     *        
      ******************************************************************        
           EXEC SQL                                                     
               DECLARE  ELEC-MTR-TEST CURSOR FOR                        
                SELECT  ET.DATE_TEST                                    
                      , ET.CODE_TEST_TYPE                               
                      , ET.CODE_TEST_RESULT                             
                      , ET.LIGHT_LOAD_ACCU_AL                           
                      , ET.FULL_LOAD_ACCU_AL                            
                      , M9.TEST_TYPE_DESC                               
                      , N2.TEST_RESULT_DESC                             
                  FROM  CSS_ELEC_MTR_TEST  ET                           
                      , CSS_EQUIP_TEST_TYP M9                           
                      , CSS_EQUIP_TST_RSLT N2                           
                 WHERE  ET.COMPANY_NO        = :ET-COMPANY-NO           
                   AND  ET.METER_NO          = :ET-METER-NO             
                   AND  ET.CODE_UTIL_TYPE    = :EQ-CODE-UTIL-TYPE       
                   AND  M9.CODE_TEST_TYPE    =  ET.CODE_TEST_TYPE       
                   AND  M9.CODE_UTIL_TYPE    =  ET.CODE_UTIL_TYPE       
                   AND  N2.CODE_TEST_RESULT  =  ET.CODE_TEST_RESULT     
           END-EXEC.                                                    
      *                                                                         
      ******************************************************************        
      *    CURSOR TO RETRIEVE ALL TEST DATA FOR A GAS METER.           *        
      ******************************************************************        
           EXEC SQL                                                     
               DECLARE  GAS-MTR-TEST CURSOR FOR                         
                SELECT  GT.DATE_TEST                                    
                      , GT.CODE_TEST_TYPE                               
                      , GT.CODE_TEST_RESULT                             
                      , GT.IN_CHECK_RATE                                
                      , GT.IN_OPEN_RATE                                 
                      , GT.OUT_CHECK_RATE                               
                      , GT.OUT_OPEN_RATE                                
                      , M9.TEST_TYPE_DESC                               
                      , N2.TEST_RESULT_DESC                             
                  FROM  CSS_GAS_MTR_TEST   GT                           
                      , CSS_EQUIP_TEST_TYP M9                           
                      , CSS_EQUIP_TST_RSLT N2                           
                 WHERE  GT.COMPANY_NO        = :GT-COMPANY-NO           
                   AND  GT.METER_NO          = :GT-METER-NO             
                   AND  GT.CODE_UTIL_TYPE    = :EQ-CODE-UTIL-TYPE       
                   AND  M9.CODE_TEST_TYPE    =  GT.CODE_TEST_TYPE       
                   AND  M9.CODE_UTIL_TYPE    =  GT.CODE_UTIL_TYPE       
                   AND  N2.CODE_TEST_RESULT  =  GT.CODE_TEST_RESULT     
           END-EXEC.                                                    
      *                                                                         
       LINKAGE SECTION.                                                 
COB305 01 I-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.   
      *                                                                         
       PROCEDURE DIVISION USING I-ACCOUNT-NO.                           
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION         THRU 0100-EXIT.          
           PERFORM 1000-PROCESS-INPUT          THRU 1000-EXIT.          
           PERFORM 2000-BUILD-RESULT           THRU 2000-EXIT.          
           PERFORM 9999-END-PROGRAM            THRU 9999-EXIT.          
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 0100-INITIALIZATION.                                          *         
      *****************************************************************         
       0100-INITIALIZATION.                                             
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE 'N'                         TO WS-GTT01-DECLARED        
                                               WS-GTT02-DECLARED        
                                               WS-GTT03-DECLARED        
                                               WS-GTT04-DECLARED.       
           EXEC SQL                                                     
               WHENEVER SQLWARNING                                      
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLERROR                                        
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER NOT FOUND                                       
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1        THRU 0100A-EXIT.         
           PERFORM 0100B-DECLARE-GTT-R2        THRU 0100B-EXIT.         
           PERFORM 0100C-DECLARE-GTT-R3        THRU 0100C-EXIT.         
           PERFORM 0100D-DECLARE-GTT-R4        THRU 0100D-EXIT.         
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100A-DECLARE-GTT-R1 - ALL METERS ON THE PREMISE.              *        
      ******************************************************************        
       0100A-DECLARE-GTT-R1.                                            
                                                                        
           MOVE 'SESSION.CSR04648_R1'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04648_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04648_R1
              (                                                      
                    RETURN_CODE             INT                     
                   ,CODE_UTIL_TYPE CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,METER_NO CHAR(9)  COLLATE LATIN1_GENERAL_100_BIN2           
                 )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS       THRU 8000A-EXIT          
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE 'Y'                   TO WS-GTT01-DECLARED        
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100A'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT           
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE             AS RETURN_CODE           
                      ,LTRIM(RTRIM(CODE_UTIL_TYPE))   AS CODE_UTIL_TYPE        
                      ,LTRIM(RTRIM(METER_NO))         AS METER_NO              
                  FROM #CSR04648_R1                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE             AS RETURN_CODE                   
MFA-TR*               ,STRIP(CODE_UTIL_TYPE)   AS CODE_UTIL_TYPE                
MFA-TR*               ,STRIP(METER_NO)         AS METER_NO                      
MFA-TR*           FROM SESSION.CSR04648_R1                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 0100B-DECLARE-GTT-R2 - MOVEMENT DATE FOR ALL METERS.           *        
      ******************************************************************        
       0100B-DECLARE-GTT-R2.                                            
                                                                        
           MOVE 'SESSION.CSR04648_R2'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04648_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04648_R2
              (                                                      
                    RETURN_CODE             INT                     
                   ,CODE_UTIL_TYPE CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,METER_NO CHAR(9)  COLLATE LATIN1_GENERAL_100_BIN2           
                   ,DATE_MOVE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2         
                 )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000B-DEL-GTT-ROWS       THRU 8000B-EXIT          
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE 'Y'                   TO WS-GTT02-DECLARED        
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100B'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT           
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C2 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE             AS RETURN_CODE           
                      ,LTRIM(RTRIM(CODE_UTIL_TYPE))   AS CODE_UTIL_TYPE        
                      ,LTRIM(RTRIM(METER_NO))         AS METER_NO              
                      ,LTRIM(RTRIM(DATE_MOVE))        AS DATE_MOVE             
                  FROM #CSR04648_R2                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C2 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE             AS RETURN_CODE                   
MFA-TR*               ,STRIP(CODE_UTIL_TYPE)   AS CODE_UTIL_TYPE                
MFA-TR*               ,STRIP(METER_NO)         AS METER_NO                      
MFA-TR*               ,STRIP(DATE_MOVE)        AS DATE_MOVE                     
MFA-TR*           FROM SESSION.CSR04648_R2                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100B-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 0100C-DECLARE-GTT-R3 - TEST DATA FOR METERS.                   *        
      ******************************************************************        
       0100C-DECLARE-GTT-R3.                                            
                                                                        
           MOVE 'SESSION.CSR04648_R3'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04648_R3')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04648_R3
              (                                                      
                    RETURN_CODE             INT                     
                   ,CODE_UTIL_TYPE CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,METER_NO CHAR(9)  COLLATE LATIN1_GENERAL_100_BIN2           
                   ,DATE_TEST CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,CODE_TEST_TYPE CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,TEST_TYPE_DESC CHAR(9)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,CODE_TEST_RESULT CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,TEST_RESULT_DESC CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,ACCURACY_PCT            DECIMAL(5,2)                
                 )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000C-DEL-GTT-ROWS       THRU 8000C-EXIT          
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE 'Y'                   TO WS-GTT03-DECLARED        
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100C'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT           
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C3 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE             AS RETURN_CODE           
                      ,LTRIM(RTRIM(CODE_UTIL_TYPE))   AS CODE_UTIL_TYPE        
                      ,LTRIM(RTRIM(METER_NO))         AS METER_NO              
                      ,LTRIM(RTRIM(DATE_TEST))        AS DATE_TEST             
                      ,LTRIM(RTRIM(CODE_TEST_TYPE))   AS CODE_TEST_TYPE        
                      ,LTRIM(RTRIM(TEST_TYPE_DESC))   AS TEST_TYPE_DESC        
                      ,LTRIM(RTRIM(CODE_TEST_RESULT)) AS 
           CODE_TEST_RESULT      
                      ,LTRIM(RTRIM(TEST_RESULT_DESC)) AS 
           TEST_RESULT_DESC      
                      ,ACCURACY_PCT            AS ACCURACY_PCT          
                  FROM #CSR04648_R3                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C3 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE             AS RETURN_CODE                   
MFA-TR*               ,STRIP(CODE_UTIL_TYPE)   AS CODE_UTIL_TYPE                
MFA-TR*               ,STRIP(METER_NO)         AS METER_NO                      
MFA-TR*               ,STRIP(DATE_TEST)        AS DATE_TEST                     
MFA-TR*               ,STRIP(CODE_TEST_TYPE)   AS CODE_TEST_TYPE                
MFA-TR*               ,STRIP(TEST_TYPE_DESC)   AS TEST_TYPE_DESC                
MFA-TR*               ,STRIP(CODE_TEST_RESULT) AS CODE_TEST_RESULT              
MFA-TR*               ,STRIP(TEST_RESULT_DESC) AS TEST_RESULT_DESC              
MFA-TR*               ,ACCURACY_PCT            AS ACCURACY_PCT                  
MFA-TR*           FROM SESSION.CSR04648_R3                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100C-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 0100D-DECLARE-GTT-R4 - BUSINESS RULES.                         *        
      ******************************************************************        
       0100D-DECLARE-GTT-R4.                                            
                                                                        
           MOVE 'SESSION.CSR04648_R4'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04648_R4')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04648_R4
              (                                                      
                    RETURN_CODE             INT                     
                   ,BUS_RULE_ID CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,ACTION_TYPE_CD CHAR(08)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BUS_RULE_XREF_ID CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                 )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000D-DEL-GTT-ROWS       THRU 8000D-EXIT          
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE 'Y'                   TO WS-GTT04-DECLARED        
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100D'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT           
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C4 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE        AS RETURN_CODE                
                      ,BUS_RULE_ID        AS BUS_RULE_ID                
                      ,ACTION_TYPE_CD     AS ACTION_TYPE_CD             
                      ,BUS_RULE_XREF_ID   AS BUS_RULE_XREF_ID           
                  FROM #CSR04648_R4                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C4 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE        AS RETURN_CODE                        
MFA-TR*               ,BUS_RULE_ID        AS BUS_RULE_ID                        
MFA-TR*               ,ACTION_TYPE_CD     AS ACTION_TYPE_CD                     
MFA-TR*               ,BUS_RULE_XREF_ID   AS BUS_RULE_XREF_ID                   
MFA-TR*           FROM SESSION.CSR04648_R4                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100D-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT.                                            *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           IF I-ACCOUNT-NO NOT NUMERIC                                  
              MOVE ZEROS                    TO I-ACCOUNT-NO             
           END-IF.                                                      
                                                                        
           MOVE I-ACCOUNT-NO                TO PARM-ACCOUNT-NO.         
                                                                        
           IF PARM-ACCOUNT-NO EQUAL ZEROES                              
              MOVE +100                     TO WS-ACTIVE-RETURN-CODE    
              MOVE 'PARMS ZERO'             TO S-BUS-RULE-ID            
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-BUILD-RESULT                                              *        
      ******************************************************************        
       2000-BUILD-RESULT.                                               
                                                                        
           PERFORM 7000-SELECT-ACCOUNT         THRU 7000-EXIT.          
           MOVE AT-COMPANY-NO               TO EQ-COMPANY-NO            
                                               MV-COMPANY-NO            
                                               ET-COMPANY-NO            
                                               GT-COMPANY-NO.           
      *--- PROCESS METERS CURRENTLY ON PREMISE                                  
           PERFORM 7100-OPEN-EQUIPMENT         THRU 7100-EXIT.          
           PERFORM 7110-FETCH-EQUIPMENT        THRU 7110-EXIT.          
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              NEXT SENTENCE                                             
           ELSE                                                         
      *------ SEND ROWS FOR CURRENT METER                                       
              PERFORM 2100-GET-CURRENT-MTR     THRU 2100-EXIT           
                      UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND           
           END-IF.                                                      
           PERFORM 7120-CLOSE-EQUIPMENT        THRU 7120-EXIT.          
                                                                        
      *--- PROCESS METERS NOT CURRENTLY ON PREMISE                              
           PERFORM 7500-OPEN-MOVEMENT          THRU 7500-EXIT.          
           PERFORM 7510-FETCH-MOVEMENT         THRU 7510-EXIT.          
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              NEXT SENTENCE                                             
           ELSE                                                         
      *------ SEND ROWS IF METER NOT IN EQUIPMENT TABLE, THAT IS,               
      *------ IF DATA FOR THIS METER HAVE NOT ALREADY BEEN SENT                 
              PERFORM 2200-GET-REMOVED-MTR     THRU 2200-EXIT           
                      UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND           
           END-IF.                                                      
           PERFORM 7520-CLOSE-MOVEMENT         THRU 7520-EXIT.          
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 2100-GET-CURRENT-MTR                                          *         
      *****************************************************************         
       2100-GET-CURRENT-MTR.                                            
                                                                        
      *--- SEND ROW FOR CURRENT METER                                           
           MOVE 0                           TO S-RETURN-CODE-RS1.       
           MOVE EQ-CODE-UTIL-TYPE           TO S-CODE-UTIL-TYPE-RS1.    
           MOVE EQ-DEVICE-NO                TO S-METER-NO-RS1           
                                               ET-METER-NO              
                                               GT-METER-NO.             
                                                                        
           PERFORM 8010-INSERT-GTT-R1          THRU 8010-EXIT.          
A05065                                                                  
A05065     MOVE 0                           TO S-RETURN-CODE-RS2        
A05065     MOVE EQ-CODE-UTIL-TYPE           TO S-CODE-UTIL-TYPE-RS2     
A05065     MOVE EQ-DEVICE-NO                TO S-METER-NO-RS2           
A05065     MOVE SPACES                      TO S-MOVE-DATE-RS2          
A05065                                                                  
A05065     PERFORM 8020-INSERT-GTT-R2          THRU 8020-EXIT           
                                                                        
      *--- CHECK IF THIS METER WAS EVER REMOVED FROM PREMISE                    
           PERFORM 7200-OPEN-EQUIPMENT-MOVEMENT                         
                                               THRU 7200-EXIT.          
           PERFORM 7210-FETCH-EQUIPMENT-MOVEMENT                        
                                               THRU 7210-EXIT.          
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              NEXT SENTENCE                                             
           ELSE                                                         
      *------ SEND MOVEMENT DATA FOR THE SELECTED CURRENT METER                 
              PERFORM 2110-SEND-MOVEMENT-DATA  THRU 2110-EXIT           
                      UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND           
           END-IF.                                                      
           PERFORM 7220-CLOSE-EQUIPMENT-MOVEMENT                        
                                               THRU 7220-EXIT.          
                                                                        
           IF EQ-CODE-UTIL-TYPE = WS-ELECTRIC                           
      *------ CHECK IF ELECTRIC METER HAS TEST DATA                             
              PERFORM 7300-OPEN-ELEC-MTR-TEST  THRU 7300-EXIT           
              PERFORM 7310-FETCH-ELEC-MTR-TEST THRU 7310-EXIT           
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 PERFORM 7320-CLOSE-ELEC-MTR-TEST                       
                                               THRU 7320-EXIT           
              ELSE                                                      
      *--------- SEND METER TEST DATA                                           
                 PERFORM 2120-SEND-TEST-DATA   THRU 2120-EXIT           
                         UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND        
                 PERFORM 7320-CLOSE-ELEC-MTR-TEST                       
                                               THRU 7320-EXIT           
              END-IF                                                    
           ELSE                                                         
      *------ CHECK IF GAS METER HAS TEST DATA                                  
              PERFORM 7400-OPEN-GAS-MTR-TEST   THRU 7400-EXIT           
              PERFORM 7410-FETCH-GAS-MTR-TEST  THRU 7410-EXIT           
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 PERFORM 7420-CLOSE-GAS-MTR-TEST                        
                                               THRU 7420-EXIT           
              ELSE                                                      
      *--------- SEND METER TEST DATA                                           
                 PERFORM 2120-SEND-TEST-DATA   THRU 2120-EXIT           
                         UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND        
                 PERFORM 7420-CLOSE-GAS-MTR-TEST                        
                                               THRU 7420-EXIT           
              END-IF                                                    
           END-IF.                                                      
                                                                        
           PERFORM 7110-FETCH-EQUIPMENT        THRU 7110-EXIT.          
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2110-SEND-MOVEMENT-DATA                                        *        
      *     THIS MODULE OBTAINS AND RETURNS MOVEMENT DATA FOR METERS   *        
      *     CURRENTLY INSTALLED AT THE PREMISE.                        *        
      ******************************************************************        
       2110-SEND-MOVEMENT-DATA.                                         
                                                                        
           MOVE EQ-DATE-LAST-MOVE(1:4)      TO USA-YEAR.                
           MOVE EQ-DATE-LAST-MOVE(6:2)      TO USA-MONTH.               
           MOVE EQ-DATE-LAST-MOVE(9:2)      TO USA-DAY.                 
                                                                        
           IF EQ-DEVICE-NO      NOT EQUAL S-METER-NO-RS2       OR       
              USA-DATE-FORMAT   NOT EQUAL S-MOVE-DATE-RS2      OR       
              EQ-CODE-UTIL-TYPE NOT EQUAL S-CODE-UTIL-TYPE-RS2          
              MOVE 0                        TO S-RETURN-CODE-RS2        
              MOVE EQ-CODE-UTIL-TYPE        TO S-CODE-UTIL-TYPE-RS2     
              MOVE EQ-DEVICE-NO             TO S-METER-NO-RS2           
              MOVE USA-DATE-FORMAT          TO S-MOVE-DATE-RS2          
                                                                        
              PERFORM 8020-INSERT-GTT-R2       THRU 8020-EXIT           
           END-IF.                                                      
                                                                        
           PERFORM 7210-FETCH-EQUIPMENT-MOVEMENT                        
                                               THRU 7210-EXIT.          
                                                                        
       2110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2120-SEND-TEST-DATA                                            *        
      *     THIS MODULE OBTAINS AND RETURNS METER TEST DATA            *        
      ******************************************************************        
       2120-SEND-TEST-DATA.                                             
                                                                        
           MOVE 0                           TO S-RETURN-CODE-RS3.       
           MOVE EQ-CODE-UTIL-TYPE           TO S-CODE-UTIL-TYPE-RS3.    
           MOVE EQ-DEVICE-NO                TO S-METER-NO-RS3.          
                                                                        
           MOVE WS-HOLD-DATE(1:4)           TO USA-YEAR.                
           MOVE WS-HOLD-DATE(6:2)           TO USA-MONTH.               
           MOVE WS-HOLD-DATE(9:2)           TO USA-DAY.                 
           MOVE USA-DATE-FORMAT             TO S-TEST-DATE-RS3.         
           MOVE M9-TEST-TYPE-DESC           TO S-TEST-TYPE-DESC-RS3.    
           MOVE N2-TEST-RESULT-DESC         TO S-TEST-RESULT-DESC-RS3.  
                                                                        
      *--- COMPUTE PERCENT ACCURACY OF REGISTRATION                             
           IF EQ-CODE-UTIL-TYPE = WS-ELECTRIC                           
                 COMPUTE S-ACCURACY-PCT-RS3 ROUNDED                     
                     = (( 4 * ET-FULL-LOAD-ACCU-AL )                    
                           + ET-LIGHT-LOAD-ACCU-AL ) / 5                
           ELSE                                                         
              IF GT-IN-OPEN-RATE > 0                                    
                 COMPUTE S-ACCURACY-PCT-RS3 ROUNDED                     
                 = ( GT-IN-CHECK-RATE + GT-IN-OPEN-RATE ) / 2           
              ELSE                                                      
                 IF GT-IN-CHECK-RATE > 0                                
                    COMPUTE S-ACCURACY-PCT-RS3 ROUNDED                  
                    = ( GT-IN-CHECK-RATE + GT-IN-OPEN-RATE ) / 2        
                 ELSE                                                   
                    MOVE 0                  TO S-ACCURACY-PCT-RS3       
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
           PERFORM 8030-INSERT-GTT-R3          THRU 8030-EXIT.          
                                                                        
           IF EQ-CODE-UTIL-TYPE = WS-ELECTRIC                           
              PERFORM 7310-FETCH-ELEC-MTR-TEST THRU 7310-EXIT           
           ELSE                                                         
              PERFORM 7410-FETCH-GAS-MTR-TEST  THRU 7410-EXIT           
           END-IF.                                                      
                                                                        
       2120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 2200-GET-REMOVED-MTR                                          *         
      *****************************************************************         
       2200-GET-REMOVED-MTR.                                            
                                                                        
      *--- CHECK WHETHER THIS METER IS CURRENTLY INSTALLED                      
           PERFORM 7600-CHECK-EQUIPMENT        THRU 7600-EXIT.          
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
      *------ DATE HAS BEEN SENT SINCE THIS IS A CURRENT METER                  
              NEXT SENTENCE                                             
           ELSE                                                         
      *------ SEND ROW FOR REMOVED METER IF NOT ALREADY SENT                    
              IF MV-CODE-UTIL-TYPE NOT EQUAL S-CODE-UTIL-TYPE-RS1 OR    
                 MV-DEVICE-NO      NOT EQUAL S-METER-NO-RS1             
                 MOVE 0                     TO S-RETURN-CODE-RS1        
                 MOVE MV-CODE-UTIL-TYPE     TO S-CODE-UTIL-TYPE-RS1     
                 MOVE MV-DEVICE-NO          TO S-METER-NO-RS1           
                 PERFORM 8010-INSERT-GTT-R1    THRU 8010-EXIT           
              END-IF                                                    
                                                                        
      *------ SEND MOVEMENT DATA FOR REMOVED METER                              
              PERFORM 2210-SEND-REMOVED-MTR-ROW                         
                                               THRU 2210-EXIT           
      *------ GET METER TEST DATA ONCE FOR EACH METER                           
              IF MV-CODE-UTIL-TYPE NOT EQUAL WS-CODE-UTIL-TYPE-HOLD     
                 OR  MV-DEVICE-NO  NOT EQUAL WS-METER-NO-HOLD           
                 MOVE MV-DEVICE-NO          TO ET-METER-NO              
                                               GT-METER-NO              
                 IF MV-CODE-UTIL-TYPE = WS-ELECTRIC                     
      *------------ CHECK IF ELECTRIC METER HAS TEST DATA                       
                    PERFORM 7300-OPEN-ELEC-MTR-TEST                     
                                               THRU 7300-EXIT           
                    PERFORM 7310-FETCH-ELEC-MTR-TEST                    
                                               THRU 7310-EXIT           
                    IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                
                       PERFORM 7320-CLOSE-ELEC-MTR-TEST                 
                                               THRU 7320-EXIT           
                    ELSE                                                
      *--------------- SEND METER TEST DATA                                     
                       PERFORM 2120-SEND-TEST-DATA                      
                                               THRU 2120-EXIT           
                               UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND  
                       PERFORM 7320-CLOSE-ELEC-MTR-TEST                 
                                               THRU 7320-EXIT           
                    END-IF                                              
                 ELSE                                                   
      *------------ CHECK IF GAS METER HAS TEST DATA                            
                    PERFORM 7400-OPEN-GAS-MTR-TEST                      
                                               THRU 7400-EXIT           
                    PERFORM 7410-FETCH-GAS-MTR-TEST                     
                                               THRU 7410-EXIT           
                    IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                
                       PERFORM 7420-CLOSE-GAS-MTR-TEST                  
                                               THRU 7420-EXIT           
                    ELSE                                                
      *--------------- SEND METER TEST DATA                                     
                       PERFORM 2120-SEND-TEST-DATA                      
                                               THRU 2120-EXIT           
                             UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND    
                       PERFORM 7420-CLOSE-GAS-MTR-TEST                  
                                               THRU 7420-EXIT           
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
           MOVE MV-CODE-UTIL-TYPE           TO WS-CODE-UTIL-TYPE-HOLD.  
           MOVE MV-DEVICE-NO                TO WS-METER-NO-HOLD.        
           PERFORM 7510-FETCH-MOVEMENT         THRU 7510-EXIT.          
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2210-SEND-REMOVED-MTR-ROW                                     *         
      *     THIS MODULE OBTAINS AND RETURNS MOVEMENT DATA FOR METERS   *        
      *     REMOVED FROM THE PREMISE.                                  *        
      ******************************************************************        
       2210-SEND-REMOVED-MTR-ROW.                                       
                                                                        
           MOVE MV-CODE-UTIL-TYPE           TO EQ-CODE-UTIL-TYPE.       
           MOVE MV-DEVICE-NO                TO EQ-DEVICE-NO.            
           MOVE MV-DATE-MOVE                TO WS-HOLD-DATE.            
                                                                        
           PERFORM 7650-GET-REMOVE-DATE        THRU 7650-EXIT.          
                                                                        
           IF WS-NULL-IND EQUAL ZEROS                                   
              MOVE MV-DATE-MOVE             TO WS-HOLD-DATE             
           ELSE                                                         
              PERFORM 7700-SELECT-FROM-EQ      THRU 7700-EXIT           
              MOVE EQ-DATE-LAST-MOVE        TO WS-HOLD-DATE             
           END-IF.                                                      
                                                                        
           MOVE WS-HOLD-DATE(1:4)           TO USA-YEAR.                
           MOVE WS-HOLD-DATE(6:2)           TO USA-MONTH.               
           MOVE WS-HOLD-DATE(9:2)           TO USA-DAY.                 
                                                                        
           IF MV-DEVICE-NO      NOT EQUAL S-METER-NO-RS2       OR       
              USA-DATE-FORMAT   NOT EQUAL S-MOVE-DATE-RS2      OR       
              MV-CODE-UTIL-TYPE NOT EQUAL S-CODE-UTIL-TYPE-RS2          
              MOVE 0                        TO S-RETURN-CODE-RS2        
              MOVE MV-CODE-UTIL-TYPE        TO S-CODE-UTIL-TYPE-RS2     
              MOVE MV-DEVICE-NO             TO S-METER-NO-RS2           
              MOVE USA-DATE-FORMAT          TO S-MOVE-DATE-RS2          
                                                                        
              PERFORM 8020-INSERT-GTT-R2       THRU 8020-EXIT           
           END-IF.                                                      
                                                                        
       2210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7000-SELECT-ACCOUNT                                            *        
      ******************************************************************        
       7000-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
               SELECT  PREMISE_NO                                       
                     , COMPANY_NO                                       
                 INTO :AT-PREMISE-NO                                    
                     ,:AT-COMPANY-NO                                    
                 FROM  CSS_ACCOUNT                                      
                WHERE  ACCOUNT_NO   = :PARM-ACCOUNT-NO                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7000'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_ACCOUNT'            TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE PARM-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7100-OPEN-EQUIPMENT                                            *        
      ******************************************************************        
       7100-OPEN-EQUIPMENT.                                             
                                                                        
           EXEC SQL                                                     
               OPEN EQUIPMENT                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7100'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_EQUIPMENT'          TO TABLE-1                  
              MOVE 'EQUIP_TYPE_CD'          TO TABLE-ELEMENT-1          
              MOVE WS-METER                 TO HOSTVAR-ELEMENT-1        
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-2          
              MOVE AT-COMPANY-NO            TO HOSTVAR-ELEMENT-2        
              MOVE 'CRNT_LOC_NO'            TO TABLE-ELEMENT-3          
              MOVE AT-PREMISE-NO            TO HOSTVAR-ELEMENT-3        
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-4          
              MOVE PARM-ACCOUNT-NO          TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7110-FETCH-EQUIPMENT                                           *        
      *     THIS MODULE FETCHES THE METER NUMBERS FROM EQUIPMENT TABLE *        
      ******************************************************************        
       7110-FETCH-EQUIPMENT.                                            
                                                                        
           EXEC SQL                                                     
               FETCH  EQUIPMENT                                         
                INTO :EQ-CODE-UTIL-TYPE                                 
                    ,:EQ-DEVICE-NO                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7110'                   TO ACTIVE-PARAGRAPH         
              MOVE 'FETCH'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_EQUIPMENT'          TO TABLE-1                  
              MOVE 'EQUIP_TYPE_CD'          TO TABLE-ELEMENT-1          
              MOVE WS-METER                 TO HOSTVAR-ELEMENT-1        
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-2          
              MOVE AT-COMPANY-NO            TO HOSTVAR-ELEMENT-2        
              MOVE 'CRNT_LOC_NO'            TO TABLE-ELEMENT-3          
              MOVE AT-PREMISE-NO            TO HOSTVAR-ELEMENT-3        
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-4          
              MOVE PARM-ACCOUNT-NO          TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7120-CLOSE-EQUIPMENT.                                          *        
      ******************************************************************        
       7120-CLOSE-EQUIPMENT.                                            
                                                                        
           EXEC SQL                                                     
               CLOSE EQUIPMENT                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7120'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_EQUIPMENT'          TO TABLE-1                  
              MOVE 'EQUIP_TYPE_CD'          TO TABLE-ELEMENT-1          
              MOVE WS-METER                 TO HOSTVAR-ELEMENT-1        
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-2          
              MOVE AT-COMPANY-NO            TO HOSTVAR-ELEMENT-2        
              MOVE 'CRNT_LOC_NO'            TO TABLE-ELEMENT-3          
              MOVE AT-PREMISE-NO            TO HOSTVAR-ELEMENT-3        
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-4          
              MOVE PARM-ACCOUNT-NO          TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7200-OPEN-EQUIPMENT-MOVEMENT                                   *        
      ******************************************************************        
                                                                        
       7200-OPEN-EQUIPMENT-MOVEMENT.                                    
                                                                        
           EXEC SQL                                                     
               OPEN EQUIPMENT-MOVEMENT                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7200'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_MOVEMENT'           TO TABLE-1                  
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-1          
              MOVE EQ-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-1        
              MOVE 'DEVICE_NO'              TO TABLE-ELEMENT-2          
              MOVE EQ-DEVICE-NO             TO HOSTVAR-ELEMENT-2        
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-3          
              MOVE AT-COMPANY-NO            TO HOSTVAR-ELEMENT-3        
              MOVE 'LOC_NO'                 TO TABLE-ELEMENT-4          
              MOVE AT-PREMISE-NO            TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7210-FETCH-EQUIPMENT-MOVEMENT                                  *        
      *     THIS MODULE FETCHES MOVE DATES FROM MOVEMENT TABLE         *        
      ******************************************************************        
       7210-FETCH-EQUIPMENT-MOVEMENT.                                   
                                                                        
           EXEC SQL                                                     
               FETCH  EQUIPMENT-MOVEMENT                                
                INTO :EQ-DATE-LAST-MOVE                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7210'                   TO ACTIVE-PARAGRAPH         
              MOVE 'FETCH'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_MOVEMENT'           TO TABLE-1                  
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-1          
              MOVE EQ-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-1        
              MOVE 'DEVICE_NO'              TO TABLE-ELEMENT-2          
              MOVE EQ-DEVICE-NO             TO HOSTVAR-ELEMENT-2        
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-3          
              MOVE AT-COMPANY-NO            TO HOSTVAR-ELEMENT-3        
              MOVE 'LOC_NO'                 TO TABLE-ELEMENT-4          
              MOVE AT-PREMISE-NO            TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7220-CLOSE-EQUIPMENT-MOVEMENT.                                 *        
      ******************************************************************        
       7220-CLOSE-EQUIPMENT-MOVEMENT.                                   
                                                                        
           EXEC SQL                                                     
               CLOSE EQUIPMENT-MOVEMENT                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7220'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_MOVEMENT'           TO TABLE-1                  
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-1          
              MOVE EQ-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-1        
              MOVE 'DEVICE_NO'              TO TABLE-ELEMENT-2          
              MOVE EQ-DEVICE-NO             TO HOSTVAR-ELEMENT-2        
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-3          
              MOVE AT-COMPANY-NO            TO HOSTVAR-ELEMENT-3        
              MOVE 'LOC_NO'                 TO TABLE-ELEMENT-4          
              MOVE AT-PREMISE-NO            TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7220-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7300-OPEN-ELEC-MTR-TEST                                        *        
      ******************************************************************        
       7300-OPEN-ELEC-MTR-TEST.                                         
                                                                        
           EXEC SQL                                                     
               OPEN ELEC-MTR-TEST                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7300'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_ELEC_MTR_TEST'      TO TABLE-1                  
              MOVE 'METER_NO'               TO TABLE-ELEMENT-1          
              MOVE ET-METER-NO              TO HOSTVAR-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE EQ-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-3          
              MOVE PARM-ACCOUNT-NO          TO HOSTVAR-ELEMENT-3        
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-4          
              MOVE ET-COMPANY-NO            TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7310-FETCH-ELEC-MTR-TEST                                       *        
      *     THIS MODULE FETCHES TEST DATA FOR ELECTRIC METERS          *        
      ******************************************************************        
       7310-FETCH-ELEC-MTR-TEST.                                        
                                                                        
           EXEC SQL                                                     
               FETCH  ELEC-MTR-TEST                                     
                INTO :WS-HOLD-DATE                                      
                    ,:S-CODE-TEST-TYPE-RS3                              
                    ,:S-CODE-TEST-RESULT-RS3                            
                    ,:ET-LIGHT-LOAD-ACCU-AL                             
                    ,:ET-FULL-LOAD-ACCU-AL                              
                    ,:M9-TEST-TYPE-DESC                                 
                    ,:N2-TEST-RESULT-DESC                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7310'                   TO ACTIVE-PARAGRAPH         
              MOVE 'FETCH'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_ELEC_MTR_TEST'      TO TABLE-1                  
              MOVE 'METER_NO'               TO TABLE-ELEMENT-1          
              MOVE ET-METER-NO              TO HOSTVAR-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE EQ-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-3          
              MOVE PARM-ACCOUNT-NO          TO HOSTVAR-ELEMENT-3        
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-4          
              MOVE ET-COMPANY-NO            TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7320-CLOSE-ELEC-MTR-TEST.                                      *        
      ******************************************************************        
       7320-CLOSE-ELEC-MTR-TEST.                                        
                                                                        
           EXEC SQL                                                     
               CLOSE ELEC-MTR-TEST                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7320'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_ELEC_MTR_TEST'      TO TABLE-1                  
              MOVE 'METER_NO'               TO TABLE-ELEMENT-1          
              MOVE ET-METER-NO              TO HOSTVAR-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE EQ-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-3          
              MOVE PARM-ACCOUNT-NO          TO HOSTVAR-ELEMENT-3        
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-4          
              MOVE ET-COMPANY-NO            TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7320-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7400-OPEN-GAS-MTR-TEST                                         *        
      ******************************************************************        
       7400-OPEN-GAS-MTR-TEST.                                          
                                                                        
           EXEC SQL                                                     
               OPEN GAS-MTR-TEST                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7400'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_GAS_MTR_TEST'       TO TABLE-1                  
              MOVE 'METER_NO'               TO TABLE-ELEMENT-1          
              MOVE GT-METER-NO              TO HOSTVAR-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE EQ-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-3          
              MOVE PARM-ACCOUNT-NO          TO HOSTVAR-ELEMENT-3        
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-4          
              MOVE GT-COMPANY-NO            TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7410-FETCH-GAS-MTR-TEST                                        *        
      *     THIS MODULE FETCHES TEST DATA FOR GAS METERS               *        
      ******************************************************************        
       7410-FETCH-GAS-MTR-TEST.                                         
                                                                        
           EXEC SQL                                                     
               FETCH  GAS-MTR-TEST                                      
                INTO :WS-HOLD-DATE                                      
                    ,:S-CODE-TEST-TYPE-RS3                              
                    ,:S-CODE-TEST-RESULT-RS3                            
                    ,:GT-IN-CHECK-RATE                                  
                    ,:GT-IN-OPEN-RATE                                   
                    ,:GT-OUT-CHECK-RATE                                 
                    ,:GT-OUT-OPEN-RATE                                  
                    ,:M9-TEST-TYPE-DESC                                 
                    ,:N2-TEST-RESULT-DESC                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7410'                   TO ACTIVE-PARAGRAPH         
              MOVE 'FETCH'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_ELEC_MTR_TEST'      TO TABLE-1                  
              MOVE 'METER_NO'               TO TABLE-ELEMENT-1          
              MOVE GT-METER-NO              TO HOSTVAR-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE EQ-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-3          
              MOVE PARM-ACCOUNT-NO          TO HOSTVAR-ELEMENT-3        
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-4          
              MOVE GT-COMPANY-NO            TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7410-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7420-CLOSE-GAS-MTR-TEST.                                       *        
      ******************************************************************        
       7420-CLOSE-GAS-MTR-TEST.                                         
                                                                        
           EXEC SQL                                                     
               CLOSE GAS-MTR-TEST                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7420'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_GAS_MTR_TEST'       TO TABLE-1                  
              MOVE 'METER_NO'               TO TABLE-ELEMENT-1          
              MOVE GT-METER-NO              TO HOSTVAR-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE EQ-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-3          
              MOVE PARM-ACCOUNT-NO          TO HOSTVAR-ELEMENT-3        
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-4          
              MOVE GT-COMPANY-NO            TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7420-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7500-OPEN-MOVEMENT                                             *        
      ******************************************************************        
       7500-OPEN-MOVEMENT.                                              
                                                                        
           EXEC SQL                                                     
               OPEN MOVEMENT                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7500'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_MOVEMENT_HIST'      TO TABLE-1                  
              MOVE 'CODE_DEVICE_TYPE'       TO TABLE-ELEMENT-1          
              MOVE WS-METER                 TO HOSTVAR-ELEMENT-1        
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-2          
              MOVE AT-COMPANY-NO            TO HOSTVAR-ELEMENT-2        
              MOVE 'LOC_NO'                 TO TABLE-ELEMENT-3          
              MOVE AT-PREMISE-NO            TO HOSTVAR-ELEMENT-3        
              MOVE 'DEVICE_NO'              TO TABLE-ELEMENT-4          
              MOVE EQ-DEVICE-NO             TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7510-FETCH-MOVEMENT                                            *        
      * THIS MODULE FETCHES THE METER NOS FROM MOVEMENT HIST TABLE     *        
      ******************************************************************        
       7510-FETCH-MOVEMENT.                                             
                                                                        
           EXEC SQL                                                     
               FETCH  MOVEMENT                                          
                INTO :MV-CODE-UTIL-TYPE                                 
                    ,:MV-DEVICE-NO                                      
                    ,:MV-DATE-MOVE                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7510'                   TO ACTIVE-PARAGRAPH         
              MOVE 'FETCH'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_MOVEMENT_HIST'      TO TABLE-1                  
              MOVE 'CODE_DEVICE_TYPE'       TO TABLE-ELEMENT-1          
              MOVE WS-METER                 TO HOSTVAR-ELEMENT-1        
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-2          
              MOVE AT-COMPANY-NO            TO HOSTVAR-ELEMENT-2        
              MOVE 'LOC_NO'                 TO TABLE-ELEMENT-3          
              MOVE AT-PREMISE-NO            TO HOSTVAR-ELEMENT-3        
              MOVE 'DEVICE_NO'              TO TABLE-ELEMENT-4          
              MOVE EQ-DEVICE-NO             TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7520-CLOSE-MOVEMENT.                                           *        
      ******************************************************************        
       7520-CLOSE-MOVEMENT.                                             
                                                                        
           EXEC SQL                                                     
               CLOSE MOVEMENT                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7520'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_MOVEMENT_HIST'      TO TABLE-1                  
              MOVE 'CODE_DEVICE_TYPE'       TO TABLE-ELEMENT-1          
              MOVE WS-METER                 TO HOSTVAR-ELEMENT-1        
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-2          
              MOVE AT-COMPANY-NO            TO HOSTVAR-ELEMENT-2        
              MOVE 'LOC_NO'                 TO TABLE-ELEMENT-3          
              MOVE AT-PREMISE-NO            TO HOSTVAR-ELEMENT-3        
              MOVE 'DEVICE_NO'              TO TABLE-ELEMENT-4          
              MOVE EQ-DEVICE-NO             TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7520-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7600-CHECK-EQUIPMENT.                                          *        
      * CHECK IF THE DEVICE IS CURRENTLY INSTALLED ON THE PREMISE.     *        
      ******************************************************************        
       7600-CHECK-EQUIPMENT.                                            
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                              
                 INTO :WS-FLAG                                          
                 FROM  CSS_EQUIPMENT WITH(READUNCOMMITTED)                      
                WHERE  CRNT_LOC_NO       = :AT-PREMISE-NO               
                  AND  CODE_UTIL_TYPE    = :MV-CODE-UTIL-TYPE           
                  AND  DEVICE_NO         = :MV-DEVICE-NO                
                  AND  COMPANY_NO        = :AT-COMPANY-NO               
                  AND  EQUIP_TYPE_CD     = :WS-METER                    
                                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  'Y'                                                      
MFA-TR*          INTO :WS-FLAG                                                  
MFA-TR*          FROM  CSS_EQUIPMENT                                            
MFA-TR*         WHERE  CRNT_LOC_NO       = :AT-PREMISE-NO                       
MFA-TR*           AND  CODE_UTIL_TYPE    = :MV-CODE-UTIL-TYPE                   
MFA-TR*           AND  DEVICE_NO         = :MV-DEVICE-NO                        
MFA-TR*           AND  COMPANY_NO        = :AT-COMPANY-NO                       
MFA-TR*           AND  EQUIP_TYPE_CD     = :WS-METER                            
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7600'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_EQUIPMENT'          TO TABLE-1                  
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-1          
              MOVE MV-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-1        
              MOVE 'CRNT_LOC_NO'            TO TABLE-ELEMENT-2          
              MOVE AT-PREMISE-NO            TO HOSTVAR-ELEMENT-2        
              MOVE 'DEVICE_NO'              TO TABLE-ELEMENT-3          
              MOVE MV-DEVICE-NO             TO HOSTVAR-ELEMENT-3        
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-4          
              MOVE AT-COMPANY-NO            TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7650-GET-REMOVE-DATE                                           *        
      ******************************************************************        
       7650-GET-REMOVE-DATE.                                            
                                                                        
           EXEC SQL                                                     
               SELECT  MIN(DATE_MOVE)                                   
                 INTO :MV-DATE-MOVE :WS-NULL-IND                         
                 FROM  CSS_MOVEMENT_HIST                                
                WHERE  COMPANY_NO     = :MV-COMPANY-NO                  
                  AND  CODE_UTIL_TYPE = :MV-CODE-UTIL-TYPE              
                  AND  DEVICE_NO      = :MV-DEVICE-NO                   
                  AND  DATE_MOVE      > IIF(TRY_CONVERT(DATE, 
                                                          :MV-DATE-MOVE
              ) IS NULL OR (PATINDEX('%.%', :MV-DATE-MOVE
              ) <> 0) OR (LEN(:MV-DATE-MOVE) <> 10), CIS.CHAR2DATE(
                                                          :MV-DATE-MOVE
              ), CONVERT(DATE, :MV-DATE-MOVE) )                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  MIN(DATE_MOVE)                                           
MFA-TR*          INTO :MV-DATE-MOVE:WS-NULL-IND                                 
MFA-TR*          FROM  CSS_MOVEMENT_HIST                                        
MFA-TR*         WHERE  COMPANY_NO     = :MV-COMPANY-NO                          
MFA-TR*           AND  CODE_UTIL_TYPE = :MV-CODE-UTIL-TYPE                      
MFA-TR*           AND  DEVICE_NO      = :MV-DEVICE-NO                           
MFA-TR*           AND  DATE_MOVE      > :MV-DATE-MOVE                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7650'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_MOVEMENT_HIST'      TO TABLE-1                  
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-1          
              MOVE MV-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-1        
              MOVE 'DEVICE_NO'              TO TABLE-ELEMENT-2          
              MOVE MV-DEVICE-NO             TO HOSTVAR-ELEMENT-2        
              MOVE 'DATE_MOVE'              TO TABLE-ELEMENT-3          
              MOVE MV-DATE-MOVE             TO HOSTVAR-ELEMENT-3        
              MOVE 'COMAPNY_NO'             TO TABLE-ELEMENT-4          
              MOVE MV-COMPANY-NO            TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7650-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7700-SELECT-FROM-EQ                                            *        
      ******************************************************************        
       7700-SELECT-FROM-EQ.                                             
                                                                        
           EXEC SQL                                                     
               SELECT  DATE_LAST_MOVE                                   
                 INTO :EQ-DATE-LAST-MOVE                                
                 FROM  CSS_EQUIPMENT                                    
                WHERE  COMPANY_NO     = :EQ-COMPANY-NO                  
                  AND  CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE              
                  AND  DEVICE_NO      = :EQ-DEVICE-NO                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7700'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_EQUIPMENT'          TO TABLE-1                  
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-1          
              MOVE EQ-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-1        
              MOVE 'DEVICE_NO'              TO TABLE-ELEMENT-2          
              MOVE EQ-DEVICE-NO             TO HOSTVAR-ELEMENT-2        
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-3          
              MOVE EQ-COMPANY-NO            TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8000A-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000A-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04648_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04648_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000A'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04648_R1'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       8000A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      * 8000B-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000B-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04648_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04648_R2                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000B'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04648_R2'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       8000B-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      * 8000C-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000C-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04648_R3                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04648_R3                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000C'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04648_R3'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       8000C-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      * 8000D-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000D-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04648_R4                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04648_R4                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000D'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04648_R4'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       8000D-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 8010-INSERT-GTT-R1. ALL METERS ON THE PREMISE.                 *        
      ******************************************************************        
       8010-INSERT-GTT-R1.                                              
                                                                        
           EXEC SQL                                                     
               INSERT INTO #CSR04648_R1                          
                 (                                                      
                   RETURN_CODE                                          
                  ,CODE_UTIL_TYPE                                       
                  ,METER_NO                                             
                 )                                                      
               VALUES                                                   
                 (                                                      
                   :S-RETURN-CODE-RS1                                   
                  ,:S-CODE-UTIL-TYPE-RS1                                
                  ,:S-METER-NO-RS1                                      
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO SESSION.CSR04648_R1                                  
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,CODE_UTIL_TYPE                                               
MFA-TR*           ,METER_NO                                                     
MFA-TR*          )                                                              
MFA-TR*        VALUES                                                           
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-RS1                                           
MFA-TR*           ,:S-CODE-UTIL-TYPE-RS1                                        
MFA-TR*           ,:S-METER-NO-RS1                                              
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                        TO CTR-ROWS-RS1             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8010'                   TO ACTIVE-PARAGRAPH         
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSR04648_R1'            TO TABLE-1                  
              MOVE SPACES                   TO TABLE-ELEMENT-1          
              MOVE SPACES                   TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8020-INSERT-GTT-R2. MOVEMENT DATA FOR ALL METERS.              *        
      ******************************************************************        
       8020-INSERT-GTT-R2.                                              
                                                                        
           EXEC SQL                                                     
               INSERT INTO #CSR04648_R2                          
                 (                                                      
                   RETURN_CODE                                          
                  ,CODE_UTIL_TYPE                                       
                  ,METER_NO                                             
                  ,DATE_MOVE                                            
                 )                                                      
               VALUES                                                   
                 (                                                      
                   :S-RETURN-CODE-RS2                                   
                  ,:S-CODE-UTIL-TYPE-RS2                                
                  ,:S-METER-NO-RS2                                      
                  ,:S-MOVE-DATE-RS2                                     
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO SESSION.CSR04648_R2                                  
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,CODE_UTIL_TYPE                                               
MFA-TR*           ,METER_NO                                                     
MFA-TR*           ,DATE_MOVE                                                    
MFA-TR*          )                                                              
MFA-TR*        VALUES                                                           
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-RS2                                           
MFA-TR*           ,:S-CODE-UTIL-TYPE-RS2                                        
MFA-TR*           ,:S-METER-NO-RS2                                              
MFA-TR*           ,:S-MOVE-DATE-RS2                                             
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                        TO CTR-ROWS-RS2             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8020'                   TO ACTIVE-PARAGRAPH         
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSR04648_R2'            TO TABLE-1                  
              MOVE SPACES                   TO TABLE-ELEMENT-1          
              MOVE SPACES                   TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8030-INSERT-GTT-R3. TEST DATA FOR ALL METERS.                  *        
      ******************************************************************        
       8030-INSERT-GTT-R3.                                              
                                                                        
           EXEC SQL                                                     
               INSERT INTO #CSR04648_R3                          
                 (                                                      
                   RETURN_CODE                                          
                  ,CODE_UTIL_TYPE                                       
                  ,METER_NO                                             
                  ,DATE_TEST                                            
                  ,CODE_TEST_TYPE                                       
                  ,TEST_TYPE_DESC                                       
                  ,CODE_TEST_RESULT                                     
                  ,TEST_RESULT_DESC                                     
                  ,ACCURACY_PCT                                         
                 )                                                      
               VALUES                                                   
                 (                                                      
                   :S-RETURN-CODE-RS3                                   
                  ,:S-CODE-UTIL-TYPE-RS3                                
                  ,:S-METER-NO-RS3                                      
                  ,:S-TEST-DATE-RS3                                     
                  ,:S-CODE-TEST-TYPE-RS3                                
                  ,:S-TEST-TYPE-DESC-RS3                                
                  ,:S-CODE-TEST-RESULT-RS3                              
                  ,:S-TEST-RESULT-DESC-RS3                              
                  ,:S-ACCURACY-PCT-RS3                                  
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO SESSION.CSR04648_R3                                  
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,CODE_UTIL_TYPE                                               
MFA-TR*           ,METER_NO                                                     
MFA-TR*           ,DATE_TEST                                                    
MFA-TR*           ,CODE_TEST_TYPE                                               
MFA-TR*           ,TEST_TYPE_DESC                                               
MFA-TR*           ,CODE_TEST_RESULT                                             
MFA-TR*           ,TEST_RESULT_DESC                                             
MFA-TR*           ,ACCURACY_PCT                                                 
MFA-TR*          )                                                              
MFA-TR*        VALUES                                                           
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-RS3                                           
MFA-TR*           ,:S-CODE-UTIL-TYPE-RS3                                        
MFA-TR*           ,:S-METER-NO-RS3                                              
MFA-TR*           ,:S-TEST-DATE-RS3                                             
MFA-TR*           ,:S-CODE-TEST-TYPE-RS3                                        
MFA-TR*           ,:S-TEST-TYPE-DESC-RS3                                        
MFA-TR*           ,:S-CODE-TEST-RESULT-RS3                                      
MFA-TR*           ,:S-TEST-RESULT-DESC-RS3                                      
MFA-TR*           ,:S-ACCURACY-PCT-RS3                                          
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                        TO CTR-ROWS-RS3             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8030'                   TO ACTIVE-PARAGRAPH         
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSR04648_R3'            TO TABLE-1                  
              MOVE SPACES                   TO TABLE-ELEMENT-1          
              MOVE SPACES                   TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8040-INSERT-GTT-R4.  BUSINESS RULES.                           *        
      ******************************************************************        
       8040-INSERT-GTT-R4.                                              
                                                                        
           EXEC SQL                                                     
               INSERT INTO #CSR04648_R4                          
                 (                                                      
                   RETURN_CODE                                          
                  ,BUS_RULE_ID                                          
                  ,ACTION_TYPE_CD                                       
                  ,BUS_RULE_XREF_ID                                     
                 )                                                      
               VALUES                                                   
                 (                                                      
                   :S-RETURN-CODE-RS4                                   
                  ,:S-BUS-RULE-ID                                       
                  ,:S-ACTION-TYPE-CD                                    
                  ,:S-BUS-RULE-XREF-ID                                  
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO SESSION.CSR04648_R4                                  
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,BUS_RULE_ID                                                  
MFA-TR*           ,ACTION_TYPE_CD                                               
MFA-TR*           ,BUS_RULE_XREF_ID                                             
MFA-TR*          )                                                              
MFA-TR*        VALUES                                                           
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-RS4                                           
MFA-TR*           ,:S-BUS-RULE-ID                                               
MFA-TR*           ,:S-ACTION-TYPE-CD                                            
MFA-TR*           ,:S-BUS-RULE-XREF-ID                                          
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                        TO CTR-ROWS-RS4             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8040'                   TO ACTIVE-PARAGRAPH         
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSR04648_R4'            TO TABLE-1                  
              MOVE SPACES                   TO TABLE-ELEMENT-1          
              MOVE SPACES                   TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8040-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8800-CHECK-RESULTS.                                           *         
      *****************************************************************         
       8800-CHECK-RESULTS.                                              
                                                                        
           IF CTR-ROWS-RS1 <= 0                                         
              INITIALIZE                       GTT-RETURN-FIELDS-RS1    
              MOVE   0                      TO S-RETURN-CODE-RS1        
              PERFORM 8010-INSERT-GTT-R1       THRU 8010-EXIT           
           END-IF.                                                      
                                                                        
           IF CTR-ROWS-RS2 <= 0                                         
              INITIALIZE                       GTT-RETURN-FIELDS-RS2    
              MOVE   0                      TO S-RETURN-CODE-RS2        
              PERFORM 8020-INSERT-GTT-R2       THRU 8020-EXIT           
           END-IF.                                                      
                                                                        
           IF CTR-ROWS-RS3 <= 0                                         
              INITIALIZE                       GTT-RETURN-FIELDS-RS3    
              MOVE   0                      TO S-RETURN-CODE-RS3        
              PERFORM 8030-INSERT-GTT-R3       THRU 8030-EXIT           
           END-IF.                                                      
                                                                        
           IF CTR-ROWS-RS4 <= 0                                         
              INITIALIZE                       GTT-RETURN-FIELDS-RS4    
              MOVE   0                      TO S-RETURN-CODE-RS4        
              PERFORM 8040-INSERT-GTT-R4       THRU 8040-EXIT           
           END-IF.                                                      
                                                                        
       8800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8900-SEND-DONE.                                               *         
      *****************************************************************         
       8900-SEND-DONE.                                                  
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           EXEC SQL                                                     
               OPEN C2                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           EXEC SQL                                                     
               OPEN C3                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C3 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           EXEC SQL                                                     
               OPEN C4                                                  
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C4 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
                                                    
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 9000-SEND-ERROR-RESULT.                                       *         
      *****************************************************************         
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE       TO ABEND-SQLCODE            
                                               S-RETURN-CODE-RS1        
                                               S-RETURN-CODE-RS2        
                                               S-RETURN-CODE-RS3        
                                               S-RETURN-CODE-RS4.       
                                                                        
           MOVE SQLERRMC                    TO ABEND-SQLERRMC.          
                                                                        
           IF WS-GTT01-DECLARED = 'N'                                   
              PERFORM 0100A-DECLARE-GTT-R1     THRU 0100A-EXIT          
           END-IF.                                                      
                                                                        
           IF WS-GTT02-DECLARED = 'N'                                   
              PERFORM 0100B-DECLARE-GTT-R2     THRU 0100B-EXIT          
           END-IF.                                                      
                                                                        
           IF WS-GTT03-DECLARED = 'N'                                   
              PERFORM 0100C-DECLARE-GTT-R3     THRU 0100C-EXIT          
           END-IF.                                                      
                                                                        
           IF WS-GTT04-DECLARED = 'N'                                   
              PERFORM 0100D-DECLARE-GTT-R4     THRU 0100D-EXIT          
           END-IF.                                                      
                                                                        
           PERFORM 8010-INSERT-GTT-R1          THRU 8010-EXIT.          
           PERFORM 8020-INSERT-GTT-R2          THRU 8020-EXIT.          
           PERFORM 8030-INSERT-GTT-R3          THRU 8030-EXIT.          
           PERFORM 8040-INSERT-GTT-R4          THRU 8040-EXIT.          
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 9700-PROCESS-ABEND.                                           *         
      *****************************************************************         
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT      THRU 9000-EXIT.          
           PERFORM 9900-SQL-ERROR-ROUTINE      THRU 9900-EXIT.          
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 9900-SQL-ERROR-ROUTINE.                                       *         
      *****************************************************************         
       9900-SQL-ERROR-ROUTINE.                                          

MSQ002     EXEC SQL
MSQ002         SELECT LTRIM(RTRIM(CASE                                          
                        WHEN :TABLE-ELEMENT-1 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-1)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-1))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-2 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-2)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-2))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-3 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-3)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-3))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-4 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-4)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-4))                    
                        ELSE                                            
                           ''                                           
                     END))
MSQ002              , :ABEND-FUNCTION
MSQ002              , 'PARAGRAPH-' + LTRIM(RTRIM(:ACTIVE-PARAGRAPH)) + 
           ',' + 'TABLES-' + LTRIM(RTRIM(:TABLE-2)) + ',' + 
           LTRIM(RTRIM(:TABLE-3)) + ',' + LTRIM(RTRIM(:TABLE-4)) + 
           ',' + 'ERRMSG-' + LTRIM(RTRIM(:ABEND-SQLERRMC))
MSQ002           INTO :MFA-CSRERLOG.ARG-5
MSQ002              , :MFA-CSRERLOG.ARG-6
MSQ002              , :MFA-CSRERLOG.ARG-7
MSQ002     END-EXEC
                                                                        
           EXEC SQL                                                     
               CALL CSRERLOG ( :ABEND-PROGRAM
                  , :ABEND-SQLCODE
                  , :ABEND-SQLSTATE
                  , :TABLE-1
                  , :MFA-CSRERLOG.ARG-5
                  , :MFA-CSRERLOG.ARG-6
                  , :MFA-CSRERLOG.ARG-7
                  )                                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ002
MFA-TR*    EXEC SQL                                                             
MFA-TR*        CALL CSRERLOG (                                                  
MFA-TR*             :ABEND-PROGRAM,                                             
MFA-TR*             :ABEND-SQLCODE,                                             
MFA-TR*             :ABEND-SQLSTATE,                                            
MFA-TR*             :TABLE-1,                                                   
MFA-TR*              VARCHAR(STRIP(                                             
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-1 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-1) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-1)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-2 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-2) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-2)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-3 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-3) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-3)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-4 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-4) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-4)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END                                                        
MFA-TR*              )),                                                        
MFA-TR*              VARCHAR(:ABEND-FUNCTION),                                  
MFA-TR*              VARCHAR(                                                   
MFA-TR*              'PARAGRAPH-' CONCAT STRIP(:ACTIVE-PARAGRAPH) CONCAT        
MFA-TR*              ',' CONCAT 'TABLES-' CONCAT STRIP(:TABLE-2) CONCAT         
MFA-TR*              ',' CONCAT STRIP(:TABLE-3) CONCAT                          
MFA-TR*              ',' CONCAT STRIP(:TABLE-4) CONCAT                          
MFA-TR*              ',' CONCAT 'ERRMSG-' CONCAT STRIP(:ABEND-SQLERRMC)         
MFA-TR*              )                                                          
MFA-TR*             )                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           PERFORM 8900-SEND-DONE              THRU 8900-EXIT.          
           
MSQ016        GOBACK.                                                    
                                                                        
       9900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 9999-END-PROGRAM.                                             *         
      *****************************************************************         
       9999-END-PROGRAM.                                                
                                                                        
           PERFORM 8800-CHECK-RESULTS          THRU 8800-EXIT.          
           PERFORM 8900-SEND-DONE              THRU 8900-EXIT.          
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
