       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04647.                                         
COB303 DATE-WRITTEN.  JULY 22, 2013.                                    
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------         
      *--                 SOUTH CAROLINA ELECTRIC & GAS              --         
      *----------------------------------------------------------------         
      *--                  STORED PROCEDURE:  CSR04647               --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--  CSR04647 :                                                --         
      *--                                                            --         
      *--     SP CALLED FROM METERING & RATE MAINTENANCE METER       --         
      *--     HISTORY VIEW OF CIS PORTAL TO RETRIEVE METER MOVEMENT  --         
      *--     HISTORY DATA.                                          --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *--  PARAMETERS                                                --         
      *--                                                            --         
      *--      INPUT                                                 --         
      *--           CODE_UTIL_TYPE          CHAR(01)                 --         
      *--           DEVICE_TYPE             CHAR(01)                 --         
      *--           DEVICE_NO               CHAR(09)                 --         
      *--           COMPANY_NO              CHAR(02)                 --         
      *--                                                            --         
      *--      OUT                                                   --         
      *--           NONE                                             --         
      *--                                                            --         
      *--      INOUT                                                 --         
      *--           NONE                                             --         
      *--                                                            --         
      *--  RESULT SET                                                --         
      *--      1. CSR04647_R1 - METER/DEVICE MOVEMENT HISTORY.       --         
      *--           RETURN_CODE             INTEGER                  --         
      *--           DATE_MOVE               CHAR(10)                 --         
      *--           CODE_CRNT_LOC           CHAR(01)                 --         
      *--           EQUIP_LOC_DESC          CHAR(25)                 --         
      *--           LOCATION_ADDR           CHAR(60)                 --         
      *--                                                            --         
      *--      2. CSR04647_R2 - BUSINESS RULES.                      --         
      *--           RETURN_CODE             INTEGER                  --         
      *--           BUS_RULE_ID             CHAR(10)                 --         
      *--           ACTION_TYPE_CD          CHAR(08)                 --         
      *--           BUS_RULE_XREF_ID        CHAR(26)                 --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                      MODIFICATION LOG                      --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
P00738*--  07/22/2013    SS97726     PROCEDURE ORIGINALLY CODED.     --         
      *----------------------------------------------------------------         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04647'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-START                          PIC X(40) VALUE             
            'WORKING STORAGE FOR CSR04647 STARTS HERE'.                 
      *                                                                         
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-SUBROUTINE-IDS.                                       
               10  CSRERLOG                 PIC X(8)  VALUE 'CSRERLOG'. 
           05  PROGRAM-NAME                 PIC X(08) VALUE 'CSR04647'. 
      *                                                                         
       01  PARM-FIELDS.                                                 
           05  PARM-L                       PIC S9(9) COMP.             
           05  PARM-CODE-UTIL-TYPE          PIC X(01).                  
           05  PARM-CODE-DEVICE-TYPE        PIC X(01).                  
           05  PARM-DEVICE-NO               PIC X(09).                  
           05  PARM-COMPANY-NO              PIC X(02).                  
      *                                                                         
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS-RS1                 PIC S9(9) COMP VALUE 0.     
           05  CTR-ROWS-RS2                 PIC S9(9) COMP VALUE 0.     
      *                                                                         
       01  WS-MISC.                                                     
           05  WS-D                         PIC X(01) VALUE 'D'.        
           05  WS-E                         PIC X(01) VALUE 'E'.        
           05  WS-J                         PIC X(01) VALUE 'J'.        
           05  WS-K                         PIC X(01) VALUE 'K'.        
           05  WS-M                         PIC X(01) VALUE 'M'.        
           05  WS-T                         PIC X(01) VALUE 'T'.        
           05  WS-YES                       PIC X(01) VALUE 'Y'.        
           05  WS-NO                        PIC X(01) VALUE 'N'.        
           05  WS-ACTIVE-CODE               PIC X(01) VALUE 'A'.        
           05  WS-ADDRESS-ID-NUM            PIC 9(13) VALUE 0.          
           05  WS-ADDRESS-ID                REDEFINES WS-ADDRESS-ID-NUM 
                                            PIC X(13).                  
           05  WS-DUMMY-DATE                PIC X(10) VALUE SPACES.     
           05  WS-CURRENT-DATE              PIC X(10) VALUE SPACES.     
           05  WS-DB2-CURRENT-DATE          PIC X(10).                  
           05  WS-NULL-IND-1                PIC S9(04) COMP.            
           05  WS-NULL-IND-2                PIC S9(04) COMP.            
           05  WS-NULL-IND-3                PIC S9(04) COMP.            
           05  WS-DATE-LAST-MOVE-NULL       PIC S9(04) COMP VALUE ZERO. 
               88 DATE-LAST-MOVE-NULL                 VALUE -1.         
           05  WS-ADDR-UNKNOWN-MSG          PIC X(30) VALUE             
                            'PREMISE ADDR NOT AVAILABLE FOR'.           
           05  WS-SQLSTATE                  PIC X(05) VALUE SPACES.     
           05  WS-GTT-NAME                  PIC X(19) VALUE SPACES.     
           05  WS-GTT01-DECLARED            PIC X(01) VALUE 'N'.        
           05  WS-GTT02-DECLARED            PIC X(01) VALUE 'N'.        
           05  WS-SAVE-RETURN-CODE          PIC S9(9) COMP VALUE 0.     
      *                                                                         
       01  WS-PR-ADDRESS.                                               
           05  WS-PR-ADR-STR                PIC X(30).                  
           05  WS-PR-ADDR-FILLER            PIC X(01).                  
           05  WS-PR-CITY-ST-ZIP            PIC X(24).                  
      *                                                                         
       01  WS-METER-INFO.                                               
           05  FILLER                       PIC X(10) VALUE             
                            'METER NO: '.                               
           05  WS-METER-NO                  PIC X(09).                  
           05  FILLER                       PIC X(41) VALUE SPACES.     
      *                                                                         
       01  WS-NEW-MSF.                                                  
           05  FILLER                       PIC X(15) VALUE SPACES.     
           05  WS-PRE-DET1                  PIC X(14) VALUE             
                            'OLD ACCT NBR :'.                           
           05  FILLER                       PIC X(03) VALUE SPACES.     
           05  WS-PRE-ADD.                                              
               07  WS-PRE-LL                PIC 9(02).                  
               07  FILLER                   PIC X(01) VALUE '-'.        
               07  WS-PRE-RR                PIC 9(04).                  
               07  FILLER                   PIC X(01) VALUE '-'.        
               07  WS-PRE-FF                PIC 9(04).                  
           05  FILLER                       PIC X(16).                  
      *                                                                         
       01  WS-LOC-NO                        PIC 9(10).                  
      *                                                                         
       01  WS-LOC-NO1                       REDEFINES WS-LOC-NO.        
           05  WS-PRE-LL1                   PIC 9(02).                  
           05  WS-PRE-RR1                   PIC 9(04).                  
           05  WS-PRE-FF1                   PIC 9(04).                  
      *                                                                         
       01  WS-SWITCHES.                                                 
           05  WS-NO-MORE-ROWS              PIC X(01) VALUE 'N'.        
               88 NO-MORE-ROWS                        VALUE 'Y'.        
           05  ALL-DONE-SW                  PIC X(01) VALUE 'N'.        
               88 NOT-ALL-DONE                        VALUE 'N'.        
               88 ALL-DONE                            VALUE 'Y'.        
           05  SEND-DONE-SW                 PIC X(01) VALUE 'Y'.        
               88 SEND-DONE-ERROR                     VALUE 'N'.        
               88 SEND-DONE-OK                        VALUE 'Y'.        
           05  WS-MST-SUB-ACCT-IND          PIC X(01) VALUE SPACES.     
               88 MASTER-ACCOUNT                      VALUE 'M'.        
      *                                                                         
      ******************************************************************        
      *    ERROR PROCESSING VARIABLES                                  *        
      ******************************************************************        
      *                                                                         
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                    PIC X(18) VALUE SPACES.     
           10  S-SQLCODE                    PIC S9(9) COMP VALUE 0.     
           10  S-SQLSTATE                   PIC X(5)  VALUE ' '.        
           10  S-TABLE-NAME                 PIC X(18) VALUE SPACES.     
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L       PIC S9(4) USAGE COMP.       
               49  S-HOST-VARIABLES-V       PIC X(255).                 
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L        PIC S9(4) USAGE COMP.       
               49  S-SQL-STATEMENT-V        PIC X(255).                 
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L      PIC S9(4) USAGE COMP.       
               49  S-SQL-DESCRIPTION-V      PIC X(255).                 
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L      PIC S9(4) USAGE COMP.       
               49  WS-ABEND-SQLERRMC-V      PIC X(255).                 
      *                                                                         
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE               PIC S9(9) COMP VALUE 0.     
      *                                                                         
       01 GTT-RETURN-FIELDS.                                            
      ******************************************************************        
      *   GTT TABLE LAYOUT METER MOVEMENT HISTORY DATA.                *        
      ******************************************************************        
          05  GTT-RETURN-FIELDS-1.                                      
              10  S-RETURN-CODE-1           PIC S9(9) COMP VALUE 0.     
              10  S-DATE-MOVE               PIC X(10) VALUE SPACES.     
              10  S-CODE-CRNT-LOC           PIC X(01) VALUE SPACES.     
              10  S-EQUIP-LOC-DESC          PIC X(25) VALUE SPACES.     
              10  S-LOCATION                PIC X(60) VALUE SPACES.     
      *                                                                         
      ******************************************************************        
      *   GTT TABLE LAYOUT FOR BUSINESS RULES.                         *        
      ******************************************************************        
          05  GTT-RETURN-FIELDS-2.                                      
              10  S-RETURN-CODE-2           PIC S9(9) COMP VALUE ZERO.  
              10  S-BUS-RULE-ID             PIC X(10) VALUE SPACES.     
              10  S-ACTION-TYPE-CD          PIC X(08) VALUE SPACES.     
              10  S-BUS-RULE-XREF-ID        PIC X(26) VALUE SPACES.     
      *                                                                         
      ******************************************************************        
      *               COBOL WORKING STORAGE COPY BOOKS                 *        
      ******************************************************************        
      *                                                                         
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_ACCOUNT        (AT)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_EQUIPMENT      (EQ)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBEQUIP                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_EQUIP_LOCATION (M6)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBEQLOC                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_METER_ATTCHMTS (MA)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBMTRATT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_MOVEMENT_HIST  (MV)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBMVHIST                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_PREMISE        (PR)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_ADDR_FORMATTED (DY)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_ADDR_FREEFORM  (DZ)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBADRFRE                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_ACCT_MISC_INFO (TA)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBATMISC                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_CUST_ADDR_XREF (DM)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCSADRX                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_LOCAL_OFFICE   (B1)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBLOCOFC                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_MTR_STORGE_FAC (W9)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBMTRFAC                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_NAME           (DQ)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_NAME_ACCT_XREF (HT)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBNMACTX                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_ZIP_CODE       (A4)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBZIPCD                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
      *                                                                         
      ******************************************************************        
      *    ERROR HANDLING                                                       
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    SUPPORTS DB2 AND SQL ERROR CHECKING                         *        
      ******************************************************************        
      *                                                                         
           COPY CWS00303.                                                       
      *                                                                         
      ******************************************************************        
      *    ADDRESS FORMATTING ROUTINE REQUIRED COPYBOOKS               *        
      ******************************************************************        
      *                                                                         
           COPY CWS00011.                                                       
           COPY CWS00074.                                                       
      *                                                                         
      ******************************************************************        
      *    CURSOR DECLARATIONS.                                        *        
      ******************************************************************        
      *                                                                         
      ******************************************************************        
      *    GET ALL MOVEMENT HISTORY FOR THE METER/DEVICE.              *        
      ******************************************************************        
           EXEC SQL                                                     
             DECLARE MV-CURSOR CURSOR FOR                               
                 SELECT LOCAL_OFFICE,                                   
                        CIS.CHAR2$DATE(DATE_MOVE,'USA'),                        
                        DATE_MOVE,                                      
                        LOC_NO,                                         
                        CODE_CRNT_LOC,                                  
                        REPLACE(REPLACE(CONVERT(CHAR(26), MOVE_NO
           , 121), ' ', '-'), ':', '.') MOVE_NO                                
                   FROM CSS_MOVEMENT_HIST                               
                  WHERE COMPANY_NO       = :MV-COMPANY-NO               
                    AND CODE_UTIL_TYPE   = :MV-CODE-UTIL-TYPE           
                    AND CODE_DEVICE_TYPE = :MV-CODE-DEVICE-TYPE         
                    AND DEVICE_NO        = :MV-DEVICE-NO                
                 ORDER BY MOVE_NO DESC                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE MV-CURSOR CURSOR FOR                                       
MFA-TR*          SELECT LOCAL_OFFICE,                                           
MFA-TR*                 CHAR(DATE_MOVE,USA),                                    
MFA-TR*                 DATE_MOVE,                                              
MFA-TR*                 LOC_NO,                                                 
MFA-TR*                 CODE_CRNT_LOC,                                          
MFA-TR*                 MOVE_NO                                                 
MFA-TR*            FROM CSS_MOVEMENT_HIST                                       
MFA-TR*           WHERE COMPANY_NO       = :MV-COMPANY-NO                       
MFA-TR*             AND CODE_UTIL_TYPE   = :MV-CODE-UTIL-TYPE                   
MFA-TR*             AND CODE_DEVICE_TYPE = :MV-CODE-DEVICE-TYPE                 
MFA-TR*             AND DEVICE_NO        = :MV-DEVICE-NO                        
MFA-TR*          ORDER BY MOVE_NO DESC                                          
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       LINKAGE SECTION.                                                 
       01  I-CODE-UTIL-TYPE                 PIC X(01).                  
       01  I-CODE-DEVICE-TYPE               PIC X(01).                  
       01  I-DEVICE-NO                      PIC X(09).                  
       01  I-COMPANY-NO                     PIC X(02).                  
      *                                                                         
       PROCEDURE DIVISION USING I-CODE-UTIL-TYPE                        
                                I-CODE-DEVICE-TYPE                      
                                I-DEVICE-NO                             
                                I-COMPANY-NO.                           
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION         THRU 0100-EXIT.          
           PERFORM 1000-PROCESS-INPUT          THRU 1000-EXIT.          
           PERFORM 2000-BUILD-RESULT           THRU 2000-EXIT.          
           PERFORM 9999-END-PROGRAM            THRU 9999-EXIT.          
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 0100-INITIALIZATION.                                          *         
      *****************************************************************         
       0100-INITIALIZATION.                                             
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE 'N'                         TO WS-GTT01-DECLARED        
                                               WS-GTT02-DECLARED.       
           EXEC SQL                                                     
               WHENEVER SQLWARNING                                      
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLERROR                                        
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER NOT FOUND                                       
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1        THRU 0100A-EXIT.         
           PERFORM 0100B-DECLARE-GTT-R2        THRU 0100B-EXIT.         
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100A-DECLARE-GTT-R1 - METER MOVEMENT DATA.                    *        
      ******************************************************************        
       0100A-DECLARE-GTT-R1.                                            
                                                                        
           MOVE 'SESSION.CSR04647_R1'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04647_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04647_R1
              (                                                      
                    RETURN_CODE             INT                     
                   ,DATE_MOVE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,CODE_CRNT_LOC CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,EQUIP_LOC_DESC CHAR(25)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,LOCATION CHAR(60)  COLLATE LATIN1_GENERAL_100_BIN2          
                 )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS       THRU 8000A-EXIT          
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE 'Y'                   TO WS-GTT01-DECLARED        
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100A'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT           
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE           AS RETURN_CODE             
                      ,LTRIM(RTRIM(DATE_MOVE))      AS DATE_MOVE               
                      ,LTRIM(RTRIM(CODE_CRNT_LOC))  AS CODE_CRNT_LOC           
                      ,LTRIM(RTRIM(EQUIP_LOC_DESC)) AS EQUIP_LOC_DESC          
                      ,LTRIM(RTRIM(LOCATION))       AS LOCATION_ADDR           
                  FROM #CSR04647_R1                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE           AS RETURN_CODE                     
MFA-TR*               ,STRIP(DATE_MOVE)      AS DATE_MOVE                       
MFA-TR*               ,STRIP(CODE_CRNT_LOC)  AS CODE_CRNT_LOC                   
MFA-TR*               ,STRIP(EQUIP_LOC_DESC) AS EQUIP_LOC_DESC                  
MFA-TR*               ,STRIP(LOCATION)       AS LOCATION_ADDR                   
MFA-TR*           FROM SESSION.CSR04647_R1                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 0100B-DECLARE-GTT-R2 - BUSINESS RULES                          *        
      ******************************************************************        
       0100B-DECLARE-GTT-R2.                                            
                                                                        
           MOVE 'SESSION.CSR04647_R2'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04647_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04647_R2
              (                                                      
                    RETURN_CODE             INT                     
                   ,BUS_RULE_ID CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,ACTION_TYPE_CD CHAR(08)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BUS_RULE_XREF_ID CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                 )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000B-DEL-GTT-ROWS       THRU 8000B-EXIT          
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE 'Y'                   TO WS-GTT02-DECLARED        
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100B'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT           
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C2 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE           AS RETURN_CODE             
                      ,BUS_RULE_ID           AS BUS_RULE_ID             
                      ,ACTION_TYPE_CD        AS ACTION_TYPE_CD          
                      ,BUS_RULE_XREF_ID      AS BUS_RULE_XREF_ID        
                  FROM #CSR04647_R2                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C2 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE           AS RETURN_CODE                     
MFA-TR*               ,BUS_RULE_ID           AS BUS_RULE_ID                     
MFA-TR*               ,ACTION_TYPE_CD        AS ACTION_TYPE_CD                  
MFA-TR*               ,BUS_RULE_XREF_ID      AS BUS_RULE_XREF_ID                
MFA-TR*           FROM SESSION.CSR04647_R2                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100B-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT.                                            *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE I-CODE-UTIL-TYPE            TO PARM-CODE-UTIL-TYPE.     
           MOVE I-CODE-DEVICE-TYPE          TO PARM-CODE-DEVICE-TYPE.   
           MOVE I-DEVICE-NO                 TO PARM-DEVICE-NO.          
           MOVE I-COMPANY-NO                TO PARM-COMPANY-NO.         
                                                                        
           IF (I-CODE-UTIL-TYPE   EQUAL SPACES OR LOW-VALUES) OR        
              (I-CODE-DEVICE-TYPE EQUAL SPACES OR LOW-VALUES) OR        
              (I-DEVICE-NO        EQUAL SPACES OR LOW-VALUES) OR        
              (I-COMPANY-NO       EQUAL SPACES OR LOW-VALUES)           
              MOVE +100                     TO WS-ACTIVE-RETURN-CODE    
              MOVE 'PARM ERROR'             TO S-BUS-RULE-ID            
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
           MOVE PARM-CODE-UTIL-TYPE         TO MV-CODE-UTIL-TYPE.       
           MOVE PARM-CODE-DEVICE-TYPE       TO MV-CODE-DEVICE-TYPE.     
           MOVE PARM-DEVICE-NO              TO MV-DEVICE-NO.            
           MOVE PARM-COMPANY-NO             TO MV-COMPANY-NO.           
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-BUILD-RESULT.                                             *        
      ******************************************************************        
       2000-BUILD-RESULT.                                               
                                                                        
           MOVE '2000'                      TO ACTIVE-PARAGRAPH.        
           PERFORM 2100-SELECT-CURR-LOC        THRU 2100-EXIT.          
           PERFORM 2200-BUILD-MV               THRU 2200-EXIT.          
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2100-SELECT-CURR-LOC.                                          *        
      ******************************************************************        
       2100-SELECT-CURR-LOC.                                            
                                                                        
           MOVE '2100'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           MOVE PARM-COMPANY-NO             TO EQ-COMPANY-NO.           
           MOVE PARM-CODE-UTIL-TYPE         TO EQ-CODE-UTIL-TYPE.       
           MOVE PARM-CODE-DEVICE-TYPE       TO EQ-EQUIP-TYPE-CD.        
           MOVE PARM-DEVICE-NO              TO EQ-DEVICE-NO.            
                                                                        
           PERFORM 7170-SELECT-EQUIP           THRU 7170-EXIT.          
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              PERFORM 2150-LOAD-METER-DATA     THRU 2150-EXIT           
           END-IF.                                                      
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2150-LOAD-METER-DATA.                                          *        
      ******************************************************************        
       2150-LOAD-METER-DATA.                                            
                                                                        
           MOVE EQ-DATE-LAST-MOVE           TO S-DATE-MOVE              
           MOVE EQ-CODE-CRNT-LOC            TO S-CODE-CRNT-LOC          
           MOVE EQ-CODE-CRNT-LOC            TO MV-CODE-CRNT-LOC         
           MOVE PARM-COMPANY-NO             TO MA-COMPANY-NO.           
                                                                        
           PERFORM 7130-SELECT-LOCATION-TYPE   THRU 7130-EXIT           
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE M6-EQUIP-LOC-DESC        TO S-EQUIP-LOC-DESC         
           ELSE                                                         
              MOVE SPACES                   TO S-EQUIP-LOC-DESC         
           END-IF                                                       
                                                                        
           IF (MV-CODE-CRNT-LOC    = WS-K  AND                          
                (EQ-CODE-UTIL-TYPE = 'E'   AND EQ-EQUIP-TYPE-CD = 'M')) 
             OR                                                         
              (MV-CODE-CRNT-LOC    = WS-K  AND EQ-EQUIP-TYPE-CD = 'T')  
              PERFORM 7160-GET-METER-NO        THRU 7160-EXIT           
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                 MOVE MA-METER-NO           TO WS-METER-NO              
                 MOVE WS-METER-INFO         TO S-LOCATION               
              ELSE                                                      
                 MOVE SPACES                TO S-LOCATION               
              END-IF                                                    
           ELSE                                                         
              IF MV-CODE-CRNT-LOC = WS-J OR WS-K                        
                 MOVE EQ-CRNT-LOC-NO        TO MV-LOC-NO                
                 MOVE EQ-CRNT-LOC-NO        TO PR-PREMISE-NO            
                 MOVE ZEROS                 TO DY-ADDRESS-ID            
                                                                        
                 PERFORM 7150-GET-ADDRESS-ID   THRU 7150-EXIT           
                                                                        
                 IF DY-ADDRESS-ID > 0                                   
                    PERFORM 4050-GET-FORMATTED-ADDRESS                  
                                               THRU 4050-EXIT           
                    MOVE RS-RETURN-CODE     TO WS-ACTIVE-RETURN-CODE    
                    IF WS-FMT-ADDR-STREET > SPACES                      
                       MOVE WS-FMT-ADDR-STREET                          
                                            TO WS-PR-ADR-STR            
                       MOVE WS-FMT-CITY-STATE-ZIP                       
                                            TO WS-PR-CITY-ST-ZIP        
                       MOVE SPACE           TO WS-PR-ADDR-FILLER        
                       MOVE WS-PR-ADDRESS   TO S-LOCATION               
                    END-IF                                              
                 END-IF                                                 
                                                                        
                 IF DY-ADDRESS-ID NOT > 0 OR                            
                    WS-FMT-ADDR-STREET EQUAL SPACES                     
                    IF MV-CODE-CRNT-LOC = WS-J                          
                       MOVE WS-ADDR-UNKNOWN-MSG                         
                                            TO WS-PR-ADR-STR            
                       MOVE MV-LOC-NO       TO WS-PR-CITY-ST-ZIP        
                       MOVE SPACE           TO WS-PR-ADDR-FILLER        
                       MOVE WS-PR-ADDRESS   TO S-LOCATION               
                    ELSE                                                
                       PERFORM 7140-SELECT-MTR-STR-FAC                  
                                               THRU 7140-EXIT           
                       IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL   
                          MOVE W9-MTR-STORAGE-FAC-TX                    
                                            TO S-LOCATION               
                       ELSE                                             
                          MOVE SPACES       TO S-LOCATION               
                       END-IF                                           
                    END-IF                                              
                 END-IF                                                 
              ELSE                                                      
                 IF MV-CODE-CRNT-LOC = 'X'                              
                    MOVE EQ-CRNT-LOC-NO     TO WS-LOC-NO                
                    MOVE WS-PRE-LL1         TO WS-PRE-LL                
                    MOVE WS-PRE-RR1         TO WS-PRE-RR                
                    MOVE WS-PRE-FF1         TO WS-PRE-FF                
                    MOVE WS-NEW-MSF         TO S-LOCATION               
                 ELSE                                                   
                    MOVE EQ-LOCAL-OFFICE    TO MV-LOCAL-OFFICE          
                    PERFORM 7140-SELECT-MTR-STR-FAC                     
                                               THRU 7140-EXIT           
                    IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL      
                       MOVE W9-MTR-STORAGE-FAC-TX                       
                                            TO S-LOCATION               
                    ELSE                                                
                       MOVE SPACES          TO S-LOCATION               
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
           PERFORM 8010-INSERT-GTT-R1          THRU 8010-EXIT.          
                                                                        
       2150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2200-BUILD-MV                                                  *        
      *     BUILD THE METER/DEVICE MOVEMENT DATA.                      *        
      ******************************************************************        
       2200-BUILD-MV.                                                   
                                                                        
           MOVE '2200'                      TO ACTIVE-PARAGRAPH.        
           MOVE ZEROS                       TO WS-SAVE-RETURN-CODE.     
                                                                        
           PERFORM 7100-OPEN-MV-CURSOR         THRU  7100-EXIT.         
           PERFORM 7110-FETCH-MV-ROW           THRU  7110-EXIT.         
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE       TO WS-SAVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
               MOVE WS-ACTIVE-RETURN-CODE   TO S-RETURN-CODE-1          
               MOVE SPACES                  TO S-DATE-MOVE              
               MOVE SPACES                  TO S-CODE-CRNT-LOC          
               MOVE SPACES                  TO S-EQUIP-LOC-DESC         
               MOVE SPACES                  TO S-LOCATION               
               PERFORM 8010-INSERT-GTT-R1      THRU 8010-EXIT           
           END-IF                                                       
                                                                        
           MOVE WS-SAVE-RETURN-CODE         TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           PERFORM 2250-PROCESS-MV-CURSOR      THRU 2250-EXIT           
             UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.                   
                                                                        
           PERFORM 7120-CLOSE-MV-CURSOR        THRU 7120-EXIT.          
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2250-PROCESS-MV-CURSOR                                         *        
      ******************************************************************        
       2250-PROCESS-MV-CURSOR.                                          
                                                                        
           MOVE '2250'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE MV-DATE-MOVE             TO S-DATE-MOVE              
              MOVE MV-CODE-CRNT-LOC         TO S-CODE-CRNT-LOC          
              PERFORM 7130-SELECT-LOCATION-TYPE                         
                                               THRU 7130-EXIT           
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                 MOVE M6-EQUIP-LOC-DESC     TO S-EQUIP-LOC-DESC         
              ELSE                                                      
                 MOVE SPACES                TO S-EQUIP-LOC-DESC         
              END-IF                                                    
                                                                        
              IF MV-CODE-CRNT-LOC = WS-J OR WS-K                        
                 MOVE MV-LOC-NO             TO PR-PREMISE-NO            
                 MOVE ZEROS                    TO DY-ADDRESS-ID         
                 PERFORM 7150-GET-ADDRESS-ID   THRU 7150-EXIT           
                                                                        
                 IF DY-ADDRESS-ID > 0                                   
                    PERFORM 4050-GET-FORMATTED-ADDRESS                  
                                               THRU 4050-EXIT           
                    MOVE RS-RETURN-CODE     TO WS-ACTIVE-RETURN-CODE    
                    IF WS-FMT-ADDR-STREET > SPACES                      
                       MOVE WS-FMT-ADDR-STREET                          
                                            TO WS-PR-ADR-STR            
                       MOVE WS-FMT-CITY-STATE-ZIP                       
                                            TO WS-PR-CITY-ST-ZIP        
                       MOVE SPACE           TO WS-PR-ADDR-FILLER        
                       MOVE WS-PR-ADDRESS   TO S-LOCATION               
                    END-IF                                              
                 END-IF                                                 
                                                                        
                 IF DY-ADDRESS-ID NOT > 0                               
                     OR WS-FMT-ADDR-STREET EQUAL SPACES                 
                    IF MV-CODE-CRNT-LOC = WS-J                          
                       MOVE WS-ADDR-UNKNOWN-MSG                         
                                            TO WS-PR-ADR-STR            
                       MOVE MV-LOC-NO       TO WS-PR-CITY-ST-ZIP        
                       MOVE SPACE           TO WS-PR-ADDR-FILLER        
                       MOVE WS-PR-ADDRESS   TO S-LOCATION               
                    ELSE                                                
                       PERFORM 7140-SELECT-MTR-STR-FAC                  
                                               THRU 7140-EXIT           
                       IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL   
                          MOVE W9-MTR-STORAGE-FAC-TX                    
                                            TO S-LOCATION               
                       ELSE                                             
                          MOVE SPACES       TO S-LOCATION               
                       END-IF                                           
                    END-IF                                              
                 END-IF                                                 
              ELSE                                                      
                 IF MV-CODE-CRNT-LOC = 'X'                              
                    MOVE MV-LOC-NO          TO WS-LOC-NO                
                    MOVE WS-PRE-LL1         TO WS-PRE-LL                
                    MOVE WS-PRE-RR1         TO WS-PRE-RR                
                    MOVE WS-PRE-FF1         TO WS-PRE-FF                
                    MOVE WS-NEW-MSF         TO S-LOCATION               
                 ELSE                                                   
                    PERFORM 7140-SELECT-MTR-STR-FAC                     
                                               THRU 7140-EXIT           
                    IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL      
                       MOVE W9-MTR-STORAGE-FAC-TX                       
                                            TO S-LOCATION               
                    ELSE                                                
                       MOVE SPACES          TO S-LOCATION               
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO S-RETURN-CODE-1          
              MOVE SPACES                   TO S-DATE-MOVE              
              MOVE SPACES                   TO S-CODE-CRNT-LOC          
              MOVE SPACES                   TO S-EQUIP-LOC-DESC         
              MOVE SPACES                   TO S-LOCATION               
           END-IF.                                                      
                                                                        
           PERFORM 8010-INSERT-GTT-R1          THRU 8010-EXIT.          
           PERFORM 7110-FETCH-MV-ROW           THRU 7110-EXIT.          
                                                                        
       2250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * COPYBOOK ROUTINE TO GET ADDRESS.                               *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00004                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00074                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 7100-OPEN-MV-CURSOR.                                           *        
      *                                                                *        
      *   THIS PARAGRAPH IS USED TO OPEN THE CURSOR USED TO FETCH      *        
      *   ROWS FROM THE CSS_MOVEMENT_HIST TABLE.                       *        
      *                                                                *        
      ******************************************************************        
       7100-OPEN-MV-CURSOR.                                             
                                                                        
           MOVE '7100'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
               OPEN MV-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_MOVEMENT_HIST'      TO TABLE-1                  
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-1          
              MOVE 'CODE_DEVICE_TYPE'       TO TABLE-ELEMENT-2          
              MOVE 'DEVICE_NO'              TO TABLE-ELEMENT-3          
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-4          
              MOVE MV-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-1        
              MOVE MV-CODE-DEVICE-TYPE      TO HOSTVAR-ELEMENT-2        
              MOVE MV-DEVICE-NO             TO HOSTVAR-ELEMENT-3        
              MOVE MV-COMPANY-NO            TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7110-FETCH-MV-ROW                                              *        
      *                                                                *        
      *   THIS PARAGRAPH IS USED TO OBTAIN THE NEXT ROW FROM THE       *        
      *   CSS_MOVEMENT_HIST TABLE                                      *        
      *                                                                *        
      ******************************************************************        
       7110-FETCH-MV-ROW.                                               
                                                                        
           MOVE '7110'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
               FETCH  MV-CURSOR                                         
                INTO :MV-LOCAL-OFFICE                                   
                    ,:MV-DATE-MOVE :WS-NULL-IND-1                        
                    ,:WS-DUMMY-DATE :WS-NULL-IND-2                       
                    ,:MV-LOC-NO :WS-NULL-IND-3                           
                    ,:MV-CODE-CRNT-LOC                                  
                    ,:MV-MOVE-NO                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF WS-NULL-IND-1 < 0                                         
              MOVE SPACES                   TO MV-DATE-MOVE             
           END-IF.                                                      
                                                                        
           IF WS-NULL-IND-2 < 0                                         
              MOVE SPACES                   TO WS-DUMMY-DATE            
           END-IF.                                                      
                                                                        
           IF WS-NULL-IND-3 < 0                                         
              MOVE 0                        TO MV-LOC-NO                
           END-IF.                                                      
                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE 'FETCH'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_MOVEMENT_HIST'      TO TABLE-1                  
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-1          
              MOVE 'CODE_DEVICE_TYPE'       TO TABLE-ELEMENT-2          
              MOVE 'DEVICE_NO'              TO TABLE-ELEMENT-3          
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-4          
              MOVE MV-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-1        
              MOVE MV-CODE-DEVICE-TYPE      TO HOSTVAR-ELEMENT-2        
              MOVE MV-DEVICE-NO             TO HOSTVAR-ELEMENT-3        
              MOVE MV-COMPANY-NO            TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7120-CLOSE-MV-CURSOR                                           *        
      *                                                                *        
      *   THIS PARAGRAPH IS USED TO CLOSE THE CURSOR USED TO FETCH     *        
      *   ROWS FROM THE CSS_MOVEMENT_HIST TABLE.                       *        
      *                                                                *        
      ******************************************************************        
       7120-CLOSE-MV-CURSOR.                                            
                                                                        
           MOVE '7120'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
               CLOSE MV-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_MOVEMENT_HIST'      TO TABLE-1                  
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-1          
              MOVE 'CODE_DEVICE_TYPE'       TO TABLE-ELEMENT-2          
              MOVE 'DEVICE_NO'              TO TABLE-ELEMENT-3          
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-4          
              MOVE MV-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-1        
              MOVE MV-CODE-DEVICE-TYPE      TO HOSTVAR-ELEMENT-2        
              MOVE MV-DEVICE-NO             TO HOSTVAR-ELEMENT-3        
              MOVE MV-COMPANY-NO            TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7130-SELECT-LOCATION-TYPE                                      *        
      ******************************************************************        
       7130-SELECT-LOCATION-TYPE.                                       
                                                                        
           MOVE '7130'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
               SELECT  EQUIP_LOC_DESC                                   
                 INTO :M6-EQUIP-LOC-DESC                                
                 FROM  CSS_EQUIP_LOCATION                               
                WHERE  EQUIP_LOC_ID     = :MV-CODE-CRNT-LOC             
                  AND  CODE_UTIL_TYPE   = :MV-CODE-UTIL-TYPE            
                  AND  COMPANY_NO       = :MV-COMPANY-NO                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_EQUIP_LOCATION'     TO TABLE-1                  
              MOVE 'EQUIP_LOC_ID  '         TO TABLE-ELEMENT-1          
              MOVE 'DEVICE_NO'              TO TABLE-ELEMENT-2          
              MOVE MV-CODE-CRNT-LOC         TO HOSTVAR-ELEMENT-1        
              MOVE PARM-DEVICE-NO           TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7130-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7140-SELECT-MTR-STR-FAC                                       *         
      ******************************************************************        
       7140-SELECT-MTR-STR-FAC.                                         
                                                                        
           MOVE '7140'                      TO ACTIVE-PARAGRAPH.        
           MOVE PARM-CODE-UTIL-TYPE         TO W9-CODE-UTIL-TYPE.       
           MOVE PARM-COMPANY-NO             TO W9-COMPANY-NO.           
                                                                        
           EXEC SQL                                                     
               SELECT  MTR_STORAGE_FAC_TX                               
                 INTO :W9-MTR-STORAGE-FAC-TX                            
                 FROM  CSS_MTR_STORGE_FAC                               
                WHERE  CODE_UTIL_TYPE     = :W9-CODE-UTIL-TYPE          
                  AND  COMPANY_NO         = :W9-COMPANY-NO              
                  AND  MTR_STORAGE_FAC_CD = :MV-LOCAL-OFFICE            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_MTR_STORGE_FAC'     TO TABLE-1                  
              MOVE 'MTR_STORAGE_FAC_CD'     TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'DEVICE_NO'              TO TABLE-ELEMENT-3          
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-4          
              MOVE MV-LOCAL-OFFICE          TO HOSTVAR-ELEMENT-1        
              MOVE W9-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE PARM-DEVICE-NO           TO HOSTVAR-ELEMENT-3        
              MOVE W9-COMPANY-NO            TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7140-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7150-GET-ADDRESS-ID.                                          *         
      ******************************************************************        
       7150-GET-ADDRESS-ID.                                             
                                                                        
           EXEC SQL                                                     
               SELECT  ADDRESS_ID                                       
                 INTO :PR-ADDRESS-ID                                    
                 FROM  CSS_PREMISE                                      
                WHERE  PREMISE_NO = :PR-PREMISE-NO                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                 MOVE PR-ADDRESS-ID         TO DY-ADDRESS-ID            
              ELSE                                                      
                 MOVE ZERO                  TO DY-ADDRESS-ID            
              END-IF                                                    
           ELSE                                                         
              MOVE '7150'                   TO ACTIVE-PARAGRAPH         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_PREMISE'            TO TABLE-1                  
              MOVE 'PREMISE_NO'             TO TABLE-ELEMENT-1          
              MOVE  PR-PREMISE-NO           TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7160-GET-METER-NO.                                            *         
      ******************************************************************        
       7160-GET-METER-NO.                                               
                                                                        
           EXEC SQL                                                     
               SELECT  METER_NO                                         
                 INTO :MA-METER-NO                                      
                 FROM  CSS_METER_ATTCHMTS                               
                WHERE  DEVICE_NO         = :EQ-DEVICE-NO                
                  AND  COMPANY_NO        = :MA-COMPANY-NO               
                  AND (CODE_DEVICE_TYPE  = :WS-T                        
                   OR  CODE_DEVICE_TYPE  = :WS-M)                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                                       OR NOT-FOUND                     
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE '7160'                   TO ACTIVE-PARAGRAPH         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_METER_ATTCHMTS'     TO TABLE-1                  
              MOVE 'DEVICE_NO'              TO TABLE-ELEMENT-1          
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-2          
              MOVE EQ-DEVICE-NO             TO HOSTVAR-ELEMENT-1        
              MOVE MA-COMPANY-NO            TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7160-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7170-SELECT-EQUIP.                                                      
      ******************************************************************        
       7170-SELECT-EQUIP.                                               
                                                                        
           EXEC SQL                                                     
               SELECT  CODE_UTIL_TYPE                                   
                      ,DEVICE_NO                                        
                      ,CODE_CRNT_LOC                                    
                      ,LOCAL_OFFICE                                     
                      ,CIS.CHAR2$DATE(DATE_LAST_MOVE,'USA')                     
                      ,CRNT_LOC_NO                                      
                      ,COMPANY_NO                                       
                      ,CAST(SYSDATETIMEOFFSET() AS DATE)                        
                 INTO :EQ-CODE-UTIL-TYPE,                               
                      :EQ-DEVICE-NO,                                    
                      :EQ-CODE-CRNT-LOC,                                
                      :EQ-LOCAL-OFFICE,                                 
                      :EQ-DATE-LAST-MOVE :WS-DATE-LAST-MOVE-NULL,       
                      :EQ-CRNT-LOC-NO,                                  
                      :EQ-COMPANY-NO,                                   
                      :WS-DB2-CURRENT-DATE                              
                 FROM  CSS_EQUIPMENT                                    
                WHERE  CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE              
                  AND  COMPANY_NO     = :EQ-COMPANY-NO                  
                  AND  EQUIP_TYPE_CD  = :EQ-EQUIP-TYPE-CD               
                  AND  DEVICE_NO      = :EQ-DEVICE-NO                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  CODE_UTIL_TYPE                                           
MFA-TR*               ,DEVICE_NO                                                
MFA-TR*               ,CODE_CRNT_LOC                                            
MFA-TR*               ,LOCAL_OFFICE                                             
MFA-TR*               ,CHAR(DATE_LAST_MOVE,USA)                                 
MFA-TR*               ,CRNT_LOC_NO                                              
MFA-TR*               ,COMPANY_NO                                               
MFA-TR*               ,CURRENT DATE                                             
MFA-TR*          INTO :EQ-CODE-UTIL-TYPE,                                       
MFA-TR*               :EQ-DEVICE-NO,                                            
MFA-TR*               :EQ-CODE-CRNT-LOC,                                        
MFA-TR*               :EQ-LOCAL-OFFICE,                                         
MFA-TR*               :EQ-DATE-LAST-MOVE :WS-DATE-LAST-MOVE-NULL,               
MFA-TR*               :EQ-CRNT-LOC-NO,                                          
MFA-TR*               :EQ-COMPANY-NO,                                           
MFA-TR*               :WS-DB2-CURRENT-DATE                                      
MFA-TR*          FROM  CSS_EQUIPMENT                                            
MFA-TR*         WHERE  CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE                      
MFA-TR*           AND  COMPANY_NO     = :EQ-COMPANY-NO                          
MFA-TR*           AND  EQUIP_TYPE_CD  = :EQ-EQUIP-TYPE-CD                       
MFA-TR*           AND  DEVICE_NO      = :EQ-DEVICE-NO                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF DATE-LAST-MOVE-NULL                                    
                 INITIALIZE EQ-DATE-LAST-MOVE                           
              END-IF                                                    
           ELSE                                                         
              MOVE '7170'                   TO ACTIVE-PARAGRAPH         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_EQUIPMENT'          TO TABLE-1                  
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-1          
              MOVE 'EQUIP_TYPE_CD'          TO TABLE-ELEMENT-2          
              MOVE 'DEVICE_NO'              TO TABLE-ELEMENT-3          
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-4          
              MOVE EQ-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-1        
              MOVE EQ-EQUIP-TYPE-CD         TO HOSTVAR-ELEMENT-2        
              MOVE EQ-DEVICE-NO             TO HOSTVAR-ELEMENT-3        
              MOVE EQ-COMPANY-NO            TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7170-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8000A-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000A-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04647_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04647_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000A'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04647_R1'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       8000A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      * 8000B-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000B-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04647_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04647_R2                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000B'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04647_R2'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       8000B-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 8010-INSERT-GTT-R1. METER MOVEMENT HISTORY DATA.               *        
      ******************************************************************        
       8010-INSERT-GTT-R1.                                              
                                                                        
           EXEC SQL                                                     
               INSERT INTO #CSR04647_R1                          
                 (                                                      
                   RETURN_CODE                                          
                  ,DATE_MOVE                                            
                  ,CODE_CRNT_LOC                                        
                  ,EQUIP_LOC_DESC                                       
                  ,LOCATION                                             
                 )                                                      
               VALUES                                                   
                 (                                                      
                   :S-RETURN-CODE-1                                     
                  ,:S-DATE-MOVE                                         
                  ,:S-CODE-CRNT-LOC                                     
                  ,:S-EQUIP-LOC-DESC                                    
                  ,:S-LOCATION                                          
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO SESSION.CSR04647_R1                                  
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,DATE_MOVE                                                    
MFA-TR*           ,CODE_CRNT_LOC                                                
MFA-TR*           ,EQUIP_LOC_DESC                                               
MFA-TR*           ,LOCATION                                                     
MFA-TR*          )                                                              
MFA-TR*        VALUES                                                           
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-1                                             
MFA-TR*           ,:S-DATE-MOVE                                                 
MFA-TR*           ,:S-CODE-CRNT-LOC                                             
MFA-TR*           ,:S-EQUIP-LOC-DESC                                            
MFA-TR*           ,:S-LOCATION                                                  
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                        TO CTR-ROWS-RS1             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8010'                   TO ACTIVE-PARAGRAPH         
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSR04647_R1'            TO TABLE-1                  
              MOVE SPACES                   TO TABLE-ELEMENT-1          
              MOVE SPACES                   TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8020-INSERT-GTT-R2.  BUSINESS RULES.                           *        
      ******************************************************************        
       8020-INSERT-GTT-R2.                                              
                                                                        
           EXEC SQL                                                     
               INSERT INTO #CSR04647_R2                          
                 (                                                      
                   RETURN_CODE                                          
                  ,BUS_RULE_ID                                          
                  ,ACTION_TYPE_CD                                       
                  ,BUS_RULE_XREF_ID                                     
                 )                                                      
               VALUES                                                   
                 (                                                      
                   :S-RETURN-CODE-2                                     
                  ,:S-BUS-RULE-ID                                       
                  ,:S-ACTION-TYPE-CD                                    
                  ,:S-BUS-RULE-XREF-ID                                  
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO SESSION.CSR04647_R2                                  
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,BUS_RULE_ID                                                  
MFA-TR*           ,ACTION_TYPE_CD                                               
MFA-TR*           ,BUS_RULE_XREF_ID                                             
MFA-TR*          )                                                              
MFA-TR*        VALUES                                                           
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-2                                             
MFA-TR*           ,:S-BUS-RULE-ID                                               
MFA-TR*           ,:S-ACTION-TYPE-CD                                            
MFA-TR*           ,:S-BUS-RULE-XREF-ID                                          
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                        TO CTR-ROWS-RS2             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8020'                   TO ACTIVE-PARAGRAPH         
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSR04647_R2'            TO TABLE-1                  
              MOVE SPACES                   TO TABLE-ELEMENT-1          
              MOVE SPACES                   TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8800-CHECK-RESULTS.                                           *         
      *****************************************************************         
       8800-CHECK-RESULTS.                                              
                                                                        
           IF CTR-ROWS-RS1 <= 0                                         
              INITIALIZE                       GTT-RETURN-FIELDS-1      
              MOVE   0                      TO S-RETURN-CODE-1          
              PERFORM 8010-INSERT-GTT-R1       THRU 8010-EXIT           
           END-IF.                                                      
                                                                        
           IF CTR-ROWS-RS2 <= 0                                         
              INITIALIZE                       GTT-RETURN-FIELDS-2      
              MOVE   0                      TO S-RETURN-CODE-2          
              PERFORM 8020-INSERT-GTT-R2       THRU 8020-EXIT           
           END-IF.                                                      
                                                                        
       8800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8900-SEND-DONE.                                               *         
      *****************************************************************         
       8900-SEND-DONE.                                                  
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           EXEC SQL                                                     
               OPEN C2                                                  
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
                                                    
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 9000-SEND-ERROR-RESULT.                                       *         
      *****************************************************************         
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE       TO ABEND-SQLCODE            
                                               S-RETURN-CODE-1          
                                               S-RETURN-CODE-2.         
                                                                        
           MOVE SQLERRMC                    TO ABEND-SQLERRMC.          
                                                                        
           IF WS-GTT01-DECLARED = 'N'                                   
              PERFORM 0100A-DECLARE-GTT-R1     THRU 0100A-EXIT          
           END-IF.                                                      
                                                                        
           IF WS-GTT02-DECLARED = 'N'                                   
              PERFORM 0100B-DECLARE-GTT-R2     THRU 0100B-EXIT          
           END-IF.                                                      
                                                                        
           PERFORM 8010-INSERT-GTT-R1          THRU 8010-EXIT.          
           PERFORM 8020-INSERT-GTT-R2          THRU 8020-EXIT.          
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 9700-PROCESS-ABEND.                                           *         
      *****************************************************************         
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT      THRU 9000-EXIT.          
           PERFORM 9900-SQL-ERROR-ROUTINE      THRU 9900-EXIT.          
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 9900-SQL-ERROR-ROUTINE.                                       *         
      *****************************************************************         
       9900-SQL-ERROR-ROUTINE.                                          

MSQ002     EXEC SQL
MSQ002         SELECT LTRIM(RTRIM(CASE                                          
                        WHEN :TABLE-ELEMENT-1 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-1)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-1))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-2 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-2)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-2))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-3 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-3)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-3))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-4 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-4)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-4))                    
                        ELSE                                            
                           ''                                           
                     END))
MSQ002              , :ABEND-FUNCTION
MSQ002              , 'PARAGRAPH-' + LTRIM(RTRIM(:ACTIVE-PARAGRAPH)) + 
           ',' + 'TABLES-' + LTRIM(RTRIM(:TABLE-2)) + ',' + 
           LTRIM(RTRIM(:TABLE-3)) + ',' + LTRIM(RTRIM(:TABLE-4)) + 
           ',' + 'ERRMSG-' + LTRIM(RTRIM(:ABEND-SQLERRMC))
MSQ002           INTO :MFA-CSRERLOG.ARG-5
MSQ002              , :MFA-CSRERLOG.ARG-6
MSQ002              , :MFA-CSRERLOG.ARG-7
MSQ002     END-EXEC
                                                                        
           EXEC SQL                                                     
               CALL CSRERLOG ( :ABEND-PROGRAM
                  , :ABEND-SQLCODE
                  , :ABEND-SQLSTATE
                  , :TABLE-1
                  , :MFA-CSRERLOG.ARG-5
                  , :MFA-CSRERLOG.ARG-6
                  , :MFA-CSRERLOG.ARG-7
                  )                                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ002
MFA-TR*    EXEC SQL                                                             
MFA-TR*        CALL CSRERLOG (                                                  
MFA-TR*             :ABEND-PROGRAM,                                             
MFA-TR*             :ABEND-SQLCODE,                                             
MFA-TR*             :ABEND-SQLSTATE,                                            
MFA-TR*             :TABLE-1,                                                   
MFA-TR*              VARCHAR(STRIP(                                             
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-1 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-1) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-1)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-2 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-2) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-2)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-3 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-3) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-3)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-4 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-4) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-4)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END                                                        
MFA-TR*              )),                                                        
MFA-TR*              VARCHAR(:ABEND-FUNCTION),                                  
MFA-TR*              VARCHAR(                                                   
MFA-TR*              'PARAGRAPH-' CONCAT STRIP(:ACTIVE-PARAGRAPH) CONCAT        
MFA-TR*              ',' CONCAT 'TABLES-' CONCAT STRIP(:TABLE-2) CONCAT         
MFA-TR*              ',' CONCAT STRIP(:TABLE-3) CONCAT                          
MFA-TR*              ',' CONCAT STRIP(:TABLE-4) CONCAT                          
MFA-TR*              ',' CONCAT 'ERRMSG-' CONCAT STRIP(:ABEND-SQLERRMC)         
MFA-TR*              )                                                          
MFA-TR*             )                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           PERFORM 8900-SEND-DONE              THRU 8900-EXIT.          
           
MSQ016        GOBACK.                                                    
                                                                        
       9900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 9999-END-PROGRAM.                                             *         
      *****************************************************************         
       9999-END-PROGRAM.                                                
                                                                        
           PERFORM 8800-CHECK-RESULTS          THRU 8800-EXIT.          
           PERFORM 8900-SEND-DONE              THRU 8900-EXIT.          
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
