       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04646.                                          
       AUTHOR.       SATISH SIVASUBRAMANIAN.                            
COB303 DATE-WRITTEN. JULY 19, 2013.                                     
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                        PROGRAM  SUMMARY                        *        
      *                                                                *        
      *       THIS PROGRAM RETRIEVES METER IRREGULARITY DETAILS.       *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  07/19/13  SS95855    P#0738 METERING & RATE MAINTENANCE       *        
      *  02/17/14  AW41078    MODIFY SO THAT ROW GETS RUTURNED IF      *        
      *                       IRREG 1, 2, OR COMMENTS > SPACES.        *        
      *                       PREVIOUSLY ONLY RETURNED ROW IF COMMENTS *        
      *                       WAS > SPACES.                            *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04646'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                     PIC X(40) VALUE                 
           'WORKING STORAGE FOR CSR04646 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ***  CSS_IRRGLR_MTR_RD                                                    
           EXEC SQL                                                             
               INCLUDE TBIRMTRD                                                 
           END-EXEC.                                                            
                                                                        
      ***  CSS_IRRGLR_METER                                                     
           EXEC SQL                                                             
             INCLUDE TBIRRMTR                                                   
           END-EXEC.                                                            
                                                                        
       01  WS-LITERALS.                                                 
           05  PROGRAM-NAME                 PIC X(08) VALUE 'CSR04646'. 
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-ACCOUNT-NO           PIC 9(13) VALUE ZERO.          
           05  PARM-CODE-UTIL-TYPE       PIC X(01) VALUE SPACES.        
           05  PARM-IC-NO                PIC S9(4) COMP VALUE 0.        
           05  PARM-METER-REF-NO         PIC S9(4) COMP VALUE 0.        
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS-RS1                 PIC S9(9) COMP VALUE 0.     
           05  CTR-ROWS-RS2                 PIC S9(9) COMP VALUE 0.     
                                                                        
       01  GTT-RETURN-FIELDS.                                           
      ******************************************************************        
      *   GTT TABLE LAYOUT METER IRREGULARITY DATA.                    *        
      ******************************************************************        
           05  GTT-RETURN-FIELDS-1.                                     
               10  S-RETURN-CODE-1          PIC S9(9) COMP VALUE 0.     
               10  S-COMMENTS               PIC X(32) VALUE SPACES.     
               10  S-IRRGLR-MTR-DESC-FIRST  PIC X(25) VALUE SPACES.     
               10  S-IRRGLR-MTR-DESC-SECOND PIC X(25) VALUE SPACES.     
               10  S-METER-READ-DT          PIC X(10) VALUE SPACES.     
      *                                                                         
      ******************************************************************        
      *   GTT TABLE LAYOUT FOR BUSINESS RULES.                         *        
      ******************************************************************        
           05  GTT-RETURN-FIELDS-2.                                     
               10  S-RETURN-CODE-2       PIC S9(9) COMP VALUE ZERO.     
               10  S-BUS-RULE-ID         PIC X(10) VALUE SPACES.        
               10  S-ACTION-TYPE-CD      PIC X(08) VALUE SPACES.        
               10  S-BUS-RULE-XREF-ID    PIC X(26) VALUE SPACES.        
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
           10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
                                                                        
       01  SWITCHES.                                                    
           05  SEND-DONE-SW              PIC X(01) VALUE 'Y'.           
               88 SEND-DONE-ERROR                  VALUE 'N'.           
               88 SEND-DONE-OK                     VALUE 'Y'.           
                                                                        
       01  WS-NULL-INDICATORS.                                          
           05  WS-IRRGLR-DESC1-IND1      PIC S9(04) COMP VALUE 0.       
           05  WS-IRRGLR-DESC2-IND2      PIC S9(04) COMP VALUE 0.       
                                                                        
       01  WS-MISC.                                                     
           05  WS-IRRGLR-MTR-CD-DESC1    PIC X(25) VALUE SPACES.        
           05  WS-IRRGLR-MTR-CD-DESC2    PIC X(25) VALUE SPACES.        
           05  WS-GTT-NAME               PIC X(19) VALUE SPACES.        
           05  WS-GTT01-DECLARED         PIC X(01) VALUE 'N'.           
           05  WS-GTT02-DECLARED         PIC X(01) VALUE 'N'.           
           05  WS-ACCOUNT-NO             PIC 9(13) VALUE ZERO.          
                                                                        
       01  WS-METER-READ-DT.                                            
           05  WS-READ-YYYY            PIC X(04).                       
           05  WS-READ-SLASH1          PIC X.                           
           05  WS-READ-MM              PIC X(02).                       
           05  WS-READ-SLASH2          PIC X.                           
           05  WS-READ-DD              PIC X(02).                       
                                                                        
       01  RS-METER-READ-DT.                                            
           10  RS-READ-MM              PIC X(02).                       
           10  FILLER                  PIC X VALUE '/'.                 
           10  RS-READ-DD              PIC X(02).                       
           10  FILLER                  PIC X VALUE '/'.                 
           10  RS-READ-YYYY            PIC X(04).                       
                                                                        
      **** ERROR HANDLING (ABEND VARIABLES)                                     
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
      *                                                                         
      **** DB2 AND SQL ERROR CHECKING                                           
           COPY CWS00303.                                                       
      *                                                                         
      **** ABEND ROUTINE (USED WITH CPD09900 INCLUDE MEMBER)                    
           COPY CWS09900.                                                       
      *                                                                         
                                                                        
      *** CURSOR DECLARATION FOR METER IRREGULARITY READ                        
      *                                                                         
           EXEC SQL                                                     
               DECLARE MTR_CRSR CURSOR FOR                              
                 SELECT B.IRRGLR_MTR_CD_DESC                            
                       ,C.IRRGLR_MTR_CD_DESC                            
                       ,A.METER_READ_DT                                 
                       ,A.MTR_RD_COMMENTS                               
                 FROM CSS_IRRGLR_MTR_RD A WITH(READUNCOMMITTED)                 
                 LEFT OUTER JOIN CSS_IRRGLR_METER B
                           WITH(READUNCOMMITTED)                     
                            ON A.IRRGLR_MTR_CD_1 = B.IRRGLR_MTR_CD      
                 LEFT OUTER JOIN CSS_IRRGLR_METER C
                           WITH(READUNCOMMITTED)                     
                            ON A.IRRGLR_MTR_CD_2 = C.IRRGLR_MTR_CD      
                 WHERE A.ACCOUNT_NO     = :IM-ACCOUNT-NO                
                   AND A.CODE_UTIL_TYPE = :IM-CODE-UTIL-TYPE            
                   AND A.IC_NO          = :IM-IC-NO                     
                   AND A.METER_REF_NO   = :IM-METER-REF-NO              
                 ORDER BY A.METER_READ_DT DESC                          
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE MTR_CRSR CURSOR FOR                              01022000
MFA-TR*          SELECT B.IRRGLR_MTR_CD_DESC                                    
MFA-TR*                ,C.IRRGLR_MTR_CD_DESC                                    
MFA-TR*                ,A.METER_READ_DT                                         
MFA-TR*                ,A.MTR_RD_COMMENTS                                       
MFA-TR*          FROM CSS_IRRGLR_MTR_RD A                                       
MFA-TR*          LEFT OUTER JOIN CSS_IRRGLR_METER B                             
MFA-TR*                     ON A.IRRGLR_MTR_CD_1 = B.IRRGLR_MTR_CD              
MFA-TR*          LEFT OUTER JOIN CSS_IRRGLR_METER C                             
MFA-TR*                     ON A.IRRGLR_MTR_CD_2 = C.IRRGLR_MTR_CD              
MFA-TR*          WHERE A.ACCOUNT_NO     = :IM-ACCOUNT-NO                        
MFA-TR*            AND A.CODE_UTIL_TYPE = :IM-CODE-UTIL-TYPE                    
MFA-TR*            AND A.IC_NO          = :IM-IC-NO                             
MFA-TR*            AND A.METER_REF_NO   = :IM-METER-REF-NO                      
MFA-TR*          ORDER BY A.METER_READ_DT DESC                                  
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*        QUERYNO 7000                                                     
MFA-TR*    END-EXEC.                                                            
      *                                                                         
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-ACCOUNT-NO                  PIC X(13).                  
       01  LINK-CODE-UTIL-TYPE              PIC X(01).                  
       01  LINK-IC-NO                       PIC S9(4) COMP.             
       01  LINK-METER-REF-NO                PIC S9(4) COMP.             
                                                                        
       PROCEDURE DIVISION USING  LINK-ACCOUNT-NO                        
                                 LINK-CODE-UTIL-TYPE                    
                                 LINK-IC-NO                             
                                 LINK-METER-REF-NO.                     
                                                                        
      ******************************************************************        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE             THRU 0100-EXIT.          
           PERFORM 1000-PROCESS-INPUT          THRU 1000-EXIT.          
           PERFORM 2000-BUILD-RESULT           THRU 2000-EXIT.          
           PERFORM 9999-END-PROGRAM            THRU 9999-EXIT.          
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  INITIALIZE REQUIRED VARIABLES                                 *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE 'N'                         TO WS-GTT01-DECLARED        
                                               WS-GTT02-DECLARED.       
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1        THRU 0100A-EXIT.         
           PERFORM 0100B-DECLARE-GTT-R2        THRU 0100B-EXIT.         
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  DECLARE GLOBAL TEMPORARY TABLE  - METER IRREGULARITY READ     *        
      ******************************************************************        
       0100A-DECLARE-GTT-R1.                                            
                                                                        
           MOVE 'SESSION.CSR04646_R1'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04646_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04646_R1
              (                                                    
                     RETURN_CODE              INT                   
                    ,METER_READ_DT CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,COMMENTS CHAR(32)  COLLATE LATIN1_GENERAL_100_BIN2         
                    ,IRRGLR_MTR_DESC1 CHAR(25)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,IRRGLR_MTR_DESC2 CHAR(25)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                   )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF SQLSTATE = '42710'                                        
              PERFORM 8000A-DELETE-GTT-ROWS    THRU 8000A-EXIT          
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  MOVE 'Y'                  TO WS-GTT01-DECLARED        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'              TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE WS-GTT-NAME          TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT           
               END-IF                                                   
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                       WITH ROWSET POSITIONING FOR                      
               SELECT  RETURN_CODE                                      
                      ,METER_READ_DT                                    
                      ,LTRIM(RTRIM(COMMENTS))          AS 
           MTR_RD_COMMENTS      
                      ,LTRIM(RTRIM(IRRGLR_MTR_DESC1))  AS IRRGLR_MTR_1         
                      ,LTRIM(RTRIM(IRRGLR_MTR_DESC2))  AS IRRGLR_MTR_2         
               FROM #CSR04646_R1                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                WITH ROWSET POSITIONING FOR                              
MFA-TR*        SELECT  RETURN_CODE                                              
MFA-TR*               ,METER_READ_DT                                            
MFA-TR*               ,STRIP(COMMENTS)          AS MTR_RD_COMMENTS              
MFA-TR*               ,STRIP(IRRGLR_MTR_DESC1)  AS IRRGLR_MTR_1                 
MFA-TR*               ,STRIP(IRRGLR_MTR_DESC2)  AS IRRGLR_MTR_2                 
MFA-TR*        FROM SESSION.CSR04646_R1                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100B-DECLARE-GTT-R2 - BUSINESS RULES                          *        
      ******************************************************************        
       0100B-DECLARE-GTT-R2.                                            
                                                                        
           MOVE 'SESSION.CSR04646_R2'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04646_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04646_R2
              (                                                      
                    RETURN_CODE             INT                     
                   ,BUS_RULE_ID CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,ACTION_TYPE_CD CHAR(08)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BUS_RULE_XREF_ID CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                 )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF SQLSTATE = '42710'                                        
              PERFORM 8000B-DELETE-GTT-ROWS    THRU 8000B-EXIT          
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                 MOVE 'Y'                   TO WS-GTT02-DECLARED        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100B'              TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE WS-GTT-NAME          TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT           
               END-IF                                                   
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C2 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE           AS RETURN_CODE             
                      ,BUS_RULE_ID           AS BUS_RULE_ID             
                      ,ACTION_TYPE_CD        AS ACTION_TYPE_CD          
                      ,BUS_RULE_XREF_ID      AS BUS_RULE_XREF_ID        
                  FROM #CSR04646_R2                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C2 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE           AS RETURN_CODE                     
MFA-TR*               ,BUS_RULE_ID           AS BUS_RULE_ID                     
MFA-TR*               ,ACTION_TYPE_CD        AS ACTION_TYPE_CD                  
MFA-TR*               ,BUS_RULE_XREF_ID      AS BUS_RULE_XREF_ID                
MFA-TR*           FROM SESSION.CSR04646_R2                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100B-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * RECEIVE INPUT PARMS                                            *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE '1000'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           MOVE LINK-ACCOUNT-NO             TO WS-ACCOUNT-NO.           
           MOVE LINK-CODE-UTIL-TYPE         TO PARM-CODE-UTIL-TYPE.     
           MOVE LINK-IC-NO                  TO PARM-IC-NO.              
           MOVE LINK-METER-REF-NO           TO PARM-METER-REF-NO.       
                                                                        
           MOVE WS-ACCOUNT-NO               TO IM-ACCOUNT-NO.           
           MOVE PARM-CODE-UTIL-TYPE         TO IM-CODE-UTIL-TYPE.       
           MOVE PARM-IC-NO                  TO IM-IC-NO.                
           MOVE PARM-METER-REF-NO           TO IM-METER-REF-NO.         
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-BUILD-RESULT                                              *        
      ******************************************************************        
       2000-BUILD-RESULT.                                               
                                                                        
           MOVE '2000'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           PERFORM 7000-OPEN-MTR-CRSR          THRU 7000-EXIT.          
                                                                        
           PERFORM 7010-FETCH-MTR-CRSR         THRU 7010-EXIT.          
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              MOVE WS-ACTIVE-RETURN-CODE    TO S-RETURN-CODE-1          
              PERFORM 8010-INSERT-GTT-R1       THRU 8010-EXIT           
           ELSE                                                         
              PERFORM 2210-PROCESS-MTR-CRSR    THRU 2210-EXIT           
                UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                 
           END-IF.                                                      
                                                                        
           PERFORM 7020-CLOSE-MTR-CRSR         THRU 7020-EXIT.          
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * PROCESS METER READ DETAILS                                     *        
      ******************************************************************        
       2210-PROCESS-MTR-CRSR.                                           
                                                                        
           MOVE '2210'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
                                                                        
           MOVE IM-METER-READ-DT            TO WS-METER-READ-DT.        
           MOVE WS-READ-YYYY                TO RS-READ-YYYY.            
           MOVE WS-READ-MM                  TO RS-READ-MM.              
           MOVE WS-READ-DD                  TO RS-READ-DD.              
           MOVE RS-METER-READ-DT            TO S-METER-READ-DT.         
                                                                        
           MOVE WS-IRRGLR-MTR-CD-DESC1      TO S-IRRGLR-MTR-DESC-FIRST. 
           MOVE WS-IRRGLR-MTR-CD-DESC2      TO S-IRRGLR-MTR-DESC-SECOND.
                                                                        
           IF IM-MTR-RD-COMMENTS > SPACES OR                            
              WS-IRRGLR-MTR-CD-DESC1 > SPACES OR                        
              WS-IRRGLR-MTR-CD-DESC2 > SPACES                           
              MOVE IM-MTR-RD-COMMENTS       TO S-COMMENTS               
              PERFORM 8010-INSERT-GTT-R1       THRU 8010-EXIT           
           END-IF.                                                      
                                                                        
           MOVE SPACES                      TO WS-IRRGLR-MTR-CD-DESC1   
                                               WS-IRRGLR-MTR-CD-DESC2.  
                                                                        
           PERFORM 7010-FETCH-MTR-CRSR         THRU 7010-EXIT.          
                                                                        
       2210-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *  OPENS THE CURSOR DECLARED FOR GETTING METER READ DETAILS      *        
      ******************************************************************        
       7000-OPEN-MTR-CRSR.                                              
                                                                        
           EXEC SQL                                                     
               OPEN MTR_CRSR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE   TO S-RETURN-CODE-1          
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7000'                  TO ACTIVE-PARAGRAPH         
               MOVE 'OPEN'                  TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_IRRGLR_MTR_RD'     TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2          
               MOVE 'IC_NO'                 TO TABLE-ELEMENT-3          
               MOVE 'MTR_REF_NO'            TO TABLE-ELEMENT-4          
               MOVE IM-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               MOVE IM-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2        
               MOVE IM-IC-NO                TO HOSTVAR-ELEMENT-3        
               MOVE IM-METER-REF-NO         TO HOSTVAR-ELEMENT-4        
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *  FETCHES THE CURSOR DECLARED FOR GETTING THE METER READ DETAILS*        
      ******************************************************************        
       7010-FETCH-MTR-CRSR.                                             
                                                                        
           EXEC SQL                                                     
               FETCH MTR_CRSR                                           
               INTO   :WS-IRRGLR-MTR-CD-DESC1 :WS-IRRGLR-DESC1-IND1     
                     ,:WS-IRRGLR-MTR-CD-DESC2 :WS-IRRGLR-DESC2-IND2     
                     ,:IM-METER-READ-DT                                 
                     ,:IM-MTR-RD-COMMENTS                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               IF WS-IRRGLR-DESC1-IND1 EQUAL -1                         
                  MOVE SPACES               TO WS-IRRGLR-MTR-CD-DESC1   
               END-IF                                                   
               IF WS-IRRGLR-DESC2-IND2 EQUAL -1                         
                  MOVE SPACES               TO WS-IRRGLR-MTR-CD-DESC2   
               END-IF                                                   
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE   TO S-RETURN-CODE-1          
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7010'                  TO ACTIVE-PARAGRAPH         
               MOVE 'FETCH'                 TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_IRRGLR_MTR_RD'     TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2          
               MOVE 'IC_NO'                 TO TABLE-ELEMENT-3          
               MOVE 'MTR_REF_NO'            TO TABLE-ELEMENT-4          
               MOVE IM-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               MOVE IM-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2        
               MOVE IM-IC-NO                TO HOSTVAR-ELEMENT-3        
               MOVE IM-METER-REF-NO         TO HOSTVAR-ELEMENT-4        
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  CLOSES THE CURSOR DECLARED FOR GETTING THE METER READ DETAILS *        
      ******************************************************************        
       7020-CLOSE-MTR-CRSR.                                             
                                                                        
           EXEC SQL                                                     
               CLOSE MTR_CRSR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE   TO S-RETURN-CODE-1          
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7020'                  TO ACTIVE-PARAGRAPH         
               MOVE 'CLOSE'                 TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_IRRGLR_MTR_RD'     TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2          
               MOVE 'IC_NO'                 TO TABLE-ELEMENT-3          
               MOVE 'MTR_REF_NO'            TO TABLE-ELEMENT-4          
               MOVE IM-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               MOVE IM-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2        
               MOVE IM-IC-NO                TO HOSTVAR-ELEMENT-3        
               MOVE IM-METER-REF-NO         TO HOSTVAR-ELEMENT-4        
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  DELETE SESSION TABLE - INITIAL                                *        
      ******************************************************************        
       8000A-DELETE-GTT-ROWS.                                           
                                                                        
            EXEC SQL                                                    
                DELETE                                                  
                  FROM #CSR04646_R1                              
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE                                                          
MFA-TR*           FROM SESSION.CSR04646_R1                                      
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.   
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE SQLCODE                 TO ABEND-SQLCODE            
               MOVE SQLSTATE                TO ABEND-SQLSTATE           
               MOVE '8000A'                 TO ACTIVE-PARAGRAPH         
               MOVE 'DELETE'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
               MOVE 'CSR04646_R1'           TO TABLE-1                  
               MOVE SPACES                  TO TABLE-ELEMENT-1          
               MOVE SPACES                  TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  DELETE SESSION TABLE - BUSINESS RULES                         *        
      ******************************************************************        
       8000B-DELETE-GTT-ROWS.                                           
                                                                        
            EXEC SQL                                                    
                DELETE                                                  
                  FROM #CSR04646_R2                              
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE                                                          
MFA-TR*           FROM SESSION.CSR04646_R2                                      
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.   
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE SQLCODE                 TO ABEND-SQLCODE            
               MOVE SQLSTATE                TO ABEND-SQLSTATE           
               MOVE '8000B'                 TO ACTIVE-PARAGRAPH         
               MOVE 'CSR04646_R2'           TO TABLE-1                  
               MOVE 'DELETE'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8000B-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8010-INSERT-GTT-R1.  METER READ HISTORY DATA                   *        
      ******************************************************************        
       8010-INSERT-GTT-R1.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04646_R1                            
             (                                                          
              RETURN_CODE                                               
             ,COMMENTS                                                  
             ,IRRGLR_MTR_DESC1                                          
             ,IRRGLR_MTR_DESC2                                          
             ,METER_READ_DT                                             
             )                                                          
             VALUES                                                     
             (                                                          
              :S-RETURN-CODE-1                                          
             ,:S-COMMENTS                                               
             ,:S-IRRGLR-MTR-DESC-FIRST                                  
             ,:S-IRRGLR-MTR-DESC-SECOND                                 
             ,:S-METER-READ-DT                                          
             )                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04646_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,COMMENTS                                                          
MFA-TR*      ,IRRGLR_MTR_DESC1                                                  
MFA-TR*      ,IRRGLR_MTR_DESC2                                                  
MFA-TR*      ,METER_READ_DT                                                     
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S-RETURN-CODE-1                                                  
MFA-TR*      ,:S-COMMENTS                                                       
MFA-TR*      ,:S-IRRGLR-MTR-DESC-FIRST                                          
MFA-TR*      ,:S-IRRGLR-MTR-DESC-SECOND                                         
MFA-TR*      ,:S-METER-READ-DT                                                  
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                        TO CTR-ROWS-RS1             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
              MOVE '8010'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE 'CSR04646_R1'            TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8010-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 8020-INSERT-GTT-R2.  BUSINESS RULES.                           *        
      ******************************************************************        
       8020-INSERT-GTT-R2.                                              
                                                                        
           EXEC SQL                                                     
               INSERT INTO #CSR04646_R2                          
                 (                                                      
                   RETURN_CODE                                          
                  ,BUS_RULE_ID                                          
                  ,ACTION_TYPE_CD                                       
                  ,BUS_RULE_XREF_ID                                     
                 )                                                      
               VALUES                                                   
                 (                                                      
                   :S-RETURN-CODE-2                                     
                  ,:S-BUS-RULE-ID                                       
                  ,:S-ACTION-TYPE-CD                                    
                  ,:S-BUS-RULE-XREF-ID                                  
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO SESSION.CSR04646_R2                                  
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,BUS_RULE_ID                                                  
MFA-TR*           ,ACTION_TYPE_CD                                               
MFA-TR*           ,BUS_RULE_XREF_ID                                             
MFA-TR*          )                                                              
MFA-TR*        VALUES                                                           
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-2                                             
MFA-TR*           ,:S-BUS-RULE-ID                                               
MFA-TR*           ,:S-ACTION-TYPE-CD                                            
MFA-TR*           ,:S-BUS-RULE-XREF-ID                                          
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                        TO CTR-ROWS-RS2             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE '8020'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE 'CSR04646_R2'            TO TABLE-1                  
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
       8020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8800-CHECK-RESULTS.                                           *         
      *****************************************************************         
       8800-CHECK-RESULTS.                                              
                                                                        
           IF CTR-ROWS-RS1 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-1                            
              MOVE +100                     TO S-RETURN-CODE-1          
              PERFORM 8010-INSERT-GTT-R1       THRU 8010-EXIT           
           END-IF.                                                      
                                                                        
           IF CTR-ROWS-RS2 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-2                            
              MOVE 0                        TO S-RETURN-CODE-2          
              PERFORM 8020-INSERT-GTT-R2       THRU 8020-EXIT           
           END-IF.                                                      
                                                                        
       8800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8900-SEND-DONE.                                               *         
      *****************************************************************         
       8900-SEND-DONE.                                                  
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           EXEC SQL                                                     
               OPEN C2                                                  
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
                                                    
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 9000-SEND-ERROR-RESULT.                                       *         
      *****************************************************************         
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE       TO ABEND-SQLCODE            
                                               S-RETURN-CODE-1          
                                               S-RETURN-CODE-2.         
                                                                        
           MOVE SQLERRMC                    TO ABEND-SQLERRMC.          
                                                                        
           IF WS-GTT01-DECLARED = 'N'                                   
              PERFORM 0100A-DECLARE-GTT-R1     THRU 0100A-EXIT          
           END-IF.                                                      
                                                                        
           IF WS-GTT02-DECLARED = 'N'                                   
              PERFORM 0100B-DECLARE-GTT-R2     THRU 0100B-EXIT          
           END-IF.                                                      
                                                                        
           PERFORM 8010-INSERT-GTT-R1          THRU 8010-EXIT.          
           PERFORM 8020-INSERT-GTT-R2          THRU 8020-EXIT.          
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 9700-PROCESS-ABEND.                                           *         
      *****************************************************************         
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT      THRU 9000-EXIT.          
           PERFORM 9900-SQL-ERROR-ROUTINE      THRU 9900-EXIT.          
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 9900-SQL-ERROR-ROUTINE.                                       *         
      *****************************************************************         
       9900-SQL-ERROR-ROUTINE.                                          

MSQ002     EXEC SQL
MSQ002         SELECT LTRIM(RTRIM(CASE                                          
                        WHEN :TABLE-ELEMENT-1 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-1)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-1))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-2 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-2)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-2))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-3 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-3)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-3))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-4 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-4)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-4))                    
                        ELSE                                            
                           ''                                           
                     END))
MSQ002              , :ABEND-FUNCTION
MSQ002              , 'PARAGRAPH-' + LTRIM(RTRIM(:ACTIVE-PARAGRAPH)) + 
           ',' + 'TABLES-' + LTRIM(RTRIM(:TABLE-2)) + ',' + 
           LTRIM(RTRIM(:TABLE-3)) + ',' + LTRIM(RTRIM(:TABLE-4)) + 
           ',' + 'ERRMSG-' + LTRIM(RTRIM(:ABEND-SQLERRMC))
MSQ002           INTO :MFA-CSRERLOG.ARG-5
MSQ002              , :MFA-CSRERLOG.ARG-6
MSQ002              , :MFA-CSRERLOG.ARG-7
MSQ002     END-EXEC
                                                                        
           EXEC SQL                                                     
               CALL CSRERLOG ( :ABEND-PROGRAM
                  , :ABEND-SQLCODE
                  , :ABEND-SQLSTATE
                  , :TABLE-1
                  , :MFA-CSRERLOG.ARG-5
                  , :MFA-CSRERLOG.ARG-6
                  , :MFA-CSRERLOG.ARG-7
                  )                                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ002
MFA-TR*    EXEC SQL                                                             
MFA-TR*        CALL CSRERLOG (                                                  
MFA-TR*             :ABEND-PROGRAM,                                             
MFA-TR*             :ABEND-SQLCODE,                                             
MFA-TR*             :ABEND-SQLSTATE,                                            
MFA-TR*             :TABLE-1,                                                   
MFA-TR*              VARCHAR(STRIP(                                             
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-1 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-1) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-1)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-2 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-2) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-2)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-3 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-3) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-3)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-4 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-4) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-4)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END                                                        
MFA-TR*              )),                                                        
MFA-TR*              VARCHAR(:ABEND-FUNCTION),                                  
MFA-TR*              VARCHAR(                                                   
MFA-TR*              'PARAGRAPH-' CONCAT STRIP(:ACTIVE-PARAGRAPH) CONCAT        
MFA-TR*              ',' CONCAT 'TABLES-' CONCAT STRIP(:TABLE-2) CONCAT         
MFA-TR*              ',' CONCAT STRIP(:TABLE-3) CONCAT                          
MFA-TR*              ',' CONCAT STRIP(:TABLE-4) CONCAT                          
MFA-TR*              ',' CONCAT 'ERRMSG-' CONCAT STRIP(:ABEND-SQLERRMC)         
MFA-TR*              )                                                          
MFA-TR*             )                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           PERFORM 8900-SEND-DONE              THRU 8900-EXIT.          
           
MSQ016        GOBACK.                                                    
                                                                        
       9900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 9999-END-PROGRAM.                                             *         
      *****************************************************************         
       9999-END-PROGRAM.                                                
                                                                        
           PERFORM 8800-CHECK-RESULTS          THRU 8800-EXIT.          
           PERFORM 8900-SEND-DONE              THRU 8900-EXIT.          
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
