       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04645.                                          
       AUTHOR.       SATISH SIVASUBRAMANIAN.                            
COB303 DATE-WRITTEN. JULY 19, 2013.                                     
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                        PROGRAM  SUMMARY                        *        
      *                                                                *        
      *       THIS PROGRAM RETRIEVES METER READ HISTORY DETAILS.       *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  07/19/13  SS95855    P#0738 METERING & RATE MAINTENANCE       *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04645'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                     PIC X(40) VALUE                 
           'WORKING STORAGE FOR CSR04645 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ***  CSS_ROUTE_REPORT.                                                    
           EXEC SQL                                                             
               INCLUDE TBRTERPT                                                 
           END-EXEC.                                                            
                                                                        
      ***  CSS_UTIL_ENVRNMT.                                                    
           EXEC SQL                                                             
             INCLUDE TBUTLENV                                                   
           END-EXEC.                                                            
                                                                        
      ***  CSS_MTRD_ENVRNMT.                                                    
           EXEC SQL                                                             
             INCLUDE TBMTRENV                                                   
           END-EXEC.                                                            
                                                                        
      ***  CSS_LOCAL_OFFICE.                                                    
           EXEC SQL                                                             
             INCLUDE TBLOCOFC                                                   
           END-EXEC.                                                            
                                                                        
      ***  CSS_NO_READ_REASON.                                                  
           EXEC SQL                                                             
             INCLUDE TBNORDRN                                                   
           END-EXEC.                                                            
                                                                        
      ***  CSS_MTR_CAP.                                                         
           EXEC SQL                                                             
             INCLUDE TBMTRCAP                                                   
           END-EXEC.                                                            
      *                                                                         
      ***  CSS_MTR_RD_SOURCE                                                    
           EXEC SQL                                                             
             INCLUDE TBRDSRCE                                                   
           END-EXEC.                                                            
      *                                                                         
      ***  CSS_CODE_VALUE                                                       
           EXEC SQL                                                             
             INCLUDE TBCDVALU                                                   
           END-EXEC.                                                            
      *                                                                         
                                                                        
       01  WS-LITERALS.                                                 
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR04645'.      
           05  MRM0000073              PIC X(10) VALUE 'MRM0000073'.    
           05  WS-FAILED               PIC X(10) VALUE 'F'.             
           05  WS-CODE-TIME-PERIOD     PIC X(18) VALUE                  
                                        'CODE_TIME_PERIOD  '.           
           05  WS-CODE-TOU-SEASON      PIC X(18) VALUE                  
                                         'CODE_TOU_SEASN    '.          
           05  WS-READING-CODE         PIC X(18) VALUE                  
                                         'READING_CODE      '.          
           05  WS-CODE-USAGE-ID        PIC X(18) VALUE                  
                                         'CODE_USAGE_ID     '.          
           05  WS-MICRO-SECOND         PIC X(06) VALUE '000000'.        
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-PREMISE-NO           PIC X(10) VALUE SPACES.        
           05  PARM-PREMISE-NO-RED  REDEFINES                           
               PARM-PREMISE-NO           PIC 9(10).                     
           05  PARM-IC-NO                PIC S9(4) COMP VALUE 0.        
           05  PARM-CODE-UTIL-TYPE       PIC X(01) VALUE SPACES.        
           05  PARM-MTR-REF-NO           PIC S9(4) COMP VALUE 0.        
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS-RS1              PIC S9(9) COMP VALUE 0.        
           05  CTR-ROWS-RS2              PIC S9(9) COMP VALUE 0.        
                                                                        
       01  GTT-RETURN-FIELDS.                                           
      ******************************************************************        
      *   GTT TABLE LAYOUT METER READ HISTORY DATA.                    *        
      ******************************************************************        
           05  GTT-RETURN-FIELDS-1.                                     
               10  S-RETURN-CODE-1       PIC S9(9) COMP VALUE +0.       
               10  S-LAST-REG-READ-DT-TM PIC X(26) VALUE SPACES.        
               10  S-METER-NO            PIC X(09) VALUE SPACES.        
               10  S-METER-READING       PIC S9(09)V999 COMP-3 VALUE 0. 
               10  S-READING-CODE        PIC X(24) VALUE SPACES.        
               10  S-MTR-READ-SOURCE-CD  PIC X(01) VALUE SPACES.        
               10  S-REG-MEASURE-CD      PIC X(03) VALUE SPACES.        
               10  S-READ-CYCLE          PIC X(02) VALUE SPACES.        
               10  S-READ-ROUTE          PIC S9(4) COMP VALUE 0.        
               10  S-CONDITION-CODE      PIC X(34) VALUE SPACES.        
               10  S-ACCOUNT-NO          PIC X(13) VALUE SPACES.        
               10  S-LOCAL-OFFICE-DESC   PIC X(22) VALUE SPACES.        
               10  S-METER-READER-ID     PIC X(05) VALUE SPACES.        
               10  S-CODE-TIME-PERIOD    PIC S9(4) COMP VALUE 0.        
               10  S-CODE-TOU-SEASN      PIC X(01) VALUE SPACES.        
               10  S-CODE-USAGE-ID       PIC X(01) VALUE SPACES.        
               10  S-RATIO               PIC S9(9)V999 COMP-3 VALUE 0.  
               10  S-TIME-PERIOD-DESC    PIC X(15) VALUE SPACES.        
               10  S-SEASON-DESC         PIC X(15) VALUE SPACES.        
               10  S-USAGE-ID-DESC       PIC X(15) VALUE SPACES.        
               10  S-READ-SOURCE-DESC    PIC X(25) VALUE SPACES.        
      *                                                                         
      ******************************************************************        
      *   GTT TABLE LAYOUT FOR BUSINESS RULES.                         *        
      ******************************************************************        
           05  GTT-RETURN-FIELDS-2.                                     
               10  S-RETURN-CODE-2       PIC S9(9) COMP VALUE ZERO.     
               10  S-BUS-RULE-ID         PIC X(10) VALUE SPACES.        
               10  S-ACTION-TYPE-CD      PIC X(08) VALUE SPACES.        
               10  S-BUS-RULE-XREF-ID    PIC X(26) VALUE SPACES.        
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
           10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
                                                                        
       01  SWITCHES.                                                    
           05  SEND-DONE-SW              PIC X(01) VALUE 'Y'.           
               88 SEND-DONE-ERROR                  VALUE 'N'.           
               88 SEND-DONE-OK                     VALUE 'Y'.           
                                                                        
       01  WS-NULL-INDICATORS.                                          
           05  WS-METER-NULL-IND0        PIC S9(04) COMP VALUE 0.       
           05  WS-METER-NULL-IND1        PIC S9(04) COMP VALUE 0.       
           05  WS-METER-NULL-IND2        PIC S9(04) COMP VALUE 0.       
           05  WS-METER-NULL-IND3        PIC S9(04) COMP VALUE 0.       
                                                                        
       01  WS-MISC.                                                     
           05  WS-ACCOUNT-NO             PIC 9(13) VALUE ZEROS.         
           05  WS-ACCOUNT-NO-RED REDEFINES                              
               WS-ACCOUNT-NO             PIC X(13).                     
           05  WS-METER-READING          PIC S9(09)V999 COMP-3 VALUE 0. 
           05  WS-CURRENT-USAGE          PIC S9(11)V COMP-3 VALUE 0.    
           05  WS-HOLD-CORR-UNITS        PIC S9(09)V COMP-3 VALUE 0.    
           05  WS-RATIO                  PIC S9(09)V999 COMP-3 VALUE 0. 
           05  WS-GTT-NAME               PIC X(19) VALUE SPACES.        
           05  WS-GTT01-DECLARED         PIC X(01) VALUE 'N'.           
           05  WS-GTT02-DECLARED         PIC X(01) VALUE 'N'.           
           05  WS-HOLD-CODE-VALUE        PIC X(01) VALUE SPACES.        
           05  WS-HOLD-COLUMN-NAME       PIC X(18) VALUE SPACES.        
           05  WS-CDV-COUNT              PIC 9(05) VALUE ZERO.          
           05  WS-CD-VALUE-ROWS          PIC 9(05) VALUE ZERO.          
           05  WS-CDV-SUB                PIC 9(05) VALUE ZERO.          
           05  WS-HOLD-DESC              PIC X(15) VALUE SPACES.        
           05  WS-CODE-TIME-PERIOD-STR   PIC X(15) VALUE SPACES.        
           05  WS-CODE-TIME-PERIOD-NUM   PIC 9(04) VALUE 0.             
           05  WS-CODE-TIME-PERIOD-RED   REDEFINES                      
                       WS-CODE-TIME-PERIOD-NUM.                         
               10  WS-CD-TIME-PD-3       PIC 9(03).                     
               10  WS-CD-TIME-PD-1       PIC X(01).                     
           05  WS-CODE-VALUE-FLAG        PIC X(01) VALUE 'N'.           
               88  CODE-VALUE-FOUND                VALUE 'Y'.           
               88  CODE-VALUE-NOT-FOUND            VALUE 'N'.           
           05  WS-READ-DATE-TIME.                                       
               10  WS-READ-DATE          PIC X(10) VALUE SPACES.        
               10  FILLER                PIC X(01) VALUE '-'.           
               10  WS-READ-TIME          PIC X(08) VALUE SPACES.        
               10  FILLER                PIC X(01) VALUE '.'.           
               10  WS-READ-MS            PIC X(06) VALUE SPACES.        
                                                                        
       01  ALT-CODE-TIME-PERIOD          PIC S9(4) USAGE COMP.          
                                                                        
       01  WS-CODE-VALUE-TABLE.                                         
           05 WS-CD-VAL-RECORD OCCURS 200 TIMES.                        
              10 TAB-CODE-VALUE          PIC X(01).                     
              10 TAB-COLUMN-NA           PIC X(18).                     
              10 TAB-CODE-SHORT-DESC     PIC X(15).                     
      *                                                                         
      **** ERROR HANDLING (ABEND VARIABLES)                                     
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
      *                                                                         
      **** DB2 AND SQL ERROR CHECKING                                           
           COPY CWS00303.                                                       
      *                                                                         
      **** ABEND ROUTINE (USED WITH CPD09900 INCLUDE MEMBER)                    
           COPY CWS09900.                                                       
      *                                                                         
                                                                        
      *** METER READ HISTORY USING PREMISE NO                                   
      *                                                                         
           EXEC SQL                                                     
               DECLARE MTR_CRSR CURSOR FOR                              
               SELECT PW.LOCAL_OFFICE                                   
                     ,PW.READ_CYCLE                                     
                     ,METER_READER_ID                                   
                     ,PW.READ_ROUTE                                     
                     ,REG_MEASURE_CD                                    
                     ,PW.METER_NO                                       
                     ,METER_READING                                     
                     ,LAST_REG_READ_DT                                  
                     ,REPLACE(CONVERT(CHAR(8), LAST_REG_READ_TM, 108), 
           ':', '.') LAST_REG_READ_TM                                  
                     ,READING_CODE                                      
                     ,READING_COND_CD                                   
                     ,PW.ACCOUNT_NO                                     
                     ,REVENUE_MONTH                                     
                     ,PW.COMPANY_NO                                     
                     ,PW.CONSTANT                                       
                     ,PW.MTR_READ_SOURCE_CD                             
                     ,PW.PREV_METER_READING                             
                     ,PW.CODE_TIME_PERIOD                               
                     ,PW.CODE_TOU_SEASN                                 
                     ,PW.TYPE_OF_RD_IND                                 
                     ,PW.CODE_USAGE_ID                                  
                     ,CASE                                              
                         WHEN PW.CODE_TIME_PERIOD = 2                   
                         THEN PW.CODE_TIME_PERIOD + 2                   
                      ELSE                                              
                         PW.CODE_TIME_PERIOD                            
                      END                                               
                      AS ALT_CODE_TIME_PERIOD                           
               FROM CSS_ROUTE_REPORT PW WITH(READUNCOMMITTED),                  
                    CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                   
               WHERE PW.ACCOUNT_NO     =  UT.ACCOUNT_NO                 
                 AND PW.CODE_UTIL_TYPE =  UT.CODE_UTIL_TYPE             
                 AND PW.IC_NO          =  UT.IC_NO                      
                 AND UT.PREMISE_NO     = :UT-PREMISE-NO                 
                 AND PW.CODE_UTIL_TYPE = :PW-CODE-UTIL-TYPE             
                 AND PW.IC_NO          = :PW-IC-NO                      
                 AND PW.MTR_REF_NO     = :PW-MTR-REF-NO                 
               ORDER BY PW.REVENUE_MONTH      DESC                      
                       ,PW.LAST_REG_READ_DT   DESC                      
                       ,PW.LAST_REG_READ_TM   DESC                      
                       ,PW.CODE_USAGE_ID      ASC                       
                       ,PW.CODE_TOU_SEASN     ASC                       
                       ,ALT_CODE_TIME_PERIOD  ASC                       
                       ,PW.CODE_USAGE_TYPE    ASC                       
               FOR READ ONLY                                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE MTR_CRSR CURSOR FOR                                      
MFA-TR*        SELECT PW.LOCAL_OFFICE                                           
MFA-TR*              ,PW.READ_CYCLE                                             
MFA-TR*              ,METER_READER_ID                                           
MFA-TR*              ,PW.READ_ROUTE                                             
MFA-TR*              ,REG_MEASURE_CD                                            
MFA-TR*              ,PW.METER_NO                                               
MFA-TR*              ,METER_READING                                             
MFA-TR*              ,LAST_REG_READ_DT                                          
MFA-TR*              ,LAST_REG_READ_TM                                          
MFA-TR*              ,READING_CODE                                              
MFA-TR*              ,READING_COND_CD                                           
MFA-TR*              ,PW.ACCOUNT_NO                                             
MFA-TR*              ,REVENUE_MONTH                                             
MFA-TR*              ,PW.COMPANY_NO                                             
MFA-TR*              ,PW.CONSTANT                                               
MFA-TR*              ,PW.MTR_READ_SOURCE_CD                                     
MFA-TR*              ,PW.PREV_METER_READING                                     
MFA-TR*              ,PW.CODE_TIME_PERIOD                                       
MFA-TR*              ,PW.CODE_TOU_SEASN                                         
MFA-TR*              ,PW.TYPE_OF_RD_IND                                         
MFA-TR*              ,PW.CODE_USAGE_ID                                          
MFA-TR*              ,CASE                                                      
MFA-TR*                  WHEN PW.CODE_TIME_PERIOD = 2                           
MFA-TR*                  THEN PW.CODE_TIME_PERIOD + 2                           
MFA-TR*               ELSE                                                      
MFA-TR*                  PW.CODE_TIME_PERIOD                                    
MFA-TR*               END                                                       
MFA-TR*               AS ALT_CODE_TIME_PERIOD                                   
MFA-TR*        FROM CSS_ROUTE_REPORT PW,                                        
MFA-TR*             CSS_UTIL_ENVRNMT UT                                         
MFA-TR*        WHERE PW.ACCOUNT_NO     =  UT.ACCOUNT_NO                         
MFA-TR*          AND PW.CODE_UTIL_TYPE =  UT.CODE_UTIL_TYPE                     
MFA-TR*          AND PW.IC_NO          =  UT.IC_NO                              
MFA-TR*          AND UT.PREMISE_NO     = :UT-PREMISE-NO                         
MFA-TR*          AND PW.CODE_UTIL_TYPE = :PW-CODE-UTIL-TYPE                     
MFA-TR*          AND PW.IC_NO          = :PW-IC-NO                              
MFA-TR*          AND PW.MTR_REF_NO     = :PW-MTR-REF-NO                         
MFA-TR*        ORDER BY PW.REVENUE_MONTH      DESC                              
MFA-TR*                ,PW.LAST_REG_READ_DT   DESC                              
MFA-TR*                ,PW.LAST_REG_READ_TM   DESC                              
MFA-TR*                ,PW.CODE_USAGE_ID      ASC                               
MFA-TR*                ,PW.CODE_TOU_SEASN     ASC                               
MFA-TR*                ,ALT_CODE_TIME_PERIOD  ASC                               
MFA-TR*                ,PW.CODE_USAGE_TYPE    ASC                               
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*      QUERYNO 7000                                                       
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      *** GET TRANSLATION FOR CODE VALUES.                                      
      *                                                                         
           EXEC SQL                                                     
               DECLARE CDV_CRSR CURSOR FOR                              
               SELECT CODE_VALUE                                        
                     ,LTRIM(RTRIM(COLUMN_NA)) AS COLUMN_NA                     
                     ,LTRIM(RTRIM(CODE_SHORT_DESC)) AS CODE_SHORT_DESC         
               FROM CSS_CODE_VALUE                                      
               WHERE TABLE_NA = 'CSS_ROUTE_REPORT'                      
               ORDER BY COLUMN_NA                                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE CDV_CRSR CURSOR FOR                                      
MFA-TR*        SELECT CODE_VALUE                                                
MFA-TR*              ,STRIP(COLUMN_NA) AS COLUMN_NA                             
MFA-TR*              ,STRIP(CODE_SHORT_DESC) AS CODE_SHORT_DESC                 
MFA-TR*        FROM CSS_CODE_VALUE                                              
MFA-TR*        WHERE TABLE_NA = 'CSS_ROUTE_REPORT'                              
MFA-TR*        ORDER BY COLUMN_NA                                               
MFA-TR*      QUERYNO 7610                                                       
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       LINKAGE SECTION.                                                 
       01  LINK-PREMISE-NO                  PIC X(10).                  
       01  LINK-IC-NO                       PIC S9(4) COMP.             
       01  LINK-CODE-UTIL-TYPE              PIC X(01).                  
       01  LINK-MTR-REF-NO                  PIC S9(4) COMP.             
                                                                        
       PROCEDURE DIVISION USING  LINK-PREMISE-NO                        
                                 LINK-IC-NO                             
                                 LINK-CODE-UTIL-TYPE                    
                                 LINK-MTR-REF-NO.                       
                                                                        
      ******************************************************************        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE             THRU 0100-EXIT.          
           PERFORM 1000-PROCESS-INPUT          THRU 1000-EXIT.          
           PERFORM 2000-BUILD-RESULT           THRU 2000-EXIT.          
           PERFORM 9999-END-PROGRAM            THRU 9999-EXIT.          
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  INITIALIZE REQUIRED VARIABLES                                 *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE 'N'                         TO WS-GTT01-DECLARED        
                                               WS-GTT02-DECLARED.       
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1        THRU 0100A-EXIT.         
           PERFORM 0100B-DECLARE-GTT-R2        THRU 0100B-EXIT.         
           PERFORM 0100C-LOAD-CD-VALUES        THRU 0100C-EXIT.         
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  DECLARE GLOBAL TEMPORARY TABLE  - METER READ HISTORY          *        
      ******************************************************************        
       0100A-DECLARE-GTT-R1.                                            
                                                                        
           MOVE 'SESSION.CSR04645_R1'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04645_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04645_R1
              (                                                    
                     RETURN_CODE              INT                   
                    ,LAST_REG_READ_DT_TM CHAR(26)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,METER_READING            DECIMAL(12,3)             
                    ,METER_NO CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2         
                    ,READING_CODE CHAR(24)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,MTR_READ_SOURCE_CD CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,REG_MEASURE_CD CHAR(03)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,READ_CYCLE CHAR(02)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,READ_ROUTE               SMALLINT                  
                    ,CONDITION_CODE CHAR(34)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,ACCOUNT_NO CHAR(13)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,LOCAL_OFFICE_DESC CHAR(22)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,METER_READER_ID CHAR(05)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,CODE_TIME_PERIOD         SMALLINT                  
                    ,CODE_TOU_SEASN CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,CODE_USAGE_ID CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,RATIO                    DECIMAL(12,3)             
                    ,TIME_PERIOD_DESC CHAR(15)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,SEASON_DESC CHAR(15)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,USAGE_ID_DESC CHAR(15)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,READ_SOURCE_DESC CHAR(25)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                   )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF SQLSTATE = '42710'                                        
              PERFORM 8000A-DELETE-GTT-ROWS    THRU 8000A-EXIT          
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  MOVE 'Y'                  TO WS-GTT01-DECLARED        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'              TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE WS-GTT-NAME          TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT           
               END-IF                                                   
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                       WITH ROWSET POSITIONING FOR                      
               SELECT  RETURN_CODE                                      
                      ,LAST_REG_READ_DT_TM                              
                      ,METER_READING                                    
                      ,METER_NO                                         
                      ,READING_CODE                                     
                      ,MTR_READ_SOURCE_CD                               
                      ,REG_MEASURE_CD                                   
                      ,READ_CYCLE                                       
                      ,READ_ROUTE                                       
                      ,CONDITION_CODE                                   
                      ,ACCOUNT_NO                                       
                      ,LTRIM(RTRIM(LOCAL_OFFICE_DESC)) AS 
           LOCAL_OFFICE_DESC    
                      ,METER_READER_ID                                  
                      ,CODE_TIME_PERIOD                                 
                      ,CODE_TOU_SEASN                                   
                      ,CODE_USAGE_ID                                    
                      ,RATIO                                            
                      ,LTRIM(RTRIM(TIME_PERIOD_DESC)) AS 
           TIME_PERIOD_DESC      
                      ,LTRIM(RTRIM(SEASON_DESC))      AS SEASON_DESC           
                      ,LTRIM(RTRIM(USAGE_ID_DESC))    AS USAGE_ID_DESC         
                      ,LTRIM(RTRIM(READ_SOURCE_DESC)) AS 
           READ_SOURCE_DESC      
               FROM #CSR04645_R1                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                WITH ROWSET POSITIONING FOR                              
MFA-TR*        SELECT  RETURN_CODE                                              
MFA-TR*               ,LAST_REG_READ_DT_TM                                      
MFA-TR*               ,METER_READING                                            
MFA-TR*               ,METER_NO                                                 
MFA-TR*               ,READING_CODE                                             
MFA-TR*               ,MTR_READ_SOURCE_CD                                       
MFA-TR*               ,REG_MEASURE_CD                                           
MFA-TR*               ,READ_CYCLE                                               
MFA-TR*               ,READ_ROUTE                                               
MFA-TR*               ,CONDITION_CODE                                           
MFA-TR*               ,ACCOUNT_NO                                               
MFA-TR*               ,STRIP(LOCAL_OFFICE_DESC) AS LOCAL_OFFICE_DESC            
MFA-TR*               ,METER_READER_ID                                          
MFA-TR*               ,CODE_TIME_PERIOD                                         
MFA-TR*               ,CODE_TOU_SEASN                                           
MFA-TR*               ,CODE_USAGE_ID                                            
MFA-TR*               ,RATIO                                                    
MFA-TR*               ,STRIP(TIME_PERIOD_DESC) AS TIME_PERIOD_DESC              
MFA-TR*               ,STRIP(SEASON_DESC)      AS SEASON_DESC                   
MFA-TR*               ,STRIP(USAGE_ID_DESC)    AS USAGE_ID_DESC                 
MFA-TR*               ,STRIP(READ_SOURCE_DESC) AS READ_SOURCE_DESC              
MFA-TR*        FROM SESSION.CSR04645_R1                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100B-DECLARE-GTT-R2 - BUSINESS RULES                          *        
      ******************************************************************        
       0100B-DECLARE-GTT-R2.                                            
                                                                        
           MOVE 'SESSION.CSR04645_R2'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04645_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04645_R2
              (                                                      
                    RETURN_CODE             INT                     
                   ,BUS_RULE_ID CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,ACTION_TYPE_CD CHAR(08)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BUS_RULE_XREF_ID CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                 )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF SQLSTATE = '42710'                                        
              PERFORM 8000B-DELETE-GTT-ROWS    THRU 8000B-EXIT          
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                 MOVE 'Y'                   TO WS-GTT02-DECLARED        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100B'              TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE WS-GTT-NAME          TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT           
               END-IF                                                   
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C2 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE           AS RETURN_CODE             
                      ,BUS_RULE_ID           AS BUS_RULE_ID             
                      ,ACTION_TYPE_CD        AS ACTION_TYPE_CD          
                      ,BUS_RULE_XREF_ID      AS BUS_RULE_XREF_ID        
                  FROM #CSR04645_R2                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C2 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE           AS RETURN_CODE                     
MFA-TR*               ,BUS_RULE_ID           AS BUS_RULE_ID                     
MFA-TR*               ,ACTION_TYPE_CD        AS ACTION_TYPE_CD                  
MFA-TR*               ,BUS_RULE_XREF_ID      AS BUS_RULE_XREF_ID                
MFA-TR*           FROM SESSION.CSR04645_R2                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100B-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 0100C-LOAD-CD-VALUES.                                          *        
      ******************************************************************        
       0100C-LOAD-CD-VALUES.                                            
                                                                        
           MOVE '0100C'                     TO ACTIVE-PARAGRAPH.        
                                                                        
           INITIALIZE WS-CODE-VALUE-TABLE.                              
                                                                        
           PERFORM 7610-OPEN-CDV-CRSR            THRU 7610-EXIT.        
                                                                        
           PERFORM 7620-FETCH-CDV-CRSR           THRU 7620-EXIT.        
                                                                        
           IF WS-CD-VALUE-ROWS >= 100                                   
              MOVE WS-ACTIVE-RETURN-CODE   TO S-RETURN-CODE-1           
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE '0100C'                 TO ACTIVE-PARAGRAPH          
              MOVE 'LOAD '                 TO ABEND-FUNCTION            
              MOVE SPACES                  TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
              MOVE 'CSS_CODE_VALUE'        TO TABLE-1                   
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF                                                       
                                                                        
           PERFORM 0100D-BUILD-CDVAL-ARRAY       THRU 0100D-EXIT        
              UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.                  
                                                                        
           PERFORM 7630-CLOSE-CDV-CRSR           THRU 7630-EXIT.        
                                                                        
       0100C-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 0100D-BUILD-CDVAL-ARRAY.                                       *        
      ******************************************************************        
       0100D-BUILD-CDVAL-ARRAY.                                         
                                                                        
           MOVE '0100C'                     TO ACTIVE-PARAGRAPH.        
                                                                        
           ADD +1  TO WS-CDV-SUB.                                       
                                                                        
           MOVE UV-CODE-VALUE-TEXT(1:1)                                 
                              TO TAB-CODE-VALUE(WS-CDV-SUB).            
           INSPECT UV-COLUMN-NA-TEXT                                    
              REPLACING ALL LOW-VALUES BY SPACES.                       
           MOVE UV-COLUMN-NA-TEXT                                       
                              TO TAB-COLUMN-NA(WS-CDV-SUB).             
           MOVE UV-CODE-SHORT-DESC-TEXT                                 
                              TO TAB-CODE-SHORT-DESC(WS-CDV-SUB).       
                                                                        
           MOVE SPACES        TO DCLCSS-CODE-VALUE.                     
           PERFORM 7620-FETCH-CDV-CRSR           THRU 7620-EXIT.        
                                                                        
       0100D-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * RECEIVE INPUT PARMS                                            *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE '1000'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           MOVE LINK-PREMISE-NO             TO PARM-PREMISE-NO.         
           MOVE LINK-CODE-UTIL-TYPE         TO PARM-CODE-UTIL-TYPE.     
           MOVE LINK-IC-NO                  TO PARM-IC-NO.              
           MOVE LINK-MTR-REF-NO             TO PARM-MTR-REF-NO.         
                                                                        
           MOVE PARM-PREMISE-NO-RED         TO UT-PREMISE-NO.           
           MOVE PARM-CODE-UTIL-TYPE         TO PW-CODE-UTIL-TYPE.       
           MOVE PARM-IC-NO                  TO PW-IC-NO.                
           MOVE PARM-MTR-REF-NO             TO PW-MTR-REF-NO.           
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-BUILD-RESULT                                              *        
      ******************************************************************        
       2000-BUILD-RESULT.                                               
                                                                        
           MOVE '2000'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           PERFORM 7000-OPEN-MTR-CRSR          THRU 7000-EXIT.          
                                                                        
           PERFORM 7010-FETCH-MTR-CRSR         THRU 7010-EXIT.          
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              MOVE WS-ACTIVE-RETURN-CODE    TO S-RETURN-CODE-1          
              PERFORM 8010-INSERT-GTT-R1       THRU 8010-EXIT           
              MOVE 0                        TO S-RETURN-CODE-2          
              MOVE MRM0000073               TO S-BUS-RULE-ID            
              MOVE WS-FAILED                TO S-ACTION-TYPE-CD         
              PERFORM 7640-GET-RULE-XREF-ID    THRU 7640-EXIT           
              PERFORM 8020-INSERT-GTT-R2       THRU 8020-EXIT           
           ELSE                                                         
              PERFORM 2210-PROCESS-MTR-CRSR    THRU 2210-EXIT           
                UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                 
           END-IF.                                                      
                                                                        
           PERFORM 7020-CLOSE-MTR-CRSR         THRU 7020-EXIT.          
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * PROCESS METER READ DETAILS                                     *        
      ******************************************************************        
       2210-PROCESS-MTR-CRSR.                                           
                                                                        
           MOVE '2210'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
                                                                        
      ***  AROP NO READS WILL NOT BE DISPLAYED IN METER HISTORY                 
           IF PW-TYPE-OF-RD-IND = 'O' AND                               
              (PW-READING-CODE = '0' OR PW-READING-CODE = 'J')          
              PERFORM 7010-FETCH-MTR-CRSR      THRU 7010-EXIT           
              GO TO 2210-EXIT                                           
           END-IF.                                                      
                                                                        
           MOVE PW-LOCAL-OFFICE             TO B1-LOCAL-OFFICE.         
           MOVE PW-COMPANY-NO               TO B1-COMPANY-NO.           
                                                                        
           PERFORM 7200-SELECT-LOCALOFF-DESC   THRU 7200-EXIT.          
                                                                        
           MOVE B1-LOCAL-OFFICE-DESC        TO S-LOCAL-OFFICE-DESC.     
           MOVE PW-READ-CYCLE               TO S-READ-CYCLE.            
                                                                        
           IF PW-READING-CODE = 'H'                                     
               MOVE 'AMI  '                 TO S-METER-READER-ID        
           ELSE                                                         
               INSPECT PW-METER-READER-ID CONVERTING                    
               "abcdefghijklmnopqrstuvwxyz" TO                          
               "ABCDEFGHIJKLMNOPQRSTUVWXYZ"                             
                                                                        
               MOVE PW-METER-READER-ID      TO S-METER-READER-ID        
           END-IF.                                                      
                                                                        
           MOVE PW-READ-ROUTE               TO S-READ-ROUTE.            
           MOVE PW-REG-MEASURE-CD           TO S-REG-MEASURE-CD.        
           MOVE PW-METER-NO                 TO S-METER-NO.              
           MOVE PW-METER-READING            TO S-METER-READING.         
           INITIALIZE WS-READ-DATE-TIME.                                
           MOVE PW-LAST-REG-READ-DT         TO WS-READ-DATE.            
           MOVE PW-LAST-REG-READ-TM         TO WS-READ-TIME.            
           MOVE WS-MICRO-SECOND             TO WS-READ-MS.              
           MOVE WS-READ-DATE-TIME           TO S-LAST-REG-READ-DT-TM.   
                                                                        
           MOVE PW-ACCOUNT-NO               TO WS-ACCOUNT-NO.           
           MOVE WS-ACCOUNT-NO-RED           TO S-ACCOUNT-NO.            
           MOVE PW-CODE-TIME-PERIOD         TO S-CODE-TIME-PERIOD.      
           MOVE PW-CODE-TOU-SEASN           TO S-CODE-TOU-SEASN.        
           MOVE PW-CODE-USAGE-ID            TO S-CODE-USAGE-ID.         
           MOVE ZEROS                       TO S-RATIO.                 
           MOVE PW-MTR-READ-SOURCE-CD       TO S-MTR-READ-SOURCE-CD.    
                                                                        
           MOVE PW-METER-READING            TO WS-METER-READING.        
                                                                        
           COMPUTE WS-CURRENT-USAGE ROUNDED =                           
            ((WS-METER-READING - PW-PREV-METER-READING) * PW-CONSTANT). 
                                                                        
           MOVE PW-ACCOUNT-NO               TO MN-ACCOUNT-NO.           
           MOVE PW-CODE-UTIL-TYPE           TO MN-CODE-UTIL-TYPE        
                                               MC-CODE-UTIL-TYPE.       
           MOVE PW-IC-NO                    TO MN-IC-NO.                
           MOVE PW-METER-NO                 TO MN-METER-NO              
                                               MC-METER-NO.             
                                                                        
           PERFORM 7300-GET-REG-ID-NO          THRU 7300-EXIT.          
                                                                        
           MOVE PW-COMPANY-NO               TO MC-COMPANY-NO.           
           MOVE MN-REG-ID-NO                TO MC-REG-ID-NO.            
                                                                        
           PERFORM 7400-GET-DIAL-NO            THRU 7400-EXIT.          
                                                                        
           PERFORM 2300-ROLLOVER-CHECK         THRU 2300-EXIT.          
                                                                        
           IF WS-CURRENT-USAGE < 0                                      
              COMPUTE WS-CURRENT-USAGE ROUNDED =                        
              ((WS-METER-READING - PW-PREV-METER-READING) * PW-CONSTANT)
           END-IF.                                                      
                                                                        
           IF PW-REG-MEASURE-CD = 'COR'                                 
              MOVE ZERO                          TO S-RATIO             
              MOVE WS-CURRENT-USAGE              TO WS-HOLD-CORR-UNITS  
           ELSE                                                         
              IF PW-REG-MEASURE-CD = 'UNC'                              
                 IF WS-HOLD-CORR-UNITS > 0 AND WS-CURRENT-USAGE > 0     
                    COMPUTE WS-RATIO ROUNDED =                          
                         WS-HOLD-CORR-UNITS / WS-CURRENT-USAGE          
                    MOVE WS-RATIO                TO S-RATIO             
                 ELSE                                                   
                    MOVE ZERO                    TO S-RATIO             
                 END-IF                                                 
              ELSE                                                      
                 IF PW-REG-MEASURE-CD = 'INT'                           
                    IF WS-HOLD-CORR-UNITS > 0 AND WS-CURRENT-USAGE > 0  
                       COMPUTE WS-RATIO ROUNDED =                       
                               WS-HOLD-CORR-UNITS / WS-CURRENT-USAGE    
                       MOVE WS-RATIO             TO S-RATIO             
                    ELSE                                                
                       MOVE ZERO                 TO S-RATIO             
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF PW-REG-MEASURE-CD = 'VER'                                 
              MOVE 'CONSTANT VERIFICATION'       TO S-READING-CODE      
              MOVE SPACES                        TO S-CONDITION-CODE    
           ELSE                                                         
              PERFORM 2220-GET-READ-CODE-DESC  THRU 2220-EXIT           
              PERFORM 2230-PROCESS-READ-COND-DESC                       
                                               THRU 2230-EXIT           
           END-IF.                                                      
                                                                        
      ***  GET METER READ SOURCE CODE DESCRIPTION                               
           MOVE SPACES                      TO X7-MTR-READ-SOURCE-CD    
                                               X7-MTR-READ-SOURCE-TX.   
           MOVE PW-MTR-READ-SOURCE-CD       TO X7-MTR-READ-SOURCE-CD.   
           PERFORM 7500-GET-RD-SOURCE-DESC     THRU 7500-EXIT.          
           MOVE X7-MTR-READ-SOURCE-TX       TO S-READ-SOURCE-DESC.      
                                                                        
      ***  GET TIME PERIOD DESCRIPTION                                          
           INITIALIZE  WS-HOLD-CODE-VALUE                               
                       WS-HOLD-COLUMN-NAME                              
                       WS-CODE-TIME-PERIOD-NUM                          
                       WS-CODE-TIME-PERIOD-RED.                         
           MOVE PW-CODE-TIME-PERIOD         TO WS-CODE-TIME-PERIOD-NUM. 
           MOVE WS-CD-TIME-PD-1             TO WS-HOLD-CODE-VALUE.      
           MOVE WS-CODE-TIME-PERIOD         TO WS-HOLD-COLUMN-NAME.     
           PERFORM 2400-GET-CODE-VALUE-DESC    THRU 2400-EXIT.          
           MOVE WS-HOLD-DESC                TO S-TIME-PERIOD-DESC.      
                                                                        
      ***  GET TIME OF USE SEASON DESCRIPTION                                   
           MOVE SPACES                      TO WS-HOLD-CODE-VALUE       
                                               WS-HOLD-COLUMN-NAME.     
           MOVE PW-CODE-TOU-SEASN           TO WS-HOLD-CODE-VALUE.      
           MOVE WS-CODE-TOU-SEASON          TO WS-HOLD-COLUMN-NAME.     
           PERFORM 2400-GET-CODE-VALUE-DESC    THRU 2400-EXIT.          
           MOVE WS-HOLD-DESC                TO S-SEASON-DESC.           
                                                                        
      ***  GET USAGE ID DESCRIPTION                                             
           MOVE SPACES                      TO WS-HOLD-CODE-VALUE       
                                               WS-HOLD-COLUMN-NAME.     
           MOVE PW-CODE-USAGE-ID            TO WS-HOLD-CODE-VALUE.      
           MOVE WS-CODE-USAGE-ID            TO WS-HOLD-COLUMN-NAME.     
           PERFORM 2400-GET-CODE-VALUE-DESC    THRU 2400-EXIT.          
           MOVE WS-HOLD-DESC                TO S-USAGE-ID-DESC.         
                                                                        
           PERFORM 8010-INSERT-GTT-R1          THRU 8010-EXIT.          
                                                                        
           PERFORM 7010-FETCH-MTR-CRSR         THRU 7010-EXIT.          
                                                                        
       2210-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 2220-GET-READ-CODE-DESC                                        *        
      ******************************************************************        
       2220-GET-READ-CODE-DESC.                                         
                                                                        
           MOVE '2220'                      TO ACTIVE-PARAGRAPH.        
                                                                        
      ***  AROP OUT OF CYCLE READ HANDLING                                      
      *                                                                         
           IF PW-TYPE-OF-RD-IND = 'O'                                   
              MOVE 'AROP OOC READ'          TO S-READING-CODE           
              GO TO 2220-EXIT                                           
           END-IF.                                                      
                                                                        
      * GET READING CODE DESC FOR PW-READING-CODE                               
           MOVE SPACES                      TO WS-HOLD-CODE-VALUE       
                                               WS-HOLD-COLUMN-NAME.     
           MOVE PW-READING-CODE             TO WS-HOLD-CODE-VALUE.      
           MOVE WS-READING-CODE             TO WS-HOLD-COLUMN-NAME.     
           PERFORM 2400-GET-CODE-VALUE-DESC    THRU 2400-EXIT.          
           MOVE WS-HOLD-DESC                TO S-READING-CODE.          
                                                                        
       2220-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 2220-GET-READ-CODE-DESC                                        *        
      ******************************************************************        
       2230-PROCESS-READ-COND-DESC.                                     
                                                                        
           MOVE '2230'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           MOVE PW-READING-COND-CD          TO S4-CODE-NO-RD-REASON.    
                                                                        
           PERFORM 7100-SELECT-READ-COND-DESC  THRU 7100-EXIT.          
                                                                        
           IF  WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL             
               MOVE  S4-NO-RD-REASON-DESC   TO S-CONDITION-CODE         
           ELSE                                                         
               MOVE SPACES                  TO S-CONDITION-CODE         
           END-IF.                                                      
                                                                        
       2230-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 2300-ROLLOVER-CHECK                                            *        
      ******************************************************************        
       2300-ROLLOVER-CHECK.                                             
                                                                        
           MOVE '2300'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           IF WS-CURRENT-USAGE < ZERO                                   
              EVALUATE MC-NO-READ-DIALS                                 
                 WHEN 3                                                 
                      ADD        1000       TO WS-METER-READING         
                 WHEN 4                                                 
                      ADD       10000       TO WS-METER-READING         
                 WHEN 5                                                 
                      ADD      100000       TO WS-METER-READING         
                 WHEN 6                                                 
                      ADD     1000000       TO WS-METER-READING         
                 WHEN 7                                                 
                      ADD    10000000       TO WS-METER-READING         
                 WHEN 8                                                 
                      ADD   100000000       TO WS-METER-READING         
                 WHEN 9                                                 
                      ADD  1000000000       TO WS-METER-READING         
                 WHEN 10                                                
                      ADD 10000000000       TO WS-METER-READING         
            END-IF.                                                     
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2400-GET-CODE-VALUE-DESC.                                      *        
      ******************************************************************        
       2400-GET-CODE-VALUE-DESC.                                        
                                                                        
           MOVE '2400'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           MOVE 0                           TO WS-CDV-SUB.              
           MOVE SPACES                      TO WS-HOLD-DESC.            
           SET CODE-VALUE-NOT-FOUND         TO TRUE.                    
                                                                        
           PERFORM VARYING WS-CDV-SUB FROM 1 BY 1                       
             UNTIL WS-CDV-SUB > 200                                     
                OR CODE-VALUE-FOUND                                     
              IF  TAB-CODE-VALUE(WS-CDV-SUB)  = WS-HOLD-CODE-VALUE      
                 IF TAB-COLUMN-NA(WS-CDV-SUB) = WS-HOLD-COLUMN-NAME     
                    MOVE TAB-CODE-SHORT-DESC(WS-CDV-SUB) TO WS-HOLD-DESC
                    SET CODE-VALUE-FOUND        TO TRUE                 
                 END-IF                                                 
              END-IF                                                    
           END-PERFORM.                                                 
                                                                        
       2400-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *  OPENS THE CURSOR DECLARED FOR GETTING METER READ DETAILS      *        
      ******************************************************************        
       7000-OPEN-MTR-CRSR.                                              
                                                                        
           EXEC SQL                                                     
               OPEN MTR_CRSR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE   TO S-RETURN-CODE-1          
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7000'                  TO ACTIVE-PARAGRAPH         
               MOVE 'OPEN'                  TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_ROUTE_REPORT'      TO TABLE-1                  
               MOVE 'CSS_LOCAL_OFFICE'      TO TABLE-2                  
               MOVE 'CSS_MTRD_ENVRNMT'      TO TABLE-3                  
               MOVE 'CSS_UTIL_ENVRNMT'      TO TABLE-4                  
               MOVE 'PREMISE_NO'            TO TABLE-ELEMENT-1          
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2          
               MOVE 'IC_NO'                 TO TABLE-ELEMENT-3          
               MOVE 'MTR_REF_NO'            TO TABLE-ELEMENT-4          
               MOVE UT-PREMISE-NO           TO HOSTVAR-ELEMENT-1        
               MOVE PW-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2        
               MOVE PW-IC-NO                TO HOSTVAR-ELEMENT-3        
               MOVE MN-MTR-REF-NO           TO HOSTVAR-ELEMENT-4        
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *  FETCHES THE CURSOR DECLARED FOR GETTING THE METER READ DETAILS*        
      ******************************************************************        
       7010-FETCH-MTR-CRSR.                                             
                                                                        
           EXEC SQL                                                     
               FETCH MTR_CRSR                                           
               INTO   :PW-LOCAL-OFFICE                                  
                     ,:PW-READ-CYCLE                                    
                     ,:PW-METER-READER-ID                               
                     ,:PW-READ-ROUTE                                    
                     ,:PW-REG-MEASURE-CD                                
                     ,:PW-METER-NO                                      
                     ,:PW-METER-READING                                 
                     ,:PW-LAST-REG-READ-DT :WS-METER-NULL-IND1          
                     ,:PW-LAST-REG-READ-TM :WS-METER-NULL-IND2          
                     ,:PW-READING-CODE                                  
                     ,:PW-READING-COND-CD                               
                     ,:PW-ACCOUNT-NO                                    
                     ,:PW-REVENUE-MONTH                                 
                     ,:PW-COMPANY-NO                                    
                     ,:PW-CONSTANT                                      
                     ,:PW-MTR-READ-SOURCE-CD                            
                     ,:PW-PREV-METER-READING :WS-METER-NULL-IND0        
                     ,:PW-CODE-TIME-PERIOD                              
                     ,:PW-CODE-TOU-SEASN                                
                     ,:PW-TYPE-OF-RD-IND                                
                     ,:PW-CODE-USAGE-ID                                 
                     ,:ALT-CODE-TIME-PERIOD                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               IF WS-METER-NULL-IND0 < 0                                
                  MOVE ZEROES               TO PW-PREV-METER-READING    
               END-IF                                                   
               IF WS-METER-NULL-IND1 < 0                                
                  MOVE SPACES               TO PW-LAST-REG-READ-DT      
               END-IF                                                   
               IF WS-METER-NULL-IND2 < 0                                
                  MOVE ZEROES               TO PW-LAST-REG-READ-TM      
               END-IF                                                   
               IF WS-METER-NULL-IND3 < 0                                
                  MOVE SPACES               TO PW-MTR-READ-SOURCE-CD    
               END-IF                                                   
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE   TO S-RETURN-CODE-1          
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7010'                  TO ACTIVE-PARAGRAPH         
               MOVE 'FETCH'                 TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_ROUTE_REPORT'      TO TABLE-1                  
               MOVE 'CSS_LOCAL_OFFICE'      TO TABLE-2                  
               MOVE 'CSS_MTRD_ENVRNMT'      TO TABLE-3                  
               MOVE 'CSS_UTIL_ENVRNMT'      TO TABLE-4                  
               MOVE 'PREMISE_NO'            TO TABLE-ELEMENT-1          
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2          
               MOVE 'IC_NO'                 TO TABLE-ELEMENT-3          
               MOVE 'MTR_REF_NO'            TO TABLE-ELEMENT-4          
               MOVE UT-PREMISE-NO           TO HOSTVAR-ELEMENT-1        
               MOVE PW-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2        
               MOVE PW-IC-NO                TO HOSTVAR-ELEMENT-3        
               MOVE MN-MTR-REF-NO           TO HOSTVAR-ELEMENT-4        
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  CLOSES THE CURSOR DECLARED FOR GETTING THE METER READ DETAILS *        
      ******************************************************************        
       7020-CLOSE-MTR-CRSR.                                             
                                                                        
           EXEC SQL                                                     
               CLOSE MTR_CRSR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE   TO S-RETURN-CODE-1          
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7020'                  TO ACTIVE-PARAGRAPH         
               MOVE 'CLOSE'                 TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_ROUTE_REPORT'      TO TABLE-1                  
               MOVE 'CSS_LOCAL_OFFICE'      TO TABLE-2                  
               MOVE 'CSS_MTRD_ENVRNMT'      TO TABLE-3                  
               MOVE 'CSS_UTIL_ENVRNMT'      TO TABLE-4                  
               MOVE 'PREMISE_NO'            TO TABLE-ELEMENT-1          
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2          
               MOVE 'IC_NO'                 TO TABLE-ELEMENT-3          
               MOVE 'MTR_REF_NO'            TO TABLE-ELEMENT-4          
               MOVE UT-PREMISE-NO           TO HOSTVAR-ELEMENT-1        
               MOVE PW-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2        
               MOVE PW-IC-NO                TO HOSTVAR-ELEMENT-3        
               MOVE MN-MTR-REF-NO           TO HOSTVAR-ELEMENT-4        
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  SELECTS NO READ REASON DESCRIPTION                            *        
      ******************************************************************        
       7100-SELECT-READ-COND-DESC.                                      
                                                                        
           EXEC SQL                                                     
              SELECT  NO_RD_REASON_DESC                                 
                INTO  :S4-NO-RD-REASON-DESC                             
                FROM  CSS_NO_READ_REASON WITH(READUNCOMMITTED)                  
                WHERE CODE_NO_RD_REASON = :S4-CODE-NO-RD-REASON         
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  NO_RD_REASON_DESC                                         
MFA-TR*         INTO  :S4-NO-RD-REASON-DESC                                     
MFA-TR*         FROM  CSS_NO_READ_REASON                                        
MFA-TR*         WHERE CODE_NO_RD_REASON = :S4-CODE-NO-RD-REASON                 
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE        TO S-RETURN-CODE-1     
               MOVE PROGRAM-NAME                 TO ABEND-PROGRAM       
               MOVE '7100'                       TO ACTIVE-PARAGRAPH    
               MOVE 'SELECT'                     TO ABEND-FUNCTION      
               MOVE SPACES                       TO ABEND-SQL-PREDICATES
                                                    ABEND-TABLES        
               MOVE 'CSS_NO_READ_REASON'         TO TABLE-1             
               MOVE 'CODE_NO_RD_REASON'          TO TABLE-ELEMENT-1     
               MOVE 'CODE_UTIL_TYPE'             TO TABLE-ELEMENT-2     
               MOVE 'PREMISE_NO'                 TO TABLE-ELEMENT-3     
               MOVE 'IC_NO'                      TO TABLE-ELEMENT-4     
               MOVE S4-CODE-NO-RD-REASON         TO HOSTVAR-ELEMENT-1   
               MOVE PW-CODE-UTIL-TYPE            TO HOSTVAR-ELEMENT-2   
               MOVE UT-PREMISE-NO                TO HOSTVAR-ELEMENT-3   
               MOVE PW-IC-NO                     TO HOSTVAR-ELEMENT-4   
               PERFORM 9700-PROCESS-ABEND           THRU 9700-EXIT      
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  SELECT THE DESCRIPTION OF LOCAL OFFICE                        *        
      ******************************************************************        
       7200-SELECT-LOCALOFF-DESC.                                       
                                                                        
           EXEC SQL                                                     
              SELECT  LOCAL_OFFICE_DESC                                 
                INTO  :B1-LOCAL-OFFICE-DESC                             
                FROM  CSS_LOCAL_OFFICE WITH(READUNCOMMITTED)                    
                WHERE LOCAL_OFFICE = :B1-LOCAL-OFFICE                   
                   AND COMPANY_NO  = :B1-COMPANY-NO                     
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  LOCAL_OFFICE_DESC                                         
MFA-TR*         INTO  :B1-LOCAL-OFFICE-DESC                                     
MFA-TR*         FROM  CSS_LOCAL_OFFICE                                          
MFA-TR*         WHERE LOCAL_OFFICE = :B1-LOCAL-OFFICE                           
MFA-TR*            AND COMPANY_NO  = :B1-COMPANY-NO                             
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE   TO S-RETURN-CODE-1          
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7200'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_LOCAL_OFFICE'      TO TABLE-1                  
               MOVE 'LOCAL_OFFICE'          TO TABLE-ELEMENT-1          
               MOVE 'COMPANY_NO'            TO TABLE-ELEMENT-2          
               MOVE B1-LOCAL-OFFICE         TO HOSTVAR-ELEMENT-1        
               MOVE B1-COMPANY-NO           TO HOSTVAR-ELEMENT-2        
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  SELECT REGISTER ID FOR THE METER                              *        
      ******************************************************************        
       7300-GET-REG-ID-NO.                                              
                                                                        
           EXEC SQL                                                     
              SELECT REG_ID_NO                                          
                INTO :MN-REG-ID-NO                                      
                FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                     
              WHERE  ACCOUNT_NO     = :MN-ACCOUNT-NO                    
                AND  CODE_UTIL_TYPE = :MN-CODE-UTIL-TYPE                
                AND  IC_NO          = :MN-IC-NO                         
                AND  METER_NO       = :MN-METER-NO                      
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT REG_ID_NO                                                  
MFA-TR*         INTO :MN-REG-ID-NO                                              
MFA-TR*         FROM CSS_MTRD_ENVRNMT                                           
MFA-TR*       WHERE  ACCOUNT_NO     = :MN-ACCOUNT-NO                            
MFA-TR*         AND  CODE_UTIL_TYPE = :MN-CODE-UTIL-TYPE                        
MFA-TR*         AND  IC_NO          = :MN-IC-NO                                 
MFA-TR*         AND  METER_NO       = :MN-METER-NO                              
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE  SQLCODE                    TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE   TO S-RETURN-CODE-1          
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7300'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_MTRD_ENVRNMT'      TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2          
               MOVE 'IC_NO'                 TO TABLE-ELEMENT-3          
               MOVE 'METER_NO'              TO TABLE-ELEMENT-4          
               MOVE MN-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               MOVE MN-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2        
               MOVE MN-IC-NO                TO HOSTVAR-ELEMENT-3        
               MOVE MN-METER-NO             TO HOSTVAR-ELEMENT-4        
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  SELECT READ DIALS FOR THE METER                               *        
      ******************************************************************        
       7400-GET-DIAL-NO.                                                
                                                                        
            EXEC SQL                                                    
                SELECT NO_READ_DIALS                                    
                  INTO :MC-NO-READ-DIALS                                
                  FROM CSS_MTR_CAP WITH(READUNCOMMITTED)                        
                 WHERE CODE_UTIL_TYPE = :MC-CODE-UTIL-TYPE              
                   AND COMPANY_NO     = :MC-COMPANY-NO                  
                   AND METER_NO       = :MC-METER-NO                    
                   AND REG_ID_NO      = :MC-REG-ID-NO                   
                                                                 
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*         SELECT NO_READ_DIALS                                            
MFA-TR*           INTO :MC-NO-READ-DIALS                                        
MFA-TR*           FROM CSS_MTR_CAP                                              
MFA-TR*          WHERE CODE_UTIL_TYPE = :MC-CODE-UTIL-TYPE                      
MFA-TR*            AND COMPANY_NO     = :MC-COMPANY-NO                          
MFA-TR*            AND METER_NO       = :MC-METER-NO                            
MFA-TR*            AND REG_ID_NO      = :MC-REG-ID-NO                           
MFA-TR*          WITH UR                                                        
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE  SQLCODE                   TO WS-ACTIVE-RETURN-CODE.   
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE WS-ACTIVE-RETURN-CODE   TO S-RETURN-CODE-1          
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7400'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_MTR_CAP'           TO TABLE-1                  
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-1          
               MOVE 'COMPANY_NO'            TO TABLE-ELEMENT-2          
               MOVE 'METER_NO'              TO TABLE-ELEMENT-3          
               MOVE 'REG_ID_NO'             TO TABLE-ELEMENT-4          
               MOVE MC-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-1        
               MOVE MC-COMPANY-NO           TO HOSTVAR-ELEMENT-2        
               MOVE MC-METER-NO             TO HOSTVAR-ELEMENT-3        
               MOVE MC-REG-ID-NO            TO HOSTVAR-ELEMENT-4        
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  SELECT READ SOURCE DESCRIPTION                                *        
      ******************************************************************        
       7500-GET-RD-SOURCE-DESC.                                         
                                                                        
            EXEC SQL                                                    
                SELECT MTR_READ_SOURCE_TX                               
                  INTO :X7-MTR-READ-SOURCE-TX                           
                  FROM CSS_MTR_RD_SOURCE WITH(READUNCOMMITTED)                  
                 WHERE MTR_READ_SOURCE_CD = :X7-MTR-READ-SOURCE-CD      
                                                                 
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*         SELECT MTR_READ_SOURCE_TX                                       
MFA-TR*           INTO :X7-MTR-READ-SOURCE-TX                                   
MFA-TR*           FROM CSS_MTR_RD_SOURCE                                        
MFA-TR*          WHERE MTR_READ_SOURCE_CD = :X7-MTR-READ-SOURCE-CD              
MFA-TR*          WITH UR                                                        
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE  SQLCODE                   TO WS-ACTIVE-RETURN-CODE.   
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE WS-ACTIVE-RETURN-CODE   TO S-RETURN-CODE-1          
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7500'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_MTR_RD_SOURCE '    TO TABLE-1                  
               MOVE 'MTR_READ_SOURCE_CD'    TO TABLE-ELEMENT-1          
               MOVE X7-MTR-READ-SOURCE-CD   TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  OPENS THE CURSOR DECLARED FOR GETTING CODE VALUES             *        
      ******************************************************************        
       7610-OPEN-CDV-CRSR.                                              
                                                                        
           EXEC SQL                                                     
               OPEN CDV_CRSR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE   TO S-RETURN-CODE-1          
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7610'                  TO ACTIVE-PARAGRAPH         
               MOVE 'OPEN'                  TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_CODE_VALUE'        TO TABLE-1                  
               MOVE 'TABLE_NA'              TO TABLE-ELEMENT-1          
               MOVE 'CSS_ROUTE_REPORT'      TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7610-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *  FETCHES THE CURSOR DECLARED FOR GETTING CODE VALUE DESCRIPTION*        
      ******************************************************************        
       7620-FETCH-CDV-CRSR.                                             
                                                                        
           EXEC SQL                                                     
               FETCH  CDV_CRSR                                          
               INTO  :UV-CODE-VALUE                                     
                    ,:UV-COLUMN-NA                                      
                    ,:UV-CODE-SHORT-DESC                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               MOVE SQLERRD(3)              TO WS-CD-VALUE-ROWS         
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE   TO S-RETURN-CODE-1          
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7620'                  TO ACTIVE-PARAGRAPH         
               MOVE 'FETCH'                 TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_CODE_VALUE'        TO TABLE-1                  
               MOVE 'TABLE_NA'              TO TABLE-ELEMENT-1          
               MOVE 'CSS_ROUTE_REPORT'      TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7620-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  CLOSES THE CURSOR DECLARED FOR GETTING THE CODE VALUE DESC    *        
      ******************************************************************        
       7630-CLOSE-CDV-CRSR.                                             
                                                                        
           EXEC SQL                                                     
               CLOSE CDV_CRSR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE   TO S-RETURN-CODE-1          
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7630'                  TO ACTIVE-PARAGRAPH         
               MOVE 'CLOSE'                 TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_CODE_VALUE'        TO TABLE-1                  
               MOVE 'TABLE_NA'              TO TABLE-ELEMENT-1          
               MOVE 'CSS_ROUTE_REPORT'      TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7630-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  GET BUSINESS RULE CROSSREFERENCE ID FROM BUS RULE ID.         *        
      ******************************************************************        
       7640-GET-RULE-XREF-ID.                                           
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           BUS_RULE_XREF_ID, 121), ' ', '-'), ':', '.') 
           BUS_RULE_XREF_ID                                   
                INTO :S-BUS-RULE-XREF-ID                                
                FROM CSS_BUS_RULE   [1R] WITH(READUNCOMMITTED)                  
                    ,CSS_BUS_RULE_XREF [1T] WITH(READUNCOMMITTED)               
               WHERE [1R].BUS_RULE_ID = :S-BUS-RULE-ID                    
                 AND [1R].BUS_RULE_ID = [1T].BUS_RULE_ID                    
                                             
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BUS_RULE_XREF_ID                                           
MFA-TR*         INTO :S-BUS-RULE-XREF-ID                                        
MFA-TR*         FROM CSS_BUS_RULE   1R                                          
MFA-TR*             ,CSS_BUS_RULE_XREF 1T                                       
MFA-TR*        WHERE 1R.BUS_RULE_ID = :S-BUS-RULE-ID                            
MFA-TR*          AND 1R.BUS_RULE_ID = 1T.BUS_RULE_ID                            
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7640                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
               MOVE SPACES                  TO ABEND-TABLES             
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
               MOVE '7640'                  TO ACTIVE-PARAGRAPH         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_BUS_RULE'          TO TABLE-1                  
               MOVE 'BUS_RULE_ID'           TO TABLE-ELEMENT-1          
               MOVE S-BUS-RULE-ID           TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7640-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  DELETE SESSION TABLE - INITIAL                                *        
      ******************************************************************        
       8000A-DELETE-GTT-ROWS.                                           
                                                                        
            EXEC SQL                                                    
                DELETE                                                  
                  FROM #CSR04645_R1                              
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE                                                          
MFA-TR*           FROM SESSION.CSR04645_R1                                      
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.   
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE SQLCODE                 TO ABEND-SQLCODE            
               MOVE SQLSTATE                TO ABEND-SQLSTATE           
               MOVE '8000A'                 TO ACTIVE-PARAGRAPH         
               MOVE 'DELETE'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
               MOVE 'CSR04645_R1'           TO TABLE-1                  
               MOVE SPACES                  TO TABLE-ELEMENT-1          
               MOVE SPACES                  TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  DELETE SESSION TABLE - BUSINESS RULES                         *        
      ******************************************************************        
       8000B-DELETE-GTT-ROWS.                                           
                                                                        
            EXEC SQL                                                    
                DELETE                                                  
                  FROM #CSR04645_R2                              
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE                                                          
MFA-TR*           FROM SESSION.CSR04645_R2                                      
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.   
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE SQLCODE                 TO ABEND-SQLCODE            
               MOVE SQLSTATE                TO ABEND-SQLSTATE           
               MOVE '8000B'                 TO ACTIVE-PARAGRAPH         
               MOVE 'CSR04645_R2'           TO TABLE-1                  
               MOVE 'DELETE'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8000B-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8010-INSERT-GTT-R1.  METER READ HISTORY DATA                   *        
      ******************************************************************        
       8010-INSERT-GTT-R1.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04645_R1                            
             (                                                          
              RETURN_CODE                                               
             ,LAST_REG_READ_DT_TM                                       
             ,METER_READING                                             
             ,METER_NO                                                  
             ,READING_CODE                                              
             ,MTR_READ_SOURCE_CD                                        
             ,REG_MEASURE_CD                                            
             ,READ_CYCLE                                                
             ,READ_ROUTE                                                
             ,CONDITION_CODE                                            
             ,ACCOUNT_NO                                                
             ,LOCAL_OFFICE_DESC                                         
             ,METER_READER_ID                                           
             ,CODE_TIME_PERIOD                                          
             ,CODE_TOU_SEASN                                            
             ,CODE_USAGE_ID                                             
             ,RATIO                                                     
             ,TIME_PERIOD_DESC                                          
             ,SEASON_DESC                                               
             ,USAGE_ID_DESC                                             
             ,READ_SOURCE_DESC                                          
             )                                                          
             VALUES                                                     
             (                                                          
              :S-RETURN-CODE-1                                          
             ,:S-LAST-REG-READ-DT-TM                                    
             ,:S-METER-READING                                          
             ,:S-METER-NO                                               
             ,:S-READING-CODE                                           
             ,:S-MTR-READ-SOURCE-CD                                     
             ,:S-REG-MEASURE-CD                                         
             ,:S-READ-CYCLE                                             
             ,:S-READ-ROUTE                                             
             ,:S-CONDITION-CODE                                         
             ,:S-ACCOUNT-NO                                             
             ,:S-LOCAL-OFFICE-DESC                                      
             ,:S-METER-READER-ID                                        
             ,:S-CODE-TIME-PERIOD                                       
             ,:S-CODE-TOU-SEASN                                         
             ,:S-CODE-USAGE-ID                                          
             ,:S-RATIO                                                  
             ,:S-TIME-PERIOD-DESC                                       
             ,:S-SEASON-DESC                                            
             ,:S-USAGE-ID-DESC                                          
             ,:S-READ-SOURCE-DESC                                       
             )                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04645_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,LAST_REG_READ_DT_TM                                               
MFA-TR*      ,METER_READING                                                     
MFA-TR*      ,METER_NO                                                          
MFA-TR*      ,READING_CODE                                                      
MFA-TR*      ,MTR_READ_SOURCE_CD                                                
MFA-TR*      ,REG_MEASURE_CD                                                    
MFA-TR*      ,READ_CYCLE                                                        
MFA-TR*      ,READ_ROUTE                                                        
MFA-TR*      ,CONDITION_CODE                                                    
MFA-TR*      ,ACCOUNT_NO                                                        
MFA-TR*      ,LOCAL_OFFICE_DESC                                                 
MFA-TR*      ,METER_READER_ID                                                   
MFA-TR*      ,CODE_TIME_PERIOD                                                  
MFA-TR*      ,CODE_TOU_SEASN                                                    
MFA-TR*      ,CODE_USAGE_ID                                                     
MFA-TR*      ,RATIO                                                             
MFA-TR*      ,TIME_PERIOD_DESC                                                  
MFA-TR*      ,SEASON_DESC                                                       
MFA-TR*      ,USAGE_ID_DESC                                                     
MFA-TR*      ,READ_SOURCE_DESC                                                  
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S-RETURN-CODE-1                                                  
MFA-TR*      ,:S-LAST-REG-READ-DT-TM                                            
MFA-TR*      ,:S-METER-READING                                                  
MFA-TR*      ,:S-METER-NO                                                       
MFA-TR*      ,:S-READING-CODE                                                   
MFA-TR*      ,:S-MTR-READ-SOURCE-CD                                             
MFA-TR*      ,:S-REG-MEASURE-CD                                                 
MFA-TR*      ,:S-READ-CYCLE                                                     
MFA-TR*      ,:S-READ-ROUTE                                                     
MFA-TR*      ,:S-CONDITION-CODE                                                 
MFA-TR*      ,:S-ACCOUNT-NO                                                     
MFA-TR*      ,:S-LOCAL-OFFICE-DESC                                              
MFA-TR*      ,:S-METER-READER-ID                                                
MFA-TR*      ,:S-CODE-TIME-PERIOD                                               
MFA-TR*      ,:S-CODE-TOU-SEASN                                                 
MFA-TR*      ,:S-CODE-USAGE-ID                                                  
MFA-TR*      ,:S-RATIO                                                          
MFA-TR*      ,:S-TIME-PERIOD-DESC                                               
MFA-TR*      ,:S-SEASON-DESC                                                    
MFA-TR*      ,:S-USAGE-ID-DESC                                                  
MFA-TR*      ,:S-READ-SOURCE-DESC                                               
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                        TO CTR-ROWS-RS1             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
              MOVE '8010'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE 'CSR04645_R1'            TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8010-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 8020-INSERT-GTT-R2.  BUSINESS RULES.                           *        
      ******************************************************************        
       8020-INSERT-GTT-R2.                                              
                                                                        
           EXEC SQL                                                     
               INSERT INTO #CSR04645_R2                          
                 (                                                      
                   RETURN_CODE                                          
                  ,BUS_RULE_ID                                          
                  ,ACTION_TYPE_CD                                       
                  ,BUS_RULE_XREF_ID                                     
                 )                                                      
               VALUES                                                   
                 (                                                      
                   :S-RETURN-CODE-2                                     
                  ,:S-BUS-RULE-ID                                       
                  ,:S-ACTION-TYPE-CD                                    
                  ,:S-BUS-RULE-XREF-ID                                  
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO SESSION.CSR04645_R2                                  
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,BUS_RULE_ID                                                  
MFA-TR*           ,ACTION_TYPE_CD                                               
MFA-TR*           ,BUS_RULE_XREF_ID                                             
MFA-TR*          )                                                              
MFA-TR*        VALUES                                                           
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-2                                             
MFA-TR*           ,:S-BUS-RULE-ID                                               
MFA-TR*           ,:S-ACTION-TYPE-CD                                            
MFA-TR*           ,:S-BUS-RULE-XREF-ID                                          
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                        TO CTR-ROWS-RS2             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE '8020'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE 'CSR04645_R2'            TO TABLE-1                  
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
       8020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8800-CHECK-RESULTS.                                           *         
      *****************************************************************         
       8800-CHECK-RESULTS.                                              
                                                                        
           IF CTR-ROWS-RS1 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-1                            
              MOVE 0                        TO S-RETURN-CODE-1          
              PERFORM 8010-INSERT-GTT-R1       THRU 8010-EXIT           
           END-IF.                                                      
                                                                        
           IF CTR-ROWS-RS2 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-2                            
              MOVE 0                        TO S-RETURN-CODE-2          
              PERFORM 8020-INSERT-GTT-R2       THRU 8020-EXIT           
           END-IF.                                                      
                                                                        
       8800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8900-SEND-DONE.                                               *         
      *****************************************************************         
       8900-SEND-DONE.                                                  
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           EXEC SQL                                                     
               OPEN C2                                                  
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
                                                    
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 9000-SEND-ERROR-RESULT.                                       *         
      *****************************************************************         
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE       TO ABEND-SQLCODE            
                                               S-RETURN-CODE-1          
                                               S-RETURN-CODE-2.         
                                                                        
           MOVE SQLERRMC                    TO ABEND-SQLERRMC.          
                                                                        
           IF WS-GTT01-DECLARED = 'N'                                   
              PERFORM 0100A-DECLARE-GTT-R1     THRU 0100A-EXIT          
           END-IF.                                                      
                                                                        
           IF WS-GTT02-DECLARED = 'N'                                   
              PERFORM 0100B-DECLARE-GTT-R2     THRU 0100B-EXIT          
           END-IF.                                                      
                                                                        
           PERFORM 8010-INSERT-GTT-R1          THRU 8010-EXIT.          
           PERFORM 8020-INSERT-GTT-R2          THRU 8020-EXIT.          
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 9700-PROCESS-ABEND.                                           *         
      *****************************************************************         
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT      THRU 9000-EXIT.          
           PERFORM 9900-SQL-ERROR-ROUTINE      THRU 9900-EXIT.          
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 9900-SQL-ERROR-ROUTINE.                                       *         
      *****************************************************************         
       9900-SQL-ERROR-ROUTINE.                                          

MSQ002     EXEC SQL
MSQ002         SELECT LTRIM(RTRIM(CASE                                          
                        WHEN :TABLE-ELEMENT-1 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-1)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-1))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-2 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-2)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-2))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-3 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-3)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-3))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-4 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-4)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-4))                    
                        ELSE                                            
                           ''                                           
                     END))
MSQ002              , :ABEND-FUNCTION
MSQ002              , 'PARAGRAPH-' + LTRIM(RTRIM(:ACTIVE-PARAGRAPH)) + 
           ',' + 'TABLES-' + LTRIM(RTRIM(:TABLE-2)) + ',' + 
           LTRIM(RTRIM(:TABLE-3)) + ',' + LTRIM(RTRIM(:TABLE-4)) + 
           ',' + 'ERRMSG-' + LTRIM(RTRIM(:ABEND-SQLERRMC))
MSQ002           INTO :MFA-CSRERLOG.ARG-5
MSQ002              , :MFA-CSRERLOG.ARG-6
MSQ002              , :MFA-CSRERLOG.ARG-7
MSQ002     END-EXEC
                                                                        
           EXEC SQL                                                     
               CALL CSRERLOG ( :ABEND-PROGRAM
                  , :ABEND-SQLCODE
                  , :ABEND-SQLSTATE
                  , :TABLE-1
                  , :MFA-CSRERLOG.ARG-5
                  , :MFA-CSRERLOG.ARG-6
                  , :MFA-CSRERLOG.ARG-7
                  )                                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ002
MFA-TR*    EXEC SQL                                                             
MFA-TR*        CALL CSRERLOG (                                                  
MFA-TR*             :ABEND-PROGRAM,                                             
MFA-TR*             :ABEND-SQLCODE,                                             
MFA-TR*             :ABEND-SQLSTATE,                                            
MFA-TR*             :TABLE-1,                                                   
MFA-TR*              VARCHAR(STRIP(                                             
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-1 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-1) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-1)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-2 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-2) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-2)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-3 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-3) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-3)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-4 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-4) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-4)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END                                                        
MFA-TR*              )),                                                        
MFA-TR*              VARCHAR(:ABEND-FUNCTION),                                  
MFA-TR*              VARCHAR(                                                   
MFA-TR*              'PARAGRAPH-' CONCAT STRIP(:ACTIVE-PARAGRAPH) CONCAT        
MFA-TR*              ',' CONCAT 'TABLES-' CONCAT STRIP(:TABLE-2) CONCAT         
MFA-TR*              ',' CONCAT STRIP(:TABLE-3) CONCAT                          
MFA-TR*              ',' CONCAT STRIP(:TABLE-4) CONCAT                          
MFA-TR*              ',' CONCAT 'ERRMSG-' CONCAT STRIP(:ABEND-SQLERRMC)         
MFA-TR*              )                                                          
MFA-TR*             )                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           PERFORM 8900-SEND-DONE              THRU 8900-EXIT.          
           
MSQ016        GOBACK.                                                    
                                                                        
       9900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 9999-END-PROGRAM.                                             *         
      *****************************************************************         
       9999-END-PROGRAM.                                                
                                                                        
           PERFORM 8800-CHECK-RESULTS          THRU 8800-EXIT.          
           PERFORM 8900-SEND-DONE              THRU 8900-EXIT.          
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
