       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.      CSR04644.                                       
       AUTHOR.       SAKTHIVEL MATHIYAZHAGAN.                           
COB303 DATE-WRITTEN. 30 JULY 2013.                                      
       DATE-COMPILED.                                                   
      *----------------------------------------------------------------         
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE: CSR04644               --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--                                                            --         
      *--  CSR04644 :                                                --         
      *--                                                            --         
      *--  #  THIS STORED PROCEDURE IS PERFORM TO UPDATE AND DELETE  --         
      *--     FOR METER & REGISTER READ SCREEN.                      --         
      *--                                                            --         
      *--  #  DELETE CAN PERFORM WHEN METER STATUS IS REMOVED.       --         
      *--                                                            --         
      *--  #  CLONED FROM: CSR02080                                  --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *--  PARAMETERS                                                --         
      *--                                                            --         
      *--      IN                                                    --         
      *--            I_APPL_PGM_ID              CHAR(08)             --         
      *--            I_USER_ID                  CHAR(07)             --         
      *--            I_OPERATION_ID             CHAR(02)             --         
      *--            I_MTR_UPDT_ACTN_IND        CHAR(01)             --         
      *--            I_MTR_ACCOUNT_NO           CHAR(13)             --         
      *--            I_MTR_CODE_UTIL_TYPE       CHAR(01)             --         
      *--            I_MTR_IC_NO                SMALLINT             --         
      *--            I_METER_NO                 CHAR(09)             --         
      *--            I_MTR_REF_NO               SMALLINT             --         
      *--            I_MTR_POINT_ID             CHAR(10)             --         
      *--            I_MTR_PRESSURE             CHAR(03)             --         
      *--            I_MTR_READ_SOURCE_CD       CHAR(01)             --         
      *--            I_MTR_CODE_METER_LOC       CHAR(02)             --         
      *--            I_MTR_REMOTE_READ_IND      CHAR(01)             --         
      *--            I_MTR_METER_SUPPLYING      CHAR(15)             --         
      *--            I_MTR_CODE_MTR_RD_INST1    CHAR(02)             --         
      *--            I_MTR_UTILITY_SOURCE_CD    CHAR(01)             --         
      *--            I_MTR_NO_CONSEC_ESTIMATE   SMALLINT             --         
      *--            I_MTR_DELIVERY_LEVEL_CD    CHAR(01)             --         
      *--            I_MTR_SEAL_CODE_ID         CHAR(01)             --         
      *--            I_MTR_MIN_NO_UNITS         DECIMAL(9,0)         --         
      *--            I_MTR_MAX_NO_UNITS         DECIMAL(9,0)         --         
      *--            I_MTR_LOCK_TYPE_ID         CHAR(01)             --         
      *--            I_MTR_REGISTER_RD_SEQ      INTEGER              --         
      *--            I_MTR_IDR_RECIPIENT_CD     CHAR(01)             --         
      *--            I_MTR_INDUST_BTU_ID        CHAR(01)             --         
      *--            I_MTR_GIS_MISMATCH_FL      CHAR(01)             --         
      *--            I_MTR_INSULATED_IND        CHAR(01)             --         
      *--            I_MTR_RGISTR01_DATA        VARCHAR(100)         --         
      *--            I_MTR_RGISTR02_DATA        VARCHAR(100)         --         
      *--            I_MTR_RGISTR03_DATA        VARCHAR(100)         --         
      *--            I_MTR_RGISTR04-DATA        VARCHAR(100)         --         
      *--            I_MTR_RGISTR05_DATA        VARCHAR(100)         --         
      *--            I_MTR_RGISTR06_DATA        VARCHAR(100)         --         
      *--            I_MTR_RGISTR07_DATA        VARCHAR(100)         --         
      *--                                                            --         
      *--      OUT                                                   --         
      *--            NONE                                            --         
      *--                                                            --         
      *--      INOUT                                                 --         
      *--            NONE                                            --         
      *--                                                            --         
      *--  RESULT SET                                                --         
      *--            RETURN_CODE             INTEGER                 --         
      *--            APPL_RETURN_CODE        INTEGER                 --         
      *--            BUS_RULE_ID             CHAR(10)                --         
      *--            BUS_RULE_RESULT_CD      CHAR(10)                --         
      *--            BUS_RULE_XREF_ID        CHAR(26)                --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                        MODIFICATION LOG                    --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
P00738*--  07-30-2013    MS93554     PROGRAM INTIALLY WRITTEN.       --         
A05065*--  10-06-2014    AW41078     FIXED TRANSACTION HISTORY FOR   --         
A05065*--                            REGISTER STATUS.  USE CODE_METER--         
A05065*--                            STATUS INSTEAD OF CODE_REG_     --         
A05065*--                            STATUS TO WRITE RECORD.         --         
A05136*--  04/07/2015    MJ13662     PROGRAM PUT BACK TO PROD VERSION--         
A05136*--                            ACT082                          --         
A05460*--  03/09/2016    SS7F226     REMOVED COMMA IN READ VALUES    --         
A05460*--                ACT086      OF REGISTER DETAILS WHILE INSRT --         
A05460*--                            INTO TRANSACTION HISTORY.       --         
      *----------------------------------------------------------------         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04644'.
MSQ017     COPY MFASQLM.
                                                                        
                                                                        
       01  WS-WORKING-STORAGE.                                          
           05 WS-SQLSTATE                 PIC X(05) VALUE SPACES.       
                                                                        
       01  WS-SWITCHES.                                                 
           05 ALL-DONE-SW                 PIC X(01) VALUE 'N'.          
              88 NOT-ALL-DONE             VALUE 'N'.                    
              88 ALL-DONE                 VALUE 'Y'.                    
           05 SEND-DONE-SW                PIC X(01) VALUE 'Y'.          
              88 SEND-DONE-ERROR          VALUE 'N'.                    
              88 SEND-DONE-OK             VALUE 'Y'.                    
           05 WS-MTR-UPDT-ACTION-IND      PIC X(01) VALUE SPACES.       
              88 METER-UPDATE             VALUE 'U'.                    
              88 METER-DELETE             VALUE 'D'.                    
          05  WS-MSTDEP-REL-EXISTS-FL     PIC X(01) VALUE 'N'.          
              88 MSTDEP-REL-EXISTS        VALUE 'Y'.                    
          05  WS-ROW-EXIST                PIC X(01) VALUE 'N'.          
              88 ROW-EXIST                VALUE 'Y'.                    
              88 ROW-NOT-EXIST            VALUE 'N'.                    
          05  WS-DIAL-USAGE-TYPE          PIC X(01) VALUE SPACES.       
              88 DIAL-USAGE-TYPE          VALUE 'B','I','U','C'.        
                                                                        
       01 WS-REGISTER-DATA-INFO.                                        
          05 WS-REGISTER-DATA-LEN         PIC S9(4) COMP.               
          05 WS-REGISTER-DATA-TEXT        PIC X(100).                   
                                                                        
       01 WS-GENERAL-VARIABLE.                                          
          05 WS-MTR-APPL-PGM-ID           PIC X(08) VALUE SPACES.       
          05 WS-LAST-UPDATE-USERID        PIC X(07) VALUE SPACES.       
          05 WS-WHT-CROSS-CHECK           PIC X(01) VALUE SPACES.       
          05 WS-OLD-GIS-LOC-OFF           PIC X(03) VALUE SPACES.       
          05 WS-NEW-GIS-LOC-OFF           PIC X(03) VALUE SPACES.       
          05 WS-TIME-PRD-TXT              PIC X(04) VALUE SPACES.       
          05 WS-NO-READ-DIALS             PIC S9(04) USAGE COMP         
                                                    VALUE 0.            
          05 WS-CONSTANT                  PIC S9(06)V9(3)               
                                               USAGE COMP-3 VALUE 0.    
          05 WS-OLD-TAG-NM                PIC X(07) VALUE SPACES.       
          05 WS-NEW-TAG-NM                PIC X(07) VALUE SPACES.       
          05 WS-WHT-CROSS-UPDATE          PIC X(01) VALUE 'N'.          
          05 WS-RESP-AREA-ID              PIC X(03) VALUE SPACES.       
COB305    05 WS-GIS-POINT-ID        PIC S9(9) COMP-3 VALUE 0.             
          05 WS-CURRENT-DATE              PIC X(10) VALUE SPACES.       
          05 WS-PRMRY-REGSTR-DELETED      PIC X(01) VALUE 'N'.          
          05 WS-METER-PRESSURE            PIC X(03) VALUE SPACES.       
          05 WS-METER-PRESSURE-NUM REDEFINES WS-METER-PRESSURE          
                                          PIC 9(03).                    
          05 WS-DECIMAL-12V3-NUM          PIC S9(15).                   
          05 WS-DECIMAL-12V3-NUM-RED REDEFINES WS-DECIMAL-12V3-NUM      
                                          PIC S9(12)V9(3).              
      *                                                                         
          05 WS-LAST-VAL-RD-VALUE-TEXT    PIC X(15).                    
          05 WS-LAST-VAL-RD-VALUE-UNPACK                                
                            REDEFINES WS-LAST-VAL-RD-VALUE-TEXT         
                                          PIC 9(12)V9(3).               
ACT086    05 WS-LAST-VAL-RD-VALUE-TX-N    PIC 9(12).9(3).               
ACT086    05 WS-LAST-VAL-RD-VALUE-Z       PIC -Z(12).9(3).              
      *                                                                         
          05 WS-REG-USAGE-CODETIME-DESC   PIC X(51) VALUE SPACES.       
          05 WS-REG-USAGE-DESC            PIC X(35) VALUE SPACES.       
          05 WS-REG-CODETIME-DESC         PIC X(15) VALUE SPACES.       
      *                                                                         
          05 WS-LAST-READ-VALUE-TEXT         PIC X(15).                 
          05 WS-LAST-READ-VALUE-UNPACK                                  
                            REDEFINES WS-LAST-READ-VALUE-TEXT           
                                          PIC 9(12)V9(3).               
      *                                                                         
          05 WS-DIAL-VARIABLES-NUM.                                     
             10 WS-DIAL-NO-4-NUM          PIC 9999   VALUE 0.           
             10 WS-DIAL-NO-5-NUM          PIC 99999  VALUE 0.           
             10 WS-DIAL-NO-6-NUM          PIC 999999 VALUE 0.           
      *                                                                         
       01 WS-POINT-ID.                                                  
          05 WS-GIS-LOCAL-OFF             PIC X(3).                     
          05 WS-TAG-NUMBER                PIC X(7).                     
                                                                        
       01 WS-CODE-LONG-DESC.                                            
          05 WS-LONG-DESC-LEN             PIC S9(04) USAGE COMP.        
          05 WS-LONG-DESC-TEXT            PIC X(80)  VALUE SPACES.      
                                                                        
                                                                        
       01 WS-TRANS-COMMENTS.                                            
          05 WS-ENTITY-KEY-DESC.                                        
             10 FILLER                    PIC X(12)                     
                                          VALUE 'METER NO  - '.         
             10 WS-TRAN-METER-NO          PIC X(13).                    
             10 FILLER                    PIC X(15)                     
                                          VALUE 'REGISTER NO -  '.      
             10 WS-TRAN-REG-ID-NO         PIC 9(04).                    
          05 WS-METER-LEN                 PIC 9(04)  VALUE 25.          
          05 WS-REGISTER-LEN              PIC 9(04)  VALUE 44.          
          05 WS-COMMENT                   PIC X(210) VALUE SPACES.      
          05 WS-COMMENT-LEN               PIC S9(04) USAGE COMP.        
                                                                        
       01 WS-PREV-METER-FIELD.                                          
COB305    05 WS-PREV-GIS-POINT-ID        PIC S9(9) COMP-3 VALUE 0.            
COB305    05 WS-PREV-MTR-PRESSURE        PIC S9(9) COMP-3 VALUE 0.            
          05 WS-PREV-READ-SOURCE-CD       PIC X(01).                    
          05 WS-PREV-CODE-METER-LOC       PIC X(02).                    
          05 WS-PREV-REMOTE-READ-IND      PIC X(01).                    
          05 WS-PREV-METER-SUPPLYING      PIC X(15).                    
          05 WS-PREV-CODE-MTR-RD-INST1    PIC X(02).                    
          05 WS-PREV-UTILITY-SOURCE-CD    PIC X(01).                    
          05 WS-PREV-NO-CONSEC-ESTIMATE   PIC S9(04) USAGE COMP.        
          05 WS-PREV-DELIVERY-LEVEL-CD    PIC X(01).                    
          05 WS-PREV-SEAL-CODE-ID         PIC X(01).                    
COB305    05 WS-PREV-MIN-NO-UNITS        PIC S9(9)V USAGE COMP-3 
COB305       VALUE 0.      
COB305    05 WS-PREV-MAX-NO-UNITS        PIC S9(9)V USAGE COMP-3 
COB305       VALUE 0.      
          05 WS-PREV-LOCK-TYPE-ID         PIC X(01).                    
COB305    05 WS-PREV-REGISTER-RD-SEQ        PIC S9(09) COMP-3 VALUE 0.          
          05 WS-PREV-IDR-RECIPIENT-CD     PIC X(01).                    
          05 WS-PREV-INDUST-BTU-ID        PIC X(03).                    
          05 WS-PREV-GIS-MISMATCH-FL      PIC X(01).                    
          05 WS-PREV-INSULATED-IND        PIC X(01).                    
                                                                        
       01 WS-PREV-REGISTER-FILED.                                       
          05 WS-PREV-CODE-REG-STATUS      PIC X(01).                    
          05 WS-PREV-CODE-CRNT-REG-READ   PIC X(01).                    
          05 WS-PREV-CODE-NO-RD-REASON    PIC X(01).                    
          05 WS-PREV-CODE-STATUS-REAS     PIC X(01).                    
COB305    05 WS-PREV-LAST-VAL-RD-VALUE        PIC S9(12)V9(03) COMP-3 
COB305       VALUE 0.      
          05 WS-PREV-CODE-LAST-VALID-RD   PIC X(01).                    
          05 WS-PREV-LAST-VALID-READ-DT   PIC X(10).                    
          05 WS-PREV-LAST-VALID-READ-TM   PIC X(08).                    
COB305    05 WS-PREV-LAST-READ-VALUE        PIC S9(12)V9(03) COMP-3 
COB305       VALUE 0.      
          05 WS-PREV-CODE-LAST-REG-READ   PIC X(01).                    
          05 WS-PREV-LAST-REG-READ-DT     PIC X(10).                    
          05 WS-PREV-LAST-REG-READ-TM     PIC X(08).                    
                                                                        
       01 WS-MTR-REG-OPERATION-ID.                                      
          05 WS-METER-DETAILS             PIC X(01) VALUE SPACES.       
             88 METER-CHANGE                  VALUE 'Y'.                
          05 WS-REGISTER-READ-DETAILS     PIC X(01) VALUE SPACES.       
             88 REGISTER-READ-CHANGE          VALUE 'Y'.                
                                                                        
       01 WS-NULL-INDICATORS.                                           
          05 WS-NULL-IND-01               PIC S9(04) COMP.              
          05 WS-NULL-IND-02               PIC S9(04) COMP.              
          05 WS-NULL-IND-03               PIC S9(04) COMP.              
          05 WS-NULL-IND-04               PIC S9(04) COMP.              
          05 WS-NULL-IND-05               PIC S9(04) COMP.              
          05 WS-NULL-IND-06               PIC S9(04) COMP.              
          05 WS-NULL-IND-07               PIC S9(04) COMP.              
                                                                        
       01 WS-LITERALS.                                                  
          05 PROGRAM-NAME                 PIC X(08) VALUE 'CSR04644'.   
          05 WS-NO                        PIC X(01) VALUE 'N'.          
          05 WS-YES                       PIC X(01) VALUE 'Y'.          
          05 WS-YES-NULL                  PIC S9(04) VALUE -1.          
          05 WS-ZERO                      PIC 9(01) VALUE 0.            
          05 WS-ONE                       PIC 9(01) VALUE 1.            
          05 WS-FAILED                    PIC X(01) VALUE 'F'.          
          05 WS-ELECTRIC                  PIC X(01) VALUE 'E'.          
          05 WS-GAS                       PIC X(01) VALUE 'G'.          
          05 GTT-NAME                     PIC X(26)                     
                                          VALUE 'SESSION.CSR04644_R1'.  
                                                                        
       01 GTT-MISC-FIELDS.                                              
          05 GTT-ROW.                                                   
             49 GTT-ROW-LEN               PIC S9(04) COMP.              
             49 GTT-ROW-CHAR              PIC X(1024).                  
          05 GTT-SQLCODE                  PIC S9(9) COMP.               
                                                                        
       01 COUNTER-FIELDS.                                               
          05  CTR-COLUMN                  PIC S9(9) COMP VALUE 1.       
          05  CTR-ROWS                    PIC S9(9) COMP VALUE 0.       
                                                                        
       01 WORK-FIELDS.                                                  
          05  MAX-LENGTH-PARM             PIC S9(9) COMP.               
          05  WRKLEN1                     PIC S9(9) COMP.               
          05  WRKLEN2                     PIC S9(9) COMP.               
          05  WRK-DONE-STATUS             PIC S9(9) COMP.               
                                                                        
       01 GTT-RETURN-FIELDS.                                            
          05  S-RETURN-CODE               PIC S9(09) COMP VALUE 0.      
          05  S-APPL-RETURN-CODE          PIC S9(09) COMP VALUE 0.      
          05  S-BUS-RULE-ID               PIC X(10)  VALUE SPACES.      
          05  S-BUS-RULE-RESULT-CD        PIC X(08)  VALUE SPACES.      
          05  S-BUS-RULE-XREF-ID          PIC X(26)  VALUE SPACES.      
                                                                        
       01 WS-REGISTER-INFO-RG.                                          
          05 WS-REGISTER-DATA-RG OCCURS 7 TIMES                         
                                 INDEXED BY WS-RGSTER-RD-INDX.          
             10 WS-REG-UPDT-ACTN-IND          PIC X(01)                 
                                              VALUE SPACES.             
                88 REGISTER-UPDATE            VALUE 'U'.                
                88 REGISTER-DELETE            VALUE 'D'.                
             10 WS-REGISTER-KEY.                                        
                20 WS-REG-ID-NO               PIC S9(04).               
                20 WS-REG-CD-TIME-PRID        PIC S9(04).               
             10 WS-REG-CODE-REG-STATUS        PIC X(01).                
             10 WS-CODE-CRNT-REG-READ         PIC X(01).                
             10 WS-REG-CODE-NO-RD-REASON      PIC X(01).                
             10 WS-REG-MCODE-STATUS-REAS      PIC X(01).                
             10 WS-REG-LAST-VAL-RD-VALUE.                               
                15 WS-REG-LST-VAL-RD-VAL-SGN  PIC X(01).                
                15 WS-REG-LST-VAL-RD-VALUE    PIC X(15).                
             10 WS-REG-CODE-LAST-VALID-RD     PIC X(01).                
             10 WS-REG-LAST-VALID-READ-DT     PIC X(10).                
             10 WS-REG-LAST-VALID-READ-TM     PIC X(08).                
             10 WS-REG-LAST-READ-VALUE.                                 
                15 WS-REG-LAST-READ-VALUE-SGN PIC X(01).                
                15 WS-REG-LAST-READ-VALUE-VAL PIC X(15).                
             10 WS-REG-CODE-LAST-REG-READ     PIC X(01).                
             10 WS-REG-LAST-REG-READ-DT       PIC X(10).                
             10 WS-REG-LAST-REG-READ-TM       PIC X(08).                
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9) COMP VALUE 0.         
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.           
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.           
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.           
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_CNSMPTN_HIST     CX                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCNSMP                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_BTU_INDUST     FD                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBBTUIND                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_MTR_CAP        MC                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMTRCAP                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_MTRD_ENVRNMT     MN                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMTRENV                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_REGISTER_READ    RG                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRGREAD                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_MTR_USAGE_VALS S5                                      *         
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMTRVAL                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_PIM_POINT        PP                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBPIMPNT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_OP_AREA          QG                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBOPAREA                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_USER_PROFILE     PF                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_BUS_RULE         1R                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBBUSRUL                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_BUS_RULE_XREF    1T                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRULXRF                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ACCT_WHT_CROSS   WH                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBWCACCT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_MT_TRN_HST_DET   MI                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_MNT_TRANS_HIST   MH                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_UTL_BILL_REL     UR                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBUTLREL                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ACCOUNT          AT                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_SPCL_BILL_MSG    U1                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBSBLMSG                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_IRRGLR_MTR_RD    IM                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBIRMTRD                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_CODE_VALUE       UV                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCDVALU                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_NO_READ_REASON   S4                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBNORDRN                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    SQL ERROR CHECKING COPYBOOK.                                *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS TO XFER DATA.                                    *        
      ******************************************************************        
           COPY CCA00001.                                                       
                                                                        
      ******************************************************************        
      *    ERROR HANDLING COPY BOOK.                                   *        
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  CURSOR DECLARATIONS.                                          *        
      ******************************************************************        
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-APPL-PGM-ID                PIC X(08).                   
       01  PARM-USER-ID                    PIC X(07).                   
       01  PARM-OPERATION-ID               PIC X(02).                   
       01  PARM-MTR-UPDT-ACTN-IND          PIC X(01).                   
       01  PARM-MTR-ACCOUNT-NO             PIC X(13).                   
       01  PARM-MTR-CODE-UTIL-TYPE         PIC X(01).                   
       01  PARM-MTR-IC-NO                  PIC S9(4) USAGE COMP.        
       01  PARM-METER-NO                   PIC X(09).                   
       01  PARM-MTR-REF-NO                 PIC S9(4) USAGE COMP.        
       01  PARM-MTR-POINT-ID               PIC X(10).                   
       01  PARM-MTR-PRESSURE               PIC X(03).                   
       01  PARM-MTR-READ-SOURCE-CD         PIC X(01).                   
       01  PARM-MTR-CODE-METER-LOC         PIC X(02).                   
       01  PARM-MTR-REMOTE-READ-IND        PIC X(01).                   
       01  PARM-MTR-METER-SUPPLYING        PIC X(15).                   
       01  PARM-MTR-CODE-MTR-RD-INST1      PIC X(02).                   
       01  PARM-MTR-UTILITY-SOURCE-CD      PIC X(01).                   
       01  PARM-MTR-NO-CONSEC-ESTIMATE     PIC S9(04) USAGE COMP.       
       01  PARM-MTR-DELIVERY-LEVEL-CD      PIC X(01).                   
       01  PARM-MTR-SEAL-CODE-ID           PIC X(01).                   
COB305 01 PARM-MTR-MIN-NO-UNITS        PIC S9(9)V USAGE COMP-3 VALUE 0.     
COB305 01 PARM-MTR-MAX-NO-UNITS        PIC S9(9)V USAGE COMP-3 VALUE 0.     
       01  PARM-MTR-LOCK-TYPE-ID           PIC X(01).                   
       01  PARM-MTR-REGISTER-RD-SEQ        PIC S9(09) USAGE COMP.       
       01  PARM-MTR-IDR-RECIPIENT-CD       PIC X(01).                   
       01  PARM-MTR-INDUST-BTU-ID          PIC X(03).                   
       01  PARM-MTR-GIS-MISMATCH-FLAG      PIC X(01).                   
       01  PARM-MTR-INSULATED-IND          PIC X(01).                   
       01  PARM-MTR-RGISTR01-DATA          PIC X(100).                  
       01  PARM-MTR-RGISTR02-DATA          PIC X(100).                  
       01  PARM-MTR-RGISTR03-DATA          PIC X(100).                  
       01  PARM-MTR-RGISTR04-DATA          PIC X(100).                  
       01  PARM-MTR-RGISTR05-DATA          PIC X(100).                  
       01  PARM-MTR-RGISTR06-DATA          PIC X(100).                  
       01  PARM-MTR-RGISTR07-DATA          PIC X(100).                  
       01  PARM-COMMENT                    PIC X(210).                  
       01  PARM-COMMENT-LEN                PIC S9(04) USAGE COMP.       
                                                                        
       PROCEDURE DIVISION  USING PARM-APPL-PGM-ID                       
                                 PARM-USER-ID                           
                                 PARM-OPERATION-ID                      
                                 PARM-MTR-UPDT-ACTN-IND                 
                                 PARM-MTR-ACCOUNT-NO                    
                                 PARM-MTR-CODE-UTIL-TYPE                
                                 PARM-MTR-IC-NO                         
                                 PARM-METER-NO                          
                                 PARM-MTR-REF-NO                        
                                 PARM-MTR-POINT-ID                      
                                 PARM-MTR-PRESSURE                      
                                 PARM-MTR-READ-SOURCE-CD                
                                 PARM-MTR-CODE-METER-LOC                
                                 PARM-MTR-REMOTE-READ-IND               
                                 PARM-MTR-METER-SUPPLYING               
                                 PARM-MTR-CODE-MTR-RD-INST1             
                                 PARM-MTR-UTILITY-SOURCE-CD             
                                 PARM-MTR-NO-CONSEC-ESTIMATE            
                                 PARM-MTR-DELIVERY-LEVEL-CD             
                                 PARM-MTR-SEAL-CODE-ID                  
                                 PARM-MTR-MIN-NO-UNITS                  
                                 PARM-MTR-MAX-NO-UNITS                  
                                 PARM-MTR-LOCK-TYPE-ID                  
                                 PARM-MTR-REGISTER-RD-SEQ               
                                 PARM-MTR-IDR-RECIPIENT-CD              
                                 PARM-MTR-INDUST-BTU-ID                 
                                 PARM-MTR-GIS-MISMATCH-FLAG             
                                 PARM-MTR-INSULATED-IND                 
                                 PARM-MTR-RGISTR01-DATA                 
                                 PARM-MTR-RGISTR02-DATA                 
                                 PARM-MTR-RGISTR03-DATA                 
                                 PARM-MTR-RGISTR04-DATA                 
                                 PARM-MTR-RGISTR05-DATA                 
                                 PARM-MTR-RGISTR06-DATA                 
                                 PARM-MTR-RGISTR07-DATA                 
                                 PARM-COMMENT                           
                                 PARM-COMMENT-LEN.                      
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0000-MAINLINE.                                                 *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE             THRU 0100-EXIT.          
           PERFORM 1000-PROCESS-INPUT          THRU 1000-EXIT.          
           PERFORM 2000-PROCESS-OUTPUT         THRU 2000-EXIT.          
           PERFORM 9999-END-PROGRAM            THRU 9999-EXIT.          
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           EXEC SQL                                                     
              DECLARE C1 CURSOR  FOR                         
              SELECT :S-RETURN-CODE           AS RETURN_CODE            
                    ,:S-APPL-RETURN-CODE      AS APPL_RETURN_CODE       
                    ,:S-BUS-RULE-ID           AS BUS_RULE_ID            
                    ,:S-BUS-RULE-RESULT-CD    AS BUS_RULE_RESULT_CD     
                    ,:S-BUS-RULE-XREF-ID      AS BUS_RULE_XREF_ID       
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN FOR                                 
MFA-TR*       SELECT :S-RETURN-CODE           AS RETURN_CODE                    
MFA-TR*             ,:S-APPL-RETURN-CODE      AS APPL_RETURN_CODE               
MFA-TR*             ,:S-BUS-RULE-ID           AS BUS_RULE_ID                    
MFA-TR*             ,:S-BUS-RULE-RESULT-CD    AS BUS_RULE_RESULT_CD             
MFA-TR*             ,:S-BUS-RULE-XREF-ID      AS BUS_RULE_XREF_ID               
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-APPL-PGM-ID            TO WS-MTR-APPL-PGM-ID       
           MOVE PARM-USER-ID                TO WS-LAST-UPDATE-USERID    
           MOVE PARM-OPERATION-ID           TO WS-MTR-REG-OPERATION-ID  
           MOVE PARM-MTR-UPDT-ACTN-IND      TO WS-MTR-UPDT-ACTION-IND   
                                                                        
           MOVE PARM-MTR-ACCOUNT-NO         TO MN-ACCOUNT-NO            
                                               RG-ACCOUNT-NO            
                                               CX-ACCOUNT-NO            
                                               AT-ACCOUNT-NO.           
           MOVE PARM-MTR-CODE-UTIL-TYPE     TO MN-CODE-UTIL-TYPE        
                                               RG-CODE-UTIL-TYPE        
                                               CX-CODE-UTIL-TYPE        
                                               MC-CODE-UTIL-TYPE.       
           MOVE PARM-MTR-IC-NO              TO MN-IC-NO                 
                                               RG-IC-NO                 
                                               CX-IC-NO.                
           MOVE PARM-METER-NO               TO MN-METER-NO              
                                               RG-METER-NO              
                                               CX-METER-NO              
                                               MC-METER-NO              
                                               WS-TRAN-METER-NO.        
           MOVE PARM-MTR-REF-NO             TO MN-MTR-REF-NO            
                                               RG-MTR-REF-NO            
                                               CX-MTR-REF-NO.           
                                                                        
           MOVE PARM-MTR-POINT-ID           TO MN-POINT-ID              
           MOVE PARM-MTR-PRESSURE           TO WS-METER-PRESSURE        
           INSPECT WS-METER-PRESSURE                                    
                   REPLACING LEADING SPACES BY ZEROES.                  
           MOVE WS-METER-PRESSURE-NUM       TO MN-METER-PRESSURE        
           MOVE PARM-MTR-READ-SOURCE-CD     TO MN-MTR-READ-SOURCE-CD    
           MOVE PARM-MTR-CODE-METER-LOC     TO MN-CODE-METER-LOC        
           MOVE PARM-MTR-REMOTE-READ-IND    TO MN-REMOTE-READ-IND       
           MOVE PARM-MTR-METER-SUPPLYING    TO MN-METER-SUPPLYING       
           MOVE PARM-MTR-CODE-MTR-RD-INST1  TO MN-CODE-MTR-RD-INST1     
           MOVE PARM-MTR-UTILITY-SOURCE-CD  TO MN-UTILITY-SOURCE-CD     
           MOVE PARM-MTR-NO-CONSEC-ESTIMATE TO MN-NO-CONSEC-ESTIMATE    
           MOVE PARM-MTR-DELIVERY-LEVEL-CD  TO MN-DELIVERY-LEVEL-CD     
           MOVE PARM-MTR-SEAL-CODE-ID       TO MN-SEAL-CODE-ID          
           MOVE PARM-MTR-MIN-NO-UNITS       TO MN-MIN-NO-UNITS          
           MOVE PARM-MTR-MAX-NO-UNITS       TO MN-MAX-NO-UNITS          
           MOVE PARM-MTR-LOCK-TYPE-ID       TO MN-LOCK-TYPE-ID          
           MOVE PARM-MTR-REGISTER-RD-SEQ    TO MN-REGISTER-RD-SEQ       
           MOVE PARM-MTR-IDR-RECIPIENT-CD   TO MN-IDR-RECIPIENT-CD      
           MOVE PARM-MTR-INDUST-BTU-ID      TO MN-INDUST-BTU-ID         
           MOVE PARM-MTR-GIS-MISMATCH-FLAG  TO MN-GIS-MISMATCH-FL       
           MOVE PARM-MTR-INSULATED-IND      TO MN-INSULATED-IND         
                                                                        
           MOVE PARM-MTR-RGISTR01-DATA      TO WS-REGISTER-DATA-INFO    
           MOVE WS-REGISTER-DATA-TEXT       TO WS-REGISTER-DATA-RG(01)  
                                                                        
           MOVE PARM-MTR-RGISTR02-DATA      TO WS-REGISTER-DATA-INFO    
           MOVE WS-REGISTER-DATA-TEXT       TO WS-REGISTER-DATA-RG(02)  
                                                                        
           MOVE PARM-MTR-RGISTR03-DATA      TO WS-REGISTER-DATA-INFO    
           MOVE WS-REGISTER-DATA-TEXT       TO WS-REGISTER-DATA-RG(03)  
                                                                        
           MOVE PARM-MTR-RGISTR04-DATA      TO WS-REGISTER-DATA-INFO    
           MOVE WS-REGISTER-DATA-TEXT       TO WS-REGISTER-DATA-RG(04)  
                                                                        
           MOVE PARM-MTR-RGISTR05-DATA      TO WS-REGISTER-DATA-INFO    
           MOVE WS-REGISTER-DATA-TEXT       TO WS-REGISTER-DATA-RG(05)  
                                                                        
           MOVE PARM-MTR-RGISTR06-DATA      TO WS-REGISTER-DATA-INFO    
           MOVE WS-REGISTER-DATA-TEXT       TO WS-REGISTER-DATA-RG(06)  
                                                                        
           MOVE PARM-MTR-RGISTR07-DATA      TO WS-REGISTER-DATA-INFO    
           MOVE WS-REGISTER-DATA-TEXT       TO WS-REGISTER-DATA-RG(07)  
                                                                        
           MOVE PARM-COMMENT                TO WS-COMMENT               
           MOVE PARM-COMMENT-LEN            TO WS-COMMENT-LEN           
      *    VAIDATE THE POINT ID THAT COMES FROM METER SCREEN, IF                
      *    GIS POINT CODE IS INVALID,THEN RETURN A ERROR MESSAGE                
      *    TO USER.                                                             
           IF MN-CODE-UTIL-TYPE EQUAL WS-ELECTRIC AND                   
              METER-CHANGE AND METER-UPDATE                             
              PERFORM 1100-VALIDATE-INPUT      THRU 1100-EXIT           
           END-IF.                                                      
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 1100-VALIDATE-INPUT.                                           *        
      ******************************************************************        
       1100-VALIDATE-INPUT.                                             
                                                                        
           MOVE MN-POINT-ID                 TO WS-POINT-ID.             
           MOVE WS-GIS-LOCAL-OFF            TO PP-AREA-ID               
           MOVE WS-TAG-NUMBER               TO PP-TAG-NM                
           PERFORM 7000-GET-NEW-GIS-POINT-ID   THRU 7000-EXIT.          
           MOVE PP-POINT-ID                 TO MN-GIS-POINT-ID.         
                                                                        
           IF MN-GIS-POINT-ID LESS THAN WS-ONE                          
              MOVE 'MRM0000004'             TO S-BUS-RULE-ID            
              MOVE WS-FAILED                TO S-BUS-RULE-RESULT-CD     
              IF S-BUS-RULE-ID GREATER THAN SPACES                      
                 PERFORM 7020-GET-RULE-XREF-ID THRU 7020-EXIT           
              END-IF                                                    
              MOVE 100                      TO S-APPL-RETURN-CODE       
              PERFORM 8005-SEND-RESULT         THRU 8005-EXIT           
              PERFORM 9999-END-PROGRAM         THRU 9999-EXIT           
           END-IF.                                                      
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 7250-SELECT-ACCT-DET           THRU 7250-EXIT.       
           MOVE AT-COMPANY-NO               TO MC-COMPANY-NO.           
           MOVE '01'                        TO UV-COMPANY-NO.           
                                                                        
      *    FOR METER SCREEN                                                     
           IF METER-CHANGE                                              
              EVALUATE TRUE                                             
              WHEN METER-UPDATE                                         
                   PERFORM 2100-UPDT-PRCS-FOR-METER   THRU 2100-EXIT    
              WHEN METER-DELETE                                         
      *            DELETE CAN PERFORM WHEN METER STATUS IS REMOVED.             
                   PERFORM 2200-DEL-PRCS-FOR-METER    THRU 2200-EXIT    
              END-EVALUATE                                              
           END-IF.                                                      
                                                                        
      *    FOR REGISTER READ SCREEN                                             
           IF REGISTER-READ-CHANGE                                      
              PERFORM 2300-UPDT-PRCS-FOR-RGSTER       THRU 2300-EXIT    
           END-IF.                                                      
                                                                        
           PERFORM 8005-SEND-RESULT                   THRU 8005-EXIT.   
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2100-UPDT-PRCS-FOR-METER.                                      *        
      ******************************************************************        
       2100-UPDT-PRCS-FOR-METER.                                        
                                                                        
           PERFORM 7005-SELECT-MTRD-ENVRNMT      THRU 7005-EXIT.        
           MOVE MN-REG-ID-NO                  TO WS-TRAN-REG-ID-NO.     
           PERFORM 5000-WRITE-TRANS-HIST         THRU 5000-EXIT.        
           PERFORM 2115-UPDT-MTRD-ENVRNMT        THRU 2115-EXIT.        
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2105-GET-DIAL-CONSTANT.                                        *        
      ******************************************************************        
       2105-GET-DIAL-CONSTANT.                                          
                                                                        
           PERFORM 7105-GET-METER-CAP-DETAILS     THRU 7105-EXIT        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE MC-CONSTANT                 TO WS-CONSTANT           
              MOVE MC-NO-READ-DIALS            TO WS-NO-READ-DIALS      
           ELSE                                                         
              PERFORM 7110-GET-DET-CONSUMP-HIST   THRU 7110-EXIT        
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                 MOVE CX-CONSTANT              TO WS-CONSTANT           
                 MOVE CX-NO-DIALS              TO WS-NO-READ-DIALS      
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2105-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2110-CHK-PCOMP-BILL-MSG.                                       *        
      ******************************************************************        
       2110-CHK-PCOMP-BILL-MSG.                                         
                                                                        
           IF WS-PREV-MTR-PRESSURE GREATER THAN WS-ZERO AND             
              MN-METER-PRESSURE    GREATER THAN WS-ZERO                 
              CONTINUE                                                  
           ELSE                                                         
              MOVE MN-ACCOUNT-NO            TO AT-ACCOUNT-NO            
                                               U1-ACCOUNT-NO            
              PERFORM 7250-SELECT-ACCT-DET     THRU 7250-EXIT           
                                                                        
      *       NEW ACCOUNTS DO NOT NEED THE MESSAGE.                             
      *       P COMP BILL MESSAGE ID = 95079                                    
              IF AT-REV-MTH-LST-NRML > 0                                
                 MOVE '95079'               TO U1-BILL-MSG-ID           
                 MOVE 'M'                   TO U1-MSG-TYPE-CD           
                 MOVE AT-COMPANY-NO         TO U1-COMPANY-NO            
                 COMPUTE U1-REVENUE-MO-END = AT-REV-MTH-LST-NRML + 1    
                                                                        
      *          DELETE IF THE MESSAGE EXISTS, IF PRESSURE IS                   
      *          CHANGED TO ZEROS                                               
                 IF WS-PREV-MTR-PRESSURE GREATER THAN WS-ZERO AND       
                    MN-METER-PRESSURE EQUAL WS-ZERO                     
                    PERFORM 8090-DELETE-BILL-MSG                        
                                               THRU 8090-EXIT           
                 ELSE                                                   
      *             INSERT THE BILL MESSAGE, IF PRESSURE IS                     
      *             CHANGED TO > ZEROS                                          
                    IF WS-PREV-MTR-PRESSURE EQUAL WS-ZERO AND           
                       MN-METER-PRESSURE GREATER THAN WS-ZERO           
                       MOVE 1               TO U1-BILL-CYCLE-ST         
                       MOVE 21              TO U1-BILL-CYCLE-END        
                       MOVE U1-REVENUE-MO-END                           
                                            TO U1-REVENUE-MO-ST         
                       PERFORM 8095-INSERT-BILL-MSG                     
                                               THRU 8095-EXIT           
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2115-UPDT-MTRD-ENVRNMT.                                        *        
      ******************************************************************        
       2115-UPDT-MTRD-ENVRNMT.                                          
                                                                        
           PERFORM 8000-UPDATE-MTRD-ENVRNMT        THRU 8000-EXIT.      
                                                                        
      *    CHECK IF ANY ROW EXIST IN CSS_ACCT_WHT_CROSS EXISTING                
      *    ACCOUNT NO AND OLD GIS-POINT-ID.                                     
           IF WS-WHT-CROSS-CHECK EQUAL WS-YES                           
              MOVE MN-ACCOUNT-NO            TO WH-ACCOUNT-NO            
              MOVE WS-PREV-GIS-POINT-ID     TO WH-GIS-POINT-ID          
              PERFORM 7030-SELECT-ACCT-WHT-CROSS   THRU 7030-EXIT       
              IF WS-WHT-CROSS-UPDATE EQUAL WS-YES                       
                 MOVE MN-GIS-POINT-ID       TO WH-GIS-POINT-ID          
                 PERFORM 8010-UPDATE-ACCT-WHT-CROSS THRU 8010-EXIT      
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2115-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2200-DEL-PRCS-FOR-METER.                                       *        
      ******************************************************************        
       2200-DEL-PRCS-FOR-METER.                                         
                                                                        
           MOVE MN-ACCOUNT-NO               TO UR-ACCOUNT-NO-MST        
                                               UR-ACCOUNT-NO-DEP        
                                               IM-ACCOUNT-NO.           
           MOVE MN-CODE-UTIL-TYPE           TO UR-CODE-UTIL-TYPE-MST    
                                               UR-CODE-UTIL-TYPE-DEP    
                                               IM-CODE-UTIL-TYPE.       
           MOVE MN-IC-NO                    TO UR-IC-NO-MST             
                                               UR-IC-NO-DEP             
                                               IM-IC-NO.                
           MOVE MN-MTR-REF-NO               TO UR-MTR-REF-NO-MST        
                                               UR-MTR-REF-NO-DEP        
                                               IM-METER-REF-NO.         
           MOVE MN-CODE-TIME-PERIOD         TO RG-CODE-TIME-PERIOD.     
                                                                        
      *    CHECK IF ANY ROW EXIST IN CSS_UTL_BILL_REL TABLE WHERE               
      *    ACCOUNT AND METER IS A DEPENDENT                                     
           PERFORM 7040-CHECK-DEP-UTL-BILL-REL THRU 7040-EXIT           
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              PERFORM 7050-CHECK-MST-UTL-BILL-REL                       
                                               THRU 7050-EXIT           
           END-IF                                                       
                                                                        
           IF MSTDEP-REL-EXISTS                                         
              MOVE 'MRM0000005'             TO S-BUS-RULE-ID            
              MOVE WS-FAILED                TO S-BUS-RULE-RESULT-CD     
              IF S-BUS-RULE-ID GREATER THAN SPACES                      
                 PERFORM 7020-GET-RULE-XREF-ID THRU 7020-EXIT           
              END-IF                                                    
              MOVE 100                      TO S-APPL-RETURN-CODE       
              PERFORM 8005-SEND-RESULT         THRU 8005-EXIT           
              PERFORM 9999-END-PROGRAM         THRU 9999-EXIT           
           END-IF                                                       
                                                                        
           PERFORM 7005-SELECT-MTRD-ENVRNMT    THRU 7005-EXIT.          
           MOVE MN-REG-ID-NO                TO WS-TRAN-REG-ID-NO.       
                                                                        
           PERFORM 5000-WRITE-TRANS-HIST       THRU 5000-EXIT.          
                                                                        
           PERFORM 8020-DELETE-IRRGLR-MTR-RD   THRU 8020-EXIT.          
           PERFORM 8030-DELETE-REGISTER-READ   THRU 8030-EXIT.          
           PERFORM 8040-DELETE-MTRD-ENVRNMT    THRU 8040-EXIT.          
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2300-UPDT-PRCS-FOR-RGSTER.                                     *        
      ******************************************************************        
       2300-UPDT-PRCS-FOR-RGSTER.                                       
                                                                        
           PERFORM VARYING WS-RGSTER-RD-INDX FROM 1 BY 1                
SCA006                     UNTIL WS-PRMRY-REGSTR-DELETED EQUAL WS-YES OR 
                                 WS-RGSTER-RD-INDX > 7 OR 
                                 
                   WS-REG-ID-NO(WS-RGSTER-RD-INDX) EQUAL SPACES                
                                                                        
              EVALUATE TRUE                                             
              WHEN REGISTER-UPDATE(WS-RGSTER-RD-INDX)                   
                   PERFORM 6000-MOVE-REGISTER-RD     THRU 6000-EXIT     
                   PERFORM 2105-GET-DIAL-CONSTANT    THRU 2105-EXIT     
                   PERFORM 2310-UPDATE-REGISTER-READ THRU 2310-EXIT     
              WHEN REGISTER-DELETE(WS-RGSTER-RD-INDX)                   
                   PERFORM 6000-MOVE-REGISTER-RD     THRU 6000-EXIT     
                   PERFORM 2105-GET-DIAL-CONSTANT    THRU 2105-EXIT     
                   PERFORM 2320-DELETE-REGISTER-READ THRU 2320-EXIT     
              END-EVALUATE                                              
                                                                        
           END-PERFORM.                                                 
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2310-UPDATE-REGISTER-READ.                                     *        
      ******************************************************************        
       2310-UPDATE-REGISTER-READ.                                       
                                                                        
           PERFORM 7100-GET-REGISTER-READ      THRU 7100-EXIT           
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE RG-CODE-USAGE-TYPE       TO WS-DIAL-USAGE-TYPE       
      *                                                                         
              MOVE RG-CODE-USAGE-ID         TO S5-CODE-USAGE-ID         
              MOVE RG-CODE-USAGE-TYPE       TO S5-CODE-USAGE-TYPE       
              MOVE RG-CODE-USAGE-SOURCE     TO S5-CODE-USAGE-SOURCE     
              PERFORM 7120-GET-MTR-USAGE-DESC  THRU 7120-EXIT           
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                 MOVE S5-METER-USAGE-DESC   TO WS-REG-USAGE-DESC        
              ELSE                                                      
                 MOVE WS-TRAN-REG-ID-NO     TO WS-REG-USAGE-DESC        
              END-IF                                                    
      *                                                                         
              PERFORM 5100-WRITE-TRANS-HIST    THRU 5100-EXIT           
              PERFORM 8050-UPDATE-REG-READ     THRU 8050-EXIT           
           ELSE                                                         
      *       PRIMARY METER REGISTER DETAILS WILL NOT BE PRESENT                
      *       IN CSS_REGISTER_READ TABLE SO WE NEED TO UPDATE IT                
      *       IN CSS_MTRD_ENVRNMT TABLE,WHEN UPDATE COME THROUGH                
      *       REGISTER READ SCREEN.                                             
              PERFORM 7200-GET-REG-DET-FRM-MTRD-TB                      
                                               THRU 7200-EXIT           
              MOVE MN-CODE-USAGE-TYPE       TO WS-DIAL-USAGE-TYPE       
                                                                        
      *                                                                         
              MOVE MN-CODE-USAGE-ID         TO S5-CODE-USAGE-ID         
              MOVE MN-CODE-USAGE-TYPE       TO S5-CODE-USAGE-TYPE       
              MOVE MN-CODE-USAGE-SOURCE     TO S5-CODE-USAGE-SOURCE     
              PERFORM 7120-GET-MTR-USAGE-DESC  THRU 7120-EXIT           
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                 MOVE S5-METER-USAGE-DESC   TO WS-REG-USAGE-DESC        
              ELSE                                                      
                 MOVE WS-TRAN-REG-ID-NO     TO WS-REG-USAGE-DESC        
              END-IF                                                    
      *                                                                         
              PERFORM 5200-WRITE-TRANS-HIST    THRU 5200-EXIT           
              PERFORM 6100-MOVE-REG-TO-MTRD    THRU 6100-EXIT           
              PERFORM 8080-UPDATE-MTRD-ENVRNMT THRU 8080-EXIT           
           END-IF.                                                      
                                                                        
       2310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2320-DELETE-REGISTER-READ.                                     *        
      ******************************************************************        
       2320-DELETE-REGISTER-READ.                                       
                                                                        
           PERFORM 7100-GET-REGISTER-READ      THRU 7100-EXIT           
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              PERFORM 5100-WRITE-TRANS-HIST    THRU 5100-EXIT           
              PERFORM 8060-DELETE-REG-READ     THRU 8060-EXIT           
      *       CODE_DATA_PRESENT = 'A' MEANS, METER HAS ADDITIONAL               
      *       REGISTERS. IF THERE IS NO ADDITIONAL METER REGISTER THEN          
      *       RE-SET THE VALUE AS SPCAES IN CSS_MTRD_ENVRNMT TABLE.             
              PERFORM 7060-CHK-ROW-EXIST       THRU 7060-EXIT           
              IF ROW-NOT-EXIST                                          
                 MOVE SPACE                 TO MN-CODE-DATA-PRESENT     
                 PERFORM 8070-UPDATE-DATA-PRSNT THRU 8070-EXIT          
              END-IF                                                    
           ELSE                                                         
      *       PRIMARY METER REGISTER DETAILS WILL NOT BE PRESENT                
      *       IN CSS_REGISTER_READ TABLE SO WE NEED TO DELETE IT                
      *       IN CSS_MTRD_ENVRNMT TABLE,WHEN DELETE COME THROUGH                
      *       REGISTER READ SCREEN.                                             
              PERFORM 7200-GET-REG-DET-FRM-MTRD-TB                      
                                               THRU 7200-EXIT           
              MOVE MN-CODE-USAGE-TYPE       TO WS-DIAL-USAGE-TYPE       
              PERFORM 5200-WRITE-TRANS-HIST    THRU 5200-EXIT           
              PERFORM 2330-DEL-PRCS-FOR-REG-MTR                         
                                               THRU 2330-EXIT           
      *       IF WE ARE DELETING PRIMARY REGISTER FROM REGISTER SCREEN          
      *       NO NEED TO DELETE ADDITIONAL REGISTER. BECAUSE IT IS              
      *       DEPENDENT TABLE OF CSS_MTRD_ENVRNMT.                              
              MOVE WS-YES                   TO WS-PRMRY-REGSTR-DELETED  
           END-IF.                                                      
                                                                        
       2320-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * DELETE PROCESS FOR PRIMARY REGISTER WHICH IS PRESENT IN MTR TAB*        
      * CSS_MTRD_ENVRNMT.                                              *        
      * 2330-DEL-PRCS-FOR-REG-MTR.                                     *        
      ******************************************************************        
       2330-DEL-PRCS-FOR-REG-MTR.                                       
                                                                        
           MOVE MN-ACCOUNT-NO               TO UR-ACCOUNT-NO-MST        
                                               UR-ACCOUNT-NO-DEP        
                                               IM-ACCOUNT-NO.           
           MOVE MN-CODE-UTIL-TYPE           TO UR-CODE-UTIL-TYPE-MST    
                                               UR-CODE-UTIL-TYPE-DEP    
                                               IM-CODE-UTIL-TYPE.       
           MOVE MN-IC-NO                    TO UR-IC-NO-MST             
                                               UR-IC-NO-DEP             
                                               IM-IC-NO.                
           MOVE MN-MTR-REF-NO               TO UR-MTR-REF-NO-MST        
                                               UR-MTR-REF-NO-DEP        
                                               IM-METER-REF-NO.         
           MOVE MN-REG-ID-NO                TO RG-REG-ID-NO             
                                               WS-TRAN-REG-ID-NO.       
           MOVE MN-CODE-TIME-PERIOD         TO RG-CODE-TIME-PERIOD.     
                                                                        
      *    CHECK IF ANY ROW EXIST IN CSS_UTL_BILL_REL TABLE WHERE               
      *    ACCOUNT AND METER IS A DEPENDENT.                                    
           PERFORM 7040-CHECK-DEP-UTL-BILL-REL THRU 7040-EXIT           
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              PERFORM 7050-CHECK-MST-UTL-BILL-REL                       
                                               THRU 7050-EXIT           
           END-IF                                                       
                                                                        
           IF MSTDEP-REL-EXISTS                                         
              MOVE 'MRM00000005'            TO S-BUS-RULE-ID            
              MOVE WS-FAILED                TO S-BUS-RULE-RESULT-CD     
              IF S-BUS-RULE-ID GREATER THAN SPACES                      
                 PERFORM 7020-GET-RULE-XREF-ID THRU 7020-EXIT           
              END-IF                                                    
              MOVE 100                      TO S-APPL-RETURN-CODE       
              PERFORM 8005-SEND-RESULT         THRU 8005-EXIT           
              PERFORM 9999-END-PROGRAM         THRU 9999-EXIT           
           END-IF                                                       
                                                                        
           PERFORM 8020-DELETE-IRRGLR-MTR-RD   THRU 8020-EXIT.          
           PERFORM 8030-DELETE-REGISTER-READ   THRU 8030-EXIT.          
           PERFORM 8040-DELETE-MTRD-ENVRNMT    THRU 8040-EXIT.          
                                                                        
       2330-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 5000-WRITE-TRANS-HIST.                                         *        
      ******************************************************************        
       5000-WRITE-TRANS-HIST.                                           
                                                                        
           PERFORM 7010-GET-CURR-TIMESTAMP     THRU 7010-EXIT.          
           PERFORM 7015-GET-RESP-AREA-ID       THRU 7015-EXIT.          
                                                                        
      *    WRITE A TRANSACTION HISTORY FOR THE HEADER ROW                       
           MOVE 'F'                         TO MH-CODE-TRAN-TYPE.       
           MOVE WS-RESP-AREA-ID             TO MH-RESP-AREA-ID.         
           MOVE MN-ACCOUNT-NO               TO MH-ACCOUNT-NO.           
           MOVE WS-ZERO                     TO MH-CUSTOMER-NO.          
           MOVE WS-ZERO                     TO MH-PREMISE-NO.           
           MOVE WS-LAST-UPDATE-USERID       TO MH-USER-ID.              
           MOVE 'CSR04644M'                 TO MH-APPL-PROGRAM-ID.      
           MOVE WS-ENTITY-KEY-DESC          TO MH-ENTITY-KEY-DESC-TEXT. 
           MOVE WS-REGISTER-LEN             TO MH-ENTITY-KEY-DESC-LEN.  
                                                                        
           MOVE WS-COMMENT-LEN              TO MH-TRAN-COMMENT-LEN.     
           MOVE WS-COMMENT                  TO MH-TRAN-COMMENT-TEXT     
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO        TO MI-TRANS-HIST-SEQ-NO.    
           MOVE 1                           TO MI-TRAN-APPL-NO.         
                                                                        
      * WRITING METER NO IN TRAN HIST DETAIL                                    
           MOVE +13                         TO MI-PRV-COLUMN-VALUE-LEN  
                                               MI-CHG-COLUMN-VALUE-LEN. 
                                                                        
           MOVE WS-TRAN-METER-NO            TO MI-PRV-COLUMN-VALUE-TEXT 
                                               MI-CHG-COLUMN-VALUE-TEXT.
           IF METER-DELETE THEN                                         
              MOVE +08                      TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE '*DELETED'               TO MI-CHG-COLUMN-VALUE-TEXT 
           END-IF.                                                      
                                                                        
           MOVE 'METER NO'                  TO MI-COLUMN-DESC.          
           MOVE SPACES                      TO MI-TABLE-ID.             
           PERFORM 6530-LOAD-MNT-TRANS-HIST       THRU 6530-EXIT.       
           ADD +1                           TO MI-TRAN-APPL-NO.         
      * METER  NUMBER ENDS HERE                                                 
                                                                        
      *    WRITE A TRANSACTION HISTORY DETAIL ROW                               
           IF (( MN-GIS-POINT-ID NOT EQUAL WS-PREV-GIS-POINT-ID) OR     
               ( METER-DELETE ))                                        
              AND MN-CODE-UTIL-TYPE EQUAL WS-ELECTRIC                   
              MOVE SPACES                   TO MI-TABLE-ID              
              MOVE 'Y'                      TO WS-WHT-CROSS-CHECK       
              MOVE WS-PREV-GIS-POINT-ID     TO WS-GIS-POINT-ID          
              PERFORM 7025-GET-OLD-GIS-TAG     THRU 7025-EXIT           
              MOVE PP-AREA-ID               TO WS-OLD-GIS-LOC-OFF       
              MOVE PP-TAG-NM                TO WS-OLD-TAG-NM            
                                                                        
              MOVE MN-GIS-POINT-ID          TO WS-GIS-POINT-ID          
              PERFORM 7025-GET-OLD-GIS-TAG     THRU 7025-EXIT           
              MOVE PP-AREA-ID               TO WS-NEW-GIS-LOC-OFF       
              MOVE PP-TAG-NM                TO WS-NEW-TAG-NM            
      *       GIS LOCAL OFFICE.                                                 
              IF METER-UPDATE                                           
                 MOVE +03                   TO MI-PRV-COLUMN-VALUE-LEN  
                                               MI-CHG-COLUMN-VALUE-LEN  
                 MOVE WS-OLD-GIS-LOC-OFF    TO MI-PRV-COLUMN-VALUE-TEXT 
                 MOVE WS-NEW-GIS-LOC-OFF    TO MI-CHG-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +03                   TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE +08                   TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE WS-OLD-GIS-LOC-OFF    TO MI-PRV-COLUMN-VALUE-TEXT 
                 MOVE '*DELETED'            TO MI-CHG-COLUMN-VALUE-TEXT 
              END-IF                                                    
              MOVE 'GIS-LOC-OFF'            TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD +1                        TO MI-TRAN-APPL-NO          
      *       TAG NUMBER                                                        
              IF METER-UPDATE                                           
                 MOVE +07                   TO MI-PRV-COLUMN-VALUE-LEN  
                                               MI-CHG-COLUMN-VALUE-LEN  
                 MOVE WS-OLD-TAG-NM         TO MI-PRV-COLUMN-VALUE-TEXT 
                 MOVE WS-NEW-TAG-NM         TO MI-CHG-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +07                   TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE +08                   TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE WS-OLD-TAG-NM         TO MI-PRV-COLUMN-VALUE-TEXT 
                 MOVE '*DELETED'            TO MI-CHG-COLUMN-VALUE-TEXT 
              END-IF                                                    
              MOVE 'TAG-NO'                 TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD +1                        TO MI-TRAN-APPL-NO          
      *       GIS POINT ID                                                      
              IF METER-UPDATE                                           
                 MOVE +09                  TO MI-PRV-COLUMN-VALUE-LEN   
                                              MI-CHG-COLUMN-VALUE-LEN   
                 MOVE WS-PREV-GIS-POINT-ID TO MI-PRV-COLUMN-VALUE-TEXT  
                 MOVE MN-GIS-POINT-ID      TO MI-CHG-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +09                  TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE +08                  TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE WS-PREV-GIS-POINT-ID TO MI-PRV-COLUMN-VALUE-TEXT  
                 MOVE '*DELETED'           TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'GIS-POINT-ID'          TO MI-COLUMN-DESC            
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD +1                       TO MI-TRAN-APPL-NO           
           END-IF.                                                      
                                                                        
           IF ((MN-METER-PRESSURE NOT EQUAL WS-PREV-MTR-PRESSURE) OR    
               ( METER-DELETE))                                         
              AND MN-CODE-UTIL-TYPE EQUAL WS-GAS                        
              PERFORM 2110-CHK-PCOMP-BILL-MSG THRU 2110-EXIT            
              IF METER-UPDATE                                           
                 MOVE +09                  TO MI-PRV-COLUMN-VALUE-LEN   
                                              MI-CHG-COLUMN-VALUE-LEN   
                 MOVE WS-PREV-MTR-PRESSURE TO MI-PRV-COLUMN-VALUE-TEXT  
                 MOVE MN-METER-PRESSURE    TO MI-CHG-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +09                  TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE +08                  TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE WS-PREV-MTR-PRESSURE TO MI-PRV-COLUMN-VALUE-TEXT  
                 MOVE '*DELETED'           TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'METER-PRESSURE'        TO MI-COLUMN-DESC            
              MOVE '25'                    TO MI-TABLE-ID               
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD +1                       TO MI-TRAN-APPL-NO           
           END-IF.                                                      
                                                                        
           IF ((MN-MTR-READ-SOURCE-CD NOT EQUAL WS-PREV-READ-SOURCE-CD) 
               OR (METER-DELETE))                                       
              IF METER-UPDATE                                           
                 MOVE +01                    TO MI-PRV-COLUMN-VALUE-LEN 
                                                MI-CHG-COLUMN-VALUE-LEN 
                 MOVE WS-PREV-READ-SOURCE-CD TO MI-PRV-COLUMN-VALUE-TEXT
                 MOVE MN-MTR-READ-SOURCE-CD  TO MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +01                    TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE +08                    TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE WS-PREV-READ-SOURCE-CD TO MI-PRV-COLUMN-VALUE-TEXT
                 MOVE '*DELETED'             TO MI-CHG-COLUMN-VALUE-TEXT
              END-IF                                                    
              MOVE 'MTR-READ-SOURCE'         TO MI-COLUMN-DESC          
              MOVE '24'                      TO MI-TABLE-ID             
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD +1                         TO MI-TRAN-APPL-NO         
           END-IF.                                                      
                                                                        
           IF ((MN-CODE-METER-LOC NOT EQUAL WS-PREV-CODE-METER-LOC) OR  
               (METER-DELETE))                                          
              IF METER-UPDATE                                           
                 MOVE +02                    TO MI-PRV-COLUMN-VALUE-LEN 
                                                MI-CHG-COLUMN-VALUE-LEN 
                 MOVE WS-PREV-CODE-METER-LOC TO MI-PRV-COLUMN-VALUE-TEXT
                 MOVE MN-CODE-METER-LOC      TO MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +02                    TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE +08                    TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE WS-PREV-CODE-METER-LOC TO MI-PRV-COLUMN-VALUE-TEXT
                 MOVE '*DELETED'             TO MI-CHG-COLUMN-VALUE-TEXT
              END-IF                                                    
              MOVE 'Q4'                      TO MI-TABLE-ID             
              MOVE 'CODE-METER-LOC'          TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD +1                         TO MI-TRAN-APPL-NO         
           END-IF.                                                      
                                                                        
           IF ((MN-REMOTE-READ-IND NOT EQUAL WS-PREV-REMOTE-READ-IND)   
               OR (METER-DELETE))                                       
              IF METER-UPDATE                                           
                 MOVE +01                    TO MI-PRV-COLUMN-VALUE-LEN 
                                                MI-CHG-COLUMN-VALUE-LEN 
                 MOVE WS-PREV-REMOTE-READ-IND                           
                                             TO MI-PRV-COLUMN-VALUE-TEXT
                 MOVE MN-REMOTE-READ-IND     TO MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +01                    TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE +08                    TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE WS-PREV-REMOTE-READ-IND                           
                                             TO MI-PRV-COLUMN-VALUE-TEXT
                 MOVE '*DELETED'             TO MI-CHG-COLUMN-VALUE-TEXT
              END-IF                                                    
              MOVE '69'                      TO MI-TABLE-ID             
              MOVE 'REMOTE-READ-IND'         TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD +1                         TO MI-TRAN-APPL-NO         
           END-IF.                                                      
                                                                        
           IF ((MN-METER-SUPPLYING NOT EQUAL WS-PREV-METER-SUPPLYING) OR
               (METER-DELETE))                                          
              IF METER-UPDATE                                           
                 MOVE +15                    TO MI-PRV-COLUMN-VALUE-LEN 
                                                MI-CHG-COLUMN-VALUE-LEN 
                 MOVE WS-PREV-METER-SUPPLYING                           
                                             TO MI-PRV-COLUMN-VALUE-TEXT
                 MOVE MN-METER-SUPPLYING     TO MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +15                    TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE +08                    TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE WS-PREV-METER-SUPPLYING                           
                                             TO MI-PRV-COLUMN-VALUE-TEXT
                 MOVE '*DELETED'             TO MI-CHG-COLUMN-VALUE-TEXT
              END-IF                                                    
              MOVE '25'                      TO MI-TABLE-ID             
              MOVE 'METER-SUPPLYING'         TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD +1                         TO MI-TRAN-APPL-NO         
           END-IF.                                                      
                                                                        
           IF((MN-CODE-MTR-RD-INST1 NOT EQUAL WS-PREV-CODE-MTR-RD-INST1)
             OR (METER-DELETE))                                         
              IF METER-UPDATE                                           
                 MOVE +02                    TO MI-PRV-COLUMN-VALUE-LEN 
                                                MI-CHG-COLUMN-VALUE-LEN 
                 MOVE WS-PREV-CODE-MTR-RD-INST1                         
                                             TO MI-PRV-COLUMN-VALUE-TEXT
                 MOVE MN-CODE-MTR-RD-INST1   TO MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +02                    TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE +08                    TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE WS-PREV-CODE-MTR-RD-INST1                         
                                             TO MI-PRV-COLUMN-VALUE-TEXT
                 MOVE '*DELETED'             TO MI-CHG-COLUMN-VALUE-TEXT
              END-IF                                                    
              MOVE 'Q5'                      TO MI-TABLE-ID             
              MOVE 'MTR-RD-INST1   '         TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD +1                         TO MI-TRAN-APPL-NO         
           END-IF.                                                      
                                                                        
           IF((MN-UTILITY-SOURCE-CD NOT EQUAL WS-PREV-UTILITY-SOURCE-CD)
              OR (METER-DELETE))                                        
              AND MN-CODE-UTIL-TYPE EQUAL WS-ELECTRIC                   
              IF METER-UPDATE                                           
                 MOVE +75                   TO MI-PRV-COLUMN-VALUE-LEN  
                                               MI-CHG-COLUMN-VALUE-LEN  
                 MOVE +17                   TO UV-COLUMN-NA-LEN         
                 MOVE 'UTILITY_SOURCE_CD'   TO UV-COLUMN-NA-TEXT        
                 MOVE +16                   TO UV-TABLE-NA-LEN          
                 MOVE 'CSS_MTRD_ENVRNMT'    TO UV-TABLE-NA-TEXT         
                 MOVE 01                    TO UV-CODE-VALUE-LEN        
                 MOVE 75                    TO UV-CODE-LONG-DESC-LEN    
                 MOVE 'ALL'                 TO UV-PROGRAM-ID            
                 MOVE WS-PREV-UTILITY-SOURCE-CD                         
                                            TO UV-CODE-VALUE-TEXT       
                 PERFORM 7260-GET-CODE-VALUE      THRU   7260-EXIT      
                 MOVE UV-CODE-LONG-DESC-TEXT                            
                                            TO MI-PRV-COLUMN-VALUE-TEXT 
                 INITIALIZE  UV-CODE-VALUE-TEXT                         
                             UV-CODE-LONG-DESC-TEXT                     
      *          GET CURRENT UTIL SOURCE CODE                                   
                 MOVE MN-UTILITY-SOURCE-CD  TO UV-CODE-VALUE-TEXT       
                 PERFORM 7260-GET-CODE-VALUE      THRU   7260-EXIT      
                 MOVE UV-CODE-LONG-DESC-TEXT                            
                                            TO MI-CHG-COLUMN-VALUE-TEXT 
                 INITIALIZE  UV-CODE-VALUE-TEXT                         
                             UV-CODE-LONG-DESC-TEXT                     
              ELSE                                                      
                 MOVE +75                   TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE +08                   TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE +17                   TO UV-COLUMN-NA-LEN         
                 MOVE 'UTILITY_SOURCE_CD'   TO UV-COLUMN-NA-TEXT        
                 MOVE +16                   TO UV-TABLE-NA-LEN          
                 MOVE 'CSS_MTRD_ENVRNMT'    TO UV-TABLE-NA-TEXT         
                 MOVE 01                    TO UV-CODE-VALUE-LEN        
                 MOVE 75                    TO UV-CODE-LONG-DESC-LEN    
                 MOVE  WS-PREV-UTILITY-SOURCE-CD                        
                                            TO UV-CODE-VALUE-TEXT       
                 MOVE 'ALL'                 TO UV-PROGRAM-ID            
                 PERFORM 7260-GET-CODE-VALUE      THRU   7260-EXIT      
                 MOVE UV-CODE-LONG-DESC-TEXT                            
                                            TO MI-PRV-COLUMN-VALUE-TEXT 
                 INITIALIZE  UV-CODE-VALUE-TEXT                         
                             UV-CODE-LONG-DESC-TEXT                     
                 MOVE '*DELETED'            TO MI-CHG-COLUMN-VALUE-TEXT 
              END-IF                                                    
                                                                        
              MOVE SPACES                    TO MI-TABLE-ID             
              MOVE 'UTIL-SOURCE-CODE'        TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD +1                         TO MI-TRAN-APPL-NO         
           END-IF.                                                      
                                                                        
           IF ((MN-NO-CONSEC-ESTIMATE NOT EQUAL                         
                         WS-PREV-NO-CONSEC-ESTIMATE) OR (METER-DELETE)) 
              IF METER-UPDATE                                           
                 MOVE +04                    TO MI-PRV-COLUMN-VALUE-LEN 
                                                MI-CHG-COLUMN-VALUE-LEN 
                 MOVE WS-PREV-NO-CONSEC-ESTIMATE                        
                                             TO MI-PRV-COLUMN-VALUE-TEXT
                 MOVE MN-NO-CONSEC-ESTIMATE  TO MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +04                    TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE +08                    TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE WS-PREV-NO-CONSEC-ESTIMATE                        
                                             TO MI-PRV-COLUMN-VALUE-TEXT
                 MOVE '*DELETED'             TO MI-CHG-COLUMN-VALUE-TEXT
              END-IF                                                    
              MOVE SPACES                    TO MI-TABLE-ID             
              MOVE 'NO-CONSEC-EST'           TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD +1                         TO MI-TRAN-APPL-NO         
           END-IF.                                                      
                                                                        
           IF ((MN-DELIVERY-LEVEL-CD NOT EQUAL                          
                   WS-PREV-DELIVERY-LEVEL-CD) OR (METER-DELETE))        
              AND MN-CODE-UTIL-TYPE    EQUAL WS-ELECTRIC                
              IF METER-UPDATE                                           
                 MOVE +01                    TO MI-PRV-COLUMN-VALUE-LEN 
                                                MI-CHG-COLUMN-VALUE-LEN 
                 MOVE WS-PREV-DELIVERY-LEVEL-CD                         
                                             TO MI-PRV-COLUMN-VALUE-TEXT
                 MOVE MN-DELIVERY-LEVEL-CD   TO MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +01                    TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE +08                    TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE WS-PREV-DELIVERY-LEVEL-CD                         
                                             TO MI-PRV-COLUMN-VALUE-TEXT
                 MOVE '*DELETED'             TO MI-CHG-COLUMN-VALUE-TEXT
              END-IF                                                    
              MOVE 'R2'                      TO MI-TABLE-ID             
              MOVE 'DELIVERY LEVEL'          TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD +1                         TO MI-TRAN-APPL-NO         
           END-IF.                                                      
                                                                        
           IF ((MN-SEAL-CODE-ID NOT EQUAL WS-PREV-SEAL-CODE-ID) OR      
               (METER-DELETE))                                          
              IF METER-UPDATE                                           
                 MOVE +01                    TO MI-PRV-COLUMN-VALUE-LEN 
                                                MI-CHG-COLUMN-VALUE-LEN 
                 MOVE WS-PREV-SEAL-CODE-ID   TO MI-PRV-COLUMN-VALUE-TEXT
                 MOVE MN-SEAL-CODE-ID        TO MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +01                    TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE +08                    TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE WS-PREV-SEAL-CODE-ID   TO MI-PRV-COLUMN-VALUE-TEXT
                 MOVE '*DELETED'             TO MI-CHG-COLUMN-VALUE-TEXT
              END-IF                                                    
              MOVE 'B4'                      TO MI-TABLE-ID             
              MOVE 'SEAL-CODE-ID  '          TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD +1                         TO MI-TRAN-APPL-NO         
           END-IF.                                                      
                                                                        
           IF ((MN-MIN-NO-UNITS NOT EQUAL WS-PREV-MIN-NO-UNITS) OR      
               (METER-DELETE)) OR                                       
              (METER-DELETE AND WS-PREV-MIN-NO-UNITS EQUAL WS-ZERO)     
              IF METER-UPDATE                                           
                 MOVE +09                    TO MI-PRV-COLUMN-VALUE-LEN 
                                                MI-CHG-COLUMN-VALUE-LEN 
                 MOVE WS-PREV-MIN-NO-UNITS   TO MI-PRV-COLUMN-VALUE-TEXT
                 MOVE MN-MIN-NO-UNITS        TO MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +01                    TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE +08                    TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE WS-PREV-MIN-NO-UNITS   TO MI-PRV-COLUMN-VALUE-TEXT
                 MOVE '*DELETED'             TO MI-CHG-COLUMN-VALUE-TEXT
              END-IF                                                    
              MOVE '69'                      TO MI-TABLE-ID             
              MOVE 'MIN-NO-UNITS'            TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD +1                         TO MI-TRAN-APPL-NO         
           END-IF.                                                      
                                                                        
           IF ((MN-MAX-NO-UNITS NOT EQUAL WS-PREV-MAX-NO-UNITS) OR      
               (METER-DELETE)) OR                                       
              (METER-DELETE AND WS-PREV-MAX-NO-UNITS EQUAL WS-ZERO)     
              IF METER-UPDATE                                           
                 MOVE +09                    TO MI-PRV-COLUMN-VALUE-LEN 
                                                MI-CHG-COLUMN-VALUE-LEN 
                 MOVE WS-PREV-MAX-NO-UNITS   TO MI-PRV-COLUMN-VALUE-TEXT
                 MOVE MN-MAX-NO-UNITS        TO MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +09                    TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE +08                    TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE WS-PREV-MAX-NO-UNITS   TO MI-PRV-COLUMN-VALUE-TEXT
                 MOVE '*DELETED'             TO MI-CHG-COLUMN-VALUE-TEXT
              END-IF                                                    
              MOVE '69'                      TO MI-TABLE-ID             
              MOVE 'MAX-NO-UNITS'            TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD +1                         TO MI-TRAN-APPL-NO         
           END-IF.                                                      
                                                                        
           IF ((MN-LOCK-TYPE-ID NOT EQUAL WS-PREV-LOCK-TYPE-ID) OR      
                (METER-DELETE))                                         
              IF METER-UPDATE                                           
                 MOVE +01                    TO MI-PRV-COLUMN-VALUE-LEN 
                                                MI-CHG-COLUMN-VALUE-LEN 
                 MOVE WS-PREV-LOCK-TYPE-ID   TO MI-PRV-COLUMN-VALUE-TEXT
                 MOVE MN-LOCK-TYPE-ID        TO MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +01                    TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE +08                    TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE WS-PREV-LOCK-TYPE-ID   TO MI-PRV-COLUMN-VALUE-TEXT
                 MOVE '*DELETED'             TO MI-CHG-COLUMN-VALUE-TEXT
              END-IF                                                    
              MOVE 'B3'                      TO MI-TABLE-ID             
              MOVE 'LOCK-TYPE-ID'            TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD +1                         TO MI-TRAN-APPL-NO         
           END-IF.                                                      
                                                                        
           IF ((MN-REGISTER-RD-SEQ NOT EQUAL WS-PREV-REGISTER-RD-SEQ)   
               OR (METER-DELETE))                                       
              IF METER-UPDATE                                           
                 MOVE +09                    TO MI-PRV-COLUMN-VALUE-LEN 
                                                MI-CHG-COLUMN-VALUE-LEN 
                 MOVE WS-PREV-REGISTER-RD-SEQ                           
                                             TO MI-PRV-COLUMN-VALUE-TEXT
                 MOVE MN-REGISTER-RD-SEQ     TO MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +09                    TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE +08                    TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE WS-PREV-REGISTER-RD-SEQ                           
                                             TO MI-PRV-COLUMN-VALUE-TEXT
                 MOVE '*DELETED'             TO MI-CHG-COLUMN-VALUE-TEXT
              END-IF                                                    
              MOVE SPACES                    TO MI-TABLE-ID             
              MOVE 'REGISTER-RD-SEQ'         TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD +1                         TO MI-TRAN-APPL-NO         
           END-IF.                                                      
                                                                        
           IF ((MN-IDR-RECIPIENT-CD NOT EQUAL WS-PREV-IDR-RECIPIENT-CD) 
               OR (METER-DELETE))                                       
              AND MN-CODE-UTIL-TYPE   EQUAL WS-ELECTRIC                 
              IF METER-UPDATE                                           
                 MOVE +01                    TO MI-PRV-COLUMN-VALUE-LEN 
                                                MI-CHG-COLUMN-VALUE-LEN 
                 MOVE WS-PREV-IDR-RECIPIENT-CD                          
                                             TO MI-PRV-COLUMN-VALUE-TEXT
                 MOVE MN-IDR-RECIPIENT-CD    TO MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +01                    TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE +08                    TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE WS-PREV-IDR-RECIPIENT-CD                          
                                             TO MI-PRV-COLUMN-VALUE-TEXT
                 MOVE '*DELETED'             TO MI-CHG-COLUMN-VALUE-TEXT
              END-IF                                                    
              MOVE '26'                      TO MI-TABLE-ID             
              MOVE 'IDR-RECIPIENT'           TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD +1                         TO MI-TRAN-APPL-NO         
           END-IF.                                                      
                                                                        
           IF ((MN-INDUST-BTU-ID NOT EQUAL WS-PREV-INDUST-BTU-ID) OR    
               (METER-DELETE))                                          
              AND (MN-CODE-UTIL-TYPE   EQUAL WS-GAS)                    
              IF METER-UPDATE                                           
                 MOVE SPACES                 TO MI-TABLE-ID             
                 MOVE 'INDUST-BTU-ID'        TO MI-COLUMN-DESC          
                 MOVE +20                    TO MI-PRV-COLUMN-VALUE-LEN 
                                                MI-CHG-COLUMN-VALUE-LEN 
                 IF WS-PREV-INDUST-BTU-ID = SPACES                      
                    MOVE +07                 TO MI-PRV-COLUMN-VALUE-LEN 
                    MOVE '**NEW**'           TO MI-PRV-COLUMN-VALUE-TEXT
                 ELSE                                                   
                    MOVE SPACES              TO FD-INDUST-BTU-ID        
                                                FD-INDUST-BTU-DESC      
                    MOVE WS-PREV-INDUST-BTU-ID                          
                                             TO FD-INDUST-BTU-ID        
                    MOVE AT-COMPANY-NO       TO FD-COMPANY-NO           
                    PERFORM 7280-GET-IND-BTU-DESC THRU 7280-EXIT        
                    MOVE FD-INDUST-BTU-DESC  TO MI-PRV-COLUMN-VALUE-TEXT
                 END-IF                                                 
                                                                        
                 IF MN-INDUST-BTU-ID      = SPACES                      
                    MOVE +08                 TO MI-CHG-COLUMN-VALUE-LEN 
                    MOVE '*DELETED'          TO MI-CHG-COLUMN-VALUE-TEXT
                 ELSE                                                   
                    MOVE SPACES              TO FD-INDUST-BTU-ID        
                                                FD-INDUST-BTU-DESC      
                    MOVE MN-INDUST-BTU-ID    TO FD-INDUST-BTU-ID        
                    MOVE AT-COMPANY-NO       TO FD-COMPANY-NO           
                    PERFORM 7280-GET-IND-BTU-DESC THRU 7280-EXIT        
                    MOVE FD-INDUST-BTU-DESC                             
                                             TO MI-CHG-COLUMN-VALUE-TEXT
                 END-IF                                                 
                                                                        
                 PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
                 ADD +1                      TO MI-TRAN-APPL-NO         
              ELSE                                                      
                 MOVE +20                    TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE +08                    TO MI-CHG-COLUMN-VALUE-LEN 
                                                                        
                 IF WS-PREV-INDUST-BTU-ID > SPACES                      
                    MOVE SPACES              TO FD-INDUST-BTU-ID        
                                                FD-INDUST-BTU-DESC      
                    MOVE WS-PREV-INDUST-BTU-ID                          
                                             TO FD-INDUST-BTU-ID        
                    MOVE AT-COMPANY-NO       TO FD-COMPANY-NO           
                    PERFORM 7280-GET-IND-BTU-DESC    THRU 7280-EXIT     
                    MOVE FD-INDUST-BTU-DESC  TO MI-PRV-COLUMN-VALUE-TEXT
                    MOVE '*DELETED'          TO MI-CHG-COLUMN-VALUE-TEXT
                    PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT     
                    ADD +1                         TO MI-TRAN-APPL-NO   
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF ((MN-GIS-MISMATCH-FL NOT EQUAL WS-PREV-GIS-MISMATCH-FL)   
               OR (METER-DELETE))                                       
              IF METER-UPDATE                                           
                 MOVE +01                    TO MI-PRV-COLUMN-VALUE-LEN 
                                                MI-CHG-COLUMN-VALUE-LEN 
                 MOVE WS-PREV-GIS-MISMATCH-FL                           
                                             TO MI-PRV-COLUMN-VALUE-TEXT
                                                                        
                 MOVE MN-GIS-MISMATCH-FL     TO MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +01                    TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE +08                    TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE WS-PREV-GIS-MISMATCH-FL                           
                                             TO MI-PRV-COLUMN-VALUE-TEXT
                 MOVE '*DELETED'             TO MI-CHG-COLUMN-VALUE-TEXT
              END-IF                                                    
              MOVE SPACES                    TO MI-TABLE-ID             
              MOVE 'GIS-MISMATCH-FL'         TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD +1                         TO MI-TRAN-APPL-NO         
           END-IF.                                                      
                                                                        
           IF ((MN-INSULATED-IND NOT = WS-PREV-INSULATED-IND) OR        
               (METER-DELETE))                                          
              AND MN-CODE-UTIL-TYPE  EQUAL WS-GAS                       
              IF METER-UPDATE                                           
                 MOVE +01                    TO MI-PRV-COLUMN-VALUE-LEN 
                                                MI-CHG-COLUMN-VALUE-LEN 
                 MOVE WS-PREV-INSULATED-IND                             
                                             TO MI-PRV-COLUMN-VALUE-TEXT
                                                                        
                 MOVE MN-INSULATED-IND       TO MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +01                    TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE +08                    TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE WS-PREV-INSULATED-IND                             
                                             TO MI-PRV-COLUMN-VALUE-TEXT
                 MOVE '*DELETED'             TO MI-CHG-COLUMN-VALUE-TEXT
              END-IF                                                    
              MOVE SPACES                    TO MI-TABLE-ID             
              MOVE 'INSULATED-IND'           TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD +1                         TO MI-TRAN-APPL-NO         
           END-IF.                                                      
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 5100-WRITE-TRANS-HIST.                                         *        
      ******************************************************************        
       5100-WRITE-TRANS-HIST.                                           
                                                                        
           PERFORM 7010-GET-CURR-TIMESTAMP     THRU 7010-EXIT.          
           PERFORM 7015-GET-RESP-AREA-ID       THRU 7015-EXIT.          
                                                                        
      *    WRITE A TRANSACTION HISTORY FOR THE HEADER ROW                       
           MOVE 'F'                         TO MH-CODE-TRAN-TYPE.       
           MOVE WS-RESP-AREA-ID             TO MH-RESP-AREA-ID.         
           MOVE MN-ACCOUNT-NO               TO MH-ACCOUNT-NO.           
           MOVE WS-ZERO                     TO MH-CUSTOMER-NO.          
           MOVE WS-ZERO                     TO MH-PREMISE-NO.           
           MOVE WS-LAST-UPDATE-USERID       TO MH-USER-ID.              
           MOVE 'CSR04644R'                 TO MH-APPL-PROGRAM-ID.      
           MOVE WS-ENTITY-KEY-DESC          TO MH-ENTITY-KEY-DESC-TEXT. 
           MOVE WS-REGISTER-LEN             TO MH-ENTITY-KEY-DESC-LEN.  
           MOVE WS-COMMENT-LEN              TO MH-TRAN-COMMENT-LEN      
           MOVE WS-COMMENT                  TO MH-TRAN-COMMENT-TEXT     
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO        TO MI-TRANS-HIST-SEQ-NO.    
           MOVE 1                           TO MI-TRAN-APPL-NO.         
                                                                        
      * WRITING METER NO IN TRAN HIST DETAIL                                    
           MOVE +13                         TO MI-PRV-COLUMN-VALUE-LEN  
                                               MI-CHG-COLUMN-VALUE-LEN. 
                                                                        
           MOVE WS-TRAN-METER-NO            TO MI-PRV-COLUMN-VALUE-TEXT 
                                               MI-CHG-COLUMN-VALUE-TEXT.
           MOVE 'METER NO'                  TO MI-COLUMN-DESC.          
           MOVE SPACES                      TO MI-TABLE-ID.             
           PERFORM 6530-LOAD-MNT-TRANS-HIST       THRU 6530-EXIT.       
           ADD +1                           TO MI-TRAN-APPL-NO.         
      * METER  NUMBER ENDS HERE                                                 
                                                                        
      * WRITING REG HEADER IN TRAN HIST DETAIL                                  
           MOVE +51                         TO MI-PRV-COLUMN-VALUE-LEN  
                                               MI-CHG-COLUMN-VALUE-LEN. 
                                                                        
      * GET CODE VALUE FOR REG CODE_TIME_PERIOD                                 
           IF RG-CODE-TIME-PERIOD    = ZERO                             
              MOVE SPACES                   TO WS-REG-CODETIME-DESC     
           ELSE                                                         
              MOVE +16                      TO UV-COLUMN-NA-LEN         
              MOVE 'CODE_TIME_PERIOD'       TO UV-COLUMN-NA-TEXT        
              MOVE +17                      TO UV-TABLE-NA-LEN          
              MOVE 'CSS_REGISTER_READ'      TO UV-TABLE-NA-TEXT         
              MOVE 01                       TO UV-CODE-VALUE-LEN        
              MOVE 'ALL'                    TO UV-PROGRAM-ID            
              MOVE AT-COMPANY-NO            TO UV-COMPANY-NO            
              MOVE RG-CODE-TIME-PERIOD      TO WS-TIME-PRD-TXT          
              MOVE WS-TIME-PRD-TXT(4:1)     TO UV-CODE-VALUE-TEXT       
              PERFORM 7260-GET-CODE-VALUE         THRU 7260-EXIT        
              MOVE LENGTH OF UV-CODE-SHORT-DESC-TEXT                    
                                            TO UV-CODE-SHORT-DESC-LEN   
              MOVE FUNCTION UPPER-CASE(UV-CODE-SHORT-DESC-TEXT)         
                                            TO                          
                                            UV-CODE-SHORT-DESC-TEXT     
              MOVE UV-CODE-SHORT-DESC-TEXT  TO WS-REG-CODETIME-DESC     
           END-IF.                                                      
                                                                        
           STRING WS-REG-USAGE-DESC DELIMITED BY '  ' ' ' DELIMITED     
                   BY SIZE WS-REG-CODETIME-DESC DELIMITED BY '  ' INTO  
                   WS-REG-USAGE-CODETIME-DESC.                          
                                                                        
           MOVE WS-REG-USAGE-CODETIME-DESC  TO MI-PRV-COLUMN-VALUE-TEXT 
                                               MI-CHG-COLUMN-VALUE-TEXT.
      *                                                                         
           INITIALIZE  UV-CODE-VALUE-TEXT                               
                       UV-CODE-LONG-DESC-TEXT.                          
      *                                                                         
           MOVE '01'                        TO UV-COMPANY-NO.           
           MOVE 'REGISTER '                 TO MI-COLUMN-DESC.          
           MOVE SPACES                      TO MI-TABLE-ID.             
           PERFORM 6530-LOAD-MNT-TRANS-HIST       THRU 6530-EXIT.       
           ADD +1                           TO MI-TRAN-APPL-NO.         
      * REG HEADER ENDS HERE                                                    
                                                                        
           IF RG-CODE-REG-STATUS NOT EQUAL WS-PREV-CODE-REG-STATUS      
              IF REGISTER-UPDATE(WS-RGSTER-RD-INDX)                     
                 MOVE +75                  TO MI-PRV-COLUMN-VALUE-LEN   
                                              MI-CHG-COLUMN-VALUE-LEN   
      * GET CODE VALUE                                                          
                 MOVE +17                   TO UV-COLUMN-NA-LEN         
                 MOVE 'CODE_METER_STATUS'   TO UV-COLUMN-NA-TEXT        
                 MOVE +17                   TO UV-TABLE-NA-LEN          
                 MOVE 'CSS_REGISTER_READ'   TO UV-TABLE-NA-TEXT         
                 MOVE 01                    TO UV-CODE-VALUE-LEN        
                 MOVE 75                    TO UV-CODE-LONG-DESC-LEN    
                 MOVE 'ALL'                 TO UV-PROGRAM-ID            
                 MOVE  WS-PREV-CODE-REG-STATUS                          
                                            TO UV-CODE-VALUE-TEXT       
                 PERFORM 7260-GET-CODE-VALUE      THRU   7260-EXIT      
                 MOVE UV-CODE-LONG-DESC-TEXT                            
                                            TO MI-PRV-COLUMN-VALUE-TEXT 
      *                                                                         
                 INITIALIZE UV-CODE-VALUE-TEXT                          
                            UV-CODE-LONG-DESC-TEXT                      
      *                                                                         
MRMCHG* CODE VALUE TAKEN                                                        
                                                                        
MRMCHG* GET CODE VALUE                                                          
                 MOVE  RG-CODE-REG-STATUS   TO UV-CODE-VALUE-TEXT       
                 PERFORM 7260-GET-CODE-VALUE      THRU   7260-EXIT      
                 MOVE UV-CODE-LONG-DESC-TEXT                            
                                            TO MI-CHG-COLUMN-VALUE-TEXT 
      *                                                                         
                 INITIALIZE  UV-CODE-VALUE-TEXT                         
                             UV-CODE-LONG-DESC-TEXT                     
MRMCHG* CODE VALUE TAKEN                                                        
                                                                        
              ELSE                                                      
                 MOVE +75                  TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE +08                  TO MI-CHG-COLUMN-VALUE-LEN   
MRMCHG* GET CODE VALUE                                                          
                 MOVE +17                   TO UV-COLUMN-NA-LEN         
                 MOVE 'CODE_METER_STATUS'   TO UV-COLUMN-NA-TEXT        
                 MOVE +17                   TO UV-TABLE-NA-LEN          
                 MOVE 'CSS_REGISTER_READ'   TO UV-TABLE-NA-TEXT         
                 MOVE 01                    TO UV-CODE-VALUE-LEN        
                 MOVE 75                    TO UV-CODE-LONG-DESC-LEN    
                 MOVE 'ALL'                 TO UV-PROGRAM-ID            
                 MOVE  WS-PREV-CODE-REG-STATUS                          
                                            TO UV-CODE-VALUE-TEXT       
                 PERFORM 7260-GET-CODE-VALUE      THRU   7260-EXIT      
                 MOVE UV-CODE-LONG-DESC-TEXT                            
                                            TO MI-PRV-COLUMN-VALUE-TEXT 
      *                                                                         
                 INITIALIZE  UV-CODE-VALUE-TEXT                         
                             UV-CODE-LONG-DESC-TEXT                     
MRMCHG* CODE VALUE TAKEN                                                        
                 MOVE '*DELETED'           TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'Register Status'       TO MI-COLUMN-DESC            
              MOVE SPACES                  TO MI-TABLE-ID               
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD +1                       TO MI-TRAN-APPL-NO           
           END-IF.                                                      
                                                                        
           IF RG-CODE-CRNT-REG-READ NOT EQUAL WS-PREV-CODE-CRNT-REG-READ
              IF REGISTER-UPDATE(WS-RGSTER-RD-INDX)                     
                 MOVE +75                  TO MI-PRV-COLUMN-VALUE-LEN   
                                              MI-CHG-COLUMN-VALUE-LEN   
MRMCHG* GET CODE VALUE                                                          
                 MOVE +18                   TO UV-COLUMN-NA-LEN         
                 MOVE 'CODE_CRNT_REG_READ'  TO UV-COLUMN-NA-TEXT        
                 MOVE +17                   TO UV-TABLE-NA-LEN          
                 MOVE 'CSS_REGISTER_READ'   TO UV-TABLE-NA-TEXT         
                 MOVE 01                    TO UV-CODE-VALUE-LEN        
                 MOVE 75                    TO UV-CODE-LONG-DESC-LEN    
                 MOVE 'ALL'                 TO UV-PROGRAM-ID            
                 MOVE  WS-PREV-CODE-CRNT-REG-READ                       
                                            TO UV-CODE-VALUE-TEXT       
                 PERFORM 7260-GET-CODE-VALUE      THRU   7260-EXIT      
                 MOVE UV-CODE-LONG-DESC-TEXT                            
                                            TO MI-PRV-COLUMN-VALUE-TEXT 
      *                                                                         
                 INITIALIZE  UV-CODE-VALUE-TEXT                         
                             UV-CODE-LONG-DESC-TEXT                     
      *                                                                         
MRMCHG* GET CODE VALUE                                                          
                 MOVE  RG-CODE-CRNT-REG-READ                            
                                            TO UV-CODE-VALUE-TEXT       
                 PERFORM 7260-GET-CODE-VALUE      THRU   7260-EXIT      
                 MOVE UV-CODE-LONG-DESC-TEXT                            
                                            TO MI-CHG-COLUMN-VALUE-TEXT 
                 INITIALIZE  UV-CODE-VALUE-TEXT                         
                             UV-CODE-LONG-DESC-TEXT                     
MRMCHG* CODE VALUE TAKEN                                                        
              ELSE                                                      
                 MOVE +75                  TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE +08                  TO MI-CHG-COLUMN-VALUE-LEN   
MRMCHG* GET CODE VALUE                                                          
                 MOVE +18                   TO UV-COLUMN-NA-LEN         
                 MOVE 'CODE_CRNT_REG_READ'  TO UV-COLUMN-NA-TEXT        
                 MOVE +17                   TO UV-TABLE-NA-LEN          
                 MOVE 'CSS_REGISTER_READ'   TO UV-TABLE-NA-TEXT         
                 MOVE 01                    TO UV-CODE-VALUE-LEN        
                 MOVE 75                    TO UV-CODE-LONG-DESC-LEN    
                 MOVE  WS-PREV-CODE-CRNT-REG-READ                       
                                            TO UV-CODE-VALUE-TEXT       
                 MOVE 'ALL'                 TO UV-PROGRAM-ID            
                 PERFORM 7260-GET-CODE-VALUE      THRU   7260-EXIT      
                 MOVE UV-CODE-LONG-DESC-TEXT                            
                                            TO MI-PRV-COLUMN-VALUE-TEXT 
                 INITIALIZE  UV-CODE-VALUE-TEXT                         
                             UV-CODE-LONG-DESC-TEXT                     
MRMCHG* CODE VALUE TAKEN                                                        
                 MOVE '*DELETED'           TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'Read Code '            TO MI-COLUMN-DESC            
              MOVE SPACES                  TO MI-TABLE-ID               
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD +1                       TO MI-TRAN-APPL-NO           
           END-IF.                                                      
MRMCHG* NO READ REASON                                                          
           IF RG-CODE-NO-RD-REASON NOT EQUAL WS-PREV-CODE-NO-RD-REASON  
              IF REGISTER-UPDATE(WS-RGSTER-RD-INDX)                     
                 MOVE +35                  TO MI-PRV-COLUMN-VALUE-LEN   
                                              MI-CHG-COLUMN-VALUE-LEN   
                 MOVE WS-PREV-CODE-NO-RD-REASON                         
                                           TO S4-CODE-NO-RD-REASON      
                 PERFORM 7270-GET-NO-READ-REASON  THRU 7270-EXIT        
                                                                        
                 IF WS-PREV-CODE-NO-RD-REASON = SPACES                  
                    MOVE '**NEW**'         TO MI-PRV-COLUMN-VALUE-TEXT  
                 ELSE                                                   
                   MOVE S4-NO-RD-REASON-DESC                            
                                           TO MI-PRV-COLUMN-VALUE-TEXT  
                 END-IF                                                 
                                                                        
                 INITIALIZE  DCLCSS-NO-READ-REASON                      
                                                                        
      * NO READ REASON TAKEN                                                    
                 MOVE RG-CODE-NO-RD-REASON TO S4-CODE-NO-RD-REASON      
                 PERFORM 7270-GET-NO-READ-REASON  THRU 7270-EXIT        
                 MOVE S4-NO-RD-REASON-DESC TO MI-CHG-COLUMN-VALUE-TEXT  
                 INITIALIZE DCLCSS-NO-READ-REASON                       
      * NO READ REASON TAKEN                                                    
              ELSE                                                      
                 MOVE +35                  TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE +08                  TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE WS-PREV-CODE-NO-RD-REASON                         
                                           TO S4-CODE-NO-RD-REASON      
                 PERFORM 7270-GET-NO-READ-REASON  THRU 7270-EXIT        
                                                                        
                 IF WS-PREV-CODE-NO-RD-REASON = SPACES                  
                    MOVE '**NEW**'         TO MI-PRV-COLUMN-VALUE-TEXT  
                 ELSE                                                   
                   MOVE S4-NO-RD-REASON-DESC                            
                                           TO MI-PRV-COLUMN-VALUE-TEXT  
                 END-IF                                                 
                                                                        
                 INITIALIZE DCLCSS-NO-READ-REASON                       
      * NO READ REASON TAKEN                                                    
                 MOVE '*DELETED'           TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'No Read Reason '       TO MI-COLUMN-DESC            
              MOVE SPACES                  TO MI-TABLE-ID               
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD +1                       TO MI-TRAN-APPL-NO           
           END-IF.                                                      
                                                                        
           IF RG-CODE-STATUS-REAS NOT EQUAL WS-PREV-CODE-STATUS-REAS    
              IF REGISTER-UPDATE(WS-RGSTER-RD-INDX)                     
                 MOVE +75                  TO MI-PRV-COLUMN-VALUE-LEN   
                                              MI-CHG-COLUMN-VALUE-LEN   
MRMCHG* GET CODE VALUE                                                          
                 MOVE +16                   TO UV-COLUMN-NA-LEN         
                 MOVE 'CODE_STATUS_REAS'    TO UV-COLUMN-NA-TEXT        
                 MOVE +17                   TO UV-TABLE-NA-LEN          
                 MOVE 'CSS_REGISTER_READ'   TO UV-TABLE-NA-TEXT         
                 MOVE 01                    TO UV-CODE-VALUE-LEN        
                 MOVE 75                    TO UV-CODE-LONG-DESC-LEN    
                 MOVE 'ALL'                 TO UV-PROGRAM-ID            
                 MOVE  WS-PREV-CODE-STATUS-REAS                         
                                            TO UV-CODE-VALUE-TEXT       
                 PERFORM 7260-GET-CODE-VALUE      THRU   7260-EXIT      
                 MOVE UV-CODE-LONG-DESC-TEXT                            
                                            TO MI-PRV-COLUMN-VALUE-TEXT 
      *                                                                         
                 INITIALIZE  UV-CODE-VALUE-TEXT                         
                             UV-CODE-LONG-DESC-TEXT                     
      *                                                                         
MRMCHG* GET CODE VALUE                                                          
                 MOVE RG-CODE-STATUS-REAS  TO UV-CODE-VALUE-TEXT        
                 PERFORM 7260-GET-CODE-VALUE      THRU   7260-EXIT      
                 MOVE UV-CODE-LONG-DESC-TEXT                            
                                            TO MI-CHG-COLUMN-VALUE-TEXT 
                 INITIALIZE  UV-CODE-VALUE-TEXT                         
                             UV-CODE-LONG-DESC-TEXT                     
MRMCHG* CODE VALUE TAKEN                                                        
              ELSE                                                      
                 MOVE +75                  TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE +08                  TO MI-CHG-COLUMN-VALUE-LEN   
MRMCHG* GET CODE VALUE                                                          
                 MOVE +16                   TO UV-COLUMN-NA-LEN         
                 MOVE 'CODE_STATUS_REAS'    TO UV-COLUMN-NA-TEXT        
                 MOVE +17                   TO UV-TABLE-NA-LEN          
                 MOVE 'CSS_REGISTER_READ'   TO UV-TABLE-NA-TEXT         
                 MOVE 01                    TO UV-CODE-VALUE-LEN        
                 MOVE 75                    TO UV-CODE-LONG-DESC-LEN    
                 MOVE  WS-PREV-CODE-STATUS-REAS                         
                                            TO UV-CODE-VALUE-TEXT       
                 MOVE 'ALL'                 TO UV-PROGRAM-ID            
                 PERFORM 7260-GET-CODE-VALUE      THRU   7260-EXIT      
                 MOVE UV-CODE-LONG-DESC-TEXT                            
                                            TO MI-PRV-COLUMN-VALUE-TEXT 
                 INITIALIZE  UV-CODE-VALUE-TEXT                         
                             UV-CODE-LONG-DESC-TEXT                     
MRMCHG* CODE VALUE TAKEN                                                        
                 MOVE '*DELETED'           TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'Reason '               TO MI-COLUMN-DESC            
              MOVE SPACES                  TO MI-TABLE-ID               
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD +1                        TO MI-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
           IF RG-LAST-VAL-RD-VALUE NOT EQUAL WS-PREV-LAST-VAL-RD-VALUE  
              IF DIAL-USAGE-TYPE AND ( WS-NO-READ-DIALS > 0 )           
                 PERFORM 5111-MOVE-LST-RD-DIAL    THRU 5111-EXIT        
              ELSE                                                      
                 PERFORM 5110-MOVE-LST-RD-VALUE   THRU 5110-EXIT        
              END-IF                                                    
                                                                        
              MOVE 'Lst Vald Rd Value'     TO MI-COLUMN-DESC            
              MOVE SPACES                  TO MI-TABLE-ID               
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD +1                       TO MI-TRAN-APPL-NO           
           END-IF.                                                      
                                                                        
           IF RG-CODE-LAST-VALID-RD NOT EQUAL WS-PREV-CODE-LAST-VALID-RD
              IF REGISTER-UPDATE(WS-RGSTER-RD-INDX)                     
                 MOVE +75                  TO MI-PRV-COLUMN-VALUE-LEN   
                                              MI-CHG-COLUMN-VALUE-LEN   
MRMCHG* GET CODE VALUE                                                          
                 MOVE +18                   TO UV-COLUMN-NA-LEN         
                 MOVE 'CODE_CRNT_REG_READ'  TO UV-COLUMN-NA-TEXT        
                 MOVE +17                   TO UV-TABLE-NA-LEN          
                 MOVE 'CSS_REGISTER_READ'   TO UV-TABLE-NA-TEXT         
                 MOVE 01                    TO UV-CODE-VALUE-LEN        
                 MOVE 75                    TO UV-CODE-LONG-DESC-LEN    
                 MOVE 'ALL'                 TO UV-PROGRAM-ID            
                 MOVE  WS-PREV-CODE-LAST-VALID-RD                       
                                            TO UV-CODE-VALUE-TEXT       
                 PERFORM 7260-GET-CODE-VALUE      THRU   7260-EXIT      
                 MOVE UV-CODE-LONG-DESC-TEXT                            
                                            TO MI-PRV-COLUMN-VALUE-TEXT 
      *                                                                         
                 INITIALIZE  UV-CODE-VALUE-TEXT                         
                             UV-CODE-LONG-DESC-TEXT                     
      *                                                                         
MRMCHG* GET CODE VALUE                                                          
                 MOVE  RG-CODE-LAST-VALID-RD                            
                                            TO UV-CODE-VALUE-TEXT       
                 PERFORM 7260-GET-CODE-VALUE      THRU   7260-EXIT      
                 MOVE UV-CODE-LONG-DESC-TEXT                            
                                            TO MI-CHG-COLUMN-VALUE-TEXT 
                 INITIALIZE  UV-CODE-VALUE-TEXT                         
                             UV-CODE-LONG-DESC-TEXT                     
MRMCHG* CODE VALUE TAKEN                                                        
              ELSE                                                      
                 MOVE +75                  TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE +08                  TO MI-CHG-COLUMN-VALUE-LEN   
MRMCHG* GET CODE VALUE                                                          
                 MOVE +18                   TO UV-COLUMN-NA-LEN         
                 MOVE 'CODE_CRNT_REG_READ'  TO UV-COLUMN-NA-TEXT        
                 MOVE +17                   TO UV-TABLE-NA-LEN          
                 MOVE 'CSS_REGISTER_READ'   TO UV-TABLE-NA-TEXT         
                 MOVE 01                    TO UV-CODE-VALUE-LEN        
                 MOVE 75                    TO UV-CODE-LONG-DESC-LEN    
                 MOVE  WS-PREV-CODE-LAST-VALID-RD                       
                                            TO UV-CODE-VALUE-TEXT       
                 MOVE 'ALL'                 TO UV-PROGRAM-ID            
                 PERFORM 7260-GET-CODE-VALUE      THRU   7260-EXIT      
                 MOVE UV-CODE-LONG-DESC-TEXT                            
                                            TO MI-PRV-COLUMN-VALUE-TEXT 
                 INITIALIZE  UV-CODE-VALUE-TEXT                         
                             UV-CODE-LONG-DESC-TEXT                     
MRMCHG* CODE VALUE TAKEN                                                        
                 MOVE '*DELETED'           TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'Lst Vald Rd Sts'                                    
                                           TO MI-COLUMN-DESC            
              MOVE SPACES                  TO MI-TABLE-ID               
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD +1                       TO MI-TRAN-APPL-NO           
           END-IF.                                                      
                                                                        
           IF RG-LAST-VALID-READ-DT NOT EQUAL WS-PREV-LAST-VALID-READ-DT
              IF REGISTER-UPDATE(WS-RGSTER-RD-INDX)                     
                 MOVE +10                  TO MI-PRV-COLUMN-VALUE-LEN   
                                              MI-CHG-COLUMN-VALUE-LEN   
                 MOVE WS-PREV-LAST-VALID-READ-DT                        
                                           TO MI-PRV-COLUMN-VALUE-TEXT  
                 MOVE RG-LAST-VALID-READ-DT                             
                                           TO MI-CHG-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +10                  TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE +08                  TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE WS-PREV-LAST-VALID-READ-DT                        
                                           TO MI-PRV-COLUMN-VALUE-TEXT  
                 MOVE '*DELETED'           TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'Lst Valid Rd Dt'                                    
                                           TO MI-COLUMN-DESC            
              MOVE SPACES                  TO MI-TABLE-ID               
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD +1                       TO MI-TRAN-APPL-NO           
           END-IF.                                                      
                                                                        
           IF RG-LAST-VALID-READ-TM NOT EQUAL WS-PREV-LAST-VALID-READ-TM
              IF REGISTER-UPDATE(WS-RGSTER-RD-INDX)                     
                 MOVE +08                  TO MI-PRV-COLUMN-VALUE-LEN   
                                              MI-CHG-COLUMN-VALUE-LEN   
                 MOVE WS-PREV-LAST-VALID-READ-TM                        
                                           TO MI-PRV-COLUMN-VALUE-TEXT  
                 MOVE RG-LAST-VALID-READ-TM                             
                                           TO MI-CHG-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +08                  TO MI-PRV-COLUMN-VALUE-LEN   
                                              MI-CHG-COLUMN-VALUE-LEN   
                 MOVE WS-PREV-LAST-VALID-READ-TM                        
                                           TO MI-PRV-COLUMN-VALUE-TEXT  
                 MOVE '*DELETED'           TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'Lst Valid Rd Tm'       TO MI-COLUMN-DESC            
              MOVE SPACES                  TO MI-TABLE-ID               
              PERFORM 6530-LOAD-MNT-TRANS-HIST    THRU 6530-EXIT        
              ADD +1                       TO MI-TRAN-APPL-NO           
           END-IF.                                                      
                                                                        
           IF RG-LAST-READ-VALUE NOT EQUAL WS-PREV-LAST-READ-VALUE      
              IF DIAL-USAGE-TYPE AND ( WS-NO-READ-DIALS > 0 )           
                 PERFORM 5121-MOVE-REG-RD-DIAL    THRU 5121-EXIT        
              ELSE                                                      
                 PERFORM 5120-MOVE-REG-RD-VALUE   THRU 5120-EXIT        
              END-IF                                                    
              MOVE 'Regular Rd Val'        TO MI-COLUMN-DESC            
              MOVE SPACES                  TO MI-TABLE-ID               
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD +1                       TO MI-TRAN-APPL-NO           
           END-IF.                                                      
                                                                        
           IF RG-CODE-LAST-REG-READ NOT EQUAL WS-PREV-CODE-LAST-REG-READ
              IF REGISTER-UPDATE(WS-RGSTER-RD-INDX)                     
                 MOVE +75                  TO MI-PRV-COLUMN-VALUE-LEN   
                                              MI-CHG-COLUMN-VALUE-LEN   
MRMCHG* GET CODE VALUE                                                          
                 MOVE +18                   TO UV-COLUMN-NA-LEN         
                 MOVE 'CODE_CRNT_REG_READ'  TO UV-COLUMN-NA-TEXT        
                 MOVE +17                   TO UV-TABLE-NA-LEN          
                 MOVE 'CSS_REGISTER_READ'   TO UV-TABLE-NA-TEXT         
                 MOVE 01                    TO UV-CODE-VALUE-LEN        
                 MOVE 75                    TO UV-CODE-LONG-DESC-LEN    
                 MOVE 'ALL'                 TO UV-PROGRAM-ID            
                 MOVE  WS-PREV-CODE-LAST-REG-READ                       
                                            TO UV-CODE-VALUE-TEXT       
                 PERFORM 7260-GET-CODE-VALUE      THRU   7260-EXIT      
                 MOVE UV-CODE-LONG-DESC-TEXT                            
                                            TO MI-PRV-COLUMN-VALUE-TEXT 
      *                                                                         
                 INITIALIZE  UV-CODE-VALUE-TEXT                         
                             UV-CODE-LONG-DESC-TEXT                     
      *                                                                         
MRMCHG* CODE VALUE TAKEN                                                        
MRMCHG* GET CODE VALUE                                                          
                 MOVE  RG-CODE-LAST-REG-READ                            
                                            TO UV-CODE-VALUE-TEXT       
                 PERFORM 7260-GET-CODE-VALUE      THRU   7260-EXIT      
                 MOVE UV-CODE-LONG-DESC-TEXT                            
                                            TO MI-CHG-COLUMN-VALUE-TEXT 
                 INITIALIZE  UV-CODE-VALUE-TEXT                         
                             UV-CODE-LONG-DESC-TEXT                     
MRMCHG* CODE VALUE TAKEN                                                        
              ELSE                                                      
                 MOVE +75                  TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE +08                  TO MI-CHG-COLUMN-VALUE-LEN   
MRMCHG* GET CODE VALUE                                                          
                 MOVE +18                   TO UV-COLUMN-NA-LEN         
                 MOVE 'CODE_CRNT_REG_READ'  TO UV-COLUMN-NA-TEXT        
                 MOVE +17                   TO UV-TABLE-NA-LEN          
                 MOVE 'CSS_REGISTER_READ'   TO UV-TABLE-NA-TEXT         
                 MOVE 01                    TO UV-CODE-VALUE-LEN        
                 MOVE 75                    TO UV-CODE-LONG-DESC-LEN    
                 MOVE  WS-PREV-CODE-LAST-REG-READ                       
                                            TO UV-CODE-VALUE-TEXT       
                 MOVE 'ALL'                 TO UV-PROGRAM-ID            
                 PERFORM 7260-GET-CODE-VALUE      THRU   7260-EXIT      
                 MOVE UV-CODE-LONG-DESC-TEXT                            
                                            TO MI-PRV-COLUMN-VALUE-TEXT 
                 INITIALIZE  UV-CODE-VALUE-TEXT                         
                             UV-CODE-LONG-DESC-TEXT                     
MRMCHG* CODE VALUE TAKEN                                                        
                 MOVE '*DELETED'           TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'Regular Rd Sts'        TO MI-COLUMN-DESC            
              MOVE SPACES                  TO MI-TABLE-ID               
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD +1                       TO MI-TRAN-APPL-NO           
           END-IF.                                                      
                                                                        
           IF RG-LAST-REG-READ-DT NOT EQUAL WS-PREV-LAST-REG-READ-DT    
              IF REGISTER-UPDATE(WS-RGSTER-RD-INDX)                     
                 MOVE +10                  TO MI-PRV-COLUMN-VALUE-LEN   
                                              MI-CHG-COLUMN-VALUE-LEN   
                 MOVE WS-PREV-LAST-REG-READ-DT                          
                                           TO MI-PRV-COLUMN-VALUE-TEXT  
                 MOVE RG-LAST-REG-READ-DT  TO MI-CHG-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +10                  TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE +08                  TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE WS-PREV-LAST-REG-READ-DT                          
                                           TO MI-PRV-COLUMN-VALUE-TEXT  
                 MOVE '*DELETED'           TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'Regular Read Dt'       TO MI-COLUMN-DESC            
              MOVE SPACES                  TO MI-TABLE-ID               
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD +1                       TO MI-TRAN-APPL-NO           
           END-IF.                                                      
                                                                        
           IF RG-LAST-REG-READ-TM NOT EQUAL WS-PREV-LAST-REG-READ-TM    
              IF REGISTER-UPDATE(WS-RGSTER-RD-INDX)                     
                 MOVE +08                  TO MI-PRV-COLUMN-VALUE-LEN   
                                              MI-CHG-COLUMN-VALUE-LEN   
                 MOVE WS-PREV-LAST-REG-READ-TM                          
                                           TO MI-PRV-COLUMN-VALUE-TEXT  
                 MOVE RG-LAST-REG-READ-TM  TO MI-CHG-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +08                  TO MI-PRV-COLUMN-VALUE-LEN   
                                              MI-CHG-COLUMN-VALUE-LEN   
                 MOVE WS-PREV-LAST-REG-READ-TM                          
                                           TO MI-PRV-COLUMN-VALUE-TEXT  
                 MOVE '*DELETED'           TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'Regular Read Tm'                                    
                                           TO MI-COLUMN-DESC            
              MOVE SPACES                  TO MI-TABLE-ID               
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD +1                       TO MI-TRAN-APPL-NO           
           END-IF.                                                      
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 5110-MOVE-LST-RD-VALUE                                         *        
      ******************************************************************        
       5110-MOVE-LST-RD-VALUE.                                          
           IF REGISTER-UPDATE(WS-RGSTER-RD-INDX)                        
              MOVE +21                   TO MI-PRV-COLUMN-VALUE-LEN     
                                            MI-CHG-COLUMN-VALUE-LEN     
              MOVE WS-PREV-LAST-VAL-RD-VALUE                            
                                        TO                              
ACT086                                  WS-LAST-VAL-RD-VALUE-TX-N       
ACT086        MOVE WS-LAST-VAL-RD-VALUE-TX-N                            
ACT086                                  TO                              
ACT086                                  WS-LAST-VAL-RD-VALUE-Z          
ACT086        MOVE WS-LAST-VAL-RD-VALUE-Z                               
                                        TO MI-PRV-COLUMN-VALUE-TEXT     
ACT086        INITIALIZE WS-LAST-VAL-RD-VALUE-TX-N                      
ACT086                   WS-LAST-VAL-RD-VALUE-Z                         
ACT086*                                                                         
              MOVE RG-LAST-VAL-RD-VALUE                                 
                                        TO                              
ACT086                                  WS-LAST-VAL-RD-VALUE-TX-N       
ACT086        MOVE WS-LAST-VAL-RD-VALUE-TX-N                            
ACT086                                  TO                              
ACT086                                  WS-LAST-VAL-RD-VALUE-Z          
ACT086        MOVE WS-LAST-VAL-RD-VALUE-Z                               
                                        TO MI-CHG-COLUMN-VALUE-TEXT     
      *                                                                         
           ELSE                                                         
              MOVE +21                  TO MI-PRV-COLUMN-VALUE-LEN      
              MOVE +08                  TO MI-CHG-COLUMN-VALUE-LEN      
              MOVE WS-PREV-LAST-VAL-RD-VALUE                            
                                        TO                              
ACT086                                  WS-LAST-VAL-RD-VALUE-TX-N       
ACT086        MOVE WS-LAST-VAL-RD-VALUE-TX-N                            
ACT086                                  TO                              
ACT086                                  WS-LAST-VAL-RD-VALUE-Z          
ACT086        MOVE WS-LAST-VAL-RD-VALUE-Z                               
                                        TO MI-PRV-COLUMN-VALUE-TEXT     
      *                                                                         
              MOVE '*DELETED'           TO MI-CHG-COLUMN-VALUE-TEXT     
           END-IF.                                                      
                                                                        
       5110-EXIT.                                                       
      ******************************************************************        
      *                                                                *        
      * 5111-MOVE-LST-RD-DIAL                                          *        
      ******************************************************************        
       5111-MOVE-LST-RD-DIAL.                                           
           IF REGISTER-UPDATE(WS-RGSTER-RD-INDX)                        
ACT086*                                                                         
              MOVE WS-PREV-LAST-VAL-RD-VALUE                            
                                        TO                              
                                        WS-LAST-VAL-RD-VALUE-UNPACK     
              IF WS-NO-READ-DIALS = 5                                   
                 MOVE +06               TO MI-PRV-COLUMN-VALUE-LEN      
                                           MI-CHG-COLUMN-VALUE-LEN      
                 MOVE WS-LAST-VAL-RD-VALUE-TEXT(08:05)                  
                                        TO WS-DIAL-NO-5-NUM             
ACT086           MOVE WS-DIAL-NO-5-NUM                                  
                                        TO MI-PRV-COLUMN-VALUE-TEXT     
              ELSE                                                      
                 IF WS-NO-READ-DIALS = 6                                
                    MOVE +07               TO MI-PRV-COLUMN-VALUE-LEN   
                                           MI-CHG-COLUMN-VALUE-LEN      
                    MOVE WS-LAST-VAL-RD-VALUE-TEXT(07:06)               
                                           TO WS-DIAL-NO-6-NUM          
ACT086              MOVE WS-DIAL-NO-6-NUM                               
                                           TO MI-PRV-COLUMN-VALUE-TEXT  
                 ELSE                                                   
                    MOVE +05               TO MI-PRV-COLUMN-VALUE-LEN   
                                              MI-CHG-COLUMN-VALUE-LEN   
                    MOVE  WS-LAST-VAL-RD-VALUE-TEXT(09:04)              
                                           TO WS-DIAL-NO-4-NUM          
ACT086              MOVE WS-DIAL-NO-4-NUM                               
                                           TO MI-PRV-COLUMN-VALUE-TEXT  
                 END-IF                                                 
              END-IF                                                    
              INITIALIZE WS-LAST-VAL-RD-VALUE-UNPACK                    
              MOVE RG-LAST-VAL-RD-VALUE                                 
                                        TO                              
                                        WS-LAST-VAL-RD-VALUE-UNPACK     
              IF WS-NO-READ-DIALS = 5                                   
                 MOVE +06               TO MI-PRV-COLUMN-VALUE-LEN      
                                           MI-CHG-COLUMN-VALUE-LEN      
                 MOVE WS-LAST-VAL-RD-VALUE-TEXT(08:05)                  
                                        TO WS-DIAL-NO-5-NUM             
ACT086           MOVE WS-DIAL-NO-5-NUM                                  
                                        TO MI-CHG-COLUMN-VALUE-TEXT     
              ELSE                                                      
                 IF WS-NO-READ-DIALS = 6                                
                    MOVE +07               TO MI-PRV-COLUMN-VALUE-LEN   
                                              MI-CHG-COLUMN-VALUE-LEN   
                    MOVE  WS-LAST-VAL-RD-VALUE-TEXT(07:06)              
                                           TO WS-DIAL-NO-6-NUM          
ACT086              MOVE WS-DIAL-NO-6-NUM                               
                                           TO MI-CHG-COLUMN-VALUE-TEXT  
                 ELSE                                                   
                    MOVE +05               TO MI-PRV-COLUMN-VALUE-LEN   
                                              MI-CHG-COLUMN-VALUE-LEN   
                    MOVE  WS-LAST-VAL-RD-VALUE-TEXT(09:04)              
                                           TO WS-DIAL-NO-4-NUM          
ACT086              MOVE WS-DIAL-NO-4-NUM                               
                                           TO MI-CHG-COLUMN-VALUE-TEXT  
                 END-IF                                                 
              END-IF                                                    
      *                                                                         
           ELSE                                                         
              MOVE WS-PREV-LAST-VAL-RD-VALUE                            
                                        TO                              
                                        WS-LAST-VAL-RD-VALUE-UNPACK     
              IF WS-NO-READ-DIALS = 5                                   
                 MOVE +06               TO MI-PRV-COLUMN-VALUE-LEN      
                 MOVE WS-LAST-VAL-RD-VALUE-TEXT(08:05)                  
                                        TO WS-DIAL-NO-5-NUM             
ACT086           MOVE WS-DIAL-NO-5-NUM                                  
                                        TO MI-PRV-COLUMN-VALUE-TEXT     
              ELSE                                                      
                 IF WS-NO-READ-DIALS = 6                                
                    MOVE +07               TO MI-PRV-COLUMN-VALUE-LEN   
                    MOVE WS-LAST-VAL-RD-VALUE-TEXT(07:06)               
                                           TO WS-DIAL-NO-6-NUM          
ACT086              MOVE WS-DIAL-NO-6-NUM                               
                                           TO MI-PRV-COLUMN-VALUE-TEXT  
                 ELSE                                                   
                    MOVE +05               TO MI-PRV-COLUMN-VALUE-LEN   
                    MOVE WS-LAST-VAL-RD-VALUE-TEXT(09:04)               
                                           TO WS-DIAL-NO-4-NUM          
ACT086              MOVE WS-DIAL-NO-4-NUM                               
                                           TO MI-PRV-COLUMN-VALUE-TEXT  
                 END-IF                                                 
              END-IF                                                    
      *                                                                         
              MOVE +08                  TO MI-CHG-COLUMN-VALUE-LEN      
              MOVE '*DELETED'           TO MI-CHG-COLUMN-VALUE-TEXT     
           END-IF.                                                      
                                                                        
       5111-EXIT.                                                       
      ******************************************************************        
      *                                                                *        
      * 5112-MOVE-LST-RD-DIAL                                          *        
      ******************************************************************        
       5112-MOVE-LST-RD-DIAL.                                           
           IF REGISTER-UPDATE(WS-RGSTER-RD-INDX)                        
              MOVE MN-LAST-VAL-RD-VALUE                                 
                                        TO                              
                                        WS-LAST-VAL-RD-VALUE-UNPACK     
              IF WS-NO-READ-DIALS = 5                                   
                 MOVE +06               TO MI-PRV-COLUMN-VALUE-LEN      
                                           MI-CHG-COLUMN-VALUE-LEN      
                 MOVE WS-LAST-VAL-RD-VALUE-TEXT(08:5)                   
ACT086                                  TO WS-DIAL-NO-5-NUM             
ACT086           MOVE WS-DIAL-NO-5-NUM                                  
                                        TO MI-PRV-COLUMN-VALUE-TEXT     
              ELSE                                                      
                 IF WS-NO-READ-DIALS = 6                                
                    MOVE +07               TO MI-PRV-COLUMN-VALUE-LEN   
                                              MI-CHG-COLUMN-VALUE-LEN   
                    MOVE WS-LAST-VAL-RD-VALUE-TEXT(07:6)                
                                           TO WS-DIAL-NO-6-NUM          
ACT086              MOVE WS-DIAL-NO-5-NUM                               
                                           TO MI-PRV-COLUMN-VALUE-TEXT  
                 ELSE                                                   
                    MOVE +05               TO MI-PRV-COLUMN-VALUE-LEN   
                                              MI-CHG-COLUMN-VALUE-LEN   
                    MOVE WS-LAST-VAL-RD-VALUE-TEXT(09:4)                
                                           TO WS-DIAL-NO-4-NUM          
ACT086              MOVE WS-DIAL-NO-4-NUM                               
                                           TO MI-PRV-COLUMN-VALUE-TEXT  
                 END-IF                                                 
              END-IF                                                    
              INITIALIZE WS-LAST-VAL-RD-VALUE-UNPACK                    
              MOVE RG-LAST-VAL-RD-VALUE                                 
                                        TO                              
                                        WS-LAST-VAL-RD-VALUE-UNPACK     
              IF WS-NO-READ-DIALS = 5                                   
                 MOVE +06               TO MI-PRV-COLUMN-VALUE-LEN      
                                           MI-CHG-COLUMN-VALUE-LEN      
                 MOVE WS-LAST-VAL-RD-VALUE-TEXT(08:5)                   
                                        TO WS-DIAL-NO-5-NUM             
ACT086           MOVE WS-DIAL-NO-5-NUM                                  
                                        TO MI-CHG-COLUMN-VALUE-TEXT     
              ELSE                                                      
                 IF WS-NO-READ-DIALS = 6                                
                    MOVE +07               TO MI-PRV-COLUMN-VALUE-LEN   
                                              MI-CHG-COLUMN-VALUE-LEN   
                    MOVE WS-LAST-VAL-RD-VALUE-TEXT(07:6)                
                                           TO WS-DIAL-NO-6-NUM          
ACT086              MOVE WS-DIAL-NO-6-NUM                               
                                           TO MI-CHG-COLUMN-VALUE-TEXT  
                 ELSE                                                   
                    MOVE +05               TO MI-PRV-COLUMN-VALUE-LEN   
                                              MI-CHG-COLUMN-VALUE-LEN   
                    MOVE WS-LAST-VAL-RD-VALUE-TEXT(09:4)                
                                           TO WS-DIAL-NO-4-NUM          
ACT086              MOVE WS-DIAL-NO-4-NUM                               
                                           TO MI-CHG-COLUMN-VALUE-TEXT  
                 END-IF                                                 
              END-IF                                                    
      *                                                                         
           ELSE                                                         
              MOVE WS-PREV-LAST-VAL-RD-VALUE                            
                                        TO                              
                                        WS-LAST-VAL-RD-VALUE-UNPACK     
              IF WS-NO-READ-DIALS = 5                                   
                 MOVE +06               TO MI-PRV-COLUMN-VALUE-LEN      
                 MOVE WS-LAST-VAL-RD-VALUE-TEXT(08:5)                   
                                        TO WS-DIAL-NO-5-NUM             
ACT086           MOVE WS-DIAL-NO-5-NUM                                  
                                        TO MI-PRV-COLUMN-VALUE-TEXT     
              ELSE                                                      
                 IF WS-NO-READ-DIALS = 6                                
                    MOVE +08               TO MI-PRV-COLUMN-VALUE-LEN   
                    MOVE WS-LAST-VAL-RD-VALUE-TEXT(07:6)                
                                           TO WS-DIAL-NO-6-NUM          
ACT086              MOVE WS-DIAL-NO-6-NUM                               
                                           TO MI-PRV-COLUMN-VALUE-TEXT  
                 ELSE                                                   
                    MOVE +05               TO MI-PRV-COLUMN-VALUE-LEN   
                    MOVE WS-LAST-VAL-RD-VALUE-TEXT(09:4)                
                                           TO WS-DIAL-NO-4-NUM          
ACT086              MOVE WS-DIAL-NO-4-NUM                               
                                           TO MI-PRV-COLUMN-VALUE-TEXT  
                 END-IF                                                 
              END-IF                                                    
      *                                                                         
              MOVE +08                  TO MI-CHG-COLUMN-VALUE-LEN      
              MOVE '*DELETED'           TO MI-CHG-COLUMN-VALUE-TEXT     
           END-IF.                                                      
                                                                        
       5112-EXIT.                                                       
      ******************************************************************        
      *                                                                *        
      * 5113-MOVE-LST-RD-VALUE                                         *        
      ******************************************************************        
       5113-MOVE-LST-RD-VALUE.                                          
           IF REGISTER-UPDATE(WS-RGSTER-RD-INDX)                        
              MOVE +21                  TO MI-PRV-COLUMN-VALUE-LEN      
                                           MI-CHG-COLUMN-VALUE-LEN      
              MOVE MN-LAST-VAL-RD-VALUE                                 
                                        TO                              
ACT086                                  WS-LAST-VAL-RD-VALUE-TX-N       
ACT086        MOVE WS-LAST-VAL-RD-VALUE-TX-N                            
ACT086                                  TO                              
ACT086                                  WS-LAST-VAL-RD-VALUE-Z          
ACT086        MOVE WS-LAST-VAL-RD-VALUE-Z                               
                                        TO MI-PRV-COLUMN-VALUE-TEXT     
ACT086        INITIALIZE WS-LAST-VAL-RD-VALUE-TX-N                      
ACT086                   WS-LAST-VAL-RD-VALUE-Z                         
                                                                        
              MOVE RG-LAST-VAL-RD-VALUE                                 
                                        TO                              
ACT086                                  WS-LAST-VAL-RD-VALUE-TX-N       
ACT086        MOVE WS-LAST-VAL-RD-VALUE-TX-N                            
ACT086                                  TO                              
ACT086                                  WS-LAST-VAL-RD-VALUE-Z          
ACT086        MOVE WS-LAST-VAL-RD-VALUE-Z                               
                                        TO MI-CHG-COLUMN-VALUE-TEXT     
      *                                                                         
           ELSE                                                         
              MOVE +21                  TO MI-PRV-COLUMN-VALUE-LEN      
              MOVE +08                  TO MI-CHG-COLUMN-VALUE-LEN      
              MOVE WS-PREV-LAST-VAL-RD-VALUE                            
                                        TO                              
ACT086                                  WS-LAST-VAL-RD-VALUE-TX-N       
ACT086        MOVE WS-LAST-VAL-RD-VALUE-TX-N                            
ACT086                                  TO                              
ACT086                                  WS-LAST-VAL-RD-VALUE-Z          
ACT086        MOVE WS-LAST-VAL-RD-VALUE-Z                               
                                        TO MI-PRV-COLUMN-VALUE-TEXT     
      *                                                                         
              MOVE '*DELETED'           TO MI-CHG-COLUMN-VALUE-TEXT     
           END-IF.                                                      
                                                                        
       5113-EXIT.                                                       
      ******************************************************************        
      *                                                                *        
      * 5120-MOVE-REG-RD-VALUE                                         *        
      ******************************************************************        
       5120-MOVE-REG-RD-VALUE.                                          
           IF REGISTER-UPDATE(WS-RGSTER-RD-INDX)                        
              MOVE +21                  TO MI-PRV-COLUMN-VALUE-LEN      
                                           MI-CHG-COLUMN-VALUE-LEN      
                                                                        
ACT086        MOVE WS-PREV-LAST-READ-VALUE                              
ACT086                                  TO                              
ACT086                                  WS-LAST-VAL-RD-VALUE-TX-N       
ACT086        MOVE WS-LAST-VAL-RD-VALUE-TX-N                            
ACT086                                  TO                              
ACT086                                  WS-LAST-VAL-RD-VALUE-Z          
ACT086        MOVE WS-LAST-VAL-RD-VALUE-Z                               
                                        TO MI-PRV-COLUMN-VALUE-TEXT     
                                                                        
ACT086        MOVE RG-LAST-READ-VALUE   TO WS-LAST-VAL-RD-VALUE-TX-N    
ACT086        MOVE WS-LAST-VAL-RD-VALUE-TX-N                            
ACT086                                  TO                              
ACT086                                  WS-LAST-VAL-RD-VALUE-Z          
ACT086        MOVE WS-LAST-VAL-RD-VALUE-Z                               
                                        TO MI-CHG-COLUMN-VALUE-TEXT     
                                                                        
           ELSE                                                         
              MOVE +21                  TO MI-PRV-COLUMN-VALUE-LEN      
              MOVE +08                  TO MI-CHG-COLUMN-VALUE-LEN      
ACT086        MOVE WS-PREV-LAST-READ-VALUE                              
ACT086                                  TO WS-LAST-VAL-RD-VALUE-TX-N    
ACT086        MOVE WS-LAST-VAL-RD-VALUE-TX-N                            
ACT086                                  TO                              
ACT086                                  WS-LAST-VAL-RD-VALUE-Z          
ACT086        MOVE WS-LAST-VAL-RD-VALUE-Z                               
                                        TO MI-PRV-COLUMN-VALUE-TEXT     
                                                                        
              MOVE '*DELETED'           TO MI-CHG-COLUMN-VALUE-TEXT     
           END-IF.                                                      
                                                                        
       5120-EXIT.                                                       
      ******************************************************************        
      *                                                                *        
      * 5121-MOVE-REG-RD-DIAL                                          *        
      ******************************************************************        
       5121-MOVE-REG-RD-DIAL.                                           
           IF REGISTER-UPDATE(WS-RGSTER-RD-INDX)                        
                                                                        
              MOVE WS-PREV-LAST-READ-VALUE                              
                                         TO                             
                                           WS-LAST-READ-VALUE-UNPACK    
              IF WS-NO-READ-DIALS = 5                                   
                 MOVE +06                TO MI-PRV-COLUMN-VALUE-LEN     
                                            MI-CHG-COLUMN-VALUE-LEN     
                 MOVE WS-LAST-READ-VALUE-TEXT(08:5)                     
                                         TO WS-DIAL-NO-5-NUM            
ACT086           MOVE WS-DIAL-NO-5-NUM   TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 IF WS-NO-READ-DIALS = 6                                
                    MOVE +07                TO MI-PRV-COLUMN-VALUE-LEN  
                                               MI-CHG-COLUMN-VALUE-LEN  
                    MOVE WS-LAST-READ-VALUE-TEXT(07:6)                  
                                            TO WS-DIAL-NO-6-NUM         
ACT086              MOVE WS-DIAL-NO-6-NUM   TO MI-PRV-COLUMN-VALUE-TEXT 
                 ELSE                                                   
                    MOVE +05                TO MI-PRV-COLUMN-VALUE-LEN  
                                               MI-CHG-COLUMN-VALUE-LEN  
                    MOVE WS-LAST-READ-VALUE-TEXT(09:4)                  
                                            TO WS-DIAL-NO-4-NUM         
ACT086              MOVE WS-DIAL-NO-4-NUM   TO MI-PRV-COLUMN-VALUE-TEXT 
                 END-IF                                                 
              END-IF                                                    
      * CHANGED LAST VALID READ VALUE                                           
              MOVE RG-LAST-READ-VALUE                                   
                                         TO                             
                                           WS-LAST-READ-VALUE-UNPACK    
              IF WS-NO-READ-DIALS = 5                                   
                 MOVE +06                TO MI-PRV-COLUMN-VALUE-LEN     
                                            MI-CHG-COLUMN-VALUE-LEN     
                 MOVE WS-LAST-READ-VALUE-TEXT(08:05)                    
                                         TO WS-DIAL-NO-5-NUM            
ACT086           MOVE WS-DIAL-NO-5-NUM   TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 IF WS-NO-READ-DIALS = 6                                
                    MOVE +07                TO MI-PRV-COLUMN-VALUE-LEN  
                                               MI-CHG-COLUMN-VALUE-LEN  
                    MOVE WS-LAST-READ-VALUE-TEXT(07:06)                 
                                            TO WS-DIAL-NO-6-NUM         
ACT086              MOVE WS-DIAL-NO-6-NUM   TO MI-CHG-COLUMN-VALUE-TEXT 
                 ELSE                                                   
                    MOVE +05                TO MI-PRV-COLUMN-VALUE-LEN  
                                               MI-CHG-COLUMN-VALUE-LEN  
                    MOVE WS-LAST-READ-VALUE-TEXT(09:04)                 
                                            TO WS-DIAL-NO-4-NUM         
ACT086              MOVE WS-DIAL-NO-4-NUM   TO MI-CHG-COLUMN-VALUE-TEXT 
                 END-IF                                                 
              END-IF                                                    
                                                                        
           ELSE                                                         
              MOVE +08                   TO MI-CHG-COLUMN-VALUE-LEN     
                                                                        
              MOVE WS-PREV-LAST-READ-VALUE                              
                                         TO                             
                                           WS-LAST-READ-VALUE-UNPACK    
                                                                        
              IF WS-NO-READ-DIALS = 5                                   
                 MOVE +06                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE WS-LAST-READ-VALUE-TEXT(08:05)                    
                                         TO WS-DIAL-NO-5-NUM            
ACT086           MOVE WS-DIAL-NO-5-NUM   TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 IF WS-NO-READ-DIALS = 6                                
                    MOVE +07                TO MI-PRV-COLUMN-VALUE-LEN  
                    MOVE WS-LAST-READ-VALUE-TEXT(07:06)                 
                                            TO WS-DIAL-NO-6-NUM         
ACT086              MOVE WS-DIAL-NO-6-NUM   TO MI-PRV-COLUMN-VALUE-TEXT 
                 ELSE                                                   
                    MOVE +05                TO MI-PRV-COLUMN-VALUE-LEN  
                    MOVE WS-LAST-READ-VALUE-TEXT(09:04)                 
                                            TO WS-DIAL-NO-4-NUM         
ACT086              MOVE WS-DIAL-NO-4-NUM   TO MI-PRV-COLUMN-VALUE-TEXT 
                 END-IF                                                 
              END-IF                                                    
              MOVE '*DELETED'           TO MI-CHG-COLUMN-VALUE-TEXT     
           END-IF.                                                      
                                                                        
       5121-EXIT.                                                       
      ******************************************************************        
      *                                                                *        
      * 5122-MOVE-REG-RD-DIAL                                          *        
      ******************************************************************        
       5122-MOVE-REG-RD-DIAL.                                           
           IF REGISTER-UPDATE(WS-RGSTER-RD-INDX)                        
                                                                        
              MOVE MN-LAST-READ-VALUE                                   
                                         TO                             
                                           WS-LAST-READ-VALUE-UNPACK    
              IF WS-NO-READ-DIALS = 5                                   
                 MOVE +06                TO MI-PRV-COLUMN-VALUE-LEN     
                                            MI-CHG-COLUMN-VALUE-LEN     
                 MOVE WS-LAST-READ-VALUE-TEXT(8:05)                     
                                         TO WS-DIAL-NO-5-NUM            
ACT086           MOVE WS-DIAL-NO-5-NUM   TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 IF WS-NO-READ-DIALS = 6                                
                    MOVE +07                TO MI-PRV-COLUMN-VALUE-LEN  
                                               MI-CHG-COLUMN-VALUE-LEN  
                    MOVE WS-LAST-READ-VALUE-TEXT(7:06)                  
                                            TO WS-DIAL-NO-6-NUM         
ACT086              MOVE WS-DIAL-NO-6-NUM   TO MI-PRV-COLUMN-VALUE-TEXT 
                 ELSE                                                   
                    MOVE +05                TO MI-PRV-COLUMN-VALUE-LEN  
                                               MI-CHG-COLUMN-VALUE-LEN  
                    MOVE WS-LAST-READ-VALUE-TEXT(9:04)                  
                                            TO WS-DIAL-NO-4-NUM         
ACT086              MOVE WS-DIAL-NO-4-NUM   TO MI-PRV-COLUMN-VALUE-TEXT 
                    END-IF                                              
              END-IF                                                    
      * CHANGED LAST VALID READ VALUE                                           
              MOVE RG-LAST-READ-VALUE                                   
                                         TO                             
                                           WS-LAST-READ-VALUE-UNPACK    
              IF WS-NO-READ-DIALS = 5                                   
                 MOVE +06                TO MI-PRV-COLUMN-VALUE-LEN     
                                            MI-CHG-COLUMN-VALUE-LEN     
                 MOVE WS-LAST-READ-VALUE-TEXT(08:05)                    
                                         TO WS-DIAL-NO-5-NUM            
ACT086           MOVE WS-DIAL-NO-5-NUM   TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 IF WS-NO-READ-DIALS = 6                                
                    MOVE +07                TO MI-PRV-COLUMN-VALUE-LEN  
                                               MI-CHG-COLUMN-VALUE-LEN  
                    MOVE WS-LAST-READ-VALUE-TEXT(07:06)                 
                                            TO WS-DIAL-NO-6-NUM         
ACT086              MOVE WS-DIAL-NO-6-NUM   TO MI-CHG-COLUMN-VALUE-TEXT 
                 ELSE                                                   
                    MOVE +05                TO MI-PRV-COLUMN-VALUE-LEN  
                                               MI-CHG-COLUMN-VALUE-LEN  
                    MOVE WS-LAST-READ-VALUE-TEXT(09:04)                 
                                            TO WS-DIAL-NO-4-NUM         
ACT086              MOVE WS-DIAL-NO-4-NUM   TO MI-CHG-COLUMN-VALUE-TEXT 
                 END-IF                                                 
              END-IF                                                    
                                                                        
           ELSE                                                         
              MOVE +08                   TO MI-CHG-COLUMN-VALUE-LEN     
                                                                        
              MOVE WS-PREV-LAST-READ-VALUE                              
                                         TO                             
                                           WS-LAST-READ-VALUE-UNPACK    
              IF WS-NO-READ-DIALS = 5                                   
                 MOVE +06                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE WS-LAST-READ-VALUE-TEXT(08:05)                    
                                         TO WS-DIAL-NO-5-NUM            
ACT086           MOVE WS-DIAL-NO-5-NUM   TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 IF WS-NO-READ-DIALS = 6                                
                    MOVE +07                TO MI-PRV-COLUMN-VALUE-LEN  
                    MOVE WS-LAST-READ-VALUE-TEXT(07:06)                 
                                            TO WS-DIAL-NO-6-NUM         
ACT086              MOVE WS-DIAL-NO-6-NUM   TO MI-PRV-COLUMN-VALUE-TEXT 
                 ELSE                                                   
                    MOVE +05                TO MI-PRV-COLUMN-VALUE-LEN  
                    MOVE WS-LAST-READ-VALUE-TEXT(09:04)                 
                                            TO WS-DIAL-NO-4-NUM         
ACT086              MOVE WS-DIAL-NO-4-NUM   TO MI-PRV-COLUMN-VALUE-TEXT 
                 END-IF                                                 
              END-IF                                                    
              MOVE '*DELETED'           TO MI-CHG-COLUMN-VALUE-TEXT     
           END-IF.                                                      
                                                                        
       5122-EXIT.                                                       
      ******************************************************************        
      *                                                                *        
      * 5123-MOVE-REG-RD-VALUE                                         *        
      ******************************************************************        
       5123-MOVE-REG-RD-VALUE.                                          
           IF REGISTER-UPDATE(WS-RGSTER-RD-INDX)                        
              MOVE +21                  TO MI-PRV-COLUMN-VALUE-LEN      
                                           MI-CHG-COLUMN-VALUE-LEN      
              MOVE MN-LAST-READ-VALUE                                   
                                        TO                              
ACT086                                  WS-LAST-VAL-RD-VALUE-TX-N       
ACT086        MOVE WS-LAST-VAL-RD-VALUE-TX-N                            
ACT086                                  TO                              
ACT086                                  WS-LAST-VAL-RD-VALUE-Z          
ACT086        MOVE WS-LAST-VAL-RD-VALUE-Z                               
                                        TO MI-PRV-COLUMN-VALUE-TEXT     
      *                                                                         
              MOVE RG-LAST-READ-VALUE                                   
                                        TO                              
ACT086                                  WS-LAST-VAL-RD-VALUE-TX-N       
ACT086        MOVE WS-LAST-VAL-RD-VALUE-TX-N                            
ACT086                                  TO                              
ACT086                                  WS-LAST-VAL-RD-VALUE-Z          
ACT086        MOVE WS-LAST-VAL-RD-VALUE-Z                               
                                        TO MI-CHG-COLUMN-VALUE-TEXT     
   *                                                                    
           ELSE                                                         
              MOVE +21                  TO MI-PRV-COLUMN-VALUE-LEN      
              MOVE +08                  TO MI-CHG-COLUMN-VALUE-LEN      
              MOVE WS-PREV-LAST-READ-VALUE                              
                                        TO                              
ACT086                                  WS-LAST-VAL-RD-VALUE-TX-N       
ACT086        MOVE WS-LAST-VAL-RD-VALUE-TX-N                            
ACT086                                  TO                              
ACT086                                  WS-LAST-VAL-RD-VALUE-Z          
ACT086        MOVE WS-LAST-VAL-RD-VALUE-Z                               
                                        TO MI-PRV-COLUMN-VALUE-TEXT     
   *                                                                    
              MOVE '*DELETED'           TO MI-CHG-COLUMN-VALUE-TEXT     
           END-IF.                                                      
                                                                        
       5123-EXIT.                                                       
      ******************************************************************        
      *                                                                *        
      * 5200-WRITE-TRANS-HIST.                                       *          
      ******************************************************************        
       5200-WRITE-TRANS-HIST.                                           
                                                                        
           PERFORM 7010-GET-CURR-TIMESTAMP     THRU 7010-EXIT.          
           PERFORM 7015-GET-RESP-AREA-ID       THRU 7015-EXIT.          
                                                                        
      *    WRITE A TRANSACTION HISTORY FOR THE HEADER ROW                       
           MOVE 'F'                         TO MH-CODE-TRAN-TYPE.       
           MOVE WS-RESP-AREA-ID             TO MH-RESP-AREA-ID.         
           MOVE MN-ACCOUNT-NO               TO MH-ACCOUNT-NO.           
           MOVE WS-ZERO                     TO MH-CUSTOMER-NO.          
           MOVE WS-ZERO                     TO MH-PREMISE-NO.           
           MOVE WS-LAST-UPDATE-USERID       TO MH-USER-ID.              
           MOVE 'CSR04644R'                 TO MH-APPL-PROGRAM-ID.      
           MOVE WS-ENTITY-KEY-DESC          TO MH-ENTITY-KEY-DESC-TEXT. 
           MOVE WS-REGISTER-LEN             TO MH-ENTITY-KEY-DESC-LEN.  
           MOVE WS-COMMENT-LEN              TO MH-TRAN-COMMENT-LEN      
           MOVE WS-COMMENT                  TO MH-TRAN-COMMENT-TEXT     
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO        TO MI-TRANS-HIST-SEQ-NO.    
           MOVE 1                           TO MI-TRAN-APPL-NO.         
                                                                        
      * WRITING METER NO IN TRAN HIST DETAIL                                    
           MOVE +13                         TO MI-PRV-COLUMN-VALUE-LEN  
                                               MI-CHG-COLUMN-VALUE-LEN. 
                                                                        
           MOVE WS-TRAN-METER-NO            TO MI-PRV-COLUMN-VALUE-TEXT 
                                               MI-CHG-COLUMN-VALUE-TEXT.
           MOVE 'METER NO'                  TO MI-COLUMN-DESC.          
           MOVE SPACES                      TO MI-TABLE-ID.             
           PERFORM 6530-LOAD-MNT-TRANS-HIST       THRU 6530-EXIT.       
           ADD +1                           TO MI-TRAN-APPL-NO.         
      * METER  NUMBER ENDS HERE                                                 
                                                                        
      * WRITING REG HEADER IN TRAN HIST DETAIL                                  
           MOVE +51                         TO MI-PRV-COLUMN-VALUE-LEN  
                                               MI-CHG-COLUMN-VALUE-LEN. 
                                                                        
      * GET CODE VALUE FOR REG CODE_TIME_PERIOD                                 
           IF RG-CODE-TIME-PERIOD    = ZERO                             
              MOVE SPACES                   TO WS-REG-CODETIME-DESC     
           ELSE                                                         
              MOVE +16                      TO UV-COLUMN-NA-LEN         
              MOVE 'CODE_TIME_PERIOD'       TO UV-COLUMN-NA-TEXT        
              MOVE +17                      TO UV-TABLE-NA-LEN          
              MOVE 'CSS_REGISTER_READ'      TO UV-TABLE-NA-TEXT         
              MOVE 01                       TO UV-CODE-VALUE-LEN        
              MOVE 'ALL'                    TO UV-PROGRAM-ID            
              MOVE AT-COMPANY-NO            TO UV-COMPANY-NO            
              MOVE RG-CODE-TIME-PERIOD      TO WS-TIME-PRD-TXT          
              MOVE WS-TIME-PRD-TXT(4:1)     TO UV-CODE-VALUE-TEXT       
              PERFORM 7260-GET-CODE-VALUE         THRU 7260-EXIT        
              MOVE LENGTH OF UV-CODE-SHORT-DESC-TEXT                    
                                            TO UV-CODE-SHORT-DESC-LEN   
              MOVE FUNCTION UPPER-CASE(UV-CODE-SHORT-DESC-TEXT)         
                                            TO                          
                                            UV-CODE-SHORT-DESC-TEXT     
              MOVE UV-CODE-SHORT-DESC-TEXT  TO WS-REG-CODETIME-DESC     
           END-IF.                                                      
                                                                        
           STRING WS-REG-USAGE-DESC DELIMITED BY '  ' ' ' DELIMITED     
                   BY SIZE WS-REG-CODETIME-DESC DELIMITED BY '  ' INTO  
                   WS-REG-USAGE-CODETIME-DESC.                          
                                                                        
           MOVE WS-REG-USAGE-CODETIME-DESC  TO MI-PRV-COLUMN-VALUE-TEXT 
                                               MI-CHG-COLUMN-VALUE-TEXT.
      *                                                                         
           INITIALIZE  UV-CODE-VALUE-TEXT                               
                       UV-CODE-LONG-DESC-TEXT.                          
           MOVE '01'                        TO UV-COMPANY-NO.           
      *                                                                         
           MOVE 'REGISTER '                 TO MI-COLUMN-DESC.          
           MOVE SPACES                      TO MI-TABLE-ID.             
           PERFORM 6530-LOAD-MNT-TRANS-HIST       THRU 6530-EXIT.       
           ADD +1                           TO MI-TRAN-APPL-NO.         
      * REG HEADER ENDS HERE                                                    
                                                                        
           IF RG-CODE-REG-STATUS NOT EQUAL MN-CODE-METER-STATUS         
                                                                        
              IF RG-CODE-REG-STATUS EQUAL 'A'                           
                 MOVE SPACES               TO  MN-METER-INACTIVE-DT     
                                               MN-METER-REMOVED-DT      
              END-IF                                                    
                                                                        
              IF (RG-CODE-REG-STATUS EQUAL 'K' AND                      
                  MN-CODE-METER-STATUS NOT EQUAL 'J')                   
               OR RG-CODE-REG-STATUS EQUAL 'J'                          
                 MOVE WS-CURRENT-DATE      TO MN-METER-INACTIVE-DT      
              END-IF                                                    
                                                                        
              IF RG-CODE-REG-STATUS EQUAL 'K'                           
                 MOVE WS-CURRENT-DATE      TO MN-METER-REMOVED-DT       
              END-IF                                                    
                                                                        
              IF REGISTER-UPDATE(WS-RGSTER-RD-INDX)                     
                 MOVE +75                  TO MI-PRV-COLUMN-VALUE-LEN   
                                              MI-CHG-COLUMN-VALUE-LEN   
      *          MOVE MN-CODE-METER-STATUS                                      
      *                                    TO MI-PRV-COLUMN-VALUE-TEXT          
      * GET CODE VALUE                                                          
                 MOVE +17                   TO UV-COLUMN-NA-LEN         
                 MOVE 'CODE_METER_STATUS'   TO UV-COLUMN-NA-TEXT        
                 MOVE +17                   TO UV-TABLE-NA-LEN          
                 MOVE 'CSS_REGISTER_READ'   TO UV-TABLE-NA-TEXT         
                 MOVE 01                    TO UV-CODE-VALUE-LEN        
                 MOVE 75                    TO UV-CODE-LONG-DESC-LEN    
                 MOVE 'ALL'                 TO UV-PROGRAM-ID            
                 MOVE  MN-CODE-METER-STATUS                             
                                            TO UV-CODE-VALUE-TEXT       
                 PERFORM 7260-GET-CODE-VALUE      THRU   7260-EXIT      
                 MOVE UV-CODE-LONG-DESC-TEXT                            
                                            TO MI-PRV-COLUMN-VALUE-TEXT 
      *                                                                         
                 INITIALIZE  UV-CODE-VALUE-TEXT                         
                             UV-CODE-LONG-DESC-TEXT                     
      *                                                                         
      *          MOVE RG-CODE-REG-STATUS   TO MI-CHG-COLUMN-VALUE-TEXT          
                 MOVE  RG-CODE-REG-STATUS                               
                                            TO UV-CODE-VALUE-TEXT       
                 PERFORM 7260-GET-CODE-VALUE      THRU   7260-EXIT      
                 MOVE UV-CODE-LONG-DESC-TEXT                            
                                            TO MI-CHG-COLUMN-VALUE-TEXT 
      *                                                                         
                 INITIALIZE  UV-CODE-VALUE-TEXT                         
                             UV-CODE-LONG-DESC-TEXT                     
MRMCHG*          MOVE +01                  TO MI-PRV-COLUMN-VALUE-LEN           
      *                                       MI-CHG-COLUMN-VALUE-LEN           
              ELSE                                                      
                 MOVE +75                  TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE +08                  TO MI-CHG-COLUMN-VALUE-LEN   
      *                                                                         
      *          MOVE WS-PREV-CODE-REG-STATUS                                   
      *                                    TO MI-PRV-COLUMN-VALUE-TEXT          
                 MOVE +17                   TO UV-COLUMN-NA-LEN         
                 MOVE 'CODE_METER_STATUS'   TO UV-COLUMN-NA-TEXT        
                 MOVE +17                   TO UV-TABLE-NA-LEN          
                 MOVE 'CSS_REGISTER_READ'   TO UV-TABLE-NA-TEXT         
                 MOVE 01                    TO UV-CODE-VALUE-LEN        
                 MOVE 75                    TO UV-CODE-LONG-DESC-LEN    
                 MOVE 'ALL'                 TO UV-PROGRAM-ID            
                 MOVE  WS-PREV-CODE-REG-STATUS                          
                                            TO UV-CODE-VALUE-TEXT       
                 PERFORM 7260-GET-CODE-VALUE      THRU   7260-EXIT      
                 MOVE UV-CODE-LONG-DESC-TEXT                            
                                            TO MI-PRV-COLUMN-VALUE-TEXT 
      *                                                                         
                 INITIALIZE  UV-CODE-VALUE-TEXT                         
                             UV-CODE-LONG-DESC-TEXT                     
      *                                                                         
                 MOVE '*DELETED'           TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'Register Status'       TO MI-COLUMN-DESC            
              MOVE SPACES                  TO MI-TABLE-ID               
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD +1                       TO MI-TRAN-APPL-NO           
              IF RG-REG-ID-NO EQUAL WS-ONE                              
                 MOVE WS-CURRENT-DATE      TO MN-MTR-STATUS-CHNG-DT     
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF RG-CODE-CRNT-REG-READ NOT EQUAL MN-CODE-CRNT-REG-READ     
              IF REGISTER-UPDATE(WS-RGSTER-RD-INDX)                     
                 MOVE +75                  TO MI-PRV-COLUMN-VALUE-LEN   
                                              MI-CHG-COLUMN-VALUE-LEN   
      *          MOVE MN-CODE-CRNT-REG-READ                                     
      *                                    TO MI-PRV-COLUMN-VALUE-TEXT          
                 MOVE +18                   TO UV-COLUMN-NA-LEN         
                 MOVE 'CODE_CRNT_REG_READ'  TO UV-COLUMN-NA-TEXT        
                 MOVE +17                   TO UV-TABLE-NA-LEN          
                 MOVE 'CSS_REGISTER_READ'   TO UV-TABLE-NA-TEXT         
                 MOVE 01                    TO UV-CODE-VALUE-LEN        
                 MOVE 75                    TO UV-CODE-LONG-DESC-LEN    
                 MOVE 'ALL'                 TO UV-PROGRAM-ID            
                 MOVE  MN-CODE-CRNT-REG-READ                            
                                            TO UV-CODE-VALUE-TEXT       
                 PERFORM 7260-GET-CODE-VALUE      THRU   7260-EXIT      
                 MOVE UV-CODE-LONG-DESC-TEXT                            
                                            TO MI-PRV-COLUMN-VALUE-TEXT 
      *                                                                         
                 INITIALIZE  UV-CODE-VALUE-TEXT                         
                             UV-CODE-LONG-DESC-TEXT                     
      *                                                                         
      *          MOVE RG-CODE-CRNT-REG-READ                                     
      *                                    TO MI-CHG-COLUMN-VALUE-TEXT          
                 MOVE RG-CODE-CRNT-REG-READ                             
                                            TO UV-CODE-VALUE-TEXT       
                 PERFORM 7260-GET-CODE-VALUE      THRU   7260-EXIT      
                 MOVE UV-CODE-LONG-DESC-TEXT                            
                                            TO MI-CHG-COLUMN-VALUE-TEXT 
      *                                                                         
                 INITIALIZE  UV-CODE-VALUE-TEXT                         
                             UV-CODE-LONG-DESC-TEXT                     
              ELSE                                                      
                 MOVE +75                  TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE +08                  TO MI-CHG-COLUMN-VALUE-LEN   
      *          MOVE WS-PREV-CODE-CRNT-REG-READ                                
      *                                    TO MI-PRV-COLUMN-VALUE-TEXT          
                 MOVE +18                   TO UV-COLUMN-NA-LEN         
                 MOVE 'CODE_CRNT_REG_READ'  TO UV-COLUMN-NA-TEXT        
                 MOVE +17                   TO UV-TABLE-NA-LEN          
                 MOVE 'CSS_REGISTER_READ'   TO UV-TABLE-NA-TEXT         
                 MOVE 01                    TO UV-CODE-VALUE-LEN        
                 MOVE 75                    TO UV-CODE-LONG-DESC-LEN    
                 MOVE 'ALL'                 TO UV-PROGRAM-ID            
                 MOVE WS-PREV-CODE-CRNT-REG-READ                        
                                            TO UV-CODE-VALUE-TEXT       
                 PERFORM 7260-GET-CODE-VALUE      THRU   7260-EXIT      
                 MOVE UV-CODE-LONG-DESC-TEXT                            
                                            TO MI-PRV-COLUMN-VALUE-TEXT 
      *                                                                         
                 INITIALIZE  UV-CODE-VALUE-TEXT                         
                             UV-CODE-LONG-DESC-TEXT                     
      *                                                                         
                 MOVE '*DELETED'           TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'Read code'             TO MI-COLUMN-DESC            
              MOVE '30'                    TO MI-TABLE-ID               
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD +1                       TO MI-TRAN-APPL-NO           
           END-IF.                                                      
      * NO READ REASON                                                          
           IF RG-CODE-NO-RD-REASON NOT EQUAL MN-CODE-NO-RD-REASON       
              IF REGISTER-UPDATE(WS-RGSTER-RD-INDX)                     
                 MOVE +35                  TO MI-PRV-COLUMN-VALUE-LEN   
                                              MI-CHG-COLUMN-VALUE-LEN   
      *          MOVE MN-CODE-NO-RD-REASON TO MI-PRV-COLUMN-VALUE-TEXT          
                 MOVE MN-CODE-NO-RD-REASON                              
                                           TO S4-CODE-NO-RD-REASON      
                 PERFORM 7270-GET-NO-READ-REASON  THRU 7270-EXIT        
                 MOVE S4-NO-RD-REASON-DESC TO MI-PRV-COLUMN-VALUE-TEXT  
                 INITIALIZE  DCLCSS-NO-READ-REASON                      
      *          MOVE RG-CODE-NO-RD-REASON TO MI-CHG-COLUMN-VALUE-TEXT          
                 MOVE RG-CODE-NO-RD-REASON                              
                                           TO S4-CODE-NO-RD-REASON      
                 PERFORM 7270-GET-NO-READ-REASON  THRU 7270-EXIT        
                 MOVE S4-NO-RD-REASON-DESC TO MI-CHG-COLUMN-VALUE-TEXT  
                 INITIALIZE  DCLCSS-NO-READ-REASON                      
      *                                                                         
              ELSE                                                      
                 MOVE +35                  TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE +08                  TO MI-CHG-COLUMN-VALUE-LEN   
      *          MOVE WS-PREV-CODE-NO-RD-REASON                                 
      *                                    TO MI-PRV-COLUMN-VALUE-TEXT          
                 MOVE WS-PREV-CODE-NO-RD-REASON                         
                                           TO S4-CODE-NO-RD-REASON      
                 PERFORM 7270-GET-NO-READ-REASON  THRU 7270-EXIT        
                 MOVE S4-NO-RD-REASON-DESC TO MI-PRV-COLUMN-VALUE-TEXT  
                 INITIALIZE  DCLCSS-NO-READ-REASON                      
                 MOVE '*DELETED'           TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'No Read Reason'        TO MI-COLUMN-DESC            
              MOVE SPACES                  TO MI-TABLE-ID               
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD +1                       TO MI-TRAN-APPL-NO           
           END-IF.                                                      
                                                                        
           IF RG-CODE-STATUS-REAS NOT EQUAL MN-CODE-STATUS-REAS         
              IF REGISTER-UPDATE(WS-RGSTER-RD-INDX)                     
                 MOVE +75                  TO MI-PRV-COLUMN-VALUE-LEN   
                                              MI-CHG-COLUMN-VALUE-LEN   
      *          MOVE MN-CODE-STATUS-REAS  TO MI-PRV-COLUMN-VALUE-TEXT          
                 MOVE +16                   TO UV-COLUMN-NA-LEN         
                 MOVE 'CODE_STATUS_REAS'    TO UV-COLUMN-NA-TEXT        
                 MOVE +17                   TO UV-TABLE-NA-LEN          
                 MOVE 'CSS_REGISTER_READ'   TO UV-TABLE-NA-TEXT         
                 MOVE 01                    TO UV-CODE-VALUE-LEN        
                 MOVE 75                    TO UV-CODE-LONG-DESC-LEN    
                 MOVE 'ALL'                 TO UV-PROGRAM-ID            
                 MOVE  MN-CODE-STATUS-REAS                              
                                            TO UV-CODE-VALUE-TEXT       
                 PERFORM 7260-GET-CODE-VALUE      THRU   7260-EXIT      
                 MOVE UV-CODE-LONG-DESC-TEXT                            
                                            TO MI-PRV-COLUMN-VALUE-TEXT 
      *                                                                         
                 INITIALIZE  UV-CODE-VALUE-TEXT                         
                             UV-CODE-LONG-DESC-TEXT                     
      *                                                                         
      *          MOVE RG-CODE-STATUS-REAS  TO MI-CHG-COLUMN-VALUE-TEXT          
                 MOVE RG-CODE-STATUS-REAS                               
                                            TO UV-CODE-VALUE-TEXT       
                 PERFORM 7260-GET-CODE-VALUE      THRU   7260-EXIT      
                 MOVE UV-CODE-LONG-DESC-TEXT                            
                                            TO MI-CHG-COLUMN-VALUE-TEXT 
      *                                                                         
                 INITIALIZE  UV-CODE-VALUE-TEXT                         
                             UV-CODE-LONG-DESC-TEXT                     
              ELSE                                                      
                 MOVE +75                  TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE +08                  TO MI-CHG-COLUMN-VALUE-LEN   
      *          MOVE WS-PREV-CODE-STATUS-REAS                                  
      *                                    TO MI-PRV-COLUMN-VALUE-TEXT          
                 MOVE +16                   TO UV-COLUMN-NA-LEN         
                 MOVE 'CODE_STATUS_REAS'    TO UV-COLUMN-NA-TEXT        
                 MOVE +17                   TO UV-TABLE-NA-LEN          
                 MOVE 'CSS_REGISTER_READ'   TO UV-TABLE-NA-TEXT         
                 MOVE 01                    TO UV-CODE-VALUE-LEN        
                 MOVE 75                    TO UV-CODE-LONG-DESC-LEN    
                 MOVE 'ALL'                 TO UV-PROGRAM-ID            
                 MOVE  WS-PREV-CODE-STATUS-REAS                         
                                            TO UV-CODE-VALUE-TEXT       
                 PERFORM 7260-GET-CODE-VALUE      THRU   7260-EXIT      
                 MOVE UV-CODE-LONG-DESC-TEXT                            
                                            TO MI-PRV-COLUMN-VALUE-TEXT 
      *                                                                         
                 INITIALIZE  UV-CODE-VALUE-TEXT                         
                             UV-CODE-LONG-DESC-TEXT                     
      *                                                                         
                 MOVE '*DELETED'           TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'Reason'                TO MI-COLUMN-DESC            
              MOVE SPACES                  TO MI-TABLE-ID               
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD +1                       TO MI-TRAN-APPL-NO           
           END-IF.                                                      
                                                                        
           IF RG-LAST-VAL-RD-VALUE NOT EQUAL MN-LAST-VAL-RD-VALUE       
              IF DIAL-USAGE-TYPE AND ( WS-NO-READ-DIALS > 0 )           
                 PERFORM 5112-MOVE-LST-RD-DIAL    THRU 5112-EXIT        
              ELSE                                                      
                 PERFORM 5113-MOVE-LST-RD-VALUE   THRU 5113-EXIT        
              END-IF                                                    
                                                                        
              MOVE 'Lst Vald Rd Value'     TO MI-COLUMN-DESC            
              MOVE SPACES                  TO MI-TABLE-ID               
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD +1                       TO MI-TRAN-APPL-NO           
           END-IF.                                                      
                                                                        
           IF RG-CODE-LAST-VALID-RD NOT EQUAL MN-CODE-LAST-VALID-RD     
              IF REGISTER-UPDATE(WS-RGSTER-RD-INDX)                     
                 MOVE +75                  TO MI-PRV-COLUMN-VALUE-LEN   
                                              MI-CHG-COLUMN-VALUE-LEN   
      *          MOVE MN-CODE-LAST-VALID-RD                                     
      *                                    TO MI-PRV-COLUMN-VALUE-TEXT          
                 MOVE +18                   TO UV-COLUMN-NA-LEN         
                 MOVE 'CODE_CRNT_REG_READ'  TO UV-COLUMN-NA-TEXT        
                 MOVE +17                   TO UV-TABLE-NA-LEN          
                 MOVE 'CSS_REGISTER_READ'   TO UV-TABLE-NA-TEXT         
                 MOVE 01                    TO UV-CODE-VALUE-LEN        
                 MOVE 75                    TO UV-CODE-LONG-DESC-LEN    
                 MOVE 'ALL'                 TO UV-PROGRAM-ID            
                 MOVE  MN-CODE-LAST-VALID-RD                            
                                            TO UV-CODE-VALUE-TEXT       
                 PERFORM 7260-GET-CODE-VALUE      THRU   7260-EXIT      
                 MOVE UV-CODE-LONG-DESC-TEXT                            
                                            TO MI-PRV-COLUMN-VALUE-TEXT 
      *                                                                         
                 INITIALIZE  UV-CODE-VALUE-TEXT                         
                             UV-CODE-LONG-DESC-TEXT                     
      *                                                                         
      *          MOVE RG-CODE-LAST-VALID-RD                                     
      *                                    TO MI-CHG-COLUMN-VALUE-TEXT          
                 MOVE  RG-CODE-LAST-VALID-RD                            
                                            TO UV-CODE-VALUE-TEXT       
                 PERFORM 7260-GET-CODE-VALUE      THRU   7260-EXIT      
                 MOVE UV-CODE-LONG-DESC-TEXT                            
                                            TO MI-CHG-COLUMN-VALUE-TEXT 
      *                                                                         
                 INITIALIZE  UV-CODE-VALUE-TEXT                         
                             UV-CODE-LONG-DESC-TEXT                     
              ELSE                                                      
                 MOVE +75                  TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE +08                  TO MI-CHG-COLUMN-VALUE-LEN   
      *          MOVE WS-PREV-CODE-LAST-VALID-RD                                
      *                                    TO MI-PRV-COLUMN-VALUE-TEXT          
                 MOVE +18                   TO UV-COLUMN-NA-LEN         
                 MOVE 'CODE_CRNT_REG_READ'  TO UV-COLUMN-NA-TEXT        
                 MOVE +17                   TO UV-TABLE-NA-LEN          
                 MOVE 'CSS_REGISTER_READ'   TO UV-TABLE-NA-TEXT         
                 MOVE 01                    TO UV-CODE-VALUE-LEN        
                 MOVE 75                    TO UV-CODE-LONG-DESC-LEN    
                 MOVE 'ALL'                 TO UV-PROGRAM-ID            
                 MOVE  WS-PREV-CODE-LAST-VALID-RD                       
                                            TO UV-CODE-VALUE-TEXT       
                 PERFORM 7260-GET-CODE-VALUE      THRU   7260-EXIT      
                 MOVE UV-CODE-LONG-DESC-TEXT                            
                                            TO MI-PRV-COLUMN-VALUE-TEXT 
      *                                                                         
                 INITIALIZE  UV-CODE-VALUE-TEXT                         
                             UV-CODE-LONG-DESC-TEXT                     
      *                                                                         
                 MOVE '*DELETED'           TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'Lst Vald Rd Sts'       TO MI-COLUMN-DESC            
              MOVE '30'                    TO MI-TABLE-ID               
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD +1                       TO MI-TRAN-APPL-NO           
           END-IF.                                                      
                                                                        
           IF RG-LAST-VALID-READ-DT NOT EQUAL MN-LAST-VALID-READ-DT     
              IF REGISTER-UPDATE(WS-RGSTER-RD-INDX)                     
                 MOVE +10                  TO MI-PRV-COLUMN-VALUE-LEN   
                                              MI-CHG-COLUMN-VALUE-LEN   
                 MOVE MN-LAST-VALID-READ-DT                             
                                           TO MI-PRV-COLUMN-VALUE-TEXT  
                 MOVE RG-LAST-VALID-READ-DT                             
                                           TO MI-CHG-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +10                  TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE +08                  TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE WS-PREV-LAST-VALID-READ-DT                        
                                           TO MI-PRV-COLUMN-VALUE-TEXT  
                 MOVE '*DELETED'           TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'Lst Valid Rd Dt'                                    
                                           TO MI-COLUMN-DESC            
              MOVE SPACES                  TO MI-TABLE-ID               
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD +1                       TO MI-TRAN-APPL-NO           
           END-IF.                                                      
                                                                        
           IF RG-LAST-VALID-READ-TM NOT EQUAL MN-LAST-VALID-READ-TM     
            IF (MN-LAST-VALID-READ-TM NOT EQUAL '00:00 AM' OR           
                RG-LAST-VALID-READ-TM NOT EQUAL '00:00:00')             
              IF REGISTER-UPDATE(WS-RGSTER-RD-INDX)                     
                 MOVE +08                  TO MI-PRV-COLUMN-VALUE-LEN   
                                              MI-CHG-COLUMN-VALUE-LEN   
                 MOVE MN-LAST-VALID-READ-TM                             
                                           TO MI-PRV-COLUMN-VALUE-TEXT  
                 MOVE RG-LAST-VALID-READ-TM                             
                                           TO MI-CHG-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +08                  TO MI-PRV-COLUMN-VALUE-LEN   
                                              MI-CHG-COLUMN-VALUE-LEN   
                 MOVE WS-PREV-LAST-VALID-READ-TM                        
                                           TO MI-PRV-COLUMN-VALUE-TEXT  
                 MOVE '*DELETED'           TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'Lst Valid Rd Tm'                                    
                                           TO MI-COLUMN-DESC            
              MOVE SPACES                  TO MI-TABLE-ID               
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD +1                       TO MI-TRAN-APPL-NO           
            END-IF                                                      
           END-IF.                                                      
                                                                        
           IF RG-LAST-READ-VALUE NOT EQUAL MN-LAST-READ-VALUE           
              IF DIAL-USAGE-TYPE AND ( WS-NO-READ-DIALS > 0 )           
                 PERFORM 5122-MOVE-REG-RD-DIAL    THRU 5122-EXIT        
              ELSE                                                      
                 PERFORM 5123-MOVE-REG-RD-VALUE   THRU 5123-EXIT        
              END-IF                                                    
              MOVE 'Regular Rd Val'        TO MI-COLUMN-DESC            
              MOVE SPACES                  TO MI-TABLE-ID               
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD +1                       TO MI-TRAN-APPL-NO           
           END-IF.                                                      
                                                                        
           IF RG-CODE-LAST-REG-READ NOT EQUAL MN-CODE-LAST-REG-READ     
              IF REGISTER-UPDATE(WS-RGSTER-RD-INDX)                     
                 MOVE +75                  TO MI-PRV-COLUMN-VALUE-LEN   
                                              MI-CHG-COLUMN-VALUE-LEN   
      *          MOVE MN-CODE-LAST-REG-READ                                     
      *                                    TO MI-PRV-COLUMN-VALUE-TEXT          
                 MOVE +18                   TO UV-COLUMN-NA-LEN         
                 MOVE 'CODE_CRNT_REG_READ'  TO UV-COLUMN-NA-TEXT        
                 MOVE +17                   TO UV-TABLE-NA-LEN          
                 MOVE 'CSS_REGISTER_READ'   TO UV-TABLE-NA-TEXT         
                 MOVE 01                    TO UV-CODE-VALUE-LEN        
                 MOVE 75                    TO UV-CODE-LONG-DESC-LEN    
                 MOVE 'ALL'                 TO UV-PROGRAM-ID            
                 MOVE  MN-CODE-LAST-REG-READ                            
                                            TO UV-CODE-VALUE-TEXT       
                 PERFORM 7260-GET-CODE-VALUE      THRU   7260-EXIT      
                 MOVE UV-CODE-LONG-DESC-TEXT                            
                                            TO MI-PRV-COLUMN-VALUE-TEXT 
      *                                                                         
                 INITIALIZE  UV-CODE-VALUE-TEXT                         
                             UV-CODE-LONG-DESC-TEXT                     
      *                                                                         
      *          MOVE RG-CODE-LAST-REG-READ                                     
      *                                    TO MI-CHG-COLUMN-VALUE-TEXT          
                 MOVE RG-CODE-LAST-REG-READ                             
                                            TO UV-CODE-VALUE-TEXT       
                 PERFORM 7260-GET-CODE-VALUE      THRU   7260-EXIT      
                 MOVE UV-CODE-LONG-DESC-TEXT                            
                                            TO MI-CHG-COLUMN-VALUE-TEXT 
      *                                                                         
                 INITIALIZE  UV-CODE-VALUE-TEXT                         
                             UV-CODE-LONG-DESC-TEXT                     
      *                                                                         
              ELSE                                                      
                 MOVE +75                  TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE +08                  TO MI-CHG-COLUMN-VALUE-LEN   
      *          MOVE WS-PREV-CODE-LAST-REG-READ                                
      *                                    TO MI-PRV-COLUMN-VALUE-TEXT          
                 MOVE +18                   TO UV-COLUMN-NA-LEN         
                 MOVE 'CODE_CRNT_REG_READ'  TO UV-COLUMN-NA-TEXT        
                 MOVE +17                   TO UV-TABLE-NA-LEN          
                 MOVE 'CSS_REGISTER_READ'   TO UV-TABLE-NA-TEXT         
                 MOVE 01                    TO UV-CODE-VALUE-LEN        
                 MOVE 75                    TO UV-CODE-LONG-DESC-LEN    
                 MOVE 'ALL'                 TO UV-PROGRAM-ID            
                 MOVE  WS-PREV-CODE-LAST-REG-READ                       
                                            TO UV-CODE-VALUE-TEXT       
                 PERFORM 7260-GET-CODE-VALUE      THRU   7260-EXIT      
                 MOVE UV-CODE-LONG-DESC-TEXT                            
                                            TO MI-PRV-COLUMN-VALUE-TEXT 
      *                                                                         
                 INITIALIZE  UV-CODE-VALUE-TEXT                         
                             UV-CODE-LONG-DESC-TEXT                     
      *                                                                         
                 MOVE '*DELETED'           TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'Regular Rd Sts'        TO MI-COLUMN-DESC            
              MOVE '30'                    TO MI-TABLE-ID               
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD +1                       TO MI-TRAN-APPL-NO           
           END-IF.                                                      
                                                                        
           IF RG-LAST-REG-READ-DT NOT EQUAL MN-LAST-REG-READ-DATE       
              IF REGISTER-UPDATE(WS-RGSTER-RD-INDX)                     
                 MOVE +10                  TO MI-PRV-COLUMN-VALUE-LEN   
                                              MI-CHG-COLUMN-VALUE-LEN   
                 MOVE MN-LAST-REG-READ-DATE                             
                                           TO MI-PRV-COLUMN-VALUE-TEXT  
                 MOVE RG-LAST-REG-READ-DT  TO MI-CHG-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +10                  TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE +08                  TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE WS-PREV-LAST-REG-READ-DT                          
                                           TO MI-PRV-COLUMN-VALUE-TEXT  
                 MOVE '*DELETED'           TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'Regular Read Dt'       TO MI-COLUMN-DESC            
              MOVE SPACES                  TO MI-TABLE-ID               
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD +1                       TO MI-TRAN-APPL-NO           
           END-IF.                                                      
                                                                        
           IF RG-LAST-REG-READ-TM NOT EQUAL MN-LAST-REG-READ-TIME       
            IF (MN-LAST-REG-READ-TIME NOT EQUAL '00:00 AM' OR           
                RG-LAST-REG-READ-TM   NOT EQUAL '00:00:00')             
              IF REGISTER-UPDATE(WS-RGSTER-RD-INDX)                     
                 MOVE +08                  TO MI-PRV-COLUMN-VALUE-LEN   
                                              MI-CHG-COLUMN-VALUE-LEN   
                 MOVE MN-LAST-REG-READ-TIME                             
                                           TO MI-PRV-COLUMN-VALUE-TEXT  
                 MOVE RG-LAST-REG-READ-TM  TO MI-CHG-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +08                  TO MI-PRV-COLUMN-VALUE-LEN   
                                              MI-CHG-COLUMN-VALUE-LEN   
                 MOVE WS-PREV-LAST-REG-READ-TM                          
                                           TO MI-PRV-COLUMN-VALUE-TEXT  
                 MOVE '*DELETED'           TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'Regular Read Tm'       TO MI-COLUMN-DESC            
              MOVE SPACES                  TO MI-TABLE-ID               
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD +1                       TO MI-TRAN-APPL-NO           
            END-IF                                                      
           END-IF.                                                      
                                                                        
       5200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 6000-MOVE-REGISTER-RD.                                         *        
      ******************************************************************        
       6000-MOVE-REGISTER-RD.                                           
                                                                        
           MOVE WS-REG-ID-NO(WS-RGSTER-RD-INDX) TO RG-REG-ID-NO         
                                                   MN-REG-ID-NO         
                                                   MC-REG-ID-NO         
                                                   WS-TRAN-REG-ID-NO.   
           MOVE WS-REG-CD-TIME-PRID(WS-RGSTER-RD-INDX)                  
                                                TO RG-CODE-TIME-PERIOD  
                                                   MN-CODE-TIME-PERIOD. 
           MOVE WS-REG-CODE-REG-STATUS(WS-RGSTER-RD-INDX)               
                                                TO RG-CODE-REG-STATUS   
           MOVE WS-CODE-CRNT-REG-READ(WS-RGSTER-RD-INDX)                
                                                TO RG-CODE-CRNT-REG-READ
           MOVE WS-REG-CODE-NO-RD-REASON(WS-RGSTER-RD-INDX)             
                                                TO RG-CODE-NO-RD-REASON 
           MOVE WS-REG-MCODE-STATUS-REAS(WS-RGSTER-RD-INDX)             
                                                TO RG-CODE-STATUS-REAS  
                                                                        
           MOVE WS-REG-LST-VAL-RD-VALUE(WS-RGSTER-RD-INDX)              
                                                TO WS-DECIMAL-12V3-NUM  
           IF WS-REG-LST-VAL-RD-VAL-SGN(WS-RGSTER-RD-INDX)  = '-' THEN  
              COMPUTE WS-DECIMAL-12V3-NUM     = WS-DECIMAL-12V3-NUM * -1
           END-IF.                                                      
           MOVE WS-DECIMAL-12V3-NUM-RED         TO RG-LAST-VAL-RD-VALUE 
                                                                        
           MOVE WS-REG-CODE-LAST-VALID-RD(WS-RGSTER-RD-INDX)            
                                                TO RG-CODE-LAST-VALID-RD
           MOVE WS-REG-LAST-VALID-READ-DT(WS-RGSTER-RD-INDX)            
                                                TO RG-LAST-VALID-READ-DT
           MOVE WS-REG-LAST-VALID-READ-TM(WS-RGSTER-RD-INDX)            
                                                TO RG-LAST-VALID-READ-TM
           IF RG-LAST-VALID-READ-TM EQUAL '12:00 AM'                    
               MOVE '00:00:00'                  TO RG-LAST-VALID-READ-TM
           END-IF.                                                      
                                                                        
           MOVE WS-REG-LAST-READ-VALUE-VAL(WS-RGSTER-RD-INDX)           
                                                TO WS-DECIMAL-12V3-NUM  
           IF WS-REG-LAST-READ-VALUE-SGN(WS-RGSTER-RD-INDX) = '-' THEN  
              COMPUTE WS-DECIMAL-12V3-NUM     = WS-DECIMAL-12V3-NUM * -1
           END-IF                                                       
           MOVE WS-DECIMAL-12V3-NUM-RED         TO RG-LAST-READ-VALUE   
                                                                        
           MOVE WS-REG-CODE-LAST-REG-READ(WS-RGSTER-RD-INDX)            
                                                TO RG-CODE-LAST-REG-READ
           MOVE WS-REG-LAST-REG-READ-DT(WS-RGSTER-RD-INDX)              
                                                TO RG-LAST-REG-READ-DT  
           MOVE WS-REG-LAST-REG-READ-TM(WS-RGSTER-RD-INDX)              
                                                TO RG-LAST-REG-READ-TM. 
           IF RG-LAST-REG-READ-TM EQUAL '12:00 AM'                      
               MOVE '00:00:00'                  TO RG-LAST-REG-READ-TM  
           END-IF.                                                      
                                                                        
       6000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 6100-MOVE-REG-TO-MTRD.                                         *        
      ******************************************************************        
       6100-MOVE-REG-TO-MTRD.                                           
                                                                        
           MOVE RG-CODE-REG-STATUS              TO MN-CODE-METER-STATUS 
           MOVE RG-CODE-CRNT-REG-READ           TO MN-CODE-CRNT-REG-READ
           MOVE RG-CODE-NO-RD-REASON            TO MN-CODE-NO-RD-REASON 
           MOVE RG-CODE-STATUS-REAS             TO MN-CODE-STATUS-REAS  
           MOVE RG-LAST-VAL-RD-VALUE            TO MN-LAST-VAL-RD-VALUE 
           MOVE RG-CODE-LAST-VALID-RD           TO MN-CODE-LAST-VALID-RD
           MOVE RG-LAST-VALID-READ-DT           TO MN-LAST-VALID-READ-DT
           MOVE RG-LAST-VALID-READ-TM           TO MN-LAST-VALID-READ-TM
           MOVE RG-LAST-READ-VALUE              TO MN-LAST-READ-VALUE   
           MOVE RG-CODE-LAST-REG-READ           TO MN-CODE-LAST-REG-READ
           MOVE RG-LAST-REG-READ-DT             TO MN-LAST-REG-READ-DATE
           MOVE RG-LAST-REG-READ-TM             TO MN-LAST-REG-READ-TIME
                                                                        
           IF MN-METER-INACTIVE-DT  EQUAL LOW-VALUES OR SPACES          
              MOVE -1   TO WS-NULL-IND-05                               
           ELSE                                                         
              MOVE ZERO TO WS-NULL-IND-05                               
           END-IF.                                                      
                                                                        
           IF MN-METER-REMOVED-DT   EQUAL LOW-VALUES OR SPACES          
              MOVE -1   TO WS-NULL-IND-06                               
           ELSE                                                         
              MOVE ZERO TO WS-NULL-IND-06                               
           END-IF.                                                      
                                                                        
           IF MN-MTR-STATUS-CHNG-DT EQUAL LOW-VALUES OR SPACES          
              MOVE -1   TO WS-NULL-IND-07                               
           ELSE                                                         
              MOVE ZERO TO WS-NULL-IND-07                               
           END-IF.                                                      
                                                                        
       6100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 6530-LOAD-MNT-TRANS-HIST.                                     *         
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7000-GET-NEW-GIS-POINT-ID.                                     *        
      ******************************************************************        
       7000-GET-NEW-GIS-POINT-ID.                                       
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) PP.POINT_ID                                        
                INTO :PP-POINT-ID                                       
                FROM CSS_PIM_POINT  PP WITH(READUNCOMMITTED)                    
                    ,CSS_OP_AREA    LO WITH(READUNCOMMITTED)                    
               WHERE PP.TAG_NM         = :PP-TAG-NM                     
                 AND PP.AREA_ID        = :PP-AREA-ID                    
                 AND PP.AREA_ID        = LO.AREA_ID                     
                 AND PP.INACTIVE_TS IS NULL                             
               ORDER BY TAG_NM                                          
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT PP.POINT_ID                                                
MFA-TR*         INTO :PP-POINT-ID                                               
MFA-TR*         FROM CSS_PIM_POINT  PP                                          
MFA-TR*             ,CSS_OP_AREA    LO                                          
MFA-TR*        WHERE PP.TAG_NM         = :PP-TAG-NM                             
MFA-TR*          AND PP.AREA_ID        = :PP-AREA-ID                            
MFA-TR*          AND PP.AREA_ID        = LO.AREA_ID                             
MFA-TR*          AND PP.INACTIVE_TS IS NULL                                     
MFA-TR*        ORDER BY TAG_NM                                                  
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7000                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7000'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_PIM_POINT'          TO TABLE-1                  
              MOVE 'CSS_OP_AREA'            TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'TAG NO'                 TO TABLE-ELEMENT-2          
              MOVE 'AREA_ID'                TO TABLE-ELEMENT-3          
              MOVE MN-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE PP-TAG-NM                TO HOSTVAR-ELEMENT-2        
              MOVE PP-AREA-ID               TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7004-GET-REG-ID                                                *        
      ******************************************************************        
       7004-GET-REG-ID.                                                 
                                                                        
           EXEC SQL                                                     
              SELECT MN.REG_ID_NO                                       
                INTO :MN-REG-ID-NO                                      
                FROM CSS_MTRD_ENVRNMT  MN WITH(READUNCOMMITTED)                 
               WHERE MN.ACCOUNT_NO        = :MN-ACCOUNT-NO              
                 AND MN.CODE_UTIL_TYPE    = :MN-CODE-UTIL-TYPE          
                 AND MN.IC_NO             = :MN-IC-NO                   
                 AND MN.MTR_REF_NO        = :MN-MTR-REF-NO              
                 AND MN.METER_NO          = :MN-METER-NO                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MN.REG_ID_NO                                               
MFA-TR*         INTO :MN-REG-ID-NO                                              
MFA-TR*         FROM CSS_MTRD_ENVRNMT  MN                                       
MFA-TR*        WHERE MN.ACCOUNT_NO        = :MN-ACCOUNT-NO                      
MFA-TR*          AND MN.CODE_UTIL_TYPE    = :MN-CODE-UTIL-TYPE                  
MFA-TR*          AND MN.IC_NO             = :MN-IC-NO                           
MFA-TR*          AND MN.MTR_REF_NO        = :MN-MTR-REF-NO                      
MFA-TR*          AND MN.METER_NO          = :MN-METER-NO                        
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7004                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7004'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_MTRD_ENVRNMT'       TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE 'METER_NO'               TO TABLE-ELEMENT-4          
              MOVE MN-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE MN-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE MN-IC-NO                 TO HOSTVAR-ELEMENT-3        
              MOVE MN-METER-NO              TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7004-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7005-SELECT-MTRD-ENVRNMT.                                      *        
      ******************************************************************        
       7005-SELECT-MTRD-ENVRNMT.                                        
                                                                        
           EXEC SQL                                                     
              SELECT MN.GIS_POINT_ID                                    
                    ,MN.METER_PRESSURE                                  
                    ,MN.MTR_READ_SOURCE_CD                              
                    ,MN.CODE_METER_LOC                                  
                    ,MN.REMOTE_READ_IND                                 
                    ,MN.METER_SUPPLYING                                 
                    ,MN.CODE_MTR_RD_INST1                               
                    ,MN.UTILITY_SOURCE_CD                               
                    ,MN.NO_CONSEC_ESTIMATE                              
                    ,MN.DELIVERY_LEVEL_CD                               
                    ,MN.SEAL_CODE_ID                                    
                    ,MN.MIN_NO_UNITS                                    
                    ,MN.MAX_NO_UNITS                                    
                    ,MN.LOCK_TYPE_ID                                    
                    ,MN.REGISTER_RD_SEQ                                 
                    ,MN.IDR_RECIPIENT_CD                                
                    ,MN.INDUST_BTU_ID                                   
                    ,MN.REG_ID_NO                                       
                    ,MN.CODE_TIME_PERIOD                                
                    ,MN.GIS_MISMATCH_FL                                 
                    ,MN.INSULATED_IND                                   
                INTO :WS-PREV-GIS-POINT-ID,
                :WS-PREV-MTR-PRESSURE,
                :WS-PREV-READ-SOURCE-CD,
                :WS-PREV-CODE-METER-LOC,
                :WS-PREV-REMOTE-READ-IND,
                :WS-PREV-METER-SUPPLYING,
                :WS-PREV-CODE-MTR-RD-INST1,
                :WS-PREV-UTILITY-SOURCE-CD,
                :WS-PREV-NO-CONSEC-ESTIMATE,
                :WS-PREV-DELIVERY-LEVEL-CD,
                :WS-PREV-SEAL-CODE-ID,
                :WS-PREV-MIN-NO-UNITS,
                :WS-PREV-MAX-NO-UNITS,
                :WS-PREV-LOCK-TYPE-ID,
                :WS-PREV-REGISTER-RD-SEQ,
                :WS-PREV-IDR-RECIPIENT-CD,
                :WS-PREV-INDUST-BTU-ID,
                :MN-REG-ID-NO,
                :MN-CODE-TIME-PERIOD,
                :WS-PREV-GIS-MISMATCH-FL,
                :WS-PREV-INSULATED-IND                              
                FROM CSS_MTRD_ENVRNMT  MN WITH(READUNCOMMITTED)                 
               WHERE MN.ACCOUNT_NO        = :MN-ACCOUNT-NO              
                 AND MN.CODE_UTIL_TYPE    = :MN-CODE-UTIL-TYPE          
                 AND MN.IC_NO             = :MN-IC-NO                   
                 AND MN.MTR_REF_NO        = :MN-MTR-REF-NO              
                 AND MN.METER_NO          = :MN-METER-NO                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ025
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MN.GIS_POINT_ID                                            
MFA-TR*             ,MN.METER_PRESSURE                                          
MFA-TR*             ,MN.MTR_READ_SOURCE_CD                                      
MFA-TR*             ,MN.CODE_METER_LOC                                          
MFA-TR*             ,MN.REMOTE_READ_IND                                         
MFA-TR*             ,MN.METER_SUPPLYING                                         
MFA-TR*             ,MN.CODE_MTR_RD_INST1                                       
MFA-TR*             ,MN.UTILITY_SOURCE_CD                                       
MFA-TR*             ,MN.NO_CONSEC_ESTIMATE                                      
MFA-TR*             ,MN.DELIVERY_LEVEL_CD                                       
MFA-TR*             ,MN.SEAL_CODE_ID                                            
MFA-TR*             ,MN.MIN_NO_UNITS                                            
MFA-TR*             ,MN.MAX_NO_UNITS                                            
MFA-TR*             ,MN.LOCK_TYPE_ID                                            
MFA-TR*             ,MN.REGISTER_RD_SEQ                                         
MFA-TR*             ,MN.IDR_RECIPIENT_CD                                        
MFA-TR*             ,MN.INDUST_BTU_ID                                           
MFA-TR*             ,MN.REG_ID_NO                                               
MFA-TR*             ,MN.CODE_TIME_PERIOD                                        
MFA-TR*             ,MN.GIS_MISMATCH_FL                                         
MFA-TR*             ,MN.INSULATED_IND                                           
MFA-TR*         INTO:WS-PREV-GIS-POINT-ID                                       
MFA-TR*            ,:WS-PREV-MTR-PRESSURE                                       
MFA-TR*            ,:WS-PREV-READ-SOURCE-CD                                     
MFA-TR*            ,:WS-PREV-CODE-METER-LOC                                     
MFA-TR*            ,:WS-PREV-REMOTE-READ-IND                                    
MFA-TR*            ,:WS-PREV-METER-SUPPLYING                                    
MFA-TR*            ,:WS-PREV-CODE-MTR-RD-INST1                                  
MFA-TR*            ,:WS-PREV-UTILITY-SOURCE-CD                                  
MFA-TR*            ,:WS-PREV-NO-CONSEC-ESTIMATE                                 
MFA-TR*            ,:WS-PREV-DELIVERY-LEVEL-CD                                  
MFA-TR*            ,:WS-PREV-SEAL-CODE-ID                                       
MFA-TR*            ,:WS-PREV-MIN-NO-UNITS                                       
MFA-TR*            ,:WS-PREV-MAX-NO-UNITS                                       
MFA-TR*            ,:WS-PREV-LOCK-TYPE-ID                                       
MFA-TR*            ,:WS-PREV-REGISTER-RD-SEQ                                    
MFA-TR*            ,:WS-PREV-IDR-RECIPIENT-CD                                   
MFA-TR*            ,:WS-PREV-INDUST-BTU-ID                                      
MFA-TR*            ,:MN-REG-ID-NO                                               
MFA-TR*            ,:MN-CODE-TIME-PERIOD                                        
MFA-TR*            ,:WS-PREV-GIS-MISMATCH-FL                                    
MFA-TR*            ,:WS-PREV-INSULATED-IND                                      
MFA-TR*         FROM CSS_MTRD_ENVRNMT  MN                                       
MFA-TR*        WHERE MN.ACCOUNT_NO        = :MN-ACCOUNT-NO                      
MFA-TR*          AND MN.CODE_UTIL_TYPE    = :MN-CODE-UTIL-TYPE                  
MFA-TR*          AND MN.IC_NO             = :MN-IC-NO                           
MFA-TR*          AND MN.MTR_REF_NO        = :MN-MTR-REF-NO                      
MFA-TR*          AND MN.METER_NO          = :MN-METER-NO                        
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7005                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7005'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_MTRD_ENVRNMT'       TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE 'METER_NO'               TO TABLE-ELEMENT-4          
              MOVE MN-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE MN-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE MN-IC-NO                 TO HOSTVAR-ELEMENT-3        
              MOVE MN-METER-NO              TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7005-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7010-GET-CURR-TIMESTAMP                                        *        
      ******************************************************************        
       7010-GET-CURR-TIMESTAMP.                                         
                                                                        
           EXEC SQL                                                     
               SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :MH-TRANS-HIST-SEQ-NO,
              :MH-DATE-TRANS,
              :WS-CURRENT-DATE                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :MH-TRANS-HIST-SEQ-NO = CURRENT TIMESTAMP                    
MFA-TR*           ,:MH-DATE-TRANS        = CURRENT DATE                         
MFA-TR*           ,:WS-CURRENT-DATE      = CURRENT DATE                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SPACES                   TO ABEND-TABLES             
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
              MOVE '7010'                   TO ACTIVE-PARAGRAPH         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7015-GET-RESP-AREA-ID.                                         *        
      *                                                                *        
      ******************************************************************        
       7015-GET-RESP-AREA-ID.                                           
                                                                        
           EXEC SQL                                                     
               SELECT RESP_AREA_ID                                      
                 INTO :WS-RESP-AREA-ID                                  
                 FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                    
                WHERE USER_ID = :WS-LAST-UPDATE-USERID                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RESP_AREA_ID                                              
MFA-TR*          INTO :WS-RESP-AREA-ID                                          
MFA-TR*          FROM CSS_USER_PROFILE                                          
MFA-TR*         WHERE USER_ID = :WS-LAST-UPDATE-USERID                          
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7015                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7015'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT '                TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_USER_PROFILE  '     TO TABLE-1                  
              MOVE 'USER_ID'                TO TABLE-ELEMENT-1          
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-2          
              MOVE WS-LAST-UPDATE-USERID    TO HOSTVAR-ELEMENT-1        
              MOVE MN-ACCOUNT-NO            TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7015-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7020-GET-RULE-XREF-ID                                          *        
      ******************************************************************        
       7020-GET-RULE-XREF-ID.                                           
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           BUS_RULE_XREF_ID, 121), ' ', '-'), ':', '.') 
           BUS_RULE_XREF_ID                                   
                INTO :S-BUS-RULE-XREF-ID                                
                FROM CSS_BUS_RULE   [1R] WITH(READUNCOMMITTED)                  
                    ,CSS_BUS_RULE_XREF [1T] WITH(READUNCOMMITTED)               
               WHERE [1R].BUS_RULE_ID = :S-BUS-RULE-ID                    
                 AND [1R].BUS_RULE_ID = [1T].BUS_RULE_ID                    
                                             
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BUS_RULE_XREF_ID                                           
MFA-TR*         INTO :S-BUS-RULE-XREF-ID                                        
MFA-TR*         FROM CSS_BUS_RULE   1R                                          
MFA-TR*             ,CSS_BUS_RULE_XREF 1T                                       
MFA-TR*        WHERE 1R.BUS_RULE_ID = :S-BUS-RULE-ID                            
MFA-TR*          AND 1R.BUS_RULE_ID = 1T.BUS_RULE_ID                            
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7020                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               MOVE SPACES                TO ABEND-TABLES               
               MOVE SPACES                TO ABEND-SQL-PREDICATES       
               MOVE '7020'                TO ACTIVE-PARAGRAPH           
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_BUS_RULE'        TO TABLE-1                    
               MOVE 'BUS_RULE_ID'         TO TABLE-ELEMENT-1            
               MOVE S-BUS-RULE-ID     TO HOSTVAR-ELEMENT-1              
               PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7025-GET-OLD-GIS-TAG.                                          *        
      ******************************************************************        
       7025-GET-OLD-GIS-TAG.                                            
                                                                        
           EXEC SQL                                                     
              SELECT PP.AREA_ID                                         
                    ,PP.TAG_NM                                          
                INTO :PP-AREA-ID                                        
                    ,:PP-TAG-NM                                         
                FROM CSS_PIM_POINT PP WITH(READUNCOMMITTED)                     
               WHERE PP.POINT_ID = :WS-GIS-POINT-ID                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT PP.AREA_ID                                                 
MFA-TR*             ,PP.TAG_NM                                                  
MFA-TR*         INTO :PP-AREA-ID                                                
MFA-TR*             ,:PP-TAG-NM                                                 
MFA-TR*         FROM CSS_PIM_POINT PP                                           
MFA-TR*        WHERE PP.POINT_ID = :WS-GIS-POINT-ID                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7025                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7025'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_PIM_POINT'          TO TABLE-1                  
              MOVE 'GIS-POINT-ID'           TO TABLE-ELEMENT-1          
              MOVE WS-PREV-GIS-POINT-ID     TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7025-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7030-SELECT-ACCT-WHT-CROSS.                                    *        
      ******************************************************************        
       7030-SELECT-ACCT-WHT-CROSS.                                      
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-WHT-CROSS-UPDATE                               
                FROM CSS_ACCT_WHT_CROSS WH WITH(READUNCOMMITTED)                
               WHERE ACCOUNT_NO       = :WH-ACCOUNT-NO                  
                 AND GIS_POINT_ID     = :WH-GIS-POINT-ID                
                                                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-WHT-CROSS-UPDATE                                       
MFA-TR*         FROM CSS_ACCT_WHT_CROSS WH                                      
MFA-TR*        WHERE ACCOUNT_NO       = :WH-ACCOUNT-NO                          
MFA-TR*          AND GIS_POINT_ID     = :WH-GIS-POINT-ID                        
MFA-TR*        FETCH FIRST 1 ROW ONLY                                           
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7030                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7030'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_ACCT_WHT_CROSS'     TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'GIS-POINT-ID'           TO TABLE-ELEMENT-2          
              MOVE WH-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE WH-GIS-POINT-ID          TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7040-CHECK-DEP-UTL-BILL-REL.                                   *        
      ******************************************************************        
       7040-CHECK-DEP-UTL-BILL-REL.                                     
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-MSTDEP-REL-EXISTS-FL                           
                FROM CSS_UTL_BILL_REL WITH(READUNCOMMITTED)                     
               WHERE ACCOUNT_NO_DEP         = :UR-ACCOUNT-NO-DEP        
                 AND CODE_UTIL_TYPE_DEP     = :UR-CODE-UTIL-TYPE-DEP    
                 AND IC_NO_DEP              = :UR-IC-NO-DEP             
                 AND MTR_REF_NO_DEP         = :UR-MTR-REF-NO-DEP        
                                                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-MSTDEP-REL-EXISTS-FL                                   
MFA-TR*         FROM CSS_UTL_BILL_REL                                           
MFA-TR*        WHERE ACCOUNT_NO_DEP         = :UR-ACCOUNT-NO-DEP                
MFA-TR*          AND CODE_UTIL_TYPE_DEP     = :UR-CODE-UTIL-TYPE-DEP            
MFA-TR*          AND IC_NO_DEP              = :UR-IC-NO-DEP                     
MFA-TR*          AND MTR_REF_NO_DEP         = :UR-MTR-REF-NO-DEP                
MFA-TR*        FETCH FIRST 1 ROW ONLY                                           
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7040                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7040'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_UTL_BILL_REL'       TO TABLE-1                  
              MOVE 'ACCOUNT_NO_DEP'         TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE_DEP'     TO TABLE-ELEMENT-2          
              MOVE UR-ACCOUNT-NO-DEP        TO HOSTVAR-ELEMENT-1        
              MOVE UR-CODE-UTIL-TYPE-DEP    TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7040-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7050-CHECK-MST-UTL-BILL-REL.                                   *        
      ******************************************************************        
       7050-CHECK-MST-UTL-BILL-REL.                                     
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-MSTDEP-REL-EXISTS-FL                           
                FROM CSS_UTL_BILL_REL WITH(READUNCOMMITTED)                     
               WHERE ACCOUNT_NO_MST         = :UR-ACCOUNT-NO-MST        
                 AND CODE_UTIL_TYPE_MST     = :UR-CODE-UTIL-TYPE-MST    
                 AND IC_NO_MST              = :UR-IC-NO-MST             
                 AND MTR_REF_NO_MST         = :UR-MTR-REF-NO-MST        
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-MSTDEP-REL-EXISTS-FL                                   
MFA-TR*         FROM CSS_UTL_BILL_REL                                           
MFA-TR*        WHERE ACCOUNT_NO_MST         = :UR-ACCOUNT-NO-MST                
MFA-TR*          AND CODE_UTIL_TYPE_MST     = :UR-CODE-UTIL-TYPE-MST            
MFA-TR*          AND IC_NO_MST              = :UR-IC-NO-MST                     
MFA-TR*          AND MTR_REF_NO_MST         = :UR-MTR-REF-NO-MST                
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7050                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7050'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_UTL_BILL_REL'       TO TABLE-1                  
              MOVE 'ACCOUNT_NO_MST'         TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE_MST'     TO TABLE-ELEMENT-2          
              MOVE UR-ACCOUNT-NO-MST        TO HOSTVAR-ELEMENT-1        
              MOVE UR-CODE-UTIL-TYPE-MST    TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7060-CHK-ROW-EXIST.                                            *        
      ******************************************************************        
       7060-CHK-ROW-EXIST.                                              
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-ROW-EXIST                                      
                FROM CSS_REGISTER_READ WITH(READUNCOMMITTED)                    
               WHERE ACCOUNT_NO       = :RG-ACCOUNT-NO                  
                 AND CODE_UTIL_TYPE   = :RG-CODE-UTIL-TYPE              
                 AND MTR_REF_NO       = :RG-MTR-REF-NO                  
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-ROW-EXIST                                              
MFA-TR*         FROM CSS_REGISTER_READ                                          
MFA-TR*        WHERE ACCOUNT_NO       = :RG-ACCOUNT-NO                          
MFA-TR*          AND CODE_UTIL_TYPE   = :RG-CODE-UTIL-TYPE                      
MFA-TR*          AND MTR_REF_NO       = :RG-MTR-REF-NO                          
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7060                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7060'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_REGISTER_READ'      TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'MTR_REF_NO'             TO TABLE-ELEMENT-3          
              MOVE RG-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE RG-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE RG-MTR-REF-NO            TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7060-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7100-GET-REGISTER-READ.                                        *        
      ******************************************************************        
       7100-GET-REGISTER-READ.                                          
                                                                        
           EXEC SQL                                                     
              SELECT RG.CODE_REG_STATUS                                 
                    ,RG.CODE_CRNT_REG_READ                              
                    ,RG.CODE_NO_RD_REASON                               
                    ,RG.CODE_STATUS_REAS                                
                    ,RG.CODE_USAGE_TYPE                                 
                    ,RG.CODE_USAGE_ID                                   
                    ,RG.CODE_USAGE_SOURCE                               
                    ,RG.LAST_VAL_RD_VALUE                               
                    ,RG.CODE_LAST_VALID_RD                              
                    ,RG.LAST_VALID_READ_DT                              
                    ,REPLACE(CONVERT(CHAR(8), RG.LAST_VALID_READ_TM
           , 108), ':', '.') LAST_VALID_READ_TM                              
                    ,RG.LAST_READ_VALUE                                 
                    ,RG.CODE_LAST_REG_READ                              
                    ,RG.LAST_REG_READ_DT                                
                    ,REPLACE(CONVERT(CHAR(8), RG.LAST_REG_READ_TM
           , 108), ':', '.') LAST_REG_READ_TM                                
                INTO :WS-PREV-CODE-REG-STATUS,
                :WS-PREV-CODE-CRNT-REG-READ,
                :WS-PREV-CODE-NO-RD-REASON,
                :WS-PREV-CODE-STATUS-REAS,
                :RG-CODE-USAGE-TYPE,
                :RG-CODE-USAGE-ID,
                :RG-CODE-USAGE-SOURCE,
                :WS-PREV-LAST-VAL-RD-VALUE,
                :WS-PREV-CODE-LAST-VALID-RD,
                :WS-PREV-LAST-VALID-READ-DT :WS-NULL-IND-01,
                :WS-PREV-LAST-VALID-READ-TM :WS-NULL-IND-02,
                :WS-PREV-LAST-READ-VALUE,
                :WS-PREV-CODE-LAST-REG-READ,
                :WS-PREV-LAST-REG-READ-DT :WS-NULL-IND-03,
                :WS-PREV-LAST-REG-READ-TM :WS-NULL-IND-04            
               FROM CSS_REGISTER_READ RG WITH(READUNCOMMITTED)                  
              WHERE RG.ACCOUNT_NO        = :RG-ACCOUNT-NO               
                AND RG.CODE_UTIL_TYPE    = :RG-CODE-UTIL-TYPE           
      *         AND RG.IC_NO             = :RG-IC-NO                            
                AND RG.MTR_REF_NO        = :RG-MTR-REF-NO               
                AND RG.REG_ID_NO         = :RG-REG-ID-NO                
                AND RG.METER_NO          = :RG-METER-NO                 
                AND RG.CODE_TIME_PERIOD  = :RG-CODE-TIME-PERIOD         
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ025
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RG.CODE_REG_STATUS                                         
MFA-TR*             ,RG.CODE_CRNT_REG_READ                                      
MFA-TR*             ,RG.CODE_NO_RD_REASON                                       
MFA-TR*             ,RG.CODE_STATUS_REAS                                        
MFA-TR*             ,RG.CODE_USAGE_TYPE                                         
MFA-TR*             ,RG.CODE_USAGE_ID                                           
MFA-TR*             ,RG.CODE_USAGE_SOURCE                                       
MFA-TR*             ,RG.LAST_VAL_RD_VALUE                                       
MFA-TR*             ,RG.CODE_LAST_VALID_RD                                      
MFA-TR*             ,RG.LAST_VALID_READ_DT                                      
MFA-TR*             ,RG.LAST_VALID_READ_TM                                      
MFA-TR*             ,RG.LAST_READ_VALUE                                         
MFA-TR*             ,RG.CODE_LAST_REG_READ                                      
MFA-TR*             ,RG.LAST_REG_READ_DT                                        
MFA-TR*             ,RG.LAST_REG_READ_TM                                        
MFA-TR*         INTO:WS-PREV-CODE-REG-STATUS                                    
MFA-TR*            ,:WS-PREV-CODE-CRNT-REG-READ                                 
MFA-TR*            ,:WS-PREV-CODE-NO-RD-REASON                                  
MFA-TR*            ,:WS-PREV-CODE-STATUS-REAS                                   
MFA-TR*            ,:RG-CODE-USAGE-TYPE                                         
MFA-TR*            ,:RG-CODE-USAGE-ID                                           
MFA-TR*            ,:RG-CODE-USAGE-SOURCE                                       
MFA-TR*            ,:WS-PREV-LAST-VAL-RD-VALUE                                  
MFA-TR*            ,:WS-PREV-CODE-LAST-VALID-RD                                 
MFA-TR*            ,:WS-PREV-LAST-VALID-READ-DT:WS-NULL-IND-01                  
MFA-TR*            ,:WS-PREV-LAST-VALID-READ-TM:WS-NULL-IND-02                  
MFA-TR*            ,:WS-PREV-LAST-READ-VALUE                                    
MFA-TR*            ,:WS-PREV-CODE-LAST-REG-READ                                 
MFA-TR*            ,:WS-PREV-LAST-REG-READ-DT:WS-NULL-IND-03                    
MFA-TR*            ,:WS-PREV-LAST-REG-READ-TM:WS-NULL-IND-04                    
MFA-TR*        FROM CSS_REGISTER_READ RG                                        
MFA-TR*       WHERE RG.ACCOUNT_NO        = :RG-ACCOUNT-NO                       
MFA-TR*         AND RG.CODE_UTIL_TYPE    = :RG-CODE-UTIL-TYPE                   
MFA-TR*         AND RG.IC_NO             = :RG-IC-NO                            
MFA-TR*         AND RG.MTR_REF_NO        = :RG-MTR-REF-NO                       
MFA-TR*         AND RG.REG_ID_NO         = :RG-REG-ID-NO                        
MFA-TR*         AND RG.METER_NO          = :RG-METER-NO                         
MFA-TR*         AND RG.CODE_TIME_PERIOD  = :RG-CODE-TIME-PERIOD                 
MFA-TR*        WITH UR                                                          
MFA-TR*     QUERYNO 7100                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-NULL-IND-01 = WS-YES-NULL                           
                 MOVE SPACES             TO WS-PREV-LAST-VALID-READ-DT  
              END-IF                                                    
              IF WS-NULL-IND-02 = WS-YES-NULL                           
                  MOVE SPACES            TO WS-PREV-LAST-VALID-READ-TM  
              END-IF                                                    
              IF WS-NULL-IND-03 = WS-YES-NULL                           
                  MOVE SPACES            TO WS-PREV-LAST-REG-READ-DT    
              END-IF                                                    
              IF WS-NULL-IND-04 = WS-YES-NULL                           
                  MOVE SPACES            TO WS-PREV-LAST-REG-READ-TM    
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7100'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_REGISTER_READ'   TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'UTIL_TYPE'           TO TABLE-ELEMENT-2             
              MOVE 'IC_NO'               TO TABLE-ELEMENT-3             
              MOVE 'METER_NO'            TO TABLE-ELEMENT-4             
              MOVE RG-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE RG-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2           
              MOVE RG-IC-NO              TO HOSTVAR-ELEMENT-3           
              MOVE RG-METER-NO           TO HOSTVAR-ELEMENT-4           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7105-GET-METER-CAP-DETAILS.                                    *        
      ******************************************************************        
       7105-GET-METER-CAP-DETAILS.                                      
                                                                        
           EXEC SQL                                                     
                SELECT CONSTANT                                         
                      ,NO_READ_DIALS                                    
                  INTO :MC-CONSTANT                                     
                      ,:MC-NO-READ-DIALS                                
                  FROM CSS_MTR_CAP  MC WITH(READUNCOMMITTED)                    
                 WHERE MC.METER_NO       = :MC-METER-NO                 
                   AND MC.REG_ID_NO      = :MC-REG-ID-NO                
                   AND MC.CODE_UTIL_TYPE = :MC-CODE-UTIL-TYPE           
                   AND MC.COMPANY_NO     = :MC-COMPANY-NO               
                                                                 
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     20010000
MFA-TR*         SELECT CONSTANT                                         20020000
MFA-TR*               ,NO_READ_DIALS                                    20030000
MFA-TR*           INTO :MC-CONSTANT                                     20040000
MFA-TR*               ,:MC-NO-READ-DIALS                                20050000
MFA-TR*           FROM CSS_MTR_CAP  MC                                  20060000
MFA-TR*          WHERE MC.METER_NO       = :MC-METER-NO                 20070000
MFA-TR*            AND MC.REG_ID_NO      = :MC-REG-ID-NO                20080000
MFA-TR*            AND MC.CODE_UTIL_TYPE = :MC-CODE-UTIL-TYPE           20090000
MFA-TR*            AND MC.COMPANY_NO     = :MC-COMPANY-NO                       
MFA-TR*           WITH UR                                                       
MFA-TR*        QUERYNO 7105                                                     
MFA-TR*    END-EXEC                                                     20100000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7105'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_MTR_CAP'             TO TABLE-1                 
              MOVE 'MTR_NO'                  TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-3         
              MOVE MN-METER-NO               TO HOSTVAR-ELEMENT-1       
              MOVE MN-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              MOVE MN-ACCOUNT-NO             TO HOSTVAR-ELEMENT-3       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7105-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7110-GET-DET-CONSUMP-HIST.                                     *        
      ******************************************************************        
       7110-GET-DET-CONSUMP-HIST.                                       
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) CONSTANT,
              NO_DIALS                                           
                INTO :CX-CONSTANT                                       
                    ,:CX-NO-DIALS                                       
                FROM CSS_CNSMPTN_HIST CX WITH(READUNCOMMITTED)                  
               WHERE METER_NO       = :CX-METER-NO                      
                 AND ACCOUNT_NO     = :CX-ACCOUNT-NO                    
                 AND IC_NO          = :CX-IC-NO                         
                 AND CODE_UTIL_TYPE = :CX-CODE-UTIL-TYPE                
                 AND MTR_REF_NO     = :CX-MTR-REF-NO                    
                 AND COMPANY_NO     = :CX-COMPANY-NO                    
               ORDER BY BILL_NO DESC                                    
                                             
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CONSTANT                                                   
MFA-TR*             ,NO_DIALS                                                   
MFA-TR*         INTO :CX-CONSTANT                                               
MFA-TR*             ,:CX-NO-DIALS                                               
MFA-TR*         FROM CSS_CNSMPTN_HIST CX                                        
MFA-TR*        WHERE METER_NO       = :CX-METER-NO                              
MFA-TR*          AND ACCOUNT_NO     = :CX-ACCOUNT-NO                            
MFA-TR*          AND IC_NO          = :CX-IC-NO                                 
MFA-TR*          AND CODE_UTIL_TYPE = :CX-CODE-UTIL-TYPE                        
MFA-TR*          AND MTR_REF_NO     = :CX-MTR-REF-NO                            
MFA-TR*          AND COMPANY_NO     = :CX-COMPANY-NO                            
MFA-TR*        ORDER BY BILL_NO DESC                                            
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7110'                 TO ACTIVE-PARAGRAPH           
              MOVE 'SELECT'               TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSS_CNSMPTN_HIST'     TO TABLE-1                    
              MOVE 'MTR_NO'               TO TABLE-ELEMENT-1            
              MOVE 'CODE_UTIL_TYPE'       TO TABLE-ELEMENT-2            
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-3            
              MOVE CX-METER-NO            TO HOSTVAR-ELEMENT-1          
              MOVE CX-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-2          
              MOVE CX-ACCOUNT-NO          TO HOSTVAR-ELEMENT-3          
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************21390000
      *                                                                *21410000
      * 7120-GET-MTR-USAGE-DESC.                                       *21420000
      ******************************************************************21430000
       7120-GET-MTR-USAGE-DESC.                                         
                                                                        
           EXEC SQL                                                     
               SELECT S5.METER_USAGE_DESC                               
                 INTO :S5-METER-USAGE-DESC                              
                 FROM CSS_MTR_USAGE_VALS S5 WITH(READUNCOMMITTED)               
                WHERE CODE_USAGE_ID     = :S5-CODE-USAGE-ID             
                  AND CODE_USAGE_TYPE   = :S5-CODE-USAGE-TYPE           
                  AND CODE_USAGE_SOURCE = :S5-CODE-USAGE-SOURCE         
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     21460000
MFA-TR*        SELECT S5.METER_USAGE_DESC                               21470000
MFA-TR*          INTO :S5-METER-USAGE-DESC                              21490000
MFA-TR*          FROM CSS_MTR_USAGE_VALS S5                             21510000
MFA-TR*         WHERE CODE_USAGE_ID     = :S5-CODE-USAGE-ID             21520000
MFA-TR*           AND CODE_USAGE_TYPE   = :S5-CODE-USAGE-TYPE           21530000
MFA-TR*           AND CODE_USAGE_SOURCE = :S5-CODE-USAGE-SOURCE         21540000
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7120                                                      
MFA-TR*    END-EXEC.                                                    21570000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7120'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_MTR_USAGE_VALS'      TO TABLE-1                 
              MOVE 'CODE_USAGE_ID'           TO TABLE-ELEMENT-1         
              MOVE 'CODE_USAGE_TYPE'         TO TABLE-ELEMENT-2         
              MOVE 'CODE_USAGE_SOURCE'       TO TABLE-ELEMENT-3         
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-4         
              MOVE S5-CODE-USAGE-ID          TO HOSTVAR-ELEMENT-1       
              MOVE S5-CODE-USAGE-TYPE        TO HOSTVAR-ELEMENT-2       
              MOVE S5-CODE-USAGE-SOURCE      TO HOSTVAR-ELEMENT-3       
              MOVE MN-ACCOUNT-NO             TO HOSTVAR-ELEMENT-4       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7200-GET-REG-DET-FRM-MTRD-TB.                                 *         
      ******************************************************************        
       7200-GET-REG-DET-FRM-MTRD-TB.                                    
                                                                        
           EXEC SQL                                                     
              SELECT MN.CODE_METER_STATUS                               
                    ,MN.CODE_CRNT_REG_READ                              
                    ,MN.CODE_NO_RD_REASON                               
                    ,MN.CODE_USAGE_TYPE                                 
                    ,MN.CODE_USAGE_ID                                   
                    ,MN.CODE_USAGE_SOURCE                               
                    ,MN.CODE_STATUS_REAS                                
                    ,MN.LAST_VAL_RD_VALUE                               
                    ,MN.CODE_LAST_VALID_RD                              
                    ,MN.LAST_VALID_READ_DT                              
                    ,REPLACE(CONVERT(CHAR(8), MN.LAST_VALID_READ_TM
           , 108), ':', '.') LAST_VALID_READ_TM                              
                    ,MN.LAST_READ_VALUE                                 
                    ,MN.CODE_LAST_REG_READ                              
                    ,MN.LAST_REG_READ_DATE                              
                    ,REPLACE(CONVERT(CHAR(8), MN.LAST_REG_READ_TIME
           , 108), ':', '.') LAST_REG_READ_TIME                              
                    ,MN.METER_INACTIVE_DT                               
                    ,MN.METER_REMOVED_DT                                
                    ,MN.MTR_STATUS_CHNG_DT                              
                INTO :MN-CODE-METER-STATUS                              
                    ,:MN-CODE-CRNT-REG-READ                             
                    ,:MN-CODE-NO-RD-REASON                              
                    ,:MN-CODE-USAGE-TYPE                                
                    ,:MN-CODE-USAGE-ID                                  
                    ,:MN-CODE-USAGE-SOURCE                              
                    ,:MN-CODE-STATUS-REAS                               
                    ,:MN-LAST-VAL-RD-VALUE                              
                    ,:MN-CODE-LAST-VALID-RD                             
                    ,:MN-LAST-VALID-READ-DT :WS-NULL-IND-01             
                    ,:MN-LAST-VALID-READ-TM :WS-NULL-IND-02             
                    ,:MN-LAST-READ-VALUE                                
                    ,:MN-CODE-LAST-REG-READ                             
                    ,:MN-LAST-REG-READ-DATE :WS-NULL-IND-03             
                    ,:MN-LAST-REG-READ-TIME :WS-NULL-IND-04             
                    ,:MN-METER-INACTIVE-DT :WS-NULL-IND-05             
                    ,:MN-METER-REMOVED-DT :WS-NULL-IND-06             
                    ,:MN-MTR-STATUS-CHNG-DT :WS-NULL-IND-07             
                FROM CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)                  
               WHERE MN.ACCOUNT_NO        = :MN-ACCOUNT-NO              
                 AND MN.CODE_UTIL_TYPE    = :MN-CODE-UTIL-TYPE          
                 AND MN.IC_NO             = :MN-IC-NO                   
                 AND MN.MTR_REF_NO        = :MN-MTR-REF-NO              
                 AND MN.METER_NO          = :MN-METER-NO                
                 AND MN.REG_ID_NO         = :MN-REG-ID-NO               
                 AND MN.CODE_TIME_PERIOD  = :MN-CODE-TIME-PERIOD        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MN.CODE_METER_STATUS                                       
MFA-TR*             ,MN.CODE_CRNT_REG_READ                                      
MFA-TR*             ,MN.CODE_NO_RD_REASON                                       
MFA-TR*             ,MN.CODE_USAGE_TYPE                                         
MFA-TR*             ,MN.CODE_USAGE_ID                                           
MFA-TR*             ,MN.CODE_USAGE_SOURCE                                       
MFA-TR*             ,MN.CODE_STATUS_REAS                                        
MFA-TR*             ,MN.LAST_VAL_RD_VALUE                                       
MFA-TR*             ,MN.CODE_LAST_VALID_RD                                      
MFA-TR*             ,MN.LAST_VALID_READ_DT                                      
MFA-TR*             ,MN.LAST_VALID_READ_TM                                      
MFA-TR*             ,MN.LAST_READ_VALUE                                         
MFA-TR*             ,MN.CODE_LAST_REG_READ                                      
MFA-TR*             ,MN.LAST_REG_READ_DATE                                      
MFA-TR*             ,MN.LAST_REG_READ_TIME                                      
MFA-TR*             ,MN.METER_INACTIVE_DT                                       
MFA-TR*             ,MN.METER_REMOVED_DT                                        
MFA-TR*             ,MN.MTR_STATUS_CHNG_DT                                      
MFA-TR*         INTO :MN-CODE-METER-STATUS                                      
MFA-TR*             ,:MN-CODE-CRNT-REG-READ                                     
MFA-TR*             ,:MN-CODE-NO-RD-REASON                                      
MFA-TR*             ,:MN-CODE-USAGE-TYPE                                        
MFA-TR*             ,:MN-CODE-USAGE-ID                                          
MFA-TR*             ,:MN-CODE-USAGE-SOURCE                                      
MFA-TR*             ,:MN-CODE-STATUS-REAS                                       
MFA-TR*             ,:MN-LAST-VAL-RD-VALUE                                      
MFA-TR*             ,:MN-CODE-LAST-VALID-RD                                     
MFA-TR*             ,:MN-LAST-VALID-READ-DT :WS-NULL-IND-01                     
MFA-TR*             ,:MN-LAST-VALID-READ-TM :WS-NULL-IND-02                     
MFA-TR*             ,:MN-LAST-READ-VALUE                                        
MFA-TR*             ,:MN-CODE-LAST-REG-READ                                     
MFA-TR*             ,:MN-LAST-REG-READ-DATE :WS-NULL-IND-03                     
MFA-TR*             ,:MN-LAST-REG-READ-TIME :WS-NULL-IND-04                     
MFA-TR*             ,:MN-METER-INACTIVE-DT  :WS-NULL-IND-05                     
MFA-TR*             ,:MN-METER-REMOVED-DT   :WS-NULL-IND-06                     
MFA-TR*             ,:MN-MTR-STATUS-CHNG-DT :WS-NULL-IND-07                     
MFA-TR*         FROM CSS_MTRD_ENVRNMT MN                                        
MFA-TR*        WHERE MN.ACCOUNT_NO        = :MN-ACCOUNT-NO                      
MFA-TR*          AND MN.CODE_UTIL_TYPE    = :MN-CODE-UTIL-TYPE                  
MFA-TR*          AND MN.IC_NO             = :MN-IC-NO                           
MFA-TR*          AND MN.MTR_REF_NO        = :MN-MTR-REF-NO                      
MFA-TR*          AND MN.METER_NO          = :MN-METER-NO                        
MFA-TR*          AND MN.REG_ID_NO         = :MN-REG-ID-NO                       
MFA-TR*          AND MN.CODE_TIME_PERIOD  = :MN-CODE-TIME-PERIOD                
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7005                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF WS-NULL-IND-01 = WS-YES-NULL                           
                 MOVE SPACES             TO MN-LAST-VALID-READ-DT       
              END-IF                                                    
              IF WS-NULL-IND-02 = WS-YES-NULL                           
                  MOVE SPACES            TO MN-LAST-VALID-READ-TM       
              END-IF                                                    
              IF WS-NULL-IND-03 = WS-YES-NULL                           
                  MOVE SPACES            TO MN-LAST-REG-READ-DATE       
              END-IF                                                    
              IF WS-NULL-IND-04 = WS-YES-NULL                           
                  MOVE SPACES            TO MN-LAST-REG-READ-TIME       
              END-IF                                                    
              IF WS-NULL-IND-05 = WS-YES-NULL                           
                  MOVE SPACES            TO MN-METER-INACTIVE-DT        
              END-IF                                                    
              IF WS-NULL-IND-06 = WS-YES-NULL                           
                  MOVE SPACES            TO MN-METER-REMOVED-DT         
              END-IF                                                    
              IF WS-NULL-IND-07 = WS-YES-NULL                           
                  MOVE SPACES            TO MN-MTR-STATUS-CHNG-DT       
              END-IF                                                    
                                                                        
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7200'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_MTRD_ENVRNMT'       TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE 'METER_NO'               TO TABLE-ELEMENT-4          
              MOVE MN-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE MN-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE MN-IC-NO                 TO HOSTVAR-ELEMENT-3        
              MOVE MN-METER-NO              TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7250-SELECT-ACCT-DET.                                          *        
      ******************************************************************        
       7250-SELECT-ACCT-DET.                                            
                                                                        
           EXEC SQL                                                     
              SELECT AT.COMPANY_NO                                      
                    ,AT.REV_MTH_LST_NRML                                
                INTO :AT-COMPANY-NO                                     
                    ,:AT-REV-MTH-LST-NRML                               
                FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
               WHERE AT.ACCOUNT_NO   = :AT-ACCOUNT-NO                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT AT.COMPANY_NO                                              
MFA-TR*             ,AT.REV_MTH_LST_NRML                                        
MFA-TR*         INTO :AT-COMPANY-NO                                             
MFA-TR*             ,:AT-REV-MTH-LST-NRML                                       
MFA-TR*         FROM CSS_ACCOUNT AT                                             
MFA-TR*        WHERE AT.ACCOUNT_NO   = :AT-ACCOUNT-NO                           
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7250                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7250'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_ACCOUNT'            TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7260-GET-CODE-VALUE                                           *         
      *****************************************************************         
                                                                        
       7260-GET-CODE-VALUE.                                             
                                                                        
           EXEC SQL                                                     
              SELECT UV.CODE_LONG_DESC                                  
                    ,UV.CODE_SHORT_DESC                                 
                INTO :UV-CODE-LONG-DESC                                 
                    ,:UV-CODE-SHORT-DESC                                
                FROM CSS_CODE_VALUE    UV WITH(READUNCOMMITTED)                 
               WHERE UV.CODE_VALUE  = :UV-CODE-VALUE                    
                 AND UV.COLUMN_NA   = :UV-COLUMN-NA                     
                 AND UV.TABLE_NA    = :UV-TABLE-NA                      
                 AND UV.PROGRAM_ID  = :UV-PROGRAM-ID                    
                 AND UV.COMPANY_NO  = :UV-COMPANY-NO                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT UV.CODE_LONG_DESC                                          
MFA-TR*             ,UV.CODE_SHORT_DESC                                         
MFA-TR*         INTO :UV-CODE-LONG-DESC                                         
MFA-TR*             ,:UV-CODE-SHORT-DESC                                        
MFA-TR*         FROM CSS_CODE_VALUE    UV                                       
MFA-TR*        WHERE UV.CODE_VALUE  = :UV-CODE-VALUE                            
MFA-TR*          AND UV.COLUMN_NA   = :UV-COLUMN-NA                             
MFA-TR*          AND UV.TABLE_NA    = :UV-TABLE-NA                              
MFA-TR*          AND UV.PROGRAM_ID  = :UV-PROGRAM-ID                            
MFA-TR*          AND UV.COMPANY_NO  = :UV-COMPANY-NO                            
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7260                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE +09                TO UV-CODE-LONG-DESC-LEN    
                    MOVE 'NOT FOUND'        TO UV-CODE-LONG-DESC-TEXT   
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE '7260'             TO ACTIVE-PARAGRAPH         
                    MOVE 'SELECT'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSS_CODE_VALUE'   TO TABLE-1                  
                    MOVE 'PROGRAM_ID'       TO TABLE-ELEMENT-1          
                    MOVE UV-PROGRAM-ID      TO HOSTVAR-ELEMENT-1        
                    MOVE 'CODE_VALUE'       TO TABLE-ELEMENT-2          
                    MOVE UV-CODE-VALUE      TO HOSTVAR-ELEMENT-2        
                    MOVE 'COLUMN_NA'        TO TABLE-ELEMENT-3          
                    MOVE UV-COLUMN-NA       TO HOSTVAR-ELEMENT-3        
                    PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT        
           END-EVALUATE.                                                
      *                                                                         
       7260-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      *                                                               *         
      * 7270-GET-NO-READ-REASON                                       *         
      *****************************************************************         
                                                                        
       7270-GET-NO-READ-REASON.                                         
                                                                        
           EXEC SQL                                                     
              SELECT S4.NO_RD_REASON_DESC                               
                INTO :S4-NO-RD-REASON-DESC                              
                FROM CSS_NO_READ_REASON S4 WITH(READUNCOMMITTED)                
               WHERE S4.CODE_NO_RD_REASON = :S4-CODE-NO-RD-REASON       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT S4.NO_RD_REASON_DESC                                       
MFA-TR*         INTO :S4-NO-RD-REASON-DESC                                      
MFA-TR*         FROM CSS_NO_READ_REASON S4                                      
MFA-TR*        WHERE S4.CODE_NO_RD_REASON = :S4-CODE-NO-RD-REASON               
MFA-TR*         WITH UR                                                         
MFA-TR*       QUERYNO 7270                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7270'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_NO_READ_REASON'     TO TABLE-1                  
              MOVE 'CODE_NO_RD_REASON'      TO TABLE-ELEMENT-1          
              MOVE S4-CODE-NO-RD-REASON     TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
       7270-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      *                                                               *         
      * 7280-GET-IND-BTU-DESC                                         *         
      *****************************************************************         
                                                                        
       7280-GET-IND-BTU-DESC.                                           
                                                                        
           EXEC SQL                                                     
              SELECT FD.INDUST_BTU_DESC                                 
                INTO :FD-INDUST-BTU-DESC                                
                FROM CSS_BTU_INDUST      FD WITH(READUNCOMMITTED)               
               WHERE FD.COMPANY_NO        = :FD-COMPANY-NO              
                 AND FD.INDUST_BTU_ID     = :FD-INDUST-BTU-ID           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT FD.INDUST_BTU_DESC                                         
MFA-TR*         INTO :FD-INDUST-BTU-DESC                                        
MFA-TR*         FROM CSS_BTU_INDUST      FD                                     
MFA-TR*        WHERE FD.COMPANY_NO        = :FD-COMPANY-NO                      
MFA-TR*          AND FD.INDUST_BTU_ID     = :FD-INDUST-BTU-ID                   
MFA-TR*         WITH UR                                                         
MFA-TR*       QUERYNO 7280                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7280'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_BTU_INDUST'         TO TABLE-1                  
              MOVE 'INDUST_BTU_ID'          TO TABLE-ELEMENT-1          
              MOVE FD-INDUST-BTU-ID         TO HOSTVAR-ELEMENT-1        
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-2          
              MOVE FD-COMPANY-NO            TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
       7280-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *                                                                *        
      * 8000-UPDATE-MTRD-ENVRNMT.                                      *        
      ******************************************************************        
       8000-UPDATE-MTRD-ENVRNMT.                                        
                                                                        
           EXEC SQL                                                     
              UPDATE MN                                 
                 SET GIS_POINT_ID            = :MN-GIS-POINT-ID         
                    ,METER_PRESSURE          = :MN-METER-PRESSURE       
                    ,MTR_READ_SOURCE_CD      = :MN-MTR-READ-SOURCE-CD   
                    ,CODE_METER_LOC          = :MN-CODE-METER-LOC       
                    ,REMOTE_READ_IND         = :MN-REMOTE-READ-IND      
                    ,METER_SUPPLYING         = :MN-METER-SUPPLYING      
                    ,CODE_MTR_RD_INST1       = :MN-CODE-MTR-RD-INST1    
                    ,UTILITY_SOURCE_CD       = :MN-UTILITY-SOURCE-CD    
                    ,NO_CONSEC_ESTIMATE      = :MN-NO-CONSEC-ESTIMATE   
                    ,DELIVERY_LEVEL_CD       = :MN-DELIVERY-LEVEL-CD    
                    ,SEAL_CODE_ID            = :MN-SEAL-CODE-ID         
                    ,MIN_NO_UNITS            = :MN-MIN-NO-UNITS         
                    ,MAX_NO_UNITS            = :MN-MAX-NO-UNITS         
                    ,LOCK_TYPE_ID            = :MN-LOCK-TYPE-ID         
                    ,REGISTER_RD_SEQ         = :MN-REGISTER-RD-SEQ      
                    ,IDR_RECIPIENT_CD        = :MN-IDR-RECIPIENT-CD     
                    ,INDUST_BTU_ID           = :MN-INDUST-BTU-ID        
                    ,GIS_MISMATCH_FL         = :MN-GIS-MISMATCH-FL      
                    ,INSULATED_IND           = :MN-INSULATED-IND        
              FROM CSS_MTRD_ENVRNMT MN
               WHERE MN.ACCOUNT_NO           = :MN-ACCOUNT-NO           
                 AND MN.CODE_UTIL_TYPE       = :MN-CODE-UTIL-TYPE       
                 AND MN.METER_NO             = :MN-METER-NO             
                 AND MN.IC_NO                = :MN-IC-NO                
                 AND MN.MTR_REF_NO           = :MN-MTR-REF-NO           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_MTRD_ENVRNMT MN                                        
MFA-TR*          SET GIS_POINT_ID            = :MN-GIS-POINT-ID                 
MFA-TR*             ,METER_PRESSURE          = :MN-METER-PRESSURE               
MFA-TR*             ,MTR_READ_SOURCE_CD      = :MN-MTR-READ-SOURCE-CD           
MFA-TR*             ,CODE_METER_LOC          = :MN-CODE-METER-LOC               
MFA-TR*             ,REMOTE_READ_IND         = :MN-REMOTE-READ-IND              
MFA-TR*             ,METER_SUPPLYING         = :MN-METER-SUPPLYING              
MFA-TR*             ,CODE_MTR_RD_INST1       = :MN-CODE-MTR-RD-INST1            
MFA-TR*             ,UTILITY_SOURCE_CD       = :MN-UTILITY-SOURCE-CD            
MFA-TR*             ,NO_CONSEC_ESTIMATE      = :MN-NO-CONSEC-ESTIMATE           
MFA-TR*             ,DELIVERY_LEVEL_CD       = :MN-DELIVERY-LEVEL-CD            
MFA-TR*             ,SEAL_CODE_ID            = :MN-SEAL-CODE-ID                 
MFA-TR*             ,MIN_NO_UNITS            = :MN-MIN-NO-UNITS                 
MFA-TR*             ,MAX_NO_UNITS            = :MN-MAX-NO-UNITS                 
MFA-TR*             ,LOCK_TYPE_ID            = :MN-LOCK-TYPE-ID                 
MFA-TR*             ,REGISTER_RD_SEQ         = :MN-REGISTER-RD-SEQ              
MFA-TR*             ,IDR_RECIPIENT_CD        = :MN-IDR-RECIPIENT-CD             
MFA-TR*             ,INDUST_BTU_ID           = :MN-INDUST-BTU-ID                
MFA-TR*             ,GIS_MISMATCH_FL         = :MN-GIS-MISMATCH-FL              
MFA-TR*             ,INSULATED_IND           = :MN-INSULATED-IND                
MFA-TR*        WHERE MN.ACCOUNT_NO           = :MN-ACCOUNT-NO                   
MFA-TR*          AND MN.CODE_UTIL_TYPE       = :MN-CODE-UTIL-TYPE               
MFA-TR*          AND MN.METER_NO             = :MN-METER-NO                     
MFA-TR*          AND MN.IC_NO                = :MN-IC-NO                        
MFA-TR*          AND MN.MTR_REF_NO           = :MN-MTR-REF-NO                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '8000'                  TO ACTIVE-PARAGRAPH         
               MOVE 'UPDATE'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-TABLES             
                                               ABEND-SQL-PREDICATES     
               MOVE 'CSS_MTRD_ENVRNMT'      TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2          
               MOVE 'METER_NO'              TO TABLE-ELEMENT-3          
               MOVE 'IC_NO'                 TO TABLE-ELEMENT-4          
               MOVE MN-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               MOVE MN-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2        
               MOVE MN-METER-NO             TO HOSTVAR-ELEMENT-3        
               MOVE MN-IC-NO                TO HOSTVAR-ELEMENT-4        
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *8005-SEND-RESULT                                                *        
      ******************************************************************        
       8005-SEND-RESULT.                                                
                                                                        
           ADD +1                       TO CTR-ROWS.                    
                                                                        
       8005-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *                                                                *        
      * 8010-UPDATE-ACCT-WHT-CROSS.                                    *        
      ******************************************************************        
       8010-UPDATE-ACCT-WHT-CROSS.                                      
                                                                        
           EXEC SQL                                                     
              UPDATE WH                               
                 SET WH.GIS_POINT_ID     = :WH-GIS-POINT-ID             
              FROM CSS_ACCT_WHT_CROSS WH
               WHERE WH.ACCOUNT_NO       = :WH-ACCOUNT-NO               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_ACCT_WHT_CROSS WH                                      
MFA-TR*          SET WH.GIS_POINT_ID     = :WH-GIS-POINT-ID                     
MFA-TR*        WHERE WH.ACCOUNT_NO       = :WH-ACCOUNT-NO                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8010'                   TO ACTIVE-PARAGRAPH         
              MOVE 'UPDATE'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_ACCT_WHT_CROSS'     TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'GIS-POINT-ID'           TO TABLE-ELEMENT-2          
              MOVE WH-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE WH-GIS-POINT-ID          TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8020-DELETE-IRRGLR-MTR-RD.                                     *        
      ******************************************************************        
       8020-DELETE-IRRGLR-MTR-RD.                                       
                                                                        
           EXEC SQL                                                     
              DELETE FROM IM                           
              FROM CSS_IRRGLR_MTR_RD IM
               WHERE ACCOUNT_NO       = :IM-ACCOUNT-NO                  
                 AND CODE_UTIL_TYPE   = :IM-CODE-UTIL-TYPE              
                 AND METER_REF_NO     = :IM-METER-REF-NO                
                 AND IC_NO            = :IM-IC-NO                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_IRRGLR_MTR_RD IM                                  
MFA-TR*        WHERE ACCOUNT_NO       = :IM-ACCOUNT-NO                          
MFA-TR*          AND CODE_UTIL_TYPE   = :IM-CODE-UTIL-TYPE                      
MFA-TR*          AND METER_REF_NO     = :IM-METER-REF-NO                        
MFA-TR*          AND IC_NO            = :IM-IC-NO                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8020'                   TO ACTIVE-PARAGRAPH         
              MOVE 'DELETE'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-TABLES             
                                               ABEND-SQL-PREDICATES     
              MOVE 'CSS_IRRGLR-MTR-RD '     TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE 'MTR_REF_NO'             TO TABLE-ELEMENT-4          
              MOVE IM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE IM-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE IM-IC-NO                 TO HOSTVAR-ELEMENT-3        
              MOVE IM-METER-REF-NO          TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8030-DELETE-REGISTER-READ.                                     *        
      ******************************************************************        
       8030-DELETE-REGISTER-READ.                                       
                                                                        
           EXEC SQL                                                     
              DELETE FROM RG                           
              FROM CSS_REGISTER_READ RG
               WHERE ACCOUNT_NO       = :RG-ACCOUNT-NO                  
                 AND CODE_UTIL_TYPE   = :RG-CODE-UTIL-TYPE              
                 AND MTR_REF_NO       = :RG-MTR-REF-NO                  
                 AND REG_ID_NO        = :RG-REG-ID-NO                   
                 AND CODE_TIME_PERIOD = :RG-CODE-TIME-PERIOD            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_REGISTER_READ RG                                  
MFA-TR*        WHERE ACCOUNT_NO       = :RG-ACCOUNT-NO                          
MFA-TR*          AND CODE_UTIL_TYPE   = :RG-CODE-UTIL-TYPE                      
MFA-TR*          AND MTR_REF_NO       = :RG-MTR-REF-NO                          
MFA-TR*          AND REG_ID_NO        = :RG-REG-ID-NO                           
MFA-TR*          AND CODE_TIME_PERIOD = :RG-CODE-TIME-PERIOD                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8030'                   TO ACTIVE-PARAGRAPH         
              MOVE 'DELETE'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-TABLES             
                                               ABEND-SQL-PREDICATES     
              MOVE 'CSS_REGISTER_READ '     TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'REG_ID_NO'              TO TABLE-ELEMENT-3          
              MOVE 'MTR_REF_NO'             TO TABLE-ELEMENT-4          
              MOVE RG-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE RG-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE RG-REG-ID-NO             TO HOSTVAR-ELEMENT-3        
              MOVE RG-MTR-REF-NO            TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      *  8040-DELETE-MTRD-ENVRNMT.                                     *        
      ******************************************************************        
       8040-DELETE-MTRD-ENVRNMT.                                        
                                                                        
           EXEC SQL                                                     
              DELETE FROM MN                            
              FROM CSS_MTRD_ENVRNMT MN
               WHERE ACCOUNT_NO     = :MN-ACCOUNT-NO                    
                 AND CODE_UTIL_TYPE = :MN-CODE-UTIL-TYPE                
                 AND METER_NO       = :MN-METER-NO                      
                 AND MTR_REF_NO     = :MN-MTR-REF-NO                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_MTRD_ENVRNMT MN                                   
MFA-TR*        WHERE ACCOUNT_NO     = :MN-ACCOUNT-NO                            
MFA-TR*          AND CODE_UTIL_TYPE = :MN-CODE-UTIL-TYPE                        
MFA-TR*          AND METER_NO       = :MN-METER-NO                              
MFA-TR*          AND MTR_REF_NO     = :MN-MTR-REF-NO                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8040'                   TO ACTIVE-PARAGRAPH         
              MOVE 'DELETE'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-TABLES             
                                               ABEND-SQL-PREDICATES     
              MOVE 'CSS_MTRD_ENVRNMT  '     TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'METER_NO'               TO TABLE-ELEMENT-3          
              MOVE 'MTR_REF_NO'             TO TABLE-ELEMENT-4          
              MOVE MN-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE MN-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE MN-METER-NO              TO HOSTVAR-ELEMENT-3        
              MOVE MN-MTR-REF-NO            TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8040-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8050-UPDATE-REG-READ.                                          *        
      ******************************************************************        
       8050-UPDATE-REG-READ.                                            
                                                                        
           EXEC SQL                                                     
              UPDATE RG                                
                 SET RG.CODE_REG_STATUS      = :RG-CODE-REG-STATUS      
                    ,RG.CODE_CRNT_REG_READ   = :RG-CODE-CRNT-REG-READ   
                    ,RG.CODE_NO_RD_REASON    = :RG-CODE-NO-RD-REASON    
                    ,RG.CODE_STATUS_REAS     = :RG-CODE-STATUS-REAS     
                    ,RG.LAST_VAL_RD_VALUE    = :RG-LAST-VAL-RD-VALUE    
                    ,RG.CODE_LAST_VALID_RD   = :RG-CODE-LAST-VALID-RD   
                    ,RG.LAST_VALID_READ_DT   = IIF(TRY_CONVERT(DATE, 
                                                 :RG-LAST-VALID-READ-DT
              ) IS NULL OR (PATINDEX('%.%', :RG-LAST-VALID-READ-DT
              ) <> 0) OR (LEN(:RG-LAST-VALID-READ-DT
              ) <> 10), CIS.CHAR2DATE(:RG-LAST-VALID-READ-DT
              ), CONVERT(DATE, :RG-LAST-VALID-READ-DT) )   
                    ,RG.LAST_VALID_READ_TM   = CIS.CHAR2TIME(
                                                 :RG-LAST-VALID-READ-TM
              )   
                    ,RG.LAST_READ_VALUE      = :RG-LAST-READ-VALUE      
                    ,RG.CODE_LAST_REG_READ   = :RG-CODE-LAST-REG-READ   
                    ,RG.LAST_REG_READ_DT     = IIF(TRY_CONVERT(DATE, 
                                                   :RG-LAST-REG-READ-DT
              ) IS NULL OR (PATINDEX('%.%', :RG-LAST-REG-READ-DT
              ) <> 0) OR (LEN(:RG-LAST-REG-READ-DT
              ) <> 10), CIS.CHAR2DATE(:RG-LAST-REG-READ-DT
              ), CONVERT(DATE, :RG-LAST-REG-READ-DT) )     
                    ,RG.LAST_REG_READ_TM     = CIS.CHAR2TIME(
                                                   :RG-LAST-REG-READ-TM
              )     
              FROM CSS_REGISTER_READ RG
               WHERE RG.ACCOUNT_NO           = :RG-ACCOUNT-NO           
                 AND RG.CODE_UTIL_TYPE       = :RG-CODE-UTIL-TYPE       
                 AND RG.IC_NO                = :RG-IC-NO                
                 AND RG.REG_ID_NO            = :RG-REG-ID-NO            
                 AND RG.MTR_REF_NO           = :RG-MTR-REF-NO           
                 AND RG.METER_NO             = :RG-METER-NO             
                 AND RG.CODE_TIME_PERIOD     = :RG-CODE-TIME-PERIOD     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_REGISTER_READ RG                                       
MFA-TR*          SET RG.CODE_REG_STATUS      = :RG-CODE-REG-STATUS              
MFA-TR*             ,RG.CODE_CRNT_REG_READ   = :RG-CODE-CRNT-REG-READ           
MFA-TR*             ,RG.CODE_NO_RD_REASON    = :RG-CODE-NO-RD-REASON            
MFA-TR*             ,RG.CODE_STATUS_REAS     = :RG-CODE-STATUS-REAS             
MFA-TR*             ,RG.LAST_VAL_RD_VALUE    = :RG-LAST-VAL-RD-VALUE            
MFA-TR*             ,RG.CODE_LAST_VALID_RD   = :RG-CODE-LAST-VALID-RD           
MFA-TR*             ,RG.LAST_VALID_READ_DT   = :RG-LAST-VALID-READ-DT           
MFA-TR*             ,RG.LAST_VALID_READ_TM   = :RG-LAST-VALID-READ-TM           
MFA-TR*             ,RG.LAST_READ_VALUE      = :RG-LAST-READ-VALUE              
MFA-TR*             ,RG.CODE_LAST_REG_READ   = :RG-CODE-LAST-REG-READ           
MFA-TR*             ,RG.LAST_REG_READ_DT     = :RG-LAST-REG-READ-DT             
MFA-TR*             ,RG.LAST_REG_READ_TM     = :RG-LAST-REG-READ-TM             
MFA-TR*        WHERE RG.ACCOUNT_NO           = :RG-ACCOUNT-NO                   
MFA-TR*          AND RG.CODE_UTIL_TYPE       = :RG-CODE-UTIL-TYPE               
MFA-TR*          AND RG.IC_NO                = :RG-IC-NO                        
MFA-TR*          AND RG.REG_ID_NO            = :RG-REG-ID-NO                    
MFA-TR*          AND RG.MTR_REF_NO           = :RG-MTR-REF-NO                   
MFA-TR*          AND RG.METER_NO             = :RG-METER-NO                     
MFA-TR*          AND RG.CODE_TIME_PERIOD     = :RG-CODE-TIME-PERIOD             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '8050'                  TO ACTIVE-PARAGRAPH         
               MOVE 'UPDATE'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-TABLES             
                                               ABEND-SQL-PREDICATES     
               MOVE 'CSS_REGISTER_READ'     TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2          
               MOVE 'METER_NO'              TO TABLE-ELEMENT-3          
               MOVE 'IC_NO'                 TO TABLE-ELEMENT-4          
               MOVE RG-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               MOVE RG-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2        
               MOVE RG-METER-NO             TO HOSTVAR-ELEMENT-3        
               MOVE RG-IC-NO                TO HOSTVAR-ELEMENT-4        
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8060-DELETE-REG-READ.                                          *        
      ******************************************************************        
       8060-DELETE-REG-READ.                                            
                                                                        
           EXEC SQL                                                     
                DELETE FROM RG                         
                FROM CSS_REGISTER_READ RG
                 WHERE RG.ACCOUNT_NO           = :RG-ACCOUNT-NO         
                   AND RG.CODE_UTIL_TYPE       = :RG-CODE-UTIL-TYPE     
                   AND RG.IC_NO                = :RG-IC-NO              
                   AND RG.REG_ID_NO            = :RG-REG-ID-NO          
                   AND RG.MTR_REF_NO           = :RG-MTR-REF-NO         
                   AND RG.METER_NO             = :RG-METER-NO           
                   AND RG.CODE_TIME_PERIOD     = :RG-CODE-TIME-PERIOD   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE FROM CSS_REGISTER_READ RG                                
MFA-TR*          WHERE RG.ACCOUNT_NO           = :RG-ACCOUNT-NO                 
MFA-TR*            AND RG.CODE_UTIL_TYPE       = :RG-CODE-UTIL-TYPE             
MFA-TR*            AND RG.IC_NO                = :RG-IC-NO                      
MFA-TR*            AND RG.REG_ID_NO            = :RG-REG-ID-NO                  
MFA-TR*            AND RG.MTR_REF_NO           = :RG-MTR-REF-NO                 
MFA-TR*            AND RG.METER_NO             = :RG-METER-NO                   
MFA-TR*            AND RG.CODE_TIME_PERIOD     = :RG-CODE-TIME-PERIOD           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '8060'                  TO ACTIVE-PARAGRAPH         
               MOVE 'DELETE'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-TABLES             
                                               ABEND-SQL-PREDICATES     
               MOVE 'CSS_REGISTER_READ'     TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2          
               MOVE 'METER_NO'              TO TABLE-ELEMENT-3          
               MOVE 'IC_NO'                 TO TABLE-ELEMENT-4          
               MOVE RG-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               MOVE RG-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2        
               MOVE RG-METER-NO             TO HOSTVAR-ELEMENT-3        
               MOVE RG-IC-NO                TO HOSTVAR-ELEMENT-4        
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8060-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8070-UPDATE-DATA-PRSNT.                                        *        
      ******************************************************************        
       8070-UPDATE-DATA-PRSNT.                                          
                                                                        
           EXEC SQL                                                     
              UPDATE MN                                 
                 SET MN.CODE_DATA_PRESENT = :MN-CODE-DATA-PRESENT       
              FROM CSS_MTRD_ENVRNMT MN
               WHERE MN.ACCOUNT_NO        = :MN-ACCOUNT-NO              
                 AND MN.CODE_UTIL_TYPE    = :MN-CODE-UTIL-TYPE          
                 AND MN.METER_NO          = :MN-METER-NO                
      *          AND MN.MTR_REF_NO        = :MN-MTR-REF-NO                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_MTRD_ENVRNMT MN                                        
MFA-TR*          SET MN.CODE_DATA_PRESENT = :MN-CODE-DATA-PRESENT               
MFA-TR*        WHERE MN.ACCOUNT_NO        = :MN-ACCOUNT-NO                      
MFA-TR*          AND MN.CODE_UTIL_TYPE    = :MN-CODE-UTIL-TYPE                  
MFA-TR*          AND MN.METER_NO          = :MN-METER-NO                        
MFA-TR*          AND MN.MTR_REF_NO        = :MN-MTR-REF-NO                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '8070'                  TO ACTIVE-PARAGRAPH         
               MOVE 'UPDATE'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-TABLES             
                                               ABEND-SQL-PREDICATES     
               MOVE 'CSS_MTRD_ENVRNMT'      TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2          
               MOVE 'METER_NO'              TO TABLE-ELEMENT-3          
               MOVE 'MTR_REF_NO'            TO TABLE-ELEMENT-4          
               MOVE MN-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               MOVE MN-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2        
               MOVE MN-METER-NO             TO HOSTVAR-ELEMENT-3        
               MOVE MN-MTR-REF-NO           TO HOSTVAR-ELEMENT-4        
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8070-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8080-UPDATE-MTRD-ENVRNMT.                                      *        
      ******************************************************************        
       8080-UPDATE-MTRD-ENVRNMT.                                        
                                                                        
           EXEC SQL                                                     
              UPDATE MN                                 
                 SET MN.CODE_METER_STATUS    = :MN-CODE-METER-STATUS    
                    ,MN.CODE_CRNT_REG_READ   = :MN-CODE-CRNT-REG-READ   
                    ,MN.CODE_NO_RD_REASON    = :MN-CODE-NO-RD-REASON    
                    ,MN.CODE_STATUS_REAS     = :MN-CODE-STATUS-REAS     
                    ,MN.LAST_VAL_RD_VALUE    = :MN-LAST-VAL-RD-VALUE    
                    ,MN.CODE_LAST_VALID_RD   = :MN-CODE-LAST-VALID-RD   
                    ,MN.LAST_VALID_READ_DT   = IIF(TRY_CONVERT(DATE, 
                                                 :MN-LAST-VALID-READ-DT
              ) IS NULL OR (PATINDEX('%.%', :MN-LAST-VALID-READ-DT
              ) <> 0) OR (LEN(:MN-LAST-VALID-READ-DT
              ) <> 10), CIS.CHAR2DATE(:MN-LAST-VALID-READ-DT
              ), CONVERT(DATE, :MN-LAST-VALID-READ-DT) )   
                    ,MN.LAST_VALID_READ_TM   = CIS.CHAR2TIME(
                                                 :MN-LAST-VALID-READ-TM
              )   
                    ,MN.LAST_READ_VALUE      = :MN-LAST-READ-VALUE      
                    ,MN.CODE_LAST_REG_READ   = :MN-CODE-LAST-REG-READ   
                    ,MN.LAST_REG_READ_DATE   = IIF(TRY_CONVERT(DATE, 
                                                 :MN-LAST-REG-READ-DATE
              ) IS NULL OR (PATINDEX('%.%', :MN-LAST-REG-READ-DATE
              ) <> 0) OR (LEN(:MN-LAST-REG-READ-DATE
              ) <> 10), CIS.CHAR2DATE(:MN-LAST-REG-READ-DATE
              ), CONVERT(DATE, :MN-LAST-REG-READ-DATE) )   
                    ,MN.LAST_REG_READ_TIME   = CIS.CHAR2TIME(
                                                 :MN-LAST-REG-READ-TIME
              )   
                    ,MN.METER_INACTIVE_DT    = IIF(TRY_CONVERT(DATE, 
                                                 :MN-METER-INACTIVE-DT 
                                                        :WS-NULL-IND-05
              ) IS NULL OR (PATINDEX('%.%', :MN-METER-INACTIVE-DT 
                                                        :WS-NULL-IND-05
              ) <> 0) OR (LEN(:MN-METER-INACTIVE-DT :WS-NULL-IND-05
              ) <> 10), CIS.CHAR2DATE(:MN-METER-INACTIVE-DT 
                                                        :WS-NULL-IND-05
              ), CONVERT(DATE, :MN-METER-INACTIVE-DT :WS-NULL-IND-05) )        
                    ,MN.METER_REMOVED_DT     = IIF(TRY_CONVERT(DATE, 
                                                  :MN-METER-REMOVED-DT 
                                                        :WS-NULL-IND-06
              ) IS NULL OR (PATINDEX('%.%', :MN-METER-REMOVED-DT 
                                                        :WS-NULL-IND-06
              ) <> 0) OR (LEN(:MN-METER-REMOVED-DT :WS-NULL-IND-06
              ) <> 10), CIS.CHAR2DATE(:MN-METER-REMOVED-DT 
                                                        :WS-NULL-IND-06
              ), CONVERT(DATE, :MN-METER-REMOVED-DT :WS-NULL-IND-06) )         
                    ,MN.MTR_STATUS_CHNG_DT   = IIF(TRY_CONVERT(DATE, 
                                                :MN-MTR-STATUS-CHNG-DT 
                                                        :WS-NULL-IND-07
              ) IS NULL OR (PATINDEX('%.%', :MN-MTR-STATUS-CHNG-DT 
                                                        :WS-NULL-IND-07
              ) <> 0) OR (LEN(:MN-MTR-STATUS-CHNG-DT :WS-NULL-IND-07
              ) <> 10), CIS.CHAR2DATE(:MN-MTR-STATUS-CHNG-DT 
                                                        :WS-NULL-IND-07
              ), CONVERT(DATE, :MN-MTR-STATUS-CHNG-DT :WS-NULL-IND-07
              ) )          
              FROM CSS_MTRD_ENVRNMT MN
               WHERE MN.ACCOUNT_NO           = :MN-ACCOUNT-NO           
                 AND MN.CODE_UTIL_TYPE       = :MN-CODE-UTIL-TYPE       
                 AND MN.METER_NO             = :MN-METER-NO             
                 AND MN.IC_NO                = :MN-IC-NO                
                 AND MN.MTR_REF_NO           = :MN-MTR-REF-NO           
                 AND MN.REG_ID_NO            = :MN-REG-ID-NO            
                 AND MN.CODE_TIME_PERIOD     = :MN-CODE-TIME-PERIOD     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_MTRD_ENVRNMT MN                                        
MFA-TR*          SET MN.CODE_METER_STATUS    = :MN-CODE-METER-STATUS            
MFA-TR*             ,MN.CODE_CRNT_REG_READ   = :MN-CODE-CRNT-REG-READ           
MFA-TR*             ,MN.CODE_NO_RD_REASON    = :MN-CODE-NO-RD-REASON            
MFA-TR*             ,MN.CODE_STATUS_REAS     = :MN-CODE-STATUS-REAS             
MFA-TR*             ,MN.LAST_VAL_RD_VALUE    = :MN-LAST-VAL-RD-VALUE            
MFA-TR*             ,MN.CODE_LAST_VALID_RD   = :MN-CODE-LAST-VALID-RD           
MFA-TR*             ,MN.LAST_VALID_READ_DT   = :MN-LAST-VALID-READ-DT           
MFA-TR*             ,MN.LAST_VALID_READ_TM   = :MN-LAST-VALID-READ-TM           
MFA-TR*             ,MN.LAST_READ_VALUE      = :MN-LAST-READ-VALUE              
MFA-TR*             ,MN.CODE_LAST_REG_READ   = :MN-CODE-LAST-REG-READ           
MFA-TR*             ,MN.LAST_REG_READ_DATE   = :MN-LAST-REG-READ-DATE           
MFA-TR*             ,MN.LAST_REG_READ_TIME   = :MN-LAST-REG-READ-TIME           
MFA-TR*             ,MN.METER_INACTIVE_DT    = :MN-METER-INACTIVE-DT            
MFA-TR*                                        :WS-NULL-IND-05                  
MFA-TR*             ,MN.METER_REMOVED_DT     = :MN-METER-REMOVED-DT             
MFA-TR*                                        :WS-NULL-IND-06                  
MFA-TR*             ,MN.MTR_STATUS_CHNG_DT   = :MN-MTR-STATUS-CHNG-DT           
MFA-TR*                                        :WS-NULL-IND-07                  
MFA-TR*        WHERE MN.ACCOUNT_NO           = :MN-ACCOUNT-NO                   
MFA-TR*          AND MN.CODE_UTIL_TYPE       = :MN-CODE-UTIL-TYPE               
MFA-TR*          AND MN.METER_NO             = :MN-METER-NO                     
MFA-TR*          AND MN.IC_NO                = :MN-IC-NO                        
MFA-TR*          AND MN.MTR_REF_NO           = :MN-MTR-REF-NO                   
MFA-TR*          AND MN.REG_ID_NO            = :MN-REG-ID-NO                    
MFA-TR*          AND MN.CODE_TIME_PERIOD     = :MN-CODE-TIME-PERIOD             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '8080'                  TO ACTIVE-PARAGRAPH         
               MOVE 'UPDATE'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-TABLES             
                                               ABEND-SQL-PREDICATES     
               MOVE 'CSS_MTRD_ENVRNMT'      TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2          
               MOVE 'METER_NO'              TO TABLE-ELEMENT-3          
               MOVE 'IC_NO'                 TO TABLE-ELEMENT-4          
               MOVE MN-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               MOVE MN-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2        
               MOVE MN-METER-NO             TO HOSTVAR-ELEMENT-3        
               MOVE MN-IC-NO                TO HOSTVAR-ELEMENT-4        
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8080-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8090-DELETE-BILL-MSG                                           *        
      ******************************************************************        
       8090-DELETE-BILL-MSG.                                            
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_SPCL_BILL_MSG                             
               WHERE ACCOUNT_NO       = :U1-ACCOUNT-NO                  
                 AND BILL_MSG_ID      = :U1-BILL-MSG-ID                 
                 AND MSG_TYPE_CD      = :U1-MSG-TYPE-CD                 
                 AND REVENUE_MO_END  >= :U1-REVENUE-MO-END              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8090'                   TO ACTIVE-PARAGRAPH         
              MOVE 'DELETE'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_SPCL_BILL_MSG'      TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'BILL_MSG_ID'            TO TABLE-ELEMENT-2          
              MOVE 'MSG_TYPE_CD'            TO TABLE-ELEMENT-3          
              MOVE 'REVENUE_MO_END'         TO TABLE-ELEMENT-4          
              MOVE U1-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE U1-BILL-MSG-ID           TO HOSTVAR-ELEMENT-2        
              MOVE U1-MSG-TYPE-CD           TO HOSTVAR-ELEMENT-3        
              MOVE U1-REVENUE-MO-END        TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       8090-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8095-INSERT-BILL-MSG                                           *        
      ******************************************************************        
       8095-INSERT-BILL-MSG.                                            
                                                                        
           EXEC SQL                                                     
             INSERT INTO CSS_SPCL_BILL_MSG                              
                  ( REVENUE_MO_ST                                       
                   ,ACCOUNT_NO                                          
                   ,BILL_MSG_ID                                         
                   ,MSG_TYPE_CD                                         
                   ,COMPANY_NO                                          
                   ,BILL_CYCLE_ST                                       
                   ,BILL_CYCLE_END                                      
                   ,REVENUE_MO_END )                                    
            VALUES (:U1-REVENUE-MO-ST                                   
                   ,:U1-ACCOUNT-NO                                      
                   ,:U1-BILL-MSG-ID                                     
                   ,:U1-MSG-TYPE-CD                                     
                   ,:U1-COMPANY-NO                                      
                   ,:U1-BILL-CYCLE-ST                                   
                   ,:U1-BILL-CYCLE-END                                  
                   ,:U1-REVENUE-MO-END )                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR -803           
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8095'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_SPCL_BILL_MSG'      TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'BILL_MSG_ID'            TO TABLE-ELEMENT-2          
              MOVE 'REVENUE_MO_END'         TO TABLE-ELEMENT-3          
              MOVE U1-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE U1-BILL-MSG-ID           TO HOSTVAR-ELEMENT-2        
              MOVE U1-REVENUE-MO-END        TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       8095-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************** ***********************************************        
      * 9700-ABEND-PROCESSING.                                         *        
      ******************************************************************        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT.             
           PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT.             
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900 - JOURNALING / ERROR HANDLING ROUTINE                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
           EXEC SQL                                                             
             INCLUDE CPD00321                                                   
           END-EXEC.                                                            
                                                                        
