       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       CSR04643.                                      
       AUTHOR.        SAKTHIVEL MATHIYAZHAGAN.                          
COB303 DATE-WRITTEN.     JULY 24, 2013.                                 
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE:  CSR04643              --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--                                                            --         
      *--  CSR04643 :                                                --         
      *--                                                            --         
      *--  SP CALLED TO RETRIEVE METER & REGISTER READ DATA.         --         
      *--                                                            --         
      *--  CLONED FROM CSR02076.                                     --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *--  PARAMETERS                                                --         
      *--                                                            --         
      *--      INPUT                                                 --         
      *--             ACCOUNT_NO          CHAR(13)                   --         
      *--             CODE_UTIL_TYPE      CHAR(03)                   --         
      *--             IC_NO               SMALLINT                   --         
      *--             MTR_REF_NO          SMALLINT                   --         
      *--             METER_NO            CHAR(09)                   --         
      *--                                                            --         
      *--      OUT                                                   --         
      *--                                                            --         
      *--            NONE                                            --         
      *--                                                            --         
      *--      INOUT                                                 --         
      *--                                                            --         
      *--            NONE                                            --         
      *--                                                            --         
      *--  RESULT SET                                                --         
      *--                                                            --         
      *--   1. CSR04643_R1 - METER DETAILS                           --         
      *--         RETURN_CODE             INTEGER                    --         
      *--         APPL_RETURN_CODE        INTEGER                    --         
      *--         METER_NO                CHAR(9)                    --         
      *--         MTR_REF_NO              SMALLINT                   --         
      *--         CODE_UTIL_TYPE          CHAR(1)                    --         
      *--         IC_NO                   SMALLINT                   --         
      *--         RATE_PLAN_NO            CHAR(3)                    --         
      *--         SECURE_RATE_FLAG        CHAR(1)                    --         
      *--         NO_READ_DIALS           SMALLINT                   --         
      *--         CONSTANT                DECIMAL(9,3)               --         
      *--         METER_TYPE              CHAR(13)                   --         
      *--         ELEC_MTR_FORM_CD        CHAR(4)                    --         
      *--         MONTHS_INACTIVE         SMALLINT                   --         
      *--         CCF_CAP_PER_HR          INTEGER                    --         
      *--         CONNECTION_TYPE         CHAR(10)                   --         
      *--         OPTIMUM_READ_DATE       CHAR(10)                   --         
      *--         POINT_ID                CHAR(10)                   --         
      *--         LAST_VALID_READ_DT      CHAR(10)                   --         
      *--         CODE_METER_STATUS       CHAR(1)                    --         
      *--         MTR_READ_SOURCE_CD      CHAR(1)                    --         
      *--         REMOTE_READ_IND         CHAR(1)                    --         
      *--         CODE_MTR_RD_INST1       CHAR(2)                    --         
      *--         CODE_MTR_RD_INST2       CHAR(2)                    --         
      *--         CODE_MTR_RD_INST3       CHAR(2)                    --         
      *--         METER_PRESSURE          INTEGER                    --         
      *--         CODE_METER_LOC          CHAR(2)                    --         
      *--         METER_SUPPLYING         CHAR(15)                   --         
      *--         DIGTL_MTR_TYPE          CHAR(3)                    --         
      *--         PROGRAM_ID              CHAR(2)                    --         
      *--         DATE_MTR_INSTALL        CHAR(10)                   --         
      *--         NO_CONSEC_ESTIMATE      SMALLINT                   --         
      *--         MIN_NO_UNITS            DECIMAL(09,0)              --         
      *--         MAX_NO_UNITS            DECIMAL(09,0)              --         
      *--         UTILITY_SOURCE_CD       CHAR(1)                    --         
      *--         DELIVERY_LEVEL_CD       CHAR(1)                    --         
      *--         PHASE                   SMALLINT                   --         
      *--         INDUST_BTU_ID           CHAR(3)                    --         
      *--         REGISTER_RD_SEQ         INTEGER                    --         
      *--         SEAL_CODE_ID            CHAR(1)                    --         
      *--         LOCK_TYPE_ID            CHAR(1)                    --         
      *--         IDR_RECIPIENT_CD        CHAR(1)                    --         
      *--         INSULATED_IND           CHAR(1)                    --         
      *--         DEVICE_NO               CHAR(12)                   --         
      *--         CODE_ATT_TYPE           CHAR(02)                   --         
      *--         CODE_SHORT_DESC         CHAR(15)                   --         
      *--         MTR_ATT_TYPE_TX         CHAR(25)                   --         
      *--         CODE_METER_TYPE         CHAR(01)                   --         
      *--         GIS_MISMATCH_FL         CHAR(01)                   --         
      *--         MTR_REL_EXISTS          CHAR(01)                   --         
      *--                                                            --         
      *--   2. CSR04643_R2 - REGISTERED READ DETAILS                 --         
      *--         RETURN_CODE             INTEGER                    --         
      *--         APPL_RETURN_CODE        INTEGER                    --         
      *--         METER_NO                CHAR(9)                    --         
      *--         MTR_REF_NO              SMALLINT                   --         
      *--         CODE_UTIL_TYPE          CHAR(1)                    --         
      *--         IC_NO                   SMALLINT                   --         
      *--         REG_ID_NO               SMALLINT                   --         
      *--         CODE_TIME_PERIOD        SMALLINT                   --         
      *--         CODE_REG_STATUS         CHAR(1)                    --         
      *--         CODE_STATUS_REAS        CHAR(1)                    --         
      *--         CODE_NO_RD_REASON       CHAR(1)                    --         
      *--         LAST_VAL_RD_VALUE       DECIMAL(15                 --         
      *--         CODE_LAST_REG_READ      CHAR(1)                    --         
      *--         LAST_VALID_READ_DT      CHAR(10)                   --         
      *--         LAST_VALID_READ_TM      CHAR(8)                    --         
      *--         LAST_READ_VALUE         DECIMAL(1                  --         
      *--         CODE_LAST_VALID_RD      CHAR(1)                    --         
      *--         LAST_REG_READ_DT        CHAR(10)                   --         
      *--         LAST_REG_READ_TM        CHAR(8)                    --         
      *--         NO_READ_DIALS           SMALLINT                   --         
      *--         CONSTANT                DECIMAL(9,3)               --         
      *--         METER_USAGE_DESC        CHAR(35)                   --         
      *--         READ_SEQUENCE_NO        SMALLINT                   --         
      *--         CODE_CRNT_REG_READ      CHAR(01)                   --         
      *--                                                            --         
      *--   3. CSR04643_R3 - BUS RULE DETAILS                        --         
      *--                                                            --         
      *--           RETURN_CODE           INTEGER                    --         
      *--          ,APPL_RETURN_CODE      INTEGER                    --         
      *--          ,BUS_RULE_ID           CHAR(10)                   --         
      *--          ,BUS_RULE_RESULT_CD    CHAR(10)                   --         
      *--          ,BUS_RULE_XREF_ID      CHAR(26)                   --         
      *--                                                            --         
      *--   4. CSR04643_R4 - AGL DISTRIBUTION METER DETAILS          --         
      *--                                                            --         
      *--         RETURN_CODE             INTEGER                    --         
      *--         APPL_RETURN_CODE        INTEGER                    --         
      *--         DIST_COMPANY_NO         CHAR(03)                   --         
      *--         DIST_ACCOUNT_NO         CHAR(20)                   --         
      *--         DIST_METER_NO           CHAR(09)                   --         
      *--         CODE_UTIL_TYPE          CHAR(01)                   --         
      *--         METER_NO                CHAR(09)                   --         
      *--         STATUS_CD               CHAR(01)                   --         
      *--         STATUS_DESC             CHAR(80)                   --         
      *----------------------------------------------------------------         
      *--                        MODIFICATION LOG                    --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
      *--  07/24/2013    MS93554     PROCEDURE ORIGINALLY CODED.     --         
ACT163*--  05/17/2016    TP7R341     REMOVED UNWANTED CODE.          --         
A05460*--  07/15/2016    HA7A338     REPLACE 5901- WITH 7910- PARA   --         
A05460*--                            TO GET THE READ DATE AT IC LEVEL--         
      *----------------------------------------------------------------         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04643'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-START                   PIC X(40) VALUE                    
            'WORKING STORAGE FOR CSR04643 STARTS HERE'.                 
      *                                                                         
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-SUBROUTINE-IDS.                                       
               10  CSRERLOG                 PIC X(8)  VALUE 'CSRERLOG'. 
           05  PROGRAM-NAME                 PIC X(08) VALUE 'CSR04643'. 
           05  WS-DELINQ-CD                 PIC X(08) VALUE 'DATABASE'. 
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN                   PIC S9(9) COMP VALUE 1.     
           05  CTR-ROWS-RS1                 PIC S9(9) COMP VALUE 0.     
           05  CTR-ROWS-RS2                 PIC S9(9) COMP VALUE 0.     
           05  CTR-ROWS-RS3                 PIC S9(9) COMP VALUE 0.     
           05  CTR-ROWS-RS4                 PIC S9(9) COMP VALUE 0.     
                                                                        
       01  WS-MISC.                                                     
           05  WS-SQLSTATE                  PIC X(05)  VALUE SPACES.    
           05  WS-GTT-NAME                  PIC X(19)  VALUE SPACES.    
           05  WS-APPL-RETURN-CODE          PIC S9(04) COMP VALUE 0.    
           05  RS-RETURN-CODE               PIC S9(04) COMP VALUE 0.    
           05  WS-OPTIMUM-READ-DATE         PIC X(10)  VALUE SPACES.    
           05  WS-MONTHS-INACTIVE           PIC S9(4)  USAGE COMP       
                                                       VALUE 0.         
           05  WS-INACTIVE-YEAR             PIC S9(2)  USAGE COMP       
                                                       VALUE 0.         
           05  WS-INACTIVE-MONTH            PIC S9(2)  USAGE COMP       
                                                       VALUE 0.         
           05  WS-KEY-UTIL-TYPE             PIC X(01)  VALUE SPACES.    
           05  WS-KEY-METER-NO              PIC X(09)  VALUE SPACES.    
           05  WS-KEY-IC-NO                 PIC S9(4)  USAGE COMP.      
           05  WS-KEY-MTR-REF-NO            PIC S9(4)  USAGE COMP.      
           05  WS-POINT-ID                  PIC X(10)  VALUE SPACES.    
           05  WS-METER-SIZE-DESC           PIC X(13)  VALUE SPACES.    
           05  WS-DATE-READ                 PIC X(10)  VALUE SPACES.    
           05  WS-LAST-VALID-READ-DT        PIC X(10)  VALUE SPACES.    
           05  WS-LAST-REG-READ-DT          PIC X(10)  VALUE SPACES.    
           05  WS-RUN-DATE                  PIC X(10)  VALUE SPACES.    
           05  WS-NO-READ-DIALS             PIC S9(04) USAGE COMP       
                                                       VALUE 0.         
           05  WS-VERSION-CD-VALUE          PIC X(10)  VALUE SPACES.    
           05  WS-MTR-REL-EXIST             PIC X(01)  VALUE 'N'.       
           05  WS-CONSTANT                  PIC S9(06)V9(3)             
                                                USAGE COMP-3 VALUE 0.   
                                                                        
       01  WS-CODE-VALUE-TB-MISC.                                       
           05 WS-VERSION-CD                 PIC X(18)  VALUE            
                                                'VERSION_CD'.           
           05 WS-STATUS-CD                  PIC X(18)  VALUE            
                                                'STATUS_CD'.            
           05 WS-DIST-XREF-MTR              PIC X(18)  VALUE            
                                                'CSS_DIST_XREF_MTR'.    
           05 WS-EQUIP-ATTCHMTS             PIC X(18)  VALUE            
                                                'CSS_EQUIP_ATTCHMTS'.   
           05 WS-LONG-DESC                  PIC X(80)  VALUE SPACES.    
           05 WS-SHORT-DESC                 PIC X(15)  VALUE SPACES.    
           05 WS-SORT-ORDER                 PIC S9(04) COMP.            
           05 WS-VER-CD-SHRT-DESC           PIC X(15)  VALUE SPACES.    
           05 WS-CD-STAT-LNG-DESC           PIC X(80)  VALUE SPACES.    
           05 WS-SRCH-CODE-VALUE            PIC X(10)  VALUE SPACES.    
           05 WS-SRCH-COLUMN-NA             PIC X(18)  VALUE SPACES.    
           05 WS-SRCH-TABLE-NA              PIC X(18)  VALUE SPACES.    
                                                                        
       01  WS-CODE-VALUE-TABLE.                                         
           05 WS-CODE-VALUE-DATA OCCURS 100 TIMES                       
                                INDEXED BY WS-CD-VAL-INDX.              
              10 WS-CODE-VALUE          PIC X(10).                      
              10 WS-COMPANY-NO          PIC X(02).                      
              10 WS-COLUMN-NA           PIC X(18).                      
              10 WS-TABLE-NA            PIC X(18).                      
              10 WS-CODE-LONG-DESC      PIC X(80).                      
              10 WS-CODE-SHORT-DESC     PIC X(15).                      
              10 WS-CODE-SORT-ORDER     PIC S9(04) COMP.                
                                                                        
       01  WS-NULL-INDICATORS.                                          
           05  WS-NULL-IND-01               PIC S9(04) COMP.            
           05  WS-NULL-IND-02               PIC S9(04) COMP.            
           05  WS-NULL-IND-03               PIC S9(04) COMP.            
           05  WS-NULL-IND-04               PIC S9(04) COMP.            
           05  WS-NULL-IND-05               PIC S9(04) COMP.            
           05  WS-NULL-IND-06               PIC S9(04) COMP.            
           05  WS-NULL-IND-07               PIC S9(04) COMP.            
           05  WS-DATE-LAST-NULL            PIC S9(04) COMP.            
           05  WS-NULL-IND-CPD              PIC S9(04) COMP.            
           05  WS-CPD310-NULL-IND           PIC S9(04) COMP.            
                                                                        
       01  WS-FLAGS.                                                    
           05  WS-YES-NULL                  PIC S9(04) VALUE -1.        
           05  WS-YES                       PIC X(01)  VALUE 'Y'.       
           05  WS-NO                        PIC X(01)  VALUE 'N'.       
           05  WS-ZERO                      PIC S9(04) VALUE 0.         
           05  WS-ELECTRIC                  PIC X(01)  VALUE 'E'.       
           05  WS-GAS                       PIC X(01)  VALUE 'G'.       
           05  WS-CURRENT                   PIC X(01)  VALUE 'C'.       
                                                                        
       01  WS-ERR-FLAGS.                                                
           05  WS-ERR-INSRT-R1              PIC X(01) VALUE 'N'.        
           05  WS-ERR-INSRT-R2              PIC X(01) VALUE 'N'.        
           05  WS-ERR-INSRT-R3              PIC X(01) VALUE 'N'.        
           05  WS-ERR-INSRT-R4              PIC X(01) VALUE 'N'.        
                                                                        
       01  WS-SWITCHES.                                                 
           05  WS-DATABASE                  PIC 9(01) VALUE ZERO.       
               88 CSR-DATABASE                        VALUE 1.          
               88 SEB-DATABASE                        VALUE 2.          
                                                                        
           05 WS-NO-MORE-CD-VALUE           PIC X(01) VALUE 'N'.        
              88 NO-MORE-CD-VALUE                     VALUE 'Y'.        
                                                                        
           05  WS-DIST-METER-EXIST          PIC X(01) VALUE 'N'.        
               88 NO-MORE-DIST-MET                    VALUE 'Y'.        
               88 MORE-DIST-MET                       VALUE 'N'.        
                                                                        
      ****************************************************************          
      *                                                              *          
      *    ERROR PROCESSING VARIABLES                                *          
      ****************************************************************          
      *                                                                         
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
                                                                        
       01 GTT-RETURN-FIELDS.                                            
      *********************************************************                 
      *   GTT TABLE LAYOUT FOR ICP CSS_MTRD_ENVRNMT           *                 
      *********************************************************                 
          05 S-RETURN-CODE                  PIC S9(04) COMP VALUE 0.    
          05 GTT-RETURN-FIELDS-1.                                       
             10 S-RETURN-CODE-1             PIC S9(4)  COMP VALUE 0.    
             10 S-APPL-RETURN-CODE-1        PIC S9(4)  COMP VALUE 0.    
             10 S-RS1-METER-NO              PIC X(9)   VALUE SPACES.    
             10 S-RS1-MTR-REF-NO            PIC S9(4)  COMP VALUE 0.    
             10 S-RS1-CODE-UTIL-TYPE        PIC X(1)   VALUE SPACES.    
             10 S-RS1-IC-NO                 PIC S9(4)  COMP VALUE 0.    
             10 S-RS1-RATE-PLAN-NO          PIC X(3)   VALUE SPACES.    
             10 S-RS1-SECURE-RATE-FLAG      PIC X(1)   VALUE SPACES.    
             10 S-RS1-NO-READ-DIALS         PIC S9(4)  COMP VALUE 0.    
COB305       10 S-RS1-CONSTANT        PIC S9(6)V9(3) USAGE COMP-3 
COB305          VALUE 0.
             10 S-RS1-METER-TYPE            PIC X(13)  VALUE SPACES.    
             10 S-RS1-ELEC-MTR-FORM-CD      PIC X(4)   VALUE SPACES.    
             10 S-RS1-MONTHS-INACTIVE       PIC S9(4)  COMP VALUE 0.    
             10 S-RS1-CCF-CAP-PER-HR        PIC S9(9)  COMP VALUE 0.    
             10 S-RS1-CONNECTION-TYPE       PIC X(10)  VALUE SPACES.    
             10 S-RS1-OPTIMUM-READ-DATE     PIC X(10)  VALUE SPACES.    
             10 S-RS1-POINT-ID              PIC X(10)  VALUE SPACES.    
             10 S-RS1-LAST-VALID-READ-DT    PIC X(10)  VALUE SPACES.    
             10 S-RS1-CODE-METER-STATUS     PIC X(1)   VALUE SPACES.    
             10 S-RS1-MTR-READ-SOURCE-CD    PIC X(1)   VALUE SPACES.    
             10 S-RS1-REMOTE-READ-IND       PIC X(1)   VALUE SPACES.    
             10 S-RS1-CODE-MTR-RD-INST1     PIC X(2)   VALUE SPACES.    
             10 S-RS1-CODE-MTR-RD-INST2     PIC X(2)   VALUE SPACES.    
             10 S-RS1-CODE-MTR-RD-INST3     PIC X(2)   VALUE SPACES.    
             10 S-RS1-METER-PRESSURE        PIC S9(9)  COMP VALUE 0.    
             10 S-RS1-CODE-METER-LOC        PIC X(2)   VALUE SPACES.    
             10 S-RS1-METER-SUPPLYING       PIC X(15)  VALUE SPACES.    
             10 S-RS1-DIGTL-MTR-TYPE        PIC X(3)   VALUE SPACES.    
             10 S-RS1-PROGRAM-ID            PIC X(2)   VALUE SPACES.    
             10 S-RS1-DATE-MTR-INSTALL      PIC X(10)  VALUE SPACES.    
             10 S-RS1-NO-CONSEC-ESTIMATE    PIC S9(4)  COMP VALUE 0.    
COB305       10 S-RS1-MIN-NO-UNITS        PIC S9(9)V USAGE COMP-3 
COB305          VALUE 0.    
COB305       10 S-RS1-MAX-NO-UNITS        PIC S9(9)V USAGE COMP-3 
COB305          VALUE 0.    
             10 S-RS1-UTILITY-SOURCE-CD     PIC X(1)   VALUE SPACES.    
             10 S-RS1-DELIVERY-LEVEL-CD     PIC X(1)   VALUE SPACES.    
             10 S-RS1-PHASE                 PIC S9(4)  COMP VALUE 0.    
             10 S-RS1-INDUST-BTU-ID         PIC X(3)   VALUE SPACES.    
             10 S-RS1-REGISTER-RD-SEQ       PIC S9(9)  COMP VALUE 0.    
             10 S-RS1-SEAL-CODE-ID          PIC X(1)   VALUE SPACES.    
             10 S-RS1-LOCK-TYPE-ID          PIC X(1)   VALUE SPACES.    
             10 S-RS1-IDR-RECIPIENT-CD      PIC X(1)   VALUE SPACES.    
             10 S-RS1-INSULATED-IND         PIC X(1)   VALUE SPACES.    
             10 S-RS1-DEVICE-NO             PIC X(12)  VALUE SPACES.    
             10 S-RS1-CODE-ATT-TYPE         PIC X(02)  VALUE SPACES.    
             10 S-RS1-CODE-SHORT-DESC       PIC X(15)  VALUE SPACES.    
             10 S-RS1-MTR-ATT-TYPE-TX       PIC X(25)  VALUE SPACES.    
             10 S-RS1-CODE-METER-TYPE       PIC X(01)  VALUE SPACES.    
             10 S-RS1-GIS-MISMATCH-FL       PIC X(01)  VALUE SPACES.    
             10 S-RS1-MTR-REL-EXISTS        PIC X(01)  VALUE SPACES.    
                                                                        
      *********************************************************                 
      *   GTT TABLE LAYOUT FOR METER CSS_REGISTERED_READ      *                 
      *********************************************************                 
          05 GTT-RETURN-FIELDS-2.                                       
             10 S-RETURN-CODE-2             PIC S9(04) COMP VALUE 0.    
             10 S-APPL-RETURN-CODE-2        PIC S9(04) COMP VALUE 0.    
             10 S-RS2-METER-NO              PIC X(9)   VALUE SPACES.    
             10 S-RS2-MTR-REF-NO            PIC S9(4)  COMP VALUE 0.    
             10 S-RS2-CODE-UTIL-TYPE        PIC X(1)   VALUE SPACES.    
             10 S-RS2-IC-NO                 PIC S9(4)  COMP VALUE 0.    
             10 S-RS2-REG-ID-NO             PIC S9(4)  COMP VALUE 0.    
             10 S-RS2-CODE-TIME-PERIOD      PIC S9(4)  COMP VALUE 0.    
             10 S-RS2-CODE-REG-STATUS       PIC X(1)   VALUE SPACES.    
             10 S-RS2-CODE-STATUS-REAS      PIC X(1)   VALUE SPACES.    
             10 S-RS2-CODE-NO-RD-REASON     PIC X(1)   VALUE SPACES.    
COB305       10 S-RS2-LAST-VAL-RD-VALUE        PIC S9(12)V9(3) 
COB305          USAGE COMP-3 VALUE 0.    
             10 S-RS2-CODE-LAST-VALID-RD    PIC X(1)   VALUE SPACES.    
             10 S-RS2-LAST-VALID-READ-DT    PIC X(10)  VALUE SPACES.    
             10 S-RS2-LAST-VALID-READ-TM    PIC X(8)   VALUE SPACES.    
COB305       10 S-RS2-LAST-READ-VALUE        PIC S9(12)V9(3) 
COB305          USAGE COMP-3 VALUE 0.    
             10 S-RS2-CODE-LAST-REG-READ    PIC X(1)   VALUE SPACES.    
             10 S-RS2-LAST-REG-READ-DT      PIC X(10)  VALUE SPACES.    
             10 S-RS2-LAST-REG-READ-TM      PIC X(8)   VALUE SPACES.    
             10 S-RS2-NO-READ-DIALS         PIC S9(4)  COMP VALUE 0.    
COB305       10 S-RS2-CONSTANT        PIC S9(6)V9(3) USAGE COMP-3 
COB305          VALUE 0.
             10 S-RS2-METER-USAGE-DESC      PIC X(35)  VALUE SPACES.    
             10 S-RS2-READ-SEQUENCE-NO      PIC S9(4)  COMP VALUE 0.    
             10 S-RS2-CODE-CRNT-REG-READ    PIC X(01)  VALUE SPACES.    
                                                                        
      *********************************************************                 
      *   GTT TABLE LAYOUT FOR BUS RULE ERROR MESSAGE        *                  
      *********************************************************                 
          05 GTT-RETURN-FIELDS-3.                                       
             10 S-RETURN-CODE-3             PIC S9(04) COMP VALUE 0.    
             10 S-APPL-RETURN-CODE-3        PIC S9(04) COMP VALUE 0.    
             10 S-RS3-BUS-RULE-ID           PIC X(10)  VALUE SPACES.    
             10 S-RS3-BUS-RULE-RESULT-CD    PIC X(10)  VALUE SPACES.    
             10 S-RS3-BUS-RULE-XREF-ID      PIC X(26)  VALUE SPACES.    
                                                                        
      *********************************************************                 
      *   GTT TABLE LAYOUT FOR DISTRIBUTION METER DETAILS    *                  
      *********************************************************                 
          05 GTT-RETURN-FIELDS-4.                                       
             10 S-RETURN-CODE-4             PIC S9(04) COMP VALUE 0.    
             10 S-APPL-RETURN-CODE-4        PIC S9(04) COMP VALUE 0.    
             10 S-RS4-DIST-COMPANY-NO       PIC X(03)  VALUE SPACES.    
             10 S-RS4-DIST-ACCOUNT-NO       PIC X(20)  VALUE SPACES.    
             10 S-RS4-DIST-METER-NO         PIC X(09)  VALUE SPACES.    
             10 S-RS4-CODE-UTIL-TYPE        PIC X(01)  VALUE SPACES.    
             10 S-RS4-METER-NO              PIC X(09)  VALUE SPACES.    
             10 S-RS4-STATUS-CD             PIC X(01)  VALUE SPACES.    
             10 S-RS4-STATUS-DESC           PIC X(80)  VALUE SPACES.    
                                                                        
      ******************************************************************        
      *               COBOL WORKING STORAGE COPY BOOKS                 *        
      ******************************************************************        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ACCOUNT        AT                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_READ_WINDOW    RW                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRDWNDW                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_UTIL_ENVRNMT   UT                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_UTL_BILL_REL   UR                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBUTLREL                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_MTRD_ENVRNMT   MN                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMTRENV                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_REGISTER_READ  RG                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRGREAD                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_RATE_PLAN_DESC RD                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRTDESC                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_GAS_METER      GM                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBGASMTR                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ELEC_METER     EM                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBELMTR                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ELEC_MTR_SIZE  M1                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBEMTRSZ                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_GAS_METER_SIZE M5                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBGASMSZ                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_MTR_CAP        MC                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMTRCAP                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_DELINQUENCY     C8                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_CNSMPTN_HIST   CX                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCNSMP                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_PIM_POINT      PP                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBPIMPNT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ELEC_MTR_SPEC  U5                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBEMTRSP                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ELEC_MTR_CLASS U4                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBEMTRCL                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ELEC_CL_SPEC  U0                                       *         
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBELCLSP                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_MTR_ATT_TYPE  MT                                       *         
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMTRATP                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_METER_ATTCHMTS MA                                      *         
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMTRATT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_EQUIP_ATTCHMTS LX                                      *         
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBEQATTH                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_CODE_VALUE     UV                                      *         
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCDVALU                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_MTR_USAGE_VALS S5                                      *         
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMTRVAL                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_MTR_RD_FMT     OA                                      *         
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRDFMT                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_DIST_XREF_MTR  TM                                      *         
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMRKXMT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_MKT_XREF_ACCT  XM                                      *         
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMRKXR                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
      ******************************************************************        
      *    ERROR HANDLING                                                       
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    SUPPORTS DB2 AND SQL ERROR CHECKING                         *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      *   CURSOR DECLARATION TO FETCH ALL REGISTER READ DETAILS        *        
      ******************************************************************        
           EXEC SQL                                                     
               DECLARE REGISTER_RD_CUR CURSOR FOR                       
                SELECT RG.REG_ID_NO                                     
                      ,RG.CODE_TIME_PERIOD                              
                      ,RG.CODE_REG_STATUS                               
                      ,RG.CODE_STATUS_REAS                              
                      ,RG.CODE_NO_RD_REASON                             
                      ,RG.LAST_VAL_RD_VALUE                             
                      ,RG.CODE_LAST_REG_READ                            
                      ,RG.LAST_VALID_READ_DT                            
                      ,REPLACE(CONVERT(CHAR(8), RG.LAST_VALID_READ_TM
           , 108), ':', '.') LAST_VALID_READ_TM                            
                      ,RG.LAST_READ_VALUE                               
                      ,RG.CODE_LAST_VALID_RD                            
                      ,RG.LAST_REG_READ_DT                              
                      ,REPLACE(CONVERT(CHAR(8), RG.LAST_REG_READ_TM
           , 108), ':', '.') LAST_REG_READ_TM                              
                      ,RG.CODE_USAGE_ID                                 
                      ,RG.CODE_USAGE_TYPE                               
                      ,RG.CODE_USAGE_SOURCE                             
                      ,RG.CODE_CRNT_REG_READ                            
                  FROM CSS_REGISTER_READ RG WITH(READUNCOMMITTED)               
                WHERE RG.ACCOUNT_NO        = :RG-ACCOUNT-NO             
                  AND RG.CODE_UTIL_TYPE    = :RG-CODE-UTIL-TYPE         
                  AND RG.IC_NO             = :RG-IC-NO                  
                  AND RG.MTR_REF_NO        = :RG-MTR-REF-NO             
                  AND RG.METER_NO          = :RG-METER-NO               
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE REGISTER_RD_CUR CURSOR FOR                               
MFA-TR*         SELECT RG.REG_ID_NO                                             
MFA-TR*               ,RG.CODE_TIME_PERIOD                                      
MFA-TR*               ,RG.CODE_REG_STATUS                                       
MFA-TR*               ,RG.CODE_STATUS_REAS                                      
MFA-TR*               ,RG.CODE_NO_RD_REASON                                     
MFA-TR*               ,RG.LAST_VAL_RD_VALUE                                     
MFA-TR*               ,RG.CODE_LAST_REG_READ                                    
MFA-TR*               ,RG.LAST_VALID_READ_DT                                    
MFA-TR*               ,RG.LAST_VALID_READ_TM                                    
MFA-TR*               ,RG.LAST_READ_VALUE                                       
MFA-TR*               ,RG.CODE_LAST_VALID_RD                                    
MFA-TR*               ,RG.LAST_REG_READ_DT                                      
MFA-TR*               ,RG.LAST_REG_READ_TM                                      
MFA-TR*               ,RG.CODE_USAGE_ID                                         
MFA-TR*               ,RG.CODE_USAGE_TYPE                                       
MFA-TR*               ,RG.CODE_USAGE_SOURCE                                     
MFA-TR*               ,RG.CODE_CRNT_REG_READ                                    
MFA-TR*           FROM CSS_REGISTER_READ RG                                     
MFA-TR*         WHERE RG.ACCOUNT_NO        = :RG-ACCOUNT-NO                     
MFA-TR*           AND RG.CODE_UTIL_TYPE    = :RG-CODE-UTIL-TYPE                 
MFA-TR*           AND RG.IC_NO             = :RG-IC-NO                          
MFA-TR*           AND RG.MTR_REF_NO        = :RG-MTR-REF-NO                     
MFA-TR*           AND RG.METER_NO          = :RG-METER-NO                       
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*           QUERYNO 7005                                                  
MFA-TR*    END-EXEC.                                                            
      ******************************************************************        
      *                                                                *        
      *   CURSOR DECLARATION TO FETCH ALL DISTRIBUTION XREF METERS.    *        
      ******************************************************************        
           EXEC SQL                                                     
               DECLARE DIST_XREF_MET_CUR CURSOR FOR                     
                SELECT TM.DIST_COMPANY_NO                               
                      ,TM.DIST_ACCOUNT_NO                               
                      ,TM.DIST_METER_NO                                 
                      ,TM.CODE_UTIL_TYPE                                
                      ,TM.METER_NO                                      
                      ,TM.STATUS_CD                                     
                  FROM CSS_DIST_XREF_MTR TM                             
                WHERE TM.DIST_ACCOUNT_NO   = :TM-DIST-ACCOUNT-NO        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE DIST_XREF_MET_CUR CURSOR FOR                             
MFA-TR*         SELECT TM.DIST_COMPANY_NO                                       
MFA-TR*               ,TM.DIST_ACCOUNT_NO                                       
MFA-TR*               ,TM.DIST_METER_NO                                         
MFA-TR*               ,TM.CODE_UTIL_TYPE                                        
MFA-TR*               ,TM.METER_NO                                              
MFA-TR*               ,TM.STATUS_CD                                             
MFA-TR*           FROM CSS_DIST_XREF_MTR TM                                     
MFA-TR*         WHERE TM.DIST_ACCOUNT_NO   = :TM-DIST-ACCOUNT-NO                
MFA-TR*           QUERYNO 7260                                                  
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *                                                                         
      *   CURSOR DECLARATION TO FETCH ALL CODE VALUES.                 *        
      ******************************************************************        
           EXEC SQL                                                     
               DECLARE CODE_VALUE_CUR CURSOR FOR                        
                SELECT UV.CODE_VALUE                                    
                      ,UV.COMPANY_NO                                    
                      ,UV.COLUMN_NA                                     
                      ,UV.TABLE_NA                                      
                      ,UV.CODE_LONG_DESC                                
                      ,UV.CODE_SHORT_DESC                               
                      ,UV.SORT_ORDER                                    
                  FROM CSS_CODE_VALUE UV WITH(READUNCOMMITTED)                  
                 WHERE UV.COLUMN_NA  IN (:WS-STATUS-CD                  
                                        ,:WS-VERSION-CD)                
                   AND UV.TABLE_NA   IN (:WS-DIST-XREF-MTR              
                                        ,:WS-EQUIP-ATTCHMTS)            
                   AND UV.PROGRAM_ID = 'ALL'                            
                ORDER BY UV.COLUMN_NA                                   
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE CODE_VALUE_CUR CURSOR FOR                                
MFA-TR*         SELECT UV.CODE_VALUE                                            
MFA-TR*               ,UV.COMPANY_NO                                            
MFA-TR*               ,UV.COLUMN_NA                                             
MFA-TR*               ,UV.TABLE_NA                                              
MFA-TR*               ,UV.CODE_LONG_DESC                                        
MFA-TR*               ,UV.CODE_SHORT_DESC                                       
MFA-TR*               ,UV.SORT_ORDER                                            
MFA-TR*           FROM CSS_CODE_VALUE UV                                        
MFA-TR*          WHERE UV.COLUMN_NA  IN (:WS-STATUS-CD                          
MFA-TR*                                 ,:WS-VERSION-CD)                        
MFA-TR*            AND UV.TABLE_NA   IN (:WS-DIST-XREF-MTR                      
MFA-TR*                                 ,:WS-EQUIP-ATTCHMTS)                    
MFA-TR*            AND UV.PROGRAM_ID = 'ALL'                                    
MFA-TR*         ORDER BY UV.COLUMN_NA                                           
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*           QUERYNO 7500                                                  
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
COB305 01 I-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.               
       01 I-CODE-UTIL-TYPE      PIC X(01).                              
       01 I-METER-NO            PIC X(09).                              
       01 I-IC-NO               PIC S9(4)  COMP VALUE 0.                
       01 I-MTR-REF-NO          PIC S9(4)  COMP VALUE 0.                
                                                                        
       PROCEDURE DIVISION USING I-ACCOUNT-NO                            
                                I-CODE-UTIL-TYPE                        
                                I-METER-NO                              
                                I-IC-NO                                 
                                I-MTR-REF-NO.                           
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 1000-PROCESS-INPUT       THRU 1000-EXIT.             
           PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT.             
           PERFORM 9999-END-PROGRAM         THRU 9999-EXIT.             
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100A-DECLARE-GTT-R1                                           *        
      ******************************************************************        
       0100A-DECLARE-GTT-R1.                                            
                                                                        
           MOVE 'SESSION.CSR04643_R1'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04643_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04643_R1
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,METER_NO CHAR(9)  COLLATE LATIN1_GENERAL_100_BIN2           
                   ,MTR_REF_NO              SMALLINT                    
                   ,CODE_UTIL_TYPE CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,IC_NO                   SMALLINT                    
                   ,RATE_PLAN_NO CHAR(3)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,SECURE_RATE_FLAG CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,NO_READ_DIALS           SMALLINT                    
                   ,CONSTANT                DECIMAL(9,3)                
                   ,METER_TYPE CHAR(13)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,ELEC_MTR_FORM_CD CHAR(4)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,MONTHS_INACTIVE         SMALLINT                    
                   ,CCF_CAP_PER_HR          INT                     
                   ,CONNECTION_TYPE CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,OPTIMUM_READ_DATE CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,POINT_ID CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,LAST_VALID_READ_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,CODE_METER_STATUS CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,MTR_READ_SOURCE_CD CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,REMOTE_READ_IND CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,CODE_MTR_RD_INST1 CHAR(2)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,CODE_MTR_RD_INST2 CHAR(2)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,CODE_MTR_RD_INST3 CHAR(2)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,METER_PRESSURE          INT                     
                   ,CODE_METER_LOC CHAR(2)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,METER_SUPPLYING CHAR(15)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,DIGTL_MTR_TYPE CHAR(3)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,PROGRAM_ID CHAR(2)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,DATE_MTR_INSTALL CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,NO_CONSEC_ESTIMATE      SMALLINT                    
                   ,MIN_NO_UNITS            DECIMAL(9,0)                
                   ,MAX_NO_UNITS            DECIMAL(9,0)                
                   ,UTILITY_SOURCE_CD CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,DELIVERY_LEVEL_CD CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,PHASE                   SMALLINT                    
                   ,INDUST_BTU_ID CHAR(3)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,REGISTER_RD_SEQ         INT                     
                   ,SEAL_CODE_ID CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,LOCK_TYPE_ID CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,IDR_RECIPIENT_CD CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,INSULATED_IND CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,DEVICE_NO CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,CODE_ATT_TYPE CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,CODE_SHORT_DESC CHAR(15)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,MTR_ATT_TYPE_TX CHAR(25)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,CODE_METER_TYPE CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,GIS_MISMATCH_FL CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,MTR_RLTN_EXISTS CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS    THRU 8000A-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100A'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,LTRIM(RTRIM(METER_NO))             AS METER_NO          
                      ,MTR_REF_NO                  AS MTR_REF_NO        
                      ,LTRIM(RTRIM(CODE_UTIL_TYPE))       AS 
           CODE_UTIL_TYPE    
                      ,IC_NO                       AS IC_NO             
                      ,LTRIM(RTRIM(RATE_PLAN_NO))         AS 
           RATE_PLAN_NO      
                      ,LTRIM(RTRIM(SECURE_RATE_FLAG))     AS 
           SECURE_RATE_FLAG  
                      ,NO_READ_DIALS               AS NO_READ_DIALS     
                      ,CONSTANT                    AS CONSTANT          
                      ,LTRIM(RTRIM(METER_TYPE))           AS METER_TYPE        
                      ,LTRIM(RTRIM(ELEC_MTR_FORM_CD))     AS 
           ELEC_MTR_FORM_CD  
                      ,MONTHS_INACTIVE             AS MONTHS_INACTIVE   
                      ,CCF_CAP_PER_HR              AS CCF_CAP_PER_HR    
                      ,LTRIM(RTRIM(CONNECTION_TYPE))      AS 
           CONNECTION_TYPE   
                      ,LTRIM(RTRIM(OPTIMUM_READ_DATE))    AS 
           OPTIMUM_READ_DATE 
                      ,LTRIM(RTRIM(POINT_ID))             AS POINT_ID          
                      ,LTRIM(RTRIM(LAST_VALID_READ_DT))   AS 
           LAST_VALID_READ_DT
                      ,LTRIM(RTRIM(CODE_METER_STATUS))    AS 
           CODE_METER_STATUS 
                      ,LTRIM(RTRIM(MTR_READ_SOURCE_CD))   AS 
           MTR_READ_SOURCE_CD
                      ,LTRIM(RTRIM(REMOTE_READ_IND))      AS 
           REMOTE_READ_IND   
                      ,LTRIM(RTRIM(CODE_MTR_RD_INST1))    AS 
           CODE_MTR_RD_INST1 
                      ,LTRIM(RTRIM(CODE_MTR_RD_INST2))    AS 
           CODE_MTR_RD_INST2 
                      ,LTRIM(RTRIM(CODE_MTR_RD_INST3))    AS 
           CODE_MTR_RD_INST3 
                      ,LTRIM(RTRIM(METER_PRESSURE))       AS 
           METER_PRESSURE    
                      ,LTRIM(RTRIM(CODE_METER_LOC))       AS 
           CODE_METER_LOC    
                      ,LTRIM(RTRIM(METER_SUPPLYING))      AS 
           METER_SUPPLYING   
                      ,LTRIM(RTRIM(DIGTL_MTR_TYPE))       AS 
           DIGTL_MTR_TYPE    
                      ,LTRIM(RTRIM(PROGRAM_ID))           AS PROGRAM_ID        
                      ,LTRIM(RTRIM(DATE_MTR_INSTALL))     AS 
           DATE_MTR_INSTALL  
                      ,NO_CONSEC_ESTIMATE          AS NO_CONSEC_ESTIMATE
                      ,MIN_NO_UNITS                AS MIN_NO_UNITS      
                      ,MAX_NO_UNITS                AS MAX_NO_UNITS      
                      ,LTRIM(RTRIM(UTILITY_SOURCE_CD))    AS 
           UTILITY_SOURCE_CD 
                      ,LTRIM(RTRIM(DELIVERY_LEVEL_CD))    AS 
           DELIVERY_LEVEL_CD 
                      ,PHASE                       AS NO_PHASE          
                      ,LTRIM(RTRIM(INDUST_BTU_ID))        AS 
           INDUST_BTU_ID     
                      ,REGISTER_RD_SEQ             AS REGISTER_RD_SEQ   
                      ,LTRIM(RTRIM(SEAL_CODE_ID))         AS 
           SEAL_CODE_ID      
                      ,LTRIM(RTRIM(LOCK_TYPE_ID))         AS 
           LOCK_TYPE_ID      
                      ,LTRIM(RTRIM(IDR_RECIPIENT_CD))     AS 
           IDR_RECIPIENT_CD  
                      ,LTRIM(RTRIM(INSULATED_IND))        AS 
           INSULATED_IND     
                      ,LTRIM(RTRIM(DEVICE_NO))            AS AMR_ID            
                      ,LTRIM(RTRIM(CODE_ATT_TYPE))        AS 
           CODE_ATT_TYPE     
                      ,LTRIM(RTRIM(CODE_SHORT_DESC))      AS AMR_VERSION       
                      ,LTRIM(RTRIM(MTR_ATT_TYPE_TX))      AS AMR_TYPE          
                      ,LTRIM(RTRIM(CODE_METER_TYPE))      AS 
           CODE_METER_TYPE   
                      ,LTRIM(RTRIM(GIS_MISMATCH_FL))      AS 
           GIS_MISMATCH_FL   
                      ,LTRIM(RTRIM(MTR_RLTN_EXISTS))      AS 
           MTR_RLTN_EXISTS   
                  FROM #CSR04643_R1                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,STRIP(METER_NO)             AS METER_NO                  
MFA-TR*               ,MTR_REF_NO                  AS MTR_REF_NO                
MFA-TR*               ,STRIP(CODE_UTIL_TYPE)       AS CODE_UTIL_TYPE            
MFA-TR*               ,IC_NO                       AS IC_NO                     
MFA-TR*               ,STRIP(RATE_PLAN_NO)         AS RATE_PLAN_NO              
MFA-TR*               ,STRIP(SECURE_RATE_FLAG)     AS SECURE_RATE_FLAG          
MFA-TR*               ,NO_READ_DIALS               AS NO_READ_DIALS             
MFA-TR*               ,CONSTANT                    AS CONSTANT                  
MFA-TR*               ,STRIP(METER_TYPE)           AS METER_TYPE                
MFA-TR*               ,STRIP(ELEC_MTR_FORM_CD)     AS ELEC_MTR_FORM_CD          
MFA-TR*               ,MONTHS_INACTIVE             AS MONTHS_INACTIVE           
MFA-TR*               ,CCF_CAP_PER_HR              AS CCF_CAP_PER_HR            
MFA-TR*               ,STRIP(CONNECTION_TYPE)      AS CONNECTION_TYPE           
MFA-TR*               ,STRIP(OPTIMUM_READ_DATE)    AS OPTIMUM_READ_DATE         
MFA-TR*               ,STRIP(POINT_ID)             AS POINT_ID                  
MFA-TR*               ,STRIP(LAST_VALID_READ_DT)   AS LAST_VALID_READ_DT        
MFA-TR*               ,STRIP(CODE_METER_STATUS)    AS CODE_METER_STATUS         
MFA-TR*               ,STRIP(MTR_READ_SOURCE_CD)   AS MTR_READ_SOURCE_CD        
MFA-TR*               ,STRIP(REMOTE_READ_IND)      AS REMOTE_READ_IND           
MFA-TR*               ,STRIP(CODE_MTR_RD_INST1)    AS CODE_MTR_RD_INST1         
MFA-TR*               ,STRIP(CODE_MTR_RD_INST2)    AS CODE_MTR_RD_INST2         
MFA-TR*               ,STRIP(CODE_MTR_RD_INST3)    AS CODE_MTR_RD_INST3         
MFA-TR*               ,STRIP(METER_PRESSURE)       AS METER_PRESSURE            
MFA-TR*               ,STRIP(CODE_METER_LOC)       AS CODE_METER_LOC            
MFA-TR*               ,STRIP(METER_SUPPLYING)      AS METER_SUPPLYING           
MFA-TR*               ,STRIP(DIGTL_MTR_TYPE)       AS DIGTL_MTR_TYPE            
MFA-TR*               ,STRIP(PROGRAM_ID)           AS PROGRAM_ID                
MFA-TR*               ,STRIP(DATE_MTR_INSTALL)     AS DATE_MTR_INSTALL          
MFA-TR*               ,NO_CONSEC_ESTIMATE          AS NO_CONSEC_ESTIMATE        
MFA-TR*               ,MIN_NO_UNITS                AS MIN_NO_UNITS              
MFA-TR*               ,MAX_NO_UNITS                AS MAX_NO_UNITS              
MFA-TR*               ,STRIP(UTILITY_SOURCE_CD)    AS UTILITY_SOURCE_CD         
MFA-TR*               ,STRIP(DELIVERY_LEVEL_CD)    AS DELIVERY_LEVEL_CD         
MFA-TR*               ,PHASE                       AS NO_PHASE                  
MFA-TR*               ,STRIP(INDUST_BTU_ID)        AS INDUST_BTU_ID             
MFA-TR*               ,REGISTER_RD_SEQ             AS REGISTER_RD_SEQ           
MFA-TR*               ,STRIP(SEAL_CODE_ID)         AS SEAL_CODE_ID              
MFA-TR*               ,STRIP(LOCK_TYPE_ID)         AS LOCK_TYPE_ID              
MFA-TR*               ,STRIP(IDR_RECIPIENT_CD)     AS IDR_RECIPIENT_CD          
MFA-TR*               ,STRIP(INSULATED_IND)        AS INSULATED_IND             
MFA-TR*               ,STRIP(DEVICE_NO)            AS AMR_ID                    
MFA-TR*               ,STRIP(CODE_ATT_TYPE)        AS CODE_ATT_TYPE             
MFA-TR*               ,STRIP(CODE_SHORT_DESC)      AS AMR_VERSION               
MFA-TR*               ,STRIP(MTR_ATT_TYPE_TX)      AS AMR_TYPE                  
MFA-TR*               ,STRIP(CODE_METER_TYPE)      AS CODE_METER_TYPE           
MFA-TR*               ,STRIP(GIS_MISMATCH_FL)      AS GIS_MISMATCH_FL           
MFA-TR*               ,STRIP(MTR_RLTN_EXISTS)      AS MTR_RLTN_EXISTS           
MFA-TR*           FROM SESSION.CSR04643_R1                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100B-DECLARE-GTT-R2 - CSS_REGISTER_READ                       *        
      ******************************************************************        
       0100B-DECLARE-GTT-R2.                                            
                                                                        
           MOVE 'SESSION.CSR04643_R2'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04643_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04643_R2
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,METER_NO CHAR(9)  COLLATE LATIN1_GENERAL_100_BIN2           
                   ,MTR_REF_NO              SMALLINT                    
                   ,CODE_UTIL_TYPE CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,IC_NO                   SMALLINT                    
                   ,REG_ID_NO               SMALLINT                    
                   ,CODE_TIME_PERIOD        SMALLINT                    
                   ,CODE_REG_STATUS CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,CODE_STATUS_REAS CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,CODE_NO_RD_REASON CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,LAST_VAL_RD_VALUE       DECIMAL(15,3)               
                   ,CODE_LAST_REG_READ CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,LAST_VALID_READ_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,LAST_VALID_READ_TM CHAR(8)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,LAST_READ_VALUE         DECIMAL(15,3)               
                   ,CODE_LAST_VALID_RD CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,LAST_REG_READ_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,LAST_REG_READ_TM CHAR(8)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,NO_READ_DIALS           SMALLINT                    
                   ,CONSTANT                DECIMAL(9,3)                
                   ,METER_USAGE_DESC CHAR(35)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,READ_SEQUENCE_NO        SMALLINT                    
                   ,CODE_CRNT_REG_READ CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000B-DEL-GTT-ROWS    THRU 8000B-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100B'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C2 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,LTRIM(RTRIM(METER_NO))             AS METER_NO          
                      ,MTR_REF_NO                  AS MTR_REF_NO        
                      ,LTRIM(RTRIM(CODE_UTIL_TYPE))       AS 
           CODE_UTIL_TYPE    
                      ,IC_NO                       AS IC_NO             
                      ,REG_ID_NO                   AS REG_ID_NO         
                      ,CODE_TIME_PERIOD            AS CODE_TIME_PERIOD  
                      ,LTRIM(RTRIM(CODE_REG_STATUS))      AS 
           CODE_REG_STATUS   
                      ,LTRIM(RTRIM(CODE_STATUS_REAS))     AS 
           CODE_STATUS_REAS  
                      ,LTRIM(RTRIM(CODE_NO_RD_REASON))    AS 
           CODE_NO_RD_REASON 
                      ,LAST_VAL_RD_VALUE           AS LAST_VAL_RD_VALUE 
                      ,LTRIM(RTRIM(CODE_LAST_VALID_RD))   AS 
           CODE_LAST_VALID_RD
                      ,LTRIM(RTRIM(LAST_VALID_READ_DT))   AS 
           LAST_VALID_READ_DT
                      ,LTRIM(RTRIM(LAST_VALID_READ_TM))   AS 
           LAST_VALID_READ_TM
                      ,LAST_READ_VALUE             AS LAST_READ_VALUE   
                      ,LTRIM(RTRIM(CODE_LAST_REG_READ))   AS 
           CODE_LAST_REG_READ
                      ,LTRIM(RTRIM(LAST_REG_READ_DT))     AS 
           LAST_REG_READ_DT  
                      ,LTRIM(RTRIM(LAST_REG_READ_TM))     AS 
           LAST_REG_READ_TM  
                      ,NO_READ_DIALS               AS NO_READ_DIALS     
                      ,CONSTANT                    AS CONSTANT          
                      ,LTRIM(RTRIM(METER_USAGE_DESC))     AS 
           REGISTER_USAGE    
                      ,READ_SEQUENCE_NO            AS READ_SEQUENCE_NO  
                      ,CODE_CRNT_REG_READ          AS CODE_CRNT_REG_READ
                  FROM #CSR04643_R2                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C2 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,STRIP(METER_NO)             AS METER_NO                  
MFA-TR*               ,MTR_REF_NO                  AS MTR_REF_NO                
MFA-TR*               ,STRIP(CODE_UTIL_TYPE)       AS CODE_UTIL_TYPE            
MFA-TR*               ,IC_NO                       AS IC_NO                     
MFA-TR*               ,REG_ID_NO                   AS REG_ID_NO                 
MFA-TR*               ,CODE_TIME_PERIOD            AS CODE_TIME_PERIOD          
MFA-TR*               ,STRIP(CODE_REG_STATUS)      AS CODE_REG_STATUS           
MFA-TR*               ,STRIP(CODE_STATUS_REAS)     AS CODE_STATUS_REAS          
MFA-TR*               ,STRIP(CODE_NO_RD_REASON)    AS CODE_NO_RD_REASON         
MFA-TR*               ,LAST_VAL_RD_VALUE           AS LAST_VAL_RD_VALUE         
MFA-TR*               ,STRIP(CODE_LAST_VALID_RD)   AS CODE_LAST_VALID_RD        
MFA-TR*               ,STRIP(LAST_VALID_READ_DT)   AS LAST_VALID_READ_DT        
MFA-TR*               ,STRIP(LAST_VALID_READ_TM)   AS LAST_VALID_READ_TM        
MFA-TR*               ,LAST_READ_VALUE             AS LAST_READ_VALUE           
MFA-TR*               ,STRIP(CODE_LAST_REG_READ)   AS CODE_LAST_REG_READ        
MFA-TR*               ,STRIP(LAST_REG_READ_DT)     AS LAST_REG_READ_DT          
MFA-TR*               ,STRIP(LAST_REG_READ_TM)     AS LAST_REG_READ_TM          
MFA-TR*               ,NO_READ_DIALS               AS NO_READ_DIALS             
MFA-TR*               ,CONSTANT                    AS CONSTANT                  
MFA-TR*               ,STRIP(METER_USAGE_DESC)     AS REGISTER_USAGE            
MFA-TR*               ,READ_SEQUENCE_NO            AS READ_SEQUENCE_NO          
MFA-TR*               ,CODE_CRNT_REG_READ          AS CODE_CRNT_REG_READ        
MFA-TR*           FROM SESSION.CSR04643_R2                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100B-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100C-DECLARE-GTT-R3                                           *        
      ******************************************************************        
       0100C-DECLARE-GTT-R3.                                            
                                                                        
           MOVE 'SESSION.CSR04643_R3'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04643_R3')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04643_R3
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,BUS_RULE_ID CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BUS_RULE_RESULT_CD CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BUS_RULE_XREF_ID CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000C-DEL-GTT-ROWS    THRU 8000C-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100C'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C3 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,LTRIM(RTRIM(BUS_RULE_ID))          AS BUS_RULE_ID       
                      ,LTRIM(RTRIM(BUS_RULE_RESULT_CD))   AS 
           BUS_RULE_RESULT_CD
                      ,LTRIM(RTRIM(BUS_RULE_XREF_ID))     AS 
           BUS_RULE_XREF_ID  
                  FROM #CSR04643_R3                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C3 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,STRIP(BUS_RULE_ID)          AS BUS_RULE_ID               
MFA-TR*               ,STRIP(BUS_RULE_RESULT_CD)   AS BUS_RULE_RESULT_CD        
MFA-TR*               ,STRIP(BUS_RULE_XREF_ID)     AS BUS_RULE_XREF_ID          
MFA-TR*           FROM SESSION.CSR04643_R3                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100C-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100D-DECLARE-GTT-R4                                           *        
      ******************************************************************        
       0100D-DECLARE-GTT-R4.                                            
                                                                        
           MOVE 'SESSION.CSR04643_R4'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04643_R4')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04643_R4
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,DIST_COMPANY_NO CHAR(03)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,DIST_ACCOUNT_NO CHAR(20)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,DIST_METER_NO CHAR(09)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,CODE_UTIL_TYPE CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,METER_NO CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,STATUS_CD CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,STATUS_DESC CHAR(80)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000D-DEL-GTT-ROWS    THRU 8000D-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100D'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C4 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,LTRIM(RTRIM(DIST_COMPANY_NO))      AS 
           DIST_COMPANY_NO   
                      ,LTRIM(RTRIM(DIST_ACCOUNT_NO))      AS 
           DIST_ACCOUNT_NO   
                      ,LTRIM(RTRIM(DIST_METER_NO))        AS 
           DIST_METER_NO     
                      ,LTRIM(RTRIM(CODE_UTIL_TYPE))       AS 
           CODE_UTIL_TYPE    
                      ,LTRIM(RTRIM(METER_NO))             AS METER_NO          
                      ,LTRIM(RTRIM(STATUS_CD))            AS STATUS_CD         
                      ,LTRIM(RTRIM(STATUS_DESC))          AS STATUS_DESC       
                  FROM #CSR04643_R4                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C4 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,STRIP(DIST_COMPANY_NO)      AS DIST_COMPANY_NO           
MFA-TR*               ,STRIP(DIST_ACCOUNT_NO)      AS DIST_ACCOUNT_NO           
MFA-TR*               ,STRIP(DIST_METER_NO)        AS DIST_METER_NO             
MFA-TR*               ,STRIP(CODE_UTIL_TYPE)       AS CODE_UTIL_TYPE            
MFA-TR*               ,STRIP(METER_NO)             AS METER_NO                  
MFA-TR*               ,STRIP(STATUS_CD)            AS STATUS_CD                 
MFA-TR*               ,STRIP(STATUS_DESC)          AS STATUS_DESC               
MFA-TR*           FROM SESSION.CSR04643_R4                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100D-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           PERFORM 1050-INITIALIZE             THRU  1050-EXIT.         
                                                                        
           MOVE I-ACCOUNT-NO                TO MN-ACCOUNT-NO            
                                               AT-ACCOUNT-NO            
                                               RG-ACCOUNT-NO            
                                               CX-ACCOUNT-NO            
                                               UT-ACCOUNT-NO            
                                               XM-ACCOUNT-NO.           
                                                                        
           MOVE I-CODE-UTIL-TYPE            TO MN-CODE-UTIL-TYPE        
                                               RG-CODE-UTIL-TYPE        
                                               UT-CODE-UTIL-TYPE        
                                               CX-CODE-UTIL-TYPE        
                                               MC-CODE-UTIL-TYPE        
                                               MA-CODE-UTIL-TYPE        
                                               LX-CODE-UTIL-TYPE        
                                               OA-CODE-UTIL-TYPE        
                                               WS-KEY-UTIL-TYPE.        
                                                                        
           MOVE I-IC-NO                     TO MN-IC-NO                 
                                               RG-IC-NO                 
                                               UT-IC-NO                 
                                               CX-IC-NO                 
                                               WS-KEY-IC-NO.            
                                                                        
           MOVE I-METER-NO                  TO MN-METER-NO              
                                               RG-METER-NO              
                                               CX-METER-NO              
                                               EM-METER-NO              
                                               GM-METER-NO              
                                               MC-METER-NO              
                                               MA-METER-NO              
                                               WS-KEY-METER-NO.         
                                                                        
           MOVE I-MTR-REF-NO                TO MN-MTR-REF-NO            
                                               RG-MTR-REF-NO            
                                               CX-MTR-REF-NO            
                                               WS-KEY-MTR-REF-NO.       
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1        THRU 0100A-EXIT.         
           PERFORM 0100B-DECLARE-GTT-R2        THRU 0100B-EXIT.         
           PERFORM 0100C-DECLARE-GTT-R3        THRU 0100C-EXIT.         
           PERFORM 0100D-DECLARE-GTT-R4        THRU 0100D-EXIT.         
                                                                        
      *    GET THE DATABASE.                                                    
           MOVE WS-DELINQ-CD                TO C8-DELINQ-CD.            
           MOVE '01'                        TO C8-COMPANY-NO.           
           PERFORM 7300-GET-DELINQ-VALUE       THRU 7300-EXIT.          
           MOVE C8-DELINQ-VALUE             TO WS-DATABASE.             
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2000-PROCESS-OUTPUT                                            *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           SET WS-CD-VAL-INDX   TO 1                                    
           PERFORM 7500-OPEN-CODE-VALUE-CUR      THRU 7500-EXIT.        
           PERFORM 7510-FETCH-CODE-VALUE-CUR     THRU 7510-EXIT.        
           PERFORM 2101-LOAD-CODE-VALUES         THRU 2101-EXIT         
                                                 UNTIL NO-MORE-CD-VALUE 
           PERFORM 7520-CLOSE-CODE-VALUE-CUR     THRU 7520-EXIT.        
                                                                        
           PERFORM 2100-LOAD-MTRD-ENVRNMT        THRU  2100-EXIT.       
           PERFORM 2200-LOAD-REGISTER-READ       THRU  2200-EXIT.       
           IF SEB-DATABASE                                              
              PERFORM 2500-LOAD-AGL-DIST-METER-DET                      
                                                 THRU  2500-EXIT        
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 1050-INITIALIZE.                                               *        
      ******************************************************************        
       1050-INITIALIZE.                                                 
                                                                        
           INITIALIZE      DCLCSS-MTRD-ENVRNMT                          
                           U0-ELEC-MTR-FORM-CD                          
                           M5-CCF-CAP-PER-HR                            
                           U0-MTR-CONNECT-TYP-ID                        
                           U4-NO-PHASES                                 
                           N5-MTR-ATT-TYPE-TX                           
                           GM-CODE-METER-TYPE                           
                           MA-DEVICE-NO                                 
                           MA-CODE-ATT-TYPE                             
                           M1-METER-SIZE-DESC                           
                           M5-METER-SIZE-DESC                           
                           UV-CODE-LONG-DESC-TEXT.                      
                                                                        
       1050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2100-LOAD-MTRD-ENVRNMT.                                        *        
      ******************************************************************        
       2100-LOAD-MTRD-ENVRNMT.                                          
                                                                        
           PERFORM 7180-GET-CURRENT-DATE          THRU 7180-EXIT.       
           PERFORM 7000-SELECT-MTRD-ENVRNMT       THRU 7000-EXIT.       
           PERFORM 7020-GET-RATE-PLAN-NO          THRU 7020-EXIT.       
                                                                        
           MOVE MN-REG-ID-NO                   TO MC-REG-ID-NO          
           MOVE UT-COMPANY-NO                  TO MC-COMPANY-NO         
                                                  CX-COMPANY-NO         
                                                  EM-COMPANY-NO         
                                                  MA-COMPANY-NO         
                                                  LX-COMPANY-NO         
                                                  UV-COMPANY-NO         
                                                  GM-COMPANY-NO.        
                                                                        
           MOVE MN-DIGTL-MTR-TYPE              TO OA-DIGTL-MTR-TYPE     
           MOVE MN-PROGRAM-ID                  TO OA-PROGRAM-ID         
           MOVE MN-REMOTE-READ-IND             TO OA-REMOTE-READ-IND    
           MOVE MN-MTR-READ-SOURCE-CD          TO OA-MTR-READ-SOURCE-CD 
           MOVE MN-CODE-USAGE-TYPE             TO OA-CODE-USAGE-TYPE    
           MOVE MN-CODE-TIME-PERIOD            TO OA-CODE-TIME-PERIOD   
           MOVE MN-CODE-USAGE-ID               TO OA-CODE-USAGE-ID      
           MOVE WS-ZERO                        TO OA-READ-SEQUENCE-NO   
           PERFORM 7230-GET-READ-SEQ-NO           THRU 7230-EXIT.       
                                                                        
           PERFORM 2105-GET-NEXT-READ-DATE        THRU 2105-EXIT.       
           PERFORM 2110-GET-DIAL-CONSTANT         THRU 2110-EXIT.       
           PERFORM 2120-GET-POINT-ID              THRU 2120-EXIT.       
           PERFORM 2130-GET-METER-TYPE            THRU 2130-EXIT.       
           PERFORM 2140-GET-LAST-READING-DT       THRU 2140-EXIT.       
           PERFORM 2150-GET-AMR-DETAILS           THRU 2150-EXIT.       
           PERFORM 2160-SET-MTR-REG-READ-DET      THRU 2160-EXIT.       
           PERFORM 2170-CHECK-MTR-RLTN-EXISTS     THRU 2170-EXIT.       
                                                                        
      *    TO GET MONTHS INACTIVE VALUE                                         
           COMPUTE WS-MONTHS-INACTIVE = (WS-INACTIVE-YEAR * 12) +       
                                         WS-INACTIVE-MONTH.             
                                                                        
           PERFORM 2400-MOVE-METER-RS1            THRU 2400-EXIT.       
           PERFORM 2410-MOVE-REG-READ-RS2         THRU 2410-EXIT.       
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2101-LOAD-CODE-VALUES.                                         *        
      ******************************************************************        
       2101-LOAD-CODE-VALUES.                                           
                                                                        
           MOVE UV-CODE-VALUE-TEXT(1:UV-CODE-VALUE-LEN)                 
                                   TO WS-CODE-VALUE(WS-CD-VAL-INDX)     
           MOVE UV-COMPANY-NO      TO WS-COMPANY-NO(WS-CD-VAL-INDX)     
           MOVE UV-COLUMN-NA-TEXT(1:UV-COLUMN-NA-LEN)                   
                                   TO WS-COLUMN-NA(WS-CD-VAL-INDX)      
           MOVE UV-TABLE-NA-TEXT(1:UV-TABLE-NA-LEN)                     
                                   TO WS-TABLE-NA(WS-CD-VAL-INDX)       
           MOVE UV-CODE-LONG-DESC-TEXT(1:UV-CODE-LONG-DESC-LEN)         
                                   TO WS-CODE-LONG-DESC(WS-CD-VAL-INDX) 
           MOVE UV-CODE-SHORT-DESC-TEXT(1:UV-CODE-SHORT-DESC-LEN)       
                                  TO WS-CODE-SHORT-DESC(WS-CD-VAL-INDX) 
           MOVE UV-SORT-ORDER     TO WS-CODE-SORT-ORDER(WS-CD-VAL-INDX) 
                                                                        
           SET WS-CD-VAL-INDX UP BY 1                                   
           INITIALIZE DCLCSS-CODE-VALUE                                 
           PERFORM 7510-FETCH-CODE-VALUE-CUR THRU 7510-EXIT.            
                                                                        
       2101-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2105-GET-NEXT-READ-DATE.                                       *        
      ******************************************************************        
       2105-GET-NEXT-READ-DATE.                                         
                                                                        
      *    GET NEXT READ DATE USING COPYBOOK CPD00310.                          
A05460     IF UT-READ-CYCLE > SPACES                                    
A05460        PERFORM 7910-SELECT-NXT-RD-DT                             
A05460                       THRU 7910-SELECT-NXT-RD-DT-EXIT            
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                 IF RW-THIRD-PTY-READ-DT GREATER THAN SPACES            
                    MOVE RW-THIRD-PTY-READ-DT  TO WS-OPTIMUM-READ-DATE  
                 ELSE                                                   
                    MOVE RW-OPTIMUM-READ-DATE  TO WS-OPTIMUM-READ-DATE  
                 END-IF                                                 
              END-IF                                                    
A05460     END-IF.                                                      
                                                                        
       2105-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2110-GET-DIAL-CONSTANT.                                        *        
      ******************************************************************        
       2110-GET-DIAL-CONSTANT.                                          
                                                                        
           PERFORM 7100-GET-METER-CAP-DETAILS     THRU 7100-EXIT        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE MC-CONSTANT                 TO WS-CONSTANT           
              MOVE MC-NO-READ-DIALS            TO WS-NO-READ-DIALS      
           ELSE                                                         
              PERFORM 7110-GET-DET-CONSUMP-HIST   THRU 7110-EXIT        
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                 MOVE CX-CONSTANT              TO WS-CONSTANT           
                 MOVE CX-NO-DIALS              TO WS-NO-READ-DIALS      
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2120-GET-POINT-ID.                                             *        
      ******************************************************************        
       2120-GET-POINT-ID.                                               
                                                                        
           IF WS-KEY-UTIL-TYPE EQUAL WS-ELECTRIC                        
              AND MN-GIS-POINT-ID GREATER THAN WS-ZERO                  
              PERFORM 7120-GET-GIS-LOC-AND-TAG      THRU 7120-EXIT      
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                 STRING PP-AREA-ID(1:3)  DELIMITED BY SIZE              
                        PP-TAG-NM(1:7)   DELIMITED BY SIZE              
                   INTO WS-POINT-ID                                     
                 END-STRING                                             
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2130-GET-METER-TYPE.                                           *        
      ******************************************************************        
       2130-GET-METER-TYPE.                                             
                                                                        
           INITIALIZE                       DCLCSS-ELEC-MTR-CLASS       
                                            DCLCSS-ELEC-CL-SPEC.        
                                                                        
           IF WS-KEY-UTIL-TYPE EQUAL WS-ELECTRIC                        
              PERFORM 7130-GET-ELEC-METER         THRU 7130-EXIT        
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                 PERFORM 7135-GET-ELEC-MTR-DET    THRU 7135-EXIT        
                 PERFORM 7140-GET-ELEC-METER-SIZE THRU 7140-EXIT        
              END-IF                                                    
           ELSE                                                         
              PERFORM 7150-GET-GAS-METER          THRU 7150-EXIT        
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                 PERFORM 7160-GET-GAS-METER-SIZE  THRU 7160-EXIT        
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2130-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2140-GET-LAST-READING-DT.                                      *        
      ******************************************************************        
       2140-GET-LAST-READING-DT.                                        
                                                                        
ACT163*    IF MN-LAST-VALID-READ-TM EQUAL '24.00.00'                            
ACT163*       MOVE MN-LAST-VALID-READ-DT       TO WS-DATE-READ                  
ACT163*       PERFORM 7170-ADD-ONE-DAY            THRU 7170-EXIT                
ACT163*       MOVE WS-DATE-READ                TO WS-LAST-VALID-READ-DT         
ACT163*       MOVE '00.00.00'                  TO MN-LAST-VALID-READ-TM         
ACT163*    ELSE                                                                 
           MOVE MN-LAST-VALID-READ-DT          TO WS-LAST-VALID-READ-DT.
ACT163*    END-IF.                                                              
                                                                        
       2140-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2150-GET-AMR-DETAILS.                                          *        
      ******************************************************************        
       2150-GET-AMR-DETAILS.                                            
                                                                        
           PERFORM 7190-GET-AMR-DETAILS           THRU 7190-EXIT.       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE MA-CODE-ATT-TYPE            TO LX-CODE-ATT-TYPE      
              MOVE MA-DEVICE-NO                TO LX-DEVICE-NO          
              PERFORM 7200-GET-VERSION-NO         THRU 7200-EXIT        
           END-IF.                                                      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              STRING LX-CODE-UTIL-TYPE                                  
                     LX-CODE-ATT-TYPE                                   
                     LX-VERSION-CD                                      
                     DELIMITED BY SIZE                                  
                     INTO WS-VERSION-CD-VALUE                           
              PERFORM 2155-GET-VER-CD-SHRT-DESC  THRU 2155-EXIT         
           END-IF.                                                      
                                                                        
       2150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2155-GET-VER-CD-SHRT-DESC.                                    *         
      ******************************************************************        
       2155-GET-VER-CD-SHRT-DESC.                                       
                                                                        
      *    VERSION_CD SHORT DESCRIPTION                                         
           MOVE WS-VERSION-CD-VALUE         TO WS-SRCH-CODE-VALUE.      
           MOVE WS-VERSION-CD               TO WS-SRCH-COLUMN-NA.       
           MOVE WS-EQUIP-ATTCHMTS           TO WS-SRCH-TABLE-NA.        
           PERFORM 5000-SEARCH-CD-VALUE        THRU 5000-EXIT.          
           MOVE WS-SHORT-DESC               TO WS-VER-CD-SHRT-DESC.     
                                                                        
       2155-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2160-SET-MTR-REG-READ-DET.                                     *        
      ******************************************************************        
       2160-SET-MTR-REG-READ-DET.                                       
                                                                        
           MOVE MN-REG-ID-NO                   TO RG-REG-ID-NO          
           MOVE MN-CODE-METER-STATUS           TO RG-CODE-REG-STATUS    
           MOVE MN-LAST-VALID-READ-TM          TO RG-LAST-VALID-READ-TM 
           MOVE MN-CODE-TIME-PERIOD            TO RG-CODE-TIME-PERIOD   
           MOVE MN-CODE-STATUS-REAS            TO RG-CODE-STATUS-REAS   
           MOVE MN-CODE-NO-RD-REASON           TO RG-CODE-NO-RD-REASON  
           MOVE MN-LAST-VAL-RD-VALUE           TO RG-LAST-VAL-RD-VALUE  
           MOVE MN-CODE-LAST-REG-READ          TO RG-CODE-LAST-REG-READ 
           MOVE MN-LAST-READ-VALUE             TO RG-LAST-READ-VALUE    
           MOVE MN-CODE-LAST-VALID-RD          TO RG-CODE-LAST-VALID-RD 
           MOVE MN-LAST-REG-READ-TIME          TO RG-LAST-REG-READ-TM   
           MOVE MN-CODE-CRNT-REG-READ          TO RG-CODE-CRNT-REG-READ 
                                                                        
           IF MN-LAST-REG-READ-TIME EQUAL '24.00.00'                    
              MOVE MN-LAST-REG-READ-DATE       TO WS-DATE-READ          
              PERFORM 7170-ADD-ONE-DAY            THRU 7170-EXIT        
              MOVE WS-DATE-READ                TO WS-LAST-REG-READ-DT   
              MOVE '00.00.00'                  TO MN-LAST-REG-READ-TIME 
                                                  RG-LAST-REG-READ-TM   
           ELSE                                                         
              MOVE MN-LAST-REG-READ-DATE       TO WS-LAST-REG-READ-DT   
           END-IF.                                                      
                                                                        
           MOVE MN-CODE-USAGE-ID               TO S5-CODE-USAGE-ID      
           MOVE MN-CODE-USAGE-TYPE             TO S5-CODE-USAGE-TYPE    
           MOVE MN-CODE-USAGE-SOURCE           TO S5-CODE-USAGE-SOURCE  
           PERFORM 7220-GET-MTR-USAGE-DESC        THRU 7220-EXIT.       
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              MOVE SPACES                      TO S5-METER-USAGE-DESC   
           END-IF.                                                      
                                                                        
       2160-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2170-CHECK-MTR-RLTN-EXISTS                                     *        
      ******************************************************************        
       2170-CHECK-MTR-RLTN-EXISTS.                                      
                                                                        
           MOVE MN-ACCOUNT-NO                  TO UR-ACCOUNT-NO-MST     
                                                  UR-ACCOUNT-NO-DEP.    
                                                                        
           MOVE MN-CODE-UTIL-TYPE              TO UR-CODE-UTIL-TYPE-MST 
                                                  UR-CODE-UTIL-TYPE-DEP.
                                                                        
           MOVE MN-IC-NO                       TO UR-IC-NO-MST          
                                                  UR-IC-NO-DEP.         
                                                                        
           MOVE MN-MTR-REF-NO                  TO UR-MTR-REF-NO-MST     
                                                  UR-MTR-REF-NO-DEP.    
                                                                        
           PERFORM 7530-CHK-MTR-REL-MST           THRU 7530-EXIT.       
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              PERFORM 7540-CHK-MTR-REL-DEP        THRU 7540-EXIT        
           END-IF.                                                      
                                                                        
       2170-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2200-LOAD-REGISTER-READ.                                       *        
      ******************************************************************        
       2200-LOAD-REGISTER-READ.                                         
                                                                        
           PERFORM 7005-OPEN-REGISTER-RD-CUR      THRU 7005-EXIT.       
           PERFORM 7010-FETCH-REGISTER-RD-CUR     THRU 7010-EXIT.       
                                                                        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
             PERFORM 2300-BUILD-REGISTER-DATA     THRU 2300-EXIT        
             PERFORM 2410-MOVE-REG-READ-RS2       THRU 2410-EXIT        
             PERFORM 7010-FETCH-REGISTER-RD-CUR   THRU 7010-EXIT        
           END-PERFORM.                                                 
                                                                        
           PERFORM 7015-CLOSE-REGISTER-RD-CUR     THRU 7015-EXIT.       
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2250-GET-DISTXRF-MTR-LNG-DESC.                                 *        
      ******************************************************************        
       2250-GET-DISTXRF-MTR-LNG-DESC.                                   
                                                                        
      *    STATUS_CD LONG DESCRIPTION                                           
           MOVE TM-STATUS-CD                TO WS-SRCH-CODE-VALUE.      
           MOVE WS-STATUS-CD                TO WS-SRCH-COLUMN-NA.       
           MOVE WS-DIST-XREF-MTR            TO WS-SRCH-TABLE-NA.        
           PERFORM 5000-SEARCH-CD-VALUE        THRU 5000-EXIT.          
           MOVE WS-LONG-DESC                TO WS-CD-STAT-LNG-DESC.     
                                                                        
       2250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2300-BUILD-REGISTER-DATA.                                      *        
      ******************************************************************        
       2300-BUILD-REGISTER-DATA.                                        
                                                                        
      *      GET LAST VALID READ DATE.                                          
             IF RG-LAST-VALID-READ-TM EQUAL '24.00.00'                  
                MOVE RG-LAST-VALID-READ-DT     TO WS-DATE-READ          
                PERFORM 7170-ADD-ONE-DAY          THRU 7170-EXIT        
                MOVE WS-DATE-READ              TO WS-LAST-VALID-READ-DT 
                MOVE '00.00.00'                TO RG-LAST-VALID-READ-TM 
             ELSE                                                       
                MOVE RG-LAST-VALID-READ-DT     TO WS-LAST-VALID-READ-DT 
             END-IF                                                     
                                                                        
      *      GET DIALS & CONSTANT                                               
             MOVE RG-REG-ID-NO                 TO MC-REG-ID-NO          
             MOVE WS-ZERO                      TO WS-CONSTANT           
             MOVE WS-ZERO                      TO WS-NO-READ-DIALS      
             PERFORM 2110-GET-DIAL-CONSTANT       THRU 2110-EXIT        
                                                                        
      *      GET LAST REGISTER READ DATE                                        
             IF RG-LAST-REG-READ-TM EQUAL '24.00.00'                    
                MOVE RG-LAST-REG-READ-DT       TO WS-DATE-READ          
                PERFORM 7170-ADD-ONE-DAY          THRU 7170-EXIT        
                MOVE WS-DATE-READ              TO WS-LAST-REG-READ-DT   
                MOVE '00.00.00'                TO RG-LAST-REG-READ-TM   
             ELSE                                                       
                MOVE RG-LAST-REG-READ-DT       TO WS-LAST-REG-READ-DT   
             END-IF.                                                    
                                                                        
      *      GET REGISTER USAGE                                                 
             MOVE RG-CODE-USAGE-ID             TO S5-CODE-USAGE-ID      
             MOVE RG-CODE-USAGE-TYPE           TO S5-CODE-USAGE-TYPE    
             MOVE RG-CODE-USAGE-SOURCE         TO S5-CODE-USAGE-SOURCE  
             PERFORM 7220-GET-MTR-USAGE-DESC      THRU 7220-EXIT.       
             IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                   
                MOVE SPACES                    TO S5-METER-USAGE-DESC   
             END-IF.                                                    
                                                                        
      * GET READ SEQUENCE NUMBER.                                               
             MOVE RG-CODE-USAGE-TYPE           TO OA-CODE-USAGE-TYPE    
             MOVE RG-CODE-TIME-PERIOD          TO OA-CODE-TIME-PERIOD   
             MOVE RG-CODE-USAGE-ID             TO OA-CODE-USAGE-ID      
             MOVE WS-ZERO                      TO OA-READ-SEQUENCE-NO   
             PERFORM 7230-GET-READ-SEQ-NO         THRU 7230-EXIT.       
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2400-MOVE-METER-RS1.                                           *        
      ******************************************************************        
       2400-MOVE-METER-RS1.                                             
                                                                        
           MOVE WS-KEY-METER-NO           TO S-RS1-METER-NO             
           MOVE WS-KEY-MTR-REF-NO         TO S-RS1-MTR-REF-NO           
           MOVE WS-KEY-UTIL-TYPE          TO S-RS1-CODE-UTIL-TYPE       
           MOVE WS-KEY-IC-NO              TO S-RS1-IC-NO                
           MOVE UT-RATE-PLAN-NO           TO S-RS1-RATE-PLAN-NO         
           MOVE RD-SECURED-RATE-FL        TO S-RS1-SECURE-RATE-FLAG     
           MOVE WS-NO-READ-DIALS          TO S-RS1-NO-READ-DIALS        
           MOVE WS-CONSTANT               TO S-RS1-CONSTANT             
           MOVE WS-METER-SIZE-DESC        TO S-RS1-METER-TYPE           
           MOVE U0-ELEC-MTR-FORM-CD       TO S-RS1-ELEC-MTR-FORM-CD     
           MOVE WS-MONTHS-INACTIVE        TO S-RS1-MONTHS-INACTIVE      
           MOVE M5-CCF-CAP-PER-HR         TO S-RS1-CCF-CAP-PER-HR       
           MOVE U0-MTR-CONNECT-TYP-ID     TO S-RS1-CONNECTION-TYPE      
           MOVE WS-OPTIMUM-READ-DATE      TO S-RS1-OPTIMUM-READ-DATE    
           MOVE WS-POINT-ID               TO S-RS1-POINT-ID             
           MOVE WS-LAST-VALID-READ-DT     TO S-RS1-LAST-VALID-READ-DT   
           MOVE MN-CODE-METER-STATUS      TO S-RS1-CODE-METER-STATUS    
           MOVE MN-MTR-READ-SOURCE-CD     TO S-RS1-MTR-READ-SOURCE-CD   
           MOVE MN-REMOTE-READ-IND        TO S-RS1-REMOTE-READ-IND      
           MOVE MN-CODE-MTR-RD-INST1      TO S-RS1-CODE-MTR-RD-INST1    
           MOVE MN-CODE-MTR-RD-INST2      TO S-RS1-CODE-MTR-RD-INST2    
           MOVE MN-CODE-MTR-RD-INST3      TO S-RS1-CODE-MTR-RD-INST3    
           MOVE MN-METER-PRESSURE         TO S-RS1-METER-PRESSURE       
           MOVE MN-CODE-METER-LOC         TO S-RS1-CODE-METER-LOC       
           MOVE MN-METER-SUPPLYING        TO S-RS1-METER-SUPPLYING      
           MOVE MN-DIGTL-MTR-TYPE         TO S-RS1-DIGTL-MTR-TYPE       
           MOVE MN-PROGRAM-ID             TO S-RS1-PROGRAM-ID           
           MOVE MN-DATE-MTR-INSTALL       TO S-RS1-DATE-MTR-INSTALL     
           MOVE MN-NO-CONSEC-ESTIMATE     TO S-RS1-NO-CONSEC-ESTIMATE   
           MOVE MN-MIN-NO-UNITS           TO S-RS1-MIN-NO-UNITS         
           MOVE MN-MAX-NO-UNITS           TO S-RS1-MAX-NO-UNITS         
           MOVE MN-UTILITY-SOURCE-CD      TO S-RS1-UTILITY-SOURCE-CD    
           MOVE MN-DELIVERY-LEVEL-CD      TO S-RS1-DELIVERY-LEVEL-CD    
           MOVE U4-NO-PHASES              TO S-RS1-PHASE                
           MOVE MN-INDUST-BTU-ID          TO S-RS1-INDUST-BTU-ID        
           MOVE MN-REGISTER-RD-SEQ        TO S-RS1-REGISTER-RD-SEQ      
           MOVE MN-SEAL-CODE-ID           TO S-RS1-SEAL-CODE-ID         
           MOVE MN-LOCK-TYPE-ID           TO S-RS1-LOCK-TYPE-ID         
           MOVE MN-IDR-RECIPIENT-CD       TO S-RS1-IDR-RECIPIENT-CD     
           MOVE MN-INSULATED-IND          TO S-RS1-INSULATED-IND        
           MOVE MA-DEVICE-NO              TO S-RS1-DEVICE-NO            
           MOVE MA-CODE-ATT-TYPE          TO S-RS1-CODE-ATT-TYPE        
           MOVE WS-VER-CD-SHRT-DESC       TO S-RS1-CODE-SHORT-DESC      
           MOVE N5-MTR-ATT-TYPE-TX        TO S-RS1-MTR-ATT-TYPE-TX      
           MOVE GM-CODE-METER-TYPE        TO S-RS1-CODE-METER-TYPE      
           MOVE MN-GIS-MISMATCH-FL        TO S-RS1-GIS-MISMATCH-FL      
           MOVE WS-MTR-REL-EXIST          TO S-RS1-MTR-REL-EXISTS       
                                                                        
           PERFORM 8010-INSERT-GTT-R1        THRU 8010-EXIT.            
           INITIALIZE GTT-RETURN-FIELDS-1.                              
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2410-MOVE-REG-READ-RS2.                                        *        
      ******************************************************************        
       2410-MOVE-REG-READ-RS2.                                          
                                                                        
           MOVE WS-KEY-METER-NO           TO S-RS2-METER-NO             
           MOVE WS-KEY-MTR-REF-NO         TO S-RS2-MTR-REF-NO           
           MOVE WS-KEY-UTIL-TYPE          TO S-RS2-CODE-UTIL-TYPE       
           MOVE WS-KEY-IC-NO              TO S-RS2-IC-NO                
           MOVE RG-REG-ID-NO              TO S-RS2-REG-ID-NO            
           MOVE RG-CODE-TIME-PERIOD       TO S-RS2-CODE-TIME-PERIOD     
           MOVE RG-CODE-REG-STATUS        TO S-RS2-CODE-REG-STATUS      
           MOVE RG-CODE-STATUS-REAS       TO S-RS2-CODE-STATUS-REAS     
           MOVE RG-CODE-NO-RD-REASON      TO S-RS2-CODE-NO-RD-REASON    
           MOVE RG-LAST-VAL-RD-VALUE      TO S-RS2-LAST-VAL-RD-VALUE    
           MOVE RG-CODE-LAST-VALID-RD     TO S-RS2-CODE-LAST-VALID-RD   
           MOVE WS-LAST-VALID-READ-DT     TO S-RS2-LAST-VALID-READ-DT   
           MOVE RG-LAST-VALID-READ-TM     TO S-RS2-LAST-VALID-READ-TM   
           MOVE RG-LAST-READ-VALUE        TO S-RS2-LAST-READ-VALUE      
           MOVE RG-CODE-LAST-REG-READ     TO S-RS2-CODE-LAST-REG-READ   
           MOVE WS-LAST-REG-READ-DT       TO S-RS2-LAST-REG-READ-DT     
           MOVE RG-LAST-REG-READ-TM       TO S-RS2-LAST-REG-READ-TM     
           MOVE WS-NO-READ-DIALS          TO S-RS2-NO-READ-DIALS        
           MOVE WS-CONSTANT               TO S-RS2-CONSTANT             
           MOVE S5-METER-USAGE-DESC       TO S-RS2-METER-USAGE-DESC     
           MOVE OA-READ-SEQUENCE-NO       TO S-RS2-READ-SEQUENCE-NO     
           MOVE RG-CODE-CRNT-REG-READ     TO S-RS2-CODE-CRNT-REG-READ   
                                                                        
           PERFORM 8020-INSERT-GTT-R2        THRU 8020-EXIT.            
           INITIALIZE GTT-RETURN-FIELDS-2.                              
                                                                        
       2410-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2500-LOAD-AGL-DIST-METER-DET.                                  *        
      ******************************************************************        
       2500-LOAD-AGL-DIST-METER-DET.                                    
                                                                        
           PERFORM 7240-GET-MKT-XREF-ACCT         THRU 7240-EXIT.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE XM-DIST-ACCT-NO        TO TM-DIST-ACCOUNT-NO         
              PERFORM 7250-OPEN-DIST-MET-CUR      THRU 7250-EXIT        
              PERFORM 7260-FETCH-DIST-MET-CUR     THRU 7260-EXIT        
              PERFORM 2550-MOVE-DIST-MET-RS4      THRU 2550-EXIT        
                                          UNTIL NO-MORE-DIST-MET        
              PERFORM 7270-CLOSE-DIST-MET-CUR     THRU 7270-EXIT        
           END-IF.                                                      
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2550-MOVE-DIST-MET-RS4.                                        *        
      ******************************************************************        
       2550-MOVE-DIST-MET-RS4.                                          
                                                                        
           PERFORM 2250-GET-DISTXRF-MTR-LNG-DESC                        
                                                  THRU 2250-EXIT        
           MOVE TM-DIST-COMPANY-NO        TO S-RS4-DIST-COMPANY-NO.     
           MOVE TM-DIST-ACCOUNT-NO        TO S-RS4-DIST-ACCOUNT-NO.     
           MOVE TM-DIST-METER-NO          TO S-RS4-DIST-METER-NO.       
           MOVE TM-CODE-UTIL-TYPE         TO S-RS4-CODE-UTIL-TYPE.      
           MOVE TM-METER-NO               TO S-RS4-METER-NO.            
           MOVE TM-STATUS-CD              TO S-RS4-STATUS-CD.           
           MOVE WS-CD-STAT-LNG-DESC       TO S-RS4-STATUS-DESC.         
                                                                        
           PERFORM 8040-INSERT-GTT-R4        THRU 8040-EXIT.            
           INITIALIZE GTT-RETURN-FIELDS-4                               
           PERFORM 7260-FETCH-DIST-MET-CUR   THRU 7260-EXIT.            
                                                                        
       2550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      *                                                              *          
      * 5000-SEARCH-CD-VALUE.                                        *          
      ****************************************************************          
       5000-SEARCH-CD-VALUE.                                            
                                                                        
           SET WS-CD-VAL-INDX      TO 1                                 
           SEARCH WS-CODE-VALUE-DATA                                    
              AT END                                                    
              MOVE SPACES                    TO WS-LONG-DESC            
              MOVE SPACES                    TO WS-SHORT-DESC           
              MOVE WS-ZERO                   TO WS-SORT-ORDER           
           WHEN WS-CODE-VALUE(WS-CD-VAL-INDX) = WS-SRCH-CODE-VALUE      
            AND WS-COLUMN-NA(WS-CD-VAL-INDX)  = WS-SRCH-COLUMN-NA       
            AND WS-TABLE-NA(WS-CD-VAL-INDX)   = WS-SRCH-TABLE-NA        
                MOVE WS-CODE-LONG-DESC(WS-CD-VAL-INDX)                  
                                             TO WS-LONG-DESC            
                MOVE WS-CODE-SHORT-DESC(WS-CD-VAL-INDX)                 
                                             TO WS-SHORT-DESC           
                MOVE WS-CODE-SORT-ORDER(WS-CD-VAL-INDX)                 
                                             TO WS-SORT-ORDER           
           END-SEARCH.                                                  
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 22150000
      * 7910-SELECT-NXT-RD-DT.                                                  
      ***************************************************************** 22150000
           EXEC SQL                                                             
              INCLUDE CPD00310                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7000-SELECT-MTRD-ENVRNMT.                                      *        
      ******************************************************************        
       7000-SELECT-MTRD-ENVRNMT.                                        
                                                                        
           EXEC SQL                                                     
              SELECT MN.GIS_POINT_ID                                    
                    ,MN.LAST_VALID_READ_DT                              
                    ,REPLACE(CONVERT(CHAR(8), MN.LAST_VALID_READ_TM
           , 108), ':', '.') LAST_VALID_READ_TM                              
                    ,MN.CODE_METER_STATUS                               
                    ,MN.MTR_READ_SOURCE_CD                              
                    ,MN.REMOTE_READ_IND                                 
                    ,MN.CODE_MTR_RD_INST1                               
                    ,MN.CODE_MTR_RD_INST2                               
                    ,MN.CODE_MTR_RD_INST3                               
                    ,MN.METER_PRESSURE                                  
                    ,MN.CODE_METER_LOC                                  
                    ,MN.METER_SUPPLYING                                 
                    ,MN.DIGTL_MTR_TYPE                                  
                    ,MN.PROGRAM_ID                                      
                    ,MN.DATE_MTR_INSTALL                                
                    ,MN.NO_CONSEC_ESTIMATE                              
                    ,MN.MIN_NO_UNITS                                    
                    ,MN.MAX_NO_UNITS                                    
                    ,MN.UTILITY_SOURCE_CD                               
                    ,MN.DELIVERY_LEVEL_CD                               
                    ,MN.INDUST_BTU_ID                                   
                    ,MN.REGISTER_RD_SEQ                                 
                    ,MN.SEAL_CODE_ID                                    
                    ,MN.LOCK_TYPE_ID                                    
                    ,MN.IDR_RECIPIENT_CD                                
                    ,MN.INSULATED_IND                                   
                    ,CIS.DECIMAL2YEAR(CIS.DIFFDATE( 
              IIF(TRY_CONVERT(DATE, :WS-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-RUN-DATE
              ) <> 0) OR (LEN(:WS-RUN-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-RUN-DATE
              ), CONVERT(DATE, :WS-RUN-DATE) ), MTR_STATUS_CHNG_DT ))          
                    ,CIS.DECIMAL2MONTH(CIS.DIFFDATE( 
              IIF(TRY_CONVERT(DATE, :WS-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-RUN-DATE
              ) <> 0) OR (LEN(:WS-RUN-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-RUN-DATE
              ), CONVERT(DATE, :WS-RUN-DATE) ), MTR_STATUS_CHNG_DT ))          
                    ,MN.REG_ID_NO                                       
                    ,MN.CODE_METER_STATUS                               
                    ,REPLACE(CONVERT(CHAR(8), MN.LAST_VALID_READ_TM
           , 108), ':', '.') LAST_VALID_READ_TM                              
                    ,MN.CODE_TIME_PERIOD                                
                    ,MN.CODE_STATUS_REAS                                
                    ,MN.CODE_NO_RD_REASON                               
                    ,MN.LAST_VAL_RD_VALUE                               
                    ,MN.CODE_LAST_REG_READ                              
                    ,MN.LAST_READ_VALUE                                 
                    ,MN.CODE_LAST_VALID_RD                              
                    ,REPLACE(CONVERT(CHAR(8), MN.LAST_REG_READ_TIME
           , 108), ':', '.') LAST_REG_READ_TIME                              
                    ,MN.LAST_REG_READ_DATE                              
                    ,MN.CODE_USAGE_ID                                   
                    ,MN.CODE_USAGE_TYPE                                 
                    ,MN.CODE_USAGE_SOURCE                               
                    ,MN.CODE_CRNT_REG_READ                              
                    ,MN.GIS_MISMATCH_FL                                 
                INTO :MN-GIS-POINT-ID,
                :MN-LAST-VALID-READ-DT :WS-NULL-IND-01,
                :MN-LAST-VALID-READ-TM :WS-NULL-IND-02,
                :MN-CODE-METER-STATUS,
                :MN-MTR-READ-SOURCE-CD,
                :MN-REMOTE-READ-IND,
                :MN-CODE-MTR-RD-INST1,
                :MN-CODE-MTR-RD-INST2,
                :MN-CODE-MTR-RD-INST3,
                :MN-METER-PRESSURE,
                :MN-CODE-METER-LOC,
                :MN-METER-SUPPLYING,
                :MN-DIGTL-MTR-TYPE,
                :MN-PROGRAM-ID,
                :MN-DATE-MTR-INSTALL :WS-NULL-IND-03,
                :MN-NO-CONSEC-ESTIMATE,
                :MN-MIN-NO-UNITS,
                :MN-MAX-NO-UNITS,
                :MN-UTILITY-SOURCE-CD,
                :MN-DELIVERY-LEVEL-CD,
                :MN-INDUST-BTU-ID,
                :MN-REGISTER-RD-SEQ,
                :MN-SEAL-CODE-ID,
                :MN-LOCK-TYPE-ID,
                :MN-IDR-RECIPIENT-CD,
                :MN-INSULATED-IND,
                :WS-INACTIVE-YEAR :WS-NULL-IND-04,
                :WS-INACTIVE-MONTH :WS-NULL-IND-05,
                :MN-REG-ID-NO,
                :MN-CODE-METER-STATUS,
                :MN-LAST-VALID-READ-TM,
                :MN-CODE-TIME-PERIOD,
                :MN-CODE-STATUS-REAS,
                :MN-CODE-NO-RD-REASON,
                :MN-LAST-VAL-RD-VALUE,
                :MN-CODE-LAST-REG-READ,
                :MN-LAST-READ-VALUE,
                :MN-CODE-LAST-VALID-RD,
                :MN-LAST-REG-READ-TIME :WS-NULL-IND-06,
                :MN-LAST-REG-READ-DATE :WS-NULL-IND-07,
                :MN-CODE-USAGE-ID,
                :MN-CODE-USAGE-TYPE,
                :MN-CODE-USAGE-SOURCE,
                :MN-CODE-CRNT-REG-READ,
                :MN-GIS-MISMATCH-FL                                 
                FROM CSS_MTRD_ENVRNMT  MN WITH(READUNCOMMITTED)                 
               WHERE MN.ACCOUNT_NO        = :MN-ACCOUNT-NO              
                 AND MN.CODE_UTIL_TYPE    = :MN-CODE-UTIL-TYPE          
                 AND MN.IC_NO             = :MN-IC-NO                   
                 AND MN.MTR_REF_NO        = :MN-MTR-REF-NO              
                 AND MN.METER_NO          = :MN-METER-NO                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ025
MFA-TR* MSQ029
MFA-TR* MSQ050
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MN.GIS_POINT_ID                                            
MFA-TR*             ,MN.LAST_VALID_READ_DT                                      
MFA-TR*             ,MN.LAST_VALID_READ_TM                                      
MFA-TR*             ,MN.CODE_METER_STATUS                                       
MFA-TR*             ,MN.MTR_READ_SOURCE_CD                                      
MFA-TR*             ,MN.REMOTE_READ_IND                                         
MFA-TR*             ,MN.CODE_MTR_RD_INST1                                       
MFA-TR*             ,MN.CODE_MTR_RD_INST2                                       
MFA-TR*             ,MN.CODE_MTR_RD_INST3                                       
MFA-TR*             ,MN.METER_PRESSURE                                          
MFA-TR*             ,MN.CODE_METER_LOC                                          
MFA-TR*             ,MN.METER_SUPPLYING                                         
MFA-TR*             ,MN.DIGTL_MTR_TYPE                                          
MFA-TR*             ,MN.PROGRAM_ID                                              
MFA-TR*             ,MN.DATE_MTR_INSTALL                                        
MFA-TR*             ,MN.NO_CONSEC_ESTIMATE                                      
MFA-TR*             ,MN.MIN_NO_UNITS                                            
MFA-TR*             ,MN.MAX_NO_UNITS                                            
MFA-TR*             ,MN.UTILITY_SOURCE_CD                                       
MFA-TR*             ,MN.DELIVERY_LEVEL_CD                                       
MFA-TR*             ,MN.INDUST_BTU_ID                                           
MFA-TR*             ,MN.REGISTER_RD_SEQ                                         
MFA-TR*             ,MN.SEAL_CODE_ID                                            
MFA-TR*             ,MN.LOCK_TYPE_ID                                            
MFA-TR*             ,MN.IDR_RECIPIENT_CD                                        
MFA-TR*             ,MN.INSULATED_IND                                           
MFA-TR*             ,YEAR(:WS-RUN-DATE  - MTR_STATUS_CHNG_DT)           18730000
MFA-TR*             ,MONTH(:WS-RUN-DATE - MTR_STATUS_CHNG_DT)           18740000
MFA-TR*             ,MN.REG_ID_NO                                               
MFA-TR*             ,MN.CODE_METER_STATUS                                       
MFA-TR*             ,MN.LAST_VALID_READ_TM                                      
MFA-TR*             ,MN.CODE_TIME_PERIOD                                        
MFA-TR*             ,MN.CODE_STATUS_REAS                                        
MFA-TR*             ,MN.CODE_NO_RD_REASON                                       
MFA-TR*             ,MN.LAST_VAL_RD_VALUE                                       
MFA-TR*             ,MN.CODE_LAST_REG_READ                                      
MFA-TR*             ,MN.LAST_READ_VALUE                                         
MFA-TR*             ,MN.CODE_LAST_VALID_RD                                      
MFA-TR*             ,MN.LAST_REG_READ_TIME                                      
MFA-TR*             ,MN.LAST_REG_READ_DATE                                      
MFA-TR*             ,MN.CODE_USAGE_ID                                           
MFA-TR*             ,MN.CODE_USAGE_TYPE                                         
MFA-TR*             ,MN.CODE_USAGE_SOURCE                                       
MFA-TR*             ,MN.CODE_CRNT_REG_READ                                      
MFA-TR*             ,MN.GIS_MISMATCH_FL                                         
MFA-TR*         INTO:MN-GIS-POINT-ID                                            
MFA-TR*            ,:MN-LAST-VALID-READ-DT :WS-NULL-IND-01                      
MFA-TR*            ,:MN-LAST-VALID-READ-TM :WS-NULL-IND-02                      
MFA-TR*            ,:MN-CODE-METER-STATUS                                       
MFA-TR*            ,:MN-MTR-READ-SOURCE-CD                                      
MFA-TR*            ,:MN-REMOTE-READ-IND                                         
MFA-TR*            ,:MN-CODE-MTR-RD-INST1                                       
MFA-TR*            ,:MN-CODE-MTR-RD-INST2                                       
MFA-TR*            ,:MN-CODE-MTR-RD-INST3                                       
MFA-TR*            ,:MN-METER-PRESSURE                                          
MFA-TR*            ,:MN-CODE-METER-LOC                                          
MFA-TR*            ,:MN-METER-SUPPLYING                                         
MFA-TR*            ,:MN-DIGTL-MTR-TYPE                                          
MFA-TR*            ,:MN-PROGRAM-ID                                              
MFA-TR*            ,:MN-DATE-MTR-INSTALL :WS-NULL-IND-03                        
MFA-TR*            ,:MN-NO-CONSEC-ESTIMATE                                      
MFA-TR*            ,:MN-MIN-NO-UNITS                                            
MFA-TR*            ,:MN-MAX-NO-UNITS                                            
MFA-TR*            ,:MN-UTILITY-SOURCE-CD                                       
MFA-TR*            ,:MN-DELIVERY-LEVEL-CD                                       
MFA-TR*            ,:MN-INDUST-BTU-ID                                           
MFA-TR*            ,:MN-REGISTER-RD-SEQ                                         
MFA-TR*            ,:MN-SEAL-CODE-ID                                            
MFA-TR*            ,:MN-LOCK-TYPE-ID                                            
MFA-TR*            ,:MN-IDR-RECIPIENT-CD                                        
MFA-TR*            ,:MN-INSULATED-IND                                           
MFA-TR*            ,:WS-INACTIVE-YEAR  :WS-NULL-IND-04                  19160000
MFA-TR*            ,:WS-INACTIVE-MONTH :WS-NULL-IND-05                  19170000
MFA-TR*            ,:MN-REG-ID-NO                                               
MFA-TR*            ,:MN-CODE-METER-STATUS                                       
MFA-TR*            ,:MN-LAST-VALID-READ-TM                                      
MFA-TR*            ,:MN-CODE-TIME-PERIOD                                        
MFA-TR*            ,:MN-CODE-STATUS-REAS                                        
MFA-TR*            ,:MN-CODE-NO-RD-REASON                                       
MFA-TR*            ,:MN-LAST-VAL-RD-VALUE                                       
MFA-TR*            ,:MN-CODE-LAST-REG-READ                                      
MFA-TR*            ,:MN-LAST-READ-VALUE                                         
MFA-TR*            ,:MN-CODE-LAST-VALID-RD                                      
MFA-TR*            ,:MN-LAST-REG-READ-TIME :WS-NULL-IND-06                      
MFA-TR*            ,:MN-LAST-REG-READ-DATE :WS-NULL-IND-07                      
MFA-TR*            ,:MN-CODE-USAGE-ID                                           
MFA-TR*            ,:MN-CODE-USAGE-TYPE                                         
MFA-TR*            ,:MN-CODE-USAGE-SOURCE                                       
MFA-TR*            ,:MN-CODE-CRNT-REG-READ                                      
MFA-TR*            ,:MN-GIS-MISMATCH-FL                                         
MFA-TR*         FROM CSS_MTRD_ENVRNMT  MN                                       
MFA-TR*        WHERE MN.ACCOUNT_NO        = :MN-ACCOUNT-NO                      
MFA-TR*          AND MN.CODE_UTIL_TYPE    = :MN-CODE-UTIL-TYPE                  
MFA-TR*          AND MN.IC_NO             = :MN-IC-NO                           
MFA-TR*          AND MN.MTR_REF_NO        = :MN-MTR-REF-NO                      
MFA-TR*          AND MN.METER_NO          = :MN-METER-NO                        
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7000                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-NULL-IND-01 = WS-YES-NULL                           
                 MOVE SPACES             TO MN-DATE-MTR-INSTALL         
              END-IF                                                    
              IF WS-NULL-IND-02 = WS-YES-NULL                           
                  MOVE SPACES            TO MN-LAST-VALID-READ-TM       
              END-IF                                                    
              IF WS-NULL-IND-03 = WS-YES-NULL                           
                  MOVE SPACES            TO MN-LAST-VALID-READ-DT       
              END-IF                                                    
              IF WS-NULL-IND-04 = WS-YES-NULL                           
                  MOVE WS-ZERO           TO WS-INACTIVE-YEAR            
              END-IF                                                    
              IF WS-NULL-IND-05 = WS-YES-NULL                           
                  MOVE WS-ZERO           TO WS-INACTIVE-MONTH           
              END-IF                                                    
              IF WS-NULL-IND-06 = WS-YES-NULL                           
                  MOVE SPACES            TO MN-LAST-REG-READ-TIME       
              END-IF                                                    
              IF WS-NULL-IND-07 = WS-YES-NULL                           
                  MOVE SPACES            TO MN-LAST-REG-READ-DATE       
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7000'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_MTRD_ENVRNMT'    TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2             
              MOVE 'IC_NO'               TO TABLE-ELEMENT-3             
              MOVE 'METER_NO'            TO TABLE-ELEMENT-4             
              MOVE MN-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE MN-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2           
              MOVE MN-IC-NO              TO HOSTVAR-ELEMENT-3           
              MOVE MN-METER-NO           TO HOSTVAR-ELEMENT-4           
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7005-OPEN-REGISTER-RD-CUR.                                    *         
      ******************************************************************        
       7005-OPEN-REGISTER-RD-CUR.                                       
                                                                        
           EXEC SQL                                                     
                OPEN REGISTER_RD_CUR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7005'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_REGISTER_READ'   TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'UTIL_TYPE'           TO TABLE-ELEMENT-2             
              MOVE 'IC_NO'               TO TABLE-ELEMENT-3             
              MOVE 'METER_NO'            TO TABLE-ELEMENT-4             
              MOVE RG-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE RG-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2           
              MOVE RG-IC-NO              TO HOSTVAR-ELEMENT-3           
              MOVE RG-METER-NO           TO HOSTVAR-ELEMENT-4           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7005-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7010-FETCH-REGISTER-RD-CUR.                                   *         
      ******************************************************************        
       7010-FETCH-REGISTER-RD-CUR.                                      
                                                                        
           EXEC SQL                                                     
               FETCH REGISTER_RD_CUR                                    
                INTO :RG-REG-ID-NO                                      
                    ,:RG-CODE-TIME-PERIOD                               
                    ,:RG-CODE-REG-STATUS                                
                    ,:RG-CODE-STATUS-REAS                               
                    ,:RG-CODE-NO-RD-REASON                              
                    ,:RG-LAST-VAL-RD-VALUE                              
                    ,:RG-CODE-LAST-REG-READ                             
                    ,:RG-LAST-VALID-READ-DT                             
                    ,:RG-LAST-VALID-READ-TM                             
                    ,:RG-LAST-READ-VALUE                                
                    ,:RG-CODE-LAST-VALID-RD                             
                    ,:RG-LAST-REG-READ-DT                               
                    ,:RG-LAST-REG-READ-TM                               
                    ,:RG-CODE-USAGE-ID                                  
                    ,:RG-CODE-USAGE-TYPE                                
                    ,:RG-CODE-USAGE-SOURCE                              
                    ,:RG-CODE-CRNT-REG-READ                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-2          
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME       TO ABEND-PROGRAM                  
              MOVE '7010'             TO ACTIVE-PARAGRAPH               
              MOVE 'FETCH'            TO ABEND-FUNCTION                 
              MOVE SPACES             TO ABEND-SQL-PREDICATES           
                                         ABEND-TABLES                   
              MOVE 'CSS_REGISTER_READ'                                  
                                      TO TABLE-1                        
              MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1                
              MOVE 'UTIL_TYPE'        TO TABLE-ELEMENT-2                
              MOVE 'IC_NO'            TO TABLE-ELEMENT-3                
              MOVE 'METER_NO'         TO TABLE-ELEMENT-4                
              MOVE RG-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1              
              MOVE RG-CODE-UTIL-TYPE  TO HOSTVAR-ELEMENT-2              
              MOVE RG-IC-NO           TO HOSTVAR-ELEMENT-3              
              MOVE RG-METER-NO        TO HOSTVAR-ELEMENT-4              
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7015-CLOSE-REGISTER-RD-CUR.                                    *        
      ******************************************************************        
       7015-CLOSE-REGISTER-RD-CUR.                                      
                                                                        
           EXEC SQL                                                     
                CLOSE REGISTER_RD_CUR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-2.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7015'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_REGISTER_READ'      TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'UTIL_TYPE'              TO TABLE-ELEMENT-2          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE 'METER_NO'               TO TABLE-ELEMENT-4          
              MOVE RG-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE RG-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE RG-IC-NO                 TO HOSTVAR-ELEMENT-3        
              MOVE RG-METER-NO              TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7015-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7020-GET-RATE-PLAN-NO.                                         *        
      ******************************************************************        
       7020-GET-RATE-PLAN-NO.                                           
                                                                        
           EXEC SQL                                                     
                SELECT UT.RATE_PLAN_NO                                  
                      ,UT.COMPANY_NO                                    
A05460                ,UT.READ_CYCLE                                    
                      ,RD.SECURED_RATE_FL                               
                  INTO :UT-RATE-PLAN-NO                                 
                      ,:UT-COMPANY-NO                                   
A05460                ,:UT-READ-CYCLE                                   
                      ,:RD-SECURED-RATE-FL                              
                  FROM CSS_UTIL_ENVRNMT   UT WITH(READUNCOMMITTED)              
                      ,CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED)              
                 WHERE UT.ACCOUNT_NO     = :UT-ACCOUNT-NO               
                   AND UT.CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE           
                   AND UT.IC_NO          = :UT-IC-NO                    
                   AND UT.CODE_UTIL_TYPE = RD.CODE_UTIL_TYPE            
                   AND UT.RATE_PLAN_NO   = RD.RATE_PLAN_NO              
                                                                 
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     20010000
MFA-TR*         SELECT UT.RATE_PLAN_NO                                  20020000
MFA-TR*               ,UT.COMPANY_NO                                            
MFA-TR*               ,UT.READ_CYCLE                                            
MFA-TR*               ,RD.SECURED_RATE_FL                               20030000
MFA-TR*           INTO :UT-RATE-PLAN-NO                                 20040000
MFA-TR*               ,:UT-COMPANY-NO                                   20040000
MFA-TR*               ,:UT-READ-CYCLE                                           
MFA-TR*               ,:RD-SECURED-RATE-FL                              20050000
MFA-TR*           FROM CSS_UTIL_ENVRNMT   UT                            20060000
MFA-TR*               ,CSS_RATE_PLAN_DESC RD                                    
MFA-TR*          WHERE UT.ACCOUNT_NO     = :UT-ACCOUNT-NO               20070000
MFA-TR*            AND UT.CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE           20080000
MFA-TR*            AND UT.IC_NO          = :UT-IC-NO                    20090000
MFA-TR*            AND UT.CODE_UTIL_TYPE = RD.CODE_UTIL_TYPE                    
MFA-TR*            AND UT.RATE_PLAN_NO   = RD.RATE_PLAN_NO                      
MFA-TR*           WITH UR                                                       
MFA-TR*        QUERYNO 7020                                                     
MFA-TR*    END-EXEC                                                     20100000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7020'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_UTIL_ENVRNMT'        TO TABLE-1                 
              MOVE 'CSS_RATE_PLAN_DESC'      TO TABLE-2                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE 'IC_NO'                   TO TABLE-ELEMENT-3         
              MOVE UT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE UT-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              MOVE UT-IC-NO                  TO HOSTVAR-ELEMENT-3       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7100-GET-METER-CAP-DETAILS.                                    *        
      ******************************************************************        
       7100-GET-METER-CAP-DETAILS.                                      
                                                                        
           EXEC SQL                                                     
                SELECT CONSTANT                                         
                      ,NO_READ_DIALS                                    
                  INTO :MC-CONSTANT                                     
                      ,:MC-NO-READ-DIALS                                
                  FROM CSS_MTR_CAP  MC WITH(READUNCOMMITTED)                    
                 WHERE MC.METER_NO       = :MC-METER-NO                 
                   AND MC.REG_ID_NO      = :MC-REG-ID-NO                
                   AND MC.CODE_UTIL_TYPE = :MC-CODE-UTIL-TYPE           
                   AND MC.COMPANY_NO     = :MC-COMPANY-NO               
                                                                 
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     20010000
MFA-TR*         SELECT CONSTANT                                         20020000
MFA-TR*               ,NO_READ_DIALS                                    20030000
MFA-TR*           INTO :MC-CONSTANT                                     20040000
MFA-TR*               ,:MC-NO-READ-DIALS                                20050000
MFA-TR*           FROM CSS_MTR_CAP  MC                                  20060000
MFA-TR*          WHERE MC.METER_NO       = :MC-METER-NO                 20070000
MFA-TR*            AND MC.REG_ID_NO      = :MC-REG-ID-NO                20080000
MFA-TR*            AND MC.CODE_UTIL_TYPE = :MC-CODE-UTIL-TYPE           20090000
MFA-TR*            AND MC.COMPANY_NO     = :MC-COMPANY-NO                       
MFA-TR*           WITH UR                                                       
MFA-TR*        QUERYNO 7100                                                     
MFA-TR*    END-EXEC                                                     20100000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7100'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_MTR_CAP'             TO TABLE-1                 
              MOVE 'MTR_NO'                  TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-3         
              MOVE MN-METER-NO               TO HOSTVAR-ELEMENT-1       
              MOVE MN-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              MOVE MN-ACCOUNT-NO             TO HOSTVAR-ELEMENT-3       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7110-GET-DET-CONSUMP-HIST.                                     *        
      ******************************************************************        
       7110-GET-DET-CONSUMP-HIST.                                       
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) CONSTANT,
              NO_DIALS                                           
                INTO :CX-CONSTANT                                       
                    ,:CX-NO-DIALS                                       
                FROM CSS_CNSMPTN_HIST CX WITH(READUNCOMMITTED)                  
               WHERE METER_NO       = :CX-METER-NO                      
                 AND ACCOUNT_NO     = :CX-ACCOUNT-NO                    
                 AND IC_NO          = :CX-IC-NO                         
                 AND CODE_UTIL_TYPE = :CX-CODE-UTIL-TYPE                
                 AND MTR_REF_NO     = :CX-MTR-REF-NO                    
                 AND COMPANY_NO     = :CX-COMPANY-NO                    
               ORDER BY BILL_NO DESC                                    
                                             
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CONSTANT                                                   
MFA-TR*             ,NO_DIALS                                                   
MFA-TR*         INTO :CX-CONSTANT                                               
MFA-TR*             ,:CX-NO-DIALS                                               
MFA-TR*         FROM CSS_CNSMPTN_HIST CX                                        
MFA-TR*        WHERE METER_NO       = :CX-METER-NO                              
MFA-TR*          AND ACCOUNT_NO     = :CX-ACCOUNT-NO                            
MFA-TR*          AND IC_NO          = :CX-IC-NO                                 
MFA-TR*          AND CODE_UTIL_TYPE = :CX-CODE-UTIL-TYPE                        
MFA-TR*          AND MTR_REF_NO     = :CX-MTR-REF-NO                            
MFA-TR*          AND COMPANY_NO     = :CX-COMPANY-NO                            
MFA-TR*        ORDER BY BILL_NO DESC                                            
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7110'                 TO ACTIVE-PARAGRAPH           
              MOVE 'SELECT'               TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSS_CNSMPTN_HIST'     TO TABLE-1                    
              MOVE 'MTR_NO'               TO TABLE-ELEMENT-1            
              MOVE 'CODE_UTIL_TYPE'       TO TABLE-ELEMENT-2            
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-3            
              MOVE CX-METER-NO            TO HOSTVAR-ELEMENT-1          
              MOVE CX-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-2          
              MOVE CX-ACCOUNT-NO          TO HOSTVAR-ELEMENT-3          
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7120-GET-GIS-LOC-AND-TAG.                                     *         
      *****************************************************************         
       7120-GET-GIS-LOC-AND-TAG.                                        
                                                                        
           EXEC SQL                                                     
              SELECT PP.AREA_ID                                         
                    ,PP.TAG_NM                                          
                INTO :PP-AREA-ID                                        
                    ,:PP-TAG-NM                                         
                FROM CSS_PIM_POINT PP WITH(READUNCOMMITTED)                     
               WHERE PP.POINT_ID = :MN-GIS-POINT-ID                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT PP.AREA_ID                                                 
MFA-TR*             ,PP.TAG_NM                                                  
MFA-TR*         INTO :PP-AREA-ID                                                
MFA-TR*             ,:PP-TAG-NM                                                 
MFA-TR*         FROM CSS_PIM_POINT PP                                           
MFA-TR*        WHERE PP.POINT_ID = :MN-GIS-POINT-ID                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7120                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7120'                 TO ACTIVE-PARAGRAPH           
              MOVE 'SELECT'               TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSS_PIM_POINT'        TO TABLE-1                    
              MOVE 'GIS_POINT_ID'         TO TABLE-ELEMENT-1            
              MOVE MN-GIS-POINT-ID        TO HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7130-GET-ELEC-METER.                                          *         
      *****************************************************************         
       7130-GET-ELEC-METER.                                             
                                                                        
           EXEC SQL                                                     
              SELECT EM.METER_SIZE_ID                                   
                    ,EM.ELEC_MTR_SPEC_CD                                
                    ,EM.ELEC_MTR_CLASS_CD                               
                INTO :EM-METER-SIZE-ID                                  
                    ,:EM-ELEC-MTR-SPEC-CD                               
                    ,:EM-ELEC-MTR-CLASS-CD                              
                FROM CSS_ELEC_METER EM WITH(READUNCOMMITTED)                    
               WHERE EM.CODE_UTIL_TYPE   = :WS-KEY-UTIL-TYPE            
                 AND EM.METER_NO         = :EM-METER-NO                 
                 AND EM.COMPANY_NO       = :EM-COMPANY-NO               
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT EM.METER_SIZE_ID                                           
MFA-TR*             ,EM.ELEC_MTR_SPEC_CD                                        
MFA-TR*             ,EM.ELEC_MTR_CLASS_CD                                       
MFA-TR*         INTO :EM-METER-SIZE-ID                                          
MFA-TR*             ,:EM-ELEC-MTR-SPEC-CD                                       
MFA-TR*             ,:EM-ELEC-MTR-CLASS-CD                                      
MFA-TR*         FROM CSS_ELEC_METER EM                                          
MFA-TR*        WHERE EM.CODE_UTIL_TYPE   = :WS-KEY-UTIL-TYPE                    
MFA-TR*          AND EM.METER_NO         = :EM-METER-NO                         
MFA-TR*          AND EM.COMPANY_NO       = :EM-COMPANY-NO                       
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7130                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE '7130'                  TO ACTIVE-PARAGRAPH          
              MOVE 'SELECT'                TO ABEND-FUNCTION            
              MOVE SPACES                  TO ABEND-SQL-PREDICATES      
                                                ABEND-TABLES            
              MOVE 'CSS_ELEC_MTR'          TO TABLE-1                   
              MOVE 'MTR_NO'                TO TABLE-ELEMENT-1           
              MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2           
              MOVE 'COMPANY_NO'            TO TABLE-ELEMENT-3           
              MOVE MN-METER-NO             TO HOSTVAR-ELEMENT-1         
              MOVE WS-KEY-UTIL-TYPE        TO HOSTVAR-ELEMENT-2         
              MOVE EM-COMPANY-NO           TO HOSTVAR-ELEMENT-3         
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7130-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************20340000
      *                                                                *20350000
      * 7135-GET-ELEC-MTR-DET.                                         *20370000
      ******************************************************************20380000
       7135-GET-ELEC-MTR-DET.                                           
                                                                        
              EXEC SQL                                                  
                  SELECT U0.ELEC_MTR_FORM_CD                            
                        ,U0.MTR_CONNECT_TYP_ID                          
                        ,U4.NO_PHASES                                   
                    INTO :U0-ELEC-MTR-FORM-CD                           
                        ,:U0-MTR-CONNECT-TYP-ID                         
                        ,:U4-NO-PHASES                                  
                    FROM CSS_ELEC_MTR_SPEC  U5                          
                        ,CSS_ELEC_MTR_CLASS U4                          
                        ,CSS_ELEC_CL_SPEC   U0                          
                   WHERE U5.ELEC_MTR_SPEC_CD  = :EM-ELEC-MTR-SPEC-CD    
                     AND U4.ELEC_MTR_CLASS_CD = :EM-ELEC-MTR-CLASS-CD   
                     AND U0.ELEC_MTR_SPEC_CD  = U5.ELEC_MTR_SPEC_CD     
                     AND U0.ELEC_MTR_CLASS_CD = U4.ELEC_MTR_CLASS_CD    
              END-EXEC                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
              MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE  
                                                                        
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND   
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME            TO ABEND-PROGRAM          
                 MOVE '7135'                  TO ACTIVE-PARAGRAPH       
                 MOVE 'SELECT'                TO ABEND-FUNCTION         
                 MOVE SPACES                  TO ABEND-SQL-PREDICATES   
                                                   ABEND-TABLES         
                 MOVE 'CSS_ELEC_MTR_SPEC'     TO TABLE-1                
                 MOVE 'CSS_ELEC_MTR_CLASS'    TO TABLE-2                
                 MOVE 'CSS_ELEC_CL_SPEC'      TO TABLE-3                
                 MOVE 'ELEC_MTR_SPEC_CD'      TO TABLE-ELEMENT-1        
                 MOVE 'ELEC_MTR_CLASS_CD'     TO TABLE-ELEMENT-2        
                 MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-3        
                 MOVE EM-ELEC-MTR-SPEC-CD     TO HOSTVAR-ELEMENT-1      
                 MOVE EM-ELEC-MTR-CLASS-CD    TO HOSTVAR-ELEMENT-2      
                 MOVE MN-ACCOUNT-NO           TO HOSTVAR-ELEMENT-3      
                 PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT          
              END-IF.                                                   
                                                                        
       7135-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7140-GET-ELEC-METER-SIZE                                       *        
      ******************************************************************        
       7140-GET-ELEC-METER-SIZE.                                        
                                                                        
           EXEC SQL                                                     
              SELECT M1.METER_SIZE_DESC                                 
                INTO :WS-METER-SIZE-DESC                                
                FROM CSS_ELEC_MTR_SIZE M1 WITH(READUNCOMMITTED)                 
               WHERE M1.METER_SIZE_ID  = :EM-METER-SIZE-ID              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT M1.METER_SIZE_DESC                                         
MFA-TR*         INTO :WS-METER-SIZE-DESC                                        
MFA-TR*         FROM CSS_ELEC_MTR_SIZE M1                                       
MFA-TR*        WHERE M1.METER_SIZE_ID  = :EM-METER-SIZE-ID                      
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7140                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7140'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_ELEC_MTR_SIZE'     TO TABLE-1                  
               MOVE 'METER_SIZE_ID'         TO TABLE-ELEMENT-1          
               MOVE EM-METER-SIZE-ID        TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7140-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7150-GET-GAS-METER.                                            *        
      ******************************************************************        
       7150-GET-GAS-METER.                                              
                                                                        
           EXEC SQL                                                     
              SELECT GM.METER_SIZE_ID                                   
                    ,GM.CODE_METER_TYPE                                 
                INTO :GM-METER-SIZE-ID                                  
                    ,:GM-CODE-METER-TYPE                                
                FROM CSS_GAS_METER GM WITH(READUNCOMMITTED)                     
               WHERE GM.CODE_UTIL_TYPE = :WS-KEY-UTIL-TYPE              
                 AND GM.METER_NO       = :GM-METER-NO                   
                 AND GM.COMPANY_NO     = :GM-COMPANY-NO                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT GM.METER_SIZE_ID                                           
MFA-TR*             ,GM.CODE_METER_TYPE                                         
MFA-TR*         INTO :GM-METER-SIZE-ID                                          
MFA-TR*             ,:GM-CODE-METER-TYPE                                        
MFA-TR*         FROM CSS_GAS_METER GM                                           
MFA-TR*        WHERE GM.CODE_UTIL_TYPE = :WS-KEY-UTIL-TYPE                      
MFA-TR*          AND GM.METER_NO       = :GM-METER-NO                           
MFA-TR*          AND GM.COMPANY_NO     = :GM-COMPANY-NO                         
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7150                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO RS-RETURN-CODE            
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE '7150'                  TO ACTIVE-PARAGRAPH          
              MOVE 'SELECT'                TO ABEND-FUNCTION            
              MOVE SPACES                  TO ABEND-SQL-PREDICATES      
                                                ABEND-TABLES            
              MOVE 'CSS_GAS_METER'         TO TABLE-1                   
              MOVE 'METER_NO'              TO TABLE-ELEMENT-1           
              MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2           
              MOVE 'COMPANY_NO'            TO TABLE-ELEMENT-3           
              MOVE GM-METER-NO             TO HOSTVAR-ELEMENT-1         
              MOVE WS-KEY-UTIL-TYPE        TO HOSTVAR-ELEMENT-2         
              MOVE GM-COMPANY-NO           TO HOSTVAR-ELEMENT-3         
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7160-GET-GAS-METER-SIZE.                                       *        
      ******************************************************************        
       7160-GET-GAS-METER-SIZE.                                         
                                                                        
           EXEC SQL                                                     
              SELECT M5.METER_SIZE_DESC                                 
                    ,M5.CCF_CAP_PER_HR                                  
                INTO :WS-METER-SIZE-DESC                                
                    ,:M5-CCF-CAP-PER-HR                                 
                FROM CSS_GAS_METER_SIZE M5 WITH(READUNCOMMITTED)                
               WHERE M5.METER_SIZE_ID  = :GM-METER-SIZE-ID              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT M5.METER_SIZE_DESC                                         
MFA-TR*             ,M5.CCF_CAP_PER_HR                                          
MFA-TR*         INTO :WS-METER-SIZE-DESC                                        
MFA-TR*             ,:M5-CCF-CAP-PER-HR                                         
MFA-TR*         FROM CSS_GAS_METER_SIZE M5                                      
MFA-TR*        WHERE M5.METER_SIZE_ID  = :GM-METER-SIZE-ID                      
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7160                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE   TO RS-RETURN-CODE           
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7160'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                                 ABEND-TABLES           
               MOVE 'CSS_GAS_METER_SIZE'    TO TABLE-1                  
               MOVE 'METER_SIZE_ID'         TO TABLE-ELEMENT-1          
               MOVE GM-METER-SIZE-ID      TO HOSTVAR-ELEMENT-1          
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7160-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************22160000
      *                                                                *22160000
      * 7170-ADD-ONE-DAY.                                               22170000
      ******************************************************************22180000
       7170-ADD-ONE-DAY.                                                
                                                                        
           EXEC SQL                                                     
               SELECT
              DATEADD( DAY, 1, IIF(TRY_CONVERT(DATE, :WS-DATE-READ
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-READ
              ) <> 0) OR (LEN(:WS-DATE-READ) <> 10), CIS.CHAR2DATE(
                                                          :WS-DATE-READ
              ), CONVERT(DATE, :WS-DATE-READ) ) )
            INTO
              :WS-DATE-READ    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-DATE-READ = DATE(DATE(:WS-DATE-READ) + 1 DAY)            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7170'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SET'                   TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                                 ABEND-TABLES           
               MOVE 'DATE_READ'             TO TABLE-ELEMENT-1          
               MOVE WS-DATE-READ            TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7170-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************22160000
      *                                                                *22160000
      * 7180-GET-CURRENT-DATE.                                          22170000
      ******************************************************************22180000
       7180-GET-CURRENT-DATE.                                           
                                                                        
           EXEC SQL                                                     
               SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-RUN-DATE                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-RUN-DATE = CURRENT DATE                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7180'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SET'                   TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                                 ABEND-TABLES           
               MOVE 'CURRENT DATE'          TO TABLE-ELEMENT-1          
               MOVE WS-RUN-DATE             TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7180-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************22160000
      *                                                                *22160000
      * 7190-GET-AMR-DETAILS.                                           22170000
      ******************************************************************22180000
       7190-GET-AMR-DETAILS.                                            
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) MA.DEVICE_NO,
              MA.CODE_ATT_TYPE,
              N5.MTR_ATT_TYPE_TX                                 
                INTO :MA-DEVICE-NO                                      
                    ,:MA-CODE-ATT-TYPE                                  
                    ,:N5-MTR-ATT-TYPE-TX                                
                FROM CSS_METER_ATTCHMTS MA WITH(READUNCOMMITTED)                
                    ,CSS_MTR_ATT_TYPE N5 WITH(READUNCOMMITTED)                  
               WHERE MA.CODE_UTIL_TYPE    = N5.CODE_UTIL_TYPE           
                 AND MA.CODE_ATT_TYPE     = N5.CODE_ATT_TYPE            
                 AND MA.COMPANY_NO        = :MA-COMPANY-NO              
                 AND MA.CODE_UTIL_TYPE    = :MA-CODE-UTIL-TYPE          
                 AND N5.DEVICE_TYPE_CD    = 'A'                         
                 AND MA.METER_NO          = :MA-METER-NO                
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MA.DEVICE_NO                                               
MFA-TR*             ,MA.CODE_ATT_TYPE                                           
MFA-TR*             ,N5.MTR_ATT_TYPE_TX                                         
MFA-TR*         INTO :MA-DEVICE-NO                                              
MFA-TR*             ,:MA-CODE-ATT-TYPE                                          
MFA-TR*             ,:N5-MTR-ATT-TYPE-TX                                        
MFA-TR*         FROM CSS_METER_ATTCHMTS MA                                      
MFA-TR*             ,CSS_MTR_ATT_TYPE N5                                        
MFA-TR*        WHERE MA.CODE_UTIL_TYPE    = N5.CODE_UTIL_TYPE                   
MFA-TR*          AND MA.CODE_ATT_TYPE     = N5.CODE_ATT_TYPE                    
MFA-TR*          AND MA.COMPANY_NO        = :MA-COMPANY-NO                      
MFA-TR*          AND MA.CODE_UTIL_TYPE    = :MA-CODE-UTIL-TYPE                  
MFA-TR*          AND N5.DEVICE_TYPE_CD    = 'A'                                 
MFA-TR*          AND MA.METER_NO          = :MA-METER-NO                        
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7190                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE   TO RS-RETURN-CODE           
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7190'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_METER_ATTCHMTS'    TO TABLE-1                  
               MOVE 'CSS_MTR_ATT_TYPE'      TO TABLE-2                  
               MOVE 'COMPANY_NO'            TO TABLE-ELEMENT-1          
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2          
               MOVE 'METER_NO'              TO TABLE-ELEMENT-3          
               MOVE MA-COMPANY-NO           TO HOSTVAR-ELEMENT-1        
               MOVE MA-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2        
               MOVE MA-METER-NO             TO HOSTVAR-ELEMENT-3        
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7190-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************17900000
      * 7200-GET-VERSION-NO.                                           *17910000
      ******************************************************************17930000
       7200-GET-VERSION-NO.                                             
                                                                        
           EXEC SQL                                                     
                SELECT VERSION_CD                                       
                  INTO :LX-VERSION-CD                                   
                  FROM CSS_EQUIP_ATTCHMTS LX WITH(READUNCOMMITTED)              
                 WHERE CODE_ATT_TYPE     = :LX-CODE-ATT-TYPE            
                   AND COMPANY_NO        = :LX-COMPANY-NO               
                   AND CODE_UTIL_TYPE    = :LX-CODE-UTIL-TYPE           
                   AND DEVICE_NO         = :LX-DEVICE-NO                
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     17960000
MFA-TR*         SELECT VERSION_CD                                               
MFA-TR*           INTO :LX-VERSION-CD                                           
MFA-TR*           FROM CSS_EQUIP_ATTCHMTS LX                                    
MFA-TR*          WHERE CODE_ATT_TYPE     = :LX-CODE-ATT-TYPE                    
MFA-TR*            AND COMPANY_NO        = :LX-COMPANY-NO                       
MFA-TR*            AND CODE_UTIL_TYPE    = :LX-CODE-UTIL-TYPE                   
MFA-TR*            AND DEVICE_NO         = :LX-DEVICE-NO                        
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                    17980000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '7200'               TO ACTIVE-PARAGRAPH            
               MOVE 'SELECT'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSS_EQUIP_ATTCHMTS' TO TABLE-1                     
               MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1             
               MOVE 'CODE_ATT_TYPE'      TO TABLE-ELEMENT-2             
               MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-3             
               MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-4             
               MOVE MN-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1           
               MOVE LX-CODE-ATT-TYPE     TO HOSTVAR-ELEMENT-2           
               MOVE LX-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-3           
               MOVE LX-COMPANY-NO         TO HOSTVAR-ELEMENT-4          
               PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************21390000
      *                                                                *21410000
      * 7220-GET-MTR-USAGE-DESC.                                       *21420000
      ******************************************************************21430000
       7220-GET-MTR-USAGE-DESC.                                         
                                                                        
           EXEC SQL                                                     
               SELECT S5.METER_USAGE_DESC                               
                 INTO :S5-METER-USAGE-DESC                              
                 FROM CSS_MTR_USAGE_VALS S5 WITH(READUNCOMMITTED)               
                WHERE CODE_USAGE_ID     = :S5-CODE-USAGE-ID             
                  AND CODE_USAGE_TYPE   = :S5-CODE-USAGE-TYPE           
                  AND CODE_USAGE_SOURCE = :S5-CODE-USAGE-SOURCE         
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     21460000
MFA-TR*        SELECT S5.METER_USAGE_DESC                               21470000
MFA-TR*          INTO :S5-METER-USAGE-DESC                              21490000
MFA-TR*          FROM CSS_MTR_USAGE_VALS S5                             21510000
MFA-TR*         WHERE CODE_USAGE_ID     = :S5-CODE-USAGE-ID             21520000
MFA-TR*           AND CODE_USAGE_TYPE   = :S5-CODE-USAGE-TYPE           21530000
MFA-TR*           AND CODE_USAGE_SOURCE = :S5-CODE-USAGE-SOURCE         21540000
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7220                                                      
MFA-TR*    END-EXEC.                                                    21570000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7220'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_MTR_USAGE_VALS'      TO TABLE-1                 
              MOVE 'CODE_USAGE_ID'           TO TABLE-ELEMENT-1         
              MOVE 'CODE_USAGE_TYPE'         TO TABLE-ELEMENT-2         
              MOVE 'CODE_USAGE_SOURCE'       TO TABLE-ELEMENT-3         
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-4         
              MOVE S5-CODE-USAGE-ID          TO HOSTVAR-ELEMENT-1       
              MOVE S5-CODE-USAGE-TYPE        TO HOSTVAR-ELEMENT-2       
              MOVE S5-CODE-USAGE-SOURCE      TO HOSTVAR-ELEMENT-3       
              MOVE MN-ACCOUNT-NO             TO HOSTVAR-ELEMENT-4       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7220-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************21390000
      *                                                                *21410000
      * 7230-GET-READ-SEQ-NO.                                          *21420000
      ******************************************************************21430000
       7230-GET-READ-SEQ-NO.                                            
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) OA.READ_SEQUENCE_NO                               
                 INTO :OA-READ-SEQUENCE-NO                              
                 FROM CSS_MTR_RD_FMT OA WITH(READUNCOMMITTED)                   
                WHERE OA.CODE_UTIL_TYPE      = :OA-CODE-UTIL-TYPE       
                  AND OA.DIGTL_MTR_TYPE      = :OA-DIGTL-MTR-TYPE       
                  AND OA.PROGRAM_ID          = :OA-PROGRAM-ID           
                  AND OA.MTR_READ_SOURCE_CD  = :OA-MTR-READ-SOURCE-CD   
      *           AND OA.MTR_RD_RECORD_CD    = :OA-MTR-RD-RECORD-CD     21540000
                  AND OA.REMOTE_READ_IND     = :OA-REMOTE-READ-IND      
                  AND OA.CODE_USAGE_TYPE     = :OA-CODE-USAGE-TYPE      
                  AND OA.CODE_TIME_PERIOD    = :OA-CODE-TIME-PERIOD     
                  AND OA.CODE_TOU_SEASN      = :WS-CURRENT              
                  AND OA.CODE_USAGE_ID       = :OA-CODE-USAGE-ID        
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     21460000
MFA-TR*        SELECT OA.READ_SEQUENCE_NO                               21470000
MFA-TR*          INTO :OA-READ-SEQUENCE-NO                              21490000
MFA-TR*          FROM CSS_MTR_RD_FMT OA                                 21510000
MFA-TR*         WHERE OA.CODE_UTIL_TYPE      = :OA-CODE-UTIL-TYPE       21520000
MFA-TR*           AND OA.DIGTL_MTR_TYPE      = :OA-DIGTL-MTR-TYPE       21530000
MFA-TR*           AND OA.PROGRAM_ID          = :OA-PROGRAM-ID           21540000
MFA-TR*           AND OA.MTR_READ_SOURCE_CD  = :OA-MTR-READ-SOURCE-CD   21540000
MFA-TR*           AND OA.MTR_RD_RECORD_CD    = :OA-MTR-RD-RECORD-CD     21540000
MFA-TR*           AND OA.REMOTE_READ_IND     = :OA-REMOTE-READ-IND      21540000
MFA-TR*           AND OA.CODE_USAGE_TYPE     = :OA-CODE-USAGE-TYPE      21540000
MFA-TR*           AND OA.CODE_TIME_PERIOD    = :OA-CODE-TIME-PERIOD     21540000
MFA-TR*           AND OA.CODE_TOU_SEASN      = :WS-CURRENT              21540000
MFA-TR*           AND OA.CODE_USAGE_ID       = :OA-CODE-USAGE-ID        21540000
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*       QUERYNO 7230                                                      
MFA-TR*    END-EXEC.                                                    21570000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7230'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_MTR_D_FMT'           TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'DIGTL_MTR_TYPE'          TO TABLE-ELEMENT-2         
              MOVE 'PROGRAM_ID'              TO TABLE-ELEMENT-3         
              MOVE 'MTR_READ_SOURCE_CD'      TO TABLE-ELEMENT-4         
              MOVE OA-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE OA-DIGTL-MTR-TYPE         TO HOSTVAR-ELEMENT-2       
              MOVE OA-PROGRAM-ID             TO HOSTVAR-ELEMENT-3       
              MOVE OA-MTR-READ-SOURCE-CD     TO HOSTVAR-ELEMENT-4       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7230-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************21390000
      *                                                                *21410000
      * 7240-GET-MKT-XREF-ACCT.                                        *21420000
      ******************************************************************21430000
       7240-GET-MKT-XREF-ACCT.                                          
                                                                        
           EXEC SQL                                                     
               SELECT XM.DIST_ACCT_NO                                   
                 INTO :XM-DIST-ACCT-NO                                  
                 FROM CSS_MKT_XREF_ACCT  XM WITH(READUNCOMMITTED)               
                WHERE XM.ACCOUNT_NO = :XM-ACCOUNT-NO                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     21460000
MFA-TR*        SELECT XM.DIST_ACCT_NO                                   21470000
MFA-TR*          INTO :XM-DIST-ACCT-NO                                  21490000
MFA-TR*          FROM CSS_MKT_XREF_ACCT  XM                             21510000
MFA-TR*         WHERE XM.ACCOUNT_NO = :XM-ACCOUNT-NO                    21520000
MFA-TR*          WITH UR                                                21530000
MFA-TR*       QUERYNO 7240                                                      
MFA-TR*    END-EXEC.                                                    21570000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7240'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_MKT_XREF_ACCT'       TO TABLE-1                 
              MOVE 'DIST_ACCT_NO'            TO TABLE-ELEMENT-1         
              MOVE XM-DIST-ACCT-NO           TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7240-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7250-OPEN-DIST-MET-CUR                                        *         
      ******************************************************************        
       7250-OPEN-DIST-MET-CUR.                                          
                                                                        
           EXEC SQL                                                     
                OPEN DIST_XREF_MET_CUR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-4.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7250'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_DIST_XREF_MTR'   TO TABLE-1                     
              MOVE 'DIST_ACCOUNT_NO'     TO TABLE-ELEMENT-1             
              MOVE TM-DIST-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7260-FETCH-DIST-MET-CUR                                        *        
      ******************************************************************        
       7260-FETCH-DIST-MET-CUR.                                         
                                                                        
           EXEC SQL                                                     
               FETCH DIST_XREF_MET_CUR                                  
                INTO :TM-DIST-COMPANY-NO                                
                    ,:TM-DIST-ACCOUNT-NO                                
                    ,:TM-DIST-METER-NO                                  
                    ,:TM-CODE-UTIL-TYPE                                 
                    ,:TM-METER-NO                                       
                    ,:TM-STATUS-CD                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-4          
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    SET NO-MORE-DIST-MET    TO TRUE                     
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE '7260'             TO ACTIVE-PARAGRAPH         
                    MOVE 'FETCH'            TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSS_DIST_XREF_MTR'                            
                                            TO TABLE-1                  
                    MOVE 'DIST-COMPANY-NO'  TO TABLE-ELEMENT-1          
                    MOVE 'DIST-ACCOUNT-NO'  TO TABLE-ELEMENT-2          
                    MOVE 'CODE_UTIL_TYPE'   TO TABLE-ELEMENT-3          
                    MOVE 'METER_NO'         TO TABLE-ELEMENT-4          
                    MOVE TM-DIST-COMPANY-NO TO HOSTVAR-ELEMENT-1        
                    MOVE TM-DIST-ACCOUNT-NO TO HOSTVAR-ELEMENT-2        
                    MOVE TM-CODE-UTIL-TYPE  TO HOSTVAR-ELEMENT-3        
                    MOVE TM-METER-NO        TO HOSTVAR-ELEMENT-4        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       7260-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7270-CLOSE-DIST-MET-CUR                                        *        
      ******************************************************************        
       7270-CLOSE-DIST-MET-CUR.                                         
                                                                        
           EXEC SQL                                                     
                CLOSE DIST_XREF_MET_CUR                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-4.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7270'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_DIST_XREF_MTR'      TO TABLE-1                  
              MOVE 'DIST-ACCOUNT-NO'        TO TABLE-ELEMENT-1          
              MOVE TM-DIST-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7270-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7300-GET-DELINQ-VALUE.                                         *        
      ******************************************************************        
       7300-GET-DELINQ-VALUE.                                           
                                                                        
           EXEC SQL                                                     
              SELECT C8.DELINQ_VALUE                                    
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY C8 WITH(READUNCOMMITTED)                   
               WHERE C8.DELINQ_CD  = :C8-DELINQ-CD                      
                 AND C8.COMPANY_NO = :C8-COMPANY-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT C8.DELINQ_VALUE                                            
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY C8                                         
MFA-TR*        WHERE C8.DELINQ_CD  = :C8-DELINQ-CD                              
MFA-TR*          AND C8.COMPANY_NO = :C8-COMPANY-NO                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7300                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7300'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_DELINQUENCY'        TO TABLE-1                  
              MOVE 'DELINQ_CD'              TO TABLE-ELEMENT-1          
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-2          
              MOVE C8-DELINQ-CD             TO HOSTVAR-ELEMENT-1        
              MOVE C8-COMPANY-NO            TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7500-OPEN-CODE-VALUE-CUR.                                      *        
      ******************************************************************        
       7500-OPEN-CODE-VALUE-CUR.                                        
                                                                        
           EXEC SQL                                                     
                OPEN CODE_VALUE_CUR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7500'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_CODE_VALUE'      TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7510-FETCH-CODE-VALUE-CUR.                                     *        
      ******************************************************************        
       7510-FETCH-CODE-VALUE-CUR.                                       
                                                                        
           EXEC SQL                                                     
               FETCH CODE_VALUE_CUR                                     
                INTO :UV-CODE-VALUE                                     
                    ,:UV-COMPANY-NO                                     
                    ,:UV-COLUMN-NA                                      
                    ,:UV-TABLE-NA                                       
                    ,:UV-CODE-LONG-DESC                                 
                    ,:UV-CODE-SHORT-DESC                                
                    ,:UV-SORT-ORDER                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE 'Y'                TO WS-NO-MORE-CD-VALUE      
                    MOVE 0                  TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE '7510'             TO ACTIVE-PARAGRAPH         
                    MOVE 'FETCH'            TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSS_CODE_VALUE'   TO TABLE-1                  
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       7510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7520-CLOSE-CODE-VALUE-CUR.                                     *        
      ******************************************************************        
       7520-CLOSE-CODE-VALUE-CUR.                                       
                                                                        
           EXEC SQL                                                     
                CLOSE CODE_VALUE_CUR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7520'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_CODE_VALUE'         TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7520-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7530-CHK-MTR-REL-MST                                           *        
      ******************************************************************        
       7530-CHK-MTR-REL-MST.                                            
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-MTR-REL-EXIST                                  
                FROM CSS_UTL_BILL_REL                                   
               WHERE ACCOUNT_NO_MST     = :UR-ACCOUNT-NO-MST            
                 AND CODE_UTIL_TYPE_MST = :UR-CODE-UTIL-TYPE-MST        
                 AND IC_NO_MST          = :UR-IC-NO-MST                 
                 AND MTR_REF_NO_MST     = :UR-MTR-REF-NO-MST            
                                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-MTR-REL-EXIST                                          
MFA-TR*         FROM CSS_UTL_BILL_REL                                           
MFA-TR*        WHERE ACCOUNT_NO_MST     = :UR-ACCOUNT-NO-MST                    
MFA-TR*          AND CODE_UTIL_TYPE_MST = :UR-CODE-UTIL-TYPE-MST                
MFA-TR*          AND IC_NO_MST          = :UR-IC-NO-MST                         
MFA-TR*          AND MTR_REF_NO_MST     = :UR-MTR-REF-NO-MST                    
MFA-TR*        FETCH FIRST 1 ROW ONLY                                           
MFA-TR*      QUERYNO 7530                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7530'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_UTL_BILL_REL'       TO TABLE-1                  
              MOVE 'UR-ACCOUNT-NO-MST'      TO TABLE-ELEMENT-1          
              MOVE 'UR-CODE-UTIL-TYPE-MST'  TO TABLE-ELEMENT-2          
              MOVE 'UR-IC-NO-MST'           TO TABLE-ELEMENT-3          
              MOVE UR-ACCOUNT-NO-MST        TO HOSTVAR-ELEMENT-1        
              MOVE UR-CODE-UTIL-TYPE-MST    TO HOSTVAR-ELEMENT-2        
              MOVE UR-IC-NO-MST             TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7530-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7540-CHK-MTR-REL-DEP                                           *        
      ******************************************************************        
       7540-CHK-MTR-REL-DEP.                                            
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-MTR-REL-EXIST                                  
                FROM CSS_UTL_BILL_REL                                   
               WHERE ACCOUNT_NO_DEP     = :UR-ACCOUNT-NO-DEP            
                 AND CODE_UTIL_TYPE_DEP = :UR-CODE-UTIL-TYPE-DEP        
                 AND IC_NO_DEP          = :UR-IC-NO-DEP                 
                 AND MTR_REF_NO_DEP     = :UR-MTR-REF-NO-DEP            
                                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-MTR-REL-EXIST                                          
MFA-TR*         FROM CSS_UTL_BILL_REL                                           
MFA-TR*        WHERE ACCOUNT_NO_DEP     = :UR-ACCOUNT-NO-DEP                    
MFA-TR*          AND CODE_UTIL_TYPE_DEP = :UR-CODE-UTIL-TYPE-DEP                
MFA-TR*          AND IC_NO_DEP          = :UR-IC-NO-DEP                         
MFA-TR*          AND MTR_REF_NO_DEP     = :UR-MTR-REF-NO-DEP                    
MFA-TR*        FETCH FIRST 1 ROW ONLY                                           
MFA-TR*      QUERYNO 7540                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7540'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_UTL_BILL_REL'       TO TABLE-1                  
              MOVE 'UR-ACCOUNT-NO-DEP'      TO TABLE-ELEMENT-1          
              MOVE 'UR-CODE-UTIL-TYPE-DEP'  TO TABLE-ELEMENT-2          
              MOVE 'UR-IC-NO-DEP'           TO TABLE-ELEMENT-3          
              MOVE UR-ACCOUNT-NO-DEP        TO HOSTVAR-ELEMENT-1        
              MOVE UR-CODE-UTIL-TYPE-DEP    TO HOSTVAR-ELEMENT-2        
              MOVE UR-IC-NO-DEP             TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7540-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8000A-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000A-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04643_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04643_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1          
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000A'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04643_R1'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       8000A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8000B-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000B-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04643_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04643_R2                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-2.         
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-2          
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000B'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04643_R2'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       8000B-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8000C-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000C-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04643_R3                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04643_R3                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3.            
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES          TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3             
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME    TO ABEND-PROGRAM               
                    MOVE SQLCODE         TO ABEND-SQLCODE               
                    MOVE SQLSTATE        TO ABEND-SQLSTATE              
                    MOVE '8000C'         TO ACTIVE-PARAGRAPH            
                    MOVE 'DELETE'        TO ABEND-FUNCTION              
                    MOVE SPACES          TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                    MOVE 'CSR04643_R3'   TO TABLE-1                     
                    MOVE SPACES          TO TABLE-ELEMENT-1             
                    MOVE SPACES          TO HOSTVAR-ELEMENT-1           
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       8000C-EXIT.                                                      
            EXIT.                                                       
                                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8000D-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000D-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04643_R4                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04643_R4                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-4.            
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES          TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-4             
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME    TO ABEND-PROGRAM               
                    MOVE SQLCODE         TO ABEND-SQLCODE               
                    MOVE SQLSTATE        TO ABEND-SQLSTATE              
                    MOVE '8000D'         TO ACTIVE-PARAGRAPH            
                    MOVE 'DELETE'        TO ABEND-FUNCTION              
                    MOVE SPACES          TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                    MOVE 'CSR04643_R4'   TO TABLE-1                     
                    MOVE SPACES          TO TABLE-ELEMENT-1             
                    MOVE SPACES          TO HOSTVAR-ELEMENT-1           
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       8000D-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8010-INSERT-GTT-R1.   OFFER CODE TABLE                         *        
      ******************************************************************        
       8010-INSERT-GTT-R1.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04643_R1                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,METER_NO                                             
                  ,MTR_REF_NO                                           
                  ,CODE_UTIL_TYPE                                       
                  ,IC_NO                                                
                  ,RATE_PLAN_NO                                         
                  ,SECURE_RATE_FLAG                                     
                  ,NO_READ_DIALS                                        
                  ,CONSTANT                                             
                  ,METER_TYPE                                           
                  ,ELEC_MTR_FORM_CD                                     
                  ,MONTHS_INACTIVE                                      
                  ,CCF_CAP_PER_HR                                       
                  ,CONNECTION_TYPE                                      
                  ,OPTIMUM_READ_DATE                                    
                  ,POINT_ID                                             
                  ,LAST_VALID_READ_DT                                   
                  ,CODE_METER_STATUS                                    
                  ,MTR_READ_SOURCE_CD                                   
                  ,REMOTE_READ_IND                                      
                  ,CODE_MTR_RD_INST1                                    
                  ,CODE_MTR_RD_INST2                                    
                  ,CODE_MTR_RD_INST3                                    
                  ,METER_PRESSURE                                       
                  ,CODE_METER_LOC                                       
                  ,METER_SUPPLYING                                      
                  ,DIGTL_MTR_TYPE                                       
                  ,PROGRAM_ID                                           
                  ,DATE_MTR_INSTALL                                     
                  ,NO_CONSEC_ESTIMATE                                   
                  ,MIN_NO_UNITS                                         
                  ,MAX_NO_UNITS                                         
                  ,UTILITY_SOURCE_CD                                    
                  ,DELIVERY_LEVEL_CD                                    
                  ,PHASE                                                
                  ,INDUST_BTU_ID                                        
                  ,REGISTER_RD_SEQ                                      
                  ,SEAL_CODE_ID                                         
                  ,LOCK_TYPE_ID                                         
                  ,IDR_RECIPIENT_CD                                     
                  ,INSULATED_IND                                        
                  ,DEVICE_NO                                            
                  ,CODE_ATT_TYPE                                        
                  ,CODE_SHORT_DESC                                      
                  ,MTR_ATT_TYPE_TX                                      
                  ,CODE_METER_TYPE                                      
                  ,GIS_MISMATCH_FL                                      
                  ,MTR_RLTN_EXISTS                                      
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-1                                     
                  ,:S-APPL-RETURN-CODE-1                                
                  ,:S-RS1-METER-NO                                      
                  ,:S-RS1-MTR-REF-NO                                    
                  ,:S-RS1-CODE-UTIL-TYPE                                
                  ,:S-RS1-IC-NO                                         
                  ,:S-RS1-RATE-PLAN-NO                                  
                  ,:S-RS1-SECURE-RATE-FLAG                              
                  ,:S-RS1-NO-READ-DIALS                                 
                  ,:S-RS1-CONSTANT                                      
                  ,:S-RS1-METER-TYPE                                    
                  ,:S-RS1-ELEC-MTR-FORM-CD                              
                  ,:S-RS1-MONTHS-INACTIVE                               
                  ,:S-RS1-CCF-CAP-PER-HR                                
                  ,:S-RS1-CONNECTION-TYPE                               
                  ,:S-RS1-OPTIMUM-READ-DATE                             
                  ,:S-RS1-POINT-ID                                      
                  ,:S-RS1-LAST-VALID-READ-DT                            
                  ,:S-RS1-CODE-METER-STATUS                             
                  ,:S-RS1-MTR-READ-SOURCE-CD                            
                  ,:S-RS1-REMOTE-READ-IND                               
                  ,:S-RS1-CODE-MTR-RD-INST1                             
                  ,:S-RS1-CODE-MTR-RD-INST2                             
                  ,:S-RS1-CODE-MTR-RD-INST3                             
                  ,:S-RS1-METER-PRESSURE                                
                  ,:S-RS1-CODE-METER-LOC                                
                  ,:S-RS1-METER-SUPPLYING                               
                  ,:S-RS1-DIGTL-MTR-TYPE                                
                  ,:S-RS1-PROGRAM-ID                                    
                  ,:S-RS1-DATE-MTR-INSTALL                              
                  ,:S-RS1-NO-CONSEC-ESTIMATE                            
                  ,:S-RS1-MIN-NO-UNITS                                  
                  ,:S-RS1-MAX-NO-UNITS                                  
                  ,:S-RS1-UTILITY-SOURCE-CD                             
                  ,:S-RS1-DELIVERY-LEVEL-CD                             
                  ,:S-RS1-PHASE                                         
                  ,:S-RS1-INDUST-BTU-ID                                 
                  ,:S-RS1-REGISTER-RD-SEQ                               
                  ,:S-RS1-SEAL-CODE-ID                                  
                  ,:S-RS1-LOCK-TYPE-ID                                  
                  ,:S-RS1-IDR-RECIPIENT-CD                              
                  ,:S-RS1-INSULATED-IND                                 
                  ,:S-RS1-DEVICE-NO                                     
                  ,:S-RS1-CODE-ATT-TYPE                                 
                  ,:S-RS1-CODE-SHORT-DESC                               
                  ,:S-RS1-MTR-ATT-TYPE-TX                               
                  ,:S-RS1-CODE-METER-TYPE                               
                  ,:S-RS1-GIS-MISMATCH-FL                               
                  ,:S-RS1-MTR-REL-EXISTS                                
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04643_R1                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,METER_NO                                                     
MFA-TR*           ,MTR_REF_NO                                                   
MFA-TR*           ,CODE_UTIL_TYPE                                               
MFA-TR*           ,IC_NO                                                        
MFA-TR*           ,RATE_PLAN_NO                                                 
MFA-TR*           ,SECURE_RATE_FLAG                                             
MFA-TR*           ,NO_READ_DIALS                                                
MFA-TR*           ,CONSTANT                                                     
MFA-TR*           ,METER_TYPE                                                   
MFA-TR*           ,ELEC_MTR_FORM_CD                                             
MFA-TR*           ,MONTHS_INACTIVE                                              
MFA-TR*           ,CCF_CAP_PER_HR                                               
MFA-TR*           ,CONNECTION_TYPE                                              
MFA-TR*           ,OPTIMUM_READ_DATE                                            
MFA-TR*           ,POINT_ID                                                     
MFA-TR*           ,LAST_VALID_READ_DT                                           
MFA-TR*           ,CODE_METER_STATUS                                            
MFA-TR*           ,MTR_READ_SOURCE_CD                                           
MFA-TR*           ,REMOTE_READ_IND                                              
MFA-TR*           ,CODE_MTR_RD_INST1                                            
MFA-TR*           ,CODE_MTR_RD_INST2                                            
MFA-TR*           ,CODE_MTR_RD_INST3                                            
MFA-TR*           ,METER_PRESSURE                                               
MFA-TR*           ,CODE_METER_LOC                                               
MFA-TR*           ,METER_SUPPLYING                                              
MFA-TR*           ,DIGTL_MTR_TYPE                                               
MFA-TR*           ,PROGRAM_ID                                                   
MFA-TR*           ,DATE_MTR_INSTALL                                             
MFA-TR*           ,NO_CONSEC_ESTIMATE                                           
MFA-TR*           ,MIN_NO_UNITS                                                 
MFA-TR*           ,MAX_NO_UNITS                                                 
MFA-TR*           ,UTILITY_SOURCE_CD                                            
MFA-TR*           ,DELIVERY_LEVEL_CD                                            
MFA-TR*           ,PHASE                                                        
MFA-TR*           ,INDUST_BTU_ID                                                
MFA-TR*           ,REGISTER_RD_SEQ                                              
MFA-TR*           ,SEAL_CODE_ID                                                 
MFA-TR*           ,LOCK_TYPE_ID                                                 
MFA-TR*           ,IDR_RECIPIENT_CD                                             
MFA-TR*           ,INSULATED_IND                                                
MFA-TR*           ,DEVICE_NO                                                    
MFA-TR*           ,CODE_ATT_TYPE                                                
MFA-TR*           ,CODE_SHORT_DESC                                              
MFA-TR*           ,MTR_ATT_TYPE_TX                                              
MFA-TR*           ,CODE_METER_TYPE                                              
MFA-TR*           ,GIS_MISMATCH_FL                                              
MFA-TR*           ,MTR_RLTN_EXISTS                                              
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-1                                             
MFA-TR*           ,:S-APPL-RETURN-CODE-1                                        
MFA-TR*           ,:S-RS1-METER-NO                                              
MFA-TR*           ,:S-RS1-MTR-REF-NO                                            
MFA-TR*           ,:S-RS1-CODE-UTIL-TYPE                                        
MFA-TR*           ,:S-RS1-IC-NO                                                 
MFA-TR*           ,:S-RS1-RATE-PLAN-NO                                          
MFA-TR*           ,:S-RS1-SECURE-RATE-FLAG                                      
MFA-TR*           ,:S-RS1-NO-READ-DIALS                                         
MFA-TR*           ,:S-RS1-CONSTANT                                              
MFA-TR*           ,:S-RS1-METER-TYPE                                            
MFA-TR*           ,:S-RS1-ELEC-MTR-FORM-CD                                      
MFA-TR*           ,:S-RS1-MONTHS-INACTIVE                                       
MFA-TR*           ,:S-RS1-CCF-CAP-PER-HR                                        
MFA-TR*           ,:S-RS1-CONNECTION-TYPE                                       
MFA-TR*           ,:S-RS1-OPTIMUM-READ-DATE                                     
MFA-TR*           ,:S-RS1-POINT-ID                                              
MFA-TR*           ,:S-RS1-LAST-VALID-READ-DT                                    
MFA-TR*           ,:S-RS1-CODE-METER-STATUS                                     
MFA-TR*           ,:S-RS1-MTR-READ-SOURCE-CD                                    
MFA-TR*           ,:S-RS1-REMOTE-READ-IND                                       
MFA-TR*           ,:S-RS1-CODE-MTR-RD-INST1                                     
MFA-TR*           ,:S-RS1-CODE-MTR-RD-INST2                                     
MFA-TR*           ,:S-RS1-CODE-MTR-RD-INST3                                     
MFA-TR*           ,:S-RS1-METER-PRESSURE                                        
MFA-TR*           ,:S-RS1-CODE-METER-LOC                                        
MFA-TR*           ,:S-RS1-METER-SUPPLYING                                       
MFA-TR*           ,:S-RS1-DIGTL-MTR-TYPE                                        
MFA-TR*           ,:S-RS1-PROGRAM-ID                                            
MFA-TR*           ,:S-RS1-DATE-MTR-INSTALL                                      
MFA-TR*           ,:S-RS1-NO-CONSEC-ESTIMATE                                    
MFA-TR*           ,:S-RS1-MIN-NO-UNITS                                          
MFA-TR*           ,:S-RS1-MAX-NO-UNITS                                          
MFA-TR*           ,:S-RS1-UTILITY-SOURCE-CD                                     
MFA-TR*           ,:S-RS1-DELIVERY-LEVEL-CD                                     
MFA-TR*           ,:S-RS1-PHASE                                                 
MFA-TR*           ,:S-RS1-INDUST-BTU-ID                                         
MFA-TR*           ,:S-RS1-REGISTER-RD-SEQ                                       
MFA-TR*           ,:S-RS1-SEAL-CODE-ID                                          
MFA-TR*           ,:S-RS1-LOCK-TYPE-ID                                          
MFA-TR*           ,:S-RS1-IDR-RECIPIENT-CD                                      
MFA-TR*           ,:S-RS1-INSULATED-IND                                         
MFA-TR*           ,:S-RS1-DEVICE-NO                                             
MFA-TR*           ,:S-RS1-CODE-ATT-TYPE                                         
MFA-TR*           ,:S-RS1-CODE-SHORT-DESC                                       
MFA-TR*           ,:S-RS1-MTR-ATT-TYPE-TX                                       
MFA-TR*           ,:S-RS1-CODE-METER-TYPE                                       
MFA-TR*           ,:S-RS1-GIS-MISMATCH-FL                                       
MFA-TR*           ,:S-RS1-MTR-REL-EXISTS                                        
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R1 = 'Y'             
              ADD +1                     TO  CTR-ROWS-RS1               
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8010'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE 'Y'                   TO  WS-ERR-INSRT-R1            
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04643_R1'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
        8010-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8020-INSERT-GTT-R2.                                            *        
      ******************************************************************        
       8020-INSERT-GTT-R2.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04643_R2                           
                 (                                                      
                     RETURN_CODE                                        
                    ,APPL_RETURN_CODE                                   
                    ,METER_NO                                           
                    ,MTR_REF_NO                                         
                    ,CODE_UTIL_TYPE                                     
                    ,IC_NO                                              
                    ,REG_ID_NO                                          
                    ,CODE_TIME_PERIOD                                   
                    ,CODE_REG_STATUS                                    
                    ,CODE_STATUS_REAS                                   
                    ,CODE_NO_RD_REASON                                  
                    ,LAST_VAL_RD_VALUE                                  
                    ,CODE_LAST_VALID_RD                                 
                    ,LAST_VALID_READ_DT                                 
                    ,LAST_VALID_READ_TM                                 
                    ,LAST_READ_VALUE                                    
                    ,CODE_LAST_REG_READ                                 
                    ,LAST_REG_READ_DT                                   
                    ,LAST_REG_READ_TM                                   
                    ,NO_READ_DIALS                                      
                    ,CONSTANT                                           
                    ,METER_USAGE_DESC                                   
                    ,READ_SEQUENCE_NO                                   
                    ,CODE_CRNT_REG_READ                                 
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-2                                     
                  ,:S-APPL-RETURN-CODE-2                                
                  ,:S-RS2-METER-NO                                      
                  ,:S-RS2-MTR-REF-NO                                    
                  ,:S-RS2-CODE-UTIL-TYPE                                
                  ,:S-RS2-IC-NO                                         
                  ,:S-RS2-REG-ID-NO                                     
                  ,:S-RS2-CODE-TIME-PERIOD                              
                  ,:S-RS2-CODE-REG-STATUS                               
                  ,:S-RS2-CODE-STATUS-REAS                              
                  ,:S-RS2-CODE-NO-RD-REASON                             
                  ,:S-RS2-LAST-VAL-RD-VALUE                             
                  ,:S-RS2-CODE-LAST-VALID-RD                            
                  ,:S-RS2-LAST-VALID-READ-DT                            
                  ,:S-RS2-LAST-VALID-READ-TM                            
                  ,:S-RS2-LAST-READ-VALUE                               
                  ,:S-RS2-CODE-LAST-REG-READ                            
                  ,:S-RS2-LAST-REG-READ-DT                              
                  ,:S-RS2-LAST-REG-READ-TM                              
                  ,:S-RS2-NO-READ-DIALS                                 
                  ,:S-RS2-CONSTANT                                      
                  ,:S-RS2-METER-USAGE-DESC                              
                  ,:S-RS2-READ-SEQUENCE-NO                              
                  ,:S-RS2-CODE-CRNT-REG-READ                            
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04643_R2                                   
MFA-TR*          (                                                              
MFA-TR*              RETURN_CODE                                                
MFA-TR*             ,APPL_RETURN_CODE                                           
MFA-TR*             ,METER_NO                                                   
MFA-TR*             ,MTR_REF_NO                                                 
MFA-TR*             ,CODE_UTIL_TYPE                                             
MFA-TR*             ,IC_NO                                                      
MFA-TR*             ,REG_ID_NO                                                  
MFA-TR*             ,CODE_TIME_PERIOD                                           
MFA-TR*             ,CODE_REG_STATUS                                            
MFA-TR*             ,CODE_STATUS_REAS                                           
MFA-TR*             ,CODE_NO_RD_REASON                                          
MFA-TR*             ,LAST_VAL_RD_VALUE                                          
MFA-TR*             ,CODE_LAST_VALID_RD                                         
MFA-TR*             ,LAST_VALID_READ_DT                                         
MFA-TR*             ,LAST_VALID_READ_TM                                         
MFA-TR*             ,LAST_READ_VALUE                                            
MFA-TR*             ,CODE_LAST_REG_READ                                         
MFA-TR*             ,LAST_REG_READ_DT                                           
MFA-TR*             ,LAST_REG_READ_TM                                           
MFA-TR*             ,NO_READ_DIALS                                              
MFA-TR*             ,CONSTANT                                                   
MFA-TR*             ,METER_USAGE_DESC                                           
MFA-TR*             ,READ_SEQUENCE_NO                                           
MFA-TR*             ,CODE_CRNT_REG_READ                                         
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-2                                             
MFA-TR*           ,:S-APPL-RETURN-CODE-2                                        
MFA-TR*           ,:S-RS2-METER-NO                                              
MFA-TR*           ,:S-RS2-MTR-REF-NO                                            
MFA-TR*           ,:S-RS2-CODE-UTIL-TYPE                                        
MFA-TR*           ,:S-RS2-IC-NO                                                 
MFA-TR*           ,:S-RS2-REG-ID-NO                                             
MFA-TR*           ,:S-RS2-CODE-TIME-PERIOD                                      
MFA-TR*           ,:S-RS2-CODE-REG-STATUS                                       
MFA-TR*           ,:S-RS2-CODE-STATUS-REAS                                      
MFA-TR*           ,:S-RS2-CODE-NO-RD-REASON                                     
MFA-TR*           ,:S-RS2-LAST-VAL-RD-VALUE                                     
MFA-TR*           ,:S-RS2-CODE-LAST-VALID-RD                                    
MFA-TR*           ,:S-RS2-LAST-VALID-READ-DT                                    
MFA-TR*           ,:S-RS2-LAST-VALID-READ-TM                                    
MFA-TR*           ,:S-RS2-LAST-READ-VALUE                                       
MFA-TR*           ,:S-RS2-CODE-LAST-REG-READ                                    
MFA-TR*           ,:S-RS2-LAST-REG-READ-DT                                      
MFA-TR*           ,:S-RS2-LAST-REG-READ-TM                                      
MFA-TR*           ,:S-RS2-NO-READ-DIALS                                         
MFA-TR*           ,:S-RS2-CONSTANT                                              
MFA-TR*           ,:S-RS2-METER-USAGE-DESC                                      
MFA-TR*           ,:S-RS2-READ-SEQUENCE-NO                                      
MFA-TR*           ,:S-RS2-CODE-CRNT-REG-READ                                    
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R2 = 'Y'             
              ADD +1                     TO  CTR-ROWS-RS2               
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8020'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE 'Y'                   TO  WS-ERR-INSRT-R2            
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04643_R2'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
        8020-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8030-INSERT-GTT-R3.                                            *        
      ******************************************************************        
       8030-INSERT-GTT-R3.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04643_R3                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,BUS_RULE_ID                                          
                  ,BUS_RULE_RESULT_CD                                   
                  ,BUS_RULE_XREF_ID                                     
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-3                                     
                  ,:S-APPL-RETURN-CODE-3                                
                  ,:S-RS3-BUS-RULE-ID                                   
                  ,:S-RS3-BUS-RULE-RESULT-CD                            
                  ,:S-RS3-BUS-RULE-XREF-ID                              
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04643_R3                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,BUS_RULE_ID                                                  
MFA-TR*           ,BUS_RULE_RESULT_CD                                           
MFA-TR*           ,BUS_RULE_XREF_ID                                             
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-3                                             
MFA-TR*           ,:S-APPL-RETURN-CODE-3                                        
MFA-TR*           ,:S-RS3-BUS-RULE-ID                                           
MFA-TR*           ,:S-RS3-BUS-RULE-RESULT-CD                                    
MFA-TR*           ,:S-RS3-BUS-RULE-XREF-ID                                      
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R3 = 'Y'             
              ADD +1                     TO  CTR-ROWS-RS3               
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8030'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE 'Y'                   TO  WS-ERR-INSRT-R3            
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04643_R3'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
        8030-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8040-INSERT-GTT-R4.                                            *        
      ******************************************************************        
       8040-INSERT-GTT-R4.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04643_R4                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,DIST_COMPANY_NO                                      
                  ,DIST_ACCOUNT_NO                                      
                  ,DIST_METER_NO                                        
                  ,CODE_UTIL_TYPE                                       
                  ,METER_NO                                             
                  ,STATUS_CD                                            
                  ,STATUS_DESC                                          
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-4                                     
                  ,:S-APPL-RETURN-CODE-4                                
                  ,:S-RS4-DIST-COMPANY-NO                               
                  ,:S-RS4-DIST-ACCOUNT-NO                               
                  ,:S-RS4-DIST-METER-NO                                 
                  ,:S-RS4-CODE-UTIL-TYPE                                
                  ,:S-RS4-METER-NO                                      
                  ,:S-RS4-STATUS-CD                                     
                  ,:S-RS4-STATUS-DESC                                   
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04643_R4                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,DIST_COMPANY_NO                                              
MFA-TR*           ,DIST_ACCOUNT_NO                                              
MFA-TR*           ,DIST_METER_NO                                                
MFA-TR*           ,CODE_UTIL_TYPE                                               
MFA-TR*           ,METER_NO                                                     
MFA-TR*           ,STATUS_CD                                                    
MFA-TR*           ,STATUS_DESC                                                  
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-4                                             
MFA-TR*           ,:S-APPL-RETURN-CODE-4                                        
MFA-TR*           ,:S-RS4-DIST-COMPANY-NO                                       
MFA-TR*           ,:S-RS4-DIST-ACCOUNT-NO                                       
MFA-TR*           ,:S-RS4-DIST-METER-NO                                         
MFA-TR*           ,:S-RS4-CODE-UTIL-TYPE                                        
MFA-TR*           ,:S-RS4-METER-NO                                              
MFA-TR*           ,:S-RS4-STATUS-CD                                             
MFA-TR*           ,:S-RS4-STATUS-DESC                                           
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-4.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R4 = 'Y'             
              ADD +1                     TO  CTR-ROWS-RS4               
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8040'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE 'Y'                   TO  WS-ERR-INSRT-R4            
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04643_R4'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
        8040-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8800-CHECK-RESULTS.                                           *         
      *****************************************************************         
       8800-CHECK-RESULTS.                                              
                                                                        
           IF CTR-ROWS-RS1 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-1                            
              MOVE   0                       TO S-RETURN-CODE-1         
              MOVE 100                       TO S-APPL-RETURN-CODE-1    
              PERFORM 8010-INSERT-GTT-R1     THRU 8010-EXIT             
           END-IF.                                                      
      *                                                                         
           IF CTR-ROWS-RS2 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-2                            
              MOVE   0                       TO S-RETURN-CODE-2         
              MOVE 100                       TO S-APPL-RETURN-CODE-2    
              PERFORM 8020-INSERT-GTT-R2     THRU 8020-EXIT             
           END-IF.                                                      
      *                                                                         
           IF CTR-ROWS-RS3 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-3                            
              MOVE   0                       TO S-RETURN-CODE-3         
              MOVE 100                       TO S-APPL-RETURN-CODE-3    
              PERFORM 8030-INSERT-GTT-R3     THRU 8030-EXIT             
           END-IF.                                                      
      *                                                                         
           IF CTR-ROWS-RS4 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-4                            
              MOVE   0                       TO S-RETURN-CODE-4         
              MOVE 100                       TO S-APPL-RETURN-CODE-4    
              PERFORM 8040-INSERT-GTT-R4     THRU 8040-EXIT             
           END-IF.                                                      
      *                                                                         
       8800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8900-SEND-DONE.                                                *        
      ******************************************************************        
       8900-SEND-DONE.                                                  
                                                                        
           MOVE PROGRAM-NAME          TO ABEND-PROGRAM                  
           MOVE '8900'                TO ACTIVE-PARAGRAPH               
           MOVE 'OPEN'                TO ABEND-FUNCTION                 
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE 'CSR04643_R1'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C2                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE 'CSR04643_R2'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C3                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C3 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE 'CSR04643_R3'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C4                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C4 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-4.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE 'CSR04643_R4'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 9000-SEND-ERROR-RESULT                                         *        
      ******************************************************************        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE       TO ABEND-SQLCODE            
                                               S-RETURN-CODE-1          
                                               S-RETURN-CODE-2          
                                               S-RETURN-CODE-3          
                                               S-RETURN-CODE-4.         
                                                                        
           MOVE WS-APPL-RETURN-CODE         TO S-APPL-RETURN-CODE-1     
                                               S-APPL-RETURN-CODE-2     
                                               S-APPL-RETURN-CODE-3     
                                               S-APPL-RETURN-CODE-4.    
                                                                        
                                                                        
           MOVE SQLERRMC                    TO ABEND-SQLERRMC.          
                                                                        
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'               TO ABEND-FUNCTION           
           END-IF.                                                      
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1        THRU 0100A-EXIT.         
           PERFORM 0100B-DECLARE-GTT-R2        THRU 0100B-EXIT.         
           PERFORM 0100C-DECLARE-GTT-R3        THRU 0100C-EXIT.         
           PERFORM 0100D-DECLARE-GTT-R4        THRU 0100D-EXIT.         
                                                                        
           PERFORM 8010-INSERT-GTT-R1          THRU 8010-EXIT.          
           PERFORM 8020-INSERT-GTT-R2          THRU 8020-EXIT.          
           PERFORM 8030-INSERT-GTT-R3          THRU 8030-EXIT.          
           PERFORM 8040-INSERT-GTT-R4          THRU 8040-EXIT.          
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9700-ABEND-PROCESSING.                                         *        
      ******************************************************************        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT.             
           PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT.             
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900-SQL-ERROR-ROUTINE.                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9999-END-PROGRAM.                                              *        
      ******************************************************************        
                                                                        
       9999-END-PROGRAM.                                                
                                                                        
            PERFORM 8800-CHECK-RESULTS THRU 8800-EXIT                   
            PERFORM 8900-SEND-DONE     THRU 8900-EXIT                   
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
