       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.      CSR04642.                                       
       AUTHOR.       SAKTHIVEL MATHIYAZHAGAN.                           
COB303 DATE-WRITTEN. SEPTEMBER 10, 2013.                                
       DATE-COMPILED.                                                   
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE:  CSR04642              --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--                                                            --         
      *--  CSR04642 :                                                --         
      *--                                                            --         
      *--  #  THIS STORED PROCEDURE IS PERFORM INSERT,UPDATE AND     --         
      *--     DELETE FOR RATE DETAILS SCREEN.                        --         
      *--                                                            --         
      *--     CLONED FROM: CSR02211                                  --         
      *--                                                            --         
      *--    NOTE:FOR SEB REGION CAN PERFORM ONLY UPDATE AND DELETE. --         
      *--        :DELETE FUNCTION CAN PERFORM WHEN THERE IS NO MTR.  --         
      *--                                                            --         
      *--  INSERT:                                                   --         
      *--     1. INCREASE THE MAXIMUM IC NUMBER.                     --         
      *--     2. INSERT NEW ROW IN CSS_UTIL_ENVRNMT TABLE.           --         
      *--     3. UPDATE DATE_LAST_ACTION IN CSS_ACCOUNT TABLE.       --         
      *--     4. UPDATE CODE_COMPANY_ACCT IN CSS_ACCOUNT TABLE.      --         
      *--        WHEN CODE REVENUE CLASS CHANGED.                    --         
      *--     5. UPDATE PERSONAL-CNTCT-CD BASED ON THE UTIL TYPE.    --         
      *--                                                            --         
      *--  UPDATE:                                                   --         
      *--     1. IF RATE PLAN NUMBER CHANGES, INSERT BILL MESSAGE.   --         
      *--     2. IF RATE & REV CLAS CHANGE, CREATE A WQ.             --         
      *--     3. UPDATE THE EXISTING ROE IN CSS_UTIL_ENVRNMT TABLE.  --         
      *--     4. UPDATE LIFETIME PEAK DEMAND AND DATE IN CSS_BILL_   --         
      *--        CONTRACT IF THE CONTRACT RECORD EXISTS.             --         
      *--     5. IF BILL CYCLE CHANGE, UPDATE PRORATE CODE IN        --         
      *--        CSS_BILLING_DET TABLE.                              --         
      *--     6. UPDATE RATE DETAILS IN CSS_BILLING_DET IS RECORD.   --         
      *--     7. UPDATE CODE REV CLAS OF FUTURE HOOK TRANSPORTATION  --         
      *--        ROW IN CSS_BILLING_DET TABLE FOR CIG ACCOUNTS.      --         
      *--     8. UPDATE DATE_LAST_ACTION IN CSS_ACCOUNT TABLE.       --         
      *--     9. UPDATE PERSONAL-CNTCT-CD BASED ON THE  UTIL TYPE    --         
      *--        IN CSS_PREMISE TABLE.                               --         
      *--                                                            --         
      *--  DELETE:                                                   --         
      *--     1. IF ACCOUNT'S IS HAS DEPENDENT ACCOUNTS,CANNOT DELETE--         
      *--     2. IF ACCOUNT'S HAS MASTER ACCOUNTS, CANNOT DELETE.    --         
      *--     3. DELETE ICP RECORD FROM CSS_INTV_USE_CLASS.          --         
      *--     4. DELETE ICP RECORD FROM CSS_INTV_USE_CLASS.          --         
      *--     5. DELETE ICP RECORD FROM CSS_MTRD_ENVRNMT.            --         
      *--     6. DELETE ICP RECORD FROM CSS_STANDBY_GEN.             --         
      *--     7. DELETE ICP RECORD FROM CSS_CUST_PLAN.               --         
      *--     8. DELETE ICP RECORD FROM CSS_UTIL_ENVRNMT             --         
      *--     9. UPDATE DATE_LAST_ACTION IN CSS_ACCOUNT TABLE.       --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *--  PARAMETERS                                                --         
      *--                                                            --         
      *--      IN                                                    --         
      *--                                                            --         
      *--            I_APPL_PGM_ID           CHAR (08)               --         
      *--            I_UPDT_ACTION_IND       CHAR(01)                --         
      *--            I_USERID                CHAR(07)                --         
      *--            I_ACCOUNT_NO            CHAR(13)                --         
      *--            I_PREMISE_NO            CHAR(10)                --         
      *--            I_CUSTOMER_NO           CHAR(10)                --         
      *--            I_COMPANY_NO            CHAR(02)                --         
      *--            I_CODE_UTIL_TYPE        CHAR(1)                 --         
      *--            I_IC_NO                 SMALLINT                --         
      *--            I_RATE_PLAN_NO          CHAR(3)                 --         
      *--            I_CODE_REVENUE_CLASS    CHAR(3)                 --         
      *--            I_CODE_SIC_NO           CHAR(4)                 --         
      *--            I_NAICS_CD              CHAR(6)                 --         
      *--            I_SEASONAL_USE_CODE     CHAR(2)                 --         
      *--            I_ZERO_USE_INVEST_DT    CHAR(10)                --         
      *--            I_READ_CYCLE            CHAR(2)                 --         
      *--            I_READ_ROUTE            SMALLINT                --         
      *--            I_CODE_MTR_READ_FREQ    CHAR(3)                 --         
      *--            I_CODE_ESTIMATE_OK      CHAR(1)                 --         
      *--            I_PERSONAL_CNTCT_CD     CHAR(1)                 --         
      *--            I_ALTERNATE_FUEL_CD     CHAR(1)                 --         
      *--            I_PRTY_SVC_CAT_CD       CHAR(2)                 --         
      *--            I_GAS_BASE_USE          DECIMAL(9,0)            --         
      *--            I_GAS_BASE_LAST_UPDT    CHAR (10)               --         
      *--            I_CALC_ACT_TYPE_CD      CHAR(01)                --         
      *--            I_BILL_CYCLE            CHAR(02)                --         
      *--            I_PRORATE_CD            CHAR(01)                --         
      *--            I_DELETE_SUBDSN_FL      CHAR(1)                 --         
      *--            I_WQ_COMMENT            CHAR(210)               --         
      *--            I_WQ_CREATE_FL          CHAR(01)                --         
      *--                                                            --         
      *--                                                            --         
      *--      OUT                                                   --         
      *--            NONE                                            --         
      *--                                                            --         
      *--      INOUT                                                 --         
      *--            NONE                                            --         
      *--                                                            --         
      *--  RESULT SET                                                --         
      *--            RETURN_CODE             INTEGER                 --         
      *--            APPL_RETURN_CODE        INTEGER                 --         
      *--            BUS_RULE_ID             CHAR(10)                --         
      *--            ACTION_TYPE_CD          CHAR(08)                --         
      *--            BUS_RULE_XREF_ID        CHAR(26)                --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                        MODIFICATION LOG                    --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
P00738*--  09-10-2013    MS93554     PROGRAM INTIALLY WRITTEN.       --         
P00738*--  09-24-2014    AW41078     REMOVED TABLE ID F3 FROM MNT TRN--         
P00738*--                            INSERT OF REVENUE CLASS CHANGE  --         
P00738*--                            PER DEFECT 5814.                --         
A05065*--  10-28-2014    MJ13662     IF ADDING, DO NOT WRITE TRANS   --         
A05065*--                            HIST FOR PRORATE CD OR REGISTER --         
A05065*--                            RED SEQ.                        --         
A05065*--                            WRITE TRANS HIST FOR UTIL TYPE  --         
A05065*--                            AND IC NO.                      --         
A05065*--  12-12-2014    AW41078     WRITE UTIL TYPE AND IC FIRST TO --         
A05065*--                            TRANSHIST RATHER THAN LAST      --         
A05051*--  14-11-2014    AS7C117     CREATE WQ IF THE ACCOUNT IS CHANGED        
A05051*--                ACT002      RESIDENTIAL TO COMMERCIAL AND THE          
A05051*--                            ACCOUNT HAS CREDIT CARD PAYMENT            
ACT233*    07-26-2016    TP7R341     REPLACE CSR00028 WITH CSR04675    *00290000
ACT233*     APPL5460                 AND REMOVE CSS_STANDBY_GEN        *00290000
ACT365*    12-01-2016    MR7E794     FIX FOR CODE-CURTAIL-PRTY WAS     *00290000
ACT365*     APPL5460                 MISSED TO UPDATE IN TABLE         *00290000
ACT365*                              CSS_BILLING_DET AS PART OF RATE   *00290000
ACT365*                              UPDATE PROCESS.                   *00290000
ACT009*    01-21-2017    RS7V450     ADD CONDITION FOR MOVING VALUES   *00290000
ACT009*     APPL5744                 TO UT-CODE-SERVICE-TYPE AND       *00290000
ACT009*                              UT-SPLY-SENSITIVE-IND             *00290000
      *----------------------------------------------------------------         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04642'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-WORKING-STORAGE.                                          
           05 WS-SQLSTATE                 PIC X(05) VALUE SPACES.       
                                                                        
       01 WS-SWITCHES.                                                  
          05 ALL-DONE-SW                  PIC X(01) VALUE 'N'.          
             88 NOT-ALL-DONE                        VALUE 'N'.          
             88 ALL-DONE                            VALUE 'Y'.          
          05 SEND-DONE-SW                 PIC X(01) VALUE 'Y'.          
             88 SEND-DONE-ERROR                     VALUE 'N'.          
             88 SEND-DONE-OK                        VALUE 'Y'.          
          05 WS-CURR-UPDT-ACTION-IND      PIC X(01) VALUE SPACES.       
             88 RATE-INSERT                         VALUE 'I'.          
             88 RATE-UPDATE                         VALUE 'U'.          
             88 RATE-DELETE                         VALUE 'D'.          
          05 WS-REV-CLS-STATUS            PIC X(01) VALUE 'N'.          
             88 REV-CLS-EXISTS                      VALUE 'Y'.          
             88 REV-CLS-NOT-EXISTS                  VALUE 'N'.          
          05 WS-CIG-RATE-STAT             PIC X(01) VALUE 'N'.          
             88 CIG-RATE                            VALUE 'Y'.          
          05 WS-UNMETERED-EXISTS          PIC X(01) VALUE 'N'.          
             88 UNMETERED-EXISTS                    VALUE 'Y'.          
             88 UNMETERED-NOT-EXISTS                VALUE 'N'.          
          05 WS-METERED-RATE-SW           PIC X(01) VALUE 'N'.          
             88 UNMETERED-RATE                      VALUE 'Y'.          
             88 METERED-RATE                        VALUE 'N'.          
          05 WS-COMPANY-USE               PIC X(03) VALUE SPACES.       
             88  COMPANY-USE                        VALUES              
                                                    '000' '900' '901'.  
          05 WS-DATABASE                  PIC 9(01) VALUE ZERO.         
             88 CSR-DATABASE                        VALUE 1.            
             88 SEB-DATABASE                        VALUE 2.            
          05 WS-RATE-EXIST                PIC X(01) VALUE 'Y'.          
             88 RATE-EXIST                          VALUE 'Y'.          
             88 RATE-NOT-EXIST                      VALUE 'N'.          
          05 WS-INDUS-GAS-CUST-FLAG       PIC X(01) VALUE 'N'.          
             88 INDUS-GAS-CUST                      VALUE 'Y'.          
                                                                        
       01 WS-GENERAL-VARIABLE.                                          
          05 PROGRAM-NAME                 PIC X(08) VALUE 'CSR04642'.   
A05051    05 WS-PGRMNAME                  PIC X(08) VALUE 'CSR04642'.   
          05 WS-DELINQ-CD                 PIC X(08) VALUE 'DATABASE'.   
          05 WS-REV-CLAS-CHGD-FLAG        PIC X(01) VALUE SPACES.       
          05 WS-PERSONAL-CNTCT-CD         PIC X(01) VALUE SPACES.       
          05 WS-REVENUE-CLS-DESC          PIC X(32) VALUE SPACES.       
      *   05 WS-COMMENTS                  PIC X(50) VALUE                       
      *                                   'MAINTAIN ICP DETAILS'.               
          05 WS-CURRENT-TIMESTAMP         PIC X(26) VALUE SPACES.       
          05 WS-CURRENT-DATE              PIC X(10) VALUE SPACES.       
          05 WS-ROUTE-CYCLE-CHANGE        PIC X(01) VALUE SPACES.       
          05 WS-BILL-CYCLE-CHANGE         PIC X(01) VALUE SPACES.       
          05 WS-RESP-AREA-ID              PIC X(03) VALUE SPACES.       
          05 WS-DEP-ACCT-EXIST            PIC X(01) VALUE 'N'.          
          05 WS-MST-ACCT-EXIST            PIC X(01) VALUE 'N'.          
          05 WS-SUBDVSN-LIGHT             PIC X(03) VALUE '064'.        
A05744    05 WS-SERVICE-TYPE              PIC X(01) VALUE 'P'.          
A05744    05 WS-SNSTVTY-IND               PIC X(01) VALUE 'N'.          
          05 WS-PRTY-SVC-CAT-CD           PIC X(02) VALUE SPACES.       
          05 WS-UT-IC-NO                  PIC S9(04) USAGE COMP.        
          05 WS-UTIL-SEAS-CD-NEW          PIC X(03).                    
          05 WS-UTIL-SEAS-CD-OLD          PIC X(03).                    
          05 MCSCB626                     PIC X(08) VALUE 'MCSCB626'.   
          05 WS-PRV-GROUP-NO              PIC X(02) VALUE SPACES.       
          05 WS-CHG-GROUP-NO              PIC X(02) VALUE SPACES.       
          05 WS-PRV-GROUP-DESC            PIC X(75) VALUE SPACES.       
          05 WS-CHG-GROUP-DESC            PIC X(75) VALUE SPACES.       
          05 WS-PREV-CODE-DISC-OK         PIC X(01) VALUE SPACES.       
ACT233    05 WS-CSR04675-RETURN-CODE      PIC S9(9) COMP VALUE +0.      
ACT233    05 ROUTING-CATEGORY-4675        PIC X(1) VALUE SPACES.        
ACT233    05 LOCAL-OFFICE-4675            PIC X(3) VALUE SPACES.        
          05 WS-WQ-COMMENT-LEN            PIC 9(04) VALUE 0.            
          05 WS-WQ-COMMENT-DESC           PIC X(30) VALUE SPACES.       
          05 WS-SIC-LONG-DESC             PIC X(75) VALUE SPACES.       
          05 WS-NAICS-LONG-DESC           PIC X(75) VALUE SPACES.       
          05 WS-OLD-BILL-CYC              PIC X(2).                     
          05 WS-OLD-BILL-CYC-RED REDEFINES WS-OLD-BILL-CYC.             
             10 WS-OLD-BILL-CYC-POS1      PIC X(01).                    
             10 WS-OLD-BILL-CYC-POS2      PIC X(01).                    
          05 WS-OLD-BILL-CYC-NUM REDEFINES WS-OLD-BILL-CYC PIC 99.      
          05 WS-NEW-BILL-CYC              PIC X(2).                     
          05 WS-NEW-BILL-CYC-RED REDEFINES WS-NEW-BILL-CYC.             
              10 WS-NEW-BILL-CYC-POS1     PIC X(01).                    
              10 WS-NEW-BILL-CYC-POS2     PIC X(01).                    
          05 WS-NEW-BILL-CYC-NUM REDEFINES WS-NEW-BILL-CYC PIC 99.      
          05 WS-BILL-CYC-DIFF             PIC S99.                      
A05051    05 WS-AUTO-CARD-PAY             PIC X(01) VALUE SPACES.       
A05051    05 WS-SEQ-NO-COUNT              PIC S9(4) COMP VALUE 0.       
A05051    05 WS-MESSAGE-NO                PIC 9(5)  VALUE 98004.        
A05051    05 WS-CORRESP-ID                PIC S9(13)V COMP-3 VALUE 0.   
A05051    05 WS-MESSAGE-VAR1              PIC 99    VALUE ZEROS.        
A05051    05 WS-MESSAGE-VAR1X             PIC X(5)  VALUE SPACES.       
A05051    05 WS-MESSAGE-ALPHA1            PIC X(80) VALUE SPACES.       
A05051    05 WS-MESSAGE-ALPHA1X           PIC X(7)  VALUE SPACES.       
A05051    05 WS-MESSAGE-ALPHA2            PIC X(80) VALUE SPACES.       
A05051    05 WS-MESSAGE-ALPHA2X           PIC X(4)  VALUE SPACES.       
A05051    05 WS-MESSAGE-ALPHA3            PIC X(80) VALUE SPACES.       
A05051    05 WS-MESSAGE-ALPHA3X           PIC X(5)  VALUE SPACES.       
A05051    05 WS-WQ-COMMENT-TXT1           PIC X(50) VALUE               
A05051    'ACCOUNT IS CHANGED FROM RESIDENTIAL TO COMMERCIAL '.         
A05051    05 WS-WQ-COMMENT-TXT2           PIC X(50) VALUE               
A05051    'AND NEED TO REMOVE AN ACCOUNT FROM AUTO-CARD PAY'.           
                                                                        
       01 WS-CURR-RATE-FIELD.                                           
          05 WS-CURR-APPL-PGM-ID          PIC X(08) VALUE SPACES.       
          05 WS-CURR-USER-ID              PIC X(07) VALUE SPACES.       
          05 WS-CURR-ACCOUNT-NO           PIC X(13) VALUE SPACES.       
          05 WS-CURR-PREMISE-NO           PIC X(10) VALUE SPACES.       
          05 WS-CURR-CUSTOMER-NO          PIC X(10) VALUE SPACES.       
          05 WS-CURR-COMPANY-NO           PIC X(02) VALUE SPACES.       
          05 WS-CURR-CODE-UTIL-TYPE       PIC X(01) VALUE SPACES.       
COB305    05 WS-CURR-IC-NO        PIC S9(4) COMP-3 VALUE 0.             
          05 WS-CURR-RATE-PLAN-NO         PIC X(03) VALUE SPACES.       
          05 WS-CURR-CODE-REV-CLASS       PIC X(03) VALUE SPACES.       
          05 WS-CURR-CODE-SIC-NO          PIC X(04) VALUE SPACES.       
          05 WS-CURR-NAICS-CD             PIC X(06) VALUE SPACES.       
          05 WS-CURR-SEASONAL-USE-CD      PIC X(02) VALUE SPACES.       
          05 WS-CURR-ZERO-USE-INVST-DT    PIC X(10) VALUE SPACES.       
          05 WS-CURR-READ-CYCLE           PIC X(02) VALUE SPACES.       
COB305    05 WS-CURR-READ-ROUTE        PIC S9(4) COMP-3 VALUE 0.             
          05 WS-CURR-CD-MTR-READ-FREQ     PIC X(03) VALUE SPACES.       
          05 WS-CURR-CODE-ESTIMATE-OK     PIC X(01) VALUE SPACES.       
          05 WS-CURR-PERSONAL-CNTCT-CD    PIC X(01) VALUE SPACES.       
          05 WS-CURR-ALTERNATE-FUEL-CD    PIC X(01) VALUE SPACES.       
          05 WS-CURR-PRTY-SVC-CAT-CD      PIC X(02) VALUE SPACES.       
COB305    05 WS-CURR-GAS-BASE-USE        PIC S9(9)V USAGE COMP-3 
COB305       VALUE 0.      
          05 WS-CURR-GAS-BASE-LAST-UPD    PIC X(10) VALUE SPACES.       
          05 WS-CURR-CALC-ACT-TYPE-CD     PIC X(01) VALUE SPACES.       
          05 WS-CURR-BILL-CYCLE           PIC X(02) VALUE SPACES.       
          05 WS-CURR-PRORATE-CD           PIC X(01) VALUE SPACES.       
          05 WS-CURR-DELETE-SUBDSN-FL     PIC X(01) VALUE SPACES.       
          05 WS-CURR-WQ-COMMENT           PIC X(210) VALUE SPACES.      
          05 WS-CURR-WQ-CREATE-FL         PIC X(01) VALUE SPACES.       
                                                                        
       01 WS-NULL-INDICATORS.                                           
          05 WS-NULL-IND                  PIC S9(4)  COMP VALUE -1.     
          05 WS-NOT-NULL-IND              PIC S9(4)  COMP VALUE 0.      
          05 WS-NULL-IND-01               PIC S9(04) COMP.              
          05 WS-NULL-IND-02               PIC S9(04) COMP.              
          05 WS-NULL-IND-03               PIC S9(04) COMP.              
                                                                        
       01 WS-LITERALS.                                                  
          05 WS-NO                        PIC X(01) VALUE 'N'.          
          05 WS-YES                       PIC X(01) VALUE 'Y'.          
A05051    05 WS-A                         PIC X(01) VALUE 'A'.          
A05051    05 WS-AUTOC                     PIC X(05) VALUE 'AUTOC'.      
A05051    05 WS-AUTO-CARD                 PIC X(13)                     
                                          VALUE 'AUTO_CARD_PAY'.        
          05 WS-YES-NULL                  PIC S9(04) VALUE -1.          
          05 WS-ZERO                      PIC 9(01) VALUE 0.            
          05 WS-ONE                       PIC 9(01) VALUE 1.            
          05 WS-FAILED                    PIC X(01) VALUE 'F'.          
          05 WS-ACTIVE                    PIC X(01) VALUE 'A'.          
          05 WS-ELECTRIC                  PIC X(01) VALUE 'E'.          
          05 WS-GAS                       PIC X(01) VALUE 'G'.          
          05 WS-UNMETER                   PIC X(01) VALUE 'U'.          
          05 WS-INACTIVE                  PIC X(01) VALUE 'I'.          
          05 WS-CMPNY-ACCT                PIC X(01) VALUE 'B'.          
          05 WS-NOT-CMPNY-ACCT            PIC X(01) VALUE 'A'.          
          05 WS-PENDING                   PIC X(01) VALUE 'P'.          
          05 GTT-NAME                     PIC X(26)                     
                                          VALUE 'SESSION.CSR04642_R1'.  
                                                                        
      *01  LOC1                           USAGE IS SQL TYPE IS          
      *                                   RESULT-SET-LOCATOR VARYING.   
                                                                        
       01 GTT-MISC-FIELDS.                                              
          05 GTT-ROW.                                                   
             49 GTT-ROW-LEN               PIC S9(04) COMP.              
             49 GTT-ROW-CHAR              PIC X(1024).                  
          05 GTT-SQLCODE                  PIC S9(9) COMP.               
                                                                        
       01 COUNTER-FIELDS.                                               
          05  CTR-COLUMN                  PIC S9(9) COMP VALUE 1.       
          05  CTR-ROWS                    PIC S9(9) COMP VALUE 0.       
                                                                        
       01 WORK-FIELDS.                                                  
          05  MAX-LENGTH-PARM             PIC S9(9) COMP.               
          05  WRKLEN1                     PIC S9(9) COMP.               
          05  WRKLEN2                     PIC S9(9) COMP.               
          05  WRK-DONE-STATUS             PIC S9(9) COMP.               
                                                                        
       01 GTT-RETURN-FIELDS.                                            
          05  S-RETURN-CODE               PIC S9(09) COMP VALUE 0.      
          05  S-APPL-RETURN-CODE          PIC S9(09) COMP VALUE 0.      
          05  S-BUS-RULE-ID               PIC X(10)  VALUE SPACES.      
          05  S-BUS-RULE-RESULT-CD        PIC X(08)  VALUE SPACES.      
          05  S-BUS-RULE-XREF-ID          PIC X(26)  VALUE SPACES.      
          05  S-WQ-CREATED-FLAG           PIC X(01)  VALUE 'N'.         
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9) COMP VALUE 0.         
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.           
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.           
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.           
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ACCOUNT          AT                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_BILLING_HDR      BI                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBBLLHDR                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_BILLING_DET      BG                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBBLLDET                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_USER_PROFILE     PF                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_UTIL_ENVRNMT     UT                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_BUS_RULE_XREF    1T                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRULXRF                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_BILL_CONTRACT    BK                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBBLCNTR                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_RESP_AREA        C1                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRSAREA                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_MNT_TRANS_HIST   MH                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_MT_TRN_HST_DET   MI                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_RATE_PLAN_DESC   RD                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRTDESC                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_PREMISE          PR                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_UTL_BILL_REL    UR                                     *         
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBUTLREL                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_MTRD_ENVRNMT    MN                                     *         
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMTRENV                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_DMT_PGM_ID      T2                                     *         
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBDMTPI                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_RATE_CREATOR    RT                                     *         
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRTCRTR                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_DELINQUENCY     C8                                     *         
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_INTV_USE_CLASS  IU                                               
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBINTUSE                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_CUST_PLAN       CP                                               
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCSTPLN                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_RATE_VRSN_DEF   J4                                               
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRTVRSN                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_RATE_COMP_DEF   J1                                               
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRTCDEF                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_BTU_WNA_RANGE   BR                                               
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBBTUWNA                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_JOB_PARM        G6                                               
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_CODE_VALUE      UV                                               
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCDVALU                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_REV_CLS_RATE    Q8                                               
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRVCLS                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_TRNSP_VOL_BLK   TZ                                               
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBTRNBLK                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ALTN_FUEL_TYPE  W0                                               
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBALTFUL                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_REVENUE_CLASS   F3                                               
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBREVCLS                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_WQ_ITEMS        WQ                                               
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBWQITS                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_SIC             R1                                               
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBSIC                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_SIC             Z4                                               
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBSVCCAT                                                  
           END-EXEC.                                                            
                                                                        
A05051*****************************************************************         
A05051**** CSS_ACCT_ATTRIBUTE, YP                                               
A05051*****************************************************************         
A05051     EXEC SQL                                                             
A05051         INCLUDE TBACTATT                                                 
A05051     END-EXEC.                                                            
A05051*                                                                         
A05051****************************************************************          
A05051* CSS_CORRESP_HDR - 1J                                         *          
A05051****************************************************************          
A05051*                                                                         
A05051     EXEC SQL                                                             
A05051         INCLUDE TBCORHDR                                                 
A05051     END-EXEC.                                                            
A05051*                                                                         
A05051****************************************************************          
A05051* CSS_CORRESP_VAR - 1K                                         *          
A05051****************************************************************          
A05051*                                                                         
A05051     EXEC SQL                                                             
A05051         INCLUDE TBCORVAR                                                 
A05051     END-EXEC.                                                            
A05051*                                                                         
A05051****************************************************************          
A05051* CSS_CORRESP_COMM  - 1L                                       *          
A05051****************************************************************          
A05051*                                                                         
A05051     EXEC SQL                                                             
A05051         INCLUDE TBCORCOM                                                 
A05051     END-EXEC.                                                            
A05051*                                                                         
A05051****************************************************************          
A05051* CSS_CORRESP_NOTICE- 1M                                       *          
A05051****************************************************************          
A05051*                                                                         
A05051     EXEC SQL                                                             
A05051         INCLUDE TBCORNOT                                                 
A05051     END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    SQL ERROR CHECKING COPYBOOK.                                *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    ERROR HANDLING COPY BOOK.                                   *        
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *  WORKING STORAGE COPYBOOK FOR CPD00118                        *         
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE CWS00118                                                
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *  WORKING STORAGE COPYBOOK FOR CPD00626                        *         
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE CWS00626                                                
           END-EXEC.                                                            
A05051*                                                                         
A05051*****************************************************************         
A05051*  CWS00350  - CORRESP_COMM VARIABLES                           *         
A05051*****************************************************************         
A05051                                                                  
A05051     EXEC SQL                                                             
A05051         INCLUDE CWS00350                                                 
A05051     END-EXEC.                                                            
A05051*                                                                         
A05051****************************************************************          
A05051*  COPYBOOK - WORKING STORAGE FOR CPDCA165                     *          
A05051****************************************************************          
A05051*                                                                         
A05051     COPY CWSCA165.                                                       
MSQ001        EXEC SQL
MSQ001          DECLARE C2 CURSOR
MSQ001          FOR CALL CSR04675                                       
                       ( :WQ-ITEM-ID
                  , :ROUTING-CATEGORY-4675
                  , :LOCAL-OFFICE-4675
                  , :WQ-USER-ID-ORIG
                  , :WQ-USER-ID-ASGN
                  , :WQ-RESP-AREA-ID
                  , :WQ-CATEGORY-ID
                  , :WQ-ACCOUNT-NO
                  , :WQ-PREMISE-NO
                  , :WQ-CUSTOMER-NO
                  , :WQ-SERV-ORDER-NO
                  , :WQ-COMMENTS
                  , :WQ-DATE-REQUIRED
                  , :WQ-DATE-CREATED
                  , :WQ-PRIORITY
                  , :WQ-FREE-FORM-AREA
                  , :WQ-CREATED-BY
                  )
MSQ001        END-EXEC.
     
                                                                        
      ******************************************************************        
      *  CURSOR DECLARATIONS.                                          *        
      ******************************************************************        
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-APPL-PGM-ID                PIC X(08).                   
       01  PARM-UPDT-ACTION-IND            PIC X(01).                   
       01  PARM-USERID                     PIC X(07).                   
COB305 01 PARM-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.    
       01  PARM-PREMISE-NO                 PIC X(10).                   
       01  PARM-CUSTOMER-NO                PIC X(10).                   
       01  PARM-COMPANY-NO                 PIC X(02).                   
       01  PARM-CODE-UTIL-TYPE             PIC X(01).                   
       01  PARM-IC-NO                      PIC S9(04) USAGE COMP.       
       01  PARM-RATE-PLAN-NO               PIC X(03).                   
       01  PARM-CODE-REVENUE-CLASS         PIC X(03).                   
       01  PARM-CODE-SIC-NO                PIC X(04).                   
       01  PARM-NAICS-CD                   PIC X(06).                   
       01  PARM-SEASONAL-USE-CODE          PIC X(02).                   
       01  PARM-ZERO-USE-INVEST-DT         PIC X(10).                   
       01  PARM-READ-CYCLE                 PIC X(02).                   
       01  PARM-READ-ROUTE                 PIC S9(04) USAGE COMP.       
       01  PARM-CODE-MTR-READ-FREQ         PIC X(03).                   
       01  PARM-CODE-ESTIMATE-OK           PIC X(01).                   
       01  PARM-PERSONAL-CNTCT-CD          PIC X(01).                   
       01  PARM-ALTERNATE-FUEL-CD          PIC X(01).                   
       01  PARM-PRTY-SVC-CAT-CD            PIC X(02).                   
COB305 01 PARM-GAS-BASE-USE        PIC S9(09)V USAGE COMP-3 VALUE 0.    
       01  PARM-GAS-BASE-LAST-UPDT         PIC X(10).                   
       01  PARM-CALC-ACT-TYPE-CD           PIC X(01).                   
       01  PARM-BILL-CYCLE                 PIC X(02).                   
       01  PARM-PRORATE-CD                 PIC X(01).                   
       01  PARM-DELETE-SUBDSN-FL           PIC X(01).                   
       01  PARM-WQ-COMMENT                 PIC X(210).                  
       01  PARM-WQ-CREATE-FL               PIC X(01).                   
                                                                        
       PROCEDURE DIVISION  USING PARM-APPL-PGM-ID                       
                                 PARM-UPDT-ACTION-IND                   
                                 PARM-USERID                            
                                 PARM-ACCOUNT-NO                        
                                 PARM-PREMISE-NO                        
                                 PARM-CUSTOMER-NO                       
                                 PARM-COMPANY-NO                        
                                 PARM-CODE-UTIL-TYPE                    
                                 PARM-IC-NO                             
                                 PARM-RATE-PLAN-NO                      
                                 PARM-CODE-REVENUE-CLASS                
                                 PARM-CODE-SIC-NO                       
                                 PARM-NAICS-CD                          
                                 PARM-SEASONAL-USE-CODE                 
                                 PARM-ZERO-USE-INVEST-DT                
                                 PARM-READ-CYCLE                        
                                 PARM-READ-ROUTE                        
                                 PARM-CODE-MTR-READ-FREQ                
                                 PARM-CODE-ESTIMATE-OK                  
                                 PARM-PERSONAL-CNTCT-CD                 
                                 PARM-ALTERNATE-FUEL-CD                 
                                 PARM-PRTY-SVC-CAT-CD                   
                                 PARM-GAS-BASE-USE                      
                                 PARM-GAS-BASE-LAST-UPDT                
                                 PARM-CALC-ACT-TYPE-CD                  
                                 PARM-BILL-CYCLE                        
                                 PARM-PRORATE-CD                        
                                 PARM-DELETE-SUBDSN-FL                  
                                 PARM-WQ-COMMENT                        
                                 PARM-WQ-CREATE-FL.                     
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0000-MAINLINE.                                                 *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE             THRU 0100-EXIT.          
           PERFORM 1000-PROCESS-INPUT          THRU 1000-EXIT.          
           PERFORM 2000-PROCESS-OUTPUT         THRU 2000-EXIT.          
           PERFORM 9999-END-PROGRAM            THRU 9999-EXIT.          
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           EXEC SQL                                                     
              DECLARE C1 CURSOR  FOR                         
              SELECT :S-RETURN-CODE           AS RETURN_CODE            
                    ,:S-APPL-RETURN-CODE      AS APPL_RETURN_CODE       
                    ,:S-BUS-RULE-ID           AS BUS_RULE_ID            
                    ,:S-BUS-RULE-RESULT-CD    AS BUS_RULE_RESULT_CD     
                    ,:S-BUS-RULE-XREF-ID      AS BUS_RULE_XREF_ID       
                    ,:S-WQ-CREATED-FLAG       AS WQ_CREATED_FLAG        
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN FOR                                 
MFA-TR*       SELECT :S-RETURN-CODE           AS RETURN_CODE                    
MFA-TR*             ,:S-APPL-RETURN-CODE      AS APPL_RETURN_CODE               
MFA-TR*             ,:S-BUS-RULE-ID           AS BUS_RULE_ID                    
MFA-TR*             ,:S-BUS-RULE-RESULT-CD    AS BUS_RULE_RESULT_CD             
MFA-TR*             ,:S-BUS-RULE-XREF-ID      AS BUS_RULE_XREF_ID               
MFA-TR*             ,:S-WQ-CREATED-FLAG       AS WQ_CREATED_FLAG                
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-APPL-PGM-ID            TO WS-CURR-APPL-PGM-ID      
           MOVE PARM-UPDT-ACTION-IND        TO WS-CURR-UPDT-ACTION-IND  
           MOVE PARM-USERID                 TO WS-CURR-USER-ID          
           MOVE PARM-ACCOUNT-NO             TO WS-CURR-ACCOUNT-NO       
           MOVE PARM-PREMISE-NO             TO WS-CURR-PREMISE-NO       
           MOVE PARM-CUSTOMER-NO            TO WS-CURR-CUSTOMER-NO      
           MOVE PARM-COMPANY-NO             TO WS-CURR-COMPANY-NO       
           MOVE PARM-CODE-UTIL-TYPE         TO WS-CURR-CODE-UTIL-TYPE   
           MOVE PARM-IC-NO                  TO WS-CURR-IC-NO            
           MOVE PARM-RATE-PLAN-NO           TO WS-CURR-RATE-PLAN-NO     
           MOVE PARM-CODE-REVENUE-CLASS     TO WS-CURR-CODE-REV-CLASS   
           MOVE PARM-CODE-SIC-NO            TO WS-CURR-CODE-SIC-NO      
           MOVE PARM-NAICS-CD               TO WS-CURR-NAICS-CD         
           MOVE PARM-SEASONAL-USE-CODE      TO WS-CURR-SEASONAL-USE-CD  
           MOVE PARM-ZERO-USE-INVEST-DT     TO WS-CURR-ZERO-USE-INVST-DT
           MOVE PARM-READ-CYCLE             TO WS-CURR-READ-CYCLE       
           MOVE PARM-READ-ROUTE             TO WS-CURR-READ-ROUTE       
           MOVE PARM-CODE-MTR-READ-FREQ     TO WS-CURR-CD-MTR-READ-FREQ 
           MOVE PARM-CODE-ESTIMATE-OK       TO WS-CURR-CODE-ESTIMATE-OK 
           MOVE PARM-PERSONAL-CNTCT-CD      TO WS-CURR-PERSONAL-CNTCT-CD
           MOVE PARM-ALTERNATE-FUEL-CD      TO WS-CURR-ALTERNATE-FUEL-CD
           MOVE PARM-PRTY-SVC-CAT-CD        TO WS-CURR-PRTY-SVC-CAT-CD  
           MOVE PARM-GAS-BASE-USE           TO WS-CURR-GAS-BASE-USE     
           MOVE PARM-GAS-BASE-LAST-UPDT     TO WS-CURR-GAS-BASE-LAST-UPD
           MOVE PARM-CALC-ACT-TYPE-CD       TO WS-CURR-CALC-ACT-TYPE-CD 
           MOVE PARM-BILL-CYCLE             TO WS-CURR-BILL-CYCLE       
           MOVE PARM-PRORATE-CD             TO WS-CURR-PRORATE-CD       
           MOVE PARM-DELETE-SUBDSN-FL       TO WS-CURR-DELETE-SUBDSN-FL 
           MOVE PARM-WQ-COMMENT             TO WS-CURR-WQ-COMMENT       
           MOVE PARM-WQ-CREATE-FL           TO WS-CURR-WQ-CREATE-FL.    
                                                                        
      *    GET THE DATABASE.                                                    
           MOVE WS-DELINQ-CD                TO C8-DELINQ-CD.            
           MOVE WS-CURR-COMPANY-NO          TO C8-COMPANY-NO.           
           PERFORM 7000-GET-DELINQ-VALUE       THRU 7000-EXIT.          
           MOVE C8-DELINQ-VALUE             TO WS-DATABASE.             
                                                                        
      *    VALIDATE THE REV-CLASS AND RATE-CODE COMBINATIONS                    
      *    FOR SEB ACCOUNTS ALONE.                                              
           PERFORM 1100-VALIDATE-INPUT         THRU 1100-EXIT.          
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 1100-VALIDATE-INPUT.                                           *        
      ******************************************************************        
       1100-VALIDATE-INPUT.                                             
                                                                        
           IF (RATE-INSERT OR RATE-UPDATE) AND SEB-DATABASE             
                                                                        
              MOVE WS-CURR-RATE-PLAN-NO        TO Q8-RATE-PLAN-NO       
              MOVE WS-CURR-CODE-REV-CLASS      TO Q8-CODE-REVENUE-CLASS 
              MOVE WS-CURR-CODE-UTIL-TYPE      TO Q8-CODE-UTIL-TYPE     
              MOVE WS-CURR-COMPANY-NO          TO Q8-COMPANY-NO         
              PERFORM 7005-VALDAT-REV-CLS-RATE    THRU 7005-EXIT        
                                                                        
      *       ERR:ACCOUNT SUB TYPE DOES NOT MATCH WITH SELECTED REVENUE         
      *       PLEASE SELECT A REVENUE CLASS OR CLICK RATE SELECTION             
      *       TO CHANGE RESPECTIVE OPTION.                                      
              IF REV-CLS-NOT-EXISTS                                     
                 MOVE 'MRM0000148'             TO S-BUS-RULE-ID         
                 MOVE WS-FAILED                TO S-BUS-RULE-RESULT-CD  
                 IF S-BUS-RULE-ID GREATER THAN SPACES                   
                    PERFORM 7010-GET-RULE-XREF-ID THRU 7010-EXIT        
                 END-IF                                                 
                 MOVE WS-ZERO                  TO S-APPL-RETURN-CODE    
                 PERFORM 8005-SEND-RESULT         THRU 8005-EXIT        
                 PERFORM 9999-END-PROGRAM         THRU 9999-EXIT        
              END-IF                                                    
           END-IF.                                                      
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           EVALUATE TRUE                                                
              WHEN RATE-INSERT                                          
                   PERFORM 2100-INSRT-PRCS-FOR-RATE   THRU 2100-EXIT    
              WHEN RATE-UPDATE                                          
                   PERFORM 2200-UPDT-PRCS-FOR-RATE    THRU 2200-EXIT    
              WHEN RATE-DELETE                                          
                   PERFORM 2300-DEL-PRCS-FOR-RATE     THRU 2300-EXIT    
           END-EVALUATE                                                 
                                                                        
      *    IF THE RATES OR REVENUE CLASSES HAVE CHANGED, THEN                   
      *    RE-COMPUTE THE ACCOUNT TYPE CODE FOR THE ACCOUNT.                    
           IF WS-CURR-CALC-ACT-TYPE-CD EQUAL WS-YES OR RATE-DELETE      
              PERFORM 2400-DETERMINE-ACCT-TYPE-CODE   THRU 2400-EXIT    
           END-IF.                                                      
                                                                        
           PERFORM 8005-SEND-RESULT                   THRU 8005-EXIT.   
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2100-INSRT-PRCS-FOR-RATE.                                      *        
      ******************************************************************        
       2100-INSRT-PRCS-FOR-RATE.                                        
                                                                        
           MOVE WS-CURR-CODE-UTIL-TYPE      TO BR-CODE-UTIL-TYPE        
                                               RD-CODE-UTIL-TYPE.       
           MOVE WS-CURR-RATE-PLAN-NO        TO BR-RATE-PLAN-NO          
                                               RD-RATE-PLAN-NO.         
      *                                                                         
           PERFORM 2410-SET-MTRD-UNMTRD-FLAG   THRU 2410-EXIT.          
                                                                        
      *    MAIN INSERT PROCESS FOR RATE.                                        
A05065     PERFORM 7020-GET-CURR-TIMESTAMP     THRU 7020-EXIT.          
           PERFORM 2105-PROCESS-INSERT-RATE    THRU 2105-EXIT.          
                                                                        
      *    WRITE TRANSACTION HISTORY SUMMARY.                                   
           PERFORM 5100-WRITE-TRANS-HIST-SUMM  THRU 5100-EXIT.          
                                                                        
      *    WRITE TRANSACTION HISTORY DETAILS.                                   
           PERFORM 5200-WRITE-TRANS-HIST-DET   THRU 5200-EXIT.          
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2105-PROCESS-INSERT-RATE.                                     *         
      ******************************************************************        
       2105-PROCESS-INSERT-RATE.                                        
                                                                        
           MOVE WS-CURR-ACCOUNT-NO          TO UT-ACCOUNT-NO            
                                               AT-ACCOUNT-NO.           
           MOVE WS-CURR-CODE-UTIL-TYPE      TO UT-CODE-UTIL-TYPE.       
           MOVE WS-CURRENT-DATE             TO AT-DATE-LAST-ACTION.     
           MOVE WS-CURR-PREMISE-NO          TO PR-PREMISE-NO.           
           MOVE WS-CURR-PERSONAL-CNTCT-CD   TO PR-PERSONAL-CNTCT-CD.    
                                                                        
      *    GET MAXIMUM IC NUMBER.                                               
           PERFORM 7055-GET-MAX-IC-NO          THRU 7055-EXIT.          
                                                                        
      *    FORMAT ALL INPUT VALUES.                                             
           PERFORM 2110-FORMAT-INPUT-VALUES    THRU 2110-EXIT.          
                                                                        
           PERFORM 8100-INSERT-UTIL-ENVRNMT    THRU 8100-EXIT.          
           PERFORM 8150-UPD-DT-LAST-ACTN-AT    THRU 8150-EXIT.          
           PERFORM 7060-GET-AVALIABLE-IND      THRU 7060-EXIT.          
                                                                        
           EVALUATE WS-CURR-CODE-UTIL-TYPE                              
               WHEN WS-ELECTRIC                                         
                    IF PR-ELEC-AVAILABLE-IND NOT EQUAL WS-ACTIVE        
                       PERFORM 8160-UPD-PREMISE-ELEC THRU 8160-EXIT     
                    END-IF                                              
               WHEN WS-GAS                                              
                    IF PR-GAS-AVAILABLE-IND NOT EQUAL  WS-ACTIVE        
                       PERFORM 8170-UPD-PREMISE-GAS  THRU 8170-EXIT     
                    END-IF                                              
               WHEN WS-UNMETER                                          
                    IF PR-LITE-AVAILABLE-IND NOT EQUAL WS-ACTIVE        
                       PERFORM 8180-UPD-PREMISE-LITE THRU 8180-EXIT     
                    END-IF                                              
           END-EVALUATE.                                                
                                                                        
       2105-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2110-FORMAT-INPUT-VALUES.                                     *         
      ******************************************************************        
       2110-FORMAT-INPUT-VALUES.                                        
                                                                        
           MOVE WS-CURR-PREMISE-NO          TO UT-PREMISE-NO.           
           MOVE WS-CURR-CODE-UTIL-TYPE      TO UT-CODE-UTIL-TYPE.       
           MOVE WS-CURR-CODE-ESTIMATE-OK    TO UT-CODE-ESTIMATE-OK.     
           MOVE ZERO                        TO UT-CODE-CURTAIL-PRTY.    
           MOVE WS-CURR-CODE-REV-CLASS      TO UT-CODE-REVENUE-CLASS.   
           MOVE SPACES                      TO UT-CODE-SERVICE-TYPE.    
           MOVE SPACES                      TO UT-DATE-LST-NRML-BILL.   
           MOVE WS-CURR-RATE-PLAN-NO        TO UT-RATE-PLAN-NO.         
           MOVE WS-ZERO                     TO UT-END-USER-PER-RATE.    
           MOVE SPACES                      TO UT-DATE-INSTALL.         
           MOVE WS-CURR-READ-CYCLE          TO UT-READ-CYCLE.           
           MOVE WS-CURR-READ-ROUTE          TO UT-READ-ROUTE.           
           MOVE WS-CURR-CD-MTR-READ-FREQ    TO UT-CODE-MTR-READ-FREQ.   
           MOVE WS-CURR-CODE-SIC-NO         TO UT-CODE-SIC-NO.          
           MOVE WS-CURR-NAICS-CD            TO UT-NAICS-CD.             
           MOVE SPACES                      TO UT-ENERGY-SOURCE.        
           MOVE SPACES                      TO UT-SPLY-SENSITIVE-IND.   
           MOVE WS-CURR-SEASONAL-USE-CD     TO UT-SEASONAL-USE-CODE.    
           MOVE WS-CURR-COMPANY-NO          TO UT-COMPANY-NO.           
           MOVE SPACES                      TO UT-PRV-RATE-PLAN-NO.     
           MOVE SPACES                      TO UT-CODE-STAT-TAX-XMT.    
           MOVE SPACES                      TO UT-CODE-CITY-TAX-XMT     
           MOVE SPACES                      TO UT-CODE-OTHR-TAX-XMT.    
           MOVE SPACES                      TO UT-CODE-XCIS-TAX-XMT.    
           MOVE SPACES                      TO UT-STATE-TAX-EXMPT-NO.   
           MOVE ZERO                        TO UT-TOU-RATE-IND.         
           MOVE ZERO                        TO UT-GAS-PREV-BASE-USE.    
           MOVE WS-CURR-GAS-BASE-USE        TO UT-GAS-BASE-USE.         
           MOVE WS-CURRENT-TIMESTAMP        TO UT-LAST-UPDATE-TS.       
                                                                        
           IF WS-CURR-APPL-PGM-ID ='CSR04547'                           
              MOVE WS-SERVICE-TYPE TO UT-CODE-SERVICE-TYPE              
              MOVE WS-SNSTVTY-IND  TO UT-SPLY-SENSITIVE-IND             
           END-IF.                                                      
                                                                        
           IF WS-CURR-GAS-BASE-LAST-UPD GREATER THAN SPACES             
              MOVE WS-CURR-GAS-BASE-LAST-UPD                            
                                            TO UT-GAS-BASE-LAST-UPDT    
           ELSE                                                         
              MOVE WS-YES-NULL              TO WS-NULL-IND-02           
           END-IF.                                                      
                                                                        
           IF WS-CURR-ZERO-USE-INVST-DT GREATER THAN SPACES             
              MOVE WS-CURR-ZERO-USE-INVST-DT                            
                                            TO UT-ZERO-USE-INVEST-DT    
           ELSE                                                         
              MOVE WS-YES-NULL              TO WS-NULL-IND-01           
           END-IF.                                                      
                                                                        
           IF WS-CURR-ALTERNATE-FUEL-CD EQUAL WS-NO                     
              MOVE SPACES                   TO UT-ALTERNATE-FUEL-CD     
           ELSE                                                         
              MOVE WS-CURR-ALTERNATE-FUEL-CD                            
                                            TO UT-ALTERNATE-FUEL-CD     
           END-IF.                                                      
                                                                        
           IF WS-CURR-PRTY-SVC-CAT-CD GREATER THAN SPACES               
              MOVE WS-CURR-PRTY-SVC-CAT-CD  TO Z4-PRTY-SVC-CAT-CD       
              MOVE WS-CURR-COMPANY-NO       TO Z4-COMPANY-NO            
              PERFORM 7080-GET-CURTAIL-PRTY    THRU 7080-EXIT           
              MOVE Z4-CODE-CURTAIL-PRTY     TO UT-CODE-CURTAIL-PRTY     
           ELSE                                                         
              PERFORM 7085-CHK-INDUS-GAS-CUST  THRU 7085-EXIT           
              IF INDUS-GAS-CUST                                         
                 MOVE 'MRM0000087'             TO S-BUS-RULE-ID         
                 MOVE WS-FAILED                TO S-BUS-RULE-RESULT-CD  
                 IF S-BUS-RULE-ID GREATER THAN SPACES                   
                    PERFORM 7010-GET-RULE-XREF-ID THRU 7010-EXIT        
                 END-IF                                                 
                 MOVE WS-ZERO                  TO S-APPL-RETURN-CODE    
                 PERFORM 8005-SEND-RESULT         THRU 8005-EXIT        
                 PERFORM 9999-END-PROGRAM         THRU 9999-EXIT        
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      *  2200-UPDT-PRCS-FOR-RATE.                                      *        
      ******************************************************************        
       2200-UPDT-PRCS-FOR-RATE.                                         
                                                                        
           MOVE WS-CURR-CODE-UTIL-TYPE      TO RD-CODE-UTIL-TYPE.       
           MOVE WS-CURR-RATE-PLAN-NO        TO RD-RATE-PLAN-NO.         
      *                                                                         
           PERFORM 2410-SET-MTRD-UNMTRD-FLAG   THRU 2410-EXIT.          
                                                                        
      *    VALIDATE NEW RATE PLAN NO WHEN RATE OR REV CLASS CHANGE.             
           IF WS-CURR-CALC-ACT-TYPE-CD EQUAL WS-YES                     
              AND (WS-CURR-CODE-UTIL-TYPE EQUAL WS-ELECTRIC OR WS-GAS)  
              PERFORM 2202-VLDT-CURR-RATE      THRU 2202-EXIT           
           END-IF                                                       
      *                                                                         
      *    GET ALL PREVIOUS VALUES.                                             
           PERFORM 2205-GET-PREV-VALUES        THRU 2205-EXIT.          
                                                                        
      *    INSERT A BILL MESSAGE WHEN RATE CHANGE FOR PSNC.                     
           IF UT-RATE-PLAN-NO NOT = WS-CURR-RATE-PLAN-NO                
              PERFORM 2210-BILL-MSG-INSERT     THRU 2210-EXIT           
           END-IF.                                                      
                                                                        
      *    CREATE A WQ WHEN RATE OR REV CLASS CHANGE.                           
      *    IF WS-CURR-WQ-CREATE-FL EQUAL WS-YES                                 
           PERFORM 2220-CREATE-TRANS-CMNT     THRU 2220-EXIT            
      *    END-IF.                                                              
                                                                        
      *    WRITE A TRANSACTION HISTORY SUMMARY.                                 
           PERFORM 5100-WRITE-TRANS-HIST-SUMM THRU 5100-EXIT.           
                                                                        
      *    WRITE A TRANSACTION HISTORY DETAILS.                                 
           PERFORM 5200-WRITE-TRANS-HIST-DET  THRU 5200-EXIT.           
                                                                        
      *    MAIN UPDATE PROCESS.                                                 
           PERFORM 2230-PROCESS-UPDATE-RATE   THRU 2230-EXIT.           
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2202-VLDT-CURR-RATE.                                           *        
      ******************************************************************        
       2202-VLDT-CURR-RATE.                                             
                                                                        
           MOVE WS-CURR-ACCOUNT-NO       TO MN-ACCOUNT-NO.              
           MOVE WS-CURR-CODE-UTIL-TYPE   TO MN-CODE-UTIL-TYPE.          
           MOVE WS-CURR-IC-NO            TO MN-IC-NO.                   
           MOVE WS-YES                   TO WS-RATE-EXIST.              
                                                                        
           PERFORM 7065-GET-MTRD-ENVRNMT-DET THRU 7065-EXIT             
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE WS-CURR-RATE-PLAN-NO  TO T2-RATE-PLAN-NO             
              MOVE WS-CURR-CODE-UTIL-TYPE                               
                                         TO T2-CODE-UTIL-TYPE           
              MOVE MN-DIGTL-MTR-TYPE     TO T2-DIGTL-MTR-TYPE           
              MOVE MN-PROGRAM-ID         TO T2-PROGRAM-ID               
              PERFORM 7070-VLDT-DMT-PGM-ID  THRU 7070-EXIT              
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE WS-NO              TO WS-RATE-EXIST               
              END-IF                                                    
           END-IF.                                                      
                                                                        
      *    ERR:NEW RATE IS NOT SUPPORTED BY METERS INSTALLED.                   
           IF RATE-NOT-EXIST                                            
              MOVE 'MRM0000065'          TO S-BUS-RULE-ID               
              MOVE WS-FAILED             TO S-BUS-RULE-RESULT-CD        
              IF S-BUS-RULE-ID GREATER THAN SPACES                      
                 PERFORM 7010-GET-RULE-XREF-ID THRU 7010-EXIT           
              END-IF                                                    
              MOVE WS-ZERO               TO S-APPL-RETURN-CODE          
              PERFORM 8005-SEND-RESULT      THRU 8005-EXIT              
              PERFORM 9999-END-PROGRAM      THRU 9999-EXIT              
           END-IF.                                                      
                                                                        
       2202-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2205-GET-PREV-VALUES.                                          *        
      ******************************************************************        
       2205-GET-PREV-VALUES.                                            
                                                                        
           MOVE WS-CURR-ACCOUNT-NO          TO UT-ACCOUNT-NO            
                                               AT-ACCOUNT-NO            
                                               BG-ACCOUNT-NO.           
                                                                        
           MOVE WS-CURR-CODE-UTIL-TYPE      TO UT-CODE-UTIL-TYPE        
                                               BR-CODE-UTIL-TYPE.       
                                                                        
           MOVE WS-CURR-IC-NO               TO UT-IC-NO.                
           MOVE WS-CURR-RATE-PLAN-NO        TO BR-RATE-PLAN-NO.         
                                                                        
           PERFORM 7100-SELECT-UTIL-ENVRNMT    THRU 7100-EXIT.          
           MOVE WS-CURR-PREMISE-NO          TO PR-PREMISE-NO.           
           PERFORM 7102-SELECT-PREMISE         THRU 7102-EXIT.          
           PERFORM 7105-SELECT-ACCOUNT-DET     THRU 7105-EXIT.          
           MOVE AT-BILL-CYCLE               TO WS-OLD-BILL-CYC.         
           MOVE AT-CODE-DISC-OK             TO WS-PREV-CODE-DISC-OK.    
                                                                        
           MOVE UT-CODE-CURTAIL-PRTY        TO Z4-CODE-CURTAIL-PRTY.    
           MOVE WS-CURR-COMPANY-NO          TO Z4-COMPANY-NO.           
           MOVE SPACES                      TO Z4-PRTY-SVC-CAT-CD.      
           IF Z4-CODE-CURTAIL-PRTY GREATER THAN WS-ZERO                 
              PERFORM 7090-GET-PRTY-SVC-CAT    THRU 7090-EXIT           
           END-IF.                                                      
                                                                        
       2205-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2210-BILL-MSG-INSERT.                                          *        
      ******************************************************************        
       2210-BILL-MSG-INSERT.                                            
                                                                        
           MOVE PROGRAM-NAME                TO G6-PROGRAM-NAME          
           MOVE 'OPTN'                      TO G6-CMND-CODE             
           MOVE WS-CURR-COMPANY-NO          TO G6-COMPANY-NO            
           MOVE WS-ONE                      TO G6-SEQ-NO                
                                                                        
           PERFORM 7125-SELECT-JOB-PARM        THRU 7125-EXIT           
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
A05051        PERFORM 5025-INSERT-BILL-MSGS    THRU 5025-EXIT           
           END-IF.                                                      
                                                                        
       2210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2220-CREATE-TRANS-CMNT                                         *        
      ******************************************************************        
       2220-CREATE-TRANS-CMNT.                                          
                                                                        
      *    CATEGORY 524 AND 525 WQ NOT REQUIRED IN CIS MOD                      
      *    PERFORM 5050-CREATE-QA-WQ       THRU 5050-EXIT.                      
                                                                        
      *    UNSTRING WS-CURR-WQ-COMMENT DELIMITED BY ':'                         
      *        INTO WS-WQ-COMMENT-DESC                                          
      *             WS-CURR-WQ-COMMENT                                          
      *    END-UNSTRING                                                         
                                                                        
      *    INSPECT FUNCTION REVERSE(WS-CURR-WQ-COMMENT)                         
      *            TALLYING WS-WQ-COMMENT-LEN FOR LEADING SPACES                
      *                                                                         
      *    COMPUTE WS-WQ-COMMENT-LEN =                                          
      *              LENGTH OF WS-CURR-WQ-COMMENT - WS-WQ-COMMENT-LEN           
      *                                                                         
      *    STRING WS-COMMENTS           DELIMITED BY '   '                      
      *           ' - '                 DELIMITED BY SIZE                       
      *           WS-CURR-WQ-COMMENT    DELIMITED BY SIZE                       
      *      INTO MH-TRAN-COMMENT-TEXT                                          
      *    END-STRING                                                           
                                                                        
      *    COMPUTE MH-TRAN-COMMENT-LEN =                                        
      *              MH-TRAN-COMMENT-LEN + WS-WQ-COMMENT-LEN + 3.               
           MOVE WS-CURR-WQ-COMMENT          TO MH-TRAN-COMMENT-TEXT.    
                                                                        
           MOVE LENGTH OF MH-TRAN-COMMENT-TEXT                          
                                            TO MH-TRAN-COMMENT-LEN.     
                                                                        
       2220-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2230-PROCESS-UPDATE-RATE.                                      *        
      ******************************************************************        
       2230-PROCESS-UPDATE-RATE.                                        
                                                                        
           MOVE WS-CURR-ACCOUNT-NO          TO UT-ACCOUNT-NO            
                                               BK-ACCOUNT-NO            
                                               BG-ACCOUNT-NO            
                                               BI-ACCOUNT-NO            
                                               MN-ACCOUNT-NO            
                                               AT-ACCOUNT-NO            
                                               TZ-ACCOUNT-NO.           
                                                                        
           MOVE WS-CURR-CODE-UTIL-TYPE      TO UT-CODE-UTIL-TYPE        
                                               BK-CODE-UTIL-TYPE        
                                               MN-CODE-UTIL-TYPE        
                                               BG-CODE-UTIL-TYPE.       
                                                                        
           MOVE WS-CURR-IC-NO               TO UT-IC-NO                 
                                               BK-IC-NO                 
                                               MN-IC-NO                 
                                               BG-IC-NO.                
                                                                        
           MOVE WS-CURRENT-DATE             TO AT-DATE-LAST-ACTION.     
           MOVE WS-CURR-CODE-ESTIMATE-OK    TO UT-CODE-ESTIMATE-OK.     
           MOVE WS-CURR-CODE-REV-CLASS      TO UT-CODE-REVENUE-CLASS    
                                               BG-CODE-REVENUE-CLASS.   
                                                                        
           MOVE WS-CURR-RATE-PLAN-NO        TO UT-RATE-PLAN-NO          
                                               BG-RATE-PLAN-NO.         
                                                                        
           MOVE WS-CURR-READ-CYCLE          TO UT-READ-CYCLE.           
           MOVE WS-CURR-READ-ROUTE          TO UT-READ-ROUTE.           
           MOVE WS-CURR-CD-MTR-READ-FREQ    TO UT-CODE-MTR-READ-FREQ.   
           MOVE WS-CURR-CODE-SIC-NO         TO UT-CODE-SIC-NO           
                                               BG-CODE-SIC-NO.          
                                                                        
           MOVE WS-CURR-NAICS-CD            TO UT-NAICS-CD              
                                               BG-NAICS-CD.             
                                                                        
           MOVE WS-CURR-SEASONAL-USE-CD     TO UT-SEASONAL-USE-CODE.    
           MOVE WS-CURR-GAS-BASE-USE        TO UT-GAS-BASE-USE          
                                               BG-GAS-BASE-USE.         
                                                                        
           MOVE WS-CURRENT-TIMESTAMP        TO UT-LAST-UPDATE-TS.       
                                                                        
           IF WS-CURR-ZERO-USE-INVST-DT GREATER THAN SPACES             
              MOVE WS-CURR-ZERO-USE-INVST-DT                            
                                            TO UT-ZERO-USE-INVEST-DT    
              MOVE WS-ZERO                  TO WS-NULL-IND-01           
           ELSE                                                         
              MOVE WS-YES-NULL              TO WS-NULL-IND-01           
           END-IF.                                                      
                                                                        
           IF WS-CURR-GAS-BASE-LAST-UPD GREATER THAN SPACES             
              MOVE WS-CURR-GAS-BASE-LAST-UPD                            
                                            TO UT-GAS-BASE-LAST-UPDT    
              MOVE WS-ZERO                  TO WS-NULL-IND-02           
           ELSE                                                         
              MOVE WS-YES-NULL              TO WS-NULL-IND-02           
           END-IF.                                                      
                                                                        
           IF WS-CURR-ALTERNATE-FUEL-CD EQUAL WS-NO                     
              MOVE SPACES                   TO UT-ALTERNATE-FUEL-CD     
                                               BG-ALTERNATE-FUEL-CD     
           ELSE                                                         
              MOVE WS-CURR-ALTERNATE-FUEL-CD TO UT-ALTERNATE-FUEL-CD    
                                                BG-ALTERNATE-FUEL-CD    
           END-IF.                                                      
                                                                        
ACT365     MOVE WS-ZERO                     TO UT-CODE-CURTAIL-PRTY     
ACT365                                         BG-CODE-CURTAIL-PRTY.    
           IF WS-CURR-PRTY-SVC-CAT-CD GREATER THAN SPACES               
              MOVE WS-CURR-PRTY-SVC-CAT-CD  TO Z4-PRTY-SVC-CAT-CD       
              MOVE WS-CURR-COMPANY-NO       TO Z4-COMPANY-NO            
              PERFORM 7080-GET-CURTAIL-PRTY    THRU 7080-EXIT           
              MOVE Z4-CODE-CURTAIL-PRTY     TO UT-CODE-CURTAIL-PRTY     
ACT365                                         BG-CODE-CURTAIL-PRTY     
           ELSE                                                         
              PERFORM 7085-CHK-INDUS-GAS-CUST  THRU 7085-EXIT           
              IF INDUS-GAS-CUST                                         
                 MOVE 'MRM0000087'             TO S-BUS-RULE-ID         
                 MOVE WS-FAILED                TO S-BUS-RULE-RESULT-CD  
                 IF S-BUS-RULE-ID GREATER THAN SPACES                   
                    PERFORM 7010-GET-RULE-XREF-ID THRU 7010-EXIT        
                 END-IF                                                 
                 MOVE WS-ZERO                  TO S-APPL-RETURN-CODE    
                 PERFORM 8005-SEND-RESULT         THRU 8005-EXIT        
                 PERFORM 9999-END-PROGRAM         THRU 9999-EXIT        
              END-IF                                                    
           END-IF.                                                      
                                                                        
      *    UPDATE CSS_UTIL_ENVRNMT TABLE WITH NEW FIELD.                        
           PERFORM 8200-UPDATE-UTIL-ENVRNMT    THRU 8200-EXIT.          
           PERFORM 8150-UPD-DT-LAST-ACTN-AT    THRU 8150-EXIT.          
                                                                        
      *    UPDATE PRORATE CODE IN CSS_BILLING_DET TABLE WHEN                    
      *    BILL CYCLE CHANGE.                                                   
           IF WS-BILL-CYCLE-CHANGE EQUAL WS-YES                         
              MOVE WS-CURR-BILL-CYCLE       TO AT-BILL-CYCLE            
              MOVE WS-CURR-PRORATE-CD       TO BG-PRORATE-CD            
              PERFORM 8230-UPDATE-PRORATE-CD   THRU 8230-EXIT           
           END-IF.                                                      
                                                                        
      *    UPDATE CSS_BILLING_DET WITH NEW FIELD FROM RATE SCREEN.              
           PERFORM 8240-UPDATE-BILLING-DET     THRU 8240-EXIT.          
                                                                        
      *    CIG ACCT: IF CODE REV CLASS CHANGES,REVERT BACK TRANSPORATION        
      *    TRANSPORATION FUTURE HOOK CODE REV CLASS                             
      *    WITH TRNSP_VOL_BLK VALUE.                                            
           IF BG-CODE-UTIL-TYPE EQUAL WS-GAS                            
              AND WS-REV-CLAS-CHGD-FLAG EQUAL WS-YES                    
              MOVE WS-NO                    TO WS-CIG-RATE-STAT         
              MOVE BG-RATE-PLAN-NO          TO J1-RATE-PLAN-NO          
              PERFORM 7130-CHECK-FOR-CIG-RATE  THRU 7130-EXIT           
              IF CIG-RATE                                               
                 PERFORM 7140-GET-TRNSP-CD-REV-CLASS                    
                                               THRU 7140-EXIT           
                 IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL         
                    MOVE TZ-CODE-REVENUE-CLASS  TO BG-CODE-REVENUE-CLASS
                    PERFORM 8250-UPDATE-BG-TRANSPORTATION               
                                               THRU 8250-EXIT           
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
      *    UDPT READ ROUTE AND READ CYCLE WHEN ROUTE OR BILL CYCLE CHNG.        
           IF (WS-ROUTE-CYCLE-CHANGE = WS-YES OR                        
               WS-BILL-CYCLE-CHANGE  = WS-YES)                          
              PERFORM 2240-CHECK-DISC          THRU 2240-EXIT           
              PERFORM 8260-UPDATE-ACCOUNT-DTLS THRU 8260-EXIT           
      *       DISCONNECT EXEMPTION - WRITING INTO TRANS HISTORY TABLE.          
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                 PERFORM 5300-WRITE-TRANS-DISC-OK                       
                                               THRU 5300-EXIT           
              END-IF                                                    
                                                                        
      *       UPDATE READ ROUTE AND READ CYCLE.                                 
              PERFORM 8270-UPDATE-READ-DETAILS THRU 8270-EXIT           
              PERFORM 7150-SELECT-MTR-SEQ      THRU 7150-EXIT           
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                 MOVE WS-ZERO               TO MN-REGISTER-RD-SEQ       
                 PERFORM 8280-UPDATE-MTR-SEQ   THRU 8280-EXIT           
              END-IF                                                    
           END-IF.                                                      
                                                                        
      *    UPDATE PREMISE RECORD.                                               
           MOVE WS-CURR-PREMISE-NO          TO PR-PREMISE-NO.           
           MOVE WS-CURR-PERSONAL-CNTCT-CD   TO PR-PERSONAL-CNTCT-CD.    
           PERFORM 8290-UPDATE-PREMISE         THRU 8290-EXIT.          
                                                                        
       2230-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                         
      * 2240-CHECK-DISC.                                                        
      ******************************************************************        
       2240-CHECK-DISC.                                                 
                                                                        
            IF AT-CODE-DISC-OK GREATER THAN SPACES                      
               CONTINUE                                                 
            ELSE                                                        
               IF SEB-DATABASE                                          
                  IF AT-CODE-ACCT-STAT EQUAL WS-PENDING                 
                     CONTINUE                                           
                  ELSE                                                  
                     MOVE WS-CURR-READ-CYCLE TO WS-NEW-BILL-CYC         
                     IF WS-NEW-BILL-CYC-POS1 EQUAL SPACES               
                        MOVE WS-ZERO         TO WS-NEW-BILL-CYC-POS1    
                     END-IF                                             
                     IF WS-NEW-BILL-CYC-POS2 EQUAL SPACES               
                        MOVE WS-NEW-BILL-CYC-POS1 TO                    
                             WS-NEW-BILL-CYC-POS2                       
                        MOVE WS-ZERO         TO WS-NEW-BILL-CYC-POS1    
                     END-IF                                             
                                                                        
                     IF WS-OLD-BILL-CYC-POS1 EQUAL SPACES               
                        MOVE WS-ZERO         TO WS-OLD-BILL-CYC-POS1    
                     END-IF                                             
                     IF WS-OLD-BILL-CYC-POS2 EQUAL SPACES               
                        MOVE WS-OLD-BILL-CYC-POS1 TO                    
                             WS-OLD-BILL-CYC-POS2                       
                        MOVE WS-ZERO         TO WS-OLD-BILL-CYC-POS1    
                     END-IF                                             
                                                                        
                     COMPUTE WS-BILL-CYC-DIFF = WS-NEW-BILL-CYC-NUM -   
                                                WS-OLD-BILL-CYC-NUM     
                                                                        
                     IF (WS-BILL-CYC-DIFF > 0 AND WS-BILL-CYC-DIFF < 6) 
                         CONTINUE                                       
                     ELSE                                               
                          MOVE WS-ONE        TO AT-CODE-DISC-OK         
                     END-IF                                             
                  END-IF                                                
               ELSE                                                     
      *           DO NOT FORECAST A DISCONNECT FOR REST OF BILLING              
      *           MONTH OR NEXT MONTH                                           
                  MOVE WS-ONE               TO AT-CODE-DISC-OK          
               END-IF                                                   
            END-IF.                                                     
                                                                        
       2240-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2300-DEL-PRCS-FOR-RATE.                                        *        
      ******************************************************************        
       2300-DEL-PRCS-FOR-RATE.                                          
                                                                        
           MOVE WS-CURR-ACCOUNT-NO          TO UR-ACCOUNT-NO-MST        
                                               UR-ACCOUNT-NO-DEP        
                                               UT-ACCOUNT-NO            
                                               AT-ACCOUNT-NO            
                                               IU-ACCOUNT-NO            
                                               BK-ACCOUNT-NO            
                                               MN-ACCOUNT-NO            
                                               CP-ACCOUNT-NO.           
                                                                        
           MOVE WS-CURR-CODE-UTIL-TYPE      TO UR-CODE-UTIL-TYPE-MST    
                                               UR-CODE-UTIL-TYPE-DEP    
                                               UT-CODE-UTIL-TYPE        
                                               IU-CODE-UTIL-TYPE        
                                               BK-CODE-UTIL-TYPE        
                                               RD-CODE-UTIL-TYPE        
                                               MN-CODE-UTIL-TYPE        
                                               CP-CODE-UTIL-TYPE        
                                               BR-CODE-UTIL-TYPE.       
                                                                        
           MOVE WS-CURR-IC-NO               TO UR-IC-NO-MST             
                                               UR-IC-NO-DEP             
                                               UT-IC-NO                 
                                               IU-IC-NO                 
                                               BK-IC-NO                 
                                               MN-IC-NO                 
                                               CP-IC-NO.                
                                                                        
           MOVE WS-CURR-RATE-PLAN-NO        TO BR-RATE-PLAN-NO.         
                                                                        
      *    VALIDATION FOR DELETE.                                               
           PERFORM 2310-VLDTN-FOR-DELETE       THRU 2310-EXIT.          
                                                                        
      *    GET ALL PREVIOUS VALUES.                                             
           PERFORM 2205-GET-PREV-VALUES        THRU 2205-EXIT           
                                                                        
      *                                                                         
           MOVE UT-RATE-PLAN-NO             TO RD-RATE-PLAN-NO.         
           PERFORM 2410-SET-MTRD-UNMTRD-FLAG   THRU 2410-EXIT.          
                                                                        
      *    WRITE TRANSACTION HISTORY SUMMARY.                                   
           PERFORM 5100-WRITE-TRANS-HIST-SUMM  THRU 5100-EXIT.          
           MOVE WS-CURRENT-DATE             TO AT-DATE-LAST-ACTION.     
                                                                        
      *    WRITE TRANSACTION HISTORY DETAILS.                                   
           PERFORM 5200-WRITE-TRANS-HIST-DET   THRU 5200-EXIT.          
                                                                        
      *    MAIN DELETE PROCESS.                                                 
           PERFORM 2320-PROCESS-DELETE-RATE    THRU 2320-EXIT.          
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2310-VLDTN-FOR-DELETE.                                         *        
      ******************************************************************        
       2310-VLDTN-FOR-DELETE.                                           
                                                                        
           PERFORM 7200-CHECK-FOR-DEP          THRU 7200-EXIT           
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              PERFORM 7210-CHECK-FOR-MST       THRU 7210-EXIT           
           END-IF                                                       
                                                                        
      *    IF ACCOUNT HAS DEPENDENT / MASTER ACCOUNTS, CANNNOT DEL RATE.        
           IF WS-DEP-ACCT-EXIST EQUAL WS-YES                            
              OR WS-MST-ACCT-EXIST EQUAL WS-YES                         
              MOVE 'MRM0000057'             TO S-BUS-RULE-ID            
              MOVE WS-FAILED                TO S-BUS-RULE-RESULT-CD     
              IF S-BUS-RULE-ID GREATER THAN SPACES                      
                 PERFORM 7010-GET-RULE-XREF-ID THRU 7010-EXIT           
              END-IF                                                    
              MOVE WS-ZERO                  TO S-APPL-RETURN-CODE       
              PERFORM 8005-SEND-RESULT         THRU 8005-EXIT           
              PERFORM 9999-END-PROGRAM         THRU 9999-EXIT           
           END-IF.                                                      
                                                                        
       2310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2320-PROCESS-DELETE-RATE.                                      *        
      ******************************************************************        
       2320-PROCESS-DELETE-RATE.                                        
                                                                        
           PERFORM 8300-DELETE-INTV-USE-CLASS    THRU 8300-EXIT.        
           PERFORM 8310-DELETE-BILL-CONTRACT     THRU 8310-EXIT.        
           PERFORM 8320-DELETE-MTRD-ENVRNMT      THRU 8320-EXIT.        
           PERFORM 8340-DELETE-CUST-PLAN         THRU 8340-EXIT.        
           PERFORM 8350-DELETE-UTIL-ENVRNMT      THRU 8350-EXIT.        
           PERFORM 8150-UPD-DT-LAST-ACTN-AT      THRU 8150-EXIT.        
                                                                        
       2320-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2400-DETERMINE-ACCT-TYPE-CODE.                                 *        
      ******************************************************************        
       2400-DETERMINE-ACCT-TYPE-CODE.                                   
                                                                        
      *    IF REV_CLASS MID DGT IS NOT "RESIDENTIAL",DELETE SUBDIVISION         
      *    LIGHTING ROW FROM CSS_CUST_PLAN & CSS_UTIL_ENVRNMT.                  
           IF (WS-CURR-CODE-REV-CLASS (2:1) = '2' OR '3' OR '8' OR '9') 
               AND WS-CURR-DELETE-SUBDSN-FL EQUAL WS-YES                
              PERFORM 7300-SELECT-IC-NO        THRU 7300-EXIT           
              PERFORM 8400-DEL-UNMTR-CUST-PLAN THRU 8400-EXIT           
              PERFORM 8410-DEL-UNMTR-UTIL-ENVRNMT                       
                                               THRU 8410-EXIT           
              MOVE WS-NO                    TO WS-UNMETERED-EXISTS      
              PERFORM 7310-CHECK-UNMTR-EXISTS  THRU 7310-EXIT           
              IF UNMETERED-NOT-EXISTS                                   
                 PERFORM 8420-UPDT-PREMSE-INFO THRU 8420-EXIT           
              END-IF                                                    
           END-IF.                                                      
                                                                        
      *    GET THE DERIVED ACCT_TYPE_CODE FROM COPYBOOK CPD00118                
           MOVE AT-ACCOUNT-NO               TO UT-ACCOUNT-NO.           
           PERFORM 6000-GET-ACCT-TYPE-CODE-CPD118                       
                                               THRU 6000-CPD118-EXIT.   
      *    UPDATE ACCOUNT_TYPE_CODE IF REQUIRED                                 
           IF WS-CPD118-ACCT-TYPE-CODE GREATER THAN SPACES              
              PERFORM 7320-GET-CURR-ACCT-TYPE  THRU 7320-EXIT           
              IF WS-CPD118-ACCT-TYPE-CODE NOT = AT-ACCOUNT-TYPE-CODE    
                 PERFORM 5500-WRITE-TRANS-ACCT-TYPE                     
                                               THRU 5500-EXIT           
                 MOVE WS-CPD118-ACCT-TYPE-CODE                          
                                            TO AT-ACCOUNT-TYPE-CODE     
                 PERFORM 8430-UPDATE-ACCT-TYPE THRU 8430-EXIT           
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2410-SET-MTRD-UNMTRD-FLAG                                      *        
      ******************************************************************        
       2410-SET-MTRD-UNMTRD-FLAG.                                       
                                                                        
           PERFORM 7025-GET-RATE-DTLS          THRU 7025-EXIT.          
                                                                        
           IF RD-UNMTR-PROV-FL = 'Y' THEN                               
              SET UNMETERED-RATE            TO TRUE                     
           END-IF.                                                      
                                                                        
       2410-EXIT.                                                       
           EXIT.                                                        
A05051*                                                                         
A05051****************************************************************          
A05051**  FORMAT LETTERS.                                           **          
A05051****************************************************************          
A05051*                                                                         
A05051 2500-FORMAT-LETTERS.                                             
A05051*                                                                         
A05051     MOVE WS-SEQ-NO-COUNT          TO 1J-CORRESP-SEQ-NO.          
A05051     MOVE WS-MESSAGE-NO            TO 1J-CORRESP-MSG-ID           
A05051                                      WS-MESSAGE-ID.              
A05051     MOVE AT-COMPANY-NO            TO 1J-CORRESP-COMPANY-NO       
A05051     MOVE AT-ACCOUNT-NO            TO 1J-ACCOUNT-NO.              
A05051     MOVE AT-CUSTOMER-NO           TO 1J-CUSTOMER-NO.             
A05051     MOVE AT-LOCAL-OFFICE          TO WS-CWS350-LOCAL-OFFICE.     
A05051     MOVE WS-DATABASE              TO WS-CWS350-DATABASE.         
A05051     MOVE SPACES                   TO 1J-REG-GROUP-CD             
A05051     MOVE 'I'                      TO 1J-CORRESP-STATUS-CD        
A05051     MOVE ZEROES                   TO 1J-GUARNTR-ACCT-NO          
A05051                                      1J-THD-PRTY-ID              
A05051     MOVE SPACES                   TO 1J-BARCODE-UNIQUE-ID        
A05051     MOVE PROGRAM-NAME             TO 1J-CREATED-BY-PGM-ID        
A05051                                      1J-LAST-UPDATE-PGM-ID       
A05051     MOVE MH-DATE-TRANS            TO 1J-CORRESP-STMT-DT          
A05051     MOVE SPACES                   TO WS-CORRESP-ID-FND.          
A05051     MOVE ' '                      TO 1J-SENIOR-FL.               
A05051     SET ONLINE-CALL             TO TRUE.                         
A05051     SET WS-COR-INDX             TO 1.                            
A05051*                                                                         
A05051     PERFORM 5000-CHECK-LOAD-CORRESP-TBL THRU 5000-CPD350-EXIT.   
A05051*                                                                         
A05051     MOVE WS-CURR-CORRESP-TYP-CD TO 1J-CORRESP-TYPE-CD.           
A05051     PERFORM 5425-GET-CORRESP-ID-VAL THRU 5425-CPD350-EXIT.       
A05051*                                                                         
A05051     INITIALIZE DCLCSS-CORRESP-VAR.                               
A05051     MOVE WS-CORRESP-ID            TO 1K-CORRESP-ID .             
A05051     MOVE 'NUM-VAR-1'              TO 1K-CORRESP-VAR-NM.          
A05051     MOVE WS-MESSAGE-VAR1X         TO 1K-CORRESP-VAR-DATA.        
A05051     MOVE WS-MESSAGE-VAR1          TO 1K-CORRESP-VAR-NUM.         
A05051     PERFORM 8600-INSERT-CORRESP-VAR THRU 8600-CPD350-EXIT.       
A05051*                                                                         
A05051     INITIALIZE DCLCSS-CORRESP-VAR.                               
A05051     MOVE WS-CORRESP-ID            TO 1K-CORRESP-ID .             
A05051     MOVE 'ALPHA-VAR-1'            TO 1K-CORRESP-VAR-NM.          
A05051     MOVE WS-MESSAGE-ALPHA1X       TO 1K-CORRESP-VAR-DATA.        
A05051     MOVE WS-MESSAGE-ALPHA1        TO 1K-CORRESP-VAR-CHAR.        
A05051     PERFORM 8600-INSERT-CORRESP-VAR THRU 8600-CPD350-EXIT.       
A05051*                                                                         
A05051     INITIALIZE DCLCSS-CORRESP-VAR.                               
A05051     MOVE WS-CORRESP-ID            TO 1K-CORRESP-ID .             
A05051     MOVE 'ALPHA-VAR-2'            TO 1K-CORRESP-VAR-NM.          
A05051     MOVE WS-MESSAGE-ALPHA2X       TO 1K-CORRESP-VAR-DATA.        
A05051     MOVE WS-MESSAGE-ALPHA2        TO 1K-CORRESP-VAR-CHAR.        
A05051     PERFORM 8600-INSERT-CORRESP-VAR THRU 8600-CPD350-EXIT.       
A05051*                                                                         
A05051     INITIALIZE DCLCSS-CORRESP-VAR.                               
A05051     MOVE WS-CORRESP-ID            TO 1K-CORRESP-ID .             
A05051     MOVE 'ALPHA-VAR-3'            TO 1K-CORRESP-VAR-NM.          
A05051     MOVE WS-MESSAGE-ALPHA3X       TO 1K-CORRESP-VAR-DATA.        
A05051     MOVE WS-MESSAGE-ALPHA3        TO 1K-CORRESP-VAR-CHAR.        
A05051     PERFORM 8600-INSERT-CORRESP-VAR THRU 8600-CPD350-EXIT.       
A05051*                                                                         
A05051 2500-EXIT.                                                       
A05051     EXIT.                                                        
A05051*                                                                         
A05051****************************************************************          
A05051* 5000-CHECK-LOAD-CORRESP-TBL.                                 *          
A05051****************************************************************          
A05051*                                                                         
A05051      EXEC SQL                                                            
A05051           INCLUDE CPD00350                                               
A05051      END-EXEC.                                                           
                                                                        
      ******************************************************************        
      *                                                                *        
A05051* 5025-INSERT-BILL-MSGS.                                         *        
      ******************************************************************        
A05051 5025-INSERT-BILL-MSGS.                                           
                                                                        
           MOVE 'CSR04642'               TO WS-626-CALLING-PGM          
           MOVE UT-ACCOUNT-NO            TO WS-626-ACCOUNT-NO           
           MOVE WS-CURR-COMPANY-NO       TO WS-626-COMPANY-NO           
           MOVE UT-CODE-UTIL-TYPE        TO WS-626-CODE-UTIL-TYPE       
           MOVE 'R'                      TO WS-626-VALUE-SOURCE-CD      
           MOVE WS-CURR-RATE-PLAN-NO     TO WS-626-VALUE-CD             
           MOVE UT-RATE-PLAN-NO          TO WS-626-PREV-VALUE-CD        
           MOVE WS-CURR-USER-ID          TO WS-626-USER-ID              
           MOVE WS-YES                   TO WS-626-DB2-UPDATE-FLAG      
                                                                        
           MOVE WS-ZERO                  TO WS-626-RETURN-CODE          
                                            WS-626-RETURN-ROW-COUNT     
                                            WS-626-MSG-DEL-COUNT        
                                                                        
           CALL MCSCB626  USING  ABEND-FILE                             
                                ,WS-WARNING-DATA-ELEMENTS               
                                ,LS-626-INPUT-FIELDS                    
                                ,LS-626-OUTPUT-FIELDS.                  
                                                                        
           IF WS-626-RETURN-CODE NOT EQUAL WS-ZERO                      
              MOVE WS-626-RETURN-CODE       TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE            
              MOVE WS-ZERO                  TO S-APPL-RETURN-CODE       
              PERFORM 8005-SEND-RESULT         THRU 8005-EXIT           
              PERFORM 9999-END-PROGRAM         THRU 9999-EXIT           
           END-IF.                                                      
                                                                        
A05051 5025-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 5050-CREATE-QA-WQ.                                             *        
      ******************************************************************        
       5050-CREATE-QA-WQ.                                               
                                                                        
           MOVE WS-ZERO                      TO WQ-ITEM-ID              
ACT233                                          WQ-SERV-ORDER-NO.       
ACT233     MOVE WS-CURR-ACCOUNT-NO           TO WQ-ACCOUNT-NO.          
ACT233     MOVE WS-CURR-CUSTOMER-NO          TO WQ-CUSTOMER-NO.         
ACT233     MOVE WS-CURR-USER-ID              TO WQ-USER-ID-ORIG.        
ACT233     MOVE WS-CURR-PREMISE-NO           TO WQ-PREMISE-NO.          
ACT233     MOVE WS-CURR-COMPANY-NO           TO WQ-COMPANY-NO.          
ACT233     MOVE 573                          TO WQ-CATEGORY-ID.         
ACT233     MOVE 4                            TO ROUTING-CATEGORY-4675.  
ACT233     MOVE WS-NO                        TO WQ-PRIORITY.            
ACT233     MOVE SPACES                       TO WQ-DATE-CREATED         
ACT233                                          WQ-DATE-REQUIRED        
ACT233                                          WQ-RESP-AREA-ID         
                                                WQ-USER-ID-ASGN         
ACT233                                          LOCAL-OFFICE-4675.      
                                                                        
ACT233     MOVE WS-CURR-WQ-COMMENT           TO WQ-COMMENTS-TEXT.       
ACT233     MOVE LENGTH OF WQ-COMMENTS-TEXT   TO WQ-COMMENTS-LEN.        
ACT233     MOVE 'CSR04642'                   TO WQ-CREATED-BY.          
                                                                        
           PERFORM 6100-CALL-CREATE-WQ-SP       THRU 6100-EXIT.         
                                                                        
           IF SQLCODE = +466 THEN                                       
      *       EXEC SQL ASSOCIATE LOCATORS(:LOC1) WITH PROCEDURE         
ACT233*         CSR04675                                                
      *       END-EXEC                                                  
      *       EXEC SQL ALLOCATE C2 CURSOR FOR RESULT SET :LOC1          
      *       END-EXEC                                                  
              EXEC SQL                                                  
ACT233        FETCH C2 INTO :WS-CSR04675-RETURN-CODE                    
                           ,:WQ-ITEM-ID                                 
              END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                  
           END-IF.                                                      
                                                                        
ACT233     IF WS-CSR04675-RETURN-CODE EQUAL WS-ZERO                     
              MOVE WS-YES                TO S-WQ-CREATED-FLAG           
           ELSE                                                         
              MOVE 'CMN0000027'          TO S-BUS-RULE-ID               
              MOVE WS-FAILED             TO S-BUS-RULE-RESULT-CD        
              IF S-BUS-RULE-ID GREATER THAN SPACES                      
                 PERFORM 7010-GET-RULE-XREF-ID THRU 7010-EXIT           
              END-IF                                                    
              MOVE WS-ZERO               TO S-APPL-RETURN-CODE          
              PERFORM 8005-SEND-RESULT      THRU 8005-EXIT              
              PERFORM 9999-END-PROGRAM      THRU 9999-EXIT              
           END-IF.                                                      
                                                                        
       5050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 5100-WRITE-TRANS-HIST-SUMM.                                    *        
      ******************************************************************        
       5100-WRITE-TRANS-HIST-SUMM.                                      
                                                                        
           PERFORM 7015-GET-RESP-AREA-ID       THRU 7015-EXIT.          
           PERFORM 7020-GET-CURR-TIMESTAMP     THRU 7020-EXIT.          
                                                                        
      *    WRITE A TRANSACTION HISTORY FOR THE HEADER ROW                       
           MOVE 'F'                         TO MH-CODE-TRAN-TYPE.       
           MOVE WS-RESP-AREA-ID             TO MH-RESP-AREA-ID.         
           MOVE WS-CURR-ACCOUNT-NO          TO MH-ACCOUNT-NO.           
           MOVE WS-CURR-CUSTOMER-NO         TO MH-CUSTOMER-NO.          
           MOVE WS-CURR-PREMISE-NO          TO MH-PREMISE-NO.           
           MOVE WS-CURR-USER-ID             TO MH-USER-ID.              
           MOVE 'CSR04642'                  TO MH-APPL-PROGRAM-ID.      
                                                                        
      *    IF WS-CURR-WQ-CREATE-FL NOT EQUAL WS-YES                             
      *       MOVE WS-COMMENTS              TO MH-TRAN-COMMENT-TEXT             
      *       MOVE LENGTH OF MH-TRAN-COMMENT-TEXT                               
      *                                     TO MH-TRAN-COMMENT-LEN              
      *    END-IF.                                                              
                                                                        
           MOVE WS-ONE                      TO MI-TRAN-APPL-NO.         
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 5200-WRITE-TRANS-HIST-DET.                                     *        
      ******************************************************************        
       5200-WRITE-TRANS-HIST-DET.                                       
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO    TO MI-TRANS-HIST-SEQ-NO.        
                                                                        
A05065* RECORD UTILITY TYPE TO HELP IDENTIFY WHICH RATE WAS UPDATED,            
A05065*    ADDED OR DELETED.                                                    
A05065     MOVE 'CODE_UTIL_TYPE'         TO UV-COLUMN-NA-TEXT.          
A05065     MOVE LENGTH OF UV-COLUMN-NA-TEXT                             
A05065                                   TO UV-COLUMN-NA-LEN.           
A05065     MOVE 'CSS_RATE_PLAN_DESC'     TO UV-TABLE-NA-TEXT.           
A05065     MOVE LENGTH OF UV-TABLE-NA-TEXT                              
A05065                                   TO UV-TABLE-NA-LEN.            
A05065     MOVE 'ALL'                    TO UV-PROGRAM-ID.              
A05065     MOVE SPACES                   TO UV-CODE-SHORT-DESC.         
A05065     MOVE '01'                     TO UV-COMPANY-NO.              
A05065     MOVE WS-CURR-CODE-UTIL-TYPE   TO UV-CODE-VALUE-TEXT.         
A05065     MOVE LENGTH OF UV-CODE-VALUE-TEXT                            
A05065                                   TO UV-CODE-VALUE-LEN.          
A05065     PERFORM 7095-GET-CODE-UTIL-TYPE-DESC THRU 7095-EXIT.         
A05065     IF WS-CURR-UPDT-ACTION-IND = 'I'                             
A05065         MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN     
A05065         MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT    
A05065         MOVE UV-CODE-SHORT-DESC-TEXT                             
A05065                                   TO MI-CHG-COLUMN-VALUE-TEXT    
A05065         MOVE LENGTH OF UV-CODE-SHORT-DESC-TEXT                   
A05065                                   TO MI-CHG-COLUMN-VALUE-LEN     
A05065     ELSE                                                         
A05065        IF WS-CURR-UPDT-ACTION-IND = 'D'                          
A05065            MOVE UV-CODE-SHORT-DESC-TEXT                          
A05065                                   TO MI-PRV-COLUMN-VALUE-TEXT    
A05065            MOVE LENGTH OF UV-CODE-SHORT-DESC-TEXT                
A05065                                   TO MI-PRV-COLUMN-VALUE-LEN     
A05065            MOVE +9                TO MI-CHG-COLUMN-VALUE-LEN     
A05065            MOVE '*DELETED*'       TO MI-CHG-COLUMN-VALUE-TEXT    
A05065        ELSE                                                      
A05065            MOVE UV-CODE-SHORT-DESC-TEXT                          
A05065                                   TO MI-PRV-COLUMN-VALUE-TEXT    
A05065                                      MI-CHG-COLUMN-VALUE-TEXT    
A05065            MOVE LENGTH OF UV-CODE-SHORT-DESC-TEXT                
A05065                                   TO MI-PRV-COLUMN-VALUE-LEN     
A05065                                      MI-CHG-COLUMN-VALUE-LEN     
A05065        END-IF                                                    
A05065     END-IF.                                                      
A05065     MOVE SPACES                   TO MI-TABLE-ID.                
A05065     MOVE 'UTILITY TYPE   '        TO MI-COLUMN-DESC.             
A05065     PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
A05065     ADD 1                         TO MI-TRAN-APPL-NO.            
                                                                        
A05065* RECORD IC NUMBER TO HELP IDENTIFY WHICH RATE WAS UPDATED,               
A05065* ADDED OR DELETED.                                                       
A05065     IF WS-CURR-UPDT-ACTION-IND = 'I'                             
A05065         MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN     
A05065         MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT    
A05065         MOVE +4                   TO MI-CHG-COLUMN-VALUE-LEN     
A05065         MOVE UT-IC-NO             TO MI-CHG-COLUMN-VALUE-TEXT    
A05065     ELSE                                                         
A05065        IF WS-CURR-UPDT-ACTION-IND = 'D'                          
A05065            MOVE +4                TO MI-PRV-COLUMN-VALUE-LEN     
A05065            MOVE WS-CURR-IC-NO     TO MI-PRV-COLUMN-VALUE-TEXT    
A05065            MOVE +9                TO MI-CHG-COLUMN-VALUE-LEN     
A05065            MOVE '*DELETED*'       TO MI-CHG-COLUMN-VALUE-TEXT    
A05065        ELSE                                                      
A05065           MOVE +4                 TO MI-PRV-COLUMN-VALUE-LEN     
A05065                                      MI-CHG-COLUMN-VALUE-LEN     
A05065           MOVE WS-CURR-IC-NO      TO MI-PRV-COLUMN-VALUE-TEXT    
A05065                                      MI-CHG-COLUMN-VALUE-TEXT    
A05065        END-IF                                                    
A05065     END-IF.                                                      
A05065     MOVE SPACES                   TO MI-TABLE-ID.                
A05065     MOVE 'IC NUMBER      '        TO MI-COLUMN-DESC.             
A05065     PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
A05065     ADD 1                         TO MI-TRAN-APPL-NO.            
                                                                        
      * ESTIMATE OK FLAG - START HERE                                           
           IF METERED-RATE                                              
              EVALUATE WS-CURR-UPDT-ACTION-IND                          
                 WHEN 'U'                                               
                    IF UT-CODE-ESTIMATE-OK NOT EQUAL                    
                                              WS-CURR-CODE-ESTIMATE-OK  
                       MOVE +1             TO MI-CHG-COLUMN-VALUE-LEN   
                                              MI-PRV-COLUMN-VALUE-LEN   
                       MOVE WS-CURR-CODE-ESTIMATE-OK                    
                                           TO MI-CHG-COLUMN-VALUE-TEXT  
                       MOVE UT-CODE-ESTIMATE-OK                         
                                           TO MI-PRV-COLUMN-VALUE-TEXT  
                       MOVE '37'           TO MI-TABLE-ID               
                       MOVE 'ESTIMATE OK    '                           
                                           TO MI-COLUMN-DESC            
                       PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT  
                       ADD 1               TO MI-TRAN-APPL-NO           
                    END-IF                                              
                 WHEN 'I'                                               
                    MOVE +1                TO MI-CHG-COLUMN-VALUE-LEN   
                    MOVE WS-CURR-CODE-ESTIMATE-OK                       
                                           TO MI-CHG-COLUMN-VALUE-TEXT  
                    MOVE +5                TO MI-PRV-COLUMN-VALUE-LEN   
                    MOVE '*NEW*'                                        
                                           TO MI-PRV-COLUMN-VALUE-TEXT  
                    MOVE '37'              TO MI-TABLE-ID               
                    MOVE 'ESTIMATE OK    ' TO MI-COLUMN-DESC            
                    PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT     
                    ADD 1                     TO MI-TRAN-APPL-NO        
                 WHEN 'D'                                               
                    MOVE +9                TO MI-CHG-COLUMN-VALUE-LEN   
                    MOVE '*DELETED*'                                    
                                           TO MI-CHG-COLUMN-VALUE-TEXT  
                    MOVE +1                TO MI-PRV-COLUMN-VALUE-LEN   
                    MOVE UT-CODE-ESTIMATE-OK                            
                                           TO MI-PRV-COLUMN-VALUE-TEXT  
                    MOVE '37'              TO MI-TABLE-ID               
                    MOVE 'ESTIMATE OK    ' TO MI-COLUMN-DESC            
                    PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT     
                    ADD 1                  TO MI-TRAN-APPL-NO           
              END-EVALUATE                                              
           END-IF.                                                      
      * ESTIMATE OK TRANSACTION HISTORY UPDATE ENDS HERE                        
      * ALTERNATE FUEL CODE START HERE                                          
                                                                        
           IF CSR-DATABASE  AND METERED-RATE                            
                                                                        
             IF UT-ALTERNATE-FUEL-CD      EQUAL SPACES                  
                MOVE WS-NO              TO UT-ALTERNATE-FUEL-CD         
             END-IF                                                     
                                                                        
             IF WS-CURR-ALTERNATE-FUEL-CD EQUAL SPACES                  
                MOVE WS-NO              TO WS-CURR-ALTERNATE-FUEL-CD    
             END-IF                                                     
      *                                                                         
             IF RATE-INSERT AND (WS-CURR-ALTERNATE-FUEL-CD = 'N')       
                NEXT SENTENCE                                           
             ELSE                                                       
                EVALUATE WS-CURR-UPDT-ACTION-IND                        
                   WHEN 'U'                                             
                     IF UT-ALTERNATE-FUEL-CD NOT EQUAL                  
                                               WS-CURR-ALTERNATE-FUEL-CD
                       MOVE WS-CURR-ALTERNATE-FUEL-CD                   
                                             TO W0-ALTERNATE-FUEL-CD    
                       PERFORM 7074-GET-ALT-FUEL-DESC THRU 7074-EXIT    
                       MOVE LENGTH OF W0-ALTERNATE-FUEL-TX              
                                             TO MI-CHG-COLUMN-VALUE-LEN 
                       MOVE W0-ALTERNATE-FUEL-TX                        
                                             TO MI-CHG-COLUMN-VALUE-TEXT
      * MOVE PREVIOUS ALT FUEL CODE                                             
                       MOVE UT-ALTERNATE-FUEL-CD                        
                                             TO W0-ALTERNATE-FUEL-CD    
                       PERFORM 7074-GET-ALT-FUEL-DESC THRU 7074-EXIT    
                       MOVE LENGTH OF W0-ALTERNATE-FUEL-TX              
                                             TO MI-PRV-COLUMN-VALUE-LEN 
                       MOVE W0-ALTERNATE-FUEL-TX                        
                                             TO MI-PRV-COLUMN-VALUE-TEXT
      *                                                                         
                       MOVE SPACES           TO MI-TABLE-ID             
                       MOVE 'ALT FUEL CODE'  TO MI-COLUMN-DESC          
                       PERFORM 6530-LOAD-MNT-TRANS-HIST                 
                                                  THRU 6530-EXIT        
                       ADD 1                 TO MI-TRAN-APPL-NO         
                     END-IF                                             
                   WHEN 'I'                                             
                       MOVE WS-CURR-ALTERNATE-FUEL-CD                   
                                            TO W0-ALTERNATE-FUEL-CD     
                       PERFORM 7074-GET-ALT-FUEL-DESC THRU 7074-EXIT    
                       MOVE LENGTH OF W0-ALTERNATE-FUEL-TX              
                                            TO MI-CHG-COLUMN-VALUE-LEN  
                       MOVE W0-ALTERNATE-FUEL-TX                        
                                            TO MI-CHG-COLUMN-VALUE-TEXT 
      * MOVE PREVIOUS ALT FUEL CODE                                             
                       MOVE +5              TO MI-PRV-COLUMN-VALUE-LEN  
                       MOVE '*NEW*'         TO MI-PRV-COLUMN-VALUE-TEXT 
      *                                                                         
                       MOVE SPACES          TO MI-TABLE-ID              
                       MOVE 'ALT FUEL CODE' TO MI-COLUMN-DESC           
                       PERFORM 6530-LOAD-MNT-TRANS-HIST                 
                                                  THRU 6530-EXIT        
                       ADD 1                TO MI-TRAN-APPL-NO          
                   WHEN 'D'                                             
                       MOVE +9              TO MI-CHG-COLUMN-VALUE-LEN  
                       MOVE '*DELETED*'                                 
                                            TO MI-CHG-COLUMN-VALUE-TEXT 
      * MOVE PREVIOUS ALT FUEL CODE                                             
                       MOVE UT-ALTERNATE-FUEL-CD                        
                                             TO W0-ALTERNATE-FUEL-CD    
                       PERFORM 7074-GET-ALT-FUEL-DESC THRU 7074-EXIT    
                       MOVE LENGTH OF W0-ALTERNATE-FUEL-TX              
                                             TO MI-PRV-COLUMN-VALUE-LEN 
                       MOVE W0-ALTERNATE-FUEL-TX                        
                                             TO MI-PRV-COLUMN-VALUE-TEXT
      *                                                                         
                       MOVE SPACES           TO MI-TABLE-ID             
                       MOVE 'ALT FUEL CODE'  TO MI-COLUMN-DESC          
                       PERFORM 6530-LOAD-MNT-TRANS-HIST                 
                                                       THRU 6530-EXIT   
                       ADD 1                 TO MI-TRAN-APPL-NO         
                END-EVALUATE                                            
             END-IF                                                     
           END-IF.                                                      
      *  GAS CATEGORY START HERE                                                
           IF CSR-DATABASE AND WS-CURR-CODE-UTIL-TYPE EQUAL WS-GAS      
             AND METERED-RATE                                           
                                                                        
             IF Z4-PRTY-SVC-CAT-CD EQUAL LOW-VALUES                     
                MOVE SPACES                 TO Z4-PRTY-SVC-CAT-CD       
             END-IF                                                     
                                                                        
             IF Z4-PRTY-SVC-CAT-CD NOT = WS-CURR-PRTY-SVC-CAT-CD        
                                                                        
                IF WS-CURR-PRTY-SVC-CAT-CD GREATER THAN SPACES          
                   MOVE WS-CURR-PRTY-SVC-CAT-CD                         
                                            TO WS-PRTY-SVC-CAT-CD       
                   PERFORM 7075-GET-SVC-CAT-DESC THRU 7075-EXIT         
                   MOVE LENGTH OF Z4-PRTY-SVC-CAT-DESC                  
                                            TO MI-CHG-COLUMN-VALUE-LEN  
                   MOVE Z4-PRTY-SVC-CAT-DESC                            
                                            TO MI-CHG-COLUMN-VALUE-TEXT 
                ELSE                                                    
                   IF WS-CURR-UPDT-ACTION-IND = 'U' OR 'D'              
                      MOVE +9               TO MI-CHG-COLUMN-VALUE-LEN  
                      MOVE '*DELETED*'      TO MI-CHG-COLUMN-VALUE-TEXT 
                   ELSE                                                 
                      MOVE +1               TO MI-CHG-COLUMN-VALUE-LEN  
                      MOVE SPACES           TO MI-CHG-COLUMN-VALUE-TEXT 
                   END-IF                                               
                END-IF                                                  
                                                                        
                IF Z4-PRTY-SVC-CAT-CD GREATER THAN SPACES               
                   MOVE Z4-PRTY-SVC-CAT-CD                              
                                        TO WS-PRTY-SVC-CAT-CD           
                   PERFORM 7075-GET-SVC-CAT-DESC THRU 7075-EXIT         
                   MOVE LENGTH OF Z4-PRTY-SVC-CAT-DESC                  
                                        TO MI-PRV-COLUMN-VALUE-LEN      
                   MOVE Z4-PRTY-SVC-CAT-DESC                            
                                        TO MI-PRV-COLUMN-VALUE-TEXT     
                ELSE                                                    
                   MOVE +5              TO MI-PRV-COLUMN-VALUE-LEN      
                   MOVE '*NEW*'         TO MI-PRV-COLUMN-VALUE-TEXT     
                END-IF                                                  
                                                                        
                MOVE SPACES             TO MI-TABLE-ID                  
                MOVE 'GAS CATEGORY'     TO MI-COLUMN-DESC               
                PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT        
                ADD 1                   TO MI-TRAN-APPL-NO              
             END-IF                                                     
           END-IF.                                                      
                                                                        
           IF UT-CODE-REVENUE-CLASS NOT EQUAL WS-CURR-CODE-REV-CLASS    
                  OR RATE-INSERT                                        
      *       SET THE FLAG FOR CODE REV CLASS CHANGED VALDTN(CIG ACCT)          
              MOVE WS-YES               TO WS-REV-CLAS-CHGD-FLAG        
                                                                        
      *       ACCOUNT IS COMPANY USE THEN UPDATE CSS_ACCOUNT TABLE.             
              IF RATE-UPDATE                                            
                 MOVE UT-CODE-REVENUE-CLASS                             
                                        TO WS-COMPANY-USE               
                 IF COMPANY-USE                                         
                    MOVE WS-CURR-CODE-REV-CLASS                         
                                        TO WS-COMPANY-USE               
                    IF NOT COMPANY-USE                                  
                       MOVE WS-NOT-CMPNY-ACCT                           
                                        TO AT-CODE-COMPANY-ACCT         
                       PERFORM 8000-UPDT-CD-COMPANY-ACCT THRU 8000-EXIT 
                    END-IF                                              
                 ELSE                                                   
                    MOVE WS-CURR-CODE-REV-CLASS                         
                                        TO WS-COMPANY-USE               
                    IF COMPANY-USE                                      
                       MOVE WS-CMPNY-ACCT                               
                                        TO AT-CODE-COMPANY-ACCT         
                       PERFORM 8000-UPDT-CD-COMPANY-ACCT THRU 8000-EXIT 
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
                                                                        
              IF RATE-INSERT                                            
                 MOVE WS-CURR-ACCOUNT-NO TO AT-ACCOUNT-NO               
                 MOVE WS-CURR-CODE-REV-CLASS                            
                                         TO WS-COMPANY-USE              
                 IF COMPANY-USE                                         
                    MOVE WS-CMPNY-ACCT   TO AT-CODE-COMPANY-ACCT        
                    PERFORM 8000-UPDT-CD-COMPANY-ACCT THRU 8000-EXIT    
                                                                        
                 ELSE                                                   
                    MOVE WS-NOT-CMPNY-ACCT TO AT-CODE-COMPANY-ACCT      
                    PERFORM 8000-UPDT-CD-COMPANY-ACCT THRU 8000-EXIT    
                 END-IF                                                 
              END-IF                                                    
                                                                        
              IF WS-CURR-CODE-REV-CLASS GREATER THAN SPACES             
                 MOVE WS-CURR-CODE-REV-CLASS                            
                                            TO F3-CODE-REVENUE-CLASS    
                 MOVE WS-CURR-COMPANY-NO    TO F3-COMPANY-NO            
                 MOVE WS-CURR-CODE-UTIL-TYPE                            
                                            TO F3-CODE-UTIL-TYPE        
                 PERFORM 7076-GET-REV-CLS-DESC    THRU 7076-EXIT        
                 MOVE F3-CODE-REVENUE-CLASS                             
                                            TO WS-REVENUE-CLS-DESC(1:3) 
                 MOVE ' - '                 TO WS-REVENUE-CLS-DESC(4:3) 
                 MOVE F3-REVENUE-CLS-DESC                               
                                            TO WS-REVENUE-CLS-DESC(7:26)
                 MOVE 32                                                
                                            TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE WS-REVENUE-CLS-DESC                               
                                            TO MI-CHG-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE '*DELETED*'           TO MI-CHG-COLUMN-VALUE-TEXT 
              END-IF                                                    
                                                                        
              INITIALIZE WS-REVENUE-CLS-DESC                            
                         F3-REVENUE-CLS-DESC                            
                         F3-CODE-REVENUE-CLASS                          
                                                                        
              IF UT-CODE-REVENUE-CLASS GREATER THAN SPACES AND          
                        NOT RATE-INSERT                                 
                 MOVE UT-CODE-REVENUE-CLASS                             
                                            TO F3-CODE-REVENUE-CLASS    
                 MOVE UT-COMPANY-NO         TO F3-COMPANY-NO            
                 MOVE UT-CODE-UTIL-TYPE                                 
                                            TO F3-CODE-UTIL-TYPE        
                 PERFORM 7076-GET-REV-CLS-DESC    THRU 7076-EXIT        
                 MOVE F3-CODE-REVENUE-CLASS                             
                                            TO WS-REVENUE-CLS-DESC(1:3) 
                 MOVE ' - '                 TO WS-REVENUE-CLS-DESC(4:3) 
                 MOVE F3-REVENUE-CLS-DESC                               
                                            TO WS-REVENUE-CLS-DESC(7:26)
                 MOVE 32                                                
                                            TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE WS-REVENUE-CLS-DESC                               
                                            TO MI-PRV-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT 
              END-IF                                                    
                                                                        
              MOVE SPACES                   TO MI-TABLE-ID              
              MOVE 'REVENUE CLASS  '        TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                         TO MI-TRAN-APPL-NO          
A05051        MOVE 'N'                      TO WS-AUTO-CARD-PAY         
A05051        PERFORM 7800-CHK-AUTO-CARD-PAY-ATTR  THRU  7800-EXIT      
A05051        IF UT-CODE-REVENUE-CLASS(2:1)  = '1' AND                  
A05051           WS-CURR-CODE-REV-CLASS(2:1) = '2' AND                  
A05051           WS-AUTO-CARD-PAY           = 'Y'                       
A05051           MOVE  SPACES               TO WS-CURR-WQ-COMMENT       
A05051           MOVE  WS-WQ-COMMENT-TXT1   TO WS-CURR-WQ-COMMENT(1:50) 
A05051           MOVE  WS-WQ-COMMENT-TXT2   TO WS-CURR-WQ-COMMENT(51:49)
A05051           PERFORM 5050-CREATE-QA-WQ   THRU 5050-EXIT             
A05051           PERFORM 7810-GET-ACCOUNT    THRU 7810-EXIT             
A05051           PERFORM 2500-FORMAT-LETTERS THRU 2500-EXIT             
A05051        END-IF                                                    
           END-IF.                                                      
      * PERSONAL CONTACT CD STARTS                                              
           IF METERED-RATE                                              
                                                                        
              IF PR-PERSONAL-CNTCT-CD = SPACES OR 'N'                   
                 MOVE 'N'                  TO WS-PERSONAL-CNTCT-CD      
              ELSE                                                      
                 MOVE 'Y'                  TO WS-PERSONAL-CNTCT-CD      
              END-IF                                                    
                                                                        
              EVALUATE WS-CURR-UPDT-ACTION-IND                          
                 WHEN 'U'                                               
                    IF WS-PERSONAL-CNTCT-CD NOT EQUAL                   
                                              WS-CURR-PERSONAL-CNTCT-CD 
                       MOVE +3             TO MI-CHG-COLUMN-VALUE-LEN   
                                              MI-PRV-COLUMN-VALUE-LEN   
                       IF WS-CURR-PERSONAL-CNTCT-CD = 'N'               
                          MOVE 'NO'        TO MI-CHG-COLUMN-VALUE-TEXT  
                       ELSE                                             
                          MOVE 'YES'       TO MI-CHG-COLUMN-VALUE-TEXT  
                       END-IF                                           
                                                                        
                       IF WS-PERSONAL-CNTCT-CD = 'N'                    
                          MOVE 'NO'        TO MI-PRV-COLUMN-VALUE-TEXT  
                       ELSE                                             
                          MOVE 'YES'       TO MI-PRV-COLUMN-VALUE-TEXT  
                       END-IF                                           
                       MOVE SPACES         TO MI-TABLE-ID               
                       MOVE 'CALL AHEAD  '                              
                                           TO MI-COLUMN-DESC            
                       PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT  
                       ADD 1               TO MI-TRAN-APPL-NO           
                    END-IF                                              
                 WHEN 'I'                                               
                    MOVE +3                TO MI-CHG-COLUMN-VALUE-LEN   
                    IF WS-CURR-PERSONAL-CNTCT-CD = 'N'                  
                       MOVE 'NO'           TO MI-CHG-COLUMN-VALUE-TEXT  
                    ELSE                                                
                       MOVE 'YES'          TO MI-CHG-COLUMN-VALUE-TEXT  
                    END-IF                                              
                                                                        
                    MOVE +5                TO MI-PRV-COLUMN-VALUE-LEN   
                    MOVE '*NEW*'                                        
                                           TO MI-PRV-COLUMN-VALUE-TEXT  
                    MOVE SPACES            TO MI-TABLE-ID               
                    MOVE 'CALL AHEAD '     TO MI-COLUMN-DESC            
                    PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT     
                    ADD 1                     TO MI-TRAN-APPL-NO        
                 WHEN 'D'                                               
                    MOVE +9                TO MI-CHG-COLUMN-VALUE-LEN   
                    MOVE '*DELETED*'                                    
                                           TO MI-CHG-COLUMN-VALUE-TEXT  
                    MOVE +3                TO MI-PRV-COLUMN-VALUE-LEN   
                    IF WS-PERSONAL-CNTCT-CD = 'N'                       
                       MOVE 'NO'           TO MI-PRV-COLUMN-VALUE-TEXT  
                    ELSE                                                
                       MOVE 'YES'          TO MI-PRV-COLUMN-VALUE-TEXT  
                    END-IF                                              
                                                                        
                    MOVE SPACES            TO MI-TABLE-ID               
                    MOVE 'CALL AHEAD '     TO MI-COLUMN-DESC            
                    PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT     
                    ADD 1                  TO MI-TRAN-APPL-NO           
              END-EVALUATE                                              
           END-IF.                                                      
      * END PERSONAL CONTACT CD                                                 
      *                                                                         
      * BEGIN  RATE PLAN                                                        
           IF UT-RATE-PLAN-NO NOT EQUAL WS-CURR-RATE-PLAN-NO OR         
                   RATE-INSERT                                          
              IF WS-CURR-RATE-PLAN-NO GREATER THAN SPACES               
                 MOVE +03                 TO MI-CHG-COLUMN-VALUE-LEN    
                 MOVE WS-CURR-RATE-PLAN-NO                              
                                          TO MI-CHG-COLUMN-VALUE-TEXT   
              ELSE                                                      
                 MOVE +9                  TO MI-CHG-COLUMN-VALUE-LEN    
                 MOVE '*DELETED*'         TO MI-CHG-COLUMN-VALUE-TEXT   
              END-IF                                                    
                                                                        
              IF UT-RATE-PLAN-NO GREATER THAN SPACES AND                
                     NOT RATE-INSERT                                    
                 MOVE +03                 TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE UT-RATE-PLAN-NO     TO MI-PRV-COLUMN-VALUE-TEXT   
              ELSE                                                      
                 MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT   
              END-IF                                                    
                                                                        
              MOVE SPACES                 TO MI-TABLE-ID                
              MOVE 'RATE PLAN NO   '      TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1                       TO MI-TRAN-APPL-NO            
           END-IF.                                                      
                                                                        
           IF UT-RATE-PLAN-NO NOT EQUAL WS-CURR-RATE-PLAN-NO OR         
                     RATE-INSERT                                        
              IF WS-CURR-RATE-PLAN-NO GREATER THAN SPACES               
                 MOVE WS-CURR-RATE-PLAN-NO  TO RD-RATE-PLAN-NO          
                 MOVE WS-CURR-CODE-UTIL-TYPE                            
                                            TO RD-CODE-UTIL-TYPE        
                 PERFORM 7025-GET-RATE-DTLS    THRU 7025-EXIT           
                 MOVE LENGTH OF RD-RATE-DESC                            
                                            TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE RD-RATE-DESC          TO MI-CHG-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE '*DELETED*'           TO MI-CHG-COLUMN-VALUE-TEXT 
              END-IF                                                    
                                                                        
              IF UT-RATE-PLAN-NO GREATER THAN SPACES AND                
                         NOT RATE-INSERT                                
                 MOVE UT-RATE-PLAN-NO       TO RD-RATE-PLAN-NO          
                 MOVE UT-CODE-UTIL-TYPE     TO RD-CODE-UTIL-TYPE        
                 PERFORM 7025-GET-RATE-DTLS   THRU 7025-EXIT            
                 MOVE LENGTH OF RD-RATE-DESC                            
                                          TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE RD-RATE-DESC         TO MI-PRV-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT   
              END-IF                                                    
                                                                        
              MOVE SPACES                 TO MI-TABLE-ID                
              MOVE 'RATE PLAN DESC   '    TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                       TO MI-TRAN-APPL-NO            
           END-IF.                                                      
      * END RATE PLAN                                                           
      ****************************************************************          
      *                                                              *          
      * EWNA CODE WILL NOT BE USED ANY MORE AND FIELD WILL BECOME    *          
      * INVISIBLE IN SCREEN.                                         *          
      *                                                              *          
      ****************************************************************          
      *                                                                         
      *    IF CSR-DATABASE AND WS-CURR-CODE-UTIL-TYPE = WS-ELECTRIC     12740000
      *       IF UT-CODE-REVENUE-CLASS NOT EQUAL WS-CURR-CODE-REV-CLASS         
      *         OR UT-RATE-PLAN-NO     NOT EQUAL WS-CURR-RATE-PLAN-NO           
      *                                                                         
      *          INITIALIZE UV-CODE-LONG-DESC                                   
      *          MOVE SPACES                  TO UV-CODE-VALUE-TEXT             
      *          MOVE UT-RATE-PLAN-NO         TO Q8-RATE-PLAN-NO                
      *          MOVE UT-CODE-REVENUE-CLASS   TO Q8-CODE-REVENUE-CLASS          
      *          PERFORM 7030-GET-GROUP-DESC     THRU 7030-EXIT                 
      *          MOVE UV-CODE-VALUE-TEXT(1:2) TO WS-PRV-GROUP-NO                
      *          MOVE UV-CODE-LONG-DESC-TEXT(1:UV-CODE-LONG-DESC-LEN)           
      *                                       TO WS-PRV-GROUP-DESC              
      *                                                                         
      *          INITIALIZE UV-CODE-LONG-DESC                                   
      *          MOVE SPACES                  TO UV-CODE-VALUE-TEXT             
      *          MOVE WS-CURR-RATE-PLAN-NO    TO Q8-RATE-PLAN-NO                
      *          MOVE WS-CURR-CODE-REV-CLASS  TO Q8-CODE-REVENUE-CLASS          
      *          PERFORM 7030-GET-GROUP-DESC    THRU 7030-EXIT                  
      *          MOVE UV-CODE-VALUE-TEXT(1:2) TO WS-CHG-GROUP-NO                
      *          MOVE UV-CODE-LONG-DESC-TEXT(1:UV-CODE-LONG-DESC-LEN)           
      *                                       TO WS-CHG-GROUP-DESC              
      *                                                                         
      *          IF WS-PRV-GROUP-NO NOT = WS-CHG-GROUP-NO                       
      *                                                                         
      *             IF WS-CHG-GROUP-NO GREATER THAN SPACES                      
      *                STRING WS-CHG-GROUP-NO   DELIMITED BY SIZE               
      *                       ' - '             DELIMITED BY SIZE               
      *                       WS-CHG-GROUP-DESC DELIMITED BY SIZE               
      *                  INTO MI-CHG-COLUMN-VALUE-TEXT                          
      *                END-STRING                                               
      *                MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                  
      *                                   TO MI-CHG-COLUMN-VALUE-LEN            
      *             ELSE                                                        
      *                MOVE +9            TO MI-CHG-COLUMN-VALUE-LEN            
      *                MOVE '*DELETED*'   TO MI-CHG-COLUMN-VALUE-TEXT           
      *             END-IF                                                      
      *                                                                         
      *             IF WS-PRV-GROUP-NO GREATER THAN SPACES                      
      *                STRING WS-PRV-GROUP-NO   DELIMITED BY SIZE               
      *                       ' - '             DELIMITED BY SIZE               
      *                       WS-PRV-GROUP-DESC DELIMITED BY SIZE               
      *                  INTO MI-PRV-COLUMN-VALUE-TEXT                          
      *                END-STRING                                               
      *                MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                  
      *                                   TO MI-PRV-COLUMN-VALUE-LEN            
      *             ELSE                                                        
      *                MOVE +5            TO MI-PRV-COLUMN-VALUE-LEN            
      *                MOVE '*NEW*'       TO MI-PRV-COLUMN-VALUE-TEXT           
      *             END-IF                                                      
      *                                                                         
      *             MOVE SPACES           TO MI-TABLE-ID                        
      *             MOVE 'EWNA GROUP'     TO MI-COLUMN-DESC                     
      *             PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT             
      *             ADD 1                 TO MI-TRAN-APPL-NO                    
      *          END-IF                                                         
      *       END-IF                                                            
      *    END-IF.                                                              
      *                                                                         
           IF UT-READ-CYCLE NOT EQUAL WS-CURR-READ-CYCLE OR             
                 RATE-INSERT                                            
                                                                        
              MOVE WS-YES                 TO WS-ROUTE-CYCLE-CHANGE      
                                                                        
              IF WS-CURR-READ-CYCLE GREATER THAN SPACES                 
                 MOVE +2                  TO MI-CHG-COLUMN-VALUE-LEN    
                 MOVE WS-CURR-READ-CYCLE  TO MI-CHG-COLUMN-VALUE-TEXT   
              ELSE                                                      
                 MOVE +9                  TO MI-CHG-COLUMN-VALUE-LEN    
                 MOVE '*DELETED*'         TO MI-CHG-COLUMN-VALUE-TEXT   
              END-IF                                                    
                                                                        
              IF UT-READ-CYCLE GREATER THAN SPACES AND                  
                    NOT RATE-INSERT                                     
                                                                        
                 MOVE +2                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE UT-READ-CYCLE       TO MI-PRV-COLUMN-VALUE-TEXT   
              ELSE                                                      
                 MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT   
              END-IF                                                    
                                                                        
              MOVE SPACES                 TO MI-TABLE-ID                
              MOVE 'READ CYCLE     '      TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                       TO MI-TRAN-APPL-NO            
           END-IF.                                                      
                                                                        
           IF UT-READ-ROUTE NOT EQUAL WS-CURR-READ-ROUTE OR             
                  RATE-INSERT                                           
                                                                        
              MOVE WS-YES                  TO WS-ROUTE-CYCLE-CHANGE     
              IF WS-CURR-READ-ROUTE GREATER THAN WS-ZERO                
                 MOVE +4                   TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE WS-CURR-READ-ROUTE   TO MI-CHG-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
                                                                        
              IF UT-READ-ROUTE GREATER THAN WS-ZERO AND                 
                     NOT RATE-INSERT                                    
                 MOVE +4                   TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE UT-READ-ROUTE        TO MI-PRV-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT  
              END-IF                                                    
                                                                        
              MOVE SPACES                  TO MI-TABLE-ID               
              MOVE 'READ ROUTE     '       TO MI-COLUMN-DESC            
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO MI-TRAN-APPL-NO           
           END-IF.                                                      
                                                                        
           IF UT-CODE-MTR-READ-FREQ NOT EQUAL WS-CURR-CD-MTR-READ-FREQ  
              AND METERED-RATE                                          
                                                                        
              MOVE 'CODE_MTR_READ_FREQ'     TO UV-COLUMN-NA-TEXT        
              MOVE LENGTH OF UV-COLUMN-NA-TEXT                          
                                            TO UV-COLUMN-NA-LEN         
              MOVE 'CSS_UTIL_ENVRNMT'       TO UV-TABLE-NA-TEXT         
              MOVE LENGTH OF UV-TABLE-NA-TEXT                           
                                            TO UV-TABLE-NA-LEN          
              MOVE 'ALL'                    TO UV-PROGRAM-ID            
              MOVE SPACES                   TO UV-CODE-SHORT-DESC       
              MOVE WS-CURR-COMPANY-NO       TO UV-COMPANY-NO            
                                                                        
              IF WS-CURR-CD-MTR-READ-FREQ GREATER THAN SPACES           
                 MOVE WS-CURR-CD-MTR-READ-FREQ                          
                                            TO UV-CODE-VALUE-TEXT       
                 MOVE LENGTH OF UV-CODE-VALUE-TEXT                      
                                            TO UV-CODE-VALUE-LEN        
                 PERFORM 7035-GET-MTR-RD-FREQ-DESC THRU 7035-EXIT       
                 MOVE UV-CODE-SHORT-DESC-TEXT                           
                                            TO MI-CHG-COLUMN-VALUE-TEXT 
                 MOVE LENGTH OF UV-CODE-SHORT-DESC-TEXT                 
                                            TO MI-CHG-COLUMN-VALUE-LEN  
              ELSE                                                      
                 MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE '*DELETED*'           TO MI-CHG-COLUMN-VALUE-TEXT 
              END-IF                                                    
                                                                        
              MOVE SPACES                   TO UV-CODE-SHORT-DESC       
              IF UT-CODE-MTR-READ-FREQ GREATER THAN SPACES              
                 MOVE UT-CODE-MTR-READ-FREQ TO UV-CODE-VALUE-TEXT       
                 MOVE LENGTH OF UV-CODE-VALUE-TEXT                      
                                            TO UV-CODE-VALUE-LEN        
                 PERFORM 7035-GET-MTR-RD-FREQ-DESC THRU 7035-EXIT       
                 MOVE UV-CODE-SHORT-DESC-TEXT                           
                                            TO MI-PRV-COLUMN-VALUE-TEXT 
                 MOVE LENGTH OF UV-CODE-SHORT-DESC-TEXT                 
                                            TO MI-PRV-COLUMN-VALUE-LEN  
              ELSE                                                      
                 MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT 
              END-IF                                                    
                                                                        
              MOVE SPACES                   TO MI-TABLE-ID              
              MOVE 'READ FREQUENCY '        TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                         TO MI-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
      * SIC TRANSACTION HISTORY STARTS HERE                                     
           MOVE SPACES TO MI-CHG-COLUMN-VALUE-TEXT                      
                          MI-PRV-COLUMN-VALUE-TEXT                      
                                                                        
           EVALUATE WS-CURR-UPDT-ACTION-IND                             
              WHEN 'U'                                                  
                 IF UT-CODE-SIC-NO NOT EQUAL WS-CURR-CODE-SIC-NO        
                    IF WS-CURR-CODE-SIC-NO NOT EQUAL SPACES             
                       MOVE +75              TO MI-CHG-COLUMN-VALUE-LEN 
                       MOVE WS-CURR-CODE-SIC-NO   TO R1-CODE-SIC-NO     
                       PERFORM 7040-SELECT-SIC-DESC   THRU 7040-EXIT    
                       IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND         
                          MOVE 'MRM0000063'     TO S-BUS-RULE-ID        
                          MOVE WS-FAILED        TO S-BUS-RULE-RESULT-CD 
                          IF S-BUS-RULE-ID GREATER THAN SPACES          
                            PERFORM 7010-GET-RULE-XREF-ID THRU 7010-EXIT
                          END-IF                                        
                          MOVE WS-ZERO          TO S-APPL-RETURN-CODE   
                          PERFORM 8005-SEND-RESULT        THRU 8005-EXIT
                          PERFORM 9999-END-PROGRAM       THRU 9999-EXIT 
                       ELSE                                             
                          MOVE WS-SIC-LONG-DESC TO                      
                                             MI-CHG-COLUMN-VALUE-TEXT   
                       END-IF                                           
                    ELSE                                                
                       MOVE +9               TO MI-CHG-COLUMN-VALUE-LEN 
                       MOVE '*DELETED*'      TO MI-CHG-COLUMN-VALUE-TEXT
                    END-IF                                              
                                                                        
                    IF UT-CODE-SIC-NO GREATER THAN SPACES               
                       MOVE +75             TO MI-PRV-COLUMN-VALUE-LEN  
                       MOVE UT-CODE-SIC-NO  TO MI-PRV-COLUMN-VALUE-TEXT 
                                               R1-CODE-SIC-NO           
                       PERFORM 7040-SELECT-SIC-DESC   THRU 7040-EXIT    
                       IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL   
                          MOVE WS-SIC-LONG-DESC TO                      
                                             MI-PRV-COLUMN-VALUE-TEXT   
                       END-IF                                           
                    ELSE                                                
                       MOVE +5              TO MI-PRV-COLUMN-VALUE-LEN  
                       MOVE '*NEW*'         TO MI-PRV-COLUMN-VALUE-TEXT 
                    END-IF                                              
                    MOVE SPACES                 TO MI-TABLE-ID          
                    MOVE 'SIC NO         '      TO MI-COLUMN-DESC       
                    PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT     
                    ADD 1                       TO MI-TRAN-APPL-NO      
                 END-IF                                                 
              WHEN 'I'                                                  
                 IF WS-CURR-CODE-SIC-NO NOT EQUAL SPACES                
                    MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN  
                    MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT 
                    MOVE +75                TO MI-CHG-COLUMN-VALUE-LEN  
                    MOVE WS-CURR-CODE-SIC-NO   TO R1-CODE-SIC-NO        
                    PERFORM 7040-SELECT-SIC-DESC   THRU 7040-EXIT       
                    IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND            
                       MOVE 'MRM0000063'     TO S-BUS-RULE-ID           
                       MOVE WS-FAILED        TO S-BUS-RULE-RESULT-CD    
                       IF S-BUS-RULE-ID GREATER THAN SPACES             
                          PERFORM 7010-GET-RULE-XREF-ID THRU 7010-EXIT  
                       END-IF                                           
                       MOVE WS-ZERO          TO S-APPL-RETURN-CODE      
                       PERFORM 8005-SEND-RESULT         THRU 8005-EXIT  
                       PERFORM 9999-END-PROGRAM         THRU 9999-EXIT  
                    ELSE                                                
                       MOVE WS-SIC-LONG-DESC TO MI-CHG-COLUMN-VALUE-TEXT
                    END-IF                                              
                    MOVE SPACES                 TO MI-TABLE-ID          
                    MOVE 'SIC NO         '      TO MI-COLUMN-DESC       
                    PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT     
                    ADD 1                       TO MI-TRAN-APPL-NO      
                 END-IF                                                 
              WHEN 'D'                                                  
                 IF UT-CODE-SIC-NO GREATER THAN SPACES                  
                    MOVE +75                 TO MI-PRV-COLUMN-VALUE-LEN 
                    MOVE UT-CODE-SIC-NO      TO MI-PRV-COLUMN-VALUE-TEXT
                                                  R1-CODE-SIC-NO        
                    PERFORM 7040-SELECT-SIC-DESC   THRU 7040-EXIT       
                    IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL      
                       MOVE WS-SIC-LONG-DESC TO MI-PRV-COLUMN-VALUE-TEXT
                    END-IF                                              
                    MOVE +9                TO MI-CHG-COLUMN-VALUE-LEN   
                    MOVE '*DELETED*'       TO MI-CHG-COLUMN-VALUE-TEXT  
                    MOVE SPACES                 TO MI-TABLE-ID          
                    MOVE 'SIC NO         '      TO MI-COLUMN-DESC       
                    PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT     
                    ADD 1                       TO MI-TRAN-APPL-NO      
                 END-IF                                                 
           END-EVALUATE                                                 
      * SIC TRANSACTION HISTORY UPDATE ENDS HERE                                
                                                                        
      * NAICS TRANSACTION HISTORY UPDATE ENDS HERE                              
           MOVE SPACES TO MI-CHG-COLUMN-VALUE-TEXT                      
                          MI-PRV-COLUMN-VALUE-TEXT                      
                                                                        
           IF UT-NAICS-CD = LOW-VALUE                                   
              MOVE SPACES                   TO UT-NAICS-CD              
           END-IF                                                       
                                                                        
           EVALUATE WS-CURR-UPDT-ACTION-IND                             
              WHEN 'U'                                                  
                 IF UT-NAICS-CD NOT EQUAL WS-CURR-NAICS-CD              
                    IF WS-CURR-NAICS-CD NOT EQUAL SPACES                
                       MOVE +75              TO MI-CHG-COLUMN-VALUE-LEN 
                       MOVE WS-CURR-NAICS-CD   TO R1-NAICS-CD           
                       MOVE WS-CURR-CODE-SIC-NO   TO R1-CODE-SIC-NO     
                       PERFORM 7050-SELECT-NAICS-DESC THRU 7050-EXIT    
                       IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND         
                          MOVE 'MRM0000064'     TO S-BUS-RULE-ID        
                          MOVE WS-FAILED        TO S-BUS-RULE-RESULT-CD 
                          IF S-BUS-RULE-ID GREATER THAN SPACES          
                            PERFORM 7010-GET-RULE-XREF-ID THRU 7010-EXIT
                          END-IF                                        
                          MOVE WS-ZERO          TO S-APPL-RETURN-CODE   
                          PERFORM 8005-SEND-RESULT        THRU 8005-EXIT
                          PERFORM 9999-END-PROGRAM       THRU 9999-EXIT 
                       ELSE                                             
                          MOVE WS-NAICS-LONG-DESC TO                    
                                             MI-CHG-COLUMN-VALUE-TEXT   
                       END-IF                                           
                    ELSE                                                
                       MOVE +9               TO MI-CHG-COLUMN-VALUE-LEN 
                       MOVE '*DELETED*'      TO MI-CHG-COLUMN-VALUE-TEXT
                    END-IF                                              
                                                                        
                    IF UT-NAICS-CD GREATER THAN SPACES                  
                       MOVE +75             TO MI-PRV-COLUMN-VALUE-LEN  
                       MOVE UT-NAICS-CD  TO MI-PRV-COLUMN-VALUE-TEXT    
                                               R1-NAICS-CD              
                       MOVE UT-CODE-SIC-NO      TO R1-CODE-SIC-NO       
                       PERFORM 7050-SELECT-NAICS-DESC THRU 7050-EXIT    
                       IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL   
                          MOVE WS-NAICS-LONG-DESC TO                    
                                             MI-PRV-COLUMN-VALUE-TEXT   
                       END-IF                                           
                    ELSE                                                
                       MOVE +5              TO MI-PRV-COLUMN-VALUE-LEN  
                       MOVE '*NEW*'         TO MI-PRV-COLUMN-VALUE-TEXT 
                    END-IF                                              
                    MOVE SPACES                 TO MI-TABLE-ID          
                    MOVE 'NAICS CD       '      TO MI-COLUMN-DESC       
                    PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT     
                    ADD 1                       TO MI-TRAN-APPL-NO      
                 END-IF                                                 
              WHEN 'I'                                                  
                 IF WS-CURR-NAICS-CD NOT EQUAL SPACES                   
                    MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN  
                    MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT 
                    MOVE +75                TO MI-CHG-COLUMN-VALUE-LEN  
                    MOVE WS-CURR-NAICS-CD   TO R1-NAICS-CD              
                    MOVE WS-CURR-CODE-SIC-NO   TO R1-CODE-SIC-NO        
                    PERFORM 7050-SELECT-NAICS-DESC THRU 7050-EXIT       
                    IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND            
                       MOVE 'MRM0000064'     TO S-BUS-RULE-ID           
                       MOVE WS-FAILED        TO S-BUS-RULE-RESULT-CD    
                       IF S-BUS-RULE-ID GREATER THAN SPACES             
                          PERFORM 7010-GET-RULE-XREF-ID THRU 7010-EXIT  
                       END-IF                                           
                       MOVE WS-ZERO          TO S-APPL-RETURN-CODE      
                       PERFORM 8005-SEND-RESULT         THRU 8005-EXIT  
                       PERFORM 9999-END-PROGRAM         THRU 9999-EXIT  
                    ELSE                                                
                       MOVE WS-NAICS-LONG-DESC  TO                      
                                              MI-CHG-COLUMN-VALUE-TEXT  
                    END-IF                                              
                    MOVE SPACES                 TO MI-TABLE-ID          
                    MOVE 'NAICS CD       '      TO MI-COLUMN-DESC       
                    PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT     
                    ADD 1                       TO MI-TRAN-APPL-NO      
                 END-IF                                                 
              WHEN 'D'                                                  
                 IF UT-NAICS-CD GREATER THAN SPACES                     
                    MOVE +75                 TO MI-PRV-COLUMN-VALUE-LEN 
                    MOVE UT-NAICS-CD      TO MI-PRV-COLUMN-VALUE-TEXT   
                                                  R1-NAICS-CD           
                    MOVE UT-CODE-SIC-NO      TO R1-CODE-SIC-NO          
                    PERFORM 7050-SELECT-NAICS-DESC THRU 7050-EXIT       
                    IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL      
                       MOVE WS-NAICS-LONG-DESC TO                       
                                              MI-PRV-COLUMN-VALUE-TEXT  
                    END-IF                                              
                    MOVE +9                TO MI-CHG-COLUMN-VALUE-LEN   
                    MOVE '*DELETED*'       TO MI-CHG-COLUMN-VALUE-TEXT  
                    MOVE SPACES                 TO MI-TABLE-ID          
                    MOVE 'NAICS CD       '      TO MI-COLUMN-DESC       
                    PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT     
                    ADD 1                       TO MI-TRAN-APPL-NO      
                 END-IF                                                 
           END-EVALUATE                                                 
      * NAICS TRANSACTION HISTORY UPDATE ENDS HERE                              
                                                                        
           IF UT-SEASONAL-USE-CODE  NOT EQUAL WS-CURR-SEASONAL-USE-CD   
              AND METERED-RATE                                          
                                                                        
              MOVE SPACES                  TO WS-UTIL-SEAS-CD-NEW       
              IF NOT RATE-DELETE                                        
                 STRING WS-CURR-CODE-UTIL-TYPE,WS-CURR-SEASONAL-USE-CD  
                                                DELIMITED BY SIZE       
                                                INTO WS-UTIL-SEAS-CD-NEW
              END-IF                                                    
              STRING UT-CODE-UTIL-TYPE, UT-SEASONAL-USE-CODE            
                              DELIMITED BY SIZE INTO WS-UTIL-SEAS-CD-OLD
                                                                        
              IF WS-UTIL-SEAS-CD-NEW GREATER THAN SPACES                
                 MOVE +03                   TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE WS-UTIL-SEAS-CD-NEW   TO MI-CHG-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE '*DELETED*'           TO MI-CHG-COLUMN-VALUE-TEXT 
              END-IF                                                    
                                                                        
              IF WS-UTIL-SEAS-CD-OLD GREATER THAN SPACES                
                 MOVE +03                   TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE WS-UTIL-SEAS-CD-OLD   TO MI-PRV-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT 
              END-IF                                                    
                                                                        
              IF MI-CHG-COLUMN-VALUE-TEXT = '*DELETED*' AND             
                 MI-PRV-COLUMN-VALUE-TEXT = '*NEW*'                     
                 MOVE SPACES                TO MI-TABLE-ID              
              END-IF                                                    
              MOVE 'B2'                     TO MI-TABLE-ID              
              MOVE 'SEASONAL USE CD'        TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                         TO MI-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
           IF UT-GAS-BASE-LAST-UPDT EQUAL LOW-VALUES                    
              MOVE SPACES                   TO UT-GAS-BASE-LAST-UPDT    
           END-IF                                                       
                                                                        
           IF UT-GAS-BASE-LAST-UPDT NOT EQUAL WS-CURR-GAS-BASE-LAST-UPD 
              AND WS-CURR-CODE-UTIL-TYPE = WS-GAS                       
              AND METERED-RATE                                          
      *                                           AND CSR-DATABASE              
              IF WS-CURR-GAS-BASE-LAST-UPD GREATER THAN SPACES          
                 MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN  
                 IF SEB-DATABASE                                        
                    MOVE +07                TO MI-CHG-COLUMN-VALUE-LEN  
                    STRING WS-CURR-GAS-BASE-LAST-UPD(1:4)               
                               DELIMITED BY SIZE                        
                           '/' DELIMITED BY SIZE                        
                           WS-CURR-GAS-BASE-LAST-UPD(6:2)               
                               DELIMITED BY SIZE                        
                      INTO MI-CHG-COLUMN-VALUE-TEXT                     
                    END-STRING                                          
                 ELSE                                                   
                    MOVE +10                TO MI-CHG-COLUMN-VALUE-LEN  
                    MOVE WS-CURR-GAS-BASE-LAST-UPD                      
                                            TO MI-CHG-COLUMN-VALUE-TEXT 
                 END-IF                                                 
              ELSE                                                      
                 IF WS-CURR-UPDT-ACTION-IND = 'U' OR 'D'                
                    MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN  
                    MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT 
                 ELSE                                                   
                    MOVE +01                TO MI-CHG-COLUMN-VALUE-LEN  
                    MOVE SPACES             TO MI-CHG-COLUMN-VALUE-TEXT 
                 END-IF                                                 
              END-IF                                                    
                                                                        
              IF UT-GAS-BASE-LAST-UPDT GREATER THAN SPACES              
                 MOVE +10                   TO MI-PRV-COLUMN-VALUE-LEN  
                 IF SEB-DATABASE                                        
                    MOVE +07                TO MI-PRV-COLUMN-VALUE-LEN  
                    STRING UT-GAS-BASE-LAST-UPDT(1:4) DELIMITED BY SIZE 
                           '/' DELIMITED BY SIZE                        
                           UT-GAS-BASE-LAST-UPDT(6:2) DELIMITED BY SIZE 
                      INTO MI-PRV-COLUMN-VALUE-TEXT                     
                    END-STRING                                          
                 ELSE                                                   
                    MOVE +10                TO MI-PRV-COLUMN-VALUE-LEN  
                    MOVE UT-GAS-BASE-LAST-UPDT                          
                                            TO MI-PRV-COLUMN-VALUE-TEXT 
                 END-IF                                                 
              ELSE                                                      
                 MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT 
              END-IF                                                    
                                                                        
              IF SEB-DATABASE                                           
                 MOVE 'GROUP2 MOVE DT'      TO MI-COLUMN-DESC           
              ELSE                                                      
                 MOVE 'BASE LAST UPDT '     TO MI-COLUMN-DESC           
              END-IF                                                    
                                                                        
              MOVE SPACES                   TO MI-TABLE-ID              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                         TO MI-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
           IF UT-GAS-BASE-USE IS NUMERIC                                
              CONTINUE                                                  
           ELSE                                                         
              MOVE ZERO                     TO UT-GAS-BASE-USE          
           END-IF                                                       
                                                                        
      *    ASSUMPTION IS UT-GAS-BASE-LAST-UPDT WILL HAVE SPACES WHEN            
      *    METER TURNED ON INITIALLY. WHEN RATE IS CHANGED TO 031 OR            
      *    032 DEFAULT SUMMBER BASE BASED ON RATE PLAN NO. DO NOT WANT          
      *    TO TOUCH FOR UPDATED ONES.                                           
                                                                        
           IF UT-GAS-BASE-LAST-UPDT EQUAL SPACES                        
              AND UT-CODE-UTIL-TYPE EQUAL WS-GAS                        
              AND METERED-RATE                                          
              PERFORM 7045-GET-GAS-BASE-DFLT   THRU 7045-EXIT           
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                 MOVE BR-GAS-BASE-USE-DFLT  TO WS-CURR-GAS-BASE-USE     
               ELSE                                                     
                 MOVE WS-ZERO               TO WS-CURR-GAS-BASE-USE     
              END-IF                                                    
           END-IF                                                       
                                                                        
           IF UT-GAS-BASE-USE NOT = WS-CURR-GAS-BASE-USE                
              AND WS-CURR-CODE-UTIL-TYPE = WS-GAS                       
              AND METERED-RATE                                          
                                                                        
              IF WS-CURR-GAS-BASE-USE GREATER THAN WS-ZERO              
                 MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE WS-CURR-GAS-BASE-USE  TO MI-CHG-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE '*DELETED*'           TO MI-CHG-COLUMN-VALUE-TEXT 
              END-IF                                                    
                                                                        
              IF UT-GAS-BASE-USE GREATER THAN WS-ZERO                   
                 MOVE +9                    TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE UT-GAS-BASE-USE       TO MI-PRV-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT 
              END-IF                                                    
                                                                        
              MOVE SPACES                   TO MI-TABLE-ID              
              MOVE 'GAS BASE USE '          TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                         TO MI-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
           IF UT-ZERO-USE-INVEST-DT EQUAL LOW-VALUES                    
              MOVE SPACES                   TO UT-ZERO-USE-INVEST-DT    
           END-IF                                                       
                                                                        
           IF UT-ZERO-USE-INVEST-DT NOT EQUAL WS-CURR-ZERO-USE-INVST-DT 
              AND METERED-RATE                                          
                                                                        
              IF WS-CURR-ZERO-USE-INVST-DT GREATER THAN SPACES          
                 MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE WS-CURR-ZERO-USE-INVST-DT                         
                                            TO MI-CHG-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 IF WS-CURR-UPDT-ACTION-IND = 'U' OR 'D'                
                    MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN  
                    MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT 
                 ELSE                                                   
                    MOVE +01                TO MI-CHG-COLUMN-VALUE-LEN  
                    MOVE SPACES             TO MI-CHG-COLUMN-VALUE-TEXT 
                 END-IF                                                 
              END-IF                                                    
                                                                        
              IF UT-ZERO-USE-INVEST-DT GREATER THAN SPACES              
                 MOVE +10                   TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE UT-ZERO-USE-INVEST-DT TO MI-PRV-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT 
              END-IF                                                    
                                                                        
              MOVE SPACES                   TO MI-TABLE-ID              
              MOVE 'ZRO USE NVST DT'        TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                         TO MI-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
           IF AT-BILL-CYCLE NOT EQUAL WS-CURR-BILL-CYCLE                
              MOVE WS-YES                   TO WS-BILL-CYCLE-CHANGE     
                                                                        
              IF WS-CURR-BILL-CYCLE GREATER THAN SPACES                 
                 MOVE +2                    TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE WS-CURR-BILL-CYCLE    TO MI-CHG-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE '*DELETED*'           TO MI-CHG-COLUMN-VALUE-TEXT 
              END-IF                                                    
                                                                        
              IF AT-BILL-CYCLE GREATER THAN SPACES                      
                 MOVE +2                    TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE AT-BILL-CYCLE         TO MI-PRV-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT 
              END-IF                                                    
                                                                        
              MOVE SPACES                   TO MI-TABLE-ID              
              MOVE 'BILL CYCLE     '        TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                         TO MI-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
A05065     IF (WS-BILL-CYCLE-CHANGE EQUAL WS-YES AND                    
A05065        METERED-RATE AND (WS-CURR-UPDT-ACTION-IND = 'U' OR 'D'))  
A05065        IF WS-CURR-UPDT-ACTION-IND = 'U'                          
                 MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT 
                 MOVE +1                    TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE WS-CURR-PRORATE-CD    TO MI-CHG-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 IF WS-CURR-UPDT-ACTION-IND = 'D'                       
                    MOVE +1                 TO MI-PRV-COLUMN-VALUE-LEN  
                    MOVE WS-CURR-PRORATE-CD TO MI-PRV-COLUMN-VALUE-TEXT 
                    MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN  
                    MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT 
                 END-IF                                                 
              END-IF                                                    
              MOVE SPACES                   TO MI-TABLE-ID              
              MOVE 'PRORATE CD     '        TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                         TO MI-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
A05065     IF (WS-ROUTE-CYCLE-CHANGE EQUAL WS-YES AND                   
A05065        METERED-RATE AND (WS-CURR-UPDT-ACTION-IND = 'U' OR 'D'))  
A05065        IF WS-CURR-UPDT-ACTION-IND = 'U'                          
                 MOVE +18                   TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE 'ROUTE/CYCLE CHANGE'  TO MI-PRV-COLUMN-VALUE-TEXT 
                 MOVE +1                    TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE WS-ZERO               TO MI-CHG-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 IF WS-CURR-UPDT-ACTION-IND = 'D'                       
                    MOVE +18                TO MI-PRV-COLUMN-VALUE-LEN  
                    MOVE 'ROUTE/CYCLE CHANGE'                           
                                            TO MI-PRV-COLUMN-VALUE-TEXT 
                    MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN  
                    MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT 
                 END-IF                                                 
              END-IF                                                    
              MOVE SPACES                   TO MI-TABLE-ID              
              MOVE 'REGISTER-RD-SEQ'        TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                         TO MI-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
       5200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               * 16660000
      * 5300-WRITE-TRANS-DISC-OK.                                     *         
      *****************************************************************         
       5300-WRITE-TRANS-DISC-OK.                                        
                                                                        
           IF WS-PREV-CODE-DISC-OK NOT = AT-CODE-DISC-OK                
                                                                        
              IF WS-PREV-CODE-DISC-OK <= SPACES                         
                 MOVE +1                   TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE SPACES               TO MI-PRV-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +1                   TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE WS-PREV-CODE-DISC-OK TO MI-PRV-COLUMN-VALUE-TEXT  
              END-IF                                                    
                                                                        
              IF AT-CODE-DISC-OK > SPACES                               
                 MOVE +1                   TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE AT-CODE-DISC-OK      TO MI-CHG-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +1                   TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE SPACES               TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
                                                                        
              MOVE 'DISCONNECT EXMPTN'     TO MI-COLUMN-DESC            
              MOVE '12'                    TO MI-TABLE-ID               
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1                        TO MI-TRAN-APPL-NO           
           END-IF.                                                      
                                                                        
       5300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               * 16660000
      * 5400-WRITE-TRANS-SUBDSN-LGHT.                                 *         
      *****************************************************************         
       5400-WRITE-TRANS-SUBDSN-LGHT.                                    
                                                                        
           MOVE +03                         TO MI-PRV-COLUMN-VALUE-LEN. 
           MOVE WS-SUBDVSN-LIGHT            TO MI-PRV-COLUMN-VALUE-TEXT.
           MOVE +9                          TO MI-CHG-COLUMN-VALUE-LEN. 
           MOVE '*DELETED*'                 TO MI-CHG-COLUMN-VALUE-TEXT.
           MOVE SPACES                      TO MI-TABLE-ID.             
           MOVE 'RATE PLAN NO   '           TO MI-COLUMN-DESC.          
           PERFORM 6530-LOAD-MNT-TRANS-HIST    THRU 6530-EXIT.          
           ADD 1                            TO MI-TRAN-APPL-NO.         
                                                                        
           MOVE MI-TRAN-APPL-NO             TO MI-TRAN-APPL-NO.         
           MOVE WS-SUBDVSN-LIGHT            TO RD-RATE-PLAN-NO.         
           MOVE 'U'                         TO RD-CODE-UTIL-TYPE.       
           PERFORM 7025-GET-RATE-DTLS          THRU 7025-EXIT.          
           MOVE LENGTH OF RD-RATE-DESC      TO MI-PRV-COLUMN-VALUE-LEN  
           MOVE SPACES                      TO MI-TABLE-ID.             
           MOVE RD-RATE-DESC                TO MI-PRV-COLUMN-VALUE-TEXT.
           MOVE 'RATE PLAN DESC   ' TO MI-COLUMN-DESC.                  
           PERFORM 6530-LOAD-MNT-TRANS-HIST    THRU 6530-EXIT.          
           ADD 1                            TO MI-TRAN-APPL-NO.         
                                                                        
       5400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               * 16660000
      * 5500-WRITE-TRANS-ACCT-TYPE.                                   *         
      *****************************************************************         
       5500-WRITE-TRANS-ACCT-TYPE.                                      
                                                                        
           MOVE AT-ACCOUNT-TYPE-CODE        TO MI-PRV-COLUMN-VALUE-TEXT 
           MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
                                            TO MI-PRV-COLUMN-VALUE-LEN  
           MOVE WS-CPD118-ACCT-TYPE-CODE    TO MI-CHG-COLUMN-VALUE-TEXT 
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                            TO MI-CHG-COLUMN-VALUE-LEN  
                                                                        
           MOVE 'N9'                        TO MI-TABLE-ID              
           MOVE 'ACCT_TYPE_CODE'            TO MI-COLUMN-DESC           
           PERFORM 6530-LOAD-MNT-TRANS-HIST    THRU 6530-EXIT           
           ADD 1                            TO MI-TRAN-APPL-NO.         
                                                                        
       5500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 6000-GET-ACCT-TYPE-CODE-CPD118                                 *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CPD00118                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *                                                                *        
      * 6999-CPD118-ERROR-ROUTINE.                                     *        
      ******************************************************************        
       6999-CPD118-ERROR-ROUTINE.                                       
                                                                        
           PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT.              
                                                                        
       6999-CPD118-EXIT.                                                
           EXIT.                                                        
      ******************************************************************        
      *                                                                *        
      * 6100-CALL-CREATE-WQ-SP.                                       *         
      ******************************************************************        
       6100-CALL-CREATE-WQ-SP.                                          
                                                                        
ACT233*    EXEC SQL CALL CSR04675                                       
      *                ( :WQ-ITEM-ID                                    
ACT233*                 ,:ROUTING-CATEGORY-4675                         
ACT233*                 ,:LOCAL-OFFICE-4675                             
ACT233*                 ,:WQ-USER-ID-ORIG                               
      *                 ,:WQ-USER-ID-ASGN                               
ACT233*                 ,:WQ-RESP-AREA-ID                               
ACT233*                 ,:WQ-CATEGORY-ID                                
ACT233*                 ,:WQ-ACCOUNT-NO                                 
ACT233*                 ,:WQ-PREMISE-NO                                 
ACT233*                 ,:WQ-CUSTOMER-NO                                
ACT233*                 ,:WQ-SERV-ORDER-NO                              
ACT233*                 ,:WQ-COMMENTS                                   
ACT233*                 ,:WQ-DATE-REQUIRED                              
ACT233*                 ,:WQ-DATE-CREATED                               
ACT233*                 ,:WQ-PRIORITY                                   
ACT233*                 ,:WQ-FREE-FORM-AREA                             
ACT233*                 ,:WQ-CREATED-BY                                 
      *                )                                                
      *    END-EXEC.                                                    
MSQ001        EXEC SQL
MSQ001          CLOSE C2
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN C2
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR C2 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF.
                                                    
                                                                        
       6100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 6530-LOAD-MNT-TRANS-HIST.                                     *         
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7000-GET-DELINQ-VALUE.                                     *            
      ******************************************************************        
       7000-GET-DELINQ-VALUE.                                           
                                                                        
           EXEC SQL                                                     
              SELECT C8.DELINQ_VALUE                                    
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY C8 WITH(READUNCOMMITTED)                   
               WHERE C8.DELINQ_CD  = :C8-DELINQ-CD                      
                 AND C8.COMPANY_NO = :C8-COMPANY-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT C8.DELINQ_VALUE                                            
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY C8                                         
MFA-TR*        WHERE C8.DELINQ_CD  = :C8-DELINQ-CD                              
MFA-TR*          AND C8.COMPANY_NO = :C8-COMPANY-NO                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7000                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7000'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_DELINQUENCY'        TO TABLE-1                  
              MOVE 'DELINQ_CD'              TO TABLE-ELEMENT-1          
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-2          
              MOVE C8-DELINQ-CD             TO HOSTVAR-ELEMENT-1        
              MOVE C8-COMPANY-NO            TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7005-VALDAT-REV-CLS-RATE.                                      *        
      ******************************************************************        
       7005-VALDAT-REV-CLS-RATE.                                        
                                                                        
           EXEC SQL                                                     
              SELECT 'Y'                                                
                INTO :WS-REV-CLS-STATUS                                 
                FROM CSS_REV_CLS_RATE Q8 WITH(READUNCOMMITTED)                  
               WHERE Q8.RATE_PLAN_NO       = :Q8-RATE-PLAN-NO           
                 AND Q8.CODE_REVENUE_CLASS = :Q8-CODE-REVENUE-CLASS     
                 AND Q8.CODE_UTIL_TYPE     = :Q8-CODE-UTIL-TYPE         
                 AND Q8.COMPANY_NO         = :Q8-COMPANY-NO             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-REV-CLS-STATUS                                         
MFA-TR*         FROM CSS_REV_CLS_RATE Q8                                        
MFA-TR*        WHERE Q8.RATE_PLAN_NO       = :Q8-RATE-PLAN-NO                   
MFA-TR*          AND Q8.CODE_REVENUE_CLASS = :Q8-CODE-REVENUE-CLASS             
MFA-TR*          AND Q8.CODE_UTIL_TYPE     = :Q8-CODE-UTIL-TYPE                 
MFA-TR*          AND Q8.COMPANY_NO         = :Q8-COMPANY-NO                     
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7005                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7005'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_REV_CLS_RATE'       TO TABLE-1                  
              MOVE 'RATE_PLAN_NO'           TO TABLE-ELEMENT-1          
              MOVE 'CODE_REVENUE_CLASS'     TO TABLE-ELEMENT-2          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-3          
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-4          
              MOVE Q8-RATE-PLAN-NO          TO HOSTVAR-ELEMENT-1        
              MOVE Q8-CODE-REVENUE-CLASS    TO HOSTVAR-ELEMENT-2        
              MOVE Q8-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-3        
              MOVE Q8-COMPANY-NO            TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7005-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7010-GET-RULE-XREF-ID.                                         *        
      ******************************************************************        
       7010-GET-RULE-XREF-ID.                                           
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           BUS_RULE_XREF_ID, 121), ' ', '-'), ':', '.') 
           BUS_RULE_XREF_ID                                   
                INTO :S-BUS-RULE-XREF-ID                                
                FROM CSS_BUS_RULE   [1R] WITH(READUNCOMMITTED)                  
                    ,CSS_BUS_RULE_XREF [1T] WITH(READUNCOMMITTED)               
               WHERE [1R].BUS_RULE_ID = :S-BUS-RULE-ID                    
                 AND [1R].BUS_RULE_ID = [1T].BUS_RULE_ID                    
                                             
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BUS_RULE_XREF_ID                                           
MFA-TR*         INTO :S-BUS-RULE-XREF-ID                                        
MFA-TR*         FROM CSS_BUS_RULE   1R                                          
MFA-TR*             ,CSS_BUS_RULE_XREF 1T                                       
MFA-TR*        WHERE 1R.BUS_RULE_ID = :S-BUS-RULE-ID                            
MFA-TR*          AND 1R.BUS_RULE_ID = 1T.BUS_RULE_ID                            
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7010                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               MOVE SPACES                TO ABEND-TABLES               
               MOVE SPACES                TO ABEND-SQL-PREDICATES       
               MOVE '7010'                TO ACTIVE-PARAGRAPH           
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_BUS_RULE'        TO TABLE-1                    
               MOVE 'BUS_RULE_ID'         TO TABLE-ELEMENT-1            
               MOVE S-BUS-RULE-ID         TO HOSTVAR-ELEMENT-1          
               PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7015-GET-RESP-AREA-ID.                                         *        
      ******************************************************************        
       7015-GET-RESP-AREA-ID.                                           
                                                                        
           EXEC SQL                                                     
               SELECT RESP_AREA_ID                                      
                 INTO :WS-RESP-AREA-ID                                  
                 FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                    
                WHERE USER_ID = :WS-CURR-USER-ID                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RESP_AREA_ID                                              
MFA-TR*          INTO :WS-RESP-AREA-ID                                          
MFA-TR*          FROM CSS_USER_PROFILE                                          
MFA-TR*         WHERE USER_ID = :WS-CURR-USER-ID                                
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7015                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7015'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT '                TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_USER_PROFILE  '     TO TABLE-1                  
              MOVE 'USER_ID'                TO TABLE-ELEMENT-1          
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-2          
              MOVE WS-CURR-USER-ID          TO HOSTVAR-ELEMENT-1        
              MOVE WS-CURR-ACCOUNT-NO       TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7015-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7020-GET-CURR-TIMESTAMP                                        *        
      ******************************************************************        
       7020-GET-CURR-TIMESTAMP.                                         
                                                                        
           EXEC SQL                                                     
               SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :MH-TRANS-HIST-SEQ-NO,
              :WS-CURRENT-TIMESTAMP,
              :MH-DATE-TRANS,
              :WS-CURRENT-DATE                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :MH-TRANS-HIST-SEQ-NO = CURRENT TIMESTAMP                    
MFA-TR*           ,:WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                    
MFA-TR*           ,:MH-DATE-TRANS        = CURRENT DATE                         
MFA-TR*           ,:WS-CURRENT-DATE      = CURRENT DATE                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SPACES                   TO ABEND-TABLES             
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
              MOVE '7020'                   TO ACTIVE-PARAGRAPH         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7025-GET-RATE-DTLS.                                            *        
      ******************************************************************        
       7025-GET-RATE-DTLS.                                              
                                                                        
           EXEC SQL                                                     
              SELECT RD.RATE_DESC                                       
                    ,RD.UNMTR_PROV_FL                                   
                INTO :RD-RATE-DESC                                      
                    ,:RD-UNMTR-PROV-FL                                  
                FROM CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED)                
               WHERE RD.RATE_PLAN_NO     = :RD-RATE-PLAN-NO             
                 AND RD.CODE_UTIL_TYPE   = :RD-CODE-UTIL-TYPE           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RD.RATE_DESC                                               
MFA-TR*             ,RD.UNMTR_PROV_FL                                           
MFA-TR*         INTO :RD-RATE-DESC                                              
MFA-TR*             ,:RD-UNMTR-PROV-FL                                          
MFA-TR*         FROM CSS_RATE_PLAN_DESC RD                                      
MFA-TR*        WHERE RD.RATE_PLAN_NO     = :RD-RATE-PLAN-NO                     
MFA-TR*          AND RD.CODE_UTIL_TYPE   = :RD-CODE-UTIL-TYPE                   
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7025                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7025'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_RATE_PLAN_DESC'     TO TABLE-1                  
              MOVE 'RATE_PLAN_NO'           TO TABLE-ELEMENT-1          
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-2          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-3          
              MOVE RD-RATE-PLAN-NO          TO HOSTVAR-ELEMENT-1        
              MOVE WS-CURR-COMPANY-NO       TO HOSTVAR-ELEMENT-2        
              MOVE RD-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7025-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      *                                                              *          
      * EWNA CODE WILL NOT BE USED ANY MORE AND FIELD WILL BECOME    *          
      * INVISIBLE IN SCREEN.                                         *          
      *                                                              *          
      ****************************************************************          
      ******************************************************************        
      *                                                                *        
      * 7030-GET-GROUP-DESC.                                           *        
      ******************************************************************        
      *7030-GET-GROUP-DESC.                                                     
      *                                                                         
      *    EXEC SQL                                                             
      *       SELECT UV.CODE_VALUE                                              
      *             ,UV.CODE_LONG_DESC                                          
      *         INTO :UV-CODE-VALUE                                             
      *             ,:UV-CODE-LONG-DESC                                         
      *         FROM CSS_CODE_VALUE UV                                          
      *             ,CSS_REV_CLS_RATE Q8                                        
      *        WHERE UV.TABLE_NA           = 'CSS_ELEC_WNA_PARMS'               
      *          AND UV.COLUMN_NA          = 'ELEC_WNA_GROUP_NO'                
      *          AND UV.START_DT          <= CURRENT DATE                       
      *          AND UV.END_DATE          >= CURRENT DATE                       
      *          AND Q8.RATE_PLAN_NO       = :Q8-RATE-PLAN-NO                   
      *          AND Q8.CODE_REVENUE_CLASS = :Q8-CODE-REVENUE-CLASS             
      *          AND Q8.CODE_UTIL_TYPE     = :WS-ELECTRIC                       
      *          AND Q8.ELEC_WNA_GROUP_NO  = INT(UV.CODE_VALUE)                 
      *         WITH UR                                                         
      *      QUERYNO 7030                                                       
      *    END-EXEC.                                                            
      *                                                                         
      *    MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.           
      *                                                                         
      *    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND              
      *       CONTINUE                                                          
      *    ELSE                                                                 
      *       MOVE PROGRAM-NAME             TO ABEND-PROGRAM                    
      *       MOVE '7030'                   TO ACTIVE-PARAGRAPH                 
      *       MOVE 'SELECT'                 TO ABEND-FUNCTION                   
      *       MOVE SPACES                   TO ABEND-SQL-PREDICATES             
      *                                        ABEND-TABLES                     
      *       MOVE 'CSS_CODE_VALUE'         TO TABLE-1                          
      *       MOVE 'CSS_REV_CLS_RATE'       TO TABLE-2                          
      *       MOVE 'RATE_PLAN_NO'           TO TABLE-ELEMENT-1                  
      *       MOVE 'CODE_REVENUE_CLASS'     TO TABLE-ELEMENT-2                  
      *       MOVE Q8-RATE-PLAN-NO          TO HOSTVAR-ELEMENT-1                
      *       MOVE Q8-CODE-REVENUE-CLASS    TO HOSTVAR-ELEMENT-2                
      *       PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT                   
      *    END-IF.                                                              
      *                                                                         
      *7030-EXIT.                                                               
      *    EXIT.                                                                
      *                                                                         
      ******************************************************************        
      *                                                               *         
      * 7035-GET-MTR-RD-FREQ-DESC.                                     *        
      ******************************************************************        
       7035-GET-MTR-RD-FREQ-DESC.                                       
                                                                        
           EXEC SQL                                                     
              SELECT UV.CODE_SHORT_DESC                                 
               INTO :UV-CODE-SHORT-DESC                                 
               FROM CSS_CODE_VALUE UV WITH(READUNCOMMITTED)                     
              WHERE UV.CODE_VALUE     = :UV-CODE-VALUE                  
                AND UV.COLUMN_NA      = :UV-COLUMN-NA                   
                AND UV.COMPANY_NO     = :UV-COMPANY-NO                  
                AND UV.PROGRAM_ID     = :UV-PROGRAM-ID                  
                AND UV.TABLE_NA       = :UV-TABLE-NA                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT UV.CODE_SHORT_DESC                                         
MFA-TR*        INTO :UV-CODE-SHORT-DESC                                         
MFA-TR*        FROM CSS_CODE_VALUE UV                                           
MFA-TR*       WHERE UV.CODE_VALUE     = :UV-CODE-VALUE                          
MFA-TR*         AND UV.COLUMN_NA      = :UV-COLUMN-NA                           
MFA-TR*         AND UV.COMPANY_NO     = :UV-COMPANY-NO                          
MFA-TR*         AND UV.PROGRAM_ID     = :UV-PROGRAM-ID                          
MFA-TR*         AND UV.TABLE_NA       = :UV-TABLE-NA                            
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7035                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7920'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_CODE_VALUE'         TO TABLE-1                  
              MOVE 'CODE_VALUE'             TO TABLE-ELEMENT-1          
              MOVE 'COLUMN_NA '             TO TABLE-ELEMENT-2          
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-3          
              MOVE 'TABLE_NA'               TO TABLE-ELEMENT-4          
              MOVE UV-CODE-VALUE            TO HOSTVAR-ELEMENT-1        
              MOVE UV-COLUMN-NA             TO HOSTVAR-ELEMENT-2        
              MOVE UV-COMPANY-NO            TO HOSTVAR-ELEMENT-3        
              MOVE UV-TABLE-NA              TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7035-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                               *         
      * 7040-SELECT-SIC-DESC.                                          *        
      ******************************************************************        
       7040-SELECT-SIC-DESC.                                            
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) CIS.SUBSTR3((CODE_SIC_NO + '-' + 
           SIC_LONG_DESC),1,75) 
                INTO :WS-SIC-LONG-DESC                                  
                FROM CSS_SIC R1 WITH(READUNCOMMITTED)                           
               WHERE R1.CODE_SIC_NO = :R1-CODE-SIC-NO                   
                                                    
                                                                 
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SUBSTR((CODE_SIC_NO || '-' || SIC_LONG_DESC),1,75)         
MFA-TR*         INTO :WS-SIC-LONG-DESC                                          
MFA-TR*         FROM CSS_SIC R1                                                 
MFA-TR*        WHERE R1.CODE_SIC_NO = :R1-CODE-SIC-NO                           
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7040                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7040'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_SIC'                TO TABLE-1                  
              MOVE 'CODE_SIC_NO'            TO TABLE-ELEMENT-1          
              MOVE R1-CODE-SIC-NO           TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7040-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7045-SELECT-GASBASE-DEFAULT                                    *        
      ******************************************************************        
       7045-GET-GAS-BASE-DFLT.                                          
                                                                        
           EXEC SQL                                                     
              SELECT BR.GAS_BASE_USE_DFLT                               
                INTO :BR-GAS-BASE-USE-DFLT                              
                FROM CSS_BTU_WNA_RANGE BR WITH(READUNCOMMITTED)                 
               WHERE CODE_UTIL_TYPE  = :BR-CODE-UTIL-TYPE               
                 AND RATE_PLAN_NO    = :BR-RATE-PLAN-NO                 
                 AND BR.EFFECTIVE_DT =                                  
                          (SELECT MAX(B1.EFFECTIVE_DT)                  
                          FROM CSS_BTU_WNA_RANGE B1
                           WITH(READUNCOMMITTED)                     
                         WHERE B1.CODE_UTIL_TYPE = :BR-CODE-UTIL-TYPE   
                           AND B1.RATE_PLAN_NO   = :BR-RATE-PLAN-NO     
                           AND B1.EFFECTIVE_DT  <= 
           CAST(SYSDATETIMEOFFSET() AS DATE))        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BR.GAS_BASE_USE_DFLT                                       
MFA-TR*         INTO :BR-GAS-BASE-USE-DFLT                                      
MFA-TR*         FROM CSS_BTU_WNA_RANGE BR                                       
MFA-TR*        WHERE CODE_UTIL_TYPE  = :BR-CODE-UTIL-TYPE                       
MFA-TR*          AND RATE_PLAN_NO    = :BR-RATE-PLAN-NO                         
MFA-TR*          AND BR.EFFECTIVE_DT =                                          
MFA-TR*                   (SELECT MAX(B1.EFFECTIVE_DT)                          
MFA-TR*                   FROM CSS_BTU_WNA_RANGE B1                             
MFA-TR*                  WHERE B1.CODE_UTIL_TYPE = :BR-CODE-UTIL-TYPE           
MFA-TR*                    AND B1.RATE_PLAN_NO   = :BR-RATE-PLAN-NO             
MFA-TR*                    AND B1.EFFECTIVE_DT  <= CURRENT DATE)                
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7045                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL OR NOT-FOUND     
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7045'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_BTU_WNA_RANGE'   TO TABLE-1                     
              MOVE 'CODE-UTIL-TYPE'      TO TABLE-ELEMENT-1             
              MOVE 'RATE-PLAN-NO'        TO TABLE-ELEMENT-2             
              MOVE BR-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-1           
              MOVE BR-RATE-PLAN-NO       TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       7045-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7050-SELECT-NAICS-DESC.                                        *        
      ******************************************************************        
       7050-SELECT-NAICS-DESC.                                          
                                                                        
           EXEC SQL                                                     
              SELECT CIS.SUBSTR3((NAICS_CD + '-' + 
           NAICS_LONG_DESC),1,75)  
                INTO :WS-NAICS-LONG-DESC                                
                FROM CSS_SIC R1 WITH(READUNCOMMITTED)                           
               WHERE R1.CODE_SIC_NO = :R1-CODE-SIC-NO                   
                 AND R1.NAICS_CD    = :R1-NAICS-CD                      
                                                                 
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SUBSTR((NAICS_CD || '-' || NAICS_LONG_DESC),1,75)          
MFA-TR*         INTO :WS-NAICS-LONG-DESC                                        
MFA-TR*         FROM CSS_SIC R1                                                 
MFA-TR*        WHERE R1.CODE_SIC_NO = :R1-CODE-SIC-NO                           
MFA-TR*          AND R1.NAICS_CD    = :R1-NAICS-CD                              
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7050                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7050'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_SIC'             TO TABLE-1                     
              MOVE 'CODE_SIC_NO'         TO TABLE-ELEMENT-1             
              MOVE 'NAICS_CD'            TO TABLE-ELEMENT-2             
              MOVE R1-CODE-SIC-NO        TO HOSTVAR-ELEMENT-1           
              MOVE R1-NAICS-CD           TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7055-GET-MAX-IC-NO.                                            *        
      ******************************************************************        
       7055-GET-MAX-IC-NO.                                              
                                                                        
           EXEC SQL                                                     
              SELECT COALESCE(MAX(IC_NO), 0) + 1                        
                INTO :UT-IC-NO                                          
                FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                  
               WHERE UT.ACCOUNT_NO     = :UT-ACCOUNT-NO                 
                 AND UT.CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COALESCE(MAX(IC_NO), 0) + 1                                
MFA-TR*         INTO :UT-IC-NO                                                  
MFA-TR*         FROM CSS_UTIL_ENVRNMT UT                                        
MFA-TR*        WHERE UT.ACCOUNT_NO     = :UT-ACCOUNT-NO                         
MFA-TR*          AND UT.CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE                     
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7055                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7055'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_UTIL_ENVRNMT'    TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2             
              MOVE UT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE UT-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       7055-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7060-GET-AVALIABLE-IND.                                                 
      ******************************************************************        
       7060-GET-AVALIABLE-IND.                                          
                                                                        
           EXEC SQL                                                     
              SELECT PR.ELEC_AVAILABLE_IND                              
                    ,PR.GAS_AVAILABLE_IND                               
                    ,PR.LITE_AVAILABLE_IND                              
                INTO :PR-ELEC-AVAILABLE-IND                             
                    ,:PR-GAS-AVAILABLE-IND                              
                    ,:PR-LITE-AVAILABLE-IND                             
                FROM CSS_PREMISE PR WITH(READUNCOMMITTED)                       
               WHERE PR.PREMISE_NO = :PR-PREMISE-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT PR.ELEC_AVAILABLE_IND                                      
MFA-TR*             ,PR.GAS_AVAILABLE_IND                                       
MFA-TR*             ,PR.LITE_AVAILABLE_IND                                      
MFA-TR*         INTO :PR-ELEC-AVAILABLE-IND                                     
MFA-TR*             ,:PR-GAS-AVAILABLE-IND                                      
MFA-TR*             ,:PR-LITE-AVAILABLE-IND                                     
MFA-TR*         FROM CSS_PREMISE PR                                             
MFA-TR*        WHERE PR.PREMISE_NO = :PR-PREMISE-NO                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7060                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7060'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_PREMISE'         TO TABLE-1                     
              MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1             
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2             
              MOVE PR-PREMISE-NO         TO HOSTVAR-ELEMENT-1           
              MOVE WS-CURR-ACCOUNT-NO    TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       7060-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7065-GET-MTRD-ENVRNMT-DET.                                              
      ******************************************************************        
       7065-GET-MTRD-ENVRNMT-DET.                                       
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) MN.METER_NO,
              MN.DIGTL_MTR_TYPE,
              MN.PROGRAM_ID                                      
                INTO :MN-METER-NO                                       
                    ,:MN-DIGTL-MTR-TYPE                                 
                    ,:MN-PROGRAM-ID                                     
                FROM CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)                  
               WHERE MN.ACCOUNT_NO          = :MN-ACCOUNT-NO            
                 AND MN.CODE_UTIL_TYPE      = :MN-CODE-UTIL-TYPE        
                 AND MN.IC_NO               = :MN-IC-NO                 
                 AND MN.CODE_METER_STATUS <> 'K'                        
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MN.METER_NO                                                
MFA-TR*             ,MN.DIGTL_MTR_TYPE                                          
MFA-TR*             ,MN.PROGRAM_ID                                              
MFA-TR*         INTO :MN-METER-NO                                               
MFA-TR*             ,:MN-DIGTL-MTR-TYPE                                         
MFA-TR*             ,:MN-PROGRAM-ID                                             
MFA-TR*         FROM CSS_MTRD_ENVRNMT MN                                        
MFA-TR*        WHERE MN.ACCOUNT_NO          = :MN-ACCOUNT-NO                    
MFA-TR*          AND MN.CODE_UTIL_TYPE      = :MN-CODE-UTIL-TYPE                
MFA-TR*          AND MN.IC_NO               = :MN-IC-NO                         
MFA-TR*          AND MN.CODE_METER_STATUS <> 'K'                                
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7065                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7065'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_MTRD_ENVRNMT'    TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2             
              MOVE 'IC_NO'               TO TABLE-ELEMENT-3             
              MOVE MN-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE MN-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2           
              MOVE MN-IC-NO              TO HOSTVAR-ELEMENT-3           
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       7065-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7070-VLDT-DMT-PGM-ID.                                          *        
      ******************************************************************        
       7070-VLDT-DMT-PGM-ID.                                            
                                                                        
           EXEC SQL                                                     
              SELECT 'Y'                                                
                INTO :WS-RATE-EXIST                                     
                FROM CSS_DMT_PGM_ID T2 WITH(READUNCOMMITTED)                    
               WHERE T2.CODE_UTIL_TYPE    = :T2-CODE-UTIL-TYPE          
                 AND T2.DIGTL_MTR_TYPE    = :T2-DIGTL-MTR-TYPE          
                 AND T2.PROGRAM_ID        = :T2-PROGRAM-ID              
                 AND T2.RATE_PLAN_NO      = :T2-RATE-PLAN-NO            
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-RATE-EXIST                                             
MFA-TR*         FROM CSS_DMT_PGM_ID T2                                          
MFA-TR*        WHERE T2.CODE_UTIL_TYPE    = :T2-CODE-UTIL-TYPE                  
MFA-TR*          AND T2.DIGTL_MTR_TYPE    = :T2-DIGTL-MTR-TYPE                  
MFA-TR*          AND T2.PROGRAM_ID        = :T2-PROGRAM-ID                      
MFA-TR*          AND T2.RATE_PLAN_NO      = :T2-RATE-PLAN-NO                    
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7070                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7070'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_DMT_PGM_ID'      TO TABLE-1                     
              MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-1             
              MOVE 'DIGTL_MTR_TYPE'      TO TABLE-ELEMENT-2             
              MOVE 'PROGRAM_ID'          TO TABLE-ELEMENT-3             
              MOVE 'RATE_PLAN_NO'        TO TABLE-ELEMENT-4             
              MOVE T2-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-1           
              MOVE T2-DIGTL-MTR-TYPE     TO HOSTVAR-ELEMENT-2           
              MOVE T2-PROGRAM-ID         TO HOSTVAR-ELEMENT-3           
              MOVE T2-RATE-PLAN-NO       TO HOSTVAR-ELEMENT-4           
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       7070-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7074-GET-ALT-FUEL-DESC                                         *        
      ******************************************************************        
       7074-GET-ALT-FUEL-DESC.                                          
                                                                        
           EXEC SQL                                                     
              SELECT W0.ALTERNATE_FUEL_TX                               
                INTO :W0-ALTERNATE-FUEL-TX                              
                FROM CSS_ALTN_FUEL_TYPE        W0 WITH(READUNCOMMITTED)         
               WHERE W0.ALTERNATE_FUEL_CD   = :W0-ALTERNATE-FUEL-CD     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT W0.ALTERNATE_FUEL_TX                                       
MFA-TR*         INTO :W0-ALTERNATE-FUEL-TX                                      
MFA-TR*         FROM CSS_ALTN_FUEL_TYPE        W0                               
MFA-TR*        WHERE W0.ALTERNATE_FUEL_CD   = :W0-ALTERNATE-FUEL-CD             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7074                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7074'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_ALTN_FUEL_TYPE'  TO TABLE-1                     
              MOVE 'ALTERNATE_FUEL_CD'   TO TABLE-ELEMENT-1             
              MOVE W0-ALTERNATE-FUEL-CD  TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       7074-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7075-GET-SVC-CAT-DESC.                                         *        
      ******************************************************************        
       7075-GET-SVC-CAT-DESC.                                           
                                                                        
           EXEC SQL                                                     
              SELECT Z4.PRTY_SVC_CAT_DESC                               
                INTO :Z4-PRTY-SVC-CAT-DESC                              
                FROM CSS_PRTY_SVC_CAT Z4 WITH(READUNCOMMITTED)                  
               WHERE Z4.PRTY_SVC_CAT_CD     = :WS-PRTY-SVC-CAT-CD       
                 AND Z4.COMPANY_NO          = :WS-CURR-COMPANY-NO       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT Z4.PRTY_SVC_CAT_DESC                                       
MFA-TR*         INTO :Z4-PRTY-SVC-CAT-DESC                                      
MFA-TR*         FROM CSS_PRTY_SVC_CAT Z4                                        
MFA-TR*        WHERE Z4.PRTY_SVC_CAT_CD     = :WS-PRTY-SVC-CAT-CD               
MFA-TR*          AND Z4.COMPANY_NO          = :WS-CURR-COMPANY-NO               
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7075                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7075'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_PRTY_SVC_CAT'    TO TABLE-1                     
              MOVE 'PRTY_SVC_CAT_CD'     TO TABLE-ELEMENT-1             
              MOVE 'COMAPNY_NO'          TO TABLE-ELEMENT-2             
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-3             
              MOVE WS-PRTY-SVC-CAT-CD    TO HOSTVAR-ELEMENT-1           
              MOVE WS-CURR-COMPANY-NO    TO HOSTVAR-ELEMENT-2           
              MOVE WS-CURR-ACCOUNT-NO    TO HOSTVAR-ELEMENT-3           
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       7075-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7076-GET-REV-CLS-DESC.                                         *        
      ******************************************************************        
       7076-GET-REV-CLS-DESC.                                           
                                                                        
           EXEC SQL                                                     
              SELECT F3.REVENUE_CLS_DESC                                
                INTO :F3-REVENUE-CLS-DESC                               
                FROM CSS_REVENUE_CLASS         F3 WITH(READUNCOMMITTED)         
               WHERE F3.CODE_REVENUE_CLASS  = :F3-CODE-REVENUE-CLASS    
                 AND F3.COMPANY_NO          = :F3-COMPANY-NO            
                 AND F3.CODE_UTIL_TYPE      = :F3-CODE-UTIL-TYPE        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT F3.REVENUE_CLS_DESC                                        
MFA-TR*         INTO :F3-REVENUE-CLS-DESC                                       
MFA-TR*         FROM CSS_REVENUE_CLASS         F3                               
MFA-TR*        WHERE F3.CODE_REVENUE_CLASS  = :F3-CODE-REVENUE-CLASS            
MFA-TR*          AND F3.COMPANY_NO          = :F3-COMPANY-NO                    
MFA-TR*          AND F3.CODE_UTIL_TYPE      = :F3-CODE-UTIL-TYPE                
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7076                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7076'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_REVENUE_CLASS'   TO TABLE-1                     
              MOVE 'CODE_REVENUE_CLASS'  TO TABLE-ELEMENT-1             
              MOVE 'COMAPNY_NO'          TO TABLE-ELEMENT-2             
              MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-3             
              MOVE F3-CODE-REVENUE-CLASS TO HOSTVAR-ELEMENT-1           
              MOVE F3-COMPANY-NO         TO HOSTVAR-ELEMENT-2           
              MOVE F3-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-3           
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       7076-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7080-GET-CURTAIL-PRTY.                                         *        
      ******************************************************************        
       7080-GET-CURTAIL-PRTY.                                           
                                                                        
           EXEC SQL                                                     
              SELECT Z4.CODE_CURTAIL_PRTY                               
                INTO :Z4-CODE-CURTAIL-PRTY                              
                FROM CSS_PRTY_SVC_CAT Z4 WITH(READUNCOMMITTED)                  
               WHERE Z4.PRTY_SVC_CAT_CD    = :Z4-PRTY-SVC-CAT-CD        
                 AND Z4.COMPANY_NO         = :Z4-COMPANY-NO             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT Z4.CODE_CURTAIL_PRTY                                       
MFA-TR*         INTO :Z4-CODE-CURTAIL-PRTY                                      
MFA-TR*         FROM CSS_PRTY_SVC_CAT Z4                                        
MFA-TR*        WHERE Z4.PRTY_SVC_CAT_CD    = :Z4-PRTY-SVC-CAT-CD                
MFA-TR*          AND Z4.COMPANY_NO         = :Z4-COMPANY-NO                     
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7080                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7075'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_PRTY_SVC_CAT'    TO TABLE-1                     
              MOVE 'PRTY_SVC_CAT_CD'     TO TABLE-ELEMENT-1             
              MOVE 'COMAPNY_NO'          TO TABLE-ELEMENT-2             
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-3             
              MOVE Z4-PRTY-SVC-CAT-CD    TO HOSTVAR-ELEMENT-1           
              MOVE Z4-COMPANY-NO         TO HOSTVAR-ELEMENT-2           
              MOVE WS-CURR-ACCOUNT-NO    TO HOSTVAR-ELEMENT-3           
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       7080-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7085-CHK-INDUS-GAS-CUST.                                       *        
      ******************************************************************        
       7085-CHK-INDUS-GAS-CUST.                                         
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                               
                INTO :WS-INDUS-GAS-CUST-FLAG                            
                FROM CSS_RATE_COMP_DEF J1 WITH(READUNCOMMITTED)                 
               WHERE J1.RATE_PLAN_NO   = :UT-RATE-PLAN-NO               
                 AND J1.REG_TYPE_CD    = 'D'                            
                 AND J1.CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE             
                 AND J1.VERSION_NO_CNTRL IN                             
                     (SELECT MAX(A1.VERSION_NO_CNTRL)                   
                        FROM CSS_RATE_COMP_DEF A1 WITH(READUNCOMMITTED)         
                       WHERE A1.RATE_PLAN_NO   = :UT-RATE-PLAN-NO       
                         AND A1.CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE)    
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  'Y'                                                       
MFA-TR*         INTO :WS-INDUS-GAS-CUST-FLAG                                    
MFA-TR*         FROM CSS_RATE_COMP_DEF J1                                       
MFA-TR*        WHERE J1.RATE_PLAN_NO   = :UT-RATE-PLAN-NO                       
MFA-TR*          AND J1.REG_TYPE_CD    = 'D'                                    
MFA-TR*          AND J1.CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE                     
MFA-TR*          AND J1.VERSION_NO_CNTRL IN                                     
MFA-TR*              (SELECT MAX(A1.VERSION_NO_CNTRL)                           
MFA-TR*                 FROM CSS_RATE_COMP_DEF A1                               
MFA-TR*                WHERE A1.RATE_PLAN_NO   = :UT-RATE-PLAN-NO               
MFA-TR*                  AND A1.CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE)            
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7085                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7085'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_RATE_COMP_DEF'   TO TABLE-1                     
              MOVE 'RATE_PLAN_NO'        TO TABLE-ELEMENT-1             
              MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2             
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-3             
              MOVE UT-RATE-PLAN-NO       TO HOSTVAR-ELEMENT-1           
              MOVE UT-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2           
              MOVE UT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-3           
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       7085-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7090-GET-PRTY-SVC-CAT.                                         *        
      ******************************************************************        
       7090-GET-PRTY-SVC-CAT.                                           
                                                                        
           EXEC SQL                                                     
              SELECT Z4.PRTY_SVC_CAT_CD                                 
                INTO :Z4-PRTY-SVC-CAT-CD                                
                FROM CSS_PRTY_SVC_CAT Z4 WITH(READUNCOMMITTED)                  
               WHERE CODE_CURTAIL_PRTY  = :Z4-CODE-CURTAIL-PRTY         
                 AND COMPANY_NO         = :Z4-COMPANY-NO                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT Z4.PRTY_SVC_CAT_CD                                         
MFA-TR*         INTO :Z4-PRTY-SVC-CAT-CD                                        
MFA-TR*         FROM CSS_PRTY_SVC_CAT Z4                                        
MFA-TR*        WHERE CODE_CURTAIL_PRTY  = :Z4-CODE-CURTAIL-PRTY                 
MFA-TR*          AND COMPANY_NO         = :Z4-COMPANY-NO                        
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7090                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7090'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_PRTY_SVC_CAT'    TO TABLE-1                     
              MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1             
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2             
              MOVE Z4-COMPANY-NO         TO HOSTVAR-ELEMENT-1           
              MOVE UT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       7090-EXIT.                                                       
           EXIT.                                                        
                                                                        
A05065******************************************************************        
A05065*                                                               *         
A05065* 7095-GET-CODE-UTIL-TYPE-DESC.                                  *        
A05065******************************************************************        
A05065 7095-GET-CODE-UTIL-TYPE-DESC.                                    
A05065                                                                  
A05065     EXEC SQL                                                     
A05065        SELECT UV.CODE_SHORT_DESC                                 
A05065         INTO :UV-CODE-SHORT-DESC                                 
A05065         FROM CSS_CODE_VALUE UV WITH(READUNCOMMITTED)                     
A05065        WHERE UV.CODE_VALUE     = :UV-CODE-VALUE                  
A05065          AND UV.COLUMN_NA      = :UV-COLUMN-NA                   
A05065          AND UV.COMPANY_NO     = :UV-COMPANY-NO                  
A05065          AND UV.PROGRAM_ID     = :UV-PROGRAM-ID                  
A05065          AND UV.TABLE_NA       = :UV-TABLE-NA                    
A05065                                                           
A05065                                                      
A05065     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT UV.CODE_SHORT_DESC                                         
MFA-TR*        INTO :UV-CODE-SHORT-DESC                                         
MFA-TR*        FROM CSS_CODE_VALUE UV                                           
MFA-TR*       WHERE UV.CODE_VALUE     = :UV-CODE-VALUE                          
MFA-TR*         AND UV.COLUMN_NA      = :UV-COLUMN-NA                           
MFA-TR*         AND UV.COMPANY_NO     = :UV-COMPANY-NO                          
MFA-TR*         AND UV.PROGRAM_ID     = :UV-PROGRAM-ID                          
MFA-TR*         AND UV.TABLE_NA       = :UV-TABLE-NA                            
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7095                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05065                                                                  
A05065     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
A05065                                                                  
A05065     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A05065        CONTINUE                                                  
A05065     ELSE                                                         
A05065        MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
A05065        MOVE '7095'                   TO ACTIVE-PARAGRAPH         
A05065        MOVE 'SELECT'                 TO ABEND-FUNCTION           
A05065        MOVE 'CSS_CODE_VALUE'         TO TABLE-1                  
A05065        MOVE 'CODE_VALUE'             TO TABLE-ELEMENT-1          
A05065        MOVE 'COLUMN_NA '             TO TABLE-ELEMENT-2          
A05065        MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-3          
A05065        MOVE 'TABLE_NA'               TO TABLE-ELEMENT-4          
A05065        MOVE UV-CODE-VALUE            TO HOSTVAR-ELEMENT-1        
A05065        MOVE UV-COLUMN-NA             TO HOSTVAR-ELEMENT-2        
A05065        MOVE UV-COMPANY-NO            TO HOSTVAR-ELEMENT-3        
A05065        MOVE UV-TABLE-NA              TO HOSTVAR-ELEMENT-4        
A05065        PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
A05065     END-IF.                                                      
A05065                                                                  
A05065 7095-EXIT.                                                       
A05065     EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7100-SELECT-UTIL-ENVRNMT.                                      *        
      ******************************************************************        
       7100-SELECT-UTIL-ENVRNMT.                                        
                                                                        
           EXEC SQL                                                     
              SELECT UT.RATE_PLAN_NO                                    
                    ,UT.CODE_REVENUE_CLASS                              
                    ,UT.CODE_SIC_NO                                     
                    ,UT.NAICS_CD                                        
                    ,UT.COMPANY_NO                                      
                    ,UT.SEASONAL_USE_CODE                               
                    ,UT.ZERO_USE_INVEST_DT                              
                    ,UT.READ_CYCLE                                      
                    ,UT.READ_ROUTE                                      
                    ,UT.CODE_MTR_READ_FREQ                              
                    ,UT.CODE_ESTIMATE_OK                                
                    ,UT.ALTERNATE_FUEL_CD                               
                    ,UT.GAS_BASE_USE                                    
                    ,UT.GAS_BASE_LAST_UPDT                              
                    ,UT.CODE_CURTAIL_PRTY                               
                INTO :UT-RATE-PLAN-NO                                   
                    ,:UT-CODE-REVENUE-CLASS                             
                    ,:UT-CODE-SIC-NO                                    
                    ,:UT-NAICS-CD                                       
                    ,:UT-COMPANY-NO                                     
                    ,:UT-SEASONAL-USE-CODE                              
                    ,:UT-ZERO-USE-INVEST-DT :WS-NULL-IND-01              
                    ,:UT-READ-CYCLE                                     
                    ,:UT-READ-ROUTE                                     
                    ,:UT-CODE-MTR-READ-FREQ                             
                    ,:UT-CODE-ESTIMATE-OK                               
                    ,:UT-ALTERNATE-FUEL-CD                              
                    ,:UT-GAS-BASE-USE                                   
                    ,:UT-GAS-BASE-LAST-UPDT :WS-NULL-IND-02              
                    ,:UT-CODE-CURTAIL-PRTY                              
               FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                   
              WHERE UT.ACCOUNT_NO     = :UT-ACCOUNT-NO                  
                AND UT.CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE              
                AND UT.IC_NO          = :UT-IC-NO                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT UT.RATE_PLAN_NO                                            
MFA-TR*             ,UT.CODE_REVENUE_CLASS                                      
MFA-TR*             ,UT.CODE_SIC_NO                                             
MFA-TR*             ,UT.NAICS_CD                                                
MFA-TR*             ,UT.COMPANY_NO                                              
MFA-TR*             ,UT.SEASONAL_USE_CODE                                       
MFA-TR*             ,UT.ZERO_USE_INVEST_DT                                      
MFA-TR*             ,UT.READ_CYCLE                                              
MFA-TR*             ,UT.READ_ROUTE                                              
MFA-TR*             ,UT.CODE_MTR_READ_FREQ                                      
MFA-TR*             ,UT.CODE_ESTIMATE_OK                                        
MFA-TR*             ,UT.ALTERNATE_FUEL_CD                                       
MFA-TR*             ,UT.GAS_BASE_USE                                            
MFA-TR*             ,UT.GAS_BASE_LAST_UPDT                                      
MFA-TR*             ,UT.CODE_CURTAIL_PRTY                                       
MFA-TR*         INTO :UT-RATE-PLAN-NO                                           
MFA-TR*             ,:UT-CODE-REVENUE-CLASS                                     
MFA-TR*             ,:UT-CODE-SIC-NO                                            
MFA-TR*             ,:UT-NAICS-CD                                               
MFA-TR*             ,:UT-COMPANY-NO                                             
MFA-TR*             ,:UT-SEASONAL-USE-CODE                                      
MFA-TR*             ,:UT-ZERO-USE-INVEST-DT:WS-NULL-IND-01                      
MFA-TR*             ,:UT-READ-CYCLE                                             
MFA-TR*             ,:UT-READ-ROUTE                                             
MFA-TR*             ,:UT-CODE-MTR-READ-FREQ                                     
MFA-TR*             ,:UT-CODE-ESTIMATE-OK                                       
MFA-TR*             ,:UT-ALTERNATE-FUEL-CD                                      
MFA-TR*             ,:UT-GAS-BASE-USE                                           
MFA-TR*             ,:UT-GAS-BASE-LAST-UPDT:WS-NULL-IND-02                      
MFA-TR*             ,:UT-CODE-CURTAIL-PRTY                                      
MFA-TR*        FROM CSS_UTIL_ENVRNMT UT                                         
MFA-TR*       WHERE UT.ACCOUNT_NO     = :UT-ACCOUNT-NO                          
MFA-TR*         AND UT.CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE                      
MFA-TR*         AND UT.IC_NO          = :UT-IC-NO                               
MFA-TR*        WITH UR                                                          
MFA-TR*     QUERYNO 7100                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF WS-NULL-IND-01 = WS-YES-NULL                           
                 MOVE SPACES             TO UT-ZERO-USE-INVEST-DT       
              END-IF                                                    
              IF WS-NULL-IND-02 = WS-YES-NULL                           
                 MOVE SPACES             TO UT-GAS-BASE-LAST-UPDT       
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7100'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_UTIL_ENVRNMT'    TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2             
              MOVE 'IC_NO'               TO TABLE-ELEMENT-3             
              MOVE UT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE UT-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2           
              MOVE UT-IC-NO              TO HOSTVAR-ELEMENT-3           
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7102-SELECT-PREMISE                                            *        
      ******************************************************************        
       7102-SELECT-PREMISE.                                             
                                                                        
           EXEC SQL                                                     
              SELECT PR.PERSONAL_CNTCT_CD                               
                INTO :PR-PERSONAL-CNTCT-CD                              
                FROM CSS_PREMISE PR WITH(READUNCOMMITTED)                       
               WHERE PR.PREMISE_NO = :PR-PREMISE-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT PR.PERSONAL_CNTCT_CD                                       
MFA-TR*         INTO :PR-PERSONAL-CNTCT-CD                                      
MFA-TR*         FROM CSS_PREMISE PR                                             
MFA-TR*        WHERE PR.PREMISE_NO = :PR-PREMISE-NO                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7102                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7102'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_PREMISE'         TO TABLE-1                     
              MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1             
              MOVE PR-PREMISE-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       7102-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7105-SELECT-ACCOUNT-DET.                                       *        
      ******************************************************************        
       7105-SELECT-ACCOUNT-DET.                                         
                                                                        
           EXEC SQL                                                     
              SELECT AT.BILL_CYCLE                                      
                    ,AT.CODE_DISC_OK                                    
                    ,AT.REV_MTH_LST_NRML                                
                INTO :AT-BILL-CYCLE,
                :AT-CODE-DISC-OK,
                :AT-REV-MTH-LST-NRML                                 
                FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
               WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ064
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT AT.BILL_CYCLE                                              
MFA-TR*             ,AT.CODE_DISC_OK                                            
MFA-TR*             ,AT.REV_MTH_LST_NRML                                        
MFA-TR*         INTO :AT-BILL-CYCLE                                             
MFA-TR*             ,:AT-CODE-DISC-OK                                           
MFA-TR*             ,:AT-REV-MTH-LST-NRML                                       
MFA-TR*             ,:AT-CODE-ACCT-STAT                                         
MFA-TR*         FROM CSS_ACCOUNT AT                                             
MFA-TR*        WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7105                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7105'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
              MOVE 'USER_ID'             TO TABLE-ELEMENT-1             
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2             
              MOVE PARM-USERID           TO HOSTVAR-ELEMENT-1           
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       7105-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7125-SELECT-JOB-PARM.                                         *         
      *****************************************************************         
       7125-SELECT-JOB-PARM.                                            
                                                                        
           EXEC SQL                                                     
              SELECT G6.PARM_DATA                                       
                INTO :G6-PARM-DATA                                      
                FROM CSS_JOB_PARM G6 WITH(READUNCOMMITTED)                      
               WHERE G6.PROGRAM_NAME   = :G6-PROGRAM-NAME               
                 AND G6.CMND_CODE      = :G6-CMND-CODE                  
                 AND G6.COMPANY_NO     = :G6-COMPANY-NO                 
                 AND G6.SEQ_NO         = :G6-SEQ-NO                     
                 AND G6.STATUS         = 'A'                            
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT G6.PARM_DATA                                               
MFA-TR*         INTO :G6-PARM-DATA                                              
MFA-TR*         FROM CSS_JOB_PARM G6                                            
MFA-TR*        WHERE G6.PROGRAM_NAME   = :G6-PROGRAM-NAME                       
MFA-TR*          AND G6.CMND_CODE      = :G6-CMND-CODE                          
MFA-TR*          AND G6.COMPANY_NO     = :G6-COMPANY-NO                         
MFA-TR*          AND G6.SEQ_NO         = :G6-SEQ-NO                             
MFA-TR*          AND G6.STATUS         = 'A'                                    
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7125                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7125'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_JOB_PARM'             TO TABLE-1                
              MOVE 'PROGRAM_NAME'             TO TABLE-ELEMENT-1        
              MOVE 'CMND_CODE'                TO TABLE-ELEMENT-2        
              MOVE G6-PROGRAM-NAME            TO HOSTVAR-ELEMENT-1      
              MOVE G6-CMND-CODE               TO HOSTVAR-ELEMENT-2      
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7125-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7130-CHECK-FOR-CIG-RATE.                                       *        
      ******************************************************************        
       7130-CHECK-FOR-CIG-RATE.                                         
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
               INTO :WS-CIG-RATE-STAT                                   
               FROM CSS_RATE_COMP_DEF J1 WITH(READUNCOMMITTED)                  
              WHERE J1.RATE_PLAN_NO   = :J1-RATE-PLAN-NO                
                AND J1.CODE_UTIL_TYPE = :WS-GAS                         
                AND J1.REG_TYPE_CD    = 'D'                             
                                           
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*        INTO :WS-CIG-RATE-STAT                                           
MFA-TR*        FROM CSS_RATE_COMP_DEF J1                                        
MFA-TR*       WHERE J1.RATE_PLAN_NO   = :J1-RATE-PLAN-NO                        
MFA-TR*         AND J1.CODE_UTIL_TYPE = :WS-GAS                                 
MFA-TR*         AND J1.REG_TYPE_CD    = 'D'                                     
MFA-TR*       FETCH FIRST 1 ROW ONLY WITH UR                                    
MFA-TR*     QUERYNO 7130                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7130'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_RATE_COMP_DEF'   TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'RATE_PLAN_NO'        TO TABLE-ELEMENT-2             
              MOVE BG-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE J1-RATE-PLAN-NO       TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       7130-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7140-GET-TRNSP-CD-REV-CLASS.                                   *        
      ******************************************************************        
       7140-GET-TRNSP-CD-REV-CLASS.                                     
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) TZ.CODE_REVENUE_CLASS                             
                 INTO :TZ-CODE-REVENUE-CLASS                            
                 FROM CSS_TRNSP_VOL_BLK TZ WITH(READUNCOMMITTED)                
                     ,CSS_BILL_CONTRACT BK WITH(READUNCOMMITTED)                
                WHERE TZ.ACCOUNT_NO       = :TZ-ACCOUNT-NO              
                  AND TZ.ACCOUNT_NO       = BK.ACCOUNT_NO               
                  AND TZ.CODE_UTIL_TYPE   = BK.CODE_UTIL_TYPE           
                  AND TZ.PRIMARY_IC_NO    = BK.IC_NO                    
                  AND TZ.CNTRCT_START_DT  = BK.CNTRCT_START_DT          
                  AND BK.CNTRCT_START_DT <= CAST(SYSDATETIMEOFFSET() 
           AS DATE)                
                  AND BK.CNTRCT_END_DT   >= CAST(SYSDATETIMEOFFSET() 
           AS DATE)                
                ORDER BY BK.CNTRCT_START_DT DESC                        
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT TZ.CODE_REVENUE_CLASS                                     
MFA-TR*          INTO :TZ-CODE-REVENUE-CLASS                                    
MFA-TR*          FROM CSS_TRNSP_VOL_BLK TZ                                      
MFA-TR*              ,CSS_BILL_CONTRACT BK                                      
MFA-TR*         WHERE TZ.ACCOUNT_NO       = :TZ-ACCOUNT-NO                      
MFA-TR*           AND TZ.ACCOUNT_NO       = BK.ACCOUNT_NO                       
MFA-TR*           AND TZ.CODE_UTIL_TYPE   = BK.CODE_UTIL_TYPE                   
MFA-TR*           AND TZ.PRIMARY_IC_NO    = BK.IC_NO                            
MFA-TR*           AND TZ.CNTRCT_START_DT  = BK.CNTRCT_START_DT                  
MFA-TR*           AND BK.CNTRCT_START_DT <= CURRENT DATE                        
MFA-TR*           AND BK.CNTRCT_END_DT   >= CURRENT DATE                        
MFA-TR*         ORDER BY BK.CNTRCT_START_DT DESC                                
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*        QUERYNO 7140                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO               WS-ACTIVE-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7140'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_TRNSP_VOL_BLK'   TO TABLE-1                     
              MOVE 'CSS_BILL_CONTRACT'   TO TABLE-2                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE TZ-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
        7140-EXIT.                                                      
             EXIT.                                                      
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7150-SELECT-MTR-SEQ.                                           *        
      ******************************************************************        
       7150-SELECT-MTR-SEQ.                                             
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) MN.REGISTER_RD_SEQ                                 
                INTO :MN-REGISTER-RD-SEQ                                
                FROM CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)                  
               WHERE MN.ACCOUNT_NO     = :MN-ACCOUNT-NO                 
                 AND MN.CODE_UTIL_TYPE IN('E', 'G')                     
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MN.REGISTER_RD_SEQ                                         
MFA-TR*         INTO :MN-REGISTER-RD-SEQ                                        
MFA-TR*         FROM CSS_MTRD_ENVRNMT MN                                        
MFA-TR*        WHERE MN.ACCOUNT_NO     = :MN-ACCOUNT-NO                         
MFA-TR*          AND MN.CODE_UTIL_TYPE IN('E', 'G')                             
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*       QUERYNO 7150                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7150'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_MTRD_ENVRNMT'    TO TABLE-1                     
              MOVE 'USER_ID'             TO TABLE-ELEMENT-1             
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2             
              MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-3             
              MOVE 'IC_NO'               TO TABLE-ELEMENT-4             
              MOVE WS-CURR-USER-ID       TO HOSTVAR-ELEMENT-1           
              MOVE MN-ACCOUNT-NO         TO HOSTVAR-ELEMENT-2           
              MOVE MN-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-3           
              MOVE MN-IC-NO              TO HOSTVAR-ELEMENT-4           
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                                         
      * 7200-CHECK-FOR-DEP.                                                     
      *****************************************************************         
       7200-CHECK-FOR-DEP.                                              
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-DEP-ACCT-EXIST                                 
                FROM CSS_UTL_BILL_REL UR WITH(READUNCOMMITTED)                  
               WHERE UR.ACCOUNT_NO_MST      = :UR-ACCOUNT-NO-MST        
                 AND UR.CODE_UTIL_TYPE_MST  = :UR-CODE-UTIL-TYPE-MST    
                 AND UR.IC_NO_MST           = :UR-IC-NO-MST             
                                                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-DEP-ACCT-EXIST                                         
MFA-TR*         FROM CSS_UTL_BILL_REL UR                                        
MFA-TR*        WHERE UR.ACCOUNT_NO_MST      = :UR-ACCOUNT-NO-MST                
MFA-TR*          AND UR.CODE_UTIL_TYPE_MST  = :UR-CODE-UTIL-TYPE-MST            
MFA-TR*          AND UR.IC_NO_MST           = :UR-IC-NO-MST                     
MFA-TR*        FETCH FIRST 1 ROW ONLY                                           
MFA-TR*        WITH UR                                                          
MFA-TR*       QUERYNO 7200                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7200'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_UTL_BILL_REL'         TO TABLE-1                
              MOVE 'ACCOUNT_NO_MST'           TO TABLE-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE_MST'       TO TABLE-ELEMENT-2        
              MOVE 'IC_NO_MST'                TO TABLE-ELEMENT-3        
              MOVE UR-ACCOUNT-NO-MST          TO HOSTVAR-ELEMENT-1      
              MOVE UR-CODE-UTIL-TYPE-MST      TO HOSTVAR-ELEMENT-2      
              MOVE UR-IC-NO-MST               TO HOSTVAR-ELEMENT-3      
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                                         
      * 7210-CHECK-FOR-MST.                                                     
      *****************************************************************         
       7210-CHECK-FOR-MST.                                              
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-MST-ACCT-EXIST                                 
                FROM CSS_UTL_BILL_REL UR WITH(READUNCOMMITTED)                  
               WHERE UR.ACCOUNT_NO_DEP      = :UR-ACCOUNT-NO-DEP        
                 AND UR.CODE_UTIL_TYPE_DEP  = :UR-CODE-UTIL-TYPE-DEP    
                 AND UR.IC_NO_DEP           = :UR-IC-NO-DEP             
                                                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-MST-ACCT-EXIST                                         
MFA-TR*         FROM CSS_UTL_BILL_REL UR                                        
MFA-TR*        WHERE UR.ACCOUNT_NO_DEP      = :UR-ACCOUNT-NO-DEP                
MFA-TR*          AND UR.CODE_UTIL_TYPE_DEP  = :UR-CODE-UTIL-TYPE-DEP            
MFA-TR*          AND UR.IC_NO_DEP           = :UR-IC-NO-DEP                     
MFA-TR*        FETCH FIRST 1 ROW ONLY                                           
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7210                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7210'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_UTL_BILL_REL'         TO TABLE-1                
              MOVE 'ACCOUNT_NO_DEP'           TO TABLE-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE_DEP'       TO TABLE-ELEMENT-2        
              MOVE 'IC_NO_DEP'                TO TABLE-ELEMENT-3        
              MOVE UR-ACCOUNT-NO-DEP          TO HOSTVAR-ELEMENT-1      
              MOVE UR-CODE-UTIL-TYPE-DEP      TO HOSTVAR-ELEMENT-2      
              MOVE UR-IC-NO-DEP               TO HOSTVAR-ELEMENT-3      
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7300-SELECT-IC-NO.                                             *        
      ******************************************************************        
       7300-SELECT-IC-NO.                                               
                                                                        
           EXEC SQL                                                     
              SELECT UT.IC_NO                                           
                INTO :WS-UT-IC-NO                                       
                FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                  
               WHERE UT.ACCOUNT_NO     = :UT-ACCOUNT-NO                 
                 AND UT.CODE_UTIL_TYPE = :WS-UNMETER                    
                 AND UT.RATE_PLAN_NO   = :WS-SUBDVSN-LIGHT              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT UT.IC_NO                                                   
MFA-TR*         INTO :WS-UT-IC-NO                                               
MFA-TR*         FROM CSS_UTIL_ENVRNMT UT                                        
MFA-TR*        WHERE UT.ACCOUNT_NO     = :UT-ACCOUNT-NO                         
MFA-TR*          AND UT.CODE_UTIL_TYPE = :WS-UNMETER                            
MFA-TR*          AND UT.RATE_PLAN_NO   = :WS-SUBDVSN-LIGHT                      
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7300                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7300'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_UTIL_ENVRNMT'    TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'IC_NO'               TO TABLE-ELEMENT-2             
              MOVE UT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE WS-UT-IC-NO           TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7310-CHECK-FOR-UNMETERED.                                     *         
      ******************************************************************        
       7310-CHECK-UNMTR-EXISTS.                                         
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-UNMETERED-EXISTS                               
                FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                  
               WHERE UT.ACCOUNT_NO     = :AT-ACCOUNT-NO                 
                 AND UT.CODE_UTIL_TYPE = :WS-UNMETER                    
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-UNMETERED-EXISTS                                       
MFA-TR*         FROM CSS_UTIL_ENVRNMT UT                                        
MFA-TR*        WHERE UT.ACCOUNT_NO     = :AT-ACCOUNT-NO                         
MFA-TR*          AND UT.CODE_UTIL_TYPE = :WS-UNMETER                            
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7310                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7310'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_UTIL_ENVRNMT'    TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       7310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7320-GET-CURR-ACCT-TYPE.                                      *         
      ******************************************************************        
       7320-GET-CURR-ACCT-TYPE.                                         
                                                                        
           EXEC SQL                                                     
              SELECT ACCOUNT_TYPE_CODE                                  
                INTO :AT-ACCOUNT-TYPE-CODE                              
                FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
               WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ACCOUNT_TYPE_CODE                                          
MFA-TR*         INTO :AT-ACCOUNT-TYPE-CODE                                      
MFA-TR*         FROM CSS_ACCOUNT AT                                             
MFA-TR*        WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7320                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7320'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_ACCOUNT'              TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       7320-EXIT.                                                       
           EXIT.                                                        
A05051*                                                                         
A05051******************************************************************        
A05051**  CHECK FOR RECURRING CREDIT CARD PAYMENT                     **        
A05051******************************************************************        
A05051*                                                                         
A05051 7800-CHK-AUTO-CARD-PAY-ATTR.                                     
A05051*                                                                         
A05051     EXEC SQL                                                     
A05051       SELECT  'Y'                                                
A05051         INTO  :WS-AUTO-CARD-PAY                                  
A05051         FROM  CSS_ACCT_ATTRIBUTE  YP WITH(READUNCOMMITTED)               
A05051        WHERE  YP.ACCOUNT_NO          =  :AT-ACCOUNT-NO           
A05051          AND  YP.ATTRIBUTE_DESC      =  :WS-AUTO-CARD            
A05051          AND  YP.ATTRIBUTE_VALUE_CD  =  :WS-AUTOC                
A05051          AND  YP.STATUS_CD           =  :WS-A                    
A05051                                                           
A05051                                                      
A05051     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  'Y'                                                        
MFA-TR*        INTO  :WS-AUTO-CARD-PAY                                          
MFA-TR*        FROM  CSS_ACCT_ATTRIBUTE  YP                                     
MFA-TR*       WHERE  YP.ACCOUNT_NO          =  :AT-ACCOUNT-NO                   
MFA-TR*         AND  YP.ATTRIBUTE_DESC      =  :WS-AUTO-CARD                    
MFA-TR*         AND  YP.ATTRIBUTE_VALUE_CD  =  :WS-AUTOC                        
MFA-TR*         AND  YP.STATUS_CD           =  :WS-A                            
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7800                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05051*                                                                         
A05051     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
A05051*                                                                         
A05051     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
A05051         NEXT SENTENCE                                            
A05051     ELSE                                                         
A05051        MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
A05051        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
A05051        MOVE '7800'                     TO ACTIVE-PARAGRAPH       
A05051        MOVE 'SELECT'                   TO ABEND-FUNCTION         
A05051        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
A05051                                           ABEND-TABLES           
A05051        MOVE 'CSS_ACCT_ATTRIBUTE'       TO TABLE-1                
A05051        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
A05051        MOVE YP-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
A05051        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
A05051     END-IF.                                                      
A05051*                                                                         
A05051 7800-EXIT.                                                       
A05051     EXIT.                                                        
A05051*                                                                         
A05051****************************************************************          
A05051**  GET CUSTOMR NUMBER FROM CSS_ACCOUNT                       **          
A05051****************************************************************          
A05051*                                                                         
A05051 7810-GET-ACCOUNT.                                                
A05051*                                                                         
A05051     EXEC SQL                                                     
A05051          SELECT CUSTOMER_NO                                      
A05051                ,PREMISE_NO                                       
A05051                ,COMPANY_NO                                       
A05051                ,LOCAL_OFFICE                                     
A05051            INTO :AT-CUSTOMER-NO                                  
A05051                ,:AT-PREMISE-NO                                   
A05051                ,:AT-COMPANY-NO                                   
A05051                ,:AT-LOCAL-OFFICE                                 
A05051            FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                        
A05051           WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                      
A05051                                                           
A05051                                                      
A05051     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT CUSTOMER_NO                                              
MFA-TR*               ,PREMISE_NO                                               
MFA-TR*               ,COMPANY_NO                                               
MFA-TR*               ,LOCAL_OFFICE                                             
MFA-TR*           INTO :AT-CUSTOMER-NO                                          
MFA-TR*               ,:AT-PREMISE-NO                                           
MFA-TR*               ,:AT-COMPANY-NO                                           
MFA-TR*               ,:AT-LOCAL-OFFICE                                         
MFA-TR*           FROM CSS_ACCOUNT                                              
MFA-TR*          WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                              
MFA-TR*           WITH UR                                                       
MFA-TR*        QUERYNO 7810                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05051*                                                                         
A05051     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A05051*                                                                         
A05051     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A05051        CONTINUE                                                  
A05051     ELSE                                                         
A05051        MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
A05051        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
A05051        MOVE '7810'                     TO ACTIVE-PARAGRAPH       
A05051        MOVE 'SELECT'                   TO ABEND-FUNCTION         
A05051        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
A05051                                           ABEND-TABLES           
A05051        MOVE 'CSS_ACCOUNT'              TO TABLE-1                
A05051        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
A05051        MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
A05051        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
A05051     END-IF.                                                      
A05051*                                                                         
A05051 7810-EXIT.                                                       
A05051     EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8000-UPDT-CD-COMPANY-ACCT.                                     *        
      ******************************************************************        
       8000-UPDT-CD-COMPANY-ACCT.                                       
                                                                        
           EXEC SQL                                                     
              UPDATE AT                                      
                 SET AT.CODE_COMPANY_ACCT  = :AT-CODE-COMPANY-ACCT      
              FROM CSS_ACCOUNT AT
               WHERE AT.ACCOUNT_NO         = :AT-ACCOUNT-NO             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_ACCOUNT AT                                             
MFA-TR*          SET AT.CODE_COMPANY_ACCT  = :AT-CODE-COMPANY-ACCT              
MFA-TR*        WHERE AT.ACCOUNT_NO         = :AT-ACCOUNT-NO                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8000'                   TO ACTIVE-PARAGRAPH         
              MOVE 'UPDATE'                 TO ABEND-FUNCTION           
              MOVE 'CSS_ACCOUNT'            TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'CODE_COMPANY_ACCT'      TO TABLE-ELEMENT-2          
              MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE AT-CODE-COMPANY-ACCT     TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8100-INSERT-UTIL-ENVRNMT.                                      *        
      ******************************************************************        
       8100-INSERT-UTIL-ENVRNMT.                                        
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_UTIL_ENVRNMT                              
                   ( PREMISE_NO                                         
                    ,CODE_UTIL_TYPE                                     
                    ,IC_NO                                              
                    ,CODE_ESTIMATE_OK                                   
                    ,CODE_CURTAIL_PRTY                                  
                    ,CODE_REVENUE_CLASS                                 
                    ,CODE_SERVICE_TYPE                                  
                    ,DATE_LST_NRML_BILL                                 
                    ,RATE_PLAN_NO                                       
                    ,END_USER_PER_RATE                                  
                    ,DATE_INSTALL                                       
                    ,READ_CYCLE                                         
                    ,READ_ROUTE                                         
                    ,ACCOUNT_NO                                         
                    ,CODE_MTR_READ_FREQ                                 
                    ,CODE_SIC_NO                                        
                    ,NAICS_CD                                           
                    ,ENERGY_SOURCE                                      
                    ,SPLY_SENSITIVE_IND                                 
                    ,SEASONAL_USE_CODE                                  
                    ,COMPANY_NO                                         
                    ,PRV_RATE_PLAN_NO                                   
                    ,CODE_STAT_TAX_XMT                                  
                    ,CODE_CITY_TAX_XMT                                  
                    ,CODE_OTHR_TAX_XMT                                  
                    ,CODE_XCIS_TAX_XMT                                  
                    ,STATE_TAX_EXMPT_NO                                 
                    ,TOU_RATE_IND                                       
                    ,GAS_BASE_LAST_UPDT                                 
                    ,GAS_PREV_BASE_USE                                  
                    ,GAS_BASE_USE                                       
                    ,LAST_UPDATE_TS                                     
                    ,ZERO_USE_INVEST_DT                                 
                    ,ALTERNATE_FUEL_CD )                                
           VALUES ( :UT-PREMISE-NO                                      
                   ,:UT-CODE-UTIL-TYPE                                  
                   ,:UT-IC-NO                                           
                   ,:UT-CODE-ESTIMATE-OK                                
                   ,:UT-CODE-CURTAIL-PRTY                               
                   ,:UT-CODE-REVENUE-CLASS                              
                   ,:UT-CODE-SERVICE-TYPE                               
                   ,IIF(TRY_CONVERT(DATE, :UT-DATE-LST-NRML-BILL 
                                          :WS-NULL-IND
              ) IS NULL OR (PATINDEX('%.%', :UT-DATE-LST-NRML-BILL 
                                                           :WS-NULL-IND
              ) <> 0) OR (LEN(:UT-DATE-LST-NRML-BILL :WS-NULL-IND
              ) <> 10), CIS.CHAR2DATE(:UT-DATE-LST-NRML-BILL 
                                                           :WS-NULL-IND
              ), CONVERT(DATE, :UT-DATE-LST-NRML-BILL :WS-NULL-IND) )          
                   ,:UT-RATE-PLAN-NO                                    
                   ,:UT-END-USER-PER-RATE                               
                   ,IIF(TRY_CONVERT(DATE, :UT-DATE-INSTALL :WS-NULL-IND
              ) IS NULL OR (PATINDEX('%.%', :UT-DATE-INSTALL 
                                                           :WS-NULL-IND
              ) <> 0) OR (LEN(:UT-DATE-INSTALL :WS-NULL-IND
              ) <> 10), CIS.CHAR2DATE(:UT-DATE-INSTALL :WS-NULL-IND
              ), CONVERT(DATE, :UT-DATE-INSTALL :WS-NULL-IND) )                
                   ,:UT-READ-CYCLE                                      
                   ,:UT-READ-ROUTE                                      
                   ,:UT-ACCOUNT-NO                                      
                   ,:UT-CODE-MTR-READ-FREQ                              
                   ,:UT-CODE-SIC-NO                                     
                   ,:UT-NAICS-CD                                        
                   ,:UT-ENERGY-SOURCE                                   
                   ,:UT-SPLY-SENSITIVE-IND                              
                   ,:UT-SEASONAL-USE-CODE                               
                   ,:UT-COMPANY-NO                                      
                   ,:UT-PRV-RATE-PLAN-NO                                
                   ,:UT-CODE-STAT-TAX-XMT                               
                   ,:UT-CODE-CITY-TAX-XMT                               
                   ,:UT-CODE-OTHR-TAX-XMT                               
                   ,:UT-CODE-XCIS-TAX-XMT                               
                   ,:UT-STATE-TAX-EXMPT-NO                              
                   ,:UT-TOU-RATE-IND                                    
                   ,IIF(TRY_CONVERT(DATE, :UT-GAS-BASE-LAST-UPDT 
                                          :WS-NULL-IND-02
              ) IS NULL OR (PATINDEX('%.%', :UT-GAS-BASE-LAST-UPDT 
                                                        :WS-NULL-IND-02
              ) <> 0) OR (LEN(:UT-GAS-BASE-LAST-UPDT :WS-NULL-IND-02
              ) <> 10), CIS.CHAR2DATE(:UT-GAS-BASE-LAST-UPDT 
                                                        :WS-NULL-IND-02
              ), CONVERT(DATE, :UT-GAS-BASE-LAST-UPDT :WS-NULL-IND-02
              ) )               
                   ,:UT-GAS-PREV-BASE-USE                               
                   ,:UT-GAS-BASE-USE                                    
                   ,CIS.CHAR2TIMESTAMP(:UT-LAST-UPDATE-TS)                      
                   ,IIF(TRY_CONVERT(DATE, :UT-ZERO-USE-INVEST-DT 
                                          :WS-NULL-IND-01
              ) IS NULL OR (PATINDEX('%.%', :UT-ZERO-USE-INVEST-DT 
                                                        :WS-NULL-IND-01
              ) <> 0) OR (LEN(:UT-ZERO-USE-INVEST-DT :WS-NULL-IND-01
              ) <> 10), CIS.CHAR2DATE(:UT-ZERO-USE-INVEST-DT 
                                                        :WS-NULL-IND-01
              ), CONVERT(DATE, :UT-ZERO-USE-INVEST-DT :WS-NULL-IND-01
              ) )               
                   ,:UT-ALTERNATE-FUEL-CD)                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_UTIL_ENVRNMT                                      
MFA-TR*            ( PREMISE_NO                                                 
MFA-TR*             ,CODE_UTIL_TYPE                                             
MFA-TR*             ,IC_NO                                                      
MFA-TR*             ,CODE_ESTIMATE_OK                                           
MFA-TR*             ,CODE_CURTAIL_PRTY                                          
MFA-TR*             ,CODE_REVENUE_CLASS                                         
MFA-TR*             ,CODE_SERVICE_TYPE                                          
MFA-TR*             ,DATE_LST_NRML_BILL                                         
MFA-TR*             ,RATE_PLAN_NO                                               
MFA-TR*             ,END_USER_PER_RATE                                          
MFA-TR*             ,DATE_INSTALL                                               
MFA-TR*             ,READ_CYCLE                                                 
MFA-TR*             ,READ_ROUTE                                                 
MFA-TR*             ,ACCOUNT_NO                                                 
MFA-TR*             ,CODE_MTR_READ_FREQ                                         
MFA-TR*             ,CODE_SIC_NO                                                
MFA-TR*             ,NAICS_CD                                                   
MFA-TR*             ,ENERGY_SOURCE                                              
MFA-TR*             ,SPLY_SENSITIVE_IND                                         
MFA-TR*             ,SEASONAL_USE_CODE                                          
MFA-TR*             ,COMPANY_NO                                                 
MFA-TR*             ,PRV_RATE_PLAN_NO                                           
MFA-TR*             ,CODE_STAT_TAX_XMT                                          
MFA-TR*             ,CODE_CITY_TAX_XMT                                          
MFA-TR*             ,CODE_OTHR_TAX_XMT                                          
MFA-TR*             ,CODE_XCIS_TAX_XMT                                          
MFA-TR*             ,STATE_TAX_EXMPT_NO                                         
MFA-TR*             ,TOU_RATE_IND                                               
MFA-TR*             ,GAS_BASE_LAST_UPDT                                         
MFA-TR*             ,GAS_PREV_BASE_USE                                          
MFA-TR*             ,GAS_BASE_USE                                               
MFA-TR*             ,LAST_UPDATE_TS                                             
MFA-TR*             ,ZERO_USE_INVEST_DT                                         
MFA-TR*             ,ALTERNATE_FUEL_CD )                                        
MFA-TR*    VALUES ( :UT-PREMISE-NO                                              
MFA-TR*            ,:UT-CODE-UTIL-TYPE                                          
MFA-TR*            ,:UT-IC-NO                                                   
MFA-TR*            ,:UT-CODE-ESTIMATE-OK                                        
MFA-TR*            ,:UT-CODE-CURTAIL-PRTY                                       
MFA-TR*            ,:UT-CODE-REVENUE-CLASS                                      
MFA-TR*            ,:UT-CODE-SERVICE-TYPE                                       
MFA-TR*            ,:UT-DATE-LST-NRML-BILL:WS-NULL-IND                          
MFA-TR*            ,:UT-RATE-PLAN-NO                                            
MFA-TR*            ,:UT-END-USER-PER-RATE                                       
MFA-TR*            ,:UT-DATE-INSTALL:WS-NULL-IND                                
MFA-TR*            ,:UT-READ-CYCLE                                              
MFA-TR*            ,:UT-READ-ROUTE                                              
MFA-TR*            ,:UT-ACCOUNT-NO                                              
MFA-TR*            ,:UT-CODE-MTR-READ-FREQ                                      
MFA-TR*            ,:UT-CODE-SIC-NO                                             
MFA-TR*            ,:UT-NAICS-CD                                                
MFA-TR*            ,:UT-ENERGY-SOURCE                                           
MFA-TR*            ,:UT-SPLY-SENSITIVE-IND                                      
MFA-TR*            ,:UT-SEASONAL-USE-CODE                                       
MFA-TR*            ,:UT-COMPANY-NO                                              
MFA-TR*            ,:UT-PRV-RATE-PLAN-NO                                        
MFA-TR*            ,:UT-CODE-STAT-TAX-XMT                                       
MFA-TR*            ,:UT-CODE-CITY-TAX-XMT                                       
MFA-TR*            ,:UT-CODE-OTHR-TAX-XMT                                       
MFA-TR*            ,:UT-CODE-XCIS-TAX-XMT                                       
MFA-TR*            ,:UT-STATE-TAX-EXMPT-NO                                      
MFA-TR*            ,:UT-TOU-RATE-IND                                            
MFA-TR*            ,:UT-GAS-BASE-LAST-UPDT:WS-NULL-IND-02                       
MFA-TR*            ,:UT-GAS-PREV-BASE-USE                                       
MFA-TR*            ,:UT-GAS-BASE-USE                                            
MFA-TR*            ,:UT-LAST-UPDATE-TS                                          
MFA-TR*            ,:UT-ZERO-USE-INVEST-DT:WS-NULL-IND-01                       
MFA-TR*            ,:UT-ALTERNATE-FUEL-CD)                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8100'                TO ACTIVE-PARAGRAPH            
              MOVE 'INSERT'              TO ABEND-FUNCTION              
              MOVE 'CSS_UTIL_ENVRNMT'    TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2             
              MOVE 'IC_NO'               TO TABLE-ELEMENT-3             
              MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-4             
              MOVE UT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE UT-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2           
              MOVE UT-IC-NO              TO HOSTVAR-ELEMENT-3           
              MOVE UT-PREMISE-NO         TO HOSTVAR-ELEMENT-4           
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8150-UPD-DT-LAST-ACTN-AT.                                      *        
      ******************************************************************        
       8150-UPD-DT-LAST-ACTN-AT.                                        
                                                                        
           EXEC SQL                                                     
              UPDATE AT                                      
                 SET AT.DATE_LAST_ACTION   = IIF(TRY_CONVERT(DATE, 
                                                   :AT-DATE-LAST-ACTION
              ) IS NULL OR (PATINDEX('%.%', :AT-DATE-LAST-ACTION
              ) <> 0) OR (LEN(:AT-DATE-LAST-ACTION
              ) <> 10), CIS.CHAR2DATE(:AT-DATE-LAST-ACTION
              ), CONVERT(DATE, :AT-DATE-LAST-ACTION) )       
              FROM CSS_ACCOUNT AT
               WHERE AT.ACCOUNT_NO         = :AT-ACCOUNT-NO             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_ACCOUNT AT                                             
MFA-TR*          SET AT.DATE_LAST_ACTION   = :AT-DATE-LAST-ACTION               
MFA-TR*        WHERE AT.ACCOUNT_NO         = :AT-ACCOUNT-NO                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8150'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'DATE_LAST_ACTION'    TO TABLE-ELEMENT-2             
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE AT-DATE-LAST-ACTION   TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       8150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8160-UPD-PREMISE-ELEC.                                        *         
      ******************************************************************        
       8160-UPD-PREMISE-ELEC.                                           
                                                                        
           EXEC SQL                                                     
              UPDATE PR                                      
                 SET PR.PERSONAL_CNTCT_CD  = :PR-PERSONAL-CNTCT-CD      
                    ,PR.ELEC_AVAILABLE_IND = :WS-INACTIVE               
              FROM CSS_PREMISE PR
               WHERE PR.PREMISE_NO         = :PR-PREMISE-NO             
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_PREMISE PR                                             
MFA-TR*          SET PR.PERSONAL_CNTCT_CD  = :PR-PERSONAL-CNTCT-CD              
MFA-TR*             ,PR.ELEC_AVAILABLE_IND = :WS-INACTIVE                       
MFA-TR*        WHERE PR.PREMISE_NO         = :PR-PREMISE-NO                     
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8160'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE 'CSS_PREMISE'         TO TABLE-1                     
              MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1             
              MOVE 'PERSONAL_CNTCT_CD'   TO TABLE-ELEMENT-2             
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-3             
              MOVE PR-PREMISE-NO         TO HOSTVAR-ELEMENT-1           
              MOVE PR-PERSONAL-CNTCT-CD  TO HOSTVAR-ELEMENT-2           
              MOVE WS-CURR-ACCOUNT-NO    TO HOSTVAR-ELEMENT-3           
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       8160-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8170-UPD-PREMISE-GAS.                                         *         
      ******************************************************************        
       8170-UPD-PREMISE-GAS.                                            
                                                                        
           EXEC SQL                                                     
              UPDATE PR                                      
                 SET PR.PERSONAL_CNTCT_CD  = :PR-PERSONAL-CNTCT-CD      
                    ,PR.GAS_AVAILABLE_IND  = :WS-INACTIVE               
              FROM CSS_PREMISE PR
               WHERE PR.PREMISE_NO         = :PR-PREMISE-NO             
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_PREMISE PR                                             
MFA-TR*          SET PR.PERSONAL_CNTCT_CD  = :PR-PERSONAL-CNTCT-CD              
MFA-TR*             ,PR.GAS_AVAILABLE_IND  = :WS-INACTIVE                       
MFA-TR*        WHERE PR.PREMISE_NO         = :PR-PREMISE-NO                     
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8170'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE 'CSS_PREMISE'         TO TABLE-1                     
              MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1             
              MOVE 'PERSONAL_CNTCT_CD'   TO TABLE-ELEMENT-2             
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-3             
              MOVE PR-PREMISE-NO         TO HOSTVAR-ELEMENT-1           
              MOVE PR-PERSONAL-CNTCT-CD  TO HOSTVAR-ELEMENT-2           
              MOVE WS-CURR-ACCOUNT-NO    TO HOSTVAR-ELEMENT-3           
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       8170-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8180-UPD-PREMISE-LITE.                                        *         
      ******************************************************************        
       8180-UPD-PREMISE-LITE.                                           
                                                                        
           EXEC SQL                                                     
              UPDATE PR                                      
                 SET PR.PERSONAL_CNTCT_CD  = :PR-PERSONAL-CNTCT-CD      
                    ,PR.LITE_AVAILABLE_IND = :WS-INACTIVE               
              FROM CSS_PREMISE PR
               WHERE PR.PREMISE_NO         = :PR-PREMISE-NO             
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_PREMISE PR                                             
MFA-TR*          SET PR.PERSONAL_CNTCT_CD  = :PR-PERSONAL-CNTCT-CD              
MFA-TR*             ,PR.LITE_AVAILABLE_IND = :WS-INACTIVE                       
MFA-TR*        WHERE PR.PREMISE_NO         = :PR-PREMISE-NO                     
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8180'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE 'CSS_PREMISE'         TO TABLE-1                     
              MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1             
              MOVE 'PERSONAL_CNTCT_CD'   TO TABLE-ELEMENT-2             
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-3             
              MOVE PR-PREMISE-NO         TO HOSTVAR-ELEMENT-1           
              MOVE PR-PERSONAL-CNTCT-CD  TO HOSTVAR-ELEMENT-2           
              MOVE WS-CURR-ACCOUNT-NO    TO HOSTVAR-ELEMENT-3           
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       8180-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8200-UPDATE-UTIL-ENVRNMT.                                      *        
      ******************************************************************        
       8200-UPDATE-UTIL-ENVRNMT.                                        
                                                                        
           EXEC SQL                                                     
              UPDATE UT                                 
                 SET UT.RATE_PLAN_NO       = :UT-RATE-PLAN-NO           
                    ,UT.CODE_REVENUE_CLASS = :UT-CODE-REVENUE-CLASS     
                    ,UT.CODE_CURTAIL_PRTY  = :UT-CODE-CURTAIL-PRTY      
                    ,UT.CODE_SIC_NO        = :UT-CODE-SIC-NO            
                    ,UT.NAICS_CD           = :UT-NAICS-CD               
                    ,UT.SEASONAL_USE_CODE  = :UT-SEASONAL-USE-CODE      
                    ,UT.ZERO_USE_INVEST_DT                              
                               = IIF(TRY_CONVERT(DATE, 
                                                :UT-ZERO-USE-INVEST-DT 
                                                       :WS-NULL-IND-01
              ) IS NULL OR (PATINDEX('%.%', :UT-ZERO-USE-INVEST-DT 
                                                        :WS-NULL-IND-01
              ) <> 0) OR (LEN(:UT-ZERO-USE-INVEST-DT :WS-NULL-IND-01
              ) <> 10), CIS.CHAR2DATE(:UT-ZERO-USE-INVEST-DT 
                                                        :WS-NULL-IND-01
              ), CONVERT(DATE, :UT-ZERO-USE-INVEST-DT :WS-NULL-IND-01
              ) )  
                    ,UT.READ_CYCLE         = :UT-READ-CYCLE             
                    ,UT.READ_ROUTE         = :UT-READ-ROUTE             
                    ,UT.CODE_MTR_READ_FREQ = :UT-CODE-MTR-READ-FREQ     
                    ,UT.CODE_ESTIMATE_OK   = :UT-CODE-ESTIMATE-OK       
                    ,UT.ALTERNATE_FUEL_CD  = :UT-ALTERNATE-FUEL-CD      
                    ,UT.GAS_BASE_USE       = :UT-GAS-BASE-USE           
                    ,UT.GAS_BASE_LAST_UPDT                              
                               = IIF(TRY_CONVERT(DATE, 
                                                :UT-GAS-BASE-LAST-UPDT 
                                                       :WS-NULL-IND-02
              ) IS NULL OR (PATINDEX('%.%', :UT-GAS-BASE-LAST-UPDT 
                                                        :WS-NULL-IND-02
              ) <> 0) OR (LEN(:UT-GAS-BASE-LAST-UPDT :WS-NULL-IND-02
              ) <> 10), CIS.CHAR2DATE(:UT-GAS-BASE-LAST-UPDT 
                                                        :WS-NULL-IND-02
              ), CONVERT(DATE, :UT-GAS-BASE-LAST-UPDT :WS-NULL-IND-02
              ) )  
              FROM CSS_UTIL_ENVRNMT UT
              WHERE  UT.ACCOUNT_NO         = :UT-ACCOUNT-NO             
                AND  UT.CODE_UTIL_TYPE     = :UT-CODE-UTIL-TYPE         
                AND  UT.IC_NO              = :UT-IC-NO                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_UTIL_ENVRNMT UT                                        
MFA-TR*          SET UT.RATE_PLAN_NO       = :UT-RATE-PLAN-NO                   
MFA-TR*             ,UT.CODE_REVENUE_CLASS = :UT-CODE-REVENUE-CLASS             
MFA-TR*             ,UT.CODE_CURTAIL_PRTY  = :UT-CODE-CURTAIL-PRTY              
MFA-TR*             ,UT.CODE_SIC_NO        = :UT-CODE-SIC-NO                    
MFA-TR*             ,UT.NAICS_CD           = :UT-NAICS-CD                       
MFA-TR*             ,UT.SEASONAL_USE_CODE  = :UT-SEASONAL-USE-CODE              
MFA-TR*             ,UT.ZERO_USE_INVEST_DT                                      
MFA-TR*                        = :UT-ZERO-USE-INVEST-DT:WS-NULL-IND-01          
MFA-TR*             ,UT.READ_CYCLE         = :UT-READ-CYCLE                     
MFA-TR*             ,UT.READ_ROUTE         = :UT-READ-ROUTE                     
MFA-TR*             ,UT.CODE_MTR_READ_FREQ = :UT-CODE-MTR-READ-FREQ             
MFA-TR*             ,UT.CODE_ESTIMATE_OK   = :UT-CODE-ESTIMATE-OK               
MFA-TR*             ,UT.ALTERNATE_FUEL_CD  = :UT-ALTERNATE-FUEL-CD              
MFA-TR*             ,UT.GAS_BASE_USE       = :UT-GAS-BASE-USE                   
MFA-TR*             ,UT.GAS_BASE_LAST_UPDT                                      
MFA-TR*                        = :UT-GAS-BASE-LAST-UPDT:WS-NULL-IND-02          
MFA-TR*       WHERE  UT.ACCOUNT_NO         = :UT-ACCOUNT-NO                     
MFA-TR*         AND  UT.CODE_UTIL_TYPE     = :UT-CODE-UTIL-TYPE                 
MFA-TR*         AND  UT.IC_NO              = :UT-IC-NO                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8200'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE 'CSS_UTIL_ENVRNMT'    TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2             
              MOVE 'IC_NO'               TO TABLE-ELEMENT-3             
              MOVE 'ZERO_USE_INVEST_DT'  TO TABLE-ELEMENT-4             
              MOVE UT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE UT-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2           
              MOVE UT-IC-NO              TO HOSTVAR-ELEMENT-3           
              MOVE UT-ZERO-USE-INVEST-DT TO HOSTVAR-ELEMENT-4           
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                                *        
      * 8230-UPDATE-PRORATE-CD.                                        *        
      ******************************************************************        
       8230-UPDATE-PRORATE-CD.                                          
                                                                        
           EXEC SQL                                                     
              UPDATE BG                                  
                 SET BG.PRORATE_CD      = :BG-PRORATE-CD                
              FROM CSS_BILLING_DET BG
               WHERE BG.ACCOUNT_NO      = :BG-ACCOUNT-NO                
                 AND BG.CODE_UTIL_TYPE IN('E','G','U')                  
                 AND BG.IC_NO           = :BG-IC-NO                     
                 AND BG.BILL_NO IN                                      
                           ( SELECT BI.BILL_NO                          
                               FROM CSS_BILLING_HDR BI                  
                              WHERE BI.ACCOUNT_NO = :BI-ACCOUNT-NO      
                                AND BI.DATE_BILLED IS NULL )            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_BILLING_DET BG                                         
MFA-TR*          SET BG.PRORATE_CD      = :BG-PRORATE-CD                        
MFA-TR*        WHERE BG.ACCOUNT_NO      = :BG-ACCOUNT-NO                        
MFA-TR*          AND BG.CODE_UTIL_TYPE IN('E','G','U')                          
MFA-TR*          AND BG.IC_NO           = :BG-IC-NO                             
MFA-TR*          AND BG.BILL_NO IN                                              
MFA-TR*                    ( SELECT BI.BILL_NO                                  
MFA-TR*                        FROM CSS_BILLING_HDR BI                          
MFA-TR*                       WHERE BI.ACCOUNT_NO = :BI-ACCOUNT-NO              
MFA-TR*                         AND BI.DATE_BILLED IS NULL )                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8230'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE 'CSS_BILLING_DET'     TO TABLE-1                     
              MOVE 'CSS_BILLING_HDR'     TO TABLE-2                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2             
              MOVE 'IC_NO'               TO TABLE-ELEMENT-3             
              MOVE 'PRORATE_CD'          TO TABLE-ELEMENT-4             
              MOVE BG-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE BG-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2           
              MOVE BG-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-3           
              MOVE BG-PRORATE-CD         TO HOSTVAR-ELEMENT-4           
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       8230-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8240-UPDATE-BILLING-DET.                                       *        
      ******************************************************************        
       8240-UPDATE-BILLING-DET.                                         
                                                                        
           EXEC SQL                                                     
              UPDATE BG                                  
                 SET BG.CODE_REVENUE_CLASS   = :BG-CODE-REVENUE-CLASS   
                    ,BG.RATE_PLAN_NO         = :BG-RATE-PLAN-NO         
                    ,BG.CODE_SIC_NO          = :BG-CODE-SIC-NO          
                    ,BG.NAICS_CD             = :BG-NAICS-CD             
                    ,BG.GAS_BASE_USE         = :BG-GAS-BASE-USE         
                    ,BG.ALTERNATE_FUEL_CD    = :BG-ALTERNATE-FUEL-CD    
ACT365              ,BG.CODE_CURTAIL_PRTY    = :BG-CODE-CURTAIL-PRTY    
              FROM CSS_BILLING_DET BG
               WHERE BG.ACCOUNT_NO           = :BG-ACCOUNT-NO           
                 AND BG.CODE_UTIL_TYPE       = :BG-CODE-UTIL-TYPE       
                 AND BG.IC_NO                = :BG-IC-NO                
                 AND BG.BILL_NO IN                                      
                               ( SELECT BI.BILL_NO                      
                                   FROM CSS_BILLING_HDR BI              
                                  WHERE BI.ACCOUNT_NO = :BI-ACCOUNT-NO  
                                    AND BI.DATE_BILLED IS NULL )        
                                                                        
                 AND BG.REV_MTH_ORIG_BILL = 0                           
                 AND BG.CODE_BILL_ITM_TYPE <> 'B'                       
                 AND BG.REBILL_IND  <> 'Y'                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_BILLING_DET BG                                         
MFA-TR*          SET BG.CODE_REVENUE_CLASS   = :BG-CODE-REVENUE-CLASS           
MFA-TR*             ,BG.RATE_PLAN_NO         = :BG-RATE-PLAN-NO                 
MFA-TR*             ,BG.CODE_SIC_NO          = :BG-CODE-SIC-NO                  
MFA-TR*             ,BG.NAICS_CD             = :BG-NAICS-CD                     
MFA-TR*             ,BG.GAS_BASE_USE         = :BG-GAS-BASE-USE                 
MFA-TR*             ,BG.ALTERNATE_FUEL_CD    = :BG-ALTERNATE-FUEL-CD            
MFA-TR*             ,BG.CODE_CURTAIL_PRTY    = :BG-CODE-CURTAIL-PRTY            
MFA-TR*        WHERE BG.ACCOUNT_NO           = :BG-ACCOUNT-NO                   
MFA-TR*          AND BG.CODE_UTIL_TYPE       = :BG-CODE-UTIL-TYPE               
MFA-TR*          AND BG.IC_NO                = :BG-IC-NO                        
MFA-TR*          AND BG.BILL_NO IN                                              
MFA-TR*                        ( SELECT BI.BILL_NO                              
MFA-TR*                            FROM CSS_BILLING_HDR BI                      
MFA-TR*                           WHERE BI.ACCOUNT_NO = :BI-ACCOUNT-NO          
MFA-TR*                             AND BI.DATE_BILLED IS NULL )                
MFA-TR*                                                                         
MFA-TR*          AND BG.REV_MTH_ORIG_BILL = 0                                   
MFA-TR*          AND BG.CODE_BILL_ITM_TYPE <> 'B'                               
MFA-TR*          AND BG.REBILL_IND  <> 'Y'                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8240'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE 'CSS_BILLING_DET'     TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2             
              MOVE 'IC_NO'               TO TABLE-ELEMENT-3             
              MOVE BG-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE BG-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2           
              MOVE BG-IC-NO              TO HOSTVAR-ELEMENT-3           
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       8240-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8250-UPDATE-BG-TRANSPORTATION.                                 *        
      ******************************************************************        
       8250-UPDATE-BG-TRANSPORTATION.                                   
                                                                        
           EXEC SQL                                                     
              UPDATE BG                                  
                 SET BG.CODE_REVENUE_CLASS = :BG-CODE-REVENUE-CLASS     
              FROM CSS_BILLING_DET BG
               WHERE BG.ACCOUNT_NO         = :BG-ACCOUNT-NO             
                 AND BG.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE         
                 AND BG.IC_NO              = :BG-IC-NO                  
                 AND BG.BILL_NO IN                                      
                     ( SELECT BI.BILL_NO                                
                         FROM CSS_BILLING_HDR BI                        
                        WHERE BI.ACCOUNT_NO = :BI-ACCOUNT-NO            
                          AND BI.DATE_BILLED IS NULL )                  
                 AND BG.REV_MTH_ORIG_BILL   = 0                         
                 AND BG.CODE_BILL_ITM_TYPE  <> 'B'                      
                 AND BG.REBILL_IND          <> 'Y'                      
                 AND BG.REV_RPT_CD          =  'T'                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_BILLING_DET BG                                         
MFA-TR*          SET BG.CODE_REVENUE_CLASS = :BG-CODE-REVENUE-CLASS             
MFA-TR*        WHERE BG.ACCOUNT_NO         = :BG-ACCOUNT-NO                     
MFA-TR*          AND BG.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE                 
MFA-TR*          AND BG.IC_NO              = :BG-IC-NO                          
MFA-TR*          AND BG.BILL_NO IN                                              
MFA-TR*              ( SELECT BI.BILL_NO                                        
MFA-TR*                  FROM CSS_BILLING_HDR BI                                
MFA-TR*                 WHERE BI.ACCOUNT_NO = :BI-ACCOUNT-NO                    
MFA-TR*                   AND BI.DATE_BILLED IS NULL )                          
MFA-TR*          AND BG.REV_MTH_ORIG_BILL   = 0                                 
MFA-TR*          AND BG.CODE_BILL_ITM_TYPE  <> 'B'                              
MFA-TR*          AND BG.REBILL_IND          <> 'Y'                              
MFA-TR*          AND BG.REV_RPT_CD          =  'T'                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8250'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_BILLING_DET'    TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2              
              MOVE 'IC_NO'              TO TABLE-ELEMENT-3              
              MOVE BG-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE BG-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2            
              MOVE BG-IC-NO             TO HOSTVAR-ELEMENT-3            
              PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
           END-IF.                                                      
                                                                        
       8250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8260-UPDATE-ACCOUNT-DTLS.                                      *        
      ******************************************************************        
       8260-UPDATE-ACCOUNT-DTLS.                                        
                                                                        
           EXEC SQL                                                     
              UPDATE AT                                      
                 SET AT.BILL_CYCLE         = :AT-BILL-CYCLE             
                    ,AT.CODE_DISC_OK       = :AT-CODE-DISC-OK           
              FROM CSS_ACCOUNT AT
               WHERE AT.ACCOUNT_NO         = :AT-ACCOUNT-NO             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_ACCOUNT AT                                             
MFA-TR*          SET AT.BILL_CYCLE         = :AT-BILL-CYCLE                     
MFA-TR*             ,AT.CODE_DISC_OK       = :AT-CODE-DISC-OK                   
MFA-TR*        WHERE AT.ACCOUNT_NO         = :AT-ACCOUNT-NO                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8260'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'BILL_CYCLE'          TO TABLE-ELEMENT-2             
              MOVE 'CODE_DISC_OK'        TO TABLE-ELEMENT-3             
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE AT-BILL-CYCLE         TO HOSTVAR-ELEMENT-2           
              MOVE AT-CODE-DISC-OK       TO HOSTVAR-ELEMENT-3           
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       8260-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8270-UPDATE-READ-DETAILS.                                      *        
      ******************************************************************        
       8270-UPDATE-READ-DETAILS.                                        
                                                                        
           EXEC SQL                                                     
              UPDATE UT                                 
                 SET UT.READ_CYCLE     = :UT-READ-CYCLE                 
                    ,UT.READ_ROUTE     = :UT-READ-ROUTE                 
              FROM CSS_UTIL_ENVRNMT UT
               WHERE UT.ACCOUNT_NO     = :UT-ACCOUNT-NO                 
                 AND CODE_UTIL_TYPE IN ('E','G','U')                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_UTIL_ENVRNMT UT                                        
MFA-TR*          SET UT.READ_CYCLE     = :UT-READ-CYCLE                         
MFA-TR*             ,UT.READ_ROUTE     = :UT-READ-ROUTE                         
MFA-TR*        WHERE UT.ACCOUNT_NO     = :UT-ACCOUNT-NO                         
MFA-TR*          AND CODE_UTIL_TYPE IN ('E','G','U')                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8600'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE 'CSS_UTIL_ENVRNMT'    TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2             
              MOVE 'READ_ROUTE'          TO TABLE-ELEMENT-3             
              MOVE 'READ_CYCLE'          TO TABLE-ELEMENT-4             
              MOVE UT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE WS-CURR-CODE-UTIL-TYPE TO HOSTVAR-ELEMENT-2          
              MOVE UT-READ-ROUTE         TO HOSTVAR-ELEMENT-3           
              MOVE UT-READ-CYCLE         TO HOSTVAR-ELEMENT-4           
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       8270-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8280-UPDATE-MTR-SEQ.                                           *        
      ******************************************************************        
       8280-UPDATE-MTR-SEQ.                                             
                                                                        
           EXEC SQL                                                     
              UPDATE MN                                 
                 SET MN.REGISTER_RD_SEQ   = :MN-REGISTER-RD-SEQ         
              FROM CSS_MTRD_ENVRNMT MN
               WHERE MN.ACCOUNT_NO        = :MN-ACCOUNT-NO              
                 AND MN.CODE_UTIL_TYPE IN ('E','G')                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_MTRD_ENVRNMT MN                                        
MFA-TR*          SET MN.REGISTER_RD_SEQ   = :MN-REGISTER-RD-SEQ                 
MFA-TR*        WHERE MN.ACCOUNT_NO        = :MN-ACCOUNT-NO                      
MFA-TR*          AND MN.CODE_UTIL_TYPE IN ('E','G')                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8280'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE 'CSS_MTRD_ENVRNMT'    TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'REGISTER_RD_SEQ'     TO TABLE-ELEMENT-2             
              MOVE UT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE MN-REGISTER-RD-SEQ    TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       8280-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8290-UPDATE-PREMISE.                                           *        
      ******************************************************************        
       8290-UPDATE-PREMISE.                                             
                                                                        
           EXEC SQL                                                     
              UPDATE PR                                      
                 SET PR.PERSONAL_CNTCT_CD = :PR-PERSONAL-CNTCT-CD       
              FROM CSS_PREMISE PR
               WHERE PR.PREMISE_NO        = :PR-PREMISE-NO              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_PREMISE PR                                             
MFA-TR*          SET PR.PERSONAL_CNTCT_CD = :PR-PERSONAL-CNTCT-CD               
MFA-TR*        WHERE PR.PREMISE_NO        = :PR-PREMISE-NO                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8290'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_PREMISE'        TO TABLE-1                      
              MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-1              
              MOVE 'PERSONAL_CNTCT_CD'  TO TABLE-ELEMENT-2              
              MOVE PR-PREMISE-NO        TO HOSTVAR-ELEMENT-1            
              MOVE PR-PERSONAL-CNTCT-CD TO HOSTVAR-ELEMENT-2            
              PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
           END-IF.                                                      
                                                                        
       8290-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8300-DELETE-INTV-USE-CLASS.                                    *        
      ******************************************************************        
       8300-DELETE-INTV-USE-CLASS.                                      
                                                                        
           EXEC SQL                                                     
              DELETE FROM IU                          
              FROM CSS_INTV_USE_CLASS IU
               WHERE IU.ACCOUNT_NO     = :IU-ACCOUNT-NO                 
                 AND IU.CODE_UTIL_TYPE = :IU-CODE-UTIL-TYPE             
                 AND IU.IC_NO          = :IU-IC-NO                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_INTV_USE_CLASS IU                                 
MFA-TR*        WHERE IU.ACCOUNT_NO     = :IU-ACCOUNT-NO                         
MFA-TR*          AND IU.CODE_UTIL_TYPE = :IU-CODE-UTIL-TYPE                     
MFA-TR*          AND IU.IC_NO          = :IU-IC-NO                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8300'                TO ACTIVE-PARAGRAPH            
              MOVE 'DELETE'              TO ABEND-FUNCTION              
              MOVE 'CSS_INTV_USE_CLASS'  TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2             
              MOVE 'IC_NO'               TO TABLE-ELEMENT-3             
              MOVE UT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE UT-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2           
              MOVE UT-IC-NO              TO HOSTVAR-ELEMENT-3           
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8310-DELETE-BILL-CONTRACT.                                     *        
      ******************************************************************        
       8310-DELETE-BILL-CONTRACT.                                       
                                                                        
           EXEC SQL                                                     
              DELETE FROM BK                           
              FROM CSS_BILL_CONTRACT BK
               WHERE BK.ACCOUNT_NO     = :BK-ACCOUNT-NO                 
                 AND BK.CODE_UTIL_TYPE = :BK-CODE-UTIL-TYPE             
                 AND BK.IC_NO          = :BK-IC-NO                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_BILL_CONTRACT BK                                  
MFA-TR*        WHERE BK.ACCOUNT_NO     = :BK-ACCOUNT-NO                         
MFA-TR*          AND BK.CODE_UTIL_TYPE = :BK-CODE-UTIL-TYPE                     
MFA-TR*          AND BK.IC_NO          = :BK-IC-NO                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8310'                TO ACTIVE-PARAGRAPH            
              MOVE 'DELETE'              TO ABEND-FUNCTION              
              MOVE 'CSS_BILL_CONTRACT'   TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2             
              MOVE 'IC_NO'               TO TABLE-ELEMENT-3             
              MOVE BK-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE BK-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2           
              MOVE BK-IC-NO              TO HOSTVAR-ELEMENT-3           
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       8310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8320-DELETE-MTRD-ENVRNMT.                                      *        
      ******************************************************************        
       8320-DELETE-MTRD-ENVRNMT.                                        
                                                                        
           EXEC SQL                                                     
              DELETE FROM MN                            
              FROM CSS_MTRD_ENVRNMT MN
               WHERE MN.ACCOUNT_NO     = :MN-ACCOUNT-NO                 
                 AND MN.CODE_UTIL_TYPE = :MN-CODE-UTIL-TYPE             
                 AND MN.IC_NO          = :MN-IC-NO                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_MTRD_ENVRNMT MN                                   
MFA-TR*        WHERE MN.ACCOUNT_NO     = :MN-ACCOUNT-NO                         
MFA-TR*          AND MN.CODE_UTIL_TYPE = :MN-CODE-UTIL-TYPE                     
MFA-TR*          AND MN.IC_NO          = :MN-IC-NO                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8320'                TO ACTIVE-PARAGRAPH            
              MOVE 'DELETE'              TO ABEND-FUNCTION              
              MOVE 'CSS_MTRD_ENVRNMT'    TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2             
              MOVE 'IC_NO'               TO TABLE-ELEMENT-3             
              MOVE MN-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE MN-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2           
              MOVE MN-IC-NO              TO HOSTVAR-ELEMENT-3           
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       8320-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8340-DELETE-CUST-PLAN.                                       *          
      ******************************************************************        
       8340-DELETE-CUST-PLAN.                                           
                                                                        
           EXEC SQL                                                     
              DELETE FROM CP                               
              FROM CSS_CUST_PLAN CP
               WHERE CP.ACCOUNT_NO     = :CP-ACCOUNT-NO                 
                 AND CP.CODE_UTIL_TYPE = :CP-CODE-UTIL-TYPE             
                 AND CP.IC_NO          = :CP-IC-NO                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_CUST_PLAN CP                                      
MFA-TR*        WHERE CP.ACCOUNT_NO     = :CP-ACCOUNT-NO                         
MFA-TR*          AND CP.CODE_UTIL_TYPE = :CP-CODE-UTIL-TYPE                     
MFA-TR*          AND CP.IC_NO          = :CP-IC-NO                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8340'                TO ACTIVE-PARAGRAPH            
              MOVE 'DELETE'              TO ABEND-FUNCTION              
              MOVE 'CSS_CUST_PLAN'       TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2             
              MOVE 'IC_NO'               TO TABLE-ELEMENT-3             
              MOVE CP-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE CP-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2           
              MOVE CP-IC-NO              TO HOSTVAR-ELEMENT-3           
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       8340-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8350-DELETE-UTIL-ENVRNMT.                                      *        
      ******************************************************************        
       8350-DELETE-UTIL-ENVRNMT.                                        
                                                                        
           EXEC SQL                                                     
              DELETE FROM UT                            
              FROM CSS_UTIL_ENVRNMT UT
               WHERE UT.ACCOUNT_NO     = :UT-ACCOUNT-NO                 
                 AND UT.CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE             
                 AND UT.IC_NO          = :UT-IC-NO                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_UTIL_ENVRNMT UT                                   
MFA-TR*        WHERE UT.ACCOUNT_NO     = :UT-ACCOUNT-NO                         
MFA-TR*          AND UT.CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE                     
MFA-TR*          AND UT.IC_NO          = :UT-IC-NO                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8350'                TO ACTIVE-PARAGRAPH            
              MOVE 'DELETE'              TO ABEND-FUNCTION              
              MOVE 'CSS_UTIL_ENVRNMT'    TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2             
              MOVE 'IC_NO'               TO TABLE-ELEMENT-3             
              MOVE UT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE UT-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2           
              MOVE UT-IC-NO              TO HOSTVAR-ELEMENT-3           
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       8350-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8400-DEL-UNMTR-CUST-PLAN.                                      *        
      ******************************************************************        
       8400-DEL-UNMTR-CUST-PLAN.                                        
                                                                        
           EXEC SQL                                                     
              DELETE FROM CP                               
              FROM CSS_CUST_PLAN CP
               WHERE CP.ACCOUNT_NO     = :UT-ACCOUNT-NO                 
                 AND CP.CODE_UTIL_TYPE = 'U'                            
                 AND CP.IC_NO          = :WS-UT-IC-NO                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_CUST_PLAN CP                                      
MFA-TR*        WHERE CP.ACCOUNT_NO     = :UT-ACCOUNT-NO                         
MFA-TR*          AND CP.CODE_UTIL_TYPE = 'U'                                    
MFA-TR*          AND CP.IC_NO          = :WS-UT-IC-NO                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8400'                TO ACTIVE-PARAGRAPH            
              MOVE 'DELETE'              TO ABEND-FUNCTION              
              MOVE 'CSS_CUST_PLAN'       TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'IC_NO'               TO TABLE-ELEMENT-2             
              MOVE UT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE WS-UT-IC-NO           TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       8400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8410-DEL-UNMTR-UTIL-ENVRNMT.                                   *        
      ******************************************************************        
       8410-DEL-UNMTR-UTIL-ENVRNMT.                                     
                                                                        
           EXEC SQL                                                     
              DELETE FROM UT                            
              FROM CSS_UTIL_ENVRNMT UT
               WHERE UT.ACCOUNT_NO     = :UT-ACCOUNT-NO                 
                 AND UT.CODE_UTIL_TYPE = :WS-UNMETER                    
                 AND UT.IC_NO          = :WS-UT-IC-NO                   
                 AND UT.RATE_PLAN_NO   = :WS-SUBDVSN-LIGHT              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_UTIL_ENVRNMT UT                                   
MFA-TR*        WHERE UT.ACCOUNT_NO     = :UT-ACCOUNT-NO                         
MFA-TR*          AND UT.CODE_UTIL_TYPE = :WS-UNMETER                            
MFA-TR*          AND UT.IC_NO          = :WS-UT-IC-NO                           
MFA-TR*          AND UT.RATE_PLAN_NO   = :WS-SUBDVSN-LIGHT                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8410'                TO ACTIVE-PARAGRAPH            
              MOVE 'DELETE'              TO ABEND-FUNCTION              
              MOVE 'CSS_UTIL_ENVRNMT'    TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'IC_NO'               TO TABLE-ELEMENT-2             
              MOVE UT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE WS-UT-IC-NO           TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
                                                                        
       8410-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8420-UPDT-PREMSE-INFO.                                         *        
      ******************************************************************        
       8420-UPDT-PREMSE-INFO.                                           
                                                                        
           EXEC SQL                                                     
              UPDATE PR                                      
                 SET PR.LITE_AVAILABLE_IND = ' '                        
              FROM CSS_PREMISE PR
               WHERE PR.PREMISE_NO         = :PR-PREMISE-NO             
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_PREMISE PR                                             
MFA-TR*          SET PR.LITE_AVAILABLE_IND = ' '                                
MFA-TR*        WHERE PR.PREMISE_NO         = :PR-PREMISE-NO                     
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8420'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_PREMISE'        TO TABLE-1                      
              MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-1              
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2              
              MOVE WS-CURR-ACCOUNT-NO   TO HOSTVAR-ELEMENT-1            
              MOVE PR-PREMISE-NO        TO HOSTVAR-ELEMENT-2            
              PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
           END-IF.                                                      
                                                                        
       8420-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8430-UPDATE-ACCT-TYPE.                                         *        
      ******************************************************************        
       8430-UPDATE-ACCT-TYPE.                                           
                                                                        
           EXEC SQL                                                     
              UPDATE AT                                      
                 SET AT.ACCOUNT_TYPE_CODE = :AT-ACCOUNT-TYPE-CODE       
              FROM CSS_ACCOUNT AT
               WHERE AT.ACCOUNT_NO        = :AT-ACCOUNT-NO              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_ACCOUNT AT                                             
MFA-TR*          SET AT.ACCOUNT_TYPE_CODE = :AT-ACCOUNT-TYPE-CODE               
MFA-TR*        WHERE AT.ACCOUNT_NO        = :AT-ACCOUNT-NO                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8430'                     TO ACTIVE-PARAGRAPH       
              MOVE 'UPDATE'                   TO ABEND-FUNCTION         
              MOVE 'CSS_ACCOUNT'              TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'ACCOUNT_TYPE_CODE'        TO TABLE-ELEMENT-2        
              MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE AT-ACCOUNT-TYPE-CODE       TO HOSTVAR-ELEMENT-2      
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       8430-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *8005-SEND-RESULT                                                *        
      ******************************************************************        
       8005-SEND-RESULT.                                                
                                                                        
           ADD +1                       TO CTR-ROWS.                    
                                                                        
       8005-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************** ***********************************************        
      * 9700-ABEND-PROCESSING.                                         *        
      ******************************************************************        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT.             
           PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT.             
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900 - JOURNALING / ERROR HANDLING ROUTINE                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
           EXEC SQL                                                             
             INCLUDE CPD00321                                                   
           END-EXEC.                                                            
                                                                        
