       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       CSR04641.                                      
       AUTHOR.        SAKTHIVEL MATHIYAZHAGAN.                          
COB303 DATE-WRITTEN.     AUGUST 14, 2013                                
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE:  CSR04641              --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--                                                            --         
      *--  CSR04641 :                                                --         
      *--                                                            --         
      *--  RETRIEVE RATE DETAIlS TO DISPLAY IN RATE DETAILS SCREEN.  --         
      *--                                                            --         
      *--  CLONED FROM CSR02046.                                     --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *--  PARAMETERS:                                               --         
      *--                                                            --         
      *--  INPUT PARAMETERS.                                         --         
      *--                                                            --         
      *--           ACCOUNT_NO             DECIMAL(13)               --         
      *--           CODE_UTIL_TYPE         CHAR(02)                  --         
      *--           IC_NO                  SMALLINT                  --         
      *--                                                            --         
      *--                                                            --         
      *--  OUTPUT RESULT SET.                                        --         
      *--                                                            --         
      *--  CSR04641_R1 - RATE DETAILS                                --         
      *--                                                            --         
      *--           RETURN_CODE            INTEGER                   --         
      *--          ,APPL_RETURN_CODE       INTEGER                   --         
      *--          ,CODE_UTIL_TYPE         CHAR(1)                   --         
      *--          ,IC_NO                  SMALLINT                  --         
      *--          ,RATE_PLAN_NO           CHAR(3)                   --         
      *--          ,RATE_PLAN_DESC         CHAR(50)                  --         
      *--          ,CODE_REVENUE_CLASS     CHAR(3)                   --         
      *--          ,SECURED_RATE_FL        CHAR(1)                   --         
      *--          ,CODE_SIC_NO            CHAR(4)                   --         
      *--          ,NAICS_CD               CHAR(6)                   --         
      *--          ,SEASONAL_USE_CODE      CHAR(2)                   --         
      *--          ,ZERO_USE_INVEST_DT     DATE                      --         
      *--          ,READ_CYCLE             CHAR(2)                   --         
      *--          ,READ_ROUTE             SMALLINT                  --         
      *--          ,CODE_MTR_READ_FREQ     CHAR(3)                   --         
      *--          ,CODE_ESTIMATE_OK       CHAR(1)                   --         
      *--          ,PERSONAL_CNTCT_CD      CHAR(1)                   --         
      *--          ,ALTERNATE_FUEL_CD      CHAR(1)                   --         
      *--          ,WNA_GROUP_NO           SMALLINT                  --         
      *--          ,WNA_GROUP_DESC         CHAR(80)                  --         
      *--          ,GAS_BASE_USE           DECIMAL(9,0)              --         
      *--          ,GAS_BASE_LAST_UPDT     CHAR (10)                 --         
      *--          ,PRTY_SVC_CAT_CD        CHAR (02)                 --         
      *--          ,AGL_SENIOR_FLAG        CHAR (01)                 --         
      *--          ,TIER_ACCT_TYPE_CD      CHAR (01)                 --         
      *--          ,TIER_CUST_STAT_CD      CHAR (01)                 --         
      *--          ,MKT_TIER_RANKING       SMALLINT                  --         
      *--          ,ADJUSTABLE_OPTION_FLAG CHAR(01)                  --         
      *--                                                            --         
      *--  CSR04641_R2 - BUS RULE DETAILS.                           --         
      *--                                                            --         
      *--           RETURN_CODE            INTEGER                   --         
      *--          ,APPL_RETURN_CODE       INTEGER                   --         
      *--          ,BUS_RULE_ID            CHAR(10)                  --         
      *--          ,BUS_RULE_RESULT_CD     CHAR(10)                  --         
      *--          ,BUS_RULE_XREF_ID       CHAR(26)                  --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                        MODIFICATION LOG                    --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
      *--  08/14/2013    MS93554     RETRIEVE RATE DETAILS.          --         
ACT163*--  05/12/2016    TP7R341     REMOVE REFERENCES TO THE TABLE  --         
ACT163*--                APPL5460    CSS_ELEC_WNA_PARMS              --         
      *----------------------------------------------------------------         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04641'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-START                   PIC X(40) VALUE                    
            'WORKING STORAGE FOR CSR04641 STARTS HERE'.                 
      *                                                                         
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-SUBROUTINE-IDS.                                       
               10  CSRERLOG                 PIC X(8)  VALUE 'CSRERLOG'. 
           05  PROGRAM-NAME                 PIC X(08) VALUE 'CSR04641'. 
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN                   PIC S9(9) COMP VALUE 1.     
           05  CTR-ROWS-RS1                 PIC S9(9) COMP VALUE 0.     
           05  CTR-ROWS-RS2                 PIC S9(9) COMP VALUE 0.     
                                                                        
       01  WS-MISC.                                                     
           05  WS-SQLSTATE                  PIC X(05) VALUE SPACES.     
           05  WS-GTT-NAME                  PIC X(19) VALUE SPACES.     
           05  WS-APPL-RETURN-CODE          PIC S9(4) COMP VALUE 0.     
           05  WS-NON-UTILITY               PIC X(01) VALUE 'N'.        
           05  WS-AGL-SENIOR-FLAG           PIC X(01) VALUE SPACES.     
           05  WS-STAT-ADJUSTABLE-CD        PIC X(01) VALUE 'N'.        
           05  WS-RATE-CODE-STATUS          PIC X(01) VALUE SPACES.     
           05  WS-INACT                     PIC X(01) VALUE 'I'.        
           05  WS-DISPLAY-END-TS            PIC X(26) VALUE SPACES.     
           05  WS-CURRENT-TS                PIC X(26) VALUE SPACES.     
                                                                        
       01  WS-BUS-RULE-ID.                                              
           05  WS-MRM-INACT-RULE-ID         PIC X(10) VALUE             
                                                      'MRM0000056'.     
           05  WS-MRM-ACC-DEP-RULE-ID       PIC X(10) VALUE             
                                                      'MRM0000058'.     
           05  WS-MRM-NON-UTIL-ACCOUNT      PIC X(10) VALUE             
                                                      'MRM0000021'.     
           05  WS-MRM-DEP-MASTER-ACCT       PIC X(10) VALUE             
                                                      'MRM0000009'.     
           05  WS-MRM-UTIL-ENVIR-ERROR      PIC X(10) VALUE             
                                                      'MRM0000008'.     
       01  WS-FLAGS.                                                    
           05  WS-YES-NULL                  PIC S9(4) VALUE -1.         
           05  WS-YES                       PIC X(01) VALUE 'Y'.        
           05  WS-NO                        PIC X(01) VALUE 'N'.        
           05  WS-ZERO                      PIC S9(4) VALUE 0.          
           05  WS-ELECTRIC                  PIC X(01) VALUE 'E'.        
           05  WS-GAS                       PIC X(01) VALUE 'G'.        
           05  WS-FAILED                    PIC X(01) VALUE 'F'.        
           05  WS-DELINQ-CD                 PIC X(08) VALUE 'DATABASE'. 
           05  WS-CHECK-FOR-DEP             PIC X(01) VALUE 'N'.        
           05  WS-CHECK-FOR-MST             PIC X(01) VALUE 'N'.        
                                                                        
       01  WS-NULL-INDICATORS.                                          
           05  WS-NULL-IND-01               PIC S9(04) COMP.            
           05  WS-NULL-IND-02               PIC S9(04) COMP.            
           05  WS-NULL-IND-03               PIC S9(04) COMP.            
                                                                        
       01  WS-ERR-FLAGS.                                                
           05  WS-ERR-INSRT-R1              PIC X(01) VALUE 'N'.        
           05  WS-ERR-INSRT-R2              PIC X(01) VALUE 'N'.        
                                                                        
       01  WS-SWITCHES.                                                 
           05  WS-DATABASE                  PIC 9(01) VALUE ZERO.       
               88 CSR-DATABASE                        VALUE 1.          
               88 SEB-DATABASE                        VALUE 2.          
                                                                        
      ****************************************************************          
      *                                                              *          
      *    ERROR PROCESSING VARIABLES                                *          
      ****************************************************************          
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
                                                                        
       01 GTT-RETURN-FIELDS.                                            
      *********************************************************                 
      *   GTT TABLE LAYOUT FOR RATE CSS_UTIL_ENVRNMT          *                 
      *********************************************************                 
          05 S-RETURN-CODE                  PIC S9(04) COMP VALUE 0.    
          05 GTT-RETURN-FIELDS-1.                                       
             10 S-RETURN-CODE-1             PIC S9(04) COMP VALUE 0.    
             10 S-APPL-RETURN-CODE-1        PIC S9(04) COMP VALUE 0.    
             10 S-RS1-CODE-UTIL-TYPE        PIC X(01)  VALUE SPACES.    
             10 S-RS1-IC-NO                 PIC S9(04) USAGE COMP       
                                                       VALUE 0.         
             10 S-RS1-RATE-PLAN-NO          PIC X(03)  VALUE SPACES.    
             10 S-RS1-RATE-PLAN-DESC        PIC X(50)  VALUE SPACES.    
             10 S-RS1-CODE-REVENUE-CLASS    PIC X(03)  VALUE SPACES.    
             10 S-RS1-SECURED-RATE-FL       PIC X(01)  VALUE SPACES.    
             10 S-RS1-CODE-SIC-NO           PIC X(04)  VALUE SPACES.    
             10 S-RS1-NAICS-CD              PIC X(06)  VALUE SPACES.    
             10 S-RS1-SEASONAL-USE-CODE     PIC X(02)  VALUE SPACES.    
             10 S-RS1-ZERO-USE-INVEST-DT    PIC X(10)  VALUE SPACES.    
             10 S-RS1-READ-CYCLE            PIC X(02)  VALUE SPACES.    
             10 S-RS1-READ-ROUTE            PIC S9(4)  USAGE COMP.      
             10 S-RS1-CODE-MTR-READ-FREQ    PIC X(03)  VALUE SPACES.    
             10 S-RS1-CODE-ESTIMATE-OK      PIC X(01)  VALUE SPACES.    
             10 S-RS1-PERSONAL-CNTCT-CD     PIC X(01)  VALUE SPACES.    
             10 S-RS1-ALTERNATE-FUEL-CD     PIC X(01)  VALUE SPACES.    
             10 S-RS1-ELEC-WNA-GROUP-NO     PIC S9(4)  USAGE COMP.      
             10 S-RS1-WNA-GROUP-DESC        PIC X(80)  VALUE SPACES.    
COB305       10 S-RS1-GAS-BASE-USE        PIC S9(9)V USAGE COMP-3 
COB305          VALUE 0.    
             10 S-RS1-GAS-BASE-LAST-UPDT    PIC X(10)  VALUE SPACES.    
             10 S-RS1-PRTY-SVC-CAT-CD       PIC X(02)  VALUE SPACES.    
             10 S-RS1-AGL-SENIOR-FLAG       PIC X(01)  VALUE SPACES.    
             10 S-RS1-TIER-ACCT-TYPE-CD     PIC X(01)  VALUE SPACES.    
             10 S-RS1-TIER-CUST-STAT-CD     PIC X(01)  VALUE SPACES.    
             10 S-RS1-MKT-TIER-RANKING      PIC S9(4)  USAGE COMP       
                                                       VALUE ZERO.      
             10 S-RS1-ADJ-OPTION-FLAG       PIC X(01)  VALUE SPACES.    
      *********************************************************                 
      *   GTT TABLE LAYOUT FOR BUS RULE ERROR MESSAGE        *                  
      *********************************************************                 
          05 GTT-RETURN-FIELDS-2.                                       
             10 S-RETURN-CODE-2             PIC S9(04) COMP VALUE 0.    
             10 S-APPL-RETURN-CODE-2        PIC S9(04) COMP VALUE 0.    
             10 S-RS2-BUS-RULE-ID           PIC X(10)  VALUE SPACES.    
             10 S-RS2-BUS-RULE-RESULT-CD    PIC X(10)  VALUE SPACES.    
             10 S-RS2-BUS-RULE-XREF-ID      PIC X(26)  VALUE SPACES.    
                                                                        
      ******************************************************************        
      *               COBOL WORKING STORAGE COPY BOOKS                 *        
      ******************************************************************        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_UTIL_ENVRNMT   UT                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ACCT_MKT_TIER  DD                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMKTIER                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ACCT_RTPK_AGR  DF                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBACCTRG                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_FIXED_FCTR     FF                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBFXDFCT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CRM_OPT_ATTR_INCTV HQ                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBOPTATT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ACCT_ATTRIBUTE YP                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBACTATT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_CODE_VALUE     UV                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCDVALU                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_REV_CLS_RATE   Q4                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRVCLS                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_REV_CLS_RATE   PR                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ACCOUNT        AT                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_DELINQUENCY     C8                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_PRTY_SVC_CAT_CD Z8                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBSVCCAT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_RATE_CREATOR    RT                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRTCRTR                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_RATE_PLAN_DESC  RD                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRTDESC                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_UTL_BILL_REL    UR                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBUTLREL                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
      ******************************************************************        
      *    ERROR HANDLING                                                       
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    SUPPORTS DB2 AND SQL ERROR CHECKING                         *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
                                                                        
       LINKAGE SECTION.                                                 
COB305 01 I-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.               
       01 I-CODE-UTIL-TYPE      PIC X(01).                              
       01 I-IC-NO               PIC S9(4)   USAGE COMP.                 
                                                                        
       PROCEDURE DIVISION USING I-ACCOUNT-NO                            
                                I-CODE-UTIL-TYPE                        
                                I-IC-NO.                                
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 1000-PROCESS-INPUT       THRU 1000-EXIT.             
           PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT.             
           PERFORM 9999-END-PROGRAM         THRU 9999-EXIT.             
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100A-DECLARE-GTT-R1                                           *        
      ******************************************************************        
       0100A-DECLARE-GTT-R1.                                            
                                                                        
           MOVE 'SESSION.CSR04641_R1'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04641_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04641_R1
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,CODE_UTIL_TYPE CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,IC_NO                   SMALLINT                    
                   ,RATE_PLAN_NO CHAR(3)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,RATE_PLAN_DESC CHAR(50)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,CODE_REVENUE_CLASS CHAR(3)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,SECURED_RATE_FL CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,CODE_SIC_NO CHAR(4)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,NAICS_CD CHAR(6)  COLLATE LATIN1_GENERAL_100_BIN2           
                   ,SEASONAL_USE_CODE CHAR(2)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,ZERO_USE_INVEST_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,READ_CYCLE CHAR(2)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,READ_ROUTE              SMALLINT                    
                   ,CODE_MTR_READ_FREQ CHAR(3)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,CODE_ESTIMATE_OK CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,PERSONAL_CNTCT_CD CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,ALTERNATE_FUEL_CD CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,WNA_GROUP_NO            SMALLINT                    
                   ,WNA_GROUP_DESC CHAR(80)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,GAS_BASE_USE            DECIMAL(9,0)                
                   ,GAS_BASE_LAST_UPDT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PRTY_SVC_CAT_CD CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,AGL_SENIOR_FLAG CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,TIER_ACCT_TYPE_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,TIER_CUST_STAT_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,MKT_TIER_RANKING        SMALLINT                    
                   ,ADJUSTABLE_OPTION_FLAG CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS    THRU 8000A-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100A'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,LTRIM(RTRIM(CODE_UTIL_TYPE))       AS 
           CODE_UTIL_TYPE    
                      ,IC_NO                       AS IC_NO             
                      ,LTRIM(RTRIM(RATE_PLAN_NO))         AS 
           RATE_PLAN_NO      
                      ,LTRIM(RTRIM(RATE_PLAN_DESC))       AS 
           RATE_PLAN_DESC    
                      ,LTRIM(RTRIM(CODE_REVENUE_CLASS))   AS 
           CODE_REVENUE_CLASS
                      ,LTRIM(RTRIM(SECURED_RATE_FL))      AS 
           SECURED_RATE_FL   
                      ,LTRIM(RTRIM(CODE_SIC_NO))          AS CODE_SIC_NO       
                      ,LTRIM(RTRIM(NAICS_CD))             AS NAICS_CD          
                      ,LTRIM(RTRIM(SEASONAL_USE_CODE))    AS 
           SEASONAL_USE_CODE 
                      ,LTRIM(RTRIM(ZERO_USE_INVEST_DT))   AS 
           ZERO_USE_INVEST_DT
                      ,LTRIM(RTRIM(READ_CYCLE))           AS READ_CYCLE        
                      ,READ_ROUTE                  AS READ_ROUTE        
                      ,LTRIM(RTRIM(CODE_MTR_READ_FREQ))   AS 
           CODE_MTR_READ_FREQ
                      ,LTRIM(RTRIM(CODE_ESTIMATE_OK))     AS 
           CODE_ESTIMATE_OK  
                      ,LTRIM(RTRIM(PERSONAL_CNTCT_CD))    AS 
           PERSONAL_CNTCT_CD 
                      ,LTRIM(RTRIM(ALTERNATE_FUEL_CD))    AS 
           ALTERNATE_FUEL_CD 
                      ,WNA_GROUP_NO                AS WNA_GROUP_NO      
                      ,LTRIM(RTRIM(WNA_GROUP_DESC))       AS 
           WNA_GROUP_DESC    
                      ,GAS_BASE_USE                AS GAS_BASE_USE      
                      ,LTRIM(RTRIM(GAS_BASE_LAST_UPDT))   AS 
           GAS_BASE_LAST_UPDT
                      ,LTRIM(RTRIM(PRTY_SVC_CAT_CD))      AS 
           PRTY_SVC_CAT_CD   
                      ,LTRIM(RTRIM(AGL_SENIOR_FLAG))      AS 
           AGL_SENIOR_FLAG   
                      ,LTRIM(RTRIM(TIER_ACCT_TYPE_CD))    AS 
           TIER_ACCT_TYPE_CD 
                      ,LTRIM(RTRIM(TIER_CUST_STAT_CD))    AS 
           TIER_CUST_STAT_CD 
                      ,MKT_TIER_RANKING            AS MKT_TIER_RANKING  
                      ,LTRIM(RTRIM(ADJUSTABLE_OPTION_FLAG))                    
                                               AS ADJUSTABLE_OPTION_FLAG
                  FROM #CSR04641_R1                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,STRIP(CODE_UTIL_TYPE)       AS CODE_UTIL_TYPE            
MFA-TR*               ,IC_NO                       AS IC_NO                     
MFA-TR*               ,STRIP(RATE_PLAN_NO)         AS RATE_PLAN_NO              
MFA-TR*               ,STRIP(RATE_PLAN_DESC)       AS RATE_PLAN_DESC            
MFA-TR*               ,STRIP(CODE_REVENUE_CLASS)   AS CODE_REVENUE_CLASS        
MFA-TR*               ,STRIP(SECURED_RATE_FL)      AS SECURED_RATE_FL           
MFA-TR*               ,STRIP(CODE_SIC_NO)          AS CODE_SIC_NO               
MFA-TR*               ,STRIP(NAICS_CD)             AS NAICS_CD                  
MFA-TR*               ,STRIP(SEASONAL_USE_CODE)    AS SEASONAL_USE_CODE         
MFA-TR*               ,STRIP(ZERO_USE_INVEST_DT)   AS ZERO_USE_INVEST_DT        
MFA-TR*               ,STRIP(READ_CYCLE)           AS READ_CYCLE                
MFA-TR*               ,READ_ROUTE                  AS READ_ROUTE                
MFA-TR*               ,STRIP(CODE_MTR_READ_FREQ)   AS CODE_MTR_READ_FREQ        
MFA-TR*               ,STRIP(CODE_ESTIMATE_OK)     AS CODE_ESTIMATE_OK          
MFA-TR*               ,STRIP(PERSONAL_CNTCT_CD)    AS PERSONAL_CNTCT_CD         
MFA-TR*               ,STRIP(ALTERNATE_FUEL_CD)    AS ALTERNATE_FUEL_CD         
MFA-TR*               ,WNA_GROUP_NO                AS WNA_GROUP_NO              
MFA-TR*               ,STRIP(WNA_GROUP_DESC)       AS WNA_GROUP_DESC            
MFA-TR*               ,GAS_BASE_USE                AS GAS_BASE_USE              
MFA-TR*               ,STRIP(GAS_BASE_LAST_UPDT)   AS GAS_BASE_LAST_UPDT        
MFA-TR*               ,STRIP(PRTY_SVC_CAT_CD)      AS PRTY_SVC_CAT_CD           
MFA-TR*               ,STRIP(AGL_SENIOR_FLAG)      AS AGL_SENIOR_FLAG           
MFA-TR*               ,STRIP(TIER_ACCT_TYPE_CD)    AS TIER_ACCT_TYPE_CD         
MFA-TR*               ,STRIP(TIER_CUST_STAT_CD)    AS TIER_CUST_STAT_CD         
MFA-TR*               ,MKT_TIER_RANKING            AS MKT_TIER_RANKING          
MFA-TR*               ,STRIP(ADJUSTABLE_OPTION_FLAG)                            
MFA-TR*                                        AS ADJUSTABLE_OPTION_FLAG        
MFA-TR*           FROM SESSION.CSR04641_R1                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100B-DECLARE-GTT-R2                                           *        
      ******************************************************************        
       0100B-DECLARE-GTT-R2.                                            
                                                                        
           MOVE 'SESSION.CSR04641_R2'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04641_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04641_R2
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,BUS_RULE_ID CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BUS_RULE_RESULT_CD CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BUS_RULE_XREF_ID CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000B-DEL-GTT-ROWS    THRU 8000B-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100B'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C2 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,LTRIM(RTRIM(BUS_RULE_ID))          AS BUS_RULE_ID       
                      ,LTRIM(RTRIM(BUS_RULE_RESULT_CD))   AS 
           BUS_RULE_RESULT_CD
                      ,LTRIM(RTRIM(BUS_RULE_XREF_ID))     AS 
           BUS_RULE_XREF_ID  
                  FROM #CSR04641_R2                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C2 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,STRIP(BUS_RULE_ID)          AS BUS_RULE_ID               
MFA-TR*               ,STRIP(BUS_RULE_RESULT_CD)   AS BUS_RULE_RESULT_CD        
MFA-TR*               ,STRIP(BUS_RULE_XREF_ID)     AS BUS_RULE_XREF_ID          
MFA-TR*           FROM SESSION.CSR04641_R2                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100B-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE I-ACCOUNT-NO                TO AT-ACCOUNT-NO            
                                               UT-ACCOUNT-NO            
                                               DD-ACCOUNT-NO            
                                               DF-ACCOUNT-NO            
                                               FF-ACCOUNT-NO            
                                               YP-ACCOUNT-NO.           
                                                                        
           MOVE I-CODE-UTIL-TYPE            TO UT-CODE-UTIL-TYPE        
                                               DF-CODE-UTIL-TYPE        
                                               FF-CODE-UTIL-TYPE        
                                               Q8-CODE-UTIL-TYPE.       
                                                                        
           MOVE I-IC-NO                     TO UT-IC-NO                 
                                               DF-IC-NO                 
                                               FF-IC-NO.                
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1        THRU 0100A-EXIT.         
           PERFORM 0100B-DECLARE-GTT-R2        THRU 0100B-EXIT.         
                                                                        
      *    GET THE DATABASE.                                                    
           MOVE WS-DELINQ-CD                TO C8-DELINQ-CD.            
           MOVE '01'                        TO C8-COMPANY-NO.           
           PERFORM 7500-GET-DELINQ-VALUE       THRU 7500-EXIT.          
           MOVE C8-DELINQ-VALUE             TO WS-DATABASE.             
      *                                                                         
           IF SEB-DATABASE                                              
              PERFORM 1100-VALIDATE-MASTER-ACCT                         
                                               THRU 1100-EXIT           
           END-IF.                                                      
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * VALIDATE THE ACCOUNT TO SEE IT IS A MASTER                    *         
      *                                                               *         
      *****************************************************************         
       1100-VALIDATE-MASTER-ACCT.                                       
                                                                        
           PERFORM 7025-GET-ACCT-TYPE          THRU 7025-EXIT           
                                                                        
      *    IF THE ACCOUNT IS A NON-UTILITY, AND IS NOT EITHER AN                
      *    ADDITIVE OR SUBTRACTIVE MASTER, SEND A MESSAGE TO USER.              
                                                                        
           IF (AT-ACCOUNT-TYPE-CODE EQUAL WS-NON-UTILITY                
              AND AT-CODE-ACCT-USAGE NOT EQUAL 'A'                      
              AND AT-CODE-ACCT-USAGE NOT EQUAL 'C'                      
              AND AT-CODE-ACCT-USAGE NOT EQUAL 'E')                     
                                                                        
              MOVE WS-MRM-NON-UTIL-ACCOUNT  TO S-RS2-BUS-RULE-ID        
              MOVE WS-FAILED                TO S-RS2-BUS-RULE-RESULT-CD 
              IF S-RS2-BUS-RULE-ID GREATER THAN SPACES                  
                 PERFORM 7550-GET-RULE-XREF-ID THRU 7550-EXIT           
              END-IF                                                    
              PERFORM 8020-INSERT-GTT-R2       THRU 8020-EXIT           
              PERFORM 9999-END-PROGRAM         THRU 9999-EXIT           
                                                                        
           ELSE IF AT-MST-SUB-ACCT-IND = 'M'                            
                                                                        
              MOVE WS-MRM-DEP-MASTER-ACCT   TO S-RS2-BUS-RULE-ID        
              MOVE WS-FAILED                TO S-RS2-BUS-RULE-RESULT-CD 
              IF S-RS2-BUS-RULE-ID GREATER THAN SPACES                  
                 PERFORM 7550-GET-RULE-XREF-ID THRU 7550-EXIT           
              END-IF                                                    
              PERFORM 8020-INSERT-GTT-R2       THRU 8020-EXIT           
              PERFORM 9999-END-PROGRAM         THRU 9999-EXIT           
           END-IF
           END-IF.                                                      
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2000-PROCESS-OUTPUT                                            *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 7100-SELECT-UTIL-ENVRNMT    THRU 7100-EXIT.          
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              PERFORM 2100-BUILD-RESULT-SET    THRU 2100-EXIT           
           ELSE                                                         
              MOVE WS-MRM-UTIL-ENVIR-ERROR  TO S-RS2-BUS-RULE-ID        
              MOVE WS-FAILED                TO S-RS2-BUS-RULE-RESULT-CD 
              IF S-RS2-BUS-RULE-ID GREATER THAN SPACES                  
                 PERFORM 7550-GET-RULE-XREF-ID THRU 7550-EXIT           
              END-IF                                                    
              PERFORM 8020-INSERT-GTT-R2       THRU 8020-EXIT           
              PERFORM 9999-END-PROGRAM         THRU 9999-EXIT           
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2100-BUILD-RESULT-SET.                                         *        
      ******************************************************************        
       2100-BUILD-RESULT-SET.                                           
                                                                        
           MOVE UT-CODE-CURTAIL-PRTY        TO Z4-CODE-CURTAIL-PRTY.    
           MOVE UT-PREMISE-NO               TO PR-PREMISE-NO.           
           MOVE UT-RATE-PLAN-NO             TO Q8-RATE-PLAN-NO.         
           MOVE UT-CODE-REVENUE-CLASS       TO Q8-CODE-REVENUE-CLASS.   
           MOVE UT-COMPANY-NO               TO Q8-COMPANY-NO            
                                               Z4-COMPANY-NO.           
                                                                        
ACT163*    INITIALIZE                          Q8-ELEC-WNA-GROUP-NO             
ACT163     INITIALIZE                          UV-CODE-LONG-DESC.       
                                                                        
      *    GET RATE PACKAGE AGREEMENT AND FIXED FACTOR FOR ADJ-FLAG             
           IF SEB-DATABASE                                              
              PERFORM 7110-GET-RTPK-AGREE-DET  THRU 7110-EXIT           
              IF DF-STAT-ADJUSTABLE-CD = 'A'                            
                 MOVE DF-OPTION-CD          TO HQ-OPTION-CD             
                 MOVE DF-RT-PKG-OPT-SEQ-NO  TO FF-RT-PKG-OPT-SEQ-NO     
                 PERFORM 7120-SEL-FIXED-FACTOR-DET                      
                                               THRU 7120-EXIT           
                 IF FF-DURATION-REMAIN-NO > 0                           
                    MOVE 'Y'                TO WS-STAT-ADJUSTABLE-CD    
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
      *    GET PERSONAL CONTACT CODE ( CALL-AHEAD)                              
           PERFORM 7200-GET-PRSNL-CNTCT-CD     THRU 7200-EXIT.          
                                                                        
ACT163*    GET ELECTRIC WNA GROUP NUMBER & DESC. ( WNA GROUP)                   
ACT163*    IF UT-CODE-UTIL-TYPE EQUAL WS-ELECTRIC                               
ACT163*       PERFORM 7300-GET-WNA-GROUP       THRU 7300-EXIT                   
ACT163*    END-IF.                                                              
                                                                        
      *    GET PRIORITY OF SERVICE CATEGORY CODE.                               
           IF ((UT-CODE-CURTAIL-PRTY > WS-ZERO) AND (CSR-DATABASE))     
              PERFORM 7400-GET-PRTY-SVC-CAT-CD THRU 7400-EXIT           
              MOVE Z4-PRTY-SVC-CAT-CD       TO S-RS1-PRTY-SVC-CAT-CD    
           ELSE                                                         
              MOVE SPACES                   TO S-RS1-PRTY-SVC-CAT-CD    
           END-IF.                                                      
                                                                        
      *    GET MARKET TIER DETAILS AND AGL_SENIOR_FLAG FOR SEB-DATABASE         
           IF SEB-DATABASE                                              
              PERFORM 7560-GET-MKT-TIER-DETAIL THRU 7560-EXIT           
              MOVE 'AGL DISCOUNT SR'        TO YP-ATTRIBUTE-DESC        
              PERFORM 7570-GET-ACCT-ATTR-DETAIL  THRU 7570-EXIT         
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                 IF YP-ATTRIBUTE-VALUE-CD = 'YES'                       
                    MOVE 'Y'                TO WS-AGL-SENIOR-FLAG       
                 ELSE                                                   
                    MOVE 'N'                TO WS-AGL-SENIOR-FLAG       
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *    GET CURRENT TIME STAMP                                               
           PERFORM 7590-GET-CURRENT-TIMESTAMP    THRU 7590-EXIT.        
                                                                        
      *    GET RATE PLAN STATUS                                                 
           PERFORM 7600-GET-RATEPLAN-STAT        THRU 7600-EXIT.        
                                                                        
      *    GET RATE PLAN INACTIVE STATUS BUSINESS RULE.                         
           IF WS-RATE-CODE-STATUS EQUAL WS-INACT OR                     
              WS-DISPLAY-END-TS LESS THAN  WS-CURRENT-TS                
              MOVE WS-MRM-INACT-RULE-ID     TO                          
                                      S-RS2-BUS-RULE-ID                 
              MOVE WS-FAILED                TO                          
                                      S-RS2-BUS-RULE-RESULT-CD          
              PERFORM 7550-GET-RULE-XREF-ID     THRU 7550-EXIT          
              PERFORM 8020-INSERT-GTT-R2        THRU 8020-EXIT          
           ELSE                                                         
              MOVE SPACES                   TO WS-RATE-CODE-STATUS      
           END-IF.                                                      
                                                                        
      *    GET ACCOUNT DEPENDENCY FOR DELETION.                                 
           PERFORM 7700-CHECK-FOR-DEP            THRU 7700-EXIT.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
      *    GET MASTER ACCOUNT IF NOT DEPENDENT.                                 
              PERFORM 7710-CHECK-FOR-MST         THRU 7710-EXIT         
           END-IF.                                                      
                                                                        
      *    GET ACCOUNT DEPENDENCY FOR DELETION.                                 
           IF WS-CHECK-FOR-DEP = 'Y' OR WS-CHECK-FOR-MST = 'Y'          
                MOVE WS-MRM-ACC-DEP-RULE-ID TO                          
                                      S-RS2-BUS-RULE-ID                 
                MOVE WS-FAILED              TO                          
                                      S-RS2-BUS-RULE-RESULT-CD          
                PERFORM 7550-GET-RULE-XREF-ID     THRU 7550-EXIT        
                PERFORM 8020-INSERT-GTT-R2        THRU 8020-EXIT        
           END-IF.                                                      
      *                                                                         
           PERFORM 2200-MOVE-RATE-RS1            THRU 2200-EXIT.        
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2200-MOVE-RATE-RS1.                                            *        
      ******************************************************************        
       2200-MOVE-RATE-RS1.                                              
                                                                        
           MOVE UT-CODE-UTIL-TYPE           TO S-RS1-CODE-UTIL-TYPE     
           MOVE UT-IC-NO                    TO S-RS1-IC-NO              
           MOVE UT-RATE-PLAN-NO             TO S-RS1-RATE-PLAN-NO       
           MOVE UT-CODE-REVENUE-CLASS       TO S-RS1-CODE-REVENUE-CLASS 
           MOVE RD-SECURED-RATE-FL          TO S-RS1-SECURED-RATE-FL    
           MOVE RD-RATE-DESC                TO S-RS1-RATE-PLAN-DESC     
           MOVE UT-CODE-SIC-NO              TO S-RS1-CODE-SIC-NO        
      *                                                                         
           IF UT-NAICS-CD NOT EQUAL LOW-VALUES                          
              MOVE UT-NAICS-CD                 TO S-RS1-NAICS-CD        
           ELSE                                                         
              MOVE SPACES                      TO S-RS1-NAICS-CD        
           END-IF                                                       
      *                                                                         
           MOVE WS-AGL-SENIOR-FLAG          TO S-RS1-AGL-SENIOR-FLAG    
      *                                                                         
           MOVE DD-TIER-ACCT-TYPE-CD        TO S-RS1-TIER-ACCT-TYPE-CD  
           MOVE DD-TIER-CUST-STAT-CD        TO S-RS1-TIER-CUST-STAT-CD  
           MOVE DD-MKT-TIER-RANKING         TO S-RS1-MKT-TIER-RANKING   
      *                                                                         
           MOVE UT-SEASONAL-USE-CODE        TO S-RS1-SEASONAL-USE-CODE  
           MOVE UT-ZERO-USE-INVEST-DT       TO S-RS1-ZERO-USE-INVEST-DT 
           MOVE UT-READ-CYCLE               TO S-RS1-READ-CYCLE         
           MOVE UT-READ-ROUTE               TO S-RS1-READ-ROUTE         
           MOVE UT-CODE-MTR-READ-FREQ       TO S-RS1-CODE-MTR-READ-FREQ 
           MOVE UT-CODE-ESTIMATE-OK         TO S-RS1-CODE-ESTIMATE-OK   
                                                                        
           MOVE WS-STAT-ADJUSTABLE-CD       TO S-RS1-ADJ-OPTION-FLAG    
                                                                        
           IF UT-ALTERNATE-FUEL-CD = SPACES                             
              MOVE WS-NO                    TO S-RS1-ALTERNATE-FUEL-CD  
           ELSE                                                         
              MOVE UT-ALTERNATE-FUEL-CD     TO S-RS1-ALTERNATE-FUEL-CD  
           END-IF                                                       
                                                                        
           MOVE PR-PERSONAL-CNTCT-CD        TO S-RS1-PERSONAL-CNTCT-CD  
                                                                        
           IF UT-CODE-UTIL-TYPE EQUAL WS-ELECTRIC                       
ACT163*       MOVE Q8-ELEC-WNA-GROUP-NO     TO S-RS1-ELEC-WNA-GROUP-NO          
              MOVE UV-CODE-LONG-DESC-TEXT   TO S-RS1-WNA-GROUP-DESC     
           END-IF.                                                      
                                                                        
           MOVE UT-GAS-BASE-USE             TO S-RS1-GAS-BASE-USE       
           MOVE UT-GAS-BASE-LAST-UPDT       TO S-RS1-GAS-BASE-LAST-UPDT 
                                                                        
           PERFORM 8010-INSERT-GTT-R1          THRU 8010-EXIT.          
           INITIALIZE GTT-RETURN-FIELDS-1.                              
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7025-GET-ACCT-TYPE.                                            *        
      *                                                                *        
      ******************************************************************        
       7025-GET-ACCT-TYPE.                                              
                                                                        
           EXEC SQL                                                     
              SELECT ACCOUNT_TYPE_CODE                                  
                    ,CODE_ACCT_USAGE                                    
                    ,MST_SUB_ACCT_IND                                   
                INTO :AT-ACCOUNT-TYPE-CODE                              
                    ,:AT-CODE-ACCT-USAGE                                
                    ,:AT-MST-SUB-ACCT-IND                               
                FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
               WHERE AT.ACCOUNT_NO    = :AT-ACCOUNT-NO                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ACCOUNT_TYPE_CODE                                          
MFA-TR*             ,CODE_ACCT_USAGE                                            
MFA-TR*             ,MST_SUB_ACCT_IND                                           
MFA-TR*         INTO :AT-ACCOUNT-TYPE-CODE                                      
MFA-TR*             ,:AT-CODE-ACCT-USAGE                                        
MFA-TR*             ,:AT-MST-SUB-ACCT-IND                                       
MFA-TR*         FROM CSS_ACCOUNT AT                                             
MFA-TR*        WHERE AT.ACCOUNT_NO    = :AT-ACCOUNT-NO                          
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7025                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7025'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_ACCOUNT'            TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7025-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7050-GET-RULE-XREF-ID                                          *        
      ******************************************************************        
       7050-GET-RULE-XREF-ID.                                           
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           BUS_RULE_XREF_ID, 121), ' ', '-'), ':', '.') 
           BUS_RULE_XREF_ID                                   
                INTO :S-RS2-BUS-RULE-XREF-ID                            
                FROM CSS_BUS_RULE   [1R] WITH(READUNCOMMITTED)                  
                    ,CSS_BUS_RULE_XREF [1T] WITH(READUNCOMMITTED)               
               WHERE [1R].BUS_RULE_ID = :S-RS2-BUS-RULE-ID                
                 AND [1R].BUS_RULE_ID = [1T].BUS_RULE_ID                    
                                             
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BUS_RULE_XREF_ID                                           
MFA-TR*         INTO :S-RS2-BUS-RULE-XREF-ID                                    
MFA-TR*         FROM CSS_BUS_RULE   1R                                          
MFA-TR*             ,CSS_BUS_RULE_XREF 1T                                       
MFA-TR*        WHERE 1R.BUS_RULE_ID = :S-RS2-BUS-RULE-ID                        
MFA-TR*          AND 1R.BUS_RULE_ID = 1T.BUS_RULE_ID                            
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7050                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
               MOVE SPACES                  TO ABEND-TABLES             
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
               MOVE '7050'                  TO ACTIVE-PARAGRAPH         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_BUS_RULE'          TO TABLE-1                  
               MOVE 'BUS_RULE_ID'           TO TABLE-ELEMENT-1          
               MOVE S-RS2-BUS-RULE-ID       TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7100-SELECT-UTIL-ENVRNMT.                                      *        
      ******************************************************************        
       7100-SELECT-UTIL-ENVRNMT.                                        
                                                                        
           EXEC SQL                                                     
              SELECT UT.PREMISE_NO                                      
                    ,UT.CODE_UTIL_TYPE                                  
                    ,UT.IC_NO                                           
                    ,UT.COMPANY_NO                                      
                    ,UT.RATE_PLAN_NO                                    
                    ,UT.CODE_REVENUE_CLASS                              
                    ,RD.SECURED_RATE_FL                                 
                    ,RD.RATE_DESC                                       
                    ,UT.CODE_SIC_NO                                     
                    ,UT.NAICS_CD                                        
                    ,UT.SEASONAL_USE_CODE                               
                    ,UT.ZERO_USE_INVEST_DT                              
                    ,UT.READ_CYCLE                                      
                    ,UT.READ_ROUTE                                      
                    ,UT.CODE_MTR_READ_FREQ                              
                    ,UT.CODE_ESTIMATE_OK                                
                    ,UT.ALTERNATE_FUEL_CD                               
                    ,UT.GAS_BASE_USE                                    
                    ,UT.GAS_BASE_LAST_UPDT                              
                    ,UT.CODE_CURTAIL_PRTY                               
                    ,UT.RT_PKG_OPT_SEQ_NO                               
                INTO :UT-PREMISE-NO                                     
                    ,:UT-CODE-UTIL-TYPE                                 
                    ,:UT-IC-NO                                          
                    ,:UT-COMPANY-NO                                     
                    ,:UT-RATE-PLAN-NO                                   
                    ,:UT-CODE-REVENUE-CLASS                             
                    ,:RD-SECURED-RATE-FL                                
                    ,:RD-RATE-DESC                                      
                    ,:UT-CODE-SIC-NO                                    
                    ,:UT-NAICS-CD                                       
                    ,:UT-SEASONAL-USE-CODE                              
                    ,:UT-ZERO-USE-INVEST-DT :WS-NULL-IND-01              
                    ,:UT-READ-CYCLE                                     
                    ,:UT-READ-ROUTE                                     
                    ,:UT-CODE-MTR-READ-FREQ                             
                    ,:UT-CODE-ESTIMATE-OK                               
                    ,:UT-ALTERNATE-FUEL-CD                              
                    ,:UT-GAS-BASE-USE                                   
                    ,:UT-GAS-BASE-LAST-UPDT :WS-NULL-IND-02              
                    ,:UT-CODE-CURTAIL-PRTY                              
                    ,:UT-RT-PKG-OPT-SEQ-NO                              
                FROM CSS_UTIL_ENVRNMT   UT WITH(READUNCOMMITTED)                
                    ,CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED)                
               WHERE UT.ACCOUNT_NO         = :UT-ACCOUNT-NO             
                 AND UT.CODE_UTIL_TYPE     = :UT-CODE-UTIL-TYPE         
                 AND UT.IC_NO              = :UT-IC-NO                  
                 AND UT.RATE_PLAN_NO       = RD.RATE_PLAN_NO            
                 AND UT.CODE_UTIL_TYPE     = RD.CODE_UTIL_TYPE          
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT UT.PREMISE_NO                                              
MFA-TR*             ,UT.CODE_UTIL_TYPE                                          
MFA-TR*             ,UT.IC_NO                                                   
MFA-TR*             ,UT.COMPANY_NO                                              
MFA-TR*             ,UT.RATE_PLAN_NO                                            
MFA-TR*             ,UT.CODE_REVENUE_CLASS                                      
MFA-TR*             ,RD.SECURED_RATE_FL                                         
MFA-TR*             ,RD.RATE_DESC                                               
MFA-TR*             ,UT.CODE_SIC_NO                                             
MFA-TR*             ,UT.NAICS_CD                                                
MFA-TR*             ,UT.SEASONAL_USE_CODE                                       
MFA-TR*             ,UT.ZERO_USE_INVEST_DT                                      
MFA-TR*             ,UT.READ_CYCLE                                              
MFA-TR*             ,UT.READ_ROUTE                                              
MFA-TR*             ,UT.CODE_MTR_READ_FREQ                                      
MFA-TR*             ,UT.CODE_ESTIMATE_OK                                        
MFA-TR*             ,UT.ALTERNATE_FUEL_CD                                       
MFA-TR*             ,UT.GAS_BASE_USE                                            
MFA-TR*             ,UT.GAS_BASE_LAST_UPDT                                      
MFA-TR*             ,UT.CODE_CURTAIL_PRTY                                       
MFA-TR*             ,UT.RT_PKG_OPT_SEQ_NO                                       
MFA-TR*         INTO :UT-PREMISE-NO                                             
MFA-TR*             ,:UT-CODE-UTIL-TYPE                                         
MFA-TR*             ,:UT-IC-NO                                                  
MFA-TR*             ,:UT-COMPANY-NO                                             
MFA-TR*             ,:UT-RATE-PLAN-NO                                           
MFA-TR*             ,:UT-CODE-REVENUE-CLASS                                     
MFA-TR*             ,:RD-SECURED-RATE-FL                                        
MFA-TR*             ,:RD-RATE-DESC                                              
MFA-TR*             ,:UT-CODE-SIC-NO                                            
MFA-TR*             ,:UT-NAICS-CD                                               
MFA-TR*             ,:UT-SEASONAL-USE-CODE                                      
MFA-TR*             ,:UT-ZERO-USE-INVEST-DT:WS-NULL-IND-01                      
MFA-TR*             ,:UT-READ-CYCLE                                             
MFA-TR*             ,:UT-READ-ROUTE                                             
MFA-TR*             ,:UT-CODE-MTR-READ-FREQ                                     
MFA-TR*             ,:UT-CODE-ESTIMATE-OK                                       
MFA-TR*             ,:UT-ALTERNATE-FUEL-CD                                      
MFA-TR*             ,:UT-GAS-BASE-USE                                           
MFA-TR*             ,:UT-GAS-BASE-LAST-UPDT:WS-NULL-IND-02                      
MFA-TR*             ,:UT-CODE-CURTAIL-PRTY                                      
MFA-TR*             ,:UT-RT-PKG-OPT-SEQ-NO                                      
MFA-TR*         FROM CSS_UTIL_ENVRNMT   UT                                      
MFA-TR*             ,CSS_RATE_PLAN_DESC RD                                      
MFA-TR*        WHERE UT.ACCOUNT_NO         = :UT-ACCOUNT-NO                     
MFA-TR*          AND UT.CODE_UTIL_TYPE     = :UT-CODE-UTIL-TYPE                 
MFA-TR*          AND UT.IC_NO              = :UT-IC-NO                          
MFA-TR*          AND UT.RATE_PLAN_NO       = RD.RATE_PLAN_NO                    
MFA-TR*          AND UT.CODE_UTIL_TYPE     = RD.CODE_UTIL_TYPE                  
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-NULL-IND-01 = WS-YES-NULL                           
                 MOVE SPACES                TO UT-ZERO-USE-INVEST-DT    
              END-IF                                                    
              IF WS-NULL-IND-02 = WS-YES-NULL                           
                 MOVE SPACES                TO UT-GAS-BASE-LAST-UPDT    
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7000'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_UTIL_ENVRNMT'       TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'UTIL_TYPE'              TO TABLE-ELEMENT-2          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE UT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE UT-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE UT-IC-NO                 TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7110-GET-RTPK-AGREE-DET.                                       *        
      ******************************************************************        
       7110-GET-RTPK-AGREE-DET.                                         
                                                                        
           EXEC SQL                                                     
               SELECT DF.OPTION_CD                                      
                     ,DF.RT_PKG_OPT_SEQ_NO                              
                     ,DF.STATUS_CD                                      
                     ,DF.STAT_ADJUSTABLE_CD                             
                 INTO :DF-OPTION-CD                                     
                     ,:DF-RT-PKG-OPT-SEQ-NO                             
                     ,:DF-STATUS-CD                                     
                     ,:DF-STAT-ADJUSTABLE-CD                            
                 FROM CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)                
                     ,CSS_UTIL_ENVRNMT  UT WITH(READUNCOMMITTED)                
                WHERE UT.ACCOUNT_NO        = :UT-ACCOUNT-NO             
                  AND UT.CODE_UTIL_TYPE    = :UT-CODE-UTIL-TYPE         
                  AND UT.IC_NO             = :UT-IC-NO                  
                  AND DF.ACCOUNT_NO        = UT.ACCOUNT_NO              
                  AND DF.CODE_UTIL_TYPE    = UT.CODE_UTIL_TYPE          
                  AND DF.IC_NO             = UT.IC_NO                   
                  AND DF.RT_PKG_OPT_SEQ_NO = UT.RT_PKG_OPT_SEQ_NO       
                                                                 
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     41146600
MFA-TR*        SELECT DF.OPTION_CD                                      41146600
MFA-TR*              ,DF.RT_PKG_OPT_SEQ_NO                              41146600
MFA-TR*              ,DF.STATUS_CD                                      41146600
MFA-TR*              ,DF.STAT_ADJUSTABLE_CD                                     
MFA-TR*          INTO :DF-OPTION-CD                                     41146600
MFA-TR*              ,:DF-RT-PKG-OPT-SEQ-NO                             41146600
MFA-TR*              ,:DF-STATUS-CD                                     41146600
MFA-TR*              ,:DF-STAT-ADJUSTABLE-CD                                    
MFA-TR*          FROM CSS_ACCT_RTPK_AGR DF                              41146600
MFA-TR*              ,CSS_UTIL_ENVRNMT  UT                              41146600
MFA-TR*         WHERE UT.ACCOUNT_NO        = :UT-ACCOUNT-NO             41146600
MFA-TR*           AND UT.CODE_UTIL_TYPE    = :UT-CODE-UTIL-TYPE         41146600
MFA-TR*           AND UT.IC_NO             = :UT-IC-NO                  41146600
MFA-TR*           AND DF.ACCOUNT_NO        = UT.ACCOUNT_NO              41146600
MFA-TR*           AND DF.CODE_UTIL_TYPE    = UT.CODE_UTIL_TYPE          41146600
MFA-TR*           AND DF.IC_NO             = UT.IC_NO                   41146600
MFA-TR*           AND DF.RT_PKG_OPT_SEQ_NO = UT.RT_PKG_OPT_SEQ_NO       41146600
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7110                                                    
MFA-TR*     END-EXEC.                                                   41146600

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7110'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_UTIL_ENVRNMT'       TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-4          
              MOVE UT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE UT-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE UT-IC-NO                 TO HOSTVAR-ELEMENT-3        
              MOVE AT-COMPANY-NO            TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND          THRU 9000-EXIT        
           END-IF.                                                      
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7120-SEL-FIXED-FACTOR-DET.                                     *        
      ******************************************************************        
       7120-SEL-FIXED-FACTOR-DET.                                       
      *                                                                         
           EXEC SQL                                                     
               SELECT TOP(1) FF.DURATION_REMAIN_NO                             
                 INTO :FF-DURATION-REMAIN-NO :WS-NULL-IND-01             
                 FROM CRM_OPT_ATTR_INCTV HQ WITH(READUNCOMMITTED)               
                     ,CSS_FIXED_FCTR FF WITH(READUNCOMMITTED)                   
                WHERE FF.ACCOUNT_NO         = :FF-ACCOUNT-NO            
                  AND FF.CODE_UTIL_TYPE     = :FF-CODE-UTIL-TYPE        
                  AND FF.IC_NO              = :FF-IC-NO                 
                  AND FF.RT_PKG_OPT_SEQ_NO  = :FF-RT-PKG-OPT-SEQ-NO     
                  AND HQ.FACTOR_ID          = FF.FACTOR_ID              
                  AND HQ.OPTION_CD          = :HQ-OPTION-CD             
                  AND HQ.PRIMRY_OPT_ATTR_FL = 'Y'                       
                  AND HQ.RT_ATTR_INCTV_TYPE = 'FIXED PRICE'             
                  AND HQ.ATTR_INCTV_STRT_DT <= CAST(SYSDATETIMEOFFSET() 
           AS DATE)             
                  AND HQ.ATTR_INCTV_END_DT  >= CAST(SYSDATETIMEOFFSET() 
           AS DATE)             
                  AND HQ.OPT_ATTR_VSTART_TS <= CIS.CURRENT$TIMESTAMP()        
                  AND HQ.OPT_ATTR_VEND_TS   >= CIS.CURRENT$TIMESTAMP()        
                  AND HQ.PROC_STATUS_CD      = 'AC'                     
                ORDER BY FF.EFF_DATE_FROM DESC                          
                                                    
                                                                 
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     41146600
MFA-TR*        SELECT FF.DURATION_REMAIN_NO                             41146600
MFA-TR*          INTO :FF-DURATION-REMAIN-NO:WS-NULL-IND-01             41146600
MFA-TR*          FROM CRM_OPT_ATTR_INCTV HQ                             41146600
MFA-TR*              ,CSS_FIXED_FCTR FF                                 41146600
MFA-TR*         WHERE FF.ACCOUNT_NO         = :FF-ACCOUNT-NO            41146600
MFA-TR*           AND FF.CODE_UTIL_TYPE     = :FF-CODE-UTIL-TYPE        41146600
MFA-TR*           AND FF.IC_NO              = :FF-IC-NO                 41146600
MFA-TR*           AND FF.RT_PKG_OPT_SEQ_NO  = :FF-RT-PKG-OPT-SEQ-NO     41146600
MFA-TR*           AND HQ.FACTOR_ID          = FF.FACTOR_ID              41146600
MFA-TR*           AND HQ.OPTION_CD          = :HQ-OPTION-CD             41146600
MFA-TR*           AND HQ.PRIMRY_OPT_ATTR_FL = 'Y'                       41146600
MFA-TR*           AND HQ.RT_ATTR_INCTV_TYPE = 'FIXED PRICE'             41146600
MFA-TR*           AND HQ.ATTR_INCTV_STRT_DT <= CURRENT DATE                     
MFA-TR*           AND HQ.ATTR_INCTV_END_DT  >= CURRENT DATE                     
MFA-TR*           AND HQ.OPT_ATTR_VSTART_TS <= CURRENT TIMESTAMP        41146600
MFA-TR*           AND HQ.OPT_ATTR_VEND_TS   >= CURRENT TIMESTAMP        41146600
MFA-TR*           AND HQ.PROC_STATUS_CD      = 'AC'                     41146600
MFA-TR*         ORDER BY FF.EFF_DATE_FROM DESC                                  
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7120                                                      
MFA-TR*     END-EXEC.                                                   41146600

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7120'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_FIXED_FCTR'         TO TABLE-1                  
              MOVE 'CRM_OPT_ATTR_INCTV'     TO TABLE-2                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE FF-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE FF-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7200-GET-PRSNL-CNTCT-CD.                                       *        
      ******************************************************************        
       7200-GET-PRSNL-CNTCT-CD.                                         
                                                                        
           EXEC SQL                                                     
              SELECT PR.PERSONAL_CNTCT_CD                               
                INTO :PR-PERSONAL-CNTCT-CD                              
                FROM CSS_PREMISE PR WITH(READUNCOMMITTED)                       
               WHERE PR.PREMISE_NO  = :PR-PREMISE-NO                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT PR.PERSONAL_CNTCT_CD                                       
MFA-TR*         INTO :PR-PERSONAL-CNTCT-CD                                      
MFA-TR*         FROM CSS_PREMISE PR                                             
MFA-TR*        WHERE PR.PREMISE_NO  = :PR-PREMISE-NO                            
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7200                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7200'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_PREMISE'            TO TABLE-1                  
              MOVE 'PREMISE_NO'             TO TABLE-ELEMENT-1          
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-2          
              MOVE PR-PREMISE-NO            TO HOSTVAR-ELEMENT-1        
              MOVE UT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
ACT163******************************************************************        
ACT163*                                                                *        
ACT163* 7300-GET-WNA-GROUP.                                            *        
ACT163******************************************************************        
ACT163*7300-GET-WNA-GROUP.                                                      
ACT163*                                                                         
ACT163*    EXEC SQL                                                             
ACT163*       SELECT Q8.ELEC_WNA_GROUP_NO                                       
ACT163*             ,UV.CODE_LONG_DESC                                          
ACT163*         INTO :Q8-ELEC-WNA-GROUP-NO                                      
ACT163*             ,:UV-CODE-LONG-DESC                                         
ACT163*         FROM CSS_REV_CLS_RATE Q8                                        
ACT163*             ,CSS_CODE_VALUE   UV                                        
ACT163*        WHERE Q8.RATE_PLAN_NO       = :Q8-RATE-PLAN-NO                   
ACT163*          AND Q8.CODE_REVENUE_CLASS = :Q8-CODE-REVENUE-CLASS             
ACT163*          AND Q8.CODE_UTIL_TYPE     = :Q8-CODE-UTIL-TYPE                 
ACT163*          AND Q8.COMPANY_NO         = :Q8-COMPANY-NO                     
ACT163*          AND UV.CODE_VALUE         = Q8.ELEC_WNA_GROUP_NO               
ACT163*          AND UV.COLUMN_NA          = 'ELEC_WNA_GROUP_NO'                
ACT163*          AND UV.TABLE_NA           = 'CSS_ELEC_WNA_PARMS'               
ACT163*          AND UV.PROGRAM_ID         = 'ALL'                              
ACT163*         WITH UR                                                         
ACT163*      QUERYNO 7300                                                       
ACT163*    END-EXEC.                                                            
ACT163*                                                                         
ACT163*    MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.           
ACT163*                                                                         
ACT163*    IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND          
ACT163*       CONTINUE                                                          
ACT163*    ELSE                                                                 
ACT163*       MOVE PROGRAM-NAME             TO ABEND-PROGRAM                    
ACT163*       MOVE '7300'                   TO ACTIVE-PARAGRAPH                 
ACT163*       MOVE 'SELECT'                 TO ABEND-FUNCTION                   
ACT163*       MOVE 'CSS_REV_CLS_RATE'       TO TABLE-1                          
ACT163*       MOVE 'CSS_CODE_VALUE'         TO TABLE-2                          
ACT163*       MOVE 'RATE_PLAN_NO'           TO TABLE-ELEMENT-1                  
ACT163*       MOVE 'CODE_REVENUE_CLASS'     TO TABLE-ELEMENT-2                  
ACT163*       MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-3                  
ACT163*       MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-4                  
ACT163*       MOVE Q8-RATE-PLAN-NO          TO HOSTVAR-ELEMENT-1                
ACT163*       MOVE Q8-CODE-REVENUE-CLASS    TO HOSTVAR-ELEMENT-2                
ACT163*       MOVE Q8-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-3                
ACT163*       MOVE Q8-COMPANY-NO            TO HOSTVAR-ELEMENT-4                
ACT163*       PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT                   
ACT163*    END-IF.                                                              
ACT163*                                                                         
ACT163*7300-EXIT.                                                               
ACT163*    EXIT.                                                                
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7400-GET-PRTY-SVC-CAT-CD.                                      *        
      ******************************************************************        
       7400-GET-PRTY-SVC-CAT-CD.                                        
                                                                        
           EXEC SQL                                                     
              SELECT Z4.PRTY_SVC_CAT_CD                                 
                INTO :Z4-PRTY-SVC-CAT-CD                                
                FROM CSS_PRTY_SVC_CAT Z4 WITH(READUNCOMMITTED)                  
               WHERE Z4.CODE_CURTAIL_PRTY = :Z4-CODE-CURTAIL-PRTY       
                 AND Z4.COMPANY_NO        = :Z4-COMPANY-NO              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT Z4.PRTY_SVC_CAT_CD                                         
MFA-TR*         INTO :Z4-PRTY-SVC-CAT-CD                                        
MFA-TR*         FROM CSS_PRTY_SVC_CAT Z4                                        
MFA-TR*        WHERE Z4.CODE_CURTAIL_PRTY = :Z4-CODE-CURTAIL-PRTY               
MFA-TR*          AND Z4.COMPANY_NO        = :Z4-COMPANY-NO                      
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7400                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7400'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_PRTY-SVC-CAT-CD'    TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-3          
              MOVE UT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE Z4-COMPANY-NO            TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7500-GET-DELINQ-VALUE.                                     *            
      ******************************************************************        
       7500-GET-DELINQ-VALUE.                                           
                                                                        
           EXEC SQL                                                     
              SELECT C8.DELINQ_VALUE                                    
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY C8 WITH(READUNCOMMITTED)                   
               WHERE C8.DELINQ_CD  = :C8-DELINQ-CD                      
                 AND C8.COMPANY_NO = :C8-COMPANY-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT C8.DELINQ_VALUE                                            
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY C8                                         
MFA-TR*        WHERE C8.DELINQ_CD  = :C8-DELINQ-CD                              
MFA-TR*          AND C8.COMPANY_NO = :C8-COMPANY-NO                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7500                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7500'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_DELINQUENCY'        TO TABLE-1                  
              MOVE 'DELINQ_CD'              TO TABLE-ELEMENT-1          
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-2          
              MOVE C8-DELINQ-CD             TO HOSTVAR-ELEMENT-1        
              MOVE C8-COMPANY-NO            TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7550-GET-RULE-XREF-ID                                          *        
      *                                                                *        
      ******************************************************************        
       7550-GET-RULE-XREF-ID.                                           
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           BUS_RULE_XREF_ID, 121), ' ', '-'), ':', '.') 
           BUS_RULE_XREF_ID                                   
                INTO :S-RS2-BUS-RULE-XREF-ID                            
                FROM CSS_BUS_RULE   R WITH(READUNCOMMITTED)                     
                    ,CSS_BUS_RULE_XREF T WITH(READUNCOMMITTED)                  
               WHERE R.BUS_RULE_ID = :S-RS2-BUS-RULE-ID                 
                 AND R.BUS_RULE_ID = T.BUS_RULE_ID                      
                                             
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BUS_RULE_XREF_ID                                           
MFA-TR*         INTO :S-RS2-BUS-RULE-XREF-ID                                    
MFA-TR*         FROM CSS_BUS_RULE   R                                           
MFA-TR*             ,CSS_BUS_RULE_XREF T                                        
MFA-TR*        WHERE R.BUS_RULE_ID = :S-RS2-BUS-RULE-ID                         
MFA-TR*          AND R.BUS_RULE_ID = T.BUS_RULE_ID                              
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7550                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
               MOVE SPACES                  TO ABEND-TABLES             
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
               MOVE '7550'                  TO ACTIVE-PARAGRAPH         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_BUS_RULE'          TO TABLE-1                  
               MOVE 'BUS_RULE_ID'           TO TABLE-ELEMENT-1          
               MOVE S-RS2-BUS-RULE-ID       TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7560-GET-MKT-TIER-DETAIL.                                      *        
      ******************************************************************        
       7560-GET-MKT-TIER-DETAIL.                                        
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) DD.TIER_ACCT_TYPE_CD,
              DD.TIER_CUST_STAT_CD,
              DD.MKT_TIER_RANKING                              
                  INTO :DD-TIER-ACCT-TYPE-CD                            
                      ,:DD-TIER-CUST-STAT-CD                            
                      ,:DD-MKT-TIER-RANKING                             
                  FROM CSS_ACCT_MKT_TIER DD WITH(READUNCOMMITTED)               
                 WHERE DD.ACCOUNT_NO   = :DD-ACCOUNT-NO                 
                   AND DD.EFF_START_DT = (                              
                            SELECT MAX(EFF_START_DT)                    
                              FROM CSS_ACCT_MKT_TIER
                           WITH(READUNCOMMITTED)                    
                             WHERE ACCOUNT_NO = :DD-ACCOUNT-NO          
                                         )                              
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT DD.TIER_ACCT_TYPE_CD                                     
MFA-TR*               ,DD.TIER_CUST_STAT_CD                                     
MFA-TR*               ,DD.MKT_TIER_RANKING                                      
MFA-TR*           INTO :DD-TIER-ACCT-TYPE-CD                                    
MFA-TR*               ,:DD-TIER-CUST-STAT-CD                                    
MFA-TR*               ,:DD-MKT-TIER-RANKING                                     
MFA-TR*           FROM CSS_ACCT_MKT_TIER DD                                     
MFA-TR*          WHERE DD.ACCOUNT_NO   = :DD-ACCOUNT-NO                         
MFA-TR*            AND DD.EFF_START_DT = (                                      
MFA-TR*                     SELECT MAX(EFF_START_DT)                            
MFA-TR*                       FROM CSS_ACCT_MKT_TIER                            
MFA-TR*                      WHERE ACCOUNT_NO = :DD-ACCOUNT-NO                  
MFA-TR*                                  )                                      
MFA-TR*          FETCH FIRST ROW ONLY                                           
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7560                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
      *                                                                         
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
      *                                                                         
               WHEN NOT-FOUND                                           
                    CONTINUE                                            
      *                                                                         
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME             TO ABEND-PROGRAM      
                    MOVE '7560'                   TO ACTIVE-PARAGRAPH   
                    MOVE 'SELECT'                 TO ABEND-FUNCTION     
                    MOVE SPACES                   TO ABEND-TABLES       
                    MOVE 'ACCT_MKT_TIER'          TO TABLE-1            
                    MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1    
                    MOVE SPACES                   TO TABLE-ELEMENT-2    
                    MOVE DD-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1  
                    MOVE SPACES                   TO HOSTVAR-ELEMENT-2  
                    PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT    
      *                                                                         
           END-EVALUATE.                                                
                                                                        
       7560-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *                                                                *        
      * 7570-GET-ACCT-ATTR-DETAIL.                                     *        
      ******************************************************************        
       7570-GET-ACCT-ATTR-DETAIL.                                       
                                                                        
           EXEC SQL                                                     
               SELECT YP.ATTRIBUTE_VALUE_CD                             
                 INTO :YP-ATTRIBUTE-VALUE-CD                            
                 FROM CSS_ACCT_ATTRIBUTE YP WITH(READUNCOMMITTED)               
                WHERE YP.ACCOUNT_NO         = :YP-ACCOUNT-NO            
                  AND YP.ATTRIBUTE_DESC     = :YP-ATTRIBUTE-DESC        
                                                                 
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT YP.ATTRIBUTE_VALUE_CD                                     
MFA-TR*          INTO :YP-ATTRIBUTE-VALUE-CD                                    
MFA-TR*          FROM CSS_ACCT_ATTRIBUTE YP                                     
MFA-TR*         WHERE YP.ACCOUNT_NO         = :YP-ACCOUNT-NO                    
MFA-TR*           AND YP.ATTRIBUTE_DESC     = :YP-ATTRIBUTE-DESC                
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7570                                                   
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE. 
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7570'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_ACCT_ATTRIBUTE'    TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE YP-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT        
            END-IF.                                                     
                                                                        
       7570-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *                                                                *        
      * 7590-GET-CURRENT-TIMESTAMP                                     *        
      ******************************************************************        
       7590-GET-CURRENT-TIMESTAMP.                                      
                                                                        
           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TS                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-TS   = CURRENT TIMESTAMP                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1          
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7590'                 TO ACTIVE-PARAGRAPH           
              MOVE 'SELECT'               TO ABEND-FUNCTION             
              MOVE 'CURRENT TIMESTAMP'    TO TABLE-1                    
              MOVE 'CURRENT_TIMESTAMP'    TO TABLE-ELEMENT-1            
              PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT                
           END-IF.                                                      
                                                                        
       7590-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7600-GET-RATEPLAN-STAT                                         *        
      ******************************************************************        
       7600-GET-RATEPLAN-STAT.                                          
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) RT.CODE_STATUS,
              REPLACE(REPLACE(CONVERT(CHAR(26), RD.DISPLAY_END_TS
           , 121), ' ', '-'), ':', '.') DISPLAY_END_TS                         
                INTO :WS-RATE-CODE-STATUS                               
                    ,:WS-DISPLAY-END-TS                                 
                FROM CSS_RATE_CREATOR    RT WITH(READUNCOMMITTED)               
                    ,CSS_RATE_PLAN_DESC  RD WITH(READUNCOMMITTED)               
               WHERE RT.CODE_UTIL_TYPE    = :UT-CODE-UTIL-TYPE          
                 AND RT.RATE_PLAN_NO      = :UT-RATE-PLAN-NO            
                 AND RT.CODE_UTIL_TYPE    = RD.CODE_UTIL_TYPE           
                 AND RT.RATE_PLAN_NO      = RD.RATE_PLAN_NO             
               ORDER BY VERSION_NO_CNTRL DESC                           
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RT.CODE_STATUS                                             
MFA-TR*             ,RD.DISPLAY_END_TS                                          
MFA-TR*         INTO :WS-RATE-CODE-STATUS                                       
MFA-TR*             ,:WS-DISPLAY-END-TS                                         
MFA-TR*         FROM CSS_RATE_CREATOR    RT                                     
MFA-TR*             ,CSS_RATE_PLAN_DESC  RD                                     
MFA-TR*        WHERE RT.CODE_UTIL_TYPE    = :UT-CODE-UTIL-TYPE                  
MFA-TR*          AND RT.RATE_PLAN_NO      = :UT-RATE-PLAN-NO                    
MFA-TR*          AND RT.CODE_UTIL_TYPE    = RD.CODE_UTIL_TYPE                   
MFA-TR*          AND RT.RATE_PLAN_NO      = RD.RATE_PLAN_NO                     
MFA-TR*        ORDER BY VERSION_NO_CNTRL DESC                                   
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*        WITH UR                                                          
MFA-TR*      QUERYNO 7600                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
      *                                                                         
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
      *                                                                         
               WHEN NOT-FOUND                                           
                    CONTINUE                                            
      *                                                                         
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME             TO ABEND-PROGRAM      
                    MOVE '7600'                   TO ACTIVE-PARAGRAPH   
                    MOVE 'SELECT'                 TO ABEND-FUNCTION     
                    MOVE SPACES                   TO ABEND-TABLES       
                    MOVE 'RATE_CREATOR'           TO TABLE-1            
                    MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-1    
                    MOVE 'RATE_PLAN_NO'           TO TABLE-ELEMENT-2    
                    MOVE SPACES                   TO HOSTVAR-ELEMENT-1  
                    MOVE SPACES                   TO HOSTVAR-ELEMENT-2  
                    PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT    
      *                                                                         
           END-EVALUATE.                                                
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * 7700-CHECK-FOR-DEP.                                                     
      *                                                                         
      *    CHECK IF THE ACCOUNT HAS ANY DEPENDENT ACCOUNTS.                     
      *                                                                         
      *****************************************************************         
       7700-CHECK-FOR-DEP.                                              
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-CHECK-FOR-DEP                                  
                FROM CSS_UTL_BILL_REL WITH(READUNCOMMITTED)                     
               WHERE ACCOUNT_NO_MST      = :UT-ACCOUNT-NO               
                 AND CODE_UTIL_TYPE_MST  = :UT-CODE-UTIL-TYPE           
                 AND IC_NO_MST           = :UT-IC-NO                    
                                                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-CHECK-FOR-DEP                                          
MFA-TR*         FROM CSS_UTL_BILL_REL                                           
MFA-TR*        WHERE ACCOUNT_NO_MST      = :UT-ACCOUNT-NO                       
MFA-TR*          AND CODE_UTIL_TYPE_MST  = :UT-CODE-UTIL-TYPE                   
MFA-TR*          AND IC_NO_MST           = :UT-IC-NO                            
MFA-TR*        FETCH FIRST 1 ROW ONLY                                           
MFA-TR*        WITH UR                                                          
MFA-TR*       QUERYNO 7700                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7700'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_UTL_BILL_REL'       TO TABLE-1                  
              MOVE 'ACCOUNT_NO_MST'         TO TABLE-ELEMENT-1          
              MOVE UR-ACCOUNT-NO-MST        TO HOSTVAR-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE_MST'     TO TABLE-ELEMENT-2          
              MOVE UR-CODE-UTIL-TYPE-MST    TO HOSTVAR-ELEMENT-2        
              MOVE 'IC_NO_MST'              TO TABLE-ELEMENT-3          
              MOVE UR-IC-NO-MST             TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND           THRU 9700-EXIT       
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7710-CHECK-FOR-DEP.                                                     
      *                                                                         
      *    CHECK IF THE ACCOUNT HAS ANY MASTER ACCOUNTS.                        
      *                                                                         
      *****************************************************************         
       7710-CHECK-FOR-MST.                                              
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-CHECK-FOR-MST                                  
                FROM CSS_UTL_BILL_REL WITH(READUNCOMMITTED)                     
               WHERE ACCOUNT_NO_DEP      = :UT-ACCOUNT-NO               
                 AND CODE_UTIL_TYPE_DEP  = :UT-CODE-UTIL-TYPE           
                 AND IC_NO_DEP           = :UT-IC-NO                    
                                                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-CHECK-FOR-MST                                          
MFA-TR*         FROM CSS_UTL_BILL_REL                                           
MFA-TR*        WHERE ACCOUNT_NO_DEP      = :UT-ACCOUNT-NO                       
MFA-TR*          AND CODE_UTIL_TYPE_DEP  = :UT-CODE-UTIL-TYPE                   
MFA-TR*          AND IC_NO_DEP           = :UT-IC-NO                            
MFA-TR*        FETCH FIRST 1 ROW ONLY                                           
MFA-TR*        WITH UR                                                          
MFA-TR*       QUERYNO 7710                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7710'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_UTL_BILL_REL'       TO TABLE-1                  
              MOVE 'ACCOUNT_NO_DEP'         TO TABLE-ELEMENT-1          
              MOVE UR-ACCOUNT-NO-DEP        TO HOSTVAR-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE_DEP'     TO TABLE-ELEMENT-2          
              MOVE UR-CODE-UTIL-TYPE-DEP    TO HOSTVAR-ELEMENT-2        
              MOVE 'IC_NO_DEP'              TO TABLE-ELEMENT-3          
              MOVE UR-IC-NO-DEP             TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       7710-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *                                                               *         
      * 8000A-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000A-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04641_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04641_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1          
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000A'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04641_R1'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       8000A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8000B-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000B-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04641_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04641_R2                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-2.         
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-2          
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000B'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04641_R2'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       8000B-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8010-INSERT-GTT-R1.   OFFER CODE TABLE                         *        
      ******************************************************************        
       8010-INSERT-GTT-R1.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04641_R1                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,CODE_UTIL_TYPE                                       
                  ,IC_NO                                                
                  ,RATE_PLAN_NO                                         
                  ,RATE_PLAN_DESC                                       
                  ,CODE_REVENUE_CLASS                                   
                  ,SECURED_RATE_FL                                      
                  ,CODE_SIC_NO                                          
                  ,NAICS_CD                                             
                  ,SEASONAL_USE_CODE                                    
                  ,ZERO_USE_INVEST_DT                                   
                  ,READ_CYCLE                                           
                  ,READ_ROUTE                                           
                  ,CODE_MTR_READ_FREQ                                   
                  ,CODE_ESTIMATE_OK                                     
                  ,PERSONAL_CNTCT_CD                                    
                  ,ALTERNATE_FUEL_CD                                    
                  ,WNA_GROUP_NO                                         
                  ,WNA_GROUP_DESC                                       
                  ,GAS_BASE_USE                                         
                  ,GAS_BASE_LAST_UPDT                                   
                  ,PRTY_SVC_CAT_CD                                      
                  ,AGL_SENIOR_FLAG                                      
                  ,TIER_ACCT_TYPE_CD                                    
                  ,TIER_CUST_STAT_CD                                    
                  ,MKT_TIER_RANKING                                     
                  ,ADJUSTABLE_OPTION_FLAG                               
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-1                                     
                  ,:S-APPL-RETURN-CODE-1                                
                  ,:S-RS1-CODE-UTIL-TYPE                                
                  ,:S-RS1-IC-NO                                         
                  ,:S-RS1-RATE-PLAN-NO                                  
                  ,:S-RS1-RATE-PLAN-DESC                                
                  ,:S-RS1-CODE-REVENUE-CLASS                            
                  ,:S-RS1-SECURED-RATE-FL                               
                  ,:S-RS1-CODE-SIC-NO                                   
                  ,:S-RS1-NAICS-CD                                      
                  ,:S-RS1-SEASONAL-USE-CODE                             
                  ,:S-RS1-ZERO-USE-INVEST-DT                            
                  ,:S-RS1-READ-CYCLE                                    
                  ,:S-RS1-READ-ROUTE                                    
                  ,:S-RS1-CODE-MTR-READ-FREQ                            
                  ,:S-RS1-CODE-ESTIMATE-OK                              
                  ,:S-RS1-PERSONAL-CNTCT-CD                             
                  ,:S-RS1-ALTERNATE-FUEL-CD                             
                  ,:S-RS1-ELEC-WNA-GROUP-NO                             
                  ,:S-RS1-WNA-GROUP-DESC                                
                  ,:S-RS1-GAS-BASE-USE                                  
                  ,:S-RS1-GAS-BASE-LAST-UPDT                            
                  ,:S-RS1-PRTY-SVC-CAT-CD                               
                  ,:S-RS1-AGL-SENIOR-FLAG                               
                  ,:S-RS1-TIER-ACCT-TYPE-CD                             
                  ,:S-RS1-TIER-CUST-STAT-CD                             
                  ,:S-RS1-MKT-TIER-RANKING                              
                  ,:S-RS1-ADJ-OPTION-FLAG                               
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04641_R1                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,CODE_UTIL_TYPE                                               
MFA-TR*           ,IC_NO                                                        
MFA-TR*           ,RATE_PLAN_NO                                                 
MFA-TR*           ,RATE_PLAN_DESC                                               
MFA-TR*           ,CODE_REVENUE_CLASS                                           
MFA-TR*           ,SECURED_RATE_FL                                              
MFA-TR*           ,CODE_SIC_NO                                                  
MFA-TR*           ,NAICS_CD                                                     
MFA-TR*           ,SEASONAL_USE_CODE                                            
MFA-TR*           ,ZERO_USE_INVEST_DT                                           
MFA-TR*           ,READ_CYCLE                                                   
MFA-TR*           ,READ_ROUTE                                                   
MFA-TR*           ,CODE_MTR_READ_FREQ                                           
MFA-TR*           ,CODE_ESTIMATE_OK                                             
MFA-TR*           ,PERSONAL_CNTCT_CD                                            
MFA-TR*           ,ALTERNATE_FUEL_CD                                            
MFA-TR*           ,WNA_GROUP_NO                                                 
MFA-TR*           ,WNA_GROUP_DESC                                               
MFA-TR*           ,GAS_BASE_USE                                                 
MFA-TR*           ,GAS_BASE_LAST_UPDT                                           
MFA-TR*           ,PRTY_SVC_CAT_CD                                              
MFA-TR*           ,AGL_SENIOR_FLAG                                              
MFA-TR*           ,TIER_ACCT_TYPE_CD                                            
MFA-TR*           ,TIER_CUST_STAT_CD                                            
MFA-TR*           ,MKT_TIER_RANKING                                             
MFA-TR*           ,ADJUSTABLE_OPTION_FLAG                                       
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-1                                             
MFA-TR*           ,:S-APPL-RETURN-CODE-1                                        
MFA-TR*           ,:S-RS1-CODE-UTIL-TYPE                                        
MFA-TR*           ,:S-RS1-IC-NO                                                 
MFA-TR*           ,:S-RS1-RATE-PLAN-NO                                          
MFA-TR*           ,:S-RS1-RATE-PLAN-DESC                                        
MFA-TR*           ,:S-RS1-CODE-REVENUE-CLASS                                    
MFA-TR*           ,:S-RS1-SECURED-RATE-FL                                       
MFA-TR*           ,:S-RS1-CODE-SIC-NO                                           
MFA-TR*           ,:S-RS1-NAICS-CD                                              
MFA-TR*           ,:S-RS1-SEASONAL-USE-CODE                                     
MFA-TR*           ,:S-RS1-ZERO-USE-INVEST-DT                                    
MFA-TR*           ,:S-RS1-READ-CYCLE                                            
MFA-TR*           ,:S-RS1-READ-ROUTE                                            
MFA-TR*           ,:S-RS1-CODE-MTR-READ-FREQ                                    
MFA-TR*           ,:S-RS1-CODE-ESTIMATE-OK                                      
MFA-TR*           ,:S-RS1-PERSONAL-CNTCT-CD                                     
MFA-TR*           ,:S-RS1-ALTERNATE-FUEL-CD                                     
MFA-TR*           ,:S-RS1-ELEC-WNA-GROUP-NO                                     
MFA-TR*           ,:S-RS1-WNA-GROUP-DESC                                        
MFA-TR*           ,:S-RS1-GAS-BASE-USE                                          
MFA-TR*           ,:S-RS1-GAS-BASE-LAST-UPDT                                    
MFA-TR*           ,:S-RS1-PRTY-SVC-CAT-CD                                       
MFA-TR*           ,:S-RS1-AGL-SENIOR-FLAG                                       
MFA-TR*           ,:S-RS1-TIER-ACCT-TYPE-CD                                     
MFA-TR*           ,:S-RS1-TIER-CUST-STAT-CD                                     
MFA-TR*           ,:S-RS1-MKT-TIER-RANKING                                      
MFA-TR*           ,:S-RS1-ADJ-OPTION-FLAG                                       
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R1 = 'Y'             
              ADD +1                     TO  CTR-ROWS-RS1               
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8010'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE 'Y'                   TO  WS-ERR-INSRT-R1            
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04641_R1'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
        8010-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8020-INSERT-GTT-R2.                                            *        
      ******************************************************************        
       8020-INSERT-GTT-R2.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04641_R2                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,BUS_RULE_ID                                          
                  ,BUS_RULE_RESULT_CD                                   
                  ,BUS_RULE_XREF_ID                                     
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-2                                     
                  ,:S-APPL-RETURN-CODE-2                                
                  ,:S-RS2-BUS-RULE-ID                                   
                  ,:S-RS2-BUS-RULE-RESULT-CD                            
                  ,:S-RS2-BUS-RULE-XREF-ID                              
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04641_R2                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,BUS_RULE_ID                                                  
MFA-TR*           ,BUS_RULE_RESULT_CD                                           
MFA-TR*           ,BUS_RULE_XREF_ID                                             
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-2                                             
MFA-TR*           ,:S-APPL-RETURN-CODE-2                                        
MFA-TR*           ,:S-RS2-BUS-RULE-ID                                           
MFA-TR*           ,:S-RS2-BUS-RULE-RESULT-CD                                    
MFA-TR*           ,:S-RS2-BUS-RULE-XREF-ID                                      
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R2 = 'Y'             
              ADD +1                     TO  CTR-ROWS-RS2               
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8020'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE 'Y'                   TO  WS-ERR-INSRT-R2            
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04641_R2'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
        8020-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8800-CHECK-RESULTS.                                           *         
      *****************************************************************         
       8800-CHECK-RESULTS.                                              
                                                                        
           IF CTR-ROWS-RS1 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-1                            
              MOVE   0                       TO S-RETURN-CODE-1         
              MOVE 100                       TO S-APPL-RETURN-CODE-1    
              PERFORM 8010-INSERT-GTT-R1     THRU 8010-EXIT             
           END-IF.                                                      
                                                                        
           IF CTR-ROWS-RS2 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-2                            
              MOVE   0                       TO S-RETURN-CODE-2         
              MOVE 100                       TO S-APPL-RETURN-CODE-2    
              PERFORM 8020-INSERT-GTT-R2     THRU 8020-EXIT             
           END-IF.                                                      
                                                                        
       8800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8900-SEND-DONE.                                                *        
      ******************************************************************        
       8900-SEND-DONE.                                                  
                                                                        
           MOVE PROGRAM-NAME          TO ABEND-PROGRAM                  
           MOVE '8900'                TO ACTIVE-PARAGRAPH               
           MOVE 'OPEN'                TO ABEND-FUNCTION                 
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE 'CSR04641_R1'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C2                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE 'CSR04641_R2'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 9000-SEND-ERROR-RESULT                                         *        
      ******************************************************************        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE       TO ABEND-SQLCODE            
                                               S-RETURN-CODE-1          
                                               S-RETURN-CODE-2.         
                                                                        
           MOVE WS-APPL-RETURN-CODE         TO S-APPL-RETURN-CODE-1     
                                               S-APPL-RETURN-CODE-2.    
                                                                        
                                                                        
           MOVE SQLERRMC                    TO ABEND-SQLERRMC.          
                                                                        
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'               TO ABEND-FUNCTION           
           END-IF.                                                      
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1        THRU 0100A-EXIT.         
           PERFORM 0100B-DECLARE-GTT-R2        THRU 0100B-EXIT.         
                                                                        
           PERFORM 8010-INSERT-GTT-R1          THRU 8010-EXIT.          
           PERFORM 8020-INSERT-GTT-R2          THRU 8020-EXIT.          
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9700-ABEND-PROCESSING.                                         *        
      ******************************************************************        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT.             
           PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT.             
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900-SQL-ERROR-ROUTINE.                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9999-END-PROGRAM.                                              *        
      ******************************************************************        
       9999-END-PROGRAM.                                                
                                                                        
            PERFORM 8800-CHECK-RESULTS THRU 8800-EXIT                   
            PERFORM 8900-SEND-DONE     THRU 8900-EXIT                   
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
