       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       CSR04640.                                      
COB303 DATE-WRITTEN.     JULY 19, 2013.                                 
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE:  CSR04640              --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--                                                            --         
      *--  CSR04640 :                                                --         
      *--                                                            --         
      *--  RETRIEVE RATE & METERING INFORMATION FROM THE BELOW       --         
      *--  TABLES BASED ON THE INPUT ACCOUNT NUMBER FOR ALL UTILITY. --         
      *--                                                            --         
      *--  CLONED FROM CSR02046.                                     --         
      *--                                                            --         
      *--       CSS_UTIL_ENVRNMT                                     --         
      *--       CSS_MTRD_ENVRNMT                                     --         
      *--       CSS_CUST_PLAN     - UNMETERED                        --         
      *--                                                            --         
      *--  # APPL-RETURN-CODE.                                       --         
      *--   +1000 - INPUT IS INVALID                                 --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *--  PARAMETERS                                                --         
      *--                                                            --         
      *--      INPUT                                                 --         
      *--             ACCOUNT_NO          CHAR(13)                   --         
      *--                                                            --         
      *--      OUT                                                   --         
      *--                                                            --         
      *--            NONE                                            --         
      *--                                                            --         
      *--      INOUT                                                 --         
      *--                                                            --         
      *--            NONE                                            --         
      *--                                                            --         
      *--  RESULT SET                                                --         
      *--                                                            --         
      *--  CSR04640_R1 - ICP DETAILS                                 --         
      *--                                                            --         
      *--           RETURN_CODE             INTEGER                  --         
      *--          ,APPL_RETURN_CODE        INTEGER                  --         
      *--          ,CODE_UTIL_TYPE          CHAR(1)                  --         
      *--          ,IC_NO                   SMALLINT                 --         
      *--          ,RATE_PLAN_NO            CHAR(3)                  --         
      *--          ,RATE_DESC               CHAR(50)                 --         
      *--          ,CODE_REVENUE_CLASS      CHAR(3)                  --         
      *--          ,REVENUE_CLASS_DESC      CHAR(26)                 --         
      *--          ,SECURED_RATE_FL         CHAR(1)                  --         
LMSCHG*--          ,IS_UNMTRD_SRVC          CHAR(01)                 --         
      *--          ,READ_CYCLE              CHAR(2)                  --         
      *--          ,READ_ROUTE              SMALLINT                 --         
      *--          ,STATUS_CODE             CHAR(01)                 --         
      *--          ,STATUS                  CHAR(15)                 --         
      *--          ,UNMTRD_VIEW_TYPE        CHAR(02)                 --         
      *--          ,PRTY_SVC_CAT_CD         CHAR(02)                 --         
      *--          ,PRTY_SVC_CAT_DEC        CHAR(25)                 --         
      *--                                                            --         
      *--  CSR04640_R2 - METER DETAILS                               --         
      *--                                                            --         
      *--           RETURN_CODE             INTEGER                  --         
      *--          ,APPL_RETURN_CODE        INTEGER                  --         
      *--          ,CODE_UTIL_TYPE          CHAR(1)                  --         
      *--          ,IC_NO                   SMALLINT                 --         
      *--          ,RATE_PLAN_NO            CHAR(3)                  --         
      *--          ,CODE_METER_STATUS       CHAR(1)                  --         
      *--          ,CD_MTR_STAT_SHRT_DESC   CHAR(15)                 --         
      *--          ,CD_MTR_STAT_SORT_ORD    SMALLINT                 --         
      *--          ,CODE_STATUS_REAS        CHAR(1)                  --         
      *--          ,CD_STAT_REAS_LNG_DESC   CHAR(80)                 --         
      *--          ,DATE_MTR_INSTALL        CHAR(10)                 --         
      *--          ,METER_TYPE              CHAR(13)                 --         
      *--          ,LAST_VAL_RD_VALUE       DECIMAL(15,3)            --         
      *--          ,LAST_VALID_READ_DT      CHAR(10)                 --         
      *--          ,METER_NO                CHAR(9)                  --         
      *--          ,MTR_REF_NO              SMALLINT                 --         
      *--          ,METER_PRESSURE          INTEGER                  --         
      *--          ,MTR_PRESSURE_LNG_DESC   CHAR(80)                 --         
      *--          ,METER_SUPPLYING         CHAR(15)                 --         
      *--          ,MTR_READ_SOURCE_CD      CHAR(1)                  --         
      *--          ,MTR_RD_SRCE_CD_LNG_DESC CHAR(80)                 --         
      *--          ,POINT_ID                CHAR(10)                 --         
      *--          ,OPTIMUM_READ_DATE       CHAR(10)                 --         
      *--          ,CONSTANT                DECIMAL(9,3)             --         
      *--          ,NO_READ_DIALS           SMALLINT                 --         
      *--          ,CODE_METER_LOC          CHAR(02)                 --         
      *--          ,METER_LOC_DESC          CHAR(14)                 --         
      *--                                                            --         
      *--  CSR04640_R3 - UNMETER DETAILS                             --         
      *--                                                            --         
      *--           RETURN_CODE             INTEGER                  --         
      *--          ,APPL_RETURN_CODE        INTEGER                  --         
      *--          ,CODE_UTIL_TYPE          CHAR(1)                  --         
      *--          ,IC_NO                   SMALLINT                 --         
      *--          ,RATE_PLAN_NO            CHAR(3)                  --         
      *--          ,RATE_ITEM_CODE          SMALLINT                 --         
      *--          ,ITEM_SEQ_NO             SMALLINT                 --         
      *--          ,CODE_PLAN_STATUS        CHAR(1)                  --         
      *--          ,CD_PLN_STAT_SHRT_DESC   CHAR(15)                 --         
      *--          ,CD_PLN_STAT_LONG_DESC   CHAR(80)                 --         
      *--          ,CD_PLN_STAT_SORT_ORDR   SMALLINT                 --         
      *--          ,POLE_NO                 CHAR(7)                  --         
      *--          ,NO_UNITS                INTEGER                  --         
      *--          ,CODE_STAT_REASON        CHAR(1)                  --         
      *--          ,CD_STAT_RSON_LNG_DESC   CHAR(80)                 --         
      *--          ,DATE_PLAN_START         CHAR(10)                 --         
      *--          ,REMOVE_DATE             CHAR(10)                 --         
      *--          ,PRICE_PER_SERV          DECIMAL(9,6)             --         
      *--          ,TOTAL_PRICE             DECIMAL(11,2)            --         
      *--          ,EQUIP_SHRT_DESC         CHAR(17)                 --         
      *--          ,EQUIP_LONG_DESC         CHAR(60)                 --         
      *--          ,LAST_BILL_DATE          CHAR(10)                 --         
      *--          ,USAGE_FIXED             DECIMAL(9,0)             --         
      *--          ,MTHLY_AMOUNT_FIXED      DECIMAL(11,2)            --         
      *--          ,UM_EQUIP_TYPE_CD        CHAR(01)                 --         
      *--          ,UM_EQUIP_TYPE_DESC      CHAR(20)                 --         
      *--                                                            --         
      *--  CSR04640_R4 - BUS RULE DETAILS                            --         
      *--                                                            --         
      *--           RETURN_CODE             INTEGER                  --         
      *--          ,APPL_RETURN_CODE        INTEGER                  --         
      *--          ,BUS_RULE_ID             CHAR(10)                 --         
      *--          ,BUS_RULE_RESULT_CD      CHAR(10)                 --         
      *--          ,BUS_RULE_XREF_ID        CHAR(26)                 --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                        MODIFICATION LOG                    --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
P00738*--  07/18/2013    MS93554     RETRIEVE RATE & METER TABLE     --         
      *--                            INFORMATION.                    --         
ACT163*--  05/17/2016    TP7R341     REMOVE UNWANTED CODE.           --         
ACT163*--                APPL5460                                    --         
A05460*--  07/07/2016    HA7A338     REPLACE 5901- WITH 7910- PARA   --         
A05460*--                            TO GET THE READ DATE AT IC LEVEL--         
ACT041*--  02/24/2017    AD7F921     MOD LOG CHANGE TO - REMOVED THE --         
ACT041*--               APPL00005744 METER LOCATION DESC LOGIC FROM  --         
ACT041*--                            MAIN CURSOR AND GETTING THE SAME--         
ACT041*--                            VALUE FROM SEPARATE SQL.        --         
      *----------------------------------------------------------------         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04640'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-START                   PIC X(40) VALUE                    
            'WORKING STORAGE FOR CSR04640 STARTS HERE'.                 
      *                                                                         
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-SUBROUTINE-IDS.                                       
               10  CSRERLOG                 PIC X(8)  VALUE 'CSRERLOG'. 
           05  PROGRAM-NAME                 PIC X(08) VALUE 'CSR04640'. 
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN                   PIC S9(9) COMP VALUE 1.     
           05  CTR-ROWS-RS1                 PIC S9(9) COMP VALUE 0.     
           05  CTR-ROWS-RS2                 PIC S9(9) COMP VALUE 0.     
           05  CTR-ROWS-RS3                 PIC S9(9) COMP VALUE 0.     
           05  CTR-ROWS-RS4                 PIC S9(9) COMP VALUE 0.     
                                                                        
       01  WS-MISC.                                                     
           05  WS-SQLSTATE                  PIC X(05)  VALUE SPACES.    
           05  WS-GTT-NAME                  PIC X(19)  VALUE SPACES.    
           05  WS-APPL-RETURN-CODE          PIC S9(04) COMP VALUE 0.    
           05  RS-RETURN-CODE               PIC S9(04) COMP VALUE 0.    
           05  WS-STATUS-CODE               PIC X(01)  VALUE SPACES.    
           05  WS-CD-SHORT-DESC             PIC X(15)  VALUE SPACES.    
           05  WS-NO-READ-DIALS             PIC S9(04) USAGE COMP.      
           05  WS-OPTIMUM-READ-DATE         PIC X(10)  VALUE SPACES.    
           05  WS-KEY-UTIL-TYPE             PIC X(01)  VALUE SPACES.    
           05  WS-KEY-IC-NO                 PIC S9(4)  USAGE COMP.      
           05  WS-KEY-RATE-PLAN-NO          PIC X(3)   VALUE SPACES.    
           05  WS-KEY-COMPANY-NO            PIC X(2)   VALUE SPACES.    
           05  WS-UM-EQUIP-SHRT-DESC        PIC X(17)  VALUE SPACES.    
           05  WS-UM-EQUIP-LONG-DESC        PIC X(60)  VALUE SPACES.    
           05  WS-UM-EQUIP-TYPE-CD          PIC X(01)  VALUE SPACES.    
           05  WS-UM-EQUIP-TYPE-DESC        PIC X(20)  VALUE SPACES.    
           05  WS-POINT-ID                  PIC X(10)  VALUE SPACES.    
           05  WS-E-METER-SIZE-ID           PIC X(08)  VALUE SPACES.    
           05  WS-G-METER-SIZE-ID           PIC X(08)  VALUE SPACES.    
           05  WS-METER-SIZE-DESC           PIC X(13)  VALUE SPACES.    
           05  WS-DATE-READ                 PIC X(10)  VALUE SPACES.    
           05  WS-NON-UTILITY               PIC X(01)  VALUE 'N'.       
           05  WS-FAILED                    PIC X(01)  VALUE 'F'.       
           05  WS-ACTIVE                    PIC X(01)  VALUE 'A'.       
           05  WS-LAST-VALID-READ-DT        PIC X(10)  VALUE SPACES.    
           05  WS-PREV-MTR-RD-SRCE-CD       PIC X(01)  VALUE SPACES.    
COB305     05 WS-TOT-PRICE        PIC S9(09)V9(2) USAGE COMP-3 VALUE 0.    
COB305     05 WS-PRICE-PER-SERV        PIC S9(03)V9(06) USAGE COMP-3 
COB305       VALUE 0.    
           05  WS-CONSTANT                  PIC S9(06)V9(5)             
                                               USAGE COMP-3 VALUE 0.    
           05  WS-METER-PRESSURE            PIC X(09)  VALUE SPACES.    
                                                                        
       01  WS-CODE-VALUE-TB-MISC.                                       
           05 WS-CD-PLAN-STAT               PIC X(18)  VALUE            
                                                'CODE_PLAN_STATUS'.     
           05 WS-CD-STAT-REASON             PIC X(18)  VALUE            
                                                'CODE_STAT_REASON'.     
           05 WS-MTR-PRESSURE               PIC X(18)  VALUE            
                                                'METER_PRESSURE'.       
           05 WS-CD-MTR-STAT                PIC X(18)  VALUE            
                                                'CODE_METER_STATUS'.    
           05 WS-CD-STAT-REAS               PIC X(18)  VALUE            
                                                'CODE_STATUS_REAS'.     
           05 WS-CD-EQUIP-TYPE              PIC X(18)  VALUE            
                                                'UM_EQUIP_TYPE_CD'.     
           05 WS-UNMTRD-VIEW-TYPE           PIC X(18)  VALUE            
                                                'UI_VIEW_TYPE'.         
           05 WS-CUST-PLAN-TB               PIC X(18)  VALUE            
                                                'CSS_CUST_PLAN'.        
           05 WS-MTRD-ENVRNMT-TB            PIC X(18)  VALUE            
                                                'CSS_MTRD_ENVRNMT'.     
           05 WS-REGISTER-READ-TB           PIC X(18) VALUE             
                                                'CSS_REGISTER_READ'.    
           05 WS-UM-EQUIPMENT-TB            PIC X(18) VALUE             
                                                'CSS_UM_EQUIPMENT'.     
           05 WS-UNMTRD-PLAN-TB             PIC X(18) VALUE             
                                                'CSS_UNMTR_PLAN'.       
           05 WS-LONG-DESC                  PIC X(80)  VALUE SPACES.    
           05 WS-SHORT-DESC                 PIC X(15)  VALUE SPACES.    
           05 WS-ZERO-LOC                   PIC X(02)  VALUE '00'.      
           05 WS-SORT-ORDER                 PIC S9(04) COMP.            
           05 WS-CD-MTR-STAT-SHRT-DESC      PIC X(15)  VALUE SPACES.    
           05 WS-CD-MTR-STAT-SORT-ORDR      PIC S9(04) COMP.            
           05 WS-CD-STAT-REAS-LNG-DESC      PIC X(80)  VALUE SPACES.    
           05 WS-MTR-PRESSUR-LNG-DESC       PIC X(80)  VALUE SPACES.    
           05 WS-MTR-RD-SRC-LNG-DESC        PIC X(80)  VALUE SPACES.    
           05 WS-CD-PLN-STAT-SHRT-DESC      PIC X(15)  VALUE SPACES.    
           05 WS-CD-PLN-STAT-LONG-DESC      PIC X(80)  VALUE SPACES.    
           05 WS-CD-PLN-STAT-SORT-ORDR      PIC S9(04) COMP.            
           05 WS-CD-STAT-RSON-LNG-DESC      PIC X(80)  VALUE SPACES.    
           05 WS-SRCH-CODE-VALUE            PIC X(10)  VALUE SPACES.    
           05 WS-SRCH-COLUMN-NA             PIC X(18)  VALUE SPACES.    
           05 WS-SRCH-TABLE-NA              PIC X(18)  VALUE SPACES.    
                                                                        
           05 WS-UTIL-TYP-RATEPLAN.                                     
              10 WS-UTIL-TYPE-CD            PIC X(01) VALUE SPACES.     
              10 FILLER                     PIC X(01) VALUE ''.        
              10 WS-RATE-PLAN               PIC X(03) VALUE SPACES.     
              10 FILLER                     PIC X(05) VALUE SPACES.     
                                                                        
       01  WS-CODE-VALUE-TABLE.                                         
           05 WS-CODE-VALUE-DATA OCCURS 150 TIMES                       
                                INDEXED BY WS-CD-VAL-INDX.              
              10 WS-CODE-VALUE          PIC X(10).                      
              10 WS-COMPANY-NO          PIC X(02).                      
              10 WS-COLUMN-NA           PIC X(18).                      
              10 WS-TABLE-NA            PIC X(18).                      
              10 WS-CODE-LONG-DESC      PIC X(80).                      
              10 WS-CODE-SHORT-DESC     PIC X(15).                      
              10 WS-CODE-SORT-ORDER     PIC S9(04) COMP.                
                                                                        
       01  WS-NULL-INDICATORS.                                          
           05  WS-NULL-IND-01               PIC S9(04) COMP.            
           05  WS-NULL-IND-02               PIC S9(04) COMP.            
           05  WS-NULL-IND-03               PIC S9(04) COMP.            
           05  WS-NULL-IND-04               PIC S9(04) COMP.            
           05  WS-NULL-IND-05               PIC S9(04) COMP.            
           05  WS-DATE-LAST-NULL            PIC S9(04) COMP.            
           05  WS-NULL-IND-CPD              PIC S9(04) COMP.            
           05  WS-CPD310-NULL-IND           PIC S9(04) COMP.            
                                                                        
       01  WS-SWITCHES.                                                 
           05 WS-NO-MORE-UTIL-ROWS          PIC X(01) VALUE 'N'.        
              88 NO-MORE-UTIL-ROWS                    VALUE 'Y'.        
           05 WS-NO-MORE-MTRD-ROWS          PIC X(01) VALUE 'N'.        
              88 NO-MORE-MTRD-ROWS                    VALUE 'Y'.        
           05 WS-NO-MORE-UNMTR-ROWS         PIC X(01) VALUE 'N'.        
              88 NO-MORE-UNMTR-ROWS                   VALUE 'Y'.        
           05 WS-NO-MORE-CD-VALUE           PIC X(01) VALUE 'N'.        
              88 NO-MORE-CD-VALUE                     VALUE 'Y'.        
           05 WS-FIRST-ROW-FL               PIC X(01) VALUE 'Y'.        
              88 FIRST-ROW                            VALUE 'Y'.        
           05 WS-UTILITY-EXISTS-SW          PIC X(01) VALUE 'N'.        
              88 UTILITY-EXISTS                       VALUE 'Y'.        
              88 UTILITY-NOT-EXISTS                   VALUE 'N'.        
                                                                        
       01  WS-FLAGS.                                                    
           05  WS-YES-NULL                  PIC S9(04) VALUE -1.        
           05  WS-YES                       PIC X(01)  VALUE 'Y'.       
           05  WS-NO                        PIC X(01)  VALUE 'N'.       
           05  WS-ZERO                      PIC S9(04) VALUE 0.         
           05  WS-ELECTRIC                  PIC X(01)  VALUE 'E'.       
           05  WS-GAS                       PIC X(01)  VALUE 'G'.       
           05  WS-UNMETER                   PIC X(01)  VALUE 'U'.       
                                                                        
       01  WS-ERR-FLAGS.                                                
           05  WS-ERR-INSRT-R1              PIC X(01) VALUE 'N'.        
           05  WS-ERR-INSRT-R2              PIC X(01) VALUE 'N'.        
           05  WS-ERR-INSRT-R3              PIC X(01) VALUE 'N'.        
           05  WS-ERR-INSRT-R4              PIC X(01) VALUE 'N'.        
                                                                        
      ****************************************************************          
      *                                                              *          
      *    ERROR PROCESSING VARIABLES                                *          
      ****************************************************************          
      *                                                                         
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
                                                                        
       01 GTT-RETURN-FIELDS.                                            
      *********************************************************                 
      *   GTT TABLE LAYOUT FOR ICP CSS_UTIL_ENVRNMT           *                 
      *********************************************************                 
          05 S-RETURN-CODE                  PIC S9(04) COMP VALUE 0.    
          05 GTT-RETURN-FIELDS-1.                                       
             10 S-RETURN-CODE-1             PIC S9(04) COMP VALUE 0.    
             10 S-APPL-RETURN-CODE-1        PIC S9(04) COMP VALUE 0.    
             10 S-RS1-CODE-UTIL-TYPE        PIC X(01)  VALUE SPACES.    
             10 S-RS1-IC-NO                 PIC S9(04) USAGE COMP.      
             10 S-RS1-RATE-PLAN-NO          PIC X(03)  VALUE SPACES.    
             10 S-RS1-RATE-DESC             PIC X(50)  VALUE SPACES.    
             10 S-RS1-CODE-REVENUE-CLASS    PIC X(03)  VALUE SPACES.    
             10 S-RS1-REVENUE-CLASS-DESC    PIC X(26)  VALUE SPACES.    
             10 S-RS1-SECURED-RATE-FL       PIC X(01)  VALUE SPACES.    
LMSCHG       10 S-RS1-IS-UNMTRD-SRVC        PIC X(01)  VALUE SPACES.    
             10 S-RS1-READ-CYCLE            PIC X(02)  VALUE SPACES.    
             10 S-RS1-READ-ROUTE            PIC S9(04) COMP VALUE 0.    
             10 S-RS1-STATUS-CODE           PIC X(01)  VALUE SPACES.    
             10 S-RS1-STAT-CD-SHORT-DESC    PIC X(15)  VALUE SPACES.    
             10 S-RS1-UNMTRD-VIEW-TYPE      PIC X(02)  VALUE SPACES.    
             10 S-RS1-PRTY-SVC-CAT-CD       PIC X(02)  VALUE SPACES.    
             10 S-RS1-PRTY-SVC-CAT-DEC      PIC X(25)  VALUE SPACES.    
                                                                        
      *********************************************************                 
      *   GTT TABLE LAYOUT FOR METER CSS_MTRD_ENVRNMT         *                 
      *********************************************************                 
          05 GTT-RETURN-FIELDS-2.                                       
             10 S-RETURN-CODE-2             PIC S9(04) COMP VALUE 0.    
             10 S-APPL-RETURN-CODE-2        PIC S9(04) COMP VALUE 0.    
             10 S-RS2-CODE-UTIL-TYPE        PIC X(01)  VALUE SPACES.    
             10 S-RS2-IC-NO                 PIC S9(04) USAGE COMP.      
             10 S-RS2-RATE-PLAN-NO          PIC X(03)  VALUE SPACES.    
             10 S-RS2-CODE-METER-STATUS     PIC x(01)  VALUE SPACES.    
             10 S-RS2-MTR-STAT-SHRT-DESC    PIC X(15)  VALUE SPACES.    
             10 S-RS2-MTR-STAT-SORT-ORDR    PIC S9(04) USAGE COMP.      
             10 S-RS2-CODE-STATUS-REAS      PIC x(01)  VALUE SPACES.    
             10 S-RS2-STAT-REASON-LONG-DESC PIC X(80)  VALUE SPACES.    
             10 S-RS2-DATE-MTR-INSTALL      PIC X(10)  VALUE SPACES.    
             10 S-RS2-METER-TYPE            PIC X(13)  VALUE SPACES.    
COB305       10 S-RS2-LAST-VAL-RD-VALUE        PIC S9(12)V9(3) 
COB305          USAGE COMP-3 VALUE 0.    
             10 S-RS2-LAST-VALID-READ-DT    PIC X(10)  VALUE SPACES.    
             10 S-RS2-METER-NO              PIC X(09)  VALUE SPACES.    
             10 S-RS2-METER-REF-NO          PIC S9(04) USAGE COMP.      
             10 S-RS2-METER-PRESSURE        PIC S9(09) USAGE COMP.      
             10 S-RS2-MTR-PRESSRE-LONG-DESC PIC X(80)  VALUE SPACES.    
             10 S-RS2-METER-SUPPLYING       PIC X(15)  VALUE SPACES.    
             10 S-RS2-MTR-READ-SOURCE-CD    PIC X(01)  VALUE SPACES.    
             10 S-RS2-MTR-RD-SRCE-CD-LNG-DESC                           
                                            PIC X(80)  VALUE SPACES.    
             10 S-RS2-POINT-ID              PIC X(10)  VALUE SPACES.    
             10 S-RS2-OPTIMUM-READ-DATE     PIC X(10)  VALUE SPACES.    
COB305       10 S-RS2-CONSTANT        PIC S9(06)V9(3) USAGE COMP-3 
COB305          VALUE 0.    
             10 S-RS2-NO-READ-DIALS         PIC S9(04) USAGE COMP.      
             10 S-RS2-CODE-METER-LOC        PIC X(02)  VALUE SPACES.    
             10 S-RS2-METER-LOC-DESC        PIC X(14)  VALUE SPACES.    
                                                                        
      *********************************************************                 
      *   GTT TABLE LAYOUT FOR UNMETER CSS_CUST_PLAN          *                 
      *********************************************************                 
          05 GTT-RETURN-FIELDS-3.                                       
             10 S-RETURN-CODE-3             PIC S9(04) COMP VALUE 0.    
             10 S-APPL-RETURN-CODE-3        PIC S9(04) COMP VALUE 0.    
             10 S-RS3-CODE-UTIL-TYPE        PIC X(01)  VALUE SPACES.    
             10 S-RS3-IC-NO                 PIC S9(04) USAGE COMP.      
             10 S-RS3-RATE-PLAN-NO          PIC X(03)  VALUE SPACES.    
             10 S-RS3-RATE-ITEM-CODE        PIC S9(04) USAGE COMP.      
             10 S-RS3-ITEM-SEQ-NO           PIC S9(04) USAGE COMP.      
             10 S-RS3-CODE-PLAN-STATUS      PIC X(01)  VALUE SPACES.    
             10 S-RS3-CD-PLN-STAT-SHRT-DESC PIC X(15)  VALUE SPACES.    
             10 S-RS3-CD-PLN-STAT-LONG-DESC PIC X(80)  VALUE SPACES.    
             10 S-RS3-CD-PLN-STAT-SORT-ORDR PIC S9(04) USAGE COMP.      
             10 S-RS3-POLE-NO               PIC X(07)  VALUE SPACES.    
             10 S-RS3-NO-UNITS              PIC S9(09) COMP VALUE 0.    
             10 S-RS3-CODE-STAT-REASON      PIC X(01)  VALUE SPACES.    
             10 S-RS3-CD-STAT-RSON-LNG-DESC PIC X(80)  VALUE SPACES.    
             10 S-RS3-DATE-PLAN-START       PIC X(10)  VALUE SPACES.    
             10 S-RS3-REMOVE-DATE           PIC X(10)  VALUE SPACES.    
COB305       10 S-RS3-PRICE-PER-SERV        PIC S9(03)V9(06) 
COB305          USAGE COMP-3 VALUE 0.    
COB305       10 S-RS3-TOTAL-PRICE        PIC S9(09)V9(02) USAGE COMP-3 
COB305          VALUE 0.    
             10 S-RS3-EQUIP-SHRT-DESC       PIC X(17)  VALUE SPACES.    
             10 S-RS3-EQUIP-LONG-DESC       PIC X(60)  VALUE SPACES.    
             10 S-RS3-LAST-BILL-DATE        PIC X(10)  VALUE SPACES.    
COB305       10 S-RS3-USAGE-FIXED        PIC S9(09) USAGE COMP-3 
COB305          VALUE 0.    
COB305       10 S-RS3-MTHLY-AMOUNT-FIXED        PIC S9(09)V9(02) 
COB305          USAGE COMP-3 VALUE 0.    
             10 S-RS3-UM-EQUIP-TYPE-CD      PIC X(01)  VALUE SPACES.    
             10 S-RS3-UM-EQUIP-TYPE-DESC    PIC X(20)  VALUE SPACES.    
                                                                        
      *********************************************************                 
      *   GTT TABLE LAYOUT FOR BUS RULE ERROR MESSAGE        *                  
      *********************************************************                 
          05 GTT-RETURN-FIELDS-4.                                       
             10 S-RETURN-CODE-4             PIC S9(04) COMP VALUE 0.    
             10 S-APPL-RETURN-CODE-4        PIC S9(04) COMP VALUE 0.    
             10 S-RS4-BUS-RULE-ID           PIC X(10)  VALUE SPACES.    
             10 S-RS4-BUS-RULE-RESULT-CD    PIC X(10)  VALUE SPACES.    
             10 S-RS4-BUS-RULE-XREF-ID      PIC X(26)  VALUE SPACES.    
                                                                        
      ******************************************************************        
      *               COBOL WORKING STORAGE COPY BOOKS                 *        
      ******************************************************************        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ACCOUNT        AT                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_READ_WINDOW    rw                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRDWNDW                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_UTIL_ENVRNMT   UT                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_PRTY_SVC_CAT_CD Z4                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBSVCCAT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_MTRD_ENVRNMT   MN                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMTRENV                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_CUST_PLAN      CP                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCSTPLN                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_UNMTR_PLAN     UP                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBUMPLAN                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_RATE_PLAN_DESC RD                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRTDESC                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_REVENUE_CLASS  F3                                                
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBREVCLS                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_RATE_CREATOR   RT                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRTCRTR                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_CODE_VALUE     UV                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCDVALU                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_MTR_RD_SOURCE  X7                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRDSRCE                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_GAS_METER      GM                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBGASMTR                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ELEC_METER     EM                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBELMTR                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ELEC_MTR_SIZE  M1                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBEMTRSZ                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_GAS_METER_SIZE M5                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBGASMSZ                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_MTR_CAP        MC                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMTRCAP                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_CNSMPTN_HIST   CX                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCNSMP                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_UM_EQUIPMENT   L9                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBUMEQP                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_PIM_POINT      PP                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBPIMPNT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_METER_LOC      Q4                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMTRLOC                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
      ******************************************************************        
      *    ERROR HANDLING                                                       
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    SUPPORTS DB2 AND SQL ERROR CHECKING                         *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *   CURSOR DECLARATION TO FETCH UTIL ENVRNMT DETAISL BASED ON    *        
      *   THE ACCOUNT NUMBER.                                          *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
               DECLARE UTIL_ENVRNMT_CUR CURSOR FOR                      
                SELECT UT.CODE_UTIL_TYPE                                
                      ,UT.IC_NO                                         
                      ,UT.RATE_PLAN_NO                                  
                      ,UT.COMPANY_NO                                    
                      ,UT.CODE_CURTAIL_PRTY                             
                      ,RD.RATE_DESC                                     
                      ,UT.CODE_REVENUE_CLASS                            
                      ,F3.REVENUE_CLS_DESC                              
                      ,RD.SECURED_RATE_FL                               
LMSCHG                ,RD.UNMTR_PROV_FL                                 
                      ,UT.READ_CYCLE                                    
                      ,UT.READ_ROUTE                                    
                  FROM CSS_UTIL_ENVRNMT   UT WITH(READUNCOMMITTED)              
                      ,CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED)              
                      ,CSS_REVENUE_CLASS  F3 WITH(READUNCOMMITTED)              
                 WHERE UT.ACCOUNT_NO         = :UT-ACCOUNT-NO           
                   AND UT.RATE_PLAN_NO       = RD.RATE_PLAN_NO          
                   AND UT.CODE_UTIL_TYPE     = RD.CODE_UTIL_TYPE        
                   AND UT.CODE_REVENUE_CLASS = F3.CODE_REVENUE_CLASS    
                   AND UT.COMPANY_NO         = F3.COMPANY_NO            
                   AND UT.CODE_UTIL_TYPE     = F3.CODE_UTIL_TYPE        
                   FOR READ ONLY                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE UTIL_ENVRNMT_CUR CURSOR FOR                              
MFA-TR*         SELECT UT.CODE_UTIL_TYPE                                        
MFA-TR*               ,UT.IC_NO                                                 
MFA-TR*               ,UT.RATE_PLAN_NO                                          
MFA-TR*               ,UT.COMPANY_NO                                            
MFA-TR*               ,UT.CODE_CURTAIL_PRTY                                     
MFA-TR*               ,RD.RATE_DESC                                             
MFA-TR*               ,UT.CODE_REVENUE_CLASS                                    
MFA-TR*               ,F3.REVENUE_CLS_DESC                                      
MFA-TR*               ,RD.SECURED_RATE_FL                                       
MFA-TR*               ,RD.UNMTR_PROV_FL                                         
MFA-TR*               ,UT.READ_CYCLE                                            
MFA-TR*               ,UT.READ_ROUTE                                            
MFA-TR*           FROM CSS_UTIL_ENVRNMT   UT                                    
MFA-TR*               ,CSS_RATE_PLAN_DESC RD                                    
MFA-TR*               ,CSS_REVENUE_CLASS  F3                                    
MFA-TR*          WHERE UT.ACCOUNT_NO         = :UT-ACCOUNT-NO                   
MFA-TR*            AND UT.RATE_PLAN_NO       = RD.RATE_PLAN_NO                  
MFA-TR*            AND UT.CODE_UTIL_TYPE     = RD.CODE_UTIL_TYPE                
MFA-TR*            AND UT.CODE_REVENUE_CLASS = F3.CODE_REVENUE_CLASS            
MFA-TR*            AND UT.COMPANY_NO         = F3.COMPANY_NO                    
MFA-TR*            AND UT.CODE_UTIL_TYPE     = F3.CODE_UTIL_TYPE                
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*           QUERYNO 7000                                                  
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CURSOR DECLARATION TO FETCH METER ENVRNMT DETAILS BASED ON   *        
      *   THE ACCOUNT,UTIL AND IC NO.                                  *        
      ******************************************************************        
           EXEC SQL                                                     
               DECLARE MTRD_ENVRNMT_CUR CURSOR FOR                      
               SELECT MN.CODE_METER_STATUS                              
                     ,MN.CODE_STATUS_REAS                               
                     ,MN.DATE_MTR_INSTALL                               
                     ,MN.LAST_VAL_RD_VALUE                              
                     ,MN.LAST_VALID_READ_DT                             
                     ,REPLACE(CONVERT(CHAR(8), MN.LAST_VALID_READ_TM
           , 108), ':', '.') LAST_VALID_READ_TM                             
                     ,MN.METER_NO                                       
                     ,MN.METER_PRESSURE                                 
                     ,MN.METER_SUPPLYING                                
                     ,MN.MTR_READ_SOURCE_CD                             
                     ,MN.GIS_POINT_ID                                   
                     ,MN.MTR_REF_NO                                     
                     ,MN.REG_ID_NO                                      
                     ,MN.CODE_METER_LOC                                 
                 FROM CSS_MTRD_ENVRNMT  MN WITH(READUNCOMMITTED)                
                     ,CSS_CODE_VALUE    UV WITH(READUNCOMMITTED)                
                WHERE MN.ACCOUNT_NO        = :MN-ACCOUNT-NO             
                  AND MN.CODE_UTIL_TYPE    = :MN-CODE-UTIL-TYPE         
                  AND MN.IC_NO             = :MN-IC-NO                  
                  AND MN.CODE_METER_STATUS = UV.CODE_VALUE              
                  AND UV.COLUMN_NA         = 'CODE_METER_STATUS'        
                  AND UV.PROGRAM_ID        = 'ALL'                      
                ORDER BY UV.SORT_ORDER                                  
                 FOR READ ONLY                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE MTRD_ENVRNMT_CUR CURSOR FOR                              
MFA-TR*        SELECT MN.CODE_METER_STATUS                                      
MFA-TR*              ,MN.CODE_STATUS_REAS                                       
MFA-TR*              ,MN.DATE_MTR_INSTALL                                       
MFA-TR*              ,MN.LAST_VAL_RD_VALUE                                      
MFA-TR*              ,MN.LAST_VALID_READ_DT                                     
MFA-TR*              ,MN.LAST_VALID_READ_TM                                     
MFA-TR*              ,MN.METER_NO                                               
MFA-TR*              ,MN.METER_PRESSURE                                         
MFA-TR*              ,MN.METER_SUPPLYING                                        
MFA-TR*              ,MN.MTR_READ_SOURCE_CD                                     
MFA-TR*              ,MN.GIS_POINT_ID                                           
MFA-TR*              ,MN.MTR_REF_NO                                             
MFA-TR*              ,MN.REG_ID_NO                                              
MFA-TR*              ,MN.CODE_METER_LOC                                         
MFA-TR*          FROM CSS_MTRD_ENVRNMT  MN                                      
MFA-TR*              ,CSS_CODE_VALUE    UV                                      
MFA-TR*         WHERE MN.ACCOUNT_NO        = :MN-ACCOUNT-NO                     
MFA-TR*           AND MN.CODE_UTIL_TYPE    = :MN-CODE-UTIL-TYPE                 
MFA-TR*           AND MN.IC_NO             = :MN-IC-NO                          
MFA-TR*           AND MN.CODE_METER_STATUS = UV.CODE_VALUE                      
MFA-TR*           AND UV.COLUMN_NA         = 'CODE_METER_STATUS'                
MFA-TR*           AND UV.PROGRAM_ID        = 'ALL'                              
MFA-TR*         ORDER BY UV.SORT_ORDER                                          
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*          QUERYNO 7030                                                   
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CURSOR DECLARATION TO FETCH ALL UNMETERED DETAILS BASED      *        
      *   ON ACCOUNT NUMBER.                                           *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
               DECLARE UNMETER_CUR CURSOR FOR                           
                SELECT CP.RATE_ITEM_CODE                                
                      ,CP.ITEM_SEQ_NO                                   
                      ,CP.CODE_PLAN_STATUS                              
                      ,CP.POLE_NO                                       
                      ,CP.NO_UNITS                                      
                      ,CP.CODE_STAT_REASON                              
                      ,CP.DATE_PLAN_START                               
                      ,CP.REMOVE_DATE                                   
                      ,CP.LAST_BILL_DATE                                
                      ,CP.USAGE_FIXED                                   
                      ,CP.MTHLY_AMOUNT_FIXED                            
                  FROM CSS_CUST_PLAN     CP WITH(READUNCOMMITTED)               
                  LEFT OUTER JOIN CSS_CODE_VALUE UV
                           WITH(READUNCOMMITTED)                     
                   ON CP.CODE_PLAN_STATUS  = UV.CODE_VALUE              
                  AND UV.COLUMN_NA         = 'CODE_PLAN_STATUS'         
                  AND UV.TABLE_NA          = 'CSS_CUST_PLAN'            
                  AND UV.PROGRAM_ID        = 'ALL'                      
                WHERE CP.ACCOUNT_NO        = :CP-ACCOUNT-NO             
                  AND CP.CODE_UTIL_TYPE    = :CP-CODE-UTIL-TYPE         
                  AND CP.IC_NO             = :CP-IC-NO                  
                ORDER BY UV.SORT_ORDER                                  
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE UNMETER_CUR CURSOR FOR                                   
MFA-TR*         SELECT CP.RATE_ITEM_CODE                                        
MFA-TR*               ,CP.ITEM_SEQ_NO                                           
MFA-TR*               ,CP.CODE_PLAN_STATUS                                      
MFA-TR*               ,CP.POLE_NO                                               
MFA-TR*               ,CP.NO_UNITS                                              
MFA-TR*               ,CP.CODE_STAT_REASON                                      
MFA-TR*               ,CP.DATE_PLAN_START                                       
MFA-TR*               ,CP.REMOVE_DATE                                           
MFA-TR*               ,CP.LAST_BILL_DATE                                        
MFA-TR*               ,CP.USAGE_FIXED                                           
MFA-TR*               ,CP.MTHLY_AMOUNT_FIXED                                    
MFA-TR*           FROM CSS_CUST_PLAN     CP                                     
MFA-TR*           LEFT OUTER JOIN CSS_CODE_VALUE UV                             
MFA-TR*            ON CP.CODE_PLAN_STATUS  = UV.CODE_VALUE                      
MFA-TR*           AND UV.COLUMN_NA         = 'CODE_PLAN_STATUS'                 
MFA-TR*           AND UV.TABLE_NA          = 'CSS_CUST_PLAN'                    
MFA-TR*           AND UV.PROGRAM_ID        = 'ALL'                              
MFA-TR*         WHERE CP.ACCOUNT_NO        = :CP-ACCOUNT-NO                     
MFA-TR*           AND CP.CODE_UTIL_TYPE    = :CP-CODE-UTIL-TYPE                 
MFA-TR*           AND CP.IC_NO             = :CP-IC-NO                          
MFA-TR*         ORDER BY UV.SORT_ORDER                                          
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*           QUERYNO 7060                                                  
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *                                                                         
      *   CURSOR DECLARATION TO FETCH ALL CODE VALUES.                 *        
      ******************************************************************        
           EXEC SQL                                                     
               DECLARE CODE_VALUE_CUR CURSOR FOR                        
                SELECT UV.CODE_VALUE                                    
                      ,UV.COMPANY_NO                                    
                      ,UV.COLUMN_NA                                     
                      ,UV.TABLE_NA                                      
                      ,UV.CODE_LONG_DESC                                
                      ,UV.CODE_SHORT_DESC                               
                      ,UV.SORT_ORDER                                    
                  FROM CSS_CODE_VALUE UV WITH(READUNCOMMITTED)                  
                 WHERE UV.COLUMN_NA IN (:WS-CD-PLAN-STAT                
                                       ,:WS-CD-STAT-REASON              
                                       ,:WS-MTR-PRESSURE                
                                       ,:WS-CD-MTR-STAT                 
                                       ,:WS-CD-STAT-REAS                
                                       ,:WS-CD-EQUIP-TYPE               
                                       ,:WS-UNMTRD-VIEW-TYPE)           
                   AND UV.TABLE_NA  IN (:WS-CUST-PLAN-TB                
                                       ,:WS-MTRD-ENVRNMT-TB             
                                       ,:WS-REGISTER-READ-TB            
                                       ,:WS-UM-EQUIPMENT-TB             
                                       ,:WS-UNMTRD-PLAN-TB)             
                   AND UV.PROGRAM_ID IN ('ALL','CSR04640')              
                ORDER BY UV.COLUMN_NA                                   
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE CODE_VALUE_CUR CURSOR FOR                                
MFA-TR*         SELECT UV.CODE_VALUE                                            
MFA-TR*               ,UV.COMPANY_NO                                            
MFA-TR*               ,UV.COLUMN_NA                                             
MFA-TR*               ,UV.TABLE_NA                                              
MFA-TR*               ,UV.CODE_LONG_DESC                                        
MFA-TR*               ,UV.CODE_SHORT_DESC                                       
MFA-TR*               ,UV.SORT_ORDER                                            
MFA-TR*           FROM CSS_CODE_VALUE UV                                        
MFA-TR*          WHERE UV.COLUMN_NA IN (:WS-CD-PLAN-STAT                        
MFA-TR*                                ,:WS-CD-STAT-REASON                      
MFA-TR*                                ,:WS-MTR-PRESSURE                        
MFA-TR*                                ,:WS-CD-MTR-STAT                         
MFA-TR*                                ,:WS-CD-STAT-REAS                        
MFA-TR*                                ,:WS-CD-EQUIP-TYPE                       
MFA-TR*                                ,:WS-UNMTRD-VIEW-TYPE)                   
MFA-TR*            AND UV.TABLE_NA  IN (:WS-CUST-PLAN-TB                        
MFA-TR*                                ,:WS-MTRD-ENVRNMT-TB                     
MFA-TR*                                ,:WS-REGISTER-READ-TB                    
MFA-TR*                                ,:WS-UM-EQUIPMENT-TB                     
MFA-TR*                                ,:WS-UNMTRD-PLAN-TB)                     
MFA-TR*            AND UV.PROGRAM_ID IN ('ALL','CSR04640')                      
MFA-TR*         ORDER BY UV.COLUMN_NA                                           
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*           QUERYNO 7500                                                  
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
COB305 01 I-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.               
                                                                        
       PROCEDURE DIVISION USING I-ACCOUNT-NO.                           
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 1000-PROCESS-INPUT       THRU 1000-EXIT.             
           PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT.             
           PERFORM 9999-END-PROGRAM         THRU 9999-EXIT.             
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100A-DECLARE-GTT-R1                                           *        
      ******************************************************************        
       0100A-DECLARE-GTT-R1.                                            
                                                                        
           MOVE 'SESSION.CSR04640_R1'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04640_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04640_R1
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,CODE_UTIL_TYPE CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,IC_NO                   SMALLINT                    
                   ,RATE_PLAN_NO CHAR(3)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,RATE_DESC CHAR(50)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,CODE_REVENUE_CLASS CHAR(3)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,REVENUE_CLASS_DESC CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,SECURED_RATE_FL CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
LMSCHG             ,IS_UNMTRD_SRVC CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,READ_CYCLE CHAR(2)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,READ_ROUTE              SMALLINT                    
                   ,STATUS_CODE CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,STATUS CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2            
                   ,UNMTRD_VIEW_TYPE CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PRTY_SVC_CAT_CD CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PRTY_SVC_CAT_DEC CHAR(25)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS    THRU 8000A-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100A'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,LTRIM(RTRIM(CODE_UTIL_TYPE))       AS 
           CODE_UTIL_TYPE    
                      ,IC_NO                       AS IC_NO             
                      ,LTRIM(RTRIM(RATE_PLAN_NO))         AS 
           RATE_PLAN_NO      
                      ,LTRIM(RTRIM(RATE_DESC))            AS RATE_DESC         
                      ,LTRIM(RTRIM(CODE_REVENUE_CLASS))   AS 
           CODE_REVENUE_CLASS
                      ,LTRIM(RTRIM(REVENUE_CLASS_DESC))   AS 
           REVENUE_CLASS_DESC
                      ,LTRIM(RTRIM(SECURED_RATE_FL))      AS 
           SECURED_RATE_FL   
LMSCHG                ,LTRIM(RTRIM(IS_UNMTRD_SRVC))       AS 
           IS_UNMTRD_SRVC    
                      ,LTRIM(RTRIM(READ_CYCLE))           AS READ_CYCLE        
                      ,READ_ROUTE                  AS READ_ROUTE        
                      ,LTRIM(RTRIM(STATUS_CODE))          AS 
           MTR_STATUS_CODE   
                      ,LTRIM(RTRIM(STATUS))               AS 
           STAT_CD_SHORT_DESC
                      ,LTRIM(RTRIM(UNMTRD_VIEW_TYPE))     AS 
           UNMTRD_VIEW_TYPE  
                      ,LTRIM(RTRIM(PRTY_SVC_CAT_CD))      AS 
           PRTY_SVC_CAT_CD   
                      ,LTRIM(RTRIM(PRTY_SVC_CAT_DEC))     AS 
           PRTY_SVC_CAT_DEC  
                  FROM #CSR04640_R1                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,STRIP(CODE_UTIL_TYPE)       AS CODE_UTIL_TYPE            
MFA-TR*               ,IC_NO                       AS IC_NO                     
MFA-TR*               ,STRIP(RATE_PLAN_NO)         AS RATE_PLAN_NO              
MFA-TR*               ,STRIP(RATE_DESC)            AS RATE_DESC                 
MFA-TR*               ,STRIP(CODE_REVENUE_CLASS)   AS CODE_REVENUE_CLASS        
MFA-TR*               ,STRIP(REVENUE_CLASS_DESC)   AS REVENUE_CLASS_DESC        
MFA-TR*               ,STRIP(SECURED_RATE_FL)      AS SECURED_RATE_FL           
MFA-TR*               ,STRIP(IS_UNMTRD_SRVC)       AS IS_UNMTRD_SRVC            
MFA-TR*               ,STRIP(READ_CYCLE)           AS READ_CYCLE                
MFA-TR*               ,READ_ROUTE                  AS READ_ROUTE                
MFA-TR*               ,STRIP(STATUS_CODE)          AS MTR_STATUS_CODE           
MFA-TR*               ,STRIP(STATUS)               AS STAT_CD_SHORT_DESC        
MFA-TR*               ,STRIP(UNMTRD_VIEW_TYPE)     AS UNMTRD_VIEW_TYPE          
MFA-TR*               ,STRIP(PRTY_SVC_CAT_CD)      AS PRTY_SVC_CAT_CD           
MFA-TR*               ,STRIP(PRTY_SVC_CAT_DEC)     AS PRTY_SVC_CAT_DEC          
MFA-TR*           FROM SESSION.CSR04640_R1                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100B-DECLARE-GTT-R2 - CSS_MTRD_ENVRNMT                        *        
      ******************************************************************        
       0100B-DECLARE-GTT-R2.                                            
                                                                        
           MOVE 'SESSION.CSR04640_R2'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04640_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04640_R2
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,CODE_UTIL_TYPE CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,IC_NO                   SMALLINT                    
                   ,RATE_PLAN_NO CHAR(3)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,CODE_METER_STATUS CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,CD_MTR_STAT_SHRT_DESC CHAR(15)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,CD_MTR_STAT_SORT_ORD    SMALLINT                    
                   ,CODE_STATUS_REAS CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,CD_STAT_REAS_LNG_DESC CHAR(80)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,DATE_MTR_INSTALL CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,METER_TYPE CHAR(13)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,LAST_VAL_RD_VALUE       DECIMAL(15,3)               
                   ,LAST_VALID_READ_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,METER_NO CHAR(9)  COLLATE LATIN1_GENERAL_100_BIN2           
                   ,MTR_REF_NO              SMALLINT                    
                   ,METER_PRESSURE          INT                     
                   ,MTR_PRESSURE_LNG_DESC CHAR(80)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,METER_SUPPLYING CHAR(15)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,MTR_READ_SOURCE_CD CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,MTR_RD_SRCE_CD_LNG_DESC CHAR(80)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,POINT_ID CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,OPTIMUM_READ_DATE CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,CONSTANT                DECIMAL(9,3)                
                   ,NO_READ_DIALS           SMALLINT                    
                   ,CODE_METER_LOC CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,METER_LOC_DESC CHAR(14)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000B-DEL-GTT-ROWS    THRU 8000B-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100B'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C2 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,LTRIM(RTRIM(CODE_UTIL_TYPE))       AS 
           CODE_UTIL_TYPE    
                      ,IC_NO                       AS IC_NO             
                      ,LTRIM(RTRIM(RATE_PLAN_NO))         AS 
           RATE_PLAN_NO      
                      ,LTRIM(RTRIM(CODE_METER_STATUS))    AS 
           CODE_METER_STATUS 
                      ,LTRIM(RTRIM(CD_MTR_STAT_SHRT_DESC)) AS                  
                                                   CD_MTR_STAT_SHRT_DESC
                      ,CD_MTR_STAT_SORT_ORD                             
                                                                        
                      ,LTRIM(RTRIM(CODE_STATUS_REAS))     AS 
           CODE_STATUS_REAS  
                      ,LTRIM(RTRIM(CD_STAT_REAS_LNG_DESC)) AS                  
                                                 CD_STAT_REAS_LNG_DESC  
                      ,LTRIM(RTRIM(DATE_MTR_INSTALL))     AS 
           DATE_MTR_INSTALL  
                      ,LTRIM(RTRIM(METER_TYPE))           AS METER_TYPE        
                      ,LAST_VAL_RD_VALUE           AS LAST_READING_VALUE
                      ,LTRIM(RTRIM(LAST_VALID_READ_DT))   AS 
           LAST_READ_DT      
                      ,LTRIM(RTRIM(METER_NO))             AS METER_NO          
                      ,MTR_REF_NO                                       
                      ,METER_PRESSURE              AS METER_PRESSURE    
                      ,LTRIM(RTRIM(MTR_PRESSURE_LNG_DESC)) AS                  
                                                 MTR_PRESSURE_LNG_DESC  
                      ,LTRIM(RTRIM(METER_SUPPLYING))      AS 
           METER_SUPPLYING   
                      ,LTRIM(RTRIM(MTR_READ_SOURCE_CD))   AS 
           MTR_READ_SOURCE_CD
                      ,LTRIM(RTRIM(MTR_RD_SRCE_CD_LNG_DESC)) AS                
                                                 MTR_RD_SRCE_CD_LNG_DESC
                      ,LTRIM(RTRIM(POINT_ID))             AS POINT_ID          
                      ,LTRIM(RTRIM(OPTIMUM_READ_DATE))    AS 
           OPTIMUM_READ_DATE 
                      ,CONSTANT                    AS CONSTANT          
                      ,NO_READ_DIALS               AS NO_READ_DIALS     
                      ,LTRIM(RTRIM(CODE_METER_LOC))       AS 
           CODE_METER_LOC    
                      ,LTRIM(RTRIM(METER_LOC_DESC))       AS 
           METER_LOC_DESC    
                  FROM #CSR04640_R2                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C2 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,STRIP(CODE_UTIL_TYPE)       AS CODE_UTIL_TYPE            
MFA-TR*               ,IC_NO                       AS IC_NO                     
MFA-TR*               ,STRIP(RATE_PLAN_NO)         AS RATE_PLAN_NO              
MFA-TR*               ,STRIP(CODE_METER_STATUS)    AS CODE_METER_STATUS         
MFA-TR*               ,STRIP(CD_MTR_STAT_SHRT_DESC) AS                          
MFA-TR*                                            CD_MTR_STAT_SHRT_DESC        
MFA-TR*               ,CD_MTR_STAT_SORT_ORD                                     
MFA-TR*                                                                         
MFA-TR*               ,STRIP(CODE_STATUS_REAS)     AS CODE_STATUS_REAS          
MFA-TR*               ,STRIP(CD_STAT_REAS_LNG_DESC) AS                          
MFA-TR*                                          CD_STAT_REAS_LNG_DESC          
MFA-TR*               ,STRIP(DATE_MTR_INSTALL)     AS DATE_MTR_INSTALL          
MFA-TR*               ,STRIP(METER_TYPE)           AS METER_TYPE                
MFA-TR*               ,LAST_VAL_RD_VALUE           AS LAST_READING_VALUE        
MFA-TR*               ,STRIP(LAST_VALID_READ_DT)   AS LAST_READ_DT              
MFA-TR*               ,STRIP(METER_NO)             AS METER_NO                  
MFA-TR*               ,MTR_REF_NO                                               
MFA-TR*               ,METER_PRESSURE              AS METER_PRESSURE            
MFA-TR*               ,STRIP(MTR_PRESSURE_LNG_DESC) AS                          
MFA-TR*                                          MTR_PRESSURE_LNG_DESC          
MFA-TR*               ,STRIP(METER_SUPPLYING)      AS METER_SUPPLYING           
MFA-TR*               ,STRIP(MTR_READ_SOURCE_CD)   AS MTR_READ_SOURCE_CD        
MFA-TR*               ,STRIP(MTR_RD_SRCE_CD_LNG_DESC) AS                        
MFA-TR*                                          MTR_RD_SRCE_CD_LNG_DESC        
MFA-TR*               ,STRIP(POINT_ID)             AS POINT_ID                  
MFA-TR*               ,STRIP(OPTIMUM_READ_DATE)    AS OPTIMUM_READ_DATE         
MFA-TR*               ,CONSTANT                    AS CONSTANT                  
MFA-TR*               ,NO_READ_DIALS               AS NO_READ_DIALS             
MFA-TR*               ,STRIP(CODE_METER_LOC)       AS CODE_METER_LOC            
MFA-TR*               ,STRIP(METER_LOC_DESC)       AS METER_LOC_DESC            
MFA-TR*           FROM SESSION.CSR04640_R2                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100B-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100C-DECLARE-GTT-R3                                           *        
      ******************************************************************        
       0100C-DECLARE-GTT-R3.                                            
                                                                        
           MOVE 'SESSION.CSR04640_R3'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04640_R3')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04640_R3
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,CODE_UTIL_TYPE CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,IC_NO                   SMALLINT                    
                   ,RATE_PLAN_NO CHAR(3)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,RATE_ITEM_CODE          SMALLINT                    
                   ,ITEM_SEQ_NO             SMALLINT                    
                   ,CODE_PLAN_STATUS CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,CD_PLN_STAT_SHRT_DESC CHAR(15)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,CD_PLN_STAT_LONG_DESC CHAR(80)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,CD_PLN_STAT_SORT_ORDR   SMALLINT                    
                   ,POLE_NO CHAR(7)  COLLATE LATIN1_GENERAL_100_BIN2            
                   ,NO_UNITS                INT                     
                   ,CODE_STAT_REASON CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,CD_STAT_RSON_LNG_DESC CHAR(80)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,DATE_PLAN_START CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,REMOVE_DATE CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PRICE_PER_SERV          DECIMAL(9,6)                
                   ,TOTAL_PRICE             DECIMAL(11,2)               
                   ,EQUIP_SHRT_DESC CHAR(17)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,EQUIP_LONG_DESC CHAR(60)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,LAST_BILL_DATE CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,USAGE_FIXED             DECIMAL(9,0)                
                   ,MTHLY_AMOUNT_FIXED      DECIMAL(11,2)               
                   ,UM_EQUIP_TYPE_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,UM_EQUIP_TYPE_DESC CHAR(20)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000C-DEL-GTT-ROWS    THRU 8000C-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100C'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C3 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT DISTINCT RETURN_CODE                             
                      ,APPL_RETURN_CODE                                 
                      ,LTRIM(RTRIM(CODE_UTIL_TYPE))       AS 
           CODE_UTIL_TYPE    
                      ,IC_NO                       AS IC_NO             
                      ,LTRIM(RTRIM(RATE_PLAN_NO))         AS 
           RATE_PLAN_NO      
                      ,RATE_ITEM_CODE              AS RATE_ITEM_CODE    
                      ,ITEM_SEQ_NO                                      
                      ,LTRIM(RTRIM(CODE_PLAN_STATUS))     AS 
           CODE_PLAN_STATUS  
                      ,LTRIM(RTRIM(CD_PLN_STAT_SHRT_DESC)) AS                  
                                                 CD_PLN_STAT_SHRT_DESC  
                      ,LTRIM(RTRIM(CD_PLN_STAT_LONG_DESC)) AS                  
                                                 CD_PLN_STAT_LONG_DESC  
                      ,CD_PLN_STAT_SORT_ORDR                            
                      ,LTRIM(RTRIM(POLE_NO))              AS POLE_NO           
                      ,NO_UNITS                    AS NO_UNITS          
                      ,LTRIM(RTRIM(CODE_STAT_REASON))     AS 
           CODE_STAT_REASON  
                      ,LTRIM(RTRIM(CD_STAT_RSON_LNG_DESC)) AS                  
                                                 CD_STAT_RSON_LNG_DESC  
                      ,LTRIM(RTRIM(DATE_PLAN_START))      AS 
           DATE_PLAN_START   
                      ,LTRIM(RTRIM(REMOVE_DATE))          AS REMOVE_DATE       
                      ,PRICE_PER_SERV              AS PRICE_PER_SERV    
                      ,TOTAL_PRICE                 AS TOTAL_PRICE       
                      ,LTRIM(RTRIM(EQUIP_SHRT_DESC))      AS 
           EQUIP_SHRT_DESC   
                      ,LTRIM(RTRIM(EQUIP_LONG_DESC))      AS 
           EQUIP_LONG_DESC   
                      ,LTRIM(RTRIM(LAST_BILL_DATE))       AS 
           BILLED_THRU_DATE  
                      ,USAGE_FIXED                 AS USAGE_FIXED       
                      ,MTHLY_AMOUNT_FIXED          AS MTHLY_AMOUNT_FIXED
                      ,LTRIM(RTRIM(UM_EQUIP_TYPE_CD))     AS 
           UM_EQUIP_TYPE_CD  
                      ,LTRIM(RTRIM(UM_EQUIP_TYPE_DESC))   AS 
           UM_EQUIP_TYPE_DESC
                 FROM #CSR04640_R3                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C3 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT DISTINCT RETURN_CODE                                     
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,STRIP(CODE_UTIL_TYPE)       AS CODE_UTIL_TYPE            
MFA-TR*               ,IC_NO                       AS IC_NO                     
MFA-TR*               ,STRIP(RATE_PLAN_NO)         AS RATE_PLAN_NO              
MFA-TR*               ,RATE_ITEM_CODE              AS RATE_ITEM_CODE            
MFA-TR*               ,ITEM_SEQ_NO                                              
MFA-TR*               ,STRIP(CODE_PLAN_STATUS)     AS CODE_PLAN_STATUS          
MFA-TR*               ,STRIP(CD_PLN_STAT_SHRT_DESC) AS                          
MFA-TR*                                          CD_PLN_STAT_SHRT_DESC          
MFA-TR*               ,STRIP(CD_PLN_STAT_LONG_DESC) AS                          
MFA-TR*                                          CD_PLN_STAT_LONG_DESC          
MFA-TR*               ,CD_PLN_STAT_SORT_ORDR                                    
MFA-TR*               ,STRIP(POLE_NO)              AS POLE_NO                   
MFA-TR*               ,NO_UNITS                    AS NO_UNITS                  
MFA-TR*               ,STRIP(CODE_STAT_REASON)     AS CODE_STAT_REASON          
MFA-TR*               ,STRIP(CD_STAT_RSON_LNG_DESC) AS                          
MFA-TR*                                          CD_STAT_RSON_LNG_DESC          
MFA-TR*               ,STRIP(DATE_PLAN_START)      AS DATE_PLAN_START           
MFA-TR*               ,STRIP(REMOVE_DATE)          AS REMOVE_DATE               
MFA-TR*               ,PRICE_PER_SERV              AS PRICE_PER_SERV            
MFA-TR*               ,TOTAL_PRICE                 AS TOTAL_PRICE               
MFA-TR*               ,STRIP(EQUIP_SHRT_DESC)      AS EQUIP_SHRT_DESC           
MFA-TR*               ,STRIP(EQUIP_LONG_DESC)      AS EQUIP_LONG_DESC           
MFA-TR*               ,STRIP(LAST_BILL_DATE)       AS BILLED_THRU_DATE          
MFA-TR*               ,USAGE_FIXED                 AS USAGE_FIXED               
MFA-TR*               ,MTHLY_AMOUNT_FIXED          AS MTHLY_AMOUNT_FIXED        
MFA-TR*               ,STRIP(UM_EQUIP_TYPE_CD)     AS UM_EQUIP_TYPE_CD          
MFA-TR*               ,STRIP(UM_EQUIP_TYPE_DESC)   AS UM_EQUIP_TYPE_DESC        
MFA-TR*          FROM SESSION.CSR04640_R3                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100C-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100D-DECLARE-GTT-R4                                           *        
      ******************************************************************        
       0100D-DECLARE-GTT-R4.                                            
                                                                        
           MOVE 'SESSION.CSR04640_R4'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04640_R4')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04640_R4
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,BUS_RULE_ID CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BUS_RULE_RESULT_CD CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BUS_RULE_XREF_ID CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000D-DEL-GTT-ROWS    THRU 8000D-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100D'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C4 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,LTRIM(RTRIM(BUS_RULE_ID))          AS BUS_RULE_ID       
                      ,LTRIM(RTRIM(BUS_RULE_RESULT_CD))   AS 
           BUS_RULE_RESULT_CD
                      ,LTRIM(RTRIM(BUS_RULE_XREF_ID))     AS 
           BUS_RULE_XREF_ID  
                  FROM #CSR04640_R4                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C4 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,STRIP(BUS_RULE_ID)          AS BUS_RULE_ID               
MFA-TR*               ,STRIP(BUS_RULE_RESULT_CD)   AS BUS_RULE_RESULT_CD        
MFA-TR*               ,STRIP(BUS_RULE_XREF_ID)     AS BUS_RULE_XREF_ID          
MFA-TR*           FROM SESSION.CSR04640_R4                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100D-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE I-ACCOUNT-NO                TO UT-ACCOUNT-NO            
                                               MN-ACCOUNT-NO            
                                               AT-ACCOUNT-NO            
                                               CP-ACCOUNT-NO            
                                               CX-ACCOUNT-NO.           
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1        THRU 0100A-EXIT.         
           PERFORM 0100B-DECLARE-GTT-R2        THRU 0100B-EXIT.         
           PERFORM 0100C-DECLARE-GTT-R3        THRU 0100C-EXIT.         
           PERFORM 0100D-DECLARE-GTT-R4        THRU 0100D-EXIT.         
                                                                        
           PERFORM 1100-VALIDATE-MASTER-ACCT   THRU 1100-EXIT.          
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * VALIDATE THE ACCOUNT TO SEE IT IS A MASTER                    *         
      *                                                               *         
      *****************************************************************         
       1100-VALIDATE-MASTER-ACCT.                                       
                                                                        
           PERFORM 7025-GET-ACCT-TYPE          THRU 7025-EXIT           
                                                                        
      *    IF THE ACCOUNT IS A NON-UTILITY, AND IS NOT EITHER AN                
      *    ADDITIVE OR SUBTRACTIVE MASTER, SEND A MESSAGE TO USER.              
                                                                        
           IF (AT-ACCOUNT-TYPE-CODE EQUAL WS-NON-UTILITY                
              AND AT-CODE-ACCT-USAGE NOT EQUAL 'A'                      
              AND AT-CODE-ACCT-USAGE NOT EQUAL 'C'                      
              AND AT-CODE-ACCT-USAGE NOT EQUAL 'E')                     
                                                                        
              MOVE 'MRM0000021'             TO S-RS4-BUS-RULE-ID        
              MOVE WS-FAILED                TO S-RS4-BUS-RULE-RESULT-CD 
              IF S-RS4-BUS-RULE-ID GREATER THAN SPACES                  
                 PERFORM 7550-GET-RULE-XREF-ID THRU 7550-EXIT           
              END-IF                                                    
              PERFORM 8040-INSERT-GTT-R4       THRU 8040-EXIT           
              PERFORM 9999-END-PROGRAM         THRU 9999-EXIT           
                                                                        
           ELSE IF AT-MST-SUB-ACCT-IND = 'M'                            
                                                                        
              MOVE 'MRM0000009'             TO S-RS4-BUS-RULE-ID        
              MOVE WS-FAILED                TO S-RS4-BUS-RULE-RESULT-CD 
              IF S-RS4-BUS-RULE-ID GREATER THAN SPACES                  
                 PERFORM 7550-GET-RULE-XREF-ID THRU 7550-EXIT           
              END-IF                                                    
              PERFORM 8040-INSERT-GTT-R4       THRU 8040-EXIT           
              PERFORM 9999-END-PROGRAM         THRU 9999-EXIT           
           END-IF
           END-IF.                                                      
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2000-PROCESS-OUTPUT                                            *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           SET WS-CD-VAL-INDX   TO 1                                    
           PERFORM 7500-OPEN-CODE-VALUE-CUR      THRU 7500-EXIT.        
           PERFORM 7510-FETCH-CODE-VALUE-CUR     THRU 7510-EXIT.        
           PERFORM 2105-LOAD-CODE-VALUES         THRU 2105-EXIT         
                                                 UNTIL NO-MORE-CD-VALUE 
           PERFORM 7520-CLOSE-CODE-VALUE-CUR     THRU 7520-EXIT.        
                                                                        
           PERFORM 7000-OPEN-UTIL-ENVRNMT-CUR    THRU 7000-EXIT.        
           PERFORM 7010-FETCH-UTIL-ENVRNMT-CUR   THRU 7010-EXIT.        
           PERFORM 2100-BUILD-RESULT-SET         THRU 2100-EXIT         
                                                 UNTIL NO-MORE-UTIL-ROWS
           PERFORM 7020-CLOSE-UTIL-ENVRNMT-CUR   THRU 7020-EXIT.        
                                                                        
           IF UTILITY-NOT-EXISTS THEN                                   
              MOVE 'MRM0000008'             TO S-RS4-BUS-RULE-ID        
              MOVE WS-FAILED                TO S-RS4-BUS-RULE-RESULT-CD 
              IF S-RS4-BUS-RULE-ID GREATER THAN SPACES                  
                 PERFORM 7550-GET-RULE-XREF-ID THRU 7550-EXIT           
              END-IF                                                    
              PERFORM 8040-INSERT-GTT-R4       THRU 8040-EXIT           
              PERFORM 9999-END-PROGRAM         THRU 9999-EXIT           
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2105-LOAD-CODE-VALUES.                                         *        
      ******************************************************************        
       2105-LOAD-CODE-VALUES.                                           
                                                                        
           MOVE UV-CODE-VALUE-TEXT(1:UV-CODE-VALUE-LEN)                 
                                   TO WS-CODE-VALUE(WS-CD-VAL-INDX)     
           MOVE UV-COMPANY-NO      TO WS-COMPANY-NO(WS-CD-VAL-INDX)     
           MOVE UV-COLUMN-NA-TEXT(1:UV-COLUMN-NA-LEN)                   
                                   TO WS-COLUMN-NA(WS-CD-VAL-INDX)      
           MOVE UV-TABLE-NA-TEXT(1:UV-TABLE-NA-LEN)                     
                                   TO WS-TABLE-NA(WS-CD-VAL-INDX)       
           MOVE UV-CODE-LONG-DESC-TEXT(1:UV-CODE-LONG-DESC-LEN)         
                                   TO WS-CODE-LONG-DESC(WS-CD-VAL-INDX) 
           MOVE UV-CODE-SHORT-DESC-TEXT(1:UV-CODE-SHORT-DESC-LEN)       
                                   TO WS-CODE-SHORT-DESC(WS-CD-VAL-INDX)
           MOVE UV-SORT-ORDER      TO WS-CODE-SORT-ORDER(WS-CD-VAL-INDX)
                                                                        
           SET WS-CD-VAL-INDX UP BY 1                                   
                                                                        
           INITIALIZE DCLCSS-CODE-VALUE.                                
                                                                        
           PERFORM 7510-FETCH-CODE-VALUE-CUR THRU 7510-EXIT.            
                                                                        
       2105-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2100-BUILD-RESULT-SET.                                         *        
      ******************************************************************        
       2100-BUILD-RESULT-SET.                                           
                                                                        
           SET UTILITY-EXISTS                  TO TRUE.                 
                                                                        
           MOVE UT-CODE-UTIL-TYPE              TO MN-CODE-UTIL-TYPE     
                                                  CP-CODE-UTIL-TYPE     
                                                  CX-CODE-UTIL-TYPE     
                                                  MC-CODE-UTIL-TYPE     
                                                  UP-CODE-UTIL-TYPE     
                                                  WS-KEY-UTIL-TYPE.     
                                                                        
           MOVE UT-IC-NO                       TO MN-IC-NO              
                                                  CP-IC-NO              
                                                  CX-IC-NO              
                                                  WS-KEY-IC-NO.         
                                                                        
           MOVE UT-RATE-PLAN-NO                TO UP-RATE-PLAN-NO       
                                                  WS-KEY-RATE-PLAN-NO.  
                                                                        
           MOVE UT-COMPANY-NO                  TO MC-COMPANY-NO         
                                                  CX-COMPANY-NO         
                                                  EM-COMPANY-NO         
                                                  GM-COMPANY-NO         
                                                  Z4-COMPANY-NO         
                                                  WS-KEY-COMPANY-NO.    
                                                                        
           MOVE SPACES                         TO WS-STATUS-CODE        
                                                  WS-CD-SHORT-DESC.     
                                                                        
      *    Retrieve meter details for electric & gas utility.                   
           IF WS-KEY-UTIL-TYPE EQUAL WS-ELECTRIC OR WS-GAS              
              MOVE WS-YES                      TO WS-FIRST-ROW-FL       
              PERFORM 7030-OPEN-MTRD-ENVRNMT-CUR  THRU 7030-EXIT        
              PERFORM 7040-FETCH-MTRD-ENVRNMT-CUR THRU 7040-EXIT        
              PERFORM 2200-PROCESS-FOR-METER      THRU 2200-EXIT        
                      UNTIL NO-MORE-MTRD-ROWS                           
              PERFORM 7050-CLOSE-MTRD-ENVRNMT-CUR THRU 7050-EXIT        
           END-IF.                                                      
                                                                        
      *    TO GET VIEW TYPE FOR THE RATE PLAN                                   
           PERFORM 2360-GET-VIEW-TYPE             THRU 2360-EXIT.       
                                                                        
      *    Retrieve un-meter details for lighting.                              
           MOVE WS-YES                         TO WS-FIRST-ROW-FL       
           PERFORM 7060-OPEN-UNMETER-CUR          THRU 7060-EXIT        
           PERFORM 7070-FETCH-UNMETER-CUR         THRU 7070-EXIT        
           PERFORM 2300-PROCESS-FOR-UNMETER       THRU 2300-EXIT        
                     UNTIL NO-MORE-UNMTR-ROWS                           
           PERFORM 7080-CLOSE-UNMETER-CUR         THRU 7080-EXIT        
                                                                        
           PERFORM 2400-MOVE-UTIL-RS1          THRU 2400-EXIT           
                                                                        
           INITIALIZE WS-NO-MORE-MTRD-ROWS                              
                      WS-NO-MORE-UNMTR-ROWS.                            
           PERFORM 7010-FETCH-UTIL-ENVRNMT-CUR    THRU 7010-EXIT.       
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2200-PROCESS-FOR-METER.                                        *        
      ******************************************************************        
       2200-PROCESS-FOR-METER.                                          
                                                                        
           MOVE MN-REG-ID-NO                   TO MC-REG-ID-NO          
           MOVE MN-MTR-REF-NO                  TO CX-MTR-REF-NO         
           MOVE MN-METER-NO                    TO MC-METER-NO           
                                                  CX-METER-NO           
                                                  EM-METER-NO           
                                                  GM-METER-NO.          
                                                                        
           IF FIRST-ROW                                                 
              MOVE SPACES                      TO WS-SHORT-DESC         
              MOVE WS-NO                       TO WS-FIRST-ROW-FL       
              MOVE MN-CODE-METER-STATUS        TO WS-SRCH-CODE-VALUE    
                                                  WS-STATUS-CODE        
              MOVE WS-CD-MTR-STAT              TO WS-SRCH-COLUMN-NA     
              MOVE WS-REGISTER-READ-TB         TO WS-SRCH-TABLE-NA      
              PERFORM 5000-SEARCH-CD-VALUE        THRU 5000-EXIT        
              MOVE WS-SHORT-DESC               TO WS-CD-SHORT-DESC      
           END-IF.                                                      
                                                                        
      *    GET NEXT READ DATE USING COPYBOOK CPD00310.                          
A05460     IF UT-READ-CYCLE > SPACES                                    
A05460        PERFORM 7910-SELECT-NXT-RD-DT                             
A05460                       THRU 7910-SELECT-NXT-RD-DT-EXIT            
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                 IF RW-THIRD-PTY-READ-DT GREATER THAN SPACES            
                    MOVE RW-THIRD-PTY-READ-DT  TO WS-OPTIMUM-READ-DATE  
                 ELSE                                                   
                    MOVE RW-OPTIMUM-READ-DATE  TO WS-OPTIMUM-READ-DATE  
                 END-IF                                                 
              END-IF                                                    
A05460     END-IF.                                                      
                                                                        
      *    GET CONSTANT & NO OF READ DIALS.                                     
           PERFORM 7100-GET-METER-CAP-DETAILS     THRU 7100-EXIT        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE MC-CONSTANT                 TO WS-CONSTANT           
              MOVE MC-NO-READ-DIALS            TO WS-NO-READ-DIALS      
           ELSE                                                         
              PERFORM 7110-GET-DET-CONSUMP-HIST   THRU 7110-EXIT        
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                 MOVE CX-CONSTANT              TO WS-CONSTANT           
                 MOVE CX-NO-DIALS              TO WS-NO-READ-DIALS      
              END-IF                                                    
           END-IF.                                                      
                                                                        
      *    GET POINT ID USING GIS POINT ID.                                     
           IF WS-KEY-UTIL-TYPE EQUAL WS-ELECTRIC                        
              AND MN-GIS-POINT-ID GREATER THAN WS-ZERO                  
              PERFORM 7140-GET-GIS-LOC-AND-TAG      THRU 7140-EXIT      
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                 STRING PP-AREA-ID(1:3)  DELIMITED BY SIZE              
                        PP-TAG-NM(1:7)   DELIMITED BY SIZE              
                   INTO WS-POINT-ID                                     
                 END-STRING                                             
              END-IF                                                    
           END-IF.                                                      
                                                                        
      *    GET METER TYPE                                                       
           IF WS-KEY-UTIL-TYPE EQUAL WS-ELECTRIC                        
              PERFORM 7200-GET-ELEC-METER         THRU 7200-EXIT        
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                 PERFORM 7210-GET-ELEC-METER-SIZE THRU 7210-EXIT        
                 IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND               
                    MOVE SPACES                TO WS-METER-SIZE-DESC    
                 END-IF                                                 
              END-IF                                                    
           ELSE                                                         
      *    GET PRIORITY OF SERVICE CATEGORY CODE.                               
              IF UT-CODE-CURTAIL-PRTY > WS-ZERO                         
                 MOVE UT-CODE-CURTAIL-PRTY     TO Z4-CODE-CURTAIL-PRTY  
                 PERFORM 7400-GET-PRTY-SVC-CAT-CD THRU 7400-EXIT        
                 MOVE Z4-PRTY-SVC-CAT-CD       TO S-RS1-PRTY-SVC-CAT-CD 
                 MOVE Z4-PRTY-SVC-CAT-DESC     TO S-RS1-PRTY-SVC-CAT-DEC
              ELSE                                                      
                 MOVE SPACES                   TO S-RS1-PRTY-SVC-CAT-CD 
                                                  S-RS1-PRTY-SVC-CAT-DEC
              END-IF                                                    
                                                                        
              PERFORM 7220-GET-GAS-METER          THRU 7220-EXIT        
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                 PERFORM 7230-GET-GAS-METER-SIZE  THRU 7230-EXIT        
                 IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND               
                    MOVE SPACES                TO WS-METER-SIZE-DESC    
                 END-IF                                                 
           END-IF
           END-IF.                                                      
                                                                        
      *    To get last reading date                                             
ACT163*    IF MN-LAST-VALID-READ-TM EQUAL '24.00.00'                            
ACT163*       MOVE MN-LAST-VALID-READ-DT       TO WS-DATE-READ                  
ACT163*       PERFORM 7300-ADD-ONE-DAY            THRU 7300-EXIT                
ACT163*       MOVE WS-DATE-READ                TO WS-LAST-VALID-READ-DT         
ACT163*    ELSE                                                                 
           MOVE MN-LAST-VALID-READ-DT          TO WS-LAST-VALID-READ-DT.
ACT163*    END-IF.                                                              
                                                                        
      *    TO GET CODE VALUE LONG DESCRIPTION.                                  
           PERFORM 2250-GET-CD-VALUE-LNG-DESC     THRU 2250-EXIT.       
                                                                        
           PERFORM 2410-MOVE-MTRD-RS2             THRU 2410-EXIT.       
           MOVE SPACES                         TO WS-OPTIMUM-READ-DATE  
                                                  WS-METER-SIZE-DESC    
                                                  WS-LAST-VALID-READ-DT 
                                                  WS-DATE-READ          
                                                  WS-POINT-ID.          
           MOVE WS-ZERO                        TO WS-CONSTANT           
                                                  WS-NO-READ-DIALS.     
                                                                        
           PERFORM 7040-FETCH-MTRD-ENVRNMT-CUR    THRU 7040-EXIT.       
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2250-GET-CD-VALUE-LNG-DESC.                                    *        
      ******************************************************************        
       2250-GET-CD-VALUE-LNG-DESC.                                      
                                                                        
      *    CODE_METER_STATUS LONG DESCRIPTION                                   
           MOVE MN-CODE-METER-STATUS        TO WS-SRCH-CODE-VALUE       
           MOVE WS-CD-MTR-STAT              TO WS-SRCH-COLUMN-NA        
           MOVE WS-REGISTER-READ-TB         TO WS-SRCH-TABLE-NA         
           PERFORM 5000-SEARCH-CD-VALUE        THRU 5000-EXIT           
           MOVE WS-SHORT-DESC               TO WS-CD-MTR-STAT-SHRT-DESC 
           MOVE WS-SORT-ORDER               TO WS-CD-MTR-STAT-SORT-ORDR 
                                                                        
      *    CODE_STATUS_REAS LONG DESCRIPTION                                    
           MOVE MN-CODE-STATUS-REAS         TO WS-SRCH-CODE-VALUE       
           MOVE WS-CD-STAT-REAS             TO WS-SRCH-COLUMN-NA        
           MOVE WS-REGISTER-READ-TB         TO WS-SRCH-TABLE-NA         
           PERFORM 5000-SEARCH-CD-VALUE        THRU 5000-EXIT           
           MOVE WS-LONG-DESC                TO WS-CD-STAT-REAS-LNG-DESC 
                                                                        
      *    METER_PRESSURE LONG DESCRIPTION.                                     
           IF WS-KEY-UTIL-TYPE EQUAL WS-GAS                             
              MOVE MN-METER-PRESSURE        TO WS-METER-PRESSURE        
              MOVE WS-METER-PRESSURE(7:3)   TO WS-SRCH-CODE-VALUE       
              MOVE WS-MTR-PRESSURE          TO WS-SRCH-COLUMN-NA        
              MOVE WS-MTRD-ENVRNMT-TB       TO WS-SRCH-TABLE-NA         
              PERFORM 5000-SEARCH-CD-VALUE     THRU 5000-EXIT           
              MOVE WS-LONG-DESC             TO WS-MTR-PRESSUR-LNG-DESC  
           END-IF.                                                      
                                                                        
      *    MTR_READ_SOURCE_CD DESCRIPTION                                       
           IF MN-MTR-READ-SOURCE-CD NOT EQUAL WS-PREV-MTR-RD-SRCE-CD    
              MOVE MN-MTR-READ-SOURCE-CD    TO X7-MTR-READ-SOURCE-CD    
                                               WS-PREV-MTR-RD-SRCE-CD   
              PERFORM 7090-GET-MTR-RD-SURC-DESC THRU 7090-EXIT          
              MOVE X7-MTR-READ-SOURCE-TX    TO WS-MTR-RD-SRC-LNG-DESC   
           END-IF.                                                      
                                                                        
ACT041*    METER_LOC_DESC DESCRIPTION                                           
ACT041     MOVE SPACES                      TO Q4-CODE-METER-LOC        
ACT041                                         Q4-METER-LOC-DESC        
ACT041                                                                  
ACT041     IF MN-CODE-METER-LOC     EQUAL  '0'                          
ACT041        MOVE WS-ZERO-LOC              TO Q4-CODE-METER-LOC        
ACT041     ELSE                                                         
ACT041        MOVE MN-CODE-METER-LOC        TO Q4-CODE-METER-LOC        
ACT041     END-IF.                                                      
ACT041                                                                  
ACT041     PERFORM 7095-GET-MTR-LOC-DESC     THRU 7095-EXIT.            
ACT041                                                                  
                                                                        
       2250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2300-PROCESS-FOR-UNMETER.                                      *        
      ******************************************************************        
       2300-PROCESS-FOR-UNMETER.                                        
                                                                        
           IF FIRST-ROW                                                 
              MOVE SPACES                   TO WS-SHORT-DESC            
              MOVE WS-NO                    TO WS-FIRST-ROW-FL          
              MOVE CP-CODE-PLAN-STATUS      TO WS-SRCH-CODE-VALUE       
                                               WS-STATUS-CODE           
              MOVE WS-CD-PLAN-STAT          TO WS-SRCH-COLUMN-NA        
              MOVE WS-CUST-PLAN-TB          TO WS-SRCH-TABLE-NA         
              PERFORM 5000-SEARCH-CD-VALUE        THRU 5000-EXIT        
              MOVE WS-SHORT-DESC            TO WS-CD-SHORT-DESC         
           END-IF.                                                      
                                                                        
      *    GET PRICE PER SERV FOR SUBDIVISION LIGHTING.                         
           MOVE CP-RATE-ITEM-CODE              TO UP-RATE-ITEM-CODE     
           PERFORM 7120-GET-PRICE-PER-SERV        THRU 7120-EXIT.       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE UP-PRICE-PER-SERV           TO WS-PRICE-PER-SERV     
           ELSE                                                         
              MOVE WS-ZERO                     TO WS-PRICE-PER-SERV     
           END-IF.                                                      
                                                                        
      *    GET TOTAL PRICE OF UNITS.                                            
           COMPUTE WS-TOT-PRICE ROUNDED                                 
                                  = WS-PRICE-PER-SERV * CP-NO-UNITS     
                                                                        
      *    GET RATE ITEM CODE DESCRIPTION.                                      
           PERFORM 7130-GET-RATE-ITEM-DESC        THRU 7130-EXIT        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE L9-UM-EQUIP-SHRT-DESC       TO WS-UM-EQUIP-SHRT-DESC 
              MOVE L9-UM-EQUIP-LONG-DESC       TO WS-UM-EQUIP-LONG-DESC 
              MOVE L9-UM-EQUIP-TYPE-CD         TO WS-UM-EQUIP-TYPE-CD   
           ELSE                                                         
              MOVE SPACES                      TO WS-UM-EQUIP-SHRT-DESC 
                                                  WS-UM-EQUIP-LONG-DESC 
                                                  WS-UM-EQUIP-TYPE-CD   
                                                  WS-UM-EQUIP-TYPE-DESC 
           END-IF.                                                      
                                                                        
      *    TO GET EQUIPMENT TYPE CODE DESCRIPTION.                              
           MOVE SPACES                      TO WS-UM-EQUIP-TYPE-DESC    
           IF WS-UM-EQUIP-TYPE-CD  > SPACES                             
              MOVE WS-UM-EQUIP-TYPE-CD         TO WS-SRCH-CODE-VALUE    
              MOVE 'UM_EQUIP_TYPE_CD'          TO WS-SRCH-COLUMN-NA     
              MOVE 'CSS_UM_EQUIPMENT'          TO WS-SRCH-TABLE-NA      
              PERFORM 5000-SEARCH-CD-VALUE        THRU 5000-EXIT        
              MOVE WS-LONG-DESC                TO WS-UM-EQUIP-TYPE-DESC 
           END-IF.                                                      
                                                                        
      *    TO GET CODE VALUE LONG DESCRIPTION FOR UNMETER.                      
           PERFORM 2350-GET-CD-VALUE-LNG-DESC     THRU 2350-EXIT.       
                                                                        
           PERFORM 2420-MOVE-UNMTR-RS3            THRU 2420-EXIT.       
                                                                        
           MOVE WS-ZERO                        TO WS-TOT-PRICE.         
           MOVE SPACES                         TO WS-UM-EQUIP-SHRT-DESC 
                                                  WS-UM-EQUIP-LONG-DESC 
                                                  WS-UM-EQUIP-TYPE-CD.  
                                                                        
           PERFORM 7070-FETCH-UNMETER-CUR         THRU 7070-EXIT.       
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2350-GET-CD-VALUE-LNG-DESC.                                    *        
      ******************************************************************        
       2350-GET-CD-VALUE-LNG-DESC.                                      
                                                                        
      *    CODE_PLAN_STATUS LONG DESCRIPTION                                    
           MOVE CP-CODE-PLAN-STATUS         TO WS-SRCH-CODE-VALUE       
           MOVE WS-CD-PLAN-STAT             TO WS-SRCH-COLUMN-NA        
           MOVE WS-CUST-PLAN-TB             TO WS-SRCH-TABLE-NA         
           PERFORM 5000-SEARCH-CD-VALUE        THRU 5000-EXIT           
           MOVE WS-SHORT-DESC               TO WS-CD-PLN-STAT-SHRT-DESC 
           MOVE WS-LONG-DESC                TO WS-CD-PLN-STAT-LONG-DESC 
           MOVE WS-SORT-ORDER               TO WS-CD-PLN-STAT-SORT-ORDR 
                                                                        
      *    CODE_STAT_REASON LONG DESCRIPTION                                    
           MOVE CP-CODE-STAT-REASON         TO WS-SRCH-CODE-VALUE       
           MOVE WS-CD-STAT-REASON           TO WS-SRCH-COLUMN-NA        
           MOVE WS-CUST-PLAN-TB             TO WS-SRCH-TABLE-NA         
           PERFORM 5000-SEARCH-CD-VALUE        THRU 5000-EXIT           
           MOVE WS-LONG-DESC                TO WS-CD-STAT-RSON-LNG-DESC.
                                                                        
       2350-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2360-GET-VIEW-TYPE.                                            *        
      ******************************************************************        
       2360-GET-VIEW-TYPE.                                              
                                                                        
      *    CODE_VALUE TABLE VIEW_TYPE LONG DESCRIPTION                          
           MOVE UT-RATE-PLAN-NO             TO WS-RATE-PLAN             
           MOVE UT-CODE-UTIL-TYPE           TO WS-UTIL-TYPE-CD          
           MOVE WS-UTIL-TYP-RATEPLAN        TO WS-SRCH-CODE-VALUE       
           MOVE WS-UNMTRD-VIEW-TYPE         TO WS-SRCH-COLUMN-NA        
           MOVE WS-UNMTRD-PLAN-TB           TO WS-SRCH-TABLE-NA         
           PERFORM 5000-SEARCH-CD-VALUE        THRU 5000-EXIT           
      *                                                                         
           IF WS-SHORT-DESC NOT EQUAL SPACES                            
              MOVE WS-SHORT-DESC            TO S-RS1-UNMTRD-VIEW-TYPE   
           ELSE                                                         
              MOVE '00'                     TO S-RS1-UNMTRD-VIEW-TYPE   
           END-IF.                                                      
      *                                                                         
           MOVE SPACES                      TO WS-RATE-PLAN             
                                               WS-UTIL-TYPE-CD.         
      *                                                                         
       2360-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2400-MOVE-UTIL-RS1.                                            *        
      ******************************************************************        
       2400-MOVE-UTIL-RS1.                                              
                                                                        
           MOVE UT-CODE-UTIL-TYPE           TO S-RS1-CODE-UTIL-TYPE     
           MOVE UT-IC-NO                    TO S-RS1-IC-NO              
           MOVE UT-RATE-PLAN-NO             TO S-RS1-RATE-PLAN-NO       
           MOVE RD-RATE-DESC                TO S-RS1-RATE-DESC          
           MOVE UT-CODE-REVENUE-CLASS       TO S-RS1-CODE-REVENUE-CLASS 
           MOVE F3-REVENUE-CLS-DESC         TO S-RS1-REVENUE-CLASS-DESC 
           MOVE RD-SECURED-RATE-FL          TO S-RS1-SECURED-RATE-FL    
LMSCHG     MOVE RD-UNMTR-PROV-FL            TO S-RS1-IS-UNMTRD-SRVC     
           MOVE UT-READ-CYCLE               TO S-RS1-READ-CYCLE         
           MOVE UT-READ-ROUTE               TO S-RS1-READ-ROUTE         
           MOVE WS-STATUS-CODE              TO S-RS1-STATUS-CODE        
           MOVE WS-CD-SHORT-DESC            TO S-RS1-STAT-CD-SHORT-DESC 
                                                                        
           PERFORM 8010-INSERT-GTT-R1          THRU 8010-EXIT.          
           INITIALIZE GTT-RETURN-FIELDS-1.                              
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2410-MOVE-MTRD-RS2.                                            *        
      ******************************************************************        
       2410-MOVE-MTRD-RS2.                                              
                                                                        
           MOVE WS-KEY-UTIL-TYPE            TO S-RS2-CODE-UTIL-TYPE     
           MOVE WS-KEY-IC-NO                TO S-RS2-IC-NO              
           MOVE WS-KEY-RATE-PLAN-NO         TO S-RS2-RATE-PLAN-NO       
           MOVE MN-CODE-METER-STATUS        TO S-RS2-CODE-METER-STATUS  
           MOVE WS-CD-MTR-STAT-SHRT-DESC    TO S-RS2-MTR-STAT-SHRT-DESC 
           MOVE WS-CD-MTR-STAT-SORT-ORDR    TO S-RS2-MTR-STAT-SORT-ORDR 
           MOVE MN-CODE-STATUS-REAS         TO S-RS2-CODE-STATUS-REAS   
           MOVE WS-CD-STAT-REAS-LNG-DESC    TO                          
                                  S-RS2-STAT-REASON-LONG-DESC           
           MOVE MN-DATE-MTR-INSTALL         TO S-RS2-DATE-MTR-INSTALL   
           MOVE WS-METER-SIZE-DESC          TO S-RS2-METER-TYPE         
           MOVE MN-LAST-VAL-RD-VALUE        TO S-RS2-LAST-VAL-RD-VALUE  
           MOVE WS-LAST-VALID-READ-DT       TO S-RS2-LAST-VALID-READ-DT 
           MOVE MN-METER-NO                 TO S-RS2-METER-NO           
           MOVE MN-MTR-REF-NO               TO S-RS2-METER-REF-NO       
           MOVE MN-METER-SUPPLYING          TO S-RS2-METER-SUPPLYING    
           MOVE MN-MTR-READ-SOURCE-CD       TO S-RS2-MTR-READ-SOURCE-CD 
           MOVE WS-MTR-RD-SRC-LNG-DESC      TO                          
                                  S-RS2-MTR-RD-SRCE-CD-LNG-DESC         
           MOVE WS-OPTIMUM-READ-DATE        TO S-RS2-OPTIMUM-READ-DATE  
           MOVE WS-CONSTANT                 TO S-RS2-CONSTANT           
           MOVE WS-NO-READ-DIALS            TO S-RS2-NO-READ-DIALS      
           MOVE MN-CODE-METER-LOC           TO S-RS2-CODE-METER-LOC     
           MOVE Q4-METER-LOC-DESC           TO S-RS2-METER-LOC-DESC     
                                                                        
           IF WS-KEY-UTIL-TYPE EQUAL WS-GAS                             
              MOVE MN-METER-PRESSURE        TO S-RS2-METER-PRESSURE     
              MOVE WS-MTR-PRESSUR-LNG-DESC  TO                          
                                  S-RS2-MTR-PRESSRE-LONG-DESC           
           END-IF.                                                      
                                                                        
           IF WS-KEY-UTIL-TYPE EQUAL WS-ELECTRIC                        
              MOVE WS-POINT-ID              TO S-RS2-POINT-ID           
           END-IF.                                                      
                                                                        
           PERFORM 8020-INSERT-GTT-R2          THRU 8020-EXIT.          
           INITIALIZE GTT-RETURN-FIELDS-2.                              
                                                                        
       2410-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2420-MOVE-UNMTR-RS3.                                           *        
      ******************************************************************        
       2420-MOVE-UNMTR-RS3.                                             
                                                                        
           MOVE WS-KEY-UTIL-TYPE            TO S-RS3-CODE-UTIL-TYPE     
           MOVE WS-KEY-IC-NO                TO S-RS3-IC-NO              
           MOVE WS-KEY-RATE-PLAN-NO         TO S-RS3-RATE-PLAN-NO       
           MOVE CP-RATE-ITEM-CODE           TO S-RS3-RATE-ITEM-CODE     
           MOVE CP-ITEM-SEQ-NO              TO S-RS3-ITEM-SEQ-NO        
           MOVE CP-CODE-PLAN-STATUS         TO S-RS3-CODE-PLAN-STATUS   
           MOVE WS-CD-PLN-STAT-SHRT-DESC    TO                          
                                   S-RS3-CD-PLN-STAT-SHRT-DESC          
           MOVE WS-CD-PLN-STAT-LONG-DESC    TO                          
                                   S-RS3-CD-PLN-STAT-LONG-DESC          
           MOVE WS-CD-PLN-STAT-SORT-ORDR    TO                          
                                   S-RS3-CD-PLN-STAT-SORT-ORDR          
           MOVE CP-POLE-NO                  TO S-RS3-POLE-NO            
           MOVE CP-NO-UNITS                 TO S-RS3-NO-UNITS           
           MOVE CP-CODE-STAT-REASON         TO S-RS3-CODE-STAT-REASON   
           MOVE WS-CD-STAT-RSON-LNG-DESC    TO                          
                                   S-RS3-CD-STAT-RSON-LNG-DESC          
           MOVE CP-DATE-PLAN-START          TO S-RS3-DATE-PLAN-START    
           MOVE CP-REMOVE-DATE              TO S-RS3-REMOVE-DATE        
           MOVE WS-PRICE-PER-SERV           TO S-RS3-PRICE-PER-SERV     
           MOVE WS-TOT-PRICE                TO S-RS3-TOTAL-PRICE        
           MOVE WS-UM-EQUIP-SHRT-DESC       TO S-RS3-EQUIP-SHRT-DESC    
           MOVE WS-UM-EQUIP-LONG-DESC       TO S-RS3-EQUIP-LONG-DESC    
           MOVE WS-UM-EQUIP-TYPE-CD         TO S-RS3-UM-EQUIP-TYPE-CD   
           MOVE WS-UM-EQUIP-TYPE-DESC       TO S-RS3-UM-EQUIP-TYPE-DESC 
           MOVE CP-LAST-BILL-DATE           TO S-RS3-LAST-BILL-DATE     
           MOVE CP-USAGE-FIXED              TO S-RS3-USAGE-FIXED        
           MOVE CP-MTHLY-AMOUNT-FIXED       TO S-RS3-MTHLY-AMOUNT-FIXED 
                                                                        
           PERFORM 8030-INSERT-GTT-R3          THRU 8030-EXIT.          
           INITIALIZE GTT-RETURN-FIELDS-3.                              
                                                                        
       2420-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      *                                                              *          
      * 5000-SEARCH-CD-VALUE.                                        *          
      ****************************************************************          
       5000-SEARCH-CD-VALUE.                                            
                                                                        
           SET WS-CD-VAL-INDX      TO 1                                 
           SEARCH WS-CODE-VALUE-DATA                                    
              AT END                                                    
              MOVE SPACES                    TO WS-LONG-DESC            
              MOVE SPACES                    TO WS-SHORT-DESC           
              MOVE WS-ZERO                   TO WS-SORT-ORDER           
           WHEN WS-CODE-VALUE(WS-CD-VAL-INDX) = WS-SRCH-CODE-VALUE      
            AND WS-COLUMN-NA(WS-CD-VAL-INDX)  = WS-SRCH-COLUMN-NA       
            AND WS-TABLE-NA(WS-CD-VAL-INDX)   = WS-SRCH-TABLE-NA        
                MOVE WS-CODE-LONG-DESC(WS-CD-VAL-INDX)                  
                                             TO WS-LONG-DESC            
                MOVE WS-CODE-SHORT-DESC(WS-CD-VAL-INDX)                 
                                             TO WS-SHORT-DESC           
                MOVE WS-CODE-SORT-ORDER(WS-CD-VAL-INDX)                 
                                             TO WS-SORT-ORDER           
           END-SEARCH.                                                  
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 22150000
      * 5901-NEXT-READ-DATE.                                                    
      ***************************************************************** 22150000
           EXEC SQL                                                             
              INCLUDE CPD00310                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7000-OPEN-UTIL-ENVRNMT-CUR.                                    *        
      ******************************************************************        
       7000-OPEN-UTIL-ENVRNMT-CUR.                                      
                                                                        
           EXEC SQL                                                     
                OPEN UTIL_ENVRNMT_CUR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7000'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_UTIL_ENVRNMT'    TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE UT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7010-FETCH-UTIL-ENVRNMT-CUR.                                   *        
      ******************************************************************        
       7010-FETCH-UTIL-ENVRNMT-CUR.                                     
                                                                        
           EXEC SQL                                                     
               FETCH UTIL_ENVRNMT_CUR                                   
                INTO :UT-CODE-UTIL-TYPE                                 
                    ,:UT-IC-NO                                          
                    ,:UT-RATE-PLAN-NO                                   
                    ,:UT-COMPANY-NO                                     
                    ,:UT-CODE-CURTAIL-PRTY                              
                    ,:RD-RATE-DESC                                      
                    ,:UT-CODE-REVENUE-CLASS                             
                    ,:F3-REVENUE-CLS-DESC                               
                    ,:RD-SECURED-RATE-FL                                
LMSCHG              ,:RD-UNMTR-PROV-FL                                  
                    ,:UT-READ-CYCLE                                     
                    ,:UT-READ-ROUTE                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1          
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE 'Y'                TO WS-NO-MORE-UTIL-ROWS     
                    MOVE 0                  TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE '7010'             TO ACTIVE-PARAGRAPH         
                    MOVE 'FETCH'            TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSS_UTIL_ENVRNMT' TO TABLE-1                  
                    MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1          
                    MOVE UT-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7020-CLOSE-UTIL-ENVRNMT-CUR.                                   *        
      ******************************************************************        
       7020-CLOSE-UTIL-ENVRNMT-CUR.                                     
                                                                        
           EXEC SQL                                                     
                CLOSE UTIL_ENVRNMT_CUR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7020'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_UTIL_ENVRNMT'       TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE UT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7025-GET-ACCT-TYPE.                                            *        
      *                                                                *        
      ******************************************************************        
       7025-GET-ACCT-TYPE.                                              
                                                                        
           EXEC SQL                                                     
              SELECT ACCOUNT_TYPE_CODE                                  
                    ,CODE_ACCT_USAGE                                    
                    ,MST_SUB_ACCT_IND                                   
                INTO :AT-ACCOUNT-TYPE-CODE                              
                    ,:AT-CODE-ACCT-USAGE                                
                    ,:AT-MST-SUB-ACCT-IND                               
                FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
               WHERE AT.ACCOUNT_NO    = :AT-ACCOUNT-NO                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ACCOUNT_TYPE_CODE                                          
MFA-TR*             ,CODE_ACCT_USAGE                                            
MFA-TR*             ,MST_SUB_ACCT_IND                                           
MFA-TR*         INTO :AT-ACCOUNT-TYPE-CODE                                      
MFA-TR*             ,:AT-CODE-ACCT-USAGE                                        
MFA-TR*             ,:AT-MST-SUB-ACCT-IND                                       
MFA-TR*         FROM CSS_ACCOUNT AT                                             
MFA-TR*        WHERE AT.ACCOUNT_NO    = :AT-ACCOUNT-NO                          
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7025                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7025'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_ACCOUNT'            TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7025-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7030-OPEN-MTRD-ENVRNMT-CUR.                                    *        
      ******************************************************************        
       7030-OPEN-MTRD-ENVRNMT-CUR.                                      
                                                                        
           EXEC SQL                                                     
                OPEN MTRD_ENVRNMT_CUR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7030'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_MTRD_ENVRNMT'    TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'UTIL_TYPE'           TO TABLE-ELEMENT-2             
              MOVE 'IC_NO'               TO TABLE-ELEMENT-3             
              MOVE MN-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE MN-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2           
              MOVE MN-IC-NO              TO HOSTVAR-ELEMENT-3           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7040-FETCH-MTRD-ENVRNMT-CUR.                                   *        
      ******************************************************************        
       7040-FETCH-MTRD-ENVRNMT-CUR.                                     
                                                                        
           EXEC SQL                                                     
               FETCH MTRD_ENVRNMT_CUR                                   
                INTO :MN-CODE-METER-STATUS                              
                    ,:MN-CODE-STATUS-REAS                               
                    ,:MN-DATE-MTR-INSTALL :WS-NULL-IND-01                
                    ,:MN-LAST-VAL-RD-VALUE                              
                    ,:MN-LAST-VALID-READ-DT :WS-NULL-IND-02              
                    ,:MN-LAST-VALID-READ-TM                             
                    ,:MN-METER-NO                                       
                    ,:MN-METER-PRESSURE                                 
                    ,:MN-METER-SUPPLYING                                
                    ,:MN-MTR-READ-SOURCE-CD                             
                    ,:MN-GIS-POINT-ID                                   
                    ,:MN-MTR-REF-NO                                     
                    ,:MN-REG-ID-NO                                      
                    ,:MN-CODE-METER-LOC                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-2          
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    IF WS-NULL-IND-01 = WS-YES-NULL                     
                       MOVE SPACES          TO MN-DATE-MTR-INSTALL      
                    END-IF                                              
                    IF WS-NULL-IND-02 = WS-YES-NULL                     
                       MOVE SPACES          TO MN-LAST-VALID-READ-DT    
                    END-IF                                              
               WHEN NOT-FOUND                                           
                    MOVE 'Y'                TO WS-NO-MORE-MTRD-ROWS     
                    MOVE 0                  TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE '7040'             TO ACTIVE-PARAGRAPH         
                    MOVE 'FETCH'            TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSS_MTRD_ENVRNMT' TO TABLE-1                  
                    MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1          
                    MOVE 'UTIL_TYPE'        TO TABLE-ELEMENT-2          
                    MOVE 'IC_NO'            TO TABLE-ELEMENT-3          
                    MOVE MN-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1        
                    MOVE MN-CODE-UTIL-TYPE  TO HOSTVAR-ELEMENT-2        
                    MOVE MN-IC-NO           TO HOSTVAR-ELEMENT-3        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       7040-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7050-CLOSE-MTRD-ENVRNMT-CUR.                                   *        
      ******************************************************************        
       7050-CLOSE-MTRD-ENVRNMT-CUR.                                     
                                                                        
           EXEC SQL                                                     
                CLOSE MTRD_ENVRNMT_CUR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-2.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7050'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_MTRD_ENVRNMT'       TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'UTIL_TYPE'              TO TABLE-ELEMENT-2          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE MN-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE MN-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE MN-IC-NO                 TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7060-OPEN-UNMETER-CUR.                                         *        
      ******************************************************************        
       7060-OPEN-UNMETER-CUR.                                           
                                                                        
           EXEC SQL                                                     
                OPEN UNMETER_CUR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7060'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_CUST_PLAN'       TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'UTIL_TYPE'           TO TABLE-ELEMENT-2             
              MOVE 'IC_NO'               TO TABLE-ELEMENT-3             
              MOVE CP-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE CP-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2           
              MOVE CP-IC-NO              TO HOSTVAR-ELEMENT-3           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7060-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7070-FETCH-UNMETER-CUR.                                        *        
      ******************************************************************        
       7070-FETCH-UNMETER-CUR.                                          
                                                                        
           EXEC SQL                                                     
               FETCH UNMETER_CUR                                        
                INTO :CP-RATE-ITEM-CODE                                 
                    ,:CP-ITEM-SEQ-NO                                    
                    ,:CP-CODE-PLAN-STATUS                               
                    ,:CP-POLE-NO                                        
                    ,:CP-NO-UNITS                                       
                    ,:CP-CODE-STAT-REASON                               
                    ,:CP-DATE-PLAN-START :WS-NULL-IND-03                 
                    ,:CP-REMOVE-DATE :WS-NULL-IND-04                     
                    ,:CP-LAST-BILL-DATE :WS-NULL-IND-05                  
                    ,:CP-USAGE-FIXED                                    
                    ,:CP-MTHLY-AMOUNT-FIXED                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-3          
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    IF WS-NULL-IND-03 = WS-YES-NULL                     
                       MOVE SPACES          TO CP-DATE-PLAN-START       
                    END-IF                                              
                    IF WS-NULL-IND-04 = WS-YES-NULL                     
                       MOVE SPACES          TO CP-REMOVE-DATE           
                    END-IF                                              
                    IF WS-NULL-IND-05 = WS-YES-NULL                     
                       MOVE SPACES          TO CP-LAST-BILL-DATE        
                    END-IF                                              
               WHEN NOT-FOUND                                           
                    MOVE 'Y'                TO WS-NO-MORE-UNMTR-ROWS    
                    MOVE 0                  TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE '7070'             TO ACTIVE-PARAGRAPH         
                    MOVE 'FETCH'            TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSS_CUST_PLAN'    TO TABLE-1                  
                    MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1          
                    MOVE 'UTIL_TYPE'        TO TABLE-ELEMENT-2          
                    MOVE 'IC_NO'            TO TABLE-ELEMENT-3          
                    MOVE CP-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1        
                    MOVE CP-CODE-UTIL-TYPE  TO HOSTVAR-ELEMENT-2        
                    MOVE CP-IC-NO           TO HOSTVAR-ELEMENT-3        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       7070-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7080-CLOSE-UNMETER-CUR.                                        *        
      ******************************************************************        
       7080-CLOSE-UNMETER-CUR.                                          
                                                                        
           EXEC SQL                                                     
                CLOSE UNMETER_CUR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-3.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7080'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_MTRD_ENVRNMT'       TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'UTIL_TYPE'              TO TABLE-ELEMENT-2          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE CP-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE CP-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE CP-IC-NO                 TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7080-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7090-GET-MTR-RD-SURC-DESC.                                    *         
      ******************************************************************        
       7090-GET-MTR-RD-SURC-DESC.                                       
                                                                        
           EXEC SQL                                                     
                SELECT X7.MTR_READ_SOURCE_TX                            
                  INTO :X7-MTR-READ-SOURCE-TX                           
                  FROM CSS_MTR_RD_SOURCE X7 WITH(READUNCOMMITTED)               
                 WHERE X7.MTR_READ_SOURCE_CD = :X7-MTR-READ-SOURCE-CD   
                                                                 
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     20010000
MFA-TR*         SELECT X7.MTR_READ_SOURCE_TX                            20020000
MFA-TR*           INTO :X7-MTR-READ-SOURCE-TX                           20040000
MFA-TR*           FROM CSS_MTR_RD_SOURCE X7                             20060000
MFA-TR*          WHERE X7.MTR_READ_SOURCE_CD = :X7-MTR-READ-SOURCE-CD   20070000
MFA-TR*           WITH UR                                                       
MFA-TR*        QUERYNO 7090                                                     
MFA-TR*    END-EXEC                                                     20100000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7090'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_MTR_RD_SOURCE'       TO TABLE-1                 
              MOVE 'MTR_READ_SOURCE_CD'      TO TABLE-ELEMENT-1         
              MOVE X7-MTR-READ-SOURCE-CD     TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7090-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
ACT041*                                                                *        
ACT041* 7095-GET-MTR-LOC-DESC.                                        *         
ACT041******************************************************************        
ACT041 7095-GET-MTR-LOC-DESC.                                           
ACT041                                                                  
ACT041     EXEC SQL                                                     
ACT041          SELECT Q4.METER_LOC_DESC                                
ACT041            INTO :Q4-METER-LOC-DESC                               
ACT041            FROM CSS_METER_LOC     Q4 WITH(READUNCOMMITTED)               
ACT041           WHERE Q4.CODE_METER_LOC = :Q4-CODE-METER-LOC           
ACT041                                                           
ACT041                                                      
ACT041     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     20010000
MFA-TR*         SELECT Q4.METER_LOC_DESC                                20020000
MFA-TR*           INTO :Q4-METER-LOC-DESC                               20040000
MFA-TR*           FROM CSS_METER_LOC     Q4                             20060000
MFA-TR*          WHERE Q4.CODE_METER_LOC = :Q4-CODE-METER-LOC           20070000
MFA-TR*           WITH UR                                                       
MFA-TR*        QUERYNO 7095                                                     
MFA-TR*    END-EXEC                                                     20100000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT041                                                                  
ACT041     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
ACT041                                                                  
ACT041     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
ACT041        CONTINUE                                                  
ACT041     ELSE                                                         
ACT041        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
ACT041        MOVE '7095'                    TO ACTIVE-PARAGRAPH        
ACT041        MOVE 'SELECT'                  TO ABEND-FUNCTION          
ACT041        MOVE SPACES                    TO ABEND-SQL-PREDICATES    
ACT041                                          ABEND-TABLES            
ACT041        MOVE 'CSS_METER_LOC'           TO TABLE-1                 
ACT041        MOVE 'METER_LOC_DESC'          TO TABLE-ELEMENT-1         
ACT041        MOVE Q4-CODE-METER-LOC         TO HOSTVAR-ELEMENT-1       
ACT041        PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
ACT041     END-IF.                                                      
ACT041                                                                  
ACT041 7095-EXIT.                                                       
ACT041     EXIT.                                                        
ACT041                                                                  
      ******************************************************************        
      *                                                                *        
      * 7100-GET-METER-CAP-DETAILS.                                    *        
      ******************************************************************        
       7100-GET-METER-CAP-DETAILS.                                      
                                                                        
           EXEC SQL                                                     
                SELECT CONSTANT                                         
                      ,NO_READ_DIALS                                    
                  INTO :MC-CONSTANT                                     
                      ,:MC-NO-READ-DIALS                                
                  FROM CSS_MTR_CAP  MC WITH(READUNCOMMITTED)                    
                 WHERE MC.METER_NO       = :MC-METER-NO                 
                   AND MC.REG_ID_NO      = :MC-REG-ID-NO                
                   AND MC.CODE_UTIL_TYPE = :MC-CODE-UTIL-TYPE           
                   AND MC.COMPANY_NO     = :MC-COMPANY-NO               
                                                                 
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     20010000
MFA-TR*         SELECT CONSTANT                                         20020000
MFA-TR*               ,NO_READ_DIALS                                    20030000
MFA-TR*           INTO :MC-CONSTANT                                     20040000
MFA-TR*               ,:MC-NO-READ-DIALS                                20050000
MFA-TR*           FROM CSS_MTR_CAP  MC                                  20060000
MFA-TR*          WHERE MC.METER_NO       = :MC-METER-NO                 20070000
MFA-TR*            AND MC.REG_ID_NO      = :MC-REG-ID-NO                20080000
MFA-TR*            AND MC.CODE_UTIL_TYPE = :MC-CODE-UTIL-TYPE           20090000
MFA-TR*            AND MC.COMPANY_NO     = :MC-COMPANY-NO                       
MFA-TR*           WITH UR                                                       
MFA-TR*        QUERYNO 7100                                                     
MFA-TR*    END-EXEC                                                     20100000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7100'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_MTR_CAP'             TO TABLE-1                 
              MOVE 'MTR_NO'                  TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-3         
              MOVE MN-METER-NO               TO HOSTVAR-ELEMENT-1       
              MOVE MN-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              MOVE MN-ACCOUNT-NO             TO HOSTVAR-ELEMENT-3       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7110-GET-DET-CONSUMP-HIST.                                     *        
      ******************************************************************        
       7110-GET-DET-CONSUMP-HIST.                                       
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) CONSTANT,
              NO_DIALS                                           
                INTO :CX-CONSTANT                                       
                    ,:CX-NO-DIALS                                       
                FROM CSS_CNSMPTN_HIST CX WITH(READUNCOMMITTED)                  
               WHERE METER_NO       = :CX-METER-NO                      
                 AND ACCOUNT_NO     = :CX-ACCOUNT-NO                    
                 AND IC_NO          = :CX-IC-NO                         
                 AND CODE_UTIL_TYPE = :CX-CODE-UTIL-TYPE                
                 AND MTR_REF_NO     = :CX-MTR-REF-NO                    
                 AND COMPANY_NO     = :CX-COMPANY-NO                    
               ORDER BY BILL_NO DESC                                    
                                             
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CONSTANT                                                   
MFA-TR*             ,NO_DIALS                                                   
MFA-TR*         INTO :CX-CONSTANT                                               
MFA-TR*             ,:CX-NO-DIALS                                               
MFA-TR*         FROM CSS_CNSMPTN_HIST CX                                        
MFA-TR*        WHERE METER_NO       = :CX-METER-NO                              
MFA-TR*          AND ACCOUNT_NO     = :CX-ACCOUNT-NO                            
MFA-TR*          AND IC_NO          = :CX-IC-NO                                 
MFA-TR*          AND CODE_UTIL_TYPE = :CX-CODE-UTIL-TYPE                        
MFA-TR*          AND MTR_REF_NO     = :CX-MTR-REF-NO                            
MFA-TR*          AND COMPANY_NO     = :CX-COMPANY-NO                            
MFA-TR*        ORDER BY BILL_NO DESC                                            
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7110                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7110'                 TO ACTIVE-PARAGRAPH           
              MOVE 'SELECT'               TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSS_CNSMPTN_HIST'     TO TABLE-1                    
              MOVE 'MTR_NO'               TO TABLE-ELEMENT-1            
              MOVE 'CODE_UTIL_TYPE'       TO TABLE-ELEMENT-2            
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-3            
              MOVE CX-METER-NO            TO HOSTVAR-ELEMENT-1          
              MOVE CX-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-2          
              MOVE CX-ACCOUNT-NO          TO HOSTVAR-ELEMENT-3          
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7120-GET-PRICE-PER-SERV.                                       *        
      ******************************************************************        
       7120-GET-PRICE-PER-SERV.                                         
                                                                        
           EXEC SQL                                                     
              SELECT UP.PRICE_PER_SERV                                  
                INTO :UP-PRICE-PER-SERV                                 
                FROM CSS_UNMTR_PLAN UP WITH(READUNCOMMITTED)                    
               WHERE UP.CODE_UTIL_TYPE   = :UP-CODE-UTIL-TYPE           
                 AND UP.RATE_PLAN_NO     = :UP-RATE-PLAN-NO             
                 AND UP.RATE_ITEM_CODE   = :UP-RATE-ITEM-CODE           
                 AND UP.VERSION_NO_CNTRL =                              
                       (SELECT MAX(A.VERSION_NO_CNTRL)                  
                          FROM CSS_UNMTR_PLAN A WITH(READUNCOMMITTED)           
                         WHERE A.CODE_UTIL_TYPE = :UP-CODE-UTIL-TYPE    
                           AND A.RATE_PLAN_NO   = :UP-RATE-PLAN-NO      
                           AND A.RATE_ITEM_CODE = :UP-RATE-ITEM-CODE)   
                                                                 
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT UP.PRICE_PER_SERV                                          
MFA-TR*         INTO :UP-PRICE-PER-SERV                                         
MFA-TR*         FROM CSS_UNMTR_PLAN UP                                          
MFA-TR*        WHERE UP.CODE_UTIL_TYPE   = :UP-CODE-UTIL-TYPE                   
MFA-TR*          AND UP.RATE_PLAN_NO     = :UP-RATE-PLAN-NO                     
MFA-TR*          AND UP.RATE_ITEM_CODE   = :UP-RATE-ITEM-CODE                   
MFA-TR*          AND UP.VERSION_NO_CNTRL =                                      
MFA-TR*                (SELECT MAX(A.VERSION_NO_CNTRL)                          
MFA-TR*                   FROM CSS_UNMTR_PLAN A                                 
MFA-TR*                  WHERE A.CODE_UTIL_TYPE = :UP-CODE-UTIL-TYPE            
MFA-TR*                    AND A.RATE_PLAN_NO   = :UP-RATE-PLAN-NO              
MFA-TR*                    AND A.RATE_ITEM_CODE = :UP-RATE-ITEM-CODE)           
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7120                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7120'                 TO ACTIVE-PARAGRAPH           
              MOVE 'SELECT'               TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSS_UNMTR_PLAN'       TO TABLE-1                    
              MOVE 'CODE_UTIL_TYPE'       TO TABLE-ELEMENT-1            
              MOVE 'RATE_PLAN_NO'         TO TABLE-ELEMENT-2            
              MOVE 'RATE_ITEM_CODE'       TO TABLE-ELEMENT-3            
              MOVE UP-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-1          
              MOVE UP-RATE-PLAN-NO        TO HOSTVAR-ELEMENT-2          
              MOVE UP-RATE-ITEM-CODE      TO HOSTVAR-ELEMENT-3          
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7130-GET-RATE-ITEM-DESC.                                       *        
      ******************************************************************        
       7130-GET-RATE-ITEM-DESC.                                         
                                                                        
           EXEC SQL                                                     
              SELECT L9.UM_EQUIP_SHRT_DESC                              
                    ,L9.UM_EQUIP_LONG_DESC                              
                    ,L9.UM_EQUIP_TYPE_CD                                
                INTO :L9-UM-EQUIP-SHRT-DESC                             
                    ,:L9-UM-EQUIP-LONG-DESC                             
                    ,:L9-UM-EQUIP-TYPE-CD                               
                FROM CSS_UNMTR_PLAN   UP                                
                    ,CSS_UM_EQUIPMENT L9                                
               WHERE UP.UM_EQUIP_ID    =  L9.UM_EQUIP_ID                
                 AND UP.CODE_UTIL_TYPE = :UP-CODE-UTIL-TYPE             
                 AND UP.RATE_PLAN_NO   = :UP-RATE-PLAN-NO               
                 AND UP.RATE_ITEM_CODE = :UP-RATE-ITEM-CODE             
                 AND L9.STATUS_CD      = 'A'                            
                 AND UP.VERSION_NO_CNTRL =                              
                        (SELECT MAX(RT.VERSION_NO_CNTRL)                
                           FROM CSS_RATE_CREATOR RT                     
                          WHERE RT.CODE_UTIL_TYPE = :UP-CODE-UTIL-TYPE  
                            AND RT.RATE_PLAN_NO   = :UP-RATE-PLAN-NO    
                            AND RT.CODE_STATUS    = 'A')                
              ORDER BY UP.RATE_ITEM_CODE                                
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7130'                 TO ACTIVE-PARAGRAPH           
              MOVE 'SELECT'               TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSS_UNMTR_PLAN'       TO TABLE-1                    
              MOVE 'CODE_UTIL_TYPE'       TO TABLE-ELEMENT-1            
              MOVE 'RATE_PLAN_NO'         TO TABLE-ELEMENT-2            
              MOVE 'RATE_ITEM_CODE'       TO TABLE-ELEMENT-3            
              MOVE UP-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-1          
              MOVE UP-RATE-PLAN-NO        TO HOSTVAR-ELEMENT-2          
              MOVE UP-RATE-ITEM-CODE      TO HOSTVAR-ELEMENT-3          
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7130-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7140-GET-GIS-LOC-AND-TAG.                                     *         
      *****************************************************************         
       7140-GET-GIS-LOC-AND-TAG.                                        
                                                                        
           EXEC SQL                                                     
              SELECT PP.AREA_ID                                         
                    ,PP.TAG_NM                                          
                INTO :PP-AREA-ID                                        
                    ,:PP-TAG-NM                                         
                FROM CSS_PIM_POINT PP WITH(READUNCOMMITTED)                     
               WHERE PP.POINT_ID = :MN-GIS-POINT-ID                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT PP.AREA_ID                                                 
MFA-TR*             ,PP.TAG_NM                                                  
MFA-TR*         INTO :PP-AREA-ID                                                
MFA-TR*             ,:PP-TAG-NM                                                 
MFA-TR*         FROM CSS_PIM_POINT PP                                           
MFA-TR*        WHERE PP.POINT_ID = :MN-GIS-POINT-ID                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7140                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7140'                 TO ACTIVE-PARAGRAPH           
              MOVE 'SELECT'               TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSS_PIM_POINT'        TO TABLE-1                    
              MOVE 'GIS_POINT_ID'         TO TABLE-ELEMENT-1            
              MOVE MN-GIS-POINT-ID        TO HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7140-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7200-GET-ELEC-METER.                                          *         
      *****************************************************************         
       7200-GET-ELEC-METER.                                             
                                                                        
           EXEC SQL                                                     
              SELECT EM.METER_SIZE_ID                                   
                INTO :WS-E-METER-SIZE-ID                                
                FROM CSS_ELEC_METER EM WITH(READUNCOMMITTED)                    
               WHERE EM.CODE_UTIL_TYPE   = :WS-KEY-UTIL-TYPE            
                 AND EM.METER_NO         = :EM-METER-NO                 
                 AND EM.COMPANY_NO       = :EM-COMPANY-NO               
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT EM.METER_SIZE_ID                                           
MFA-TR*         INTO :WS-E-METER-SIZE-ID                                        
MFA-TR*         FROM CSS_ELEC_METER EM                                          
MFA-TR*        WHERE EM.CODE_UTIL_TYPE   = :WS-KEY-UTIL-TYPE                    
MFA-TR*          AND EM.METER_NO         = :EM-METER-NO                         
MFA-TR*          AND EM.COMPANY_NO       = :EM-COMPANY-NO                       
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7200                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE '7200'                  TO ACTIVE-PARAGRAPH          
              MOVE 'SELECT'                TO ABEND-FUNCTION            
              MOVE SPACES                  TO ABEND-SQL-PREDICATES      
                                                ABEND-TABLES            
              MOVE 'CSS_ELEC_MTR'          TO TABLE-1                   
              MOVE 'MTR_NO'                TO TABLE-ELEMENT-1           
              MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2           
              MOVE 'COMPANY_NO'            TO TABLE-ELEMENT-3           
              MOVE MN-METER-NO             TO HOSTVAR-ELEMENT-1         
              MOVE WS-KEY-UTIL-TYPE        TO HOSTVAR-ELEMENT-2         
              MOVE EM-COMPANY-NO           TO HOSTVAR-ELEMENT-3         
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7210-GET-ELEC-METER-SIZE                                       *        
      ******************************************************************        
       7210-GET-ELEC-METER-SIZE.                                        
                                                                        
           EXEC SQL                                                     
              SELECT M1.METER_SIZE_DESC                                 
                INTO :WS-METER-SIZE-DESC                                
                FROM CSS_ELEC_MTR_SIZE M1 WITH(READUNCOMMITTED)                 
               WHERE M1.METER_SIZE_ID  = :WS-E-METER-SIZE-ID            
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT M1.METER_SIZE_DESC                                         
MFA-TR*         INTO :WS-METER-SIZE-DESC                                        
MFA-TR*         FROM CSS_ELEC_MTR_SIZE M1                                       
MFA-TR*        WHERE M1.METER_SIZE_ID  = :WS-E-METER-SIZE-ID                    
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7210                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7210'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_ELEC_MTR_SIZE'     TO TABLE-1                  
               MOVE 'METER_SIZE_ID'         TO TABLE-ELEMENT-1          
               MOVE WS-E-METER-SIZE-ID      TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7220-GET-GAS-METER.                                            *        
      ******************************************************************        
       7220-GET-GAS-METER.                                              
                                                                        
           EXEC SQL                                                     
              SELECT GM.METER_SIZE_ID                                   
                INTO :WS-G-METER-SIZE-ID                                
                FROM CSS_GAS_METER GM WITH(READUNCOMMITTED)                     
               WHERE GM.CODE_UTIL_TYPE = :WS-KEY-UTIL-TYPE              
                 AND GM.METER_NO       = :GM-METER-NO                   
                 AND GM.COMPANY_NO     = :GM-COMPANY-NO                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT GM.METER_SIZE_ID                                           
MFA-TR*         INTO :WS-G-METER-SIZE-ID                                        
MFA-TR*         FROM CSS_GAS_METER GM                                           
MFA-TR*        WHERE GM.CODE_UTIL_TYPE = :WS-KEY-UTIL-TYPE                      
MFA-TR*          AND GM.METER_NO       = :GM-METER-NO                           
MFA-TR*          AND GM.COMPANY_NO     = :GM-COMPANY-NO                         
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7220                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO RS-RETURN-CODE            
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE '7220'                  TO ACTIVE-PARAGRAPH          
              MOVE 'SELECT'                TO ABEND-FUNCTION            
              MOVE SPACES                  TO ABEND-SQL-PREDICATES      
                                                ABEND-TABLES            
              MOVE 'CSS_GAS_METER'         TO TABLE-1                   
              MOVE 'METER_NO'              TO TABLE-ELEMENT-1           
              MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2           
              MOVE 'COMPANY_NO'            TO TABLE-ELEMENT-3           
              MOVE GM-METER-NO             TO HOSTVAR-ELEMENT-1         
              MOVE WS-KEY-UTIL-TYPE        TO HOSTVAR-ELEMENT-2         
              MOVE GM-COMPANY-NO           TO HOSTVAR-ELEMENT-3         
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7220-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7230-GET-GAS-METER-SIZE.                                       *        
      ******************************************************************        
       7230-GET-GAS-METER-SIZE.                                         
                                                                        
           EXEC SQL                                                     
              SELECT M5.METER_SIZE_DESC                                 
                INTO :WS-METER-SIZE-DESC                                
                FROM CSS_GAS_METER_SIZE M5 WITH(READUNCOMMITTED)                
               WHERE M5.METER_SIZE_ID  = :WS-G-METER-SIZE-ID            
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT M5.METER_SIZE_DESC                                         
MFA-TR*         INTO :WS-METER-SIZE-DESC                                        
MFA-TR*         FROM CSS_GAS_METER_SIZE M5                                      
MFA-TR*        WHERE M5.METER_SIZE_ID  = :WS-G-METER-SIZE-ID                    
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7230                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE   TO RS-RETURN-CODE           
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7230'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                                 ABEND-TABLES           
               MOVE 'CSS_GAS_METER_SIZE'    TO TABLE-1                  
               MOVE 'METER_SIZE_ID'         TO TABLE-ELEMENT-1          
               MOVE WS-G-METER-SIZE-ID      TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7230-EXIT.                                                       
           EXIT.                                                        
                                                                        
ACT163******************************************************************22160000
ACT163* 7300-ADD-ONE-DAY.                                               22170000
ACT163******************************************************************22180000
ACT163*7300-ADD-ONE-DAY.                                                        
ACT163*                                                                         
ACT163*    EXEC SQL                                                             
ACT163*        SET :WS-DATE-READ = DATE(DATE(:WS-DATE-READ) + 1 DAY)            
ACT163*    END-EXEC.                                                            
ACT163*                                                                         
ACT163*    MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE            
ACT163*                                                                         
ACT163*    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND              
ACT163*       CONTINUE                                                          
ACT163*    ELSE                                                                 
ACT163*        MOVE PROGRAM-NAME            TO ABEND-PROGRAM                    
ACT163*        MOVE '7300'                  TO ACTIVE-PARAGRAPH                 
ACT163*        MOVE 'SET'                   TO ABEND-FUNCTION                   
ACT163*        MOVE SPACES                  TO ABEND-SQL-PREDICATES             
ACT163*                                          ABEND-TABLES                   
ACT163*        MOVE 'DATE_READ'             TO TABLE-ELEMENT-1                  
ACT163*        MOVE WS-DATE-READ            TO HOSTVAR-ELEMENT-1                
ACT163*        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT                   
ACT163*    END-IF.                                                              
ACT163*                                                                         
ACT163*7300-EXIT.                                                               
ACT163*    EXIT.                                                                
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7400-GET-PRTY-SVC-CAT-CD.                                      *        
      ******************************************************************        
       7400-GET-PRTY-SVC-CAT-CD.                                        
                                                                        
           EXEC SQL                                                     
              SELECT Z4.PRTY_SVC_CAT_CD                                 
                    ,Z4.PRTY_SVC_CAT_DESC                               
                INTO :Z4-PRTY-SVC-CAT-CD                                
                    ,:Z4-PRTY-SVC-CAT-DESC                              
                FROM CSS_PRTY_SVC_CAT Z4 WITH(READUNCOMMITTED)                  
               WHERE Z4.CODE_CURTAIL_PRTY = :Z4-CODE-CURTAIL-PRTY       
                 AND Z4.COMPANY_NO        = :Z4-COMPANY-NO              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT Z4.PRTY_SVC_CAT_CD                                         
MFA-TR*             ,Z4.PRTY_SVC_CAT_DESC                                       
MFA-TR*         INTO :Z4-PRTY-SVC-CAT-CD                                        
MFA-TR*             ,:Z4-PRTY-SVC-CAT-DESC                                      
MFA-TR*         FROM CSS_PRTY_SVC_CAT Z4                                        
MFA-TR*        WHERE Z4.CODE_CURTAIL_PRTY = :Z4-CODE-CURTAIL-PRTY               
MFA-TR*          AND Z4.COMPANY_NO        = :Z4-COMPANY-NO                      
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7400                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7400'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_PRTY-SVC-CAT-CD'    TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-2          
              MOVE UT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE Z4-COMPANY-NO            TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7500-OPEN-CODE-VALUE-CUR.                                      *        
      ******************************************************************        
       7500-OPEN-CODE-VALUE-CUR.                                        
                                                                        
           EXEC SQL                                                     
                OPEN CODE_VALUE_CUR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7500'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_CODE_VALUE'      TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7510-FETCH-CODE-VALUE-CUR.                                     *        
      ******************************************************************        
       7510-FETCH-CODE-VALUE-CUR.                                       
                                                                        
           EXEC SQL                                                     
               FETCH CODE_VALUE_CUR                                     
                INTO :UV-CODE-VALUE                                     
                    ,:UV-COMPANY-NO                                     
                    ,:UV-COLUMN-NA                                      
                    ,:UV-TABLE-NA                                       
                    ,:UV-CODE-LONG-DESC                                 
                    ,:UV-CODE-SHORT-DESC                                
                    ,:UV-SORT-ORDER                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE 'Y'                TO WS-NO-MORE-CD-VALUE      
                    MOVE 0                  TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE '7510'             TO ACTIVE-PARAGRAPH         
                    MOVE 'FETCH'            TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSS_CODE_VALUE'   TO TABLE-1                  
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       7510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7520-CLOSE-CODE-VALUE-CUR.                                     *        
      ******************************************************************        
       7520-CLOSE-CODE-VALUE-CUR.                                       
                                                                        
           EXEC SQL                                                     
                CLOSE CODE_VALUE_CUR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7520'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_CODE_VALUE'         TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7520-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7550-GET-RULE-XREF-ID                                          *        
      *                                                                *        
      ******************************************************************        
       7550-GET-RULE-XREF-ID.                                           
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           BUS_RULE_XREF_ID, 121), ' ', '-'), ':', '.') 
           BUS_RULE_XREF_ID                                   
                INTO :S-RS4-BUS-RULE-XREF-ID                            
                FROM CSS_BUS_RULE   [1R] WITH(READUNCOMMITTED)                  
                    ,CSS_BUS_RULE_XREF [1T] WITH(READUNCOMMITTED)               
               WHERE [1R].BUS_RULE_ID = :S-RS4-BUS-RULE-ID                
                 AND [1R].BUS_RULE_ID = [1T].BUS_RULE_ID                    
                                             
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BUS_RULE_XREF_ID                                           
MFA-TR*         INTO :S-RS4-BUS-RULE-XREF-ID                                    
MFA-TR*         FROM CSS_BUS_RULE   1R                                          
MFA-TR*             ,CSS_BUS_RULE_XREF 1T                                       
MFA-TR*        WHERE 1R.BUS_RULE_ID = :S-RS4-BUS-RULE-ID                        
MFA-TR*          AND 1R.BUS_RULE_ID = 1T.BUS_RULE_ID                            
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7550                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
               MOVE SPACES                  TO ABEND-TABLES             
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
               MOVE '7550'                  TO ACTIVE-PARAGRAPH         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_BUS_RULE'          TO TABLE-1                  
               MOVE 'BUS_RULE_ID'           TO TABLE-ELEMENT-1          
               MOVE S-RS4-BUS-RULE-ID       TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8000A-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000A-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04640_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04640_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1          
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000A'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04640_R1'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       8000A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8000B-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000B-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04640_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04640_R2                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-2.         
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-2          
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000B'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04640_R2'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       8000B-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8000C-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000C-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04640_R3                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04640_R3                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3.            
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES          TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3             
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME    TO ABEND-PROGRAM               
                    MOVE SQLCODE         TO ABEND-SQLCODE               
                    MOVE SQLSTATE        TO ABEND-SQLSTATE              
                    MOVE '8000C'         TO ACTIVE-PARAGRAPH            
                    MOVE 'DELETE'        TO ABEND-FUNCTION              
                    MOVE SPACES          TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                    MOVE 'CSR04640_R3'   TO TABLE-1                     
                    MOVE SPACES          TO TABLE-ELEMENT-1             
                    MOVE SPACES          TO HOSTVAR-ELEMENT-1           
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       8000C-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8000D-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000D-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04640_R4                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04640_R4                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-4.            
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES          TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-4             
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME    TO ABEND-PROGRAM               
                    MOVE SQLCODE         TO ABEND-SQLCODE               
                    MOVE SQLSTATE        TO ABEND-SQLSTATE              
                    MOVE '8000D'         TO ACTIVE-PARAGRAPH            
                    MOVE 'DELETE'        TO ABEND-FUNCTION              
                    MOVE SPACES          TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                    MOVE 'CSR04640_R4'   TO TABLE-1                     
                    MOVE SPACES          TO TABLE-ELEMENT-1             
                    MOVE SPACES          TO HOSTVAR-ELEMENT-1           
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       8000D-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8010-INSERT-GTT-R1.   OFFER CODE TABLE                         *        
      ******************************************************************        
       8010-INSERT-GTT-R1.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04640_R1                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,CODE_UTIL_TYPE                                       
                  ,IC_NO                                                
                  ,RATE_PLAN_NO                                         
                  ,RATE_DESC                                            
                  ,CODE_REVENUE_CLASS                                   
                  ,REVENUE_CLASS_DESC                                   
                  ,SECURED_RATE_FL                                      
LMSCHG            ,IS_UNMTRD_SRVC                                       
                  ,READ_CYCLE                                           
                  ,READ_ROUTE                                           
                  ,STATUS_CODE                                          
                  ,STATUS                                               
                  ,UNMTRD_VIEW_TYPE                                     
                  ,PRTY_SVC_CAT_CD                                      
                  ,PRTY_SVC_CAT_DEC                                     
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-1                                     
                  ,:S-APPL-RETURN-CODE-1                                
                  ,:S-RS1-CODE-UTIL-TYPE                                
                  ,:S-RS1-IC-NO                                         
                  ,:S-RS1-RATE-PLAN-NO                                  
                  ,:S-RS1-RATE-DESC                                     
                  ,:S-RS1-CODE-REVENUE-CLASS                            
                  ,:S-RS1-REVENUE-CLASS-DESC                            
                  ,:S-RS1-SECURED-RATE-FL                               
LMSCHG            ,:S-RS1-IS-UNMTRD-SRVC                                
                  ,:S-RS1-READ-CYCLE                                    
                  ,:S-RS1-READ-ROUTE                                    
                  ,:S-RS1-STATUS-CODE                                   
                  ,:S-RS1-STAT-CD-SHORT-DESC                            
                  ,:S-RS1-UNMTRD-VIEW-TYPE                              
                  ,:S-RS1-PRTY-SVC-CAT-CD                               
                  ,:S-RS1-PRTY-SVC-CAT-DEC                              
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04640_R1                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,CODE_UTIL_TYPE                                               
MFA-TR*           ,IC_NO                                                        
MFA-TR*           ,RATE_PLAN_NO                                                 
MFA-TR*           ,RATE_DESC                                                    
MFA-TR*           ,CODE_REVENUE_CLASS                                           
MFA-TR*           ,REVENUE_CLASS_DESC                                           
MFA-TR*           ,SECURED_RATE_FL                                              
MFA-TR*           ,IS_UNMTRD_SRVC                                               
MFA-TR*           ,READ_CYCLE                                                   
MFA-TR*           ,READ_ROUTE                                                   
MFA-TR*           ,STATUS_CODE                                                  
MFA-TR*           ,STATUS                                                       
MFA-TR*           ,UNMTRD_VIEW_TYPE                                             
MFA-TR*           ,PRTY_SVC_CAT_CD                                              
MFA-TR*           ,PRTY_SVC_CAT_DEC                                             
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-1                                             
MFA-TR*           ,:S-APPL-RETURN-CODE-1                                        
MFA-TR*           ,:S-RS1-CODE-UTIL-TYPE                                        
MFA-TR*           ,:S-RS1-IC-NO                                                 
MFA-TR*           ,:S-RS1-RATE-PLAN-NO                                          
MFA-TR*           ,:S-RS1-RATE-DESC                                             
MFA-TR*           ,:S-RS1-CODE-REVENUE-CLASS                                    
MFA-TR*           ,:S-RS1-REVENUE-CLASS-DESC                                    
MFA-TR*           ,:S-RS1-SECURED-RATE-FL                                       
MFA-TR*           ,:S-RS1-IS-UNMTRD-SRVC                                        
MFA-TR*           ,:S-RS1-READ-CYCLE                                            
MFA-TR*           ,:S-RS1-READ-ROUTE                                            
MFA-TR*           ,:S-RS1-STATUS-CODE                                           
MFA-TR*           ,:S-RS1-STAT-CD-SHORT-DESC                                    
MFA-TR*           ,:S-RS1-UNMTRD-VIEW-TYPE                                      
MFA-TR*           ,:S-RS1-PRTY-SVC-CAT-CD                                       
MFA-TR*           ,:S-RS1-PRTY-SVC-CAT-DEC                                      
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R1 = 'Y'             
              ADD +1                     TO  CTR-ROWS-RS1               
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8010'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE 'Y'                   TO  WS-ERR-INSRT-R1            
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04640_R1'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
        8010-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8020-INSERT-GTT-R2.                                            *        
      ******************************************************************        
       8020-INSERT-GTT-R2.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04640_R2                           
                 (                                                      
                     RETURN_CODE                                        
                    ,APPL_RETURN_CODE                                   
                    ,CODE_UTIL_TYPE                                     
                    ,IC_NO                                              
                    ,RATE_PLAN_NO                                       
                    ,CODE_METER_STATUS                                  
                    ,CD_MTR_STAT_SHRT_DESC                              
                    ,CD_MTR_STAT_SORT_ORD                               
                    ,CODE_STATUS_REAS                                   
                    ,CD_STAT_REAS_LNG_DESC                              
                    ,DATE_MTR_INSTALL                                   
                    ,METER_TYPE                                         
                    ,LAST_VAL_RD_VALUE                                  
                    ,LAST_VALID_READ_DT                                 
                    ,METER_NO                                           
                    ,MTR_REF_NO                                         
                    ,METER_PRESSURE                                     
                    ,MTR_PRESSURE_LNG_DESC                              
                    ,METER_SUPPLYING                                    
                    ,MTR_READ_SOURCE_CD                                 
                    ,MTR_RD_SRCE_CD_LNG_DESC                            
                    ,POINT_ID                                           
                    ,OPTIMUM_READ_DATE                                  
                    ,CONSTANT                                           
                    ,NO_READ_DIALS                                      
                    ,CODE_METER_LOC                                     
                    ,METER_LOC_DESC                                     
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-2                                     
                  ,:S-APPL-RETURN-CODE-2                                
                  ,:S-RS2-CODE-UTIL-TYPE                                
                  ,:S-RS2-IC-NO                                         
                  ,:S-RS2-RATE-PLAN-NO                                  
                  ,:S-RS2-CODE-METER-STATUS                             
                  ,:S-RS2-MTR-STAT-SHRT-DESC                            
                  ,:S-RS2-MTR-STAT-SORT-ORDR                            
                  ,:S-RS2-CODE-STATUS-REAS                              
                  ,:S-RS2-STAT-REASON-LONG-DESC                         
                  ,:S-RS2-DATE-MTR-INSTALL                              
                  ,:S-RS2-METER-TYPE                                    
                  ,:S-RS2-LAST-VAL-RD-VALUE                             
                  ,:S-RS2-LAST-VALID-READ-DT                            
                  ,:S-RS2-METER-NO                                      
                  ,:S-RS2-METER-REF-NO                                  
                  ,:S-RS2-METER-PRESSURE                                
                  ,:S-RS2-MTR-PRESSRE-LONG-DESC                         
                  ,:S-RS2-METER-SUPPLYING                               
                  ,:S-RS2-MTR-READ-SOURCE-CD                            
                  ,:S-RS2-MTR-RD-SRCE-CD-LNG-DESC                       
                  ,:S-RS2-POINT-ID                                      
                  ,:S-RS2-OPTIMUM-READ-DATE                             
                  ,:S-RS2-CONSTANT                                      
                  ,:S-RS2-NO-READ-DIALS                                 
                  ,:S-RS2-CODE-METER-LOC                                
                  ,:S-RS2-METER-LOC-DESC                                
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04640_R2                                   
MFA-TR*          (                                                              
MFA-TR*              RETURN_CODE                                                
MFA-TR*             ,APPL_RETURN_CODE                                           
MFA-TR*             ,CODE_UTIL_TYPE                                             
MFA-TR*             ,IC_NO                                                      
MFA-TR*             ,RATE_PLAN_NO                                               
MFA-TR*             ,CODE_METER_STATUS                                          
MFA-TR*             ,CD_MTR_STAT_SHRT_DESC                                      
MFA-TR*             ,CD_MTR_STAT_SORT_ORD                                       
MFA-TR*             ,CODE_STATUS_REAS                                           
MFA-TR*             ,CD_STAT_REAS_LNG_DESC                                      
MFA-TR*             ,DATE_MTR_INSTALL                                           
MFA-TR*             ,METER_TYPE                                                 
MFA-TR*             ,LAST_VAL_RD_VALUE                                          
MFA-TR*             ,LAST_VALID_READ_DT                                         
MFA-TR*             ,METER_NO                                                   
MFA-TR*             ,MTR_REF_NO                                                 
MFA-TR*             ,METER_PRESSURE                                             
MFA-TR*             ,MTR_PRESSURE_LNG_DESC                                      
MFA-TR*             ,METER_SUPPLYING                                            
MFA-TR*             ,MTR_READ_SOURCE_CD                                         
MFA-TR*             ,MTR_RD_SRCE_CD_LNG_DESC                                    
MFA-TR*             ,POINT_ID                                                   
MFA-TR*             ,OPTIMUM_READ_DATE                                          
MFA-TR*             ,CONSTANT                                                   
MFA-TR*             ,NO_READ_DIALS                                              
MFA-TR*             ,CODE_METER_LOC                                             
MFA-TR*             ,METER_LOC_DESC                                             
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-2                                             
MFA-TR*           ,:S-APPL-RETURN-CODE-2                                        
MFA-TR*           ,:S-RS2-CODE-UTIL-TYPE                                        
MFA-TR*           ,:S-RS2-IC-NO                                                 
MFA-TR*           ,:S-RS2-RATE-PLAN-NO                                          
MFA-TR*           ,:S-RS2-CODE-METER-STATUS                                     
MFA-TR*           ,:S-RS2-MTR-STAT-SHRT-DESC                                    
MFA-TR*           ,:S-RS2-MTR-STAT-SORT-ORDR                                    
MFA-TR*           ,:S-RS2-CODE-STATUS-REAS                                      
MFA-TR*           ,:S-RS2-STAT-REASON-LONG-DESC                                 
MFA-TR*           ,:S-RS2-DATE-MTR-INSTALL                                      
MFA-TR*           ,:S-RS2-METER-TYPE                                            
MFA-TR*           ,:S-RS2-LAST-VAL-RD-VALUE                                     
MFA-TR*           ,:S-RS2-LAST-VALID-READ-DT                                    
MFA-TR*           ,:S-RS2-METER-NO                                              
MFA-TR*           ,:S-RS2-METER-REF-NO                                          
MFA-TR*           ,:S-RS2-METER-PRESSURE                                        
MFA-TR*           ,:S-RS2-MTR-PRESSRE-LONG-DESC                                 
MFA-TR*           ,:S-RS2-METER-SUPPLYING                                       
MFA-TR*           ,:S-RS2-MTR-READ-SOURCE-CD                                    
MFA-TR*           ,:S-RS2-MTR-RD-SRCE-CD-LNG-DESC                               
MFA-TR*           ,:S-RS2-POINT-ID                                              
MFA-TR*           ,:S-RS2-OPTIMUM-READ-DATE                                     
MFA-TR*           ,:S-RS2-CONSTANT                                              
MFA-TR*           ,:S-RS2-NO-READ-DIALS                                         
MFA-TR*           ,:S-RS2-CODE-METER-LOC                                        
MFA-TR*           ,:S-RS2-METER-LOC-DESC                                        
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R2 = 'Y'             
              ADD +1                     TO  CTR-ROWS-RS2               
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8020'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE 'Y'                   TO  WS-ERR-INSRT-R2            
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04640_R2'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
        8020-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8030-INSERT-GTT-R3.                                            *        
      ******************************************************************        
       8030-INSERT-GTT-R3.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04640_R3                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,CODE_UTIL_TYPE                                       
                  ,IC_NO                                                
                  ,RATE_PLAN_NO                                         
                  ,RATE_ITEM_CODE                                       
                  ,ITEM_SEQ_NO                                          
                  ,CODE_PLAN_STATUS                                     
                  ,CD_PLN_STAT_SHRT_DESC                                
                  ,CD_PLN_STAT_LONG_DESC                                
                  ,CD_PLN_STAT_SORT_ORDR                                
                  ,POLE_NO                                              
                  ,NO_UNITS                                             
                  ,CODE_STAT_REASON                                     
                  ,CD_STAT_RSON_LNG_DESC                                
                  ,DATE_PLAN_START                                      
                  ,REMOVE_DATE                                          
                  ,PRICE_PER_SERV                                       
                  ,TOTAL_PRICE                                          
                  ,EQUIP_SHRT_DESC                                      
                  ,EQUIP_LONG_DESC                                      
                  ,LAST_BILL_DATE                                       
                  ,USAGE_FIXED                                          
                  ,MTHLY_AMOUNT_FIXED                                   
                  ,UM_EQUIP_TYPE_CD                                     
                  ,UM_EQUIP_TYPE_DESC                                   
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-3                                     
                  ,:S-APPL-RETURN-CODE-3                                
                  ,:S-RS3-CODE-UTIL-TYPE                                
                  ,:S-RS3-IC-NO                                         
                  ,:S-RS3-RATE-PLAN-NO                                  
                  ,:S-RS3-RATE-ITEM-CODE                                
                  ,:S-RS3-ITEM-SEQ-NO                                   
                  ,:S-RS3-CODE-PLAN-STATUS                              
                  ,:S-RS3-CD-PLN-STAT-SHRT-DESC                         
                  ,:S-RS3-CD-PLN-STAT-LONG-DESC                         
                  ,:S-RS3-CD-PLN-STAT-SORT-ORDR                         
                  ,:S-RS3-POLE-NO                                       
                  ,:S-RS3-NO-UNITS                                      
                  ,:S-RS3-CODE-STAT-REASON                              
                  ,:S-RS3-CD-STAT-RSON-LNG-DESC                         
                  ,:S-RS3-DATE-PLAN-START                               
                  ,:S-RS3-REMOVE-DATE                                   
                  ,:S-RS3-PRICE-PER-SERV                                
                  ,:S-RS3-TOTAL-PRICE                                   
                  ,:S-RS3-EQUIP-SHRT-DESC                               
                  ,:S-RS3-EQUIP-LONG-DESC                               
                  ,:S-RS3-LAST-BILL-DATE                                
                  ,:S-RS3-USAGE-FIXED                                   
                  ,:S-RS3-MTHLY-AMOUNT-FIXED                            
                  ,:S-RS3-UM-EQUIP-TYPE-CD                              
                  ,:S-RS3-UM-EQUIP-TYPE-DESC                            
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04640_R3                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,CODE_UTIL_TYPE                                               
MFA-TR*           ,IC_NO                                                        
MFA-TR*           ,RATE_PLAN_NO                                                 
MFA-TR*           ,RATE_ITEM_CODE                                               
MFA-TR*           ,ITEM_SEQ_NO                                                  
MFA-TR*           ,CODE_PLAN_STATUS                                             
MFA-TR*           ,CD_PLN_STAT_SHRT_DESC                                        
MFA-TR*           ,CD_PLN_STAT_LONG_DESC                                        
MFA-TR*           ,CD_PLN_STAT_SORT_ORDR                                        
MFA-TR*           ,POLE_NO                                                      
MFA-TR*           ,NO_UNITS                                                     
MFA-TR*           ,CODE_STAT_REASON                                             
MFA-TR*           ,CD_STAT_RSON_LNG_DESC                                        
MFA-TR*           ,DATE_PLAN_START                                              
MFA-TR*           ,REMOVE_DATE                                                  
MFA-TR*           ,PRICE_PER_SERV                                               
MFA-TR*           ,TOTAL_PRICE                                                  
MFA-TR*           ,EQUIP_SHRT_DESC                                              
MFA-TR*           ,EQUIP_LONG_DESC                                              
MFA-TR*           ,LAST_BILL_DATE                                               
MFA-TR*           ,USAGE_FIXED                                                  
MFA-TR*           ,MTHLY_AMOUNT_FIXED                                           
MFA-TR*           ,UM_EQUIP_TYPE_CD                                             
MFA-TR*           ,UM_EQUIP_TYPE_DESC                                           
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-3                                             
MFA-TR*           ,:S-APPL-RETURN-CODE-3                                        
MFA-TR*           ,:S-RS3-CODE-UTIL-TYPE                                        
MFA-TR*           ,:S-RS3-IC-NO                                                 
MFA-TR*           ,:S-RS3-RATE-PLAN-NO                                          
MFA-TR*           ,:S-RS3-RATE-ITEM-CODE                                        
MFA-TR*           ,:S-RS3-ITEM-SEQ-NO                                           
MFA-TR*           ,:S-RS3-CODE-PLAN-STATUS                                      
MFA-TR*           ,:S-RS3-CD-PLN-STAT-SHRT-DESC                                 
MFA-TR*           ,:S-RS3-CD-PLN-STAT-LONG-DESC                                 
MFA-TR*           ,:S-RS3-CD-PLN-STAT-SORT-ORDR                                 
MFA-TR*           ,:S-RS3-POLE-NO                                               
MFA-TR*           ,:S-RS3-NO-UNITS                                              
MFA-TR*           ,:S-RS3-CODE-STAT-REASON                                      
MFA-TR*           ,:S-RS3-CD-STAT-RSON-LNG-DESC                                 
MFA-TR*           ,:S-RS3-DATE-PLAN-START                                       
MFA-TR*           ,:S-RS3-REMOVE-DATE                                           
MFA-TR*           ,:S-RS3-PRICE-PER-SERV                                        
MFA-TR*           ,:S-RS3-TOTAL-PRICE                                           
MFA-TR*           ,:S-RS3-EQUIP-SHRT-DESC                                       
MFA-TR*           ,:S-RS3-EQUIP-LONG-DESC                                       
MFA-TR*           ,:S-RS3-LAST-BILL-DATE                                        
MFA-TR*           ,:S-RS3-USAGE-FIXED                                           
MFA-TR*           ,:S-RS3-MTHLY-AMOUNT-FIXED                                    
MFA-TR*           ,:S-RS3-UM-EQUIP-TYPE-CD                                      
MFA-TR*           ,:S-RS3-UM-EQUIP-TYPE-DESC                                    
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R3 = 'Y'             
              ADD +1                     TO  CTR-ROWS-RS3               
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8030'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE 'Y'                   TO  WS-ERR-INSRT-R3            
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04640_R3'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
        8030-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8040-INSERT-GTT-R4.                                            *        
      ******************************************************************        
       8040-INSERT-GTT-R4.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04640_R4                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,BUS_RULE_ID                                          
                  ,BUS_RULE_RESULT_CD                                   
                  ,BUS_RULE_XREF_ID                                     
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-4                                     
                  ,:S-APPL-RETURN-CODE-4                                
                  ,:S-RS4-BUS-RULE-ID                                   
                  ,:S-RS4-BUS-RULE-RESULT-CD                            
                  ,:S-RS4-BUS-RULE-XREF-ID                              
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04640_R4                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,BUS_RULE_ID                                                  
MFA-TR*           ,BUS_RULE_RESULT_CD                                           
MFA-TR*           ,BUS_RULE_XREF_ID                                             
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-4                                             
MFA-TR*           ,:S-APPL-RETURN-CODE-4                                        
MFA-TR*           ,:S-RS4-BUS-RULE-ID                                           
MFA-TR*           ,:S-RS4-BUS-RULE-RESULT-CD                                    
MFA-TR*           ,:S-RS4-BUS-RULE-XREF-ID                                      
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-4.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R4 = 'Y'             
              ADD +1                     TO  CTR-ROWS-RS4               
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8040'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE 'Y'                   TO  WS-ERR-INSRT-R4            
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04640_R4'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
        8040-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8800-CHECK-RESULTS.                                           *         
      *****************************************************************         
       8800-CHECK-RESULTS.                                              
                                                                        
           IF CTR-ROWS-RS1 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-1                            
              MOVE   0                       TO S-RETURN-CODE-1         
              MOVE 100                       TO S-APPL-RETURN-CODE-1    
              PERFORM 8010-INSERT-GTT-R1     THRU 8010-EXIT             
           END-IF.                                                      
      *                                                                         
           IF CTR-ROWS-RS2 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-2                            
              MOVE   0                       TO S-RETURN-CODE-2         
              MOVE 100                       TO S-APPL-RETURN-CODE-2    
              PERFORM 8020-INSERT-GTT-R2     THRU 8020-EXIT             
           END-IF.                                                      
      *                                                                         
           IF CTR-ROWS-RS3 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-3                            
              MOVE   0                       TO S-RETURN-CODE-3         
              MOVE 100                       TO S-APPL-RETURN-CODE-3    
              PERFORM 8030-INSERT-GTT-R3     THRU 8030-EXIT             
           END-IF.                                                      
      *                                                                         
           IF CTR-ROWS-RS4 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-4                            
              MOVE   0                       TO S-RETURN-CODE-4         
              MOVE 100                       TO S-APPL-RETURN-CODE-4    
              PERFORM 8040-INSERT-GTT-R4     THRU 8040-EXIT             
           END-IF.                                                      
      *                                                                         
       8800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8900-SEND-DONE.                                                *        
      ******************************************************************        
       8900-SEND-DONE.                                                  
                                                                        
           MOVE PROGRAM-NAME          TO ABEND-PROGRAM                  
           MOVE '8900'                TO ACTIVE-PARAGRAPH               
           MOVE 'OPEN'                TO ABEND-FUNCTION                 
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE 'CSR04640_R1'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C2                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE 'CSR04640_R2'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C3                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C3 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE 'CSR04640_R3'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C4                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C4 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-4.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE 'CSR04640_R4'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 9000-SEND-ERROR-RESULT                                         *        
      ******************************************************************        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE       TO ABEND-SQLCODE            
                                               S-RETURN-CODE-1          
                                               S-RETURN-CODE-2          
                                               S-RETURN-CODE-3          
                                               S-RETURN-CODE-4.         
                                                                        
           MOVE WS-APPL-RETURN-CODE         TO S-APPL-RETURN-CODE-1     
                                               S-APPL-RETURN-CODE-2     
                                               S-APPL-RETURN-CODE-3     
                                               S-APPL-RETURN-CODE-4.    
                                                                        
                                                                        
           MOVE SQLERRMC                    TO ABEND-SQLERRMC.          
                                                                        
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'               TO ABEND-FUNCTION           
           END-IF.                                                      
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1        THRU 0100A-EXIT.         
           PERFORM 0100B-DECLARE-GTT-R2        THRU 0100B-EXIT.         
           PERFORM 0100C-DECLARE-GTT-R3        THRU 0100C-EXIT.         
           PERFORM 0100D-DECLARE-GTT-R4        THRU 0100D-EXIT.         
                                                                        
           PERFORM 8010-INSERT-GTT-R1          THRU 8010-EXIT.          
           PERFORM 8020-INSERT-GTT-R2          THRU 8020-EXIT.          
           PERFORM 8030-INSERT-GTT-R3          THRU 8030-EXIT.          
           PERFORM 8040-INSERT-GTT-R4          THRU 8040-EXIT.          
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9700-ABEND-PROCESSING.                                         *        
      ******************************************************************        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT.             
           PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT.             
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900-SQL-ERROR-ROUTINE.                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9999-END-PROGRAM.                                              *        
      ******************************************************************        
                                                                        
       9999-END-PROGRAM.                                                
                                                                        
            PERFORM 8800-CHECK-RESULTS THRU 8800-EXIT                   
            PERFORM 8900-SEND-DONE     THRU 8900-EXIT                   
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
