       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       CSR04638.                                      
COB303 DATE-WRITTEN.     MAY 30, 2013.                                  
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE:  CSR04638              --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--                                                            --         
      *--  CSR04638 :                                                --         
      *--                                                            --         
      *--     RETRIEVE BILLING INFO USED IN BILL ANALYSIS PANEL.     --         
      *--                                                            --         
      *--       CSS_BUS_RULE                                         --         
      *--       CSS_BUS_RULE_XREF                                    --         
      *--       CSS_BUS_RULE_ACTN                                    --         
      *--       CSS_BUS_RULE_MSG                                     --         
      *--       CSS_RULE_ACTN_LINK                                   --         
      *--       CSS_BUS_RULE_LINK                                    --         
      *--       CSS_UI_RUL_ACTN_XR                                   --         
      *--                                                            --         
      *--  # APPL-RETURN-CODE.                                       --         
      *--   +1000 - INPUT IS INVALID                                 --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *--  PARAMETERS                                                --         
      *--                                                            --         
      *--      INPUT                                                 --         
      *--             ACCOUNT_NO          DECIMAL(13)                --         
      *--             UTIL_TYPE           CHAR(01)                   --         
      *--             APPL_PROG_ID        CHAR(03)                   --         
      *--                                                            --         
      *--      OUT                                                   --         
      *--                                                            --         
      *--            NONE                                            --         
      *--                                                            --         
      *--      INOUT                                                 --         
      *--                                                            --         
      *--            NONE                                            --         
      *--                                                            --         
      *--  RESULT SET                                                --         
      *--    1. CSR04638_R1 - HEADER DETAILS                         --         
      *--    2. CSR04638_R2 - BILLING DETAIL INFO                    --         
      *--    3. CSR04638_R3 - BILL MONTH GUIDANCE                    --         
      *--    3. CSR04638_R4 - AGL FACTOR DETAILS                     --         
      *--    3. CSR04638_R5 - WEATHER SERVICE DIVISION               --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                        MODIFICATION LOG                    --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
      *--  05/30/2013    HA7A338     RETRIEVE BILLING INFO           --         
      *--                                                            --         
      *--  12/31/2013    AD7F921     ADDITIONAL CHANGES: ADDED       --         
      *--                            ADDITIONAL CHECK IN TWO PART    --         
      *--                            RATE.                           --         
P00836*--  10/21/2015    HA7A338     CHANGE 7200- SQL TO FETCH MULT  --         
P00836*--                            REBILL ROWS FOR SAME BILL NO.   --         
I02104*--  04/28/2016    JC91900     Exclude customer generation     --         
I02104*--                            rates from bill compare.        --         
A05460*--  08/02/2016    SM93554     REMOVED UNUSED DCLGEN.          --         
A05470*--  08/31/2016    MS7M727     EXCLUDE ROWS FOR                --         
A05470*--                ACT046      RATE_SUB_GRP_TYPE WHEN 'A'      --         
ACT384*--  09/12/2016    VIJAY       REMOVED UNUSED DCLGENS.         --         
ACT384*--  A05460                    TBCNSMPT, TBZIPUSE              --         
A05470*--  12/02/2016    MS7M727     SET WS-SOLAR-RATE-FLG IS 'Y' WHEN--        
A05470*--                ACT056      RATE_SUB_GRP_TYPE IS 'A'        --         
      *----------------------------------------------------------------         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04638'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-START                   PIC X(40) VALUE                    
            'WORKING STORAGE FOR CSR04638 STARTS HERE'.                 
      *                                                                         
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-SUBROUTINE-IDS.                                       
               10  CSRERLOG          PIC X(8)  VALUE 'CSRERLOG'.        
           05  PROGRAM-NAME          PIC X(08) VALUE 'CSR04638'.        
           05  WS-PGRMNAME           PIC X(08) VALUE 'CSR04638'.        
           05  WS-YES                PIC X(01) VALUE 'Y'.               
           05  WS-NO                 PIC X(01) VALUE 'N'.               
           05  WS-PSNC               PIC X(02) VALUE '26'.              
           05  WS-CIG                PIC X(02) VALUE '01'.              
           05  WS-RESIDENTIAL        PIC X(01) VALUE 'R'.               
           05  WS-MULT-MTR-REG-FLG   PIC X(01) VALUE 'N'.               
           05  WS-FIRST-TIME-PROCESS PIC X(01) VALUE 'Y'.               
           05  WS-CSC-ADJ-EXIST      PIC X(01) VALUE 'N'.               
ACT056     05  WS-SOLAR-RATE-FLG     PIC X(01) VALUE 'Y'.               
                                                                        
           05  WS-CODE-BILL-ITM-IND  PIC X(01) VALUE ' '.               
               88 BILL-ACTIVE                  VALUE 'A'.               
               88 BILL-CANCEL                  VALUE 'C'.               
               88 BILL-REBILL                  VALUE 'R'.               
               88 BILL-SUMMARY                 VALUE 'S'.               
               88 BILL-TRANSFER                VALUE 'T'.               
               88 BILL-UNKNOWN                 VALUE 'U'.               
                                                                        
       01  WS-RATE-DESC-TABLE.                                          
           05 WS-RATE-DESC-DATA OCCURS 75 TIMES                         
                                INDEXED BY WS-RATE-INDX.                
              10 WS-RATE-PLAN-NO        PIC X(03).                      
              10 WS-UTIL-TYPE-CODE      PIC X(01).                      
              10 WS-RATE-DESC           PIC X(50).                      
              10 WS-RATE-DEF-CD         PIC X(01).                      
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN            PIC S9(9) COMP VALUE 1.            
           05  CTR-ROWS-RS1          PIC S9(9) VALUE 0 COMP.            
           05  CTR-ROWS-RS2          PIC S9(9) VALUE 0 COMP.            
           05  CTR-ROWS-RS3          PIC S9(9) VALUE 0 COMP.            
           05  CTR-ROWS-RS4          PIC S9(9) VALUE 0 COMP.            
           05  CTR-ROWS-RS5          PIC S9(9) VALUE 0 COMP.            
                                                                        
       01  WS-MISC.                                                     
           05  WS-SQLSTATE           PIC X(05) VALUE SPACES.            
           05  WS-GTT-NAME           PIC X(19) VALUE SPACES.            
           05  WS-APPL-RETURN-CODE   PIC S9(4) VALUE 0.                 
           05  WS-APPL-ID            PIC X(03) VALUE SPACES.            
           05  WS-HOLD-REV-MM        PIC S9(6) VALUE 0.                 
           05  WS-DATE-BILLED        PIC X(10) VALUE SPACES.            
           05  WS-DATE-ORIG-BILL     PIC X(10) VALUE SPACES.            
           05  WS-WEATHER-SRVC-DIV   PIC X(01) VALUE SPACES.            
           05  WS-HDR-REBIL-R-NRML-BIL                                  
                                     PIC X(01) VALUE SPACES.            
           05  WS-NULL-CHRG          PIC S9(4) VALUE 0 COMP.            
           05  WS-NULL-PRICE         PIC S9(4) VALUE 0 COMP.            
           05  WS-NULL-IND-1         PIC S9(4) VALUE 0 COMP.            
           05  WS-NULL-IND-2         PIC S9(4) VALUE 0 COMP.            
           05  WS-NULL-IND-3         PIC S9(4) VALUE 0 COMP.            
           05  WS-NULL-IND-4         PIC S9(4) VALUE 0 COMP.            
           05  WS-NULL-IND-5         PIC S9(4) VALUE 0 COMP.            
           05  WS-NULL-IND-6         PIC S9(4) VALUE 0 COMP.            
           05  WS-NULL-IND-7         PIC S9(4) VALUE 0 COMP.            
           05  WS-NULL-IND-8         PIC S9(4) VALUE 0 COMP.            
           05  WS-ACCOUNT-NO         PIC S9(13)V                        
                                               VALUE 0 COMP-3.          
           05  WS-COMPANY-NO         PIC X(02) VALUE SPACES.            
           05  WS-PREV-RT-PKG-SEQ-NO PIC S9(4) USAGE COMP VALUE 0.      
           05  WS-INDX-COUNT         PIC S9(4) USAGE COMP VALUE 0.      
COB305     05 WS-REVENUE-MONTH        PIC S9(6) COMP-3 VALUE 0.                 
           05  WS-BILL-NO            PIC S9(9) VALUE 0 COMP.            
P00836     05  WS-PREV-BILL-NO       PIC S9(9) VALUE 0 COMP.            
           05  WS-BILL-ITEM-TIMESTMP PIC X(26) VALUE SPACES.            
P00836     05  WS-TEMP-TS            PIC X(26) VALUE SPACES.            
           05  WS-NO-OF-CONS-DAYS    PIC S9(4) VALUE 0 COMP.            
           05  WS-BLOCKS-COUNT       PIC S9(9) VALUE 0 COMP.            
           05  WS-CODE-UTIL-TYPE     PIC X(01) VALUE SPACES.            
           05  WS-IC-NO              PIC S9(4) VALUE 0 COMP.            
           05  WS-NO-UNITS           PIC S9(9) VALUE 0 COMP-3.          
           05  WS-CODE-USAGE-TYPE    PIC X(01) VALUE SPACES.            
           05  WS-UNMTRD-ELEC-GAS    PIC X(01) VALUE SPACES.            
           05  WS-REG-TYPE-CD        PIC X(01) VALUE SPACES.            
           05  WS-RATE-DFNTN-CD      PIC X(01) VALUE SPACES.            
           05  WS-METER-NO           PIC X(09) VALUE SPACES.            
           05  WS-CODE-MTR-READ      PIC X(01) VALUE SPACES.            
           05  WS-FACTOR-VAL-EXIST   PIC X(01) VALUE SPACES.            
           05  WS-GET-FACTOR-TYPE    PIC X(01) VALUE SPACES.            
           05  WS-FACTOR-ONLY        PIC X(01) VALUE 'F'   .            
           05  WS-ADJ-FACTOR-ONLY    PIC X(01) VALUE 'J'   .            
           05  WS-ANY-FACTORS        PIC X(01) VALUE 'A'   .            
           05  WS-METER-READING      PIC S9(11)V                        
                                               VALUE 0 COMP-3.          
           05  WS-DATE-READ          PIC X(10) VALUE SPACES.            
           05  WS-DATE-READ-COMPARE  PIC X(10) VALUE SPACES.            
           05  WS-AMT-BILL-ITEM      PIC S9(9)V99                       
                                               VALUE 0 COMP-3.          
           05  WS-AMT-TAXES          PIC S9(9)V99                       
                                               VALUE 0 COMP-3.          
           05  WS-STATE-TAX-AMT      PIC S9(9)V99                       
                                               VALUE 0 COMP-3.          
           05  WS-CITY-TAX-AMT       PIC S9(9)V99                       
                                               VALUE 0 COMP-3.          
           05  WS-TOT-COST           PIC S9(9)V99                       
                                               VALUE 0 COMP-3.          
           05  WS-ACCUM-NO-UNITS     PIC S9(09)V                        
                                               VALUE 0 COMP-3.          
           05  WS-ACCUM-UNITS-TP     PIC S9(09)V                        
                                               VALUE 0 COMP-3.          
           05  WS-ACCUM-NO-DAYS      PIC S9(5) VALUE 0 COMP.            
           05  WS-ACCUM-NO-KVA       PIC S9(5) VALUE 0 COMP-3.          
           05  WS-MTR-REF-COMP       PIC S9(4) VALUE 0 COMP.            
           05  WS-TP-COMP            PIC S9(4) VALUE 0 COMP.            
           05  WS-REG-ID-COMP        PIC S9(4) VALUE 0 COMP.            
           05  WS-TOTAL-BG-DOLLARS   PIC S9(09)V99                      
                                               VALUE 0.                 
           05  WS-TOT-UTILITY        PIC S9(09)V99                      
                                               VALUE 0 COMP-3.          
           05  WS-WNA-AMOUNT         PIC S9(09)V99                      
                                               VALUE 0 COMP-3.          
           05  WS-FACTOR-ID          PIC X(09) VALUE SPACES.            
           05  WS-FACTOR             PIC S9(09)V9999                    
                                               VALUE 0 COMP-3.          
           05  WS-SUM-FACTOR         PIC S9(09)V9999                    
                                               VALUE 0 COMP-3.          
           05  WS-BFC-CHARGE         PIC S9(09)V9999                    
                                               VALUE 0 COMP-3.          
           05  WS-BFC-CHARGE-DBT     PIC S9(09)V9999                    
                                               VALUE 0 COMP-3.          
           05  WS-BFC-CHARGE-CRD     PIC S9(09)V9999                    
                                               VALUE 0 COMP-3.          
           05  WS-TOTAL-CHARGES-CREDIT                                  
                                     PIC S9(09)V99                      
                                               VALUE 0 COMP-3.          
           05  WS-SPCDDC-CHARGE-RESULT                                  
                                     PIC S9(09)V9999                    
                                               VALUE 0 COMP-3.          
           05  WS-DDC-FACTOR         PIC S9(09)V9999                    
                                               VALUE 0 COMP-3.          
           05  WS-SPCDDC-CHARGE      PIC S9(09)V9999                    
                                               VALUE 0 COMP-3.          
           05  WS-TOT-BILL-USAGE     PIC S9(09)V                        
                                               VALUE 0 COMP-3.          
           05  WS-TOT-READ-USAGE     PIC S9(09)V                        
                                               VALUE 0 COMP-3.          
           05  WS-UNIT-PRICE-AMT     PIC S9(05)V9(6)                    
                                               VALUE 0 COMP-3.          
           05  WS-AVG-COST-PER-USG   PIC S9(05)V9999                    
                                               VALUE 0 COMP-3.          
           05  WS-AVG-COST-PER-DAY   PIC S9(05)V999                     
                                               VALUE 0 COMP-3.          
           05  WS-NO-OF-DAYS         PIC S9(4) VALUE 0 COMP.            
           05  WS-AVG-USG-PER-DAY    PIC S9(09)V99                      
                                               VALUE 0 COMP-3.          
           05  WS-BA01-DSP-VAL       PIC $$$$$$$$$9.99.                 
           05  WS-BA02-DSP-VAL       PIC ZZZZZZZZ9.                     
           05  WS-BA03-DSP-VAL       PIC $$$$$9.999.                    
           05  WS-BA04-DSP-VAL       PIC $$$$$9.999.                    
           05  WS-BA05-DSP-VAL       PIC ZZZ9.                          
           05  WS-BA06-DSP-VAL       PIC ZZZZZZZZ9.99.                  
      *                                                                         
       01  SWITCHES.                                                    
           05 ALL-DONE-SW             PIC X(01) VALUE 'N'.              
              88 NOT-ALL-DONE                   VALUE 'N'.              
              88 ALL-DONE                       VALUE 'Y'.              
           05 SEND-DONE-SW            PIC X(01) VALUE 'Y'.              
              88 SEND-DONE-ERROR                VALUE 'N'.              
              88 SEND-DONE-OK                   VALUE 'Y'.              
           05 END-OF-BI-SW            PIC X(01) VALUE 'N'.              
              88 NO-MORE-HEADER-RECS            VALUE 'Y'.              
           05 END-OF-BG-SW            PIC X(01) VALUE 'N'.              
              88 NO-MORE-DETAIL-RECS            VALUE 'Y'.              
           05 END-OF-FH-SW            PIC X(01) VALUE 'N'.              
              88 NO-MORE-FACTOR-RECS            VALUE 'Y'.              
           05 END-OF-FCTR-VAL-SW      PIC X(01) VALUE 'N'.              
              88 NO-MORE-FCTR-VAL-RCS           VALUE 'Y'.              
           05 WS-INDUST-GAS-CUST      PIC X(01) VALUE 'N'.              
              88 INDUST-GAS-CUST                VALUE 'Y'.              
           05 WS-INDUST-RATE          PIC X(01) VALUE 'N'.              
              88 INDUST-RATE                    VALUE 'Y'.              
           05 WS-DTL-ROW-REBIL-FL     PIC X(01) VALUE 'N'.              
              88 CNCL-NO-REBIL                  VALUE 'Y'.              
              88 CNCL-REBIL-R-NRML-BIL          VALUE 'N'.              
           05 WS-VOLUMETRIC-FACTORS   PIC X(09) VALUE SPACES.           
              88 VOLUMETRIC-FACTORS             VALUE 'AGL VOL',        
                                                      'AGLSMRVOL',      
                                                      'AGLWTRVOL'.      
           05 WS-DATABASE             PIC 9(01) VALUE 0.                
              88 CSR-DATABASE                   VALUE 1.                
              88 SEB-DATABASE                   VALUE 2.                
                                                                        
      ****************************************************************          
      *                                                              *          
      *    ERROR PROCESSING VARIABLES                                *          
      ****************************************************************          
      *                                                                         
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) VALUE 0 COMP.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
                                                                        
       01 GTT-RETURN-FIELDS.                                            
      *********************************************************                 
      *   GTT TABLE LAYOUT FOR BILLING HEADER INFO            *                 
      *********************************************************                 
          05 RS-RETURN-CODE                 PIC S9(04) VALUE 0 COMP.    
          05 GTT-RETURN-FIELDS-1.                                       
             10 S1-RETURN-CODE              PIC S9(09) VALUE 0 COMP.    
             10 S1-APPL-RETURN-CODE         PIC S9(09) VALUE 0 COMP.    
             10 S1-ACCOUNT-NO               PIC S9(13)V VALUE 0 COMP-3. 
             10 S1-BC-BILL-NO               PIC S9(09) VALUE 0 COMP.    
COB305       10 S1-BILLING-MONTH        PIC S9(06) COMP-3 VALUE 0.          
             10 S1-DATE-BILLED              PIC X(10) VALUE SPACES.     
             10 S1-UTILITY-REVENUE          PIC S9(09)V99               
                                                     COMP-3 VALUE 0.    
             10 S1-ARREARS                  PIC S9(09)V99               
                                                     COMP-3 VALUE 0.    
             10 S1-OTHER-CHARGES            PIC S9(09)V99               
                                                     COMP-3 VALUE 0.    
                                                                        
      *********************************************************                 
      *   GTT TABLE LAYOUT FOR BILLING DETAIL INFO            *                 
      *********************************************************                 
          05 GTT-RETURN-FIELDS-2.                                       
             10 S2-RETURN-CODE              PIC S9(09) VALUE 0 COMP.    
             10 S2-APPL-RETURN-CODE         PIC S9(09) VALUE 0 COMP.    
             10 S2-BC-BILL-NO               PIC S9(09) VALUE 0 COMP.    
             10 S2-BILL-NO                  PIC S9(09) VALUE 0 COMP.    
COB305       10 S2-BILLING-MONTH        PIC S9(06) COMP-3 VALUE 0.          
             10 S2-DATE-BILLED              PIC X(10)  VALUE SPACES.    
             10 S2-BILL-ITEM-TIMESTMP       PIC X(26)  VALUE SPACES.    
             10 S2-CODE-UTIL-TYPE           PIC X(01)  VALUE SPACES.    
             10 S2-IC-NO                    PIC S9(4)  VALUE 0 COMP.    
             10 S2-RATE-PLAN-NO             PIC X(03)  VALUE SPACES.    
             10 S2-RATE-DESC                PIC X(50)  VALUE SPACES.    
             10 S2-OPTION-CD                PIC X(12)  VALUE SPACES.    
             10 S2-OPTION-DESC              PIC X(50)  VALUE SPACES.    
             10 S2-OPTION-CALC-TYPE-CD      PIC X(02)  VALUE SPACES.    
             10 S2-TOT-UTILITY              PIC S9(09)V99               
                                                       VALUE 0 COMP-3.  
             10 S2-TOT-USAGE                PIC S9(09)V                 
                                                       VALUE 0 COMP-3.  
             10 S2-WNA-AMOUNT               PIC S9(09)V99               
                                                       VALUE 0 COMP-3.  
             10 S2-AVG-COST-PER-USG         PIC S9(05)V9999             
                                                       VALUE 0 COMP-3.  
             10 S2-AVG-COST-PER-DAY         PIC S9(05)V999              
                                                       VALUE 0 COMP-3.  
             10 S2-NO-OF-DAYS               PIC S9(04) VALUE 0 COMP.    
             10 S2-AVG-USG-PER-DAY          PIC S9(09)V99               
                                                       VALUE 0 COMP-3.  
             10 S2-AGL-CHARGE               PIC S9(09)V9999             
                                                       VALUE 0 COMP-3.  
             10 S2-DATE-READ                PIC X(10)  VALUE SPACES.    
             10 S2-CODE-MTR-READ            PIC X(01)  VALUE SPACES.    
             10 S2-METER-NO                 PIC X(09)  VALUE SPACES.    
             10 S2-METER-READING            PIC S9(11)V                 
                                                       VALUE 0 COMP-3.  
             10 S2-STATE-TAX-AMT            PIC S9(07)V99               
                                                       VALUE 0 COMP-3.  
             10 S2-CITY-TAX-AMT             PIC S9(07)V99               
                                                       VALUE 0 COMP-3.  
             10 S2-UNIT-PRICE-AMT           PIC S9(05)V9(6)             
                                                       VALUE 0 COMP-3.  
             10 S2-CALC-COMP-AMT            PIC S9(09)V99               
                                                       VALUE 0 COMP-3.  
             10 S2-READ-UNITS               PIC S9(09)V                 
                                                       VALUE 0 COMP-3.  
             10 S2-BFC-CHARGE               PIC S9(09)V9999             
                                                       VALUE 0 COMP-3.  
             10 S2-SPC-DDC-CHARGE           PIC S9(09)V9999             
                                                       VALUE 0 COMP-3.  
             10 S2-UNBIL-REBIL-FLG          PIC X(01)  VALUE SPACES.    
             10 S2-DDC-FACTOR               PIC S9(09)V9999             
                                                       VALUE 0 COMP-3.  
             10 S2-2PART-RATE-FLG           PIC X(01)  VALUE SPACES.    
             10 S2-STEP-RATE-FLG            PIC X(01)  VALUE SPACES.    
             10 S2-TOTAL-CHARGES-CREDIT     PIC S9(09)V9999             
                                                       VALUE 0 COMP-3.  
             10 S2-CSC-ADJ-EXIST            PIC X(01)  VALUE SPACES.    
             10 S2-MULT-MTR-REG-FLG         PIC X(01)  VALUE SPACES.    
ACT056       10 S2-SOLAR-RATE-FLG           PIC X(01)  VALUE SPACES.    
                                                                        
      *********************************************************                 
      *   GTT TABLE LAYOUT FOR BILL MONTH GUIDANCE            *                 
      *********************************************************                 
          05 GTT-RETURN-FIELDS-3.                                       
             10 S3-RETURN-CODE              PIC S9(09) VALUE 0 COMP.    
             10 S3-APPL-RETURN-CODE         PIC S9(09) VALUE 0 COMP.    
COB305       10 S3-BILLING-MONTH        PIC S9(06) COMP-3 VALUE 0.          
             10 S3-DATE-BILLED              PIC X(10)  VALUE SPACES.    
             10 S3-CODE-UTIL-TYPE           PIC X(01)  VALUE SPACES.    
             10 S3-IC-NO                    PIC S9(4)  VALUE 0 COMP.    
             10 S3-RULE-ID                  PIC X(10)  VALUE SPACES.    
             10 S3-RULE-RESULT-CD           PIC X(08)  VALUE SPACES.    
             10 S3-BUS-RULE-XREF-ID         PIC X(26)  VALUE SPACES.    
             10 S3-MESSAGE-PARMS            PIC X(55)  VALUE SPACES.    
             10 S3-LINK-PARMS               PIC X(10)  VALUE SPACES.    
                                                                        
      *********************************************************                 
      *   GTT TABLE LAYOUT FOR BILLING DETAIL FACTORS         *                 
      *********************************************************                 
          05 GTT-RETURN-FIELDS-4.                                       
             10 S4-RETURN-CODE              PIC S9(09) VALUE 0 COMP.    
             10 S4-APPL-RETURN-CODE         PIC S9(09) VALUE 0 COMP.    
             10 S4-BILL-NO                  PIC S9(09) VALUE 0 COMP.    
             10 S4-DATE-BILLED              PIC X(10)  VALUE SPACES.    
COB305       10 S4-BILLING-MONTH        PIC S9(06) COMP-3 VALUE 0.          
             10 S4-BILL-ITEM-TIMESTMP       PIC X(26)  VALUE SPACES.    
             10 S4-CODE-UTIL-TYPE           PIC X(01)  VALUE SPACES.    
             10 S4-IC-NO                    PIC S9(4)  VALUE 0 COMP.    
             10 S4-FACTOR-ID                PIC X(12)  VALUE SPACES.    
             10 S4-CODE-DEBIT-CREDIT        PIC X(01)  VALUE SPACES.    
             10 S4-FACTOR                   PIC S9(09)V9999             
                                                       VALUE 0 COMP-3.  
                                                                        
      *********************************************************                 
      *   GTT TABLE LAYOUT FOR WEATHER SERVICE DIVISION       *                 
      *********************************************************                 
          05 GTT-RETURN-FIELDS-5.                                       
             10 S5-RETURN-CODE              PIC S9(09) VALUE 0 COMP.    
             10 S5-APPL-RETURN-CODE         PIC S9(09) VALUE 0 COMP.    
             10 S5-WEATHER-SRVC-DIV         PIC X(01)  VALUE SPACES.    
                                                                        
      ******************************************************************        
      *               COBOL WORKING STORAGE COPY BOOKS                 *        
      ******************************************************************        
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_MTR_RD_SOURCE  (X7)                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRDSRCE                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_BUS_RULE       (1R)                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBBUSRUL                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_BUS_RULE_XREF  (1T)                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRULXRF                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_BUS_RULE_ACTN  (1S)                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRULACT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_BUS_RULE_MSG   (1X)                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRULMSG                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_RULE_ACTN_LINK (2X)                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRULACN                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_BUS_RULE_LINK  (2W)                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRULLNK                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_UI_RUL_ACTN_XR (1U)                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBUIRULX                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_LOCAL_OFFICE B1                                         *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBLOCOFC                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_UI_RUL_ACTN_XR (1U)                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRDWNDW                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBBLLHDR                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBBLLDET                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBBLACXF                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBPREM                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBCNSMP                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBBGTHST                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBFXHST                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSPLFTR                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBARHIST                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBADRFMT                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBNAME                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBNMACTX                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBBLCLDT                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBUMCNSM                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBRTDESC                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBCSTPLN                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBRTCDEF                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBOFFCYL                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBRTCRTR                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBPRCSCH                                                  
           END-EXEC.                                                            
      *                                                                         
      * CSS_MTRD_ENVRNMT ,   MN                                                 
           EXEC SQL                                                             
              INCLUDE TBMTRENV                                                  
           END-EXEC.                                                            
      * CRM_RT_PKG_OPTION,   FI                                                 
           EXEC SQL                                                             
               INCLUDE TBRTPKGO                                                 
           END-EXEC.                                                            
                                                                        
      * CSS_ACCT_RTPK_AGR,   DF                                                 
           EXEC SQL                                                             
               INCLUDE TBACCTRG                                                 
           END-EXEC.                                                            
                                                                        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE FIOJC01                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      ******************************************************************        
      *   WORKING STORAGE AREA FOR READING GUIDANCE RESULT SET         *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE  CWS00831                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  ERROR HANDLING                                                *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    SUPPORTS DB2 AND SQL ERROR CHECKING                         *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      **  THE FOLLOWING DECLARES THE CURSOR FOR RETRIEVING A SET OF   **        
      **  ROWS FROM THE CSS_BILLING_HDR TABLE FOR A GIVEN ACCOUNT     **        
      **  NUMBER.                                                     **        
      ******************************************************************        
           EXEC SQL                                                     
               DECLARE BI-CURSOR CURSOR FOR                             
                   SELECT BILL_NO                                       
                         ,DATE_BILLED                                   
                         ,CODE_BILL_TYPE                                
                         ,CODE_BILL_STATUS                              
                         ,TOT_OTHER_CHARGES                             
                         ,TOTAL_ARREARS                                 
                         ,COMPANY_NO                                    
                   FROM   CSS_BILLING_HDR WITH(READUNCOMMITTED)                 
                   WHERE  ACCOUNT_NO  =  :BI-ACCOUNT-NO                 
      *              AND  DATE_BILLED IS NOT NULL                               
                   ORDER BY BILL_NO DESC                                
                   FOR READ ONLY                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE BI-CURSOR CURSOR FOR                                     
MFA-TR*            SELECT BILL_NO                                               
MFA-TR*                  ,DATE_BILLED                                           
MFA-TR*                  ,CODE_BILL_TYPE                                        
MFA-TR*                  ,CODE_BILL_STATUS                                      
MFA-TR*                  ,TOT_OTHER_CHARGES                                     
MFA-TR*                  ,TOTAL_ARREARS                                         
MFA-TR*                  ,COMPANY_NO                                            
MFA-TR*            FROM   CSS_BILLING_HDR                                       
MFA-TR*            WHERE  ACCOUNT_NO  =  :BI-ACCOUNT-NO                         
MFA-TR*              AND  DATE_BILLED IS NOT NULL                               
MFA-TR*            ORDER BY BILL_NO DESC                                        
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*            QUERYNO 7000                                                 
MFA-TR*    END-EXEC.                                                            
HPCCDM*EJECT                                                                    
      ******************************************************************        
      **  THE FOLLOWING DECLARES THE CURSOR FOR RETRIEVING A SET OF   **        
      **  ROWS FROM THE CSS_BILLING_DET TABLE WHERE THE ACCOUNT       **        
      **  NUMBER AND BILL NUMBER ARE EQUAL TO THE ACCOUNT NUMBER AND  **        
      **  BILL NUMBER ON THE CURRENT CSS_BILLING_HDR ROW.             **        
      ******************************************************************        
           EXEC SQL                                                     
               DECLARE BG-CURSOR CURSOR FOR                             
ACT046             SELECT BG.CODE_UTIL_TYPE                             
ACT046                   ,BG.IC_NO                                      
ACT046                   ,BG.AMT_BILL_ITEM                              
ACT046                   ,BG.AMT_STATE_TAX                              
ACT046                   ,BG.AMT_CITY_TAX                               
ACT046                   ,BG.AMT_OTHER_TAX                              
ACT046                   ,BG.CODE_REVENUE_CLASS                         
ACT046                   ,BG.CODE_BILL_CALC                             
ACT046                   ,BG.CODE_BILL_ITM_IND                          
ACT046                   ,BG.CODE_BILL_ITM_TYPE                         
ACT046                   ,BG.CODE_DR_CR_CNSMPTN                         
ACT046                   ,BG.RATE_PLAN_NO                               
ACT046                   ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           BG.BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP                         
ACT046                   ,BG.REVENUE_MONTH                              
ACT046                   ,BG.DATE_ORIG_BILL                             
ACT046                   ,BG.WNA_FACTOR                                 
ACT046                   ,BG.BTU_FACTOR                                 
ACT046                   ,BG.ACCOUNT_NO                                 
ACT046                   ,BG.BILL_NO                                    
ACT046                   ,BG.NO_OF_CONS_DAYS                            
ACT046                   ,BG.PRORATE_CD                                 
ACT046                   ,BG.RT_PKG_OPT_SEQ_NO                          
ACT046                   ,BG.REV_MTH_ORIG_BILL                          
ACT046                   ,BG.GAS_BASE_USE                               
ACT056                   ,RD.RATE_SUB_GRP_TYPE                          
ACT046               FROM CSS_BILLING_DET BG WITH(READUNCOMMITTED),             
ACT046                    CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED)           
ACT046              WHERE BG.ACCOUNT_NO          = :BG-ACCOUNT-NO       
ACT046                AND BG.BILL_NO             = :BI-BILL-NO          
ACT046                AND BG.CODE_BILL_CALC      <> 'S'                 
ACT046                AND BG.CODE_BILL_ITM_TYPE  <> 'B'                 
ACT046                AND BG.CODE_UTIL_TYPE      <> 'U'                 
ACT046                AND BG.COMPANY_NO         = RD.COMPANY_NO         
ACT046                AND BG.CODE_UTIL_TYPE     = RD.CODE_UTIL_TYPE     
ACT046                AND BG.RATE_PLAN_NO       = RD.RATE_PLAN_NO       
ACT046                AND RD.RATE_SUB_GRP_TYPE  NOT IN ('B','D')        
ACT046              ORDER BY BG.ACCOUNT_NO         ASC                  
ACT046                      ,BG.BILL_NO            DESC                 
ACT046                      ,BG.CODE_UTIL_TYPE     ASC                  
ACT046                      ,BG.IC_NO              ASC                  
ACT046                      ,BG.DATE_ORIG_BILL     ASC                  
ACT046                      ,BILL_ITEM_TIMESTMP ASC                  
                    FOR READ ONLY                               
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE BG-CURSOR CURSOR FOR                                     
MFA-TR*            SELECT BG.CODE_UTIL_TYPE                                     
MFA-TR*                  ,BG.IC_NO                                              
MFA-TR*                  ,BG.AMT_BILL_ITEM                                      
MFA-TR*                  ,BG.AMT_STATE_TAX                                      
MFA-TR*                  ,BG.AMT_CITY_TAX                                       
MFA-TR*                  ,BG.AMT_OTHER_TAX                                      
MFA-TR*                  ,BG.CODE_REVENUE_CLASS                                 
MFA-TR*                  ,BG.CODE_BILL_CALC                                     
MFA-TR*                  ,BG.CODE_BILL_ITM_IND                                  
MFA-TR*                  ,BG.CODE_BILL_ITM_TYPE                                 
MFA-TR*                  ,BG.CODE_DR_CR_CNSMPTN                                 
MFA-TR*                  ,BG.RATE_PLAN_NO                                       
MFA-TR*                  ,BG.BILL_ITEM_TIMESTMP                                 
MFA-TR*                  ,BG.REVENUE_MONTH                                      
MFA-TR*                  ,BG.DATE_ORIG_BILL                                     
MFA-TR*                  ,BG.WNA_FACTOR                                         
MFA-TR*                  ,BG.BTU_FACTOR                                         
MFA-TR*                  ,BG.ACCOUNT_NO                                         
MFA-TR*                  ,BG.BILL_NO                                            
MFA-TR*                  ,BG.NO_OF_CONS_DAYS                                    
MFA-TR*                  ,BG.PRORATE_CD                                         
MFA-TR*                  ,BG.RT_PKG_OPT_SEQ_NO                                  
MFA-TR*                  ,BG.REV_MTH_ORIG_BILL                                  
MFA-TR*                  ,BG.GAS_BASE_USE                                       
MFA-TR*                  ,RD.RATE_SUB_GRP_TYPE                                  
MFA-TR*              FROM CSS_BILLING_DET BG,                                   
MFA-TR*                   CSS_RATE_PLAN_DESC RD                                 
MFA-TR*             WHERE BG.ACCOUNT_NO          = :BG-ACCOUNT-NO               
MFA-TR*               AND BG.BILL_NO             = :BI-BILL-NO                  
MFA-TR*               AND BG.CODE_BILL_CALC      <> 'S'                         
MFA-TR*               AND BG.CODE_BILL_ITM_TYPE  <> 'B'                         
MFA-TR*               AND BG.CODE_UTIL_TYPE      <> 'U'                         
MFA-TR*               AND BG.COMPANY_NO         = RD.COMPANY_NO                 
MFA-TR*               AND BG.CODE_UTIL_TYPE     = RD.CODE_UTIL_TYPE             
MFA-TR*               AND BG.RATE_PLAN_NO       = RD.RATE_PLAN_NO               
MFA-TR*               AND RD.RATE_SUB_GRP_TYPE  NOT IN ('B','D')                
MFA-TR*             ORDER BY BG.ACCOUNT_NO         ASC                          
MFA-TR*                     ,BG.BILL_NO            DESC                         
MFA-TR*                     ,BG.CODE_UTIL_TYPE     ASC                          
MFA-TR*                     ,BG.IC_NO              ASC                          
MFA-TR*                     ,BG.DATE_ORIG_BILL     ASC                          
MFA-TR*                     ,BG.BILL_ITEM_TIMESTMP ASC                          
MFA-TR*             FOR FETCH ONLY WITH UR                                      
MFA-TR*             QUERYNO 7100                                                
MFA-TR*    END-EXEC.                                                            
HPCCDM*EJECT                                                                    
                                                                        
      ************************************************************              
      * THE FOLLOWING DECLARES THE CURSOR FOR RETRIEVING A SET OF*              
      * ROWS FROM THE CSS_CNSMPTN_HIST TABLE.                    *              
      ************************************************************              
      *                                                                         
            EXEC SQL                                                    
                DECLARE CX-CURSOR CURSOR FOR                            
                   SELECT CODE_USAGE_TYPE                               
                         ,METER_NO                                      
                         ,DATE_READ                                     
                         ,NO_UNITS                                      
                         ,NO_DEMAND_UNITS                               
                         ,NO_DAYS                                       
                         ,CODE_SOURCE_ID                                
                         ,CODE_DEBIT_CREDIT                             
                         ,MTR_REF_NO                                    
                         ,REG_ID_NO                                     
                         ,CODE_TOU_SEASN                                
                         ,CODE_TIME_PERIOD                              
                         ,CODE_ITEM_STATUS                              
                         ,CODE_METER_READ                               
                         ,ACCOUNT_NO                                    
                         ,METER_READING                                 
                   FROM   CSS_CNSMPTN_HIST WITH(READUNCOMMITTED)                
                   WHERE  ACCOUNT_NO         = :CX-ACCOUNT-NO           
                   AND    CODE_UTIL_TYPE     = :CX-CODE-UTIL-TYPE       
                   AND    BILL_NO            = :CX-BILL-NO              
                   AND    IC_NO              = :CX-IC-NO                
                   AND    BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :CX-BILL-ITEM-TIMESTMP
              )   
                   AND    CODE_ITEM_STATUS IN ( 'A' , 'T')              
                   ORDER BY DATE_READ DESC                              
                           ,CODE_USAGE_TYPE ASC                         
                   FOR READ ONLY                                
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DECLARE CX-CURSOR CURSOR FOR                                    
MFA-TR*            SELECT CODE_USAGE_TYPE                                       
MFA-TR*                  ,METER_NO                                              
MFA-TR*                  ,DATE_READ                                             
MFA-TR*                  ,NO_UNITS                                              
MFA-TR*                  ,NO_DEMAND_UNITS                                       
MFA-TR*                  ,NO_DAYS                                               
MFA-TR*                  ,CODE_SOURCE_ID                                        
MFA-TR*                  ,CODE_DEBIT_CREDIT                                     
MFA-TR*                  ,MTR_REF_NO                                            
MFA-TR*                  ,REG_ID_NO                                             
MFA-TR*                  ,CODE_TOU_SEASN                                        
MFA-TR*                  ,CODE_TIME_PERIOD                                      
MFA-TR*                  ,CODE_ITEM_STATUS                                      
MFA-TR*                  ,CODE_METER_READ                                       
MFA-TR*                  ,ACCOUNT_NO                                            
MFA-TR*                  ,METER_READING                                         
MFA-TR*            FROM   CSS_CNSMPTN_HIST                                      
MFA-TR*            WHERE  ACCOUNT_NO         = :CX-ACCOUNT-NO                   
MFA-TR*            AND    CODE_UTIL_TYPE     = :CX-CODE-UTIL-TYPE               
MFA-TR*            AND    BILL_NO            = :CX-BILL-NO                      
MFA-TR*            AND    IC_NO              = :CX-IC-NO                        
MFA-TR*            AND    BILL_ITEM_TIMESTMP = :CX-BILL-ITEM-TIMESTMP           
MFA-TR*            AND    CODE_ITEM_STATUS IN ( 'A' , 'T')                      
MFA-TR*            ORDER BY DATE_READ DESC                                      
MFA-TR*                    ,CODE_USAGE_TYPE ASC                                 
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*            QUERYNO 7800                                                 
MFA-TR*     END-EXEC.                                                           
      *                                                                         
      ******************************************************************        
      ****THE FOLLOWING DECLARES THE CURSOR FOR RETRIEVING A SET OF   **        
      **** ROWS FROM THE CSS_BILL_CALC_DET.                           **        
      ******************************************************************        
           EXEC SQL                                                     
              DECLARE BZ-CURSOR CURSOR FOR                              
              SELECT  BILL_UNITS                                        
                     ,READ_UNITS                                        
                     ,BILLED_COMP_AM                                    
                     ,CONSUMPT_TYPE_CD                                  
                     ,CMPNT_ID_CD                                       
                     ,CALC_COMP_AM                                      
                     ,UNIT_PRICE_AM                                     
                     ,WNA_COMP_AM                                       
                     ,INSTR_USE_TYPE_CD                                 
                FROM  CSS_BILL_CALC_DET WITH(READUNCOMMITTED)                   
               WHERE  ACCOUNT_NO         = :BZ-ACCOUNT-NO               
                 AND  CODE_UTIL_TYPE     = :BZ-CODE-UTIL-TYPE           
                 AND  BILL_NO            = :BZ-BILL-NO                  
                 AND  IC_NO              = :BZ-IC-NO                    
                 AND  BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :BZ-BILL-ITEM-TIMESTMP
              )       
                 AND  CMPNT_ID_CD NOT IN ('92','93')                    
              ORDER BY CONSUMPT_TYPE_CD ASC                             
              FOR READ ONLY                                     
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE BZ-CURSOR CURSOR FOR                                      
MFA-TR*       SELECT  BILL_UNITS                                                
MFA-TR*              ,READ_UNITS                                                
MFA-TR*              ,BILLED_COMP_AM                                            
MFA-TR*              ,CONSUMPT_TYPE_CD                                          
MFA-TR*              ,CMPNT_ID_CD                                               
MFA-TR*              ,CALC_COMP_AM                                              
MFA-TR*              ,UNIT_PRICE_AM                                             
MFA-TR*              ,WNA_COMP_AM                                               
MFA-TR*              ,INSTR_USE_TYPE_CD                                         
MFA-TR*         FROM  CSS_BILL_CALC_DET                                         
MFA-TR*        WHERE  ACCOUNT_NO         = :BZ-ACCOUNT-NO                       
MFA-TR*          AND  CODE_UTIL_TYPE     = :BZ-CODE-UTIL-TYPE                   
MFA-TR*          AND  BILL_NO            = :BZ-BILL-NO                          
MFA-TR*          AND  IC_NO              = :BZ-IC-NO                            
MFA-TR*          AND  BILL_ITEM_TIMESTMP = :BZ-BILL-ITEM-TIMESTMP               
MFA-TR*          AND  CMPNT_ID_CD NOT IN ('92','93')                            
MFA-TR*       ORDER BY CONSUMPT_TYPE_CD ASC                                     
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*       QUERYNO 7610                                                      
MFA-TR*    END-EXEC.                                                            
      ******************************************************************        
      ****THE FOLLOWING DECLARES THE CURSOR FOR RETRIEVING A SET OF   **        
      **** ROWS FROM THE CSS_BILL_CALC_DET.                           **        
      ******************************************************************        
           EXEC SQL                                                     
              DECLARE FH-CURSOR CURSOR FOR                              
               SELECT  FH.FACTOR_ID                                     
                      ,FH.CODE_DEBIT_CREDIT                             
                      ,FH.FACTOR                                        
                      ,FH.BILL_UNITS                                    
               FROM    CSS_FIXED_FCT_HIST FH WITH(READUNCOMMITTED)              
                      ,CSS_SPCL_FCTR      SF WITH(READUNCOMMITTED)              
               WHERE   FH.ACCOUNT_NO         = :FH-ACCOUNT-NO           
                 AND   FH.BILL_NO            = :FH-BILL-NO              
                 AND   FH.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :FH-BILL-ITEM-TIMESTMP
              )   
                 AND   SF.SPCL_GROUP_CD      IN ('AP','MT')             
                 AND   SF.FACTOR_ID          = FH.FACTOR_ID             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE FH-CURSOR CURSOR FOR                                      
MFA-TR*        SELECT  FH.FACTOR_ID                                             
MFA-TR*               ,FH.CODE_DEBIT_CREDIT                                     
MFA-TR*               ,FH.FACTOR                                                
MFA-TR*               ,FH.BILL_UNITS                                            
MFA-TR*        FROM    CSS_FIXED_FCT_HIST FH                                    
MFA-TR*               ,CSS_SPCL_FCTR      SF                                    
MFA-TR*        WHERE   FH.ACCOUNT_NO         = :FH-ACCOUNT-NO                   
MFA-TR*          AND   FH.BILL_NO            = :FH-BILL-NO                      
MFA-TR*          AND   FH.BILL_ITEM_TIMESTMP = :FH-BILL-ITEM-TIMESTMP           
MFA-TR*          AND   SF.SPCL_GROUP_CD      IN ('AP','MT')                     
MFA-TR*          AND   SF.FACTOR_ID          = FH.FACTOR_ID                     
MFA-TR*    WITH UR                                                              
MFA-TR*    QUERYNO 7130                                                         
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      ****THE FOLLOWING DECLARES THE CURSOR FOR RETRIEVING FACTOR VALUE*        
      **** ROWS FROM THE CSS_FIXED_FCT_HIST                           **        
      ******************************************************************        
           EXEC SQL                                                     
              DECLARE FACTOR_VAL CURSOR FOR                             
               SELECT FH.FACTOR                                         
                     ,FH.FCTR_POWER_10                                  
                 FROM CSS_FIXED_FCT_HIST FH WITH(READUNCOMMITTED)               
                WHERE FH.ACCOUNT_NO         = :FH-ACCOUNT-NO            
                  AND FH.CODE_UTIL_TYPE     = :FH-CODE-UTIL-TYPE        
                  AND FH.IC_NO              = :FH-IC-NO                 
                  AND FH.BILL_NO            = :FH-BILL-NO               
                  AND FH.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :FH-BILL-ITEM-TIMESTMP
              )    
                  AND (( :WS-GET-FACTOR-TYPE = :WS-FACTOR-ONLY          
                     AND FH.FACTOR_ID        = :WS-FACTOR-ID )          
                    OR ( :WS-GET-FACTOR-TYPE = :WS-ADJ-FACTOR-ONLY      
                     AND (FH.FACTOR_ID      IN                          
                            (SELECT CIS.SUBSTR3(PARM_DATA,1,9)               
                               FROM CSS_JOB_PARM J1
                           WITH(READUNCOMMITTED)                     
                              WHERE J1.PROGRAM_NAME = 'CSR04638'        
                                AND J1.COMPANY_NO   = '01'              
                                AND J1.CMND_CODE    = 'OPTN'            
                                AND J1.STATUS       = 'A')))            
                    OR ( :WS-GET-FACTOR-TYPE = :WS-ANY-FACTORS))        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE FACTOR_VAL CURSOR FOR                                     
MFA-TR*        SELECT FH.FACTOR                                                 
MFA-TR*              ,FH.FCTR_POWER_10                                          
MFA-TR*          FROM CSS_FIXED_FCT_HIST FH                                     
MFA-TR*         WHERE FH.ACCOUNT_NO         = :FH-ACCOUNT-NO                    
MFA-TR*           AND FH.CODE_UTIL_TYPE     = :FH-CODE-UTIL-TYPE                
MFA-TR*           AND FH.IC_NO              = :FH-IC-NO                         
MFA-TR*           AND FH.BILL_NO            = :FH-BILL-NO                       
MFA-TR*           AND FH.BILL_ITEM_TIMESTMP = :FH-BILL-ITEM-TIMESTMP            
MFA-TR*           AND (( :WS-GET-FACTOR-TYPE = :WS-FACTOR-ONLY                  
MFA-TR*              AND FH.FACTOR_ID        = :WS-FACTOR-ID )                  
MFA-TR*             OR ( :WS-GET-FACTOR-TYPE = :WS-ADJ-FACTOR-ONLY              
MFA-TR*              AND (FH.FACTOR_ID      IN                                  
MFA-TR*                     (SELECT SUBSTR(PARM_DATA,1,9)                       
MFA-TR*                        FROM CSS_JOB_PARM J1                             
MFA-TR*                       WHERE J1.PROGRAM_NAME = 'CSR04638'                
MFA-TR*                         AND J1.COMPANY_NO   = '01'                      
MFA-TR*                         AND J1.CMND_CODE    = 'OPTN'                    
MFA-TR*                         AND J1.STATUS       = 'A')))                    
MFA-TR*             OR ( :WS-GET-FACTOR-TYPE = :WS-ANY-FACTORS))                
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7230                                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       LINKAGE SECTION.                                                 
COB305 01 PARM-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.             
       01 PARM-APPLICATION-ID     PIC X(03)   VALUE SPACES.             
       01 PARM-GET-FACTOR-DTLS    PIC X(01)   VALUE SPACES.             
                                                                        
       PROCEDURE DIVISION USING PARM-ACCOUNT-NO                         
                                PARM-APPLICATION-ID                     
                                PARM-GET-FACTOR-DTLS.                   
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 1000-PROCESS-INPUT       THRU 1000-EXIT.             
           PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT.             
           PERFORM 9999-END-PROGRAM         THRU 9999-EXIT.             
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100A-DECLARE-GTT-R1   -  CSS_BUS_RULE                         *        
      ******************************************************************        
       0100A-DECLARE-GTT-R1.                                            
                                                                        
           MOVE 'SESSION.CSR04638_R1'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04638_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04638_R1
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,ACCOUNT_NO              DECIMAL(13,0)               
                   ,BC_BILL_NO              INT                     
                   ,BILLING_MONTH           DECIMAL(06)                 
                   ,DATE_BILLED CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,UTILITY_REVENUE         DECIMAL(13,2)               
                   ,ARREARS                 DECIMAL(13,2)               
                   ,OTHER_CHARGES           DECIMAL(13,2)               
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS    THRU 8000A-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100A'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,ACCOUNT_NO                                       
                      ,BC_BILL_NO                                       
                      ,BILLING_MONTH                                    
                      ,LTRIM(RTRIM(DATE_BILLED))       AS DATE_BILLED          
                      ,UTILITY_REVENUE                                  
                      ,ARREARS                                          
                      ,OTHER_CHARGES                                    
                  FROM #CSR04638_R1                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,ACCOUNT_NO                                               
MFA-TR*               ,BC_BILL_NO                                               
MFA-TR*               ,BILLING_MONTH                                            
MFA-TR*               ,STRIP(DATE_BILLED)       AS DATE_BILLED                  
MFA-TR*               ,UTILITY_REVENUE                                          
MFA-TR*               ,ARREARS                                                  
MFA-TR*               ,OTHER_CHARGES                                            
MFA-TR*           FROM SESSION.CSR04638_R1                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 0100B-DECLARE-GTT-R2 - CSS_BUS_RULE_XREF                       *        
      ******************************************************************        
       0100B-DECLARE-GTT-R2.                                            
                                                                        
           MOVE 'SESSION.CSR04638_R2'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04638_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04638_R2
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,BC_BILL_NO              INT                     
                   ,BILL_NO                 INT                     
                   ,BILLING_MONTH           DECIMAL(06)                 
                   ,BILL_ITEM_TIMESTAMP CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,DATE_BILLED CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,CODE_UTIL_TYPE CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,IC_NO                   SMALLINT                    
                   ,RATE_PLAN_NO CHAR(03)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,RATE_DESC CHAR(50)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,OPTION_CD CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,OPTION_DESC CHAR(50)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,OPTION_CALC_TYPE_CD CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,TOT_USG_COST            DECIMAL(11,2)               
                   ,TOT_USG                 INT                     
                   ,WNA_AMOUNT              DECIMAL(11,2)               
                   ,AVG_COST_PER_USG        DECIMAL(11,6)               
                   ,AVG_COST_PER_DAY        DECIMAL(11,6)               
                   ,NO_OF_DAYS              SMALLINT                    
                   ,AVG_USG_PER_DAY         DECIMAL(11,2)               
                   ,AGL_CHRG                DECIMAL(13,4)               
                   ,DATE_READ CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,CODE_MTR_READ CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,METER_NO CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,METER_READING           DECIMAL(11,0)               
                   ,STATE_TAX_AMT           DECIMAL(09,2)               
                   ,CITY_TAX_AMT            DECIMAL(09,2)               
                   ,UNIT_PRICE_AMT          DECIMAL(11,6)               
                   ,CALC_COMP_AMT           DECIMAL(11,2)               
                   ,READ_UNITS              INT                     
                   ,BFC_CHRG                DECIMAL(13,4)               
                   ,SPC_DDC_CHARGE          DECIMAL(13,4)               
                   ,UNBIL_REBIL_FLG CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,DDC_FACTOR              DECIMAL(13,4)               
                   ,[2PART_RATE_FLG] CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,STEP_RATE_FLG CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,TOTAL_CHARGES_CREDIT    DECIMAL(13,4)               
                   ,CSC_ADJ_EXIST CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,MULT_MTR_REG_FLG CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
ACT056             ,SOLAR_RATE_FLG CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000B-DEL-GTT-ROWS    THRU 8000B-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100B'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C2 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,BC_BILL_NO                                       
                      ,BILL_NO                                          
                      ,BILLING_MONTH                                    
                      ,BILL_ITEM_TIMESTAMP                              
                      ,LTRIM(RTRIM(DATE_BILLED))         AS DATE_BILLED        
                      ,LTRIM(RTRIM(CODE_UTIL_TYPE))      AS 
           CODE_UTIL_TYP      
                      ,IC_NO                                            
                      ,LTRIM(RTRIM(RATE_PLAN_NO))        AS RATE_PLAN_NO       
                      ,LTRIM(RTRIM(RATE_DESC))           AS RATE_DESC          
                      ,LTRIM(RTRIM(OPTION_CD))           AS OPTION_CD          
                      ,LTRIM(RTRIM(OPTION_DESC))         AS OPTION_DESC        
                      ,LTRIM(RTRIM(OPTION_CALC_TYPE_CD)) AS 
           OPTION_CALC_TYPE_CD
                      ,TOT_USG_COST                                     
                      ,TOT_USG                                          
                      ,WNA_AMOUNT                                       
                      ,AVG_COST_PER_USG                                 
                      ,AVG_COST_PER_DAY                                 
                      ,NO_OF_DAYS                                       
                      ,AVG_USG_PER_DAY                                  
                      ,AGL_CHRG                                         
                      ,LTRIM(RTRIM(DATE_READ))           AS DATE_READ          
                      ,LTRIM(RTRIM(CODE_MTR_READ))       AS MTR_RD_CD          
                      ,LTRIM(RTRIM(METER_NO))            AS MTR_NO             
                      ,METER_READING              AS MTR_RD             
                      ,STATE_TAX_AMT                                    
                      ,CITY_TAX_AMT                                     
                      ,UNIT_PRICE_AMT                                   
                      ,CALC_COMP_AMT                                    
                      ,READ_UNITS                                       
                      ,BFC_CHRG                                         
                      ,SPC_DDC_CHARGE                                   
                      ,LTRIM(RTRIM(UNBIL_REBIL_FLG))     AS 
           UNBIL_REBIL_FLG    
                      ,DDC_FACTOR                                       
                      ,LTRIM(RTRIM([2PART_RATE_FLG]))      AS 
           [2PART_RATE_FLG]     
                      ,LTRIM(RTRIM(STEP_RATE_FLG))       AS 
           STEP_RATE_FLG      
                      ,TOTAL_CHARGES_CREDIT                             
                      ,LTRIM(RTRIM(CSC_ADJ_EXIST))       AS 
           CSC_ADJ_EXIST      
                      ,LTRIM(RTRIM(MULT_MTR_REG_FLG))    AS 
           MULT_MTR_REG_FLG   
ACT056                ,LTRIM(RTRIM(SOLAR_RATE_FLG))      AS 
           SOLAR_RATE_FLG     
                  FROM #CSR04638_R2                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ026
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C2 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,BC_BILL_NO                                               
MFA-TR*               ,BILL_NO                                                  
MFA-TR*               ,BILLING_MONTH                                            
MFA-TR*               ,BILL_ITEM_TIMESTAMP                                      
MFA-TR*               ,STRIP(DATE_BILLED)         AS DATE_BILLED                
MFA-TR*               ,STRIP(CODE_UTIL_TYPE)      AS CODE_UTIL_TYP              
MFA-TR*               ,IC_NO                                                    
MFA-TR*               ,STRIP(RATE_PLAN_NO)        AS RATE_PLAN_NO               
MFA-TR*               ,STRIP(RATE_DESC)           AS RATE_DESC                  
MFA-TR*               ,STRIP(OPTION_CD)           AS OPTION_CD                  
MFA-TR*               ,STRIP(OPTION_DESC)         AS OPTION_DESC                
MFA-TR*               ,STRIP(OPTION_CALC_TYPE_CD) AS OPTION_CALC_TYPE_CD        
MFA-TR*               ,TOT_USG_COST                                             
MFA-TR*               ,TOT_USG                                                  
MFA-TR*               ,WNA_AMOUNT                                               
MFA-TR*               ,AVG_COST_PER_USG                                         
MFA-TR*               ,AVG_COST_PER_DAY                                         
MFA-TR*               ,NO_OF_DAYS                                               
MFA-TR*               ,AVG_USG_PER_DAY                                          
MFA-TR*               ,AGL_CHRG                                                 
MFA-TR*               ,STRIP(DATE_READ)           AS DATE_READ                  
MFA-TR*               ,STRIP(CODE_MTR_READ)       AS MTR_RD_CD                  
MFA-TR*               ,STRIP(METER_NO)            AS MTR_NO                     
MFA-TR*               ,METER_READING              AS MTR_RD                     
MFA-TR*               ,STATE_TAX_AMT                                            
MFA-TR*               ,CITY_TAX_AMT                                             
MFA-TR*               ,UNIT_PRICE_AMT                                           
MFA-TR*               ,CALC_COMP_AMT                                            
MFA-TR*               ,READ_UNITS                                               
MFA-TR*               ,BFC_CHRG                                                 
MFA-TR*               ,SPC_DDC_CHARGE                                           
MFA-TR*               ,STRIP(UNBIL_REBIL_FLG)     AS UNBIL_REBIL_FLG            
MFA-TR*               ,DDC_FACTOR                                               
MFA-TR*               ,STRIP(2PART_RATE_FLG)      AS 2PART_RATE_FLG             
MFA-TR*               ,STRIP(STEP_RATE_FLG)       AS STEP_RATE_FLG              
MFA-TR*               ,TOTAL_CHARGES_CREDIT                                     
MFA-TR*               ,STRIP(CSC_ADJ_EXIST)       AS CSC_ADJ_EXIST              
MFA-TR*               ,STRIP(MULT_MTR_REG_FLG)    AS MULT_MTR_REG_FLG           
MFA-TR*               ,STRIP(SOLAR_RATE_FLG)      AS SOLAR_RATE_FLG             
MFA-TR*           FROM SESSION.CSR04638_R2                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100B-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100C-DECLARE-GTT-R3  -  CSS_BUS_RULE_ACTN                     *        
      ******************************************************************        
       0100C-DECLARE-GTT-R3.                                            
                                                                        
           MOVE 'SESSION.CSR04638_R3'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04638_R3')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04638_R3
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,BILLING_MONTH           DECIMAL(06)                 
                   ,DATE_BILLED CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,CODE_UTIL_TYPE CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,IC_NO                   SMALLINT                    
                   ,BUS_RULE_ID CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BUS_RESULT_CD CHAR(08)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BUS_RULE_XREF_ID CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,MESSAGE_PARMS CHAR(55)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,LINK_PARMS CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2        
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000C-DEL-GTT-ROWS    THRU 8000C-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100C'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C3 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,BILLING_MONTH                                    
                      ,LTRIM(RTRIM(DATE_BILLED))          AS DATE_BILLED       
                      ,LTRIM(RTRIM(CODE_UTIL_TYPE))       AS 
           CODE_UTIL_TYPE    
                      ,IC_NO                                            
                      ,LTRIM(RTRIM(BUS_RULE_ID))          AS BUS_RULE_ID       
                      ,LTRIM(RTRIM(BUS_RESULT_CD))        AS 
           BUS_RESULT_CD     
                      ,LTRIM(RTRIM(BUS_RULE_XREF_ID))     AS 
           BUS_RULE_XREF_ID  
                      ,LTRIM(RTRIM(MESSAGE_PARMS))        AS 
           MESSAGE_PARMS     
                      ,LTRIM(RTRIM(LINK_PARMS))           AS LINK_PARMS        
                 FROM #CSR04638_R3                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C3 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,BILLING_MONTH                                            
MFA-TR*               ,STRIP(DATE_BILLED)          AS DATE_BILLED               
MFA-TR*               ,STRIP(CODE_UTIL_TYPE)       AS CODE_UTIL_TYPE            
MFA-TR*               ,IC_NO                                                    
MFA-TR*               ,STRIP(BUS_RULE_ID)          AS BUS_RULE_ID               
MFA-TR*               ,STRIP(BUS_RESULT_CD)        AS BUS_RESULT_CD             
MFA-TR*               ,STRIP(BUS_RULE_XREF_ID)     AS BUS_RULE_XREF_ID          
MFA-TR*               ,STRIP(MESSAGE_PARMS)        AS MESSAGE_PARMS             
MFA-TR*               ,STRIP(LINK_PARMS)           AS LINK_PARMS                
MFA-TR*          FROM SESSION.CSR04638_R3                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100C-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100D-DECLARE-GTT-R4  -  FIXED_FCTR_DETAILS                    *        
      ******************************************************************        
       0100D-DECLARE-GTT-R4.                                            
                                                                        
           MOVE 'SESSION.CSR04638_R4'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04638_R4')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04638_R4
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,BILL_NO                 INT                     
                   ,DATE_BILLED CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BILLING_MONTH           DECIMAL(06)                 
                   ,BILL_ITEM_TIMESTAMP CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,CODE_UTIL_TYPE CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,IC_NO                   SMALLINT                    
                   ,FACTOR_ID CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,CODE_DEBIT_CREDIT CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,FACTOR                  DECIMAL(13,4)               
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000D-DEL-GTT-ROWS    THRU 8000D-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100D'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C4 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,BILL_NO                                          
                      ,LTRIM(RTRIM(DATE_BILLED))         AS DATE_BILLED        
                      ,BILLING_MONTH                                    
                      ,LTRIM(RTRIM(BILL_ITEM_TIMESTAMP)) AS 
           BILL_ITEM_TIMESTAMP
                      ,LTRIM(RTRIM(CODE_UTIL_TYPE))      AS 
           CODE_UTIL_TYP      
                      ,IC_NO                                            
                      ,LTRIM(RTRIM(FACTOR_ID))           AS FACTOR_ID          
                      ,LTRIM(RTRIM(CODE_DEBIT_CREDIT))   AS 
           CODE_DEBIT_CREDIT  
                      ,FACTOR                     AS FACTOR             
                 FROM #CSR04638_R4                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C4 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,BILL_NO                                                  
MFA-TR*               ,STRIP(DATE_BILLED)         AS DATE_BILLED                
MFA-TR*               ,BILLING_MONTH                                            
MFA-TR*               ,STRIP(BILL_ITEM_TIMESTAMP) AS BILL_ITEM_TIMESTAMP        
MFA-TR*               ,STRIP(CODE_UTIL_TYPE)      AS CODE_UTIL_TYP              
MFA-TR*               ,IC_NO                                                    
MFA-TR*               ,STRIP(FACTOR_ID)           AS FACTOR_ID                  
MFA-TR*               ,STRIP(CODE_DEBIT_CREDIT)   AS CODE_DEBIT_CREDIT          
MFA-TR*               ,FACTOR                     AS FACTOR                     
MFA-TR*          FROM SESSION.CSR04638_R4                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100D-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 0100E-DECLARE-GTT-R5  -  WEATHER SERVICE DIVISION RESULTSET    *        
      ******************************************************************        
       0100E-DECLARE-GTT-R5.                                            
                                                                        
           MOVE 'SESSION.CSR04638_R5'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04638_R5')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04638_R5
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,WEATHER_SRVC_DIV CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000E-DEL-GTT-ROWS    THRU 8000E-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100E'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C5 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                                                                        
                SELECT RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,LTRIM(RTRIM(WEATHER_SRVC_DIV))    AS 
           WEATHER_SRVC_DIV   
                 FROM #CSR04638_R5                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C5 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*                                                                         
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,STRIP(WEATHER_SRVC_DIV)    AS WEATHER_SRVC_DIV           
MFA-TR*          FROM SESSION.CSR04638_R5                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100E-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           PERFORM 1100-VALIDATE-INPUT        THRU 1100-EXIT.           
                                                                        
           MOVE PARM-ACCOUNT-NO              TO BI-ACCOUNT-NO           
                                                BG-ACCOUNT-NO           
                                                AT-ACCOUNT-NO           
                                                BH-ACCOUNT-NO           
                                                AR-ACCOUNT-NO.          
                                                                        
           MOVE PARM-APPLICATION-ID          TO WS-APPL-ID.             
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1       THRU 0100A-EXIT.          
           PERFORM 0100B-DECLARE-GTT-R2       THRU 0100B-EXIT.          
           PERFORM 0100C-DECLARE-GTT-R3       THRU 0100C-EXIT.          
           PERFORM 0100D-DECLARE-GTT-R4       THRU 0100D-EXIT.          
           PERFORM 0100E-DECLARE-GTT-R5       THRU 0100E-EXIT.          
                                                                        
      *GETTING ACCOUNT REGION FROM CSS_LOCAL_OFFICE TABLE.                      
           PERFORM 7250A-GET-REGION           THRU 7250A-EXIT.          
                                                                        
      *GETTING DATABASE REGION.                                                 
           MOVE 'DATABASE'                   TO C8-DELINQ-CD.           
           MOVE AT-COMPANY-NO                TO C8-COMPANY-NO.          
           PERFORM 7250B-DETERMINE-DB         THRU 7250B-EXIT.          
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 1100-VALIDATE-INPUT.                                          *         
      *****************************************************************         
       1100-VALIDATE-INPUT.                                             
                                                                        
           IF  PARM-ACCOUNT-NO GREATER THAN ZERO                        
           AND PARM-ACCOUNT-NO IS NUMERIC                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '1100'                    TO ACTIVE-PARAGRAPH        
              MOVE 'RECEIVE INPUT'           TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE SPACES                    TO TABLE-1                 
              MOVE SPACES                    TO TABLE-ELEMENT-1         
              MOVE SPACES                    TO HOSTVAR-ELEMENT-1       
      ****************************************************************          
      * IF ACCOUNT NUMBER IS INVALID                                 *          
      ****************************************************************          
              MOVE +0                        TO WS-ACTIVE-RETURN-CODE   
              MOVE +1000                     TO WS-APPL-RETURN-CODE     
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       1100-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 7000-OPEN-BI-CURSOR        THRU 7000-EXIT.           
           PERFORM 7010-FETCH-BI-ROW          THRU 7010-EXIT.           
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE        TO S1-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              PERFORM 2200-BUILD-RESULT-HEADER                          
                                              THRU 2200-EXIT            
                     UNTIL NO-MORE-HEADER-RECS                          
           END-IF.                                                      
                                                                        
           PERFORM 7020-CLOSE-BI-CURSOR       THRU 7020-EXIT.           
                                                                        
           PERFORM 2660-MOVE-N-INSERT-S5-VALUES                         
                                              THRU 2660-EXIT.           
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2200-BUILD-RESULT-HEADER                                       *        
      *     BUILD THE RESULT SET DESCRIBED ABOVE.                      *        
      ******************************************************************        
       2200-BUILD-RESULT-HEADER.                                        
      *                                                                         
           PERFORM 2500-BUILD-RESULT-DETAIL   THRU 2500-EXIT.           
                                                                        
           IF WS-HDR-REBIL-R-NRML-BIL = WS-YES                          
              PERFORM 2240-MOVE-BI-VALUES     THRU 2240-EXIT            
              PERFORM 8010-INSERT-GTT-R1      THRU 8010-EXIT            
           END-IF.                                                      
                                                                        
           PERFORM 2250-INIT-HEADER-FIELDS    THRU 2250-EXIT.           
           PERFORM 2505-INIT-DETAIL-FIELDS    THRU 2505-EXIT.           
                                                                        
           PERFORM 7010-FETCH-BI-ROW          THRU 7010-EXIT.           
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2240-MOVE-BI-VALUES.                                           *        
      *     MOVE BILLING HEADER VALUES TO RESULT SET 1 FIELDS          *        
      ******************************************************************        
       2240-MOVE-BI-VALUES.                                             
      *                                                                         
           MOVE BI-ACCOUNT-NO                TO S1-ACCOUNT-NO.          
           MOVE BI-BILL-NO                   TO S1-BC-BILL-NO.          
           MOVE BI-TOTAL-ARREARS             TO S1-ARREARS.             
           MOVE WS-DATE-BILLED               TO S1-DATE-BILLED.         
           MOVE BI-TOT-OTHER-CHARGES         TO S1-OTHER-CHARGES.       
           MOVE WS-HOLD-REV-MM               TO S1-BILLING-MONTH.       
           MOVE WS-TOTAL-BG-DOLLARS          TO S1-UTILITY-REVENUE.     
           MOVE ZERO                         TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
       2240-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2250-INIT-HEADER-FIELDS.                                       *        
      *   THIS ROUTINE WILL INITIALIZE ALL BILLING HEADER COLUMNS      *        
      ******************************************************************        
       2250-INIT-HEADER-FIELDS.                                         
      *                                                                         
           MOVE SPACES                       TO S1-DATE-BILLED          
                                                WS-DATE-ORIG-BILL.      
           MOVE 0                            TO S1-ARREARS              
                                                S1-BC-BILL-NO           
                                                S1-OTHER-CHARGES        
                                                S1-BILLING-MONTH        
                                                S1-UTILITY-REVENUE      
                                                WS-TOTAL-BG-DOLLARS     
                                                WS-HOLD-REV-MM.         
      *                                                                         
       2250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2500-BUILD-RESULT-DETAIL                                       *        
      *     OBTAINS THE BILLING DETAILS DATA.                          *        
      ***  THIS LOGIC IS THE SAME AS THE OLD S093 PROGRAM IS THAT      *        
      ***  REVENUE MONTH IS SAVED AFTER THE FIRST RETRIEVE OF          *        
      ***  OF BILLING DETAIL.                                          *        
      ******************************************************************        
       2500-BUILD-RESULT-DETAIL.                                        
      *                                                                         
           PERFORM 7030-OPEN-BG-CURSOR        THRU 7030-EXIT.           
           PERFORM 7040-FETCH-BG-ROW          THRU 7040-EXIT.           
           MOVE WS-ACTIVE-RETURN-CODE        TO S2-RETURN-CODE.         
           MOVE WS-NO                        TO WS-HDR-REBIL-R-NRML-BIL.
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE WS-NO                     TO END-OF-BG-SW            
              PERFORM 2510-PROCESS-DTL-ROWS   THRU 2510-EXIT            
                   UNTIL NO-MORE-DETAIL-RECS                            
      *                                                                         
      * NOTE: WS-FIRST-TIME-PROCESS FLAG IS USED IN MULT-MTR-REG-FLG            
      *       CHECK LOGIC.                                                      
      *                                                                         
              IF WS-FIRST-TIME-PROCESS = WS-YES                         
                 AND CTR-ROWS-RS2 > 0                                   
                 MOVE WS-NO                  TO WS-FIRST-TIME-PROCESS   
              END-IF                                                    
           END-IF                                                       
                                                                        
           PERFORM 7050-CLOSE-BG-CURSOR       THRU 7050-EXIT.           
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2505-INIT-DETAIL-RETURN FIELDS                                 *        
      *   THIS ROUTINE WILL INITIALIZE ALL BILLING DETAIL COLUMNS               
      *   THAT ARE UNRELATED TO THE BILLING HEADER RECORDS TO BE                
      *   RETURNED.                                                             
      ******************************************************************        
       2505-INIT-DETAIL-FIELDS.                                         
      *                                                                         
           MOVE SPACES                       TO WS-CODE-UTIL-TYPE       
                                                WS-DATE-BILLED          
                                                WS-CODE-BILL-ITM-IND.   
           MOVE 0                            TO WS-TOT-UTILITY          
                                                WS-TOT-BILL-USAGE       
                                                WS-TOT-READ-USAGE       
                                                WS-AVG-COST-PER-USG     
                                                WS-AVG-COST-PER-DAY     
                                                WS-NO-OF-DAYS           
                                                WS-AVG-USG-PER-DAY      
                                                WS-AMT-TAXES            
                                                WS-STATE-TAX-AMT        
                                                WS-CITY-TAX-AMT         
                                                WS-IC-NO.               
      *                                                                         
       2505-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2510-PROCESS-DTL-ROWS                                          *        
      *     OBTAINS THE BILLING DETAILS DATA.                          *        
      ******************************************************************        
       2510-PROCESS-DTL-ROWS.                                           
      *                                                                         
           MOVE SPACES                       TO WS-DATE-READ            
                                                WS-CODE-BILL-ITM-IND.   
ACT056     IF RD-RATE-SUB-GRP-TYPE EQUAL 'A'                            
ACT056           OR RD-RATE-SUB-GRP-TYPE EQUAL 'B'                      
ACT056                 OR RD-RATE-SUB-GRP-TYPE EQUAL 'C'                
ACT056                      OR RD-RATE-SUB-GRP-TYPE EQUAL 'D'           
ACT056        MOVE WS-SOLAR-RATE-FLG         TO S2-SOLAR-RATE-FLG       
ACT056     ELSE                                                         
ACT056        MOVE WS-NO                     TO S2-SOLAR-RATE-FLG       
ACT056     END-IF                                                       
           PERFORM 2515-MOVE-BG-VALUES        THRU 2515-EXIT.           
                                                                        
           IF BI-DATE-BILLED    EQUAL   SPACES                          
              PERFORM 7280-GET-DATE-READ      THRU 7280-EXIT            
           END-IF.                                                      
                                                                        
      *****************************************************************         
      **WS-DATE-READ   > SPACES CHECK IS TO PROCESS FUTURE BILL ROW             
      **                 WITH UNBILLED CONSUMPTION DETAILS.                     
      **                                                                        
      **BI-DATE-BILLED > SPACES CHECK IS TO PROCESS BILLED ROWS.                
      **                                                                        
      *****************************************************************         
                                                                        
           IF WS-DATE-READ      GREATER SPACES                          
           OR BI-DATE-BILLED    GREATER SPACES                          
              PERFORM 2520-PROCESS-BG-CURSOR  THRU 2520-EXIT            
           END-IF.                                                      
                                                                        
           PERFORM 7040-FETCH-BG-ROW          THRU 7040-EXIT.           
      *                                                                         
       2510-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2515-MOVE-BG-VALUES.                                           *        
      *     MOVE BILLING DETAIL VALUES FOR FURTHER PROCESS             *        
      ******************************************************************        
       2515-MOVE-BG-VALUES.                                             
      *                                                                         
                                                                        
      *****************************************************************         
      **BILL-CANCEL & BI-DATE-BILLED > SPACE                                    
      **       -OVERRIDING REBILL ROW DETAILS WITH CANCEL ROW INFO              
      *****************************************************************         
           IF BILL-CANCEL                                               
           AND BI-DATE-BILLED    GREATER SPACES                         
              MOVE WS-DATE-BILLED            TO S2-DATE-BILLED          
              MOVE BG-BILL-NO                TO S2-BC-BILL-NO           
              MOVE WS-BILL-NO                TO CX-BILL-NO              
                                                S2-BILL-NO              
                                                BZ-BILL-NO              
                                                UC-BILL-NO              
                                                FH-BILL-NO              
              MOVE WS-BILL-ITEM-TIMESTMP     TO CX-BILL-ITEM-TIMESTMP   
                                                BZ-BILL-ITEM-TIMESTMP   
                                                UC-BILL-ITEM-TIMESTMP   
                                                FH-BILL-ITEM-TIMESTMP   
                                                S2-BILL-ITEM-TIMESTMP   
              MOVE WS-NO-OF-CONS-DAYS        TO WS-NO-OF-DAYS           
              MOVE BG-REV-MTH-ORIG-BILL      TO WS-HOLD-REV-MM          
              MOVE BG-RATE-PLAN-NO           TO RD-RATE-PLAN-NO         
                                                S2-RATE-PLAN-NO         
           ELSE                                                         
              MOVE BI-DATE-BILLED            TO S2-DATE-BILLED          
                                                WS-DATE-BILLED          
              MOVE BG-BILL-NO                TO CX-BILL-NO              
                                                BZ-BILL-NO              
                                                UC-BILL-NO              
                                                FH-BILL-NO              
                                                S2-BILL-NO              
                                                S2-BC-BILL-NO           
              MOVE BG-IC-NO                  TO CX-IC-NO                
                                                BZ-IC-NO                
                                                CP-IC-NO                
                                                UC-IC-NO                
                                                FH-IC-NO                
                                                WS-IC-NO                
              MOVE BG-ACCOUNT-NO             TO CX-ACCOUNT-NO           
                                                BZ-ACCOUNT-NO           
                                                UC-ACCOUNT-NO           
                                                CP-ACCOUNT-NO           
                                                FH-ACCOUNT-NO           
                                                WS-ACCOUNT-NO           
              MOVE BI-COMPANY-NO             TO WS-COMPANY-NO           
              MOVE BG-RATE-PLAN-NO           TO RD-RATE-PLAN-NO         
                                                S2-RATE-PLAN-NO         
              MOVE BG-CODE-UTIL-TYPE         TO CX-CODE-UTIL-TYPE       
                                                BZ-CODE-UTIL-TYPE       
                                                CP-CODE-UTIL-TYPE       
                                                UC-CODE-UTIL-TYPE       
                                                RD-CODE-UTIL-TYPE       
                                                FH-CODE-UTIL-TYPE       
                                                WS-CODE-UTIL-TYPE       
              MOVE BG-BILL-ITEM-TIMESTMP     TO CX-BILL-ITEM-TIMESTMP   
                                                BZ-BILL-ITEM-TIMESTMP   
                                                UC-BILL-ITEM-TIMESTMP   
                                                FH-BILL-ITEM-TIMESTMP   
                                                S2-BILL-ITEM-TIMESTMP   
              MOVE BG-NO-OF-CONS-DAYS        TO WS-NO-OF-DAYS           
              MOVE BG-REVENUE-MONTH          TO WS-HOLD-REV-MM          
              MOVE WS-NO                     TO S2-UNBIL-REBIL-FLG      
           END-IF.                                                      
           MOVE WS-NO                        TO S2-2PART-RATE-FLG       
           MOVE WS-NO                        TO S2-STEP-RATE-FLG        
           MOVE WS-NO                        TO S2-MULT-MTR-REG-FLG     
           MOVE WS-HOLD-REV-MM               TO S2-BILLING-MONTH.       
      *                                                                         
       2515-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2520-PROCESS-BG-CURSOR                                         *        
      *     OBTAINS THE BILLING DETAILS DATA.                          *        
      ******************************************************************        
       2520-PROCESS-BG-CURSOR.                                          
      *                                                                         
           PERFORM 2535-SET-CODE-BILL-ITM-IND THRU 2535-EXIT.           
      **                                                                        
      **BILL-REBILL                                                             
      **     WE CAN SKIP REBILL DETAIL ROW SINCE WE ARE GOING TO GET            
      **     LATEST REBILL DETAIL FOR ORIGINAL CANCEL ROW AT PARA 7200-         
      **                                                                        
      **BILL-CANCEL & DATE-ORIG-BILL > SPACES                                   
      **     THIS CONDITION MEETS WHEN REBIL ROW IS CANCELED.                   
      **     WE CAN SKIP THIS CANCELED REBIL ROW SINCE WE ARE GOING TO          
      **     PROCESS THE ORIGINAL CANCEL ROW.                                   
      **                                                                        
P00836**WS-TEMP-TS                                                              
P00836**     THIS IS USED TO FETCH CORRECT LATEST REBILL ROW WHEN A BILL        
P00836**     HAS MULTIPLE ROWS PRESENT.                                         
P00836**                                                                        
           IF BILL-REBILL                                               
           OR (BILL-CANCEL AND BG-DATE-ORIG-BILL GREATER SPACES)        
              CONTINUE                                                  
           ELSE                                                         
              SET CNCL-REBIL-R-NRML-BIL      TO TRUE                    
      *                                                                         
              IF BILL-CANCEL                                            
              AND BI-DATE-BILLED    GREATER SPACES                      
P00836           IF BG-BILL-NO = WS-PREV-BILL-NO                        
P00836              MOVE WS-BILL-ITEM-TIMESTMP                          
P00836                                       TO WS-TEMP-TS              
P00836           ELSE                                                   
P00836              MOVE '0001-01-01-00.00.00.000000'                   
P00836                                       TO WS-TEMP-TS              
P00836           END-IF                                                 
                 PERFORM 7200-GET-REBILL-DET  THRU 7200-EXIT            
P00836           MOVE BG-BILL-NO             TO WS-PREV-BILL-NO         
              END-IF                                                    
      *                                                                         
              IF CNCL-REBIL-R-NRML-BIL                                  
                 PERFORM 2515-MOVE-BG-VALUES  THRU 2515-EXIT            
                 PERFORM 2540-CALC-TAXES-N-TOT-AMT                      
                                              THRU 2540-EXIT            
                 PERFORM 2545-SELECT-RT-DESC  THRU 2545-EXIT            
                 PERFORM 7225-GET-TOT-CHARGE-CREDIT                     
                                              THRU 7225-EXIT            
      *                                                                         
                 MOVE 'BFACCHRG'             TO WS-FACTOR-ID            
                 MOVE WS-FACTOR-ONLY         TO WS-GET-FACTOR-TYPE      
                 MOVE WS-NO                  TO WS-CSC-ADJ-EXIST        
                 MOVE ZERO                   TO WS-BFC-CHARGE           
                                                WS-BFC-CHARGE-DBT       
                                                WS-BFC-CHARGE-CRD       
                                                                        
                 PERFORM 2597-GET-FACTOR-VALUE THRU 2597-EXIT           
                                                                        
                 MOVE WS-SUM-FACTOR          TO WS-BFC-CHARGE-DBT       
                                                                        
                 IF SEB-DATABASE                                        
                    MOVE WS-ADJ-FACTOR-ONLY  TO WS-GET-FACTOR-TYPE      
                                                                        
                    PERFORM 2597-GET-FACTOR-VALUE THRU 2597-EXIT        
                                                                        
                    MOVE WS-SUM-FACTOR       TO WS-BFC-CHARGE-CRD       
                                                                        
                    IF WS-FACTOR-VAL-EXIST EQUAL WS-YES                 
                       MOVE WS-YES           TO WS-CSC-ADJ-EXIST        
                    ELSE                                                
                       MOVE WS-NO            TO WS-CSC-ADJ-EXIST        
                    END-IF                                              
                                                                        
                 END-IF                                                 
                                                                        
                 COMPUTE WS-BFC-CHARGE = WS-BFC-CHARGE-DBT -            
                                         WS-BFC-CHARGE-CRD              
      *                                                                         
                 IF SEB-DATABASE                                        
                    MOVE 'DDC'               TO WS-FACTOR-ID            
                    MOVE WS-FACTOR-ONLY      TO WS-GET-FACTOR-TYPE      
                    MOVE ZEROES              TO WS-DDC-FACTOR           
                                                S2-AGL-CHARGE           
                    PERFORM 2597-GET-FACTOR-VALUE                       
                                              THRU 2597-EXIT            
                    MOVE WS-SUM-FACTOR       TO WS-DDC-FACTOR           
                                                                        
                    IF AT-ACCOUNT-TYPE-CODE = WS-RESIDENTIAL            
                       MOVE 'SPCDDC1'        TO WS-FACTOR-ID            
                    ELSE                                                
                       MOVE 'SPC DDC'        TO WS-FACTOR-ID            
                    END-IF                                              
                    MOVE ZEROES              TO WS-SPCDDC-CHARGE        
                    MOVE ZEROES              TO WS-SPCDDC-CHARGE-RESULT 
                    MOVE WS-FACTOR-ONLY      TO WS-GET-FACTOR-TYPE      
                    PERFORM 2597-GET-FACTOR-VALUE                       
                                              THRU 2597-EXIT            
                    MOVE WS-SUM-FACTOR        TO WS-SPCDDC-CHARGE       
                    MOVE WS-SUM-FACTOR        TO WS-SPCDDC-CHARGE-RESULT
      *                                                                         
                    PERFORM 2548-GET-FCTR-DTL THRU 2548-EXIT            
                 END-IF                                                 
      *          IF PARM-GET-FACTOR-DTLS = 'Y'                                  
      *             PERFORM 2548-GET-FCTR-DTL THRU 2548-EXIT                    
      *          END-IF                                                         
                 PERFORM 2550-FETCH-CNSMPTN-DETAILS                     
                                              THRU 2550-EXIT            
                 PERFORM 2650-MOVE-N-INSERT-S3-VALUES                   
                                              THRU 2650-EXIT            
                 IF WS-HDR-REBIL-R-NRML-BIL = WS-NO                     
                    MOVE WS-YES              TO WS-HDR-REBIL-R-NRML-BIL 
                 END-IF                                                 
              END-IF                                                    
              IF CNCL-NO-REBIL                                          
                 MOVE BG-BILL-NO             TO S2-BILL-NO              
                                                S2-BC-BILL-NO           
                 MOVE BI-DATE-BILLED         TO S2-DATE-BILLED          
                                                WS-DATE-BILLED          
                 MOVE BG-BILL-ITEM-TIMESTMP  TO S2-BILL-ITEM-TIMESTMP   
                 MOVE BI-COMPANY-NO          TO WS-COMPANY-NO           
                 MOVE BG-CODE-UTIL-TYPE      TO RD-CODE-UTIL-TYPE       
                 MOVE WS-YES                 TO S2-UNBIL-REBIL-FLG      
                 MOVE WS-NO                  TO S2-MULT-MTR-REG-FLG     
                 MOVE BG-RATE-PLAN-NO        TO S2-RATE-PLAN-NO         
                                                RD-RATE-PLAN-NO         
                 MOVE BG-NO-OF-CONS-DAYS     TO WS-NO-OF-DAYS           
                 IF BG-REVENUE-MONTH > 0                                
                    MOVE BG-REVENUE-MONTH    TO S2-BILLING-MONTH        
                 ELSE                                                   
                    MOVE WS-HOLD-REV-MM      TO S2-BILLING-MONTH        
                 END-IF                                                 
                 PERFORM 7280-GET-DATE-READ   THRU 7280-EXIT            
                 PERFORM 2545-SELECT-RT-DESC  THRU 2545-EXIT            
                 MOVE ZEROES                 TO WS-STATE-TAX-AMT        
                                                WS-CITY-TAX-AMT         
                                                WS-AMT-BILL-ITEM        
                                                WS-TOT-COST             
                                                WS-UNIT-PRICE-AMT       
                                                WS-WNA-AMOUNT           
                                                WS-METER-READING        
                                                WS-TOT-UTILITY          
                                                WS-TOT-BILL-USAGE       
                                                WS-TOT-READ-USAGE       
                                                WS-BFC-CHARGE           
                                                WS-BFC-CHARGE-DBT       
                                                WS-BFC-CHARGE-CRD       
                                                WS-SPCDDC-CHARGE-RESULT 
                                                BG-WNA-FACTOR           
                                                WS-AVG-COST-PER-USG     
                                                WS-AVG-COST-PER-DAY     
                                                WS-AVG-USG-PER-DAY      
                                                WS-TOTAL-CHARGES-CREDIT 
                 MOVE SPACES                 TO WS-CODE-MTR-READ        
                 MOVE WS-NO                  TO WS-CSC-ADJ-EXIST        
                 PERFORM 2600-MOVE-N-INSERT-S2-VALUES                   
                                              THRU 2600-EXIT            
                 IF WS-HDR-REBIL-R-NRML-BIL = WS-NO                     
                    MOVE WS-YES              TO WS-HDR-REBIL-R-NRML-BIL 
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2520-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2535-SET-CODE-BILL-ITM-IND.                                    *        
      *     CHECK FOR CODE ITEM BILL INDICATOR.                        *        
      ******************************************************************        
       2535-SET-CODE-BILL-ITM-IND.                                      
      *                                                                         
           IF BG-DATE-ORIG-BILL GREATER SPACES                          
              IF BG-CODE-BILL-ITM-TYPE = 'C'                            
                 IF BG-CODE-BILL-ITM-IND = 'K'                          
                    SET BILL-CANCEL       TO TRUE                       
                 ELSE                                                   
                    SET BILL-REBILL       TO TRUE                       
                 END-IF                                                 
              ELSE                                                      
                 SET BILL-UNKNOWN         TO TRUE                       
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF BG-DATE-ORIG-BILL EQUAL SPACES                            
              IF BG-CODE-BILL-ITM-TYPE = 'C' AND                        
                 BG-CODE-BILL-ITM-IND = 'J' OR 'K'                      
                 SET BILL-CANCEL             TO TRUE                    
              ELSE                                                      
                 IF BG-CODE-BILL-ITM-TYPE = 'C' AND                     
                    BG-CODE-BILL-ITM-IND = 'A' OR 'S' OR 'T'            
                    MOVE BG-CODE-BILL-ITM-IND                           
                                             TO WS-CODE-BILL-ITM-IND    
                 ELSE                                                   
                    SET BILL-UNKNOWN         TO TRUE                    
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2535-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * THIS PROCESS HAS BEEN ADDED TO RATIONALISE TAX CALCULATION              
      * SO THAT IT IS DONE JUST AT ONE POINT OF TIME DURING PROCESSING.         
      * - M ROUTH 7/17/96                                                       
      ****************************************************************          
       2540-CALC-TAXES-N-TOT-AMT.                                       
      *                                                                         
           MOVE ZEROES                       TO WS-AMT-TAXES            
                                                WS-CITY-TAX-AMT         
                                                WS-STATE-TAX-AMT.       
           ADD BG-AMT-STATE-TAX                                         
               BG-AMT-CITY-TAX                                          
               BG-AMT-OTHER-TAX              TO WS-AMT-TAXES.           
                                                                        
           MOVE BG-AMT-STATE-TAX             TO WS-STATE-TAX-AMT.       
           MOVE BG-AMT-CITY-TAX              TO WS-CITY-TAX-AMT.        
                                                                        
           IF BG-CODE-DR-CR-CNSMPTN = 'C'                               
              IF WS-STATE-TAX-AMT NOT = ZEROES                          
                 COMPUTE WS-STATE-TAX-AMT = WS-STATE-TAX-AMT * -1       
              END-IF                                                    
              IF WS-CITY-TAX-AMT  NOT = ZEROES                          
                 COMPUTE WS-CITY-TAX-AMT  = WS-CITY-TAX-AMT  * -1       
              END-IF                                                    
              SUBTRACT BG-AMT-BILL-ITEM    FROM WS-TOTAL-BG-DOLLARS     
           ELSE                                                         
              ADD BG-AMT-BILL-ITEM           TO WS-TOTAL-BG-DOLLARS     
           END-IF.                                                      
      *                                                                         
       2540-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ****************************************************************          
      * SELECT RATE DESC FOR CSR ACCOUNS. OPTION DESC FOR SEB ACCTS             
      ****************************************************************          
       2545-SELECT-RT-DESC.                                             
                                                                        
           SET WS-RATE-INDX                  TO 1                       
           SEARCH WS-RATE-DESC-DATA                                     
              AT END                                                    
              PERFORM 2546-GET-RATE-DESC      THRU 2546-EXIT            
              MOVE RD-RATE-DESC              TO S2-RATE-DESC            
              MOVE RD-RATE-DEFINITION-CD     TO WS-RATE-DFNTN-CD        
           WHEN WS-RATE-PLAN-NO(WS-RATE-INDX)   = RD-RATE-PLAN-NO       
            AND WS-UTIL-TYPE-CODE(WS-RATE-INDX) = RD-CODE-UTIL-TYPE     
                MOVE WS-RATE-DESC(WS-RATE-INDX)                         
                                             TO S2-RATE-DESC            
                MOVE WS-RATE-DEF-CD(WS-RATE-INDX)                       
                                             TO WS-RATE-DFNTN-CD        
           END-SEARCH.                                                  
                                                                        
           MOVE SPACES                       TO S2-OPTION-CD.           
           IF SEB-DATABASE                                              
              IF WS-RATE-DFNTN-CD = '2'                                 
                 MOVE WS-YES                 TO S2-2PART-RATE-FLG       
              END-IF                                                    
              IF BG-RT-PKG-OPT-SEQ-NO > 0                               
                 MOVE BG-ACCOUNT-NO          TO DF-ACCOUNT-NO           
                 MOVE BG-CODE-UTIL-TYPE      TO DF-CODE-UTIL-TYPE       
                 MOVE BG-IC-NO               TO DF-IC-NO                
                 MOVE BG-RT-PKG-OPT-SEQ-NO   TO DF-RT-PKG-OPT-SEQ-NO    
                 IF DF-RT-PKG-OPT-SEQ-NO NOT EQUAL WS-PREV-RT-PKG-SEQ-NO
                    PERFORM 7270-GET-OPTION-DESC                        
                                              THRU 7270-EXIT            
                    MOVE DF-RT-PKG-OPT-SEQ-NO                           
                                             TO WS-PREV-RT-PKG-SEQ-NO   
                 END-IF                                                 
                 MOVE FI-OPT-CALC-TYPE-CD    TO S2-OPTION-CALC-TYPE-CD  
                 MOVE FI-OPT-DESC-INT        TO S2-OPTION-DESC          
                 MOVE FI-OPTION-CD           TO S2-OPTION-CD            
              END-IF                                                    
           END-IF.                                                      
           IF SEB-DATABASE OR WS-COMPANY-NO EQUAL WS-PSNC               
              MOVE WS-NO                     TO S2-STEP-RATE-FLG        
              MOVE WS-ZERO                   TO WS-BLOCKS-COUNT         
              IF WS-DATE-BILLED GREATER THAN SPACES                     
                 PERFORM 7290-STEP-RATE       THRU 7290-EXIT            
                 IF WS-BLOCKS-COUNT GREATER THAN WS-ONE                 
                    MOVE WS-YES              TO S2-STEP-RATE-FLG        
                 ELSE                                                   
                    MOVE WS-NO               TO S2-STEP-RATE-FLG        
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2545-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ****************************************************************          
      * 2546-GET-RATE-DESC.                                          *          
      ****************************************************************          
       2546-GET-RATE-DESC.                                              
                                                                        
           PERFORM 7260-SELECT-RATE-DESC      THRU 7260-EXIT            
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
              ADD +1                         TO WS-INDX-COUNT           
              SET WS-RATE-INDX               TO WS-INDX-COUNT           
              MOVE RD-CODE-UTIL-TYPE         TO                         
                                         WS-UTIL-TYPE-CODE(WS-RATE-INDX)
              MOVE RD-RATE-PLAN-NO           TO                         
                                         WS-RATE-PLAN-NO(WS-RATE-INDX)  
              MOVE RD-RATE-DESC              TO                         
                                         WS-RATE-DESC(WS-RATE-INDX)     
              MOVE RD-RATE-DEFINITION-CD     TO                         
                                         WS-RATE-DEF-CD(WS-RATE-INDX)   
           END-IF.                                                      
      *                                                                         
       2546-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2548-GET-FCTR-DTL.                                             *        
      *     OBTAINS AND SENDS THE METERED CONSUMPTION DATA             *        
      ******************************************************************        
       2548-GET-FCTR-DTL.                                               
      *                                                                         
           PERFORM 7120-OPEN-FH-CURSOR        THRU 7120-EXIT.           
           PERFORM 7130-FETCH-FH-ROW          THRU 7130-EXIT.           
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE        TO S4-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE WS-NO                     TO END-OF-FH-SW            
              PERFORM 2549-PROCESS-FH-CURSOR  THRU 2549-EXIT            
                   UNTIL NO-MORE-FACTOR-RECS                            
           END-IF                                                       
                                                                        
           PERFORM 7140-CLOSE-FH-CURSOR       THRU 7140-EXIT.           
      *                                                                         
       2548-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 2549-PROCESS-FH-CURSOR.                                        *        
      *     OBTAINS AND SENDS THE METERED CONSUMPTION DATA             *        
      ******************************************************************        
       2549-PROCESS-FH-CURSOR.                                          
      *                                                                         
           PERFORM 2655-MOVE-N-INSERT-S4-VALUES                         
                                              THRU 2655-EXIT.           
           PERFORM 7130-FETCH-FH-ROW          THRU 7130-EXIT.           
      *                                                                         
       2549-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2550-FETCH-CNSMPTN-DETAILS.                                    *        
      *     OBTAINS AND SENDS THE METERED CONSUMPTION DATA             *        
      ******************************************************************        
       2550-FETCH-CNSMPTN-DETAILS.                                      
      *                                                                         
           MOVE ZEROES                       TO WS-TOT-UTILITY          
                                                WS-TOT-BILL-USAGE       
                                                WS-TOT-READ-USAGE       
                                                WS-AVG-COST-PER-USG     
                                                WS-AVG-COST-PER-DAY     
                                                WS-AVG-USG-PER-DAY      
                                                WS-ACCUM-UNITS-TP       
                                                WS-ACCUM-NO-UNITS.      
           MOVE SPACES                       TO WS-REG-TYPE-CD          
                                                WS-CODE-USAGE-TYPE.     
           IF BG-CODE-UTIL-TYPE EQUAL 'E' OR 'G'                        
              PERFORM 7220-CUST-PLAN-EXISTS   THRU 7220-EXIT            
                                                                        
              IF WS-UNMTRD-ELEC-GAS = WS-NO                             
                 PERFORM 2570-PROCESS-CX-CURSOR                         
                                              THRU 2570-EXIT            
              END-IF                                                    
                                                                        
           END-IF.                                                      
      *                                                                         
       2550-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2570-PROCESS-CX-CURSOR.                                        *        
      ******************************************************************        
       2570-PROCESS-CX-CURSOR.                                          
      *                                                                         
           PERFORM 7090-OPEN-CX-CURSOR        THRU 7090-EXIT.           
           PERFORM 7100-FETCH-CX-ROW          THRU 7100-EXIT.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE CX-DATE-READ              TO WS-DATE-READ            
              MOVE CX-METER-NO               TO WS-METER-NO             
              MOVE CX-METER-READING          TO WS-METER-READING        
              MOVE CX-CODE-METER-READ        TO WS-CODE-MTR-READ        
              MOVE CX-REG-ID-NO              TO WS-REG-ID-COMP          
              MOVE CX-MTR-REF-NO             TO WS-MTR-REF-COMP         
              MOVE CX-CODE-TIME-PERIOD       TO WS-TP-COMP              
              MOVE SPACES                    TO WS-DATE-READ-COMPARE    
              MOVE ZEROES                    TO WS-ACCUM-NO-UNITS       
                                                WS-ACCUM-NO-KVA         
                                                WS-ACCUM-NO-DAYS        
                                                WS-ACCUM-UNITS-TP       
              PERFORM 2580-ACCUM-NO-DAYS      THRU 2580-EXIT            
              UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                   
              IF WS-NO-OF-DAYS = 0                                      
                 MOVE WS-ACCUM-NO-DAYS       TO WS-NO-OF-DAYS           
              END-IF                                                    
      ******************************************************************        
      * NOTE: MULT-MTR-REG-FLG VALUE IS USED IN CHECK READ SCREEN FOR           
      *       VALIDATION. THIS INFO IS REQUIRED ONLY FOR LATEST BILLED          
      *       ROW. SO, WE ARE CHECKING FOR ANY MULTIPLE METERS/REGISTERS        
      *       PRESENT FOR ALL IC'S PRESENT UNDER ELECTRIC UTIL TYPE FOR         
      *       THE LATEST BILL ALONE AND USING THE SAME VALUE FOR OTHER          
      *       BILLS.                                                            
      ******************************************************************        
              IF WS-FIRST-TIME-PROCESS EQUAL   WS-YES                   
                 AND BG-CODE-UTIL-TYPE EQUAL   'E'                      
                 AND CX-METER-NO       GREATER SPACES                   
                 PERFORM 2595-CHK-MULT-REG-MTR                          
                                           THRU 2595-EXIT               
              END-IF                                                    
              IF WS-METER-NO EQUAL 'CHANGE'                             
                 MOVE WS-YES              TO WS-MULT-MTR-REG-FLG        
              END-IF                                                    
      ******************************************************************        
              PERFORM 2585-PROCESS-BZ-CURSOR  THRU 2585-EXIT            
           ELSE                                                         
              MOVE ZEROES                    TO WS-METER-READING        
              MOVE SPACES                    TO WS-CODE-MTR-READ        
                                                WS-DATE-READ            
                                                WS-METER-NO             
           END-IF.                                                      
           PERFORM 7110-CLOSE-CX-CURSOR       THRU 7110-EXIT.           
      *                                                                         
       2570-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *2580-ACCUM-NO-DAYS.                                                      
      ****************************************************************          
       2580-ACCUM-NO-DAYS.                                              
      *                                                                         
           IF (CX-CODE-USAGE-TYPE = 'B' OR 'C')                         
              AND CX-MTR-REF-NO    = WS-MTR-REF-COMP                    
              AND CX-CODE-TIME-PERIOD = 0                               
              AND CX-CODE-DEBIT-CREDIT = 'D'                            
              ADD CX-NO-DAYS                 TO WS-ACCUM-NO-DAYS        
              MOVE CX-MTR-REF-NO             TO WS-MTR-REF-COMP         
           END-IF.                                                      
                                                                        
           IF (CX-CODE-USAGE-TYPE = 'B' OR 'C')                         
             AND CX-CODE-TIME-PERIOD = 0                                
             IF CX-CODE-DEBIT-CREDIT = 'C'                              
                SUBTRACT CX-NO-UNITS         FROM WS-ACCUM-NO-UNITS     
             ELSE                                                       
                ADD CX-NO-UNITS              TO WS-ACCUM-NO-UNITS       
             END-IF                                                     
           END-IF.                                                      
                                                                        
           IF CX-CODE-USAGE-TYPE = 'B'                                  
             AND CX-CODE-TIME-PERIOD > 0                                
             AND CX-CODE-TOU-SEASN   = 'C'                              
               ADD CX-NO-UNITS               TO WS-ACCUM-UNITS-TP       
           END-IF.                                                      
                                                                        
           IF ((CX-CODE-USAGE-TYPE = 'E' OR 'J')                        
             AND CX-DATE-READ NOT = WS-DATE-READ-COMPARE)               
             AND CX-MTR-REF-NO    = WS-MTR-REF-COMP                     
             AND CX-REG-ID-NO     = WS-REG-ID-COMP                      
             AND CX-CODE-TIME-PERIOD = WS-TP-COMP                       
              MOVE CX-NO-DEMAND-UNITS        TO WS-ACCUM-NO-KVA         
              MOVE CX-DATE-READ              TO WS-DATE-READ-COMPARE    
              MOVE CX-MTR-REF-NO             TO WS-MTR-REF-COMP         
              MOVE CX-REG-ID-NO              TO WS-REG-ID-COMP          
              MOVE CX-CODE-TIME-PERIOD       TO WS-TP-COMP              
           END-IF.                                                      
                                                                        
           IF CX-METER-NO NOT EQUAL WS-METER-NO                         
              MOVE 'CHANGE'                  TO WS-METER-NO             
           END-IF.                                                      
                                                                        
           PERFORM 7100-FETCH-CX-ROW          THRU  7100-EXIT.          
      *                                                                         
       2580-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2585-PROCESS-BZ-CURSOR.                                        *        
      ******************************************************************        
       2585-PROCESS-BZ-CURSOR.                                          
      *                                                                         
           PERFORM 7060-OPEN-BZ-CURSOR        THRU 7060-EXIT.           
           PERFORM 7070-FETCH-BZ-ROW          THRU 7070-EXIT.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE BZ-CONSUMPT-TYPE-CD       TO WS-CODE-USAGE-TYPE      
              PERFORM 2590-PROCESS-BZ-CURSOR  THRU 2590-EXIT            
                UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                 
           ELSE                                                         
              IF WS-ACCUM-UNITS-TP > 0                                  
                MOVE WS-ACCUM-UNITS-TP       TO WS-TOT-READ-USAGE       
              ELSE                                                      
                MOVE WS-ACCUM-NO-UNITS       TO WS-TOT-READ-USAGE       
              END-IF                                                    
                                                                        
              IF WS-TOT-READ-USAGE NOT = 0                              
                MOVE WS-TOT-READ-USAGE       TO WS-TOT-BILL-USAGE       
                IF BG-BTU-FACTOR NOT = 0 AND BG-CODE-UTIL-TYPE = 'G'    
                   COMPUTE WS-TOT-BILL-USAGE = WS-TOT-READ-USAGE *      
                                               BG-BTU-FACTOR            
                END-IF                                                  
              END-IF                                                    
                                                                        
              IF BG-CODE-DR-CR-CNSMPTN = 'C'                            
                 COMPUTE WS-TOT-UTILITY = BG-AMT-BILL-ITEM * -1         
              END-IF                                                    
                                                                        
              IF WS-NO-OF-DAYS         > 0                              
                 COMPUTE WS-AVG-COST-PER-DAY ROUNDED                    
                                             = WS-TOT-UTILITY /         
                                               WS-NO-OF-DAYS            
                 COMPUTE WS-AVG-USG-PER-DAY ROUNDED                     
                                             = WS-TOT-BILL-USAGE /      
                                               WS-NO-OF-DAYS            
              END-IF                                                    
                                                                        
              IF WS-DATE-READ > SPACES                                  
                 PERFORM 2600-MOVE-N-INSERT-S2-VALUES                   
                                              THRU 2600-EXIT            
              END-IF                                                    
              MOVE ZEROES                    TO WS-AMT-TAXES            
                                                WS-CITY-TAX-AMT         
                                                WS-STATE-TAX-AMT        
                                                WS-SPCDDC-CHARGE-RESULT 
           END-IF.                                                      
           PERFORM 7080-CLOSE-BZ-CURSOR       THRU 7080-EXIT.           
      *                                                                         
       2585-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2590-PROCESS-BZ-CURSOR                                         *        
      *     OBTAINES AND SENDS THE METERD CONSUMPTION DATA.            *        
      ******************************************************************        
       2590-PROCESS-BZ-CURSOR.                                          
      *                                                                         
           IF BZ-BILL-UNITS NOT NUMERIC                                 
              MOVE ZEROES                    TO BZ-BILL-UNITS           
           END-IF.                                                      
                                                                        
           IF BZ-BILLED-COMP-AM NOT NUMERIC                             
              MOVE ZEROES                    TO BZ-BILLED-COMP-AM       
           END-IF.                                                      
                                                                        
           IF WS-NULL-CHRG = -1                                         
              MOVE ZEROES                    TO BZ-CALC-COMP-AM         
           END-IF.                                                      
                                                                        
           IF WS-NULL-PRICE = -1                                        
              MOVE ZEROES                    TO BZ-UNIT-PRICE-AM        
           END-IF.                                                      
                                                                        
           ADD BZ-UNIT-PRICE-AM              TO WS-UNIT-PRICE-AMT.      
           ADD BZ-BILLED-COMP-AM             TO WS-AMT-BILL-ITEM.       
           ADD BZ-CALC-COMP-AM               TO WS-TOT-COST.            
                                                                        
           IF BZ-CONSUMPT-TYPE-CD = 'B' OR 'C'                          
              IF WS-CODE-USAGE-TYPE = BZ-CONSUMPT-TYPE-CD               
                 IF(BZ-CMPNT-ID-CD NOT EQUAL '70' AND                   
                    BZ-CMPNT-ID-CD NOT EQUAL '71')                      
                    ADD BZ-BILL-UNITS        TO WS-TOT-BILL-USAGE       
                    ADD BZ-READ-UNITS        TO WS-TOT-READ-USAGE       
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF BZ-CONSUMPT-TYPE-CD  = 'B'  OR                            
             (BZ-CONSUMPT-TYPE-CD  = 'C'  AND                           
              BZ-INSTR-USE-TYPE-CD = 'R')                               
      ****COMMENTED SINCE INDUSTRIAL WITH HIGH USAGE COMES UNDER SECURED        
      ****RATE ONLY HAS CONSUMPT-TYPE = D AND THOSE ACCTS NOT ELIGIBLE          
      ****FOR BILL COMPARE CHECK                                                
      *      (BZ-CONSUMPT-TYPE-CD  = 'D'  AND                                   
      *       BZ-INSTR-USE-TYPE-CD = 'R')                                       
              ADD BZ-WNA-COMP-AM             TO WS-WNA-AMOUNT           
           END-IF.                                                      
                                                                        
           PERFORM 7070-FETCH-BZ-ROW          THRU 7070-EXIT.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL  NOT-FOUND                   
              COMPUTE WS-TOT-UTILITY         = WS-AMT-BILL-ITEM         
                                             + WS-AMT-TAXES             
                                                                        
*******   FOR 2PART RATE ACCOUNTS, ADDTIONAL DDC FACTOR WILL BE > 0.            
*******   ADD ADDITIONAL DDC CHARGE WITH CALC-COMP-AMT                          
*******   COMMENTED ON 03/21. WILL REMOVE AFTER CONFIRMED WITH JIJU             
              IF WS-SPCDDC-CHARGE > 0                                   
                 COMPUTE WS-TOT-COST         = WS-TOT-COST              
                                             + WS-SPCDDC-CHARGE         
                 MOVE ZEROES                 TO WS-SPCDDC-CHARGE        
              END-IF                                                    
                                                                        
*******   CALCULATE THE AVERAGE COST PER UNIT                                   
              IF WS-TOT-BILL-USAGE NOT EQUAL ZEROES                     
                 COMPUTE WS-AVG-COST-PER-USG ROUNDED =                  
                                  WS-TOT-COST / WS-TOT-BILL-USAGE       
              ELSE                                                      
                 MOVE ZERO                   TO WS-AVG-COST-PER-USG     
              END-IF                                                    
                                                                        
              IF WS-NO-OF-DAYS         > 0                              
                 COMPUTE WS-AVG-COST-PER-DAY ROUNDED                    
                                             = WS-TOT-UTILITY /         
                                               WS-NO-OF-DAYS            
                 COMPUTE WS-AVG-USG-PER-DAY ROUNDED                     
                                             = WS-TOT-BILL-USAGE /      
                                               WS-NO-OF-DAYS            
              END-IF                                                    
                                                                        
              IF WS-DATE-READ > SPACES                                  
                 PERFORM 2600-MOVE-N-INSERT-S2-VALUES                   
                                              THRU 2600-EXIT            
              END-IF                                                    
              MOVE ZEROES                    TO WS-AMT-TAXES            
                                                WS-CITY-TAX-AMT         
                                                WS-STATE-TAX-AMT        
                                                WS-AMT-BILL-ITEM        
                                                WS-TOT-COST             
                                                WS-UNIT-PRICE-AMT       
                                                WS-WNA-AMOUNT           
                                                WS-BFC-CHARGE           
                                                WS-BFC-CHARGE-DBT       
                                                WS-BFC-CHARGE-CRD       
                                                WS-SPCDDC-CHARGE-RESULT 
                                                WS-DDC-FACTOR           
                                                WS-SPCDDC-CHARGE        
              MOVE SPACES                    TO WS-DATE-READ            
              MOVE WS-NO                     TO WS-CSC-ADJ-EXIST        
              MOVE NOT-FOUND                 TO WS-ACTIVE-RETURN-CODE   
           END-IF.                                                      
      *                                                                         
       2590-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2595-CHK-MULT-REG-MTR.                                         *        
      *     CHECK IF MULTIPLE REGISTER EXIST FOR THE METER             *        
      ******************************************************************        
       2595-CHK-MULT-REG-MTR.                                           
      *                                                                         
           MOVE WS-NO                        TO WS-MULT-MTR-REG-FLG.    
           MOVE CX-METER-NO                  TO MN-METER-NO.            
           MOVE CX-ACCOUNT-NO                TO MN-ACCOUNT-NO.          
           MOVE BG-CODE-UTIL-TYPE            TO MN-CODE-UTIL-TYPE.      
           MOVE CX-MTR-REF-NO                TO MN-MTR-REF-NO.          
           MOVE CX-IC-NO                     TO MN-IC-NO.               
      *                                                                         
           PERFORM 7285-SELECT-METER-READ-ENVRMNT                       
                                              THRU 7285-EXIT.           
      *                                                                         
       2595-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2597-GET-FACTOR-VALUE.                                         *        
      *     OBTAINS FACTOR VALUE                                       *        
      ******************************************************************        
       2597-GET-FACTOR-VALUE.                                           
      *                                                                         
           MOVE WS-NO                        TO WS-FACTOR-VAL-EXIST.    
           MOVE 0                            TO WS-FACTOR               
                                                WS-SUM-FACTOR.          
                                                                        
           PERFORM 7230-OPEN-FACTOR-VAL-DET  THRU 7230-EXIT.            
           PERFORM 7231-FETCH-FACTOR-VAL-DET THRU 7231-EXIT.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE WS-YES                    TO WS-FACTOR-VAL-EXIST     
              MOVE WS-NO                     TO END-OF-FCTR-VAL-SW      
              PERFORM 2598-PRCS-FACTOR-VAL-CURSOR  THRU 2598-EXIT       
                   UNTIL NO-MORE-FCTR-VAL-RCS                           
           END-IF.                                                      
      *                                                                         
           PERFORM 7232-CLOSE-FACTOR-VAL-DET  THRU 7232-EXIT.           
      *                                                                         
       2597-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2598-PRCS-FACTOR-VAL-CURSOR.                                *           
      *     SUM FACTOR VALUE                                           *        
      ******************************************************************        
       2598-PRCS-FACTOR-VAL-CURSOR.                                     
      *                                                                         
           IF FH-FCTR-POWER-10  NOT EQUAL 0                             
              COMPUTE WS-FACTOR = FH-FACTOR * 10**FH-FCTR-POWER-10      
              MOVE 0                      TO FH-FCTR-POWER-10           
           ELSE                                                         
              COMPUTE WS-FACTOR = FH-FACTOR                             
           END-IF.                                                      
                                                                        
           COMPUTE WS-SUM-FACTOR = WS-SUM-FACTOR + WS-FACTOR.           
                                                                        
           PERFORM 7231-FETCH-FACTOR-VAL-DET THRU 7231-EXIT.            
      *                                                                         
       2598-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2600-MOVE-N-INSERT-S2-VALUES.                                  *        
      *     MOVE BILLING DETAIL VALUES FOR FURTHER PROCESS             *        
      ******************************************************************        
       2600-MOVE-N-INSERT-S2-VALUES.                                    
      *                                                                         
           MOVE BG-CODE-UTIL-TYPE            TO S2-CODE-UTIL-TYPE       
           MOVE BG-IC-NO                     TO S2-IC-NO                
           MOVE WS-DATE-READ                 TO S2-DATE-READ            
           MOVE WS-METER-NO                  TO S2-METER-NO             
           IF   WS-METER-NO = 'CHANGE'                                  
              MOVE ZERO                      TO S2-METER-NO             
           END-IF                                                       
           MOVE WS-CODE-MTR-READ             TO S2-CODE-MTR-READ        
           MOVE WS-METER-READING             TO S2-METER-READING        
           MOVE WS-TOT-UTILITY               TO S2-TOT-UTILITY          
           MOVE WS-TOT-BILL-USAGE            TO S2-TOT-USAGE            
           MOVE WS-TOT-READ-USAGE            TO S2-READ-UNITS           
           MOVE WS-UNIT-PRICE-AMT            TO S2-UNIT-PRICE-AMT       
           MOVE WS-TOT-COST                  TO S2-CALC-COMP-AMT        
           MOVE WS-BFC-CHARGE                TO S2-BFC-CHARGE           
           MOVE WS-CSC-ADJ-EXIST             TO S2-CSC-ADJ-EXIST        
           MOVE WS-TOTAL-CHARGES-CREDIT      TO S2-TOTAL-CHARGES-CREDIT 
           MOVE WS-DDC-FACTOR                TO S2-DDC-FACTOR           
           MOVE WS-WNA-AMOUNT                TO S2-WNA-AMOUNT           
      *                                                                         
           IF WS-COMPANY-NO     = WS-CIG  AND                           
              WS-WNA-AMOUNT     = 0       AND                           
              BG-WNA-FACTOR NOT = 0                                     
              COMPUTE S2-WNA-AMOUNT ROUNDED  =  BG-WNA-FACTOR *         
                             (WS-TOT-BILL-USAGE - BG-GAS-BASE-USE)      
           END-IF                                                       
      *                                                                         
           MOVE WS-SPCDDC-CHARGE-RESULT      TO S2-SPC-DDC-CHARGE       
      *                                                                         
           MOVE WS-AVG-COST-PER-USG          TO S2-AVG-COST-PER-USG     
           MOVE WS-AVG-COST-PER-DAY          TO S2-AVG-COST-PER-DAY     
           MOVE WS-NO-OF-DAYS                TO S2-NO-OF-DAYS           
           MOVE WS-AVG-USG-PER-DAY           TO S2-AVG-USG-PER-DAY      
           MOVE WS-STATE-TAX-AMT             TO S2-STATE-TAX-AMT        
           MOVE WS-CITY-TAX-AMT              TO S2-CITY-TAX-AMT         
      *                                                                         
           IF WS-MULT-MTR-REG-FLG GREATER SPACES                        
              MOVE WS-MULT-MTR-REG-FLG       TO S2-MULT-MTR-REG-FLG     
           END-IF                                                       
                                                                        
           PERFORM 8020-INSERT-GTT-R2         THRU 8020-EXIT.           
      *                                                                         
       2600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2650-MOVE-N-INSERT-S3-VALUES.                                  *        
      *     MOVE BILLING DETAIL VALUES FOR GUIDANCE PROCESS            *        
      ******************************************************************        
       2650-MOVE-N-INSERT-S3-VALUES.                                    
      *                                                                         
           INITIALIZE WS-BILL-ANLYS-INPUT-PARMS.                        
                                                                        
           MOVE WS-ACCOUNT-NO                TO WS-4638-ACCOUNT-NO.     
           MOVE WS-COMPANY-NO                TO WS-4638-COMPANY-NO.     
           MOVE WS-CODE-UTIL-TYPE            TO WS-4638-CODE-UTIL-TYPE. 
           MOVE S2-BILL-NO                   TO WS-4638-BILL-NO.        
           MOVE BG-IC-NO                     TO WS-4638-IC-NO.          
           MOVE BG-RATE-PLAN-NO              TO WS-4638-RATE-PLAN-NO.   
           MOVE WS-DATE-BILLED               TO WS-4638-BILLED-DATE.    
           MOVE WS-HOLD-REV-MM               TO WS-4638-BILLING-MONTH.  
           MOVE CX-CODE-METER-READ           TO WS-4638-CODE-METER-READ.
           MOVE BG-CODE-BILL-ITM-IND         TO WS-4638-CD-BILL-ITM-IND.
           MOVE S2-BILL-ITEM-TIMESTMP        TO                         
                                            WS-4638-BILL-ITEM-TIMESTAMP.
           MOVE BG-CODE-BILL-ITM-TYPE        TO                         
                                            WS-4638-CD-BILL-ITM-TYPE.   
                                                                        
           PERFORM 6000-START-BILL-ANLYS-VLDT THRU 6000-EXIT.           
                                                                        
           PERFORM VARYING WS-ERR-MSG-INDX FROM 1 BY 1 UNTIL            
                WS-4638-BUS-RULE-ID(WS-ERR-MSG-INDX) <= SPACES          
                                                                        
              MOVE WS-4638-BUS-RULE-ID(WS-ERR-MSG-INDX)                 
                                             TO S3-RULE-ID              
              MOVE WS-4638-BUS-RULE-RESULT-CD(WS-ERR-MSG-INDX)          
                                             TO S3-RULE-RESULT-CD       
              MOVE WS-4638-BUS-RULE-XREF-ID(WS-ERR-MSG-INDX)            
                                             TO S3-BUS-RULE-XREF-ID     
              MOVE WS-4638-BUS-RULE-MESSAGE-PARMS(WS-ERR-MSG-INDX)      
                                             TO S3-MESSAGE-PARMS        
              MOVE WS-4638-BUS-RULE-LINK-PARMS(WS-ERR-MSG-INDX)         
                                             TO S3-LINK-PARMS           
              IF S3-RULE-ID EQUAL WS-BUSRUL-HOME-ENERGY-CHECKUP         
                               OR WS-BUSRUL-PEND-FINAL-EXIST            
                 MOVE SPACES                 TO S3-DATE-BILLED          
                                                S3-CODE-UTIL-TYPE       
                 MOVE 0                      TO S3-BILLING-MONTH        
                                                S3-IC-NO                
              ELSE                                                      
                 MOVE WS-4638-BILLED-DATE    TO S3-DATE-BILLED          
                 MOVE WS-4638-CODE-UTIL-TYPE TO S3-CODE-UTIL-TYPE       
                 MOVE WS-4638-BILLING-MONTH  TO S3-BILLING-MONTH        
                 MOVE WS-4638-IC-NO          TO S3-IC-NO                
              END-IF                                                    
              PERFORM 8030-INSERT-GTT-R3      THRU 8030-EXIT            
           END-PERFORM.                                                 
      *                                                                         
       2650-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2655-MOVE-N-INSERT-S4-VALUES.                                  *        
      *     MOVE BILLING FACTOR DETAILS FOR EACH BILLING DETAILS.      *        
      ******************************************************************        
       2655-MOVE-N-INSERT-S4-VALUES.                                    
      *                                                                         
           MOVE FH-CODE-UTIL-TYPE            TO S4-CODE-UTIL-TYPE.      
           MOVE FH-IC-NO                     TO S4-IC-NO.               
           MOVE FH-BILL-NO                   TO S4-BILL-NO.             
           MOVE WS-DATE-BILLED               TO S4-DATE-BILLED.         
           MOVE WS-HOLD-REV-MM               TO S4-BILLING-MONTH.       
           MOVE FH-BILL-ITEM-TIMESTMP        TO S4-BILL-ITEM-TIMESTMP.  
           MOVE FH-FACTOR-ID                 TO S4-FACTOR-ID            
                                                WS-VOLUMETRIC-FACTORS.  
      *                                                                         
           IF FH-CODE-DEBIT-CREDIT = SPACES                             
              MOVE 'D'                       TO FH-CODE-DEBIT-CREDIT    
           END-IF.                                                      
           MOVE FH-CODE-DEBIT-CREDIT         TO S4-CODE-DEBIT-CREDIT.   
      *                                                                         
           IF VOLUMETRIC-FACTORS                                        
              COMPUTE FH-FACTOR = FH-FACTOR * FH-BILL-UNITS             
           END-IF.                                                      
           MOVE FH-FACTOR                    TO S4-FACTOR.              
           IF FH-CODE-DEBIT-CREDIT = 'C'                                
              COMPUTE S2-AGL-CHARGE = S2-AGL-CHARGE - FH-FACTOR         
           ELSE                                                         
              COMPUTE S2-AGL-CHARGE = S2-AGL-CHARGE + FH-FACTOR         
           END-IF.                                                      
      *                                                                         
           IF PARM-GET-FACTOR-DTLS = 'Y'                                
              PERFORM 8040-INSERT-GTT-R4      THRU 8040-EXIT            
           END-IF.                                                      
      *                                                                         
       2655-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2660-MOVE-N-INSERT-S5-VALUES.                                  *        
      *     MOVE WEATHER SERVICE DIVISION                              *        
      ******************************************************************        
       2660-MOVE-N-INSERT-S5-VALUES.                                    
      *                                                                         
           MOVE WS-WEATHER-SRVC-DIV          TO S5-WEATHER-SRVC-DIV     
                                                                        
           PERFORM 8050-INSERT-GTT-R5         THRU 8050-EXIT.           
      *                                                                         
       2660-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO OPEN THE CURSOR USED TO FETCH     **        
      **  ROWS FROM THE CSS_BILLING_HDR TABLE.                        **        
      ******************************************************************        
       7000-OPEN-BI-CURSOR.                                             
      *                                                                         
           EXEC SQL                                                     
               OPEN BI-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE '7000'                   TO ACTIVE-PARAGRAPH        
               MOVE 'OPEN'                   TO ABEND-FUNCTION          
               MOVE SPACES                   TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
               MOVE 'CSS_BILLING_HDR  '      TO TABLE-1                 
               MOVE 'ACCOUNT_NO  '           TO TABLE-ELEMENT-1         
               MOVE BI-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1       
               PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO OBTAIN THE NEXT ROW FROM THE      **        
      **  CSS_BILLING_HDR TABLE WHERE THE ACCOUNT NUMBER IS EQUAL TO  **        
      **  THE ACCOUNT NUMBER PASSED TO THIS PROGRAM VIA THE           **        
      **  COMMUNICATION AREA ACCOUNT NUMBER.                          **        
      ******************************************************************        
       7010-FETCH-BI-ROW.                                               
      *                                                                         
           EXEC SQL                                                     
               FETCH BI-CURSOR                                          
                INTO :BI-BILL-NO                                        
                    ,:BI-DATE-BILLED :WS-NULL-IND-1                     
                    ,:BI-CODE-BILL-TYPE                                 
                    ,:BI-CODE-BILL-STATUS                               
                    ,:BI-TOT-OTHER-CHARGES                              
                    ,:BI-TOTAL-ARREARS                                  
                    ,:BI-COMPANY-NO                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE     = SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-NULL-IND-1      < 0                                 
                 MOVE SPACES                 TO BI-DATE-BILLED          
              END-IF                                                    
              IF WS-ACTIVE-RETURN-CODE  = NOT-FOUND                     
                  MOVE WS-YES                TO END-OF-BI-SW            
                                                END-OF-BG-SW            
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7010'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_BILLING_HDR  '       TO TABLE-1                 
              MOVE 'ACCOUNT_NO  '            TO TABLE-ELEMENT-1         
              MOVE BI-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO CLOSE THE CURSOR USED TO FETCH    **        
      **  ROWS FROM THE CSS_BILLING_HDR TABLE.                        **        
      ******************************************************************        
       7020-CLOSE-BI-CURSOR.                                            
      *                                                                         
           EXEC SQL                                                     
               CLOSE BI-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7020'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_BILLING_HDR  '       TO TABLE-1                 
              MOVE 'ACCOUNT_NO  '            TO TABLE-ELEMENT-1         
              MOVE BI-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO OPEN THE CURSOR USED TO FETCH     **        
      **  ROWS FROM THE CSS_BILLING_DET TABLE.                        **        
      ******************************************************************        
       7030-OPEN-BG-CURSOR.                                             
      *                                                                         
           EXEC SQL                                                     
               OPEN BG-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7030'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_BILLING_DET  '       TO TABLE-1                 
              MOVE 'BILL_NO  '               TO TABLE-ELEMENT-1         
              MOVE 'ACCOUNT_NO  '            TO TABLE-ELEMENT-2         
              MOVE BI-BILL-NO                TO HOSTVAR-ELEMENT-1       
              MOVE BG-ACCOUNT-NO             TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT
           END-IF.           
      *                                                                         
       7030-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO OBTAIN THE NEXT ROW FROM THE      **        
      **  CSS_BILLING_DET TABLE WHERE THE ACCOUNT NUMBER IS EQUAL TO  **        
      **  THE ACCOUNT NUMBER PASSED TO THIS PROGRAM VIA THE           **        
      **  COMMUNICATION AREA ACCOUNT NUMBER AND THE BILL NUMBER IS    **        
      **  EQUAL THE CURRENT CSS_BILLING_HDR ROW BILL NUMBER.          **        
      ******************************************************************        
       7040-FETCH-BG-ROW.                                               
      *                                                                         
           EXEC SQL                                                     
               FETCH BG-CURSOR                                          
               INTO :BG-CODE-UTIL-TYPE                                  
                   ,:BG-IC-NO                                           
                   ,:BG-AMT-BILL-ITEM                                   
                   ,:BG-AMT-STATE-TAX                                   
                   ,:BG-AMT-CITY-TAX                                    
                   ,:BG-AMT-OTHER-TAX                                   
                   ,:BG-CODE-REVENUE-CLASS                              
                   ,:BG-CODE-BILL-CALC                                  
                   ,:BG-CODE-BILL-ITM-IND                               
                   ,:BG-CODE-BILL-ITM-TYPE                              
                   ,:BG-CODE-DR-CR-CNSMPTN                              
                   ,:BG-RATE-PLAN-NO                                    
                   ,:BG-BILL-ITEM-TIMESTMP                              
                   ,:BG-REVENUE-MONTH                                   
                   ,:BG-DATE-ORIG-BILL :WS-NULL-IND-2                   
                   ,:BG-WNA-FACTOR                                      
                   ,:BG-BTU-FACTOR                                      
                   ,:BG-ACCOUNT-NO                                      
                   ,:BG-BILL-NO                                         
                   ,:BG-NO-OF-CONS-DAYS                                 
                   ,:BG-REV-RPT-CD                                      
                   ,:BG-RT-PKG-OPT-SEQ-NO                               
                   ,:BG-REV-MTH-ORIG-BILL                               
                   ,:BG-GAS-BASE-USE                                    
ACT056             ,:RD-RATE-SUB-GRP-TYPE                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-NULL-IND-2 < 0                                      
                 MOVE SPACES                 TO BG-DATE-ORIG-BILL       
              END-IF                                                    
              IF WS-ACTIVE-RETURN-CODE  = NOT-FOUND                     
                 MOVE WS-YES                 TO END-OF-BG-SW            
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7040'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_BILLING_DET  '       TO TABLE-1                 
              MOVE 'ACCOUNT_NO  '            TO TABLE-ELEMENT-1         
              MOVE 'BILL_NO  '               TO TABLE-ELEMENT-2         
              MOVE BG-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE BI-BILL-NO                TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT
           END-IF.           
      *                                                                         
       7040-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO CLOSE THE CURSOR USED TO FETCH    **        
      **  ROWS FROM THE CSS_BILLING_DET TABLE.                        **        
      ******************************************************************        
       7050-CLOSE-BG-CURSOR.                                            
      *                                                                         
           EXEC SQL                                                     
               CLOSE BG-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7050'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_BILLING_DET  '       TO TABLE-1                 
              MOVE 'ACCOUNT_NO  '            TO TABLE-ELEMENT-1         
              MOVE 'BILL_NO  '               TO TABLE-ELEMENT-2         
              MOVE BG-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE BI-BILL-NO                TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT
           END-IF.           
      *                                                                         
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO OPEN THE CURSOR TO                **        
      **  CSS_BILL_CALC_DET TABLE.                                    **        
      ******************************************************************        
       7060-OPEN-BZ-CURSOR.                                             
      *                                                                         
           EXEC SQL                                                     
               OPEN BZ-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7060'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_BILL_CALC_DET'       TO TABLE-1                 
              MOVE 'ACCOUNT_NO  '            TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE 'BILL_NO'                 TO TABLE-ELEMENT-3         
              MOVE 'IC_NO'                   TO TABLE-ELEMENT-4         
              MOVE BZ-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE BZ-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              MOVE BZ-BILL-NO                TO HOSTVAR-ELEMENT-3       
              MOVE BZ-IC-NO                  TO HOSTVAR-ELEMENT-4       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT
           END-IF.           
      *                                                                         
       7060-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  THIS PARAGRAPH FETCHES THE PAYMENT ROWS FROM THE            **        
      **  CSS_BILL_CALC_DET TABLE FOR A GIVEN ACCOUNT NUMBER AND      **        
      **  IC-NO.                                                      **        
      ******************************************************************        
       7070-FETCH-BZ-ROW.                                               
      *                                                                         
           EXEC SQL                                                     
               FETCH BZ-CURSOR                                          
                  INTO :BZ-BILL-UNITS                                   
                      ,:BZ-READ-UNITS                                   
                      ,:BZ-BILLED-COMP-AM                               
                      ,:BZ-CONSUMPT-TYPE-CD                             
                      ,:BZ-CMPNT-ID-CD                                  
                      ,:BZ-CALC-COMP-AM :WS-NULL-CHRG                    
                      ,:BZ-UNIT-PRICE-AM :WS-NULL-PRICE                  
                      ,:BZ-WNA-COMP-AM                                  
                      ,:BZ-INSTR-USE-TYPE-CD                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL OR          
                                            NOT-FOUND                   
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7070'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_BILL_CALC_DET'       TO TABLE-1                 
              MOVE 'ACCOUNT_NO  '            TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE 'BILL_NO'                 TO TABLE-ELEMENT-3         
              MOVE 'IC_NO'                   TO TABLE-ELEMENT-4         
              MOVE BZ-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE BZ-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              MOVE BZ-BILL-NO                TO HOSTVAR-ELEMENT-3       
              MOVE BZ-IC-NO                  TO HOSTVAR-ELEMENT-4       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT
           END-IF.           
      *                                                                         
       7070-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO CLOSE THE CURSOR USED TO FETCH    **        
      **  ROWS FROM THE CSS_BILL_CALC_DET TABLE.                      **        
      ******************************************************************        
       7080-CLOSE-BZ-CURSOR.                                            
      *                                                                         
           EXEC SQL                                                     
               CLOSE BZ-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7080'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_BILL_CALC_DET'       TO TABLE-1                 
              MOVE 'ACCOUNT_NO  '            TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE 'BILL_NO'                 TO TABLE-ELEMENT-3         
              MOVE 'IC_NO'                   TO TABLE-ELEMENT-4         
              MOVE BZ-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE BZ-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              MOVE BZ-BILL-NO                TO HOSTVAR-ELEMENT-3       
              MOVE BZ-IC-NO                  TO HOSTVAR-ELEMENT-4       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT
           END-IF.           
      *                                                                         
       7080-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO OPEN THE CURSOR TO                **        
      **  CSS_CNSMPTN_HIST  TABLE.                                    **        
      ******************************************************************        
       7090-OPEN-CX-CURSOR.                                             
      *                                                                         
           EXEC SQL                                                     
               OPEN CX-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7090'                    TO ACTIVE-PARAGRAPH        
              MOVE '0PEN'                    TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_CNSMPTN_HIST '       TO TABLE-1                 
              MOVE 'ACCOUNT_NO  '            TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE 'BILL_NO'                 TO TABLE-ELEMENT-3         
              MOVE 'IC_NO'                   TO TABLE-ELEMENT-4         
              MOVE CX-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE CX-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              MOVE CX-BILL-NO                TO HOSTVAR-ELEMENT-3       
              MOVE CX-IC-NO                  TO HOSTVAR-ELEMENT-4       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT
           END-IF.           
      *                                                                         
       7090-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  THIS PARAGRAPH FETCHES THE PAYMENT ROWS FROM THE            **        
      **  CSS_CNSMPTN_HIST  TABLE FOR A GIVEN ACCOUNT NUMBER AND      **        
      **  IC-NO.                                                      **        
      ******************************************************************        
       7100-FETCH-CX-ROW.                                               
      *                                                                         
           EXEC SQL                                                     
               FETCH CX-CURSOR                                          
                  INTO :CX-CODE-USAGE-TYPE                              
                      ,:CX-METER-NO                                     
                      ,:CX-DATE-READ :WS-NULL-IND-4                     
                      ,:CX-NO-UNITS                                     
                      ,:CX-NO-DEMAND-UNITS                              
                      ,:CX-NO-DAYS                                      
                      ,:CX-CODE-SOURCE-ID                               
                      ,:CX-CODE-DEBIT-CREDIT                            
                      ,:CX-MTR-REF-NO                                   
                      ,:CX-REG-ID-NO                                    
                      ,:CX-CODE-TOU-SEASN                               
                      ,:CX-CODE-TIME-PERIOD                             
                      ,:CX-CODE-ITEM-STATUS                             
                      ,:CX-CODE-METER-READ                              
                      ,:CX-ACCOUNT-NO                                   
                      ,:CX-METER-READING                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL OR NOT-FOUND
               IF WS-NULL-IND-4 < ZERO                                  
                   MOVE LOW-VALUES           TO CX-DATE-READ            
               END-IF                                                   
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7100'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_CNSMPTN_HIST '       TO TABLE-1                 
              MOVE 'ACCOUNT_NO  '            TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE 'BILL_NO'                 TO TABLE-ELEMENT-3         
              MOVE 'IC_NO'                   TO TABLE-ELEMENT-4         
              MOVE CX-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE CX-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              MOVE CX-BILL-NO                TO HOSTVAR-ELEMENT-3       
              MOVE CX-IC-NO                  TO HOSTVAR-ELEMENT-4       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT
           END-IF.           
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO CLOSE THE CURSOR USED TO FETCH    **        
      **  ROWS FROM THE CSS_CNSMPTN_HIST TABLE.                       **        
      ******************************************************************        
       7110-CLOSE-CX-CURSOR.                                            
      *                                                                         
           EXEC SQL                                                     
               CLOSE CX-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7110'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_CNSMPTN_HIST '       TO TABLE-1                 
              MOVE 'ACCOUNT_NO  '            TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE 'BILL_NO'                 TO TABLE-ELEMENT-3         
              MOVE 'IC_NO'                   TO TABLE-ELEMENT-4         
              MOVE CX-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE CX-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              MOVE CX-BILL-NO                TO HOSTVAR-ELEMENT-3       
              MOVE CX-IC-NO                  TO HOSTVAR-ELEMENT-4       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT
           END-IF.           
      *                                                                         
       7110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO OPEN THE CURSOR TO                **        
      **  CSS_CNSMPTN_HIST  TABLE.                                    **        
      ******************************************************************        
       7120-OPEN-FH-CURSOR.                                             
      *                                                                         
           EXEC SQL                                                     
               OPEN FH-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7120'                    TO ACTIVE-PARAGRAPH        
              MOVE '0PEN'                    TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_FIXED_FCT_HIST'      TO TABLE-1                 
              MOVE 'ACCOUNT_NO  '            TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE 'BILL_NO'                 TO TABLE-ELEMENT-3         
              MOVE 'IC_NO'                   TO TABLE-ELEMENT-4         
              MOVE FH-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE FH-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              MOVE FH-BILL-NO                TO HOSTVAR-ELEMENT-3       
              MOVE FH-IC-NO                  TO HOSTVAR-ELEMENT-4       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT
           END-IF.           
      *                                                                         
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  THIS PARAGRAPH FETCHES THE FACTOR AND ITS DETAILS ATTACHED  **        
      **  TO AP SPCL_GROUP_CD IN CSS_SPCL_FACTOR TABLE                **        
      ******************************************************************        
       7130-FETCH-FH-ROW.                                               
      *                                                                         
           EXEC SQL                                                     
               FETCH FH-CURSOR                                          
                  INTO :FH-FACTOR-ID                                    
                      ,:FH-CODE-DEBIT-CREDIT                            
                      ,:FH-FACTOR :WS-NULL-IND-7                        
                      ,:FH-BILL-UNITS                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL OR NOT-FOUND
               IF WS-NULL-IND-7 < ZERO                                  
                   MOVE ZEROES               TO FH-FACTOR               
               END-IF                                                   
              IF WS-ACTIVE-RETURN-CODE  = NOT-FOUND                     
                 MOVE WS-YES                 TO END-OF-FH-SW            
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7130'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_FIXED_FCT_HIST'      TO TABLE-1                 
              MOVE 'ACCOUNT_NO  '            TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE 'BILL_NO'                 TO TABLE-ELEMENT-3         
              MOVE 'IC_NO'                   TO TABLE-ELEMENT-4         
              MOVE FH-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE FH-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              MOVE FH-BILL-NO                TO HOSTVAR-ELEMENT-3       
              MOVE FH-IC-NO                  TO HOSTVAR-ELEMENT-4       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT
           END-IF.           
      *                                                                         
       7130-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO CLOSE THE CURSOR USED TO FETCH    **        
      **  ROWS FROM THE CSS_FIXED_FCT_HIST TABLE.                     **        
      ******************************************************************        
       7140-CLOSE-FH-CURSOR.                                            
      *                                                                         
           EXEC SQL                                                     
               CLOSE FH-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7140'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_FIXED_FCT_HIST'      TO TABLE-1                 
              MOVE 'ACCOUNT_NO  '            TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE 'BILL_NO'                 TO TABLE-ELEMENT-3         
              MOVE 'IC_NO'                   TO TABLE-ELEMENT-4         
              MOVE FH-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE FH-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              MOVE FH-BILL-NO                TO HOSTVAR-ELEMENT-3       
              MOVE FH-IC-NO                  TO HOSTVAR-ELEMENT-4       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT
           END-IF.           
      *                                                                         
       7140-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7200-GET-REBILL-DET.                                           *        
      *     GET REBILL DETAIL INFO FOR CANCELLED ROW (IF PRESENT)      *        
      ******************************************************************        
       7200-GET-REBILL-DET.                                             
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) BG.CODE_UTIL_TYPE,
              BG.IC_NO,
              BG.AMT_BILL_ITEM,
              BG.AMT_STATE_TAX,
              BG.AMT_CITY_TAX,
              BG.AMT_OTHER_TAX,
              BG.CODE_REVENUE_CLASS,
              BG.CODE_BILL_CALC,
              BG.CODE_BILL_ITM_TYPE,
              BG.CODE_DR_CR_CNSMPTN,
              BG.RATE_PLAN_NO,
              REPLACE(REPLACE(CONVERT(CHAR(26), BG.BILL_ITEM_TIMESTMP
           , 121), ' ', '-'), ':', '.') BILL_ITEM_TIMESTMP,
              BG.REVENUE_MONTH,
              BG.DATE_ORIG_BILL,
              BG.WNA_FACTOR,
              BG.BTU_FACTOR,
              BG.ACCOUNT_NO,
              BG.BILL_NO,
              BG.NO_OF_CONS_DAYS,
              BG.PRORATE_CD,
              BI.DATE_BILLED,
              BI.TOT_OTHER_CHARGES,
              BI.TOTAL_ARREARS,
              BG.REV_MTH_ORIG_BILL,
              BG.RT_PKG_OPT_SEQ_NO,
              BG.GAS_BASE_USE                                    
                INTO :BG-CODE-UTIL-TYPE                                 
                    ,:BG-IC-NO                                          
                    ,:BG-AMT-BILL-ITEM                                  
                    ,:BG-AMT-STATE-TAX                                  
                    ,:BG-AMT-CITY-TAX                                   
                    ,:BG-AMT-OTHER-TAX                                  
                    ,:BG-CODE-REVENUE-CLASS                             
                    ,:BG-CODE-BILL-CALC                                 
                    ,:BG-CODE-BILL-ITM-TYPE                             
                    ,:BG-CODE-DR-CR-CNSMPTN                             
                    ,:BG-RATE-PLAN-NO                                   
                    ,:WS-BILL-ITEM-TIMESTMP                             
                    ,:BG-REVENUE-MONTH                                  
                    ,:BG-DATE-ORIG-BILL :WS-NULL-IND-5                  
                    ,:BG-WNA-FACTOR                                     
                    ,:BG-BTU-FACTOR                                     
                    ,:BG-ACCOUNT-NO                                     
                    ,:WS-BILL-NO                                        
                    ,:WS-NO-OF-CONS-DAYS                                
                    ,:BG-REV-RPT-CD                                     
                    ,:WS-DATE-BILLED :WS-NULL-IND-6                     
                    ,:BI-TOT-OTHER-CHARGES                              
                    ,:BI-TOTAL-ARREARS                                  
                    ,:BG-REV-MTH-ORIG-BILL                              
                    ,:BG-RT-PKG-OPT-SEQ-NO                              
                    ,:BG-GAS-BASE-USE                                   
                FROM CSS_BILLING_DET  BG WITH(READUNCOMMITTED)                  
                    ,CSS_BILLING_HDR  BI WITH(READUNCOMMITTED)                  
               WHERE BG.ACCOUNT_NO          = BI.ACCOUNT_NO             
                 AND BG.BILL_NO             = BI.BILL_NO                
                 AND BG.DATE_ORIG_BILL      = IIF(TRY_CONVERT(DATE, 
                                                        :BI-DATE-BILLED
              ) IS NULL OR (PATINDEX('%.%', :BI-DATE-BILLED
              ) <> 0) OR (LEN(:BI-DATE-BILLED) <> 10), CIS.CHAR2DATE(
                                                        :BI-DATE-BILLED
              ), CONVERT(DATE, :BI-DATE-BILLED) )           
                 AND BG.ACCOUNT_NO          = :BG-ACCOUNT-NO            
                 AND BG.CODE_UTIL_TYPE      = :BG-CODE-UTIL-TYPE        
                 AND BG.IC_NO               = :BG-IC-NO                 
P00836           AND BG.BILL_ITEM_TIMESTMP  > CIS.CHAR2TIMESTAMP(
                                                            :WS-TEMP-TS
              )               
                 AND BG.CODE_BILL_CALC     <> 'S'                       
                 AND BG.CODE_BILL_ITM_TYPE <> 'B'                       
                 AND BG.CODE_BILL_ITM_IND  <> 'K'                       
               ORDER BY BG.BILL_NO                                      
P00836                 ,BILL_ITEM_TIMESTMP                           
                                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BG.CODE_UTIL_TYPE                                          
MFA-TR*             ,BG.IC_NO                                                   
MFA-TR*             ,BG.AMT_BILL_ITEM                                           
MFA-TR*             ,BG.AMT_STATE_TAX                                           
MFA-TR*             ,BG.AMT_CITY_TAX                                            
MFA-TR*             ,BG.AMT_OTHER_TAX                                           
MFA-TR*             ,BG.CODE_REVENUE_CLASS                                      
MFA-TR*             ,BG.CODE_BILL_CALC                                          
MFA-TR*             ,BG.CODE_BILL_ITM_TYPE                                      
MFA-TR*             ,BG.CODE_DR_CR_CNSMPTN                                      
MFA-TR*             ,BG.RATE_PLAN_NO                                            
MFA-TR*             ,BG.BILL_ITEM_TIMESTMP                                      
MFA-TR*             ,BG.REVENUE_MONTH                                           
MFA-TR*             ,BG.DATE_ORIG_BILL                                          
MFA-TR*             ,BG.WNA_FACTOR                                              
MFA-TR*             ,BG.BTU_FACTOR                                              
MFA-TR*             ,BG.ACCOUNT_NO                                              
MFA-TR*             ,BG.BILL_NO                                                 
MFA-TR*             ,BG.NO_OF_CONS_DAYS                                         
MFA-TR*             ,BG.PRORATE_CD                                              
MFA-TR*             ,BI.DATE_BILLED                                             
MFA-TR*             ,BI.TOT_OTHER_CHARGES                                       
MFA-TR*             ,BI.TOTAL_ARREARS                                           
MFA-TR*             ,BG.REV_MTH_ORIG_BILL                                       
MFA-TR*             ,BG.RT_PKG_OPT_SEQ_NO                                       
MFA-TR*             ,BG.GAS_BASE_USE                                            
MFA-TR*         INTO :BG-CODE-UTIL-TYPE                                         
MFA-TR*             ,:BG-IC-NO                                                  
MFA-TR*             ,:BG-AMT-BILL-ITEM                                          
MFA-TR*             ,:BG-AMT-STATE-TAX                                          
MFA-TR*             ,:BG-AMT-CITY-TAX                                           
MFA-TR*             ,:BG-AMT-OTHER-TAX                                          
MFA-TR*             ,:BG-CODE-REVENUE-CLASS                                     
MFA-TR*             ,:BG-CODE-BILL-CALC                                         
MFA-TR*             ,:BG-CODE-BILL-ITM-TYPE                                     
MFA-TR*             ,:BG-CODE-DR-CR-CNSMPTN                                     
MFA-TR*             ,:BG-RATE-PLAN-NO                                           
MFA-TR*             ,:WS-BILL-ITEM-TIMESTMP                                     
MFA-TR*             ,:BG-REVENUE-MONTH                                          
MFA-TR*             ,:BG-DATE-ORIG-BILL :WS-NULL-IND-5                          
MFA-TR*             ,:BG-WNA-FACTOR                                             
MFA-TR*             ,:BG-BTU-FACTOR                                             
MFA-TR*             ,:BG-ACCOUNT-NO                                             
MFA-TR*             ,:WS-BILL-NO                                                
MFA-TR*             ,:WS-NO-OF-CONS-DAYS                                        
MFA-TR*             ,:BG-REV-RPT-CD                                             
MFA-TR*             ,:WS-DATE-BILLED :WS-NULL-IND-6                             
MFA-TR*             ,:BI-TOT-OTHER-CHARGES                                      
MFA-TR*             ,:BI-TOTAL-ARREARS                                          
MFA-TR*             ,:BG-REV-MTH-ORIG-BILL                                      
MFA-TR*             ,:BG-RT-PKG-OPT-SEQ-NO                                      
MFA-TR*             ,:BG-GAS-BASE-USE                                           
MFA-TR*         FROM CSS_BILLING_DET  BG                                        
MFA-TR*             ,CSS_BILLING_HDR  BI                                        
MFA-TR*        WHERE BG.ACCOUNT_NO          = BI.ACCOUNT_NO                     
MFA-TR*          AND BG.BILL_NO             = BI.BILL_NO                        
MFA-TR*          AND BG.DATE_ORIG_BILL      = :BI-DATE-BILLED                   
MFA-TR*          AND BG.ACCOUNT_NO          = :BG-ACCOUNT-NO                    
MFA-TR*          AND BG.CODE_UTIL_TYPE      = :BG-CODE-UTIL-TYPE                
MFA-TR*          AND BG.IC_NO               = :BG-IC-NO                         
MFA-TR*          AND BG.BILL_ITEM_TIMESTMP  > :WS-TEMP-TS                       
MFA-TR*          AND BG.CODE_BILL_CALC     <> 'S'                               
MFA-TR*          AND BG.CODE_BILL_ITM_TYPE <> 'B'                               
MFA-TR*          AND BG.CODE_BILL_ITM_IND  <> 'K'                               
MFA-TR*        ORDER BY BG.BILL_NO                                              
MFA-TR*                ,BG.BILL_ITEM_TIMESTMP                                   
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-NULL-IND-5         < 0                              
                 MOVE SPACES                 TO BG-DATE-ORIG-BILL       
              END-IF                                                    
              IF WS-NULL-IND-6         < 0                              
                 MOVE SPACES                 TO WS-DATE-BILLED          
              END-IF                                                    
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
              OR WS-DATE-BILLED        = SPACES                         
                 SET CNCL-NO-REBIL           TO TRUE                    
              END-IF                                                    
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
              AND WS-DATE-BILLED       = SPACES                         
                 MOVE BG-REV-MTH-ORIG-BILL   TO WS-HOLD-REV-MM          
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7200'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_BILLING_DET'         TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'DATE_ORIG_BILL'          TO TABLE-ELEMENT-2         
              MOVE BG-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE BI-DATE-BILLED            TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * CHECK TO SEE IF UNMETERED ACCOUNT EXISTS WITH UTIL TYPE E OR G *        
      ******************************************************************        
       7220-CUST-PLAN-EXISTS.                                           
      *                                                                         
           EXEC SQL                                                     
               SELECT  'Y'                                              
                 INTO  :WS-UNMTRD-ELEC-GAS                              
                 FROM  CSS_CUST_PLAN WITH(READUNCOMMITTED)                      
                WHERE  ACCOUNT_NO     = :CP-ACCOUNT-NO                  
                  AND  CODE_UTIL_TYPE = :CP-CODE-UTIL-TYPE              
                  AND  IC_NO          = :CP-IC-NO                       
                  AND  CODE_UTIL_TYPE IN ('E', 'G')                     
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  'Y'                                                      
MFA-TR*          INTO  :WS-UNMTRD-ELEC-GAS                                      
MFA-TR*          FROM  CSS_CUST_PLAN                                            
MFA-TR*         WHERE  ACCOUNT_NO     = :CP-ACCOUNT-NO                          
MFA-TR*           AND  CODE_UTIL_TYPE = :CP-CODE-UTIL-TYPE                      
MFA-TR*           AND  IC_NO          = :CP-IC-NO                               
MFA-TR*           AND  CODE_UTIL_TYPE IN ('E', 'G')                             
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE WS-NO                  TO WS-UNMTRD-ELEC-GAS      
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7220'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_CUST_PLAN'           TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE CP-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE CP-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       7220-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO SELECT THE TOTAL CREDIT CHARGES.  **        
      **                                                              **        
      ******************************************************************        
       7225-GET-TOT-CHARGE-CREDIT.                                      
      *                                                                         
           MOVE ZERO                        TO WS-TOTAL-CHARGES-CREDIT  
      *                                                                         
           EXEC SQL                                                     
               SELECT  SUM(FH.FACTOR)                                   
                 INTO  :WS-TOTAL-CHARGES-CREDIT :WS-NULL-IND-8          
               FROM    CSS_FIXED_FCT_HIST FH WITH(READUNCOMMITTED)              
                      ,CSS_SPCL_FCTR      SF WITH(READUNCOMMITTED)              
               WHERE   FH.ACCOUNT_NO         = :FH-ACCOUNT-NO           
                 AND   FH.CODE_UTIL_TYPE     = :FH-CODE-UTIL-TYPE       
                 AND   FH.IC_NO              = :FH-IC-NO                
                 AND   FH.BILL_NO            = :FH-BILL-NO              
                 AND   FH.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :FH-BILL-ITEM-TIMESTMP
              )   
                 AND   FH.FACTOR_ID          = SF.FACTOR_ID             
                 AND   SF.ADJUST_ELEMENT     IN ('A','H')               
                 AND   SF.FACTOR_TYPE        = 'B'                      
                 AND   SF.GL_ACCT_NO         > 0                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  SUM(FH.FACTOR)                                           
MFA-TR*          INTO  :WS-TOTAL-CHARGES-CREDIT :WS-NULL-IND-8                  
MFA-TR*        FROM    CSS_FIXED_FCT_HIST FH                                    
MFA-TR*               ,CSS_SPCL_FCTR      SF                                    
MFA-TR*        WHERE   FH.ACCOUNT_NO         = :FH-ACCOUNT-NO                   
MFA-TR*          AND   FH.CODE_UTIL_TYPE     = :FH-CODE-UTIL-TYPE               
MFA-TR*          AND   FH.IC_NO              = :FH-IC-NO                        
MFA-TR*          AND   FH.BILL_NO            = :FH-BILL-NO                      
MFA-TR*          AND   FH.BILL_ITEM_TIMESTMP = :FH-BILL-ITEM-TIMESTMP           
MFA-TR*          AND   FH.FACTOR_ID          = SF.FACTOR_ID                     
MFA-TR*          AND   SF.ADJUST_ELEMENT     IN ('A','H')                       
MFA-TR*          AND   SF.FACTOR_TYPE        = 'B'                              
MFA-TR*          AND   SF.GL_ACCT_NO         > 0                                
MFA-TR*    WITH UR                                                              
MFA-TR*    QUERYNO 7225                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL OR NOT-FOUND
              IF WS-NULL-IND-8 < 0                                      
                 MOVE 0                      TO WS-TOTAL-CHARGES-CREDIT 
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7225'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_FIXED_FCT_HIST'      TO TABLE-1                 
              MOVE 'CSS_SPCL_FCTR'           TO TABLE-2                 
              MOVE 'ACCOUNT_NO  '            TO TABLE-ELEMENT-1         
              MOVE 'BILL_ITEM_TIMESTMP'      TO TABLE-ELEMENT-2         
              MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE BG-BILL-ITEM-TIMESTMP     TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7225-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO SELECT THE FACTOR VALUE FROM      **        
      **  FIXED FACTOR HISTORY DETAIL                                 **        
      ******************************************************************        
       7230-OPEN-FACTOR-VAL-DET.                                        
      *                                                                         
           EXEC SQL                                                     
               OPEN FACTOR_VAL                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7230'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_FIXED_FCT_HIST'      TO TABLE-1                 
              MOVE 'ACCOUNT_NO  '            TO TABLE-ELEMENT-1         
              MOVE 'BILL_ITEM_TIMESTMP'      TO TABLE-ELEMENT-2         
              MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE BG-BILL-ITEM-TIMESTMP     TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       7230-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      **  FETCH FIXED FACTOR HISTORY DETAIL                           **        
      **                                                              **        
      ******************************************************************        
       7231-FETCH-FACTOR-VAL-DET.                                       
      *                                                                         
           EXEC SQL                                                     
               FETCH FACTOR_VAL                                         
                INTO :FH-FACTOR :WS-NULL-IND-8                         
                    ,:FH-FCTR-POWER-10                                  
                                                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-NULL-IND-8 < ZERO                                   
                 MOVE ZEROES               TO FH-FACTOR                 
               END-IF                                                   
              IF WS-ACTIVE-RETURN-CODE  = NOT-FOUND                     
                 MOVE WS-YES                 TO END-OF-FCTR-VAL-SW      
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7231'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_FIXED_FCT_HIST'      TO TABLE-1                 
              MOVE 'ACCOUNT_NO  '            TO TABLE-ELEMENT-1         
              MOVE 'BILL_ITEM_TIMESTMP'      TO TABLE-ELEMENT-2         
              MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE BG-BILL-ITEM-TIMESTMP     TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       7231-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      **  CLOSE FIXED FACTOR HISTORY DETAIL                           **        
      **                                                              **        
      ******************************************************************        
       7232-CLOSE-FACTOR-VAL-DET.                                       
      *                                                                         
           EXEC SQL                                                     
               CLOSE FACTOR_VAL                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7232'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_FIXED_FCT_HIST'      TO TABLE-1                 
              MOVE 'ACCOUNT_NO  '            TO TABLE-ELEMENT-1         
              MOVE 'BILL_ITEM_TIMESTMP'      TO TABLE-ELEMENT-2         
              MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE BG-BILL-ITEM-TIMESTMP     TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       7232-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *                                                                         
      ******************************************************************        
      **  THIS PARAGRAPH CHECKS WHETHER THE GIVEN BG-RATE-PLAN-NO     **        
      **  BELONGS TO INDUSTRIAL GAS OR NET-METRING CUSTOMER           **        
      ******************************************************************        
       7240-CHECK-INDUS-CUST.                                           
      *                                                                         
           EXEC SQL                                                     
             SELECT TOP(1) J1.REG_TYPE_CD                                      
               INTO :WS-REG-TYPE-CD                                     
               FROM CSS_RATE_COMP_DEF J1 WITH(READUNCOMMITTED)                  
              WHERE J1.RATE_PLAN_NO           = :BG-RATE-PLAN-NO        
                AND J1.CODE_UTIL_TYPE         = :BG-CODE-UTIL-TYPE      
                AND J1.VERSION_NO_CNTRL       =                         
                    (SELECT MAX(A1.VERSION_NO_CNTRL)                    
                       FROM CSS_RATE_COMP_DEF A1 WITH(READUNCOMMITTED)          
                      WHERE A1.RATE_PLAN_NO   = :BG-RATE-PLAN-NO        
                        AND A1.CODE_UTIL_TYPE = :BG-CODE-UTIL-TYPE)     
                                                    
                                                                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT J1.REG_TYPE_CD                                              
MFA-TR*        INTO :WS-REG-TYPE-CD                                             
MFA-TR*        FROM CSS_RATE_COMP_DEF J1                                        
MFA-TR*       WHERE J1.RATE_PLAN_NO           = :BG-RATE-PLAN-NO                
MFA-TR*         AND J1.CODE_UTIL_TYPE         = :BG-CODE-UTIL-TYPE              
MFA-TR*         AND J1.VERSION_NO_CNTRL       =                                 
MFA-TR*             (SELECT MAX(A1.VERSION_NO_CNTRL)                            
MFA-TR*                FROM CSS_RATE_COMP_DEF A1                                
MFA-TR*               WHERE A1.RATE_PLAN_NO   = :BG-RATE-PLAN-NO                
MFA-TR*                 AND A1.CODE_UTIL_TYPE = :BG-CODE-UTIL-TYPE)             
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL OR NOT-FOUND
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7240'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_RATE_COMP_DEF'       TO TABLE-1                 
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE BG-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-1       
              MOVE BG-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       7240-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  THIS PARAGRAPH FETCHES THE  ROWS FROM THE                   **        
      **  CSS_ACCOUNT , CSS_LOCAL_OFFICE                              **        
      ******************************************************************        
       7250A-GET-REGION.                                                
      *                                                                         
           EXEC SQL                                                     
             SELECT  AT.ACCOUNT_NO                                      
                    ,AT.COMPANY_NO                                      
                    ,AT.ACCOUNT_TYPE_CODE                               
                    ,B1.LOCAL_OFFICE                                    
                    ,B1.WEATHER_SERV_DIV                                
               INTO  :AT-ACCOUNT-NO                                     
                    ,:AT-COMPANY-NO                                     
                    ,:AT-ACCOUNT-TYPE-CODE                              
                    ,:B1-LOCAL-OFFICE                                   
                    ,:B1-WEATHER-SERV-DIV :WS-NULL-IND-7                 
               FROM  CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
                    ,CSS_LOCAL_OFFICE B1 WITH(READUNCOMMITTED)                  
              WHERE  AT.ACCOUNT_NO     = :AT-ACCOUNT-NO                 
                AND  AT.LOCAL_OFFICE   = B1.LOCAL_OFFICE                
                AND  AT.COMPANY_NO     = B1.COMPANY_NO                  
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  AT.ACCOUNT_NO                                              
MFA-TR*             ,AT.COMPANY_NO                                              
MFA-TR*             ,AT.ACCOUNT_TYPE_CODE                                       
MFA-TR*             ,B1.LOCAL_OFFICE                                            
MFA-TR*             ,B1.WEATHER_SERV_DIV                                        
MFA-TR*        INTO  :AT-ACCOUNT-NO                                             
MFA-TR*             ,:AT-COMPANY-NO                                             
MFA-TR*             ,:AT-ACCOUNT-TYPE-CODE                                      
MFA-TR*             ,:B1-LOCAL-OFFICE                                           
MFA-TR*             ,:B1-WEATHER-SERV-DIV:WS-NULL-IND-7                         
MFA-TR*        FROM  CSS_ACCOUNT AT                                             
MFA-TR*             ,CSS_LOCAL_OFFICE B1                                        
MFA-TR*       WHERE  AT.ACCOUNT_NO     = :AT-ACCOUNT-NO                         
MFA-TR*         AND  AT.LOCAL_OFFICE   = B1.LOCAL_OFFICE                        
MFA-TR*         AND  AT.COMPANY_NO     = B1.COMPANY_NO                          
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF WS-NULL-IND-7 < 0 OR B1-WEATHER-SERV-DIV EQUAL SPACES     
              MOVE '1'                       TO WS-WEATHER-SRVC-DIV     
           ELSE                                                         
              MOVE B1-WEATHER-SERV-DIV       TO WS-WEATHER-SRVC-DIV     
           END-IF                                                       
                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S5-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7250A'                   TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_ACCOUNT'             TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       7250A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
       7250B-DETERMINE-DB.                                              
      ******************************************************************        
      **  THIS PARAGRAPH DETERMINES IF THE CURRENT REGION IS AGL      **        
      **  OR NOT.                                                     **        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE DELINQ_CD  = :C8-DELINQ-CD                         
                 AND COMPANY_NO = :C8-COMPANY-NO                        
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD  = :C8-DELINQ-CD                                 
MFA-TR*          AND COMPANY_NO = :C8-COMPANY-NO                                
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               MOVE C8-DELINQ-VALUE          TO WS-DATABASE             
           ELSE                                                         
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE '7250B'                  TO ACTIVE-PARAGRAPH        
               MOVE 'SELECT'                 TO ABEND-FUNCTION          
               MOVE 'CSS_DELINQUENCY'        TO TABLE-1                 
               MOVE 'DELINQ_VALUE'           TO TABLE-ELEMENT-1         
               MOVE 'DATABASE'               TO HOSTVAR-ELEMENT-1       
               PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       7250B-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  THIS PARAGRAPH RETRIEVE THE RATE PLAN DESC FOR THE GIVEN    **        
      **  RD-RATE-PLAN-NO                                             **        
      ******************************************************************        
       7260-SELECT-RATE-DESC.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT RATE_DESC                                          
                    ,RATE_DEFINITION_CD                                 
               INTO :RD-RATE-DESC                                       
                   ,:RD-RATE-DEFINITION-CD                              
                FROM CSS_RATE_PLAN_DESC WITH(READUNCOMMITTED)                   
               WHERE CODE_UTIL_TYPE  =  :RD-CODE-UTIL-TYPE              
                 AND RATE_PLAN_NO    =  :RD-RATE-PLAN-NO                
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RATE_DESC                                                  
MFA-TR*             ,RATE_DEFINITION_CD                                         
MFA-TR*        INTO :RD-RATE-DESC                                               
MFA-TR*            ,:RD-RATE-DEFINITION-CD                                      
MFA-TR*         FROM CSS_RATE_PLAN_DESC                                         
MFA-TR*        WHERE CODE_UTIL_TYPE  =  :RD-CODE-UTIL-TYPE                      
MFA-TR*          AND RATE_PLAN_NO    =  :RD-RATE-PLAN-NO                        
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL OR NOT-FOUND
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7260'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_RATE_PLAN_DESC'       TO TABLE-1                
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-3        
              MOVE RD-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-1      
              MOVE RD-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2      
              MOVE BG-ACCOUNT-NO              TO HOSTVAR-ELEMENT-3      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       7260-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      **  THIS PARAGRAPH RETRIEVE THE RATE PLAN DESC FOR THE GIVEN    **        
      **  RD-RATE-PLAN-NO                                             **        
      ******************************************************************        
       7270-GET-OPTION-DESC.                                            
                                                                        
           EXEC SQL                                                     
              SELECT FI.OPT_DESC_INT                                    
                    ,FI.OPTION_CD                                       
                    ,FI.OPT_CALC_TYPE_CD                                
                INTO :FI-OPT-DESC-INT                                   
                    ,:FI-OPTION-CD                                      
                    ,:FI-OPT-CALC-TYPE-CD                               
                FROM CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)                 
                    ,CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)                 
               WHERE DF.ACCOUNT_NO         = :DF-ACCOUNT-NO             
                 AND DF.CODE_UTIL_TYPE     = :DF-CODE-UTIL-TYPE         
                 AND DF.IC_NO              = :DF-IC-NO                  
                 AND DF.RT_PKG_OPT_SEQ_NO  = :DF-RT-PKG-OPT-SEQ-NO      
                 AND DF.OPTION_CD          = FI.OPTION_CD               
                 AND FI.OPTION_START_DT   <= CAST(SYSDATETIMEOFFSET() 
           AS DATE)               
                 AND FI.OPTION_END_DT     >= CAST(SYSDATETIMEOFFSET() 
           AS DATE)               
                 AND FI.OPT_VSTART_TS     <= CIS.CURRENT$TIMESTAMP()          
                 AND FI.OPT_VEND_TS       >= CIS.CURRENT$TIMESTAMP()          
                 AND FI.PROC_STATUS_CD     = 'AC'                       
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT FI.OPT_DESC_INT                                            
MFA-TR*             ,FI.OPTION_CD                                               
MFA-TR*             ,FI.OPT_CALC_TYPE_CD                                        
MFA-TR*         INTO :FI-OPT-DESC-INT                                           
MFA-TR*             ,:FI-OPTION-CD                                              
MFA-TR*             ,:FI-OPT-CALC-TYPE-CD                                       
MFA-TR*         FROM CSS_ACCT_RTPK_AGR DF                                       
MFA-TR*             ,CRM_RT_PKG_OPTION FI                                       
MFA-TR*        WHERE DF.ACCOUNT_NO         = :DF-ACCOUNT-NO                     
MFA-TR*          AND DF.CODE_UTIL_TYPE     = :DF-CODE-UTIL-TYPE                 
MFA-TR*          AND DF.IC_NO              = :DF-IC-NO                          
MFA-TR*          AND DF.RT_PKG_OPT_SEQ_NO  = :DF-RT-PKG-OPT-SEQ-NO              
MFA-TR*          AND DF.OPTION_CD          = FI.OPTION_CD                       
MFA-TR*          AND FI.OPTION_START_DT   <= CURRENT DATE                       
MFA-TR*          AND FI.OPTION_END_DT     >= CURRENT DATE                       
MFA-TR*          AND FI.OPT_VSTART_TS     <= CURRENT TIMESTAMP                  
MFA-TR*          AND FI.OPT_VEND_TS       >= CURRENT TIMESTAMP                  
MFA-TR*          AND FI.PROC_STATUS_CD     = 'AC'                               
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE SPACES                   TO FI-OPT-DESC-INT       
                 MOVE SPACES                   TO FI-OPTION-CD          
              ELSE                                                      
                MOVE '7270'                    TO ACTIVE-PARAGRAPH      
                MOVE PROGRAM-NAME              TO ABEND-PROGRAM         
                MOVE 'SELECT'                  TO ABEND-FUNCTION        
                MOVE 'CSS_ACCT_RTPK_AGR'       TO TABLE-1               
                MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1       
                MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2       
                MOVE 'IC_NO'                   TO TABLE-ELEMENT-3       
                MOVE 'RT_PKG_OPT_SEQ_NO'       TO TABLE-ELEMENT-4       
                MOVE DF-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1     
                MOVE DF-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2     
                MOVE DF-IC-NO                  TO HOSTVAR-ELEMENT-3     
                MOVE DF-RT-PKG-OPT-SEQ-NO      TO HOSTVAR-ELEMENT-4     
                PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT          
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7270-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  THIS PARAGRAPH RETRIEVE THE DATE READ FOR THE UNBILL REBILL **        
      **  ROW                                                         **        
      ******************************************************************        
       7280-GET-DATE-READ.                                              
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) METER_NO,
              DATE_READ                                          
              INTO   :WS-METER-NO                                       
                    ,:WS-DATE-READ                                      
              FROM   CSS_CNSMPTN_HIST WITH(READUNCOMMITTED)                     
              WHERE  ACCOUNT_NO         = :BG-ACCOUNT-NO                
              AND    CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE            
              AND    BILL_NO            = :BG-BILL-NO                   
              AND    IC_NO              = :BG-IC-NO                     
              AND    BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :BG-BILL-ITEM-TIMESTMP
              )        
              AND    CODE_ITEM_STATUS IN ( 'A' , 'T')                   
              ORDER BY DATE_READ DESC                                   
                      ,CODE_USAGE_TYPE ASC                              
                                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT METER_NO                                                   
MFA-TR*             ,DATE_READ                                                  
MFA-TR*       INTO   :WS-METER-NO                                               
MFA-TR*             ,:WS-DATE-READ                                              
MFA-TR*       FROM   CSS_CNSMPTN_HIST                                           
MFA-TR*       WHERE  ACCOUNT_NO         = :BG-ACCOUNT-NO                        
MFA-TR*       AND    CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE                    
MFA-TR*       AND    BILL_NO            = :BG-BILL-NO                           
MFA-TR*       AND    IC_NO              = :BG-IC-NO                             
MFA-TR*       AND    BILL_ITEM_TIMESTMP = :BG-BILL-ITEM-TIMESTMP                
MFA-TR*       AND    CODE_ITEM_STATUS IN ( 'A' , 'T')                           
MFA-TR*       ORDER BY DATE_READ DESC                                           
MFA-TR*               ,CODE_USAGE_TYPE ASC                                      
MFA-TR*       FETCH FIRST ROW ONLY                                              
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE SPACES                   TO WS-METER-NO           
                                                  WS-DATE-READ          
              ELSE                                                      
                MOVE '7280'                    TO ACTIVE-PARAGRAPH      
                MOVE PROGRAM-NAME              TO ABEND-PROGRAM         
                MOVE 'SELECT'                  TO ABEND-FUNCTION        
                MOVE 'CSS_CNSMPTN_HIST'        TO TABLE-1               
                MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1       
                MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2       
                MOVE 'IC_NO'                   TO TABLE-ELEMENT-3       
                MOVE 'BILL_NO'                 TO TABLE-ELEMENT-4       
                MOVE BG-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1     
                MOVE BG-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2     
                MOVE BG-IC-NO                  TO HOSTVAR-ELEMENT-3     
                MOVE BG-BILL-NO                TO HOSTVAR-ELEMENT-4     
                PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT          
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7280-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  THIS PARAGRAPH SELECTS THE DATA FROM METER READ ENVIRONMENT **        
      **  TABLE                                                       **        
      ******************************************************************        
       7285-SELECT-METER-READ-ENVRMNT.                                  
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-MULT-MTR-REG-FLG                               
                FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                     
               WHERE ACCOUNT_NO        = :MN-ACCOUNT-NO                 
                 AND CODE_UTIL_TYPE    = :MN-CODE-UTIL-TYPE             
                 AND METER_NO          = :MN-METER-NO                   
                 AND MTR_REF_NO        = :MN-MTR-REF-NO                 
                 AND IC_NO             = :MN-IC-NO                      
                 AND CODE_DATA_PRESENT > ' '                            
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-MULT-MTR-REG-FLG                                       
MFA-TR*         FROM CSS_MTRD_ENVRNMT                                           
MFA-TR*        WHERE ACCOUNT_NO        = :MN-ACCOUNT-NO                         
MFA-TR*          AND CODE_UTIL_TYPE    = :MN-CODE-UTIL-TYPE                     
MFA-TR*          AND METER_NO          = :MN-METER-NO                           
MFA-TR*          AND MTR_REF_NO        = :MN-MTR-REF-NO                         
MFA-TR*          AND IC_NO             = :MN-IC-NO                              
MFA-TR*          AND CODE_DATA_PRESENT > ' '                                    
MFA-TR*       FETCH FIRST ROW ONLY                                              
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7285                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE WS-NO                    TO WS-MULT-MTR-REG-FLG   
              ELSE                                                      
                MOVE '7285'                    TO ACTIVE-PARAGRAPH      
                MOVE PROGRAM-NAME              TO ABEND-PROGRAM         
                MOVE 'SELECT'                  TO ABEND-FUNCTION        
                MOVE 'CSS_MTRD_ENVRNMT'        TO TABLE-1               
                MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1       
                MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2       
                MOVE 'IC_NO'                   TO TABLE-ELEMENT-3       
                MOVE 'METER_NO'                TO TABLE-ELEMENT-4       
                MOVE MN-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1     
                MOVE MN-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2     
                MOVE MN-IC-NO                  TO HOSTVAR-ELEMENT-3     
                MOVE MN-METER-NO               TO HOSTVAR-ELEMENT-4     
                PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT          
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7285-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7290-STEP-RATE.                                                *        
      ******************************************************************        
       7290-STEP-RATE.                                                  
                                                                        
           EXEC SQL                                                     
              SELECT COUNT(*)                                           
                INTO :WS-BLOCKS-COUNT                                   
                FROM CSS_PRICE_SCHED     PS WITH(READUNCOMMITTED)               
               WHERE PS.CODE_UTIL_TYPE   =  :WS-CODE-UTIL-TYPE          
                 AND PS.RATE_PLAN_NO     =  :BG-RATE-PLAN-NO            
                 AND PS.VERSION_NO_CNTRL = (                            
                     SELECT MAX(RT.VERSION_NO_CNTRL)                    
                       FROM CSS_RATE_CREATOR      RT
                           WITH(READUNCOMMITTED)                    
                      WHERE RT.CODE_UTIL_TYPE     = :WS-CODE-UTIL-TYPE  
                        AND RT.RATE_PLAN_NO       = :BG-RATE-PLAN-NO    
                        AND RT.FROM_EFFECTIVE_DT <= 
              IIF(TRY_CONVERT(DATE, :WS-DATE-BILLED
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-BILLED
              ) <> 0) OR (LEN(:WS-DATE-BILLED) <> 10), CIS.CHAR2DATE(
                                                        :WS-DATE-BILLED
              ), CONVERT(DATE, :WS-DATE-BILLED) )     
                        AND RT.CODE_STATUS        = 'A')                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COUNT(*)                                                   
MFA-TR*         INTO :WS-BLOCKS-COUNT                                           
MFA-TR*         FROM CSS_PRICE_SCHED     PS                                     
MFA-TR*        WHERE PS.CODE_UTIL_TYPE   =  :WS-CODE-UTIL-TYPE                  
MFA-TR*          AND PS.RATE_PLAN_NO     =  :BG-RATE-PLAN-NO                    
MFA-TR*          AND PS.VERSION_NO_CNTRL = (                                    
MFA-TR*              SELECT MAX(RT.VERSION_NO_CNTRL)                            
MFA-TR*                FROM CSS_RATE_CREATOR      RT                            
MFA-TR*               WHERE RT.CODE_UTIL_TYPE     = :WS-CODE-UTIL-TYPE          
MFA-TR*                 AND RT.RATE_PLAN_NO       = :BG-RATE-PLAN-NO            
MFA-TR*                 AND RT.FROM_EFFECTIVE_DT <= :WS-DATE-BILLED             
MFA-TR*                 AND RT.CODE_STATUS        = 'A')                        
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7290                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7290'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_PRICE_SCHED'         TO TABLE-1                 
              MOVE 'CSS_RATE_CREATOR'        TO TABLE-2                 
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE 'BILLED_DATE'             TO TABLE-ELEMENT-3         
              MOVE BG-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-1       
              MOVE WS-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              MOVE WS-DATE-BILLED            TO HOSTVAR-ELEMENT-3       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7290-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *****************************************************************         
      * 8000A-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000A-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04638_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04638_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S1-RETURN-CODE.          
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
                                               S1-RETURN-CODE           
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000A'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04638_R1'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       8000A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      * 8000B-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000B-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04638_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04638_R2                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S2-RETURN-CODE.          
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
                                               S2-RETURN-CODE           
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000B'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04638_R2'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       8000B-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      * 8000C-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000C-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04638_R3                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04638_R3                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S3-RETURN-CODE.             
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES          TO WS-ACTIVE-RETURN-CODE       
                                            S3-RETURN-CODE              
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME    TO ABEND-PROGRAM               
                    MOVE SQLCODE         TO ABEND-SQLCODE               
                    MOVE SQLSTATE        TO ABEND-SQLSTATE              
                    MOVE '8000C'         TO ACTIVE-PARAGRAPH            
                    MOVE 'DELETE'        TO ABEND-FUNCTION              
                    MOVE SPACES          TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                    MOVE 'CSR04638_R3'   TO TABLE-1                     
                    MOVE SPACES          TO TABLE-ELEMENT-1             
                    MOVE SPACES          TO HOSTVAR-ELEMENT-1           
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       8000C-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      * 8000D-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000D-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04638_R4                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04638_R4                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S4-RETURN-CODE.             
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES          TO WS-ACTIVE-RETURN-CODE       
                                            S4-RETURN-CODE              
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME    TO ABEND-PROGRAM               
                    MOVE SQLCODE         TO ABEND-SQLCODE               
                    MOVE SQLSTATE        TO ABEND-SQLSTATE              
                    MOVE '8000D'         TO ACTIVE-PARAGRAPH            
                    MOVE 'DELETE'        TO ABEND-FUNCTION              
                    MOVE SPACES          TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                    MOVE 'CSR04638_R4'   TO TABLE-1                     
                    MOVE SPACES          TO TABLE-ELEMENT-1             
                    MOVE SPACES          TO HOSTVAR-ELEMENT-1           
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       8000D-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      * 8000E-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000E-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04638_R5                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04638_R5                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S5-RETURN-CODE.             
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES          TO WS-ACTIVE-RETURN-CODE       
                                            S5-RETURN-CODE              
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME    TO ABEND-PROGRAM               
                    MOVE SQLCODE         TO ABEND-SQLCODE               
                    MOVE SQLSTATE        TO ABEND-SQLSTATE              
                    MOVE '8000E'         TO ACTIVE-PARAGRAPH            
                    MOVE 'DELETE'        TO ABEND-FUNCTION              
                    MOVE SPACES          TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                    MOVE 'CSR04638_R5'   TO TABLE-1                     
                    MOVE SPACES          TO TABLE-ELEMENT-1             
                    MOVE SPACES          TO HOSTVAR-ELEMENT-1           
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       8000E-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 8010-INSERT-GTT-R1.   CSS_BUS_RULE                             *        
      ******************************************************************        
       8010-INSERT-GTT-R1.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04638_R1                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,ACCOUNT_NO                                           
                  ,BC_BILL_NO                                           
                  ,BILLING_MONTH                                        
                  ,DATE_BILLED                                          
                  ,UTILITY_REVENUE                                      
                  ,ARREARS                                              
                  ,OTHER_CHARGES                                        
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S1-RETURN-CODE                                      
                  ,:S1-APPL-RETURN-CODE                                 
                  ,:S1-ACCOUNT-NO                                       
                  ,:S1-BC-BILL-NO                                       
                  ,:S1-BILLING-MONTH                                    
                  ,:S1-DATE-BILLED                                      
                  ,:S1-UTILITY-REVENUE                                  
                  ,:S1-ARREARS                                          
                  ,:S1-OTHER-CHARGES                                    
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04638_R1                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,ACCOUNT_NO                                                   
MFA-TR*           ,BC_BILL_NO                                                   
MFA-TR*           ,BILLING_MONTH                                                
MFA-TR*           ,DATE_BILLED                                                  
MFA-TR*           ,UTILITY_REVENUE                                              
MFA-TR*           ,ARREARS                                                      
MFA-TR*           ,OTHER_CHARGES                                                
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S1-RETURN-CODE                                              
MFA-TR*           ,:S1-APPL-RETURN-CODE                                         
MFA-TR*           ,:S1-ACCOUNT-NO                                               
MFA-TR*           ,:S1-BC-BILL-NO                                               
MFA-TR*           ,:S1-BILLING-MONTH                                            
MFA-TR*           ,:S1-DATE-BILLED                                              
MFA-TR*           ,:S1-UTILITY-REVENUE                                          
MFA-TR*           ,:S1-ARREARS                                                  
MFA-TR*           ,:S1-OTHER-CHARGES                                            
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S1-RETURN-CODE.             
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                     TO  CTR-ROWS-RS1               
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8010'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04638_R1'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
        8010-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 8020-INSERT-GTT-R2.  BUS RULE XREF                             *        
      ******************************************************************        
       8020-INSERT-GTT-R2.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04638_R2                           
                 (                                                      
                     RETURN_CODE                                        
                    ,APPL_RETURN_CODE                                   
                    ,BC_BILL_NO                                         
                    ,BILL_NO                                            
                    ,BILLING_MONTH                                      
                    ,DATE_BILLED                                        
                    ,BILL_ITEM_TIMESTAMP                                
                    ,CODE_UTIL_TYPE                                     
                    ,IC_NO                                              
                    ,RATE_PLAN_NO                                       
                    ,RATE_DESC                                          
                    ,OPTION_CD                                          
                    ,OPTION_DESC                                        
                    ,OPTION_CALC_TYPE_CD                                
                    ,TOT_USG_COST                                       
                    ,TOT_USG                                            
                    ,WNA_AMOUNT                                         
                    ,AVG_COST_PER_USG                                   
                    ,AVG_COST_PER_DAY                                   
                    ,NO_OF_DAYS                                         
                    ,AVG_USG_PER_DAY                                    
                    ,AGL_CHRG                                           
                    ,DATE_READ                                          
                    ,CODE_MTR_READ                                      
                    ,METER_NO                                           
                    ,METER_READING                                      
                    ,STATE_TAX_AMT                                      
                    ,CITY_TAX_AMT                                       
                    ,UNIT_PRICE_AMT                                     
                    ,CALC_COMP_AMT                                      
                    ,READ_UNITS                                         
                    ,BFC_CHRG                                           
                    ,SPC_DDC_CHARGE                                     
                    ,UNBIL_REBIL_FLG                                    
                    ,DDC_FACTOR                                         
                    ,[2PART_RATE_FLG]                                     
                    ,STEP_RATE_FLG                                      
                    ,TOTAL_CHARGES_CREDIT                               
                    ,CSC_ADJ_EXIST                                      
                    ,MULT_MTR_REG_FLG                                   
ACT056              ,SOLAR_RATE_FLG                                     
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S2-RETURN-CODE                                      
                  ,:S2-APPL-RETURN-CODE                                 
                  ,:S2-BC-BILL-NO                                       
                  ,:S2-BILL-NO                                          
                  ,:S2-BILLING-MONTH                                    
                  ,:S2-DATE-BILLED                                      
                  ,:S2-BILL-ITEM-TIMESTMP                               
                  ,:S2-CODE-UTIL-TYPE                                   
                  ,:S2-IC-NO                                            
                  ,:S2-RATE-PLAN-NO                                     
                  ,:S2-RATE-DESC                                        
                  ,:S2-OPTION-CD                                        
                  ,:S2-OPTION-DESC                                      
                  ,:S2-OPTION-CALC-TYPE-CD                              
                  ,:S2-TOT-UTILITY                                      
                  ,:S2-TOT-USAGE                                        
                  ,:S2-WNA-AMOUNT                                       
                  ,:S2-AVG-COST-PER-USG                                 
                  ,:S2-AVG-COST-PER-DAY                                 
                  ,:S2-NO-OF-DAYS                                       
                  ,:S2-AVG-USG-PER-DAY                                  
                  ,:S2-AGL-CHARGE                                       
                  ,:S2-DATE-READ                                        
                  ,:S2-CODE-MTR-READ                                    
                  ,:S2-METER-NO                                         
                  ,:S2-METER-READING                                    
                  ,:S2-STATE-TAX-AMT                                    
                  ,:S2-CITY-TAX-AMT                                     
                  ,:S2-UNIT-PRICE-AMT                                   
                  ,:S2-CALC-COMP-AMT                                    
                  ,:S2-READ-UNITS                                       
                  ,:S2-BFC-CHARGE                                       
                  ,:S2-SPC-DDC-CHARGE                                   
                  ,:S2-UNBIL-REBIL-FLG                                  
                  ,:S2-DDC-FACTOR                                       
                  ,:S2-2PART-RATE-FLG                                   
                  ,:S2-STEP-RATE-FLG                                    
                  ,:S2-TOTAL-CHARGES-CREDIT                             
                  ,:S2-CSC-ADJ-EXIST                                    
                  ,:S2-MULT-MTR-REG-FLG                                 
ACT056            ,:S2-SOLAR-RATE-FLG                                   
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ026
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04638_R2                                   
MFA-TR*          (                                                              
MFA-TR*              RETURN_CODE                                                
MFA-TR*             ,APPL_RETURN_CODE                                           
MFA-TR*             ,BC_BILL_NO                                                 
MFA-TR*             ,BILL_NO                                                    
MFA-TR*             ,BILLING_MONTH                                              
MFA-TR*             ,DATE_BILLED                                                
MFA-TR*             ,BILL_ITEM_TIMESTAMP                                        
MFA-TR*             ,CODE_UTIL_TYPE                                             
MFA-TR*             ,IC_NO                                                      
MFA-TR*             ,RATE_PLAN_NO                                               
MFA-TR*             ,RATE_DESC                                                  
MFA-TR*             ,OPTION_CD                                                  
MFA-TR*             ,OPTION_DESC                                                
MFA-TR*             ,OPTION_CALC_TYPE_CD                                        
MFA-TR*             ,TOT_USG_COST                                               
MFA-TR*             ,TOT_USG                                                    
MFA-TR*             ,WNA_AMOUNT                                                 
MFA-TR*             ,AVG_COST_PER_USG                                           
MFA-TR*             ,AVG_COST_PER_DAY                                           
MFA-TR*             ,NO_OF_DAYS                                                 
MFA-TR*             ,AVG_USG_PER_DAY                                            
MFA-TR*             ,AGL_CHRG                                                   
MFA-TR*             ,DATE_READ                                                  
MFA-TR*             ,CODE_MTR_READ                                              
MFA-TR*             ,METER_NO                                                   
MFA-TR*             ,METER_READING                                              
MFA-TR*             ,STATE_TAX_AMT                                              
MFA-TR*             ,CITY_TAX_AMT                                               
MFA-TR*             ,UNIT_PRICE_AMT                                             
MFA-TR*             ,CALC_COMP_AMT                                              
MFA-TR*             ,READ_UNITS                                                 
MFA-TR*             ,BFC_CHRG                                                   
MFA-TR*             ,SPC_DDC_CHARGE                                             
MFA-TR*             ,UNBIL_REBIL_FLG                                            
MFA-TR*             ,DDC_FACTOR                                                 
MFA-TR*             ,2PART_RATE_FLG                                             
MFA-TR*             ,STEP_RATE_FLG                                              
MFA-TR*             ,TOTAL_CHARGES_CREDIT                                       
MFA-TR*             ,CSC_ADJ_EXIST                                              
MFA-TR*             ,MULT_MTR_REG_FLG                                           
MFA-TR*             ,SOLAR_RATE_FLG                                             
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S2-RETURN-CODE                                              
MFA-TR*           ,:S2-APPL-RETURN-CODE                                         
MFA-TR*           ,:S2-BC-BILL-NO                                               
MFA-TR*           ,:S2-BILL-NO                                                  
MFA-TR*           ,:S2-BILLING-MONTH                                            
MFA-TR*           ,:S2-DATE-BILLED                                              
MFA-TR*           ,:S2-BILL-ITEM-TIMESTMP                                       
MFA-TR*           ,:S2-CODE-UTIL-TYPE                                           
MFA-TR*           ,:S2-IC-NO                                                    
MFA-TR*           ,:S2-RATE-PLAN-NO                                             
MFA-TR*           ,:S2-RATE-DESC                                                
MFA-TR*           ,:S2-OPTION-CD                                                
MFA-TR*           ,:S2-OPTION-DESC                                              
MFA-TR*           ,:S2-OPTION-CALC-TYPE-CD                                      
MFA-TR*           ,:S2-TOT-UTILITY                                              
MFA-TR*           ,:S2-TOT-USAGE                                                
MFA-TR*           ,:S2-WNA-AMOUNT                                               
MFA-TR*           ,:S2-AVG-COST-PER-USG                                         
MFA-TR*           ,:S2-AVG-COST-PER-DAY                                         
MFA-TR*           ,:S2-NO-OF-DAYS                                               
MFA-TR*           ,:S2-AVG-USG-PER-DAY                                          
MFA-TR*           ,:S2-AGL-CHARGE                                               
MFA-TR*           ,:S2-DATE-READ                                                
MFA-TR*           ,:S2-CODE-MTR-READ                                            
MFA-TR*           ,:S2-METER-NO                                                 
MFA-TR*           ,:S2-METER-READING                                            
MFA-TR*           ,:S2-STATE-TAX-AMT                                            
MFA-TR*           ,:S2-CITY-TAX-AMT                                             
MFA-TR*           ,:S2-UNIT-PRICE-AMT                                           
MFA-TR*           ,:S2-CALC-COMP-AMT                                            
MFA-TR*           ,:S2-READ-UNITS                                               
MFA-TR*           ,:S2-BFC-CHARGE                                               
MFA-TR*           ,:S2-SPC-DDC-CHARGE                                           
MFA-TR*           ,:S2-UNBIL-REBIL-FLG                                          
MFA-TR*           ,:S2-DDC-FACTOR                                               
MFA-TR*           ,:S2-2PART-RATE-FLG                                           
MFA-TR*           ,:S2-STEP-RATE-FLG                                            
MFA-TR*           ,:S2-TOTAL-CHARGES-CREDIT                                     
MFA-TR*           ,:S2-CSC-ADJ-EXIST                                            
MFA-TR*           ,:S2-MULT-MTR-REG-FLG                                         
MFA-TR*           ,:S2-SOLAR-RATE-FLG                                           
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S2-RETURN-CODE.             
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                     TO  CTR-ROWS-RS2               
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8020'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04638_R2'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
        8020-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 8030-INSERT-GTT-R3.       BUS RULE ACTN                        *        
      ******************************************************************        
       8030-INSERT-GTT-R3.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04638_R3                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,BILLING_MONTH                                        
                  ,DATE_BILLED                                          
                  ,CODE_UTIL_TYPE                                       
                  ,IC_NO                                                
                  ,BUS_RULE_ID                                          
                  ,BUS_RESULT_CD                                        
                  ,BUS_RULE_XREF_ID                                     
                  ,MESSAGE_PARMS                                        
                  ,LINK_PARMS                                           
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S3-RETURN-CODE                                      
                  ,:S3-APPL-RETURN-CODE                                 
                  ,:S3-BILLING-MONTH                                    
                  ,:S3-DATE-BILLED                                      
                  ,:S3-CODE-UTIL-TYPE                                   
                  ,:S3-IC-NO                                            
                  ,:S3-RULE-ID                                          
                  ,:S3-RULE-RESULT-CD                                   
                  ,:S3-BUS-RULE-XREF-ID                                 
                  ,:S3-MESSAGE-PARMS                                    
                  ,:S3-LINK-PARMS                                       
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04638_R3                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,BILLING_MONTH                                                
MFA-TR*           ,DATE_BILLED                                                  
MFA-TR*           ,CODE_UTIL_TYPE                                               
MFA-TR*           ,IC_NO                                                        
MFA-TR*           ,BUS_RULE_ID                                                  
MFA-TR*           ,BUS_RESULT_CD                                                
MFA-TR*           ,BUS_RULE_XREF_ID                                             
MFA-TR*           ,MESSAGE_PARMS                                                
MFA-TR*           ,LINK_PARMS                                                   
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S3-RETURN-CODE                                              
MFA-TR*           ,:S3-APPL-RETURN-CODE                                         
MFA-TR*           ,:S3-BILLING-MONTH                                            
MFA-TR*           ,:S3-DATE-BILLED                                              
MFA-TR*           ,:S3-CODE-UTIL-TYPE                                           
MFA-TR*           ,:S3-IC-NO                                                    
MFA-TR*           ,:S3-RULE-ID                                                  
MFA-TR*           ,:S3-RULE-RESULT-CD                                           
MFA-TR*           ,:S3-BUS-RULE-XREF-ID                                         
MFA-TR*           ,:S3-MESSAGE-PARMS                                            
MFA-TR*           ,:S3-LINK-PARMS                                               
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S3-RETURN-CODE.             
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                     TO  CTR-ROWS-RS3               
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8030'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04638_R3'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
        8030-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 8040-INSERT-GTT-R4.                                            *        
      ******************************************************************        
       8040-INSERT-GTT-R4.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04638_R4                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,BILL_NO                                              
                  ,DATE_BILLED                                          
                  ,BILLING_MONTH                                        
                  ,BILL_ITEM_TIMESTAMP                                  
                  ,CODE_UTIL_TYPE                                       
                  ,IC_NO                                                
                  ,FACTOR_ID                                            
                  ,CODE_DEBIT_CREDIT                                    
                  ,FACTOR                                               
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S4-RETURN-CODE                                      
                  ,:S4-APPL-RETURN-CODE                                 
                  ,:S4-BILL-NO                                          
                  ,:S4-DATE-BILLED                                      
                  ,:S4-BILLING-MONTH                                    
                  ,:S4-BILL-ITEM-TIMESTMP                               
                  ,:S4-CODE-UTIL-TYPE                                   
                  ,:S4-IC-NO                                            
                  ,:S4-FACTOR-ID                                        
                  ,:S4-CODE-DEBIT-CREDIT                                
                  ,:S4-FACTOR                                           
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04638_R4                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,BILL_NO                                                      
MFA-TR*           ,DATE_BILLED                                                  
MFA-TR*           ,BILLING_MONTH                                                
MFA-TR*           ,BILL_ITEM_TIMESTAMP                                          
MFA-TR*           ,CODE_UTIL_TYPE                                               
MFA-TR*           ,IC_NO                                                        
MFA-TR*           ,FACTOR_ID                                                    
MFA-TR*           ,CODE_DEBIT_CREDIT                                            
MFA-TR*           ,FACTOR                                                       
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S4-RETURN-CODE                                              
MFA-TR*           ,:S4-APPL-RETURN-CODE                                         
MFA-TR*           ,:S4-BILL-NO                                                  
MFA-TR*           ,:S4-DATE-BILLED                                              
MFA-TR*           ,:S4-BILLING-MONTH                                            
MFA-TR*           ,:S4-BILL-ITEM-TIMESTMP                                       
MFA-TR*           ,:S4-CODE-UTIL-TYPE                                           
MFA-TR*           ,:S4-IC-NO                                                    
MFA-TR*           ,:S4-FACTOR-ID                                                
MFA-TR*           ,:S4-CODE-DEBIT-CREDIT                                        
MFA-TR*           ,:S4-FACTOR                                                   
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S4-RETURN-CODE.             
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                     TO  CTR-ROWS-RS4               
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8040'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04638_R4'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
        8040-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 8050-INSERT-GTT-R5.                                            *        
      ******************************************************************        
       8050-INSERT-GTT-R5.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04638_R5                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,WEATHER_SRVC_DIV                                     
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S5-RETURN-CODE                                      
                  ,:S5-APPL-RETURN-CODE                                 
                  ,:S5-WEATHER-SRVC-DIV                                 
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04638_R5                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,WEATHER_SRVC_DIV                                             
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S5-RETURN-CODE                                              
MFA-TR*           ,:S5-APPL-RETURN-CODE                                         
MFA-TR*           ,:S5-WEATHER-SRVC-DIV                                         
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S5-RETURN-CODE.             
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                     TO  CTR-ROWS-RS5               
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8050'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04638_R5'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
        8050-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      * 8800-CHECK-RESULTS.                                           *         
      *****************************************************************         
       8800-CHECK-RESULTS.                                              
                                                                        
           IF CTR-ROWS-RS1 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-1                            
              MOVE   0                       TO S1-RETURN-CODE          
              MOVE 100                       TO S1-APPL-RETURN-CODE     
              PERFORM 8010-INSERT-GTT-R1     THRU 8010-EXIT             
           END-IF.                                                      
      *                                                                         
           IF CTR-ROWS-RS2 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-2                            
              MOVE   0                       TO S2-RETURN-CODE          
              MOVE 100                       TO S2-APPL-RETURN-CODE     
              PERFORM 8020-INSERT-GTT-R2     THRU 8020-EXIT             
           END-IF.                                                      
      *                                                                         
           IF CTR-ROWS-RS3 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-3                            
              MOVE   0                       TO S3-RETURN-CODE          
              MOVE 100                       TO S3-APPL-RETURN-CODE     
              PERFORM 8030-INSERT-GTT-R3     THRU 8030-EXIT             
           END-IF.                                                      
      *                                                                         
           IF CTR-ROWS-RS4 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-4                            
              MOVE   0                       TO S4-RETURN-CODE          
              MOVE 100                       TO S4-APPL-RETURN-CODE     
              PERFORM 8040-INSERT-GTT-R4     THRU 8040-EXIT             
           END-IF.                                                      
      *                                                                         
           IF CTR-ROWS-RS5 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-5                            
              MOVE   0                       TO S5-RETURN-CODE          
              MOVE 100                       TO S5-APPL-RETURN-CODE     
              PERFORM 8050-INSERT-GTT-R5     THRU 8050-EXIT             
           END-IF.                                                      
      *                                                                         
       8800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8900-SEND-DONE.                                                *        
      ******************************************************************        
       8900-SEND-DONE.                                                  
                                                                        
           MOVE PROGRAM-NAME          TO ABEND-PROGRAM                  
           MOVE '8900'                TO ACTIVE-PARAGRAPH               
           MOVE 'OPEN'                TO ABEND-FUNCTION                 
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S1-RETURN-CODE.             
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE 'CSR04638_R1'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C2                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S2-RETURN-CODE.             
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE 'CSR04638_R2'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C3                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C3 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S3-RETURN-CODE.             
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE 'CSR04638_R3'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C4                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C4 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S4-RETURN-CODE.             
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE 'CSR04638_R4'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C5                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C5 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S5-RETURN-CODE.             
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE 'CSR04638_R5'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9000-SEND-ERROR-RESULT                                         *        
      ******************************************************************        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE       TO ABEND-SQLCODE            
                                               S1-RETURN-CODE           
                                               S2-RETURN-CODE           
                                               S3-RETURN-CODE           
                                               S4-RETURN-CODE           
                                               S5-RETURN-CODE.          
                                                                        
           MOVE WS-APPL-RETURN-CODE         TO S1-APPL-RETURN-CODE      
                                               S2-APPL-RETURN-CODE      
                                               S3-APPL-RETURN-CODE      
                                               S4-APPL-RETURN-CODE      
                                               S5-APPL-RETURN-CODE.     
                                                                        
           MOVE SQLERRMC                    TO ABEND-SQLERRMC.          
                                                                        
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'               TO ABEND-FUNCTION           
           END-IF.                                                      
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1        THRU 0100A-EXIT.         
           PERFORM 0100B-DECLARE-GTT-R2        THRU 0100B-EXIT.         
           PERFORM 0100C-DECLARE-GTT-R3        THRU 0100C-EXIT.         
           PERFORM 0100D-DECLARE-GTT-R4        THRU 0100D-EXIT.         
           PERFORM 0100E-DECLARE-GTT-R5        THRU 0100E-EXIT.         
                                                                        
           PERFORM 8010-INSERT-GTT-R1          THRU 8010-EXIT.          
           PERFORM 8020-INSERT-GTT-R2          THRU 8020-EXIT.          
           PERFORM 8030-INSERT-GTT-R3          THRU 8030-EXIT.          
           PERFORM 8040-INSERT-GTT-R4          THRU 8040-EXIT.          
           PERFORM 8050-INSERT-GTT-R5          THRU 8050-EXIT.          
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9700-ABEND-PROCESSING.                                         *        
      ******************************************************************        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT.             
           PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT.             
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  6000-START-BILL-ANLYS-VLDT                                    *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00831                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 9900-SQL-ERROR-ROUTINE.                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9999-END-PROGRAM.                                              *        
      ******************************************************************        
                                                                        
       9999-END-PROGRAM.                                                
                                                                        
            PERFORM 8800-CHECK-RESULTS THRU 8800-EXIT                   
            PERFORM 8900-SEND-DONE     THRU 8900-EXIT                   
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
