       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04637.                                         
COB303 DATE-WRITTEN. MAY 20, 2013.                                       
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      ******************************************************************00160000
      *                 P R O G R A M  S U M M A R Y                   *00170000
      *                                                                *00180000
      *  THIS PROGRAM RETRIEVES TEMPERATURE INFORMATION FOR THE WEATHER*00220000
      *  DEGREES.                                                      *00230000
      *                                                                *00240000
      ******************************************************************00250000
      *                                                                *00260000
      *                     PROGRAM MODIFICATION LOG                   *00270000
      *                                                                *00280000
      *    DATE    INITIALS   COMMENTS                                 *00290000
      *  --------  --------   ---------------------------------------  *00300000
      *  05/20/13  SV95326    NEW PROGRAM.                             *00310000
A04880*  03/03/14  SV95326    ACT043 - REMOVE THE FETCH LIMIT FROM     *        
A04880*                       PROCESS PARA FOR TEMPERATURE CACHING.    *        
ACT130*  06/05/16  MS7M727    TO REMOVE COLUMN REFERRED IN             *00320000
      *            A05460     CSS_TEMPERATURE TABLE                    *00320000
      ******************************************************************00330000
      ******************************************************************00340000
      *                                                                *00350000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00360000
      *                                                                *00370000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00380000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00390000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00400000
      *  3000 - 4999  NOT USED                                         *00410000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00420000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00430000
      *  7000 - 7999  INPUT MODULES                                    *00440000
      *  8000 - 8999  OUTPUT MODULES                                   *00450000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00460000
      *                                                                *00470000
      ******************************************************************00480000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04637'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04637 STARTS HERE'.                  
                                                                        
                                                                        
      *================================================================*00860000
      *    DB2 INCLUDES                                                *00590000
      *================================================================*00860000
                                                                        
           EXEC SQL                                                     00620000
              INCLUDE SQLCA                                             00630000
           END-EXEC.                                                    00640000
                                                                        
           EXEC SQL                                                     00660000
              INCLUDE TBTEMPIN                                          00670000
           END-EXEC.                                                    00680000
                                                                        
           EXEC SQL                                                     00700000
              INCLUDE TBMODEL                                           00710000
           END-EXEC.                                                    00720000
                                                                        
      *================================================================*00860000
      * CSS_JOB_PARM, G6                                               *00881912
      *================================================================*00860000
           EXEC SQL                                                     00592000
              INCLUDE TBJBPARM                                          00593000
           END-EXEC.                                                    00594000
      *================================================================*00860000
      * JC01 WORK DATA                                                 *00881912
      *================================================================*00860000
                                                                        
           EXEC SQL                                                             
               INCLUDE CWS00038                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE FIOJC01                                                  
           END-EXEC.                                                            
                                                                        
      *================================================================*00860000
      *    COBOL WORKING STORAGE COPY BOOKS                            *00760000
      *================================================================*00860000
                                                                        
           COPY CCA00001.                                               00810000
           COPY CWS00027.                                               00830000
           COPY CWS00303.                                               00840000
                                                                        
      *================================================================*00860000
      *    WORK AREAS                                                  *00870000
      *================================================================*00860000
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
           05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                  
                                                                        
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-L                  PIC S9(9) COMP.                  
           05  PARM-COMPANY-NO         PIC X(2)   VALUE SPACES.         
           05  PARM-TEMPR-STRT-DT      PIC X(10)  VALUE SPACES.         
           05  PARM-TEMPR-END-DT       PIC X(10)  VALUE SPACES.         
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR04637'.      
           05  WS-COMPANY-NO           PIC X(2)  VALUE ZERO.            
           05  WS-COMPANY-NO1          PIC X(2)  VALUE ZERO.            
           05  WS-COMPANY-NO2          PIC X(2)  VALUE ZERO.            
           05  WS-TEMPR-STRT-DT        PIC X(10) VALUE SPACES.          
           05  WS-TEMPR-END-DT         PIC X(10) VALUE SPACES.          
COB305     05 WS-COLA-AVG        PIC S999V USAGE COMP-3 VALUE 0.          
COB305     05 WS-CHAS-AVG        PIC S999V USAGE COMP-3 VALUE 0.          
COB305     05 WS-AIKEN-AVG        PIC S999V USAGE COMP-3 VALUE 0.          
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE           PIC S9(9) COMP VALUE 0.          
           05  S-TEMP-DT               PIC X(10) VALUE SPACE.           
COB305     05 S-CHAS-HIGH        PIC S999V USAGE COMP-3 VALUE 0.          
COB305     05 S-AIKEN-HIGH        PIC S999V USAGE COMP-3 VALUE 0.          
COB305     05 S-COLA-HIGH        PIC S999V USAGE COMP-3 VALUE 0.          
COB305     05 S-CHAS-NORM        PIC S999V USAGE COMP-3 VALUE 0.          
COB305     05 S-AIKEN-NORM        PIC S999V USAGE COMP-3 VALUE 0.          
COB305     05 S-COLA-NORM        PIC S999V USAGE COMP-3 VALUE 0.          
COB305     05 S-CHAS-LOW        PIC S999V USAGE COMP-3 VALUE 0.          
COB305     05 S-AIKEN-LOW        PIC S999V USAGE COMP-3 VALUE 0.          
COB305     05 S-COLA-LOW        PIC S999V USAGE COMP-3 VALUE 0.          
COB305     05 S-ACT-ACCUM-DEGREE        PIC S9(05)V99 USAGE COMP-3 
COB305       VALUE 0.      
COB305     05 S-ACT-HEAT-DEGREE        PIC S99V99 USAGE COMP-3 VALUE 0.         
COB305     05 S-NORM-ACCUM-DEGREE        PIC S9(05)V99 USAGE COMP-3 
COB305       VALUE 0.      
COB305     05 S-NORM-HEAT-DEGREE        PIC S99V99 USAGE COMP-3 VALUE 0.        
           05  S-COMPANY-NO            PIC X(02) VALUE SPACE.           
COB305     05 S-NORM-TEMP        PIC S999V USAGE COMP-3 VALUE 0.          
COB305     05 S-CDD        PIC S999V USAGE COMP-3 VALUE 0.          
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
      *================================================================*01820000
      *    CURSOR DECLARATIONS                                         *01830000
      *================================================================*01820000
           EXEC SQL DECLARE TEMPERATURE-CURSOR CURSOR FOR               
              SELECT TEMP_DT          ,                                 
                     CHAS_HIGH        ,                                 
                     AIKEN_HIGH       ,                                 
                     COLA_HIGH        ,                                 
                     CHAS_NORM        ,                                 
                     AIKEN_NORM       ,                                 
                     COLA_NORM        ,                                 
                     CHAS_LOW         ,                                 
                     AIKEN_LOW        ,                                 
                     COLA_LOW         ,                                 
                     ACT_ACCUM_DEGREE ,                                 
                     ACT_HEAT_DEGREE  ,                                 
                     NORM_ACCUM_DEGREE,                                 
                     NORM_HEAT_DEGREE ,                                 
                     COMPANY_NO                                         
                FROM CSS_TEMPERATURE WITH(READUNCOMMITTED)                      
               WHERE TEMP_DT >= IIF(TRY_CONVERT(DATE, :WS-TEMPR-STRT-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-TEMPR-STRT-DT
              ) <> 0) OR (LEN(:WS-TEMPR-STRT-DT) <> 10), CIS.CHAR2DATE(
                                                      :WS-TEMPR-STRT-DT
              ), CONVERT(DATE, :WS-TEMPR-STRT-DT) )                       
                 AND TEMP_DT <= IIF(TRY_CONVERT(DATE, :WS-TEMPR-END-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-TEMPR-END-DT
              ) <> 0) OR (LEN(:WS-TEMPR-END-DT) <> 10), CIS.CHAR2DATE(
                                                       :WS-TEMPR-END-DT
              ), CONVERT(DATE, :WS-TEMPR-END-DT) )                        
                 AND COMPANY_NO IN ( :WS-COMPANY-NO1,:WS-COMPANY-NO2)   
            ORDER BY TEMP_DT DESC                                       
              FOR READ ONLY                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL DECLARE TEMPERATURE-CURSOR CURSOR FOR               01850000
MFA-TR*       SELECT TEMP_DT          ,                                 01851000
MFA-TR*              CHAS_HIGH        ,                                 01860000
MFA-TR*              AIKEN_HIGH       ,                                 01870000
MFA-TR*              COLA_HIGH        ,                                 01880000
MFA-TR*              CHAS_NORM        ,                                 01890000
MFA-TR*              AIKEN_NORM       ,                                 01900000
MFA-TR*              COLA_NORM        ,                                 01910000
MFA-TR*              CHAS_LOW         ,                                 01920000
MFA-TR*              AIKEN_LOW        ,                                 01930000
MFA-TR*              COLA_LOW         ,                                 01940000
MFA-TR*              ACT_ACCUM_DEGREE ,                                 01950000
MFA-TR*              ACT_HEAT_DEGREE  ,                                 01960000
MFA-TR*              NORM_ACCUM_DEGREE,                                 01970000
MFA-TR*              NORM_HEAT_DEGREE ,                                 01980000
MFA-TR*              COMPANY_NO                                                 
MFA-TR*         FROM CSS_TEMPERATURE                                    01981000
MFA-TR*        WHERE TEMP_DT >= :WS-TEMPR-STRT-DT                       01982000
MFA-TR*          AND TEMP_DT <= :WS-TEMPR-END-DT                        01982000
MFA-TR*          AND COMPANY_NO IN ( :WS-COMPANY-NO1,:WS-COMPANY-NO2)   01984001
MFA-TR*     ORDER BY TEMP_DT DESC                                       01985000
MFA-TR*       FOR FETCH ONLY                                                    
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC.                                                    01990000
                                                                        
HPCCDM*EJECT                                                            02021000
           EXEC SQL                                                     00000010
               INCLUDE CWSX0010                                         00000020
           END-EXEC.                                                    00000030
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
           10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT                                                   
                  LTRIM(RTRIM(TEMP_DT))    AS   TEMP_DT                        
                 ,CHAS_HIGH                                             
                 ,AIKEN_HIGH                                            
                 ,COLA_HIGH                                             
                 ,CHAS_NORM                                             
                 ,AIKEN_NORM                                            
                 ,COLA_NORM                                             
                 ,CHAS_LOW                                              
                 ,AIKEN_LOW                                             
                 ,COLA_LOW                                              
                 ,ACT_ACCUM_DEGREE                                      
                 ,ACT_HEAT_DEGREE                                       
                 ,NORM_ACCUM_DEGREE                                     
                 ,NORM_HEAT_DEGREE                                      
                 ,RETURN_CODE                                           
                 ,LTRIM(RTRIM(COMPANY_NO)) AS   COMPANY_NO                     
                 ,NORM_TEMP                                             
                 ,CDD                                                   
               FROM #CSR04637_R1                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     00000100
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                        00000300
MFA-TR*        SELECT                                                   00000400
MFA-TR*           STRIP(TEMP_DT)    AS   TEMP_DT                                
MFA-TR*          ,CHAS_HIGH                                                     
MFA-TR*          ,AIKEN_HIGH                                                    
MFA-TR*          ,COLA_HIGH                                                     
MFA-TR*          ,CHAS_NORM                                                     
MFA-TR*          ,AIKEN_NORM                                                    
MFA-TR*          ,COLA_NORM                                                     
MFA-TR*          ,CHAS_LOW                                                      
MFA-TR*          ,AIKEN_LOW                                                     
MFA-TR*          ,COLA_LOW                                                      
MFA-TR*          ,ACT_ACCUM_DEGREE                                              
MFA-TR*          ,ACT_HEAT_DEGREE                                               
MFA-TR*          ,NORM_ACCUM_DEGREE                                             
MFA-TR*          ,NORM_HEAT_DEGREE                                              
MFA-TR*          ,RETURN_CODE                                                   
MFA-TR*          ,STRIP(COMPANY_NO) AS   COMPANY_NO                             
MFA-TR*          ,NORM_TEMP                                                     
MFA-TR*          ,CDD                                                           
MFA-TR*        FROM SESSION.CSR04637_R1                                 00000500
MFA-TR*    END-EXEC.                                                    00000700
                                                                        
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-COMPANY-NO          PIC X(2)                 .          
       01  LINK-TEMPR-STRT-DT       PIC X(10)                .          
       01  LINK-TEMPR-END-DT        PIC X(10)                .          
                                                                        
       PROCEDURE DIVISION USING                                         
                LINK-COMPANY-NO                                         
               ,LINK-TEMPR-STRT-DT                                      
               ,LINK-TEMPR-END-DT                                       
               .                                                        
           EXEC SQL                                                     
               WHENEVER SQLWARNING                                      
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLERROR                                        
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER NOT FOUND                                       
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
      *================================================================*02050000
       0000-MAINLINE.                                                   
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *02070000
      *================================================================*02050000
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*02200000
       0100-INITIALIZE.                                                 
      *     1. RESET DB2 ERROR HANDLERS                                *02230000
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *02240000
      *     3. CCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)    *02250000
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*02260000
      *================================================================*02200000
                                                                        
                                                                        
           MOVE LINK-COMPANY-NO           TO PARM-COMPANY-NO         .  
           MOVE LINK-TEMPR-STRT-DT        TO PARM-TEMPR-STRT-DT      .  
           MOVE LINK-TEMPR-END-DT         TO PARM-TEMPR-END-DT       .  
           PERFORM 0100A-DECLARE-GTT      THRU 0100A-EXIT.              
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100A-DECLARE-GTT.                                               
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04637_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04637_R1
              (                                                          
               RETURN_CODE              INT                         
              ,TEMP_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2                
              ,CHAS_HIGH                DECIMAL(03,0)                   
              ,AIKEN_HIGH               DECIMAL(03,0)                   
              ,COLA_HIGH                DECIMAL(03,0)                   
              ,CHAS_NORM                DECIMAL(03,0)                   
              ,AIKEN_NORM               DECIMAL(03,0)                   
              ,COLA_NORM                DECIMAL(03,0)                   
              ,CHAS_LOW                 DECIMAL(03,0)                   
              ,AIKEN_LOW                DECIMAL(03,0)                   
              ,COLA_LOW                 DECIMAL(03,0)                   
              ,ACT_ACCUM_DEGREE         DECIMAL(07,2)                   
              ,ACT_HEAT_DEGREE          DECIMAL(04,2)                   
              ,NORM_ACCUM_DEGREE        DECIMAL(07,2)                   
              ,NORM_HEAT_DEGREE         DECIMAL(04,2)                   
              ,COMPANY_NO CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2             
              ,NORM_TEMP                DECIMAL(03,0)                   
              ,CDD                      DECIMAL(03,0)                   
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'               TO ACTIVE-PARAGRAPH        
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04637_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
       0100A-EXIT.                                                      
               EXIT.                                                    
                                                                        
                                                                        
      *================================================================*02550001
       1000-PROCESS-INPUT.                                              
      *================================================================*02564001
                                                                        
                                                                        
           MOVE PARM-COMPANY-NO           TO WS-COMPANY-NO.             
           MOVE PARM-TEMPR-STRT-DT        TO WS-TEMPR-STRT-DT.          
           MOVE PARM-TEMPR-END-DT         TO WS-TEMPR-END-DT.           
           PERFORM 1010-VALIDATE-INPUT    THRU 1010-EXIT.               
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*02860000
       1010-VALIDATE-INPUT.                                             
      *================================================================*02890000
                                                                        
           IF WS-COMPANY-NO = '01' OR '26'                              
              MOVE WS-COMPANY-NO         TO WS-COMPANY-NO1              
                                            WS-COMPANY-NO2              
           ELSE                                                         
              MOVE '01'                  TO WS-COMPANY-NO1              
              MOVE '26'                  TO WS-COMPANY-NO2              
           END-IF.                                                      
                                                                        
           IF WS-TEMPR-STRT-DT       = SPACES                           
              PERFORM 7100-GET-START-DT      THRU 7100-EXIT             
           END-IF.                                                      
                                                                        
           IF WS-TEMPR-END-DT        = SPACES                           
              PERFORM 7200-GET-CURRENT-DATE    THRU 7200-EXIT           
           END-IF.                                                      
                                                                        
       1010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*02860000
       2000-PROCESS-OUTPUT.                                             
      *================================================================*02860000
                                                                        
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
           PERFORM 7300-OPEN-TEMPERATURE-CURSOR  THRU 7300-EXIT.        
                                                                        
           PERFORM 2300-PROCESS-FETCH            THRU 2300-EXIT         
              UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.                  
           PERFORM 7500-CLOSE-TEMPERATURE-CURSOR THRU 7500-EXIT.        
                                                                        
           IF CTR-ROWS < 1                                              
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '2200'          TO ACTIVE-PARAGRAPH                  
              MOVE 'FETCH'              TO ABEND-FUNCTION               
              MOVE 'CSS_TEMPERATURE'    TO TABLE-1                      
              MOVE NOT-FOUND       TO WS-ACTIVE-RETURN-CODE             
              MOVE NOT-FOUND       TO SQLCODE                           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*05110000
       2300-PROCESS-FETCH.                                              
      *================================================================*05130000
                                                                        
           PERFORM 7400-FETCH-TEMP       THRU 7400-EXIT.                
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD 1 TO WS-ROW-COUNT                                     
              MOVE E8-TEMP-DT            TO S-TEMP-DT                   
              MOVE E8-CHAS-HIGH          TO S-CHAS-HIGH                 
              MOVE E8-AIKEN-HIGH         TO S-AIKEN-HIGH                
              MOVE E8-COLA-HIGH          TO S-COLA-HIGH                 
              MOVE E8-CHAS-NORM          TO S-CHAS-NORM                 
              MOVE E8-AIKEN-NORM         TO S-AIKEN-NORM                
              MOVE E8-COLA-NORM          TO S-COLA-NORM                 
              MOVE E8-CHAS-LOW           TO S-CHAS-LOW                  
              MOVE E8-AIKEN-LOW          TO S-AIKEN-LOW                 
              MOVE E8-COLA-LOW           TO S-COLA-LOW                  
              MOVE E8-ACT-ACCUM-DEGREE   TO S-ACT-ACCUM-DEGREE          
              MOVE E8-ACT-HEAT-DEGREE    TO S-ACT-HEAT-DEGREE           
              MOVE E8-NORM-ACCUM-DEGREE  TO S-NORM-ACCUM-DEGREE         
              MOVE E8-NORM-HEAT-DEGREE   TO S-NORM-HEAT-DEGREE          
              MOVE E8-COMPANY-NO         TO S-COMPANY-NO                
              COMPUTE S-NORM-TEMP  = ( E8-CHAS-NORM   +                 
                                       E8-AIKEN-NORM  +                 
                                       E8-COLA-NORM ) / 3               
                                                                        
              COMPUTE WS-COLA-AVG ROUNDED = (E8-COLA-HIGH + E8-COLA-LOW)
                                                    / 2                 
              COMPUTE WS-CHAS-AVG ROUNDED = (E8-CHAS-HIGH + E8-CHAS-LOW)
                                                    / 2                 
              COMPUTE WS-AIKEN-AVG ROUNDED = (E8-AIKEN-HIGH +           
                                                   E8-AIKEN-LOW) / 2    
              COMPUTE S-CDD  = (WS-COLA-AVG + WS-CHAS-AVG +             
                                       WS-AIKEN-AVG) / 3                
              IF S-CDD < 66                                             
                 MOVE 0            TO S-CDD                             
              ELSE                                                      
                 COMPUTE S-CDD = S-CDD - 65                             
              END-IF                                                    
              MOVE '2300'          TO ACTIVE-PARAGRAPH                  
              PERFORM 8100-SEND-RESULT        THRU 8100-EXIT            
           END-IF.                                                      
                                                                        
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *===============================================================* 08152056
       7100-GET-START-DT.                                               
      *===============================================================* 08200056
      *                                                                 08220056
           EXEC SQL                                                     
               SELECT
              DATEADD( YEAR, -3, CAST(SYSDATETIMEOFFSET() AS DATE) )
            INTO
              :WS-TEMPR-STRT-DT            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-TEMPR-STRT-DT= CURRENT DATE - 3 YEARS                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 08250000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 08229356
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7100'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SET'                   TO ABEND-FUNCTION           
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                 08230456
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08260056
      *===============================================================* 08152056
       7200-GET-CURRENT-DATE.                                           
      *===============================================================* 08200056
      *                                                                 08220056
           EXEC SQL                                                     
               SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-TEMPR-END-DT                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-TEMPR-END-DT = CURRENT DATE                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 08250000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 08229356
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7200'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SET'                   TO ABEND-FUNCTION           
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                 08230456
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08260056
      *================================================================*05730000
       7300-OPEN-TEMPERATURE-CURSOR.                                    
      *================================================================*05750000
                                                                        
           EXEC SQL                                                     
              OPEN TEMPERATURE-CURSOR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7300'          TO ACTIVE-PARAGRAPH                  
              MOVE 'OPEN'          TO ABEND-FUNCTION                    
              MOVE 'CSS_TEMPERATURE'   TO TABLE-1                       
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*05390000
       7400-FETCH-TEMP.                                                 
      *================================================================*05410000
                                                                        
           EXEC SQL                                                     
              FETCH TEMPERATURE-CURSOR                                  
               INTO :E8-TEMP-DT,                                        
                    :E8-CHAS-HIGH,                                      
                    :E8-AIKEN-HIGH,                                     
                    :E8-COLA-HIGH,                                      
                    :E8-CHAS-NORM,                                      
                    :E8-AIKEN-NORM,                                     
                    :E8-COLA-NORM,                                      
                    :E8-CHAS-LOW,                                       
                    :E8-AIKEN-LOW,                                      
                    :E8-COLA-LOW,                                       
                    :E8-ACT-ACCUM-DEGREE,                               
                    :E8-ACT-HEAT-DEGREE,                                
                    :E8-NORM-ACCUM-DEGREE,                              
                    :E8-NORM-HEAT-DEGREE,                               
                    :E8-COMPANY-NO                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7400'          TO ACTIVE-PARAGRAPH                  
              MOVE 'FETCH'         TO ABEND-FUNCTION                    
              MOVE 'CSS_TEMPERATURE'    TO TABLE-1                      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*06020000
       7500-CLOSE-TEMPERATURE-CURSOR.                                   
      *================================================================*06040000
                                                                        
           EXEC SQL                                                     
              CLOSE TEMPERATURE-CURSOR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7500'          TO ACTIVE-PARAGRAPH                  
              MOVE 'CLOSE'         TO ABEND-FUNCTION                    
              MOVE 'CSS_TEMPERATURE'    TO TABLE-1                      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*06310000
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                     06320000
      *================================================================*06330000
           EXEC SQL                                                     06340000
              INCLUDE CPDSP300                                          06350000
           END-EXEC.                                                    06360000
                                                                        
      *================================================================*06420000
       8100-SEND-RESULT.                                                
      *================================================================*06420000
      *                                                                         
           EXEC SQL                                                     
             INSERT INTO #CSR04637_R1                            
             (                                                          
              RETURN_CODE                                               
             ,TEMP_DT                                                   
             ,CHAS_HIGH                                                 
             ,AIKEN_HIGH                                                
             ,COLA_HIGH                                                 
             ,CHAS_NORM                                                 
             ,AIKEN_NORM                                                
             ,COLA_NORM                                                 
             ,CHAS_LOW                                                  
             ,AIKEN_LOW                                                 
             ,COLA_LOW                                                  
             ,ACT_ACCUM_DEGREE                                          
             ,ACT_HEAT_DEGREE                                           
             ,NORM_ACCUM_DEGREE                                         
             ,NORM_HEAT_DEGREE                                          
             ,COMPANY_NO                                                
             ,NORM_TEMP                                                 
             ,CDD                                                       
             )                                                          
             VALUES                                                     
             (                                                          
              :S-RETURN-CODE                                            
             ,:S-TEMP-DT                                                
             ,:S-CHAS-HIGH                                              
             ,:S-AIKEN-HIGH                                             
             ,:S-COLA-HIGH                                              
             ,:S-CHAS-NORM                                              
             ,:S-AIKEN-NORM                                             
             ,:S-COLA-NORM                                              
             ,:S-CHAS-LOW                                               
             ,:S-AIKEN-LOW                                              
             ,:S-COLA-LOW                                               
             ,:S-ACT-ACCUM-DEGREE                                       
             ,:S-ACT-HEAT-DEGREE                                        
             ,:S-NORM-ACCUM-DEGREE                                      
             ,:S-NORM-HEAT-DEGREE                                       
             ,:S-COMPANY-NO                                             
             ,:S-NORM-TEMP                                              
             ,:S-CDD                                                    
             )                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04637_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,TEMP_DT                                                           
MFA-TR*      ,CHAS_HIGH                                                         
MFA-TR*      ,AIKEN_HIGH                                                        
MFA-TR*      ,COLA_HIGH                                                         
MFA-TR*      ,CHAS_NORM                                                         
MFA-TR*      ,AIKEN_NORM                                                        
MFA-TR*      ,COLA_NORM                                                         
MFA-TR*      ,CHAS_LOW                                                          
MFA-TR*      ,AIKEN_LOW                                                         
MFA-TR*      ,COLA_LOW                                                          
MFA-TR*      ,ACT_ACCUM_DEGREE                                                  
MFA-TR*      ,ACT_HEAT_DEGREE                                                   
MFA-TR*      ,NORM_ACCUM_DEGREE                                                 
MFA-TR*      ,NORM_HEAT_DEGREE                                                  
MFA-TR*      ,COMPANY_NO                                                        
MFA-TR*      ,NORM_TEMP                                                         
MFA-TR*      ,CDD                                                               
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S-RETURN-CODE                                                    
MFA-TR*      ,:S-TEMP-DT                                                        
MFA-TR*      ,:S-CHAS-HIGH                                                      
MFA-TR*      ,:S-AIKEN-HIGH                                                     
MFA-TR*      ,:S-COLA-HIGH                                                      
MFA-TR*      ,:S-CHAS-NORM                                                      
MFA-TR*      ,:S-AIKEN-NORM                                                     
MFA-TR*      ,:S-COLA-NORM                                                      
MFA-TR*      ,:S-CHAS-LOW                                                       
MFA-TR*      ,:S-AIKEN-LOW                                                      
MFA-TR*      ,:S-COLA-LOW                                                       
MFA-TR*      ,:S-ACT-ACCUM-DEGREE                                               
MFA-TR*      ,:S-ACT-HEAT-DEGREE                                                
MFA-TR*      ,:S-NORM-ACCUM-DEGREE                                              
MFA-TR*      ,:S-NORM-HEAT-DEGREE                                               
MFA-TR*      ,:S-COMPANY-NO                                                     
MFA-TR*      ,:S-NORM-TEMP                                                      
MFA-TR*      ,:S-CDD                                                            
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8100'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04637_R1'        TO TABLE-1                      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8100-EXIT.                                                       
            EXIT.                                                       
      *================================================================*00000100
       8000A-DELETE-GTT-ROWS.                                           
      *================================================================*00000300
      *                                                                 00000500
           MOVE                                                         
           'DELETE ROWS'                                                
               TO S-SQL-STATEMENT-V.                                    
      *                                                                 00000900
            EXEC SQL                                                    
                DELETE FROM #CSR04637_R1                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    00001000
MFA-TR*         DELETE FROM SESSION.CSR04637_R1                         00001100
MFA-TR*     END-EXEC.                                                   00001200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 00001300
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
      *                                                                 00001500
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
                NEXT SENTENCE                                           
            ELSE                                                        
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8000A'              TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04637_R1'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 00003100
       8000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                 00003400
           EXEC SQL                                                     00000100
               INCLUDE CPD00320                                         00000200
           END-EXEC.                                                    00000300
