       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04636.                                         
COB303 DATE-WRITTEN.     MARCH 21, 2013.                                
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM RETRIEVES THE CODE UTIL TYPE & IC NO             *        
      *  BASED ON THE INPUT ACCOUNT NUMBER.                            *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
PRJ724*  05-17-13  MS93554    INITIAL PROGRAM VERSION.                 *        
PRJ801*  06-04-14  MS93554    GETTING ICC+RATE+DESC AS RATE DESC       *        
PRJ821*  01-07-15  VK7L032    ADDITIONAL COLUMNS ADDED IN THE RESULT   *        
PRJ821*                       SET                                      *        
PRJ836*  10-23-15  VK7L032    ADDED APPL_PROGRAM_ID INPUT PARAMETER    *        
PRJ836*                       AND LOGIC TO DETERMINE CIG CUSTOMER      *        
PRJ836*  04-21-16  MN90523    ADDED MIN REVENUE MONTH                  *        
A05460*  05-15-16  SM93554    WHEN FETCHED RATE IS FOUND IN JOB PARM,  *        
      *            ACT-254    PASS THE SECURED FLAG AS 'Y' TO DISPLAY  *        
      *                       CORRECT VIEW IN UI.                      *        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04636'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START         PIC X(40) VALUE                             
           'WORKING STORAGE FOR CSR04636 STARTS HERE'.                  
                                                                        
      *****************************************************************         
      *    DB2 INCLUDES                                               *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_ACCOUNT         AT                                     *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_UTIL_ENVRNMT    UT                                     *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBUTLENV                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_RATE_PLAN_DESC  RD                                     *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBRTDESC                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_CODE_VALUE      UV                                     *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBCDVALU                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
PRJ821* CSS_ACCT_RTPK_AGR, DF                                         *         
PRJ821*****************************************************************         
PRJ821     EXEC SQL                                                             
PRJ821         INCLUDE TBACCTRG                                                 
PRJ821     END-EXEC.                                                            
PRJ821*                                                                         
PRJ821*****************************************************************         
PRJ821* CRM_RT_PKG_OPTION, FI                                         *         
PRJ821*****************************************************************         
PRJ821     EXEC SQL                                                             
PRJ821         INCLUDE TBRTPKGO                                                 
PRJ821     END-EXEC.                                                            
PRJ821*                                                                         
PRJ821*****************************************************************         
PRJ821* CSS_DELINQUENCY, C8                                           *         
PRJ821*****************************************************************         
PRJ821     EXEC SQL                                                             
PRJ821         INCLUDE TBDELQ                                                   
PRJ821     END-EXEC.                                                            
PRJ821*                                                                         
PRJ821*****************************************************************         
PRJ836* CSS_RATE_COMP_DEF, J1                                         *         
PRJ836*****************************************************************         
PRJ836     EXEC SQL                                                             
PRJ836         INCLUDE TBRTCDEF                                                 
PRJ836     END-EXEC.                                                            
PRJ836*                                                                         
PRJ836*****************************************************************         
PRJ836* CSS_BILLING_DET  , BG                                         *         
PRJ836*****************************************************************         
PRJ836     EXEC SQL                                                             
PRJ836         INCLUDE TBBLLDET                                                 
PRJ836     END-EXEC.                                                            
PRJ836*                                                                         
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
       01  WS-MISC.                                                     
           05 PROGRAM-NAME             PIC X(8)        VALUE 'CSR04636'.
COB305     05 WS-ACCOUNT-NO        PIC S9(13)V COMP-3 VALUE 0.             
           05 WS-RATE-DESC             PIC X(80) VALUE SPACES.          
           05 WS-CODE-DESC             PIC X(15) VALUE SPACES.          
           05 WS-IC-NO                 PIC 9(4)  VALUE 0.               
           05 WS-IC-NO-CHAR            PIC X(4)  VALUE SPACES.          
           05 WS-IC-NO-RES             PIC X(4)  VALUE SPACES.          
           05 WS-TALLY1                PIC 9(4)  VALUE 0.               
           05 WS-TALLY2                PIC 9(4)  VALUE 0.               
           05 WS-TOT-LEN               PIC 9(4)  VALUE 4.               
PRJ836     05 WS-CIG-RATE-FL           PIC X(1)  VALUE 'N'.             
PRJ836     05 WS-REV-MTH-NULL-IND      PIC S9(4) COMP VALUE 0.          
PRJ836     05 WS-MIN-REVENUE-MONTH     PIC S9(6)V COMP-3 VALUE 0.       
ACT254     05 WS-PARM                  PIC X(04)  VALUE 'PARM'.         
ACT254     05 WS-ACTIVE                PIC X(01)  VALUE 'A'.            
ACT254     05 WS-ELEC                  PIC X(01)  VALUE 'E'.            
       01  WS-FLAGS.                                                    
           05 WS-YES                   PIC X(01)  VALUE 'Y'.            
           05 WS-NO                    PIC X(01)  VALUE 'N'.            
           05 WS-ZERO                  PIC S9(04) VALUE 0.              
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
           05  WS-NO-MORE-ROWS         PIC X(01) VALUE 'N'.             
               88 NO-MORE-ROWS                   VALUE 'Y'.             
ACT254     05  WS-INDUST-RT-EXIST      PIC X(01) VALUE 'N'.             
ACT254         88 INDUST-RT-EXIST                VALUE 'Y'.             
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
                                                                        
       01  GTT-RETURN-FIELDS.                                           
            05 S-RETURN-CODE           PIC S9(9)      COMP VALUE 0.     
            05 S-APPL-RETURN-CODE      PIC S9(9)      COMP VALUE 0.     
            05 S-ACCOUNT-NO            PIC S9(13)V    COMP-3 VALUE 0.   
            05 S-PREMISE-NO            PIC S9(10)V    COMP-3 VALUE 0.   
            05 S-CODE-ACCT-STAT        PIC X(01)      VALUE SPACES.     
            05 S-CODE-UTIL-TYPE        PIC X(01)      VALUE SPACES.     
            05 S-IC-NO                 PIC S9(4)      COMP VALUE 0.     
            05 S-COMPANY-NO            PIC X(02)      VALUE SPACES.     
            05 S-RATE-PLAN-NO          PIC X(03)      VALUE SPACES.     
            05 S-RATE-DESC             PIC X(80)      VALUE SPACES.     
            05 S-SECURED-RATE-FL       PIC X(01)      VALUE SPACES.     
            05 S-RATE-PLAN-DESC        PIC X(50)      VALUE SPACES.     
            05 S-OPTION-CD             PIC X(12)      VALUE SPACES.     
            05 S-OPTION-DESC           PIC X(50)      VALUE SPACES.     
PRJ836      05 S-CIG-RATE-FL           PIC X(01)      VALUE SPACES.     
PRJ836      05 S-MIN-REVENUE-MONTH     PIC S9(6)V     COMP-3 VALUE 0.   
                                                                        
PRJ821     05  WS-DATABASE             PIC 9(01) VALUE ZERO.            
PRJ821         88  CSR-DATABASE                  VALUE 1.               
PRJ821         88  SEB-DATABASE                  VALUE 2.               
      ******************************************************************        
      *   CURSOR TO RETRIEVE UTIL TYPE AND IC NO BASED ON THE          *        
      *   INPUT ACCOUNT NUMBER.                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
             DECLARE ACCT_CURSOR CURSOR FOR                             
              SELECT AT.ACCOUNT_NO                                      
                    ,AT.PREMISE_NO                                      
                    ,AT.CODE_ACCT_STAT                                  
PRJ836              ,AT.ACCOUNT_TYPE_CODE                               
                    ,UT.CODE_UTIL_TYPE                                  
                    ,UT.IC_NO                                           
                    ,UT.COMPANY_NO                                      
                    ,UT.RATE_PLAN_NO                                    
PRJ821              ,UT.RT_PKG_OPT_SEQ_NO                               
                    ,RD.RATE_DESC                                       
                    ,RD.SECURED_RATE_FL                                 
                FROM CSS_ACCOUNT             AT WITH(READUNCOMMITTED)           
                    ,CSS_UTIL_ENVRNMT        UT WITH(READUNCOMMITTED)           
                    ,CSS_RATE_PLAN_DESC      RD WITH(READUNCOMMITTED)           
               WHERE AT.ACCOUNT_NO     = :AT-ACCOUNT-NO                 
                 AND AT.ACCOUNT_NO     =  UT.ACCOUNT_NO                 
                 AND UT.RATE_PLAN_NO   =  RD.RATE_PLAN_NO               
                 AND UT.CODE_UTIL_TYPE =  RD.CODE_UTIL_TYPE             
                 FOR READ ONLY                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE ACCT_CURSOR CURSOR FOR                                     
MFA-TR*       SELECT AT.ACCOUNT_NO                                              
MFA-TR*             ,AT.PREMISE_NO                                              
MFA-TR*             ,AT.CODE_ACCT_STAT                                          
MFA-TR*             ,AT.ACCOUNT_TYPE_CODE                                       
MFA-TR*             ,UT.CODE_UTIL_TYPE                                          
MFA-TR*             ,UT.IC_NO                                                   
MFA-TR*             ,UT.COMPANY_NO                                              
MFA-TR*             ,UT.RATE_PLAN_NO                                            
MFA-TR*             ,UT.RT_PKG_OPT_SEQ_NO                                       
MFA-TR*             ,RD.RATE_DESC                                               
MFA-TR*             ,RD.SECURED_RATE_FL                                         
MFA-TR*         FROM CSS_ACCOUNT             AT                                 
MFA-TR*             ,CSS_UTIL_ENVRNMT        UT                                 
MFA-TR*             ,CSS_RATE_PLAN_DESC      RD                                 
MFA-TR*        WHERE AT.ACCOUNT_NO     = :AT-ACCOUNT-NO                         
MFA-TR*          AND AT.ACCOUNT_NO     =  UT.ACCOUNT_NO                         
MFA-TR*          AND UT.RATE_PLAN_NO   =  RD.RATE_PLAN_NO                       
MFA-TR*          AND UT.CODE_UTIL_TYPE =  RD.CODE_UTIL_TYPE                     
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
           10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
                                                                        
                                                                        
                                                                        
       LINKAGE SECTION.                                                 
COB305 01 PARM-ACCOUNT-NO        PIC S9(13)V COMP-3 VALUE 0.                 
       01 PARM-APPL-PROGRAM-ID     PIC X(03).                           
                                                                        
       PROCEDURE DIVISION USING PARM-ACCOUNT-NO                         
                                PARM-APPL-PROGRAM-ID.                   
                                                                        
      ******************************************************************        
      * 0000-MAINLINE.                                                 *        
      *                                                                *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE          THRU 0100-EXIT.             
           PERFORM 1000-PROCESS-INPUT       THRU 1000-EXIT.             
           PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT.             
           PERFORM 9999-END-PROGRAM         THRU 9999-EXIT.             
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE.                                               *        
      *                                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           PERFORM 0100A-DECLARE-GTT    THRU 0100A-EXIT.                
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100A-DECLARE-GTT.                                             *        
      *                                                                *        
      ******************************************************************        
       0100A-DECLARE-GTT.                                               
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04636_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04636_R1
              (                                                          
               RETURN_CODE              INT                         
              ,APPL_RETURN_CODE         INT                         
              ,ACCOUNT_NO               DECIMAL(13,0)                   
              ,PREMISE_NO               DECIMAL(10,0)                   
              ,CODE_ACCT_STAT CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
              ,CODE_UTIL_TYPE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
              ,IC_NO                    SMALLINT                        
              ,COMPANY_NO CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2             
              ,RATE_PLAN_NO CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2           
              ,RATE_DESC CHAR(80)  COLLATE LATIN1_GENERAL_100_BIN2              
PRJ821        ,RATE_PLAN_DESC CHAR(50)  COLLATE LATIN1_GENERAL_100_BIN2         
PRJ821        ,SECURED_RATE_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2        
PRJ821        ,OPTION_CD CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2              
PRJ821        ,OPTION_DESC CHAR(50)  COLLATE LATIN1_GENERAL_100_BIN2            
PRJ836        ,CIG_RATE_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2            
PRJ836        ,MIN_REVENUE_MONTH        DECIMAL(06)                     
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   CONTINUE                                             
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'               TO ACTIVE-PARAGRAPH        
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04636_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT        
               END-IF                                                   
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
               SELECT RETURN_CODE                                       
                     ,APPL_RETURN_CODE                                  
                     ,ACCOUNT_NO                                        
                     ,PREMISE_NO                                        
                     ,CODE_ACCT_STAT                                    
                     ,CODE_UTIL_TYPE                                    
                     ,IC_NO                                             
                     ,COMPANY_NO                                        
                     ,RATE_PLAN_NO                                      
                     ,RATE_DESC                                         
PRJ821               ,RATE_PLAN_DESC                                    
PRJ821               ,SECURED_RATE_FL                                   
PRJ821               ,OPTION_CD                                         
PRJ821               ,OPTION_DESC                                       
PRJ836               ,CIG_RATE_FL                                       
PRJ836               ,MIN_REVENUE_MONTH                                 
                 FROM #CSR04636_R1                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*        SELECT RETURN_CODE                                               
MFA-TR*              ,APPL_RETURN_CODE                                          
MFA-TR*              ,ACCOUNT_NO                                                
MFA-TR*              ,PREMISE_NO                                                
MFA-TR*              ,CODE_ACCT_STAT                                            
MFA-TR*              ,CODE_UTIL_TYPE                                            
MFA-TR*              ,IC_NO                                                     
MFA-TR*              ,COMPANY_NO                                                
MFA-TR*              ,RATE_PLAN_NO                                              
MFA-TR*              ,RATE_DESC                                                 
MFA-TR*              ,RATE_PLAN_DESC                                            
MFA-TR*              ,SECURED_RATE_FL                                           
MFA-TR*              ,OPTION_CD                                                 
MFA-TR*              ,OPTION_DESC                                               
MFA-TR*              ,CIG_RATE_FL                                               
MFA-TR*              ,MIN_REVENUE_MONTH                                         
MFA-TR*          FROM SESSION.CSR04636_R1                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *                                                                *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-ACCOUNT-NO        TO WS-ACCOUNT-NO                 
                                          AT-ACCOUNT-NO.                
                                                                        
PRJ821     MOVE 'DATABASE'             TO C8-DELINQ-CD.                 
PRJ821     MOVE '01'                   TO C8-COMPANY-NO.                
                                                                        
PRJ821     PERFORM 7400-GET-DATABASE           THRU 7400-EXIT.          
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *                                                                *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
      *    CURSOR DRIVEN BY ACCOUNT NO.                                         
           IF AT-ACCOUNT-NO > ZEROES                                    
              PERFORM 7100-OPEN-ACCT-CURSOR    THRU 7100-EXIT           
              PERFORM 7110-FETCH-ACCT-CURSOR   THRU 7110-EXIT           
              PERFORM 2100-PROCESS-ACCT-CURSOR THRU 2100-EXIT           
                                               UNTIL NO-MORE-ROWS       
              PERFORM 7120-CLOSE-ACCT-CURSOR   THRU 7120-EXIT           
           END-IF.                                                      
                                                                        
           IF CTR-ROWS EQUAL WS-ZERO                                    
              MOVE 100                      TO S-RETURN-CODE            
              MOVE WS-ZERO                  TO S-APPL-RETURN-CODE       
              PERFORM 8100-SEND-RESULT         THRU 8100-EXIT           
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 2100-PROCESS-ACCT-CURSOR.                                      *        
      *                                                                *        
      ******************************************************************        
       2100-PROCESS-ACCT-CURSOR.                                        
                                                                        
PRJ821     PERFORM 2200-GET-RATE-DESC         THRU 2200-EXIT.           
                                                                        
           MOVE AT-ACCOUNT-NO               TO S-ACCOUNT-NO             
PRJ836                                         BG-ACCOUNT-NO.           
           MOVE AT-PREMISE-NO               TO S-PREMISE-NO.            
           MOVE AT-CODE-ACCT-STAT           TO S-CODE-ACCT-STAT.        
           MOVE UT-CODE-UTIL-TYPE           TO S-CODE-UTIL-TYPE         
PRJ836                                         BG-CODE-UTIL-TYPE        
PRJ836                                         J1-CODE-UTIL-TYPE.       
PRJ836     MOVE UT-IC-NO                    TO BG-IC-NO                 
                                               S-IC-NO.                 
           MOVE UT-COMPANY-NO               TO S-COMPANY-NO.            
           MOVE UT-RATE-PLAN-NO             TO S-RATE-PLAN-NO           
PRJ836                                         J1-RATE-PLAN-NO.         
                                                                        
ACT254*    WHEN TEH RATE IS FOUND IN JOB PARM,PASS THE SECURED                  
ACT254*    FLAG AS 'Y' TO DISPLAY CORRECT VIEW IN UI.                           
ACT254     MOVE WS-NO                       TO WS-INDUST-RT-EXIST       
ACT254     IF UT-CODE-UTIL-TYPE EQUAL WS-ELEC AND                       
ACT254        RD-SECURED-RATE-FL EQUAL WS-NO                            
ACT254        PERFORM 7600-CHK-INDUST-RT-EXIST THRU 7600-EXIT           
ACT254     END-IF.                                                      
ACT254                                                                  
ACT254     IF INDUST-RT-EXIST                                           
ACT254        MOVE WS-YES                   TO S-SECURED-RATE-FL        
ACT254     ELSE                                                         
ACT254        MOVE RD-SECURED-RATE-FL       TO S-SECURED-RATE-FL        
ACT254     END-IF.                                                      
                                                                        
           MOVE UT-IC-NO                    TO WS-IC-NO                 
           MOVE WS-IC-NO                    TO WS-IC-NO-CHAR            
           MOVE 1                           TO UV-CODE-VALUE-LEN.       
           MOVE UT-CODE-UTIL-TYPE           TO UV-CODE-VALUE-TEXT.      
           PERFORM 7200-SELECT-UTIL-TYPE-DESC THRU 7200-EXIT.           
           MOVE UV-CODE-SHORT-DESC-TEXT(1:UV-CODE-SHORT-DESC-LEN)       
                                            TO  WS-CODE-DESC            
           MOVE 0                           TO  WS-TALLY1               
           MOVE 0                           TO  WS-TALLY2               
           INSPECT WS-IC-NO-CHAR TALLYING WS-TALLY1 FOR LEADING ZEROS   
           COMPUTE WS-TALLY2 = WS-TOT-LEN  - WS-TALLY1                  
           MOVE WS-IC-NO-CHAR(WS-TALLY1 + 1 : WS-TALLY2)                
                                            TO WS-IC-NO-RES.            
           STRING WS-CODE-DESC    DELIMITED BY SPACES                   
                  ' RATE '        DELIMITED BY SIZE                     
                  WS-IC-NO-RES    DELIMITED BY SPACES                   
                  ' : '           DELIMITED BY SIZE                     
                  UT-RATE-PLAN-NO DELIMITED BY SIZE                     
                  ' - '           DELIMITED BY SIZE                     
                  RD-RATE-DESC    DELIMITED BY SIZE                     
           INTO WS-RATE-DESC                                            
           MOVE WS-RATE-DESC                TO S-RATE-DESC.             
PRJ836                                                                  
PRJ836     PERFORM 7450-GET-MIN-REVENUE-MONTH                           
PRJ836                                      THRU 7450-EXIT.             
PRJ836     MOVE WS-MIN-REVENUE-MONTH        TO S-MIN-REVENUE-MONTH.     
PRJ836                                                                  
PRJ836     MOVE WS-NO                       TO WS-CIG-RATE-FL           
PRJ836                                         S-CIG-RATE-FL.           
PRJ836     IF UT-CODE-UTIL-TYPE = 'G'                                   
PRJ836        AND (AT-ACCOUNT-TYPE-CODE = 'I' OR 'C')                   
PRJ836        PERFORM 7500-CHECK-CIG-CUSTOMER THRU 7500-EXIT            
PRJ836     END-IF.                                                      
           PERFORM 8100-SEND-RESULT         THRU 8100-EXIT.             
           INITIALIZE GTT-RETURN-FIELDS.                                
           PERFORM 7110-FETCH-ACCT-CURSOR   THRU 7110-EXIT.             
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
PRJ821******************************************************************        
PRJ821* 2200-GET-RATE-DESC.                                            *        
PRJ821*                                                                *        
PRJ821******************************************************************        
PRJ821 2200-GET-RATE-DESC.                                              
PRJ821                                                                  
PRJ821     MOVE RD-RATE-DESC                 TO S-RATE-PLAN-DESC.       
PRJ821     MOVE SPACES                       TO S-OPTION-CD.            
PRJ821     MOVE SPACES                       TO S-OPTION-DESC.          
PRJ821                                                                  
PRJ821     IF SEB-DATABASE AND UT-RT-PKG-OPT-SEQ-NO > 0                 
PRJ821                                                                  
PRJ821        MOVE AT-ACCOUNT-NO             TO DF-ACCOUNT-NO           
PRJ821        MOVE UT-CODE-UTIL-TYPE         TO DF-CODE-UTIL-TYPE       
PRJ821        MOVE UT-IC-NO                  TO DF-IC-NO                
PRJ821        MOVE UT-RT-PKG-OPT-SEQ-NO      TO DF-RT-PKG-OPT-SEQ-NO    
PRJ821                                                                  
PRJ821        PERFORM 7300-GET-OPTION-DESC     THRU 7300-EXIT           
PRJ821                                                                  
PRJ821        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
PRJ821           MOVE FI-OPT-DESC-INT        TO S-OPTION-DESC           
PRJ821           MOVE FI-OPTION-CD           TO S-OPTION-CD             
PRJ821        END-IF                                                    
PRJ821     END-IF.                                                      
PRJ821                                                                  
PRJ821 2200-EXIT.                                                       
PRJ821     EXIT.                                                        
PRJ821                                                                  
PRJ821                                                                  
      *****************************************************************         
      * 7100-OPEN-ACCT-CURSOR.                                        *         
      *                                                               *         
      *****************************************************************         
       7100-OPEN-ACCT-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
               OPEN ACCT_CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN '                    TO ABEND-FUNCTION         
              MOVE '7100'                     TO ACTIVE-PARAGRAPH       
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_ACCOUNT'              TO TABLE-1                
              MOVE 'CSS_UTIL_ENVRNMT'         TO TABLE-2                
              MOVE 'ACCOUNT_NO  '             TO TABLE-ELEMENT-1        
              MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7110-FETCH-ACCT-CURSOR.                                       *         
      *                                                               *         
      *****************************************************************         
       7110-FETCH-ACCT-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
               FETCH ACCT_CURSOR                                        
               INTO :AT-ACCOUNT-NO                                      
                   ,:AT-PREMISE-NO                                      
                   ,:AT-CODE-ACCT-STAT                                  
                   ,:AT-ACCOUNT-TYPE-CODE                               
                   ,:UT-CODE-UTIL-TYPE                                  
                   ,:UT-IC-NO                                           
                   ,:UT-COMPANY-NO                                      
                   ,:UT-RATE-PLAN-NO                                    
PRJ821             ,:UT-RT-PKG-OPT-SEQ-NO                               
                   ,:RD-RATE-DESC                                       
                   ,:RD-SECURED-RATE-FL                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE WS-YES               TO WS-NO-MORE-ROWS        
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
                    MOVE '7110'               TO ACTIVE-PARAGRAPH       
                    MOVE 'FETCH '             TO ABEND-FUNCTION         
                    MOVE SPACES               TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
                    MOVE 'CSS_ACCOUNT'        TO TABLE-1                
                    MOVE 'CSS_UTIL_ENVRNMT'   TO TABLE-2                
                    MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1        
                    MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1      
                    PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT      
                    PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT      
           END-EVALUATE.                                                
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7120-CLOSE-ACCT-CURSOR                                        *         
      *                                                               *         
      *****************************************************************         
       7120-CLOSE-ACCT-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
               CLOSE ACCT_CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7120'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE '                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_ACCOUNT'              TO TABLE-1                
              MOVE 'CSS_UTIL_ENVRNMT'         TO TABLE-2                
              MOVE 'ACCOUNT_NO  '             TO TABLE-ELEMENT-1        
              MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7200-SELECT-UTIL-TYPE-DESC                                    *         
      *                                                               *         
      *****************************************************************         
       7200-SELECT-UTIL-TYPE-DESC.                                      
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) CODE_SHORT_DESC                                    
                INTO :UV-CODE-SHORT-DESC                                
                FROM CSS_CODE_VALUE WITH(READUNCOMMITTED)                       
               WHERE COLUMN_NA  = 'CODE_UTIL_TYPE'                      
                 AND CODE_VALUE = :UV-CODE-VALUE                        
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CODE_SHORT_DESC                                            
MFA-TR*         INTO :UV-CODE-SHORT-DESC                                        
MFA-TR*         FROM CSS_CODE_VALUE                                             
MFA-TR*        WHERE COLUMN_NA  = 'CODE_UTIL_TYPE'                              
MFA-TR*          AND CODE_VALUE = :UV-CODE-VALUE                                
MFA-TR*       FETCH FIRST ROW ONLY                                              
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7200                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7200'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_CODE_VALUE'           TO TABLE-1                
              MOVE 'CODE_VALUE'               TO TABLE-ELEMENT-1        
              MOVE UT-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
PRJ821 7300-GET-OPTION-DESC.                                            
PRJ821                                                                  
PRJ821     EXEC SQL                                                     
PRJ821        SELECT FI.OPT_DESC_INT                                    
PRJ821              ,FI.OPTION_CD                                       
PRJ821          INTO :FI-OPT-DESC-INT                                   
PRJ821              ,:FI-OPTION-CD                                      
PRJ821          FROM CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)                 
PRJ821              ,CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)                 
PRJ821         WHERE DF.ACCOUNT_NO         = :DF-ACCOUNT-NO             
PRJ821           AND DF.CODE_UTIL_TYPE     = :DF-CODE-UTIL-TYPE         
PRJ821           AND DF.IC_NO              = :DF-IC-NO                  
PRJ821           AND DF.RT_PKG_OPT_SEQ_NO  = :DF-RT-PKG-OPT-SEQ-NO      
PRJ821           AND DF.OPTION_CD          = FI.OPTION_CD               
PRJ821           AND FI.OPT_VSTART_TS     <= CIS.CURRENT$TIMESTAMP()          
PRJ821           AND FI.OPT_VEND_TS       >= CIS.CURRENT$TIMESTAMP()          
PRJ821           AND FI.PROC_STATUS_CD     = 'AC'                       
PRJ821                                                           
PRJ821     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT FI.OPT_DESC_INT                                            
MFA-TR*             ,FI.OPTION_CD                                               
MFA-TR*         INTO :FI-OPT-DESC-INT                                           
MFA-TR*             ,:FI-OPTION-CD                                              
MFA-TR*         FROM CSS_ACCT_RTPK_AGR DF                                       
MFA-TR*             ,CRM_RT_PKG_OPTION FI                                       
MFA-TR*        WHERE DF.ACCOUNT_NO         = :DF-ACCOUNT-NO                     
MFA-TR*          AND DF.CODE_UTIL_TYPE     = :DF-CODE-UTIL-TYPE                 
MFA-TR*          AND DF.IC_NO              = :DF-IC-NO                          
MFA-TR*          AND DF.RT_PKG_OPT_SEQ_NO  = :DF-RT-PKG-OPT-SEQ-NO              
MFA-TR*          AND DF.OPTION_CD          = FI.OPTION_CD                       
MFA-TR*          AND FI.OPT_VSTART_TS     <= CURRENT TIMESTAMP                  
MFA-TR*          AND FI.OPT_VEND_TS       >= CURRENT TIMESTAMP                  
MFA-TR*          AND FI.PROC_STATUS_CD     = 'AC'                               
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PRJ821                                                                  
PRJ821     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
PRJ821                                                                  
PRJ821     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
PRJ821        NEXT SENTENCE                                             
PRJ821     ELSE                                                         
PRJ821        MOVE '7300'                     TO ACTIVE-PARAGRAPH       
PRJ821        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
PRJ821        MOVE 'SELECT'                   TO ABEND-FUNCTION         
PRJ821        MOVE 'CSS_ACCT_RTPK_AGR'        TO TABLE-1                
PRJ821        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
PRJ821        MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
PRJ821        MOVE 'IC_NO'                    TO TABLE-ELEMENT-3        
PRJ821        MOVE 'RT_PKG_OPT_SEQ_NO'        TO TABLE-ELEMENT-4        
PRJ821        MOVE DF-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
PRJ821        MOVE DF-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2      
PRJ821        MOVE DF-IC-NO                   TO HOSTVAR-ELEMENT-3      
PRJ821        MOVE DF-RT-PKG-OPT-SEQ-NO       TO HOSTVAR-ELEMENT-4      
PRJ821        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
PRJ821        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
PRJ821     END-IF.                                                      
PRJ821                                                                  
PRJ821 7300-EXIT.                                                       
PRJ821     EXIT.                                                        
PRJ821*****************************************************************         
PRJ821* 7400-GET-DATABASE                                             *         
PRJ821*     SELECTS BILLING ENTITY (SEB OR SCEG) FROM CSS_DELINQUENCY *         
PRJ821*****************************************************************         
PRJ821 7400-GET-DATABASE.                                               
PRJ821                                                                  
PRJ821     EXEC SQL                                                     
PRJ821        SELECT DELINQ_VALUE                                       
PRJ821          INTO :C8-DELINQ-VALUE                                   
PRJ821          FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
PRJ821         WHERE DELINQ_CD  = :C8-DELINQ-CD                         
PRJ821           AND COMPANY_NO = :C8-COMPANY-NO                        
PRJ821                                                           
PRJ821     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD  = :C8-DELINQ-CD                                 
MFA-TR*          AND COMPANY_NO = :C8-COMPANY-NO                                
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PRJ821                                                                  
PRJ821     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
PRJ821                                                                  
PRJ821     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
PRJ821        MOVE C8-DELINQ-VALUE            TO WS-DATABASE            
PRJ821     ELSE                                                         
PRJ821        MOVE '7400'                     TO ACTIVE-PARAGRAPH       
PRJ821        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
PRJ821        MOVE 'SELECT'                   TO ABEND-FUNCTION         
PRJ821        MOVE 'CSS_DELINQUENCY'          TO TABLE-1                
PRJ821        MOVE 'DELINQ_CD'                TO TABLE-ELEMENT-1        
PRJ821        MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-2        
PRJ821        MOVE C8-DELINQ-CD               TO HOSTVAR-ELEMENT-1      
PRJ821        MOVE C8-COMPANY-NO              TO HOSTVAR-ELEMENT-2      
PRJ821        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
PRJ821        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
PRJ821     END-IF.                                                      
PRJ821                                                                  
PRJ821 7400-EXIT.                                                       
PRJ821     EXIT.                                                        
PRJ821*                                                                         
PRJ836*****************************************************************         
PRJ836* 7450-GET-MIN-REVENUE-MONTH.                                   *         
PRJ836*****************************************************************         
PRJ836 7450-GET-MIN-REVENUE-MONTH.                                      
PRJ836                                                                  
PRJ836     MOVE ZERO                          TO WS-REV-MTH-NULL-IND    
PRJ836                                                                  
PRJ836     EXEC SQL                                                     
PRJ836        SELECT TOP(1) MIN(REVENUE_MONTH)                                 
PRJ836          INTO :WS-MIN-REVENUE-MONTH :WS-REV-MTH-NULL-IND          
PRJ836          FROM CSS_BILLING_DET BG WITH(READUNCOMMITTED)                   
PRJ836         WHERE BG.ACCOUNT_NO     = :BG-ACCOUNT-NO                 
PRJ836           AND BG.CODE_UTIL_TYPE = :BG-CODE-UTIL-TYPE             
PRJ836           AND BG.IC_NO          = :BG-IC-NO                      
PRJ836           AND BG.REVENUE_MONTH  > 0                              
PRJ836                                              
PRJ836                                                           
PRJ836     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MIN(REVENUE_MONTH)                                         
MFA-TR*         INTO :WS-MIN-REVENUE-MONTH:WS-REV-MTH-NULL-IND                  
MFA-TR*         FROM CSS_BILLING_DET BG                                         
MFA-TR*        WHERE BG.ACCOUNT_NO     = :BG-ACCOUNT-NO                         
MFA-TR*          AND BG.CODE_UTIL_TYPE = :BG-CODE-UTIL-TYPE                     
MFA-TR*          AND BG.IC_NO          = :BG-IC-NO                              
MFA-TR*          AND BG.REVENUE_MONTH  > 0                                      
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PRJ836                                                                  
PRJ836     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
PRJ836                                                                  
PRJ836     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
PRJ836        IF WS-REV-MTH-NULL-IND < 0                                
PRJ836           OR WS-ACTIVE-RETURN-CODE = NOT-FOUND                   
PRJ836           MOVE ZERO                    TO WS-MIN-REVENUE-MONTH   
PRJ836        END-IF                                                    
PRJ836     ELSE                                                         
PRJ836        MOVE '7450'                     TO ACTIVE-PARAGRAPH       
PRJ836        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
PRJ836        MOVE 'SELECT'                   TO ABEND-FUNCTION         
PRJ836        MOVE 'CSS_BILLING_DET'          TO TABLE-1                
PRJ836        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
PRJ836        MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
PRJ836        MOVE 'IC_NO'                    TO TABLE-ELEMENT-3        
PRJ836        MOVE BG-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
PRJ836        MOVE BG-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2      
PRJ836        MOVE BG-IC-NO                   TO HOSTVAR-ELEMENT-3      
PRJ836        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
PRJ836        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
PRJ836     END-IF.                                                      
PRJ836                                                                  
PRJ836 7450-EXIT.                                                       
PRJ836     EXIT.                                                        
PRJ836*                                                                         
PRJ836*****************************************************************         
PRJ836* 7500-CHECK-CIG-CUSTOMER.                                      *         
PRJ836*****************************************************************         
PRJ836 7500-CHECK-CIG-CUSTOMER.                                         
PRJ836                                                                  
PRJ836     EXEC SQL                                                     
PRJ836        SELECT TOP(1) 'Y'                                                
PRJ836          INTO :WS-CIG-RATE-FL                                    
PRJ836          FROM CSS_RATE_COMP_DEF J1 WITH(READUNCOMMITTED)                 
PRJ836         WHERE J1.CODE_UTIL_TYPE = :J1-CODE-UTIL-TYPE             
PRJ836           AND J1.RATE_PLAN_NO   = :J1-RATE-PLAN-NO               
PRJ836           AND J1.REG_TYPE_CD    = 'D'                            
PRJ836         ORDER BY J1.VERSION_NO_CNTRL DESC                        
PRJ836                                              
PRJ836                                                           
PRJ836     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-CIG-RATE-FL                                            
MFA-TR*         FROM CSS_RATE_COMP_DEF J1                                       
MFA-TR*        WHERE J1.CODE_UTIL_TYPE = :J1-CODE-UTIL-TYPE                     
MFA-TR*          AND J1.RATE_PLAN_NO   = :J1-RATE-PLAN-NO                       
MFA-TR*          AND J1.REG_TYPE_CD    = 'D'                                    
MFA-TR*        ORDER BY J1.VERSION_NO_CNTRL DESC                                
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PRJ836                                                                  
PRJ836     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
PRJ836                                                                  
PRJ836     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
PRJ836        MOVE WS-CIG-RATE-FL             TO S-CIG-RATE-FL          
PRJ836     ELSE                                                         
PRJ836        MOVE '7500'                     TO ACTIVE-PARAGRAPH       
PRJ836        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
PRJ836        MOVE 'SELECT'                   TO ABEND-FUNCTION         
PRJ836        MOVE 'CSS_RATE_COMP_DEF'        TO TABLE-1                
PRJ836        MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
PRJ836        MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
PRJ836        MOVE J1-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
PRJ836        MOVE J1-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-2      
PRJ836        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
PRJ836        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
PRJ836     END-IF.                                                      
PRJ836                                                                  
PRJ836 7500-EXIT.                                                       
PRJ836     EXIT.                                                        
PRJ836*                                                                         
                                                                        
ACT254*****************************************************************         
ACT254*                                                               *         
ACT254* 7600-CHK-INDUST-RT-EXIST.                                     *         
ACT254*****************************************************************         
ACT254 7600-CHK-INDUST-RT-EXIST.                                        
ACT254                                                                  
ACT254     EXEC SQL                                                     
ACT254        SELECT TOP(1) 'Y'                                                
ACT254          INTO :WS-INDUST-RT-EXIST                                
ACT254          FROM CSS_JOB_PARM G6 WITH(READUNCOMMITTED)                      
ACT254         WHERE PROGRAM_NAME              = :PROGRAM-NAME          
ACT254           AND G6.CMND_CODE              = :WS-PARM               
ACT254           AND G6.STATUS                 = :WS-ACTIVE             
ACT254           AND CIS.SUBSTR3(G6.PARM_DATA,14,3) = :UT-RATE-PLAN-NO       
ACT254                                              
ACT254                                                           
ACT254     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-INDUST-RT-EXIST                                        
MFA-TR*         FROM CSS_JOB_PARM G6                                            
MFA-TR*        WHERE PROGRAM_NAME              = :PROGRAM-NAME                  
MFA-TR*          AND G6.CMND_CODE              = :WS-PARM                       
MFA-TR*          AND G6.STATUS                 = :WS-ACTIVE                     
MFA-TR*          AND SUBSTR(G6.PARM_DATA,14,3) = :UT-RATE-PLAN-NO               
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT254                                                                  
ACT254     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
ACT254                                                                  
ACT254     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
ACT254        CONTINUE                                                  
ACT254     ELSE                                                         
ACT254        MOVE '7600'                     TO ACTIVE-PARAGRAPH       
ACT254        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
ACT254        MOVE 'SELECT'                   TO ABEND-FUNCTION         
ACT254        MOVE 'CSS_JOB_PARM'             TO TABLE-1                
ACT254        MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-1        
ACT254        MOVE UT-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-1      
ACT254        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
ACT254        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
ACT254     END-IF.                                                      
ACT254                                                                  
ACT254 7600-EXIT.                                                       
ACT254     EXIT.                                                        
ACT254*                                                                         
      ******************************************************************        
      * 8000A-DELETE-GTT-ROWS.                                         *        
      *                                                                *        
      ******************************************************************        
       8000A-DELETE-GTT-ROWS.                                           
                                                                        
            EXEC SQL                                                    
                DELETE FROM #CSR04636_R1                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR04636_R1                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
                CONTINUE                                                
            ELSE                                                        
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8000A'              TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04636_R1'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8100-SEND-RESULT.                                             *         
      *                                                               *         
      *****************************************************************         
       8100-SEND-RESULT.                                                
           EXEC SQL                                                     
             INSERT INTO #CSR04636_R1                            
             (                                                          
              RETURN_CODE                                               
             ,APPL_RETURN_CODE                                          
             ,ACCOUNT_NO                                                
             ,PREMISE_NO                                                
             ,CODE_ACCT_STAT                                            
             ,CODE_UTIL_TYPE                                            
             ,IC_NO                                                     
             ,COMPANY_NO                                                
             ,RATE_PLAN_NO                                              
             ,RATE_DESC                                                 
PRJ821       ,RATE_PLAN_DESC                                            
PRJ821       ,SECURED_RATE_FL                                           
PRJ821       ,OPTION_CD                                                 
PRJ821       ,OPTION_DESC                                               
PRJ836       ,CIG_RATE_FL                                               
PRJ836       ,MIN_REVENUE_MONTH                                         
             )                                                          
             VALUES                                                     
             (                                                          
              :S-RETURN-CODE                                            
             ,:S-APPL-RETURN-CODE                                       
             ,:S-ACCOUNT-NO                                             
             ,:S-PREMISE-NO                                             
             ,:S-CODE-ACCT-STAT                                         
             ,:S-CODE-UTIL-TYPE                                         
             ,:S-IC-NO                                                  
             ,:S-COMPANY-NO                                             
             ,:S-RATE-PLAN-NO                                           
             ,:S-RATE-DESC                                              
PRJ821       ,:S-RATE-PLAN-DESC                                         
             ,:S-SECURED-RATE-FL                                        
PRJ821       ,:S-OPTION-CD                                              
PRJ821       ,:S-OPTION-DESC                                            
PRJ836       ,:S-CIG-RATE-FL                                            
PRJ836       ,:S-MIN-REVENUE-MONTH                                      
             )                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04636_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,APPL_RETURN_CODE                                                  
MFA-TR*      ,ACCOUNT_NO                                                        
MFA-TR*      ,PREMISE_NO                                                        
MFA-TR*      ,CODE_ACCT_STAT                                                    
MFA-TR*      ,CODE_UTIL_TYPE                                                    
MFA-TR*      ,IC_NO                                                             
MFA-TR*      ,COMPANY_NO                                                        
MFA-TR*      ,RATE_PLAN_NO                                                      
MFA-TR*      ,RATE_DESC                                                         
MFA-TR*      ,RATE_PLAN_DESC                                                    
MFA-TR*      ,SECURED_RATE_FL                                                   
MFA-TR*      ,OPTION_CD                                                         
MFA-TR*      ,OPTION_DESC                                                       
MFA-TR*      ,CIG_RATE_FL                                                       
MFA-TR*      ,MIN_REVENUE_MONTH                                                 
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S-RETURN-CODE                                                    
MFA-TR*      ,:S-APPL-RETURN-CODE                                               
MFA-TR*      ,:S-ACCOUNT-NO                                                     
MFA-TR*      ,:S-PREMISE-NO                                                     
MFA-TR*      ,:S-CODE-ACCT-STAT                                                 
MFA-TR*      ,:S-CODE-UTIL-TYPE                                                 
MFA-TR*      ,:S-IC-NO                                                          
MFA-TR*      ,:S-COMPANY-NO                                                     
MFA-TR*      ,:S-RATE-PLAN-NO                                                   
MFA-TR*      ,:S-RATE-DESC                                                      
MFA-TR*      ,:S-RATE-PLAN-DESC                                                 
MFA-TR*      ,:S-SECURED-RATE-FL                                                
MFA-TR*      ,:S-OPTION-CD                                                      
MFA-TR*      ,:S-OPTION-DESC                                                    
MFA-TR*      ,:S-CIG-RATE-FL                                                    
MFA-TR*      ,:S-MIN-REVENUE-MONTH                                              
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              ADD 1                         TO CTR-ROWS                 
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE '8100'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE 'CSR04636_R1'            TO TABLE-1                  
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * END PROGRAM COPYLIB                                            *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CPD00320                                                 
           END-EXEC.                                                            
                                                                        
