       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04634.                                          
       AUTHOR.       VENKAT VUDDANDAPU.                                 
       DATE-WRITTEN. MAY 22, 2013.                                      
       DATE-COMPILED.                                                   
      *                                                                         
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      ******************************************************************        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM RETRIEVES ACTIVE CREDIT ARRANGMENT DETAILS BASED *        
      *  ON ACCOUNT#.                                                  *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
P00726*  05/22/13  VV94890    PROCEDURE ORIGINALLY CODED.              *        
P0726A*  02/04/14  AA97148    CREDIT ARRANGEMENTS - RELEASE 2 CHANGES  *        
P0726A*                       ADDED ARNG TERM CODE TO THE RESULT SET   *        
P0726A*                       AND REMAINING AMT CALC FOR CHANGE DUE AFT*        
P0726A*                       ER PLAN.                                 *        
P0726B*  02/04/14  AA97148    CREDIT ARRANGEMENTS - RELEASE 3 CHANGES  *        
P0726B*                       ADDED REMAINING AMOUNT CALCULATION FOR   *        
P0726B*                       STA/STAA.                                *        
P0726C*  10/17/14  VV94890    ADDED NEW COLUMN ARNG_TYPE TO RESULT SET.*        
P00948*  07/28/16  VP43661    LEST AMOUNT TO PAY CHANGES.              *        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION, ABEND, MESSAGING MODULES            *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04634'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04634 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************06330000
      * CSS_CRED_ARNGMENT  - X1                                        *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCRARNG                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************06330000
      * CSS_CRED_ARNG_SCHD - WX                                        *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCRARSC                                                  
           END-EXEC.                                                            
      *                                                                         
P0726A******************************************************************        
P0726A* CSS_BILLING_HDR    - BI                                        *        
P0726A******************************************************************        
P0726A                                                                  
P0726A     EXEC SQL                                                             
P0726A        INCLUDE TBBLLHDR                                                  
P0726A     END-EXEC.                                                            
P0726A                                                                  
P0726A******************************************************************        
P0726A* CSS_CRED_ARNG_HIST - WY                                        *        
P0726A******************************************************************        
P0726A                                                                  
P0726A     EXEC SQL                                                             
P0726A        INCLUDE TBCRARHS                                                  
P0726A     END-EXEC.                                                            
P0726A                                                                  
P0726A******************************************************************06330000
P0726A* CSS_DELINQUENCY    - C8                                        *06340000
P0726A******************************************************************06350000
P0726A                                                                  
P0726A     EXEC SQL                                                     06370000
P0726A        INCLUDE TBDELQ                                            06380000
P0726A     END-EXEC.                                                    06390000
P0726A                                                                  
      ******************************************************************06330000
      * CSS_ACCOUNT  - AT                                              *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                     00660000
              INCLUDE TBACCT                                            00670000
           END-EXEC.                                                    00680000
      *                                                                         
P0726A******************************************************************        
P0726A*    CSS_ARNG_OPTION - UD                                        *        
P0726A******************************************************************        
P0726A                                                                  
P0726A     EXEC SQL                                                             
P0726A        INCLUDE TBARGOPT                                                  
P0726A     END-EXEC.                                                            
P0726A                                                                  
P0726A******************************************************************        
P0726A*    CSS_ARNG_PLAN   - UF                                        *        
P0726A******************************************************************        
P0726A                                                                  
P0726A     EXEC SQL                                                             
P0726A        INCLUDE TBARGPLN                                                  
P0726A     END-EXEC.                                                            
P0726A                                                                  
P0726A******************************************************************        
P0726A*    CSS_REG_PROFILE - LR                                        *        
P0726A******************************************************************        
P0726A                                                                  
P0726A     EXEC SQL                                                             
P0726A        INCLUDE TBREGPRF                                                  
P0726A     END-EXEC.                                                            
P0726A                                                                  
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      * COMMON SYSTEM AREA                                                      
           COPY CCA00001.                                                       
      * ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS                          
           COPY CWS00027.                                                       
      * SUPPORTS DB2 AND SQL ERROR CHECKING                                     
           COPY CWS00303.                                                       
                                                                        
P0726A******************************************************************        
P0726A* WORKING STORAGE COPYBOOKS CODES DATA PRESENT                   *        
P0726A******************************************************************        
P0726A                                                                  
P0726A     COPY CWS00056.                                               01680000
P0726A                                                                  
P0726A******************************************************************        
P0726A* WORKING STORAGE COPYBOOKS FOR CPD00068                         *        
P0726A******************************************************************        
P0726A                                                                  
P0726A     EXEC SQL                                                             
P0726A        INCLUDE CWS00068                                                  
P0726A     END-EXEC.                                                            
P0726A                                                                  
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
      *                                                                         
       01  FILLER                     PIC X(11) VALUE 'PARM FIELDS'.    
      *                                                                         
       01  PARM-FIELDS.                                                 
           05  PARM-L                 PIC S9(9) COMP.                   
           05  PARM-ACCOUNT-NO        PIC X(13).                        
      *                                                                         
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC               PIC S9(9) COMP.                   
      *                                                                         
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS               PIC S9(9) COMP VALUE 0.           
           05  WS-ROW-COUNT           PIC S9(9) COMP VALUE 0.           
           05  WS-RCVPRM              PIC X(20) VALUE SPACES.           
      *                                                                         
       01  WS-MISC-FIELDS.                                              
           05  PROGRAM-NAME           PIC X(08) VALUE 'CSR04634'.       
           05  WS-NULL-IND            PIC S9(4) COMP.                   
           05  WS-DATE-HOLD           PIC X(10) VALUE SPACES.           
           05  WS-DATE-HOLD-USA       PIC X(10) VALUE SPACES.           
P0726A     05  WS-REG-GROUP-CD        PIC X(03) VALUE SPACES.           
P0726A     05  WS-ARNG-TERM-CD        PIC X(02) VALUE SPACES.           
P0726A     05  WS-CURRENT-DATE        PIC X(10) VALUE SPACES.           
P0726A     05  MCSCB068               PIC X(08) VALUE 'MCSCB068'.       
P0726A     05  WS-DATE-BILL-00-IND    PIC S9(04) COMP VALUE +0.         
P0726A     05  WS-DATE-BILL-30-IND    PIC S9(04) COMP VALUE +0.         
P0726A     05  WS-DATE-BILL-60-IND    PIC S9(04) COMP VALUE +0.         
P0726A     05  WS-DATE-BILL-90-IND    PIC S9(04) COMP VALUE +0.         
P0726A     05  WS-TOTAL-ARREARS       PIC S9(9)V99 COMP-3 VALUE 0.      
P00948     05  WS-LEAST-AMT-DUE-CD    PIC X(13) VALUE 'LEAST-AMT-DUE'.  
P00948     05  WS-LEAST-AMT-DUE       PIC S9(4)V99 COMP-3 VALUE 0.      
      *                                                                         
       01  WS-REDEFINITIONS.                                            
           05  WS-ACCOUNT              PIC X(13).                       
           05  WS-ACCOUNT-RED REDEFINES WS-ACCOUNT                      
                                       PIC 9(13).                       
COB305     05 WS-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.        
      *                                                                         
       01  WORK-FIELDS.                                                 
           05  WRK-DONE-STATUS        PIC S9(9) COMP.                   
      *                                                                         
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
      *                                                                         
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE         PIC S9(9) COMP VALUE 0.           
           05  RS-ARNG-SCHD-DUE-DT    PIC X(10) VALUE SPACES.           
           05  RS-ARNG-TOTAL-AMT      PIC S9(11)V9(2) COMP-3 VALUE 0.   
           05  RS-REMAIN-AMT          PIC S9(11)V9(2) COMP-3 VALUE 0.   
P0726A     05  RS-ARNG-TERM-CD        PIC X(02) VALUE SPACES.           
P0726C     05  RS-ARNG-TYPE           PIC X(10) VALUE SPACES.           
      *                                                                         
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE          PIC S9(9) COMP VALUE 0.           
           05  S-ARNG-SCHD-DUE-DT     PIC X(10) VALUE SPACES.           
           05  S-ARNG-TOTAL-AMT       PIC S9(11)V9(2) COMP-3 VALUE 0.   
           05  S-REMAIN-AMT           PIC S9(11)V9(2) COMP-3 VALUE 0.   
P0726A     05  S-ARNG-TERM-CD         PIC X(02) VALUE SPACES.           
P0726C     05  S-ARNG-TYPE            PIC X(10) VALUE SPACES.           
      *                                                                         
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
P0726A     05  WS-DATABASE             PIC 9(01) VALUE ZERO.            
P0726A         88 CSR-DATABASE                   VALUE 1.               
P0726A         88 SEB-DATABASE                   VALUE 2.               
                                                                        
      ******************************************************************        
      *    CURSOR DECLARATIONS                                         *        
      ******************************************************************        
                                                                        
      *--- < NO CURSORS IN THIS PROCEDURE >                                     
                                                                        
HPCCDM*EJECT                                                                    
           EXEC SQL                                                     00000010
              INCLUDE CWSX0010                                          00000020
           END-EXEC.                                                    00000030
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
           10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
                                                                        
                                                                        
      *                                                                 00001800
       LINKAGE SECTION.                                                 
       01  LINK-ACCOUNT-NO          PIC X(13)                .          
      *                                                                         
       PROCEDURE DIVISION USING   LINK-ACCOUNT-NO.                      
      *                                                                         
           EXEC SQL                                                     
               WHENEVER SQLWARNING                                      
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLERROR                                        
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER NOT FOUND                                       
                   CONTINUE                                             
           END-EXEC.                                                    
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM.                     *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 1000-INITIALIZE     THRU 1000-EXIT                   
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT                   
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-INITIALIZE                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      *     CALLED BY: 0000-MAINLINE                                   *        
      ******************************************************************        
       1000-INITIALIZE.                                                 
                                                                        
           MOVE '1000'          TO ACTIVE-PARAGRAPH.                    
      *                                                                         
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT                                                   
                :S-RETURN-CODE               AS   RETURN_CODE           
               ,:S-ARNG-SCHD-DUE-DT          AS   ARNG_SCHD_DUE_DT      
               ,:S-ARNG-TOTAL-AMT            AS   ARNG_TOTAL_AMT        
               ,:S-REMAIN-AMT                AS   REMAIN_AMT            
P0726A         ,:S-ARNG-TERM-CD              AS   ARNG_TERM_CD          
P0726C         ,:S-ARNG-TYPE                 AS   ARNG_TYPE             
                  FROM CIS.SYSDUMMY1                                 
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT                                                           
MFA-TR*         :S-RETURN-CODE               AS   RETURN_CODE                   
MFA-TR*        ,:S-ARNG-SCHD-DUE-DT          AS   ARNG_SCHD_DUE_DT              
MFA-TR*        ,:S-ARNG-TOTAL-AMT            AS   ARNG_TOTAL_AMT                
MFA-TR*        ,:S-REMAIN-AMT                AS   REMAIN_AMT                    
MFA-TR*        ,:S-ARNG-TERM-CD              AS   ARNG_TERM_CD                  
MFA-TR*        ,:S-ARNG-TYPE                 AS   ARNG_TYPE                     
MFA-TR*           FROM SYSIBM.SYSDUMMY1                                         
MFA-TR*     END-EXEC.                                                           
      *                                                                         
            MOVE LINK-ACCOUNT-NO           TO PARM-ACCOUNT-NO          .
P0726A* TO IDENTIFY THE DATA BASE                                               
P0726A     MOVE '01'                       TO C8-COMPANY-NO.            
P0726A     MOVE 'DATABASE'                 TO C8-DELINQ-CD.             
P0726A     PERFORM 7150-GET-DLINQ-VAL      THRU 7150-EXIT               
P0726A     MOVE C8-DELINQ-VALUE            TO WS-DATABASE.              
            PERFORM 1100-PROCESS-INPUT     THRU 1100-EXIT.              
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1100-PROCESS-INPUT.                                            *        
      *      SET UP PARAMETERS TO BE RETURNED.                         *        
      *      CALLED BY: 0000-MAINLINE                                  *        
      ******************************************************************        
       1100-PROCESS-INPUT.                                              
      *                                                                         
           MOVE PARM-ACCOUNT-NO       TO WS-ACCOUNT                     
           MOVE WS-ACCOUNT-RED        TO WS-ACCOUNT-NO                  
           MOVE WS-ACCOUNT-NO         TO AT-ACCOUNT-NO                  
P0726A                                   BI-ACCOUNT-NO                  
                                         X1-ACCOUNT-NO.                 
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *      SET UP PARAMETERS TO BE RETURNED.                         *        
      *      CALLED BY: 0000-MAINLINE                                  *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           MOVE '2000'                         TO ACTIVE-PARAGRAPH      
           PERFORM 2200-BUILD-RESULT           THRU 2200-EXIT           
           PERFORM 2000A-MOVE-RESULT           THRU 2000A-EXIT          
           PERFORM 8100-SEND-RESULT            THRU 8100-EXIT.          
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000A-MOVE-RESULT.                                             *        
      ******************************************************************        
       2000A-MOVE-RESULT.                                               
      *                                                                         
           MOVE RS-RETURN-CODE             TO S-RETURN-CODE             
           MOVE RS-ARNG-SCHD-DUE-DT        TO S-ARNG-SCHD-DUE-DT        
           MOVE RS-ARNG-TOTAL-AMT          TO S-ARNG-TOTAL-AMT          
           MOVE RS-REMAIN-AMT              TO S-REMAIN-AMT              
P0726A     MOVE RS-ARNG-TERM-CD            TO S-ARNG-TERM-CD            
P0726C     MOVE RS-ARNG-TYPE               TO S-ARNG-TYPE.              
      *                                                                         
       2000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2200-BUILD-RESULT                                              *        
      *     BUILD RESULT SET.                                          *        
      *     CALLED BY:  2000-PROCESS-OUTPUT                            *        
      ******************************************************************        
       2200-BUILD-RESULT.                                               
      *                                                                         
P0726A     MOVE SPACES                   TO WS-ARNG-TERM-CD             
P0726A                                      WS-REG-GROUP-CD.            
                                                                        
           PERFORM 7000-GET-ACTIVE-ARNG-INFO THRU 7000-EXIT             
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P0726A        PERFORM 7100-SELECT-ACCOUNT         THRU 7100-EXIT        
P0726A        PERFORM 7130-GET-CURRENT-DATE       THRU 7130-EXIT        
P0726A        IF SEB-DATABASE                                           
P0726A           PERFORM 7110-SELECT-REG-GROUP-CD THRU 7110-EXIT        
P0726A        END-IF                                                    
P0726A        MOVE AT-CODES-DATA-PRESENT TO WS-CODES-DATA-PRESENT       
P0726A        PERFORM 7120-GET-ARNG-TERM-CODE     THRU 7120-EXIT        
P0726A* Get Arrangement Option cd                                               
P0726A        IF UD-OPTION-TERM-CD > SPACES                             
P0726A           MOVE UD-OPTION-TERM-CD  TO WS-ARNG-TERM-CD             
P0726A        ELSE                                                      
P0726A           MOVE UF-PLAN-TERM-CD    TO WS-ARNG-TERM-CD             
P0726A        END-IF                                                    
P0726A                                                                  
P0726A        MOVE WS-ARNG-TERM-CD       TO RS-ARNG-TERM-CD             
              MOVE WX-ARNG-SCHD-DUE-DT   TO WS-DATE-HOLD                
P0726A        PERFORM 2220-CALL-MCSCB068          THRU 2220-EXIT        
              PERFORM 7200-GET-USA-DATE           THRU 7200-EXIT        
              MOVE WS-DATE-HOLD-USA      TO RS-ARNG-SCHD-DUE-DT         
              MOVE X1-ARNG-TOTAL-AMT     TO RS-ARNG-TOTAL-AMT           
P0726C        MOVE X1-ARNG-TYPE          TO RS-ARNG-TYPE                
P0726A                                                                  
P0726A        EVALUATE X1-ARNG-TYPE                                     
P0726A         WHEN 'CDD'                                               
P0726A              MOVE AT-TOTAL-AR-BALANCE          TO RS-REMAIN-AMT  
P0726A         WHEN 'CDDA'                                              
P0726A              IF AT-DATE-BILL-DAY-00 < X1-ARNG-SETUP-DT           
P0726A                 MOVE AT-TOTAL-AR-BALANCE       TO RS-REMAIN-AMT  
P0726A              ELSE                                                
P0726A                 MOVE ZEROES       TO WS-TOTAL-ARREARS            
P0726A                 COMPUTE WS-TOTAL-ARREARS  = WS-AMT-ARREARS-UTL + 
P0726A                                          WS-AMT-ARREARS-NONUTL   
P0726A                 IF AT-DATE-BILL-DAY-00 = X1-ARNG-SETUP-DT        
P0726A                    PERFORM 7140-SELECT-BILL-DETAILS              
P0726A                                                THRU 7140-EXIT    
P0726A                    IF BI-LAST-UPDATE-TS < WY-ARNG-HIST-TS        
P0726A                       MOVE AT-TOTAL-AR-BALANCE TO RS-REMAIN-AMT  
P0726A                    ELSE                                          
P0726A                       MOVE WS-TOTAL-ARREARS    TO RS-REMAIN-AMT  
P0726A                    END-IF                                        
P0726A                 ELSE                                             
P0726A                    MOVE WS-TOTAL-ARREARS       TO RS-REMAIN-AMT  
P0726A              END-IF                                              
P0726A           END-IF                                                 
P0726B         WHEN 'STA'                                               
P00948         WHEN 'STF'                                               
P0726B              IF AT-CREDIT-GROUP = 'B'                            
P0726B                 MOVE AT-TOTAL-AR-BALANCE       TO RS-REMAIN-AMT  
P0726B              ELSE                                                
P0726B                 MOVE WS-AMT-ARREARS-UTL        TO RS-REMAIN-AMT  
P0726B              END-IF                                              
P0726B         WHEN 'STAA'                                              
P00948         WHEN 'STFA'                                              
P0726B              IF AT-DATE-BILL-DAY-00 < X1-ARNG-SETUP-DT           
P0726B                 MOVE WS-TOTAL-BALANCE-UTL      TO RS-REMAIN-AMT  
P0726B              ELSE                                                
P0726B                 IF AT-DATE-BILL-DAY-00 = X1-ARNG-SETUP-DT        
P0726B                    PERFORM 7140-SELECT-BILL-DETAILS              
P0726B                                                THRU 7140-EXIT    
P0726B                    IF BI-LAST-UPDATE-TS < WY-ARNG-HIST-TS        
P0726B                       MOVE WS-TOTAL-BALANCE-UTL                  
P0726B                                       TO RS-REMAIN-AMT           
P0726B                    ELSE                                          
P0726B                       MOVE WS-AMT-ARREARS-UTL                    
P0726B                                       TO RS-REMAIN-AMT           
P0726B                    END-IF                                        
P0726B                 ELSE                                             
P0726B                    MOVE WS-AMT-ARREARS-UTL                       
P0726B                                       TO RS-REMAIN-AMT           
P0726B                 END-IF                                           
P0726B              END-IF                                              
P0726A        END-EVALUATE                                              
P00948        IF X1-ARNG-TYPE = 'STF' OR 'STFA'                         
P00948           MOVE AT-COMPANY-NO          TO C8-COMPANY-NO           
P00948           MOVE WS-LEAST-AMT-DUE-CD    TO C8-DELINQ-CD            
P00948           PERFORM 7150-GET-DLINQ-VAL  THRU 7150-EXIT             
P00948           MOVE C8-DELINQ-VALUE        TO WS-LEAST-AMT-DUE        
P00948           COMPUTE RS-REMAIN-AMT       = RS-REMAIN-AMT -          
P00948                                         WS-LEAST-AMT-DUE         
P00948        END-IF                                                    
           ELSE                                                         
P0726A        MOVE 100                   TO RS-RETURN-CODE              
              MOVE SPACES                TO RS-ARNG-SCHD-DUE-DT         
P0726A                                      RS-ARNG-TERM-CD             
P0726C                                      RS-ARNG-TYPE                
              MOVE ZEROES                TO RS-ARNG-TOTAL-AMT           
                                            RS-REMAIN-AMT               
           END-IF.                                                      
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P0726A******************************************************************        
P0726A* 2220-CALL-MCSCB068.                                            *        
P0726A******************************************************************        
P0726A                                                                  
P0726A 2220-CALL-MCSCB068.                                              
P0726A                                                                  
P0726A* SET CPD00068 SWITCHES THAT ARE NEEDED                                   
P0726A                                                                  
P0726A     MOVE WS-CURRENT-DATE           TO WS-HOLD-DATE               
P0726A                                                                  
P0726A     MOVE 'Y' TO CALC-BALANCE-SW                                  
P0726A                 CALC-ARREARS-SW                                  
P0726A                 LOAD-DNP-DATE-SW                                 
P0726A                 LOAD-DUE-DATES-SW                                
P0726A                 CALC-PAST-DUE-SW.                                
P0726A                                                                  
P0726A     MOVE PROGRAM-NAME              TO WS-CPD00068-CALLING-PGM.   
P0726A     MOVE SPACES                    TO ABEND-FUNCTION.            
P0726A                                                                  
P0726A     CALL MCSCB068  USING  CWS00068-FIELDS                        
P0726A                           WS-CODES-DATA-PRESENT                  
P0726A                           DCLCSS-ACCOUNT                         
P0726A                           ABEND-FILE                             
P0726A                           RS-RETURN-CODE.                        
P0726A                                                                  
P0726A     MOVE RS-RETURN-CODE            TO WS-ACTIVE-RETURN-CODE      
P0726A                                       S-RETURN-CODE              
P0726A                                       SQLCODE.                   
P0726A                                                                  
P0726A     IF ABEND-FUNCTION  > SPACES                                  
P0726A        IF ABEND-FUNCTION EQUAL 'BADDATA'                         
P0726A           MOVE -1                  TO WS-ACTIVE-RETURN-CODE      
P0726A                                       S-RETURN-CODE              
P0726A        END-IF                                                    
P0726A        ADD +1                      TO CTR-ROWS                   
P0726A        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
P0726A        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
P0726A     END-IF.                                                      
P0726A                                                                  
P0726A 2220-EXIT.                                                       
P0726A     EXIT.                                                        
P0726A                                                                  
      ******************************************************************16234000
      * 7000-GET-ACTIVE-ARNG-INFO                                      *16240000
      *  GET ACTIVE ARNG INFO.                                         *16260000
      ******************************************************************16290000
       7000-GET-ACTIVE-ARNG-INFO.                                       
      *                                                                 16310000
           EXEC SQL                                                     
              SELECT TOP(1) WX.ARNG_SCHD_DUE_DT,
              X1.ARNG_TOTAL_AMT,
              X1.ARNG_SETUP_DT,
              X1.ARNG_ID,
              X1.ARNG_OPTION_ID,
              X1.ARNG_TYPE,
              REPLACE(REPLACE(CONVERT(CHAR(26), WY.ARNG_HIST_TS, 121), 
           ' ', '-'), ':', '.') ARNG_HIST_TS                                   
                INTO :WX-ARNG-SCHD-DUE-DT :WS-NULL-IND                   
                    ,:X1-ARNG-TOTAL-AMT                                 
P0726A              ,:X1-ARNG-SETUP-DT                                  
P0726A              ,:X1-ARNG-ID                                        
P0726A              ,:X1-ARNG-OPTION-ID                                 
P0726A              ,:X1-ARNG-TYPE                                      
P0726A              ,:WY-ARNG-HIST-TS                                   
                FROM CSS_CRED_ARNGMENT X1 WITH(READUNCOMMITTED)                 
                    ,CSS_CRED_ARNG_SCHD WX WITH(READUNCOMMITTED)                
P0726A              ,CSS_CRED_ARNG_HIST WY WITH(READUNCOMMITTED)                
               WHERE X1.ACCOUNT_NO     =  :X1-ACCOUNT-NO                
                 AND X1.ACCOUNT_NO     =  WX.ACCOUNT_NO                 
P0726A           AND WX.ACCOUNT_NO     =  WY.ACCOUNT_NO                 
                 AND X1.ARNG_ID        =  WX.ARNG_ID                    
P0726A           AND WX.ARNG_ID        =  WY.ARNG_ID                    
                 AND X1.CRED_ARNG_SEQ  =  WX.CRED_ARNG_SEQ              
P0726A           AND WX.CRED_ARNG_SEQ  =  WY.CRED_ARNG_SEQ              
P0726A           AND WY.ARNG_CHANGE_CD =  'S'                           
                 AND X1.ARNG_STATUS_CD =  'A'                           
                 AND WX.ARNG_SCHD_SEQ  =  1                             
                                                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     16320000
MFA-TR*       SELECT WX.ARNG_SCHD_DUE_DT                                16330000
MFA-TR*             ,X1.ARNG_TOTAL_AMT                                  16330000
MFA-TR*             ,X1.ARNG_SETUP_DT                                           
MFA-TR*             ,X1.ARNG_ID                                                 
MFA-TR*             ,X1.ARNG_OPTION_ID                                          
MFA-TR*             ,X1.ARNG_TYPE                                               
MFA-TR*             ,WY.ARNG_HIST_TS                                            
MFA-TR*         INTO :WX-ARNG-SCHD-DUE-DT:WS-NULL-IND                   16341000
MFA-TR*             ,:X1-ARNG-TOTAL-AMT                                 16341000
MFA-TR*             ,:X1-ARNG-SETUP-DT                                          
MFA-TR*             ,:X1-ARNG-ID                                                
MFA-TR*             ,:X1-ARNG-OPTION-ID                                         
MFA-TR*             ,:X1-ARNG-TYPE                                              
MFA-TR*             ,:WY-ARNG-HIST-TS                                           
MFA-TR*         FROM CSS_CRED_ARNGMENT X1                               16350000
MFA-TR*             ,CSS_CRED_ARNG_SCHD WX                              16350000
MFA-TR*             ,CSS_CRED_ARNG_HIST WY                                      
MFA-TR*        WHERE X1.ACCOUNT_NO     =  :X1-ACCOUNT-NO                16390000
MFA-TR*          AND X1.ACCOUNT_NO     =  WX.ACCOUNT_NO                 16400000
MFA-TR*          AND WX.ACCOUNT_NO     =  WY.ACCOUNT_NO                         
MFA-TR*          AND X1.ARNG_ID        =  WX.ARNG_ID                    16410000
MFA-TR*          AND WX.ARNG_ID        =  WY.ARNG_ID                            
MFA-TR*          AND X1.CRED_ARNG_SEQ  =  WX.CRED_ARNG_SEQ              16420000
MFA-TR*          AND WX.CRED_ARNG_SEQ  =  WY.CRED_ARNG_SEQ                      
MFA-TR*          AND WY.ARNG_CHANGE_CD =  'S'                                   
MFA-TR*          AND X1.ARNG_STATUS_CD =  'A'                           16420000
MFA-TR*          AND WX.ARNG_SCHD_SEQ  =  1                             16420000
MFA-TR*       FETCH FIRST 1 ROW ONLY                                            
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7000                                                      
MFA-TR*    END-EXEC.                                                    16430000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 16440000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                 16460000
P0726A     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE '7000'                    TO ACTIVE-PARAGRAPH       
               MOVE 'SELECT'                  TO ABEND-FUNCTION         
               MOVE 'ARNG_TOTAL_AMT'          TO TABLE-1                
               MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1        
               MOVE WS-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1      
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                 16590000
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16650000
      *****************************************************************         
P0726A* 7100-SELECT-ACCOUNT                                           *         
      *     SELECTS CSS_ACCOUNT                                       *         
      *****************************************************************         
P0726A 7100-SELECT-ACCOUNT.                                             
      *                                                                         
           MOVE '7100'               TO ACTIVE-PARAGRAPH.               
      *                                                                         
           EXEC SQL                                                     
              SELECT AT.TOTAL_AR_BALANCE                                
P0726A              ,AT.COMPANY_NO                                      
P0726A              ,AT.CODES_DATA_PRESENT                              
P0726A              ,AT.CODE_ACCT_STAT                                  
P0726A              ,AT.CREDIT_GROUP                                    
P0726A              ,AT.NOTICE_EXEMPT_CD                                
P0726A              ,AT.CODE_DISC_OK                                    
P0726A              ,AT.DATE_BILL_DAY_00                                
P0726A              ,AT.DATE_BILL_DAY_30                                
P0726A              ,AT.DATE_BILL_DAY_60                                
P0726A              ,AT.DATE_BILL_DAY_90                                
P0726A              ,AT.LOCAL_OFFICE                                    
P0726A              ,AT.BANKRUPTCY_IND                                  
P0726A              ,AT.IVR_EXEMPT_CD                                   
                INTO :AT-TOTAL-AR-BALANCE                               
P0726A              ,:AT-COMPANY-NO                                     
P0726A              ,:AT-CODES-DATA-PRESENT                             
P0726A              ,:AT-CODE-ACCT-STAT                                 
P0726A              ,:AT-CREDIT-GROUP                                   
P0726A              ,:AT-NOTICE-EXEMPT-CD                               
P0726A              ,:AT-CODE-DISC-OK                                   
P0726A              ,:AT-DATE-BILL-DAY-00 :WS-DATE-BILL-00-IND          
P0726A              ,:AT-DATE-BILL-DAY-30 :WS-DATE-BILL-30-IND          
P0726A              ,:AT-DATE-BILL-DAY-60 :WS-DATE-BILL-60-IND          
P0726A              ,:AT-DATE-BILL-DAY-90 :WS-DATE-BILL-90-IND          
P0726A              ,:AT-LOCAL-OFFICE                                   
P0726A              ,:AT-BANKRUPTCY-IND                                 
P0726A              ,:AT-IVR-EXEMPT-CD                                  
                FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
               WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT AT.TOTAL_AR_BALANCE                                        
MFA-TR*             ,AT.COMPANY_NO                                              
MFA-TR*             ,AT.CODES_DATA_PRESENT                                      
MFA-TR*             ,AT.CODE_ACCT_STAT                                          
MFA-TR*             ,AT.CREDIT_GROUP                                            
MFA-TR*             ,AT.NOTICE_EXEMPT_CD                                        
MFA-TR*             ,AT.CODE_DISC_OK                                            
MFA-TR*             ,AT.DATE_BILL_DAY_00                                        
MFA-TR*             ,AT.DATE_BILL_DAY_30                                        
MFA-TR*             ,AT.DATE_BILL_DAY_60                                        
MFA-TR*             ,AT.DATE_BILL_DAY_90                                        
MFA-TR*             ,AT.LOCAL_OFFICE                                            
MFA-TR*             ,AT.BANKRUPTCY_IND                                          
MFA-TR*             ,AT.IVR_EXEMPT_CD                                           
MFA-TR*         INTO :AT-TOTAL-AR-BALANCE                                       
MFA-TR*             ,:AT-COMPANY-NO                                             
MFA-TR*             ,:AT-CODES-DATA-PRESENT                                     
MFA-TR*             ,:AT-CODE-ACCT-STAT                                         
MFA-TR*             ,:AT-CREDIT-GROUP                                           
MFA-TR*             ,:AT-NOTICE-EXEMPT-CD                                       
MFA-TR*             ,:AT-CODE-DISC-OK                                           
MFA-TR*             ,:AT-DATE-BILL-DAY-00 :WS-DATE-BILL-00-IND                  
MFA-TR*             ,:AT-DATE-BILL-DAY-30 :WS-DATE-BILL-30-IND                  
MFA-TR*             ,:AT-DATE-BILL-DAY-60 :WS-DATE-BILL-60-IND                  
MFA-TR*             ,:AT-DATE-BILL-DAY-90 :WS-DATE-BILL-90-IND                  
MFA-TR*             ,:AT-LOCAL-OFFICE                                           
MFA-TR*             ,:AT-BANKRUPTCY-IND                                         
MFA-TR*             ,:AT-IVR-EXEMPT-CD                                          
MFA-TR*         FROM CSS_ACCOUNT AT                                             
MFA-TR*        WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                             
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7100                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P0726A        IF WS-DATE-BILL-00-IND < 0                                
P0726A           MOVE SPACES TO AT-DATE-BILL-DAY-00                     
P0726A           MOVE ZEROES TO WS-DATE-BILL-00-IND                     
P0726A        END-IF                                                    
P0726A        IF WS-DATE-BILL-30-IND < 0                                
P0726A           MOVE SPACES TO AT-DATE-BILL-DAY-30                     
P0726A           MOVE ZEROES TO WS-DATE-BILL-30-IND                     
P0726A        END-IF                                                    
P0726A        IF WS-DATE-BILL-60-IND < 0                                
P0726A           MOVE SPACES TO AT-DATE-BILL-DAY-60                     
P0726A           MOVE ZEROES TO WS-DATE-BILL-60-IND                     
P0726A        END-IF                                                    
P0726A        IF WS-DATE-BILL-90-IND < 0                                
P0726A           MOVE SPACES TO AT-DATE-BILL-DAY-90                     
P0726A           MOVE ZEROES TO WS-DATE-BILL-90-IND                     
P0726A        END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7100'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P0726A******************************************************************        
P0726A* 7110-SELECT-REG-GROUP-CD                                       *        
P0726A******************************************************************        
P0726A                                                                  
P0726A 7110-SELECT-REG-GROUP-CD.                                        
P0726A                                                                  
P0726A     EXEC SQL                                                     
P0726A        SELECT LR.REG_GROUP_CD                                    
P0726A          INTO :WS-REG-GROUP-CD                                   
P0726A          FROM CSS_REG_PROFILE LR WITH(READUNCOMMITTED)                   
P0726A         WHERE LR.ACCOUNT_NO = :AT-ACCOUNT-NO                     
P0726A                                                           
P0726A                                                      
P0726A     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT LR.REG_GROUP_CD                                            
MFA-TR*         INTO :WS-REG-GROUP-CD                                           
MFA-TR*         FROM CSS_REG_PROFILE LR                                         
MFA-TR*        WHERE LR.ACCOUNT_NO = :AT-ACCOUNT-NO                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7110                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0726A                                                                  
P0726A     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P0726A                                                                  
P0726A     EVALUATE WS-ACTIVE-RETURN-CODE                               
P0726A         WHEN SUCCESSFUL-CALL                                     
P0726A              CONTINUE                                            
P0726A         WHEN NOT-FOUND                                           
P0726A              MOVE SPACES             TO WS-REG-GROUP-CD          
P0726A         WHEN OTHER                                               
P0726A              MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
P0726A              MOVE '7110'             TO ACTIVE-PARAGRAPH         
P0726A              MOVE 'SELECT'           TO ABEND-FUNCTION           
P0726A              MOVE SPACES             TO ABEND-SQL-PREDICATES     
P0726A                                         ABEND-TABLES             
P0726A              MOVE 'CSS_REG_PROFILE'  TO TABLE-1                  
P0726A              MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1          
P0726A              MOVE AT-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1        
P0726A              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT      
P0726A              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT      
P0726A     END-EVALUATE.                                                
P0726A                                                                  
P0726A 7110-EXIT.                                                       
P0726A     EXIT.                                                        
P0726A                                                                  
P0726A*****************************************************************         
P0726A* 7120-GET-ARNG-TERM-CODE                                       *         
P0726A*****************************************************************         
P0726A                                                                  
P0726A 7120-GET-ARNG-TERM-CODE.                                         
P0726A                                                                  
P0726A     EXEC SQL                                                     
P0726A        SELECT UD.OPTION_TERM_CD                                  
P0726A              ,UF.PLAN_TERM_CD                                    
P0726A          INTO :UD-OPTION-TERM-CD                                 
P0726A              ,:UF-PLAN-TERM-CD                                   
P0726A          FROM CSS_ARNG_PLAN   UF WITH(READUNCOMMITTED)                   
P0726A              ,CSS_ARNG_OPTION UD WITH(READUNCOMMITTED)                   
P0726A         WHERE UD.ARNG_PLAN_ID        = UF.ARNG_PLAN_ID           
P0726A           AND UD.ARNG_ID             = UF.ARNG_ID                
P0726A           AND UD.ARNG_OPTION_ID      = :X1-ARNG-OPTION-ID        
P0726A           AND UD.ARNG_ID             = :X1-ARNG-ID               
P0726A           AND UF.COMPANY_NO          = :AT-COMPANY-NO            
P0726A           AND UF.REG_GROUP_CD        = :WS-REG-GROUP-CD          
P0726A           AND UF.ARNG_PLAN_EFF_DT   <= IIF(TRY_CONVERT(DATE, 
                                                      :X1-ARNG-SETUP-DT
              ) IS NULL OR (PATINDEX('%.%', :X1-ARNG-SETUP-DT
              ) <> 0) OR (LEN(:X1-ARNG-SETUP-DT) <> 10), CIS.CHAR2DATE(
                                                      :X1-ARNG-SETUP-DT
              ), CONVERT(DATE, :X1-ARNG-SETUP-DT) )         
P0726A           AND UF.ARNG_PLAN_EXP_DT   >= IIF(TRY_CONVERT(DATE, 
                                                      :X1-ARNG-SETUP-DT
              ) IS NULL OR (PATINDEX('%.%', :X1-ARNG-SETUP-DT
              ) <> 0) OR (LEN(:X1-ARNG-SETUP-DT) <> 10), CIS.CHAR2DATE(
                                                      :X1-ARNG-SETUP-DT
              ), CONVERT(DATE, :X1-ARNG-SETUP-DT) )         
P0726A           AND UD.ARNG_OPTION_EFF_DT <= IIF(TRY_CONVERT(DATE, 
                                                      :X1-ARNG-SETUP-DT
              ) IS NULL OR (PATINDEX('%.%', :X1-ARNG-SETUP-DT
              ) <> 0) OR (LEN(:X1-ARNG-SETUP-DT) <> 10), CIS.CHAR2DATE(
                                                      :X1-ARNG-SETUP-DT
              ), CONVERT(DATE, :X1-ARNG-SETUP-DT) )         
P0726A           AND UD.ARNG_OPTION_EXP_DT >= IIF(TRY_CONVERT(DATE, 
                                                      :X1-ARNG-SETUP-DT
              ) IS NULL OR (PATINDEX('%.%', :X1-ARNG-SETUP-DT
              ) <> 0) OR (LEN(:X1-ARNG-SETUP-DT) <> 10), CIS.CHAR2DATE(
                                                      :X1-ARNG-SETUP-DT
              ), CONVERT(DATE, :X1-ARNG-SETUP-DT) )         
P0726A                                                           
P0726A                                                      
P0726A     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT UD.OPTION_TERM_CD                                          
MFA-TR*             ,UF.PLAN_TERM_CD                                            
MFA-TR*         INTO :UD-OPTION-TERM-CD                                         
MFA-TR*             ,:UF-PLAN-TERM-CD                                           
MFA-TR*         FROM CSS_ARNG_PLAN   UF                                         
MFA-TR*             ,CSS_ARNG_OPTION UD                                         
MFA-TR*        WHERE UD.ARNG_PLAN_ID        = UF.ARNG_PLAN_ID                   
MFA-TR*          AND UD.ARNG_ID             = UF.ARNG_ID                        
MFA-TR*          AND UD.ARNG_OPTION_ID      = :X1-ARNG-OPTION-ID                
MFA-TR*          AND UD.ARNG_ID             = :X1-ARNG-ID                       
MFA-TR*          AND UF.COMPANY_NO          = :AT-COMPANY-NO                    
MFA-TR*          AND UF.REG_GROUP_CD        = :WS-REG-GROUP-CD                  
MFA-TR*          AND UF.ARNG_PLAN_EFF_DT   <= :X1-ARNG-SETUP-DT                 
MFA-TR*          AND UF.ARNG_PLAN_EXP_DT   >= :X1-ARNG-SETUP-DT                 
MFA-TR*          AND UD.ARNG_OPTION_EFF_DT <= :X1-ARNG-SETUP-DT                 
MFA-TR*          AND UD.ARNG_OPTION_EXP_DT >= :X1-ARNG-SETUP-DT                 
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7120                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0726A                                                                  
P0726A     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
P0726A                                                                  
P0726A     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P0726A        CONTINUE                                                  
P0726A     ELSE                                                         
P0726A        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
P0726A        MOVE '7120'                TO ACTIVE-PARAGRAPH            
P0726A        MOVE 'SELECT'              TO ABEND-FUNCTION              
P0726A        MOVE SPACES                TO ABEND-SQL-PREDICATES        
P0726A                                      ABEND-TABLES                
P0726A        MOVE 'CSS_ARNG_PLAN'       TO TABLE-1                     
P0726A        MOVE 'CSS_ARNG_OPTION'     TO TABLE-2                     
P0726A        MOVE 'ARNG_OPTION_ID'      TO TABLE-ELEMENT-1             
P0726A        MOVE X1-ARNG-OPTION-ID     TO HOSTVAR-ELEMENT-1           
P0726A        MOVE 'ARNG_ID'             TO TABLE-ELEMENT-2             
P0726A        MOVE X1-ARNG-ID            TO HOSTVAR-ELEMENT-2           
P0726A        MOVE 'REG_GROUP_CD'        TO TABLE-ELEMENT-3             
P0726A        MOVE WS-REG-GROUP-CD       TO HOSTVAR-ELEMENT-3           
P0726A        MOVE 'ARNG_PLAN_EFF_DT'    TO TABLE-ELEMENT-4             
P0726A        MOVE X1-ARNG-SETUP-DT      TO HOSTVAR-ELEMENT-4           
P0726A        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
P0726A        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
P0726A     END-IF.                                                      
P0726A                                                                  
P0726A 7120-EXIT.                                                       
P0726A     EXIT.                                                        
P0726A                                                                  
P0726A******************************************************************        
P0726A* 7130-GET-CURRENT-DATE                                                   
P0726A******************************************************************        
P0726A                                                                  
P0726A 7130-GET-CURRENT-DATE.                                           
P0726A                                                                  
P0726A     EXEC SQL                                                     
P0726A         SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                      
P0726A     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET: WS-CURRENT-DATE = CURRENT DATE                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0726A                                                                  
P0726A     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
P0726A                                                                  
P0726A     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P0726A        CONTINUE                                                  
P0726A     ELSE                                                         
P0726A        MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
P0726A        MOVE '7130'                   TO ACTIVE-PARAGRAPH         
P0726A        MOVE 'SET'                    TO ABEND-FUNCTION           
P0726A        PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
P0726A        PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
P0726A     END-IF.                                                      
P0726A                                                                  
P0726A 7130-EXIT.                                                       
P0726A     EXIT.                                                        
P0726A                                                                  
P0726A******************************************************************        
P0726A* 7140-SELECT-BILL-DETAILS                                       *        
P0726A******************************************************************        
P0726A                                                                  
P0726A 7140-SELECT-BILL-DETAILS.                                        
P0726A                                                                  
P0726A     EXEC SQL                                                     
P0726A        SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS           
P0726A          INTO :BI-LAST-UPDATE-TS                                 
P0726A          FROM CSS_BILLING_HDR WITH(READUNCOMMITTED)                      
P0726A         WHERE ACCOUNT_NO  = :BI-ACCOUNT-NO                       
P0726A           AND DATE_BILLED IS NOT NULL                            
P0726A         ORDER BY BILL_NO DESC                                    
P0726A                                                           
P0726A                                           
P0726A                                                      
P0726A     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT LAST_UPDATE_TS                                             
MFA-TR*         INTO :BI-LAST-UPDATE-TS                                         
MFA-TR*         FROM CSS_BILLING_HDR                                            
MFA-TR*        WHERE ACCOUNT_NO  = :BI-ACCOUNT-NO                               
MFA-TR*          AND DATE_BILLED IS NOT NULL                                    
MFA-TR*        ORDER BY BILL_NO DESC                                            
MFA-TR*         WITH UR                                                         
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*      QUERYNO 7140                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0726A                                                                  
P0726A     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
P0726A                                                                  
P0726A     EVALUATE WS-ACTIVE-RETURN-CODE                               
P0726A         WHEN SUCCESSFUL-CALL                                     
P0726A              CONTINUE                                            
P0726A         WHEN NOT-FOUND                                           
P0726A              MOVE SPACES             TO BI-LAST-UPDATE-TS        
P0726A         WHEN OTHER                                               
P0726A              MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
P0726A              MOVE '7140'             TO ACTIVE-PARAGRAPH         
P0726A              MOVE 'SELECT'           TO ABEND-FUNCTION           
P0726A              MOVE SPACES             TO ABEND-SQL-PREDICATES     
P0726A                                         ABEND-TABLES             
P0726A              MOVE 'CSS_BILLING_HDR'  TO TABLE-1                  
P0726A              MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1          
P0726A              MOVE BI-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1        
P0726A              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT      
P0726A              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT      
P0726A     END-EVALUATE.                                                
P0726A                                                                  
P0726A 7140-EXIT.                                                       
P0726A     EXIT.                                                        
P0726A                                                                  
P0726A*****************************************************************         
P0726A* 7150-MET-DLINQ-VAL.                                           *         
P0726A*****************************************************************         
P0726A                                                                  
P0726A 7150-GET-DLINQ-VAL.                                              
P0726A                                                                  
P0726A     EXEC SQL                                                     
P0726A        SELECT C8.DELINQ_VALUE                                    
P0726A          INTO :C8-DELINQ-VALUE                                   
P0726A          FROM CSS_DELINQUENCY C8 WITH(READUNCOMMITTED)                   
P0726A         WHERE C8.DELINQ_CD  = :C8-DELINQ-CD                      
P0726A           AND C8.COMPANY_NO = :C8-COMPANY-NO                     
P0726A                                                           
P0726A                                                      
P0726A     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT C8.DELINQ_VALUE                                            
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY C8                                         
MFA-TR*        WHERE C8.DELINQ_CD  = :C8-DELINQ-CD                              
MFA-TR*          AND C8.COMPANY_NO = :C8-COMPANY-NO                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7150                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0726A                                                                  
P0726A     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
P0726A                                                                  
P0726A     EVALUATE WS-ACTIVE-RETURN-CODE                               
P0726A       WHEN SUCCESSFUL-CALL                                       
P0726A         CONTINUE                                                 
P0726A       WHEN OTHER                                                 
P0726A         MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
P0726A         MOVE SQLCODE                 TO ABEND-SQLCODE            
P0726A                                         RS-RETURN-CODE           
P0726A         MOVE SQLSTATE                TO ABEND-SQLSTATE           
P0726A         MOVE '7150'                  TO ACTIVE-PARAGRAPH         
P0726A         MOVE 'SELECT'                TO ABEND-FUNCTION           
P0726A         MOVE 'CSS_DELINQUENCY'       TO TABLE-1                  
P0726A         MOVE 'DELINQ_CD'             TO TABLE-ELEMENT-1          
P0726A         MOVE 'COMPANY_NO'            TO TABLE-ELEMENT-2          
P0726A         MOVE C8-DELINQ-CD            TO HOSTVAR-ELEMENT-1        
P0726A         MOVE C8-COMPANY-NO           TO HOSTVAR-ELEMENT-2        
P0726A         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
P0726A         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
P0726A     END-EVALUATE.                                                
P0726A                                                                  
P0726A 7150-EXIT.                                                       
P0726A     EXIT.                                                        
P0726A                                                                  
      ******************************************************************        
      * 7200-GET-USA-DATE                                              *        
      *     FORMATS THE DATE                                           *        
      ******************************************************************        
      *                                                                         
       7200-GET-USA-DATE.                                               
      *                                                                         
           MOVE '7200'              TO ACTIVE-PARAGRAPH.                
      *                                                                         
           EXEC SQL                                                     
              SELECT
              CIS.CHAR2$DATE(IIF(TRY_CONVERT(DATE, :WS-DATE-HOLD
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-HOLD
              ) <> 0) OR (LEN(:WS-DATE-HOLD) <> 10), CIS.CHAR2DATE(
                                                          :WS-DATE-HOLD
              ), CONVERT(DATE, :WS-DATE-HOLD) ),'USA')
            INTO
              :WS-DATE-HOLD-USA     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-DATE-HOLD-USA = CHAR(DATE(:WS-DATE-HOLD),USA)             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE 'SET'               TO ABEND-FUNCTION                
              MOVE 'WS-DATE-HOLD'      TO TABLE-ELEMENT-1               
              MOVE WS-DATE-HOLD        TO HOSTVAR-ELEMENT-1             
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
      *                                                                 16650000
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                 16650000
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
       8100-SEND-RESULT.                                                
      *                                                                 16650000
             ADD 1 TO CTR-ROWS.                                         
      *                                                                 16650000
       8100-EXIT.                                                       
              EXIT.                                                     
      *                                                                 16650000
           EXEC SQL                                                           00
               INCLUDE CPD00321                                               00
           END-EXEC.                                                          00
      *                                                                 16650000
