       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04633.                                          
       DATE-WRITTEN.     MAY 09, 2013.                                  
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00060000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00070000
      *                                                                *00080000
      *  THIS PROGRAM UPDATES THE ACCOUNT BILLING ADDRESS: (I)NSERTS,  *00210000
      *  (D)ELETES AND (U)PDATES THE FREEFORM BILLING ADDRESS          *00220000
      *  INTERNATIONAL ACH TRANSACTION COLUMNS.                        *00251000
      *                                                                *00240000
      *  DATA WILL BE MAINTAINED FROM THE FOLLOWING TABLE:             *00250000
      *                                                                *00260000
      *  TABLE                  TABLE ID     DCLGEN                    *00270000
      *  -----                  --------     ------                    *00280000
      *  CSS_ADDR_FREEFORM         DZ        TBADRFRE                  *00320000
      *                                                                *00451000
      ******************************************************************00440000
      *                                                                *00450000
      *                     PROGRAM MODIFICATION LOG                   *00460000
      *                                                                *00470000
      *    DATE    INITIALS   COMMENTS                                 *00480000
      *  --------  --------   -----------------                        *00490000
P00547*  05/09/13   DB18339   CREATED.                                 *00500000
      ******************************************************************00532700
      *                                                                *00532900
      *                -- BASIC SEQUENCE STRUCTURE --                  *00535100
      *                                                                *00533100
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00533200
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00533300
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00534000
      *  5100 - 4999  NOT USED                                         *00535000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00536000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00537000
      *  7000 - 7999  INPUT MODULES                                    *00538000
      *  8000 - 8999  OUTPUT MODULES                                   *00539000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00540000
      *                                                                *00550000
      ******************************************************************00560000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04633'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR04633 STARTS HERE'.                  
                                                                        
      ******************************************************************00650000
      *    DB2 INCLUDES                                                *00660000
      ******************************************************************00670000
                                                                        
           EXEC SQL                                                     00690000
              INCLUDE SQLCA                                             00700000
           END-EXEC.                                                    00710000
                                                                        
           EXEC SQL                                                     00751000
              INCLUDE TBMODEL                                           00740000
           END-EXEC.                                                    00750000
                                                                        
      *----< CSS_ADDR_FREEFORM >                                        00920000
           EXEC SQL                                                     00951000
              INCLUDE TBADRFRE                                          00940000
           END-EXEC.                                                    00950000
                                                                        
      *---< CSS_MNT_TRANS_HIST >                                        01120000
           EXEC SQL                                                     01151000
              INCLUDE TBMNHIST                                          01140000
           END-EXEC.                                                    01150000
                                                                        
      *---< CSS_MT_TRN_HST_DET >                                        01170000
           EXEC SQL                                                     01180000
              INCLUDE TBMNHDT                                           01190000
           END-EXEC.                                                    01200000
                                                                        
      *---< CSS_USER_PROFILE >                                          01170000
           EXEC SQL                                                     01180000
              INCLUDE TBUSRPRF                                          01190000
           END-EXEC.                                                    01200000
                                                                        
      ******************************************************************01470000
      *    COBOL WORKING STORAGE COPY BOOKS                            *01480000
      ******************************************************************01490000
                                                                        
           COPY CCA00001.                                               01570000
           COPY CWS00011.                                               01570000
           EXEC SQL                                                             
             INCLUDE CWSX0010                                                   
           END-EXEC.                                                            
      *----< ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS >           01600000
           COPY CWS00027.                                               01610000
      *----< SUPPORTS DB2 AND SQL ERROR CHECKING >                      01620000
           COPY CWS00303.                                               01651000
                                                                        
           EXEC SQL                                                     01632000
              INCLUDE CWS00071                                          01635100
           END-EXEC.                                                    01634000
                                                                        
           EXEC SQL                                                     01636000
              INCLUDE CWS0090A                                          01637000
           END-EXEC.                                                    01638000
                                                                        
           EXEC SQL                                                     01639100
              INCLUDE CWS0091A                                          01639200
           END-EXEC.                                                    01639300
                                                                        
      ******************************************************************01650000
      *    WORK AREAS                                                  *01660000
      ******************************************************************01670000
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR04633'.      
           05  WS-SQLSTATE             PIC X(05) VALUE SPACES.          
                                                                        
       01  GTT-MISC-FIELDS.                                             
           05  GTT-NAME                PIC X(26) VALUE                  
                                           'SESSION.CSR04633_R1'.       
           05  GTT-ROW.                                                 
               49 GTT-ROW-LEN          PIC S9(04) COMP.                 
               49 GTT-ROW-CHAR         PIC X(1024).                     
           05  GTT-SQLCODE             PIC S9(9) COMP.                  
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN                PIC S9(9)   COMP VALUE 1.      
           05  CTR-ROWS                  PIC S9(9)   COMP VALUE 0.      
           05  WS-ROW-COUNT              PIC S9(9)   COMP VALUE 0.      
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM           PIC S9(9)   COMP VALUE 0.      
           05  WRKLEN1                   PIC S9(9)   COMP VALUE 0.      
           05  WRKLEN2                   PIC S9(9)   COMP VALUE 0.      
           05  WRK-DONE-STATUS           PIC S9(9)   COMP VALUE 0.      
                                                                        
       01  WS-FLAG-VALUES.                                              
           05  WS-YES                    PIC X(01)   VALUE 'Y'.         
           05  WS-NO                     PIC X(01)   VALUE 'N'.         
           05  WS-ACTIVE-CODE            PIC X(01)   VALUE 'A'.         
           05  WS-B                      PIC X(01)   VALUE 'B'.         
           05  WS-S                      PIC X(01)   VALUE 'S'.         
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE            PIC S9(09)  COMP VALUE 0.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE             PIC S9(09)  COMP VALUE 0.      
                                                                        
       01  GENERAL-WORKING-STORAGE.                                     
           05  WS-ACCOUNT-NO-I           PIC S9(13)  USAGE COMP         
                                                     VALUE ZERO.        
           05  WS-ACCOUNT-NO-D           PIC S9(13)V USAGE COMP-3       
                                                     VALUE ZERO.        
           05  WS-ADDRESS-ID-I           PIC S9(13)  USAGE COMP         
                                                     VALUE ZERO.        
           05  WS-TRANS-HIST-SEQ-NO      PIC X(26)   VALUE SPACES.      
           05  WS-TRAN-APPL-NO           PIC S9(4)   COMP VALUE 1.      
           05  WS-DATE-TRANS             PIC X(10)   VALUE SPACES.      
           05  WS-RESP-AREA-ID           PIC X(03)   VALUE SPACES.      
                                                                        
       01  MISC-HOLD-FIELDS.                                            
           05  WS-NULL-IND               PIC S9(04)  COMP VALUE 0.      
                                                                        
       01  MISC-FLAGS.                                                  
           05  ADDR-FREE-EXISTS-FLAG      PIC X(01)  VALUE 'N'.         
               88 ADDR-FREE-EXISTS                   VALUE 'Y'.         
                                                                        
       01  WS-NEW-ADDR-COMP.                                            
           05  WS-NEW-ADDR-ID-COMP         PIC S9(13) COMP-3            
                                                     VALUE ZERO.        
           05  WS-NEW-ADDR-IDENT           PIC 9(13).                   
           05  FILLER REDEFINES WS-NEW-ADDR-IDENT.                      
               10  WS-NEW-ADDR-CHECK-DIGIT PIC 9.                       
               10  WS-NEW-ADDR-ID          PIC 9(12).                   
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       LINKAGE SECTION.                                                 
       01 PARM-ACCOUNT-NO           PIC X(13)   VALUE SPACES.           
       01 PARM-USER-ID              PIC X(07)   VALUE SPACES.           
       01 PARM-ADDRESS-ID           PIC X(13)   VALUE SPACES.           
       01 PARM-INTRNTNL-CITY        PIC X(40)   VALUE SPACES.           
       01 PARM-INTRNTNL-PROVINCE    PIC X(10)   VALUE SPACES.           
       01 PARM-INTRNTNL-POST-CODE   PIC X(25)   VALUE SPACES.           
                                                                        
       PROCEDURE DIVISION USING PARM-ACCOUNT-NO                         
                                PARM-USER-ID                            
                                PARM-ADDRESS-ID                         
                                PARM-INTRNTNL-CITY                      
                                PARM-INTRNTNL-PROVINCE                  
                                PARM-INTRNTNL-POST-CODE.                
                                                                        
      ******************************************************************03690000
      * 0000-MAINLINE                                                  *03700000
      *     CALLS 0100-INITIALIZE                                      *03710000
      *           1000-PROCESS-INPUT                                   *03720000
      *           2000-PROCESS-OUTPUT                                  *03751000
      *           9999-END-PROGRAM                                     *03740000
      *                                                                *03750000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *03760000
      ******************************************************************03770000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03890000
      * 0100-INITIALIZE                                                *03900000
      *     CALLS 9000-SEND-ERROR-RESULT                               *03910000
      *           9900-SQL-ERROR-ROUTINE                               *03920000
      *                                                                *03951000
      *     CALLED FROM 0000-MAINLINE                                  *03940000
      *                                                                *03950000
      *     1. RESET DB2 ERROR HANDLERS                                *03960000
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *03970000
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *03980000
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*03990000
      *                                                                *04000000
      ******************************************************************04010000
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'          TO ACTIVE-PARAGRAPH.                    
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT                                                   
                    :S-RETURN-CODE          AS RETURN_CODE              
               FROM                                                     
                    CIS.SYSDUMMY1                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                     04250000
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT                                                           
MFA-TR*             :S-RETURN-CODE          AS RETURN_CODE                      
MFA-TR*        FROM                                                             
MFA-TR*             SYSIBM.SYSDUMMY1                                            
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04290000
      * 1000-PROCESS-INPUT                                             *04510000
      *     CALLS 1100-RECEIVE-PARMS                                   *04310000
      *                                                                *04320000
      *     CALLED FROM 0000-MAINLINE                                  *04351000
      *                                                                *04340000
      *     1. RECEIVE PARMS.                                          *04350000
      ******************************************************************04360000
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-ACCOUNT-NO           TO WS-ACCOUNT-NO-I.           
           MOVE WS-ACCOUNT-NO-I           TO WS-ACCOUNT-NO-D.           
           MOVE PARM-ADDRESS-ID           TO WS-ADDRESS-ID-I.           
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************09710000
      * 2000-PROCESS-OUTPUT.                                           *09720000
      *     CALLS        2100-DESCRIBE-RESULT                          *09751000
      *                  2300-FIND-OLD-VALUES                          *09740000
      *                  8100-SEND-RESULT                              *09750000
      *                                                                *09760000
      *      CALLED FROM 0000-MAINLINE                                 *09770000
      *                                                                *09780000
      *      SETS UP PARAMETERS TO BE RETURNED, POPULATES THE PARMS    *09790000
      *      AND SENDS THEM BACK                                       *09800000
      ******************************************************************09810000
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2300-FIND-OLD-VALUES          THRU 2300-EXIT.        
                                                                        
           PERFORM 5000-UPDATE                   THRU 5000-EXIT.        
                                                                        
           MOVE '2000'                           TO ACTIVE-PARAGRAPH.   
           MOVE RS-RETURN-CODE                   TO S-RETURN-CODE.      
           ADD +1                                TO CTR-ROWS.           
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************10522000
      * 2300-FIND-OLD-VALUES                                           *10551000
      *                                                                *10540000
      *     CALLS                                                      *10550000
      *           7100-SELECT-ADDR-FREEFORM                            *10590000
      *                                                                *10660000
      *     CALLED FROM 2000-PROCESS-OUTPUT                            *10670000
      *                                                                *10680000
      *     GETS ORIGINAL VALUES FOR JOURNALLING.                      *10690000
      ******************************************************************10700000
                                                                        
       2300-FIND-OLD-VALUES.                                            
                                                                        
           MOVE '2300' TO ACTIVE-PARAGRAPH.                             
                                                                        
           MOVE 'N'    TO ADDR-FREE-EXISTS-FLAG.                        
                                                                        
           PERFORM 7100-SELECT-ADDR-FREEFORM   THRU 7100-EXIT.          
                                                                        
           IF DZ-INTRNTNL-CITY < SPACES                                 
               MOVE SPACES TO     DZ-INTRNTNL-CITY                      
           END-IF.                                                      
                                                                        
           IF DZ-INTRNTNL-PROVINCE < SPACES                             
               MOVE SPACES TO     DZ-INTRNTNL-PROVINCE                  
           END-IF.                                                      
                                                                        
           IF DZ-INTRNTNL-POST-CODE < SPACES                            
               MOVE SPACES TO     DZ-INTRNTNL-POST-CODE                 
           END-IF.                                                      
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************11186000
      * 5000-UPDATE                                                    *11187000
      *                                                                *11188000
      *     CALLS 5010-JRNL-TRAN-HEAD                                  *11189000
      *           5020-JRNL-ACCOUNT-DETAILS                            *11190000
      *           5040-JRNL-ATTN-NAME                                  *11200000
      *           5050-JRNL-BILL-NAME                                  *11210000
      *                                                                *11250000
      *     CALLED FROM 2300-BUILD-RESULT                              *11260000
      *                                                                *11270000
      *     UPDATE THE MAINTENANCE TRANSACTION HISTORY TABLES.         *11280000
      ******************************************************************11290000
                                                                        
       5000-UPDATE.                                                     
                                                                        
           MOVE '5000' TO ACTIVE-PARAGRAPH.                             
                                                                        
           PERFORM 5010-JRNL-TRAN-HEAD          THRU 5010-EXIT.         
           MOVE MH-TRANS-HIST-SEQ-NO                                    
              TO MI-TRANS-HIST-SEQ-NO.                                  
           PERFORM 5030-JRNL-ADDRESS-DETAILS    THRU 5030-EXIT.         
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************11408000
      * 5010-JRNL-TRAN-HEAD                                            *11409000
      *                                                                *11410000
      *     CALLS 7000-SELECT-CUR-TIME-STATS                           *11420000
      *           7040-SELECT-RESP-AREA-ID                             *11451000
      *                                                                *11440000
      *     CALLED FROM 5000-UPDATE                                    *11450000
      *                                                                *11460000
      *     JOURNALS THE MAINTENANCE TRANSACTION HISTORY HEADER.       *11470000
      ******************************************************************11480000
                                                                        
       5010-JRNL-TRAN-HEAD.                                             
                                                                        
           MOVE '5010' TO ACTIVE-PARAGRAPH.                             
                                                                        
           PERFORM 7000-SELECT-CUR-TIME-STATS   THRU 7000-EXIT.         
           PERFORM 7040-SELECT-RESP-AREA-ID     THRU 7040-EXIT.         
                                                                        
           MOVE WS-TRANS-HIST-SEQ-NO            TO MH-TRANS-HIST-SEQ-NO.
           MOVE WS-DATE-TRANS                   TO MH-DATE-TRANS.       
           MOVE 'F'                             TO MH-CODE-TRAN-TYPE.   
           MOVE WS-RESP-AREA-ID                 TO MH-RESP-AREA-ID.     
           MOVE WS-ACCOUNT-NO-D                 TO MH-ACCOUNT-NO.       
           MOVE ZEROS                           TO MH-CUSTOMER-NO.      
           MOVE ZEROS                           TO MH-PREMISE-NO.       
           MOVE PARM-USER-ID                    TO MH-USER-ID.          
           MOVE 'PANEL086'                      TO MH-APPL-PROGRAM-ID.  
           MOVE 0                               TO MH-TRAN-COMMENT-TEXT.
                                                                        
       5010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************13670000
      * 5030-JRNL-ADDRESS-DETAILS                                      *13680000
      *                                                                *13690000
      *     CALLS 8000-UPDATE-TBADRFRE                                 *13700000
      *           6530-LOAD-MNT-TRANS-HIST                             *13720000
      *                                                                *13751000
      *     CALLED FROM 5000-UPDATE                                    *13740000
      *                                                                *13750000
      *     JOURNALS THE MAINTENANCE TRANSACTION DETAILS               *13760000
      ******************************************************************13770000
                                                                        
       5030-JRNL-ADDRESS-DETAILS.                                       
                                                                        
           MOVE '5030' TO ACTIVE-PARAGRAPH.                             
                                                                        
           IF PARM-INTRNTNL-CITY NOT = DZ-INTRNTNL-CITY                 
              MOVE SPACES          TO MI-TABLE-ID                       
              MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO                   
              MOVE 'INTRNTNL CITY' TO MI-COLUMN-DESC                    
              MOVE +40             TO MI-CHG-COLUMN-VALUE-LEN           
              MOVE PARM-INTRNTNL-CITY                                   
                TO MI-CHG-COLUMN-VALUE-TEXT                             
              IF DZ-INTRNTNL-CITY > SPACES                              
                 MOVE +40           TO MI-PRV-COLUMN-VALUE-LEN          
                 MOVE DZ-INTRNTNL-CITY                                  
                       TO MI-PRV-COLUMN-VALUE-TEXT                      
              ELSE                                                      
                 MOVE +5            TO MI-PRV-COLUMN-VALUE-LEN          
                 MOVE '*NEW*'       TO MI-PRV-COLUMN-VALUE-TEXT         
              END-IF                                                    
                 PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
                 ADD 1                 TO WS-TRAN-APPL-NO               
           END-IF.                                                      
                                                                        
           IF PARM-INTRNTNL-PROVINCE NOT = DZ-INTRNTNL-PROVINCE         
              MOVE SPACES          TO MI-TABLE-ID                       
              MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO                   
              MOVE 'INTRNTNL PROV' TO MI-COLUMN-DESC                    
              MOVE +10             TO MI-CHG-COLUMN-VALUE-LEN           
              MOVE PARM-INTRNTNL-PROVINCE                               
                TO MI-CHG-COLUMN-VALUE-TEXT                             
              IF DZ-INTRNTNL-PROVINCE > SPACES                          
                 MOVE +10           TO MI-PRV-COLUMN-VALUE-LEN          
                 MOVE DZ-INTRNTNL-PROVINCE                              
                       TO MI-PRV-COLUMN-VALUE-TEXT                      
              ELSE                                                      
                 MOVE +5            TO MI-PRV-COLUMN-VALUE-LEN          
                 MOVE '*NEW*'       TO MI-PRV-COLUMN-VALUE-TEXT         
              END-IF                                                    
                 PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
                 ADD 1                 TO WS-TRAN-APPL-NO               
           END-IF.                                                      
                                                                        
           IF PARM-INTRNTNL-POST-CODE NOT = DZ-INTRNTNL-POST-CODE       
              MOVE SPACES          TO MI-TABLE-ID                       
              MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO                   
              MOVE 'INTRNTNL POST CODE' TO MI-COLUMN-DESC               
              MOVE +25             TO MI-CHG-COLUMN-VALUE-LEN           
              MOVE PARM-INTRNTNL-POST-CODE                              
                TO MI-CHG-COLUMN-VALUE-TEXT                             
              IF DZ-INTRNTNL-POST-CODE > SPACES                         
                 MOVE +25           TO MI-PRV-COLUMN-VALUE-LEN          
                 MOVE DZ-INTRNTNL-POST-CODE                             
                       TO MI-PRV-COLUMN-VALUE-TEXT                      
              ELSE                                                      
                 MOVE +5            TO MI-PRV-COLUMN-VALUE-LEN          
                 MOVE '*NEW*'       TO MI-PRV-COLUMN-VALUE-TEXT         
              END-IF                                                    
                 PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
                 ADD 1                 TO WS-TRAN-APPL-NO               
           END-IF.                                                      
                                                                        
           PERFORM 8000-UPDATE-TBADRFRE THRU 8000-EXIT.                 
                                                                        
       5030-EXIT.                                                       
           EXIT.                                                        
                                                                        
           COPY CPD00004.                                                       
                                                                        
      ******************************************************************22989309
      *  CHECK DIGITS COPYBOOK.                                        *22989409
      ******************************************************************22989509
                                                                        
           EXEC SQL                                                     22989709
              INCLUDE CPD00071                                          22989809
           END-EXEC.                                                    22989909
                                                                        
HPCCDM*EJECT                                                            22990909
                                                                        
      ******************************************************************22991109
      *  JOURNALING COPYBOOK.                                          *22991209
      ******************************************************************22991309
                                                                        
           EXEC SQL                                                     22991509
              INCLUDE CPD00067                                          22991609
           END-EXEC.                                                    22991709
                                                                        
HPCCDM*EJECT                                                            22991909
                                                                        
      ******************************************************************22995100
      * 7000-SELECT-CUR-TIME-STATS                                     *25100000
      *                                                                *23010000
      *     CALLS 9000-SEND-ERROR-RESULT                               *23020000
      *           9900-SQL-ERROR-ROUTINE                               *23051000
      *                                                                *23040000
      *     CALLED FROM 5020-JRNL-TRAN-HEAD.                           *23050000
      *                                                                *23060000
      *     SELECTS FROM TABLE CSS_MODEL_SQL.                          *23070000
      ******************************************************************23080000
                                                                        
       7000-SELECT-CUR-TIME-STATS.                                      
                                                                        
           MOVE '7000' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-TRANS-HIST-SEQ-NO                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     23140000
MFA-TR*       VALUES CURRENT TIMESTAMP                                          
MFA-TR*         INTO :WS-TRANS-HIST-SEQ-NO                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-DATE-TRANS                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     23140000
MFA-TR*       VALUES CURRENT DATE                                               
MFA-TR*         INTO :WS-DATE-TRANS                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
              MOVE 'SELECT'                     TO ABEND-FUNCTION       
              MOVE SPACES                       TO ABEND-SQL-PREDICATES 
                                                   ABEND-TABLES         
              MOVE 'VALUES'                     TO TABLE-1              
              MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-1      
              MOVE PARM-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1    
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************23350000
      * 7040-SELECT-RESP-AREA-ID                                       *23360000
      *                                                                *23370000
      *     CALLS 9000-SEND-ERROR-RESULT                               *23380000
      *           9900-SQL-ERROR-ROUTINE                               *23390000
      *                                                                *23400000
      *     CALLED FROM 5020-JRNL-TRAN-HEAD.                           *23410000
      *                                                                *23420000
      *     SELECTS FROM TABLE CSS_USER_PROFILE.                       *23451000
      ******************************************************************23440000
                                                                        
       7040-SELECT-RESP-AREA-ID.                                        
                                                                        
           MOVE '7040' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              SELECT  RESP_AREA_ID                                      
              INTO    :WS-RESP-AREA-ID                                  
              FROM    CSS_USER_PROFILE WITH(READUNCOMMITTED)                    
              WHERE   USER_ID                   = :PARM-USER-ID         
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     23500000
MFA-TR*       SELECT  RESP_AREA_ID                                      23510000
MFA-TR*       INTO    :WS-RESP-AREA-ID                                  23520000
MFA-TR*       FROM    CSS_USER_PROFILE                                  23551000
MFA-TR*       WHERE   USER_ID                   = :PARM-USER-ID         23540000
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    23550000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
              MOVE 'SELECT'                     TO ABEND-FUNCTION       
              MOVE SPACES                       TO ABEND-SQL-PREDICATES 
                                                   ABEND-TABLES         
              MOVE 'CSS_USER_PROFILE'           TO TABLE-1              
              MOVE 'USER_ID'                    TO TABLE-ELEMENT-1      
              MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-2      
              MOVE PARM-USER-ID                 TO HOSTVAR-ELEMENT-1    
              MOVE PARM-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2    
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7040-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************28551000
      * 7100-SELECT-ADDR-FREEFORM                                      *28540000
      *                                                                *28550000
      *     CALLS 9000-SEND-ERROR-RESULT                               *28560000
      *           9900-SQL-ERROR-ROUTINE                               *28570000
      *                                                                *28580000
      *     CALLED FROM 2300-FIND-OLD-VALUES                           *28590000
      *                                                                *28600000
      *     SELECTS FROM TABLE CSS_ADDR_FREEFORM.                      *28610000
      ******************************************************************28620000
                                                                        
       7100-SELECT-ADDR-FREEFORM.                                       
                                                                        
           MOVE '7100' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              SELECT  'Y',                                              
                      INTRNTNL_CITY,                                    
                      INTRNTNL_PROVINCE,                                
                      INTRNTNL_POST_CODE                                
              INTO    :ADDR-FREE-EXISTS-FLAG,                           
                      :DZ-INTRNTNL-CITY,                                
                      :DZ-INTRNTNL-PROVINCE,                            
                      :DZ-INTRNTNL-POST-CODE                            
              FROM    CSS_ADDR_FREEFORM WITH(READUNCOMMITTED)                   
              WHERE   ADDRESS_ID = :WS-ADDRESS-ID-I                     
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     28680000
MFA-TR*       SELECT  'Y',                                              28690000
MFA-TR*               INTRNTNL_CITY,                                    28700000
MFA-TR*               INTRNTNL_PROVINCE,                                28710000
MFA-TR*               INTRNTNL_POST_CODE                                28720000
MFA-TR*       INTO    :ADDR-FREE-EXISTS-FLAG,                           28750000
MFA-TR*               :DZ-INTRNTNL-CITY,                                28760000
MFA-TR*               :DZ-INTRNTNL-PROVINCE,                            28770000
MFA-TR*               :DZ-INTRNTNL-POST-CODE                            28780000
MFA-TR*       FROM    CSS_ADDR_FREEFORM                                 28810000
MFA-TR*       WHERE   ADDRESS_ID = :WS-ADDRESS-ID-I                     28820000
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    28851000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
              MOVE 'SELECT'                     TO ABEND-FUNCTION       
              MOVE SPACES                       TO ABEND-SQL-PREDICATES 
                                                   ABEND-TABLES         
              MOVE 'CSS_ADDR_FREEFORM'          TO TABLE-1              
              MOVE 'ADDRESS_ID'                 TO TABLE-ELEMENT-1      
              MOVE WS-ADDRESS-ID-I              TO HOSTVAR-ELEMENT-1    
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************34080000
      * 8000-UPDATE-TBADRFRE                                           *34090000
      *                                                                *34100000
      *     CALLS 9000-SEND-ERROR-RESULT                               *34110000
      *           9900-SQL-ERROR-ROUTINE                               *34120000
      *                                                                *34151000
      *     CALLED FROM 5400-PROCESS-ADDR-FREE                         *34140000
      *                                                                *34150000
      *     UPDATE TABLE CSS_ADDR_FREEFORM.                            *34160000
      ******************************************************************34170000
                                                                        
       8000-UPDATE-TBADRFRE.                                            
                                                                        
           MOVE '8000' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              UPDATE  CSS_ADDR_FREEFORM                                 
              SET     INTRNTNL_CITY         = :PARM-INTRNTNL-CITY,      
                      INTRNTNL_PROVINCE     = :PARM-INTRNTNL-PROVINCE,  
                      INTRNTNL_POST_CODE    = :PARM-INTRNTNL-POST-CODE  
              WHERE   ADDRESS_ID            = :WS-ADDRESS-ID-I          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'UPDATE'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_ADDR_FREEFORM'        TO TABLE-1                
              MOVE 'ADDRESS_ID'               TO TABLE-ELEMENT-1        
              MOVE WS-ADDRESS-ID-I            TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************40751000
      *       END PROGRAM COPYLIB                                      *40740000
      ******************************************************************40750000
      * INCLUDED COPY BOOK HAVING COMMIT LOGIC  BEFORE STOP RUN.        40770000
           EXEC SQL                                                     16360000
                INCLUDE CPD00331                                        16360000
           END-EXEC.                                                    16360000
      ******************************************************************40780000
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                     40790000
      ******************************************************************40800000
           EXEC SQL                                                             
                INCLUDE CPDSP300                                                
           END-EXEC.                                                            
