       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04629.                                         
COB303 DATE-WRITTEN. APRIL 25, 2013.                                     
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************      00
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      ******************************************************************00160000
      *                 P R O G R A M  S U M M A R Y                   *00170000
      *                                                                *00180000
      *  THIS PROGRAM INSERTS, OR UPDATES THE                          *00220000
      *  CSS_TEMPERATURE TABLE BASED ON THE ACTION IN THE FIELD        *00230000
      *  PARM-ACTION.                                                  *00240000
      *                                                                *00250000
      ******************************************************************00260000
      *                                                                *00270000
      *                     PROGRAM MODIFICATION LOG                   *00280000
      *                                                                *00290000
      *    DATE    INITIALS   COMMENTS                                 *00300000
      *  --------  --------   ---------------------------------------  *00310000
      *  04/25/13  SV95326    NEW PROGRAM.                             *00320000
ACT130*  04/22/16  MS7M727    TO REMOVE CSS_NORM_DGR_DAY TABLE AND     *00320000
      *            A05460     COMMENTED CODE                           *00320000
ACT326*  11/04/16  SM93554    REPLACED NORM DGR DAY TABLE WITH CSS_    *00320000
      *            A05460     TEMPERATUE TABLE TO GET NORM HEAT DEGREE *00320000
ACT326*  11/09/16  SM93554    ADDED LOGIC TO GET INPUT DATE - 1YEAR    *00328000
ACT002*  09/01/17  TP7R341    ADD TABLE CSS_NRML_DEGRE_DAY TO GET      *00328000
ACT002*   A05744              NRML DEGRE DAYS VALUE.                   *00328000
      ******************************************************************00328000
      *                                                                *00329000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00330000
      *                                                                *00340000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00350000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00360000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00370000
      *  3000 - 4999  NOT USED                                         *00380000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00390000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00400000
      *  7000 - 7999  INPUT MODULES                                    *00410000
      *  8000 - 8999  OUTPUT MODULES                                   *00420000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00430000
      *                                                                *00440000
      ******************************************************************00450000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04629'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
          'WORKING STORAGE FOR CSR04629 STARTS HERE'.                   
                                                                        
                                                                        
      ******************************************************************00550000
      *    DB2 INCLUDES                                                *00560000
      ******************************************************************00570000
                                                                        
           EXEC SQL                                                     00590000
              INCLUDE SQLCA                                             00600000
           END-EXEC.                                                    00610000
                                                                        
           EXEC SQL                                                     00630000
              INCLUDE TBTEMPIN                                          00640000
           END-EXEC.                                                    00650000
                                                                        
           EXEC SQL                                                     00670000
              INCLUDE TBDELQ                                                  00
           END-EXEC.                                                          00
                                                                        
           EXEC SQL                                                             
               INCLUDE TBHLDAY                                                  
           END-EXEC.                                                            
                                                                        
ACT002     EXEC SQL                                                             
ACT002         INCLUDE TBNRMDEG                                                 
ACT002     END-EXEC.                                                            
                                                                        
                                                                        
      ******************************************************************00720000
      *    COBOL WORKING STORAGE COPY BOOKS                            *00730000
      ******************************************************************00740000
                                                                        
           EXEC SQL                                                     00760000
              INCLUDE CWS00013                                          00770000
           END-EXEC.                                                    00780000
                                                                        
      ******************************************************************00800000
      *    COBOL WORKING STORAGE COPY BOOKS                            *00810000
      ******************************************************************00820000
                                                                        
           COPY CCA00001.                                               00860000
           COPY CWS00027.                                               00880000
           COPY CWS00303.                                               00890000
                                                                        
      ******************************************************************00910000
      *    WORK AREAS                                                  *00920000
      ******************************************************************00930000
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
           05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                  
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-L                  PIC S9(9) COMP.                  
           05  PARM-ACTION-IND         PIC X(01) VALUE SPACES.          
           05  PARM-COMPANY-NO         PIC X(2)  VALUE SPACES.          
           05  PARM-TEMP-DT            PIC X(10) VALUE SPACES.          
           05  PARM-CHAS-HIGH          PIC S9(04) COMP VALUE 0.         
           05  PARM-AIKEN-HIGH         PIC S9(04) COMP VALUE 0.         
           05  PARM-COLA-HIGH          PIC S9(04) COMP VALUE 0.         
           05  PARM-CHAS-LOW           PIC S9(04) COMP VALUE 0.         
           05  PARM-AIKEN-LOW          PIC S9(04) COMP VALUE 0.         
           05  PARM-COLA-LOW           PIC S9(04) COMP VALUE 0.         
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
           05  WS-DATE                 PIC X(10) VALUE SPACES.          
           05  WS-DATE-MINUS-ONE-DAY   PIC X(10) VALUE SPACES.          
ACT326     05  WS-DATE-MINUS-ONE-YEAR  PIC X(10) VALUE SPACES.          
           05  WS-DATE-MINUS-ONE-YR    PIC X(10) VALUE SPACES.          
           05  WS-SEB-DATABASE         PIC X(01) VALUE 'N'.             
       01  WS-TALLY                    PIC S9(3) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR04629'.      
           05  WS-COMPANY-NO           PIC X(2)  VALUE ZERO.            
           05  WS-PARM-ACTION-IND      PIC X(1)  VALUE SPACE.           
           05  WS-COLA-AVG             PIC S9(3)  VALUE ZERO.           
           05  WS-CHAS-AVG             PIC S9(3)  VALUE ZERO.           
           05  WS-AIKEN-AVG            PIC S9(3)  VALUE ZERO.           
           05  WS-COLA-TOTAL-AVG       PIC S9(4)V99 VALUE ZERO.         
           05  WS-CHAS-TOTAL-AVG       PIC S9(4)V99 VALUE ZERO.         
           05  WS-COLA-TOT-AVG-R       PIC S9(3)V   VALUE ZERO.         
           05  WS-CHAS-TOT-AVG-R       PIC S9(3)V   VALUE ZERO.         
           05  WS-AIKEN-TOTAL-AVG      PIC S9(4)V99 VALUE ZERO.         
           05  WS-COLA-TOTAL-AVG-0DEC  PIC S9(4)    VALUE ZERO.         
           05  WS-CHAS-TOTAL-AVG-0DEC  PIC S9(4)    VALUE ZERO.         
           05  WS-AIKEN-TOTAL-AVG-0DEC PIC S9(4)    VALUE ZERO.         
           05  WS-TOTAL-AVG            PIC S9(4)V99 VALUE ZERO.         
           05  WS-FACTOR-VALUE         PIC S9(7)V9(4) VALUE ZERO.       
           05  WS-FCTR-ASHEVILLE       PIC S9(7)V9(4) VALUE ZERO.       
           05  WS-FCTR-CHARLOTTE       PIC S9(7)V9(4) VALUE ZERO.       
           05  WS-FCTR-RALEIGH         PIC S9(7)V9(4) VALUE ZERO.       
           05  WS-ACT-ACCUM-DEGREE     PIC S9(7)V99 VALUE ZERO.         
           05  WS-ACT-HEAT-DEGREE      PIC S9(4)V99 VALUE ZERO.         
           05  WS-ACT-HEAT-DEGREE-1DEC PIC S9(4)V9  VALUE ZERO.         
           05  WS-ACT-HEAT-DEGREE-0DEC PIC S9(4)    VALUE ZERO.         
           05  WS-NORM-ACCUM-DEGREE    PIC S9(7)V99 VALUE ZERO.         
           05  WS-NORM-HEAT-DEGREE     PIC S9(4)V99 VALUE ZERO.         
           05  WS-DATE-RESET.                                           
               10  WS-RESET-YEAR           PIC X(04) VALUE SPACES.      
               10  FILLER                  PIC X(01) VALUE '-'.         
               10  WS-RESET-MONTH          PIC X(02) VALUE SPACES.      
               10  FILLER                  PIC X(01) VALUE '-'.         
               10  WS-RESET-DAY            PIC X(02) VALUE SPACES.      
           05  WS-DATE-NORM.                                            
               10  WS-MONTH-NORM           PIC X(02) VALUE SPACES.      
               10  WS-DAY-NORM             PIC X(02) VALUE SPACES.      
ACT002     05  WS-DATE-NORM-NUM            PIC 9(04) VALUE ZEROS.       
           05  WS-DATE-0228                PIC X(04) VALUE '0228'.      
           05  WS-DATE-0229                PIC X(04) VALUE '0229'.      
           05  WS-DATE-0801                PIC X(04) VALUE '0801'.      
           05  WS-DATE-0901                PIC X(04) VALUE '0901'.      
           05  WS-DATE-YEAR                PIC X(04) VALUE SPACES.      
           05  WS-DATE-YEAR-RD                                          
               REDEFINES WS-DATE-YEAR      PIC 9(04).                   
           05  WS-YEAR-QUOTIENT            PIC S9(05) COMP-3 VALUE 0.   
           05  WS-LEAP-YEAR-CHECK-4        PIC S9(05) COMP-3 VALUE 0.   
           05  WS-LEAP-YEAR-CHECK-400      PIC S9(05) COMP-3 VALUE 0.   
           05  WS-LEAP-YEAR-CHECK-100      PIC S9(05) COMP-3 VALUE 0.   
COB305     05 WS-CHAS-NORM        PIC S9(03)V USAGE COMP-3 VALUE 0.    
COB305     05 WS-AIKEN-NORM        PIC S9(03)V USAGE COMP-3 VALUE 0.    
COB305     05 WS-COLA-NORM        PIC S9(03)V USAGE COMP-3 VALUE 0.    
           05  WS-DT-MINUS-ONE-YR          PIC X(10) VALUE ZERO.        
                                                                        
       01  WS-MISC-PARM.                                                
           05  WS-TEMP-DT              PIC X(10)  VALUE SPACES.         
           05  WS-CHAS-HIGH            PIC S9(04) COMP VALUE 0.         
           05  WS-AIKEN-HIGH           PIC S9(04) COMP VALUE 0.         
           05  WS-COLA-HIGH            PIC S9(04) COMP VALUE 0.         
           05  WS-CHAS-LOW             PIC S9(04) COMP VALUE 0.         
           05  WS-AIKEN-LOW            PIC S9(04) COMP VALUE 0.         
           05  WS-COLA-LOW             PIC S9(04) COMP VALUE 0.         
                                                                        
       01 WS-PREV-BUSINESS-DAY-MISC.                                    
          05 WS-PREV-BUSINESS-DAY           PIC X(10).                  
          05 WS-DAY-OF-WEEK                 PIC S9(04) COMP.            
          05 WS-SUNDAY                      PIC S9(04) COMP VALUE +1.   
          05 WS-SATURDAY                    PIC S9(04) COMP VALUE +7.   
      *                                                                         
       01 WS-NEXT-BUSINESS-DAY-SWITCHES.                                
          05 WS-HOLIDAY-EXISTS              PIC  X(01).                 
             88 HOLIDAY-EXISTS-NO                       VALUE 'N'.      
             88 HOLIDAY-EXISTS-YES                      VALUE 'Y'.      
          05 WS-PREV-BUS-DAY-FLAG           PIC  X(01)  VALUE 'N'.      
             88 PREV-BUS-DAY-FOUND                      VALUE 'Y'.      
          05 WS-NO-TEMP-ROWS                PIC  X(01)  VALUE 'N'.      
             88 NO-TEMP-ROWS                            VALUE 'Y'.      
       01  WS-INVALID-DATE                  PIC S9(9) VALUE -803 COMP.  
       01  WS-FLAG-VALUES.                                              
           05  WS-YES                  PIC X(01) VALUE 'Y'.             
           05  WS-NO                   PIC X(01) VALUE 'N'.             
           05  WS-ACTIVE-CODE          PIC X(01) VALUE 'A'.             
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE           PIC S9(9) COMP VALUE 0.          
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
           05  WS-LEAP-YEAR-SW         PIC X(01) VALUE 'N'.             
               88 NOT-LEAP-YEAR                  VALUE 'N'.             
               88 LEAP-YEAR                      VALUE 'Y'.             
                                                                        
                                                                        
HPCCDM*EJECT                                                            01900000
           EXEC SQL                                                     00000010
               INCLUDE CWSX0010                                         00000020
           END-EXEC.                                                    00000030
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
           10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
                                                                        
                                                                        
      ******************************************************************01820000
      *    CURSOR DECLARATIONS                                         *01830000
      ******************************************************************01840000
           EXEC SQL DECLARE TEMP-CURS CURSOR FOR                        
              SELECT TEMP_DT                                            
                    ,CHAS_HIGH                                          
                    ,AIKEN_HIGH                                         
                    ,COLA_HIGH                                          
                    ,CHAS_NORM                                          
                    ,AIKEN_NORM                                         
                    ,COLA_NORM                                          
                    ,CHAS_LOW                                           
                    ,AIKEN_LOW                                          
                    ,COLA_LOW                                           
                FROM CSS_TEMPERATURE WITH(READUNCOMMITTED)                      
               WHERE TEMP_DT > IIF(TRY_CONVERT(DATE, :WS-TEMP-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-TEMP-DT) <> 0) OR (LEN(
                                                            :WS-TEMP-DT
              ) <> 10), CIS.CHAR2DATE(:WS-TEMP-DT), CONVERT(DATE, 
                                                            :WS-TEMP-DT
              ) )                              
                 AND COMPANY_NO = :WS-COMPANY-NO                        
                 FOR READ ONLY                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL DECLARE TEMP-CURS CURSOR FOR                        01850000
MFA-TR*       SELECT TEMP_DT                                            01851000
MFA-TR*             ,CHAS_HIGH                                          01860000
MFA-TR*             ,AIKEN_HIGH                                         01870000
MFA-TR*             ,COLA_HIGH                                          01880000
MFA-TR*             ,CHAS_NORM                                          01890000
MFA-TR*             ,AIKEN_NORM                                         01900000
MFA-TR*             ,COLA_NORM                                          01910000
MFA-TR*             ,CHAS_LOW                                           01920000
MFA-TR*             ,AIKEN_LOW                                          01930000
MFA-TR*             ,COLA_LOW                                           01940000
MFA-TR*         FROM CSS_TEMPERATURE                                    01981000
MFA-TR*        WHERE TEMP_DT > :WS-TEMP-DT                              01982000
MFA-TR*          AND COMPANY_NO = :WS-COMPANY-NO                        01984001
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*        QUERYNO 7010                                                     
MFA-TR*    END-EXEC.                                                    01990000
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-ACTION-IND          PIC X(01)                .          
       01  LINK-COMPANY-NO          PIC X(2)                 .          
       01  LINK-TEMP-DT             PIC X(10)                .          
       01  LINK-COLA-HIGH           PIC S9(04) COMP VALUE 0  .          
       01  LINK-COLA-LOW            PIC S9(04) COMP VALUE 0  .          
       01  LINK-CHAS-HIGH           PIC S9(04) COMP VALUE 0  .          
       01  LINK-CHAS-LOW            PIC S9(04) COMP VALUE 0  .          
       01  LINK-AIKEN-HIGH          PIC S9(04) COMP VALUE 0  .          
       01  LINK-AIKEN-LOW           PIC S9(04) COMP VALUE 0  .          
                                                                        
       PROCEDURE DIVISION USING                                         
                LINK-ACTION-IND                                         
               ,LINK-COMPANY-NO                                         
               ,LINK-TEMP-DT                                            
               ,LINK-COLA-HIGH                                          
               ,LINK-COLA-LOW                                           
               ,LINK-CHAS-HIGH                                          
               ,LINK-CHAS-LOW                                           
               ,LINK-AIKEN-HIGH                                         
               ,LINK-AIKEN-LOW                                          
               .                                                        
           EXEC SQL                                                     
               WHENEVER SQLWARNING                                      
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLERROR                                        
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER NOT FOUND                                       
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
      ******************************************************************01930000
      * 0000-MAINLINE                                                  *01940000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *01950000
      ******************************************************************01960000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02080000
      * 0100-INITIALIZE                                                *02090000
      *                                                                *02100000
      *     1. RESET DB2 ERROR HANDLERS                                *02110000
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *02120000
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *02130000
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*02140000
      *                                                                *02150000
      ******************************************************************02160000
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
                                                                        
           EXEC SQL                                                     
             DECLARE C1 CURSOR  FOR                          
             SELECT                                                     
              :S-RETURN-CODE              AS    RETURN_CODE             
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*      SELECT                                                             
MFA-TR*       :S-RETURN-CODE              AS    RETURN_CODE                     
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
           MOVE LINK-ACTION-IND           TO PARM-ACTION-IND          . 
           MOVE LINK-COMPANY-NO           TO PARM-COMPANY-NO          . 
           MOVE LINK-TEMP-DT              TO PARM-TEMP-DT             . 
           MOVE LINK-COLA-HIGH            TO PARM-COLA-HIGH           . 
           MOVE LINK-COLA-LOW             TO PARM-COLA-LOW            . 
           MOVE LINK-CHAS-HIGH            TO PARM-CHAS-HIGH           . 
           MOVE LINK-CHAS-LOW             TO PARM-CHAS-LOW            . 
           MOVE LINK-AIKEN-HIGH           TO PARM-AIKEN-HIGH          . 
           MOVE LINK-AIKEN-LOW            TO PARM-AIKEN-LOW           . 
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02430000
      * 1000-PROCESS-INPUT                                             *02440000
      *                                                                *02450000
      *     1. RECEIVE PARMS.                                          *02460000
      *                                                                *02470000
      ******************************************************************02480000
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-ACTION-IND           TO WS-PARM-ACTION-IND.        
           MOVE PARM-TEMP-DT              TO WS-TEMP-DT                 
                                             WS-DATE.                   
           MOVE PARM-COMPANY-NO           TO WS-COMPANY-NO.             
           MOVE PARM-COLA-HIGH            TO WS-COLA-HIGH.              
           MOVE PARM-COLA-LOW             TO WS-COLA-LOW.               
           MOVE PARM-CHAS-HIGH            TO WS-CHAS-HIGH.              
           MOVE PARM-CHAS-LOW             TO WS-CHAS-LOW.               
           MOVE PARM-AIKEN-HIGH           TO WS-AIKEN-HIGH.             
           MOVE PARM-AIKEN-LOW            TO WS-AIKEN-LOW.              
                                                                        
           IF WS-COMPANY-NO = '26'                                      
               MOVE WS-COMPANY-NO            TO C8-COMPANY-NO           
               MOVE 'ASHEVILLE'              TO C8-DELINQ-CD            
               PERFORM 7103-GET-WEATHER-DIV  THRU  7103-EXIT            
               MOVE WS-FACTOR-VALUE          TO WS-FCTR-ASHEVILLE       
                                                                        
               MOVE WS-COMPANY-NO            TO C8-COMPANY-NO           
               MOVE 'CHARLOTTE'              TO C8-DELINQ-CD            
               PERFORM 7103-GET-WEATHER-DIV  THRU  7103-EXIT            
               MOVE WS-FACTOR-VALUE          TO WS-FCTR-CHARLOTTE       
                                                                        
               MOVE WS-COMPANY-NO            TO C8-COMPANY-NO           
               MOVE 'RALEIGH'                TO C8-DELINQ-CD            
               PERFORM 7103-GET-WEATHER-DIV  THRU  7103-EXIT            
               MOVE WS-FACTOR-VALUE          TO WS-FCTR-RALEIGH         
           END-IF                                                       
                                                                        
           PERFORM 7000-DETERMINE-REGION THRU 7000-EXIT.                
                                                                        
           IF C8-DELINQ-VALUE = 2                                       
              MOVE 'Y'        TO WS-SEB-DATABASE                        
           ELSE                                                         
              MOVE 'N'        TO WS-SEB-DATABASE                        
           END-IF.                                                      
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02430000
      * 1010-CALCULATE-PARM                                            *02440000
      *                                                                *02450000
      *  1. CALCULATES AVERAGE TEMPERATURE AND SET 0 WHEN > 65         *02460000
      *  2. CALCULATES HEAT & ACCUM DEGREE FOR ACTUAL AND NORMAL       *02470000
      *                                                                *02470000
      ******************************************************************02480000
                                                                        
       1010-CALCULATE-PARM.                                             
                                                                        
      ******************************************************************        
      *  FIELDS USED FOR PSNC DATA:                                    *        
      *    RALEIGH     USES   COLUMBIA OR COLA FIELDS                  *        
      *    ASHEVILLE   USES   AIKEN FIELDS                             *        
      *    CHARLOTTE   USES   CHARLESTON OR CHAR FIELDS                *        
      ******************************************************************        
                                                                        
           IF WS-COMPANY-NO = '26'                                      
               COMPUTE WS-TOTAL-AVG ROUNDED =                           
                        (WS-COLA-HIGH + WS-COLA-LOW +                   
                         WS-CHAS-HIGH + WS-CHAS-LOW +                   
                         WS-AIKEN-HIGH + WS-AIKEN-LOW) / 6              
               COMPUTE WS-COLA-TOTAL-AVG-0DEC ROUNDED =                 
                        (WS-COLA-HIGH + WS-COLA-LOW) / 2                
               COMPUTE WS-CHAS-TOTAL-AVG-0DEC ROUNDED =                 
                        (WS-CHAS-HIGH + WS-CHAS-LOW) / 2                
               COMPUTE WS-AIKEN-TOTAL-AVG-0DEC ROUNDED =                
                        (WS-AIKEN-HIGH + WS-AIKEN-LOW) / 2              
                                                                        
               MOVE WS-COLA-TOTAL-AVG-0DEC   TO WS-COLA-TOTAL-AVG       
               MOVE WS-CHAS-TOTAL-AVG-0DEC   TO WS-CHAS-TOTAL-AVG       
               MOVE WS-AIKEN-TOTAL-AVG-0DEC  TO WS-AIKEN-TOTAL-AVG      
                                                                        
               IF WS-COLA-TOTAL-AVG > 65                                
                   MOVE ZERO TO WS-COLA-TOTAL-AVG                       
               ELSE                                                     
                   COMPUTE WS-COLA-TOTAL-AVG ROUNDED = 65 -             
                       WS-COLA-TOTAL-AVG                                
               END-IF                                                   
                                                                        
               IF WS-CHAS-TOTAL-AVG > 65                                
                   MOVE ZERO TO WS-CHAS-TOTAL-AVG                       
               ELSE                                                     
                   COMPUTE WS-CHAS-TOTAL-AVG ROUNDED = 65 -             
                       WS-CHAS-TOTAL-AVG                                
               END-IF                                                   
                                                                        
               IF WS-AIKEN-TOTAL-AVG > 65                               
                   MOVE ZERO TO WS-AIKEN-TOTAL-AVG                      
               ELSE                                                     
                   COMPUTE WS-AIKEN-TOTAL-AVG ROUNDED = 65 -            
                       WS-AIKEN-TOTAL-AVG                               
               END-IF                                                   
                                                                        
               COMPUTE WS-ACT-HEAT-DEGREE-0DEC ROUNDED =                
                       ((WS-FCTR-RALEIGH   * WS-COLA-TOTAL-AVG) +       
                        (WS-FCTR-CHARLOTTE * WS-CHAS-TOTAL-AVG) +       
                        (WS-FCTR-ASHEVILLE * WS-AIKEN-TOTAL-AVG))       
                                                                        
               MOVE WS-ACT-HEAT-DEGREE-0DEC TO WS-ACT-HEAT-DEGREE       
           ELSE                                                         
               COMPUTE WS-COLA-TOTAL-AVG ROUNDED =                      
                 (WS-COLA-HIGH + WS-COLA-LOW) / 2                       
               COMPUTE WS-CHAS-TOTAL-AVG ROUNDED =                      
                 (WS-CHAS-HIGH + WS-CHAS-LOW) / 2                       
                                                                        
               IF WS-COLA-TOTAL-AVG > 65                                
                   MOVE ZERO TO WS-COLA-TOTAL-AVG                       
               ELSE                                                     
                   COMPUTE WS-COLA-TOTAL-AVG ROUNDED = 65 -             
                       WS-COLA-TOTAL-AVG                                
               END-IF                                                   
                                                                        
               IF WS-CHAS-TOTAL-AVG > 65                                
                   MOVE ZERO TO WS-CHAS-TOTAL-AVG                       
               ELSE                                                     
                   COMPUTE WS-CHAS-TOTAL-AVG ROUNDED = 65               
                       - WS-CHAS-TOTAL-AVG                              
               END-IF                                                   
                                                                        
               COMPUTE WS-ACT-HEAT-DEGREE =                             
                       (WS-COLA-TOTAL-AVG + WS-CHAS-TOTAL-AVG) / 2      
                                                                        
               IF WS-SEB-DATABASE = 'N'                                 
                                                                        
                  COMPUTE WS-COLA-TOT-AVG-R ROUNDED =                   
                           (WS-COLA-HIGH + WS-COLA-LOW) / 2             
                  COMPUTE WS-CHAS-TOT-AVG-R ROUNDED =                   
                           (WS-CHAS-HIGH + WS-CHAS-LOW) / 2             
                                                                        
                  IF WS-COLA-TOT-AVG-R > 60                             
                      MOVE ZERO TO WS-COLA-TOT-AVG-R                    
                  ELSE                                                  
                      COMPUTE WS-COLA-TOT-AVG-R ROUNDED = 60 -          
                          WS-COLA-TOT-AVG-R                             
                  END-IF                                                
                                                                        
                  IF WS-CHAS-TOT-AVG-R > 60                             
                      MOVE ZERO TO WS-CHAS-TOT-AVG-R                    
                  ELSE                                                  
                      COMPUTE WS-CHAS-TOT-AVG-R ROUNDED = 60            
                          - WS-CHAS-TOT-AVG-R                           
                  END-IF                                                
                                                                        
                                                                        
                  COMPUTE WS-COLA-TOT-AVG-R ROUNDED =                   
                         (WS-COLA-HIGH + WS-COLA-LOW) / 2               
                  COMPUTE WS-CHAS-TOT-AVG-R ROUNDED =                   
                         (WS-CHAS-HIGH + WS-CHAS-LOW) / 2               
                                                                        
                  IF WS-COLA-TOT-AVG-R < 75                             
                      MOVE ZERO TO WS-COLA-TOT-AVG-R                    
                  ELSE                                                  
                      COMPUTE WS-COLA-TOT-AVG-R ROUNDED =               
                          WS-COLA-TOT-AVG-R - 75                        
                  END-IF                                                
                                                                        
                  IF WS-CHAS-TOT-AVG-R < 75                             
                      MOVE ZERO TO WS-CHAS-TOT-AVG-R                    
                  ELSE                                                  
                      COMPUTE WS-CHAS-TOT-AVG-R ROUNDED =               
                            WS-CHAS-TOT-AVG-R - 75                      
                  END-IF                                                
                                                                        
               END-IF                                                   
           END-IF.                                                      
                                                                        
                                                                        
           PERFORM 7150-SELECT-DATE-MINUS-ONE-DAY THRU 7150-EXIT.       
                                                                        
           PERFORM 7100-SELECT-YEST-ACCUM-HDD THRU 7100-EXIT.           
                                                                        
           COMPUTE WS-ACT-ACCUM-DEGREE = E8-ACT-ACCUM-DEGREE +          
                                         WS-ACT-HEAT-DEGREE.            
                                                                        
ACT002     MOVE WS-DATE(6:2)             TO WS-MONTH-NORM.              
ACT002     MOVE WS-DATE(9:2)             TO WS-DAY-NORM.                
ACT002     MOVE WS-DATE-NORM             TO WS-DATE-NORM-NUM.           
ACT002     MOVE WS-DATE-NORM-NUM         TO NT-MONTH-DAY.               
ACT002     MOVE WS-COMPANY-NO            TO NT-COMPANY-NO.              
ACT002     MOVE ZERO                     TO NT-NORMAL-DEGREE-DAYS.      
ACT326     PERFORM 7102-SELECT-NORM-HDD  THRU 7102-EXIT.                
ACT002     MOVE NT-NORMAL-DEGREE-DAYS    TO WS-NORM-HEAT-DEGREE.        
ACT002*    TODAYS WS-NORM-HEAT-DEGREE IS ADDED                                  
ACT002*    YESTERDAYS E8-NORM-HEAT-DEGREE  TO GET                               
ACT002*    TODAYS TODAYS E8-NORM-ACCUM-DEGREE                                   
ACT002     COMPUTE WS-NORM-ACCUM-DEGREE = WS-NORM-HEAT-DEGREE +         
ACT002                                    E8-NORM-ACCUM-DEGREE.         
                                                                        
       1010-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************03431600
      * 2000-PROCESS-OUTPUT.                                           *03431700
      ******************************************************************03431800
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 7200-DATE-MINUS-ONE-YR      THRU 7200-EXIT.          
           PERFORM 7250-SELECT-NORM-DETAILS    THRU 7250-EXIT.          
           IF PARM-ACTION-IND = 'U'                                     
              PERFORM 1010-CALCULATE-PARM THRU 1010-EXIT                
              PERFORM 5000-UPDATE         THRU 5000-EXIT                
              PERFORM 7010-OPEN-TEMP-CURS THRU 7010-EXIT                
              PERFORM 2200-PROCESS-FETCH  THRU 2200-EXIT                
                UNTIL NO-TEMP-ROWS                                      
              PERFORM 7030-CLOSE-TEMP-CURS THRU 7030-EXIT               
           ELSE                                                         
              PERFORM 1010-CALCULATE-PARM THRU 1010-EXIT                
              PERFORM 5000-UPDATE         THRU 5000-EXIT                
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *2000A-MOVE-RESULT.                                                       
      ******************************************************************        
       2000A-MOVE-RESULT.                                               
      *                                                                         
           MOVE RS-RETURN-CODE         TO S-RETURN-CODE.                
      *                                                                         
       2000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************03750000
      * 2200-PROCESS-FETCH                                             *03760000
      *   FETCH ALL ROWS THAT ARE GREATER THEN THE UPDATED ROW TO      *        
      *   REFLECT CHANGES ON REST OF THE DAYS.                         *        
      ******************************************************************03770000
       2200-PROCESS-FETCH.                                              
                                                                        
           INITIALIZE WS-MISC-PARM                                      
                                                                        
           PERFORM 7020-FETCH-TEMP-CURS        THRU 7020-EXIT           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                                                                        
              MOVE E8-TEMP-DT             TO WS-TEMP-DT                 
                                             WS-DATE                    
              MOVE E8-CHAS-HIGH           TO WS-CHAS-HIGH               
              MOVE E8-AIKEN-HIGH          TO WS-AIKEN-HIGH              
              MOVE E8-COLA-HIGH           TO WS-COLA-HIGH               
              MOVE E8-CHAS-NORM           TO WS-CHAS-NORM               
              MOVE E8-AIKEN-NORM          TO WS-AIKEN-NORM              
              MOVE E8-COLA-NORM           TO WS-COLA-NORM               
              MOVE E8-CHAS-LOW            TO WS-CHAS-LOW                
              MOVE E8-AIKEN-LOW           TO WS-AIKEN-LOW               
              MOVE E8-COLA-LOW            TO WS-COLA-LOW                
                                                                        
              PERFORM 1010-CALCULATE-PARM THRU 1010-EXIT                
              PERFORM 5000-UPDATE         THRU 5000-EXIT                
           END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03750000
      * 5000-UPDATE                                                    *03760000
      ******************************************************************03770000
       5000-UPDATE.                                                     
                                                                        
           IF PARM-ACTION-IND = 'I' OR 'U'                              
              MOVE WS-TEMP-DT             TO E8-TEMP-DT                 
                                             WS-DATE-RESET              
              MOVE WS-COMPANY-NO          TO E8-COMPANY-NO              
              MOVE WS-CHAS-HIGH           TO E8-CHAS-HIGH               
              MOVE WS-AIKEN-HIGH          TO E8-AIKEN-HIGH              
              MOVE WS-COLA-HIGH           TO E8-COLA-HIGH               
              MOVE WS-CHAS-NORM           TO E8-CHAS-NORM               
              MOVE WS-AIKEN-NORM          TO E8-AIKEN-NORM              
              MOVE WS-COLA-NORM           TO E8-COLA-NORM               
              MOVE WS-CHAS-LOW            TO E8-CHAS-LOW                
              MOVE WS-AIKEN-LOW           TO E8-AIKEN-LOW               
              MOVE WS-COLA-LOW            TO E8-COLA-LOW                
              IF WS-COMPANY-NO = '26'                                   
                  IF ( WS-RESET-MONTH = '08' AND WS-RESET-DAY = '01' )  
                      MOVE ZERO              TO WS-ACT-ACCUM-DEGREE     
                      COMPUTE WS-ACT-ACCUM-DEGREE =                     
                           WS-ACT-ACCUM-DEGREE + WS-ACT-HEAT-DEGREE     
                      MOVE WS-ACT-ACCUM-DEGREE  TO E8-ACT-ACCUM-DEGREE  
                  ELSE                                                  
                      MOVE WS-ACT-ACCUM-DEGREE  TO E8-ACT-ACCUM-DEGREE  
                  END-IF                                                
              ELSE                                                      
                  IF ( WS-RESET-MONTH = '09' AND WS-RESET-DAY = '01' )  
                      MOVE ZERO              TO WS-ACT-ACCUM-DEGREE     
                      COMPUTE WS-ACT-ACCUM-DEGREE =                     
                           WS-ACT-ACCUM-DEGREE + WS-ACT-HEAT-DEGREE     
                      MOVE WS-ACT-ACCUM-DEGREE  TO E8-ACT-ACCUM-DEGREE  
                                                                        
                      MOVE ZERO              TO WS-NORM-ACCUM-DEGREE    
                      COMPUTE WS-NORM-ACCUM-DEGREE =                    
                           WS-NORM-ACCUM-DEGREE + WS-NORM-HEAT-DEGREE   
                      MOVE WS-NORM-ACCUM-DEGREE TO E8-NORM-ACCUM-DEGREE 
                                                                        
                  ELSE                                                  
                    MOVE WS-ACT-ACCUM-DEGREE  TO E8-ACT-ACCUM-DEGREE    
                  END-IF                                                
              END-IF                                                    
              MOVE WS-ACT-HEAT-DEGREE     TO E8-ACT-HEAT-DEGREE         
              MOVE WS-NORM-ACCUM-DEGREE   TO E8-NORM-ACCUM-DEGREE       
ACT002        MOVE WS-NORM-HEAT-DEGREE    TO E8-NORM-HEAT-DEGREE        
                                                                        
              IF PARM-ACTION-IND = 'I'                                  
                 PERFORM 8200-INSERT-TEMP    THRU 8200-EXIT             
              ELSE                                                      
                 PERFORM 8300-UPDATE-TEMP    THRU 8300-EXIT             
              END-IF                                                    
           ELSE                                                         
                  MOVE PROGRAM-NAME    TO ABEND-PROGRAM                 
                  MOVE '5000'          TO ACTIVE-PARAGRAPH              
                  MOVE 'BAD PARM-ACTION'    TO ABEND-FUNCTION           
                  MOVE 'PROGRAMMER LOGIC'   TO TABLE-1                  
                  MOVE 'PARM-ACTION-IND'    TO TABLE-ELEMENT-1          
                  MOVE PARM-ACTION-IND      TO HOSTVAR-ELEMENT-1        
                  PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT        
           END-IF.                                                      
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE.                
           MOVE '5000'          TO ACTIVE-PARAGRAPH                     
           PERFORM 8100-SEND-RESULT      THRU 8100-EXIT.                
           PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT.               
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************03750000
      * GET THE REGION.                                                *03760000
      ******************************************************************03770000
       7000-DETERMINE-REGION.                                           
                                                                        
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE DELINQ_CD = 'DATABASE'                             
                 AND COMPANY_NO = '01'                                  
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     15040000
MFA-TR*       SELECT DELINQ_VALUE                                       15040000
MFA-TR*         INTO :C8-DELINQ-VALUE                                   15040000
MFA-TR*         FROM CSS_DELINQUENCY                                    15040000
MFA-TR*        WHERE DELINQ_CD = 'DATABASE'                             15040000
MFA-TR*          AND COMPANY_NO = '01'                                  15040000
MFA-TR*        QUERYNO 7000                                                     
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                    15040000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE '7000'                    TO ACTIVE-PARAGRAPH       
               MOVE 'SELECT'                  TO ABEND-FUNCTION         
               MOVE 'CSS_DELINQUENCY'         TO TABLE-1                
               MOVE 'DELINQ_VALUE'            TO TABLE-ELEMENT-1        
               MOVE 'DATABASE'                TO HOSTVAR-ELEMENT-1      
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03750000
      * 7010-OPEN-TEMP-CURS                                            *03760000
      ******************************************************************03770000
       7010-OPEN-TEMP-CURS.                                             
                                                                        
           EXEC SQL                                                     
              OPEN TEMP-CURS                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7010'               TO ACTIVE-PARAGRAPH             
              MOVE 'OPEN'               TO ABEND-FUNCTION               
              MOVE 'CSS_TEMPERTURE'     TO TABLE-1                      
              MOVE 'TEMP-DT'            TO TABLE-ELEMENT-1              
              MOVE WS-TEMP-DT           TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03750000
      * 7020-FETCH-TEMP-CURS                                           *03760000
      ******************************************************************03770000
       7020-FETCH-TEMP-CURS.                                            
                                                                        
           EXEC SQL                                                     
              FETCH TEMP-CURS                                           
               INTO :E8-TEMP-DT                                         
                   ,:E8-CHAS-HIGH                                       
                   ,:E8-AIKEN-HIGH                                      
                   ,:E8-COLA-HIGH                                       
                   ,:E8-CHAS-NORM                                       
                   ,:E8-AIKEN-NORM                                      
                   ,:E8-COLA-NORM                                       
                   ,:E8-CHAS-LOW                                        
                   ,:E8-AIKEN-LOW                                       
                   ,:E8-COLA-LOW                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE 'Y'              TO WS-NO-TEMP-ROWS               
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7020'               TO ACTIVE-PARAGRAPH             
              MOVE 'FETCH'              TO ABEND-FUNCTION               
              MOVE 'CSS_TEMPERTURE'     TO TABLE-1                      
              MOVE 'TEMP-DT'            TO TABLE-ELEMENT-1              
              MOVE WS-TEMP-DT           TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03750000
      * 7030-CLOSE-TEMP-CURS                                           *03760000
      ******************************************************************03770000
       7030-CLOSE-TEMP-CURS.                                            
                                                                        
           EXEC SQL                                                     
              CLOSE TEMP-CURS                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7030'               TO ACTIVE-PARAGRAPH             
              MOVE 'CLOSE'              TO ABEND-FUNCTION               
              MOVE 'CSS_TEMPERTURE'     TO TABLE-1                      
              MOVE 'TEMP-DT'            TO TABLE-ELEMENT-1              
              MOVE WS-TEMP-DT           TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************03750000
      * 7100-SELECT-YEST-ACCUM-HDD.                                    *03760000
      ******************************************************************03770000
       7100-SELECT-YEST-ACCUM-HDD.                                      
           EXEC SQL                                                     
                SELECT ACT_ACCUM_DEGREE                                 
                      ,NORM_ACCUM_DEGREE                                
                  INTO :E8-ACT-ACCUM-DEGREE                             
                      ,:E8-NORM-ACCUM-DEGREE                            
                  FROM CSS_TEMPERATURE WITH(READUNCOMMITTED)                    
                WHERE TEMP_DT = IIF(TRY_CONVERT(DATE, 
                                                 :WS-DATE-MINUS-ONE-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-MINUS-ONE-DAY
              ) <> 0) OR (LEN(:WS-DATE-MINUS-ONE-DAY
              ) <> 10), CIS.CHAR2DATE(:WS-DATE-MINUS-ONE-DAY
              ), CONVERT(DATE, :WS-DATE-MINUS-ONE-DAY) ) AND              
                      COMPANY_NO   = :WS-COMPANY-NO                     
                                                                 
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     04340000
MFA-TR*         SELECT ACT_ACCUM_DEGREE                                 04350000
MFA-TR*               ,NORM_ACCUM_DEGREE                                04350000
MFA-TR*           INTO :E8-ACT-ACCUM-DEGREE                             04360000
MFA-TR*               ,:E8-NORM-ACCUM-DEGREE                            04350000
MFA-TR*           FROM CSS_TEMPERATURE                                  04370000
MFA-TR*         WHERE TEMP_DT = :WS-DATE-MINUS-ONE-DAY AND              04380000
MFA-TR*               COMPANY_NO   = :WS-COMPANY-NO                     06170000
MFA-TR*           WITH UR                                                       
MFA-TR*        QUERYNO 7100                                                     
MFA-TR*     END-EXEC.                                                   04390000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME    TO ABEND-PROGRAM                    
               MOVE '7100'          TO ACTIVE-PARAGRAPH                 
               MOVE 'SELECT'             TO ABEND-FUNCTION              
               MOVE 'CSS_TEMPERTURE'     TO TABLE-1                     
               MOVE 'TEMP-DT'            TO TABLE-ELEMENT-1             
               MOVE WS-DATE              TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
ACT326******************************************************************03750000
ACT326* 7102-SELECT-NORM-HDD.                                          *03760000
ACT326******************************************************************03770000
ACT326 7102-SELECT-NORM-HDD.                                            
ACT002                                                                  
ACT002      EXEC SQL                                                    
ACT002           SELECT NT.NORMAL_DEGREE_DAYS                           
ACT002             INTO :NT-NORMAL-DEGREE-DAYS                          
ACT002             FROM CSS_NRML_DEGRE_DAY NT WITH(READUNCOMMITTED)             
ACT002           WHERE NT.MONTH_DAY     = :NT-MONTH-DAY                 
ACT002             AND NT.COMPANY_NO    = :NT-COMPANY-NO                
ACT002                                                           
ACT002                                                      
ACT002      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                    04590000
MFA-TR*          SELECT NT.NORMAL_DEGREE_DAYS                                   
MFA-TR*            INTO :NT-NORMAL-DEGREE-DAYS                                  
MFA-TR*            FROM CSS_NRML_DEGRE_DAY NT                                   
MFA-TR*          WHERE NT.MONTH_DAY     = :NT-MONTH-DAY                         
MFA-TR*            AND NT.COMPANY_NO    = :NT-COMPANY-NO                        
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7102                                                   
MFA-TR*     END-EXEC.                                                   04640000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT326                                                                  
ACT326      MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
ACT326                                                                  
ACT326      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
ACT326         CONTINUE                                                 
ACT326      ELSE                                                        
ACT326         MOVE PROGRAM-NAME    TO ABEND-PROGRAM                    
ACT326         MOVE '7102'          TO ACTIVE-PARAGRAPH                 
ACT326         MOVE 'SELECT'             TO ABEND-FUNCTION              
ACT002         MOVE 'CSS_NRML_DEGRE_DAY' TO TABLE-1                     
ACT002         MOVE 'MONTH-DAY'          TO TABLE-ELEMENT-1             
ACT002         MOVE 'COMPANY-NO'         TO TABLE-ELEMENT-2             
ACT002         MOVE NT-MONTH-DAY         TO HOSTVAR-ELEMENT-1           
ACT002         MOVE NT-COMPANY-NO        TO HOSTVAR-ELEMENT-2           
ACT326         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
ACT326         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
ACT326      END-IF.                                                     
ACT326                                                                  
ACT326 7102-EXIT.                                                       
ACT326     EXIT.                                                        
      ***************************************************************** 04320000
      * 7103-GET-WEATHER-DIV.      (SEB OR SCEG OR PSNC)              * 04320000
      *  SELECTS WEATHER SERV DIV                FROM CSS_DELINQUENCY * 04320000
      ***************************************************************** 04320000
       7103-GET-WEATHER-DIV.                                            
                                                                        
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE DELINQ_CD =  :C8-DELINQ-CD                         
                 AND COMPANY_NO = :C8-COMPANY-NO                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     04320000
MFA-TR*       SELECT DELINQ_VALUE                                       04320000
MFA-TR*         INTO :C8-DELINQ-VALUE                                   04320000
MFA-TR*         FROM CSS_DELINQUENCY                                    04320000
MFA-TR*        WHERE DELINQ_CD =  :C8-DELINQ-CD                         04320000
MFA-TR*          AND COMPANY_NO = :C8-COMPANY-NO                        04320000
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7103                                                     
MFA-TR*    END-EXEC.                                                    04320000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE C8-DELINQ-VALUE TO WS-FACTOR-VALUE                   
           ELSE                                                         
              MOVE '7103'                     TO ACTIVE-PARAGRAPH       
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_DELINQUENCY'          TO TABLE-1                
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-1        
              MOVE WS-COMPANY-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'WEATHER DIVISION'         TO TABLE-ELEMENT-1        
              MOVE C8-DELINQ-CD               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7103-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03750000
      * 7150-SELECT-DATE-MINUS-ONE-DAY.                                *03760000
      ******************************************************************03770000
       7150-SELECT-DATE-MINUS-ONE-DAY.                                  
            EXEC SQL                                                    
                SELECT
              DATEADD( DAY, -1, IIF(TRY_CONVERT(DATE, :WS-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE) <> 0) OR (LEN(
                                                               :WS-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-DATE), CONVERT(DATE, :WS-DATE
              ) ) )
            INTO
              :WS-DATE-MINUS-ONE-DAY     
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*     EXEC SQL                                                    06390000
MFA-TR*         SET :WS-DATE-MINUS-ONE-DAY = DATE(:WS-DATE) - 1 DAY     06400000
MFA-TR*     END-EXEC.                                                   06430000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
ACT326      EXEC SQL                                                    
ACT326          SELECT
              DATEADD( YEAR, -1, IIF(TRY_CONVERT(DATE, :WS-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE) <> 0) OR (LEN(
                                                               :WS-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-DATE), CONVERT(DATE, :WS-DATE
              ) ) )
            INTO
              :WS-DATE-MINUS-ONE-YEAR   
ACT326      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*     EXEC SQL                                                    06390000
MFA-TR*         SET :WS-DATE-MINUS-ONE-YEAR = DATE(:WS-DATE) - 1 YEAR   06400000
MFA-TR*     END-EXEC.                                                   06430000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME    TO ABEND-PROGRAM                    
               MOVE '7150'          TO ACTIVE-PARAGRAPH                 
               MOVE 'SET'                TO ABEND-FUNCTION              
               MOVE WS-DATE              TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7200-DATE-MINUS-ONE-YR                                         *        
      ******************************************************************        
       7200-DATE-MINUS-ONE-YR.                                          
                                                                        
           EXEC SQL                                                     
              SELECT
              DATEADD( YEAR, -1, IIF(TRY_CONVERT(DATE, :WS-TEMP-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-TEMP-DT) <> 0) OR (LEN(
                                                            :WS-TEMP-DT
              ) <> 10), CIS.CHAR2DATE(:WS-TEMP-DT), CONVERT(DATE, 
                                                            :WS-TEMP-DT
              ) ) )
            INTO
              :WS-DT-MINUS-ONE-YR      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-DT-MINUS-ONE-YR = DATE(:WS-TEMP-DT) - 1 YEAR              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7200'               TO ACTIVE-PARAGRAPH             
              MOVE 'SET'                TO ABEND-FUNCTION               
              MOVE 'WS_DATE'            TO TABLE-ELEMENT-1              
              MOVE WS-TEMP-DT           TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************06830000
      * 7250-SELECT-NORM-DETAILS.                                      *06840000
      ******************************************************************06850000
                                                                        
       7250-SELECT-NORM-DETAILS.                                        
                                                                        
           EXEC SQL                                                     
              SELECT COLA_NORM,                                         
                     CHAS_NORM,                                         
                     AIKEN_NORM                                         
                INTO :WS-COLA-NORM                                      
                    ,:WS-CHAS-NORM                                      
                    ,:WS-AIKEN-NORM                                     
                FROM CSS_TEMPERATURE WITH(READUNCOMMITTED)                      
               WHERE TEMP_DT = IIF(TRY_CONVERT(DATE, :WS-DT-MINUS-ONE-YR
              ) IS NULL OR (PATINDEX('%.%', :WS-DT-MINUS-ONE-YR
              ) <> 0) OR (LEN(:WS-DT-MINUS-ONE-YR
              ) <> 10), CIS.CHAR2DATE(:WS-DT-MINUS-ONE-YR
              ), CONVERT(DATE, :WS-DT-MINUS-ONE-YR) ) AND                  
                     COMPANY_NO = :WS-COMPANY-NO                        
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     15040000
MFA-TR*       SELECT COLA_NORM,                                                 
MFA-TR*              CHAS_NORM,                                                 
MFA-TR*              AIKEN_NORM                                                 
MFA-TR*         INTO :WS-COLA-NORM                                              
MFA-TR*             ,:WS-CHAS-NORM                                              
MFA-TR*             ,:WS-AIKEN-NORM                                             
MFA-TR*         FROM CSS_TEMPERATURE                                            
MFA-TR*        WHERE TEMP_DT = :WS-DT-MINUS-ONE-YR AND                          
MFA-TR*              COMPANY_NO = :WS-COMPANY-NO                                
MFA-TR*        QUERYNO 7250                                                     
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                    15040000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE '7250'                    TO ACTIVE-PARAGRAPH       
               MOVE 'SELECT'                  TO ABEND-FUNCTION         
               MOVE 'CSS_TEMPERATURE'         TO TABLE-1                
               MOVE 'TEMP_DT'                 TO TABLE-ELEMENT-1        
               MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-2        
               MOVE WS-DT-MINUS-ONE-YR        TO HOSTVAR-ELEMENT-1      
               MOVE WS-COMPANY-NO             TO HOSTVAR-ELEMENT-2      
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05410000
      * 8100-SEND-RESULT.                                              *05420000
      ******************************************************************05430000
       8100-SEND-RESULT.                                                
             ADD 1 TO CTR-ROWS.                                         
       8100-EXIT.                                                       
                                                                        
      ******************************************************************05410000
      * 8200-INSERT-TEMP                                               *05420000
      ******************************************************************05430000
       8200-INSERT-TEMP.                                                
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_TEMPERATURE                               
                     (    TEMP_DT          ,                            
                          COMPANY_NO       ,                            
                          CHAS_HIGH        ,                            
                          AIKEN_HIGH       ,                            
                          COLA_HIGH        ,                            
                          CHAS_NORM        ,                            
                          AIKEN_NORM       ,                            
                          COLA_NORM        ,                            
                          CHAS_LOW         ,                            
                          AIKEN_LOW        ,                            
                          COLA_LOW         ,                            
                          ACT_ACCUM_DEGREE ,                            
                          ACT_HEAT_DEGREE  ,                            
                          NORM_ACCUM_DEGREE,                            
                          NORM_HEAT_DEGREE                              
                          )                                             
              VALUES (IIF(TRY_CONVERT(DATE, :E8-TEMP-DT
              ) IS NULL OR (PATINDEX('%.%', :E8-TEMP-DT) <> 0) OR (LEN(
                                                            :E8-TEMP-DT
              ) <> 10), CIS.CHAR2DATE(:E8-TEMP-DT), CONVERT(DATE, 
                                                            :E8-TEMP-DT
              ) ),                                      
                      :E8-COMPANY-NO,                                   
                      :E8-CHAS-HIGH,                                    
                      :E8-AIKEN-HIGH,                                   
                      :E8-COLA-HIGH,                                    
                      :E8-CHAS-NORM,                                    
                      :E8-AIKEN-NORM,                                   
                      :E8-COLA-NORM,                                    
                      :E8-CHAS-LOW,                                     
                      :E8-AIKEN-LOW,                                    
                      :E8-COLA-LOW,                                     
                      :E8-ACT-ACCUM-DEGREE,                             
                      :E8-ACT-HEAT-DEGREE,                              
                      :E8-NORM-ACCUM-DEGREE,                            
                      :E8-NORM-HEAT-DEGREE                              
                      )                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     05460000
MFA-TR*       INSERT INTO CSS_TEMPERATURE                               05470000
MFA-TR*              (    TEMP_DT          ,                            05480000
MFA-TR*                   COMPANY_NO       ,                            05610000
MFA-TR*                   CHAS_HIGH        ,                            05490000
MFA-TR*                   AIKEN_HIGH       ,                            05500000
MFA-TR*                   COLA_HIGH        ,                            05510000
MFA-TR*                   CHAS_NORM        ,                            05520000
MFA-TR*                   AIKEN_NORM       ,                            05530000
MFA-TR*                   COLA_NORM        ,                            05540000
MFA-TR*                   CHAS_LOW         ,                            05550000
MFA-TR*                   AIKEN_LOW        ,                            05560000
MFA-TR*                   COLA_LOW         ,                            05570000
MFA-TR*                   ACT_ACCUM_DEGREE ,                            05580000
MFA-TR*                   ACT_HEAT_DEGREE  ,                            05590000
MFA-TR*                   NORM_ACCUM_DEGREE,                            05600000
MFA-TR*                   NORM_HEAT_DEGREE                              05610000
MFA-TR*                   )                                                     
MFA-TR*       VALUES (:E8-TEMP-DT,                                      05620000
MFA-TR*               :E8-COMPANY-NO,                                   05750000
MFA-TR*               :E8-CHAS-HIGH,                                    05630000
MFA-TR*               :E8-AIKEN-HIGH,                                   05640000
MFA-TR*               :E8-COLA-HIGH,                                    05650000
MFA-TR*               :E8-CHAS-NORM,                                    05660000
MFA-TR*               :E8-AIKEN-NORM,                                   05670000
MFA-TR*               :E8-COLA-NORM,                                    05680000
MFA-TR*               :E8-CHAS-LOW,                                     05690000
MFA-TR*               :E8-AIKEN-LOW,                                    05700000
MFA-TR*               :E8-COLA-LOW,                                     05710000
MFA-TR*               :E8-ACT-ACCUM-DEGREE,                             05720000
MFA-TR*               :E8-ACT-HEAT-DEGREE,                              05730000
MFA-TR*               :E8-NORM-ACCUM-DEGREE,                            05740000
MFA-TR*               :E8-NORM-HEAT-DEGREE                              05750000
MFA-TR*               )                                                         
MFA-TR*    END-EXEC.                                                    05760000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR ALREADY-EXISTS
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '8200'          TO ACTIVE-PARAGRAPH                  
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_TEMPERATURE'    TO TABLE-1                      
              MOVE 'TEMP_DT'            TO TABLE-ELEMENT-1              
              MOVE E8-TEMP-DT           TO HOSTVAR-ELEMENT-1            
              MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-1              
              MOVE E8-COMPANY-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05960000
      * 8300-UPDATE-TEMP                                               *05970000
      ******************************************************************05980000
       8300-UPDATE-TEMP.                                                
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_TEMPERATURE                                    
                 SET TEMP_DT           = IIF(TRY_CONVERT(DATE, 
                                                            :E8-TEMP-DT
              ) IS NULL OR (PATINDEX('%.%', :E8-TEMP-DT) <> 0) OR (LEN(
                                                            :E8-TEMP-DT
              ) <> 10), CIS.CHAR2DATE(:E8-TEMP-DT), CONVERT(DATE, 
                                                            :E8-TEMP-DT
              ) ),                   
                     COMPANY_NO        = :E8-COMPANY-NO,                
                     CHAS_HIGH         = :E8-CHAS-HIGH,                 
                     AIKEN_HIGH        = :E8-AIKEN-HIGH,                
                     COLA_HIGH         = :E8-COLA-HIGH,                 
                     CHAS_NORM         = :E8-CHAS-NORM,                 
                     AIKEN_NORM        = :E8-AIKEN-NORM,                
                     COLA_NORM         = :E8-COLA-NORM,                 
                     CHAS_LOW          = :E8-CHAS-LOW,                  
                     AIKEN_LOW         = :E8-AIKEN-LOW,                 
                     COLA_LOW          = :E8-COLA-LOW,                  
                     ACT_ACCUM_DEGREE  = :E8-ACT-ACCUM-DEGREE,          
                     ACT_HEAT_DEGREE   = :E8-ACT-HEAT-DEGREE,           
                     NORM_ACCUM_DEGREE = :E8-NORM-ACCUM-DEGREE,         
                     NORM_HEAT_DEGREE  = :E8-NORM-HEAT-DEGREE           
               WHERE TEMP_DT      = IIF(TRY_CONVERT(DATE, :WS-TEMP-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-TEMP-DT) <> 0) OR (LEN(
                                                            :WS-TEMP-DT
              ) <> 10), CIS.CHAR2DATE(:WS-TEMP-DT), CONVERT(DATE, 
                                                            :WS-TEMP-DT
              ) ) AND                     
                     COMPANY_NO   = :WS-COMPANY-NO                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     06010000
MFA-TR*       UPDATE CSS_TEMPERATURE                                    06020000
MFA-TR*          SET TEMP_DT           = :E8-TEMP-DT,                   06030000
MFA-TR*              COMPANY_NO        = :E8-COMPANY-NO,                06160000
MFA-TR*              CHAS_HIGH         = :E8-CHAS-HIGH,                 06040000
MFA-TR*              AIKEN_HIGH        = :E8-AIKEN-HIGH,                06050000
MFA-TR*              COLA_HIGH         = :E8-COLA-HIGH,                 06060000
MFA-TR*              CHAS_NORM         = :E8-CHAS-NORM,                 06070000
MFA-TR*              AIKEN_NORM        = :E8-AIKEN-NORM,                06080000
MFA-TR*              COLA_NORM         = :E8-COLA-NORM,                 06090000
MFA-TR*              CHAS_LOW          = :E8-CHAS-LOW,                  06100000
MFA-TR*              AIKEN_LOW         = :E8-AIKEN-LOW,                 06110000
MFA-TR*              COLA_LOW          = :E8-COLA-LOW,                  06120000
MFA-TR*              ACT_ACCUM_DEGREE  = :E8-ACT-ACCUM-DEGREE,          06130000
MFA-TR*              ACT_HEAT_DEGREE   = :E8-ACT-HEAT-DEGREE,           06140000
MFA-TR*              NORM_ACCUM_DEGREE = :E8-NORM-ACCUM-DEGREE,         06150000
MFA-TR*              NORM_HEAT_DEGREE  = :E8-NORM-HEAT-DEGREE           06160000
MFA-TR*        WHERE TEMP_DT      = :WS-TEMP-DT AND                     06170000
MFA-TR*              COMPANY_NO   = :WS-COMPANY-NO                      06170000
MFA-TR*    END-EXEC.                                                    06180000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '8300'          TO ACTIVE-PARAGRAPH                  
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_TEMPERATURE'    TO TABLE-1                      
              MOVE 'TEMP_DT'            TO TABLE-ELEMENT-1              
              MOVE WS-TEMP-DT           TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************06830000
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *06840000
      ******************************************************************06850000
           EXEC SQL                                                     06860000
              INCLUDE CPDSP300                                          06870000
           END-EXEC.                                                    06880000
                                                                        
                                                                        
              EXIT.                                                     
           EXEC SQL                                                     00000100
               INCLUDE CPD00321                                         00000200
           END-EXEC.                                                    00000300
