       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04628.                                         
       AUTHOR.        AARON ABRAHAM.                                    
COB303 DATE-WRITTEN.  APR 23, 2013.                                     
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  CSR04628 RETRIEVE SP FOR CREDIT ARRANGEMENTS                  *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
P0726K*  THIS PROGRAM RETURNS MULTIPLE CREDIT ARRANGEMENTS OPTION AND  *        
P00836*  BEING CALLED FROM CIS/IVR/WEB.                                *        
      *  RESULTS SETS:                                                 *        
      *     1.  ELIGIBLE ARRANGEMENTS                                  *        
      *     2.  ARRANGEMENT DETAILS                                    *        
      *     3.  BUSINESS RULES                                         *        
P00836*                                                                *        
P00836*     PARM-ARNG-CHANNEL-CD                                       *        
P00836*     - 'C' - CALL FROM CIS MOD                                  *        
P00836*     - 'I' - CALL FROM IVR                                      *        
P00836*     - 'W' - CALL FROM WEB MOD                                  *        
P00836*                                                                *        
P00836*  BusOp : GetCreditArngSetupPackage (Common Solution)           *        
P00836*                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
P00726*  03/04/13  AA97148    INITIAL IMPLEMENTATION.                  *        
P00726*  06/06/13  SS42021    ADD REG GROUP 1 S CHECK FOR ELIGIBILITY. *        
P00726*  06/14/13  Gokul      Add eligibility checks for Major and     *        
P00726*                       Non-residential accounts.                *        
P0726A*  08/19/13  AA97148    SELECTS DATE-BILL-DAYS FROM CSS_ACCOUNT  *        
P0726A*                       TO CORRECT ARREARS AMOUNT.               *        
P0726B*  10/23/13  AA97148    ADD FAIL SAFE HARD STOP MESSAGE TO FIX   *        
P0726B*                       FOR RESCHEDULED DNP ISSUE.               *        
P0726B*  11/22/13  AA97148    EXPAND FAIL SAFE HARD STOP MESSAGE TO    *        
P0726B*                       RETURN CHECK DNP AND DEPOSIT DNP.        *        
P0726C*  01/06/14  AA97148    ADD FAIL SAFE HARD STOP MESSAGE TO HANDLE*        
P0726C*                       CREDIT IS NOT COMPLETE WHEN ACCOUNT HAS  *        
P0726C*                       BILLED.                                  *        
P0726D*  02/10/14  AA97148    ADD FAIL SAFE HARD STOP MESSAGE IF THE   *        
P0726D*                       ACCOUNT HAS AN ACTIVE RETURNED CHECK.    *        
P0726E*  02/17/14  AA97148    RELEASE 2 CHANGES - CHANGE RTV SP TO GET *        
P0726E*                       MULTIPLE OPTIONS FOR CREDIT ARRANGEMENTS.*        
P0726F*  07/03/14  AA97148    1. RELEASE 3 CHANGES - CHANGE RTV SP TO  *        
P0726F*                          SHOW CDD/CDDA/STA/STAA.               *        
P0726F*                       2. STA PROCESS/BUSINESS RULES HAS BEEN   *        
P0726F*  07/03/14  AA97148       MOVED TO THIS SP FROM CSR04366/CSR04383        
P0726G*  08/08/14  Gokul      RELEASE 3 CHANGES - Group 1 Senior       *        
P0726G*                       changes.                                 *        
P0726H*  10/20/14  AA97148    PROD FIX - WS-DNP-TYPE VARIABLE REPLACED *        
P0726H*                       WITH NEAREST DNP TYPE WHILE LOADING FROM *        
P0726H*                       CPD00068.                                *        
P0726I*  10/24/14  AA97148    VALIDATES LAST REVENUE MONTH NORMAL BEFORE        
P0726I*                       FETCHING CREDIT FORECAST DETAILS.        *        
P0726J*  10/28/14  Gokul      RELEASE 4.1 changes - Populate active    *        
P0726J*                       credit action flag.                      *        
P0726K*  10/29/14  AA97148    ADDED ADDITIONAL VALIDATION TO THE STA   *        
P0726K*                       ARRANGEMENT TO SUPPORT IVR PROCESS.      *        
P0726L*  01/16/15  AA97148    Credit Arrangements Release 5 changes -  *        
P0726L*                       1. Move PSNC 'CUT' message to the plan   *        
P0726L*                       level and hide 2nd notice date on payment*        
P0726L*                       Arrangement maintail view                *        
P0726L*                       2. Remove STA duplicate message for SEB  *        
P0726M*  07/01/15  AA97148    Credit Arrangements Release 6 changes -  *        
P0726M*                       Add LAST-UPDATE-TS to the 2nd result set *        
D09359*  11/23/15  AA97148    Extend DNPFB validation to the CDD & CDDA*        
D09359*                       Arrangement Plans.                       *        
D09359*                       Ref. HPALM Defect # D9359.               *        
P00836*  12/23/15  AA97148    WEB MOD changes - Setup user table entries        
P00836*                       for WEB channel code and add validation  *        
P00836*                       which is similar to the IVR.             *        
D03409*  04/25/16  AA97148    Modify existing Service Order Status to  *        
D03409*                       display different warning/Hard stop msg. *        
D03409*                       Service Order Status < 26:               *        
D03409*                           CIS/IVR/WEB can able to make Arrange *        
D03409*                           ment.                                *        
D03409*                       Service Order Status = 26:               *        
D03409*                           CIS- can able to make Arrangement    *        
D03409*                           IVR/WEB - Not eligible to make Arrang*        
D03409*                           ement.                               *        
D03409*                       Service Order Status >= 30:              *        
D03409*                           CIS/IVR/WEB - Not eligible to make   *        
D03409*                           Arrangement                          *        
D03409*                       Ref. HPALM Defect # D3409 & D7262        *        
P00948*  06/13/16  VENKAT.P   - Least Amount to Pay Changes            *        
P00948*                       - Add BUS_RULES_RTN_FL.                  *        
ACT027*  02/15/17  RAMESH     -Remove STA_SUMMARY & STA_DETAIL TABLE   *        
ACT027*            APPL00005744   RELATED CHANGES.                     *        
P0948A*  11/11/16  VENKAT.P   Defect# 12885 - Do not offer STF when    *        
P0948A*                       - Exceptional DNP with status > 26       *        
P0948A*                       - When STF completed with NO compliance  *        
P0948A*                         on most recent business day            *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04628'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                      PIC X(40) VALUE                
           'WORKING STORAGE FOR CSR04628 STARTS HERE'.                  
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME              PIC X(08)  VALUE 'CSR04628'.   
           05  WS-PGRMNAME               PIC X(08)  VALUE 'CSR04628'.   
           05  MCSCB068                  PIC X(08)  VALUE 'MCSCB068'.   
           05  WS-AUTOCARD-SETUP-FL      PIC X(01)  VALUE 'N'.          
           05  WS-CURRENT-DATE           PIC X(10)  VALUE SPACES.       
P0948A     05  WS-TIMESTAMP.                                            
P0948A         10 WS-DATE                PIC X(10)  VALUE SPACES.       
P0948A         10 FILLER                 PIC X(16)  VALUE               
P0948A                                   '-00.00.00.000000'.            
           05  WS-NEXT-BILL-DATE         PIC X(10)  VALUE SPACES.       
P0726E     05  WS-NEW-DUE-DATE           PIC X(10)  VALUE SPACES.       
P0726E     05  WS-NEXT-READ-DATE         PIC X(10)  VALUE SPACES.       
           05  WS-REG-GROUP-CD           PIC X(03)  VALUE SPACES.       
           05  WS-RULE-XREF-ID           PIC X(26)  VALUE SPACES.       
           05  WS-RULE-ID                PIC X(10)  VALUE SPACES.       
           05  WS-COMP-NO                PIC X(10)  VALUE SPACES.       
           05  WS-SEASON-START-DDMM-NULL PIC S9(04) COMP VALUE +0.      
           05  WS-SEASON-END-DDMM-NULL   PIC S9(04) COMP VALUE +0.      
P0726A     05  WS-DATE-BILL-00-IND       PIC S9(04) COMP VALUE +0.      
P0726A     05  WS-DATE-BILL-30-IND       PIC S9(04) COMP VALUE +0.      
P0726A     05  WS-DATE-BILL-60-IND       PIC S9(04) COMP VALUE +0.      
P0726A     05  WS-DATE-BILL-90-IND       PIC S9(04) COMP VALUE +0.      
P0726D     05  WS-AMT-AR-DAY-00-NULL     PIC S9(04) COMP VALUE +0.      
P0726D     05  WS-AMT-AR-DAY-30-NULL     PIC S9(04) COMP VALUE +0.      
P0726D     05  WS-AMT-AR-DAY-60-NULL     PIC S9(04) COMP VALUE +0.      
P0726D     05  WS-AMT-AR-DAY-90-NULL     PIC S9(04) COMP VALUE +0.      
P0726F     05  WS-CR-GRP-EFF-DT-NULL     PIC S9(04) COMP VALUE +0.      
P0726C     05  WS-PARM-DATE              PIC X(10)  VALUE SPACES.       
P0726C     05  WS-INCOMPLETE-CREDIT-FL   PIC X(01)  VALUE 'N'.          
P0726C     05  WS-BILL-HDR-FL            PIC X(01)  VALUE 'N'.          
P0726D     05  WS-ACTIVE-RET-CHECK       PIC X(01)  VALUE 'N'.          
P0726E     05  WS-BUS-RULE-COUNT         PIC S9(04) COMP VALUE +0.      
P0726E     05  WS-HOLD-ARNG-COUNT        PIC S9(04) COMP VALUE +0.      
P0726E     05  WS-TEMP-RULE-COUNT        PIC S9(04) COMP VALUE +0.      
P0726E     05  WS-CPD310-NULL-IND        PIC S9(04) COMP VALUE +0.      
P0726E     05  WS-NULL-IND-CPD           PIC S9(04) COMP VALUE +0.      
P0726E     05  RS-RETURN-CODE            PIC S9(9)  COMP VALUE +0.      
P0726E     05  WS-RETAIN-COMMER-DEP      PIC S9(04) COMP VALUE ZERO.    
P0726E     05  WS-RETAIN-INDUST-DEP      PIC S9(04) COMP VALUE ZERO.    
P0726E     05  WS-RETAIN-RESIDENT-DEP    PIC S9(04) COMP VALUE ZERO.    
P0726E     05  WS-RETAIN-DEL-MTHS        PIC S9(04) COMP VALUE ZERO.    
P0726E     05  WS-MONTH                  PIC S9(04) COMP VALUE ZERO.    
P0726E     05  WS-ARREARS-COUNT          PIC S9(04) COMP VALUE ZERO.    
P0726E     05  WS-OVER-30-DAYS           PIC X(01)  VALUE '1'.          
P0726E     05  WS-OVER-60-DAYS           PIC X(01)  VALUE '2'.          
P0726E     05  WS-OVER-90-DAYS           PIC X(01)  VALUE '3'.          
P0726E     05  WS-ELIG-MTHS-SEB          PIC S9(02) COMP VALUE 0.       
P0726E     05  WS-CREDIT-GROUP           PIC X(01)  VALUE SPACES.       
P0726E     05  WS-ACCOUNT-TYPE-CODE      PIC X(01)  VALUE SPACES.       
P0726E     05  WS-ARNG-ID-EXISTS         PIC X(01)  VALUE SPACES.       
P0726E     05  WS-BILL-DATE              PIC X(10)  VALUE SPACES.       
P0726E     05  WS-BILL-CYCLE-OPEN-DT     PIC X(10)  VALUE SPACES.       
P0726E     05  WS-BILL-CYCLE-CLOSE-DT    PIC X(10)  VALUE SPACES.       
P0726E     05  WS-ROW-FOUND              PIC X(01)  VALUE 'N'.          
P0726E     05  WS-BN-COUNT               PIC S9(04) COMP VALUE 0.       
P0726E     05  WS-BILL-SUB               PIC S9(04) COMP VALUE 0.       
P0726E     05  WS-REV-MTH-LST-NRML       PIC S9(6)V COMP-3 VALUE 0.     
P0726E     05  WS-REV-MTH-LST-NRML-A     PIC 9(6)   VALUE 0.            
P0726E     05  WS-REV-MTH-LST-NRML-B     PIC 9(6)   VALUE 0.            
P0726E     05  WS-BILL-CYCLE             PIC X(02)  VALUE SPACES.       
P0726E     05  WS-CURR-CHG-DUE-DT-NULL   PIC S9(04) COMP VALUE 0.       
P0726E     05  WS-DNP-NOTICE-DUE-DT-NULL PIC S9(04) COMP VALUE 0.       
P0726E     05  WS-CURR-ARNG-ID           PIC X(05)  VALUE SPACES.       
P0726E     05  WS-ARRANGEMENT-ID         PIC X(05)  VALUE SPACES.       
P0726E     05  WS-FORECAST-ROW-NOT-FOUND PIC X(01)  VALUE 'N'.          
P0726E     05  WS-CDD-AFTER-BILL-EXISTS  PIC X(01)  VALUE 'N'.          
P0726E     05  WS-ARNG-PLAN-PROCESSED    PIC X(01)  VALUE 'N'.          
P0726E     05  WS-ARNG-TERM-CD           PIC X(02)  VALUE SPACES.       
P0726F     05  WS-NEAREST-DNP-DT         PIC X(10)  VALUE SPACES.       
P0726F     05  WS-NO-CRED-ACT-ROWS       PIC S9(4)  COMP VALUE 0.       
P0726F     05  WS-CRED-ACTION-DT OCCURS 04 TIMES INDEXED BY CRED-INDX.  
P0726F         10 IN-CRED-ACTION-DT      PIC X(10).                     
P0726F         10 IN-DNP-TYPE            PIC X(01).                     
P0726F     05  WS-DNP-FLAG               PIC X(01)  VALUE SPACES.       
P0726F     05  WS-PENDING-SO-FLAG        PIC X(01)  VALUE SPACES.       
P0726J     05  WS-CREDIT-ACTION-FL       PIC X(01)  VALUE SPACES.       
P0726F     05  WS-DNP-ACT-FLAG           PIC X(01)  VALUE SPACES.       
P0726F     05  WS-STA-AMOUNT             PIC S9(9)V9(2) USAGE COMP-3    
P0726F                                              VALUE 0.            
P0726F     05  WS-EXCPTNL-MSG            PIC X(01)  VALUE 'N'.          
P0726F     05  WS-DAY-STA-SECOND-MAIL-CD PIC X(19)  VALUE               
P0726F                                       'DAY-STA-SECOND-MAIL'.     
P0726K     05  WS-WQ-STA-START-TIME-CD   PIC X(17)  VALUE               
P0726K                                       'WQ-STA-START-TIME'.       
P00948     05  WS-LEAST-AMT-DUE-CD       PIC X(13)  VALUE               
P00948                                       'LEAST-AMT-DUE'.           
P00948     05  WS-LEAST-AMT-DUE          PIC S9(4)V9(2) USAGE COMP-3    
P00948                                              VALUE 0.            
P0726K     05  WS-WQ-STA-START-TIME      PIC S9(4)V9(5) USAGE COMP-3    
P0726K                                              VALUE 0.            
P0726K     05  WS-WQ-STA-START-TIME-N    PIC 9(4)   VALUE 0.            
P0726K     05  WS-WQ-STA-START-TIME-A    PIC X(4)   VALUE SPACES.       
P0726K     05  WS-CURRENT-TIMESTMP       PIC X(26)  VALUE SPACES.       
P0726K     05  WS-TS-FULL.                                              
P0726K         10 WS-TS-DATE             PIC X(10)  VALUE SPACES.       
P0726K         10 WS-TS-FILLER-1         PIC X(1)   VALUE SPACES.       
P0726K         10 WS-TS-HOUR             PIC X(2)   VALUE SPACES.       
P0726K         10 WS-TS-FILLER-2         PIC X(1)   VALUE SPACES.       
P0726K         10 WS-TS-MIN              PIC X(2)   VALUE SPACES.       
P0726K         10 WS-TS-FILLER-2         PIC X(1)   VALUE SPACES.       
P0726K         10 WS-TS-SEC-NANO         PIC X(9)   VALUE SPACES.       
P0726K     05  WS-TIME.                                                 
P0726K         10 WS-TIME-HOUR           PIC X(2)   VALUE SPACES.       
P0726K         10 WS-TIME-MIN            PIC X(2)   VALUE SPACES.       
p0726F     05  WS-DAY-STA-SECOND-MAIL    PIC S9(05) COMP-3 VALUE +0.    
P0726F     05  WS-DPP-DROP-EXISTS        PIC X(01)  VALUE 'N'.          
P0726F     05  WS-RECENT-PAYMENT         PIC X(01)  VALUE SPACES.       
P0726F     05  WS-UNPAID-DEPOSIT         PIC X(01)  VALUE SPACES.       
P0726F     05  WS-60-DAY-ARREARS         PIC X(01)  VALUE SPACES.       
P0726F     05  WS-DAYS-60                PIC S9(4)  COMP VALUE 0.       
P0726F     05  WS-AMT-ARREARS-GR-30      PIC S9(09)V99 USAGE COMP-3     
P0726F                                              VALUE 0.            
P0726F     05  WS-AMT-NSA                PIC S9(09)V99 USAGE COMP-3     
P0726F                                              VALUE 0.            
P0726K     05  WS-AMT-NSA-NSN            PIC S9(09)V99 COMP-3 VALUE +0. 
P0726F     05  WS-DAY-DUE                PIC S9(05) COMP-3 VALUE +0.    
P0726F     05  WS-DAY-DUE-CD             PIC X(07)  VALUE 'DAY-DUE'.    
P0726F     05  WS-MIN-DATE-EXTRACT       PIC X(10)  VALUE SPACES.       
P0726F     05  WS-MAX-DATE-EXTRACT       PIC X(10)  VALUE SPACES.       
P0726F     05  WS-DAY-DNP                PIC S9(05) COMP-3 VALUE +0.    
P0726F     05  WS-AMT-ARREARS-GR-60      PIC S9(09)V99 USAGE COMP-3     
P0726F                                              VALUE 0.            
P0726F     05  WS-DAYS-EXPIRE            PIC S9(04) COMP VALUE 0.       
P0726F     05  WS-RECENT-DPP-FL          PIC X(01)  VALUE SPACES.       
P0726F         88 WS-RECENT-DPP-EXISTS              VALUE 'Y'.          
P0726F     05  WS-RECENT-STA-FL          PIC X(01)  VALUE SPACES.       
P0726F         88 WS-RECENT-STA-EXISTS              VALUE 'Y'.          
P0726F     05  WS-RECENT-STA-DAYS        PIC S9(09) COMP VALUE 0.       
P0726F     05  WS-LAST-ARNG-DAYS         PIC S9(09) COMP VALUE 0.       
P0726F     05  WS-RECENT-DPP-DAYS        PIC S9(09) COMP VALUE 0.       
P0726F     05  WS-CRED-FL                PIC X(01)  VALUE 'N'.          
P0726F     05  WS-DAYS-90                PIC S9(4)  COMP VALUE 0.       
P0726F     05  WS-RECENT-PYMT-DAYS       PIC S9(09) COMP VALUE 0.       
P0726F     05  WS-BUD-HIST-DT            PIC X(10)  VALUE SPACES.       
P0726F     05  WS-3MNTHS-CHK-DT          PIC X(10)  VALUE SPACES.       
P0726F     05  WS-60-DAY-AR-IND          PIC X(01)  VALUE SPACES.       
P0726F     05  WS-CURRENT-DT             PIC X(10)  VALUE SPACES.       
P0726F     05  WS-HOLD-REVENUE-MONTH     PIC 9(06)  VALUE 0.            
P0726F     05  WS-ORIGINAL-REV-MTH-NRML  PIC 9(06)  VALUE 0.            
P0726F     05  WS-CATEGORY-CD            PIC X(01)  VALUE SPACES.       
P0726F     05  WS-DAYS-30                PIC S9(4)  COMP VALUE 0.       
P0726F     05  WS-STA-CTMTR-LMT          PIC S9(4)V9(5) USAGE COMP-3    
P0726F                                              VALUE 0.            
P0726F     05  WS-GUARNTR-TRSFR-DT       PIC X(10)  VALUE SPACES.       
P0726F     05  WS-WRITE-OFF-DT           PIC X(10)  VALUE SPACES.       
P0726F     05  WS-BILL-IMED-DEP          PIC X(01)  VALUE SPACES.       
P0726F     05  WS-NEW-DNP-FL             PIC X(01)  VALUE SPACES.       
P0726F     05  WS-CRED-ACT-ROWS          PIC S9(4)  COMP VALUE 0.       
P0726F     05  WS-NXT-NEAR-DNP-DT        PIC X(10)  VALUE SPACES.       
P0726F     05  WS-NXT-DNP-TYPE           PIC X(01)  VALUE SPACES.       
P0726F     05  WS-ZERO                   PIC 9(01)  VALUE 0.            
P0726F     05  WS-NEXT-BUSINESS-DAY      PIC X(01)  VALUE 'N'.          
P0726F         88 NEXT-BUSINESS-DAY-FOUND           VALUE 'Y'.          
P0726F     05  WS-ORIGINAL-DNP-TYPE      PIC X(01)  VALUE SPACES.       
P0726F     05  WS-ORIGINAL-DNP-DATE      PIC X(10)  VALUE SPACES.       
P0726F     05  WS-FIRST-NOT-MAIL-DT      PIC X(10)  VALUE SPACES.       
P0726F     05  WS-FINAL-NOT-MAIL-DT      PIC X(10)  VALUE SPACES.       
P0726F     05  WS-NEW-DNP-DT-DB2FMT      PIC X(10)  VALUE SPACES.       
P0726F     05  WS-FINAL-NOT-DT-DB2FMT    PIC X(10)  VALUE SPACES.       
P0726F     05  WS-CALC-DUE-DATE          PIC X(10)  VALUE SPACES.       
P0726F     05  WS-NEW-DNP-DATE           PIC X(10)  VALUE SPACES.       
P0726F     05  WS-CALC-ARREARS-UTL       PIC S9(09)V99 VALUE +0.        
P0726F     05  WS-DAY-DUE-CD-STA         PIC X(11)  VALUE 'DAY-DUE-STA'.
P0726F     05  WS-ARNG-CHANNEL-CODE      PIC X(02)  VALUE SPACES.       
P0726F     05  WS-2ND-NEXT-BILL-DATE     PIC X(10)  VALUE SPACES.       
P0726F     05  WS-FST-GROUP-CD           PIC X(01)  VALUE SPACES.       
P0726F     05  WS-ACTIVE-ARNG-TYPE       PIC X(10)  VALUE SPACES.       
P0726F     05  WS-STAA-ELIGIBLE-FL       PIC X(01)  VALUE 'N'.          
P0726F     05  WS-UTIL-HISTORY.                                         
P0726F         10 WS-UTILITY-ARREARS     PIC X(24)  VALUE SPACES.       
P0726F         10 WS-UTIL-LAST-MTH-HST   PIC X(01)  VALUE SPACES.       
P0726F     05  WS-MONTHS-TO-EVALUATE     PIC S9(9)  COMP VALUE 0.       
P0726F     05  WS-DATE-1                 PIC X(10)  VALUE SPACES.       
P0726F     05  WS-DATE-2                 PIC X(10)  VALUE SPACES.       
P0726F     05  ws-STA-ARNG-CMPLD-IND     PIC X(01)  VALUE SPACES.       
P0726H     05  WS-NEAREST-DNP-TYPE       PIC X(01)  VALUE SPACES.       
P0726G     05  WS-GROUP1-TO-GROUP2-FL    PIC X(01)  VALUE 'N'.          
P0726G     05  WS-ACCT-ATTRIBUTE-FL      PIC X(01)  VALUE 'N'.          
           05  WS-SSN-CUST               PIC X(04)  VALUE SPACE.        
           05  WS-SSN-SPOUSE             PIC X(04)  VALUE SPACE.        
           05  WS-SSN-ROOMMATE1          PIC X(04)  VALUE SPACE.        
           05  WS-SSN-ROOMMATE2          PIC X(04)  VALUE SPACE.        
           05  WS-SSN-ROOMMATE3          PIC X(04)  VALUE SPACE.        
           05  WS-DATE-CCYY-MM-DD.                                      
               10  WS-DATE-CCYY          PIC X(04)  VALUE SPACES.       
               10  FILLER                PIC X(01)  VALUE SPACES.       
               10  WS-DATE-MM            PIC X(02)  VALUE SPACES.       
               10  FILLER                PIC X(01)  VALUE SPACES.       
               10  WS-DATE-DD            PIC X(02)  VALUE SPACES.       
           05  WS-DATE-MM-DD-YYYY.                                      
               10  WS-DATE2-MM           PIC X(02)  VALUE SPACES.       
               10  FILLER                PIC X(01)  VALUE '/'.          
               10  WS-DATE2-DD           PIC X(02)  VALUE SPACES.       
               10  FILLER                PIC X(01)  VALUE '/'.          
               10  WS-DATE2-CCYY         PIC X(04)  VALUE SPACES.       
P0726E     05  WS-REV-MNTH-HOLD.                                        
P0726E         10  WS-REV-YY-HOLD        PIC 9(04)  VALUE 0.            
P0726E         10  WS-REV-MM-HOLD        PIC 9(02)  VALUE 0.            
P0726F     05  WS-YEAR-MONTH.                                           
P0726F         10 WS-YEAR                PIC 9(04)  VALUE 0.            
P0726F         10 WS-MNTH                PIC 9(02)  VALUE 0.            
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS-RS1              PIC S9(9)  COMP VALUE 0.       
           05  CTR-ROWS-RS2              PIC S9(9)  COMP VALUE 0.       
           05  CTR-ROWS-RS3              PIC S9(9)  COMP VALUE 0.       
           05  WS-ARNG-TBL-COUNT         PIC S9(9)  COMP VALUE 0.       
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  GTT-RETURN-FIELDS-1.                                     
               10 S-R1-RETURN-CODE       PIC S9(9)  COMP VALUE 0.       
P0726E         10 S-R1-APPL-RETURN-CODE  PIC S9(9)  COMP VALUE 0.       
P0726E         10 S-R1-ARNG-ID           PIC X(05)  VALUE SPACES.       
P0726E         10 S-R1-ARNG-TYPE         PIC X(10)  VALUE SPACES.       
P0726E         10 S-R1-ARNG-TERM_CD      PIC X(02)  VALUE SPACES.       
P0726E         10 S-R1-ARNG-OPTION-ID    PIC S9(4)  COMP VALUE +0.      
P00948         10 S-R1-ARNG-PRIORITY     PIC S9(4)  COMP VALUE +0.      
               10 S-R1-STA-AMOUNT        PIC S9(09)V99  COMP-3 VALUE +0.
               10 S-R1-NEW-STA-DUE-DATE  PIC X(10)  VALUE SPACES.       
               10 S-R1-NEW-STA-DNP-DATE  PIC X(10)  VALUE SPACES.       
P0726J         10 S-R1-CREDIT-ACTION-FL  PIC X(01)  VALUE SPACES.       
           05  GTT-RETURN-FIELDS-2.                                     
               10 S-R2-RETURN-CODE       PIC S9(9)  COMP VALUE 0.       
               10 S-R2-ARNG-ID           PIC X(05)  VALUE SPACES.       
               10 S-R2-ARNG-TYPE         PIC X(10)  VALUE SPACES.       
               10 S-R2-ARNG-CHANNEL-CD   PIC X(02)  VALUE SPACES.       
               10 S-R2-ARNG-TOTAL-AMT    PIC S9(9)V9(2) COMP-3 VALUE +0.
               10 S-R2-ARNG-DUE-DT       PIC X(10)  VALUE SPACES.       
               10 S-R2-ORIG-DUE-DT       PIC X(10)  VALUE SPACES.       
               10 S-R2-TOTAL-AR-BALANCE  PIC S9(9)V9(2) COMP-3 VALUE +0.
               10 S-R2-TOTAL-UTL-BALANCE PIC S9(9)V9(2) COMP-3 VALUE +0.
               10 S-R2-TOTAL-NONUTL-BALANCE                             
                                         PIC S9(9)V9(2) COMP-3 VALUE +0.
               10 S-R2-UTL-ARREARS-AMT   PIC S9(9)V9(2) COMP-3 VALUE +0.
               10 S-R2-NONUTL-ARREARS-AMT                               
                                         PIC S9(9)V9(2) COMP-3 VALUE +0.
               10 S-R2-SSN-CUST          PIC X(04)  VALUE SPACE.        
               10 S-R2-SSN-SPOUSE        PIC X(04)  VALUE SPACE.        
               10 S-R2-SSN-ROOMMATE1     PIC X(04)  VALUE SPACE.        
               10 S-R2-SSN-ROOMMATE2     PIC X(04)  VALUE SPACE.        
               10 S-R2-SSN-ROOMMATE3     PIC X(04)  VALUE SPACE.        
P0726F         10 S-R2-ORIGINAL-DNP-TYPE PIC X(01)  VALUE SPACES.       
P0726F         10 S-R2-ORIGINAL-DNP-DATE PIC X(10)  VALUE SPACES.       
P0726F         10 S-R2-FIRST-NOT-MAIL-DT PIC X(10)  VALUE SPACES.       
P0726F         10 S-R2-FINAL-NOT-MAIL-DT PIC X(10)  VALUE SPACES.       
P0726M         10 S-R2-LAST-UPDATE-TS    PIC X(26)  VALUE SPACES.       
           05  GTT-RETURN-FIELDS-3.                                     
               10 S-R3-RETURN-CODE       PIC S9(9)  COMP VALUE 0.       
P0726E         10 S-R3-ARNG-ID           PIC X(05)  VALUE SPACES.       
P0726E         10 S-R3-RULE-NOTIFY-TYPE-CD                              
P0726E                                   PIC X(01)  VALUE SPACES.       
               10 S-R3-BUS-RULE-ID       PIC X(10)  VALUE SPACES.       
               10 S-R3-RULE-RESULT-CD    PIC X(10)  VALUE SPACES.       
               10 S-R3-BUS-RULE-XREF-ID  PIC X(26)  VALUE SPACES.       
               10 S-R3-MESSAGE-PARMS     PIC X(200) VALUE SPACES.       
               10 S-R3-LINK-PARMS        PIC X(200) VALUE SPACES.       
                                                                        
       01  SWITCHES.                                                    
           05  WS-ARNG-USER-TBL-LOADED   PIC X(01)  VALUE 'N'.          
               88 ARNG-USER-TBL-LOADED              VALUE 'Y'.          
           05  WS-ARNG-VALIDATION        PIC X(01)  VALUE 'N'.          
               88 VALIDATION-FAILED                 VALUE 'Y'.          
P0726E     05  WS-ROW-INSERTED           PIC X(01)  VALUE 'N'.          
P0726E         88 ROW-INSERTED                      VALUE 'Y'.          
P0726E     05  WS-RULE-ID-FOUND          PIC X(01)  VALUE 'N'.          
P0726E         88 RULE-ID-FOUND                     VALUE 'Y'.          
P0726E     05  WS-DATABASE               PIC 9(01)  VALUE ZERO.         
P0726E         88 CSR-DATABASE                      VALUE 1.            
P0726E         88 SEB-DATABASE                      VALUE 2.            
P0726E     05  WS-BILL-WINDOW            PIC X(10)  VALUE 'N'.          
P0726E         88 BILL-WINDOW-LOADED                VALUE 'Y'.          
P0726E         88 BILL-WINDOW-NOT-LOADED            VALUE 'N'.          
P0726F     05  WS-DNP-TYPE               PIC X(01)  VALUE SPACES.       
P0726F         88 EXCPTNL-DNP            VALUE 'D', 'M', 'Q', 'S', 'T', 
P0726F                                         'W'.                     
P0726F     05  WS-STA004-DSP             PIC X(01)  VALUE 'N'.          
P0726F         88 STA004-DSP                        VALUE 'Y'.          
P0726F     05  WS-REG-GROUP              PIC X(03)  VALUE SPACES.       
P0726F         88 WS-DEREG                          VALUE ' '.          
P0726F         88 WS-REG                            VALUE '100', '200'. 
P0726F     05  WS-COMPANY                PIC X(02)  VALUE SPACES.       
P0726F         88 WS-SCEG                           VALUE '01'.         
P0726F         88 WS-PSNC                           VALUE '26'.         
P00948     05  WS-STAA-PROCESSED-FL      PIC X(01)  VALUE SPACES.       
P00948         88 STAA-PROCESSED                    VALUE 'Y'.          
P00948         88 STAA-NOT-PROCESSED                VALUE 'N'.          
P00948     05  WS-BUS-RULES-RTN-FL       PIC X(01)  VALUE SPACES.       
P00948         88 BUS-RULES-RTN                     VALUE 'Y'.          
P0948A     05  WS-ARNG-COMPLIED-FL       PIC X(01)  VALUE 'Y'.          
P0948A         88 ARNG-COMPLIED                     VALUE 'Y'.          
P0948A         88 ARNG-NOT-COMPLIED                 VALUE 'N'.          
P0726F                                                                  
       01  CSRERLOG-P.                                                  
           05  S-SP-NAME                 PIC X(18)  VALUE SPACES.       
           05  S-SQLCODE                 PIC S9(9)  COMP  VALUE 0.      
           05  S-SQLSTATE                PIC X(5)   VALUE ' '.          
           05  S-TABLE-NAME              PIC X(18)  VALUE SPACES.       
           05  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4)  USAGE COMP.         
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           05  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4)  USAGE COMP.         
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           05  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4)  USAGE COMP.         
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           05  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4)  USAGE COMP.         
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
           05  WS-SQLSTATE               PIC X(05)  VALUE SPACES.       
           05  WS-GTT-NAME               PIC X(19)  VALUE SPACES.       
                                                                        
       01  WS-TABLES.                                                   
           05  WS-ARNG-DTLS              OCCURS 300                     
                                         INDEXED BY T1-INDX.            
               10 WS-ARNG-ID             PIC X(05)  VALUE SPACES.       
               10 WS-ARNG-TYPE           PIC X(10)  VALUE SPACES.       
               10 WS-ARNG-STATUS-CD      PIC X(01)  VALUE SPACES.       
               10 WS-ARNG-DESC           PIC X(50)  VALUE SPACES.       
               10 WS-ARNG-BILL-OPTN-CD   PIC X(01)  VALUE SPACES.       
               10 WS-UTIL-NONUTIL-CD     PIC X(02)  VALUE SPACES.       
               10 WS-RECVBLE-DEFER-CD    PIC X(01)  VALUE SPACES.       
               10 WS-ARNG-FREQ-CD        PIC X(01)  VALUE SPACES.       
               10 WS-SEASONAL-FL         PIC X(01)  VALUE SPACES.       
               10 WS-INSTALLMENT-FL      PIC X(01)  VALUE SPACES.       
               10 WS-ARNG-DROP-FL        PIC X(01)  VALUE SPACES.       
               10 WS-PLAN-TERM-CD        PIC X(02)  VALUE SPACES.       
               10 WS-PLAN-TERM-MIN       PIC S9(3)V COMP-3 VALUE +0.    
               10 WS-PLAN-TERM-MAX       PIC S9(3)V COMP-3 VALUE +0.    
               10 WS-PLAN-TERM-MAX-OVRD  PIC S9(3)V COMP-3 VALUE +0.    
               10 WS-SEASON-START-DDMM   PIC S9(4)V COMP-3 VALUE +0.    
               10 WS-SEASON-END-DDMM     PIC S9(4)V COMP-3 VALUE +0.    
               10 WS-PATH-START-CD       PIC X(01)  VALUE SPACES.       
               10 WS-LPC-ASSESS-CD       PIC X(01)  VALUE SPACES.       
               10 WS-ARNG-AMOUNT-CD      PIC X(01)  VALUE SPACES.       
               10 WS-ARNG-PLAN-DESC      PIC X(50)  VALUE SPACES.       
               10 WS-NSF-ALLOWED-FL      PIC X(01)  VALUE SPACES.       
               10 WS-ACTN-PATH-TYPE-CD   PIC X(01)  VALUE SPACES.       
               10 WS-TERM-OPTION-SEQ     PIC S9(04) USAGE COMP VALUE +0.
               10 WS-ARNG-GRACE-PERIOD   PIC S9(04) USAGE COMP VALUE +0.
               10 WS-ARNG-PRIORITY       PIC S9(04) USAGE COMP VALUE +0.
               10 WS-DAY-COUNT-TYPE-CD   PIC X(01)  VALUE SPACES.       
P0726E         10 WS-ARNG-CHANNEL-CD     PIC X(02)  VALUE SPACES.       
               10 WS-ARNG-PLAN-ID        PIC S9(04) USAGE COMP VALUE +0.
               10 WS-ARNG-OPTION-ID      PIC S9(04) USAGE COMP VALUE +0.
P0726E         10 WS-CREDIT-GROUP-CD     PIC X(01)  VALUE SPACES.       
P0726E         10 WS-CRED-ACTN-EXIST-CD  PIC X(01)  VALUE SPACES.       
P0726E         10 WS-OPTION-TERM-CD      PIC X(02)  VALUE SPACES.       
                                                                        
           05  T2-RULES                  OCCURS 300                     
                                         INDEXED BY T2-INDX.            
               10  T2-RULE-ID            PIC X(10) VALUE SPACES.        
               10  T2-RULE-XREF-ID       PIC X(26) VALUE SPACES.        
               10  T2-COMPANY-NO         PIC X(02) VALUE SPACES.        
                                                                        
P0726E     05  T3-RULES                  OCCURS 300                     
P0726E                                   INDEXED BY T3-INDX.            
P0726E         10  T3-RULE-ID            PIC X(10)  VALUE SPACES.       
P0726E         10  T3-RULE-XREF-ID       PIC X(26)  VALUE SPACES.       
P0726E         10  T3-COMPANY-NO         PIC X(02)  VALUE SPACES.       
                                                                        
P0726E 01  WS-BUS-RULE-TMP-TBL.                                         
P0726E     05  T4-BUS-RULE-TEMP          OCCURS 300                     
P0726E                                   INDEXED BY T4-INDX.            
P0726E         10 T4-RETURN-CODE         PIC S9(9)  COMP VALUE 0.       
P0726E         10 T4-ARNG-ID             PIC X(05)  VALUE SPACES.       
P0726E         10 T4-RULE-NOTIFY-TYPE-CD                                
P0726E                                   PIC X(01)  VALUE SPACES.       
P0726E         10 T4-BUS-RULE-ID         PIC X(10)  VALUE SPACES.       
P0726E         10 T4-RULE-RESULT-CD      PIC X(10)  VALUE SPACES.       
P0726E         10 T4-BUS-RULE-XREF-ID    PIC X(26)  VALUE SPACES.       
P0726E         10 T4-MESSAGE-PARMS       PIC X(200) VALUE SPACES.       
P0726E         10 T4-LINK-PARMS          PIC X(200) VALUE SPACES.       
                                                                        
P0726E 01  WS-HOLD-ARNG-ID-TBL.                                         
P0726E     05  T5-HOLD-ARNG-ID-TEMP      OCCURS 300                     
P0726E                                   INDEXED BY T5-INDX.            
P0726E         10  T5-HOLD-ARNG-ID       PIC X(05)  VALUE SPACES.       
                                                                        
P0726E 01  WS-BILL-WINDOW-TBL.                                          
P0726E     05  WS-BILL-WINDOW-ENTRY      OCCURS 20 TIMES.               
P0726E         10 WS-DATE-EXTRACT-TB     PIC X(10)  VALUE SPACES.       
P0726E         10 WS-CODE-BILL-COND-TB   PIC X(01)  VALUE SPACES.       
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ACCOUNT         - AT                                    *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
P0726D******************************************************************        
P0726D*    CSS_AR_CNTL         - AC                                    *        
P0726D******************************************************************        
P0726D                                                                  
P0726D     EXEC SQL                                                             
P0726D        INCLUDE TBARCNTL                                                  
P0726D     END-EXEC.                                                            
P0726D                                                                  
      ******************************************************************        
      *    CSS_ARNG_OPTION     - UD                                    *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBARGOPT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ARNG_PLAN       - UF                                    *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBARGPLN                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ARNG_DEFNITION  - UJ                                    *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBARGDEF                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ARNG_ATTR       - UY                                    *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBARGATT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ARNG_OPTN_ATTR  - VH                                    *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBARGOPA                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ACCT_ATTRIBUTE  - YP                                    *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBACTATT                                                  
           END-EXEC.                                                            
                                                                        
P0726F******************************************************************        
P0726F*    CSS_AR_TRANS_HIST   - AR                                    *        
P0726F******************************************************************        
P0726F                                                                  
P0726F     EXEC SQL                                                             
P0726F        INCLUDE TBARHIST                                                  
P0726F     END-EXEC.                                                            
P0726F                                                                  
P0726C******************************************************************        
P0726C*    CSS_BILLING_HDR     - BI                                    *        
P0726C******************************************************************        
P0726C                                                                  
P0726C     EXEC SQL                                                             
P0726C        INCLUDE TBBLLHDR                                                  
P0726C     END-EXEC.                                                            
P0726C                                                                  
P0726C******************************************************************        
P0726C*    CSS_BILL_CRED_DET   - 1H                                    *        
P0726C******************************************************************        
P0726C                                                                  
P0726C     EXEC SQL                                                             
P0726C        INCLUDE TBCRBLDL                                                  
P0726C     END-EXEC.                                                            
P0726C                                                                  
P0726E******************************************************************        
P0726E*    CSS_BILL_WINDOW     - BN                                    *        
P0726E******************************************************************        
P0726E                                                                  
P0726E     EXEC SQL                                                     06460000
P0726E        INCLUDE TBBILWDW                                          06470000
P0726E     END-EXEC.                                                    06480000
P0726E                                                                  
      ******************************************************************        
      *    CSS_BUS_RULE_XREF   - IT                                    *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     06460000
              INCLUDE TBRULXRF                                          06470000
           END-EXEC.                                                    06480000
                                                                        
P0726F******************************************************************        
P0726F*    CSS_BUDGET_HIST     - BH                                    *        
P0726F******************************************************************        
P0726F                                                                  
P0726F     EXEC SQL                                                             
P0726F        INCLUDE TBBGTHST                                                  
P0726F     END-EXEC.                                                            
P0726F                                                                  
P0726E******************************************************************        
P0726E*    CSS_CRED_ARNGMENT   - X1                                    *        
P0726E******************************************************************        
P0726E*                                                                         
P0726E     EXEC SQL                                                             
P0726E         INCLUDE TBCRARNG                                                 
P0726E     END-EXEC.                                                            
P0726E*                                                                         
P0726E******************************************************************06330000
P0726E*    CSS_CRED_FORECAST   - CM                                    *06340000
P0726E******************************************************************06350000
P0726E                                                                  
P0726E     EXEC SQL                                                     01763000
P0726E         INCLUDE TBCRFCST                                         01764000
P0726E     END-EXEC.                                                    01765000
P0726E                                                                  
P0726E******************************************************************        
P0726E*    CSS_CREDIT_PROFILE  - CZ                                    *        
P0726E******************************************************************        
P0726E                                                                  
P0726E     EXEC SQL                                                             
P0726E          INCLUDE TBCRPROF                                                
P0726E     END-EXEC.                                                            
P0726E                                                                  
      ******************************************************************        
      *    CSS_CUST_STATS      - CE                                    *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCSTSTS                                                  
           END-EXEC.                                                            
                                                                        
P0726F******************************************************************        
P0726F*    CSS_CUST_ALERT      - CA                                    *        
P0726F******************************************************************        
P0726F                                                                  
P0726F     EXEC SQL                                                             
P0726F        INCLUDE TBCSTALT                                                  
P0726F     END-EXEC.                                                            
P0726F                                                                  
P0726F******************************************************************        
P0726F*    CSS_CATEGORY        - F5                                    *        
P0726F******************************************************************        
P0726F                                                                  
P0726F     EXEC SQL                                                             
P0726F        INCLUDE TBCAT                                                     
P0726F     END-EXEC.                                                            
P0726F                                                                  
P0726F******************************************************************        
P0726F*    CSS_DFA_ACCT        - DA                                    *        
P0726F******************************************************************        
P0726F                                                                  
P0726F     EXEC SQL                                                             
P0726F        INCLUDE TBDFAACT                                                  
P0726F     END-EXEC.                                                            
P0726F                                                                  
P0726E******************************************************************06330000
P0726E*    CSS_DELINQUENCY     - C8                                    *06340000
P0726E******************************************************************06350000
P0726E                                                                  
P0726E     EXEC SQL                                                     06370000
P0726E        INCLUDE TBDELQ                                            06380000
P0726E     END-EXEC.                                                    06390000
P0726E                                                                  
P0726F******************************************************************        
P0726F*    CSS_FINAL_WO        - FW                                    *        
P0726F******************************************************************        
P0726F                                                                  
P0726F     EXEC SQL                                                             
P0726F        INCLUDE TBFINLWO                                                  
P0726F     END-EXEC.                                                            
P0726F                                                                  
P0726F******************************************************************        
P0726F*    CSS_FIN_WO_ACTION   - KD                                    *        
P0726F******************************************************************        
P0726F                                                                  
P0726F     EXEC SQL                                                             
P0726F        INCLUDE TBFWACTN                                                  
P0726F     END-EXEC.                                                            
P0726F                                                                  
P0726C******************************************************************        
P0726C*    CSS_JOB_PARM        - G6                                    *        
P0726C******************************************************************        
P0726C                                                                  
P0726C     EXEC SQL                                                             
P0726C        INCLUDE TBJBPARM                                                  
P0726C     END-EXEC.                                                            
P0726C                                                                  
      ******************************************************************        
      *    CSS_ROOMMATE        - RO                                    *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBROOMT                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_REG_PROFILE     - LR                                    *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBREGPRF                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_READ_WINDOW     - RW                                    *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE TBRDWNDW                                                 
           END-EXEC.                                                            
                                                                        
P0726F******************************************************************        
P0726F*    CSS_SO_DATA         - VO                                    *        
P0726F******************************************************************        
P0726F                                                                  
P0726F     EXEC SQL                                                             
P0726F        INCLUDE TBSODAT                                                   
P0726F     END-EXEC.                                                            
P0726F                                                                  
P0726F******************************************************************        
      *    CSS_UTIL_ENVRNMT    - UT                                    *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE TBUTLENV                                                 
           END-EXEC.                                                            
                                                                        
P00948******************************************************************        
P00948*    CSS_CRED_ARNG_HIST WY - WY                                  *        
P00948******************************************************************        
P00948                                                                  
P00948     EXEC SQL                                                             
P00948         INCLUDE TBCRARHS                                                 
P00948     END-EXEC.                                                            
P00948                                                                  
P00948******************************************************************        
P00948*    CSS_CRED_ARNG_ACTN - 4W                                     *        
P00948******************************************************************        
P00948                                                                  
P00948     EXEC SQL                                                             
P00948         INCLUDE TBCRDACT                                                 
P00948     END-EXEC.                                                            
P00948                                                                  
      ******************************************************************        
      * ERROR HANDLING                                                 *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * SUPPORTS DB2 AND SQL ERROR CHECKING                            *        
      ******************************************************************        
                                                                        
           COPY CWS00303.                                                       
                                                                        
           COPY CWS00056.                                               01680000
                                                                        
      ******************************************************************        
      * WORKING STORAGE COPYBOOKS FOR CPD00068                         *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS00068                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * WORKING STORAGE COPYBOOKS FOR CPD00309                         *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     01720000
              INCLUDE CWS00309                                          01730000
           END-EXEC.                                                    01740000
                                                                        
P0726E******************************************************************        
P0726E* WORKING STORAGE COPYBOOKS FOR CPD00322                         *        
P0726E******************************************************************        
P0726E                                                                  
P0726E     EXEC SQL                                                             
P0726E         INCLUDE CWS00322                                                 
P0726E     END-EXEC.                                                            
P0726E                                                                  
P0726E******************************************************************        
P0726E* WORKING STORAGE COPYBOOKS FOR CPD00334                         *        
P0726E******************************************************************        
P0726E                                                                  
P0726E     EXEC SQL                                                             
P0726E         INCLUDE CWS00334                                                 
P0726E     END-EXEC.                                                            
P0726E                                                                  
      ******************************************************************        
      * WORKING STORAGE COPYBOOKS FOR CPDKR361                         *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     01720000
              INCLUDE CWSKR361                                          01730000
           END-EXEC.                                                    01740000
                                                                        
      ******************************************************************        
      *    DECLARE CURSOR TO GET ALL RECEIVABLES                       *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
              DECLARE ARNG_DTLS CURSOR FOR                              
                 SELECT UJ.ARNG_ID                                      
                       ,UJ.ARNG_TYPE                                    
                       ,UJ.ARNG_STATUS_CD                               
                       ,UJ.ARNG_DESC                                    
                       ,UJ.ARNG_BILL_OPTN_CD                            
                       ,UJ.UTIL_NONUTIL_CD                              
                       ,UJ.RECVBLE_DEFER_CD                             
                       ,UJ.ARNG_FREQ_CD                                 
                       ,UJ.SEASONAL_FL                                  
                       ,UJ.INSTALLMENT_FL                               
                       ,UJ.ARNG_DROP_FL                                 
                       ,UF.PLAN_TERM_CD                                 
                       ,UF.PLAN_TERM_MIN                                
                       ,UF.PLAN_TERM_MAX                                
                       ,UF.PLAN_TERM_MAX_OVRD                           
                       ,UF.SEASON_START_DDMM                            
                       ,UF.SEASON_END_DDMM                              
                       ,UF.PATH_START_CD                                
                       ,UF.LPC_ASSESS_CD                                
                       ,UF.ARNG_AMOUNT_CD                               
                       ,UF.ARNG_PLAN_DESC                               
                       ,UF.NSF_ALLOWED_FL                               
                       ,UD.ACTN_PATH_TYPE_CD                            
                       ,UD.TERM_OPTION_SEQ                              
                       ,UD.ARNG_GRACE_PERIOD                            
                       ,UD.ARNG_PRIORITY                                
                       ,UD.DAY_COUNT_TYPE_CD                            
                       ,UD.ARNG_CHANNEL_CD                              
                       ,UF.ARNG_PLAN_ID                                 
                       ,UD.ARNG_OPTION_ID                               
P0726E                 ,UD.CREDIT_GROUP_CD                              
P0726E                 ,UD.CRED_ACTN_EXIST_CD                           
P0726E                 ,UD.OPTION_TERM_CD                               
                   FROM CSS_ARNG_DEFNITION UJ WITH(READUNCOMMITTED)             
                       ,CSS_ARNG_PLAN      UF WITH(READUNCOMMITTED)             
                       ,CSS_ARNG_OPTION    UD WITH(READUNCOMMITTED)             
                  WHERE UJ.ARNG_ID             = UF.ARNG_ID             
                    AND UF.ARNG_PLAN_ID        = UD.ARNG_PLAN_ID        
                    AND UJ.ARNG_STATUS_CD      = 'A'                    
                    AND UF.COMPANY_NO          = :AT-COMPANY-NO         
                    AND UF.REG_GROUP_CD        = :WS-REG-GROUP-CD       
                    AND UF.ARNG_PLAN_EFF_DT   <= IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )       
                    AND UF.ARNG_PLAN_EXP_DT   >= IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )       
                    AND UD.ARNG_OPTION_EFF_DT <= IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )       
                    AND UD.ARNG_OPTION_EXP_DT >= IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )       
P0726F              AND UD.ARNG_CHANNEL_CD     = :WS-ARNG-CHANNEL-CODE  
                    FOR READ ONLY                                      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE ARNG_DTLS CURSOR FOR                                      
MFA-TR*          SELECT UJ.ARNG_ID                                              
MFA-TR*                ,UJ.ARNG_TYPE                                            
MFA-TR*                ,UJ.ARNG_STATUS_CD                                       
MFA-TR*                ,UJ.ARNG_DESC                                            
MFA-TR*                ,UJ.ARNG_BILL_OPTN_CD                                    
MFA-TR*                ,UJ.UTIL_NONUTIL_CD                                      
MFA-TR*                ,UJ.RECVBLE_DEFER_CD                                     
MFA-TR*                ,UJ.ARNG_FREQ_CD                                         
MFA-TR*                ,UJ.SEASONAL_FL                                          
MFA-TR*                ,UJ.INSTALLMENT_FL                                       
MFA-TR*                ,UJ.ARNG_DROP_FL                                         
MFA-TR*                ,UF.PLAN_TERM_CD                                         
MFA-TR*                ,UF.PLAN_TERM_MIN                                        
MFA-TR*                ,UF.PLAN_TERM_MAX                                        
MFA-TR*                ,UF.PLAN_TERM_MAX_OVRD                                   
MFA-TR*                ,UF.SEASON_START_DDMM                                    
MFA-TR*                ,UF.SEASON_END_DDMM                                      
MFA-TR*                ,UF.PATH_START_CD                                        
MFA-TR*                ,UF.LPC_ASSESS_CD                                        
MFA-TR*                ,UF.ARNG_AMOUNT_CD                                       
MFA-TR*                ,UF.ARNG_PLAN_DESC                                       
MFA-TR*                ,UF.NSF_ALLOWED_FL                                       
MFA-TR*                ,UD.ACTN_PATH_TYPE_CD                                    
MFA-TR*                ,UD.TERM_OPTION_SEQ                                      
MFA-TR*                ,UD.ARNG_GRACE_PERIOD                                    
MFA-TR*                ,UD.ARNG_PRIORITY                                        
MFA-TR*                ,UD.DAY_COUNT_TYPE_CD                                    
MFA-TR*                ,UD.ARNG_CHANNEL_CD                                      
MFA-TR*                ,UF.ARNG_PLAN_ID                                         
MFA-TR*                ,UD.ARNG_OPTION_ID                                       
MFA-TR*                ,UD.CREDIT_GROUP_CD                                      
MFA-TR*                ,UD.CRED_ACTN_EXIST_CD                                   
MFA-TR*                ,UD.OPTION_TERM_CD                                       
MFA-TR*            FROM CSS_ARNG_DEFNITION UJ                                   
MFA-TR*                ,CSS_ARNG_PLAN      UF                                   
MFA-TR*                ,CSS_ARNG_OPTION    UD                                   
MFA-TR*           WHERE UJ.ARNG_ID             = UF.ARNG_ID                     
MFA-TR*             AND UF.ARNG_PLAN_ID        = UD.ARNG_PLAN_ID                
MFA-TR*             AND UJ.ARNG_STATUS_CD      = 'A'                            
MFA-TR*             AND UF.COMPANY_NO          = :AT-COMPANY-NO                 
MFA-TR*             AND UF.REG_GROUP_CD        = :WS-REG-GROUP-CD               
MFA-TR*             AND UF.ARNG_PLAN_EFF_DT   <= :WS-CURRENT-DATE               
MFA-TR*             AND UF.ARNG_PLAN_EXP_DT   >= :WS-CURRENT-DATE               
MFA-TR*             AND UD.ARNG_OPTION_EFF_DT <= :WS-CURRENT-DATE               
MFA-TR*             AND UD.ARNG_OPTION_EXP_DT >= :WS-CURRENT-DATE               
MFA-TR*             AND UD.ARNG_CHANNEL_CD     = :WS-ARNG-CHANNEL-CODE          
MFA-TR*             FOR FETCH ONLY                                              
MFA-TR*            WITH UR                                                      
MFA-TR*         QUERYNO 7510                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    DECLARE CURSOR TO GET ALL RULE DTLS                         *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
              DECLARE RULE_CURSOR CURSOR FOR                            
               SELECT BUS_RULE_ID,                                      
                      REPLACE(REPLACE(CONVERT(CHAR(26), BUS_RULE_XREF_ID
           , 121), ' ', '-'), ':', '.') BUS_RULE_XREF_ID,                      
                      COMPANY_NO                                        
                 FROM CSS_BUS_RULE_XREF WITH(READUNCOMMITTED)                   
                WHERE BUS_PROCESS_ID      = 'CREDITARNG'                
                  AND APPLICATION_ID      = 'CSR'                       
P0726F            AND RULE_EFFECTIVE_DT  <= IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )            
P0726F            AND RULE_EXPIRATION_DT >= IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )            
P0726K            ORDER BY BUS_RULE_ID ASC                              
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE RULE_CURSOR CURSOR FOR                                    
MFA-TR*        SELECT BUS_RULE_ID,                                              
MFA-TR*               BUS_RULE_XREF_ID,                                         
MFA-TR*               COMPANY_NO                                                
MFA-TR*          FROM CSS_BUS_RULE_XREF                                         
MFA-TR*         WHERE BUS_PROCESS_ID      = 'CREDITARNG'                        
MFA-TR*           AND APPLICATION_ID      = 'CSR'                               
MFA-TR*           AND RULE_EFFECTIVE_DT  <= :WS-CURRENT-DATE                    
MFA-TR*           AND RULE_EXPIRATION_DT >= :WS-CURRENT-DATE                    
MFA-TR*           ORDER BY BUS_RULE_ID ASC                                      
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*       QUERYNO 7540                                                      
MFA-TR*    END-EXEC.                                                            
      ******************************************************************        
      *    DECLARE CURSOR TO GET ALL SSN DETAILS.                      *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
              DECLARE ROOMMATE_CURSOR CURSOR FOR                        
               SELECT CE.SSN                                            
                 FROM CSS_ROOMMATE   RO WITH(READUNCOMMITTED)                   
                     ,CSS_CUST_STATS CE WITH(READUNCOMMITTED)                   
                WHERE RO.ACCOUNT_NO     = :AT-ACCOUNT-NO                
                  AND CE.CUSTOMER_NO    = RO.CUSTOMER_NO                
                  AND CE.CUSTOMER_TYPE  = :CE-CUSTOMER-TYPE             
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE ROOMMATE_CURSOR CURSOR FOR                                
MFA-TR*        SELECT CE.SSN                                                    
MFA-TR*          FROM CSS_ROOMMATE   RO                                         
MFA-TR*              ,CSS_CUST_STATS CE                                         
MFA-TR*         WHERE RO.ACCOUNT_NO     = :AT-ACCOUNT-NO                        
MFA-TR*           AND CE.CUSTOMER_NO    = RO.CUSTOMER_NO                        
MFA-TR*           AND CE.CUSTOMER_TYPE  = :CE-CUSTOMER-TYPE                     
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*       QUERYNO 7570                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
P0726E******************************************************************        
P0726E* Declare cursor to get all the open and closed bill dates.      *        
P0726E******************************************************************        
P0726E                                                                  
P0726E     EXEC SQL                                                     
P0726E        DECLARE BILL-WINDOW CURSOR FOR                            
P0726E         SELECT BN.DATE_EXTRACT                                   
P0726E               ,BN.CODE_BILL_COND                                 
P0726E           FROM CSS_BILL_WINDOW BN WITH(READUNCOMMITTED)                  
P0726E          WHERE BN.BILL_CYCLE    = :AT-BILL-CYCLE                 
P0726E            AND BN.REVENUE_MONTH = :WS-REV-MTH-LST-NRML           
P0726E          ORDER BY BN.DATE_EXTRACT ASC                            
P0726E            FOR READ ONLY                                 
P0726E                                                      
P0726E     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE BILL-WINDOW CURSOR FOR                                    
MFA-TR*        SELECT BN.DATE_EXTRACT                                           
MFA-TR*              ,BN.CODE_BILL_COND                                         
MFA-TR*          FROM CSS_BILL_WINDOW BN                                        
MFA-TR*         WHERE BN.BILL_CYCLE    = :AT-BILL-CYCLE                         
MFA-TR*           AND BN.REVENUE_MONTH = :WS-REV-MTH-LST-NRML                   
MFA-TR*         ORDER BY BN.DATE_EXTRACT ASC                                    
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*       QUERYNO 7600                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-ACCOUNT-NO             PIC 9(13).                       
       01  PARM-ARNG-CHANNEL-CD        PIC X(02).                       
       01  PARM-BUS-RULES-RTN-FL       PIC X(01).                       
                                                                        
       PROCEDURE DIVISION USING PARM-ACCOUNT-NO                         
                                PARM-ARNG-CHANNEL-CD                    
                                PARM-BUS-RULES-RTN-FL.                  
                                                                        
      ******************************************************************        
      * 0000-MAINLINE.                                                 *        
      * CONTROLS THE MAIN PATH OF THE PROGRAM                          *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE          THRU 0100-EXIT.             
           PERFORM 1000-PROCESS-INPUT       THRU 1000-EXIT.             
           PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT.             
           PERFORM 9999-END-PROGRAM         THRU 9999-EXIT.             
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1     THRU 0100A-EXIT.            
           PERFORM 0100B-DECLARE-GTT-R2     THRU 0100B-EXIT.            
           PERFORM 0100C-DECLARE-GTT-R3     THRU 0100C-EXIT.            
                                                                        
P0726E* TO IDENTIFY THE DATA BASE                                               
P0726E     MOVE '01'                        TO C8-COMPANY-NO.           
P0726E     MOVE 'DATABASE'                  TO C8-DELINQ-CD.            
P0726E     PERFORM 7010-GET-DLINQ-VAL       THRU 7010-EXIT              
P0726E     MOVE C8-DELINQ-VALUE             TO WS-DATABASE.             
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100A-DECLARE-GTT-R1                                           *        
      ******************************************************************        
                                                                        
       0100A-DECLARE-GTT-R1.                                            
                                                                        
           MOVE 'SESSION.CSR04628_R1'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04628_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04628_R1
              (                                                          
                  RETURN_CODE           INT                         
P0726E           ,ARNG_ID CHAR(05)  COLLATE LATIN1_GENERAL_100_BIN2             
P0726E           ,APPL_RETURN_CODE CHAR(05)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                        
P0726E           ,ARNG_TYPE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2           
P0726E           ,ARNG_TERM_CD CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2        
P0726E           ,ARNG_OPTION_ID        SMALLINT                        
P00948           ,ARNG_PRIORITY         SMALLINT                        
                 ,STA_AMOUNT            DECIMAL(11,2)                   
                 ,NEW_STA_DUE_DATE CHAR(10)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                        
                 ,NEW_STA_DNP_DATE CHAR(10)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                        
P0726J           ,CREDIT_ACTION_FL CHAR(01)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                        
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE   = SUCCESSFUL-CALL              
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE '0100A'               TO ACTIVE-PARAGRAPH         
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
               SELECT                                                   
                  RETURN_CODE                                           
P0726E           ,APPL_RETURN_CODE          AS APPL_RETURN_CODE         
P0726E           ,LTRIM(RTRIM(ARNG_ID))            AS ARNG_ID                  
P0726E           ,LTRIM(RTRIM(ARNG_TYPE))          AS ARNG_TYPE                
P0726E           ,LTRIM(RTRIM(ARNG_TERM_CD))       AS ARNG_TERM_CD             
P0726E           ,LTRIM(RTRIM(ARNG_OPTION_ID))     AS ARNG_OPTION_ID           
                 ,STA_AMOUNT                AS STA_AMOUNT               
                 ,LTRIM(RTRIM(NEW_STA_DUE_DATE))   AS NEW_STA_DUE_DATE         
                 ,LTRIM(RTRIM(NEW_STA_DNP_DATE))   AS NEW_STA_DNP_DATE         
P0726J           ,LTRIM(RTRIM(CREDIT_ACTION_FL))   AS CREDIT_ACTION_FL         
P00948           ,ARNG_PRIORITY             AS ARNG_PRIORITY            
               FROM #CSR04628_R1                                 
P00948         ORDER BY NEW_STA_DUE_DATE                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*        SELECT                                                           
MFA-TR*           RETURN_CODE                                                   
MFA-TR*          ,APPL_RETURN_CODE          AS APPL_RETURN_CODE                 
MFA-TR*          ,STRIP(ARNG_ID)            AS ARNG_ID                          
MFA-TR*          ,STRIP(ARNG_TYPE)          AS ARNG_TYPE                        
MFA-TR*          ,STRIP(ARNG_TERM_CD)       AS ARNG_TERM_CD                     
MFA-TR*          ,STRIP(ARNG_OPTION_ID)     AS ARNG_OPTION_ID                   
MFA-TR*          ,STA_AMOUNT                AS STA_AMOUNT                       
MFA-TR*          ,STRIP(NEW_STA_DUE_DATE)   AS NEW_STA_DUE_DATE                 
MFA-TR*          ,STRIP(NEW_STA_DNP_DATE)   AS NEW_STA_DNP_DATE                 
MFA-TR*          ,STRIP(CREDIT_ACTION_FL)   AS CREDIT_ACTION_FL                 
MFA-TR*          ,ARNG_PRIORITY             AS ARNG_PRIORITY                    
MFA-TR*        FROM SESSION.CSR04628_R1                                         
MFA-TR*        ORDER BY NEW_STA_DUE_DATE                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
P00948     EXEC SQL                                                     
P00948         DECLARE C1_IVR_WEB CURSOR                     
P00948                                   WITH ROWSET POSITIONING FOR    
P00948         SELECT TOP(2) * FROM #CSR04628_R1                        
P00948         ORDER BY ARNG_PRIORITY DESC                              
P00948                                           
P00948     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1_IVR_WEB CURSOR WITH RETURN                            
MFA-TR*                                  WITH ROWSET POSITIONING FOR            
MFA-TR*        SELECT * FROM SESSION.CSR04628_R1                                
MFA-TR*        ORDER BY ARNG_PRIORITY DESC                                      
MFA-TR*        FETCH FIRST 2 ROWS ONLY                                          
MFA-TR*    END-EXEC.                                                            
P00948                                                                  
       0100A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100B-DECLARE-GTT-R2                                           *        
      ******************************************************************        
       0100B-DECLARE-GTT-R2.                                            
                                                                        
           MOVE 'SESSION.CSR04628_R2'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04628_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04628_R2
              (                                                          
                  RETURN_CODE               INT                     
                 ,ARNG_ID CHAR(05)  COLLATE LATIN1_GENERAL_100_BIN2             
                 ,ARNG_TYPE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2           
                 ,ARNG_CHANNEL_CD CHAR(02)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                    
                 ,ARNG_TOTAL_AMT            DECIMAL(11,2)              
                 ,ARNG_DUE_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2         
                 ,ORIG_DUE_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2         
                 ,TOTAL_AR_BALANCE          DECIMAL(11,2)              
                 ,TOTAL_UTL_BALANCE         DECIMAL(11,2)              
                 ,TOTAL_NONUTL_BALANCE      DECIMAL(11,2)              
                 ,UTL_ARREARS_AMT           DECIMAL(11,2)              
                 ,NONUTL_ARREARS_AMT        DECIMAL(11,2)              
                 ,SSN_CUST CHAR(04)  COLLATE LATIN1_GENERAL_100_BIN2            
                 ,SSN_SPOUSE CHAR(04)  COLLATE LATIN1_GENERAL_100_BIN2          
                 ,SSN_ROOMMATE1 CHAR(04)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                    
                 ,SSN_ROOMMATE2 CHAR(04)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                    
                 ,SSN_ROOMMATE3 CHAR(04)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                    
P0726F           ,ORIGINAL_DNP_TYPE CHAR(01)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                    
P0726F           ,ORIGINAL_DNP_DATE CHAR(10)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                    
P0726F           ,FIRST_NOTICE_MAIL_DT CHAR(10)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                    
P0726F           ,FINAL_NOTICE_MAIL_DT CHAR(10)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                    
P0726M           ,LAST_UPDATE_TS CHAR(26)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                    
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000B-DELETE-GTT-ROWS THRU 8000B-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE   = SUCCESSFUL-CALL              
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE '0100B'               TO ACTIVE-PARAGRAPH         
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C2 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
               SELECT                                                   
                  RETURN_CODE                                           
                 ,LTRIM(RTRIM(ARNG_ID))            AS ARNG_ID                  
                 ,LTRIM(RTRIM(ARNG_TYPE))          AS ARNG_TYPE                
                 ,LTRIM(RTRIM(ARNG_CHANNEL_CD))    AS ARNG_CHANNEL_CD          
                 ,ARNG_TOTAL_AMT            AS ARNG_TOTAL_AMT           
                 ,LTRIM(RTRIM(ARNG_DUE_DT))        AS ARNG_DUE_DT              
                 ,LTRIM(RTRIM(ORIG_DUE_DT))        AS ORIG_DUE_DT              
                 ,TOTAL_AR_BALANCE          AS TOTAL_AR_BALANCE         
                 ,TOTAL_UTL_BALANCE         AS TOTAL_UTL_BALANCE        
                 ,TOTAL_NONUTL_BALANCE      AS TOTAL_NONUTL_BALANCE     
                 ,UTL_ARREARS_AMT           AS UTL_ARREARS_AMT          
                 ,NONUTL_ARREARS_AMT        AS NONUTL_ARREARS_AMT       
                 ,SSN_CUST                  AS SSN_CUST                 
                 ,SSN_SPOUSE                AS SSN_SPOUSE               
                 ,SSN_ROOMMATE1             AS SSN_ROOMMATE1            
                 ,SSN_ROOMMATE2             AS SSN_ROOMMATE2            
                 ,SSN_ROOMMATE3             AS SSN_ROOMMATE3            
P0726F           ,LTRIM(RTRIM(ORIGINAL_DNP_TYPE))  AS ORIGINAL_DNP_TYPE        
P0726F           ,LTRIM(RTRIM(ORIGINAL_DNP_DATE))  AS ORIGINAL_DNP_DATE        
P0726F           ,LTRIM(RTRIM(FIRST_NOTICE_MAIL_DT))  AS 
           FIRST_NOTICE_MAIL_DT  
P0726F           ,LTRIM(RTRIM(FINAL_NOTICE_MAIL_DT))  AS 
           FINAL_NOTICE_MAIL_DT  
P0726M           ,LTRIM(RTRIM(LAST_UPDATE_TS))        AS LAST_UPDATE_TS        
               FROM #CSR04628_R2                                 
P00948         ORDER BY ARNG_DUE_DT                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C2 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*        SELECT                                                           
MFA-TR*           RETURN_CODE                                                   
MFA-TR*          ,STRIP(ARNG_ID)            AS ARNG_ID                          
MFA-TR*          ,STRIP(ARNG_TYPE)          AS ARNG_TYPE                        
MFA-TR*          ,STRIP(ARNG_CHANNEL_CD)    AS ARNG_CHANNEL_CD                  
MFA-TR*          ,ARNG_TOTAL_AMT            AS ARNG_TOTAL_AMT                   
MFA-TR*          ,STRIP(ARNG_DUE_DT)        AS ARNG_DUE_DT                      
MFA-TR*          ,STRIP(ORIG_DUE_DT)        AS ORIG_DUE_DT                      
MFA-TR*          ,TOTAL_AR_BALANCE          AS TOTAL_AR_BALANCE                 
MFA-TR*          ,TOTAL_UTL_BALANCE         AS TOTAL_UTL_BALANCE                
MFA-TR*          ,TOTAL_NONUTL_BALANCE      AS TOTAL_NONUTL_BALANCE             
MFA-TR*          ,UTL_ARREARS_AMT           AS UTL_ARREARS_AMT                  
MFA-TR*          ,NONUTL_ARREARS_AMT        AS NONUTL_ARREARS_AMT               
MFA-TR*          ,SSN_CUST                  AS SSN_CUST                         
MFA-TR*          ,SSN_SPOUSE                AS SSN_SPOUSE                       
MFA-TR*          ,SSN_ROOMMATE1             AS SSN_ROOMMATE1                    
MFA-TR*          ,SSN_ROOMMATE2             AS SSN_ROOMMATE2                    
MFA-TR*          ,SSN_ROOMMATE3             AS SSN_ROOMMATE3                    
MFA-TR*          ,STRIP(ORIGINAL_DNP_TYPE)  AS ORIGINAL_DNP_TYPE                
MFA-TR*          ,STRIP(ORIGINAL_DNP_DATE)  AS ORIGINAL_DNP_DATE                
MFA-TR*          ,STRIP(FIRST_NOTICE_MAIL_DT)  AS FIRST_NOTICE_MAIL_DT          
MFA-TR*          ,STRIP(FINAL_NOTICE_MAIL_DT)  AS FINAL_NOTICE_MAIL_DT          
MFA-TR*          ,STRIP(LAST_UPDATE_TS)        AS LAST_UPDATE_TS                
MFA-TR*        FROM SESSION.CSR04628_R2                                         
MFA-TR*        ORDER BY ARNG_DUE_DT                                             
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100B-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100C-DECLARE-GTT-R3                                           *        
      ******************************************************************        
                                                                        
       0100C-DECLARE-GTT-R3.                                            
                                                                        
           MOVE 'SESSION.CSR04628_R3'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04628_R3')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04628_R3
              (                                                          
                  RETURN_CODE               INT                     
P0726E           ,ARNG_ID CHAR(05)  COLLATE LATIN1_GENERAL_100_BIN2             
P0726E           ,RULE_NOTIFY_TYPE_CD CHAR(01)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                    
                 ,BUS_RULE_ID CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2         
                 ,RULE_RESULT_CD CHAR(10)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                    
                 ,BUS_RULE_XREF_ID CHAR(26)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                    
                 ,MESSAGE_PARMS CHAR(200)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                   
                 ,LINK_PARMS CHAR(200)  COLLATE LATIN1_GENERAL_100_BIN2         
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000C-DELETE-GTT-ROWS THRU 8000C-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE   = SUCCESSFUL-CALL              
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE '0100C'               TO ACTIVE-PARAGRAPH         
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C3 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
               SELECT                                                   
                  RETURN_CODE                                           
P0726E           ,LTRIM(RTRIM(ARNG_ID))            AS ARNG_ID                  
P0726E           ,LTRIM(RTRIM(RULE_NOTIFY_TYPE_CD)) AS 
           RULE_NOTIFY_TYPE_CD     
                 ,LTRIM(RTRIM(BUS_RULE_ID))        AS BUS_RULE_ID              
                 ,LTRIM(RTRIM(RULE_RESULT_CD))     AS RULE_RESULT_CD           
                 ,LTRIM(RTRIM(BUS_RULE_XREF_ID))   AS BUS_RULE_XREF_ID         
                 ,LTRIM(RTRIM(MESSAGE_PARMS))      AS MESSAGE_PARMS            
                 ,LTRIM(RTRIM(LINK_PARMS))         AS LINK_PARMS               
               FROM #CSR04628_R3                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C3 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*        SELECT                                                           
MFA-TR*           RETURN_CODE                                                   
MFA-TR*          ,STRIP(ARNG_ID)            AS ARNG_ID                          
MFA-TR*          ,STRIP(RULE_NOTIFY_TYPE_CD) AS RULE_NOTIFY_TYPE_CD             
MFA-TR*          ,STRIP(BUS_RULE_ID)        AS BUS_RULE_ID                      
MFA-TR*          ,STRIP(RULE_RESULT_CD)     AS RULE_RESULT_CD                   
MFA-TR*          ,STRIP(BUS_RULE_XREF_ID)   AS BUS_RULE_XREF_ID                 
MFA-TR*          ,STRIP(MESSAGE_PARMS)      AS MESSAGE_PARMS                    
MFA-TR*          ,STRIP(LINK_PARMS)         AS LINK_PARMS                       
MFA-TR*        FROM SESSION.CSR04628_R3                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100c-EXIT.                                                      
           EXIT.                                                        
                                                                        
P0726E******************************************************************        
P0726E* 0110-LOAD-BILL-WINDOW                                         *         
P0726E******************************************************************        
P0726E                                                                  
P0726E 0110-LOAD-BILL-WINDOW.                                           
P0726E                                                                  
P0726E     PERFORM 7590-OPEN-BILL-WINDOW-CSR            THRU 7590-EXIT. 
P0726E     PERFORM 7600-FETCH-BILL-WINDOW-CSR           THRU 7600-EXIT. 
P0726E     PERFORM VARYING WS-BILL-SUB FROM 1 BY 1                      
P0726E       UNTIL SQLCODE = NOT-FOUND                                  
P0726E       ADD 1                  TO WS-BN-COUNT                      
P0726E       MOVE BN-DATE-EXTRACT   TO WS-DATE-EXTRACT-TB(WS-BILL-SUB)  
P0726E       MOVE BN-CODE-BILL-COND TO WS-CODE-BILL-COND-TB(WS-BILL-SUB)
P0726E       PERFORM 7600-FETCH-BILL-WINDOW-CSR         THRU 7600-EXIT  
P0726E     END-PERFORM.                                                 
P0726E     PERFORM 7610-CLOSE-BILL-WINDOW-CSR           THRU 7610-EXIT. 
P0726E                                                                  
P0726E 0110-EXIT.                                                       
P0726E     EXIT.                                                        
P0726E                                                                  
      ******************************************************************        
      * 1000-PROCESS-INPUT.                                            *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
                                                                        
           INITIALIZE WS-SSN-CUST                                       
                      WS-SSN-SPOUSE                                     
                      WS-SSN-ROOMMATE1                                  
                      WS-SSN-ROOMMATE2                                  
                      WS-SSN-ROOMMATE3.                                 
                                                                        
P0726G     MOVE 'N'                           TO WS-GROUP1-TO-GROUP2-FL.
P0726F     MOVE SPACES                        TO ws-STA-ARNG-CMPLD-IND. 
P0726F     MOVE ZEROES                        TO WS-LAST-ARNG-DAYS.     
           MOVE PARM-ACCOUNT-NO               TO AT-ACCOUNT-NO          
P0726C                                           BI-ACCOUNT-NO          
P0726D                                           AC-ACCOUNT-NO          
P0726C                                           1H-ACCOUNT-NO          
P0726E                                           X1-ACCOUNT-NO          
P0726E                                           LR-ACCOUNT-NO          
P0726E                                           CZ-ACCOUNT-NO          
P0726F                                           VO-ACCOUNT-NO          
P0726F                                           FW-ACCOUNT-NO          
P0726F                                           DA-ACCOUNT-NO          
P0726F                                           AR-ACCOUNT-NO          
P0726F                                           YP-ACCOUNT-NO          
P0726F                                           BH-ACCOUNT-NO          
P0726F                                           CA-ACCOUNT-NO          
P00948                                           WY-ACCOUNT-NO          
P00948                                           4W-ACCOUNT-NO.         
P0726F     MOVE PARM-ARNG-CHANNEL-CD          TO WS-ARNG-CHANNEL-CODE.  
P00948     MOVE PARM-BUS-RULES-RTN-FL         TO WS-BUS-RULES-RTN-FL.   
                                                                        
P0726E     PERFORM 7000-SELECT-ACCOUNT        THRU 7000-EXIT.           
P00948     PERFORM 7270-SEL-ACTIVE-ARNG-TYPE  THRU 7270-EXIT.           
P00948     IF WS-ACTIVE-ARNG-TYPE = 'STAA'                              
P00948        MOVE X1-ARNG-ID                 TO 4W-ARNG-ID             
P00948        MOVE X1-CRED-ARNG-SEQ           TO 4W-CRED-ARNG-SEQ       
P00948        MOVE SPACES                     TO WS-STAA-PROCESSED-FL   
P00948        PERFORM 7290-SEL-PROCESSED-FL   THRU 7290-EXIT            
P00948     END-IF.                                                      
P0726E     MOVE AT-CODES-DATA-PRESENT         TO WS-CODES-DATA-PRESENT. 
P0726E     MOVE AT-CREDIT-GROUP               TO WS-CREDIT-GROUP        
P0726F                                           WS-FST-GROUP-CD.       
P0726F     MOVE AT-COMPANY-NO                 TO WS-COMPANY             
P0726F                                           CM-COMPANY-NO.         
P0726F     PERFORM 7050-GET-CURRENT-DATE      THRU 7050-EXIT.           
P0726E                                                                  
P0948A     IF WS-ACTIVE-ARNG-TYPE = SPACES                              
P0948A        MOVE 1                          TO WS-NO-OF-DAY           
P0948A        MOVE WS-CURRENT-DATE            TO WS-NEW-BUSINESS-DAY    
P0948A        PERFORM 6525-PREV-BUSINESS-DAY                            
P0948A           THRU 6525-PREV-BUSINESS-DAY-EXIT                       
P0948A        MOVE WS-NEW-BUSINESS-DAY        TO WS-DATE                
P0948A        MOVE WS-TIMESTAMP               TO X1-LAST-UPDATE-TS      
P0948A        MOVE 'A0005'                    TO X1-ARNG-ID             
P0948A        MOVE 'N'                        TO X1-ARNG-COMPLIANCE-CD  
P0948A        MOVE 'C'                        TO X1-ARNG-STATUS-CD      
P0948A        PERFORM 7300-SEL-CRED-ARNG      THRU 7300-EXIT            
P0948A        IF ARNG-COMPLIED                                          
P0948A           MOVE 'A0006'                 TO X1-ARNG-ID             
P0948A           PERFORM 7300-SEL-CRED-ARNG   THRU 7300-EXIT            
P0948A        END-IF                                                    
P0948A     END-IF.                                                      
P0726F* Populte util/non-util/past due details                                  
P0726F     MOVE 'Y' TO CALC-BALANCE-SW                                  
P0726F                 CALC-ARREARS-SW                                  
P0726F                 LOAD-DNP-DATE-SW                                 
P0726F                 CALC-PAST-DUE-SW.                                
P0726F     PERFORM 2100-CALL-MCSCB068                    THRU 2100-EXIT.
P0726E                                                                  
P0726F* Compliance hist process                                                 
P0726F     PERFORM 7280-SEL-LAST-ARNG-DT-CMPLNCE         THRU 7280-EXIT 
P0726F     PERFORM 7170-SELECT-DPP-COMPLIANCE            THRU 7170-EXIT 
P0726F                                                                  
P0726F     MOVE X1-ARNG-COMPLIANCE-CD      TO ws-STA-ARNG-CMPLD-IND     
P0726F     MOVE WS-LAST-ARNG-DAYS          TO WS-RECENT-STA-DAYS        
P0726E                                                                  
P0726F* Get Reg group cd for SEB                                                
P0726F     IF SEB-DATABASE                                              
P0726F        PERFORM 7070-SELECT-REG-GROUP-CD           THRU 7070-EXIT 
P0726F        MOVE WS-REG-GROUP-CD            TO WS-REG-GROUP           
P0726F        PERFORM 2490-COMPLIANCE-HIST-PROCESS       THRU 2490-EXIT 
P0726G        IF WS-REG                                                 
P0726G           MOVE 'FCST CR GP BALANCE' TO YP-ATTRIBUTE-DESC         
P0726G           PERFORM 7650-ACCOUNT-ATTRIBUTE THRU 7650-EXIT          
P0726G           IF WS-ACCT-ATTRIBUTE-FL = 'Y'                          
P0726G               MOVE 'Y' TO WS-GROUP1-TO-GROUP2-FL                 
P0726G           END-IF                                                 
P0726G        END-IF                                                    
P0726F     ELSE                                                         
P0726F        MOVE WS-DAY-STA-SECOND-MAIL-CD  TO C8-DELINQ-CD           
P0726F        MOVE AT-COMPANY-NO              TO C8-COMPANY-NO          
P0726F        PERFORM 7010-GET-DLINQ-VAL      THRU 7010-EXIT            
P0726F        MOVE  C8-DELINQ-VALUE           TO WS-DAY-STA-SECOND-MAIL 
P0726F     END-IF.                                                      
P0726F                                                                  
P0726K     MOVE WS-WQ-STA-START-TIME-CD       TO  C8-DELINQ-CD          
P0726K     PERFORM 7010-GET-DLINQ-VAL         THRU 7010-EXIT            
P0726K     MOVE C8-DELINQ-VALUE               TO WS-WQ-STA-START-TIME   
P0726K                                                                  
P0726F* Set DNP flag                                                            
P0726F     MOVE 'N' TO WS-DNP-FLAG                                      
P0726F                 WS-PENDING-SO-FLAG                               
P0726F                 WS-DNP-ACT-FLAG.                                 
P0726F     IF  WS-CODE-PENDING-DNP = 'A'                                
P0726F         MOVE 'DNP01'                   TO VO-ORDER-TYPE-CD       
P0726F         PERFORM 7150-SELECT-PENDING-SO THRU 7150-EXIT            
P0726F         MOVE  VO-ORDER-REASON          TO WS-DNP-TYPE            
P0726F         IF WS-PENDING-SO-FLAG = 'Y'                              
P0726F            MOVE 'Y'                    TO WS-DNP-FLAG            
P0726F         END-IF                                                   
P0726F     END-IF.                                                      
P0726F                                                                  
P0726F* Set Reconnect flag                                                      
P0726F     IF WS-DNP-FLAG = 'Y'                                         
P0726F        CONTINUE                                                  
P0726F     ELSE                                                         
P0726F        MOVE 'FM006'                    TO VO-ORDER-TYPE-CD       
P0726F        PERFORM 7150-SELECT-PENDING-SO  THRU 7150-EXIT            
P0726F         IF WS-PENDING-SO-FLAG = 'Y'                              
P0726F            MOVE 'Y'                    TO WS-DNP-ACT-FLAG        
P0726F         END-IF                                                   
P0726F     END-IF.                                                      
P0726F* Set STA004-DSP flag                                                     
P0726F     IF AT-TOTAL-AR-BALANCE < 0 OR (WS-DNP-ACT-FLAG = 'Y'         
P0726F        AND WS-PENDING-SO-FLAG = 'Y')                             
P0726F        MOVE 'Y'      TO WS-STA004-DSP                            
P0726F     END-IF                                                       
P0726F                                                                  
P0726F                                                                  
P0726F     PERFORM 2130-LOAD-CRED-ACT-DT      THRU 2130-EXIT.           
P0726F     IF WS-NEW-DNP-FL = 'Y'                                       
P0726F        IF WS-NO-CRED-ACT-ROWS = 1                                
P0726H           MOVE WS-NEAREST-DNP-TYPE     TO WS-ORIGINAL-DNP-TYPE   
P0726F           MOVE WS-NEAREST-DNP-DT       TO WS-ORIGINAL-DNP-DATE   
P0726F        ELSE                                                      
P0726F           PERFORM 7260-GET-FORCST-DT-SO           THRU 7260-EXIT 
P0726F           MOVE SPACES                  TO WS-ORIGINAL-DNP-TYPE   
P0726F           IF VO-WANTED-BY-DATETIME > SPACES                      
P0726F              MOVE VO-WANTED-BY-DATETIME(1:10) TO                 
P0726F                   WS-ORIGINAL-DNP-DATE                           
P0726F           ELSE                                                   
P0726F              MOVE SPACES               TO WS-ORIGINAL-DNP-DATE   
P0726F           END-IF                                                 
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726F                                                                  
P0726F* Populate Arrangement amount based on credit group/database              
P0726F     IF SEB-DATABASE AND AT-CREDIT-GROUP = 'B'                    
P0726F         MOVE WS-TOTAL-BALANCE-UTL      TO WS-STA-AMOUNT          
P0726F     ELSE                                                         
P0726F         MOVE WS-AMT-PAST-DUE-UTL       TO WS-STA-AMOUNT          
P0726F     END-IF.                                                      
P0726F                                                                  
P0726F* Load Business rules into temp table                                     
           PERFORM 7530-OPEN-RULE-CURSOR      THRU 7530-EXIT.           
           PERFORM 7540-FETCH-RULE-CURSOR     THRU 7540-EXIT.           
           SET T2-INDX                        TO 1.                     
P00948     SET T3-INDX                        TO 1.                     
           PERFORM 2210-LOAD-RULE-DTLS        THRU 2210-EXIT            
             UNTIL SQLCODE = NOT-FOUND                                  
           PERFORM 7550-CLOSE-RULE-CURSOR     THRU 7550-EXIT.           
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE 'N'                           TO WS-AUTOCARD-SETUP-FL   
P0726D                                           WS-ACTIVE-RET-CHECK.   
P0726F     PERFORM 7200-SELECT-FINAL-WO       THRU 7200-EXIT            
                                                                        
           PERFORM 7020-AUTOCARD-SETUP        THRU 7020-EXIT.           
           PERFORM 2110-GET-NEXT-BILL-DATE    THRU 2110-EXIT.           
           PERFORM 2120-GET-NEXT-READ-DATE    THRU 2120-EXIT.           
P0726C     PERFORM 2220-CREDIT-COMPLETE-PROCESS       THRU 2220-EXIT.   
P0726D     PERFORM 7110-ACTIVE-RETURNED-CHECK THRU 7110-EXIT.           
                                                                        
           IF ARNG-USER-TBL-LOADED                                      
              CONTINUE                                                  
           ELSE                                                         
              PERFORM 7500-OPEN-ARNG-DTLS-CURSOR      THRU 7500-EXIT    
              PERFORM 7510-FETCH-ARNG-DTLS-CURSOR     THRU 7510-EXIT    
              SET T1-INDX TO 1                                          
              PERFORM 2200-LOAD-ARNG-DTLS             THRU 2200-EXIT    
                UNTIL SQLCODE = NOT-FOUND                               
              PERFORM 7520-CLOSE-ARNG-DTLS-CURSOR     THRU 7520-EXIT    
P0726F                                                                  
P0726E        PERFORM 2330-CHECK-FOR-GOOD-CRED        THRU 2330-EXIT    
P0726F        PERFORM 2240-PROCESS-ARNG-DTL-CIS       THRU 2240-EXIT    
              SET ARNG-USER-TBL-LOADED        TO TRUE                   
           END-IF.                                                      
                                                                        
P0726E     IF WS-ARNG-TBL-COUNT = 0 AND WS-FORECAST-ROW-NOT-FOUND = 'N' 
              INITIALIZE GTT-RETURN-FIELDS-1                            
                         GTT-RETURN-FIELDS-2                            
              MOVE 100                        TO S-R1-RETURN-CODE       
                                                 S-R2-RETURN-CODE       
P0726E        PERFORM 2580-GET-PLAN-ERR-MSG           THRU 2580-EXIT    
              GO TO 2000-EXIT                                           
           END-IF.                                                      
                                                                        
P0726E     IF ROW-INSERTED                                              
P0726E        CONTINUE                                                  
P0726E     ELSE                                                         
P0726E        INITIALIZE GTT-RETURN-FIELDS-1                            
P0726E                   GTT-RETURN-FIELDS-2                            
P0726E        IF WS-FORECAST-ROW-NOT-FOUND = 'Y'                        
P0726E           MOVE -1                      TO S-R1-RETURN-CODE       
P0726E                                           S-R2-RETURN-CODE       
P0726E        ELSE                                                      
P0726E           MOVE 100                     TO S-R1-RETURN-CODE       
P0726E                                           S-R2-RETURN-CODE       
P0726E           PERFORM 2570-GET-LST-PLAN-ERR-MSGS   THRU 2570-EXIT    
P0726E        END-IF                                                    
P0726E     END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2100-CALL-MCSCB068.                                            *        
      ******************************************************************        
                                                                        
       2100-CALL-MCSCB068.                                              
                                                                        
      * Set CPD00068 Switches that are needed                                   
                                                                        
P0726A     MOVE WS-CURRENT-DATE              TO WS-HOLD-DATE            
                                                                        
           MOVE 'Y' TO CALC-BALANCE-SW                                  
                       CALC-ARREARS-SW                                  
                       LOAD-DNP-DATE-SW                                 
                       LOAD-DUE-DATES-SW                                
                       CALC-PAST-DUE-SW.                                
                                                                        
           MOVE PROGRAM-NAME                 TO WS-CPD00068-CALLING-PGM.
           MOVE SPACES                       TO ABEND-FUNCTION.         
P0726F                                                                  
P0726F     CALL MCSCB068  USING  CWS00068-FIELDS                        
P0726F                           WS-CODES-DATA-PRESENT                  
P0726F                           DCLCSS-ACCOUNT                         
P0726F                           ABEND-FILE                             
P0726F                           S-R2-RETURN-CODE.                      
P0726F                                                                  
P0726F     MOVE S-R2-RETURN-CODE            TO WS-ACTIVE-RETURN-CODE.   
P0726F                                                                  
P0726F     IF ABEND-FUNCTION  > SPACES                                  
P0726F        IF ABEND-FUNCTION EQUAL 'BADDATA'                         
P0726F           MOVE -1                    TO WS-ACTIVE-RETURN-CODE    
P0726F        END-IF                                                    
P0726F        ADD +1                        TO CTR-ROWS-RS2             
P0726F        PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
P0726F     END-IF.                                                      
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
P0726E******************************************************************        
P0726E* 2110-GET-NEXT-BILL-DATE                                        *        
P0726E******************************************************************        
P0726E                                                                  
P0726E 2110-GET-NEXT-BILL-DATE.                                         
P0726E                                                                  
P0726F     INITIALIZE WS-NEXT-BILL-DATE                                 
P0726F                                                                  
P0726E     PERFORM 5900-NEXT-BILL-DATE   THRU 5900-NEXT-BILL-DATE-EXIT. 
P0726E     IF WS-NULL-DATE-EXTRACT EQUAL ZEROES                         
P0726E        IF BN-DATE-EXTRACT > SPACES                               
P0726E           MOVE BN-DATE-EXTRACT         TO WS-NEXT-BILL-DATE      
P0726F           MOVE BN-REVENUE-MONTH        TO WS-HOLD-REVENUE-MONTH  
P0726F        END-IF                                                    
P0726F     END-IF.                                                      
P0726E                                                                  
P0726E 2110-EXIT.                                                       
P0726E     EXIT.                                                        
P0726E                                                                  
P0726E******************************************************************        
P0726E* 2120-GET-NEXT-READ-DATE                                        *        
P0726E******************************************************************        
P0726E                                                                  
P0726E 2120-GET-NEXT-READ-DATE.                                         
P0726E                                                                  
P0726F     INITIALIZE WS-NEXT-READ-DATE                                 
P0726E                                                                  
P0726E     IF AT-CODE-ACCT-STAT = 'A'                                   
P0726E        PERFORM 5901-NEXT-READ-DATE                               
P0726E           THRU 5901-NEXT-READ-DATE-EXIT                          
P0726E                                                                  
P0726E         IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
P0726E            IF RW-THIRD-PTY-READ-DT > SPACES                      
P0726E               MOVE RW-THIRD-PTY-READ-DT TO WS-NEXT-READ-DATE     
P0726E            ELSE                                                  
P0726E               MOVE RW-OPTIMUM-READ-DATE TO WS-NEXT-READ-DATE     
P0726E            END-IF                                                
P0726E         END-IF                                                   
P0726E     END-IF.                                                      
P0726E                                                                  
P0726E 2120-EXIT.                                                       
P0726E     EXIT.                                                        
P0726E                                                                  
P0726F******************************************************************        
P0726F* 2130-LOAD-CRED-ACT-DT.                                         *        
P0726F******************************************************************        
P0726F                                                                  
P0726F 2130-LOAD-CRED-ACT-DT.                                           
P0726F                                                                  
P0726F     MOVE WS-DATE-CREDIT-ACTION-D  TO IN-CRED-ACTION-DT(1).       
P0726F     MOVE 'D'                      TO IN-DNP-TYPE(1).             
P0726F     MOVE WS-DATE-CREDIT-ACTION-G  TO IN-CRED-ACTION-DT(2).       
P0726F     MOVE 'G'                      TO IN-DNP-TYPE(2).             
P0726F     MOVE WS-DATE-CREDIT-ACTION-H  TO IN-CRED-ACTION-DT(3).       
P0726F     MOVE 'H'                      TO IN-DNP-TYPE(3).             
P0726F     MOVE WS-DATE-CREDIT-ACTION-I  TO IN-CRED-ACTION-DT(4).       
P0726F     MOVE 'I'                      TO IN-DNP-TYPE(4).             
P0726F*                                                                         
P0726F     MOVE 4                        TO WS-CRED-ACT-ROWS.           
P0726F     PERFORM VARYING CRED-INDX FROM 1 BY 1                        
P0726F        UNTIL CRED-INDX > WS-CRED-ACT-ROWS                        
P0726F        IF IN-CRED-ACTION-DT(CRED-INDX) = SPACES                  
P0726F           MOVE '1900-01-01'       TO IN-CRED-ACTION-DT(CRED-INDX)
P0726F           MOVE SPACES             TO IN-DNP-TYPE(CRED-INDX)      
P0726F        END-IF                                                    
P0726F        IF WS-CRED-FL = 'N'                                       
P0726F           IF IN-CRED-ACTION-DT(CRED-INDX) > WS-CURRENT-DATE      
P0726F              MOVE IN-CRED-ACTION-DT(CRED-INDX)    TO             
P0726F                                            WS-NEAREST-DNP-DT     
P0726H              MOVE IN-DNP-TYPE(CRED-INDX) TO WS-NEAREST-DNP-TYPE  
P0726F              MOVE 'Y'                    TO WS-CRED-FL           
P0726F              ADD +1               TO WS-NO-CRED-ACT-ROWS         
P0726F           END-IF                                                 
P0726F        ELSE                                                      
P0726F           IF IN-CRED-ACTION-DT(CRED-INDX) > WS-CURRENT-DATE      
P0726F              IF IN-CRED-ACTION-DT(CRED-INDX) < WS-NEAREST-DNP-DT 
P0726F                 MOVE IN-CRED-ACTION-DT(CRED-INDX) TO             
P0726F                                              WS-NEAREST-DNP-DT   
P0726H                 MOVE IN-DNP-TYPE(CRED-INDX)                      
P0726H                                          TO WS-NEAREST-DNP-TYPE  
P0726F              END-IF                                              
P0726F              ADD +1               TO WS-NO-CRED-ACT-ROWS         
P0726F           END-IF                                                 
P0726F        END-IF                                                    
P0726F     END-PERFORM.                                                 
P0726F                                                                  
P0726F* Set Exceptional Message                                                 
P0726F     IF WS-NEAREST-DNP-DT > SPACES                                
P0726F        IF WS-NEAREST-DNP-DT = WS-DATE-CREDIT-ACTION-G            
P0726F           MOVE 'Y'                TO WS-EXCPTNL-MSG              
P0726F        END-IF                                                    
P0726F     ELSE                                                         
P0726F        IF WS-DNP-FLAG = 'Y' AND VO-SERV-ORDER-STATUS < 26        
P0726F           IF EXCPTNL-DNP                                         
P0726F              MOVE 'Y'             TO WS-EXCPTNL-MSG              
P0726F           END-IF                                                 
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726F                                                                  
P0726F     IF WS-NO-CRED-ACT-ROWS > 1                                   
P0726F        MOVE 'N'                   TO WS-NEW-DNP-FL               
P0726F        MOVE 'N'                   TO WS-CRED-FL                  
P0726F        SET  WS-ZERO               TO CRED-INDX                   
P0726F        PERFORM VARYING CRED-INDX FROM 1 BY 1                     
P0726F          UNTIL CRED-INDX > WS-CRED-ACT-ROWS                      
P0726F           IF IN-CRED-ACTION-DT(CRED-INDX) = SPACES               
P0726F              MOVE '1900-01-01'    TO IN-CRED-ACTION-DT(CRED-INDX)
P0726F              MOVE SPACES          TO IN-DNP-TYPE(CRED-INDX)      
P0726F           END-IF                                                 
P0726F           IF WS-CRED-FL = 'N'                                    
P0726F              IF IN-CRED-ACTION-DT(CRED-INDX) > WS-NEAREST-DNP-DT 
P0726F                 MOVE IN-CRED-ACTION-DT(CRED-INDX)                
P0726F                                   TO WS-NXT-NEAR-DNP-DT          
P0726F                 MOVE IN-DNP-TYPE(CRED-INDX)   TO WS-NXT-DNP-TYPE 
P0726F                 MOVE 'Y'          TO WS-CRED-FL                  
P0726F              END-IF                                              
P0726F           ELSE                                                   
P0726F              IF IN-CRED-ACTION-DT(CRED-INDX) < WS-NXT-NEAR-DNP-DT
P0726F              AND IN-CRED-ACTION-DT(CRED-INDX) > WS-NEAREST-DNP-DT
P0726F                  MOVE IN-CRED-ACTION-DT(CRED-INDX)               
P0726F                                   TO WS-NXT-NEAR-DNP-DT          
P0726F                  MOVE IN-DNP-TYPE(CRED-INDX)  TO WS-NXT-DNP-TYPE 
P0726F              END-IF                                              
P0726F           END-IF                                                 
P0726F        END-PERFORM                                               
P0726F                                                                  
P0726F        EVALUATE WS-NXT-DNP-TYPE                                  
P0726F         WHEN 'D'                                                 
P0726F              MOVE WS-DATE-NOTICE-MAIL-B TO WS-FIRST-NOT-MAIL-DT  
P0726F              MOVE WS-DATE-NOTICE-MAIL-C TO WS-FINAL-NOT-MAIL-DT  
P0726F         WHEN 'G'                                                 
P0726F              MOVE WS-DATE-NOTICE-MAIL-E TO WS-FIRST-NOT-MAIL-DT  
P0726F              MOVE WS-DATE-NOTICE-MAIL-F TO WS-FINAL-NOT-MAIL-DT  
P0726F         WHEN 'H'                                                 
P0726F              MOVE SPACES                TO WS-FIRST-NOT-MAIL-DT  
P0726F              MOVE WS-DATE-NOTICE-MAIL-N TO WS-FINAL-NOT-MAIL-DT  
P0726F         WHEN 'I'                                                 
P0726F              MOVE SPACES                TO WS-FIRST-NOT-MAIL-DT  
P0726F              MOVE WS-DATE-NOTICE-MAIL-O TO WS-FINAL-NOT-MAIL-DT  
P0726F        END-EVALUATE                                              
P0726F        MOVE WS-NEAREST-DNP-DT           TO WS-ORIGINAL-DNP-DATE  
P0726F        MOVE WS-NXT-NEAR-DNP-DT          TO WS-NEW-DNP-DATE       
P0726F        MOVE WS-NXT-NEAR-DNP-DT          TO WS-NEW-BUSINESS-DAY   
P0726F        PERFORM 6525-PREV-BUSINESS-DAY   THRU                     
P0726F         6525-PREV-BUSINESS-DAY-EXIT UNTIL NEXT-BUSINESS-DAY-FOUND
P0726F        MOVE WS-NEW-BUSINESS-DAY         TO WS-NEW-DUE-DATE       
P0726H        MOVE WS-NEAREST-DNP-TYPE         TO WS-ORIGINAL-DNP-TYPE  
P0726F        IF SEB-DATABASE AND WS-REG AND AT-CREDIT-GROUP = 'B'      
P0726F           MOVE WS-TOTAL-BALANCE-UTL     TO WS-STA-AMOUNT         
P0726F        ELSE                                                      
P0726F           MOVE WS-AMT-PAST-DUE-UTL      TO WS-STA-AMOUNT         
P0726F        END-IF                                                    
P0726F     ELSE                                                         
P0726F        MOVE 'Y'                         TO WS-NEW-DNP-FL         
P0726F     END-IF.                                                      
P0726F                                                                  
P0726F 2130-EXIT.                                                       
P0726F     EXIT.                                                        
P0726F                                                                  
P0726F******************************************************************        
P0726F* 2140-GET-60-DAY-OLD.                                                    
P0726F******************************************************************        
P0726F                                                                  
P0726F 2140-GET-60-DAY-OLD.                                             
P0726F                                                                  
P0726F     EVALUATE TRUE                                                
P0726F         WHEN WS-DAYS-60 > 60                                     
P0726F              COMPUTE WS-CALC-ARREARS-UTL = (WS-AMT-60-DAY-UTL    
P0726F                    + WS-AMT-90-DAY-UTL + WS-AMT-30-DAY-NSA)      
P0726F         WHEN WS-DAYS-90 > 60                                     
P0726F              COMPUTE WS-CALC-ARREARS-UTL =  (WS-AMT-90-DAY-UTL   
P0726F                    + WS-AMT-30-DAY-NSA + WS-AMT-60-DAY-NSA)      
P0726F     END-EVALUATE.                                                
P0726F     COMPUTE WS-AMT-ARREARS-GR-60 = WS-CALC-ARREARS-UTL.          
P0726F                                                                  
P0726F 2140-EXIT.                                                       
P0726F     EXIT.                                                        
P0726F                                                                  
P0726F                                                                  
P0726F******************************************************************        
P0726F* 2170-GET-30-DAY-OLD.                                                    
P0726F******************************************************************        
P0726F                                                                  
P0726F 2170-GET-30-DAY-OLD.                                             
P0726F                                                                  
P0726F     EVALUATE TRUE                                                
P0726F        WHEN WS-DAYS-30 > 30                                      
P0726F             COMPUTE WS-CALC-ARREARS-UTL = (WS-AMT-30-DAY-UTL     
P0726F                     + WS-AMT-60-DAY-UTL + WS-AMT-90-DAY-UTL      
P0726F                     + WS-AMT-00-DAY-NSA)                         
P0726F        WHEN WS-DAYS-60 > 30                                      
P0726F             COMPUTE WS-CALC-ARREARS-UTL = (WS-AMT-60-DAY-UTL     
P0726F                     + WS-AMT-90-DAY-UTL + WS-AMT-30-DAY-NSA)     
P0726F        WHEN WS-DAYS-90 > 30                                      
P0726F             COMPUTE WS-CALC-ARREARS-UTL =  (WS-AMT-90-DAY-UTL    
P0726F                     + WS-AMT-30-DAY-NSA + WS-AMT-60-DAY-NSA)     
P0726F     END-EVALUATE                                                 
P0726F     COMPUTE WS-AMT-ARREARS-GR-30 = WS-CALC-ARREARS-UTL.          
P0726F                                                                  
P0726F 2170-EXIT.                                                       
P0726F     EXIT.                                                        
      ******************************************************************        
      * 2200-LOAD-ARNG-DTLS                                            *        
      ******************************************************************        
                                                                        
       2200-LOAD-ARNG-DTLS.                                             
                                                                        
           ADD 1                      TO WS-ARNG-TBL-COUNT              
           MOVE UJ-ARNG-ID            TO WS-ARNG-ID(T1-INDX)            
           MOVE UJ-ARNG-TYPE          TO WS-ARNG-TYPE(T1-INDX)          
           MOVE UJ-ARNG-STATUS-CD     TO WS-ARNG-STATUS-CD(T1-INDX)     
           MOVE UJ-ARNG-DESC          TO WS-ARNG-DESC(T1-INDX)          
           MOVE UJ-ARNG-BILL-OPTN-CD  TO WS-ARNG-BILL-OPTN-CD(T1-INDX)  
           MOVE UJ-UTIL-NONUTIL-CD    TO WS-UTIL-NONUTIL-CD(T1-INDX)    
           MOVE UJ-RECVBLE-DEFER-CD   TO WS-RECVBLE-DEFER-CD(T1-INDX)   
           MOVE UJ-ARNG-FREQ-CD       TO WS-ARNG-FREQ-CD(T1-INDX)       
           MOVE UJ-SEASONAL-FL        TO WS-SEASONAL-FL(T1-INDX)        
           MOVE UJ-INSTALLMENT-FL     TO WS-INSTALLMENT-FL(T1-INDX)     
           MOVE UJ-ARNG-DROP-FL       TO WS-ARNG-DROP-FL(T1-INDX)       
           MOVE UF-PLAN-TERM-CD       TO WS-PLAN-TERM-CD(T1-INDX)       
           MOVE UF-PLAN-TERM-MIN      TO WS-PLAN-TERM-MIN(T1-INDX)      
           MOVE UF-PLAN-TERM-MAX      TO WS-PLAN-TERM-MAX(T1-INDX)      
           MOVE UF-PLAN-TERM-MAX-OVRD TO WS-PLAN-TERM-MAX-OVRD(T1-INDX) 
           MOVE UF-SEASON-START-DDMM  TO WS-SEASON-START-DDMM(T1-INDX)  
           MOVE UF-SEASON-END-DDMM    TO WS-SEASON-END-DDMM(T1-INDX)    
           MOVE UF-PATH-START-CD      TO WS-PATH-START-CD(T1-INDX)      
           MOVE UF-LPC-ASSESS-CD      TO WS-LPC-ASSESS-CD(T1-INDX)      
           MOVE UF-ARNG-AMOUNT-CD     TO WS-ARNG-AMOUNT-CD(T1-INDX)     
           MOVE UF-ARNG-PLAN-DESC     TO WS-ARNG-PLAN-DESC(T1-INDX)     
           MOVE UF-NSF-ALLOWED-FL     TO WS-NSF-ALLOWED-FL(T1-INDX)     
           MOVE UD-ACTN-PATH-TYPE-CD  TO WS-ACTN-PATH-TYPE-CD(T1-INDX)  
           MOVE UD-TERM-OPTION-SEQ    TO WS-TERM-OPTION-SEQ(T1-INDX)    
           MOVE UD-ARNG-GRACE-PERIOD  TO WS-ARNG-GRACE-PERIOD(T1-INDX)  
           MOVE UD-ARNG-PRIORITY      TO WS-ARNG-PRIORITY(T1-INDX)      
           MOVE UD-DAY-COUNT-TYPE-CD  TO WS-DAY-COUNT-TYPE-CD(T1-INDX)  
P0726E     MOVE UD-ARNG-CHANNEL-CD    TO WS-ARNG-CHANNEL-CD(T1-INDX)    
           MOVE UF-ARNG-PLAN-ID       TO WS-ARNG-PLAN-ID  (T1-INDX)     
           MOVE UD-ARNG-OPTION-ID     TO WS-ARNG-OPTION-ID(T1-INDX)     
P0726E     MOVE UD-CREDIT-GROUP-CD    TO WS-CREDIT-GROUP-CD(T1-INDX)    
P0726E     MOVE UD-CRED-ACTN-EXIST-CD TO WS-CRED-ACTN-EXIST-CD(T1-INDX) 
P0726E     MOVE UD-OPTION-TERM-CD     TO WS-OPTION-TERM-CD(T1-INDX)     
                                                                        
           SET T1-INDX UP BY 1.                                         
           PERFORM 7510-FETCH-ARNG-DTLS-CURSOR     THRU 7510-EXIT.      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2210-LOAD-RULE-DTLS                                            *        
      ******************************************************************        
                                                                        
       2210-LOAD-RULE-DTLS.                                             
                                                                        
P0726E     ADD +1                        TO WS-BUS-RULE-COUNT.          
P0726E     MOVE 1T-BUS-RULE-ID           TO T2-RULE-ID (T2-INDX).       
P0726E     MOVE 1T-BUS-RULE-XREF-ID      TO T2-RULE-XREF-ID (T2-INDX).  
P0726E     MOVE 1T-COMPANY-NO            TO T2-COMPANY-NO (T2-INDX).    
P0726E     SET T2-INDX UP BY 1.                                         
P0726E                                                                  
P0726E*    IF 1T-COMPANY-NO = '01' OR '26'                                      
P0726E     IF 1T-COMPANY-NO = AT-COMPANY-NO                             
P0726E        MOVE 1T-BUS-RULE-ID        TO T3-RULE-ID (T3-INDX)        
P0726E        MOVE 1T-BUS-RULE-XREF-ID   TO T3-RULE-XREF-ID (T3-INDX)   
P0726E        MOVE 1T-COMPANY-NO         TO T3-COMPANY-NO (T3-INDX)     
P0726E        SET T3-INDX UP BY 1                                       
P0726E     END-IF.                                                      
                                                                        
           PERFORM 7540-FETCH-RULE-CURSOR          THRU 7540-EXIT.      
                                                                        
       2210-EXIT.                                                       
           EXIT.                                                        
                                                                        
P0726C******************************************************************        
P0726C* 2220-CREDIT-COMPLETE-PROCESS                                   *        
P0726C******************************************************************        
P0726C                                                                  
P0726C 2220-CREDIT-COMPLETE-PROCESS.                                    
P0726C                                                                  
P0726C     MOVE 'N'                      TO WS-INCOMPLETE-CREDIT-FL     
P0726C                                      WS-BILL-HDR-FL.             
P0726C     MOVE 'BILCREDDET'             TO G6-PROGRAM-NAME.            
P0726C     MOVE  '01'                    TO G6-COMPANY-NO.              
P0726C     MOVE 'PARM'                   TO G6-CMND-CODE.               
P0726C     PERFORM 7090-SELECT-JOB-PARM        THRU 7090-EXIT.          
P0726C     PERFORM 7080-SELECT-BILL-DETAILS    THRU 7080-EXIT.          
P0726C                                                                  
P0726C     IF WS-BILL-HDR-FL = 'Y'                                      
P0726C        MOVE BI-BILL-NO            TO 1H-BILL-NO                  
P0726C        IF BI-DATE-BILLED >= WS-PARM-DATE AND                     
P0726C           BI-BILL-NO > 0                                         
P0726C           PERFORM 7100-BILL-CRED-DET    THRU 7100-EXIT           
P0726C        END-IF                                                    
P0726C     END-IF.                                                      
P0726C                                                                  
P0726C 2220-EXIT.                                                       
P0726C     EXIT.                                                        
P0726C                                                                  
P0726F******************************************************************        
P0726F* 2240-PROCESS-ARNG-DTL-CIS                                      *        
P0726F******************************************************************        
P0726F                                                                  
P0726F 2240-PROCESS-ARNG-DTL-CIS.                                       
P0726F                                                                  
P0726F     PERFORM VARYING T1-INDX FROM 1 BY 1 UNTIL                    
P0726F        T1-INDX > WS-ARNG-TBL-COUNT                               
P0726F        EVALUATE WS-CREDIT-GROUP-CD(T1-INDX)                      
P0726F          WHEN 'C'                                                
P0726F               IF WS-FST-GROUP-CD = 'C'                           
P0726F                  PERFORM 2250-GET-ARNG-ATTRIBUTES THRU 2250-EXIT 
P0726F               END-IF                                             
P0726F          WHEN 'A'                                                
P0726F               IF WS-FST-GROUP-CD = 'A'                           
P0726F                  PERFORM 2250-GET-ARNG-ATTRIBUTES THRU 2250-EXIT 
P0726F               END-IF                                             
P0726F          WHEN OTHER                                              
P0726F               PERFORM 2250-GET-ARNG-ATTRIBUTES    THRU 2250-EXIT 
P0726F        END-EVALUATE                                              
P0726F     END-PERFORM.                                                 
P0726F                                                                  
P0726F 2240-EXIT.                                                       
P0726F     EXIT.                                                        
P0726F                                                                  
      ******************************************************************        
      * 2250-GET-ARNG-ATTRIBUTES                                       *        
      ******************************************************************        
                                                                        
       2250-GET-ARNG-ATTRIBUTES.                                        
                                                                        
P0726E     INITIALIZE GTT-RETURN-FIELDS.                                
P0726E     MOVE SPACES                   TO WS-NEW-DUE-DATE             
P0726E                                      WS-ARNG-TERM-CD             
P0726E                                      WS-DATE-CCYY                
P0726E                                      WS-DATE-MM                  
P0726E                                      WS-DATE-DD.                 
P0726E     MOVE 'N'                      TO WS-ARNG-VALIDATION          
P0726E                                      WS-FORECAST-ROW-NOT-FOUND.  
P0726E     MOVE ZEROES                   TO WS-TEMP-RULE-COUNT.         
P0726E                                                                  
P0726F* Populate CPDKR361 variables                                             
           MOVE AT-ACCOUNT-NO            TO WS-KR361-ACCOUNT-NO.        
P0726F     EVALUATE WS-ARNG-TYPE(T1-INDX)                               
P0726F       WHEN 'CDD'                                                 
P0726F       WHEN 'CDDA'                                                
P0726E            MOVE AT-TOTAL-AR-BALANCE  TO WS-KR361-TOTAL-AMOUNT    
P0726F       WHEN 'STA'                                                 
P00948       WHEN 'STF'                                                 
P0726F            MOVE WS-STA-AMOUNT     TO WS-KR361-TOTAL-AMOUNT       
P0726F       WHEN 'STAA'                                                
P00948       WHEN 'STFA'                                                
P0726F            MOVE WS-TOTAL-BALANCE-UTL TO WS-KR361-TOTAL-AMOUNT    
P0726F     END-EVALUATE.                                                
           MOVE PARM-ARNG-CHANNEL-CD     TO WS-KR361-ARNG-CHANNEL-CD.   
           MOVE AT-CODE-MAJOR-ACCT       TO WS-KR361-MAJOR-IND.         
           MOVE AT-ACCOUNT-TYPE-CODE     TO WS-KR361-ACCOUNT-TYPE-CD.   
P0726E     MOVE ws-ARNG-PLAN-ID(T1-INDX) TO WS-KR361-ARNG-PLAN-ID.      
P0726E     MOVE WS-ARNG-ID(T1-INDX)      TO WS-CURR-ARNG-ID.            
P0726E     MOVE WS-ARNG-OPTION-ID(T1-INDX)  TO WS-KR361-ARNG-OPTION-ID. 
                                                                        
P0726E     MOVE WS-CURRENT-DATE          TO WS-BILL-DATE.               
P0726E     MOVE AT-ACCOUNT-TYPE-CODE     TO WS-ACCOUNT-TYPE-CODE.       
P0726E     MOVE AT-BILL-CYCLE            TO WS-BILL-CYCLE               
P0726F                                      CM-BILL-CYCLE.              
P0726E     MOVE AT-REV-MTH-LST-NRML      TO WS-REV-MTH-LST-NRML         
P0726F                                      CM-REVENUE-MONTH            
P0726F                                      WS-ORIGINAL-REV-MTH-NRML    
P0726E                                      WS-REV-MTH-LST-NRML-A.      
P0726F* Get 60/90 days arrears                                                  
P0726F     COMPUTE WS-KR361-60-90-AMOUNT = WS-AMT-60-DAY-UTL +          
P0726F                                     WS-AMT-90-DAY-UTL            
P0726E                                                                  
P0726F* Call CPDKR361 to get all the attributes                                 
           PERFORM 5000-PROCESS-ARNG-ATTRIBUTES                         
                                         THRU 5000-CPDKR361-EXIT.       
                                                                        
P0726F                                                                  
P0726F* Set Recent Payment Flag                                                 
P0726F     MOVE 'Y'                      TO WS-RECENT-PAYMENT           
P0726F     IF WS-RECENT-PYMT-DAYS > 60                                  
P0726F        MOVE 'N'                   TO WS-RECENT-PAYMENT           
P0726F     ELSE                                                         
P0726F        MOVE 'Y'                   TO WS-RECENT-PAYMENT           
P0726F     END-IF                                                       
P0726F     MOVE 'N'                      TO WS-UNPAID-DEPOSIT           
P0726F     PERFORM 7210-SELECT-DEP-ON-HAND        THRU 7210-EXIT        
P0726F     PERFORM 7220-CHK-AR-TRAN-HIST          THRU 7220-EXIT.       
P0726F     PERFORM 7230-SELECT-MED-CERT           THRU 7230-EXIT        
                                                                        
P0726F* Set 60 days arrears flag                                                
P0726F     MOVE 'Y'                      TO WS-60-DAY-ARREARS.          
P0726F     IF WS-DAYS-60 > 60                                           
P0726F        COMPUTE WS-CALC-ARREARS-UTL = (WS-AMT-60-DAY-UTL +        
P0726F                WS-AMT-90-DAY-UTL + WS-AMT-30-DAY-NSA)            
P0726F     ELSE                                                         
P0726F        IF AT-DATE-BILL-DAY-90 LESS THAN WS-DT-25-DAYS-AGO        
P0726F           COMPUTE WS-CALC-ARREARS-UTL = (WS-AMT-90-DAY-UTL +     
P0726F                   WS-AMT-30-DAY-NSA + WS-AMT-60-DAY-NSA)         
P0726F        END-IF                                                    
P0726F     END-IF.                                                      
P0726F     COMPUTE WS-AMT-ARREARS-GR-30 = WS-CALC-ARREARS-UTL.          
P0726F     IF WS-AMT-ARREARS-GR-30 > 0                                  
P0726F        MOVE 'Y'                   TO WS-60-DAY-ARREARS           
P0726F     ELSE                                                         
P0726F        MOVE 'N'                   TO WS-60-DAY-ARREARS           
P0726F     END-IF.                                                      
P0726F                                                                  
P0726F     COMPUTE WS-AMT-NSA =  WS-AMT-00-DAY-NSA                      
P0726J                        +  WS-AMT-30-DAY-NSA                      
P0726J                        +  WS-AMT-60-DAY-NSA                      
P0726J                        +  WS-AMT-90-DAY-NSA                      
P0726J                                                                  
P0726K     COMPUTE WS-AMT-NSA-NSN = WS-AMT-00-DAY-NSA                   
P0726K                        +  WS-AMT-30-DAY-NSA                      
P0726K                        +  WS-AMT-60-DAY-NSA                      
P0726K                        +  WS-AMT-90-DAY-NSA                      
P0726K                        +  WS-AMT-00-DAY-NSN                      
P0726K                        +  WS-AMT-30-DAY-NSN                      
P0726K                        +  WS-AMT-60-DAY-NSN                      
P0726K                        +  WS-AMT-90-DAY-NSN.                     
P0726K                                                                  
P0726F* Get 30 & 60 days arrears amount                                         
P0726F     PERFORM 2170-GET-30-DAY-OLD            THRU 2170-EXIT.       
P0726F     PERFORM 2140-GET-60-DAY-OLD            THRU 2140-EXIT.       
P0726F                                                                  
P0726F     PERFORM 2290-CALC-DUE-DT-PROCESS       THRU 2290-EXIT        
P0726E     PERFORM 2300-ARNG-VALIDATION           THRU 2300-EXIT        
P0726E                                                                  
P0726E     IF NOT VALIDATION-FAILED OR BUS-RULES-RTN                    
P0726F        PERFORM 2291-PROCESS-RESULTS        THRU 2291-EXIT        
           END-IF.                                                      
                                                                        
       2250-EXIT.                                                       
           EXIT.                                                        
                                                                        
P0726E*****************************************************************         
P0726E* 2260-PROCESS-CREDIT-HISTORY                                             
P0726E*****************************************************************         
P0726E                                                                  
P0726E 2260-PROCESS-CREDIT-HISTORY.                                     
P0726E                                                                  
P0726E     PERFORM VARYING WS-MONTH FROM 1 BY 1                         
P0726E               UNTIL WS-MONTH > WS-ELIG-MTHS-SEB                  
P0726E        EVALUATE TRUE                                             
P0726E           WHEN WS-ACCT-HST (WS-MONTH:1) =                        
P0726E                WS-OVER-60-DAYS OR WS-OVER-90-DAYS                
P0726E                ADD 3 TO WS-ARREARS-COUNT                         
P0726E           WHEN WS-ACCT-HST (WS-MONTH:1) = WS-OVER-30-DAYS        
P0726E                ADD 1 TO WS-ARREARS-COUNT                         
P0726E        END-EVALUATE                                              
P0726E     END-PERFORM.                                                 
P0726E                                                                  
P0726E 2260-EXIT.                                                       
P0726E     EXIT.                                                        
P0726E                                                                  
P0726E*****************************************************************         
P0726E* 2270-PROCESS-CRED-FORECAST                                              
P0726E*****************************************************************         
P0726E                                                                  
P0726E 2270-PROCESS-CRED-FORECAST.                                      
P0726E                                                                  
P0726E     MOVE WS-REV-MTH-LST-NRML-A      TO WS-REV-MNTH-HOLD.         
P0726E     ADD +1                          TO WS-REV-MM-HOLD            
P0726E     IF WS-REV-MM-HOLD = 13                                       
P0726E        MOVE 01                      TO WS-REV-MM-HOLD            
P0726E        ADD +1                       TO WS-REV-YY-HOLD            
P0726E     END-IF.                                                      
P0726E     MOVE WS-REV-MNTH-HOLD           TO WS-REV-MTH-LST-NRML-B     
P0726E     MOVE WS-REV-MTH-LST-NRML-B      TO WS-REV-MTH-LST-NRML.      
P0726E                                                                  
P0726E     IF BILL-WINDOW-NOT-LOADED                                    
P0726E        PERFORM 0110-LOAD-BILL-WINDOW        THRU 0110-EXIT       
P0726E        SET BILL-WINDOW-LOADED       TO TRUE                      
P0726E     END-IF.                                                      
P0726E                                                                  
P0726E     PERFORM 2370-GET-BILL-CYCLE-OPEN-DT     THRU 2370-EXIT.      
P0726E     PERFORM 2380-GET-BILL-CYCLE-CLOSE-DT    THRU 2380-EXIT.      
P0726E     PERFORM 2280-SEARCH-CRED-FORECAST       THRU 2280-EXIT.      
P0726E     IF WS-FORECAST-ROW-NOT-FOUND = 'Y'                           
P0726E        MOVE 'O'                     TO WS-ACCOUNT-TYPE-CODE      
P0726E        PERFORM 2280-SEARCH-CRED-FORECAST    THRU 2280-EXIT       
P0726E     END-IF.                                                      
P0726E                                                                  
P0726E 2270-EXIT.                                                       
P0726E     EXIT.                                                        
P0726E                                                                  
P0726E*****************************************************************         
P0726E* 2280-SEARCH-CRED-FORECAST                                               
P0726E*****************************************************************         
P0726E                                                                  
P0726E 2280-SEARCH-CRED-FORECAST.                                       
P0726E                                                                  
P0726E     MOVE WS-BILL-CYCLE-OPEN-DT      TO WS-BILL-DATE.             
P0726E     PERFORM 7060-SELECT-CRED-FORECAST-DT    THRU 7060-EXIT.      
P0726E     IF WS-FORECAST-ROW-NOT-FOUND = 'Y'                           
P0726E        MOVE WS-BILL-CYCLE-CLOSE-DT  TO WS-BILL-DATE              
P0726E        PERFORM 7060-SELECT-CRED-FORECAST-DT THRU 7060-EXIT       
P0726E     END-IF.                                                      
P0726E                                                                  
P0726E 2280-EXIT.                                                       
P0726E     EXIT.                                                        
P0726E                                                                  
P0726E*****************************************************************         
P0726E* 2290-CALC-DUE-DT-PROCESS                                                
P0726E*****************************************************************         
P0726E                                                                  
P0726E 2290-CALC-DUE-DT-PROCESS.                                        
P0726E                                                                  
P0726E     EVALUATE WS-PLAN-TERM-CD(T1-INDX)                            
P0726E       WHEN 'B'                                                   
P0726E          MOVE WS-PLAN-TERM-MAX(T1-INDX) TO WS-NO-OF-DAY          
P0726E          MOVE WS-NEXT-BILL-DATE      TO WS-NEW-BUSINESS-DAY      
P0726E          PERFORM 5110-GET-NEXT-BUSINESS-DAY        THRU 5110-EXIT
P0726F          MOVE WS-CALC-DUE-DATE       TO WS-NEW-DUE-DATE          
P0726E       WHEN 'R'                                                   
P0726E          MOVE WS-PLAN-TERM-MAX(T1-INDX) TO WS-NO-OF-DAY          
P0726E          MOVE WS-NEXT-READ-DATE         TO WS-NEW-BUSINESS-DAY   
P0726E          PERFORM 5110-GET-NEXT-BUSINESS-DAY        THRU 5110-EXIT
P0726F          MOVE WS-CALC-DUE-DATE       TO WS-NEW-DUE-DATE          
P0726E       WHEN 'A'                                                   
P0726E          EVALUATE WS-OPTION-TERM-CD(T1-INDX)                     
P0726E            WHEN '2N'                                             
P0726I               IF AT-REV-MTH-LST-NRML > 0                         
P0726E                 PERFORM 2270-PROCESS-CRED-FORECAST THRU 2270-EXIT
P0726E                 IF WS-FORECAST-ROW-NOT-FOUND = 'Y'               
P0726E                    GO TO 2290-EXIT                               
P0726E                 END-IF                                           
P0726E                                                                  
P0726E                 MOVE CM-DNP-NOTICE-DUE-DT TO WS-NEW-BUSINESS-DAY 
P0726E                 MOVE WS-PLAN-TERM-MAX(T1-INDX) TO WS-NO-OF-DAY   
P0726E                 PERFORM 5110-GET-NEXT-BUSINESS-DAY THRU 5110-EXIT
P0726F                 MOVE WS-CALC-DUE-DATE     TO WS-NEW-DUE-DATE     
P0726I               END-IF                                             
P0726E            WHEN 'BD'                                             
P0726F               IF AT-REV-MTH-LST-NRML > 0                         
P0726E                 PERFORM 2270-PROCESS-CRED-FORECAST THRU 2270-EXIT
P0726E                 IF WS-FORECAST-ROW-NOT-FOUND = 'Y'               
P0726E                    GO TO 2290-EXIT                               
P0726E                 END-IF                                           
P0726E                                                                  
P0726E                 MOVE CM-CURR-CHG-DUE-DT  TO WS-NEW-BUSINESS-DAY  
P0726E                 MOVE WS-PLAN-TERM-MAX(T1-INDX)  TO WS-NO-OF-DAY  
P0726E                 PERFORM 5110-GET-NEXT-BUSINESS-DAY THRU 5110-EXIT
P0726F                 MOVE WS-CALC-DUE-DATE TO WS-NEW-DUE-DATE         
P0726F               END-IF                                             
P0726E          END-EVALUATE                                            
P0726F       WHEN 'N'                                                   
P0726F* STA After Due date calculation                                          
P0726F        IF CSR-DATABASE                                           
P0726F           MOVE WS-HOLD-REVENUE-MONTH  TO AT-REV-MTH-LST-NRML     
P0726F           PERFORM 5900-NEXT-BILL-DATE THRU                       
P0726F                                       5900-NEXT-BILL-DATE-EXIT   
P0726F           MOVE BN-DATE-EXTRACT        TO WS-2ND-NEXT-BILL-DATE   
P0726F           MOVE WS-PLAN-TERM-MAX(T1-INDX) TO WS-NO-OF-DAY         
P0726F           MOVE WS-2ND-NEXT-BILL-DATE  TO WS-NEW-BUSINESS-DAY     
P0726F           PERFORM 5110-GET-NEXT-BUSINESS-DAY  THRU 5110-EXIT     
P0726F           MOVE WS-CALC-DUE-DATE       TO WS-NEW-DUE-DATE         
P0726F* STA After DNP date calculation                                          
P0726F           MOVE 1                      TO WS-NO-OF-DAY            
P0726E           PERFORM 5110-GET-NEXT-BUSINESS-DAY  THRU 5110-EXIT     
P0726F           MOVE WS-CALC-DUE-DATE       TO WS-NEW-DNP-DATE         
P0726F* STA After Final notice mail date                                        
P0726F           MOVE WS-DAY-STA-SECOND-MAIL TO WS-NO-OF-DAY            
P0726F           PERFORM 5120-GET-PREV-BUSINESS-DAY  THRU 5120-EXIT     
P0726F           MOVE WS-CALC-DUE-DATE       TO WS-FINAL-NOT-MAIL-DT    
P0726F* STA After Fisrt notice mail date/Date format                            
P0726F           MOVE 1                      TO WS-NO-OF-DAY            
P0726F           MOVE WS-NEXT-BILL-DATE      TO WS-NEW-BUSINESS-DAY     
P0726F           PERFORM 5110-GET-NEXT-BUSINESS-DAY  THRU 5110-EXIT     
P0726F           MOVE WS-CALC-DUE-DATE       TO WS-FIRST-NOT-MAIL-DT    
P0726F        ELSE                                                      
P0726F           IF SEB-DATABASE                                        
P0726F              MOVE WS-HOLD-REVENUE-MONTH  TO AT-REV-MTH-LST-NRML  
P0726F              PERFORM 5900-NEXT-BILL-DATE THRU                    
P0726F                                       5900-NEXT-BILL-DATE-EXIT   
P0726F              MOVE BN-DATE-EXTRACT        TO WS-2ND-NEXT-BILL-DATE
P0726F              MOVE WS-PLAN-TERM-MAX(T1-INDX) TO WS-NO-OF-DAY      
P0726F              MOVE WS-2ND-NEXT-BILL-DATE  TO WS-NEW-BUSINESS-DAY  
P0726F              PERFORM 5110-GET-NEXT-BUSINESS-DAY  THRU 5110-EXIT  
P0726F              MOVE WS-CALC-DUE-DATE       TO WS-NEW-DUE-DATE      
P0726F              MOVE SPACES                 TO WS-FIRST-NOT-MAIL-DT 
P0726F                                             WS-FINAL-NOT-MAIL-DT 
P0726F                                             WS-NEW-DNP-DATE      
P0726F           END-IF                                                 
P0726F        END-IF                                                    
P0726F* Original revenue month last normal has been replaced after 2nd          
P0726F* next bill date calculation.                                             
P0726F        MOVE WS-ORIGINAL-REV-MTH-NRML  TO AT-REV-MTH-LST-NRML     
P0726E     END-EVALUATE.                                                
P0726E                                                                  
P00948     IF WS-ARNG-TYPE(T1-INDX) = 'STA' OR 'STF'                    
P00948        AND WS-NEW-DNP-FL = 'Y'                                   
P0726F        IF CSR-DATABASE                                           
P0726F           MOVE WS-CALC-DUE-DATE  TO WS-NEW-DUE-DATE              
P0726F* STA DNP date calculation                                                
P0726F           MOVE 1                 TO WS-NO-OF-DAY                 
P0726F           PERFORM 5110-GET-NEXT-BUSINESS-DAY THRU 5110-EXIT      
P0726F           MOVE WS-CALC-DUE-DATE  TO WS-NEW-DNP-DATE              
P0726F           MOVE WS-DATE-CCYY-MM-DD     TO WS-NEW-DNP-DT-DB2FMT    
P0726F* STA Final notice mail date                                              
P0726F           MOVE WS-DAY-STA-SECOND-MAIL TO WS-NO-OF-DAY            
P0726F           PERFORM 5120-GET-PREV-BUSINESS-DAY THRU 5120-EXIT      
P0726F           MOVE WS-CALC-DUE-DATE  TO WS-FINAL-NOT-MAIL-DT         
P0726F           MOVE WS-DATE-CCYY-MM-DD     TO WS-FINAL-NOT-DT-DB2FMT  
P0726F           MOVE SPACES            TO WS-FIRST-NOT-MAIL-DT         
P0726F        ELSE                                                      
P0726F           IF SEB-DATABASE                                        
P0726F              MOVE WS-CALC-DUE-DATE      TO WS-NEW-DUE-DATE       
P0726F              MOVE SPACES                TO WS-FIRST-NOT-MAIL-DT  
P0726F                                            WS-FINAL-NOT-MAIL-DT  
P0726F                                            WS-NEW-DNP-DATE       
P0726F           END-IF                                                 
P0726F        END-IF                                                    
P0726F     END-IF.                                                      
P0726F                                                                  
P0726E 2290-EXIT.                                                       
P0726E     EXIT.                                                        
P0726E                                                                  
P0726F******************************************************************        
P0726F* 2291-PROCESS-RESULTS                                           *        
P0726F******************************************************************        
P0726F                                                                  
P0726F 2291-PROCESS-RESULTS.                                            
P0726F                                                                  
P0726F     PERFORM 2295-GET-ARNG-TERM-CD       THRU 2295-EXIT           
P0726F     IF WS-FORECAST-ROW-NOT-FOUND = 'Y' OR                        
P0726F        WS-NEW-DUE-DATE = SPACES                                  
P0726F        MOVE ZEROES TO WS-HOLD-ARNG-COUNT                         
P0726F                       WS-ARNG-TBL-COUNT                          
P0726F     ELSE                                                         
P0726F        PERFORM 2310-POPULATE-SSN-DTLS   THRU 2310-EXIT           
P0726F        PERFORM 2400-BUILD-RESULTS-1     THRU 2400-EXIT           
P0726F        PERFORM 2500-BUILD-RESULTS-2     THRU 2500-EXIT           
P0726F        PERFORM 2600-BUILD-RESULTS-3     THRU 2600-EXIT           
P0726F        SET ROW-INSERTED                 TO TRUE                  
P0726F     END-IF.                                                      
P0726F                                                                  
P0726F 2291-EXIT.                                                       
P0726F     EXIT.                                                        
P0726F                                                                  
P0726E******************************************************************        
P0726E* 2295-GET-ARNG-TERM-CD                                          *        
P0726E******************************************************************        
P0726E                                                                  
P0726E 2295-GET-ARNG-TERM-CD.                                           
P0726E                                                                  
P0726E     IF WS-OPTION-TERM-CD(T1-INDX) > SPACES                       
P0726E        MOVE WS-OPTION-TERM-CD(T1-INDX) TO  WS-ARNG-TERM-CD       
P0726E     ELSE                                                         
P0726E        MOVE WS-PLAN-TERM-CD(T1-INDX)   TO  WS-ARNG-TERM-CD       
P0726E     END-IF.                                                      
P0726E                                                                  
P0726E 2295-EXIT.                                                       
P0726E     EXIT.                                                        
P0726E                                                                  
      ******************************************************************        
      * 2300-ARNG-VALIDATION                                           *        
      ******************************************************************        
                                                                        
       2300-ARNG-VALIDATION.                                            
                                                                        
P0726F     SET T2-INDX                   TO 1.                          
P0726F     SET T4-INDX                   TO 1.                          
P0726F     INITIALIZE WS-BUS-RULE-TMP-TBL.                              
                                                                        
P0726F     EVALUATE WS-ARNG-TYPE(T1-INDX)                               
P0726F      WHEN 'CDD'                                                  
P0726F      WHEN 'CDDA'                                                 
P0726E           PERFORM VARYING T2-INDX FROM 1 BY 1                    
P0726E             UNTIL T2-INDX > WS-BUS-RULE-COUNT                    
P0726E             PERFORM 2450-CDD-CDDA-VALIDATION       THRU 2450-EXIT
P0726E           END-PERFORM                                            
P0726F      WHEN 'STA'                                                  
P00948      WHEN 'STF'                                                  
P0726F        EVALUATE TRUE ALSO TRUE                                   
P0726F          WHEN CSR-DATABASE ALSO WS-SCEG                          
P0726E               PERFORM VARYING T2-INDX FROM 1 BY 1                
P0726E                 UNTIL T2-INDX > WS-BUS-RULE-COUNT                
P0726E                 PERFORM 2410-SCEG-STA-VALIDATION   THRU 2410-EXIT
P0726E               END-PERFORM                                        
P0726F          WHEN CSR-DATABASE ALSO WS-PSNC                          
P0726E               PERFORM VARYING T2-INDX FROM 1 BY 1                
P0726E                 UNTIL T2-INDX > WS-BUS-RULE-COUNT                
P0726E                 PERFORM 2420-PSNC-STA-VALIDATION   THRU 2420-EXIT
P0726E               END-PERFORM                                        
P0726F          WHEN SEB-DATABASE ALSO WS-DEREG                         
P0726E               PERFORM VARYING T2-INDX FROM 1 BY 1                
P0726E                 UNTIL T2-INDX > WS-BUS-RULE-COUNT                
P0726E                 PERFORM 2430-SEB-DREG-STA-VALIDATION             
P0726E                                                    THRU 2430-EXIT
P0726E               END-PERFORM                                        
P0726F          WHEN SEB-DATABASE ALSO WS-REG                           
P0726E               PERFORM VARYING T2-INDX FROM 1 BY 1                
P0726E                 UNTIL T2-INDX > WS-BUS-RULE-COUNT                
P0726E                 PERFORM 2440-SEB-REG-STA-VALIDATION              
P0726E                                                    THRU 2440-EXIT
P0726E               END-PERFORM                                        
P0726F        END-EVALUATE                                              
P0726F      WHEN 'STAA'                                                 
P00948      WHEN 'STFA'                                                 
P0726F           PERFORM VARYING T2-INDX FROM 1 BY 1                    
P0726F             UNTIL T2-INDX > WS-BUS-RULE-COUNT                    
P0726F              PERFORM 2460-STA-AFTER-VALIDATION     THRU 2460-EXIT
P0726F           END-PERFORM                                            
P0726F     END-EVALUATE.                                                
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2310-POPULATE-SSN-DTLS                                         *        
      ******************************************************************        
                                                                        
       2310-POPULATE-SSN-DTLS.                                          
                                                                        
           IF AT-CUSTOMER-NO > 0                                        
              MOVE 'C'                     TO CE-CUSTOMER-TYPE          
              PERFORM 7030-CUSTOMER-SSN    THRU 7030-EXIT               
              IF SQLCODE = SUCCESSFUL-CALL                              
                 MOVE CE-SSN(6:4)          TO WS-SSN-CUST               
              ELSE                                                      
                 MOVE SPACES               TO WS-SSN-CUST               
              END-IF                                                    
                                                                        
              MOVE 'S'                     TO CE-CUSTOMER-TYPE          
              PERFORM 7030-CUSTOMER-SSN    THRU 7030-EXIT               
              IF SQLCODE = SUCCESSFUL-CALL                              
                 MOVE CE-SSN(6:4)          TO WS-SSN-SPOUSE             
              ELSE                                                      
                 MOVE SPACES               TO WS-SSN-SPOUSE             
              END-IF                                                    
           ELSE                                                         
              MOVE SPACES                  TO WS-SSN-CUST               
              MOVE SPACES                  TO WS-SSN-SPOUSE             
           END-IF.                                                      
                                                                        
           IF AT-ACCOUNT-NO > 0                                         
              MOVE 'C'                     TO CE-CUSTOMER-TYPE          
              PERFORM 7560-OPEN-ROOMMATE-CURSOR    THRU 7560-EXIT       
              PERFORM 2320-LOAD-ROOMMATE-SSN       THRU 2320-EXIT       
              PERFORM 7580-CLOSE-ROOMMATE-CURSOR   THRU 7580-EXIT       
           ELSE                                                         
              MOVE SPACES                  TO WS-SSN-ROOMMATE1          
              MOVE SPACES                  TO WS-SSN-ROOMMATE2          
              MOVE SPACES                  TO WS-SSN-ROOMMATE3          
           END-IF.                                                      
                                                                        
       2310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05330000
      * 2320-LOAD-ROOMMATE-SSN                                         *05620000
      ******************************************************************        
                                                                        
       2320-LOAD-ROOMMATE-SSN.                                          
                                                                        
           MOVE '2320' TO ACTIVE-PARAGRAPH.                             
                                                                        
           PERFORM 7570-FETCH-ROOMMATE-CURSOR      THRU 7570-EXIT       
           IF SQLCODE = SUCCESSFUL-CALL                                 
              MOVE CE-SSN(6:4)          TO WS-SSN-ROOMMATE1             
           ELSE                                                         
              MOVE SPACES               TO WS-SSN-ROOMMATE1             
              MOVE SPACES               TO WS-SSN-ROOMMATE2             
              MOVE SPACES               TO WS-SSN-ROOMMATE3             
              GO TO 2320-EXIT                                           
           END-IF.                                                      
                                                                        
           PERFORM 7570-FETCH-ROOMMATE-CURSOR      THRU 7570-EXIT       
           IF SQLCODE = SUCCESSFUL-CALL                                 
              MOVE CE-SSN(6:4)          TO WS-SSN-ROOMMATE2             
           ELSE                                                         
              MOVE SPACES               TO WS-SSN-ROOMMATE2             
              MOVE SPACES               TO WS-SSN-ROOMMATE3             
              GO TO 2320-EXIT                                           
           END-IF.                                                      
                                                                        
           PERFORM 7570-FETCH-ROOMMATE-CURSOR      THRU 7570-EXIT       
           IF SQLCODE = SUCCESSFUL-CALL                                 
              MOVE CE-SSN(6:4)          TO WS-SSN-ROOMMATE3             
           ELSE                                                         
              MOVE SPACES               TO WS-SSN-ROOMMATE3             
           END-IF.                                                      
                                                                        
       2320-EXIT.                                                       
           EXIT.                                                        
                                                                        
P0726E******************************************************************        
P0726E* 2330-CHECK-FOR-GOOD-CRED                                       *        
P0726F* CALL GOOD CREDIT COPY BOOK TO DECIDE THE GROUP MOVEMENTS       *        
P0726E******************************************************************        
P0726E                                                                  
P0726E 2330-CHECK-FOR-GOOD-CRED.                                        
P0726E                                                                  
P0726E     MOVE ZERO                  TO WS-RETAIN-COMMER-DEP           
P0726E                                   WS-RETAIN-INDUST-DEP           
P0726E                                   WS-RETAIN-RESIDENT-DEP         
P0726E                                   WS-RETAIN-DEL-MTHS             
P0726F                                   WS-MONTHS-TO-EVALUATE          
P0726E                                   WS-ARREARS-COUNT               
P0726E                                   WS-ELIG-NO-MTHS                
P0726E                                   WS-DELINQ-MTH                  
P0726E                                   WS-ARRS-CNT.                   
P0726E     MOVE SPACES                TO WS-ACCT-HST                    
P0726F                                   WS-UTIL-HISTORY.               
P0726F     MOVE 'N'                   TO WS-NOT-USE-CR-HIST-FL.         
P0726E     MOVE AT-COMPANY-NO         TO WS-COMPANY-CPD334.             
P0726E     MOVE PROGRAM-NAME          TO WS-PROGRAM-CPD334.             
P0726E                                                                  
P0726E     MOVE AT-COMPANY-NO         TO C8-COMPANY-NO.                 
P0726E     MOVE 'RETAIN-RESIDENT-DEP' TO C8-DELINQ-CD.                  
P0726E     PERFORM 7010-GET-DLINQ-VAL THRU 7010-EXIT.                   
P0726E     MOVE C8-DELINQ-VALUE       TO WS-RETAIN-RESIDENT-DEP.        
P0726E     MOVE 'RETAIN-COMMER-DEP'   TO C8-DELINQ-CD.                  
P0726E     PERFORM 7010-GET-DLINQ-VAL THRU 7010-EXIT.                   
P0726E     MOVE C8-DELINQ-VALUE       TO WS-RETAIN-COMMER-DEP.          
P0726E     MOVE 'RETAIN-INDUST-DEP'   TO C8-DELINQ-CD.                  
P0726E     PERFORM 7010-GET-DLINQ-VAL THRU 7010-EXIT.                   
P0726E     MOVE C8-DELINQ-VALUE       TO WS-RETAIN-INDUST-DEP.          
P0726E                                                                  
P0726E     EVALUATE AT-ACCOUNT-TYPE-CODE                                
P0726E       WHEN 'C'                                                   
P0726E           MOVE WS-RETAIN-COMMER-DEP   TO WS-RETAIN-DEL-MTHS      
P0726E       WHEN 'I'                                                   
P0726E           MOVE WS-RETAIN-INDUST-DEP   TO WS-RETAIN-DEL-MTHS      
P0726E       WHEN 'R'                                                   
P0726E           MOVE WS-RETAIN-RESIDENT-DEP TO WS-RETAIN-DEL-MTHS      
P0726E       WHEN OTHER                                                 
P0726E           MOVE 12                     TO WS-RETAIN-DEL-MTHS      
P0726E     END-EVALUATE.                                                
P0726E                                                                  
P0726F     COMPUTE WS-ELIG-NO-MTHS = WS-RETAIN-DEL-MTHS + 1             
P0726E     MOVE WS-RETAIN-DEL-MTHS    TO WS-ELIG-MTHS-SEB               
P0726E                                   WS-DELINQ-MTH                  
P0726E     IF WS-ELIG-MTHS-SEB > 23                                     
P0726E        MOVE 23                 TO WS-ELIG-MTHS-SEB               
P0726E     END-IF.                                                      
P0726E                                                                  
P0726E     PERFORM 7120-SEL-CRED-PROFILE             THRU 7120-EXIT.    
P0726E     MOVE CZ-DISCONNECT-HIST    TO WS-ACCT-DISCONNECT-HST.        
P0726E     MOVE CZ-DISC-EXCEPTN-HIST  TO WS-ACCT-DISC-EXCEPTN-HST.      
P0726F     MOVE CZ-ARREARS-HIST(24:1) TO WS-UTIL-LAST-MTH-HST.          
P0726E     MOVE '1'                   TO WS-UTILITY-ARREARS(1:1).       
P0726E     MOVE CZ-ARREARS-HIST(1:WS-RETAIN-DEL-MTHS)                   
P0726E                                TO WS-UTILITY-ARREARS(2:23)       
P0726E     MOVE WS-UTIL-HISTORY       TO WS-ACCT-HST                    
P0726E                                                                  
P0726F* IF THERE WAS A MANUAL CREDIT THEN ARREARS HISTORIES IS MOVED            
P0726F* TO A TEMP AREA AND THEN ONLY THE MONTHS SHOULD BE CONSIDERED            
P0726F* ARE LOADED BACK IN. THIS WILL ALLOW THE NORMAL CREDIT GROUP             
P0726F* CHANGE LOGIC TO BE EXECUTED.                                            
P0726F     IF CZ-CR-GRP-EFFECT-DT > SPACES                              
P0726F        MOVE CZ-CR-GRP-EFFECT-DT    TO WS-DATE-1                  
P0726F        MOVE WS-CURRENT-DATE        TO WS-DATE-2                  
P0726F* DO NOT CONSIDER REMAINDER WHEN DETERMINING # MONTHS TO EVALUATE.        
P0726F        PERFORM 7240-GET-NUMBER-OF-MONTHS      THRU 7240-EXIT     
P0726F        DIVIDE WS-MONTHS-TO-EVALUATE BY 30                        
P0726F               GIVING WS-MONTHS-TO-EVALUATE                       
P0726F        IF WS-MONTHS-TO-EVALUATE > ZERO                           
P0726F           PERFORM 2620-TEMP-ARREARS-HIST         THRU 2620-EXIT  
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726E                                                                  
P0726F     IF AT-CREDIT-GROUP = 'C' AND                                 
P0726F        CZ-CR-GRP-EFFECT-DT > SPACES                              
P0726F        MOVE 'Y'     TO WS-NOT-USE-CR-HIST-FL                     
P0726F     END-IF                                                       
P0726E                                                                  
P0726F     IF (CZ-CR-GRP-EFFECT-DT > SPACES AND                         
P0726F         WS-MONTHS-TO-EVALUATE > 0) OR                            
P0726F        (CZ-CR-GRP-EFFECT-DT NOT > SPACES)                        
P0726E        IF CSR-DATABASE                                           
P0726E           PERFORM 6565-PROCESS-CREDIT-RULE       THRU 6565-EXIT  
P0726E           IF AT-COMPANY-NO = '01'                                
P0726E              PERFORM 2340-SCEG-CRED-GRP-MOVEMENT THRU 2340-EXIT  
P0726E           ELSE                                                   
P0726E              PERFORM 2350-PSNC-CRED-GRP-MOVEMENT THRU 2350-EXIT  
P0726E           END-IF                                                 
P0726E        ELSE                                                      
P0726E           PERFORM 2260-PROCESS-CREDIT-HISTORY    THRU 2260-EXIT  
P0726E           PERFORM 2360-SEB-CRED-GRP-MOVEMENT     THRU 2360-EXIT  
P0726E        END-IF                                                    
P0726E     END-IF.                                                      
P0726F                                                                  
P0726F     IF WS-FST-GROUP-CD = 'N'                                     
P0726F        MOVE 'A'                TO WS-FST-GROUP-CD                
P0726F     END-IF.                                                      
P0726E                                                                  
P0726E 2330-EXIT.                                                       
P0726E     EXIT.                                                        
P0726E                                                                  
P0726E******************************************************************        
P0726E* 2340-SCEG-CRED-GRP-MOVEMENT                                    *        
P0726E* SCEG TO DETERMINE NEW CREDIT GROUP RULES                       *        
P0726E******************************************************************        
P0726E                                                                  
P0726E 2340-SCEG-CRED-GRP-MOVEMENT.                                     
P0726E                                                                  
P0726F     EVALUATE AT-CREDIT-GROUP ALSO TRUE                           
P0726F* Exempt(C)  ---> Arrears(A)                                              
P0726F     WHEN 'C' ALSO ((WS-CONSEC-CNT >= 1 OR WS-NON-CONSEC-CNT > 2) 
P0726F              AND (WS-ENOUGH-CREDIT-HIST = 'Y'))                  
P0726F              MOVE 'A'                TO WS-CREDIT-GROUP          
P0726F                                         WS-FST-GROUP-CD          
P0726F* Arrears(A) ---> Exempt(C)                                               
P0726F     WHEN 'A' ALSO ((WS-CONSEC-CNT = 0 AND WS-NON-CONSEC-CNT <= 2)
P0726F              AND ( WS-ENOUGH-CREDIT-HIST = 'Y'))                 
P0726F              IF (WS-CODE-MEDICAL     NOT = 'A' OR                
P0726F                  WS-CODE-DPP-ACCT    NOT = 'A' OR                
P0726F                  WS-CODE-DEP-ON-HAND NOT = 'A')                  
P0726F                  MOVE 'C'            TO WS-CREDIT-GROUP          
P0726F                                         WS-FST-GROUP-CD          
P0726F              END-IF                                              
P0726F* New(N)     ---> Exempt(C)                                               
P0726F     WHEN 'N' ALSO ((WS-CONSEC-CNT = 0 AND WS-NON-CONSEC-CNT <= 2)
P0726F              AND ( WS-ENOUGH-CREDIT-HIST = 'Y'))                 
P0726F              IF (WS-CODE-MEDICAL     NOT = 'A' OR                
P0726F                  WS-CODE-DPP-ACCT    NOT = 'A' OR                
P0726F                  WS-CODE-DEP-ON-HAND NOT = 'A')                  
P0726F                  MOVE 'C'            TO WS-CREDIT-GROUP          
P0726F                                         WS-FST-GROUP-CD          
P0726F              END-IF                                              
P0726F     END-EVALUATE.                                                
P0726F                                                                  
P0726F                                                                  
P0726E 2340-EXIT.                                                       
P0726E     EXIT.                                                        
P0726E                                                                  
P0726E***************************************************************           
P0726E* 2350-PSNC-CRED-GRP-MOVEMENT                                 *           
P0726E***************************************************************           
P0726E                                                                  
P0726E 2350-PSNC-CRED-GRP-MOVEMENT.                                     
P0726E                                                                  
P0726E     EVALUATE AT-CREDIT-GROUP ALSO TRUE                           
P0726E*Exmpt(C)    ---> Arrears(A)                                              
P0726E     WHEN 'C' ALSO WS-ARRS-CNT > 2 AND WS-ENOUGH-CREDIT-HIST = 'Y'
P0726E          MOVE 'A'                TO WS-CREDIT-GROUP              
P0726F                                     WS-FST-GROUP-CD              
P0726E*Arrears(A)  ---> Exempt(C)                                               
P0726E     WHEN 'A' ALSO WS-ARRS-CNT <= 2 AND                           
P0726E          WS-ENOUGH-CREDIT-HIST = 'Y'                             
P0726F          IF (WS-CODE-MEDICAL     NOT = 'A' OR                    
P0726F              WS-CODE-DPP-ACCT    NOT = 'A' OR                    
P0726F              WS-CODE-DEP-ON-HAND NOT = 'A')                      
P0726E             MOVE 'C'             TO WS-CREDIT-GROUP              
P0726F                                     WS-FST-GROUP-CD              
P0726F          END-IF                                                  
P0726E*New(N)      ---> Exempt(C)                                               
P0726E     WHEN 'N' ALSO WS-ARRS-CNT <= 2 AND                           
P0726E          WS-ENOUGH-CREDIT-HIST = 'Y'                             
P0726F          IF (WS-CODE-MEDICAL     NOT = 'A' OR                    
P0726F              WS-CODE-DPP-ACCT    NOT = 'A' OR                    
P0726F              WS-CODE-DEP-ON-HAND NOT = 'A')                      
P0726E             MOVE 'C'             TO WS-CREDIT-GROUP              
P0726F                                     WS-FST-GROUP-CD              
P0726F          END-IF                                                  
P0726F     END-EVALUATE.                                                
P0726E 2350-EXIT.                                                       
P0726E      EXIT.                                                       
P0726E                                                                  
P0726E******************************************************************        
P0726E* 2360-SEB-CRED-GRP-MOVEMENT                                     *        
P0726E******************************************************************        
P0726E                                                                  
P0726E 2360-SEB-CRED-GRP-MOVEMENT.                                      
P0726E                                                                  
P0726F     EVALUATE AT-CREDIT-GROUP ALSO TRUE                           
P0726F*Exmpt(C)    ---> Arrears(A)                                              
P0726F     WHEN 'C' ALSO WS-ARREARS-COUNT >= 3                          
P0726F          MOVE 'A'                TO WS-CREDIT-GROUP              
P0726F                                     WS-FST-GROUP-CD              
P0726F     END-EVALUATE.                                                
P0726F                                                                  
P0726E 2360-EXIT.                                                       
P0726E     EXIT.                                                        
P0726E                                                                  
P0726E******************************************************************        
P0726E* 2370-GET-BILL-CYCLE-OPEN-DT                                    *        
P0726E******************************************************************        
P0726E                                                                  
P0726E 2370-GET-BILL-CYCLE-OPEN-DT.                                     
P0726E                                                                  
P0726E     MOVE 'N'                       TO WS-ROW-FOUND.              
P0726E                                                                  
P0726E     PERFORM VARYING WS-BILL-SUB FROM 1 BY 1                      
P0726E       UNTIL WS-BILL-SUB > WS-BN-COUNT OR                         
P0726E             WS-DATE-EXTRACT-TB(WS-BILL-SUB) = SPACES             
P0726E          IF WS-CODE-BILL-COND-TB(WS-BILL-SUB) = 'R' AND          
P0726E             WS-ROW-FOUND NOT = 'Y'                               
P0726E             MOVE WS-DATE-EXTRACT-TB(WS-BILL-SUB)                 
P0726E                                    TO WS-BILL-CYCLE-OPEN-DT      
P0726E             MOVE 'Y'               TO WS-ROW-FOUND               
P0726E          END-IF                                                  
P0726E     END-PERFORM.                                                 
P0726E                                                                  
P0726E 2370-EXIT.                                                       
P0726E     EXIT.                                                        
P0726E                                                                  
P0726E******************************************************************        
P0726E* 2380-GET-BILL-CYCLE-CLOSE-DT                                   *        
P0726E******************************************************************        
P0726E                                                                  
P0726E 2380-GET-BILL-CYCLE-CLOSE-DT.                                    
P0726E                                                                  
P0726E     MOVE 'N'                       TO WS-ROW-FOUND.              
P0726E                                                                  
P0726E     PERFORM VARYING WS-BILL-SUB FROM 1 BY 1                      
P0726E       UNTIL WS-BILL-SUB > WS-BN-COUNT OR                         
P0726E             WS-DATE-EXTRACT-TB(WS-BILL-SUB) = SPACES             
P0726E          IF WS-CODE-BILL-COND-TB(WS-BILL-SUB) = 'C' AND          
P0726E             WS-ROW-FOUND NOT = 'Y'                               
P0726E             MOVE WS-DATE-EXTRACT-TB(WS-BILL-SUB)                 
P0726E                                    TO WS-BILL-CYCLE-CLOSE-DT     
P0726E             MOVE 'Y'               TO WS-ROW-FOUND               
P0726E          END-IF                                                  
P0726E     END-PERFORM.                                                 
P0726E                                                                  
P0726E 2380-EXIT.                                                       
P0726E     EXIT.                                                        
P0726E                                                                  
      ******************************************************************        
      * 2400-BUILD-RESULTS-1                                                    
      ******************************************************************        
                                                                        
       2400-BUILD-RESULTS-1.                                            
                                                                        
P0726F     EVALUATE WS-ARNG-TYPE(T1-INDX)                               
P0726F         WHEN 'CDD'                                               
P0726F         WHEN 'CDDA'                                              
P0726F              MOVE AT-TOTAL-AR-BALANCE  TO S-R1-STA-AMOUNT        
P0726F                                           S-R2-ARNG-TOTAL-AMT    
P00948              IF PARM-ARNG-CHANNEL-CD = 'I'                       
P00948                 MOVE '1900-01-01'      TO S-R1-NEW-STA-DNP-DATE  
P00948              ELSE                                                
P00948                 MOVE SPACE             TO S-R1-NEW-STA-DNP-DATE  
P00948              END-IF                                              
P0726F         WHEN 'STA'                                               
p00948         WHEN 'STF'                                               
P0726F              MOVE WS-STA-AMOUNT        TO S-R1-STA-AMOUNT        
P0726F                                           S-R2-ARNG-TOTAL-AMT    
P00948              MOVE WS-NEW-DNP-DATE      TO S-R1-NEW-STA-DNP-DATE  
P0726F         WHEN 'STAA'                                              
p00948         WHEN 'STFA'                                              
P0726F              MOVE WS-TOTAL-BALANCE-UTL TO S-R1-STA-AMOUNT        
P0726F                                           S-R2-ARNG-TOTAL-AMT    
P00948              MOVE WS-NEW-DNP-DATE      TO S-R1-NEW-STA-DNP-DATE  
P0726F     END-EVALUATE.                                                
P00948     IF ws-ARNG-TYPE(T1-INDX) = 'STF' OR 'STFA'                   
P00948        MOVE AT-COMPANY-NO         TO C8-COMPANY-NO               
P00948        MOVE WS-LEAST-AMT-DUE-CD   TO C8-DELINQ-CD                
P00948        PERFORM 7010-GET-DLINQ-VAL THRU 7010-EXIT                 
P00948        MOVE C8-DELINQ-VALUE       TO WS-LEAST-AMT-DUE            
P00948        COMPUTE S-R1-STA-AMOUNT     = S-R1-STA-AMOUNT -           
P00948                                      WS-LEAST-AMT-DUE            
P00948        COMPUTE S-R2-ARNG-TOTAL-AMT = S-R2-ARNG-TOTAL-AMT -       
P00948                                      WS-LEAST-AMT-DUE            
P00948     END-IF.                                                      
P0726J                                                                  
P0726J     PERFORM 2405-VALIDATE-CREDIT-ACTION                          
P0726J                                    THRU 2405-EXIT.               
P0726J                                                                  
P0726F*    TO SUPPORT LEGACY STA saved in CSS_STA_SUMMARY                       
P0726F     IF SEB-DATABASE AND WS-ARNG-TYPE(T1-INDX) = 'STA'            
P0726F        MOVE WS-NEW-DUE-DATE        TO S-R1-NEW-STA-DNP-DATE      
P0726F     END-IF                                                       
P0726E     MOVE ZEROES                    TO S-R1-APPL-RETURN-CODE      
P0726E     MOVE WS-NEW-DUE-DATE           TO S-R1-NEW-STA-DUE-DATE      
                                             S-R2-ARNG-DUE-DT.          
P0726E     MOVE WS-ARNG-ID(T1-INDX)       TO S-R1-ARNG-ID               
P0726E                                       S-R2-ARNG-ID.              
P0726E     MOVE WS-ARNG-TYPE(T1-INDX)     TO S-R1-ARNG-TYPE             
P0726E                                       S-R2-ARNG-TYPE.            
P0726E     MOVE WS-ARNG-OPTION-ID(T1-INDX)   TO S-R1-ARNG-OPTION-ID.    
P00948     MOVE WS-ARNG-PRIORITY(T1-INDX)    TO S-R1-ARNG-PRIORITY.     
P0726E     MOVE WS-ARNG-TERM-CD           TO S-R1-ARNG-TERM_CD.         
                                                                        
           PERFORM 8010-INSERT-GTT-R1     THRU 8010-EXIT.               
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
P0726F******************************************************************        
P0726J* 2405-VALIDATE-CREDIT-ACTION                                    *        
P0726J******************************************************************        
P0726J                                                                  
P0726J 2405-VALIDATE-CREDIT-ACTION.                                     
P0726J                                                                  
P0726J     MOVE 'N'                       TO WS-CREDIT-ACTION-FL.       
P0726J     IF WS-DATE-DISC(1:4) NUMERIC AND                             
P0726J        WS-DATE-DISC(6:2) NUMERIC AND                             
P0726J        WS-DATE-DISC(9:2) NUMERIC                                 
P0726J        IF WS-DATE-DISC >= WS-CURRENT-DATE                        
P0726J           MOVE 'Y'                 TO WS-CREDIT-ACTION-FL        
P0726J        END-IF                                                    
P0726J     ELSE                                                         
P0726J        IF WS-DATE-DISC = 'MULTIPLE'                              
P0726J           IF WS-DATE-CREDIT-ACTION-G >= WS-CURRENT-DATE OR       
P0726J              WS-DATE-CREDIT-ACTION-D >= WS-CURRENT-DATE OR       
P0726J              WS-DATE-CREDIT-ACTION-H >= WS-CURRENT-DATE OR       
P0726J              WS-DATE-CREDIT-ACTION-I >= WS-CURRENT-DATE          
P0726J              MOVE 'Y'              TO WS-CREDIT-ACTION-FL        
P0726J           END-IF                                                 
P0726J        END-IF                                                    
P0726J     END-IF.                                                      
P0726J                                                                  
P0726J     IF WS-DNP-FLAG = 'Y'                                         
P0726J        MOVE 'Y'                    TO WS-CREDIT-ACTION-FL        
P0726J     END-IF.                                                      
P0726J                                                                  
P0726J* GROUP1 SENIOR SCHEDULED TO MOVE TO GROUP2                               
P0726J                                                                  
P0726J     IF WS-REG-GROUP-CD = '100'  AND                              
P0726J        LR-SENIOR-FL = 'Y'       AND                              
P0726J        WS-GROUP1-TO-GROUP2-FL = 'Y' AND                          
P0726J        WS-DATE-NOTICE-MAIL-C > SPACES AND                        
P0726J        WS-AMT-NOTICE-C > WS-NOTICE-DNP-LIMIT                     
P0726J        MOVE 'Y'                    TO WS-CREDIT-ACTION-FL        
P0726J     END-IF.                                                      
P0726J     MOVE WS-CREDIT-ACTION-FL       TO S-R1-CREDIT-ACTION-FL.     
P0726J                                                                  
P0726J 2405-EXIT.                                                       
P0726J     EXIT.                                                        
P0726J                                                                  
P0726F******************************************************************        
P0726F* 2410-SCEG-STA-VALIDATION                                                
P0726F******************************************************************        
P0726F                                                                  
P0726F 2410-SCEG-STA-VALIDATION.                                        
P0726F                                                                  
P0726F* Account is in the New or Arrears credit group.                          
P0726F     IF AT-CODE-ACCT-STAT NOT = 'S' AND 'B'                       
P0726F        IF T2-RULE-ID(T2-INDX) = 'CRDARNG021'                     
P0726F           IF AT-CREDIT-GROUP = 'A' OR 'B' OR 'N'                 
P0726F              MOVE 'P' TO T4-RULE-RESULT-CD(T4-INDX)              
P0726F              MOVE 'A' TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)         
P0726F              PERFORM 5100-GET-BUSINESS-RULE        THRU 5100-EXIT
P0726F              GO TO 2410-EXIT                                     
P0726F           END-IF                                                 
P0726F        END-IF                                                    
P0726F* Account is in the Exempt credit group.                                  
P0726F        IF T2-RULE-ID(T2-INDX) = 'CRDARNG042'                     
P0726F           IF AT-CREDIT-GROUP = 'C'                               
P0726F              MOVE 'F'      TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F              MOVE 'A'      TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F              SET VALIDATION-FAILED           TO TRUE             
P0726F              PERFORM 5100-GET-BUSINESS-RULE        THRU 5100-EXIT
P0726F              GO TO 2410-EXIT                                     
P0726F           END-IF                                                 
P0726J        END-IF                                                    
P0726J     END-IF                                                       
P0726J                                                                  
P0726K* Account Status must be Active or FB to be eligible for STA              
P0726K     IF T2-RULE-ID(T2-INDX) = 'CRDARNG043'                        
P0726K        IF AT-CODE-ACCT-STAT NOT = 'A' AND 'B'                    
P0726K           MOVE 'F'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726K           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726K           SET VALIDATION-FAILED          TO TRUE                 
P0726K           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726K           GO TO 2410-EXIT                                        
P0726K        END-IF                                                    
P0726K     END-IF                                                       
P0726K                                                                  
P0726F     IF AT-CODE-ACCT-STAT = 'B'                                   
P0726F* STA Amount for Final Billed accounts includes non-utility chrgs         
P0726F        IF T2-RULE-ID(T2-INDX) = 'CRDARNG041'                     
P0726F           MOVE 'P'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           GO TO 2410-EXIT                                        
P0726F        END-IF                                                    
P0726F* Account does not have an STA eligible balance.                          
P0726F        IF T2-RULE-ID(T2-INDX) = 'CRDARNG053'                     
P0726F           IF WS-TOTAL-BALANCE <= 0                               
P0726F              MOVE 'F'      TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F              MOVE 'A'      TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F              SET VALIDATION-FAILED           TO TRUE             
P0726F              PERFORM 5100-GET-BUSINESS-RULE        THRU 5100-EXIT
P0726F              GO TO 2410-EXIT                                     
P0726F           END-IF                                                 
P0726F        END-IF                                                    
P0726F* This is a Final Billed account that is Guaranteed                       
P0726F        IF T2-RULE-ID(T2-INDX) = 'CRDARNG032'                     
P0726F           IF AT-ACCT-FINALED-DT > SPACES AND                     
P0726F              FW-GUARANTEED-IND = 'Y'                             
P0726F              MOVE 'P'      TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F              MOVE 'A'      TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F              PERFORM 5100-GET-BUSINESS-RULE        THRU 5100-EXIT
P0726F              GO TO 2410-EXIT                                     
P0726F           END-IF                                                 
P0726F        END-IF                                                    
P0726F* Account is Active or Final Billed                                       
P0726F        IF T2-RULE-ID(T2-INDX) = 'CRDARNG022'                     
P0726F           IF AT-ACCT-FINALED-DT > SPACES AND                     
P0726F              FW-GUARANTEED-IND NOT = 'Y'                         
P0726F                 MOVE 'P'   TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F                 MOVE 'A'   TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F                 PERFORM 5100-GET-BUSINESS-RULE     THRU 5100-EXIT
P0726F                 GO TO 2410-EXIT                                  
P0726F           END-IF                                                 
P0726F        END-IF                                                    
P0726F* Final Bill has not been generated. Unable to setup STA                  
P0726F        IF T2-RULE-ID(T2-INDX) = 'CRDARNG049'                     
P0726F           IF AT-ACCT-FINALED-DT = SPACES                         
P0726F              MOVE 'F'      TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F              MOVE 'A'      TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F              SET VALIDATION-FAILED           TO TRUE             
P0726F              PERFORM 5100-GET-BUSINESS-RULE        THRU 5100-EXIT
P0726F              GO TO 2410-EXIT                                     
P0726F           END-IF                                                 
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726F                                                                  
P0726F* Account with credit balance cannot be set up on STA                     
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG050'                        
P0726F        IF AT-TOTAL-AR-BALANCE < 0                                
P0726F           MOVE 'F'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           SET VALIDATION-FAILED           TO TRUE                
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           GO TO 2410-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726F                                                                  
P0726F     IF AT-CODE-ACCT-STAT = 'A'                                   
P0726F* Account is Active or Final Billed                                       
P0726F        IF T2-RULE-ID(T2-INDX) = 'CRDARNG022'                     
P0726F           MOVE 'P'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           GO TO 2410-EXIT                                        
P0726F        END-IF                                                    
P0726F* STA Cannot be created for Exceptional credit action                     
P0726F* Offer STF when exceptional credit action is from STA                    
P0726F        IF T2-RULE-ID(T2-INDX) = 'CRDARNG051'                     
P0726F           IF WS-NEAREST-DNP-DT > SPACES                          
P0726F              IF WS-NEAREST-DNP-DT = WS-DATE-CREDIT-ACTION-G      
P0948A                 IF (STAA-PROCESSED OR                            
P0948A                    WS-ACTIVE-ARNG-TYPE = SPACES OR 'STA') AND    
P0948A                    WS-ARNG-TYPE(T1-INDX) = 'STF' AND             
P0948A                    ARNG-COMPLIED AND NOT                         
P0948A                    (EXCPTNL-DNP AND VO-SERV-ORDER-STATUS > 26)   
P00948                   CONTINUE                                       
P00948                 ELSE                                             
P00948                   MOVE 'F'   TO T4-RULE-RESULT-CD(T4-INDX)       
P00948                   MOVE 'A'   TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)  
P00948                   SET VALIDATION-FAILED        TO TRUE           
P00948                   PERFORM 5100-GET-BUSINESS-RULE THRU 5100-EXIT  
P00948                 END-IF                                           
P0726F              END-IF                                              
P0726F           ELSE                                                   
P0726F              IF WS-DNP-FLAG = 'Y' AND VO-SERV-ORDER-STATUS < 26  
P0726F                 AND EXCPTNL-DNP                                  
P0726F                 MOVE 'F'   TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F                 MOVE 'A'   TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F                 SET VALIDATION-FAILED           TO TRUE          
P0726F                 PERFORM 5100-GET-BUSINESS-RULE     THRU 5100-EXIT
P0726F              END-IF                                              
P0726F           END-IF                                                 
P0726F           IF WS-PENDING-SO-FLAG = 'Y' AND WS-DNP-FLAG  = 'Y'     
P0726F              AND EXCPTNL-DNP AND WS-EXCPTNL-MSG NOT = 'Y'        
P0726F              MOVE 'F'      TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F              MOVE 'A'      TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F              SET VALIDATION-FAILED              TO TRUE          
P0726F              PERFORM 5100-GET-BUSINESS-RULE        THRU 5100-EXIT
P0726F           END-IF                                                 
P0726F           GO TO 2410-EXIT                                        
P0726F        END-IF                                                    
P0726F                                                                  
P0726F* Account has forecasted credit action or an Active DNP service           
P0726F        IF T2-RULE-ID(T2-INDX) = 'CRDARNG023'                     
P0726F           IF WS-NEAREST-DNP-DT > SPACES                          
P0726F              IF WS-NEAREST-DNP-DT NOT = WS-DATE-CREDIT-ACTION-G  
P0726F                 MOVE 'P'   TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F                 MOVE 'A'   TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F                 PERFORM 5100-GET-BUSINESS-RULE     THRU 5100-EXIT
P0726F              END-IF                                              
P0726F           ELSE                                                   
P0726F              IF WS-DNP-FLAG = 'Y' AND VO-SERV-ORDER-STATUS < 26  
P0726F                 AND NOT EXCPTNL-DNP                              
P0726F                 MOVE 'P'   TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F                 MOVE 'A'   TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F                 PERFORM 5100-GET-BUSINESS-RULE     THRU 5100-EXIT
P0726F              END-IF                                              
P0726F           END-IF                                                 
P0726F           GO TO 2410-EXIT                                        
P0726F        END-IF                                                    
P0726F* Future forecasted credit action does not exist or DNP order is c        
P0726F* urrently being initiated.                                               
P0726F        IF T2-RULE-ID(T2-INDX) = 'CRDARNG044'                     
P0726F           IF WS-NEAREST-DNP-DT = SPACES AND (WS-DNP-FLAG = 'N'   
P0726F              OR VO-SERV-ORDER-STATUS = 30)                       
P0726F              MOVE 'F'      TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F              MOVE 'A'      TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F              SET VALIDATION-FAILED          TO TRUE              
P0726F              PERFORM 5100-GET-BUSINESS-RULE        THRU 5100-EXIT
P0726F              GO TO 2410-EXIT                                     
P0726F           END-IF                                                 
P0726F        END-IF                                                    
P0726F                                                                  
P0726F        IF WS-PENDING-SO-FLAG = 'Y'                               
D03409* Account has an active DNP Service Order that is not yet                 
D03409* 'In Route' or 'On Site'.                                                
D03409           IF T2-RULE-ID(T2-INDX) = 'CRDARNG034'                  
D03409              IF WS-DNP-FLAG  = 'Y' AND NOT EXCPTNL-DNP AND       
D03409                 VO-SERV-ORDER-STATUS < 26                        
D03409                 MOVE 'P'   TO T4-RULE-RESULT-CD(T4-INDX)         
D03409                 MOVE 'A'   TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
D03409                 PERFORM 5100-GET-BUSINESS-RULE     THRU 5100-EXIT
D03409                 GO TO 2410-EXIT                                  
D03409              END-IF                                              
D03409           END-IF                                                 
D03409* Account has an active DNP Service Order that is already In-Rout.        
D03409           IF T2-RULE-ID(T2-INDX) = 'CRDARNG033'                  
D03409              IF WS-DNP-FLAG  = 'Y' AND NOT EXCPTNL-DNP AND       
D03409                 VO-SERV-ORDER-STATUS = 26                        
D03409                 MOVE 'P'   TO T4-RULE-RESULT-CD(T4-INDX)         
D03409                 MOVE 'A'   TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
D03409                 PERFORM 5100-GET-BUSINESS-RULE     THRU 5100-EXIT
D03409                 GO TO 2410-EXIT                                  
D03409              END-IF                                              
D03409           END-IF                                                 
D03409* Account has an active DNP Service Order that is 'On Site'.              
D03409* Short term arrangement cannot be established. Contact the               
D03409* dispatcher to make arrangements.                                        
D03409           IF T2-RULE-ID(T2-INDX) = 'CRDARNG045'                  
D03409              IF WS-DNP-FLAG  = 'Y' AND NOT EXCPTNL-DNP AND       
D03409                 VO-SERV-ORDER-STATUS >= 30                       
D03409                 MOVE 'F'   TO T4-RULE-RESULT-CD(T4-INDX)         
D03409                 MOVE 'A'   TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
D03409                 SET VALIDATION-FAILED          TO TRUE           
D03409                 PERFORM 5100-GET-BUSINESS-RULE     THRU 5100-EXIT
D03409                 GO TO 2410-EXIT                                  
D03409              END-IF                                              
D03409           END-IF                                                 
P0726F* Cannot establish payment arrangement if meter status is off             
P0726F           IF T2-RULE-ID(T2-INDX) = 'CRDARNG046'                  
P0726F              IF WS-DNP-FLAG  = 'N' AND WS-DNP-ACT-FLAG = 'Y'     
P0726F                 MOVE 'F'   TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F                 MOVE 'A'   TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F                 SET VALIDATION-FAILED          TO TRUE           
P0726F                 PERFORM 5100-GET-BUSINESS-RULE     THRU 5100-EXIT
P0726F                 GO TO 2410-EXIT                                  
P0726F              END-IF                                              
P0726F           END-IF                                                 
P0726F* STA006- DNP Worked - G                                                  
P0726F           IF T2-RULE-ID(T2-INDX) = 'CRDARNG091'                  
P0726F              IF WS-DNP-FLAG  = 'N' AND WS-DNP-ACT-FLAG = 'N'     
P0726F                 MOVE 'P'   TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F                 MOVE 'A'   TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F                 PERFORM 5100-GET-BUSINESS-RULE     THRU 5100-EXIT
P0726F                 GO TO 2410-EXIT                                  
P0726F              END-IF                                              
P0726F           END-IF                                                 
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726F                                                                  
P0726F* Account does not already have an active STA.                            
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG024'                        
P0726F        IF WS-CODE-STA-ACCT NOT = 'A'                             
P0726F           MOVE 'P'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           GO TO 2410-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726F                                                                  
P0726F* Account has an active STA.                                              
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG008'                        
P0726F        IF WS-CODE-STA-ACCT = 'A'                                 
P0948A           IF (STAA-PROCESSED OR                                  
P0948A              WS-ACTIVE-ARNG-TYPE = SPACES OR 'STA') AND          
P00948              WS-ARNG-TYPE(T1-INDX) = 'STF'                       
P00948              CONTINUE                                            
P00948           ELSE                                                   
P00948              IF WS-KR361-SETUP-BELOW-LMT-FL = 'Y'                
P0726F                 MOVE 'Y'      TO WS-STAA-ELIGIBLE-FL             
P0726F              END-IF                                              
P0726F              MOVE 'F'         TO T4-RULE-RESULT-CD(T4-INDX)      
P0726F              MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX) 
P0726F              SET VALIDATION-FAILED          TO TRUE              
P0726F              PERFORM 5100-GET-BUSINESS-RULE THRU 5100-EXIT       
P0726F              GO TO 2410-EXIT                                     
P0726F           END-IF                                                 
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726F                                                                  
P0726F* Account does not have an active DPP.                                    
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG025'                        
P0726F        IF WS-CODE-DPP-ACCT NOT = 'A'                             
P0726F           MOVE 'P'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           PERFORM 5100-GET-BUSINESS-RULE          THRU 5100-EXIT 
P0726F           GO TO 2410-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726F                                                                  
P0726F* Account does not already have an active DPP.                            
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG009'                        
P0726F        IF WS-CODE-DPP-ACCT = 'A'                                 
P0726F           MOVE 'F'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           SET VALIDATION-FAILED          TO TRUE                 
P0726F           GO TO 2410-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726F                                                                  
P0726F* Account does not have an active Medical Certificate.                    
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG026'                        
P0726F        IF WS-CODE-MEDICAL  NOT = 'A'                             
P0726F           MOVE 'P'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           GO TO 2410-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726F                                                                  
P0726F* Account has an active Medical Certificate.                              
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG010'                        
P0726F        IF WS-CODE-MEDICAL  = 'A'                                 
P0726F           MOVE 'F'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           SET VALIDATION-FAILED          TO TRUE                 
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           GO TO 2410-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726K* Account has unpaid Returned Check                                       
P0726K     IF T2-RULE-ID(T2-INDX) = 'CRDARNG047'                        
P00836        IF PARM-ARNG-CHANNEL-CD = 'I' OR 'W'                      
P0726K           IF WS-AMT-NSA-NSN > 0                                  
P0726K              MOVE 'F'      TO T4-RULE-RESULT-CD(T4-INDX)         
P0726K              MOVE 'A'      TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726K              SET VALIDATION-FAILED       TO TRUE                 
P0726K              PERFORM 5100-GET-BUSINESS-RULE        THRU 5100-EXIT
P0726K              GO TO 2410-EXIT                                     
P0726K           END-IF                                                 
P0726K        ELSE                                                      
P0726K           IF WS-AMT-NSA > 0                                      
P0726K              MOVE 'F'      TO T4-RULE-RESULT-CD(T4-INDX)         
P0726K              MOVE 'A'      TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726K              SET VALIDATION-FAILED       TO TRUE                 
P0726K              PERFORM 5100-GET-BUSINESS-RULE        THRU 5100-EXIT
P0726K              GO TO 2410-EXIT                                     
P0726K           END-IF                                                 
P0726K        END-IF                                                    
P0726K     END-IF                                                       
P0726F* Account does not have any unpaid Returned Checks for UTIL chrgs         
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG027'                        
P0726F        IF WS-AMT-NSA <= 0                                        
P0726F           MOVE 'P'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           GO TO 2410-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726F* Account does not have any unpaid deposit.                               
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG028'                        
P0726F        IF WS-UNPAID-DEPOSIT = 'N'                                
P0726F           MOVE 'P'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           GO TO 2410-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726F                                                                  
P0726K* Account has unpaid deposit.                                             
P0726K     IF T2-RULE-ID(T2-INDX) = 'CRDARNG035'                        
P0726K        IF WS-UNPAID-DEPOSIT = 'Y'                                
P00836           IF PARM-ARNG-CHANNEL-CD = 'I' OR 'W'                   
P0726K              MOVE 'F'      TO T4-RULE-RESULT-CD(T4-INDX)         
P0726K              SET VALIDATION-FAILED        TO TRUE                
P0726K           ELSE                                                   
P0726K              MOVE 'P'      TO T4-RULE-RESULT-CD(T4-INDX)         
P0726K           END-IF                                                 
P0726K           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726K           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726K           GO TO 2410-EXIT                                        
P0726K        END-IF                                                    
P0726K     END-IF                                                       
P0726F                                                                  
P0726F* Account has not had a payment posted in more than 60 days.              
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG036'                        
P0726F        IF WS-RECENT-PAYMENT = 'N'                                
P0726F           MOVE 'P'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           GO TO 2410-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726F                                                                  
P0726F* Account has had a payment posted within the past 60 days.               
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG029'                        
P0726F        IF WS-RECENT-PAYMENT = 'Y'                                
P0726F           MOVE 'P'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           GO TO 2410-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726F                                                                  
P0726F* Account has Utility charges that are 60 days or older.                  
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG037'                        
P0726F        IF WS-60-DAY-ARREARS = 'Y'                                
P0726F           MOVE 'P'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           GO TO 2410-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726F                                                                  
P0726F* Account was dropped from the most recent DPP.                           
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG038'                        
P0726F        PERFORM 7130-CHK-DPP-DROP                   THRU 7130-EXIT
P0726F        IF WS-DPP-DROP-EXISTS = 'Y'                               
P0726F           MOVE 'P'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           GO TO 2410-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726F                                                                  
P0726F* Account that has not yet gone thru initial billing                      
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG007'                        
P0726F        IF AT-REV-MTH-LST-NRML = ZEROES                           
P0726F           MOVE 'F'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           SET VALIDATION-FAILED          TO TRUE                 
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           GO TO 2410-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726F                                                                  
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG039'                        
P0726F        IF WS-60-DAY-AR-IND = 'Y'                                 
P0726F           MOVE 'P'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           GO TO 2410-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726F                                                                  
P0726F     IF WS-CODE-STA-ACCT NOT = 'A' AND AT-CODE-ACCT-STAT = 'A' AND
P0726F        WS-EXCPTNL-MSG = 'N' AND ( WS-DNP-FLAG = 'Y' OR           
P0726F        WS-NEAREST-DNP-DT > SPACES)                               
P0726F* Do not offer STA/STF when not enough time to send a notice.             
P0726F        IF T2-RULE-ID(T2-INDX) = 'CRDARNG054'                     
P0726F           IF (WS-FINAL-NOT-DT-DB2FMT <= WS-CURRENT-DATE     AND  
P0726F               WS-FINAL-NOT-DT-DB2FMT < WS-NEW-DNP-DT-DB2FMT AND  
P0726F               WS-FINAL-NOT-DT-DB2FMT > SPACES )             OR   
P0726F              (WS-NEW-DNP-DT-DB2FMT = WS-NEAREST-DNP-DT)          
P0726F              MOVE 'F'      TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F              MOVE 'A'      TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F              SET VALIDATION-FAILED          TO TRUE              
P0726F              PERFORM 5100-GET-BUSINESS-RULE        THRU 5100-EXIT
P0726F              GO TO 2410-EXIT                                     
P0726F           END-IF                                                 
P0726F        END-IF                                                    
P0726F     END-IF.                                                      
P0726F                                                                  
P0726F* Originally Due date is for current charges.                             
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG088'                        
P0726F        MOVE 'P'            TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F        MOVE 'A'            TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F        PERFORM 5100-GET-BUSINESS-RULE              THRU 5100-EXIT
P0726F        GO TO 2410-EXIT                                           
P0726F     END-IF                                                       
P0726F                                                                  
P0726F* Review Util chrgs: Account has Utility charges 60 days or older.        
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG087'                        
P0726F        PERFORM 2140-GET-60-DAY-OLD    THRU 2140-EXIT             
P0726F        IF WS-AMT-ARREARS-GR-60 > WS-NOTICE-DNP-LIMIT             
P0726F           MOVE 'P'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           GO TO 2410-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726F                                                                  
P0726F     IF WS-DATE-CREDIT-ACTION-I         > WS-CURRENT-DATE         
P0726F        MOVE 'Y'                      TO WS-BILL-IMED-DEP         
P0726F     END-IF.                                                      
P0726F                                                                  
P0726F     IF WS-BILL-IMED-DEP ='Y'                                     
P0726F* Account not eligible for STA.Reason:STA not allowed for Bill            
P0726F* Immediate Deposit DNP                                                   
P0726F        IF T2-RULE-ID(T2-INDX) = 'CRDARNG055'                     
P0726F           MOVE 'F'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           SET VALIDATION-FAILED          TO TRUE                 
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           GO TO 2410-EXIT                                        
P0726F        END-IF                                                    
P0726F     ELSE                                                         
P0726F* Account is not having Bill Immediate deposit DNP                        
P0726F        IF T2-RULE-ID(T2-INDX) = 'CRDARNG030'                     
P0726F           MOVE 'P'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           GO TO 2410-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF.                                                      
P0726F                                                                  
P0726F* Minimum amount needed for setting up any new arrangements               
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG101'                        
P0726F        IF WS-KR361-SETUP-BELOW-LMT-FL = 'Y'                      
P0726F           MOVE 'F'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           SET VALIDATION-FAILED          TO TRUE                 
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           GO TO 2410-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726F                                                                  
P00948* 60/90 days arrears must be less than limit amt                          
P00948     IF T2-RULE-ID(T2-INDX) = 'CRDARNG098'                        
P00948        IF WS-KR361-60-90-ATTR-FL = 'N'                           
P00948           SET VALIDATION-FAILED     TO TRUE                      
P00948           MOVE 'F'    TO T4-RULE-RESULT-CD(T4-INDX)              
P00948           MOVE 'A'    TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)         
P00948           PERFORM 5100-GET-BUSINESS-RULE    THRU 5100-EXIT       
P00948           GO TO 2410-EXIT                                        
P00948        END-IF                                                    
P00948     END-IF                                                       
P00948                                                                  
P00836     IF PARM-ARNG-CHANNEL-CD = 'I' OR 'W'                         
P0726K* BANK DRAFT OR E-DRAFT ACCOUNTS WILL NOT BE ELIGIBLE FOR CDD.            
P0726K        IF T2-RULE-ID(T2-INDX) = 'CRDARNG014'                     
P0726K           IF WS-CODE-BANK-EFT = 'A'                              
P0726K              MOVE 'F' TO T4-RULE-RESULT-CD(T4-INDX)              
P0726K              MOVE 'A' TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)         
P0726K              SET VALIDATION-FAILED TO TRUE                       
P0726K              PERFORM 5100-GET-BUSINESS-RULE THRU 5100-EXIT       
P0726K              GO TO 2410-EXIT                                     
P0726K           END-IF                                                 
P0726K        END-IF                                                    
P0726K* STA Compliance - Y                                                      
P0726K        IF T2-RULE-ID(T2-INDX) = 'CRDARNG061'                     
P0726K           IF (ws-STA-ARNG-CMPLD-IND = 'N' OR SPACES) AND         
P0726K              (WS-KR361-CMPL-CHECK-IVR-FL = 'Y')                  
P0726K              MOVE 'F' TO T4-RULE-RESULT-CD(T4-INDX)              
P0726K              MOVE 'A' TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)         
P0726K              SET VALIDATION-FAILED TO TRUE                       
P0726K              PERFORM 5100-GET-BUSINESS-RULE THRU 5100-EXIT       
P0726K              GO TO 2410-EXIT                                     
P0726K           END-IF                                                 
P0726K        END-IF                                                    
P0726K                                                                  
P0726K        IF T2-RULE-ID(T2-INDX) = 'CRDARNG102'                     
P0726K           IF AT-BILL-CYCLE-CHG-CD = 'F'                          
P0726K              MOVE 'F' TO T4-RULE-RESULT-CD(T4-INDX)              
P0726K              MOVE 'A' TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)         
P0726K              SET VALIDATION-FAILED TO TRUE                       
P0726K              PERFORM 5100-GET-BUSINESS-RULE THRU 5100-EXIT       
P0726K              GO TO 2410-EXIT                                     
P0726K           END-IF                                                 
P0726K        END-IF                                                    
P0726K                                                                  
D03409* Account has an active DNP Service Order that is not yet                 
D03409* 'In Route' or 'On Site'.                                                
D03409        IF T2-RULE-ID(T2-INDX) = 'CRDARNG034'                     
D03409           IF WS-DNP-FLAG  = 'Y' AND NOT EXCPTNL-DNP AND          
D03409              VO-SERV-ORDER-STATUS < 26                           
D03409              MOVE 'P'   TO T4-RULE-RESULT-CD(T4-INDX)            
D03409              MOVE 'A'   TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)       
D03409              PERFORM 5100-GET-BUSINESS-RULE     THRU 5100-EXIT   
D03409              GO TO 2410-EXIT                                     
D03409           END-IF                                                 
D03409        END-IF                                                    
D03409                                                                  
D03409* Account has an active DNP Service Order that is 'On Site'.              
D03409* Short term arrangement cannot be established. Contact the               
D03409* dispatcher to make arrangements.                                        
D03409        IF T2-RULE-ID(T2-INDX) = 'CRDARNG045'                     
D03409           IF WS-DNP-FLAG  = 'Y' AND NOT EXCPTNL-DNP AND          
D03409              VO-SERV-ORDER-STATUS >= 26                          
D03409              MOVE 'F'   TO T4-RULE-RESULT-CD(T4-INDX)            
D03409              MOVE 'A'   TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)       
D03409              SET VALIDATION-FAILED          TO TRUE              
D03409              PERFORM 5100-GET-BUSINESS-RULE     THRU 5100-EXIT   
D03409              GO TO 2410-EXIT                                     
D03409           END-IF                                                 
D03409        END-IF                                                    
P0726K                                                                  
P0726K        IF T2-RULE-ID(T2-INDX) = 'CRDARNG219'                     
P0726K           IF AT-BANKRUPTCY-IND NOT = SPACES OR                   
P0726K              AT-JUDGEMENT-IND  NOT = SPACES                      
P0726K              MOVE 'F' TO T4-RULE-RESULT-CD(T4-INDX)              
P0726K              MOVE 'A' TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)         
P0726K              SET VALIDATION-FAILED TO TRUE                       
P0726K              PERFORM 5100-GET-BUSINESS-RULE THRU 5100-EXIT       
P0726K              GO TO 2410-EXIT                                     
P0726K           END-IF                                                 
P0726K        END-IF                                                    
P0726K                                                                  
P0726K        IF T2-RULE-ID(T2-INDX) = 'CRDARNG220'                     
P0726K           IF WS-ORIGINAL-DNP-DATE = WS-CURRENT-DATE              
P0726K              MOVE WS-WQ-STA-START-TIME TO WS-WQ-STA-START-TIME-N 
P0726K              MOVE WS-WQ-STA-START-TIME-N                         
P0726K                                        TO WS-WQ-STA-START-TIME-A 
P0726K              MOVE WS-CURRENT-TIMESTMP  TO WS-TS-FULL             
P0726K              MOVE WS-TS-HOUR           TO WS-TIME-HOUR           
P0726K              MOVE WS-TS-MIN            TO WS-TIME-MIN            
P0726K              IF WS-TIME > WS-WQ-STA-START-TIME-A                 
P0726K                 MOVE 'F' TO T4-RULE-RESULT-CD(T4-INDX)           
P0726K                 MOVE 'A' TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)      
P0726K                 SET VALIDATION-FAILED  TO TRUE                   
P0726K                 PERFORM 5100-GET-BUSINESS-RULE    THRU 5100-EXIT 
P0726K                 GO TO 2410-EXIT                                  
P0726K              END-IF                                              
P0726K           END-IF                                                 
P0726K        END-IF                                                    
P0726K     END-IF.                                                      
P0726K                                                                  
P0726F     PERFORM 2610-CTMTR-MAJOR-ACCT-CHK             THRU 2610-EXIT.
P0726F                                                                  
P0726F 2410-EXIT.                                                       
P0726F     EXIT.                                                        
P0726F                                                                  
P0726F******************************************************************        
P0726F* 2420-PSNC-STA-VALIDATION                                                
P0726F******************************************************************        
P0726F                                                                  
P0726F 2420-PSNC-STA-VALIDATION.                                        
P0726F                                                                  
P0726F     IF AT-CODE-ACCT-STAT NOT = 'S' AND 'B'                       
P0726F* Account is in the New or Arrears credit group.                          
P0726F        IF T2-RULE-ID(T2-INDX) = 'CRDARNG021'                     
P0726F           IF AT-CREDIT-GROUP = 'A' OR 'N'                        
P0726F              MOVE 'P'      TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F              MOVE 'A'      TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F              PERFORM 5100-GET-BUSINESS-RULE        THRU 5100-EXIT
P0726F              GO TO 2420-EXIT                                     
P0726F           END-IF                                                 
P0726F        END-IF                                                    
P0726F* Account is in the Exempt credit group.                                  
P0726F        IF T2-RULE-ID(T2-INDX) = 'CRDARNG042'                     
P0726F           IF AT-CREDIT-GROUP NOT = 'A' AND 'N'                   
P0726F              MOVE 'F'      TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F              MOVE 'A'      TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F              SET VALIDATION-FAILED          TO TRUE              
P0726F              PERFORM 5100-GET-BUSINESS-RULE        THRU 5100-EXIT
P0726F              GO TO 2420-EXIT                                     
P0726F           END-IF                                                 
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726F                                                                  
P0726F     IF AT-CODE-ACCT-STAT = 'B'                                   
P0726F* STA Amount for Final Billed accounts includes non-utility chrgs         
P0726F        IF T2-RULE-ID(T2-INDX) = 'CRDARNG041'                     
P0726F           MOVE 'P'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           GO TO 2420-EXIT                                        
P0726F        END-IF                                                    
P0726F* Account does not have an STA eligible balance.                          
P0726F        IF T2-RULE-ID(T2-INDX) = 'CRDARNG053'                     
P0726F           IF WS-TOTAL-BALANCE <= 0                               
P0726F              MOVE 'F'      TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F              MOVE 'A'      TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F              SET VALIDATION-FAILED          TO TRUE              
P0726F              PERFORM 5100-GET-BUSINESS-RULE        THRU 5100-EXIT
P0726F              GO TO 2420-EXIT                                     
P0726F           END-IF                                                 
P0726F        END-IF                                                    
P0726F* This is a Final Billed account that is Guaranteed                       
P0726F        IF T2-RULE-ID(T2-INDX) = 'CRDARNG032'                     
P0726F           IF AT-ACCT-FINALED-DT > SPACES AND                     
P0726F              FW-GUARANTEED-IND = 'Y'                             
P0726F              MOVE 'P'   TO T4-RULE-RESULT-CD(T4-INDX)            
P0726F              MOVE 'A'   TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)       
P0726F              PERFORM 5100-GET-BUSINESS-RULE        THRU 5100-EXIT
P0726F              GO TO 2420-EXIT                                     
P0726F           END-IF                                                 
P0726F        END-IF                                                    
P0726F* Account is Active or Final Billed                                       
P0726F        IF T2-RULE-ID(T2-INDX) = 'CRDARNG022'                     
P0726F           IF AT-ACCT-FINALED-DT > SPACES AND                     
P0726F              FW-GUARANTEED-IND NOT = 'Y'                         
P0726F                 MOVE 'P'   TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F                 MOVE 'A'   TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F                 PERFORM 5100-GET-BUSINESS-RULE     THRU 5100-EXIT
P0726F                 GO TO 2420-EXIT                                  
P0726F           END-IF                                                 
P0726F        END-IF                                                    
P0726F* Final Bill has not been generated. Unable to setup STA                  
P0726F        IF T2-RULE-ID(T2-INDX) = 'CRDARNG049'                     
P0726F           IF AT-ACCT-FINALED-DT = SPACES                         
P0726F              MOVE 'F'      TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F              MOVE 'A'      TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F              SET VALIDATION-FAILED          TO TRUE              
P0726F              PERFORM 5100-GET-BUSINESS-RULE        THRU 5100-EXIT
P0726F              GO TO 2420-EXIT                                     
P0726F           END-IF                                                 
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726F                                                                  
P0726F* Account with credit balance cannot be set up on STA                     
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG050'                        
P0726F        IF AT-TOTAL-AR-BALANCE < 0                                
P0726F           MOVE 'F'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           SET VALIDATION-FAILED           TO TRUE                
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           GO TO 2420-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726F                                                                  
P0726F* Account Status must be Active or FB to be eligible for STA              
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG043'                        
P0726F        IF AT-CODE-ACCT-STAT NOT = 'A' AND 'B'                    
P0726F           MOVE 'F'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           SET VALIDATION-FAILED           TO TRUE                
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           GO TO 2420-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726F                                                                  
P0726F     IF AT-CODE-ACCT-STAT = 'A'                                   
P0726F* Account is Active or Final Billed                                       
P0726F        IF T2-RULE-ID(T2-INDX) = 'CRDARNG022'                     
P0726F           MOVE 'P'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           GO TO 2420-EXIT                                        
P0726F        END-IF                                                    
P0726F* STA Cannot be created for Exceptional credit action                     
P0726F* Offer STF when exceptional credit action is from STA                    
P0726F        IF T2-RULE-ID(T2-INDX) = 'CRDARNG051'                     
P0726F           IF WS-NEAREST-DNP-DT > SPACES                          
P0726F              IF WS-NEAREST-DNP-DT = WS-DATE-CREDIT-ACTION-G      
P0948A                 IF (STAA-PROCESSED OR                            
P0948A                    WS-ACTIVE-ARNG-TYPE = SPACES OR 'STA') AND    
P0948A                    WS-ARNG-TYPE(T1-INDX) = 'STF' AND             
P0948A                    ARNG-COMPLIED AND NOT                         
P0948A                    (EXCPTNL-DNP AND VO-SERV-ORDER-STATUS > 26)   
P00948                   CONTINUE                                       
P00948                 ELSE                                             
P00948                   MOVE 'F'   TO T4-RULE-RESULT-CD(T4-INDX)       
P00948                   MOVE 'A'   TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)  
P00948                   SET VALIDATION-FAILED        TO TRUE           
P00948                   PERFORM 5100-GET-BUSINESS-RULE THRU 5100-EXIT  
P00948                 END-IF                                           
P0726F              END-IF                                              
P0726F           ELSE                                                   
P0726F              IF WS-DNP-FLAG = 'Y' AND VO-SERV-ORDER-STATUS < 26  
P0726F                 AND EXCPTNL-DNP                                  
P0726F                 MOVE 'F'   TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F                 MOVE 'A'   TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F                 SET VALIDATION-FAILED           TO TRUE          
P0726F                 PERFORM 5100-GET-BUSINESS-RULE     THRU 5100-EXIT
P0726F              END-IF                                              
P0726F           END-IF                                                 
P0726F           IF WS-PENDING-SO-FLAG = 'Y' AND WS-DNP-FLAG  = 'Y'     
P0726F              AND EXCPTNL-DNP AND WS-EXCPTNL-MSG NOT = 'Y'        
P0726F              MOVE 'F'      TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F              MOVE 'A'      TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F              SET VALIDATION-FAILED              TO TRUE          
P0726F              PERFORM 5100-GET-BUSINESS-RULE        THRU 5100-EXIT
P0726F           END-IF                                                 
P0726F           GO TO 2420-EXIT                                        
P0726F        END-IF                                                    
P0726F                                                                  
P0726F* Account has forecasted credit action or an Active DNP service           
P0726F        IF T2-RULE-ID(T2-INDX) = 'CRDARNG023'                     
P0726F           IF WS-NEAREST-DNP-DT > SPACES                          
P0726F              IF WS-NEAREST-DNP-DT NOT = WS-DATE-CREDIT-ACTION-G  
P0726F                 MOVE 'P'   TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F                 MOVE 'A'   TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F                 PERFORM 5100-GET-BUSINESS-RULE     THRU 5100-EXIT
P0726F              END-IF                                              
P0726F           ELSE                                                   
P0726F              IF WS-DNP-FLAG = 'Y' AND VO-SERV-ORDER-STATUS < 26  
P0726F                 AND NOT EXCPTNL-DNP                              
P0726F                 MOVE 'P'   TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F                 MOVE 'A'   TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F                 PERFORM 5100-GET-BUSINESS-RULE     THRU 5100-EXIT
P0726F              END-IF                                              
P0726F           END-IF                                                 
P0726F           GO TO 2420-EXIT                                        
P0726F        END-IF                                                    
P0726F* Future forecasted credit action does not exist or DNP order is c        
P0726F* urrently being initiated.                                               
P0726F        IF T2-RULE-ID(T2-INDX) = 'CRDARNG044'                     
P0726F           IF WS-NEAREST-DNP-DT = SPACES AND (WS-DNP-FLAG = 'N'   
P0726F              OR VO-SERV-ORDER-STATUS = 30)                       
P0726F              MOVE 'F'      TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F              MOVE 'A'      TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F              SET VALIDATION-FAILED           TO TRUE             
P0726F              PERFORM 5100-GET-BUSINESS-RULE        THRU 5100-EXIT
P0726F              GO TO 2420-EXIT                                     
P0726F           END-IF                                                 
P0726F        END-IF                                                    
P0726F                                                                  
P0726F        IF WS-PENDING-SO-FLAG = 'Y'                               
D03409* Account has an active DNP Service Order that is not yet                 
D03409* 'In Route' or 'On Site'.                                                
D03409           IF T2-RULE-ID(T2-INDX) = 'CRDARNG034'                  
D03409              IF WS-DNP-FLAG  = 'Y' AND NOT EXCPTNL-DNP AND       
D03409                 VO-SERV-ORDER-STATUS < 26                        
D03409                 MOVE 'P'   TO T4-RULE-RESULT-CD(T4-INDX)         
D03409                 MOVE 'A'   TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
D03409                 PERFORM 5100-GET-BUSINESS-RULE     THRU 5100-EXIT
D03409                 GO TO 2420-EXIT                                  
D03409              END-IF                                              
D03409           END-IF                                                 
D03409* Account has an active DNP Service Order that is already In-Rout.        
D03409           IF T2-RULE-ID(T2-INDX) = 'CRDARNG033'                  
D03409              IF WS-DNP-FLAG  = 'Y' AND NOT EXCPTNL-DNP AND       
D03409                 VO-SERV-ORDER-STATUS = 26                        
D03409                 MOVE 'P'   TO T4-RULE-RESULT-CD(T4-INDX)         
D03409                 MOVE 'A'   TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
D03409                 PERFORM 5100-GET-BUSINESS-RULE     THRU 5100-EXIT
D03409                 GO TO 2420-EXIT                                  
D03409              END-IF                                              
D03409           END-IF                                                 
D03409* Account has an active DNP Service Order that is 'On Site'.              
D03409* Short term arrangement cannot be established. Contact the               
D03409* dispatcher to make arrangements.                                        
D03409           IF T2-RULE-ID(T2-INDX) = 'CRDARNG045'                  
D03409              IF WS-DNP-FLAG  = 'Y' AND NOT EXCPTNL-DNP AND       
D03409                 VO-SERV-ORDER-STATUS >= 30                       
D03409                 MOVE 'F'   TO T4-RULE-RESULT-CD(T4-INDX)         
D03409                 MOVE 'A'   TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
D03409                 SET VALIDATION-FAILED          TO TRUE           
D03409                 PERFORM 5100-GET-BUSINESS-RULE     THRU 5100-EXIT
D03409                 GO TO 2420-EXIT                                  
D03409              END-IF                                              
D03409           END-IF                                                 
P0726F* Cannot establish payment arrangement if meter status is off             
P0726F           IF T2-RULE-ID(T2-INDX) = 'CRDARNG046'                  
P0726F              IF WS-DNP-FLAG  = 'N' AND WS-DNP-ACT-FLAG = 'Y'     
P0726F                 MOVE 'F'   TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F                 MOVE 'A'   TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F                 SET VALIDATION-FAILED          TO TRUE           
P0726F                 PERFORM 5100-GET-BUSINESS-RULE     THRU 5100-EXIT
P0726F                 GO TO 2420-EXIT                                  
P0726F              END-IF                                              
P0726F           END-IF                                                 
P0726F           IF T2-RULE-ID(T2-INDX) = 'CRDARNG091'                  
P0726F              IF WS-DNP-FLAG  = 'N' AND WS-DNP-ACT-FLAG = 'N'     
P0726F                 MOVE 'P'   TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F                 MOVE 'A'   TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F                 PERFORM 5100-GET-BUSINESS-RULE     THRU 5100-EXIT
P0726F                 GO TO 2420-EXIT                                  
P0726F              END-IF                                              
P0726F           END-IF                                                 
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726F                                                                  
P0726F* Account does not already have an active STA.                            
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG024'                        
P0726F        IF WS-CODE-STA-ACCT NOT = 'A'                             
P0726F           MOVE 'P'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           GO TO 2420-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726F                                                                  
P0726F* Account has an active STA.                                              
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG008'                        
P0726F        IF WS-CODE-STA-ACCT = 'A'                                 
P0948A           IF (STAA-PROCESSED OR                                  
P00948              WS-ACTIVE-ARNG-TYPE = SPACES OR 'STA') AND          
P00948              WS-ARNG-TYPE(T1-INDX) = 'STF'                       
P00948              CONTINUE                                            
P00948           ELSE                                                   
P00948              IF WS-KR361-SETUP-BELOW-LMT-FL = 'Y'                
P0726F                 MOVE 'Y'      TO WS-STAA-ELIGIBLE-FL             
P0726F              END-IF                                              
P0726F              MOVE 'F'         TO T4-RULE-RESULT-CD(T4-INDX)      
P0726F              MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX) 
P0726F              SET VALIDATION-FAILED          TO TRUE              
P0726F              PERFORM 5100-GET-BUSINESS-RULE THRU 5100-EXIT       
P0726F              GO TO 2420-EXIT                                     
P0726F           END-IF                                                 
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726F                                                                  
P0726F* Account does not have an active DPP.                                    
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG025'                        
P0726F        IF WS-CODE-DPP-ACCT NOT = 'A'                             
P0726F           MOVE 'P'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           GO TO 2420-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726F                                                                  
P0726F* Account does not already have an active DPP.                            
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG009'                        
P0726F        IF WS-CODE-DPP-ACCT = 'A'                                 
P0726F           MOVE 'F'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           SET VALIDATION-FAILED          TO TRUE                 
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           GO TO 2420-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726F                                                                  
P0726F* Account has an active Medical Certificate.                              
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG010'                        
P0726F        IF WS-CODE-MEDICAL  = 'A'                                 
P0726F           MOVE 'F'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           SET VALIDATION-FAILED          TO TRUE                 
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           GO TO 2420-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726F                                                                  
P0726F     IF WS-CODE-MEDICAL  NOT = 'A'                                
P0726F        IF WS-DAYS-EXPIRE > 0 AND WS-DAYS-EXPIRE <= 30            
P0726F* Account does not have an active Medical Certificate                     
P0726F           IF T2-RULE-ID(T2-INDX) = 'CRDARNG060'                  
P0726F              MOVE 'P'      TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F              MOVE 'A'      TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F              PERFORM 5100-GET-BUSINESS-RULE        THRU 5100-EXIT
P0726F              GO TO 2420-EXIT                                     
P0726F           END-IF                                                 
P0726F        ELSE                                                      
P0726F* Med Certificate - Y                                                     
P0726F           IF T2-RULE-ID(T2-INDX) = 'CRDARNG026'                  
P0726F              MOVE 'P'      TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F              MOVE 'A'      TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F              PERFORM 5100-GET-BUSINESS-RULE        THRU 5100-EXIT
P0726F              GO TO 2420-EXIT                                     
P0726F           END-IF                                                 
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726F                                                                  
P0726K* Account has unpaid Returned Check                                       
P0726K     IF T2-RULE-ID(T2-INDX) = 'CRDARNG047'                        
P00836        IF PARM-ARNG-CHANNEL-CD = 'I' OR 'W'                      
P0726K           IF WS-AMT-NSA-NSN > 0                                  
P0726K              MOVE 'F'      TO T4-RULE-RESULT-CD(T4-INDX)         
P0726K              MOVE 'A'      TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726K              SET VALIDATION-FAILED       TO TRUE                 
P0726K              PERFORM 5100-GET-BUSINESS-RULE        THRU 5100-EXIT
P0726K              GO TO 2420-EXIT                                     
P0726K           END-IF                                                 
P0726K        ELSE                                                      
P0726K           IF WS-AMT-NSA > 0                                      
P0726K              MOVE 'F'      TO T4-RULE-RESULT-CD(T4-INDX)         
P0726K              MOVE 'A'      TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726K              SET VALIDATION-FAILED       TO TRUE                 
P0726K              PERFORM 5100-GET-BUSINESS-RULE        THRU 5100-EXIT
P0726K              GO TO 2420-EXIT                                     
P0726K           END-IF                                                 
P0726K        END-IF                                                    
P0726K     END-IF                                                       
P0726F* Account does not have any unpaid Returned Checks for UTIL chrgs         
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG027'                        
P0726F        IF WS-AMT-NSA <= 0                                        
P0726F           MOVE 'P'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           GO TO 2420-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726F* Account does not have any unpaid deposit.                               
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG028'                        
P0726F        IF WS-UNPAID-DEPOSIT = 'N'                                
P0726F           MOVE 'P'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           GO TO 2420-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726F                                                                  
P0726K* Account has unpaid deposit.                                             
P0726K     IF T2-RULE-ID(T2-INDX) = 'CRDARNG035'                        
P0726K        IF WS-UNPAID-DEPOSIT = 'Y'                                
P00836           IF PARM-ARNG-CHANNEL-CD = 'I' OR 'W'                   
P0726K              MOVE 'F'      TO T4-RULE-RESULT-CD(T4-INDX)         
P0726K              SET VALIDATION-FAILED        TO TRUE                
P0726K           ELSE                                                   
P0726K              MOVE 'P'      TO T4-RULE-RESULT-CD(T4-INDX)         
P0726K           END-IF                                                 
P0726K           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726K           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726K           GO TO 2420-EXIT                                        
P0726K        END-IF                                                    
P0726K     END-IF                                                       
P0726F                                                                  
P0726F* Account has not had a payment posted in more than 60 days.              
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG036'                        
P0726F        IF WS-RECENT-PAYMENT = 'N'                                
P0726F           MOVE 'P'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           GO TO 2420-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726F                                                                  
P0726F* Account has had a payment posted within the past 60 days.               
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG029'                        
P0726F        IF WS-RECENT-PAYMENT = 'Y'                                
P0726F           MOVE 'P'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           GO TO 2420-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726F                                                                  
P0726F* Account has Utility charges that are 60 days or older.                  
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG037'                        
P0726F        IF WS-60-DAY-ARREARS = 'Y'                                
P0726F           MOVE 'P'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           GO TO 2420-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726F                                                                  
P0726K* STA Compliance - Y                                                      
P0726K     IF T2-RULE-ID(T2-INDX) = 'CRDARNG061'                        
P0726K        IF ws-STA-ARNG-CMPLD-IND = 'N' OR SPACES                  
P00836           IF ((PARM-ARNG-CHANNEL-CD = 'I' OR 'W') AND            
P00836              (WS-KR361-CMPL-CHECK-IVR-FL = 'Y'))                 
P0726K              MOVE 'F'      TO T4-RULE-RESULT-CD(T4-INDX)         
P0726K              SET VALIDATION-FAILED        TO TRUE                
P0726K           ELSE                                                   
P0726K              MOVE 'P'      TO T4-RULE-RESULT-CD(T4-INDX)         
P0726K           END-IF                                                 
P0726K           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726K           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726K           GO TO 2420-EXIT                                        
P0726K        END-IF                                                    
P0726K     END-IF                                                       
P0726F                                                                  
P0726F* Account was dropped from the most recent DPP.                           
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG038'                        
P0726F        PERFORM 7130-CHK-DPP-DROP                   THRU 7130-EXIT
P0726F        IF WS-DPP-DROP-EXISTS = 'Y'                               
P0726F           MOVE 'P'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           GO TO 2420-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726F                                                                  
P0726F* BBP Compliance                                                          
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG062'                        
P0726F        PERFORM 7160-SELECT-BBP-COMPLIANCE          THRU 7160-EXIT
P0726F        MOVE BH-BUD-HIST-SEQ-NO(1:10)      TO WS-BUD-HIST-DT      
P0726F        IF BH-CHANGE-REASON = 'D' AND                             
P0726F           BH-REMARKS-TEXT(1:BH-REMARKS-LEN) =                    
P0726F                           'AUTOMATICALLY DROPPED FROM EPP' AND   
P0726F           WS-BUD-HIST-DT  > WS-3MNTHS-CHK-DT                     
P0726F           MOVE 'P'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           GO TO 2420-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726F                                                                  
P0726F* Account that has not yet gone thru initial billing                      
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG007'                        
P0726F        IF AT-REV-MTH-LST-NRML = ZEROES                           
P0726F           MOVE 'F'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           SET VALIDATION-FAILED          TO TRUE                 
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           GO TO 2420-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726F                                                                  
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG039'                        
P0726F        IF WS-60-DAY-AR-IND = 'Y'                                 
P0726F           MOVE 'P'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           GO TO 2420-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726F                                                                  
      *                                                                         
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG040'                        
P0726F        IF WS-CODE-STA-ACCT NOT = 'A' AND AT-CODE-ACCT-STAT = 'A' 
P0726F           AND WS-EXCPTNL-MSG = 'N' AND ( WS-DNP-FLAG = 'Y' OR    
P0726F           WS-NEAREST-DNP-DT > SPACES)                            
P0726F* Notice the customer verbally about the CUT.                             
P0726F           IF WS-FINAL-NOT-DT-DB2FMT > SPACES AND                 
P0726F              WS-FINAL-NOT-DT-DB2FMT <= WS-CURRENT-DATE AND       
P0726F              WS-FINAL-NOT-DT-DB2FMT < WS-NEW-DNP-DT-DB2FMT       
P00836              IF PARM-ARNG-CHANNEL-CD = 'I' OR 'W'                
P0726K                 MOVE 'F'   TO T4-RULE-RESULT-CD(T4-INDX)         
P0726K                 SET VALIDATION-FAILED TO TRUE                    
P0726K              ELSE                                                
P0726K                 MOVE 'P'   TO T4-RULE-RESULT-CD(T4-INDX)         
P0726K              END-IF                                              
P0726L              MOVE 'P'      TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726L              MOVE SPACES   TO WS-FINAL-NOT-MAIL-DT               
P0726K              PERFORM 5100-GET-BUSINESS-RULE        THRU 5100-EXIT
P0726K              GO TO 2420-EXIT                                     
P0726K           END-IF                                                 
P0726K        END-IF                                                    
P0726K     END-IF                                                       
P0726F                                                                  
P0726F* Originally Due date is for current charges.                             
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG088'                        
P0726F        MOVE 'P'            TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F        MOVE 'A'            TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F        PERFORM 5100-GET-BUSINESS-RULE              THRU 5100-EXIT
P0726F        GO TO 2420-EXIT                                           
P0726F     END-IF                                                       
P0726F                                                                  
P0726F* Review Util chrgs: Account has Utility charges 60 days or older.        
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG087'                        
P0726F        PERFORM 2140-GET-60-DAY-OLD                 THRU 2140-EXIT
P0726F        IF WS-AMT-ARREARS-GR-60 > WS-NOTICE-DNP-LIMIT             
P0726F           MOVE 'P'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           GO TO 2420-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726F                                                                  
P0726F     IF WS-DATE-CREDIT-ACTION-I         > WS-CURRENT-DATE         
P0726F        MOVE 'Y'            TO WS-BILL-IMED-DEP                   
P0726F     END-IF.                                                      
P0726F                                                                  
P0726F     IF WS-BILL-IMED-DEP ='Y'                                     
P0726F* Account not eligible for STA.Reason:STA not allowed for Bill            
P0726F* Immediate Deposit DNP                                                   
P0726F        IF T2-RULE-ID(T2-INDX) = 'CRDARNG055'                     
P0726F           MOVE 'F'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           SET VALIDATION-FAILED          TO TRUE                 
P0726F           GO TO 2420-EXIT                                        
P0726F        END-IF                                                    
P0726F     ELSE                                                         
P0726F* Account is not having Bill Immediate deposit DNP                        
P0726F        IF T2-RULE-ID(T2-INDX) = 'CRDARNG030'                     
P0726F           MOVE 'P'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           GO TO 2420-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF.                                                      
P0726F                                                                  
P0726F* Minimum amount needed for setting up any new arrangements               
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG101'                        
P0726F        IF WS-KR361-SETUP-BELOW-LMT-FL = 'Y'                      
P0726F           MOVE 'F'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           SET VALIDATION-FAILED          TO TRUE                 
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           GO TO 2420-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726K                                                                  
P00948* 60/90 days arrears must be less than limit amt                          
P00948     IF T2-RULE-ID(T2-INDX) = 'CRDARNG098'                        
P00948        IF WS-KR361-60-90-ATTR-FL = 'N'                           
P00948           SET VALIDATION-FAILED     TO TRUE                      
P00948           MOVE 'F'    TO T4-RULE-RESULT-CD(T4-INDX)              
P00948           MOVE 'A'    TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)         
P00948           PERFORM 5100-GET-BUSINESS-RULE    THRU 5100-EXIT       
P00948           GO TO 2420-EXIT                                        
P00948        END-IF                                                    
P00948     END-IF                                                       
P00948                                                                  
P00836     IF PARM-ARNG-CHANNEL-CD = 'I' OR 'W'                         
P0726K* BANK DRAFT OR E-DRAFT ACCOUNTS WILL NOT BE ELIGIBLE FOR CDD.            
P0726K        IF T2-RULE-ID(T2-INDX) = 'CRDARNG014'                     
P0726K           IF WS-CODE-BANK-EFT = 'A'                              
P0726K              MOVE 'F' TO T4-RULE-RESULT-CD(T4-INDX)              
P0726K              MOVE 'A' TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)         
P0726K              SET VALIDATION-FAILED TO TRUE                       
P0726K              PERFORM 5100-GET-BUSINESS-RULE THRU 5100-EXIT       
P0726K              GO TO 2420-EXIT                                     
P0726K           END-IF                                                 
P0726K        END-IF                                                    
P0726K                                                                  
P0726K        IF T2-RULE-ID(T2-INDX) = 'CRDARNG102'                     
P0726K           IF AT-BILL-CYCLE-CHG-CD = 'F'                          
P0726K              MOVE 'F' TO T4-RULE-RESULT-CD(T4-INDX)              
P0726K              MOVE 'A' TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)         
P0726K              SET VALIDATION-FAILED TO TRUE                       
P0726K              PERFORM 5100-GET-BUSINESS-RULE THRU 5100-EXIT       
P0726K              GO TO 2420-EXIT                                     
P0726K           END-IF                                                 
P0726K        END-IF                                                    
P0726K                                                                  
D03409* Account has an active DNP Service Order that is not yet                 
D03409* 'In Route' or 'On Site'.                                                
D03409        IF T2-RULE-ID(T2-INDX) = 'CRDARNG034'                     
D03409           IF WS-DNP-FLAG  = 'Y' AND NOT EXCPTNL-DNP AND          
D03409              VO-SERV-ORDER-STATUS < 26                           
D03409              MOVE 'P'   TO T4-RULE-RESULT-CD(T4-INDX)            
D03409              MOVE 'A'   TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)       
D03409              PERFORM 5100-GET-BUSINESS-RULE     THRU 5100-EXIT   
D03409              GO TO 2420-EXIT                                     
D03409           END-IF                                                 
D03409        END-IF                                                    
D03409                                                                  
D03409* Account has an active DNP Service Order that is 'On Site'.              
D03409* Short term arrangement cannot be established. Contact the               
D03409* dispatcher to make arrangements.                                        
D03409        IF T2-RULE-ID(T2-INDX) = 'CRDARNG045'                     
D03409           IF WS-DNP-FLAG  = 'Y' AND NOT EXCPTNL-DNP AND          
D03409              VO-SERV-ORDER-STATUS >= 26                          
D03409              MOVE 'F'   TO T4-RULE-RESULT-CD(T4-INDX)            
D03409              MOVE 'A'   TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)       
D03409              SET VALIDATION-FAILED          TO TRUE              
D03409              PERFORM 5100-GET-BUSINESS-RULE     THRU 5100-EXIT   
D03409              GO TO 2420-EXIT                                     
D03409           END-IF                                                 
D03409        END-IF                                                    
P0726K                                                                  
P0726K        IF T2-RULE-ID(T2-INDX) = 'CRDARNG219'                     
P0726K           IF AT-BANKRUPTCY-IND NOT = SPACES OR                   
P0726K              AT-JUDGEMENT-IND  NOT = SPACES                      
P0726K              MOVE 'F' TO T4-RULE-RESULT-CD(T4-INDX)              
P0726K              MOVE 'A' TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)         
P0726K              SET VALIDATION-FAILED TO TRUE                       
P0726K              PERFORM 5100-GET-BUSINESS-RULE THRU 5100-EXIT       
P0726K              GO TO 2420-EXIT                                     
P0726K           END-IF                                                 
P0726K        END-IF                                                    
P0726K                                                                  
P0726K        IF T2-RULE-ID(T2-INDX) = 'CRDARNG220'                     
P0726K           IF WS-ORIGINAL-DNP-DATE = WS-CURRENT-DATE              
P0726K              MOVE WS-WQ-STA-START-TIME TO WS-WQ-STA-START-TIME-N 
P0726K              MOVE WS-WQ-STA-START-TIME-N                         
P0726K                                        TO WS-WQ-STA-START-TIME-A 
P0726K              MOVE WS-CURRENT-TIMESTMP  TO WS-TS-FULL             
P0726K              MOVE WS-TS-HOUR           TO WS-TIME-HOUR           
P0726K              MOVE WS-TS-MIN            TO WS-TIME-MIN            
P0726K              IF WS-TIME > WS-WQ-STA-START-TIME-A                 
P0726K                 MOVE 'F' TO T4-RULE-RESULT-CD(T4-INDX)           
P0726K                 MOVE 'A' TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)      
P0726K                 SET VALIDATION-FAILED  TO TRUE                   
P0726K                 PERFORM 5100-GET-BUSINESS-RULE    THRU 5100-EXIT 
P0726K                 GO TO 2420-EXIT                                  
P0726K              END-IF                                              
P0726K           END-IF                                                 
P0726K        END-IF                                                    
P0726K     END-IF.                                                      
P0726F                                                                  
P0726F     PERFORM 2610-CTMTR-MAJOR-ACCT-CHK             THRU 2610-EXIT.
P0726F                                                                  
P0726F 2420-EXIT.                                                       
P0726F     EXIT.                                                        
P0726F                                                                  
P0726F******************************************************************        
P0726F* 2430-SEB-DREG-STA-VALIDATION                                            
P0726F******************************************************************        
P0726F                                                                  
P0726F 2430-SEB-DREG-STA-VALIDATION.                                    
P0726F                                                                  
P0726F     IF AT-CODE-ACCT-STAT NOT = 'S' AND 'B'                       
P0726F* Account is in the Exempt credit group.                                  
P0726F        IF T2-RULE-ID(T2-INDX) = 'CRDARNG042'                     
P0726F           IF AT-CREDIT-GROUP = 'C'                               
P0726F              MOVE 'F'      TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F              MOVE 'A'      TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F              PERFORM 5100-GET-BUSINESS-RULE        THRU 5100-EXIT
P0726F              SET VALIDATION-FAILED           TO TRUE             
P0726F              GO TO 2430-EXIT                                     
P0726F           ELSE                                                   
P0726F              IF AT-CREDIT-GROUP NOT = 'N' AND 'D' AND 'A' AND 'B'
P0726F                 MOVE 'F'   TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F                 MOVE 'A'   TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F                 PERFORM 5100-GET-BUSINESS-RULE     THRU 5100-EXIT
P0726F                 SET VALIDATION-FAILED        TO TRUE             
P0726F                 GO TO 2430-EXIT                                  
P0726F              END-IF                                              
P0726F           END-IF                                                 
P0726F        END-IF                                                    
P0726F* Account is in the New credit group                                      
P0726F        IF T2-RULE-ID(T2-INDX) = 'CRDARNG056'                     
P0726F           IF AT-CREDIT-GROUP = 'N'                               
P0726F              MOVE 'P'      TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F              MOVE 'A'      TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F              PERFORM 5100-GET-BUSINESS-RULE        THRU 5100-EXIT
P0726F              GO TO 2430-EXIT                                     
P0726F           END-IF                                                 
P0726F        END-IF                                                    
P0726F* Account is in the New credit group.                                     
P0726F        IF T2-RULE-ID(T2-INDX) = 'CRDARNG011'                     
P0726F           IF AT-CREDIT-GROUP = 'D'                               
P0726F              MOVE 'F'      TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F              MOVE 'A'      TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F              PERFORM 5100-GET-BUSINESS-RULE        THRU 5100-EXIT
P0726F              SET VALIDATION-FAILED            TO TRUE            
P0726F              GO TO 2430-EXIT                                     
P0726F           END-IF                                                 
P0726F        END-IF                                                    
P0726F     END-IF.                                                      
P0726F                                                                  
P0726F     IF AT-CODE-ACCT-STAT = 'A'                                   
P0726F* Account is Active or Final Billed                                       
P0726F        IF T2-RULE-ID(T2-INDX) = 'CRDARNG022'                     
P0726F           MOVE 'P'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           GO TO 2430-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726F                                                                  
P0726F     IF AT-CODE-ACCT-STAT = 'B'                                   
P0726F* Account status is Active or Final Billed                                
P0726F        IF T2-RULE-ID(T2-INDX) = 'CRDARNG022'                     
P0726F           IF AT-ACCT-FINALED-DT > SPACES                         
P0726F              MOVE 'P'      TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F              MOVE 'A'      TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F              PERFORM 5100-GET-BUSINESS-RULE        THRU 5100-EXIT
P0726F              GO TO 2430-EXIT                                     
P0726F           END-IF                                                 
P0726F        END-IF                                                    
P0726F* Final Bill has not been generated. Unable to setup STA                  
P0726F        IF T2-RULE-ID(T2-INDX) = 'CRDARNG049'                     
P0726F           IF AT-ACCT-FINALED-DT = SPACES                         
P0726F              MOVE 'F'      TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F              MOVE 'A'      TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F              PERFORM 5100-GET-BUSINESS-RULE        THRU 5100-EXIT
P0726F              SET VALIDATION-FAILED               TO TRUE         
P0726F              GO TO 2430-EXIT                                     
P0726F           END-IF                                                 
P0726F        END-IF                                                    
P0726F* STA Amount for Final Billed accounts includes non-utility chrgs         
P0726F* Account does not have an STA eligible balance.                          
P0726F        IF T2-RULE-ID(T2-INDX) = 'CRDARNG053'                     
P0726F           IF WS-TOTAL-BALANCE <= 0                               
P0726F              MOVE 'F'      TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F              MOVE 'A'      TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F              PERFORM 5100-GET-BUSINESS-RULE        THRU 5100-EXIT
P0726F              SET VALIDATION-FAILED               TO TRUE         
P0726F              GO TO 2430-EXIT                                     
P0726F           END-IF                                                 
P0726F        END-IF                                                    
P0726F        IF T2-RULE-ID(T2-INDX) = 'CRDARNG041'                     
P0726F           IF WS-TOTAL-BALANCE > 0                                
P0726F              MOVE 'P'      TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F              MOVE 'A'      TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F              PERFORM 5100-GET-BUSINESS-RULE        THRU 5100-EXIT
P0726F              GO TO 2430-EXIT                                     
P0726F           END-IF                                                 
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726F                                                                  
P0726F* Account Status must be Active or FB to be eligible for STA              
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG043'                        
P0726F        IF AT-CODE-ACCT-STAT NOT = 'A' AND 'B'                    
P0726F           MOVE 'F'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           SET VALIDATION-FAILED               TO TRUE            
P0726F           GO TO 2430-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726F* Forecasted credit action does not exist or DNP/SONP order has be        
P0726F* en completed. Payment arrangement cannot be established.                
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG044'                        
P0726F        IF AT-TOTAL-AR-BALANCE < 0 OR (WS-DNP-ACT-FLAG = 'Y'      
P0726F           AND WS-PENDING-SO-FLAG = 'Y')                          
P0726F           MOVE 'F'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           SET VALIDATION-FAILED               TO TRUE            
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726F                                                                  
P0726F     IF AT-CODE-ACCT-STAT = 'A' AND NOT STA004-DSP                
P0726F* Account has forecasted credit action or an active DNP/SONP order        
P0726F        IF T2-RULE-ID(T2-INDX) = 'CRDARNG023'                     
P0726F           IF WS-NEAREST-DNP-DT > SPACES                          
P0726F              IF VO-SERV-ORDER-STATUS < 26                        
P0726F                 MOVE 'P'   TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F                 MOVE 'A'   TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F                 PERFORM 5100-GET-BUSINESS-RULE     THRU 5100-EXIT
P0726F                 GO TO 2430-EXIT                                  
P0726F              END-IF                                              
P0726F           ELSE                                                   
P0726F              IF WS-DNP-FLAG = 'Y' AND WS-STA-AMOUNT > 0          
P0726F                 MOVE 'P'   TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F                 MOVE 'A'   TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F                 PERFORM 5100-GET-BUSINESS-RULE     THRU 5100-EXIT
P0726F                 GO TO 2430-EXIT                                  
P0726F              END-IF                                              
P0726F           END-IF                                                 
P0726F        END-IF                                                    
P0726F* Forecasted credit action does not exist or DNP/SONP order has be        
P0726F* en completed. Payment arrangement cannot be established.                
P0726F        IF T2-RULE-ID(T2-INDX) = 'CRDARNG044'                     
P0726F           IF WS-NEAREST-DNP-DT = SPACES AND (WS-DNP-FLAG = 'N'   
P0726F              OR WS-STA-AMOUNT <= 0) AND NOT STA004-DSP           
P0726F              MOVE 'F'      TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F              MOVE 'A'      TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F              PERFORM 5100-GET-BUSINESS-RULE        THRU 5100-EXIT
P0726F              SET VALIDATION-FAILED              TO TRUE          
P0726F              MOVE 'Y'      TO WS-STA004-DSP                      
P0726F           END-IF                                                 
P0726F        END-IF                                                    
P0726F* Account has active DNP/SONP. Please confirm meter status careful        
P0726F* ly before creating payment arrangements.                                
P0726F        IF T2-RULE-ID(T2-INDX) = 'CRDARNG033'                     
P0726F           IF WS-PENDING-SO-FLAG = 'Y' AND WS-DNP-FLAG  = 'Y'     
P0726F              AND WS-STA-AMOUNT > 0 AND NOT EXCPTNL-DNP           
P0726F              MOVE 'P'      TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F              MOVE 'A'      TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F              PERFORM 5100-GET-BUSINESS-RULE        THRU 5100-EXIT
P0726F              GO TO 2430-EXIT                                     
P0726F           END-IF                                                 
P0726F        END-IF                                                    
P0726F* Forecasted credit action does not exist or DNP/SONP order has be        
P0726F* en completed. Payment arrangement cannot be established.                
P0726F        IF T2-RULE-ID(T2-INDX) = 'CRDARNG044'                     
P0726F           IF AT-REV-MTH-LST-NRML = 0 AND NOT STA004-DSP          
P0726F              MOVE 'F'      TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F              MOVE 'A'      TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F              PERFORM 5100-GET-BUSINESS-RULE        THRU 5100-EXIT
P0726F              MOVE 'Y'      TO WS-STA004-DSP                      
P0726F              SET VALIDATION-FAILED              TO TRUE          
P0726F              GO TO 2430-EXIT                                     
P0726F           END-IF                                                 
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726F                                                                  
P0726F* Account does not have an active STA.                                    
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG024'                        
P0726F        IF WS-CODE-STA-ACCT NOT = 'A'                             
P0726F           MOVE 'P'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           GO TO 2430-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726F                                                                  
P0726F* Account has an active STA.                                              
P0726L     IF T2-RULE-ID(T2-INDX) = 'CRDARNG211'                        
P0726F        IF WS-CODE-STA-ACCT = 'A'                                 
P0726F           IF WS-KR361-SETUP-BELOW-LMT-FL = 'Y'                   
P0726F              MOVE 'Y'      TO WS-STAA-ELIGIBLE-FL                
P0726F           END-IF                                                 
P0726F           MOVE 'F'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           SET VALIDATION-FAILED          TO TRUE                 
P0726F           GO TO 2430-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726F                                                                  
P0726F* Account does not have an active DPP.                                    
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG025'                        
P0726F        IF WS-CODE-DPP-ACCT NOT = 'A'                             
P0726F           MOVE 'P'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           GO TO 2430-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726F                                                                  
P0726F* Account has an active DPP. So not eligible for STA.                     
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG009'                        
P0726F        IF WS-CODE-DPP-ACCT = 'A'                                 
P0726F           MOVE 'F'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           SET VALIDATION-FAILED          TO TRUE                 
P0726F           GO TO 2430-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726F                                                                  
P0726F* Account does not have an active Medical Certificate                     
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG026'                        
P0726F        IF WS-CODE-MEDICAL  NOT = 'A'                             
P0726F           MOVE 'P'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           GO TO 2430-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726F                                                                  
P0726F* Account has an active Medical Certificate.                              
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG010'                        
P0726F        IF WS-CODE-MEDICAL  = 'A'                                 
P0726F           MOVE 'F'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           SET VALIDATION-FAILED          TO TRUE                 
P0726F           GO TO 2430-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726F                                                                  
P0726K*  Account has unpaid Returned Check                                      
P0726K     IF T2-RULE-ID(T2-INDX) = 'CRDARNG047'                        
P00836        IF PARM-ARNG-CHANNEL-CD = 'I' OR 'W'                      
P0726K           IF WS-AMT-NSA-NSN > 0                                  
P0726K              MOVE 'F'      TO T4-RULE-RESULT-CD(T4-INDX)         
P0726K              MOVE 'A'      TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726K              SET VALIDATION-FAILED       TO TRUE                 
P0726K              PERFORM 5100-GET-BUSINESS-RULE        THRU 5100-EXIT
P0726K              GO TO 2430-EXIT                                     
P0726K           END-IF                                                 
P0726K        ELSE                                                      
P0726K           IF WS-AMT-NSA > 0                                      
P0726K              MOVE 'F'      TO T4-RULE-RESULT-CD(T4-INDX)         
P0726K              MOVE 'A'      TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726K              SET VALIDATION-FAILED       TO TRUE                 
P0726K              PERFORM 5100-GET-BUSINESS-RULE        THRU 5100-EXIT
P0726K              GO TO 2430-EXIT                                     
P0726K           END-IF                                                 
P0726K        END-IF                                                    
P0726K     END-IF                                                       
P0726F                                                                  
P0726F* Account was dropped from the most recent DPP.                           
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG038'                        
P0726F        PERFORM 7130-CHK-DPP-DROP                   THRU 7130-EXIT
P0726F        IF WS-DPP-DROP-EXISTS = 'Y'                               
P0726F           MOVE 'P'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           GO TO 2430-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726F                                                                  
P0726F* Account has Utility Arrears > 60 days old and an active STA/DPP         
P0726F* within past 60 days                                                     
P0726F     IF WS-AMT-ARREARS-GR-60 > 0 AND                              
P0726F        (WS-RECENT-STA-EXISTS OR WS-RECENT-DPP-EXISTS) AND        
P0726F        WS-CODE-PRE-PAY-PLAN NOT = 'A'                            
P0726F        IF T2-RULE-ID(T2-INDX) = 'CRDARNG058'                     
P0726F           MOVE 'P'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           GO TO 2430-EXIT                                        
P0726F        END-IF                                                    
P0726F     ELSE                                                         
P0726F* Account has Utility Arrears > 30 days old and an active STA/DPP         
P0726F* within past 60 days                                                     
P0726F        IF WS-AMT-ARREARS-GR-30 > 0 AND                           
P0726F           (WS-RECENT-STA-EXISTS OR WS-RECENT-DPP-EXISTS) AND     
P0726F           WS-CODE-PRE-PAY-PLAN NOT = 'A'                         
P0726F           IF T2-RULE-ID(T2-INDX) = 'CRDARNG057'                  
P0726F              MOVE 'P'      TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F              MOVE 'A'      TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F              PERFORM 5100-GET-BUSINESS-RULE        THRU 5100-EXIT
P0726F              GO TO 2430-EXIT                                     
P0726F           END-IF                                                 
P0726F        END-IF                                                    
P0726F     END-IF.                                                      
P0726F                                                                  
P0726K* PRE-PAY PLAN is eligible for arrangements                               
P00836     IF PARM-ARNG-CHANNEL-CD  = 'I' OR 'W'                        
P0726K        IF T2-RULE-ID(T2-INDX) = 'CRDARNG015'                     
P0726K           IF WS-CODE-PRE-PAY-PLAN = 'A'                          
P0726K              MOVE 'F'      TO T4-RULE-RESULT-CD(T4-INDX)         
P0726K              MOVE 'A'      TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726K              SET VALIDATION-FAILED       TO TRUE                 
P0726K              PERFORM 5100-GET-BUSINESS-RULE        THRU 5100-EXIT
P0726K              GO TO 2430-EXIT                                     
P0726K           END-IF                                                 
P0726K        END-IF                                                    
P0726K     ELSE                                                         
P0726K        IF T2-RULE-ID(T2-INDX) = 'CRDARNG100'                     
P0726K           IF WS-CODE-PRE-PAY-PLAN = 'A'                          
P0726K              MOVE 'P'      TO T4-RULE-RESULT-CD(T4-INDX)         
P0726K              MOVE 'A'      TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726K              PERFORM 5100-GET-BUSINESS-RULE        THRU 5100-EXIT
P0726K              GO TO 2430-EXIT                                     
P0726K           END-IF                                                 
P0726K        END-IF                                                    
P0726K     END-IF                                                       
P0726F                                                                  
P0726F*Review Utility chrgs: Account has Utility chrgs 60 days or older.        
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG087' AND                    
P0726F        WS-CODE-PRE-PAY-PLAN NOT = 'A'                            
P0726F        PERFORM 2140-GET-60-DAY-OLD    THRU 2140-EXIT             
P0726F        IF WS-AMT-ARREARS-GR-60 > WS-NOTICE-DNP-LIMIT             
P0726F           MOVE 'P'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           GO TO 2430-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726F                                                                  
P0726F* Originally Due date is for current charges.                             
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG088'                        
P0726F        MOVE 'P'            TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F        MOVE 'A'            TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F        PERFORM 5100-GET-BUSINESS-RULE              THRU 5100-EXIT
P0726F        GO TO 2430-EXIT                                           
P0726F     END-IF                                                       
P0726F                                                                  
P0726F* Minimum amount needed for setting up any new arrangements               
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG101'                        
P0726F        IF WS-KR361-SETUP-BELOW-LMT-FL = 'Y'                      
P0726F           MOVE 'F'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           SET VALIDATION-FAILED          TO TRUE                 
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           GO TO 2430-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726F                                                                  
P00836     IF PARM-ARNG-CHANNEL-CD = 'I' OR 'W'                         
P0726K* BANK DRAFT OR E-DRAFT ACCOUNTS WILL NOT BE ELIGIBLE FOR CDD.            
P0726K        IF T2-RULE-ID(T2-INDX) = 'CRDARNG014'                     
P0726K           IF WS-CODE-BANK-EFT = 'A'                              
P0726K              MOVE 'F' TO T4-RULE-RESULT-CD(T4-INDX)              
P0726K              MOVE 'A' TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)         
P0726K              SET VALIDATION-FAILED TO TRUE                       
P0726K              PERFORM 5100-GET-BUSINESS-RULE THRU 5100-EXIT       
P0726K              GO TO 2430-EXIT                                     
P0726K           END-IF                                                 
P0726K        END-IF                                                    
P0726K* Account has unpaid deposit.                                             
P0726K        IF T2-RULE-ID(T2-INDX) = 'CRDARNG035'                     
P0726K           IF WS-UNPAID-DEPOSIT = 'Y'                             
P0726K              MOVE 'F' TO T4-RULE-RESULT-CD(T4-INDX)              
P0726K              MOVE 'A' TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)         
P0726K              SET VALIDATION-FAILED TO TRUE                       
P0726K              PERFORM 5100-GET-BUSINESS-RULE THRU 5100-EXIT       
P0726K              GO TO 2430-EXIT                                     
P0726K           END-IF                                                 
P0726K        END-IF                                                    
P0726K* STA Compliance - Y                                                      
P0726K        IF T2-RULE-ID(T2-INDX) = 'CRDARNG061'                     
P0726K           IF (ws-STA-ARNG-CMPLD-IND = 'N' OR SPACES) AND         
P0726K              (WS-KR361-CMPL-CHECK-IVR-FL = 'Y')                  
P0726K              MOVE 'F' TO T4-RULE-RESULT-CD(T4-INDX)              
P0726K              MOVE 'A' TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)         
P0726K              SET VALIDATION-FAILED TO TRUE                       
P0726K              PERFORM 5100-GET-BUSINESS-RULE THRU 5100-EXIT       
P0726K              GO TO 2430-EXIT                                     
P0726K           END-IF                                                 
P0726K        END-IF                                                    
P0726K* 60/90 days arrears must be less than limit amt                          
P0726K        IF T2-RULE-ID(T2-INDX) = 'CRDARNG098'                     
P0726K           IF WS-KR361-60-90-ATTR-FL = 'N'                        
P0726K              SET VALIDATION-FAILED     TO TRUE                   
P0726K              MOVE 'F'    TO T4-RULE-RESULT-CD(T4-INDX)           
P0726K              MOVE 'A'    TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)      
P0726K              PERFORM 5100-GET-BUSINESS-RULE       THRU 5100-EXIT 
P0726K              GO TO 2430-EXIT                                     
P0726K           END-IF                                                 
P0726K        END-IF                                                    
P0726K                                                                  
P0726K        IF T2-RULE-ID(T2-INDX) = 'CRDARNG102'                     
P0726K           IF AT-BILL-CYCLE-CHG-CD = 'F'                          
P0726K              MOVE 'F' TO T4-RULE-RESULT-CD(T4-INDX)              
P0726K              MOVE 'A' TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)         
P0726K              SET VALIDATION-FAILED TO TRUE                       
P0726K              PERFORM 5100-GET-BUSINESS-RULE THRU 5100-EXIT       
P0726K              GO TO 2430-EXIT                                     
P0726K           END-IF                                                 
P0726K        END-IF                                                    
P0726K                                                                  
P0726K        IF T2-RULE-ID(T2-INDX) = 'CRDARNG105'                     
P0726K           IF WS-CODE-PENDING-DNP = 'A'                           
P0726K              MOVE 'F' TO T4-RULE-RESULT-CD(T4-INDX)              
P0726K              MOVE 'A' TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)         
P0726K              SET VALIDATION-FAILED TO TRUE                       
P0726K              PERFORM 5100-GET-BUSINESS-RULE THRU 5100-EXIT       
P0726K              GO TO 2430-EXIT                                     
P0726K           END-IF                                                 
P0726K        END-IF                                                    
P0726K                                                                  
P0726K        IF T2-RULE-ID(T2-INDX) = 'CRDARNG219'                     
P0726K           IF AT-BANKRUPTCY-IND NOT = SPACES OR                   
P0726K              AT-JUDGEMENT-IND  NOT = SPACES                      
P0726K              MOVE 'F' TO T4-RULE-RESULT-CD(T4-INDX)              
P0726K              MOVE 'A' TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)         
P0726K              SET VALIDATION-FAILED TO TRUE                       
P0726K              PERFORM 5100-GET-BUSINESS-RULE THRU 5100-EXIT       
P0726K              GO TO 2430-EXIT                                     
P0726K           END-IF                                                 
P0726K        END-IF                                                    
P0726K                                                                  
P0726K        IF T2-RULE-ID(T2-INDX) = 'CRDARNG220'                     
P0726K           IF WS-ORIGINAL-DNP-DATE = WS-CURRENT-DATE              
P0726K              MOVE WS-WQ-STA-START-TIME TO WS-WQ-STA-START-TIME-N 
P0726K              MOVE WS-WQ-STA-START-TIME-N                         
P0726K                                        TO WS-WQ-STA-START-TIME-A 
P0726K              MOVE WS-CURRENT-TIMESTMP  TO WS-TS-FULL             
P0726K              MOVE WS-TS-HOUR           TO WS-TIME-HOUR           
P0726K              MOVE WS-TS-MIN            TO WS-TIME-MIN            
P0726K              IF WS-TIME > WS-WQ-STA-START-TIME-A                 
P0726K                 MOVE 'F' TO T4-RULE-RESULT-CD(T4-INDX)           
P0726K                 MOVE 'A' TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)      
P0726K                 SET VALIDATION-FAILED  TO TRUE                   
P0726K                 PERFORM 5100-GET-BUSINESS-RULE    THRU 5100-EXIT 
P0726K                 GO TO 2430-EXIT                                  
P0726K              END-IF                                              
P0726K           END-IF                                                 
P0726K        END-IF                                                    
P0726K     END-IF.                                                      
P0726K                                                                  
P0726F     PERFORM 2610-CTMTR-MAJOR-ACCT-CHK             THRU 2610-EXIT.
P0726F                                                                  
P0726F 2430-EXIT.                                                       
P0726F     EXIT.                                                        
P0726F                                                                  
P0726F******************************************************************        
P0726F* 2440-SEB-REG-STA-VALIDATION                                             
P0726F******************************************************************        
P0726F                                                                  
P0726F 2440-SEB-REG-STA-VALIDATION.                                     
P0726F                                                                  
P0726F     IF AT-CODE-ACCT-STAT NOT = 'S' AND 'B'                       
P0726F* Account is in the Exempt credit group.                                  
P0726F        IF T2-RULE-ID(T2-INDX) = 'CRDARNG042'                     
P0726F           IF AT-CREDIT-GROUP = 'A' OR 'B' OR 'N'                 
P0726F              CONTINUE                                            
P0726F           ELSE                                                   
P0726F              MOVE 'F'      TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F              MOVE 'A'      TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F              SET VALIDATION-FAILED          TO TRUE              
P0726F              PERFORM 5100-GET-BUSINESS-RULE        THRU 5100-EXIT
P0726F              GO TO 2440-EXIT                                     
P0726F           END-IF                                                 
P0726F        END-IF                                                    
P0726K* Account is in the New credit group                                      
P0726K        IF T2-RULE-ID(T2-INDX) = 'CRDARNG056'                     
P0726K           IF AT-CREDIT-GROUP = 'N'                               
P00836              IF PARM-ARNG-CHANNEL-CD = 'I' OR 'W'                
P0726K                 MOVE 'F'   TO T4-RULE-RESULT-CD(T4-INDX)         
P0726K                 SET VALIDATION-FAILED          TO TRUE           
P0726K              ELSE                                                
P0726K                 MOVE 'P'   TO T4-RULE-RESULT-CD(T4-INDX)         
P0726K              END-IF                                              
P0726K              MOVE 'A'      TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726K              PERFORM 5100-GET-BUSINESS-RULE        THRU 5100-EXIT
P0726K              GO TO 2440-EXIT                                     
P0726K           END-IF                                                 
P0726K        END-IF                                                    
P0726K     END-IF.                                                      
P0726F                                                                  
P0726F     IF AT-CODE-ACCT-STAT = 'A'                                   
P0726F* Account is Active or Final Billed                                       
P0726F        IF T2-RULE-ID(T2-INDX) = 'CRDARNG022'                     
P0726F           MOVE 'P'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           GO TO 2440-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726F                                                                  
P0726F     IF AT-CODE-ACCT-STAT = 'B'                                   
P0726F* Account status is Active or Final Billed                                
P0726F        IF T2-RULE-ID(T2-INDX) = 'CRDARNG022'                     
P0726F           IF AT-ACCT-FINALED-DT > SPACES                         
P0726F              MOVE 'P'      TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F              MOVE 'A'      TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F              PERFORM 5100-GET-BUSINESS-RULE        THRU 5100-EXIT
P0726F              GO TO 2440-EXIT                                     
P0726F           END-IF                                                 
P0726F        END-IF                                                    
P0726F* Final Bill has not been generated. Unable to setup STA                  
P0726F        IF T2-RULE-ID(T2-INDX) = 'CRDARNG049'                     
P0726F           IF AT-ACCT-FINALED-DT = SPACES                         
P0726F              MOVE 'F'      TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F              MOVE 'A'      TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F              SET VALIDATION-FAILED          TO TRUE              
P0726F              PERFORM 5100-GET-BUSINESS-RULE        THRU 5100-EXIT
P0726F              GO TO 2440-EXIT                                     
P0726F           END-IF                                                 
P0726F        END-IF                                                    
P0726F* STA Amount for Final Billed accounts includes non-utility chrgs         
P0726F* Account does not have an STA eligible balance.                          
P0726F        IF T2-RULE-ID(T2-INDX) = 'CRDARNG053'                     
P0726F           IF WS-TOTAL-BALANCE <= 0                               
P0726F              MOVE 'F'      TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F              MOVE 'A'      TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F              SET VALIDATION-FAILED          TO TRUE              
P0726F              PERFORM 5100-GET-BUSINESS-RULE        THRU 5100-EXIT
P0726F              GO TO 2440-EXIT                                     
P0726F           END-IF                                                 
P0726F        END-IF                                                    
P0726F        IF T2-RULE-ID(T2-INDX) = 'CRDARNG041'                     
P0726F           IF WS-TOTAL-BALANCE > 0                                
P0726F              MOVE 'P'      TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F              MOVE 'A'      TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F              PERFORM 5100-GET-BUSINESS-RULE        THRU 5100-EXIT
P0726F              GO TO 2440-EXIT                                     
P0726F           END-IF                                                 
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726F                                                                  
P0726F* Account Status must be Active or FB to be eligible for STA              
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG043'                        
P0726F        IF AT-CODE-ACCT-STAT NOT = 'A' AND 'B'                    
P0726F           MOVE 'F'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           SET VALIDATION-FAILED          TO TRUE                 
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           GO TO 2440-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726F                                                                  
P0726F* Forecasted credit action does not exist or DNP/SONP order has be        
P0726F* en completed. Payment arrangement cannot be established.                
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG044'                        
P0726F        IF AT-TOTAL-AR-BALANCE < 0 OR (WS-DNP-ACT-FLAG = 'Y'      
P0726F           AND WS-PENDING-SO-FLAG = 'Y')                          
P0726F           MOVE 'F'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           SET VALIDATION-FAILED          TO TRUE                 
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           GO TO 2440-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726F                                                                  
P0726F     IF AT-CODE-ACCT-STAT = 'A' AND NOT STA004-DSP                
P0726F* Account has forecasted credit action or an active DNP/SONP order        
P0726F        IF T2-RULE-ID(T2-INDX) = 'CRDARNG023'                     
P0726F           IF WS-NEAREST-DNP-DT > SPACES                          
P0726F              IF VO-SERV-ORDER-STATUS < 26                        
P0726F                 MOVE 'P'   TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F                 MOVE 'A'   TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F                 PERFORM 5100-GET-BUSINESS-RULE     THRU 5100-EXIT
P0726F                 GO TO 2440-EXIT                                  
P0726F              END-IF                                              
P0726F           ELSE                                                   
P0726F              IF WS-DNP-FLAG = 'Y' AND WS-STA-AMOUNT > 0          
P0726F                 MOVE 'P'   TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F                 MOVE 'A'   TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F                 PERFORM 5100-GET-BUSINESS-RULE     THRU 5100-EXIT
P0726F                 GO TO 2440-EXIT                                  
P0726F              END-IF                                              
P0726F           END-IF                                                 
P0726F        END-IF                                                    
P0726F* Forecasted credit action does not exist or DNP/SONP order has be        
P0726F* en completed. Payment arrangement cannot be established.                
P0726F        IF T2-RULE-ID(T2-INDX) = 'CRDARNG044'                     
P0726F           IF WS-NEAREST-DNP-DT = SPACES AND (WS-DNP-FLAG = 'N'   
P0726F              OR WS-STA-AMOUNT <= 0) AND NOT STA004-DSP           
P0726G              IF WS-REG-GROUP-CD = '100'  AND                     
P0726G                 LR-SENIOR-FL = 'Y'       AND                     
P0726G                 WS-GROUP1-TO-GROUP2-FL = 'Y' AND                 
P0726G                 WS-DATE-NOTICE-MAIL-C > SPACES AND               
P0726G                 WS-AMT-NOTICE-C > WS-NOTICE-DNP-LIMIT            
P0726G                 CONTINUE                                         
P0726G              ELSE                                                
P0726F                 MOVE 'F'      TO T4-RULE-RESULT-CD(T4-INDX)      
P0726F                 MOVE 'A'      TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX) 
P0726F                 SET VALIDATION-FAILED          TO TRUE           
P0726F                 PERFORM 5100-GET-BUSINESS-RULE    THRU 5100-EXIT 
P0726F                 MOVE 'Y'      TO WS-STA004-DSP                   
P0726G              END-IF                                              
P0726F           END-IF                                                 
P0726F        END-IF                                                    
P0726F* Account has active DNP/SONP. Please confirm meter status careful        
P0726F* ly before creating payment arrangements.                                
P0726F        IF T2-RULE-ID(T2-INDX) = 'CRDARNG033'                     
P0726F           IF WS-PENDING-SO-FLAG = 'Y' AND WS-DNP-FLAG  = 'Y'     
P0726F              AND WS-STA-AMOUNT > 0 AND NOT EXCPTNL-DNP           
P0726F              MOVE 'P'      TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F              MOVE 'A'      TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F              PERFORM 5100-GET-BUSINESS-RULE        THRU 5100-EXIT
P0726F              GO TO 2440-EXIT                                     
P0726F           END-IF                                                 
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726F* Forecasted credit action does not exist or DNP/SONP order has be        
P0726F* en completed. Payment arrangement cannot be established.                
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG044'                        
P0726F        IF AT-REV-MTH-LST-NRML = 0 AND NOT STA004-DSP             
P0726F           MOVE 'F'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           SET VALIDATION-FAILED          TO TRUE                 
P0726F           PERFORM 5100-GET-BUSINESS-RULE  THRU 5100-EXIT         
P0726F           MOVE 'Y'         TO WS-STA004-DSP                      
P0726F           GO TO 2440-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726F                                                                  
P0726F* Account does not have an active STA.                                    
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG024'                        
P0726F        IF WS-CODE-STA-ACCT NOT = 'A'                             
P0726F           MOVE 'P'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           GO TO 2440-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726F                                                                  
P0726F* Account has an active STA.                                              
P0726L     IF T2-RULE-ID(T2-INDX) = 'CRDARNG211'                        
P0726F        IF WS-CODE-STA-ACCT = 'A'                                 
P0726F           IF WS-KR361-SETUP-BELOW-LMT-FL = 'Y'                   
P0726F              MOVE 'Y'      TO WS-STAA-ELIGIBLE-FL                
P0726F           END-IF                                                 
P0726F           MOVE 'F'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           SET VALIDATION-FAILED          TO TRUE                 
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           GO TO 2440-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726F                                                                  
P0726F* Account does not have an active DPP.                                    
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG025'                        
P0726F        IF WS-CODE-DPP-ACCT NOT = 'A'                             
P0726F           MOVE 'P'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           GO TO 2440-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726F                                                                  
P0726F* Account has an active DPP. So not eligible for STA.                     
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG009'                        
P0726F        IF WS-CODE-DPP-ACCT = 'A'                                 
P0726F           MOVE 'F'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           SET VALIDATION-FAILED          TO TRUE                 
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           GO TO 2440-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726F                                                                  
P0726F* Account does not have an active Medical Certificate                     
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG026'                        
P0726F        IF WS-CODE-MEDICAL  NOT = 'A'                             
P0726F           MOVE 'P'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           GO TO 2440-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726F                                                                  
P0726F* Account has an active Medical Certificate.                              
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG010'                        
P0726F        IF WS-CODE-MEDICAL  = 'A'                                 
P0726F           MOVE 'F'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           SET VALIDATION-FAILED          TO TRUE                 
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           GO TO 2440-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726F                                                                  
P0726K*  Account has unpaid Returned Check                                      
P0726K     IF T2-RULE-ID(T2-INDX) = 'CRDARNG047'                        
P00836        IF PARM-ARNG-CHANNEL-CD = 'I' OR 'W'                      
P0726K           IF WS-AMT-NSA-NSN > 0                                  
P0726K              MOVE 'F'      TO T4-RULE-RESULT-CD(T4-INDX)         
P0726K              MOVE 'A'      TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726K              SET VALIDATION-FAILED       TO TRUE                 
P0726K              PERFORM 5100-GET-BUSINESS-RULE        THRU 5100-EXIT
P0726K              GO TO 2440-EXIT                                     
P0726K           END-IF                                                 
P0726K        ELSE                                                      
P0726K           IF WS-AMT-NSA > 0                                      
P0726K              MOVE 'F'      TO T4-RULE-RESULT-CD(T4-INDX)         
P0726K              MOVE 'A'      TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726K              SET VALIDATION-FAILED       TO TRUE                 
P0726K              PERFORM 5100-GET-BUSINESS-RULE        THRU 5100-EXIT
P0726K              GO TO 2440-EXIT                                     
P0726K           END-IF                                                 
P0726K        END-IF                                                    
P0726K     END-IF                                                       
P0726F                                                                  
P0726F* Account was dropped from the most recent DPP.                           
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG038'                        
P0726F        PERFORM 7130-CHK-DPP-DROP                   THRU 7130-EXIT
P0726F        IF WS-DPP-DROP-EXISTS = 'Y'                               
P0726F           MOVE 'P'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           GO TO 2440-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726F                                                                  
P0726F* Account has Utility Arrears > 60 days old and an active STA/DPP         
P0726F* within past 60 days                                                     
P0726F     IF WS-AMT-ARREARS-GR-60 > 0 AND                              
P0726F        (WS-RECENT-STA-EXISTS OR WS-RECENT-DPP-EXISTS)            
P0726F        IF T2-RULE-ID(T2-INDX) = 'CRDARNG058'                     
P0726F           MOVE 'P'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           GO TO 2440-EXIT                                        
P0726F        END-IF                                                    
P0726F     ELSE                                                         
P0726F* Account has Utility Arrears > 30 days old and an active STA/DPP         
P0726F* within past 60 days                                                     
P0726F        IF WS-AMT-ARREARS-GR-30 > 0 AND                           
P0726F           (WS-RECENT-STA-EXISTS OR WS-RECENT-DPP-EXISTS)         
P0726F           IF T2-RULE-ID(T2-INDX) = 'CRDARNG057'                  
P0726F              MOVE 'P'      TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F              MOVE 'A'      TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F              PERFORM 5100-GET-BUSINESS-RULE        THRU 5100-EXIT
P0726F              GO TO 2440-EXIT                                     
P0726F           END-IF                                                 
P0726F        END-IF                                                    
P0726F     END-IF.                                                      
P0726F                                                                  
P0726F* Review Util chrgs: Account has Utility charges 60 days or older.        
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG087'                        
P0726F        PERFORM 2140-GET-60-DAY-OLD                 THRU 2140-EXIT
P0726F        IF WS-AMT-ARREARS-GR-60 > WS-NOTICE-DNP-LIMIT             
P0726F           MOVE 'P'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           GO TO 2440-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726F                                                                  
P0726F* Originally Due date is for current charges.                             
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG088'                        
P0726F        MOVE 'P'            TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F        MOVE 'A'            TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F        PERFORM 5100-GET-BUSINESS-RULE              THRU 5100-EXIT
P0726F        GO TO 2440-EXIT                                           
P0726F     END-IF                                                       
P0726F                                                                  
P0726F* Minimum amount needed for setting up any new arrangements               
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG101'                        
P0726F        IF WS-KR361-SETUP-BELOW-LMT-FL = 'Y'                      
P0726F           MOVE 'F'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           SET VALIDATION-FAILED          TO TRUE                 
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           GO TO 2440-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726J                                                                  
P00836     IF PARM-ARNG-CHANNEL-CD = 'I' OR 'W'                         
P0726K* BANK DRAFT OR E-DRAFT ACCOUNTS WILL NOT BE ELIGIBLE FOR CDD.            
P0726K        IF T2-RULE-ID(T2-INDX) = 'CRDARNG014'                     
P0726K           IF WS-CODE-BANK-EFT = 'A'                              
P0726K              MOVE 'F' TO T4-RULE-RESULT-CD(T4-INDX)              
P0726K              MOVE 'A' TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)         
P0726K              SET VALIDATION-FAILED TO TRUE                       
P0726K              PERFORM 5100-GET-BUSINESS-RULE THRU 5100-EXIT       
P0726K              GO TO 2440-EXIT                                     
P0726K           END-IF                                                 
P0726K        END-IF                                                    
P0726K* Account has unpaid deposit.                                             
P0726K        IF T2-RULE-ID(T2-INDX) = 'CRDARNG035'                     
P0726K           IF WS-UNPAID-DEPOSIT = 'Y'                             
P0726K              MOVE 'F' TO T4-RULE-RESULT-CD(T4-INDX)              
P0726K              MOVE 'A' TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)         
P0726K              SET VALIDATION-FAILED TO TRUE                       
P0726K              PERFORM 5100-GET-BUSINESS-RULE THRU 5100-EXIT       
P0726K              GO TO 2440-EXIT                                     
P0726K           END-IF                                                 
P0726K        END-IF                                                    
P0726K* STA Compliance - Y                                                      
P0726K        IF T2-RULE-ID(T2-INDX) = 'CRDARNG061'                     
P0726K           IF (ws-STA-ARNG-CMPLD-IND = 'N' OR SPACES) AND         
P0726K              (WS-KR361-CMPL-CHECK-IVR-FL = 'Y')                  
P0726K              MOVE 'F' TO T4-RULE-RESULT-CD(T4-INDX)              
P0726K              MOVE 'A' TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)         
P0726K              SET VALIDATION-FAILED TO TRUE                       
P0726K              PERFORM 5100-GET-BUSINESS-RULE THRU 5100-EXIT       
P0726K              GO TO 2440-EXIT                                     
P0726K           END-IF                                                 
P0726K        END-IF                                                    
P0726K* 60/90 days arrears must be less than limit amt                          
P0726K        IF T2-RULE-ID(T2-INDX) = 'CRDARNG098'                     
P0726K           IF WS-KR361-60-90-ATTR-FL = 'N'                        
P0726K              SET VALIDATION-FAILED     TO TRUE                   
P0726K              MOVE 'F'    TO T4-RULE-RESULT-CD(T4-INDX)           
P0726K              MOVE 'A'    TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)      
P0726K              PERFORM 5100-GET-BUSINESS-RULE       THRU 5100-EXIT 
P0726K              GO TO 2440-EXIT                                     
P0726K           END-IF                                                 
P0726K        END-IF                                                    
P0726K                                                                  
P0726K        IF T2-RULE-ID(T2-INDX) = 'CRDARNG102'                     
P0726K           IF AT-BILL-CYCLE-CHG-CD = 'F'                          
P0726K              MOVE 'F' TO T4-RULE-RESULT-CD(T4-INDX)              
P0726K              MOVE 'A' TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)         
P0726K              SET VALIDATION-FAILED TO TRUE                       
P0726K              PERFORM 5100-GET-BUSINESS-RULE THRU 5100-EXIT       
P0726K              GO TO 2440-EXIT                                     
P0726K           END-IF                                                 
P0726K        END-IF                                                    
P0726K                                                                  
P0726K        IF T2-RULE-ID(T2-INDX) = 'CRDARNG105'                     
P0726K           IF WS-CODE-PENDING-DNP = 'A'                           
P0726K              MOVE 'F' TO T4-RULE-RESULT-CD(T4-INDX)              
P0726K              MOVE 'A' TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)         
P0726K              SET VALIDATION-FAILED TO TRUE                       
P0726K              PERFORM 5100-GET-BUSINESS-RULE THRU 5100-EXIT       
P0726K              GO TO 2440-EXIT                                     
P0726K           END-IF                                                 
P0726K        END-IF                                                    
P0726K                                                                  
P0726K        IF T2-RULE-ID(T2-INDX) = 'CRDARNG219'                     
P0726K           IF AT-BANKRUPTCY-IND NOT = SPACES OR                   
P0726K              AT-JUDGEMENT-IND  NOT = SPACES                      
P0726K              MOVE 'F' TO T4-RULE-RESULT-CD(T4-INDX)              
P0726K              MOVE 'A' TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)         
P0726K              SET VALIDATION-FAILED TO TRUE                       
P0726K              PERFORM 5100-GET-BUSINESS-RULE THRU 5100-EXIT       
P0726K              GO TO 2440-EXIT                                     
P0726K           END-IF                                                 
P0726K        END-IF                                                    
P0726K                                                                  
P0726K        IF T2-RULE-ID(T2-INDX) = 'CRDARNG220'                     
P0726K           IF WS-ORIGINAL-DNP-DATE = WS-CURRENT-DATE              
P0726K              MOVE WS-WQ-STA-START-TIME TO WS-WQ-STA-START-TIME-N 
P0726K              MOVE WS-WQ-STA-START-TIME-N                         
P0726K                                        TO WS-WQ-STA-START-TIME-A 
P0726K              MOVE WS-CURRENT-TIMESTMP  TO WS-TS-FULL             
P0726K              MOVE WS-TS-HOUR           TO WS-TIME-HOUR           
P0726K              MOVE WS-TS-MIN            TO WS-TIME-MIN            
P0726K              IF WS-TIME > WS-WQ-STA-START-TIME-A                 
P0726K                 MOVE 'F' TO T4-RULE-RESULT-CD(T4-INDX)           
P0726K                 MOVE 'A' TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)      
P0726K                 SET VALIDATION-FAILED  TO TRUE                   
P0726K                 PERFORM 5100-GET-BUSINESS-RULE    THRU 5100-EXIT 
P0726K                 GO TO 2440-EXIT                                  
P0726K              END-IF                                              
P0726K           END-IF                                                 
P0726K        END-IF                                                    
P0726K     END-IF.                                                      
P0726K                                                                  
P0726F     PERFORM 2610-CTMTR-MAJOR-ACCT-CHK             THRU 2610-EXIT.
P0726F                                                                  
P0726F 2440-EXIT.                                                       
P0726F     EXIT.                                                        
P0726F                                                                  
P0726F******************************************************************        
P0726F* 2450-CDD-CDDA-VALIDATION                                                
P0726F******************************************************************        
P0726F 2450-CDD-CDDA-VALIDATION.                                        
P0726F                                                                  
P0726E* COMMON VALIDATION FOR CIS & IVR                                         
P0726E     IF T2-RULE-ID(T2-INDX) = 'CRDARNG002'                        
P0726E        MOVE 'P'            TO T4-RULE-RESULT-CD(T4-INDX)         
P0726E                               T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726E        PERFORM 5100-GET-BUSINESS-RULE   THRU 5100-EXIT           
P0726F        GO TO 2450-EXIT                                           
P0726E     END-IF.                                                      
P0726E                                                                  
P0726E* CIS VALIDATION                                                          
P0726E* RESIDENTIAL & COMMERCIAL ACCOUNTS ARE ELIGIBLE FOR CDD                  
P0726E     IF T2-RULE-ID(T2-INDX) = 'CRDARNG001'                        
P0726E        IF AT-ACCOUNT-TYPE-CODE = 'R' OR 'C'                      
P0726E           MOVE 'P'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726E                               T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726E           PERFORM 5100-GET-BUSINESS-RULE  THRU 5100-EXIT         
P0726F           GO TO 2450-EXIT                                        
P0726E        END-IF                                                    
P0726E     END-IF.                                                      
P0726E                                                                  
P0726E* ACCOUNT TYPE SHOULD BE RESIDENTIAL OR COMMERCIAL.                       
P0726E     IF T2-RULE-ID(T2-INDX) = 'CRDARNG003'                        
P0726E        IF AT-ACCOUNT-TYPE-CODE NOT = 'R' AND                     
P0726E           AT-ACCOUNT-TYPE-CODE NOT = 'C'                         
P0726E           SET VALIDATION-FAILED  TO TRUE                         
P0726E           MOVE 'F'          TO T4-RULE-RESULT-CD(T4-INDX)        
P0726E           MOVE 'A'          TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)   
P0726E           PERFORM 5100-GET-BUSINESS-RULE  THRU 5100-EXIT         
P0726F           GO TO 2450-EXIT                                        
P0726E        END-IF                                                    
P0726E     END-IF.                                                      
P0726E                                                                  
P0726E* OTHER THAN ACTIVE ACCOUNTS WILL NOT BE ELIGIBLE FOR CDD.                
P0726E     IF T2-RULE-ID(T2-INDX) = 'CRDARNG004'                        
P0726E        IF AT-CODE-ACCT-STAT NOT = 'A'                            
P0726E           SET VALIDATION-FAILED    TO TRUE                       
P0726E           MOVE 'F'          TO T4-RULE-RESULT-CD(T4-INDX)        
P0726E           MOVE 'A'          TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)   
P0726E           PERFORM 5100-GET-BUSINESS-RULE  THRU 5100-EXIT         
P0726F           GO TO 2450-EXIT                                        
P0726E        END-IF                                                    
P0726E     END-IF.                                                      
P0726E                                                                  
P0726E* NEXT BILL DATE SHOULD BE GREATER THAN CURRENT DATE.                     
P0726E     IF T2-RULE-ID(T2-INDX) = 'CRDARNG005'                        
P0726E        IF WS-NEXT-BILL-DATE <= WS-CURRENT-DATE                   
P0726E           AND AT-REV-MTH-LST-NRML > 0                            
P0726E           AND WS-PLAN-TERM-CD(T1-INDX) = 'B'                     
P0726E           SET VALIDATION-FAILED    TO TRUE                       
P0726E           MOVE 'F'          TO T4-RULE-RESULT-CD(T4-INDX)        
P0726E           MOVE 'A'          TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)   
P0726E           PERFORM 5100-GET-BUSINESS-RULE  THRU 5100-EXIT         
P0726F           GO TO 2450-EXIT                                        
P0726E        END-IF                                                    
P0726E     END-IF.                                                      
P0726E                                                                  
P0726E* TOTAL AR BALANCE SHOULD BE GREATER THAN ZERO.                           
P0726E     IF AT-TOTAL-AR-BALANCE > 0                                   
P0726E        CONTINUE                                                  
P0726E     ELSE                                                         
P0726E        IF T2-RULE-ID(T2-INDX) = 'CRDARNG006'                     
P0726E           SET VALIDATION-FAILED    TO TRUE                       
P0726E           MOVE 'F'          TO T4-RULE-RESULT-CD(T4-INDX)        
P0726E           MOVE 'A'          TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)   
P0726E           PERFORM 5100-GET-BUSINESS-RULE  THRU 5100-EXIT         
P0726F           GO TO 2450-EXIT                                        
P0726E        END-IF                                                    
P0726E     END-IF.                                                      
P0726E                                                                  
P0726E* ACCOUNT HASN'T BILLED FOR 1ST BILL WILL NOT BE ELIGIBLE FOR CDD.        
P0726E     IF T2-RULE-ID(T2-INDX) = 'CRDARNG007'                        
P0726E        IF AT-REV-MTH-LST-NRML > 0                                
P0726E           CONTINUE                                               
P0726E        ELSE                                                      
P0726E           SET VALIDATION-FAILED    TO TRUE                       
P0726E           MOVE 'F'          TO T4-RULE-RESULT-CD(T4-INDX)        
P0726E           MOVE 'A'          TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)   
P0726E           PERFORM 5100-GET-BUSINESS-RULE  THRU 5100-EXIT         
P0726F           GO TO 2450-EXIT                                        
P0726E        END-IF                                                    
P0726E     END-IF.                                                      
P0726E                                                                  
P0726E* STA ACCOUNTS WILL NOT BE ELIGIBLE FOR CDD.                              
P0726E     IF T2-RULE-ID(T2-INDX) = 'CRDARNG008'                        
P0726E        IF WS-CODE-STA-ACCT = 'A'                                 
P0726E           SET VALIDATION-FAILED    TO TRUE                       
P0726E           MOVE 'F'          TO T4-RULE-RESULT-CD(T4-INDX)        
P0726E           MOVE 'A'          TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)   
P0726E           PERFORM 5100-GET-BUSINESS-RULE  THRU 5100-EXIT         
P0726F           GO TO 2450-EXIT                                        
P0726E        END-IF                                                    
P0726E     END-IF.                                                      
P0726E                                                                  
P0726E* DPP ACCOUNTS WILL NOT BE ELIGIBLE FOR CDD.                              
P0726E     IF T2-RULE-ID(T2-INDX) = 'CRDARNG009'                        
P0726E        IF WS-CODE-DPP-ACCT = 'A'                                 
P0726E           SET VALIDATION-FAILED    TO TRUE                       
P0726E           MOVE 'F'          TO T4-RULE-RESULT-CD(T4-INDX)        
P0726E           MOVE 'A'          TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)   
P0726E           PERFORM 5100-GET-BUSINESS-RULE  THRU 5100-EXIT         
P0726F           GO TO 2450-EXIT                                        
P0726E        END-IF                                                    
P0726E     END-IF.                                                      
P0726E                                                                  
P0726E* MEDICAL CERTIFICATE ACCOUNTS WILL NOT BE ELIGIBLE FOR CDD.              
P0726E     IF T2-RULE-ID(T2-INDX) = 'CRDARNG010'                        
P0726E        IF WS-CODE-MEDICAL = 'A'                                  
P0726E           SET VALIDATION-FAILED    TO TRUE                       
P0726E           MOVE 'F'          TO T4-RULE-RESULT-CD(T4-INDX)        
P0726E           MOVE 'A'          TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)   
P0726E           PERFORM 5100-GET-BUSINESS-RULE  THRU 5100-EXIT         
P0726F           GO TO 2450-EXIT                                        
P0726E        END-IF                                                    
P0726E     END-IF.                                                      
P0726E                                                                  
P0726E* NON UTILITY ACCOUNTS WILL NOT BE ELIGIBLE FOR CDD.                      
P0726E     IF T2-RULE-ID(T2-INDX) = 'CRDARNG011'                        
P0726E        IF AT-CREDIT-GROUP = 'D'                                  
P0726E           SET VALIDATION-FAILED    TO TRUE                       
P0726E           MOVE 'F'          TO T4-RULE-RESULT-CD(T4-INDX)        
P0726E           MOVE 'A'          TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)   
P0726E           PERFORM 5100-GET-BUSINESS-RULE  THRU 5100-EXIT         
P0726F           GO TO 2450-EXIT                                        
P0726E        END-IF                                                    
P0726E     END-IF.                                                      
P0726E                                                                  
P0726E* MASTER/SUB ACCOUNTS WILL NOT BE ELIGIBLE FOR CDD.                       
P0726E     IF T2-RULE-ID(T2-INDX) = 'CRDARNG012'                        
P0726E        IF AT-CREDIT-GROUP = 'M' OR 'S'                           
P0726E           SET VALIDATION-FAILED    TO TRUE                       
P0726E           MOVE 'F'          TO T4-RULE-RESULT-CD(T4-INDX)        
P0726E           MOVE 'A'          TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)   
P0726E           PERFORM 5100-GET-BUSINESS-RULE  THRU 5100-EXIT         
P0726F           GO TO 2450-EXIT                                        
P0726E        END-IF                                                    
P0726E     END-IF.                                                      
P0726E                                                                  
P0726E* RECURRING CREDIT CARD PYMT ACCOUNTS WILL NOT BE ELIGIBLE FOR CDD        
P0726E     IF T2-RULE-ID(T2-INDX) = 'CRDARNG013'                        
P0726E        IF WS-AUTOCARD-SETUP-FL = 'Y'                             
P0726E           SET VALIDATION-FAILED    TO TRUE                       
P0726E           MOVE 'F'          TO T4-RULE-RESULT-CD(T4-INDX)        
P0726E           MOVE 'A'          TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)   
P0726E           PERFORM 5100-GET-BUSINESS-RULE  THRU 5100-EXIT         
P0726F           GO TO 2450-EXIT                                        
P0726E        END-IF                                                    
P0726E     END-IF.                                                      
P0726E                                                                  
P0726E* BANK DRAFT OR E-DRAFT ACCOUNTS WILL NOT BE ELIGIBLE FOR CDD.            
P0726E     IF T2-RULE-ID(T2-INDX) = 'CRDARNG014'                        
P0726E        IF WS-CODE-BANK-EFT = 'A'                                 
P0726E           SET VALIDATION-FAILED    TO TRUE                       
P0726E           MOVE 'F'          TO T4-RULE-RESULT-CD(T4-INDX)        
P0726E           MOVE 'A'          TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)   
P0726E           PERFORM 5100-GET-BUSINESS-RULE  THRU 5100-EXIT         
P0726F           GO TO 2450-EXIT                                        
P0726E        END-IF                                                    
P0726E     END-IF.                                                      
P0726E                                                                  
P0726E* PRE PAYMENT PLAN ACCOUNTS WILL NOT BE ELIGIBLE FOR CDD.                 
P0726E     IF T2-RULE-ID(T2-INDX) = 'CRDARNG015'                        
P0726E        IF WS-CODE-PRE-PAY-PLAN = 'A' AND                         
P0726F           WS-PLAN-TERM-CD(T1-INDX) = 'A'                         
P0726E           SET VALIDATION-FAILED    TO TRUE                       
P0726E           MOVE 'F'          TO T4-RULE-RESULT-CD(T4-INDX)        
P0726E           MOVE 'A'          TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)   
P0726E           PERFORM 5100-GET-BUSINESS-RULE  THRU 5100-EXIT         
P0726F           GO TO 2450-EXIT                                        
P0726E        END-IF                                                    
P0726E     END-IF.                                                      
P0726E                                                                  
P0726E* GROUP 1 SENIOR WILL NOT BE ELIGIBILE FOR CDD.                           
P0726E     IF T2-RULE-ID(T2-INDX) = 'CRDARNG017'                        
P0726E        IF WS-REG-GROUP-CD = '100'  AND                           
P0726G           LR-SENIOR-FL = 'Y'       AND                           
P0726G           WS-GROUP1-TO-GROUP2-FL = 'Y' AND                       
P0726G           WS-DATE-NOTICE-MAIL-C > SPACES AND                     
P0726G           WS-AMT-NOTICE-C > WS-NOTICE-DNP-LIMIT                  
P0726E           SET VALIDATION-FAILED    TO TRUE                       
P0726E           MOVE 'F'          TO T4-RULE-RESULT-CD(T4-INDX)        
P0726E           MOVE 'A'          TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)   
P0726E           PERFORM 5100-GET-BUSINESS-RULE  THRU 5100-EXIT         
P0726F           GO TO 2450-EXIT                                        
P0726E        END-IF                                                    
P0726E     END-IF.                                                      
P0726E                                                                  
P0726E* ONLY ACTIVE ACCOUNTS ELIGIBLE FOR CDD.                                  
P0726E     IF T2-RULE-ID(T2-INDX) = 'CMN0000021'                        
P0726E        IF AT-CODE-ACCT-STAT = 'A'                                
P0726E           MOVE 'P'          TO T4-RULE-RESULT-CD(T4-INDX)        
P0726E                                T4-RULE-NOTIFY-TYPE-CD(T4-INDX)   
P0726E           PERFORM 5100-GET-BUSINESS-RULE  THRU 5100-EXIT         
P0726F           GO TO 2450-EXIT                                        
P0726E        END-IF                                                    
P0726E     END-IF.                                                      
P0726E                                                                  
P0726E* Business Rule 016 & 018 is a hard stop message, if this SP call         
P0726E* ed from IVR. If not still then consider this as hard stop but           
P0726E* we will populate Plan and Account result sets along with                
P0726E* business rule result set. So RULE-NOTIFY-TYPE-CD is being               
P0726E* passed as 'P' in the below scenatio.                                    
P0726E* COMMERCIAL AND NON-RES-ATTR-FL AS 'Y' ACCOUNTS ARE NOT ELIGIBLE         
P0726E     IF T2-RULE-ID(T2-INDX) = 'CRDARNG016'                        
P0726E        IF WS-KR361-NON-RES-ATTR-FL = 'Y'                         
P0726E           AND AT-ACCOUNT-TYPE-CODE = 'C'                         
P00836           IF PARM-ARNG-CHANNEL-CD  = 'I' OR 'W'                  
P0726E              SET VALIDATION-FAILED TO TRUE                       
P0726E           END-IF                                                 
P0726E           MOVE 'F'       TO T4-RULE-RESULT-CD(T4-INDX)           
P0726E           MOVE 'A'       TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)      
P0726E           PERFORM 5100-GET-BUSINESS-RULE THRU 5100-EXIT          
P0726F           GO TO 2450-EXIT                                        
P0726E        END-IF                                                    
P0726E     END-IF.                                                      
P0726E                                                                  
P0726E* COMMERCIAL AND MAJOR-ATTR-FL AS 'Y' ACCOUNTS ARE NOT ELIGIBLE           
P0726E     IF T2-RULE-ID(T2-INDX) = 'CRDARNG018'                        
P0726E        IF WS-KR361-MAJOR-ATTR-FL = 'Y'                           
P0726E           AND AT-ACCOUNT-TYPE-CODE = 'C'                         
P00836           IF PARM-ARNG-CHANNEL-CD  = 'I' OR 'W'                  
P0726E              SET VALIDATION-FAILED TO TRUE                       
P0726E           END-IF                                                 
P0726E           MOVE 'F'       TO T4-RULE-RESULT-CD(T4-INDX)           
P0726E           MOVE 'A'       TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)      
P0726E           PERFORM 5100-GET-BUSINESS-RULE THRU 5100-EXIT          
P0726F           GO TO 2450-EXIT                                        
P0726E        END-IF                                                    
P0726E     END-IF.                                                      
P0726E                                                                  
P0726E* CREDIT ARRANGEMENT ACCOUNTS WILL NOT BE ELIGIBLE FOR CDD.               
P0726E     IF T2-RULE-ID(T2-INDX) = 'CRDARNG064'                        
P0726E        MOVE 'N' TO WS-ARNG-ID-EXISTS                             
P0726E                    WS-CDD-AFTER-BILL-EXISTS                      
P0726E        MOVE WS-ARNG-ID(T1-INDX)    TO WS-ARRANGEMENT-ID          
P0726E        PERFORM 7040-SELECT-ARNG-ID        THRU 7040-EXIT         
P0726E        IF WS-ARNG-ID-EXISTS = 'Y'                                
P0726E           IF WS-PLAN-TERM-CD(T1-INDX) = 'A'                      
P0726E              MOVE 'Y'       TO WS-CDD-AFTER-BILL-EXISTS          
P0726E           END-IF                                                 
P0726E           SET VALIDATION-FAILED    TO TRUE                       
P0726E           MOVE 'F'          TO T4-RULE-RESULT-CD(T4-INDX)        
P0726E           MOVE 'A'          TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)   
P0726E           PERFORM 5100-GET-BUSINESS-RULE  THRU 5100-EXIT         
P0726F           GO TO 2450-EXIT                                        
P0726E        END-IF                                                    
P0726E     END-IF.                                                      
P0726E                                                                  
P0726E                                                                  
P0726E* CDD AFTER BILL ACCOUNTS WILL NOT BE ELIGIBLE FOR ANY CDD PLANS.         
P0726E     IF T2-RULE-ID(T2-INDX) = 'CRDARNG066'                        
P0726E        IF WS-CDD-AFTER-BILL-EXISTS = 'Y'                         
P0726E           MOVE 'N'                 TO WS-ROW-INSERTED            
P0726E           PERFORM 8000A-DELETE-GTT-ROWS   THRU 8000A-EXIT        
P0726E           PERFORM 8000B-DELETE-GTT-ROWS   THRU 8000B-EXIT        
P0726E           PERFORM 8000C-DELETE-GTT-ROWS   THRU 8000C-EXIT        
P0726E           SET VALIDATION-FAILED    TO TRUE                       
P0726E           MOVE 'F'          TO T4-RULE-RESULT-CD(T4-INDX)        
P0726E           MOVE 'A'          TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)   
P0726E           PERFORM 5100-GET-BUSINESS-RULE  THRU 5100-EXIT         
P0726F           GO TO 2450-EXIT                                        
P0726E        END-IF                                                    
P0726E     END-IF.                                                      
                                                                        
P0726B* ACCOUNTS WHICH HAS FORECASTED CREDIT ACTION WILL NOT BE ELIGIBLE        
P0726B     IF T2-RULE-ID(T2-INDX) = 'CRDARNG067'                        
P0726F        IF WS-DNP-FLAG = 'Y'                                      
P0726F              SET VALIDATION-FAILED       TO TRUE                 
P0726F              MOVE 'F'         TO T4-RULE-RESULT-CD(T4-INDX)      
P0726F              MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX) 
P0726F              PERFORM 5100-GET-BUSINESS-RULE     THRU 5100-EXIT   
P0726F              GO TO 2450-EXIT                                     
P0726F        END-IF                                                    
P0726F                                                                  
P0726B        IF WS-DATE-DISC(1:4) NUMERIC AND                          
P0726B           WS-DATE-DISC(6:2) NUMERIC AND                          
P0726B           WS-DATE-DISC(9:2) NUMERIC                              
P0726B           IF WS-DATE-DISC >= WS-CURRENT-DATE                     
P0726B              SET VALIDATION-FAILED       TO TRUE                 
P0726B              MOVE 'F'          TO T4-RULE-RESULT-CD(T4-INDX)     
P0726E              MOVE 'A'          TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)
P0726B              PERFORM 5100-GET-BUSINESS-RULE     THRU 5100-EXIT   
P0726F              GO TO 2450-EXIT                                     
P0726B           END-IF                                                 
P0726B        ELSE                                                      
P0726B           IF WS-DATE-DISC = 'MULTIPLE'                           
P0726B              IF WS-DATE-CREDIT-ACTION-G >= WS-CURRENT-DATE OR    
P0726B                 WS-DATE-CREDIT-ACTION-D >= WS-CURRENT-DATE OR    
P0726B                 WS-DATE-CREDIT-ACTION-H >= WS-CURRENT-DATE OR    
P0726B                 WS-DATE-CREDIT-ACTION-I >= WS-CURRENT-DATE       
P0726B                 SET VALIDATION-FAILED    TO TRUE                 
P0726B                 MOVE 'F'      TO T4-RULE-RESULT-CD(T4-INDX)      
P0726E                 MOVE 'A'      TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX) 
P0726B                 PERFORM 5100-GET-BUSINESS-RULE  THRU 5100-EXIT   
P0726F                 GO TO 2450-EXIT                                  
P0726B              END-IF                                              
P0726B           END-IF                                                 
P0726B        END-IF                                                    
P0726B     END-IF.                                                      
P0726C                                                                  
P0726C* CREDIT PROCESS NOT COMPLETE ACCTS WILL NOT BE ELIGIBILE FOR CDD.        
P0726C     IF T2-RULE-ID(T2-INDX) = 'CRDARNG068'                        
P0726C        IF WS-INCOMPLETE-CREDIT-FL = 'Y'                          
P0726C           SET VALIDATION-FAILED    TO TRUE                       
P0726C           MOVE 'F'          TO T4-RULE-RESULT-CD(T4-INDX)        
P0726E           MOVE 'A'          TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)   
P0726C           PERFORM 5100-GET-BUSINESS-RULE  THRU 5100-EXIT         
P0726F           GO TO 2450-EXIT                                        
P0726C        END-IF                                                    
P0726C     END-IF.                                                      
P0726D* ACTIVE RETURNED CHECK ACCOUNTS WILL NOT BE ELIGIBILE FOR CDD.           
P0726D     IF T2-RULE-ID(T2-INDX) = 'CRDARNG079'                        
P0726D        IF WS-ACTIVE-RET-CHECK = 'Y'                              
P0726D           SET VALIDATION-FAILED    TO TRUE                       
P0726D           MOVE 'F'          TO T4-RULE-RESULT-CD(T4-INDX)        
P0726D           MOVE 'A'          TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)   
P0726D           PERFORM 5100-GET-BUSINESS-RULE  THRU 5100-EXIT         
P0726F           GO TO 2450-EXIT                                        
P0726D        END-IF                                                    
P0726D     END-IF.                                                      
P0726E* BUDGET BILLING ACCOUNTS WILL NOT BE ELIGIBLE FOR CDDA.                  
P0726E     IF T2-RULE-ID(T2-INDX) = 'CRDARNG082'                        
P0726E        IF WS-CODE-BUDGET = 'A'                                   
P0726E           SET VALIDATION-FAILED    TO TRUE                       
P0726E           MOVE 'F'          TO T4-RULE-RESULT-CD(T4-INDX)        
P0726E           MOVE 'A'          TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)   
P0726E           PERFORM 5100-GET-BUSINESS-RULE  THRU 5100-EXIT         
P0726F           GO TO 2450-EXIT                                        
P0726E        END-IF                                                    
P0726E     END-IF.                                                      
P0726F                                                                  
P0726F* Minimum amount needed for setting up any new arrangements               
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG101'                        
P0726F        IF WS-KR361-SETUP-BELOW-LMT-FL = 'Y'                      
P0726F           MOVE 'F'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           SET VALIDATION-FAILED          TO TRUE                 
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           GO TO 2450-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF.                                                      
P0726F                                                                  
D09359* Cannot establish payment arrangement if meter status is off             
D09359     IF WS-PENDING-SO-FLAG = 'Y'                                  
D09359        IF T2-RULE-ID(T2-INDX) = 'CRDARNG046'                     
D09359           IF WS-DNP-FLAG  = 'N' AND WS-DNP-ACT-FLAG = 'Y'        
D09359              MOVE 'F'       TO T4-RULE-RESULT-CD(T4-INDX)        
D09359              MOVE 'A'       TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)   
D09359              SET VALIDATION-FAILED          TO TRUE              
D09359              PERFORM 5100-GET-BUSINESS-RULE        THRU 5100-EXIT
D09359              GO TO 2450-EXIT                                     
D09359           END-IF                                                 
D09359        END-IF                                                    
D09359     END-IF.                                                      
D09359                                                                  
P00948* 60/90 days arrears must be less than limit amt                          
P00948     IF T2-RULE-ID(T2-INDX) = 'CRDARNG098'                        
P00948        IF WS-KR361-60-90-ATTR-FL = 'N'                           
P00948           SET VALIDATION-FAILED     TO TRUE                      
P00948           MOVE 'F'    TO T4-RULE-RESULT-CD(T4-INDX)              
P00948           MOVE 'A'    TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)         
P00948           PERFORM 5100-GET-BUSINESS-RULE        THRU 5100-EXIT   
P00948           GO TO 2450-EXIT                                        
P00948        END-IF                                                    
P00948     END-IF.                                                      
P00948                                                                  
P0726F 2450-EXIT.                                                       
P0726F     EXIT.                                                        
P0726F                                                                  
P0726F******************************************************************        
P0726F* 2460-STA-AFTER-VALIDATION                                               
P0726F******************************************************************        
P0726F                                                                  
P0726F 2460-STA-AFTER-VALIDATION.                                       
P0726F                                                                  
P0726F* ONLY ACTIVE ACCOUNTS ELIGIBLE FOR STA AFTER PLAN                        
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG004'                        
P0726F        IF AT-CODE-ACCT-STAT NOT = 'A'                            
P0726F           SET VALIDATION-FAILED    TO TRUE                       
P0726F           MOVE 'F'          TO T4-RULE-RESULT-CD(T4-INDX)        
P0726F           MOVE 'A'          TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)   
P0726F           PERFORM 5100-GET-BUSINESS-RULE  THRU 5100-EXIT         
P0726F           GO TO 2460-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF.                                                      
P0726F                                                                  
P0726F* ACCOUNTS WHICH HAS FORECASTED CREDIT ACTION WILL NOT BE ELIGIBLE        
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG067'                        
P0726F        IF WS-DNP-FLAG = 'Y'                                      
P0726F              SET VALIDATION-FAILED       TO TRUE                 
P0726F              MOVE 'F'         TO T4-RULE-RESULT-CD(T4-INDX)      
P0726F              MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX) 
P0726F              PERFORM 5100-GET-BUSINESS-RULE     THRU 5100-EXIT   
P0726F              GO TO 2460-EXIT                                     
P0726F        END-IF                                                    
P0726F                                                                  
P0726F        IF WS-DATE-DISC(1:4) NUMERIC AND                          
P0726F           WS-DATE-DISC(6:2) NUMERIC AND                          
P0726F           WS-DATE-DISC(9:2) NUMERIC                              
P0726F           IF WS-DATE-DISC >= WS-CURRENT-DATE                     
P0726F              SET VALIDATION-FAILED       TO TRUE                 
P0726F              MOVE 'F'         TO T4-RULE-RESULT-CD(T4-INDX)      
P0726F              MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX) 
P0726F              PERFORM 5100-GET-BUSINESS-RULE     THRU 5100-EXIT   
P0726F              GO TO 2460-EXIT                                     
P0726F           END-IF                                                 
P0726F        ELSE                                                      
P0726F           IF WS-DATE-DISC = 'MULTIPLE'                           
P0726F              IF WS-DATE-CREDIT-ACTION-G >= WS-CURRENT-DATE OR    
P0726F                 WS-DATE-CREDIT-ACTION-D >= WS-CURRENT-DATE OR    
P0726F                 WS-DATE-CREDIT-ACTION-H >= WS-CURRENT-DATE OR    
P0726F                 WS-DATE-CREDIT-ACTION-I >= WS-CURRENT-DATE       
P0726F                 SET VALIDATION-FAILED    TO TRUE                 
P0726F                 MOVE 'F'      TO T4-RULE-RESULT-CD(T4-INDX)      
P0726F                 MOVE 'A'      TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX) 
P0726F                 PERFORM 5100-GET-BUSINESS-RULE  THRU 5100-EXIT   
P0726F                 GO TO 2460-EXIT                                  
P0726F              END-IF                                              
P0726F           END-IF                                                 
P0726F        END-IF                                                    
P0726F     END-IF.                                                      
P0726F                                                                  
P0726F* ACCOUNT HASN'T BILLED FOR 1ST BILL WILL NOT BE ELIGIBLE FOR STAA        
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG007'                        
P0726F        IF AT-REV-MTH-LST-NRML > 0                                
P0726F           CONTINUE                                               
P0726F        ELSE                                                      
P0726F           SET VALIDATION-FAILED    TO TRUE                       
P0726F           MOVE 'F'          TO T4-RULE-RESULT-CD(T4-INDX)        
P0726F           MOVE 'A'          TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)   
P0726F           PERFORM 5100-GET-BUSINESS-RULE  THRU 5100-EXIT         
P0726F           GO TO 2460-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF.                                                      
P0726F                                                                  
P0726F* Account has an active STA/STF/STAA/STFA.                                
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG008'                        
P0726F        IF WS-CODE-STA-ACCT = 'A'                                 
P00948           IF ((WS-STAA-ELIGIBLE-FL = 'Y' AND                     
P00948                WS-ACTIVE-ARNG-TYPE = SPACES OR 'STA' OR 'STF') OR
P00948               STAA-NOT-PROCESSED)  AND                           
P00948              WS-ARNG-TYPE(T1-INDX) = 'STFA'                      
P0726F              CONTINUE                                            
P0726F           ELSE                                                   
P0726F              MOVE 'F'      TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F              MOVE 'A'      TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F              SET VALIDATION-FAILED       TO TRUE                 
P0726F              PERFORM 5100-GET-BUSINESS-RULE        THRU 5100-EXIT
P0726F              GO TO 2460-EXIT                                     
P0726F           END-IF                                                 
P0726F        END-IF                                                    
P0726F     END-IF.                                                      
P0726F                                                                  
P0726F* Account has active DPP                                                  
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG009'                        
P0726F        IF WS-CODE-DPP-ACCT = 'A'                                 
P0726F           MOVE 'F'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           SET VALIDATION-FAILED          TO TRUE                 
P0726F           GO TO 2460-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF.                                                      
P0726F                                                                  
P0726F* Account has an active Medical Certificate.                              
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG010'                        
P0726F        IF WS-CODE-MEDICAL  = 'A'                                 
P0726F           MOVE 'F'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           SET VALIDATION-FAILED          TO TRUE                 
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           GO TO 2460-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF.                                                      
P0726F                                                                  
P0726F* Account has unpaid Returned Check                                       
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG047'                        
P0726F        IF WS-AMT-NSA > 0                                         
P0726F           MOVE 'F'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           SET VALIDATION-FAILED          TO TRUE                 
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           GO TO 2460-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF.                                                      
P0726F* Immediate Deposit DNP                                                   
P0726F     IF WS-DATE-CREDIT-ACTION-I         > WS-CURRENT-DATE         
P0726F        MOVE 'Y'            TO WS-BILL-IMED-DEP                   
P0726F     END-IF.                                                      
P0726F                                                                  
P0726F     IF WS-BILL-IMED-DEP ='Y'                                     
P0726F        IF T2-RULE-ID(T2-INDX) = 'CRDARNG055'                     
P0726F           MOVE 'F'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           SET VALIDATION-FAILED          TO TRUE                 
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           GO TO 2460-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF.                                                      
P0726F                                                                  
P0726F* Account has unpaid deposit.                                             
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG104'                        
P0726F        IF WS-UNPAID-DEPOSIT = 'Y'                                
P0726F           MOVE 'F'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           SET VALIDATION-FAILED          TO TRUE                 
P0726F           GO TO 2460-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF                                                       
P0726F                                                                  
P0726F* Account not eligible for PRE-PAY PLAN.                                  
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG015'                        
P0726F        IF WS-CODE-PRE-PAY-PLAN = 'A'                             
P0726F           MOVE 'F'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           SET VALIDATION-FAILED          TO TRUE                 
P0726F           GO TO 2460-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF.                                                      
P0726F* BANK DRAFT OR E-DRAFT ACCOUNTS WILL NOT BE ELIGIBLE FOR CDD.            
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG014'                        
P0726F        IF WS-CODE-BANK-EFT = 'A'                                 
P0726F           SET VALIDATION-FAILED    TO TRUE                       
P0726F           MOVE 'F'          TO T4-RULE-RESULT-CD(T4-INDX)        
P0726F           MOVE 'A'          TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)   
P0726F           PERFORM 5100-GET-BUSINESS-RULE  THRU 5100-EXIT         
P0726F           GO TO 2460-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF.                                                      
P0726F                                                                  
P0726F* Account type should be Residential.                                     
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG097'                        
P0726F        IF AT-ACCOUNT-TYPE-CODE NOT = 'R'                         
P0726F           MOVE 'F'          TO T4-RULE-RESULT-CD(T4-INDX)        
P0726F           MOVE 'A'          TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)   
P0726F           SET VALIDATION-FAILED       TO TRUE                    
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           GO TO 2460-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF.                                                      
P0726F                                                                  
P0726F* Account type is Residential.                                            
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG020'                        
P0726F        MOVE 'P'          TO T4-RULE-RESULT-CD(T4-INDX)           
P0726F        MOVE 'A'          TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)      
P0726F        PERFORM 5100-GET-BUSINESS-RULE              THRU 5100-EXIT
P0726F        GO TO 2460-EXIT                                           
P0726F     END-IF.                                                      
P0726F                                                                  
P0726F* Budget Billing accounts will not be eligible for staa.                  
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG082'                        
P0726F        IF WS-CODE-BUDGET = 'A'                                   
P0726F           SET VALIDATION-FAILED    TO TRUE                       
P0726F           MOVE 'F'          TO T4-RULE-RESULT-CD(T4-INDX)        
P0726F           MOVE 'A'          TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)   
P0726F           PERFORM 5100-GET-BUSINESS-RULE  THRU 5100-EXIT         
P0726F           GO TO 2460-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF.                                                      
P0726F                                                                  
P0726F* Arrangement amount must be less than equal to STAA arng limit           
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG099'                        
P0726F        IF WS-KR361-LIMIT-ATTR-FL = 'N'                           
P0726F           SET VALIDATION-FAILED    TO TRUE                       
P0726F           MOVE 'F'          TO T4-RULE-RESULT-CD(T4-INDX)        
P0726F           MOVE 'A'          TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)   
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           GO TO 2460-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF.                                                      
P0726F                                                                  
P0726F                                                                  
P0726F* 60/90 days arrears must be less than limit amt                          
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG098'                        
P0726F        IF WS-KR361-60-90-ATTR-FL = 'N'                           
P0726F           SET VALIDATION-FAILED    TO TRUE                       
P0726F           MOVE 'F'          TO T4-RULE-RESULT-CD(T4-INDX)        
P0726F           MOVE 'A'          TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)   
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           GO TO 2460-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF.                                                      
P0726F                                                                  
P0726F* Cannot establish payment arrangement if meter status is off             
P0726F     IF WS-PENDING-SO-FLAG = 'Y'                                  
P0726F        IF T2-RULE-ID(T2-INDX) = 'CRDARNG046'                     
P0726F           IF WS-DNP-FLAG  = 'N' AND WS-DNP-ACT-FLAG = 'Y'        
P0726F              MOVE 'F'       TO T4-RULE-RESULT-CD(T4-INDX)        
P0726F              MOVE 'A'       TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)   
P0726F              SET VALIDATION-FAILED          TO TRUE              
P0726F              PERFORM 5100-GET-BUSINESS-RULE        THRU 5100-EXIT
P0726F              GO TO 2460-EXIT                                     
P0726F           END-IF                                                 
P0726F        END-IF                                                    
P0726F     END-IF.                                                      
P0726F                                                                  
P0726F* Minimum amount needed for setting up any new arrangements               
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG101'                        
P0726F        IF WS-KR361-SETUP-BELOW-LMT-FL = 'Y'                      
P0726F           MOVE 'F'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           SET VALIDATION-FAILED          TO TRUE                 
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           GO TO 2460-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF.                                                      
P0726F                                                                  
P0726F                                                                  
P0726F* Account with Fixed Income Assistance cannot be setup on STAA            
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG102'                        
P0726F        IF AT-BILL-CYCLE-CHG-CD = 'F'                             
P0726F           MOVE 'F'         TO T4-RULE-RESULT-CD(T4-INDX)         
P0726F           MOVE 'A'         TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)    
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           SET VALIDATION-FAILED          TO TRUE                 
P0726F           GO TO 2460-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF.                                                      
P0726F                                                                  
P0726F* Disconnect Exemption or Notice accounts not eligible for STAA.          
P0726F     IF T2-RULE-ID(T2-INDX) = 'CRDARNG103'                        
P0726F        IF AT-NOTICE-EXEMPT-CD > SPACES OR                        
P0726F           AT-CODE-DISC-OK > SPACES                               
P0726F           SET VALIDATION-FAILED    TO TRUE                       
P0726F           MOVE 'F'          TO T4-RULE-RESULT-CD(T4-INDX)        
P0726F           MOVE 'A'          TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)   
P0726F           PERFORM 5100-GET-BUSINESS-RULE  THRU 5100-EXIT         
P0726F           GO TO 2460-EXIT                                        
P0726F        END-IF                                                    
P0726F     END-IF.                                                      
P0726F                                                                  
P0726F                                                                  
P0726F 2460-EXIT.                                                       
P0726F     EXIT.                                                        
P0726F                                                                  
P0726F******************************************************************        
P0726F* 2490-COMPLIANCE-HIST-PROCESS                                            
P0726F******************************************************************        
P0726F                                                                  
P0726F 2490-COMPLIANCE-HIST-PROCESS.                                    
P0726F                                                                  
P0726F        MOVE 'DAYS-RECNT-ARRNGMT'  TO C8-DELINQ-CD                
P0726F        MOVE AT-COMPANY-NO         TO C8-COMPANY-NO               
P0726F        PERFORM 7010-GET-DLINQ-VAL                 THRU 7010-EXIT 
P0726F                                                                  
P0726F        IF  WS-RECENT-STA-DAYS <= C8-DELINQ-VALUE                 
P0726F        AND WS-RECENT-STA-DAYS > 0                                
P0726F            MOVE 'Y'               TO WS-RECENT-STA-FL            
P0726F        END-IF                                                    
P0726F                                                                  
P0726F        IF  WS-RECENT-DPP-DAYS <= C8-DELINQ-VALUE                 
P0726F        AND WS-RECENT-DPP-DAYS > 0                                
P0726F           MOVE 'Y'                TO WS-RECENT-DPP-FL            
P0726F        END-IF.                                                   
P0726F                                                                  
P0726F 2490-EXIT.                                                       
P0726F     EXIT.                                                        
P0726F                                                                  
      ******************************************************************        
      * 2500-BUILD-RESULTS-2                                                    
      ******************************************************************        
                                                                        
       2500-BUILD-RESULTS-2.                                            
                                                                        
           MOVE SPACES                    TO WS-DATE2-CCYY              
                                             WS-DATE2-MM                
                                             WS-DATE2-DD.               
           MOVE AT-TOTAL-AR-BALANCE       TO S-R2-TOTAL-AR-BALANCE      
P0726M     MOVE AT-LAST-UPDATE-TS         TO S-R2-LAST-UPDATE-TS        
           MOVE WS-ARNG-CHANNEL-CD(T1-INDX)  TO S-R2-ARNG-CHANNEL-CD    
           MOVE WS-TOTAL-BALANCE-UTL      TO S-R2-TOTAL-UTL-BALANCE     
           MOVE WS-TOTAL-BALANCE-NONUTL   TO S-R2-TOTAL-NONUTL-BALANCE  
           MOVE WS-AMT-ARREARS-UTL        TO S-R2-UTL-ARREARS-AMT       
           MOVE WS-AMT-ARREARS-NONUTL     TO S-R2-NONUTL-ARREARS-AMT    
           MOVE WS-SSN-CUST               TO S-R2-SSN-CUST              
           MOVE WS-SSN-SPOUSE             TO S-R2-SSN-SPOUSE            
           MOVE WS-SSN-ROOMMATE1          TO S-R2-SSN-ROOMMATE1         
           MOVE WS-SSN-ROOMMATE2          TO S-R2-SSN-ROOMMATE2         
           MOVE WS-SSN-ROOMMATE3          TO S-R2-SSN-ROOMMATE3         
P0726F     MOVE WS-ORIGINAL-DNP-TYPE      TO S-R2-ORIGINAL-DNP-TYPE     
P0726F     MOVE WS-ORIGINAL-DNP-DATE      TO S-R2-ORIGINAL-DNP-DATE     
P0726F     MOVE WS-FIRST-NOT-MAIL-DT      TO S-R2-FIRST-NOT-MAIL-DT     
P0726F     MOVE WS-FINAL-NOT-MAIL-DT      TO S-R2-FINAL-NOT-MAIL-DT     
                                                                        
P0726F     IF WS-ORIGINAL-DNP-DATE > SPACES                             
P0726F        MOVE WS-ORIGINAL-DNP-DATE(1:4) TO WS-DATE2-CCYY           
P0726F        MOVE WS-ORIGINAL-DNP-DATE(6:2) TO WS-DATE2-MM             
P0726F        MOVE WS-ORIGINAL-DNP-DATE(9:2) TO WS-DATE2-DD             
P0726F        MOVE WS-DATE-MM-DD-YYYY     TO S-R2-ORIGINAL-DNP-DATE     
P0726F     ELSE                                                         
P0726F        MOVE SPACES                 TO S-R2-ORIG-DUE-DT           
P0726F     END-IF.                                                      
P0726F                                                                  
P0726F     MOVE SPACES                    TO WS-DATE2-CCYY              
P0726F                                       WS-DATE2-MM                
P0726F                                       WS-DATE2-DD.               
P0726F                                                                  
           IF WS-DATE-BILL-DUE > SPACES                                 
              MOVE WS-DATE-BILL-DUE(1:4)  TO WS-DATE2-CCYY              
              MOVE WS-DATE-BILL-DUE(6:2)  TO WS-DATE2-MM                
              MOVE WS-DATE-BILL-DUE(9:2)  TO WS-DATE2-DD                
              MOVE WS-DATE-MM-DD-YYYY     TO S-R2-ORIG-DUE-DT           
           ELSE                                                         
P0726F        MOVE WS-DATE-NOTICE-DUE-A   TO S-R2-ORIG-DUE-DT           
           END-IF.                                                      
                                                                        
           PERFORM 8020-INSERT-GTT-R2     THRU 8020-EXIT.               
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2550-GET-BUS-RULE-DATA                                         *        
      ******************************************************************        
                                                                        
       2550-GET-BUS-RULE-DATA.                                          
                                                                        
           PERFORM 2560-GET-RULE-XREF        THRU 2560-EXIT             
                                                                        
P0726E     IF RULE-ID-FOUND                                             
P0726E        MOVE WS-RULE-XREF-ID       TO T4-BUS-RULE-XREF-ID(T4-INDX)
P0726E        MOVE WS-RULE-ID            TO T4-BUS-RULE-ID(T4-INDX)     
P0726E     ELSE                                                         
P0726E        IF WS-RULE-XREF-ID <= SPACES AND                          
P0726E           T2-COMPANY-NO (T2-INDX) = '00'                         
P0726E           MOVE T2-RULE-XREF-ID (T2-INDX)                         
                                         TO T4-BUS-RULE-XREF-ID(T4-INDX)
P0726E           MOVE WS-RULE-ID         TO T4-BUS-RULE-ID(T4-INDX)     
P0726E        ELSE                                                      
P0726E           MOVE 0                  TO T4-RETURN-CODE(T4-INDX)     
P0726E           MOVE SPACES             TO T4-ARNG-ID (T4-INDX)        
P0726E                                      T4-BUS-RULE-ID(T4-INDX)     
P0726E                                      T4-RULE-RESULT-CD(T4-INDX)  
P0726E                                      T4-BUS-RULE-XREF-ID(T4-INDX)
P0726E                                      T4-MESSAGE-PARMS(T4-INDX)   
P0726E                                      T4-LINK-PARMS(T4-INDX)      
P0726E                                   T4-RULE-NOTIFY-TYPE-CD(T4-INDX)
P0726E        END-IF                                                    
P0726E     END-IF.                                                      
                                                                        
       2550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2560-GET-RULE-XREF                                             *        
      ******************************************************************        
                                                                        
       2560-GET-RULE-XREF.                                              
                                                                        
P0726E     SET T3-INDX TO +1.                                           
P0726E     SEARCH T3-RULES                                              
              AT END                                                    
                 MOVE SPACES TO WS-RULE-XREF-ID                         
P0726E         WHEN T3-RULE-ID (T3-INDX)     = WS-RULE-ID               
P0726E          AND T3-COMPANY-NO (T3-INDX)  = WS-COMP-NO               
P0726E              MOVE T3-RULE-XREF-ID (T3-INDX) TO WS-RULE-XREF-ID   
P0726E              SET RULE-ID-FOUND       TO TRUE                     
           END-SEARCH.                                                  
                                                                        
       2560-EXIT.                                                       
           EXIT.                                                        
                                                                        
P0726E******************************************************************        
P0726E* 2570-GET-LST-PLAN-ERR-MSGS                                     *        
P0726E******************************************************************        
P0726E                                                                  
P0726E 2570-GET-LST-PLAN-ERR-MSGS.                                      
P0726E                                                                  
P0726E     PERFORM VARYING T4-INDX FROM 1 BY 1                          
P0726E       UNTIL T4-INDX > WS-TEMP-RULE-COUNT OR                      
P0726E             T4-BUS-RULE-XREF-ID(T4-INDX) = SPACES                
P0726E          IF T4-ARNG-ID(T4-INDX) = WS-CURR-ARNG-ID                
P0726E             MOVE T4-RETURN-CODE(T4-INDX) TO S-R3-RETURN-CODE     
P0726E             MOVE T4-ARNG-ID(T4-INDX)     TO S-R3-ARNG-ID         
P0726E             MOVE T4-RULE-NOTIFY-TYPE-CD(T4-INDX) TO              
P0726E                                      S-R3-RULE-NOTIFY-TYPE-CD    
P0726E             MOVE T4-BUS-RULE-ID(T4-INDX) TO S-R3-BUS-RULE-ID     
P0726E             MOVE T4-RULE-RESULT-CD(T4-INDX)                      
P0726E                                          TO S-R3-RULE-RESULT-CD  
P0726E             MOVE T4-BUS-RULE-XREF-ID(T4-INDX)    TO              
P0726E                                          S-R3-BUS-RULE-XREF-ID   
P0726E             MOVE T4-MESSAGE-PARMS(T4-INDX)                       
P0726E                                          TO S-R3-MESSAGE-PARMS   
P0726E             MOVE T4-LINK-PARMS(T4-INDX)  TO S-R3-LINK-PARMS      
P0726E             PERFORM 8030-INSERT-GTT-R3   THRU 8030-EXIT          
P0726E          END-IF                                                  
P0726E     END-PERFORM.                                                 
P0726E                                                                  
P0726E 2570-EXIT.                                                       
P0726E     EXIT.                                                        
P0726E                                                                  
P0726E******************************************************************        
P0726E* 2580-GET-PLAN-ERR-MSG                                          *        
P0726E******************************************************************        
P0726E                                                                  
P0726E 2580-GET-PLAN-ERR-MSG.                                           
P0726E                                                                  
P0726E     MOVE 0                       TO S-R3-RETURN-CODE.            
P0726E     MOVE 'F'                     TO S-R3-RULE-RESULT-CD.         
P0726E     MOVE 'A'                     TO S-R3-RULE-NOTIFY-TYPE-CD.    
P0726E     MOVE SPACES                  TO WS-RULE-XREF-ID.             
P0726E     MOVE 'N'                     TO WS-RULE-ID-FOUND.            
P0726E     MOVE 'CRDARNG066'            TO WS-RULE-ID                   
P0726E                                     S-R3-BUS-RULE-ID.            
P0726E     MOVE AT-COMPANY-NO           TO WS-COMP-NO.                  
P0726E                                                                  
P0726E     PERFORM 2560-GET-RULE-XREF             THRU 2560-EXIT.       
P0726E     IF RULE-ID-FOUND                                             
P0726E        MOVE WS-RULE-XREF-ID      TO S-R3-BUS-RULE-XREF-ID        
P0726E     ELSE                                                         
P0726E        IF WS-RULE-XREF-ID <= SPACES                              
P0726E           PERFORM 2590-PLAN-ERR-RULE-XREF  THRU 2590-EXIT        
P0726E        END-IF                                                    
P0726E     END-IF.                                                      
P0726E                                                                  
P0726E     PERFORM 8030-INSERT-GTT-R3             THRU 8030-EXIT.       
P0726E                                                                  
P0726E 2580-EXIT.                                                       
P0726E     EXIT.                                                        
P0726E                                                                  
P0726E******************************************************************        
P0726E* 2590-PLAN-ERR-RULE-XREF                                        *        
P0726E******************************************************************        
P0726E                                                                  
P0726E 2590-PLAN-ERR-RULE-XREF.                                         
P0726E                                                                  
P0726E     SET T2-INDX TO +1.                                           
P0726E     SEARCH T2-RULES                                              
P0726E        AT END                                                    
P0726E           MOVE SPACES TO WS-RULE-XREF-ID                         
P0726E         WHEN T2-RULE-ID (T2-INDX)     = WS-RULE-ID               
P0726E          AND T2-COMPANY-NO (T2-INDX)  = '00'                     
P0726E              MOVE T2-RULE-XREF-ID (T2-INDX) TO                   
P0726E                   S-R3-BUS-RULE-XREF-ID                          
P0726E     END-SEARCH.                                                  
P0726E                                                                  
P0726E 2590-EXIT.                                                       
P0726E     EXIT.                                                        
P0726E                                                                  
P0726E******************************************************************        
P0726E* 2600-BUILD-RESULTS-3                                                    
P0726E******************************************************************        
P0726E                                                                  
P0726E 2600-BUILD-RESULTS-3.                                            
P0726E                                                                  
P0726E     PERFORM VARYING T4-INDX FROM 1 BY 1                          
P0726E       UNTIL T4-INDX > WS-TEMP-RULE-COUNT OR                      
P0726E             T4-BUS-RULE-XREF-ID(T4-INDX) = SPACES                
P0726F          IF T4-ARNG-ID(T4-INDX) = WS-CURR-ARNG-ID                
P0726E             MOVE T4-RETURN-CODE(T4-INDX) TO S-R3-RETURN-CODE     
P0726E             MOVE T4-ARNG-ID(T4-INDX)     TO S-R3-ARNG-ID         
P0726E             MOVE T4-RULE-NOTIFY-TYPE-CD(T4-INDX) TO              
P0726E                                          S-R3-RULE-NOTIFY-TYPE-CD
P0726E             MOVE T4-BUS-RULE-ID(T4-INDX) TO S-R3-BUS-RULE-ID     
P0726E             MOVE T4-RULE-RESULT-CD(T4-INDX)                      
P0726E                                          TO S-R3-RULE-RESULT-CD  
P0726E             MOVE T4-BUS-RULE-XREF-ID(T4-INDX)                    
P0726E                                          TO S-R3-BUS-RULE-XREF-ID
P0726E             MOVE T4-MESSAGE-PARMS(T4-INDX)                       
P0726E                                          TO S-R3-MESSAGE-PARMS   
P0726E             MOVE T4-LINK-PARMS(T4-INDX)  TO S-R3-LINK-PARMS      
P0726E             PERFORM 8030-INSERT-GTT-R3   THRU 8030-EXIT          
P0726E          END-IF                                                  
P0726E     END-PERFORM.                                                 
P0726E                                                                  
P0726E 2600-EXIT.                                                       
P0726E     EXIT.                                                        
P0726E                                                                  
P0726F******************************************************************        
P0726F* 2610-CTMTR-MAJOR-ACCT-CHK                                      *        
P0726F******************************************************************        
P0726F                                                                  
P0726F 2610-CTMTR-MAJOR-ACCT-CHK.                                       
P0726F                                                                  
P0726F     IF AT-ACCOUNT-TYPE-CODE  = 'R' AND                           
P0726F        AT-CT-METER-RATED-IND NOT = 'Y'                           
P0726F* Account type is Residential.                                            
P0726F        IF T2-RULE-ID(T2-INDX) = 'CRDARNG020'                     
P0726F           MOVE 'P'          TO T4-RULE-RESULT-CD(T4-INDX)        
P0726F           MOVE 'A'          TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)   
P0726F           PERFORM 5100-GET-BUSINESS-RULE           THRU 5100-EXIT
P0726F           GO TO 2610-EXIT                                        
P0726F        END-IF                                                    
P0726F     ELSE                                                         
P0726F        IF AT-CODE-MAJOR-ACCT = 'Y'                               
P0726F           IF WS-KR361-MAJOR-ATTR-FL = 'Y'                        
P0726F              IF T2-RULE-ID(T2-INDX) = 'CRDARNG048'               
P00836                 IF PARM-ARNG-CHANNEL-CD  = 'I' OR 'W'            
P0726F                    SET VALIDATION-FAILED    TO TRUE              
P0726F                 END-IF                                           
P0726F                 MOVE 'F'    TO T4-RULE-RESULT-CD(T4-INDX)        
P0726F                 MOVE 'A'    TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)   
P0726F                 PERFORM 5100-GET-BUSINESS-RULE     THRU 5100-EXIT
P0726F                 GO TO 2610-EXIT                                  
P0726F              END-IF                                              
P0726F           END-IF                                                 
P0726F        ELSE                                                      
P0726F           IF AT-CT-METER-RATED-IND = 'Y'                         
P0726F              IF WS-KR361-CT-METER-ATTR-FL = 'Y'                  
P0726F* Account is a CT Meter Account. You may want to consult with             
P0726F* Corporate Credit @ 71599 prior to establishing or changing arngs        
P0726F                 IF T2-RULE-ID(T2-INDX) = 'CRDARNG080'            
P0726F                    MOVE 'P' TO T4-RULE-RESULT-CD(T4-INDX)        
P0726F                    MOVE 'A' TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)   
P0726F                    PERFORM 5100-GET-BUSINESS-RULE  THRU 5100-EXIT
P0726F                    GO TO 2610-EXIT                               
P0726F                 END-IF                                           
P0726F              ELSE                                                
P0726F* Insufficient authority to setup or change STA on CT Meter/Major         
P0726F* account. For arrangements, contact with Corporate Credit @71599         
P0726F                 IF T2-RULE-ID(T2-INDX) = 'CRDARNG090'            
P00836                    IF PARM-ARNG-CHANNEL-CD  = 'I' OR 'W'         
P0726E                       SET VALIDATION-FAILED TO TRUE              
P0726E                    END-IF                                        
P0726F                    MOVE 'F' TO T4-RULE-RESULT-CD(T4-INDX)        
P0726F                    MOVE 'A' TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)   
P0726F                    PERFORM 5100-GET-BUSINESS-RULE  THRU 5100-EXIT
P0726F                    GO TO 2610-EXIT                               
P0726F                 END-IF                                           
P0726F              END-IF                                              
P0726F           ELSE                                                   
P0726F              IF AT-ACCOUNT-TYPE-CODE = 'C'                       
P0726F* This is a Commercial account.                                           
P0726F                 IF T2-RULE-ID(T2-INDX) = 'CRDARNG031'            
P00836                    IF PARM-ARNG-CHANNEL-CD  = 'I' OR 'W'         
P0726K                       MOVE 'F' TO T4-RULE-RESULT-CD(T4-INDX)     
P0726K                       SET VALIDATION-FAILED TO TRUE              
P0726K                    ELSE                                          
P0726K                       MOVE 'P' TO T4-RULE-RESULT-CD(T4-INDX)     
P0726K                    END-IF                                        
P0726F                    MOVE 'A' TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)   
P0726F                    PERFORM 5100-GET-BUSINESS-RULE  THRU 5100-EXIT
P0726F                    GO TO 2610-EXIT                               
P0726F                 END-IF                                           
P0726F              ELSE                                                
P0726F* Account type is not Residential or Commercial.                          
P0726F                 IF T2-RULE-ID(T2-INDX) = 'CRDARNG003'            
P0726F                    MOVE 'F' TO T4-RULE-RESULT-CD(T4-INDX)        
P0726F                    MOVE 'A' TO T4-RULE-NOTIFY-TYPE-CD(T4-INDX)   
P0726F                    PERFORM 5100-GET-BUSINESS-RULE  THRU 5100-EXIT
P0726F                    SET VALIDATION-FAILED           TO TRUE       
P0726F                    GO TO 2610-EXIT                               
P0726F                 END-IF                                           
P0726F              END-IF                                              
P0726F           END-IF                                                 
P0726F        END-IF                                                    
P0726F     END-IF.                                                      
P0726F                                                                  
P0726F 2610-EXIT.                                                       
P0726F     EXIT.                                                        
P0726F                                                                  
P0726F******************************************************************        
P0726F* 2620-TEMP-ARREARS-HIST                                                  
P0726F******************************************************************        
P0726F                                                                  
P0726F 2620-TEMP-ARREARS-HIST.                                          
P0726F                                                                  
P0726F     MOVE SPACES                  TO WS-UTIL-HISTORY              
P0726F                                     WS-ACCT-HST.                 
P0726F     MOVE '1'                     TO WS-UTILITY-ARREARS(1:1).     
P0726F                                                                  
P0726F     IF WS-MONTHS-TO-EVALUATE > 24                                
P0726F        MOVE 24 TO WS-MONTHS-TO-EVALUATE                          
P0726F     END-IF.                                                      
P0726F                                                                  
P0726F     MOVE CZ-ARREARS-HIST(1:WS-MONTHS-TO-EVALUATE)                
P0726F                                  TO WS-UTILITY-ARREARS(2:23).    
P0726F     MOVE WS-UTIL-HISTORY         TO WS-ACCT-HST.                 
P0726F                                                                  
P0726F 2620-EXIT.                                                       
P0726F     EXIT.                                                        
P0726F                                                                  
P0726E******************************************************************        
P0726E* 5100-GET-BUSINESS-RULE                                         *        
P0726E******************************************************************        
P0726E                                                                  
P0726E 5100-GET-BUSINESS-RULE.                                          
P0726F                                                                  
P0726E     MOVE 'N'                         TO WS-RULE-ID-FOUND         
P0726E     MOVE SPACES                      TO WS-RULE-XREF-ID          
P0726E     MOVE 0                           TO T4-RETURN-CODE(T4-INDX). 
P0726E     MOVE WS-ARNG-ID(T1-INDX)         TO T4-ARNG-ID(T4-INDX).     
P0726E     MOVE T2-RULE-ID(T2-INDX)         TO WS-RULE-ID.              
P0726E     MOVE T2-COMPANY-NO(T2-INDX)      TO WS-COMP-NO.              
           PERFORM 2550-GET-BUS-RULE-DATA      THRU 2550-EXIT.          
P0726E     IF T4-BUS-RULE-XREF-ID(T4-INDX) > SPACES                     
P0726E        SET T4-INDX UP BY 1                                       
P0726E        ADD +1                        TO WS-TEMP-RULE-COUNT       
P0726E     END-IF.                                                      
P0726E                                                                  
P0726E 5100-EXIT.                                                       
P0726E     EXIT.                                                        
P0726E                                                                  
P0726F******************************************************************        
P0726E* 5110-GET-NEXT-BUSINESS-DAY                                     *        
P0726F******************************************************************        
P0726F                                                                  
P0726E 5110-GET-NEXT-BUSINESS-DAY.                                      
P0726F                                                                  
P0726F     INITIALIZE WS-DATE2-CCYY                                     
P0726F                WS-DATE2-MM                                       
P0726F                WS-DATE2-DD.                                      
P0726E     PERFORM 6500-GET-NEXT-BUSINESS-DAY                           
P0726E                                  THRU 6500-NEXT-BUSINESS-DAY-EXIT
P0726E     MOVE WS-NEW-BUSINESS-DAY     TO WS-DATE-CCYY-MM-DD.          
P0726E     MOVE WS-DATE-CCYY            TO WS-DATE2-CCYY.               
P0726E     MOVE WS-DATE-MM              TO WS-DATE2-MM.                 
P0726E     MOVE WS-DATE-DD              TO WS-DATE2-DD.                 
P0726E     MOVE WS-DATE-MM-DD-YYYY      TO WS-CALC-DUE-DATE.            
P0726E                                                                  
P0726E 5110-EXIT.                                                       
P0726E     EXIT.                                                        
P0726E                                                                  
P0726F******************************************************************        
P0726F* 5120-GET-PREV-BUSINESS-DAY                                     *        
P0726F******************************************************************        
P0726F                                                                  
P0726F 5120-GET-PREV-BUSINESS-DAY.                                      
P0726F                                                                  
P0726F     INITIALIZE WS-DATE2-CCYY                                     
P0726F                WS-DATE2-MM                                       
P0726F                WS-DATE2-DD.                                      
P0726F     PERFORM 6525-PREV-BUSINESS-DAY                               
P0726F                                  THRU 6525-PREV-BUSINESS-DAY-EXIT
P0726F     MOVE WS-NEW-BUSINESS-DAY     TO WS-DATE-CCYY-MM-DD.          
P0726F     MOVE WS-DATE-CCYY            TO WS-DATE2-CCYY.               
P0726F     MOVE WS-DATE-MM              TO WS-DATE2-MM.                 
P0726F     MOVE WS-DATE-DD              TO WS-DATE2-DD.                 
P0726F     MOVE WS-DATE-MM-DD-YYYY      TO WS-CALC-DUE-DATE.            
P0726F                                                                  
P0726F 5120-EXIT.                                                       
P0726F     EXIT.                                                        
P0726F                                                                  
P0726F******************************************************************        
P0726F* 5130-STA-SCEG-FRCST                                            *        
P0726F******************************************************************        
P0726F                                                                  
P0726F 5130-STA-SCEG-FRCST.                                             
P0726F                                                                  
P0726F                                                                  
P0726F 5130-EXIT.                                                       
P0726F     EXIT.                                                        
P0726F                                                                  
      ******************************************************************        
      * 5000-PROCESS-ARNG-ATTRIBUTES                                            
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDKR361                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 5900-NEXT-BILL-DATE                                                     
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00309                                                  
           END-EXEC.                                                            
                                                                        
P0726E******************************************************************        
P0726E* 5901-NEXT-READ-DATE                                                     
P0726E******************************************************************        
P0726E                                                                  
P0726E     EXEC SQL                                                             
P0726E        INCLUDE CPD00310                                                  
P0726E     END-EXEC.                                                            
P0726E                                                                  
P0726E******************************************************************        
P0726E* 6500-GET-NEXT-BUSINESS-DAY                                     *        
P0726E******************************************************************        
P0726E                                                                  
P0726E     EXEC SQL                                                             
P0726E        INCLUDE CPD00322                                                  
P0726E     END-EXEC.                                                            
P0726E                                                                  
P0726E******************************************************************        
P0726E* 6565-PROCESS-CREDIT-RULE                                       *        
P0726E******************************************************************        
P0726E                                                                  
P0726E     EXEC SQL                                                             
P0726E        INCLUDE CPD00334                                                  
P0726E     END-EXEC.                                                            
P0726E                                                                  
      ******************************************************************        
      *  7000-SELECT-ACCOUNT                                           *31850000
      ******************************************************************        
                                                                        
       7000-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
              SELECT AT.CODES_DATA_PRESENT                              
                    ,AT.TOTAL_AR_BALANCE                                
                    ,AT.COMPANY_NO                                      
                    ,AT.CREDIT_GROUP                                    
                    ,AT.CODE_ACCT_STAT                                  
                    ,AT.ACCOUNT_TYPE_CODE                               
                    ,AT.CODE_MAJOR_ACCT                                 
                    ,AT.CT_METER_RATED_IND                              
                    ,AT.REV_MTH_LST_NRML                                
                    ,AT.BILL_CYCLE                                      
                    ,COALESCE(AT.LAST_PYMT_DATE,IIF(TRY_CONVERT(DATE, 
              '0001-01-01') IS NULL OR (PATINDEX('%.%', '0001-01-01'
              ) <> 0) OR (LEN('0001-01-01') <> 10), CIS.CHAR2DATE(
              '0001-01-01'), CONVERT(DATE, '0001-01-01') ))             
                    ,AT.CUSTOMER_NO                                     
P0726A              ,AT.NOTICE_EXEMPT_CD                                
P0726A              ,AT.CODE_DISC_OK                                    
P0726A              ,AT.DATE_BILL_DAY_00                                
P0726A              ,AT.DATE_BILL_DAY_30                                
P0726A              ,AT.DATE_BILL_DAY_60                                
P0726A              ,AT.DATE_BILL_DAY_90                                
P0726A              ,AT.LOCAL_OFFICE                                    
P0726A              ,AT.BANKRUPTCY_IND                                  
P0726A              ,AT.IVR_EXEMPT_CD                                   
P0726E              ,AT.CODE_BILL_FREQ                                  
P0726F              ,CIS.DAYS(CAST(SYSDATETIMEOFFSET() AS DATE)) -              
P0726F               CIS.DAYS(COALESCE(AT.LAST_PYMT_DATE,
              IIF(TRY_CONVERT(DATE, '1900-01-01'
              ) IS NULL OR (PATINDEX('%.%', '1900-01-01'
              ) <> 0) OR (LEN('1900-01-01') <> 10), CIS.CHAR2DATE(
              '1900-01-01'), CONVERT(DATE, '1900-01-01') )))       
P0726F              ,COALESCE(CAST(AT.ACCT_FINALED_DT AS DATE),
              IIF(TRY_CONVERT(DATE, '1900-01-01'
              ) IS NULL OR (PATINDEX('%.%', '1900-01-01'
              ) <> 0) OR (LEN('1900-01-01') <> 10), CIS.CHAR2DATE(
              '1900-01-01'), CONVERT(DATE, '1900-01-01') ))      
P0726F              ,AT.BILL_CYCLE_CHG_CD                               
P0726K              ,AT.JUDGEMENT_IND                                   
P0726M              ,REPLACE(REPLACE(CONVERT(CHAR(26), AT.LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS                         
                INTO :AT-CODES-DATA-PRESENT                             
                    ,:AT-TOTAL-AR-BALANCE                               
                    ,:AT-COMPANY-NO                                     
                    ,:AT-CREDIT-GROUP                                   
                    ,:AT-CODE-ACCT-STAT                                 
                    ,:AT-ACCOUNT-TYPE-CODE                              
                    ,:AT-CODE-MAJOR-ACCT                                
                    ,:AT-CT-METER-RATED-IND                             
                    ,:AT-REV-MTH-LST-NRML                               
                    ,:AT-BILL-CYCLE                                     
                    ,:AT-LAST-PYMT-DATE                                 
                    ,:AT-CUSTOMER-NO                                    
P0726A              ,:AT-NOTICE-EXEMPT-CD                               
P0726A              ,:AT-CODE-DISC-OK                                   
P0726A              ,:AT-DATE-BILL-DAY-00 :WS-DATE-BILL-00-IND          
P0726A              ,:AT-DATE-BILL-DAY-30 :WS-DATE-BILL-30-IND          
P0726A              ,:AT-DATE-BILL-DAY-60 :WS-DATE-BILL-60-IND          
P0726A              ,:AT-DATE-BILL-DAY-90 :WS-DATE-BILL-90-IND          
P0726A              ,:AT-LOCAL-OFFICE                                   
P0726A              ,:AT-BANKRUPTCY-IND                                 
P0726A              ,:AT-IVR-EXEMPT-CD                                  
P0726E              ,:AT-CODE-BILL-FREQ                                 
P0726F              ,:WS-RECENT-PYMT-DAYS                               
P0726F              ,:AT-ACCT-FINALED-DT                                
P0726F              ,:AT-BILL-CYCLE-CHG-CD                              
P0726K              ,:AT-JUDGEMENT-IND                                  
P0726M              ,:AT-LAST-UPDATE-TS                                 
                FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     31860000
MFA-TR*       SELECT AT.CODES_DATA_PRESENT                              32000000
MFA-TR*             ,AT.TOTAL_AR_BALANCE                                        
MFA-TR*             ,AT.COMPANY_NO                                              
MFA-TR*             ,AT.CREDIT_GROUP                                            
MFA-TR*             ,AT.CODE_ACCT_STAT                                          
MFA-TR*             ,AT.ACCOUNT_TYPE_CODE                                       
MFA-TR*             ,AT.CODE_MAJOR_ACCT                                         
MFA-TR*             ,AT.CT_METER_RATED_IND                                      
MFA-TR*             ,AT.REV_MTH_LST_NRML                                        
MFA-TR*             ,AT.BILL_CYCLE                                              
MFA-TR*             ,IFNULL(AT.LAST_PYMT_DATE,'0001-01-01')                     
MFA-TR*             ,AT.CUSTOMER_NO                                             
MFA-TR*             ,AT.NOTICE_EXEMPT_CD                                        
MFA-TR*             ,AT.CODE_DISC_OK                                            
MFA-TR*             ,AT.DATE_BILL_DAY_00                                        
MFA-TR*             ,AT.DATE_BILL_DAY_30                                        
MFA-TR*             ,AT.DATE_BILL_DAY_60                                        
MFA-TR*             ,AT.DATE_BILL_DAY_90                                        
MFA-TR*             ,AT.LOCAL_OFFICE                                            
MFA-TR*             ,AT.BANKRUPTCY_IND                                          
MFA-TR*             ,AT.IVR_EXEMPT_CD                                           
MFA-TR*             ,AT.CODE_BILL_FREQ                                          
MFA-TR*             ,DAYS(CURRENT DATE) -                                       
MFA-TR*              DAYS(IFNULL(AT.LAST_PYMT_DATE,'1900-01-01'))               
MFA-TR*             ,IFNULL(DATE(AT.ACCT_FINALED_DT),'1900-01-01')              
MFA-TR*             ,AT.BILL_CYCLE_CHG_CD                                       
MFA-TR*             ,AT.JUDGEMENT_IND                                           
MFA-TR*             ,AT.LAST_UPDATE_TS                                          
MFA-TR*         INTO :AT-CODES-DATA-PRESENT                             32260000
MFA-TR*             ,:AT-TOTAL-AR-BALANCE                                       
MFA-TR*             ,:AT-COMPANY-NO                                             
MFA-TR*             ,:AT-CREDIT-GROUP                                           
MFA-TR*             ,:AT-CODE-ACCT-STAT                                         
MFA-TR*             ,:AT-ACCOUNT-TYPE-CODE                                      
MFA-TR*             ,:AT-CODE-MAJOR-ACCT                                        
MFA-TR*             ,:AT-CT-METER-RATED-IND                                     
MFA-TR*             ,:AT-REV-MTH-LST-NRML                                       
MFA-TR*             ,:AT-BILL-CYCLE                                             
MFA-TR*             ,:AT-LAST-PYMT-DATE                                         
MFA-TR*             ,:AT-CUSTOMER-NO                                            
MFA-TR*             ,:AT-NOTICE-EXEMPT-CD                                       
MFA-TR*             ,:AT-CODE-DISC-OK                                           
MFA-TR*             ,:AT-DATE-BILL-DAY-00 :WS-DATE-BILL-00-IND                  
MFA-TR*             ,:AT-DATE-BILL-DAY-30 :WS-DATE-BILL-30-IND                  
MFA-TR*             ,:AT-DATE-BILL-DAY-60 :WS-DATE-BILL-60-IND                  
MFA-TR*             ,:AT-DATE-BILL-DAY-90 :WS-DATE-BILL-90-IND                  
MFA-TR*             ,:AT-LOCAL-OFFICE                                           
MFA-TR*             ,:AT-BANKRUPTCY-IND                                         
MFA-TR*             ,:AT-IVR-EXEMPT-CD                                          
MFA-TR*             ,:AT-CODE-BILL-FREQ                                         
MFA-TR*             ,:WS-RECENT-PYMT-DAYS                                       
MFA-TR*             ,:AT-ACCT-FINALED-DT                                        
MFA-TR*             ,:AT-BILL-CYCLE-CHG-CD                                      
MFA-TR*             ,:AT-JUDGEMENT-IND                                          
MFA-TR*             ,:AT-LAST-UPDATE-TS                                         
MFA-TR*         FROM CSS_ACCOUNT AT                                     32390000
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        32400000
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7000                                                       
MFA-TR*    END-EXEC.                                                    32410000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
P0726A     IF WS-DATE-BILL-00-IND < 0                                   
P0726A        MOVE SPACES TO AT-DATE-BILL-DAY-00                        
P0726A        MOVE ZEROES TO WS-DATE-BILL-00-IND                        
P0726A     END-IF                                                       
P0726A     IF WS-DATE-BILL-30-IND < 0                                   
P0726A        MOVE SPACES TO AT-DATE-BILL-DAY-30                        
P0726A        MOVE ZEROES TO WS-DATE-BILL-30-IND                        
P0726A     END-IF                                                       
P0726A     IF WS-DATE-BILL-60-IND < 0                                   
P0726A        MOVE SPACES TO AT-DATE-BILL-DAY-60                        
P0726A        MOVE ZEROES TO WS-DATE-BILL-60-IND                        
P0726A     END-IF                                                       
P0726A     IF WS-DATE-BILL-90-IND < 0                                   
P0726A        MOVE SPACES TO AT-DATE-BILL-DAY-90                        
P0726A        MOVE ZEROES TO WS-DATE-BILL-90-IND                        
P0726A     END-IF                                                       
P0726F     IF AT-ACCT-FINALED-DT  = '1900-01-01'                        
P0726F        MOVE SPACES TO AT-ACCT-FINALED-DT                         
P0726F     END-IF                                                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7000'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_ACCOUNT'            TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
P0726E*****************************************************************         
P0726E* 7010-MET-DLINQ-VAL.                                           *         
P0726E*****************************************************************         
P0726E                                                                  
P0726E 7010-GET-DLINQ-VAL.                                              
P0726E                                                                  
P0726E     EXEC SQL                                                     
P0726E        SELECT C8.DELINQ_VALUE                                    
P0726E          INTO :C8-DELINQ-VALUE                                   
P0726E          FROM CSS_DELINQUENCY C8 WITH(READUNCOMMITTED)                   
P0726E         WHERE C8.DELINQ_CD  = :C8-DELINQ-CD                      
P0726E           AND C8.COMPANY_NO = :C8-COMPANY-NO                     
P0726E                                                           
P0726E                                                      
P0726E     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT C8.DELINQ_VALUE                                            
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY C8                                         
MFA-TR*        WHERE C8.DELINQ_CD  = :C8-DELINQ-CD                              
MFA-TR*          AND C8.COMPANY_NO = :C8-COMPANY-NO                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7010                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0726E                                                                  
P0726E     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
P0726E                                                                  
P0726E     EVALUATE WS-ACTIVE-RETURN-CODE                               
P0726E       WHEN SUCCESSFUL-CALL                                       
P0726E         CONTINUE                                                 
P0726E       WHEN OTHER                                                 
P0726E         MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
P0726E         MOVE SQLCODE                 TO ABEND-SQLCODE            
P0726E                                         RS-RETURN-CODE           
P0726E         MOVE SQLSTATE                TO ABEND-SQLSTATE           
P0726E         MOVE '7010'                  TO ACTIVE-PARAGRAPH         
P0726E         MOVE 'SELECT'                TO ABEND-FUNCTION           
P0726E         MOVE 'CSS_DELINQUENCY'       TO TABLE-1                  
P0726E         MOVE 'DELINQ_CD'             TO TABLE-ELEMENT-1          
P0726E         MOVE 'COMPANY_NO'            TO TABLE-ELEMENT-2          
P0726E         MOVE C8-DELINQ-CD            TO HOSTVAR-ELEMENT-1        
P0726E         MOVE C8-COMPANY-NO           TO HOSTVAR-ELEMENT-2        
P0726E         PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT              
P0726E     END-EVALUATE.                                                
P0726E                                                                  
P0726E 7010-EXIT.                                                       
P0726E     EXIT.                                                        
P0726E                                                                  
      ******************************************************************        
      * 7020-AUTOCARD-SETUP                                            *31850000
      ******************************************************************        
                                                                        
       7020-AUTOCARD-SETUP.                                             
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) ACCOUNT_NO                                        
                 INTO :YP-ACCOUNT-NO                                    
                 FROM CSS_ACCT_ATTRIBUTE WITH(READUNCOMMITTED)                  
                WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO               
                  AND ATTRIBUTE_DESC     = 'AUTO_CARD_PAY'              
                  AND ATTRIBUTE_VALUE_CD = 'AUTOC'                      
                  AND STATUS_CD          = 'A'                          
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ACCOUNT_NO                                                
MFA-TR*          INTO :YP-ACCOUNT-NO                                            
MFA-TR*          FROM CSS_ACCT_ATTRIBUTE                                        
MFA-TR*         WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO                       
MFA-TR*           AND ATTRIBUTE_DESC     = 'AUTO_CARD_PAY'                      
MFA-TR*           AND ATTRIBUTE_VALUE_CD = 'AUTOC'                              
MFA-TR*           AND STATUS_CD          = 'A'                                  
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7020                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y'    TO WS-AUTOCARD-SETUP-FL                  
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE 'N'    TO WS-AUTOCARD-SETUP-FL                  
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '7020'               TO ACTIVE-PARAGRAPH        
                   MOVE 'SELECT'             TO ABEND-FUNCTION          
                   MOVE 'CSS_ACCT_ATTRIBUTE' TO TABLE-1                 
                   MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1         
                   MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1       
                   PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05330000
      * 7030-CUSTOMER-SSN                                              *05620000
      ******************************************************************        
                                                                        
       7030-CUSTOMER-SSN.                                               
                                                                        
           EXEC SQL                                                     
              SELECT CE.SSN                                             
                INTO :CE-SSN                                            
                FROM CSS_CUST_STATS CE WITH(READUNCOMMITTED)                    
               WHERE CE.CUSTOMER_NO   = :AT-CUSTOMER-NO                 
                 AND CE.CUSTOMER_TYPE = :CE-CUSTOMER-TYPE               
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CE.SSN                                                     
MFA-TR*         INTO :CE-SSN                                                    
MFA-TR*         FROM CSS_CUST_STATS CE                                          
MFA-TR*        WHERE CE.CUSTOMER_NO   = :AT-CUSTOMER-NO                         
MFA-TR*          AND CE.CUSTOMER_TYPE = :CE-CUSTOMER-TYPE                       
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7030                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES              TO WS-ACTIVE-RETURN-CODE   
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME        TO ABEND-PROGRAM           
                    MOVE '7030'              TO ACTIVE-PARAGRAPH        
                    MOVE 'SELECT'            TO ABEND-FUNCTION          
                    MOVE 'CSS_CUST_STATUS'   TO TABLE-1                 
                    MOVE 'CUSTOMER_NO'       TO TABLE-ELEMENT-1         
                    MOVE 'CUSTOMER_TYPE'     TO TABLE-ELEMENT-2         
                    MOVE AT-CUSTOMER-NO      TO HOSTVAR-ELEMENT-1       
                    MOVE CE-CUSTOMER-TYPE    TO HOSTVAR-ELEMENT-2       
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
P0726E******************************************************************05330000
P0726E* 7040-SELECT-ARNG-ID                                            *05620000
P0726E******************************************************************        
P0726E                                                                  
P0726E 7040-SELECT-ARNG-ID.                                             
P0726E                                                                  
P0726E     EXEC SQL                                                     
P0726E        SELECT 'Y'                                                
P0726E          INTO :WS-ARNG-ID-EXISTS                                 
P0726E          FROM CSS_CRED_ARNGMENT X1 WITH(READUNCOMMITTED)                 
P0726E         WHERE X1.ACCOUNT_NO     = :X1-ACCOUNT-NO                 
P0726E           AND X1.ARNG_ID        = :WS-ARRANGEMENT-ID             
P0726E           AND X1.ARNG_STATUS_CD = 'A'                            
P0726E                                                           
P0726E                                                      
P0726E     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-ARNG-ID-EXISTS                                         
MFA-TR*         FROM CSS_CRED_ARNGMENT X1                                       
MFA-TR*        WHERE X1.ACCOUNT_NO     = :X1-ACCOUNT-NO                         
MFA-TR*          AND X1.ARNG_ID        = :WS-ARRANGEMENT-ID                     
MFA-TR*          AND X1.ARNG_STATUS_CD = 'A'                                    
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7040                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0726E                                                                  
P0726E     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
P0726E                                                                  
P0726E     EVALUATE WS-ACTIVE-RETURN-CODE                               
P0726E         WHEN SUCCESSFUL-CALL                                     
P0726E              CONTINUE                                            
P0726E         WHEN NOT-FOUND                                           
P0726E              MOVE ZEROES              TO WS-ACTIVE-RETURN-CODE   
P0726E              MOVE SPACES              TO X1-ARNG-ID              
P0726E         WHEN OTHER                                               
P0726E              MOVE PROGRAM-NAME        TO ABEND-PROGRAM           
P0726E              MOVE '7040'              TO ACTIVE-PARAGRAPH        
P0726E              MOVE 'SELECT'            TO ABEND-FUNCTION          
P0726E              MOVE 'CSS_CRED_ARNGMENT' TO TABLE-1                 
P0726E              MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1         
P0726E              MOVE 'ARNG_ID'           TO TABLE-ELEMENT-2         
P0726E              MOVE X1-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1       
P0726E              MOVE UJ-ARNG-ID          TO HOSTVAR-ELEMENT-2       
P0726E              PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
P0726E     END-EVALUATE.                                                
P0726E                                                                  
P0726E 7040-EXIT.                                                       
P0726E     EXIT.                                                        
P0726E                                                                  
      ******************************************************************        
      * 7050-GET-CURRENT-DATE                                                   
      ******************************************************************        
                                                                        
       7050-GET-CURRENT-DATE.                                           
                                                                        
           EXEC SQL                                                     
               SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE),
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CIS.DAYS(CAST(SYSDATETIMEOFFSET() AS DATE)) -              
P0726F                                CIS.DAYS( IIF(TRY_CONVERT(DATE, 
                                                   :AT-DATE-BILL-DAY-30
              ) IS NULL OR (PATINDEX('%.%', :AT-DATE-BILL-DAY-30
              ) <> 0) OR (LEN(:AT-DATE-BILL-DAY-30
              ) <> 10), CIS.CHAR2DATE(:AT-DATE-BILL-DAY-30
              ), CONVERT(DATE, :AT-DATE-BILL-DAY-30) ) ),
              CIS.DAYS(CAST(SYSDATETIMEOFFSET() AS DATE)) -              
P0726F                                CIS.DAYS( IIF(TRY_CONVERT(DATE, 
                                                   :AT-DATE-BILL-DAY-60
              ) IS NULL OR (PATINDEX('%.%', :AT-DATE-BILL-DAY-60
              ) <> 0) OR (LEN(:AT-DATE-BILL-DAY-60
              ) <> 10), CIS.CHAR2DATE(:AT-DATE-BILL-DAY-60
              ), CONVERT(DATE, :AT-DATE-BILL-DAY-60) ) ),
              CIS.DAYS(CAST(SYSDATETIMEOFFSET() AS DATE)) -              
P0726F                                CIS.DAYS( IIF(TRY_CONVERT(DATE, 
                                                   :AT-DATE-BILL-DAY-90
              ) IS NULL OR (PATINDEX('%.%', :AT-DATE-BILL-DAY-90
              ) <> 0) OR (LEN(:AT-DATE-BILL-DAY-90
              ) <> 10), CIS.CHAR2DATE(:AT-DATE-BILL-DAY-90
              ), CONVERT(DATE, :AT-DATE-BILL-DAY-90) ) )
            INTO
              :WS-CURRENT-DATE,
              :WS-CURRENT-TIMESTMP,
              :WS-DAYS-30,
              :WS-DAYS-60,
              :WS-DAYS-90        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET: WS-CURRENT-DATE = CURRENT DATE                              
MFA-TR*          ,:WS-CURRENT-TIMESTMP = CURRENT TIMESTAMP                      
MFA-TR*          ,:WS-DAYS-30       = DAYS(CURRENT DATE) -                      
MFA-TR*                               DAYS(:AT-DATE-BILL-DAY-30)                
MFA-TR*          ,:WS-DAYS-60       = DAYS(CURRENT DATE) -                      
MFA-TR*                               DAYS(:AT-DATE-BILL-DAY-60)                
MFA-TR*          ,:WS-DAYS-90       = DAYS(CURRENT DATE) -                      
MFA-TR*                               DAYS(:AT-DATE-BILL-DAY-90)                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7050'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SET'                    TO ABEND-FUNCTION           
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
P0726E******************************************************************05330000
P0726E* 7060-SELECT-CRED-FORECAST-DT                                   *05620000
P0726E******************************************************************        
P0726E                                                                  
P0726E 7060-SELECT-CRED-FORECAST-DT.                                    
P0726E                                                                  
P0726E     EXEC SQL                                                     
P0726E        SELECT CM.DNP_NOTICE_DUE_DT                               
P0726E              ,CM.CURR_CHG_DUE_DT                                 
P0726E          INTO :CM-DNP-NOTICE-DUE-DT :WS-DNP-NOTICE-DUE-DT-NULL  
P0726E              ,:CM-CURR-CHG-DUE-DT :WS-CURR-CHG-DUE-DT-NULL    
P0726E          FROM CSS_CRED_FORECAST CM WITH(READUNCOMMITTED)                 
P0726E         WHERE CM.COMPANY_NO        = :AT-COMPANY-NO              
P0726E           AND CM.REG_GROUP_CD      = :WS-REG-GROUP-CD            
P0726E           AND CM.REVENUE_MONTH     = :WS-REV-MTH-LST-NRML        
P0726E           AND CM.BILL_CYCLE        = :WS-BILL-CYCLE              
P0726E           AND CM.CREDIT_GROUP      = :WS-CREDIT-GROUP            
P0726E           AND CM.CREDIT_GROUP_ID   = ''                          
P0726E           AND CM.BILL_DT           = IIF(TRY_CONVERT(DATE, 
                                                          :WS-BILL-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-BILL-DATE
              ) <> 0) OR (LEN(:WS-BILL-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-BILL-DATE
              ), CONVERT(DATE, :WS-BILL-DATE) )               
P0726E           AND CM.CRED_ACCT_TYPE_CD = :WS-ACCOUNT-TYPE-CODE       
P0726E                                                           
P0726E                                                      
P0726E     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CM.DNP_NOTICE_DUE_DT                                       
MFA-TR*             ,CM.CURR_CHG_DUE_DT                                         
MFA-TR*         INTO :CM-DNP-NOTICE-DUE-DT  :WS-DNP-NOTICE-DUE-DT-NULL          
MFA-TR*             ,:CM-CURR-CHG-DUE-DT    :WS-CURR-CHG-DUE-DT-NULL            
MFA-TR*         FROM CSS_CRED_FORECAST CM                                       
MFA-TR*        WHERE CM.COMPANY_NO        = :AT-COMPANY-NO                      
MFA-TR*          AND CM.REG_GROUP_CD      = :WS-REG-GROUP-CD                    
MFA-TR*          AND CM.REVENUE_MONTH     = :WS-REV-MTH-LST-NRML                
MFA-TR*          AND CM.BILL_CYCLE        = :WS-BILL-CYCLE                      
MFA-TR*          AND CM.CREDIT_GROUP      = :WS-CREDIT-GROUP                    
MFA-TR*          AND CM.CREDIT_GROUP_ID   = ''                                  
MFA-TR*          AND CM.BILL_DT           = :WS-BILL-DATE                       
MFA-TR*          AND CM.CRED_ACCT_TYPE_CD = :WS-ACCOUNT-TYPE-CODE               
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7060                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0726E                                                                  
P0726E                                                                  
P0726E     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
P0726E                                                                  
P0726E     EVALUATE WS-ACTIVE-RETURN-CODE                               
P0726E         WHEN SUCCESSFUL-CALL                                     
P0726E              MOVE 'N'                 TO                         
P0726E                                       WS-FORECAST-ROW-NOT-FOUND  
P0726E              IF WS-DNP-NOTICE-DUE-DT-NULL < 0                    
P0726E                 MOVE SPACES           TO CM-DNP-NOTICE-DUE-DT    
P0726E                 MOVE ZEROS            TO                         
P0726E                                       WS-DNP-NOTICE-DUE-DT-NULL  
P0726E              END-IF                                              
P0726E              IF WS-CURR-CHG-DUE-DT-NULL < 0                      
P0726E                 MOVE SPACES           TO CM-CURR-CHG-DUE-DT      
P0726E                 MOVE ZEROS            TO WS-CURR-CHG-DUE-DT-NULL 
P0726E              END-IF                                              
P0726E         WHEN NOT-FOUND                                           
P0726E              MOVE 'Y'                 TO                         
P0726E                                       WS-FORECAST-ROW-NOT-FOUND  
P0726E         WHEN OTHER                                               
P0726E              MOVE PROGRAM-NAME        TO ABEND-PROGRAM           
P0726E              MOVE '7060'              TO ACTIVE-PARAGRAPH        
P0726E              MOVE 'SELECT'            TO ABEND-FUNCTION          
P0726E              MOVE 'CSS_CRED_FORECAST' TO TABLE-1                 
P0726E              MOVE 'COMPANY_NO'        TO TABLE-ELEMENT-1         
P0726E              MOVE AT-COMPANY-NO       TO HOSTVAR-ELEMENT-1       
P0726E              MOVE 'REV_MTH_LST_NRML'  TO TABLE-ELEMENT-2         
P0726E              MOVE WS-REV-MTH-LST-NRML TO HOSTVAR-ELEMENT-2       
P0726E              MOVE 'BILL_CYCLE'        TO TABLE-ELEMENT-3         
P0726E              MOVE AT-BILL-CYCLE       TO HOSTVAR-ELEMENT-3       
P0726E              MOVE 'ACCOUNT_TYPE_CODE' TO TABLE-ELEMENT-4         
P0726E              MOVE WS-ACCOUNT-TYPE-CODE   TO HOSTVAR-ELEMENT-4    
P0726E              PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
P0726E     END-EVALUATE.                                                
P0726E                                                                  
P0726E 7060-EXIT.                                                       
P0726E     EXIT.                                                        
P0726E                                                                  
      ******************************************************************        
      * 7070-SELECT-REG-GROUP-CD                                       *        
      ******************************************************************        
                                                                        
       7070-SELECT-REG-GROUP-CD.                                        
                                                                        
           EXEC SQL                                                     
              SELECT LR.REG_GROUP_CD                                    
                    ,LR.SENIOR_FL                                       
                INTO :WS-REG-GROUP-CD                                   
                    ,:LR-SENIOR-FL                                      
                FROM CSS_REG_PROFILE LR WITH(READUNCOMMITTED)                   
               WHERE LR.ACCOUNT_NO = :AT-ACCOUNT-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT LR.REG_GROUP_CD                                            
MFA-TR*             ,LR.SENIOR_FL                                               
MFA-TR*         INTO :WS-REG-GROUP-CD                                           
MFA-TR*             ,:LR-SENIOR-FL                                              
MFA-TR*         FROM CSS_REG_PROFILE LR                                         
MFA-TR*        WHERE LR.ACCOUNT_NO = :AT-ACCOUNT-NO                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7070                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
P0726F              MOVE SPACES             TO WS-REG-GROUP-CD          
                    MOVE 0                  TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE '7070'             TO ACTIVE-PARAGRAPH         
                    MOVE 'SELECT'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSS_REG_PROFILE'  TO TABLE-1                  
                    MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1          
                    MOVE AT-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       7070-EXIT.                                                       
           EXIT.                                                        
                                                                        
P0726C******************************************************************        
P0726C* 7080-SELECT-BILL-DETAILS                                       *        
P0726C******************************************************************        
P0726C                                                                  
P0726C 7080-SELECT-BILL-DETAILS.                                        
P0726C                                                                  
P0726C     EXEC SQL                                                     
P0726C        SELECT TOP(1) BILL_NO,
              DATE_BILLED                                        
P0726C          INTO :BI-BILL-NO                                        
P0726C              ,:BI-DATE-BILLED                                    
P0726C          FROM CSS_BILLING_HDR WITH(READUNCOMMITTED)                      
P0726C         WHERE ACCOUNT_NO  = :BI-ACCOUNT-NO                       
P0726C           AND DATE_BILLED IS NOT NULL                            
P0726C         ORDER BY BILL_NO DESC                                    
P0726C                                                           
P0726C                                           
P0726C                                                      
P0726C     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BILL_NO                                                    
MFA-TR*             ,DATE_BILLED                                                
MFA-TR*         INTO :BI-BILL-NO                                                
MFA-TR*             ,:BI-DATE-BILLED                                            
MFA-TR*         FROM CSS_BILLING_HDR                                            
MFA-TR*        WHERE ACCOUNT_NO  = :BI-ACCOUNT-NO                               
MFA-TR*          AND DATE_BILLED IS NOT NULL                                    
MFA-TR*        ORDER BY BILL_NO DESC                                            
MFA-TR*         WITH UR                                                         
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*      QUERYNO 7080                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0726C                                                                  
P0726C     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
P0726C                                                                  
P0726C     EVALUATE WS-ACTIVE-RETURN-CODE                               
P0726C         WHEN SUCCESSFUL-CALL                                     
P0726C              MOVE 'Y'                TO WS-BILL-HDR-FL           
P0726C         WHEN NOT-FOUND                                           
P0726C              MOVE 0                  TO WS-ACTIVE-RETURN-CODE    
P0726C         WHEN OTHER                                               
P0726C              MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
P0726C              MOVE '7080'             TO ACTIVE-PARAGRAPH         
P0726C              MOVE 'SELECT'           TO ABEND-FUNCTION           
P0726C              MOVE SPACES             TO ABEND-SQL-PREDICATES     
P0726C                                         ABEND-TABLES             
P0726C              MOVE 'CSS_BILLING_HDR'  TO TABLE-1                  
P0726C              MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1          
P0726C              MOVE BI-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1        
P0726C              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
P0726C     END-EVALUATE.                                                
P0726C                                                                  
P0726C 7080-EXIT.                                                       
P0726C     EXIT.                                                        
P0726C                                                                  
P0726C******************************************************************        
P0726C* 7090-SELECT-JOB-PARM                                           *        
P0726C******************************************************************        
P0726C                                                                  
P0726C 7090-SELECT-JOB-PARM.                                            
P0726C                                                                  
P0726C     EXEC SQL                                                     
P0726C        SELECT TOP(1) (SELECT IIF(TRY_CONVERT(DATE, E) IS NULL OR 
              (PATINDEX('%.%', E) <> 0) OR (LEN(E) <> 10), 
              CIS.CHAR2DATE(E), CONVERT(DATE, E)) FROM (SELECT 
           CIS.SUBSTR3(PARM_DATA,1,10) E) T)                       
P0726C          INTO :WS-PARM-DATE                                      
P0726C          FROM CSS_JOB_PARM WITH(READUNCOMMITTED)                         
P0726C         WHERE PROGRAM_NAME = :G6-PROGRAM-NAME                    
P0726C           AND COMPANY_NO   = :G6-COMPANY-NO                      
P0726C           AND CMND_CODE    = :G6-CMND-CODE                       
P0726C                                                           
P0726C                                           
P0726C                                                      
P0726C     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DATE(SUBSTR(PARM_DATA,1,10))                               
MFA-TR*         INTO :WS-PARM-DATE                                              
MFA-TR*         FROM CSS_JOB_PARM                                               
MFA-TR*        WHERE PROGRAM_NAME = :G6-PROGRAM-NAME                            
MFA-TR*          AND COMPANY_NO   = :G6-COMPANY-NO                              
MFA-TR*          AND CMND_CODE    = :G6-CMND-CODE                               
MFA-TR*         WITH UR                                                         
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*      QUERYNO 7090                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0726C                                                                  
P0726C     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P0726C                                                                  
P0726C     EVALUATE WS-ACTIVE-RETURN-CODE                               
P0726C         WHEN SUCCESSFUL-CALL                                     
P0726C              CONTINUE                                            
P0726C         WHEN NOT-FOUND                                           
P0726C              MOVE 0                  TO WS-ACTIVE-RETURN-CODE    
P0726C         WHEN OTHER                                               
P0726C              MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
P0726C              MOVE '7090'             TO ACTIVE-PARAGRAPH         
P0726C              MOVE 'SELECT'           TO ABEND-FUNCTION           
P0726C              MOVE SPACES             TO ABEND-SQL-PREDICATES     
P0726C                                         ABEND-TABLES             
P0726C              MOVE 'CSS_JOB_PARM'     TO TABLE-1                  
P0726C              MOVE 'PROGRAM_NAME'     TO TABLE-ELEMENT-1          
P0726C              MOVE G6-PROGRAM-NAME    TO HOSTVAR-ELEMENT-1        
P0726C              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
P0726C     END-EVALUATE.                                                
P0726C                                                                  
P0726C 7090-EXIT.                                                       
P0726C     EXIT.                                                        
P0726C                                                                  
P0726C******************************************************************        
P0726C* 7100-BILL-CRED-DET                                             *        
P0726C******************************************************************        
P0726C                                                                  
P0726C 7100-BILL-CRED-DET.                                              
P0726C                                                                  
P0726C     EXEC SQL                                                     
P0726C        SELECT BILL_NO                                            
P0726C          INTO :1H-BILL-NO                                        
P0726C          FROM CSS_BILL_CRED_DET WITH(READUNCOMMITTED)                    
P0726C         WHERE ACCOUNT_NO  = :1H-ACCOUNT-NO                       
P0726C           AND BILL_NO     = :1H-BILL-NO                          
P0726C                                                           
P0726C                                                      
P0726C     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BILL_NO                                                    
MFA-TR*         INTO :1H-BILL-NO                                                
MFA-TR*         FROM CSS_BILL_CRED_DET                                          
MFA-TR*        WHERE ACCOUNT_NO  = :1H-ACCOUNT-NO                               
MFA-TR*          AND BILL_NO     = :1H-BILL-NO                                  
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0726C                                                                  
P0726C     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P0726C                                                                  
P0726C     EVALUATE WS-ACTIVE-RETURN-CODE                               
P0726C         WHEN SUCCESSFUL-CALL                                     
P0726C              CONTINUE                                            
P0726C         WHEN NOT-FOUND                                           
P0726C              MOVE 'Y'                  TO WS-INCOMPLETE-CREDIT-FL
P0726C              MOVE 0                    TO WS-ACTIVE-RETURN-CODE  
P0726C         WHEN OTHER                                               
P0726C              MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
P0726C              MOVE '7100'               TO ACTIVE-PARAGRAPH       
P0726C              MOVE 'SELECT'             TO ABEND-FUNCTION         
P0726C              MOVE SPACES               TO ABEND-SQL-PREDICATES   
P0726C                                           ABEND-TABLES           
P0726C              MOVE 'CSS_BILL_CRED_DET'  TO TABLE-1                
P0726C              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1        
P0726C              MOVE 1H-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1      
P0726C              MOVE 'BILL_NO'            TO TABLE-ELEMENT-2        
P0726C              MOVE 1H-BILL-NO           TO HOSTVAR-ELEMENT-2      
P0726C              PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
P0726C     END-EVALUATE.                                                
P0726C                                                                  
P0726C 7100-EXIT.                                                       
P0726C     EXIT.                                                        
P0726C                                                                  
P0726D******************************************************************        
P0726D* 7110-ACTIVE-RETURNED-CHECK                                     *        
P0726D******************************************************************        
P0726D                                                                  
P0726D 7110-ACTIVE-RETURNED-CHECK.                                      
P0726D                                                                  
P0726D     EXEC SQL                                                     
P0726D        SELECT SUM(AMT_AR_DAY_00)                                 
P0726D              ,SUM(AMT_AR_DAY_30)                                 
P0726D              ,SUM(AMT_AR_DAY_60)                                 
P0726D              ,SUM(AMT_AR_DAY_90)                                 
P0726D          INTO :AC-AMT-AR-DAY-00 :WS-AMT-AR-DAY-00-NULL           
P0726D              ,:AC-AMT-AR-DAY-30 :WS-AMT-AR-DAY-30-NULL           
P0726D              ,:AC-AMT-AR-DAY-60 :WS-AMT-AR-DAY-60-NULL           
P0726D              ,:AC-AMT-AR-DAY-90 :WS-AMT-AR-DAY-90-NULL           
P0726D          FROM CSS_AR_CNTL WITH(READUNCOMMITTED)                          
P0726D         WHERE ACCOUNT_NO         = :AC-ACCOUNT-NO                
P0726D           AND PYMT_PRIORITY_LVL IN (020, 029)                    
P0726D                                                           
P0726D                                                      
P0726D     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SUM(AMT_AR_DAY_00)                                         
MFA-TR*             ,SUM(AMT_AR_DAY_30)                                         
MFA-TR*             ,SUM(AMT_AR_DAY_60)                                         
MFA-TR*             ,SUM(AMT_AR_DAY_90)                                         
MFA-TR*         INTO :AC-AMT-AR-DAY-00 :WS-AMT-AR-DAY-00-NULL                   
MFA-TR*             ,:AC-AMT-AR-DAY-30 :WS-AMT-AR-DAY-30-NULL                   
MFA-TR*             ,:AC-AMT-AR-DAY-60 :WS-AMT-AR-DAY-60-NULL                   
MFA-TR*             ,:AC-AMT-AR-DAY-90 :WS-AMT-AR-DAY-90-NULL                   
MFA-TR*         FROM CSS_AR_CNTL                                                
MFA-TR*        WHERE ACCOUNT_NO         = :AC-ACCOUNT-NO                        
MFA-TR*          AND PYMT_PRIORITY_LVL IN (020, 029)                            
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7110                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0726D                                                                  
P0726D     MOVE SQLCODE          TO WS-ACTIVE-RETURN-CODE.              
P0726D                                                                  
P0726D     EVALUATE WS-ACTIVE-RETURN-CODE                               
P0726D         WHEN SUCCESSFUL-CALL                                     
P0726D              IF WS-AMT-AR-DAY-00-NULL < 0                        
P0726D                 MOVE 0.00 TO AC-AMT-AR-DAY-00                    
P0726D                 MOVE 0    TO WS-AMT-AR-DAY-00-NULL               
P0726D              END-IF                                              
P0726D              IF WS-AMT-AR-DAY-30-NULL < 0                        
P0726D                 MOVE 0.00 TO AC-AMT-AR-DAY-30                    
P0726D                 MOVE 0    TO WS-AMT-AR-DAY-30-NULL               
P0726D              END-IF                                              
P0726D              IF WS-AMT-AR-DAY-60-NULL < 0                        
P0726D                 MOVE 0.00 TO AC-AMT-AR-DAY-60                    
P0726D                 MOVE 0    TO WS-AMT-AR-DAY-60-NULL               
P0726D              END-IF                                              
P0726D              IF WS-AMT-AR-DAY-90-NULL < 0                        
P0726D                 MOVE 0.00 TO AC-AMT-AR-DAY-90                    
P0726D                 MOVE 0    TO WS-AMT-AR-DAY-90-NULL               
P0726D              END-IF                                              
P0726D              IF AC-AMT-AR-DAY-00 > 0 OR                          
P0726D                 AC-AMT-AR-DAY-30 > 0 OR                          
P0726D                 AC-AMT-AR-DAY-60 > 0 OR                          
P0726D                 AC-AMT-AR-DAY-90 > 0                             
P0726D                 MOVE 'Y'  TO WS-ACTIVE-RET-CHECK                 
P0726D              END-IF                                              
P0726D         WHEN NOT-FOUND                                           
P0726D              MOVE 'N'     TO WS-ACTIVE-RET-CHECK                 
P0726D         WHEN OTHER                                               
P0726D              MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
P0726D              MOVE '7110'             TO ACTIVE-PARAGRAPH         
P0726D              MOVE 'SELECT'           TO ABEND-FUNCTION           
P0726D              MOVE SPACES             TO ABEND-SQL-PREDICATES     
P0726D                                         ABEND-TABLES             
P0726D              MOVE 'CSS_AR_CNTL'      TO TABLE-1                  
P0726D              MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1          
P0726D              MOVE AC-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1        
P0726D              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
P0726D     END-EVALUATE.                                                
P0726D                                                                  
P0726D 7110-EXIT.                                                       
P0726D     EXIT.                                                        
P0726D                                                                  
P0726E******************************************************************        
P0726E* 7120-SEL-CRED-PROFILE.                                         *        
P0726E******************************************************************        
P0726E                                                                  
P0726E 7120-SEL-CRED-PROFILE.                                           
P0726E                                                                  
P0726E      EXEC SQL                                                    
P0726E         SELECT CZ.ARREARS_HIST                                   
P0726E               ,CZ.DISCONNECT_HIST                                
P0726E               ,CZ.DISC_EXCEPTN_HIST                              
P0726F               ,CZ.CR_GRP_EFFECT_DT                               
P0726E           INTO :CZ-ARREARS-HIST                                  
P0726E               ,:CZ-DISCONNECT-HIST                               
P0726E               ,:CZ-DISC-EXCEPTN-HIST                             
P0726F               ,:CZ-CR-GRP-EFFECT-DT :WS-CR-GRP-EFF-DT-NULL       
P0726E           FROM CSS_CREDIT_PROFILE CZ                             
P0726E          WHERE CZ.ACCOUNT_NO = :CZ-ACCOUNT-NO                    
P0726E                                                      
P0726E      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*     EXEC SQL                                                            
MFA-TR*        SELECT CZ.ARREARS_HIST                                           
MFA-TR*              ,CZ.DISCONNECT_HIST                                        
MFA-TR*              ,CZ.DISC_EXCEPTN_HIST                                      
MFA-TR*              ,CZ.CR_GRP_EFFECT_DT                                       
MFA-TR*          INTO :CZ-ARREARS-HIST                                          
MFA-TR*              ,:CZ-DISCONNECT-HIST                                       
MFA-TR*              ,:CZ-DISC-EXCEPTN-HIST                                     
MFA-TR*              ,:CZ-CR-GRP-EFFECT-DT :WS-CR-GRP-EFF-DT-NULL               
MFA-TR*          FROM CSS_CREDIT_PROFILE CZ                                     
MFA-TR*         WHERE CZ.ACCOUNT_NO = :CZ-ACCOUNT-NO                            
MFA-TR*       QUERYNO 7120                                                      
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0726E                                                                  
P0726E     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
P0726E                                                                  
P0726E     EVALUATE WS-ACTIVE-RETURN-CODE                               
P0726E       WHEN SUCCESSFUL-CALL                                       
P0726F         IF WS-CR-GRP-EFF-DT-NULL < 0                             
P0726F            MOVE SPACES               TO CZ-CR-GRP-EFFECT-DT      
P0726F            MOVE 0                    TO WS-CR-GRP-EFF-DT-NULL    
P0726F         END-IF                                                   
P0726E       WHEN NOT-FOUND                                             
P0726E         CONTINUE                                                 
P0726E       WHEN OTHER                                                 
P0726E         MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
P0726E         MOVE SQLCODE                 TO ABEND-SQLCODE            
P0726E                                         RS-RETURN-CODE           
P0726E         MOVE SQLSTATE                TO ABEND-SQLSTATE           
P0726E         MOVE '7120'                  TO ACTIVE-PARAGRAPH         
P0726E         MOVE 'SELECT'                TO ABEND-FUNCTION           
P0726E         MOVE 'CSS_CREDIT_PROFILE'    TO TABLE-1                  
P0726E         MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
P0726E         MOVE CZ-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
P0726E         PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT              
P0726E     END-EVALUATE.                                                
P0726E                                                                  
P0726E 7120-EXIT.                                                       
P0726E      EXIT.                                                       
P0726E                                                                  
P0726F******************************************************************        
P0726F* 7130-CHK-DPP-DROP                                              *        
P0726F******************************************************************        
P0726F                                                                  
P0726F 7130-CHK-DPP-DROP.                                               
P0726F                                                                  
P0726F     EXEC SQL                                                     
P0726F        SELECT TOP(1) 'Y'                                               
P0726F          INTO :WS-DPP-DROP-EXISTS                                
P0726F          FROM CSS_ACCT_ATTRIBUTE YP WITH(READUNCOMMITTED)                
P0726F         WHERE YP.ACCOUNT_NO           = :YP-ACCOUNT-NO           
P0726F           AND YP.STATUS_CD            = 'A'                      
P0726F           AND YP.ATTRIBUTE_DESC       = 'AUTO_DROP_DPP'          
P0726F                                    
P0726F                                                      
P0726F     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  'Y'                                                       
MFA-TR*         INTO :WS-DPP-DROP-EXISTS                                        
MFA-TR*         FROM CSS_ACCT_ATTRIBUTE YP                                      
MFA-TR*        WHERE YP.ACCOUNT_NO           = :YP-ACCOUNT-NO                   
MFA-TR*          AND YP.STATUS_CD            = 'A'                              
MFA-TR*          AND YP.ATTRIBUTE_DESC       = 'AUTO_DROP_DPP'                  
MFA-TR*        FETCH FIRST 1 ROWS ONLY WITH UR                                  
MFA-TR*      QUERYNO 7130                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0726F                                                                  
P0726F     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
P0726F                                                                  
P0726F     EVALUATE WS-ACTIVE-RETURN-CODE                               
P0726F       WHEN SUCCESSFUL-CALL                                       
P0726F       WHEN NOT-FOUND                                             
P0726F         CONTINUE                                                 
P0726F       WHEN OTHER                                                 
P0726F         MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
P0726F         MOVE SQLCODE                 TO ABEND-SQLCODE            
P0726F                                         RS-RETURN-CODE           
P0726F         MOVE SQLSTATE                TO ABEND-SQLSTATE           
P0726F         MOVE '7130'                  TO ACTIVE-PARAGRAPH         
P0726F         MOVE 'SELECT'                TO ABEND-FUNCTION           
P0726F         MOVE 'CSS_CREDIT_PROFILE'    TO TABLE-1                  
P0726F         MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
P0726F         MOVE YP-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
P0726F         PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT              
P0726F     END-EVALUATE.                                                
P0726F                                                                  
P0726F 7130-EXIT.                                                       
P0726F      EXIT.                                                       
P0726F                                                                  
P0726F***************************************************************           
P0726F* 7150-SELECT-PENDING-SO                                                  
P0726F***************************************************************           
P0726F                                                                  
P0726F 7150-SELECT-PENDING-SO.                                          
P0726F                                                                  
P0726F     EXEC SQL                                                     
P0726F        SELECT TOP(1) 'Y',
              ORDER_REASON,
              ORDER_TYPE_CD,
              SERV_ORDER_STATUS                                  
P0726F          INTO :WS-PENDING-SO-FLAG                                
P0726F              ,:VO-ORDER-REASON                                   
P0726F              ,:VO-ORDER-TYPE-CD                                  
P0726F              ,:VO-SERV-ORDER-STATUS                              
P0726F          FROM CSS_SO_DATA WITH(READUNCOMMITTED)                          
P0726F         WHERE ACCOUNT_NO_PRIOR = :VO-ACCOUNT-NO                  
P0726F           AND ORDER_STATE_CD IN ('A', 'H', 'B', 'D','R')         
P0726F           AND ORDER_TYPE_CD = :VO-ORDER-TYPE-CD                  
P0726F                                    
P0726F                                                      
P0726F     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*             ,ORDER_REASON                                               
MFA-TR*             ,ORDER_TYPE_CD                                              
MFA-TR*             ,SERV_ORDER_STATUS                                          
MFA-TR*         INTO :WS-PENDING-SO-FLAG                                        
MFA-TR*             ,:VO-ORDER-REASON                                           
MFA-TR*             ,:VO-ORDER-TYPE-CD                                          
MFA-TR*             ,:VO-SERV-ORDER-STATUS                                      
MFA-TR*         FROM CSS_SO_DATA                                                
MFA-TR*        WHERE ACCOUNT_NO_PRIOR = :VO-ACCOUNT-NO                          
MFA-TR*          AND ORDER_STATE_CD IN ('A', 'H', 'B', 'D','R')                 
MFA-TR*          AND ORDER_TYPE_CD = :VO-ORDER-TYPE-CD                          
MFA-TR*        FETCH FIRST 1 ROWS ONLY WITH UR                                  
MFA-TR*      QUERYNO 7150                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0726F                                                                  
P0726F     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P0726F     EVALUATE SQLCODE                                             
P0726F        WHEN SUCCESSFUL-CALL                                      
P0726F        WHEN NOT-FOUND                                            
P0726F           CONTINUE                                               
P0726F        WHEN OTHER                                                
P0726F            MOVE 'CSR04628'              TO ABEND-PROGRAM         
P0726F            MOVE '7150'                  TO ACTIVE-PARAGRAPH      
P0726F            MOVE 'SELECT'                TO ABEND-FUNCTION        
P0726F            MOVE 'CSS_SO_DATA'           TO TABLE-1               
P0726F            MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1       
P0726F            MOVE VO-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1     
P0726F            PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT           
P0726F     END-EVALUATE.                                                
P0726F                                                                  
P0726F 7150-EXIT.                                                       
P0726F     EXIT.                                                        
P0726F                                                                  
P0726F***************************************************************           
P0726F* 7160-SELECT-BBP-COMPLIANCE.                         *                   
P0726F***************************************************************           
P0726F                                                                  
P0726F 7160-SELECT-BBP-COMPLIANCE.                                      
P0726F                                                                  
P0726F     EXEC SQL                                                     
P0726F        SELECT TOP(1) BH.CHANGE_REASON,
              BH.REMARKS,
              REPLACE(REPLACE(CONVERT(CHAR(26), BH.BUD_HIST_SEQ_NO
           , 121), ' ', '-'), ':', '.') BUD_HIST_SEQ_NO                        
P0726F          INTO :BH-CHANGE-REASON                                  
P0726F              ,:BH-REMARKS                                        
P0726F              ,:BH-BUD-HIST-SEQ-NO                                
P0726F          FROM CSS_BUDGET_HIST BH WITH(READUNCOMMITTED)                   
P0726F         WHERE BH.ACCOUNT_NO = :BH-ACCOUNT-NO                     
P0726F         ORDER BY BUD_HIST_SEQ_NO DESC                         
P0726F                                            
P0726F                                                           
P0726F                                                      
P0726F     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BH.CHANGE_REASON                                           
MFA-TR*             ,BH.REMARKS                                                 
MFA-TR*             ,BH.BUD_HIST_SEQ_NO                                         
MFA-TR*         INTO :BH-CHANGE-REASON                                          
MFA-TR*             ,:BH-REMARKS                                                
MFA-TR*             ,:BH-BUD-HIST-SEQ-NO                                        
MFA-TR*         FROM CSS_BUDGET_HIST BH                                         
MFA-TR*        WHERE BH.ACCOUNT_NO = :BH-ACCOUNT-NO                             
MFA-TR*        ORDER BY BH.BUD_HIST_SEQ_NO DESC                                 
MFA-TR*        FETCH FIRST 1 ROW ONLY                                           
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7160                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0726F                                                                  
P0726F     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
P0726F                                                                  
P0726F     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
P0726F        CONTINUE                                                  
P0726F     ELSE                                                         
P0726F        MOVE 'CSR04628'                 TO ABEND-PROGRAM          
P0726F        MOVE '7160'                     TO ACTIVE-PARAGRAPH       
P0726F        MOVE 'SELECT'                   TO ABEND-FUNCTION         
P0726F        MOVE 'CSS_BUDGET_HIST'          TO TABLE-1                
P0726F        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
P0726F        MOVE BH-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
P0726F        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
P0726F     END-IF.                                                      
P0726F                                                                  
P0726F 7160-EXIT.                                                       
P0726F     EXIT.                                                        
P0726F                                                                  
P0726F******************************************************************        
P0726F* 7170-SELECT-DPP-COMPLIANCE.                                    *        
P0726F******************************************************************        
P0726F                                                                  
P0726F 7170-SELECT-DPP-COMPLIANCE.                                      
P0726F                                                                  
P0726F     EXEC SQL                                                     
P0726F        SELECT TOP(1) DA.CODE_DFA_STATUS,
              DA.REVERSE_REASON,
              CIS.DAYS(CAST(SYSDATETIMEOFFSET() AS DATE)) - CIS.DAYS(
           DA.DATE_OF_AGREE),
              REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS, 121), 
           ' ', '-'), ':', '.') LAST_UPDATE_TS                                 
P0726F          INTO :DA-CODE-DFA-STATUS                                
P0726F              ,:DA-REVERSE-REASON                                 
P0726F              ,:WS-RECENT-DPP-DAYS                                
P0726F              ,:DA-LAST-UPDATE-TS                                 
P0726F          FROM CSS_DFA_ACCT DA WITH(READUNCOMMITTED)                      
P0726F         WHERE DA.ACCOUNT_NO    = :DA-ACCOUNT-NO                  
P0726F           AND DA.CODE_DFA_TYPE = 'B'                             
P0726F         ORDER BY DA.DATE_OF_AGREE DESC                           
P0726F                                            
P0726F                                                           
P0726F                                                      
P0726F     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DA.CODE_DFA_STATUS                                         
MFA-TR*             ,DA.REVERSE_REASON                                          
MFA-TR*             ,DAYS(CURRENT DATE) - DAYS(DA.DATE_OF_AGREE)                
MFA-TR*             ,LAST_UPDATE_TS                                             
MFA-TR*         INTO :DA-CODE-DFA-STATUS                                        
MFA-TR*             ,:DA-REVERSE-REASON                                         
MFA-TR*             ,:WS-RECENT-DPP-DAYS                                        
MFA-TR*             ,:DA-LAST-UPDATE-TS                                         
MFA-TR*         FROM CSS_DFA_ACCT DA                                            
MFA-TR*        WHERE DA.ACCOUNT_NO    = :DA-ACCOUNT-NO                          
MFA-TR*          AND DA.CODE_DFA_TYPE = 'B'                                     
MFA-TR*        ORDER BY DA.DATE_OF_AGREE DESC                                   
MFA-TR*        FETCH FIRST 1 ROW ONLY                                           
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7170                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0726F                                                                  
P0726F     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
P0726F     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P0726F     OR NOT-FOUND                                                 
P0726F        CONTINUE                                                  
P0726F     ELSE                                                         
P0726F         MOVE 'CSR04628'                 TO ABEND-PROGRAM         
P0726F         MOVE '7170'                     TO ACTIVE-PARAGRAPH      
P0726F         MOVE 'SELECT'                   TO ABEND-FUNCTION        
P0726F         MOVE 'CSS_DFA_ACCOUNT'          TO TABLE-1               
P0726F         MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1       
P0726F         MOVE DA-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1     
P0726F         PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
P0726F     END-IF.                                                      
P0726F                                                                  
P0726F 7170-EXIT.                                                       
P0726F     EXIT.                                                        
P0726F                                                                  
P0726F*****************************************************************         
P0726F* 7190-SEL-CRED-FORECAST.                                                 
P0726F*****************************************************************         
P0726F                                                                  
P0726F 7190-SEL-CRED-FORECAST.                                          
P0726F                                                                  
P0726F     EXEC SQL                                                     
P0726F         SELECT TOP(1) COALESCE(CM.DNP_DT,IIF(TRY_CONVERT(DATE, 
              '0001-01-01') IS NULL OR (PATINDEX('%.%', '0001-01-01'
              ) <> 0) OR (LEN('0001-01-01') <> 10), CIS.CHAR2DATE(
              '0001-01-01'), CONVERT(DATE, '0001-01-01') ))                    
P0726F           INTO :CM-DNP-DT                                        
P0726F           FROM CSS_CRED_FORECAST CM WITH(READUNCOMMITTED)                
P0726F          WHERE CM.REVENUE_MONTH    = :CM-REVENUE-MONTH           
P0726F            AND CM.BILL_CYCLE       = :CM-BILL-CYCLE              
P0726F            AND CM.CRED_FORECAST_CD = 'A'                         
P0726F            AND CM.COMPANY_NO       = :CM-COMPANY-NO              
P0726F          ORDER BY CM.BILL_DT                                     
P0726F                                            
P0726F                                                           
P0726F                                                      
P0726F     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT IFNULL(CM.DNP_DT,'0001-01-01')                            
MFA-TR*          INTO :CM-DNP-DT                                                
MFA-TR*          FROM CSS_CRED_FORECAST CM                                      
MFA-TR*         WHERE CM.REVENUE_MONTH    = :CM-REVENUE-MONTH                   
MFA-TR*           AND CM.BILL_CYCLE       = :CM-BILL-CYCLE                      
MFA-TR*           AND CM.CRED_FORECAST_CD = 'A'                                 
MFA-TR*           AND CM.COMPANY_NO       = :CM-COMPANY-NO                      
MFA-TR*         ORDER BY CM.BILL_DT                                             
MFA-TR*         FETCH FIRST 1 ROW ONLY                                          
MFA-TR*          WITH UR                                                        
MFA-TR*        QUERYNO 7190                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0726F                                                                  
P0726F     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
P0726F                                                                  
P0726F     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P0726F        CONTINUE                                                  
P0726F     ELSE                                                         
P0726F        MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
P0726F        MOVE '7190'                 TO ACTIVE-PARAGRAPH           
P0726F        MOVE 'SELECT'               TO ABEND-FUNCTION             
P0726F        MOVE SPACES                 TO ABEND-SQL-PREDICATES       
P0726F                                       ABEND-TABLES               
P0726F        MOVE 'CSS_CRED_FORECAST'    TO TABLE-1                    
P0726F        MOVE 'REVENUE_MONTH'        TO TABLE-ELEMENT-1            
P0726F        MOVE CM-REVENUE-MONTH       TO HOSTVAR-ELEMENT-1          
P0726F        MOVE 'BILL_CYCLE'           TO TABLE-ELEMENT-2            
P0726F        MOVE CM-BILL-CYCLE          TO HOSTVAR-ELEMENT-2          
P0726F        MOVE 'COMPANY_NO'           TO TABLE-ELEMENT-3            
P0726F        MOVE CM-COMPANY-NO          TO HOSTVAR-ELEMENT-3          
P0726F        PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT                
P0726F     END-IF.                                                      
P0726F                                                                  
P0726F 7190-EXIT.                                                       
P0726F     EXIT.                                                        
P0726F*                                                                         
P0726F******************************************************************        
P0726F*7200-SELECT-FINAL-WO                                            *05330000
P0726F******************************************************************05330000
P0726F                                                                  
P0726F 7200-SELECT-FINAL-WO.                                            
P0726F                                                                  
P0726F     EXEC SQL                                                     
P0726F        SELECT A.GUARANTEED_IND                                   
P0726F          INTO :FW-GUARANTEED-IND                                 
P0726F          FROM CSS_FINAL_WO A WITH(READUNCOMMITTED)                       
P0726F         WHERE ACCOUNT_NO = :FW-ACCOUNT-NO                        
P0726F                                                           
P0726F                                                      
P0726F                                                                  
P0726F     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT A.GUARANTEED_IND                                           
MFA-TR*         INTO :FW-GUARANTEED-IND                                         
MFA-TR*         FROM CSS_FINAL_WO A                                             
MFA-TR*        WHERE ACCOUNT_NO = :FW-ACCOUNT-NO                                
MFA-TR*         WITH UR                                                         
MFA-TR*       QUERYNO 7200                                                      
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0726F                                                                  
P0726F     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
P0726F                                                                  
P0726F     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
P0726F        CONTINUE                                                  
P0726F     ELSE                                                         
P0726F        MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
P0726F        MOVE '7200'                   TO ACTIVE-PARAGRAPH         
P0726F        MOVE 'SELECT'                 TO ABEND-FUNCTION           
P0726F        MOVE 'CSS_FINAL_WO'           TO TABLE-1                  
P0726F        MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
P0726F        MOVE FW-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
P0726F        PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
P0726F     END-IF.                                                      
P0726F                                                                  
P0726F 7200-EXIT.                                                       
P0726F     EXIT.                                                        
P0726F                                                                  
P0726F******************************************************************        
P0726F* 7210-SELECT-DEP-ON-HAND                                        *        
P0726F******************************************************************        
P0726F                                                                  
P0726F 7210-SELECT-DEP-ON-HAND.                                         
P0726F                                                                  
P0726F     EXEC SQL                                                     
P0726F        SELECT TOP(1) 'Y'                                                
P0726F          INTO :WS-UNPAID-DEPOSIT                                 
P0726F          FROM  CSS_DEP_ON_HAND WITH(READUNCOMMITTED)                     
P0726F         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
P0726F           AND DEPOSIT_STATUS_CD = 'A'                            
P0726F                                     
P0726F     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-UNPAID-DEPOSIT                                         
MFA-TR*         FROM  CSS_DEP_ON_HAND                                           
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*          AND DEPOSIT_STATUS_CD = 'A'                                    
MFA-TR*        FETCH FIRST 1 ROW ONLY WITH UR                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0726F                                                                  
P0726F     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P0726F     EVALUATE WS-ACTIVE-RETURN-CODE                               
P0726F     WHEN SUCCESSFUL-CALL                                         
P0726F     WHEN NOT-FOUND                                               
P0726F         CONTINUE                                                 
P0726F     WHEN OTHER                                                   
P0726F        MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
P0726F        MOVE '7210'                 TO ACTIVE-PARAGRAPH           
P0726F        MOVE 'SELECT'               TO ABEND-FUNCTION             
P0726F        MOVE 'CSS_DEP_ON_HAND'      TO TABLE-1                    
P0726F        MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
P0726F        MOVE AT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
P0726F        PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT                
P0726F     END-EVALUATE.                                                
P0726F                                                                  
P0726F 7210-EXIT.                                                       
P0726F     EXIT.                                                        
P0726F                                                                  
P0726F******************************************************************        
P0726F* 7220-CHK-AR-TRAN-HIST.                                         *        
P0726F******************************************************************        
P0726F                                                                  
P0726F 7220-CHK-AR-TRAN-HIST.                                           
P0726F                                                                  
P0726F     EXEC SQL                                                     
P0726F        SELECT TOP(1) 'Y'                                                
P0726F          INTO :WS-60-DAY-AR-IND                                  
P0726F          FROM CSS_AR_TRANS_HIST  AR WITH(READUNCOMMITTED)                
P0726F         WHERE AR.ACCOUNT_NO      = :AR-ACCOUNT-NO                
P0726F           AND AR.CODE_TRAN_TYPE  = 'T'                           
P0726F           AND AR.DATE_TRANS   BETWEEN DATEADD( DAY, -60, 
           CAST(SYSDATETIMEOFFSET() AS DATE) )     
P0726F                               AND  CAST(SYSDATETIMEOFFSET() 
           AS DATE)                  
P0726F           AND AR.TRAN_COMMENT LIKE('TRANSFER F%')                
P0726F                                       
P0726F                                                      
P0726F     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-60-DAY-AR-IND                                          
MFA-TR*         FROM CSS_AR_TRANS_HIST  AR                                      
MFA-TR*        WHERE AR.ACCOUNT_NO      = :AR-ACCOUNT-NO                        
MFA-TR*          AND AR.CODE_TRAN_TYPE  = 'T'                                   
MFA-TR*          AND AR.DATE_TRANS   BETWEEN CURRENT DATE - 60 DAYS             
MFA-TR*                              AND  CURRENT DATE                          
MFA-TR*          AND AR.TRAN_COMMENT LIKE('TRANSFER F%')                        
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7220                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0726F                                                                  
P0726F     MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
P0726F     EVALUATE WS-ACTIVE-RETURN-CODE                               
P0726F     WHEN SUCCESSFUL-CALL                                         
P0726F          CONTINUE                                                
P0726F     WHEN NOT-FOUND                                               
P0726F          MOVE 'N'                TO WS-60-DAY-AR-IND             
P0726F     WHEN OTHER                                                   
P0726F        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
P0726F        MOVE '7220'               TO ACTIVE-PARAGRAPH             
P0726F        MOVE 'SELECT'             TO ABEND-FUNCTION               
P0726F        MOVE 'CSS_AR_TRANS_HIST'  TO TABLE-1                      
P0726F        MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
P0726F        MOVE  AR-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1            
P0726F        PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT                
P0726F     END-EVALUATE.                                                
P0726F                                                                  
P0726F 7220-EXIT.                                                       
P0726F     EXIT.                                                        
P0726F                                                                  
P0726F***************************************************************           
P0726F* 7230-SELECT-MED-CERT.                                       *           
P0726F***************************************************************           
P0726F                                                                  
P0726F 7230-SELECT-MED-CERT.                                            
P0726F                                                                  
P0726F     EXEC SQL                                                     
P0726F        SELECT TOP(1) COALESCE(DATE_ALERT ,IIF(TRY_CONVERT(DATE, 
              '1900-01-01') IS NULL OR (PATINDEX('%.%', '1900-01-01'
              ) <> 0) OR (LEN('1900-01-01') <> 10), CIS.CHAR2DATE(
              '1900-01-01'), CONVERT(DATE, '1900-01-01') )),
              COALESCE(DATE_EXPIRE,IIF(TRY_CONVERT(DATE, '1900-01-01'
              ) IS NULL OR (PATINDEX('%.%', '1900-01-01'
              ) <> 0) OR (LEN('1900-01-01') <> 10), CIS.CHAR2DATE(
              '1900-01-01'), CONVERT(DATE, '1900-01-01') )),
              CAST(SYSDATETIMEOFFSET() AS DATE)                                 
P0726F          INTO :CA-DATE-ALERT                                     
P0726F              ,:CA-DATE-EXPIRE                                    
P0726F              ,:WS-CURRENT-DT                                     
P0726F          FROM  CSS_CUST_ALERT WITH(READUNCOMMITTED)                      
P0726F         WHERE ACCOUNT_NO        =:CA-ACCOUNT-NO                  
P0726F         ORDER BY DATE_ALERT DESC                                 
P0726F                                     
P0726F                                                      
P0726F     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT IFNULL(DATE_ALERT ,'1900-01-01')                           
MFA-TR*             ,IFNULL(DATE_EXPIRE,'1900-01-01')                           
MFA-TR*             ,CURRENT DATE                                               
MFA-TR*         INTO :CA-DATE-ALERT                                             
MFA-TR*             ,:CA-DATE-EXPIRE                                            
MFA-TR*             ,:WS-CURRENT-DT                                             
MFA-TR*         FROM  CSS_CUST_ALERT                                            
MFA-TR*        WHERE ACCOUNT_NO        =:CA-ACCOUNT-NO                          
MFA-TR*        ORDER BY DATE_ALERT DESC                                         
MFA-TR*        FETCH FIRST 1 ROW ONLY WITH UR                                   
MFA-TR*      QUERYNO 7230                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0726F                                                                  
P0726F     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
P0726F                                                                  
P0726F     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P0726F        OR NOT-FOUND                                              
P0726F        IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
P0726F           EXEC SQL                                               
P0726F              SELECT
              CIS.DAYS( IIF(TRY_CONVERT(DATE, :WS-CURRENT-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DT
              ) <> 0) OR (LEN(:WS-CURRENT-DT) <> 10), CIS.CHAR2DATE(
                                                         :WS-CURRENT-DT
              ), CONVERT(DATE, :WS-CURRENT-DT) ) ) - CIS.DAYS( 
              IIF(TRY_CONVERT(DATE, :CA-DATE-EXPIRE
              ) IS NULL OR (PATINDEX('%.%', :CA-DATE-EXPIRE
              ) <> 0) OR (LEN(:CA-DATE-EXPIRE) <> 10), CIS.CHAR2DATE(
                                                        :CA-DATE-EXPIRE
              ), CONVERT(DATE, :CA-DATE-EXPIRE) ) )
            INTO
              :WS-DAYS-EXPIRE    
P0726F           END-EXEC

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*          EXEC SQL                                                       
MFA-TR*             SET :WS-DAYS-EXPIRE =                                       
MFA-TR*                 DAYS(:WS-CURRENT-DT) - DAYS(:CA-DATE-EXPIRE)            
MFA-TR*          END-EXEC                                                       
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                               
P0726F        ELSE                                                      
P0726F           MOVE 0                        TO WS-DAYS-EXPIRE        
P0726F        END-IF                                                    
P0726F     ELSE                                                         
P0726F         MOVE 'CSR04628'                 TO ABEND-PROGRAM         
P0726F         MOVE '7230'                     TO ACTIVE-PARAGRAPH      
P0726F         MOVE 'SELECT'                   TO ABEND-FUNCTION        
P0726F         MOVE 'CSS_CUST_ALERT'           TO TABLE-1               
P0726F         MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1       
P0726F         MOVE CA-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1     
P0726F         PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT               
P0726F     END-IF.                                                      
P0726F                                                                  
P0726F 7230-EXIT.                                                       
P0726F     EXIT.                                                        
P0726F                                                                  
P0726F******************************************************************        
P0726F* 7240-GET-NUMBER-OF-MONTHS                                      *        
P0726F******************************************************************        
P0726F                                                                  
P0726F 7240-GET-NUMBER-OF-MONTHS.                                       
P0726F                                                                  
P0726F     EXEC SQL                                                     
P0726F        SELECT
              CIS.DAYS(IIF(TRY_CONVERT(DATE, :WS-DATE-2
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-2) <> 0) OR (LEN(
                                                             :WS-DATE-2
              ) <> 10), CIS.CHAR2DATE(:WS-DATE-2), CONVERT(DATE, 
                                                             :WS-DATE-2
              ) )) - CIS.DAYS(IIF(TRY_CONVERT(DATE, :WS-DATE-1
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-1) <> 0) OR (LEN(
                                                             :WS-DATE-1
              ) <> 10), CIS.CHAR2DATE(:WS-DATE-1), CONVERT(DATE, 
                                                             :WS-DATE-1
              ) ))
            INTO
              :WS-MONTHS-TO-EVALUATE      
P0726F     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-MONTHS-TO-EVALUATE =                                      
MFA-TR*          (DAYS(DATE(:WS-DATE-2)) - DAYS(DATE(:WS-DATE-1)))              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0726F                                                                  
P0726F     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
P0726F                                                                  
P0726F     IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
P0726F         MOVE 'CSR04628'                 TO ABEND-PROGRAM         
P0726F         MOVE '7240'                     TO ACTIVE-PARAGRAPH      
P0726F         MOVE 'SET'                      TO ABEND-FUNCTION        
P0726F         PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
P0726F     END-IF.                                                      
P0726F                                                                  
P0726F 7240-EXIT.                                                       
P0726F     EXIT.                                                        
P0726F                                                                  
P0726F*****************************************************************         
P0726F* 7250-SELECT-FW-ACTION-DT                                                
P0726F*****************************************************************         
P0726F                                                                  
P0726F 7250-SELECT-FW-ACTION-DT.                                        
P0726F                                                                  
P0726F     EXEC SQL                                                     
P0726F         SELECT TOP(1) COALESCE(KD.FW_ACTION_DT,
              IIF(TRY_CONVERT(DATE, '0001-01-01'
              ) IS NULL OR (PATINDEX('%.%', '0001-01-01'
              ) <> 0) OR (LEN('0001-01-01') <> 10), CIS.CHAR2DATE(
              '0001-01-01'), CONVERT(DATE, '0001-01-01') ))              
P0726F           INTO :KD-FW-ACTION-DT                                  
P0726F           FROM CSS_FIN_WO_ACTION KD WITH(READUNCOMMITTED)                
P0726F          WHERE KD.ACCOUNT_NO       = :KD-ACCOUNT-NO              
P0726F            AND FW_ACTION_TYPE_CD   = :KD-FW-ACTION-TYPE-CD       
P0726F          ORDER BY KD.FW_SEQ_NO DESC                              
P0726F                                            
P0726F                                                           
P0726F                                                      
P0726F     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT IFNULL(KD.FW_ACTION_DT,'0001-01-01')                      
MFA-TR*          INTO :KD-FW-ACTION-DT                                          
MFA-TR*          FROM CSS_FIN_WO_ACTION KD                                      
MFA-TR*         WHERE KD.ACCOUNT_NO       = :KD-ACCOUNT-NO                      
MFA-TR*           AND FW_ACTION_TYPE_CD   = :KD-FW-ACTION-TYPE-CD               
MFA-TR*         ORDER BY KD.FW_SEQ_NO DESC                                      
MFA-TR*         FETCH FIRST 1 ROW ONLY                                          
MFA-TR*          WITH UR                                                        
MFA-TR*        QUERYNO 7250                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0726F                                                                  
P0726F     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
P0726F                                                                  
P0726F     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P0726F        CONTINUE                                                  
P0726F     ELSE                                                         
P0726F        MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
P0726F        MOVE '7250'                 TO ACTIVE-PARAGRAPH           
P0726F        MOVE 'SELECT'               TO ABEND-FUNCTION             
P0726F        MOVE SPACES                 TO ABEND-SQL-PREDICATES       
P0726F                                       ABEND-TABLES               
P0726F        MOVE 'CSS_FIN_WO_ACTION'    TO TABLE-1                    
P0726F        MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
P0726F        MOVE KD-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
P0726F        MOVE 'FW_ACTION_TYPE_CD'    TO TABLE-ELEMENT-2            
P0726F        MOVE KD-FW-ACTION-TYPE-CD   TO HOSTVAR-ELEMENT-2          
P0726F                                                                  
P0726F        PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT                
P0726F     END-IF.                                                      
P0726F                                                                  
P0726F 7250-EXIT.                                                       
P0726F     EXIT.                                                        
P0726F                                                                  
P0726F******************************************************************        
P0726F* 7260-GET-FORCST-DT-SO                                                   
P0726F******************************************************************        
P0726F                                                                  
P0726F 7260-GET-FORCST-DT-SO.                                           
P0726F                                                                  
P0726F     EXEC SQL                                                     
P0726F         SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           VO.WANTED_BY_DATETIME, 121), ' ', '-'), ':', '.') 
           WANTED_BY_DATETIME                             
P0726F           INTO :VO-WANTED-BY-DATETIME                            
P0726F           FROM CSS_SO_DATA VO WITH(READUNCOMMITTED)                      
P0726F          WHERE VO.ACCOUNT_NO_PRIOR     = :VO-ACCOUNT-NO          
P0726F            AND VO.ORDER_STATE_CD       = 'A'                     
P0726F            AND VO.SERV_ORDER_STATUS    < '60'                    
P0726F            AND VO.ORDER_TYPE_CD        = 'DNP01'                 
P0726F                                            
P0726F                                                           
P0726F                                                      
P0726F     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT VO.WANTED_BY_DATETIME                                     
MFA-TR*          INTO :VO-WANTED-BY-DATETIME                                    
MFA-TR*          FROM CSS_SO_DATA VO                                            
MFA-TR*         WHERE VO.ACCOUNT_NO_PRIOR     = :VO-ACCOUNT-NO                  
MFA-TR*           AND VO.ORDER_STATE_CD       = 'A'                             
MFA-TR*           AND VO.SERV_ORDER_STATUS    < '60'                            
MFA-TR*           AND VO.ORDER_TYPE_CD        = 'DNP01'                         
MFA-TR*         FETCH FIRST 1 ROW ONLY                                          
MFA-TR*          WITH UR                                                        
MFA-TR*        QUERYNO 7260                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0726F                                                                  
P0726F     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
P0726F                                                                  
P0726F     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P0726F        CONTINUE                                                  
P0726F     ELSE                                                         
P0726F        MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
P0726F        MOVE '7260'                 TO ACTIVE-PARAGRAPH           
P0726F        MOVE 'SELECT'               TO ABEND-FUNCTION             
P0726F        MOVE SPACES                 TO ABEND-SQL-PREDICATES       
P0726F                                       ABEND-TABLES               
P0726F        MOVE 'CSS_SO_DATA'          TO TABLE-1                    
P0726F        MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
P0726F        MOVE VO-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
P0726F        PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT                
P0726F     END-IF.                                                      
P0726F*                                                                         
P0726F 7260-EXIT.                                                       
P0726F     EXIT.                                                        
P0726F*                                                                         
P0726F******************************************************************05330000
P0726F* 7270-SEL-ACTIVE-ARNG-TYPE                                      *05620000
P0726F******************************************************************        
P0726F                                                                  
P0726F 7270-SEL-ACTIVE-ARNG-TYPE.                                       
P0726F                                                                  
P0726F     EXEC SQL                                                     
P0726F        SELECT X1.ARNG_TYPE                                       
P00948              ,X1.ARNG_ID                                         
P00948              ,X1.CRED_ARNG_SEQ                                   
P0726F          INTO :WS-ACTIVE-ARNG-TYPE                               
P00948              ,:X1-ARNG-ID                                        
P00948              ,:X1-CRED-ARNG-SEQ                                  
P0726F          FROM CSS_CRED_ARNGMENT X1 WITH(READUNCOMMITTED)                 
P0726F         WHERE X1.ACCOUNT_NO     = :X1-ACCOUNT-NO                 
P0726F           AND X1.ARNG_STATUS_CD = 'A'                            
P0726F                                                           
P0726F                                                      
P0726F     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT X1.ARNG_TYPE                                               
MFA-TR*             ,X1.ARNG_ID                                                 
MFA-TR*             ,X1.CRED_ARNG_SEQ                                           
MFA-TR*         INTO :WS-ACTIVE-ARNG-TYPE                                       
MFA-TR*             ,:X1-ARNG-ID                                                
MFA-TR*             ,:X1-CRED-ARNG-SEQ                                          
MFA-TR*         FROM CSS_CRED_ARNGMENT X1                                       
MFA-TR*        WHERE X1.ACCOUNT_NO     = :X1-ACCOUNT-NO                         
MFA-TR*          AND X1.ARNG_STATUS_CD = 'A'                                    
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7270                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0726F                                                                  
P0726F     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
P0726F                                                                  
P0726F     EVALUATE WS-ACTIVE-RETURN-CODE                               
P0726F         WHEN SUCCESSFUL-CALL                                     
P0726F              CONTINUE                                            
P0726F         WHEN NOT-FOUND                                           
P0726F              MOVE ZEROES              TO WS-ACTIVE-RETURN-CODE   
P0726F              MOVE SPACES              TO WS-ACTIVE-ARNG-TYPE     
P0726F         WHEN OTHER                                               
P0726F              MOVE PROGRAM-NAME        TO ABEND-PROGRAM           
P0726F              MOVE '7270'              TO ACTIVE-PARAGRAPH        
P0726F              MOVE 'SELECT'            TO ABEND-FUNCTION          
P0726F              MOVE 'CSS_CRED_ARNGMENT' TO TABLE-1                 
P0726F              MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1         
P0726F              MOVE X1-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1       
P0726F              PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
P0726F     END-EVALUATE.                                                
P0726F                                                                  
P0726F 7270-EXIT.                                                       
P0726F     EXIT.                                                        
P0726F                                                                  
P0726F*****************************************************************         
P0726F* 7280-SEL-LAST-ARNG-DT-CMPLNCE                                 *         
P0726F*****************************************************************         
P0726F 7280-SEL-LAST-ARNG-DT-CMPLNCE.                                   
P0726F                                                                  
P0726F     EXEC SQL                                                     
P0726F        SELECT TOP(1) (CIS.DAYS(CAST(SYSDATETIMEOFFSET() 
           AS DATE)) -                              
P0726F                CIS.DAYS(X1.ARNG_SETUP_DT)),
              ARNG_COMPLIANCE_CD                                 
P0726F          INTO :WS-LAST-ARNG-DAYS                                 
P0726F              ,:X1-ARNG-COMPLIANCE-CD                             
P0726F          FROM CSS_CRED_ARNGMENT X1 WITH(READUNCOMMITTED)                 
P0726F         WHERE X1.ACCOUNT_NO     = :X1-ACCOUNT-NO                 
P00948           AND X1.ARNG_TYPE      IN ('STA','STF')                 
P0726F           AND X1.ARNG_STATUS_CD ='C'                             
P0726F         ORDER BY X1.ARNG_SETUP_DT DESC                           
P0726F                                              
P0726F                                                           
P0726F                                                      
P0726F     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT (DAYS(CURRENT DATE) -                                      
MFA-TR*               DAYS(DATE(X1.ARNG_SETUP_DT)))                             
MFA-TR*             ,ARNG_COMPLIANCE_CD                                         
MFA-TR*         INTO :WS-LAST-ARNG-DAYS                                         
MFA-TR*             ,:X1-ARNG-COMPLIANCE-CD                                     
MFA-TR*         FROM CSS_CRED_ARNGMENT X1                                       
MFA-TR*        WHERE X1.ACCOUNT_NO     = :X1-ACCOUNT-NO                         
MFA-TR*          AND X1.ARNG_TYPE      IN ('STA','STF')                         
MFA-TR*          AND X1.ARNG_STATUS_CD ='C'                                     
MFA-TR*        ORDER BY X1.ARNG_SETUP_DT DESC                                   
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7280                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0726F                                                                  
P0726F     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
P0726F                                                                  
P0726F     EVALUATE WS-ACTIVE-RETURN-CODE                               
P0726F         WHEN SUCCESSFUL-CALL                                     
P0726F              CONTINUE                                            
P0726F         WHEN NOT-FOUND                                           
P0726F              MOVE ZEROES              TO WS-ACTIVE-RETURN-CODE   
P0726F         WHEN OTHER                                               
P0726F              MOVE PROGRAM-NAME        TO ABEND-PROGRAM           
P0726F              MOVE '7280'              TO ACTIVE-PARAGRAPH        
P0726F              MOVE 'SELECT'            TO ABEND-FUNCTION          
P0726F              MOVE 'CSS_CRED_ARNGMENT' TO TABLE-1                 
P0726F              MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1         
P0726F              MOVE X1-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1       
P0726F              PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
P0726F     END-EVALUATE.                                                
P0726F                                                                  
P0726F 7280-EXIT.                                                       
P0726F     EXIT.                                                        
P0726F                                                                  
P00948*                                                                         
P00948******************************************************************        
P00948* 7290-SEL-PROCESSED-FL                                                   
P00948******************************************************************        
P00948*                                                                         
P00948 7290-SEL-PROCESSED-FL.                                           
P00948*                                                                         
P00948     EXEC SQL                                                     
P00948        SELECT TOP(1) 'N'                                                
P00948          INTO :WS-STAA-PROCESSED-FL                              
P00948          FROM CSS_CRED_ARNG_ACTN WITH(READUNCOMMITTED)                   
P00948         WHERE ACCOUNT_NO        = :4W-ACCOUNT-NO                 
P00948           AND ARNG_ID           = :4W-ARNG-ID                    
P00948           AND CRED_ARNG_SEQ     = :4W-CRED-ARNG-SEQ              
P00948           AND PROCESSED_FL     <> 'Y'                            
P0726F                                              
P0726F                                                           
P0726F                                                      
P00948     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'N'                                                        
MFA-TR*         INTO :WS-STAA-PROCESSED-FL                                      
MFA-TR*         FROM CSS_CRED_ARNG_ACTN                                         
MFA-TR*        WHERE ACCOUNT_NO        = :4W-ACCOUNT-NO                         
MFA-TR*          AND ARNG_ID           = :4W-ARNG-ID                            
MFA-TR*          AND CRED_ARNG_SEQ     = :4W-CRED-ARNG-SEQ                      
MFA-TR*          AND PROCESSED_FL     <> 'Y'                                    
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7290                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00948*                                                                         
P00948     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00948*                                                                         
P00948     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00948         WHEN SUCCESSFUL-CALL                                     
P00948              CONTINUE                                            
P00948         WHEN NOT-FOUND                                           
P00948              MOVE 'Y'                    TO WS-STAA-PROCESSED-FL 
P00948              MOVE ZEROES                 TO WS-ACTIVE-RETURN-CODE
P00948         WHEN OTHER                                               
P00948              MOVE PROGRAM-NAME           TO ABEND-PROGRAM        
P00948              MOVE '7290'                 TO ACTIVE-PARAGRAPH     
P00948              MOVE 'SELECT'               TO ABEND-FUNCTION       
P00948              MOVE 'CSS_CRED_ARNG_ACTN'   TO TABLE-1              
P00948              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1      
P00948              MOVE 4W-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1    
P00948              MOVE 'ARNG_ID'              TO TABLE-ELEMENT-2      
P00948              MOVE 4W-ARNG-ID             TO HOSTVAR-ELEMENT-2    
P00948              MOVE 'CRED_ARNG_SEQ'        TO TABLE-ELEMENT-3      
P00948              MOVE 4W-CRED-ARNG-SEQ       TO HOSTVAR-ELEMENT-3    
P00948              PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
P00948     END-EVALUATE.                                                
P00948*                                                                         
P00948 7290-EXIT.                                                       
P00948     EXIT.                                                        
P0948A*                                                                         
P0948A******************************************************************        
P0948A* 7300-SEL-CRED-ARNG.                                                     
P0948A******************************************************************        
P0948A*                                                                         
P0948A 7300-SEL-CRED-ARNG.                                              
P0948A*                                                                         
P0948A     EXEC SQL                                                     
P0948A         SELECT TOP(1) 'N'                                               
P0948A           INTO :WS-ARNG-COMPLIED-FL                              
P0948A           FROM CSS_CRED_ARNGMENT X1 WITH(READUNCOMMITTED)                
P0948A          WHERE X1.ACCOUNT_NO         =  :X1-ACCOUNT-NO           
P0948A            AND X1.ARNG_ID            =  :X1-ARNG-ID              
P0948A            AND X1.CRED_ARNG_SEQ      =                           
P0948A                (SELECT MAX(A.CRED_ARNG_SEQ)                      
P0948A                   FROM CSS_CRED_ARNGMENT A WITH(READUNCOMMITTED)         
P0948A                  WHERE A.ACCOUNT_NO  =  :X1-ACCOUNT-NO           
P0948A                    AND A.ARNG_ID     =  :X1-ARNG-ID)             
P0948A            AND X1.ARNG_COMPLIANCE_CD =  :X1-ARNG-COMPLIANCE-CD   
P0948A            AND X1.ARNG_STATUS_CD     =  :X1-ARNG-STATUS-CD       
P0948A            AND X1.LAST_UPDATE_TS     >= CIS.CHAR2TIMESTAMP(
                                                     :X1-LAST-UPDATE-TS
              )       
P0948A                                           
P0948A                                                           
P0948A                                                      
P0948A     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'N'                                                       
MFA-TR*          INTO :WS-ARNG-COMPLIED-FL                                      
MFA-TR*          FROM CSS_CRED_ARNGMENT X1                                      
MFA-TR*         WHERE X1.ACCOUNT_NO         =  :X1-ACCOUNT-NO                   
MFA-TR*           AND X1.ARNG_ID            =  :X1-ARNG-ID                      
MFA-TR*           AND X1.CRED_ARNG_SEQ      =                                   
MFA-TR*               (SELECT MAX(A.CRED_ARNG_SEQ)                              
MFA-TR*                  FROM CSS_CRED_ARNGMENT A                               
MFA-TR*                 WHERE A.ACCOUNT_NO  =  :X1-ACCOUNT-NO                   
MFA-TR*                   AND A.ARNG_ID     =  :X1-ARNG-ID)                     
MFA-TR*           AND X1.ARNG_COMPLIANCE_CD =  :X1-ARNG-COMPLIANCE-CD           
MFA-TR*           AND X1.ARNG_STATUS_CD     =  :X1-ARNG-STATUS-CD               
MFA-TR*           AND X1.LAST_UPDATE_TS     >= :X1-LAST-UPDATE-TS               
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7300                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0948A*                                                                         
P0948A     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
P0948A*                                                                         
P0948A     EVALUATE WS-ACTIVE-RETURN-CODE                               
P0948A         WHEN SUCCESSFUL-CALL                                     
P0948A              CONTINUE                                            
P0948A         WHEN NOT-FOUND                                           
P0948A              MOVE ZEROES                TO WS-ACTIVE-RETURN-CODE 
P0948A         WHEN OTHER                                               
P0948A              MOVE PROGRAM-NAME          TO ABEND-PROGRAM         
P0948A              MOVE '7300'                TO ACTIVE-PARAGRAPH      
P0948A              MOVE 'SELECT'              TO ABEND-FUNCTION        
P0948A              MOVE 'CSS_CRED_ARNG_HIST'  TO TABLE-1               
P0948A              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1       
P0948A              MOVE X1-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1     
P0948A              MOVE 'ARNG_ID'             TO TABLE-ELEMENT-2       
P0948A              MOVE X1-ARNG-ID            TO HOSTVAR-ELEMENT-2     
P0948A              MOVE 'ARNG_COMPLIANCE_CD'  TO TABLE-ELEMENT-3       
P0948A              MOVE X1-ARNG-COMPLIANCE-CD TO HOSTVAR-ELEMENT-3     
P0948A              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
P0948A     END-EVALUATE.                                                
P0948A*                                                                         
P0948A 7300-EXIT.                                                       
P0948A     EXIT.                                                        
P0948A*                                                                         
      ******************************************************************        
      * 7500-OPEN-ARNG-DTLS-CURSOR                                              
      ******************************************************************        
                                                                        
       7500-OPEN-ARNG-DTLS-CURSOR.                                      
                                                                        
           EXEC SQL                                                     
              OPEN ARNG_DTLS                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
                    MOVE '7500'               TO ACTIVE-PARAGRAPH       
                    MOVE 'OPEN'               TO ABEND-FUNCTION         
                    MOVE SPACES               TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
                    MOVE 'CSS_ARNG_DEFNITION' TO TABLE-1                
                    MOVE 'CSS_ARNG_PLAN'      TO TABLE-2                
                    MOVE 'CSS_ARNG_OPTION'    TO TABLE-3                
                    PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT         
           END-EVALUATE.                                                
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7510-FETCH-ARNG-DTLS-CURSOR                                             
      ******************************************************************        
                                                                        
       7510-FETCH-ARNG-DTLS-CURSOR.                                     
                                                                        
           EXEC SQL                                                     
               FETCH ARNG_DTLS                                          
                INTO :UJ-ARNG-ID                                        
                    ,:UJ-ARNG-TYPE                                      
                    ,:UJ-ARNG-STATUS-CD                                 
                    ,:UJ-ARNG-DESC                                      
                    ,:UJ-ARNG-BILL-OPTN-CD                              
                    ,:UJ-UTIL-NONUTIL-CD                                
                    ,:UJ-RECVBLE-DEFER-CD                               
                    ,:UJ-ARNG-FREQ-CD                                   
                    ,:UJ-SEASONAL-FL                                    
                    ,:UJ-INSTALLMENT-FL                                 
                    ,:UJ-ARNG-DROP-FL                                   
                    ,:UF-PLAN-TERM-CD                                   
                    ,:UF-PLAN-TERM-MIN                                  
                    ,:UF-PLAN-TERM-MAX                                  
                    ,:UF-PLAN-TERM-MAX-OVRD                             
                    ,:UF-SEASON-START-DDMM :WS-SEASON-START-DDMM-NULL   
                    ,:UF-SEASON-END-DDMM :WS-SEASON-END-DDMM-NULL     
                    ,:UF-PATH-START-CD                                  
                    ,:UF-LPC-ASSESS-CD                                  
                    ,:UF-ARNG-AMOUNT-CD                                 
                    ,:UF-ARNG-PLAN-DESC                                 
                    ,:UF-NSF-ALLOWED-FL                                 
                    ,:UD-ACTN-PATH-TYPE-CD                              
                    ,:UD-TERM-OPTION-SEQ                                
                    ,:UD-ARNG-GRACE-PERIOD                              
                    ,:UD-ARNG-PRIORITY                                  
                    ,:UD-DAY-COUNT-TYPE-CD                              
                    ,:UD-ARNG-CHANNEL-CD                                
                    ,:UF-ARNG-PLAN-ID                                   
                    ,:UD-ARNG-OPTION-ID                                 
P0726E              ,:UD-CREDIT-GROUP-CD                                
P0726E              ,:UD-CRED-ACTN-EXIST-CD                             
P0726E              ,:UD-OPTION-TERM-CD                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-SEASON-START-DDMM-NULL < 0                             
              MOVE ZEROES TO UF-SEASON-START-DDMM                       
                             WS-SEASON-START-DDMM-NULL                  
           END-IF                                                       
                                                                        
           IF WS-SEASON-END-DDMM-NULL < 0                               
              MOVE ZEROES TO UF-SEASON-END-DDMM                         
                             WS-SEASON-END-DDMM-NULL                    
           END-IF                                                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES               TO WS-ACTIVE-RETURN-CODE  
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
                    MOVE '7510'               TO ACTIVE-PARAGRAPH       
                    MOVE 'FETCH'              TO ABEND-FUNCTION         
                    MOVE SPACES               TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
                    MOVE 'CSS_ARNG_DEFNITION' TO TABLE-1                
                    MOVE 'CSS_ARNG_PLAN'      TO TABLE-2                
                    MOVE 'CSS_ARNG_OPTION'    TO TABLE-3                
                    MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-1        
                    MOVE 'REG_GROUP_CD'       TO TABLE-ELEMENT-2        
                    MOVE 'CURRENT_DATE'       TO TABLE-ELEMENT-3        
                    MOVE AT-COMPANY-NO        TO HOSTVAR-ELEMENT-1      
                    MOVE WS-REG-GROUP-CD      TO HOSTVAR-ELEMENT-2      
                    MOVE WS-CURRENT-DATE      TO HOSTVAR-ELEMENT-3      
                    PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT         
           END-EVALUATE.                                                
                                                                        
       7510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7520-CLOSE-ARNG-DTLS-CURSOR                                             
      ******************************************************************        
                                                                        
       7520-CLOSE-ARNG-DTLS-CURSOR.                                     
                                                                        
           EXEC SQL                                                     
               CLOSE ARNG_DTLS                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
                    MOVE '7520'               TO ACTIVE-PARAGRAPH       
                    MOVE 'CLOSE'              TO ABEND-FUNCTION         
                    MOVE SPACES               TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
                    MOVE 'CSS_ARNG_DEFNITION' TO TABLE-1                
                    MOVE 'CSS_ARNG_PLAN'      TO TABLE-2                
                    MOVE 'CSS_ARNG_OPTION'    TO TABLE-3                
                    PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT         
           END-EVALUATE.                                                
                                                                        
       7520-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7530-OPEN-RULE-CURSOR                                                   
      ******************************************************************        
                                                                        
       7530-OPEN-RULE-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
              OPEN RULE_CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
                    MOVE '7530'               TO ACTIVE-PARAGRAPH       
                    MOVE 'OPEN'               TO ABEND-FUNCTION         
                    MOVE SPACES               TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
                    MOVE 'CSS_BUS_RULE_XREF'  TO TABLE-1                
                    PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT         
           END-EVALUATE.                                                
                                                                        
       7530-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7540-FETCH-RULE-CURSOR                                                  
      ******************************************************************        
                                                                        
       7540-FETCH-RULE-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
               FETCH RULE_CURSOR                                        
                INTO :1T-BUS-RULE-ID                                    
                    ,:1T-BUS-RULE-XREF-ID                               
                    ,:1T-COMPANY-NO                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES               TO WS-ACTIVE-RETURN-CODE  
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
                    MOVE '7540'               TO ACTIVE-PARAGRAPH       
                    MOVE 'FETCH'              TO ABEND-FUNCTION         
                    MOVE SPACES               TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
                    MOVE 'CSS_BUS_RULE_XREF'  TO TABLE-1                
                    PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT         
           END-EVALUATE.                                                
                                                                        
       7540-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7550-CLOSE-RULE-CURSOR                                                  
      ******************************************************************        
                                                                        
       7550-CLOSE-RULE-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
               CLOSE RULE_CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
                    MOVE '7550'               TO ACTIVE-PARAGRAPH       
                    MOVE 'CLOSE'              TO ABEND-FUNCTION         
                    MOVE SPACES               TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
                    MOVE 'CSS_BUS_RULE_XREF'  TO TABLE-1                
                    PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT         
           END-EVALUATE.                                                
                                                                        
       7550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7560-OPEN-ROOMMATE-CURSOR                                      *        
      ******************************************************************        
                                                                        
       7560-OPEN-ROOMMATE-CURSOR.                                       
                                                                        
           EXEC SQL                                                     
              OPEN ROOMMATE_CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
                    MOVE '7560'               TO ACTIVE-PARAGRAPH       
                    MOVE 'OPEN'               TO ABEND-FUNCTION         
                    MOVE SPACES               TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
                    MOVE 'CSS_ROOMMATE'       TO TABLE-1                
                    MOVE 'CSS_CUST_STATUS'    TO TABLE-2                
                    PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT         
           END-EVALUATE.                                                
                                                                        
       7560-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7570-FETCH-ROOMMATE-CURSOR                                     *        
      ******************************************************************        
                                                                        
       7570-FETCH-ROOMMATE-CURSOR.                                      
                                                                        
           EXEC SQL                                                     
               FETCH ROOMMATE_CURSOR                                    
                INTO :CE-SSN                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES               TO WS-ACTIVE-RETURN-CODE  
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
                    MOVE '7570'               TO ACTIVE-PARAGRAPH       
                    MOVE 'FETCH'              TO ABEND-FUNCTION         
                    MOVE SPACES               TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
                    MOVE 'CSS_ROOMMATE'       TO TABLE-1                
                    MOVE 'CSS_CUST_STATUS'    TO TABLE-2                
                    MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1        
                    MOVE 'CUSTOMER_TYPE'      TO TABLE-ELEMENT-2        
                    MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1      
                    MOVE CE-CUSTOMER-TYPE     TO HOSTVAR-ELEMENT-2      
                    PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT         
           END-EVALUATE.                                                
                                                                        
       7570-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7580-CLOSE-ROOMMATE-CURSOR                                     *        
      ******************************************************************        
                                                                        
       7580-CLOSE-ROOMMATE-CURSOR.                                      
                                                                        
           EXEC SQL                                                     
               CLOSE ROOMMATE_CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
                    MOVE '7580'               TO ACTIVE-PARAGRAPH       
                    MOVE 'CLOSE'              TO ABEND-FUNCTION         
                    MOVE SPACES               TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
                    MOVE 'CSS_ROOMMATE'       TO TABLE-1                
                    MOVE 'CSS_CUST_STATUS'    TO TABLE-2                
                    PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT         
           END-EVALUATE.                                                
                                                                        
       7580-EXIT.                                                       
           EXIT.                                                        
                                                                        
P0726E******************************************************************        
P0726E* 7590-OPEN-BILL-WINDOW-CSR                                      *        
P0726E******************************************************************        
P0726E                                                                  
P0726E 7590-OPEN-BILL-WINDOW-CSR.                                       
P0726E                                                                  
P0726E     EXEC SQL                                                     
P0726E        OPEN BILL-WINDOW                                          
P0726E     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0726E                                                                  
P0726E     IF SQLCODE = SUCCESSFUL-CALL                                 
P0726E        CONTINUE                                                  
P0726E     ELSE                                                         
P0726E        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
P0726E        MOVE '7590'               TO ACTIVE-PARAGRAPH             
P0726E        MOVE 'OPEN'               TO ABEND-FUNCTION               
P0726E        MOVE SPACES               TO ABEND-SQL-PREDICATES         
P0726E                                     ABEND-TABLES                 
P0726E        MOVE 'CSS_BILL_WINDOW'    TO TABLE-1                      
P0726E        PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
P0726E     END-IF.                                                      
P0726E                                                                  
P0726E 7590-EXIT.                                                       
P0726E     EXIT.                                                        
P0726E                                                                  
P0726E******************************************************************        
P0726E* 7600-FETCH-BILL-WINDOW-CSR                                     *        
P0726E******************************************************************        
P0726E                                                                  
P0726E 7600-FETCH-BILL-WINDOW-CSR.                                      
P0726E                                                                  
P0726E     EXEC SQL                                                     
P0726E        FETCH BILL-WINDOW                                         
P0726E         INTO :BN-DATE-EXTRACT                                    
P0726E             ,:BN-CODE-BILL-COND                                  
P0726E     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0726E                                                                  
P0726E     IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
P0726E        CONTINUE                                                  
P0726E     ELSE                                                         
P0726E        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
P0726E        MOVE '7600'               TO ACTIVE-PARAGRAPH             
P0726E        MOVE 'FETCH'              TO ABEND-FUNCTION               
P0726E        MOVE SPACES               TO ABEND-SQL-PREDICATES         
P0726E                                     ABEND-TABLES                 
P0726E        MOVE 'CSS_BILL_WINDOW'    TO TABLE-1                      
P0726E        MOVE 'CURRENT DATE'       TO TABLE-ELEMENT-1              
P0726E        MOVE WS-CURRENT-DATE      TO HOSTVAR-ELEMENT-1            
P0726E        PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
P0726E     END-IF.                                                      
P0726E                                                                  
P0726E 7600-EXIT.                                                       
P0726E     EXIT.                                                        
P0726E                                                                  
P0726E******************************************************************        
P0726E* 7610-CLOSE-BILL-WINDOW-CSR                                     *        
P0726E******************************************************************        
P0726E                                                                  
P0726E 7610-CLOSE-BILL-WINDOW-CSR.                                      
P0726E                                                                  
P0726E     EXEC SQL                                                     
P0726E        CLOSE BILL-WINDOW                                         
P0726E     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0726E                                                                  
P0726E     IF SQLCODE = SUCCESSFUL-CALL                                 
P0726E        CONTINUE                                                  
P0726E     ELSE                                                         
P0726E        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
P0726E        MOVE '7610'               TO ACTIVE-PARAGRAPH             
P0726E        MOVE 'CLOSE'              TO ABEND-FUNCTION               
P0726E        MOVE SPACES               TO ABEND-SQL-PREDICATES         
P0726E                                     ABEND-TABLES                 
P0726E        MOVE 'CSS_BILL_WINDOW'    TO TABLE-1                      
P0726E        PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
P0726E     END-IF.                                                      
P0726E                                                                  
P0726E 7610-EXIT.                                                       
P0726E     EXIT.                                                        
P0726E                                                                  
P0726G******************************************************************        
P0726G* 7650-ACCOUNT-ATTRIBUTE                                         *        
P0726G* CHECKS ACCCOUNT ATTRIBUTE                                      *        
P0726G******************************************************************        
P0726G 7650-ACCOUNT-ATTRIBUTE.                                          
P0726G                                                                  
P0726G     EXEC SQL                                                     
P0726G         SELECT TOP(1) ACCOUNT_NO                                        
P0726G           INTO :YP-ACCOUNT-NO                                    
P0726G           FROM CSS_ACCT_ATTRIBUTE WITH(READUNCOMMITTED)                  
P0726G          WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
P0726G            AND ATTRIBUTE_DESC = :YP-ATTRIBUTE-DESC               
P0726G                                           
P0726G                                                           
P0726G                                                      
P0726G     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ACCOUNT_NO                                                
MFA-TR*          INTO :YP-ACCOUNT-NO                                            
MFA-TR*          FROM CSS_ACCT_ATTRIBUTE                                        
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*           AND ATTRIBUTE_DESC = :YP-ATTRIBUTE-DESC                       
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7650                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0726G                                                                  
P0726G     MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
P0726G                                                                  
P0726G     EVALUATE WS-ACTIVE-RETURN-CODE                               
P0726G         WHEN SUCCESSFUL-CALL                                     
P0726G             MOVE 'Y' TO WS-ACCT-ATTRIBUTE-FL                     
P0726G         WHEN NOT-FOUND                                           
P0726G             MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
P0726G             MOVE 'N' TO WS-ACCT-ATTRIBUTE-FL                     
P0726G         WHEN OTHER                                               
P0726G             MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
P0726G             MOVE '7650'               TO ACTIVE-PARAGRAPH        
P0726G             MOVE 'SELECT'             TO ABEND-FUNCTION          
P0726G             MOVE 'CSS_ACCT_ATTRIBUTE' TO TABLE-1                 
P0726G             MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1         
P0726G             MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1       
P0726G             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
P0726G     END-EVALUATE.                                                
P0726G                                                                  
P0726G 7650-EXIT.                                                       
P0726G     EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8000A-DELETE-GTT-ROWS.                                         *        
      ******************************************************************        
       8000A-DELETE-GTT-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04628_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04628_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                   CONTINUE                                             
              WHEN NOT-FOUND                                            
                   MOVE ZEROES              TO WS-ACTIVE-RETURN-CODE    
              WHEN OTHER                                                
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '8000A'             TO ACTIVE-PARAGRAPH         
                   MOVE 'DELETE'            TO ABEND-FUNCTION           
                   MOVE SPACES              TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                   MOVE 'CSR04628_R1'       TO TABLE-1                  
                   MOVE SPACES              TO TABLE-ELEMENT-1          
                   MOVE SPACES              TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       8000A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 8000B-DELETE-GTT-ROWS.                                         *        
      ******************************************************************        
       8000B-DELETE-GTT-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04628_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04628_R2                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                   CONTINUE                                             
              WHEN NOT-FOUND                                            
                   MOVE ZEROES              TO WS-ACTIVE-RETURN-CODE    
              WHEN OTHER                                                
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '8000B'             TO ACTIVE-PARAGRAPH         
                   MOVE 'DELETE'            TO ABEND-FUNCTION           
                   MOVE SPACES              TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                   MOVE 'CSR04628_R2'       TO TABLE-1                  
                   MOVE SPACES              TO TABLE-ELEMENT-1          
                   MOVE SPACES              TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       8000B-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 8000C-DELETE-GTT-ROWS.                                         *        
      ******************************************************************        
       8000C-DELETE-GTT-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04628_R3                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04628_R3                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                   CONTINUE                                             
              WHEN NOT-FOUND                                            
                   MOVE ZEROES              TO WS-ACTIVE-RETURN-CODE    
              WHEN OTHER                                                
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '8000C'             TO ACTIVE-PARAGRAPH         
                   MOVE 'DELETE'            TO ABEND-FUNCTION           
                   MOVE SPACES              TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                   MOVE 'CSR04628_R3'       TO TABLE-1                  
                   MOVE SPACES              TO TABLE-ELEMENT-1          
                   MOVE SPACES              TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       8000C-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 8010-INSERT-GTT-R1.                                            *        
      ******************************************************************        
       8010-INSERT-GTT-R1.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04628_R1                            
             (                                                          
              RETURN_CODE                                               
P0726E       ,APPL_RETURN_CODE                                          
P0726E       ,ARNG_ID                                                   
P0726E       ,ARNG_TYPE                                                 
P0726E       ,ARNG_TERM_CD                                              
P0726E       ,ARNG_OPTION_ID                                            
900948       ,ARNG_PRIORITY                                             
             ,STA_AMOUNT                                                
             ,NEW_STA_DUE_DATE                                          
             ,NEW_STA_DNP_DATE                                          
P0726J       ,CREDIT_ACTION_FL                                          
             )                                                          
             VALUES                                                     
             (                                                          
              :S-R1-RETURN-CODE                                         
P0726E       ,:S-R1-APPL-RETURN-CODE                                    
P0726E       ,:S-R1-ARNG-ID                                             
P0726E       ,:S-R1-ARNG-TYPE                                           
P0726E       ,:S-R1-ARNG-TERM_CD                                        
P0726E       ,:S-R1-ARNG-OPTION-ID                                      
P00948       ,:S-R1-ARNG-PRIORITY                                       
             ,:S-R1-STA-AMOUNT                                          
             ,:S-R1-NEW-STA-DUE-DATE                                    
             ,:S-R1-NEW-STA-DNP-DATE                                    
P0726J       ,:S-R1-CREDIT-ACTION-FL                                    
             )                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04628_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,APPL_RETURN_CODE                                                  
MFA-TR*      ,ARNG_ID                                                           
MFA-TR*      ,ARNG_TYPE                                                         
MFA-TR*      ,ARNG_TERM_CD                                                      
MFA-TR*      ,ARNG_OPTION_ID                                                    
MFA-TR*      ,ARNG_PRIORITY                                                     
MFA-TR*      ,STA_AMOUNT                                                        
MFA-TR*      ,NEW_STA_DUE_DATE                                                  
MFA-TR*      ,NEW_STA_DNP_DATE                                                  
MFA-TR*      ,CREDIT_ACTION_FL                                                  
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S-R1-RETURN-CODE                                                 
MFA-TR*      ,:S-R1-APPL-RETURN-CODE                                            
MFA-TR*      ,:S-R1-ARNG-ID                                                     
MFA-TR*      ,:S-R1-ARNG-TYPE                                                   
MFA-TR*      ,:S-R1-ARNG-TERM_CD                                                
MFA-TR*      ,:S-R1-ARNG-OPTION-ID                                              
MFA-TR*      ,:S-R1-ARNG-PRIORITY                                               
MFA-TR*      ,:S-R1-STA-AMOUNT                                                  
MFA-TR*      ,:S-R1-NEW-STA-DUE-DATE                                            
MFA-TR*      ,:S-R1-NEW-STA-DNP-DATE                                            
MFA-TR*      ,:S-R1-CREDIT-ACTION-FL                                            
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE       = SUCCESSFUL-CALL             
              ADD +1                        TO  CTR-ROWS-RS1            
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE '8010'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE 'CSR04628_R1'            TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       8010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8020-INSERT-GTT-R2.                                            *        
      ******************************************************************        
       8020-INSERT-GTT-R2.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04628_R2                            
             (                                                          
              RETURN_CODE                                               
             ,ARNG_ID                                                   
             ,ARNG_TYPE                                                 
             ,ARNG_CHANNEL_CD                                           
             ,ARNG_TOTAL_AMT                                            
             ,ARNG_DUE_DT                                               
             ,ORIG_DUE_DT                                               
             ,TOTAL_AR_BALANCE                                          
             ,TOTAL_UTL_BALANCE                                         
             ,TOTAL_NONUTL_BALANCE                                      
             ,UTL_ARREARS_AMT                                           
             ,NONUTL_ARREARS_AMT                                        
             ,SSN_CUST                                                  
             ,SSN_SPOUSE                                                
             ,SSN_ROOMMATE1                                             
             ,SSN_ROOMMATE2                                             
             ,SSN_ROOMMATE3                                             
P0726F       ,ORIGINAL_DNP_TYPE                                         
P0726F       ,ORIGINAL_DNP_DATE                                         
P0726F       ,FIRST_NOTICE_MAIL_DT                                      
P0726F       ,FINAL_NOTICE_MAIL_DT                                      
P0726M       ,LAST_UPDATE_TS                                            
             )                                                          
             VALUES                                                     
             (                                                          
              :S-R2-RETURN-CODE                                         
             ,:S-R2-ARNG-ID                                             
             ,:S-R2-ARNG-TYPE                                           
             ,:S-R2-ARNG-CHANNEL-CD                                     
             ,:S-R2-ARNG-TOTAL-AMT                                      
             ,:S-R2-ARNG-DUE-DT                                         
             ,:S-R2-ORIG-DUE-DT                                         
             ,:S-R2-TOTAL-AR-BALANCE                                    
             ,:S-R2-TOTAL-UTL-BALANCE                                   
             ,:S-R2-TOTAL-NONUTL-BALANCE                                
             ,:S-R2-UTL-ARREARS-AMT                                     
             ,:S-R2-NONUTL-ARREARS-AMT                                  
             ,:S-R2-SSN-CUST                                            
             ,:S-R2-SSN-SPOUSE                                          
             ,:S-R2-SSN-ROOMMATE1                                       
             ,:S-R2-SSN-ROOMMATE2                                       
             ,:S-R2-SSN-ROOMMATE3                                       
P0726F       ,:S-R2-ORIGINAL-DNP-TYPE                                   
P0726F       ,:S-R2-ORIGINAL-DNP-DATE                                   
P0726F       ,:S-R2-FIRST-NOT-MAIL-DT                                   
P0726F       ,:S-R2-FINAL-NOT-MAIL-DT                                   
P0726M       ,:S-R2-LAST-UPDATE-TS                                      
             )                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04628_R2                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,ARNG_ID                                                           
MFA-TR*      ,ARNG_TYPE                                                         
MFA-TR*      ,ARNG_CHANNEL_CD                                                   
MFA-TR*      ,ARNG_TOTAL_AMT                                                    
MFA-TR*      ,ARNG_DUE_DT                                                       
MFA-TR*      ,ORIG_DUE_DT                                                       
MFA-TR*      ,TOTAL_AR_BALANCE                                                  
MFA-TR*      ,TOTAL_UTL_BALANCE                                                 
MFA-TR*      ,TOTAL_NONUTL_BALANCE                                              
MFA-TR*      ,UTL_ARREARS_AMT                                                   
MFA-TR*      ,NONUTL_ARREARS_AMT                                                
MFA-TR*      ,SSN_CUST                                                          
MFA-TR*      ,SSN_SPOUSE                                                        
MFA-TR*      ,SSN_ROOMMATE1                                                     
MFA-TR*      ,SSN_ROOMMATE2                                                     
MFA-TR*      ,SSN_ROOMMATE3                                                     
MFA-TR*      ,ORIGINAL_DNP_TYPE                                                 
MFA-TR*      ,ORIGINAL_DNP_DATE                                                 
MFA-TR*      ,FIRST_NOTICE_MAIL_DT                                              
MFA-TR*      ,FINAL_NOTICE_MAIL_DT                                              
MFA-TR*      ,LAST_UPDATE_TS                                                    
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S-R2-RETURN-CODE                                                 
MFA-TR*      ,:S-R2-ARNG-ID                                                     
MFA-TR*      ,:S-R2-ARNG-TYPE                                                   
MFA-TR*      ,:S-R2-ARNG-CHANNEL-CD                                             
MFA-TR*      ,:S-R2-ARNG-TOTAL-AMT                                              
MFA-TR*      ,:S-R2-ARNG-DUE-DT                                                 
MFA-TR*      ,:S-R2-ORIG-DUE-DT                                                 
MFA-TR*      ,:S-R2-TOTAL-AR-BALANCE                                            
MFA-TR*      ,:S-R2-TOTAL-UTL-BALANCE                                           
MFA-TR*      ,:S-R2-TOTAL-NONUTL-BALANCE                                        
MFA-TR*      ,:S-R2-UTL-ARREARS-AMT                                             
MFA-TR*      ,:S-R2-NONUTL-ARREARS-AMT                                          
MFA-TR*      ,:S-R2-SSN-CUST                                                    
MFA-TR*      ,:S-R2-SSN-SPOUSE                                                  
MFA-TR*      ,:S-R2-SSN-ROOMMATE1                                               
MFA-TR*      ,:S-R2-SSN-ROOMMATE2                                               
MFA-TR*      ,:S-R2-SSN-ROOMMATE3                                               
MFA-TR*      ,:S-R2-ORIGINAL-DNP-TYPE                                           
MFA-TR*      ,:S-R2-ORIGINAL-DNP-DATE                                           
MFA-TR*      ,:S-R2-FIRST-NOT-MAIL-DT                                           
MFA-TR*      ,:S-R2-FINAL-NOT-MAIL-DT                                           
MFA-TR*      ,:S-R2-LAST-UPDATE-TS                                              
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE       = SUCCESSFUL-CALL             
              ADD +1                        TO  CTR-ROWS-RS2            
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE '8020'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE 'CSR04628_R2'            TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       8020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8030-INSERT-GTT-R3.                                            *        
      ******************************************************************        
       8030-INSERT-GTT-R3.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04628_R3                            
             (                                                          
              RETURN_CODE                                               
P0726E       ,ARNG_ID                                                   
P0726E       ,RULE_NOTIFY_TYPE_CD                                       
             ,BUS_RULE_ID                                               
             ,RULE_RESULT_CD                                            
             ,BUS_RULE_XREF_ID                                          
             ,MESSAGE_PARMS                                             
             ,LINK_PARMS                                                
             )                                                          
             VALUES                                                     
             (                                                          
              :S-R3-RETURN-CODE                                         
P0726E       ,:S-R3-ARNG-ID                                             
P0726E       ,:S-R3-RULE-NOTIFY-TYPE-CD                                 
             ,:S-R3-BUS-RULE-ID                                         
             ,:S-R3-RULE-RESULT-CD                                      
             ,:S-R3-BUS-RULE-XREF-ID                                    
             ,:S-R3-MESSAGE-PARMS                                       
             ,:S-R3-LINK-PARMS                                          
             )                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04628_R3                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,ARNG_ID                                                           
MFA-TR*      ,RULE_NOTIFY_TYPE_CD                                               
MFA-TR*      ,BUS_RULE_ID                                                       
MFA-TR*      ,RULE_RESULT_CD                                                    
MFA-TR*      ,BUS_RULE_XREF_ID                                                  
MFA-TR*      ,MESSAGE_PARMS                                                     
MFA-TR*      ,LINK_PARMS                                                        
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S-R3-RETURN-CODE                                                 
MFA-TR*      ,:S-R3-ARNG-ID                                                     
MFA-TR*      ,:S-R3-RULE-NOTIFY-TYPE-CD                                         
MFA-TR*      ,:S-R3-BUS-RULE-ID                                                 
MFA-TR*      ,:S-R3-RULE-RESULT-CD                                              
MFA-TR*      ,:S-R3-BUS-RULE-XREF-ID                                            
MFA-TR*      ,:S-R3-MESSAGE-PARMS                                               
MFA-TR*      ,:S-R3-LINK-PARMS                                                  
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE       = SUCCESSFUL-CALL             
              ADD +1                        TO  CTR-ROWS-RS3            
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE '8030'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE 'CSR04628_R3'            TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       8030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8900-SEND-DONE.                                                *        
      ******************************************************************        
       8900-SEND-DONE.                                                  
                                                                        
           IF WS-ARNG-CHANNEL-CODE = 'I' OR 'W'                         
              EXEC SQL                                                  
                  OPEN C1_IVR_WEB                                       
              END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1_IVR_WEB WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                  
           ELSE                                                         
              EXEC SQL                                                  
                  OPEN C1                                               
              END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                  
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C2                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
                                                                        
           EXEC SQL                                                     
               OPEN C3                                                  
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C3 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
                                                    
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9000-SEND-ERROR-RESULT                                         *        
      ******************************************************************        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE       TO ABEND-SQLCODE            
                                               S-R1-RETURN-CODE         
                                               S-R2-RETURN-CODE         
                                               S-R3-RETURN-CODE.        
                                                                        
           MOVE SQLERRMC                    TO ABEND-SQLERRMC.          
                                                                        
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE                     = SUCCESSFUL-CALL             
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'               TO ABEND-FUNCTION           
           END-IF.                                                      
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1     THRU 0100A-EXIT.            
           PERFORM 0100B-DECLARE-GTT-R2     THRU 0100B-EXIT.            
           PERFORM 0100C-DECLARE-GTT-R3     THRU 0100C-EXIT.            
                                                                        
           PERFORM 8010-INSERT-GTT-R1       THRU 8010-EXIT.             
           PERFORM 8020-INSERT-GTT-R2       THRU 8020-EXIT.             
           PERFORM 8030-INSERT-GTT-R3       THRU 8030-EXIT.             
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9700-ABEND-PROCESSING.                                         *        
      ******************************************************************        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT.             
           PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT.             
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900-SQL-ERROR-ROUTINE.                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9999-END-PROGRAM.                                              *        
      ******************************************************************        
                                                                        
       9999-END-PROGRAM.                                                
                                                                        
           IF S-R1-RETURN-CODE = 100 AND                                
              S-R2-RETURN-CODE = 100                                    
              PERFORM 8010-INSERT-GTT-R1    THRU 8010-EXIT              
              PERFORM 8020-INSERT-GTT-R2    THRU 8020-EXIT              
              IF S-R3-RETURN-CODE = 100                                 
                 PERFORM 8030-INSERT-GTT-R3 THRU 8030-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF CTR-ROWS-RS1 < 1 AND                                      
              CTR-ROWS-RS2 < 1 AND                                      
              CTR-ROWS-RS3 < 1                                          
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '9999-END-PROGRAM'       TO ABEND-FUNCTION           
              MOVE 'PROGRAMMER LOGIC'       TO TABLE-1                  
              MOVE 'FAILED TO SEND'         TO TABLE-ELEMENT-1          
              MOVE 'RESULT SET'             TO HOSTVAR-ELEMENT-1        
              MOVE -1                       TO WS-ACTIVE-RETURN-CODE    
                                                                        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           ELSE                                                         
              PERFORM 8900-SEND-DONE        THRU 8900-EXIT              
           END-IF.                                                      
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
