       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04625.                                         
       AUTHOR.        VENKAT VUDDANDAPU.                                
COB303 DATE-WRITTEN.     MAY  06, 2013.                                 
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00060000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00070000
      *                                                                *00080000
      *  THIS PROGRAM CALLS MCSKR135 TO INSERT CREDIT ARRANGEMENT SETUP*00090000
      *  TABLES AND WRITE TRANSACTION HISTORY FOR CHANGE DUE DATE ARNG.*00090000
      *                                                                *00140000
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
P00726*  05/06/13  VV94890    PROCEDURE ORIGINALLY CODED.              *        
P0726A*  01/29/14  AA97148    CREDIT ARRANGEMENTS - RELEASE 2 CHANGES  *        
P0726A*                       ADDED NEW PARM ARNG_OPTION_ID AND MODIFIED        
P0726A*                       AMOUNT FIELDS DECLARATION FROM CHAR TO   *        
P0726A*                       DECIMAL.                                 *        
P0726B*  07/02/14  AA97148    CREDIT ARRANGEMENTS - RELEASE 3 CHANGES  *        
P0726C*  07/01/15  AA97148    CREDIT ARRANGEMENTS - RELEASE 6 CHANGES  *        
P0726C*                       ADDED NEW PARM LAST-UPDATE-TS.           *        
P00948*  06/16/16  AA97148    LEAST AMOUNT DUE PROJECT CHANGES:        *        
P00948*                       ADDED NEW PAYMENT ARRANGEMENT PLANS SHORT*        
P00948*                       TERM FLEX(STF) & SHORT TERM FLEX AFTER   *        
P00948*                       (STFA).                                  *        
P00948*  07/20/16  VENKAT.P   ADDED ARRANGEMENT CANCEL PROCESS.        *        
      ******************************************************************        
      ******************************************************************00310000
      *                                                                *00320000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00330000
      *                                                                *00340000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00350000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00360000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00370000
      *  3000 - 4999  NOT USED                                         *00380000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00390000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00400000
      *  7000 - 7999  INPUT MODULES                                    *00410000
      *  8000 - 8999  OUTPUT MODULES                                   *00420000
      *  9000 - 9999  TERMINATION, ABEND, MESSAGING MODULES            *00430000
      *                                                                *00440000
      ******************************************************************00450000
      *                                                                 00460000
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04625'.
MSQ017     COPY MFASQLM.
      *                                                                 00500000
       01  WS-START                                   PIC X(45) VALUE   
           'WORKING STORAGE FOR RPC CSR04625 STARTS HERE'.              
      *                                                                 00530000
      ******************************************************************00770000
      *    COBOL WORKING STORAGE COPY BOOKS                            *00780000
      ******************************************************************00790000
      ******************************************************************        
      *    ERROR HANDLING                                                       
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    SUPPORTS DB2 AND SQL ERROR CHECKING                         *        
      ******************************************************************        
      *                                                                         
           COPY CWS00303.                                                       
      *                                                                         
      ******************************************************************00950000
      *    WORK AREAS                                                  *00960000
      ******************************************************************00970000
      *                                                                 00980000
       01  WS-MISC.                                                     
          05 PROGRAM-NAME                PIC X(08) VALUE 'CSR04625'.    
          05 WS-SQLSTATE                 PIC X(05) VALUE '     '.       
          05 MCSKR135                    PIC X(08) VALUE 'MCSKR135'.    
P00948    05 WS-CANCEL-COMMENTS          PIC X(48) VALUE                
P00948       'ARRANGEMENT CANCELLED BY SYSTEM DURING SETUP OF '.        
P00948    05 WS-CDDA                     PIC X(16) VALUE                
P00948       'CHANGE DUE AFTER'.                                        
P00948    05 WS-STA                      PIC X(22) VALUE                
P00948       'SHORT TERM ARRANGEMENT'.                                  
P00948    05 WS-STAA                     PIC X(28) VALUE                
P00948       'SHORT TERM AFTER ARRANGEMENT'.                            
P00948    05 WS-STF                      PIC X(27) VALUE                
P00948       'SHORT TERM FLEX ARRANGEMENT'.                             
P00948    05 WS-STFA                     PIC X(33) VALUE                
P00948       'SHORT TERM FLEX AFTER ARRANGEMENT'.                       
          05 SEND-DONE-SW                PIC X(01) VALUE 'Y'.           
              88 SEND-DONE-ERROR                   VALUE 'N'.           
              88 SEND-DONE-OK                      VALUE 'Y'.           
      *                                                                 05850002
       01 COUNTER-FIELDS.                                               
          05 CTR-ROWS                    PIC S9(9) COMP VALUE 0.        
      *                                                                         
       01 GTT-RETURN-FIELDS.                                            
          05 S-RETURN-CODE               PIC S9(04) COMP VALUE 0.       
          05 S-APPL-RETURN-CODE          PIC X(10) VALUE SPACES.        
          05 S-CRED-ARNG-SEQ             PIC S9(04) COMP VALUE 0.       
          05 S-CONFIRMATION-NO           PIC X(20) VALUE SPACES.        
P00948*                                                                         
P00948******************************************************************00540000
P00948*    CSS_CRED_ARNGMENT  - X1                                     *00550000
P00948******************************************************************00560000
P00948     EXEC SQL                                                     00580000
P00948        INCLUDE TBCRARNG                                          00590000
P00948     END-EXEC.                                                    00600000
      *                                                                         
      ******************************************************************00540000
      *    SQL COMMUNICATION AREA                                      *00550000
      ******************************************************************00560000
           EXEC SQL                                                     00580000
              INCLUDE SQLCA                                             00590000
           END-EXEC.                                                    00600000
      *                                                                         
      ******************************************************************        
      * VARIABLES NEEDED FOR CREDIT ARRANGEMENT PROCESS                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CWSKR135                                                  
           END-EXEC.                                                            
      *                                                                         
HPCCDM*EJECT                                                            02000000
      *                                                                         
      ******************************************************************        
      **   LINKAGE SECTION.                                           **        
      ******************************************************************        
       LINKAGE SECTION.                                                 
      *                                                                         
       01  PARM-ACCOUNT-NO             PIC  X(13).                      
       01  PARM-ARNG-ID                PIC  X(05).                      
       01  PARM-ARNG-TYPE              PIC  X(10).                      
       01  PARM-ARNG-CHANNEL-CD        PIC  X(02).                      
COB305 01 PARM-ARNG-TOTAL-AMT        PIC  S9(11)V99 COMP-3 VALUE 0.           
       01  PARM-ARNG-DUE-DT            PIC  X(10).                      
       01  PARM-ORIG-DUE-DT            PIC  X(10).                      
COB305 01 PARM-TOTAL-AR-BALANCE        PIC  S9(11)V99 COMP-3 VALUE 0.           
COB305 01 PARM-TOTAL-UTL-BALANCE        PIC  S9(11)V99 COMP-3 VALUE 0.          
COB305 01 PARM-TOTAL-NONUTL-BALANCE        PIC  S9(11)V99 COMP-3 
COB305       VALUE 0.           
COB305 01 PARM-UTL-ARREARS-AMT        PIC  S9(11)V99 COMP-3 VALUE 0.           
COB305 01 PARM-NONUTL-ARREARS-AMT        PIC  S9(11)V99 COMP-3 VALUE 0.         
       01  PARM-USER-ID                PIC  X(07).                      
       01  PARM-SSN-LAST-4             PIC  X(04).                      
P0726A 01  PARM-ARNG-OPTION-ID         PIC  S9(4) USAGE COMP.           
P0726B 01  PARM-ORIGINAL-DNP-DATE      PIC  X(10) VALUE SPACES.         
P0726B 01  PARM-ORIGINAL-DNP-TYPE      PIC  X(01) VALUE SPACES.         
P0726B 01  PARM-FIRST-NOT-MAIL-DT      PIC  X(10) VALUE SPACES.         
P0726B 01  PARM-FINAL-NOT-MAIL-DT      PIC  X(10) VALUE SPACES.         
P0726B 01  PARM-NEW-DNP-DATE           PIC  X(10) VALUE SPACES.         
P0726C 01  PARM-LAST-UPDATE-TS         PIC  X(26) VALUE SPACES.         
      *                                                                         
       PROCEDURE DIVISION USING  PARM-ACCOUNT-NO                        
                               , PARM-ARNG-ID                           
                               , PARM-ARNG-TYPE                         
                               , PARM-ARNG-CHANNEL-CD                   
                               , PARM-ARNG-TOTAL-AMT                    
                               , PARM-ARNG-DUE-DT                       
                               , PARM-ORIG-DUE-DT                       
                               , PARM-TOTAL-AR-BALANCE                  
                               , PARM-TOTAL-UTL-BALANCE                 
                               , PARM-TOTAL-NONUTL-BALANCE              
                               , PARM-UTL-ARREARS-AMT                   
                               , PARM-NONUTL-ARREARS-AMT                
                               , PARM-USER-ID                           
                               , PARM-SSN-LAST-4                        
P0726A                         , PARM-ARNG-OPTION-ID                    
P0726B                         , PARM-ORIGINAL-DNP-DATE                 
P0726B                         , PARM-ORIGINAL-DNP-TYPE                 
P0726B                         , PARM-FIRST-NOT-MAIL-DT                 
P0726B                         , PARM-FINAL-NOT-MAIL-DT                 
P0726B                         , PARM-NEW-DNP-DATE                      
P0726C                         , PARM-LAST-UPDATE-TS.                   
      *                                                                         
      ******************************************************************02030000
      * 0000-MAINLINE                                                  *02040000
      *     CALLS 0100-INITIALIZE                                      *02050000
      *           1000-PROCESS-INPUT                                   *02060000
      *           2000-PROCESS-SETUP                                   *02070000
      *           9999-END-PROGRAM                                     *02080000
      *                                                                *02090000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *02100000
      ******************************************************************02110000
      *================================================================*02120000
       0000-MAINLINE.                                                   
      *================================================================*02120000
      *                                                                 02140000
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
P00948     PERFORM 2100-PROCESS-CANCEL THRU 2100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-SETUP  THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
      *                                                                 02190000
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02220000
      *================================================================*02120000
       0100-INITIALIZE.                                                 
      *================================================================*02120000
      *                                                                 02380000
           MOVE '0100'          TO ACTIVE-PARAGRAPH.                    
      *                                                                 02400000
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
      *                                                                 02440000
           PERFORM 0100A-DECLARE-GTT    THRU 0100A-EXIT.                
      *                                                                 02440000
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
               SELECT                                                   
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,CRED_ARNG_SEQ                                        
                  ,CONFIRMATION_NO                                      
               FROM #CSR04625_R1                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                            00000300
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*        SELECT                                                   00000400
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,CRED_ARNG_SEQ                                                
MFA-TR*           ,CONFIRMATION_NO                                              
MFA-TR*        FROM SESSION.CSR04625_R1                                 00000500
MFA-TR*    END-EXEC.                                                    00000700
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02630000
      *================================================================*07800000
       0100A-DECLARE-GTT.                                               
      *================================================================*07800000
      * DECLARE TABLE TO HOLD RESULT SET                               *        
      *                                                                         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04625_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04625_R1
              (                                                       
                     RETURN_CODE            INT                     
                    ,APPL_RETURN_CODE CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
                    ,CRED_ARNG_SEQ          INT                     
                    ,CONFIRMATION_NO CHAR(20)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLSTATE              TO WS-SQLSTATE.                   
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
                 MOVE SQLCODE            TO ABEND-SQLCODE               
                 MOVE SQLSTATE           TO ABEND-SQLSTATE              
                 MOVE '0100A'            TO ACTIVE-PARAGRAPH            
                 MOVE 'DECLARE GTT'      TO ABEND-FUNCTION              
                 MOVE SPACES             TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                 MOVE 'CSR04625_R1'      TO TABLE-1                     
                 MOVE SPACES             TO TABLE-ELEMENT-1             
                 MOVE SPACES             TO HOSTVAR-ELEMENT-1           
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       0100A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      *================================================================*02710000
       1000-PROCESS-INPUT.                                              
      *================================================================*02710000
      *     RECEIVE PARMS.                                             *02700000
           INITIALIZE WS-KR135-IN-FIELDS                                
                      WS-KR135-OUT-FIELDS                               
                      WS-KR135-WORK-AREA                                
      *                                                                         
           MOVE PARM-ACCOUNT-NO           TO WS-CAR-ACCOUNT-NO          
      *                                                                 11860000
           MOVE PARM-ARNG-ID              TO WS-CAR-ARNG-ID             
           MOVE PARM-ARNG-TYPE            TO WS-CAR-ARNG-TYPE           
           MOVE PARM-ARNG-CHANNEL-CD      TO WS-CAR-ARNG-CHANNEL-CD     
      *                                                                 08910002
P0726A     MOVE PARM-ARNG-TOTAL-AMT       TO WS-CAR-ARNG-TOTAL-AMT      
      *                                                                 08910002
           MOVE PARM-ARNG-DUE-DT          TO WS-CAR-ARNG-DUE-DT         
           MOVE PARM-ORIG-DUE-DT          TO WS-CAR-ORIG-DUE-DT         
      *                                                                 08910002
P0726A     MOVE PARM-TOTAL-AR-BALANCE     TO WS-CAR-TOTAL-AR-BALANCE    
P0726A     MOVE PARM-TOTAL-UTL-BALANCE    TO WS-CAR-TOTAL-UTL-BALANCE   
P0726A     MOVE PARM-TOTAL-NONUTL-BALANCE TO WS-CAR-TOTAL-NONUTL-BALANCE
P0726A     MOVE PARM-UTL-ARREARS-AMT      TO WS-CAR-UTL-ARREARS-AMT     
P0726A     MOVE PARM-NONUTL-ARREARS-AMT   TO WS-CAR-NONUTL-ARREARS-AMT  
P0726A*                                                                 08910002
           MOVE PARM-USER-ID              TO WS-CAR-USER-ID             
           MOVE PARM-SSN-LAST-4           TO WS-CAR-SSN-LAST-4          
P0726A     MOVE PARM-ARNG-OPTION-ID       TO WS-CSR-ARNG-OPTION-ID      
P0726B     MOVE PARM-ORIGINAL-DNP-DATE    TO WS-CAR-ORIGINAL-DNP-DATE   
P0726B     MOVE PARM-ORIGINAL-DNP-TYPE    TO WS-CAR-ORIGINAL-DNP-TYPE   
P0726B     MOVE PARM-FIRST-NOT-MAIL-DT    TO WS-CAR-FIRST-NOT-MAIL-DT   
P0726B     MOVE PARM-FINAL-NOT-MAIL-DT    TO WS-CAR-FINAL-NOT-MAIL-DT   
P0726C     MOVE PARM-LAST-UPDATE-TS       TO WS-CAR-LAST-UPDATE-TS      
P0726B     IF PARM-NEW-DNP-DATE EQUAL SPACES OR LOW-VALUES              
P00948        IF PARM-ARNG-TYPE EQUAL 'STA' OR 'STF'                    
P0726B           MOVE PARM-ARNG-DUE-DT    TO PARM-NEW-DNP-DATE          
P0726B        END-IF                                                    
P0726B     END-IF                                                       
P0726B     MOVE PARM-NEW-DNP-DATE         TO WS-CAR-NEW-DNP-DATE        
      *                                                                 11895600
           MOVE 'Y'                       TO WS-CAR-TRNS-HST-FL.        
      *                                                                 11895600
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*03300000
       2000-PROCESS-SETUP.                                              
      *================================================================*03300000
      *                                                                 03330000
           MOVE '2000'                       TO   ACTIVE-PARAGRAPH      
      *                                                                         
           PERFORM 5000-CRED-ARNG-PROCESS    THRU 5000-EXIT             
      *                                                                         
           IF CTR-ROWS < 1 THEN                                         
              PERFORM 8100-SEND-RESULT   THRU 8100-EXIT                 
           END-IF.                                                      
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P00948*                                                                         
P00948*================================================================*03300000
P00948 2100-PROCESS-CANCEL.                                             
P00948*================================================================*03300000
P00948*CANCEL EXISTING ACTIVE ARNGMENT IF ANY                           03330000
P00948*                                                                 03330000
P00948     MOVE '2100'                         TO ACTIVE-PARAGRAPH      
P00948     MOVE PARM-ACCOUNT-NO                TO X1-ACCOUNT-NO         
P00948     PERFORM 7000-SEL-CRED-ARNGMENT      THRU 7000-EXIT           
P00948     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00948        IF WS-ARNG-DNP-DT-NULL < 0                                
P00948            MOVE SPACES                  TO X1-ARNG-DNP-DT        
P00948        END-IF                                                    
P00948        INITIALIZE WS-KR135-IN-FIELDS                             
P00948                   WS-KR135-OUT-FIELDS                            
P00948                   WS-KR135-WORK-AREA                             
P00948        MOVE PARM-ACCOUNT-NO             TO WS-CAR-ACCOUNT-NO     
P00948        MOVE X1-ARNG-ID                  TO WS-CAR-ARNG-ID        
P00948        MOVE X1-ARNG-COMPLIANCE-CD       TO WS-CAR-ARNG-COMPL-CD  
P00948        MOVE 'R'                         TO WS-CAR-ARNG-STATUS-CD 
P00948        MOVE 48                          TO WS-CRED-COMMENTS-LEN  
P00948        EVALUATE PARM-ARNG-TYPE                                   
P00948            WHEN 'CDDA'                                           
P00948                 STRING WS-CANCEL-COMMENTS DELIMITED BY SIZE      
P00948                        WS-CDDA            DELIMITED BY SIZE      
P00948                   INTO WS-CRED-COMMENTS-TEXT                     
P00948                 ADD LENGTH OF WS-CDDA   TO WS-CRED-COMMENTS-LEN  
P00948            WHEN 'STA'                                            
P00948                 STRING WS-CANCEL-COMMENTS DELIMITED BY SIZE      
P00948                        WS-STA             DELIMITED BY SIZE      
P00948                   INTO WS-CRED-COMMENTS-TEXT                     
P00948                 ADD LENGTH OF WS-STA    TO WS-CRED-COMMENTS-LEN  
P00948            WHEN 'STAA'                                           
P00948                 STRING WS-CANCEL-COMMENTS DELIMITED BY SIZE      
P00948                        WS-STAA            DELIMITED BY SIZE      
P00948                   INTO WS-CRED-COMMENTS-TEXT                     
P00948                 ADD LENGTH OF WS-STAA   TO WS-CRED-COMMENTS-LEN  
P00948            WHEN 'STF'                                            
P00948                 STRING WS-CANCEL-COMMENTS DELIMITED BY SIZE      
P00948                        WS-STF             DELIMITED BY SIZE      
P00948                   INTO WS-CRED-COMMENTS-TEXT                     
P00948                 ADD LENGTH OF WS-STF    TO WS-CRED-COMMENTS-LEN  
P00948            WHEN 'STFA'                                           
P00948                 STRING WS-CANCEL-COMMENTS DELIMITED BY SIZE      
P00948                        WS-STFA            DELIMITED BY SIZE      
P00948                   INTO WS-CRED-COMMENTS-TEXT                     
P00948                 ADD LENGTH OF WS-STFA   TO WS-CRED-COMMENTS-LEN  
P00948            WHEN OTHER                                            
P00948                 MOVE SPACES             TO WS-CRED-COMMENTS-TEXT 
P00948                 MOVE ZERO               TO WS-CRED-COMMENTS-LEN  
P00948        END-EVALUATE                                              
P00948        MOVE WS-CRED-COMMENTS-LEN        TO WS-CAR-COMMENTS-LEN   
P00948        MOVE WS-CRED-COMMENTS-TEXT       TO WS-CAR-COMMENTS-TEXT  
P00948        MOVE PARM-USER-ID                TO WS-CAR-USER-ID        
P00948        MOVE 'Y'                         TO WS-CAR-TRNS-HST-FL    
P00948        MOVE X1-CRED-ARNG-SEQ            TO WS-ARNG-SEQ-NO        
P0726B        MOVE X1-ARNG-DNP-DT              TO WS-CAR-NEW-DNP-DATE   
P00948*                                                                         
P00948        MOVE 'U'                         TO WS-CAR-ACTION-FL      
P00948        PERFORM 5000-CRED-ARNG-PROCESS   THRU 5000-EXIT           
P00948*                                                                         
P00948     END-IF.                                                      
P00948*                                                                         
P00948 2100-EXIT.                                                       
P00948     EXIT.                                                        
P00948*                                                                         
      *================================================================*03300000
       5000-CRED-ARNG-PROCESS.                                          
      *================================================================*03300000
      * CREDIT ARRANGEMENT SETUP PROCESS.                                       
      *                                                                         
           CALL MCSKR135 USING  WS-KR135-IN-FIELDS                      
                                WS-KR135-OUT-FIELDS                     
                                WS-KR135-WORK-AREA                      
                                ABEND-FILE.                             
      *                                                                         
           IF ABEND-FUNCTION  > SPACES                                  
              MOVE ABEND-SQLCODE           TO S-RETURN-CODE             
                                              WS-ACTIVE-RETURN-CODE     
              PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
           ELSE                                                         
              MOVE RS-RETURN-CODE        TO S-RETURN-CODE               
              MOVE WS-APPL-RETURN-CODE   TO S-APPL-RETURN-CODE          
              MOVE WS-ARNG-SEQ-NO        TO S-CRED-ARNG-SEQ             
              MOVE WS-CONFIRMATION-NO    TO S-CONFIRMATION-NO           
           END-IF.                                                      
      *                                                                         
       5000-EXIT.                                                       
           EXIT.                                                        
P00948*                                                                         
P00948*================================================================*07800000
P00948 7000-SEL-CRED-ARNGMENT.                                          
P00948*================================================================*07800000
P00948* SELECT ACTIVE CREDIT ARRANGEMENT.                              *        
P00948*                                                                         
P00948     EXEC SQL                                                     
P00948        SELECT TOP(1) X1.ARNG_ID,
              X1.CRED_ARNG_SEQ,
              X1.ARNG_COMPLIANCE_CD,
              CIS.CHAR2$DATE(X1.ARNG_DNP_DT,'USA')                     
P00948          INTO :X1-ARNG-ID                                        
P00948              ,:X1-CRED-ARNG-SEQ                                  
P00948              ,:X1-ARNG-COMPLIANCE-CD                             
P00948              ,:X1-ARNG-DNP-DT :WS-ARNG-DNP-DT-NULL        
P00948          FROM CSS_CRED_ARNGMENT X1 WITH(READUNCOMMITTED)                 
P00948         WHERE ACCOUNT_NO        = :X1-ACCOUNT-NO                 
P00948           AND X1.ARNG_STATUS_CD = 'A'                            
P00948                                                           
P00948                                              
P00948                                                      
P00948     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     31860000
MFA-TR*       SELECT X1.ARNG_ID                                                 
MFA-TR*             ,X1.CRED_ARNG_SEQ                                           
MFA-TR*             ,X1.ARNG_COMPLIANCE_CD                                      
MFA-TR*             ,CHAR(DATE(X1.ARNG_DNP_DT),USA)                             
MFA-TR*         INTO :X1-ARNG-ID                                        32260000
MFA-TR*             ,:X1-CRED-ARNG-SEQ                                          
MFA-TR*             ,:X1-ARNG-COMPLIANCE-CD                                     
MFA-TR*             ,:X1-ARNG-DNP-DT        :WS-ARNG-DNP-DT-NULL                
MFA-TR*         FROM CSS_CRED_ARNGMENT X1                               32390000
MFA-TR*        WHERE ACCOUNT_NO        = :X1-ACCOUNT-NO                 32400000
MFA-TR*          AND X1.ARNG_STATUS_CD = 'A'                            32400000
MFA-TR*         WITH UR                                                         
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*      QUERYNO 7000                                                       
MFA-TR*    END-EXEC.                                                    32410000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00948*                                                                 32420000
P00948     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
P00948*                                                                 32420000
P00948     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00948        CONTINUE                                                  
P00948     ELSE                                                         
P00948         MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
P00948         MOVE SPACES                TO ABEND-SQL-PREDICATES       
P00948                                       ABEND-TABLES               
P00948         MOVE SQLCODE               TO ABEND-SQLCODE              
P00948         MOVE '7000'                TO ACTIVE-PARAGRAPH           
P00948         MOVE 'SELECT'              TO ABEND-FUNCTION             
P00948         MOVE 'CSS_CRED_ARNGMENT'   TO TABLE-1                    
P00948         MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
P00948         MOVE X1-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
P00948         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
P00948     END-IF.                                                      
P00948*                                                                         
P00948 7000-EXIT.                                                       
P00948     EXIT.                                                        
      *                                                                         
      *                                                                         
      *================================================================*07800000
       8000A-DELETE-GTT-ROWS.                                           
      *================================================================*07800000
      * DELETE TEMPORARY TABLE WHEN REQUIRED.                          *        
      *                                                                         
           EXEC SQL                                                     
               DELETE FROM #CSR04625_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04625_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8000A'               TO ACTIVE-PARAGRAPH            
              MOVE 'DELETE'              TO ABEND-FUNCTION              
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                                    ABEND-TABLES        
              MOVE 'CSR04625_R1'         TO TABLE-1                     
              MOVE SPACES                TO TABLE-ELEMENT-1             
              MOVE SPACES                TO HOSTVAR-ELEMENT-1           
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       8000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      *================================================================*07800000
       8100-SEND-RESULT.                                                
      *================================================================*07800000
      * INSERT RESULT SET INTO TEMPORARY TABLE.                        *        
      *                                                                         
           EXEC SQL                                                     
                INSERT INTO #CSR04625_R1                         
                (                                                       
                     RETURN_CODE                                        
                    ,APPL_RETURN_CODE                                   
                    ,CRED_ARNG_SEQ                                      
                    ,CONFIRMATION_NO                                    
                )                                                       
                VALUES                                                  
                (                                                       
                     :S-RETURN-CODE                                     
                    ,:S-APPL-RETURN-CODE                                
                    ,:S-CRED-ARNG-SEQ                                   
                    ,LTRIM(RTRIM(:S-CONFIRMATION-NO))                          
                )                                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     42750000
MFA-TR*         INSERT INTO SESSION.CSR04625_R1                                 
MFA-TR*         (                                                               
MFA-TR*              RETURN_CODE                                                
MFA-TR*             ,APPL_RETURN_CODE                                           
MFA-TR*             ,CRED_ARNG_SEQ                                              
MFA-TR*             ,CONFIRMATION_NO                                            
MFA-TR*         )                                                               
MFA-TR*         VALUES                                                          
MFA-TR*         (                                                               
MFA-TR*              :S-RETURN-CODE                                             
MFA-TR*             ,:S-APPL-RETURN-CODE                                32980000
MFA-TR*             ,:S-CRED-ARNG-SEQ                                           
MFA-TR*             ,STRIP(:S-CONFIRMATION-NO)                                  
MFA-TR*         )                                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               ADD +1                    TO CTR-ROWS                    
            ELSE                                                        
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE '8100'               TO ACTIVE-PARAGRAPH            
               MOVE 'INSERT'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04625_R1'        TO TABLE-1                     
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************42800000
      * 9700-PROCESS-ABEND.                                            *42810000
      ******************************************************************42820000
           EXEC SQL                                                             
              INCLUDE CPD0023C                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************42800000
      * 9900 - JOURNALING / ERROR HANDLING ROUTINE                     *42810000
      ******************************************************************42820000
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                 42860000
      ******************************************************************42870000
      *       END PROGRAM COPYLIB                                      *42880000
      ******************************************************************42890000
           EXEC SQL                                                             
              INCLUDE CPD00320                                                  
           END-EXEC.                                                            
      *                                                                 42860000
