       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04624.                                         
COB303 DATE-WRITTEN.  MAY 20,2015                                       
       DATE-COMPILED.                                                   
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM RETURNS ATTRIBUTES FOR PROFILE SCREEN.           *        
      *  RESULT SETS:                                                  *        
      *         1. BBP                                                 *        
      *         2. ONLINE                                              *        
      *         3. PAPERLESS                                           *        
      *         4. E-PAY                                               *        
      *         5. BANK-DRAFT                                          *        
      *         6. AUTORENEW                                           *        
ACT001*         7. SHOPPING REWARDS                                    *        
P805CS*         8. AUTOCARD (SEB DEREGULATED RESIDENTIAL ONLY)         *        
P805CS*         9. CSC DISCOUNT (SEB DEREGULATED RESIDENTIAL ONLY)     *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  05/20/15  MC95456    PROCEDURE ORIGINALLY CODED.              *        
PRJ836*  09/25/15  VK7L032    CHANGES DONE FOR WEB MOD BILLING CHART.  *        
A05123*  12/07/15  SM93554    GET SHOPPING REWARDS FLAG. ACT001        *        
A05460*  03/08/16  SM93554    MOVE ACCT NO TO IN-ACCOUNT-NO AS COMMON  *        
A05460*  04/26/16  SM93554    ADDED ADDITIONAL LOGIC ON THE E-DRAFT    *        
A05460*  06/17/16  SM93554    REMOVED PENDING STATUS FOR EDRAT AND     *        
      *            ACT197     CHANGED THE ERR CHK FOR SHOPPING REWARDS *        
P805CS*  06/17/16  SS45239    CSC DISCOUNT - PROMOTE SECTION CHANGES.  *        
OTPOOL*  07/19/16  SS45239    OUTER POOL GROUP.                        *        
I02262*  08/23/16  SS45239    SMALL COMMERCIAL OUTER POOL GROUP CHANGES*        
A05724*  01/12/17  SS45239    ACT002-CSC DISCOUNTS PRODUCTION FIX.     *        
      *                                                                *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04624'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-START                   PIC X(40) VALUE                    
            'WORKING STORAGE FOR CSR04624 STARTS HERE'.                 
      *                                                                         
       01 WS-LITERALS.                                                  
          05 PROGRAM-NAME            PIC X(08) VALUE 'CSR04624'.        
PRJ836    05 WS-12                   PIC 9(02) VALUE 12.                
PRJ836    05 WS-DFLT-NO-OF-BILLS     PIC 9(02) VALUE 12.                
      *                                                                         
       01 WS-WS-GENERAL.                                                
          05 WS-GTT-NAME             PIC X(19) VALUE SPACES.            
          05 WS-SQLSTATE             PIC X(05) VALUE SPACES.            
          05 WS-DATABASE             PIC 9(01) VALUE ZERO.              
             88 CSR-DATABASE                   VALUE 1.                 
             88 SEB-DATABASE                   VALUE 2.                 
ACT001    05 WS-SHOPPING-RWRDS-FOUND PIC X(01) VALUE 'N'.               
ACT001       88 SHOPPING-RWRDS-FOUND           VALUE 'Y'.               
ACT001       88 SHOPPING-RWRDS-NOT-FOUND       VALUE 'N'.               
          05 WS-ACCOUNT-NO           PIC X(13) VALUE SPACES.            
          05 WS-ACCOUNT-NUM REDEFINES WS-ACCOUNT-NO                     
                                     PIC S9(13).                        
PRJ836    05 WS-APPL-PROG-ID         PIC X(03) VALUE SPACES.            
PRJ836    05 WS-ADDTNL-BILLS-EXIST   PIC X(01) VALUE SPACES.            
PRJ836    05 WS-CUTOFF-CNT           PIC 9(03) VALUE 0.                 
PRJ836    05 WS-CUTOF-REV-MNTH       PIC S9(6).                         
PRJ836    05 WS-CUTOF-REV-MNTH-RED   REDEFINES WS-CUTOF-REV-MNTH.       
PRJ836       10 WS-CUTOF-REV-MNTH-YY PIC 9(04).                         
PRJ836       10 WS-CUTOF-REV-MNTH-MM PIC 9(02).                         
PRJ836    05 WS-REVENUE-MONTH        PIC S9(6) VALUE 0.                 
          05 WS-ACCT-ON-EPAY         PIC X(01) VALUE SPACES.            
          05 WS-BBP-ELIG             PIC S9(9) COMP VALUE 0.            
          05 WS-BBP-REJECTED         PIC X(01) VALUE SPACES.            
          05 WS-EPAY-REJECTED        PIC X(01) VALUE SPACES.            
          05 WS-PAPERLESS-REJECTED   PIC X(01) VALUE SPACES.            
          05 WS-AUTORENEW-REJECTED   PIC X(01) VALUE SPACES.            
          05 WS-ONLINE-REJECTED      PIC X(01) VALUE SPACES.            
          05 WS-ONLINE-FL            PIC X(01) VALUE SPACES.            
          05 WS-ACCOUNTS-OK-FL       PIC X(01) VALUE SPACES.            
          05 WS-PROMO-DT             PIC X(10) VALUE SPACES.            
          05 WS-EXPIRE-DAYS          PIC S9(4) COMP-3 VALUE 0.          
          05 WS-CURRENT-TS           PIC X(26) VALUE SPACES.            
          05 WS-CURRENT-DATE         PIC X(10) VALUE SPACES.            
          05 WS-CURRENT-DATE-30      PIC X(10) VALUE SPACES.            
          05 WS-CURRENT-DATE-90      PIC X(10) VALUE SPACES.            
          05 WS-WOFF-DT              PIC X(10) VALUE SPACES.            
          05 WS-REGISTRATION-FL      PIC X(01) VALUE SPACES.            
          05 WS-CC-NC-FL             PIC X(01) VALUE 'N'.               
          05 WS-DRAFT-CD             PIC X(01) VALUE 'N'.               
          05 WS-REG-ACCT-FL          PIC X(01) VALUE 'N'.               
          05 WS-SC-LOCAL-OFFICE-FL   PIC X(01) VALUE SPACES.            
          05 WS-NULL-IND1            PIC S9(4) COMP.                    
          05 WS-NULL-IND2            PIC S9(4) COMP.                    
          05 WS-NULL-IND3            PIC S9(4) COMP.                    
P805CS    05 WS-ICON-01              PIC X(01) VALUE SPACES.            
P805CS    05 WS-ICON-02              PIC X(01) VALUE SPACES.            
P805CS    05 WS-ICON-03              PIC X(01) VALUE SPACES.            
P805CS    05 WS-FORMAT-AMT-01        PIC $9.99.                         
P805CS    05 WS-FORMAT-AMT-02        PIC $9.99.                         
P805CS    05 WS-SAVE-PL-CURR-STATUS  PIC X(01) VALUE SPACES.            
P805CS    05 WS-SAVE-PL-ELIGIBLE     PIC X(01) VALUE SPACES.            
P805CS    05 WS-SAVE-PL-REJECTED     PIC X(01) VALUE SPACES.            
P805CS    05 WS-SAVE-DRFT-CURR-STATUS                                   
P805CS                               PIC X(01) VALUE SPACES.            
P805CS    05 WS-SAVE-DRFT-ELIGIBLE   PIC X(01) VALUE SPACES.            
P805CS    05 WS-SAVE-DRFT-REJECTED   PIC X(01) VALUE SPACES.            
P805CS    05 WS-SAVE-AR-CURR-STATUS  PIC X(01) VALUE SPACES.            
P805CS    05 WS-SAVE-AR-ELIGIBLE     PIC X(01) VALUE SPACES.            
P805CS    05 WS-SAVE-AR-REJECTED     PIC X(01) VALUE SPACES.            
P805CS    05 WS-NEW-CSC-CORE-RATE    PIC X(01) VALUE SPACES.            
P805CS    05 WS-TOT-CSC-DSCNT-AMT    PIC S9(9)V9(2) COMP-3 VALUE 0.     
P805CS    05 WS-CSC-PLDSC-CD         PIC X(01) VALUE SPACES.            
P805CS    05 WS-CSC-PLDSC-AMT        PIC S9(9)V9(2) COMP-3 VALUE 0.     
P805CS    05 WS-CSC-ARDSC-CD         PIC X(01) VALUE SPACES.            
P805CS    05 WS-CSC-ARDSC-AMT        PIC S9(9)V9(2) COMP-3 VALUE 0.     
P805CS    05 WS-RULE-XREF-ID         PIC X(26) VALUE SPACES.            
P805CS    05 WS-RULE-RESULT-CD       PIC X(10) VALUE SPACES.            
P805CS    05 WS-RULE-ID              PIC X(10) VALUE SPACES.            
P805CS    05 WS-COMP-NO              PIC X(02) VALUE SPACES.            
P805CS    05 WS-RULE-MESSAGE-ID      PIC X(10) VALUE SPACES.            
P805CS    05 BUS-RULE-SW             PIC X(01) VALUE 'Y'.               
P805CS       88 BUS-RULE-NOT-FOUND             VALUE 'N'.               
P805CS       88 BUS-RULE-FOUND                 VALUE 'Y'.               
P805CS    05 END-SEARCH-SW           PIC X(01) VALUE 'Y'.               
P805CS       88 NOT-END-OF-SEARCH              VALUE 'N'.               
P805CS       88 END-OF-SEARCH                  VALUE 'Y'.               
      *                                                                         
P805CS 01 WS-RULES-TABLE.                                               
P805CS    05 BUS-RULES               OCCURS 25                          
P805CS                               INDEXED BY BUS-RULE-INDX.          
P805CS       10 BUS-RULE-ID          PIC X(10).                         
P805CS       10 BUS-RULE-XREF-ID     PIC X(26).                         
P805CS       10 BUS-RULE-COMPANY-NO  PIC X(02).                         
P805CS       10 BUS-RULE-MESSAGE-ID  PIC X(10).                         
P805CS       10 BUS-RULE-RESULT-CD   PIC X(10).                         
      *                                                                         
      ******************************************************************        
      * CSR04344/CSR04620 - BBP ELIGIBLE                               *        
      ******************************************************************        
                                                                        
       01 BBP-CALL-DATA.                                                
          05 IN-ACCOUNT-NO           PIC X(13) VALUE SPACES.            
          05 IN-ELIGIBLE             PIC X(01) VALUE SPACES.            
                                                                        
       01 BBP-RETURN-DATA.                                              
          05 BBP-RETURN-CODE         PIC S9(9) COMP VALUE 0.            
          05 BBP-ELIGIBLE            PIC X(01) VALUE SPACES.            
                                                                        
ACT001 01 WS-4872-CALL-DATA.                                            
ACT001    05 IN-PARM-TYPE            PIC X(01) VALUE SPACES.            
ACT001    05 IN-GUID                 PIC X(36) VALUE SPACES.            
                                                                        
ACT001 01 WS-4872-RETURN-DATA.                                          
ACT001    05 WS-4872-RETURN-CD       PIC S9(9) COMP VALUE 0.            
ACT001    05 WS-4872-ACCOUNT-NO      PIC X(13) VALUE SPACES.            
ACT001    05 WS-4872-GUID            PIC X(36) VALUE SPACES.            
ACT001    05 WS-4872-ELIGIBILITY-FL  PIC X(01) VALUE SPACES.            
ACT001*                                                                         
       01 WS-COUNTERS.                                                  
          05 CTR-ROWS                PIC S9(9) COMP VALUE 0.            
                                                                        
ACT001 01 WS-MISC.                                                      
ACT001    05 WS-ZERO                 PIC S9(4) VALUE 0.                 
ACT001    05 WS-YES                  PIC X(01) VALUE 'Y'.               
ACT001    05 WS-NO                   PIC X(01) VALUE 'N'.               
ACT001    05 WS-INDUSTRIAL           PIC X(01) VALUE 'I'.               
ACT001    05 WS-ACTIVE               PIC X(01) VALUE 'A'.               
ACT001    05 WS-PENDING              PIC X(01) VALUE 'P'.               
ACT001    05 WS-FINAL-BILLED         PIC X(01) VALUE 'B'.               
ACT001    05 WS-WRITTEN-OFF          PIC X(01) VALUE 'S'.               
ACT001    05 WS-INITIATED-FROM-WEB   PIC X(02) VALUE '02'.              
ACT001    05 WS-APPLIES-TO-EPAY-M    PIC X(01) VALUE 'M'.               
ACT001    05 WS-APPLIES-TO-EPAY-N    PIC X(01) VALUE 'N'.               
ACT001    05 WS-E-DRAFT              PIC X(01) VALUE 'D'.               
ACT001    05 WS-EPAY                 PIC X(01) VALUE 'E'.               
ACT001    05 WS-NO-BANK-DRAFT        PIC X(01) VALUE 'N'.               
ACT001    05 WS-BANK-DRAFT           PIC X(01) VALUE 'Y'.               
ACT001    05 WS-REGISTERED           PIC X(01) VALUE 'R'.               
ACT001    05 WS-INELIGIBLE           PIC X(01) VALUE 'I'.               
ACT001    05 WS-ELIGIBLE             PIC X(01) VALUE 'E'.               
A05460    05 WS-INCOMPLETE           PIC X(01) VALUE 'E'.               
      *                                                                         
       01 WS-SWITCHES.                                                  
          05 SEND-DONE-SW            PIC X(01) VALUE 'Y'.               
             88 SEND-DONE-ERROR                VALUE 'N'.               
             88 SEND-DONE-OK                   VALUE 'Y'.               
      *                                                                         
          05 WS-RETURN-CODE          PIC S9(4) COMP VALUE 0.            
      *                                                                         
       01 GTT-RETURN-FIELDS.                                            
          10 S-RETURN-CODE           PIC S9(4) COMP VALUE 0.            
          10 S-ATTRIBUTE             PIC X(20) VALUE SPACES.            
          10 S-CURR-STATUS           PIC X(01) VALUE SPACES.            
          10 S-ELIGIBLE              PIC X(01) VALUE SPACES.            
          10 S-REJECTED              PIC X(01) VALUE SPACES.            
P805CS    10 S-CSC-DSCNT-ELIGIBLE    PIC X(01) VALUE SPACES.            
P805CS    10 S-CSC-DSCNT-ICON-TYPE   PIC X(01) VALUE SPACES.            
P805CS    10 S-BUS-RULE-ID           PIC X(10) VALUE SPACES.            
P805CS    10 S-BUS-RULE-RESULT-CD    PIC X(10) VALUE SPACES.            
P805CS    10 S-BUS-RULE-XREF-ID      PIC X(26) VALUE SPACES.            
P805CS    10 S-MESSAGE-PARMS.                                           
P805CS       49 S-MESSAGE-PARMS-LEN  PIC S9(4) COMP SYNC VALUE +0.      
P805CS       49 S-MESSAGE-PARMS-TEXT PIC X(300) VALUE SPACES.           
P805CS    10 S-MESSAGE-HEADER        PIC X(200) VALUE SPACES.           
      *                                                                         
      ******************************************************************        
      *               COBOL WORKING STORAGE COPY BOOKS                 *        
      ******************************************************************        
      *                                                                         
P805CS***  DISCOUNT ELIGIBILITY ROUTINE WS COPYBOOK(S)                          
P805CS*                                                                         
P805CS     EXEC SQL                                                             
P805CS         INCLUDE CWS0444E                                                 
P805CS     END-EXEC.                                                            
P805CS*                                                                         
P805CS     COPY CWS00444.                                                       
P805CS*                                                                         
      ******************************************************************        
      *    ERROR HANDLING                                                       
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    SUPPORTS DB2 AND SQL ERROR CHECKING                         *        
      ******************************************************************        
      *                                                                         
           COPY CWS00303.                                                       
      *                                                                         
      ******************************************************************        
      *    COPYBOOK FOR CWS00309                                       *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWS00309                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    COPYBOOK FOR CPD04353                                       *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWS04353                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *   SQL COMMUNICATION AREA                                       *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_AR_CNTL  - AC                                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBARCNTL                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_ACCOUNT  - AT                                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      *                                                                         
OTPOOL******************************************************************02620000
OTPOOL*    CSS_LOCAL_OFFICE - B1                                       *02630000
OTPOOL******************************************************************02640000
OTPOOL*                                                                 02650000
OTPOOL     EXEC SQL                                                     02660000
OTPOOL          INCLUDE TBLOCOFC                                        02670000
OTPOOL     END-EXEC.                                                    02680000
OTPOOL*                                                                 02690000
      ******************************************************************        
      *    CSS_BANK_EFT  - BE                                          *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBBNKEFT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_CUST_STATS  - CE                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCSTSTS                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_CHRG_OFF - CO                                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCHGOFF                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************04700490
      *    CSS_CREDIT_PROFILE - CZ                                     *04700491
      ******************************************************************04700492
           EXEC SQL                                                     04700500
              INCLUDE TBCRPROF                                          04700600
           END-EXEC.                                                    04700700
      *                                                                 04710000
      ******************************************************************        
      *    CSS_DELINQUENCY - C8                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_ACCT_RTPK_AGR - DF                                      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBACCTRG                                                  
           END-EXEC.                                                            
      *                                                                         
I02262******************************************************************00510000
I02262*    CRM_RT_PKG_OFFER - FG                                       *00520000
I02262******************************************************************00530000
I02262     EXEC SQL                                                     00540000
I02262        INCLUDE TBRTPOFF                                          00550000
I02262     END-EXEC.                                                    00560000
I02262*                                                                 00570000
      ******************************************************************        
      *    CSS_FINAL_WO      - FW                                      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBFINLWO                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_AR_TYPE  - L5                                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBARTYPE                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_EDI_ACCT_DEST - NF                                      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBACDEST                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_PNDNG_BNK_DRFT - PB                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBPDBKDF                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_UTIL_ENVRMNT - UT                                       *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_ACCT_ATTRIBUTE - YP                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     00819000
              INCLUDE TBACTATT                                                  
           END-EXEC.                                                    00821000
      *                                                                 00986900
      ******************************************************************        
      *    CSS_SERVICE_PROMO -  3A                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     00819000
              INCLUDE TBSERPRM                                                  
           END-EXEC.                                                    00821000
      *                                                                 00986900
      ******************************************************************        
      *    CSS_REG_PFOFILE    - LR                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     00819000
              INCLUDE TBREGPRF                                                  
           END-EXEC.                                                    00821000
      *                                                                 00986900
      ******************************************************************        
PRJ836*    CSS_BILLING_DET,     BG                                     *        
PRJ836******************************************************************        
PRJ836*                                                                 00986900
PRJ836     EXEC SQL                                                             
PRJ836        INCLUDE TBBLLDET                                                  
PRJ836     END-EXEC.                                                            
      *                                                                 00986900
P805CS******************************************************************01610000
P805CS*    CSS_ACCT_MKT_TIER, DD                                       *01620000
P805CS******************************************************************01630000
P805CS*                                                                 00986900
P805CS     EXEC SQL                                                             
P805CS        INCLUDE TBMKTIER                                                  
P805CS     END-EXEC.                                                            
P805CS*                                                                 00986900
P805CS******************************************************************01610000
P805CS*    CSS_BUS_RULE_XREF, 1T                                       *01620000
P805CS******************************************************************01630000
P805CS*                                                                 00986900
P805CS     EXEC SQL                                                             
P805CS        INCLUDE TBRULXRF                                                  
P805CS     END-EXEC.                                                            
P805CS*                                                                 00986900
P805CS******************************************************************01610000
P805CS*    CSS_BUS_RULE_ACTN, 1S                                       *01620000
P805CS******************************************************************01630000
P805CS*                                                                 00986900
P805CS     EXEC SQL                                                             
P805CS        INCLUDE TBRULACT                                                  
P805CS     END-EXEC.                                                            
P805CS*                                                                 00986900
P805CS******************************************************************01260000
P805CS*    CURSOR DECLARATIONS                                         *01270000
P805CS******************************************************************01280000
P805CS*                                                                 00986900
P805CS     EXEC SQL                                                     
P805CS          DECLARE RULE-CURSOR CURSOR FOR                          
P805CS           SELECT [1T].BUS_RULE_ID                                  
P805CS                 ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           [1T].BUS_RULE_XREF_ID, 121), ' ', '-'), ':', '.') 
           BUS_RULE_XREF_ID                             
P805CS                 ,[1T].COMPANY_NO                                   
P805CS                 ,[1S].RULE_MESSAGE_ID                              
P805CS                 ,[1S].RULE_RESULT_CD                               
P805CS             FROM CSS_BUS_RULE_XREF  [1T] WITH(READUNCOMMITTED)           
P805CS             JOIN CSS_BUS_RULE_ACTN  [1S] WITH(READUNCOMMITTED)           
P805CS               ON [1S].BUS_RULE_XREF_ID =  [1T].BUS_RULE_XREF_ID      
P805CS            WHERE [1T].BUS_PROCESS_ID   = 'PROFILE'                 
P805CS              AND [1T].APPLICATION_ID   = 'CSR'                     
P805CS              AND [1T].BUS_RULE_ID   LIKE 'PROMOTE%'                
P805CS                                                           
P805CS              FOR READ ONLY                                      
P805CS                                                      
P805CS     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE RULE-CURSOR CURSOR FOR                                  
MFA-TR*          SELECT 1T.BUS_RULE_ID                                          
MFA-TR*                ,1T.BUS_RULE_XREF_ID                                     
MFA-TR*                ,1T.COMPANY_NO                                           
MFA-TR*                ,1S.RULE_MESSAGE_ID                                      
MFA-TR*                ,1S.RULE_RESULT_CD                                       
MFA-TR*            FROM CSS_BUS_RULE_XREF  1T                                   
MFA-TR*            JOIN CSS_BUS_RULE_ACTN  1S                                   
MFA-TR*              ON 1S.BUS_RULE_XREF_ID =  1T.BUS_RULE_XREF_ID              
MFA-TR*           WHERE 1T.BUS_PROCESS_ID   = 'PROFILE'                         
MFA-TR*             AND 1T.APPLICATION_ID   = 'CSR'                             
MFA-TR*             AND 1T.BUS_RULE_ID   LIKE 'PROMOTE%'                        
MFA-TR*            WITH UR                                                      
MFA-TR*             FOR FETCH ONLY                                              
MFA-TR*         QUERYNO 7001                                                    
MFA-TR*    END-EXEC.                                                            
P805CS*                                                                         
      ******************************************************************        
      * WORKING STORAGE COPYBOOKS FOR CPD04353                         *        
      ******************************************************************        
      *                                                                         
          COPY CWS00056.                                                        
      *                                                                         
      *01 LOC4620 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC4344 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC4872 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *                                                                         
       01  WS-END                        PIC X(40)                      
           VALUE 'WORKING STORAGE FOR CSR04624 ENDS HERE  '.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_4620 CURSOR
MSQ001          FOR CALL CSR04620                                          
                  ( :IN-ACCOUNT-NO
                  , :IN-ELIGIBLE
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_4344 CURSOR
MSQ001          FOR CALL CSR04344                                          
                  ( :IN-ACCOUNT-NO
                  , :IN-ELIGIBLE
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_4872 CURSOR
MSQ001          FOR CALL CSR04872                                          
ACT001            ( :IN-PARM-TYPE
                  , :IN-ACCOUNT-NO
                  , :IN-GUID
                  )
MSQ001        END-EXEC.
            
      *                                                                         
       LINKAGE SECTION.                                                 
       01  PARM-ACCOUNT-NO               PIC X(13).                     
PRJ836 01  PARM-APPL-PROG-ID             PIC X(03).                     
      *                                                                         
       PROCEDURE DIVISION USING PARM-ACCOUNT-NO,                        
PRJ836                          PARM-APPL-PROG-ID.                      
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE       THRU 0100-EXIT.                
           PERFORM 1000-PROCESS-INPUT    THRU 1000-EXIT.                
           PERFORM 2000-PROCESS-OUTPUT   THRU 2000-EXIT.                
           PERFORM 9999-END-PROGRAM      THRU 9999-EXIT.                
           
MSQ016        GOBACK.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           PERFORM 0100A-DECLARE-GTT     THRU 0100A-EXIT.               
      *                                                                         
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT *                                                
                  FROM #CSR04624_R1                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT *                                                        
MFA-TR*           FROM SESSION.CSR04624_R1                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100A-DECLARE-GTT                                              *        
      ******************************************************************        
      *                                                                         
       0100A-DECLARE-GTT.                                               
      *                                                                         
           MOVE 'SESSION.CSR04624_R1'    TO WS-GTT-NAME.                
      *                                                                         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04624_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04624_R1
              (                                                       
                    RETURN_CODE                 INT                 
                   ,ATTRIBUTE_NAME CHAR(20)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                
                   ,ATTRIBUTE_CURRENT_STATUS CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                
                   ,ATTRIBUTE_ELIGIBLE CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                
                   ,ATTRIBUTE_REJECTED CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                
P805CS             ,ATTR_CSC_DSCNT_ELIGIBLE CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                
P805CS             ,ATTR_CSC_DSCNT_ICON_TYPE CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                
P805CS             ,BUS_RULE_ID CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                
P805CS             ,RULE_RESULT_CD CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                
P805CS             ,BUS_RULE_XREF_ID CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                
P805CS             ,MESSAGE_PARMS VARCHAR(300)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2            
P805CS             ,MESSAGE_HEADER CHAR(200)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2               
                )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLSTATE                 TO WS-SQLSTATE.                
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE.              
      *                                                                         
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS THRU 8000A-EXIT                
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
                 MOVE '0100A'            TO ACTIVE-PARAGRAPH            
                 MOVE SQLCODE            TO ABEND-SQLCODE               
                 MOVE SQLSTATE           TO ABEND-SQLSTATE              
                 MOVE 'DECLARE GTT'      TO ABEND-FUNCTION              
                 MOVE SPACES             TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                 MOVE WS-GTT-NAME        TO TABLE-1                     
                 MOVE SPACES             TO TABLE-ELEMENT-1             
                 MOVE SPACES             TO HOSTVAR-ELEMENT-1           
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
      *                                                                 12256100
       0100A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 1000-PROCESS-INPUT.                                            *        
      ******************************************************************        
      *                                                                         
        1000-PROCESS-INPUT.                                             
                                                                        
           MOVE PARM-ACCOUNT-NO           TO WS-ACCOUNT-NO.             
PRJ836     MOVE PARM-APPL-PROG-ID         TO WS-APPL-PROG-ID.           
           MOVE WS-ACCOUNT-NUM            TO AT-ACCOUNT-NO              
                                             YP-ACCOUNT-NO              
                                             BE-ACCOUNT-NO              
                                             NF-ACCOUNT-NO              
                                             PB-ACCOUNT-NO              
                                             LR-ACCOUNT-NO              
                                             DF-ACCOUNT-NO              
P805CS                                       UT-ACCOUNT-NO              
P805CS                                       DD-ACCOUNT-NO              
PRJ836                                       BG-ACCOUNT-NO              
ACT083                                       IN-ACCOUNT-NO.             
                                                                        
           PERFORM 7000-SELECT-ACCOUNT       THRU 7000-EXIT.            
           MOVE AT-CODES-DATA-PRESENT     TO WS-CODES-DATA-PRESENT.     
                                                                        
           MOVE 'DATABASE'                TO C8-DELINQ-CD.              
           PERFORM 7100-GET-DELINQUENCY      THRU 7100-EXIT.            
           MOVE C8-DELINQ-VALUE           TO WS-DATABASE.               
      *                                                                         
P805CS     IF SEB-DATABASE                                              
P805CS        SET BUS-RULE-INDX           TO 1                          
P805CS        PERFORM 7001-OPEN-RULE-CURSOR  THRU 7001-EXIT             
P805CS        PERFORM 7002-FETCH-RULE-CURSOR THRU 7002-EXIT             
P805CS        PERFORM 1010-LOAD-BUS-RULES    THRU 1010-EXIT             
P805CS          UNTIL WS-ACTIVE-RETURN-CODE  EQUAL NOT-FOUND            
P805CS        PERFORM 7003-CLOSE-RULE-CURSOR THRU 7003-EXIT             
P805CS     END-IF                                                       
      *                                                                         
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES  CURRENT DATE                                              
MFA-TR*         INTO :WS-CURRENT-DATE                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TS                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES  CURRENT TIMESTAMP                                         
MFA-TR*         INTO :WS-CURRENT-TS                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           EXEC SQL                                                     
               SELECT
              DATEADD( DAY, -30, IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )
            INTO
              :WS-CURRENT-DATE-30                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES  (DATE(:WS-CURRENT-DATE) - 30 DAYS)                       
MFA-TR*          INTO :WS-CURRENT-DATE-30                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           EXEC SQL                                                     
               SELECT
              DATEADD( DAY, -90, IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )
            INTO
              :WS-CURRENT-DATE-90                               
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES  (DATE(:WS-CURRENT-DATE) - 90 DAYS)                       
MFA-TR*          INTO :WS-CURRENT-DATE-90                                       
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
      *                                                                         
        1000-EXIT.                                                      
             EXIT.                                                      
      *                                                                         
P805CS******************************************************************        
P805CS* 1010-LOAD-BUS-RULES                                            *        
P805CS******************************************************************        
P805CS*                                                                         
P805CS 1010-LOAD-BUS-RULES.                                             
P805CS                                                                  
P805CS     MOVE 1T-BUS-RULE-ID      TO BUS-RULE-ID      (BUS-RULE-INDX).
P805CS     MOVE 1T-BUS-RULE-XREF-ID TO BUS-RULE-XREF-ID (BUS-RULE-INDX).
P805CS     MOVE 1T-COMPANY-NO       TO BUS-RULE-COMPANY-NO              
P805CS                                                  (BUS-RULE-INDX).
P805CS     MOVE 1S-RULE-MESSAGE-ID  TO BUS-RULE-MESSAGE-ID              
P805CS                                                  (BUS-RULE-INDX).
P805CS     MOVE 1S-RULE-RESULT-CD   TO BUS-RULE-RESULT-CD               
P805CS                                                  (BUS-RULE-INDX).
P805CS     SET BUS-RULE-INDX UP BY 1.                                   
P805CS     PERFORM 7002-FETCH-RULE-CURSOR THRU 7002-EXIT.               
P805CS                                                                  
P805CS 1010-EXIT.                                                       
P805CS     EXIT.                                                        
P805CS*                                                                         
      ******************************************************************        
      * 2000-PROCESS-OUTPUT                                            *        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
P805CS     IF SEB-DATABASE                                              
P805CS        PERFORM 7800-SELECT-MKT-TIER   THRU 7800-EXIT             
P805CS        IF DD-TIER-ACCT-TYPE-CD = 'D' OR 'A' OR 'B'               
P805CS           PERFORM 2050-VLDT-CSC-DSCNT-ELGBLTY                    
P805CS                                       THRU 2050-EXIT             
P805CS        END-IF                                                    
P805CS     END-IF.                                                      
      *                                                                         
           PERFORM 2100-BBP-ATTRIB           THRU 2100-EXIT.            
           PERFORM 2200-ONLINE-ATTRIB        THRU 2200-EXIT.            
           PERFORM 2300-PAPERLESS-ATTRIB     THRU 2300-EXIT.            
           PERFORM 2400-EPAY-ATTRIB          THRU 2400-EXIT.            
      *                                                                         
           IF SEB-DATABASE                                              
              PERFORM 2500-AUTORENEW-ATTRIB  THRU 2500-EXIT             
P805CS        IF DD-TIER-ACCT-TYPE-CD = 'D' OR 'A' OR 'B'               
P805CS           PERFORM 2750-CSC-DSCNT-ATTRIB                          
P805CS                                       THRU 2750-EXIT             
P805CS        END-IF                                                    
           END-IF.                                                      
      *                                                                         
PRJ836     IF WS-APPL-PROG-ID EQUAL 'WEB'                               
PRJ836        PERFORM 2600-BBP-CALC-ATTRIB   THRU 2600-EXIT             
PRJ836     END-IF.                                                      
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10740000
P805CS*****************************************************************         
P805CS*** VALIDATE CSC DISCOUNT ELIGIBILITY                         ***         
P805CS*****************************************************************         
P805CS*                                                                         
P805CS 2050-VLDT-CSC-DSCNT-ELGBLTY.                                     
P805CS*                                                                         
P805CS     MOVE '2050'                    TO ACTIVE-PARAGRAPH.          
P805CS*                                                                         
P805CS     MOVE WS-ACCOUNT-NO             TO WS-444-I-ACCT-NO.          
P805CS     MOVE PROGRAM-NAME              TO WS-444-I-PGM-ID.           
P805CS     MOVE SPACES                    TO WS-444-I-USER-ID.          
P805CS*                                                                         
P805CS     PERFORM 6000-CPD444-CSC-DISCOUNT-ELIG                        
P805CS                                       THRU 6000-CPD444-EXIT.     
P805CS*                                                                         
P805CS     EVALUATE WS-ACTIVE-RETURN-CODE                               
P805CS         WHEN 0                                                   
P805CS            PERFORM 2055-PROCESS-CSC-DSCNTS                       
P805CS                                       THRU 2055-EXIT             
P805CS               VARYING WS-444-S FROM 1 BY 1                       
P805CS                 UNTIL WS-444-S > 10                              
P805CS                    OR WS-444-O-DISC-CD (WS-444-S) = SPACES       
P805CS         WHEN 999                                                 
P805CS            MOVE 0                  TO WS-ACTIVE-RETURN-CODE      
P805CS         WHEN OTHER                                               
P805CS            PERFORM 6999-CPD444-ERROR-ROUTINE                     
P805CS                                       THRU 6999-CPD444-EXIT      
P805CS     END-EVALUATE.                                                
P805CS*                                                                         
P805CS 2050-EXIT.                                                       
P805CS     EXIT.                                                        
P805CS*                                                                         
P805CS*****************************************************************         
P805CS*** PROCESS CSC DISCOUNTS                                     ***         
P805CS*****************************************************************         
P805CS*                                                                         
P805CS 2055-PROCESS-CSC-DSCNTS.                                         
P805CS*                                                                         
P805CS     EVALUATE WS-444-O-DISC-CD (WS-444-S)                         
P805CS         WHEN 'PAPERLESS'                                         
P805CS            EVALUATE TRUE                                         
P805CS                WHEN WS-444-O-ELIG-FL       (WS-444-S) = 'Y'      
A05724****************WHEN WS-444-O-RECV-FL       (WS-444-S) = 'Y'              
P805CS                   MOVE 'R'         TO WS-CSC-PLDSC-CD            
P805CS                   MOVE WS-444-O-FACTOR     (WS-444-S)            
P805CS                                    TO WS-CSC-PLDSC-AMT           
P805CS                WHEN WS-444-O-PROMOTE-FL    (WS-444-S) = 'Y'      
P805CS                   MOVE 'E'         TO WS-CSC-PLDSC-CD            
P805CS                   MOVE WS-444-O-DELINQ-VAL (WS-444-S)            
P805CS                                    TO WS-CSC-PLDSC-AMT           
P805CS                WHEN OTHER                                        
P805CS                   MOVE 'N'         TO WS-CSC-PLDSC-CD            
P805CS             END-EVALUATE                                         
P805CS         WHEN 'AUTORENEW'                                         
P805CS            EVALUATE TRUE                                         
P805CS                WHEN WS-444-O-ELIG-FL       (WS-444-S) = 'Y'      
A05724****************WHEN WS-444-O-RECV-FL       (WS-444-S) = 'Y'              
P805CS                   MOVE 'R'         TO WS-CSC-ARDSC-CD            
P805CS                   MOVE WS-444-O-FACTOR     (WS-444-S)            
P805CS                                    TO WS-CSC-ARDSC-AMT           
P805CS                WHEN WS-444-O-PROMOTE-FL    (WS-444-S) = 'Y'      
P805CS                   MOVE 'E'         TO WS-CSC-ARDSC-CD            
P805CS                   MOVE WS-444-O-DELINQ-VAL (WS-444-S)            
P805CS                                    TO WS-CSC-ARDSC-AMT           
P805CS                WHEN OTHER                                        
P805CS                   MOVE 'N'         TO WS-CSC-ARDSC-CD            
P805CS             END-EVALUATE                                         
P805CS     END-EVALUATE.                                                
P805CS*                                                                         
P805CS 2055-EXIT.                                                       
P805CS     EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2100-BBP-ATTRIB.                                               *        
      ******************************************************************        
      *                                                                         
       2100-BBP-ATTRIB.                                                 
      *                                                                         
           INITIALIZE GTT-RETURN-FIELDS.                                
P805CS     MOVE 'N'                       TO S-CSC-DSCNT-ELIGIBLE       
           MOVE 'Budget Billing'          TO S-ATTRIBUTE                
                                                                        
           IF WS-CODE-BUDGET = 'A'                                      
              MOVE WS-YES                 TO S-CURR-STATUS              
              MOVE WS-NO                  TO S-ELIGIBLE                 
              MOVE WS-NO                  TO S-REJECTED                 
           ELSE                                                         
              MOVE WS-NO                  TO S-CURR-STATUS              
              MOVE WS-ACCOUNT-NUM         TO IN-ACCOUNT-NO              
              MOVE 'E'                    TO IN-ELIGIBLE                
                                                                        
              IF CSR-DATABASE                                           
                 PERFORM 2150-CALL-CSR04620  THRU 2150-EXIT             
              ELSE                                                      
                 PERFORM 2155-CALL-CSR04344  THRU 2155-EXIT             
              END-IF                                                    
              MOVE BBP-ELIGIBLE           TO S-ELIGIBLE                 
                                                                        
              MOVE 'N'                    TO WS-BBP-REJECTED            
              MOVE 'BBP_REJECTED'         TO YP-ATTRIBUTE-DESC          
              PERFORM 7500-SELECT-ATTR-CD    THRU 7500-EXIT             
                                                                        
              IF YP-ATTRIBUTE-VALUE-CD = 'BBPRJ'                        
                 MOVE WS-YES              TO WS-BBP-REJECTED            
              END-IF                                                    
              MOVE WS-BBP-REJECTED        TO S-REJECTED                 
           END-IF.                                                      
                                                                        
           MOVE ZERO                      TO S-RETURN-CODE.             
           PERFORM 8010-INSERT-GTT-R1        THRU 8010-EXIT.            
                                                                        
        2100-EXIT.                                                      
             EXIT.                                                      
      *                                                                         
      ******************************************************************        
      * 2200-ONLINE-ATTRIB.                                            *        
      ******************************************************************        
      *                                                                         
       2200-ONLINE-ATTRIB.                                              
      *                                                                         
           INITIALIZE GTT-RETURN-FIELDS.                                
P805CS     MOVE 'N'                       TO S-CSC-DSCNT-ELIGIBLE       
           MOVE 'Online Account'          TO S-ATTRIBUTE                
           MOVE AT-CUSTOMER-NO            TO CE-CUSTOMER-NO             
           PERFORM 7630-CUST-STATS           THRU 7630-EXIT             
           IF CE-EBILL-REGISTER-IND = 'Y'                               
              MOVE WS-YES                 TO S-CURR-STATUS              
              MOVE WS-NO                  TO S-ELIGIBLE                 
              MOVE WS-NO                  TO S-REJECTED                 
           ELSE                                                         
              MOVE WS-NO                  TO S-CURR-STATUS              
ACT001        IF (AT-CODE-ACCT-STAT EQUAL WS-ACTIVE OR                  
ACT001            AT-CODE-ACCT-STAT EQUAL WS-PENDING )                  
ACT001           PERFORM 2201-DETERMINE-ONLINE                          
ACT001                                       THRU 2201-EXIT             
ACT001           MOVE WS-ONLINE-FL        TO S-ELIGIBLE                 
ACT001           MOVE WS-ONLINE-REJECTED  TO S-REJECTED                 
ACT001        ELSE                                                      
ACT001           MOVE WS-NO               TO S-ELIGIBLE                 
ACT001           MOVE WS-NO               TO S-REJECTED                 
ACT001        END-IF                                                    
           END-IF.                                                      
                                                                        
           MOVE ZERO                      TO S-RETURN-CODE.             
           PERFORM 8010-INSERT-GTT-R1        THRU 8010-EXIT.            
      *                                                                         
        2200-EXIT.                                                      
             EXIT.                                                      
      ******************************************************************        
      * 2201-DETERMINE-ONLINE.                                         *        
      ******************************************************************        
      *                                                                         
        2201-DETERMINE-ONLINE.                                          
                                                                        
           MOVE AT-CUSTOMER-NO            TO 3A-CUSTOMER-NO             
           MOVE 'ONLINE_ENROLL_ENABLE'    TO C8-DELINQ-CD.              
           MOVE AT-COMPANY-NO             TO C8-COMPANY-NO.             
           PERFORM 7100-GET-DELINQUENCY      THRU 7100-EXIT.            
           MOVE 'PROMO_ONLINE_ENROLL'     TO 3A-PROMO-OFFERED-SERV      
                                             C8-DELINQ-CD.              
           MOVE WS-NO                     TO WS-ONLINE-FL               
           MOVE WS-NO                     TO WS-ONLINE-REJECTED         
                                             WS-REGISTRATION-FL.        
           IF C8-DELINQ-VALUE NOT = 2                                   
              PERFORM 2210-STATUS-PROCESSING THRU 2210-EXIT             
           END-IF.                                                      
                                                                        
           IF WS-REGISTRATION-FL = WS-NO                                
              NEXT SENTENCE                                             
           ELSE                                                         
              PERFORM 2215-ONLINE-ENROLL-DETAILS                        
                                             THRU 2215-EXIT             
           END-IF.                                                      
                                                                        
        2201-EXIT.                                                      
             EXIT.                                                      
      *                                                                         
      ******************************************************************        
      * 2210-STATUS-PROCESSING.                                        *        
      ******************************************************************        
       2210-STATUS-PROCESSING.                                          
                                                                        
           PERFORM 7640-SELECT-FINAL-WO      THRU 7640-EXIT.            
           PERFORM 7650-SELECT-SO-DATA       THRU 7650-EXIT.            
           EVALUATE AT-CODE-ACCT-STAT                                   
               WHEN WS-ACTIVE                                           
                  MOVE WS-YES             TO WS-REGISTRATION-FL         
               WHEN WS-PENDING                                          
                  IF SEB-DATABASE                                       
                     IF AT-ACCT-CREATE-DT >= WS-CURRENT-DATE-90         
                        MOVE WS-YES       TO WS-REGISTRATION-FL         
                     END-IF                                             
                  ELSE                                                  
                     IF WS-CC-NC-FL = WS-YES                            
                        MOVE WS-YES       TO WS-REGISTRATION-FL         
                     END-IF                                             
                  END-IF                                                
               WHEN WS-FINAL-BILLED                                     
                  IF (AT-TOTAL-AR-BALANCE NOT = 0) OR                   
                     (AT-TOTAL-AR-BALANCE = 0 AND                       
                      AT-ACCT-FINALED-DT(1:10) >=                       
                      WS-CURRENT-DATE-30)                               
                      MOVE WS-YES         TO WS-REGISTRATION-FL         
                  END-IF                                                
               WHEN WS-WRITTEN-OFF                                      
                  IF CSR-DATABASE                                       
                     EXEC SQL                                           
                         SELECT
              DATEADD( YEAR, -6, CAST(SYSDATETIMEOFFSET() AS DATE) )
            INTO
              :WS-WOFF-DT            
                     END-EXEC                                           

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*              EXEC SQL                                                   
MFA-TR*                  SET :WS-WOFF-DT =                                      
MFA-TR*                      (DATE(CURRENT_DATE)  - 6 YEARS)                    
MFA-TR*              END-EXEC                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                     IF AT-ACCT-FINALED-DT(1:10) >= WS-WOFF-DT          
                        PERFORM 7620-CHARGE-OFF-AMT                     
                                             THRU 7620-EXIT             
                        IF CO-AMT-TRANS > 0                             
                            MOVE WS-YES   TO WS-REGISTRATION-FL         
                        END-IF                                          
                     END-IF                                             
                  ELSE                                                  
                     MOVE '1900-01-01'    TO WS-WOFF-DT                 
                     PERFORM 7620-CHARGE-OFF-AMT                        
                                             THRU 7620-EXIT             
                     IF CO-AMT-TRANS > 0                                
                        IF FW-COLLECT-STATUS-CD = 'D' OR 'E'            
                           MOVE WS-NO     TO WS-REGISTRATION-FL         
                        ELSE                                            
                           MOVE WS-YES    TO WS-REGISTRATION-FL         
                        END-IF                                          
                     END-IF                                             
                  END-IF                                                
           END-EVALUATE.                                                
                                                                        
       2210-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 2215-ONLINE-ENROLL-DETAILS.                                    *        
      ******************************************************************        
       2215-ONLINE-ENROLL-DETAILS.                                      
                                                                        
           IF AT-LOCAL-OFFICE = '301' OR '303'                          
              MOVE 'Y' TO WS-SC-LOCAL-OFFICE-FL                         
           END-IF.                                                      
           IF (CE-EBILL-REGISTER-IND NOT = WS-YES) AND                  
              (AT-MST-SUB-ACCT-IND NOT = 'S') AND                       
              (WS-SC-LOCAL-OFFICE-FL NOT = 'Y')                         
                  PERFORM 7600-PROMO-RESPONSE THRU 7600-EXIT            
                  IF 3A-PROMO-CHOICE-CD = WS-NO                         
                      PERFORM 7100-GET-DELINQUENCY  THRU 7100-EXIT      
                      EXEC SQL                                          
                          SELECT
              CIS.DAYS( IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) ) -
                                                CIS.DAYS( 
              IIF(TRY_CONVERT(DATE, :WS-PROMO-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-PROMO-DT
              ) <> 0) OR (LEN(:WS-PROMO-DT) <> 10), CIS.CHAR2DATE(
                                                           :WS-PROMO-DT
              ), CONVERT(DATE, :WS-PROMO-DT) ) )
            INTO
              :WS-EXPIRE-DAYS      
                      END-EXEC                                          

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*               EXEC SQL                                                  
MFA-TR*                   SET :WS-EXPIRE-DAYS = DAYS(:WS-CURRENT-DATE) -        
MFA-TR*                                         DAYS(:WS-PROMO-DT)              
MFA-TR*               END-EXEC                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                      IF WS-EXPIRE-DAYS > C8-DELINQ-VALUE               
                          MOVE WS-YES TO WS-ONLINE-FL                   
                      ELSE                                              
                          MOVE WS-YES TO WS-ONLINE-REJECTED             
                      END-IF                                            
                  ELSE                                                  
                      MOVE WS-YES TO WS-ONLINE-FL                       
                  END-IF                                                
            END-IF.                                                     
                                                                        
       2215-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 2300-PAPERLESS-ATTRIB.                                         *        
      ******************************************************************        
      *                                                                         
       2300-PAPERLESS-ATTRIB.                                           
      *                                                                         
           INITIALIZE GTT-RETURN-FIELDS.                                
P805CS     MOVE 'N'                         TO S-CSC-DSCNT-ELIGIBLE     
           MOVE 'Paperless Billing'         TO S-ATTRIBUTE              
           IF AT-NO-BILL-COPIES EQUAL 0                                 
              MOVE 'Y'                      TO S-CURR-STATUS            
              MOVE 'N'                      TO S-ELIGIBLE               
              MOVE 'N'                      TO S-REJECTED               
           ELSE                                                         
              MOVE WS-NO                    TO S-CURR-STATUS            
ACT001        IF AT-NO-BILL-COPIES NOT EQUAL WS-ZERO AND                
ACT001           (AT-CODE-ACCT-STAT EQUAL  WS-ACTIVE  OR                
ACT001            AT-CODE-ACCT-STAT EQUAL  WS-PENDING )                 
ACT001           MOVE WS-YES                TO  S-ELIGIBLE              
ACT001           MOVE WS-NO                    TO WS-PAPERLESS-REJECTED 
ACT001           MOVE 'PAPERLESS_REJECTED'     TO YP-ATTRIBUTE-DESC     
ACT001           PERFORM 7500-SELECT-ATTR-CD   THRU 7500-EXIT           
ACT001           IF YP-ATTRIBUTE-VALUE-CD = 'PPRRJ'                     
ACT001              MOVE WS-YES                TO WS-PAPERLESS-REJECTED 
ACT001           END-IF                                                 
ACT001           MOVE WS-PAPERLESS-REJECTED    TO S-REJECTED            
ACT001        ELSE                                                      
ACT001           MOVE WS-NO                 TO  S-ELIGIBLE              
ACT001        END-IF                                                    
ACT001     END-IF.                                                      
PRJ836                                                                  
PRJ836     IF AT-MST-SUB-ACCT-IND = 'S'                                 
PRJ836        MOVE WS-NO                    TO S-ELIGIBLE               
PRJ836     END-IF.                                                      
PRJ836                                                                  
P805CS     IF (WS-CSC-PLDSC-CD  = 'R' OR 'E')                           
P805CS         AND S-ELIGIBLE   = 'Y'                                   
P805CS        MOVE 'Y'                      TO S-CSC-DSCNT-ELIGIBLE     
P805CS        MOVE 'G'                      TO S-CSC-DSCNT-ICON-TYPE    
P805CS     END-IF.                                                      
                                                                        
P805CS     MOVE S-CURR-STATUS               TO WS-SAVE-PL-CURR-STATUS.  
P805CS     MOVE S-ELIGIBLE                  TO WS-SAVE-PL-ELIGIBLE.     
P805CS     MOVE S-REJECTED                  TO WS-SAVE-PL-REJECTED.     
                                                                        
           MOVE    ZEROS                    TO S-RETURN-CODE.           
           PERFORM 8010-INSERT-GTT-R1       THRU 8010-EXIT.             
                                                                        
        2300-EXIT.                                                      
             EXIT.                                                      
      *                                                                         
      ******************************************************************        
      * 2400-EPAY-ATTRIB.                                              *        
      ******************************************************************        
      *                                                                         
       2400-EPAY-ATTRIB.                                                
      *                                                                         
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-NO TO WS-DRAFT-CD                                    
           PERFORM 7350-CHECK-EPAY THRU 7350-EXIT.                      
           PERFORM 7355-SELECT-CREDIT-PROFILE THRU 7355-EXIT.           
A05460     IF WS-CODE-BANK-EFT EQUAL WS-ACTIVE AND                      
A05460        BE-STATUS-CODE NOT EQUAL WS-INCOMPLETE                    
              MOVE WS-YES TO WS-DRAFT-CD                                
              IF BE-INIT-TYPE-CD EQUAL WS-INITIATED-FROM-WEB            
                 MOVE WS-E-DRAFT TO WS-DRAFT-CD                         
              END-IF                                                    
           ELSE                                                         
              EVALUATE BE-STATUS-CODE                                   
                WHEN WS-APPLIES-TO-EPAY-M                               
                WHEN WS-APPLIES-TO-EPAY-N                               
                    MOVE WS-EPAY TO WS-DRAFT-CD                         
                WHEN OTHER                                              
                    MOVE WS-NO-BANK-DRAFT TO WS-DRAFT-CD                
              END-EVALUATE                                              
           END-IF.                                                      
                                                                        
P805CS     MOVE 'N'                      TO S-CSC-DSCNT-ELIGIBLE        
ACT001     MOVE 'Bank Draft/eDraft'      TO S-ATTRIBUTE                 
           IF WS-DRAFT-CD EQUAL WS-BANK-DRAFT OR WS-E-DRAFT             
              MOVE WS-YES                TO S-CURR-STATUS               
              MOVE WS-NO                 TO S-ELIGIBLE                  
              MOVE WS-NO                 TO S-REJECTED                  
           ELSE                                                         
              MOVE WS-NO                 TO S-CURR-STATUS               
ACT197        IF AT-CODE-ACCT-STAT  = WS-ACTIVE  OR                     
ACT001            AT-ACCOUNT-TYPE-CODE EQUAL WS-INDUSTRIAL              
                 IF CZ-CASH-ONLY-FL = WS-YES                            
ACT001              MOVE WS-NO                TO S-ELIGIBLE             
ACT001              MOVE WS-NO                TO S-REJECTED             
                 ELSE                                                   
                    MOVE WS-YES               TO S-ELIGIBLE             
ACT001              MOVE WS-NO                TO WS-EPAY-REJECTED       
ACT001              MOVE 'BANKDRAFT_REJECTED' TO YP-ATTRIBUTE-DESC      
ACT001              PERFORM 7500-SELECT-ATTR-CD THRU 7500-EXIT          
ACT001              IF YP-ATTRIBUTE-VALUE-CD = 'EPYRJ'                  
ACT001                 MOVE WS-YES            TO WS-EPAY-REJECTED       
ACT001              END-IF                                              
ACT001              MOVE WS-EPAY-REJECTED     TO S-REJECTED             
                 END-IF                                                 
ACT001        ELSE                                                      
ACT001           MOVE WS-NO                   TO S-ELIGIBLE             
ACT001           MOVE WS-NO                   TO S-REJECTED             
ACT001        END-IF                                                    
           END-IF.                                                      
PRJ836                                                                  
PRJ836     IF AT-MST-SUB-ACCT-IND = 'S'                                 
PRJ836        MOVE WS-NO                    TO S-ELIGIBLE               
PRJ836     END-IF.                                                      
PRJ836                                                                  
P805CS     IF (WS-CSC-PLDSC-CD = 'E' OR 'R')                            
P805CS         AND S-ELIGIBLE  = 'Y'                                    
P805CS        MOVE 'Y'                      TO S-CSC-DSCNT-ELIGIBLE     
P805CS        IF WS-444-O-AUTOCARD-FL = 'Y'                             
P805CS           MOVE 'D'                   TO S-CSC-DSCNT-ICON-TYPE    
P805CS        ELSE                                                      
P805CS           MOVE 'G'                   TO S-CSC-DSCNT-ICON-TYPE    
P805CS        END-IF                                                    
P805CS     END-IF.                                                      
                                                                        
P805CS     MOVE S-CURR-STATUS               TO WS-SAVE-DRFT-CURR-STATUS.
P805CS     MOVE S-ELIGIBLE                  TO WS-SAVE-DRFT-ELIGIBLE.   
P805CS     MOVE S-REJECTED                  TO WS-SAVE-DRFT-REJECTED.   
                                                                        
           MOVE    ZEROS                    TO S-RETURN-CODE.           
           PERFORM 8010-INSERT-GTT-R1       THRU 8010-EXIT.             
                                                                        
        2400-EXIT.                                                      
             EXIT.                                                      
      *                                                                         
      ******************************************************************        
      * 2500-AUTORENEW-ATTRIB.                                         *        
      ******************************************************************        
      *                                                                         
       2500-AUTORENEW-ATTRIB.                                           
      *                                                                         
           INITIALIZE GTT-RETURN-FIELDS.                                
P805CS     MOVE 'N'                            TO S-CSC-DSCNT-ELIGIBLE  
                                                                        
           PERFORM 7200-GET-REG-ACCT-FL    THRU 7200-EXIT.              
ACT001*    Shopping Rewards not eligible for seb regulated customers.           
ACT001                                                                  
ACT001     IF WS-REG-ACCT-FL = 'Y'                                      
ACT001        MOVE 'Shopping Rewards'          TO S-ATTRIBUTE           
ACT001        MOVE 'N'                         TO S-CURR-STATUS         
ACT001        MOVE 'N'                         TO S-ELIGIBLE            
ACT001        MOVE 'N'                         TO S-REJECTED            
ACT001     ELSE                                                         
ACT001        PERFORM 2550-GET-SHOPPING-RWRDS     THRU 2550-EXIT        
              INITIALIZE GTT-RETURN-FIELDS                              
              MOVE 'AutoRenew'                 TO S-ATTRIBUTE           
              MOVE 'N'                         TO S-CURR-STATUS         
                                                  S-ELIGIBLE            
                                                  S-REJECTED            
                                                  S-CSC-DSCNT-ELIGIBLE  
P805CS        IF (AT-CODE-ACCT-STAT EQUAL  WS-ACTIVE OR                 
P805CS            AT-CODE-ACCT-STAT EQUAL  WS-PENDING )                 
                  PERFORM 7400-GET-AUTORENEW-IND  THRU 7400-EXIT        
                  MOVE 'N'                     TO WS-AUTORENEW-REJECTED 
                  MOVE 'AUTORENEW_REJE'        TO YP-ATTRIBUTE-DESC     
                  PERFORM 7500-SELECT-ATTR-CD  THRU 7500-EXIT           
                  IF YP-ATTRIBUTE-VALUE-CD = 'RENJR'                    
                     MOVE 'Y'                  TO WS-AUTORENEW-REJECTED 
                  END-IF                                                
                  MOVE WS-AUTORENEW-REJECTED   TO S-REJECTED            
                                                                        
                  EVALUATE DF-AUTO-REN-OPT-IN-FL                        
                     WHEN 'N'                                           
                          MOVE 'N'             TO S-CURR-STATUS         
                          MOVE 'N'             TO S-ELIGIBLE            
                     WHEN 'E'                                           
                          MOVE 'N'             TO S-CURR-STATUS         
                          MOVE 'Y'             TO S-ELIGIBLE            
                          IF DF-STATUS-CD = 'O' OR 'R'                  
                             MOVE 'N'          TO S-ELIGIBLE            
                          END-IF                                        
                     WHEN 'I'                                           
                          MOVE 'Y'             TO S-CURR-STATUS         
                          MOVE 'N'             TO S-ELIGIBLE            
                     WHEN 'A'                                           
                          MOVE 'Y'             TO S-CURR-STATUS         
                          MOVE 'N'             TO S-ELIGIBLE            
                          MOVE 'N'             TO S-REJECTED            
                     WHEN 'O'                                           
                          MOVE 'N'             TO S-CURR-STATUS         
                          MOVE 'Y'             TO S-ELIGIBLE            
                          IF DF-STATUS-CD = 'O'                         
                             MOVE 'N'          TO S-ELIGIBLE            
                          END-IF                                        
                     WHEN OTHER                                         
                          MOVE 'N'             TO S-CURR-STATUS         
                          MOVE 'N'             TO S-ELIGIBLE            
                  END-EVALUATE                                          
                                                                        
OTPOOL**** MAKE AUTORENEW INELIGIBLE FOR OUTER POOL CUSTOMERS                   
OTPOOL            IF DD-TIER-ACCT-TYPE-CD = 'D' OR 'A' OR 'B'           
OTPOOL               IF S-ELIGIBLE = 'Y' AND B1-DIVISION-NO = 'OUT'     
OTPOOL                  MOVE 'N'               TO S-ELIGIBLE            
OTPOOL               END-IF                                             
I02262            ELSE                                                  
I02262               IF DD-TIER-ACCT-TYPE-CD = 'S'   AND                
I02262                  B1-DIVISION-NO       = 'OUT' AND                
I02262                  S-ELIGIBLE           = 'Y'                      
I02262                  PERFORM 7425-GET-OFFER-TYPE  THRU 7425-EXIT     
I02262                  IF FG-SPCL-OFFER-TYPE-CD NOT = 'OP'             
I02262                     MOVE 'N'            TO S-ELIGIBLE            
I02262                  END-IF                                          
I02262               END-IF                                             
OTPOOL            END-IF                                                
                                                                        
P805CS            IF DF-STATUS-CD = 'P'                                 
P805CS               MOVE 'N'                  TO WS-NEW-CSC-CORE-RATE  
P805CS               PERFORM 7850-CHECK-CORE-RATE THRU 7850-EXIT        
P805CS               IF WS-NEW-CSC-CORE-RATE = 'Y'                      
P805CS                  IF DD-TIER-ACCT-TYPE-CD = 'D' OR 'A' OR 'B'     
P805CS                     IF S-ELIGIBLE = 'Y'                          
P805CS                        MOVE 'Y'         TO S-CSC-DSCNT-ELIGIBLE  
P805CS                        MOVE 'G'         TO S-CSC-DSCNT-ICON-TYPE 
P805CS                     END-IF                                       
P805CS                  END-IF                                          
P805CS               END-IF                                             
P805CS            ELSE                                                  
P805CS               IF (WS-CSC-PLDSC-CD  = 'R' OR 'E')                 
P805CS                   AND S-ELIGIBLE   = 'Y'                         
P805CS                  MOVE 'Y'               TO S-CSC-DSCNT-ELIGIBLE  
P805CS                  MOVE 'G'               TO S-CSC-DSCNT-ICON-TYPE 
P805CS               END-IF                                             
P805CS            END-IF                                                
P805CS        END-IF                                                    
P805CS                                                                  
P805CS        MOVE S-CURR-STATUS               TO WS-SAVE-AR-CURR-STATUS
P805CS        MOVE S-ELIGIBLE                  TO WS-SAVE-AR-ELIGIBLE   
P805CS        MOVE S-REJECTED                  TO WS-SAVE-AR-REJECTED   
ACT001     END-IF.                                                      
                                                                        
           MOVE    ZEROS                 TO S-RETURN-CODE.              
           PERFORM 8010-INSERT-GTT-R1       THRU 8010-EXIT.             
                                                                        
        2500-EXIT.                                                      
             EXIT.                                                      
                                                                        
ACT001******************************************************************        
ACT001* 2550-GET-SHOPPING-RWRDS.                                       *        
ACT001******************************************************************        
ACT001 2550-GET-SHOPPING-RWRDS.                                         
ACT001                                                                  
ACT001     MOVE 'REWARD_REJECTED'               TO YP-ATTRIBUTE-DESC    
P805CS     MOVE 'N'                             TO S-CSC-DSCNT-ELIGIBLE 
ACT001     MOVE 'Shopping Rewards'              TO S-ATTRIBUTE          
ACT001     PERFORM 7500-SELECT-ATTR-CD             THRU 7500-EXIT       
ACT001                                                                  
ACT001     IF YP-ATTRIBUTE-VALUE-CD EQUAL 'SHPRJ'                       
ACT001        MOVE WS-NO                        TO S-CURR-STATUS        
ACT001        MOVE WS-NO                        TO S-ELIGIBLE           
ACT001        MOVE WS-YES                       TO S-REJECTED           
ACT001     ELSE                                                         
ACT001        MOVE WS-REGISTERED                TO YP-STATUS-CD         
ACT001        MOVE 'SHOPPINGREWARDS'            TO YP-ATTRIBUTE-DESC    
ACT001        MOVE WS-NO                        TO S-REJECTED           
ACT001        PERFORM 7550-CHK-SHOPPING-RWRDS      THRU 7550-EXIT       
ACT001                                                                  
ACT001        IF SHOPPING-RWRDS-FOUND                                   
ACT001           MOVE WS-YES                    TO S-CURR-STATUS        
ACT001           MOVE WS-NO                     TO S-ELIGIBLE           
ACT001        ELSE                                                      
ACT001           MOVE WS-ELIGIBLE               TO IN-PARM-TYPE         
ACT001           MOVE SPACES                    TO IN-GUID              
ACT001           PERFORM 2160-CALL-CSR04872        THRU 2160-EXIT       
ACT197           IF WS-4872-RETURN-CD EQUAL 100 OR                      
ACT001              WS-4872-ELIGIBILITY-FL EQUAL WS-INELIGIBLE          
ACT001              MOVE WS-NO                  TO S-CURR-STATUS        
ACT001              MOVE WS-NO                  TO S-ELIGIBLE           
ACT001           ELSE                                                   
ACT001              MOVE WS-NO                  TO S-CURR-STATUS        
ACT001              MOVE WS-YES                 TO S-ELIGIBLE           
ACT001           END-IF                                                 
ACT001        END-IF                                                    
ACT001     END-IF.                                                      
ACT001                                                                  
ACT001     MOVE  ZEROS                          TO S-RETURN-CODE.       
ACT001     PERFORM 8010-INSERT-GTT-R1              THRU 8010-EXIT.      
ACT001                                                                  
ACT001 2550-EXIT.                                                       
ACT001     EXIT.                                                        
      *                                                                         
PRJ836******************************************************************        
PRJ836* 2600-BBP-CALC-ATTRIB.                                          *        
PRJ836******************************************************************        
PRJ836*                                                                         
PRJ836 2600-BBP-CALC-ATTRIB.                                            
PRJ836*                                                                         
PRJ836     INITIALIZE GTT-RETURN-FIELDS.                                
PRJ836*****GET CUT-OFF-MONTH                                                    
PRJ836     IF AT-REV-MTH-LST-NRML  > ZERO                               
PRJ836        MOVE WS-DFLT-NO-OF-BILLS    TO WS-CUTOFF-CNT              
PRJ836        MOVE AT-REV-MTH-LST-NRML    TO WS-CUTOF-REV-MNTH          
PRJ836        PERFORM 2700-GET-CUTOFF-REV-MNTH     THRU 2700-EXIT       
PRJ836          UNTIL WS-CUTOFF-CNT = 0                                 
PRJ836        MOVE WS-CUTOF-REV-MNTH      TO WS-REVENUE-MONTH           
PRJ836        MOVE WS-REVENUE-MONTH       TO BG-REVENUE-MONTH           
PRJ836*****CHECK FOR 13 MONTHS BILLS EXISTS USING CUT-OFF-MONTH                 
PRJ836        PERFORM 7700-CHK-13-MNTHS-BILL-EXIST THRU 7700-EXIT       
PRJ836     END-IF.                                                      
PRJ836*                                                                         
PRJ836     MOVE '12 Months Usage'         TO S-ATTRIBUTE.               
PRJ836     MOVE 'N'                       TO S-REJECTED.                
PRJ836     MOVE 'N'                       TO S-ELIGIBLE.                
P805CS     MOVE 'N'                       TO S-CSC-DSCNT-ELIGIBLE.      
PRJ836*                                                                         
PRJ836     IF WS-ADDTNL-BILLS-EXIST EQUAL 'Y'                           
PRJ836        MOVE 'Y'                    TO S-CURR-STATUS              
PRJ836     ELSE                                                         
PRJ836        MOVE 'N'                    TO S-CURR-STATUS              
PRJ836     END-IF.                                                      
PRJ836     MOVE  ZEROES                   TO S-RETURN-CODE.             
PRJ836     PERFORM 8010-INSERT-GTT-R1        THRU 8010-EXIT.            
PRJ836*                                                                         
PRJ836  2600-EXIT.                                                      
PRJ836       EXIT.                                                      
PRJ836*                                                                         
PRJ836******************************************************************        
PRJ836* 2700-GET-CUTOFF-REV-MNTH.                                      *        
PRJ836*   THIS ROUTINE WILL GET THE CUTOFF REVENUE MONTH               *        
PRJ836******************************************************************        
PRJ836 2700-GET-CUTOFF-REV-MNTH.                                        
PRJ836*                                                                         
PRJ836     SUBTRACT +1     FROM WS-CUTOF-REV-MNTH-MM                    
PRJ836                          WS-CUTOFF-CNT.                          
PRJ836                                                                  
PRJ836     IF WS-CUTOF-REV-MNTH-MM = ZERO                               
PRJ836        MOVE WS-12                     TO WS-CUTOF-REV-MNTH-MM    
PRJ836        SUBTRACT +1  FROM WS-CUTOF-REV-MNTH-YY                    
PRJ836     END-IF.                                                      
PRJ836*                                                                         
PRJ836 2700-EXIT.                                                       
PRJ836     EXIT.                                                        
                                                                        
P805CS******************************************************************        
P805CS* 2750-CSC-DSCNT-ATTRIB.                                         *        
P805CS******************************************************************        
P805CS*                                                                         
P805CS 2750-CSC-DSCNT-ATTRIB.                                           
P805CS*                                                                         
P805CS     INITIALIZE GTT-RETURN-FIELDS.                                
P805CS     MOVE 'Autocard'                  TO S-ATTRIBUTE.             
P805CS     MOVE 'N'                         TO S-REJECTED               
P805CS                                         S-CSC-DSCNT-ELIGIBLE.    
P805CS                                                                  
P805CS     IF (AT-CODE-ACCT-STAT EQUAL  WS-ACTIVE OR                    
P805CS         AT-CODE-ACCT-STAT EQUAL  WS-PENDING )                    
P805CS        IF WS-444-O-AUTOCARD-FL = 'Y'                             
P805CS           MOVE 'Y'                   TO S-CURR-STATUS            
P805CS           MOVE 'N'                   TO S-ELIGIBLE               
P805CS        ELSE                                                      
P805CS           MOVE 'N'                   TO S-CURR-STATUS            
P805CS           MOVE 'Y'                   TO S-ELIGIBLE               
P805CS           IF WS-CSC-PLDSC-CD  = 'E'                              
P805CS              MOVE 'Y'                TO S-CSC-DSCNT-ELIGIBLE     
P805CS              MOVE 'G'                TO S-CSC-DSCNT-ICON-TYPE    
P805CS           ELSE                                                   
P805CS              IF WS-CSC-PLDSC-CD NOT = 'N'                        
P805CS                 MOVE 'Y'             TO S-CSC-DSCNT-ELIGIBLE     
P805CS                 MOVE 'D'             TO S-CSC-DSCNT-ICON-TYPE    
P805CS              END-IF                                              
P805CS           END-IF                                                 
P805CS        END-IF                                                    
P805CS     ELSE                                                         
P805CS        MOVE 'N'                      TO S-ELIGIBLE               
P805CS     END-IF.                                                      
P805CS                                                                  
P805CS     MOVE ZEROS                       TO S-RETURN-CODE.           
P805CS     PERFORM 8010-INSERT-GTT-R1       THRU 8010-EXIT.             
P805CS                                                                  
P805CS     IF (AT-CODE-ACCT-STAT EQUAL  WS-ACTIVE OR                    
P805CS         AT-CODE-ACCT-STAT EQUAL  WS-PENDING )                    
P805CS        INITIALIZE GTT-RETURN-FIELDS                              
P805CS        MOVE 'CSC Discount'           TO S-ATTRIBUTE              
P805CS        MOVE 'N'                      TO S-REJECTED               
P805CS                                         S-ELIGIBLE               
P805CS                                         S-CURR-STATUS            
P805CS        MOVE 'Y'                      TO S-CSC-DSCNT-ELIGIBLE     
P805CS        MOVE ZEROS                    TO S-RETURN-CODE            
P805CS                                                                  
P805CS**** POSITION (1) - AUTORENEW                                             
P805CS        IF DF-STATUS-CD = 'P'                                     
P805CS           IF WS-NEW-CSC-CORE-RATE = 'Y'                          
P805CS              IF WS-SAVE-AR-CURR-STATUS = 'Y'                     
P805CS                 MOVE 'G'             TO S-CSC-DSCNT-ICON-TYPE    
P805CS              ELSE                                                
P805CS                 IF WS-SAVE-AR-ELIGIBLE = 'N'                     
P805CS                    MOVE 'R'          TO S-CSC-DSCNT-ICON-TYPE    
P805CS                 ELSE                                             
P805CS                    MOVE 'B'          TO S-CSC-DSCNT-ICON-TYPE    
P805CS                 END-IF                                           
P805CS              END-IF                                              
P805CS           ELSE                                                   
P805CS              MOVE 'R'                TO S-CSC-DSCNT-ICON-TYPE    
P805CS           END-IF                                                 
P805CS        ELSE                                                      
P805CS           EVALUATE WS-CSC-ARDSC-CD                               
P805CS               WHEN 'E'                                           
P805CS                  MOVE 'B'            TO S-CSC-DSCNT-ICON-TYPE    
P805CS               WHEN 'R'                                           
P805CS                  MOVE 'G'            TO S-CSC-DSCNT-ICON-TYPE    
P805CS               WHEN OTHER                                         
P805CS                  MOVE 'R'            TO S-CSC-DSCNT-ICON-TYPE    
P805CS           END-EVALUATE                                           
P805CS        END-IF                                                    
P805CS                                                                  
P805CS        MOVE S-CSC-DSCNT-ICON-TYPE    TO WS-ICON-01               
P805CS        PERFORM 8010-INSERT-GTT-R1       THRU 8010-EXIT           
P805CS                                                                  
P805CS**** POSITION (2) - PAPERLESS BILLING                                     
P805CS        EVALUATE WS-CSC-PLDSC-CD                                  
P805CS            WHEN 'E'                                              
P805CS               IF WS-SAVE-PL-CURR-STATUS = 'Y'                    
P805CS                  MOVE 'G'            TO S-CSC-DSCNT-ICON-TYPE    
P805CS               ELSE                                               
P805CS                  IF WS-SAVE-PL-ELIGIBLE = 'N'                    
P805CS                     MOVE 'R'         TO S-CSC-DSCNT-ICON-TYPE    
P805CS                  ELSE                                            
P805CS                     MOVE 'B'         TO S-CSC-DSCNT-ICON-TYPE    
P805CS                  END-IF                                          
P805CS               END-IF                                             
P805CS            WHEN 'R'                                              
P805CS               MOVE 'G'               TO S-CSC-DSCNT-ICON-TYPE    
P805CS            WHEN OTHER                                            
P805CS               MOVE 'R'               TO S-CSC-DSCNT-ICON-TYPE    
P805CS        END-EVALUATE                                              
P805CS                                                                  
P805CS        MOVE S-CSC-DSCNT-ICON-TYPE    TO WS-ICON-02               
P805CS        PERFORM 8010-INSERT-GTT-R1       THRU 8010-EXIT           
P805CS                                                                  
P805CS**** POSITION (3) - BANK DRAFT/eDRAFT OR AUTOCARD                         
P805CS        EVALUATE WS-CSC-PLDSC-CD                                  
P805CS            WHEN 'E'                                              
P805CS               IF WS-444-O-AUTOCARD-FL = 'Y' OR                   
P805CS                  WS-444-O-BANK-EFT-FL = 'Y'                      
P805CS                  MOVE 'G'            TO S-CSC-DSCNT-ICON-TYPE    
P805CS               ELSE                                               
P805CS                  IF WS-SAVE-DRFT-ELIGIBLE = 'N'                  
P805CS                     MOVE 'R'         TO S-CSC-DSCNT-ICON-TYPE    
P805CS                  ELSE                                            
P805CS                     MOVE 'B'         TO S-CSC-DSCNT-ICON-TYPE    
P805CS                  END-IF                                          
P805CS               END-IF                                             
P805CS            WHEN 'R'                                              
P805CS               MOVE 'G'               TO S-CSC-DSCNT-ICON-TYPE    
P805CS            WHEN OTHER                                            
P805CS               MOVE 'R'               TO S-CSC-DSCNT-ICON-TYPE    
P805CS        END-EVALUATE                                              
P805CS                                                                  
P805CS        MOVE S-CSC-DSCNT-ICON-TYPE    TO WS-ICON-03               
P805CS        MOVE SPACES                   TO WS-RULE-ID               
P805CS                                                                  
P805CS**** LOGIC TO DISPLAY PROPER HOVER OVER MESSAGE FOR THE ICONS             
P805CS        EVALUATE WS-ICON-01 ALSO WS-ICON-02 ALSO WS-ICON-03       
P805CS           WHEN 'G' ALSO 'G' ALSO 'G'                             
P805CS               MOVE 'PROMOTE001'      TO WS-RULE-ID               
P805CS               MOVE WS-CSC-ARDSC-AMT  TO WS-FORMAT-AMT-01         
P805CS               MOVE WS-CSC-PLDSC-AMT  TO WS-FORMAT-AMT-02         
P805CS               STRING  WS-FORMAT-AMT-01                           
P805CS                     ' discount for AutoRenew enrollment; '       
P805CS                       WS-FORMAT-AMT-02                           
P805CS                     ' discount for Paperless Billing & Bank'     
P805CS                     ' Draft/eDraft or Auto Card'                 
P805CS                       DELIMITED BY SIZE                          
P805CS                       INTO S-MESSAGE-HEADER                      
P805CS               END-STRING                                         
P805CS               COMPUTE WS-TOT-CSC-DSCNT-AMT EQUAL                 
P805CS                       WS-CSC-PLDSC-AMT + WS-CSC-ARDSC-AMT        
P805CS               MOVE WS-TOT-CSC-DSCNT-AMT                          
P805CS                                      TO WS-FORMAT-AMT-01         
P805CS               STRING WS-FORMAT-AMT-01                            
P805CS                      DELIMITED BY SIZE                           
P805CS                      INTO S-MESSAGE-PARMS-TEXT                   
P805CS               END-STRING                                         
P805CS               MOVE LENGTH OF S-MESSAGE-PARMS-TEXT                
P805CS                                      TO S-MESSAGE-PARMS-LEN      
P805CS           WHEN 'G' ALSO 'B' ALSO 'B'                             
P805CS               MOVE 'PROMOTE002'      TO WS-RULE-ID               
P805CS               MOVE WS-CSC-ARDSC-AMT  TO WS-FORMAT-AMT-01         
P805CS               STRING  WS-FORMAT-AMT-01                           
P805CS                     ' discount for AutoRenew enrollment'         
P805CS                       DELIMITED BY SIZE                          
P805CS                       INTO S-MESSAGE-HEADER                      
P805CS               END-STRING                                         
P805CS               MOVE WS-CSC-PLDSC-AMT  TO WS-FORMAT-AMT-01         
P805CS               STRING WS-FORMAT-AMT-01                            
P805CS                      DELIMITED BY SIZE                           
P805CS                      INTO S-MESSAGE-PARMS-TEXT                   
P805CS               END-STRING                                         
P805CS               MOVE LENGTH OF S-MESSAGE-PARMS-TEXT                
P805CS                                      TO S-MESSAGE-PARMS-LEN      
P805CS           WHEN 'G' ALSO 'G' ALSO 'B'                             
P805CS               MOVE 'PROMOTE003'      TO WS-RULE-ID               
P805CS               MOVE WS-CSC-ARDSC-AMT  TO WS-FORMAT-AMT-01         
P805CS               STRING  WS-FORMAT-AMT-01                           
P805CS                     ' discount for AutoRenew enrollment;'        
P805CS                     ' enrolled in Paperless Billing'             
P805CS                       DELIMITED BY SIZE                          
P805CS                       INTO S-MESSAGE-HEADER                      
P805CS               END-STRING                                         
P805CS               MOVE WS-CSC-PLDSC-AMT  TO WS-FORMAT-AMT-01         
P805CS               STRING WS-FORMAT-AMT-01                            
P805CS                      DELIMITED BY SIZE                           
P805CS                      INTO S-MESSAGE-PARMS-TEXT                   
P805CS               END-STRING                                         
P805CS               MOVE LENGTH OF S-MESSAGE-PARMS-TEXT                
P805CS                                      TO S-MESSAGE-PARMS-LEN      
P805CS           WHEN 'B' ALSO 'G' ALSO 'G'                             
P805CS               MOVE 'PROMOTE004'      TO WS-RULE-ID               
P805CS               MOVE WS-CSC-PLDSC-AMT  TO WS-FORMAT-AMT-01         
P805CS               STRING  WS-FORMAT-AMT-01                           
P805CS                     ' discount for Paperless &'                  
P805CS                     ' Bank Draft/eDraft or Auto Card enrollment' 
P805CS                       DELIMITED BY SIZE                          
P805CS                       INTO S-MESSAGE-HEADER                      
P805CS               END-STRING                                         
P805CS               MOVE WS-CSC-ARDSC-AMT  TO WS-FORMAT-AMT-01         
P805CS               STRING WS-FORMAT-AMT-01                            
P805CS                      DELIMITED BY SIZE                           
P805CS                      INTO S-MESSAGE-PARMS-TEXT                   
P805CS               END-STRING                                         
P805CS               MOVE LENGTH OF S-MESSAGE-PARMS-TEXT                
P805CS                                      TO S-MESSAGE-PARMS-LEN      
P805CS           WHEN 'B' ALSO 'B' ALSO 'G'                             
P805CS               MOVE 'PROMOTE005'      TO WS-RULE-ID               
P805CS               MOVE 'Enrolled in Bank Draft/eDraft or Auto Card'  
P805CS                                      TO S-MESSAGE-HEADER         
P805CS               MOVE WS-CSC-PLDSC-AMT  TO WS-FORMAT-AMT-01         
P805CS               MOVE WS-CSC-ARDSC-AMT  TO WS-FORMAT-AMT-02         
P805CS               STRING WS-FORMAT-AMT-01                            
P805CS                     ';'                                          
P805CS                      WS-FORMAT-AMT-02                            
P805CS                      DELIMITED BY SIZE                           
P805CS                      INTO S-MESSAGE-PARMS-TEXT                   
P805CS               END-STRING                                         
P805CS               MOVE LENGTH OF S-MESSAGE-PARMS-TEXT                
P805CS                                      TO S-MESSAGE-PARMS-LEN      
P805CS           WHEN 'B' ALSO 'G' ALSO 'B'                             
P805CS               MOVE 'PROMOTE006'      TO WS-RULE-ID               
P805CS               MOVE 'Enrolled in Paperless Billing'               
P805CS                                      TO S-MESSAGE-HEADER         
P805CS               MOVE WS-CSC-PLDSC-AMT  TO WS-FORMAT-AMT-01         
P805CS               MOVE WS-CSC-ARDSC-AMT  TO WS-FORMAT-AMT-02         
P805CS               STRING WS-FORMAT-AMT-01                            
P805CS                     ';'                                          
P805CS                      WS-FORMAT-AMT-02                            
P805CS                      DELIMITED BY SIZE                           
P805CS                      INTO S-MESSAGE-PARMS-TEXT                   
P805CS               END-STRING                                         
P805CS               MOVE LENGTH OF S-MESSAGE-PARMS-TEXT                
P805CS                                      TO S-MESSAGE-PARMS-LEN      
P805CS           WHEN 'G' ALSO 'R' ALSO 'R'                             
P805CS           WHEN 'G' ALSO 'G' ALSO 'R'                             
P805CS           WHEN 'G' ALSO 'B' ALSO 'R'                             
P805CS           WHEN 'G' ALSO 'R' ALSO 'B'                             
P805CS           WHEN 'G' ALSO 'R' ALSO 'G'                             
P805CS               MOVE 'PROMOTE007'      TO WS-RULE-ID               
P805CS               MOVE WS-CSC-ARDSC-AMT  TO WS-FORMAT-AMT-01         
P805CS               STRING  WS-FORMAT-AMT-01                           
P805CS                     ' discount for AutoRenew enrollment'         
P805CS                       DELIMITED BY SIZE                          
P805CS                       INTO S-MESSAGE-HEADER                      
P805CS               END-STRING                                         
P805CS               STRING WS-FORMAT-AMT-01                            
P805CS                      DELIMITED BY SIZE                           
P805CS                      INTO S-MESSAGE-PARMS-TEXT                   
P805CS               END-STRING                                         
P805CS               MOVE LENGTH OF S-MESSAGE-PARMS-TEXT                
P805CS                                      TO S-MESSAGE-PARMS-LEN      
P805CS           WHEN 'G' ALSO 'B' ALSO 'G'                             
P805CS               MOVE 'PROMOTE008'      TO WS-RULE-ID               
P805CS               MOVE WS-CSC-ARDSC-AMT  TO WS-FORMAT-AMT-01         
P805CS               STRING  WS-FORMAT-AMT-01                           
P805CS                     ' discount for AutoRenew enrollment;'        
P805CS                     ' enrolled in Bank Draft/eDraft or Auto Card'
P805CS                       DELIMITED BY SIZE                          
P805CS                       INTO S-MESSAGE-HEADER                      
P805CS               END-STRING                                         
P805CS               MOVE WS-CSC-PLDSC-AMT  TO WS-FORMAT-AMT-01         
P805CS               STRING WS-FORMAT-AMT-01                            
P805CS                      DELIMITED BY SIZE                           
P805CS                      INTO S-MESSAGE-PARMS-TEXT                   
P805CS               END-STRING                                         
P805CS               MOVE LENGTH OF S-MESSAGE-PARMS-TEXT                
P805CS                                      TO S-MESSAGE-PARMS-LEN      
P805CS           WHEN 'R' ALSO 'G' ALSO 'G'                             
P805CS               MOVE 'PROMOTE009'      TO WS-RULE-ID               
P805CS               MOVE WS-CSC-PLDSC-AMT  TO WS-FORMAT-AMT-01         
P805CS               STRING  WS-FORMAT-AMT-01                           
P805CS                     ' discount for Paperless Billing &'          
P805CS                     ' Bank Draft/eDraft or Auto Card'            
P805CS                       DELIMITED BY SIZE                          
P805CS                       INTO S-MESSAGE-HEADER                      
P805CS               END-STRING                                         
P805CS               STRING WS-FORMAT-AMT-01                            
P805CS                      DELIMITED BY SIZE                           
P805CS                      INTO S-MESSAGE-PARMS-TEXT                   
P805CS               END-STRING                                         
P805CS               MOVE LENGTH OF S-MESSAGE-PARMS-TEXT                
P805CS                                      TO S-MESSAGE-PARMS-LEN      
P805CS           WHEN 'R' ALSO 'G' ALSO 'B'                             
P805CS               MOVE 'PROMOTE010'      TO WS-RULE-ID               
P805CS               MOVE 'Enrolled in Paperless Billing'               
P805CS                                      TO S-MESSAGE-HEADER         
P805CS               MOVE WS-CSC-PLDSC-AMT  TO WS-FORMAT-AMT-01         
P805CS               STRING WS-FORMAT-AMT-01                            
P805CS                      DELIMITED BY SIZE                           
P805CS                      INTO S-MESSAGE-PARMS-TEXT                   
P805CS               END-STRING                                         
P805CS               MOVE LENGTH OF S-MESSAGE-PARMS-TEXT                
P805CS                                      TO S-MESSAGE-PARMS-LEN      
P805CS           WHEN 'R' ALSO 'B' ALSO 'G'                             
P805CS               MOVE 'PROMOTE011'      TO WS-RULE-ID               
P805CS               MOVE 'Enrolled in Bank Draft/eDraft or Auto Card'  
P805CS                                      TO S-MESSAGE-HEADER         
P805CS               MOVE WS-CSC-PLDSC-AMT  TO WS-FORMAT-AMT-01         
P805CS               STRING WS-FORMAT-AMT-01                            
P805CS                      DELIMITED BY SIZE                           
P805CS                      INTO S-MESSAGE-PARMS-TEXT                   
P805CS               END-STRING                                         
P805CS               MOVE LENGTH OF S-MESSAGE-PARMS-TEXT                
P805CS                                      TO S-MESSAGE-PARMS-LEN      
P805CS**** NO HOVER OVER MESSAGE FOR FOLLOWING COMBINATIONS                     
P805CS           WHEN 'B' ALSO 'B' ALSO 'B'                             
P805CS           WHEN 'B' ALSO 'R' ALSO 'R'                             
P805CS           WHEN 'B' ALSO 'B' ALSO 'R'                             
P805CS           WHEN 'B' ALSO 'R' ALSO 'G'                             
P805CS           WHEN 'B' ALSO 'G' ALSO 'R'                             
P805CS           WHEN 'B' ALSO 'R' ALSO 'B'                             
P805CS           WHEN 'R' ALSO 'R' ALSO 'R'                             
P805CS           WHEN 'R' ALSO 'R' ALSO 'G'                             
P805CS           WHEN 'R' ALSO 'B' ALSO 'B'                             
P805CS           WHEN 'R' ALSO 'R' ALSO 'B'                             
P805CS           WHEN 'R' ALSO 'B' ALSO 'R'                             
P805CS           WHEN 'R' ALSO 'G' ALSO 'R'                             
P805CS               CONTINUE                                           
P805CS           WHEN OTHER                                             
P805CS               CONTINUE                                           
P805CS        END-EVALUATE                                              
P805CS                                                                  
P805CS        IF WS-RULE-ID >  SPACES                                   
P805CS           SET BUS-RULE-NOT-FOUND                                 
P805CS               NOT-END-OF-SEARCH      TO TRUE                     
P805CS           MOVE '00'                  TO WS-COMP-NO               
P805CS           PERFORM 2800-RULE-XREF        THRU 2800-EXIT           
P805CS                   UNTIL BUS-RULE-FOUND OR END-OF-SEARCH          
P805CS        END-IF                                                    
P805CS        PERFORM 8010-INSERT-GTT-R1       THRU 8010-EXIT           
P805CS     END-IF.                                                      
P805CS*                                                                         
P805CS 2750-EXIT.                                                       
P805CS     EXIT.                                                        
P805CS*                                                                         
P805CS******************************************************************        
P805CS* 2800-RULE-XREF.                                                *        
P805CS*   GET BUSINESS RULE DETAILS.                                   *        
P805CS******************************************************************        
P805CS*                                                                         
P805CS 2800-RULE-XREF.                                                  
P805CS                                                                  
P805CS     MOVE SPACES                         TO WS-RULE-XREF-ID       
P805CS                                            WS-RULE-RESULT-CD.    
P805CS     SET BUS-RULE-INDX TO +1.                                     
P805CS     SEARCH BUS-RULES                                             
P805CS        AT END                                                    
P805CS           MOVE SPACES                   TO WS-RULE-XREF-ID       
P805CS         WHEN BUS-RULE-ID (BUS-RULE-INDX) = LOW-VALUES OR SPACES  
P805CS              SET END-OF-SEARCH          TO TRUE                  
P805CS         WHEN BUS-RULE-ID             (BUS-RULE-INDX) = WS-RULE-ID
P805CS          AND BUS-RULE-COMPANY-NO     (BUS-RULE-INDX) = WS-COMP-NO
P805CS              MOVE BUS-RULE-XREF-ID   (BUS-RULE-INDX)             
P805CS                                         TO WS-RULE-XREF-ID       
P805CS              MOVE BUS-RULE-RESULT-CD (BUS-RULE-INDX)             
P805CS                                         TO WS-RULE-RESULT-CD     
P805CS              SET  BUS-RULE-FOUND        TO TRUE                  
P805CS     END-SEARCH.                                                  
P805CS                                                                  
P805CS     MOVE WS-RULE-ID                     TO S-BUS-RULE-ID.        
P805CS     MOVE WS-RULE-XREF-ID                TO S-BUS-RULE-XREF-ID.   
P805CS     MOVE WS-RULE-RESULT-CD              TO S-BUS-RULE-RESULT-CD. 
P805CS                                                                  
P805CS 2800-EXIT.                                                       
P805CS     EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2150-CALL-CSR04620                                             *        
      ******************************************************************        
      *                                                                         
       2150-CALL-CSR04620.                                              
      *                                                                         
      *     EXEC SQL                                                    
      *          CALL CSR04620                                          
      *           (:IN-ACCOUNT-NO,                                      
      *            :IN-ELIGIBLE)                                        
      *     END-EXEC.                                                   

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_4620
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_4620
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_4620 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '2150'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR04620'            TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE IN-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC4620)                                                
      *       WITH PROCEDURE CSR04620                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_4620 CURSOR FOR RESULT SET        
      *       :LOC4620                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_4620 INTO                            
                 :BBP-RETURN-CODE,                                      
                 :BBP-ELIGIBLE                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '2150'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR04620'            TO TABLE-1                
                   MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1        
                   MOVE IN-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1      
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
      *                                                                         
       2150-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 2155-CALL-CSR04344                                             *        
      ******************************************************************        
      *                                                                         
       2155-CALL-CSR04344.                                              
      *                                                                         
      *       EXEC SQL                                                  
      *          CALL CSR04344                                          
      *           (:IN-ACCOUNT-NO,                                      
      *            :IN-ELIGIBLE)                                        
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_4344
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_4344
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_4344 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '2155'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR04344'            TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE IN-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC4344)                                                
      *       WITH PROCEDURE CSR04344                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_4344 CURSOR FOR RESULT SET        
      *       :LOC4344                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_4344 INTO                            
                 :BBP-RETURN-CODE,                                      
                 :BBP-ELIGIBLE                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '2155'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR04344'            TO TABLE-1                
                   MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1        
                   MOVE IN-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1      
           END-EVALUATE.                                                
      *                                                                         
       2155-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
ACT001******************************************************************        
ACT001* 2160-CALL-CSR04872.                                            *        
ACT001******************************************************************        
ACT001 2160-CALL-CSR04872.                                              
ACT001                                                                  
ACT001*     EXEC SQL                                                    
ACT001*          CALL CSR04872                                          
ACT001*           (:IN-PARM-TYPE,                                       
ACT001*            :IN-ACCOUNT-NO,                                      
ACT001*            :IN-GUID)                                            
ACT001*     END-EXEC.                                                   

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_4872
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_4872
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_4872 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
ACT001                                                                  
ACT001     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
ACT001                                                                  
ACT001     IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
ACT001        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
ACT001        MOVE '2160'                TO ACTIVE-PARAGRAPH            
ACT001        MOVE 'CALL'                TO ABEND-FUNCTION              
ACT001        MOVE 'CSR04872'            TO TABLE-1                     
ACT001        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
ACT001        MOVE IN-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
ACT001        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
ACT001     END-IF.                                                      
ACT001                                                                  
ACT001*    EXEC SQL                                                     
ACT001*       ASSOCIATE LOCATORS                                        
ACT001*       (:LOC4872)                                                
ACT001*       WITH PROCEDURE CSR04872                                   
ACT001*    END-EXEC.                                                    
ACT001                                                                  
ACT001*    EXEC SQL                                                     
ACT001*       ALLOCATE RESULT_SET_CSR_4872 CURSOR FOR RESULT SET        
ACT001*       :LOC4872                                                  
ACT001*    END-EXEC.                                                    
ACT001                                                                  
ACT001     EXEC SQL                                                     
ACT001        FETCH RESULT_SET_CSR_4872 INTO                            
ACT001           :WS-4872-RETURN-CD,                                    
ACT001           :WS-4872-ACCOUNT-NO,                                   
ACT001           :WS-4872-GUID,                                         
ACT001           :WS-4872-ELIGIBILITY-FL                                
ACT001     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT001                                                                  
ACT001     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
ACT001     EVALUATE WS-ACTIVE-RETURN-CODE                               
ACT001         WHEN SUCCESSFUL-CALL                                     
ACT001              CONTINUE                                            
ACT001         WHEN OTHER                                               
ACT001             MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
ACT001             MOVE '2160'                TO ACTIVE-PARAGRAPH       
ACT001             MOVE 'FETCH'               TO ABEND-FUNCTION         
ACT001             MOVE 'CSR04872'            TO TABLE-1                
ACT001             MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1        
ACT001             MOVE IN-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1      
ACT001             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
ACT001     END-EVALUATE.                                                
ACT001*                                                                         
ACT001 2160-EXIT.                                                       
ACT001      EXIT.                                                       
                                                                        
P805CS*****************************************************************         
P805CS*** 6000-CPD444-CSC-DISCOUNT-ELIG THRU 6000-CPD444-EXIT       ***         
P805CS*****************************************************************         
P805CS*                                                                         
P805CS     EXEC SQL                                                     PCS03470
P805CS        INCLUDE CPD0444E                                          PCS03470
P805CS     END-EXEC.                                                            
P805CS*                                                                         
P805CS*****************************************************************         
P805CS*** ERROR ROUTINE FOR CPD0444E                                ***         
P805CS*****************************************************************         
P805CS*                                                                         
P805CS 6999-CPD444-ERROR-ROUTINE.                                       
P805CS*                                                                         
P805CS     PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT.               
P805CS*                                                                         
P805CS 6999-CPD444-EXIT.                                                
P805CS     EXIT.                                                        
P805CS*                                                                         
      ******************************************************************        
      * 7000-SELECT-ACCOUNT.                                           *        
      ******************************************************************        
      *                                                                         
       7000-SELECT-ACCOUNT.                                             
      *                                                                         
           EXEC SQL                                                     
              SELECT                                                    
                     AT.COMPANY_NO                                      
                    ,AT.CUSTOMER_NO                                     
                    ,AT.CODES_DATA_PRESENT                              
                    ,AT.CODE_ACCT_STAT                                  
ACT001              ,AT.ACCOUNT_TYPE_CODE                               
                    ,REPLACE(REPLACE(CONVERT(CHAR(26), AT.ACCT_CREATE_DT
           , 121), ' ', '-'), ':', '.') ACCT_CREATE_DT                         
                    ,AT.TOTAL_AR_BALANCE                                
                    ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           AT.ACCT_FINALED_DT, 121), ' ', '-'), ':', '.') 
           ACCT_FINALED_DT                                 
                    ,AT.NO_BILL_COPIES                                  
                    ,AT.PREMISE_NO                                      
                    ,AT.MST_SUB_ACCT_IND                                
PRJ836              ,AT.REV_MTH_LST_NRML                                
OTPOOL              ,COALESCE(B1.DIVISION_NO,'   ')                       
                INTO                                                    
                     :AT-COMPANY-NO                                     
                    ,:AT-CUSTOMER-NO                                    
                    ,:AT-CODES-DATA-PRESENT                             
                    ,:AT-CODE-ACCT-STAT                                 
ACT001              ,:AT-ACCOUNT-TYPE-CODE                              
                    ,:AT-ACCT-CREATE-DT :WS-NULL-IND1                    
                    ,:AT-TOTAL-AR-BALANCE                               
                    ,:AT-ACCT-FINALED-DT :WS-NULL-IND2                   
                    ,:AT-NO-BILL-COPIES                                 
                    ,:AT-PREMISE-NO                                     
                    ,:AT-MST-SUB-ACCT-IND                               
PRJ836              ,:AT-REV-MTH-LST-NRML                               
OTPOOL              ,:B1-DIVISION-NO                                    
                FROM CSS_ACCOUNT      AT WITH(READUNCOMMITTED)                  
OTPOOL              ,CSS_LOCAL_OFFICE B1 WITH(READUNCOMMITTED)                  
               WHERE ACCOUNT_NO      = :AT-ACCOUNT-NO                   
OTPOOL           AND B1.LOCAL_OFFICE =  AT.LOCAL_OFFICE                 
OTPOOL           AND B1.COMPANY_NO   =  AT.COMPANY_NO                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*              AT.COMPANY_NO                                              
MFA-TR*             ,AT.CUSTOMER_NO                                             
MFA-TR*             ,AT.CODES_DATA_PRESENT                                      
MFA-TR*             ,AT.CODE_ACCT_STAT                                          
MFA-TR*             ,AT.ACCOUNT_TYPE_CODE                                       
MFA-TR*             ,AT.ACCT_CREATE_DT                                          
MFA-TR*             ,AT.TOTAL_AR_BALANCE                                        
MFA-TR*             ,AT.ACCT_FINALED_DT                                         
MFA-TR*             ,AT.NO_BILL_COPIES                                          
MFA-TR*             ,AT.PREMISE_NO                                              
MFA-TR*             ,AT.MST_SUB_ACCT_IND                                        
MFA-TR*             ,AT.REV_MTH_LST_NRML                                        
MFA-TR*             ,IFNULL(B1.DIVISION_NO,'   ')                               
MFA-TR*         INTO                                                            
MFA-TR*              :AT-COMPANY-NO                                             
MFA-TR*             ,:AT-CUSTOMER-NO                                            
MFA-TR*             ,:AT-CODES-DATA-PRESENT                                     
MFA-TR*             ,:AT-CODE-ACCT-STAT                                         
MFA-TR*             ,:AT-ACCOUNT-TYPE-CODE                                      
MFA-TR*             ,:AT-ACCT-CREATE-DT:WS-NULL-IND1                            
MFA-TR*             ,:AT-TOTAL-AR-BALANCE                                       
MFA-TR*             ,:AT-ACCT-FINALED-DT:WS-NULL-IND2                           
MFA-TR*             ,:AT-NO-BILL-COPIES                                         
MFA-TR*             ,:AT-PREMISE-NO                                             
MFA-TR*             ,:AT-MST-SUB-ACCT-IND                                       
MFA-TR*             ,:AT-REV-MTH-LST-NRML                                       
MFA-TR*             ,:B1-DIVISION-NO                                            
MFA-TR*         FROM CSS_ACCOUNT      AT                                        
MFA-TR*             ,CSS_LOCAL_OFFICE B1                                        
MFA-TR*        WHERE ACCOUNT_NO      = :AT-ACCOUNT-NO                           
MFA-TR*          AND B1.LOCAL_OFFICE =  AT.LOCAL_OFFICE                         
MFA-TR*          AND B1.COMPANY_NO   =  AT.COMPANY_NO                           
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7000                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE.              
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7000'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE WS-ACCOUNT-NUM        TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P805CS******************************************************************        
P805CS* 7001-OPEN-RULE-CURSOR.                                         *        
P805CS******************************************************************        
P805CS*                                                                         
P805CS 7001-OPEN-RULE-CURSOR.                                           
P805CS                                                                  
P805CS     EXEC SQL                                                     
P805CS         OPEN RULE-CURSOR                                         
P805CS     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P805CS                                                                  
P805CS     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
P805CS                                            S-RETURN-CODE.        
P805CS                                                                  
P805CS     EVALUATE WS-ACTIVE-RETURN-CODE                               
P805CS         WHEN SUCCESSFUL-CALL                                     
P805CS             CONTINUE                                             
P805CS         WHEN OTHER                                               
P805CS             MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
P805CS             MOVE SQLCODE                TO ABEND-SQLCODE         
P805CS             MOVE '7001'                 TO ACTIVE-PARAGRAPH      
P805CS             MOVE 'OPEN'                 TO ABEND-FUNCTION        
P805CS             MOVE 'CSS_BUS_RULE_XREF'    TO TABLE-1               
P805CS             PERFORM 9700-PROCESS-ABEND     THRU  9700-EXIT       
P805CS     END-EVALUATE.                                                
P805CS                                                                  
P805CS 7001-EXIT.                                                       
P805CS     EXIT.                                                        
      *                                                                         
P805CS******************************************************************        
P805CS* 7002-FETCH-RULE-CURSOR.                                        *        
P805CS******************************************************************        
P805CS*                                                                         
P805CS 7002-FETCH-RULE-CURSOR.                                          
P805CS                                                                  
P805CS     EXEC SQL                                                     
P805CS         FETCH RULE-CURSOR                                        
P805CS          INTO :1T-BUS-RULE-ID                                    
P805CS              ,:1T-BUS-RULE-XREF-ID                               
P805CS              ,:1T-COMPANY-NO                                     
P805CS              ,:1S-RULE-MESSAGE-ID                                
P805CS              ,:1S-RULE-RESULT-CD                                 
P805CS     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P805CS                                                                  
P805CS     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
P805CS                                            S-RETURN-CODE.        
P805CS                                                                  
P805CS     EVALUATE WS-ACTIVE-RETURN-CODE                               
P805CS         WHEN SUCCESSFUL-CALL                                     
P805CS         WHEN NOT-FOUND                                           
P805CS             CONTINUE                                             
P805CS         WHEN OTHER                                               
P805CS             MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
P805CS             MOVE SQLCODE                TO ABEND-SQLCODE         
P805CS             MOVE '7002'                 TO ACTIVE-PARAGRAPH      
P805CS             MOVE 'FETCH'                TO ABEND-FUNCTION        
P805CS             MOVE 'CSS_BUS_RULE_XREF'    TO TABLE-1               
P805CS             PERFORM 9700-PROCESS-ABEND     THRU  9700-EXIT       
P805CS     END-EVALUATE.                                                
P805CS                                                                  
P805CS 7002-EXIT.                                                       
P805CS     EXIT.                                                        
      *                                                                         
P805CS******************************************************************        
P805CS* 7003-CLOSE-RULE-CURSOR.                                        *        
P805CS******************************************************************        
P805CS*                                                                         
P805CS 7003-CLOSE-RULE-CURSOR.                                          
P805CS                                                                  
P805CS     EXEC SQL                                                     
P805CS         CLOSE RULE-CURSOR                                        
P805CS     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P805CS                                                                  
P805CS     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
P805CS                                            S-RETURN-CODE.        
P805CS                                                                  
P805CS     EVALUATE WS-ACTIVE-RETURN-CODE                               
P805CS         WHEN SUCCESSFUL-CALL                                     
P805CS             CONTINUE                                             
P805CS         WHEN OTHER                                               
P805CS             MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
P805CS             MOVE SQLCODE                TO ABEND-SQLCODE         
P805CS             MOVE '7003'                 TO ACTIVE-PARAGRAPH      
P805CS             MOVE 'CLOSE'                TO ABEND-FUNCTION        
P805CS             MOVE 'CSS_BUS_RULE_XREF'    TO TABLE-1               
P805CS             PERFORM 9700-PROCESS-ABEND     THRU  9700-EXIT       
P805CS     END-EVALUATE.                                                
P805CS                                                                  
P805CS 7003-EXIT.                                                       
P805CS     EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7100-GET-DELINQUENCY.                                          *        
      ******************************************************************        
      *                                                                         
       7100-GET-DELINQUENCY.                                            
      *                                                                         
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE DELINQ_CD  = :C8-DELINQ-CD                         
                 AND COMPANY_NO = :AT-COMPANY-NO                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD  = :C8-DELINQ-CD                                 
MFA-TR*          AND COMPANY_NO = :AT-COMPANY-NO                                
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE '7100'                     TO ACTIVE-PARAGRAPH       
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_DELINQUENCY'          TO TABLE-1                
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-1        
              MOVE AT-COMPANY-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'DELINQ CE'                TO TABLE-ELEMENT-2        
              MOVE C8-DELINQ-CD               TO HOSTVAR-ELEMENT-2      
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************07969900
      * 7200-GET-REG-ACCT-FL                                           *07492029
      ******************************************************************07550000
       7200-GET-REG-ACCT-FL.                                            
                                                                        
           EXEC SQL                                                     
              SELECT 'Y'                                                
                INTO :WS-REG-ACCT-FL                                    
                FROM CSS_REG_PROFILE LR WITH(READUNCOMMITTED)                   
               WHERE LR.ACCOUNT_NO   = :LR-ACCOUNT-NO                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-REG-ACCT-FL                                            
MFA-TR*         FROM CSS_REG_PROFILE LR                                         
MFA-TR*        WHERE LR.ACCOUNT_NO   = :LR-ACCOUNT-NO                           
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7200                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE.              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 'N' TO WS-REG-ACCT-FL                             
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7200'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_REG_PROFILE'     TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE LR-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************07969900
      * 7300-GET-EPAY-IND.                                             *07492029
      ******************************************************************07550000
       7300-GET-EPAY-IND.                                               
                                                                        
           EXEC SQL                                                     
              SELECT 'Y'                                                
                INTO :WS-ACCT-ON-EPAY                                   
                FROM CSS_BANK_EFT BE WITH(READUNCOMMITTED)                      
               WHERE BE.ACCOUNT_NO   = :BE-ACCOUNT-NO                   
                 AND BE.STATUS_CODE IN ('M','N')                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-ACCT-ON-EPAY                                           
MFA-TR*         FROM CSS_BANK_EFT BE                                            
MFA-TR*        WHERE BE.ACCOUNT_NO   = :BE-ACCOUNT-NO                           
MFA-TR*          AND BE.STATUS_CODE IN ('M','N')                                
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7300                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE.              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7300'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_BANK_EFT'        TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE BE-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************07969900
      * 7350-GET-DRAFT-IND.                                            *07492029
      ******************************************************************07550000
       7350-CHECK-EPAY.                                                 
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) STATUS_CODE,
              INIT_TYPE_CD                                       
                INTO :BE-STATUS-CODE,                                   
                     :BE-INIT-TYPE-CD                                   
                FROM CSS_BANK_EFT WITH(READUNCOMMITTED)                         
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT STATUS_CODE,                                               
MFA-TR*              INIT_TYPE_CD                                               
MFA-TR*         INTO :BE-STATUS-CODE,                                           
MFA-TR*              :BE-INIT-TYPE-CD                                           
MFA-TR*         FROM CSS_BANK_EFT                                               
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7350                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE SPACES TO BE-STATUS-CODE                        
                                  BE-INIT-TYPE-CD                       
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7350'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_BANK_EFT'      TO TABLE-1                  
                   MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1          
                   MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
                                                                        
       7350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************24970088
      *  7355-SELECT-CREDIT-PROFILE                                    *24980000
      ******************************************************************24990088
       7355-SELECT-CREDIT-PROFILE.                                      
      *                                                                 25010000
           EXEC SQL                                                     
              SELECT                                                    
                  CASH_ONLY_FL                                          
              INTO                                                      
                  :CZ-CASH-ONLY-FL                                      
              FROM CSS_CREDIT_PROFILE WITH(READUNCOMMITTED)                     
              WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                         
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     25020000
MFA-TR*       SELECT                                                    25030000
MFA-TR*           CASH_ONLY_FL                                          25090000
MFA-TR*       INTO                                                      25100000
MFA-TR*           :CZ-CASH-ONLY-FL                                      25160000
MFA-TR*       FROM CSS_CREDIT_PROFILE                                   25170000
MFA-TR*       WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                         25180000
MFA-TR*       WITH UR                                                           
MFA-TR*    QUERYNO 7355                                                         
MFA-TR*    END-EXEC.                                                    25190000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 25200000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 25200000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE '7355'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_CREDIT_PROFILE'  TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 25350000
       7355-EXIT.                                                       
            EXIT.                                                       
      *****************************************************************         
      *                                                               *         
      * 7400-GET-AUTORENEW-IND.                                       *         
      *****************************************************************         
       7400-GET-AUTORENEW-IND.                                          
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) DF.AUTO_REN_OPT_IN_FL,
              DF.AGREEMNT_SOURCE_CD,
              DF.STATUS_CD,
              DF.OFFER_CD,
              DF.OPT_AGRMT_EFF_DT                              
                  INTO :DF-AUTO-REN-OPT-IN-FL                           
                      ,:DF-AGREEMNT-SOURCE-CD                           
                      ,:DF-STATUS-CD                                    
I02262                ,:DF-OFFER-CD                                     
I02262                ,:DF-OPT-AGRMT-EFF-DT                             
                  FROM CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)               
                      ,CSS_UTIL_ENVRNMT  UT WITH(READUNCOMMITTED)               
                 WHERE DF.ACCOUNT_NO        = :DF-ACCOUNT-NO            
                   AND DF.ACCOUNT_NO        = UT.ACCOUNT_NO             
                   AND DF.CODE_UTIL_TYPE    = UT.CODE_UTIL_TYPE         
                   AND DF.IC_NO             = UT.IC_NO                  
                 ORDER BY DF.RT_PKG_OPT_SEQ_NO DESC                     
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT DF.AUTO_REN_OPT_IN_FL                                    
MFA-TR*               ,DF.AGREEMNT_SOURCE_CD                                    
MFA-TR*               ,DF.STATUS_CD                                             
MFA-TR*               ,DF.OFFER_CD                                              
MFA-TR*               ,DF.OPT_AGRMT_EFF_DT                                      
MFA-TR*           INTO :DF-AUTO-REN-OPT-IN-FL                                   
MFA-TR*               ,:DF-AGREEMNT-SOURCE-CD                                   
MFA-TR*               ,:DF-STATUS-CD                                            
MFA-TR*               ,:DF-OFFER-CD                                             
MFA-TR*               ,:DF-OPT-AGRMT-EFF-DT                                     
MFA-TR*           FROM CSS_ACCT_RTPK_AGR DF                                     
MFA-TR*               ,CSS_UTIL_ENVRNMT  UT                                     
MFA-TR*          WHERE DF.ACCOUNT_NO        = :DF-ACCOUNT-NO                    
MFA-TR*            AND DF.ACCOUNT_NO        = UT.ACCOUNT_NO                     
MFA-TR*            AND DF.CODE_UTIL_TYPE    = UT.CODE_UTIL_TYPE                 
MFA-TR*            AND DF.IC_NO             = UT.IC_NO                          
MFA-TR*          ORDER BY DF.RT_PKG_OPT_SEQ_NO DESC                             
MFA-TR*          FETCH FIRST ROW ONLY                                           
MFA-TR*           WITH UR                                                       
MFA-TR*        QUERYNO 7400                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE.              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7400'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_ACCT_RTPK_AGR'   TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE DF-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
I02262*****************************************************************         
I02262*                                                               *         
I02262* 7425-GET-OFFER-TYPE.                                          *         
I02262*****************************************************************         
I02262 7425-GET-OFFER-TYPE.                                             
I02262*                                                                         
I02262     EXEC SQL                                                     
I02262         SELECT TOP(1) FG.SPCL_OFFER_TYPE_CD                            
I02262           INTO :FG-SPCL-OFFER-TYPE-CD                            
I02262           FROM  CRM_RT_PKG_OFFER FG WITH(READUNCOMMITTED)                
I02262          WHERE  FG.OFFER_CD             = :DF-OFFER-CD           
I02262            AND  CAST(FG.OFF_VSTART_TS AS DATE) <= 
              IIF(TRY_CONVERT(DATE, :DF-OPT-AGRMT-EFF-DT
              ) IS NULL OR (PATINDEX('%.%', :DF-OPT-AGRMT-EFF-DT
              ) <> 0) OR (LEN(:DF-OPT-AGRMT-EFF-DT
              ) <> 10), CIS.CHAR2DATE(:DF-OPT-AGRMT-EFF-DT
              ), CONVERT(DATE, :DF-OPT-AGRMT-EFF-DT) )   
I02262            AND  CAST(FG.OFF_VEND_TS AS DATE)   >= 
              IIF(TRY_CONVERT(DATE, :DF-OPT-AGRMT-EFF-DT
              ) IS NULL OR (PATINDEX('%.%', :DF-OPT-AGRMT-EFF-DT
              ) <> 0) OR (LEN(:DF-OPT-AGRMT-EFF-DT
              ) <> 10), CIS.CHAR2DATE(:DF-OPT-AGRMT-EFF-DT
              ), CONVERT(DATE, :DF-OPT-AGRMT-EFF-DT) )   
I02262            AND  FG.PROC_STATUS_CD       = 'AC'                   
I02262          ORDER BY FG.OFF_VSTART_TS DESC                          
I02262                                     
I02262                                                      
I02262     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  FG.SPCL_OFFER_TYPE_CD                                    
MFA-TR*          INTO :FG-SPCL-OFFER-TYPE-CD                                    
MFA-TR*          FROM  CRM_RT_PKG_OFFER FG                                      
MFA-TR*         WHERE  FG.OFFER_CD             = :DF-OFFER-CD                   
MFA-TR*           AND  DATE(FG.OFF_VSTART_TS) <= :DF-OPT-AGRMT-EFF-DT           
MFA-TR*           AND  DATE(FG.OFF_VEND_TS)   >= :DF-OPT-AGRMT-EFF-DT           
MFA-TR*           AND  FG.PROC_STATUS_CD       = 'AC'                           
MFA-TR*         ORDER BY FG.OFF_VSTART_TS DESC                                  
MFA-TR*         FETCH FIRST 1 ROW ONLY WITH UR                                  
MFA-TR*       QUERYNO 7425                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

I02262                                                                  
I02262     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
I02262                                                                  
I02262     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
I02262        IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
I02262           MOVE SPACES              TO FG-SPCL-OFFER-TYPE-CD      
I02262        END-IF                                                    
I02262     ELSE                                                         
I02262        MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
I02262        MOVE '7425'                 TO ACTIVE-PARAGRAPH           
I02262        MOVE 'SELECT'               TO ABEND-FUNCTION             
I02262        MOVE 'CRM_RT_PKG_OFFER'     TO TABLE-1                    
I02262        MOVE 'OFFER_CD'             TO TABLE-ELEMENT-1            
I02262        MOVE 'OPT_AGRMT_EFF_DT'     TO TABLE-ELEMENT-2            
I02262        MOVE DF-OFFER-CD            TO HOSTVAR-ELEMENT-1          
I02262        MOVE DF-OPT-AGRMT-EFF-DT    TO HOSTVAR-ELEMENT-2          
I02262        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
I02262     END-IF.                                                      
I02262                                                                  
I02262 7425-EXIT.                                                       
I02262     EXIT.                                                        
I02262*                                                                         
      ******************************************************************07453000
      * 7500-SELECT-ATTR-CD                                            *07454000
      ******************************************************************07455000
      *                                                                 07456000
       7500-SELECT-ATTR-CD.                                             
      *                                                                 07456000
           EXEC SQL                                                     
               SELECT YP.ATTRIBUTE_VALUE_CD                             
                 INTO :YP-ATTRIBUTE-VALUE-CD                            
                 FROM CSS_ACCT_ATTRIBUTE YP WITH(READUNCOMMITTED)               
                WHERE ACCOUNT_NO         = :YP-ACCOUNT-NO               
                  AND ATTRIBUTE_DESC     = :YP-ATTRIBUTE-DESC           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     07457000
MFA-TR*        SELECT YP.ATTRIBUTE_VALUE_CD                             07458000
MFA-TR*          INTO :YP-ATTRIBUTE-VALUE-CD                            07459000
MFA-TR*          FROM CSS_ACCT_ATTRIBUTE YP                             07460000
MFA-TR*         WHERE ACCOUNT_NO         = :YP-ACCOUNT-NO               07461000
MFA-TR*           AND ATTRIBUTE_DESC     = :YP-ATTRIBUTE-DESC           07462000
MFA-TR*          WITH UR                                                07463100
MFA-TR*       QUERYNO 7500                                                      
MFA-TR*    END-EXEC.                                                    07464000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE.           
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE SPACES               TO YP-ATTRIBUTE-VALUE-CD  
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '7500'                TO ACTIVE-PARAGRAPH       
                   MOVE 'SELECT'              TO ABEND-FUNCTION         
                   MOVE 'CSS_ACCT_ATTRIBUTE'  TO TABLE-1                
                   MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1        
                   MOVE YP-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1      
                   MOVE 'ATTRIBUTE_DESC'      TO TABLE-ELEMENT-2        
                   MOVE YP-ATTRIBUTE-DESC     TO HOSTVAR-ELEMENT-2      
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
ACT001******************************************************************07453000
ACT001* 7550-CHK-SHOPPING-RWRDS                                        *07454000
ACT001******************************************************************07455000
ACT001                                                                  
ACT001 7550-CHK-SHOPPING-RWRDS.                                         
ACT001                                                                  
ACT001     EXEC SQL                                                     
ACT001         SELECT 'Y'                                               
ACT001           INTO :WS-SHOPPING-RWRDS-FOUND                          
ACT001           FROM CSS_ACCT_ATTRIBUTE YP WITH(READUNCOMMITTED)               
ACT001          WHERE ACCOUNT_NO         = :YP-ACCOUNT-NO               
ACT001            AND ATTRIBUTE_DESC     = :YP-ATTRIBUTE-DESC           
ACT001            AND STATUS_CD          = :YP-STATUS-CD                
ACT001                                                           
ACT001                                                      
ACT001     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     07457000
MFA-TR*        SELECT 'Y'                                               07458000
MFA-TR*          INTO :WS-SHOPPING-RWRDS-FOUND                          07459000
MFA-TR*          FROM CSS_ACCT_ATTRIBUTE YP                             07460000
MFA-TR*         WHERE ACCOUNT_NO         = :YP-ACCOUNT-NO               07461000
MFA-TR*           AND ATTRIBUTE_DESC     = :YP-ATTRIBUTE-DESC           07462000
MFA-TR*           AND STATUS_CD          = :YP-STATUS-CD                07462000
MFA-TR*          WITH UR                                                07463100
MFA-TR*       QUERYNO 7550                                                      
MFA-TR*    END-EXEC.                                                    07464000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT001                                                                  
ACT001     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
ACT001                                         S-RETURN-CODE.           
ACT001                                                                  
ACT001     EVALUATE WS-ACTIVE-RETURN-CODE                               
ACT001         WHEN SUCCESSFUL-CALL                                     
ACT001              CONTINUE                                            
ACT001         WHEN NOT-FOUND                                           
ACT001              MOVE SPACES               TO YP-ATTRIBUTE-VALUE-CD  
ACT001         WHEN OTHER                                               
ACT001             MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
ACT001             MOVE '7550'                TO ACTIVE-PARAGRAPH       
ACT001             MOVE 'SELECT'              TO ABEND-FUNCTION         
ACT001             MOVE 'CSS_ACCT_ATTRIBUTE'  TO TABLE-1                
ACT001             MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1        
ACT001             MOVE YP-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1      
ACT001             MOVE 'ATTRIBUTE_DESC'      TO TABLE-ELEMENT-2        
ACT001             MOVE YP-ATTRIBUTE-DESC     TO HOSTVAR-ELEMENT-2      
ACT001             MOVE 'STATUS_CD'           TO TABLE-ELEMENT-3        
ACT001             MOVE YP-STATUS-CD          TO HOSTVAR-ELEMENT-3      
ACT001             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
ACT001     END-EVALUATE.                                                
ACT001                                                                  
ACT001 7550-EXIT.                                                       
ACT001     EXIT.                                                        
                                                                        
      ******************************************************************07453000
      * 7600-PROMO-RESPONSE.                                           *07454000
      ******************************************************************07455000
      *                                                                 07456000
       7600-PROMO-RESPONSE.                                             
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) PROMO_CHOICE_CD,
              REPLACE(REPLACE(CONVERT(CHAR(26), PROMO_OFFERED_TS, 121), 
           ' ', '-'), ':', '.') PROMO_OFFERED_TS                               
                 INTO :3A-PROMO-CHOICE-CD,                              
                      :3A-PROMO-OFFERED-TS                              
                 FROM CSS_SERVICE_PROMO [3A] WITH(READUNCOMMITTED)              
                WHERE CUSTOMER_NO        = :3A-CUSTOMER-NO              
                  AND PROMO_OFFERED_SERV = :3A-PROMO-OFFERED-SERV       
                  AND PROMO_STATUS_CD    = 'A'                          
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT PROMO_CHOICE_CD,                                          
MFA-TR*               PROMO_OFFERED_TS                                          
MFA-TR*          INTO :3A-PROMO-CHOICE-CD,                                      
MFA-TR*               :3A-PROMO-OFFERED-TS                                      
MFA-TR*          FROM CSS_SERVICE_PROMO 3A                                      
MFA-TR*         WHERE CUSTOMER_NO        = :3A-CUSTOMER-NO                      
MFA-TR*           AND PROMO_OFFERED_SERV = :3A-PROMO-OFFERED-SERV               
MFA-TR*           AND PROMO_STATUS_CD    = 'A'                                  
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7600                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE        
                                           S-RETURN-CODE.               
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 3A-PROMO-OFFERED-TS(1:10) TO WS-PROMO-DT        
               WHEN NOT-FOUND                                           
                   PERFORM 7610-PROMO-EXPIRATION THRU 7610-EXIT         
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '7600'                TO ACTIVE-PARAGRAPH       
                   MOVE 'SELECT'              TO ABEND-FUNCTION         
                   MOVE 'CSS_SERVICE_PROMO'   TO TABLE-1                
                   MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1        
                   MOVE 3A-CUSTOMER-NO        TO HOSTVAR-ELEMENT-1      
                   MOVE 'PROMO OFFERED SERV'  TO TABLE-ELEMENT-2        
                   MOVE 3A-PROMO-OFFERED-SERV TO HOSTVAR-ELEMENT-2      
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************07453000
      * 7610-PROMO-EXPIRATION.                                         *07454000
      ******************************************************************07455000
      *                                                                 07456000
       7610-PROMO-EXPIRATION.                                           
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) PROMO_CHOICE_CD,
              REPLACE(REPLACE(CONVERT(CHAR(26), PROMO_OFFERED_TS, 121), 
           ' ', '-'), ':', '.') PROMO_OFFERED_TS                               
                 INTO :3A-PROMO-CHOICE-CD,                              
                      :3A-PROMO-OFFERED-TS                              
                 FROM CSS_SERVICE_PROMO [3A] WITH(READUNCOMMITTED)              
                WHERE CUSTOMER_NO        = :3A-CUSTOMER-NO              
                  AND PROMO_OFFERED_SERV = :3A-PROMO-OFFERED-SERV       
                  AND PROMO_STATUS_CD    = 'E'                          
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT PROMO_CHOICE_CD,                                          
MFA-TR*               PROMO_OFFERED_TS                                          
MFA-TR*          INTO :3A-PROMO-CHOICE-CD,                                      
MFA-TR*               :3A-PROMO-OFFERED-TS                                      
MFA-TR*          FROM CSS_SERVICE_PROMO 3A                                      
MFA-TR*         WHERE CUSTOMER_NO        = :3A-CUSTOMER-NO                      
MFA-TR*           AND PROMO_OFFERED_SERV = :3A-PROMO-OFFERED-SERV               
MFA-TR*           AND PROMO_STATUS_CD    = 'E'                                  
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7610                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE        
                                           S-RETURN-CODE.               
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 3A-PROMO-OFFERED-TS(1:10) TO WS-PROMO-DT        
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO 3A-PROMO-CHOICE-CD                    
                                  3A-PROMO-OFFERED-TS                   
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '7610'                TO ACTIVE-PARAGRAPH       
                   MOVE 'SELECT'              TO ABEND-FUNCTION         
                   MOVE 'CSS_SERVICE_PROMO'   TO TABLE-1                
                   MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1        
                   MOVE 3A-CUSTOMER-NO        TO HOSTVAR-ELEMENT-1      
                   MOVE 'PROMO OFFERED SERV'  TO TABLE-ELEMENT-1        
                   MOVE 3A-PROMO-OFFERED-SERV TO HOSTVAR-ELEMENT-1      
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7610-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07456000
      ******************************************************************07453000
      * 7620-CHARGE-OFF-AMT.                                           *07454000
      ******************************************************************07455000
      *                                                                 07456000
       7620-CHARGE-OFF-AMT.                                             
                                                                        
           EXEC SQL                                                     
               SELECT SUM(AMT_TRANS)                                    
                 INTO :CO-AMT-TRANS :WS-NULL-IND3                        
                 FROM CSS_CHRG_OFF WITH(READUNCOMMITTED)                        
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                  AND DATE_OF_CHG_OFF >= IIF(TRY_CONVERT(DATE, 
                                                            :WS-WOFF-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-WOFF-DT) <> 0) OR (LEN(
                                                            :WS-WOFF-DT
              ) <> 10), CIS.CHAR2DATE(:WS-WOFF-DT), CONVERT(DATE, 
                                                            :WS-WOFF-DT
              ) )                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SUM(AMT_TRANS)                                            
MFA-TR*          INTO :CO-AMT-TRANS:WS-NULL-IND3                                
MFA-TR*          FROM CSS_CHRG_OFF                                              
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*           AND DATE_OF_CHG_OFF >= :WS-WOFF-DT                            
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7620                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE.           
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-IND3 < 0                                  
                       MOVE 0.00 TO CO-AMT-TRANS                        
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                                  CO-AMT-TRANS                          
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7620'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_CHRG_OFF'      TO TABLE-1                  
                   MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1          
                   MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7620-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************07453000
      * 7630-CUST-STATS.                                               *07454000
      ******************************************************************07455000
      *                                                                 07456000
       7630-CUST-STATS.                                                 
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) EBILL_REGISTER_IND                                 
                INTO :CE-EBILL-REGISTER-IND                             
                FROM CSS_CUST_STATS WITH(READUNCOMMITTED)                       
               WHERE CUSTOMER_NO = :CE-CUSTOMER-NO                      
                 AND CUSTOMER_TYPE = 'C'                                
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT EBILL_REGISTER_IND                                         
MFA-TR*         INTO :CE-EBILL-REGISTER-IND                                     
MFA-TR*         FROM CSS_CUST_STATS                                             
MFA-TR*        WHERE CUSTOMER_NO = :CE-CUSTOMER-NO                              
MFA-TR*          AND CUSTOMER_TYPE = 'C'                                        
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7630                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE.           
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE SPACES TO CE-EBILL-REGISTER-IND                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7630'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_CUST_STATS'    TO TABLE-1                  
                   MOVE 'CUSTOMER_NO'       TO TABLE-ELEMENT-1          
                   MOVE CE-CUSTOMER-NO      TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7630-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************07453000
      * 7640-SELECT-FINAL-WO.                                          *07454000
      ******************************************************************07455000
      *                                                                 07456000
       7640-SELECT-FINAL-WO.                                            
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) COLLECT_STATUS_CD,
              FINAL_BILL_AM                                      
                INTO :FW-COLLECT-STATUS-CD,                             
                     :FW-FINAL-BILL-AM                                  
                FROM CSS_FINAL_WO WITH(READUNCOMMITTED)                         
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COLLECT_STATUS_CD,                                         
MFA-TR*              FINAL_BILL_AM                                              
MFA-TR*         INTO :FW-COLLECT-STATUS-CD,                                     
MFA-TR*              :FW-FINAL-BILL-AM                                          
MFA-TR*         FROM CSS_FINAL_WO                                               
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7640                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE.           
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                                  FW-FINAL-BILL-AM                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '7640'                TO ACTIVE-PARAGRAPH       
                   MOVE 'SELECT'              TO ABEND-FUNCTION         
                   MOVE SPACES                TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
                   MOVE 'CSS_FINAL_WO'        TO TABLE-1                
                   MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1        
                   MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1      
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7640-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************07453000
      * 7650-SELECT-SO-DATA.                                          * 07454000
      ******************************************************************07455000
      *                                                                 07456000
        7650-SELECT-SO-DATA.                                            
      *                                                                 07456000
           EXEC SQL                                                     
               SELECT 'Y'                                               
                 INTO :WS-CC-NC-FL                                      
                 FROM CSS_SO_DATA VO WITH(READUNCOMMITTED),                     
                      CSS_ORDER_TYPE C2 WITH(READUNCOMMITTED),                  
                      CSS_WK_CLASS_STAT R6 WITH(READUNCOMMITTED)                
                WHERE PREMISE_NO       = :AT-PREMISE-NO                 
                  AND VO.ACCOUNT_NO    = :AT-ACCOUNT-NO                 
                  AND VO.ORDER_TYPE_CD = C2.ORDER_TYPE_CD               
                  AND VO.COMPANY_NO    = C2.COMPANY_NO                  
                  AND C2.WORK_CLASS_ID = R6.WORK_CLASS_ID               
                  AND VO.SERV_ORDER_STATUS = R6.SERV_ORDER_STATUS       
                  AND VO.ORDER_STATE_CD NOT IN('C')                     
                  AND VO.ORDER_TYPE_CD                                  
                   IN ('CC001','CC002','CC003','NC001')                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-CC-NC-FL                                              
MFA-TR*          FROM CSS_SO_DATA VO,                                           
MFA-TR*               CSS_ORDER_TYPE C2,                                        
MFA-TR*               CSS_WK_CLASS_STAT R6                                      
MFA-TR*         WHERE PREMISE_NO       = :AT-PREMISE-NO                         
MFA-TR*           AND VO.ACCOUNT_NO    = :AT-ACCOUNT-NO                         
MFA-TR*           AND VO.ORDER_TYPE_CD = C2.ORDER_TYPE_CD                       
MFA-TR*           AND VO.COMPANY_NO    = C2.COMPANY_NO                          
MFA-TR*           AND C2.WORK_CLASS_ID = R6.WORK_CLASS_ID                       
MFA-TR*           AND VO.SERV_ORDER_STATUS = R6.SERV_ORDER_STATUS               
MFA-TR*           AND VO.ORDER_STATE_CD NOT IN('C')                             
MFA-TR*           AND VO.ORDER_TYPE_CD                                          
MFA-TR*            IN ('CC001','CC002','CC003','NC001')                         
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               MOVE 'CSR04624'              TO ABEND-PROGRAM            
               MOVE '7650'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_SO_DATA'           TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE AT-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               MOVE 'PREMISE_NO'            TO TABLE-ELEMENT-2          
               MOVE AT-PREMISE-NO           TO HOSTVAR-ELEMENT-2        
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
           END-IF.                                                      
                                                                        
       7650-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
PRJ836* 7700-CHK-13-MNTHS-BILL-EXIST                                   *        
PRJ836******************************************************************        
PRJ836*                                                                         
PRJ836 7700-CHK-13-MNTHS-BILL-EXIST.                                    
PRJ836*                                                                         
PRJ836     EXEC SQL                                                     
PRJ836         SELECT TOP(1) 'Y'                                              
PRJ836           INTO  :WS-ADDTNL-BILLS-EXIST                           
PRJ836           FROM  CSS_BILLING_DET BG WITH(READUNCOMMITTED)                 
PRJ836          WHERE  BG.ACCOUNT_NO     = :BG-ACCOUNT-NO               
PRJ836            AND  BG.REVENUE_MONTH  < :BG-REVENUE-MONTH            
PRJ836            AND  BG.REVENUE_MONTH  > 0                            
PRJ836                                              
PRJ836                                                           
PRJ836     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  'Y'                                                      
MFA-TR*          INTO  :WS-ADDTNL-BILLS-EXIST                                   
MFA-TR*          FROM  CSS_BILLING_DET BG                                       
MFA-TR*         WHERE  BG.ACCOUNT_NO     = :BG-ACCOUNT-NO                       
MFA-TR*           AND  BG.REVENUE_MONTH  < :BG-REVENUE-MONTH                    
MFA-TR*           AND  BG.REVENUE_MONTH  > 0                                    
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PRJ836                                                                  
PRJ836     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
PRJ836                                                                  
PRJ836     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
PRJ836        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
PRJ836           MOVE WS-NO                  TO WS-ADDTNL-BILLS-EXIST   
PRJ836        END-IF                                                    
PRJ836     ELSE                                                         
PRJ836        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
PRJ836        MOVE '7700'                    TO ACTIVE-PARAGRAPH        
PRJ836        MOVE 'SELECT'                  TO ABEND-FUNCTION          
PRJ836        MOVE SPACES                    TO ABEND-SQL-PREDICATES    
PRJ836                                          ABEND-TABLES            
PRJ836        MOVE 'CSS_BILLING_DET'         TO TABLE-1                 
PRJ836        MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
PRJ836        MOVE 'REVENUE_MONTH'           TO TABLE-ELEMENT-2         
PRJ836        MOVE BG-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
PRJ836        MOVE BG-REVENUE-MONTH          TO HOSTVAR-ELEMENT-2       
PRJ836        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
PRJ836     END-IF.                                                      
PRJ836*                                                                         
PRJ836 7700-EXIT.                                                       
PRJ836      EXIT.                                                       
PRJ836*                                                                         
P805CS******************************************************************07453000
P805CS* 7800-SELECT-MKT-TIER.                                          *07454000
P805CS******************************************************************07455000
P805CS*                                                                 07456000
P805CS 7800-SELECT-MKT-TIER.                                            
P805CS*                                                                         
P805CS     EXEC SQL                                                     
P805CS        SELECT TOP(1) DD.TIER_ACCT_TYPE_CD                              
P805CS          INTO :DD-TIER-ACCT-TYPE-CD                              
P805CS          FROM  CSS_ACCT_MKT_TIER DD WITH(READUNCOMMITTED)                
P805CS         WHERE  DD.ACCOUNT_NO     = :DD-ACCOUNT-NO                
P805CS           AND  DD.EFF_START_DT   =                               
P805CS                      (SELECT MAX(ZZ.EFF_START_DT)                
P805CS                         FROM CSS_ACCT_MKT_TIER ZZ
                           WITH(READUNCOMMITTED)                
P805CS                        WHERE ZZ.ACCOUNT_NO = DD.ACCOUNT_NO)      
P805CS                                              
P805CS                                                           
P805CS                                                      
P805CS     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  DD.TIER_ACCT_TYPE_CD                              41146600
MFA-TR*         INTO :DD-TIER-ACCT-TYPE-CD                              41146600
MFA-TR*         FROM  CSS_ACCT_MKT_TIER DD                              41146600
MFA-TR*        WHERE  DD.ACCOUNT_NO     = :DD-ACCOUNT-NO                41146600
MFA-TR*          AND  DD.EFF_START_DT   =                               41146600
MFA-TR*                     (SELECT MAX(ZZ.EFF_START_DT)                41146600
MFA-TR*                        FROM CSS_ACCT_MKT_TIER ZZ                41146600
MFA-TR*                       WHERE ZZ.ACCOUNT_NO = DD.ACCOUNT_NO)      41146600
MFA-TR*        FETCH FIRST ROW ONLY                                     41146600
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7800                                                     
MFA-TR*    END-EXEC.                                                    41146600

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P805CS                                                                  
P805CS     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
P805CS                                         S-RETURN-CODE.           
P805CS                                                                  
P805CS     EVALUATE WS-ACTIVE-RETURN-CODE                               
P805CS         WHEN SUCCESSFUL-CALL                                     
P805CS             CONTINUE                                             
P805CS         WHEN NOT-FOUND                                           
P805CS             MOVE SPACES              TO DD-TIER-ACCT-TYPE-CD     
P805CS         WHEN OTHER                                               
P805CS             MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
P805CS             MOVE '7800'              TO ACTIVE-PARAGRAPH         
P805CS             MOVE 'SELECT'            TO ABEND-FUNCTION           
P805CS             MOVE SPACES              TO ABEND-SQL-PREDICATES     
P805CS                                         ABEND-TABLES             
P805CS             MOVE 'CSS_ACCT_MKT_TIER' TO TABLE-1                  
P805CS             MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1          
P805CS             MOVE DD-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1        
P805CS             PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT           
P805CS     END-EVALUATE.                                                
P805CS*                                                                         
P805CS 7800-EXIT.                                                       
P805CS     EXIT.                                                        
P805CS*                                                                         
P805CS******************************************************************07453000
P805CS* 7850-CHECK-CORE-RATE.                                          *07454000
P805CS******************************************************************07455000
P805CS*                                                                 07456000
P805CS 7850-CHECK-CORE-RATE.                                            
P805CS*                                                                         
P805CS     EXEC SQL                                                     
P805CS        SELECT TOP(1) 'Y'                                               
P805CS          INTO :WS-NEW-CSC-CORE-RATE                              
P805CS          FROM  CSS_UTIL_ENVRNMT   UT WITH(READUNCOMMITTED)               
P805CS               ,CSS_ACCT_RTPK_AGR  DF WITH(READUNCOMMITTED)               
P805CS               ,CRM_RT_PKG_OPTION  FI WITH(READUNCOMMITTED)               
P805CS         WHERE  UT.ACCOUNT_NO       = :UT-ACCOUNT-NO              
P805CS           AND  DF.ACCOUNT_NO       =  UT.ACCOUNT_NO              
P805CS           AND  DF.CODE_UTIL_TYPE   =  UT.CODE_UTIL_TYPE          
P805CS           AND  DF.IC_NO            =  UT.IC_NO                   
P805CS           AND  DF.STATUS_CD        = :DF-STATUS-CD               
P805CS           AND  FI.OPTION_CD        =  DF.OPTION_CD               
P805CS           AND  FI.OPTION_START_DT <=  CAST(SYSDATETIMEOFFSET() 
           AS DATE)               
P805CS           AND  FI.OPTION_END_DT   >=  CAST(SYSDATETIMEOFFSET() 
           AS DATE)               
P805CS           AND  FI.OPT_VSTART_TS   <=  CIS.CURRENT$TIMESTAMP()          
P805CS           AND  FI.OPT_VEND_TS     >=  CIS.CURRENT$TIMESTAMP()          
P805CS           AND  FI.PROC_STATUS_CD   = 'AC'                        
P805CS           AND  FI.RATE_PLAN_NO NOT IN                            
P805CS                        (SELECT  CIS.SUBSTR3(G6.PARM_DATA,13,3)        
P805CS                           FROM  CSS_JOB_PARM G6
                           WITH(READUNCOMMITTED)                  
P805CS                          WHERE  G6.CMND_CODE = 'OPTN'            
P805CS                            AND (G6.PARM_DATA LIKE 'OLDCSC_RATE%' 
P805CS                             OR  G6.PARM_DATA LIKE 'LEGACY_RATE%')
P805CS                            AND  G6.STATUS    = 'A')              
P805CS         ORDER BY FI.OPT_VRSN_NO DESC                             
P805CS                                              
P805CS                                                           
P805CS                                                      
P805CS     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  'Y'                                               41146600
MFA-TR*         INTO :WS-NEW-CSC-CORE-RATE                              41146600
MFA-TR*         FROM  CSS_UTIL_ENVRNMT   UT                                     
MFA-TR*              ,CSS_ACCT_RTPK_AGR  DF                                     
MFA-TR*              ,CRM_RT_PKG_OPTION  FI                                     
MFA-TR*        WHERE  UT.ACCOUNT_NO       = :UT-ACCOUNT-NO                      
MFA-TR*          AND  DF.ACCOUNT_NO       =  UT.ACCOUNT_NO                      
MFA-TR*          AND  DF.CODE_UTIL_TYPE   =  UT.CODE_UTIL_TYPE                  
MFA-TR*          AND  DF.IC_NO            =  UT.IC_NO                           
MFA-TR*          AND  DF.STATUS_CD        = :DF-STATUS-CD                       
MFA-TR*          AND  FI.OPTION_CD        =  DF.OPTION_CD                       
MFA-TR*          AND  FI.OPTION_START_DT <=  CURRENT DATE                       
MFA-TR*          AND  FI.OPTION_END_DT   >=  CURRENT DATE                       
MFA-TR*          AND  FI.OPT_VSTART_TS   <=  CURRENT TIMESTAMP                  
MFA-TR*          AND  FI.OPT_VEND_TS     >=  CURRENT TIMESTAMP                  
MFA-TR*          AND  FI.PROC_STATUS_CD   = 'AC'                                
MFA-TR*          AND  FI.RATE_PLAN_NO NOT IN                                    
MFA-TR*                       (SELECT  SUBSTR(G6.PARM_DATA,13,3)                
MFA-TR*                          FROM  CSS_JOB_PARM G6                          
MFA-TR*                         WHERE  G6.CMND_CODE = 'OPTN'                    
MFA-TR*                           AND (G6.PARM_DATA LIKE 'OLDCSC_RATE%'         
MFA-TR*                            OR  G6.PARM_DATA LIKE 'LEGACY_RATE%')        
MFA-TR*                           AND  G6.STATUS    = 'A')                      
MFA-TR*        ORDER BY FI.OPT_VRSN_NO DESC                                     
MFA-TR*        FETCH FIRST ROW ONLY                                     41146600
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7850                                                     
MFA-TR*    END-EXEC.                                                    41146600

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P805CS                                                                  
P805CS     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
P805CS                                         S-RETURN-CODE.           
P805CS                                                                  
P805CS     EVALUATE WS-ACTIVE-RETURN-CODE                               
P805CS         WHEN SUCCESSFUL-CALL                                     
P805CS             CONTINUE                                             
P805CS         WHEN NOT-FOUND                                           
P805CS             MOVE 'N'                 TO WS-NEW-CSC-CORE-RATE     
P805CS         WHEN OTHER                                               
P805CS             MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
P805CS             MOVE '7850'              TO ACTIVE-PARAGRAPH         
P805CS             MOVE 'SELECT'            TO ABEND-FUNCTION           
P805CS             MOVE SPACES              TO ABEND-SQL-PREDICATES     
P805CS                                         ABEND-TABLES             
P805CS             MOVE 'CSS_ACCT_RTPK_AGR' TO TABLE-1                  
P805CS             MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1          
P805CS             MOVE DF-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1        
P805CS             MOVE 'STATUS_CD'         TO TABLE-ELEMENT-2          
P805CS             MOVE DF-STATUS-CD        TO HOSTVAR-ELEMENT-2        
P805CS             PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT           
P805CS     END-EVALUATE.                                                
P805CS*                                                                         
P805CS 7850-EXIT.                                                       
P805CS     EXIT.                                                        
P805CS*                                                                         
      ******************************************************************        
      * 8000A-DEL-GTT-ROWS.                                            *        
      ******************************************************************        
      *                                                                         
       8000A-DEL-GTT-ROWS.                                              
      *                                                                         
           EXEC SQL                                                     
               DELETE FROM #CSR04624_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04624_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE.              
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES          TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE               
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME    TO ABEND-PROGRAM               
                    MOVE SQLCODE         TO ABEND-SQLCODE               
                    MOVE SQLSTATE        TO ABEND-SQLSTATE              
                    MOVE '8000A'         TO ACTIVE-PARAGRAPH            
                    MOVE 'DELETE'        TO ABEND-FUNCTION              
                    MOVE SPACES          TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                    MOVE 'CSR04624_R1'   TO TABLE-1                     
                    MOVE SPACES          TO TABLE-ELEMENT-1             
                    MOVE SPACES          TO HOSTVAR-ELEMENT-1           
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
      *                                                                         
       8000A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8010-INSERT-GTT-R1.                                            *        
      ******************************************************************        
      *                                                                         
       8010-INSERT-GTT-R1.                                              
      *                                                                         
            EXEC SQL                                                    
               INSERT INTO #CSR04624_R1                          
                  (                                                     
                    RETURN_CODE                                         
                   ,ATTRIBUTE_NAME                                      
                   ,ATTRIBUTE_CURRENT_STATUS                            
                   ,ATTRIBUTE_ELIGIBLE                                  
                   ,ATTRIBUTE_REJECTED                                  
P805CS             ,ATTR_CSC_DSCNT_ELIGIBLE                             
P805CS             ,ATTR_CSC_DSCNT_ICON_TYPE                            
P805CS             ,BUS_RULE_ID                                         
P805CS             ,RULE_RESULT_CD                                      
P805CS             ,BUS_RULE_XREF_ID                                    
P805CS             ,MESSAGE_PARMS                                       
P805CS             ,MESSAGE_HEADER                                      
                  )                                                     
               VALUES                                                   
                  (                                                     
                    :S-RETURN-CODE                                      
                   ,:S-ATTRIBUTE                                        
                   ,:S-CURR-STATUS                                      
                   ,:S-ELIGIBLE                                         
                   ,:S-REJECTED                                         
P805CS             ,:S-CSC-DSCNT-ELIGIBLE                               
P805CS             ,:S-CSC-DSCNT-ICON-TYPE                              
P805CS             ,:S-BUS-RULE-ID                                      
P805CS             ,:S-BUS-RULE-RESULT-CD                               
P805CS             ,:S-BUS-RULE-XREF-ID                                 
P805CS             ,:S-MESSAGE-PARMS                                    
P805CS             ,:S-MESSAGE-HEADER                                   
                  )                                                     
            END-EXEC                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*        INSERT INTO SESSION.CSR04624_R1                                  
MFA-TR*           (                                                             
MFA-TR*             RETURN_CODE                                                 
MFA-TR*            ,ATTRIBUTE_NAME                                              
MFA-TR*            ,ATTRIBUTE_CURRENT_STATUS                                    
MFA-TR*            ,ATTRIBUTE_ELIGIBLE                                          
MFA-TR*            ,ATTRIBUTE_REJECTED                                          
MFA-TR*            ,ATTR_CSC_DSCNT_ELIGIBLE                                     
MFA-TR*            ,ATTR_CSC_DSCNT_ICON_TYPE                                    
MFA-TR*            ,BUS_RULE_ID                                                 
MFA-TR*            ,RULE_RESULT_CD                                              
MFA-TR*            ,BUS_RULE_XREF_ID                                            
MFA-TR*            ,MESSAGE_PARMS                                               
MFA-TR*            ,MESSAGE_HEADER                                              
MFA-TR*           )                                                             
MFA-TR*        VALUES                                                           
MFA-TR*           (                                                             
MFA-TR*             :S-RETURN-CODE                                              
MFA-TR*            ,:S-ATTRIBUTE                                                
MFA-TR*            ,:S-CURR-STATUS                                              
MFA-TR*            ,:S-ELIGIBLE                                                 
MFA-TR*            ,:S-REJECTED                                                 
MFA-TR*            ,:S-CSC-DSCNT-ELIGIBLE                                       
MFA-TR*            ,:S-CSC-DSCNT-ICON-TYPE                                      
MFA-TR*            ,:S-BUS-RULE-ID                                              
MFA-TR*            ,:S-BUS-RULE-RESULT-CD                                       
MFA-TR*            ,:S-BUS-RULE-XREF-ID                                         
MFA-TR*            ,:S-MESSAGE-PARMS                                            
MFA-TR*            ,:S-MESSAGE-HEADER                                           
MFA-TR*           )                                                             
MFA-TR*     END-EXEC                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE.              
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                     TO  CTR-ROWS                   
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8010'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04624_R1'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
        8010-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8800-CHECK-RESULTS.                                            *        
      ******************************************************************        
      *                                                                         
       8800-CHECK-RESULTS.                                              
      *                                                                         
           IF CTR-ROWS      <= 0                                        
              INITIALIZE GTT-RETURN-FIELDS                              
              MOVE 100                      TO S-RETURN-CODE            
              PERFORM 8010-INSERT-GTT-R1    THRU 8010-EXIT              
           END-IF.                                                      
      *                                                                         
       8800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8900-SEND-DONE.                                                *        
      ******************************************************************        
      *                                                                         
       8900-SEND-DONE.                                                  
      *                                                                         
           ADD          +1               TO CTR-ROWS.                   
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE.              
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE '8900'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE 'CSR04624_R1'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 00300000
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ******************************************************************        
      * 9700-ABEND-PROCESSING.                                         *        
      ******************************************************************        
      *                                                                         
       9000-SEND-ERROR-RESULT.                                          
      *                                                                         
           IF S-RETURN-CODE NOT EQUAL ZERO                              
               MOVE S-RETURN-CODE   TO WS-RETURN-CODE                   
           END-IF.                                                      
      *                                                                         
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE 'N'                      TO SEND-DONE-SW.               
           MOVE WS-ACTIVE-RETURN-CODE    TO ABEND-SQLCODE.              
           MOVE SQLERRMC                 TO ABEND-SQLERRMC.             
      *                                                                         
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'            TO ABEND-FUNCTION              
           END-IF.                                                      
      *                                                                         
           PERFORM 0100A-DECLARE-GTT     THRU 0100A-EXIT.               
      *                                                                         
           MOVE WS-RETURN-CODE           TO S-RETURN-CODE.              
      *                                                                 00339704
           PERFORM 8010-INSERT-GTT-R1    THRU 8010-EXIT.                
                                                                        
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9700-ABEND-PROCESSING.                                         *        
      ******************************************************************        
      *                                                                         
       9700-PROCESS-ABEND.                                              
      *                                                                         
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT.            
      *                                                                         
       9700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9900-SQL-ERROR-ROUTINE.                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 9999-END-PROGRAM.                                      *                
      ******************************************************************        
      *                                                                         
       9999-END-PROGRAM.                                                
      *                                                                         
           IF CTR-ROWS < 1                                              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '9999-END-PROGRAM'    TO ABEND-FUNCTION              
              MOVE 'PROGRAMMER LOGIC'    TO TABLE-1                     
              MOVE 'FAILED TO SEND'      TO TABLE-ELEMENT-1             
              MOVE 'RESULT SET'          TO HOSTVAR-ELEMENT-1           
              MOVE -1                    TO WS-ACTIVE-RETURN-CODE       
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           ELSE                                                         
              PERFORM 8800-CHECK-RESULTS THRU 8800-EXIT                 
              PERFORM 8900-SEND-DONE     THRU 8900-EXIT                 
           
MSQ016        GOBACK
           END-IF.                                                    
      *                                                                         
       9999-EXIT.                                                       
           EXIT.                                                        
