       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       CSR04623.                                      
COB303 DATE-WRITTEN.     MAR 29, 2013.                                  
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM RETRIEVES ACCOUNT BILLING HISTORY AND DETAILS FOR*        
      *  PAST 24 MONTHS. THIS SP CALLED FROM CIS & IN WEB APPLICATION. *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
P00724*  03/29/13  HA7A338    CLONED FROM CSR02093 & REMOVED UNWANTED  *        
PRJ724*  08/29/14  JC91900    Fixed an issue with account number not   *        
      *                       getting populated.                       *        
P00821*  09/17/14  MN90523    Add REV_MTH_ORIG_BILL, CIG_FLAG          *        
P00821*                       INDUST_GAS_CUST, PSNC_FLAG               *        
P00821*                       NET_MTR_ACCOUNT, EMC_FLAG                *        
P00821*                       Fix the Total Bill Amount                *        
PRJ821*  10/29/14  AD7F921    ADDED NEW COLUMN IN RS3 AS ACCT_BILLS_COU*        
PRJ821*                       -NT TO GET THE NOCUT BILLS FOR ACCOUNT   *        
PRJ821*  11/11/14  AD7F921    ADDED ADDITIONAL BILL MONTHS FLAG LOGIC  *        
PRJ821*                       FOR CONSOLIDATED MASTER ACCOUNT ADDED    *        
PRJ821*                       7145-PARA TO ACOMPLISH THIS.             *        
ACT294*  01/13/15  HA7A338    FIX PAYMENTS DISPLAY ISSUE. DO NOT INCL- *        
ACT294* A04880                PAYMENT CORRECTIONS.                     *        
P00821*  03/02/15  HA7A338    FIXED TOTAL BILL AMOUNT ISSUE FOR MASTER *        
P00821*                       ACCOUNT ALSO DELETED THE COMMENTED CHECK *        
P00821*                       TO MOVE TOTAL BILL AMOUNT.               *        
ACT063* 03/16/15    BD09555   PREVENT -811 ERROR WHEN MORE THAN ROW    *        
ACT063* A05136                EXISTS PER IC ON CSS_CUST_PLAN           *        
P00821*  04/28/15  MN90523    ADD DATE ORIG BILL IN S2                 *        
P00899*  06/25/15  HA7A338    ADD BILL RELEASED FLAG AND SECUR FLAG AT *        
P00899*                       IC LEVEL & ACCT LAST UPDT TS IN RS3      *        
P00836** 08/22/15  GD43988    WEB BILL HISTORY CHANGES.APPL PROGRAMS: **        
P00836**                      WBH(WEB BILL HISTORY - ALL HISTORY)     **        
P00836**                      WBC(WEB BILL HISTORY - CHART)           **        
P00836**                      WBR(WEB BILL HISTORY - RECENT BILLS)    **        
P00899*  10/19/15  HA7A338    ADD MULT REGISTER FLAG AT IC LEVEL IN RS2*        
P00899*  02/04/16  HA7A338    SET FUTURE BILL HOOK INSERT FLAG 'Y' WHEN*        
P00899*                       ACCOUNT HAS NO FUTURE BILL.              *        
A05460*  05/17/16  HA7A338    INCLUDE TURN OFF METER WHILE TAKE THE IC *        
A05460*                       COUNT TO SET THE FUTURE BILL HOOK INSERT *        
A05460*                       FLAG.                                    *        
WEBFIX*  03/09/17  GD43988    A05745:FIX WEB SORT ORDER ISSUE.         *        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04623'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04623 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      * CSS_BILLING_HDR,     BI                                                 
           EXEC SQL                                                             
               INCLUDE TBBLLHDR                                                 
           END-EXEC.                                                            
                                                                        
      * CSS_BILLING_DET,     BG                                                 
           EXEC SQL                                                             
               INCLUDE TBBLLDET                                                 
           END-EXEC.                                                            
                                                                        
      * CSS_CNSMPTN_HIST,    CX                                                 
           EXEC SQL                                                             
               INCLUDE TBCNSMP                                                  
           END-EXEC.                                                            
                                                                        
      * CSS_AR_TRANS_HIST,   AR                                                 
           EXEC SQL                                                             
               INCLUDE TBARHIST                                                 
           END-EXEC.                                                            
                                                                        
      * CSS_BILL_CALC_DET,   BZ                                                 
           EXEC SQL                                                             
               INCLUDE TBBLCLDT                                                 
           END-EXEC.                                                            
                                                                        
      * CSS_UM_CNSMPT_HIST,  UC                                                 
           EXEC SQL                                                             
               INCLUDE TBUMCNSM                                                 
           END-EXEC.                                                            
                                                                        
      * CSS_CUST_PLAN,       CP                                                 
           EXEC SQL                                                             
               INCLUDE TBCSTPLN                                                 
           END-EXEC.                                                            
                                                                        
      * CSS_JOB_PARM,        G6                                                 
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
                                                                        
      * CSS_DELINQUENCY,     C8                                                 
           EXEC SQL                                                             
               INCLUDE TBDELQ                                                   
           END-EXEC.                                                            
                                                                        
      * CRM_RT_PKG_OPTION,   FI                                                 
           EXEC SQL                                                             
               INCLUDE TBRTPKGO                                                 
           END-EXEC.                                                            
                                                                        
      * CSS_ACCOUNT,         AT                                                 
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
                                                                        
      * CSS_ACCT_RTPK_AGR,   DF                                                 
           EXEC SQL                                                             
               INCLUDE TBACCTRG                                                 
           END-EXEC.                                                            
                                                                        
      * CSS_UTIL_ENVRNMT,    UT                                                 
           EXEC SQL                                                             
               INCLUDE TBUTLENV                                                 
           END-EXEC.                                                            
                                                                        
      * CSS_RATE_COMP_DEF,   J1                                                 
           EXEC SQL                                                             
               INCLUDE TBRTCDEF                                                 
           END-EXEC.                                                            
                                                                        
      * CSS_RATE_PLAN_DESC,  RD                                                 
           EXEC SQL                                                             
               INCLUDE TBRTDESC                                                 
           END-EXEC.                                                            
                                                                        
      * CSS_BILL_ACCT_XFER,  AF                                                 
           EXEC SQL                                                             
               INCLUDE TBBLACXF                                                 
           END-EXEC.                                                            
                                                                        
      * CSS_NAME_ACCT_XREF,  HT                                                 
           EXEC SQL                                                             
               INCLUDE TBNMACTX                                                 
           END-EXEC.                                                            
                                                                        
      * CSS_ADDR_FORMATTED,  DY                                                 
           EXEC SQL                                                             
               INCLUDE TBADRFMT                                                 
           END-EXEC.                                                            
                                                                        
      * CSS_BILL_WINDOW,     BN                                                 
           EXEC SQL                                                             
             INCLUDE TBBILWDW                                                   
           END-EXEC.                                                            
                                                                        
P00821* CSS_MKT_XREF_ACCT,   XM                                                 
P00821     EXEC SQL                                                             
P00821         INCLUDE TBMRKXR                                                  
P00821     END-EXEC.                                                            
P00821                                                                  
P00821* CSS_BILL_ADJUSTMNT BP                                                   
P00821     EXEC SQL                                                             
P00821       INCLUDE TBBILADJ                                                   
P00821     END-EXEC.                                                            
P00821                                                                  
P00821* CSS_PRTY_SVC_CAT   Z4                                                   
P00821     EXEC SQL                                                             
P00821       INCLUDE TBSVCCAT                                                   
P00821     END-EXEC.                                                            
P00899                                                                  
P00899* CSS_OFF_CYCL_ACCT  OC                                                   
P00899     EXEC SQL                                                             
P00899       INCLUDE TBOFFCYL                                                   
P00899     END-EXEC.                                                            
P00836*                                                                         
P00836* CSS_WQ_CATEGORY, C3                                                     
P00836     EXEC SQL                                                             
P00836       INCLUDE TBWQCAT                                                    
P00836     END-EXEC.                                                            
P00836*                                                                         
P00836*** CSS_WQ_ITEMS, WQ                                                      
P00836     EXEC SQL                                                             
P00836       INCLUDE TBWQITS                                                    
P00836     END-EXEC.                                                            
P00836*                                                                         
P00836*** CSS_BILL_CRED_DET, 1H                                                 
P00836     EXEC SQL                                                             
P00836       INCLUDE TBCRBLDL                                                   
P00836     END-EXEC.                                                            
P00836*                                                                         
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      *COMMON SYSTEM AREA                                                       
           COPY CCA00001.                                                       
                                                                        
      *ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS                           
           COPY CWS00027.                                                       
                                                                        
      *ERROR HANDLING                                                           
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
                                                                        
      *SUPPORTS DB2 AND SQL ERROR CHECKING                                      
           COPY CWS00303.                                                       
                                                                        
      *SUPPORTS JOB PARM CALCULATION                                            
           COPY CWS00038.                                                       
                                                                        
      *SUPPORTS ADDRESS FORMAT                                                  
           COPY CWS00011.                                                       
                                                                        
P00821*SUPPORTS JOB PARM                                                        
P00821     COPY FIOJC01.                                                        
                                                                        
      *                                                                         
       01  WS-ACCUMULATORS.                                             
           05 WS-NO-DAYS                PIC S9(5) VALUE 0 COMP-3.       
           05 WS-ACCUM-NO-KVA           PIC S9(5) VALUE 0 COMP-3.       
           05 WS-ACCUM-NO-DAYS          PIC S9(5) VALUE 0 COMP.         
           05 WS-ACCUM-NO-UNITS         PIC S9(9) VALUE 0 COMP-3.       
           05 WS-ACCUM-UNITS-TP         PIC S9(9) VALUE 0 COMP-3.       
           05 WS-ACCUM-READ-UNITS       PIC S9(9) VALUE 0 COMP-3.       
           05 WS-AMT-TAXES              PIC S9(9)V99                    
                                                  VALUE 0 COMP-3.       
           05 WS-TOTAL-BG-DOLLARS       PIC S9(9)V99                    
                                                  VALUE 0.              
      *                                                                         
       01  WS-COUNTERS.                                                 
           05 CTR-ROWS-RS1              PIC S9(9) VALUE 0 COMP.         
           05 CTR-ROWS-RS2              PIC S9(9) VALUE 0 COMP.         
           05 CTR-ROWS-RS3              PIC S9(9) VALUE 0 COMP.         
P00836     05 CTR-ROWS-RS4              PIC S9(9) VALUE 0 COMP.         
P00899     05 WS-IC-COUNT               PIC S9(4) VALUE 0 COMP.         
      *                                                                         
P00836 01  WS-WEBMOD-VARIABLES.                                         
P00836     05 WS-WEB-REV-MTH-CURR     PIC S9(6)V USAGE COMP-3 VALUE 0.  
P00836     05 WS-WEB-REV-MTH-PREV     PIC S9(6)V USAGE COMP-3 VALUE 0.  
P00836     05 WS-WEB-REV-MTH-LATEST   PIC S9(6)V USAGE COMP-3 VALUE 0.  
P00836     05 WS-WEB-BILL-TYPE-LATEST PIC X(01) VALUE SPACES.           
P00836     05 WS-WEB-REV-MTH-CH       PIC  9(6)  VALUE 0.               
P00836     05 WS-TOTAL-ELEC-CHARGES   PIC S9(9)V99 COMP-3 VALUE 0.      
P00836     05 WS-TOTAL-GAS-CHARGES    PIC S9(9)V99 COMP-3 VALUE 0.      
P00836     05 WS-TOTAL-UNMTR-CHARGES  PIC S9(9)V99 COMP-3 VALUE 0.      
P00836     05 WS-TOTAL-TAXES          PIC S9(9)V99 COMP-3 VALUE 0.      
P00836     05 WS-TEMP-UTIL-CHARGES    PIC S9(9)V99 COMP-3 VALUE 0.      
P00836     05 WS-CODE-BILL-TYPE-PREV  PIC X(01) VALUE SPACES.           
P00836     05 WS-SHOW-LATEST-BILL-FL  PIC X(01) VALUE 'Y'.              
P00836*                                                                         
       01  WS-MISC.                                                     
           05 WS-TP-COMP                PIC S9(4) USAGE COMP VALUE 0.   
           05 WS-REG-ID-COMP            PIC S9(4) USAGE COMP VALUE 0.   
           05 WS-REG-TYPE-CD            PIC X(01) VALUE SPACES.         
P00821     05 WS-BAL-FWD-CD             PIC X(01) VALUE SPACES.         
           05 WS-ACCOUNT-NO             PIC S9(13)V                     
                                                  VALUE 0 COMP-3.       
           05 WS-BILL-NO                PIC S9(9) VALUE 0 COMP.         
P00821     05 WS-BI-BILL-NO             PIC S9(9) VALUE 0 COMP.         
P00821     05 WS-BG-ROW-COUNT           PIC S9(9) VALUE 0 COMP-3.       
P00821     05 WS-UT-ROW-COUNT           PIC S9(9) VALUE 0 COMP-3.       
           05 WS-INCLD-ADDTNL-HIST      PIC X(01) VALUE 'N'.            
           05 WS-NO-OF-BILLS            PIC S9(4) VALUE 0 COMP.         
           05 WS-HOLD-REV-MM            PIC S9(6) VALUE 0.              
P00821     05 WS-HOLD-REV-MM-CHAR       PIC X(6).                       
           05 WS-MTR-REF-COMP           PIC S9(4) USAGE COMP VALUE 0.   
           05 WS-APPL-RETURN-CODE       PIC S9(9) VALUE 0.              
           05 WS-PREV-RT-PKG-SEQ-NO     PIC S9(4) USAGE COMP VALUE 0.   
           05 WS-INDX-COUNT             PIC S9(4) USAGE COMP VALUE 0.   
           05 WS-AGL-CREDIT             PIC S9(09)V9999                 
                                                  VALUE 0 COMP-3.       
           05 WS-AGL-DEBIT              PIC S9(09)V9999                 
                                                  VALUE 0 COMP-3.       
           05 WS-CUTOFF-CNT             PIC 9(03) VALUE 0.              
           05 WS-PREVBILL-AR-TRNSHIST-SEQ                               
                                        PIC X(26) VALUE SPACES.         
           05 WS-CURRBILL-AR-TRNSHIST-SEQ                               
                                        PIC X(26) VALUE SPACES.         
           05 WS-ITM-IND-STATUS.                                        
              10  WS-CODE-BILL-ITM-IND  PIC X(01).                      
              10  WS-CODE-ITEM-STATUS   PIC X(01).                      
P00821     05 WS-PGRMNAME              PIC X(08).                       
P00821     05 WS-CUTOFF-DATA-BREAKDOWN.                                 
P00821         10  WS-SYSINPUT         PIC  X(12).                      
P00821             88  CUT-OFF-DATE                                     
P00821               VALUE 'CUT OFF DATE'.                              
P00821         10  FILLER              PIC  X(01).                      
P00821         10  WS-INPUT-CUT-DATE.                                   
P00821             15  WS-INPUT-CUT-DATE-CC    PIC  X(02).              
P00821             15  WS-INPUT-CUT-DATE-YY    PIC  X(02).              
P00821             15    FILLER                PIC  X(01).              
P00821             15  WS-INPUT-CUT-DATE-MM    PIC  X(02).              
P00821             15    FILLER                PIC  X(01).              
P00821             15  WS-INPUT-CUT-DATE-DD    PIC  X(02).              
P00821         10  FILLER                      PIC  X(58).              
P00821     05 WS-TEMP-DATE-CCYYMMDD.                                    
P00821        10  WS-TEMP-CC           PIC X(02) VALUE SPACES.          
P00821        10  WS-TEMP-YY           PIC X(02) VALUE SPACES.          
P00821        10  FILLER               PIC X(01) VALUE '-'.             
P00821        10  WS-TEMP-MM           PIC X(02) VALUE SPACES.          
P00821        10  FILLER               PIC X(01) VALUE '-'.             
P00821        10  WS-TEMP-DD           PIC X(04) VALUE SPACES.          
P00821     05 WS-PARM-DATA             PIC X(80) VALUE SPACES.          
P00821     05 WS-PARM-DATA-RED   REDEFINES WS-PARM-DATA.                
P00821        10 WS-PARM-DESC          PIC X(23).                       
P00821        10 WS-PARM-CUT-REV       PIC X(06).                       
P00821        10 FILLER                PIC X(51).                       
P00821     05 WS-EMC-REV-MM            PIC X(06) VALUE SPACES.          
P00821     05 WS-COBB-SNAPSHOAL        PIC X(01) VALUE SPACES.          
P00899     05 WS-MULT-REG-FLG          PIC X(01) VALUE SPACES.          
                                                                        
P00899 01  WS-IC-DTLS-TABLE.                                            
P00899     05 WS-IC-DTLS-DATA OCCURS 15 TIMES                           
P00899                          INDEXED BY WS-IC-INDX.                  
P00899        10 WS-IC-NO               PIC S9(4) VALUE 0 COMP.         
P00899        10 WS-UTIL-TYPE           PIC X(01) VALUE SPACES.         
P00899        10 WS-MULT-REG-FL         PIC X(01) VALUE SPACES.         
P00899                                                                  
       01  WS-RATE-DESC-TABLE.                                          
           05 WS-RATE-DESC-DATA OCCURS 75 TIMES                         
                                INDEXED BY WS-RATE-INDX.                
              10 WS-RATE-PLAN-NO        PIC X(03).                      
              10 WS-UTIL-TYPE-CODE      PIC X(01).                      
              10 WS-RATE-DESC           PIC X(50).                      
P00821        10 WS-UNMTR-PROV-FL       PIC X(01).                      
P00899        10 WS-SECUR-RATE-FL       PIC X(01).                      
                                                                        
       01  WS-NULL-INDICATORS.                                          
           05 WS-NULL-IND-1             PIC S9(4) COMP.                 
           05 WS-NULL-IND-2             PIC S9(4) COMP.                 
           05 WS-NULL-IND-3             PIC S9(4) COMP.                 
           05 WS-NULL-IND-4             PIC S9(4) COMP.                 
           05 WS-NULL-IND-5             PIC S9(4) COMP.                 
           05 WS-NULL-IND-6             PIC S9(4) COMP.                 
           05 WS-NULL-IND-7             PIC S9(4) COMP.                 
           05 WS-NULL-IND-8             PIC S9(4) COMP.                 
           05 WS-NULL-IND-9             PIC S9(4) COMP.                 
           05 WS-NULL-IND-HEADER        PIC S9(4) COMP.                 
      *                                                                         
       01  WS-DATE-FIELDS.                                              
           05 WS-BILL-DATE              PIC X(10) VALUE SPACES.         
           05 WS-PREV-BILL-DATE         PIC X(10) VALUE SPACES.         
           05 WS-DATE-READ-COMPARE      PIC X(10) VALUE SPACES.         
      *                                                                         
       01  WS-REVENUE-MONTH-FIELDS.                                     
           05 WS-REVENUE-MONTH          PIC S9(6) VALUE 0.              
           05 WS-REVENUE-MONTH-TEMP     PIC S9(6) VALUE 0.              
           05 WS-CUTOF-REV-MNTH         PIC S9(6).                      
           05 WS-CUTOF-REV-MNTH-RED     REDEFINES WS-CUTOF-REV-MNTH.    
              10 WS-CUTOF-REV-MNTH-YY   PIC 9(04).                      
              10 WS-CUTOF-REV-MNTH-MM   PIC 9(02).                      
      *                                                                         
       01  WS-LITERALS.                                                 
           05 WS-YES                    PIC X(01) VALUE 'Y'.            
           05 WS-NO                     PIC X(01) VALUE 'N'.            
           05 WS-12                     PIC 9(02) VALUE 12.             
           05 WS-DFLT-NO-OF-BILLS       PIC 9(02) VALUE 12.             
P00836     05 WS-DFLT-WBC-NO-OF-REV-MTH PIC 9(02) VALUE 11.             
           05 WS-ALL-BILLS              PIC 9(06) VALUE 999999.         
           05 WS-CUT-OFF-DATE           PIC X(10).                      
           05 WS-PSNC                   PIC X(2) VALUE '26'.            
           05 WS-CIG                    PIC X(2) VALUE '01'.            
           05 WS-NON-UTLTY-ACCT         PIC X(1) VALUE 'N'.             
      *                                                                         
       01  WS-PARM.                                                     
           05 PROGRAM-NAME              PIC X(08) VALUE 'CSR04623'.     
           05 WS-SQLSTATE               PIC X(05).                      
      *                                                                         
       01  WS-SERV-ADDR.                                                
           05 WS-ADDR-PREFIX-1         PIC X(03) VALUE SPACES.          
           05 FILLER                   PIC X(01) VALUE SPACES.          
           05 WS-ADDR-PREFIX-2         PIC X(02) VALUE SPACES.          
           05 FILLER                   PIC X(01) VALUE SPACES.          
           05 WS-HOUSE-NO              PIC X(15) VALUE SPACES.          
           05 FILLER                   PIC X(01) VALUE SPACES.          
           05 WS-STREET-NAME           PIC X(30) VALUE SPACES.          
           05 FILLER                   PIC X(01) VALUE SPACES.          
           05 WS-STREET-LOCATION-1     PIC X(04) VALUE SPACES.          
           05 FILLER                   PIC X(01) VALUE SPACES.          
           05 WS-STREET-LOCATION-2     PIC X(11) VALUE SPACES.          
           05 FILLER                   PIC X(01) VALUE SPACES.          
           05 WS-STREET-SUFFIX         PIC X(04) VALUE SPACES.          
           05 FILLER                   PIC X(01) VALUE SPACES.          
           05 WS-ZIP-CODE              PIC X(05) VALUE SPACES.          
      *                                                                 02530000
       01  SWITCHES.                                                    
           05  ALL-DONE-SW              PIC X(01) VALUE 'N'.            
               88 NOT-ALL-DONE                    VALUE 'N'.            
               88 ALL-DONE                        VALUE 'Y'.            
           05  SEND-DONE-SW             PIC X(01) VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
           05  END-OF-BI-SW             PIC X(01) VALUE 'N'.            
               88 NO-MORE-HEADER-RECS             VALUE 'Y'.            
           05  WS-MORE-BGS-SW           PIC X(01) VALUE 'Y'.            
               88 NO-MORE-DETAIL-RECS             VALUE 'N'.            
           05  WS-MORE-SUBS-SW          PIC X(01) VALUE 'Y'.            
               88 NO-MORE-SUBACCTS                VALUE 'N'.            
           05  WS-MST-SUB-ACCT-IND      PIC X(01) VALUE ' '.            
               88 MASTER-ACCOUNT                  VALUE 'M'.            
           05  WS-INDUST-GAS-CUST       PIC X(01) VALUE 'N'.            
               88 INDUST-GAS-CUST                 VALUE 'Y'.            
           05  WS-CANCEL-REBILL         PIC X(01) VALUE 'N'.            
               88 CANCEL-BILL                     VALUE 'Y'.            
               88 NORMAL-BILL                     VALUE 'N'.            
           05 WS-UNMTRD-ELEC-GAS        PIC X(01) VALUE 'N'.            
           05  WS-DATABASE              PIC 9(01) VALUE ZERO.           
               88 CSR-DATABASE                    VALUE 1.              
               88 SEB-DATABASE                    VALUE 2.              
P00821     05  WS-BILL-ADJ-EXIST        PIC X(01) VALUE 'N'.            
      *                                                                         
       01  GTT-MISC-FIELDS.                                             
           05  WS-GTT-NAME              PIC X(26) VALUE SPACES.         
           05  GTT-ROW.                                                 
               49 GTT-ROW-LEN           PIC S9(4) COMP.                 
               49 GTT-ROW-CHAR          PIC X(1024).                    
           05  GTT-SQLCODE              PIC S9(9) COMP.                 
      *                                                                         
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM          PIC S9(9) COMP.                 
           05  WRKLEN1                  PIC S9(9) COMP.                 
           05  WRKLEN2                  PIC S9(9) COMP.                 
           05  WRK-DONE-STATUS          PIC S9(9) COMP.                 
      *                                                                         
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
      *                                                                         
       01  GTT-RETURN-FIELDS.                                           
      ******************************************************************        
      *   GTT TABLE LAYOUT FOR BILLING HEADER.                         *        
      ******************************************************************        
           05  GTT-RETURN-FIELDS-1.                                     
               10  S1-RETURN-CODE       PIC S9(9) VALUE 0 COMP.         
               10  S1-APPL-RETURN-CODE  PIC S9(9) VALUE 0 COMP.         
               10  S1-ACCOUNT-NO        PIC S9(13)V                     
                                                  VALUE 0 COMP-3.       
               10  S1-COMPANY-NO        PIC X(02) VALUE SPACES.         
COB305         10 S1-REVENUE-MONTH        PIC S9(6) COMP-3 VALUE 0.             
               10  S1-BILL-NO           PIC S9(9) VALUE 0 COMP.         
               10  S1-DATE-BILLED       PIC X(10) VALUE SPACES.         
               10  S1-BILL-AMOUNT       PIC S9(9)V99                    
                                                  VALUE 0 COMP-3.       
               10  S1-PAYMENTS          PIC S9(9)V99                    
                                                  VALUE 0 COMP-3.       
               10  S1-TOT-OTHER-CHARGES PIC S9(9)V99                    
                                                  VALUE 0 COMP-3.       
               10  S1-TOTAL-ARREARS     PIC S9(9)V99                    
                                                  VALUE 0 COMP-3.       
               10  S1-TOTAL-BILL-AMOUNT PIC S9(9)V99                    
                                                  VALUE 0 COMP-3.       
               10  S1-CODE-BILL-STATUS  PIC X(01) VALUE SPACES.         
               10  S1-CODE-BILL-TYPE    PIC X(01) VALUE SPACES.         
P00821         10  S1-PSNC-FLAG         PIC X(01) VALUE SPACES.         
P00821         10  S1-FUT-BILL-HOOK-INS-FL                              
P00821                                  PIC X(01) VALUE SPACES.         
P00821         10  S1-BILL-ADJ-FLAG     PIC X(01) VALUE SPACES.         
P00836         10  S1-TOTAL-ELEC-CHARGES  PIC S9(9)V99 COMP-3 VALUE 0.  
P00836         10  S1-TOTAL-GAS-CHARGES   PIC S9(9)V99 COMP-3 VALUE 0.  
P00836         10  S1-TOTAL-UNMTR-CHARGES PIC S9(9)V99 COMP-3 VALUE 0.  
P00836         10  S1-TOTAL-TAXES         PIC S9(9)V99 COMP-3 VALUE 0.  
P00836         10  S1-WEB-CURRENT-CHARGES PIC S9(9)V99 COMP-3 VALUE 0.  
P00836         10  S1-WEB-TOT-BILL-AMOUNT PIC S9(9)V99 COMP-3 VALUE 0.  
P00836         10  S1-SHOW-BILL-IMAGE-FL  PIC X(01) VALUE SPACES.       
      ******************************************************************        
      *   GTT TABLE LAYOUT FOR BILLING DETAILS.                        *        
      ******************************************************************        
           05  GTT-RETURN-FIELDS-2.                                     
               10  S2-RETURN-CODE        PIC S9(9) VALUE 0 COMP.        
               10  S2-APPL-RETURN-CODE   PIC S9(9) VALUE 0 COMP.        
               10  S2-ACCOUNT-NO         PIC S9(13)V                    
                                                   VALUE 0 COMP-3.      
               10  S2-COMPANY-NO         PIC X(02) VALUE SPACES.        
COB305         10 S2-REVENUE-MONTH        PIC S9(6) COMP-3 VALUE 0.             
COB305         10 S2-REV-MTH-ORIG-BILL        PIC S9(6) COMP-3 VALUE 0.         
P00821         10  S2-DATE-ORIG-BILL     PIC X(10) VALUE SPACES.        
P00821         10  S2-INDUST-GAS-CUST    PIC X(01) VALUE SPACES.        
P00821         10  S2-NET-MTR-ACCOUNT    PIC X(01) VALUE SPACES.        
               10  S2-BILL-NO            PIC S9(9) VALUE 0 COMP.        
               10  S2-BILL-ITEM-TIMESTMP PIC X(26) VALUE SPACES.        
               10  S2-DATE-READ          PIC X(10) VALUE SPACES.        
               10  S2-CODE-UTIL-TYPE     PIC X(01) VALUE SPACES.        
               10  S2-IC-NO              PIC S9(4) VALUE 0 COMP.        
               10  S2-RATE-PLAN-NO       PIC X(03) VALUE SPACES.        
P00821         10  S2-REVENUE-CLASS      PIC X(03) VALUE SPACES.        
P00821         10  S2-PRTY-SVC-CAT-CD    PIC X(02) VALUE SPACES.        
P00821         10  S2-CODE-BILL-CALC     PIC X(01) VALUE SPACES.        
               10  S2-RATE-DESC          PIC X(50) VALUE SPACES.        
P00821         10  S2-UNMTR-PROV-FL      PIC X(01) VALUE SPACES.        
P00899         10  S2-SECUR-RATE-FL      PIC X(01) VALUE SPACES.        
               10  S2-OPTION-CD          PIC X(12) VALUE SPACES.        
               10  S2-OPTION-DESC        PIC X(50) VALUE SPACES.        
               10  S2-NO-UNITS           PIC S9(9) VALUE 0 COMP-3.      
               10  S2-CODE-USAGE-TYPE    PIC X(01) VALUE SPACES.        
P00821         10  S2-CIG-FLAG           PIC X(01) VALUE SPACES.        
P00821         10  S2-EMC-FLAG           PIC X(01) VALUE SPACES.        
               10  S2-NO-DAYS            PIC S9(4) VALUE 0 COMP.        
               10  S2-AMT-BILL-ITEM      PIC S9(9)V99                   
                                                   VALUE 0 COMP-3.      
               10  S2-AMT-TAXES          PIC S9(9)V99                   
                                                   VALUE 0 COMP-3.      
               10  S2-CODE-BILL-ITM-IND  PIC X(01) VALUE SPACES.        
               10  S2-READ-UNITS         PIC S9(9) VALUE 0 COMP-3.      
               10  S2-AGL-CHARGE         PIC S9(09)V9999                
                                                   VALUE 0 COMP-3.      
               10  S2-SUB-ACCOUNT-NO     PIC S9(13)V                    
                                                   VALUE 0 COMP-3.      
               10  S2-SUB-ACCT-SERV-ADDR PIC X(81) VALUE SPACES.        
P00899         10  S2-BILL-RELEASED-FLG  PIC X(01) VALUE SPACES.        
P00899         10  S2-MULT-REGISTER-FLG  PIC X(01) VALUE 'N'.           
      ******************************************************************        
      *   GTT TABLE LAYOUT FOR ADDITIONAL BILL EXIST FLAG.             *        
      ******************************************************************        
           05  GTT-RETURN-FIELDS-3.                                     
               10  S3-RETURN-CODE        PIC S9(9) VALUE 0 COMP.        
               10  S3-APPL-RETURN-CODE   PIC S9(9) VALUE 0 COMP.        
               10  S3-ADDTNL-BILLS-EXIST PIC X(01) VALUE SPACES.        
PRJ821         10  S3-ACCT-BILLS-COUNT   PIC S9(9) VALUE 0 COMP.        
P00899         10  S3-ACCT-LAST-UPDT-TS  PIC X(26) VALUE SPACES.        
P00836         10  S3-WEB-AVERAGE-BILL-AMT PIC S9(9)V99 COMP-3 VALUE 0. 
      *                                                                         
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)  VALUE SPACES.        
            10  S-SQLCODE               PIC S9(9)  VALUE 0 COMP.        
            10  S-SQLSTATE              PIC X(05)  VALUE SPACES.        
            10  S-TABLE-NAME            PIC X(18)  VALUE SPACES.        
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4)  USAGE COMP.          
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4)  USAGE COMP.          
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4)  USAGE COMP.          
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
      *                                                                         
      ******************************************************************        
      *                    C U R S O R  D E C L A R A T I O N S        *        
      ******************************************************************        
                                                                        
      ******************************************************************        
      **  THE FOLLOWING DECLARES THE CURSOR FOR RETRIEVING A SET OF   **        
      **  ROWS FROM THE CSS_BILLING_HDR TABLE FOR A GIVEN ACCOUNT     **        
      **  NUMBER.                                                     **        
      ******************************************************************        
           EXEC SQL                                                     
               DECLARE BI-CURSOR CURSOR FOR                             
                   SELECT BILL_NO                                       
                         ,DATE_BILLED                                   
                         ,CODE_BILL_TYPE                                
                         ,CODE_BILL_STATUS                              
                         ,TOT_OTHER_CHARGES                             
                         ,TOTAL_ARREARS                                 
                         ,COMPANY_NO                                    
                   FROM CSS_BILLING_HDR WITH(READUNCOMMITTED)                   
                   WHERE ACCOUNT_NO  =  :BI-ACCOUNT-NO                  
                   ORDER BY BILL_NO DESC                                
                   FOR READ ONLY                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE BI-CURSOR CURSOR FOR                                     
MFA-TR*            SELECT BILL_NO                                               
MFA-TR*                  ,DATE_BILLED                                           
MFA-TR*                  ,CODE_BILL_TYPE                                        
MFA-TR*                  ,CODE_BILL_STATUS                                      
MFA-TR*                  ,TOT_OTHER_CHARGES                                     
MFA-TR*                  ,TOTAL_ARREARS                                         
MFA-TR*                  ,COMPANY_NO                                            
MFA-TR*            FROM CSS_BILLING_HDR                                         
MFA-TR*            WHERE ACCOUNT_NO  =  :BI-ACCOUNT-NO                          
MFA-TR*            ORDER BY BILL_NO DESC                                        
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      **  THE FOLLOWING DECLARES THE CURSOR FOR RETRIEVING A SET OF   **        
      **  ROWS FROM THE CSS_BILLING_DET TABLE WHERE THE ACCOUNT       **        
      **  NUMBER AND BILL NUMBER ARE EQUAL TO THE ACCOUNT NUMBER AND  **        
      **  BILL NUMBER ON THE CURRENT CSS_BILLING_HDR ROW.             **        
      ******************************************************************        
           EXEC SQL                                                     
               DECLARE BG-CURSOR CURSOR FOR                             
                   SELECT CODE_UTIL_TYPE                                
                         ,IC_NO                                         
                         ,AMT_BILL_ITEM                                 
                         ,AMT_STATE_TAX                                 
                         ,AMT_CITY_TAX                                  
                         ,AMT_OTHER_TAX                                 
                         ,CODE_REVENUE_CLASS                            
                         ,CODE_BILL_ITM_IND                             
                         ,CODE_BILL_ITM_TYPE                            
                         ,CODE_DR_CR_CNSMPTN                            
                         ,RATE_PLAN_NO                                  
                         ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP                            
                         ,REVENUE_MONTH                                 
P00821                   ,REV_MTH_ORIG_BILL                             
P00821                   ,CODE_CURTAIL_PRTY                             
P00821                   ,CODE_BILL_CALC                                
                         ,DATE_ORIG_BILL                                
                         ,BTU_FACTOR                                    
                         ,ACCOUNT_NO                                    
                         ,BILL_NO                                       
                         ,NO_OF_CONS_DAYS                               
                         ,REV_RPT_CD                                    
                         ,RT_PKG_OPT_SEQ_NO                             
                     FROM CSS_BILLING_DET WITH(READUNCOMMITTED)                 
                    WHERE ACCOUNT_NO        = :BG-ACCOUNT-NO            
                      AND BILL_NO           = :BG-BILL-NO               
                    ORDER BY ACCOUNT_NO         ASC                     
                            ,BILL_NO            DESC                    
                            ,CODE_UTIL_TYPE     ASC                     
                            ,IC_NO              ASC                     
                            ,BILL_ITEM_TIMESTMP ASC                     
                    FOR READ ONLY                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE BG-CURSOR CURSOR FOR                                     
MFA-TR*            SELECT CODE_UTIL_TYPE                                        
MFA-TR*                  ,IC_NO                                                 
MFA-TR*                  ,AMT_BILL_ITEM                                         
MFA-TR*                  ,AMT_STATE_TAX                                         
MFA-TR*                  ,AMT_CITY_TAX                                          
MFA-TR*                  ,AMT_OTHER_TAX                                         
MFA-TR*                  ,CODE_REVENUE_CLASS                                    
MFA-TR*                  ,CODE_BILL_ITM_IND                                     
MFA-TR*                  ,CODE_BILL_ITM_TYPE                                    
MFA-TR*                  ,CODE_DR_CR_CNSMPTN                                    
MFA-TR*                  ,RATE_PLAN_NO                                          
MFA-TR*                  ,BILL_ITEM_TIMESTMP                                    
MFA-TR*                  ,REVENUE_MONTH                                         
MFA-TR*                  ,REV_MTH_ORIG_BILL                                     
MFA-TR*                  ,CODE_CURTAIL_PRTY                                     
MFA-TR*                  ,CODE_BILL_CALC                                        
MFA-TR*                  ,DATE_ORIG_BILL                                        
MFA-TR*                  ,BTU_FACTOR                                            
MFA-TR*                  ,ACCOUNT_NO                                            
MFA-TR*                  ,BILL_NO                                               
MFA-TR*                  ,NO_OF_CONS_DAYS                                       
MFA-TR*                  ,REV_RPT_CD                                            
MFA-TR*                  ,RT_PKG_OPT_SEQ_NO                                     
MFA-TR*              FROM CSS_BILLING_DET                                       
MFA-TR*             WHERE ACCOUNT_NO        = :BG-ACCOUNT-NO                    
MFA-TR*               AND BILL_NO           = :BG-BILL-NO                       
MFA-TR*             ORDER BY ACCOUNT_NO         ASC                             
MFA-TR*                     ,BILL_NO            DESC                            
MFA-TR*                     ,CODE_UTIL_TYPE     ASC                             
MFA-TR*                     ,IC_NO              ASC                             
MFA-TR*                     ,BILL_ITEM_TIMESTMP ASC                             
MFA-TR*             FOR FETCH ONLY WITH UR                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ************************************************************              
      * THE FOLLOWING DECLARES THE CURSOR FOR RETRIEVING A SET OF*              
      * ROWS FROM THE CSS_CNSMPTN_HIST TABLE.                    *              
      ************************************************************              
            EXEC SQL                                                    
                DECLARE CX-CURSOR CURSOR FOR                            
              SELECT CODE_USAGE_TYPE                                    
                    ,METER_NO                                           
                    ,DATE_READ                                          
                    ,NO_UNITS                                           
                    ,NO_DEMAND_UNITS                                    
                    ,NO_DAYS                                            
                    ,CODE_SOURCE_ID                                     
                    ,CODE_DEBIT_CREDIT                                  
                    ,MTR_REF_NO                                         
                    ,REG_ID_NO                                          
                    ,CODE_TOU_SEASN                                     
                    ,CODE_TIME_PERIOD                                   
                    ,CODE_ITEM_STATUS                                   
                   FROM CSS_CNSMPTN_HIST WITH(READUNCOMMITTED)                  
                   WHERE  ACCOUNT_NO        = :CX-ACCOUNT-NO            
                   AND    CODE_UTIL_TYPE    = :CX-CODE-UTIL-TYPE        
                   AND    BILL_NO           = :CX-BILL-NO               
                   AND    IC_NO             = :CX-IC-NO                 
                   AND    BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :CX-BILL-ITEM-TIMESTMP
              )   
                   AND    CODE_ITEM_STATUS IN ( 'A' , 'T')              
                   ORDER BY DATE_READ       DESC                        
                           ,CODE_USAGE_TYPE ASC                         
                   FOR READ ONLY                                
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DECLARE CX-CURSOR CURSOR FOR                                    
MFA-TR*       SELECT CODE_USAGE_TYPE                                            
MFA-TR*             ,METER_NO                                                   
MFA-TR*             ,DATE_READ                                                  
MFA-TR*             ,NO_UNITS                                                   
MFA-TR*             ,NO_DEMAND_UNITS                                            
MFA-TR*             ,NO_DAYS                                                    
MFA-TR*             ,CODE_SOURCE_ID                                             
MFA-TR*             ,CODE_DEBIT_CREDIT                                          
MFA-TR*             ,MTR_REF_NO                                                 
MFA-TR*             ,REG_ID_NO                                                  
MFA-TR*             ,CODE_TOU_SEASN                                             
MFA-TR*             ,CODE_TIME_PERIOD                                           
MFA-TR*             ,CODE_ITEM_STATUS                                           
MFA-TR*            FROM CSS_CNSMPTN_HIST                                        
MFA-TR*            WHERE  ACCOUNT_NO        = :CX-ACCOUNT-NO                    
MFA-TR*            AND    CODE_UTIL_TYPE    = :CX-CODE-UTIL-TYPE                
MFA-TR*            AND    BILL_NO           = :CX-BILL-NO                       
MFA-TR*            AND    IC_NO             = :CX-IC-NO                         
MFA-TR*            AND    BILL_ITEM_TIMESTMP = :CX-BILL-ITEM-TIMESTMP           
MFA-TR*            AND    CODE_ITEM_STATUS IN ( 'A' , 'T')                      
MFA-TR*            ORDER BY DATE_READ       DESC                                
MFA-TR*                    ,CODE_USAGE_TYPE ASC                                 
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*     END-EXEC.                                                           
      *                                                                         
      *****************************************************************         
      ***    THE FOLLOWING DECLARES THE CURSOR FOR RETRIEVING A SET  **         
      ***       ROWS FROM THE CSS_UM_CNSMPT_HIST TABLE.              **         
      ***                                                            **         
      *****************************************************************         
           EXEC SQL                                                     
               DECLARE UC-CURSOR CURSOR FOR                             
               SELECT DATE_USAGE_ENDS                                   
                     ,NO_UNITS                                          
                     ,NO_DAYS                                           
                     ,MTHLY_AMOUNT_FIXED                                
                     ,CODE_DEBIT_CREDIT                                 
               FROM CSS_UM_CNSMPT_HIST WITH(READUNCOMMITTED)                    
               WHERE  ACCOUNT_NO           = :UC-ACCOUNT-NO             
                 AND  CODE_UTIL_TYPE       = :UC-CODE-UTIL-TYPE         
                 AND  BILL_NO              = :UC-BILL-NO                
                 AND  IC_NO                = :UC-IC-NO                  
                 AND  BILL_ITEM_TIMESTMP   = CIS.CHAR2TIMESTAMP(
                                                 :UC-BILL-ITEM-TIMESTMP
              )     
               FOR READ ONLY                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE UC-CURSOR CURSOR FOR                                     
MFA-TR*        SELECT DATE_USAGE_ENDS                                           
MFA-TR*              ,NO_UNITS                                                  
MFA-TR*              ,NO_DAYS                                                   
MFA-TR*              ,MTHLY_AMOUNT_FIXED                                        
MFA-TR*              ,CODE_DEBIT_CREDIT                                         
MFA-TR*        FROM CSS_UM_CNSMPT_HIST                                          
MFA-TR*        WHERE  ACCOUNT_NO           = :UC-ACCOUNT-NO                     
MFA-TR*          AND  CODE_UTIL_TYPE       = :UC-CODE-UTIL-TYPE                 
MFA-TR*          AND  BILL_NO              = :UC-BILL-NO                        
MFA-TR*          AND  IC_NO                = :UC-IC-NO                          
MFA-TR*          AND  BILL_ITEM_TIMESTMP   = :UC-BILL-ITEM-TIMESTMP             
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      ****THE FOLLOWING DECLARES THE CURSOR FOR RETRIEVING A SET OF   **        
      **** ROWS FROM THE CSS_BILL_CALC_DET.                           **        
      ******************************************************************        
           EXEC SQL                                                     
              DECLARE BZ-CURSOR CURSOR FOR                              
              SELECT BILL_UNITS                                         
                    ,BILLED_COMP_AM                                     
                    ,CONSUMPT_TYPE_CD                                   
                    ,CMPNT_ID_CD                                        
                    ,READ_UNITS                                         
                FROM CSS_BILL_CALC_DET WITH(READUNCOMMITTED)                    
               WHERE ACCOUNT_NO           = :BZ-ACCOUNT-NO              
                 AND   CODE_UTIL_TYPE     = :BZ-CODE-UTIL-TYPE          
                 AND   BILL_NO            = :BZ-BILL-NO                 
                 AND   IC_NO              = :BZ-IC-NO                   
                 AND   BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :BZ-BILL-ITEM-TIMESTMP
              )      
                 AND   (CMPNT_ID_CD NOT IN ('92','93'))                 
              ORDER BY CONSUMPT_TYPE_CD ASC                             
               FOR READ ONLY                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE BZ-CURSOR CURSOR FOR                                      
MFA-TR*       SELECT BILL_UNITS                                                 
MFA-TR*             ,BILLED_COMP_AM                                             
MFA-TR*             ,CONSUMPT_TYPE_CD                                           
MFA-TR*             ,CMPNT_ID_CD                                                
MFA-TR*             ,READ_UNITS                                                 
MFA-TR*         FROM CSS_BILL_CALC_DET                                          
MFA-TR*        WHERE ACCOUNT_NO           = :BZ-ACCOUNT-NO                      
MFA-TR*          AND   CODE_UTIL_TYPE     = :BZ-CODE-UTIL-TYPE                  
MFA-TR*          AND   BILL_NO            = :BZ-BILL-NO                         
MFA-TR*          AND   IC_NO              = :BZ-IC-NO                           
MFA-TR*          AND   BILL_ITEM_TIMESTMP = :BZ-BILL-ITEM-TIMESTMP              
MFA-TR*          AND   (CMPNT_ID_CD NOT IN ('92','93'))                         
MFA-TR*       ORDER BY CONSUMPT_TYPE_CD ASC                                     
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      ****THE FOLLOWING DECLARES THE CURSOR FOR RETRIEVING SUB ACCOUNT**        
      **** NUMBERS FROM THE BILL_ACCT_XFER TABLE FOR A MASTER ACCOUNT.**        
      ******************************************************************        
           EXEC SQL                                                     
              DECLARE XFER-CURSOR CURSOR FOR                            
              SELECT DISTINCT (BILL_NO_XFER_FROM)                       
                    ,ACCT_XFER_FROM                                     
                FROM CSS_BILL_ACCT_XFER AF WITH(READUNCOMMITTED)                
               WHERE ACCOUNT_NO         = :AF-ACCOUNT-NO               
                 AND BILL_NO            = :AF-BILL-NO                  
               FOR READ ONLY                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE XFER-CURSOR CURSOR FOR                                    
MFA-TR*       SELECT DISTINCT (BILL_NO_XFER_FROM)                               
MFA-TR*             ,ACCT_XFER_FROM                                             
MFA-TR*         FROM CSS_BILL_ACCT_XFER AF                                      
MFA-TR*        WHERE ACCOUNT_NO         = : AF-ACCOUNT-NO                       
MFA-TR*          AND BILL_NO            = : AF-BILL-NO                          
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    END-EXEC.                                                            
      *                                                                         
P00821******************************************************************        
P00821****THE FOLLOWING DECLARES THE CURSOR FOR JOP PARM TO GET       **        
P00821**** PARM DATA                                                  **        
P00821******************************************************************        
P00821     EXEC SQL                                                     
P00821        DECLARE PARM_CSR CURSOR FOR                               
P00821        SELECT  PROGRAM_NAME                                      
P00821                ,COMPANY_NO                                       
P00821                ,CMND_CODE                                        
P00821                ,SEQ_NO                                           
P00821                ,STATUS                                           
P00821                ,PARM_DATA                                        
P00821        FROM    CSS_JOB_PARM WITH(READUNCOMMITTED)                        
P00821        WHERE   PROGRAM_NAME   = :G6-PROGRAM-NAME                 
P00821          AND   CMND_CODE      = :G6-CMND-CODE                    
P00821          AND   COMPANY_NO     = :G6-COMPANY-NO                   
P00821        ORDER BY SEQ_NO                                           
P00821        FOR READ ONLY                                     
P00821     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE PARM_CSR CURSOR FOR                                       
MFA-TR*       SELECT  PROGRAM_NAME                                              
MFA-TR*               ,COMPANY_NO                                               
MFA-TR*               ,CMND_CODE                                                
MFA-TR*               ,SEQ_NO                                                   
MFA-TR*               ,STATUS                                                   
MFA-TR*               ,PARM_DATA                                                
MFA-TR*       FROM    CSS_JOB_PARM                                              
MFA-TR*       WHERE   PROGRAM_NAME   = :G6-PROGRAM-NAME                         
MFA-TR*         AND   CMND_CODE      = :G6-CMND-CODE                            
MFA-TR*         AND   COMPANY_NO     = :G6-COMPANY-NO                           
MFA-TR*       ORDER BY SEQ_NO                                                   
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01  I-APPL-PROGRAM-ID          PIC X(03).                        
       01  I-USER-ID                  PIC X(07).                        
COB305 01 I-ACCOUNT-NUMBER        PIC S9(13)V USAGE COMP-3 VALUE 0.         
       01  I-INCLUDE-DETAIL-ROWS      PIC X(01).                        
       01  I-INCLUDE-LATEST-BILL-ONLY PIC X(01).                        
       01  I-INCLUDE-UNBILLED-BILL    PIC X(01).                        
       01  I-INCLUDE-ADDTNL-HIST      PIC X(01).                        
                                                                        
      *                                                                         
       PROCEDURE DIVISION USING  I-APPL-PROGRAM-ID                      
                               , I-USER-ID                              
                               , I-ACCOUNT-NUMBER                       
                               , I-INCLUDE-DETAIL-ROWS                  
                               , I-INCLUDE-LATEST-BILL-ONLY             
                               , I-INCLUDE-UNBILLED-BILL                
                               , I-INCLUDE-ADDTNL-HIST.                 
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 1000-PROCESS-INPUT         THRU 1000-EXIT.           
           PERFORM 2000-PROCESS-OUTPUT        THRU 2000-EXIT.           
           PERFORM 9999-END-PROGRAM           THRU 9999-EXIT.           
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *0100A-DECLARE-GTT-R1.                                                    
      ******************************************************************        
       0100A-DECLARE-GTT-R1.                                            
      *                                                                         
            MOVE 'SESSION.CSR04623_R1'       TO WS-GTT-NAME.            
            MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR04623_R1'           
                                             TO S-SQL-STATEMENT-V.      
                                                                        
            EXEC SQL
              CALL CIS.DROP_TEMP_TABLE('#CSR04623_R1')
            END-EXEC
            EXEC SQL
              CREATE TABLE #CSR04623_R1
               (                                                       
                    RETURN_CODE          INT                        
                   ,APPL_RETURN_CODE     INT                        
                   ,ACCOUNT_NO           DECIMAL(13)                    
                   ,COMPANY_NO CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,BILL_MONTH           DECIMAL(06)                    
                   ,BILL_NO              INT                        
                   ,DATE_BILLED CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,BILL_AMOUNT          DECIMAL(11,2)                  
                   ,PAYMENTS             DECIMAL(11,2)                  
                   ,OTHR_CHRGS           DECIMAL(11,2)                  
                   ,ARREARS              DECIMAL(11,2)                  
                   ,TOTAL_AMOUNT         DECIMAL(11,2)                  
                   ,CODE_BILL_STATUS CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,CODE_BILL_TYPE CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
P00821             ,PSNC_FLAG CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
P00821             ,FUT_BILL_HOOK_INS_FL CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
P00821             ,BILL_ADJ_FLAG CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
P00836             ,ELECTRIC_CHARGES     DECIMAL(11,2)                  
P00836             ,GAS_CHARGES          DECIMAL(11,2)                  
P00836             ,UNMETERED_CHARGES    DECIMAL(11,2)                  
P00836             ,TAXES                DECIMAL(11,2)                  
P00836             ,WEB_CURRENT_CHARGES  DECIMAL(11,2)                  
P00836             ,SHOW_BILL_IMAGE_FL CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                )
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLSTATE                    TO WS-SQLSTATE.            
            MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
            IF WS-SQLSTATE = '42710'                                    
               PERFORM 8000-DELETE-GTT-ROWS   THRU 8000-EXIT            
            ELSE                                                        
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE SQLCODE                TO ABEND-SQLCODE           
                 MOVE SQLSTATE               TO ABEND-SQLSTATE          
                 MOVE '0100A'                TO ACTIVE-PARAGRAPH        
                 MOVE 'DECLARE GTT'          TO ABEND-FUNCTION          
                 MOVE SPACES                 TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                 MOVE WS-GTT-NAME            TO TABLE-1                 
                 MOVE SPACES                 TO TABLE-ELEMENT-1         
                 MOVE SPACES                 TO HOSTVAR-ELEMENT-1       
                 PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT            
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
               SELECT                                                   
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,ACCOUNT_NO                                           
                  ,LTRIM(RTRIM(COMPANY_NO))             AS COMPANY_NO          
                  ,BILL_MONTH                                           
                  ,BILL_NO                                              
                  ,DATE_BILLED                                          
                  ,BILL_AMOUNT                                          
                  ,PAYMENTS                                             
                  ,OTHR_CHRGS                                           
                  ,ARREARS                                              
                  ,TOTAL_AMOUNT                                         
                  ,LTRIM(RTRIM(CODE_BILL_STATUS))      AS 
           CODE_BILL_STATUS     
                  ,LTRIM(RTRIM(CODE_BILL_TYPE))        AS CODE_BILL_TYPE       
P00821            ,LTRIM(RTRIM(PSNC_FLAG))             AS PSNC_FLAG            
P00821            ,LTRIM(RTRIM(FUT_BILL_HOOK_INS_FL))  AS 
           FUT_BILL_HOOK_INS_FL 
P00821            ,LTRIM(RTRIM(BILL_ADJ_FLAG))         AS BILL_ADJ_FLAG        
P00836            ,ELECTRIC_CHARGES                                     
P00836            ,GAS_CHARGES                                          
P00836            ,UNMETERED_CHARGES                                    
P00836            ,TAXES                                                
P00836            ,WEB_CURRENT_CHARGES                                  
P00836            ,SHOW_BILL_IMAGE_FL                                   
               FROM                                                     
                   #CSR04623_R1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*        SELECT                                                           
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,ACCOUNT_NO                                                   
MFA-TR*           ,STRIP(COMPANY_NO)             AS COMPANY_NO                  
MFA-TR*           ,BILL_MONTH                                                   
MFA-TR*           ,BILL_NO                                                      
MFA-TR*           ,DATE_BILLED                                                  
MFA-TR*           ,BILL_AMOUNT                                                  
MFA-TR*           ,PAYMENTS                                                     
MFA-TR*           ,OTHR_CHRGS                                                   
MFA-TR*           ,ARREARS                                                      
MFA-TR*           ,TOTAL_AMOUNT                                                 
MFA-TR*           ,STRIP(CODE_BILL_STATUS)      AS CODE_BILL_STATUS             
MFA-TR*           ,STRIP(CODE_BILL_TYPE)        AS CODE_BILL_TYPE               
MFA-TR*           ,STRIP(PSNC_FLAG)             AS PSNC_FLAG                    
MFA-TR*           ,STRIP(FUT_BILL_HOOK_INS_FL)  AS FUT_BILL_HOOK_INS_FL         
MFA-TR*           ,STRIP(BILL_ADJ_FLAG)         AS BILL_ADJ_FLAG                
MFA-TR*           ,ELECTRIC_CHARGES                                             
MFA-TR*           ,GAS_CHARGES                                                  
MFA-TR*           ,UNMETERED_CHARGES                                            
MFA-TR*           ,TAXES                                                        
MFA-TR*           ,WEB_CURRENT_CHARGES                                          
MFA-TR*           ,SHOW_BILL_IMAGE_FL                                           
MFA-TR*        FROM                                                             
MFA-TR*            SESSION.CSR04623_R1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
      *                                                                         
       0100A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      *0100B-DECLARE-GTT-R2.                                                    
      ******************************************************************        
       0100B-DECLARE-GTT-R2.                                            
      *                                                                         
            MOVE 'SESSION.CSR04623_R2'       TO WS-GTT-NAME.            
            MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR04623_R2'           
                                             TO S-SQL-STATEMENT-V.      
                                                                        
            EXEC SQL
              CALL CIS.DROP_TEMP_TABLE('#CSR04623_R2')
            END-EXEC
            EXEC SQL
              CREATE TABLE #CSR04623_R2
               (                                                       
                    RETURN_CODE        INT                          
                   ,APPL_RETURN_CODE   INT                          
                   ,ACCOUNT_NO         DECIMAL(13)                      
                   ,COMPANY_NO CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,BILL_MONTH         DECIMAL(06)                      
                   ,BILL_NO            INT                          
                   ,BILL_TIMESTMP CHAR(26)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,DATE_READ CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,SERVICE_TYPE CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,IC_NO              SMALLINT                         
                   ,RATE_PLAN_NO CHAR(03)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
P00821             ,REVENUE_CLASS CHAR(03)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
P00821             ,PRTY_SVC_CAT_CD CHAR(02)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
P00821             ,CODE_BILL_CALC CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,RATE_DESC CHAR(50)  COLLATE LATIN1_GENERAL_100_BIN2         
P00821             ,UNMTR_PROV_FL CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
P00899             ,SECUR_RATE_FL CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,OPTION_CD CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,OPTION_DESC CHAR(50)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,USAGE              INT                          
                   ,USAGE_TYPE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,DAYS               SMALLINT                         
                   ,CHARGES            DECIMAL(11,2)                    
                   ,TAXES              DECIMAL(11,2)                    
                   ,BILL_ITEM_IND CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,READ_UNITS         INT                          
                   ,AGL_CHRG           DECIMAL(13,4)                    
                   ,SUB_ACCOUNT_NO     DECIMAL(13,0)                    
                   ,SUB_ACCT_SERV_ADDR CHAR(81)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
P00821             ,REV_MTH_ORIG_BILL  DECIMAL(06)                      
P00821             ,DATE_ORIG_BILL CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
P00821             ,INDUST_GAS_CUST CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
P00821             ,NET_MTR_ACCOUNT CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
P00821             ,CIG_FLAG CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2          
P00821             ,EMC_FLAG CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2          
P00899             ,BILL_RELEASED_FLG CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
P00899             ,MULT_REGISTER_FLG CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                )
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLSTATE                    TO WS-SQLSTATE.            
            MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
            IF WS-SQLSTATE = '42710'                                    
               PERFORM 8010-DELETE-GTT-ROWS   THRU 8010-EXIT            
            ELSE                                                        
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE SQLCODE                TO ABEND-SQLCODE           
                 MOVE SQLSTATE               TO ABEND-SQLSTATE          
                 MOVE '0100B'                TO ACTIVE-PARAGRAPH        
                 MOVE 'DECLARE GTT'          TO ABEND-FUNCTION          
                 MOVE SPACES                 TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                 MOVE WS-GTT-NAME            TO TABLE-1                 
                 MOVE SPACES                 TO TABLE-ELEMENT-1         
                 MOVE SPACES                 TO HOSTVAR-ELEMENT-1       
                 PERFORM 9700-PROCESS-ABEND   THRU  9700-EXIT           
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C2 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
               SELECT                                                   
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,ACCOUNT_NO                                           
                  ,LTRIM(RTRIM(COMPANY_NO))             AS COMPANY_NO          
                  ,BILL_MONTH                                           
                  ,BILL_NO                                              
                  ,LTRIM(RTRIM(BILL_TIMESTMP))          AS BILL_TIMESTMP       
                  ,DATE_READ                                            
                  ,LTRIM(RTRIM(SERVICE_TYPE))           AS SERVICE_TYPE        
                  ,IC_NO                                                
                  ,LTRIM(RTRIM(RATE_PLAN_NO))           AS RATE_PLAN_NO        
P00821            ,LTRIM(RTRIM(REVENUE_CLASS))          AS REVENUE_CLASS       
P00821            ,LTRIM(RTRIM(PRTY_SVC_CAT_CD))        AS 
           PRTY_SVC_CAT_CD     
P00821            ,LTRIM(RTRIM(CODE_BILL_CALC))         AS 
           CODE_BILL_CALC      
                  ,LTRIM(RTRIM(RATE_DESC))              AS RATE_DESC           
P00821            ,LTRIM(RTRIM(UNMTR_PROV_FL))          AS UNMTR_PROV_FL       
P00899            ,LTRIM(RTRIM(SECUR_RATE_FL))          AS SECUR_RATE_FL       
                  ,LTRIM(RTRIM(OPTION_CD))              AS OPTION_CD           
                  ,LTRIM(RTRIM(OPTION_DESC))            AS OPTION_DESC         
                  ,USAGE                                                
                  ,LTRIM(RTRIM(USAGE_TYPE))             AS USAGE_TYPE          
                  ,DAYS                                                 
                  ,CHARGES                                              
                  ,TAXES                                                
                  ,LTRIM(RTRIM(BILL_ITEM_IND))          AS BILL_ITEM_IND       
                  ,READ_UNITS                                           
                  ,AGL_CHRG                                             
                  ,SUB_ACCOUNT_NO                                       
                  ,LTRIM(RTRIM(SUB_ACCT_SERV_ADDR))     AS 
           SUB_ACCT_SERV_ADDR  
P00821            ,REV_MTH_ORIG_BILL                                    
P00821            ,DATE_ORIG_BILL                                       
P00821            ,LTRIM(RTRIM(INDUST_GAS_CUST))        AS 
           INDUST_GAS_CUST     
P00821            ,LTRIM(RTRIM(NET_MTR_ACCOUNT))        AS 
           NET_MTR_ACCOUNT     
P00821            ,LTRIM(RTRIM(CIG_FLAG))               AS CIG_FLAG            
P00821            ,LTRIM(RTRIM(EMC_FLAG))               AS EMC_FLAG            
P00899            ,LTRIM(RTRIM(BILL_RELEASED_FLG))      AS 
           BILL_RELEASED_FLG   
P00899            ,LTRIM(RTRIM(MULT_REGISTER_FLG))      AS 
           MULT_REGISTER_FLG   
               FROM                                                     
                   #CSR04623_R2                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C2 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*        SELECT                                                           
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,ACCOUNT_NO                                                   
MFA-TR*           ,STRIP(COMPANY_NO)             AS COMPANY_NO                  
MFA-TR*           ,BILL_MONTH                                                   
MFA-TR*           ,BILL_NO                                                      
MFA-TR*           ,STRIP(BILL_TIMESTMP)          AS BILL_TIMESTMP               
MFA-TR*           ,DATE_READ                                                    
MFA-TR*           ,STRIP(SERVICE_TYPE)           AS SERVICE_TYPE                
MFA-TR*           ,IC_NO                                                        
MFA-TR*           ,STRIP(RATE_PLAN_NO)           AS RATE_PLAN_NO                
MFA-TR*           ,STRIP(REVENUE_CLASS)          AS REVENUE_CLASS               
MFA-TR*           ,STRIP(PRTY_SVC_CAT_CD)        AS PRTY_SVC_CAT_CD             
MFA-TR*           ,STRIP(CODE_BILL_CALC)         AS CODE_BILL_CALC              
MFA-TR*           ,STRIP(RATE_DESC)              AS RATE_DESC                   
MFA-TR*           ,STRIP(UNMTR_PROV_FL)          AS UNMTR_PROV_FL               
MFA-TR*           ,STRIP(SECUR_RATE_FL)          AS SECUR_RATE_FL               
MFA-TR*           ,STRIP(OPTION_CD)              AS OPTION_CD                   
MFA-TR*           ,STRIP(OPTION_DESC)            AS OPTION_DESC                 
MFA-TR*           ,USAGE                                                        
MFA-TR*           ,STRIP(USAGE_TYPE)             AS USAGE_TYPE                  
MFA-TR*           ,DAYS                                                         
MFA-TR*           ,CHARGES                                                      
MFA-TR*           ,TAXES                                                        
MFA-TR*           ,STRIP(BILL_ITEM_IND)          AS BILL_ITEM_IND               
MFA-TR*           ,READ_UNITS                                                   
MFA-TR*           ,AGL_CHRG                                                     
MFA-TR*           ,SUB_ACCOUNT_NO                                               
MFA-TR*           ,STRIP(SUB_ACCT_SERV_ADDR)     AS SUB_ACCT_SERV_ADDR          
MFA-TR*           ,REV_MTH_ORIG_BILL                                            
MFA-TR*           ,DATE_ORIG_BILL                                               
MFA-TR*           ,STRIP(INDUST_GAS_CUST)        AS INDUST_GAS_CUST             
MFA-TR*           ,STRIP(NET_MTR_ACCOUNT)        AS NET_MTR_ACCOUNT             
MFA-TR*           ,STRIP(CIG_FLAG)               AS CIG_FLAG                    
MFA-TR*           ,STRIP(EMC_FLAG)               AS EMC_FLAG                    
MFA-TR*           ,STRIP(BILL_RELEASED_FLG)      AS BILL_RELEASED_FLG           
MFA-TR*           ,STRIP(MULT_REGISTER_FLG)      AS MULT_REGISTER_FLG           
MFA-TR*        FROM                                                             
MFA-TR*            SESSION.CSR04623_R2                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
      *                                                                         
       0100B-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      *0100C-DECLARE-GTT-R3.                                                    
      ******************************************************************        
       0100C-DECLARE-GTT-R3.                                            
      *                                                                         
            MOVE 'SESSION.CSR04623_R3'       TO WS-GTT-NAME.            
            MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR04623_R3'           
                                             TO S-SQL-STATEMENT-V.      
                                                                        
            EXEC SQL
              CALL CIS.DROP_TEMP_TABLE('#CSR04623_R3')
            END-EXEC
            EXEC SQL
              CREATE TABLE #CSR04623_R3
               (                                                       
                    RETURN_CODE        INT                          
                   ,APPL_RETURN_CODE   INT                          
                   ,ADDTNL_BILLS_EXIST CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,ACCT_BILLS_COUNT   INT                          
P00899             ,ACCT_LAST_UPDT_TS CHAR(26)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
P00836             ,WEB_AVERAGE_BILL_AMT  DECIMAL(11,2)                 
                )
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLSTATE                    TO WS-SQLSTATE.            
            MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
            IF WS-SQLSTATE = '42710'                                    
               PERFORM 8020-DELETE-GTT-ROWS   THRU 8020-EXIT            
            ELSE                                                        
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE SQLCODE                TO ABEND-SQLCODE           
                 MOVE SQLSTATE               TO ABEND-SQLSTATE          
                 MOVE '0100C'                TO ACTIVE-PARAGRAPH        
                 MOVE 'DECLARE GTT'          TO ABEND-FUNCTION          
                 MOVE SPACES                 TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                 MOVE WS-GTT-NAME            TO TABLE-1                 
                 MOVE SPACES                 TO TABLE-ELEMENT-1         
                 MOVE SPACES                 TO HOSTVAR-ELEMENT-1       
                 PERFORM 9700-PROCESS-ABEND   THRU  9700-EXIT           
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C3 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
               SELECT                                                   
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,ADDTNL_BILLS_EXIST                                   
                  ,ACCT_BILLS_COUNT                                     
P00899            ,ACCT_LAST_UPDT_TS                                    
P00836            ,WEB_AVERAGE_BILL_AMT                                 
               FROM                                                     
                   #CSR04623_R3                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C3 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*        SELECT                                                           
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,ADDTNL_BILLS_EXIST                                           
MFA-TR*           ,ACCT_BILLS_COUNT                                             
MFA-TR*           ,ACCT_LAST_UPDT_TS                                            
MFA-TR*           ,WEB_AVERAGE_BILL_AMT                                         
MFA-TR*        FROM                                                             
MFA-TR*            SESSION.CSR04623_R3                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
      *                                                                         
       0100C-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
P00836******************************************************************        
P00836* TEMP SESSION TABLE FOR APPL PROGRAM = WBH/WBC/WBR              *        
P00836******************************************************************        
P00836*                                                                         
P00836 0100D-DECLARE-GTT-R4.                                            
P00836*                                                                         
P00836      MOVE 'SESSION.CSR04623_R4'       TO WS-GTT-NAME.            
P00836      MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR04623_R4'           
P00836                                       TO S-SQL-STATEMENT-V.      
P00836*                                                                         
P00836      EXEC SQL
              CALL CIS.DROP_TEMP_TABLE('#CSR04623_R4')
            END-EXEC
            EXEC SQL
              CREATE TABLE #CSR04623_R4
               (                                                       
P00836              RETURN_CODE          INT                        
P00836             ,APPL_RETURN_CODE     INT                        
P00836             ,ACCOUNT_NO           DECIMAL(13)                    
P00836             ,COMPANY_NO CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2        
P00836             ,BILL_MONTH           DECIMAL(06)                    
P00836             ,BILL_NO              INT                        
P00836             ,DATE_BILLED CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
P00836             ,BILL_AMOUNT          DECIMAL(11,2)                  
P00836             ,PAYMENTS             DECIMAL(11,2)                  
P00836             ,OTHR_CHRGS           DECIMAL(11,2)                  
P00836             ,ARREARS              DECIMAL(11,2)                  
P00836             ,TOTAL_AMOUNT         DECIMAL(11,2)                  
P00836             ,CODE_BILL_TYPE CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
P00836             ,ELECTRIC_CHARGES     DECIMAL(11,2)                  
P00836             ,GAS_CHARGES          DECIMAL(11,2)                  
P00836             ,UNMETERED_CHARGES    DECIMAL(11,2)                  
P00836             ,TAXES                DECIMAL(11,2)                  
P00836             ,WEB_CURRENT_CHARGES  DECIMAL(11,2)                  
P00836             ,WEB_TOT_BILL_AMOUNT  DECIMAL(11,2)                  
P00836          )
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00836*                                                                         
P00836      MOVE SQLSTATE                    TO WS-SQLSTATE.            
P00836      MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.  
P00836*                                                                         
P00836      IF WS-SQLSTATE = '42710'                                    
P00836         PERFORM 8030-DELETE-GTT-ROWS   THRU 8030-EXIT            
P00836      ELSE                                                        
P00836         IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
P00836           CONTINUE                                               
P00836        ELSE                                                      
P00836           MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
P00836           MOVE SQLCODE                TO ABEND-SQLCODE           
P00836           MOVE SQLSTATE               TO ABEND-SQLSTATE          
P00836           MOVE '0100D'                TO ACTIVE-PARAGRAPH        
P00836           MOVE 'DECLARE GTT'          TO ABEND-FUNCTION          
P00836           MOVE SPACES                 TO ABEND-SQL-PREDICATES    
P00836                                          ABEND-TABLES            
P00836           MOVE WS-GTT-NAME            TO TABLE-1                 
P00836           MOVE SPACES                 TO TABLE-ELEMENT-1         
P00836           MOVE SPACES                 TO HOSTVAR-ELEMENT-1       
P00836           PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT            
P00836        END-IF                                                    
P00836     END-IF.                                                      
P00836*                                                                         
P00836     EXEC SQL                                                     
P00836         DECLARE C4 CURSOR                             
P00836                           WITH ROWSET POSITIONING FOR            
P00836         SELECT                                                   
P00836             RETURN_CODE                                          
P00836            ,APPL_RETURN_CODE                                     
P00836            ,ACCOUNT_NO                                           
P00836            ,LTRIM(RTRIM(COMPANY_NO))             AS COMPANY_NO          
P00836            ,BILL_MONTH                                           
P00836            ,BILL_NO                                              
P00836            ,DATE_BILLED                                          
P00836            ,BILL_AMOUNT                                          
P00836            ,PAYMENTS                                             
P00836            ,OTHR_CHRGS                                           
P00836            ,ARREARS                                              
P00836            ,TOTAL_AMOUNT                                         
P00836            ,LTRIM(RTRIM(CODE_BILL_TYPE))        AS CODE_BILL_TYPE       
P00836            ,ELECTRIC_CHARGES                                     
P00836            ,GAS_CHARGES                                          
P00836            ,UNMETERED_CHARGES                                    
P00836            ,TAXES                                                
P00836            ,WEB_CURRENT_CHARGES                                  
P00836            ,WEB_TOT_BILL_AMOUNT                                  
P00836         FROM                                                     
P00836             #CSR04623_R4                                  
P00836     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C4 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*        SELECT                                                           
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,ACCOUNT_NO                                                   
MFA-TR*           ,STRIP(COMPANY_NO)             AS COMPANY_NO                  
MFA-TR*           ,BILL_MONTH                                                   
MFA-TR*           ,BILL_NO                                                      
MFA-TR*           ,DATE_BILLED                                                  
MFA-TR*           ,BILL_AMOUNT                                                  
MFA-TR*           ,PAYMENTS                                                     
MFA-TR*           ,OTHR_CHRGS                                                   
MFA-TR*           ,ARREARS                                                      
MFA-TR*           ,TOTAL_AMOUNT                                                 
MFA-TR*           ,STRIP(CODE_BILL_TYPE)        AS CODE_BILL_TYPE               
MFA-TR*           ,ELECTRIC_CHARGES                                             
MFA-TR*           ,GAS_CHARGES                                                  
MFA-TR*           ,UNMETERED_CHARGES                                            
MFA-TR*           ,TAXES                                                        
MFA-TR*           ,WEB_CURRENT_CHARGES                                          
MFA-TR*           ,WEB_TOT_BILL_AMOUNT                                          
MFA-TR*        FROM                                                             
MFA-TR*            SESSION.CSR04623_R4                                          
MFA-TR*    END-EXEC.                                                            
P00836*                                                                         
P00836 0100D-EXIT.                                                      
P00836      EXIT.                                                       
P00836*                                                                         
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *     1. RECEIVE PARMS.                                          *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
      *                                                                         
           MOVE I-ACCOUNT-NUMBER             TO BI-ACCOUNT-NO           
                                                BG-ACCOUNT-NO           
                                                UT-ACCOUNT-NO           
                                                AT-ACCOUNT-NO           
                                                AF-ACCOUNT-NO           
P00899                                          OC-ACCOUNT-NO           
                                                AR-ACCOUNT-NO.          
           MOVE I-INCLUDE-ADDTNL-HIST        TO WS-INCLD-ADDTNL-HIST.   
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1       THRU 0100A-EXIT.          
           PERFORM 0100B-DECLARE-GTT-R2       THRU 0100B-EXIT.          
           PERFORM 0100C-DECLARE-GTT-R3       THRU 0100C-EXIT.          
P00836* DECLARE FOLLOWING SESSION TABLE FOR 'WBH'/'WBC'/'WBR'                   
P00836* THIS TABLE WILL BE USED TO POPULATE RESULT SET 1(HEADER)                
P00836     IF I-APPL-PROGRAM-ID = 'WBH' OR 'WBC' OR 'WBR'               
P00836        PERFORM 0100D-DECLARE-GTT-R4    THRU 0100D-EXIT           
P00836     END-IF.                                                      
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *     THIS ROUTINE WILL RETRIEVE ALL BILLING HEADER RECORDS AND  *        
      *      ASSOCIATED DETAIL RECORDS WITHIN A SINGLE PASS.           *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           PERFORM 7000-OPEN-BI-CURSOR        THRU 7000-EXIT.           
           PERFORM 7010-FETCH-BI-ROW          THRU 7010-EXIT.           
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE        TO S1-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '2000'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE 'CSS_BILLING_HDR  '       TO TABLE-1                 
              MOVE 'ACCOUNT_NO  '            TO TABLE-ELEMENT-1         
              MOVE BI-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           ELSE                                                         
              MOVE 'DATABASE'                TO C8-DELINQ-CD            
              MOVE BI-COMPANY-NO             TO C8-COMPANY-NO           
              PERFORM 7270-GET-DATABASE       THRU 7270-EXIT            
                                                                        
              PERFORM 7280-SELECT-AT          THRU 7280-EXIT            
                                                                        
      ******************************************************************        
P00821*       GET COBB SNAP SHOAL DETAILS                              *        
P00821******************************************************************        
P00821        MOVE 'N'                       TO S2-CIG-FLAG             
P00821        MOVE BI-ACCOUNT-NO             TO XM-ACCOUNT-NO           
P00821        PERFORM 7118-SELECT-COBB-SNAPSHOAL  THRU 7118-EXIT        
P00821        IF WS-COBB-SNAPSHOAL = 'C' OR 'S'                         
P00821           MOVE PROGRAM-NAME     TO G6-PROGRAM-NAME               
P00821           MOVE 'PARM'           TO G6-CMND-CODE                  
P00821           MOVE 'A'              TO G6-STATUS                     
P00821           IF WS-COBB-SNAPSHOAL = 'C'                             
P00821              MOVE 0001          TO G6-SEQ-NO                     
P00821           ELSE                                                   
P00821              MOVE 0002          TO G6-SEQ-NO                     
P00821           END-IF                                                 
P00821           PERFORM 7920-SELECT-JOB-PARM     THRU 7920-EXIT        
P00821           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND               
P00821              MOVE SPACES           TO WS-PARM-DATA               
P00821           ELSE                                                   
P00821               MOVE G6-PARM-DATA     TO WS-PARM-DATA              
P00821            END-IF                                                
P00821         END-IF                                                   
P00821                                                                  
P00821         MOVE 'N'                 TO S1-PSNC-FLAG                 
P00821******************************************************************        
P00821*       GET PSNC CUT OFF DATE                                    *        
P00821******************************************************************        
P00821        IF  AT-COMPANY-NO = WS-PSNC                               
P00821            MOVE PROGRAM-NAME          TO WS-PGRMNAME             
P00821            PERFORM 6251-GET-FJC01-DATE THRU 6251-EXIT            
P00821        END-IF                                                    
P00821                                                                  
P00899******************************************************************        
P00899*       CHECK IF BILL RELEASED FOR OFF CYCLE BILLING             *        
P00899******************************************************************        
P00899        MOVE 'N'                       TO S2-BILL-RELEASED-FLG    
P00899        PERFORM 7900-CHECK-BILL-RLSD   THRU 7900-EXIT             
P00821******************************************************************        
P00821*       CHECK IS THERE ANY IC ENTRY MISSING IN BILLING_DET TABLE *        
P00821******************************************************************        
P00821        MOVE 'N'                       TO S1-FUT-BILL-HOOK-INS-FL 
P00821        IF BI-DATE-BILLED = SPACES                                
P00821           MOVE BI-BILL-NO             TO WS-BI-BILL-NO           
P00821           PERFORM 7180-SELECT-BILLING-DET                        
P00821                                        THRU 7180-EXIT            
P00821           PERFORM 7190-SELECT-UT-ROW   THRU 7190-EXIT            
P00821                                                                  
P00821           IF WS-BG-ROW-COUNT NOT EQUAL WS-UT-ROW-COUNT           
P00821              MOVE 'Y'                 TO S1-FUT-BILL-HOOK-INS-FL 
P00821           END-IF                                                 
P00899        ELSE                                                      
P00899           MOVE 'Y'                    TO S1-FUT-BILL-HOOK-INS-FL 
P00821        END-IF                                                    
P00821******************************************************************        
      *       ADDITIONAL HIST FLAG - NO                                *        
      *                  RETRIEVE LATEST 13 REVENUE MONTH DETAILS      *        
      *       ADDITIONAL HIST FLAG - NO & ACCOUNT HAS ONLY UNBILL      *        
      *                  ROW PRESENT                                   *        
      *                  RETRIEVE ALL REVENUE MONTH DETAILS            *        
      *       ADDITIONAL HIST FLAG - YES                               *        
      *                  RETRIEVE ALL REVENUE MONTH DETAILS            *        
      ******************************************************************        
              IF WS-INCLD-ADDTNL-HIST = WS-NO AND                       
                 AT-REV-MTH-LST-NRML  > ZERO                            
P00836*** WEB CALL: 12 MONTHS HISTORY IS REQUIRED FOR CHART                     
P00836           IF I-APPL-PROGRAM-ID = 'WBC'                           
P00836              MOVE WS-DFLT-WBC-NO-OF-REV-MTH TO WS-CUTOFF-CNT     
P00836           ELSE                                                   
P00836              MOVE WS-DFLT-NO-OF-BILLS       TO WS-CUTOFF-CNT     
P00836           END-IF                                                 
                 PERFORM 2100-GET-CUTOFF-REV-MNTH                       
                                              THRU 2100-EXIT            
                   UNTIL WS-CUTOFF-CNT = 0                              
                 MOVE WS-CUTOF-REV-MNTH      TO WS-REVENUE-MONTH        
              ELSE                                                      
                 MOVE WS-ALL-BILLS           TO WS-REVENUE-MONTH        
              END-IF                                                    
                                                                        
              PERFORM 2200-BUILD-RESULT-HEADER                          
                                              THRU 2200-EXIT            
                UNTIL NO-MORE-HEADER-RECS                               
                   OR WS-REVENUE-MONTH-TEMP = WS-REVENUE-MONTH          
           END-IF.                                                      
                                                                        
           PERFORM 7020-CLOSE-BI-CURSOR       THRU 7020-EXIT.           
                                                                        
P00836*** INSERT DATA INTO RESULT SET 1(HEADER) BASED ON SCENARIO               
P00836     EVALUATE I-APPL-PROGRAM-ID                                   
P00836         WHEN 'WBH'                                               
P00836            PERFORM 8210-INSERT-R1-ALL-HISTORY  THRU 8210-EXIT    
P00836         WHEN 'WBR'                                               
P00836            PERFORM 8220-INSERT-R1-RECENT-BILLS THRU 8220-EXIT    
P00836         WHEN 'WBC'                                               
P00836            PERFORM 8230-INSERT-R1-CHART        THRU 8230-EXIT    
P00836     END-EVALUATE.                                                
P00836*                                                                         
      ******************************************************************        
      *    PERFORM BELOW CHECK TO KNOW THE ACCOUNT HAS ADDITIONAL      *        
      *    BILL(S) EXIST.                                              *        
      *    THIS FLAG IS USED IN BILL HISTORY SCREEN IN CIS-MOD TO      *        
      *    ENABLE "SHOW ALL MONTHS" LINK.                              *        
      ******************************************************************        
           IF WS-INCLD-ADDTNL-HIST = WS-NO AND                          
              AT-REV-MTH-LST-NRML  > ZERO                               
              PERFORM 2300-CHK-ADDTNL-BILLS-EXIST                       
                                              THRU 2300-EXIT            
           ELSE                                                         
              MOVE WS-NO                     TO S3-ADDTNL-BILLS-EXIST   
           END-IF.                                                      
P00899     MOVE AT-LAST-UPDATE-TS            TO S3-ACCT-LAST-UPDT-TS.   
P00836*                                                                         
P00836*** CALCULATE AVERAGE BILL AMOUNT = TOTAL BILL AMOUNT /                   
P00836*** HEADER RESULT SET ROW COUNT                                           
P00836     IF I-APPL-PROGRAM-ID = 'WBH' OR 'WBC' OR 'WBR'               
P00836        PERFORM 8250-WEB-GET-SUM-AND-COUNT  THRU  8250-EXIT       
P00836        IF CTR-ROWS-RS1 > 0                                       
P00836           COMPUTE S3-WEB-AVERAGE-BILL-AMT ROUNDED                
P00836                 = S3-WEB-AVERAGE-BILL-AMT / CTR-ROWS-RS1         
P00836           END-COMPUTE                                            
P00836        END-IF                                                    
P00836     END-IF.                                                      
P00836*                                                                         
           PERFORM 8120-INSERT-GTT-R3         THRU 8120-EXIT.           
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2100-GET-CUTOFF-REV-MNTH.                                      *        
      *   THIS ROUTINE WILL GET THE CUTOFF REVENUE MONTH               *        
      ******************************************************************        
       2100-GET-CUTOFF-REV-MNTH.                                        
      *                                                                         
           SUBTRACT +1     FROM WS-CUTOF-REV-MNTH-MM                    
                                WS-CUTOFF-CNT.                          
                                                                        
           IF WS-CUTOF-REV-MNTH-MM = ZERO                               
              MOVE WS-12                     TO WS-CUTOF-REV-MNTH-MM    
              SUBTRACT +1  FROM WS-CUTOF-REV-MNTH-YY                    
           END-IF.                                                      
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2200-BUILD-RESULT-HEADER                                       *        
      *     BUILD THE RESULT SET DESCRIBED ABOVE.                      *        
      *                                                                *        
      * I-INCLUDE-DETAIL-ROW       = 'N'                               *        
      *           DON'T INSERT BILLING DETAIL ROW                      *        
      * I-INCLUDE-UNBILLED-BILL    = 'N'                               *        
      *           DON'T INSERT FUTURE HOOK BILL                        *        
      * I-INCLUDE-LATEST-BILL-ONLY = 'Y'                               *        
      *           DON'T INSERT CANCEL/REBILL ROWS                      *        
      *                                                                *        
      ******************************************************************        
       2200-BUILD-RESULT-HEADER.                                        
      *                                                                         
           MOVE BI-ACCOUNT-NO                TO S1-ACCOUNT-NO           
                                                S2-ACCOUNT-NO.          
           MOVE BI-COMPANY-NO                TO S1-COMPANY-NO.          
           MOVE BI-BILL-NO                   TO BG-BILL-NO              
                                                AF-BILL-NO              
                                                S1-BILL-NO              
                                                S2-BILL-NO.             
           MOVE BI-CODE-BILL-TYPE            TO S1-CODE-BILL-TYPE.      
           MOVE BI-CODE-BILL-STATUS          TO S1-CODE-BILL-STATUS.    
           MOVE BI-TOT-OTHER-CHARGES         TO S1-TOT-OTHER-CHARGES.   
           MOVE BI-TOTAL-ARREARS             TO S1-TOTAL-ARREARS.       
           MOVE BI-DATE-BILLED               TO WS-BILL-DATE.           
                                                                        
P00821     MOVE 'N'                          TO S1-PSNC-FLAG            
P00821     IF WS-BILL-DATE > SPACES                                     
P00821        IF AT-COMPANY-NO = WS-PSNC                                
P00821           IF WS-BILL-DATE  < WS-CUT-OFF-DATE                     
P00821              MOVE 'Y'                 TO S1-PSNC-FLAG            
P00821           END-IF                                                 
P00821        END-IF                                                    
P00821     END-IF.                                                      
                                                                        
           IF (I-INCLUDE-UNBILLED-BILL    = WS-NO                       
           AND WS-BILL-DATE               = SPACES                      
           AND S1-CODE-BILL-STATUS        = 'A')                        
                           OR                                           
              (I-INCLUDE-LATEST-BILL-ONLY = WS-YES                      
           AND S1-CODE-BILL-STATUS        = 'C')                        
P00836                     OR                                           
P00836        ( (I-APPL-PROGRAM-ID = 'WBH' OR 'WBC' OR 'WBR') AND       
P00836          (WS-BILL-DATE      = SPACES) )                          
              CONTINUE                                                  
           ELSE                                                         
              PERFORM 2210-PROCESS-DETAIL-ROW THRU 2210-EXIT            
                                                                        
           END-IF.                                                      
                                                                        
           PERFORM 7010-FETCH-BI-ROW          THRU 7010-EXIT.           
                                                                        
           IF (I-INCLUDE-UNBILLED-BILL    = WS-NO                       
           AND WS-BILL-DATE               = SPACES                      
           AND S1-CODE-BILL-STATUS        = 'A')                        
                             OR                                         
              (I-INCLUDE-LATEST-BILL-ONLY = WS-YES                      
           AND S1-CODE-BILL-STATUS        = 'C')                        
P00836                     OR                                           
P00836        ( (I-APPL-PROGRAM-ID = 'WBH' OR 'WBC' OR 'WBR') AND       
P00836          (WS-BILL-DATE      = SPACES) )                          
              CONTINUE                                                  
           ELSE                                                         
              PERFORM 2230-COMPUTE-PAYMENTS   THRU 2230-EXIT            
P00836        IF I-APPL-PROGRAM-ID = 'WBH' OR 'WBC' OR 'WBR'            
P00836           PERFORM 2250-WEBMOD-HDR-CHANGES THRU 2250-EXIT         
P00836        ELSE                                                      
P00836           IF S1-BILL-AMOUNT       = 0 AND                        
P00836              S1-TOT-OTHER-CHARGES = 0 AND                        
P00836              S1-TOTAL-ARREARS     = 0                            
P00836              MOVE 'N'             TO S1-SHOW-BILL-IMAGE-FL       
P00836           ELSE                                                   
P00836              MOVE 'Y'             TO S1-SHOW-BILL-IMAGE-FL       
P00836           END-IF                                                 
P00836           PERFORM 8100-INSERT-GTT-R1      THRU 8100-EXIT         
P00836        END-IF                                                    
P00836        PERFORM 2290-INIT-HEADER-FIELDS THRU 2290-EXIT            
           END-IF.                                                      
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2210-PROCESS-DETAIL-ROW.                                       *        
      *   THIS ROUTINE WILL INITIALIZE ALL BILLING HEADER COLUMNS      *        
      ******************************************************************        
       2210-PROCESS-DETAIL-ROW.                                         
      *                                                                         
           IF  BI-DATE-BILLED = SPACES                                  
               MOVE ZERO                     TO S1-TOTAL-BILL-AMOUNT    
               MOVE SPACES                   TO S1-DATE-BILLED          
           ELSE                                                         
               PERFORM 2220-GET-TOTAL         THRU 2220-EXIT            
               MOVE AR-AMT-BILLED-UNPAID     TO S1-TOTAL-BILL-AMOUNT    
               MOVE BI-DATE-BILLED           TO S1-DATE-BILLED          
           END-IF.                                                      
                                                                        
           IF MASTER-ACCOUNT                                            
              MOVE WS-YES                    TO WS-MORE-SUBS-SW         
              PERFORM 7022-OPEN-XFER-CURSOR   THRU 7022-EXIT            
              PERFORM 7024-FETCH-XFER-ROW     THRU 7024-EXIT            
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 PERFORM 2400-PROCESS-SUBS    THRU 2400-EXIT            
                   UNTIL NO-MORE-SUBACCTS                               
                 PERFORM 7026-CLOSE-XFER-CURSOR                         
                                              THRU 7026-EXIT            
              ELSE                                                      
                 PERFORM 7026-CLOSE-XFER-CURSOR                         
                                              THRU 7026-EXIT            
              END-IF                                                    
           ELSE                                                         
              PERFORM 2500-BUILD-RESULT-DETAIL                          
                                              THRU 2500-EXIT            
           END-IF.                                                      
                                                                        
           MOVE WS-TOTAL-BG-DOLLARS          TO S1-BILL-AMOUNT.         
P00836     MOVE WS-TOTAL-ELEC-CHARGES        TO S1-TOTAL-ELEC-CHARGES.  
P00836     MOVE WS-TOTAL-GAS-CHARGES         TO S1-TOTAL-GAS-CHARGES.   
P00836     MOVE WS-TOTAL-UNMTR-CHARGES       TO S1-TOTAL-UNMTR-CHARGES. 
P00836     MOVE WS-TOTAL-TAXES               TO S1-TOTAL-TAXES.         
           MOVE WS-HOLD-REV-MM               TO S1-REVENUE-MONTH        
                                                WS-REVENUE-MONTH-TEMP.  
           MOVE ZERO                         TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
       2210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2220-GET-TOTAL                                                 *        
      *     OBTAINS TOTAL BILL AMOUNT FOR A GIVEN BILL DATE            *        
      ******************************************************************        
       2220-GET-TOTAL.                                                  
      *                                                                         
           EXEC SQL                                                     
              SELECT SUM(AMT_BILLED_UNPAID)                             
              INTO  :AR-AMT-BILLED-UNPAID :WS-NULL-IND-3                
              FROM   CSS_AR_TRANS_HIST WITH(READUNCOMMITTED)                    
P00821        WHERE  ACCOUNT_NO     = :AT-ACCOUNT-NO                    
              AND    DATE_TRANS     = IIF(TRY_CONVERT(DATE, 
                                                        :BI-DATE-BILLED
              ) IS NULL OR (PATINDEX('%.%', :BI-DATE-BILLED
              ) <> 0) OR (LEN(:BI-DATE-BILLED) <> 10), CIS.CHAR2DATE(
                                                        :BI-DATE-BILLED
              ), CONVERT(DATE, :BI-DATE-BILLED) )                   
              AND    CODE_TRAN_TYPE = 'B'                               
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SUM(AMT_BILLED_UNPAID)                                     
MFA-TR*       INTO  :AR-AMT-BILLED-UNPAID :WS-NULL-IND-3                        
MFA-TR*       FROM   CSS_AR_TRANS_HIST                                          
MFA-TR*       WHERE  ACCOUNT_NO     = :AT-ACCOUNT-NO                            
MFA-TR*       AND    DATE_TRANS     = :BI-DATE-BILLED                           
MFA-TR*       AND    CODE_TRAN_TYPE = 'B'                                       
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-NULL-IND-3 < 0                                      
                 MOVE 0                      TO AR-AMT-BILLED-UNPAID    
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '2220'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_AR_TRANS_HIST'       TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'DATE_TRANS'              TO TABLE-ELEMENT-2         
              MOVE BG-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE BI-DATE-BILLED            TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       2220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2230-COMPUTE-PAYMENTS.                                         *        
      *   THIS ROUTINE WILL INITIALIZE ALL BILLING HEADER COLUMNS      *        
      ******************************************************************        
       2230-COMPUTE-PAYMENTS.                                           
      *                                                                         
           IF WS-PREV-BILL-DATE EQUAL SPACES AND                        
              WS-BILL-DATE       >    SPACES                            
              MOVE '1900-01-01'              TO WS-PREV-BILL-DATE       
           END-IF.                                                      
                                                                        
           IF WS-PREV-BILL-DATE  >    SPACES AND                        
              WS-BILL-DATE       >    SPACES                            
              PERFORM 2240-PYMTS-BET-2-BILL-DATES                       
                                              THRU  2240-EXIT           
              MOVE AR-AMT-ORIG-ENTERED       TO S1-PAYMENTS             
           ELSE                                                         
              MOVE ZEROS                     TO S1-PAYMENTS             
           END-IF.                                                      
      *                                                                         
       2230-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2240-PYMTS-BET-2-BILL-DATES                                    *        
      *     OBTAINS ALL THE PAYMENTS BETWEEN TWO BILLING DATES.        *        
      ******************************************************************        
       2240-PYMTS-BET-2-BILL-DATES.                                     
      *                                                                         
      *    TO GET AR-TRANS-HIST-SEQ-NO USING CURR BILL DATE.                    
           MOVE WS-BILL-DATE                 TO AR-DATE-TRANS.          
           PERFORM  7210-GET-AR-TRANS-SEQ-NO  THRU 7210-EXIT.           
           MOVE AR-TRANS-HIST-SEQ-NO         TO                         
                                            WS-CURRBILL-AR-TRNSHIST-SEQ.
                                                                        
      *    TO GET AR-TRANS-HIST-SEQ-NO USING PREVIOUS BILL DATE.                
           IF WS-PREV-BILL-DATE = '1900-01-01'                          
              MOVE '1900-01-01-00.00.00.000000'                         
                                             TO                         
                                            WS-PREVBILL-AR-TRNSHIST-SEQ 
           ELSE                                                         
              MOVE WS-PREV-BILL-DATE         TO AR-DATE-TRANS           
              PERFORM  7210-GET-AR-TRANS-SEQ-NO                         
                                              THRU 7210-EXIT            
              MOVE AR-TRANS-HIST-SEQ-NO      TO                         
                                            WS-PREVBILL-AR-TRNSHIST-SEQ 
           END-IF.                                                      
                                                                        
           IF WS-CURRBILL-AR-TRNSHIST-SEQ > SPACES AND                  
              WS-PREVBILL-AR-TRNSHIST-SEQ > SPACES                      
               PERFORM  7220-GET-PAYMENT-AMT  THRU 7220-EXIT            
           ELSE                                                         
              MOVE ZEROS                     TO AR-AMT-ORIG-ENTERED     
           END-IF.                                                      
      *                                                                         
       2240-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P00836******************************************************************        
P00836** WEBMOD CUSTOMIZATION BASED ON WBH/WBC/WBR                    **        
P00836******************************************************************        
P00836*                                                                         
P00836 2250-WEBMOD-HDR-CHANGES.                                         
P00836*                                                                         
P00836     MOVE '2250'                       TO ACTIVE-PARAGRAPH.       
P00836*                                                                         
P00836     INITIALIZE                           WS-WEB-REV-MTH-CURR     
P00836                                          WS-WEB-REV-MTH-CH       
P00836                                          BN-BILL-CYCLE           
P00836                                          BN-DATE-EXTRACT         
P00836                                          BN-REVENUE-MONTH.       
P00836*                                                                         
P00836*** POPULATE REVENUE MONTH                                                
P00836*                                                                         
P00836*** IF CANCEL REBILL IMMEDIATE(NO BG WITH REV_MTH_ORIG_BILL=0),           
P00836*** USE MAX OF REV MTH ORIG BILL; ELSE USE MAX OF REVENUE MONTH           
P00836     PERFORM 7400-GET-REV-MTH-WEB-DFLT  THRU  7400-EXIT.          
P00836     MOVE WS-WEB-REV-MTH-CURR          TO S1-REVENUE-MONTH.       
P00836*                                                                         
P00836     IF S1-REVENUE-MONTH = 0                                      
P00836        MOVE AT-BILL-CYCLE             TO BN-BILL-CYCLE           
P00836        MOVE S1-DATE-BILLED            TO BN-DATE-EXTRACT         
P00836*** GET REVENUE MONTH USING BILL CYCLE & DATE BILLED                      
P00836        PERFORM 7410-GET-REV-MTH-WEB-BN-1 THRU 7410-EXIT          
P00836        IF WS-WEB-REV-MTH-CURR > 0                                
P00836           MOVE WS-WEB-REV-MTH-CURR    TO S1-REVENUE-MONTH        
P00836        ELSE                                                      
P00836*** GET MINIMUM REVENUE MONTH USING DATE BILLED                           
P00836           PERFORM 7420-GET-REV-MTH-WEB-BN-2 THRU 7420-EXIT       
P00836           IF WS-WEB-REV-MTH-CURR > 0                             
P00836              MOVE WS-WEB-REV-MTH-CURR TO S1-REVENUE-MONTH        
P00836           ELSE                                                   
P00836*** POPULATE REVENUE MONTH USING YYYYMM OF DATE BILLED                    
P00836              MOVE S1-DATE-BILLED(1:4) TO WS-WEB-REV-MTH-CH(1:4)  
P00836              MOVE S1-DATE-BILLED(6:2) TO WS-WEB-REV-MTH-CH(5:2)  
P00836              MOVE WS-WEB-REV-MTH-CH   TO S1-REVENUE-MONTH        
P00836           END-IF                                                 
P00836        END-IF                                                    
P00836     END-IF.                                                      
P00836*                                                                         
P00836*** WBC CALL: IF REVENUE MONTH OF PREVIOUS ROW AND CURRENT ROW            
P00836*** IS SAME, SET TOTAL OTHER CHARGES AND TOTAL ARREARS TO 0               
P00836*** WBH/WBR CALL: CHECK CODE BILL TYPE ALONG WITH ABOVE LOGIC             
P00836*                                                                         
P00836     IF (I-APPL-PROGRAM-ID      = 'WBH'               AND         
P00836         WS-CODE-BILL-TYPE-PREV =  S1-CODE-BILL-TYPE  AND         
P00836         WS-WEB-REV-MTH-PREV    =  S1-REVENUE-MONTH)              
P00836                                OR                                
P00836        (I-APPL-PROGRAM-ID      = 'WBR'               AND         
P00836         WS-CODE-BILL-TYPE-PREV =  S1-CODE-BILL-TYPE  AND         
P00836         WS-WEB-REV-MTH-PREV    =  S1-REVENUE-MONTH)              
P00836                                OR                                
P00836        (I-APPL-PROGRAM-ID      = 'WBC'               AND         
P00836         WS-WEB-REV-MTH-PREV    =  S1-REVENUE-MONTH)              
P00836        MOVE 0                         TO S1-TOT-OTHER-CHARGES    
P00836                                          S1-TOTAL-ARREARS        
P00836                                          S1-TOTAL-BILL-AMOUNT    
P00836     END-IF.                                                      
P00836*                                                                         
P00836     COMPUTE S1-WEB-CURRENT-CHARGES = S1-BILL-AMOUNT +            
P00836             S1-TOT-OTHER-CHARGES                                 
P00836     END-COMPUTE.                                                 
P00836*                                                                         
P00836*** WHEN WE ARE ABOUT TO WRITE FIRST ROW, SAVE REVENUE MONTH OF           
P00836*** LATEST BILL.USING WQ/CREDIT LOGIC, SET SHOW LATEST BILL FL.           
P00836     IF CTR-ROWS-RS4           =  0  AND                          
P00836        WS-WEB-REV-MTH-LATEST  =  0  AND                          
P00836        S1-REVENUE-MONTH       >  0                               
P00836        MOVE S1-REVENUE-MONTH          TO WS-WEB-REV-MTH-LATEST   
P00836        MOVE S1-CODE-BILL-TYPE         TO WS-WEB-BILL-TYPE-LATEST 
P00836        PERFORM 7450-CHECK-EBILL-NO-DISP-IND THRU 7450-EXIT       
P00836        IF WS-SHOW-LATEST-BILL-FL = 'Y'                           
P00836           PERFORM 7460-CHECK-BILL-CRED-DATA THRU 7460-EXIT       
P00836           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                   
P00836              MOVE 'N'                 TO WS-SHOW-LATEST-BILL-FL  
P00836           END-IF                                                 
P00836        END-IF                                                    
P00836*       IF WS-SHOW-LATEST-BILL-FL = 'Y'                                   
P00836*          PERFORM 7470-CHECK-CODE-BILL-OFF-CYCL THRU 7470-EXIT           
P00836*       END-IF                                                            
P00836     END-IF.                                                      
P00836*                                                                         
P00836*** HIDE LATEST REVENUE MONTH BILL(S) WHEN FLAG IS 'N'                    
P00836     IF WS-SHOW-LATEST-BILL-FL  = 'N'                AND          
P00836        WS-WEB-REV-MTH-LATEST   =  S1-REVENUE-MONTH  AND          
P00836        WS-WEB-BILL-TYPE-LATEST =  S1-CODE-BILL-TYPE              
P00836        CONTINUE                                                  
P00836     ELSE                                                         
P00836        PERFORM 8200-INSERT-GTT-R4     THRU  8200-EXIT            
P00836        MOVE S1-REVENUE-MONTH          TO WS-WEB-REV-MTH-PREV     
P00836        MOVE S1-CODE-BILL-TYPE         TO WS-CODE-BILL-TYPE-PREV  
P00836     END-IF.                                                      
P00836*                                                                         
P00836 2250-EXIT.                                                       
P00836     EXIT.                                                        
P00836*                                                                         
      ******************************************************************        
P00836* 2290-INIT-HEADER-FIELDS.                                       *        
      *   THIS ROUTINE WILL INITIALIZE ALL BILLING HEADER COLUMNS      *        
      ******************************************************************        
P00836 2290-INIT-HEADER-FIELDS.                                         
      *                                                                         
           MOVE SPACES                       TO S1-COMPANY-NO           
                                                S1-DATE-BILLED          
                                                S1-CODE-BILL-TYPE       
                                                S1-CODE-BILL-STATUS.    
P00821     MOVE WS-NO                        TO S1-BILL-ADJ-FLAG.       
           MOVE 0                            TO S1-TOT-OTHER-CHARGES    
                                                S1-TOTAL-BILL-AMOUNT    
                                                WS-TOTAL-BG-DOLLARS     
                                                S1-TOTAL-ARREARS        
                                                S1-REVENUE-MONTH        
                                                S1-BILL-AMOUNT          
                                                S1-PAYMENTS             
                                                S1-BILL-NO              
P00836                                          WS-TOTAL-ELEC-CHARGES   
P00836                                          WS-TOTAL-GAS-CHARGES    
P00836                                          WS-TOTAL-UNMTR-CHARGES  
P00836                                          WS-TOTAL-TAXES          
P00836                                          S1-TOTAL-ELEC-CHARGES   
P00836                                          S1-TOTAL-GAS-CHARGES    
P00836                                          S1-TOTAL-UNMTR-CHARGES  
P00836                                          S1-TOTAL-TAXES          
P00836                                          S1-WEB-CURRENT-CHARGES  
P00821                                          WS-HOLD-REV-MM-CHAR     
                                                WS-HOLD-REV-MM.         
      *                                                                         
P00836 2290-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************15130000
      * 2300-CHK-ADDTNL-BILLS-EXIST                                    *15140000
      *   THIS PARA CHECK WHETHER THE ACCOUNT HAS ADDITIONAL BILLS     *15160000
      *   EXIST.                                                       *15170000
      ******************************************************************15220000
       2300-CHK-ADDTNL-BILLS-EXIST.                                     
      *                                                                 15250000
           MOVE WS-NO                        TO S3-ADDTNL-BILLS-EXIST.  
           MOVE WS-REVENUE-MONTH             TO BG-REVENUE-MONTH.       
                                                                        
PRJ821     IF MASTER-ACCOUNT                                            
PRJ821        PERFORM 7145-CHK-13-MTHS-BIL-EXIST-MST                    
PRJ821                                        THRU 7145-EXIT            
PRJ821     ELSE                                                         
PRJ821        PERFORM 7150-CHK-13-MNTHS-BILL-EXIST                      
PRJ821                                        THRU 7150-EXIT            
PRJ821        PERFORM 7170-GET-ACCT-BILLS-COUNT                         
PRJ821                                        THRU 7170-EXIT            
PRJ821     END-IF.                                                      
PRJ821                                                                  
      *                                                                 15250000
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15250000
      ******************************************************************15130000
      * 2400-PROCESS-SUBS                                              *15140000
      *   THIS ROUTINE WILL PROCESS THE BILLING DETAILS FOR ALL SUB    *15160000
      *   ACCOUNTS WITHIN A GIVEN BILL NUMBER.                         *15170000
      ******************************************************************15220000
       2400-PROCESS-SUBS.                                               
      *                                                                 15250000
           MOVE AF-ACCT-XFER-FROM            TO BG-ACCOUNT-NO           
                                                S2-SUB-ACCOUNT-NO.      
           MOVE AF-BILL-NO-XFER-FROM         TO BG-BILL-NO.             
           MOVE WS-YES                       TO WS-MORE-BGS-SW.         
                                                                        
           PERFORM 2500-BUILD-RESULT-DETAIL   THRU 2500-EXIT.           
           PERFORM 7024-FETCH-XFER-ROW        THRU 7024-EXIT.           
      *                                                                 15250000
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15250000
      ******************************************************************        
      * 2500-BUILD-RESULT-DETAIL                                       *        
      *     OBTAINS THE BILLING DETAILS DATA.                          *        
      ***  THIS LOGIC IS THE SAME AS THE OLD S093 PROGRAM IS THAT               
      ***  REVENUE MONTH IS SAVED AFTER THE FIRST RETRIEVE OF                   
      ***  OF BILLING DETAIL.                                                   
      ******************************************************************        
       2500-BUILD-RESULT-DETAIL.                                        
      *                                                                         
           PERFORM 7030-OPEN-BG-CURSOR        THRU 7030-EXIT.           
           PERFORM 7040-FETCH-BG-ROW          THRU 7040-EXIT.           
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE        TO S2-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              PERFORM 2510-PROCESS-BG-CURSOR  THRU 2510-EXIT            
                UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                 
           ELSE                                                         
              MOVE 0                         TO WS-HOLD-REV-MM          
                                                S2-RETURN-CODE          
              MOVE WS-NO                     TO WS-CANCEL-REBILL        
           END-IF                                                       
                                                                        
           PERFORM 7050-CLOSE-BG-CURSOR       THRU 7050-EXIT.           
           PERFORM 2505-INIT-DETAIL-FIELDS    THRU 2505-EXIT.           
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2505-INIT-DETAIL-RETURN FIELDS                                 *        
      *   THIS ROUTINE WILL INITIALIZE ALL BILLING DETAIL COLUMNS               
      *   THAT ARE UNRELATED TO THE BILLING HEADER RECORDS TO BE                
      *   RETURNED.                                                             
      ******************************************************************        
       2505-INIT-DETAIL-FIELDS.                                         
      *                                                                         
           MOVE SPACES                       TO S2-DATE-READ            
                                                S2-RATE-DESC            
P00821                                          S2-UNMTR-PROV-FL        
P00899                                          S2-SECUR-RATE-FL        
                                                S2-OPTION-CD            
                                                S2-COMPANY-NO           
                                                S2-OPTION-DESC          
                                                S2-RATE-PLAN-NO         
P00821                                          S2-REVENUE-CLASS        
P00821                                          S2-PRTY-SVC-CAT-CD      
P00821                                          S2-CODE-BILL-CALC       
P00821                                          S2-DATE-ORIG-BILL       
                                                S2-CODE-UTIL-TYPE       
                                                S2-CODE-USAGE-TYPE      
                                                S2-CODE-BILL-ITM-IND    
                                                S2-BILL-ITEM-TIMESTMP.  
           MOVE 0                            TO S2-AMT-BILL-ITEM        
                                                S2-READ-UNITS           
                                                S2-AMT-TAXES            
                                                S2-NO-UNITS             
P00821                                          S2-REV-MTH-ORIG-BILL    
                                                S2-NO-DAYS              
                                                WS-BILL-NO              
                                                S2-IC-NO.               
      *                                                                         
       2505-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2510-PROCESS-BG-CURSOR                                         *        
      *                                                                *        
      *     OBTAINS THE BILLING DETAILS DATA.                          *        
      ******************************************************************        
       2510-PROCESS-BG-CURSOR.                                          
      *                                                                         
           MOVE BG-IC-NO                     TO CX-IC-NO                
                                                BZ-IC-NO                
                                                CP-IC-NO                
                                                UC-IC-NO                
                                                S2-IC-NO.               
           MOVE BG-BILL-NO                   TO CX-BILL-NO              
                                                BZ-BILL-NO              
                                                BP-BILL-NO              
                                                UC-BILL-NO.             
           MOVE BG-ACCOUNT-NO                TO CX-ACCOUNT-NO           
                                                BZ-ACCOUNT-NO           
                                                BP-ACCOUNT-NO           
                                                UC-ACCOUNT-NO           
                                                CP-ACCOUNT-NO           
                                                WS-ACCOUNT-NO.          
           MOVE BI-COMPANY-NO                TO S2-COMPANY-NO.          
           MOVE BG-CODE-UTIL-TYPE            TO CX-CODE-UTIL-TYPE       
                                                BZ-CODE-UTIL-TYPE       
                                                CP-CODE-UTIL-TYPE       
                                                UC-CODE-UTIL-TYPE       
                                                RD-CODE-UTIL-TYPE       
                                                S2-CODE-UTIL-TYPE.      
           MOVE BG-BILL-ITEM-TIMESTMP        TO CX-BILL-ITEM-TIMESTMP   
                                                BZ-BILL-ITEM-TIMESTMP   
                                                S2-BILL-ITEM-TIMESTMP   
                                                UC-BILL-ITEM-TIMESTMP.  
           MOVE BG-NO-OF-CONS-DAYS           TO S2-NO-DAYS.             
P00821     MOVE BG-REV-MTH-ORIG-BILL         TO S2-REV-MTH-ORIG-BILL.   
P00821     MOVE BG-DATE-ORIG-BILL            TO S2-DATE-ORIG-BILL.      
           MOVE BG-RATE-PLAN-NO              TO RD-RATE-PLAN-NO         
                                                S2-RATE-PLAN-NO.        
P00821     MOVE BG-CODE-BILL-CALC            TO S2-CODE-BILL-CALC.      
P00821     MOVE BG-CODE-REVENUE-CLASS        TO S2-REVENUE-CLASS.       
P00821                                                                  
P00821     IF BG-CODE-CURTAIL-PRTY > 0 THEN                             
P00821                                                                  
P00821        MOVE BG-CODE-CURTAIL-PRTY      TO Z4-CODE-CURTAIL-PRTY    
P00821        MOVE BI-COMPANY-NO             TO Z4-COMPANY-NO           
P00821                                                                  
P00821        PERFORM 7119-SELECT-SVC-CATEGORY  THRU 7119-EXIT          
P00821                                                                  
P00821        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
P00821           MOVE SPACES                 TO S2-PRTY-SVC-CAT-CD      
P00821        ELSE                                                      
P00821           MOVE Z4-PRTY-SVC-CAT-CD     TO S2-PRTY-SVC-CAT-CD      
P00821        END-IF                                                    
P00821     END-IF.                                                      
                                                                        
           IF MASTER-ACCOUNT                                            
              PERFORM 2515-GET-SUB-ACCT-ADDRESS                         
                                              THRU 2515-EXIT            
           END-IF.                                                      
                                                                        
           PERFORM 2520-PRCS-TOT-AMT-N-REV-MNTH                         
                                              THRU 2520-EXIT.           
P00821*    CHECK WHETHER THE RATE BELONGS TO INDUSTRIAL GAS OR NET-MTR          
P00821     INITIALIZE WS-REG-TYPE-CD                                    
P00821                WS-BAL-FWD-CD.                                    
P00821                                                                  
P00821     PERFORM 7240-CHECK-INDUS-CUST      THRU 7240-EXIT.           
P00821                                                                  
P00821     IF WS-REG-TYPE-CD = 'D'                                      
P00821        MOVE WS-YES                    TO WS-INDUST-GAS-CUST      
P00821                                          S2-INDUST-GAS-CUST      
P00821     ELSE                                                         
P00821        MOVE WS-NO                     TO WS-INDUST-GAS-CUST      
P00821                                          S2-INDUST-GAS-CUST      
P00821     END-IF.                                                      
P00821                                                                  
P00821     IF WS-BAL-FWD-CD > ' '                                       
P00821        MOVE WS-YES                    TO S2-NET-MTR-ACCOUNT      
P00821     ELSE                                                         
P00821        MOVE WS-NO                     TO S2-NET-MTR-ACCOUNT      
P00821     END-IF.                                                      
P00821                                                                  
P00821     MOVE 'N'                          TO S2-CIG-FLAG             
P00821     MOVE 'N'                          TO S2-EMC-FLAG             
P00821     IF S1-DATE-BILLED > SPACES                                   
P00821        IF WS-COBB-SNAPSHOAL = 'C' OR 'S'                         
P00821           IF WS-EMC-REV-MM  < WS-PARM-CUT-REV                    
P00821              MOVE 'Y'                 TO S2-EMC-FLAG             
P00821           END-IF                                                 
P00821        END-IF                                                    
P00821                                                                  
P00821        IF INDUST-GAS-CUST                                        
P00821           MOVE PROGRAM-NAME      TO WS-PGRMNAME                  
P00821           PERFORM 6251-GET-FJC01-DATE                            
P00821                                  THRU 6251-EXIT                  
P00821           IF WS-BILL-DATE < WS-CUT-OFF-DATE                      
P00821              MOVE 'Y'            TO S2-CIG-FLAG                  
P00821           END-IF                                                 
P00821        END-IF                                                    
P00821     END-IF.                                                      
                                                                        
           PERFORM 2530-SET-CODE-BILL-ITM-IND THRU 2530-EXIT.           
                                                                        
P00836** TAXES ARE REQUIRED FOR RESULT SET 1(HEADER)                            
P00836     PERFORM 2540-CALC-BG-TAXES         THRU 2540-EXIT.           
P00836*                                                                         
           IF I-INCLUDE-DETAIL-ROWS = WS-YES                            
              IF S2-CODE-BILL-ITM-IND  = 'R'                            
              AND I-INCLUDE-LATEST-BILL-ONLY = WS-YES                   
                 PERFORM 7205-CHK-REBILL-ROW  THRU 7205-EXIT            
                 IF BG-BILL-NO = WS-BILL-NO                             
                    SET NORMAL-BILL          TO TRUE                    
                 ELSE                                                   
                    SET CANCEL-BILL          TO TRUE                    
                 END-IF                                                 
              END-IF                                                    
                                                                        
              IF I-INCLUDE-LATEST-BILL-ONLY = WS-NO                     
              OR NORMAL-BILL                                            
P00899           IF CSR-DATABASE                                        
P00899              PERFORM 2532-CHCK-MULT-REG                          
P00899                                        THRU 2532-EXIT            
P00899           END-IF                                                 
                 IF SEB-DATABASE                                        
                    PERFORM 2535-GET-AGL-CHRG THRU 2535-EXIT            
P00821              PERFORM 2537-CHCK-BIL-ADJSTMNT-EXIST                
P00821                                        THRU 2537-EXIT            
                 END-IF                                                 
P00836*****      PERFORM 2540-CALC-BG-TAXES   THRU 2540-EXIT                    
                 PERFORM 2545-SELECT-RT-DESC  THRU 2545-EXIT            
                 PERFORM 2550-FETCH-CNSMPTN-DETAILS                     
                                              THRU 2550-EXIT            
              END-IF                                                    
           END-IF.                                                      
           PERFORM 7040-FETCH-BG-ROW          THRU 7040-EXIT.           
      *                                                                         
       2510-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2515-GET-SUB-ACCT-ADDRESS.                                     *        
      *     OBTAINS AND SENDS THE SUB ACCOUNT SERVICE ADDRESS.         *        
      ******************************************************************        
       2515-GET-SUB-ACCT-ADDRESS.                                       
      *                                                                 18110900
           MOVE SPACES                       TO S2-SUB-ACCT-SERV-ADDR.  
           MOVE AF-ACCT-XFER-FROM            TO HT-ACCOUNT-NO.          
                                                                        
           PERFORM 7290-SELECT-ADDR-ID        THRU 7290-EXIT.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              PERFORM 7300-SELECT-DY          THRU 7300-EXIT            
           END-IF.                                                      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE DY-HOUSE-NO               TO WS-HOUSE-NO             
              MOVE DY-ADDR-PREFIX-1          TO WS-ADDR-PREFIX-1        
              MOVE DY-ADDR-PREFIX-2          TO WS-ADDR-PREFIX-2        
              MOVE DY-STREET-NAME            TO WS-STREET-NAME          
              MOVE DY-STREET-LOCATION-1      TO WS-STREET-LOCATION-1    
              MOVE DY-STREET-LOCATION-2      TO WS-STREET-LOCATION-2    
              MOVE DY-STREET-SUFFIX          TO WS-STREET-SUFFIX        
              MOVE DY-ZIP-CODE               TO WS-ZIP-CODE             
           ELSE                                                         
              MOVE SPACES                    TO WS-HOUSE-NO             
                                                WS-ADDR-PREFIX-1        
                                                WS-ADDR-PREFIX-2        
                                                WS-STREET-NAME          
                                                WS-STREET-LOCATION-1    
                                                WS-STREET-LOCATION-2    
                                                WS-STREET-SUFFIX        
                                                WS-ZIP-CODE             
           END-IF.                                                      
           MOVE WS-SERV-ADDR                 TO WS-EMB-INPUT.           
           MOVE 81                           TO WS-EMB-LENG.            
           MOVE SPACES                       TO WS-CMP-TABLE.           
                                                                        
           PERFORM 6010-REDUCE-EMBEDDED-SPACES                          
                                              THRU 6010-EXIT.           
           MOVE WS-CMP-TABLE                 TO S2-SUB-ACCT-SERV-ADDR.  
      *                                                                         
       2515-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2520-PRCS-TOT-AMT-N-REV-MNTH.                                  *        
      *     OBTAINS AND SENDS THE UNMETERD CONSUMPTION DATA            *        
      ******************************************************************        
       2520-PRCS-TOT-AMT-N-REV-MNTH.                                    
      *                                                                         
           MOVE ZERO                         TO S2-REVENUE-MONTH.       
                                                                        
           IF BG-REVENUE-MONTH > WS-HOLD-REV-MM                         
              MOVE BG-REVENUE-MONTH          TO WS-HOLD-REV-MM          
           END-IF.                                                      
                                                                        
           MOVE WS-HOLD-REV-MM               TO S2-REVENUE-MONTH.       
P00821     MOVE WS-HOLD-REV-MM               TO WS-HOLD-REV-MM-CHAR.    
P00821     MOVE WS-HOLD-REV-MM-CHAR          TO WS-EMC-REV-MM.          
                                                                        
                                                                        
           IF BG-CODE-DR-CR-CNSMPTN = 'C'                               
              SUBTRACT BG-AMT-BILL-ITEM    FROM WS-TOTAL-BG-DOLLARS     
           ELSE                                                         
              ADD BG-AMT-BILL-ITEM           TO WS-TOTAL-BG-DOLLARS     
           END-IF.                                                      
P00836*                                                                         
P00836     MOVE 0                            TO WS-TEMP-UTIL-CHARGES.   
P00836     COMPUTE WS-TEMP-UTIL-CHARGES = BG-AMT-BILL-ITEM -            
P00836           BG-AMT-STATE-TAX - BG-AMT-CITY-TAX - BG-AMT-OTHER-TAX  
P00836     END-COMPUTE.                                                 
P00836     IF BG-CODE-DR-CR-CNSMPTN = 'C'                               
P00836        COMPUTE WS-TEMP-UTIL-CHARGES = WS-TEMP-UTIL-CHARGES * -1  
P00836        END-COMPUTE                                               
P00836     END-IF.                                                      
P00836*                                                                         
P00836     EVALUATE BG-CODE-UTIL-TYPE                                   
P00836       WHEN 'E'                                                   
P00836         COMPUTE WS-TOTAL-ELEC-CHARGES  =                         
P00836                 WS-TOTAL-ELEC-CHARGES  + WS-TEMP-UTIL-CHARGES    
P00836         END-COMPUTE                                              
P00836       WHEN 'G'                                                   
P00836         COMPUTE WS-TOTAL-GAS-CHARGES   =                         
P00836                 WS-TOTAL-GAS-CHARGES   + WS-TEMP-UTIL-CHARGES    
P00836         END-COMPUTE                                              
P00836       WHEN 'U'                                                   
P00836         COMPUTE WS-TOTAL-UNMTR-CHARGES =                         
P00836                 WS-TOTAL-UNMTR-CHARGES + WS-TEMP-UTIL-CHARGES    
P00836         END-COMPUTE                                              
P00836     END-EVALUATE.                                                
      *                                                                         
       2520-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2530-SET-CODE-BILL-ITM-IND.                                    *        
      *     OBTAINS AND SENDS THE UNMETERD CONSUMPTION DATA            *        
      ******************************************************************        
       2530-SET-CODE-BILL-ITM-IND.                                      
      *                                                                         
           IF BG-DATE-ORIG-BILL GREATER SPACES                          
              IF BG-CODE-BILL-ITM-TYPE = 'B'                            
                 MOVE 'B'                    TO S2-CODE-BILL-ITM-IND    
              ELSE                                                      
                 IF BG-CODE-BILL-ITM-TYPE = 'C'                         
                    IF BG-CODE-BILL-ITM-IND = 'K'                       
                       MOVE 'C'              TO S2-CODE-BILL-ITM-IND    
                    ELSE                                                
                       MOVE 'R'              TO S2-CODE-BILL-ITM-IND    
                    END-IF                                              
                 ELSE                                                   
                    MOVE 'U'                 TO S2-CODE-BILL-ITM-IND    
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF BG-DATE-ORIG-BILL EQUAL SPACES                            
              IF BG-CODE-BILL-ITM-TYPE = 'C' AND                        
                 BG-CODE-BILL-ITM-IND = 'J' OR 'K'                      
                 MOVE 'C'                    TO S2-CODE-BILL-ITM-IND    
              ELSE                                                      
                 IF BG-CODE-BILL-ITM-TYPE = 'C' AND                     
                    BG-CODE-BILL-ITM-IND = 'A' OR 'S' OR 'T'            
                    MOVE BG-CODE-BILL-ITM-IND                           
                                             TO S2-CODE-BILL-ITM-IND    
                 ELSE                                                   
                    MOVE 'U'                 TO S2-CODE-BILL-ITM-IND    
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF S2-CODE-BILL-ITM-IND = 'B' OR 'C'                         
              SET CANCEL-BILL                TO TRUE                    
           ELSE                                                         
              SET NORMAL-BILL                TO TRUE                    
           END-IF.                                                      
      *                                                                         
       2530-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P00899****************************************************************          
P00899* CHECK ENTRY IN REGISTER-READ TABLE FOR CSR ACCOUNTS.                    
P00899****************************************************************          
P00899 2532-CHCK-MULT-REG.                                              
P00899                                                                  
P00899     SET WS-IC-INDX                    TO 1                       
P00899     SEARCH WS-IC-DTLS-DATA                                       
P00899        AT END                                                    
P00899        PERFORM 7245-CHECK-IC-REGISTER  THRU 7245-EXIT            
P00899        MOVE WS-MULT-REG-FLG           TO S2-MULT-REGISTER-FLG    
P00899     WHEN WS-UTIL-TYPE(WS-IC-INDX) = BG-CODE-UTIL-TYPE            
P00899          AND WS-IC-NO(WS-IC-INDX) = BG-IC-NO                     
P00899          MOVE WS-MULT-REG-FL(WS-IC-INDX)                         
P00899                                       TO S2-MULT-REGISTER-FLG    
P00899     END-SEARCH.                                                  
P00899*                                                                         
P00899 2532-EXIT.                                                       
P00899      EXIT.                                                       
P00899*                                                                         
      ******************************************************************        
      * 2535-GET-AGL-CHRG.                                             *        
      *     OBTAINS AND SENDS THE METERED CONSUMPTION DATA             *        
      ******************************************************************        
       2535-GET-AGL-CHRG.                                               
      *                                                                         
           MOVE ZEROES                       TO WS-AGL-DEBIT            
                                                WS-AGL-CREDIT           
                                                S2-AGL-CHARGE.          
           PERFORM 7207-AGL-DEBIT             THRU 7207-EXIT.           
           PERFORM 7209-AGL-CREDIT            THRU 7209-EXIT.           
                                                                        
           COMPUTE S2-AGL-CHARGE = WS-AGL-DEBIT - WS-AGL-CREDIT.        
      *                                                                         
       2535-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P00821******************************************************************        
P00821* 2537-CHCK-BIL-ADJSTMNT-EXIST.                                  *        
P00821*     CHECK IF BILL ADJUSTMENT EXISTCONSUMPTION DATA             *        
P00821******************************************************************        
P00821 2537-CHCK-BIL-ADJSTMNT-EXIST.                                    
P00821*                                                                         
P00821     PERFORM 7310-CHECK-BILL-ADJUSTMNT  THRU 7310-EXIT.           
P00821                                                                  
P00821     MOVE WS-BILL-ADJ-EXIST            TO S1-BILL-ADJ-FLAG.       
P00821*                                                                         
P00821 2537-EXIT.                                                       
P00821     EXIT.                                                        
P00821*                                                                         
      ****************************************************************          
      * THIS PROCESS HAS BEEN ADDED TO RATIONALISE TAX CALCULATION              
      * SO THAT IT IS DONE JUST AT ONE POINT OF TIME DURING PROCESSING.         
      * - M ROUTH 7/17/96                                                       
      ****************************************************************          
       2540-CALC-BG-TAXES.                                              
      *                                                                         
           MOVE ZEROES                       TO WS-AMT-TAXES            
                                                S2-AMT-TAXES.           
           ADD BG-AMT-STATE-TAX                                         
               BG-AMT-CITY-TAX                                          
               BG-AMT-OTHER-TAX              TO WS-AMT-TAXES.           
                                                                        
           IF WS-AMT-TAXES NOT = ZEROES                                 
              MOVE WS-AMT-TAXES              TO S2-AMT-TAXES            
           END-IF.                                                      
                                                                        
           IF BG-CODE-DR-CR-CNSMPTN = 'C'                               
              COMPUTE S2-AMT-TAXES = S2-AMT-TAXES * -1                  
           END-IF.                                                      
P00836*                                                                         
P00836     COMPUTE WS-TOTAL-TAXES = WS-TOTAL-TAXES + S2-AMT-TAXES       
P00836     END-COMPUTE.                                                 
      *                                                                         
       2540-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ****************************************************************          
      * SELECT RATE DESC FOR CSR ACCOUNS. OPTION DESC FOR SEB ACCTS             
      ****************************************************************          
       2545-SELECT-RT-DESC.                                             
                                                                        
           SET WS-RATE-INDX                  TO 1                       
           SEARCH WS-RATE-DESC-DATA                                     
              AT END                                                    
              PERFORM 2546-GET-RATE-DESC      THRU 2546-EXIT            
              MOVE RD-RATE-DESC              TO S2-RATE-DESC            
P00821        MOVE RD-UNMTR-PROV-FL          TO S2-UNMTR-PROV-FL        
P00899        MOVE RD-SECURED-RATE-FL        TO S2-SECUR-RATE-FL        
           WHEN WS-RATE-PLAN-NO(WS-RATE-INDX)   = RD-RATE-PLAN-NO       
            AND WS-UTIL-TYPE-CODE(WS-RATE-INDX) = RD-CODE-UTIL-TYPE     
                MOVE WS-RATE-DESC(WS-RATE-INDX)                         
                                             TO S2-RATE-DESC            
P00821          MOVE WS-UNMTR-PROV-FL(WS-RATE-INDX)                     
P00821                                       TO S2-UNMTR-PROV-FL        
P00899          MOVE WS-SECUR-RATE-FL(WS-RATE-INDX)                     
P00899                                       TO S2-SECUR-RATE-FL        
           END-SEARCH.                                                  
                                                                        
           MOVE SPACES                       TO S2-OPTION-CD.           
           IF SEB-DATABASE                                              
              IF BG-RT-PKG-OPT-SEQ-NO > 0                               
                 MOVE BG-ACCOUNT-NO          TO DF-ACCOUNT-NO           
                 MOVE BG-CODE-UTIL-TYPE      TO DF-CODE-UTIL-TYPE       
                 MOVE BG-IC-NO               TO DF-IC-NO                
                 MOVE BG-RT-PKG-OPT-SEQ-NO   TO DF-RT-PKG-OPT-SEQ-NO    
                 IF DF-RT-PKG-OPT-SEQ-NO NOT EQUAL WS-PREV-RT-PKG-SEQ-NO
                    PERFORM 7260-GET-OPTION-DESC                        
                                              THRU 7260-EXIT            
                    MOVE DF-RT-PKG-OPT-SEQ-NO                           
                                             TO WS-PREV-RT-PKG-SEQ-NO   
                 END-IF                                                 
              ELSE                                                      
                 MOVE BG-ACCOUNT-NO          TO UT-ACCOUNT-NO           
                 MOVE BG-CODE-UTIL-TYPE      TO UT-CODE-UTIL-TYPE       
                 MOVE BG-IC-NO               TO UT-IC-NO                
                 PERFORM 7265-GET-OPTION-DESC THRU 7265-EXIT            
              END-IF                                                    
              MOVE FI-OPT-DESC-INT           TO S2-OPTION-DESC          
              MOVE FI-OPTION-CD              TO S2-OPTION-CD            
           END-IF.                                                      
      *                                                                         
       2545-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ****************************************************************          
      * 2546-GET-RATE-DESC.                                          *          
      ****************************************************************          
       2546-GET-RATE-DESC.                                              
                                                                        
           PERFORM 7250-SELECT-RATE-DESC      THRU 7250-EXIT            
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
              ADD +1                         TO WS-INDX-COUNT           
              SET WS-RATE-INDX               TO WS-INDX-COUNT           
              MOVE RD-CODE-UTIL-TYPE         TO                         
                                         WS-UTIL-TYPE-CODE(WS-RATE-INDX)
              MOVE RD-RATE-PLAN-NO           TO                         
                                         WS-RATE-PLAN-NO(WS-RATE-INDX)  
              MOVE RD-RATE-DESC              TO                         
                                         WS-RATE-DESC(WS-RATE-INDX)     
P00821        MOVE RD-UNMTR-PROV-FL          TO                         
P00821                                   WS-UNMTR-PROV-FL(WS-RATE-INDX) 
P00899        MOVE RD-SECURED-RATE-FL        TO                         
P00899                                   WS-SECUR-RATE-FL(WS-RATE-INDX) 
           END-IF.                                                      
      *                                                                         
       2546-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2550-FETCH-CNSMPTN-DETAILS.                                    *        
      *     OBTAINS AND SENDS THE UNMETERD CONSUMPTION DATA            *        
      ******************************************************************        
       2550-FETCH-CNSMPTN-DETAILS.                                      
      *                                                                         
           MOVE ZEROES                       TO S2-NO-UNITS             
                                                S2-READ-UNITS           
                                                S2-AMT-BILL-ITEM        
                                                WS-ACCUM-UNITS-TP       
                                                WS-ACCUM-NO-UNITS       
                                                WS-ACCUM-READ-UNITS.    
           MOVE SPACES                       TO S2-DATE-READ            
                                                WS-REG-TYPE-CD          
                                                S2-CODE-USAGE-TYPE.     
           IF BG-CODE-UTIL-TYPE EQUAL 'U'                               
              PERFORM 2555-UNMETERED-CNSMPTN  THRU 2555-EXIT            
           ELSE                                                         
              PERFORM 7200-CUST-PLAN-EXISTS   THRU 7200-EXIT            
              IF WS-UNMTRD-ELEC-GAS = WS-YES                            
                 PERFORM 2555-UNMETERED-CNSMPTN                         
                                              THRU 2555-EXIT            
              ELSE                                                      
                 MOVE WS-NO                  TO WS-UNMTRD-ELEC-GAS      
                 PERFORM 2570-METERED-CNSMPTN THRU 2570-EXIT            
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2550-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2555-UNMETERED-CNSMPTN                                         *        
      *     OBTAINS AND SENDS THE UNMETERD CONSUMPTION DATA            *        
      ******************************************************************        
       2555-UNMETERED-CNSMPTN.                                          
      *                                                                         
           PERFORM 7090-OPEN-UC-CURSOR        THRU 7090-EXIT.           
           PERFORM 7100-FETCH-UC-ROW          THRU 7100-EXIT.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE SPACES                    TO S2-DATE-READ            
              MOVE 'U'                       TO S2-CODE-USAGE-TYPE      
                                                                        
              PERFORM 2560-PROCESS-UC-CURSOR  THRU 2560-EXIT            
                UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                 
           ELSE                                                         
              MOVE SPACES                    TO S2-DATE-READ            
                                                S2-CODE-USAGE-TYPE      
              MOVE ZEROES                    TO S2-NO-UNITS             
              MOVE ZEROES                    TO S2-AMT-BILL-ITEM        
              MOVE ZEROES                    TO S2-READ-UNITS           
           END-IF.                                                      
                                                                        
           PERFORM 7110-CLOSE-UC-CURSOR       THRU 7110-EXIT.           
                                                                        
           PERFORM 7060-OPEN-BZ-CURSOR        THRU 7060-EXIT.           
           PERFORM 7070-FETCH-BZ-ROW          THRU 7070-EXIT.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              PERFORM 2565-PROC-BZ-UNMETERED  THRU 2565-EXIT            
                UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                 
           ELSE                                                         
              MOVE SPACES                    TO S2-CODE-USAGE-TYPE      
              COMPUTE S2-AMT-BILL-ITEM =                                
                      BG-AMT-BILL-ITEM - WS-AMT-TAXES                   
              IF BG-CODE-DR-CR-CNSMPTN = 'C'                            
                 COMPUTE S2-AMT-BILL-ITEM = S2-AMT-BILL-ITEM * -1       
              END-IF                                                    
              PERFORM 8110-INSERT-GTT-R2      THRU 8110-EXIT            
              MOVE ZEROES                    TO WS-AMT-TAXES            
                                                S2-AMT-TAXES            
           END-IF.                                                      
                                                                        
           PERFORM 7080-CLOSE-BZ-CURSOR      THRU 7080-EXIT.            
      *                                                                         
       2555-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *2560-PROCESS-UC-CURSOR.                                                  
      ****************************************************************          
       2560-PROCESS-UC-CURSOR.                                          
                                                                        
      *NO NEED TO SEND READ DATE FOR UNMETERED ROWS. SO COMMENTING THIS         
      *    IF UC-DATE-USAGE-ENDS    > S2-DATE-READ                              
      *       AND WS-NULL-IND-7 NOT < ZERO                                      
      *       MOVE UC-DATE-USAGE-ENDS        TO S2-DATE-READ                    
      *    END-IF.                                                              
      *                                                                         
           IF UC-CODE-DEBIT-CREDIT = 'C'                                
              SUBTRACT UC-NO-UNITS           FROM S2-NO-UNITS           
              SUBTRACT UC-NO-UNITS           FROM S2-READ-UNITS         
           ELSE                                                         
              ADD UC-NO-UNITS                TO   S2-NO-UNITS           
              ADD UC-NO-UNITS                TO   S2-READ-UNITS         
           END-IF.                                                      
                                                                        
           PERFORM 7100-FETCH-UC-ROW          THRU 7100-EXIT.           
      *                                                                         
       2560-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *2565-PROC-BZ-UNMETERED.                                                  
      ****************************************************************          
       2565-PROC-BZ-UNMETERED.                                          
                                                                        
           IF BZ-BILLED-COMP-AM NOT NUMERIC                             
              MOVE ZEROES                    TO BZ-BILLED-COMP-AM       
           END-IF.                                                      
                                                                        
           ADD BZ-BILLED-COMP-AM             TO S2-AMT-BILL-ITEM.       
                                                                        
           PERFORM 7070-FETCH-BZ-ROW          THRU 7070-EXIT.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              PERFORM 8110-INSERT-GTT-R2      THRU 8110-EXIT            
              MOVE ZEROES                    TO WS-AMT-TAXES            
                                                S2-AMT-TAXES            
              MOVE NOT-FOUND                 TO WS-ACTIVE-RETURN-CODE   
           END-IF.                                                      
      *                                                                         
       2565-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2570-METERED-CNSMPTN                                           *        
      *     OBTAINES AND SENDS THE METERD CONSUMPTION DATA.            *        
      ******************************************************************        
       2570-METERED-CNSMPTN.                                            
      *                                                                         
           PERFORM 2575-PROCESS-CX-CURSOR     THRU 2575-EXIT.           
           PERFORM 2585-PROCESS-BZ-CURSOR     THRU 2585-EXIT.           
      *                                                                         
       2570-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2575-PROCESS-CX-CURSOR.                                        *        
      ******************************************************************        
       2575-PROCESS-CX-CURSOR.                                          
      *                                                                         
           PERFORM 7120-OPEN-CX-CURSOR        THRU 7120-EXIT.           
           PERFORM 7130-FETCH-CX-ROW          THRU 7130-EXIT.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE CX-REG-ID-NO              TO WS-REG-ID-COMP          
              MOVE CX-MTR-REF-NO             TO WS-MTR-REF-COMP         
              MOVE CX-CODE-TIME-PERIOD       TO WS-TP-COMP              
              MOVE CX-CODE-ITEM-STATUS       TO WS-CODE-ITEM-STATUS     
              MOVE CX-DATE-READ              TO S2-DATE-READ            
              MOVE SPACES                    TO WS-DATE-READ-COMPARE    
              MOVE ZEROES                    TO WS-ACCUM-NO-UNITS       
                                                WS-ACCUM-NO-KVA         
                                                WS-ACCUM-NO-DAYS        
                                                WS-ACCUM-UNITS-TP       
                                                WS-ACCUM-READ-UNITS     
              PERFORM 2580-ACCUM-NO-DAYS      THRU 2580-EXIT            
              UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                   
              IF S2-NO-DAYS = 0                                         
                 MOVE WS-ACCUM-NO-DAYS       TO S2-NO-DAYS              
                                                WS-NO-DAYS              
              ELSE                                                      
                 MOVE S2-NO-DAYS             TO WS-NO-DAYS              
              END-IF                                                    
           ELSE                                                         
              IF BG-REV-RPT-CD = 'T' AND                                
                 WS-INDUST-GAS-CUST = WS-YES                            
                 IF S1-DATE-BILLED EQUAL SPACES                         
                    MOVE ZEROES              TO S2-NO-UNITS             
                                                S2-READ-UNITS           
                 END-IF                                                 
                 MOVE WS-NO-DAYS             TO S2-NO-DAYS              
              END-IF                                                    
              MOVE SPACES                    TO S2-DATE-READ            
              MOVE SPACES                    TO S2-CODE-USAGE-TYPE      
                                                WS-CODE-ITEM-STATUS     
           END-IF.                                                      
           PERFORM 7140-CLOSE-CX-CURSOR       THRU 7140-EXIT.           
      *                                                                         
       2575-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *2580-ACCUM-NO-DAYS.                                                      
      ****************************************************************          
       2580-ACCUM-NO-DAYS.                                              
      *                                                                         
           IF (CX-CODE-USAGE-TYPE = 'B' OR 'C')                         
              AND CX-MTR-REF-NO    = WS-MTR-REF-COMP                    
              AND CX-CODE-TIME-PERIOD = 0                               
              AND CX-CODE-DEBIT-CREDIT = 'D'                            
              ADD CX-NO-DAYS                 TO WS-ACCUM-NO-DAYS        
              MOVE CX-MTR-REF-NO             TO WS-MTR-REF-COMP         
           END-IF.                                                      
                                                                        
           IF (CX-CODE-USAGE-TYPE = 'B' OR 'C')                         
             AND CX-CODE-TIME-PERIOD = 0                                
             IF CX-CODE-DEBIT-CREDIT = 'C'                              
                SUBTRACT CX-NO-UNITS         FROM WS-ACCUM-NO-UNITS     
             ELSE                                                       
                ADD CX-NO-UNITS              TO WS-ACCUM-NO-UNITS       
             END-IF                                                     
           END-IF.                                                      
                                                                        
           IF CX-CODE-USAGE-TYPE = 'B'                                  
             AND CX-CODE-TIME-PERIOD > 0                                
             AND CX-CODE-TOU-SEASN   = 'C'                              
               ADD CX-NO-UNITS               TO WS-ACCUM-UNITS-TP       
           END-IF.                                                      
                                                                        
           IF ((CX-CODE-USAGE-TYPE = 'E' OR 'J')                        
             AND CX-DATE-READ NOT = WS-DATE-READ-COMPARE)               
             AND CX-MTR-REF-NO    = WS-MTR-REF-COMP                     
             AND CX-REG-ID-NO     = WS-REG-ID-COMP                      
             AND CX-CODE-TIME-PERIOD = WS-TP-COMP                       
              MOVE CX-NO-DEMAND-UNITS        TO WS-ACCUM-NO-KVA         
              MOVE CX-DATE-READ              TO WS-DATE-READ-COMPARE    
              MOVE CX-MTR-REF-NO             TO WS-MTR-REF-COMP         
              MOVE CX-REG-ID-NO              TO WS-REG-ID-COMP          
              MOVE CX-CODE-TIME-PERIOD       TO WS-TP-COMP              
           END-IF.                                                      
                                                                        
           PERFORM 7130-FETCH-CX-ROW          THRU  7130-EXIT.          
      *                                                                         
       2580-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2585-PROCESS-BZ-CURSOR.                                        *        
      ******************************************************************        
       2585-PROCESS-BZ-CURSOR.                                          
      *                                                                         
           PERFORM 7060-OPEN-BZ-CURSOR        THRU 7060-EXIT.           
           PERFORM 7070-FETCH-BZ-ROW          THRU 7070-EXIT.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE BZ-CONSUMPT-TYPE-CD       TO S2-CODE-USAGE-TYPE      
              PERFORM 2590-PROCESS-BZ-CURSOR  THRU 2590-EXIT            
                UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                 
           ELSE                                                         
              MOVE WS-ACCUM-READ-UNITS       TO S2-READ-UNITS           
              IF WS-ACCUM-UNITS-TP > 0                                  
                MOVE WS-ACCUM-UNITS-TP       TO S2-NO-UNITS             
              ELSE                                                      
                MOVE WS-ACCUM-NO-UNITS       TO S2-NO-UNITS             
              END-IF                                                    
                                                                        
              IF S2-CODE-UTIL-TYPE = 'E'                                
                 MOVE 'B'                    TO S2-CODE-USAGE-TYPE      
              ELSE                                                      
                 IF S2-CODE-UTIL-TYPE = 'G'                             
                    MOVE 'T'                 TO S2-CODE-USAGE-TYPE      
                 END-IF                                                 
              END-IF                                                    
                                                                        
              COMPUTE S2-AMT-BILL-ITEM =                                
                     (BG-AMT-BILL-ITEM - WS-AMT-TAXES)                  
                                                                        
              IF BG-CODE-DR-CR-CNSMPTN = 'C'                            
                 COMPUTE S2-AMT-BILL-ITEM = S2-AMT-BILL-ITEM * -1       
              END-IF                                                    
                                                                        
              IF BG-CODE-BILL-ITM-TYPE = 'B'                            
                 AND BG-DATE-ORIG-BILL  NOT = SPACES                    
                 PERFORM 7230-GET-BILL-UNITS  THRU 7230-EXIT            
                 MOVE WS-ACCUM-NO-UNITS      TO S2-NO-UNITS             
                 MOVE WS-ACCUM-READ-UNITS    TO S2-READ-UNITS           
                 IF S2-CODE-UTIL-TYPE = 'E'                             
                    MOVE 'B'                 TO S2-CODE-USAGE-TYPE      
                 ELSE                                                   
                    IF S2-CODE-UTIL-TYPE = 'G'                          
                       MOVE 'C'              TO S2-CODE-USAGE-TYPE      
                       IF WS-INDUST-GAS-CUST = WS-YES                   
                          MOVE 'D'           TO S2-CODE-USAGE-TYPE      
                       END-IF                                           
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
                                                                        
              PERFORM 8110-INSERT-GTT-R2      THRU 8110-EXIT            
              MOVE ZEROES                    TO WS-AMT-TAXES            
                                                S2-AMT-TAXES            
           END-IF.                                                      
           PERFORM 7080-CLOSE-BZ-CURSOR       THRU 7080-EXIT.           
      *                                                                         
       2585-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2590-PROCESS-BZ-CURSOR                                         *        
      *                                                                *        
      *     OBTAINES AND SENDS THE METERD CONSUMPTION DATA.            *        
      ******************************************************************        
       2590-PROCESS-BZ-CURSOR.                                          
      *                                                                         
           IF BZ-BILL-UNITS NOT NUMERIC                                 
              MOVE ZEROES                    TO BZ-BILL-UNITS           
           END-IF.                                                      
                                                                        
           IF BZ-READ-UNITS NOT NUMERIC                                 
              MOVE ZEROES                    TO BZ-READ-UNITS           
           END-IF.                                                      
                                                                        
           IF BZ-BILLED-COMP-AM NOT NUMERIC                             
              MOVE ZEROES                    TO BZ-BILLED-COMP-AM       
           END-IF.                                                      
                                                                        
           IF S2-CODE-USAGE-TYPE = BZ-CONSUMPT-TYPE-CD                  
              IF(BZ-CMPNT-ID-CD NOT EQUAL '70' AND                      
                 BZ-CMPNT-ID-CD NOT EQUAL '71')                         
                 ADD BZ-BILL-UNITS           TO S2-NO-UNITS             
                 ADD BZ-READ-UNITS           TO S2-READ-UNITS           
              END-IF                                                    
              ADD BZ-BILLED-COMP-AM          TO S2-AMT-BILL-ITEM        
           ELSE                                                         
              PERFORM 8110-INSERT-GTT-R2      THRU 8110-EXIT            
              MOVE ZEROES                    TO WS-AMT-TAXES            
                                                S2-AMT-TAXES            
              MOVE BZ-CONSUMPT-TYPE-CD       TO S2-CODE-USAGE-TYPE      
              MOVE BZ-BILL-UNITS             TO S2-NO-UNITS             
              MOVE BZ-READ-UNITS             TO S2-READ-UNITS           
              MOVE BZ-BILLED-COMP-AM         TO S2-AMT-BILL-ITEM        
           END-IF.                                                      
                                                                        
           PERFORM 7070-FETCH-BZ-ROW          THRU 7070-EXIT.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL  NOT-FOUND                   
              PERFORM 8110-INSERT-GTT-R2      THRU 8110-EXIT            
              MOVE ZEROES                    TO WS-AMT-TAXES            
                                                S2-AMT-TAXES            
              MOVE NOT-FOUND                 TO WS-ACTIVE-RETURN-CODE   
           END-IF.                                                      
      *                                                                         
       2590-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *SUPPORTS ADDRESS FORMAT                                                  
      ******************************************************************        
           COPY CPD00004.                                                       
                                                                        
P00821******************************************************************PCS03730
P00821* 6251-GET-FJC01-DATE                                            *        
P00821*     CALLS 7600-START-FCSJC01                                   *        
P00821*           7610-READ-FCSJC01                                    *        
P00821*           7611-CLOSE                                           *        
P00821*           9000-SEND-ERROR-RESULT                               *        
P00821*           9900-SQL-ERROR-ROUTINE                               *        
P00821*                                                                *        
P00821******************************************************************PCS03730
P00821 6251-GET-FJC01-DATE.                                             
P00821*                                                                         
P00821     MOVE  WS-PGRMNAME TO WS-PROGRAM.                             
P00821     MOVE  WS-DATE     TO WS-COMMAND.                             
P00821     MOVE  ZEROS       TO WS-SEQUENCE.                            
P00821     MOVE  SPACES      TO WS-SYSIPT.                              
P00821     MOVE  WS-KEY-AREA TO E-FJC01-KEY.                            
P00821                                                                  
P00821     MOVE WS-PROGRAM    TO G6-PROGRAM-NAME.                       
P00821     MOVE WS-COMMAND    TO G6-CMND-CODE.                          
P00821                                                                  
P00821     IF INDUST-GAS-CUST                                           
P00821        MOVE WS-CIG     TO G6-COMPANY-NO                          
P00821     ELSE                                                         
P00821        MOVE WS-PSNC    TO G6-COMPANY-NO                          
P00821     END-IF.                                                      
P00821                                                                  
P00821     PERFORM 7600-START-FCSJC01  THRU  7600-FCSJC01-EXIT.         
P00821     PERFORM 7610-READ-FCSJC01   THRU  7610-FCSJC01-EXIT          
P00821         UNTIL CUT-OFF-DATE OR END-OF-SYSIPT.                     
P00821*                                                                         
P00821     IF NOT END-OF-SYSIPT                                         
P00821              AND WS-INPUT-CUT-DATE-MM  NUMERIC                   
P00821              AND WS-INPUT-CUT-DATE-DD  NUMERIC                   
P00821              AND WS-INPUT-CUT-DATE-CC  NUMERIC                   
P00821              AND WS-INPUT-CUT-DATE-YY  NUMERIC                   
P00821         PERFORM 7611-CLOSE THRU 7611-EXIT                        
P00821         MOVE  WS-INPUT-CUT-DATE   TO    WS-CUT-OFF-DATE          
P00821     END-IF.                                                      
P00821*                                                                         
P00821 6251-EXIT.                                                       
P00821     EXIT.                                                        
P00821*                                                                         
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO OPEN THE CURSOR USED TO FETCH     **        
      **  ROWS FROM THE CSS_BILLING_HDR TABLE.                        **        
      ******************************************************************        
       7000-OPEN-BI-CURSOR.                                             
      *                                                                         
           EXEC SQL                                                     
               OPEN BI-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE '7000'                   TO ACTIVE-PARAGRAPH        
               MOVE 'OPEN'                   TO ABEND-FUNCTION          
               MOVE SPACES                   TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
               MOVE 'CSS_BILLING_HDR  '      TO TABLE-1                 
               MOVE 'ACCOUNT_NO  '           TO TABLE-ELEMENT-1         
               MOVE BI-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1       
               PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO OBTAIN THE NEXT ROW FROM THE      **        
      **  CSS_BILLING_HDR TABLE WHERE THE ACCOUNT NUMBER IS EQUAL TO  **        
      **  THE ACCOUNT NUMBER PASSED TO THIS PROGRAM VIA THE           **        
      **  COMMUNICATION AREA ACCOUNT NUMBER.                          **        
      ******************************************************************        
       7010-FETCH-BI-ROW.                                               
      *                                                                         
           EXEC SQL                                                     
               FETCH BI-CURSOR                                          
                INTO :BI-BILL-NO                                        
                    ,:BI-DATE-BILLED :WS-NULL-IND-HEADER                
                    ,:BI-CODE-BILL-TYPE                                 
                    ,:BI-CODE-BILL-STATUS                               
                    ,:BI-TOT-OTHER-CHARGES                              
                    ,:BI-TOTAL-ARREARS                                  
                    ,:BI-COMPANY-NO                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE     = SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-NULL-IND-HEADER < 0                                 
                 MOVE SPACES                 TO BI-DATE-BILLED          
              END-IF                                                    
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE BI-DATE-BILLED         TO WS-PREV-BILL-DATE       
              ELSE                                                      
                 MOVE WS-YES                 TO END-OF-BI-SW            
                 MOVE SPACES                 TO WS-PREV-BILL-DATE       
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7010'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_BILLING_HDR  '       TO TABLE-1                 
              MOVE 'ACCOUNT_NO  '            TO TABLE-ELEMENT-1         
              MOVE BI-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO CLOSE THE CURSOR USED TO FETCH    **        
      **  ROWS FROM THE CSS_BILLING_HDR TABLE.                        **        
      ******************************************************************        
       7020-CLOSE-BI-CURSOR.                                            
      *                                                                         
           EXEC SQL                                                     
               CLOSE BI-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7020'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_BILLING_HDR  '       TO TABLE-1                 
              MOVE 'ACCOUNT_NO  '            TO TABLE-ELEMENT-1         
              MOVE BI-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************18990000
      **  THIS PARAGRAPH IS USED TO OPEN THE CURSOR USED TO FETCH     **19000000
      **  ROWS FROM THE CSS_XFER_ACCT TABLE.                          **19010000
      ******************************************************************19020000
       7022-OPEN-XFER-CURSOR.                                           
      *                                                                 19030000
           EXEC SQL                                                     
               OPEN XFER-CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 19070000
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                 19090000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7022'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_BILL_ACCT_XFER'      TO TABLE-1                 
              MOVE 'ACCOUNT_NO  '            TO TABLE-ELEMENT-1         
              MOVE 'BILL_NO'                 TO TABLE-ELEMENT-2         
              MOVE AF-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE AF-BILL-NO                TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT
           END-IF.           
      *                                                                 19114000
       7022-EXIT.                                                       
           EXIT.                                                        
      *                                                                 19113000
      ******************************************************************19117000
      **  THIS PARAGRAPH IS USED TO OBTAIN THE NEXT ROW FROM THE      **19118000
      **  CSS_XFER_ACCT TABLE WHERE THE MASTER ACCT NO IS EQUAL TO    **19119000
      **  THE ACCOUNT NUMBER PASSED TO THIS PROGRAM VIA THE           **19120000
      **  COMMUNICATION AREA ACCOUNT NUMBER AND THE BILL NUMBER IS    **19130000
      **  EQUAL THE CURRENT CSS_BILLING_HDR ROW BILL NUMBER.          **19140000
      ******************************************************************19150000
       7024-FETCH-XFER-ROW.                                             
      *                                                                 19160000
           EXEC SQL                                                     
               FETCH XFER-CURSOR                                        
               INTO :AF-BILL-NO-XFER-FROM                               
                   ,:AF-ACCT-XFER-FROM                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 19340000
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                 19360000
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
              IF WS-ACTIVE-RETURN-CODE  = NOT-FOUND                     
                 MOVE WS-NO                  TO WS-MORE-SUBS-SW         
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7024'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_BILL_ACCT_XFER'      TO TABLE-1                 
              MOVE 'ACCOUNT_NO  '            TO TABLE-ELEMENT-1         
              MOVE 'BILL_NO'                 TO TABLE-ELEMENT-2         
              MOVE AF-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE AF-BILL-NO                TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT
           END-IF.           
      *                                                                 19418000
       7024-EXIT.                                                       
           EXIT.                                                        
      *                                                                 19418000
      ******************************************************************19414000
      **  THIS PARAGRAPH IS USED TO CLOSE THE CURSOR USED TO FETCH    **19415000
      **  ROWS FROM THE CSS_XFER_ACCT TABLE.                          **19416000
      ******************************************************************19417000
       7026-CLOSE-XFER-CURSOR.                                          
      *                                                                 19418000
           EXEC SQL                                                     
               CLOSE XFER-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 19440000
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                 19460000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7026'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_BILL_ACCT_XFER'      TO TABLE-1                 
              MOVE 'ACCOUNT_NO  '            TO TABLE-ELEMENT-1         
              MOVE 'BILL_NO'                 TO TABLE-ELEMENT-2         
              MOVE AF-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE AF-BILL-NO                TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT
           END-IF.           
      *                                                                 18987000
       7026-EXIT.                                                       
           EXIT.                                                        
      *                                                                 18987000
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO OPEN THE CURSOR USED TO FETCH     **        
      **  ROWS FROM THE CSS_BILLING_DET TABLE.                        **        
      ******************************************************************        
       7030-OPEN-BG-CURSOR.                                             
      *                                                                         
           EXEC SQL                                                     
               OPEN BG-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7030'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_BILLING_DET  '       TO TABLE-1                 
              MOVE 'BILL_NO  '               TO TABLE-ELEMENT-1         
              MOVE 'ACCOUNT_NO  '            TO TABLE-ELEMENT-2         
              MOVE BG-BILL-NO                TO HOSTVAR-ELEMENT-1       
              MOVE BG-ACCOUNT-NO             TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT
           END-IF.           
      *                                                                         
       7030-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO OBTAIN THE NEXT ROW FROM THE      **        
      **  CSS_BILLING_DET TABLE WHERE THE ACCOUNT NUMBER IS EQUAL TO  **        
      **  THE ACCOUNT NUMBER PASSED TO THIS PROGRAM VIA THE           **        
      **  COMMUNICATION AREA ACCOUNT NUMBER AND THE BILL NUMBER IS    **        
      **  EQUAL THE CURRENT CSS_BILLING_HDR ROW BILL NUMBER.          **        
      ******************************************************************        
       7040-FETCH-BG-ROW.                                               
      *                                                                         
           EXEC SQL                                                     
               FETCH BG-CURSOR                                          
               INTO :BG-CODE-UTIL-TYPE                                  
                   ,:BG-IC-NO                                           
                   ,:BG-AMT-BILL-ITEM                                   
                   ,:BG-AMT-STATE-TAX                                   
                   ,:BG-AMT-CITY-TAX                                    
                   ,:BG-AMT-OTHER-TAX                                   
                   ,:BG-CODE-REVENUE-CLASS                              
                   ,:BG-CODE-BILL-ITM-IND                               
                   ,:BG-CODE-BILL-ITM-TYPE                              
                   ,:BG-CODE-DR-CR-CNSMPTN                              
                   ,:BG-RATE-PLAN-NO                                    
                   ,:BG-BILL-ITEM-TIMESTMP                              
                   ,:BG-REVENUE-MONTH                                   
P00821             ,:BG-REV-MTH-ORIG-BILL :WS-NULL-IND-3                 
P00821             ,:BG-CODE-CURTAIL-PRTY                               
P00821             ,:BG-CODE-BILL-CALC                                  
                   ,:BG-DATE-ORIG-BILL :WS-NULL-IND-2                   
                   ,:BG-BTU-FACTOR                                      
                   ,:BG-ACCOUNT-NO                                      
                   ,:BG-BILL-NO                                         
                   ,:BG-NO-OF-CONS-DAYS                                 
                   ,:BG-REV-RPT-CD                                      
                   ,:BG-RT-PKG-OPT-SEQ-NO                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-NULL-IND-2 < 0                                      
                 MOVE SPACES                 TO BG-DATE-ORIG-BILL       
              END-IF                                                    
P00821        IF WS-NULL-IND-3 < 0                                      
P00821           MOVE ZERO                   TO BG-REV-MTH-ORIG-BILL    
P00821        END-IF                                                    
              IF WS-ACTIVE-RETURN-CODE  = NOT-FOUND                     
                 MOVE WS-NO                  TO WS-MORE-BGS-SW          
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7040'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_BILLING_DET  '       TO TABLE-1                 
              MOVE 'ACCOUNT_NO  '            TO TABLE-ELEMENT-1         
              MOVE 'BILL_NO  '               TO TABLE-ELEMENT-2         
              MOVE BG-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE BG-BILL-NO                TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT
           END-IF.           
      *                                                                         
       7040-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO CLOSE THE CURSOR USED TO FETCH    **        
      **  ROWS FROM THE CSS_BILLING_DET TABLE.                        **        
      ******************************************************************        
       7050-CLOSE-BG-CURSOR.                                            
      *                                                                         
           EXEC SQL                                                     
               CLOSE BG-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7050'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_BILLING_DET  '       TO TABLE-1                 
              MOVE 'ACCOUNT_NO  '            TO TABLE-ELEMENT-1         
              MOVE 'BILL_NO  '               TO TABLE-ELEMENT-2         
              MOVE BG-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE BG-BILL-NO                TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT
           END-IF.           
      *                                                                         
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO OPEN THE CURSOR TO                **        
      **  CSS_BILL_CALC_DET TABLE.                                    **        
      ******************************************************************        
       7060-OPEN-BZ-CURSOR.                                             
      *                                                                         
           EXEC SQL                                                     
               OPEN BZ-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7060'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_BILL_CALC_DET'       TO TABLE-1                 
              MOVE 'ACCOUNT_NO  '            TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE 'BILL_NO'                 TO TABLE-ELEMENT-3         
              MOVE 'IC_NO'                   TO TABLE-ELEMENT-4         
              MOVE BZ-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE BZ-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              MOVE BZ-BILL-NO                TO HOSTVAR-ELEMENT-3       
              MOVE BZ-IC-NO                  TO HOSTVAR-ELEMENT-4       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT
           END-IF.           
      *                                                                         
       7060-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  THIS PARAGRAPH FETCHES THE PAYMENT ROWS FROM THE            **        
      **  CSS_BILL_CALC_DET TABLE FOR A GIVEN ACCOUNT NUMBER AND      **        
      **  IC-NO.                                                      **        
      ******************************************************************        
       7070-FETCH-BZ-ROW.                                               
      *                                                                         
           EXEC SQL                                                     
               FETCH BZ-CURSOR                                          
                  INTO :BZ-BILL-UNITS                                   
                      ,:BZ-BILLED-COMP-AM                               
                      ,:BZ-CONSUMPT-TYPE-CD                             
                      ,:BZ-CMPNT-ID-CD                                  
                      ,:BZ-READ-UNITS                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL OR          
                                            NOT-FOUND                   
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7070'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_BILL_CALC_DET'       TO TABLE-1                 
              MOVE 'ACCOUNT_NO  '            TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE 'BILL_NO'                 TO TABLE-ELEMENT-3         
              MOVE 'IC_NO'                   TO TABLE-ELEMENT-4         
              MOVE BZ-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE BZ-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              MOVE BZ-BILL-NO                TO HOSTVAR-ELEMENT-3       
              MOVE BZ-IC-NO                  TO HOSTVAR-ELEMENT-4       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT
           END-IF.           
      *                                                                         
       7070-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO CLOSE THE CURSOR USED TO FETCH    **        
      **  ROWS FROM THE CSS_BILL_CALC_DET TABLE.                      **        
      ******************************************************************        
       7080-CLOSE-BZ-CURSOR.                                            
      *                                                                         
           EXEC SQL                                                     
               CLOSE BZ-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7080'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_BILL_CALC_DET'       TO TABLE-1                 
              MOVE 'ACCOUNT_NO  '            TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE 'BILL_NO'                 TO TABLE-ELEMENT-3         
              MOVE 'IC_NO'                   TO TABLE-ELEMENT-4         
              MOVE BZ-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE BZ-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              MOVE BZ-BILL-NO                TO HOSTVAR-ELEMENT-3       
              MOVE BZ-IC-NO                  TO HOSTVAR-ELEMENT-4       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT
           END-IF.           
      *                                                                         
       7080-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO OPEN THE CURSOR TO                **        
      **  CSS_UM_CNSMPT_HIST TABLE.                                   **        
      ******************************************************************        
       7090-OPEN-UC-CURSOR.                                             
      *                                                                         
           EXEC SQL                                                     
               OPEN UC-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7090'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_UM_CNSMPT_HIST'      TO TABLE-1                 
              MOVE 'ACCOUNT_NO  '            TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE 'BILL_NO'                 TO TABLE-ELEMENT-3         
              MOVE 'IC_NO'                   TO TABLE-ELEMENT-4         
              MOVE UC-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE UC-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              MOVE UC-BILL-NO                TO HOSTVAR-ELEMENT-3       
              MOVE UC-IC-NO                  TO HOSTVAR-ELEMENT-4       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT
           END-IF.           
      *                                                                         
       7090-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  THIS PARAGRAPH FETCHES THE PAYMENT ROWS FROM THE            **        
      **  CSS_UM_CNSMPT_HIS TABLE FOR A GIVEN ACCOUNT NUMBER AND      **        
      **  IC-NO.                                                      **        
      ******************************************************************        
       7100-FETCH-UC-ROW.                                               
      *                                                                         
           EXEC SQL                                                     
               FETCH UC-CURSOR                                          
                  INTO :UC-DATE-USAGE-ENDS :WS-NULL-IND-7               
                      ,:UC-NO-UNITS                                     
                      ,:UC-NO-DAYS                                      
                      ,:UC-MTHLY-AMOUNT-FIXED                           
                      ,:UC-CODE-DEBIT-CREDIT                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL OR          
                                            NOT-FOUND                   
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7100'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_UM_CNSMPT_HIST'      TO TABLE-1                 
              MOVE 'ACCOUNT_NO  '            TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE 'BILL_NO'                 TO TABLE-ELEMENT-3         
              MOVE 'IC_NO'                   TO TABLE-ELEMENT-4         
              MOVE UC-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE UC-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              MOVE UC-BILL-NO                TO HOSTVAR-ELEMENT-3       
              MOVE UC-IC-NO                  TO HOSTVAR-ELEMENT-4       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT
           END-IF.           
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO CLOSE THE CURSOR USED TO FETCH    **        
      **  ROWS FROM THE CSS_UM_CNSMPT_HIS TABLE.                      **        
      ******************************************************************        
       7110-CLOSE-UC-CURSOR.                                            
      *                                                                         
           EXEC SQL                                                     
               CLOSE UC-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7110'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_UM_CNSMPT_HIST'      TO TABLE-1                 
              MOVE 'ACCOUNT_NO  '            TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE 'BILL_NO'                 TO TABLE-ELEMENT-3         
              MOVE 'IC_NO'                   TO TABLE-ELEMENT-4         
              MOVE UC-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE UC-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              MOVE UC-BILL-NO                TO HOSTVAR-ELEMENT-3       
              MOVE UC-IC-NO                  TO HOSTVAR-ELEMENT-4       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT
           END-IF.           
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
P00821**  THIS PARAGRAPH IS USED TO SELECT THE ORIGINATION CODE       **19486000
P00821**  FIELD FROM THE CSS-MKT-XFER-ACCT TABLE.                     **19487000
P00821******************************************************************19488000
P00821*                                                                         
P00821 7118-SELECT-COBB-SNAPSHOAL.                                      
P00821                                                                  
P00821     EXEC SQL                                                     
P00821       SELECT TOP(1) XM.ORIGINATION_CD                                   
P00821         INTO :WS-COBB-SNAPSHOAL                                  
P00821         FROM CSS_MKT_XREF_ACCT XM WITH(READUNCOMMITTED)                  
P00821        WHERE XM.ACCOUNT_NO  = :XM-ACCOUNT-NO                     
P00821                                              
P00821                                                           
P00821     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     19489000
MFA-TR*      SELECT XM.ORIGINATION_CD                                   19490000
MFA-TR*        INTO :WS-COBB-SNAPSHOAL                                  19491000
MFA-TR*        FROM CSS_MKT_XREF_ACCT XM                                19500000
MFA-TR*       WHERE XM.ACCOUNT_NO  = :XM-ACCOUNT-NO                     19501000
MFA-TR*       FETCH FIRST ROW ONLY                                      19501000
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC                                                     19520000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00821                                                                  
P00821     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
P00821                                                                  
P00821     IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
P00821        CONTINUE                                                  
P00821     ELSE                                                         
P00821        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
P00821        MOVE '7118'                     TO ACTIVE-PARAGRAPH       
P00821        MOVE 'SELECT'                   TO ABEND-FUNCTION         
P00821        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
P00821                                           ABEND-TABLES           
P00821        MOVE 'CSS_MKT_XREF_ACCT'        TO TABLE-1                
P00821        MOVE 'ACCOUNT_NO  '             TO TABLE-ELEMENT-1        
P00821        MOVE XM-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
P00821        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT
           END-IF.           
P00821 7118-EXIT.                                                       
P00821      EXIT.                                                       
      *                                                                         
      *                                                                         
      ******************************************************************        
P00821**  THIS PARAGRAPH IS USED TO SELECT THE PRT SVC CATEGORY CODE  **19486000
P00821******************************************************************19488000
P00821*                                                                         
P00821 7119-SELECT-SVC-CATEGORY.                                        
P00821                                                                  
P00821     EXEC SQL                                                     
P00821         SELECT PRTY_SVC_CAT_CD                                   
P00821           INTO :Z4-PRTY-SVC-CAT-CD                               
P00821           FROM CSS_PRTY_SVC_CAT Z4 WITH(READUNCOMMITTED)                 
P00821          WHERE COMPANY_NO        = :Z4-COMPANY-NO                
P00821            AND CODE_CURTAIL_PRTY = :Z4-CODE-CURTAIL-PRTY         
P00821                                                           
P00821     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     19489000
MFA-TR*        SELECT PRTY_SVC_CAT_CD                                   19490000
MFA-TR*          INTO :Z4-PRTY-SVC-CAT-CD                               19491000
MFA-TR*          FROM CSS_PRTY_SVC_CAT Z4                               19500000
MFA-TR*         WHERE COMPANY_NO        = :Z4-COMPANY-NO                19501000
MFA-TR*           AND CODE_CURTAIL_PRTY = :Z4-CODE-CURTAIL-PRTY         19501000
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                    19520000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00821                                                                  
P00821     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
P00821                                                                  
P00821     IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
P00821        CONTINUE                                                  
P00821     ELSE                                                         
P00821        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
P00821        MOVE '7119'                     TO ACTIVE-PARAGRAPH       
P00821        MOVE 'SELECT'                   TO ABEND-FUNCTION         
P00821        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
P00821                                           ABEND-TABLES           
P00821        MOVE 'CSS_PRTY_SVC_CAT'         TO TABLE-1                
P00821        MOVE 'ACCOUNT_NO  '             TO TABLE-ELEMENT-1        
P00821        MOVE BG-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
P00821        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT
           END-IF.           
P00821 7119-EXIT.                                                       
P00821      EXIT.                                                       
      *                                                                         
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO OPEN THE CURSOR TO                **        
      **  CSS_CNSMPTN_HIST  TABLE.                                    **        
      ******************************************************************        
       7120-OPEN-CX-CURSOR.                                             
      *                                                                         
           EXEC SQL                                                     
               OPEN CX-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7120'                    TO ACTIVE-PARAGRAPH        
              MOVE '0PEN'                    TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_CNSMPTN_HIST '       TO TABLE-1                 
              MOVE 'ACCOUNT_NO  '            TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE 'BILL_NO'                 TO TABLE-ELEMENT-3         
              MOVE 'IC_NO'                   TO TABLE-ELEMENT-4         
              MOVE CX-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE CX-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              MOVE CX-BILL-NO                TO HOSTVAR-ELEMENT-3       
              MOVE CX-IC-NO                  TO HOSTVAR-ELEMENT-4       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT
           END-IF.           
      *                                                                         
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  THIS PARAGRAPH FETCHES THE PAYMENT ROWS FROM THE            **        
      **  CSS_CNSMPTN_HIST  TABLE FOR A GIVEN ACCOUNT NUMBER AND      **        
      **  IC-NO.                                                      **        
      ******************************************************************        
       7130-FETCH-CX-ROW.                                               
      *                                                                         
           EXEC SQL                                                     
               FETCH CX-CURSOR                                          
                  INTO :CX-CODE-USAGE-TYPE                              
                      ,:CX-METER-NO                                     
                      ,:CX-DATE-READ :WS-NULL-IND-1                     
                      ,:CX-NO-UNITS                                     
                      ,:CX-NO-DEMAND-UNITS                              
                      ,:CX-NO-DAYS                                      
                      ,:CX-CODE-SOURCE-ID                               
                      ,:CX-CODE-DEBIT-CREDIT                            
                      ,:CX-MTR-REF-NO                                   
                      ,:CX-REG-ID-NO                                    
                      ,:CX-CODE-TOU-SEASN                               
                      ,:CX-CODE-TIME-PERIOD                             
                      ,:CX-CODE-ITEM-STATUS                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL OR          
                                            NOT-FOUND                   
               IF WS-NULL-IND-1 < ZERO                                  
                   MOVE LOW-VALUES           TO CX-DATE-READ            
               END-IF                                                   
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7130'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_CNSMPTN_HIST '       TO TABLE-1                 
              MOVE 'ACCOUNT_NO  '            TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE 'BILL_NO'                 TO TABLE-ELEMENT-3         
              MOVE 'IC_NO'                   TO TABLE-ELEMENT-4         
              MOVE CX-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE CX-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              MOVE CX-BILL-NO                TO HOSTVAR-ELEMENT-3       
              MOVE CX-IC-NO                  TO HOSTVAR-ELEMENT-4       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT
           END-IF.           
      *                                                                         
       7130-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO CLOSE THE CURSOR USED TO FETCH    **        
      **  ROWS FROM THE CSS_CNSMPTN_HIST TABLE.                       **        
      ******************************************************************        
       7140-CLOSE-CX-CURSOR.                                            
      *                                                                         
           EXEC SQL                                                     
               CLOSE CX-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7140'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_CNSMPTN_HIST '       TO TABLE-1                 
              MOVE 'ACCOUNT_NO  '            TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE 'BILL_NO'                 TO TABLE-ELEMENT-3         
              MOVE 'IC_NO'                   TO TABLE-ELEMENT-4         
              MOVE CX-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE CX-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              MOVE CX-BILL-NO                TO HOSTVAR-ELEMENT-3       
              MOVE CX-IC-NO                  TO HOSTVAR-ELEMENT-4       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT
           END-IF.           
      *                                                                         
       7140-EXIT.                                                       
           EXIT.                                                        
PRJ821*                                                                         
PRJ821******************************************************************        
PRJ821* CHECK IF MASTER ACCOUNT HAS MORE THAN 13 BILLS                 *        
PRJ821******************************************************************        
PRJ821 7145-CHK-13-MTHS-BIL-EXIST-MST.                                  
PRJ821*                                                                         
PRJ821     EXEC SQL                                                     
PRJ821         SELECT TOP(1) 'Y'                                              
PRJ821           INTO  :S3-ADDTNL-BILLS-EXIST                           
PRJ821           FROM  CSS_BILLING_DET BG WITH(READUNCOMMITTED),                
PRJ821                 CSS_BILL_ACCT_XFER AF WITH(READUNCOMMITTED)              
PRJ821          WHERE  AF.ACCOUNT_NO     = :AF-ACCOUNT-NO               
PRJ821            AND  BG.REVENUE_MONTH  < :BG-REVENUE-MONTH            
PRJ821            AND  BG.REVENUE_MONTH  > 0                            
PRJ821            AND  BG.ACCOUNT_NO     = AF.ACCT_XFER_FROM            
PRJ821                                              
PRJ821                                                           
PRJ821     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  'Y'                                                      
MFA-TR*          INTO  :S3-ADDTNL-BILLS-EXIST                                   
MFA-TR*          FROM  CSS_BILLING_DET BG,                                      
MFA-TR*                CSS_BILL_ACCT_XFER AF                                    
MFA-TR*         WHERE  AF.ACCOUNT_NO     = :AF-ACCOUNT-NO                       
MFA-TR*           AND  BG.REVENUE_MONTH  < :BG-REVENUE-MONTH                    
MFA-TR*           AND  BG.REVENUE_MONTH  > 0                                    
MFA-TR*           AND  BG.ACCOUNT_NO     = AF.ACCT_XFER_FROM                    
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PRJ821                                                                  
PRJ821     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
PRJ821                                                                  
PRJ821     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
PRJ821        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
PRJ821           MOVE WS-NO                  TO S3-ADDTNL-BILLS-EXIST   
PRJ821        END-IF                                                    
PRJ821     ELSE                                                         
PRJ821        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
PRJ821        MOVE '7145'                    TO ACTIVE-PARAGRAPH        
PRJ821        MOVE 'SELECT'                  TO ABEND-FUNCTION          
PRJ821        MOVE SPACES                    TO ABEND-SQL-PREDICATES    
PRJ821                                          ABEND-TABLES            
PRJ821        MOVE 'CSS_BILLING_DET'         TO TABLE-1                 
PRJ821        MOVE 'CSS_BILL_ACCT_XFER'      TO TABLE-2                 
PRJ821        MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
PRJ821        MOVE 'REVENUE_MONTH'           TO TABLE-ELEMENT-2         
PRJ821        MOVE 'ACCT_XFER_FROM'          TO TABLE-ELEMENT-3         
PRJ821        MOVE BG-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
PRJ821        MOVE BG-REVENUE-MONTH          TO HOSTVAR-ELEMENT-2       
PRJ821        MOVE AF-ACCT-XFER-FROM         TO HOSTVAR-ELEMENT-3       
PRJ821        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
PRJ821     END-IF.                                                      
PRJ821*                                                                         
PRJ821 7145-EXIT.                                                       
PRJ821      EXIT.                                                       
PRJ821*                                                                         
      *                                                                         
      ******************************************************************        
      * CHECK IF ACCOUNT HAS MORE THAN 13 BILLS                        *        
      ******************************************************************        
       7150-CHK-13-MNTHS-BILL-EXIST.                                    
      *                                                                         
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                              
                 INTO  :S3-ADDTNL-BILLS-EXIST                           
                 FROM  CSS_BILLING_DET BG WITH(READUNCOMMITTED)                 
                WHERE  BG.ACCOUNT_NO     = :BG-ACCOUNT-NO               
                  AND  BG.REVENUE_MONTH  < :BG-REVENUE-MONTH            
                  AND  BG.REVENUE_MONTH  > 0                            
                                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  'Y'                                                      
MFA-TR*          INTO  :S3-ADDTNL-BILLS-EXIST                                   
MFA-TR*          FROM  CSS_BILLING_DET BG                                       
MFA-TR*         WHERE  BG.ACCOUNT_NO     = :BG-ACCOUNT-NO                       
MFA-TR*           AND  BG.REVENUE_MONTH  < :BG-REVENUE-MONTH                    
MFA-TR*           AND  BG.REVENUE_MONTH  > 0                                    
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE WS-NO                  TO S3-ADDTNL-BILLS-EXIST   
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7150'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_BILLING_DET'         TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'REVENUE_MONTH'           TO TABLE-ELEMENT-2         
              MOVE BG-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE BG-REVENUE-MONTH          TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       7150-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
PRJ821******************************************************************        
PRJ821* 7170-GET-ACCT-BILLS-COUNT                                      *        
PRJ821******************************************************************        
PRJ821 7170-GET-ACCT-BILLS-COUNT.                                       
PRJ821*                                                                         
PRJ821     EXEC SQL                                                     
PRJ821         SELECT  COUNT(DISTINCT BG.REVENUE_MONTH)                 
PRJ821           INTO  :S3-ACCT-BILLS-COUNT                             
PRJ821           FROM  CSS_BILLING_DET BG WITH(READUNCOMMITTED)                 
PRJ821          WHERE  BG.ACCOUNT_NO     = :BG-ACCOUNT-NO               
PRJ821            AND  BG.REVENUE_MONTH  > 0                            
PRJ821                                                           
PRJ821     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  COUNT(DISTINCT BG.REVENUE_MONTH)                         
MFA-TR*          INTO  :S3-ACCT-BILLS-COUNT                                     
MFA-TR*          FROM  CSS_BILLING_DET BG                                       
MFA-TR*         WHERE  BG.ACCOUNT_NO     = :BG-ACCOUNT-NO                       
MFA-TR*           AND  BG.REVENUE_MONTH  > 0                                    
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PRJ821                                                                  
PRJ821     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
PRJ821                                                                  
PRJ821     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
PRJ821        CONTINUE                                                  
PRJ821     ELSE                                                         
PRJ821        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
PRJ821        MOVE '7170'                    TO ACTIVE-PARAGRAPH        
PRJ821        MOVE 'SELECT'                  TO ABEND-FUNCTION          
PRJ821        MOVE SPACES                    TO ABEND-SQL-PREDICATES    
PRJ821                                          ABEND-TABLES            
PRJ821        MOVE 'CSS_BILLING_DET'         TO TABLE-1                 
PRJ821        MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
PRJ821        MOVE BG-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
PRJ821        MOVE 'REVENUE_MONTH'           TO TABLE-ELEMENT-2         
PRJ821        MOVE BG-REVENUE-MONTH          TO HOSTVAR-ELEMENT-2       
PRJ821        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
PRJ821     END-IF.                                                      
PRJ821*                                                                         
PRJ821 7170-EXIT.                                                       
PRJ821      EXIT.                                                       
PRJ821*                                                                         
P00821******************************************************************        
P00821*** SELECT THE TOTAL NO OF ROWS FOR BI IN BG TABLE.            ** 00110000
P00821******************************************************************        
P00821 7180-SELECT-BILLING-DET.                                         
P00821*                                                                         
P00821     EXEC SQL                                                     
P00821          SELECT COUNT(1)                                         
P00821            INTO :WS-BG-ROW-COUNT                                 
P00821            FROM CSS_BILLING_DET BG WITH(READUNCOMMITTED)                 
P00821           WHERE ACCOUNT_NO         = :BG-ACCOUNT-NO              
P00821             AND BILL_NO            = :WS-BI-BILL-NO              
P00821             AND DATE_ORIG_BILL    IS NULL                        
P00821             AND CODE_BILL_CALC     = 'A'                         
P00821             AND CODE_BILL_ITM_TYPE = 'C'                         
P00821             AND CODE_BILL_ITM_IND  = 'A'                         
P00821             AND REVENUE_MONTH      = 0                           
P00821             AND REV_MTH_ORIG_BILL  = 0                           
P00821             AND REV_RPT_CD        <> 'T'                         
P00821                                                           
P00821     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT COUNT(1)                                                 
MFA-TR*           INTO :WS-BG-ROW-COUNT                                         
MFA-TR*           FROM CSS_BILLING_DET BG                                       
MFA-TR*          WHERE ACCOUNT_NO         = :BG-ACCOUNT-NO                      
MFA-TR*            AND BILL_NO            = :WS-BI-BILL-NO                      
MFA-TR*            AND DATE_ORIG_BILL    IS NULL                                
MFA-TR*            AND CODE_BILL_CALC     = 'A'                                 
MFA-TR*            AND CODE_BILL_ITM_TYPE = 'C'                                 
MFA-TR*            AND CODE_BILL_ITM_IND  = 'A'                                 
MFA-TR*            AND REVENUE_MONTH      = 0                                   
MFA-TR*            AND REV_MTH_ORIG_BILL  = 0                                   
MFA-TR*            AND REV_RPT_CD        <> 'T'                                 
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00821**                                                                43529000
P00821     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
P00821**                                                                43529300
P00821     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
P00821         CONTINUE                                                 
P00821     ELSE                                                         
P00821         MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
P00821         MOVE '7180'                    TO ACTIVE-PARAGRAPH       
P00821         MOVE 'SELECT'                  TO ABEND-FUNCTION         
P00821         MOVE SPACES                    TO ABEND-SQL-PREDICATES   
P00821                                           ABEND-TABLES           
P00821         MOVE 'CSS_BILLING_DET'         TO TABLE-1                
P00821         MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1        
P00821         MOVE BG-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1      
P00821         MOVE 'BILL_NO'                 TO TABLE-ELEMENT-2        
P00821         MOVE WS-BI-BILL-NO             TO HOSTVAR-ELEMENT-2      
P00821         PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
P00821     END-IF.                                                      
P00821**                                                                        
P00821 7180-EXIT.                                                       
P00821     EXIT.                                                        
P00821**                                                                        
P00821******************************************************************42270100
P00821**                                                               *42270100
P00821** 7960-SELECT-UT-ROW.                                           *42270100
P00821** SELECT THE TOTAL NUMBER OF ROWS FOR THE BG ACCOUNT IN UT TBL. *42270100
P00821******************************************************************42270100
P00821 7190-SELECT-UT-ROW.                                              
P00821*                                                                 42270600
P00821     EXEC SQL                                                     
P00821         SELECT COUNT(1)                                          
P00821         INTO :WS-UT-ROW-COUNT                                    
P00821          FROM  CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                 
P00821         WHERE UT.ACCOUNT_NO        =   :UT-ACCOUNT-NO            
P00821         AND(                                                     
P00821            (EXISTS                                               
P00821            (SELECT 1                                             
P00821              FROM CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)              
P00821             WHERE MN.ACCOUNT_NO        =  UT.ACCOUNT_NO          
P00821               AND MN.IC_NO             =  UT.IC_NO               
P00821               AND MN.CODE_UTIL_TYPE    =  UT.CODE_UTIL_TYPE      
A05460               AND MN.CODE_METER_STATUS IN ('A','B','I','J')))    
P00821          OR                                                      
P00821            (EXISTS                                               
P00821            (SELECT 1                                             
P00821               FROM CSS_CUST_PLAN CU WITH(READUNCOMMITTED)                
P00821             WHERE CU.ACCOUNT_NO        =  UT.ACCOUNT_NO          
P00821               AND CU.IC_NO             =  UT.IC_NO               
P00821               AND CU.CODE_UTIL_TYPE    =  UT.CODE_UTIL_TYPE      
P00821               AND CU.CODE_PLAN_STATUS  =  'A'                    
P00821               AND CU.REMOVE_DATE       IS NULL)))                
P00821                                                           
P00821     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     42270300
MFA-TR*        SELECT COUNT(1)                                                  
MFA-TR*        INTO :WS-UT-ROW-COUNT                                            
MFA-TR*         FROM  CSS_UTIL_ENVRNMT UT                                       
MFA-TR*        WHERE UT.ACCOUNT_NO        =   :UT-ACCOUNT-NO                    
MFA-TR*        AND(                                                             
MFA-TR*           (EXISTS                                                       
MFA-TR*           (SELECT 1                                                     
MFA-TR*             FROM CSS_MTRD_ENVRNMT MN                                    
MFA-TR*            WHERE MN.ACCOUNT_NO        =  UT.ACCOUNT_NO                  
MFA-TR*              AND MN.IC_NO             =  UT.IC_NO                       
MFA-TR*              AND MN.CODE_UTIL_TYPE    =  UT.CODE_UTIL_TYPE      TYPE    
MFA-TR*              AND MN.CODE_METER_STATUS IN ('A','B','I','J')))       ))   
MFA-TR*         OR                                                              
MFA-TR*           (EXISTS                                                       
MFA-TR*           (SELECT 1                                                     
MFA-TR*              FROM CSS_CUST_PLAN CU                                      
MFA-TR*            WHERE CU.ACCOUNT_NO        =  UT.ACCOUNT_NO                  
MFA-TR*              AND CU.IC_NO             =  UT.IC_NO                       
MFA-TR*              AND CU.CODE_UTIL_TYPE    =  UT.CODE_UTIL_TYPE      TYPE    
MFA-TR*              AND CU.CODE_PLAN_STATUS  =  'A'                            
MFA-TR*              AND CU.REMOVE_DATE       IS NULL)))                   ))   
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                    42270300

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00821     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
P00821                                                                  
P00821     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00821        CONTINUE                                                  
P00821     ELSE                                                         
P00821         MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
P00821         MOVE '7190'                    TO ACTIVE-PARAGRAPH       
P00821         MOVE 'SELECT'                  TO ABEND-FUNCTION         
P00821         MOVE SPACES                    TO ABEND-SQL-PREDICATES   
P00821                                           ABEND-TABLES           
P00821         MOVE 'CSS_UTIL_ENVRMT'         TO TABLE-1                
P00821         MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1        
P00821         MOVE UT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1      
P00821         PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
P00821     END-IF.                                                      
P00821*                                                                 42272200
P00821 7190-EXIT.                                                       
P00821      EXIT.                                                       
P00821*                                                                 42272200
      ******************************************************************        
      * CHECK TO SEE IF UNMETERED ACCOUNT EXISTS WITH UTIL TYPE E OR G *        
      ******************************************************************        
       7200-CUST-PLAN-EXISTS.                                           
      *                                                                         
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                              
                 INTO  :WS-UNMTRD-ELEC-GAS                              
                 FROM  CSS_CUST_PLAN WITH(READUNCOMMITTED)                      
                WHERE  ACCOUNT_NO     = :CP-ACCOUNT-NO                  
                  AND  CODE_UTIL_TYPE = :CP-CODE-UTIL-TYPE              
                  AND  IC_NO          = :CP-IC-NO                       
                  AND  CODE_UTIL_TYPE IN ('E', 'G')                     
ACT063                                              
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  'Y'                                                      
MFA-TR*          INTO  :WS-UNMTRD-ELEC-GAS                                      
MFA-TR*          FROM  CSS_CUST_PLAN                                            
MFA-TR*         WHERE  ACCOUNT_NO     = :CP-ACCOUNT-NO                          
MFA-TR*           AND  CODE_UTIL_TYPE = :CP-CODE-UTIL-TYPE                      
MFA-TR*           AND  IC_NO          = :CP-IC-NO                               
MFA-TR*           AND  CODE_UTIL_TYPE IN ('E', 'G')                             
MFA-TR*           FETCH FIRST ROW ONLY                                          
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE WS-NO                  TO WS-UNMTRD-ELEC-GAS      
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7200'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_CUST_PLAN'           TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE CP-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE CP-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * THE BELOW QRY TO CHECK WHETHER THE CANCELLED ROW GOT BILLED    *        
      * 7205-CHK-REBILL-ROW.                                           *        
      ******************************************************************        
       7205-CHK-REBILL-ROW.                                             
                                                                        
           EXEC SQL                                                     
              SELECT BI.BILL_NO                                         
                INTO :WS-BILL-NO                                        
                FROM CSS_BILLING_DET  BG WITH(READUNCOMMITTED)                  
                    ,CSS_BILLING_HDR  BI WITH(READUNCOMMITTED)                  
               WHERE BG.ACCOUNT_NO          = BI.ACCOUNT_NO             
                 AND BG.BILL_NO             = BI.BILL_NO                
                 AND BG.DATE_ORIG_BILL      = IIF(TRY_CONVERT(DATE, 
                                                     :BG-DATE-ORIG-BILL
              ) IS NULL OR (PATINDEX('%.%', :BG-DATE-ORIG-BILL
              ) <> 0) OR (LEN(:BG-DATE-ORIG-BILL
              ) <> 10), CIS.CHAR2DATE(:BG-DATE-ORIG-BILL
              ), CONVERT(DATE, :BG-DATE-ORIG-BILL) )        
                 AND BG.ACCOUNT_NO          = :BG-ACCOUNT-NO            
                 AND BG.CODE_UTIL_TYPE      = :BG-CODE-UTIL-TYPE        
                 AND BG.IC_NO               = :BG-IC-NO                 
                 AND BG.CODE_BILL_CALC     <> 'S'                       
                 AND BG.CODE_BILL_ITM_TYPE <> 'B'                       
                 AND BG.CODE_BILL_ITM_IND  NOT IN('K','J')              
               ORDER BY BG.BILL_NO DESC                                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BI.BILL_NO                                                 
MFA-TR*         INTO :WS-BILL-NO                                                
MFA-TR*         FROM CSS_BILLING_DET  BG                                        
MFA-TR*             ,CSS_BILLING_HDR  BI                                        
MFA-TR*        WHERE BG.ACCOUNT_NO          = BI.ACCOUNT_NO                     
MFA-TR*          AND BG.BILL_NO             = BI.BILL_NO                        
MFA-TR*          AND BG.DATE_ORIG_BILL      = :BG-DATE-ORIG-BILL                
MFA-TR*          AND BG.ACCOUNT_NO          = :BG-ACCOUNT-NO                    
MFA-TR*          AND BG.CODE_UTIL_TYPE      = :BG-CODE-UTIL-TYPE                
MFA-TR*          AND BG.IC_NO               = :BG-IC-NO                         
MFA-TR*          AND BG.CODE_BILL_CALC     <> 'S'                               
MFA-TR*          AND BG.CODE_BILL_ITM_TYPE <> 'B'                               
MFA-TR*          AND BG.CODE_BILL_ITM_IND  NOT IN('K','J')                      
MFA-TR*        ORDER BY BG.BILL_NO DESC                                         
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
               MOVE SPACES                   TO ABEND-TABLES            
               MOVE SPACES                   TO ABEND-SQL-PREDICATES    
               MOVE '7205'                   TO ACTIVE-PARAGRAPH        
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE 'SELECT'                 TO ABEND-FUNCTION          
               MOVE 'CSS_BILLING_HDR'        TO TABLE-1                 
               MOVE 'CSS_BILLING_DET'        TO TABLE-2                 
               MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1         
               MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2         
               MOVE 'BILL_NO'                TO TABLE-ELEMENT-3         
               MOVE BG-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1       
               MOVE BG-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2       
               MOVE BG-BILL-NO               TO HOSTVAR-ELEMENT-3       
               PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT       
           END-IF.                                                      
      *                                                                         
       7205-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************19485000
      **  THIS PARAGRAPH IS USED TO SELECT THE TOTAL CHARGES THAT     **19486000
      **  ARE RELATED TO AGL FACTORS.                                 **19487000
      ******************************************************************19488000
       7207-AGL-DEBIT.                                                  
      *                                                                 19484000
           EXEC SQL                                                     
               SELECT  SUM(FH.FACTOR)                                   
                 INTO  :WS-AGL-DEBIT :WS-NULL-IND-8                      
               FROM    CSS_FIXED_FCT_HIST FH WITH(READUNCOMMITTED)              
                      ,CSS_SPCL_FCTR      SF WITH(READUNCOMMITTED)              
               WHERE   FH.ACCOUNT_NO         = :BG-ACCOUNT-NO           
                 AND   FH.BILL_NO            = :BG-BILL-NO              
                 AND   FH.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :BG-BILL-ITEM-TIMESTMP
              )   
                 AND   FH.CODE_DEBIT_CREDIT  = 'D'                      
                 AND   SF.SPCL_GROUP_CD      = 'AP'                     
                 AND   SF.FACTOR_ID          = FH.FACTOR_ID             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     19489000
MFA-TR*        SELECT  SUM(FH.FACTOR)                                           
MFA-TR*          INTO  :WS-AGL-DEBIT:WS-NULL-IND-8                              
MFA-TR*        FROM    CSS_FIXED_FCT_HIST FH                                    
MFA-TR*               ,CSS_SPCL_FCTR      SF                                    
MFA-TR*        WHERE   FH.ACCOUNT_NO         = :BG-ACCOUNT-NO                   
MFA-TR*          AND   FH.BILL_NO            = :BG-BILL-NO                      
MFA-TR*          AND   FH.BILL_ITEM_TIMESTMP = :BG-BILL-ITEM-TIMESTMP           
MFA-TR*          AND   FH.CODE_DEBIT_CREDIT  = 'D'                              
MFA-TR*          AND   SF.SPCL_GROUP_CD      = 'AP'                             
MFA-TR*          AND   SF.FACTOR_ID          = FH.FACTOR_ID                     
MFA-TR*    WITH UR                                                              
MFA-TR*    QUERYNO 7207                                                         
MFA-TR*    END-EXEC.                                                    19530000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL OR NOT-FOUND
              IF WS-NULL-IND-8 < 0                                      
                 MOVE 0                      TO WS-AGL-DEBIT            
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7207'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_FIXED_FCT_HIST'      TO TABLE-1                 
              MOVE 'ACCOUNT_NO  '            TO TABLE-ELEMENT-1         
              MOVE 'BILL_ITEM_TIMESTMP'      TO TABLE-ELEMENT-2         
              MOVE BG-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE BG-BILL-ITEM-TIMESTMP     TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7207-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************19485000
      **  THIS PARAGRAPH IS USED TO SELECT THE TOTAL CHARGES THAT     **19486000
      **  ARE RELATED TO AGL FACTORS.                                 **19487000
      ******************************************************************19488000
       7209-AGL-CREDIT.                                                 
      *                                                                 19484000
           EXEC SQL                                                     
               SELECT  SUM(FH.FACTOR)                                   
                 INTO  :WS-AGL-CREDIT :WS-NULL-IND-8                     
               FROM    CSS_FIXED_FCT_HIST FH WITH(READUNCOMMITTED)              
                      ,CSS_SPCL_FCTR      SF WITH(READUNCOMMITTED)              
               WHERE   FH.ACCOUNT_NO         = :BG-ACCOUNT-NO           
                 AND   FH.BILL_NO            = :BG-BILL-NO              
                 AND   FH.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :BG-BILL-ITEM-TIMESTMP
              )   
                 AND   FH.CODE_DEBIT_CREDIT  = 'C'                      
                 AND   SF.SPCL_GROUP_CD      = 'AP'                     
                 AND   SF.FACTOR_ID          = FH.FACTOR_ID             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     19489000
MFA-TR*        SELECT  SUM(FH.FACTOR)                                           
MFA-TR*          INTO  :WS-AGL-CREDIT:WS-NULL-IND-8                             
MFA-TR*        FROM    CSS_FIXED_FCT_HIST FH                                    
MFA-TR*               ,CSS_SPCL_FCTR      SF                                    
MFA-TR*        WHERE   FH.ACCOUNT_NO         = :BG-ACCOUNT-NO                   
MFA-TR*          AND   FH.BILL_NO            = :BG-BILL-NO                      
MFA-TR*          AND   FH.BILL_ITEM_TIMESTMP = :BG-BILL-ITEM-TIMESTMP           
MFA-TR*          AND   FH.CODE_DEBIT_CREDIT  = 'C'                              
MFA-TR*          AND   SF.SPCL_GROUP_CD      = 'AP'                             
MFA-TR*          AND   SF.FACTOR_ID          = FH.FACTOR_ID                     
MFA-TR*    WITH UR                                                              
MFA-TR*    QUERYNO 7209                                                         
MFA-TR*    END-EXEC.                                                    19530000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL OR NOT-FOUND
              IF WS-NULL-IND-8 < 0                                      
                 MOVE 0                      TO WS-AGL-CREDIT           
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7209'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_FIXED_FCT_HIST'      TO TABLE-1                 
              MOVE 'ACCOUNT_NO  '            TO TABLE-ELEMENT-1         
              MOVE 'BILL_ITEM_TIMESTMP'      TO TABLE-ELEMENT-2         
              MOVE BG-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE BG-BILL-ITEM-TIMESTMP     TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       7209-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      ** TO GET AR-TRANS-HIST-SEQ-NO FROM CSS_AR_TRANS_HIST TABLE      *        
      ******************************************************************        
       7210-GET-AR-TRANS-SEQ-NO.                                        
      *                                                                         
           EXEC SQL                                                     
               SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           AR.TRANS_HIST_SEQ_NO, 121), ' ', '-'), ':', '.') 
           TRANS_HIST_SEQ_NO                              
                 INTO :AR-TRANS-HIST-SEQ-NO                             
                 FROM CSS_AR_TRANS_HIST AR WITH(READUNCOMMITTED)                
                WHERE AR.ACCOUNT_NO     = :AR-ACCOUNT-NO                
                  AND AR.DATE_TRANS     = IIF(TRY_CONVERT(DATE, 
                                                         :AR-DATE-TRANS
              ) IS NULL OR (PATINDEX('%.%', :AR-DATE-TRANS
              ) <> 0) OR (LEN(:AR-DATE-TRANS) <> 10), CIS.CHAR2DATE(
                                                         :AR-DATE-TRANS
              ), CONVERT(DATE, :AR-DATE-TRANS) )                
                  AND AR.CODE_TRAN_TYPE = 'B'                           
                                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT AR.TRANS_HIST_SEQ_NO                                      
MFA-TR*          INTO :AR-TRANS-HIST-SEQ-NO                                     
MFA-TR*          FROM CSS_AR_TRANS_HIST AR                                      
MFA-TR*         WHERE AR.ACCOUNT_NO     = :AR-ACCOUNT-NO                        
MFA-TR*           AND AR.DATE_TRANS     = :AR-DATE-TRANS                        
MFA-TR*           AND AR.CODE_TRAN_TYPE = 'B'                                   
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7210'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_AR_TRANS_HIST'       TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'DATE_TRANS'              TO TABLE-ELEMENT-2         
              MOVE AR-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE AR-DATE-TRANS             TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** THIS PARA IS USED TO GET AR-AMT-ORIG-ENTERED FROM             *        
      ** CSS_AR_TRANS_HIST TABLE.                                      *        
      ******************************************************************        
       7220-GET-PAYMENT-AMT.                                            
      *                                                                         
           EXEC SQL                                                     
                SELECT SUM(AMT_ORIG_ENTERED)                            
                  INTO  :AR-AMT-ORIG-ENTERED :WS-NULL-IND-6              
                  FROM CSS_AR_TRANS_HIST WITH(READUNCOMMITTED)                  
                 WHERE ACCOUNT_NO        = :AR-ACCOUNT-NO               
                   AND CODE_TRAN_TYPE    = 'P'                          
                   AND RECORD_ONLY_FL    <> 'Y'                         
ACT294             AND APPL_PROGRAM_ID   <> 'PANEL373C'                 
                   AND TRANS_HIST_SEQ_NO                                
                                 BETWEEN CIS.CHAR2TIMESTAMP(
                                           :WS-PREVBILL-AR-TRNSHIST-SEQ
              )   
                                     AND CIS.CHAR2TIMESTAMP(
                                           :WS-CURRBILL-AR-TRNSHIST-SEQ
              )   
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT SUM(AMT_ORIG_ENTERED)                                    
MFA-TR*           INTO  :AR-AMT-ORIG-ENTERED:WS-NULL-IND-6                      
MFA-TR*           FROM CSS_AR_TRANS_HIST                                        
MFA-TR*          WHERE ACCOUNT_NO        = :AR-ACCOUNT-NO                       
MFA-TR*            AND CODE_TRAN_TYPE    = 'P'                                  
MFA-TR*            AND RECORD_ONLY_FL    <> 'Y'                                 
MFA-TR*            AND APPL_PROGRAM_ID   <> 'PANEL373C'                         
MFA-TR*            AND TRANS_HIST_SEQ_NO                                        
MFA-TR*                          BETWEEN :WS-PREVBILL-AR-TRNSHIST-SEQ           
MFA-TR*                              AND :WS-CURRBILL-AR-TRNSHIST-SEQ           
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-NULL-IND-6 < 0                                         
              MOVE 0                         TO AR-AMT-ORIG-ENTERED     
           END-IF.                                                      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7220'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_AR_TRANS_HIST'       TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'MIN_TRNS_HIST_SEQ'       TO TABLE-ELEMENT-2         
              MOVE 'MAX_TRNS_HIST_SEQ'       TO TABLE-ELEMENT-3         
              MOVE AR-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE WS-PREVBILL-AR-TRNSHIST-SEQ                          
                                             TO HOSTVAR-ELEMENT-2       
              MOVE WS-CURRBILL-AR-TRNSHIST-SEQ                          
                                             TO HOSTVAR-ELEMENT-3       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  THIS PARAGRAPH SELECT THE SUM OF BILL_UNITS   FROM          **        
      **  CSS_BILL_CALC_DET TABLE FOR A GIVEN ACCOUNT NUMBER AND      **        
      **  IC-NO ONLY FOR BACK OUT ITEMS                               **        
      ******************************************************************        
       7230-GET-BILL-UNITS.                                             
      *                                                                         
           EXEC SQL                                                     
              SELECT SUM(BILL_UNITS)                                    
                    ,SUM(READ_UNITS)                                    
                INTO :WS-ACCUM-NO-UNITS :WS-NULL-IND-4                
                    ,:WS-ACCUM-READ-UNITS :WS-NULL-IND-5                
              FROM CSS_BILL_CALC_DET BZ WITH(READUNCOMMITTED)                   
              WHERE BZ.ACCOUNT_NO           = :BZ-ACCOUNT-NO            
                AND BZ.CODE_UTIL_TYPE       = :BZ-CODE-UTIL-TYPE        
                AND BZ.IC_NO                = :BZ-IC-NO                 
                AND BZ.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :BZ-BILL-ITEM-TIMESTMP
              )      
                AND (CMPNT_ID_CD NOT IN ('92','93'))                    
                AND INSTR_USE_TYPE_CD  = 'R'                            
                                                                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SUM(BILL_UNITS)                                            
MFA-TR*             ,SUM(READ_UNITS)                                            
MFA-TR*         INTO :WS-ACCUM-NO-UNITS   :WS-NULL-IND-4                        
MFA-TR*             ,:WS-ACCUM-READ-UNITS :WS-NULL-IND-5                        
MFA-TR*       FROM CSS_BILL_CALC_DET BZ                                         
MFA-TR*       WHERE BZ.ACCOUNT_NO           = :BZ-ACCOUNT-NO                    
MFA-TR*         AND BZ.CODE_UTIL_TYPE       = :BZ-CODE-UTIL-TYPE                
MFA-TR*         AND BZ.IC_NO                = :BZ-IC-NO                         
MFA-TR*         AND BZ.BILL_ITEM_TIMESTMP = :BZ-BILL-ITEM-TIMESTMP              
MFA-TR*         AND (CMPNT_ID_CD NOT IN ('92','93'))                            
MFA-TR*         AND INSTR_USE_TYPE_CD  = 'R'                                    
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
              IF WS-NULL-IND-4 < 0                                      
                 MOVE 0                      TO WS-ACCUM-NO-UNITS       
              END-IF                                                    
              IF WS-NULL-IND-5 < 0                                      
                 MOVE 0                      TO WS-ACCUM-READ-UNITS     
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7230'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_BILL_CALC_DET'       TO TABLE-1                 
              MOVE 'CSS_BILLING_HDR'         TO TABLE-2                 
              MOVE 'ACCOUNT_NO  '            TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE 'DATE_BILLED'             TO TABLE-ELEMENT-3         
              MOVE 'IC_NO'                   TO TABLE-ELEMENT-4         
              MOVE BZ-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE BZ-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              MOVE BI-DATE-BILLED            TO HOSTVAR-ELEMENT-3       
              MOVE BZ-IC-NO                  TO HOSTVAR-ELEMENT-4       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT
           END-IF.           
      *                                                                         
       7230-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  THIS PARAGRAPH CHECKS WHETHER THE GIVEN BG-RATE-PLAN-NO     **        
      **  BELONGS TO INDUSTRIAL GAS OR NET-METRING CUSTOMER           **        
      ******************************************************************        
       7240-CHECK-INDUS-CUST.                                           
      *                                                                         
           EXEC SQL                                                     
             SELECT TOP(1) J1.REG_TYPE_CD,
              J1.BAL_FWD_CD                                       
               INTO :WS-REG-TYPE-CD                                     
                   ,:WS-BAL-FWD-CD                                      
               FROM CSS_RATE_COMP_DEF J1 WITH(READUNCOMMITTED)                  
              WHERE J1.RATE_PLAN_NO           = :BG-RATE-PLAN-NO        
                AND J1.CODE_UTIL_TYPE         = :BG-CODE-UTIL-TYPE      
                AND J1.VERSION_NO_CNTRL       =                         
                    (SELECT MAX(A1.VERSION_NO_CNTRL)                    
                       FROM CSS_RATE_COMP_DEF A1 WITH(READUNCOMMITTED)          
                      WHERE A1.RATE_PLAN_NO   = :BG-RATE-PLAN-NO        
                        AND A1.CODE_UTIL_TYPE = :BG-CODE-UTIL-TYPE)     
                                                    
                                                                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT J1.REG_TYPE_CD                                              
MFA-TR*            ,J1.BAL_FWD_CD                                               
MFA-TR*        INTO :WS-REG-TYPE-CD                                             
MFA-TR*            ,:WS-BAL-FWD-CD                                              
MFA-TR*        FROM CSS_RATE_COMP_DEF J1                                        
MFA-TR*       WHERE J1.RATE_PLAN_NO           = :BG-RATE-PLAN-NO                
MFA-TR*         AND J1.CODE_UTIL_TYPE         = :BG-CODE-UTIL-TYPE              
MFA-TR*         AND J1.VERSION_NO_CNTRL       =                                 
MFA-TR*             (SELECT MAX(A1.VERSION_NO_CNTRL)                            
MFA-TR*                FROM CSS_RATE_COMP_DEF A1                                
MFA-TR*               WHERE A1.RATE_PLAN_NO   = :BG-RATE-PLAN-NO                
MFA-TR*                 AND A1.CODE_UTIL_TYPE = :BG-CODE-UTIL-TYPE)             
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL OR NOT-FOUND
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7240'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_RATE_COMP_DEF'       TO TABLE-1                 
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE BG-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-1       
              MOVE BG-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       7240-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P00899******************************************************************        
P00899**  THIS PARA CHECK WHETHER THE ACCT HAS ENTRY IN REG READ TABLE**        
P00899**  AT IC LEVEL.                                                **        
P00899******************************************************************        
P00899 7245-CHECK-IC-REGISTER.                                          
P00899*                                                                 19935000
P00899     EXEC SQL                                                     
P00899        SELECT TOP(1) 'Y'                                                
P00899         INTO  :WS-MULT-REG-FLG                                   
P00899          FROM CSS_REGISTER_READ WITH(READUNCOMMITTED)                    
P00899         WHERE CODE_UTIL_TYPE  =  :BG-CODE-UTIL-TYPE              
P00899           AND IC_NO           =  :BG-IC-NO                       
P00899           AND ACCOUNT_NO      =  :BG-ACCOUNT-NO                  
P00899                                              
P00899                                                           
P00899     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     19936000
MFA-TR*       SELECT 'Y'                                                19937000
MFA-TR*        INTO  :WS-MULT-REG-FLG                                   19938000
MFA-TR*         FROM CSS_REGISTER_READ                                  19939000
MFA-TR*        WHERE CODE_UTIL_TYPE  =  :BG-CODE-UTIL-TYPE              19940000
MFA-TR*          AND IC_NO           =  :BG-IC-NO                       19950000
MFA-TR*          AND ACCOUNT_NO      =  :BG-ACCOUNT-NO                  19950000
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                    19960000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00899                                                                  
P00899     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
P00899                                                                  
P00899     IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL OR NOT-FOUND
P00899        IF WS-ACTIVE-RETURN-CODE  EQUAL  NOT-FOUND                
P00899           MOVE WS-NO                   TO WS-MULT-REG-FLG        
P00899        END-IF                                                    
P00899        ADD +1                     TO WS-IC-COUNT                 
P00899        SET WS-IC-INDX             TO WS-IC-COUNT                 
P00899        MOVE WS-MULT-REG-FLG       TO WS-MULT-REG-FL(WS-IC-INDX)  
P00899        MOVE BG-IC-NO              TO WS-IC-NO(WS-IC-INDX)        
P00899        MOVE BG-CODE-UTIL-TYPE     TO WS-UTIL-TYPE(WS-IC-INDX)    
P00899     ELSE                                                         
P00899        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
P00899        MOVE '7245'                     TO ACTIVE-PARAGRAPH       
P00899        MOVE 'SELECT'                   TO ABEND-FUNCTION         
P00899        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
P00899                                           ABEND-TABLES           
P00899        MOVE 'CSS_REGISTER_READ'        TO TABLE-1                
P00899        MOVE 'IC_NO'                    TO TABLE-ELEMENT-1        
P00899        MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
P00899        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-3        
P00899        MOVE BG-IC-NO                   TO HOSTVAR-ELEMENT-1      
P00899        MOVE BG-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2      
P00899        MOVE BG-ACCOUNT-NO              TO HOSTVAR-ELEMENT-3      
P00899        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
P00899     END-IF.                                                      
P00899*                                                                         
P00899 7245-EXIT.                                                       
P00899      EXIT.                                                       
P00899*                                                                         
      ******************************************************************        
      **  THIS PARAGRAPH RETRIEVE THE RATE PLAN DESC FOR THE GIVEN    **        
      **  RD-RATE-PLAN-NO                                             **        
      ******************************************************************        
       7250-SELECT-RATE-DESC.                                           
      *                                                                 19935000
           EXEC SQL                                                     
              SELECT RATE_DESC                                          
P00821              ,UNMTR_PROV_FL                                      
P00899              ,SECURED_RATE_FL                                    
               INTO  :RD-RATE-DESC                                      
P00821              ,:RD-UNMTR-PROV-FL                                  
P00899              ,:RD-SECURED-RATE-FL                                
                FROM CSS_RATE_PLAN_DESC WITH(READUNCOMMITTED)                   
               WHERE CODE_UTIL_TYPE  =  :RD-CODE-UTIL-TYPE              
                 AND RATE_PLAN_NO    =  :RD-RATE-PLAN-NO                
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     19936000
MFA-TR*       SELECT RATE_DESC                                          19937000
MFA-TR*             ,UNMTR_PROV_FL                                              
MFA-TR*             ,SECURED_RATE_FL                                            
MFA-TR*        INTO  :RD-RATE-DESC                                      19938000
MFA-TR*             ,:RD-UNMTR-PROV-FL                                  19938000
MFA-TR*             ,:RD-SECURED-RATE-FL                                19938000
MFA-TR*         FROM CSS_RATE_PLAN_DESC                                 19939000
MFA-TR*        WHERE CODE_UTIL_TYPE  =  :RD-CODE-UTIL-TYPE              19940000
MFA-TR*          AND RATE_PLAN_NO    =  :RD-RATE-PLAN-NO                19950000
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                    19960000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL OR NOT-FOUND
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7250'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_RATE_PLAN_DESC'       TO TABLE-1                
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-3        
              MOVE RD-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-1      
              MOVE RD-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2      
              MOVE BG-ACCOUNT-NO              TO HOSTVAR-ELEMENT-3      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       7250-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      **  THIS PARAGRAPH RETRIEVE THE OPTION CD DESC FOR THE GIVEN    **        
      **  BG-RT-PKG-OPT-SEQ-NO.                                       **        
      ******************************************************************        
       7260-GET-OPTION-DESC.                                            
                                                                        
           EXEC SQL                                                     
              SELECT FI.OPT_DESC_INT                                    
                    ,FI.OPTION_CD                                       
                INTO :FI-OPT-DESC-INT                                   
                    ,:FI-OPTION-CD                                      
                FROM CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)                 
                    ,CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)                 
               WHERE DF.ACCOUNT_NO         = :DF-ACCOUNT-NO             
                 AND DF.CODE_UTIL_TYPE     = :DF-CODE-UTIL-TYPE         
                 AND DF.IC_NO              = :DF-IC-NO                  
                 AND DF.RT_PKG_OPT_SEQ_NO  = :DF-RT-PKG-OPT-SEQ-NO      
                 AND DF.OPTION_CD          = FI.OPTION_CD               
      *          AND FI.OPTION_START_DT   <= CURRENT DATE                       
      *          AND FI.OPTION_END_DT     >= CURRENT DATE                       
                 AND FI.OPT_VSTART_TS     <= CIS.CURRENT$TIMESTAMP()          
                 AND FI.OPT_VEND_TS       >= CIS.CURRENT$TIMESTAMP()          
                 AND FI.PROC_STATUS_CD     = 'AC'                       
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT FI.OPT_DESC_INT                                            
MFA-TR*             ,FI.OPTION_CD                                               
MFA-TR*         INTO :FI-OPT-DESC-INT                                           
MFA-TR*             ,:FI-OPTION-CD                                              
MFA-TR*         FROM CSS_ACCT_RTPK_AGR DF                                       
MFA-TR*             ,CRM_RT_PKG_OPTION FI                                       
MFA-TR*        WHERE DF.ACCOUNT_NO         = :DF-ACCOUNT-NO                     
MFA-TR*          AND DF.CODE_UTIL_TYPE     = :DF-CODE-UTIL-TYPE                 
MFA-TR*          AND DF.IC_NO              = :DF-IC-NO                          
MFA-TR*          AND DF.RT_PKG_OPT_SEQ_NO  = :DF-RT-PKG-OPT-SEQ-NO              
MFA-TR*          AND DF.OPTION_CD          = FI.OPTION_CD                       
MFA-TR*          AND FI.OPTION_START_DT   <= CURRENT DATE                       
MFA-TR*          AND FI.OPTION_END_DT     >= CURRENT DATE                       
MFA-TR*          AND FI.OPT_VSTART_TS     <= CURRENT TIMESTAMP                  
MFA-TR*          AND FI.OPT_VEND_TS       >= CURRENT TIMESTAMP                  
MFA-TR*          AND FI.PROC_STATUS_CD     = 'AC'                               
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE SPACES                   TO FI-OPT-DESC-INT       
                 MOVE SPACES                   TO FI-OPTION-CD          
              ELSE                                                      
                MOVE '7260'                    TO ACTIVE-PARAGRAPH      
                MOVE PROGRAM-NAME              TO ABEND-PROGRAM         
                MOVE 'SELECT'                  TO ABEND-FUNCTION        
                MOVE 'CSS_ACCT_RTPK_AGR'       TO TABLE-1               
                MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1       
                MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2       
                MOVE 'IC_NO'                   TO TABLE-ELEMENT-3       
                MOVE 'RT_PKG_OPT_SEQ_NO'       TO TABLE-ELEMENT-4       
                MOVE DF-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1     
                MOVE DF-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2     
                MOVE DF-IC-NO                  TO HOSTVAR-ELEMENT-3     
                MOVE DF-RT-PKG-OPT-SEQ-NO      TO HOSTVAR-ELEMENT-4     
                PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT          
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7260-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  THIS PARAGRAPH RETRIEVE THE OPTION CD DESC FOR THE GIVEN    **        
      **  UT-RT-PKG-OPT-SEQ-NO                                        **        
      ******************************************************************        
       7265-GET-OPTION-DESC.                                            
                                                                        
           EXEC SQL                                                     
              SELECT FI.OPT_DESC_INT                                    
                    ,FI.OPTION_CD                                       
                INTO :FI-OPT-DESC-INT                                   
                    ,:FI-OPTION-CD                                      
                FROM CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)                 
                    ,CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)                 
                    ,CSS_UTIL_ENVRNMT  UT WITH(READUNCOMMITTED)                 
               WHERE UT.ACCOUNT_NO         = :UT-ACCOUNT-NO             
                 AND UT.CODE_UTIL_TYPE     = :UT-CODE-UTIL-TYPE         
                 AND UT.IC_NO              = :UT-IC-NO                  
                 AND DF.ACCOUNT_NO         = UT.ACCOUNT_NO              
                 AND DF.CODE_UTIL_TYPE     = UT.CODE_UTIL_TYPE          
                 AND DF.IC_NO              = UT.IC_NO                   
                 AND DF.RT_PKG_OPT_SEQ_NO  = UT.RT_PKG_OPT_SEQ_NO       
                 AND DF.OPTION_CD          = FI.OPTION_CD               
      *          AND FI.OPTION_START_DT   <= CURRENT DATE                       
      *          AND FI.OPTION_END_DT     >= CURRENT DATE                       
                 AND FI.OPT_VSTART_TS     <= CIS.CURRENT$TIMESTAMP()          
                 AND FI.OPT_VEND_TS       >= CIS.CURRENT$TIMESTAMP()          
                 AND FI.PROC_STATUS_CD     = 'AC'                       
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT FI.OPT_DESC_INT                                            
MFA-TR*             ,FI.OPTION_CD                                               
MFA-TR*         INTO :FI-OPT-DESC-INT                                           
MFA-TR*             ,:FI-OPTION-CD                                              
MFA-TR*         FROM CSS_ACCT_RTPK_AGR DF                                       
MFA-TR*             ,CRM_RT_PKG_OPTION FI                                       
MFA-TR*             ,CSS_UTIL_ENVRNMT  UT                                       
MFA-TR*        WHERE UT.ACCOUNT_NO         = :UT-ACCOUNT-NO                     
MFA-TR*          AND UT.CODE_UTIL_TYPE     = :UT-CODE-UTIL-TYPE                 
MFA-TR*          AND UT.IC_NO              = :UT-IC-NO                          
MFA-TR*          AND DF.ACCOUNT_NO         = UT.ACCOUNT_NO                      
MFA-TR*          AND DF.CODE_UTIL_TYPE     = UT.CODE_UTIL_TYPE                  
MFA-TR*          AND DF.IC_NO              = UT.IC_NO                           
MFA-TR*          AND DF.RT_PKG_OPT_SEQ_NO  = UT.RT_PKG_OPT_SEQ_NO               
MFA-TR*          AND DF.OPTION_CD          = FI.OPTION_CD                       
MFA-TR*          AND FI.OPTION_START_DT   <= CURRENT DATE                       
MFA-TR*          AND FI.OPTION_END_DT     >= CURRENT DATE                       
MFA-TR*          AND FI.OPT_VSTART_TS     <= CURRENT TIMESTAMP                  
MFA-TR*          AND FI.OPT_VEND_TS       >= CURRENT TIMESTAMP                  
MFA-TR*          AND FI.PROC_STATUS_CD     = 'AC'                               
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE SPACES                   TO FI-OPT-DESC-INT       
                 MOVE SPACES                   TO FI-OPTION-CD          
              ELSE                                                      
                MOVE '7265'                    TO ACTIVE-PARAGRAPH      
                MOVE PROGRAM-NAME              TO ABEND-PROGRAM         
                MOVE 'SELECT'                  TO ABEND-FUNCTION        
                MOVE 'CSS_ACCT_RTPK_AGR'       TO TABLE-1               
                MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1       
                MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2       
                MOVE 'IC_NO'                   TO TABLE-ELEMENT-3       
                MOVE UT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1     
                MOVE UT-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2     
                MOVE UT-IC-NO                  TO HOSTVAR-ELEMENT-3     
                PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT          
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7265-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7270-GET-DATABASE                                             *         
      *     SELECTS BILLING ENTITY (SEB OR SCEG) FROM CSS_DELINQUENCY *         
      *****************************************************************         
       7270-GET-DATABASE.                                               
                                                                        
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE DELINQ_CD  = :C8-DELINQ-CD                         
                 AND COMPANY_NO = :C8-COMPANY-NO                        
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD  = :C8-DELINQ-CD                                 
MFA-TR*          AND COMPANY_NO = :C8-COMPANY-NO                                
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE C8-DELINQ-VALUE           TO WS-DATABASE             
           ELSE                                                         
              MOVE '7270'                    TO ACTIVE-PARAGRAPH        
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_DELINQUENCY'         TO TABLE-1                 
              MOVE 'DELINQ_CD'               TO TABLE-ELEMENT-1         
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-2         
              MOVE C8-DELINQ-CD              TO HOSTVAR-ELEMENT-1       
              MOVE C8-COMPANY-NO             TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       7270-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************19485000
      **  THIS PARAGRAPH IS USED TO SELECT THE CODES-DATA-PRESENT     **19486000
      **  FIELD FROM THE CSS-ACCOUNT TABLE.                           **19487000
      ******************************************************************19488000
       7280-SELECT-AT.                                                  
      *                                                                         
           EXEC SQL                                                     
              SELECT MST_SUB_ACCT_IND                                   
                    ,CODE_COMPANY_ACCT                                  
                    ,REV_MTH_LST_NRML                                   
P00821              ,COMPANY_NO                                         
P00899              ,REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS                         
P00836              ,ACCOUNT_TYPE_CODE                                  
P00836              ,BILL_CYCLE                                         
                INTO :AT-MST-SUB-ACCT-IND                               
                    ,:AT-CODE-COMPANY-ACCT                              
                    ,:AT-REV-MTH-LST-NRML                               
P00821              ,:AT-COMPANY-NO                                     
P00899              ,:AT-LAST-UPDATE-TS                                 
P00836              ,:AT-ACCOUNT-TYPE-CODE                              
P00836              ,:AT-BILL-CYCLE                                     
                FROM CSS_ACCOUNT     AT WITH(READUNCOMMITTED)                   
               WHERE ACCOUNT_NO      =  :AT-ACCOUNT-NO                  
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     19489000
MFA-TR*       SELECT MST_SUB_ACCT_IND                                   19491000
MFA-TR*             ,CODE_COMPANY_ACCT                                          
MFA-TR*             ,REV_MTH_LST_NRML                                           
MFA-TR*             ,COMPANY_NO                                                 
MFA-TR*             ,LAST_UPDATE_TS                                             
MFA-TR*             ,ACCOUNT_TYPE_CODE                                          
MFA-TR*             ,BILL_CYCLE                                                 
MFA-TR*         INTO :AT-MST-SUB-ACCT-IND                               19501000
MFA-TR*             ,:AT-CODE-COMPANY-ACCT                                      
MFA-TR*             ,:AT-REV-MTH-LST-NRML                                       
MFA-TR*             ,:AT-COMPANY-NO                                             
MFA-TR*             ,:AT-LAST-UPDATE-TS                                         
MFA-TR*             ,:AT-ACCOUNT-TYPE-CODE                                      
MFA-TR*             ,:AT-BILL-CYCLE                                             
MFA-TR*         FROM CSS_ACCOUNT     AT                                 19510000
MFA-TR*        WHERE ACCOUNT_NO      =  :AT-ACCOUNT-NO                  19520000
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                    19530000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE  =  SUCCESSFUL-CALL                 
              MOVE AT-MST-SUB-ACCT-IND       TO WS-MST-SUB-ACCT-IND     
              MOVE AT-REV-MTH-LST-NRML       TO WS-CUTOF-REV-MNTH       
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7280'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_ACCOUNT'             TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                 19488000
       7280-EXIT.                                                       
            EXIT.                                                       
      *                                                                 19488000
      ******************************************************************19664000
      **  THIS PARAGRAPH IS USED TO FETCH A SINGLE ROW FROM THE       **19664100
      **  HT-CURSOR BASED ON AN ACCOUNT NUMBER.  ONE ADDRESS-ID ONLY. **19664200
      ******************************************************************19664300
       7290-SELECT-ADDR-ID.                                             
      *                                                                 19664500
           EXEC SQL                                                     
              SELECT DISTINCT (ADDRESS_ID)                              
                INTO :HT-ADDRESS-ID                                     
                FROM CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)                
               WHERE ACCOUNT_NO          = :HT-ACCOUNT-NO               
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     19664600
MFA-TR*       SELECT DISTINCT (ADDRESS_ID)                              05117000
MFA-TR*         INTO :HT-ADDRESS-ID                                     19664800
MFA-TR*         FROM CSS_NAME_ACCT_XREF HT                              05119100
MFA-TR*        WHERE ACCOUNT_NO          = :HT-ACCOUNT-NO               05119200
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                    19664900

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 19665000
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE  =  SUCCESSFUL-CALL OR NOT-FOUND    
              MOVE HT-ADDRESS-ID             TO DY-ADDRESS-ID           
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7290'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_NAME_ACCT_XREF'      TO TABLE-1                 
              MOVE 'ACCOUNT_NO  '            TO TABLE-ELEMENT-1         
              MOVE HT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                 19731100
       7290-EXIT.                                                       
            EXIT.                                                       
      *                                                                 19731100
      ******************************************************************19664000
      **  THIS PARAGRAPH IS USED TO FETCH THE SERVICE ADDRESS USING   **19664100
      **  THE ADDRESS-ID FROM HT TABLE.                               **19664200
      ******************************************************************19664300
       7300-SELECT-DY.                                                  
      *                                                                 19731200
           EXEC SQL                                                     
              SELECT HOUSE_NO                                           
                    ,ADDR_PREFIX_1                                      
                    ,ADDR_PREFIX_2                                      
                    ,STREET_NAME                                        
                    ,STREET_LOCATION_1                                  
                    ,STREET_LOCATION_2                                  
                    ,STREET_SUFFIX                                      
                    ,ZIP_CODE                                           
               INTO  :DY-HOUSE-NO                                       
                    ,:DY-ADDR-PREFIX-1                                  
                    ,:DY-ADDR-PREFIX-2                                  
                    ,:DY-STREET-NAME                                    
                    ,:DY-STREET-LOCATION-1                              
                    ,:DY-STREET-LOCATION-2                              
                    ,:DY-STREET-SUFFIX                                  
                    ,:DY-ZIP-CODE                                       
                FROM CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED)                
               WHERE ADDRESS_ID     =  :DY-ADDRESS-ID                   
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     19734100
MFA-TR*       SELECT HOUSE_NO                                           19735000
MFA-TR*             ,ADDR_PREFIX_1                                      19736000
MFA-TR*             ,ADDR_PREFIX_2                                      19737000
MFA-TR*             ,STREET_NAME                                        19738000
MFA-TR*             ,STREET_LOCATION_1                                  19739000
MFA-TR*             ,STREET_LOCATION_2                                  19740000
MFA-TR*             ,STREET_SUFFIX                                      19750000
MFA-TR*             ,ZIP_CODE                                           19760000
MFA-TR*        INTO  :DY-HOUSE-NO                                       19770000
MFA-TR*             ,:DY-ADDR-PREFIX-1                                  19780000
MFA-TR*             ,:DY-ADDR-PREFIX-2                                  19790000
MFA-TR*             ,:DY-STREET-NAME                                    19800000
MFA-TR*             ,:DY-STREET-LOCATION-1                              19810000
MFA-TR*             ,:DY-STREET-LOCATION-2                              19820000
MFA-TR*             ,:DY-STREET-SUFFIX                                  19830000
MFA-TR*             ,:DY-ZIP-CODE                                       19840000
MFA-TR*         FROM CSS_ADDR_FORMATTED DY                              19850000
MFA-TR*        WHERE ADDRESS_ID     =  :DY-ADDRESS-ID                   19860000
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                    19870000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE  =  SUCCESSFUL-CALL OR NOT-FOUND    
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7300'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_ADDR_FORMATTED'      TO TABLE-1                 
              MOVE 'ADDRESS_ID  '            TO TABLE-ELEMENT-1         
              MOVE DY-ADDRESS-ID             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                 19932000
       7300-EXIT.                                                       
            EXIT.                                                       
      *                                                                 19932000
P00821******************************************************************19485000
P00821* 7310-CHECK-BILL-ADJUSTMNT                                      *19486000
P00821******************************************************************19487000
P00821*                                                                 19488000
P00821 7310-CHECK-BILL-ADJUSTMNT.                                       
P00821*                                                                 19488000
P00821      EXEC SQL                                                    
P00821         SELECT TOP(1) 'Y'                                               
P00821           INTO :WS-BILL-ADJ-EXIST                                
P00821           FROM  CSS_BILL_ADJUSTMNT   BP WITH(READUNCOMMITTED)            
P00821                ,CSS_BILLING_DET      BG WITH(READUNCOMMITTED)            
P00821          WHERE  BP.ACCOUNT_NO         = :BP-ACCOUNT-NO           
P00821            AND  BP.BILL_NO            = :BP-BILL-NO              
P00821            AND  BG.ACCOUNT_NO         =  BP.ACCOUNT_NO           
P00821            AND  BG.BILL_NO            =  BP.BILL_NO              
P00821            AND  BG.CODE_UTIL_TYPE     =  BP.CODE_UTIL_TYPE       
P00821            AND  BG.IC_NO              =  BP.IC_NO                
P00821            AND  BG.BILL_ITEM_TIMESTMP =  BP.BILL_ITEM_TIMESTMP   
P00821            AND  BG.CODE_BILL_CALC     = 'A'                      
P00821            AND  BG.CODE_BILL_ITM_TYPE = 'C'                      
P00821            AND  BG.CODE_BILL_ITM_IND  IN ('A','K')               
P00821                                              
P00821                                                           
P00821                                                      
P00821      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-BILL-ADJ-EXIST                                        
MFA-TR*          FROM  CSS_BILL_ADJUSTMNT   BP                                  
MFA-TR*               ,CSS_BILLING_DET      BG                                  
MFA-TR*         WHERE  BP.ACCOUNT_NO         = :BP-ACCOUNT-NO                   
MFA-TR*           AND  BP.BILL_NO            = :BP-BILL-NO                      
MFA-TR*           AND  BG.ACCOUNT_NO         =  BP.ACCOUNT_NO                   
MFA-TR*           AND  BG.BILL_NO            =  BP.BILL_NO                      
MFA-TR*           AND  BG.CODE_UTIL_TYPE     =  BP.CODE_UTIL_TYPE               
MFA-TR*           AND  BG.IC_NO              =  BP.IC_NO                        
MFA-TR*           AND  BG.BILL_ITEM_TIMESTMP =  BP.BILL_ITEM_TIMESTMP           
MFA-TR*           AND  BG.CODE_BILL_CALC     = 'A'                              
MFA-TR*           AND  BG.CODE_BILL_ITM_TYPE = 'C'                              
MFA-TR*           AND  BG.CODE_BILL_ITM_IND  IN ('A','K')                       
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*          WITH UR                                                19540000
MFA-TR*       QUERYNO 7310                                                      
MFA-TR*     END-EXEC.                                                   19550000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00821                                                                  
P00821      MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.  
P00821                                                                  
P00821      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
P00821         IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
P00821            MOVE 'N'                   TO WS-BILL-ADJ-EXIST       
P00821         END-IF                                                   
P00821      ELSE                                                        
P00821        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
P00821        MOVE '7310'                    TO ACTIVE-PARAGRAPH        
P00821        MOVE 'SELECT'                  TO ABEND-FUNCTION          
P00821        MOVE SPACES                    TO ABEND-SQL-PREDICATES    
P00821                                          ABEND-TABLES            
P00821        MOVE 'CSS_BILL_ADJUSTMNT'      TO TABLE-1                 
P00821        MOVE 'BILL_NO'                 TO TABLE-ELEMENT-1         
P00821        MOVE BP-BILL-NO                TO HOSTVAR-ELEMENT-1       
P00821        MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-2         
P00821        MOVE BP-ACCOUNT-NO             TO HOSTVAR-ELEMENT-2       
P00821        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
P00821      END-IF.                                                     
P00821                                                                  
P00821 7310-EXIT.                                                       
P00821     EXIT.                                                        
P00821*                                                                 19488000
P00836******************************************************************        
P00836** SELECT REVENUE MONTH FOR WEB USING ACCOUNT NO & BILL NO.     **00110000
P00836** IF CANCEL REBILL IMMEDIATE(NO BG WITH REV_MTH_ORIG_BILL=0),  **        
P00836** USE MAX OF REV MTH ORIG BILL; ELSE USE MAX OF REVENUE MONTH  **        
P00836******************************************************************        
P00836*                                                                         
P00836 7400-GET-REV-MTH-WEB-DFLT.                                       
P00836*                                                                         
P00836     EXEC SQL                                                     
P00836          SELECT COALESCE(CASE                                      
P00836                        WHEN (MIN(BG.REV_MTH_ORIG_BILL) = 0)      
P00836                        THEN  MAX(BG.REVENUE_MONTH)               
P00836                        ELSE  MAX(BG.REV_MTH_ORIG_BILL)           
P00836                        END,0)                                    
P00836            INTO :WS-WEB-REV-MTH-CURR                             
P00836            FROM CSS_BILLING_DET BG WITH(READUNCOMMITTED)                 
P00836           WHERE ACCOUNT_NO  =  :S1-ACCOUNT-NO                    
P00836             AND BILL_NO     =  :S1-BILL-NO                       
P00836                                                           
P00836     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT IFNULL(CASE                                              
MFA-TR*                       WHEN (MIN(BG.REV_MTH_ORIG_BILL) = 0)              
MFA-TR*                       THEN  MAX(BG.REVENUE_MONTH)                       
MFA-TR*                       ELSE  MAX(BG.REV_MTH_ORIG_BILL)                   
MFA-TR*                       END,0)                                            
MFA-TR*           INTO :WS-WEB-REV-MTH-CURR                                     
MFA-TR*           FROM CSS_BILLING_DET BG                                       
MFA-TR*          WHERE ACCOUNT_NO  =  :S1-ACCOUNT-NO                            
MFA-TR*            AND BILL_NO     =  :S1-BILL-NO                               
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00836*                                                                 43529000
P00836     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
P00836*                                                                 43529300
P00836     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00836        CONTINUE                                                  
P00836     ELSE                                                         
P00836        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
P00836        MOVE '7400'                    TO ACTIVE-PARAGRAPH        
P00836        MOVE 'SELECT'                  TO ABEND-FUNCTION          
P00836        MOVE SPACES                    TO ABEND-SQL-PREDICATES    
P00836                                          ABEND-TABLES            
P00836        MOVE 'CSS_BILLING_DET'         TO TABLE-1                 
P00836        MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
P00836        MOVE S1-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
P00836        MOVE 'BILL_NO'                 TO TABLE-ELEMENT-2         
P00836        MOVE S1-BILL-NO                TO HOSTVAR-ELEMENT-2       
P00836        PERFORM 9700-PROCESS-ABEND     THRU  9700-EXIT            
P00836     END-IF.                                                      
P00836*                                                                         
P00836 7400-EXIT.                                                       
P00836     EXIT.                                                        
P00836*                                                                         
P00836******************************************************************        
P00836** SELECT REVENUE MONTH FOR WEB USING BILL CYCLE & DATE BILLED  **00110000
P00836******************************************************************        
P00836*                                                                         
P00836 7410-GET-REV-MTH-WEB-BN-1.                                       
P00836*                                                                         
P00836     EXEC SQL                                                     
P00836          SELECT COALESCE(BN.REVENUE_MONTH,0)                       
P00836            INTO :WS-WEB-REV-MTH-CURR                             
P00836            FROM CSS_BILL_WINDOW  BN WITH(READUNCOMMITTED)                
P00836           WHERE BN.DATE_EXTRACT  =  IIF(TRY_CONVERT(DATE, 
                                                       :BN-DATE-EXTRACT
              ) IS NULL OR (PATINDEX('%.%', :BN-DATE-EXTRACT
              ) <> 0) OR (LEN(:BN-DATE-EXTRACT) <> 10), CIS.CHAR2DATE(
                                                       :BN-DATE-EXTRACT
              ), CONVERT(DATE, :BN-DATE-EXTRACT) )             
P00836             AND BN.BILL_CYCLE    =  :BN-BILL-CYCLE               
P00836                                                           
P00836     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT IFNULL(BN.REVENUE_MONTH,0)                               
MFA-TR*           INTO :WS-WEB-REV-MTH-CURR                                     
MFA-TR*           FROM CSS_BILL_WINDOW  BN                                      
MFA-TR*          WHERE BN.DATE_EXTRACT  =  :BN-DATE-EXTRACT                     
MFA-TR*            AND BN.BILL_CYCLE    =  :BN-BILL-CYCLE                       
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00836*                                                                 43529000
P00836     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
P00836*                                                                 43529300
P00836     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00836        CONTINUE                                                  
P00836     ELSE                                                         
P00836        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
P00836        MOVE '7410'                    TO ACTIVE-PARAGRAPH        
P00836        MOVE 'SELECT'                  TO ABEND-FUNCTION          
P00836        MOVE SPACES                    TO ABEND-SQL-PREDICATES    
P00836                                          ABEND-TABLES            
P00836        MOVE 'CSS_BILLING_WINDOW'      TO TABLE-1                 
P00836        MOVE 'DATE_EXTRACT'            TO TABLE-ELEMENT-1         
P00836        MOVE BN-DATE-EXTRACT           TO HOSTVAR-ELEMENT-1       
P00836        MOVE 'BILL_CYCLE'              TO TABLE-ELEMENT-2         
P00836        MOVE BN-BILL-CYCLE             TO HOSTVAR-ELEMENT-2       
P00836        PERFORM 9700-PROCESS-ABEND     THRU  9700-EXIT            
P00836     END-IF.                                                      
P00836*                                                                         
P00836 7410-EXIT.                                                       
P00836     EXIT.                                                        
P00836*                                                                         
P00836******************************************************************        
P00836** SELECT REVENUE MONTH FOR WEB USING DATE BILLED               **00110000
P00836******************************************************************        
P00836*                                                                         
P00836 7420-GET-REV-MTH-WEB-BN-2.                                       
P00836*                                                                         
P00836     EXEC SQL                                                     
P00836          SELECT COALESCE(MIN(BN.REVENUE_MONTH),0)                  
P00836            INTO :WS-WEB-REV-MTH-CURR                             
P00836            FROM CSS_BILL_WINDOW  BN WITH(READUNCOMMITTED)                
P00836           WHERE BN.DATE_EXTRACT  =  IIF(TRY_CONVERT(DATE, 
                                                       :BN-DATE-EXTRACT
              ) IS NULL OR (PATINDEX('%.%', :BN-DATE-EXTRACT
              ) <> 0) OR (LEN(:BN-DATE-EXTRACT) <> 10), CIS.CHAR2DATE(
                                                       :BN-DATE-EXTRACT
              ), CONVERT(DATE, :BN-DATE-EXTRACT) )             
P00836                                                           
P00836     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT IFNULL(MIN(BN.REVENUE_MONTH),0)                          
MFA-TR*           INTO :WS-WEB-REV-MTH-CURR                                     
MFA-TR*           FROM CSS_BILL_WINDOW  BN                                      
MFA-TR*          WHERE BN.DATE_EXTRACT  =  :BN-DATE-EXTRACT                     
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00836*                                                                 43529000
P00836     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
P00836*                                                                 43529300
P00836     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00836        CONTINUE                                                  
P00836     ELSE                                                         
P00836        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
P00836        MOVE '7420'                    TO ACTIVE-PARAGRAPH        
P00836        MOVE 'SELECT'                  TO ABEND-FUNCTION          
P00836        MOVE SPACES                    TO ABEND-SQL-PREDICATES    
P00836                                          ABEND-TABLES            
P00836        MOVE 'CSS_BILLING_WINDOW'      TO TABLE-1                 
P00836        MOVE 'DATE_EXTRACT'            TO TABLE-ELEMENT-1         
P00836        MOVE BN-DATE-EXTRACT           TO HOSTVAR-ELEMENT-1       
P00836        MOVE 'BILL_CYCLE'              TO TABLE-ELEMENT-2         
P00836        MOVE BN-BILL-CYCLE             TO HOSTVAR-ELEMENT-2       
P00836        PERFORM 9700-PROCESS-ABEND     THRU  9700-EXIT            
P00836     END-IF.                                                      
P00836*                                                                         
P00836 7420-EXIT.                                                       
P00836     EXIT.                                                        
P00836*                                                                         
P00836******************************************************************        
P00836** CHECK ACTIVE/IN PROGRESS WQ WITH EBILL NO DISPLAY IND SET    **00110000
P00836******************************************************************        
P00836*                                                                         
P00836 7450-CHECK-EBILL-NO-DISP-IND.                                    
P00836*                                                                         
P00836     EXEC SQL                                                     
P00836          SELECT TOP(1) 'N'                                              
P00836            INTO :WS-SHOW-LATEST-BILL-FL                          
P00836            FROM CSS_WQ_CATEGORY C3 WITH(READUNCOMMITTED)                 
P00836                ,CSS_WQ_ITEMS    WQ WITH(READUNCOMMITTED)                 
P00836           WHERE WQ.ACCOUNT_NO        =  :S1-ACCOUNT-NO           
P00836             AND WQ.CATEGORY_ID       =   C3.CATEGORY_ID          
P00836             AND C3.EBILL_NO_DISP_IND =  'Y'                      
P00836             AND WQ.STATUS           IN ('A','I')                 
P00836                                       
P00836     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'N'                                                      
MFA-TR*           INTO :WS-SHOW-LATEST-BILL-FL                                  
MFA-TR*           FROM CSS_WQ_CATEGORY C3                                       
MFA-TR*               ,CSS_WQ_ITEMS    WQ                                       
MFA-TR*          WHERE WQ.ACCOUNT_NO        =  :S1-ACCOUNT-NO                   
MFA-TR*            AND WQ.CATEGORY_ID       =   C3.CATEGORY_ID                  
MFA-TR*            AND C3.EBILL_NO_DISP_IND =  'Y'                              
MFA-TR*            AND WQ.STATUS           IN ('A','I')                         
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00836*                                                                 43529000
P00836     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
P00836*                                                                 43529300
P00836     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00836        CONTINUE                                                  
P00836     ELSE                                                         
P00836        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
P00836        MOVE '7450'                    TO ACTIVE-PARAGRAPH        
P00836        MOVE 'SELECT'                  TO ABEND-FUNCTION          
P00836        MOVE SPACES                    TO ABEND-SQL-PREDICATES    
P00836                                          ABEND-TABLES            
P00836        MOVE 'CSS_WQ_ITEMS'            TO TABLE-1                 
P00836        MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
P00836        MOVE S1-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
P00836        PERFORM 9700-PROCESS-ABEND     THRU  9700-EXIT            
P00836     END-IF.                                                      
P00836*                                                                         
P00836 7450-EXIT.                                                       
P00836     EXIT.                                                        
P00836*                                                                         
P00836******************************************************************        
P00836** CHECK DATA EXISTS FOR LATEST BILL IN BILL CRED TABLE         **00110000
P00836******************************************************************        
P00836*                                                                         
P00836 7460-CHECK-BILL-CRED-DATA.                                       
P00836*                                                                         
P00836     EXEC SQL                                                     
P00836          SELECT TOP(1) [1H].ACCOUNT_NO                                   
P00836            INTO :1H-ACCOUNT-NO                                   
P00836            FROM  CSS_BILL_CRED_DET [1H] WITH(READUNCOMMITTED)            
P00836           WHERE  [1H].ACCOUNT_NO = :S1-ACCOUNT-NO                  
P00836             AND  [1H].BILL_NO    = :S1-BILL-NO                     
P00836                                       
P00836     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT  1H.ACCOUNT_NO                                           
MFA-TR*           INTO :1H-ACCOUNT-NO                                           
MFA-TR*           FROM  CSS_BILL_CRED_DET 1H                                    
MFA-TR*          WHERE  1H.ACCOUNT_NO = :S1-ACCOUNT-NO                          
MFA-TR*            AND  1H.BILL_NO    = :S1-BILL-NO                             
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00836*                                                                 43529000
P00836     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
P00836*                                                                 43529300
P00836     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00836        CONTINUE                                                  
P00836     ELSE                                                         
P00836        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
P00836        MOVE '7460'                    TO ACTIVE-PARAGRAPH        
P00836        MOVE 'SELECT'                  TO ABEND-FUNCTION          
P00836        MOVE SPACES                    TO ABEND-SQL-PREDICATES    
P00836                                          ABEND-TABLES            
P00836        MOVE 'CSS_WQ_ITEMS'            TO TABLE-1                 
P00836        MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
P00836        MOVE S1-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
P00836        MOVE 'BILL_NO'                 TO TABLE-ELEMENT-2         
P00836        MOVE S1-BILL-NO                TO HOSTVAR-ELEMENT-2       
P00836        PERFORM 9700-PROCESS-ABEND     THRU  9700-EXIT            
P00836     END-IF.                                                      
P00836*                                                                         
P00836 7460-EXIT.                                                       
P00836     EXIT.                                                        
P00836*                                                                         
P00836******************************************************************        
P00836** CHECK OFF CYCLE ACCT CODE                                    **00110000
P00836******************************************************************        
P00836*                                                                         
P00836*7470-CHECK-CODE-BILL-OFF-CYCL.                                           
P00836*                                                                         
P00836*    EXEC SQL                                                             
P00836*         SELECT 'N'                                                      
P00836*           INTO :WS-SHOW-LATEST-BILL-FL                                  
P00836*           FROM CSS_OFF_CYCL_ACCT OC                                     
P00836*          WHERE OC.ACCOUNT_NO         =  :S1-ACCOUNT-NO                  
P00836*            AND OC.CODE_BILL_OFF_CYCL =  'O'                             
P00836*         WITH UR                                                         
P00836*    END-EXEC.                                                            
P00836*                                                                 43529000
P00836*    MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  43529100
P00836*                                                                 43529300
P00836*    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      43920400
P00836*       CONTINUE                                                  43920500
P00836*    ELSE                                                         43920600
P00836*       MOVE PROGRAM-NAME              TO ABEND-PROGRAM           42271300
P00836*       MOVE '7470'                    TO ACTIVE-PARAGRAPH        42271400
P00836*       MOVE 'SELECT'                  TO ABEND-FUNCTION          42271601
P00836*       MOVE SPACES                    TO ABEND-SQL-PREDICATES    42271701
P00836*                                         ABEND-TABLES            42271801
P00836*       MOVE 'CSS_OFF_CYCL_ACCT'       TO TABLE-1                 0100    
P00836*       MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         0300    
P00836*       MOVE S1-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       3530    
P00836*       PERFORM 9700-PROCESS-ABEND     THRU  9700-EXIT            42272000
P00836*    END-IF.                                                      43921900
P00836*                                                                         
P00836*7470-EXIT.                                                               
P00836*    EXIT.                                                                
P00836*                                                                         
      ******************************************************************        
P00821* 7600-START-FCSJC01                                             *        
P00821*                                                                *        
P00821*     CALLED FROM 6251-GET-FJC01-DATE                            *        
P00821*******************************************************************       
P00821 7600-START-FCSJC01.                                              
P00821*                                                                         
P00821     EXEC SQL                                                     
P00821         OPEN PARM_CSR                                            
P00821     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00821                                                                  
P00821     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
P00821                                                                  
P00821     IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL                  
P00821         CONTINUE                                                 
P00821     ELSE                                                         
P00821        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
P00821        MOVE '7600'                TO ACTIVE-PARAGRAPH            
P00821        MOVE 'DECLARE'             TO ABEND-FUNCTION              
P00821        MOVE SPACES                TO ABEND-SQL-PREDICATES        
P00821                                      ABEND-TABLES                
P00821        MOVE 'CSS_JOB_PARM'        TO TABLE-1                     
P00821        MOVE WS-PGRMNAME           TO HOSTVAR-ELEMENT-1           
P00821        MOVE +100                  TO WS-ACTIVE-RETURN-CODE       
P00821        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
P00821     END-IF.                                                      
P00821*                                                                         
P00821 7600-FCSJC01-EXIT.                                               
P00821     EXIT.                                                        
P00821*                                                                         
P00821*******************************************************************       
P00821* 7610-READ-FCSJC01                                              *        
P00821*                                                                *        
P00821*                                                                *        
P00821*     CALLED FROM 6251-GET-FJC01-DATE                            *        
P00821*******************************************************************       
P00821 7610-READ-FCSJC01.                                               
P00821*                                                                         
P00821     EXEC SQL FETCH PARM_CSR                                      
P00821          INTO   :G6-PROGRAM-NAME                                 
P00821                ,:G6-COMPANY-NO                                   
P00821                ,:G6-CMND-CODE                                    
P00821                ,:G6-SEQ-NO                                       
P00821                ,:G6-STATUS                                       
P00821                ,:G6-PARM-DATA                                    
P00821     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00821                                                                  
P00821     IF SQLCODE EQUAL SUCCESSFUL-CALL                             
P00821         MOVE G6-SEQ-NO       TO E-FJC01-SEQ-NBR                  
P00821                                 WS-SEQ-NBR                       
P00821         MOVE G6-PROGRAM-NAME TO E-FJC01-PGRM-NAME                
P00821         MOVE G6-CMND-CODE    TO E-FJC01-CMND-CODE                
P00821         MOVE G6-STATUS       TO E-FJC01-STATUS                   
P00821                                 WS-INPUT-STATUS                  
P00821         MOVE G6-PARM-DATA    TO WS-CUTOFF-DATA-BREAKDOWN         
P00821                                 E-FJC01-PARAMETER-DATA           
P00821     ELSE                                                         
P00821     IF SQLCODE EQUAL NOT-FOUND                                   
P00821         MOVE 'END' TO WS-SYSIPT                                  
P00821         PERFORM 7611-CLOSE THRU 7611-EXIT                        
P00821     ELSE                                                         
P00821        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
P00821        MOVE '7610'                TO ACTIVE-PARAGRAPH            
P00821        MOVE 'FETCH'               TO ABEND-FUNCTION              
P00821        MOVE SPACES                TO ABEND-SQL-PREDICATES        
P00821                                      ABEND-TABLES                
P00821        MOVE 'CSS_JOB_PARM'        TO TABLE-1                     
P00821        MOVE WS-PGRMNAME           TO HOSTVAR-ELEMENT-1           
P00821        MOVE +100                  TO WS-ACTIVE-RETURN-CODE       
P00821        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
P00821     END-IF
           END-IF.                                                      
P00821                                                                  
P00821 7610-FCSJC01-EXIT.                                               
P00821     EXIT.                                                        
P00821*                                                                         
P00821*******************************************************************       
P00821* 7611-CLOSE                                                     *        
P00821*                                                                *        
P00821*     CALLED FROM 6251-GET-FJC01-DATE                            *        
P00821*******************************************************************       
P00821 7611-CLOSE.                                                      
P00821                                                                  
P00821     EXEC SQL                                                     
P00821         CLOSE PARM_CSR                                           
P00821     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00821                                                                  
P00821     IF SQLCODE = SUCCESSFUL-CALL                                 
P00821         CONTINUE                                                 
P00821     ELSE                                                         
P00821        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
P00821        MOVE '7611'                TO ACTIVE-PARAGRAPH            
P00821        MOVE 'CLOSE'               TO ABEND-FUNCTION              
P00821        MOVE SPACES                TO ABEND-SQL-PREDICATES        
P00821                                      ABEND-TABLES                
P00821        MOVE 'CSS_JOB_PARM'        TO TABLE-1                     
P00821        MOVE WS-PGRMNAME           TO HOSTVAR-ELEMENT-1           
P00821        MOVE +100                  TO WS-ACTIVE-RETURN-CODE       
P00821        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
P00821     END-IF.                                                      
P00821                                                                  
P00821 7611-EXIT.                                                       
P00821     EXIT.                                                        
P00821*                                                                         
P00899******************************************************************42270100
P00899* 7900-CHECK-BILL-RSLD.                                          *42270100
P00899* CHECK FOR OFF CYCLE ENTRY FOR FINAL BILL / IMMED CANCEL-REBILL *42270100
P00899* / FUTURE BILL                                                  *42270100
P00899******************************************************************42270100
P00899 7900-CHECK-BILL-RLSD.                                            
P00899                                                                  
P00899     EXEC SQL                                                     
P00899         SELECT TOP(1) 'Y'                                               
P00899           INTO :S2-BILL-RELEASED-FLG                             
P00899           FROM CSS_OFF_CYCL_ACCT  OC WITH(READUNCOMMITTED)               
P00899          WHERE OC.ACCOUNT_NO      = :OC-ACCOUNT-NO               
P00899            AND CODE_BILL_OFF_CYCL IN ('O','B',' ')               
P00899                                              
P00899                                                           
P00899     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     42270300
MFA-TR*        SELECT 'Y'                                               42270400
MFA-TR*          INTO :S2-BILL-RELEASED-FLG                                     
MFA-TR*          FROM CSS_OFF_CYCL_ACCT  OC                                     
MFA-TR*         WHERE OC.ACCOUNT_NO      = :OC-ACCOUNT-NO                       
MFA-TR*           AND CODE_BILL_OFF_CYCL IN ('O','B',' ')                       
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                    42270500

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00899                                                                  
P00899     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
P00899                                                                  
P00899     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00899         CONTINUE                                                 
P00899     ELSE                                                         
P00899         MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
P00899         MOVE '7900'                   TO ACTIVE-PARAGRAPH        
P00899         MOVE 'SELECT'                 TO ABEND-FUNCTION          
P00899         MOVE SPACES                   TO ABEND-SQL-PREDICATES    
P00899                                          ABEND-TABLES            
P00899         MOVE 'CSS_OFF_CYCL_ACCT'      TO TABLE-1                 
P00899         MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1         
P00899         MOVE  OC-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1       
P00899         PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
P00899     END-IF.                                                      
P00899                                                                  
P00899 7900-EXIT.                                                       
P00899      EXIT.                                                       
P00899*                                                                 19932000
P00821******************************************************************42270100
P00821*                                                                *42270100
P00821* 7920-SELECT-JOB-PARM.                                          *42270100
P00821******************************************************************42270100
P00821 7920-SELECT-JOB-PARM.                                            
P00821                                                                  
P00821     EXEC SQL                                                     
P00821         SELECT G6.PARM_DATA                                      
P00821           INTO :G6-PARM-DATA                                     
P00821           FROM CSS_JOB_PARM G6 WITH(READUNCOMMITTED)                     
P00821          WHERE G6.PROGRAM_NAME = :G6-PROGRAM-NAME                
P00821            AND G6.CMND_CODE    = :G6-CMND-CODE                   
P00821            AND G6.STATUS       = :G6-STATUS                      
P00821            AND G6.SEQ_NO       = :G6-SEQ-NO                      
P00821                                                           
P00821     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     42270300
MFA-TR*        SELECT G6.PARM_DATA                                      42270400
MFA-TR*          INTO :G6-PARM-DATA                                             
MFA-TR*          FROM CSS_JOB_PARM G6                                           
MFA-TR*         WHERE G6.PROGRAM_NAME = :G6-PROGRAM-NAME                        
MFA-TR*           AND G6.CMND_CODE    = :G6-CMND-CODE                           
MFA-TR*           AND G6.STATUS       = :G6-STATUS                              
MFA-TR*           AND G6.SEQ_NO       = :G6-SEQ-NO                              
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                    42270500

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00821                                                                  
P00821     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
P00821                                                                  
P00821     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00821         NEXT SENTENCE                                            
P00821     ELSE                                                         
P00821         MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
P00821         MOVE '7920'                   TO ACTIVE-PARAGRAPH        
P00821         MOVE 'SELECT'                 TO ABEND-FUNCTION          
P00821         MOVE SPACES                   TO ABEND-SQL-PREDICATES    
P00821                                          ABEND-TABLES            
P00821         MOVE 'CSS_JOB_PARM'           TO TABLE-1                 
P00821         MOVE 'CUT REV MTH'            TO TABLE-ELEMENT-1         
P00821         MOVE  WS-PARM-CUT-REV         TO HOSTVAR-ELEMENT-1       
P00821         PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
P00821     END-IF.                                                      
P00821                                                                  
P00821 7920-EXIT.                                                       
P00821      EXIT.                                                       
      *                                                                 19932000
      ******************************************************************        
      *8000-DELETE-GTT-ROWS.                                                    
      ******************************************************************        
       8000-DELETE-GTT-ROWS.                                            
      *                                                                         
            MOVE 'DELETE ROWS'               TO S-SQL-STATEMENT-V.      
      *                                                                         
            EXEC SQL                                                    
                DELETE FROM #CSR04623_R1                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR04623_R1                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME             TO  ABEND-PROGRAM          
               MOVE '8000'                   TO  ACTIVE-PARAGRAPH       
               MOVE 'DELETE'                 TO  ABEND-FUNCTION         
               MOVE SQLCODE                  TO  ABEND-SQLCODE          
               MOVE SPACES                   TO  ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
               MOVE 'CSR04623_R1'            TO  TABLE-1                
               MOVE SPACES                   TO  TABLE-ELEMENT-1        
               MOVE SPACES                   TO  HOSTVAR-ELEMENT-1      
               PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT            
            END-IF.                                                     
      *                                                                         
       8000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      *8010-DELETE-GTT-ROWS.                                                    
      ******************************************************************        
       8010-DELETE-GTT-ROWS.                                            
      *                                                                         
            MOVE 'DELETE ROWS'               TO S-SQL-STATEMENT-V.      
      *                                                                         
            EXEC SQL                                                    
                DELETE FROM #CSR04623_R2                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR04623_R2                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME             TO  ABEND-PROGRAM          
               MOVE '8010'                   TO  ACTIVE-PARAGRAPH       
               MOVE 'DELETE'                 TO  ABEND-FUNCTION         
               MOVE SQLCODE                  TO  ABEND-SQLCODE          
               MOVE SPACES                   TO  ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
               MOVE 'CSR04623_R2'            TO  TABLE-1                
               MOVE SPACES                   TO  TABLE-ELEMENT-1        
               MOVE SPACES                   TO  HOSTVAR-ELEMENT-1      
               PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT            
            END-IF.                                                     
      *                                                                         
       8010-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      *8020-DELETE-GTT-ROWS.                                                    
      ******************************************************************        
       8020-DELETE-GTT-ROWS.                                            
      *                                                                         
            MOVE 'DELETE ROWS'               TO S-SQL-STATEMENT-V.      
      *                                                                         
            EXEC SQL                                                    
                DELETE FROM #CSR04623_R3                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR04623_R3                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME             TO  ABEND-PROGRAM          
               MOVE '8020'                   TO  ACTIVE-PARAGRAPH       
               MOVE 'DELETE'                 TO  ABEND-FUNCTION         
               MOVE SQLCODE                  TO  ABEND-SQLCODE          
               MOVE SPACES                   TO  ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
               MOVE 'CSR04623_R3'            TO  TABLE-1                
               MOVE SPACES                   TO  TABLE-ELEMENT-1        
               MOVE SPACES                   TO  HOSTVAR-ELEMENT-1      
               PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT            
            END-IF.                                                     
      *                                                                         
       8020-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
P00836******************************************************************        
P00836*8030-DELETE-GTT-ROWS.                                                    
P00836******************************************************************        
P00836 8030-DELETE-GTT-ROWS.                                            
P00836*                                                                         
P00836      MOVE 'DELETE ROWS'               TO S-SQL-STATEMENT-V.      
P00836*                                                                         
P00836      EXEC SQL                                                    
P00836          DELETE FROM #CSR04623_R4                         
P00836      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR04623_R4                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00836*                                                                         
P00836      MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.  
P00836*                                                                         
P00836      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
P00836         CONTINUE                                                 
P00836      ELSE                                                        
P00836         MOVE PROGRAM-NAME             TO  ABEND-PROGRAM          
P00836         MOVE '8030'                   TO  ACTIVE-PARAGRAPH       
P00836         MOVE 'DELETE'                 TO  ABEND-FUNCTION         
P00836         MOVE SQLCODE                  TO  ABEND-SQLCODE          
P00836         MOVE SPACES                   TO  ABEND-SQL-PREDICATES   
P00836                                           ABEND-TABLES           
P00836         MOVE 'CSR04623_R4'            TO  TABLE-1                
P00836         MOVE SPACES                   TO  TABLE-ELEMENT-1        
P00836         MOVE SPACES                   TO  HOSTVAR-ELEMENT-1      
P00836         PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT            
P00836      END-IF.                                                     
P00836*                                                                         
P00836 8030-EXIT.                                                       
P00836      EXIT.                                                       
P00836*                                                                         
      ******************************************************************        
      *8100-INSERT-GTT-R1.                                                      
      ******************************************************************        
       8100-INSERT-GTT-R1.                                              
                                                                        
            EXEC SQL                                                    
                 INSERT INTO #CSR04623_R1                        
                 (                                                      
                       RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,ACCOUNT_NO                                       
                      ,COMPANY_NO                                       
                      ,BILL_MONTH                                       
                      ,BILL_NO                                          
                      ,DATE_BILLED                                      
                      ,BILL_AMOUNT                                      
                      ,PAYMENTS                                         
                      ,OTHR_CHRGS                                       
                      ,ARREARS                                          
                      ,TOTAL_AMOUNT                                     
                      ,CODE_BILL_STATUS                                 
                      ,CODE_BILL_TYPE                                   
P00821                ,PSNC_FLAG                                        
P00821                ,FUT_BILL_HOOK_INS_FL                             
P00821                ,BILL_ADJ_FLAG                                    
P00836                ,ELECTRIC_CHARGES                                 
P00836                ,GAS_CHARGES                                      
P00836                ,UNMETERED_CHARGES                                
P00836                ,TAXES                                            
P00836                ,WEB_CURRENT_CHARGES                              
P00836                ,SHOW_BILL_IMAGE_FL                               
                 )                                                      
                 VALUES                                                 
                 (                                                      
                      :S1-RETURN-CODE                                   
                     ,:S1-APPL-RETURN-CODE                              
                     ,:S1-ACCOUNT-NO                                    
                     ,:S1-COMPANY-NO                                    
                     ,:S1-REVENUE-MONTH                                 
                     ,:S1-BILL-NO                                       
                     ,:S1-DATE-BILLED                                   
                     ,:S1-BILL-AMOUNT                                   
                     ,:S1-PAYMENTS                                      
                     ,:S1-TOT-OTHER-CHARGES                             
                     ,:S1-TOTAL-ARREARS                                 
                     ,:S1-TOTAL-BILL-AMOUNT                             
                     ,:S1-CODE-BILL-STATUS                              
                     ,:S1-CODE-BILL-TYPE                                
P00821               ,:S1-PSNC-FLAG                                     
P00821               ,:S1-FUT-BILL-HOOK-INS-FL                          
P00821               ,:S1-BILL-ADJ-FLAG                                 
P00836               ,:S1-TOTAL-ELEC-CHARGES                            
P00836               ,:S1-TOTAL-GAS-CHARGES                             
P00836               ,:S1-TOTAL-UNMTR-CHARGES                           
P00836               ,:S1-TOTAL-TAXES                                   
P00836               ,:S1-WEB-CURRENT-CHARGES                           
P00836               ,:S1-SHOW-BILL-IMAGE-FL                            
                 )                                                      
             END-EXEC.                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*          INSERT INTO SESSION.CSR04623_R1                                
MFA-TR*          (                                                              
MFA-TR*                RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,ACCOUNT_NO                                               
MFA-TR*               ,COMPANY_NO                                               
MFA-TR*               ,BILL_MONTH                                               
MFA-TR*               ,BILL_NO                                                  
MFA-TR*               ,DATE_BILLED                                              
MFA-TR*               ,BILL_AMOUNT                                              
MFA-TR*               ,PAYMENTS                                                 
MFA-TR*               ,OTHR_CHRGS                                               
MFA-TR*               ,ARREARS                                                  
MFA-TR*               ,TOTAL_AMOUNT                                             
MFA-TR*               ,CODE_BILL_STATUS                                         
MFA-TR*               ,CODE_BILL_TYPE                                           
MFA-TR*               ,PSNC_FLAG                                                
MFA-TR*               ,FUT_BILL_HOOK_INS_FL                                     
MFA-TR*               ,BILL_ADJ_FLAG                                            
MFA-TR*               ,ELECTRIC_CHARGES                                         
MFA-TR*               ,GAS_CHARGES                                              
MFA-TR*               ,UNMETERED_CHARGES                                        
MFA-TR*               ,TAXES                                                    
MFA-TR*               ,WEB_CURRENT_CHARGES                                      
MFA-TR*               ,SHOW_BILL_IMAGE_FL                                       
MFA-TR*          )                                                              
MFA-TR*          VALUES                                                         
MFA-TR*          (                                                              
MFA-TR*               :S1-RETURN-CODE                                           
MFA-TR*              ,:S1-APPL-RETURN-CODE                                      
MFA-TR*              ,:S1-ACCOUNT-NO                                            
MFA-TR*              ,:S1-COMPANY-NO                                            
MFA-TR*              ,:S1-REVENUE-MONTH                                         
MFA-TR*              ,:S1-BILL-NO                                               
MFA-TR*              ,:S1-DATE-BILLED                                           
MFA-TR*              ,:S1-BILL-AMOUNT                                           
MFA-TR*              ,:S1-PAYMENTS                                              
MFA-TR*              ,:S1-TOT-OTHER-CHARGES                                     
MFA-TR*              ,:S1-TOTAL-ARREARS                                         
MFA-TR*              ,:S1-TOTAL-BILL-AMOUNT                                     
MFA-TR*              ,:S1-CODE-BILL-STATUS                                      
MFA-TR*              ,:S1-CODE-BILL-TYPE                                        
MFA-TR*              ,:S1-PSNC-FLAG                                             
MFA-TR*              ,:S1-FUT-BILL-HOOK-INS-FL                                  
MFA-TR*              ,:S1-BILL-ADJ-FLAG                                         
MFA-TR*              ,:S1-TOTAL-ELEC-CHARGES                                    
MFA-TR*              ,:S1-TOTAL-GAS-CHARGES                                     
MFA-TR*              ,:S1-TOTAL-UNMTR-CHARGES                                   
MFA-TR*              ,:S1-TOTAL-TAXES                                           
MFA-TR*              ,:S1-WEB-CURRENT-CHARGES                                   
MFA-TR*              ,:S1-SHOW-BILL-IMAGE-FL                                    
MFA-TR*          )                                                              
MFA-TR*      END-EXEC.                                                          

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
             MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
                ADD +1                       TO  CTR-ROWS-RS1           
             ELSE                                                       
                MOVE PROGRAM-NAME            TO  ABEND-PROGRAM          
                MOVE '8100'                  TO  ACTIVE-PARAGRAPH       
                MOVE 'INSERT'                TO  ABEND-FUNCTION         
                MOVE SQLCODE                 TO  ABEND-SQLCODE          
                MOVE SPACES                  TO  ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
                MOVE 'CSR04623_R1'           TO  TABLE-1                
                MOVE SPACES                  TO  TABLE-ELEMENT-1        
                MOVE SPACES                  TO  HOSTVAR-ELEMENT-1      
                PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT            
             END-IF.                                                    
      *                                                                         
        8100-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      *8110-INSERT-GTT-R2.                                                      
      ******************************************************************        
       8110-INSERT-GTT-R2.                                              
                                                                        
            EXEC SQL                                                    
                 INSERT INTO #CSR04623_R2                        
                 (                                                      
                       RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,ACCOUNT_NO                                       
                      ,COMPANY_NO                                       
                      ,BILL_MONTH                                       
                      ,BILL_NO                                          
                      ,BILL_TIMESTMP                                    
                      ,DATE_READ                                        
                      ,SERVICE_TYPE                                     
                      ,IC_NO                                            
                      ,RATE_PLAN_NO                                     
P00821                ,REVENUE_CLASS                                    
P00821                ,PRTY_SVC_CAT_CD                                  
P00821                ,CODE_BILL_CALC                                   
                      ,RATE_DESC                                        
P00821                ,UNMTR_PROV_FL                                    
P00899                ,SECUR_RATE_FL                                    
                      ,OPTION_CD                                        
                      ,OPTION_DESC                                      
                      ,USAGE                                            
                      ,USAGE_TYPE                                       
                      ,DAYS                                             
                      ,CHARGES                                          
                      ,TAXES                                            
                      ,BILL_ITEM_IND                                    
                      ,READ_UNITS                                       
                      ,AGL_CHRG                                         
                      ,SUB_ACCOUNT_NO                                   
                      ,SUB_ACCT_SERV_ADDR                               
P00821                ,REV_MTH_ORIG_BILL                                
P00821                ,DATE_ORIG_BILL                                   
P00821                ,INDUST_GAS_CUST                                  
P00821                ,NET_MTR_ACCOUNT                                  
P00821                ,CIG_FLAG                                         
P00821                ,EMC_FLAG                                         
P00899                ,BILL_RELEASED_FLG                                
P00899                ,MULT_REGISTER_FLG                                
                 )                                                      
                 VALUES                                                 
                 (                                                      
                      :S2-RETURN-CODE                                   
                     ,:S2-APPL-RETURN-CODE                              
                     ,:S2-ACCOUNT-NO                                    
                     ,:S2-COMPANY-NO                                    
                     ,:S2-REVENUE-MONTH                                 
                     ,:S2-BILL-NO                                       
                     ,:S2-BILL-ITEM-TIMESTMP                            
                     ,:S2-DATE-READ                                     
                     ,:S2-CODE-UTIL-TYPE                                
                     ,:S2-IC-NO                                         
                     ,:S2-RATE-PLAN-NO                                  
P00821               ,:S2-REVENUE-CLASS                                 
P00821               ,:S2-PRTY-SVC-CAT-CD                               
P00821               ,:S2-CODE-BILL-CALC                                
                     ,:S2-RATE-DESC                                     
P00821               ,:S2-UNMTR-PROV-FL                                 
P00899               ,:S2-SECUR-RATE-FL                                 
                     ,:S2-OPTION-CD                                     
                     ,:S2-OPTION-DESC                                   
                     ,:S2-NO-UNITS                                      
                     ,:S2-CODE-USAGE-TYPE                               
                     ,:S2-NO-DAYS                                       
                     ,:S2-AMT-BILL-ITEM                                 
                     ,:S2-AMT-TAXES                                     
                     ,:S2-CODE-BILL-ITM-IND                             
                     ,:S2-READ-UNITS                                    
                     ,:S2-AGL-CHARGE                                    
                     ,:S2-SUB-ACCOUNT-NO                                
                     ,:S2-SUB-ACCT-SERV-ADDR                            
P00821               ,:S2-REV-MTH-ORIG-BILL                             
P00821               ,:S2-DATE-ORIG-BILL                                
P00821               ,:S2-INDUST-GAS-CUST                               
P00821               ,:S2-NET-MTR-ACCOUNT                               
P00821               ,:S2-CIG-FLAG                                      
P00821               ,:S2-EMC-FLAG                                      
P00899               ,:S2-BILL-RELEASED-FLG                             
P00899               ,:S2-MULT-REGISTER-FLG                             
                 )                                                      
             END-EXEC.                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*          INSERT INTO SESSION.CSR04623_R2                                
MFA-TR*          (                                                              
MFA-TR*                RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,ACCOUNT_NO                                               
MFA-TR*               ,COMPANY_NO                                               
MFA-TR*               ,BILL_MONTH                                               
MFA-TR*               ,BILL_NO                                                  
MFA-TR*               ,BILL_TIMESTMP                                            
MFA-TR*               ,DATE_READ                                                
MFA-TR*               ,SERVICE_TYPE                                             
MFA-TR*               ,IC_NO                                                    
MFA-TR*               ,RATE_PLAN_NO                                             
MFA-TR*               ,REVENUE_CLASS                                            
MFA-TR*               ,PRTY_SVC_CAT_CD                                          
MFA-TR*               ,CODE_BILL_CALC                                           
MFA-TR*               ,RATE_DESC                                                
MFA-TR*               ,UNMTR_PROV_FL                                            
MFA-TR*               ,SECUR_RATE_FL                                            
MFA-TR*               ,OPTION_CD                                                
MFA-TR*               ,OPTION_DESC                                              
MFA-TR*               ,USAGE                                                    
MFA-TR*               ,USAGE_TYPE                                               
MFA-TR*               ,DAYS                                                     
MFA-TR*               ,CHARGES                                                  
MFA-TR*               ,TAXES                                                    
MFA-TR*               ,BILL_ITEM_IND                                            
MFA-TR*               ,READ_UNITS                                               
MFA-TR*               ,AGL_CHRG                                                 
MFA-TR*               ,SUB_ACCOUNT_NO                                           
MFA-TR*               ,SUB_ACCT_SERV_ADDR                                       
MFA-TR*               ,REV_MTH_ORIG_BILL                                        
MFA-TR*               ,DATE_ORIG_BILL                                           
MFA-TR*               ,INDUST_GAS_CUST                                          
MFA-TR*               ,NET_MTR_ACCOUNT                                          
MFA-TR*               ,CIG_FLAG                                                 
MFA-TR*               ,EMC_FLAG                                                 
MFA-TR*               ,BILL_RELEASED_FLG                                        
MFA-TR*               ,MULT_REGISTER_FLG                                        
MFA-TR*          )                                                              
MFA-TR*          VALUES                                                         
MFA-TR*          (                                                              
MFA-TR*               :S2-RETURN-CODE                                           
MFA-TR*              ,:S2-APPL-RETURN-CODE                                      
MFA-TR*              ,:S2-ACCOUNT-NO                                            
MFA-TR*              ,:S2-COMPANY-NO                                            
MFA-TR*              ,:S2-REVENUE-MONTH                                         
MFA-TR*              ,:S2-BILL-NO                                               
MFA-TR*              ,:S2-BILL-ITEM-TIMESTMP                                    
MFA-TR*              ,:S2-DATE-READ                                             
MFA-TR*              ,:S2-CODE-UTIL-TYPE                                        
MFA-TR*              ,:S2-IC-NO                                                 
MFA-TR*              ,:S2-RATE-PLAN-NO                                          
MFA-TR*              ,:S2-REVENUE-CLASS                                         
MFA-TR*              ,:S2-PRTY-SVC-CAT-CD                                       
MFA-TR*              ,:S2-CODE-BILL-CALC                                        
MFA-TR*              ,:S2-RATE-DESC                                             
MFA-TR*              ,:S2-UNMTR-PROV-FL                                         
MFA-TR*              ,:S2-SECUR-RATE-FL                                         
MFA-TR*              ,:S2-OPTION-CD                                             
MFA-TR*              ,:S2-OPTION-DESC                                           
MFA-TR*              ,:S2-NO-UNITS                                              
MFA-TR*              ,:S2-CODE-USAGE-TYPE                                       
MFA-TR*              ,:S2-NO-DAYS                                               
MFA-TR*              ,:S2-AMT-BILL-ITEM                                         
MFA-TR*              ,:S2-AMT-TAXES                                             
MFA-TR*              ,:S2-CODE-BILL-ITM-IND                                     
MFA-TR*              ,:S2-READ-UNITS                                            
MFA-TR*              ,:S2-AGL-CHARGE                                            
MFA-TR*              ,:S2-SUB-ACCOUNT-NO                                        
MFA-TR*              ,:S2-SUB-ACCT-SERV-ADDR                                    
MFA-TR*              ,:S2-REV-MTH-ORIG-BILL                                     
MFA-TR*              ,:S2-DATE-ORIG-BILL                                        
MFA-TR*              ,:S2-INDUST-GAS-CUST                                       
MFA-TR*              ,:S2-NET-MTR-ACCOUNT                                       
MFA-TR*              ,:S2-CIG-FLAG                                              
MFA-TR*              ,:S2-EMC-FLAG                                              
MFA-TR*              ,:S2-BILL-RELEASED-FLG                                     
MFA-TR*              ,:S2-MULT-REGISTER-FLG                                     
MFA-TR*          )                                                              
MFA-TR*      END-EXEC.                                                          

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
             MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
                ADD +1                       TO  CTR-ROWS-RS2           
             ELSE                                                       
                MOVE PROGRAM-NAME            TO  ABEND-PROGRAM          
                MOVE '8110'                  TO  ACTIVE-PARAGRAPH       
                MOVE 'INSERT'                TO  ABEND-FUNCTION         
                MOVE SQLCODE                 TO  ABEND-SQLCODE          
                MOVE SPACES                  TO  ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
                MOVE 'CSR04623_R2'           TO  TABLE-1                
                MOVE SPACES                  TO  TABLE-ELEMENT-1        
                MOVE SPACES                  TO  HOSTVAR-ELEMENT-1      
                PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT            
             END-IF.                                                    
      *                                                                         
        8110-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      *8120-INSERT-GTT-R3.                                                      
      ******************************************************************        
       8120-INSERT-GTT-R3.                                              
                                                                        
            EXEC SQL                                                    
                 INSERT INTO #CSR04623_R3                        
                 (                                                      
                       RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,ADDTNL_BILLS_EXIST                               
PRJ821                ,ACCT_BILLS_COUNT                                 
P00899                ,ACCT_LAST_UPDT_TS                                
P00836                ,WEB_AVERAGE_BILL_AMT                             
                 )                                                      
                 VALUES                                                 
                 (                                                      
                      :S3-RETURN-CODE                                   
                     ,:S3-APPL-RETURN-CODE                              
                     ,:S3-ADDTNL-BILLS-EXIST                            
PRJ821               ,:S3-ACCT-BILLS-COUNT                              
P00899               ,:S3-ACCT-LAST-UPDT-TS                             
P00836               ,:S3-WEB-AVERAGE-BILL-AMT                          
                 )                                                      
             END-EXEC.                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*          INSERT INTO SESSION.CSR04623_R3                                
MFA-TR*          (                                                              
MFA-TR*                RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,ADDTNL_BILLS_EXIST                                       
MFA-TR*               ,ACCT_BILLS_COUNT                                         
MFA-TR*               ,ACCT_LAST_UPDT_TS                                        
MFA-TR*               ,WEB_AVERAGE_BILL_AMT                                     
MFA-TR*          )                                                              
MFA-TR*          VALUES                                                         
MFA-TR*          (                                                              
MFA-TR*               :S3-RETURN-CODE                                           
MFA-TR*              ,:S3-APPL-RETURN-CODE                                      
MFA-TR*              ,:S3-ADDTNL-BILLS-EXIST                                    
MFA-TR*              ,:S3-ACCT-BILLS-COUNT                                      
MFA-TR*              ,:S3-ACCT-LAST-UPDT-TS                                     
MFA-TR*              ,:S3-WEB-AVERAGE-BILL-AMT                                  
MFA-TR*          )                                                              
MFA-TR*      END-EXEC.                                                          

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
             MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
                ADD +1                       TO  CTR-ROWS-RS3           
             ELSE                                                       
                MOVE PROGRAM-NAME            TO  ABEND-PROGRAM          
                MOVE '8120'                  TO  ACTIVE-PARAGRAPH       
                MOVE 'INSERT'                TO  ABEND-FUNCTION         
                MOVE SQLCODE                 TO  ABEND-SQLCODE          
                MOVE SPACES                  TO  ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
                MOVE 'CSR04623_R3'           TO  TABLE-1                
                MOVE SPACES                  TO  TABLE-ELEMENT-1        
                MOVE SPACES                  TO  HOSTVAR-ELEMENT-1      
                PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT            
             END-IF.                                                    
      *                                                                         
        8120-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
P00836******************************************************************        
P00836*8200-INSERT-GTT-R4.                                             *        
P00836******************************************************************        
P00836*                                                                         
P00836 8200-INSERT-GTT-R4.                                              
P00836*                                                                         
P00836      EXEC SQL                                                    
P00836           INSERT INTO #CSR04623_R4                        
P00836           (                                                      
P00836                 RETURN_CODE                                      
P00836                ,APPL_RETURN_CODE                                 
P00836                ,ACCOUNT_NO                                       
P00836                ,COMPANY_NO                                       
P00836                ,BILL_MONTH                                       
P00836                ,BILL_NO                                          
P00836                ,DATE_BILLED                                      
P00836                ,BILL_AMOUNT                                      
P00836                ,PAYMENTS                                         
P00836                ,OTHR_CHRGS                                       
P00836                ,ARREARS                                          
P00836                ,TOTAL_AMOUNT                                     
P00836                ,CODE_BILL_TYPE                                   
P00836                ,ELECTRIC_CHARGES                                 
P00836                ,GAS_CHARGES                                      
P00836                ,UNMETERED_CHARGES                                
P00836                ,TAXES                                            
P00836                ,WEB_CURRENT_CHARGES                              
P00836                ,WEB_TOT_BILL_AMOUNT                              
P00836           )                                                      
P00836           VALUES                                                 
P00836           (                                                      
P00836                :S1-RETURN-CODE                                   
P00836               ,:S1-APPL-RETURN-CODE                              
P00836               ,:S1-ACCOUNT-NO                                    
P00836               ,:S1-COMPANY-NO                                    
P00836               ,:S1-REVENUE-MONTH                                 
P00836               ,:S1-BILL-NO                                       
P00836               ,:S1-DATE-BILLED                                   
P00836               ,:S1-BILL-AMOUNT                                   
P00836               ,:S1-PAYMENTS                                      
P00836               ,:S1-TOT-OTHER-CHARGES                             
P00836               ,:S1-TOTAL-ARREARS                                 
P00836               ,:S1-TOTAL-BILL-AMOUNT                             
P00836               ,:S1-CODE-BILL-TYPE                                
P00836               ,:S1-TOTAL-ELEC-CHARGES                            
P00836               ,:S1-TOTAL-GAS-CHARGES                             
P00836               ,:S1-TOTAL-UNMTR-CHARGES                           
P00836               ,:S1-TOTAL-TAXES                                   
P00836               ,:S1-WEB-CURRENT-CHARGES                           
P00836               ,:S1-WEB-TOT-BILL-AMOUNT                           
P00836           )                                                      
P00836       END-EXEC.                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*          INSERT INTO SESSION.CSR04623_R4                                
MFA-TR*          (                                                              
MFA-TR*                RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,ACCOUNT_NO                                               
MFA-TR*               ,COMPANY_NO                                               
MFA-TR*               ,BILL_MONTH                                               
MFA-TR*               ,BILL_NO                                                  
MFA-TR*               ,DATE_BILLED                                              
MFA-TR*               ,BILL_AMOUNT                                              
MFA-TR*               ,PAYMENTS                                                 
MFA-TR*               ,OTHR_CHRGS                                               
MFA-TR*               ,ARREARS                                                  
MFA-TR*               ,TOTAL_AMOUNT                                             
MFA-TR*               ,CODE_BILL_TYPE                                           
MFA-TR*               ,ELECTRIC_CHARGES                                         
MFA-TR*               ,GAS_CHARGES                                              
MFA-TR*               ,UNMETERED_CHARGES                                        
MFA-TR*               ,TAXES                                                    
MFA-TR*               ,WEB_CURRENT_CHARGES                                      
MFA-TR*               ,WEB_TOT_BILL_AMOUNT                                      
MFA-TR*          )                                                              
MFA-TR*          VALUES                                                         
MFA-TR*          (                                                              
MFA-TR*               :S1-RETURN-CODE                                           
MFA-TR*              ,:S1-APPL-RETURN-CODE                                      
MFA-TR*              ,:S1-ACCOUNT-NO                                            
MFA-TR*              ,:S1-COMPANY-NO                                            
MFA-TR*              ,:S1-REVENUE-MONTH                                         
MFA-TR*              ,:S1-BILL-NO                                               
MFA-TR*              ,:S1-DATE-BILLED                                           
MFA-TR*              ,:S1-BILL-AMOUNT                                           
MFA-TR*              ,:S1-PAYMENTS                                              
MFA-TR*              ,:S1-TOT-OTHER-CHARGES                                     
MFA-TR*              ,:S1-TOTAL-ARREARS                                         
MFA-TR*              ,:S1-TOTAL-BILL-AMOUNT                                     
MFA-TR*              ,:S1-CODE-BILL-TYPE                                        
MFA-TR*              ,:S1-TOTAL-ELEC-CHARGES                                    
MFA-TR*              ,:S1-TOTAL-GAS-CHARGES                                     
MFA-TR*              ,:S1-TOTAL-UNMTR-CHARGES                                   
MFA-TR*              ,:S1-TOTAL-TAXES                                           
MFA-TR*              ,:S1-WEB-CURRENT-CHARGES                                   
MFA-TR*              ,:S1-WEB-TOT-BILL-AMOUNT                                   
MFA-TR*          )                                                              
MFA-TR*      END-EXEC.                                                          

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00836*                                                                         
P00836       MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.  
P00836*                                                                         
P00836       IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
P00836          ADD +1                       TO  CTR-ROWS-RS4           
P00836       ELSE                                                       
P00836          MOVE PROGRAM-NAME            TO  ABEND-PROGRAM          
P00836          MOVE '8200'                  TO  ACTIVE-PARAGRAPH       
P00836          MOVE 'INSERT'                TO  ABEND-FUNCTION         
P00836          MOVE SQLCODE                 TO  ABEND-SQLCODE          
P00836          MOVE SPACES                  TO  ABEND-SQL-PREDICATES   
P00836                                           ABEND-TABLES           
P00836          MOVE 'CSR04623_R4'           TO  TABLE-1                
P00836          MOVE SPACES                  TO  TABLE-ELEMENT-1        
P00836          MOVE SPACES                  TO  HOSTVAR-ELEMENT-1      
P00836          PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT            
P00836       END-IF.                                                    
P00836*                                                                         
P00836  8200-EXIT.                                                      
P00836      EXIT.                                                       
P00836*                                                                         
P00836******************************************************************        
P00836** APPLICATION=WBH: INSERT ROWS INTO HEADER RESULT SET USING    **        
P00836** GROUP BY REVENUE MONTH(DESC) & CODE BILL TYPE(DESC)          **        
P00836******************************************************************        
P00836*                                                                         
P00836 8210-INSERT-R1-ALL-HISTORY.                                      
P00836*                                                                         
P00836      EXEC SQL                                                    
P00836           INSERT INTO #CSR04623_R1                        
P00836           (                                                      
P00836                 RETURN_CODE                                      
P00836                ,APPL_RETURN_CODE                                 
P00836                ,ACCOUNT_NO                                       
P00836                ,COMPANY_NO                                       
P00836                ,BILL_MONTH                                       
P00836                ,BILL_NO                                          
P00836                ,DATE_BILLED                                      
P00836                ,BILL_AMOUNT                                      
P00836                ,PAYMENTS                                         
P00836                ,OTHR_CHRGS                                       
P00836                ,ARREARS                                          
P00836                ,TOTAL_AMOUNT                                     
P00836                ,CODE_BILL_STATUS                                 
P00836                ,CODE_BILL_TYPE                                   
P00836                ,PSNC_FLAG                                        
P00836                ,FUT_BILL_HOOK_INS_FL                             
P00836                ,BILL_ADJ_FLAG                                    
P00836                ,ELECTRIC_CHARGES                                 
P00836                ,GAS_CHARGES                                      
P00836                ,UNMETERED_CHARGES                                
P00836                ,TAXES                                            
P00836                ,WEB_CURRENT_CHARGES                              
P00836                ,SHOW_BILL_IMAGE_FL                               
P00836           )                                                      
P00836           SELECT TOP(100) RETURN_CODE,
              APPL_RETURN_CODE,
              ACCOUNT_NO,
              COMPANY_NO,
              BILL_MONTH,
              MAX(BILL_NO),
              MAX(DATE_BILLED),
              SUM(BILL_AMOUNT),
              SUM(PAYMENTS),
              SUM(OTHR_CHRGS),
              SUM(ARREARS),
              SUM(TOTAL_AMOUNT),
              ' ',
              CODE_BILL_TYPE,
              ' ',
              ' ',
              ' ',
              SUM(ELECTRIC_CHARGES),
              SUM(GAS_CHARGES),
              SUM(UNMETERED_CHARGES),
              SUM(TAXES),
              SUM(WEB_CURRENT_CHARGES),
              CASE WHEN ( SUM(BILL_AMOUNT) = 0 AND           
P00836                               SUM(OTHR_CHRGS)  = 0 AND           
P00836                               SUM(ARREARS)     = 0 AND           
P00836                               SUM(PAYMENTS)    = 0   )           
P00836                   THEN 'N'  ELSE 'Y'  END                        
P00836           FROM  #CSR04623_R4                              
P00836           GROUP BY RETURN_CODE, APPL_RETURN_CODE, ACCOUNT_NO,    
P00836                    COMPANY_NO, BILL_MONTH, CODE_BILL_TYPE        
P00836           ORDER BY BILL_MONTH DESC, CODE_BILL_TYPE DESC          
WEBFIX                                         
P00836       END-EXEC.                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*          INSERT INTO SESSION.CSR04623_R1                                
MFA-TR*          (                                                              
MFA-TR*                RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,ACCOUNT_NO                                               
MFA-TR*               ,COMPANY_NO                                               
MFA-TR*               ,BILL_MONTH                                               
MFA-TR*               ,BILL_NO                                                  
MFA-TR*               ,DATE_BILLED                                              
MFA-TR*               ,BILL_AMOUNT                                              
MFA-TR*               ,PAYMENTS                                                 
MFA-TR*               ,OTHR_CHRGS                                               
MFA-TR*               ,ARREARS                                                  
MFA-TR*               ,TOTAL_AMOUNT                                             
MFA-TR*               ,CODE_BILL_STATUS                                         
MFA-TR*               ,CODE_BILL_TYPE                                           
MFA-TR*               ,PSNC_FLAG                                                
MFA-TR*               ,FUT_BILL_HOOK_INS_FL                                     
MFA-TR*               ,BILL_ADJ_FLAG                                            
MFA-TR*               ,ELECTRIC_CHARGES                                         
MFA-TR*               ,GAS_CHARGES                                              
MFA-TR*               ,UNMETERED_CHARGES                                        
MFA-TR*               ,TAXES                                                    
MFA-TR*               ,WEB_CURRENT_CHARGES                                      
MFA-TR*               ,SHOW_BILL_IMAGE_FL                                       
MFA-TR*          )                                                              
MFA-TR*          SELECT  RETURN_CODE                                            
MFA-TR*                 ,APPL_RETURN_CODE                                       
MFA-TR*                 ,ACCOUNT_NO                                             
MFA-TR*                 ,COMPANY_NO                                             
MFA-TR*                 ,BILL_MONTH                                             
MFA-TR*                 ,MAX(BILL_NO)                                           
MFA-TR*                 ,MAX(DATE_BILLED)                                       
MFA-TR*                 ,SUM(BILL_AMOUNT)                                       
MFA-TR*                 ,SUM(PAYMENTS)                                          
MFA-TR*                 ,SUM(OTHR_CHRGS)                                        
MFA-TR*                 ,SUM(ARREARS)                                           
MFA-TR*                 ,SUM(TOTAL_AMOUNT)                                      
MFA-TR*                 ,' '                                                    
MFA-TR*                 ,CODE_BILL_TYPE                                         
MFA-TR*                 ,' '                                                    
MFA-TR*                 ,' '                                                    
MFA-TR*                 ,' '                                                    
MFA-TR*                 ,SUM(ELECTRIC_CHARGES)                                  
MFA-TR*                 ,SUM(GAS_CHARGES)                                       
MFA-TR*                 ,SUM(UNMETERED_CHARGES)                                 
MFA-TR*                 ,SUM(TAXES)                                             
MFA-TR*                 ,SUM(WEB_CURRENT_CHARGES)                               
MFA-TR*                 ,CASE WHEN ( SUM(BILL_AMOUNT) = 0 AND                   
MFA-TR*                              SUM(OTHR_CHRGS)  = 0 AND                   
MFA-TR*                              SUM(ARREARS)     = 0 AND                   
MFA-TR*                              SUM(PAYMENTS)    = 0   )                   
MFA-TR*                  THEN 'N'  ELSE 'Y'  END                                
MFA-TR*          FROM  SESSION.CSR04623_R4                                      
MFA-TR*          GROUP BY RETURN_CODE, APPL_RETURN_CODE, ACCOUNT_NO,            
MFA-TR*                   COMPANY_NO, BILL_MONTH, CODE_BILL_TYPE                
MFA-TR*          ORDER BY BILL_MONTH DESC, CODE_BILL_TYPE DESC                  
MFA-TR*          FETCH FIRST 100 ROWS ONLY                                      
MFA-TR*      END-EXEC.                                                          

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00836*                                                                         
P00836       MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.  
P00836*                                                                         
P00836       IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
P00836          MOVE CTR-ROWS-RS4            TO  CTR-ROWS-RS1           
P00836       ELSE                                                       
P00836          MOVE PROGRAM-NAME            TO  ABEND-PROGRAM          
P00836          MOVE '8210'                  TO  ACTIVE-PARAGRAPH       
P00836          MOVE 'INSERT'                TO  ABEND-FUNCTION         
P00836          MOVE SQLCODE                 TO  ABEND-SQLCODE          
P00836          MOVE SPACES                  TO  ABEND-SQL-PREDICATES   
P00836                                           ABEND-TABLES           
P00836          MOVE 'CSR04623_R1'           TO  TABLE-1                
P00836          MOVE SPACES                  TO  TABLE-ELEMENT-1        
P00836          MOVE SPACES                  TO  HOSTVAR-ELEMENT-1      
P00836          PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT            
P00836       END-IF.                                                    
P00836*                                                                         
P00836  8210-EXIT.                                                      
P00836      EXIT.                                                       
P00836*                                                                         
P00836******************************************************************        
P00836** APPLICATION=WBR:INSERT LATEST 3 ROWS INTO HEADER RESULT SET  **        
P00836** USING GROUP BY REVENUE MONTH(DESC) & CODE BILL TYPE(DESC)    **        
P00836******************************************************************        
P00836*                                                                         
P00836 8220-INSERT-R1-RECENT-BILLS.                                     
P00836*                                                                         
P00836      EXEC SQL                                                    
P00836           INSERT INTO #CSR04623_R1                        
P00836           (                                                      
P00836                 RETURN_CODE                                      
P00836                ,APPL_RETURN_CODE                                 
P00836                ,ACCOUNT_NO                                       
P00836                ,COMPANY_NO                                       
P00836                ,BILL_MONTH                                       
P00836                ,BILL_NO                                          
P00836                ,DATE_BILLED                                      
P00836                ,BILL_AMOUNT                                      
P00836                ,PAYMENTS                                         
P00836                ,OTHR_CHRGS                                       
P00836                ,ARREARS                                          
P00836                ,TOTAL_AMOUNT                                     
P00836                ,CODE_BILL_STATUS                                 
P00836                ,CODE_BILL_TYPE                                   
P00836                ,PSNC_FLAG                                        
P00836                ,FUT_BILL_HOOK_INS_FL                             
P00836                ,BILL_ADJ_FLAG                                    
P00836                ,ELECTRIC_CHARGES                                 
P00836                ,GAS_CHARGES                                      
P00836                ,UNMETERED_CHARGES                                
P00836                ,TAXES                                            
P00836                ,WEB_CURRENT_CHARGES                              
P00836                ,SHOW_BILL_IMAGE_FL                               
P00836           )                                                      
P00836           SELECT TOP(3) RETURN_CODE,
              APPL_RETURN_CODE,
              ACCOUNT_NO,
              COMPANY_NO,
              BILL_MONTH,
              MAX(BILL_NO),
              MAX(DATE_BILLED),
              SUM(BILL_AMOUNT),
              SUM(PAYMENTS),
              SUM(OTHR_CHRGS),
              SUM(ARREARS),
              SUM(TOTAL_AMOUNT),
              ' ',
              CODE_BILL_TYPE,
              ' ',
              ' ',
              ' ',
              SUM(ELECTRIC_CHARGES),
              SUM(GAS_CHARGES),
              SUM(UNMETERED_CHARGES),
              SUM(TAXES),
              SUM(WEB_CURRENT_CHARGES),
              CASE WHEN ( SUM(BILL_AMOUNT) = 0 AND           
P00836                               SUM(OTHR_CHRGS)  = 0 AND           
P00836                               SUM(ARREARS)     = 0 AND           
P00836                               SUM(PAYMENTS)    = 0   )           
P00836                   THEN 'N'  ELSE 'Y'  END                        
P00836           FROM  #CSR04623_R4                              
P00836           GROUP BY RETURN_CODE, APPL_RETURN_CODE, ACCOUNT_NO,    
P00836                    COMPANY_NO, BILL_MONTH, CODE_BILL_TYPE        
P00836           ORDER BY BILL_MONTH DESC, CODE_BILL_TYPE DESC          
P00836                                           
P00836       END-EXEC.                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*          INSERT INTO SESSION.CSR04623_R1                                
MFA-TR*          (                                                              
MFA-TR*                RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,ACCOUNT_NO                                               
MFA-TR*               ,COMPANY_NO                                               
MFA-TR*               ,BILL_MONTH                                               
MFA-TR*               ,BILL_NO                                                  
MFA-TR*               ,DATE_BILLED                                              
MFA-TR*               ,BILL_AMOUNT                                              
MFA-TR*               ,PAYMENTS                                                 
MFA-TR*               ,OTHR_CHRGS                                               
MFA-TR*               ,ARREARS                                                  
MFA-TR*               ,TOTAL_AMOUNT                                             
MFA-TR*               ,CODE_BILL_STATUS                                         
MFA-TR*               ,CODE_BILL_TYPE                                           
MFA-TR*               ,PSNC_FLAG                                                
MFA-TR*               ,FUT_BILL_HOOK_INS_FL                                     
MFA-TR*               ,BILL_ADJ_FLAG                                            
MFA-TR*               ,ELECTRIC_CHARGES                                         
MFA-TR*               ,GAS_CHARGES                                              
MFA-TR*               ,UNMETERED_CHARGES                                        
MFA-TR*               ,TAXES                                                    
MFA-TR*               ,WEB_CURRENT_CHARGES                                      
MFA-TR*               ,SHOW_BILL_IMAGE_FL                                       
MFA-TR*          )                                                              
MFA-TR*          SELECT  RETURN_CODE                                            
MFA-TR*                 ,APPL_RETURN_CODE                                       
MFA-TR*                 ,ACCOUNT_NO                                             
MFA-TR*                 ,COMPANY_NO                                             
MFA-TR*                 ,BILL_MONTH                                             
MFA-TR*                 ,MAX(BILL_NO)                                           
MFA-TR*                 ,MAX(DATE_BILLED)                                       
MFA-TR*                 ,SUM(BILL_AMOUNT)                                       
MFA-TR*                 ,SUM(PAYMENTS)                                          
MFA-TR*                 ,SUM(OTHR_CHRGS)                                        
MFA-TR*                 ,SUM(ARREARS)                                           
MFA-TR*                 ,SUM(TOTAL_AMOUNT)                                      
MFA-TR*                 ,' '                                                    
MFA-TR*                 ,CODE_BILL_TYPE                                         
MFA-TR*                 ,' '                                                    
MFA-TR*                 ,' '                                                    
MFA-TR*                 ,' '                                                    
MFA-TR*                 ,SUM(ELECTRIC_CHARGES)                                  
MFA-TR*                 ,SUM(GAS_CHARGES)                                       
MFA-TR*                 ,SUM(UNMETERED_CHARGES)                                 
MFA-TR*                 ,SUM(TAXES)                                             
MFA-TR*                 ,SUM(WEB_CURRENT_CHARGES)                               
MFA-TR*                 ,CASE WHEN ( SUM(BILL_AMOUNT) = 0 AND                   
MFA-TR*                              SUM(OTHR_CHRGS)  = 0 AND                   
MFA-TR*                              SUM(ARREARS)     = 0 AND                   
MFA-TR*                              SUM(PAYMENTS)    = 0   )                   
MFA-TR*                  THEN 'N'  ELSE 'Y'  END                                
MFA-TR*          FROM  SESSION.CSR04623_R4                                      
MFA-TR*          GROUP BY RETURN_CODE, APPL_RETURN_CODE, ACCOUNT_NO,            
MFA-TR*                   COMPANY_NO, BILL_MONTH, CODE_BILL_TYPE                
MFA-TR*          ORDER BY BILL_MONTH DESC, CODE_BILL_TYPE DESC                  
MFA-TR*          FETCH FIRST 3 ROWS ONLY                                        
MFA-TR*      END-EXEC.                                                          

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00836*                                                                         
P00836       MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.  
P00836*                                                                         
P00836       IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
P00836          MOVE CTR-ROWS-RS4            TO  CTR-ROWS-RS1           
P00836       ELSE                                                       
P00836          MOVE PROGRAM-NAME            TO  ABEND-PROGRAM          
P00836          MOVE '8220'                  TO  ACTIVE-PARAGRAPH       
P00836          MOVE 'INSERT'                TO  ABEND-FUNCTION         
P00836          MOVE SQLCODE                 TO  ABEND-SQLCODE          
P00836          MOVE SPACES                  TO  ABEND-SQL-PREDICATES   
P00836                                           ABEND-TABLES           
P00836          MOVE 'CSR04623_R1'           TO  TABLE-1                
P00836          MOVE SPACES                  TO  TABLE-ELEMENT-1        
P00836          MOVE SPACES                  TO  HOSTVAR-ELEMENT-1      
P00836          PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT            
P00836       END-IF.                                                    
P00836*                                                                         
P00836  8220-EXIT.                                                      
P00836      EXIT.                                                       
P00836*                                                                         
P00836******************************************************************        
P00836** APPLICATION=WBC: INSERT ROWS INTO HEADER RES SET USING GROUP **        
P00836** BY REVENUE MONTH(DESC)                                       **        
P00836******************************************************************        
P00836*                                                                         
P00836 8230-INSERT-R1-CHART.                                            
P00836*                                                                         
P00836      EXEC SQL                                                    
P00836           INSERT INTO #CSR04623_R1                        
P00836           (                                                      
P00836                 RETURN_CODE                                      
P00836                ,APPL_RETURN_CODE                                 
P00836                ,ACCOUNT_NO                                       
P00836                ,COMPANY_NO                                       
P00836                ,BILL_MONTH                                       
P00836                ,BILL_NO                                          
P00836                ,DATE_BILLED                                      
P00836                ,BILL_AMOUNT                                      
P00836                ,PAYMENTS                                         
P00836                ,OTHR_CHRGS                                       
P00836                ,ARREARS                                          
P00836                ,TOTAL_AMOUNT                                     
P00836                ,CODE_BILL_STATUS                                 
P00836                ,CODE_BILL_TYPE                                   
P00836                ,PSNC_FLAG                                        
P00836                ,FUT_BILL_HOOK_INS_FL                             
P00836                ,BILL_ADJ_FLAG                                    
P00836                ,ELECTRIC_CHARGES                                 
P00836                ,GAS_CHARGES                                      
P00836                ,UNMETERED_CHARGES                                
P00836                ,TAXES                                            
P00836                ,WEB_CURRENT_CHARGES                              
P00836                ,SHOW_BILL_IMAGE_FL                               
P00836           )                                                      
P00836           SELECT TOP(12) RETURN_CODE,
              APPL_RETURN_CODE,
              ACCOUNT_NO,
              COMPANY_NO,
              BILL_MONTH,
              MAX(BILL_NO),
              MAX(DATE_BILLED),
              SUM(BILL_AMOUNT),
              SUM(PAYMENTS),
              SUM(OTHR_CHRGS),
              SUM(ARREARS),
              SUM(TOTAL_AMOUNT),
              ' ',
              ' ',
              ' ',
              ' ',
              ' ',
              SUM(ELECTRIC_CHARGES),
              SUM(GAS_CHARGES),
              SUM(UNMETERED_CHARGES),
              SUM(TAXES),
              SUM(WEB_CURRENT_CHARGES),
              CASE WHEN ( SUM(BILL_AMOUNT) = 0 AND           
P00836                               SUM(OTHR_CHRGS)  = 0 AND           
P00836                               SUM(ARREARS)     = 0 AND           
P00836                               SUM(PAYMENTS)    = 0   )           
P00836                   THEN 'N'  ELSE 'Y'  END                        
P00836           FROM  #CSR04623_R4                              
P00836           GROUP BY RETURN_CODE, APPL_RETURN_CODE, ACCOUNT_NO,    
P00836                    COMPANY_NO, BILL_MONTH                        
P00836           ORDER BY BILL_MONTH DESC                               
P00836                                          
P00836       END-EXEC.                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*          INSERT INTO SESSION.CSR04623_R1                                
MFA-TR*          (                                                              
MFA-TR*                RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,ACCOUNT_NO                                               
MFA-TR*               ,COMPANY_NO                                               
MFA-TR*               ,BILL_MONTH                                               
MFA-TR*               ,BILL_NO                                                  
MFA-TR*               ,DATE_BILLED                                              
MFA-TR*               ,BILL_AMOUNT                                              
MFA-TR*               ,PAYMENTS                                                 
MFA-TR*               ,OTHR_CHRGS                                               
MFA-TR*               ,ARREARS                                                  
MFA-TR*               ,TOTAL_AMOUNT                                             
MFA-TR*               ,CODE_BILL_STATUS                                         
MFA-TR*               ,CODE_BILL_TYPE                                           
MFA-TR*               ,PSNC_FLAG                                                
MFA-TR*               ,FUT_BILL_HOOK_INS_FL                                     
MFA-TR*               ,BILL_ADJ_FLAG                                            
MFA-TR*               ,ELECTRIC_CHARGES                                         
MFA-TR*               ,GAS_CHARGES                                              
MFA-TR*               ,UNMETERED_CHARGES                                        
MFA-TR*               ,TAXES                                                    
MFA-TR*               ,WEB_CURRENT_CHARGES                                      
MFA-TR*               ,SHOW_BILL_IMAGE_FL                                       
MFA-TR*          )                                                              
MFA-TR*          SELECT  RETURN_CODE                                            
MFA-TR*                 ,APPL_RETURN_CODE                                       
MFA-TR*                 ,ACCOUNT_NO                                             
MFA-TR*                 ,COMPANY_NO                                             
MFA-TR*                 ,BILL_MONTH                                             
MFA-TR*                 ,MAX(BILL_NO)                                           
MFA-TR*                 ,MAX(DATE_BILLED)                                       
MFA-TR*                 ,SUM(BILL_AMOUNT)                                       
MFA-TR*                 ,SUM(PAYMENTS)                                          
MFA-TR*                 ,SUM(OTHR_CHRGS)                                        
MFA-TR*                 ,SUM(ARREARS)                                           
MFA-TR*                 ,SUM(TOTAL_AMOUNT)                                      
MFA-TR*                 ,' '                                                    
MFA-TR*                 ,' '                                                    
MFA-TR*                 ,' '                                                    
MFA-TR*                 ,' '                                                    
MFA-TR*                 ,' '                                                    
MFA-TR*                 ,SUM(ELECTRIC_CHARGES)                                  
MFA-TR*                 ,SUM(GAS_CHARGES)                                       
MFA-TR*                 ,SUM(UNMETERED_CHARGES)                                 
MFA-TR*                 ,SUM(TAXES)                                             
MFA-TR*                 ,SUM(WEB_CURRENT_CHARGES)                               
MFA-TR*                 ,CASE WHEN ( SUM(BILL_AMOUNT) = 0 AND                   
MFA-TR*                              SUM(OTHR_CHRGS)  = 0 AND                   
MFA-TR*                              SUM(ARREARS)     = 0 AND                   
MFA-TR*                              SUM(PAYMENTS)    = 0   )                   
MFA-TR*                  THEN 'N'  ELSE 'Y'  END                                
MFA-TR*          FROM  SESSION.CSR04623_R4                                      
MFA-TR*          GROUP BY RETURN_CODE, APPL_RETURN_CODE, ACCOUNT_NO,            
MFA-TR*                   COMPANY_NO, BILL_MONTH                                
MFA-TR*          ORDER BY BILL_MONTH DESC                                       
MFA-TR*          FETCH FIRST 12 ROWS ONLY                                       
MFA-TR*      END-EXEC.                                                          

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00836*                                                                         
P00836       MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.  
P00836*                                                                         
P00836       IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
P00836          MOVE CTR-ROWS-RS4            TO  CTR-ROWS-RS1           
P00836       ELSE                                                       
P00836          MOVE PROGRAM-NAME            TO  ABEND-PROGRAM          
P00836          MOVE '8230'                  TO  ACTIVE-PARAGRAPH       
P00836          MOVE 'INSERT'                TO  ABEND-FUNCTION         
P00836          MOVE SQLCODE                 TO  ABEND-SQLCODE          
P00836          MOVE SPACES                  TO  ABEND-SQL-PREDICATES   
P00836                                           ABEND-TABLES           
P00836          MOVE 'CSR04623_R1'           TO  TABLE-1                
P00836          MOVE SPACES                  TO  TABLE-ELEMENT-1        
P00836          MOVE SPACES                  TO  HOSTVAR-ELEMENT-1      
P00836          PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT            
P00836       END-IF.                                                    
P00836*                                                                         
P00836  8230-EXIT.                                                      
P00836      EXIT.                                                       
P00836*                                                                         
P00836******************************************************************        
P00836** GET SUM OF CURRENT CHARGES AND COUNT OF ROWS                 **        
P00836******************************************************************        
P00836 8250-WEB-GET-SUM-AND-COUNT.                                      
P00836                                                                  
P00836      EXEC SQL                                                    
P00836           SELECT  SUM(WEB_CURRENT_CHARGES)                       
P00836                  ,COUNT(*)                                       
P00836             INTO  :S3-WEB-AVERAGE-BILL-AMT                       
P00836                  ,:CTR-ROWS-RS1                                  
P00836             FROM  #CSR04623_R1                            
P00836           GROUP BY ACCOUNT_NO                                    
P00836       END-EXEC.                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*          SELECT  SUM(WEB_CURRENT_CHARGES)                               
MFA-TR*                 ,COUNT(*)                                               
MFA-TR*            INTO  :S3-WEB-AVERAGE-BILL-AMT                               
MFA-TR*                 ,:CTR-ROWS-RS1                                          
MFA-TR*            FROM  SESSION.CSR04623_R1                                    
MFA-TR*          GROUP BY ACCOUNT_NO                                            
MFA-TR*      END-EXEC.                                                          

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00836*                                                                         
P00836       MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.  
P00836*                                                                         
P00836       IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
P00836          CONTINUE                                                
P00836       ELSE                                                       
P00836          MOVE PROGRAM-NAME            TO  ABEND-PROGRAM          
P00836          MOVE '8250'                  TO  ACTIVE-PARAGRAPH       
P00836          MOVE 'INSERT'                TO  ABEND-FUNCTION         
P00836          MOVE SQLCODE                 TO  ABEND-SQLCODE          
P00836          MOVE SPACES                  TO  ABEND-SQL-PREDICATES   
P00836                                           ABEND-TABLES           
P00836          MOVE 'CSR04623_R1'           TO  TABLE-1                
P00836          MOVE SPACES                  TO  TABLE-ELEMENT-1        
P00836          MOVE SPACES                  TO  HOSTVAR-ELEMENT-1      
P00836          PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT            
P00836       END-IF.                                                    
P00836*                                                                         
P00836  8250-EXIT.                                                      
P00836      EXIT.                                                       
P00836*                                                                         
      *****************************************************************         
      * 8800-CHECK-RESULTS.                                           *         
      *****************************************************************         
       8800-CHECK-RESULTS.                                              
      *                                                                         
           IF CTR-ROWS-RS1 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-1                            
              MOVE   0                       TO S1-RETURN-CODE          
              MOVE 100                       TO S1-APPL-RETURN-CODE     
              PERFORM 8100-INSERT-GTT-R1     THRU 8100-EXIT             
           END-IF.                                                      
      *                                                                         
           IF CTR-ROWS-RS2 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-2                            
              MOVE   0                       TO S2-RETURN-CODE          
              MOVE 100                       TO S2-APPL-RETURN-CODE     
              PERFORM 8110-INSERT-GTT-R2      THRU 8110-EXIT            
           END-IF.                                                      
      *                                                                         
           IF CTR-ROWS-RS3 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-3                            
              MOVE   0                       TO S3-RETURN-CODE          
              MOVE 100                       TO S3-APPL-RETURN-CODE     
              PERFORM 8120-INSERT-GTT-R3      THRU 8120-EXIT            
           END-IF.                                                      
                                                                        
       8800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8900-SEND-DONE.                                                *        
      ******************************************************************        
       8900-SEND-DONE.                                                  
      *                                                                         
           MOVE PROGRAM-NAME                 TO ABEND-PROGRAM           
           MOVE '8900'                       TO ACTIVE-PARAGRAPH        
           MOVE 'OPEN'                       TO ABEND-FUNCTION          
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S1-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE 'CSR04426_R1'             TO TABLE-1                 
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C2                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S2-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE 'CSR04426_R2'             TO TABLE-1                 
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C3                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C3 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S3-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE 'CSR04426_R3'             TO TABLE-1                 
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9000-SEND-ERROR-RESULT                                         *        
      ******************************************************************        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE       TO ABEND-SQLCODE            
                                               S1-RETURN-CODE           
                                               S2-RETURN-CODE           
                                               S3-RETURN-CODE.          
                                                                        
           MOVE WS-APPL-RETURN-CODE         TO S1-APPL-RETURN-CODE      
                                               S2-APPL-RETURN-CODE      
                                               S3-APPL-RETURN-CODE.     
                                                                        
           MOVE SQLERRMC                    TO ABEND-SQLERRMC.          
                                                                        
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'               TO ABEND-FUNCTION           
           END-IF.                                                      
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1        THRU 0100A-EXIT.         
           PERFORM 0100B-DECLARE-GTT-R2        THRU 0100B-EXIT.         
           PERFORM 0100C-DECLARE-GTT-R3        THRU 0100C-EXIT.         
                                                                        
           PERFORM 8100-INSERT-GTT-R1          THRU 8100-EXIT.          
           PERFORM 8110-INSERT-GTT-R2          THRU 8110-EXIT.          
           PERFORM 8120-INSERT-GTT-R3          THRU 8120-EXIT.          
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9700-ABEND-PROCESSING.                                         *        
      ******************************************************************        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT.             
           PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT.             
      *                                                                         
       9700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 9999-END-PROGRAM.                                              *        
      ******************************************************************        
       9999-END-PROGRAM.                                                
      *                                                                         
            PERFORM 8800-CHECK-RESULTS        THRU 8800-EXIT            
            PERFORM 8900-SEND-DONE            THRU 8900-EXIT            
                                                                        
           
MSQ016        GOBACK.                                                    
      *                                                                         
       9999-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
