       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04622.                                         
       AUTHOR.       SAKTHIVEL MATHIYAZHAGAN.                           
COB303 DATE-WRITTEN. MARCH 21, 2013.                                    
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM RETRIEVES THE USAGE HISTORY DETAILS FROM         *        
      *  CSS_CNSMPTN_HIST & CSS_BILL_CALC_DET TABLES BASED ON THE      *        
      *  PREMISE NO/ACCOUNT NO,UTIL TYPE AND IC_NO.                    *        
      *  THIS IS CALLED IN CIS & WEB APPLICATION.                      *        
      *                                                                *        
      *  CLONED FROM: CSR02101                                         *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
PRJ724*  03-29-13  MS93554    INITIAL PROGRAM VERSION.                 *        
PRJ724*  02-11-14  HA7A338    ADDED ADDITIONAL RESULT SET TO PULL SO   *        
      *                       AND WQ DETAILS.                          *        
PRJ821*  01-08-15  VK7L032    ADDITIONAL DETAILS IN THE RESULT SET     *        
ACT066*  03/16/15  VIJAY      ADD ACCOUNT_NO IN ORDER BY CLUASE IN     *        
ACT066*  A05136               BG-CURSOR.                               *        
P00836*  11/06/15  GD43988    WEB MOD CHANGES.                         *        
P01137*  02/24/17  SS45239    FIX SORT ORDER.                          *        
WEBFIX*  03/09/17  GD43988    A05745:FIX WEB SORT ORDER ISSUE.         *        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04622'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START         PIC X(40) VALUE                             
           'WORKING STORAGE FOR CSR04622 STARTS HERE'.                  
                                                                        
      *****************************************************************         
      *    DB2 INCLUDES                                               *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_BILLING_DET     BG                                     *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBBLLDET                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_BILLING_HDR     BI                                     *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBBLLHDR                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_CNSMPTN_HIST    CX                                     *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBCNSMP                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_BILL_CALC_DET   CX                                     *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBBLCLDT                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_LOCAL_OFFCIE    B1                                     *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBLOCOFC                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_ACCOUNT         AT                                     *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_TEMPERATURE     E8                                     *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBTEMPIN                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_MTRD_ENVRNMT    MN                                     *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBMTRENV                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_RATE_COMPONENT  N6                                     *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBRTCPNT                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_ORDER_TYPE      C2                                     *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBORTYP                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_WORK_TYPE       L4                                     *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBWKTYP                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_WK_CLASS_STAT   R6                                     *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBWKCST                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_SO_ORDER_INST   VI                                     *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBSOODR                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_SO_DATA         VO                                     *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBSODAT                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_WQ_ITEMS        WQ                                     *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBWQITS                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_WQ_CATEGORY     C3                                     *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBWQCAT                                                  
           END-EXEC.                                                            
      *****************************************************************         
PRJ821* CSS_ACCT_RTPK_AGR, DF                                         *         
PRJ821*****************************************************************         
PRJ821     EXEC SQL                                                             
PRJ821         INCLUDE TBACCTRG                                                 
PRJ821     END-EXEC.                                                            
PRJ821*                                                                         
PRJ821*****************************************************************         
PRJ821* CRM_RT_PKG_OPTION, FI                                         *         
PRJ821*****************************************************************         
PRJ821     EXEC SQL                                                             
PRJ821         INCLUDE TBRTPKGO                                                 
PRJ821     END-EXEC.                                                            
PRJ821*                                                                         
PRJ821*****************************************************************         
PRJ821* CSS_DELINQUENCY, C8                                           *         
PRJ821*****************************************************************         
PRJ821     EXEC SQL                                                             
PRJ821         INCLUDE TBDELQ                                                   
PRJ821     END-EXEC.                                                            
PRJ821*                                                                         
PRJ821*****************************************************************         
PRJ821*    CSS_RATE_PLAN_DESC  RD                                     *         
PRJ821*****************************************************************         
PRJ821     EXEC SQL                                                             
PRJ821         INCLUDE TBRTDESC                                                 
PRJ821     END-EXEC.                                                            
PRJ821                                                                  
P00836*****************************************************************         
P00836**  CSS_BILL_CRED_DET, 1H                                      **         
P00836*****************************************************************         
P00836     EXEC SQL                                                             
P00836       INCLUDE TBCRBLDL                                                   
P00836     END-EXEC.                                                            
P00836*                                                                         
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
       01  WS-MISC.                                                     
           05 PROGRAM-NAME             PIC X(8)        VALUE 'CSR04622'.
           05 WS-APPL-RETURN-CODE      PIC S9(4)       VALUE 0.         
           05 WS-KWH-UNITS             PIC S9(09)V     COMP-3 VALUE 0.  
           05 WS-NULL-IND              PIC S9(04)      COMP.            
           05 WS-WNA-AMOUNT            PIC S9(09)V9(2) COMP-3 VALUE 0.  
           05 WS-NO-DAYS               PIC S9(04)      COMP VALUE 0.    
           05 WS-NO-UNITS              PIC S9(9)V      USAGE COMP-3     
                                                       VALUE 0.         
           05 WS-INCLD-ADDTNL-HIST     PIC X(01)       VALUE 'N'.       
           05 WS-INCLD-EVENTS          PIC X(01)       VALUE 'N'.       
           05 WS-EXCLD-CNCL-CNSMPTN    PIC X(01)       VALUE 'N'.       
           05 WS-EXCLD-UNBLD-CNSMPTN   PIC X(01)       VALUE 'N'.       
           05 WS-NO-OF-BILLS           PIC S9(4)       VALUE 0 COMP.    
           05 WS-CALC                  PIC S9(04)V999  COMP VALUE 0.    
           05 WS-HOLD-ACCUMDEG         PIC S9(06)V999  COMP VALUE 0.    
           05 WS-HOLD-ACCUM-TMP        PIC S9(06)      COMP VALUE 0.    
COB305     05 WS-RATIO        PIC S9(9)V999 USAGE COMP-3 VALUE 0.    
           05 WS-DATE-TO-BE-READ       PIC X(10)       VALUE SPACES.    
           05 WS-CCF-UNITS             PIC S9(9)V      COMP-3 VALUE 0.  
           05 WS-A                     PIC S9(04)V999  COMP VALUE 0.    
           05 WS-THERMS                PIC S9(9)V      COMP-3 VALUE 0.  
           05 WS-WNA-COMP-AM           PIC S9(9)V9(2)  COMP-3 VALUE 0.  
           05 WS-DATE-READ             PIC X(10)       VALUE SPACES.    
           05 WS-READ-UNITS-NULL       PIC S9(04)      COMP VALUE 0.    
           05 WS-FILTER-BY-PREMISE     PIC X(01)       VALUE 'N'.       
           05 WS-FILTER-BY-ACCT        PIC X(01)       VALUE 'N'.       
           05 WS-ACCOUNT-NO            PIC S9(13)V     COMP-3 VALUE 0.  
           05 WS-PREMISE-NO            PIC X(10).                       
           05 WS-PREMISE-NO-NUM REDEFINES WS-PREMISE-NO                 
                                       PIC 9(10).                       
           05 WS-CODE-UTIL-TYPE        PIC X(01)       VALUE SPACES.    
           05 WS-IC-NO                 PIC S9(04)      COMP-3 VALUE 0.  
           05 WS-BILL-EXIST-FL         PIC X(01)       VALUE 'N'.       
P00836     05 WS-SHOW-LATEST-BILL-FL   PIC X(01)       VALUE 'Y'.       
P00836     05 WS-WEB-REV-MTH-LATEST    PIC S9(6)V COMP-3 VALUE 0.       
      *                                                                         
       01  WS-REV-YEAR-MONTH.                                           
           05  WS-REVENUE-MONTH             PIC S9(06)V.                
           05  WS-REV-MONTH-RED             REDEFINES WS-REVENUE-MONTH. 
               10 WS-REV-MONTH-YY           PIC 9(04).                  
               10 WS-REV-MONTH-MM           PIC 9(02).                  
           05  WS-CUTOFF-REV-MTH            PIC S9(06) VALUE ZERO.      
           05  WS-REV-MTH-CUTOFF-CNT        PIC S9(03) VALUE 0.         
      *                                                                         
                                                                        
       01  WS-FLAGS.                                                    
           05 WS-PREMISE               PIC X(01)  VALUE 'P'.            
           05 WS-ACCT                  PIC X(01)  VALUE 'A'.            
P00836     05 WS-WEB                   PIC X(01)  VALUE 'W'.            
           05 WS-CREDIT                PIC X(01)  VALUE 'C'.            
           05 WS-ELEC                  PIC X(01)  VALUE 'E'.            
           05 WS-GAS                   PIC X(01)  VALUE 'G'.            
           05 WS-YES                   PIC X(01)  VALUE 'Y'.            
           05 WS-NO                    PIC X(01)  VALUE 'N'.            
           05 WS-SYSTEM-ESTIMATED      PIC X(01)  VALUE 'E'.            
           05 WS-KWH                   PIC X(01)  VALUE 'B'.            
           05 WS-ENERGY                PIC X(01)  VALUE 'R'.            
           05 WS-DEKATHERMS            PIC X(01)  VALUE 'D'.            
           05 WS-CCF                   PIC X(01)  VALUE 'C'.            
           05 WS-KW-DEMAND             PIC X(01)  VALUE 'J'.            
           05 WS-ZERO                  PIC S9(04) VALUE 0.              
           05 WS-ONE                   PIC S9(04) VALUE 1.              
           05 WS-TWO                   PIC S9(04) VALUE 2.              
           05 WS-THREE                 PIC S9(04) VALUE 3.              
           05 WS-12                    PIC S9(4) COMP                   
                                                  VALUE 12.             
           05 WS-DFLT-NO-OF-REVMON     PIC 9(03)  VALUE 12.             
           05 WS-ALL-REV-MONTHS        PIC 9(06)  VALUE 999999.         
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
           05  WS-BACKOUT-SW           PIC X(01) VALUE 'N'.             
               88 BACKOUT-ITEM                   VALUE 'Y'.             
           05  WS-STOP-USAGE-PRCS      PIC X(01) VALUE 'N'.             
               88 STOP-USAGE-PRCS                VALUE 'Y'.             
           05  WS-REBILL-SW            PIC X(01) VALUE 'N'.             
               88 REBILL-ITEM                    VALUE 'Y'.             
           05  WS-NO-MORE-BG-ROWS      PIC X(01) VALUE 'N'.             
               88 NO-MORE-BG-ROWS                VALUE 'Y'.             
           05  WS-NO-MORE-CX-ROWS      PIC X(01) VALUE 'N'.             
               88 NO-MORE-CX-ROWS                VALUE 'Y'.             
           05  WS-NO-MORE-BZ-ROWS      PIC X(01) VALUE 'N'.             
               88 NO-MORE-BZ-ROWS                VALUE 'Y'.             
           05  WS-NO-MORE-E8-ROWS      PIC X(01) VALUE 'N'.             
               88 NO-MORE-E8-ROWS                VALUE 'Y'.             
           05  WS-NO-MORE-VO-ROWS      PIC X(01) VALUE 'N'.             
               88 NO-MORE-VO-ROWS                VALUE 'Y'.             
           05  WS-NO-MORE-YV-ROWS      PIC X(01) VALUE 'N'.             
               88 NO-MORE-YV-ROWS                VALUE 'Y'.             
           05  WS-NO-MORE-WQ-ROWS      PIC X(01) VALUE 'N'.             
               88 NO-MORE-WQ-ROWS                VALUE 'Y'.             
                                                                        
PRJ821     05  WS-DATABASE             PIC 9(01) VALUE ZERO.            
PRJ821         88  CSR-DATABASE                  VALUE 1.               
PRJ821         88  SEB-DATABASE                  VALUE 2.               
                                                                        
PRJ821     05 WS-PREV-RATE-PLAN-NO     PIC X(03) VALUE SPACES.          
PRJ821     05 WS-PREV-ACCOUNT-NO       PIC S9(13)V COMP-3 VALUE 0.      
PRJ821     05 WS-PREV-CODE-UTIL-TYPE   PIC X(01) VALUE SPACES.          
PRJ821     05 WS-PREV-IC-NO            PIC S9(04)  COMP-3 VALUE 0.      
PRJ821     05 WS-PREV-RT-PKG-OPT-SEQ-NO PIC S9(4) USAGE COMP.           
                                                                        
PRJ821     05 WS-OPTION-CD             PIC X(12) VALUE SPACES.          
PRJ821     05 WS-OPTION-DESC           PIC X(50) VALUE SPACES.          
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS-RS1            PIC S9(9) COMP VALUE 0.          
           05  CTR-ROWS-RS2            PIC S9(9) COMP VALUE 0.          
           05  CTR-ROWS-RS3            PIC S9(9) COMP VALUE 0.          
P00836     05  CTR-ROWS-RS4            PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
                                                                        
       01  TDS-RETURN-FIELDS.                                           
            05 RS-ACCOUNT-NO           PIC S9(13)V    COMP-3 VALUE 0.   
            05 RS-AMT-BILL-ITEM        PIC S9(9)V9(2) COMP-3 VALUE 0.   
            05 RS-UTILITY-USG-AMT      PIC S9(9)V9(2) COMP-3 VALUE 0.   
            05 RS-AVG-COST-PER-USG     PIC S9(5)V9(4) COMP-3 VALUE 0.   
            05 RS-RATE-PLAN-NO         PIC X(03)      VALUE SPACES.     
            05 RS-BTU-FACTOR           PIC S9(2)V9(5) COMP-3 VALUE 0.   
            05 RS-WNA-FACTOR           PIC S9(2)V9(5) COMP-3 VALUE 0.   
            05 RS-DATE-READ            PIC X(10)      VALUE SPACES.     
            05 RS-PER-DAY-USE          PIC S9(9)V9(3) COMP-3 VALUE 0.   
            05 RS-NO-DAYS              PIC S9(4)      COMP VALUE 0.     
            05 RS-ESTIMATE-ADJUSTED    PIC X(1)       VALUE SPACES.     
            05 RS-CONSTANT             PIC S9(6)V9(5) COMP-3 VALUE 0.   
            05 RS-THERMS               PIC S9(9)V     COMP-3 VALUE 0.   
            05 RS-UNITS                PIC S9(9)V     COMP-3 VALUE 0.   
            05 RS-CNSMPTN-TYPE         PIC X(03)      VALUE SPACES.     
            05 RS-ACTUAL-ONPEAK        PIC S9(9)V     COMP-3 VALUE 0.   
            05 RS-BILLED-ONPEAK        PIC S9(9)V     COMP-3 VALUE 0.   
            05 RS-ONPEAK-DIFF          PIC S9(9)V     COMP-3 VALUE 0.   
            05 RS-ACTUAL-OFFPEAK       PIC S9(9)V     COMP-3 VALUE 0.   
            05 RS-BILLED-OFFPEAK       PIC S9(9)V     COMP-3 VALUE 0.   
            05 RS-OFFPEAK-DIFF         PIC S9(9)V     COMP-3 VALUE 0.   
            05 RS-ACTUAL-SHLDR         PIC S9(9)V     COMP-3 VALUE 0.   
            05 RS-BILLED-SHLDR         PIC S9(9)V     COMP-3 VALUE 0.   
            05 RS-SHLDR-DIFF           PIC S9(9)V     COMP-3 VALUE 0.   
            05 RS-COMBINED-READING     PIC X(1)       VALUE 'N'.        
            05 RS-BILL-NO              PIC S9(9)      COMP VALUE 0.     
            05 RS-BILL-ITEM-TMSTMP     PIC X(26)      VALUE SPACES.     
            05 RS-WNA-AMOUNT           PIC S9(9)V9(2) COMP-3 VALUE 0.   
            05 RS-SAME-ACCOUNT         PIC X(01)      VALUE 'N'.        
            05 RS-EMPLOYEE-NO          PIC S9(9)      USAGE COMP.       
            05 RS-CODE-SOURCE-ID       PIC X(10)      VALUE SPACES.     
            05 RS-DEGREE-DAYS          PIC S9(6)      COMP VALUE 0.     
            05 RS-RATIO                PIC S9(9)V999  USAGE COMP-3      
                                                      VALUE 0.          
            05 RS-COMPANY-NO           PIC X(2)       VALUE SPACES.     
            05 RS-INDUS-GAS-RATE       PIC X(1)       VALUE 'N'.        
            05 RS-METER-READING        PIC S9(11)V    COMP-3 VALUE 0.   
            05 RS-REVENUE-MONTH        PIC S9(06)V    COMP-3 VALUE 0.   
            05 RS-REV-MTH-ORIG-BILL    PIC S9(06)V    COMP-3 VALUE 0.   
            05 RS-CODE-UTIL-TYPE       PIC X(01)      VALUE SPACES.     
            05 RS-IC-NO                PIC S9(04)     COMP-3 VALUE 0.   
            05 RS-METER-NO             PIC X(09)      VALUE SPACES.     
            05 RS-METER-REF-NO         PIC S9(04)     COMP-3 VALUE 0.   
            05 RS-EVENT-DESC           PIC X(50)      VALUE SPACES.     
            05 RS-EVENT-STATUS         PIC X(01)      VALUE SPACES.     
            05 RS-COMPLETED-DATE       PIC X(26)      VALUE SPACES.     
            05 RS-CNCLD-FLG            PIC X(01)      VALUE SPACES.     
PRJ821      05 RS-RATE-PLAN-DESC       PIC X(50)      VALUE SPACES.     
PRJ821      05 RS-OPTION-CD            PIC X(12)      VALUE SPACES.     
PRJ821      05 RS-OPTION-DESC          PIC X(50)      VALUE SPACES.     
P00836      05 RS-DATE-BILLED          PIC X(10)      VALUE SPACES.     
P00836      05 RS-CODE-BILL-CALC       PIC X(01)      VALUE SPACES.     
P00836      05 RS-CODE-BILL-ITM-TYPE   PIC X(01)      VALUE SPACES.     
P00836      05 RS-CODE-BILL-ITM-IND    PIC X(01)      VALUE SPACES.     
P00836      05 RS-CODE-BILL-TYPE       PIC X(01)      VALUE SPACES.     
                                                                        
       01  GTT-RETURN-FIELDS.                                           
         05  GTT-RETURN-FIELDS-1.                                       
            10 S1-RETURN-CODE          PIC S9(9)      COMP VALUE 0.     
            10 S1-APPL-RETURN-CODE     PIC S9(9)      COMP VALUE 0.     
            10 S1-ACCOUNT-NO           PIC S9(13)V    COMP-3 VALUE 0.   
            10 S1-AMT-BILL-ITEM        PIC S9(9)V9(2) COMP-3 VALUE 0.   
            10 S1-UTILITY-USG-AMT      PIC S9(9)V9(2) COMP-3 VALUE 0.   
            10 S1-AVG-COST-PER-USG     PIC S9(5)V9(4) COMP-3 VALUE 0.   
            10 S1-RATE-PLAN-NO         PIC X(03)      VALUE SPACES.     
            10 S1-BTU-FACTOR           PIC S9(2)V9(5) COMP-3 VALUE 0.   
            10 S1-WNA-FACTOR           PIC S9(2)V9(5) COMP-3 VALUE 0.   
            10 S1-DATE-READ            PIC X(10)      VALUE SPACES.     
            10 S1-PER-DAY-USE          PIC S9(9)V9(3) COMP-3 VALUE 0.   
            10 S1-NO-DAYS              PIC S9(4)      COMP VALUE 0.     
            10 S1-ESTIMATE-ADJUSTED    PIC X(1)       VALUE SPACES.     
            10 S1-CONSTANT             PIC S9(6)V9(5) COMP-3 VALUE 0.   
            10 S1-THERMS               PIC S9(9)V     COMP-3 VALUE 0.   
            10 S1-UNITS                PIC S9(9)V     COMP-3 VALUE 0.   
            10 S1-CNSMPTN-TYPE         PIC X(03)      VALUE SPACES.     
            10 S1-ACTUAL-ONPEAK        PIC S9(9)V     COMP-3 VALUE 0.   
            10 S1-BILLED-ONPEAK        PIC S9(9)V     COMP-3 VALUE 0.   
            10 S1-ONPEAK-DIFF          PIC S9(9)V     COMP-3 VALUE 0.   
            10 S1-ACTUAL-OFFPEAK       PIC S9(9)V     COMP-3 VALUE 0.   
            10 S1-BILLED-OFFPEAK       PIC S9(9)V     COMP-3 VALUE 0.   
            10 S1-OFFPEAK-DIFF         PIC S9(9)V     COMP-3 VALUE 0.   
            10 S1-ACTUAL-SHLDR         PIC S9(9)V     COMP-3 VALUE 0.   
            10 S1-BILLED-SHLDR         PIC S9(9)V     COMP-3 VALUE 0.   
            10 S1-SHLDR-DIFF           PIC S9(9)V     COMP-3 VALUE 0.   
            10 S1-COMBINED-READING     PIC X(1)       VALUE 'N'.        
            10 S1-BILL-NO              PIC S9(9)      COMP VALUE 0.     
            10 S1-BILL-ITEM-TMSTMP     PIC X(26)      VALUE SPACES.     
            10 S1-WNA-AMOUNT           PIC S9(9)V9(2) COMP-3 VALUE 0.   
            10 S1-SAME-ACCOUNT         PIC X(01)      VALUE 'N'.        
            10 S1-EMPLOYEE-NO          PIC S9(9)      USAGE COMP.       
            10 S1-CODE-SOURCE-ID       PIC X(10)      VALUE SPACES.     
            10 S1-DEGREE-DAYS          PIC S9(6)      COMP VALUE 0.     
            10 S1-RATIO                PIC S9(9)V999  USAGE COMP-3      
                                                      VALUE 0.          
            10 S1-COMPANY-NO           PIC X(2)       VALUE SPACES.     
            10 S1-INDUS-GAS-RATE       PIC X(1)       VALUE 'N'.        
            10 S1-METER-READING        PIC S9(11)V    COMP-3 VALUE 0.   
            10 S1-REVENUE-MONTH        PIC S9(06)V    COMP-3 VALUE 0.   
            10 S1-REV-MTH-ORIG-BILL    PIC S9(06)V    COMP-3 VALUE 0.   
            10 S1-CNCLD-FLG            PIC X(01)      VALUE SPACES.     
                                                                        
PRJ821      05 S1-RATE-PLAN-DESC       PIC X(50)      VALUE SPACES.     
PRJ821      05 S1-OPTION-CD            PIC X(12)      VALUE SPACES.     
PRJ821      05 S1-OPTION-DESC          PIC X(50)      VALUE SPACES.     
P00836      05 S1-DATE-BILLED          PIC X(10)      VALUE SPACES.     
P00836      05 S1-CODE-BILL-CALC       PIC X(01)      VALUE SPACES.     
P00836      05 S1-CODE-BILL-ITM-TYPE   PIC X(01)      VALUE SPACES.     
P00836      05 S1-CODE-BILL-ITM-IND    PIC X(01)      VALUE SPACES.     
P00836      05 S1-CODE-BILL-TYPE       PIC X(01)      VALUE SPACES.     
                                                                        
         05  GTT-RETURN-FIELDS-2.                                       
            10 S2-RETURN-CODE          PIC S9(9)      COMP VALUE 0.     
            10 S2-APPL-RETURN-CODE     PIC S9(9)      COMP VALUE 0.     
            10 S2-ACCOUNT-NO           PIC S9(13)V    COMP-3 VALUE 0.   
            10 S2-CODE-UTIL-TYPE       PIC X(01)      VALUE SPACES.     
            10 S2-IC-NO                PIC S9(04)     COMP-3 VALUE 0.   
            10 S2-METER-NO             PIC X(09)      VALUE SPACES.     
            10 S2-METER-REF-NO         PIC S9(04)     COMP-3 VALUE 0.   
            10 S2-EVENT-DESC           PIC X(50)      VALUE SPACES.     
            10 S2-EVENT-STATUS         PIC X(01)      VALUE SPACES.     
            10 S2-COMPLETED-DATE       PIC X(26)      VALUE SPACES.     
                                                                        
         05  GTT-RETURN-FIELDS-3.                                       
            10 S3-RETURN-CODE          PIC S9(9)      COMP VALUE 0.     
            10 S3-APPL-RETURN-CODE     PIC S9(9)      COMP VALUE 0.     
            10 S3-ADDTNAL-USAGE-EXISTS PIC X(01)      VALUE 'N'.        
                                                                        
      ******************************************************************        
      *   CURSOR TO RETRIEVE A SET OF ROWS FROM THE CSS_BILLING_DET    *        
      *   TABLE BASED ON THE PREMISE,IC & UTIL TYPE.                   *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
             DECLARE BG_CURSOR CURSOR FOR                               
             SELECT BG.ACCOUNT_NO                                       
                   ,BG.BILL_NO                                          
                   ,BG.CODE_UTIL_TYPE                                   
                   ,BG.IC_NO                                            
                   ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           BG.BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP                               
                   ,BG.CODE_DR_CR_CNSMPTN                               
                   ,BG.RATE_PLAN_NO                                     
                   ,BG.AMT_BILL_ITEM                                    
                   ,BG.BTU_FACTOR                                       
                   ,BG.GAS_BASE_USE                                     
                   ,BG.WNA_FACTOR                                       
                   ,BG.COMPANY_NO                                       
                   ,BG.REV_RPT_CD                                       
                   ,BG.REVENUE_MONTH                                    
                   ,BG.REV_MTH_ORIG_BILL                                
                   ,BG.REBILL_IND                                       
P00836             ,BG.CODE_BILL_CALC                                   
                   ,BG.CODE_BILL_ITM_TYPE                               
                   ,BG.CODE_BILL_ITM_IND                                
                   ,BI.DATE_BILLED                                      
PRJ821             ,BG.RT_PKG_OPT_SEQ_NO                                
P00836             ,BI.CODE_BILL_TYPE                                   
               FROM CSS_BILLING_DET BG WITH(READUNCOMMITTED)                    
                   ,CSS_BILLING_HDR BI WITH(READUNCOMMITTED)                    
              WHERE BG.ACCOUNT_NO              = BI.ACCOUNT_NO          
                AND BG.BILL_NO                 = BI.BILL_NO             
                AND BG.CODE_UTIL_TYPE          = :BG-CODE-UTIL-TYPE     
                AND BG.IC_NO                   = :BG-IC-NO              
                AND ((BG.CODE_BILL_CALC         = 'A'                   
                     AND BG.CODE_BILL_ITM_TYPE  = 'C'                   
                     AND BG.CODE_BILL_ITM_IND   = 'A'                   
                     AND :WS-EXCLD-CNCL-CNSMPTN = :WS-YES)              
                      OR :WS-EXCLD-CNCL-CNSMPTN = :WS-NO )              
                AND ((BG.PREMISE_NO             = :BG-PREMISE-NO        
                     AND :WS-FILTER-BY-PREMISE  = :WS-YES)              
                             OR                                         
                    (BG.ACCOUNT_NO              = :WS-ACCOUNT-NO        
                     AND :WS-FILTER-BY-ACCT     = :WS-YES))             
ACT066        ORDER BY BG.ACCOUNT_NO                                    
                     , BG.BILL_NO DESC                                  
                FOR READ ONLY                                   
                                                            
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE BG_CURSOR CURSOR FOR                                       
MFA-TR*      SELECT BG.ACCOUNT_NO                                               
MFA-TR*            ,BG.BILL_NO                                                  
MFA-TR*            ,BG.CODE_UTIL_TYPE                                           
MFA-TR*            ,BG.IC_NO                                                    
MFA-TR*            ,BG.BILL_ITEM_TIMESTMP                                       
MFA-TR*            ,BG.CODE_DR_CR_CNSMPTN                                       
MFA-TR*            ,BG.RATE_PLAN_NO                                             
MFA-TR*            ,BG.AMT_BILL_ITEM                                            
MFA-TR*            ,BG.BTU_FACTOR                                               
MFA-TR*            ,BG.GAS_BASE_USE                                             
MFA-TR*            ,BG.WNA_FACTOR                                               
MFA-TR*            ,BG.COMPANY_NO                                               
MFA-TR*            ,BG.REV_RPT_CD                                               
MFA-TR*            ,BG.REVENUE_MONTH                                            
MFA-TR*            ,BG.REV_MTH_ORIG_BILL                                        
MFA-TR*            ,BG.REBILL_IND                                               
MFA-TR*            ,BG.CODE_BILL_CALC                                           
MFA-TR*            ,BG.CODE_BILL_ITM_TYPE                                       
MFA-TR*            ,BG.CODE_BILL_ITM_IND                                        
MFA-TR*            ,BI.DATE_BILLED                                              
MFA-TR*            ,BG.RT_PKG_OPT_SEQ_NO                                        
MFA-TR*            ,BI.CODE_BILL_TYPE                                           
MFA-TR*        FROM CSS_BILLING_DET BG                                          
MFA-TR*            ,CSS_BILLING_HDR BI                                          
MFA-TR*       WHERE BG.ACCOUNT_NO              = BI.ACCOUNT_NO                  
MFA-TR*         AND BG.BILL_NO                 = BI.BILL_NO                     
MFA-TR*         AND BG.CODE_UTIL_TYPE          = :BG-CODE-UTIL-TYPE             
MFA-TR*         AND BG.IC_NO                   = :BG-IC-NO                      
MFA-TR*         AND ((BG.CODE_BILL_CALC         = 'A'                           
MFA-TR*              AND BG.CODE_BILL_ITM_TYPE  = 'C'                           
MFA-TR*              AND BG.CODE_BILL_ITM_IND   = 'A'                           
MFA-TR*              AND :WS-EXCLD-CNCL-CNSMPTN = :WS-YES)                      
MFA-TR*               OR :WS-EXCLD-CNCL-CNSMPTN = :WS-NO )                      
MFA-TR*         AND ((BG.PREMISE_NO             = :BG-PREMISE-NO                
MFA-TR*              AND :WS-FILTER-BY-PREMISE  = :WS-YES)                      
MFA-TR*                      OR                                                 
MFA-TR*             (BG.ACCOUNT_NO              = :WS-ACCOUNT-NO                
MFA-TR*              AND :WS-FILTER-BY-ACCT     = :WS-YES))                     
MFA-TR*       ORDER BY BG.ACCOUNT_NO                                            
MFA-TR*              , BG.BILL_NO DESC                                          
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*     QUERYNO 7110                                                        
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CURSOR TO RETRIEVE THE ROWS FROM CSS_CNSMPTN_HIST TABLE        *        
      * BASED ON THE ACCOUNT NUMBER THAT FETCHED FROM BG TABLE.        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
             DECLARE CX_CURSOR CURSOR FOR                               
             SELECT NO_UNITS                                            
                   ,NO_DAYS                                             
                   ,CODE_DEBIT_CREDIT                                   
                   ,CODE_METER_READ                                     
                   ,CODE_METER_NO_READ                                  
                   ,CAST(DATE_READ AS CHAR(10))                                 
                   ,CONSTANT                                            
                   ,EMPLOYEE_NO                                         
                   ,CODE_SOURCE_ID                                      
                   ,BTU_FACTOR                                          
                   ,METER_READING                                       
               FROM CSS_CNSMPTN_HIST WITH(READUNCOMMITTED)                      
              WHERE ACCOUNT_NO         = :CX-ACCOUNT-NO                 
                AND CODE_UTIL_TYPE     = :CX-CODE-UTIL-TYPE             
                AND BILL_NO            = :CX-BILL-NO                    
                AND IC_NO              = :CX-IC-NO                      
                AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :CX-BILL-ITEM-TIMESTMP
              )         
                AND CODE_USAGE_ID NOT IN ('1','2','3','4','5',          
                                          '6','7','8','9')              
                AND CODE_USAGE_SOURCE IN ('B','J','K')                  
              ORDER BY DATE_READ DESC                                   
                      ,CODE_USAGE_TYPE ASC                              
                      ,CODE_TIME_PERIOD ASC                             
                      ,CODE_TOU_SEASN ASC                               
P01137                ,MTR_REF_NO ASC                                   
                FOR READ ONLY                                   
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE CX_CURSOR CURSOR FOR                                       
MFA-TR*      SELECT NO_UNITS                                                    
MFA-TR*            ,NO_DAYS                                                     
MFA-TR*            ,CODE_DEBIT_CREDIT                                           
MFA-TR*            ,CODE_METER_READ                                             
MFA-TR*            ,CODE_METER_NO_READ                                          
MFA-TR*            ,CHAR(DATE_READ)                                             
MFA-TR*            ,CONSTANT                                                    
MFA-TR*            ,EMPLOYEE_NO                                                 
MFA-TR*            ,CODE_SOURCE_ID                                              
MFA-TR*            ,BTU_FACTOR                                                  
MFA-TR*            ,METER_READING                                               
MFA-TR*        FROM CSS_CNSMPTN_HIST                                            
MFA-TR*       WHERE ACCOUNT_NO         = :CX-ACCOUNT-NO                         
MFA-TR*         AND CODE_UTIL_TYPE     = :CX-CODE-UTIL-TYPE                     
MFA-TR*         AND BILL_NO            = :CX-BILL-NO                            
MFA-TR*         AND IC_NO              = :CX-IC-NO                              
MFA-TR*         AND BILL_ITEM_TIMESTMP = :CX-BILL-ITEM-TIMESTMP                 
MFA-TR*         AND CODE_USAGE_ID NOT IN ('1','2','3','4','5',                  
MFA-TR*                                   '6','7','8','9')                      
MFA-TR*         AND CODE_USAGE_SOURCE IN ('B','J','K')                          
MFA-TR*       ORDER BY DATE_READ DESC                                           
MFA-TR*               ,CODE_USAGE_TYPE ASC                                      
MFA-TR*               ,CODE_TIME_PERIOD ASC                                     
MFA-TR*               ,CODE_TOU_SEASN ASC                                       
MFA-TR*               ,MTR_REF_NO ASC                                           
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*     QUERYNO 7410                                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      **  CURSOR TO RETRIEVE THE ROWS FROM CSS_BILL_CALC_DET TABLE     *        
      **  BASED ON THE ACCOUNT NUMBER THAT FETCHED FROM BG TABLE.      *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
             DECLARE BZ_CURSOR CURSOR FOR                               
             SELECT BILL_UNITS                                          
                   ,READ_UNITS                                          
                   ,INSTR_USE_TYPE_CD                                   
                   ,CONSUMPT_TYPE_CD                                    
                   ,CODE_TIME_PERIOD                                    
                   ,WNA_COMP_AM                                         
                   ,CMPNT_ID_CD                                         
                   ,CALC_COMP_AM                                        
               FROM CSS_BILL_CALC_DET WITH(READUNCOMMITTED)                     
              WHERE ACCOUNT_NO         = :BZ-ACCOUNT-NO                 
                AND CODE_UTIL_TYPE     = :BZ-CODE-UTIL-TYPE             
                AND BILL_NO            = :BZ-BILL-NO                    
                AND IC_NO              = :BZ-IC-NO                      
                AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :BZ-BILL-ITEM-TIMESTMP
              )         
                FOR READ ONLY                                   
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE BZ_CURSOR CURSOR FOR                                       
MFA-TR*      SELECT BILL_UNITS                                                  
MFA-TR*            ,READ_UNITS                                                  
MFA-TR*            ,INSTR_USE_TYPE_CD                                           
MFA-TR*            ,CONSUMPT_TYPE_CD                                            
MFA-TR*            ,CODE_TIME_PERIOD                                            
MFA-TR*            ,WNA_COMP_AM                                                 
MFA-TR*            ,CMPNT_ID_CD                                                 
MFA-TR*            ,CALC_COMP_AM                                                
MFA-TR*        FROM CSS_BILL_CALC_DET                                           
MFA-TR*       WHERE ACCOUNT_NO         = :BZ-ACCOUNT-NO                         
MFA-TR*         AND CODE_UTIL_TYPE     = :BZ-CODE-UTIL-TYPE                     
MFA-TR*         AND BILL_NO            = :BZ-BILL-NO                            
MFA-TR*         AND IC_NO              = :BZ-IC-NO                              
MFA-TR*         AND BILL_ITEM_TIMESTMP = :BZ-BILL-ITEM-TIMESTMP                 
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*     QUERYNO 7510                                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  CURSOR TO RETRIEVE A SET OF ROWS FROM CSS_TEMPERATURE TABLE   *        
      *  FRO THE GIVEN TIME PERIOD.                                    *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
             DECLARE TEMP_CURSOR CURSOR FOR                             
             SELECT TEMP_DT                                             
                   ,CHAS_HIGH                                           
                   ,AIKEN_HIGH                                          
                   ,COLA_HIGH                                           
                   ,CHAS_LOW                                            
                   ,AIKEN_LOW                                           
                   ,COLA_LOW                                            
               FROM CSS_TEMPERATURE WITH(READUNCOMMITTED)                       
              WHERE TEMP_DT    <=  DATEADD(D, (CIS.DAYS( 
              IIF(TRY_CONVERT(DATE, :WS-DATE-READ
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-READ
              ) <> 0) OR (LEN(:WS-DATE-READ) <> 10), CIS.CHAR2DATE(
                                                          :WS-DATE-READ
              ), CONVERT(DATE, :WS-DATE-READ) ) ) -1)-1, 
              CAST('00010101' AS DATE))         
                AND TEMP_DT    >=  IIF(TRY_CONVERT(DATE, 
                                                    :WS-DATE-TO-BE-READ
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-TO-BE-READ
              ) <> 0) OR (LEN(:WS-DATE-TO-BE-READ
              ) <> 10), CIS.CHAR2DATE(:WS-DATE-TO-BE-READ
              ), CONVERT(DATE, :WS-DATE-TO-BE-READ) )                  
                AND COMPANY_NO  =  :AT-COMPANY-NO                       
                FOR READ ONLY                                   
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE TEMP_CURSOR CURSOR FOR                                     
MFA-TR*      SELECT TEMP_DT                                                     
MFA-TR*            ,CHAS_HIGH                                                   
MFA-TR*            ,AIKEN_HIGH                                                  
MFA-TR*            ,COLA_HIGH                                                   
MFA-TR*            ,CHAS_LOW                                                    
MFA-TR*            ,AIKEN_LOW                                                   
MFA-TR*            ,COLA_LOW                                                    
MFA-TR*        FROM CSS_TEMPERATURE                                             
MFA-TR*       WHERE TEMP_DT    <=  DATE(DAYS(:WS-DATE-READ) -1)                 
MFA-TR*         AND TEMP_DT    >=  :WS-DATE-TO-BE-READ                          
MFA-TR*         AND COMPANY_NO  =  :AT-COMPANY-NO                               
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*     QUERYNO 7550                                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  CURSOR TO RETRIEVE SERVICE ORDER DETAILS AT PREMISE LEVEL     *        
      *  FROM SERVICE ORDER TABLE.                                     *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
             DECLARE SO_CUR_CURSOR CURSOR FOR                           
             SELECT  VO.ACCOUNT_NO                                      
                    ,VI.CODE_UTIL_TYPE                                  
                    ,VI.IC_NO                                           
                    ,VI.METER_NO                                        
                    ,VI.MTR_REF_NO                                      
                    ,C2.ORDER_TYPE_DESC                                 
                    ,VO.ORDER_STATE_CD                                  
                    ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           VO.COMPLETED_DATETIME, 121), ' ', '-'), ':', '.') 
           COMPLETED_DATETIME                              
               FROM  CSS_ORDER_TYPE       C2 WITH(READUNCOMMITTED)              
                    ,CSS_SO_ORDER_INST    VI WITH(READUNCOMMITTED)              
                    ,CSS_WK_CLASS_STAT    R6 WITH(READUNCOMMITTED)              
                    ,CSS_SO_DATA          VO WITH(READUNCOMMITTED)              
              WHERE VO.ACCOUNT_NO         = :WS-ACCOUNT-NO              
                AND VO.COMPANY_NO         = C2.COMPANY_NO               
                AND VO.ORDER_TYPE_CD      = C2.ORDER_TYPE_CD            
                AND VO.SERV_ORDER_STATUS  = R6.SERV_ORDER_STATUS        
                AND R6.WORK_CLASS_ID      = C2.WORK_CLASS_ID            
                AND VO.SERV_ORDER_NO      = VI.SERV_ORDER_NO            
                AND VI.CODE_UTIL_TYPE     = :WS-CODE-UTIL-TYPE          
                AND VI.IC_NO              = :WS-IC-NO                   
                AND VI.WORK_TYPE_CD       > ' '                         
                AND VO.ORDER_STATE_CD     = 'Z'                         
                AND VO.WANTED_BY_DATETIME >=                            
                                          (DATEADD( MONTH, -2, 
           CIS.CURRENT$TIMESTAMP() ))
                AND VO.ORDER_TYPE_CD      IN (                          
                          'DNP01','DNPFB','FM001','FM002',              
                          'FM006','FW004','MC001','NC001',              
                          'OFF01','OFF02','OFF03','ON001')              
                FOR READ ONLY                                   
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE SO_CUR_CURSOR CURSOR FOR                                   
MFA-TR*      SELECT  VO.ACCOUNT_NO                                              
MFA-TR*             ,VI.CODE_UTIL_TYPE                                          
MFA-TR*             ,VI.IC_NO                                                   
MFA-TR*             ,VI.METER_NO                                                
MFA-TR*             ,VI.MTR_REF_NO                                              
MFA-TR*             ,C2.ORDER_TYPE_DESC                                         
MFA-TR*             ,VO.ORDER_STATE_CD                                          
MFA-TR*             ,VO.COMPLETED_DATETIME                                      
MFA-TR*        FROM  CSS_ORDER_TYPE       C2                                    
MFA-TR*             ,CSS_SO_ORDER_INST    VI                                    
MFA-TR*             ,CSS_WK_CLASS_STAT    R6                                    
MFA-TR*             ,CSS_SO_DATA          VO                                    
MFA-TR*       WHERE VO.ACCOUNT_NO         = :WS-ACCOUNT-NO                      
MFA-TR*         AND VO.COMPANY_NO         = C2.COMPANY_NO                       
MFA-TR*         AND VO.ORDER_TYPE_CD      = C2.ORDER_TYPE_CD                    
MFA-TR*         AND VO.SERV_ORDER_STATUS  = R6.SERV_ORDER_STATUS                
MFA-TR*         AND R6.WORK_CLASS_ID      = C2.WORK_CLASS_ID                    
MFA-TR*         AND VO.SERV_ORDER_NO      = VI.SERV_ORDER_NO                    
MFA-TR*         AND VI.CODE_UTIL_TYPE     = :WS-CODE-UTIL-TYPE                  
MFA-TR*         AND VI.IC_NO              = :WS-IC-NO                           
MFA-TR*         AND VI.WORK_TYPE_CD       > ' '                                 
MFA-TR*         AND VO.ORDER_STATE_CD     = 'Z'                                 
MFA-TR*         AND VO.WANTED_BY_DATETIME >=                                    
MFA-TR*                                   (CURRENT TIMESTAMP - 2 MONTHS)        
MFA-TR*         AND VO.ORDER_TYPE_CD      IN (                                  
MFA-TR*                   'DNP01','DNPFB','FM001','FM002',                      
MFA-TR*                   'FM006','FW004','MC001','NC001',                      
MFA-TR*                   'OFF01','OFF02','OFF03','ON001')                      
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*     QUERYNO 7610                                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  CURSOR TO RETRIEVE METER READ EXCEPTION WORK QUEUE DETAILS    *        
      *  FROM WQ_ITEMS TABLE.                                          *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
             DECLARE WQ_ITM_CURSOR CURSOR FOR                           
             SELECT  WQ.ACCOUNT_NO                                      
                    ,RTRIM(C3.CATEGORY_NAME) + ' - ' + CAST(
           WQ.CATEGORY_ID AS VARCHAR(MAX))     
                    ,WQ.STATUS                                          
                    ,REPLACE(REPLACE(CONVERT(CHAR(26), WQ.COMPLETE_DATE
           , 121), ' ', '-'), ':', '.') COMPLETE_DATE                          
               FROM  CSS_WQ_ITEMS     WQ
                           WITH(READUNCOMMITTED)   LEFT OUTER JOIN             
                     CSS_WQ_CATEGORY  C3 WITH(READUNCOMMITTED)                  
                 ON  WQ.CATEGORY_ID    =  C3.CATEGORY_ID                
              WHERE  WQ.CATEGORY_ID   IN (33, 141)                      
                AND  WQ.DATE_REQUIRED  < (DATEADD( MONTH, -1, 
           CIS.CURRENT$TIMESTAMP() ))  
                AND  WQ.DATE_REQUIRED >= (DATEADD( MONTH, -2, 
           CIS.CURRENT$TIMESTAMP() )) 
                AND  WQ.ACCOUNT_NO     = :WS-ACCOUNT-NO                 
              ORDER BY                                                  
                     WQ.DATE_CREATED   DESC                             
                FOR READ ONLY                                   
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE WQ_ITM_CURSOR CURSOR FOR                                   
MFA-TR*      SELECT  WQ.ACCOUNT_NO                                              
MFA-TR*             ,RTRIM(C3.CATEGORY_NAME)||' - '||WQ.CATEGORY_ID             
MFA-TR*             ,WQ.STATUS                                                  
MFA-TR*             ,WQ.COMPLETE_DATE                                           
MFA-TR*        FROM  CSS_WQ_ITEMS     WQ   LEFT OUTER JOIN                      
MFA-TR*              CSS_WQ_CATEGORY  C3                                        
MFA-TR*          ON  WQ.CATEGORY_ID    =  C3.CATEGORY_ID                        
MFA-TR*       WHERE  WQ.CATEGORY_ID   IN (33, 141)                              
MFA-TR*         AND  WQ.DATE_REQUIRED  < (CURRENT TIMESTAMP - 1 MONTH)          
MFA-TR*         AND  WQ.DATE_REQUIRED >= (CURRENT TIMESTAMP - 2 MONTHS)         
MFA-TR*         AND  WQ.ACCOUNT_NO     = :WS-ACCOUNT-NO                         
MFA-TR*       ORDER BY                                                          
MFA-TR*              WQ.DATE_CREATED   DESC                                     
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*     QUERYNO 7670                                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
           10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
                                                                        
                                                                        
                                                                        
       LINKAGE SECTION.                                                 
       01 PARM-PREMISE-NO          PIC X(10).                           
COB305 01 PARM-ACCOUNT-NO        PIC S9(13)V COMP-3 VALUE 0.                  
       01 PARM-IC-NO               PIC S9(4)   COMP.                    
       01 PARM-CODE-UTIL-TYPE      PIC X(01).                           
       01 PARM-PROCESS-FL          PIC X(01).                           
       01 PARM-INCLD-ADDTNL-HIST   PIC X(01).                           
       01 PARM-INCLD-EVNTS         PIC X(01).                           
       01 PARM-EXCLD-CNCL-CNSMPTN  PIC X(01).                           
       01 PARM-EXCLD-UNBLD-CNSMPTN PIC X(01).                           
                                                                        
       PROCEDURE DIVISION USING PARM-PREMISE-NO                         
                                PARM-ACCOUNT-NO                         
                                PARM-IC-NO                              
                                PARM-CODE-UTIL-TYPE                     
                                PARM-PROCESS-FL                         
                                PARM-INCLD-ADDTNL-HIST                  
                                PARM-INCLD-EVNTS                        
                                PARM-EXCLD-CNCL-CNSMPTN                 
                                PARM-EXCLD-UNBLD-CNSMPTN.               
                                                                        
      ******************************************************************        
      * 0000-MAINLINE.                                                 *        
      *                                                                *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE          THRU 0100-EXIT.             
           PERFORM 1000-PROCESS-INPUT       THRU 1000-EXIT.             
           PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT.             
           PERFORM 9999-END-PROGRAM         THRU 9999-EXIT.             
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE.                                               *        
      *                                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1 THRU 0100A-EXIT.                
           PERFORM 0100B-DECLARE-GTT-R2 THRU 0100B-EXIT.                
           PERFORM 0100C-DECLARE-GTT-R3 THRU 0100C-EXIT.                
P00836     IF PARM-PROCESS-FL = WS-WEB                                  
P00836        PERFORM 0100D-DECLARE-GTT-R4  THRU  0100D-EXIT            
P00836     END-IF.                                                      
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100A-DECLARE-GTT-R1.                                          *        
      *                                                                *        
      ******************************************************************        
       0100A-DECLARE-GTT-R1.                                            
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04622_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04622_R1
              (                                                          
               RETURN_CODE              INT                         
              ,APPL_RETURN_CODE         INT                         
              ,ACCOUNT_NO               DECIMAL(13,0)                   
              ,AMT_BILL_ITEM            DECIMAL(11,2)                   
              ,UTILITY_USG_AMT          DECIMAL(11,2)                   
              ,AVG_COST_PER_USG         DECIMAL(09,4)                   
              ,RATE_PLAN_NO CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2           
              ,BTU_FACTOR               DECIMAL(07,5)                   
              ,DATE_READ CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2              
              ,PER_DAY_USE              DECIMAL(12,3)                   
              ,NO_DAYS                  SMALLINT                        
              ,ESTIMATE_ADJUSTED CHAR(1)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                         
              ,CONSTANT                 DECIMAL(11,5)                   
              ,THERMS                   DECIMAL(09,0)                   
              ,UNITS                    DECIMAL(09,0)                   
              ,CNSMPTN_TYPE CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2           
              ,ACTUAL_ONPEAK            DECIMAL(09,0)                   
              ,BILLED_ONPEAK            DECIMAL(09,0)                   
              ,ONPEAK_DIFF              DECIMAL(09,0)                   
              ,ACTUAL_OFFPEAK           DECIMAL(09,0)                   
              ,BILLED_OFFPEAK           DECIMAL(09,0)                   
              ,OFFPEAK_DIFF             DECIMAL(09,0)                   
              ,ACTUAL_SHLDR             DECIMAL(09,0)                   
              ,BILLED_SHLDR             DECIMAL(09,0)                   
              ,SHLDR_DIFF               DECIMAL(09,0)                   
              ,COMBINED_READING CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2        
              ,BILL_NO                  INT                         
              ,BILL_ITEM_TMSTMP CHAR(26)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
              ,WNA_AMOUNT               DECIMAL(11,2)                   
              ,SAME_ACCOUNT CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2           
              ,EMPLOYEE_NO              INT                         
              ,CODE_SOURCE_ID CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2         
              ,DEGREE_DAYS              INT                         
              ,RATIO                    DECIMAL(12,3)                   
              ,COMPANY_NO CHAR(2)  COLLATE LATIN1_GENERAL_100_BIN2              
              ,INDUS_GAS_RATE CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2          
              ,WNA_FACTOR               DECIMAL(07,5)                   
              ,METER_READING            DECIMAL(11,0)                   
              ,REVENUE_MONTH            DECIMAL(6,0)                    
              ,REV_MTH_ORIG_BILL        DECIMAL(6,0)                    
              ,CNCLD_FLG CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2              
PRJ821        ,RATE_PLAN_DESC CHAR(50)  COLLATE LATIN1_GENERAL_100_BIN2         
PRJ821        ,OPTION_CD CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2              
PRJ821        ,OPTION_DESC CHAR(50)  COLLATE LATIN1_GENERAL_100_BIN2            
P00836        ,DATE_BILLED CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2            
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   CONTINUE                                             
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'               TO ACTIVE-PARAGRAPH        
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04622_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT        
               END-IF                                                   
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
               SELECT                                                   
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,ACCOUNT_NO                                           
                  ,AMT_BILL_ITEM                                        
                  ,UTILITY_USG_AMT                                      
                  ,AVG_COST_PER_USG                                     
                  ,LTRIM(RTRIM(RATE_PLAN_NO))      AS RATE_PLAN_NO             
                  ,BTU_FACTOR                                           
                  ,LTRIM(RTRIM(DATE_READ))         AS DATE_READ                
                  ,PER_DAY_USE                                          
                  ,NO_DAYS                                              
                  ,LTRIM(RTRIM(ESTIMATE_ADJUSTED)) AS ESTIMATE_ADJUSTED        
                  ,CONSTANT                                             
                  ,THERMS                                               
                  ,UNITS                                                
                  ,CNSMPTN_TYPE                                         
                  ,ACTUAL_ONPEAK                                        
                  ,BILLED_ONPEAK                                        
                  ,ONPEAK_DIFF                                          
                  ,ACTUAL_OFFPEAK                                       
                  ,BILLED_OFFPEAK                                       
                  ,OFFPEAK_DIFF                                         
                  ,ACTUAL_SHLDR                                         
                  ,BILLED_SHLDR                                         
                  ,SHLDR_DIFF                                           
                  ,LTRIM(RTRIM(COMBINED_READING))  AS COMBINED_READING         
                  ,BILL_NO                                              
                  ,LTRIM(RTRIM(BILL_ITEM_TMSTMP))  AS BILL_ITEM_TMSTMP         
                  ,WNA_AMOUNT                                           
                  ,LTRIM(RTRIM(SAME_ACCOUNT))      AS SAME_ACCOUNT             
                  ,EMPLOYEE_NO                                          
                  ,LTRIM(RTRIM(CODE_SOURCE_ID))    AS CODE_SOURCE_ID           
                  ,DEGREE_DAYS                                          
                  ,RATIO                                                
                  ,LTRIM(RTRIM(COMPANY_NO))        AS COMPANY_NO               
                  ,LTRIM(RTRIM(INDUS_GAS_RATE))    AS INDUS_GAS_RATE           
                  ,WNA_FACTOR                                           
                  ,METER_READING                                        
                  ,REVENUE_MONTH                                        
                  ,REV_MTH_ORIG_BILL                                    
                  ,LTRIM(RTRIM(CNCLD_FLG))         AS CNCLD_FLG                
PRJ821            ,RATE_PLAN_DESC                                       
PRJ821            ,OPTION_CD                                            
PRJ821            ,OPTION_DESC                                          
P00836            ,DATE_BILLED                                          
               FROM #CSR04622_R1                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*        SELECT                                                           
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,ACCOUNT_NO                                                   
MFA-TR*           ,AMT_BILL_ITEM                                                
MFA-TR*           ,UTILITY_USG_AMT                                              
MFA-TR*           ,AVG_COST_PER_USG                                             
MFA-TR*           ,STRIP(RATE_PLAN_NO)      AS RATE_PLAN_NO                     
MFA-TR*           ,BTU_FACTOR                                                   
MFA-TR*           ,STRIP(DATE_READ)         AS DATE_READ                        
MFA-TR*           ,PER_DAY_USE                                                  
MFA-TR*           ,NO_DAYS                                                      
MFA-TR*           ,STRIP(ESTIMATE_ADJUSTED) AS ESTIMATE_ADJUSTED                
MFA-TR*           ,CONSTANT                                                     
MFA-TR*           ,THERMS                                                       
MFA-TR*           ,UNITS                                                        
MFA-TR*           ,CNSMPTN_TYPE                                                 
MFA-TR*           ,ACTUAL_ONPEAK                                                
MFA-TR*           ,BILLED_ONPEAK                                                
MFA-TR*           ,ONPEAK_DIFF                                                  
MFA-TR*           ,ACTUAL_OFFPEAK                                               
MFA-TR*           ,BILLED_OFFPEAK                                               
MFA-TR*           ,OFFPEAK_DIFF                                                 
MFA-TR*           ,ACTUAL_SHLDR                                                 
MFA-TR*           ,BILLED_SHLDR                                                 
MFA-TR*           ,SHLDR_DIFF                                                   
MFA-TR*           ,STRIP(COMBINED_READING)  AS COMBINED_READING                 
MFA-TR*           ,BILL_NO                                                      
MFA-TR*           ,STRIP(BILL_ITEM_TMSTMP)  AS BILL_ITEM_TMSTMP                 
MFA-TR*           ,WNA_AMOUNT                                                   
MFA-TR*           ,STRIP(SAME_ACCOUNT)      AS SAME_ACCOUNT                     
MFA-TR*           ,EMPLOYEE_NO                                                  
MFA-TR*           ,STRIP(CODE_SOURCE_ID)    AS CODE_SOURCE_ID                   
MFA-TR*           ,DEGREE_DAYS                                                  
MFA-TR*           ,RATIO                                                        
MFA-TR*           ,STRIP(COMPANY_NO)        AS COMPANY_NO                       
MFA-TR*           ,STRIP(INDUS_GAS_RATE)    AS INDUS_GAS_RATE                   
MFA-TR*           ,WNA_FACTOR                                                   
MFA-TR*           ,METER_READING                                                
MFA-TR*           ,REVENUE_MONTH                                                
MFA-TR*           ,REV_MTH_ORIG_BILL                                            
MFA-TR*           ,STRIP(CNCLD_FLG)         AS CNCLD_FLG                        
MFA-TR*           ,RATE_PLAN_DESC                                               
MFA-TR*           ,OPTION_CD                                                    
MFA-TR*           ,OPTION_DESC                                                  
MFA-TR*           ,DATE_BILLED                                                  
MFA-TR*        FROM SESSION.CSR04622_R1                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 0100B-DECLARE-GTT-R2.                                          *        
      *                                                                *        
      ******************************************************************        
       0100B-DECLARE-GTT-R2.                                            
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04622_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04622_R2
              (                                                          
               RETURN_CODE              INT                         
              ,APPL_RETURN_CODE         INT                         
              ,ACCOUNT_NO               DECIMAL(13,0)                   
              ,CODE_UTIL_TYPE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
              ,IC_NO                    SMALLINT                        
              ,METER_NO CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2               
              ,METER_REF_NO             SMALLINT                        
              ,EVENT_DESC CHAR(50)  COLLATE LATIN1_GENERAL_100_BIN2             
              ,EVENT_STATUS CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2           
              ,COMPLETED_DATE CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2         
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000B-DELETE-GTT-ROWS THRU 8000B-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   CONTINUE                                             
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100B'               TO ACTIVE-PARAGRAPH        
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04622_R2'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT        
               END-IF                                                   
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C2 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
               SELECT                                                   
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,ACCOUNT_NO                                           
                  ,LTRIM(RTRIM(CODE_UTIL_TYPE))    AS CODE_UTIL_TYPE           
                  ,IC_NO                                                
                  ,LTRIM(RTRIM(METER_NO))          AS METER_NO                 
                  ,METER_REF_NO                                         
                  ,LTRIM(RTRIM(EVENT_DESC))        AS EVENT_DESC               
                  ,LTRIM(RTRIM(EVENT_STATUS))      AS EVENT_STATUS             
                  ,LTRIM(RTRIM(COMPLETED_DATE))    AS COMPLETED_DATE           
               FROM #CSR04622_R2                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C2 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*        SELECT                                                           
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,ACCOUNT_NO                                                   
MFA-TR*           ,STRIP(CODE_UTIL_TYPE)    AS CODE_UTIL_TYPE                   
MFA-TR*           ,IC_NO                                                        
MFA-TR*           ,STRIP(METER_NO)          AS METER_NO                         
MFA-TR*           ,METER_REF_NO                                                 
MFA-TR*           ,STRIP(EVENT_DESC)        AS EVENT_DESC                       
MFA-TR*           ,STRIP(EVENT_STATUS)      AS EVENT_STATUS                     
MFA-TR*           ,STRIP(COMPLETED_DATE)    AS COMPLETED_DATE                   
MFA-TR*        FROM SESSION.CSR04622_R2                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100B-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 0100C-DECLARE-GTT-R3.                                          *        
      *                                                                *        
      ******************************************************************        
       0100C-DECLARE-GTT-R3.                                            
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04622_R3')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04622_R3
              (                                                          
               RETURN_CODE              INT                         
              ,APPL_RETURN_CODE         INT                         
              ,ADDTNAL_USAGE_EXISTS CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000C-DELETE-GTT-ROWS THRU 8000C-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   CONTINUE                                             
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100C'               TO ACTIVE-PARAGRAPH        
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04622_R3'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT        
               END-IF                                                   
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C3 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
               SELECT                                                   
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,ADDTNAL_USAGE_EXISTS     AS ADDTNAL_USAGE_EXISTS     
               FROM #CSR04622_R3                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C3 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*        SELECT                                                           
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,ADDTNAL_USAGE_EXISTS     AS ADDTNAL_USAGE_EXISTS             
MFA-TR*        FROM SESSION.CSR04622_R3                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100C-EXIT.                                                      
            EXIT.                                                       
                                                                        
P00836******************************************************************        
P00836* 0100D-DECLARE-GTT-R4.                                          *        
P00836*                                                                *        
P00836******************************************************************        
P00836 0100D-DECLARE-GTT-R4.                                            
P00836                                                                  
P00836     EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04622_R4')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04622_R4
              (                                                          
P00836         RETURN_CODE              INT                         
P00836        ,APPL_RETURN_CODE         INT                         
P00836        ,ACCOUNT_NO               DECIMAL(13,0)                   
P00836        ,DATE_BILLED CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2            
P00836        ,DATE_READ CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2              
P00836        ,REVENUE_MONTH            DECIMAL(6,0)                    
P00836        ,NO_DAYS                  SMALLINT                        
P00836        ,THERMS                   DECIMAL(09,0)                   
P00836        ,UNITS                    DECIMAL(09,0)                   
P00836        ,CNSMPTN_TYPE CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2           
P00836        ,AMT_BILL_ITEM            DECIMAL(13,4)                   
P00836        ,UTILITY_USG_AMT          DECIMAL(13,4)                   
P00836        ,PER_DAY_USE              DECIMAL(12,3)                   
P00836        ,RATE_PLAN_NO CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2           
P00836        ,RATE_PLAN_DESC CHAR(50)  COLLATE LATIN1_GENERAL_100_BIN2         
P00836        ,OPTION_CD CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2              
P00836        ,OPTION_DESC CHAR(50)  COLLATE LATIN1_GENERAL_100_BIN2            
P00836        ,COMPANY_NO CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2             
P00836        ,CODE_BILL_CALC CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
P00836        ,CODE_BILL_ITM_TYPE CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
P00836        ,CODE_BILL_ITM_IND CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
P00836        ,CODE_BILL_TYPE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
P00836       )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00836                                                                  
P00836     MOVE SQLSTATE TO WS-SQLSTATE.                                
P00836     MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
P00836                                                                  
P00836     IF WS-SQLSTATE = '42710'                                     
P00836        PERFORM 8000D-DELETE-GTT-ROWS THRU 8000D-EXIT             
P00836     ELSE                                                         
P00836         IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
P00836             CONTINUE                                             
P00836         ELSE                                                     
P00836            MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
P00836            MOVE SQLCODE              TO ABEND-SQLCODE            
P00836            MOVE SQLSTATE             TO ABEND-SQLSTATE           
P00836            MOVE '0100D'               TO ACTIVE-PARAGRAPH        
P00836            MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
P00836            MOVE SPACES               TO ABEND-SQL-PREDICATES     
P00836                                         ABEND-TABLES             
P00836            MOVE 'CSR04622_R4'        TO TABLE-1                  
P00836            MOVE SPACES               TO TABLE-ELEMENT-1          
P00836            MOVE SPACES               TO HOSTVAR-ELEMENT-1        
P00836            PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT        
P00836            PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT        
P00836         END-IF                                                   
P00836     END-IF.                                                      
P00836                                                                  
P00836     EXEC SQL                                                     
P00836         DECLARE C4 CURSOR                             
P00836                           WITH ROWSET POSITIONING FOR            
P00836         SELECT                                                   
P00836             RETURN_CODE                                          
P00836            ,APPL_RETURN_CODE                                     
P00836            ,ACCOUNT_NO                                           
P00836            ,DATE_BILLED                                          
P00836            ,DATE_READ                                            
P00836            ,REVENUE_MONTH                                        
P00836            ,NO_DAYS                                              
P00836            ,THERMS                                               
P00836            ,UNITS                                                
P00836            ,CNSMPTN_TYPE                                         
P00836            ,AMT_BILL_ITEM                                        
P00836            ,UTILITY_USG_AMT                                      
P00836            ,PER_DAY_USE                                          
P00836            ,RATE_PLAN_NO                                         
P00836            ,RATE_PLAN_DESC                                       
P00836            ,OPTION_CD                                            
P00836            ,OPTION_DESC                                          
P00836            ,COMPANY_NO                                           
P00836            ,CODE_BILL_CALC                                       
P00836            ,CODE_BILL_ITM_TYPE                                   
P00836            ,CODE_BILL_ITM_IND                                    
P00836            ,CODE_BILL_TYPE                                       
P00836         FROM #CSR04622_R4                                 
P00836     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C4 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*        SELECT                                                           
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,ACCOUNT_NO                                                   
MFA-TR*           ,DATE_BILLED                                                  
MFA-TR*           ,DATE_READ                                                    
MFA-TR*           ,REVENUE_MONTH                                                
MFA-TR*           ,NO_DAYS                                                      
MFA-TR*           ,THERMS                                                       
MFA-TR*           ,UNITS                                                        
MFA-TR*           ,CNSMPTN_TYPE                                                 
MFA-TR*           ,AMT_BILL_ITEM                                                
MFA-TR*           ,UTILITY_USG_AMT                                              
MFA-TR*           ,PER_DAY_USE                                                  
MFA-TR*           ,RATE_PLAN_NO                                                 
MFA-TR*           ,RATE_PLAN_DESC                                               
MFA-TR*           ,OPTION_CD                                                    
MFA-TR*           ,OPTION_DESC                                                  
MFA-TR*           ,COMPANY_NO                                                   
MFA-TR*           ,CODE_BILL_CALC                                               
MFA-TR*           ,CODE_BILL_ITM_TYPE                                           
MFA-TR*           ,CODE_BILL_ITM_IND                                            
MFA-TR*           ,CODE_BILL_TYPE                                               
MFA-TR*        FROM SESSION.CSR04622_R4                                         
MFA-TR*    END-EXEC.                                                            
P00836                                                                  
P00836 0100D-EXIT.                                                      
P00836      EXIT.                                                       
P00836                                                                  
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *                                                                *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-PREMISE-NO              TO WS-PREMISE-NO.          
           MOVE WS-PREMISE-NO-NUM            TO BG-PREMISE-NO.          
           MOVE PARM-ACCOUNT-NO              TO WS-ACCOUNT-NO           
P00836                                          AT-ACCOUNT-NO           
P00836                                          WQ-ACCOUNT-NO.          
           MOVE PARM-IC-NO                   TO BG-IC-NO                
                                                WS-IC-NO.               
           MOVE PARM-CODE-UTIL-TYPE          TO BG-CODE-UTIL-TYPE       
                                                WS-CODE-UTIL-TYPE.      
           MOVE PARM-INCLD-ADDTNL-HIST       TO WS-INCLD-ADDTNL-HIST.   
      *    MOVE PARM-INCLD-EVNTS             TO WS-INCLD-EVENTS.                
           MOVE WS-NO                        TO WS-INCLD-EVENTS.        
           MOVE PARM-EXCLD-CNCL-CNSMPTN      TO WS-EXCLD-CNCL-CNSMPTN.  
           MOVE PARM-EXCLD-UNBLD-CNSMPTN     TO WS-EXCLD-UNBLD-CNSMPTN. 
                                                                        
PRJ821     MOVE 'DATABASE'                   TO C8-DELINQ-CD.           
PRJ821     MOVE '01'                         TO C8-COMPANY-NO.          
PRJ821     PERFORM 7910-GET-DATABASE            THRU 7910-EXIT.         
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *                                                                *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
      *    CURSOR DRIVEN BY PREMISE NO / ACCOUNT NO.                            
           EVALUATE PARM-PROCESS-FL                                     
               WHEN WS-PREMISE                                          
                    MOVE WS-YES             TO WS-FILTER-BY-PREMISE     
               WHEN WS-ACCT                                             
                    MOVE WS-YES             TO WS-FILTER-BY-ACCT        
P00836         WHEN WS-WEB                                              
P00836              MOVE WS-YES             TO WS-FILTER-BY-ACCT        
P00836              PERFORM 7002-GET-ACCOUNT-DET         THRU 7002-EXIT 
P00836              PERFORM 7050-CHECK-EBILL-NO-DISP-IND THRU 7050-EXIT 
           END-EVALUATE.                                                
      *    CALC CUTOFF REV MONTH FOR ADD-HIST = 'N' & ACCOUNT PROCESS           
           IF WS-INCLD-ADDTNL-HIST = WS-NO AND                          
              WS-FILTER-BY-ACCT    = WS-YES                             
              PERFORM 7002-GET-ACCOUNT-DET       THRU 7002-EXIT         
              PERFORM 2100-GET-REVMONTH-CUTOFF   THRU 2100-EXIT         
              MOVE WS-REVENUE-MONTH         TO WS-CUTOFF-REV-MTH        
           ELSE                                                         
              MOVE WS-ALL-REV-MONTHS        TO WS-CUTOFF-REV-MTH        
           END-IF.                                                      
      *                                                                         
           PERFORM 2205-BUILD-RESULT-SET         THRU 2205-EXIT.        
                                                                        
           IF WS-INCLD-EVENTS  = WS-YES                                 
              PERFORM 2260-BUILD-RS2             THRU 2260-EXIT         
           END-IF.                                                      
                                                                        
           MOVE WS-CUTOFF-REV-MTH           TO BG-REVENUE-MONTH.        
           PERFORM 7900-GET-BILL-EXIST           THRU 7900-EXIT.        
                                                                        
           IF (WS-INCLD-ADDTNL-HIST = WS-NO   AND                       
               WS-FILTER-BY-ACCT    = WS-YES  AND                       
               AT-REV-MTH-LST-NRML  > WS-ZERO AND                       
               WS-BILL-EXIST-FL     = 'Y'     )                         
              MOVE WS-YES                   TO S3-ADDTNAL-USAGE-EXISTS  
           END-IF.                                                      
                                                                        
           PERFORM 8030-INSERT-GTT-R3             THRU 8030-EXIT.       
                                                                        
P00836     IF CTR-ROWS-RS4 > 0                                          
P00836        PERFORM 8100-DELETE-CANCEL-ROWS-R4  THRU  8100-EXIT       
P00836        PERFORM 8200-INSERT-GTT-RESULT      THRU  8200-EXIT       
P00836     END-IF.                                                      
P00836*                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *2000A-MOVE-RESULT                                               *        
      ******************************************************************        
       2000A-MOVE-RESULT.                                               
                                                                        
           MOVE WS-ZERO                     TO S1-RETURN-CODE.          
           MOVE RS-ACCOUNT-NO               TO S1-ACCOUNT-NO.           
           MOVE RS-AMT-BILL-ITEM            TO S1-AMT-BILL-ITEM.        
           MOVE RS-UTILITY-USG-AMT          TO S1-UTILITY-USG-AMT.      
           MOVE RS-AVG-COST-PER-USG         TO S1-AVG-COST-PER-USG.     
           MOVE RS-RATE-PLAN-NO             TO S1-RATE-PLAN-NO.         
           MOVE RS-BTU-FACTOR               TO S1-BTU-FACTOR.           
           MOVE RS-WNA-FACTOR               TO S1-WNA-FACTOR.           
           MOVE RS-DATE-READ                TO S1-DATE-READ.            
           MOVE RS-PER-DAY-USE              TO S1-PER-DAY-USE.          
           MOVE RS-NO-DAYS                  TO S1-NO-DAYS.              
           MOVE RS-ESTIMATE-ADJUSTED        TO S1-ESTIMATE-ADJUSTED.    
           MOVE RS-CONSTANT                 TO S1-CONSTANT.             
           MOVE RS-THERMS                   TO S1-THERMS.               
           MOVE RS-UNITS                    TO S1-UNITS.                
           MOVE RS-CNSMPTN-TYPE             TO S1-CNSMPTN-TYPE.         
           MOVE RS-ACTUAL-ONPEAK            TO S1-ACTUAL-ONPEAK.        
           MOVE RS-BILLED-ONPEAK            TO S1-BILLED-ONPEAK.        
           MOVE RS-ONPEAK-DIFF              TO S1-ONPEAK-DIFF.          
           MOVE RS-ACTUAL-OFFPEAK           TO S1-ACTUAL-OFFPEAK.       
           MOVE RS-BILLED-OFFPEAK           TO S1-BILLED-OFFPEAK.       
           MOVE RS-OFFPEAK-DIFF             TO S1-OFFPEAK-DIFF.         
           MOVE RS-ACTUAL-SHLDR             TO S1-ACTUAL-SHLDR.         
           MOVE RS-BILLED-SHLDR             TO S1-BILLED-SHLDR.         
           MOVE RS-SHLDR-DIFF               TO S1-SHLDR-DIFF.           
           MOVE RS-COMBINED-READING         TO S1-COMBINED-READING.     
           MOVE RS-BILL-NO                  TO S1-BILL-NO.              
           MOVE RS-BILL-ITEM-TMSTMP         TO S1-BILL-ITEM-TMSTMP.     
           MOVE RS-WNA-AMOUNT               TO S1-WNA-AMOUNT.           
           MOVE RS-SAME-ACCOUNT             TO S1-SAME-ACCOUNT.         
           MOVE RS-EMPLOYEE-NO              TO S1-EMPLOYEE-NO.          
           MOVE RS-CODE-SOURCE-ID           TO S1-CODE-SOURCE-ID.       
           MOVE RS-DEGREE-DAYS              TO S1-DEGREE-DAYS.          
           MOVE RS-RATIO                    TO S1-RATIO.                
           MOVE RS-COMPANY-NO               TO S1-COMPANY-NO.           
           MOVE RS-INDUS-GAS-RATE           TO S1-INDUS-GAS-RATE.       
           MOVE RS-METER-READING            TO S1-METER-READING.        
           MOVE RS-REVENUE-MONTH            TO S1-REVENUE-MONTH.        
           MOVE RS-REV-MTH-ORIG-BILL        TO S1-REV-MTH-ORIG-BILL.    
           MOVE RS-CNCLD-FLG                TO S1-CNCLD-FLG.            
PRJ821     MOVE RS-RATE-PLAN-DESC           TO S1-RATE-PLAN-DESC.       
PRJ821     MOVE RS-OPTION-CD                TO S1-OPTION-CD.            
PRJ821     MOVE RS-OPTION-DESC              TO S1-OPTION-DESC.          
P00836     MOVE RS-DATE-BILLED              TO S1-DATE-BILLED.          
P00836     MOVE RS-CODE-BILL-CALC           TO S1-CODE-BILL-CALC.       
P00836     MOVE RS-CODE-BILL-ITM-TYPE       TO S1-CODE-BILL-ITM-TYPE.   
P00836     MOVE RS-CODE-BILL-ITM-IND        TO S1-CODE-BILL-ITM-IND.    
P00836     MOVE RS-CODE-BILL-TYPE           TO S1-CODE-BILL-TYPE.       
                                                                        
       2000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *2000B-MOVE-RESULT                                               *        
      ******************************************************************        
       2000B-MOVE-RESULT.                                               
                                                                        
           MOVE WS-ZERO                     TO S2-RETURN-CODE.          
           MOVE RS-ACCOUNT-NO               TO S2-ACCOUNT-NO.           
           MOVE RS-CODE-UTIL-TYPE           TO S2-CODE-UTIL-TYPE.       
           MOVE RS-IC-NO                    TO S2-IC-NO.                
           MOVE RS-METER-NO                 TO S2-METER-NO.             
           MOVE RS-METER-REF-NO             TO S2-METER-REF-NO.         
           MOVE RS-EVENT-DESC               TO S2-EVENT-DESC.           
           MOVE RS-EVENT-STATUS             TO S2-EVENT-STATUS.         
           MOVE RS-COMPLETED-DATE           TO S2-COMPLETED-DATE.       
                                                                        
       2000B-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2100-GET-REVMONTH-CUTOFF                                       *        
      *   THIS ROUTINE WILL GET THE ACCOUNT REVENUE MONTH COUNT        *        
      ******************************************************************        
       2100-GET-REVMONTH-CUTOFF.                                        
      *                                                                         
           MOVE AT-REV-MTH-LST-NRML         TO WS-REVENUE-MONTH.        
           MOVE WS-DFLT-NO-OF-REVMON        TO WS-REV-MTH-CUTOFF-CNT.   
      *                                                                         
           PERFORM 2110-CALC-REVMONTH-CUTOFF  THRU 2110-EXIT            
                   UNTIL WS-REV-MTH-CUTOFF-CNT LESS THAN OR EQUAL ZERO. 
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2110-CALC-REVMONTH-CUTOFF                                      *        
      *   THIS ROUTINE WILL CALCULATE THE CUTOFF REVENUE MONTH.        *        
      ******************************************************************        
       2110-CALC-REVMONTH-CUTOFF.                                       
      *                                                                         
           SUBTRACT +1                      FROM WS-REV-MONTH-MM        
                                                 WS-REV-MTH-CUTOFF-CNT. 
           IF WS-REV-MONTH-MM  EQUAL ZERO                               
              MOVE WS-12                    TO WS-REV-MONTH-MM          
              SUBTRACT +1                   FROM WS-REV-MONTH-YY        
           END-IF.                                                      
      *                                                                         
       2110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2205-BUILD-RESULT-SET.                                         *        
      *                                                                *        
      ******************************************************************        
       2205-BUILD-RESULT-SET.                                           
                                                                        
           PERFORM 7100-OPEN-BG-CURSOR      THRU 7100-EXIT.             
           PERFORM 7110-FETCH-BG-CURSOR     THRU 7110-EXIT.             
           PERFORM 2206-SET-USAGE-PRCS-FL   THRU 2206-EXIT.             
           PERFORM 2210-PROCESS-BG-CURSOR   THRU 2210-EXIT              
             UNTIL NO-MORE-BG-ROWS OR STOP-USAGE-PRCS                   
           PERFORM 7120-CLOSE-BG-CURSOR     THRU 7120-EXIT.             
                                                                        
       2205-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2206-SET-USAGE-PRCS-FL.                                        *        
      *                                                                *        
      ******************************************************************        
       2206-SET-USAGE-PRCS-FL.                                          
                                                                        
           IF WS-INCLD-ADDTNL-HIST = WS-NO  AND                         
              WS-FILTER-BY-ACCT    = WS-YES                             
                                                                        
              IF BG-REVENUE-MONTH   > ZERO  AND                         
                 WS-CUTOFF-REV-MTH  >  BG-REVENUE-MONTH                 
                                                                        
                 SET STOP-USAGE-PRCS        TO TRUE                     
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2206-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2210-PROCESS-BG-CURSOR.                                        *        
      *                                                                *        
      ******************************************************************        
       2210-PROCESS-BG-CURSOR.                                          
                                                                        
           IF (WS-EXCLD-UNBLD-CNSMPTN = WS-YES AND                      
              BI-DATE-BILLED = SPACES)                                  
              CONTINUE                                                  
           ELSE                                                         
              PERFORM 2211-PROCESS-BILLING-DET                          
                                              THRU 2211-EXIT            
           END-IF.                                                      
           INITIALIZE                          TDS-RETURN-FIELDS        
                                               WS-BACKOUT-SW            
                                               WS-REBILL-SW             
                                               WS-NO-UNITS              
                                               WS-NO-MORE-CX-ROWS       
                                               WS-NO-MORE-BZ-ROWS       
                                               WS-NO-MORE-E8-ROWS.      
           MOVE WS-NO                       TO RS-COMBINED-READING.     
           MOVE SPACES                      TO CX-DATE-READ.            
           MOVE ZERO                        TO RS-UTILITY-USG-AMT       
                                               RS-AVG-COST-PER-USG.     
           PERFORM 7110-FETCH-BG-CURSOR        THRU  7110-EXIT.         
           PERFORM 2206-SET-USAGE-PRCS-FL      THRU  2206-EXIT.         
                                                                        
       2210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2211-PROCESS-BILLING-DET.                                      *        
      *                                                                *        
      ******************************************************************        
       2211-PROCESS-BILLING-DET.                                        
                                                                        
P00836     MOVE BI-DATE-BILLED              TO RS-DATE-BILLED           
PRJ821     MOVE BG-RATE-PLAN-NO             TO RS-RATE-PLAN-NO          
PRJ821                                         RD-RATE-PLAN-NO          
PRJ821     MOVE PARM-CODE-UTIL-TYPE         TO RD-CODE-UTIL-TYPE        
                                                                        
PRJ821     PERFORM 2300-PROCESS-RT-OPT-DESC    THRU 2300-EXIT           
                                                                        
           MOVE WS-NO                       TO WS-BACKOUT-SW            
                                               WS-REBILL-SW             
           MOVE BG-COMPANY-NO               TO RS-COMPANY-NO            
           MOVE BG-WNA-FACTOR               TO RS-WNA-FACTOR            
           IF PARM-CODE-UTIL-TYPE EQUAL WS-ELEC                         
              MOVE 'KWH'                    TO RS-CNSMPTN-TYPE          
           ELSE                                                         
              MOVE 'CCF'                    TO RS-CNSMPTN-TYPE          
           END-IF.                                                      
                                                                        
           IF BG-CODE-BILL-ITM-TYPE = 'C' AND                           
              BG-CODE-BILL-ITM-IND = 'J' OR 'K'                         
              MOVE WS-YES                    TO RS-CNCLD-FLG            
           ELSE                                                         
              MOVE WS-NO                     TO RS-CNCLD-FLG            
           END-IF.                                                      
                                                                        
      *    IF INPUT ACCOUNT NO & BG-ACCOUNT-NO IS SAME THEN                     
      *    SAME ACCOUNT FLAG WILL GET ENABLED.                                  
           MOVE WS-NO                       TO RS-SAME-ACCOUNT          
           IF WS-ACCOUNT-NO     EQUAL BG-ACCOUNT-NO                     
              MOVE 'Y'                      TO RS-SAME-ACCOUNT          
           END-IF                                                       
                                                                        
      *    IF REGISTER TYPE IS -D-(DAILY),CONSIDER AS INDSTRAL GAS RATE.        
           MOVE WS-NO                       TO RS-INDUS-GAS-RATE        
           PERFORM 7850-DETERMINE-INDUS-GAS-RATE THRU 7850-EXIT         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE WS-YES                   TO RS-INDUS-GAS-RATE        
           END-IF.                                                      
                                                                        
      *    CODE DEBIT/CREDIT CONSUMPTION -C- (CREDIT) INDICATES                 
      *    THAT THE MONEY AMOUNTS ON THE BILLING DETAIL SHOULD BE               
      *    MULTIPLIED BY -1 AND C FOR A BACKOUT.                                
           IF BG-CODE-DR-CR-CNSMPTN EQUAL WS-CREDIT                     
              COMPUTE BG-AMT-BILL-ITEM EQUAL BG-AMT-BILL-ITEM * -1      
              MOVE 'Y'                      TO WS-BACKOUT-SW            
           END-IF                                                       
                                                                        
           IF BG-REBILL-IND = 'Y'                                       
              SET REBILL-ITEM               TO TRUE                     
           END-IF                                                       
                                                                        
           MOVE BG-AMT-BILL-ITEM            TO RS-AMT-BILL-ITEM         
                                                                        
      *    BTU FACTOR USED TO CONVERT CCF (GAS) TO THERMS.                      
           IF BG-CODE-UTIL-TYPE EQUAL 'G'                               
              MOVE BG-BTU-FACTOR            TO RS-BTU-FACTOR            
           ELSE                                                         
              MOVE WS-ZERO                  TO RS-BTU-FACTOR            
           END-IF                                                       
                                                                        
           MOVE BG-ACCOUNT-NO               TO CX-ACCOUNT-NO            
                                               BZ-ACCOUNT-NO            
                                               RS-ACCOUNT-NO.           
           MOVE BG-CODE-UTIL-TYPE           TO CX-CODE-UTIL-TYPE        
                                               BZ-CODE-UTIL-TYPE.       
           MOVE BG-IC-NO                    TO CX-IC-NO                 
                                               BZ-IC-NO.                
           MOVE BG-BILL-NO                  TO CX-BILL-NO               
                                               BZ-BILL-NO               
                                               RS-BILL-NO.              
           MOVE BG-BILL-ITEM-TIMESTMP       TO CX-BILL-ITEM-TIMESTMP    
                                               BZ-BILL-ITEM-TIMESTMP    
                                               RS-BILL-ITEM-TMSTMP.     
P00836     MOVE BG-CODE-BILL-CALC           TO RS-CODE-BILL-CALC.       
P00836     MOVE BG-CODE-BILL-ITM-TYPE       TO RS-CODE-BILL-ITM-TYPE.   
P00836     MOVE BG-CODE-BILL-ITM-IND        TO RS-CODE-BILL-ITM-IND.    
P00836     MOVE BI-CODE-BILL-TYPE           TO RS-CODE-BILL-TYPE.       
           MOVE BG-REVENUE-MONTH            TO RS-REVENUE-MONTH         
           MOVE BG-REV-MTH-ORIG-BILL        TO RS-REV-MTH-ORIG-BILL     
                                                                        
           MOVE WS-ZERO                     TO RS-UNITS                 
                                               RS-THERMS                
                                               CX-NO-UNITS.             
                                                                        
      *    OPEN CNSMPTN HISTORY CURSOR TO ACCUMULATE ALL UNITS.                 
           PERFORM 2212-PROCESS-CNSMPTN-HIST   THRU 2212-EXIT.          
                                                                        
      *    OPEN BILL CALC DET CURSOR TO ACCUMULATE ALL UNITS.                   
           PERFORM 2214-PROCESS-BILL-CALC-DET  THRU 2214-EXIT.          
                                                                        
      *    OPEN TEMP CURSOR TO GET DEGREE DAYS.                                 
           PERFORM 2216-PROCESS-DEGREE-DAYS    THRU 2216-EXIT.          
                                                                        
           IF RS-CODE-SOURCE-ID EQUAL SPACES AND                        
              RS-INDUS-GAS-RATE EQUAL WS-YES                            
              IF  BG-REV-RPT-CD = 'T'                                   
                  IF BACKOUT-ITEM                                       
                     MOVE 'Z'               TO RS-CODE-SOURCE-ID        
                  ELSE                                                  
                     MOVE 'Y'               TO RS-CODE-SOURCE-ID        
                  END-IF                                                
              ELSE                                                      
                  MOVE 'X'                  TO RS-CODE-SOURCE-ID        
              END-IF                                                    
           END-IF.                                                      
                                                                        
           PERFORM 2000A-MOVE-RESULT           THRU 2000A-EXIT.         
           IF RS-INDUS-GAS-RATE EQUAL WS-YES                            
              PERFORM 8010-INSERT-GTT-R1       THRU 8010-EXIT           
           ELSE                                                         
              IF RS-DATE-READ GREATER THAN SPACES                       
P00836           IF PARM-PROCESS-FL      = WS-WEB  AND                  
P00836              AT-ACCOUNT-TYPE-CODE = 'R'                          
P00836              PERFORM 2400-WEBMOD-RESIDENTIAL THRU 2400-EXIT      
P00836           ELSE                                                   
P00836              PERFORM 8010-INSERT-GTT-R1  THRU  8010-EXIT         
P00836           END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2211-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2212-PROCESS-CNSMPTN-HIST.                                     *        
      *                                                                *        
      ******************************************************************        
       2212-PROCESS-CNSMPTN-HIST.                                       
                                                                        
           PERFORM 7400-OPEN-CX-CURSOR         THRU  7400-EXIT          
           PERFORM 7410-FETCH-CX-CURSOR        THRU  7410-EXIT          
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF BACKOUT-ITEM                                           
                 MOVE 'O'                   TO CX-CODE-SOURCE-ID        
              END-IF                                                    
              IF REBILL-ITEM                                            
                 MOVE 'R'                   TO CX-CODE-SOURCE-ID        
              END-IF                                                    
              PERFORM 2220-PROCESS-CX-CURSOR   THRU 2220-EXIT           
           END-IF.                                                      
                                                                        
           PERFORM 7420-CLOSE-CX-CURSOR        THRU 7420-EXIT.          
                                                                        
       2212-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2214-PROCESS-BILL-CALC-DET.                                    *        
      *                                                                *        
      ******************************************************************        
       2214-PROCESS-BILL-CALC-DET.                                      
                                                                        
           MOVE WS-ZERO                     TO BZ-READ-UNITS            
           MOVE WS-ZERO                     TO WS-WNA-COMP-AM           
           PERFORM 7500-OPEN-BZ-CURSOR         THRU  7500-EXIT          
           PERFORM 7510-FETCH-BZ-CURSOR        THRU  7510-EXIT          
                                                                        
           IF BACKOUT-ITEM                                              
              CONTINUE                                                  
           ELSE                                                         
             IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL             
                PERFORM 2230-PROCESS-BZ-CURSOR THRU 2230-EXIT           
                                              UNTIL NO-MORE-BZ-ROWS     
                IF WS-NO-DAYS EQUAL WS-ZERO                             
                   MOVE WS-ZERO               TO RS-PER-DAY-USE         
                ELSE                                                    
                   IF BZ-CODE-UTIL-TYPE EQUAL WS-ELEC                   
                      MOVE WS-KWH-UNITS     TO RS-UNITS                 
                      COMPUTE RS-PER-DAY-USE ROUNDED =                  
                                               WS-KWH-UNITS/WS-NO-DAYS  
                      MOVE WS-ZERO          TO WS-KWH-UNITS             
                      MOVE WS-WNA-COMP-AM   TO RS-WNA-AMOUNT            
                   ELSE                                                 
                      MOVE WS-CCF-UNITS     TO RS-UNITS                 
                      MOVE WS-THERMS        TO RS-THERMS                
                      COMPUTE RS-PER-DAY-USE ROUNDED =                  
                                               WS-THERMS / WS-NO-DAYS   
                      MOVE WS-WNA-COMP-AM   TO RS-WNA-AMOUNT            
                      MOVE WS-ZERO          TO WS-CCF-UNITS             
                                               WS-THERMS                
                                               WS-WNA-COMP-AM           
                   END-IF                                               
                END-IF                                                  
                                                                        
      *       ADDED THIS PORTION OF LOGIC TO CALCULATE WNA AMOUNT FOR           
      *       HISTORY FOR SCEG ACCOUNTS. PSNC CONVERTED DATA DOES NOT           
      *       HAVE WNA FACTOR FOR HISTORY.                                      
                PERFORM 7530-SELECT-OFFICE    THRU 7530-EXIT            
                IF AT-COMPANY-NO     EQUAL WS-ONE  AND                  
                   BZ-WNA-COMP-AM    EQUAL WS-ZERO AND                  
                   BG-WNA-FACTOR NOT EQUAL WS-ZERO                      
                   COMPUTE WS-WNA-AMOUNT =                              
                      (BZ-BILL-UNITS - BG-GAS-BASE-USE) * BG-WNA-FACTOR 
                   MOVE WS-WNA-AMOUNT       TO RS-WNA-AMOUNT            
                END-IF                                                  
             ELSE                                                       
                IF WS-NO-DAYS EQUAL WS-ZERO                             
                   MOVE WS-ZERO             TO RS-PER-DAY-USE           
                ELSE                                                    
                   IF BZ-CODE-UTIL-TYPE EQUAL  WS-ELEC                  
                      MOVE WS-NO-UNITS      TO RS-UNITS                 
                      COMPUTE RS-PER-DAY-USE ROUNDED  =                 
                                             WS-NO-UNITS / WS-NO-DAYS   
                   ELSE                                                 
                      MOVE WS-NO-UNITS      TO RS-UNITS                 
                      IF RS-UNITS NOT = 0 AND RS-BTU-FACTOR NOT = 0     
                         COMPUTE RS-THERMS ROUNDED =                    
                                           RS-UNITS * RS-BTU-FACTOR     
                      END-IF                                            
                      COMPUTE RS-PER-DAY-USE ROUNDED =                  
                                           RS-THERMS / WS-NO-DAYS       
                   END-IF                                               
                END-IF                                                  
             END-IF                                                     
             IF BZ-CODE-UTIL-TYPE EQUAL WS-GAS AND RS-THERMS > 0        
                COMPUTE RS-AVG-COST-PER-USG ROUNDED  =                  
                                     RS-UTILITY-USG-AMT / RS-THERMS     
             ELSE                                                       
                IF RS-UNITS > 0                                         
                   COMPUTE RS-AVG-COST-PER-USG ROUNDED  =               
                                     RS-UTILITY-USG-AMT / RS-UNITS      
                ELSE                                                    
                   MOVE WS-ZERO              TO RS-AVG-COST-PER-USG     
                END-IF                                                  
             END-IF                                                     
           END-IF.                                                      
                                                                        
           PERFORM 7520-CLOSE-BZ-CURSOR        THRU 7520-EXIT.          
                                                                        
       2214-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2216-PROCESS-DEGREE-DAYS.                                      *        
      *                                                                *        
      ******************************************************************        
       2216-PROCESS-DEGREE-DAYS.                                        
                                                                        
           MOVE WS-ZERO                        TO RS-DEGREE-DAYS.       
                                                                        
           IF CX-DATE-READ GREATER THAN SPACES                          
              PERFORM 7530-SELECT-OFFICE          THRU 7530-EXIT        
              IF B1-WEATHER-SERV-DIV EQUAL SPACES                       
                 CONTINUE                                               
              ELSE                                                      
                 PERFORM 7570-GET-NEXT-READ-DATE  THRU 7570-EXIT        
                 PERFORM 2240-PROCESS-DEGREE-DAYS THRU 2240-EXIT        
              END-IF                                                    
                                                                        
              MOVE WS-HOLD-ACCUMDEG         TO RS-DEGREE-DAYS           
              MOVE WS-ZERO                  TO WS-HOLD-ACCUMDEG         
                                                                        
      *       RATIO ( THERMS PER DEGREE DAY) ONLY FOR GAS                       
              IF PARM-CODE-UTIL-TYPE EQUAL WS-GAS AND                   
                 RS-DEGREE-DAYS NOT EQUAL WS-ZERO                       
                 COMPUTE WS-RATIO = (RS-THERMS / RS-DEGREE-DAYS)        
                 MOVE WS-RATIO              TO RS-RATIO                 
              ELSE                                                      
                 MOVE WS-ZERO               TO RS-RATIO                 
              END-IF                                                    
           ELSE                                                         
              MOVE WS-ZERO                  TO RS-DEGREE-DAYS           
              MOVE WS-ZERO                  TO RS-RATIO                 
           END-IF.                                                      
                                                                        
       2216-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2220-PROCESS-CX-CURSOR                                         *        
      *                                                                *        
      ******************************************************************        
       2220-PROCESS-CX-CURSOR.                                          
                                                                        
           MOVE CX-CONSTANT               TO RS-CONSTANT                
           MOVE CX-CODE-SOURCE-ID         TO RS-CODE-SOURCE-ID          
                                                                        
      *    METER READ CONDITION THAT INDICATES THE CONDITION OF THE             
      *    METER READ. 'E'- SYSTEM ESTIMATED                                    
           IF CX-CODE-METER-READ EQUAL WS-SYSTEM-ESTIMATED              
              MOVE CX-CODE-METER-NO-READ  TO RS-ESTIMATE-ADJUSTED       
           ELSE                                                         
              MOVE SPACES                 TO RS-ESTIMATE-ADJUSTED       
           END-IF                                                       
                                                                        
           MOVE CX-NO-DAYS                TO RS-NO-DAYS                 
                                             WS-NO-DAYS.                
           MOVE CX-NO-UNITS               TO WS-NO-UNITS                
           MOVE CX-DATE-READ              TO RS-DATE-READ               
                                             WS-DATE-READ               
           MOVE CX-EMPLOYEE-NO            TO RS-EMPLOYEE-NO             
           MOVE CX-METER-READING          TO RS-METER-READING           
                                                                        
           MOVE WS-NO                     TO RS-COMBINED-READING        
           PERFORM 2225-ACCUM-CX-ROWS        THRU 2225-EXIT             
                                             UNTIL NO-MORE-CX-ROWS      
                                                                        
      *    GETTING TOTAL NUMBER OF DAYS FOR THAT PARTICULAR BILL.               
      *    AND CALCULATING TO GET PER DAY USAGE.                                
           PERFORM 7350-GET-CX-DAYS          THRU 7350-EXIT.            
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF CX-CODE-UTIL-TYPE  EQUAL WS-ELEC                       
                 MOVE WS-NO-UNITS         TO RS-UNITS                   
              ELSE                                                      
                 MOVE WS-NO-UNITS         TO RS-UNITS                   
                 IF RS-UNITS      NOT EQUAL WS-ZERO AND                 
                    RS-BTU-FACTOR NOT EQUAL WS-ZERO                     
                    COMPUTE RS-THERMS ROUNDED                           
                                      = RS-UNITS * RS-BTU-FACTOR        
                 END-IF                                                 
              END-IF                                                    
                                                                        
              IF WS-NO-DAYS GREATER THAN WS-ZERO                        
                 IF CX-CODE-UTIL-TYPE EQUAL WS-GAS                      
                    COMPUTE RS-PER-DAY-USE ROUNDED =                    
                            RS-THERMS / WS-NO-DAYS                      
                 ELSE                                                   
                    COMPUTE RS-PER-DAY-USE ROUNDED =                    
                            WS-NO-UNITS / WS-NO-DAYS                    
                 END-IF                                                 
              ELSE                                                      
                 MOVE WS-NO-UNITS         TO RS-PER-DAY-USE             
              END-IF                                                    
                                                                        
              IF BACKOUT-ITEM                                           
                 COMPUTE RS-PER-DAY-USE = RS-PER-DAY-USE * -1           
              END-IF                                                    
              MOVE WS-NO-DAYS             TO RS-NO-DAYS                 
           END-IF.                                                      
                                                                        
           IF CX-CODE-UTIL-TYPE EQUAL WS-ELEC                           
              MOVE WS-NO-UNITS            TO RS-UNITS                   
           ELSE                                                         
              MOVE WS-NO-UNITS            TO RS-UNITS                   
              IF RS-UNITS      NOT EQUAL WS-ZERO AND                    
                 RS-BTU-FACTOR NOT EQUAL WS-ZERO                        
                 COMPUTE RS-THERMS ROUNDED                              
                                   = RS-UNITS * RS-BTU-FACTOR           
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2220-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2225-ACCUM-CX-ROWS.                                            *        
      *                                                                *        
      ******************************************************************        
       2225-ACCUM-CX-ROWS.                                              
                                                                        
           PERFORM 7410-FETCH-CX-CURSOR      THRU  7410-EXIT.           
      *    COMBINE ALL THE UNITS FOR THE PARTICULAR BILL NO.                    
      *    INCASE,IF COMSUMPTION IS CREDIT THEN SUBTRACT THAT                   
      *    PARTICULAR UNITS FROM TOT UNITS.                                     
           IF WS-ACTIVE-RETURN-CODE   EQUAL SUCCESSFUL-CALL             
              IF CX-CODE-DEBIT-CREDIT EQUAL WS-CREDIT                   
                 SUBTRACT CX-NO-UNITS  FROM WS-NO-UNITS                 
              ELSE                                                      
                 ADD CX-NO-UNITS            TO WS-NO-UNITS              
              END-IF                                                    
              MOVE WS-YES                   TO RS-COMBINED-READING      
           END-IF.                                                      
                                                                        
       2225-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2230-PROCESS-BZ-CURSOR                                         *        
      *                                                                *        
      ******************************************************************        
       2230-PROCESS-BZ-CURSOR.                                          
                                                                        
      *    CONSUMPTION TYPE CODE,A CODE THAT INDICATES THE TYPE OF              
      *    CONSUMPTION BILLED. B - KWH , J - KW DEMAND ,D-DEKATHERMS            
      *    C-CCF (BILLED IN THERMS)                                             
      *                                                                         
      *    INSTRUCTION USE TYPE CODE - INDICATES IF THE BASELINE                
      *    TO R-ENERGY, D-DEMAND, OR U-UNMETERED                                
                                                                        
      *    THIS IS ONLY FOR ELECTRIC.                                           
           IF BZ-CONSUMPT-TYPE-CD EQUAL WS-KWH                          
              AND BZ-INSTR-USE-TYPE-CD EQUAL WS-ENERGY                  
              ADD BZ-READ-UNITS           TO WS-KWH-UNITS               
              ADD BZ-WNA-COMP-AM          TO WS-WNA-COMP-AM             
           END-IF                                                       
                                                                        
      *    THIS IS ONLY FOR GAS.                                                
           IF BZ-CONSUMPT-TYPE-CD EQUAL WS-DEKATHERMS AND               
              BZ-INSTR-USE-TYPE-CD EQUAL WS-ENERGY                      
              COMPUTE BZ-READ-UNITS = BZ-READ-UNITS * 10                
              COMPUTE BZ-BILL-UNITS = BZ-BILL-UNITS * 10                
              MOVE BZ-CMPNT-ID-CD         TO N6-RATE-CMPNT-ID           
              PERFORM 7590-CHECK-REV-CNSMPNT-FL THRU 7590-EXIT          
              IF N6-REVENUE-CNSMPTN-FL EQUAL WS-YES                     
                 ADD BZ-READ-UNITS        TO WS-CCF-UNITS               
                 ADD BZ-BILL-UNITS        TO WS-THERMS                  
              END-IF                                                    
              ADD BZ-WNA-COMP-AM          TO WS-WNA-COMP-AM             
           END-IF                                                       
                                                                        
      *    THIS IS ONLY FOR GAS.                                                
           IF BZ-CONSUMPT-TYPE-CD EQUAL WS-CCF AND                      
              BZ-INSTR-USE-TYPE-CD EQUAL WS-ENERGY                      
              ADD BZ-READ-UNITS           TO WS-CCF-UNITS               
              ADD BZ-BILL-UNITS           TO WS-THERMS                  
              ADD BZ-WNA-COMP-AM          TO WS-WNA-COMP-AM             
           END-IF                                                       
                                                                        
      *    CODE TIME PERIOD - INDICATES THE TIME PERIOD THE BASELINE            
      *    APPLIES TO; 1 = ON-PEAK, 2 = OFF-PEAK,3 = SHOULDER/PARTIAL           
                                                                        
           IF BZ-CONSUMPT-TYPE-CD EQUAL WS-KW-DEMAND                    
              IF BZ-CODE-TIME-PERIOD EQUAL WS-ONE                       
                 MOVE BZ-READ-UNITS       TO RS-ACTUAL-ONPEAK           
                 MOVE BZ-BILL-UNITS       TO RS-BILLED-ONPEAK           
                 SUBTRACT BZ-BILL-UNITS FROM BZ-READ-UNITS              
                                      GIVING RS-ONPEAK-DIFF             
              END-IF                                                    
                                                                        
              IF BZ-CODE-TIME-PERIOD EQUAL WS-TWO                       
                 MOVE BZ-READ-UNITS       TO RS-ACTUAL-OFFPEAK          
                 MOVE BZ-BILL-UNITS       TO RS-BILLED-OFFPEAK          
                 SUBTRACT BZ-BILL-UNITS FROM BZ-READ-UNITS              
                                      GIVING RS-OFFPEAK-DIFF            
              END-IF                                                    
                                                                        
              IF BZ-CODE-TIME-PERIOD EQUAL WS-THREE                     
                 MOVE BZ-READ-UNITS       TO RS-ACTUAL-SHLDR            
                 MOVE BZ-BILL-UNITS       TO RS-BILLED-SHLDR            
                 SUBTRACT BZ-BILL-UNITS FROM BZ-READ-UNITS              
                                      GIVING RS-SHLDR-DIFF              
              END-IF                                                    
           END-IF                                                       
                                                                        
           ADD BZ-CALC-COMP-AM               TO RS-UTILITY-USG-AMT.     
                                                                        
           PERFORM 7510-FETCH-BZ-CURSOR      THRU  7510-EXIT.           
                                                                        
       2230-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 2240-PROCESS-DEGREE-DAYS.                                     *         
      *                                                               *         
      *****************************************************************         
       2240-PROCESS-DEGREE-DAYS.                                        
                                                                        
           PERFORM 7540-OPEN-TEMPERATURE      THRU 7540-EXIT.           
           PERFORM 7550-FETCH-TEMPERATURE     THRU 7550-EXIT.           
           PERFORM 2250-PROCESS-TEMPERATURE   THRU 2250-EXIT            
                                             UNTIL NO-MORE-E8-ROWS.     
                                                                        
           COMPUTE WS-HOLD-ACCUM-TMP ROUNDED = WS-HOLD-ACCUMDEG.        
           MOVE WS-HOLD-ACCUM-TMP           TO WS-HOLD-ACCUMDEG.        
           PERFORM 7560-CLOSE-TEMPERATURE     THRU 7560-EXIT.           
                                                                        
       2240-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 2250-PROCESS-TEMPERATURE.                                     *         
      *                                                               *         
      *****************************************************************         
       2250-PROCESS-TEMPERATURE.                                        
                                                                        
           IF B1-WEATHER-SERV-DIV = '1'                                 
              COMPUTE WS-A = (E8-COLA-HIGH + E8-COLA-LOW) / 2           
           ELSE                                                         
             IF B1-WEATHER-SERV-DIV = '2'                               
                COMPUTE WS-A = (E8-CHAS-HIGH + E8-CHAS-LOW) / 2         
             ELSE                                                       
               IF B1-WEATHER-SERV-DIV = '3'                             
                  COMPUTE WS-A = (E8-AIKEN-HIGH + E8-AIKEN-LOW) / 2     
               END-IF                                                   
             END-IF                                                     
           END-IF                                                       
                                                                        
           IF AT-COMPANY-NO EQUAL '01' AND                              
              PARM-CODE-UTIL-TYPE EQUAL WS-ELEC                         
              COMPUTE WS-CALC = (60 - WS-A)                             
           ELSE                                                         
              COMPUTE WS-CALC = (65 - WS-A)                             
           END-IF                                                       
                                                                        
           IF WS-CALC LESS THAN WS-ZERO                                 
              MOVE WS-ZERO                  TO WS-CALC                  
           END-IF                                                       
                                                                        
           COMPUTE WS-HOLD-ACCUMDEG = (WS-CALC + WS-HOLD-ACCUMDEG)      
           PERFORM 7550-FETCH-TEMPERATURE      THRU 7550-EXIT.          
                                                                        
       2250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2260-BUILD-RS2.                                                         
      *                                                                *        
      ******************************************************************        
       2260-BUILD-RS2.                                                  
                                                                        
           PERFORM 7600-OPEN-SO-CURRENT     THRU 7600-EXIT.             
           PERFORM 7610-FETCH-SO-CURRENT    THRU 7610-EXIT.             
           PERFORM 2270-PROCESS-VO-CURSOR   THRU 2270-EXIT              
             UNTIL NO-MORE-VO-ROWS.                                     
           PERFORM 7620-CLOSE-SO-CURRENT    THRU 7620-EXIT.             
                                                                        
           PERFORM 7630-OPEN-WQ-ITMS        THRU 7630-EXIT.             
           PERFORM 7640-FETCH-WQ-ITMS       THRU 7640-EXIT.             
           PERFORM 2280-PROCESS-WQ-CURSOR   THRU 2280-EXIT              
             UNTIL NO-MORE-WQ-ROWS.                                     
           PERFORM 7650-CLOSE-WQ-ITMS       THRU 7650-EXIT.             
                                                                        
       2260-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2270-PROCESS-VO-CURSOR.                                        *        
      *                                                                *        
      ******************************************************************        
       2270-PROCESS-VO-CURSOR.                                          
                                                                        
           PERFORM 2000B-MOVE-RESULT           THRU 2000B-EXIT.         
           PERFORM 8020-INSERT-GTT-R2          THRU 8020-EXIT.          
           MOVE WS-ZERO                     TO RS-IC-NO                 
                                               RS-METER-REF-NO.         
           MOVE SPACES                      TO RS-CODE-UTIL-TYPE        
                                               RS-METER-NO              
                                               RS-EVENT-DESC            
                                               RS-EVENT-STATUS          
                                               RS-COMPLETED-DATE.       
           PERFORM 7610-FETCH-SO-CURRENT       THRU  7610-EXIT.         
                                                                        
       2270-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2280-PROCESS-WQ-CURSOR.                                        *        
      *                                                                *        
      ******************************************************************        
       2280-PROCESS-WQ-CURSOR.                                          
                                                                        
           PERFORM 2000B-MOVE-RESULT           THRU 2000B-EXIT.         
           PERFORM 8020-INSERT-GTT-R2          THRU 8020-EXIT.          
           MOVE WS-ZERO                     TO RS-IC-NO                 
                                               RS-METER-REF-NO.         
           MOVE SPACES                      TO RS-CODE-UTIL-TYPE        
                                               RS-METER-NO              
                                               RS-EVENT-DESC            
                                               RS-EVENT-STATUS          
                                               RS-COMPLETED-DATE.       
           PERFORM 7640-FETCH-WQ-ITMS          THRU  7640-EXIT.         
                                                                        
       2280-EXIT.                                                       
           EXIT.                                                        
                                                                        
PRJ821******************************************************************        
PRJ821* 2300-PROCESS-RT-OPT-DESC.                                      *        
PRJ821*                                                                *        
PRJ821******************************************************************        
PRJ821 2300-PROCESS-RT-OPT-DESC.                                        
PRJ821                                                                  
PRJ821     IF RD-RATE-PLAN-NO NOT EQUAL WS-PREV-RATE-PLAN-NO            
PRJ821        PERFORM 7930-GET-RATE-DESC        THRU 7930-EXIT          
PRJ821     END-IF.                                                      
PRJ821                                                                  
PRJ821     MOVE RD-RATE-DESC                 TO RS-RATE-PLAN-DESC.      
PRJ821     MOVE SPACES                       TO RS-OPTION-CD.           
PRJ821     MOVE SPACES                       TO RS-OPTION-DESC.         
PRJ821     MOVE RD-RATE-PLAN-NO              TO WS-PREV-RATE-PLAN-NO.   
PRJ821                                                                  
PRJ821                                                                  
PRJ821     IF SEB-DATABASE AND BG-RT-PKG-OPT-SEQ-NO > 0                 
PRJ821                                                                  
PRJ821        IF BG-ACCOUNT-NO     NOT EQUAL WS-PREV-ACCOUNT-NO         
PRJ821        OR BG-CODE-UTIL-TYPE NOT EQUAL WS-PREV-CODE-UTIL-TYPE     
PRJ821        OR BG-IC-NO          NOT EQUAL WS-PREV-IC-NO              
PRJ821        OR BG-RT-PKG-OPT-SEQ-NO NOT EQUAL                         
PRJ821                                     WS-PREV-RT-PKG-OPT-SEQ-NO    
PRJ821                                                                  
PRJ821           MOVE BG-ACCOUNT-NO          TO DF-ACCOUNT-NO           
PRJ821           MOVE BG-CODE-UTIL-TYPE      TO DF-CODE-UTIL-TYPE       
PRJ821           MOVE BG-IC-NO               TO DF-IC-NO                
PRJ821           MOVE BG-RT-PKG-OPT-SEQ-NO   TO DF-RT-PKG-OPT-SEQ-NO    
PRJ821                                                                  
PRJ821           PERFORM 7920-GET-OPTION-DESC   THRU 7920-EXIT          
PRJ821                                                                  
PRJ821           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL         
PRJ821              MOVE FI-OPT-DESC-INT     TO WS-OPTION-DESC          
PRJ821              MOVE FI-OPTION-CD        TO WS-OPTION-CD            
PRJ821           ELSE                                                   
PRJ821              MOVE SPACES              TO WS-OPTION-DESC          
PRJ821              MOVE SPACES              TO WS-OPTION-CD            
PRJ821           END-IF                                                 
PRJ821        END-IF                                                    
PRJ821                                                                  
PRJ821        MOVE WS-OPTION-DESC            TO RS-OPTION-DESC          
PRJ821        MOVE WS-OPTION-CD              TO RS-OPTION-CD            
PRJ821        MOVE BG-ACCOUNT-NO             TO WS-PREV-ACCOUNT-NO      
PRJ821        MOVE BG-CODE-UTIL-TYPE         TO WS-PREV-CODE-UTIL-TYPE  
PRJ821        MOVE BG-IC-NO                  TO WS-PREV-IC-NO           
PRJ821        MOVE BG-RT-PKG-OPT-SEQ-NO      TO                         
PRJ821                                       WS-PREV-RT-PKG-OPT-SEQ-NO  
PRJ821     END-IF.                                                      
PRJ821                                                                  
PRJ821 2300-EXIT.                                                       
PRJ821     EXIT.                                                        
PRJ821                                                                  
PRJ821                                                                  
P00836******************************************************************        
P00836** WEB USAGE HISTORY-RESIDENTIAL CUSTOMERS                      **        
P00836******************************************************************        
P00836*                                                                         
P00836 2400-WEBMOD-RESIDENTIAL.                                         
P00836*                                                                         
P00836     MOVE '2400'                       TO ACTIVE-PARAGRAPH.       
P00836*                                                                         
P00836**** ACA -> CORRECTED BILL, SCA -> NON-CALC & ACK -> CANCEL-ROW           
P00836*                                                                         
P00836     IF (S1-CODE-BILL-CALC     = 'A'  AND                         
P00836         S1-CODE-BILL-ITM-TYPE = 'C'  AND                         
P00836         S1-CODE-BILL-ITM-IND  = 'A')                             
P00836                      OR                                          
P00836        (S1-CODE-BILL-CALC     = 'S'  AND                         
P00836         S1-CODE-BILL-ITM-TYPE = 'C'  AND                         
P00836         S1-CODE-BILL-ITM-IND  = 'A')                             
P00836                      OR                                          
P00836        (S1-CODE-BILL-CALC     = 'A'  AND                         
P00836         S1-CODE-BILL-ITM-TYPE = 'C'  AND                         
P00836         S1-CODE-BILL-ITM-IND  = 'K')                             
P00836        CONTINUE                                                  
P00836     ELSE                                                         
P00836        GO TO 2400-EXIT                                           
P00836     END-IF.                                                      
P00836*                                                                         
P00836**** SCA -> NON-CALC: INITIALIZE REQUIRED DATA                            
P00836     IF S1-CODE-BILL-CALC     = 'S' AND                           
P00836        S1-CODE-BILL-ITM-TYPE = 'C' AND                           
P00836        S1-CODE-BILL-ITM-IND  = 'A'                               
P00836        MOVE SPACES                    TO S1-DATE-BILLED          
P00836     END-IF.                                                      
P00836*                                                                         
P00836     IF WS-SHOW-LATEST-BILL-FL = 'Y' AND                          
P00836        CTR-ROWS-RS4           =  0  AND                          
P00836        S1-BILL-NO             >  0  AND                          
P00836        S1-REVENUE-MONTH       >  0                               
P00836        MOVE S1-REVENUE-MONTH          TO WS-WEB-REV-MTH-LATEST   
P00836        PERFORM 7950-CHECK-BILL-CRED-DATA THRU 7950-EXIT          
P00836        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
P00836           MOVE 'N'                    TO WS-SHOW-LATEST-BILL-FL  
P00836        END-IF                                                    
P00836     END-IF.                                                      
P00836*                                                                         
P00836     IF S1-REV-MTH-ORIG-BILL > 0                                  
P00836        MOVE S1-REV-MTH-ORIG-BILL      TO S1-REVENUE-MONTH        
P00836     END-IF.                                                      
P00836*                                                                         
P00836*** HIDE LATEST REVENUE MONTH BILL(S) WHEN FLAG IS 'N'                    
P00836*                                                                         
P00836     IF WS-SHOW-LATEST-BILL-FL = 'N' AND                          
P00836        WS-WEB-REV-MTH-LATEST  =  S1-REVENUE-MONTH                
P00836        CONTINUE                                                  
P00836     ELSE                                                         
P00836        PERFORM 8040-INSERT-GTT-R4  THRU  8040-EXIT               
P00836     END-IF.                                                      
P00836*                                                                         
P00836 2400-EXIT.                                                       
P00836     EXIT.                                                        
P00836*                                                                         
      ******************************************************************        
      *                                                                *        
      * 7002-GET-ACCOUNT-DET                                           *        
      *                                                                *        
      ******************************************************************        
       7002-GET-ACCOUNT-DET.                                            
                                                                        
           EXEC SQL                                                     
              SELECT AT.REV_MTH_LST_NRML                                
P00836              ,AT.ACCOUNT_TYPE_CODE                               
                INTO :AT-REV-MTH-LST-NRML                               
P00836              ,:AT-ACCOUNT-TYPE-CODE                              
                FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
               WHERE AT.ACCOUNT_NO    = :AT-ACCOUNT-NO                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT AT.REV_MTH_LST_NRML                                        
MFA-TR*             ,AT.ACCOUNT_TYPE_CODE                                       
MFA-TR*         INTO :AT-REV-MTH-LST-NRML                                       
MFA-TR*             ,:AT-ACCOUNT-TYPE-CODE                                      
MFA-TR*         FROM CSS_ACCOUNT AT                                             
MFA-TR*        WHERE AT.ACCOUNT_NO    = :AT-ACCOUNT-NO                          
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7002                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7002'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_ACCOUNT'            TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE AT-REV-MTH-LST-NRML      TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7002-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00836******************************************************************        
P00836** CHECK ACTIVE/IN PROGRESS WQ WITH EBILL NO DISPLAY IND SET    **        
P00836******************************************************************        
P00836*                                                                         
P00836 7050-CHECK-EBILL-NO-DISP-IND.                                    
P00836*                                                                         
P00836     EXEC SQL                                                     
P00836          SELECT TOP(1) 'N'                                              
P00836            INTO :WS-SHOW-LATEST-BILL-FL                          
P00836            FROM CSS_WQ_CATEGORY C3 WITH(READUNCOMMITTED)                 
P00836                ,CSS_WQ_ITEMS    WQ WITH(READUNCOMMITTED)                 
P00836           WHERE WQ.ACCOUNT_NO        =  :WQ-ACCOUNT-NO           
P00836             AND WQ.CATEGORY_ID       =   C3.CATEGORY_ID          
P00836             AND C3.EBILL_NO_DISP_IND =  'Y'                      
P00836             AND WQ.STATUS           IN ('A','I')                 
P00836                                       
P00836                                                      
P00836     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'N'                                                      
MFA-TR*           INTO :WS-SHOW-LATEST-BILL-FL                                  
MFA-TR*           FROM CSS_WQ_CATEGORY C3                                       
MFA-TR*               ,CSS_WQ_ITEMS    WQ                                       
MFA-TR*          WHERE WQ.ACCOUNT_NO        =  :WQ-ACCOUNT-NO                   
MFA-TR*            AND WQ.CATEGORY_ID       =   C3.CATEGORY_ID                  
MFA-TR*            AND C3.EBILL_NO_DISP_IND =  'Y'                              
MFA-TR*            AND WQ.STATUS           IN ('A','I')                         
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*         QUERYNO 7050                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00836                                                                  
P00836     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
P00836                                                                  
P00836     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
P00836        CONTINUE                                                  
P00836     ELSE                                                         
P00836        MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
P00836        MOVE '7050'                   TO ACTIVE-PARAGRAPH         
P00836        MOVE 'SELECT'                 TO ABEND-FUNCTION           
P00836        MOVE SPACES                   TO ABEND-SQL-PREDICATES     
P00836                                         ABEND-TABLES             
P00836        MOVE 'CSS_WQ_IEMS'            TO TABLE-1                  
P00836        MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
P00836        MOVE WQ-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
P00836        PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
P00836        PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
P00836     END-IF.                                                      
P00836*                                                                         
P00836 7050-EXIT.                                                       
P00836     EXIT.                                                        
P00836*                                                                         
      *****************************************************************         
      * 7100-OPEN-BG-CURSOR.                                          *         
      *                                                               *         
      *****************************************************************         
       7100-OPEN-BG-CURSOR.                                             
                                                                        
           EXEC SQL                                                     
               OPEN BG_CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN '                    TO ABEND-FUNCTION         
              MOVE '7100'                     TO ACTIVE-PARAGRAPH       
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_BILLING_DET  '        TO TABLE-1                
              MOVE 'PREMISE_NO    '           TO TABLE-ELEMENT-1        
              MOVE 'ACCOUNT_NO  '             TO TABLE-ELEMENT-2        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-3        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-4        
              MOVE BG-PREMISE-NO              TO HOSTVAR-ELEMENT-1      
              MOVE BG-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
              MOVE BG-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-3      
              MOVE BG-IC-NO                   TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7110-FETCH-BG-CURSOR.                                         *         
      *                                                               *         
      *****************************************************************         
       7110-FETCH-BG-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
               FETCH BG_CURSOR                                          
               INTO :BG-ACCOUNT-NO                                      
                   ,:BG-BILL-NO                                         
                   ,:BG-CODE-UTIL-TYPE                                  
                   ,:BG-IC-NO                                           
                   ,:BG-BILL-ITEM-TIMESTMP                              
                   ,:BG-CODE-DR-CR-CNSMPTN                              
                   ,:BG-RATE-PLAN-NO                                    
                   ,:BG-AMT-BILL-ITEM                                   
                   ,:BG-BTU-FACTOR                                      
                   ,:BG-GAS-BASE-USE                                    
                   ,:BG-WNA-FACTOR                                      
                   ,:BG-COMPANY-NO                                      
                   ,:BG-REV-RPT-CD                                      
                   ,:BG-REVENUE-MONTH                                   
                   ,:BG-REV-MTH-ORIG-BILL                               
                   ,:BG-REBILL-IND                                      
P00836             ,:BG-CODE-BILL-CALC                                  
                   ,:BG-CODE-BILL-ITM-TYPE                              
                   ,:BG-CODE-BILL-ITM-IND                               
                   ,:BI-DATE-BILLED :WS-NULL-IND                        
PRJ821             ,:BG-RT-PKG-OPT-SEQ-NO                               
P00836             ,:BI-CODE-BILL-TYPE                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                  IF WS-NULL-IND < 0                                    
                     MOVE SPACES             TO BI-DATE-BILLED          
                  END-IF                                                
                  IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                  
                     MOVE WS-YES             TO WS-NO-MORE-BG-ROWS      
                     MOVE ZERO               TO BG-REVENUE-MONTH        
                  END-IF                                                
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
                    MOVE '7110'               TO ACTIVE-PARAGRAPH       
                    MOVE 'FETCH '             TO ABEND-FUNCTION         
                    MOVE SPACES               TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
                    MOVE 'CSS_BILLING_DET  '  TO TABLE-1                
                    MOVE 'PREMISE_NO    '     TO TABLE-ELEMENT-1        
                    MOVE 'ACCOUNT_NO  '       TO TABLE-ELEMENT-2        
                    MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-3        
                    MOVE 'IC_NO'              TO TABLE-ELEMENT-4        
                    MOVE BG-PREMISE-NO        TO HOSTVAR-ELEMENT-1      
                    MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-2      
                    MOVE BG-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-3      
                    MOVE BG-IC-NO             TO HOSTVAR-ELEMENT-4      
                    PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT      
                    PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT      
           END-EVALUATE.                                                
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7120-CLOSE-BG-CURSOR                                          *         
      *                                                               *         
      *****************************************************************         
       7120-CLOSE-BG-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
               CLOSE BG_CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7120'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE '                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_BILLING_DET  '        TO TABLE-1                
              MOVE 'PREMISE_NO    '           TO TABLE-ELEMENT-1        
              MOVE 'ACCOUNT_NO  '             TO TABLE-ELEMENT-2        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-3        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-4        
              MOVE BG-PREMISE-NO              TO HOSTVAR-ELEMENT-1      
              MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-2      
              MOVE BG-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-3      
              MOVE BG-IC-NO                   TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * 7300-SELECT-BACKOUT-CNSMPTN.                                *           
      *                                                             *           
      ***************************************************************           
       7300-SELECT-BACKOUT-CNSMPTN.                                     
                                                                        
           EXEC SQL                                                     
              SELECT SUM(READ_UNITS)                                    
                INTO :BZ-READ-UNITS :WS-READ-UNITS-NULL                  
                FROM CSS_BILL_CALC_DET WITH(READUNCOMMITTED)                    
                    ,CSS_RATE_COMPONENT WITH(READUNCOMMITTED)                   
               WHERE ACCOUNT_NO          = :BG-ACCOUNT-NO               
                 AND CODE_UTIL_TYPE      = :BG-CODE-UTIL-TYPE           
                 AND IC_NO               = :BG-IC-NO                    
                 AND CONSUMPT_TYPE_CD   IN ('B','C','D')                
                 AND BILL_ITEM_TIMESTMP  = CIS.CHAR2TIMESTAMP(
                                                 :BG-BILL-ITEM-TIMESTMP
              )       
                 AND CMPNT_ID_CD         = RATE_CMPNT_ID                
                 AND REVENUE_CNSMPTN_FL  = 'Y'                          
               GROUP BY CONSUMPT_TYPE_CD                                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SUM(READ_UNITS)                                            
MFA-TR*         INTO :BZ-READ-UNITS:WS-READ-UNITS-NULL                          
MFA-TR*         FROM CSS_BILL_CALC_DET                                          
MFA-TR*             ,CSS_RATE_COMPONENT                                         
MFA-TR*        WHERE ACCOUNT_NO          = :BG-ACCOUNT-NO                       
MFA-TR*          AND CODE_UTIL_TYPE      = :BG-CODE-UTIL-TYPE                   
MFA-TR*          AND IC_NO               = :BG-IC-NO                            
MFA-TR*          AND CONSUMPT_TYPE_CD   IN ('B','C','D')                        
MFA-TR*          AND BILL_ITEM_TIMESTMP  = :BG-BILL-ITEM-TIMESTMP               
MFA-TR*          AND CMPNT_ID_CD         = RATE_CMPNT_ID                        
MFA-TR*          AND REVENUE_CNSMPTN_FL  = 'Y'                                  
MFA-TR*        GROUP BY CONSUMPT_TYPE_CD                                        
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7300                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-READ-UNITS-NULL LESS THAN WS-ZERO                   
                 MOVE WS-ZERO                TO BZ-READ-UNITS           
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7300'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_BILL_CALC_DET'       TO TABLE-1                 
              MOVE 'CSS_RATE_COMPONENT'      TO TABLE-2                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE 'IC_NO'                   TO TABLE-ELEMENT-3         
              MOVE 'BILL_ITEM_TIMESTMP'      TO TABLE-ELEMENT-4         
              MOVE BG-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE BG-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              MOVE BG-IC-NO                  TO HOSTVAR-ELEMENT-3       
              MOVE BG-BILL-ITEM-TIMESTMP     TO HOSTVAR-ELEMENT-4       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7350-GET-CX-DAYS.                                             *         
      *                                                               *         
      *****************************************************************         
       7350-GET-CX-DAYS.                                                
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) SUM(NO_DAYS)                                      
                 INTO :WS-NO-DAYS                                       
                 FROM CSS_CNSMPTN_HIST WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO         = :CX-ACCOUNT-NO               
                  AND CODE_UTIL_TYPE     = :CX-CODE-UTIL-TYPE           
                  AND BILL_NO            = :CX-BILL-NO                  
                  AND IC_NO              = :CX-IC-NO                    
                  AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :CX-BILL-ITEM-TIMESTMP
              )       
                  AND CODE_USAGE_SOURCE IN ('B','J','K')                
                  AND CODE_USAGE_ID NOT IN ('1','2','3','4','5',        
                                            '6','7','8','9')            
                GROUP BY MTR_REF_NO, REG_ID_NO, CODE_TIME_PERIOD        
                ORDER BY 1 DESC                                         
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SUM(NO_DAYS)                                              
MFA-TR*          INTO :WS-NO-DAYS                                               
MFA-TR*          FROM CSS_CNSMPTN_HIST                                          
MFA-TR*         WHERE ACCOUNT_NO         = :CX-ACCOUNT-NO                       
MFA-TR*           AND CODE_UTIL_TYPE     = :CX-CODE-UTIL-TYPE                   
MFA-TR*           AND BILL_NO            = :CX-BILL-NO                          
MFA-TR*           AND IC_NO              = :CX-IC-NO                            
MFA-TR*           AND BILL_ITEM_TIMESTMP = :CX-BILL-ITEM-TIMESTMP               
MFA-TR*           AND CODE_USAGE_SOURCE IN ('B','J','K')                        
MFA-TR*           AND CODE_USAGE_ID NOT IN ('1','2','3','4','5',                
MFA-TR*                                     '6','7','8','9')                    
MFA-TR*         GROUP BY MTR_REF_NO, REG_ID_NO, CODE_TIME_PERIOD                
MFA-TR*         ORDER BY 1 DESC                                                 
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*       QUERYNO 7350                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7350'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_CNSMPTN_HIST'    TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2             
              MOVE 'IC_NO'               TO TABLE-ELEMENT-3             
              MOVE 'BILL_NO'             TO TABLE-ELEMENT-4             
              MOVE CX-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE CX-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2           
              MOVE CX-IC-NO              TO HOSTVAR-ELEMENT-3           
              MOVE CX-BILL-NO            TO HOSTVAR-ELEMENT-4           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7350-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7400-OPEN-CX-CURSOR.                                          *         
      *                                                               *         
      *****************************************************************         
       7400-OPEN-CX-CURSOR.                                             
                                                                        
           EXEC SQL                                                     
               OPEN CX_CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7400'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN '                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_CNSMPTN_HIST '        TO TABLE-1                
              MOVE 'ACCOUNT_NO  '             TO TABLE-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
              MOVE 'BILL_NO '                 TO TABLE-ELEMENT-3        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-4        
              MOVE CX-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE CX-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2      
              MOVE CX-BILL-NO                 TO HOSTVAR-ELEMENT-3      
              MOVE CX-IC-NO                   TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7410-FETCH-CX-CURSOR.                                         *         
      *                                                               *         
      *****************************************************************         
       7410-FETCH-CX-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
               FETCH CX_CURSOR                                          
                INTO :CX-NO-UNITS                                       
                    ,:CX-NO-DAYS                                        
                    ,:CX-CODE-DEBIT-CREDIT                              
                    ,:CX-CODE-METER-READ                                
                    ,:CX-CODE-METER-NO-READ                             
                    ,:CX-DATE-READ :WS-NULL-IND                          
                    ,:CX-CONSTANT                                       
                    ,:CX-EMPLOYEE-NO                                    
                    ,:CX-CODE-SOURCE-ID                                 
                    ,:CX-BTU-FACTOR                                     
                    ,:CX-METER-READING                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    IF WS-NULL-IND LESS THAN WS-ZERO                    
                       MOVE SPACES TO CX-DATE-READ                      
                    END-IF                                              
               WHEN NOT-FOUND                                           
                    MOVE WS-YES               TO WS-NO-MORE-CX-ROWS     
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
                    MOVE '7410'               TO ACTIVE-PARAGRAPH       
                    MOVE 'FETCH  '            TO ABEND-FUNCTION         
                    MOVE SPACES               TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
                    MOVE 'CSS_CNSMPTN-HIST '  TO TABLE-1                
                    MOVE 'ACCOUNT_NO  '       TO TABLE-ELEMENT-1        
                    MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2        
                    MOVE 'BILL_NO '           TO TABLE-ELEMENT-3        
                    MOVE 'IC_NO'              TO TABLE-ELEMENT-4        
                    MOVE CX-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1      
                    MOVE CX-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2      
                    MOVE CX-BILL-NO           TO HOSTVAR-ELEMENT-3      
                    MOVE CX-IC-NO             TO HOSTVAR-ELEMENT-4      
                    PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT      
                    PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT      
           END-EVALUATE.                                                
                                                                        
       7410-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7420-CLOSE-CX-CURSOR.                                         *         
      *                                                               *         
      *****************************************************************         
       7420-CLOSE-CX-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
               CLOSE CX_CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7420'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_CNSMPTN_HIST '        TO TABLE-1                
              MOVE 'ACCOUNT_NO  '             TO TABLE-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
              MOVE 'BILL_NO '                 TO TABLE-ELEMENT-3        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-4        
              MOVE CX-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE CX-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2      
              MOVE CX-BILL-NO                 TO HOSTVAR-ELEMENT-3      
              MOVE CX-IC-NO                   TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7420-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7500-OPEN-BZ-CURSOR.                                          *         
      *                                                               *         
      *****************************************************************         
       7500-OPEN-BZ-CURSOR.                                             
                                                                        
           EXEC SQL                                                     
               OPEN BZ_CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7500'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN  '                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_BILL_CALC_DET'        TO TABLE-1                
              MOVE 'ACCOUNT_NO  '             TO TABLE-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
              MOVE 'BILL_NO '                 TO TABLE-ELEMENT-3        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-4        
              MOVE BZ-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE BZ-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2      
              MOVE BZ-BILL-NO                 TO HOSTVAR-ELEMENT-3      
              MOVE BZ-IC-NO                   TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7510-FETCH-BZ-CURSOR.                                         *         
      *                                                               *         
      *****************************************************************         
       7510-FETCH-BZ-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
             FETCH BZ_CURSOR                                            
              INTO :BZ-BILL-UNITS                                       
                  ,:BZ-READ-UNITS                                       
                  ,:BZ-INSTR-USE-TYPE-CD                                
                  ,:BZ-CONSUMPT-TYPE-CD                                 
                  ,:BZ-CODE-TIME-PERIOD                                 
                  ,:BZ-WNA-COMP-AM                                      
                  ,:BZ-CMPNT-ID-CD                                      
                  ,:BZ-CALC-COMP-AM                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE WS-YES               TO WS-NO-MORE-BZ-ROWS     
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
                    MOVE '7510'               TO ACTIVE-PARAGRAPH       
                    MOVE 'FETCH '             TO ABEND-FUNCTION         
                    MOVE SPACES               TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
                    MOVE 'CSS_BILL_CALC_DET'  TO TABLE-1                
                    MOVE 'ACCOUNT_NO  '       TO TABLE-ELEMENT-1        
                    MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2        
                    MOVE 'BILL_NO '           TO TABLE-ELEMENT-3        
                    MOVE 'IC_NO'              TO TABLE-ELEMENT-4        
                    MOVE BZ-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1      
                    MOVE BZ-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2      
                    MOVE BZ-BILL-NO           TO HOSTVAR-ELEMENT-3      
                    MOVE BZ-IC-NO             TO HOSTVAR-ELEMENT-4      
                    PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT      
                    PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT      
           END-EVALUATE.                                                
                                                                        
       7510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7520-CLOSE-BZ-CURSOR.                                         *         
      *                                                               *         
      *****************************************************************         
       7520-CLOSE-BZ-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
               CLOSE BZ_CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7520'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_BILL_CALC_DET'        TO TABLE-1                
              MOVE 'ACCOUNT_NO  '             TO TABLE-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
              MOVE 'BILL_NO '                 TO TABLE-ELEMENT-3        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-4        
              MOVE BZ-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE BZ-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2      
              MOVE BZ-BILL-NO                 TO HOSTVAR-ELEMENT-3      
              MOVE BZ-IC-NO                   TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7520-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7530-SELECT-OFFICE.                                           *         
      *                                                               *         
      *****************************************************************         
       7530-SELECT-OFFICE.                                              
                                                                        
           EXEC SQL                                                     
             SELECT AT.ACCOUNT_NO                                       
                   ,AT.COMPANY_NO                                       
                   ,B1.LOCAL_OFFICE                                     
                   ,B1.WEATHER_SERV_DIV                                 
               INTO :AT-ACCOUNT-NO                                      
                   ,:AT-COMPANY-NO                                      
                   ,:B1-LOCAL-OFFICE                                    
                   ,:B1-WEATHER-SERV-DIV :WS-NULL-IND                    
               FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                        
                   ,CSS_LOCAL_OFFICE B1 WITH(READUNCOMMITTED)                   
              WHERE AT.ACCOUNT_NO     = :BG-ACCOUNT-NO                  
                AND AT.LOCAL_OFFICE   = B1.LOCAL_OFFICE                 
                AND AT.COMPANY_NO     = B1.COMPANY_NO                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT AT.ACCOUNT_NO                                               
MFA-TR*            ,AT.COMPANY_NO                                               
MFA-TR*            ,B1.LOCAL_OFFICE                                             
MFA-TR*            ,B1.WEATHER_SERV_DIV                                         
MFA-TR*        INTO :AT-ACCOUNT-NO                                              
MFA-TR*            ,:AT-COMPANY-NO                                              
MFA-TR*            ,:B1-LOCAL-OFFICE                                            
MFA-TR*            ,:B1-WEATHER-SERV-DIV:WS-NULL-IND                            
MFA-TR*        FROM CSS_ACCOUNT AT                                              
MFA-TR*            ,CSS_LOCAL_OFFICE B1                                         
MFA-TR*       WHERE AT.ACCOUNT_NO     = :BG-ACCOUNT-NO                          
MFA-TR*         AND AT.LOCAL_OFFICE   = B1.LOCAL_OFFICE                         
MFA-TR*         AND AT.COMPANY_NO     = B1.COMPANY_NO                           
MFA-TR*        WITH UR                                                          
MFA-TR*     QUERYNO 7530                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF WS-NULL-IND LESS THAN WS-ZERO                          
                 MOVE SPACES                  TO B1-WEATHER-SERV-DIV    
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7530'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_ACCOUNT'              TO TABLE-1                
              MOVE 'CSS_LOCAL_OFFICE'         TO TABLE-2                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'LOCAL_OFFICE'             TO TABLE-ELEMENT-2        
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-3        
              MOVE BG-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE B1-LOCAL-OFFICE            TO HOSTVAR-ELEMENT-2      
              MOVE B1-COMPANY-NO              TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7530-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7540-OPEN-TEMPERATURE.                                        *         
      *                                                               *         
      *****************************************************************         
       7540-OPEN-TEMPERATURE.                                           
                                                                        
           EXEC SQL                                                     
               OPEN TEMP_CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7540'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN  '                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_TEMPERATURE'          TO TABLE-1                
              MOVE 'TEMP_DT'                  TO TABLE-ELEMENT-1        
              MOVE 'TEMP_DT'                  TO TABLE-ELEMENT-2        
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-3        
              MOVE CX-DATE-READ               TO HOSTVAR-ELEMENT-1      
              MOVE WS-DATE-TO-BE-READ         TO HOSTVAR-ELEMENT-2      
              MOVE AT-COMPANY-NO              TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7540-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7550-FETCH-TEMPERATURE.                                       *         
      *                                                               *         
      *****************************************************************         
       7550-FETCH-TEMPERATURE.                                          
                                                                        
           EXEC SQL                                                     
               FETCH TEMP_CURSOR                                        
                INTO :E8-TEMP-DT :WS-NULL-IND                            
                    ,:E8-CHAS-HIGH                                      
                    ,:E8-AIKEN-HIGH                                     
                    ,:E8-COLA-HIGH                                      
                    ,:E8-CHAS-LOW                                       
                    ,:E8-AIKEN-LOW                                      
                    ,:E8-COLA-LOW                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    IF WS-NULL-IND LESS THAN WS-ZERO                    
                       MOVE SPACES            TO E8-TEMP-DT             
                    END-IF                                              
               WHEN NOT-FOUND                                           
                    MOVE WS-YES               TO WS-NO-MORE-E8-ROWS     
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
                    MOVE '7550'               TO ACTIVE-PARAGRAPH       
                    MOVE 'FETCH '             TO ABEND-FUNCTION         
                    MOVE SPACES               TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
                    MOVE 'CSS_TEMPERATURE'    TO TABLE-1                
                    MOVE 'DATE_READ'          TO TABLE-ELEMENT-1        
                    MOVE 'DATE_TO_BE_READ'    TO TABLE-ELEMENT-2        
                    MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-3        
                    MOVE CX-DATE-READ         TO HOSTVAR-ELEMENT-1      
                    MOVE WS-DATE-TO-BE-READ   TO HOSTVAR-ELEMENT-2      
                    MOVE AT-COMPANY-NO        TO HOSTVAR-ELEMENT-3      
                    PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT      
                    PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT      
           END-EVALUATE.                                                
                                                                        
       7550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7560-CLOSE-TEMPERATURE.                                       *         
      *                                                               *         
      *****************************************************************         
       7560-CLOSE-TEMPERATURE.                                          
                                                                        
           EXEC SQL                                                     
               CLOSE TEMP_CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7560'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_TEMPERATURE'          TO TABLE-1                
              MOVE 'TEMP_DT'                  TO TABLE-ELEMENT-1        
              MOVE 'TEMP_DT'                  TO TABLE-ELEMENT-2        
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-3        
              MOVE CX-DATE-READ               TO HOSTVAR-ELEMENT-1      
              MOVE WS-DATE-TO-BE-READ         TO HOSTVAR-ELEMENT-2      
              MOVE AT-COMPANY-NO              TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7560-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * 7570-GET-NEXT-READ-DATE.                                      *         
      *                                                               *         
      *****************************************************************         
       7570-GET-NEXT-READ-DATE.                                         
                                                                        
           EXEC SQL                                                     
                SELECT
              DATEADD(D, (CIS.DAYS( IIF(TRY_CONVERT(DATE, :WS-DATE-READ
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-READ
              ) <> 0) OR (LEN(:WS-DATE-READ) <> 10), CIS.CHAR2DATE(
                                                          :WS-DATE-READ
              ), CONVERT(DATE, :WS-DATE-READ) ) ) - :WS-NO-DAYS)-1, 
              CAST('00010101' AS DATE))
            INTO
              :WS-DATE-TO-BE-READ               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-DATE-TO-BE-READ                                         
MFA-TR*         = DATE(DAYS(:WS-DATE-READ) - :WS-NO-DAYS)                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SET'                      TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE CX-DATE-READ               TO HOSTVAR-ELEMENT-1      
              MOVE CX-NO-DAYS                 TO HOSTVAR-ELEMENT-2      
              MOVE WS-DATE-TO-BE-READ         TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7570-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7590-CHECK-REV-CNSMPNT-FL.                                    *         
      *                                                               *         
      *****************************************************************         
       7590-CHECK-REV-CNSMPNT-FL.                                       
                                                                        
           EXEC SQL                                                     
              SELECT REVENUE_CNSMPTN_FL                                 
                INTO :N6-REVENUE-CNSMPTN-FL                             
                FROM CSS_RATE_COMPONENT WITH(READUNCOMMITTED)                   
               WHERE RATE_CMPNT_ID = :N6-RATE-CMPNT-ID                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT REVENUE_CNSMPTN_FL                                         
MFA-TR*         INTO :N6-REVENUE-CNSMPTN-FL                                     
MFA-TR*         FROM CSS_RATE_COMPONENT                                         
MFA-TR*        WHERE RATE_CMPNT_ID = :N6-RATE-CMPNT-ID                          
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7590                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7590'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_RATE_COMPONENT'       TO TABLE-1                
              MOVE 'RATE_CMPNT_ID'            TO TABLE-ELEMENT-1        
              MOVE N6-RATE-CMPNT-ID           TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7590-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7600-OPEN-SO-CURRENT.                                         *         
      *                                                               *         
      *****************************************************************         
       7600-OPEN-SO-CURRENT.                                            
                                                                        
           EXEC SQL                                                     
               OPEN SO_CUR_CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7600'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN  '                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_SO_DATA'              TO TABLE-1                
              MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-1        
              MOVE WS-PREMISE-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7610-FETCH-SO-CURRENT.                                        *         
      *                                                               *         
      *****************************************************************         
       7610-FETCH-SO-CURRENT.                                           
                                                                        
           EXEC SQL                                                     
               FETCH SO_CUR_CURSOR                                      
                INTO :RS-ACCOUNT-NO                                     
                    ,:RS-CODE-UTIL-TYPE                                 
                    ,:RS-IC-NO                                          
                    ,:RS-METER-NO                                       
                    ,:RS-METER-REF-NO                                   
                    ,:RS-EVENT-DESC                                     
                    ,:RS-EVENT-STATUS                                   
                    ,:RS-COMPLETED-DATE :WS-NULL-IND                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    IF WS-NULL-IND < 0                                  
                        MOVE SPACES           TO RS-COMPLETED-DATE      
                    END-IF                                              
               WHEN NOT-FOUND                                           
                    MOVE WS-YES               TO WS-NO-MORE-VO-ROWS     
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
                    MOVE '7610'               TO ACTIVE-PARAGRAPH       
                    MOVE 'FETCH '             TO ABEND-FUNCTION         
                    MOVE SPACES               TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
                    MOVE 'CSS_SO_DATA'        TO TABLE-1                
                    MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-1        
                    MOVE WS-PREMISE-NO        TO HOSTVAR-ELEMENT-1      
                    PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT      
                    PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT      
           END-EVALUATE.                                                
                                                                        
       7610-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7620-CLOSE-SO-CURRENT.                                        *         
      *                                                               *         
      *****************************************************************         
       7620-CLOSE-SO-CURRENT.                                           
                                                                        
           EXEC SQL                                                     
               CLOSE SO_CUR_CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7620'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_SO_DATA'              TO TABLE-1                
              MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-1        
              MOVE WS-PREMISE-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7620-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7630-OPEN-WQ-ITMS.                                            *         
      *****************************************************************         
       7630-OPEN-WQ-ITMS.                                               
                                                                        
           EXEC SQL                                                     
               OPEN WQ_ITM_CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7630'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN  '                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_WQ_ITEMS'             TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7630-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7640-FETCH-WQ-ITMS.                                           *         
      *                                                               *         
      *****************************************************************         
       7640-FETCH-WQ-ITMS.                                              
                                                                        
           EXEC SQL                                                     
               FETCH WQ_ITM_CURSOR                                      
                INTO :RS-ACCOUNT-NO                                     
                    ,:RS-EVENT-DESC                                     
                    ,:RS-EVENT-STATUS                                   
                    ,:RS-COMPLETED-DATE :WS-NULL-IND                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    IF WS-NULL-IND < 0                                  
                        MOVE SPACES           TO RS-COMPLETED-DATE      
                    END-IF                                              
               WHEN NOT-FOUND                                           
                    MOVE WS-YES               TO WS-NO-MORE-WQ-ROWS     
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
                    MOVE '7640'               TO ACTIVE-PARAGRAPH       
                    MOVE 'FETCH '             TO ABEND-FUNCTION         
                    MOVE SPACES               TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
                    MOVE 'CSS_WQ_ITEMS'       TO TABLE-1                
                    MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1        
                    MOVE WS-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1      
                    PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT      
                    PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT      
           END-EVALUATE.                                                
                                                                        
       7640-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7650-CLOSE-WQ-ITMS.                                           *         
      *                                                               *         
      *****************************************************************         
       7650-CLOSE-WQ-ITMS.                                              
                                                                        
           EXEC SQL                                                     
               CLOSE WQ_ITM_CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7650'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_WQ_ITEMS'             TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7650-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7850-DETERMINE-INDUS-GAS-RATE.                                *         
      *                                                               *         
      *****************************************************************         
       7850-DETERMINE-INDUS-GAS-RATE.                                   
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :RS-INDUS-GAS-RATE                                 
                FROM CSS_RATE_COMP_DEF RC WITH(READUNCOMMITTED)                 
               WHERE RC.RATE_PLAN_NO      = :RS-RATE-PLAN-NO            
                 AND RC.CODE_UTIL_TYPE    = :PARM-CODE-UTIL-TYPE        
                 AND RC.REG_TYPE_CD       = 'D'                         
                 AND VERSION_NO_CNTRL     =                             
                           (SELECT MAX(VERSION_NO_CNTRL)                
                              FROM CSS_RATE_COMP_DEF
                           WITH(READUNCOMMITTED)                    
                             WHERE CODE_UTIL_TYPE = :PARM-CODE-UTIL-TYPE
                               AND RATE_PLAN_NO   = :RS-RATE-PLAN-NO)   
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :RS-INDUS-GAS-RATE                                         
MFA-TR*         FROM CSS_RATE_COMP_DEF RC                                       
MFA-TR*        WHERE RC.RATE_PLAN_NO      = :RS-RATE-PLAN-NO                    
MFA-TR*          AND RC.CODE_UTIL_TYPE    = :PARM-CODE-UTIL-TYPE                
MFA-TR*          AND RC.REG_TYPE_CD       = 'D'                                 
MFA-TR*          AND VERSION_NO_CNTRL     =                                     
MFA-TR*                    (SELECT MAX(VERSION_NO_CNTRL)                        
MFA-TR*                       FROM CSS_RATE_COMP_DEF                            
MFA-TR*                      WHERE CODE_UTIL_TYPE = :PARM-CODE-UTIL-TYPE        
MFA-TR*                        AND RATE_PLAN_NO   = :RS-RATE-PLAN-NO)           
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7850                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7850'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_RATE_COMP_DEF'        TO TABLE-1                
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-1        
              MOVE RS-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7850-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7900-GET-BILL-EXIST.                                          *         
      *                                                               *         
      *****************************************************************         
       7900-GET-BILL-EXIST.                                             
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-BILL-EXIST-FL                                  
                FROM CSS_BILLING_DET    BG WITH(READUNCOMMITTED)                
               WHERE BG.ACCOUNT_NO        = :WS-ACCOUNT-NO              
                 AND BG.REVENUE_MONTH     < :BG-REVENUE-MONTH           
                 AND BG.REVENUE_MONTH     > 0                           
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-BILL-EXIST-FL                                          
MFA-TR*         FROM CSS_BILLING_DET    BG                                      
MFA-TR*        WHERE BG.ACCOUNT_NO        = :WS-ACCOUNT-NO                      
MFA-TR*          AND BG.REVENUE_MONTH     < :BG-REVENUE-MONTH                   
MFA-TR*          AND BG.REVENUE_MONTH     > 0                                   
MFA-TR*          FETCH FIRST ROW ONLY                                           
MFA-TR*          WITH UR                                                        
MFA-TR*      QUERYNO 7900                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7900'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_BILLING_DET'          TO TABLE-1                
              MOVE 'BG.ACCOUNT_NO'            TO TABLE-ELEMENT-1        
              MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'BG.REVENUE_MONTH'         TO TABLE-ELEMENT-2        
              MOVE WS-CUTOFF-REV-MTH          TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7900-EXIT.                                                       
           EXIT.                                                        
                                                                        
PRJ821*****************************************************************         
PRJ821* 7910-GET-DATABASE                                             *         
PRJ821*     SELECTS BILLING ENTITY (SEB OR SCEG) FROM CSS_DELINQUENCY *         
PRJ821*****************************************************************         
PRJ821 7910-GET-DATABASE.                                               
PRJ821                                                                  
PRJ821     EXEC SQL                                                     
PRJ821        SELECT DELINQ_VALUE                                       
PRJ821          INTO :C8-DELINQ-VALUE                                   
PRJ821          FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
PRJ821         WHERE DELINQ_CD  = :C8-DELINQ-CD                         
PRJ821           AND COMPANY_NO = :C8-COMPANY-NO                        
PRJ821                                                           
PRJ821     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD  = :C8-DELINQ-CD                                 
MFA-TR*          AND COMPANY_NO = :C8-COMPANY-NO                                
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PRJ821                                                                  
PRJ821     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
PRJ821                                                                  
PRJ821     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
PRJ821        MOVE C8-DELINQ-VALUE            TO WS-DATABASE            
PRJ821     ELSE                                                         
PRJ821        MOVE '7910'                     TO ACTIVE-PARAGRAPH       
PRJ821        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
PRJ821        MOVE 'SELECT'                   TO ABEND-FUNCTION         
PRJ821        MOVE 'CSS_DELINQUENCY'          TO TABLE-1                
PRJ821        MOVE 'DELINQ_CD'                TO TABLE-ELEMENT-1        
PRJ821        MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-2        
PRJ821        MOVE C8-DELINQ-CD               TO HOSTVAR-ELEMENT-1      
PRJ821        MOVE C8-COMPANY-NO              TO HOSTVAR-ELEMENT-2      
PRJ821        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
PRJ821        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
PRJ821     END-IF.                                                      
PRJ821                                                                  
PRJ821 7910-EXIT.                                                       
PRJ821     EXIT.                                                        
PRJ821*                                                                         
PRJ821 7920-GET-OPTION-DESC.                                            
PRJ821                                                                  
PRJ821     EXEC SQL                                                     
PRJ821        SELECT FI.OPT_DESC_INT                                    
PRJ821              ,FI.OPTION_CD                                       
PRJ821          INTO :FI-OPT-DESC-INT                                   
PRJ821              ,:FI-OPTION-CD                                      
PRJ821          FROM CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)                 
PRJ821              ,CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)                 
PRJ821         WHERE DF.ACCOUNT_NO         = :DF-ACCOUNT-NO             
PRJ821           AND DF.CODE_UTIL_TYPE     = :DF-CODE-UTIL-TYPE         
PRJ821           AND DF.IC_NO              = :DF-IC-NO                  
PRJ821           AND DF.RT_PKG_OPT_SEQ_NO  = :DF-RT-PKG-OPT-SEQ-NO      
PRJ821           AND DF.OPTION_CD          = FI.OPTION_CD               
PRJ821           AND FI.OPT_VSTART_TS     <= CIS.CURRENT$TIMESTAMP()          
PRJ821           AND FI.OPT_VEND_TS       >= CIS.CURRENT$TIMESTAMP()          
PRJ821           AND FI.PROC_STATUS_CD     = 'AC'                       
PRJ821                                                           
PRJ821     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT FI.OPT_DESC_INT                                            
MFA-TR*             ,FI.OPTION_CD                                               
MFA-TR*         INTO :FI-OPT-DESC-INT                                           
MFA-TR*             ,:FI-OPTION-CD                                              
MFA-TR*         FROM CSS_ACCT_RTPK_AGR DF                                       
MFA-TR*             ,CRM_RT_PKG_OPTION FI                                       
MFA-TR*        WHERE DF.ACCOUNT_NO         = :DF-ACCOUNT-NO                     
MFA-TR*          AND DF.CODE_UTIL_TYPE     = :DF-CODE-UTIL-TYPE                 
MFA-TR*          AND DF.IC_NO              = :DF-IC-NO                          
MFA-TR*          AND DF.RT_PKG_OPT_SEQ_NO  = :DF-RT-PKG-OPT-SEQ-NO              
MFA-TR*          AND DF.OPTION_CD          = FI.OPTION_CD                       
MFA-TR*          AND FI.OPT_VSTART_TS     <= CURRENT TIMESTAMP                  
MFA-TR*          AND FI.OPT_VEND_TS       >= CURRENT TIMESTAMP                  
MFA-TR*          AND FI.PROC_STATUS_CD     = 'AC'                               
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PRJ821                                                                  
PRJ821     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
PRJ821                                                                  
PRJ821     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
PRJ821        NEXT SENTENCE                                             
PRJ821     ELSE                                                         
PRJ821        MOVE '7920'                     TO ACTIVE-PARAGRAPH       
PRJ821        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
PRJ821        MOVE 'SELECT'                   TO ABEND-FUNCTION         
PRJ821        MOVE 'CSS_ACCT_RTPK_AGR'        TO TABLE-1                
PRJ821        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
PRJ821        MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
PRJ821        MOVE 'IC_NO'                    TO TABLE-ELEMENT-3        
PRJ821        MOVE 'RT_PKG_OPT_SEQ_NO'        TO TABLE-ELEMENT-4        
PRJ821        MOVE DF-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
PRJ821        MOVE DF-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2      
PRJ821        MOVE DF-IC-NO                   TO HOSTVAR-ELEMENT-3      
PRJ821        MOVE DF-RT-PKG-OPT-SEQ-NO       TO HOSTVAR-ELEMENT-4      
PRJ821        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
PRJ821        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
PRJ821     END-IF.                                                      
PRJ821                                                                  
PRJ821 7920-EXIT.                                                       
PRJ821     EXIT.                                                        
PRJ821***************************************************************           
PRJ821* 7930-GET-RATE-DESC                                          *           
PRJ821*                                                             *           
PRJ821***************************************************************           
PRJ821 7930-GET-RATE-DESC.                                              
PRJ821                                                                  
PRJ821     EXEC SQL                                                     
PRJ821        SELECT RD.RATE_DESC                                       
PRJ821          INTO :RD-RATE-DESC                                      
PRJ821          FROM CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED)                
PRJ821         WHERE RD.RATE_PLAN_NO = :RD-RATE-PLAN-NO                 
PRJ821          AND  RD.CODE_UTIL_TYPE = :RD-CODE-UTIL-TYPE             
PRJ821                                                           
PRJ821                                                      
PRJ821     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RD.RATE_DESC                                               
MFA-TR*         INTO :RD-RATE-DESC                                              
MFA-TR*         FROM CSS_RATE_PLAN_DESC RD                                      
MFA-TR*        WHERE RD.RATE_PLAN_NO = :RD-RATE-PLAN-NO                         
MFA-TR*         AND  RD.CODE_UTIL_TYPE = :RD-CODE-UTIL-TYPE                     
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7930                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PRJ821                                                                  
PRJ821     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
PRJ821                                                                  
PRJ821     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
PRJ821        NEXT SENTENCE                                             
PRJ821     ELSE                                                         
PRJ821        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
PRJ821        MOVE '7930'                    TO ACTIVE-PARAGRAPH        
PRJ821        MOVE 'SELECT'                  TO ABEND-FUNCTION          
PRJ821        MOVE SPACES                    TO ABEND-SQL-PREDICATES    
PRJ821                                          ABEND-TABLES            
PRJ821        MOVE 'CSS_RATE_PLAN_DESC'      TO TABLE-1                 
PRJ821        MOVE 'RATE_DESC'               TO TABLE-ELEMENT-3         
PRJ821        MOVE RD-RATE-DESC              TO HOSTVAR-ELEMENT-3       
PRJ821        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
PRJ821        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
PRJ821     END-IF.                                                      
PRJ821                                                                  
PRJ821 7930-EXIT.                                                       
PRJ821     EXIT.                                                        
P00836*                                                                         
P00836******************************************************************        
P00836** CHECK DATA EXISTS FOR LATEST BILL IN BILL CRED TABLE         **        
P00836******************************************************************        
P00836*                                                                         
P00836 7950-CHECK-BILL-CRED-DATA.                                       
P00836*                                                                         
P00836     EXEC SQL                                                     
P00836          SELECT TOP(1) [1H].ACCOUNT_NO                                   
P00836            INTO :1H-ACCOUNT-NO                                   
P00836            FROM  CSS_BILL_CRED_DET [1H] WITH(READUNCOMMITTED)            
P00836           WHERE  [1H].ACCOUNT_NO = :S1-ACCOUNT-NO                  
P00836             AND  [1H].BILL_NO    = :S1-BILL-NO                     
P00836                                       
P00836                                                      
P00836     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT  1H.ACCOUNT_NO                                           
MFA-TR*           INTO :1H-ACCOUNT-NO                                           
MFA-TR*           FROM  CSS_BILL_CRED_DET 1H                                    
MFA-TR*          WHERE  1H.ACCOUNT_NO = :S1-ACCOUNT-NO                          
MFA-TR*            AND  1H.BILL_NO    = :S1-BILL-NO                             
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*         QUERYNO 7950                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00836*                                                                         
P00836     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
P00836*                                                                         
P00836     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
P00836        CONTINUE                                                  
P00836     ELSE                                                         
P00836        MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
P00836        MOVE '7950'                   TO ACTIVE-PARAGRAPH         
P00836        MOVE 'SELECT'                 TO ABEND-FUNCTION           
P00836        MOVE SPACES                   TO ABEND-SQL-PREDICATES     
P00836                                         ABEND-TABLES             
P00836        MOVE 'CSS_BILL_CRED_DET'      TO TABLE-1                  
P00836        MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
P00836        MOVE S1-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
P00836        MOVE 'BILL_NO'                TO TABLE-ELEMENT-2          
P00836        MOVE S1-BILL-NO               TO HOSTVAR-ELEMENT-2        
P00836        PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
P00836        PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
P00836     END-IF.                                                      
P00836*                                                                         
P00836 7950-EXIT.                                                       
P00836     EXIT.                                                        
P00836*                                                                         
      ******************************************************************        
      * 8000A-DELETE-GTT-ROWS.                                         *        
      *                                                                *        
      ******************************************************************        
       8000A-DELETE-GTT-ROWS.                                           
                                                                        
            EXEC SQL                                                    
                DELETE FROM #CSR04622_R1                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR04622_R1                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE       
                                            S1-RETURN-CODE.             
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
                CONTINUE                                                
            ELSE                                                        
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8000A'              TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04622_R1'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8000B-DELETE-GTT-ROWS.                                         *        
      *                                                                *        
      ******************************************************************        
       8000B-DELETE-GTT-ROWS.                                           
                                                                        
            EXEC SQL                                                    
                DELETE FROM #CSR04622_R2                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR04622_R2                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE       
                                            S2-RETURN-CODE.             
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
                CONTINUE                                                
            ELSE                                                        
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8000B'              TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04622_R2'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8000B-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8000C-DELETE-GTT-ROWS.                                         *        
      *                                                                *        
      ******************************************************************        
       8000C-DELETE-GTT-ROWS.                                           
                                                                        
            EXEC SQL                                                    
                DELETE FROM #CSR04622_R3                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR04622_R3                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE       
                                            S3-RETURN-CODE.             
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
                CONTINUE                                                
            ELSE                                                        
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8000C'              TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04622_R3'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8000C-EXIT.                                                      
           EXIT.                                                        
                                                                        
P00836******************************************************************        
P00836* 8000D-DELETE-GTT-ROWS.                                         *        
P00836*                                                                *        
P00836******************************************************************        
P00836 8000D-DELETE-GTT-ROWS.                                           
P00836                                                                  
P00836      EXEC SQL                                                    
P00836          DELETE FROM #CSR04622_R4                         
P00836      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR04622_R4                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00836                                                                  
P00836      MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE       
P00836                                      S1-RETURN-CODE.             
P00836                                                                  
P00836      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
P00836          CONTINUE                                                
P00836      ELSE                                                        
P00836         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
P00836         MOVE SQLCODE              TO ABEND-SQLCODE               
P00836         MOVE SQLSTATE             TO ABEND-SQLSTATE              
P00836         MOVE '8000D'              TO ACTIVE-PARAGRAPH            
P00836         MOVE 'DELETE'             TO ABEND-FUNCTION              
P00836         MOVE SPACES               TO ABEND-SQL-PREDICATES        
P00836                                      ABEND-TABLES                
P00836         MOVE 'CSR04622_R4'        TO TABLE-1                     
P00836         MOVE SPACES               TO TABLE-ELEMENT-1             
P00836         MOVE SPACES               TO HOSTVAR-ELEMENT-1           
P00836         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
P00836         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
P00836     END-IF.                                                      
P00836                                                                  
P00836 8000D-EXIT.                                                      
P00836     EXIT.                                                        
P00836                                                                  
      *****************************************************************         
      * 8010-INSERT-GTT-R1.                                           *         
      *                                                               *         
      *****************************************************************         
       8010-INSERT-GTT-R1.                                              
           EXEC SQL                                                     
             INSERT INTO #CSR04622_R1                            
             (                                                          
              RETURN_CODE                                               
             ,APPL_RETURN_CODE                                          
             ,ACCOUNT_NO                                                
             ,AMT_BILL_ITEM                                             
             ,UTILITY_USG_AMT                                           
             ,AVG_COST_PER_USG                                          
             ,RATE_PLAN_NO                                              
             ,BTU_FACTOR                                                
             ,DATE_READ                                                 
             ,PER_DAY_USE                                               
             ,NO_DAYS                                                   
             ,ESTIMATE_ADJUSTED                                         
             ,CONSTANT                                                  
             ,THERMS                                                    
             ,UNITS                                                     
             ,CNSMPTN_TYPE                                              
             ,ACTUAL_ONPEAK                                             
             ,BILLED_ONPEAK                                             
             ,ONPEAK_DIFF                                               
             ,ACTUAL_OFFPEAK                                            
             ,BILLED_OFFPEAK                                            
             ,OFFPEAK_DIFF                                              
             ,ACTUAL_SHLDR                                              
             ,BILLED_SHLDR                                              
             ,SHLDR_DIFF                                                
             ,COMBINED_READING                                          
             ,BILL_NO                                                   
             ,BILL_ITEM_TMSTMP                                          
             ,WNA_AMOUNT                                                
             ,SAME_ACCOUNT                                              
             ,EMPLOYEE_NO                                               
             ,CODE_SOURCE_ID                                            
             ,DEGREE_DAYS                                               
             ,RATIO                                                     
             ,COMPANY_NO                                                
             ,INDUS_GAS_RATE                                            
             ,WNA_FACTOR                                                
             ,METER_READING                                             
             ,REVENUE_MONTH                                             
             ,REV_MTH_ORIG_BILL                                         
             ,CNCLD_FLG                                                 
PRJ821       ,RATE_PLAN_DESC                                            
PRJ821       ,OPTION_CD                                                 
PRJ821       ,OPTION_DESC                                               
P00836       ,DATE_BILLED                                               
             )                                                          
             VALUES                                                     
             (                                                          
              :S1-RETURN-CODE                                           
             ,:S1-APPL-RETURN-CODE                                      
             ,:S1-ACCOUNT-NO                                            
             ,:S1-AMT-BILL-ITEM                                         
             ,:S1-UTILITY-USG-AMT                                       
             ,:S1-AVG-COST-PER-USG                                      
             ,:S1-RATE-PLAN-NO                                          
             ,:S1-BTU-FACTOR                                            
             ,:S1-DATE-READ                                             
             ,:S1-PER-DAY-USE                                           
             ,:S1-NO-DAYS                                               
             ,:S1-ESTIMATE-ADJUSTED                                     
             ,:S1-CONSTANT                                              
             ,:S1-THERMS                                                
             ,:S1-UNITS                                                 
             ,:S1-CNSMPTN-TYPE                                          
             ,:S1-ACTUAL-ONPEAK                                         
             ,:S1-BILLED-ONPEAK                                         
             ,:S1-ONPEAK-DIFF                                           
             ,:S1-ACTUAL-OFFPEAK                                        
             ,:S1-BILLED-OFFPEAK                                        
             ,:S1-OFFPEAK-DIFF                                          
             ,:S1-ACTUAL-SHLDR                                          
             ,:S1-BILLED-SHLDR                                          
             ,:S1-SHLDR-DIFF                                            
             ,:S1-COMBINED-READING                                      
             ,:S1-BILL-NO                                               
             ,:S1-BILL-ITEM-TMSTMP                                      
             ,:S1-WNA-AMOUNT                                            
             ,:S1-SAME-ACCOUNT                                          
             ,:S1-EMPLOYEE-NO                                           
             ,:S1-CODE-SOURCE-ID                                        
             ,:S1-DEGREE-DAYS                                           
             ,:S1-RATIO                                                 
             ,:S1-COMPANY-NO                                            
             ,:S1-INDUS-GAS-RATE                                        
             ,:S1-WNA-FACTOR                                            
             ,:S1-METER-READING                                         
             ,:S1-REVENUE-MONTH                                         
             ,:S1-REV-MTH-ORIG-BILL                                     
             ,:S1-CNCLD-FLG                                             
PRJ821       ,:S1-RATE-PLAN-DESC                                        
PRJ821       ,:S1-OPTION-CD                                             
PRJ821       ,:S1-OPTION-DESC                                           
P00836       ,:S1-DATE-BILLED                                           
             )                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04622_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,APPL_RETURN_CODE                                                  
MFA-TR*      ,ACCOUNT_NO                                                        
MFA-TR*      ,AMT_BILL_ITEM                                                     
MFA-TR*      ,UTILITY_USG_AMT                                                   
MFA-TR*      ,AVG_COST_PER_USG                                                  
MFA-TR*      ,RATE_PLAN_NO                                                      
MFA-TR*      ,BTU_FACTOR                                                        
MFA-TR*      ,DATE_READ                                                         
MFA-TR*      ,PER_DAY_USE                                                       
MFA-TR*      ,NO_DAYS                                                           
MFA-TR*      ,ESTIMATE_ADJUSTED                                                 
MFA-TR*      ,CONSTANT                                                          
MFA-TR*      ,THERMS                                                            
MFA-TR*      ,UNITS                                                             
MFA-TR*      ,CNSMPTN_TYPE                                                      
MFA-TR*      ,ACTUAL_ONPEAK                                                     
MFA-TR*      ,BILLED_ONPEAK                                                     
MFA-TR*      ,ONPEAK_DIFF                                                       
MFA-TR*      ,ACTUAL_OFFPEAK                                                    
MFA-TR*      ,BILLED_OFFPEAK                                                    
MFA-TR*      ,OFFPEAK_DIFF                                                      
MFA-TR*      ,ACTUAL_SHLDR                                                      
MFA-TR*      ,BILLED_SHLDR                                                      
MFA-TR*      ,SHLDR_DIFF                                                        
MFA-TR*      ,COMBINED_READING                                                  
MFA-TR*      ,BILL_NO                                                           
MFA-TR*      ,BILL_ITEM_TMSTMP                                                  
MFA-TR*      ,WNA_AMOUNT                                                        
MFA-TR*      ,SAME_ACCOUNT                                                      
MFA-TR*      ,EMPLOYEE_NO                                                       
MFA-TR*      ,CODE_SOURCE_ID                                                    
MFA-TR*      ,DEGREE_DAYS                                                       
MFA-TR*      ,RATIO                                                             
MFA-TR*      ,COMPANY_NO                                                        
MFA-TR*      ,INDUS_GAS_RATE                                                    
MFA-TR*      ,WNA_FACTOR                                                        
MFA-TR*      ,METER_READING                                                     
MFA-TR*      ,REVENUE_MONTH                                                     
MFA-TR*      ,REV_MTH_ORIG_BILL                                                 
MFA-TR*      ,CNCLD_FLG                                                         
MFA-TR*      ,RATE_PLAN_DESC                                                    
MFA-TR*      ,OPTION_CD                                                         
MFA-TR*      ,OPTION_DESC                                                       
MFA-TR*      ,DATE_BILLED                                                       
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S1-RETURN-CODE                                                   
MFA-TR*      ,:S1-APPL-RETURN-CODE                                              
MFA-TR*      ,:S1-ACCOUNT-NO                                                    
MFA-TR*      ,:S1-AMT-BILL-ITEM                                                 
MFA-TR*      ,:S1-UTILITY-USG-AMT                                               
MFA-TR*      ,:S1-AVG-COST-PER-USG                                              
MFA-TR*      ,:S1-RATE-PLAN-NO                                                  
MFA-TR*      ,:S1-BTU-FACTOR                                                    
MFA-TR*      ,:S1-DATE-READ                                                     
MFA-TR*      ,:S1-PER-DAY-USE                                                   
MFA-TR*      ,:S1-NO-DAYS                                                       
MFA-TR*      ,:S1-ESTIMATE-ADJUSTED                                             
MFA-TR*      ,:S1-CONSTANT                                                      
MFA-TR*      ,:S1-THERMS                                                        
MFA-TR*      ,:S1-UNITS                                                         
MFA-TR*      ,:S1-CNSMPTN-TYPE                                                  
MFA-TR*      ,:S1-ACTUAL-ONPEAK                                                 
MFA-TR*      ,:S1-BILLED-ONPEAK                                                 
MFA-TR*      ,:S1-ONPEAK-DIFF                                                   
MFA-TR*      ,:S1-ACTUAL-OFFPEAK                                                
MFA-TR*      ,:S1-BILLED-OFFPEAK                                                
MFA-TR*      ,:S1-OFFPEAK-DIFF                                                  
MFA-TR*      ,:S1-ACTUAL-SHLDR                                                  
MFA-TR*      ,:S1-BILLED-SHLDR                                                  
MFA-TR*      ,:S1-SHLDR-DIFF                                                    
MFA-TR*      ,:S1-COMBINED-READING                                              
MFA-TR*      ,:S1-BILL-NO                                                       
MFA-TR*      ,:S1-BILL-ITEM-TMSTMP                                              
MFA-TR*      ,:S1-WNA-AMOUNT                                                    
MFA-TR*      ,:S1-SAME-ACCOUNT                                                  
MFA-TR*      ,:S1-EMPLOYEE-NO                                                   
MFA-TR*      ,:S1-CODE-SOURCE-ID                                                
MFA-TR*      ,:S1-DEGREE-DAYS                                                   
MFA-TR*      ,:S1-RATIO                                                         
MFA-TR*      ,:S1-COMPANY-NO                                                    
MFA-TR*      ,:S1-INDUS-GAS-RATE                                                
MFA-TR*      ,:S1-WNA-FACTOR                                                    
MFA-TR*      ,:S1-METER-READING                                                 
MFA-TR*      ,:S1-REVENUE-MONTH                                                 
MFA-TR*      ,:S1-REV-MTH-ORIG-BILL                                             
MFA-TR*      ,:S1-CNCLD-FLG                                                     
MFA-TR*      ,:S1-RATE-PLAN-DESC                                                
MFA-TR*      ,:S1-OPTION-CD                                                     
MFA-TR*      ,:S1-OPTION-DESC                                                   
MFA-TR*      ,:S1-DATE-BILLED                                                   
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S1-RETURN-CODE.          
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              ADD 1                         TO CTR-ROWS-RS1             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE '8010'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE 'CSR04622_R1'            TO TABLE-1                  
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8010-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *****************************************************************         
      * 8020-INSERT-GTT-R2                                            *         
      *                                                               *         
      *****************************************************************         
       8020-INSERT-GTT-R2.                                              
           EXEC SQL                                                     
             INSERT INTO #CSR04622_R2                            
             (                                                          
              RETURN_CODE                                               
             ,APPL_RETURN_CODE                                          
             ,ACCOUNT_NO                                                
             ,CODE_UTIL_TYPE                                            
             ,IC_NO                                                     
             ,METER_NO                                                  
             ,METER_REF_NO                                              
             ,EVENT_DESC                                                
             ,EVENT_STATUS                                              
             ,COMPLETED_DATE                                            
             )                                                          
             VALUES                                                     
             (                                                          
              :S2-RETURN-CODE                                           
             ,:S2-APPL-RETURN-CODE                                      
             ,:S2-ACCOUNT-NO                                            
             ,:S2-CODE-UTIL-TYPE                                        
             ,:S2-IC-NO                                                 
             ,:S2-METER-NO                                              
             ,:S2-METER-REF-NO                                          
             ,:S2-EVENT-DESC                                            
             ,:S2-EVENT-STATUS                                          
             ,:S2-COMPLETED-DATE                                        
             )                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04622_R2                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,APPL_RETURN_CODE                                                  
MFA-TR*      ,ACCOUNT_NO                                                        
MFA-TR*      ,CODE_UTIL_TYPE                                                    
MFA-TR*      ,IC_NO                                                             
MFA-TR*      ,METER_NO                                                          
MFA-TR*      ,METER_REF_NO                                                      
MFA-TR*      ,EVENT_DESC                                                        
MFA-TR*      ,EVENT_STATUS                                                      
MFA-TR*      ,COMPLETED_DATE                                                    
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S2-RETURN-CODE                                                   
MFA-TR*      ,:S2-APPL-RETURN-CODE                                              
MFA-TR*      ,:S2-ACCOUNT-NO                                                    
MFA-TR*      ,:S2-CODE-UTIL-TYPE                                                
MFA-TR*      ,:S2-IC-NO                                                         
MFA-TR*      ,:S2-METER-NO                                                      
MFA-TR*      ,:S2-METER-REF-NO                                                  
MFA-TR*      ,:S2-EVENT-DESC                                                    
MFA-TR*      ,:S2-EVENT-STATUS                                                  
MFA-TR*      ,:S2-COMPLETED-DATE                                                
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S2-RETURN-CODE.          
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              ADD 1                         TO CTR-ROWS-RS2             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE '8020'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE 'CSR04622_R2'            TO TABLE-1                  
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8020-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *****************************************************************         
      * 8030-INSERT-GTT-R3                                            *         
      *                                                               *         
      *****************************************************************         
       8030-INSERT-GTT-R3.                                              
           EXEC SQL                                                     
             INSERT INTO #CSR04622_R3                            
             (                                                          
              RETURN_CODE                                               
             ,APPL_RETURN_CODE                                          
             ,ADDTNAL_USAGE_EXISTS                                      
             )                                                          
             VALUES                                                     
             (                                                          
              :S3-RETURN-CODE                                           
             ,:S3-APPL-RETURN-CODE                                      
             ,:S3-ADDTNAL-USAGE-EXISTS                                  
             )                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04622_R3                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,APPL_RETURN_CODE                                                  
MFA-TR*      ,ADDTNAL_USAGE_EXISTS                                              
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S3-RETURN-CODE                                                   
MFA-TR*      ,:S3-APPL-RETURN-CODE                                              
MFA-TR*      ,:S3-ADDTNAL-USAGE-EXISTS                                          
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S3-RETURN-CODE.          
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              ADD 1                         TO CTR-ROWS-RS3             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE '8030'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE 'CSR04622_R3'            TO TABLE-1                  
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8030-EXIT.                                                       
            EXIT.                                                       
                                                                        
P00836*****************************************************************         
P00836** 8040-INSERT-GTT-R4                                          **         
P00836*****************************************************************         
P00836*                                                                         
P00836 8040-INSERT-GTT-R4.                                              
P00836*                                                                         
P00836     EXEC SQL                                                     
P00836       INSERT INTO #CSR04622_R4                            
P00836       (                                                          
P00836        RETURN_CODE                                               
P00836       ,APPL_RETURN_CODE                                          
P00836       ,ACCOUNT_NO                                                
P00836       ,DATE_BILLED                                               
P00836       ,DATE_READ                                                 
P00836       ,REVENUE_MONTH                                             
P00836       ,NO_DAYS                                                   
P00836       ,THERMS                                                    
P00836       ,UNITS                                                     
P00836       ,CNSMPTN_TYPE                                              
P00836       ,AMT_BILL_ITEM                                             
P00836       ,UTILITY_USG_AMT                                           
P00836       ,PER_DAY_USE                                               
P00836       ,RATE_PLAN_NO                                              
P00836       ,RATE_PLAN_DESC                                            
P00836       ,OPTION_CD                                                 
P00836       ,OPTION_DESC                                               
P00836       ,COMPANY_NO                                                
P00836       ,CODE_BILL_CALC                                            
P00836       ,CODE_BILL_ITM_TYPE                                        
P00836       ,CODE_BILL_ITM_IND                                         
P00836       ,CODE_BILL_TYPE                                            
P00836       )                                                          
P00836       VALUES                                                     
P00836       (                                                          
P00836        :S1-RETURN-CODE                                           
P00836       ,:S1-APPL-RETURN-CODE                                      
P00836       ,:S1-ACCOUNT-NO                                            
P00836       ,:S1-DATE-BILLED                                           
P00836       ,:S1-DATE-READ                                             
P00836       ,:S1-REVENUE-MONTH                                         
P00836       ,:S1-NO-DAYS                                               
P00836       ,:S1-THERMS                                                
P00836       ,:S1-UNITS                                                 
P00836       ,:S1-CNSMPTN-TYPE                                          
P00836       ,:S1-AMT-BILL-ITEM                                         
P00836       ,:S1-UTILITY-USG-AMT                                       
P00836       ,:S1-PER-DAY-USE                                           
P00836       ,:S1-RATE-PLAN-NO                                          
P00836       ,:S1-RATE-PLAN-DESC                                        
P00836       ,:S1-OPTION-CD                                             
P00836       ,:S1-OPTION-DESC                                           
P00836       ,:S1-COMPANY-NO                                            
P00836       ,:S1-CODE-BILL-CALC                                        
P00836       ,:S1-CODE-BILL-ITM-TYPE                                    
P00836       ,:S1-CODE-BILL-ITM-IND                                     
P00836       ,:S1-CODE-BILL-TYPE                                        
P00836       )                                                          
P00836     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04622_R4                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,APPL_RETURN_CODE                                                  
MFA-TR*      ,ACCOUNT_NO                                                        
MFA-TR*      ,DATE_BILLED                                                       
MFA-TR*      ,DATE_READ                                                         
MFA-TR*      ,REVENUE_MONTH                                                     
MFA-TR*      ,NO_DAYS                                                           
MFA-TR*      ,THERMS                                                            
MFA-TR*      ,UNITS                                                             
MFA-TR*      ,CNSMPTN_TYPE                                                      
MFA-TR*      ,AMT_BILL_ITEM                                                     
MFA-TR*      ,UTILITY_USG_AMT                                                   
MFA-TR*      ,PER_DAY_USE                                                       
MFA-TR*      ,RATE_PLAN_NO                                                      
MFA-TR*      ,RATE_PLAN_DESC                                                    
MFA-TR*      ,OPTION_CD                                                         
MFA-TR*      ,OPTION_DESC                                                       
MFA-TR*      ,COMPANY_NO                                                        
MFA-TR*      ,CODE_BILL_CALC                                                    
MFA-TR*      ,CODE_BILL_ITM_TYPE                                                
MFA-TR*      ,CODE_BILL_ITM_IND                                                 
MFA-TR*      ,CODE_BILL_TYPE                                                    
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S1-RETURN-CODE                                                   
MFA-TR*      ,:S1-APPL-RETURN-CODE                                              
MFA-TR*      ,:S1-ACCOUNT-NO                                                    
MFA-TR*      ,:S1-DATE-BILLED                                                   
MFA-TR*      ,:S1-DATE-READ                                                     
MFA-TR*      ,:S1-REVENUE-MONTH                                                 
MFA-TR*      ,:S1-NO-DAYS                                                       
MFA-TR*      ,:S1-THERMS                                                        
MFA-TR*      ,:S1-UNITS                                                         
MFA-TR*      ,:S1-CNSMPTN-TYPE                                                  
MFA-TR*      ,:S1-AMT-BILL-ITEM                                                 
MFA-TR*      ,:S1-UTILITY-USG-AMT                                               
MFA-TR*      ,:S1-PER-DAY-USE                                                   
MFA-TR*      ,:S1-RATE-PLAN-NO                                                  
MFA-TR*      ,:S1-RATE-PLAN-DESC                                                
MFA-TR*      ,:S1-OPTION-CD                                                     
MFA-TR*      ,:S1-OPTION-DESC                                                   
MFA-TR*      ,:S1-COMPANY-NO                                                    
MFA-TR*      ,:S1-CODE-BILL-CALC                                                
MFA-TR*      ,:S1-CODE-BILL-ITM-TYPE                                            
MFA-TR*      ,:S1-CODE-BILL-ITM-IND                                             
MFA-TR*      ,:S1-CODE-BILL-TYPE                                                
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00836*                                                                         
P00836     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
P00836*                                                                         
P00836     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00836        ADD 1                         TO CTR-ROWS-RS4             
P00836     ELSE                                                         
P00836        MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
P00836        MOVE SQLCODE                  TO ABEND-SQLCODE            
P00836        MOVE SQLSTATE                 TO ABEND-SQLSTATE           
P00836        MOVE '8040'                   TO ACTIVE-PARAGRAPH         
P00836        MOVE 'INSERT'                 TO ABEND-FUNCTION           
P00836        MOVE 'CSR04622_R4'            TO TABLE-1                  
P00836        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
P00836        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
P00836     END-IF.                                                      
P00836*                                                                         
P00836 8040-EXIT.                                                       
P00836      EXIT.                                                       
P00836*                                                                         
P00836******************************************************************        
P00836** DELETE CANCEL ROWS IF CORRECT BILL ROW EXISTS                **        
P00836******************************************************************        
P00836*                                                                         
P00836 8100-DELETE-CANCEL-ROWS-R4.                                      
P00836*                                                                         
P00836      EXEC SQL                                                    
P00836          DELETE                                                  
P00836            FROM T1                            
                FROM #CSR04622_R4 T1
P00836           WHERE T1.CODE_BILL_CALC     = 'A'                      
P00836             AND T1.CODE_BILL_ITM_TYPE = 'C'                      
P00836             AND T1.CODE_BILL_ITM_IND  = 'K'                      
P00836             AND EXISTS                                           
P00836                (SELECT 1                                         
P00836                   FROM #CSR04622_R4 T2                    
P00836                  WHERE T2.REVENUE_MONTH      = T1.REVENUE_MONTH  
P00836                    AND T2.CODE_BILL_CALC     = 'A'               
P00836                    AND T2.CODE_BILL_ITM_TYPE = 'C'               
P00836                    AND T2.CODE_BILL_ITM_IND  = 'A')              
P00836      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE                                                          
MFA-TR*           FROM SESSION.CSR04622_R4  T1                                  
MFA-TR*          WHERE T1.CODE_BILL_CALC     = 'A'                              
MFA-TR*            AND T1.CODE_BILL_ITM_TYPE = 'C'                              
MFA-TR*            AND T1.CODE_BILL_ITM_IND  = 'K'                              
MFA-TR*            AND EXISTS                                                   
MFA-TR*               (SELECT 1                                                 
MFA-TR*                  FROM SESSION.CSR04622_R4 T2                            
MFA-TR*                 WHERE T2.REVENUE_MONTH      = T1.REVENUE_MONTH          
MFA-TR*                   AND T2.CODE_BILL_CALC     = 'A'                       
MFA-TR*                   AND T2.CODE_BILL_ITM_TYPE = 'C'                       
MFA-TR*                   AND T2.CODE_BILL_ITM_IND  = 'A')                      
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00836*                                                                         
P00836      MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.      
P00836*                                                                         
P00836      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
P00836          CONTINUE                                                
P00836      ELSE                                                        
P00836         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
P00836         MOVE SQLCODE              TO ABEND-SQLCODE               
P00836         MOVE SQLSTATE             TO ABEND-SQLSTATE              
P00836         MOVE '8100'               TO ACTIVE-PARAGRAPH            
P00836         MOVE 'DELETE'             TO ABEND-FUNCTION              
P00836         MOVE SPACES               TO ABEND-SQL-PREDICATES        
P00836                                      ABEND-TABLES                
P00836         MOVE 'CSR04622_R4'        TO TABLE-1                     
P00836         MOVE SPACES               TO TABLE-ELEMENT-1             
P00836         MOVE SPACES               TO HOSTVAR-ELEMENT-1           
P00836         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
P00836         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
P00836     END-IF.                                                      
P00836                                                                  
P00836 8100-EXIT.                                                       
P00836     EXIT.                                                        
P00836                                                                  
P00836*****************************************************************         
P00836** INSERT RESULT SET DATA                                      **         
P00836*****************************************************************         
P00836*                                                                         
P00836 8200-INSERT-GTT-RESULT.                                          
P00836*                                                                         
P00836     EXEC SQL                                                     
P00836       INSERT INTO #CSR04622_R1                            
P00836       (                                                          
P00836        RETURN_CODE                                               
P00836       ,APPL_RETURN_CODE                                          
P00836       ,ACCOUNT_NO                                                
P00836       ,AMT_BILL_ITEM                                             
P00836       ,UTILITY_USG_AMT                                           
P00836       ,AVG_COST_PER_USG                                          
P00836       ,RATE_PLAN_NO                                              
P00836       ,BTU_FACTOR                                                
P00836       ,DATE_READ                                                 
P00836       ,PER_DAY_USE                                               
P00836       ,NO_DAYS                                                   
P00836       ,ESTIMATE_ADJUSTED                                         
P00836       ,CONSTANT                                                  
P00836       ,THERMS                                                    
P00836       ,UNITS                                                     
P00836       ,CNSMPTN_TYPE                                              
P00836       ,ACTUAL_ONPEAK                                             
P00836       ,BILLED_ONPEAK                                             
P00836       ,ONPEAK_DIFF                                               
P00836       ,ACTUAL_OFFPEAK                                            
P00836       ,BILLED_OFFPEAK                                            
P00836       ,OFFPEAK_DIFF                                              
P00836       ,ACTUAL_SHLDR                                              
P00836       ,BILLED_SHLDR                                              
P00836       ,SHLDR_DIFF                                                
P00836       ,COMBINED_READING                                          
P00836       ,BILL_NO                                                   
P00836       ,BILL_ITEM_TMSTMP                                          
P00836       ,WNA_AMOUNT                                                
P00836       ,SAME_ACCOUNT                                              
P00836       ,EMPLOYEE_NO                                               
P00836       ,CODE_SOURCE_ID                                            
P00836       ,DEGREE_DAYS                                               
P00836       ,RATIO                                                     
P00836       ,COMPANY_NO                                                
P00836       ,INDUS_GAS_RATE                                            
P00836       ,WNA_FACTOR                                                
P00836       ,METER_READING                                             
P00836       ,REVENUE_MONTH                                             
P00836       ,REV_MTH_ORIG_BILL                                         
P00836       ,CNCLD_FLG                                                 
P00836       ,RATE_PLAN_DESC                                            
P00836       ,OPTION_CD                                                 
P00836       ,OPTION_DESC                                               
P00836       ,DATE_BILLED                                               
P00836       )                                                          
P00836       SELECT TOP(100) RETURN_CODE,
              APPL_RETURN_CODE,
              ACCOUNT_NO,
              SUM(AMT_BILL_ITEM),
              SUM(UTILITY_USG_AMT),
              CASE WHEN (:PARM-CODE-UTIL-TYPE = 'E'              
P00836                     AND   SUM(UNITS)  <> 0)                      
P00836                    THEN   SUM(UTILITY_USG_AMT)/SUM(UNITS)        
P00836                    WHEN (:PARM-CODE-UTIL-TYPE = 'G'              
P00836                     AND   SUM(THERMS) <> 0)                      
P00836                    THEN   SUM(UTILITY_USG_AMT)/SUM(THERMS)       
P00836               ELSE 0 END,
              RATE_PLAN_NO,
              0,
              MAX(DATE_READ),
              SUM(PER_DAY_USE),
              SUM(NO_DAYS),
              ' ',
              0,
              SUM(THERMS),
              SUM(UNITS),
              MAX(CNSMPTN_TYPE),
              0,
              0,
              0,
              0,
              0,
              0,
              0,
              0,
              0,
              ' ',
              0,
              ' ',
              0,
              ' ',
              0,
              ' ',
              0,
              0,
              COMPANY_NO,
              ' ',
              0,
              0,
              REVENUE_MONTH,
              0,
              ' ',
              RATE_PLAN_DESC,
              OPTION_CD,
              OPTION_DESC,
              MAX(DATE_BILLED)                                   
P00836         FROM  #CSR04622_R4                                
P00836        GROUP BY RETURN_CODE, APPL_RETURN_CODE, ACCOUNT_NO,       
P00836          RATE_PLAN_NO, COMPANY_NO, REVENUE_MONTH,                
P00836          CODE_BILL_TYPE, RATE_PLAN_DESC, OPTION_CD, OPTION_DESC  
P00836        ORDER BY REVENUE_MONTH DESC, CODE_BILL_TYPE DESC          
WEBFIX                                         
P00836     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04622_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,APPL_RETURN_CODE                                                  
MFA-TR*      ,ACCOUNT_NO                                                        
MFA-TR*      ,AMT_BILL_ITEM                                                     
MFA-TR*      ,UTILITY_USG_AMT                                                   
MFA-TR*      ,AVG_COST_PER_USG                                                  
MFA-TR*      ,RATE_PLAN_NO                                                      
MFA-TR*      ,BTU_FACTOR                                                        
MFA-TR*      ,DATE_READ                                                         
MFA-TR*      ,PER_DAY_USE                                                       
MFA-TR*      ,NO_DAYS                                                           
MFA-TR*      ,ESTIMATE_ADJUSTED                                                 
MFA-TR*      ,CONSTANT                                                          
MFA-TR*      ,THERMS                                                            
MFA-TR*      ,UNITS                                                             
MFA-TR*      ,CNSMPTN_TYPE                                                      
MFA-TR*      ,ACTUAL_ONPEAK                                                     
MFA-TR*      ,BILLED_ONPEAK                                                     
MFA-TR*      ,ONPEAK_DIFF                                                       
MFA-TR*      ,ACTUAL_OFFPEAK                                                    
MFA-TR*      ,BILLED_OFFPEAK                                                    
MFA-TR*      ,OFFPEAK_DIFF                                                      
MFA-TR*      ,ACTUAL_SHLDR                                                      
MFA-TR*      ,BILLED_SHLDR                                                      
MFA-TR*      ,SHLDR_DIFF                                                        
MFA-TR*      ,COMBINED_READING                                                  
MFA-TR*      ,BILL_NO                                                           
MFA-TR*      ,BILL_ITEM_TMSTMP                                                  
MFA-TR*      ,WNA_AMOUNT                                                        
MFA-TR*      ,SAME_ACCOUNT                                                      
MFA-TR*      ,EMPLOYEE_NO                                                       
MFA-TR*      ,CODE_SOURCE_ID                                                    
MFA-TR*      ,DEGREE_DAYS                                                       
MFA-TR*      ,RATIO                                                             
MFA-TR*      ,COMPANY_NO                                                        
MFA-TR*      ,INDUS_GAS_RATE                                                    
MFA-TR*      ,WNA_FACTOR                                                        
MFA-TR*      ,METER_READING                                                     
MFA-TR*      ,REVENUE_MONTH                                                     
MFA-TR*      ,REV_MTH_ORIG_BILL                                                 
MFA-TR*      ,CNCLD_FLG                                                         
MFA-TR*      ,RATE_PLAN_DESC                                                    
MFA-TR*      ,OPTION_CD                                                         
MFA-TR*      ,OPTION_DESC                                                       
MFA-TR*      ,DATE_BILLED                                                       
MFA-TR*      )                                                                  
MFA-TR*      SELECT  RETURN_CODE                                                
MFA-TR*             ,APPL_RETURN_CODE                                           
MFA-TR*             ,ACCOUNT_NO                                                 
MFA-TR*             ,SUM(AMT_BILL_ITEM)                                         
MFA-TR*             ,SUM(UTILITY_USG_AMT)                                       
MFA-TR*             ,CASE WHEN (:PARM-CODE-UTIL-TYPE = 'E'                      
MFA-TR*                    AND   SUM(UNITS)  <> 0)                              
MFA-TR*                   THEN   SUM(UTILITY_USG_AMT)/SUM(UNITS)                
MFA-TR*                   WHEN (:PARM-CODE-UTIL-TYPE = 'G'                      
MFA-TR*                    AND   SUM(THERMS) <> 0)                              
MFA-TR*                   THEN   SUM(UTILITY_USG_AMT)/SUM(THERMS)               
MFA-TR*              ELSE 0 END                                                 
MFA-TR*             ,RATE_PLAN_NO                                               
MFA-TR*             ,0                                                          
MFA-TR*             ,MAX(DATE_READ)                                             
MFA-TR*             ,SUM(PER_DAY_USE)                                           
MFA-TR*             ,SUM(NO_DAYS)                                               
MFA-TR*             ,' '                                                        
MFA-TR*             ,0                                                          
MFA-TR*             ,SUM(THERMS)                                                
MFA-TR*             ,SUM(UNITS)                                                 
MFA-TR*             ,MAX(CNSMPTN_TYPE)                                          
MFA-TR*             ,0                                                          
MFA-TR*             ,0                                                          
MFA-TR*             ,0                                                          
MFA-TR*             ,0                                                          
MFA-TR*             ,0                                                          
MFA-TR*             ,0                                                          
MFA-TR*             ,0                                                          
MFA-TR*             ,0                                                          
MFA-TR*             ,0                                                          
MFA-TR*             ,' '                                                        
MFA-TR*             ,0                                                          
MFA-TR*             ,' '                                                        
MFA-TR*             ,0                                                          
MFA-TR*             ,' '                                                        
MFA-TR*             ,0                                                          
MFA-TR*             ,' '                                                        
MFA-TR*             ,0                                                          
MFA-TR*             ,0                                                          
MFA-TR*             ,COMPANY_NO                                                 
MFA-TR*             ,' '                                                        
MFA-TR*             ,0                                                          
MFA-TR*             ,0                                                          
MFA-TR*             ,REVENUE_MONTH                                              
MFA-TR*             ,0                                                          
MFA-TR*             ,' '                                                        
MFA-TR*             ,RATE_PLAN_DESC                                             
MFA-TR*             ,OPTION_CD                                                  
MFA-TR*             ,OPTION_DESC                                                
MFA-TR*             ,MAX(DATE_BILLED)                                           
MFA-TR*        FROM  SESSION.CSR04622_R4                                        
MFA-TR*       GROUP BY RETURN_CODE, APPL_RETURN_CODE, ACCOUNT_NO,               
MFA-TR*         RATE_PLAN_NO, COMPANY_NO, REVENUE_MONTH,                        
MFA-TR*         CODE_BILL_TYPE, RATE_PLAN_DESC, OPTION_CD, OPTION_DESC          
MFA-TR*       ORDER BY REVENUE_MONTH DESC, CODE_BILL_TYPE DESC                  
MFA-TR*       FETCH FIRST 100 ROWS ONLY                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00836*                                                                         
P00836     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
P00836*                                                                         
P00836     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00836        MOVE CTR-ROWS-RS4             TO CTR-ROWS-RS1             
P00836     ELSE                                                         
P00836        MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
P00836        MOVE SQLCODE                  TO ABEND-SQLCODE            
P00836        MOVE SQLSTATE                 TO ABEND-SQLSTATE           
P00836        MOVE '8200'                   TO ACTIVE-PARAGRAPH         
P00836        MOVE 'INSERT'                 TO ABEND-FUNCTION           
P00836        MOVE 'CSR04622_R1'            TO TABLE-1                  
P00836        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
P00836        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
P00836     END-IF.                                                      
P00836*                                                                         
P00836 8200-EXIT.                                                       
P00836      EXIT.                                                       
P00836                                                                  
      *****************************************************************         
      * 8800-CHECK-RESULTS.                                           *         
      *****************************************************************         
       8800-CHECK-RESULTS.                                              
                                                                        
           IF CTR-ROWS-RS1 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-1                            
              MOVE 100                       TO S1-RETURN-CODE          
              MOVE   0                       TO S1-APPL-RETURN-CODE     
              PERFORM 8010-INSERT-GTT-R1     THRU 8010-EXIT             
           END-IF.                                                      
      *                                                                         
           IF CTR-ROWS-RS2 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-2                            
              MOVE 100                       TO S2-RETURN-CODE          
              MOVE   0                       TO S2-APPL-RETURN-CODE     
              PERFORM 8020-INSERT-GTT-R2     THRU 8020-EXIT             
           END-IF.                                                      
      *                                                                         
           IF CTR-ROWS-RS3 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-3                            
              MOVE 100                       TO S3-RETURN-CODE          
              MOVE   0                       TO S3-APPL-RETURN-CODE     
              PERFORM 8030-INSERT-GTT-R3     THRU 8030-EXIT             
           END-IF.                                                      
      *                                                                         
       8800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8900-SEND-DONE.                                                *        
      ******************************************************************        
       8900-SEND-DONE.                                                  
                                                                        
           MOVE PROGRAM-NAME          TO ABEND-PROGRAM                  
           MOVE '8900'                TO ACTIVE-PARAGRAPH               
           MOVE 'OPEN'                TO ABEND-FUNCTION                 
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S1-RETURN-CODE.             
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE 'CSR04622_R1'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C2                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S2-RETURN-CODE.             
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE 'CSR04622_R2'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C3                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C3 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S3-RETURN-CODE.             
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE 'CSR04622_R3'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9000-SEND-ERROR-RESULT                                         *        
      ******************************************************************        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE       TO ABEND-SQLCODE            
                                               S1-RETURN-CODE           
                                               S2-RETURN-CODE           
                                               S3-RETURN-CODE.          
                                                                        
           MOVE WS-APPL-RETURN-CODE         TO S1-APPL-RETURN-CODE      
                                               S2-APPL-RETURN-CODE      
                                               S3-APPL-RETURN-CODE.     
                                                                        
           MOVE SQLERRMC                    TO ABEND-SQLERRMC.          
                                                                        
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'               TO ABEND-FUNCTION           
           END-IF.                                                      
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1        THRU 0100A-EXIT.         
           PERFORM 0100B-DECLARE-GTT-R2        THRU 0100B-EXIT.         
           PERFORM 0100C-DECLARE-GTT-R3        THRU 0100C-EXIT.         
                                                                        
           PERFORM 8010-INSERT-GTT-R1          THRU 8010-EXIT.          
           PERFORM 8020-INSERT-GTT-R2          THRU 8020-EXIT.          
           PERFORM 8030-INSERT-GTT-R3          THRU 8030-EXIT.          
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9700-ABEND-PROCESSING.                                         *        
      ******************************************************************        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT.             
           PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT.             
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900-SQL-ERROR-ROUTINE.                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9999-END-PROGRAM.                                              *        
      ******************************************************************        
                                                                        
       9999-END-PROGRAM.                                                
                                                                        
            PERFORM 8800-CHECK-RESULTS THRU 8800-EXIT                   
            PERFORM 8900-SEND-DONE     THRU 8900-EXIT                   
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
