       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04621.                                         
COB303 DATE-WRITTEN.     MARCH 22, 2013.                                
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      ******************************************************************        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      * THIS PROGRAM DETERMINES A RATE'S ENERGY AND DEMAND TIME-OF-USE *        
      * PERIODS, AND THE DEMAND TIME-OF-USE PERIOD'S UNITS.  IN        *        
      * ADDITION, THIS PROGRAM DETERMINES IF A RATE SUPPORTS LIFETIME  *        
      * PEAK DEMAND INFORMATION (FOR CSS_BILL_CONTRACT).ALSO DETERMINES*        
      * IF THE RATE IS A SECURED RATE.                                 *        
      * THIS PROCEDURE VALIDATES A SELECTED RATE PLAN WITH THE DIGITAL *        
      * METER TYPE AND PROGRAM ID OF THE PASSED IN METER PARAMETERS    *        
      * ON THE CSS_MTRD_ENVRNMT TABLE.  THE ACTUAL VALIDATION TAKES    *        
      * PLACE ON THE CSS_DMT_PGM_ID TABLE.                             *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  03/22/13   VV90387   INITIAL CODE                             *        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION, ABEND, MESSAGING MODULES            *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04621'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04621 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBDMDINS                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBRTCDEF                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBRTCRTR                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBRTDESC                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBMODEL                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMTRENV                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBDMTPI                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      * COMMON SYSTEM AREA                                                      
           COPY CCA00001.                                                       
      * ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS                          
           COPY CWS00027.                                                       
      * SUPPORTS DB2 AND SQL ERROR CHECKING                                     
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
           05  PROGRAM-NAME           PIC X(08) VALUE 'CSR04621'.       
           05  GWL-STATUS-SUBCODE     PIC S9(9) COMP.                   
                                                                        
       01  FILLER                     PIC X(11) VALUE 'PARM FIELDS'.    
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-L                 PIC S9(9) COMP.                   
           05  PARM-CODE-UTIL-TYPE    PIC X(01)      VALUE SPACES.      
           05  PARM-RATE-PLAN-NO      PIC X(03)      VALUE SPACES.      
           05  PARM-ACCOUNT-NO        PIC X(13).                        
           05  PARM-IC-NO             PIC X(04).                        
           05  PARM-MTR-REF-NO        PIC X(04).                        
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC               PIC S9(9) COMP.                   
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS               PIC S9(9) COMP VALUE 0.           
           05  WS-ROW-COUNT           PIC S9(9) COMP VALUE 0.           
           05  WS-RCVPRM              PIC X(20)      VALUE SPACES.      
                                                                        
       01  WS-MISC-FIELDS.                                              
           05  WS-CMPNT-ID-CD         PIC X(02)      VALUE '10'.        
           05  WS-ACTIVE-CODE         PIC X(01)      VALUE 'A'.         
           05  WS-IDR-TYPE            PIC X(01)      VALUE 'I'.         
           05  WS-YES                 PIC X(01)      VALUE 'Y'.         
           05  WS-NO                  PIC X(01)      VALUE 'N'.         
           05  WS-SECURED-RATE-FL     PIC X(01)      VALUE 'N'.         
           05  VALID-RATE-PLAN-NO     PIC X(01).                        
           05  WS-MAX-VERS-NO-CNTRL       PIC S9(4) USAGE COMP.         
           05  WS-MAX-VERS-NO-CNTRL-NULL  PIC S9(4) USAGE COMP.         
                                                                        
       01  WS-REDEFINITIONS.                                            
           05  WS-ACCOUNT              PIC X(13).                       
           05  WS-ACCOUNT-DEC REDEFINES WS-ACCOUNT                      
                                       PIC 9(13).                       
COB305     05 WS-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.        
                                                                        
           05  WS-IC-NO                PIC X(04).                       
           05  WS-IC-NO-DEC   REDEFINES WS-IC-NO                        
                                       PIC 9(04).                       
           05  WS-IC-NO-NO             PIC S9(04) COMP.                 
                                                                        
           05  WS-MTR-REF-NO           PIC X(04).                       
           05  WS-MTR-REF-NO-DEC REDEFINES WS-MTR-REF-NO                
                                       PIC 9(04).                       
           05  WS-MTR-REF-NO-NO        PIC S9(04) COMP.                 
       01  WORK-FIELDS.                                                 
           05  WRK-DONE-STATUS        PIC S9(9) COMP.                   
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE         PIC S9(9) COMP VALUE 0.           
           05  RS-ENERGY-TYPE-CD      PIC X(01)      VALUE SPACES.      
           05  RS-DEMAND-TYPE-CD      PIC X(01)      VALUE SPACES.      
           05  RS-DEMAND-TYPE-UNITS   PIC X(01)      VALUE SPACES.      
           05  RS-ENABLE-PEAK-IND     PIC X(01)      VALUE SPACES.      
           05  RS-SECURED-RATE-FL     PIC X(01)      VALUE SPACES.      
           05  RS-VALID-RATE          PIC X(01)      VALUE SPACES.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE          PIC S9(9) COMP VALUE 0.           
           05  S-ENERGY-TYPE-CD       PIC X(01)      VALUE SPACES.      
           05  S-DEMAND-TYPE-CD       PIC X(01)      VALUE SPACES.      
           05  S-DEMAND-TYPE-UNITS    PIC X(01)      VALUE SPACES.      
           05  S-ENABLE-PEAK-IND      PIC X(01)      VALUE SPACES.      
           05  S-SECURED-RATE-FL      PIC X(01)      VALUE SPACES.      
           05  S-VALID-RATE           PIC X(01)      VALUE SPACES.      
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
      ******************************************************************        
      *    CURSOR DECLARATIONS                                         *        
      ******************************************************************        
                                                                        
      *--- < NO CURSORS IN THIS PROCEDURE >                                     
                                                                        
HPCCDM*EJECT                                                                    
           EXEC SQL                                                     00000010
              INCLUDE CWSX0010                                          00000020
           END-EXEC.                                                    00000030
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
           10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
                                                                        
                                                                        
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-CODE-UTIL-TYPE      PIC X(01)                .          
       01  LINK-RATE-PLAN-NO        PIC X(03)                .          
       01  LINK-ACCOUNT-NO          PIC X(13)                .          
       01  LINK-IC-NO               PIC X(04)                .          
       01  LINK-MTR-REF-NO          PIC X(04)                .          
                                                                        
       PROCEDURE DIVISION USING   LINK-CODE-UTIL-TYPE                   
                                 ,LINK-RATE-PLAN-NO                     
                                 ,LINK-ACCOUNT-NO                       
                                 ,LINK-IC-NO                            
                                 ,LINK-MTR-REF-NO                       
                                 .                                      
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLWARNING                                      
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLERROR                                        
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER NOT FOUND                                       
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM.                     *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      *     CALLED BY: 0000-MAINLINE                                   *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'          TO ACTIVE-PARAGRAPH.                    
                                                                        
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT                                                   
                :S-RETURN-CODE               AS   RETURN_CODE           
               ,:S-ENERGY-TYPE-CD            AS   ENERGY_TYPE_CD        
               ,:S-DEMAND-TYPE-CD            AS   DEMAND_TYPE_CD        
               ,LTRIM(RTRIM(:S-DEMAND-TYPE-UNITS))  AS   
           DEMAND_TYPE_UNITS     
               ,:S-ENABLE-PEAK-IND           AS   ENABLE_PEAK_IND       
               ,:S-SECURED-RATE-FL           AS   SECURED_RATE_FL       
               ,:S-VALID-RATE                AS   VALID_RATE            
                  FROM CIS.SYSDUMMY1                                 
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT                                                           
MFA-TR*         :S-RETURN-CODE               AS   RETURN_CODE                   
MFA-TR*        ,:S-ENERGY-TYPE-CD            AS   ENERGY_TYPE_CD                
MFA-TR*        ,:S-DEMAND-TYPE-CD            AS   DEMAND_TYPE_CD                
MFA-TR*        ,STRIP(:S-DEMAND-TYPE-UNITS)  AS   DEMAND_TYPE_UNITS             
MFA-TR*        ,:S-ENABLE-PEAK-IND           AS   ENABLE_PEAK_IND               
MFA-TR*        ,:S-SECURED-RATE-FL           AS   SECURED_RATE_FL               
MFA-TR*        ,:S-VALID-RATE                AS   VALID_RATE                    
MFA-TR*           FROM SYSIBM.SYSDUMMY1                                         
MFA-TR*     END-EXEC.                                                           
            MOVE LINK-CODE-UTIL-TYPE       TO PARM-CODE-UTIL-TYPE.     .
            MOVE LINK-RATE-PLAN-NO         TO PARM-RATE-PLAN-NO        .
            MOVE LINK-ACCOUNT-NO           TO PARM-ACCOUNT-NO          .
            MOVE LINK-IC-NO                TO PARM-IC-NO               .
            MOVE LINK-MTR-REF-NO           TO PARM-MTR-REF-NO          .
            PERFORM 1150-ASSIGN-WS-VARS    THRU 1150-EXIT.              
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1150-ASSIGN-WS-VARS.                                           *        
      *      SET UP PARAMETERS TO BE RETURNED.                         *        
      *                                                                *        
      *      CALLED BY: 0000-MAINLINE                                  *        
      ******************************************************************        
       1150-ASSIGN-WS-VARS.                                             
      *                                                                         
           MOVE PARM-ACCOUNT-NO       TO WS-ACCOUNT.                    
           MOVE WS-ACCOUNT-DEC        TO WS-ACCOUNT-NO.                 
                                                                        
           MOVE PARM-IC-NO            TO WS-IC-NO.                      
           MOVE WS-IC-NO-DEC          TO WS-IC-NO-NO.                   
                                                                        
           MOVE PARM-MTR-REF-NO       TO WS-MTR-REF-NO.                 
           MOVE WS-MTR-REF-NO-DEC     TO WS-MTR-REF-NO-NO.              
      *                                                                         
       1150-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *      SET UP PARAMETERS TO BE RETURNED.                         *        
      *                                                                *        
      *      CALLED BY: 0000-MAINLINE                                  *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2200-BUILD-RESULT           THRU 2200-EXIT.          
           MOVE '2000'                         TO ACTIVE-PARAGRAPH.     
           PERFORM 2300-GET-METER-INFO         THRU 2300-EXIT.          
           PERFORM 2400-VALIDATE-RATE          THRU 2400-EXIT.          
           PERFORM 2000A-MOVE-RESULT           THRU 2000A-EXIT.         
           PERFORM 8100-SEND-RESULT            THRU 8100-EXIT.          
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000A-MOVE-RESULT.                                             *        
      ******************************************************************        
       2000A-MOVE-RESULT.                                               
           MOVE RS-RETURN-CODE             TO S-RETURN-CODE.            
           MOVE RS-ENERGY-TYPE-CD          TO S-ENERGY-TYPE-CD.         
           MOVE RS-DEMAND-TYPE-CD          TO S-DEMAND-TYPE-CD.         
           MOVE RS-DEMAND-TYPE-UNITS       TO S-DEMAND-TYPE-UNITS.      
           MOVE RS-ENABLE-PEAK-IND         TO S-ENABLE-PEAK-IND.        
           MOVE RS-SECURED-RATE-FL         TO S-SECURED-RATE-FL.        
           MOVE RS-VALID-RATE              TO S-VALID-RATE.             
       2000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2200-BUILD-RESULT                                              *        
      *     BUILD RESULT SET.                                          *        
      *                                                                *        
      *     CALLED BY:  2000-PROCESS-OUTPUT                            *        
      ******************************************************************        
       2200-BUILD-RESULT.                                               
                                                                        
           MOVE PARM-CODE-UTIL-TYPE      TO J1-CODE-UTIL-TYPE           
                                            RT-CODE-UTIL-TYPE           
                                            DI-CODE-UTIL-TYPE.          
           MOVE PARM-RATE-PLAN-NO        TO J1-RATE-PLAN-NO             
                                            RT-RATE-PLAN-NO             
                                            DI-RATE-PLAN-NO.            
           MOVE WS-CMPNT-ID-CD           TO J1-CMPNT-ID-CD              
                                            DI-CMPNT-ID-CD.             
           MOVE WS-ACTIVE-CODE           TO RT-CODE-STATUS.             
                                                                        
      *********************************************************                 
      * SELECT THE DEMAND AND ENERGY TIME-OF-USE CODES.       *                 
      * A NOT-FOUND CALL INDICATES THAT THE RATE IS IDR.      *                 
      *********************************************************                 
           PERFORM 2210-SELECT-MAX-VERS-NO THRU 2210-EXIT.              
           PERFORM 7000-SELECT-TOU-PERIODS THRU 7000-EXIT.              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE J1-REG-TYPE-CD        TO RS-ENERGY-TYPE-CD           
              MOVE J1-DEM-REG-TYPE-CD    TO RS-DEMAND-TYPE-CD           
              MOVE J1-DEM-UNIT-CD        TO RS-DEMAND-TYPE-UNITS        
           ELSE                                                         
              MOVE SUCCESSFUL-CALL       TO WS-ACTIVE-RETURN-CODE       
              MOVE WS-IDR-TYPE           TO RS-ENERGY-TYPE-CD           
              MOVE WS-IDR-TYPE           TO RS-DEMAND-TYPE-CD           
              MOVE SPACES                TO RS-DEMAND-TYPE-UNITS        
           END-IF.                                                      
                                                                        
      *********************************************************                 
      * BASED ON THE RATE, DETERMINE IF LIFETIME PEAK DEMAND  *                 
      * DETAILS ARE PERTINENT.                                *                 
      *********************************************************                 
           PERFORM 7100-SELECT-PEAK-IND        THRU 7100-EXIT.          
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              AND DI-LFTM-PEAK-PCT > 0                                  
              MOVE WS-YES                 TO RS-ENABLE-PEAK-IND         
           ELSE                                                         
              MOVE WS-NO                  TO RS-ENABLE-PEAK-IND         
              MOVE SUCCESSFUL-CALL        TO WS-ACTIVE-RETURN-CODE      
           END-IF.                                                      
                                                                        
           PERFORM 7200-SECURED-RATE           THRU 7200-EXIT.          
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE WS-YES                 TO RS-SECURED-RATE-FL         
           ELSE                                                         
              MOVE WS-NO                  TO RS-SECURED-RATE-FL         
              MOVE SUCCESSFUL-CALL        TO WS-ACTIVE-RETURN-CODE      
           END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2210-SELECT-MAX-VERS-NO.                                       *        
      *     SELECTS MAXIMUM VERSION CONTROL NO. FROM CSS_RATE_CERATOR  *        
      *                                                                *        
      *     CALLED BY:  2200-BUILD-RESULT                              *        
      ******************************************************************        
       2210-SELECT-MAX-VERS-NO.                                         
                                                                        
                                                                        
           EXEC SQL                                                     
              SELECT MAX(VERSION_NO_CNTRL)                              
               INTO :WS-MAX-VERS-NO-CNTRL :WS-MAX-VERS-NO-CNTRL-NULL     
               FROM  CSS_RATE_CREATOR                                   
              WHERE  CODE_UTIL_TYPE   = :J1-CODE-UTIL-TYPE              
                AND  RATE_PLAN_NO     = :J1-RATE-PLAN-NO                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '2210'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                              ABEND-TABLES              
              MOVE 'CSS_RATE_CREATOR'         TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE J1-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE J1-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       2210-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************16234000
      * 2300-GET-METER-INFO                                            *16240000
      *                                                                *16250000
      *  GET DIGITAL METER TYPE AND PROGRAM ID FOR THE METER.          *16260000
      *                                                                *16281000
      ******************************************************************16290000
       2300-GET-METER-INFO.                                             
      *                                                                 16310000
           EXEC SQL                                                     
              SELECT DIGTL_MTR_TYPE,                                    
                     PROGRAM_ID                                         
                INTO :MN-DIGTL-MTR-TYPE,                                
                     :MN-PROGRAM-ID                                     
                FROM CSS_MTRD_ENVRNMT                                   
               WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                        
                 AND CODE_UTIL_TYPE = :PARM-CODE-UTIL-TYPE              
                 AND IC_NO          = :WS-IC-NO-NO                      
                 AND MTR_REF_NO     = :WS-MTR-REF-NO-NO                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 16440000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE '2300'                    TO ACTIVE-PARAGRAPH       
               MOVE 'SELECT'                  TO ABEND-FUNCTION         
               MOVE 'CSS_MTRD_ENVRNMT'        TO TABLE-1                
               MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1        
               MOVE WS-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1      
               MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2        
               MOVE PARM-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2      
               MOVE 'IC_NO'                   TO TABLE-ELEMENT-3        
               MOVE WS-IC-NO-NO               TO HOSTVAR-ELEMENT-3      
               MOVE 'MTR_REF_NO'              TO TABLE-ELEMENT-4        
               MOVE WS-MTR-REF-NO-NO          TO HOSTVAR-ELEMENT-4      
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                 16590000
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16650000
      *                                                                 42239500
      ******************************************************************42239600
      * 2400-VALIDATE-RATE.                                            *42239700
      *                                                                *42239800
      *    VALIDATE THE RATE PLAN, CODE UTIL TYPE, DIGTL MTR TYPE AND  *42239900
      *    PROGRAM ID SEARCHING FOR A MATCHING ROW IN CSS_DMT_PGM_ID.  *42240000
      *                                                                *42240100
      ******************************************************************42240200
       2400-VALIDATE-RATE.                                              
      *                                                                 42240400
           MOVE 'N'                           TO VALID-RATE-PLAN-NO.    
                                                                        
           EXEC SQL                                                     
              SELECT 'Y'                                                
                INTO :VALID-RATE-PLAN-NO                                
                FROM CSS_DMT_PGM_ID                                     
               WHERE CODE_UTIL_TYPE = :PARM-CODE-UTIL-TYPE              
                 AND DIGTL_MTR_TYPE = :MN-DIGTL-MTR-TYPE                
                 AND PROGRAM_ID     = :MN-PROGRAM-ID                    
                 AND RATE_PLAN_NO   = :PARM-RATE-PLAN-NO                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 42241400
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE VALID-RATE-PLAN-NO      TO RS-VALID-RATE          
              ELSE                                                      
                 MOVE 'N'                     TO RS-VALID-RATE          
              END-IF                                                    
           ELSE                                                         
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE '2400'                    TO ACTIVE-PARAGRAPH       
               MOVE 'SELECT'                  TO ABEND-FUNCTION         
               MOVE 'CSS_DMT_PGM_ID'          TO TABLE-1                
               MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1        
               MOVE PARM-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-1      
               MOVE 'DIGTL_MTR_TYPE'          TO TABLE-ELEMENT-2        
               MOVE MN-DIGTL-MTR-TYPE         TO HOSTVAR-ELEMENT-2      
               MOVE 'PROGRAM_ID'              TO TABLE-ELEMENT-3        
               MOVE MN-PROGRAM-ID             TO HOSTVAR-ELEMENT-3      
               MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-4        
               MOVE PARM-RATE-PLAN-NO         TO HOSTVAR-ELEMENT-4      
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                 42243700
       2400-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 7000-SELECT-TOU-PERIODS.                                       *        
      *     DETERMINE THE ENERGY AND DEMAND TIME-OF-USE PERIODS,       *        
      *     AND THE DEMAND TIME-OF-USE PERIOD'S UNITS.                 *        
      *     A NOT-FOUND SQLCODE INDICATES THAT THE RATE IS IDR         *        
      *     (BECAUSE WE USED A COMPONENT ID CODE OF '10' IN THE WHERE  *        
      *     CLAUSE).                                                   *        
      *                                                                *        
      *     CALLED BY:  2200-BUILD-RESULT                              *        
      ******************************************************************        
       7000-SELECT-TOU-PERIODS.                                         
                                                                        
           EXEC SQL                                                     
              SELECT A.REG_TYPE_CD,                                     
                     A.DEM_REG_TYPE_CD,                                 
                     A.DEM_UNIT_CD                                      
               INTO  :J1-REG-TYPE-CD,                                   
                     :J1-DEM-REG-TYPE-CD,                               
                     :J1-DEM-UNIT-CD                                    
               FROM  CSS_RATE_COMP_DEF A                                
              WHERE  A.CODE_UTIL_TYPE     = :J1-CODE-UTIL-TYPE          
                AND  A.RATE_PLAN_NO       = :J1-RATE-PLAN-NO            
                AND  A.CMPNT_ID_CD        = :J1-CMPNT-ID-CD             
                AND  A.VERSION_NO_CNTRL   = :WS-MAX-VERS-NO-CNTRL       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7000'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                  ABEND-TABLES          
              MOVE 'CSS_RATE_COMP_DEF'        TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE J1-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE J1-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-2      
              MOVE 'CMPNT_ID_CD'              TO TABLE-ELEMENT-3        
              MOVE J1-CMPNT-ID-CD             TO HOSTVAR-ELEMENT-3      
              MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-4        
              MOVE WS-MAX-VERS-NO-CNTRL       TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7100-SELECT-PEAK-IND.                                          *        
      *     DETERMINE THE LFTM PEAK PERCENTAGE.  IF A RECORD IS NOT    *        
      *     FOUND OR THE PERCENTAGE = 0, THEN THE RATE DOES NOT        *        
      *     HAVE ANY LIFETIME PEAK OR DATE INFORMATION.                *        
      *                                                                *        
      *     CALLED BY:  2200-BUILD-RESULT                              *        
      ******************************************************************        
       7100-SELECT-PEAK-IND.                                            
                                                                        
           EXEC SQL                                                     
              SELECT A.LFTM_PEAK_PCT                                    
                INTO  :DI-LFTM-PEAK-PCT                                 
                FROM  CSS_DEMAND_INSTR A                                
               WHERE  A.CODE_UTIL_TYPE     = :DI-CODE-UTIL-TYPE         
                 AND  A.RATE_PLAN_NO       = :DI-RATE-PLAN-NO           
                 AND  A.CMPNT_ID_CD        = :DI-CMPNT-ID-CD            
                 AND  A.VERSION_NO_CNTRL   = :WS-MAX-VERS-NO-CNTRL      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                                   OR NOT-FOUND                         
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7100'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                  ABEND-TABLES          
              MOVE 'CSS_DEMAND_INSTR'         TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE DI-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE DI-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-2      
              MOVE 'CMPNT_ID_CD'              TO TABLE-ELEMENT-3        
              MOVE DI-CMPNT-ID-CD             TO HOSTVAR-ELEMENT-3      
              MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-4        
              MOVE WS-MAX-VERS-NO-CNTRL       TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT        
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7200-SECURED-RATE.                                             *        
      *     DETERMINE IF THE RATE IS A SECURED RATE.                   *        
      *                                                                *        
      *     CALLED BY:  2200-BUILD-RESULT                              *        
      ******************************************************************        
       7200-SECURED-RATE.                                               
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
              INTO  :RS-SECURED-RATE-FL                                 
              FROM CSS_RATE_PLAN_DESC RD,                               
                   CSS_UTIL_ENVRNMT UT                                  
              WHERE RD.RATE_PLAN_NO        = UT.RATE_PLAN_NO            
                    AND RD.CODE_UTIL_TYPE  = UT.CODE_UTIL_TYPE          
                    AND RD.COMPANY_NO      = UT.COMPANY_NO              
                    AND RD.SECURED_RATE_FL = 'Y'                        
                    AND UT.RATE_PLAN_NO    = :RT-RATE-PLAN-NO           
                                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*       INTO  :RS-SECURED-RATE-FL                                         
MFA-TR*       FROM CSS_RATE_PLAN_DESC RD,                                       
MFA-TR*            CSS_UTIL_ENVRNMT UT                                          
MFA-TR*       WHERE RD.RATE_PLAN_NO        = UT.RATE_PLAN_NO                    
MFA-TR*             AND RD.CODE_UTIL_TYPE  = UT.CODE_UTIL_TYPE                  
MFA-TR*             AND RD.COMPANY_NO      = UT.COMPANY_NO                      
MFA-TR*             AND RD.SECURED_RATE_FL = 'Y'                                
MFA-TR*             AND UT.RATE_PLAN_NO    = :RT-RATE-PLAN-NO                   
MFA-TR*       FETCH FIRST 1 ROW ONLY                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                                   OR NOT-FOUND                         
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7200'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                              ABEND-TABLES              
              MOVE 'CSS_UTIL_ENVRNMT'         TO TABLE-1                
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-1        
              MOVE RT-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
                                                                        
       8100-SEND-RESULT.                                                
             ADD 1 TO CTR-ROWS.                                         
       8100-EXIT.                                                       
              EXIT.                                                     
           EXEC SQL                                                           00
               INCLUDE CPD00321                                               00
           END-EXEC.                                                          00
